set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


# ../gen-gp.sh --title Benchmark runtime in s --ylabel s libstdc++-summary.txt tests 1 2
set ylabel "s"

set logscale y
set output "libstdc++-summary.txt-1-0.png"
set title "Benchmark runtime in s"
plot [:] [:] "libstdc++-summary.txt"  u 1:2 title "ofstream_insert_int.cc" w lp, \
	"" u 1:4 title "ifstream_getline.cc" w lp, \
	"" u 1:6 title "filebuf_sgetn_unbuf.cc" w lp, \
	"" u 1:8 title "filebuf_sgetn_unbuf.cc" w lp, \
	"" u 1:10 title "filebuf_sgetn_unbuf.cc" w lp, \
	"" u 1:12 title "fmtflags_manipulators.cc" w lp, \
	"" u 1:14 title "fmtflags_manipulators.cc" w lp, \
	"" u 1:16 title "ifstream_extract_float.cc" w lp, \
	"" u 1:18 title "ifstream_extract_float.cc" w lp, \
	"" u 1:20 title "ifstream_getline-2.cc" w lp, \
	"" u 1:22 title "ifstream_getline-2.cc" w lp, \
	"" u 1:24 title "ifstream_getline-2.cc" w lp, \
	"" u 1:26 title "stringbuf_overflow.cc" w lp, \
	"" u 1:28 title "stringbuf_overflow.cc" w lp, \
	"" u 1:30 title "stringbuf_overflow.cc" w lp, \
	"" u 1:32 title "stringbuf_overflow.cc" w lp, \
	"" u 1:34 title "cout_insert_int.cc" w lp, \
	"" u 1:36 title "filebuf_sputn_unbuf.cc" w lp, \
	"" u 1:38 title "filebuf_sputn_unbuf.cc" w lp, \
	"" u 1:40 title "filebuf_sputn_unbuf.cc" w lp, \
	"" u 1:42 title "fstream_seek_write.cc" w lp, \
	"" u 1:44 title "ifstream_extract_int.cc" w lp, \
	"" u 1:46 title "filebuf_sputc.cc" w lp, \
	"" u 1:48 title "filebuf_sputc.cc" w lp, \
	"" u 1:50 title "filebuf_sputc.cc" w lp, \
	"" u 1:52 title "ifstream_extract_chars.cc" w lp, \
	"" u 1:54 title "ifstream_extract_chars.cc" w lp, \
	"" u 1:56 title "filebuf_copy.cc" w lp, \
	"" u 1:58 title "filebuf_copy.cc" w lp, \
	"" u 1:60 title "ofstream_insert_float.cc" w lp, \
	"" u 1:62 title "ofstream_insert_float.cc" w lp, \
	"" u 1:64 title "wchar_t_length.cc" w lp
set output "libstdc++-summary.txt-1-1.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:66 title "narrow_widen_char.cc" w lp, \
	"" u 1:68 title "narrow_widen_char.cc" w lp, \
	"" u 1:70 title "narrow_widen_char.cc" w lp, \
	"" u 1:72 title "narrow_widen_char.cc" w lp, \
	"" u 1:74 title "wchar_t_in.cc" w lp, \
	"" u 1:76 title "wchar_t_in.cc" w lp, \
	"" u 1:78 title "narrow_widen_wchar_t.cc" w lp, \
	"" u 1:80 title "narrow_widen_wchar_t.cc" w lp, \
	"" u 1:82 title "narrow_widen_wchar_t.cc" w lp, \
	"" u 1:84 title "narrow_widen_wchar_t.cc" w lp, \
	"" u 1:86 title "is_wchar_t.cc" w lp, \
	"" u 1:88 title "is_wchar_t.cc" w lp, \
	"" u 1:90 title "wchar_t_out.cc" w lp, \
	"" u 1:92 title "wchar_t_out.cc" w lp, \
	"" u 1:94 title "search_n.cc" w lp, \
	"" u 1:96 title "search_n.cc" w lp, \
	"" u 1:98 title "string_append_2.cc" w lp, \
	"" u 1:100 title "string_find.cc" w lp, \
	"" u 1:102 title "string_find.cc" w lp, \
	"" u 1:104 title "string_find.cc" w lp, \
	"" u 1:106 title "string_find.cc" w lp, \
	"" u 1:108 title "string_find.cc" w lp, \
	"" u 1:110 title "string_find.cc" w lp, \
	"" u 1:112 title "string_find.cc" w lp, \
	"" u 1:114 title "string_append.cc" w lp, \
	"" u 1:116 title "string_append.cc" w lp, \
	"" u 1:118 title "string_append.cc" w lp, \
	"" u 1:120 title "string_append.cc" w lp, \
	"" u 1:122 title "string_append.cc" w lp, \
	"" u 1:124 title "string_append.cc" w lp, \
	"" u 1:126 title "string_cons_input_iterator.cc" w lp, \
	"" u 1:128 title "string_cons_input_iterator.cc" w lp
set output "libstdc++-summary.txt-1-2.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:130 title "string_cons_input_iterator.cc" w lp, \
	"" u 1:132 title "complex_norm.cc" w lp, \
	"" u 1:134 title "complex_norm.cc" w lp, \
	"" u 1:136 title "find-new" w lp, \
	"" u 1:138 title "find-malloc" w lp, \
	"" u 1:140 title "find-__mt" w lp, \
	"" u 1:142 title "find-bitmap" w lp, \
	"" u 1:144 title "find-__pool" w lp, \
	"" u 1:146 title "find-thread-new" w lp, \
	"" u 1:148 title "find-thread-malloc" w lp, \
	"" u 1:150 title "find-thread-__mt" w lp, \
	"" u 1:152 title "find-thread-bitmap" w lp, \
	"" u 1:154 title "find-thread-__pool" w lp, \
	"" u 1:156 title "producer_consumer_associative-thread-new" w lp, \
	"" u 1:158 title "producer_consumer_associative-thread-malloc" w lp, \
	"" u 1:160 title "producer_consumer_associative-thread-__mt" w lp, \
	"" u 1:162 title "producer_consumer_associative-thread-bitmap" w lp, \
	"" u 1:164 title "producer_consumer_associative-thread-__pool" w lp, \
	"" u 1:166 title "producer_consumer_associative-thread-new" w lp, \
	"" u 1:168 title "producer_consumer_associative-thread-malloc" w lp, \
	"" u 1:170 title "producer_consumer_associative-thread-__mt" w lp, \
	"" u 1:172 title "producer_consumer_associative-thread-bitmap" w lp, \
	"" u 1:174 title "producer_consumer_associative-thread-__pool" w lp, \
	"" u 1:176 title "producer_consumer_sequence-thread-new" w lp, \
	"" u 1:178 title "producer_consumer_sequence-thread-malloc" w lp, \
	"" u 1:180 title "producer_consumer_sequence-thread-__mt" w lp, \
	"" u 1:182 title "producer_consumer_sequence-thread-bitmap" w lp, \
	"" u 1:184 title "producer_consumer_sequence-thread-__pool" w lp, \
	"" u 1:186 title "producer_consumer_sequence-thread-new" w lp, \
	"" u 1:188 title "producer_consumer_sequence-thread-malloc" w lp, \
	"" u 1:190 title "producer_consumer_sequence-thread-__mt" w lp, \
	"" u 1:192 title "producer_consumer_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-1-3.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:194 title "producer_consumer_sequence-thread-__pool" w lp, \
	"" u 1:196 title "producer_consumer_sequence-thread-new" w lp, \
	"" u 1:198 title "producer_consumer_sequence-thread-malloc" w lp, \
	"" u 1:200 title "producer_consumer_sequence-thread-__mt" w lp, \
	"" u 1:202 title "producer_consumer_sequence-thread-bitmap" w lp, \
	"" u 1:204 title "producer_consumer_sequence-thread-__pool" w lp, \
	"" u 1:206 title "producer_consumer_sequence-thread-new" w lp, \
	"" u 1:208 title "producer_consumer_sequence-thread-malloc" w lp, \
	"" u 1:210 title "producer_consumer_sequence-thread-__mt" w lp, \
	"" u 1:212 title "producer_consumer_sequence-thread-bitmap" w lp, \
	"" u 1:214 title "producer_consumer_sequence-thread-__pool" w lp, \
	"" u 1:216 title "insert_erase_associative-new" w lp, \
	"" u 1:218 title "insert_erase_associative-malloc" w lp, \
	"" u 1:220 title "insert_erase_associative-__mt" w lp, \
	"" u 1:222 title "insert_erase_associative-bitmap" w lp, \
	"" u 1:224 title "insert_erase_associative-__pool" w lp, \
	"" u 1:226 title "insert_erase_associative-new" w lp, \
	"" u 1:228 title "insert_erase_associative-malloc" w lp, \
	"" u 1:230 title "insert_erase_associative-__mt" w lp, \
	"" u 1:232 title "insert_erase_associative-bitmap" w lp, \
	"" u 1:234 title "insert_erase_associative-__pool" w lp, \
	"" u 1:236 title "insert_erase_associative-new" w lp, \
	"" u 1:238 title "insert_erase_associative-malloc" w lp, \
	"" u 1:240 title "insert_erase_associative-__mt" w lp, \
	"" u 1:242 title "insert_erase_associative-bitmap" w lp, \
	"" u 1:244 title "insert_erase_associative-__pool" w lp, \
	"" u 1:246 title "insert_erase_associative-new" w lp, \
	"" u 1:248 title "insert_erase_associative-malloc" w lp, \
	"" u 1:250 title "insert_erase_associative-__mt" w lp, \
	"" u 1:252 title "insert_erase_associative-bitmap" w lp, \
	"" u 1:254 title "insert_erase_associative-__pool" w lp, \
	"" u 1:256 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-1-4.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:258 title "insert_erase_associative-malloc" w lp, \
	"" u 1:260 title "insert_erase_associative-__mt" w lp, \
	"" u 1:262 title "insert_erase_associative-bitmap" w lp, \
	"" u 1:264 title "insert_erase_associative-__pool" w lp, \
	"" u 1:266 title "insert_erase_associative-new" w lp, \
	"" u 1:268 title "insert_erase_associative-malloc" w lp, \
	"" u 1:270 title "insert_erase_associative-__mt" w lp, \
	"" u 1:272 title "insert_erase_associative-bitmap" w lp, \
	"" u 1:274 title "insert_erase_associative-__pool" w lp, \
	"" u 1:276 title "insert_erase_associative-thread-new" w lp, \
	"" u 1:278 title "insert_erase_associative-thread-malloc" w lp, \
	"" u 1:280 title "insert_erase_associative-thread-__mt" w lp, \
	"" u 1:282 title "insert_erase_associative-thread-bitmap" w lp, \
	"" u 1:284 title "insert_erase_associative-thread-__pool" w lp, \
	"" u 1:286 title "insert_erase_associative-thread-new" w lp, \
	"" u 1:288 title "insert_erase_associative-thread-malloc" w lp, \
	"" u 1:290 title "insert_erase_associative-thread-__mt" w lp, \
	"" u 1:292 title "insert_erase_associative-thread-bitmap" w lp, \
	"" u 1:294 title "insert_erase_associative-thread-__pool" w lp, \
	"" u 1:296 title "insert_erase_associative-thread-new" w lp, \
	"" u 1:298 title "insert_erase_associative-thread-malloc" w lp, \
	"" u 1:300 title "insert_erase_associative-thread-__mt" w lp, \
	"" u 1:302 title "insert_erase_associative-thread-bitmap" w lp, \
	"" u 1:304 title "insert_erase_associative-thread-__pool" w lp, \
	"" u 1:306 title "insert_erase_associative-thread-new" w lp, \
	"" u 1:308 title "insert_erase_associative-thread-malloc" w lp, \
	"" u 1:310 title "insert_erase_associative-thread-__mt" w lp, \
	"" u 1:312 title "insert_erase_associative-thread-bitmap" w lp, \
	"" u 1:314 title "insert_erase_associative-thread-__pool" w lp, \
	"" u 1:316 title "insert_erase_associative-thread-new" w lp, \
	"" u 1:318 title "insert_erase_associative-thread-malloc" w lp, \
	"" u 1:320 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-1-5.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:322 title "insert_erase_associative-thread-bitmap" w lp, \
	"" u 1:324 title "insert_erase_associative-thread-__pool" w lp, \
	"" u 1:326 title "insert_erase_associative-thread-new" w lp, \
	"" u 1:328 title "insert_erase_associative-thread-malloc" w lp, \
	"" u 1:330 title "insert_erase_associative-thread-__mt" w lp, \
	"" u 1:332 title "insert_erase_associative-thread-bitmap" w lp, \
	"" u 1:334 title "insert_erase_associative-thread-__pool" w lp, \
	"" u 1:336 title "insert_from_sorted-new" w lp, \
	"" u 1:338 title "insert_from_sorted-malloc" w lp, \
	"" u 1:340 title "insert_from_sorted-__mt" w lp, \
	"" u 1:342 title "insert_from_sorted-bitmap" w lp, \
	"" u 1:344 title "insert_from_sorted-__pool" w lp, \
	"" u 1:346 title "insert_from_sorted-thread-new" w lp, \
	"" u 1:348 title "insert_from_sorted-thread-malloc" w lp, \
	"" u 1:350 title "insert_from_sorted-thread-__mt" w lp, \
	"" u 1:352 title "insert_from_sorted-thread-bitmap" w lp, \
	"" u 1:354 title "insert_from_sorted-thread-__pool" w lp, \
	"" u 1:356 title "create_from_sorted-new" w lp, \
	"" u 1:358 title "create_from_sorted-malloc" w lp, \
	"" u 1:360 title "create_from_sorted-__mt" w lp, \
	"" u 1:362 title "create_from_sorted-bitmap" w lp, \
	"" u 1:364 title "create_from_sorted-__pool" w lp, \
	"" u 1:366 title "create_from_sorted-thread-new" w lp, \
	"" u 1:368 title "create_from_sorted-thread-malloc" w lp, \
	"" u 1:370 title "create_from_sorted-thread-__mt" w lp, \
	"" u 1:372 title "create_from_sorted-thread-bitmap" w lp, \
	"" u 1:374 title "create_from_sorted-thread-__pool" w lp, \
	"" u 1:376 title "index_associative-new" w lp, \
	"" u 1:378 title "index_associative-malloc" w lp, \
	"" u 1:380 title "index_associative-__mt" w lp, \
	"" u 1:382 title "index_associative-bitmap" w lp, \
	"" u 1:384 title "index_associative-__pool" w lp
set output "libstdc++-summary.txt-1-6.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:386 title "index_associative-thread-new" w lp, \
	"" u 1:388 title "index_associative-thread-malloc" w lp, \
	"" u 1:390 title "index_associative-thread-__mt" w lp, \
	"" u 1:392 title "index_associative-thread-bitmap" w lp, \
	"" u 1:394 title "index_associative-thread-__pool" w lp, \
	"" u 1:396 title "create-new" w lp, \
	"" u 1:398 title "create-malloc" w lp, \
	"" u 1:400 title "create-__mt" w lp, \
	"" u 1:402 title "create-bitmap" w lp, \
	"" u 1:404 title "create-__pool" w lp, \
	"" u 1:406 title "create-thread-new" w lp, \
	"" u 1:408 title "create-thread-malloc" w lp, \
	"" u 1:410 title "create-thread-__mt" w lp, \
	"" u 1:412 title "create-thread-bitmap" w lp, \
	"" u 1:414 title "create-thread-__pool" w lp, \
	"" u 1:416 title "insert_associative-new" w lp, \
	"" u 1:418 title "insert_associative-malloc" w lp, \
	"" u 1:420 title "insert_associative-__mt" w lp, \
	"" u 1:422 title "insert_associative-bitmap" w lp, \
	"" u 1:424 title "insert_associative-__pool" w lp, \
	"" u 1:426 title "insert_associative-new" w lp, \
	"" u 1:428 title "insert_associative-malloc" w lp, \
	"" u 1:430 title "insert_associative-__mt" w lp, \
	"" u 1:432 title "insert_associative-bitmap" w lp, \
	"" u 1:434 title "insert_associative-__pool" w lp, \
	"" u 1:436 title "insert_associative-new" w lp, \
	"" u 1:438 title "insert_associative-malloc" w lp, \
	"" u 1:440 title "insert_associative-__mt" w lp, \
	"" u 1:442 title "insert_associative-bitmap" w lp, \
	"" u 1:444 title "insert_associative-__pool" w lp, \
	"" u 1:446 title "insert_associative-new" w lp, \
	"" u 1:448 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-1-7.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:450 title "insert_associative-__mt" w lp, \
	"" u 1:452 title "insert_associative-bitmap" w lp, \
	"" u 1:454 title "insert_associative-__pool" w lp, \
	"" u 1:456 title "insert_associative-new" w lp, \
	"" u 1:458 title "insert_associative-malloc" w lp, \
	"" u 1:460 title "insert_associative-__mt" w lp, \
	"" u 1:462 title "insert_associative-bitmap" w lp, \
	"" u 1:464 title "insert_associative-__pool" w lp, \
	"" u 1:466 title "insert_associative-new" w lp, \
	"" u 1:468 title "insert_associative-malloc" w lp, \
	"" u 1:470 title "insert_associative-__mt" w lp, \
	"" u 1:472 title "insert_associative-bitmap" w lp, \
	"" u 1:474 title "insert_associative-__pool" w lp, \
	"" u 1:476 title "insert_associative-thread-new" w lp, \
	"" u 1:478 title "insert_associative-thread-malloc" w lp, \
	"" u 1:480 title "insert_associative-thread-__mt" w lp, \
	"" u 1:482 title "insert_associative-thread-bitmap" w lp, \
	"" u 1:484 title "insert_associative-thread-__pool" w lp, \
	"" u 1:486 title "insert_associative-thread-new" w lp, \
	"" u 1:488 title "insert_associative-thread-malloc" w lp, \
	"" u 1:490 title "insert_associative-thread-__mt" w lp, \
	"" u 1:492 title "insert_associative-thread-bitmap" w lp, \
	"" u 1:494 title "insert_associative-thread-__pool" w lp, \
	"" u 1:496 title "insert_associative-thread-new" w lp, \
	"" u 1:498 title "insert_associative-thread-malloc" w lp, \
	"" u 1:500 title "insert_associative-thread-__mt" w lp, \
	"" u 1:502 title "insert_associative-thread-bitmap" w lp, \
	"" u 1:504 title "insert_associative-thread-__pool" w lp, \
	"" u 1:506 title "insert_associative-thread-new" w lp, \
	"" u 1:508 title "insert_associative-thread-malloc" w lp, \
	"" u 1:510 title "insert_associative-thread-__mt" w lp, \
	"" u 1:512 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-1-8.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:514 title "insert_associative-thread-__pool" w lp, \
	"" u 1:516 title "insert_associative-thread-new" w lp, \
	"" u 1:518 title "insert_associative-thread-malloc" w lp, \
	"" u 1:520 title "insert_associative-thread-__mt" w lp, \
	"" u 1:522 title "insert_associative-thread-bitmap" w lp, \
	"" u 1:524 title "insert_associative-thread-__pool" w lp, \
	"" u 1:526 title "insert_associative-thread-new" w lp, \
	"" u 1:528 title "insert_associative-thread-malloc" w lp, \
	"" u 1:530 title "insert_associative-thread-__mt" w lp, \
	"" u 1:532 title "insert_associative-thread-bitmap" w lp, \
	"" u 1:534 title "insert_associative-thread-__pool" w lp, \
	"" u 1:536 title "insert_sequence-new" w lp, \
	"" u 1:538 title "insert_sequence-malloc" w lp, \
	"" u 1:540 title "insert_sequence-__mt" w lp, \
	"" u 1:542 title "insert_sequence-bitmap" w lp, \
	"" u 1:544 title "insert_sequence-__pool" w lp, \
	"" u 1:546 title "insert_sequence-new" w lp, \
	"" u 1:548 title "insert_sequence-malloc" w lp, \
	"" u 1:550 title "insert_sequence-__mt" w lp, \
	"" u 1:552 title "insert_sequence-bitmap" w lp, \
	"" u 1:554 title "insert_sequence-__pool" w lp, \
	"" u 1:556 title "insert_sequence-new" w lp, \
	"" u 1:558 title "insert_sequence-malloc" w lp, \
	"" u 1:560 title "insert_sequence-__mt" w lp, \
	"" u 1:562 title "insert_sequence-bitmap" w lp, \
	"" u 1:564 title "insert_sequence-__pool" w lp, \
	"" u 1:566 title "insert_sequence-new" w lp, \
	"" u 1:568 title "insert_sequence-malloc" w lp, \
	"" u 1:570 title "insert_sequence-__mt" w lp, \
	"" u 1:572 title "insert_sequence-bitmap" w lp, \
	"" u 1:574 title "insert_sequence-__pool" w lp, \
	"" u 1:576 title "insert_sequence-thread-new" w lp
set output "libstdc++-summary.txt-1-9.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:578 title "insert_sequence-thread-malloc" w lp, \
	"" u 1:580 title "insert_sequence-thread-__mt" w lp, \
	"" u 1:582 title "insert_sequence-thread-bitmap" w lp, \
	"" u 1:584 title "insert_sequence-thread-__pool" w lp, \
	"" u 1:586 title "insert_sequence-thread-new" w lp, \
	"" u 1:588 title "insert_sequence-thread-malloc" w lp, \
	"" u 1:590 title "insert_sequence-thread-__mt" w lp, \
	"" u 1:592 title "insert_sequence-thread-bitmap" w lp, \
	"" u 1:594 title "insert_sequence-thread-__pool" w lp, \
	"" u 1:596 title "insert_sequence-thread-new" w lp, \
	"" u 1:598 title "insert_sequence-thread-malloc" w lp, \
	"" u 1:600 title "insert_sequence-thread-__mt" w lp, \
	"" u 1:602 title "insert_sequence-thread-bitmap" w lp, \
	"" u 1:604 title "insert_sequence-thread-__pool" w lp, \
	"" u 1:606 title "insert_sequence-thread-new" w lp, \
	"" u 1:608 title "insert_sequence-thread-malloc" w lp, \
	"" u 1:610 title "insert_sequence-thread-__mt" w lp, \
	"" u 1:612 title "insert_sequence-thread-bitmap" w lp, \
	"" u 1:614 title "insert_sequence-thread-__pool" w lp, \
	"" u 1:616 title "sort_search-new" w lp, \
	"" u 1:618 title "sort_search-malloc" w lp, \
	"" u 1:620 title "sort_search-__mt" w lp, \
	"" u 1:622 title "sort_search-bitmap" w lp, \
	"" u 1:624 title "sort_search-__pool" w lp, \
	"" u 1:626 title "sort_search-thread-new" w lp, \
	"" u 1:628 title "sort_search-thread-malloc" w lp, \
	"" u 1:630 title "sort_search-thread-__mt" w lp, \
	"" u 1:632 title "sort_search-thread-bitmap" w lp, \
	"" u 1:634 title "sort_search-thread-__pool" w lp, \
	"" u 1:636 title "create_sort-new" w lp, \
	"" u 1:638 title "create_sort-malloc" w lp, \
	"" u 1:640 title "create_sort-__mt" w lp
set output "libstdc++-summary.txt-1-10.png"
plot [:] [:] "libstdc++-summary.txt"  u 1:642 title "create_sort-bitmap" w lp, \
	"" u 1:644 title "create_sort-__pool" w lp, \
	"" u 1:646 title "create_sort-thread-new" w lp, \
	"" u 1:648 title "create_sort-thread-malloc" w lp, \
	"" u 1:650 title "create_sort-thread-__mt" w lp, \
	"" u 1:652 title "create_sort-thread-bitmap" w lp, \
	"" u 1:654 title "create_sort-thread-__pool" w lp
set nologscale

set output "libstdc++-summary.txt-ofstream_insert_int.cc-2.png"
set title "Benchmark runtime in s for ofstream_insert_int.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:2 title "ofstream_insert_int.cc" w lp
set output "libstdc++-summary.txt-ifstream_getline.cc-4.png"
set title "Benchmark runtime in s for ifstream_getline.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:4 title "ifstream_getline.cc" w lp
set output "libstdc++-summary.txt-filebuf_sgetn_unbuf.cc-6.png"
set title "Benchmark runtime in s for filebuf_sgetn_unbuf.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:6 title "filebuf_sgetn_unbuf.cc" w lp
set output "libstdc++-summary.txt-filebuf_sgetn_unbuf.cc-8.png"
set title "Benchmark runtime in s for filebuf_sgetn_unbuf.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:8 title "filebuf_sgetn_unbuf.cc" w lp
set output "libstdc++-summary.txt-filebuf_sgetn_unbuf.cc-10.png"
set title "Benchmark runtime in s for filebuf_sgetn_unbuf.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:10 title "filebuf_sgetn_unbuf.cc" w lp
set output "libstdc++-summary.txt-fmtflags_manipulators.cc-12.png"
set title "Benchmark runtime in s for fmtflags_manipulators.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:12 title "fmtflags_manipulators.cc" w lp
set output "libstdc++-summary.txt-fmtflags_manipulators.cc-14.png"
set title "Benchmark runtime in s for fmtflags_manipulators.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:14 title "fmtflags_manipulators.cc" w lp
set output "libstdc++-summary.txt-ifstream_extract_float.cc-16.png"
set title "Benchmark runtime in s for ifstream_extract_float.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:16 title "ifstream_extract_float.cc" w lp
set output "libstdc++-summary.txt-ifstream_extract_float.cc-18.png"
set title "Benchmark runtime in s for ifstream_extract_float.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:18 title "ifstream_extract_float.cc" w lp
set output "libstdc++-summary.txt-ifstream_getline-2.cc-20.png"
set title "Benchmark runtime in s for ifstream_getline-2.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:20 title "ifstream_getline-2.cc" w lp
set output "libstdc++-summary.txt-ifstream_getline-2.cc-22.png"
set title "Benchmark runtime in s for ifstream_getline-2.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:22 title "ifstream_getline-2.cc" w lp
set output "libstdc++-summary.txt-ifstream_getline-2.cc-24.png"
set title "Benchmark runtime in s for ifstream_getline-2.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:24 title "ifstream_getline-2.cc" w lp
set output "libstdc++-summary.txt-stringbuf_overflow.cc-26.png"
set title "Benchmark runtime in s for stringbuf_overflow.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:26 title "stringbuf_overflow.cc" w lp
set output "libstdc++-summary.txt-stringbuf_overflow.cc-28.png"
set title "Benchmark runtime in s for stringbuf_overflow.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:28 title "stringbuf_overflow.cc" w lp
set output "libstdc++-summary.txt-stringbuf_overflow.cc-30.png"
set title "Benchmark runtime in s for stringbuf_overflow.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:30 title "stringbuf_overflow.cc" w lp
set output "libstdc++-summary.txt-stringbuf_overflow.cc-32.png"
set title "Benchmark runtime in s for stringbuf_overflow.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:32 title "stringbuf_overflow.cc" w lp
set output "libstdc++-summary.txt-cout_insert_int.cc-34.png"
set title "Benchmark runtime in s for cout_insert_int.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:34 title "cout_insert_int.cc" w lp
set output "libstdc++-summary.txt-filebuf_sputn_unbuf.cc-36.png"
set title "Benchmark runtime in s for filebuf_sputn_unbuf.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:36 title "filebuf_sputn_unbuf.cc" w lp
set output "libstdc++-summary.txt-filebuf_sputn_unbuf.cc-38.png"
set title "Benchmark runtime in s for filebuf_sputn_unbuf.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:38 title "filebuf_sputn_unbuf.cc" w lp
set output "libstdc++-summary.txt-filebuf_sputn_unbuf.cc-40.png"
set title "Benchmark runtime in s for filebuf_sputn_unbuf.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:40 title "filebuf_sputn_unbuf.cc" w lp
set output "libstdc++-summary.txt-fstream_seek_write.cc-42.png"
set title "Benchmark runtime in s for fstream_seek_write.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:42 title "fstream_seek_write.cc" w lp
set output "libstdc++-summary.txt-ifstream_extract_int.cc-44.png"
set title "Benchmark runtime in s for ifstream_extract_int.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:44 title "ifstream_extract_int.cc" w lp
set output "libstdc++-summary.txt-filebuf_sputc.cc-46.png"
set title "Benchmark runtime in s for filebuf_sputc.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:46 title "filebuf_sputc.cc" w lp
set output "libstdc++-summary.txt-filebuf_sputc.cc-48.png"
set title "Benchmark runtime in s for filebuf_sputc.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:48 title "filebuf_sputc.cc" w lp
set output "libstdc++-summary.txt-filebuf_sputc.cc-50.png"
set title "Benchmark runtime in s for filebuf_sputc.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:50 title "filebuf_sputc.cc" w lp
set output "libstdc++-summary.txt-ifstream_extract_chars.cc-52.png"
set title "Benchmark runtime in s for ifstream_extract_chars.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:52 title "ifstream_extract_chars.cc" w lp
set output "libstdc++-summary.txt-ifstream_extract_chars.cc-54.png"
set title "Benchmark runtime in s for ifstream_extract_chars.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:54 title "ifstream_extract_chars.cc" w lp
set output "libstdc++-summary.txt-filebuf_copy.cc-56.png"
set title "Benchmark runtime in s for filebuf_copy.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:56 title "filebuf_copy.cc" w lp
set output "libstdc++-summary.txt-filebuf_copy.cc-58.png"
set title "Benchmark runtime in s for filebuf_copy.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:58 title "filebuf_copy.cc" w lp
set output "libstdc++-summary.txt-ofstream_insert_float.cc-60.png"
set title "Benchmark runtime in s for ofstream_insert_float.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:60 title "ofstream_insert_float.cc" w lp
set output "libstdc++-summary.txt-ofstream_insert_float.cc-62.png"
set title "Benchmark runtime in s for ofstream_insert_float.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:62 title "ofstream_insert_float.cc" w lp
set output "libstdc++-summary.txt-wchar_t_length.cc-64.png"
set title "Benchmark runtime in s for wchar_t_length.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:64 title "wchar_t_length.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_char.cc-66.png"
set title "Benchmark runtime in s for narrow_widen_char.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:66 title "narrow_widen_char.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_char.cc-68.png"
set title "Benchmark runtime in s for narrow_widen_char.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:68 title "narrow_widen_char.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_char.cc-70.png"
set title "Benchmark runtime in s for narrow_widen_char.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:70 title "narrow_widen_char.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_char.cc-72.png"
set title "Benchmark runtime in s for narrow_widen_char.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:72 title "narrow_widen_char.cc" w lp
set output "libstdc++-summary.txt-wchar_t_in.cc-74.png"
set title "Benchmark runtime in s for wchar_t_in.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:74 title "wchar_t_in.cc" w lp
set output "libstdc++-summary.txt-wchar_t_in.cc-76.png"
set title "Benchmark runtime in s for wchar_t_in.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:76 title "wchar_t_in.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_wchar_t.cc-78.png"
set title "Benchmark runtime in s for narrow_widen_wchar_t.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:78 title "narrow_widen_wchar_t.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_wchar_t.cc-80.png"
set title "Benchmark runtime in s for narrow_widen_wchar_t.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:80 title "narrow_widen_wchar_t.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_wchar_t.cc-82.png"
set title "Benchmark runtime in s for narrow_widen_wchar_t.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:82 title "narrow_widen_wchar_t.cc" w lp
set output "libstdc++-summary.txt-narrow_widen_wchar_t.cc-84.png"
set title "Benchmark runtime in s for narrow_widen_wchar_t.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:84 title "narrow_widen_wchar_t.cc" w lp
set output "libstdc++-summary.txt-is_wchar_t.cc-86.png"
set title "Benchmark runtime in s for is_wchar_t.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:86 title "is_wchar_t.cc" w lp
set output "libstdc++-summary.txt-is_wchar_t.cc-88.png"
set title "Benchmark runtime in s for is_wchar_t.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:88 title "is_wchar_t.cc" w lp
set output "libstdc++-summary.txt-wchar_t_out.cc-90.png"
set title "Benchmark runtime in s for wchar_t_out.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:90 title "wchar_t_out.cc" w lp
set output "libstdc++-summary.txt-wchar_t_out.cc-92.png"
set title "Benchmark runtime in s for wchar_t_out.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:92 title "wchar_t_out.cc" w lp
set output "libstdc++-summary.txt-search_n.cc-94.png"
set title "Benchmark runtime in s for search_n.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:94 title "search_n.cc" w lp
set output "libstdc++-summary.txt-search_n.cc-96.png"
set title "Benchmark runtime in s for search_n.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:96 title "search_n.cc" w lp
set output "libstdc++-summary.txt-string_append_2.cc-98.png"
set title "Benchmark runtime in s for string_append_2.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:98 title "string_append_2.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-100.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:100 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-102.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:102 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-104.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:104 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-106.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:106 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-108.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:108 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-110.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:110 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_find.cc-112.png"
set title "Benchmark runtime in s for string_find.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:112 title "string_find.cc" w lp
set output "libstdc++-summary.txt-string_append.cc-114.png"
set title "Benchmark runtime in s for string_append.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:114 title "string_append.cc" w lp
set output "libstdc++-summary.txt-string_append.cc-116.png"
set title "Benchmark runtime in s for string_append.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:116 title "string_append.cc" w lp
set output "libstdc++-summary.txt-string_append.cc-118.png"
set title "Benchmark runtime in s for string_append.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:118 title "string_append.cc" w lp
set output "libstdc++-summary.txt-string_append.cc-120.png"
set title "Benchmark runtime in s for string_append.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:120 title "string_append.cc" w lp
set output "libstdc++-summary.txt-string_append.cc-122.png"
set title "Benchmark runtime in s for string_append.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:122 title "string_append.cc" w lp
set output "libstdc++-summary.txt-string_append.cc-124.png"
set title "Benchmark runtime in s for string_append.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:124 title "string_append.cc" w lp
set output "libstdc++-summary.txt-string_cons_input_iterator.cc-126.png"
set title "Benchmark runtime in s for string_cons_input_iterator.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:126 title "string_cons_input_iterator.cc" w lp
set output "libstdc++-summary.txt-string_cons_input_iterator.cc-128.png"
set title "Benchmark runtime in s for string_cons_input_iterator.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:128 title "string_cons_input_iterator.cc" w lp
set output "libstdc++-summary.txt-string_cons_input_iterator.cc-130.png"
set title "Benchmark runtime in s for string_cons_input_iterator.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:130 title "string_cons_input_iterator.cc" w lp
set output "libstdc++-summary.txt-complex_norm.cc-132.png"
set title "Benchmark runtime in s for complex_norm.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:132 title "complex_norm.cc" w lp
set output "libstdc++-summary.txt-complex_norm.cc-134.png"
set title "Benchmark runtime in s for complex_norm.cc"
plot [:] [:] "libstdc++-summary.txt" u 1:134 title "complex_norm.cc" w lp
set output "libstdc++-summary.txt-find-new-136.png"
set title "Benchmark runtime in s for find-new"
plot [:] [:] "libstdc++-summary.txt" u 1:136 title "find-new" w lp
set output "libstdc++-summary.txt-find-malloc-138.png"
set title "Benchmark runtime in s for find-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:138 title "find-malloc" w lp
set output "libstdc++-summary.txt-find-__mt-140.png"
set title "Benchmark runtime in s for find-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:140 title "find-__mt" w lp
set output "libstdc++-summary.txt-find-bitmap-142.png"
set title "Benchmark runtime in s for find-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:142 title "find-bitmap" w lp
set output "libstdc++-summary.txt-find-__pool-144.png"
set title "Benchmark runtime in s for find-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:144 title "find-__pool" w lp
set output "libstdc++-summary.txt-find-thread-new-146.png"
set title "Benchmark runtime in s for find-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:146 title "find-thread-new" w lp
set output "libstdc++-summary.txt-find-thread-malloc-148.png"
set title "Benchmark runtime in s for find-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:148 title "find-thread-malloc" w lp
set output "libstdc++-summary.txt-find-thread-__mt-150.png"
set title "Benchmark runtime in s for find-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:150 title "find-thread-__mt" w lp
set output "libstdc++-summary.txt-find-thread-bitmap-152.png"
set title "Benchmark runtime in s for find-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:152 title "find-thread-bitmap" w lp
set output "libstdc++-summary.txt-find-thread-__pool-154.png"
set title "Benchmark runtime in s for find-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:154 title "find-thread-__pool" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-new-156.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:156 title "producer_consumer_associative-thread-new" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-malloc-158.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:158 title "producer_consumer_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-__mt-160.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:160 title "producer_consumer_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-bitmap-162.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:162 title "producer_consumer_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-__pool-164.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:164 title "producer_consumer_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-new-166.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:166 title "producer_consumer_associative-thread-new" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-malloc-168.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:168 title "producer_consumer_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-__mt-170.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:170 title "producer_consumer_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-bitmap-172.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:172 title "producer_consumer_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-producer_consumer_associative-thread-__pool-174.png"
set title "Benchmark runtime in s for producer_consumer_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:174 title "producer_consumer_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-new-176.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:176 title "producer_consumer_sequence-thread-new" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-malloc-178.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:178 title "producer_consumer_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__mt-180.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:180 title "producer_consumer_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-bitmap-182.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:182 title "producer_consumer_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__pool-184.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:184 title "producer_consumer_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-new-186.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:186 title "producer_consumer_sequence-thread-new" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-malloc-188.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:188 title "producer_consumer_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__mt-190.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:190 title "producer_consumer_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-bitmap-192.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:192 title "producer_consumer_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__pool-194.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:194 title "producer_consumer_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-new-196.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:196 title "producer_consumer_sequence-thread-new" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-malloc-198.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:198 title "producer_consumer_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__mt-200.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:200 title "producer_consumer_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-bitmap-202.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:202 title "producer_consumer_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__pool-204.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:204 title "producer_consumer_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-new-206.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:206 title "producer_consumer_sequence-thread-new" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-malloc-208.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:208 title "producer_consumer_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__mt-210.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:210 title "producer_consumer_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-bitmap-212.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:212 title "producer_consumer_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-producer_consumer_sequence-thread-__pool-214.png"
set title "Benchmark runtime in s for producer_consumer_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:214 title "producer_consumer_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-new-216.png"
set title "Benchmark runtime in s for insert_erase_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:216 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-malloc-218.png"
set title "Benchmark runtime in s for insert_erase_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:218 title "insert_erase_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__mt-220.png"
set title "Benchmark runtime in s for insert_erase_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:220 title "insert_erase_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-bitmap-222.png"
set title "Benchmark runtime in s for insert_erase_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:222 title "insert_erase_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__pool-224.png"
set title "Benchmark runtime in s for insert_erase_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:224 title "insert_erase_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-new-226.png"
set title "Benchmark runtime in s for insert_erase_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:226 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-malloc-228.png"
set title "Benchmark runtime in s for insert_erase_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:228 title "insert_erase_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__mt-230.png"
set title "Benchmark runtime in s for insert_erase_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:230 title "insert_erase_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-bitmap-232.png"
set title "Benchmark runtime in s for insert_erase_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:232 title "insert_erase_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__pool-234.png"
set title "Benchmark runtime in s for insert_erase_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:234 title "insert_erase_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-new-236.png"
set title "Benchmark runtime in s for insert_erase_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:236 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-malloc-238.png"
set title "Benchmark runtime in s for insert_erase_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:238 title "insert_erase_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__mt-240.png"
set title "Benchmark runtime in s for insert_erase_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:240 title "insert_erase_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-bitmap-242.png"
set title "Benchmark runtime in s for insert_erase_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:242 title "insert_erase_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__pool-244.png"
set title "Benchmark runtime in s for insert_erase_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:244 title "insert_erase_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-new-246.png"
set title "Benchmark runtime in s for insert_erase_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:246 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-malloc-248.png"
set title "Benchmark runtime in s for insert_erase_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:248 title "insert_erase_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__mt-250.png"
set title "Benchmark runtime in s for insert_erase_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:250 title "insert_erase_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-bitmap-252.png"
set title "Benchmark runtime in s for insert_erase_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:252 title "insert_erase_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__pool-254.png"
set title "Benchmark runtime in s for insert_erase_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:254 title "insert_erase_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-new-256.png"
set title "Benchmark runtime in s for insert_erase_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:256 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-malloc-258.png"
set title "Benchmark runtime in s for insert_erase_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:258 title "insert_erase_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__mt-260.png"
set title "Benchmark runtime in s for insert_erase_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:260 title "insert_erase_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-bitmap-262.png"
set title "Benchmark runtime in s for insert_erase_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:262 title "insert_erase_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__pool-264.png"
set title "Benchmark runtime in s for insert_erase_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:264 title "insert_erase_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-new-266.png"
set title "Benchmark runtime in s for insert_erase_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:266 title "insert_erase_associative-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-malloc-268.png"
set title "Benchmark runtime in s for insert_erase_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:268 title "insert_erase_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__mt-270.png"
set title "Benchmark runtime in s for insert_erase_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:270 title "insert_erase_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-bitmap-272.png"
set title "Benchmark runtime in s for insert_erase_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:272 title "insert_erase_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-__pool-274.png"
set title "Benchmark runtime in s for insert_erase_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:274 title "insert_erase_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-new-276.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:276 title "insert_erase_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-malloc-278.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:278 title "insert_erase_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__mt-280.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:280 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-bitmap-282.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:282 title "insert_erase_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__pool-284.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:284 title "insert_erase_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-new-286.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:286 title "insert_erase_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-malloc-288.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:288 title "insert_erase_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__mt-290.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:290 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-bitmap-292.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:292 title "insert_erase_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__pool-294.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:294 title "insert_erase_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-new-296.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:296 title "insert_erase_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-malloc-298.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:298 title "insert_erase_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__mt-300.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:300 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-bitmap-302.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:302 title "insert_erase_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__pool-304.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:304 title "insert_erase_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-new-306.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:306 title "insert_erase_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-malloc-308.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:308 title "insert_erase_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__mt-310.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:310 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-bitmap-312.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:312 title "insert_erase_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__pool-314.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:314 title "insert_erase_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-new-316.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:316 title "insert_erase_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-malloc-318.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:318 title "insert_erase_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__mt-320.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:320 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-bitmap-322.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:322 title "insert_erase_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__pool-324.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:324 title "insert_erase_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-new-326.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:326 title "insert_erase_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-malloc-328.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:328 title "insert_erase_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__mt-330.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:330 title "insert_erase_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-bitmap-332.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:332 title "insert_erase_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_erase_associative-thread-__pool-334.png"
set title "Benchmark runtime in s for insert_erase_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:334 title "insert_erase_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_from_sorted-new-336.png"
set title "Benchmark runtime in s for insert_from_sorted-new"
plot [:] [:] "libstdc++-summary.txt" u 1:336 title "insert_from_sorted-new" w lp
set output "libstdc++-summary.txt-insert_from_sorted-malloc-338.png"
set title "Benchmark runtime in s for insert_from_sorted-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:338 title "insert_from_sorted-malloc" w lp
set output "libstdc++-summary.txt-insert_from_sorted-__mt-340.png"
set title "Benchmark runtime in s for insert_from_sorted-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:340 title "insert_from_sorted-__mt" w lp
set output "libstdc++-summary.txt-insert_from_sorted-bitmap-342.png"
set title "Benchmark runtime in s for insert_from_sorted-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:342 title "insert_from_sorted-bitmap" w lp
set output "libstdc++-summary.txt-insert_from_sorted-__pool-344.png"
set title "Benchmark runtime in s for insert_from_sorted-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:344 title "insert_from_sorted-__pool" w lp
set output "libstdc++-summary.txt-insert_from_sorted-thread-new-346.png"
set title "Benchmark runtime in s for insert_from_sorted-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:346 title "insert_from_sorted-thread-new" w lp
set output "libstdc++-summary.txt-insert_from_sorted-thread-malloc-348.png"
set title "Benchmark runtime in s for insert_from_sorted-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:348 title "insert_from_sorted-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_from_sorted-thread-__mt-350.png"
set title "Benchmark runtime in s for insert_from_sorted-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:350 title "insert_from_sorted-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_from_sorted-thread-bitmap-352.png"
set title "Benchmark runtime in s for insert_from_sorted-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:352 title "insert_from_sorted-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_from_sorted-thread-__pool-354.png"
set title "Benchmark runtime in s for insert_from_sorted-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:354 title "insert_from_sorted-thread-__pool" w lp
set output "libstdc++-summary.txt-create_from_sorted-new-356.png"
set title "Benchmark runtime in s for create_from_sorted-new"
plot [:] [:] "libstdc++-summary.txt" u 1:356 title "create_from_sorted-new" w lp
set output "libstdc++-summary.txt-create_from_sorted-malloc-358.png"
set title "Benchmark runtime in s for create_from_sorted-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:358 title "create_from_sorted-malloc" w lp
set output "libstdc++-summary.txt-create_from_sorted-__mt-360.png"
set title "Benchmark runtime in s for create_from_sorted-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:360 title "create_from_sorted-__mt" w lp
set output "libstdc++-summary.txt-create_from_sorted-bitmap-362.png"
set title "Benchmark runtime in s for create_from_sorted-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:362 title "create_from_sorted-bitmap" w lp
set output "libstdc++-summary.txt-create_from_sorted-__pool-364.png"
set title "Benchmark runtime in s for create_from_sorted-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:364 title "create_from_sorted-__pool" w lp
set output "libstdc++-summary.txt-create_from_sorted-thread-new-366.png"
set title "Benchmark runtime in s for create_from_sorted-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:366 title "create_from_sorted-thread-new" w lp
set output "libstdc++-summary.txt-create_from_sorted-thread-malloc-368.png"
set title "Benchmark runtime in s for create_from_sorted-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:368 title "create_from_sorted-thread-malloc" w lp
set output "libstdc++-summary.txt-create_from_sorted-thread-__mt-370.png"
set title "Benchmark runtime in s for create_from_sorted-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:370 title "create_from_sorted-thread-__mt" w lp
set output "libstdc++-summary.txt-create_from_sorted-thread-bitmap-372.png"
set title "Benchmark runtime in s for create_from_sorted-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:372 title "create_from_sorted-thread-bitmap" w lp
set output "libstdc++-summary.txt-create_from_sorted-thread-__pool-374.png"
set title "Benchmark runtime in s for create_from_sorted-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:374 title "create_from_sorted-thread-__pool" w lp
set output "libstdc++-summary.txt-index_associative-new-376.png"
set title "Benchmark runtime in s for index_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:376 title "index_associative-new" w lp
set output "libstdc++-summary.txt-index_associative-malloc-378.png"
set title "Benchmark runtime in s for index_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:378 title "index_associative-malloc" w lp
set output "libstdc++-summary.txt-index_associative-__mt-380.png"
set title "Benchmark runtime in s for index_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:380 title "index_associative-__mt" w lp
set output "libstdc++-summary.txt-index_associative-bitmap-382.png"
set title "Benchmark runtime in s for index_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:382 title "index_associative-bitmap" w lp
set output "libstdc++-summary.txt-index_associative-__pool-384.png"
set title "Benchmark runtime in s for index_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:384 title "index_associative-__pool" w lp
set output "libstdc++-summary.txt-index_associative-thread-new-386.png"
set title "Benchmark runtime in s for index_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:386 title "index_associative-thread-new" w lp
set output "libstdc++-summary.txt-index_associative-thread-malloc-388.png"
set title "Benchmark runtime in s for index_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:388 title "index_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-index_associative-thread-__mt-390.png"
set title "Benchmark runtime in s for index_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:390 title "index_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-index_associative-thread-bitmap-392.png"
set title "Benchmark runtime in s for index_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:392 title "index_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-index_associative-thread-__pool-394.png"
set title "Benchmark runtime in s for index_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:394 title "index_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-create-new-396.png"
set title "Benchmark runtime in s for create-new"
plot [:] [:] "libstdc++-summary.txt" u 1:396 title "create-new" w lp
set output "libstdc++-summary.txt-create-malloc-398.png"
set title "Benchmark runtime in s for create-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:398 title "create-malloc" w lp
set output "libstdc++-summary.txt-create-__mt-400.png"
set title "Benchmark runtime in s for create-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:400 title "create-__mt" w lp
set output "libstdc++-summary.txt-create-bitmap-402.png"
set title "Benchmark runtime in s for create-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:402 title "create-bitmap" w lp
set output "libstdc++-summary.txt-create-__pool-404.png"
set title "Benchmark runtime in s for create-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:404 title "create-__pool" w lp
set output "libstdc++-summary.txt-create-thread-new-406.png"
set title "Benchmark runtime in s for create-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:406 title "create-thread-new" w lp
set output "libstdc++-summary.txt-create-thread-malloc-408.png"
set title "Benchmark runtime in s for create-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:408 title "create-thread-malloc" w lp
set output "libstdc++-summary.txt-create-thread-__mt-410.png"
set title "Benchmark runtime in s for create-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:410 title "create-thread-__mt" w lp
set output "libstdc++-summary.txt-create-thread-bitmap-412.png"
set title "Benchmark runtime in s for create-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:412 title "create-thread-bitmap" w lp
set output "libstdc++-summary.txt-create-thread-__pool-414.png"
set title "Benchmark runtime in s for create-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:414 title "create-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-new-416.png"
set title "Benchmark runtime in s for insert_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:416 title "insert_associative-new" w lp
set output "libstdc++-summary.txt-insert_associative-malloc-418.png"
set title "Benchmark runtime in s for insert_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:418 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-__mt-420.png"
set title "Benchmark runtime in s for insert_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:420 title "insert_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-bitmap-422.png"
set title "Benchmark runtime in s for insert_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:422 title "insert_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-__pool-424.png"
set title "Benchmark runtime in s for insert_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:424 title "insert_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-new-426.png"
set title "Benchmark runtime in s for insert_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:426 title "insert_associative-new" w lp
set output "libstdc++-summary.txt-insert_associative-malloc-428.png"
set title "Benchmark runtime in s for insert_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:428 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-__mt-430.png"
set title "Benchmark runtime in s for insert_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:430 title "insert_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-bitmap-432.png"
set title "Benchmark runtime in s for insert_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:432 title "insert_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-__pool-434.png"
set title "Benchmark runtime in s for insert_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:434 title "insert_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-new-436.png"
set title "Benchmark runtime in s for insert_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:436 title "insert_associative-new" w lp
set output "libstdc++-summary.txt-insert_associative-malloc-438.png"
set title "Benchmark runtime in s for insert_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:438 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-__mt-440.png"
set title "Benchmark runtime in s for insert_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:440 title "insert_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-bitmap-442.png"
set title "Benchmark runtime in s for insert_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:442 title "insert_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-__pool-444.png"
set title "Benchmark runtime in s for insert_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:444 title "insert_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-new-446.png"
set title "Benchmark runtime in s for insert_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:446 title "insert_associative-new" w lp
set output "libstdc++-summary.txt-insert_associative-malloc-448.png"
set title "Benchmark runtime in s for insert_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:448 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-__mt-450.png"
set title "Benchmark runtime in s for insert_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:450 title "insert_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-bitmap-452.png"
set title "Benchmark runtime in s for insert_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:452 title "insert_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-__pool-454.png"
set title "Benchmark runtime in s for insert_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:454 title "insert_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-new-456.png"
set title "Benchmark runtime in s for insert_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:456 title "insert_associative-new" w lp
set output "libstdc++-summary.txt-insert_associative-malloc-458.png"
set title "Benchmark runtime in s for insert_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:458 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-__mt-460.png"
set title "Benchmark runtime in s for insert_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:460 title "insert_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-bitmap-462.png"
set title "Benchmark runtime in s for insert_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:462 title "insert_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-__pool-464.png"
set title "Benchmark runtime in s for insert_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:464 title "insert_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-new-466.png"
set title "Benchmark runtime in s for insert_associative-new"
plot [:] [:] "libstdc++-summary.txt" u 1:466 title "insert_associative-new" w lp
set output "libstdc++-summary.txt-insert_associative-malloc-468.png"
set title "Benchmark runtime in s for insert_associative-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:468 title "insert_associative-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-__mt-470.png"
set title "Benchmark runtime in s for insert_associative-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:470 title "insert_associative-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-bitmap-472.png"
set title "Benchmark runtime in s for insert_associative-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:472 title "insert_associative-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-__pool-474.png"
set title "Benchmark runtime in s for insert_associative-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:474 title "insert_associative-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-thread-new-476.png"
set title "Benchmark runtime in s for insert_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:476 title "insert_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_associative-thread-malloc-478.png"
set title "Benchmark runtime in s for insert_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:478 title "insert_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__mt-480.png"
set title "Benchmark runtime in s for insert_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:480 title "insert_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-thread-bitmap-482.png"
set title "Benchmark runtime in s for insert_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:482 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__pool-484.png"
set title "Benchmark runtime in s for insert_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:484 title "insert_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-thread-new-486.png"
set title "Benchmark runtime in s for insert_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:486 title "insert_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_associative-thread-malloc-488.png"
set title "Benchmark runtime in s for insert_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:488 title "insert_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__mt-490.png"
set title "Benchmark runtime in s for insert_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:490 title "insert_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-thread-bitmap-492.png"
set title "Benchmark runtime in s for insert_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:492 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__pool-494.png"
set title "Benchmark runtime in s for insert_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:494 title "insert_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-thread-new-496.png"
set title "Benchmark runtime in s for insert_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:496 title "insert_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_associative-thread-malloc-498.png"
set title "Benchmark runtime in s for insert_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:498 title "insert_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__mt-500.png"
set title "Benchmark runtime in s for insert_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:500 title "insert_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-thread-bitmap-502.png"
set title "Benchmark runtime in s for insert_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:502 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__pool-504.png"
set title "Benchmark runtime in s for insert_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:504 title "insert_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-thread-new-506.png"
set title "Benchmark runtime in s for insert_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:506 title "insert_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_associative-thread-malloc-508.png"
set title "Benchmark runtime in s for insert_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:508 title "insert_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__mt-510.png"
set title "Benchmark runtime in s for insert_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:510 title "insert_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-thread-bitmap-512.png"
set title "Benchmark runtime in s for insert_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:512 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__pool-514.png"
set title "Benchmark runtime in s for insert_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:514 title "insert_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-thread-new-516.png"
set title "Benchmark runtime in s for insert_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:516 title "insert_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_associative-thread-malloc-518.png"
set title "Benchmark runtime in s for insert_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:518 title "insert_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__mt-520.png"
set title "Benchmark runtime in s for insert_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:520 title "insert_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-thread-bitmap-522.png"
set title "Benchmark runtime in s for insert_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:522 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__pool-524.png"
set title "Benchmark runtime in s for insert_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:524 title "insert_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_associative-thread-new-526.png"
set title "Benchmark runtime in s for insert_associative-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:526 title "insert_associative-thread-new" w lp
set output "libstdc++-summary.txt-insert_associative-thread-malloc-528.png"
set title "Benchmark runtime in s for insert_associative-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:528 title "insert_associative-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__mt-530.png"
set title "Benchmark runtime in s for insert_associative-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:530 title "insert_associative-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_associative-thread-bitmap-532.png"
set title "Benchmark runtime in s for insert_associative-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:532 title "insert_associative-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_associative-thread-__pool-534.png"
set title "Benchmark runtime in s for insert_associative-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:534 title "insert_associative-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-new-536.png"
set title "Benchmark runtime in s for insert_sequence-new"
plot [:] [:] "libstdc++-summary.txt" u 1:536 title "insert_sequence-new" w lp
set output "libstdc++-summary.txt-insert_sequence-malloc-538.png"
set title "Benchmark runtime in s for insert_sequence-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:538 title "insert_sequence-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-__mt-540.png"
set title "Benchmark runtime in s for insert_sequence-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:540 title "insert_sequence-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-bitmap-542.png"
set title "Benchmark runtime in s for insert_sequence-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:542 title "insert_sequence-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-__pool-544.png"
set title "Benchmark runtime in s for insert_sequence-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:544 title "insert_sequence-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-new-546.png"
set title "Benchmark runtime in s for insert_sequence-new"
plot [:] [:] "libstdc++-summary.txt" u 1:546 title "insert_sequence-new" w lp
set output "libstdc++-summary.txt-insert_sequence-malloc-548.png"
set title "Benchmark runtime in s for insert_sequence-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:548 title "insert_sequence-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-__mt-550.png"
set title "Benchmark runtime in s for insert_sequence-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:550 title "insert_sequence-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-bitmap-552.png"
set title "Benchmark runtime in s for insert_sequence-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:552 title "insert_sequence-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-__pool-554.png"
set title "Benchmark runtime in s for insert_sequence-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:554 title "insert_sequence-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-new-556.png"
set title "Benchmark runtime in s for insert_sequence-new"
plot [:] [:] "libstdc++-summary.txt" u 1:556 title "insert_sequence-new" w lp
set output "libstdc++-summary.txt-insert_sequence-malloc-558.png"
set title "Benchmark runtime in s for insert_sequence-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:558 title "insert_sequence-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-__mt-560.png"
set title "Benchmark runtime in s for insert_sequence-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:560 title "insert_sequence-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-bitmap-562.png"
set title "Benchmark runtime in s for insert_sequence-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:562 title "insert_sequence-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-__pool-564.png"
set title "Benchmark runtime in s for insert_sequence-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:564 title "insert_sequence-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-new-566.png"
set title "Benchmark runtime in s for insert_sequence-new"
plot [:] [:] "libstdc++-summary.txt" u 1:566 title "insert_sequence-new" w lp
set output "libstdc++-summary.txt-insert_sequence-malloc-568.png"
set title "Benchmark runtime in s for insert_sequence-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:568 title "insert_sequence-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-__mt-570.png"
set title "Benchmark runtime in s for insert_sequence-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:570 title "insert_sequence-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-bitmap-572.png"
set title "Benchmark runtime in s for insert_sequence-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:572 title "insert_sequence-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-__pool-574.png"
set title "Benchmark runtime in s for insert_sequence-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:574 title "insert_sequence-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-new-576.png"
set title "Benchmark runtime in s for insert_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:576 title "insert_sequence-thread-new" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-malloc-578.png"
set title "Benchmark runtime in s for insert_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:578 title "insert_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__mt-580.png"
set title "Benchmark runtime in s for insert_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:580 title "insert_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-bitmap-582.png"
set title "Benchmark runtime in s for insert_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:582 title "insert_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__pool-584.png"
set title "Benchmark runtime in s for insert_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:584 title "insert_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-new-586.png"
set title "Benchmark runtime in s for insert_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:586 title "insert_sequence-thread-new" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-malloc-588.png"
set title "Benchmark runtime in s for insert_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:588 title "insert_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__mt-590.png"
set title "Benchmark runtime in s for insert_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:590 title "insert_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-bitmap-592.png"
set title "Benchmark runtime in s for insert_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:592 title "insert_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__pool-594.png"
set title "Benchmark runtime in s for insert_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:594 title "insert_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-new-596.png"
set title "Benchmark runtime in s for insert_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:596 title "insert_sequence-thread-new" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-malloc-598.png"
set title "Benchmark runtime in s for insert_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:598 title "insert_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__mt-600.png"
set title "Benchmark runtime in s for insert_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:600 title "insert_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-bitmap-602.png"
set title "Benchmark runtime in s for insert_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:602 title "insert_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__pool-604.png"
set title "Benchmark runtime in s for insert_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:604 title "insert_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-new-606.png"
set title "Benchmark runtime in s for insert_sequence-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:606 title "insert_sequence-thread-new" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-malloc-608.png"
set title "Benchmark runtime in s for insert_sequence-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:608 title "insert_sequence-thread-malloc" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__mt-610.png"
set title "Benchmark runtime in s for insert_sequence-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:610 title "insert_sequence-thread-__mt" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-bitmap-612.png"
set title "Benchmark runtime in s for insert_sequence-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:612 title "insert_sequence-thread-bitmap" w lp
set output "libstdc++-summary.txt-insert_sequence-thread-__pool-614.png"
set title "Benchmark runtime in s for insert_sequence-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:614 title "insert_sequence-thread-__pool" w lp
set output "libstdc++-summary.txt-sort_search-new-616.png"
set title "Benchmark runtime in s for sort_search-new"
plot [:] [:] "libstdc++-summary.txt" u 1:616 title "sort_search-new" w lp
set output "libstdc++-summary.txt-sort_search-malloc-618.png"
set title "Benchmark runtime in s for sort_search-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:618 title "sort_search-malloc" w lp
set output "libstdc++-summary.txt-sort_search-__mt-620.png"
set title "Benchmark runtime in s for sort_search-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:620 title "sort_search-__mt" w lp
set output "libstdc++-summary.txt-sort_search-bitmap-622.png"
set title "Benchmark runtime in s for sort_search-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:622 title "sort_search-bitmap" w lp
set output "libstdc++-summary.txt-sort_search-__pool-624.png"
set title "Benchmark runtime in s for sort_search-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:624 title "sort_search-__pool" w lp
set output "libstdc++-summary.txt-sort_search-thread-new-626.png"
set title "Benchmark runtime in s for sort_search-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:626 title "sort_search-thread-new" w lp
set output "libstdc++-summary.txt-sort_search-thread-malloc-628.png"
set title "Benchmark runtime in s for sort_search-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:628 title "sort_search-thread-malloc" w lp
set output "libstdc++-summary.txt-sort_search-thread-__mt-630.png"
set title "Benchmark runtime in s for sort_search-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:630 title "sort_search-thread-__mt" w lp
set output "libstdc++-summary.txt-sort_search-thread-bitmap-632.png"
set title "Benchmark runtime in s for sort_search-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:632 title "sort_search-thread-bitmap" w lp
set output "libstdc++-summary.txt-sort_search-thread-__pool-634.png"
set title "Benchmark runtime in s for sort_search-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:634 title "sort_search-thread-__pool" w lp
set output "libstdc++-summary.txt-create_sort-new-636.png"
set title "Benchmark runtime in s for create_sort-new"
plot [:] [:] "libstdc++-summary.txt" u 1:636 title "create_sort-new" w lp
set output "libstdc++-summary.txt-create_sort-malloc-638.png"
set title "Benchmark runtime in s for create_sort-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:638 title "create_sort-malloc" w lp
set output "libstdc++-summary.txt-create_sort-__mt-640.png"
set title "Benchmark runtime in s for create_sort-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:640 title "create_sort-__mt" w lp
set output "libstdc++-summary.txt-create_sort-bitmap-642.png"
set title "Benchmark runtime in s for create_sort-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:642 title "create_sort-bitmap" w lp
set output "libstdc++-summary.txt-create_sort-__pool-644.png"
set title "Benchmark runtime in s for create_sort-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:644 title "create_sort-__pool" w lp
set output "libstdc++-summary.txt-create_sort-thread-new-646.png"
set title "Benchmark runtime in s for create_sort-thread-new"
plot [:] [:] "libstdc++-summary.txt" u 1:646 title "create_sort-thread-new" w lp
set output "libstdc++-summary.txt-create_sort-thread-malloc-648.png"
set title "Benchmark runtime in s for create_sort-thread-malloc"
plot [:] [:] "libstdc++-summary.txt" u 1:648 title "create_sort-thread-malloc" w lp
set output "libstdc++-summary.txt-create_sort-thread-__mt-650.png"
set title "Benchmark runtime in s for create_sort-thread-__mt"
plot [:] [:] "libstdc++-summary.txt" u 1:650 title "create_sort-thread-__mt" w lp
set output "libstdc++-summary.txt-create_sort-thread-bitmap-652.png"
set title "Benchmark runtime in s for create_sort-thread-bitmap"
plot [:] [:] "libstdc++-summary.txt" u 1:652 title "create_sort-thread-bitmap" w lp
set output "libstdc++-summary.txt-create_sort-thread-__pool-654.png"
set title "Benchmark runtime in s for create_sort-thread-__pool"
plot [:] [:] "libstdc++-summary.txt" u 1:654 title "create_sort-thread-__pool" w lp
set output

