#!/bin/sh

# Usage: mico.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/mico-performance-`date +%y%m%d-%s`"

export LD_LIBRARY_PATH=$GCCINSTALLDIR/lib64:$GCCINSTALLDIR/lib:$LD_LIBRARY_PATH

cd $TMPDIR

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

# build
date 2>&1 | tee -a $LOGFILE
rm -Rf mico
tar xzf $BASEDIR/mico-2.3.12.tar.gz
cd mico
patch -p0 < $BASEDIR/mico.patch

export PATH=$GCCINSTALLDIR/bin:$PATH
CXX=c++ ./configure --disable-csiv2 --disable-shared
make -C admin
export PATH=$BASEDIR:$PATH
make -C orb 2>&1 | tee -a $LOGFILE | grep 'BENCHDATA'

cp $LOGFILE $LOGDIR/mico-performance-latest
