set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


set output "pdp++bench-summary-mem.png"
set title "pdp++benchmark program build time memory usage"
set ylabel "kB"
plot [:] [:] "pdp++bench-summary.txt" u 1:5 title "mainline" w lp, \
	39686 title "4.1.0" w l, \
	15701 title "icc-9.0" w l
set output

set output "pdp++bench-summary-time.png"
set title "pdp++benchmark program build time"
set ylabel "s"
plot [:] [:] "pdp++bench-summary.txt" u 1:6 title "mainline" w lp, \
	1.76 title "4.1.0" w l, \
	1.06 title "icc-9.0" w l
set output

set output "pdp++bench-summary-size.png"
set title "pdp++benchmark program text size"
set ylabel "bytes"
plot [:] [:] "pdp++bench-summary.txt" u 1:7 title "mainline" w lp
set output



# ../gen-gp.sh --title "benchmark runtime" --ylabel "s" pdp++bench-summary.txt tests 1 1
set ylabel "s"

set logscale y
set output "pdp++bench-summary.txt-1-0.png"
set title "benchmark runtime"
plot [:] [:] "pdp++bench-summary.txt"  u 1:2 title "t1" w lp, \
	"" u 1:3 title "t2" w lp, \
	"" u 1:4 title "t3" w lp
set nologscale

set output "pdp++bench-summary.txt-t1-2.png"
set title "benchmark runtime for t1"
plot [:] [:] "pdp++bench-summary.txt" u 1:2 title "t1" w lp
set output "pdp++bench-summary.txt-t2-3.png"
set title "benchmark runtime for t2"
plot [:] [:] "pdp++bench-summary.txt" u 1:3 title "t2" w lp
set output "pdp++bench-summary.txt-t3-4.png"
set title "benchmark runtime for t3"
plot [:] [:] "pdp++bench-summary.txt" u 1:4 title "t3" w lp
set output

