#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="pdp++bench-summary.txt"

echo -n "# DATE runtime-t1 runtime-t2 runtime-t2 build-mem build-time text-size" > $summary
echo >> $summary

for i in $LOGDIR/pdp++bench-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' |
 cat >> $summary
  cat $i | sed -ne 's/^\([0-9\.]\+\).*$/\1/p' | tr '\n' ' ' >> $summary
  cat $i | grep '^total:\|TIME:' | sed -e 's/^.*: \([0-9\.]*\).*$/\1/' | tr '\n' ' ' >> $summary;
  ( grep '^FILESIZE:' $i || echo "FILESIZE: a a a a a a 0" ) | cut -d ' ' -f 8 | tr '\n' ' ' | cat >> $summary
  echo >> $summary;
done

if test -f $BASEDIR/pdp++bench-summary.gp-`hostname`; then
  gnuplot $BASEDIR/pdp++bench-summary.gp-`hostname`
else
  gnuplot $BASEDIR/pdp++bench-summary.gp
fi
