#! /bin/sh

# Usage: raytracer.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/pdp++bench-performance-`date +%y%m%d-%s`"

export LANG=C

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

cd $TMPDIR

DEFINES="-DLINUX"
FLAGS=""
CC="$GCCINSTALLDIR/bin/g++ -O3 -fno-exceptions -fno-rtti -Wall"

$BASEDIR/../maxmem2.sh $CC $FLAGS $DEFINES -c $BASEDIR/pdp++base.cc $BASEDIR/pdp++bench.cc 2>&1 | tee -a $LOGFILE
/usr/bin/time -f "TIME: %U" $CC $FLAGS $DEFINES -c $BASEDIR/pdp++base.cc $BASEDIR/pdp++bench.cc 2>&1 | tee -a $LOGFILE
$CC $FLAGS $DEFINES -o pdp++bench pdp++base.o pdp++bench.o -lm 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./pdp++bench` 2>&1 | tee -a $LOGFILE

( ./pdp++bench 500 200
./pdp++bench 100 5000
./pdp++bench 10	500000 ) 2>&1 | tee -a $LOGFILE

cp $LOGFILE $LOGDIR/pdp++bench-performance-latest
