#!/bin/sh

# Usage: polyhedron-summary.sh BASEDIR LOGDIR TMPDIR

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary=polyhedron-summary.txt

echo "# compile avgrun compile avgrun ... " > $summary
for i in $LOGDIR/polyhedron-performance-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  cat $i | sed -e '/^Maximum Repeats/,/^Geometric Mean Execution Time/!d' | sed -e '/^[[:space:]]\+[acdfgilmnprt]/!d' | sed -e 's/[[:space:]]\+[acdfgilmnprt][^0-9]*\(.*\)$/\1/g' | tr -s ' ' | cut -d ' ' -f 1,3 | tr '\n' ' ' | cat >> $summary
  echo >> $summary
done

if test -f $BASEDIR/polyhedron-summary.gp-`hostname`; then
  gnuplot $BASEDIR/polyhedron-summary.gp-`hostname`
else
  gnuplot $BASEDIR/polyhedron-summary.gp
fi

