#!/bin/sh

# Usage: run BASEDIR GCCINSTALLDIR LOGDIR TMPDIR HTMLTARGETDIR

# only HTMLTARGETDIR is optional
if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"
HTMLTARGETDIR="$5"

# if there's appearantly no gcc, bail out immediately
if ! test -f "$GCCINSTALLDIR/bin/gcc"; then
  echo "c++bench: GCC did not build or install"
  exit 1
fi

LD_LIBRARY_PATH=$GCCINSTALLDIR/lib64:$GCCINSTALLDIR/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

run_in_subdir() {
  $BASEDIR/$1/$1.sh $BASEDIR/$1 $GCCINSTALLDIR $LOGDIR $TMPDIR
  if ! test -z "$HTMLTARGETDIR"; then
    mkdir -p $HTMLTARGETDIR/$1/
    mv $LOGDIR/$1-performance-latest $HTMLTARGETDIR/$1/
    $BASEDIR/$1/$1-summary.sh $BASEDIR/$1 $LOGDIR $TMPDIR
    mv $TMPDIR/$1*.png $HTMLTARGETDIR/$1/
    cp $TMPDIR/$1-summary.txt $HTMLTARGETDIR/$1/
  fi
}

# # tramp3d stuff -- fix script naming at some time
# $BASEDIR/tramp3d/monitor-tramp3d.sh $BASEDIR/tramp3d $GCCINSTALLDIR $LOGDIR $TMPDIR
# if ! test -z "$HTMLTARGETDIR"; then
#   $BASEDIR/tramp3d/monitor-tramp3d-summary.sh $BASEDIR/tramp3d $LOGDIR $TMPDIR
#   mv $TMPDIR/tramp3d-*.png $HTMLTARGETDIR/tramp3d/
#   cp $TMPDIR/tramp3d-summary.txt $HTMLTARGETDIR/tramp3d/
#   cp $LOGDIR/tramp3d-performance-latest $HTMLTARGETDIR/tramp3d/
# fi

# tramp3d
run_in_subdir tramp3d

# libstdc++
run_in_subdir libstdc++

# botan
run_in_subdir botan

# boost wave
run_in_subdir boost

# mico
run_in_subdir mico

# polyhedron
run_in_subdir polyhedron

# DLV
run_in_subdir DLV

# raytracer collection
run_in_subdir raytracer

# PDP++ Benchmark
run_in_subdir pdp++bench

# FreeFEM3D
run_in_subdir freefem
