#!/bin/sh

# Usage: $0 BASEDIR gcc-install logdir TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
INSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"
LOGFILE="$LOGDIR/tramp3d-performance-`date +%y%m%d-%s`"

uptime 2>&1 | tee $LOGFILE
echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee -a $LOGFILE
date 2>&1 | tee -a $LOGFILE
$INSTALLDIR/bin/g++ --version

TIME=/usr/bin/time

cd $TMPDIR

# leafify and non-leafify build, run and memory test
rm -f tramp3d-v4 tramp3d-v4.leafify tramp3d-v4.gcda tramp3d-v4.gcno
( $TIME -f "TIME: %U" $INSTALLDIR/bin/g++ -o tramp3d-v4 $BASEDIR/tramp3d-v4.cpp -static -O2 -funroll-loops -ffast-math -Dleafify=fooblah -ftime-report ) 2>&1 | tee -a $LOGFILE
( $TIME -f "TIME: %U" ./tramp3d-v4 -n 25 ) 2>&1 | tee -a $LOGFILE
( $TIME -f "TIME: %U" $INSTALLDIR/bin/g++ -o tramp3d-v4.leafify $BASEDIR/tramp3d-v4.cpp -static -O2 -funroll-loops -ffast-math -ftime-report -Dleafify=flatten ) 2>&1 | tee -a $LOGFILE
( $TIME -f "TIME: %U" ./tramp3d-v4.leafify -n 25 ) 2>&1 | tee -a $LOGFILE
( $BASEDIR/../maxmem2.sh $INSTALLDIR/bin/g++ -S $BASEDIR/tramp3d-v4.cpp -O2 -funroll-loops -ffast-math -Dleafify=fooblah -o /dev/null ) 2>&1 | tee -a $LOGFILE
( $BASEDIR/../maxmem2.sh $INSTALLDIR/bin/g++ -S $BASEDIR/tramp3d-v4.cpp -O2 -funroll-loops -ffast-math -Dleafify=flatten -o /dev/null ) 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./tramp3d-v4` 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./tramp3d-v4.leafify` 2>&1 | tee -a $LOGFILE

# FDO w/o leafify
rm -f tramp3d-v4.gcno tramp3d-v4.gcda tramp3d-v4.pg tramp3d-v4.pu
( $TIME -f "PTIME: %U" $INSTALLDIR/bin/g++ -o tramp3d-v4.pg $BASEDIR/tramp3d-v4.cpp -static -O2 -funroll-loops -ffast-math -fprofile-generate -Dleafify=fooblah -ftime-report ) 2>&1 | tee -a $LOGFILE
( $TIME -f "PTIME: %U" ./tramp3d-v4.pg -n 10 ) 2>&1 | tee -a $LOGFILE
( $TIME -f "PTIME: %U" $INSTALLDIR/bin/g++ -o tramp3d-v4.pu $BASEDIR/tramp3d-v4.cpp -static -O2 -funroll-loops -ffast-math -fprofile-use -Dleafify=fooblah -ftime-report ) 2>&1 | tee -a $LOGFILE
( $TIME -f "PTIME: %U" ./tramp3d-v4.pu -n 25 ) 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./tramp3d-v4.pg` 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./tramp3d-v4.pu` 2>&1 | tee -a $LOGFILE

date 2>&1 | tee -a $LOGFILE

cp $LOGFILE $LOGDIR/tramp3d-performance-latest
