!*==MAIN1.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
!   SPAG options set to convert source form only
!   Also redirected main output to screen to facilitate validation
!   (at line 4094)
      MODULE MAIN1
!***********************************************************************
!     MAIN1
!     AERMOD Model Data - Parameter, Variable and Array Declarations
!                         Global Data for All Modules
!
!***********************************************************************
 
      IMPLICIT NONE
 
! ----------------------------------------------------------------------
! --- ISC-PRIME Version 1.0
!
!     ISCST3 modified to accept additional building data required by
!     the PRIME building downwash modules
!
!     Changes are denoted in comment fields
!
!     Prepared by    Earth Tech, Inc
!     Prepared for   EPRI under contract WO3527-01
! ----------------------------------------------------------------------
 
!***********************************************************************
!     User Specified Model Parameters for Array Dimensions
!***********************************************************************
 
! --- Most array limits for data storage are now allocated at runtime.
      INTEGER , PARAMETER :: NSEC = 36 , NWSCAT = 6 , NKST = 6 ,        &
     &                       NHR = 24 , NPAIR = 100 , NWET = 2 ,        &
     &                       NHIANN = 10 , NMXPM = 10 , MXPLVL = 50 ,   &
     &                       MXGLVL = 87
 
!**   NSRC   = Max Number of Sources
!**   NREC   = Max Number of Receptors
!**   NGRP   = Max Number of Source Groups
!**   NAVE   = Max Number of Short Term Averaging Periods
!**   NVAL   = Max Number of High Values by Receptor (RECTABLE Keyword)
!**   NTYP   = Max Number of Output Types per Run (CONC, DEPOS, DDEP and WDEP)
!**   NMAX   = Max Number of Overall Maximum Values (MAXTABLE Keyword)
!**   NSEC   = Number of Sectors for Building Dimensions
!**   NQF    = Number of Variable Emission Rate Factors Per Source
!**   NPDMAX = Max Number of Particle Diameter Categories Per Source
!**   NWSCAT = Number of Wind Speed Categories
!**   NKST   = Number of Stability Categories
!**   IXM    = Max Number of X-coord (Distance) Values Per Receptor Network
!**   IYM    = Max Number of Y-coord (Direction) Values Per Receptor Network
!**   NNET   = Max Number of Cartesian and/or Polar Receptor Networks
!**   NHR    = Number of Hours in Met Data Loop
!**   NPAIR  = Number of Pairs of TXCONC and IDCONC for TOXXFILE Output
!**   NWET   = Number of phases of precipitation (2 = liquid,frozen)
!**   NHIANN = Number of high period/annual averages to include in
!**                the summary page of the output file (formerly controlled
!**                by NVAL)
!**   NMXPM  = Number of high average H4H 24-hour averages to include
!**                in the summary table for post-1997 PM10 processing
!**   MXPLVL = Maximum number of levels in the observed profile file
!**   MXGLVL = Maximum number of levels in the gridded profiles (0 - 4000 m)
!**   NARC   = Maximum number of Receptor Groupings ('ARCs') for EVALCART
 
 
!***********************************************************************
!     Model Constants Specified as Parameters
!***********************************************************************
 
!    &                   AT1PT2 = 1.2, FRACZI = 0.5, FRACSW = 0.05,
      REAL , PARAMETER :: PI = 3.141593 , TWOPI = 6.283185 ,            &
     &                    RTOFPI = 1.772454 , SRT2PI = 2.506628 ,       &
     &                    G = 9.80616 , VONKAR = 0.4 ,                  &
     &                    GOVRCP = 0.00977 , RTOF2 = 1.414214 ,         &
     &                    RTPIBY2 = 1.2533141 , DTORAD = 0.017453293 ,  &
     &                    RTODEG = 57.29578 , DCTODK = 273.16 ,         &
     &                    BETA1 = 0.6 , BETA2 = 0.4 , AT1PT2 = 1.2 ,    &
     &                    STABIY = 0.04 , STABIZ = 0.016 ,              &
     &                    UMINGR = 0.01 , GSIGV = 0.073864 ,            &
     &                    EFOLDH = 0.44 , SVUMIN = 0.05 , SVMIN = 0.2 , &
     &                    SWMIN = 0.02 , XVAL = 0.0 , TVAL = 0.01 ,     &
     &                    FFVAL = 0.0050 , SPTGMN = 0.002 ,             &
     &                    ALPHAF = 15.0 , ALPHA1 = 1.0 , BSUBC = 0.5 ,  &
     &                    SZEPS = 0.01 , SZCOEF = 2.15 , HTFACT = 1.0 , &
     &                    ALPHAR = 1.4 , LAMDAY = 2.3 , ASUBE = 0.1 ,   &
     &                    REFPOP = 2000000. , DELTRUR = 12.0 ,          &
     &                    CSUBD = 0.15 , RGAS = 8.3145
 
!**   PI     = PI
!**   TWOPI  = 2.*PI
!**   RTOFPI = SQRT(PI)
!**   SRT2PI = SQRT(2.*PI)
!**   RTPIBY2= SQRT(PI/2.)
!**   BETA1  = Coeff. in the calculation of 'direct' plume rise
!**   BETA2  = Coeff. in the calculation of buoyancy-induced dispersion
!**   G      = Acceleration Due to Gravity (m/s**2)
!**   DTORAD = Degrees to Radians Conversion Factor
!**   RTODEG = Radians to Degrees Conversion Factor
!**   AT1PT2 = The fraction of the mixed layer and above the mixed
!              layer through which a variable changes its value
!**   FRACZI = The fraction of the value at ZI a parameter has at
!**            1.2*ZI, where ZI is the boundary layer height.
!**   FRACSW = The fractional decrease of sigma_W at ZI
!**   STABIY = Stability F turbulence intensity, horizontal component
!**   STABIZ = Stability F turbulence intensity, vertical component
!**   UMINGR = Minimum value for a gridded wind speed
!**   GSIGV  = Constant used in converting sigma_A to sigma_V
!**   SVUMIN = Minimum value applied to Sigma_V / U when calculating
!**            Sigma_Y.
!**   SVMIN  = Minimum value applied to measured Sigma_V values
!**   SWMIN  = Minimum value applied to measured Sigma_W values
!**   DCTODK = Degrees Celsius to kelvin conversion factor
!**   VONKAR = von Karman constant
!**   GOVRCP = Gravity divided by specific heat at constant pressure
!**   RTOF2  = Square root of 2
!**   EFOLDH = Constant in computation of dTHETA/dZ in stable atmosphere
!**   XVAL   = Gradient in the miXing layer (unstable atmosphere)
!**   TVAL   = Gradient in the Transition layer (between ZI and 1.2*ZI)
!**   FFVAL  = Gradient in Free flow (above 1.2*ZI)
!**   SPTGMN = Minimum vert. potential temp. gradient for stable atmosphere
!**   ALPHAF = Constant in computation of Xm
!**   ALPHA1 = Constant used in computing sigma_Z for surface layer releases
!**   BSUBC  = Constant used in computing sigma_Z for surface layer releases
!**   SZEPS  = Convergence criterion for convergence of sigma-z in OPTD3
!**   SZCOEF = Coefficient of sigma-z to define the plume half-width in OPTD3
!**   HTFACT = Height factor (no longer used)
!**   ALPHAR = Parameter used in January 18, 1995 indirect source MCA
!**   LAMDAY = Parameter used in January 18, 1995 indirect source MCA
!**   ASUBE  = Parameter used in January 18, 1995 indirect source MCA
!**   REFPOP = Reference population for urban option (4/1/96 MCA)
!**   DELTRUR= Surface cooling in the rural area (4/1/96 MCA)
!**   RGAS   = ideal gas law constant = 8.3145 Pa-m^3/mol-K
!**
 
 
!***********************************************************************
!     Programmer Specified Model Parameters
!***********************************************************************
 
      INTEGER , PARAMETER :: IFMAX = 40 , IKN = 85 , ISTRG = 132 ,      &
     &                       IERRN = 170 , ILEN_FLD = 80
!*#
 
!**   IFMAX  = Max Number of Fields Per Runstream Record
!**   IPN    = Number of Pathway IDs (Includes '**')
!**   IKN    = Number of Keywords
!**   ISTRG  = Length of Runstream Image Record
!**   IERRN  = Number of Error/Warning/Informational Messages
!**   ILEN_FLD = Length of Runstream Input Fields.  Also used to
!**              specify length of input filenames and formats.
 
 
!***********************************************************************
!     Common Block for Input/Output File Units (Initialized in BLOCK DATA)
!***********************************************************************
 
      INTEGER :: INUNIT , IOUNIT , MFUNIT , MPUNIT , IERUNT , IERWRT ,  &
     &           IDPUNT , IDPUN2 , IRSUNT , IEVUNT , ITEVUT , IHREMI ,  &
     &           IZUNIT , INCUNT , DBGUNT , DBMUNT , ICVUNT , IO3UNT
 
!**   INUNIT = Input Runstream File Unit (Initialized to 7)
!**   IOUNIT = Main Printed Output File Unit (Initialized to 8)
!**   MFUNIT = Input Surface Met Data File Unit (Initialized to 19)
!**   MPUNIT = Input Profile Met Data File Unit (Initialized to 21)
!**   IERUNT = Temporary Error/Message File Unit (Initialized to 10)
!**   IERWRT = Permanent Detailed Error/Message File Unit (Init. to 11)
!**   IDPUNT = Main SAVEFILE Unit for Re-start Option (Init. to 12)
!**   IDPUN2 = Secondary SAVEFILE Unit for Re-start Option (Init. to 14)
!**   IRSUNT = INITFILE Unit for Re-start Option (Initialized to 15)
!**   IEVUNT = Event File Unit for Use With ISC2EV Model (Init. to 17)
!**   ITEVUT = Temporary Event File Used to Store High Value Events for
!**            Summary Tables and for EVENTFIL Option (Initialized to 18)
!**   IZUNIT = Gridded Terrain File Used (Initialized to 13)
!**   IHREMI = Hourly Emission Parameters File Unit (Init. to 16)
!**   INCUNT = INCLUDED File Unit (Initialized to 20)
!**   DBGUNT = Debug Output File for Calculations (Init. to 24)
!**   DBMUNT = Debug Output File for Meteorology Profiles (Init. to 25)
!**   ICVUNT = Cavity Concentration Output File (Initialized to 26)
!**   IO3UNT = Hourly Ozone Data File for PVMRM and OLM Options (Init. to 29)
!**   The following file units are declared below:
!**   ISUNIT = Surface Meteorology File for SCIM'd data (Initialized to 22)
!**   IPUNIT = Profile Meteorology File for SCIM'd data (Initialized to 23)
 
!***********************************************************************
!     This is The Global Variable Definition Block for Runstream Data
!***********************************************************************
 
      LOGICAL BLINE , INFLD , MARK , ECHO
 
      CHARACTER PATH*2 , PPATH*2 , KEYWRD*8 , PKEYWD*8 , KEYWD*8 ,      &
     &          KTYPE*5 , RUNST*1
 
      CHARACTER(LEN=ILEN_FLD) :: FIELD , INPFIL , OUTFIL , INCFIL
      CHARACTER(LEN=ISTRG) :: RUNST1
 
      INTEGER :: LOCB(IFMAX) , LOCE(IFMAX) , IFC , IDC1 , IPNUM , IPPNUM
      DIMENSION FIELD(IFMAX) , KEYWD(IKN) , RUNST(ISTRG)
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for Error Handling
!***********************************************************************
 
      LOGICAL FATAL , ISTART , IFINIS , RECERR , ERRLST , EOF
 
      CHARACTER ERRMSG*50 , ERRCOD*3 , VERSN*5
      CHARACTER(LEN=ILEN_FLD) :: MSGFIL
 
      DIMENSION ERRMSG(IERRN) , ERRCOD(IERRN)
      INTEGER :: ILINE , IERROR , IFTL , IWRN , INFO , ICLM , IMSG ,    &
     &           IHEZ , NFATAL , NWARN , IPAGE
      REAL :: EXPLIM
      INTEGER :: ICSTAT(30) , ISSTAT(30) , IRSTAT(30) , IMSTAT(30) ,    &
     &           IOSTAT(30) , ITSTAT(30) , IESTAT(30)
      INTEGER :: INCSET , IXYSET , IEVSET , IHLSET , IFGSET
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for COntrol Pathway
!***********************************************************************
 
      LOGICAL :: DFAULT , CONC , DEPOS , DDEP , WDEP , RURAL , URBAN ,  &
     &        GRDRIS , NOSTD , NOBID , CLMPRO , MSGPRO , PERIOD ,       &
     &        ANNUAL , MONTH , FLAT , ELEV , FLGPOL , RUN , EVENTS ,    &
     &        RSTSAV , RSTINP , DAYTAB , MXFILE , PPFILE , PLFILE ,     &
     &        ANPOST , ANPLOT , STATOK , FSTREC , MULTYR , TXFILE ,     &
     &        RKFILE , DDPLETE , WDPLETE , FSTCMP , EVONLY , SOCONT ,   &
     &        DETAIL , NEWMET , SEASONHR , ARDPLETE , DEBUG , METEOR ,  &
     &        NOCHKD , NOWARN , SCIM , WETSCIM , SCIMHR ,               &
     &        WETHR , FIRSTWET , TOXICS , SCREEN , URBSTAB ,            &
     &        PRM_FSTREC , O3FILE
!JRA 30 Sept 2005 - following variables were used without being defined
!                   this could lead to erroneous results 
!                   spotted by Salford FTN95 version 4.8.0
      LOGICAL ::  PM10AVE=.FALSE. , ROMBERG=.FALSE. , PVMRM=.FALSE. ,   &
     &            OLM=.FALSE.    
!*#
 
      CHARACTER ELTYPE*6 , TITLE1*68 , TITLE2*68 , EVPARM*6 , CHRAVE*5 ,&
     &          CHIDEP*4 , SOELEV*6 , REELEV*6 , TGELEV*6 , OUTTYP*5
 
      CHARACTER(LEN=ILEN_FLD) :: SAVFIL , SAVFL2 , INIFIL , EVFILE ,    &
     &                           DBGFIL , DBMFIL , URBNAM , OZONFL ,    &
     &                           O3FILUNITS , O3VALUNITS , O3FORM
 
      REAL :: O3CONC , O3BACK , NO2EQUIL
      LOGICAL :: O3MISS
 
      INTEGER :: NHIVAL , NMXVAL , NDUMP
      INTEGER :: NSRC , NREC , NGRP , NQF,                              &
     &           NPDMAX , NNET , IXM , IYM  , NUMEVE , IEVENT ,         &
     &           NARC , NOLM
!JRA 30 Sept 2005 - following variables were used without being defined
!                   this could lead to erroneous results 
!                   spotted by Salford FTN95 version 4.8.0
      INTEGER :: NAVE=0 , NVAL=0 , NTYP=0 , NMAX=0 , NEVE=0

      INTEGER , ALLOCATABLE :: KAVE(:)
 
      LOGICAL , ALLOCATABLE :: EVAL(:)
 
      ALLOCATABLE ::CHRAVE(:) , CHIDEP(:,:) , OUTTYP(:)
      CHARACTER(LEN=6) :: MODOPS(18)
 
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for SOurce Pathway
!***********************************************************************
 
      CHARACTER SRCID*8 , SRCTYP*8 , SOPCRD*1 , SOGAS*1 , URBSRC*1 ,    &
     &          GRPID*8 , EMILBL*40 , OUTLBL*40 , POLLUT*8 , PSOID*8 ,  &
     &          QFLAG*8 , PERLBL*40 , OLMID*8
 
      CHARACTER(LEN=ILEN_FLD) :: HRFILE
!*#
      CHARACTER PREVGRPID*8
 
      LOGICAL LDPART , LWPART , LDGAS , LWGAS
 
      REAL , ALLOCATABLE :: AXS(:) , AYS(:) , AZS(:) , AQS(:) , AHS(:) ,&
     &                      ATS(:) , AVS(:) , ADS(:) , ASYINI(:) ,      &
     &                      ASZINI(:) , ANO2_RATIO(:)
      REAL , ALLOCATABLE :: ADSBH(:,:) , ADSBW(:,:) , ADSBL(:,:) ,      &
     &                      ADSXADJ(:,:) , ADSYADJ(:,:)
 
      INTEGER , ALLOCATABLE :: INPD(:) , NDXSTK(:)
      REAL , ALLOCATABLE :: QFACT(:,:)
      REAL :: EMICON , HAFLIF , DECOEF , VAIRMS , ZRDEP , VDPHOR
      REAL , ALLOCATABLE :: EMIFAC(:) , APDIAM(:,:) , APHI(:,:) ,       &
     &                      APDENS(:,:) , AVGRAV(:,:) , ATSTOP(:,:)
 
!*----   ISCSTM Modification: allow for hourly emissions - jah 11/3/94
      REAL :: HRQS , HRTS , HRVS
      REAL , ALLOCATABLE :: EV_HRQS(:,:) , EV_HRTS(:,:) , EV_HRVS(:,:)
      INTEGER :: KURHRQ
!*----
!*#
 
      INTEGER , ALLOCATABLE :: IGROUP(:,:) , IGRP_OLM(:,:)
      ALLOCATABLE ::SRCID(:) , SRCTYP(:) , SOPCRD(:) , SOGAS(:) ,       &
     &            URBSRC(:) , GRPID(:) , QFLAG(:) , EMILBL(:) ,         &
     &            OUTLBL(:) , PERLBL(:) , OLMID(:)
      LOGICAL , ALLOCATABLE :: L_OLMGRP(:)
 
 
!**   NDXSTK  Index of the gridded height immediately below stack top
!**   KURHRQ  Date/Time Stamp for Hourly Emissions Data
!**   HRFILE  Hourly Emissions Data File Name
!*#
 
!***********************************************************************
!     This is The Global Variable Definition Block for the New Area
!     Source Algorithm - 7/7/93
!
!*    Added XVERT,YVERT - Jayant Hardikar, PES, 7/20/94
!***********************************************************************
 
      INTEGER , PARAMETER :: NVMAX = 24 , NVMAX2 = NVMAX*2
 
!**   NVMAX = Maximum Number of Vertices in a Single Area Source + 4
!**   NVMAX2= NVMAX * 2
!**   Note that the '+ 4' added to number of vertices for NVMAX refers
!**   to the maximum number of sides on an AREAPOLY source that a
!**   straight line can intersect.  For complex shapes, '+ 4' may not
!**   by large enough.  R. Brode, PES, Inc.
 
      LOGICAL LSEG
 
      INTEGER :: IVERT , NVERT , NSEGS
      REAL :: UVERT(NVMAX) , VVERT(NVMAX) , VNVERT(NVMAX) , WVERT(NVMAX)&
     &        , UASEGS(NVMAX) , UBSEGS(NVMAX) , XVERT(NVMAX) ,          &
     &        YVERT(NVMAX)
      REAL :: SPA(NVMAX,2)
      REAL , ALLOCATABLE :: AXINIT(:) , AYINIT(:) , AANGLE(:) ,         &
     &                      AXVERT(:,:) , AYVERT(:,:) , RADIUS(:) ,     &
     &                      AXCNTR(:) , AYCNTR(:)
      INTEGER , ALLOCATABLE :: NVERTS(:)
 
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for the New OPENPIT
!     Source Algorithm - 7/19/94
!***********************************************************************
 
      REAL , PARAMETER :: ALPHA = 0.029
      REAL , ALLOCATABLE :: AALPHA(:) , APDEFF(:) , AVOLUM(:)
      REAL , ALLOCATABLE :: EFRAC(:) , QPART(:)
      REAL :: PALPHA , THETA , PDEFF , PDREL , PITFRA , QEFF
      REAL :: PITLEN , PITWID , PITL , EMIHGT , XEFF , YEFF
 
 
!*    ALPHA     = Proportionality Constant for determining Escape Fraction
!*    AALPHA    = Array of Angles of Long Pit Dimension w.r.t.
!*                North for Each Source
!*    PALPHA    = Angle of Long Pit Dimension w.r.t. North for
!*                the Current Source
!*    THETA     = Wind Direction angle w.r.t Long Axis
!*                of the Pit
!*    APDEFF    = Array of Effective Pit Depths for Each Source
!*    PDEFF     = Effective Pit Depths for Current Source
!*    PDREL     = Relative Pit Depth
!*    AVOLUM    = Array of Volume of the OPENPIT Sources
!*    EFRAC     = Array of Escape Fractions
!*    QPART     = Array of Adjusted Emission Rates
!*    PITFRA    = Fractional Size of the Effective Pit Area
!*    PITLEN    = Length of the Pit
!*    PITWID    = Width of the Pit
!*    PITL      = Along-Wind Length of the Pit
!*    EMIHGT    = Height of Emissions Above Base of Pit
!*    XEFF      = X-dimension of Effective Pit
!*    YEFF      = Y-dimension of Effective Pit
 
 
 
!----------------------------------------------------------------------
! --- COMMON BLOCK /DRYGAS/ -- Dry deposition parameters        CALPUFF
!----------------------------------------------------------------------
!
      REAL , ALLOCATABLE :: PDIFF(:) , PDIFFW(:) , RMOLWT(:) , ALPHAS(:)&
     &                      , REACT(:) , HENRY(:) , RCLI(:) ,           &
     &                      FINEMASS(:) , SCF(:)
      LOGICAL , ALLOCATABLE :: L_METHOD2(:)
      INTEGER :: ISEAS_GD(12) , ILAND_GD(36) , NCLOUD
      REAL :: RM , RCUT , QSW , XLAI , VDEPG , USERVD , ZSUBP ,         &
     &        DELTA_Z , FO , FSEAS2 , FSEAS5 , FRACSAT , LIQCONT ,      &
     &        DENOM , XNU
 
      REAL :: WOLD , WNEW , F2 , ESTA
 
      CHARACTER*40 REFSPE
 
      LOGICAL LUSERVD
!
!     REFSPE      - Reference Species (Default is SO2)
!
! --- COMMON BLOCK /DRYGAS/ Variables:
!       PDIFF(NSRC) - real    - Molecular diffusivity (m**2/s)
!                               of each pollutant.
!                               SEE NOTE #1
!      PDIFFW(NSRC) - real    - Molecular diffusivity in water (m**2/s)
!                               of each pollutant.
!                               SEE NOTE #1
!      RMOLWT(NSRC) - real    - Molecular weight of pollutant (g/mol)
!                               of each pollutant.
!      ALPHAS(NSRC) - real    - Solubility enhancement factor due
!                               to the aqueous phase reactivity of
!                               the pollutant.
!       REACT(NSRC) - real    - Reactivity factor for each
!                               pollutant.
!                RM - real    - Mesophyll resistance (s/m)
!                               SEE NOTE #2
!       HENRY(NSRC) - real    - Henry's law constant (ratio of
!                               gas to aqueous phase concentration
!                               of the pollutant).
!              RCUT - real    - Cuticle resistance (s/m).
!
!  NOTE #1: Input units of this variable are cm**2/s.  Conversion to m**2/s
!           is made internally in the SETUP phase.
!
!  NOTE #2: Input units of s/cm are converted to s/m in the SETUP phase.
 
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for REceptor Pathway
!***********************************************************************
 
      LOGICAL ISTA , IEND , NEWID
 
      CHARACTER NETID*8 , NETIDT*8 , PNETID*8 , NTID*8 , NTTYP*8 ,      &
     &          RECTYP*2 , PXSOID*8 , PESOID*8 , ARCID*8
 
      REAL , ALLOCATABLE :: AXR(:) , AYR(:) , AZELEV(:) , AZFLAG(:) ,   &
     &                      AZHILL(:)
      INTEGER , ALLOCATABLE :: IREF(:) , NDXARC(:)
      ALLOCATABLE ::NETID(:) , RECTYP(:) , NTID(:) , NTTYP(:) , ARCID(:)
      INTEGER :: ICOUNT , JCOUNT , IZE , IZH , IZF , IRZE , IRZH ,      &
     &           IRZF , IRXR , IRYR , IRHZ , IBND , IBELEV , INNET
      REAL :: XINT , YINT
      REAL , ALLOCATABLE :: XCOORD(:,:) , YCOORD(:,:) , XORIG(:) ,      &
     &                      YORIG(:)
      INTEGER , ALLOCATABLE :: NETSTA(:) , NETEND(:) , NUMXPT(:) ,      &
     &                         NUMYPT(:)
 
!**  AZHILL Hill Height Associated with the Receptor
!**  HCRIT  Critical dividing streamline associated with the receptor
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for MEteorology Pathway
!***********************************************************************
 
      CHARACTER SFNAME*40 , UANAME*40 , ONNAME*40 , ALAT*10 , ALON*10
 
      CHARACTER(LEN=ILEN_FLD) :: METINP , SCIM_SFCFIL , SCIM_PROFIL ,   &
     &                           PROINP
      CHARACTER(LEN=105) :: METFRM , PROFRM
      LOGICAL SCIMOUT
 
!        RWB/MJ - allow for SCIM option - May, 1998.
      INTEGER :: ISDATE , IEDATE , ISYR , ISMN , ISDY , ISHR , IEYR ,   &
     &           IEMN , IEDY , IEHR , IPROC(366) , ISYEAR , IUYEAR ,    &
     &           IOYEAR , IDSURF , IDUAIR , IDSITE , ISJDAY , IEJDAY ,  &
     &           NDAYS , INCRST , ISTRT_CENT , ISTRT_WIND , NREGSTART , &
     &           NREGINT , IFIRSTHR , ISUNIT , IPUNIT , NSKIPTOT ,      &
     &           NSKIPWET , NSKIPDRY , NSWETCLM , NSDRYCLM , NSWETMSG , &
     &           NSDRYMSG , NWETHR , NWETINT , NWETSTART
 
      REAL :: UCAT(5) , ZREF , ROTANG , UMIN , VIRTPNT_URB(NKST) ,      &
     &        VIRTPNT_RUR(NKST) , VP_FACT
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for METEXT
!***********************************************************************
 
      LOGICAL CLMHR , MSGHR , UNSTAB , NEUTRL , STABLE , RUNERR ,       &
     &        PFLERR , NEWDAY , ENDMON , METHDR , HOURLY
 
      INTEGER :: KSTMSG
      INTEGER :: IHOUR , IYEAR , IMONTH , IDAY , KURDAT , ISEAS ,       &
     &           KHOUR , KYEAR , KMONTH , KDAY , KURPFL , NTOTHRS ,     &
     &           IPHOUR , IPDATE , IPCODE , KST , IYR , IDAY_OF_WEEK ,  &
     &           IDAY_OF_WEEK7 , NPLVLS , NTGLVL , IFLAG(MXPLVL)
!JRA 30 Sept 2005 - following variables were used without being defined
!                   this could lead to erroneous results 
!                   spotted by Salford FTN95 version 4.8.0
      INTEGER :: JDAY=0
      INTEGER :: FULLDATE
      REAL :: SFCHF , USTAR , WSTAR , VPTGZI , ZICONV , ZIMECH ,        &
     &        OBULEN , SFCZ0 , BOWEN , ALBEDO , UREF , WDREF , UREFHT , &
     &        TA , TREFHT , ZI , AFV , BVF , BVPRIM , XLAT , TSIGN ,    &
     &        ZIRUR , ZIURB , URBWSTR , URBPOP , PRATE , PREC1 , PREC2 ,&
     &        UREF10 , URBZ0 , URBUSTR , URBOBULEN , RURUSTR ,          &
     &        RUROBULEN , RH , SFCP
 
      INTEGER :: IKST(NHR) , IAPCODE(NHR) , NACLOUD(NHR)
      REAL :: APRATE(NHR) , AQSW(NHR) , ARH(NHR) , ASFCP(NHR)
      REAL :: ASFCHF(NHR) , AUREF(NHR) , AUREFHT(NHR) , ATA(NHR) ,      &
     &        ATREFHT(NHR) , AWDREF(NHR) , AUSTAR(NHR) , AWSTAR(NHR) ,  &
     &        AZICONV(NHR) , AZIMECH(NHR) , AOBULEN(NHR) , AVPTGZI(NHR) &
     &        , ASFCZ0(NHR) , ABOWEN(NHR) , AALBEDO(NHR) , AWNEW(NHR) , &
     &        AWOLD(NHR) , AESTA(NHR) , AF2(NHR) , APREC1(NHR) ,        &
     &        APREC2(NHR)
 
      INTEGER :: IENDHOUR , IENDDY , IENDMN , NUMYRS , NREMAIN , NDX4ZI
 
      REAL :: PFLHT(MXPLVL) , PFLWD(MXPLVL) , PFLWS(MXPLVL) ,           &
     &        PFLTA(MXPLVL) , PFLSA(MXPLVL) , PFLSW(MXPLVL) ,           &
     &        PFLSV(MXPLVL) , PFLTG(MXPLVL) , PFLTGZ(MXPLVL)
      REAL :: APFLHT(NHR,MXPLVL) , APFLWD(NHR,MXPLVL) ,                 &
     &        APFLWS(NHR,MXPLVL) , APFLTA(NHR,MXPLVL) ,                 &
     &        APFLSA(NHR,MXPLVL) , APFLSW(NHR,MXPLVL) ,                 &
     &        APFLSV(NHR,MXPLVL) , APFLTG(NHR,MXPLVL) ,                 &
     &        APFLTGZ(NHR,MXPLVL)
      INTEGER :: AIFLAG(NHR,MXPLVL) , ANPLVLS(NHR) , ANTGLVL(NHR)
!---  Add density profile for PRIME
!---  Add tubulence dissipation rate (epsilon) profile for PVMRM
      REAL :: GRIDHT(MXGLVL) , GRIDWD(MXGLVL) , GRIDWS(MXGLVL) ,        &
     &        GRIDSW(MXGLVL) , GRIDSV(MXGLVL) , GRIDTG(MXGLVL) ,        &
     &        GRIDPT(MXGLVL) , GRIDRHO(MXGLVL) , GRIDEPS(MXGLVL)
      REAL :: GRDSWU(MXGLVL) , GRDSVU(MXGLVL) , GRDTGU(MXGLVL) ,        &
     &        GRDSWR(MXGLVL) , GRDSVR(MXGLVL) , GRDTGR(MXGLVL) ,        &
     &        GRDPTU(MXGLVL) , GRDPTR(MXGLVL)
      REAL :: HNPREV , HDPREV , USPREV , HN , HTRANS , SFCLVL , TG4PFL ,&
     &        TG4XTR , THSTAR , SVAVG , SWAVG , UAVG , SVATZI , SWATZI ,&
     &        UATZI , PTATZI , UATHE , SVATHE , SWATHE , UAVH3 ,        &
     &        SVAVH3 , SWAVH3 , SWRMAX
 
!**   BVF    = Brunt-Vaisala frequency
!**   BVPRIM = 0.7*BVF
!**   SFCHF  = Surface heat flux (W/sq m)
!**   USTAR  = Surface friction velocity (m/s)
!**   WSTAR  = Convective scaling velocity (m/s)
!**   VPTGZI = Vertical potential temperature gradient from ZI to ZI+500
!**            (degrees/m)
!**   ZICONV = Hourly convective mixing height estimated by AERMET (m)
!**   ZIMECH = Hourly mechanical mixing height estimated by AERMET (m)
!**   OBULEN = Monin-Obukhov length (m)
!**   SFCZ0  = Surface roughness length (m)
!**   BOWEN  = Bowen ratio = sensible heat flux/latent heat flux
!**   ALBEDO = Albedo at the earth's surface (nondimensional)
!**   UREF   = Reference height wind speed (m/s)
!**   WDREF  = Reference height wind direction (degrees from north)
!**   UREFHT = Reference height for winds (m) (first nonmissing level
!**            of wind speed AND direction above 7.0*SFCZ0)
!**   TA     = Ambient temperature at a reference height (kelvin)
!**   TREFHT = Reference height for temperature (m) (first nonmissing
!**            level of temperature)
!**   ZI     = The mixing height used by AERMOD after any manipulation
!**            and massaging (m)
!**   NPLVLS = Number of levels in the observed hourly profile data
!**   NTGLVL = Number of levels of observed potential temperature gradient
!**   IFLAG  = Top of profile flag: 1 = top level, 0 = level below top
!**   PFLHT  = Profile height above local ground level (m)
!**   PFLWD  = Profile wind direction (degrees from north)
!**   PFLWS  = Profile wind speed (m/s)
!**   PFLTA  = Profile ambient temperature (kelvins)
!**   PFLSA  = Profile sigma_A (degrees)
!**   PFLSW  = Profile sigma_W (m/s)
!**   PFLSV  = Profile sigma_V (m/s), computed from sigma_A and wind speed
!**   PFLTG  = Profile of Vertical Potential Temperature Gradient (kelvin/m)
!**   PFLTGZ = Profile of VPTG heights (midpoint of interval) (m)
!**   GRIDHT = Gridded height (m)
!**   GRIDWD = Gridded wind direction (degrees from north)
!**   GRIDWS = Gridded wind speed (m/s)
!**   GRIDSW = Gridded sigma_W (m/s)
!**   GRIDSV = Gridded sigma_V (m/s)
!**   GRIDTG = Gridded vertical potential temperature gradient (deg/m)
!**   GRIDPT = Gridded potential temperature profile
!**   GRIDRHO= Gridded density profile
!**   GRIDEPS= Gridded tubulence dissipation rate (epsilon) profile for PVMRM
!**   HNPREV = Previous hour's computed smoothed PBL height (m)
!**   HDPREV = Previous hour's PBL height from AERMET (m)
!**   USPREV = Previous hour's friction velocity (m/s)
!**   HN     = Current hour's smoothed PBL height (m)
!**   HTRANS = PBL height at transition hour (heat flux from - to +) (m)
!**   SFCLVL = Level at which the theoretical temperature gradient
!**            profile is initialized
!**   TG4PFL = Potential temperature gradient at 2.0 meters
!**   TG4XTR = Potential temperature gradient at 100.0 meters
!**   XLAT   = Station latitude, decimal degrees
!**   TSIGN  = Sign used for turning of wind: 1.0 for northern hemis.
!**                                          -1.0 for southern hemis.
!**   NDX4ZI = Index of gridded height immediately below ZI
!**   SVAVG  = Average sigma_V from the surface to ZI (m/s)
!**   SWAVG  = Average sigma_W from the surface to ZI (m/s)
!**   UAVG   = Average wind speed from the surface to ZI (m/s)
!**   SVATZI = sigma_V at ZI (m/s)
!**   SWATZI = sigma_W at ZI (m/s)
!**   UATZI  = Wind speed at ZI (m)
!**   PTATZI = Potential temperature at ZI (kelvin)
!**   SVATHE = Average sigma_V from the surface to HS for HS > ZI (m/s)
!**   SWATHE = Average sigma_W from the surface to HS for HS > ZI (m/s)
!**   UATHE  = Average wind speed from the surface to HS for HS > ZI (m/s)
!**   SVAVH3 = Average sigma_V from the surface to HE3 for penetrated plume
!**   SWAVH3 = Average sigma_W from the surface to HE3 for penetrated plume
!**   UAVH3  = Average wind speed from the surface to HE3 for penetrated plume
!**   SWRMAX = Residual vertical turbulence, average of measured sigma-w
!**            above ZI or 0.02 * UATZI
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for Terrain Grid Pathway
!***********************************************************************
 
      CHARACTER(LEN=ILEN_FLD) :: TERINP
      LOGICAL LTGRID
 
      REAL :: TGX0 , TGY0 , GRDXLL , GRDXUR , GRDYLL , GRDYUR , XYINT
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for Calculation
!***********************************************************************
 
      LOGICAL CALCS , WAKE , WAKESS , BUOYNT , TALL , SQUAT , SSQUAT
      LOGICAL SURFAC
 
      DOUBLE PRECISION PHID1 , PHID2 , PHIN1 , PHIN2
 
      INTEGER :: IREC , ISRC , IGRP , IAVE , ITYP , ISET , NUMREC ,     &
     &           NUMSRC , NUMGRP , NUMAVE , NUMARC , NUMTYP , NUMYR ,   &
     &           ICYEAR , NUMURB , NPD , IFVSEC , IUCAT , IOLM ,        &
!JRA 30 Sept 2005 - following variables were used without being defined     
!                   this could lead to erroneous results 
!                   spotted by Salford FTN95 version 4.8.0
     &           NUMOLM=0
! --- PRIME Modification -------------------------------------------
! ------------------------------------------------------------------
      REAL :: XS , YS , ZS , QS , HS , DS , VS , TS , SYINIT , SZINIT , &
     &        XINIT , YINIT , ANGLE , XCNTR , YCNTR , DSBH , DSBW ,     &
     &        DSBL , XADJ , YADJ , B_SUBS , B_SUBL , RSCALE , D , VD ,  &
     &        E , WDRAD , WDSIN , WDCOS , ZBASE
 
!DEP      REAL, ALLOCATABLE :: V(:)
!DEPC                        Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
!DEP     &                    ,VDRY(:)
      REAL , ALLOCATABLE :: PDIAM(:) , PHI(:) , PDENS(:) , VGRAV(:) ,   &
     &                      TSTOP(:) , SCHMIDT(:) , VDEP(:) , WQCOR(:) ,&
     &                      DQCOR(:) , PSCVRT(:) , WASHOUT(:)
      REAL :: WQCORG , GSCVRT , DQCORG , WASHOUTG , VSETL
      REAL :: XR , YR , X , Y , ZELEV , ZFLAG , ZR , ZEFF , DISTR ,     &
     &        ZHILL , HCRIT , ZRT , XDIST
      REAL :: HE , HSP , HEFLAT , HTER , HEMWAK , HEDHH , ZB , ZM ,     &
     &        HED1 , HED2 , HEN1 , HEN2 , HE3 , HPEN , HED1M , HED2M ,  &
     &        HEN1M , HEN2M , HE3M , HSBL , QSUBN , QSUB3 , XY , XZ ,   &
     &        SBID , FM , FB , DTDZ , DHF , DHFAER , DHP , DHP1 , DHP2 ,&
     &        DHP3 , DELT , DHPB , DHPM , XF , XMAX , XFM , XFB , XRAD ,&
     &        WPB , DHCRIT , HTEFF , CENTER , Z4GAMMA , XTR4GAMMA
      REAL :: HESETL , HE3SETL , HV
      REAL :: US , SVS , SWS , TGS , TYS , PTS , UP , WDIR , DA , ZLY , &
     &        ZLB , RINIT , CB , CM , QTK , PPF , PSUBS , FHC , SY ,    &
     &        SYB , SYN , SY3 , SZ , SZUPR , SYAMB , SZAMB , SZAS ,     &
     &        SZAD1 , SZAD2 , SZAN1 , SZAN2 , SYAN , SZA3 , SZB , SZBD ,&
     &        SZBN , SZ3 , SZD1 , SZD2 , SZN1 , SZN2 , SZEFF , SZSURF , &
     &        SYA3 , SYB3 , SZB3 , VSY3 , VSIGY , VSIGZ , VSYN , VSZD1 ,&
     &        VSZD2 , VSZN1 , VSZN2 , VSZ3 , SZD1M , SZD2M , SZN1M ,    &
     &        SZN2M , SZ3M , U3 , SV3 , SW3 , TGP
      DOUBLE PRECISION :: FSUBY , FSUBYD , FSUBYN , FSUBY3
      REAL :: FSUBZ , FSUBZD , FSUBZN , FSUBZ3 , PHEE , FOPT , CWRAP ,  &
     &        CLIFT , XMDBG , CWRAPC , CLIFTC , FSUBYC , FSBY3C
      REAL :: UEFF , SVEFF , SWEFF , TGEFF , UEFFD , SVEFFD , SWEFFD ,  &
     &        UEFFN , SVEFFN , SWEFFN , UEFF3 , SVEFF3 , SWEFF3 ,       &
     &        TGEFF3 , EPSEFF , EPSEFFD , EPSEFF3 , XMIXED , XFINAL ,   &
     &        ZMIDMX
      REAL :: SKEW , R , ALPHPD , BETAPD , ASUB1 , ASUB2 , BSUB1 ,      &
     &        BSUB2 , LAMDA1 , LAMDA2
      REAL :: CHIW , CHIDW , CHINW , CHI3W , CHIL , CHIDL , CHINL ,     &
     &        CHI3L
      REAL :: GAMFACT
 
!**   AZSAVG = Average stack base elevation (m)
!**   ZBASE  = Base elevation used for potential temperature profile (m MSL)
!**   US     = Wind speed at stack height (m/s)
!**   UP     = Stack top wind speed for plume rise computations
!**   WDIR   = Stack top wind direction used for plume transport
!**   SVS    = sigma_V at stack height (m/s)
!**   SWS    = sigma_W at stack height (m/s)
!**   TGS    = Potential temperature gradient at stack top
!**   PTS    = Stack top potential temperature for plume rise
!**   xxEFF  = "effective" value for parameter xx
!**   FHC    = Function of Plume material above HCRIT
!**   PHEE   = "PHI" Term : Fraction of Plume Below Hcrit
!**   FSUBY  = Fy Term (Horizontal Gaussian term)
!**   FSUBYN = Fy Term (Horizontal Gaussian term) for the
!**            Indirect Source
!**   FSUBY3 = Fy Term (Horizontal Gaussian term) for the
!**            Penetrated Source
!**   HEDx   = Effective Source Heights for Direct Plume,
!**            x corresponding to each of the 2 distributions
!**   HENx   = Effective Source Heights for Indirect Plume,
!**            x corresponding to each of the 2 distributions
!**   HE3    = Effective Source Height for Penetrated Plume
!**   HEDxM  = Effective Source Heights for Direct Plume at Xm,
!**            x corresponding to each of the 2 distributions
!**   HENxM  = Effective Source Heights for Indirect Plume at Xm,
!**            x corresponding to each of the 2 distributions
!**   HE3M   = Effective Source Height for Penetrated Plume at Xm
 
!**   QSUBN  = Source Term for Indirect Source
!**   QSUB3  = Source Term for Penetrated Source
!**   SKEW   = Skewness of the Vertical Velocity
!**   R      = Lagrangian Correlation Coefficient
!**   ALPHPD = ALPHA Coefficient for the CBL PDF
!**   BETAPD = BETA  Coefficient for the CBL PDF
!**   ASUB1  =
!**   ASUB2  =
!**   BSUB1  =
!**   BSUB2  =
!**   LAMDA1 = Relative Frequencies of Updrafts
!**   LAMDA2 = Relative Frequencies of Downdrafts
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for EVent Pathway
!***********************************************************************
 
      CHARACTER EVNAME*8 , EVGRP*8
      INTEGER , ALLOCATABLE :: EVAPER(:) , EVDATE(:) , EVJDAY(:) ,      &
     &                         IDXEV(:)
 
      ALLOCATABLE ::EVNAME(:) , EVGRP(:)
 
 
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for OUtput Pathway
!***********************************************************************
 
      LOGICAL OUTPART
 
      LOGICAL , ALLOCATABLE :: ANPART(:) , ALLPARTS(:) , ALLPARTG(:)
 
      CHARACTER(LEN=ILEN_FLD) :: THRFIL , PSTFIL , PLTFIL , ANNPST ,    &
     &                           ANNPLT , THRFRM , PSTFRM , PLTFRM ,    &
     &                           TOXFIL , SEAHRS , RNKFIL , RNKFRM ,    &
     &                           EVLFIL , ANNPART
 
      INTEGER , ALLOCATABLE :: NHIAVE(:,:) , MAXAVE(:) , IMXVAL(:) ,    &
     &                         IDYTAB(:) , MAXFLE(:,:) , IPSTFL(:,:) ,  &
     &                         IPLTFL(:,:,:) , IANPST(:) , IANPLT(:) ,  &
     &                         INHI(:) , ITOXFL(:) , ISEAHR(:) ,        &
     &                         IRNKFL(:) , IRKVAL(:) , IANPART(:)
      REAL , ALLOCATABLE :: THRESH(:,:) , TOXTHR(:)
      INTEGER , ALLOCATABLE :: IMXUNT(:,:) , IPSUNT(:,:) , IPSFRM(:,:) ,&
     &                         IPLUNT(:,:,:) , IAPUNT(:) , IANFRM(:) ,  &
     &                         IPPUNT(:) , ITXUNT(:) , ISHUNT(:) ,      &
     &                         IRKUNT(:) , IELUNT(:) , IUPART(:)
 
      ALLOCATABLE ::THRFIL(:,:) , PSTFIL(:,:) , PLTFIL(:,:,:) ,         &
     &            ANNPST(:) , ANNPLT(:) , TOXFIL(:) , SEAHRS(:) ,       &
     &            RNKFIL(:) , EVLFIL(:) , ANNPART(:)
 
      INTEGER , ALLOCATABLE :: IDCONC(:,:)
 
      INTEGER :: ITAB , NXTOX , NYTOX , NHOURS , IPAIR
 
      REAL , ALLOCATABLE :: TXCONC(:,:)
 
 
 
!***********************************************************************
!     This is The Global Variable Definition Block for Working Space
!***********************************************************************
 
      CHARACTER WORKID*8 , DUMMY*8
 
      INTEGER :: IMIT , INUM , IDUM , INDAVE , INDGRP , INDVAL , ISC ,  &
     &           IOERRN , NCPP , NRPP , NGPP , NPPX , NPPY
      REAL :: FNUM , RNUM
 
      ALLOCATABLE ::WORKID(:)
      INTEGER , ALLOCATABLE :: IWRK2(:,:)
 
!     Declare Temporary Work Arrays for ZELEV and ZFLAG Receptor Data
      REAL , ALLOCATABLE :: ZETMP1(:) , ZETMP2(:)
      REAL , ALLOCATABLE :: ZFTMP1(:) , ZFTMP2(:)
      REAL , ALLOCATABLE :: ZHTMP1(:) , ZHTMP2(:)
 
 
      SAVE 
 
!***********************************************************************
!     Formerly MAIN3.INC
!     ISCST2 Model Data - Array Names, Array Limits, Named Common Blocks
!                         Necessary for Model Results
!     MODIFIED - 4/17/95   Output CONC/DEPOS in same model run
!***********************************************************************
 
 
!***********************************************************************
!     This is The Global Variable Definition Block For The Maximum
!     Value, Highest Value, Average Value, Annual Average Value and
!     Model Result Arrays.  Also Included are Calm/Missing Flag Arrays.
!***********************************************************************
 
 
      CHARACTER HCLMSG , MCLMSG , HMCLM
 
!                             Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
      REAL , ALLOCATABLE :: HRVAL(:) , AVEVAL(:,:,:,:) , HRVALD(:) ,    &
     &                      HRVALJD(:,:) , AERVAL(:) , PRMVAL(:) ,      &
     &                      AERVALD(:) , PRMVALD(:)
      REAL , ALLOCATABLE :: HIVALU(:,:,:,:,:) , HMAX(:,:,:,:)
      INTEGER , ALLOCATABLE :: HMLOC(:,:,:,:) , HMDATE(:,:,:,:) ,       &
     &                         NHIDAT(:,:,:,:,:)
 
!                             Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
      REAL , ALLOCATABLE :: ANNVAL(:,:,:) , AMXVAL(:,:,:) ,             &
     &                      SHVALS(:,:,:,:,:) , ANNVALD(:,:,:) ,        &
     &                      ANNVALW(:,:,:) , ANNVALJD(:,:,:,:) ,        &
     &                      ANNVALJW(:,:,:,:)
      INTEGER , ALLOCATABLE :: IMXLOC(:,:,:)
!                             Accomodate Wet SCIM'ing, M. Jindal, PES, 6/10/98
      INTEGER :: IANHRS , IANCLM , IANMSG , NSEAHR(4,24) , NSEACM(4,24) &
     &           , IANWET , IWETCLM , IWETMSG
      REAL , ALLOCATABLE :: RMXVAL(:,:,:,:)
      INTEGER , ALLOCATABLE :: MXDATE(:,:,:,:) , MXLOCA(:,:,:,:)
      INTEGER , ALLOCATABLE :: NUMHRS(:) , NUMCLM(:) , NUMMSG(:)
      ALLOCATABLE ::HCLMSG(:,:,:,:,:) , MCLMSG(:,:,:,:) , HMCLM(:,:,:,:)
 
      REAL , ALLOCATABLE :: SUMANN(:,:,:)
      REAL , ALLOCATABLE :: SUMH4H(:,:) , MXPMVAL(:,:)
      INTEGER , ALLOCATABLE :: MXPMLOC(:,:)
 
      REAL , ALLOCATABLE :: CHI(:,:,:) , HECNTR(:,:) , HECNTR3(:,:) ,   &
     &                      PPFACT(:) , UEFFS(:,:) , UEFF3S(:,:) ,      &
     &                      FOPTS(:,:)
 
      REAL , ALLOCATABLE :: ARCMAX(:) , QMAX(:) , DXMAX(:) , UMAX(:) ,  &
     &                      SVMAX(:) , SWMAX(:) , SYMAX(:) , SY3MX(:) , &
     &                      U3MAX(:) , HEMAX(:) , ARCCL(:) , SZMAX(:) , &
     &                      CHIDMW(:) , CHINMW(:) , CHI3MW(:) ,         &
     &                      CHIDML(:) , CHINML(:) , CHI3ML(:) ,         &
     &                      HSBLMX(:)
 
!***********************************************************************
!     This is The Global Variable Definition Block For The
!     EVENT Model Result Arrays
!***********************************************************************
 
      REAL , ALLOCATABLE :: EV_AVEVAL(:) , HRVALS(:,:) , GRPVAL(:)
 
      REAL :: GRPAVE
      INTEGER :: EV_NUMHRS , EV_NUMCLM , EV_NUMMSG , ISTAHR , IENDHR
 
 
!***********************************************************************
!
!     BLOCK DATA SUBPROGRAM OF THE ISC - Version 2 MODEL
!
!     PURPOSE: Initialize Data in COMMON Blocks
!
!     MODIFIED:  To Include Terrain Grid pathway - 12/15/93
!
!     MODIFIED:  To Include WET DEPOSITION Arrays - 11/8/93
!
!     MODIFIED:  To Include New Area Source Arrays - 7/7/93
!
!     MODIFIED:  For revised DRY DEPOSITION code - 2/15/93
!
!     MODIFIED:  To Include TOXXFILE Option - 9/29/92
!
!***********************************************************************
 
!     Variable Declarations
 
 
!***********************************************************************
!     Initialize Model Version Number, VERSN (Year, Julian Day), as a
!     Character Variable
!***********************************************************************
 
      DATA VERSN/'04300'/
 
 
!***********************************************************************
!     Input/Output File Units and Input/Output File Names
!***********************************************************************
 
!LF95 Change INUNIT from 5 to 7, and IOUNIT from 6 to 8, for the
!LF95 Lahey LF95 compiler (version 5.0).
      DATA INUNIT/7/ , IOUNIT/8/ , MFUNIT/19/ , MPUNIT/21/ ,            &
     &     IERUNT/10/ , IERWRT/11/ , IDPUNT/12/ , IZUNIT/13/ ,          &
     &     IDPUN2/14/ , IRSUNT/15/ , IHREMI/16/ , IEVUNT/17/ ,          &
     &     ITEVUT/18/ , INCUNT/20/ , ISUNIT/22/ , IPUNIT/23/ ,          &
     &     DBGUNT/24/ , DBMUNT/25/ , ICVUNT/26/ , IO3UNT/29/
!*#
      DATA INPFIL/' '/ , OUTFIL/' '/
 
 
!***********************************************************************
!     Initialize Keyword Array
!***********************************************************************
 
      INTEGER , PRIVATE :: I
 
 
! --- PRIME ------------------------------
! ----------------------------------------
 
      DATA (KEYWD(I),I=1,IKN)/'STARTING' , 'FINISHED' , 'TITLEONE' ,    &
     &      'TITLETWO' , 'MODELOPT' , 'AVERTIME' , 'POLLUTID' ,         &
     &      'HALFLIFE' , 'DCAYCOEF' , 'DEBUGOPT' , 'ELEVUNIT' ,         &
     &      'FLAGPOLE' , 'RUNORNOT' , 'EVENTFIL' , 'SAVEFILE' ,         &
     &      'INITFILE' , 'MULTYEAR' , 'ERRORFIL' , 'GASDEPDF' ,         &
     &      'GDSEASON' , 'GASDEPVD' , 'GDLANUSE' , 'EVENTFIL' ,         &
     &      'URBANOPT' , 'METHOD_2' , 'LOCATION' , 'SRCPARAM' ,         &
     &      'BUILDHGT' , 'BUILDWID' , 'BUILDLEN' , 'XBADJ   ' ,         &
     &      'YBADJ   ' , 'EMISFACT' , 'EMISUNIT' , 'PARTDIAM' ,         &
     &      'MASSFRAX' , 'PARTDENS' , '        ' , '        ' ,         &
     &      '        ' , 'CONCUNIT' , 'DEPOUNIT' , 'HOUREMIS' ,         &
     &      'GASDEPOS' , 'URBANSRC' , 'EVENTPER' , 'EVENTLOC' ,         &
     &      'SRCGROUP' , 'GRIDCART' , 'GRIDPOLR' , 'DISCCART' ,         &
     &      'DISCPOLR' , 'SURFFILE' , 'PROFFILE' , 'PROFBASE' ,         &
     &      '        ' , 'SURFDATA' , 'UAIRDATA' , 'SITEDATA' ,         &
     &      'STARTEND' , 'DAYRANGE' , 'WDROTATE' , 'DTHETADZ' ,         &
     &      'WINDCATS' , 'RECTABLE' , 'MAXTABLE' , 'DAYTABLE' ,         &
     &      'MAXIFILE' , 'POSTFILE' , 'PLOTFILE' , 'TOXXFILE' ,         &
     &      'EVENTOUT' , 'INCLUDED' , 'SCIMBYHR' , 'SEASONHR' ,         &
     &      'AREAVERT' , 'PARTSIZE' , 'RANKFILE' , 'EVALCART' ,         &
     &      'EVALFILE' , 'NO2EQUIL' , 'OZONEVAL' , 'OZONEFIL' ,         &
     &      'NO2RATIO' , 'OLMGROUP'/
 
 
!***********************************************************************
!     Initialize Miscellaneous Variables
!***********************************************************************
 
!JRA removed space after "-"
      DATA IPROC/366*1/ , EXPLIM/ -50.0/
      DATA UCAT/1.54 , 3.09 , 5.14 , 8.23 , 10.8/
      DATA MODOPS/18*'      '/
 
 
!***********************************************************************
!     Initialize distance factors used in determining when to switch
!     to point source approximation for area sources under the TOXICS
!     option.
!***********************************************************************
 
!     STAB. CLASS         A    B     C     D      E      F
!                        ***  ***   ***   ***    ***    ***
      DATA VIRTPNT_URB/3.5 , 3.5 , 5.5 , 10.5 , 15.5 , 15.5/ ,          &
     &     VIRTPNT_RUR/3.5 , 5.5 , 7.5 , 12.5 , 15.5 , 25.5/
 
 
!***********************************************************************
!     Initialize Setup Status Arrays
!***********************************************************************
 
      DATA ICSTAT/30*0/ , ISSTAT/30*0/ , IRSTAT/30*0/ , IMSTAT/30*0/ ,  &
     &     IOSTAT/30*0/ , ITSTAT/30*0/
 
 
!***********************************************************************
!     Initialize Gridded Profile Height Array
!***********************************************************************
 
      DATA GRIDHT/0.0 , 0.5 , 1.0 , 2.0 , 4.0 , 8.0 , 14.0 , 20.0 ,     &
     &     30.0 , 40.0 , 50.0 , 60.0 , 70.0 , 80.0 , 90.0 , 100.0 ,     &
     &     120.0 , 140.0 , 160.0 , 180.0 , 200.0 , 250.0 , 300.0 ,      &
     &     350.0 , 400.0 , 450.0 , 500.0 , 550.0 , 600.0 , 650.0 ,      &
     &     700.0 , 750.0 , 800.0 , 850.0 , 900.0 , 950.0 , 1000.0 ,     &
     &     1050.0 , 1100.0 , 1150.0 , 1200.0 , 1250.0 , 1300.0 ,        &
     &     1350.0 , 1400.0 , 1450.0 , 1500.0 , 1550.0 , 1600.0 ,        &
     &     1650.0 , 1700.0 , 1750.0 , 1800.0 , 1850.0 , 1900.0 ,        &
     &     1950.0 , 2000.0 , 2100.0 , 2200.0 , 2300.0 , 2400.0 ,        &
     &     2500.0 , 2600.0 , 2700.0 , 2800.0 , 2900.0 , 3000.0 ,        &
     &     3100.0 , 3200.0 , 3300.0 , 3400.0 , 3500.0 , 3600.0 ,        &
     &     3700.0 , 3800.0 , 3900.0 , 4000.0 , 4100.0 , 4200.0 ,        &
     &     4300.0 , 4400.0 , 4500.0 , 4600.0 , 4700.0 , 4800.0 ,        &
     &     4900.0 , 5000.0/
 
 
!***********************************************************************
!     Initialize Error Code and Message Arrays
!***********************************************************************
 
      DATA ERRCOD(1)/'100'/ , ERRMSG(1)                                 &
     &     /'Invalid Pathway Specified. The Troubled Pathway is'/
      DATA ERRCOD(2)/'105'/ , ERRMSG(2)                                 &
     &     /'Invalid Keyword Specified. The Troubled Keyword is'/
      DATA ERRCOD(3)/'110'/ , ERRMSG(3)                                 &
     &     /'Keyword is Not Valid for This Pathway.  Keyword is'/
      DATA ERRCOD(4)/'115'/ , ERRMSG(4)                                 &
     &     /'STARTING or FINISHED Out of Sequence:  Pathway =  '/
      DATA ERRCOD(5)/'120'/ , ERRMSG(5)                                 &
     &     /'Pathway is Out of Sequence:  Pathway =            '/
      DATA ERRCOD(6)/'125'/ , ERRMSG(6)                                 &
     &     /'Missing FINISHED-Runstream File Incomplete: ISTAT='/
      DATA ERRCOD(7)/'130'/ , ERRMSG(7)                                 &
     &     /'Missing Mandatory Keyword.  The Missing Keyword is'/
      DATA ERRCOD(8)/'135'/ , ERRMSG(8)                                 &
     &     /'Duplicate Nonrepeatable Keyword Specified:Keyword='/
      DATA ERRCOD(9)/'140'/ , ERRMSG(9)                                 &
     &     /'Invalid Order of Keyword.  The Troubled Keyword is'/
      DATA ERRCOD(10)/'141'/ , ERRMSG(10)                               &
     &     /'Conflicting Options:  PVMRM and OLM both specified'/
      DATA ERRCOD(11)/'142'/ , ERRMSG(11)                               &
     &     /'Following Keyword Invalid Without PVMRM or OLM:   '/
      DATA ERRCOD(12)/'143'/ , ERRMSG(12)                               &
     &     /'Following Keyword Invalid Without PVMRM Option:   '/
      DATA ERRCOD(13)/'144'/ , ERRMSG(13)                               &
     &     /'Following Keyword Invalid Without OLM Option:     '/
      DATA ERRCOD(14)/'145'/ , ERRMSG(14)                               &
     &     /'Conflicting Options: MULTYEAR and Re-Start Option '/
      DATA ERRCOD(15)/'150'/ , ERRMSG(15)                               &
     &     /'Conflicting Options: MULTYEAR for Wrong Pollutant '/
      DATA ERRCOD(16)/'152'/ , ERRMSG(16)                               &
     &     /'ELEVUNIT card must be first for this Pathway:     '/
      DATA ERRCOD(17)/'154'/ , ERRMSG(17)                               &
     &     /'Conflicting options:  SCIM cannot be used with    '/
      DATA ERRCOD(18)/'155'/ , ERRMSG(18)                               &
     &     /'Conflicting Decay Keyword. Inputs Ignored for     '/
      DATA ERRCOD(19)/'156'/ , ERRMSG(19)                               &
     &     /'Option ignored - not valid with SCIM.  Option =   '/
      DATA ERRCOD(20)/'157'/ , ERRMSG(20)                               &
     &     /'Wet SCIM Option Not Operational Yet. Input Ignored'/
      DATA ERRCOD(21)/'158'/ , ERRMSG(21)                               &
     &     /'EMISUNIT Keyword Used With More Than 1 Output Type'/
      DATA ERRCOD(22)/'159'/ , ERRMSG(22)                               &
     &     /'EMISUNIT Keyword Used With the Following Keyword: '/
      DATA ERRCOD(23)/'160'/ , ERRMSG(23)                               &
     &     /'Duplicate ORIG Secondary Keyword for GRIDPOLR:    '/
      DATA ERRCOD(24)/'170'/ , ERRMSG(24)                               &
     &     /'Invalid Secondary Keyword for Receptor Grid:      '/
      DATA ERRCOD(25)/'175'/ , ERRMSG(25)                               &
     &     /'Missing Secondary Keyword END for Receptor Grid:  '/
      DATA ERRCOD(26)/'180'/ , ERRMSG(26)                               &
     &     /'Conflicting Secondary Keyword for Receptor Grid:  '/
      DATA ERRCOD(27)/'185'/ , ERRMSG(27)                               &
     &     /'Missing Receptor Keywords. No Receptors Specified.'/
      DATA ERRCOD(28)/'190'/ , ERRMSG(28)                               &
     &     /'No Keywords for OU Path and No PERIOD/ANNUAL Aves.'/
      DATA ERRCOD(29)/'195'/ , ERRMSG(29)                               &
     &     /'Incompatible Option Used With SAVEFILE or INITFILE'/
      DATA ERRCOD(30)/'196'/ , ERRMSG(30)                               &
     &     /'Incompatible Keyword Used With GASDEPVD           '/
      DATA ERRCOD(31)/'197'/ , ERRMSG(31)                               &
     &     /'Post-97 PM10 without MAXIFILE is incompatible with'/
      DATA ERRCOD(32)/'198'/ , ERRMSG(32)                               &
     &     /'TOXICS Option is Required in Order to Use Option  '/
 
      DATA ERRCOD(33)/'200'/ , ERRMSG(33)                               &
     &     /'Missing Parameter(s). No Options Specified For    '/
      DATA ERRCOD(34)/'201'/ , ERRMSG(34)                               &
     &     /'Not Enough Parameters Specified For the Keyword of'/
      DATA ERRCOD(35)/'202'/ , ERRMSG(35)                               &
     &     /'Too Many Parameters Specified For the Keyword of  '/
      DATA ERRCOD(36)/'203'/ , ERRMSG(36)                               &
     &     /'Invalid Parameter Specified.  Troubled Parameter: '/
      DATA ERRCOD(37)/'204'/ , ERRMSG(37)                               &
     &     /'Option Parameters Conflict.  Forced by Default to '/
      DATA ERRCOD(38)/'205'/ , ERRMSG(38)                               &
     &     /'No Option Parameter Setting.  Forced by Default to'/
      DATA ERRCOD(39)/'206'/ , ERRMSG(39)                               &
     &     /'Regulatory DFAULT Overrides Non-DFAULT Option For '/
      DATA ERRCOD(40)/'207'/ , ERRMSG(40)                               &
     &     /'No Parameters Specified. Default Values Will Used.'/
      DATA ERRCOD(41)/'208'/ , ERRMSG(41)                               &
     &     /'Illegal Numerical Field Encountered in            '/
      DATA ERRCOD(42)/'209'/ , ERRMSG(42)                               &
     &     /'Negative Value Appears For Non-negative Variable. '/
      DATA ERRCOD(43)/'210'/ , ERRMSG(43)                               &
     &     /'Number of Short Term Averages Exceeds Max:  NAVE= '/
      DATA ERRCOD(44)/'211'/ , ERRMSG(44)                               &
     &     /'Duplicate Averaging Period Specified for Keyword  '/
      DATA ERRCOD(45)/'212'/ , ERRMSG(45)                               &
     &     /'END Encountered Without (X,Y) Points Properly Set '/
      DATA ERRCOD(46)/'213'/ , ERRMSG(46)                               &
     &     /'ELEV Input Inconsistent With Option: Input Ignored'/
      DATA ERRCOD(47)/'214'/ , ERRMSG(47)                               &
     &     /'ELEV Input Inconsistent With Option: Defaults Used'/
      DATA ERRCOD(48)/'215'/ , ERRMSG(48)                               &
     &     /'FLAG Input Inconsistent With Option: Input Ignored'/
      DATA ERRCOD(49)/'216'/ , ERRMSG(49)                               &
     &     /'FLAG Input Inconsistent With Option: Defaults Used'/
      DATA ERRCOD(50)/'217'/ , ERRMSG(50)                               &
     &     /'More Than One Delimiter In A Field for Keyword    '/
      DATA ERRCOD(51)/'218'/ , ERRMSG(51)                               &
     &     /'Number of (X,Y) Points Not Match With Number Of   '/
      DATA ERRCOD(52)/'219'/ , ERRMSG(52)                               &
     &     /'Number Of Receptors Specified Exceeds Max:  NREC= '/
      DATA ERRCOD(53)/'220'/ , ERRMSG(53)                               &
     &     /'Missing Origin (Use Default = 0,0) In GRIDPOLR    '/
      DATA ERRCOD(54)/'221'/ , ERRMSG(54)                               &
     &     /'Missing Distance Setting In Polar Network         '/
      DATA ERRCOD(55)/'222'/ , ERRMSG(55)                               &
     &     /'Missing Degree Or Dist Setting In Polar Network   '/
      DATA ERRCOD(56)/'223'/ , ERRMSG(56)                               &
     &     /'Missing Distance or Degree Field in               '/
      DATA ERRCOD(57)/'224'/ , ERRMSG(57)                               &
     &     /'Number of Receptor Networks Exceeds Max:  NNET=   '/
      DATA ERRCOD(58)/'225'/ , ERRMSG(58)                               &
     &     /'Number of X-Coords Specified Exceeds Max:  IXM=   '/
      DATA ERRCOD(59)/'226'/ , ERRMSG(59)                               &
     &     /'Number of Y-Coords Specified Exceeds Max:  IYM=   '/
      DATA ERRCOD(60)/'227'/ , ERRMSG(60)                               &
     &     /'No Receptors Were Defined on the RE Pathway.      '/
      DATA ERRCOD(61)/'228'/ , ERRMSG(61)                               &
     &     /'Default(s) Used for Missing Parameters on Keyword '/
      DATA ERRCOD(62)/'229'/ , ERRMSG(62)                               &
     &     /'Too Many Parameters - Inputs Ignored on Keyword   '/
      DATA ERRCOD(63)/'231'/ , ERRMSG(63)                               &
     &     /'Too Many Numerical Values Specified for           '/
      DATA ERRCOD(64)/'232'/ , ERRMSG(64)                               &
     &     /'Number Of Specified Sources Exceeds Maximum: NSRC='/
      DATA ERRCOD(65)/'233'/ , ERRMSG(65)                               &
     &     /'Building Dimensions Specified for Non-POINT Source'/
      DATA ERRCOD(66)/'234'/ , ERRMSG(66)                               &
     &     /'Too Many Sectors Input for                        '/
      DATA ERRCOD(67)/'235'/ , ERRMSG(67)                               &
     &     /'Number of Source Groups Exceeds Maximum:  NGRP=   '/
      DATA ERRCOD(68)/'236'/ , ERRMSG(68)                               &
     &     /'Not Enough BUILDHGTs Specified for SourceID       '/
      DATA ERRCOD(69)/'237'/ , ERRMSG(69)                               &
     &     /'Not Enough BUILDWIDs Specified for SourceID       '/
      DATA ERRCOD(70)/'239'/ , ERRMSG(70)                               &
     &     /'Not Enough QFACTs Specified for SourceID          '/
      DATA ERRCOD(71)/'240'/ , ERRMSG(71)                               &
     &     /'Inconsistent Number of Particle Categories for    '/
      DATA ERRCOD(72)/'241'/ , ERRMSG(72)                               &
     &     /'Not Enough BUILDLENs Specified for SourceID       '/
      DATA ERRCOD(73)/'242'/ , ERRMSG(73)                               &
     &     /'No Particle Cat. or Gas Depos. Specified for SRCID'/
      DATA ERRCOD(74)/'243'/ , ERRMSG(74)                               &
     &     /'Scav. Coef. may be out-of-range for SRCID         '/
      DATA ERRCOD(75)/'244'/ , ERRMSG(75)                               &
     &     /'Too Many Particle Categories Specified for        '/
      DATA ERRCOD(76)/'245'/ , ERRMSG(76)                               &
     &     /'No. of Particle Categories Exceeds Max:  NPDMAX=  '/
      DATA ERRCOD(77)/'246'/ , ERRMSG(77)                               &
     &     /'Not Enough XBADJs Specified for SourceID          '/
      DATA ERRCOD(78)/'247'/ , ERRMSG(78)                               &
     &     /'Not Enough YBADJs Specified for SourceID          '/
      DATA ERRCOD(79)/'248'/ , ERRMSG(79)                               &
     &     /'No Sources Were Defined on the SO Pathway.        '/
      DATA ERRCOD(80)/'250'/ , ERRMSG(80)                               &
     &     /'Duplicate XPNT/DIST or YPNT/DIR Specified for GRID'/
      DATA ERRCOD(81)/'252'/ , ERRMSG(81)                               &
     &     /'Duplicate Receptor Network ID Specified.  NETID = '/
      DATA ERRCOD(82)/'254'/ , ERRMSG(82)                               &
     &     /'Number of Receptor ARCs Exceeds Max:       NARC=  '/
      DATA ERRCOD(83)/'256'/ , ERRMSG(83)                               &
     &     /'EVALFILE Option Used Without EVALCART Receptors   '/
      DATA ERRCOD(84)/'260'/ , ERRMSG(84)                               &
     &     /'Number of Emission Factors Exceeds Max:      NQF= '/
      DATA ERRCOD(85)/'262'/ , ERRMSG(85)                               &
     &     /'First Vertex Does Not Match LOCATION for AREAPOLY '/
      DATA ERRCOD(86)/'264'/ , ERRMSG(86)                               &
     &     /'Too Many Vertices Specified for AREAPOLY Source   '/
      DATA ERRCOD(87)/'265'/ , ERRMSG(87)                               &
     &     /'Not Enough Vertices Specified for AREAPOLY Source '/
      DATA ERRCOD(88)/'270'/ , ERRMSG(88)                               &
     &     /'Number of High Values Specified Exceeds Max: NVAL='/
      DATA ERRCOD(89)/'280'/ , ERRMSG(89)                               &
     &     /'Number of Max Values Specified Exceeds Max:  NMAX='/
      DATA ERRCOD(90)/'281'/ , ERRMSG(90)                               &
     &     /'Number of OLMGROUPs Specified Exceeds Max: NOLM=  '/
      DATA ERRCOD(91)/'282'/ , ERRMSG(91)                               &
     &     /'Following SRCID Included in Multiple OLMGROUPs:   '/
      DATA ERRCOD(92)/'283'/ , ERRMSG(92)                               &
     &     /'Either OZONEVAL or OZONEFIL Card Needed for Option'/
      DATA ERRCOD(93)/'284'/ , ERRMSG(93)                               &
     &     /'Invalid POLLUTID Specified for PVMRM/OLM; Must Use'/
      DATA ERRCOD(94)/'290'/ , ERRMSG(94)                               &
     &     /'Number of Output Types Specified Exceeds Max:NTYP='/
      DATA ERRCOD(95)/'294'/ , ERRMSG(95)                               &
     &     /'PERIOD and ANNUAL averages are both selected for  '/
      DATA ERRCOD(96)/'295'/ , ERRMSG(96)                               &
     &     /'Invalid Averaging Period Specified for SCREEN Mode'/
      DATA ERRCOD(97)/'298'/ , ERRMSG(97)                               &
     &     /'Error Allocating Storage for Setup Arrays!        '/
      DATA ERRCOD(98)/'299'/ , ERRMSG(98)                               &
     &     /'Error Allocating Storage for Result Arrays!       '/
 
      DATA ERRCOD(99)/'300'/ , ERRMSG(99)                               &
     &     /'Specified SRCID Has Not Been Defined Yet: KEYWORD='/
      DATA ERRCOD(100)/'305'/ , ERRMSG(100)                             &
     &     /'Terrain Grid Does Not Cover Modeling Area, Change:'/
      DATA ERRCOD(101)/'310'/ , ERRMSG(101)                             &
     &     /'Attempt to Define Duplicate LOCATION Card for SRC:'/
      DATA ERRCOD(102)/'313'/ , ERRMSG(102)                             &
     &     /'Attempt to Define Duplicate EVENTPER card for     '/
      DATA ERRCOD(103)/'315'/ , ERRMSG(103)                             &
     &     /'Attempt to Define Duplicate SRCPARAM Card for SRC:'/
      DATA ERRCOD(104)/'319'/ , ERRMSG(104)                             &
     &     /'No Sources Included in Specified Source Group:    '/
      DATA ERRCOD(105)/'320'/ , ERRMSG(105)                             &
     &     /'Input Parameter May Be Out-of-Range for Parameter '/
      DATA ERRCOD(106)/'322'/ , ERRMSG(106)                             &
     &     /'Release Height Exceeds Effective Depth for OPENPIT'/
      DATA ERRCOD(107)/'323'/ , ERRMSG(107)                             &
     &     /'No Particle Categories Specified for OPENPIT Src. '/
      DATA ERRCOD(108)/'325'/ , ERRMSG(108)                             &
     &     /'Negative Exit Velocity (Set=1.0E-5) for SRCID:    '/
      DATA ERRCOD(109)/'330'/ , ERRMSG(109)                             &
     &     /'Mass Fraction Parameters Do Not Sum to 1. for Src '/
      DATA ERRCOD(110)/'332'/ , ERRMSG(110)                             &
     &     /'Mass Fraction Parameter Out-of-Range for Source   '/
      DATA ERRCOD(111)/'334'/ , ERRMSG(111)                             &
     &     /'Particle Density Out-of-Range for Source          '/
      DATA ERRCOD(112)/'336'/ , ERRMSG(112)                             &
     &     /'Value Specified for NO2RATIO is Out-of-Range for  '/
      DATA ERRCOD(113)/'338'/ , ERRMSG(113)                             &
     &     /'Neg Emis Rate Cannot be Used with OLM/PVMRM. Src: '/
      DATA ERRCOD(114)/'340'/ , ERRMSG(114)                             &
     &     /'Possible Error in PROFBASE Input:  Value is < 0   '/
      DATA ERRCOD(115)/'342'/ , ERRMSG(115)                             &
     &     /'Src ID Mismatch in Hourly Emissions File for ID = '/
      DATA ERRCOD(116)/'344'/ , ERRMSG(116)                             &
     &     /'Hourly Emission Rate is Zero for KURDAT =         '/
      DATA ERRCOD(117)/'350'/ , ERRMSG(117)                             &
     &     /'Julian Day Out Of Range at                        '/
      DATA ERRCOD(118)/'352'/ , ERRMSG(118)                             &
     &     /'Missing Field on MULTYEAR Card for Pre-1997 PM10  '/
      DATA ERRCOD(119)/'353'/ , ERRMSG(119)                             &
     &     /'MULTYEAR Card for PM10 Processing Applies Only for'/
      DATA ERRCOD(120)/'354'/ , ERRMSG(120)                             &
     &     /'High-4th-High Only Required for Post-1997 PM10    '/
      DATA ERRCOD(121)/'360'/ , ERRMSG(121)                             &
     &     /'2-Digit Year Specified: Valid for Range 1950-2049 '/
      DATA ERRCOD(122)/'363'/ , ERRMSG(122)                             &
     &     /'24HR and ANNUAL Averages Only for Post-1997 PM10  '/
      DATA ERRCOD(123)/'365'/ , ERRMSG(123)                             &
     &     /'Year Input is Greater Than 2147                   '/
      DATA ERRCOD(124)/'370'/ , ERRMSG(124)                             &
     &     /'Invalid Date: 2/29 In a Non-leap Year.            '/
      DATA ERRCOD(125)/'380'/ , ERRMSG(125)                             &
     &     /'This Input Variable is Out-of-Range:              '/
      DATA ERRCOD(126)/'381'/ , ERRMSG(126)                             &
     &     /'Latitude in Surface File Is Not Valid:            '/
      DATA ERRCOD(127)/'382'/ , ERRMSG(127)                             &
     &     /'Error Decoding Latitude:                          '/
      DATA ERRCOD(128)/'383'/ , ERRMSG(128)                             &
     &     /'NWETFREQ > 0, but Wet Dep/Depletion not selected  '/
      DATA ERRCOD(129)/'385'/ , ERRMSG(129)                             &
     &     /'Averaging Period .NE. 1-Hr for TOXXFILE Option    '/
      DATA ERRCOD(130)/'390'/ , ERRMSG(130)                             &
     &     /'Aver. Period must be .LE. 24 for EVENT Processing '/
      DATA ERRCOD(131)/'391'/ , ERRMSG(131)                             &
     &     /'Aspect ratio (L/W) of area source greater than 10 '/
      DATA ERRCOD(132)/'392'/ , ERRMSG(132)                             &
     &     /'Aspect ratio (L/W) of open pit is greater than 10 '/
      DATA ERRCOD(133)/'393'/ , ERRMSG(133)                             &
     &     /'Terrain Grid Value Differs >50% From Source Elev. '/
      DATA ERRCOD(134)/'394'/ , ERRMSG(134)                             &
     &     /'Terrain Grid Value Differs >50% From Receptor Elev'/
      DATA ERRCOD(135)/'395'/ , ERRMSG(135)                             &
     &     /'Met. Data Error; Incompatible Version of AERMET:  '/
      DATA ERRCOD(136)/'396'/ , ERRMSG(136)                             &
     &     /'Met. Data Generated by Older Version of AERMET:   '/
 
      DATA ERRCOD(137)/'405'/ , ERRMSG(137)                             &
     &     /'Value of PHEE Exceeds 1.0 on KURDAT =             '/
      DATA ERRCOD(138)/'406'/ , ERRMSG(138)                             &
     &     /'Increase NVMAX for Complex AREAPOLY Source        '/
      DATA ERRCOD(139)/'410'/ , ERRMSG(139)                             &
     &     /'Wind Direction Out-of-Range.  KURDAT=             '/
      DATA ERRCOD(140)/'413'/ , ERRMSG(140)                             &
     &     /'Number of Threshold Events > 9999 for Ave Period  '/
      DATA ERRCOD(141)/'420'/ , ERRMSG(141)                             &
     &     /'Wind Speed Out-of-Range.   KURDAT=                '/
      DATA ERRCOD(142)/'430'/ , ERRMSG(142)                             &
     &     /'Ambient Temperature Data Out-of-Range.  KURDAT=   '/
      DATA ERRCOD(143)/'432'/ , ERRMSG(143)                             &
     &     /'Friction Velocity Out-of-Range.   KURDAT=         '/
      DATA ERRCOD(144)/'435'/ , ERRMSG(144)                             &
     &     /'Surface Roughness Length Out-of-Range.  KURDAT=   '/
      DATA ERRCOD(145)/'438'/ , ERRMSG(145)                             &
     &     /'Convective Velocity Data Out-of-Range.  KURDAT=   '/
      DATA ERRCOD(146)/'439'/ , ERRMSG(146)                             &
     &     /'Monin-Obukhov Length Out-of-Range.  KURDAT=       '/
      DATA ERRCOD(147)/'440'/ , ERRMSG(147)                             &
     &     /'Calm Hour Identified in Meteorology Data File at  '/
      DATA ERRCOD(148)/'450'/ , ERRMSG(148)                             &
     &     /'Error in Meteor. File - Record Out of Sequence at '/
      DATA ERRCOD(149)/'455'/ , ERRMSG(149)                             &
     &     /'Date/time Mismatch: Hourly Emission File. KURDAT ='/
      DATA ERRCOD(150)/'456'/ , ERRMSG(150)                             &
     &     /'Date/time Mismatch on Surface & Profile. KURDAT = '/
      DATA ERRCOD(151)/'457'/ , ERRMSG(151)                             &
     &     /'Date/time Mismatch on OZONEFIL Data.  KURDAT =    '/
      DATA ERRCOD(152)/'458'/ , ERRMSG(152)                             &
     &     /'Substitution made for missing ozone data. KURDAT= '/
      DATA ERRCOD(153)/'459'/ , ERRMSG(153)                             &
     &     /'Missing ozone data; Full conversion used. KURDAT= '/
      DATA ERRCOD(154)/'460'/ , ERRMSG(154)                             &
     &     /'Missing Hour Identified in Meteor. Data File at   '/
      DATA ERRCOD(155)/'465'/ , ERRMSG(155)                             &
     &     /'Number of Profile Levels Exceeds Max:   MXPLVL=   '/
      DATA ERRCOD(156)/'470'/ , ERRMSG(156)                             &
     &     /'Mixing Height Value is < or = 0.0.   KURDAT=      '/
      DATA ERRCOD(157)/'475'/ , ERRMSG(157)                             &
     &     /'Reference height is higher than 100m.  KURDAT=    '/
      DATA ERRCOD(158)/'480'/ , ERRMSG(158)                             &
     &     /'Less Than 1 Year Found for ANNUAL Averages        '/
      DATA ERRCOD(159)/'485'/ , ERRMSG(159)                             &
     &     /'Data Remaining After End of Year. Number of Hours='/
      DATA ERRCOD(160)/'487'/ , ERRMSG(160)                             &
     &     /'User Start Date is Earlier Than Start of Data File'/
 
      DATA ERRCOD(161)/'500'/ , ERRMSG(161)                             &
     &     /'Fatal Error Occurs Opening the Data File of       '/
      DATA ERRCOD(162)/'510'/ , ERRMSG(162)                             &
     &     /'Fatal Error Occurs During Reading of the File of  '/
      DATA ERRCOD(163)/'520'/ , ERRMSG(163)                             &
     &     /'Fatal Error Occurs During Writing to the File of  '/
      DATA ERRCOD(164)/'530'/ , ERRMSG(164)                             &
     &     /'CAUTION! Met Station ID Mismatch with SURFFILE for'/
      DATA ERRCOD(165)/'540'/ , ERRMSG(165)                             &
     &     /'No RECTABLE/MAXTABLE/DAYTABLE for Average Period  '/
      DATA ERRCOD(166)/'550'/ , ERRMSG(166)                             &
     &     /'File Unit/Name Conflict for the Output Option:    '/
      DATA ERRCOD(167)/'560'/ , ERRMSG(167)                             &
     &     /'User Specified File Unit .LE. 25 for OU Keyword:  '/
      DATA ERRCOD(168)/'565'/ , ERRMSG(168)                             &
     &     /'Possible Conflict With Dynamically Allocated FUNIT'/
      DATA ERRCOD(169)/'570'/ , ERRMSG(169)                             &
     &     /'Problem Reading Temporary Event File for Event:   '/
      DATA ERRCOD(170)/'580'/ , ERRMSG(170)                             &
     &     /'End of File Reached Trying to Read the File of    '/
 
 
      END
!*==DEPVAR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      MODULE DEPVAR
!-----------------------------------------------------------------------
! --- ISCST2    Version: 1.0            Level: 931215        DEPVAR
!               D. Strimaitis, SRC
!
! PURPOSE:     Include-file of parameters and commons for deposition
!
! MODIFIED:    Split terrain grid common blocks to avoid alignment warning.
!              R. Brode, PES, Inc. - 5/24/95
!
! MODIFIED:    Added variable kurdat to common.
!              R. Brode, PES, Inc. - 9/30/94
!
!-----------------------------------------------------------------------
!     The following commented line provides the array limits for the
!     Microsoft executable file.
 
      IMPLICIT NONE
 
!-----------------------------------------------------------------------
! --- PARAMETERS
!-----------------------------------------------------------------------
      REAL , PARAMETER :: RTPIBY2 = 1.2533141 , RT2 = 1.4142136 ,       &
     &                    RTPI = 1.7724539
 
!-----------------------------------------------------------------------
! --- COMMON BLOCK /DEPVAR/ --- Source Depletion Variables
!-----------------------------------------------------------------------
      LOGICAL :: RURAL , URBAN , DEBUG , LTOXICS
      CHARACTER :: SRCTYP*8
      REAL :: VD , VS , ZD , AP , BP , CP , AR , BR , CR , HMIX ,       &
     &        ONEBYU , ER , EP , XSRC , YSRC , XREC , YREC , XR , XV ,  &
     &        H , SGZ , SGZ0 , XTD , SZTD , SZMN
      INTEGER :: IGRAV , KST , IOUNIT , KURDAT
 
!-----------------------------------------------------------------------
! --- COMMON BLOCK /TGRID/ --- Gridded Terrain Variables
!-----------------------------------------------------------------------
      LOGICAL LTGRID
      INTEGER(KIND=2) , ALLOCATABLE :: IZARRAY(:,:)
      REAL :: XLLM , YLLM , SIZEM , XURM , YURM
      INTEGER :: NTX , NTY
 
!-----------------------------------------------------------------------
!     DEFINITIONS       [i]=integer     [r]=real       [l]=logical
!-----------------------------------------------------------------------
!                      - PARAMETERS -
! rtpiby2        square root of pi/2                                 [r]
! rt2            square root of 2                                    [r]
! rtpi           square root of pi                                   [r]
! (note: mxtx and mxty now allocated at runtime)
!
!                         /DEPVAR/
! vd (m/s)       deposition velocity                                 [r]
! vs (m/s)       gravitational settling velocity                     [r]
! zd (m)         reference height for deposition calculation         [r]
! ap,bp,cp       coefficients for analytical form of profile fcn     [r]
! ar,br,cr       coefficients for resistance function                [r]
! igrav          flag for treatment of gravitational settling        [i]
!                  0:use analytical approximation to profile integral
!                  1:use numerical solution to profile integral
! rural,urban    logical indicators for dispersion site character    [l]
! kst            P-G stability class                                 [i]
! hmix (m)       mixing height                                       [r]
! onebyu (s/m)   reciprocal of wind speed                            [r]
! er (m)         elevation (MSL) of receptor location                [r]
! ep (m)         elevation (MSL) of point-source location            [r]
! (x,y)src (m)   source location                                     [r]
! (x,y)rec (m)   receptor location                                   [r]
! xr (m)         distance from source to receptor                    [r]
! xv (m)         virtual source distance upwind of actual source     [r]
! h (m)          plume centerline height (no gravitational settling) [r]
! sgz (m)        sigma-z                                             [r]
! sgz0 (m)       initial sigma-z (e.g. for BID)                      [r]
! xtd (m)        distance to centerline "touchdown" (settling)       [r]
! sgtd (m)       sigma-z at xtd                                      [r]
! szmn (m)       minimum allowed for "settling" sigma-z              [r]
! debug          logical indicator for debug option                  [l]
! iounit         unit number for debug output                        [i]
! srctyp         source type (8 characters)                          [c]
!
!                         /TGRID/
! (x,y)llm   (m) coordinates of SW corner of cell1 (lower left
!                  corner) of terrain grid                           [r]
! sizem      (m) length of side of terrain grid cell                 [r]
! (x,y)urm   (m) coordinates of upper right corner of terrain grid   [r]
! izarray (m MSL) gridded terrain elevation data                     [i]
!
!  NOTE:  This grid contains terrain elevations at the corner of each
!         cell.  Therefore there are nx+1 points in x, and ny+1 points
!         in y.  The coordinates are assumed to be referenced to the
!         same origin used to specify source and receptor locations.
!-----------------------------------------------------------------------
 
      END
!*==AERMOD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      PROGRAM AERMOD
!***********************************************************************
!           MAIN Module of the AMS/EPA Regulatory Model - AERMOD
!                       (DRAFT Version Dated 04300)
!
!               *** SEE AERMOD MODEL CHANGE BULLETIN MCB#X ***
!
!       ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS (SCRAM) WEBSITE
!
!                      http://www.epa.gov/scram001/
!
!=======================================================================
!
!       This DRAFT version (dated 04300) includes the Plume Volume Molar
!       Ratio Method (PVMRM) and the Ozone Limiting Method (OLM) for
!       modeling conversion of NOx to NO2.  This work was supported by
!       BP Exploration (Alaska), Inc., Phillips Exploration, Inc.,
!       and the Alaska Department of Environmental Conservation.
!
!       This DRAFT version (dated 04300) also includes the following
!       modifications:
!
!       1.  Dry depletion (DRYDPLT) and wet depletion (WETDPLT) are no
!           longer optional for deposition applications.  These options
!           for removal of mass from the plume due to dry and/or wet
!           deposition processes will automatically be invoked for
!           applications in which dry and/or wet deposition are
!           considered.  The DRYDPLT and WETDPLT options on the
!           MODELOPT card will be ignored, and need not be removed
!           from the model input file for the model to run.
!
!       2.  Correction made to area source algorithm, subroutine PLUMEF,
!           to include a call to CRITDS to calculate the critical
!           dividing streamline height for gaseous pollutants.  Also
!           modified PLUMEF to correct a problem with the AREADPLT option.
!
!       3.  Corrections made to area source and openpit algorithms,
!           in subroutines ACALC and OCALC, to include tilted plume
!           for point source approximation of particle emissions, and
!           to include reinitialization of __VAL arrays at end of
!           receptor loop (reinitializations also included in PCALC and
!           VCALC for point and volume sources for consistency).  The
!           latter correction fixes a potential problem with particle
!           emissions for area sources when the point source
!           approximation is used under the TOXICS option.
!
!       4.  Corrected calling arguments for call to WAKE_SIG from
!           subroutine WAKE_DFSN2, to use wakiz and wakiy instead of
!           turbz and turby.
!
!       5.  Minor correction made to wet deposition calculations to
!           include lateral term (FSUBY) in weighting of direct
!           and penetrated source contributions for WETFLUX.
!
!       6.  Modified suroutine PRMCALC to place receptor on centerline
!           of cavity plumes by setting Y2 = 0.0 for SCREEN option.
!
!       7.  Modified subroutine SRCQA to calculate equivalent XINIT
!           and YINIT values for AREAPOLY sources to allow for
!           calculation of area of source under TOXICS option and
!           for PVMRM option.  Also modified SRCQA to include a more
!           refined computation of centroid for AREAPOLY sources.
!
!       8.  Included check in subroutine METQA for absolute values of
!           Monin-Obukhov length (OBULEN) less than 1.0.  Adjustment
!           of OBULEN is made to limit ABS(OBULEN) .GE. 1.0.  The
!           sign of OBULEN is assigned the opposite of the sign of the
!           heat flux if OBULEN is 0.0.  This limit on OBULEN is
!           already applied in AERMET, so this change in AERMOD will
!           only affect input data generated by other means.
!
!       9.  Moved call to SUB. METDAT ahead of call to SUB. SET_METDATA
!           to avoid potential problem with negative (missing)
!           precipitation for first hour.
!
!      10.  Added range check on gas deposition parameters to trap
!           on input of zero (0.0) values.
!
!      11.  Modified subroutine METQA to reduce number of extraneous
!           warning messages, especially for hours with missing
!           meteorological data.  Also modified range check for missing
!           wind direction in subroutine CHKMSG.
!
!      12.  Modified PLOTFILE output to include date field.
!
!      13.  Modifications to some debug output statements based on
!           code provided by ENSR.
!
!       MODIFIED BY:    Roger W. Brode
!                       MACTEC Federal Programs, Inc.
!                       (formerly known as PES, Inc.)
!                       October 26, 2004
!
!       MODIFIED FROM:          AERMOD
!                       (Version Dated 04079)
!
!=======================================================================
!
!       This revised DRAFT version (dated 04079) incorporates
!       modifications to the wet deposition algorithms for both
!       gaseous and particle emissions.  For both gaseous and particle
!       wet deposition, the wet fluxes have been corrected to include
!       a factor of 3600.*SQRT(2*PI) in the denominator.  The factor
!       of 3600 was needed to correct a unit conversion error between
!       seconds and hours in the final calculation of the flux.
!       The factor of SQRT(2*PI) is needed to complete the integrated
!       vertical term.  A problem causing potential runtime errors for
!       volume and area sources with dry depletion was also corrected.
!
!       In addition to the corrections identified above, the particle
!       wet deposition algorithms were also modified to include an
!       algorithm for calculating the collision efficiency as a function
!       of particle size and raindrop size.  The previous version of
!       the model included a fixed value of 4.0e-4 for the collision
!       efficiency.
!
!
!       MODIFIED BY:    Roger W. Brode
!                       MACTEC Federal Programs, Inc.
!                       (formerly known as PES, Inc.)
!                       March 19, 2004
!
!       MODIFIED FROM:           AERMOD
!                         (Version Dated 03273)
!
!=======================================================================
!
!       This DRAFT version (dated 03273) incorporates wet and dry
!       deposition algorithms based on the draft ANL report (Wesely,
!       et. al, 2001), with modifications to the wet deposition
!       algorithms based on peer review comments.  The dry deposition
!       algorithms include dry depletion based on the simple source
!       depletion method.
!
!       NOTE:  The wet SCIM'ing and output by particle size options
!       from the ISCST3 model have not been implemented yet in AERMOD.
!
!       This version includes the following modifications relative to
!       the previous draft (dated 03213):
!
!       1.  Removed depletion for the "inside cavity source" from the
!           PRIME calculations.
!
!       2.  Moved the code to adjust for TS < TA (used to model a fixed
!           delta TS-TA) from SUBROUTINE SETSRC back to SUBROUTINE
!           FLUXES.  This corrects some minor discrepancies between
!           the consequence analysis results for non-buoyant sources
!           relative to version 02222.
!
!       3.  Removed the dry particle deposition code associated with
!           DFAULT mode in ISCST3.  The only dry particle deposition
!           in AERMOD is based on the ANL report for Methods 1 and 2.
!           This also corrects a logic problem if neither TOXICS nor
!           DFAULT options are specified.
!
!       4.  Modified FUNCTION F2INT to only call DELTAH for point
!           sources during plume depletion calculation.
!
!       5.  Added identification of urban sources and Method 2 sources
!           in summary of source inputs.
!
!       6.  Included optional dry depletion option for Method 2.
!
!       7.  Additional code cleanup and documentatino, including removal
!           of unused data arrays associated with ISCST3 depletion code
!           and moving the call to SUBROUTINE METINI to follow the call
!           to SETSRC in SUBROUTINE OCALC for open pit sources.
!
!
!       Version 03213 (August 1, 2003) included the following
!       modifications relative to the previous draft (dated 03171):
!
!       1.  Corrects problem with calculation of f2 term used in gas
!           dry deposition.  The calculation of Wnew and f2 had to be
!           moved outside the source loop to properly account for
!           accumulated precipitation over three hour period.
!
!       2.  Changed the definition of the "top of the plume" to be based
!           on the plume centerline height plus 2.15*sigma-z, evaluated
!           at 20km downwind.  The previous definition was based on
!           3.9*sigma-z.
!
!       3.  Terrain effects are now incorporated in the dry depletion
!           calculation.  The terrain elevation is linearly interpolated
!           between the source base elevation and the terrain elevation
!           at the receptor.  The hill height scale is linearly
!           interpolated between the stack release height at the
!           source and the hill height scale from AERMAP at the receptor
!           location.
!
!       4.  Modified the short-term EVENT processing option to be
!           compatible with the deposition algorithms.  If more than
!           one output type is selected in the normal model run that
!           generates the EVENT input file, the events will be defined
!           based on the first output type, in the order of CONC, DEPOS,
!           DDEP, WDEP.
!
!       5.  Modified summary of first 24-hours of met data to include
!           additional parameters for deposition applications.
!
!       6.  Modified the program to use free-formatted READ for the
!           surface meteorological input file for all cases.  Decision
!           on whether to read additional parameters needed for deposition
!           is based on logical variables associated with deposition
!           calculations.
!
!       7.  Incorporated a patch in SUBROUTINE UNLUMP of PRIME.FOR to
!           avoid potential math error for downwash calculations.
!           The plume temperature calculated by NUMRISE is limited to
!           be greater than or equal to the ambient temperature minus
!           10 K.  This avoids a potential SQRT of a negative number.
!
!       MODIFIED BY:    Roger W. Brode
!                       MACTEC Federal Programs, Inc.
!                       (formerly known as PES, Inc.)
!                       September 30, 2003
!
!       MODIFIED FROM:           AERMOD
!                         (Version Dated 02222)
!
!=======================================================================
!
!       This DRAFT version (dated 02222) includes fixes to the following
!       bugs:
!
!       1) modification to ACALC to avoid potential math errors
!          for AREAPOLY sources;
!       2) correction to METSUM to output missing temperatures correctly
!          for the SCIM option;
!       3) correction to EMVARY to replace 'STAR' option with
!          'WSPEED' option;
!       4) modified CAV_SRC to keep "outside" cavity source in array
!          element 3 for cases when no "inside" cavity source contribution
!          occurs;
!       5) corrected meander algorithm to combine "plume" and
!          "pancake" components of concentrations rather than just
!          blending the lateral dispersion term, removed limit on pancake
!          term to be smaller than plume lateral term, and removed meander
!          from the PRIME component for sources subject to building
!          downwash;
!       6) corrected problem in NUMRISE to avoid referencing an
!          undefined variable (xbi);
!       7) corrected calling arguments for call to WAKE_SIG from
!          subroutine WAKE_DFSN, to use wakiz and wakiy instead of
!          turbz, and turby; and
!       8) correction of Z_iuo in subroutine URBCALC from 500 to 400
!          meters.
!
!       Modified to remove command line arguments for specifying
!       input and output file names, and use hardwired names of
!       AERMOD.INP and AERMOD.OUT.
!
!       This version includes an adjustment to ustar and L for urban stable
!       cases, by equating the "convective" sigma-w based on the urban
!       "convective" w* with the mechanical sigma-w based on u*
!       evaluated at a height of 7 times the urban roughness length.
!       The URBANOPT keyword was modified to allow the user to input
!       the urban roughness length as an optional parameter following
!       the optional city name.  If no urban roughness length is input,
!       then the model assumes an urban roughness length of 1.0 meter.
!
!       This version also includes a modification to the minimum layer
!       depth near the ground used to calculate effective parameters.
!       A minimum layer depth of 5 meters is used instead of 2 meters
!       if the plume centroid height and receptor height are both below
!       5 meters.
!
!       MODIFIED BY:    Roger W. Brode
!                       PES, Inc.
!                       September 10, 2002
!
!       MODIFIED FROM:           AERMOD
!                         (Version Dated 01247)
!
!=======================================================================
!
!       This draft version (dated 01247) includes the PRIME building
!       downwash algorithms based on the ISC-PRIME model (dated 99207).
!       For cases involving building downwash, the model calculates a
!       non-wake contribution using the AERMOD algorithms, a wake
!       contribution using the PRIME algorithms, and blends the two
!       results using a factor called GAMFACT that varies based on the
!       location of the receptor relative to the wake.  For receptors
!       within the wake region, where the lateral and vertical boundaries
!       are defined by the wake half-width and height, respectively, and
!       the longitudinal boundary is defined by a distance equal to 15R
!       or the point where wake turbulence intensity decays to ambient
!       turbulence intensity, whichever is greater, measured from the
!       upwind edge of the building, GAMFACT is set equal to 1.0 (i.e.,
!       uses the PRIME result only).  The PRIME algorithm has been
!       modified to use the AERMOD meteorological profiles and
!       definitions of ambient turbulence.
!
!       This version also includes a modification to the DTHETA/DZ
!       profile (TEMPGRID.FOR) for extrapolating above the highest
!       measurement height for cases with observed temperature profiles,
!       a modification to the upper limit on the integration for
!       HCRIT (CALC2.FOR), a correction to the calculation of FYPAN
!       for meander (CALC2.FOR), and an adjustment to ISTRT_WIND used
!       for Y2K compliance to subtract 1 from ISTRT_WIND in case the
!       meteorological data file contains data from the end of the
!       previous year.
!
!       MODIFIED BY:    Roger W. Brode
!                       PES, Inc.
!                       September 4, 2001
!
!       MODIFIED FROM:           AERMOD
!                         (Version Dated 00357)
!
!=======================================================================
!
!       This version (dated 00357) includes enhancements based on the
!       current ISCST3 model (dated 00101).  These include:  1) the use of
!       globally allocatable arrays for data storage; 2) expanded data
!       structures to allow for output of concentration and deposition in
!       a single model run (for use when deposition algorithms are added
!       to AERMOD); 3) EVENT processing for short-term culpability analyses;
!       4) post-1997 PM10 processing; 5) TOXICS option enhancements such as
!       optimizations for area sources, the SCIM option, and SEASONHR output
!       file option; 6) explicit treatment of multiple-year meteorological
!       data files and ANNUAL averages; 7) the SHRDOW and SHRDOW7 options
!       for specifying emissions that vary by season, hour-of-day, and
!       day-of-week; and 8) improved data structures for field length and
!       filename lengths.
!
!       The following modifications have also been made to correct errors:
!       1) the PARAMETER LAMDAY was implicitly typed as integer in previous
!       versions, and is now explicitly typed as real, which has an impact
!       on the plume height calculations for the indirect source; 2) the
!       calculation of the plume centroid height for unstable conditions
!       for area sources was moved from SUB. ACALC to be included inside
!       the area source integration in SUB. PLUMEF and SUB. PWIDTH, which
!       affects results for area sources during unstable conditions,
!       especially for receptors located inside an elongated area source
!       with the wind blowing along the long dimension of the source; and
!       3) the STABLE and UNSTAB logical variables are now assigned prior
!       to the call to COMPTG in SUB. METEXT, potentially affecting the
!       observed DTHETA/DZ profile for the first stable hour in a day;
!       4) the calculation of wind direction (WDIR) at stack top in SUB.
!       METINI and at stack height plus 0.5*deltaH in SUB. PCALC was
!       corrected to account for possible 0-360 crossover in the profile;
!       5) corrections were made to the vertical terms to correct the
!       reflection component for receptors located below stack base elevation;
!       6) corrected calculation of FYPAN term for meander in SUB. FYTERM
!       to use radial distance (DISTR) instead of downwind distance (X); and
!       7) application of meander to both stable and unstable conditions.
!       Additional modifications were made to consolidate redundant code
!       and simplify future maintenance activities.
!
!       MODIFIED BY:    Roger W. Brode
!                       PES, Inc.
!                       December 22, 2000
!
!       MODIFIED FROM:           AERMOD
!                         (Version Dated 99351)
!
!========================================================================
!
!                              (Version Dated 99351)
!                                December 17, 1999
!
!        This version (99351) includes the following corrections to the
!        implementation of the Schulman-Scire downwash algorithm:  1) added
!        call to DHPSS in calculation of plume centroid height (CENTER) in
!        subroutine PCALC; and 2) modified to use SZ3LB and SY3LB based on
!        building enhanced dispersion curves only in subroutine DHPSS.
!        Additional modifications were made to improve consistency with
!        ISCST3 implementation of Schulman-Scire downwash algorithm.
!        Also includes changes to subroutine PCCODE to facilitate
!        compilation of the model using the DEC Visual Fortran compiler.
!        The output file unit number, IOUNIT, was also changed from 6 to 9
!        in order for runtime status update to appear on the screen for
!        DEC-compiled executables.  Minor, inconsequential changes were
!        also made to comment headers and variable declarations in
!        SIGGRID.FOR.
!
!
!        MODIFIED FROM:
!                              (Version Dated 99211)
!                                  July 30, 1999
!
!========================================================================
!
!        This version (99211) incorporates modifications for Y2K compliance.
!        Uses a window of 1950 to 2049 for 2-digit years.  Will utilize
!        4-digit year if input for surface and profile files using FREE
!        format (the default read format still reads a 2-digit year).
!        Changes also include calculation of a 10-digit date variable
!        (FULLDATE) with 4-digit year for date comparisons, and changes of
!        the output formats for the 8-digit variable, KURDAT, to I8.8 to
!        include leading zeros.  The date and time routines used for the
!        page headers have been modified to use the standard Fortran 90
!        routines, and minor changes have been made to remove obsolescent
!        features from the code.  Changes also include a correction to
!        a variable name in SUBROUTINE DELTAH.
!
!
!        MODIFIED FROM:
!                              (Version Dated 98314)
!                                November 10, 1998
!
!========================================================================
!
!        This version (dated 98314) incorporates modifications for the final
!        draft AERMOD Model. This draft represents the final version of the
!        model prior to the Notice of Proposed Rulemaking for including
!        AERMOD in the modeling Guideline and subsequent public comment period.
!        Changes to the model are too numerous to list here in detail.
!        Changes to the interface are incorporated in the revised
!        AERMOD user's guide, and pertain primarily to the regulatory
!        default option on the CO MODELOPT card, and removal of the
!        developmental options for terrain affects.  The CO TERRHGTS
!        keyword is now obsolete, and a new mandatory ME PROFBASE
!        keyword has been added for inputting the base elevation above
!        MSL for the gridded potential temperature profile.
!
!
!        MODIFIED FROM:
!                               (Version Dated 98022)
!                                  January 22, 1998
!
!========================================================================
!
!        This version (dated 98022) incorporates modifications for the revised
!        draft AERMOD Model. This draft represents the final Phase I version
!        of the model.  This version includes the use a minimum sigma-v of
!        0.2 m/s. It also incorporates corrections to the downwash algorithms.
!        It limits the number of iterations on inhomogeneity to 1,
!        i.e., effective parameters are calculated based on an average
!        for the layer from plume centerline to 2.15 sigma-z, where
!        sigma-z is based on parameters at plume centerline height.
!        The transport wind direction is based on the modpoint between
!        stack height and "final" plume height.  Modifications have also
!        been made to the dtheta/dz profile, the Tly and Tlz used for stable
!        plumes above the CBL, and the height of the effective reflecting
!        surface for stable plumes.
!
!
!        MODIFIED FROM:
!                               (Version Dated 97350)
!                                 December 16, 1997
!
!========================================================================
!
!        This draft includes an option for specifying the transport wind
!        direction.  The option is specified on the MODELOPT card, where
!        WDOPT1 is for wind direction taken at stack height, and
!        WDOPT2 is for wind direction at the midpoint between stack height
!        and "final" plume height.  The default option is WDOPT1.
!        This version does not include conditional compilation code to
!        support the Microsoft Fortran compiler.  This version of the
!        code is compatible with the Lahey F77L3 and Lahey LF/90 compilers.
!        The deposition algorithm for AERMOD is still under development,
!        and is not operational in this version.
!                   R.W. Brode, PES, Inc., December 16, 1997
!
!
!        MODIFIED FROM:
!                               (Version Dated 97064)
!                                   March 5, 1997
!
!========================================================================
!
!        Incorporates modifications for second round of Beta Testing,
!        including code clean-up and removing obsolete options.  Since
!        the urban stable boundary layer algorithm in AERMOD is still
!        under development, the keywords for implementing the urban
!        option in AERMOD have been disabled for this revised draft
!        Beta release of the model.
!                   R.W. Brode, PES, Inc., March 5, 1997
!
!        MODIFIED FROM:
!                               (Version Dated 96239)
!                                   August 26, 1996
!
!========================================================================
!
!        Includes modification to wind direction gridded profiling in
!        SUB. GRDWD, correcting a problem with wind directions backing
!        through 360 degrees.  This could result in a level of observed
!        wind direction being erroneously counted as missing.
!                   R.W. Brode, PES, Inc., August 26, 1996
!
!        MODIFIED FROM:
!                               (Version Dated 96228)
!                                   August 15, 1996
!
!========================================================================
!
!        Includes modifications for low wind/low turbulence cases.  Also
!        changed definition of "valid lower bound" to be 7zo instead of
!        20zo for consistency with recent changes to AERMET.  The terrain
!        options have also been reinstated on the CO MODELOPT card as
!        TERROPT1 and TERROPT2.  The command line developmental option
!        switch has been enabled in this version.
!                   R.W. Brode, PES, Inc., August 15, 1996
!
!        MODIFIED FROM:
!
!                               (Version Dated 96198)
!                                    July 16, 1996
!
!========================================================================
!
!        Includes Urban Boundary Layer Option based on the Model Coding
!        Abstract by Akula Ventkatram dated 4/1/96.  Modified inputs
!        include two new keywords:
!
!                 CO URBANOPT  Urbpop  (Urbnam)
!                    where Urbpop is the population of the urban area, and
!                          Urbnam is an optional character field
!                          for the name of the urban area.
!
!                 SO URBANSRC  Srcid's  and/or  Srcrng's
!                    where Srcid's identifies individual sources to be
!                          modeled as urban sources, and Srcrng's
!                          identifies a range of sources to be modeled
!                          as urban.
!
!
!        MODIFIED FROM:
!                               (Version Dated 96131)
!                                    May 10, 1996
!
!        Includes OPTG3 and OPTG4 for stable plume reflection options.
!
!        MODIFIED FROM:
!                               (Version Dated 96053)
!                                 February 22, 1996
!
!        Includes flow vector, AFV, in the EVALFILE output.
!
!        MODIFIED FROM:
!                               (Version Dated 96046)
!                                 February 15, 1996
!
!        Includes new sigma-v and sigma-w profiles coded by Bob Paine,
!        some modifications to TEMPGRID.FOR to avoid discontinuities in
!        the VPTG profile, reinstates command-line input for developmental
!        options for the Lahey version, modifies the default option settings
!        to remove stable plume reflections, reinstates the original stable
!        profile for TLz, increases the maximum number of iterations in
!        IBLVAL from 5 to 20, and includes patches for smoothed h < 0 and
!        for mixing heights at (or near) 5,000m.
!                   R.W. Brode, PES, Inc., February 15, 1996
!
!        MODIFIED FROM:
!                               (Version Dated 95272)
!
!        Includes a SCREEN mode option on CO MODELOPT card,
!        addition of AREAPOLY and AREACIRC source types,
!        and INCLUDED keyword option for including data from
!        an external file for the SO and RE pathways.  The
!        INCLUDED option is intended as a link to AERMAP and
!        for use with the screening version of AERMOD.
!
!        MODIFIED FROM:
!                               (Version Dated 95188)
!
!        Hardcoded option settings for the Beta release of AERMOD.
!
!        MODIFIED FROM:
!                               (Version Dated 95066)
!
!        "Optionized" version of AERMOD for Developmental Evaluation.
!        Developmental options are selected by use of an additional
!        10-character command line argument, e.g. '1213121111'.
!        If the additional command line argument is not present, then
!        the model will default to the Base Model.  This is equivalent
!        to using an additional command line argument of '1111111111'.
!        Note that the single quotes are not included on the command line.
!                   R.W. Brode, PES, Inc., January 27, 1995
!
!        Version 95066 includes a few minor fixes, some modifications to
!        the EVALFILE output, and the volume source option (mostly untested).
!        The fixes affect the SBL plume reflection option (OPTG2), and two of
!        the inhomogeneity options (OPTD2 and OPTD3).  In the latter cases,
!        the effective wind speed was allowed to be less than the effective
!        sigma-w.  Also, included EVALCART receptors with DISCCART receptors
!        for output purposes (RECTABLE, DAYTABLE, etc., and INPSUM.FOR).
!                   R.W. Brode, PES, Inc., February 16, 1995
!
!        Base Case Model for AERMOD Developmental Evaluation - 12/8/94
!
!        MODIFIED FROM:    ISC2 Short Term Model - ISCST2
!                               (Version Dated 93109)
!
!        MODIFIED FROM:         (Version Dated 92273)
!
!        MODIFIED FROM:         (Version Dated 92062)
!
!        PURPOSE: Controls Overall Flow and Processing of ISCST2 Model
!
!        PROGRAMMED BY: Roger W. Brode
!                       James O. Paumier
!                       Jayant A. Hardikar
!                       Pacific Environmental Services, Inc.
!                       P.O. Box 12077
!                       Research Triangle Park, North Carolina  27709
!
!        DATE:    November 9, 1993
!
!        INPUTS:  Command Line Options
!
!        OUTPUTS: Model Results
!
!========================================================================
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      INTEGER :: I , IDSTAT
      SAVE 
 
!     Variable Initializations
      MODNAM = 'MAIN'
      FATAL = .FALSE.
      RUNERR = .FALSE.
 
!     Open the Temporary File for Error Messages Generated from the Program
      OPEN (UNIT=IERUNT,FILE='ERRMSG.TMP',STATUS='REPLACE')
 
!CLC     Command line arguments removed.  Use AERMOD.INP and AERMOD.OUT.
!CLC     Retrieve Input and Output File Names From Command Line,
!CLC     ---   CALL GETCOM
!CL      CALL GETCOM (' AERMOD ',ILEN_FLD,INPFIL,OUTFIL)
 
!     Open Input and Output Files                           ---   CALL FILOPN
      CALL FILOPN
 
!     Preprocess Setup Information to Determine Data Storage Needs
      CALL PRESET
 
      IF ( .NOT.EVONLY ) THEN
!        OPEN The Temporary File to Store Events for EVENT File;
         OPEN (UNIT=ITEVUT,FILE='EVENT.TMP',STATUS='REPLACE')
!        Initialize the Event Counter
         IEVENT = 0
      ENDIF
 
!     Allocate SETUP Array Storage
      CALL ALLSETUP
 
!     Variable Initializations                              ---   CALL VARINI
      CALL VARINI
 
!     Process The Model Setup Information                   ---   CALL SETUP
      IF ( EVONLY ) THEN
         CALL EV_SETUP
      ELSE
         CALL SETUP
      ENDIF
 
!     Open file with PVMRM debugging output
      IF ( DEBUG .AND. PVMRM ) THEN
         OPEN (50,FILE='PVMRM.TXT',STATUS='REPLACE')
         WRITE (50,9001)
 9001    FORMAT (8X,'DATE',3X,'IREC SRCID',6X,'DISTDOM',4X,'MAXCONC',2X,&
     &           'NUMCONT  O3CONC',6X,'O3MOLES',5X,'NOXMOLES',4X,       &
     &           'BHORIZ',6X,'BVERT',4X,'PLUMEVOL',3X,'PercentNO2')
      ENDIF
 
!     Write the model options and debug data template to the
!     debug file if MODEL is specified
      IF ( DEBUG ) THEN
!        Write the title(s) to the debug output file
         WRITE (DBGUNT,100) TITLE1 , TITLE2
 100     FORMAT (' Title: ',A68,/'        ',A68/)
!        Write the model options (MODOPS) to the output file
         WRITE (DBGUNT,200) (MODOPS(I),I=1,18)
 200     FORMAT (' OPTIONS: ',/18(1X,A6),/)
 
         WRITE (DBGUNT,600)
 600     FORMAT (/' NOTE:  The Vert. Terms and associated',             &
     &           ' CHIs are from the LIFT calculations!!!'/)
 
      ENDIF
 
!     Open file for GDEP output from gas dry deposition algorithms
      IF ( LDGAS ) OPEN (UNIT=100,FILE='GDEP.DAT',STATUS='REPLACE')
 
!     Open file for PDEP output from particle dry deposition algorithms
      IF ( LDPART ) OPEN (UNIT=101,FILE='PDEP.DAT',STATUS='REPLACE')
 
!     Deallocate Temporary Storage
      DEALLOCATE (IWRK2,STAT=IDSTAT)
      IF ( IDSTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IDSTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
      IF ( .NOT.EVONLY ) THEN
         DEALLOCATE (ZETMP1,ZETMP2,ZHTMP1,ZHTMP2,ZFTMP1,ZFTMP2,         &
     &               STAT=IDSTAT)
         IF ( IDSTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IDSTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         ENDIF
      ENDIF
 
!     Allocate Array Storage for Results
      CALL ALLRESULT
 
!     Determine Number of Setup Messages by Message Type    ---   CALL TERRST
      CALL TERRST
 
! --- Set up common for PRIME numerical rise algorithm      ---   CALL NUMPR1
      CALL NUMPR1
 
! --- Set up common for PRIME building cavity model         ---   CALL PRIME1
      CALL PRIME1
 
      IF ( .NOT.RUN .OR. FATAL .OR. IWRN.GT.0 ) THEN
!        Write Out Summary Of Setup Error/Message Stats     ---   CALL SUMTBL
         WRITE (IOUNIT,9111)
 9111    FORMAT (//2X,'*** Message Summary For AERMOD Model Setup ***'/)
         CALL SUMTBL
      ENDIF
 
      IF ( FATAL ) THEN
         WRITE (*,99111)
99111    FORMAT ('+','Fatal Error Occurred During Setup Phase!')
         WRITE (IOUNIT,9112)
 9112    FORMAT (/4X,'**************************************',/4X,      &
     &           '*** SETUP Finishes UN-successfully ***',/4X,          &
     &           '**************************************'/)
      ELSE
         WRITE (IOUNIT,9113)
 9113    FORMAT (/1X,'***********************************',/1X,         &
     &           '*** SETUP Finishes Successfully ***',/1X,             &
     &           '***********************************'/)
      ENDIF
 
!     Print Summary of the Input Data                       ---   CALL INPSUM
      CALL INPSUM
 
!     Write Headers to GDEP.DAT and PDEP.DAT Files for new deposition algorithms
      IF ( LDGAS ) THEN
         WRITE (100,9901)
 9901    FORMAT (1X,'YYMMDDHH',3X,'ISRC',4X,'Ra',12X,'Rb',12X,'Rc',12X, &
     &           'Vdepg')
      ENDIF
      IF ( LDPART ) THEN
         WRITE (101,9902)
 9902    FORMAT (1X,'YYMMDDHH',3X,'ISRC',1X,'ICAT',2X,'Method No.',3X,  &
     &           'Ra',12X,'Rp',12X,'Vg(i)',9x,'Vdep(i)')
      ENDIF
 
      IF ( .NOT.FATAL .AND. RUN .AND. EVONLY ) THEN
!        No Fatal Errors in Setup and RUN Option Selected and EVENT Processing
 
!        Process The Data For Each Event                    ---   CALL EVLOOP
         CALL EVLOOP
 
      ELSEIF ( .NOT.FATAL .AND. RUN .AND. .NOT.EVONLY ) THEN
!        No Fatal Errors in Setup and RUN Option Selected and Normal Processing
 
!        Reinitialize Results Arrays With Zeroes            ---   CALL RESINI
         CALL RESINI
 
!           Initialize Results Arrays from Re-start File    ---   CALL RSINIT
         IF ( RSTINP ) CALL RSINIT
 
!        Process The Hourly Meteorological Data             ---   CALL HRLOOP
         CALL HRLOOP
 
         IF ( (ANNUAL .OR. PM10AVE) .AND. .NOT.RUNERR ) THEN
!           Compute averages of the high-fourth-high 24-hr and annual values
            IF ( NUMYRS.GT.0 ) THEN
               DO IGRP = 1 , NUMGRP
                  DO IREC = 1 , NUMREC
                     IF ( PM10AVE ) SUMH4H(IREC,IGRP)                   &
     &                    = SUMH4H(IREC,IGRP)/NUMYRS
                     IF ( ANNUAL ) THEN
                        DO ITYP = 1 , NUMTYP
                           ANNVAL(IREC,IGRP,ITYP)                       &
     &                        = SUMANN(IREC,IGRP,ITYP)/NUMYRS
                        ENDDO
                     ENDIF
                  ENDDO
               ENDDO
            ELSE
!              Write Error Message: Number of Years = 0.
               CALL ERRHDL(PATH,MODNAM,'E','480','NUMYRS=0')
               RUNERR = .TRUE.
            ENDIF
            IF ( NREMAIN.NE.0 ) THEN
!              Write Warning Message: Met Data Remains After End of Last Year
               WRITE (DUMMY,'(I8)') NREMAIN
               CALL ERRHDL(PATH,MODNAM,'W','485',DUMMY)
            ENDIF
         ENDIF
 
         IF ( (PERIOD .OR. ANNUAL) .AND. (.NOT.RUNERR) .AND.            &
     &        NTOTHRS.GT.0 ) THEN
!           PERIOD Average Selected and No Runtime/Meteorology Errors
!              Calculate Period Average Concentrations      ---   CALL PERAVE
            IF ( CONC .AND. PERIOD ) CALL PERAVE
            DO ITYP = 1 , NUMTYP
!              Select Highest PERIOD Values by Source Group ---   CALL HIPER
               CALL HIPER
            ENDDO
!              Write PERIOD/ANNUAL Results to Post File     ---   CALL PSTANN
            IF ( ANPOST ) CALL PSTANN
!              Write PERIOD/ANNUAL Results to Plot File     ---   CALL PLTANN
            IF ( ANPLOT ) CALL PLTANN
         ENDIF
 
         IF ( SEASONHR .AND. .NOT.RUNERR ) THEN
            IF ( CONC ) CALL SHAVE
         ENDIF
 
!           Write Short Term High Values to Plot File       ---   CALL PLOTFL
         IF ( PLFILE .AND. (.NOT.RUNERR) ) CALL PLOTFL
 
!           Print Out Model Results                         ---   CALL OUTPUT
         IF ( .NOT.RUNERR ) CALL OUTPUT
 
      ENDIF
 
      CALL HEADER
      WRITE (IOUNIT,9114)
 9114 FORMAT (/1X,'*** Message Summary : AERMOD Model Execution ***'/)
!     Determine Number of Errors/Messages by Message Type   ---   CALL TERRST
      CALL TERRST
!     Write Summary of Message Stats for Model Execution    ---   CALL SUMTBL
      CALL SUMTBL
 
      IF ( FATAL .OR. RUNERR ) THEN
         WRITE (IOUNIT,9115)
 9115    FORMAT (/4X,'***************************************',/4X,     &
     &           '*** AERMOD Finishes UN-successfully ***',/4X,         &
     &           '***************************************'/)
      ELSE
         WRITE (IOUNIT,9116)
 9116    FORMAT (/4X,'************************************',/4X,        &
     &           '*** AERMOD Finishes Successfully ***',/4X,            &
     &           '************************************'/)
      ENDIF
 
      IF ( ERRLST ) THEN
!        OPEN and Write Out Permanent Error Message File    ---   CALL MSGWRT
         OPEN (UNIT=IERWRT,FILE=MSGFIL,STATUS='REPLACE',                &
     &         FORM='FORMATTED')
         CALL MSGWRT
         CLOSE (IERWRT)
      ENDIF
 
!     Close and Delete The Error Message And EVENT Temporary Files
      CLOSE (IERUNT,STATUS='DELETE')
      CLOSE (ITEVUT,STATUS='DELETE')
 
      CONTINUE
      END
!*==HRLOOP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HRLOOP
!***********************************************************************
!                 HRLOOP Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Controls Main Calculation Loop Through
!                 Hourly Meteorological Data
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:  To include the PVMRM and OLM options for
!                   modeling conversion of NOx to NO2.
!                   R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!        MODIFIED:  To incorporate modifications to date processing
!                   for Y2K compliance, including use of date window
!                   variables (ISTRT_WIND and ISTRT_CENT) and calculation
!                   of 10-digit date variable (FULLDATE) with 4-digit
!                   year for date comparisons.
!                   Also modified to include SCIM option.
!                   R.W. Brode, PES, Inc., 5/12/99
!
!        MODIFIED:  To correct problems with the post-1997 PM10
!                   calculations involving leap years, and to
!                   add the year to the status message.
!                   R.W. Brode, PES, Inc. - 12/2/98
!
!        MODIFIED:  Changes to accommodate the post-1997 PM10
!                   calculations for average H4H 24-hour averages
!                   and ANNUAL averages.
!                   R.W. Brode, PES, Inc. - 8/14/98
!
!        MODIFIED:  Minor change to logic of IF block to correct
!                   potential problem with STARTEND keyword for
!                   non-sequential meteorological data sets.
!                   R.W. Brode, PES, Inc. - 4/22/96
!
!        MODIFIED:  To Include TOXXFILE Option - 9/29/92
!
!        INPUTS:  Source, Receptor and Setup Options
!
!        OUTPUTS: Update Hourly Results
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      INTEGER :: IEND_DAY , I , J , K , L , M , ILSAVE
      REAL :: RDUM
      REAL :: O3VALUES(24) , O3MIN , O3MAX24
!     Initialize O3VALUES array to 40 ppb (78.4 ug/m^3) for first day
      DATA O3VALUES/24*78.4/
      SAVE 
 
!     Variable Initializations
      MODNAM = 'HRLOOP'
      EOF = .FALSE.
      KURDAT = 0
      FULLDATE = 0
      NTOTHRS = 0
 
!     Begin Hourly LOOP
      DO WHILE ( FULLDATE.LT.IEDATE .AND. .NOT.EOF )
!        Retrieve One Hour of Meteorology                   ---   CALL METEXT
         CALL METEXT
 
         IF ( FULLDATE.LE.IEDATE .AND. .NOT.EOF ) THEN
!           Increment counter for total number of hours
            NTOTHRS = NTOTHRS + 1
         ELSE
!           Exit hourly loop
            GOTO 200
         ENDIF
 
!        Save ILINE as ILSAVE and Initialize ILINE
         ILSAVE = ILINE
         ILINE = 0
 
!        Process Hourly Emissions from File
!        Begin Source Loop
         DO ISRC = 1 , NUMSRC
!*             Retrieve Source Parameters for This Hour     ---   CALL HRQEXT
            IF ( QFLAG(ISRC).EQ.'HOURLY' ) CALL HRQEXT(ISRC)
         ENDDO
!*       End Source Loop
!*----
!        Retrive ILINE From ILSAVE
         ILINE = ILSAVE
 
         IF ( PVMRM .OR. OLM ) THEN
!-----      Read Ozone Data File if available
            IF ( O3FILE ) THEN
               CALL O3EXT
               IF ( .NOT.O3MISS ) THEN
                  O3VALUES(IHOUR) = O3CONC
               ELSE
                  O3VALUES(IHOUR) = 0.0
               ENDIF
!-----         Apply minimum O3 value for stable hours; O3CONC is in ug/m^3
               IF ( STABLE ) THEN
!                 Use min of 40 ppb (78.4ug/m3) and max from previous 24 hrs
                  O3MAX24 = MIN(78.40,MAXVAL(O3VALUES))
!                 Adjust minimum O3 value based on OBULEN
                  IF ( OBULEN.GT.0.0 .AND. OBULEN.LE.50.0 ) THEN
                     O3MIN = O3MAX24
                  ELSEIF ( OBULEN.GT.250.0 ) THEN
                     O3MIN = 0.0
                  ELSE
                     O3MIN = O3MAX24*(250.-OBULEN)/200.
                  ENDIF
                  O3CONC = MAX(O3CONC,O3MIN)
               ENDIF
            ELSE
               O3CONC = O3BACK
            ENDIF
 
         ENDIF
 
!*----   ISCSTM Modification: allow for NOCHKD option - jah 11/2/94
!*       Check for IHOUR = 1 and Write Update to the Screen For PC Version
         IF ( (IHOUR.EQ.1 .OR. ILINE.EQ.1) .AND. .NOT.NOCHKD ) THEN
!*          Write Out Update to the Screen by Julian Day
            WRITE (*,909) JDAY , IYR
 909        FORMAT ('+','Now Processing Data For Day No. ',I4,' of ',I4)
         ELSEIF ( NOCHKD ) THEN
!*          Write Out Update to the Screen by Hour
            WRITE (*,910) KURDAT
 910        FORMAT ('+','Now Processing Data For     ',I8.8)
         ENDIF
!*----
!*#
         IF ( SCIM .AND. .NOT.EOF ) THEN
            SCIMHR = .FALSE.
            WETHR = .FALSE.
 
!           User has specified SCIM option.  Check for whether current
!           hour is to be sampled, and whether to write sampled met
!           data to output file.
 
!           Keep track of total no. of hours.
!           Also, keep track of dry & wet, and calm & missing hours
!           Note:  Under SCIM option, IANHRS/IANCLM/IANMSG (see below) pertain
!                  to no. of hours sampled.
            NSKIPTOT = NSKIPTOT + 1
            IF ( PRATE.GT.0.0 ) THEN
               NSKIPWET = NSKIPWET + 1
            ELSE
               NSKIPDRY = NSKIPDRY + 1
            ENDIF
 
            IF ( CLMHR .AND. CLMPRO ) THEN
!              Check for Calm Hr & Processing and Increment Counters
               IF ( PRATE.GT.0.0 ) THEN
                  NSWETCLM = NSWETCLM + 1
               ELSE
                  NSDRYCLM = NSDRYCLM + 1
               ENDIF
            ELSEIF ( MSGHR .AND. MSGPRO ) THEN
!              Check for Missing Hour & Processing and Increment Counters
               IF ( PRATE.GT.0.0 ) THEN
                  NSWETMSG = NSWETMSG + 1
               ELSE
                  NSDRYMSG = NSDRYMSG + 1
               ENDIF
            ENDIF
 
            IF ( ILINE.LE.24 .AND. IHOUR.EQ.NREGSTART ) THEN
!              Current hour is to be sampled - first SCIM'd hour.
               IFIRSTHR = ILINE
               SCIMHR = .TRUE.
               IF ( WETSCIM .AND. PRATE.GT.0.0 ) THEN
                  NWETHR = NWETHR + 1
                  IF ( FIRSTWET .AND. NWETHR.EQ.NWETSTART ) THEN
                     FIRSTWET = .FALSE.
                     WETHR = .TRUE.
                     NWETHR = 0
                  ELSEIF ( NWETHR.EQ.NWETINT ) THEN
                     WETHR = .TRUE.
                     NWETHR = 0
                  ENDIF
               ENDIF
            ELSEIF ( ILINE.GT.NREGSTART .AND.                           &
     &               MOD(ILINE-IFIRSTHR,NREGINT).EQ.0 ) THEN
!              Current hour is to be sampled - SCIM'd hour
               SCIMHR = .TRUE.
               IF ( WETSCIM .AND. PRATE.GT.0.0 ) THEN
                  NWETHR = NWETHR + 1
                  IF ( FIRSTWET .AND. NWETHR.EQ.NWETSTART ) THEN
                     FIRSTWET = .FALSE.
                     WETHR = .TRUE.
                     NWETHR = 0
                  ELSEIF ( NWETHR.EQ.NWETINT ) THEN
                     WETHR = .TRUE.
                     NWETHR = 0
                  ENDIF
               ENDIF
            ELSEIF ( WETSCIM .AND. PRATE.GT.0.0 .AND.                   &
     &               (DEPOS .OR. WDEP .OR. WDPLETE) ) THEN
               NWETHR = NWETHR + 1
               IF ( FIRSTWET .AND. NWETHR.EQ.NWETSTART ) THEN
!                 Current hour is to be sampled
                  FIRSTWET = .FALSE.
                  WETHR = .TRUE.
                  NWETHR = 0
               ELSEIF ( NWETHR.EQ.NWETINT ) THEN
!                 Current hour is to be sampled
                  WETHR = .TRUE.
                  NWETHR = 0
               ELSE
!                 Current hour is NOT to be sampled. Check for end of year first.
                  CALL CHK_ENDYR
                  GOTO 100
               ENDIF
            ELSE
!              Current hour is NOT to be sampled. Check for end of year first.
               CALL CHK_ENDYR
               GOTO 100
            ENDIF
 
!              Write sampled meteorology to SCIM'd met data file
            IF ( SCIMOUT ) CALL METSUM
         ENDIF
 
         IF ( FULLDATE.GT.ISDATE .AND. FULLDATE.LE.IEDATE .AND.         &
     &        IPROC(JDAY).EQ.1 .AND. .NOT.EOF .AND. .NOT.RUNERR ) THEN
 
            IF ( CLMHR .AND. CLMPRO ) THEN
!              Check for Calm Hr & Processing and Increment Counters
               DO IAVE = 1 , NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
                  NUMCLM(IAVE) = NUMCLM(IAVE) + 1
               ENDDO
               IF ( PERIOD .OR. ANNUAL ) THEN
                  IF ( .NOT.SCIM .OR. (SCIM .AND. SCIMHR) ) THEN
                     IANHRS = IANHRS + 1
                     IANCLM = IANCLM + 1
                  ENDIF
                  IF ( SCIM .AND. WETHR ) THEN
                     IANWET = IANWET + 1
                     IWETCLM = IWETCLM + 1
                  ENDIF
               ENDIF
               IF ( SEASONHR ) THEN
                  NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR) + 1
                  NSEACM(ISEAS,IHOUR) = NSEACM(ISEAS,IHOUR) + 1
               ENDIF
            ELSEIF ( MSGHR .AND. MSGPRO ) THEN
!              Check for Missing Hour & Processing and Increment Counters
               DO IAVE = 1 , NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
                  NUMMSG(IAVE) = NUMMSG(IAVE) + 1
               ENDDO
               IF ( PERIOD .OR. ANNUAL ) THEN
                  IF ( .NOT.SCIM .OR. (SCIM .AND. SCIMHR) ) THEN
                     IANHRS = IANHRS + 1
                     IANMSG = IANMSG + 1
                  ENDIF
                  IF ( SCIM .AND. WETHR ) THEN
                     IANWET = IANWET + 1
                     IWETMSG = IWETMSG + 1
                  ENDIF
               ENDIF
               IF ( SEASONHR ) THEN
                  NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR) + 1
                  NSEACM(ISEAS,IHOUR) = NSEACM(ISEAS,IHOUR) + 1
               ENDIF
            ELSEIF ( ZI.LE.0 ) THEN
!              Write Out The Informational Message & Increment Counters
               WRITE (DUMMY,'(I8.8)') KURDAT
               CALL ERRHDL(PATH,MODNAM,'I','470',DUMMY)
               DO IAVE = 1 , NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
               ENDDO
               IF ( PERIOD .OR. ANNUAL ) THEN
                  IF ( .NOT.SCIM .OR. (SCIM .AND. SCIMHR) )             &
     &                 IANHRS = IANHRS + 1
                  IF ( SCIM .AND. WETHR ) IANWET = IANWET + 1
               ENDIF
               IF ( SEASONHR ) NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR)&
     &              + 1
            ELSE
!              Set CALCS Flag, Increment Counters & Calculate HRVAL
               CALCS = .TRUE.
               DO IAVE = 1 , NUMAVE
                  NUMHRS(IAVE) = NUMHRS(IAVE) + 1
               ENDDO
               IF ( PERIOD .OR. ANNUAL ) THEN
                  IF ( .NOT.SCIM .OR. (SCIM .AND. SCIMHR) )             &
     &                 IANHRS = IANHRS + 1
                  IF ( SCIM .AND. WETHR ) IANWET = IANWET + 1
               ENDIF
               IF ( SEASONHR ) NSEAHR(ISEAS,IHOUR) = NSEAHR(ISEAS,IHOUR)&
     &              + 1
 
!              Time/Date Marker for DEBUG Output
               IF ( DEBUG ) THEN
                  WRITE (DBGUNT,*)
                  WRITE (DBGUNT,*) '--------------------------------' , &
     &                             '--------------------'
                  WRITE (DBGUNT,*) '---  JDAY, IHOUR =  ' , JDAY , IHOUR
                  WRITE (DBGUNT,*) '--------------------------------' , &
     &                             '--------------------'
               ENDIF
 
!              Calculate CONC or DEPOS Values               ---   CALL CALC
               CALL CALC
            ENDIF
 
            IF ( PVMRM .AND. .NOT.O3MISS .AND. .NOT.CLMHR .AND.         &
     &           .NOT.MSGHR ) THEN
! ---          Process Hourly Values for PVMRM Option
               CALL PVMRM_CALC
            ELSEIF ( OLM .AND. .NOT.O3MISS .AND. .NOT.CLMHR .AND.       &
     &               .NOT.MSGHR ) THEN
! ---          Process Hourly Values for OLM Option
               CALL OLM_CALC
            ENDIF
 
!           Begin Averaging Period LOOP
            DO IAVE = 1 , NUMAVE
!              Check for End of Averaging Period
               IF ( MOD(IHOUR,KAVE(IAVE)).EQ.0 .OR.                     &
     &              (KAVE(IAVE).EQ.720 .AND. ENDMON) ) THEN
!                    Calculate Applicable Averages          ---   CALL AVER
                  IF ( CONC ) CALL AVER
!                 Update High Value Arrays                  ---   CALL HIVALS
                  CALL HIVALS
                  IF ( DAYTAB .AND. IDYTAB(IAVE).EQ.1 ) THEN
                     DO ITYP = 1 , NUMTYP
!                       Print Out Daily Value Tables        ---   CALL PRTDAY
                        CALL PRTDAY
                     ENDDO
                  ENDIF
!                    Write Max Values (>Thresh) to File     ---   CALL MAXFIL
                  IF ( MXFILE ) CALL MAXFIL
!                    Write Values to Postprocessor File     ---   CALL POSTFL
                  IF ( PPFILE ) CALL POSTFL
!                    Write Values to TOXXFILE File (9/29/92) ---  CALL TOXXFL
                  IF ( TXFILE ) CALL TOXXFL
!                 Flush Block Average Values in AVEVAL Array for This IAVE
                  DO ITYP = 1 , NUMTYP
                     DO IGRP = 1 , NUMGRP
                        DO IREC = 1 , NUMREC
                           AVEVAL(IREC,IGRP,IAVE,ITYP) = 0.0
                        ENDDO
                     ENDDO
                  ENDDO
               ENDIF
            ENDDO
!           End Averaging Period LOOP
 
            IF ( RSTSAV .AND. IHOUR.EQ.24 ) THEN
               NDAYS = NDAYS + 1
               IF ( NDAYS.EQ.INCRST ) THEN
!                 Save Results to File for Later Re-start   ---   CALL RSDUMP
                  CALL RSDUMP
                  NDAYS = 0
               ENDIF
            ENDIF
 
!           Flush HRVAL Arrays
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = 0.0
               HRVALD(ITYP) = 0.0
               AERVAL(ITYP) = 0.0
               AERVALD(ITYP) = 0.0
               PRMVAL(ITYP) = 0.0
               PRMVALD(ITYP) = 0.0
            ENDDO
 
            IF ( PVMRM .OR. OLM ) THEN
!              Flush CHI Array
               DO ITYP = 1 , NUMTYP
                  DO ISRC = 1 , NUMSRC
                     DO IREC = 1 , NUMREC
                        CHI(IREC,ISRC,ITYP) = 0.0
                     ENDDO
                  ENDDO
               ENDDO
            ENDIF
 
         ENDIF
 
!        Check for end of year of data for post-1997 PM10 processing
 
 
         IF ( (PM10AVE .OR. ANNUAL) .AND. FULLDATE.GT.ISDATE .AND.      &
     &        .NOT.EOF ) CALL CHK_ENDYR
 
!        Reset CALCS and ENDMON Flags
         CALCS = .FALSE.
         ENDMON = .FALSE.
 
!        Save precipitation rates for two previous hours
         PREC2 = PREC1
         PREC1 = PRATE
 
 100  ENDDO
!     End Hourly LOOP
 
!     Check for TOXXFILE Option, Fill Buffer and Dump to File - 9/29/92
 200  IF ( TXFILE ) THEN
         IDUM = 0
         RDUM = 0.0
         DO IAVE = 1 , NUMAVE
            IF ( ITOXFL(IAVE).EQ.1 ) THEN
!              Fill Rest of Buffer With Zeroes and Write to TOXXFILE
               DO I = IPAIR + 1 , NPAIR
                  IDCONC(IAVE,I) = IDUM
                  TXCONC(IAVE,I) = RDUM
               ENDDO
               WRITE (ITXUNT(IAVE)) (IDCONC(IAVE,I),I=1,NPAIR)
               WRITE (ITXUNT(IAVE)) (TXCONC(IAVE,I),I=1,NPAIR)
               CLOSE (ITXUNT(IAVE))
            ENDIF
         ENDDO
      ENDIF
 
!     Write Out Update to the Screen for PC Version
      WRITE (*,919)
 919  FORMAT ('+','Now Processing Output Options               ')
 
      CONTINUE
      END
!*==JULIAN.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE JULIAN(INYR,INMN,INDY,JDY)
!***********************************************************************
!                 JULIAN Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE:    CONVERT YR/MN/DY DATE TO JULIAN DAY (1-366),
!                    INCLUDES TEST FOR 100 AND 400 YEAR CORRECTIONS TO
!                    HANDLE 4 DIGIT YEARS BEYOND 2099 AND BEFORE 1901
!                    (WILL WORK WITH 2 DIGIT YR FOR PERIOD 1901-2099)
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:     YEAR,  INYR (2 OR 4 DIGIT)
!                    MONTH, INMN
!                    DAY,   INDY
!
!        OUTPUT:     JULIAN DAY,  JDY (1-366)
!
!        CALLED FROM:   DAYRNG
!
!        ERROR HANDLING:   Checks for Invalid Month or Day
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: NDAY(12) , IDYMAX(12)
      INTEGER :: INYR , INMN , INDY , JDY
 
!     Variable Initializations
      DATA NDAY/0 , 31 , 59 , 90 , 120 , 151 , 181 , 212 , 243 , 273 ,  &
     &     304 , 334/
      DATA IDYMAX/31 , 29 , 31 , 30 , 31 , 30 , 31 , 31 , 30 , 31 , 30 ,&
     &     31/
      MODNAM = 'JULIAN'
      JDY = 0
 
!     Check for 2-digit Year Input and WRITE Warning Message
!        WRITE Warning Message  ! Routine Will Work for Years 1901-2099
      IF ( INYR.LT.100 ) CALL ERRHDL(PATH,MODNAM,'W','360',KEYWRD)
 
!     Check for Invalid Month or Day
      IF ( INMN.LT.1 .OR. INMN.GT.12 ) THEN
!        WRITE Error Message    ! Invalid Month
         CALL ERRHDL(PATH,MODNAM,'E','203','MONTH')
         RUNERR = .TRUE.
         GOTO 999
      ELSEIF ( INDY.GT.IDYMAX(INMN) ) THEN
!        WRITE Error Message    ! Invalid Day
         CALL ERRHDL(PATH,MODNAM,'E','203','DAY')
         RUNERR = .TRUE.
         GOTO 999
      ENDIF
 
!     Determine JULIAN Day Number; For Non-Leap Year First
      IF ( (MOD(INYR,4).NE.0) .OR.                                      &
     &     (MOD(INYR,100).EQ.0 .AND. MOD(INYR,400).NE.0) ) THEN
!        Not a Leap Year
         IF ( INMN.NE.2 .OR. (INMN.EQ.2 .AND. INDY.LE.28) ) THEN
            JDY = INDY + NDAY(INMN)
         ELSE
!           WRITE Error Message    ! Invalid Date; 2/29 in a Non-Leap Year
            WRITE (DUMMY,'("YR= ",I4)') INYR
            CALL ERRHDL(PATH,MODNAM,'E','370',DUMMY)
            JDY = 60
            RUNERR = .TRUE.
         ENDIF
      ELSE
!        Leap Year
         JDY = INDY + NDAY(INMN)
         IF ( INMN.GT.2 ) JDY = JDY + 1
      ENDIF
 
 999  CONTINUE
 
      CONTINUE
      END
!*==GREGOR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GREGOR(INYR,INMN,JDY,IDY)
!***********************************************************************
!                 GREGOR Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE:    CONVERT JULIAN DAY (1-366) TO DAY OF MONTH,
!                    INCLUDES TEST FOR 100 AND 400 YEAR CORRECTIONS TO
!                    HANDLE 4 DIGIT YEARS BEYOND 2099 AND BEFORE 1901
!                    (WILL WORK WITH 2 DIGIT YR FOR PERIOD 1901-2099)
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:     YEAR,       INYR (2 OR 4 DIGIT)
!                    MONTH,      INMN
!                    JULIAN DAY, JDY (1-366)
!
!        OUTPUT:     DAY OF MONTH, IDY
!
!        CALLED FROM:   METEXT
!
!        ERROR HANDLING:   Checks for Invalid Month or Day
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: NDAY(12)
      INTEGER :: INYR , INMN , IDY , JDY
 
!     Variable Initializations
      DATA NDAY/0 , 31 , 59 , 90 , 120 , 151 , 181 , 212 , 243 , 273 ,  &
     &     304 , 334/
      MODNAM = 'GREGOR'
 
!     Check for Invalid Month or Julian Day
      IF ( INMN.LT.1 .OR. INMN.GT.12 ) THEN
!        WRITE Error Message    ! Invalid Month
         CALL ERRHDL(PATH,MODNAM,'E','203','MONTH')
         GOTO 999
      ELSEIF ( JDY.LT.1 .OR. JDY.GT.366 ) THEN
!        WRITE Error Message    ! Invalid Julian Day
         CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
         GOTO 999
      ENDIF
 
!     Determine Day-of-Month Number; For Non-Leap Year First
      IF ( (MOD(INYR,4).NE.0) .OR.                                      &
     &     (MOD(INYR,100).EQ.0 .AND. MOD(INYR,400).NE.0) ) THEN
!        Not a Leap Year
         IDY = JDY - NDAY(INMN)
      ELSE
!        Leap Year
         IDY = JDY - NDAY(INMN)
         IF ( INMN.GT.2 ) IDY = IDY - 1
      ENDIF
 
 999  CONTINUE
 
      CONTINUE
      END
!*==HRQEXT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HRQEXT(IS)
!***********************************************************************
!*                  HRQEXT Module of AERMOD
!*
!*         PURPOSE: To Assign Hourly Source Parameters
!*
!*         PROGRAMMER:  Jayant Hardikar, Roger Brode
!*
!*         DATE:    September 15, 1993
!*
!*         INPUTS:  Variable QFLAG and Current Source Number Being Processed
!*
!*         OUTPUTS: Source Arrays
!*
!*         MODIFIED:  REMOVED THE 'POINT' SOURCE CONDITION, SO IT APPLIES
!*                    TO ALL SOURCE TYPES, EXCEPT SAVING THE TEMP & VEL
!*
!*         CALLED FROM:  HRLOOP
!************************************************************************
!*
!*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IS , IHYEAR , IHMON , IHDAY , IHHOUR
      CHARACTER RDFRM*20
 
      CHARACTER*8 HRSOID
 
!*    Variable Initializations
      MODNAM = 'HRQEXT'
!*
!*    READ Record to Buffers, A80 and 80A1
!*    Length of ISTRG is Set in PARAMETER Statement in MAIN1
!     Setup READ format and ECHO format for runstream record,
!     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE (RDFRM,9100) ISTRG , ISTRG
 9100 FORMAT ('(A',I3.3,',T1,',I3.3,'A1)')
      READ (IHREMI,RDFRM,ERR=99,END=999) RUNST1 , (RUNST(I),I=1,ISTRG)
!*
!*    Convert Lower Case to Upper Case Letters              ---   CALL LWRUPR
      CALL LWRUPR
!*
!*    Define Fields on Card                                 ---   CALL DEFINE
      CALL DEFINE
!*
!*    Get the Contents of the Fields                        ---   CALL GETFLD
      CALL GETFLD
!*
!*    Check for number of fields - error if less than 7.
      IF ( IFC.LT.7 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','201','HOUREMIS')
         RUNERR = .TRUE.
         GOTO 999
      ENDIF
!*
!*    Assign the Fields to Local Varables and Check The Numerical Field
!*
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
      IHYEAR = NINT(FNUM)
      IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
      IHMON = NINT(FNUM)
      IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
      CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
      IHDAY = NINT(FNUM)
      IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
      CALL STONUM(FIELD(6),ILEN_FLD,FNUM,IMIT)
      IHHOUR = NINT(FNUM)
      IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
      HRSOID = FIELD(7)
 
      IF ( IFC.GE.8 ) THEN
         CALL STONUM(FIELD(8),ILEN_FLD,HRQS,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSE
!*       Emission rate is missing - set to zero
         HRQS = 0.0
      ENDIF
 
      IF ( SRCTYP(IS).EQ.'POINT' .AND. IFC.EQ.10 ) THEN
!*       Also Assign Exit Temperature and Exit Velocity
 
         CALL STONUM(FIELD(9),ILEN_FLD,HRTS,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
         CALL STONUM(FIELD(10),ILEN_FLD,HRVS,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
      ELSEIF ( SRCTYP(IS).EQ.'POINT' ) THEN
!*       Some missing parameters - assign zeros to all
         HRTS = 0.0
         HRVS = 0.0
      ENDIF
 
!*    Check for Date and Time Consistency ; If Failed, Issue Fatal Error
      KURHRQ = IHYEAR*1000000 + IHMON*10000 + IHDAY*100 + IHHOUR
      IF ( KURDAT.NE.KURHRQ ) THEN
!*       WRITE Error Message - Date mismatch
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'E','455',DUMMY)
         RUNERR = .TRUE.
      ENDIF
 
 
!*    Check for Source ID Consistency ; If Failed - Abort Program
      IF ( HRSOID.NE.SRCID(IS) ) THEN
         WRITE (DUMMY,'(A8)') SRCID(IS)
         CALL ERRHDL(PATH,MODNAM,'E','342',SRCID(IS))
         RUNERR = .TRUE.
      ENDIF
 
!*    Assign the Hourly Emission Parameters to the Stack Variables
      AQS(IS) = HRQS
 
      IF ( SRCTYP(IS).EQ.'POINT' ) THEN
         ATS(IS) = HRTS
         AVS(IS) = HRVS
      ENDIF
 
 
!*    Perform QA Error Checking on Source Parameters
!*
 
      IF ( SRCTYP(IS).EQ.'POINT' ) THEN
         IF ( ATS(IS).EQ.0.0 ) THEN
!*          Set Temperature to Small Negative Value for Ambient Releases
            ATS(IS) = -1.0E-5
         ELSEIF ( ATS(IS).GT.2000.0 ) THEN
!*          WRITE Informational Message:  Exit Temp. > 2000K
            CALL ERRHDL(PATH,MODNAM,'I','320','HRTS')
         ENDIF
 
         IF ( AVS(IS).LT.0.0 ) THEN
!*          WRITE Informational Message:  Negative or Zero Exit Velocity
            CALL ERRHDL(PATH,MODNAM,'I','325','HRVS')
!*          Set to Small Value to Avoid Zero-divide and Underflow
            AVS(IS) = 1.0E-5
         ELSEIF ( AVS(IS).LT.1.0E-5 ) THEN
!*          Set to Small Value to Avoid Zero-divide and Underflow
            AVS(IS) = 1.0E-5
         ELSEIF ( AVS(IS).GT.50.0 ) THEN
!*          WRITE Informational Message:  Exit Velocity > 50.0 m/s
            CALL ERRHDL(PATH,MODNAM,'I','320','HRVS')
         ENDIF
      ENDIF
 
      GOTO 999
 
!*    Write Error Message for Error Reading Hourly Emissions File
 99   CALL ERRHDL(PATH,MODNAM,'E','510','HOUREMIS')
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==O3EXT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE O3EXT
!***********************************************************************
!*                  O3EXT Module of AERMOD
!*
!*         PURPOSE: To extract hourly ozone data for PVMRM and OLM options
!*
!*         PROGRAMMER:  Roger W. Brode, PES, Inc.
!*
!*         DATE:    May 6, 2002
!*
!*         INPUTS:
!*
!*         OUTPUTS:
!*
!*         CALLED FROM:  HRLOOP
!************************************************************************
!*
!*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IO3YR , IO3MN , IO3DY , IO3HR , KURO3HR
 
!*    Variable Initializations
      MODNAM = 'O3EXT'
!*
      IF ( O3FORM.EQ.'FREE' ) THEN
         READ (IO3UNT,*,ERR=99,END=999) IO3YR , IO3MN , IO3DY , IO3HR , &
     &                                  O3CONC
      ELSE
         READ (IO3UNT,O3FORM,ERR=99,END=999) IO3YR , IO3MN , IO3DY ,    &
     &         IO3HR , O3CONC
      ENDIF
 
!*    Check for Date and Time Consistency ; If Failed, Issue Fatal Error
      KURO3HR = IO3YR*1000000 + IO3MN*10000 + IO3DY*100 + IO3HR
      IF ( KURDAT.NE.KURO3HR ) THEN
!*       WRITE Error Message - Date mismatch
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'E','457',DUMMY)
         RUNERR = .TRUE.
      ENDIF
 
      IF ( O3CONC.GE.900.0 .OR. O3CONC.LT.0.0 ) THEN
!        Hourly ozone value is missing, check for background value
!        from OZONEVAL card
         IF ( O3BACK.GE.0.0 ) THEN
!           Write informational message about substitution
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'I','458',DUMMY)
            O3CONC = O3BACK
            O3MISS = .FALSE.
!           Skip to end since O3BACK units have already been converted to ug/m3
            GOTO 999
         ELSE
!           Write informational message about missing data and use of full conversion
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'I','459',DUMMY)
            O3MISS = .TRUE.
            GOTO 999
         ENDIF
      ELSE
!        Hourly ozone data not missing
         O3MISS = .FALSE.
      ENDIF
 
      IF ( O3FILUNITS.EQ.'PPB' ) THEN
         O3CONC = (O3CONC/1000.)*1960.
      ELSEIF ( O3FILUNITS.EQ.'PPM' ) THEN
         O3CONC = O3CONC*1960.
      ENDIF
 
      GOTO 999
 
!*    Write Error Message for Error Reading Hourly Emissions File
 99   CALL ERRHDL(PATH,MODNAM,'E','510','OZONEFIL')
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==ERRHDL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ERRHDL(PATHWY,MODNAM,INERTP,INERCD,INPMSG)
!***********************************************************************
!                 ERRHDL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: A General Error Handling Procedure
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Error Code, Occur Locations
!
!        OUTPUTS: Error Message, Error Statistics..etc.
!
!        CALLED FROM:  (This Is An Utility Programm)
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
 
      SAVE 
      INTEGER :: I
      CHARACTER ERRMG1*50 , PATHWY*2 , INERTP*1 , INERCD*3 , ICODE*3 ,  &
     &          INPMSG*(*) , MODNAM*(*) , TMPMOD*6 , TMPMSG*8
      LOGICAL FIND
 
!     Variable Initializations
      IERROR = IERROR + 1
      FIND = .FALSE.
      I = 1
 
!     Check for Occurrence of 'E' Error Type, and Set FATAL Switch
      IF ( INERTP.EQ.'E' ) THEN
         FATAL = .TRUE.
         NFATAL = NFATAL + 1
         IF ( NFATAL.EQ.999 ) THEN
!           Number Of Fatal Errors Has Reached Limit of 999
            ERRMG1 = 'Number of Fatal Errors Has Reached Limit of 999'
            TMPMOD = 'ERRHDL'
            ICODE = '999'
            TMPMSG = ' '
            WRITE (IERUNT,1111) PATHWY , INERTP , ICODE , ILINE ,       &
     &                          TMPMOD , ERRMG1 , TMPMSG
            GOTO 999
         ELSEIF ( NFATAL.GT.999 ) THEN
!           Skip Any More Error WRITEs
            GOTO 999
         ENDIF
      ENDIF
 
!     Go To Match The Error Massage
      DO WHILE ( .NOT.FIND .AND. I.LE.IERRN )
         IF ( INERCD.EQ.ERRCOD(I) ) THEN
            ERRMG1 = ERRMSG(I)
            FIND = .TRUE.
         ENDIF
         I = I + 1
      ENDDO
 
      IF ( .NOT.FIND ) THEN
         WRITE (ERRMG1,1001)
 1001    FORMAT ('SYSTEM ERROR: MESSAGE NOT FOUND FOR THIS NUMBER!')
      ENDIF
 
!     Write Out The Error Message
      WRITE (IERUNT,1111) PATHWY , INERTP , INERCD , ILINE , MODNAM(1:6)&
     &                    , ERRMG1 , INPMSG
 
 999  CONTINUE
 1111 FORMAT (A2,1X,A1,A3,I6,1X,A6,':',A50,1X,A8)
      END
!*==TERRST.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE TERRST
!***********************************************************************
!                 TERRST Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Determine Total Error/Message Statistics
!
!        PROGRAMMER:  Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Error Message Temporary File
!
!        OUTPUTS: Total Number of Messages by Message Type
!
!        CALLED FROM:  This is A Utility Program
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IERRLN
      CHARACTER ERRTP*1 , ERRCD*3 , ERRMG1*50 , ERRMG2*8 , INPFLD*3
 
!     Variable Initialization
      MODNAM = 'TERRST'
      IFTL = 0
      IWRN = 0
      INFO = 0
      ICLM = 0
      IMSG = 0
      IHEZ = 0
      EOF = .FALSE.
 
!     Rewind the Temporary Error/Message File
      REWIND IERUNT
 
      DO WHILE ( .NOT.EOF )
         READ (IERUNT,1116,END=99,ERR=9999) PATH , ERRTP , ERRCD ,      &
     &         IERRLN , MODNAM , ERRMG1 , ERRMG2
 
 1116    FORMAT (A2,1X,A1,A3,I6,1X,A6,1X,A50,1X,A8)
 
!        Sort Error Group And Find The Index
         INPFLD = ERRCD
         CALL STONUM(INPFLD,3,FNUM,IMIT)
 
         IF ( ERRTP.EQ.'E' ) THEN
            IFTL = IFTL + 1
         ELSEIF ( ERRTP.EQ.'W' ) THEN
            IWRN = IWRN + 1
         ELSEIF ( ERRTP.EQ.'I' ) THEN
            INFO = INFO + 1
!              Message for Calm Hour, Increment Calm Counter
            IF ( NINT(FNUM).EQ.440 ) ICLM = ICLM + 1
!              Message for Missing Hour, Increment Missing Hour Counter
            IF ( NINT(FNUM).EQ.460 ) IMSG = IMSG + 1
!              Message for HE > ZI, Increment Counter
            IF ( NINT(FNUM).EQ.283 ) IHEZ = IHEZ + 1
         ENDIF
 
         GOTO 11
 99      EOF = .TRUE.
 11      CONTINUE
      ENDDO
 
!     Use BACKSPACE To Reposition Temporary Error Message File Ahead of EOF;
!     This Is Needed in Order To Allow For Additional Message Writes
      BACKSPACE IERUNT
 
      GOTO 1000
 
!     WRITE Error Message: Error Reading Temp Error Message File
 9999 CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')
 
 1000 CONTINUE
      END
!*==SUMTBL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SUMTBL
!***********************************************************************
!                 SUMTBL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Print Out The Error Summary Table
!
!        PROGRAMMER:  Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Error Message Temporary File
!
!        OUTPUTS: Summary Of Errors
!
!        CALLED FROM:  This is A Utility Program
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: PERCENT
      INTEGER :: J , IERRLN
      CHARACTER ERRTP*1 , ERRCD*3 , ERRMG1*50 , ERRMG2*8
 
!     Variable Initialization
      MODNAM = 'SUMTBL'
 
!     Write Out The Total Error Statistics
      WRITE (IOUNIT,*) ' --------- Summary of Total Messages --------'
      WRITE (IOUNIT,*) ' '
      WRITE (IOUNIT,9014) IFTL
 9014 FORMAT (' A Total of   ',I10,' Fatal Error Message(s)')
      WRITE (IOUNIT,9015) IWRN
 9015 FORMAT (' A Total of   ',I10,' Warning Message(s)')
      WRITE (IOUNIT,9016) INFO
 9016 FORMAT (' A Total of   ',I10,' Informational Message(s)')
      IF ( NTOTHRS.GT.0 ) THEN
         WRITE (IOUNIT,9017) ICLM
 9017    FORMAT (/,' A Total of   ',I10,' Calm Hours Identified')
!        Calculate percentage of missing hours, and check for > 10 percent.
         PERCENT = 100.*(FLOAT(IMSG)/FLOAT(NTOTHRS))
         WRITE (IOUNIT,9018) IMSG , PERCENT
 9018    FORMAT (/,' A Total of   ',I10,' Missing Hours Identified (',  &
     &           F6.2,' Percent)')
         IF ( PERCENT.GT.10.0 ) THEN
            WRITE (IOUNIT,9019)
 9019       FORMAT (/,' CAUTION!:  Number of Missing Hours Exceeds 10 ',&
     &              'Percent of Total!',/,12X,'Data May Not Be ',       &
     &              'Acceptable for Regulatory Applications.',/,12X,    &
     &              'See Section 5.3.2 of "Meteorological Monitoring ', &
     &              'Guidance',/,12X,'for Regulatory Modeling ',        &
     &              'Applications" (EPA-454/R-99-005).')
         ENDIF
      ENDIF
      IF ( IHEZ.GT.0 ) THEN
         WRITE (IOUNIT,9020) IHEZ
 9020    FORMAT (/,' A Total of   ',I10,                                &
     &           ' Cases Identified with HE > ZI')
      ENDIF
      WRITE (IOUNIT,*) ' '
 
!     Write Out All The Fatal Error Messages
      WRITE (IOUNIT,*) ' '
      WRITE (IOUNIT,*) '   ******** FATAL ERROR MESSAGES ******** '
      REWIND IERUNT
      EOF = .FALSE.
      J = 0
      DO WHILE ( .NOT.EOF )
         READ (IERUNT,1116,END=99,ERR=9999) PATH , ERRTP , ERRCD ,      &
     &         IERRLN , MODNAM , ERRMG1 , ERRMG2
         IF ( ERRTP.EQ.'E' ) THEN
            J = J + 1
            WRITE (IOUNIT,1117) PATH , ERRTP , ERRCD , IERRLN ,         &
     &                          MODNAM(1:6) , ERRMG1 , ERRMG2
         ENDIF
         GOTO 11
 99      EOF = .TRUE.
 11      CONTINUE
      ENDDO
 
!     If No Fatal Error Messages, Then Write 'NONE'
      IF ( J.EQ.0 ) THEN
         WRITE (IOUNIT,*) '              ***  NONE  ***         '
         WRITE (IOUNIT,*) ' '
      ENDIF
 
!     Write Out All The Warning Messages
      WRITE (IOUNIT,*) ' '
      WRITE (IOUNIT,*) '   ********   WARNING MESSAGES   ******** '
      REWIND IERUNT
      EOF = .FALSE.
      J = 0
      DO WHILE ( .NOT.EOF )
         READ (IERUNT,1116,END=999,ERR=9999) PATH , ERRTP , ERRCD ,     &
     &         IERRLN , MODNAM , ERRMG1 , ERRMG2
         IF ( ERRTP.EQ.'W' ) THEN
            J = J + 1
            IF ( .NOT.NOWARN ) THEN
               IF ( J.LE.999 ) THEN
                  WRITE (IOUNIT,1117) PATH , ERRTP , ERRCD , IERRLN ,   &
     &                                MODNAM(1:6) , ERRMG1 , ERRMG2
               ELSE
                  WRITE (IOUNIT,*) 'More Than 999 Warning Messages ' ,  &
     &                             'Found.  See ERRORFIL Output for' ,  &
     &                             ' the Remainder.'
                  EOF = .TRUE.
               ENDIF
            ENDIF
         ENDIF
         GOTO 111
 999     EOF = .TRUE.
 111     CONTINUE
      ENDDO
 
!     If No Warning Messages, Then Write 'NONE'
      IF ( J.EQ.0 ) THEN
         WRITE (IOUNIT,*) '              ***  NONE  ***        '
         WRITE (IOUNIT,*) ' '
      ELSEIF ( NOWARN ) THEN
         WRITE (IOUNIT,*) ' ** WARNINGS SUPPRESSED BY NOWARN OPTION **'
         WRITE (IOUNIT,*) ' '
      ENDIF
 
!     Use BACKSPACE To Reposition Temporary Error Message File Ahead of EOF;
!     This Is Needed in Order To Allow For Additional Message Writes
      BACKSPACE IERUNT
 
      GOTO 1000
 
!     WRITE Error Message: Error Reading Temp Error Message File
 9999 CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')
 
 1000 CONTINUE
 
 1116 FORMAT (A2,1X,A1,A3,I6,1X,A6,1X,A50,1X,A8)
 1117 FORMAT (1X,A2,1X,A1,A3,I6,1X,A6,':',A50,1X,A8)
      END
!*==MSGWRT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MSGWRT
!***********************************************************************
!                 MSGWRT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Print Out The Error Summary Table
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Error Message File
!
!        OUTPUTS: The Error Message File
!
!        CALLED FROM:  This is A Utility Program
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IERRLN
      CHARACTER ERRTP*1 , ERRCD*3 , ERRMG1*50 , ERRMG2*8
 
!     Variable Initialization
      MODNAM = 'MSGWRT'
 
!     Write Out The Header Of The Message File
      WRITE (IERWRT,*) ' '
      WRITE (IERWRT,*)                                                  &
     &                '   ************ Error Message List *************'
      WRITE (IERWRT,*) ' '
      WRITE (IERWRT,*)                                                  &
     &                '   PW     --- Pathway                           '
      WRITE (IERWRT,*)                                                  &
     &                '   Code   --- Error Type + Error Code           '
      WRITE (IERWRT,*)                                                  &
     &                '   L#     --- The Line Number Where Error Occurs'
      WRITE (IERWRT,*)                                                  &
     &                '   ModNam --- Module Name In Which Error Occurs '
      WRITE (IERWRT,*)                                                  &
     &                '   Hints  --- Hints For The Possible Solution   '
      WRITE (IERWRT,*)                                                  &
     &                '   *********************************************'
      WRITE (IERWRT,*) ' '
      WRITE (IERWRT,1114)
 1114 FORMAT ('PW CODE   L#  MODNAM ',18X,'ERROR MESSAGES',20X,'HINTS')
      WRITE (IERWRT,1115)
 1115 FORMAT ('-- ---- ----- ------ ',50('-'),' --------')
      WRITE (IERWRT,*) ' '
      REWIND IERUNT
      EOF = .FALSE.
 
      DO WHILE ( .NOT.EOF )
         READ (IERUNT,1116,END=99,ERR=999) PATH , ERRTP , ERRCD ,       &
     &         IERRLN , MODNAM , ERRMG1 , ERRMG2
 
 1116    FORMAT (A2,1X,A1,A3,I6,1X,A6,1X,A50,1X,A8)
         WRITE (IERWRT,1117) PATH , ERRTP , ERRCD , IERRLN , MODNAM(1:6)&
     &                       , ERRMG1 , ERRMG2
 1117    FORMAT (A2,1X,A1,A3,I6,1X,A6,':',A50,1X,A8)
         GOTO 11
 99      EOF = .TRUE.
 11      CONTINUE
      ENDDO
 
      GOTO 1000
 
!     WRITE Error Message: Error Reading Temp Error Message File
 999  CALL ERRHDL(PATH,MODNAM,'E','510','ERRORMSG')
 
 1000 CONTINUE
      END
!*==PNPOLY.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!----------------------------------------------------------------------
!     Courtesy: Jay Sandhu
!               email: jsandhu@esri.com
!
!
! Please cite David H. Douglas, COLLECTED ALGORITHMS, Cambridge MA:
! Harvard Laboratory for Computer Graphics, 1974
!
! This is my reinvention buster.
! 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974 1974
!
!>>>PNPY
!     .................................................................
!
!        SUBROUTINE PNPOLY
!
!        PURPOSE
!           TO DETERMINE WHETHER A POINT IS INSIDE A POLYGON
!
!        USAGE
!           CALL PNPOLY (PX, PY, X, Y, N, INOUT )
!
!        DESCRIPTION OF THE PARAMETERS
!           PX      - X-COORDINATE OF POINT IN QUESTION.
!           PY      - Y-COORDINATE OF POINT IN QUESTION.
!           X       - N LONG VECTOR CONTAINING X-COORDINATES OF
!                     VERTICES OF POLYGON.
!           Y       - N LONG VECTOR CONTAINING Y-COORDINATES OF
!                     VERTICES OF POLYGON.
!           N       - NUMBER OF VERTICES IN THE POLYGON.
!           INOUT   - THE SIGNAL RETURNED:
!                     -1 IF THE POINT IS OUTSIDE OF THE POLYGON,
!                      0 IF THE POINT IS ON AN EDGE OR AT A VERTEX,
!                      1 IF THE POINT IS INSIDE OF THE POLYGON.
!
!        REMARKS
!           THE VERTICES MAY BE LISTED IN CLOCKWISE OR ANTICLOCKWISE
!           ORDER.  FOR THIS SUBROUTINE A POINT IS CONSIDERED INSIDE
!           THE POLYGON IF IT IS LOCATED IN THE ENCLOSED AREA DEFINED
!           BY THE LINE FORMING THE POLYGON.
!           THE INPUT POLYGON MAY BE A COMPOUND POLYGON CONSISTING
!           OF SEVERAL SEPARATE SUBPOLYGONS. IF SO, THE FIRST VERTEX
!           OF EACH SUBPOLYGON MUST BE REPEATED, AND WHEN CALCULATING
!           N, THESE FIRST VERTICES MUST BE COUNTED TWICE.
!           INOUT IS THE ONLY PARAMETER WHOSE VALUE IS CHANGED.
!           PNPOLY CAN HANDLE ANY NUMBER OF VERTICES IN THE POLYGON.
!           WRITTEN BY RANDOLPH FRANKLIN, UNIVERSITY OF OTTAWA, 6/72.
!
!        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
!           NONE
!
!        METHOD
!           A VERTICAL SEMI-INFINITE LINE IS DRAWN UP FROM THE POINT
!           IN QUESTION. IF IT CROSSES THE POLYGON AN ODD NUMBER OF
!           TIMES, THE POINT IS INSIDE THE POLYGON.
!
!     .................................................................
!
      SUBROUTINE PNPOLY(PX,PY,X,Y,N,INOUT)
 
      IMPLICIT NONE
 
      INTEGER I , J , N , INOUT
      REAL X(N) , Y(N) , XI , YI , XJ , YJ , PX , PY
      LOGICAL IX , IY , JX , JY , EOR
 
!     EXCLUSIVE OR STATEMENT FUNCTION.
      EOR(IX,IY) = (IX .OR. IY) .AND. .NOT.(IX .AND. IY)
 
      INOUT = -1
 
      DO I = 1 , N
         XI = X(I) - PX
         YI = Y(I) - PY
!        CHECK WHETHER THE POINT IN QUESTION IS AT THIS VERTEX.
         IF ( XI.EQ.0.0 .AND. YI.EQ.0.0 ) THEN
            INOUT = 0
            RETURN
         ENDIF
!        J IS NEXT VERTEX NUMBER OF POLYGON.
         J = 1 + MOD(I,N)
         XJ = X(J) - PX
         YJ = Y(J) - PY
!        IS THIS LINE OF 0 LENGTH ?
         IF ( XI.EQ.XJ .AND. YI.EQ.YJ ) GOTO 100
         IX = XI.GE.0.0
         IY = YI.GE.0.0
         JX = XJ.GE.0.0
         JY = YJ.GE.0.0
!        CHECK WHETHER (PX,PY) IS ON VERTICAL SIDE OF POLYGON.
         IF ( XI.EQ.0.0 .AND. XJ.EQ.0.0 .AND. EOR(IY,JY) ) THEN
            INOUT = 0
            RETURN
         ENDIF
!        CHECK WHETHER (PX,PY) IS ON HORIZONTAL SIDE OF POLYGON.
         IF ( YI.EQ.0.0 .AND. YJ.EQ.0.0 .AND. EOR(IX,JX) ) THEN
            INOUT = 0
            RETURN
         ENDIF
!        CHECK WHETHER BOTH ENDS OF THIS SIDE ARE COMPLETELY 1) TO RIGHT
!        OF, 2) TO LEFT OF, OR 3) BELOW (PX,PY).
         IF ( .NOT.((IY .OR. JY) .AND. EOR(IX,JX)) ) GOTO 100
!        DOES THIS SIDE OBVIOUSLY CROSS LINE RISING VERTICALLY FROM (PX,PY)
         IF ( .NOT.(IY .AND. JY .AND. EOR(IX,JX)) ) THEN
            IF ( (YI*XJ-XI*YJ)/(XJ-XI).LT.0.0 ) THEN
               GOTO 100
            ELSEIF ( (YI*XJ-XI*YJ)/(XJ-XI).EQ.0.0 ) THEN
               INOUT = 0
               RETURN
            ELSE
               INOUT = -INOUT
            ENDIF
         ELSE
            INOUT = -INOUT
         ENDIF
 
 100  ENDDO
 
      CONTINUE
      END
!*==ALLSETUP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ALLSETUP
!***********************************************************************
!                 ALLSETUP Module
!
!        PURPOSE: Allocate Array Storage for SETUP
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    September 21, 1996
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!        CALLED FROM:  MAIN
!
!        ERROR HANDLING:   Checks for error allocating arrays
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      INTEGER :: IASTAT
      SAVE 
 
!     Variable Initializations
      MODNAM = 'ALLSET'
 
!DEP     &           V(NTYP), VDRY(NTYP),
      ALLOCATE (KAVE(NAVE),CHRAVE(NAVE),CHIDEP(6,NTYP),OUTTYP(NTYP),    &
     &          STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
! --- PRIME Modification -------------------------------------------
! ------------------------------------------------------------------
      ALLOCATE (AXS(NSRC),AYS(NSRC),AZS(NSRC),AQS(NSRC),AHS(NSRC),      &
     &          ATS(NSRC),AVS(NSRC),ADS(NSRC),ASYINI(NSRC),ASZINI(NSRC),&
     &          NDXSTK(NSRC),ADSBH(NSEC,NSRC),ADSBW(NSEC,NSRC),         &
     &          ADSBL(NSEC,NSRC),ADSXADJ(NSEC,NSRC),ADSYADJ(NSEC,NSRC), &
     &          INPD(NSRC),EVAL(NSRC),QFACT(NQF,NSRC),EMIFAC(NTYP),     &
     &          STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      ALLOCATE (APDIAM(NPDMAX,NSRC),APHI(NPDMAX,NSRC),                  &
     &          APDENS(NPDMAX,NSRC),AVGRAV(NPDMAX,NSRC),                &
     &          ATSTOP(NPDMAX,NSRC),EFRAC(NPDMAX),QPART(NPDMAX),        &
     &          STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      ALLOCATE (PDIAM(NPDMAX),PHI(NPDMAX),PDENS(NPDMAX),VGRAV(NPDMAX),  &
     &          TSTOP(NPDMAX),SCHMIDT(NPDMAX),VDEP(NPDMAX),SCF(NPDMAX), &
     &          WQCOR(NPDMAX),DQCOR(NPDMAX),PSCVRT(NPDMAX),             &
     &          WASHOUT(NPDMAX),STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      ALLOCATE (IGROUP(NSRC,NGRP),SRCID(NSRC),SRCTYP(NSRC),SOPCRD(NSRC),&
     &          SOGAS(NSRC),GRPID(NGRP),QFLAG(NSRC),EMILBL(NTYP),       &
     &          OUTLBL(NTYP),PERLBL(NTYP),AXINIT(NSRC),AYINIT(NSRC),    &
     &          AANGLE(NSRC),AXVERT(NVMAX,NSRC),AYVERT(NVMAX,NSRC),     &
     &          AALPHA(NSRC),APDEFF(NSRC),AVOLUM(NSRC),RADIUS(NSRC),    &
     &          NVERTS(NSRC),AXCNTR(NSRC),AYCNTR(NSRC),URBSRC(NSRC),    &
     &          PDIFF(NSRC),PDIFFW(NSRC),RMOLWT(NSRC),ALPHAS(NSRC),     &
     &          REACT(NSRC),HENRY(NSRC),RCLI(NSRC),FINEMASS(NSRC),      &
     &          L_METHOD2(NSRC),STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      IF ( EVONLY ) THEN
         ALLOCATE (EV_HRQS(NSRC,NHR),EV_HRTS(NSRC,NHR),EV_HRVS(NSRC,NHR)&
     &             ,STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         ENDIF
      ENDIF
 
      IF ( .NOT.EVONLY ) THEN
         ALLOCATE (AXR(NREC),AYR(NREC),AZELEV(NREC),AZFLAG(NREC),       &
     &             AZHILL(NREC),IREF(NREC),NETID(NREC),RECTYP(NREC),    &
     &             NDXARC(NREC),ARCID(NARC),NTID(NNET),NTTYP(NNET),     &
     &             XCOORD(IXM,NNET),YCOORD(IYM,NNET),XORIG(NNET),       &
     &             YORIG(NNET),NETSTA(NNET),NETEND(NNET),NUMXPT(NNET),  &
     &             NUMYPT(NNET),STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         ENDIF
      ENDIF
 
      IF ( EVONLY ) THEN
         ALLOCATE (EVAPER(NEVE),EVDATE(NEVE),EVJDAY(NEVE),IDXEV(NEVE),  &
     &             AXR(NEVE),AYR(NEVE),AZELEV(NEVE),AZFLAG(NEVE),       &
     &             AZHILL(NEVE),EVNAME(NEVE),EVGRP(NEVE),STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         ENDIF
      ENDIF
 
      ALLOCATE (NHIAVE(NVAL,NAVE),MAXAVE(NAVE),IMXVAL(NAVE),IDYTAB(NAVE)&
     &          ,MAXFLE(NGRP,NAVE),IPSTFL(NGRP,NAVE),                   &
     &          IPLTFL(NVAL,NGRP,NAVE),IANPST(NGRP),IANPLT(NGRP),       &
     &          INHI(NAVE),ITOXFL(NAVE),IRNKFL(NAVE),IRKVAL(NAVE),      &
     &          THRESH(NGRP,NAVE),TOXTHR(NAVE),IMXUNT(NGRP,NAVE),       &
     &          IPSUNT(NGRP,NAVE),IPSFRM(NGRP,NAVE),                    &
     &          IPLUNT(NVAL,NGRP,NAVE),IAPUNT(NGRP),IANFRM(NGRP),       &
     &          IPPUNT(NGRP),ITXUNT(NAVE),IRKUNT(NAVE),IELUNT(NSRC),    &
     &          THRFIL(NGRP,NAVE),PSTFIL(NGRP,NAVE),                    &
     &          PLTFIL(NVAL,NGRP,NAVE),ANNPST(NGRP),ANNPLT(NGRP),       &
     &          TOXFIL(NAVE),RNKFIL(NAVE),EVLFIL(NSRC),ISEAHR(NGRP),    &
     &          SEAHRS(NGRP),ISHUNT(NGRP),STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      ALLOCATE (IDCONC(NAVE,NPAIR),TXCONC(NAVE,NPAIR),STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      ALLOCATE (WORKID(NSRC),IWRK2(NSRC,13),STAT=IASTAT)
      IF ( IASTAT.NE.0 ) THEN
         WRITE (DUMMY,'(I8)') IASTAT
         CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
      ENDIF
 
      IF ( .NOT.EVONLY ) THEN
         ALLOCATE (ZETMP1(NREC),ZETMP2(NREC),ZHTMP1(NREC),ZHTMP2(NREC), &
     &             ZFTMP1(NREC),ZFTMP2(NREC),STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         ENDIF
      ENDIF
 
      IF ( PVMRM .OR. OLM ) THEN
         ALLOCATE (ANO2_RATIO(NSRC),CHI(NREC,NSRC,NTYP),STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
         ENDIF
         IF ( PVMRM ) THEN
            ALLOCATE (HECNTR(NREC,NSRC),HECNTR3(NREC,NSRC),             &
     &                UEFFS(NREC,NSRC),UEFF3S(NREC,NSRC),               &
     &                FOPTS(NREC,NSRC),PPFACT(NSRC),STAT=IASTAT)
            IF ( IASTAT.NE.0 ) THEN
               WRITE (DUMMY,'(I8)') IASTAT
               CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
            ENDIF
         ENDIF
         IF ( OLM ) THEN
            ALLOCATE (OLMID(NOLM),L_OLMGRP(NSRC),IGRP_OLM(NSRC,NOLM),   &
     &                STAT=IASTAT)
            IF ( IASTAT.NE.0 ) THEN
               WRITE (DUMMY,'(I8)') IASTAT
               CALL ERRHDL(PATH,MODNAM,'E','298',DUMMY)
            ENDIF
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==ALLRESULT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ALLRESULT
!***********************************************************************
!                 ALLRESULT Module
!
!        PURPOSE: Allocate Array Storage for Results
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    September 21, 1996
!
!        MODIFIED:   Changed parameter for allocating the number of
!                    high annual/period averages from NHIVAL to NHIANN.
!                    R.W. Brode, PES, Inc.,  4/3/98
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!        CALLED FROM:  MAIN
!
!        ERROR HANDLING:   Checks for error allocating arrays
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      INTEGER :: IASTAT
      SAVE 
 
!     Variable Initializations
      MODNAM = 'ALLRESULT'
 
!     NARC was initially set to NREC prior to SETUP, now set NARC = NUMARC
      NARC = NUMARC
 
      ALLOCATE (HRVAL(NUMTYP),HRVALD(NUMTYP),HRVALJD(NUMTYP,NPDMAX),    &
     &          AERVAL(NUMTYP),PRMVAL(NUMTYP),AERVALD(NUMTYP),          &
     &          PRMVALD(NUMTYP),STAT=IASTAT)
 
      ALLOCATE (ARCMAX(NARC),QMAX(NARC),DXMAX(NARC),UMAX(NARC),         &
     &          SVMAX(NARC),SWMAX(NARC),SYMAX(NARC),SY3MX(NARC),        &
     &          U3MAX(NARC),HEMAX(NARC),ARCCL(NARC),SZMAX(NARC),        &
     &          CHIDMW(NARC),CHINMW(NARC),CHI3MW(NARC),CHIDML(NARC),    &
     &          CHINML(NARC),CHI3ML(NARC),HSBLMX(NARC),STAT=IASTAT)
 
      IF ( .NOT.EVONLY ) THEN
         ALLOCATE (AVEVAL(NUMREC,NUMGRP,NUMAVE,NUMTYP),                 &
     &             HIVALU(NUMREC,NHIVAL,NUMGRP,NUMAVE,NUMTYP),          &
     &             HMAX(NHIVAL,NUMGRP,NUMAVE,NUMTYP),                   &
     &             HMLOC(NHIVAL,NUMGRP,NUMAVE,NUMTYP),                  &
     &             HMDATE(NHIVAL,NUMGRP,NUMAVE,NUMTYP),                 &
     &             NHIDAT(NUMREC,NHIVAL,NUMGRP,NUMAVE,NUMTYP),          &
     &             STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         ENDIF
 
         ALLOCATE (ANNVAL(NUMREC,NUMGRP,NUMTYP),                        &
     &             ANNVALD(NUMREC,NUMGRP,NUMTYP),                       &
     &             ANNVALW(NUMREC,NUMGRP,NUMTYP),                       &
     &             AMXVAL(NHIANN,NUMGRP,NUMTYP),                        &
     &             IMXLOC(NHIANN,NUMGRP,NUMTYP),                        &
     &             ANNVALJD(NUMREC,NUMGRP,NUMTYP,NPDMAX),               &
     &             ANNVALJW(NUMREC,NUMGRP,NUMTYP,NPDMAX),               &
     &             RMXVAL(NMXVAL,NUMGRP,NUMAVE,NUMTYP),                 &
     &             MXDATE(NMXVAL,NUMGRP,NUMAVE,NUMTYP),                 &
     &             MXLOCA(NMXVAL,NUMGRP,NUMAVE,NUMTYP),NUMHRS(NUMAVE),  &
     &             NUMCLM(NUMAVE),NUMMSG(NUMAVE),                       &
     &             SHVALS(NUMREC,NUMGRP,4,24,NUMTYP),STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         ENDIF
 
         ALLOCATE (HCLMSG(NUMREC,NHIVAL,NUMGRP,NUMAVE,NUMTYP),          &
     &             MCLMSG(NMXVAL,NUMGRP,NUMAVE,NUMTYP),                 &
     &             HMCLM(NHIVAL,NUMGRP,NUMAVE,NUMTYP),STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         ENDIF
 
         ALLOCATE (SUMANN(NUMREC,NUMGRP,NUMTYP),SUMH4H(NUMREC,NUMGRP),  &
     &             MXPMVAL(NMXPM,NUMGRP),MXPMLOC(NMXPM,NUMGRP),         &
     &             STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         ENDIF
      ENDIF
 
      IF ( EVONLY ) THEN
         ALLOCATE (EV_AVEVAL(NSRC),HRVALS(NHR,NSRC),GRPVAL(NHR),        &
     &             STAT=IASTAT)
         IF ( IASTAT.NE.0 ) THEN
            WRITE (DUMMY,'(I8)') IASTAT
            CALL ERRHDL(PATH,MODNAM,'E','299',DUMMY)
         ENDIF
      ENDIF
 
 
      CONTINUE
      END
!*==DATIME.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!CLC  Note that SUBROUTINE GETCOM is no longer called to retrieve
!CLC  the command line arguments.  The input and output filenames
!CLC  hardwired by the model as AERMOD.INP and AERMOD.OUT, respectively.
!CL      SUBROUTINE GETCOM (MODEL,LENGTH,INPFIL,OUTFIL)
!CLC***********************************************************************
!CLC
!CLC        GETCOM Module of the AMS/EPA Regulatory Model - AERMOD
!CLC
!CLC        PURPOSE: Controls Retrieving Input and Output File Names From
!CLC                 the Command Line for PCs
!CLC
!CLC        PROGRAMMER: Roger Brode
!CLC
!CLC        DATE:    March 2, 1992
!CLC
!CLC        MODIFIED:   To use ILEN_FLD (passed in as LENGTH) to define
!CLC                    the length of the INPFIL and OUTFIL variables,
!CLC                    and to specify length of the command line as
!CLC                    a PARAMETER, initially set to 150.  Also set up
!CLC                    conditional compilation statements (commented out)
!CLC                    to facilitate compilation by Compaq Visual Fortran.
!CLC                    R.W. Brode, PES, Inc. - 12/2/98
!CLC
!CLC        MODIFIED:   Jayant Hardikar, PES, Inc.
!CLC                    - Length of command line for Lahey version changed
!CLC                      from 80 to 120 characters - 4/19/93
!CLC                    - Adapted for DEPMET/PMERGE - 7/29/94
!CLC
!CLC        INPUTS:  Command Line
!CLC
!CLC        OUTPUTS: Input Runstream File Name
!CLC                 Output Print File Name
!CLC
!CLC        CALLED FROM:   MAIN
!CLC***********************************************************************
!CLC
!CLC     Variable Declarations
!CLC     For compilation with Compaq Visual Fortran Compiler, delete the string
!CLC     'CCVF' from columns 1-4 in this subroutine (using a null replacement).
!CLC     This will allow the Compaq compiler to conditionally compile the
!CLC     appropriate code for retrieving the command line arguments.
!CL!DEC$ DEFINE CVF
!CL!DEC$ IF DEFINED (CVF)
!CL      USE DFLIB
!CL!DEC$ ENDIF
!CL      IMPLICIT NONE
!CL
!CL      INTEGER LENGTH
!CL      CHARACTER (LEN=LENGTH) :: INPFIL, OUTFIL
!CL      CHARACTER (LEN=8)      :: MODEL
!CL!DEC$ IF DEFINED (CVF)
!CLC     Declare 2-Byte Integer for Field Number of Command Line Argument
!CL      INTEGER*2 IARG, IFCNT, ISTAT
!CL!DEC$ ELSEIF DEFINED (LAHEY)
!CLC     Declare the COMLIN Variable to Hold Contents of Command Line for Lahey
!CL      INTEGER , PARAMETER :: LENCL = 150
!CL      CHARACTER (LEN=LENCL) :: COMLIN
!CL      INTEGER LOCB(LENCL), LOCE(LENCL), I, IFCNT
!CL      LOGICAL INFLD
!CL
!CL      COMLIN = ' '
!CL!DEC$ ENDIF
!CL
!CL!DEC$ IF DEFINED (CVF)
!CLC************************************************************CVF START
!CLC     Use Microsoft/DEC Functions NARGS and GETARG To Retrieve
!CLC     Contents of Command Line
!CL      IFCNT = NARGS()
!CLC     IFCNT Is The Number Of Arguments on Command Line Including Program
!CL      IF (IFCNT .NE. 3) THEN
!CLC        Error on Command Line.  Write Error Message and STOP
!CL         WRITE(*,660) MODEL
!CL         STOP
!CL      ELSE
!CLC        Retrieve First Argument as Input File Name
!CL         IARG = 1
!CL         CALL GETARG(IARG,INPFIL,ISTAT)
!CLC        Retrieve Second Argument as Output File Name
!CL         IARG = 2
!CL         CALL GETARG(IARG,OUTFIL,ISTAT)
!CL      END IF
!CLC************************************************************CVF STOP
!CL
!CL!DEC$ ELSEIF DEFINED (LAHEY)
!CLC************************************************************LAHEY START
!CLC     Use Lahey Function GETCL To Retrieve Contents of Command Line.
!CLC     Retrieve Input and Output File Names From the COMLIN Variable.
!CL      CALL GETCL(COMLIN)
!CL      INFLD = .FALSE.
!CL      IFCNT = 0
!CL      DO I = 1, LENCL
!CL         IF (.NOT.INFLD .AND. COMLIN(I:I) .NE. ' ') THEN
!CL            INFLD = .TRUE.
!CL            IFCNT = IFCNT + 1
!CL            LOCB(IFCNT) = I
!CL         ELSE IF (INFLD .AND. COMLIN(I:I) .EQ. ' ') THEN
!CL            INFLD = .FALSE.
!CL            LOCE(IFCNT) = I - 1
!CL         END IF
!CL      END DO
!CL      IF (IFCNT .NE. 2) THEN
!CLC        Error on Command Line.  Write Error Message and STOP
!CL         WRITE(*,660) MODEL
!CL         STOP
!CL      END IF
!CL      INPFIL = COMLIN(LOCB(1):LOCE(1))
!CL      OUTFIL = COMLIN(LOCB(2):LOCE(2))
!CLC************************************************************LAHEY STOP
!CL
!CL!DEC$ ENDIF
!CL
!CL  660 FORMAT (' COMMAND LINE ERROR: ',A8,' input_file output_file')
!CL
!CL      RETURN
!CL      END
 
 
      SUBROUTINE DATIME(DCALL,TCALL)
!***********************************************************************
!                 DATIME Module
!
!        PURPOSE: Obtain the system date and time
!
!        PROGRAMMER: Jim Paumier, PES, Inc.
!
!        DATE:    April 15, 1994
!
!        MODIFIED:   Uses Fortran 90 DATE_AND_TIME routine.
!                    R.W. Brode, PES, 8/14/98
!
!        INPUTS:  none
!
!        OUTPUTS: Date and time in character format
!
!        CALLED FROM:  RUNTIME
!***********************************************************************
!
!     Variable Declarations
      IMPLICIT NONE
 
      CHARACTER DCALL*8 , TCALL*8
      CHARACTER CDATE*8 , CTIME*10 , CZONE*5
      INTEGER :: IDATETIME(8)
      INTEGER :: IPTYR , IPTMON , IPTDAY , IPTHR , IPTMIN , IPTSEC
 
      DCALL = ' '
      TCALL = ' '
 
!     Call Fortran 90 date and time routine
      CALL DATE_AND_TIME(CDATE,CTIME,CZONE,IDATETIME)
 
!     Convert year to two digits and store array variables
      IPTYR = IDATETIME(1) - 100*INT(IDATETIME(1)/100)
      IPTMON = IDATETIME(2)
      IPTDAY = IDATETIME(3)
      IPTHR = IDATETIME(5)
      IPTMIN = IDATETIME(6)
      IPTSEC = IDATETIME(7)
 
!     Write Date and Time to Character Variables, DCALL & TCALL
      WRITE (DCALL,'(2(I2.2,"/"),I2.2)') IPTMON , IPTDAY , IPTYR
      WRITE (TCALL,'(2(I2.2,":"),I2.2)') IPTHR , IPTMIN , IPTSEC
 
      CONTINUE
      END
!*==FILOPN.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE FILOPN
!***********************************************************************
!                 FILOPN Module
!
!        PURPOSE: Obtain the system date and time
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    December 6, 1994
!
!        INPUTS:  Input filename, INPFIL
!                 Output filename, OUTFIL
!
!        OUTPUTS: Openned files
!
!        CALLED FROM:  HEADER
!
!        ERROR HANDLING:   Checks errors openning files
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     OPEN Input Runstream File, Unit INUNIT=7
      DUMMY = 'RUN-STRM'
!CLC     Remove command line input filename and use AERMOD.INP
!CL      OPEN (UNIT=INUNIT,FILE=INPFIL,ERR=99,STATUS='OLD')
      OPEN (UNIT=INUNIT,FILE='aermod.inp',ERR=99,STATUS='OLD')
 
!     OPEN Print Output File, Unit IOUNIT=8
      DUMMY = 'OUTPUT'
!LF90 The CARRIAGECONTROL specifier in the following statement is a
!LF90 non-standard Lahey language extension (also supported by DEC VF),
!LF90 and may need to be removed for portability of the code.
!CLC     Remove command line output filename and use AERMOD.OUT
!CL      OPEN (UNIT=IOUNIT,FILE=OUTFIL,CARRIAGECONTROL='FORTRAN',
!JRA comment out OPEN and set IOUNIT to 6 to facilitate PB05 validation
!      OPEN (UNIT=IOUNIT,FILE='AERMOD.OUT',ERR=99,STATUS='REPLACE')
      IOUNIT = 6
 
!     Write Out Update to the Screen
      WRITE (*,909)
 909  FORMAT ('+','Now Processing SETUP Information')
 
      GOTO 1000
 
!     WRITE Error Message:  Error Opening File
 99   CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)
 
!     Check for Error Opening Runstream File and STOP
      IF ( DUMMY.EQ.'RUN-STRM' ) THEN
         WRITE (*,919)
 919     FORMAT ('+','Error Opening Runstream Input File!  Aborting.')
         STOP
      ENDIF
 
 1000 CONTINUE
 
      CONTINUE
      END
!*==HEADER.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HEADER
!***********************************************************************
!                 HEADER Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Control Page Feed and Header Information for
!                 Printed File Output
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    September 28, 1993
!
!        MODIFIED:   Replace DEPLETE parameter for plume depletion option
!                    with DDPLETE and WDPLETE in the list of model options
!                    for Wet & Dry depletion.
!                    D. Strimaitis, SRC - 11/8/93
!
!        MODIFIED:   Header modified for draft version of model with new
!                    area source and deposition algorithms - 9/28/93
!
!        MODIFIED:   To add DEPLETE parameter for plume depletion option
!                    to the list of model options
!                    D. Strimaitis, SRC - 2/15/93
!
!        INPUTS:  Page Number from COMMON
!
!        OUTPUTS: Page Feed and Header
!
!        CALLED FROM:  (This Is An Utility Program)
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
      CHARACTER RUNDAT*8 , RUNTIM*8
 
!     Variable Initializations
      MODNAM = 'HEADER'
 
!     Increment Page Number Counter
      IPAGE = IPAGE + 1
 
!     Retrieve Date and Time Variables for First Call
      IF ( IPAGE.EQ.1 ) THEN
         RUNDAT = ' '
         RUNTIM = ' '
 
!        Get Date and Time using system-specific functions  ---   CALL DATIME
         CALL DATIME(RUNDAT,RUNTIM)
 
      ENDIF
 
!     Write Header to Printed Output File
      WRITE (IOUNIT,9028) VERSN , TITLE1 , RUNDAT
 
 9028 FORMAT ('1',' *** AERMOD - VERSION ',A5,' ***',4X,'*** ',A68,     &
     &        ' ***',8X,A8)
      WRITE (IOUNIT,9029) TITLE2 , RUNTIM
 9029 FORMAT (36X,'*** ',A68,' ***',8X,A8)
      WRITE (IOUNIT,9030) IPAGE
 9030 FORMAT (1X,'**MODELOPTs:',107X,'PAGE',I4)
      WRITE (IOUNIT,9040) (MODOPS(I),I=1,18)
 9040 FORMAT (18(1X,A6)/)
 
      CONTINUE
      END
!*==DCDLAT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE DCDLAT()
!***********************************************************************
!            DCDLAT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To decode the hemisphere and latitude from
!                 the character variable ALAT (record 1 in scalar file)
!
!        PROGRAMMER: Jim Paumier, PES, Inc.
!
!        DATE:       September 30, 1993
!
!        INPUTS:  ALAT, the character variable latitude from AERMET
!
!        ASSUMPTIONS:  The first field in the first record of the
!                      scalar input file contains the latitude
!
!        OUTPUTS: Hemisphere (NORTH or SOUTH), latitude and sign (TSIGN)
!                 for turning of wind with height
!
!        CALLED FROM:  HRLOOP
!***********************************************************************
 
!---- Variable declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER NORS , SORN
 
!---- Data initialization
      MODNAM = 'DCDLAT'
      PATH = 'ME'
 
!---- Determine if the letter 'N' or 'n' is in the latitude field
      NORS = INDEX(ALAT,'N') + INDEX(ALAT,'n')
 
      IF ( NORS.NE.0 ) THEN
 
!        The latitude is in the northern hemisphere; decode the latitude
 
         TSIGN = 1.0
         READ (ALAT,'(F9.1)',ERR=1000) XLAT
 
!        Write a message if the latitude is too far north
 
         IF ( XLAT.GT.90.0 .OR. XLAT.LT.0.0 ) THEN
!           Write a warning to the user - latitude out-of-range
            CALL ERRHDL(PATH,MODNAM,'E','381',ALAT(3:10))
            RUNERR = .TRUE.
         ENDIF
 
      ELSE
 
!        The latitude may be in the southern hemisphere
 
         SORN = INDEX(ALAT,'S') + INDEX(ALAT,'s')
         IF ( SORN.NE.0 ) THEN
            TSIGN = -1.0
            READ (ALAT,'(F9.1)',ERR=1000) XLAT
 
            IF ( XLAT.GT.90.0 .OR. XLAT.LT.0.0 ) THEN
!              Write a warning to the user - latitude out-of-range
               CALL ERRHDL(PATH,MODNAM,'E','381',ALAT(3:10))
               RUNERR = .TRUE.
            ENDIF
 
 
         ELSE
!           Write a warning to the user - error decoding the latitude
            CALL ERRHDL(PATH,MODNAM,'E','382',ALAT(3:10))
            RUNERR = .TRUE.
 
         ENDIF
 
      ENDIF
 
      GOTO 999
 
 1000 CONTINUE
!     Write a warning to the user - error decoding the latitude
      CALL ERRHDL(PATH,MODNAM,'E','382',ALAT(3:10))
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==PRESET.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRESET
!***********************************************************************
!                 PRESET Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Preprocesses SETUP Information to Determine Data
!                 Storage Requirements
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        MODIFIED:   To check for NO ECHO in the input file.
!                    R.W. Brode, PES, Inc. - 12/2/98
!
!        INPUTS:  Input Runstream File
!
!        OUTPUTS: Array Sizes
!
!        CALLED FROM:   MAIN
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , ISPRD , IEPRD
      LOGICAL NOPATH , NOKEY
      CHARACTER RDFRM*20
      CHARACTER LPRD*8 , HPRD*8 , NCHR1(10)*8 , NCHR2(10)*4
      LOGICAL RMARK
      CHARACTER INPFLD*2 , PATHWY(8)*2
      INTERFACE
      SUBROUTINE EXPATH(INPFLD,PATHWY,IPN,NOPATH)
      CHARACTER(LEN=2) , INTENT(IN) :: INPFLD
      CHARACTER(LEN=2) , INTENT(IN) , DIMENSION(:) :: PATHWY
      INTEGER , INTENT(IN) :: IPN
      LOGICAL , INTENT(OUT) :: NOPATH
      END
      END INTERFACE
 
!     Variable Initializations
      DATA (NCHR1(I),I=1,10)/'FIRST' , 'SECOND' , 'THIRD' , 'FOURTH' ,  &
     &      'FIFTH' , 'SIXTH' , 'SEVENTH' , 'EIGHTH' , 'NINTH' ,        &
     &      'TENTH'/
      DATA (NCHR2(I),I=1,10)/'1ST' , '2ND' , '3RD' , '4TH' , '5TH' ,    &
     &      '6TH' , '7TH' , '8TH' , '9TH' , '10TH'/
 
!     Variable Initializations
      MODNAM = 'PRESET'
      PREVGRPID = '        '
      EOF = .FALSE.
      NPDMAX = 1
      NQF = 1
      ILINE = 0
 
      IPNUM = 0
      IPPNUM = 0
!     Counters for the Receptor Groups
      IREC = 0
      ISTA = .FALSE.
      IEND = .FALSE.
      IBND = 36
      IBELEV = 36
      NEWID = .TRUE.
 
!     Setup READ format and ECHO format for runstream record,
!     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE (RDFRM,9100) ISTRG , ISTRG
 9100 FORMAT ('(A',I3.3,',T1,',I3.3,'A1)')
 
!     LOOP Through Input Runstream Records
      DO WHILE ( .NOT.EOF )
 
!        Increment the Line Counter
         ILINE = ILINE + 1
 
!        READ Record to Buffers, as A80 and 80A1 for ISTRG = 80.
!        Length of ISTRG is Set in PARAMETER Statement in MAIN1
         READ (INUNIT,RDFRM,END=999) RUNST1 , (RUNST(I),I=1,ISTRG)
 
!        Convert Lower Case to Upper Case Letters           ---   CALL LWRUPR
         CALL LWRUPR
 
!        Define Fields on Card                              ---   CALL DEFINE
         CALL DEFINE
 
!        Get the Contents of the Fields                     ---   CALL GETFLD
         CALL GETFLD
 
!        If Blank Line, Then CYCLE to Next Card
         IF ( BLINE ) GOTO 11
 
!        Check for 'NO ECHO' In First Two Fields
!           Skip record with NO ECHO during PRESET stage of processing
         IF ( FIELD(1).EQ.'NO' .AND. FIELD(2).EQ.'ECHO' ) GOTO 11
 
!        Extract Pathway ID From Field 1                    ---   CALL EXPATH
         PATHWY(1) = 'CO'
         PATHWY(2) = 'SO'
         PATHWY(3) = 'RE'
         PATHWY(4) = 'ME'
         PATHWY(5) = 'TG'
         PATHWY(6) = 'OU'
         PATHWY(7) = '**'
         PATHWY(8) = 'EV'
         CALL EXPATH(FIELD(1),PATHWY,8,NOPATH)
 
!        For Invalid Pathway and Comment Lines Skip to Next Record
         IF ( NOPATH ) THEN
!           Skip Error Message for PRESET stage of processing
            PATH = PPATH
            GOTO 11
         ELSEIF ( PATH.EQ.'**' ) THEN
            GOTO 11
         ENDIF
 
!        Extract Keyword From Field 2                       ---   CALL EXKEY
         CALL EXKEY(FIELD(2),NOKEY)
 
         IF ( NOKEY ) THEN
!           Invalid Keyword - Skip Error Message for PRESET stage
            PKEYWD = KEYWRD
            GOTO 11
         ENDIF
 
!        Save Current Path and Path Number as Previous Path and Number
         PPATH = PATH
         IPPNUM = IPNUM
 
!        Process Cards to Determine Storage Requirements
         IF ( PATH.EQ.'CO' .AND. KEYWRD.EQ.'MODELOPT' ) THEN
            DO I = 3 , IFC
               IF ( FIELD(I).EQ.'CONC' .OR. FIELD(I).EQ.'DEPOS' .OR.    &
     &              FIELD(I).EQ.'DDEP' .OR. FIELD(I).EQ.'WDEP' )        &
     &              NTYP = NTYP + 1
!              Set PVMRM and OLM logicals for use in ALLSETUP
               IF ( FIELD(I).EQ.'PVMRM' ) THEN
                  PVMRM = .TRUE.
               ELSEIF ( FIELD(I).EQ.'OLM' ) THEN
                  OLM = .TRUE.
               ENDIF
            ENDDO
         ENDIF
 
         IF ( PATH.EQ.'CO' .AND. KEYWRD.EQ.'AVERTIME' ) THEN
            DO I = 3 , IFC
               IF ( FIELD(I).NE.'PERIOD' .AND. FIELD(I).NE.'ANNUAL' )   &
     &              NAVE = NAVE + 1
            ENDDO
         ENDIF
 
         IF ( PATH.EQ.'SO' ) CALL SRCSIZ
 
         IF ( PATH.EQ.'RE' ) THEN
            EVONLY = .FALSE.
            CALL RECSIZ
         ENDIF
 
         IF ( PATH.EQ.'EV' ) THEN
            EVONLY = .TRUE.
            IF ( KEYWRD.EQ.'EVENTPER' ) THEN
               NEVE = NEVE + 1
            ELSEIF ( KEYWRD.EQ.'INCLUDED' ) THEN
               CALL PREINCLUD
            ENDIF
         ENDIF
 
!           Read start year from SURFDATA card to establish date window
         IF ( PATH.EQ.'ME' .AND. KEYWRD.EQ.'SURFDATA' ) CALL SET_WINDOW
 
         IF ( PATH.EQ.'OU' .AND. KEYWRD.EQ.'RECTABLE' ) THEN
!           Begin LOOP Through Fields
            DO I = 4 , IFC
!              Retrieve The High Value
               CALL FSPLIT(PATH,KEYWRD,FIELD(I),ILEN_FLD,'-',RMARK,LPRD,&
     &                     HPRD)
               ISPRD = 0
               IEPRD = 0
               DO J = 1 , 10
                  IF ( LPRD.EQ.NCHR1(J) .OR. LPRD.EQ.NCHR2(J) )         &
     &                 ISPRD = J
                  IF ( HPRD.EQ.NCHR1(J) .OR. HPRD.EQ.NCHR2(J) )         &
     &                 IEPRD = J
               ENDDO
               IF ( ISPRD.GT.NVAL ) NVAL = ISPRD
               IF ( IEPRD.GT.NVAL ) NVAL = IEPRD
!           End LOOP Through Fields
            ENDDO
         ENDIF
 
         IF ( PATH.EQ.'OU' .AND. KEYWRD.EQ.'MAXTABLE' ) THEN
!           Set Number of Maximum Values to Sort
            CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!              Invalid Numerical Field
            IF ( IMIT.NE.1 ) GOTO 999
            INUM = NINT(FNUM)
            IF ( INUM.GT.NMAX ) NMAX = INUM
         ENDIF
 
!        Store the Current Keyword as the Previous Keyword
         PKEYWD = KEYWRD
 
!        Check for 'OU FINISHED' Card.  Exit DO WHILE Loop By Branching
!        to Statement 999 in Order to Avoid Reading a ^Z "End of File"
!        Marker That May Be Present For Some Editors.
         IF ( PATH.EQ.'OU' .AND. KEYWRD.EQ.'FINISHED' ) GOTO 999
 
         GOTO 11
 999     EOF = .TRUE.
 11      CONTINUE
      ENDDO
 
!     Rewind File and Reinitialize Line Number Counter for SETUP
      REWIND INUNIT
      ILINE = 0
      PNETID = '        '
 
!     Ensure that array limits are not < 1.
      NSRC = MAX(NSRC,1)
      NGRP = MAX(NGRP,1)
      NREC = MAX(NREC,1)
!     Set NARC = NREC temporarily for allocating setup arrays
      NARC = NREC
      NAVE = MAX(NAVE,1)
      NVAL = MAX(NVAL,1)
      NTYP = MAX(NTYP,1)
      NMAX = MAX(NMAX,1)
      NNET = MAX(NNET,1)
      IXM = MAX(IXM,1)
      IYM = MAX(IYM,1)
      NEVE = MAX(NEVE,1)
 
      CONTINUE
      END
!*==PREINCLUD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREINCLUD
!***********************************************************************
!*                PREINCLUD Module of the AMS/EPA Regulatory Model - AERMOD
!*
!*       PURPOSE: To read an external receptor/source file using the
!*                INCLUDED keyword.
!*
!*       PROGRAMMER: Roger Brode
!*
!*       DATE:    September 24, 1996
!*
!*       MODIFIED:
!*
!*       INPUTS:
!*
!*       OUTPUTS:
!*
!*
!*       CALLED FROM:   PRESET, SRCSIZ, RECSIZ
!***********************************************************************
 
!*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , ILREAL
      LOGICAL NOPATH , NOKEY
      CHARACTER RDFRM*20 , ECFRM*20
      CHARACTER INPFLD*2 , PATHWY(8)*2
      INTERFACE
      SUBROUTINE EXPATH(INPFLD,PATHWY,IPN,NOPATH)
      CHARACTER(LEN=2) , INTENT(IN) :: INPFLD
      CHARACTER(LEN=2) , INTENT(IN) , DIMENSION(:) :: PATHWY
      INTEGER , INTENT(IN) :: IPN
      LOGICAL , INTENT(OUT) :: NOPATH
      END
      END INTERFACE
 
!*    Variable Initializations
      MODNAM = 'PREINCLUD'
      EOF = .FALSE.
      ILINE = 1
 
!     Setup READ format and ECHO format for runstream record,
!     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE (RDFRM,9100) ISTRG , ISTRG
 9100 FORMAT ('(A',I3.3,',T1,',I3.3,'A1)')
      WRITE (ECFRM,9250) ISTRG
 9250 FORMAT ('(1X,A',I3.3,')')
 
 
      IF ( IFC.EQ.3 ) THEN
!        Retrieve Included Filename as Character Substring to Maintain Case
         INCFIL = RUNST1(LOCB(3):LOCE(3))
         OPEN (INCUNT,FILE=INCFIL,STATUS='OLD',ERR=1002)
 
      ELSEIF ( IFC.GT.4 ) THEN
!        Too Many Parameters
         GOTO 1002
      ELSE
!        No Parameters Specified
         GOTO 1002
      ENDIF
 
!     LOOP Through Input Runstream Records
      DO WHILE ( .NOT.EOF )
 
!        Increment the Line Counter.  It was Initially Set to 1, to Handle
!        the Code in Subroutine DEFINE
         ILINE = ILINE + 1
         ILREAL = ILREAL + 1
 
!        READ Record to Buffers, as A80 and 80A1 for ISTRG = 80.
!        Length of ISTRG is Set in PARAMETER Statement in MAIN1
         READ (INCUNT,RDFRM,END=999) RUNST1 , (RUNST(I),I=1,ISTRG)
 
!        Convert Lower Case to Upper Case Letters           ---   CALL LWRUPR
         CALL LWRUPR
 
!        Define Fields on Card                              ---   CALL DEFINE
         CALL DEFINE
 
         IF ( ILREAL.EQ.1 ) ILINE = ILINE - 1
 
!        Get the Contents of the Fields                     ---   CALL GETFLD
         CALL GETFLD
 
!        If Blank Line, Then CYCLE to Next Card
         IF ( BLINE ) GOTO 11
 
!        Check for 'NO ECHO' In First Two Fields
!           Skip record with NO ECHO during PREINCLUD stage of processing
         IF ( FIELD(1).EQ.'NO' .AND. FIELD(2).EQ.'ECHO' ) GOTO 11
 
!        Extract Pathway ID From Field 1                    ---   CALL EXPATH
         PATHWY(1) = 'CO'
         PATHWY(2) = 'SO'
         PATHWY(3) = 'RE'
         PATHWY(4) = 'ME'
         PATHWY(5) = 'TG'
         PATHWY(6) = 'OU'
         PATHWY(7) = '**'
         PATHWY(8) = 'EV'
         CALL EXPATH(FIELD(1),PATHWY,8,NOPATH)
 
!        For Invalid Pathway and Comment Lines Skip to Next Record
         IF ( NOPATH ) THEN
!           Skip Error Message for PREINCLUD stage of processing
            PATH = PPATH
            GOTO 11
         ELSEIF ( PATH.EQ.'**' ) THEN
            GOTO 11
         ENDIF
 
!        Extract Keyword From Field 2                       ---   CALL EXKEY
         CALL EXKEY(FIELD(2),NOKEY)
 
         IF ( NOKEY ) THEN
!           Invalid Keyword - Skip Error Message for PREINCLUD stage
            PKEYWD = KEYWRD
            GOTO 11
         ENDIF
 
!        Save Current Path and Path Number as Previous Path and Number
         PPATH = PATH
         IPPNUM = IPNUM
 
!        Process Input Card Based on Pathway
         IF ( PATH.EQ.'SO' ) THEN
!           Process SOurce Pathway Cards                    ---   CALL SOINCL
            CALL PRESOINC
         ELSEIF ( PATH.EQ.'RE' ) THEN
!           Process REceptor Pathway Cards                  ---   CALL REINCL
            CALL PREREINC
         ELSEIF ( PATH.EQ.'EV' ) THEN
            IF ( KEYWRD.EQ.'EVENTPER' ) NEVE = NEVE + 1
         ENDIF
 
!        Store the Current Keyword as the Previous Keyword
         PKEYWD = KEYWRD
 
         GOTO 11
 999     EOF = .TRUE.
 11      CONTINUE
 
      ENDDO
      EOF = .FALSE.
 
!     Close the INCLUDED File
      CLOSE (INCUNT)
 
 1002 CONTINUE
      END
!*==SRCSIZ.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE SRCSIZ
!***********************************************************************
!                 SRCSIZ Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To preprocess receptor inputs to determine
!                 storage requirements
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        MODIFIED:   To include an option to vary emissions by season,
!                    hour-of-day, and day-of-week (SHRDOW).
!                    R.W. Brode, PES, 4/10/2000
!
!        INPUTS:  Pathway (RE) and Keyword
!
!        OUTPUTS: Receptor Arrays
!                 Receptor Setup Status Switches
!
!        CALLED FROM:   PRESET
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'SRCSIZ'
 
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Initialize Counters and Set Status Switch
         NSRC = 0
         NGRP = 0
         PREVGRPID = '        '
 
      ELSEIF ( KEYWRD.EQ.'LOCATION' ) THEN
         NSRC = NSRC + 1
 
      ELSEIF ( (KEYWRD.EQ.'PARTDIAM' .OR. KEYWRD.EQ.'MASSFRAX' .OR.     &
     &         KEYWRD.EQ.'PARTDENS') ) THEN
         NPDMAX = 20
 
      ELSEIF ( KEYWRD.EQ.'EMISFACT' ) THEN
         IF ( FIELD(4).EQ.'SEASON' ) THEN
            NQF = MAX(NQF,4)
         ELSEIF ( FIELD(4).EQ.'MONTH' ) THEN
            NQF = MAX(NQF,12)
         ELSEIF ( FIELD(4).EQ.'HROFDY' ) THEN
            NQF = MAX(NQF,24)
         ELSEIF ( FIELD(4).EQ.'WSPEED' ) THEN
            NQF = MAX(NQF,6)
         ELSEIF ( FIELD(4).EQ.'SEASHR' ) THEN
            NQF = MAX(NQF,96)
         ELSEIF ( FIELD(4).EQ.'SHRDOW' ) THEN
            NQF = MAX(NQF,288)
         ELSEIF ( FIELD(4).EQ.'SHRDOW7' ) THEN
            NQF = MAX(NQF,672)
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'OLMGROUP' ) THEN
         IF ( FIELD(3).NE.PREVGRPID ) THEN
            NOLM = NOLM + 1
            PREVGRPID = FIELD(3)
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'SRCGROUP' ) THEN
         IF ( NGRP.EQ.0 ) PREVGRPID = '        '
         IF ( FIELD(3).NE.PREVGRPID ) THEN
            NGRP = NGRP + 1
            PREVGRPID = FIELD(3)
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'INCLUDED' ) THEN
         CALL PREINCLUD
      ENDIF
 
      CONTINUE
      END
!*==PRESOINC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRESOINC
!***********************************************************************
!                 PRESOINC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To preprocess receptor inputs to determine
!                 storage requirements
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        MODIFIED:   To include allocation for SHRDOW emission factor
!                    option.  R.W. Brode, PES, Inc., 9/15/2000
!
!        INPUTS:  Pathway (RE) and Keyword
!
!        OUTPUTS: Receptor Arrays
!                 Receptor Setup Status Switches
!
!        CALLED FROM:   PREINCLUD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PRESOINC'
 
      IF ( KEYWRD.EQ.'LOCATION' ) THEN
         NSRC = NSRC + 1
 
      ELSEIF ( (KEYWRD.EQ.'PARTDIAM' .OR. KEYWRD.EQ.'MASSFRAX' .OR.     &
     &         KEYWRD.EQ.'PARTDENS') ) THEN
         NPDMAX = 20
 
      ELSEIF ( KEYWRD.EQ.'EMISFACT' ) THEN
         IF ( FIELD(4).EQ.'SEASON' ) THEN
            NQF = MAX(NQF,4)
         ELSEIF ( FIELD(4).EQ.'MONTH' ) THEN
            NQF = MAX(NQF,12)
         ELSEIF ( FIELD(4).EQ.'HROFDY' ) THEN
            NQF = MAX(NQF,24)
         ELSEIF ( FIELD(4).EQ.'WSPEED' ) THEN
            NQF = MAX(NQF,6)
         ELSEIF ( FIELD(4).EQ.'SEASHR' ) THEN
            NQF = MAX(NQF,96)
         ELSEIF ( FIELD(4).EQ.'SHRDOW' ) THEN
            NQF = MAX(NQF,288)
         ELSEIF ( FIELD(4).EQ.'SHRDOW7' ) THEN
            NQF = MAX(NQF,672)
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'SRCGROUP' ) THEN
         IF ( FIELD(3).NE.PREVGRPID ) THEN
            NGRP = NGRP + 1
            PREVGRPID = FIELD(3)
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==RECSIZ.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE RECSIZ
!***********************************************************************
!                 RECSIZ Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To preprocess receptor inputs to determine
!                 storage requirements
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Pathway (RE) and Keyword
!
!        OUTPUTS: Receptor Arrays
!                 Receptor Setup Status Switches
!
!        CALLED FROM:   PRESET
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      LOGICAL FOUND
      INTEGER J
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'RECSIZ'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Initialize Counters and Set Status Switch
         NREC = 0
         NNET = 0
         IXM = 0
         IYM = 0
         PXSOID = ' '
         ISTA = .FALSE.
      ELSEIF ( KEYWRD.EQ.'GRIDCART' ) THEN
!        Process Cartesian Grid Receptor Network            ---   CALL PRECART
         CALL PRECART
      ELSEIF ( KEYWRD.EQ.'GRIDPOLR' ) THEN
!        Process Polar Receptor Network                     ---   CALL PREPOLR
         CALL PREPOLR
      ELSEIF ( KEYWRD.EQ.'DISCCART' ) THEN
         NREC = NREC + 1
      ELSEIF ( KEYWRD.EQ.'EVALCART' ) THEN
         NREC = NREC + 1
      ELSEIF ( KEYWRD.EQ.'DISCPOLR' ) THEN
         NREC = NREC + 1
      ELSEIF ( KEYWRD.EQ.'BOUNDARY' ) THEN
!        Process Plant Boundary Receptor Locations          ---   CALL PREBOUND
         CALL PREBOUND
      ELSEIF ( KEYWRD.EQ.'INCLUDED' ) THEN
         CALL PREINCLUD
      ENDIF
 
      CONTINUE
      END
!*==PREREINC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREREINC
!***********************************************************************
!                 PREREINC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To preprocess receptor inputs to determine
!                 storage requirements
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Pathway (RE) and Keyword
!
!        OUTPUTS: Receptor Arrays
!                 Receptor Setup Status Switches
!
!        CALLED FROM:   PREINCLUD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PREREINC'
 
      IF ( KEYWRD.EQ.'GRIDCART' ) THEN
!        Process Cartesian Grid Receptor Network            ---   CALL PRECART
         CALL PRECART
      ELSEIF ( KEYWRD.EQ.'GRIDPOLR' ) THEN
!        Process Polar Receptor Network                     ---   CALL PREPOLR
         CALL PREPOLR
      ELSEIF ( KEYWRD.EQ.'DISCCART' ) THEN
         NREC = NREC + 1
      ELSEIF ( KEYWRD.EQ.'EVALCART' ) THEN
         NREC = NREC + 1
      ELSEIF ( KEYWRD.EQ.'DISCPOLR' ) THEN
         NREC = NREC + 1
      ELSEIF ( KEYWRD.EQ.'BOUNDARY' ) THEN
!        Process Plant Boundary Receptor Locations          ---   CALL PREBOUND
         CALL PREBOUND
      ENDIF
 
      CONTINUE
      END
!*==PRECART.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRECART
!***********************************************************************
!                 PRECART Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Cartesian Grid Receptor Network Inputs
!
!        PROGRAMMER:  Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Cartesian Grid Receptor Network Inputs
!
!        CALLED FROM:   RECSIZ, PREREINC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PRECART'
 
!     READ in the Netid and Nettype
!        Missing Data Field
      IF ( IFC.LT.3 ) GOTO 999
      NETIDT = FIELD(3)
      IF ( .NOT.NEWID .AND.                                             &
     &     (NETIDT.EQ.'    ' .OR. NETIDT.EQ.'XYINC' .OR.                &
     &     NETIDT.EQ.'XPNTS' .OR. NETIDT.EQ.'YPNTS' .OR.                &
     &     NETIDT.EQ.'ELEV' .OR. NETIDT.EQ.'HILL' .OR.                  &
     &     NETIDT.EQ.'FLAG' .OR. NETIDT.EQ.'END') ) THEN
         NETIDT = PNETID
         KTYPE = FIELD(3)
      ELSEIF ( .NOT.NEWID .AND. NETIDT.EQ.PNETID ) THEN
         KTYPE = FIELD(4)
      ELSEIF ( NEWID .AND. NETIDT.NE.' ' ) THEN
         NEWID = .FALSE.
         KTYPE = FIELD(4)
!        The Keyword Counter
         NNET = NNET + 1
      ELSE
!        Invalid Secondary Keyword
         GOTO 999
      ENDIF
 
!     Start to Set Up the Network
      IF ( KTYPE.EQ.'STA' ) THEN
!        Initialize Logical Control Variables
         ISTA = .TRUE.
         IEND = .FALSE.
         NEWID = .FALSE.
         RECERR = .FALSE.
!        Set Counters of Calculation Field
         ICOUNT = 0
         JCOUNT = 0
      ELSEIF ( KTYPE.EQ.'XYINC' ) THEN
!        Set the Uniform Spacing Receptor Network           ---   CALL PREGENCAR
         CALL PREGENCAR
      ELSEIF ( KTYPE.EQ.'XPNTS' .OR. KTYPE.EQ.'YPNTS' ) THEN
!        Set the Non-uniform Spacing Receptor Network       ---   CALL PREXYPNTS
         CALL PREXYPNTS
      ELSEIF ( KTYPE.EQ.'END' ) THEN
         IEND = .TRUE.
         IF ( .NOT.RECERR ) NREC = NREC + ICOUNT*JCOUNT
         ISTA = .FALSE.
         NEWID = .TRUE.
 
      ELSEIF ( KTYPE.NE.'ELEV' .AND. KTYPE.NE.'FLAG' .AND.              &
     &         KTYPE.NE.'HILL' ) THEN
!        Invalid Secondary Keyword
         RECERR = .TRUE.
         GOTO 999
 
      ENDIF
 
      PNETID = NETIDT
 
 999  CONTINUE
      END
!*==PREGENCAR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREGENCAR
!***********************************************************************
!                 PREGENCAR Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Generates Cartesian Grid Receptor Network With
!                 Uniform Spacing
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Cartesian Grid Receptor Network With Uniform
!                 Spacing
!
!        CALLED FROM:   PRECART
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , K
      REAL :: TEMPP(6) , XDELTA , YDELTA
      LOGICAL ERROR
 
!     Variable Initializations
      MODNAM = 'PREGENCAR'
      ERROR = .FALSE.
 
!     Check for Location of Secondary Keyword, XYINC
      DO I = 1 , IFC
         IF ( FIELD(I).EQ.'XYINC' ) ISC = I + 1
      ENDDO
 
!     Determine Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.ISC-1 ) THEN
!        Missing Parameter
         RECERR = .TRUE.
         GOTO 999
      ELSEIF ( IFC.GT.ISC+5 ) THEN
!        Too Many Parameters
         RECERR = .TRUE.
         GOTO 999
      ELSEIF ( IFC.LT.ISC+5 ) THEN
!        Too Few Parameters
         RECERR = .TRUE.
         GOTO 999
      ENDIF
 
!     Input The Numerical Values
      DO K = 1 , 6
         CALL STONUM(FIELD(ISC+K-1),ILEN_FLD,TEMPP(K),IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            ERROR = .TRUE.
            RECERR = .TRUE.
         ENDIF
      ENDDO
 
      IF ( ERROR ) THEN
         ERROR = .FALSE.
         GOTO 999
      ENDIF
 
!     Assign Values to Appropriate Variables for Generated Network
      XINT = TEMPP(1)
      ICOUNT = NINT(TEMPP(2))
      XDELTA = TEMPP(3)
      YINT = TEMPP(4)
      JCOUNT = NINT(TEMPP(5))
      YDELTA = TEMPP(6)
 
!     Assign Them to the Coordinate Arrays
      IF ( ICOUNT.GT.IXM ) IXM = ICOUNT
      IF ( JCOUNT.GT.IYM ) IYM = JCOUNT
 
 999  CONTINUE
      END
!*==PREXYPNTS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREXYPNTS
!***********************************************************************
!                 PREXYPNTS Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Cartesian Grid x,y Input Value
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Cartesian Grid x,y Input Value
!
!        CALLED FROM:   PRECART
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , JSET
 
!     Variable Initializations
      MODNAM = 'PREXYPNTS'
 
      IF ( KTYPE.EQ.'XPNTS' ) THEN
!        Check for Location of Secondary Keyword, XPNTS
         DO I = 1 , IFC
            IF ( FIELD(I).EQ.'XPNTS' ) ISC = I + 1
         ENDDO
 
!        Determine Whether There Are Enough Parameter Fields
         IF ( IFC.EQ.ISC-1 ) THEN
!           Missing Parameter
            RECERR = .TRUE.
            GOTO 999
         ENDIF
 
         ISET = ICOUNT
         DO I = ISC , IFC
            CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
!           Check The Numerical Field
            IF ( IMIT.EQ.-1 ) RECERR = .TRUE.
            ISET = ISET + 1
            IF ( ISET.GT.IXM ) IXM = ISET
         ENDDO
         ICOUNT = ISET
 
      ELSEIF ( KTYPE.EQ.'YPNTS' ) THEN
!        Check for Location of Secondary Keyword, YPNTS
         DO I = 1 , IFC
            IF ( FIELD(I).EQ.'YPNTS' ) ISC = I + 1
         ENDDO
 
!        Determine Whether There Are Enough Parameter Fields
         IF ( IFC.EQ.ISC-1 ) THEN
!           Missing Parameter
            RECERR = .TRUE.
            GOTO 999
         ENDIF
 
         JSET = JCOUNT
         DO I = ISC , IFC
            CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
!           Check The Numerical Field
            IF ( IMIT.EQ.-1 ) RECERR = .TRUE.
            JSET = JSET + 1
            IF ( JSET.GT.IYM ) IYM = JSET
         ENDDO
         JCOUNT = JSET
 
      ENDIF
 
 999  CONTINUE
      END
!*==PREPOLR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREPOLR
!***********************************************************************
!                 PREPOLR Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Polar Grid Receptor Network Inputs
!
!        PROGRAMMER:  Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Polar Receptor Network Inputs
!
!        CALLED FROM:   RECSIZ, PREREINC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PREPOLR'
 
!        Missing Data Field
      IF ( IFC.LT.3 ) GOTO 999
 
!     READ in the Netid and Nettype
      NETIDT = FIELD(3)
      IF ( .NOT.NEWID .AND. (NETIDT.EQ.'    ' .OR. NETIDT.EQ.'ORIG' .OR.&
     &     NETIDT.EQ.'DIST' .OR. NETIDT.EQ.'DDIR' .OR.                  &
     &     NETIDT.EQ.'ELEV' .OR. NETIDT.EQ.'HILL' .OR.                  &
     &     NETIDT.EQ.'FLAG' .OR. NETIDT.EQ.'GDIR' .OR. NETIDT.EQ.'END') &
     &     ) THEN
         NETIDT = PNETID
         KTYPE = FIELD(3)
      ELSEIF ( .NOT.NEWID .AND. NETIDT.EQ.PNETID ) THEN
         KTYPE = FIELD(4)
      ELSEIF ( NEWID .AND. NETIDT.NE.'    ' ) THEN
         NEWID = .FALSE.
         KTYPE = FIELD(4)
!        The Keyword Counter
         NNET = NNET + 1
      ELSE
!        Invalid Secondary Keyword
         RECERR = .TRUE.
         GOTO 999
      ENDIF
 
!     Start to Set Up the Network
      IF ( KTYPE.EQ.'STA' ) THEN
         ISTA = .TRUE.
         IEND = .FALSE.
         NEWID = .FALSE.
         RECERR = .FALSE.
         ICOUNT = 0
         JCOUNT = 0
      ELSEIF ( KTYPE.EQ.'DIST' ) THEN
!        Read in the Distance Set                           ---   CALL PREPOLDST
         CALL PREPOLDST
      ELSEIF ( KTYPE.EQ.'GDIR' ) THEN
         CALL PREGENPOL
      ELSEIF ( KTYPE.EQ.'DDIR' ) THEN
         CALL PRERADRNG
      ELSEIF ( KTYPE.EQ.'END' ) THEN
         IEND = .TRUE.
!        Get the Final Result
         IF ( .NOT.RECERR ) NREC = NREC + ICOUNT*JCOUNT
         ISTA = .FALSE.
         NEWID = .TRUE.
 
      ELSEIF ( KTYPE.NE.'ELEV' .AND. KTYPE.NE.'FLAG' .AND.              &
     &         KTYPE.NE.'HILL' .AND. KTYPE.NE.'ORIG' ) THEN
!        Invalid Secondary Keyword
         RECERR = .TRUE.
         GOTO 999
 
      ENDIF
 
      PNETID = NETIDT
 
 999  CONTINUE
      END
!*==PREPOLDST.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREPOLDST
!***********************************************************************
!                 PREPOLDST Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Gets Distances for the Polar Network
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Polar Network Distance Input Value
!
!        CALLED FROM:   PREPOLR
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
 
!     Variable Initializations
      MODNAM = 'PREPOLDST'
 
!     Skip the Unrelated Fields
      DO I = 1 , IFC
         IF ( FIELD(I).EQ.'DIST' ) ISC = I + 1
      ENDDO
 
!     Determine Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.ISC-1 ) THEN
!        Missing Parameter
         RECERR = .TRUE.
         GOTO 999
      ENDIF
 
      ISET = ICOUNT
 
      DO I = ISC , IFC
         CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) RECERR = .TRUE.
         ISET = ISET + 1
         IF ( ISET.GT.IXM ) IXM = ISET
      ENDDO
 
      ICOUNT = ISET
 
 999  CONTINUE
      END
!*==PREGENPOL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREGENPOL
!***********************************************************************
!                 PREGENPOL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Generates Polar Receptor Network With
!                 Uniform Spacing
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Polar Receptor Network With Uniform Direction Spacing
!
!        CALLED FROM:   PREPOLR
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , K
      REAL :: TEMPP(3) , DIRINI , DIRINC
      LOGICAL ERROR
 
!     Variable Initializations
      MODNAM = 'PREGENPOL'
      ERROR = .FALSE.
 
!     Check for the Location of the Secondary Keyword, GDIR
      DO I = 1 , IFC
         IF ( FIELD(I).EQ.'GDIR' ) ISC = I + 1
      ENDDO
 
!     Determine Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.ISC-1 ) THEN
!        Missing Parameter
         RECERR = .TRUE.
         GOTO 999
      ELSEIF ( IFC.LT.ISC+2 ) THEN
!        Not Enough Parameters
         RECERR = .TRUE.
         GOTO 999
      ELSEIF ( IFC.GT.ISC+2 ) THEN
!        Too Many Parameters
         RECERR = .TRUE.
         GOTO 999
      ENDIF
 
!     Input Numerical Values
      DO K = 1 , 3
         CALL STONUM(FIELD(ISC+K-1),ILEN_FLD,TEMPP(K),IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            RECERR = .TRUE.
            ERROR = .TRUE.
         ENDIF
      ENDDO
 
      IF ( ERROR ) THEN
         ERROR = .FALSE.
         GOTO 999
      ENDIF
 
      JCOUNT = NINT(TEMPP(1))
      DIRINI = TEMPP(2)
      DIRINC = TEMPP(3)
 
!     Assign Them to the Coordinate Arrays
      IF ( JCOUNT.GT.IYM ) IYM = JCOUNT
 
 999  CONTINUE
      END
!*==PRERADRNG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRERADRNG
!***********************************************************************
!                 PRERADRNG Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Non-Uniform Polar Network Value
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Polar Network Directions in Non-Uniform Spacing
!
!        CALLED FROM:   PREPOLR
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
 
!     Variable Initializations
      MODNAM = 'PRERADRNG'
 
!     Skip the non-useful Fields
      DO I = 1 , IFC
         IF ( FIELD(I).EQ.'DDIR' ) ISC = I + 1
      ENDDO
 
!     Determine Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.ISC-1 ) THEN
!        Error Message: Missing Parameter
         RECERR = .TRUE.
         GOTO 999
      ENDIF
 
      ISET = JCOUNT
 
      DO I = ISC , IFC
         CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) RECERR = .TRUE.
         ISET = ISET + 1
         IF ( ISET.GT.IYM ) IYM = ISET
      ENDDO
 
      JCOUNT = ISET
 
 999  CONTINUE
      END
!*==PREBOUND.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PREBOUND
!***********************************************************************
!                 PREBOUND Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Plant Boundary Receptor Location Inputs
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 24, 1996
!
!        MODIFIED:   To Include TOXXFILE Option - 9/29/92
!                    To Correct Index Counter for BOUNDELV, and
!                    To Include Conversion of Elevations From
!                    Feet to Meters - 9/29/92
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Plant Boundary Receptor Location Inputs
!
!        CALLED FROM:   RECSIZ, PREREINC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      CHARACTER SOID*8
 
!     Variable Initializations
      MODNAM = 'PREBOUND'
 
!     Determine Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.2 ) THEN
!        Missing Parameter
         GOTO 999
      ELSEIF ( IFC.EQ.3 ) THEN
!        Missing Numerical Field
         GOTO 999
      ENDIF
 
      SOID = FIELD(3)
 
!     Update The Counter
      IF ( SOID.NE.PXSOID ) THEN
         NREC = NREC + 36
         PXSOID = SOID
      ENDIF
 
 999  CONTINUE
      END
!*==SET_WINDOW.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE SET_WINDOW
!***********************************************************************
!                 SET_WINDOW Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Preprocess Meteorology Surface Data Card (SURFDATA)
!                 to Set Date Window for Y2K Fixes
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    April 29, 1999
!
!        MODIFICATIONS:
!
!                    To subtract 1 from ISTRT_WIND in case data file
!                    contains data from end of previous year.
!                    R.W. Brode, PES, Inc.  8/28/01
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Starting Century, ISTRT_CENT                    [I4]
!                 Starting Year for 2-digit Window, ISTRT_WIND    [I4]
!
!        ERROR HANDLING:   Checks for Too Few Parameters;
!                          Checks for Invalid Numeric Fields;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   PRESET
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'SET_WINDOW'
 
      IF ( IFC.LT.4 ) THEN
         GOTO 999
      ELSEIF ( IFC.GT.7 ) THEN
         GOTO 999
      ENDIF
 
      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) GOTO 999
      ISYEAR = NINT(FNUM)
      IF ( ISYEAR.LT.100 ) THEN
!        Write warning message for 2-digit year, and set default "windowing"
!        variables, ISTRT_CENT (=19) and ISTRT_WIND (=50).
         CALL ERRHDL(PATH,MODNAM,'W','360',KEYWRD)
         ISTRT_CENT = 19
         ISTRT_WIND = 50
      ELSE
!        Determine starting century (ISTRT_CENT) and starting year for
!        window (ISTRT_WIND) from 4-digit input
         ISTRT_CENT = ISYEAR/100
         ISTRT_WIND = ISYEAR - ISTRT_CENT*100
!        Subtract 1 from ISTRT_WIND in case data file contains data
!        from end of previous year
         ISTRT_WIND = ISTRT_WIND - 1
         IF ( ISTRT_WIND.LT.0 ) ISTRT_WIND = 0
!        Check for year .ge. 2148 to avoid integer overflow on FULLDATE
         IF ( ISTRT_CENT.GE.21 .AND. ISTRT_WIND.GE.48 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','365',KEYWRD)
            ISTRT_CENT = 21
            ISTRT_WIND = 47
         ENDIF
      ENDIF
 
      GOTO 1000
 
 999  CONTINUE
!     For error in processing assume 1900 for start century and 50 for window
      ISTRT_CENT = 19
      ISTRT_WIND = 50
 
 1000 CONTINUE
      END
!*==CHK_ENDYR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CHK_ENDYR
!***********************************************************************
!                 CHK_ENDYR Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Checks date for "end-of-year" for use in ANNUAL
!                 averages and post-1997 PM10 processing.
!
!        PROGRAMMER: Roger Brode
!
!        DATE:
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Plant Boundary Receptor Location Inputs
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IEND_DAY , I , J , K , L , M
      CHARACTER SOID*8
 
!     Variable Initializations
      MODNAM = 'CHK_ENDYR'
 
      IF ( (IENDMN.EQ.2 .AND. IENDDY.EQ.29 .AND. IMONTH.EQ.2) .AND.     &
     &     (MOD(IYR,4).NE.0) .OR.                                       &
     &     (MOD(IYR,100).EQ.0 .AND. MOD(IYR,400).NE.0) ) THEN
!        Set End Day to 28 for non-leap year February
         IEND_DAY = 28
      ELSE
         IEND_DAY = IENDDY
      ENDIF
 
      IF ( IMONTH.EQ.IENDMN .AND. IDAY.EQ.IEND_DAY .AND.                &
     &     IHOUR.EQ.IENDHOUR ) THEN
!        End of year reached, increment counter and store H4H values
         NUMYRS = NUMYRS + 1
         IF ( ANNUAL ) CALL PERAVE
         DO IGRP = 1 , NUMGRP
            DO IREC = 1 , NUMREC
               IF ( PM10AVE .AND. NUMAVE.EQ.1 ) SUMH4H(IREC,IGRP)       &
     &              = SUMH4H(IREC,IGRP) + HIVALU(IREC,4,IGRP,1,1)
               IF ( ANNUAL ) THEN
                  DO ITYP = 1 , NUMTYP
                     SUMANN(IREC,IGRP,ITYP) = SUMANN(IREC,IGRP,ITYP)    &
     &                  + ANNVAL(IREC,IGRP,ITYP)
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
         NREMAIN = 0
         IF ( ANNUAL ) THEN
!           Re-initialize the annual counters and array
            IANHRS = 0
            IANCLM = 0
            IANMSG = 0
            IANWET = 0
            IWETCLM = 0
            IWETMSG = 0
            NSKIPTOT = 0
            NSKIPDRY = 0
            NSDRYCLM = 0
            NSDRYMSG = 0
            NSKIPWET = 0
            NSWETCLM = 0
            NSWETMSG = 0
            DO L = 1 , NUMTYP
               DO K = 1 , NUMGRP
                  DO J = 1 , NUMREC
                     ANNVAL(J,K,L) = 0.0
                     ANNVALD(J,K,L) = 0.0
                     ANNVALW(J,K,L) = 0.0
                  ENDDO
               ENDDO
            ENDDO
         ENDIF
         IF ( PM10AVE .AND. NUMAVE.EQ.1 ) THEN
!           Re-initialize the High Value Arrays for post-1997 PM10
            DO M = 1 , NUMTYP
               DO L = 1 , NUMAVE
                  DO K = 1 , NUMGRP
                     DO J = 1 , NUMREC
                        DO I = 1 , NHIVAL
                           HIVALU(J,I,K,L,M) = 0.0
                           NHIDAT(J,I,K,L,M) = 0
                           HCLMSG(J,I,K,L,M) = ' '
                        ENDDO
                     ENDDO
                  ENDDO
               ENDDO
            ENDDO
         ENDIF
      ELSE
!        Increment counter for number of hours remaining after
!        the end of the last year
         NREMAIN = NREMAIN + 1
      ENDIF
 
      CONTINUE
      END
!*==CALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE CALC
!***********************************************************************
!             CALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Controls Flow and Processing of CALCulation Modules
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Receptor Locations
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: Array of 1-hr CONC or DEPOS Values for Each
!                 Source/Receptor
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'CALC'
      PATH = 'CN'
 
!     Begin Source LOOP
      SOURCE_LOOP:DO ISRC = 1 , NUMSRC
         IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
!           Calculate Point Source Values                ---   CALL PCALC
            CALL PCALC
 
         ELSEIF ( SRCTYP(ISRC).EQ.'VOLUME' ) THEN
!           Calculate Volume Source Values               ---   CALL VCALC
            CALL VCALC
 
         ELSEIF ( SRCTYP(ISRC).EQ.'AREA' ) THEN
!           Calculate Area Source Values                 ---   CALL ACALC
            CALL ACALC
 
         ELSEIF ( SRCTYP(ISRC).EQ.'AREAPOLY' ) THEN
!           Calculate Area Source Values                 ---   CALL ACALC
            CALL ACALC
 
         ELSEIF ( SRCTYP(ISRC).EQ.'AREACIRC' ) THEN
!           Calculate Area Source Values                 ---   CALL ACALC
            CALL ACALC
 
         ELSEIF ( SRCTYP(ISRC).EQ.'OPENPIT' ) THEN
!           Calculate OpenPit Source Values              ---   CALL OCALC
            CALL OCALC
 
         ENDIF
      ENDDO SOURCE_LOOP
!     End Source LOOP
 
      CONTINUE
      END
!*==PCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PCALC
!***********************************************************************
!             PCALC Module of the AMS/EPA Regulatory Model - AERMOD
! ----------------------------------------------------------------------
! ---    ISC-PRIME     Version 1.0    Level 970812              Modified
! ---        D. Strimaitis, J. Scire
! ---        Earth Tech, Inc.
!            Prepared for EPRI under contract WO3527-01
! ----------------------------------------------------------------------
!
!        PURPOSE: Calculates concentration or deposition values
!                 for POINT sources
!
!        PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        CHANGES:
!                  Modified to include initialization of __VAL arrays
!                  at end of receptor loop.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 10/26/04
!
!                  Modified to include the PVMRM and OLM options for
!                  modeling conversion of NOx to NO2.
!                  Added debug statement based on ENSR code.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!RWB               Modified to call DHPSS to obtain plume centroid height
!RWB               (CENTER) for Schulman-Scire downwash cases.  Modified
!RWB               to compare XFINAL to XMIXED only for unstable cases with
!RWB               HS < ZI.  Added initialization of TGEFF and TGEFF3 as TGS.
!RWB               Additional modifications made to improve consistency with
!RWB               the implementation of Schulman-Scire downwash algorithm
!RWB               in the ISCST3 model.
!RWB               R. Brode, PES - 12/6/99
!
!RWB               Modified to use wind direction at midpoint between
!RWB               stack height and "final" plume height for transport.
!RWB               R. Brode, PES - 1/22/98
!
!RWB               Use effective parameters evaluated at stack height
!RWB               for the indirect plume, as for direct plume.  Also
!RWB               commented out calls to LOCATE and GINTRP with ZIO2.
!RWB               This change is made for the Base Case model.
!RWB               R. Brode, PES - 12/8/94
!
!RWB               Commented out calls to LOCATE and GINTRP with HTEFF in
!RWB               order to use effective parameters evaluated at stack height
!RWB               instead of HTEFF for the direct plume and the stable
!RWB               plume.  This change is made for the Base Case model.
!RWB               R. Brode, PES - 12/7/94
!
!                  Moved calculation of penetration factor from outside
!                  to inside receptor loop, and deleted code related C                  to indirect and penetrated plumes which is no
!                  longer needed.  (R.F. Lee, 7/13/94)
!
!                  Added true centerline concentration calculations
!                  for EVALFL output.  (R.F. Lee, 7/25/94)
!
!RJP               Changes made to calculations of effective parameters
!RJP               in conjunction with new treatment of inhomogeneity.
!RJP               (Bob Paine, 10/4/94)
!
!
!        INPUTS:  Source Parameters for Specific Source
!                 Arrays of Receptor Locations
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: 1-hr CONC or DEPOS Values for Each Receptor for
!                 Particular Source
!
!        CALLED FROM:   CALC
!
!        Assumptions:
!
!        References:  "A Dispersion Model for the Convective Boundary
!                      Layer", J. Weil, 8/17/93
!                     "Inhomogeneous Boundary Layer", A. Venkatram,
!                      6/25/93
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I , KITER , NDXHE , NDXZMID , NDXZPL , NDXHE3
      INTEGER :: IPOSITN , NDXBH , N1 , N2 , N , IS
      REAL :: HSPRIM , ZPLM , DHFOLD , SVPM , UPM , TGPM , PTPM , PTP , &
     &        ZMID
      REAL :: VALABV , VBELOW
      REAL :: USTACK , UBLDG , XBREC , YBREC , FQCAV
      REAL :: AERPLM(NUMTYP) , AERPAN(NUMTYP) , FRAN , FRAN3
      REAL :: PRMPLM(NUMTYP) , PRMPAN(NUMTYP)
      LOGICAL :: L_PLUME
 
      LOGICAL :: LDBHR
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PCALC'
 
!     Initialize __VAL arrays
      DO ITYP = 1 , NUMTYP
         HRVAL(ITYP) = 0.0
         HRVALD(ITYP) = 0.0
         AERVAL(ITYP) = 0.0
         AERVALD(ITYP) = 0.0
         AERPLM(ITYP) = 0.0
         AERPAN(ITYP) = 0.0
         PRMVAL(ITYP) = 0.0
         PRMVALD(ITYP) = 0.0
      ENDDO
 
!     Set the Source Variables for This Source              ---   CALL SETSRC
      CALL SETSRC
 
!     Apply Variable Emission Rate and Unit Factors         ---   CALL EMFACT
      CALL EMFACT(QS)
 
      IF ( (QTK.NE.0.0) ) THEN
 
!        Set Mixing Height and Profiles for Urban Option if Needed
         IF ( STABLE .AND. URBAN ) THEN
            IF ( URBSRC(ISRC).EQ.'Y' ) THEN
               URBSTAB = .TRUE.
               ZI = AMAX1(ZIURB,ZIMECH)
               GRIDSV = GRDSVU
               GRIDSW = GRDSWU
               GRIDTG = GRDTGU
               GRIDPT = GRDPTU
               OBULEN = ABS(URBOBULEN)
               USTAR = URBUSTR
            ELSEIF ( URBSRC(ISRC).EQ.'N' ) THEN
               URBSTAB = .FALSE.
               ZI = ZIRUR
               GRIDSV = GRDSVR
               GRIDSW = GRDSWR
               GRIDTG = GRDTGR
               GRIDPT = GRDPTR
               OBULEN = RUROBULEN
               USTAR = RURUSTR
            ENDIF
         ELSE
            URBSTAB = .FALSE.
         ENDIF
 
!        Calculate the initial meteorological variables     ---   CALL METINI
         CALL METINI
 
!        Calculate Buoyancy and Momentum Fluxes             ---   CALL FLUXES
         CALL FLUXES
 
!        Set Wake and Building Type Switches                ---   CALL WAKFLG
! ---    NOTE:  WAKFLG sets building dimensions based on wind
!        direction at stack top.
         CALL WAKFLG
 
!        Define temporary values of CENTER and SURFAC based on HS
         CENTER = HS
         IF ( CENTER.LT.0.1*ZI ) THEN
            SURFAC = .TRUE.
         ELSE
            SURFAC = .FALSE.
         ENDIF
 
!        Check for stack-tip downwash option and adjust if necessary
         IF ( NOSTD ) THEN
!           No stack-tip downwash, no adjustments necessary
            HSP = HS
         ELSE
!           Make adjustments for stack-tip downwash
            HSP = HSPRIM(US,VS,HS,DS)
         ENDIF
 
!        Calculate Distance to Final Rise                   ---   CALL DISTF
         CALL DISTF
 
!        Calculate the plume penetration factor             ---   CALL PENFCT
         CALL PENFCT
 
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6000) DHFAER , UP , TGS
 6000       FORMAT (/,5X,'INITIAL PLUME RISE ESTIMATE:  DELH = ',F6.1,  &
     &              ' M; Uplume = ',F5.2,' M/S; DTHDZ = ',F7.4,         &
     &              ' DEG K/M')
         ENDIF
 
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!           Use iterative approach to stable plume rise calculations
            KITER = 0
 50         ZPLM = HSP + 0.5*DHFAER
            DHFOLD = DHFAER
 
!----       Locate index below ZPLM
 
            CALL LOCATE(GRIDHT,1,MXGLVL,ZPLM,NDXZPL)
 
!----       Get Wind speed at ZPLM; replace UP.  Also, replace TGP,
!           vertical potential temperature gradient, if stable.
 
            CALL GINTRP(GRIDHT(NDXZPL),GRIDSV(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDSV(NDXZPL+1),ZPLM,SVPM)
            CALL GINTRP(GRIDHT(NDXZPL),GRIDWS(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDWS(NDXZPL+1),ZPLM,UPM)
            SVPM = AMAX1(SVPM,SVMIN,0.05*UPM)
            UPM = SQRT(UPM*UPM+2.*SVPM*SVPM)
!RWB        Use average of stack top and midpoint wind speeds.
            UP = 0.5*(US+UPM)
 
            CALL GINTRP(GRIDHT(NDXZPL),GRIDTG(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDTG(NDXZPL+1),ZPLM,TGPM)
            CALL GINTRP(GRIDHT(NDXZPL),GRIDPT(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDPT(NDXZPL+1),ZPLM,PTPM)
!RWB        Use average of stack top and midpoint temperature gradients.
            TGP = 0.5*(TGS+TGPM)
            PTP = 0.5*(PTS+PTPM)
            BVF = SQRT(G*TGP/PTP)
            IF ( BVF.LT.1.0E-10 ) BVF = 1.0E-10
            BVPRIM = 0.7*BVF
 
            CALL DISTF
 
            KITER = KITER + 1
 
!RJP        Add temporary debugging statements
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6001) KITER , DHFOLD , DHFAER , ZPLM , UP ,&
     &                             TGP
 6001          FORMAT (/,5X,'OPTH2 ITER. #',I1,': OLD DELH = ',F6.1,    &
     &                 ' M; NEW DELH = ',F6.1,' M; MET LEVEL = ',F6.1,  &
     &                 ' M; NEW Upl = ',F5.2,' M/S; NEW DTHDZ = ',F7.4, &
     &                 ' K/M')
            ENDIF
            IF ( ABS((DHFOLD-DHFAER)/DHFAER).LT.0.01 ) GOTO 60
            IF ( KITER.GE.5 ) THEN
               DHFAER = 0.5*(DHFAER+DHFOLD)
               IF ( DEBUG ) WRITE (DBGUNT,6002) DHFAER
 6002          FORMAT (/,5X,'OPTH2 ITERATION FAILED TO CONVERGE; PLUME',&
     &                 ' RISE SET AT ',F6.1,' METERS.',/)
               GOTO 60
            ELSE
               GOTO 50
            ENDIF
 
 60         CONTINUE
 
!RWB        After completing iteration, reset UP and TGP to stack top
!RWB        values for subsequent distance-dependent plume rise calcs.
            UP = US
            TGP = TGS
            PTP = PTS
            BVF = SQRT(G*TGP/PTP)
            IF ( BVF.LT.1.0E-10 ) BVF = 1.0E-10
            BVPRIM = 0.7*BVF
         ENDIF
 
!        Initialize FSTREC Logical Switch for First Receptor of Loop;
         FSTREC = .TRUE.
         PRM_FSTREC = .TRUE.
 
!        Initialize 'ARC' Arrays for EVALFILE Output        ---   CALL EVLINI
         IF ( EVAL(ISRC) ) CALL EVLINI
 
         ZMIDMX = 0.5*ZI
 
!RJP     Add temporary debugging statement.
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6010) KURDAT , ZMIDMX
 6010       FORMAT (/,72('*'),//,5X,'YYMMDDHH: ',I8,//,5X,              &
     &              'Height assigned to midpoint of ',                  &
     &              'well-mixed layer for effective parameters = ',F6.1,&
     &              ' meters.',/)
         ENDIF
!RJP
!RJP     Calculate distance to uniformly mixed plume within the
!RJP     boundary layer (XMIXED) after Turner's Workbook (1970), page 7:
!RJP     distance is approximately (Zi * UAVG)/SWAVG, where UAVG
!RJP     and SWAVG are wind speed and sigma-w averaged over the depth
!RJP     between the ground and Zi (or the plume height, if higher in
!RJP     stable conditions); this height is denoted as 2 * ZMIDMX.
!RJP
!RJP     First, get refined estimate of final rise and distance to final
!RJP     rise if downwash conditions prevail.
!RJP
         XFINAL = XMAX
         DHCRIT = DHFAER
         XMIXED = ZI*UAVG/SWAVG
         IF ( UNSTAB .AND. HS.LT.ZI ) THEN
!           Check for XMIXED smaller than 1.25*XFINAL
            IF ( XMIXED.LT.1.25*XFINAL ) THEN
               XFINAL = 0.8*XMIXED
               CALL CBLPRD(XFINAL)
               DHCRIT = DHP1
            ENDIF
         ELSEIF ( STABLE ) THEN
            IF ( XMIXED.LT.1.25*XFINAL ) THEN
               XFINAL = 0.8*XMIXED
               CALL SBLRIS(XFINAL)
               DHCRIT = DHP
            ENDIF
 
         ENDIF
 
 
!DEP     Initialize PDF parameters for use in calculating ZSUBP
         IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
!        Set Deposition Variables for this Source
!           Calculate Deposition Velocities for this Source    ---   CALL VDP
         IF ( LDPART .OR. LDGAS ) CALL VDP
         IF ( LWPART .OR. LWGAS ) THEN
!PES        Set value of ZSUBP = MAX( ZI, TOP OF PLUME ), where
!PES        TOP OF PLUME is defined as plume height (HE) plus 2.15*SZ,
!PES        evaluated at a distance of 20 kilometers downwind.
!PES        Apply minimum value of 500m and maximum value of 10,000m.
            IF ( STABLE .OR. (UNSTAB .AND. HS.GE.ZI) ) THEN
               HE = HSP + DHCRIT
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HE+SZCOEF*SZAS)
            ELSEIF ( UNSTAB ) THEN
               HED1 = HSP + DHCRIT
               IF ( PPF.GT.0. ) CALL CBLPR3
               CALL SIGZ(20000.)
 
               IF ( PPF.EQ.0. ) THEN
                  ZSUBP = MAX(500.,ZI,HED1+SZCOEF*(SZAD1+SZAD2)/2.)
               ELSEIF ( PPF.EQ.1. ) THEN
                  ZSUBP = MAX(500.,ZI,HE3+SZCOEF*SZA3)
               ELSE
                  ZSUBP = MAX(500.,ZI,PPF*(HE3+SZCOEF*SZA3)+(1.-PPF)    &
     &                    *(HED1+SZCOEF*(SZAD1+SZAD2)/2.))
               ENDIF
            ENDIF
            ZSUBP = MIN(10000.,ZSUBP)
!           Calculate Scavenging Ratios for this Source           ---   CALL SCAVRAT
            CALL SCAVRAT
         ENDIF
 
!RWB     Determine transport wind direction using midpoint between
!RWB     stack height and "final" plume height.  R. Brode, PES, 1/22/98
!----    Define ZMID=midpoint between stack height and "final" plume height
         ZMID = AMIN1(4000.,(HS+0.5*DHFAER))
 
!----    Locate index below ZMID
         CALL LOCATE(GRIDHT,1,MXGLVL,ZMID,NDXZMID)
 
!----    Check for 360 crossover and adjust if necessary
         VALABV = GRIDWD(NDXZMID+1)
         VBELOW = GRIDWD(NDXZMID)
 
         IF ( (VALABV-VBELOW).LT.-180.0 ) THEN
            VALABV = VALABV + 360.
         ELSEIF ( (VALABV-VBELOW).GT.180.0 ) THEN
            VALABV = VALABV - 360.
         ENDIF
 
!----    Wind direction
         CALL GINTRP(GRIDHT(NDXZMID),VBELOW,GRIDHT(NDXZMID+1),VALABV,   &
     &               ZMID,WDIR)
 
!        Check for WDIR > 360 or < 0
         IF ( WDIR.GT.360. ) THEN
            WDIR = WDIR - 360.
         ELSEIF ( WDIR.LE.0.0 ) THEN
            WDIR = WDIR + 360.
         ENDIF
!
!----    Convert direction to radians, compute sine and cosine of direction,
!        and determine nearest 10-degree sector.
!
!---->   wind direction = wind direction in degrees * DTORAD
 
         WDSIN = SIN(WDIR*DTORAD)
         WDCOS = COS(WDIR*DTORAD)
 
         AFV = WDIR - 180.0
         IF ( AFV.LT.0.0 ) AFV = AFV + 360.0
         IFVSEC = INT(AFV*0.10+0.4999)
         IF ( IFVSEC.EQ.0 ) IFVSEC = 36
 
!
! --- PRIME ---------------------------------------------------------
! ---    Setup computations for numerical plume rise algorithm
! ---    and building wake analysis
         IF ( WAKE ) THEN
! ---       Store selected data in new variables for future reference
            USTACK = US
 
! ---       Compute wind speed at top of building           ---   CALL WSADJ
! ---       Locate index below building height
            CALL LOCATE(GRIDHT,1,MXGLVL,DSBH,NDXBH)
 
            CALL GINTRP(GRIDHT(NDXBH),GRIDWS(NDXBH),GRIDHT(NDXBH+1),    &
     &                  GRIDWS(NDXBH+1),DSBH,UBLDG)
 
! ---       Refresh /WAKEDAT/ variables                     ---   CALL WAKE_INI
            LDBHR = DEBUG
! ---       Note that logical RURAL has not impact on calculations
            RURAL = .TRUE.
            CALL WAKE_INI(LDBHR,KST,RURAL,DSBH,DSBW,DSBL,XADJ,YADJ,     &
     &                    UBLDG,USTACK)
         ENDIF
! ------------------------------------------------------------
 
!RJP     Add temporary debugging statement.
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6011) DHCRIT , XFINAL , XMIXED
 6011       FORMAT (5X,'For effective parameter calculations: ',        &
     &              '"Final" plume rise = ',F6.1,                       &
     &              ' m; Distance to final ','rise = ',F7.1,' m',/,5x,  &
     &              'Distance to well-mixed ','state = ',F7.1,' m.',/)
!RJP
!RJP        Make call to PSRDEB
!RJP
            CALL PSRDEB
 
         ENDIF
!
!        Begin Receptor LOOP *******************************************
!CRFL
!CRFL    Add logical variable METHDR, which is set to TRUE at the start
!CRFL    of the receptor loop, and reset to false after the headers and
!CRFL    non-receptor dependent meteorological variables in the
!CRFL    meteorological debug file are printed.  METHDR is also added
!CRFL    to MAIN.INC and METEXT.FOR (Subroutine METDEB).  9/27/94, R.F. Lee.
!CRFL
         METHDR = .TRUE.
         RECEPTOR_LOOP:DO IREC = 1 , NUMREC
!           Calculate Down and Crosswind Distances          ---   CALL XYDIST
            IF ( EVONLY ) THEN
               CALL XYDIST(IEVENT)
            ELSE
               CALL XYDIST(IREC)
            ENDIF
 
! ---       Calculate AERMOD Concentration Without Downwash, AERVAL
! ---       First calculate coherent plume component using downwind distance
            L_PLUME = .TRUE.
! ---       Assign XDIST for use in dry depletion (FUNCTION F2INT)
            XDIST = X
            CALL AERCALC(X,L_PLUME,AERPLM)
 
! ---       Next calculate random "pancake" component using radial distance
            L_PLUME = .FALSE.
! ---       Assign XDIST for use in dry depletion (FUNCTION F2INT)
            XDIST = DISTR
            CALL AERCALC(DISTR,L_PLUME,AERPAN)
 
! ---       Calculate fraction of random kinetic energy to total kinetic energy.
!           Note that these effective parameters are based on the radial dist.
            IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
               CALL MEANDR(UEFF,SVEFF,FRAN)
            ELSEIF ( UNSTAB ) THEN
               CALL MEANDR(UEFFD,SVEFFD,FRAN)
               IF ( PPF.GT.0.0 ) THEN
!                 For penetrated source calculate weighted average of
!                 direct/indirect plume component and penetrated component
                  CALL MEANDR(UEFF3,SVEFF3,FRAN3)
                  FRAN = PPF*FRAN3 + (1.-PPF)*FRAN
               ENDIF
            ENDIF
 
! ---       Combine coherent plume and random "pancake" components
            DO ITYP = 1 , NUMTYP
               AERVAL(ITYP) = FRAN*AERPAN(ITYP) + (1.-FRAN)*AERPLM(ITYP)
!   ENSR STATEMENT
               IF ( DEBUG ) THEN
                  WRITE (DBGUNT,10) AERPAN(ITYP) , AERPLM(ITYP) , FRAN ,&
     &                              AERVAL(ITYP)
 10               FORMAT (/,                                            &
     &       'AERVAL(ITYP) = FRAN*AERPAN(ITYP) + (1.-FRAN)*AERPLM(ITYP)'&
     &       ,//,'PANCAKE/MEANDER COMPONENT, AERPAN(ITYP) = ',G16.8,/,  &
     &       'COHERENT PLUME COMPONENT,  AERPLM(ITYP) = ',G16.8,/,      &
     &       'MEANDER FACTOR, FRAN = ',G16.8,/,                         &
     &       'RESULTANT CONC, AERVAL(ITYP) = ',G16.8,//)
               ENDIF
            ENDDO
 
            IF ( WAKE .AND. (STABLE .OR. HS.LE.ZI) ) THEN
! ---          Calculate receptor coordinates relative to upwind face of bldg.:
!              xbrec is downwind dist. of receptor from upwind
!              bldg face; ybrec is crosswind dist. of receptor from
!              center of upwind bldg. face
               XBREC = X - XADJ
               YBREC = Y - YADJ
 
               XDIST = X
! ---          Calculate PRIME Downwash Concentration, PRMVAL
               CALL PRMCALC(XBREC,YBREC)
 
! ---          Calculate Gamma weighting factor, GAMFACT
               CALL GAMCALC(XBREC,YBREC)
 
               DO ITYP = 1 , NUMTYP
! ---             Calculate hourly concentration from PRIME and AERMOD values
                  HRVAL(ITYP) = GAMFACT*PRMVAL(ITYP) + (1.0-GAMFACT)    &
     &                          *AERVAL(ITYP)
 
                  IF ( DEBUG ) THEN
                     WRITE (IOUNIT,*) 'YYMMDDHH:  ' , KURDAT ,          &
     &                                ' ISRC: ' , ISRC , ' IREC: ' ,    &
     &                                IREC
                     WRITE (IOUNIT,*) ' GAMFACT = ' , GAMFACT
                     WRITE (IOUNIT,*) ' AERVAL  = ' , AERVAL(ITYP)
                     WRITE (IOUNIT,*) ' PRMVAL  = ' , PRMVAL(ITYP)
                     WRITE (IOUNIT,*) ' HRVAL   = ' , HRVAL(ITYP)
                     WRITE (IOUNIT,*) ' '
                  ENDIF
               ENDDO
 
            ELSE
! ---          No WAKE effects or HS > ZI, set GAMFACT to 0.0 and use AERVAL only.
               GAMFACT = 0.0
               DO ITYP = 1 , NUMTYP
! ---             Calculate hourly concentration from PRIME and AERMOD values
                  HRVAL(ITYP) = AERVAL(ITYP)
                  PRMVAL(ITYP) = 0.0
               ENDDO
 
            ENDIF
 
            IF ( PVMRM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for PVMRM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
               IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
                  HECNTR(IREC,ISRC) = HE
                  UEFFS(IREC,ISRC) = UEFF
               ELSE
                  HECNTR(IREC,ISRC) = CENTER
                  UEFFS(IREC,ISRC) = UEFFD
               ENDIF
               IF ( PPF.GT.0.0 ) THEN
                  HECNTR3(IREC,ISRC) = HE3
                  PPFACT(ISRC) = PPF
                  UEFF3S(IREC,ISRC) = UEFF3
               ELSE
                  PPFACT(ISRC) = 0.0
               ENDIF
               FOPTS(IREC,ISRC) = FOPT
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 100
            ELSEIF ( OLM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for OLM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 100
            ENDIF
 
!           Sum HRVAL to AVEVAL and ANNVAL Arrays  ---   CALL SUMVAL
            IF ( EVONLY ) THEN
               CALL EV_SUMVAL
            ELSE
               CALL SUMVAL
            ENDIF
!              Check ARC centerline values for EVALFILE
!              output                              ---   CALL EVALCK
            IF ( EVAL(ISRC) ) CALL EVALCK
 
!           Initialize __VAL arrays
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = 0.0
               HRVALD(ITYP) = 0.0
               AERVAL(ITYP) = 0.0
               AERVALD(ITYP) = 0.0
               AERPLM(ITYP) = 0.0
               AERPAN(ITYP) = 0.0
               PRMVAL(ITYP) = 0.0
               PRMVALD(ITYP) = 0.0
            ENDDO
 
 100     ENDDO RECEPTOR_LOOP
!        End Receptor LOOP
 
!        Output 'ARC' Values for EVALFILE                   ---   CALL EVALFL
         IF ( EVAL(ISRC) ) CALL EVALFL
 
      ENDIF
 
      CONTINUE
      END
!*==AERCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE AERCALC(XARG,L_PLUME,AEROUT)
!***********************************************************************
!             AERCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates the AERMOD concentration without downwash
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     November 10, 2000
!
!        CHANGES:
!                  Added debug statement based on ENSR code.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!        INPUTS:   XARG         - Real - Distance (m), downwind for coherent
!                                        plume component and radial for
!                                        random component
!                  L_PLUME      - Log  - Specifies coherent plume calculation
!                                        if TRUE, otherwise random component
!
!        OUTPUTS:  AEROUT(NTYP) - Real - AERMOD component of concentration
!                                        without building downwash for either
!                                        coherent plume component or for
!                                        random component, depending on
!                                        L_PLUME.
!
!        CALLED FROM:   PCALC
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: J
      REAL :: AEROUT(NUMTYP) , AERTMP(NUMTYP) , FYOUT , XARG , ADJ
      LOGICAL :: L_PLUME
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'AERCALC'
 
      DO ITYP = 1 , NUMTYP
         AEROUT(ITYP) = 0.0
         AERTMP(ITYP) = 0.0
      ENDDO
 
      IF ( XARG.LT.1.0 ) THEN
!        Receptor Too Close to Source for Calculation
         DO ITYP = 1 , NUMTYP
            AEROUT(ITYP) = 0.0
            IF ( WETSCIM ) AERVALD(ITYP) = 0.0
         ENDDO
 
      ELSEIF ( TOXICS .AND. DISTR.GT.80000. ) THEN
!        Receptor is beyond 80km from source.
         DO ITYP = 1 , NUMTYP
            AEROUT(ITYP) = 0.0
            IF ( WETSCIM ) AERVALD(ITYP) = 0.0
         ENDDO
 
      ELSE
 
!        Determine Deposition Correction Factors
         IF ( LDGAS .OR. LWGAS ) THEN
            CALL PDEPG(XARG)
         ELSE
            DQCORG = 1.0
            WQCORG = 1.0
         ENDIF
         IF ( LDPART .OR. LWPART ) THEN
            CALL PDEP(XARG)
         ELSEIF ( NPD.GT.0 ) THEN
            DO J = 1 , NPD
               DQCOR(J) = 1.0
               WQCOR(J) = 1.0
            ENDDO
         ENDIF
 
!        Set initial effective parameters
         UEFF = US
         SVEFF = SVS
         SWEFF = SWS
         TGEFF = TGS
         IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
            UEFFD = US
            SVEFFD = SVS
            SWEFFD = SWS
            UEFFN = US
            SVEFFN = SVS
            SWEFFN = SWS
            UEFF3 = US
            SVEFF3 = SVS
            SWEFF3 = SWS
            TGEFF3 = TGS
         ENDIF
 
!RJP     Add temporary debugging statement here.
 
!   ENSR ENHANCEMENT OF WRITE STATEMENT TO IDENTIFY COMPONENT CONCENTRATION
         IF ( DEBUG ) THEN
            IF ( L_PLUME ) THEN
               WRITE (DBGUNT,6015) UEFF , SVEFF , SWEFF
 6015          FORMAT (//,'COHERENT PLUME COMPONENT',/,5X,              &
     &                 'Initial effective parameters for ',             &
     &                 'stable or direct convective ','plume:',//,5x,   &
     &                 'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &                 ' m/s; SWeff = ',F7.2,' m/s.',/)
            ELSE
               WRITE (DBGUNT,6016) UEFF , SVEFF , SWEFF
 6016          FORMAT (//,'MEANDER COMPONENT',/,5X,                     &
     &                 'Initial effective parameters for ',             &
     &                 'stable or direct convective ','plume:',//,5x,   &
     &                 'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &                 ' m/s; SWeff = ',F7.2,' m/s.',/)
            ENDIF
         ENDIF
 
!        Define plume centroid height (CENTER) for use in
!        inhomogeneity calculations
         CALL CENTROID(XARG)
 
!        Calculate the plume rise                     ---   CALL DELTAH
         CALL DELTAH(XARG)
 
!        If the atmosphere is unstable and the stack
!        top is below the mixing height, calculate
!        the CBL PDF coefficients                     ---   CALL PDF
         IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!        Determine Effective Plume Height             ---   CALL HEFF
         CALL HEFF(XARG)
 
!        Compute effective parameters using an
!        average through plume layer
         CALL IBLVAL(XARG)
 
!        Call PDF & HEFF again for final CBL plume heights
         IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
            CALL PDF
            CALL HEFF(XARG)
         ENDIF
 
!        Determine Dispersion Parameters              ---   CALL PDIS
         CALL PDIS(XARG)
 
!        Calculate the 'y-term' contribution to
!        dispersion, FSUBY
         IF ( L_PLUME ) THEN
!           Calculate FSUBY for coherent plume        ---   CALL FYPLM
            CALL FYPLM(SY,FYOUT)
         ELSE
!           Calculate FSUBY for random component      ---   CALL FYPAN
            CALL FYPAN(FYOUT)
         ENDIF
         FSUBY = FYOUT
         FSUBYD = FSUBY
         FSUBYN = FSUBYD
 
!        Calculate the 'y-term' contribution to dispersion
!        for the penetrated plume, FSUBY3
         IF ( UNSTAB .AND. (HS.LT.ZI) .AND. (PPF.GT.0.0) ) THEN
!           Compute meander fraction of horizontal distribution function
!           from Venky's memo of 6/24/98.
            IF ( L_PLUME ) THEN
!              Calculate FSUBY for coherent plume     ---   CALL FYPLM
               CALL FYPLM(SY3,FYOUT)
            ELSE
!              Calculate FSUBY for random component   ---   CALL FYPAN
               CALL FYPAN(FYOUT)
            ENDIF
            FSUBY3 = FYOUT
         ELSE
            FSUBY3 = 0.0
         ENDIF
 
!        Check for zero "y-terms"; if zero then skip calculations
!        and go to next receptor.
         IF ( FSUBY.EQ.0.0 .AND. FSUBY3.EQ.0.0 ) THEN
            DO ITYP = 1 , NUMTYP
               AEROUT(ITYP) = 0.0
               IF ( WETSCIM ) AERVALD(ITYP) = 0.0
            ENDDO
 
         ELSE
 
            IF ( NPD.EQ.0 ) THEN
!              Perform calculations for gases
!              Assign plume tilt, HV = 0.0
               HV = 0.0
 
               ADJ = DQCORG*WQCORG
 
               IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!                 Calculate height of the "effective reflecting surface"
                  CALL REFL_HT(HE,XARG,SZB,0.0,HSBL)
               ELSEIF ( UNSTAB ) THEN
                  HSBL = 0.0
               ENDIF
 
               IF ( UNSTAB .AND. (HS.LT.ZI) .AND. (PPF.GT.0.0) ) THEN
!                 Calculate height of the "effective reflecting surface"
                  CALL REFL_HT(HE3,XARG,SZB3,0.0,HPEN)
               ELSE
                  HPEN = 0.0
               ENDIF
 
!              Determine the CRITical Dividing Streamline---   CALL CRITDS
               CALL CRITDS(HE)
 
!              Calculate the fraction of plume below
!              HCRIT, PHEE                               ---   CALL PFRACT
               CALL PFRACT(HE)
 
!              Calculate FOPT = f(PHEE)                  ---   CALL FTERM
               CALL FTERM
 
!              Calculate AERMOD Concentration     ---   CALL AER_PCHI
               CALL AER_PCHI(XARG,ADJ,VDEPG,0,AEROUT)
 
            ELSE
!              Perform calculations for particles, loop through particle sizes
 
!              Begin loop over particle sizes
               DO J = 1 , NPD
 
!                 Calculate Plume Tilt Due to Settling, HV
                  HV = (XARG/US)*VGRAV(J)
 
!                 Adjust Jth contribution by mass fraction and source
!                 depletion
                  ADJ = PHI(J)*DQCOR(J)*WQCOR(J)
 
                  IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!                    Calculate height of the "effective reflecting surface"
!                    Calculate Settled Plume Height(s), HESETL
                     HESETL = MAX(0.0,HE-HV)
                     CALL REFL_HT(HESETL,XARG,SZB,0.0,HSBL)
                  ELSEIF ( UNSTAB ) THEN
                     HESETL = MAX(0.0,0.5*(HED1+HED2)-HV)
                     HSBL = 0.0
                  ENDIF
 
                  IF ( UNSTAB .AND. (HS.LT.ZI) .AND. (PPF.GT.0.0) ) THEN
!                    Calculate height of the "effective reflecting surface"
!                    Calculate Settled Plume Height(s), HE3SETL
                     HE3SETL = MAX(0.0,HE3-HV)
                     CALL REFL_HT(HE3SETL,XARG,SZB3,0.0,HPEN)
                     HPEN = MAX(HPEN,ZI)
                  ELSE
                     HPEN = 0.0
                  ENDIF
 
!                 Determine the CRITical Dividing Streamline---   CALL CRITDS
                  CALL CRITDS(HESETL)
 
!                 Calculate the fraction of plume below
!                 HCRIT, PHEE                               ---   CALL PFRACT
                  CALL PFRACT(HESETL)
 
!                 Calculate FOPT = f(PHEE)                  ---   CALL FTERM
                  CALL FTERM
 
!                 Calculate AERMOD Concentration            ---   CALL AER_PCHI
                  CALL AER_PCHI(XARG,ADJ,VDEP(J),J,AERTMP)
                  AEROUT = AEROUT + AERTMP
 
               ENDDO
!              End loop over particle sizes
 
            ENDIF
 
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==PRMCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PRMCALC(XBREC,YBREC)
!***********************************************************************
!             PRMCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates the PRIME downwash component of the
!                 concentration
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     November 10, 2000
!
!        MODIFIED:
!                  Modified to place receptor on centerline of cavity
!                  plumes by setting Y2 = 0.0 for SCREEN option.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 10/26/04
!
!        INPUTS:  XBREC - Real    - Downwind distance (m) of receptor
!                                   from upwind edge of building
!                 YBREC - Real    - Lateral distance (m) of receptor from
!                                   center of upwind edge of building
!
!        OUTPUTS: PRMVAL(NTYP) - Real - PRIME downwash component of
!                                       concentration
!
!        CALLED FROM:   PCALC
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL , PARAMETER :: BIGT = 24.
      INTEGER :: IPOSITN , NDXBH , N1 , N2 , N , IS , J
      REAL :: XARG , ADJ
      REAL :: DHPOUT , SYOUT , SZOUT , FYOUT
      REAL :: USTACK , UBLDG , XBREC , YBREC , FQCAV , SYCAV , SZCAV
      REAL :: ZHI , ZLO
      INTEGER :: NDXBHI , NDXBLO , NDXALO
! --- Declare local PRIME arrays for "3-source" data
      REAL Q2(3) , Y2(3) , SY2(3) , Z2(3) , H2(3) , SZ2(3) , QC2(3) ,   &
     &     QTKSAV , PPFSAV
      REAL :: CAV_VAL
 
      LOGICAL :: LDBHR , L_INWAKE
 
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PRMCALC'
 
! --- PRIME ---------------------------------------------------------
! --- Calculate where receptor is relative to near-wake cavity
!     and building (IPOSITN=1 for within bldg; 2=within
!     near-wake, 3=within far wake; 4=outside)
! --- Note:  xbrec is downwind dist. of receptor from upwind
!     bldg face; ybrec is crosswind dist. of receptor from
!     center of upwind bldg. face                  ---  CALL POSITION
      CALL POSITION(XBREC,YBREC,ZFLAG,IPOSITN)
 
      IF ( IPOSITN.EQ.4 .AND. X.LE.0.0 ) THEN
! ---    Receptor is upwind of sources and is not within
! ---    a building wake - use AERMOD calculation
         DO ITYP = 1 , NUMTYP
            PRMVAL(ITYP) = AERVAL(ITYP)
            IF ( WETSCIM ) PRMVALD(ITYP) = AERVALD(ITYP)
         ENDDO
 
      ELSEIF ( IPOSITN.NE.2 .AND. DISTR.LT.0.99 ) THEN
! ---    Receptor Too Close to Source for Calculation and is not
! ---    within a building near-wake (cavity) - use AERMOD calculation
         DO ITYP = 1 , NUMTYP
            PRMVAL(ITYP) = AERVAL(ITYP)
            IF ( WETSCIM ) PRMVALD(ITYP) = AERVALD(ITYP)
         ENDDO
! -------------------------------------------------------------
 
      ELSEIF ( TOXICS .AND. DISTR.GT.80000. ) THEN
! ---    Receptor is beyond 80km from source - use AERMOD calculation
         DO ITYP = 1 , NUMTYP
            PRMVAL(ITYP) = AERVAL(ITYP)
            IF ( WETSCIM ) PRMVALD(ITYP) = AERVALD(ITYP)
         ENDDO
 
      ELSEIF ( .NOT.WAKE ) THEN
! ---    No wake effects for this source for this hour - use AERMOD calculation
         DO ITYP = 1 , NUMTYP
            PRMVAL(ITYP) = AERVAL(ITYP)
            IF ( WETSCIM ) PRMVALD(ITYP) = AERVALD(ITYP)
         ENDDO
 
 
      ELSE
! ---    Calculate PRIME concentration with downwash
 
! ---    Calculate effective parameters to define ambient turbulence intensities,
!        as averages across layer from ground to top of wake (as calculated at
!        a downwind distance of 15R).
         ZHI = 1.2*RSCALE*(15.0+(DSBH/(1.2*RSCALE))**3)**0.333333
         IF ( UNSTAB ) ZHI = MIN(ZHI,ZI)
         ZLO = 0.0
 
         CALL LOCATE(GRIDHT,1,MXGLVL,ZHI,NDXBHI)
         CALL LOCATE(GRIDHT,1,MXGLVL,ZLO,NDXBLO)
         NDXALO = NDXBLO + 1
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDWS,ZLO,NDXALO,ZHI,NDXBHI,UEFF)
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDSV,ZLO,NDXALO,ZHI,NDXBHI,SVEFF)
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDSW,ZLO,NDXALO,ZHI,NDXBHI,SWEFF)
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDTG,ZLO,NDXALO,ZHI,NDXBHI,TGEFF)
 
!RWB     Modify treatment of low wind/low turbulence cases.
!RWB     R. Brode, PES, 8/15/96
         SWEFF = AMAX1(SWEFF,SWMIN)
         SVEFF = AMAX1(SVEFF,SVMIN,0.05*UEFF)
         UEFF = SQRT(UEFF*UEFF+2.*SVEFF*SVEFF)
 
         IF ( DEBUG ) THEN
            WRITE (IOUNIT,*) 'PRIME Effective Parameters: '
            WRITE (IOUNIT,*) 'ZLO, ZHI     = ' , ZLO , ZHI
            WRITE (IOUNIT,*) 'SWEFF, SVEFF = ' , SWEFF , SVEFF
            WRITE (IOUNIT,*) 'UEFF,  TGEFF = ' , UEFF , TGEFF
         ENDIF
 
!        Calculate the plume rise                     ---   CALL PRMDELH
         CALL PRMDELH(X,L_INWAKE)
 
         IF ( .NOT.L_INWAKE ) THEN
!           Plume is not affected by wake, set PRMVAL = AERVAL and return
            DO ITYP = 1 , NUMTYP
               PRMVAL(ITYP) = AERVAL(ITYP)
            ENDDO
            RETURN
         ENDIF
 
!        Determine Effective Plume Height             ---   CALL PRMHEFF
         CALL PRMHEFF
 
         IF ( UNSTAB .AND. HE.GE.ZI ) THEN
!           Plume is above ZI, set PRMVAL = AERVAL and return
            DO ITYP = 1 , NUMTYP
               PRMVAL(ITYP) = AERVAL(ITYP)
            ENDDO
            RETURN
         ENDIF
 
! ---    Calculate sigmas
         DHPOUT = DHP
         CALL WAKE_XSIG(X,HS,DHPOUT,NOBID,SZOUT,SYOUT,SZCAV,SYCAV)
         SY = SYOUT
         SZ = SZOUT
 
! ---    PRIME ---------------------------------------------------
! ---    When there is a building wake, consider treatment of mass in
! ---    cavity as additional sources, or as only source
         QTKSAV = QTK
         PPFSAV = PPF
! ---    Place selected plume data into transfer arrays (first element)
         Q2(1) = QTK
         Y2(1) = Y
         SY2(1) = SY
         Z2(1) = ZFLAG
         H2(1) = HE
         SZ2(1) = SZ
         N1 = 1
         N2 = 1
         IF ( WAKE ) THEN
! ---       Define cavity source                              ---   CALL CAV_SRC
            CALL CAV_SRC(X,Y,ZFLAG,FQCAV,QC2,H2,Y2,Z2,SZ2,SY2,N1,N2)
! ---          Force receptor to be on "centerline" for all plumes for SCREEN
            IF ( SCREEN ) Y2 = 0.0
            IF ( FQCAV.GT.0.0 ) THEN
! ---          Set source strengths
               Q2(1) = QTK*(1.0-FQCAV)
               Q2(2) = QTK*FQCAV*QC2(2)
               Q2(3) = QTK*FQCAV*QC2(3)
            ENDIF
         ENDIF
 
! ---    Initialize output array values to zero, because contributions
! ---    due to more than one source are summed here (or do loop may
! ---    not execute if neither source contributes)
         DO ITYP = 1 , NUMTYP
            PRMVAL(ITYP) = 0.0
         ENDDO
 
! ---    Loop over 3 possible sources (is=1 for primary source,
! ---    is=2 for "outside" cavity source, and is=3 for "inside" cavity source)
         DO IS = N1 , N2
 
! ---       Cycle to next source if emission rate is 0.0
            IF ( Q2(IS).EQ.0.0 ) GOTO 50
 
! ---       Transfer data for current source
            QTK = Q2(IS)
            Y = Y2(IS)
            SY = SY2(IS)
            SZ = SZ2(IS)
            HE = H2(IS)
            ZFLAG = Z2(IS)
 
! -------------------------------------------------------------
!           Calculate the 'y-term' contribution to
!           dispersion, FSUBY                              ---   CALL FYPLM
            CALL FYPLM(SY,FYOUT)
            FSUBY = FYOUT
 
            IF ( FSUBY.EQ.0.0 ) THEN
! ---          Lateral term is 0.0, set PRMVAL to 0.0.
               DO ITYP = 1 , NUMTYP
                  PRMVAL(ITYP) = 0.0
                  IF ( WETSCIM ) PRMVALD(ITYP) = 0.0
               ENDDO
 
            ELSE
 
! ---          Set FOPT = 0.5 for PRIME calculation since wake is "near neutral"
               FOPT = 0.5
 
               IF ( NPD.EQ.0 ) THEN
!                 Determine Deposition Correction Factors
                  IF ( (LDGAS .OR. LWGAS) .AND. IS.NE.3 .AND. X.GT.1. ) &
     &                 THEN
!                    Do not apply depletion for "inside cavity source", IS=3
                     CALL PRM_PDEPG(X)
 
!                    Reassign plume height and sigmas, which may have changed
!                    during integration
                     SY = SY2(IS)
                     SZ = SZ2(IS)
                     HE = H2(IS)
                  ELSE
                     DQCORG = 1.0
                     WQCORG = 1.0
                  ENDIF
 
                  ADJ = DQCORG*WQCORG
 
                  CALL PRM_PCHI(ADJ,VDEPG,0)
 
               ELSE
                  IF ( (LDPART .OR. LWPART) .AND. IS.NE.3 .AND.         &
     &                 X.GT.1. ) THEN
!                    Do not apply depletion for "inside cavity source", IS=3
                     CALL PRM_PDEP(X)
 
!                    Reassign plume height and sigmas, which may have changed
!                    during integration
                     SY = SY2(IS)
                     SZ = SZ2(IS)
                     HE = H2(IS)
                  ELSE
                     DO J = 1 , NPD
                        DQCOR(J) = 1.0
                        WQCOR(J) = 1.0
                     ENDDO
                  ENDIF
 
                  DO J = 1 , NPD
 
                     ADJ = PHI(J)*DQCOR(J)*WQCOR(J)
                     HV = (X/US)*VGRAV(J)
                     HE = MAX(0.0,HE-HV)
 
                     CALL PRM_PCHI(ADJ,VDEP(J),J)
 
                  ENDDO
               ENDIF
 
            ENDIF
 
 50      ENDDO
 
! ---    Restore original plume data
         QTK = QTKSAV
         PPF = PPFSAV
         Y = Y2(1)
         SY = SY2(1)
         SZ = SZ2(1)
         HE = H2(1)
         ZFLAG = Z2(1)
 
      ENDIF
 
      CONTINUE
      END
!*==GAMCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE GAMCALC(XARG,YARG)
!***********************************************************************
!             GAMCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates the Gamma weighting factor to combine
!                 AERMOD and PRIME concentrations
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     July 19, 2001
!
!        INPUTS:   XARG - Real - Downwind distance (m) of receptor
!                                from upwind edge of building
!                  YARG - Real - Lateral distance (m) of receptor from
!                                center of upwind edge of building
!
!        OUTPUTS:  GAMFACT - Real - Gamma weighting factor to combine
!                                   AERMOD and PRIME concentrations
!
!        CALLED FROM:   PCALC
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG , YARG , ZTMP
      REAL :: WAKE_LEN , WAKE_WID , WAKE_HGT
      REAL :: XAY , XAZ , XAMX
      REAL :: SIGMA_XG , SIGMA_YG , SIGMA_ZG , EXPARG_XG , EXPARG_YG ,  &
     &        EXPARG_ZG
 
      SAVE 
 
! --- Variable Initializations
      MODNAM = 'GAMCALC'
 
      IF ( XARG.LE.0.0 .OR. .NOT.WAKE ) THEN
! ---    Receptor is upwind of building or no WAKE, set GAMFACT = 0.0 to
! ---    use AERVAL only.
         GAMFACT = 0.0
 
      ELSE
 
! ---    Calculate the height, half-width and "length" of the wake.
! ---    Length of wake is measured from upwind edge of building.
         WAKE_HGT = 1.2*RSCALE*(XARG/RSCALE+(DSBH/(1.2*RSCALE))**3)     &
     &              **0.333333
         WAKE_WID = 0.5*DSBW + (RSCALE/3.)*(XARG/RSCALE)**0.333333
! ---    Obtain distance to transition from wake to ambient turbulence,
! ---    without cap at 15R.
         CALL WAKE_XA2(KST,RURAL,DSBL,RSCALE,XAZ,XAY)
         XAMX = MAX(XAZ,XAY)
! ---    Set WAKE_LEN as maximum of 15R and transition distance
         WAKE_LEN = MAX(15.0*RSCALE,XAMX)
!
! ---    Assign wake dimensions to SIGMA_?G terms
         SIGMA_XG = WAKE_LEN
         SIGMA_YG = WAKE_WID
         SIGMA_ZG = WAKE_HGT
 
! ---    Calculate exponential argument for alongwind dimension
         IF ( XARG.LE.SIGMA_XG ) THEN
            EXPARG_XG = 0.0
         ELSE
            EXPARG_XG = -((XARG-SIGMA_XG)**2/(2.0*SIGMA_XG**2))
         ENDIF
 
! ---    Calculate exponential argument for crosswind dimension
         IF ( ABS(YARG).LE.SIGMA_YG ) THEN
            EXPARG_YG = 0.0
         ELSE
            EXPARG_YG = -((ABS(YARG)-SIGMA_YG)**2/(2.0*SIGMA_YG**2))
         ENDIF
 
! ---    Calculate exponential argument for vertical dimension, using ZRT,
! ---    height of receptor above stack base, including terrain and flagpole.
         IF ( ZRT.LE.SIGMA_ZG ) THEN
            EXPARG_ZG = 0.0
         ELSE
            EXPARG_ZG = -((ZRT-SIGMA_ZG)**2/(2.0*SIGMA_ZG**2))
         ENDIF
 
!        Calculate gamma weighting factor, GAMFACT
         IF ( EXPARG_XG.GT.EXPLIM .AND. EXPARG_YG.GT.EXPLIM .AND.       &
     &        EXPARG_ZG.GT.EXPLIM ) THEN
            GAMFACT = EXP(EXPARG_XG)*EXP(EXPARG_YG)*EXP(EXPARG_ZG)
         ELSE
            GAMFACT = 0.0
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==CENTROID.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE CENTROID(XARG)
!***********************************************************************
!             CENTROID Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates the plume centroid height, and sets the
!                 SURFAC logical variable
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     November 10, 2000
!
!        INPUTS:  Downwind distance, XARG (m)
!
!        OUTPUTS: Plume centroid height, CENTER
!                 Surface logical variable, SURFAC
!
!        CALLED FROM:   PCALC, VCALC, ACALC, PLUMEF
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG , DELX , DELZ , FRAC , XTMP
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'CENTROID'
 
      XTMP = MAX(XARG,1.0)
 
      IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
!----    Calculate plume centerline height without PDF adjustments
         IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
            CALL CBLPRD(XTMP)
            HTEFF = AMIN1(HSP+DHP1,ZI)
         ELSE
            HTEFF = HSP
         ENDIF
         IF ( XTMP.LT.XFINAL ) THEN
            CENTER = HTEFF
         ELSEIF ( XTMP.GE.XMIXED ) THEN
            CENTER = ZMIDMX
         ELSE
            DELX = XMIXED - XFINAL
            DELZ = ZMIDMX - AMIN1(HSP+DHCRIT,ZI)
            FRAC = (XTMP-XFINAL)/DELX
            CENTER = AMIN1(HSP+DHCRIT,ZI) + FRAC*DELZ
         ENDIF
 
!----    Determine if this is a surface layer release
         IF ( CENTER.LT.0.1*ZI ) THEN
            SURFAC = .TRUE.
 
         ELSE
            SURFAC = .FALSE.
         ENDIF
 
      ELSEIF ( UNSTAB .AND. (HS.GE.ZI) ) THEN
         SURFAC = .FALSE.
         CENTER = HSP
 
      ELSE
!----    Assign centroid height to release height
         CENTER = HSP
 
      ENDIF
 
      CONTINUE
      END
!*==REFL_HT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE REFL_HT(HEARG,XARG,SZBARG,VSIGZARG,HEREFL)
!***********************************************************************
!             REFL_HT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates height of the "effective reflecting surface"
!                 for stable plumes, including penetrated source for
!                 point sources.
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     November 10, 2000
!
!        INPUTS:  Height of plume (m),                HEARG
!                 Downwind distance (m),              XARG
!                 Bouyancy induced dispersion (m),    SZBARG
!                 Virtual source dispersion term (m), VSIGZARG
!
!        OUTPUTS: Effective height of the reflecting surface (m), HEREFL
!
!        CALLED FROM:   PCALC, VCALC, ACALC, PLUMEF
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: NDXHE
      REAL :: HEARG , HEREFL , XARG , SZBARG , VSIGZARG , SVREFL ,      &
     &        SWREFL , UREFL , TGREFL , PTREFL , TTRAVL , BVFRQ , ZTMP ,&
     &        SZREFL , SZRF , SIGF , SZHSBL
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'REFL_HT'
 
!---- Compute the height of the "effective reflecting surface"
!---- for stable plumes, HEREFL
!---- First locate index below HEARG
      CALL LOCATE(GRIDHT,1,MXGLVL,HEARG,NDXHE)
 
      IF ( NDXHE.GE.1 ) THEN
 
!---- Sigma_V at HEARG
         CALL GINTRP(GRIDHT(NDXHE),GRIDSV(NDXHE),GRIDHT(NDXHE+1),       &
     &               GRIDSV(NDXHE+1),HEARG,SVREFL)
 
!---- Sigma_W at HEARG
         CALL GINTRP(GRIDHT(NDXHE),GRIDSW(NDXHE),GRIDHT(NDXHE+1),       &
     &               GRIDSW(NDXHE+1),HEARG,SWREFL)
 
!---- Wind speed at HEARG
         CALL GINTRP(GRIDHT(NDXHE),GRIDWS(NDXHE),GRIDHT(NDXHE+1),       &
     &               GRIDWS(NDXHE+1),HEARG,UREFL)
 
!---- Temperature gradient at HEARG
         CALL GINTRP(GRIDHT(NDXHE),GRIDTG(NDXHE),GRIDHT(NDXHE+1),       &
     &               GRIDTG(NDXHE+1),HEARG,TGREFL)
 
!---- Potential temperature at HEARG
         CALL GINTRP(GRIDHT(NDXHE),GRIDPT(NDXHE),GRIDHT(NDXHE+1),       &
     &               GRIDPT(NDXHE+1),HEARG,PTREFL)
 
      ELSE
         SVREFL = GRIDSV(1)
         SWREFL = GRIDSW(1)
         UREFL = GRIDWS(1)
         TGREFL = GRIDTG(1)
         PTREFL = GRIDPT(1)
      ENDIF
!
!---- Apply minimum wind speed and turbulence checks to values
!     at HEARG
!
      SWREFL = AMAX1(SWREFL,SWMIN)
      SVREFL = AMAX1(SVREFL,SVMIN,0.05*UREFL)
      UREFL = SQRT(UREFL*UREFL+2.*SVREFL*SVREFL)
 
!     Compute surface sigma-z term for stable conditions
      IF ( STABLE ) THEN
         SZSURF = (RTOF2/RTOFPI)*USTAR*(XARG/UREFL)                     &
     &            *(1.0+0.7*XARG/OBULEN)**(-1.0/3.0)
      ELSE
         SZSURF = 0.0
      ENDIF
 
!     Compute ambient sigma-z term at HEARG
      TTRAVL = XARG/UREFL
!---- Apply Sigma-Z formulation from CTDMPLUS
 
      BVFRQ = SQRT(G*TGREFL/PTREFL)
      IF ( BVFRQ.LT.1.0E-10 ) BVFRQ = 1.0E-10
 
!     Set height for sigma-z calculation, ZTMP
      ZTMP = AMAX1(HS,HEARG,1.0E-4)
      SZREFL = SWREFL*TTRAVL/SQRT                                       &
     &         (1.0+SWREFL*TTRAVL*(1.0/(0.72*ZTMP)+BVFRQ/(0.54*SWREFL)))
 
      IF ( HEARG.GE.ZI ) THEN
         SZRF = SZREFL
      ELSE
         SIGF = AMIN1(HEARG/ZI,1.0)
         SZRF = (1.0-SIGF)*SZSURF + SIGF*SZREFL
      ENDIF
 
!     Calculate sigma-z at plume height, SZHSBL
      SZHSBL = SQRT(SZBARG*SZBARG+SZRF*SZRF+VSIGZARG*VSIGZARG)
 
!     Compute height of effective reflecting surface, HEREFL
      HEREFL = AMAX1(ZI,HEARG+2.15*SZHSBL)
 
!     For urban/stable plumes below ZI, set HEREFL = ZI.
      IF ( URBSTAB .AND. HEARG.LT.ZI ) HEREFL = ZI
 
      CONTINUE
      END
!*==PSRDEB.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PSRDEB
!***********************************************************************
!             PSRDEB Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Outputs point source information for debugging
!                 purposes
!
!        PROGRAMMER: Bob Paine.  Implemented by Russ Lee.
!
!        DATE:    August 18, 1994
!
!        INPUTS:  Source Parameters for Specific Source, including
!                 those calculated in PCALC
!
!RJP              DHCRIT = "Final" plume rise (m)
!
!        OUTPUTS: Debugging information for a specific source.
!
!        CALLED FROM:   CALC
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PSRDEB'
 
      WRITE (DBGUNT,6130) KURDAT
 
 6130 FORMAT (20('===='),//,' yymmddhh:  ',I8,//,8X,                    &
     &        '<----------------- SOURCE INFORMATION ---------',        &
     &        '------> FINAL PLUME',/,                                  &
     &       ' SOURCE   QS    TS      VS     DS   BUOY FLUX  MOM FLUX  '&
     &       ,' HS      RISE',/,                                        &
     &       '   #    (G/S)   (K)    (M/S)   (M)   (M4/S3)    (M4/S2)  '&
     &       ,' (M)      (M)',/)
 
      WRITE (DBGUNT,6135) ISRC , QS , TS , VS , DS , FB , FM , HS ,     &
     &                    DHCRIT
 6135 FORMAT (I4,F9.1,F7.1,F7.2,F7.2,F10.1,2X,F9.1,F6.1,F9.1,//,2X,     &
     &        'VARIABLES AT ',T21,'HEIGHT   WDIR   ',                   &
     &        'USCAL  URISE  SIGV   SIGW   DTHDZ ',/,2X,'STACK HEIGHT:',&
     &        T21,'  (M)    (DEG)  (M/S)  (M/S)  (M/S)  (M/S) (DEG/M)', &
     &        /)
      WRITE (DBGUNT,6140) HS , WDIR , US , UP , SVS , SWS , TGS
 6140 FORMAT (19X,F7.1,F7.0,F8.2,2F7.2,F7.2,F8.4,/)
 
      CONTINUE
      END
!*==VCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE VCALC
!***********************************************************************
!        VCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates concentration or deposition values
!                 for VOLUME sources
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:
!                  Modified to include initialization of __VAL arrays
!                  at end of receptor loop.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 10/26/04
!
!                  Modified to include the PVMRM and OLM options for
!                  modeling conversion of NOx to NO2.
!                  Added debug statement based on ENSR code.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!                  To assign values to XDIST before calls to
!                  SUBROUTINE VOLCALC.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 03/19/04
!
!        INPUTS:  Source Parameters for Specific Source
!                 Arrays of Receptor Locations
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: 1-hr CONC or DEPOS Values for Each Receptor for
!                 Particular Source
!
!        CALLED FROM:   CALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
      REAL :: AERPLM(NUMTYP) , AERPAN(NUMTYP) , FRAN
      LOGICAL :: L_PLUME
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'VCALC'
      WAKE = .FALSE.
 
!     Initialize HRVAL arrays
      DO ITYP = 1 , NUMTYP
         HRVAL(ITYP) = 0.0
         HRVALD(ITYP) = 0.0
         AERVAL(ITYP) = 0.0
         AERVALD(ITYP) = 0.0
         AERPLM(ITYP) = 0.0
         AERPAN(ITYP) = 0.0
      ENDDO
 
!     Set the Source Variables for This Source              ---   CALL SETSRC
      CALL SETSRC
 
!     Apply Variable Emission Rate and Unit Factors         ---   CALL EMFACT
      CALL EMFACT(QS)
 
!     Initialize 'ARC' Arrays for EVALFILE Output           ---   CALL EVLINI
      IF ( EVAL(ISRC) ) CALL EVLINI
 
      IF ( QTK.NE.0.0 ) THEN
!        Set Mixing Height and Profiles for Urban Option if Needed
         IF ( STABLE .AND. URBAN ) THEN
            IF ( URBSRC(ISRC).EQ.'Y' ) THEN
               URBSTAB = .TRUE.
               ZI = AMAX1(ZIURB,ZIMECH)
               GRIDSV = GRDSVU
               GRIDSW = GRDSWU
               GRIDTG = GRDTGU
               GRIDPT = GRDPTU
               OBULEN = ABS(URBOBULEN)
               USTAR = URBUSTR
            ELSEIF ( URBSRC(ISRC).EQ.'N' ) THEN
               URBSTAB = .FALSE.
               ZI = ZIRUR
               GRIDSV = GRDSVR
               GRIDSW = GRDSWR
               GRIDTG = GRDTGR
               GRIDPT = GRDPTR
               OBULEN = RUROBULEN
               USTAR = RURUSTR
            ENDIF
         ELSE
            URBSTAB = .FALSE.
         ENDIF
 
!        Initialize meteorological variables                ---   CALL METINI
         CALL METINI
!        Initialize miscellaneous variables
         FB = 0.0
         FM = 0.0
         PPF = 0.0
         HSP = HS
         DHP = 0.0
         DHP1 = 0.0
         DHP2 = 0.0
         DHP3 = 0.0
         DHCRIT = 0.0
         XFINAL = 0.0
         XMIXED = ZI*UAVG/SWAVG
         IF ( XMIXED.LT.XFINAL ) XMIXED = XFINAL
         ZMIDMX = 0.5*ZI
 
!        Calculate Effective Radius
         XRAD = 2.15*SYINIT
 
!DEP     Initialize PDF parameters for use in calculating ZSUBP
         IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
!        Set Deposition Variables for this Source
!           Calculate Deposition Velocities for this Source    ---   CALL VDP
         IF ( LDPART .OR. LDGAS ) CALL VDP
         IF ( LWPART .OR. LWGAS ) THEN
!PES        Set value of ZSUBP = MAX( ZI, TOP OF PLUME ), where
!PES        TOP OF PLUME is defined as plume height (HE) plus 2.15*SZ,
!PES        evaluated at a distance of 20 kilometers downwind.
!PES        Apply minimum value of 500m and maximum value of 10,000m.
            IF ( STABLE .OR. (UNSTAB .AND. HS.GE.ZI) ) THEN
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HS+SZCOEF*SZAS)
            ELSEIF ( UNSTAB ) THEN
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HS+SZCOEF*(SZAD1+SZAD2)/2.)
            ENDIF
            ZSUBP = MIN(10000.,ZSUBP)
!           Calculate Scavenging Ratios for this Source           ---   CALL SCAVRAT
            CALL SCAVRAT
         ENDIF
 
!        Begin Receptor LOOP
         RECEPTOR_LOOP:DO IREC = 1 , NUMREC
!           Calculate Down and Crosswind Distances          ---   CALL XYDIST
            IF ( EVONLY ) THEN
               CALL XYDIST(IEVENT)
            ELSE
               CALL XYDIST(IREC)
            ENDIF
 
! ---       First calculate coherent plume component using downwind distance
            L_PLUME = .TRUE.
! ---       Assign XDIST for use in dry depletion (FUNCTION F2INT)
            XDIST = X
            CALL VOLCALC(X,L_PLUME,AERPLM)
 
! ---       Next calculate random "pancake" component using radial distance
            L_PLUME = .FALSE.
! ---       Assign XDIST for use in dry depletion (FUNCTION F2INT)
            XDIST = DISTR
            CALL VOLCALC(DISTR,L_PLUME,AERPAN)
 
! ---       Calculate fraction of random kinetic energy to total kinetic energy.
!           Note that these effective parameters are based on the radial dist.
            IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
               CALL MEANDR(UEFF,SVEFF,FRAN)
            ELSEIF ( UNSTAB ) THEN
               CALL MEANDR(UEFFD,SVEFFD,FRAN)
            ENDIF
 
! ---       Combine coherent plume and random "pancake" components
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = FRAN*AERPAN(ITYP) + (1.-FRAN)*AERPLM(ITYP)
!   ENSR STATEMENT
               IF ( DEBUG ) THEN
                  WRITE (DBGUNT,10) AERPAN(ITYP) , AERPLM(ITYP) , FRAN ,&
     &                              HRVAL(ITYP)
 10               FORMAT (/,                                            &
     &       'HRVAL(ITYP) = FRAN*AERPAN(ITYP) + (1.-FRAN) *AERPLM(ITYP)'&
     &       ,//,'PANCAKE/MEANDER COMPONENT, AERPAN(ITYP) = ',G16.8,/,  &
     &       'COHERENT PLUME COMPONENT,  AERPLM(ITYP) = ',G16.8,/,      &
     &       'MEANDER FACTOR, FRAN = ',G16.8,/,                         &
     &       'RESULTANT CONC, HRVAL(ITYP) = ',G16.8,//)
               ENDIF
            ENDDO
 
            IF ( PVMRM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for PVMRM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
               IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
                  HECNTR(IREC,ISRC) = HE
                  UEFFS(IREC,ISRC) = UEFF
               ELSE
                  HECNTR(IREC,ISRC) = CENTER
                  UEFFS(IREC,ISRC) = UEFFD
               ENDIF
               IF ( PPF.GT.0.0 ) THEN
                  HECNTR3(IREC,ISRC) = HE3
                  PPFACT(ISRC) = PPF
                  UEFF3S(IREC,ISRC) = UEFF3
               ENDIF
               FOPTS(IREC,ISRC) = FOPT
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 50
            ELSEIF ( OLM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for OLM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 50
            ENDIF
 
            IF ( EVONLY ) THEN
               CALL EV_SUMVAL
            ELSE
               CALL SUMVAL
            ENDIF
!              Check ARC centerline values for EVALFILE
!              output                              ---   CALL EVALCK
            IF ( EVAL(ISRC) ) CALL EVALCK
 
!           Initialize __VAL arrays
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = 0.0
               HRVALD(ITYP) = 0.0
               AERVAL(ITYP) = 0.0
               AERVALD(ITYP) = 0.0
               AERPLM(ITYP) = 0.0
               AERPAN(ITYP) = 0.0
            ENDDO
 
 50      ENDDO RECEPTOR_LOOP
!        End Receptor LOOP
 
!        Output 'ARC' Values for EVALFILE                   ---   CALL EVALFL
         IF ( EVAL(ISRC) ) CALL EVALFL
 
      ENDIF
 
      CONTINUE
      END
!*==VOLCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE VOLCALC(XARG,L_PLUME,AEROUT)
!***********************************************************************
!             VOLCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates the AERMOD concentration without downwash
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     November 10, 2000
!
!        CHANGES:
!                  Added debug statement based on ENSR code.
!                  R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!        INPUTS:   XARG         - Real - Distance (m), downwind for coherent
!                                        plume component and radial for
!                                        random component
!                  L_PLUME      - Log  - Specifies coherent plume calculation
!                                        if TRUE, otherwise random component
!
!        OUTPUTS:  AEROUT(NTYP) - Real - AERMOD component of concentration
!                                        without building downwash for either
!                                        coherent plume component or for
!                                        random component, depending on
!                                        L_PLUME.
!
!        CALLED FROM:   VCALC
!
!***********************************************************************
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: AEROUT(NUMTYP) , AERTMP(NUMTYP) , FYOUT , XARG , ADJ
      INTEGER :: J
      LOGICAL :: L_PLUME
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'VOLCALC'
 
      DO ITYP = 1 , NUMTYP
         AEROUT(ITYP) = 0.0
         AERTMP(ITYP) = 0.0
      ENDDO
 
      IF ( DISTR.LT.(XRAD+0.99) ) THEN
!        Receptor Too Close to Source for Calculation
         DO ITYP = 1 , NUMTYP
            AEROUT(ITYP) = 0.0
            IF ( WETSCIM ) HRVALD(ITYP) = 0.0
         ENDDO
      ELSEIF ( (XARG-XRAD).LT.0.0 ) THEN
!        Receptor Upwind of Downwind Edge
         DO ITYP = 1 , NUMTYP
            AEROUT(ITYP) = 0.0
            IF ( WETSCIM ) HRVALD(ITYP) = 0.0
         ENDDO
      ELSEIF ( TOXICS .AND. DISTR.GT.80000. ) THEN
!        Receptor is beyond 80km from source.
         DO ITYP = 1 , NUMTYP
            AEROUT(ITYP) = 0.0
            IF ( WETSCIM ) HRVALD(ITYP) = 0.0
         ENDDO
      ELSE
 
!        Determine Deposition Correction Factors
         IF ( LDGAS .OR. LWGAS ) THEN
            CALL PDEPG(XARG)
         ELSE
            DQCORG = 1.0
            WQCORG = 1.0
         ENDIF
         IF ( LDPART .OR. LWPART ) THEN
            CALL PDEP(XARG)
         ELSEIF ( NPD.GT.0 ) THEN
            DO J = 1 , NPD
               DQCOR(J) = 1.0
               WQCOR(J) = 1.0
            ENDDO
         ENDIF
 
!        Set initial effective parameters
         UEFF = US
         SVEFF = SVS
         SWEFF = SWS
         TGEFF = TGS
         IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
            UEFFD = US
            SVEFFD = SVS
            SWEFFD = SWS
            UEFFN = US
            SVEFFN = SVS
            SWEFFN = SWS
         ENDIF
 
!RJP     Add temporary debugging statement here.
 
!   ENSR ENHANCEMENT OF WRITE STATEMENT TO IDENTIFY COMPONENT CONCENTRATION
         IF ( DEBUG ) THEN
            IF ( L_PLUME ) THEN
               WRITE (DBGUNT,6015) UEFF , SVEFF , SWEFF
 6015          FORMAT (//,'COHERENT PLUME COMPONENT',/,5X,              &
     &                 'Initial effective parameters for ',             &
     &                 'stable or direct convective ','plume:',//,5x,   &
     &                 'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &                 ' m/s; SWeff = ',F7.2,' m/s.',/)
            ELSE
               WRITE (DBGUNT,6016) UEFF , SVEFF , SWEFF
 6016          FORMAT (//,'MEANDER COMPONENT',/,5X,                     &
     &                 'Initial effective parameters for ',             &
     &                 'stable or direct convective ','plume:',//,5x,   &
     &                 'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &                 ' m/s; SWeff = ',F7.2,' m/s.',/)
            ENDIF
         ENDIF
 
!        Define plume centroid height (CENTER) for use in
!        inhomogeniety calculations
         CALL CENTROID(XARG)
 
!        If the atmosphere is unstable and the stack
!        top is below the mixing height, calculate
!        the CBL PDF coefficients                     ---   CALL PDF
         IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!        Determine Effective Plume Height             ---   CALL HEFF
         CALL HEFF(XARG)
 
!        Compute effective parameters using an
!        iterative average through plume rise layer
         CALL IBLVAL(XARG)
 
!        Call PDF & HEFF again for final CBL plume heights
         IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
            CALL PDF
            CALL HEFF(XARG)
         ENDIF
 
!        Determine Dispersion Parameters              ---   CALL VDIS
         CALL VDIS(XARG)
 
!        Calculate the 'y-term' contribution to
!        dispersion, FSUBY
         IF ( L_PLUME ) THEN
!           Calculate FSUBY for coherent plume        ---   CALL FYPLM
            CALL FYPLM(SY,FYOUT)
         ELSE
!           Calculate FSUBY for random component      ---   CALL FYPAN
            CALL FYPAN(FYOUT)
         ENDIF
         FSUBY = FYOUT
         FSUBYD = FSUBY
         FSUBYN = FSUBYD
 
!        Set lateral term = 0.0 for penetrated source
         FSUBY3 = 0.0
 
!        Check for zero "y-terms"; if zero then skip calculations
!        and go to next receptor.
         IF ( FSUBY.EQ.0.0 .AND. FSUBY3.EQ.0.0 ) THEN
            DO ITYP = 1 , NUMTYP
               AEROUT(ITYP) = 0.0
               IF ( WETSCIM ) HRVALD(ITYP) = 0.0
            ENDDO
 
         ELSE
 
            IF ( NPD.EQ.0 ) THEN
!              Perform calculations for gases
!              Assign plume tilt, HV = 0.0
 
               ADJ = DQCORG*WQCORG
 
               IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!                 Calculate height of the "effective reflecting surface"
                  CALL REFL_HT(HE,XARG,0.0,VSIGZ,HSBL)
               ELSEIF ( UNSTAB ) THEN
                  HSBL = 0.0
               ENDIF
 
!              Determine the CRITical Dividing Streamline---   CALL CRITDS
               CALL CRITDS(HE)
 
!              Calculate the fraction of plume below
!              HCRIT, PHEE                               ---   CALL PFRACT
               CALL PFRACT(HE)
 
!              Calculate FOPT = f(PHEE)                  ---   CALL FTERM
               CALL FTERM
 
!              Calculate Conc. for Virtual Point Source  ---   CALL AER_PCHI
               CALL AER_PCHI(XARG,ADJ,VDEPG,0,AEROUT)
 
            ELSE
!              Perform calculations for particles, loop through particle sizes
 
!              Begin loop over particle sizes
               DO J = 1 , NPD
 
!                 Calculate Plume Tilt Due to Settling, HV
                  HV = (XARG/US)*VGRAV(J)
 
!                 Adjust Jth contribution by mass fraction and source
!                 depletion
                  ADJ = PHI(J)*DQCOR(J)*WQCOR(J)
 
                  IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!                    Calculate height of the "effective reflecting surface"
                     HESETL = MAX(0.0,HE-HV)
                     CALL REFL_HT(HESETL,XARG,0.0,VSIGZ,HSBL)
                  ELSEIF ( UNSTAB ) THEN
                     HESETL = MAX(0.0,0.5*(HED1+HED2)-HV)
                     HSBL = 0.0
                  ENDIF
 
!                 Determine the CRITical Dividing Streamline---   CALL CRITDS
                  CALL CRITDS(HESETL)
 
!                 Calculate the fraction of plume below
!                 HCRIT, PHEE                               ---   CALL PFRACT
                  CALL PFRACT(HESETL)
 
!                 Calculate FOPT = f(PHEE)                  ---   CALL FTERM
                  CALL FTERM
 
!                 Calculate Conc. for Virtual Point Source  ---   CALL AER_PCHI
                  CALL AER_PCHI(XARG,ADJ,VDEP(J),J,AERTMP)
                  AEROUT = AEROUT + AERTMP
 
               ENDDO
!              End loop over particle sizes
 
            ENDIF
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==ACALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE ACALC
!***********************************************************************
!            ACALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates concentration or deposition values
!                 for AREA sources utilizing an integrated line source.
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   Modified to include initialization of __VAL arrays
!                    at end of receptor loop.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 10/26/04
!
!        MODIFIED:   To include the PVMRM and OLM options for
!                    modeling conversion of NOx to NO2.
!                    Added debug statement based on ENSR code.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!        MODIFIED:   To include tilted plume for point source
!                    approximation of particle emissions.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 07/23/04
!
!        MODIFIED:   To allow TOXICS option for AREAPOLY sources.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 05/12/04
!
!        MODIFIED:   To assign value to XDIST for use in dry depletion.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 03/19/04
!
!        MODIFIED:   To avoid potential math errors for AREAPOLY sources
!                    R.W. Brode, PES, Inc. - 02/25/02
!
!        MODIFIED:   To incorporate numerical integration algorithm
!                    for AREA source - 7/7/93
!
!        INPUTS:  Source Parameters for Specific Source
!                 Arrays of Receptor Locations
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: Array of 1-hr CONC or DEPOS Values for Each Source/Receptor
!
!        CALLED FROM:   CALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I , J
      REAL :: XDEP , WIDTH , LENGTH , XMAXR , QTKSAV , XPOINT , ADJ
      REAL :: AEROUT(NUMTYP) , FYOUT
 
      SAVE 
      REAL XSPA(NVMAX) , YSPA(NVMAX)
 
!     Variable Initializations
      MODNAM = 'ACALC'
      WAKE = .FALSE.
 
      DO ITYP = 1 , NUMTYP
         HRVAL(ITYP) = 0.0
         HRVALD(ITYP) = 0.0
         AERVAL(ITYP) = 0.0
         AERVALD(ITYP) = 0.0
         AEROUT(ITYP) = 0.0
      ENDDO
 
!     Set the Source Variables for This Source              ---   CALL SETSRC
      CALL SETSRC
 
!     Apply Variable Emission Rate and Unit Factors         ---   CALL EMFACT
      CALL EMFACT(QS)
 
!     Initialize 'ARC' Arrays for EVALFILE Output           ---   CALL EVLINI
      IF ( EVAL(ISRC) ) CALL EVLINI
 
      IF ( QTK.NE.0.0 ) THEN
!        Set Mixing Height and Profiles for Urban Option if Needed
         IF ( STABLE .AND. URBAN ) THEN
            IF ( URBSRC(ISRC).EQ.'Y' ) THEN
               URBSTAB = .TRUE.
               ZI = AMAX1(ZIURB,ZIMECH)
               GRIDSV = GRDSVU
               GRIDSW = GRDSWU
               GRIDTG = GRDTGU
               GRIDPT = GRDPTU
               OBULEN = ABS(URBOBULEN)
               USTAR = URBUSTR
            ELSEIF ( URBSRC(ISRC).EQ.'N' ) THEN
               URBSTAB = .FALSE.
               ZI = ZIRUR
               GRIDSV = GRDSVR
               GRIDSW = GRDSWR
               GRIDTG = GRDTGR
               GRIDPT = GRDPTR
               OBULEN = RUROBULEN
               USTAR = RURUSTR
            ENDIF
         ELSE
            URBSTAB = .FALSE.
         ENDIF
 
!        Initialize meteorological variables                ---   CALL METINI
         CALL METINI
!        Initialize miscellaneous variables
         FB = 0.0
         FM = 0.0
         PPF = 0.0
         HSP = HS
         DHP = 0.0
         DHP1 = 0.0
         DHP2 = 0.0
         DHP3 = 0.0
         DHCRIT = 0.0
         XFINAL = 0.0
         XMIXED = ZI*UAVG/SWAVG
         IF ( XMIXED.LT.XFINAL ) XMIXED = XFINAL
         ZMIDMX = 0.5*ZI
 
!DEP     Initialize PDF parameters for use in calculating ZSUBP
         IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
!        Set Deposition Variables for this Source
!           Calculate Deposition Velocities for this Source    ---   CALL VDP
         IF ( LDPART .OR. LDGAS ) CALL VDP
         IF ( LWPART .OR. LWGAS ) THEN
!PES        Set value of ZSUBP = MAX( ZI, TOP OF PLUME ), where
!PES        TOP OF PLUME is defined as plume height (HE) plus 2.15*SZ,
!PES        evaluated at a distance of 20 kilometers downwind.
!PES        Apply minimum value of 500m and maximum value of 10,000m.
            IF ( STABLE .OR. (UNSTAB .AND. HS.GE.ZI) ) THEN
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HS+SZCOEF*SZAS)
            ELSEIF ( UNSTAB ) THEN
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HS+SZCOEF*(SZAD1+SZAD2)/2.)
            ENDIF
            ZSUBP = MIN(10000.,ZSUBP)
!           Calculate Scavenging Ratios for this Source           ---   CALL SCAVRAT
            CALL SCAVRAT
         ENDIF
 
!        Begin Receptor LOOP
         RECEPTOR_LOOP:DO IREC = 1 , NUMREC
!           Calculate Down and Crosswind Distances          ---   CALL ARDIST
            IF ( EVONLY ) THEN
               CALL ARDIST(IEVENT,XDEP,WIDTH,LENGTH,XMAXR)
            ELSE
               CALL ARDIST(IREC,XDEP,WIDTH,LENGTH,XMAXR)
            ENDIF
 
!           Check to see if receptor is upwind of area source
            IF ( XMAXR.LT.1.0 ) GOTO 50
 
!           Check to see if receptor is more than 80km from source.
            IF ( TOXICS .AND. DISTR.GT.80000. ) GOTO 50
 
!           Set initial effective parameters
            UEFF = US
            SVEFF = SVS
            SWEFF = SWS
            TGEFF = TGS
            IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
               UEFFD = US
               SVEFFD = SVS
               SWEFFD = SWS
               UEFFN = US
               SVEFFN = SVS
               SWEFFN = SWS
            ENDIF
 
!           Check to see if receptor is beyond edge of plume laterally.
            IF ( (ABS(Y)-0.5*WIDTH).GT.0. ) THEN
               CALL ADISY(XMAXR)
               IF ( (ABS(Y)-0.5*WIDTH).GE.4.*SY ) GOTO 50
            ENDIF
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6015) UEFF , SVEFF , SWEFF
!   ENSR ENHANCEMENT OF WRITE STATEMENT
 6015          FORMAT (//,'AERMOD AREA SOURCE COMPONENT',/,5X,          &
     &                 'Initial effective parameters for ',             &
     &                 'stable or direct convective ','plume:',//,5x,   &
     &                 'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &                 ' m/s; SWeff = ',F7.2,' m/s.',/)
            ENDIF
 
!           Determine the CRITical Dividing Streamline      ---   CALL CRITDS
            CALL CRITDS(HE)
 
!           Set distance factor for point source approx. for TOXICS based
!           on "equivalent" PG stability class (KST)
            IF ( URBSTAB ) THEN
               VP_FACT = VIRTPNT_URB(KST)
            ELSE
               VP_FACT = VIRTPNT_RUR(KST)
            ENDIF
 
!           Calculate distance for switch to point source approx. for TOXICS
            XPOINT = 1.5*LENGTH + VP_FACT*WIDTH
 
! ---       Assign XDIST for use in dry depletion (FUNCTION F2INT)
            XDIST = X
 
            IF ( .NOT.TOXICS .OR. (TOXICS .AND. X.LT.XPOINT) ) THEN
               IF ( ARDPLETE ) THEN
 
                  IF ( LDGAS .OR. LWGAS ) THEN
                     CALL PDEPG(XDEP)
                  ELSE
                     DQCORG = 1.0
                     WQCORG = 1.0
                  ENDIF
                  IF ( LDPART .OR. LWPART ) THEN
                     CALL PDEP(XDEP)
                  ELSEIF ( NPD.GT.0 ) THEN
                     DO J = 1 , NPD
                        DQCOR(J) = 1.0
                        WQCOR(J) = 1.0
                     ENDDO
                  ENDIF
 
               ENDIF
 
               DO ITYP = 1 , NUMTYP
!                 Calculate Area Source Integral         ---   CALL AREAIN
                  CALL AREAIN
               ENDDO
            ELSE
!              Use point source approximation
!              Save emissions per unit area and calculate total emissions
               QTKSAV = QTK
               IF ( SRCTYP(ISRC).EQ.'AREA' .OR. SRCTYP(ISRC)            &
     &              .EQ.'AREAPOLY' ) THEN
!                 Note that XINIT and YINIT are equivalent values for AREAPOLY
                  QTK = QTK*XINIT*YINIT
               ELSEIF ( SRCTYP(ISRC).EQ.'AREACIRC' ) THEN
                  QTK = QTK*PI*RADIUS(ISRC)*RADIUS(ISRC)
               ENDIF
               SYINIT = 0.0
 
!              Determine Deposition Correction Factors
               IF ( LDGAS .OR. LWGAS ) THEN
                  CALL PDEPG(X)
               ELSE
                  DQCORG = 1.0
                  WQCORG = 1.0
               ENDIF
               IF ( LDPART .OR. LWPART ) THEN
                  CALL PDEP(X)
               ELSEIF ( NPD.GT.0 ) THEN
                  DO J = 1 , NPD
                     DQCOR(J) = 1.0
                     WQCOR(J) = 1.0
                  ENDDO
               ENDIF
 
!              Define plume centroid height (CENTER) for use in
!              inhomogeniety calculations
               CALL CENTROID(X)
 
!              If the atmosphere is unstable and the stack
!              top is below the mixing height, calculate
!              the CBL PDF coefficients                     ---   CALL PDF
               IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!              Determine Effective Plume Height             ---   CALL HEFF
               CALL HEFF(X)
 
!              Compute effective parameters using an
!              iterative average through plume rise layer
               CALL IBLVAL(X)
 
!              Call PDF & HEFF again for final CBL plume heights
               IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
                  CALL PDF
                  CALL HEFF(X)
               ENDIF
 
!              Determine Dispersion Parameters              ---   CALL VDIS
               CALL VDIS(X)
 
!              Calculate the 'y-term' contribution to
!              dispersion, FSUBY, for coherent plume        ---   CALL FYPLM
               CALL FYPLM(SY,FYOUT)
               FSUBY = FYOUT
               FSUBYD = FSUBY
               FSUBYN = FSUBYD
 
!              Set lateral term = 0.0 for penetrated source
               FSUBY3 = 0.0
 
!              Check for zero "y-terms"; if zero then skip calculations
!              and go to next receptor.
               IF ( FSUBY.EQ.0.0 .AND. FSUBY3.EQ.0.0 ) THEN
                  DO ITYP = 1 , NUMTYP
                     HRVAL(ITYP) = 0.0
                     IF ( WETSCIM ) HRVALD(ITYP) = 0.0
                  ENDDO
 
               ELSE
 
                  IF ( NPD.EQ.0 ) THEN
!                    Perform calculations for gases
!                    Assign plume tilt, HV = 0.0
 
                     ADJ = DQCORG*WQCORG
 
                     IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!                       Calculate height of the "effective reflecting surface"
                        CALL REFL_HT(HE,X,0.0,VSIGZ,HSBL)
                     ELSEIF ( UNSTAB ) THEN
                        HSBL = 0.0
                     ENDIF
 
!                    Determine the CRITical Dividing Streamline---   CALL CRITDS
                     CALL CRITDS(HE)
 
!                    Calculate the fraction of plume below
!                    HCRIT, PHEE                               ---   CALL PFRACT
                     CALL PFRACT(HE)
 
!                    Calculate FOPT = f(PHEE)                  ---   CALL FTERM
                     CALL FTERM
 
!                    Calculate Conc. for Virtual Point Source  ---   CALL AER_PCHI
                     CALL AER_PCHI(X,ADJ,VDEPG,0,AEROUT)
                     HRVAL = AEROUT
 
                  ELSE
!                    Perform calculations for particles, loop through particle sizes
 
!                    Begin loop over particle sizes
                     DO J = 1 , NPD
 
!                       Calculate Plume Tilt Due to Settling, HV
                        HV = (X/US)*VGRAV(J)
 
!                       Adjust Jth contribution by mass fraction and source
!                       depletion
                        ADJ = PHI(J)*DQCOR(J)*WQCOR(J)
 
                        IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) )    &
     &                       THEN
!                          Calculate height of the "effective reflecting surface"
!                          Calculate Settled Plume Height(s), HESETL
                           HESETL = MAX(0.0,HE-HV)
                           CALL REFL_HT(HESETL,X,0.0,VSIGZ,HSBL)
                        ELSEIF ( UNSTAB ) THEN
!                          Calculate Settled Plume Height(s), HESETL
                           HESETL = MAX(0.0,0.5*(HED1+HED2)-HV)
                           HSBL = 0.0
                        ENDIF
 
!                       Determine the CRITical Dividing Streamline---   CALL CRITDS
                        CALL CRITDS(HESETL)
 
!                       Calculate the fraction of plume below
!                       HCRIT, PHEE                               ---   CALL PFRACT
                        CALL PFRACT(HESETL)
 
!                       Calculate FOPT = f(PHEE)                  ---   CALL FTERM
                        CALL FTERM
 
!                       Calculate Conc. for Virtual Point Source  ---   CALL AER_PCHI
                        CALL AER_PCHI(X,ADJ,VDEP(J),J,AEROUT)
                        HRVAL = HRVAL + AEROUT
 
                     ENDDO
!                    End loop over particle sizes
 
                  ENDIF
               ENDIF
               QTK = QTKSAV
            ENDIF
 
            IF ( PVMRM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for PVMRM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
               IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
                  HECNTR(IREC,ISRC) = HE
                  UEFFS(IREC,ISRC) = UEFF
               ELSE
                  HECNTR(IREC,ISRC) = CENTER
                  UEFFS(IREC,ISRC) = UEFFD
               ENDIF
               IF ( PPF.GT.0.0 ) THEN
                  HECNTR3(IREC,ISRC) = HE3
                  PPFACT(ISRC) = PPF
                  UEFF3S(IREC,ISRC) = UEFF3
               ELSE
                  PPFACT(ISRC) = 0.0
               ENDIF
               FOPTS(IREC,ISRC) = FOPT
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 50
            ELSEIF ( OLM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for OLM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 50
            ENDIF
 
!           Sum HRVAL to AVEVAL and ANNVAL Arrays           ---   CALL SUMVAL
            IF ( EVONLY ) THEN
               CALL EV_SUMVAL
            ELSE
               CALL SUMVAL
            ENDIF
 
!           Initialize __VAL arrays
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = 0.0
               HRVALD(ITYP) = 0.0
               AERVAL(ITYP) = 0.0
               AERVALD(ITYP) = 0.0
               AEROUT(ITYP) = 0.0
            ENDDO
 
 50      ENDDO RECEPTOR_LOOP
!        End Receptor LOOP
 
!        Output 'ARC' Values for EVALFILE                   ---   CALL EVALFL
         IF ( EVAL(ISRC) ) CALL EVALFL
 
      ENDIF
 
      CONTINUE
      END
!*==ARDIST.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ARDIST(INDX,XDEP,WIDTH,LENGTH,XMAXREC)
!***********************************************************************
!                 ARDIST Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Sets Receptor Variables and Calculates Downwind (X)
!                 and Crosswind (Y) Distances, Crosswind Width (WIDTH),
!                 Distance used for AREADPLT Option (XDEP), Maximum
!                 Downwind Distance by Vertex (XMAXREC), and
!                 Radial Distance from Source to Receptor (DISTR)
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Source Location
!                 Arrays of Receptor Locations
!                 SIN and COS of Wind Direction FROM Which Wind
!                 is Blowing, WDSIN and WDCOS
!
!        OUTPUTS: Values of X, Y, and DISTR (m) [in MAIN1]
!                 XDEP (m)
!                 WIDTH (m)
!                 LENGTH (m)
!                 XMAXREC (m)
!
!        CALLED FROM:   ACALC
!                       OCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , INDX
      REAL :: XSRC , YSRC , XMINREC , XMAXREC , YMINREC , YMAXREC ,     &
     &        XDEP , WIDTH , LENGTH
 
!     Variable Initializations
      MODNAM = 'ARDIST'
 
!     Set Receptor Coordinates, Terrain Elevation and Flagpole Heights
      XR = AXR(INDX)
      YR = AYR(INDX)
      ZELEV = AZELEV(INDX)
      ZHILL = AZHILL(INDX)
      ZFLAG = AZFLAG(INDX)
 
      XMINREC = 9999999.
      XMAXREC = -9999999.
      YMINREC = 9999999.
      YMAXREC = -9999999.
 
!     Calculate Downwind (X) and Crosswind (Y) Distances for Each Vertex
      DO I = 1 , NVERT + 1
         XSRC = XVERT(I)
         YSRC = YVERT(I)
         SPA(I,1) = -((XR-XSRC)*WDSIN+(YR-YSRC)*WDCOS)
         SPA(I,2) = (XR-XSRC)*WDCOS - (YR-YSRC)*WDSIN
         XMINREC = MIN(XMINREC,SPA(I,1))
         XMAXREC = MAX(XMAXREC,SPA(I,1))
         YMINREC = MIN(YMINREC,SPA(I,2))
         YMAXREC = MAX(YMAXREC,SPA(I,2))
      ENDDO
 
!     Calculate crosswind width, WIDTH, and alongwind length, LENGTH
      WIDTH = YMAXREC - YMINREC
      LENGTH = XMAXREC - XMINREC
 
!     Determine downwind distance to use for AREADPLT option, XDEP
      IF ( XMINREC.GE.0.0 ) THEN
         XDEP = XMINREC + 0.333333*LENGTH
      ELSE
         XDEP = 0.333333*XMAXREC
      ENDIF
 
      XDEP = MAX(1.0,XDEP)
 
!     Calculate Downwind (X) and Crosswind (Y) Distances from Center of Source
      X = -((XR-XCNTR)*WDSIN+(YR-YCNTR)*WDCOS)
      Y = (XR-XCNTR)*WDCOS - (YR-YCNTR)*WDSIN
 
!     Calculate Radial Distance from Center of Source
      DISTR = SQRT(X*X+Y*Y)
 
!     Calculate height of receptor above stack base, ZRT
      ZRT = ZELEV - ZS + ZFLAG
 
      CONTINUE
      END
!*==OCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OCALC
!***********************************************************************
!                 OCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates concentration or deposition values
!                 for OPENPIT sources
!
!        PROGRAMMER: Jayant Hardikar, Roger Brode
!        ADAPTED FROM:  SUBROUTINE ACALC
!
!        DATE:    July 19, 1994
!
!        MODIFIED:   Modified to include initialization of __VAL arrays
!                    at end of receptor loop.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 10/26/04
!
!        MODIFIED:   To include tilted plume for point source
!                    approximation of particle emissions.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 07/23/04
!
!        MODIFIED:   To move call to METINI up since AFV is needed for
!                    SUBROUTINE LWIND.
!                    R. W. Brode, PES Inc., - 1/22/98
!
!        MODIFIED:   To skip calculations if QPTOT = 0.0, avoiding
!                    zero divide error in SUB. AMFRAC.
!                    R. W. Brode, PES Inc., - 4/14/95
!
!        INPUTS:  Source Parameters for Specific Source
!                 Arrays of Receptor Locations
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: Array of 1-hr CONC or DEPOS Values for Each Source/Receptor
!
!        CALLED FROM:   CALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I , II , J , ICAT , INOUT , NDXR
      REAL :: QPTOT , XVM(5) , YVM(5) , XDEP , WIDTH , LENGTH , XMAXR , &
     &        QTKSAV , XPOINT , ADJ , FYOUT
      REAL :: AEROUT(NUMTYP)
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'OCALC'
      WAKE = .FALSE.
 
      DO ITYP = 1 , NUMTYP
         HRVAL(ITYP) = 0.0
         HRVALD(ITYP) = 0.0
         AEROUT(ITYP) = 0.0
         AERVALD(ITYP) = 0.0
         AEROUT(ITYP) = 0.0
      ENDDO
 
!     Obtain reference wind speed at 10-meters
!---- First locate index below 10.
      CALL LOCATE(GRIDHT,1,MXGLVL,10.,NDXR)
      CALL GINTRP(GRIDHT(NDXR),GRIDWS(NDXR),GRIDHT(NDXR+1),             &
     &            GRIDWS(NDXR+1),10.,UREF10)
 
!     Set Mixing Height and Profiles for Urban Option if Needed
      IF ( STABLE .AND. URBAN ) THEN
         IF ( URBSRC(ISRC).EQ.'Y' ) THEN
            URBSTAB = .TRUE.
            ZI = AMAX1(ZIURB,ZIMECH)
            GRIDSV = GRDSVU
            GRIDSW = GRDSWU
            GRIDTG = GRDTGU
            GRIDPT = GRDPTU
            OBULEN = ABS(URBOBULEN)
            USTAR = URBUSTR
         ELSEIF ( URBSRC(ISRC).EQ.'N' ) THEN
            URBSTAB = .FALSE.
            ZI = ZIRUR
            GRIDSV = GRDSVR
            GRIDSW = GRDSWR
            GRIDTG = GRDTGR
            GRIDPT = GRDPTR
            OBULEN = RUROBULEN
            USTAR = RURUSTR
         ENDIF
      ELSE
         URBSTAB = .FALSE.
      ENDIF
 
!     Set the Source Variables for This Source              ---   CALL SETSRC
      CALL SETSRC
 
!     Initialize meteorological variables                   ---   CALL METINI
      CALL METINI
 
!*    Initialize the Total Adjusted Emission Rate from
!*    All Particles
      QPTOT = 0.0
 
!*    Loop over Particle Size Categories
      DO ICAT = 1 , NPD
!*       Calculate the Escape Fraction for Each Category    ---   CALL ESCAPE
         CALL ESCAPE(ICAT)
 
!*       Adjust the Emission Rate for Each Category         ---   CALL ADJEMI
         CALL ADJEMI(ICAT,QPTOT)
 
!*    End Loop Over Particle Size Categories
      ENDDO
 
!*    Skip Calculations if QPTOT = 0.0
      IF ( QPTOT.EQ.0.0 ) GOTO 999
 
!*    Adjust the Mass Fractions for All the Particle
!*    Size Categories                                       ---   CALL AMFRAC
      CALL AMFRAC(QPTOT)
 
!*    Determine the AlongWind Length of the OPENPIT Source  ---   CALL LWIND
      CALL LWIND
 
!*    Calculate the Relative Depth of the OPENPIT Source    ---   CALL PDEPTH
      CALL PDEPTH
 
!*    Calculate the Fractional Size of the
!*    Effective Pit Area                                    ---   CALL PTFRAC
      CALL PTFRAC
 
 
!*    WRITE DEBUG INFORMATION
      IF ( DEBUG ) THEN
         WRITE (IOUNIT,*)
         WRITE (IOUNIT,*)
         WRITE (IOUNIT,*) 'DETAIL INFORMATION ON THE OPENPIT SOURCE:'
         WRITE (IOUNIT,*)
         WRITE (IOUNIT,*)
      ENDIF
 
!*    Determine the Coordinates of the Effective Pit Area
!*    in Wind Direction Coordinate System                   ---   CALL PITEFF
      CALL PITEFF
 
!*    Calculate the Emission Rate for the Effective
!*    Pit Area                                              ---   CALL PITEMI
      CALL PITEMI(QPTOT)
 
!*    WRITE DEBUG INFORMATION
      IF ( DEBUG ) THEN
         WRITE (IOUNIT,*) 'OPENPIT PARTICLE CHARACTERISTICS:'
         WRITE (IOUNIT,*) '-------------------------------'
         WRITE (IOUNIT,*)
         WRITE (IOUNIT,8000) (EFRAC(II),II=1,NPD)
 8000    FORMAT (1X,'ESCAPE FRACTIONS= ',10(F8.3,2X))
         WRITE (IOUNIT,8200) (QPART(II),II=1,NPD)
 8200    FORMAT (1X,'ADJUSTED EMISSION RATES= ',10(F8.3,2X))
         WRITE (IOUNIT,8400) (PHI(II),II=1,NPD)
 8400    FORMAT (1X,'ADJUSTED MASS FRACTIONS= ',10(F8.3,2X))
         WRITE (IOUNIT,*) 'EMISSION RATE OF EFFECTIVE PIT= ' , QEFF
         WRITE (IOUNIT,*)
      ENDIF
 
!     Apply Variable Emission Rate and Unit Factors         ---   CALL EMFACT
      CALL EMFACT(QEFF)
 
!     Initialize 'ARC' Arrays for EVALFILE Output           ---   CALL EVLINI
      IF ( EVAL(ISRC) ) CALL EVLINI
 
      IF ( (QTK.NE.0.0) .AND. (STABLE .OR. (HS.LE.ZI)) ) THEN
!        Initialize miscellaneous variables
         FB = 0.0
         FM = 0.0
         PPF = 0.0
         HSP = HS
         DHP = 0.0
         DHP1 = 0.0
         DHP2 = 0.0
         DHP3 = 0.0
         DHCRIT = 0.0
         XFINAL = 0.0
         XMIXED = ZI*UAVG/SWAVG
         IF ( XMIXED.LT.XFINAL ) XMIXED = XFINAL
         ZMIDMX = 0.5*ZI
 
!DEP     Initialize PDF parameters for use in calculating ZSUBP
         IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
!        Set Deposition Variables for this Source
!           Calculate Deposition Velocities for this Source    ---   CALL VDP
         IF ( LDPART .OR. LDGAS ) CALL VDP
         IF ( LWPART .OR. LWGAS ) THEN
!PES        Set value of ZSUBP = MAX( ZI, TOP OF PLUME ), where
!PES        TOP OF PLUME is defined as plume height (HE) plus 2.15*SZ,
!PES        evaluated at a distance of 20 kilometers downwind.
!PES        Apply minimum value of 500m and maximum value of 10,000m.
            IF ( STABLE .OR. (UNSTAB .AND. HS.GE.ZI) ) THEN
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HS+SZCOEF*SZAS)
            ELSEIF ( UNSTAB ) THEN
               CALL SIGZ(20000.)
               ZSUBP = MAX(500.,ZI,HS+SZCOEF*(SZAD1+SZAD2)/2.)
            ENDIF
            ZSUBP = MIN(10000.,ZSUBP)
!           Calculate Scavenging Ratios for this Source           ---   CALL SCAVRAT
            CALL SCAVRAT
         ENDIF
 
!        Begin Receptor LOOP
         RECEPTOR_LOOP:DO IREC = 1 , NUMREC
!           Check for receptor located inside boundary of open pit source
            DO I = 1 , NVERT + 1
               XVM(I) = AXVERT(I,ISRC)
               YVM(I) = AYVERT(I,ISRC)
            ENDDO
            XR = AXR(IREC)
            YR = AYR(IREC)
            CALL PNPOLY(XR,YR,XVM,YVM,5,INOUT)
!              Receptor is within boundary - skip to next receptor
            IF ( INOUT.GT.0 ) GOTO 50
 
!           Calculate Down and Crosswind Distances          ---   CALL ARDIST
            IF ( EVONLY ) THEN
               CALL ARDIST(IEVENT,XDEP,WIDTH,LENGTH,XMAXR)
            ELSE
               CALL ARDIST(IREC,XDEP,WIDTH,LENGTH,XMAXR)
            ENDIF
 
!           Check to see if receptor is upwind of area source
            IF ( XMAXR.LT.1.0 ) GOTO 50
 
!           Check to see if receptor is more than 80km from source.
            IF ( TOXICS .AND. DISTR.GT.80000. ) GOTO 50
 
!           Set initial effective parameters
            UEFF = US
            SVEFF = SVS
            SWEFF = SWS
            TGEFF = TGS
            IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
               UEFFD = US
               SVEFFD = SVS
               SWEFFD = SWS
               UEFFN = US
               SVEFFN = SVS
               SWEFFN = SWS
            ENDIF
 
!           Check to see if receptor is beyond edge of plume laterally.
            IF ( (ABS(Y)-0.5*WIDTH).GT.0. ) THEN
               CALL ADISY(XMAXR)
               IF ( (ABS(Y)-0.5*WIDTH).GE.4.*SY ) GOTO 50
            ENDIF
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6015) UEFF , SVEFF , SWEFF
 6015          FORMAT (//,5X,'Initial effective parameters for ',       &
     &                 'stable or direct convective ','plume:',//,5x,   &
     &                 'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &                 ' m/s; SWeff = ',F7.2,' m/s.',/)
            ENDIF
 
!           Determine the CRITical Dividing Streamline---   CALL CRITDS
            CALL CRITDS(HE)
 
!           Set distance factor for point source approx. for TOXICS based
!           on "equivalent" PG stability class (KST)
            IF ( URBSTAB ) THEN
               VP_FACT = VIRTPNT_URB(KST)
            ELSE
               VP_FACT = VIRTPNT_RUR(KST)
            ENDIF
 
!           Calculate distance for switch to point source approx. for TOXICS
            XPOINT = 1.5*LENGTH + VP_FACT*WIDTH
 
            IF ( .NOT.TOXICS .OR. (TOXICS .AND. X.LT.XPOINT) ) THEN
               IF ( ARDPLETE ) THEN
 
                  IF ( LDGAS .OR. LWGAS ) THEN
                     CALL PDEPG(XDEP)
                  ELSE
                     DQCORG = 1.0
                     WQCORG = 1.0
                  ENDIF
                  IF ( LDPART .OR. LWPART ) THEN
                     CALL PDEP(XDEP)
                  ELSEIF ( NPD.GT.0 ) THEN
                     DO J = 1 , NPD
                        DQCOR(J) = 1.0
                        WQCOR(J) = 1.0
                     ENDDO
                  ENDIF
 
               ENDIF
 
               DO ITYP = 1 , NUMTYP
!                 Calculate Area Source Integral         ---   CALL AREAIN
                  CALL AREAIN
               ENDDO
            ELSE
!              Use point source approximation
!              Save emissions per unit area and calculate total emissions
               QTKSAV = QTK
               QTK = QTK*XINIT*YINIT
               SYINIT = 0.0
 
!              Determine Deposition Correction Factors
               IF ( LDGAS .OR. LWGAS ) THEN
                  CALL PDEPG(X)
               ELSE
                  DQCORG = 1.0
                  WQCORG = 1.0
               ENDIF
               IF ( LDPART .OR. LWPART ) THEN
                  CALL PDEP(X)
               ELSEIF ( NPD.GT.0 ) THEN
                  DO J = 1 , NPD
                     DQCOR(J) = 1.0
                     WQCOR(J) = 1.0
                  ENDDO
               ENDIF
 
!              Define plume centroid height (CENTER) for use in
!              inhomogeniety calculations
               CALL CENTROID(X)
 
!              If the atmosphere is unstable and the stack
!              top is below the mixing height, calculate
!              the CBL PDF coefficients                     ---   CALL PDF
               IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!              Determine Effective Plume Height             ---   CALL HEFF
               CALL HEFF(X)
 
!              Compute effective parameters using an
!              iterative average through plume rise layer
               CALL IBLVAL(X)
 
!              Call PDF & HEFF again for final CBL plume heights
               IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
                  CALL PDF
                  CALL HEFF(X)
               ENDIF
 
!              Determine Dispersion Parameters              ---   CALL VDIS
               CALL VDIS(X)
 
!              Calculate the 'y-term' contribution to
!              dispersion, FSUBY, for coherent plume        ---   CALL FYPLM
               CALL FYPLM(SY,FYOUT)
               FSUBY = FYOUT
               FSUBYD = FSUBY
               FSUBYN = FSUBYD
 
!              Set lateral term = 0.0 for penetrated source
               FSUBY3 = 0.0
 
!              Check for zero "y-terms"; if zero then skip calculations
!              and go to next receptor.
               IF ( FSUBY.EQ.0.0 .AND. FSUBY3.EQ.0.0 ) THEN
                  DO ITYP = 1 , NUMTYP
                     HRVAL(ITYP) = 0.0
                     IF ( WETSCIM ) HRVALD(ITYP) = 0.0
                  ENDDO
 
               ELSE
 
                  IF ( NPD.EQ.0 ) THEN
!                    Perform calculations for gases
!                    Assign plume tilt, HV = 0.0
 
                     ADJ = DQCORG*WQCORG
 
                     IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!                       Calculate height of the "effective reflecting surface"
                        CALL REFL_HT(HE,X,0.0,VSIGZ,HSBL)
                     ELSEIF ( UNSTAB ) THEN
                        HSBL = 0.0
                     ENDIF
 
!                    Determine the CRITical Dividing Streamline---   CALL CRITDS
                     CALL CRITDS(HE)
 
!                    Calculate the fraction of plume below
!                    HCRIT, PHEE                               ---   CALL PFRACT
                     CALL PFRACT(HE)
 
!                    Calculate FOPT = f(PHEE)                  ---   CALL FTERM
                     CALL FTERM
 
!                    Calculate Conc. for Virtual Point Source  ---   CALL AER_PCHI
                     CALL AER_PCHI(X,ADJ,VDEPG,0,AEROUT)
                     HRVAL = AEROUT
 
                  ELSE
!                    Perform calculations for particles, loop through particle sizes
 
!                    Begin loop over particle sizes
                     DO J = 1 , NPD
 
!                       Calculate Plume Tilt Due to Settling, HV
                        HV = (X/US)*VGRAV(J)
 
!                       Adjust Jth contribution by mass fraction and source
!                       depletion
                        ADJ = PHI(J)*DQCOR(J)*WQCOR(J)
 
                        IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) )    &
     &                       THEN
!                          Calculate height of the "effective reflecting surface"
!                          Calculate Settled Plume Height(s), HESETL
                           HESETL = MAX(0.0,HE-HV)
                           CALL REFL_HT(HESETL,X,0.0,VSIGZ,HSBL)
                        ELSEIF ( UNSTAB ) THEN
!                          Calculate Settled Plume Height(s), HESETL
                           HESETL = MAX(0.0,0.5*(HED1+HED2)-HV)
                           HSBL = 0.0
                        ENDIF
 
!                       Determine the CRITical Dividing Streamline---   CALL CRITDS
                        CALL CRITDS(HESETL)
 
!                       Calculate the fraction of plume below
!                       HCRIT, PHEE                               ---   CALL PFRACT
                        CALL PFRACT(HESETL)
 
!                       Calculate FOPT = f(PHEE)                  ---   CALL FTERM
                        CALL FTERM
 
!                       Calculate Conc. for Virtual Point Source  ---   CALL AER_PCHI
                        CALL AER_PCHI(X,ADJ,VDEP(J),J,AEROUT)
                        HRVAL = HRVAL + AEROUT
 
                     ENDDO
!                    End loop over particle sizes
 
                  ENDIF
               ENDIF
               QTK = QTKSAV
            ENDIF
 
            IF ( PVMRM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for PVMRM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
               IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
                  HECNTR(IREC,ISRC) = HE
                  UEFFS(IREC,ISRC) = UEFF
               ELSE
                  HECNTR(IREC,ISRC) = CENTER
                  UEFFS(IREC,ISRC) = UEFFD
               ENDIF
               IF ( PPF.GT.0.0 ) THEN
                  HECNTR3(IREC,ISRC) = HE3
                  PPFACT(ISRC) = PPF
                  UEFF3S(IREC,ISRC) = UEFF3
               ELSE
                  PPFACT(ISRC) = 0.0
               ENDIF
               FOPTS(IREC,ISRC) = FOPT
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 50
            ELSEIF ( OLM .AND. .NOT.O3MISS ) THEN
! ---          Store data by source and receptor for OLM option
               DO ITYP = 1 , NUMTYP
                  CHI(IREC,ISRC,ITYP) = HRVAL(ITYP)
               ENDDO
!              Cycle to next receptor & skip call to SUMVAL (will be done later)
               GOTO 50
            ENDIF
 
!           Sum HRVAL to AVEVAL and ANNVAL Arrays           ---   CALL SUMVAL
            IF ( EVONLY ) THEN
               CALL EV_SUMVAL
            ELSE
               CALL SUMVAL
            ENDIF
 
!           Initialize __VAL arrays
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = 0.0
               HRVALD(ITYP) = 0.0
               AEROUT(ITYP) = 0.0
               AERVALD(ITYP) = 0.0
               AEROUT(ITYP) = 0.0
            ENDDO
 
 50      ENDDO RECEPTOR_LOOP
!        End Receptor LOOP
 
!        Output 'ARC' Values for EVALFILE                   ---   CALL EVALFL
         IF ( EVAL(ISRC) ) CALL EVALFL
 
      ENDIF
 
 999  CONTINUE
      END
!*==SETSRC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE SETSRC
!***********************************************************************
!             SETSRC Module of the AMS/EPA Regulatory Model - AERMOD
! ----------------------------------------------------------------------
! ---    ISC-PRIME     Version 1.0    Level 970812              Modified
! ---        D. Strimaitis
! ---        Earth Tech, Inc.
!            Prepared for EPRI under contract WO3527-01
! ----------------------------------------------------------------------
!
!        PURPOSE: Sets the Source Parameters for a Particular Source
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate inputs for numerical integration
!                    algorithm for AREA source - 7/7/93
!
!        INPUTS:  Source Parameters Arrays
!                 Source Index
!
!        OUTPUTS: Source Parameters for a Particular Source
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: J
 
!     Variable Initializations
      MODNAM = 'SETSRC'
 
!     Assign The Values From Array Elements To Variables
      IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
         XS = AXS(ISRC)
         YS = AYS(ISRC)
         ZS = AZS(ISRC)
         QS = AQS(ISRC)
         HS = AHS(ISRC)
 
         DS = ADS(ISRC)
         VS = AVS(ISRC)
         TS = ATS(ISRC)
 
      ELSEIF ( SRCTYP(ISRC).EQ.'VOLUME' ) THEN
         XS = AXS(ISRC)
         YS = AYS(ISRC)
         ZS = AZS(ISRC)
         QS = AQS(ISRC)
         HS = AHS(ISRC)
 
         SYINIT = ASYINI(ISRC)
         SZINIT = ASZINI(ISRC)
 
      ELSEIF ( SRCTYP(ISRC).EQ.'AREA' ) THEN
         XS = AXS(ISRC)
         YS = AYS(ISRC)
         ZS = AZS(ISRC)
         QS = AQS(ISRC)
         HS = AHS(ISRC)
 
         XINIT = AXINIT(ISRC)
         YINIT = AYINIT(ISRC)
         ANGLE = AANGLE(ISRC)
 
         SZINIT = ASZINI(ISRC)
         NVERT = 4
 
!        Store Vertices in Temporary Arrays
         DO IVERT = 1 , NVERT + 1
            XVERT(IVERT) = AXVERT(IVERT,ISRC)
            YVERT(IVERT) = AYVERT(IVERT,ISRC)
         ENDDO
 
         XCNTR = AXCNTR(ISRC)
         YCNTR = AYCNTR(ISRC)
 
      ELSEIF ( SRCTYP(ISRC).EQ.'AREAPOLY' ) THEN
         XS = AXS(ISRC)
         YS = AYS(ISRC)
         ZS = AZS(ISRC)
         QS = AQS(ISRC)
         HS = AHS(ISRC)
 
         SZINIT = ASZINI(ISRC)
         NVERT = NVERTS(ISRC)
 
!        Store Vertices in Temporary Arrays
         DO IVERT = 1 , NVERT + 1
            XVERT(IVERT) = AXVERT(IVERT,ISRC)
            YVERT(IVERT) = AYVERT(IVERT,ISRC)
         ENDDO
 
!        Assign equivalent values of XINIT and YINIT for calculating area
         XINIT = AXINIT(ISRC)
         YINIT = AYINIT(ISRC)
 
!        Assign centroid of polygon
         XCNTR = AXCNTR(ISRC)
         YCNTR = AYCNTR(ISRC)
 
      ELSEIF ( SRCTYP(ISRC).EQ.'AREACIRC' ) THEN
         XS = AXS(ISRC)
         YS = AYS(ISRC)
         ZS = AZS(ISRC)
         QS = AQS(ISRC)
         HS = AHS(ISRC)
 
         SZINIT = ASZINI(ISRC)
         NVERT = NVERTS(ISRC)
 
!        Store Vertices in Temporary Arrays
         DO IVERT = 1 , NVERT + 1
            XVERT(IVERT) = AXVERT(IVERT,ISRC)
            YVERT(IVERT) = AYVERT(IVERT,ISRC)
         ENDDO
 
!        Assign equivalent values of XINIT and YINIT for calculating area
         XINIT = AXINIT(ISRC)
         YINIT = AYINIT(ISRC)
 
         XCNTR = AXCNTR(ISRC)
         YCNTR = AYCNTR(ISRC)
 
      ELSEIF ( SRCTYP(ISRC).EQ.'OPENPIT' ) THEN
         XS = AXS(ISRC)
         YS = AYS(ISRC)
         ZS = AZS(ISRC)
         QS = AQS(ISRC)
!        Set Emission Height of Effective Area, HS = 0.0
         HS = 0.0
!        Set Height of Emissions Above Base of Pit, EMIHGT
         EMIHGT = AHS(ISRC)
         NVERT = 4
 
         XINIT = AXINIT(ISRC)
         YINIT = AYINIT(ISRC)
         ANGLE = AANGLE(ISRC)
         PALPHA = AALPHA(ISRC)
         PDEFF = APDEFF(ISRC)
         SZINIT = ASZINI(ISRC)
         PITLEN = MAX(XINIT,YINIT)
         PITWID = MIN(XINIT,YINIT)
 
!        Store Vertices in Temporary Arrays
         DO IVERT = 1 , NVERT + 1
            XVERT(IVERT) = AXVERT(IVERT,ISRC)
            YVERT(IVERT) = AYVERT(IVERT,ISRC)
         ENDDO
 
         XCNTR = AXCNTR(ISRC)
         YCNTR = AYCNTR(ISRC)
 
      ENDIF
 
      NPD = INPD(ISRC)
      IF ( NPD.GT.0 ) THEN
         DO J = 1 , NPD
            PDIAM(J) = APDIAM(J,ISRC)
            PHI(J) = APHI(J,ISRC)
            PDENS(J) = APDENS(J,ISRC)
            VGRAV(J) = AVGRAV(J,ISRC)
            TSTOP(J) = ATSTOP(J,ISRC)
         ENDDO
      ENDIF
 
!     Initialize SURFAC variable
      SURFAC = .FALSE.
 
      CONTINUE
      END
!*==FLUXES.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE FLUXES
!***********************************************************************
!             FLUXES Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates the source momentum and buoyancy fluxes
!
!        PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Ambient temperature at source height, TA
!                 Source gas exit temperature, TS
!                 Source gas exit velocity, VS
!                 Source diameter, DS
!
!        OUTPUTS: Momentum flux, FM, and buoyancy flux, FB
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'FLUXES'
 
!     Note:  TA is now ambient temperature AT STACK HEIGHT and
!            was computed in METINI
 
!     Check for Negative Stack Temperature, Used to
!     Indicate Constant TS-TA
      IF ( TS.LT.0.0 ) TS = TA + ABS(TS)
 
      IF ( TS.LT.TA ) TS = TA
      FB = (0.25/TS)*(VS*DS*DS)*G*(TS-TA)
      FM = (0.25/TS)*(VS*DS*DS)*VS*TA
 
!     To avoid divide by zero or underflow, set FB and FM to a minimum value
      IF ( FB.LT.1.0E-10 ) FB = 1.0E-10
      IF ( FM.LT.1.0E-10 ) FM = 1.0E-10
 
      CONTINUE
      END
!*==HEFF.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HEFF(XARG)
!***********************************************************************
!             HEFF Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Effective Plume Height (m)
!
!        PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        REVISIONS:  Corrected formulations for HEN1 & HEN2 per
!                    Model Formulation Document and conversation
!                    with Russ Lee and Jeff Weil.
!                    Roger Brode, PES, Inc. - 12/7/94
!
!        INPUTS:  Arrays of Source Parameters
!                 Logical Wake Flags
!                 Meteorological Variables for One Hour
!                 Wind Speed Adjusted to Stack Height
!                 Downwind Distance
!                 Terrain Elevation of Receptor
!
!        OUTPUTS: Effective Plume Height (HE)
!
!        CALLED FROM:   PCALC, VCALC, ACALC, PLUMEF
!
!   References:   "A Dispersion Model for the Convective Boundary
!                  Layer", J. Weil, 8/17/93
!                 "Plume Penetration of the CBL and Source 3: Source
!                  Strength and Plume Rise", J. Weil, 9/1/93
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'HEFF'
 
!     Compute the effective plume height
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!        The atmosphere is stable or the release is above the CBL
!        mixing ht.
         HE = HSP + DHP
!        Don't Allow Effective Plume Height to be < 0.0
         HE = AMAX1(0.0,HE)
 
      ELSEIF ( UNSTAB ) THEN
!        The atmosphere is unstable and the release is below the
!        mixing ht.
 
!        Compute the effective direct plume height, for both the
!        Plume 1 (HED1) and Plume 2 (HED2)
         HED1 = HSP + DHP1 + (ASUB1*WSTAR*XARG/UEFFD)
         HED2 = HSP + DHP1 + (ASUB2*WSTAR*XARG/UEFFD)
 
!        Compute the effective indirect plume height, for both the
!        updraft (HEN1) and downdraft (HEN2)
 
         HEN1 = HSP + DHP1 - DHP2 + (ASUB1*WSTAR*XARG/UEFFN)
         HEN2 = HSP + DHP1 - DHP2 + (ASUB2*WSTAR*XARG/UEFFN)
 
!        Compute the plume height for the penetrated source
!        (See Eq. 8 in the reference for Source 3)
         HE3 = HSP + DHP3
 
      ENDIF
 
      CONTINUE
      END
!*==PRMHEFF.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRMHEFF
!***********************************************************************
!             PRMHEFF Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Effective Plume Height (m)
!
!        PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        REVISIONS:  Corrected formulations for HEN1 & HEN2 per
!                    Model Formulation Document and conversation
!                    with Russ Lee and Jeff Weil.
!                    Roger Brode, PES, Inc. - 12/7/94
!
!        INPUTS:  Arrays of Source Parameters
!                 Logical Wake Flags
!                 Meteorological Variables for One Hour
!                 Wind Speed Adjusted to Stack Height
!                 Downwind Distance
!                 Terrain Elevation of Receptor
!
!        OUTPUTS: Effective Plume Height (HE)
!
!        CALLED FROM:   PCALC, VCALC, ACALC, PLUMEF
!
!   References:   "A Dispersion Model for the Convective Boundary
!                  Layer", J. Weil, 8/17/93
!                 "Plume Penetration of the CBL and Source 3: Source
!                  Strength and Plume Rise", J. Weil, 9/1/93
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PRMHEFF'
 
!     Compute the effective plume height
      IF ( STABLE ) THEN
!        The atmosphere is stable or the release is above the CBL
!        mixing ht.
 
         HE = HS + DHP
!        Don't Allow Effective Plume Height to be < 0.0
         HE = AMAX1(0.0,HE)
 
      ELSEIF ( UNSTAB ) THEN
!        The atmosphere is unstable and the release is below the
!        mixing ht.
 
         HE = HS + DHP
!        Don't Allow Effective Plume Height to be < 0.0
         HE = AMAX1(0.0,HE)
      ENDIF
 
      CONTINUE
      END
!*==PDIS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PDIS(XARG)
!***********************************************************************
!             PDIS module of the AMS/EPA Regulatory Model - AERMOD
! ----------------------------------------------------------------------
! ---    ISC-PRIME     Version 1.0    Level 970812              Modified
! ---        D. Strimaitis
! ---        Earth Tech, Inc.
!            Prepared for EPRI under contract WO3527-01
! ----------------------------------------------------------------------
!
!        PURPOSE: Calculates Dispersion Parameters for POINT Sources
!
!        PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!        DATE:    Spetember 30, 1993
!
!        REVISIONS:  SZSURF calculation reinstated 7/13/94, R.F. Lee
!
!        INPUTS:  Arrays of Source Parameters
!                 Logical Wake Flags
!                 Wake Plume Height, HEMWAK
!                 Meteorological Variables for One Hour
!                 Distance, XARG
!
!        OUTPUTS: Lateral and Vertical Dispersion Coefficients, SY and SZ
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PDIS'
 
!     Calculate Sigma-y from formulae                 --- CALL SIGY
      CALL SIGY(XARG)
!     Calculate Sigma-z from formuale                 --- CALL SIGZ
      CALL SIGZ(XARG)
 
!     Set all virtual source terms to 0 for non-downwashing sources
      VSIGY = 0.0
      VSYN = 0.0
      VSIGZ = 0.0
      VSZD1 = 0.0
      VSZD2 = 0.0
      VSZN1 = 0.0
      VSZN2 = 0.0
      VSZ3 = 0.0
      VSY3 = 0.0
 
!     Calculate the buoyancy-induced dispersion parameters
      IF ( NOBID ) THEN
!        Set BID Terms to 0.0
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
            SYB = 0.0
            SZB = 0.0
 
         ELSEIF ( UNSTAB ) THEN
            SYB = 0.0
            SZBD = 0.0
            SZBN = 0.0
            SYB3 = 0.0
            SZB3 = 0.0
 
         ENDIF
 
      ELSE
!        Specify BID Terms                                 --- CALL BID
         CALL BID
 
      ENDIF
 
!---- Calculate the root-mean-square sigma_Y and sigma_Z   --- CALL RMSSIG
      CALL RMSSIG
 
      CONTINUE
      END
!*==VDIS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE VDIS(XARG)
!***********************************************************************
!             VDIS Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Dispersion Parameters for VOLUME Sources
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Arrays of Source Parameters
!                 Meteorological Variables for One Hour
!                 Downwind Distance
!
!        OUTPUTS: Lateral and Vertical Dispersion Coefficients
!
!        CALLED FROM:   VCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'VDIS'
 
!     Calculate Sigma-y from formulae                 --- CALL SIGY
      CALL SIGY(XARG)
!     Calculate Sigma-z from formulae                 --- CALL SIGZ
      CALL SIGZ(XARG)
 
!     Set virtual source terms based on initial sigmas input by user
      VSIGY = SYINIT
      VSYN = SYINIT
      VSIGZ = SZINIT
      VSZD1 = SZINIT
      VSZD2 = SZINIT
      VSZN1 = SZINIT
      VSZN2 = SZINIT
      VSZ3 = 0.0
      VSY3 = 0.0
 
!     Set BID terms to zero
      SYB = 0.0
      SZB = 0.0
      SZBD = 0.0
      SZBN = 0.0
      SYB3 = 0.0
      SZB3 = 0.0
 
!---- Calculate the root-mean-square sigma_Y and sigma_Z   --- CALL RMSSIG
      CALL RMSSIG
 
      CONTINUE
      END
!*==ADISY.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ADISY(XARG)
!***********************************************************************
!                 ADISY Module of the AERMOD Model
!
!        PURPOSE: Calculates Lateral Dispersion Parameters for AREA Sources
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    July 21, 1994
!
!        MODIFIED:   To calculate sigma-y and sigma-z separately
!                    for AREA source - R.Brode, PES, 12/9/98
!
!        INPUTS:  Arrays of Source Parameters
!                 Meteorological Variables for One Hour
!                 Downwind Distance
!
!        OUTPUTS: Lateral and Vertical Dispersion Coefficients
!
!        CALLED FROM:   VCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'ADISY'
 
!     Calculate Sigma-y from formulae                 --- CALL SIGY
      CALL SIGY(XARG)
 
!     Set virtual source terms based on initial sigmas input by user
      VSIGY = 0.0
      VSY3 = 0.0
 
!     Set BID terms to zero
      SYB = 0.0
      SYB3 = 0.0
 
      SY = SYAMB
 
      CONTINUE
      END
!*==ADISZ.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ADISZ(XARG)
!***********************************************************************
!                 ADISZ Module of the AERMOD Model
!
!        PURPOSE: Calculates Vertical Dispersion Parameters for AREA Sources
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    July 21, 1994
!
!        MODIFIED:   To calculate sigma-y and sigma-z separately
!                    for AREA source - R.Brode, PES, 12/9/98
!
!        INPUTS:  Arrays of Source Parameters
!                 Meteorological Variables for One Hour
!                 Downwind Distance
!
!        OUTPUTS: Lateral and Vertical Dispersion Coefficients
!
!        CALLED FROM:   VCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XARG
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'ADISZ'
 
!     Calculate Sigma-z from formulae                 --- CALL SIGZ
      CALL SIGZ(XARG)
 
!     Set virtual source terms based on initial sigmas input by user
      VSIGZ = SZINIT
      VSZD1 = SZINIT
      VSZD2 = SZINIT
      VSZN1 = SZINIT
      VSZN2 = SZINIT
      VSZ3 = 0.0
 
!     Set BID terms to zero
      SZB = 0.0
      SZBD = 0.0
      SZBN = 0.0
      SZB3 = 0.0
 
!---- Calculate the root-mean-square sigma_Y and sigma_Z   --- CALL RMSSIG
      CALL RMSSIG
 
      CONTINUE
      END
!*==AER_PCHI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE AER_PCHI(XARG,ADJ,VDINP,JIN,AEROUT)
!***********************************************************************
!        AER_PCHI Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Hourly Concentration for POINT Sources
!                 Using Gaussian Plume Equation
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    November 10, 2000
!
!        MODIFIED:   To include lateral term (FSUBY) in weighting of
!                    direct and penetrated contributions for wet dep.
!                    Added debug statement for CONC based on ENSR.
!                    - R.Brode, MACTEC, 7/27/2004
!
!        MODIFIED:   To correct WETFLUX values for conversion from
!                    seconds to hours and to include SQRT(2PI) in
!                    denominator of integrated vertical term.
!                    - R.Brode, MACTEC, 3/9/2004
!
!        INPUTS:  Distance, XARG (downwind for plume; radial for pancake)
!                 Crosswind Distance
!                 Plume Height
!                 Stack Top Wind Speed
!                 Lateral Dispersion Parameter
!                 Vertical Dispersion Parameter
!                 Stability Class
!                 Mixing Height
!                 Receptor Height Above Ground
!                 Emission Rate and Units Scaling Factor
!                 Source Parameter Arrays
!
!        OUTPUTS: AEROUT, AERMOD Concentration for Particular
!                 Source/Receptor Combination
!
!        CALLED FROM:   AERCALC, VOLCALC, ACALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      INTEGER :: JIN
      REAL :: AEROUT(NUMTYP) , XARG , ADJ , VDINP , DRYFLUX , WETFLUX
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'AER_PCHI'
 
!---- Calculate the contribution due to horizontal plume, CWRAP
      IF ( FOPT.EQ.0.0 ) THEN
         CWRAP = 0.0
      ELSE
         CALL CPLUME(ZRT,CWRAP)
      ENDIF
 
!---- Calculate the contribution due to terrain-following plume, CLIFT
      IF ( ZRT.EQ.ZFLAG ) THEN
!----    Effective receptor heights are equal, therefore CLIFT = CWRAP
         CLIFT = CWRAP
      ELSEIF ( FOPT.EQ.1.0 ) THEN
         CLIFT = 0.0
      ELSE
         CALL CPLUME(ZFLAG,CLIFT)
      ENDIF
 
!---- Calculate the exponential decay term, D               ---   CALL DECAY
      CALL DECAY(XARG)
 
!---- Calculate the hourly concentration and deposition values
      ITYP = 0
      IF ( CONC ) THEN
         ITYP = 1
         AEROUT(ITYP) = ADJ*EMIFAC(ITYP)*(FOPT*CWRAP+(1.0-FOPT)*CLIFT)*D
 
!   ENHANCEMENT TO DEBUG OUTPUT BASED ON ENSR
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,10) ITYP , ADJ , FOPT , CWRAP , CLIFT , D ,   &
     &                        AEROUT(ITYP)
 10         FORMAT (/,'ITYP = ',I2,' - CONC:',/,                        &
     &              'AEROUT(ITYP) = ADJ * EMIFAC(ITYP) * (FOPT * ',     &
     &              'CWRAP + (1.0 -FOPT) * CLIFT) * D',/,' ADJ   = ',   &
     &              G16.8,/,' FOPT  = ',G16.8,/,' CWRAP = ',G16.8,/,    &
     &              ' CLIFT = ',G16.8,/,' D     = ',G16.8,/,            &
     &              ' AEROUT(ITYP) = ',G16.8,/)
         ENDIF
 
      ENDIF
 
      IF ( DEPOS .OR. DDEP ) THEN
!        Calculate DRYFLUX, vertical term for wet deposition
!----    Calculate the contribution due to horizontal plume, CWRAP
         IF ( FOPT.EQ.0.0 ) THEN
            CWRAP = 0.0
         ELSE
            CALL CPLUME(ZRT-ZFLAG+ZRDEP,CWRAP)
         ENDIF
 
!----    Calculate the contribution due to terrain-following plume, CLIFT
         IF ( ZRT.EQ.ZFLAG ) THEN
!----       Effective receptor heights are equal, therefore CLIFT = CWRAP
            CLIFT = CWRAP
         ELSEIF ( FOPT.EQ.1.0 ) THEN
            CLIFT = 0.0
         ELSE
            CALL CPLUME(ZRDEP,CLIFT)
         ENDIF
 
         DRYFLUX = (FOPT*CWRAP+(1.0-FOPT)*CLIFT)*D
      ENDIF
      IF ( DEPOS .OR. WDEP ) THEN
!        Calculate WETFLUX, vertical term for wet deposition.
!        Note that the SRT2PI for the integrated vertical term
!        has been removed since it should be divided by SRT2PI.
!        Additional factor of 3600. has been added to denominator
!        to account for conversion from seconds to hours when
!        divided by wind speed below.
         IF ( PRATE.GT.0. ) THEN
            IF ( NPD.EQ.0 ) THEN
               WETFLUX = (ADJ*FRACSAT*PRATE*1.0E6*RGAS*TA)              &
     &                   /(ZSUBP*HENRY(ISRC)*1.0E9*DENOM*3600.)
            ELSE
               WETFLUX = 1.0E-3*ADJ*WASHOUT(JIN)*PRATE/(ZSUBP*3600.)
            ENDIF
         ELSE
            WETFLUX = 0.0
         ENDIF
      ENDIF
 
      IF ( DEPOS ) THEN
         ITYP = ITYP + 1
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
            AEROUT(ITYP) = ADJ*VDINP*EMIFAC(ITYP)*DRYFLUX +             &
     &                     QTK*WETFLUX*EMIFAC(ITYP)*FSUBY/UEFF
         ELSEIF ( UNSTAB ) THEN
            AEROUT(ITYP) = ADJ*VDINP*EMIFAC(ITYP)*DRYFLUX +             &
     &                     QTK*WETFLUX*EMIFAC(ITYP)                     &
     &                     *(PPF*FSUBY3/UEFF3+(1.-PPF)*FSUBY/UEFFD)
         ENDIF
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,11) ITYP , ADJ , VDINP , DRYFLUX , WETFLUX ,  &
     &                        AEROUT(ITYP)
 11         FORMAT (/,'ITYP = ',I2,' - DEPOS:',/,' ADJ     = ',G16.8,/, &
     &              ' VPDINP  = ',G16.8,/,' DRYFLUX = ',G16.8,/,        &
     &              ' WETFLUX = ',G16.8,/,' AEROUT(ITYP) = ',G16.8,/)
         ENDIF
 
      ENDIF
 
      IF ( DDEP ) THEN
         ITYP = ITYP + 1
         AEROUT(ITYP) = ADJ*VDINP*EMIFAC(ITYP)*DRYFLUX
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,12) ITYP , ADJ , VDINP , DRYFLUX ,            &
     &                        AEROUT(ITYP)
 12         FORMAT (/,'ITYP = ',I2,' - DDEP:',/,' ADJ     = ',G16.8,/,  &
     &              ' VPDINP  = ',G16.8,/,' DRYFLUX = ',G16.8,/,        &
     &              ' AEROUT(ITYP) = ',G16.8,/)
         ENDIF
 
      ENDIF
 
      IF ( WDEP ) THEN
         ITYP = ITYP + 1
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
            AEROUT(ITYP) = QTK*WETFLUX*EMIFAC(ITYP)*FSUBY/UEFF
         ELSEIF ( UNSTAB ) THEN
            AEROUT(ITYP) = QTK*WETFLUX*EMIFAC(ITYP)                     &
     &                     *(PPF*FSUBY3/UEFF3+(1.-PPF)*FSUBY/UEFFD)
         ENDIF
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,13) ITYP , ADJ , ZSUBP , PRATE , WETFLUX ,    &
     &                        AEROUT(ITYP)
 13         FORMAT (/,'ITYP = ',I2,' - WDEP:',/,' ADJ     = ',G16.8,/,  &
     &              ' ZSUBP   = ',G16.8,/,' PRATE   = ',G16.8,/,        &
     &              ' WETFLUX = ',G16.8,/,' AEROUT(ITYP) = ',G16.8,/)
         ENDIF
 
      ENDIF
 
 
!CRFL Call to METDEB was moved here from METEXT on 9/26/94, R.F. Lee.
!CRFL Print meteorological debug output.                   ---   CALL METDEB
      IF ( METEOR ) CALL METDEB
 
!        Print Out Debugging Information                    ---   CALL DEBOUT
      IF ( DEBUG ) CALL DEBOUT
 
      CONTINUE
      END
!*==PRM_PCHI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRM_PCHI(ADJ,VDINP,JIN)
!***********************************************************************
!        PRM_PCHI Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Hourly Concentration for POINT Sources
!                 with PRIME Downwash Algorithm
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:     November 10, 2000
!
!        MODIFIED:   To correct WETFLUX values for conversion from
!                    seconds to hours and to include SQRT(2PI) in
!                    denominator of integrated vertical term.
!                    - R.Brode, MACTEC, 3/9/2004
!
!        INPUTS:  Downwind Distance
!                 Crosswind Distance
!                 Plume Height
!                 Stack Top Wind Speed
!                 Lateral Dispersion Parameter
!                 Vertical Dispersion Parameter
!                 Stability Class
!                 Mixing Height
!                 Receptor Height Above Ground
!                 Emission Rate and Units Scaling Factor
!                 Source Parameter Arrays
!
!        OUTPUTS: PRMVAL, PRIME Concentration for Particular
!                 Source/Receptor Combination, summed across
!                 three PRIME "sources", i.e., primary source,
!                 inside cavity source and outside cavity source
!
!        CALLED FROM:   PRMCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      INTEGER :: JIN
      REAL :: ADJ , VDINP , DRYFLUX , WETFLUX
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PRM_PCHI'
 
!---- Calculate the exponential decay term, D               ---   CALL DECAY
      CALL DECAY(X)
 
!---- Calculate the hourly concentration value
      ITYP = 0
      IF ( CONC ) THEN
         ITYP = 1
!----    Calculate the contribution due to horizontal plume, CWRAP
         IF ( FOPT.EQ.0.0 ) THEN
            CWRAP = 0.0
         ELSE
            CALL PRM_PLUME(ZRT,CWRAP)
         ENDIF
 
!----    Calculate the contribution due to terrain-following plume, CLIFT
         IF ( ZRT.EQ.ZFLAG ) THEN
!----       Effective receptor heights are equal, therefore CLIFT = CWRAP
            CLIFT = CWRAP
         ELSEIF ( FOPT.EQ.1.0 ) THEN
            CLIFT = 0.0
         ELSE
            CALL PRM_PLUME(ZFLAG,CLIFT)
         ENDIF
 
         PRMVAL(ITYP) = PRMVAL(ITYP) + ADJ*EMIFAC(ITYP)                 &
     &                  *(FOPT*CWRAP+(1.0-FOPT)*CLIFT)*D
      ENDIF
 
      IF ( DEPOS .OR. DDEP ) THEN
!        Calculate DRYFLUX, vertical term for wet deposition
!----    Calculate the contribution due to horizontal plume, CWRAP
         IF ( FOPT.EQ.0.0 ) THEN
            CWRAP = 0.0
         ELSE
            CALL PRM_PLUME(ZRT-ZFLAG+ZRDEP,CWRAP)
         ENDIF
 
!----    Calculate the contribution due to terrain-following plume, CLIFT
         IF ( ZRT.EQ.ZFLAG ) THEN
!----       Effective receptor heights are equal, therefore CLIFT = CWRAP
            CLIFT = CWRAP
         ELSEIF ( FOPT.EQ.1.0 ) THEN
            CLIFT = 0.0
         ELSE
            CALL PRM_PLUME(ZRDEP,CLIFT)
         ENDIF
 
         DRYFLUX = (FOPT*CWRAP+(1.0-FOPT)*CLIFT)*D
      ENDIF
      IF ( DEPOS .OR. WDEP ) THEN
!        Calculate WETFLUX, vertical term for wet deposition
!        Note that the SRT2PI for the integrated vertical term
!        has been removed since it should be divided by SRT2PI.
!        Additional factor of 3600. has been added to denominator
!        to account for conversion from seconds to hours when
!        divided by wind speed below.
         IF ( PRATE.GT.0. ) THEN
            IF ( NPD.EQ.0 ) THEN
               WETFLUX = (ADJ*FRACSAT*PRATE*1.0E6*RGAS*TA)              &
     &                   /(ZSUBP*HENRY(ISRC)*1.0E9*DENOM*3600.)
            ELSE
               WETFLUX = 1.0E-3*ADJ*WASHOUT(JIN)*PRATE/(ZSUBP*3600.)
            ENDIF
         ELSE
            WETFLUX = 0.0
         ENDIF
      ENDIF
 
      IF ( DEPOS ) THEN
         ITYP = ITYP + 1
         PRMVAL(ITYP) = PRMVAL(ITYP) + ADJ*VDINP*EMIFAC(ITYP)*DRYFLUX + &
     &                  QTK*WETFLUX*EMIFAC(ITYP)*FSUBY/UEFF
      ENDIF
 
      IF ( DDEP ) THEN
         ITYP = ITYP + 1
         PRMVAL(ITYP) = PRMVAL(ITYP) + ADJ*VDINP*EMIFAC(ITYP)*DRYFLUX
      ENDIF
 
      IF ( WDEP ) THEN
         ITYP = ITYP + 1
         PRMVAL(ITYP) = PRMVAL(ITYP) + QTK*WETFLUX*EMIFAC(ITYP)         &
     &                  *FSUBY/UEFF
      ENDIF
 
!        Print Out Debugging Information                    ---   CALL DEBOUT
      IF ( DEBUG ) CALL DEBOUT
 
      CONTINUE
      END
!*==AER_ACHI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE AER_ACHI(XARG,ADJ,VDINP,JIN,FYARG,POUT)
!***********************************************************************
!        AER_ACHI Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Hourly Concentration for POINT Sources
!                 Using Gaussian Plume Equation
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    November 10, 2000
!
!        MODIFIED:   To correct WETFLUX values for conversion from
!                    seconds to hours and to include SQRT(2PI) in
!                    denominator of integrated vertical term.
!                    - R.Brode, MACTEC, 3/9/2004
!
!        INPUTS:  Distance, XARG (downwind for plume; radial for pancake)
!                 Crosswind Distance
!                 Plume Height
!                 Stack Top Wind Speed
!                 Lateral Dispersion Parameter
!                 Vertical Dispersion Parameter
!                 Stability Class
!                 Mixing Height
!                 Receptor Height Above Ground
!                 Emission Rate and Units Scaling Factor
!                 Source Parameter Arrays
!
!        OUTPUTS: AEROUT, AERMOD Concentration for Particular
!                 Source/Receptor Combination
!
!        CALLED FROM:   AERCALC, VOLCALC, ACALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      INTEGER :: JIN
      REAL :: POUT , XARG , ADJ , VDINP , FYARG , DRYFLUX , WETFLUX
      LOGICAL :: SCONC , SDEPOS , SDDEP , SWDEP
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'AER_ACHI'
 
!     Determine appropriate output type for this ITYP, assign output type
!     logicals to local variables, and set others to .FALSE.
      IF ( OUTTYP(ITYP).EQ.'CONC' ) THEN
         SCONC = .TRUE.
         SDEPOS = .FALSE.
         SDDEP = .FALSE.
         SWDEP = .FALSE.
      ELSEIF ( OUTTYP(ITYP).EQ.'DEPOS' ) THEN
         SCONC = .FALSE.
         SDEPOS = .TRUE.
         SDDEP = .FALSE.
         SWDEP = .FALSE.
      ELSEIF ( OUTTYP(ITYP).EQ.'DDEP' ) THEN
         SCONC = .FALSE.
         SDEPOS = .FALSE.
         SDDEP = .TRUE.
         SWDEP = .FALSE.
      ELSEIF ( OUTTYP(ITYP).EQ.'WDEP' ) THEN
         SCONC = .FALSE.
         SDEPOS = .FALSE.
         SDDEP = .FALSE.
         SWDEP = .TRUE.
      ENDIF
 
      POUT = 0.0
 
!---- Calculate the exponential decay term, D               ---   CALL DECAY
      CALL DECAY(XARG)
 
      IF ( SCONC ) THEN
!----    Get Concentration or Deposition due to horizontal plume, CWRAP
         IF ( FOPT.EQ.0.0 ) THEN
            CWRAP = 0.0
         ELSE
            CALL ACPLUME(ZRT,FYARG,CWRAP)
         ENDIF
 
!----    Calculate the contribution due to terrain-following plume, CLIFT
         IF ( ZRT.EQ.ZFLAG ) THEN
!----       Effective receptor heights are equal, therefore CLIFT = CWRAP
            CLIFT = CWRAP
         ELSEIF ( FOPT.EQ.1.0 ) THEN
            CLIFT = 0.0
         ELSE
!           Get Concentration or Deposition due to LIFT algorithm
            CALL ACPLUME(ZFLAG,FYARG,CLIFT)
         ENDIF
 
!----    Calculate the hourly concentration value
!        Now compute the function
         POUT = ADJ*(FOPT*CWRAP+(1.0-FOPT)*CLIFT)*D
 
      ENDIF
      IF ( SDEPOS .OR. SDDEP ) THEN
!----    Get Concentration or Deposition due to horizontal plume, CWRAP
         IF ( FOPT.EQ.0.0 ) THEN
            CWRAP = 0.0
         ELSE
            CALL ACPLUME(ZRT-ZFLAG+ZRDEP,FYARG,CWRAP)
         ENDIF
 
!----    Calculate the contribution due to terrain-following plume, CLIFT
         IF ( ZRT.EQ.ZFLAG ) THEN
!----       Effective receptor heights are equal, therefore CLIFT = CWRAP
            CLIFT = CWRAP
         ELSEIF ( FOPT.EQ.1.0 ) THEN
            CLIFT = 0.0
         ELSE
!           Get Concentration or Deposition due to LIFT algorithm
            CALL ACPLUME(ZRDEP,FYARG,CLIFT)
         ENDIF
 
!----    Calculate the hourly concentration value
!        Now compute the function
         DRYFLUX = ADJ*(FOPT*CWRAP+(1.0-FOPT)*CLIFT)*D
 
      ENDIF
      IF ( SDEPOS .OR. SWDEP ) THEN
!        Calculate WETFLUX, vertical term for wet deposition
!        Note that the SRT2PI for the integrated vertical term
!        has been removed since it should be divided by SRT2PI.
!        Additional factor of 3600. has been added to denominator
!        to account for conversion from seconds to hours when
!        divided by wind speed below.
         IF ( PRATE.GT.0. ) THEN
            IF ( NPD.EQ.0 ) THEN
               WETFLUX = (ADJ*FRACSAT*PRATE*1.0E6*RGAS*TA)              &
     &                   /(ZSUBP*HENRY(ISRC)*1.0E9*DENOM*3600.)
            ELSE
               WETFLUX = 1.0E-3*ADJ*WASHOUT(JIN)*PRATE/(ZSUBP*3600.)
            ENDIF
         ELSE
            WETFLUX = 0.0
         ENDIF
      ENDIF
      IF ( SDEPOS ) THEN
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
            POUT = VDINP*DRYFLUX + WETFLUX*FYARG/UEFF
         ELSEIF ( UNSTAB ) THEN
            POUT = VDINP*DRYFLUX + WETFLUX*FYARG/UEFFD
         ENDIF
      ENDIF
      IF ( SDDEP ) POUT = VDINP*DRYFLUX
      IF ( SWDEP ) THEN
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
            POUT = WETFLUX*FYARG/UEFF
         ELSEIF ( UNSTAB ) THEN
            POUT = WETFLUX*FYARG/UEFFD
         ENDIF
      ENDIF
 
 
!CRFL Call to METDEB was moved here from METEXT on 9/26/94, R.F. Lee.
!CRFL Print meteorological debug output.                   ---   CALL METDEB
      IF ( METEOR ) CALL METDEB
 
!        Print Out Debugging Information                    ---   CALL DEBOUT
      IF ( DEBUG ) CALL DEBOUT
 
      CONTINUE
      END
!*==DEBOUT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE DEBOUT
!***********************************************************************
!             DEBOUT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Outputs Debugging Information: Sigmas, Plume Heights,
!                 etc., for Each Calculation
!
!        PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!        DATE:    October 8, 1993
!
!        REVISIONS:  Revised emission rate terms:  for CHID & CHIN,
!                    to QTK*(1-PPF), and for CHI3 to QTK*PPF.
!                    Ref:  P.D.F. Model for Dispersion in the
!                    Convective Boundary Layer, J.C. Weil, 6/27/94.
!                    Changed 7/19/94, R.F. Lee.
!
!                    Revised by Bob Paine to improve readability
!                    of debugging output.  Changed 8/18/94, R.F. Lee
!                    & R. Paine.
!
!
!        INPUTS:  Downwind Distance
!                 Crosswind Distance
!                 Plume Height
!                 Stack Top Wind Speed
!                 Lateral Dispersion Parameter
!                 Vertical Dispersion Parameter
!                 Stability Class
!                 Mixing Height
!                 Receptor Height Above Ground
!                 Emission Rate and Units Scaling Factor
!                 Source Parameter Arrays
!
!        OUTPUTS: Debug Outputs
!
!        CALLED FROM:   PCHI, PDEP, AREAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: CHID , CHIN , CHI3
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'DEBOUT'
 
!     Calculate contributions from each "plume"
      IF ( STABLE .OR. (UNSTAB .AND. HS.GE.ZI) ) THEN
         CHID = HRVAL(1)
      ELSEIF ( UNSTAB ) THEN
!CRFL
!CRFL    Revised emission rate terms:  for CHID & CHIN, to QTK*(1-PPF),
!CRFL    and for CHI3 to QTK*PPF.  Ref:  P.D.F. Model for Dispersion in
!CRFL    the Convective Boundary Layer, J.C. Weil, 6/27/94.  Changed
!CRFL    7/19/94, R.F. Lee.
!CRFL
         CHID = (QTK*EMIFAC(1)*(1.-PPF)/UEFFD)*(FSUBYD*FSUBZD)
         CHIN = (QTK*EMIFAC(1)*(1.-PPF)/UEFFN)*(FSUBYN*FSUBZN)
         IF ( PPF.GT.0.0 .AND. UEFF3.GT.0.0 ) THEN
            CHI3 = (QTK*EMIFAC(1)*PPF/UEFF3)*(FSUBY3*FSUBZ3)
         ELSE
            CHI3 = 0.0
         ENDIF
      ENDIF
 
!     Write a blank line to separate the groupings
      WRITE (DBGUNT,101)
!
!     FORMAT STATEMENTS
!
 101  FORMAT (1X)
 
!     Write the debug output for the receptor data
      WRITE (DBGUNT,320) IREC , XR , YR , ZELEV , ZHILL , ZFLAG , X ,   &
     &                   Y , ZELEV - ZS , HCRIT , PHEE , FOPT , D ,     &
     &                   CWRAP*EMIFAC(1) , CLIFT*EMIFAC(1) , AERVAL(1) ,&
     &                   PRMVAL(1)
 320  FORMAT ('  REC  REC-X    REC-Y   REC-Z    HILLHT  FLAGPL    ',    &
     &       'DEL-X   DEL-Y  DEL-Z   HCRIT   PHEE  FOPT  DECAY   CWRAP '&
     &       ,'     CLIFT      AERVAL    PRMVAL',/,                     &
     &      '    #   (M)      (M)     (M)      (M)     (M)       (M)   '&
     &      ,'  (M)    (M)     (M)                       (UG/M3)    ',  &
     &      '(UG/M3)    (UG/M3)',//,I5,F8.0,F9.0,F8.1,F9.1,F8.1,F10.0,  &
     &      F8.0,F7.1,F7.1,F7.3,F6.3,F7.3,4E11.4,/)
!
!     Write header for plume sigma information
!
      WRITE (DBGUNT,330)
 330  FORMAT ('   PLUME   PART.  SOURCE  PLUME  <----- SIGMA-Y TERMS --'&
     &        ,                                                         &
     &   '--->   GAUSS.     <--------- SIGMA-Z TERMS -------->   GAUSS.'&
     &   ,/,' COMPONENT PEN.     Q     HEIGHT  AMB.  DOWNW.  BUOY.  TO',&
     &   'TAL   HORIZ.      AMB.  DOWNW.  BUOY.  SURF.  TOTAL   VERT.  '&
     &   ,'       CHI ',/,                                              &
     &   '   TYPE    FRAC.   (G/S)   (M)    (M)    (M)     (M)    ',    &
     &   '(M)    TERM        (M)    (M)     (M)    (M)    (M)    TERM ',&
     &   '       (UG/M3)',/)
!
!     Write the data that was used in the plume computations,
!      which is stability-dependent.
!
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
         WRITE (DBGUNT,400) PPF , QTK , HE , SYAMB , VSIGY , SYB , SY , &
     &                      FSUBY , SZAMB , VSIGZ , SZB , SZSURF , SZ , &
     &                      FSUBZ , CHID
 400     FORMAT (' GAUSSIAN ',F6.3,F9.2,F7.1,4F7.1,E11.4,2X,5F7.1,E11.4,&
     &           E12.4)
 
      ELSEIF ( UNSTAB ) THEN
         IF ( (1.0-PPF)*QTK.GT.0.0 ) THEN
            WRITE (DBGUNT,410) PPF , (1.0-PPF)*QTK , HED1 , SYAMB ,     &
     &                         VSIGY , SYB , SY , SZAD1 , VSZD1 , SZBD ,&
     &                         SZSURF , SZD1
 410        FORMAT (' DIRECT #1',F6.3,F9.2,F7.1,4F7.1,13X,5F7.1)
            WRITE (DBGUNT,420) (1.0-PPF)*QTK , HED2 , SYAMB , VSIGY ,   &
     &                         SYB , SY , FSUBYD , SZAD2 , VSZD2 ,      &
     &                         SZBD , SZSURF , SZD2 , FSUBZD , CHID
 420        FORMAT (' DIRECT #2',6X,F9.2,F7.1,4F7.1,E11.4,2X,5F7.1,     &
     &              E11.4,E12.4)
!CRFL
!CRFL  SZSURF has been added to the indirect plume sigma z calculations--
!CRFL  add it also to the debug output for the indirect plume.
!CRFL  Changed 9/12/94.  R.F. Lee.  (Format statements 430 and 440 were
!CRFL  changed also.)
            WRITE (DBGUNT,430) PPF , (1.0-PPF)*QTK , HEN1 , SYAMB ,     &
     &                         VSIGY , SYB , SY , SZAN1 , VSZN1 , SZBN ,&
     &                         SZSURF , SZN1
 430        FORMAT (' INDIRECT1',F6.3,F9.2,F7.1,4F7.1,13X,4F7.1,F7.1)
            WRITE (DBGUNT,440) (1.0-PPF)*QTK , HEN2 , SYAMB , VSIGY ,   &
     &                         SYB , SY , FSUBYN , SZAN2 , VSZN2 ,      &
     &                         SZBN , SZSURF , SZN2 , FSUBZN , CHIN
 440        FORMAT (' INDIRECT2',6X,F9.2,F7.1,4F7.1,E11.4,2X,5F7.1,     &
     &              E11.4,E12.4)
         ENDIF
         IF ( (PPF*QTK).GT.0.0 ) THEN
            WRITE (DBGUNT,450) PPF , (PPF*QTK) , HE3 , SYA3 , VSY3 ,    &
     &                         SYB3 , SY3 , FSUBY3 , SZA3 , VSZ3 ,      &
     &                         SZB3 , SZ3 , FSUBZ3 , CHI3
 450        FORMAT (' PENETRATE',F6.3,F9.2,F7.1,4F7.1,E11.4,2X,3F7.1,7X,&
     &              F7.1,E11.4,E12.4,/)
         ENDIF
      ENDIF
!
      CONTINUE
      END
!*==PENFCT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PENFCT
!***********************************************************************
!             PENFCT Module of the AMS/EPA Regulatory Model - AERMOD
!
!   PURPOSE: Calculate the plume penetration factor
!
!   PROGRAMMER: Roger Brode and Jim Paumier, PES, Inc.
!
!   DATE:    September 30, 1993
!
!   REVISED: To use VPTGZI = 0.01 for Base Case model. R.Brode, PES - 12/7/94
!
!   INPUTS:  Stability, STABLE/UNSTAB
!            Buoyancy flux, FB
!            Wind speed at release height, UP (computed in METINI)
!            Potential temperature at ZI
!            Potential temperature gradient above ZI, VPTGZI (from
!            AERMET)
!
!   OUTPUTS: Plume penetration factor, PPF
!
!   CALLED FROM:   PCALC
!
!   Assumptions:
!
!   References:   "Plume Penetration of the CBL and Source 3: Source
!                 Strength and Plume Rise", J. Weil, 9/1/93
!                 "A Dispersion Model for the Convective Boundary Layer",
!                 J. Weil, 8/17/93
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL BVZI2
 
      MODNAM = 'PENFCT'
 
      IF ( STABLE ) THEN
         PPF = 0.0
 
      ELSEIF ( UNSTAB .AND. (HS.GE.ZI) ) THEN
         PPF = 1.0
 
      ELSE
!        Compute the square of the Brunt-Vaisala frequency at ZI, BVZI2
 
         BVZI2 = G/PTATZI*VPTGZI
 
!        Compute the value of PsubS, Eq. 26b in the 2nd reference
         PSUBS = FB/(UP*BVZI2*(ZI-HSP)*(ZI-HSP)*(ZI-HSP))
 
!        Compute the ratio of delta(Hsub_e)/delta(Hsub_h), HEDHH
!        (Eq. 25 in the 2nd ref.
!        NOTE: 17.576 = (2.6)**3 and 0.296296 is (2/3)**3
         HEDHH = (17.576*PSUBS+0.296296)**0.333333
 
!        Check the value of HEDHH and compute the plume penetration, P
         IF ( HEDHH.LT.0.666667 ) THEN
            PPF = 0.0
 
         ELSEIF ( HEDHH.GT.2.0 ) THEN
            PPF = 1.0
 
         ELSE
            PPF = 1.5 - (1.0/HEDHH)
 
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==CPLUME.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CPLUME(ZARG,COUT)
!***********************************************************************
!             CPLUME Module of the AMS/EPA Regulatory Model - AERMOD
!
!   PURPOSE: Calculate the contribution to the concentration due to
!            plume component, either horizontal or terrain-following,
!            depending on the input receptor height, ZARG
!
!   PROGRAMMER: Roger Brode, PES, Inc.
!
!   DATE:    September 30, 1993
!
!   REVISIONS:
!               Make stable plume reflections dependent on the
!               developmental option switch, OPTG1 & OPTG2,
!               R. Brode, PES, 1/6/95
!
!               Remove stable plume reflections off of ZI for
!               Base Case model.  R. Brode, PES - 12/7/94
!
!               Revised emission rates for each plume to QTK*(1.-PPF)
!               for the direct and indirect plumes, and to QTK*PPF
!               for the penetrated plume.  Ref:  P.D.F. Model for
!               Dispersion in the Convective Boundary Layer,
!               J.C. Weil, 6/27/94. Changes made 7/19/94, R.F. Lee.
!
!               Added true centerline concentration calculations.
!               Changes made 7/25/94, R.F. Lee.
!
!   INPUTS:  Stability, STABLE/UNSTAB
!            Fraction of plume vertical flux remaining in the CBL, FOPT
!            Mixing height, ZI
!            Plume heights, HE/HED1/HED2/HEN1/HEN2
!            sigma_Z's: SZ, SZD1, SZD2, SZN1, SZN2, SZ3
!            Receptor height, ZARG
!
!   OUTPUTS: Contribution due to WRAP, CWRAP
!
!   CALLED FROM:   PCHI
!
!   Assumptions:  For receptor height (ZR) above the mixing height (ZI)
!                 for unstable conditions, the direct and indirect plume
!                 impacts are set to zero.
!
!   References:   "A Dispersion Model for the Convective Boundary
!                 Layer", J. Weil, 8/17/93
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: ZARG , COUT
 
      SAVE 
 
      MODNAM = 'CPLUME'
 
!     Assign receptor height for vertical term calculations
      ZR = ZARG
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!        Calculate the vertical term, FSUBZ              ---   CALL VRTSBL
!        With stable plume reflections and effective Zi
         IF ( ZR.LE.HSBL ) THEN
            CALL VRTSBL(SZ,MAX(0.0,HE-HV),HSBL)
         ELSE
            CALL VRTSBN(SZ,MAX(0.0,HE-HV),HSBL)
         ENDIF
 
!        Calculate the concentration for a stable atmosphere
         COUT = (QTK/UEFF)*(FSUBY*FSUBZ)
 
      ELSEIF ( UNSTAB ) THEN
         IF ( PPF.LT.1.0 ) THEN
!           Calculate the vertical term for the direct plume, FSUBZD
            IF ( ZR.LE.ZI ) THEN
!              Calculation for Receptor below Zi      ---   CALL VRTCBL
               CALL VRTCBL(HED1-HV,HED2-HV,SZD1,SZD2,1.0)
               FSUBZD = FSUBZ
            ELSE
!              Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
               FSUBZD = 0.0
            ENDIF
 
!           Calculate the vertical term for the indirect plume, FSUBZN
            IF ( ZR.LE.ZI ) THEN
!              Calculation for Receptor below Zi      ---   CALL VRTCBL
               CALL VRTCBL(HEN1-HV,HEN2-HV,SZN1,SZN2,-1.0)
               FSUBZN = FSUBZ
            ELSE
!              Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
               FSUBZN = 0.0
            ENDIF
         ELSE
            FSUBZD = 0.0
            FSUBZN = 0.0
 
         ENDIF
 
!        Note that UEFF and UEFF3 can never be zero, since they get
!        set to a minimum value earlier on.
 
         IF ( PPF.GT.0.0 ) THEN
!           Calculate the vertical term for the penetrated
!           plume, FSUBZ3                                ---   CALL VRTSBL
            IF ( ZR.LE.HPEN ) THEN
               CALL VRTSBL(SZ3,MAX(0.0,HE3-HV),HPEN)
            ELSE
               CALL VRTSBN(SZ3,MAX(0.0,HE3-HV),HPEN)
            ENDIF
            FSUBZ3 = FSUBZ
 
            IF ( PPF.LT.1.0 ) THEN
               COUT = (QTK*(1.-PPF)/UEFFD)*(FSUBYD*FSUBZD)              &
     &                + (QTK*(1.-PPF)/UEFFN)*(FSUBYN*FSUBZN)            &
     &                + (QTK*PPF/UEFF3)*(FSUBY3*FSUBZ3)
 
            ELSE
               COUT = (QTK*PPF/UEFF3)*(FSUBY3*FSUBZ3)
 
            ENDIF
 
         ELSE
            FSUBZ3 = 0.0
            HPEN = 0.0
            COUT = (QTK/UEFFD)*(FSUBYD*FSUBZD) + (QTK/UEFFN)            &
     &             *(FSUBYN*FSUBZN)
 
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==PRM_PLUME.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRM_PLUME(ZARG,COUT)
!***********************************************************************
!             PRM_PLUME Module of the AMS/EPA Regulatory Model - AERMOD
!
!   PURPOSE: Calculate the contribution to the concentration due to
!            PRIME downwash component
!
!   PROGRAMMER: Roger Brode, PES, Inc.
!
!   DATE:    July 5, 2001
!
!   INPUTS:  Receptor height, ZARG
!
!   OUTPUTS: Contribution due to PRIME, COUT
!
!   CALLED FROM:   PRM_PCHI
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: ZARG , FYPL , COUT , EXPARG
 
      SAVE 
 
      MODNAM = 'PRM_PLUME'
 
!     Assign receptor height for vertical term calculations
      ZR = ZARG
 
      IF ( STABLE ) THEN
         CALL VRTSBN(SZ,HE,HSBL)
      ELSEIF ( UNSTAB .AND. HE.LE.ZI ) THEN
         CALL VRTSBL(SZ,HE,ZI)
      ELSE
         FSUBZ = 0.0
      ENDIF
 
!     Calculate the WRAP term for a stable atmosphere
      COUT = (QTK/US)*(FSUBY*FSUBZ)
 
      CONTINUE
      END
!*==ACPLUME.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ACPLUME(ZARG,FYARG,COUT)
!***********************************************************************
!             ACPLUME Module of the AMS/EPA Regulatory Model - AERMOD
!
!   PURPOSE: Calculate the contribution to the concentration due to
!            plume component, either horizontal or terrain-following,
!            for AREA sources
!
!   PROGRAMMER: Roger Brode, PES, Inc.
!
!   DATE:    September 30, 1993
!
!   REVISIONS:
!               Make stable plume reflections dependent on the
!               developmental option switch, OPTG1 & OPTG2,
!               R. Brode, PES, 1/6/95
!
!               Remove stable plume reflections off of ZI for
!               Base Case model.  R. Brode, PES - 12/7/94
!
!               Revised emission rates for each plume to QTK*(1.-PPF)
!               for the direct and indirect plumes, and to QTK*PPF
!               for the penetrated plume.  Ref:  P.D.F. Model for
!               Dispersion in the Convective Boundary Layer,
!               J.C. Weil, 6/27/94. Changes made 7/19/94, R.F. Lee.
!
!               Added true centerline concentration calculations.
!               Changes made 7/25/94, R.F. Lee.
!
!   INPUTS:  Stability, STABLE/UNSTAB
!            Fraction of plume vertical flux remaining in the CBL, FOPT
!            Mixing height, ZI
!            Plume heights, HE/HED1/HED2/HEN1/HEN2
!            sigma_Z's: SZ, SZD1, SZD2, SZN1, SZN2, SZ3
!
!   OUTPUTS: Contribution due to WRAP, CWRAP
!
!   CALLED FROM:   ACHI
!
!   Assumptions:  For receptor height (ZR) above the mixing height (ZI)
!                 for unstable conditions, the direct and indirect plume
!                 impacts are set to zero.
!
!   References:   "A Dispersion Model for the Convective Boundary
!                 Layer", J. Weil, 8/17/93
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: ZARG , FYARG , COUT
 
      SAVE 
 
      MODNAM = 'ACPLUME'
 
!     Assign receptor height for vertical term calculations
      ZR = ZARG
 
!     Assign lateral term
      FSUBY = FYARG
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!        Calculate the vertical term, FSUBZ              ---   CALL VRTSBL
!        With stable plume reflections
         IF ( ZR.LE.HSBL ) THEN
            CALL VRTSBL(SZ,MAX(0.0,HE-HV),HSBL)
         ELSE
            CALL VRTSBN(SZ,MAX(0.0,HE-HV),HSBL)
         ENDIF
 
!        Calculate the WRAP term for a stable atmosphere
         COUT = (1.0/UEFF)*(FSUBY*FSUBZ)
 
      ELSEIF ( UNSTAB ) THEN
!        Calculate the vertical term for the direct plume, FSUBZD
         IF ( ZR.LE.ZI ) THEN
!           Calculation for Receptor below Zi         ---   CALL VRTCBL
            CALL VRTCBL(HED1-HV,HED2-HV,SZD1,SZD2,1.0)
            FSUBZD = FSUBZ
         ELSE
!           Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
            FSUBZD = 0.0
         ENDIF
 
!        Calculate the vertical term for the indirect plume, FSUBZN
         IF ( ZR.LE.ZI ) THEN
!           Calculation for Receptor below Zi         ---   CALL VRTCBL
            CALL VRTCBL(HEN1-HV,HEN2-HV,SZN1,SZN2,-1.0)
            FSUBZN = FSUBZ
         ELSE
!           Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
            FSUBZN = 0.0
         ENDIF
 
!        Note that UEFF and UEFF3 can never be zero, since they get
!        set to a minimum value earlier on.
 
         FSUBZ3 = 0.0
         HPEN = 0.0
         COUT = (1.0/UEFFD)*(FSUBY*FSUBZD) + (1.0/UEFFN)*(FSUBY*FSUBZN)
 
      ENDIF
 
      CONTINUE
      END
!*==GCUBIC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
!-----------------------------------------------------------------------
      SUBROUTINE GCUBIC(A1,A2,A3,ROOT)
!-----------------------------------------------------------------------
!
! --- ISCST2    Version: 1.0            Level: 931215           GCUBIC
!               D. Strimaitis, SRC
!
! PURPOSE:     Program solves the general cubic equation of the form:
!                  0 = x**3 + (a1)x**2 + (a2)x + (a3)
!              for the real roots
!              (Numerical Recipes, Press et al., 1986)
!
! ARGUMENTS:
!    PASSED:  a1,a2,a3  constants for terms as described above       [r]
!
!  RETURNED:  root      root(s) of equation                          [r]
!
! CALLING ROUTINES:   (utility routine)
!
! EXTERNAL ROUTINES:  none
!-----------------------------------------------------------------------
 
      IMPLICIT NONE
 
      REAL :: A1 , A2 , A3 , THIRD , A1SQ , A1CUBE , A1BY3 , Q , R ,    &
     &        QCUBE , RSQ , SQRTQ2 , THETA , ARG , ROOT(3)
 
      REAL , PARAMETER :: TWOPI = 6.2831853 , FOURPI = 12.566371
 
      THIRD = 1./3.
      A1SQ = A1*A1
      A1CUBE = A1*A1SQ
      A1BY3 = A1*THIRD
 
      Q = (A1SQ-3.*A2)/9.
      R = (2.*A1CUBE-9.*A1*A2+27.*A3)/54.
 
      QCUBE = Q*Q*Q
      RSQ = R*R
 
      IF ( QCUBE.GE.RSQ ) THEN
! ---    THREE real roots
         SQRTQ2 = SQRT(Q)*2.
         THETA = ACOS(R/SQRT(QCUBE))
         ROOT(1) = -SQRTQ2*COS(THETA/3.) - A1BY3
         ROOT(2) = -SQRTQ2*COS((THETA+TWOPI)/3.) - A1BY3
         ROOT(3) = -SQRTQ2*COS((THETA+FOURPI)/3.) - A1BY3
      ELSE
! ---    ONE real root
         ARG = (SQRT(RSQ-QCUBE)+ABS(R))**THIRD
         ROOT(1) = -SIGN(1.0,R)*(ARG+Q/ARG) - A1BY3
         ROOT(2) = 0.
         ROOT(3) = 0.
      ENDIF
 
 
      CONTINUE
      END
!*==LTOPG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE LTOPG(ISTAB)
!***********************************************************************
!               LTOPG Module of AERMOD Model
!
!        PURPOSE: Converts Monin-Obukhov length to PG stability class
!                 for use with AREADPLT option, based on Golder (1972)
!
!        PROGRAMMER: R. Brode
!
!        DATE:       November 21, 1997
!
!        INPUTS:  Monin-Obukhov lenght, OBULEN
!                 Surface roughness length, SFCZ0
!
!
!        OUTPUTS: HRVAL, Concentration or Deposition for Particular
!                 Source/Receptor Combination
!
!        CALLED FROM:   SETSZMN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL LNZ0 , LNZ02 , OBUINV
      REAL AB , BC , CD , DE , EF , AA , BB , CC , DD , EE , FF
      INTEGER ISTAB
 
!     Variable Initializations
      MODNAM = 'LTOPG'
 
!     Initialize local variables
 
      IF ( ZI.EQ.0. .OR. OBULEN.EQ.0. .OR. SFCZ0.LE.0. ) THEN
         ISTAB = 9
         GOTO 999
      ENDIF
 
      LNZ0 = ALOG(SFCZ0)
      LNZ02 = LNZ0*LNZ0
      AA = -0.1360107 + 0.0118433*LNZ0 + 0.00021242*LNZ02
      BB = -0.08608128 + 0.0118433*LNZ0 + 0.00021242*LNZ02
      CC = -0.0390887 + 0.009030514*LNZ0 - 0.0005869182*LNZ02
      DD = -0.0116834 + 0.00182343*LNZ0 - 0.000002247867*LNZ02
      EE = -DD
      FF = -CC
 
!     Interpolate to get 1./L values to define boundaries between
!     stability classes.
      AB = (AA+BB)/2.
      BC = (BB+CC)/2.
      CD = (CC+DD)/2.
      DE = (DD+EE)/2.
      EF = (EE+FF)/2.
 
!     Calculate stability class ISTAB
 
      OBUINV = 1./OBULEN
 
      IF ( OBUINV.LE.AB ) THEN
         ISTAB = 1
      ELSEIF ( OBUINV.LE.BC ) THEN
         ISTAB = 2
      ELSEIF ( OBUINV.LE.CD ) THEN
         ISTAB = 3
      ELSEIF ( OBUINV.LE.DE ) THEN
         ISTAB = 4
      ELSEIF ( OBUINV.LE.EF ) THEN
         ISTAB = 5
      ELSE
         ISTAB = 6
      ENDIF
 
 999  CONTINUE
      END
!*==VDP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
!----------------------------------------------------------------------
      SUBROUTINE VDP
!----------------------------------------------------------------------
!
! --- ISCST3     R.W. Brode, PES, Inc.
!
! --- PURPOSE:  Compute particle and gas dry deposition velocities
!               based on ANL report,
!               Wesely, et. al. (2001)
!
! --- MODIFIED: To add SCHMIDT number as global array.
!               R. W. Brode, MACTEC (f/k/a PES), Inc., 03/19/04
!
! --- INPUTS (and other variables):
!
!      DEFINITIONS OF DRY DEPOSITION VARIABLES AND CONSTANTS
!      C0-C6 = coefficients used in computing saturation vapor pressure
!      de = water vapor deficit computed from Ta and ambient RH (kPa)
!      D_suba = diffusivity in air of gas of interest (m**2/s) (User Input)
!      D_sub_b = diffusivity in air of particle (m**2/s)
!      dq = specific humidity deficit (g/kg)
!      Dv = diffusivity of water vapor in air (0.219e-04m**2/s)
!      el = Monin-Obukhov stability length scale (m)
!      EsTa = saturation vapor pressure at the ambient temperature (kPa)
!             (calculated outside source loop and passed through MODULE MAIN1)
!      F =  factor used in specifying LAIr
!      fo = measure of reactivity
!      f1 = factor for the variation of Rs with solar irradiance
!      f2 = factor for the variation of Rs with available soil moisture (global)
!      f3 = factor for the variation of Rs with water vapor deficit
!      f4 = factor for the variation of Rs with temperature
!      QSW = solar irradiance (W/m**2) (Provided by MPRM)
!      Gr = reference solar irradiance (30 W/m**2 for forests, otherwise 100 W/m**2)
!      Gust_Adj = unstable gusty wind adjustment for Rd
!      HENRY = Henry's Law coefficient for gas of interest (Pa*m**3/mol) (User Input)
!      ISEA5 = Wesely season category (1-5) (Based on User Input)
!      iseas = assign Wesely season category by month for the locale of the meteorological data
!      LANUSE = land use category (1-9) (User Input)
!      P = ambient pressure (kPa)  (Provided by MPRM)
!      Po = reference pressure (101.3 kPa)
!      Prate = precipitation total for the current hour (mm) (Provided by MPRM)
!      prec1 = precipitation one hour back
!      prec2 = precipitation two hours back
!      q = ambient specific humidity (g/kg)
!      qsat = specific humidity at saturation (g/kg)
!      rLAI = relative leaf area index factor
!      Ra = aerodynamic resistance (s/m)
!      Rac = gas-phase aerodymanic resistance within the canopy (s/m)
!      Raci = in-canopy aerodynamic resistance appropriate for Ustar=0.3 (s/m)
!      Rb = quasiliminar resistance for bulk surface (s/m)
!      Rc = bulk surface resistance (s/m)
!      Rcl = bulk cuticle resistance to uptake associated with lipid solubility (s/m)
!      Rcli = resistance to uptake by lipids in cuticles for individual leaves (s/m) (User Input)
!      Rcox = cuticle resistance for ozone, wetted (s/m)
!      Rcs = bulk surface resistance for sulfur dioxide, wetted (s/m)
!      Rcut = cuticle resistance (s/m)
!      Restab = table of resistances that vary with land use and season categories only.
!      Rg = ground resistance (s/m)
!      Rgo = ground resistance for ozone, wetted (s/m)
!      Rgs = ground resistance for sulfur dioxide, wetted (s/m)
!      Ri = surface resistance component (from table) (s/m)
!      RH = relative humidity (%)  (Provided by MPRM)
!      rLAI = relative leaf area index
!      Rm = mesophyll resistance (s/m)
!      Rp = resistance component for particles (s/m)
!      Rs = bulk canopy stomatal resistance (s/m)
!pes   Rx = term used to adjust components of cuticular and ground resistances
!           in the event of a hard freeze
!      S = scaling factor used to estimate cuticle resistance by land use category
!      Stab = table of S by land use category
!      Ta = ambient temperature (deg K) (Provided by MPRM)
!      Tcel = ambient temperature in celsius
!      To = reference temperature (273.16 K)
!      ustar  = friction velocity at the meteorological site (Provided by MPRM)
!      uref = wind speed at anemometer height from the meteorological site (Provided by MPRM)
!      Vdepg = gaseous deposition velocity (m/s)
!      Vdep(i) = particle deposition velocity for i-th particle size category (m/s)
!      vd1 = submicron particle deposition velocity (cm/s)
!      vd2 = coarse particle deposition velocity (cm/s)
!      VONKAR = von Karman constant (0.4)
!      vp = vapor pressure (kPa)
!      Wnew = available rootzone water for current hour (mm) (calculated outside
!             source loop and passed through MODULE MAIN1)
!      Wold = available rootzone water for previous hour (mm) (global)
!      Xnu = kinematic viscosity of air (0.1505 x 10-4 m**2/s, before correction for ambient temp. and pressure)
!      Zrdep = reference height (m)
 
!
! --- OUTPUT:  Deposition velocity for gases, Vdepg (m/s), or
!              Deposition velocity for particles, Vdep(i) (m/s) by
!                 particle size for Method 1 or for single category
!                 for Method 2
!
! --- VDP_TOX called by:  VDP
! --- VDP_TOX calls:      none
!----------------------------------------------------------------------
!
      USE MAIN1
      IMPLICIT NONE
 
      SAVE 
 
      REAL , PARAMETER :: A1 = 1.257 , A2 = 0.4 , A3 = 0.55 ,           &
     &                    XMFP = 6.5E-6
      REAL DIAMCM
      INTEGER LANUSE , ILAND_NDX
      REAL TCEL , IM , RI , RCS , RCO , RX
      REAL RACI , RGS , RGO , F , RLAI , GR , TT , XX , TD , ESTD
      REAL DE , RP , F1 , ALFA , F3 , F4 , PPP , RCOX , RAC
      REAL D_SUBA , RB , RCL , VD1 , VD2 , RSUBM , SFACT , D_SUB_B
      REAL STAB , RESTAB , Z0TAB , DV
      REAL PO , TO , PRESSURE , A , Q , DQ , QSAT , VP
      INTEGER J , K , ISEA5
 
      INTEGER :: I , N
      REAL :: ELABS , PSIH , RA , T1 , ST , XINERT , RD(NPDMAX) , RDG , &
     &        RG , B , FR , RS , RF , RC , GUST_ADJ
!
      DIMENSION RESTAB(9,6,5) , STAB(9)
 
!     Initialize stability factor array by land use category
      DATA STAB/1.0E-5 , 6. , 5. , 7. , 3. , 4. , 1.0E-5 , 1.0E-5 , 3./
 
!     Initialize resistance table by land use category and season
      DATA (((RESTAB(I,J,K),I=1,9),J=1,6),K=1,5)/1.E07 , 60. , 120. ,   &
     &      100. , 200. , 150. , 1.E07 , 1.E07 , 80. , 1.E07 , 2000. ,  &
     &      2000. , 2000. , 2000. , 2000. , 1.E07 , 1.E07 , 2500. ,     &
     &      1.E07 , 1000. , 1000. , 1000. , 2000. , 2000. , 1.E07 ,     &
     &      1.E07 , 1000. , 100. , 200. , 100. , 2000. , 100. , 1500. , &
     &      0. , 0. , 300. , 400. , 150. , 350. , 300. , 500. , 450. ,  &
     &      0. , 1000. , 0. , 300. , 150. , 200. , 200. , 300. , 300. , &
     &      2000. , 400. , 1000. , 1.E07 , 1.E07 , 1.E07 , 350. ,       &
     &      1.E07 , 700. , 1.E07 , 1.E07 , 1.E07 , 1.E07 , 6500. ,      &
     &      6500. , 3000. , 2000. , 2000. , 1.E07 , 1.E07 , 6500. ,     &
     &      1.E07 , 400. , 300. , 500. , 600. , 1000. , 1.E07 , 1.E07 , &
     &      300. , 100. , 150. , 100. , 1700. , 100. , 1200. , 0. , 0. ,&
     &      200. , 400. , 200. , 350. , 300. , 500. , 450. , 0. ,       &
     &      1000. , 0. , 300. , 150. , 200. , 200. , 300. , 300. ,      &
     &      2000. , 400. , 800. , 1.E07 , 1.E07 , 1.E07 , 500. , 1.E07 ,&
     &      1000. , 1.E07 , 1.E07 , 1.E07 , 1.E07 , 1.E07 , 9000. ,     &
     &      6000. , 2000. , 2000. , 1.E07 , 1.E07 , 9000. , 1.E07 ,     &
     &      1.E07 , 400. , 600. , 800. , 1600. , 1.E07 , 1.E07 , 800. , &
     &      100. , 0. , 100. , 1500. , 100. , 1000. , 0. , 0. , 100. ,  &
     &      400. , 150. , 350. , 300. , 500. , 450. , 0. , 0. , 1000. , &
     &      300. , 150. , 200. , 200. , 300. , 300. , 2000. , 400. ,    &
     &      1000. , 1.E07 , 1.E07 , 1.E07 , 800. , 1.E07 , 1600. ,      &
     &      1.E07 , 1.E07 , 1.E07 , 1.E07 , 1.E07 , 1.E07 , 400. ,      &
     &      1.E07 , 800. , 1.E07 , 1.E07 , 9000. , 1.E07 , 2000. ,      &
     &      1000. , 600. , 2000. , 1200. , 1.E07 , 1.E07 , 800. , 100. ,&
     &      0. , 10. , 1500. , 100. , 1000. , 0. , 0. , 50. , 100. ,    &
     &      100. , 100. , 100. , 200. , 200. , 0. , 1000. , 100. ,      &
     &      600. , 3500. , 3500. , 3500. , 500. , 500. , 2000. , 400. , &
     &      3500. , 1.E07 , 100. , 120. , 100. , 200. , 150. , 1.E07 ,  &
     &      1.E07 , 80. , 1.E07 , 2000. , 2000. , 1500. , 2000. ,       &
     &      2000. , 1.E07 , 1.E07 , 2000. , 1.E07 , 1000. , 250. ,      &
     &      350. , 500. , 700. , 1.E07 , 1.E07 , 300. , 100. , 50. ,    &
     &      80. , 1500. , 100. , 1000. , 0. , 0. , 200. , 500. , 150. , &
     &      350. , 300. , 500. , 450. , 0. , 1000. , 0. , 300. , 150. , &
     &      200. , 200. , 300. , 300. , 2000. , 400. , 1000./
 
      DV = 0.219E-04
      PO = 101.3
      TO = 273.16
!PES  Define alfa based on Eqn. 10
      ALFA = 0.1
 
 
! ... Convert surface pressure and temperature to proper units.
      PRESSURE = SFCP/10.
      IF ( SFCP.LT.10 ) PRESSURE = 100.
      TCEL = TA - TO
 
!PESc ... check to catch errors in temperature input
!PESc     This code is not used since currently no dew point data (Td)
!PESc     provided from MPRM.
!PES      if (Tcel.lt.Td .and. Td.lt.50.) then
!PES       Tcel = Tdry
!PES       Ta = Tcel+273.2
!PES      end if
 
      IF ( NPD.EQ.0 ) THEN
! ...    Assign parameters for gas deposition
 
! ...    Assign land use category for this direction based on user input.
         ILAND_NDX = NINT(AFV/10.)
         IF ( ILAND_NDX.EQ.0 ) ILAND_NDX = 36
         LANUSE = ILAND_GD(ILAND_NDX)
 
! ...    Assign Wesely "seasonal" category (1-5) based on calendar month
         ISEA5 = ISEAS_GD(IMONTH)
 
! ...    Assign surface roughness, stability factor and resistance terms
         SFACT = STAB(LANUSE)
         RI = RESTAB(LANUSE,1,ISEA5)
         RCS = RESTAB(LANUSE,2,ISEA5)
         RCO = RESTAB(LANUSE,3,ISEA5)
         RACI = RESTAB(LANUSE,4,ISEA5)
         RGS = RESTAB(LANUSE,5,ISEA5)
         RGO = RESTAB(LANUSE,6,ISEA5)
! ...    Compute rLAI and reference solar irradiance as a function of
!        land use category and season.
         IF ( ISEA5.EQ.1 .OR. ISEA5.EQ.3 .OR. ISEA5.EQ.4 ) THEN
            F = 1.0
         ELSEIF ( ISEA5.EQ.2 ) THEN
!           Assign user-supplied value for season 2, default it 0.50
            F = FSEAS2
         ELSEIF ( ISEA5.EQ.5 ) THEN
!           Assign user-supplied value for season 5, default it 0.25
            F = FSEAS5
         ENDIF
         IF ( LANUSE.EQ.4 .OR. LANUSE.EQ.6 ) THEN
            RLAI = F
            GR = 30.
         ELSE
            RLAI = F**0.5
            GR = 100.
         ENDIF
 
      ENDIF
 
! ... Use Zrdep of SFCZ0 plus 1.0 meter for TOXICS deposition option
      ZRDEP = SFCZ0 + 1.0
 
! ... Check to avoid corruption by bad humidity input data
      IF ( RH.GT.100. ) RH = 100.
      IF ( RH.LT.5. ) RH = 5.
 
! ... Compute vapor pressure deficit
      DE = ((100.-RH)/100.)*ESTA
      IF ( DE.LT.0. ) DE = 0.
 
! ... Compute specific humidity at saturation (g/kg)
      QSAT = 1.E03*0.622*ESTA/(PRESSURE-0.378*ESTA)
 
! ... Compute ambient specific humidity (g/kg)
      VP = (RH/100.)*ESTA
      Q = 1.E03*0.622*VP/(PRESSURE-0.378*VP)
 
! ... Compute specific humidity deficit (g/kg)
      DQ = QSAT - Q
      IF ( DQ.LT.0. ) DQ = 0.
 
! ... Compute atmospheric resistance Ra
 
      IF ( OBULEN.GE.0. ) THEN
         RA = (1./(VONKAR*USTAR))*(LOG(ZRDEP/SFCZ0)+5.0*ZRDEP/OBULEN)
 
      ELSE
!        Ra = (1./(VONKAR*ustar))*(log(Zrdep/SFCZ0)-
!    1   2.*log(0.5*(1.+sqrt(1.-16.*(Zrdep/obulen)))))
! ...   The following is the expanded form of the unstable Ra equation (2c)
         RA = (1./(VONKAR*USTAR))                                       &
     &        *LOG(((SQRT(1.-16.*ZRDEP/OBULEN)-1.)*(SQRT                &
     &        (1.-16.*SFCZ0/OBULEN)+1.))                                &
     &        /((SQRT(1.-16.*ZRDEP/OBULEN)+1.)*                         &
     &        (SQRT(1.-16.*SFCZ0/OBULEN)-1.)))
      ENDIF
 
! ... Compute kinematic viscosity of air (m**2/s), with temp and presssure corrections
      XNU = 0.1505*1.E-4*((TA/TO)**1.772)*(PRESSURE/PO)                 &
     &      *(1.+0.0132*(PRESSURE-PO))
 
!***
      IF ( NPD.EQ.0 ) THEN
 
! ...    Compute gas deposition velocity, vdepg
 
! ...    compute parameters necessary for bulk stomatal resistance
         F1 = ((QSW/GR)+0.01)/((QSW/GR)+1.0)
         IF ( F1.LE.0.01 ) F1 = 0.01
         IF ( F1.GT.1. ) F1 = 1.
         IF ( RI.EQ.1.E07 ) F1 = 0.01
!PES     Calculation of Wnew and f2 moved outside the source loop
 
         F3 = 1./(1.+ALFA*DE)
         IF ( F3.LE.0.01 ) F3 = 0.01
 
         F4 = 1. - 0.0016*(298.2-TA)**2
         IF ( F4.LE.0.01 ) F4 = 0.01
 
 
! ...    Modify certain resistances if the surface is wetted (high humidity/
!        weak mixing or rain during current or previous two hours)
         PPP = PRATE + PREC1 + PREC2
 
!PES     Adjust Rcs and Rco based on cloud cover from MPRM
! ...    Determine factor "a" as a function of cloud cover
         A = 0.30
         IF ( NCLOUD.LE.2 ) A = 0.45
         IF ( NCLOUD.GE.8 ) A = 0.15
         IF ( ISEA5.EQ.5 .AND. IPCODE.GT.18 .AND. TA.LT.TO ) THEN
! ...       Skip adjustments for wetted surface if surface is snow covered
            RCOX = RCO
            CONTINUE
         ELSEIF ( (USTAR.LT.(A/DQ) .AND. ((IHOUR.LT.8) .OR. (IHOUR.GT.19&
     &            ))) .OR. PPP.GT.0. ) THEN
            RCS = 50.
            RCOX = 0.75*RCO
            RGS = 50.
            IF ( (USTAR.LT.(A/DQ)) .AND.                                &
     &           ((IHOUR.LT.8) .OR. (IHOUR.GT.19)) ) THEN
! ...          Limit Ra for gases if surface is wetted by dew
               IF ( RA.LT.1000. ) RA = 1000.
            ENDIF
         ELSE
            RCOX = RCO
         ENDIF
 
! ...    Calculate Rx term, used to adjust cuticular and ground terms for
!        hard freeze
         RX = 1.E03*EXP(-(TA-269.2))
 
! ...    drive some resistances to high values if there is a hard freeze
         RCS = RCS + RX
         RGS = RGS + RX
         RGO = RGO + RX
         RCOX = RCOX + RX
 
! ...    then compute in-canopy aerodynamic resistance, Racx
         RAC = 0.3*RACI/USTAR
 
! ...    Assign diffusivity for this source. Note that conversion of
!        diffusivity to m2/s is made in VDP1
         D_SUBA = PDIFF(ISRC)
 
! ...    Compute quasiliminar resistance for bulk surface, Rb
 
         RB = 2.2*((XNU/D_SUBA)**(2./3.))/(VONKAR*USTAR)
 
! ...    Compute bulk surface resistance, Rc
 
! ...    First compute the bulk canopy stomatal resistance, Rs
 
         RS = RI*(DV/D_SUBA)/(F1*F2*F3*F4)
         IF ( RS.GT.1.E07 ) RS = 1.E07
 
! ...    Next compute bulk canopy leaf mesophyll resistance, Rm
! ...    The fo factor applies to ozone (fo=1.0) and nitrogen oxide (fo=0.1).
!        The fo factor should also be set to 1.0 for titanium tetrachloride
!        and divalent mercury, otherwise fo is 0.0
 
         RM = 1./((0.034/HENRY(ISRC))+100.*FO)
         IF ( RM.GT.1.E07 ) RM = 1.E07
 
! ...    Then compute cuticular resistance, Rcut
!        Note that Rcli is converted from s/cm to s/m in SUB. VDP1
 
         RCL = RCLI(ISRC)/(RLAI*SFACT)
! ...    Adjust Rcl for hard freeze
         RCL = RCL + RX
         IF ( RCL.LT.100. ) RCL = 100.
 
         RCUT = 1./((1.E-3/(HENRY(ISRC)*RCS))                           &
     &          +((FO+FO*FO/HENRY(ISRC))/RCOX)+(1./RCL))
 
! ...    Next compute ground resistance Rg
 
         RG = 1./((1.E-3/(HENRY(ISRC)*RGS))+((FO+(0.1*FO*FO))/RGO))
         IF ( RG.GT.1.E07 ) RG = 1.E07
 
! ...    Finally, combine to compute Rc
 
         RC = 1./((RLAI/(RS+RM))+(RLAI/RCUT)+(1./(RAC+RG)))
 
! ...    Add the parallel resistances and take the inverse to compute the
!        deposition velocity for gases, Vdepg.
 
         VDEPG = 1./(RA+RB+RC)
 
!***
      ELSE
! ...    Compute particle deposition velocity, vdep
 
         IF ( .NOT.L_METHOD2(ISRC) ) THEN
! ...       Calculate using existing ISCST3 method with modified Rb (Eq. 21)
 
! ---       Calculate t1 using Xnu, adjusted for ambient temp and pressure
            T1 = USTAR*USTAR/XNU
!
! ---       LOOP OVER SIZE INTERVALS
            DO I = 1 , NPD
!
               ST = TSTOP(I)*T1
!
! ---          Compute inertial impaction term
               XINERT = 10**(-3./ST)
!
! ---          Calculate Schmidt number based on ambient temp and pressure
               D_SUB_B = 8.09E-14*(TA*SCF(I)/PDIAM(I))
               SCHMIDT(I) = XNU/D_SUB_B
 
! ---          Calculate unstable gusty wind adjustment for rd,
!              set factor to 1.0 for DFAULT option
               IF ( WSTAR.LE.0.0 ) THEN
                  GUST_ADJ = 1.0
               ELSE
                  GUST_ADJ = 1.0 + 0.24*WSTAR*WSTAR/(USTAR*USTAR)
               ENDIF
!
! ---          Compute the deposition layer resistance (s/m)
               RD(I) = 1.0/(GUST_ADJ*USTAR*(SCHMIDT(I)**(-2./3.)+XINERT)&
     &                 )
!
! ---          Deposition velocity for this particle size category
               VDEP(I) = 1.0/(RA+RD(I)+RA*RD(I)*VGRAV(I)) + VGRAV(I)    &
     &                   + VDPHOR
 
            ENDDO
! ***
            IF ( DEBUG ) THEN
               WRITE (IOUNIT,*)
               WRITE (IOUNIT,*) 'RA (s/m)    = ' , RA
               WRITE (IOUNIT,*) 'RD (s/m)    = ' , (RD(N),N=1,NPD)
               WRITE (IOUNIT,*) 'VDEP (m/s)  = ' , (VDEP(N),N=1,NPD)
            ENDIF
 
         ELSEIF ( L_METHOD2(ISRC) ) THEN
! ...       Calculate deposition velocities for fine (vd1) and
!           coarse (vd2) particles for METHOD 2
            IF ( OBULEN.GE.0.0 ) THEN
               RP = 500./USTAR
            ELSE
               RP = 500./(USTAR*(1.-(300./OBULEN)))
            ENDIF
 
!
! ---       Calculate Schmidt number based on ambient temp and pressure
            D_SUB_B = 8.09E-14*(TA*SCF(1)/PDIAM(1))
            SCHMIDT(1) = XNU/D_SUB_B
 
            VD1 = 1./(RA+RP)
! ...       Assign value of 0.002 m/s for Vgrav for coarse mode of METHOD 2
            VD2 = 0.002 + (1./(RA+RP+0.002*RA*RP))
 
! ...       Combine fine and coarse terms to get total deposition velocity.
!           Note that subscript 1 for vdep is used since NPD = 1 for METHOD 2.
            VDEP(1) = FINEMASS(ISRC)*VD1 + (1.-FINEMASS(ISRC))*VD2
         ENDIF
 
      ENDIF
 
! ... Write resistances and deposition velocities to separate files:
!     GDEP.DAT for gas deposition and PDEP.DAT for particle deposition.
 
      IF ( NPD.EQ.0 ) THEN
         WRITE (100,1001) KURDAT , ISRC , RA , RB , RC , VDEPG
 1001    FORMAT (1x,i8,1x,i6,4(2x,e12.6))
      ENDIF
      IF ( .NOT.L_METHOD2(ISRC) ) THEN
         DO I = 1 , NPD
            WRITE (101,1002) KURDAT , ISRC , I , RA , RD(I) , VGRAV(I) ,&
     &                       VDEP(I)
 1002       FORMAT (1x,i8,1x,i6,2x,i3,'  METHOD_1 ',4(2x,e12.6))
         ENDDO
      ELSEIF ( L_METHOD2(ISRC) ) THEN
         WRITE (101,1003) KURDAT , ISRC , RA , RP , VGRAV(1) , VDEP(1)
 1003    FORMAT (1x,i8,1x,i6,4x,'-  METHOD_2 ',4(2x,e12.6))
      ENDIF
 
      CONTINUE
      END
!*==SCAVRAT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
!----------------------------------------------------------------------
      SUBROUTINE SCAVRAT
!----------------------------------------------------------------------
!
! --- AERMOD     R.W. Brode, PES
!
! --- PURPOSE:  Compute the wet SCAVenging RATio for particles, as a
!               function of particle size, and for gases, based on
!               new algorithms developed by Chris Walcek
!
! --- MODIFIED: To add calculation of collision efficiency as a
!               function of particle size and raindrop size for
!               particulate emissions, based on Slinn (1984) and
!               Seinfeld and Pandis (1998).
!               R. W. Brode, MACTEC (f/k/a PES), Inc., 03/19/04
!
! --- INPUTS:
!     Global variables:
!            IPCODE - integer    - Precip. code (00-45)
!             PRATE - real       - Precip. rate (mm/hr)
!                TA - real       - Ambient Temperature (deg K)
!               NPD - integer    - Number of particle size categories
!
! --- OUTPUT:
!     Global variables:
!            WASHOUT- real array - Washout coefficient for particles
!            PSCVRT - real array - Scavenging ratio for particles (1/s)
!            GSCVRT - real       - Scavenging ratio for gases (1/s)
!
!     Local variables:
!            ECOLL  - real array - Collision efficiency for particles
!
! --- SCAVRAT called by:  PCALC, VCALC, ACALC
! --- SCAVRAT calls:      none
!----------------------------------------------------------------------
!
! --- Include common blocks
      USE MAIN1
      IMPLICIT NONE
 
      SAVE 
 
! --- Assign RHOW, density of water (g/m^3), as a parameter = 1.0E6
      REAL , PARAMETER :: RHOW = 1.0E6
      INTEGER :: I , N , ILQ , IMISS
      REAL :: ECOLL(NPDMAX) , VFALL , RDROP , FSUBG , FSUBL , TABS ,    &
     &        TRES , REYNOLD , STOKE , SSTAR , KAPPA , TERM1 , TERM2 ,  &
     &        TERM3
 
      DATA IMISS/9999/
 
      IF ( DEBUG ) THEN
         WRITE (IOUNIT,*)
         WRITE (IOUNIT,*) 'SUBR. SCAVRAT -- Inputs'
         WRITE (IOUNIT,*) 'IPCODE               = ' , IPCODE
         WRITE (IOUNIT,*) 'PRATE (mm/hr)        = ' , PRATE
         WRITE (IOUNIT,*) 'TA (deg K)           = ' , TA
         WRITE (IOUNIT,*) 'NPD                  = ' , NPD
         WRITE (IOUNIT,*)
      ENDIF
 
! --- If no precipitation, no wet removal
      IF ( PRATE.EQ.0. ) THEN
         DO I = 1 , NPD
            PSCVRT(I) = 0.0
            WASHOUT(I) = 0.0
            ECOLL(I) = 0.0
         ENDDO
         GSCVRT = 0.0
      ELSEIF ( NPD.GT.0 ) THEN
!PES --- Apply TOXICS option based on Wesely, et. al. (2001), with
!PES     with modifications based on Chris Walcek, for particles.
!PES     ZSUBP is calculated in PCALC as the top of the plume or the PBL
!PES     height (ZI), whichever is greater.  The top of the plume is defined
!PES     as plume centerline height plus 2.15 sigma-z, evaluated at a downwind
!PES     distance of 20 kilometers.  Since STABLE hours are modeled as
!PES     unlimited mixing, ZSUBP is simply the top of the plume for those
!PES     hours.
 
! ---    Calculate the precipitaion fall speed, VFALL (m/s) based on
!        precipitation rate in mm/hr.
         VFALL = 3.75*PRATE**0.111
 
! ---    Calculate rainfall droplet radius, RDROP (cm), based on precipitation
!        rate in mm/hr.
         RDROP = (PRATE**0.232)/18.11
 
         DO I = 1 , NPD
! ---       Calculate collision efficiency, ECOLL, as function of particle
!           size and raindrop size based on Slinn (1984) and Seinfeld and
!           Pandis (1998).
 
! ---       Calculate Reynolds number for raindrop
            REYNOLD = RDROP*0.01*VFALL/XNU
!           Calculate diffusion term, TERM1
            TERM1 = (4./(REYNOLD*SCHMIDT(I)))                           &
     &              *(1.+0.4*SQRT(REYNOLD)*SCHMIDT(I)**0.333333+        &
     &              0.16*SQRT(REYNOLD*SCHMIDT(I)))
 
! ---       Calculate ratio of particle diameter and raindrop diameter,
!           KAPPA, with adjustments for units
            KAPPA = (PDIAM(I)*1.E-6)/(RDROP*0.02)
!           Calculate interception term, TERM2
!           The constant term 1.81E-2 is ratio of viscosity or air to water
            TERM2 = 4.*KAPPA*(1.81E-2+KAPPA*(1.+2.*SQRT(REYNOLD)))
 
! ---       Calculate Stokes number for raindrop
            STOKE = TSTOP(I)*(VFALL-VGRAV(I))/(RDROP*0.01)
!           Calculate critical Stokes number
            SSTAR = (1.2+ALOG(1.+REYNOLD)/12.)/(1.+ALOG(1.+REYNOLD))
            SSTAR = MIN(SSTAR,STOKE)
!           Calculate inertial impaction term, TERM3
            TERM3 = ((STOKE-SSTAR)/(STOKE-SSTAR+2./3.))**1.5
!           Scale TERM3, inertial impaction term,by ratio of water
!           density (1 g/cm**3) to particle density
            TERM3 = TERM3*SQRT(1./PDENS(I))
 
            ECOLL(I) = MIN(1.0,TERM1+TERM2+TERM3)
 
! ---       Calculate washout coefficient from Equation 29; factor of 0.01
!           converts drop radius from cm to m.
            WASHOUT(I) = 1.5*(ZSUBP*ECOLL(I))/(2.*RDROP*0.01)
 
            IF ( PRATE.GT.0.0 ) THEN
! ---          Calculate scavenging rate (1/s); factor of 3.6E4 converts drop
!              radius from cm to mm, and converts hours to seconds.
               PSCVRT(I) = 1.5*ECOLL(I)*PRATE/(2.*RDROP*3.6E4)
            ELSE
               PSCVRT(I) = 0.0
            ENDIF
         ENDDO
      ELSE
!PES --- Apply TOXICS option based on Wesely, et. al. (2001),
!PES     with modifications based on Chris Walcek, for gases.
!PES     ZSUBP is calculated in PCALC as the top of the plume or the PBL
!PES     height (ZI), whichever is greater.  The top of the plume is defined
!PES     as plume centerline height plus 2.15 sigma-z, evaluated at a downwind
!PES     distance of 20 kilometers.
 
! ---    Calculate the precipitaion fall speed, VFALL (m/s) based on
!        precipitation rate in mm/hr.
         VFALL = 3.75*PRATE**0.111
 
! ---    Calculate rainfall droplet radius, RDROP (cm), based on precipitation
!        rate in mm/hr.
         RDROP = (PRATE**0.232)/18.11
 
! ---    Calculate liquid content of falling rain, LIQCONT (g/m^3), based on
!        precipitation rate in mm/hr.
         LIQCONT = (PRATE**0.889)/13.28
 
! ---    Calculate gas-side diffusion enhancement factor, FSUBG (unitless),
!        based on droplet radius (cm).  Linear approximation based on
!        Figure 13-20 of "Microphysics of Clouds and Precipitation" by
!        Hans Pruppacher and James Klett.
         FSUBG = 80.0*RDROP + 1.0
 
! ---    Set the liquid-side diffusion enhancement factor, FSUBL (unitless),
!        based on droplet radius.
         IF ( RDROP.LT.0.01 ) THEN
            FSUBL = 1
         ELSEIF ( RDROP.LE.0.05 ) THEN
            FSUBL = 2.6
         ELSE
            FSUBL = 20.0
         ENDIF
 
! ---    Calculate the absorption time scale, TABS (s); first calculate
!        term in the denominator.
         DENOM = (1.0+(LIQCONT*RGAS*TA)/(HENRY(ISRC)*RHOW))
         TABS = (RDROP**2*RGAS*TA/(HENRY(ISRC)*3.*PDIFF(ISRC)*1.E4*FSUBG&
     &          )+(4.*RDROP*RGAS*TA)/(HENRY(ISRC)*3.*50000.*0.01)       &
     &          +(RDROP**2*0.17)/(3.*PDIFFW(ISRC)*1.E4*FSUBL))/DENOM
 
! ---    Calculate the residence time of drops in the plume, TRES (s);
!        ZSUBP is defined in PCALC.
         TRES = ZSUBP/VFALL
 
! ---    Calculate the fraction of saturation, FRACSAT, based on time scales.
         FRACSAT = MIN(1.0,TRES/TABS)
 
! ---    Calculate equivalent scavenging rate (1/s)
         GSCVRT = (FRACSAT*RGAS*TA*PRATE)                               &
     &            /(3600.*ZSUBP*HENRY(ISRC)*1.E3*DENOM)
 
      ENDIF
 
      IF ( DEBUG ) THEN
         WRITE (IOUNIT,*) 'SUBR. SCAVRAT -- Results'
         IF ( NPD.EQ.0 ) THEN
            WRITE (IOUNIT,*) 'GSCVRT (1/s)= ' , GSCVRT
         ELSEIF ( NPD.GT.0 ) THEN
            WRITE (IOUNIT,*) 'PSCVRT (1/s)= ' , (PSCVRT(N),N=1,NPD)
            WRITE (IOUNIT,*) 'COLL. EFF.  = ' , (ECOLL(N),N=1,NPD)
            WRITE (IOUNIT,*) 'WASHOUT COEF= ' , (WASHOUT(N),N=1,NPD)
         ENDIF
         WRITE (IOUNIT,*)
      ENDIF
 
      CONTINUE
      END
!*==PDEP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PDEP(XARG)
!***********************************************************************
!               PDEP Module of AERMOD Model
!
!        PURPOSE: Calculates Deposition Adjustment Factors from DEPLETE
!
!        PROGRAMMER: R. W. Brode, MACTEC/PES, Inc.
!
!        DATE:       September 20, 2003
!
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
      REAL :: XARG
 
!     Variable Initializations
      MODNAM = 'PDEP'
 
!     Loop over particle sizes
      DO I = 1 , NPD
         DQCOR(I) = 1.0
         WQCOR(I) = 1.0
         IF ( DDPLETE ) THEN
!           Determine factor for dry depletion
            VSETL = VGRAV(I)
            CALL DEPLETE(VDEP(I),XARG,ROMBERG,DQCOR(I))
         ENDIF
!           Determine source depletion factor from wet removal
!           Simple Terrain Model
         IF ( WDPLETE .AND. PSCVRT(I).GT.0.0 ) WQCOR(I)                 &
     &        = EXP(-PSCVRT(I)*XARG/US)
      ENDDO
 
      CONTINUE
      END
!*==PDEPG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PDEPG(XARG)
!***********************************************************************
!               PDEPG Module of AERMOD Model
!
!        PURPOSE: Calculates Deposition Adjustment Factors from DEPLETE
!                 for Gases
!
!        PROGRAMMER: R. W. Brode, MACTEC/PES, Inc.
!
!        DATE:       September 29, 2003
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: XARG
 
!     Variable Initializations
      MODNAM = 'PDEPG'
 
!     Initialize source depletion factors to unity.
      DQCORG = 1.0
      WQCORG = 1.0
!        Determine factor for dry depletion
      IF ( DDPLETE ) CALL DEPLETE(VDEPG,XARG,ROMBERG,DQCORG)
!        Determine source depletion factor
!        from wet removal (GASES)
!        Simple Terrain Model
      IF ( WDPLETE .AND. GSCVRT.GT.0.0 ) WQCORG = EXP(-GSCVRT*XARG/US)
 
      CONTINUE
      END
!*==DEPLETE.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!-----------------------------------------------------------------------
      SUBROUTINE DEPLETE(VDI,XRI,LROMB,QCOR)
!-----------------------------------------------------------------------
!
! --- DEPLETE Module of AERMOD
!              R.W. Brode, MACTEC/PES
!
! PURPOSE:     Subroutine DEPLETE provides the value of the integral of
!              the vertical distribution function over the travel of the
!              plume from the source to the receptor.  Integration is
!              performed by 2-point gaussian quadrature or Romberg
!              integration method, depending on logical argument, lromb.
!
! ARGUMENTS:
!    PASSED:   vdi      deposition velocity (m/s)              [r]
!              vsi      gravitational settling velocity (m/s)  [r]
!              xri      distance from source to receptor (m)   [r]
!              hmixi    mixing height (m)                      [r]
!              lromb    logical for use of Romberg integration [l]
!
!  RETURNED:   qcor     ratio of depleted emission rate to original  [r]
!
! CALLING ROUTINES:   PDEP, PDEPG
!
! EXTERNAL ROUTINES:  F2INT, QATR2, QG2D2
!-----------------------------------------------------------------------
 
!     Set up call to QATR2(xl,xu,eps,ndim2,fct,y,ier,num,aux2)
!     Declare parameter to fix the size of the aux2 array
      IMPLICIT NONE
 
      SAVE 
      LOGICAL LROMB
      REAL :: VDI , XRI , QCOR , EPS , VALUE
      EXTERNAL F2INT
!JRA F2INT must be given a type if it is a FUNCTION
!          spotted by NAG 5.0 compiler
      REAL F2INT      
      INTEGER NUM , IER
      INTEGER , PARAMETER :: NDIM2 = 12
      REAL AUX2(NDIM2)
 
!     Evaluate integral, Use Romberg if LROMB=.T., otherwise use
!     two-point Gaussian Quadrature:
      IF ( LROMB ) THEN
!        Use ROMBERG Integration
         EPS = .05
         CALL QATR2(1.,XRI,EPS,NDIM2,F2INT,VALUE,IER,NUM,AUX2)
      ELSE
!        Use 2-point Gaussian Quadrature
         CALL QG2D2(1.,XRI,F2INT,VALUE)
      ENDIF
 
      IF ( VDI*VALUE.GT.50.0 ) THEN
!        Potential underflow, limit product to 50.0
         VALUE = 50.0/VDI
      ELSEIF ( VDI*VALUE.LT.-50.0 ) THEN
!        Potential overflow, limit product to 50.0
         VALUE = -50.0/VDI
      ENDIF
 
      QCOR = EXP(-VDI*VALUE)
 
      CONTINUE
      END
!*==F2INT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!-----------------------------------------------------------------------
      FUNCTION F2INT(XI)
!-----------------------------------------------------------------------
!
! --- F2INT Module of AERMOD
!              R.W. Brode, MACTEC/PES
!
! PURPOSE:     Function is the integrand of integral over the travel
!              distance to obtain the fraction of material removed from
!              the plume. Module MAIN1 is used to pass data that are
!              constant during the integration, so QATR (the integrator)
!              only needs to pass values of distance.
!
! ARGUMENTS:
!    PASSED:  xi        distance from source                         [r]
!
!  RETURNED:  f2int     value of integrand                           [r]
!
! CALLING ROUTINES:   QATR2, QG2D2
!
! EXTERNAL ROUTINES:
!
!-----------------------------------------------------------------------
!      USE DEPVAR
      USE MAIN1
      IMPLICIT NONE
 
      REAL XI , VWRAP , VLIFT , F2INT , ZETMP , ZHTMP
 
      SAVE 
 
!     Set initial effective parameters
      UEFF = US
      SVEFF = SVS
      SWEFF = SWS
      TGEFF = TGS
      IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
         UEFFD = US
         SVEFFD = SVS
         SWEFFD = SWS
         UEFFN = US
         SVEFFN = SVS
         SWEFFN = SWS
         UEFF3 = US
         SVEFF3 = SVS
         SWEFF3 = SWS
         TGEFF3 = TGS
      ENDIF
 
!     Set temporary receptor elevation and height scale
      ZETMP = ZELEV
      ZELEV = ZS + (ZETMP-ZS)*XI/XDIST
 
      ZHTMP = ZHILL
      ZHILL = HS + (ZHTMP-HS)*XI/XDIST
 
!     Define plume centroid height (CENTER) for use in
!     inhomogeneity calculations
      CALL CENTROID(XI)
 
!        Calculate the plume rise                     ---   CALL DELTAH
      IF ( SRCTYP(ISRC).EQ.'POINT' ) CALL DELTAH(XI)
 
!     If the atmosphere is unstable and the stack
!     top is below the mixing height, calculate
!     the CBL PDF coefficients                     ---   CALL PDF
      IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!     Determine Effective Plume Height             ---   CALL HEFF
      CALL HEFF(XI)
 
!     Compute effective parameters using an
!     average through plume layer
      CALL IBLVAL(XI)
 
!     Call PDF & HEFF again for final CBL plume heights
      IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
         CALL PDF
         CALL HEFF(XI)
      ENDIF
 
!     Determine Dispersion Parameters              ---   CALL PDIS
      CALL PDIS(XI)
 
!     Calculate Plume Tilt Due to Settling, HV
      HV = (XI/US)*VSETL
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!        Calculate height of the "effective reflecting surface"
!        Calculate Settled Plume Height(s), HESETL
         HESETL = MAX(0.0,HE-HV)
         CALL REFL_HT(HESETL,XI,SZB,0.0,HSBL)
      ELSEIF ( UNSTAB ) THEN
         HESETL = MAX(0.0,0.5*(HED1+HED2)-HV)
         HSBL = 0.0
      ENDIF
 
      IF ( UNSTAB .AND. (HS.LT.ZI) .AND. (PPF.GT.0.0) ) THEN
!        Calculate height of the "effective reflecting surface"
!        Calculate Settled Plume Height(s), HE3SETL
         HE3SETL = MAX(0.0,HE3-HV)
         CALL REFL_HT(HE3SETL,XI,SZB3,0.0,HPEN)
         HPEN = MAX(HPEN,ZI)
      ELSE
         HPEN = 0.0
      ENDIF
 
!     Determine the CRITical Dividing Streamline---   CALL CRITDS
      CALL CRITDS(HESETL)
 
!     Calculate the fraction of plume below
!     HCRIT, PHEE                               ---   CALL PFRACT
      CALL PFRACT(HESETL)
 
!     Calculate FOPT = f(PHEE)                  ---   CALL FTERM
      CALL FTERM
 
      IF ( FOPT.EQ.0.0 ) THEN
         VWRAP = 0.0
      ELSE
!        Assign receptor height for vertical term calculations
         ZR = ZRT + ZRDEP
 
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!           Calculate the vertical term, FSUBZ              ---   CALL VRTSBL
!           With stable plume reflections and effective Zi
            IF ( ZR.LE.HSBL ) THEN
               CALL VRTSBL(SZ,MAX(0.0,HE-HV),HSBL)
            ELSE
               CALL VRTSBN(SZ,MAX(0.0,HE-HV),HSBL)
            ENDIF
 
!           Calculate value of integral, VWRAP
            VWRAP = FSUBZ/UEFF
 
         ELSEIF ( UNSTAB ) THEN
            IF ( PPF.LT.1.0 ) THEN
!              Calculate the vertical term for the direct plume, FSUBZD
               IF ( ZR.LE.ZI ) THEN
!                 Calculation for Receptor below Zi      ---   CALL VRTCBL
                  CALL VRTCBL(HED1-HV,HED2-HV,SZD1,SZD2,1.0)
                  FSUBZD = FSUBZ
               ELSE
!                 Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
                  FSUBZD = 0.0
               ENDIF
 
!              Calculate the vertical term for the indirect plume, FSUBZN
               IF ( ZR.LE.ZI ) THEN
!                 Calculation for Receptor below Zi      ---   CALL VRTCBL
                  CALL VRTCBL(HEN1-HV,HEN2-HV,SZN1,SZN2,-1.0)
                  FSUBZN = FSUBZ
               ELSE
!                 Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
                  FSUBZN = 0.0
               ENDIF
            ELSE
               FSUBZD = 0.0
               FSUBZN = 0.0
 
            ENDIF
 
!           Note that UEFF and UEFF3 can never be zero, since they get
!           set to a minimum value earlier on.
 
            IF ( PPF.GT.0.0 ) THEN
!              Calculate the vertical term for the penetrated
!              plume, FSUBZ3                                ---   CALL VRTSBL
               IF ( ZR.LE.HPEN ) THEN
                  CALL VRTSBL(SZ3,MAX(0.0,HE3-HV),HPEN)
               ELSE
                  CALL VRTSBN(SZ3,MAX(0.0,HE3-HV),HPEN)
               ENDIF
               FSUBZ3 = FSUBZ
 
!              Calculate value of integral, VWRAP
               IF ( PPF.LT.1.0 ) THEN
                  VWRAP = (1.-PPF)*FSUBZD/UEFFD + (1.-PPF)              &
     &                    *FSUBZN/UEFFN + PPF*FSUBZ3/UEFF3
               ELSE
                  VWRAP = PPF*FSUBZ3/UEFF3
               ENDIF
 
            ELSE
               FSUBZ3 = 0.0
               HPEN = 0.0
 
!              Calculate value of integral, VWRAP
               VWRAP = FSUBZD/UEFFD + FSUBZN/UEFFN
 
            ENDIF
 
         ENDIF
      ENDIF
 
!---- Calculate the contribution due to terrain-following plume, VLIFT
      IF ( ZRT.EQ.0.0 ) THEN
!----    Effective receptor heights are equal, therefore VLIFT = VWRAP
         VLIFT = VWRAP
      ELSEIF ( FOPT.EQ.1.0 ) THEN
         VLIFT = 0.0
      ELSE
!        Assign receptor height for vertical term calculations
         ZR = ZRDEP
 
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!           Calculate the vertical term, FSUBZ              ---   CALL VRTSBL
!           With stable plume reflections and effective Zi
            IF ( ZR.LE.HSBL ) THEN
               CALL VRTSBL(SZ,MAX(0.0,HE-HV),HSBL)
            ELSE
               CALL VRTSBN(SZ,MAX(0.0,HE-HV),HSBL)
            ENDIF
 
!           Calculate value of integral, VLIFT
            VLIFT = FSUBZ/UEFF
 
         ELSEIF ( UNSTAB ) THEN
            IF ( PPF.LT.1.0 ) THEN
!              Calculate the vertical term for the direct plume, FSUBZD
               IF ( ZR.LE.ZI ) THEN
!                 Calculation for Receptor below Zi      ---   CALL VRTCBL
                  CALL VRTCBL(HED1-HV,HED2-HV,SZD1,SZD2,1.0)
                  FSUBZD = FSUBZ
               ELSE
!                 Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
                  FSUBZD = 0.0
               ENDIF
 
!              Calculate the vertical term for the indirect plume, FSUBZN
               IF ( ZR.LE.ZI ) THEN
!                 Calculation for Receptor below Zi      ---   CALL VRTCBL
                  CALL VRTCBL(HEN1-HV,HEN2-HV,SZN1,SZN2,-1.0)
                  FSUBZN = FSUBZ
               ELSE
!                 Set FSUBZ = 0.0 for "receptor height" (ZR) > ZI
                  FSUBZN = 0.0
               ENDIF
            ELSE
               FSUBZD = 0.0
               FSUBZN = 0.0
 
            ENDIF
 
!           Note that UEFF and UEFF3 can never be zero, since they get
!           set to a minimum value earlier on.
 
            IF ( PPF.GT.0.0 ) THEN
!              Calculate the vertical term for the penetrated
!              plume, FSUBZ3                                ---   CALL VRTSBL
               IF ( ZR.LE.HPEN ) THEN
                  CALL VRTSBL(SZ3,MAX(0.0,HE3-HV),HPEN)
               ELSE
                  CALL VRTSBN(SZ3,MAX(0.0,HE3-HV),HPEN)
               ENDIF
               FSUBZ3 = FSUBZ
 
!              Calculate value of integral, VLIFT
               IF ( PPF.LT.1.0 ) THEN
                  VLIFT = (1.-PPF)*FSUBZD/UEFFD + (1.-PPF)              &
     &                    *FSUBZN/UEFFN + PPF*FSUBZ3/UEFF3
               ELSE
                  VLIFT = PPF*FSUBZ3/UEFF3
               ENDIF
 
            ELSE
               FSUBZ3 = 0.0
               HPEN = 0.0
 
!              Calculate value of integral, VLIFT
               VLIFT = FSUBZD/UEFFD + FSUBZN/UEFFN
 
            ENDIF
 
         ENDIF
      ENDIF
 
!     Blend horizontal and terrain-responding components of integral
      F2INT = FOPT*VWRAP + (1.0-FOPT)*VLIFT
 
!     Reassign receptor elevation and height scales
      ZELEV = ZETMP
      ZHILL = ZHTMP
 
      CONTINUE
      END
!*==PRM_PDEP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRM_PDEP(XARG)
!***********************************************************************
!               PRM_PDEP Module of AERMOD Model
!
!        PURPOSE: Calculates Deposition Adjustment Factors from
!                 PRM_DEPLETE for PRIME component
!
!        PROGRAMMER: R. W. Brode, PES, Inc.
!
!        DATE:       September 29, 1994
!
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
      REAL :: XARG
 
!     Variable Initializations
      MODNAM = 'PRM_PDEP'
 
!     Loop over particle sizes
      DO I = 1 , NPD
         DQCOR(I) = 1.0
         WQCOR(I) = 1.0
         IF ( DDPLETE ) THEN
!           Determine factor for dry depletion
            VSETL = VGRAV(I)
            CALL PRM_DEPLETE(VDEP(I),XARG,ROMBERG,DQCOR(I))
         ENDIF
         IF ( WDPLETE .AND. PSCVRT(I).GT.0.0 ) THEN
!           Determine source depletion factor from wet removal
!           Simple Terrain Model
            WQCOR(I) = EXP(-PSCVRT(I)*XARG/US)
         ELSE
         ENDIF
      ENDDO
 
      CONTINUE
      END
!*==PRM_PDEPG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PRM_PDEPG(XARG)
!***********************************************************************
!               PRM_PDEPG Module of AERMOD Model
!
!        PURPOSE: Calculates Deposition Adjustment Factors from
!                 PRM_DEPLETE for PRIME component for gases
!
!        PROGRAMMER: R. W. Brode, MACTEC/PES, Inc.
!
!        DATE:       September 29, 2003
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: XARG
 
!     Variable Initializations
      MODNAM = 'PRM_PDEPG'
 
!     Initialize source depletion factors to unity.
      DQCORG = 1.0
      WQCORG = 1.0
!        Determine factor for dry depletion
      IF ( DDPLETE ) CALL PRM_DEPLETE(VDEPG,XARG,ROMBERG,DQCORG)
!        Determine source depletion factor
!        from wet removal (GASES)
!        Simple Terrain Model
      IF ( WDPLETE .AND. GSCVRT.GT.0.0 ) WQCORG = EXP(-GSCVRT*XARG/US)
 
      CONTINUE
      END
!*==PRM_DEPLETE.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!-----------------------------------------------------------------------
      SUBROUTINE PRM_DEPLETE(VDI,XRI,LROMB,QCOR)
!-----------------------------------------------------------------------
!
! --- PRM_DEPLETE Module of AERMOD
!
!
! PURPOSE:     Subroutine PRM_DEPLETE provides the value of the integral of
!              the vertical distribution function over the travel of the
!              plume from the source to the receptor for the PRIME downwash
!              component.  Integration is performed by 2-point gaussian
!              quadrature or Romberg integration method, depending on
!              logical argument, lromb.
!
! ARGUMENTS:
!    PASSED:   vdi      deposition velocity (m/s)              [r]
!              vsi      gravitational settling velocity (m/s)  [r]
!              xri      distance from source to receptor (m)   [r]
!              hmixi    mixing height (m)                      [r]
!              lromb    logical for use of Romberg integration [l]
!
!  RETURNED:   qcor     ratio of depleted emission rate to original  [r]
!
! CALLING ROUTINES:   PRM_PDEP, PRM_PDEPG
!
! EXTERNAL ROUTINES:  PRM_F2INT, QATR2, QG2D2
!-----------------------------------------------------------------------
 
!     Set up call to QATR2(xl,xu,eps,ndim2,fct,y,ier,num,aux2)
!     Declare parameter to fix the size of the aux2 array
      IMPLICIT NONE
 
      SAVE 
      LOGICAL LROMB
      REAL :: VDI , XRI , QCOR , EPS , VALUE
      EXTERNAL PRM_F2INT
!JRA F2INT must be given a type if it is a FUNCTION
!          spotted by NAG 5.0 compiler
      REAL PRM_F2INT
      INTEGER NUM , IER
      INTEGER , PARAMETER :: NDIM2 = 12
      REAL AUX2(NDIM2)
 
!     Evaluate integral, Use Romberg if LROMB=.T., otherwise use
!     two-point Gaussian Quadrature:
      IF ( LROMB ) THEN
!        Use ROMBERG Integration
         EPS = .05
         CALL QATR2(1.,XRI,EPS,NDIM2,PRM_F2INT,VALUE,IER,NUM,AUX2)
      ELSE
!        Use 2-point Gaussian Quadrature
         CALL QG2D2(1.,XRI,PRM_F2INT,VALUE)
      ENDIF
 
      IF ( VDI*VALUE.GT.50.0 ) THEN
!        Potential underflow, limit product to 50.0
         VALUE = 50.0/VDI
      ELSEIF ( VDI*VALUE.LT.-50.0 ) THEN
!        Potential overflow, limit product to 50.0
         VALUE = -50.0/VDI
      ENDIF
 
      QCOR = EXP(-VDI*VALUE)
 
      CONTINUE
      END
!*==PRM_F2INT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!-----------------------------------------------------------------------
      FUNCTION PRM_F2INT(XI)
!-----------------------------------------------------------------------
!
! --- PRM_F2INT Module of AERMOD
!              R.W. Brode, MACTEC/PES
!
! PURPOSE:     Function is the integrand of integral over the travel
!              distance to obtain the fraction of material removed from
!              the plume for the PRIME downwash component. Module MAIN1
!              is used to pass data that are constant during the
!              integration, so QATR (the integrator) only needs to
!              pass values of distance.
!
! ARGUMENTS:
!    PASSED:  xi         distance from source                        [r]
!
!  RETURNED:  PRM_f2int  value of integrand                          [r]
!
! CALLING ROUTINES:   QATR2, QG2D2
!
! EXTERNAL ROUTINES:
!
!-----------------------------------------------------------------------
      USE MAIN1
      IMPLICIT NONE
 
      REAL XI , VWRAP , VLIFT , PRM_F2INT , ZETMP , ZHTMP
      REAL :: DHPOUT , SYOUT , SZOUT , SYCAV , SZCAV
      LOGICAL L_INWAKE
 
      SAVE 
 
!     Set temporary receptor elevation and height scale
      ZETMP = ZELEV
      ZELEV = ZS + (ZETMP-ZS)*XI/X
 
      ZHTMP = ZHILL
      ZHILL = HS + (ZHTMP-HS)*XI/X
 
!     Calculate the plume rise                     ---   CALL PRMDELH
      CALL PRMDELH(XI,L_INWAKE)
 
!     Determine Effective Plume Height             ---   CALL PRMHEFF
      CALL PRMHEFF
 
! --- Calculate sigmas
      DHPOUT = DHP
      CALL WAKE_XSIG(XI,HS,DHPOUT,NOBID,SZOUT,SYOUT,SZCAV,SYCAV)
      SY = SYOUT
      SZ = SZOUT
 
!     Calculate Plume Tilt Due to Settling, HV
      HV = (XI/US)*VSETL
      HE = MAX(0.0,HE-HV)
 
!     Calculate FOPT = f(PHEE)                  ---   CALL FTERM
      FOPT = 0.5
 
!     Assign receptor height for vertical term calculations
      ZR = ZRT + ZRDEP
 
      IF ( STABLE ) THEN
         CALL VRTSBN(SZ,HE,HSBL)
      ELSEIF ( UNSTAB .AND. HE.LE.ZI ) THEN
         CALL VRTSBL(SZ,HE,ZI)
      ELSE
         FSUBZ = 0.0
      ENDIF
 
      VWRAP = FSUBZ/UEFF
 
!---- Calculate the contribution due to terrain-following plume, VLIFT
      IF ( ZRT.EQ.0.0 ) THEN
!----    Effective receptor heights are equal, therefore VLIFT = VWRAP
         VLIFT = VWRAP
      ELSEIF ( FOPT.EQ.1.0 ) THEN
         VLIFT = 0.0
      ELSE
!        Assign receptor height for vertical term calculations
         ZR = ZRDEP
         IF ( STABLE ) THEN
            CALL VRTSBN(SZ,HE,HSBL)
         ELSEIF ( UNSTAB .AND. HE.LE.ZI ) THEN
            CALL VRTSBL(SZ,HE,ZI)
         ELSE
            FSUBZ = 0.0
         ENDIF
         VLIFT = FSUBZ/UEFF
      ENDIF
 
!     Blend horizontal and terrain-responding components of integral
      PRM_F2INT = FOPT*VWRAP + (1.0-FOPT)*VLIFT
 
!     Reassign receptor elevation and height scales
      ZELEV = ZETMP
      ZHILL = ZHTMP
 
      CONTINUE
      END
!*==QATR2.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!-----------------------------------------------------------------------
      SUBROUTINE QATR2(XL,XU,EPS,NDIM,FCT,Y,IER,I,AUX)
!-----------------------------------------------------------------------
!
! --- ISCST2    Version: 1.0            Level: 930930           QATR2
!
! PURPOSE:      Integration routine adapted from the IBM SSP program
!               DQATR.  Modified for single precision.  This is a COPY
!               of QATR for use in double integrations.
!
! MODIFIED:     To use new convergence criteria, including a lower
!               threshold in the value of the integral (1.0E-10), and
!               to check for "delta-x" < 1.0 meters (delta-x = hh).
!               R. W. Brode, PES, Inc. - 9/30/94
!
! ARGUMENTS:
!    PASSED:    xl,xu   lower and upper limits of integration        [r]
!               eps     fractional error used to define convergence  [r]
!               ndim    dimension of array aux (parameter)           [p]
!               fct     external function (integrand)
!               aux     working array, passed to allow variable dim. [r]
!  RETURNED:    y       value of integral                            [r]
!               ier     status flag at terminatio                    [i]
!               i       number of subdivision steps                  [i]
!
! CALLING ROUTINES:     DEPLETE
!
! EXTERNAL ROUTINES:    none
!-----------------------------------------------------------------------
 
!  NOTES: status flags denote the following --
!               ier=0   value of integral converged to within eps
!               ier=1   value of integral is diverging
!               ier=2   value of integral did not converge to within
!                       eps before ndim limit was reached
 
!  NDIM Note:  The aux(ndim) array keeps track of the average value of
!              the integrand for each of the steps in subdividing the
!              interval.  For example, when i=4 in the "do 7 i=2,ndim"
!              loop, aux(4) contains the mean value as obtained from
!              the trapezoidal rule, while aux(1 through 3) contain
!              a set of current Romberg extrapolations.  At each new
!              value of i, the interval is subdivided again, and the
!              integrand is evaluated at jj=2**(i-2) new points.
!              Therefore, at i=5, there will be jj=8 new points added
!              to the 9 points already used in the interval.  When i=17
!              there will be jj=32,768 new points added to the 32,769
!              already used.  This is the maximum number of new points
!              that are allowed as jj is an INTEGER*2 variable, with
!              a maximum value of 2**15.  Therefore, i should not exceed
!              17, and probably should be no larger than 16.  This means
!              that NDIM should be set at 16.  Larger values of NDIM
!              could be accepted if the INTEGER*2 variables were changed
!              to INTEGER*4, but for most applications, 30000 to 60000
!              points ought to be sufficient for evaluating an integral.
 
      IMPLICIT NONE
 
      INTEGER :: NDIM , IER
      REAL :: Y , EPS , XU , XL , AUX(NDIM) , HALF , FCT , H , HH ,     &
     &        DELT2 , P , DELT1 , HD , X , SM , Q
      EXTERNAL FCT
      INTEGER I , II , JI , J , JJ
      HALF = 0.5
 
!     Preparations for Romberg loop
      AUX(1) = HALF*(FCT(XL)+FCT(XU))
      H = XU - XL
 
      IF ( H.EQ.0.0 .OR. AUX(1).EQ.0.0 ) THEN
         IER = 0
         Y = 0.0
         RETURN
      ENDIF
 
      HH = H
      DELT2 = 0.
      P = 1.
      JJ = 1
 
      DO I = 2 , NDIM
         Y = AUX(1)
         DELT1 = DELT2
         HD = HH
         HH = HALF*HH
         P = HALF*P
         X = XL + HH
         SM = 0.
 
         DO J = 1 , JJ
            SM = SM + FCT(X)
            X = X + HD
         ENDDO
 
!  A new approximation to the integral is computed by means
!  of the trapezoidal rule
         AUX(I) = HALF*AUX(I-1) + P*SM
 
!  Start of Rombergs extrapolation method
 
         Q = 1.
         JI = I - 1
         DO J = 1 , JI
            II = I - J
            Q = Q + Q
            Q = Q + Q
            AUX(II) = AUX(II+1) + (AUX(II+1)-AUX(II))/(Q-1.)
         ENDDO
 
!  End of Romberg step
 
         DELT2 = ABS(Y-AUX(1))
 
         IF ( I.GE.3 ) THEN
!  Modification for cases in which function = 0 over interval
!rwb        add lower threshold convergence test
            IF ( AUX(1).LT.1.0E-10 ) THEN
               IER = 0
               Y = H*AUX(1)
               RETURN
            ELSEIF ( DELT2.LE.EPS*ABS(AUX(1)) ) THEN
               IER = 0
               Y = H*AUX(1)
               RETURN
!rwb        add lower limit on "delta-x" of 1.0m
            ELSEIF ( HH.LT.1.0 ) THEN
               IER = 0
               Y = H*AUX(1)
               RETURN
!           elseif (delt2 .GE. delt1)then
!              ier=1
!              y=h*y
!              return
            ENDIF
         ENDIF
         JJ = JJ + JJ
      ENDDO
 
      IER = 2
      Y = H*AUX(1)
 
      CONTINUE
      END
!*==QG2D2.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
 
!
!     ..................................................................
!
!        SUBROUTINE QG2D2
!
!        PURPOSE
!           TO COMPUTE INTEGRAL(FCT(X), SUMMED OVER X FROM XL TO XU)
!
!        USAGE
!           CALL QG2 (XL,XU,FCT,Y)
!           PARAMETER FCT REQUIRES AN EXTERNAL STATEMENT
!
!        DESCRIPTION OF PARAMETERS
!           XL     - THE LOWER BOUND OF THE INTERVAL.
!           XU     - THE UPPER BOUND OF THE INTERVAL.
!           FCT    - THE NAME OF AN EXTERNAL FUNCTION SUBPROGRAM USED.
!           Y      - THE RESULTING INTEGRAL VALUE.
!
!        REMARKS
!           NONE
!
!        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
!           THE EXTERNAL FUNCTION SUBPROGRAM FCT(X) MUST BE FURNISHED
!           BY THE USER.
!
!        METHOD
!           EVALUATION IS DONE BY MEANS OF 2-POINT GAUSS QUADRATURE
!           FORMULA, WHICH INTEGRATES POLYNOMIALS UP TO DEGREE 3
!           EXACTLY.
!           FOR REFERENCE, SEE
!           V.I.KRYLOV, APPROXIMATE CALCULATION OF INTEGRALS,
!           MACMILLAN, NEW YORK/LONDON, 1962, PP.100-111 AND 337-338.
!
!     ..................................................................
!
      SUBROUTINE QG2D2(XL,XU,FCT,Y)
!
!
      IMPLICIT NONE
 
      REAL :: A , B , Y , XL , XU , FCT
      EXTERNAL FCT
 
      A = .5*(XU+XL)
      B = XU - XL
      Y = .2886751*B
      Y = .5*B*(FCT(A+Y)+FCT(A-Y))
 
      CONTINUE
      END
!*==OLM_CALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OLM_CALC
!***********************************************************************
!             OLM_CALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Hourly Results for OLM Option
!
!        PROGRAMMER: Roger W. Brode, PES, Inc.
!
!        DATE:    May 6, 2002
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: OLMVAL(NUMOLM,NUMTYP) , NO2VAL(NUMOLM) , NO_VAL(NUMOLM)
      REAL :: NO2 , NO , OLMTEMP , PERCENTNO2
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'OLM_CALC'
      NO2 = 0.0
      NO = 0.0
      OLMTEMP = 0.0
      PERCENTNO2 = 0.0
      DO IOLM = 1 , NUMOLM
         NO2VAL(IOLM) = 0.0
         NO_VAL(IOLM) = 0.0
         DO ITYP = 1 , NUMTYP
            OLMVAL(IOLM,ITYP) = 0.0
         ENDDO
      ENDDO
 
!     Begin Receptor LOOP
      RECEPTOR_LOOP:DO IREC = 1 , NUMREC
         SOURCE_LOOP:DO ISRC = 1 , NUMSRC
            IF ( .NOT.L_OLMGRP(ISRC) ) THEN
!              Source is not in an OLMGROUP; apply NO2_RATIO to CONC (ITYP=1)
               NO2 = ANO2_RATIO(ISRC)*CHI(IREC,ISRC,1)
               NO = (1.-ANO2_RATIO(ISRC))*CHI(IREC,ISRC,1)*(30./46.)
 
!              Determine if O3 limited. If not, then no conversion needed.
               IF ( (O3CONC/48.0).LT.(NO/30.0) ) THEN
                  HRVAL(1) = NO2 + (O3CONC*(46.0/48.0))
               ELSE
                  HRVAL(1) = CHI(IREC,ISRC,1)
               ENDIF
 
!              Calculate an equivalent Percent NO2 for CONC
               PERCENTNO2 = HRVAL(1)/CHI(IREC,ISRC,1)
 
!              Apply equivalent PercentNO2 to other ITYPs (DDEP, WDEP or DEPOS)
               DO ITYP = 2 , NUMTYP
                  HRVAL(ITYP) = PERCENTNO2*CHI(IREC,ISRC,ITYP)
               ENDDO
 
!              Sum HRVAL to AVEVAL and ANNVAL Arrays  ---   CALL SUMVAL
               IF ( EVONLY ) THEN
                  CALL EV_SUMVAL
               ELSE
                  CALL SUMVAL
               ENDIF
!                 Check ARC centerline values for EVALFILE
!                 output                              ---   CALL EVALCK
               IF ( EVAL(ISRC) ) CALL EVALCK
               GOTO 50
            ELSE
               DO IOLM = 1 , NUMOLM
                  IF ( IGRP_OLM(ISRC,IOLM).EQ.1 ) THEN
!                    Calculate NO2 and NO CONV Values for OLMGROUP
                     NO2VAL(IOLM) = NO2VAL(IOLM) + ANO2_RATIO(ISRC)     &
     &                              *CHI(IREC,ISRC,1)
                     NO_VAL(IOLM) = NO_VAL(IOLM) + (1.-ANO2_RATIO(ISRC))&
     &                              *CHI(IREC,ISRC,1)*(30./46.)
 
                     DO ITYP = 1 , NUMTYP
!                       Calculate Hourly Values (Full Conversion) for OLMGROUP
                        OLMVAL(IOLM,ITYP) = OLMVAL(IOLM,ITYP)           &
     &                     + CHI(IREC,ISRC,ITYP)
                     ENDDO
!                    Exit the OLMGROUP Loop
                     GOTO 50
                  ENDIF
               ENDDO
            ENDIF
 50      ENDDO SOURCE_LOOP
 
         DO IOLM = 1 , NUMOLM
 
!           Determine if combined plume is O3 limited, and assign
!           PercentNO2 to OLMGroup for CONC (ITYP=1)
            IF ( (O3CONC/48.0).LT.((NO_VAL(IOLM))/30.0) ) THEN
               OLMTEMP = NO2VAL(IOLM) + (O3CONC*(46.0/48.0))
               PERCENTNO2 = OLMTEMP/OLMVAL(IOLM,1)
            ELSE
               PERCENTNO2 = 1.0
            ENDIF
 
!           Apply PercentNO2 of OLMGroup to Individual Sources
            DO ISRC = 1 , NUMSRC
               IF ( IGRP_OLM(ISRC,IOLM).EQ.1 ) THEN
                  DO ITYP = 1 , NUMTYP
                     HRVAL(ITYP) = PERCENTNO2*CHI(IREC,ISRC,ITYP)
                  ENDDO
!                 Sum HRVAL to AVEVAL and ANNVAL Arrays  ---   CALL SUMVAL
                  IF ( EVONLY ) THEN
                     CALL EV_SUMVAL
                  ELSE
                     CALL SUMVAL
                  ENDIF
!                    Check ARC centerline values for EVALFILE
!                    output                              ---   CALL EVALCK
                  IF ( EVAL(ISRC) ) CALL EVALCK
               ENDIF
            ENDDO
 
         ENDDO
 
!        Initialize __VAL arrays
         DO ITYP = 1 , NUMTYP
            HRVAL(ITYP) = 0.0
            HRVALD(ITYP) = 0.0
            AERVAL(ITYP) = 0.0
            AERVALD(ITYP) = 0.0
         ENDDO
 
      ENDDO RECEPTOR_LOOP
!     End Receptor LOOP
 
      CONTINUE
      END
!*==PVMRM_CALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PVMRM_CALC
!***********************************************************************
!             PVMRM_CALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Hourly Results for PVMRM Option
!
!        PROGRAMMER: Roger W. Brode, MACTEC, Inc. (f/k/a PES, Inc.)
!
!        DATE:    May 12, 2004
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      CHARACTER LEADIN*25
      REAL , PARAMETER :: EPS = 0.01
      REAL :: MAXCHI(NUMREC,NUMTYP) , MAXCONC , CWDIST , CWMAX , CWMIN
      REAL :: DWDIST , DWMAX , DWMIN , CWDELT , DWDELT
      REAL :: HMNH , HMXH , HMNT , HMXT , HMNH3 , HMXH3 , HMNT3 ,       &
     &        HMXT3 , BVERT , BVERT3 , BLONG , BHORIZ , VOLDOM ,        &
     &        VOLSUM , QSUM , XDOM , YDOM , DISTDOM , UDOM , VOLDOM3 ,  &
     &        VOLSUM3 , FDOM
      REAL :: DOMO3MOLES , SUMO3MOLES , DOMNOXMOLES , SUMNOXMOLES ,     &
     &        DOMCONVERTED , SUMCONVERTED , PERCENTNO2
      REAL :: AVE_NO2RATIO , SUM_NO2RAT , QAREA
      REAL :: ZCORR , PCORR , TCORR , PTZ , TAP
      REAL :: XDEP , WIDTH , LENGTH , XMAXR
      INTEGER :: DOMIDX(NUMREC,NUMTYP) , IDOM , NDXBLZ , NUMCONT
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PVMRM_CALC'
 
!     Determine maximum values and corresponding index by receptor
      MAXCHI = MAXVAL(CHI,DIM=2)
      DOMIDX = MAXLOC(CHI,DIM=2)
 
!     Begin Receptor LOOP
      RECEPTOR_LOOP:DO IREC = 1 , NUMREC
 
!        Get max concentration and index for dominant source for this receptor
         MAXCONC = MAXCHI(IREC,1)
         IF ( MAXCONC.EQ.0.0 ) GOTO 100
 
!        Set index for dominant source, IDOM
         IDOM = DOMIDX(IREC,1)
         UDOM = UEFFS(IREC,IDOM)
         FDOM = FOPTS(IREC,IDOM)
 
!        Determine extent of major contributing sources
         HMNT = 1.0E10
         HMXT = 0.0
         HMNH = 1.0E10
         HMXH = 0.0
         HMNT3 = 1.0E10
         HMXT3 = 0.0
         HMNH3 = 1.0E10
         HMXH3 = 0.0
         CWMIN = 1.0E20
         CWMAX = -1.0E20
         DWMIN = 1.0E20
         DWMAX = -1.0E20
 
         NUMCONT = 0
!        Loop through sources to obtain major contributing sources
         DO ISRC = 1 , NUMSRC
            IF ( CHI(IREC,ISRC,1).GE.0.5*MAXCONC ) THEN
               NUMCONT = NUMCONT + 1
               IF ( SRCTYP(ISRC)(1:4).EQ.'AREA' ) THEN
                  CALL SETSRC
                  CALL ARDIST(IREC,XDEP,WIDTH,LENGTH,XMAXR)
!                 Store max and min values of crosswind and downwind distances
                  CWMAX = MAX(CWMAX,Y+0.5*WIDTH)
                  CWMIN = MIN(CWMIN,Y-0.5*WIDTH)
                  DWMAX = MAX(DWMAX,X+0.5*LENGTH)
                  DWMIN = MIN(DWMIN,X-0.5*LENGTH)
               ELSE
!                 Calculate crosswind distance from source to receptor
                  CWDIST = (AXR(IREC)-AXS(ISRC))                        &
     &                     *WDCOS - (AYR(IREC)-AYS(ISRC))*WDSIN
!                 Calculate downwind distance from source to receptor
                  DWDIST = -((AXR(IREC)-AXS(ISRC))*WDSIN+(AYR(IREC)-AYS(&
     &                     ISRC))*WDCOS)
!                 Store max and min values of crosswind and downwind distances
                  CWMAX = MAX(CWMAX,CWDIST)
                  CWMIN = MIN(CWMIN,CWDIST)
                  DWMAX = MAX(DWMAX,DWDIST)
                  DWMIN = MIN(DWMIN,DWDIST)
               ENDIF
!              Assign receptor height above stack base for dominant source
               ZRT = AZELEV(IREC) - AZS(ISRC) + AZFLAG(IREC)
!              Check plume height ranges for horizontal and terrain responding
               IF ( HECNTR(IREC,ISRC).LT.HMNT ) HMNT = HECNTR(IREC,ISRC)
               IF ( HECNTR(IREC,ISRC).GT.HMXT ) HMXT = HECNTR(IREC,ISRC)
               IF ( HECNTR(IREC,ISRC)-ZRT.LT.HMNH )                     &
     &              HMNH = HECNTR(IREC,ISRC) - ZRT
               IF ( HECNTR(IREC,ISRC)-ZRT.GT.HMXH )                     &
     &              HMXH = HECNTR(IREC,ISRC) - ZRT
               IF ( PPFACT(ISRC).GT.0.0 ) THEN
                  IF ( HECNTR3(IREC,ISRC).LT.HMNT3 )                    &
     &                 HMNT3 = HECNTR3(IREC,ISRC)
                  IF ( HECNTR3(IREC,ISRC).GT.HMXT3 )                    &
     &                 HMXT3 = HECNTR3(IREC,ISRC)
                  IF ( HECNTR3(IREC,ISRC)-ZRT.LT.HMNH3 )                &
     &                 HMNH3 = HECNTR3(IREC,ISRC) - ZRT
                  IF ( HECNTR3(IREC,ISRC)-ZRT.GT.HMXH3 )                &
     &                 HMXH3 = HECNTR3(IREC,ISRC) - ZRT
               ENDIF
            ENDIF
         ENDDO
 
!        Set vertical dimensions of "box" for major cont. sources.
!        Use terrain weighting factor for dominant source (FDOM) to
!        combine heights for horizontal and terrain responding plumes.
         BVERT = FDOM*(HMXH-HMNH) + (1.-FDOM)*(HMXT-HMNT)
         IF ( UNSTAB .AND. PPFACT(IDOM).GT.0.0 ) THEN
            BVERT3 = FDOM*(HMXH3-HMNH3) + (1.-FDOM)*(HMXT3-HMNT3)
         ELSE
            BVERT3 = 0.0
         ENDIF
 
!        Set horizontal dimensions of "box" for major cont. sources.
         IF ( CWMAX.GT.CWMIN ) THEN
            BHORIZ = CWMAX - CWMIN
         ELSE
            BHORIZ = 0.0
         ENDIF
 
!        Calculate Distance from Dominant Source
         IF ( SRCTYP(IDOM)(1:4).EQ.'AREA' ) THEN
            ISRC = IDOM
            CALL SETSRC
            CALL ARDIST(IREC,XDEP,WIDTH,LENGTH,XMAXR)
!           Assign downwind distance based on most upwind vertex of area source
            XDOM = X
            YDOM = Y
            DISTDOM = XMAXR
!           Calculate volume of dominant plume, passing WIDTH for BHORIZ
            CALL PLUME_VOL(DISTDOM,IDOM,0.0,0.0,WIDTH,VOLDOM)
         ELSE
            XDOM = -((AXR(IREC)-AXS(IDOM))*WDSIN+(AYR(IREC)-AYS(IDOM))  &
     &             *WDCOS)
            YDOM = (AXR(IREC)-AXS(IDOM))*WDCOS - (AYR(IREC)-AYS(IDOM))  &
     &             *WDSIN
            DISTDOM = SQRT(XDOM*XDOM+YDOM*YDOM)
!           Calculate volume of dominant plume
            CALL PLUME_VOL(DISTDOM,IDOM,0.0,0.0,0.0,VOLDOM)
         ENDIF
 
         IF ( BVERT.GT.0.0 .OR. BHORIZ.GT.0.0 ) THEN
!           Calculate volume of dominant plus major contributing sources
            CALL PLUME_VOL(DISTDOM,IDOM,BVERT,BVERT3,BHORIZ,VOLSUM)
         ELSE
            VOLSUM = VOLDOM
         ENDIF
 
!        Correct plume volume to conditions of standard temperature
!        and pressure (Hanrahan, 1999)
!        0.028966 is the average kg/mole of air
 
!        First obtain a height to use in the correction
         ZCORR = AZS(IDOM) + HECNTR(IREC,IDOM)
 
!        Calculate ambient temperature at plume height from pot. temp. profile
         CALL LOCATE(GRIDHT,1,MXGLVL,ZCORR,NDXBLZ)
         IF ( NDXBLZ.GE.1 ) THEN
!----       Potential temperature
            CALL GINTRP(GRIDHT(NDXBLZ),GRIDPT(NDXBLZ),GRIDHT(NDXBLZ+1), &
     &                  GRIDPT(NDXBLZ+1),ZCORR,PTZ)
         ELSE
!           Use GRID value for lowest level
            PTZ = GRIDPT(1)
         ENDIF
         TAP = PTZ - GOVRCP*ZCORR
 
         PCORR = EXP(-G*0.028966*ZCORR/(RGAS*TAP))
         TCORR = 273.15/TAP
 
         VOLDOM = VOLDOM*PCORR*TCORR
         VOLSUM = VOLSUM*PCORR*TCORR
 
!        get moles of ozone in dominant plume
!        O3 expressed in ug/m3
         DOMO3MOLES = VOLDOM*O3CONC/(10**6*48.)    ! O3 is ug/m3
 
!        get moles of ozone in the combined plume
         SUMO3MOLES = VOLSUM*O3CONC/(10**6*48.)    ! O3 is ug/m3
 
!        get moles of NOx in the dominant plume
!        Use molecular weight of NO2 (46) since emission calcs are based on NO2
         IF ( SRCTYP(IDOM).EQ.'AREA' .OR. SRCTYP(IDOM).EQ.'AREAPOLY' )  &
     &        THEN
            ISRC = IDOM
            CALL SETSRC
            DOMNOXMOLES = AQS(IDOM)*XINIT*YINIT*DISTDOM/(UDOM*46.)
         ELSEIF ( SRCTYP(IDOM).EQ.'AREACIRC' ) THEN
            ISRC = IDOM
            CALL SETSRC
            DOMNOXMOLES = AQS(IDOM)*PI*RADIUS(IDOM)*RADIUS(IDOM)        &
     &                    *DISTDOM/(UDOM*46.)
         ELSE
            DOMNOXMOLES = AQS(IDOM)*DISTDOM/(UDOM*46.)
         ENDIF
 
!        get moles of NOx in the merged plume
!        Sum emissions for sources within projected width of major
!        contributing sources
!        Assign small delta values for extent of box containing major
!        contributing sources to ensure inclusion of sources on the edge
         CWDELT = MAX(0.1,EPS*(CWMAX-CWMIN))
         DWDELT = MAX(0.1,EPS*(DWMAX-DWMIN))
         QSUM = 0.0
         SUM_NO2RAT = 0.0
         DO ISRC = 1 , NUMSRC
            IF ( SRCTYP(ISRC)(1:4).EQ.'AREA' ) THEN
               CALL SETSRC
               CALL ARDIST(IREC,XDEP,WIDTH,LENGTH,XMAXR)
!              Assign CWDIST and DWDIST to Y and X based on distance from
!              center of area source to receptor.  If center of area source
!              is within "box" of major contributing sources, then include
!              it's emissions in calculation of NOx moles.
               CWDIST = Y
               DWDIST = X
            ELSE
!              Calculate crosswind distance from source to receptor
               CWDIST = (AXR(IREC)-AXS(ISRC))                           &
     &                  *WDCOS - (AYR(IREC)-AYS(ISRC))*WDSIN
!              Calculate downwind distance from source to receptor
               DWDIST = -                                               &
     &                  ((AXR(IREC)-AXS(ISRC))*WDSIN+(AYR(IREC)-AYS(ISRC&
     &                  ))*WDCOS)
            ENDIF
!           Check for crosswind disance between MIN and MAX of projected width
            IF ( CWDIST.GE.CWMIN-CWDELT .AND. CWDIST.LE.CWMAX+CWDELT )  &
     &           THEN
               IF ( DWDIST.GE.DWMIN-DWDELT .AND. DWDIST.LE.DWMAX+       &
     &              DWDELT ) THEN
                  IF ( SRCTYP(ISRC).EQ.'AREA' .OR. SRCTYP(ISRC)         &
     &                 .EQ.'AREAPOLY' ) THEN
                     QAREA = AQS(ISRC)*XINIT*YINIT
                     QSUM = QSUM + QAREA
                     SUM_NO2RAT = SUM_NO2RAT + ANO2_RATIO(ISRC)*QAREA
                  ELSEIF ( SRCTYP(ISRC).EQ.'AREACIRC' ) THEN
                     QAREA = AQS(ISRC)*PI*RADIUS(ISRC)*RADIUS(ISRC)
                     QSUM = QSUM + QAREA
                     SUM_NO2RAT = SUM_NO2RAT + ANO2_RATIO(ISRC)*QAREA
                  ELSE
                     QSUM = QSUM + AQS(ISRC)
                     SUM_NO2RAT = SUM_NO2RAT + ANO2_RATIO(ISRC)         &
     &                            *AQS(ISRC)
                  ENDIF
               ENDIF
            ENDIF
         ENDDO
 
!TMP     Check for QSUM = 0.0 error (i.e., dominant source not inc. in sum)
!TMP     This condition should never be encountered
         IF ( QSUM.EQ.0.0 ) THEN
            WRITE (IOUNIT,*)                                            &
     &                    'Error in PVMRM_CALC; QSUM = 0.0. Aborting!!!'
            WRITE (*,*) 'Error in PVMRM_CALC; QSUM = 0.0. Aborting!!!'
            STOP
         ENDIF
 
!        Calculate NOx moles for combined plume, and average in-stack ratio
!        Use molecular weight of NO2 (46) since emission calcs are based on NO2
         SUMNOXMOLES = QSUM*DISTDOM/(UDOM*46.)
         AVE_NO2RATIO = SUM_NO2RAT/QSUM
 
!        Calculate NOx conversion ratios for dominant plume and combined plume
         DOMCONVERTED = DOMO3MOLES/(DOMNOXMOLES)
         SUMCONVERTED = SUMO3MOLES/(SUMNOXMOLES)
 
!
!        Find which is more important -- the dominant plume or the combined plume
!        Minimum used as the most controlling plumes will have the least conversion
         IF ( DOMCONVERTED.LT.SUMCONVERTED ) THEN
            PERCENTNO2 = DOMCONVERTED + ANO2_RATIO(IDOM)
         ELSE
            PERCENTNO2 = SUMCONVERTED + AVE_NO2RATIO
         ENDIF
 
!        Limit to equilibrium concentration of NO2 (default set at 90 percent)
         IF ( PERCENTNO2.GT.NO2EQUIL ) PERCENTNO2 = NO2EQUIL
 
!        Write data to PVMRM.TXT debugging file
         IF ( DEBUG .AND. DOMCONVERTED.LT.SUMCONVERTED ) THEN
            WRITE (50,9987) KURDAT , IREC , SRCID(IDOM) , DISTDOM ,     &
     &                      MAXCONC , NUMCONT , O3CONC , DOMO3MOLES ,   &
     &                      DOMNOXMOLES , BHORIZ , BVERT , VOLDOM ,     &
     &                      PERCENTNO2
 9987       FORMAT (1x,'DOM: ',i8,i5,1x,a8,2F11.4,1x,i4,1x,f10.3,       &
     &              2(1x,f12.3),2(1x,f10.3),1x,e12.4,1x,f8.3)
         ELSEIF ( DEBUG ) THEN
            WRITE (50,9988) KURDAT , IREC , SRCID(IDOM) , DISTDOM ,     &
     &                      MAXCONC , NUMCONT , O3CONC , SUMO3MOLES ,   &
     &                      SUMNOXMOLES , BHORIZ , BVERT , VOLSUM ,     &
     &                      PERCENTNO2
 9988       FORMAT (1x,'SUM: ',i8,i5,1x,a8,2F11.4,1x,i4,1x,f10.3,       &
     &              2(1x,f12.3),2(1x,f10.3),1x,e12.4,1x,f8.3)
         ENDIF
 
!        Update HRVAL, AVEVAL and ANNVAL Arrays
         DO ISRC = 1 , NUMSRC
            DO ITYP = 1 , NUMTYP
               HRVAL(ITYP) = CHI(IREC,ISRC,ITYP)*PERCENTNO2
!              Sum HRVAL to AVEVAL and ANNVAL Arrays  ---   CALL SUMVAL
            ENDDO
            IF ( EVONLY ) THEN
               CALL EV_SUMVAL
            ELSE
               CALL SUMVAL
            ENDIF
!              Check ARC centerline values for EVALFILE
!              output                              ---   CALL EVALCK
            IF ( EVAL(ISRC) ) CALL EVALCK
         ENDDO
 
!        Initialize __VAL arrays
         DO ITYP = 1 , NUMTYP
            HRVAL(ITYP) = 0.0
            HRVALD(ITYP) = 0.0
            AERVAL(ITYP) = 0.0
            AERVALD(ITYP) = 0.0
         ENDDO
 
 100  ENDDO RECEPTOR_LOOP
!     End Receptor LOOP
 
      CONTINUE
      END
!*==PLUME_VOL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PLUME_VOL(XARG,ISDX,BVARG,BVARG3,BHARG,VOLOUT)
!***********************************************************************
!             PLUME_VOL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates plume volume for PVMRM option
!
!        PROGRAMMER: Roger W. Brode, PES, Inc.
!
!        DATE:    May 6, 2002
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:   PVMRM_CALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER , PARAMETER :: NTAB = 79
      REAL , PARAMETER :: NSUBZ = 4.00 , SRMIN = 5.0
      REAL :: XARG , BVARG , BVARG3 , BHARG , VERT , VOLOUT , SUM , SUM3
      REAL :: XTABLE(NTAB) , SR(NTAB) , SR3(NTAB) , SIGR , SIGR3
      REAL :: XTAB , DELTAX , BVTMP , SIGRZTMP
      INTEGER :: I , ISDX
      INTEGER :: KITER , NDXHE , NDXZMID , NDXZPL , NDXHE3
      INTEGER :: IPOSITN , NDXBH , N1 , N2 , N , IS
      REAL :: HSPRIM , ZPLM , DHFOLD , SVPM , UPM , TGPM , PTPM , PTP , &
     &        ZMID
 
      SAVE 
 
!     Variable Initializations
      DATA XTABLE/10. , 20. , 30. , 40. , 50. , 60. , 70. , 80. , 90. , &
     &     100. , 110. , 120. , 130. , 140. , 150. , 160. , 170. ,      &
     &     180. , 190. , 200. , 210. , 220. , 230. , 240. , 250. ,      &
     &     260. , 300. , 400. , 500. , 600. , 700. , 800. , 900. ,      &
     &     1000. , 1100. , 1200. , 1300. , 1400. , 1500. , 1600. ,      &
     &     1700. , 1800. , 1900. , 2000. , 2100. , 2200. , 2300. ,      &
     &     2400. , 2500. , 2600. , 2700. , 2800. , 2900. , 3000. ,      &
     &     3100. , 3300. , 3500. , 3700. , 4000. , 5000. , 5500. ,      &
     &     7000. , 8000. , 9000. , 10000. , 12000. , 14000. , 16000. ,  &
     &     18000. , 20000. , 23000. , 25000. , 27500. , 30000. ,        &
     &     35000. , 40000. , 45000. , 50000. , 500000./
      DATA SR/NTAB*0.0/ , SR3/NTAB*0.0/
 
      MODNAM = 'PLUME_VOL'
 
!     Assign source index to global variable
      ISRC = ISDX
      SUM = 0.0
      SUM3 = 0.0
 
!     Set Mixing Height and Profiles for Urban Option if Needed
      IF ( STABLE .AND. URBAN ) THEN
         IF ( URBSRC(ISRC).EQ.'Y' ) THEN
            URBSTAB = .TRUE.
            ZI = AMAX1(ZIURB,ZIMECH)
            GRIDSV = GRDSVU
            GRIDSW = GRDSWU
            GRIDTG = GRDTGU
            GRIDPT = GRDPTU
         ELSEIF ( URBSRC(ISRC).EQ.'N' ) THEN
            URBSTAB = .FALSE.
            ZI = ZIRUR
            GRIDSV = GRDSVR
            GRIDSW = GRDSWR
            GRIDTG = GRDTGR
            GRIDPT = GRDPTR
         ENDIF
      ELSE
         URBSTAB = .FALSE.
      ENDIF
 
!     Set the Source Variables for This Source              ---   CALL SETSRC
      CALL SETSRC
 
!     Set Deposition Variables for this Source
!        Calculate Deposition Velocities for this Source    ---   CALL VDP
      IF ( LDPART .OR. LWPART .OR. LDGAS ) CALL VDP
 
!     Calculate Scavenging Ratios for this Source           ---   CALL SCAVRAT
      IF ( LWPART .OR. LWGAS ) CALL SCAVRAT
 
!     Calculate the initial meteorological variables     ---   CALL METINI
      CALL METINI
 
      IF ( SRCTYP(ISRC).EQ.'VOLUME' .OR. SRCTYP(ISRC)(1:4).EQ.'AREA' )  &
     &     THEN
         FB = 0.0
         FM = 0.0
         PPF = 0.0
         HSP = HS
         DHP = 0.0
         DHP1 = 0.0
         DHP2 = 0.0
         DHP3 = 0.0
         DHCRIT = 0.0
         XFINAL = 0.0
         XMIXED = ZI*UAVG/SWAVG
         IF ( XMIXED.LT.XFINAL ) XMIXED = XFINAL
         ZMIDMX = 0.5*ZI
 
      ELSEIF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
!        Calculate Buoyancy and Momentum Fluxes             ---   CALL FLUXES
         CALL FLUXES
 
!        Set Wake and Building Type Switches                ---   CALL WAKFLG
! ---    NOTE:  WAKFLG sets building dimensions based on wind
!        direction at stack top.
         WAKE = .FALSE.
 
!        Define temporary values of CENTER and SURFAC based on HS
         CENTER = HS
         IF ( CENTER.LT.0.1*ZI ) THEN
            SURFAC = .TRUE.
         ELSE
            SURFAC = .FALSE.
         ENDIF
 
!        Check for stack-tip downwash option and adjust if necessary
         IF ( NOSTD ) THEN
!           No stack-tip downwash, no adjustments necessary
            HSP = HS
         ELSE
!           Make adjustments for stack-tip downwash
            HSP = HSPRIM(US,VS,HS,DS)
         ENDIF
 
!        Calculate Distance to Final Rise                   ---   CALL DISTF
         CALL DISTF
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6000) DHFAER , UP , TGS
 6000       FORMAT (/,5X,'INITIAL PLUME RISE ESTIMATE:  DELH = ',F6.1,  &
     &              ' M; Uplume = ',F5.2,' M/S; DTHDZ = ',F7.4,         &
     &              ' DEG K/M')
         ENDIF
 
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!           Use iterative approach to stable plume rise calculations
            KITER = 0
 50         ZPLM = HSP + 0.5*DHFAER
            DHFOLD = DHFAER
 
!----       Locate index below ZPLM
 
            CALL LOCATE(GRIDHT,1,MXGLVL,ZPLM,NDXZPL)
 
!----       Get Wind speed at ZPLM; replace UP.  Also, replace TGP,
!           vertical potential temperature gradient, if stable.
 
            CALL GINTRP(GRIDHT(NDXZPL),GRIDSV(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDSV(NDXZPL+1),ZPLM,SVPM)
            CALL GINTRP(GRIDHT(NDXZPL),GRIDWS(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDWS(NDXZPL+1),ZPLM,UPM)
            SVPM = AMAX1(SVPM,SVMIN,0.05*UPM)
            UPM = SQRT(UPM*UPM+2.*SVPM*SVPM)
!RWB        Use average of stack top and midpoint wind speeds.
            UP = 0.5*(US+UPM)
 
            CALL GINTRP(GRIDHT(NDXZPL),GRIDTG(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDTG(NDXZPL+1),ZPLM,TGPM)
            CALL GINTRP(GRIDHT(NDXZPL),GRIDPT(NDXZPL),GRIDHT(NDXZPL+1), &
     &                  GRIDPT(NDXZPL+1),ZPLM,PTPM)
!RWB        Use average of stack top and midpoint temperature gradients.
            TGP = 0.5*(TGS+TGPM)
            PTP = 0.5*(PTS+PTPM)
            BVF = SQRT(G*TGP/PTP)
            IF ( BVF.LT.1.0E-10 ) BVF = 1.0E-10
            BVPRIM = 0.7*BVF
 
            CALL DISTF
 
            KITER = KITER + 1
 
!RJP        Add temporary debugging statements
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6001) KITER , DHFOLD , DHFAER , ZPLM , UP ,&
     &                             TGP
 6001          FORMAT (/,5X,'OPTH2 ITER. #',I1,': OLD DELH = ',F6.1,    &
     &                 ' M; NEW DELH = ',F6.1,' M; MET LEVEL = ',F6.1,  &
     &                 ' M; NEW Upl = ',F5.2,' M/S; NEW DTHDZ = ',F7.4, &
     &                 ' K/M')
            ENDIF
            IF ( ABS((DHFOLD-DHFAER)/DHFAER).LT.0.01 ) GOTO 60
            IF ( KITER.GE.5 ) THEN
               DHFAER = 0.5*(DHFAER+DHFOLD)
               IF ( DEBUG ) WRITE (DBGUNT,6002) DHFAER
 6002          FORMAT (/,5X,'OPTH2 ITERATION FAILED TO CONVERGE; PLUME',&
     &                 ' RISE SET AT ',F6.1,' METERS.',/)
               GOTO 60
            ELSE
               GOTO 50
            ENDIF
 
 60         CONTINUE
 
!RWB        After completing iteration, reset UP and TGP to stack top
!RWB        values for subsequent distance-dependent plume rise calcs.
            UP = US
            TGP = TGS
            PTP = PTS
            BVF = SQRT(G*TGP/PTP)
            IF ( BVF.LT.1.0E-10 ) BVF = 1.0E-10
            BVPRIM = 0.7*BVF
         ENDIF
 
!        Initialize FSTREC Logical Switch for First Receptor of Loop;
         FSTREC = .TRUE.
         PRM_FSTREC = .TRUE.
 
         ZMIDMX = 0.5*ZI
 
!RJP
!RJP     Calculate distance to uniformly mixed plume within the
!RJP     boundary layer (XMIXED) after Turner's Workbook (1970), page 7:
!RJP     distance is approximately (Zi * UAVG)/SWAVG, where UAVG
!RJP     and SWAVG are wind speed and sigma-w averaged over the depth
!RJP     between the ground and Zi (or the plume height, if higher in
!RJP     stable conditions); this height is denoted as 2 * ZMIDMX.
!RJP
!RJP     First, get refined estimate of final rise and distance to final
!RJP     rise if downwash conditions prevail.
!RJP
         XFINAL = XMAX
         DHCRIT = DHFAER
         XMIXED = ZI*UAVG/SWAVG
         IF ( UNSTAB .AND. HS.LT.ZI ) THEN
!           Check for XMIXED smaller than 1.25*XFINAL
            IF ( XMIXED.LT.1.25*XFINAL ) THEN
               XFINAL = 0.8*XMIXED
               CALL CBLPRD(XFINAL)
               DHCRIT = DHP1
            ENDIF
         ENDIF
 
      ENDIF
 
!     First build table of relative dispersion coefficients for
!     dominant source (source index = ISDX)
      DO I = 1 , NTAB
 
         XTAB = XTABLE(I)
         IF ( I.GT.1 ) THEN
            DELTAX = XTABLE(I) - XTABLE(I-1)
         ELSE
            DELTAX = XTABLE(1)
         ENDIF
 
         IF ( XARG.GT.XTAB ) THEN
 
!           Define plume centroid height (CENTER) for use in
!           inhomogeneity calculations
            CALL CENTROID(XTAB)
 
!              Calculate the plume rise                  ---   CALL DELTAH
            IF ( SRCTYP(ISRC).EQ.'POINT' ) CALL DELTAH(XTAB)
 
!           If the atmosphere is unstable and the stack
!           top is below the mixing height, calculate
!           the CBL PDF coefficients                     ---   CALL PDF
            IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!           Determine Effective Plume Height             ---   CALL HEFF
            CALL HEFF(XTAB)
 
!           Compute effective parameters using an
!           average through plume rise layer
            CALL IBLVAL(XTAB)
 
!           Call PDF & HEFF again for final CBL plume heights
            IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
               CALL PDF
               CALL HEFF(XTAB)
            ENDIF
 
            IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
!              Call BID to get buoyancy-induced dispersion terms
               CALL BID
            ELSE
               SZB = 0.0
               SZBD = 0.0
               SZB3 = 0.0
            ENDIF
 
!           Determine Relative Dispersion Parameters     ---   CALL RELDISP
            CALL RELDISP(XTAB,SR(I),SR3(I))
 
            IF ( I.GT.1 ) THEN
               SIGR = MAX(SRMIN,0.5*(SR(I)+SR(I-1)))
            ELSE
               SIGR = MAX(SRMIN,0.5*SR(I))
            ENDIF
 
!           Calculate vertical dimension (VERT) taking into account ZI limit
            VERT = BVARG + 2.*NSUBZ*SIGR
            IF ( UNSTAB .AND. VERT.GT.ZI ) THEN
               VERT = ZI
               BVTMP = MAX(0.0,ZI-2.*NSUBZ*SIGR)
               IF ( 2.*NSUBZ*SIGR.GT.ZI ) THEN
                  SIGRZTMP = ZI/(2.*NSUBZ)
               ELSE
                  SIGRZTMP = SIGR
               ENDIF
            ELSE
               BVTMP = BVARG
               SIGRZTMP = SIGR
            ENDIF
 
 
!           Plume volume calculation based on rectangle with rounded corners
!           First component is for major contributing plume only
            SUM = SUM + (PI*(NSUBZ*SIGR)*(NSUBZ*SIGRZTMP)+VERT*BHARG+   &
     &            2.*NSUBZ*SIGR*BVTMP)*DELTAX
 
            IF ( UNSTAB .AND. PPFACT(ISRC).GT.0.0 ) THEN
 
               IF ( I.GT.1 ) THEN
                  SIGR3 = MAX(SRMIN,0.5*(SR3(I)+SR3(I-1)))
               ELSE
                  SIGR3 = MAX(SRMIN,0.5*SR3(I))
               ENDIF
 
               VERT = BVARG3 + 2.*NSUBZ*SIGR3
 
               SUM3 = SUM3 + (PI*(NSUBZ*SIGR3)*(NSUBZ*SIGR3)+VERT*BHARG+&
     &                2.*NSUBZ*SIGR3*BVARG3)*DELTAX
 
            ENDIF
 
         ELSE
 
!           Define plume centroid height (CENTER) for use in
!           inhomogeneity calculations
            CALL CENTROID(XARG)
 
!              Calculate the plume rise                  ---   CALL DELTAH
            IF ( SRCTYP(ISRC).EQ.'POINT' ) CALL DELTAH(XARG)
 
!           If the atmosphere is unstable and the stack
!           top is below the mixing height, calculate
!           the CBL PDF coefficients                     ---   CALL PDF
            IF ( UNSTAB .AND. (HS.LT.ZI) ) CALL PDF
 
!           Determine Effective Plume Height             ---   CALL HEFF
            CALL HEFF(XARG)
 
!           Compute effective parameters using an
!           average through plume rise layer
            CALL IBLVAL(XARG)
 
!           Call PDF & HEFF again for final CBL plume heights
            IF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
               CALL PDF
               CALL HEFF(XARG)
            ENDIF
 
            IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
!              Call BID to get buoyancy-induced dispersion terms
               CALL BID
            ELSE
               SZB = 0.0
               SZBD = 0.0
               SZB3 = 0.0
            ENDIF
 
!           Determine Relative Dispersion Parameters     ---   CALL RELDISP
            CALL RELDISP(XARG,SR(I),SR3(I))
 
            DELTAX = XARG - XTABLE(I-1)
 
            IF ( I.GT.1 ) THEN
               SIGR = MAX(SRMIN,0.5*(SR(I)+SR(I-1)))
            ELSE
               SIGR = MAX(SRMIN,0.5*SR(I))
            ENDIF
 
!           Calculate vertical dimension (VERT) taking into account ZI limit
            VERT = BVARG + 2.*NSUBZ*SIGR
            IF ( UNSTAB .AND. VERT.GT.ZI ) THEN
               VERT = ZI
               BVTMP = MAX(0.0,ZI-2.*NSUBZ*SIGR)
               IF ( 2.*NSUBZ*SIGR.GT.ZI ) THEN
                  SIGRZTMP = ZI/(2.*NSUBZ)
               ELSE
                  SIGRZTMP = SIGR
               ENDIF
            ELSE
               BVTMP = BVARG
               SIGRZTMP = SIGR
            ENDIF
 
!           Plume volume calculation based on rectangle with rounded corners
!           First component is for major contributing plume only
            SUM = SUM + (PI*(NSUBZ*SIGR)*(NSUBZ*SIGRZTMP)+VERT*BHARG+   &
     &            2.*NSUBZ*SIGR*BVTMP)*DELTAX
 
            IF ( UNSTAB .AND. PPFACT(ISRC).GT.0.0 ) THEN
 
               IF ( I.GT.1 ) THEN
                  SIGR3 = MAX(SRMIN,0.5*(SR3(I)+SR3(I-1)))
               ELSE
                  SIGR3 = MAX(SRMIN,0.5*SR3(I))
               ENDIF
 
               VERT = BVARG3 + 2.*NSUBZ*SIGR3
 
               SUM3 = SUM3 + (PI*(NSUBZ*SIGR3)*(NSUBZ*SIGR3)+VERT*BHARG+&
     &                2.*NSUBZ*SIGR3*BVARG3)*DELTAX
 
            ENDIF
 
            GOTO 100
 
         ENDIF
 
      ENDDO
 
!     Combine volume for "direct" plume volume and penetrated plume volume
 100  VOLOUT = SUM*(1.-PPFACT(ISRC)) + SUM3*PPFACT(ISRC)
 
      CONTINUE
      END
!*==RELDISP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE RELDISP(XARG,SROUT,SROUT3)
!***********************************************************************
!             RELDISP Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates relative dispersion coefficients for use
!                 in calculating plume volume for the PVMRM option
!
!        PROGRAMMER: Roger W. Brode, PES, Inc.
!
!        DATE:    May 14, 2002
!
!        INPUTS:
!
!
!        OUTPUTS:
!
!
!        CALLED FROM:   PLUME_VOL
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL , PARAMETER :: A1 = 0.57 , A2 = 0.62*A1 , AR1 = 0.46
      REAL :: XARG , SROUT , SROUT3 , SRAMB , TLR , SZBID , VSIGR
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'RELDISP'
 
      VSIGR = SQRT(SYINIT*SZINIT)
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
!        The atmosphere is stable or the release is above the CBL mixing ht.
         TLR = AR1*ZI/SWEFF
         SRAMB = (A1*SQRT(EPSEFF)*(XARG/UEFF)**1.5)                     &
     &           /(1.+A2*XARG/(UEFF*TLR))
         SROUT = (SRAMB**3.+SZB**3.+VSIGR**3.)**0.3333333
 
         SROUT3 = SROUT
 
      ELSEIF ( UNSTAB ) THEN
!        The atmosphere is unstable and the release is below the CBL mixing ht.
         TLR = AR1*ZI/SWEFFD
         SRAMB = (A1*SQRT(EPSEFFD)*(XARG/UEFFD)**1.5)                   &
     &           /(1.+A2*XARG/(UEFFD*TLR))
         SROUT = (SRAMB**3.+SZBD**3.+VSIGR**3.)**0.3333333
 
!        Calculate relative dispersion for a penetrated plume, SROUT3
         IF ( PPFACT(ISRC).GT.0.0 ) THEN
            TLR = AR1*ZI/SWEFF3
            SRAMB = (A1*SQRT(EPSEFF3)*(XARG/UEFF3)**1.5)                &
     &              /(1.+A2*XARG/(UEFF3*TLR))
            SROUT3 = (SRAMB**3.+SZB3**3.+VSIGR**3.)**0.3333333
 
         ELSE
            SROUT3 = 0.0
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==EMFACT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE EMFACT(QARG)
!***********************************************************************
!                 EMFACT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Applies Variable Emission Rate and
!                 Unit Conversion Factors
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!        MODIFIED  : for handling OpenPit Source Type - PES, 7/26/94
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To include an option to vary emissions by season,
!                    hour-of-day, and day-of-week (SHRDOW).
!                    R.W. Brode, PES, 4/10/2000
!
!        INPUTS:  Arrays of Source Parameters
!                 Date and Hour
!                 Meteorological Variables for One Hour
!                 Variable Emission Rate Flags and Factors
!                 Unit Conversion Rate Factors
!
!        OUTPUTS: Adjusted Emission Rate, QTK
!
!        CALLED FROM:   PCALC
!                       VCALC
!                       ACALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: QARG
 
!     Variable Initializations
      MODNAM = 'EMFACT'
 
!     Apply Emission Unit Factor (EMIFAC) and Variable Emission Rate
!     Factor, Based on Value of QFLAG
      IF ( QFLAG(ISRC).EQ.' ' ) THEN
         QTK = QARG
 
!*----   ISCSTM Modification: To handle hourly emissions - jah 11/4/94
      ELSEIF ( QFLAG(ISRC).EQ.'HOURLY' ) THEN
         QTK = QARG
!*----
!*#
 
      ELSEIF ( QFLAG(ISRC).EQ.'MONTH' ) THEN
         QTK = QARG*QFACT(IMONTH,ISRC)
 
      ELSEIF ( QFLAG(ISRC).EQ.'HROFDY' ) THEN
         QTK = QARG*QFACT(IHOUR,ISRC)
 
      ELSEIF ( QFLAG(ISRC).EQ.'WSPEED' ) THEN
         QTK = QARG*QFACT(IUCAT,ISRC)
 
      ELSEIF ( QFLAG(ISRC).EQ.'SEASON' ) THEN
         QTK = QARG*QFACT(ISEAS,ISRC)
 
      ELSEIF ( QFLAG(ISRC).EQ.'SEASHR' ) THEN
         QTK = QARG*QFACT((IHOUR+(ISEAS-1)*24),ISRC)
 
      ELSEIF ( QFLAG(ISRC).EQ.'SHRDOW' ) THEN
         QTK = QARG*QFACT((IHOUR+(ISEAS-1)*24+(IDAY_OF_WEEK-1)*96),ISRC)
 
      ELSEIF ( QFLAG(ISRC).EQ.'SHRDOW7' ) THEN
         QTK = QARG*QFACT((IHOUR+(ISEAS-1)*24+(IDAY_OF_WEEK7-1)*96),    &
     &         ISRC)
 
      ENDIF
 
      CONTINUE
      END
!*==DISTF.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE DISTF
!***********************************************************************
!                 DISTF Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Distance to Final Plume Rise
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Arrays of Source Parameters
!                 Buoyancy and Momentum Fluxes
!                 Meteorological Variables for One Hour
!                 Wind Speed Adjusted to Stack Height
!
!        OUTPUTS: Distance to Final Plume Rise, XF (m), and Distance
!                 to Final Buoyant Rise (XFB) and Final Momentum Rise (XFM)
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: XLN , DELHNN , XMAXN
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'DISTF'
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
 
!        Compute the distance to final rise, XMAX;
!        The negative sign appears on the FB term to insure that the
!           resulting angle is between 0 and PI (i.e., positive)
         XMAX = UP*ATAN2(FM*BVPRIM,-FB)/BVPRIM
 
!        Compute the final stable plume rise, DHF, from Eqn. 3-113 of MFD
         DHFAER = 2.66*(FB/(BVF*BVF*UP))**0.333333
         XLN = FB/(UP*USTAR*USTAR)
         DELHNN = 1.2*XLN**0.6*(HSP+1.2*XLN)**0.4
         DHFAER = AMIN1(DHFAER,DELHNN)
 
!        Compute Neutral/Unstable Final Rise
         IF ( FB.LE.0.0 ) THEN
            XMAXN = 4.*DS*(VS+3.*UP)*(VS+3.*UP)/(VS*UP)
            DHFAER = AMIN1(DHFAER,3.0*DS*VS/UP)
         ELSE
            IF ( FB.GE.55.0 ) THEN
               XMAXN = 119.0*FB**0.4
            ELSE
               XMAXN = 49.0*FB**0.625
            ENDIF
            CALL CBLPRD(XMAXN)
            DHFAER = AMIN1(DHFAER,DHP1)
         ENDIF
 
!        Apply calm, stable rise limit
         DHFAER = AMIN1(DHFAER,4.0*FB**0.25/(BVF*BVF)**0.375)
 
!        For urban stable boundary layers, limit plume rise to 1.25*ZI - HSP
         IF ( URBSTAB ) THEN
            IF ( HSP.LT.1.25*ZI ) THEN
               DHFAER = MIN(DHFAER,1.25*ZI-HSP)
            ELSE
               DHFAER = 0.0
            ENDIF
         ENDIF
 
      ELSE
!        Unstable plume
 
         IF ( FB.LE.0.0 ) THEN
            XMAX = 4.*DS*(VS+3.*UP)*(VS+3.*UP)/(VS*UP)
            DHFAER = 3.0*DS*VS/UP
         ELSE
            IF ( FB.GE.55. ) THEN
               XMAX = 119.*FB**0.4
            ELSE
               XMAX = 49.*FB**0.625
            ENDIF
            CALL CBLPRD(XMAX)
            DHFAER = DHP1
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==WAKFLG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE WAKFLG
!***********************************************************************
!                 WAKFLG Module of the AMS/EPA Regulatory Model - AERMOD
! ----------------------------------------------------------------------
! ---    ISC-PRIME     Version 1.0    Level 970812              Modified
! ---        D. Strimaitis
! ---        Earth Tech, Inc.
!            Prepared for EPRI under contract WO3527-01
! ----------------------------------------------------------------------
!
!        PURPOSE: To Set Wake Flags for Building Downwash Algorithms
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Building Dimensions
!                 Source Parameters
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: Logical Flags for Wake Switch, WAKE;
!                 And Building Types, TALL, SQUAT, and SSQUAT;
!                 And Value of ZLB
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: X2BH
 
!     Variable Initializations
      MODNAM = 'WAKFLG'
 
!     Select Building Dimensions for This Sector
      IF ( IFVSEC.LE.NSEC ) THEN
         DSBH = ADSBH(IFVSEC,ISRC)
         DSBW = ADSBW(IFVSEC,ISRC)
 
! --- PRIME ---------------------------------
         DSBL = ADSBL(IFVSEC,ISRC)
         XADJ = ADSXADJ(IFVSEC,ISRC)
         YADJ = ADSYADJ(IFVSEC,ISRC)
         B_SUBS = MIN(DSBH,DSBW)
         B_SUBL = MAX(DSBH,DSBW)
         B_SUBL = MIN(B_SUBL,8.0*B_SUBS)
         RSCALE = B_SUBS**0.666667*B_SUBL**0.333333
! -------------------------------------------
 
      ENDIF
 
!     Set Initiala Wake Switches Based on Building Dimensions
! --- PRIME ----------------------------------------------------
! --- Fix error in ISC to conform to GEP policy
! *** IF (DSBH.EQ.0.0 .OR. DSBW.EQ.0.0 .OR.
! ***&    HS .GT. (DSBH + 1.5*AMIN1(DSBH,DSBW))) THEN
      IF ( DSBH.EQ.0.0 .OR. DSBW.EQ.0.0 .OR.                            &
     &     HS.GE.(DSBH+1.5*AMIN1(DSBH,DSBW)) ) THEN
! -------------------------------------------------------------
         WAKE = .FALSE.
      ELSE
         WAKE = .TRUE.
      ENDIF
 
! --- PRIME ----------------------------------------------------
 
      CONTINUE
      END
!*==XYDIST.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE XYDIST(INDX)
!***********************************************************************
!                 XYDIST Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Sets Receptor Variables and Calculates Downwind (X)
!                 and Crosswind (Y) Distances,
!                 and Radial Distance from Source to Receptor (DISTR)
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED BY R.W. Brode, PES, Inc. to use calling argument to
!                 specify array index, so that routine can be used by
!                 both the regular ISCST3 routines and the routines of
!                 the EVENT processor (ISCEV3). - 12/29/97
!
!        INPUTS:  Source Location
!                 Arrays of Receptor Locations
!                 SIN and COS of Wind Direction FROM Which Wind
!                 is Blowing, WDSIN and WDCOS
!
!        OUTPUTS: Values of X, Y, and DISTR (m)
!
!        CALLED FROM:   PCALC
!                       VCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: INDX
 
!     Variable Initializations
      MODNAM = 'XYDIST'
 
!     Set Receptor Coordinates, Terrain Elevation and Flagpole Heights
      XR = AXR(INDX)
      YR = AYR(INDX)
      ZELEV = AZELEV(INDX)
      ZHILL = AZHILL(INDX)
      ZFLAG = AZFLAG(INDX)
 
!     Calculate Downwind (X) and Crosswind (Y) Distances
      X = -((XR-XS)*WDSIN+(YR-YS)*WDCOS)
      Y = (XR-XS)*WDCOS - (YR-YS)*WDSIN
 
!     Calculate Source-Receptor (Radial) Distance, DISTR
      DISTR = SQRT(X*X+Y*Y)
 
!     Calculate height of receptor above stack base, ZRT
      ZRT = ZELEV - ZS + ZFLAG
 
!     Check for SCREENing Mode and Set X,Y to Force Centerline Calc.
      IF ( SCREEN ) THEN
         X = DISTR
         Y = 0.0
      ENDIF
 
      CONTINUE
      END
!*==FTERM.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE FTERM
!***********************************************************************
!             FTERM Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Calculate the Value of 'F' Which is Related to the
!                 Fraction of Plume Material Below HCrit
!
!        PROGRAMMER: Roger Brode, Jayant Hardikar
!
!        DATE:    September 30, 1993
!
!        INPUTS:  PHEE - Fraction of Plume Material Below HCrit
!
!        OUTPUTS: FOPT  - The 'F' Term
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'FTERM'
 
      FOPT = 0.5*(1.0+PHEE)
 
      CONTINUE
      END
!*==FYPLM.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE FYPLM(SYARG,FYOUT)
!***********************************************************************
!             FYPLM Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Calculate the Value of the Horizontal Gaussian
!                 Distribution Function for the Coherent Plume
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 30, 1993
!
!        INPUTS:
!                 SY   - Sigma-Y
!                 Y    - The Crosswind Distance of the Receptor from
!                        the Plume
!
!        OUTPUTS: 'FSUBY' Term
!
!        CALLED FROM:   AERCALC, PRMCALC, VOLCALC, ACALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: SYARG , EXPARG , FYOUT
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'FYPLM'
 
      EXPARG = -(Y*Y/(2.0*SYARG*SYARG))
!
!     Add meander component
!
      IF ( EXPARG.GT.EXPLIM ) THEN
!        Calculate lateral term for Gaussian plume
         FYOUT = EXP(EXPARG)/(SRT2PI*SYARG)
      ELSE
         FYOUT = 0.0
      ENDIF
 
      CONTINUE
      END
!*==FYPAN.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE FYPAN(FYOUT)
!***********************************************************************
!             FYPAN Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Calculate the Value of the Horizontal Gaussian
!                 Distribution Function for the Random ("Pancake")
!                 Component
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 30, 1993
!
!        INPUTS:
!                 DISTR - Real - Radial distance of receptor from the
!                                source (m)
!
!        OUTPUTS: 'FSUBY' Term
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: FYOUT
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'FYPAN'
 
      FYOUT = 1.0/(TWOPI*DISTR)
 
      CONTINUE
      END
!*==MEANDR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE MEANDR(UEF,SVEF,FRAN)
!***********************************************************************
!             MEANDR Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates fraction of random plume for lateral
!                 meander
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:       June 26, 2001
!
!        MODIFICATIONS:
!
!                    To use UEF instead of UMEAN in denominator of TTRAV
!                    term in calculation of SIGRAN.
!                    R.W. Brode, PES, Inc.  8/28/01
!
!                    To use radial distance (DISTR) in calculation of
!                    TTRAV instead of downwind distance (X).
!                    R.W. Brode, PES, Inc.  6/19/01
!
!        INPUTS:  Effective wind speed, UEF, in m/s
!                 Effective wind sigma_V, SVEF, in m/s
!
!        OUTPUTS: Fraction of plume in random lateral distribution, FRAN
!
!        CALLED FROM:   AERCALC
!                       PRMCALC
!                       VCALC
!
!        CALLS:         None
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL , PARAMETER :: BIGT = 24.
      REAL :: UEF , SVEF , FRAN , UMEAN , TOTKIN , TRAN , TTRAV , SIGRAN
      REAL :: SQRTARG
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'MEANDR'
 
!     Compute meander fraction of horizontal distribution function
!     from Venky's memo of 6/24/98.
 
!     Calculate time scale (s) for random dispersion, based on 24 hours
      TRAN = BIGT*3600.
!
!     Remove the SVeff component from UEF
!
 
      SQRTARG = UEF*UEF - 2.0*SVEF*SVEF
      IF ( SQRTARG.GE.0.01 ) THEN
         UMEAN = SQRT(SQRTARG)
      ELSE
         UMEAN = 0.1
      ENDIF
      TOTKIN = UEF*UEF
      TTRAV = DISTR/UEF
      SIGRAN = 2.0*SVEF*SVEF + UMEAN*UMEAN*(1.0-EXP(-TTRAV/TRAN))
      FRAN = SIGRAN/TOTKIN
 
      IF ( DEBUG ) THEN
         WRITE (DBGUNT,*)                                               &
     &      "SVEF, UEF, UMEAN, DISTR, TTRAV, TRAN, TOTKIN, SIGRAN, FRAN"&
     &      , SVEF , UEF , UMEAN , DISTR , TTRAV , TRAN , TOTKIN ,      &
     &      SIGRAN , FRAN
         WRITE (DBGUNT,*) ' '
      ENDIF
 
      CONTINUE
      END
!*==CRITDS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CRITDS(HEARG)
!***********************************************************************
!             CRITDS Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Compute the critical dividing streamline for each receptor
!                 (this routine is source dependent)
!
!        PROGRAMMER: Jim Paumier and Roger Brode, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        MODIFICATIONS:
!
!                    To redefine the upper limit on the integration for
!                    HCRIT as the minimum of the plume height above
!                    the receptor height, and the height scale input
!                    from AERMAP.
!                    R.W. Brode, PES, Inc.  9/4/01
!
!        INPUTS:  Plume Height, HEARG
!                 Gridded profile heights, GRIDHT
!                                 wind speed, GRIDWS
!                                 potential temperature, GRIDPT
!                                 potential temperature gradient, GRIDTG
!                 Hill height scale, ZHILL, input from AERMAP
!
!        OUTPUTS: Critical dividing streamline for the receptor
!
!        Assumptions:
!
!        References:  "User's Guide to the Complex Terrain Dispersion
!                      Model Plus ..."
!                     "Approach for Determining Hill Heights for AERMOD",
!                      A. Cimorelli, 6/25/93
!
!        CALLED FROM:
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: NDX4HC
      REAL :: HHILL , UATHH , PTATHH , TGATHH , PTHC , TGHC , TOPHT ,   &
     &        WSTOP
      REAL :: HEARG
 
      SAVE 
 
!     DEFINE LOCAL VARIABLES
      REAL A , AC4 , B , B2 , C , DETER , HBOT , HTOP , LS(MXGLVL) ,    &
     &     RS(MXGLVL) , XN2(MXGLVL) , N2 , DWS , DWS2 , ZMID
      INTEGER IB , IT , NL , NLEV
 
!     Variable Initializations
      MODNAM = 'CRITDS'
 
!     Compute the upper limit on the integration for HCRIT, called HHILL.
!     Set as minimum of plume height above receptor height, and height
!     scale above the receptor height (ZHILL) input from AERMAP.
 
      HHILL = MIN(ZHILL-ZS,ZELEV-ZS+HEARG)
 
      IF ( STABLE .AND. ELEV .AND. HHILL.GT.0.0 ) THEN
!        The hill elevation is above the source elevation and we are
!        using elevated terrain;
 
!        Determine the index of the gridded height immediately below
!        the hill height and determine the number of levels to use
 
         CALL LOCATE(GRIDHT,1,MXGLVL,HHILL,NDX4HC)
         NLEV = NDX4HC + 1
 
!        Compute values at hill height
         CALL GINTRP(GRIDHT(NDX4HC),GRIDWS(NDX4HC),GRIDHT(NDX4HC+1),    &
     &               GRIDWS(NDX4HC+1),HHILL,UATHH)
         CALL GINTRP(GRIDHT(NDX4HC),GRIDPT(NDX4HC),GRIDHT(NDX4HC+1),    &
     &               GRIDPT(NDX4HC+1),HHILL,PTATHH)
         CALL GINTRP(GRIDHT(NDX4HC),GRIDTG(NDX4HC),GRIDHT(NDX4HC+1),    &
     &               GRIDTG(NDX4HC+1),HHILL,TGATHH)
 
!        Compute the left side of Eq. 32 in the CTDMPLUS User's Guide
!        for all gridded levels; the actual number of levels to use is
!        determined later in the routine
 
         DO NL = 1 , NLEV - 1
            LS(NL) = 0.5*GRIDWS(NL)*GRIDWS(NL)
         ENDDO
 
!        Define LS at the hill top
         LS(NLEV) = 0.5*UATHH*UATHH
 
!        Compute the right-hand side (RHS) of Eq. 32 in the CTDMPLUS
!        User's Guide using the midpoint of each layer
 
         RS(NLEV) = 0.0
         DO NL = NLEV - 1 , 1 , -1
 
            IF ( NL.LT.NLEV-1 ) THEN
               ZMID = 0.5*(GRIDHT(NL+1)+GRIDHT(NL))
               PTHC = 0.5*(GRIDPT(NL+1)+GRIDPT(NL))
               TGHC = 0.5*(GRIDTG(NL+1)+GRIDTG(NL))
               TOPHT = GRIDHT(NL+1)
 
            ELSEIF ( NL.EQ.NLEV-1 ) THEN
               ZMID = 0.5*(HHILL+GRIDHT(NL))
               PTHC = 0.5*(PTATHH+GRIDPT(NL))
               TGHC = 0.5*(TGATHH+GRIDTG(NL))
               TOPHT = HHILL
 
            ENDIF
 
!           Compute the Brunt-Vaisala frequency and then the RHS of Eq. 32
 
            XN2(NL) = (G/PTHC)*TGHC
            RS(NL) = RS(NL+1) + XN2(NL)                                 &
     &               *((HHILL-ZMID)*(TOPHT-GRIDHT(NL)))
 
         ENDDO
 
!        Find the layer(s) where Eq. 32 is satisfied; the lowest layer
!        is saved for the computation
 
         IT = 1
         DO NL = NLEV , 1 , -1
            IF ( LS(NL).GE.RS(NL) ) IT = NL
         ENDDO
 
!        Interpolate to get the critical dividing streamline, HC,
!        assuming a linear change of variables within a layer;
!        the result is a quadratic equation for HC
!
!        DWS is wind speed shear; N2 is the Brunt-Vaisala frequency.
!
         IF ( IT.GT.1 ) THEN
 
            IF ( IT.EQ.NLEV ) THEN
               WSTOP = UATHH
               HTOP = HHILL
            ELSE
               WSTOP = GRIDWS(IT)
               HTOP = GRIDHT(IT)
            ENDIF
 
            IB = IT - 1
            HBOT = GRIDHT(IB)
            DWS = (WSTOP-GRIDWS(IB))/(HTOP-HBOT)
            DWS2 = DWS*DWS
            N2 = XN2(IB)
!
!           Solve the quadratic eqn
!
            A = 0.5*(N2-DWS2)
            B = (HTOP*DWS2-WSTOP*DWS-N2*HHILL)
            C = (N2*HHILL*HTOP) - 0.5*(N2*HTOP*HTOP)                    &
     &          - 0.5*(DWS2*HTOP*HTOP) + WSTOP*DWS*HTOP -               &
     &          (LS(IT)-RS(IT))
            B2 = B*B
            AC4 = 4.0*A*C
!crfl 6/19/96 Avoid sqrt (neg #) when near zero.
            IF ( (B2-AC4)/B2.LT.0. .AND. (B2-AC4)/B2.GT.-0.001 )        &
     &           AC4 = B2
!crflendtest
            DETER = SQRT(B2-AC4)
            HCRIT = (-B-DETER)/(2.0*A)
         ELSE
            HCRIT = 0.0
         ENDIF
 
      ELSE
!        The hill height is less than zero (i.e., the hill elevation is
!        less than stack base); set HCRIT = 0.0 for this receptor
         HCRIT = 0.0
 
      ENDIF
 
      CONTINUE
      END
!*==PDF.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PDF
!=======================================================================
!             PDF Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To calculate the parameters required by the CBL
!                probability density function
!
!   Input:
!
!
!   Output:
!
!   Assumptions:
!
!   Called by:   PCALC
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Data initializations
 
      MODNAM = 'PDF'
 
!---- Calculate the skewness, SKEW                         --- CALL SKCALC
      CALL SKCALC
 
!---- Calculate the Lagrangian correlation function, R     --- CALL CRCALC
      CALL CRCALC
 
!---- Calculate the parameter ALPHPD                       --- CALL ALCALC
      CALL ALCALC
 
!---- Calculate the parameter BETAPD                       --- CALL BECALC
      CALL BECALC
 
!---- Calculate the ratio of the mean updraft and downdraft velocities
!     to the standard deviation of the vertical velocity, ASUB1 and ASUB2,
!     respectively                                         --- CALL AACALC
      CALL AACALC
 
!---- Calculate the ratio of the turbulent energy in the updrafts
!     and downdrafts to the standard deviation of the total vertical
!     velocity, BSUB1 and BSUB2, respectively              --- CALL BBCALC
      CALL BBCALC
 
!---- Calculate the relative frequencies of updrafts and
!     downdrafts, LAMDA1 and LAMDA2, respectively          --- CALL LLCALC
      CALL LLCALC
 
      CONTINUE
      END
!*==SKCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SKCALC
!=======================================================================
!             SKCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To calculate the skewness of the vertical velocity
!
!   Input:       Height at which computation is made, HEIGHT
!                Convective scaling velocity, WSTAR
!RJP
!RJP             Change SWEFF to SWEFFD throughout
!RJP
!RJP             Effective sigma_W, SWEFF
!                Effective sigma_W, SWEFFD
!
!   Output:      Skewness, SKEW
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer(s):  Jim Paumier, PES, Inc.
!   Date:           September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
      REAL WBAR3
 
!---- Data initializations
!
      MODNAM = 'SKCALC'
 
!---- Define the mean of the third moment of vertical velocity
      IF ( SURFAC ) THEN
!        This is a surface layer release
         WBAR3 = 1.25*(WSTAR**3)*(CENTER/ZI)
 
      ELSE
!        The release is above the surface layer
         WBAR3 = 0.125*(WSTAR**3)
 
      ENDIF
 
!---- Calculate the skewness
      SKEW = WBAR3/(SWEFFD*SWEFFD*SWEFFD)
 
      CONTINUE
      END
!*==CRCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CRCALC()
!=======================================================================
!             CRCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To calculate the lagrangian correlation coefficient
!
!   Input:       Convective scaling velocity, WSTAR
!                Surface friction velocity, USTAR
!
!   Output:      Correlation coefficient, R
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Data initializations
!
      MODNAM = 'CRCALC'
 
!---- Set value of R to 2.0
 
      R = 2.0
 
      CONTINUE
      END
!*==ALCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ALCALC()
!=======================================================================
!             ALCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To calculate the coefficient ALPHPD for the CBL PDF
!
!   Input:       Lagrangian correlation coefficient, R
!
!   Output:      Coefficient, ALPHPD
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Data initializations
!
      MODNAM = 'ALCALC'
 
!---- Calculate the coefficient ALPHPD
 
      ALPHPD = (1.0+R*R)/(1.0+3.0*R*R)
 
      CONTINUE
      END
!*==BECALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE BECALC()
!=======================================================================
!             BECALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To calculate the coefficient BETAPD for the CBL PDF
!
!   Input:       Lagrangian correlation coefficient, R
!
!   Output:      Coefficient, BETAPD
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Data initializations
!
      MODNAM = 'BECALC'
 
!---- Calculate the coefficient BETAPD
 
      BETAPD = 1.0 + R*R
 
      CONTINUE
      END
!*==AACALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE AACALC()
!=======================================================================
!             AACALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     Calculate the ratio of the mean updraft and downdraft
!                velocities to the standard deviation of the vertical
!                velocity
!
!   Input:       Skewness, SKEW
!                The coefficients ALPHPD and BETAPD
!
!   Output:      ASUB1 and ASUB2
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: DETERM , SWRATIO
 
      SAVE 
 
!---- Data initializations
!
      MODNAM = 'AACALC'
 
!---- These two coefficients appear to be the solutions to a quadratic
!     equation.  Therefore, first compute the value of the determinant.
 
      DETERM = (ALPHPD*ALPHPD)*(SKEW*SKEW) + (4.0/BETAPD)
 
!---- Compute square root of sigma-wc^2/wstar^2
      SWRATIO = SWEFFD/WSTAR
 
!---- Calculate the coefficients ASUB1 and ASUB2
 
      ASUB1 = SWRATIO*(0.5*ALPHPD*SKEW+0.5*SQRT(DETERM))
      ASUB2 = SWRATIO*(0.5*ALPHPD*SKEW-0.5*SQRT(DETERM))
 
      CONTINUE
      END
!*==BBCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE BBCALC()
!=======================================================================
!             BBCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     Calculate the ratio of the turbulent energy in the
!                updrafts and downdrafts to the standard deviation of
!                the vertical velocity
!
!   Input:       The Lagrangian correlation, R
!                The coefficients ASUB1 and ASUB2
!
!   Output:      BSUB1 and BSUB2
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Data initializations
!
      MODNAM = 'BBCALC'
 
!---- Calculate the coefficients BSUB1 and BSUB2
 
      BSUB1 = R*ASUB1
      BSUB2 = -R*ASUB2
 
      CONTINUE
      END
!*==LLCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE LLCALC()
!=======================================================================
!             LLCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     Calculate the relative frequencies of updrafts and
!                downdrafts
!
!   Input:       The coefficients ASUB1 and ASUB2
!
!   Output:      LAMDA1 and LAMDA2
!
!   Assumptions:
!
!   Called by:   PDF
!
!   Programmer:  Jim Paumier, PES, Inc.
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   References:  "Summary of Expressions for the CBL", J. Weil, 4/12/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Data initializations
!
      MODNAM = 'LLCALC'
 
!---- Calculate the coefficients LAMDA1 and LAMDA2
 
      LAMDA1 = ASUB2/(ASUB2-ASUB1)
      LAMDA2 = 1.0 - LAMDA1
 
      CONTINUE
      END
!*==DECAY.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE DECAY(XARG)
!***********************************************************************
!                 DECAY Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Decay Term for Use in Gaussian Plume Equation
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Downwind Distance, XARG (m)
!                 Stack Top Wind Speed, US (m/s)
!                 Decay Coefficient, DECOEFF (1/s)
!
!        OUTPUTS: Decay Term, D
!
!        CALLED FROM:   CHI
!                       DEP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: XARG
 
!     Variable Initializations
      MODNAM = 'DECAY'
 
      D = 1.0
 
      IF ( DFAULT .AND. URBAN .AND. POLLUT.EQ.'SO2' .AND. URBSRC(ISRC)  &
     &     .EQ.'Y' ) THEN
         DECOEF = 4.81E-5
      ELSEIF ( DFAULT ) THEN
         DECOEF = 0.0
      ENDIF
 
      IF ( DECOEF.GT.0.0 ) THEN
         IF ( STABLE .OR. (UNSTAB .AND. HS.GE.ZI) ) THEN
            D = EXP(AMAX1(EXPLIM,-DECOEF*XARG/UEFF))
         ELSE
            D = EXP(AMAX1(EXPLIM,-DECOEF*XARG/UEFFD))
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==VRTSBL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE VRTSBL(SZARG,HEARG,ZIARG)
!***********************************************************************
!        VRTSBL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Vertical Term for Use in Gaussian Plume
!                 Equation for Stable Conditions.
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 30, 1993
!
!        MODIFIED BY R.W. Brode, PES, Inc. to adjust HE and ZI for cases
!                 with receptors below stack base (ZR < 0) - 12/26/00
!
!        INPUTS:  Plume Height, HE
!                 Vertical Dispersion Parameter, SZ
!                 Mixing/Reflection Height, HSBL (= max(zi,he))
!                 Receptor Height, ZR
!
!        OUTPUTS: Vertical Term, FSUBZ
!
!        ASSUMPTIONS:   Vertical term for STABLE plumes includes
!                       multiple reflection terms.
!
!        REVISIONS:  Concentrations for receptors above HSBL forced
!                    to zero.  Change made 8/31/94 by R.F. Lee.
!
!        CALLED FROM:   WRAP, LIFT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
      REAL :: SZARG , HEARG , ZIARG , A1 , A2 , A3 , A4 , A5 , A6 ,     &
     &        TWOIZI , SUM , T , V
      REAL :: HETMP , ZITMP
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'VRTSBL'
      V = 0.0
 
      IF ( ZR.EQ.0.0 ) THEN
!        Vertical Term for Case With FLAT Terrain and No Flagpole
!        Receptor (ZR = 0.0)
         A1 = (-0.5/(SZARG*SZARG))*HEARG*HEARG
         IF ( A1.GT.EXPLIM ) V = EXP(A1)
         SUM = 0.0
         DO I = 1 , 100
            T = 0.0
!           Use ZIARG (set in PCALC = max(HE,ZI)) instead of ZI.
            TWOIZI = 2.*I*ZIARG
            A2 = (-0.5/(SZARG*SZARG))*(TWOIZI-HEARG)*(TWOIZI-HEARG)
            A3 = (-0.5/(SZARG*SZARG))*(TWOIZI+HEARG)*(TWOIZI+HEARG)
            IF ( A2.GT.EXPLIM ) T = EXP(A2)
            IF ( A3.GT.EXPLIM ) T = T + EXP(A3)
            SUM = SUM + T
 
!RWB        Modify convergence criterion to use relative value of T
!              Exit Loop
            IF ( ABS(T).LE.5.0E-7*ABS(SUM) ) GOTO 50
         ENDDO
!        Calculate Total Vert. Term - (2.*) was Removed for Optimization
 50      V = 2.*(V+SUM)
 
      ELSEIF ( ZR.LE.ZIARG ) THEN
!        Vertical Term for Case of ZR .NE. 0.0
!        First adjust for terrain below stack base with ZR < 0,
!        by keeping HE and ZI horizontal.
         HETMP = MAX(HEARG,HEARG-ZR)
         ZITMP = MAX(ZIARG,ZIARG-ZR)
 
         A1 = (-0.5/(SZARG*SZARG))*(ZR-HETMP)*(ZR-HETMP)
         A2 = (-0.5/(SZARG*SZARG))*(ZR+HETMP)*(ZR+HETMP)
         IF ( A1.GT.EXPLIM ) V = EXP(A1)
         IF ( A2.GT.EXPLIM ) V = V + EXP(A2)
         SUM = 0.0
         DO I = 1 , 100
            T = 0.0
            TWOIZI = 2.*I*ZITMP
            A3 = (-0.5/(SZARG*SZARG))*(ZR-(TWOIZI-HETMP))               &
     &           *(ZR-(TWOIZI-HETMP))
            A4 = (-0.5/(SZARG*SZARG))*(ZR+(TWOIZI-HETMP))               &
     &           *(ZR+(TWOIZI-HETMP))
            A5 = (-0.5/(SZARG*SZARG))*(ZR-(TWOIZI+HETMP))               &
     &           *(ZR-(TWOIZI+HETMP))
            A6 = (-0.5/(SZARG*SZARG))*(ZR+(TWOIZI+HETMP))               &
     &           *(ZR+(TWOIZI+HETMP))
            IF ( A3.GT.EXPLIM ) T = T + EXP(A3)
            IF ( A4.GT.EXPLIM ) T = T + EXP(A4)
            IF ( A5.GT.EXPLIM ) T = T + EXP(A5)
            IF ( A6.GT.EXPLIM ) T = T + EXP(A6)
            SUM = SUM + T
 
!RWB        Modify convergence criterion to use relative value of T
!              Exit Loop
            IF ( ABS(T).LE.1.0E-6*ABS(SUM) ) GOTO 100
         ENDDO
 100     V = V + SUM
!CRFL
!CRFL  Add 'ELSE' to cover case where receptor is above HSBL, and
!CRFL  set V = 0 for that case.
      ELSE
         V = 0.0
      ENDIF
 
!     Calculate FSUBZ from V;  FSUBZ = V / (SQRT(2*PI) * SZARG)
      FSUBZ = V/(SRT2PI*SZARG)
 
      CONTINUE
      END
!*==VRTSBN.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE VRTSBN(SZARG,HEARG,ZIARG)
!***********************************************************************
!        VRTSBN Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Vertical Term for Use in Gaussian Plume
!                 Equation for Stable Conditions WITHOUT mixing lid.
!                 This subroutine is used for plumes above the CBL.
!
!        PROGRAMMER: Russ Lee, adapted from SUBROUTINE VRTSBL written
!                 by Roger Brode
!
!        DATE:    August 31, 1994
!
!        MODIFIED BY R.W. Brode, PES, Inc. to adjust HE for cases
!                 with receptors below stack base (ZR < 0) - 12/26/00
!
!        INPUTS:  Plume Height, HE
!                 Vertical Dispersion Parameter, SZ
!                 Receptor Height, ZR
!
!        OUTPUTS: Vertical Term, FSUBZ
!
!        ASSUMPTIONS:   This routine for Vertical term for STABLE
!                       plumes does not include multiple reflection
!                       terms (used in stable layer above CBL).
!
!        CALLED FROM:   WRAP, LIFT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: SZARG , HEARG , ZIARG , A1 , A2 , V
      REAL :: HETMP
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'VRTSBN'
      V = 0.0
 
      IF ( ZR.EQ.0.0 ) THEN
!        Vertical Term for Case With FLAT Terrain and No Flagpole
!        Receptor (ZR = 0.0)
         A1 = (-0.5/(SZARG*SZARG))*HEARG*HEARG
         IF ( A1.GT.EXPLIM ) V = EXP(A1)
         V = 2.*V
      ELSE
!        Vertical Term for Case of ZR .NE. 0.0
!        First adjust for terrain below stack base with ZR < 0,
!        by keeping HE and ZI horizontal.
         HETMP = MAX(HEARG,HEARG-ZR)
 
         A1 = (-0.5/(SZARG*SZARG))*(ZR-HETMP)*(ZR-HETMP)
         A2 = (-0.5/(SZARG*SZARG))*(ZR+HETMP)*(ZR+HETMP)
         IF ( A1.GT.EXPLIM ) V = EXP(A1)
         IF ( A2.GT.EXPLIM ) V = V + EXP(A2)
      ENDIF
 
!     Calculate FSUBZ from V;  FSUBZ = V / (SQRT(2*PI) * SZ)
      FSUBZ = V/(SRT2PI*SZARG)
 
      CONTINUE
      END
!*==VRTCBL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE VRTCBL(HE1,HE2,SZ1,SZ2,FACT)
!***********************************************************************
!        VRTCBL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Vertical Term for Use in Bi-Gaussian Plume
!                 Equation for Unstable (Convective) Conditions.
!                 Skewness of the plume is treated
!                 using two Gaussian plumes.  Revised from VRTCBL as
!                 programmed by Roger Brode, September 30, 1993.
!
!        PROGRAMMERS: Roger Brode, Russ Lee
!
!        DATE:    July 20, 1994
!
!        MODIFIED BY R.W. Brode, PES, Inc. to adjust HE and ZI for cases
!                 with receptors below stack base (ZR < 0) - 12/26/00
!
!        MODIFIED BY R.W. Brode, PES, Inc. to set vertical term to 0.0
!                 for cases when receptor is above mixing height - 1/22/98
!
!        INPUTS:  Plume 1 Height (arg), HE1
!                 Plume 2 Height (arg), HE2
!                 Vertical Dispersion Parameter (Plume 1), SZ1
!                 Vertical Dispersion Parameter (Plume 2), SZ2
!                 Factor to distinguish between direct
!                    and indirect plumes, FACT =  1.0 for Direct Plume
!                                         FACT = -1.0 for Indirect Plume
!                 Mixing Height, ZI
!                 Receptor Height, ZR
!
!        OUTPUTS: Vertical Term, FSUBZ
!
!        ASSUMPTIONS:   Vertical term for UNSTAB plumes includes
!                       one-half of reflection terms corresponding
!                       to the updraft portion of the plume.  Plume
!                       heights and sigma-z's are passed as arguments.
!
!        CALLED FROM:   WRAP, LIFT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
      REAL :: HE1 , HE2 , SZ1 , SZ2 , FACT , SZARG , HEARG1 , HEARG2 ,  &
     &        A1 , A2 , A3 , A4 , TWOIZI , SUM , T1 , T2 , TERM , V
      REAL :: HE1TMP , HE2TMP , ZITMP
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'VRTCBL'
      V = 0.0
 
      IF ( ZR.EQ.0.0 ) THEN
!        Vertical Term for Case With FLAT Terrain and No Flagpole
!        Receptor (ZR = 0.0)
         SUM = 0.0
 
         DO I = 0 , 1000
            T1 = 0.0
            T2 = 0.0
            TWOIZI = 2.*I*ZI*FACT
!           Check for FACT < 0 and skip first term.
            IF ( FACT.LT.0. .AND. I.EQ.0 ) GOTO 50
 
            HEARG1 = TWOIZI + HE1
            HEARG2 = TWOIZI + HE2
            A1 = (-0.5/(SZ1*SZ1))*(HEARG1)*(HEARG1)
            IF ( A1.GT.EXPLIM ) T1 = EXP(A1)
            A2 = (-0.5/(SZ2*SZ2))*(HEARG2)*(HEARG2)
            IF ( A2.GT.EXPLIM ) T2 = EXP(A2)
 
!           Sum the Plume 1 and Plume 2 Portions
            TERM = (LAMDA1/SZ1)*T1 + (LAMDA2/SZ2)*T2
            SUM = SUM + TERM
 
!           Check for Convergence of Summation Term
!              Exit Loop
            IF ( ABS(TERM).LE.5.0E-7*ABS(SUM) ) GOTO 100
 
 50      ENDDO
 
!        Calculate Total Vert. Term - (2.*) was Removed for Optimization
 100     V = 2.*SUM
 
      ELSEIF ( ZR.LE.ZI ) THEN
!        Vertical Term for Case of ZR .NE. 0.0
!        First adjust for terrain below stack base with ZR < 0,
!        by keeping HE and ZI horizontal.
         HE1TMP = MAX(HE1,HE1-ZR)
         HE2TMP = MAX(HE2,HE2-ZR)
         ZITMP = MAX(ZI,ZI-ZR)
 
         SUM = 0.0
 
         DO I = 0 , 1000
            T1 = 0.0
            T2 = 0.0
            TWOIZI = 2.*I*ZITMP*FACT
!           Check for FACT < 0 and skip first term.
            IF ( FACT.LT.0. .AND. I.EQ.0 ) GOTO 150
!
!      Note:  The following code can be used for the indirect plume
!      as well as the direct plume, since HEn, for the indirect plume,
!      already contains ZI, and thus represents the first "reflection"
!      off the top of the mixed layer.
!
            HEARG1 = TWOIZI + HE1TMP
            HEARG2 = TWOIZI + HE2TMP
            A1 = (-0.5/(SZ1*SZ1))*(ZR-(HEARG1))*(ZR-(HEARG1))
            A2 = (-0.5/(SZ1*SZ1))*(ZR+(HEARG1))*(ZR+(HEARG1))
            IF ( A1.GT.EXPLIM ) T1 = EXP(A1)
            IF ( A2.GT.EXPLIM ) T1 = T1 + EXP(A2)
            A3 = (-0.5/(SZ2*SZ2))*(ZR-(HEARG2))*(ZR-(HEARG2))
            A4 = (-0.5/(SZ2*SZ2))*(ZR+(HEARG2))*(ZR+(HEARG2))
            IF ( A3.GT.EXPLIM ) T2 = EXP(A3)
            IF ( A4.GT.EXPLIM ) T2 = T2 + EXP(A4)
 
!           Sum the Plume 1 and Plume 2 Portions
            TERM = (LAMDA1/SZ1)*T1 + (LAMDA2/SZ2)*T2
            SUM = SUM + TERM
 
!           Check for Convergence of Summation Term
!              Exit Loop
            IF ( ABS(TERM).LE.1.0E-6*ABS(SUM) ) GOTO 200
 
 150     ENDDO
 
 200     V = SUM
 
      ELSE
!        Receptor is above mixing height, set V=0.
         V = 0.0
 
      ENDIF
 
!     Calculate FSUBZ from V;  FSUBZ = V / SQRT(2*PI)
!     (Note that 1/SZ term is included in V)
      FSUBZ = V/SRT2PI
 
      CONTINUE
      END
!*==PFRACT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PFRACT(HEARG)
!***********************************************************************
!        PFRACT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Fraction of Plume Material Below HCRIT
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Plume Height, HEARG
!                 Vertical Dispersion Parameter, SZEFF
!                 Mixing/Reflection Height, HSBL (= max(zi,he))
!                 Critical Dividing Streamline Height, HCRIT
!
!        OUTPUTS: Fraction of plume below HCRIT, PHEE
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
      REAL :: TWOIZI , HCINT , HEARG
 
      DOUBLE PRECISION A1 , A2 , A3 , A4 , A5 , A6 , B1 , B2 , B3 , B4 ,&
     &                 B5 , B6 , T , SUM , ERFX
 
      SAVE 
!     Variable Initializations
      MODNAM = 'PFRACT'
      PHEE = 0.0
 
      IF ( STABLE .AND. (HCRIT.GT.0.0) ) THEN
 
!        Define HCINT = AMIN1( HSBL, HCRIT) as the limit of the integral,
!        where HSBL = AMAX1( HE, ZI).
         HCINT = AMIN1(HSBL,HCRIT)
 
!        Calculate Terms Corresponding to n=0.
         A1 = (HCINT-HEARG)/(RTOF2*SZ)
         A2 = (HCINT+HEARG)/(RTOF2*SZ)
         B1 = ERFX(A1)
         B2 = ERFX(A2)
 
!        Calculate Summation Term.
         SUM = 0.0
         DO I = 1 , 100
            T = 0.0
!           Use HSBL (set in PCALC = max(HE,ZI)) instead of ZI.
            TWOIZI = 2.*I*HSBL
            A3 = (HCINT-HEARG+TWOIZI)/(RTOF2*SZ)
            A4 = (HCINT+HEARG+TWOIZI)/(RTOF2*SZ)
            A5 = (HCINT-HEARG-TWOIZI)/(RTOF2*SZ)
            A6 = (HCINT+HEARG-TWOIZI)/(RTOF2*SZ)
            B3 = ERFX(A3)
            B4 = ERFX(A4)
            B5 = ERFX(A5)
            B6 = ERFX(A6)
 
            T = B3 + B4 + B5 + B6
            SUM = SUM + T
 
!           Check for convergence of summation term
!              Exit Loop
            IF ( ABS(T).LE.1.0E-6*ABS(SUM) ) GOTO 50
 
         ENDDO
 
 50      PHEE = 0.5*(B1+B2+SUM)
 
!        Check for PHEE > 1.01 and Set = 1.0 (this patch may need to be changed).
         IF ( PHEE.GT.1.01 ) THEN
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'I','405',DUMMY)
            PHEE = 1.0
         ENDIF
 
      ENDIF
 
      CONTINUE
      END
!*==ERFX.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      FUNCTION ERFX(ARG)
!***********************************************************************
!        ERFX Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Error Function, Using Method Documented
!                 on Page 187 of "Approximations for Digital Computers"
!                 by Cecil Hastings, Princeton University Press, 1955
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Error Function Argument, ARG
!
!        OUTPUTS: Error Function Value, ERFX
!
!        CALLED FROM:   PFRACT
!***********************************************************************
 
!     Variable Declarations
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      DOUBLE PRECISION ARG , X , ERFX
 
!     Variable Initializations
      MODNAM = 'ERFX'
 
      IF ( ARG.GT.4.0 ) THEN
         ERFX = 1.0
      ELSEIF ( ARG.LT.-4.0 ) THEN
         ERFX = -1.0
      ELSEIF ( ABS(ARG).LT.1.0E-10 ) THEN
         ERFX = 0.0
      ELSE
         X = ABS(ARG)
         ERFX = 1. - 1./(1.+X*(0.705230784E-1+X*(0.422820123E-1+X*(     &
     &          0.92705272E-2+                                          &
     &          X*(0.1520143E-3+X*(0.2765672E-3+X*0.430638E-4))))))**16.
         IF ( ARG.LT.0.0 ) ERFX = -ERFX
      ENDIF
 
      CONTINUE
      END
!*==SUMVAL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SUMVAL
!***********************************************************************
!                 SUMVAL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Sums HRVAL to AVEVAL and ANNVAL Arrays
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  HRVAL - Hourly Value for (IREC,ISRC) Combination
!                 Averaging Period Options
!                 Source Groupings
!
!        OUTPUTS: Updated Sums of AVEVAL and ANNVAL Arrays
!
!        CALLED FROM:   PCALC
!                       VCALC
!                       ACALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'SUMVAL'
 
!     Begin LOOP Over Output Types
      DO ITYP = 1 , NUMTYP
         IF ( HRVAL(ITYP).NE.0.0 ) THEN
!           Begin Source Group LOOP
            DO IGRP = 1 , NUMGRP
!              Check for Source Belonging to Group
               IF ( IGROUP(ISRC,IGRP).EQ.1 ) THEN
!                 Begin Averaging Period LOOP
                  DO IAVE = 1 , NUMAVE
                     AVEVAL(IREC,IGRP,IAVE,ITYP) = HRVAL(ITYP)          &
     &                  + AVEVAL(IREC,IGRP,IAVE,ITYP)
                  ENDDO
!                 End Averaging Period LOOP
                  IF ( PERIOD .OR. ANNUAL ) THEN
                     IF ( .NOT.SCIM .OR. (SCIM .AND. .NOT.WETSCIM) )    &
     &                    ANNVAL(IREC,IGRP,ITYP) = HRVAL(ITYP)          &
     &                    + ANNVAL(IREC,IGRP,ITYP)
                     IF ( SCIM .AND. WETSCIM .AND. WETHR )              &
     &                    ANNVALW(IREC,IGRP,ITYP) = HRVAL(ITYP)         &
     &                    + ANNVALW(IREC,IGRP,ITYP)
                     IF ( SCIM .AND. WETSCIM .AND. SCIMHR )             &
     &                    ANNVALD(IREC,IGRP,ITYP) = HRVALD(ITYP)        &
     &                    + ANNVALD(IREC,IGRP,ITYP)
                  ENDIF
                  IF ( ISEAHR(IGRP).EQ.1 )                              &
     &                 SHVALS(IREC,IGRP,ISEAS,IHOUR,ITYP) = HRVAL(ITYP) &
     &                 + SHVALS(IREC,IGRP,ISEAS,IHOUR,ITYP)
               ENDIF
            ENDDO
!           End Source Group LOOP
         ENDIF
      ENDDO
!     End LOOP Over Output Types
 
      CONTINUE
      END
!*==AVER.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE AVER
!***********************************************************************
!                 AVER Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Short Term (<=24 hr) Average Concentrations
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Averaging Time Option Switches
!                 Updated Array of Cumulative Values, AVEVAL
!
!        OUTPUTS: Updated Array of Averages, AVEVAL
!
!        CALLED FROM: HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: SNUM
 
!     Variable Initializations
      MODNAM = 'AVER'
 
      IF ( KAVE(IAVE).NE.1 ) THEN
!        Calculate Denominator Considering Calms and Missing,
!        Skipping Averaging if Averaging Period is 1-Hour
         SNUM = AMAX0((NUMHRS(IAVE)-NUMCLM(IAVE)-NUMMSG(IAVE)),         &
     &          NINT(NUMHRS(IAVE)*0.75+0.4))
!        Begin Source Group LOOP
         DO IGRP = 1 , NUMGRP
!           Begin Receptor LOOP
            DO IREC = 1 , NUMREC
               AVEVAL(IREC,IGRP,IAVE,1) = (1./SNUM)                     &
     &            *AVEVAL(IREC,IGRP,IAVE,1)
            ENDDO
!           End Receptor LOOP
         ENDDO
!        End Source Group LOOP
      ENDIF
 
      CONTINUE
      END
!*==HIVALS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HIVALS
!***********************************************************************
!                 HIVALS Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Updates High Value Tables
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To change subroutine name MAXVAL to MAXVALUE to
!                    avoid conflicts with intrinsic function MAXVAL under
!                    Fortran 90.  R. Brode, PES, 12/29/97
!
!        INPUTS:  High Value Option Switches
!                 Array of CONC or DEPOS Averages
!
!        OUTPUTS: Updated High Value Arrays
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'HIVALS'
 
!     Check for High/Max Value Options - Skip Update If KAVE=1,
!     And No CALCS Were Made for the Current Hour
      IF ( CALCS .OR. KAVE(IAVE).NE.1 ) THEN
         IF ( INHI(IAVE).EQ.1 ) THEN
            DO ITYP = 1 , NUMTYP
!              Update High Values for Each Receptor            ---   CALL NHIGH
               CALL NHIGH
            ENDDO
         ENDIF
         IF ( MAXAVE(IAVE).EQ.1 ) THEN
            DO ITYP = 1 , NUMTYP
!              Update Maximum Value Table for KAVE             ---   CALL MAXVALUE
               CALL MAXVALUE
            ENDDO
         ENDIF
      ENDIF
!     Reset Counters for This Averaging Period
      NUMHRS(IAVE) = 0
      NUMCLM(IAVE) = 0
      NUMMSG(IAVE) = 0
 
      CONTINUE
      END
!*==NHIGH.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE NHIGH
!***********************************************************************
!                 NHIGH Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Update Highest Value by Receptor Arrays
!                 NVAL = 6 Assigned in PARAMETER Statement
!                 Note: For duplicate values, the earlier occurrence keeps its
!                       rank within the array
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  High Value Options
!                 Array of CONC or DEPOS Averages
!                 Averaging Period
!
!        OUTPUTS: Updated Highest Value Array
!                 Updated Highest Date Array
!
!        CALLED FROM:   HIVALS
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: J
 
!     Variable Initializations
      MODNAM = 'NHIGH'
 
!     Begin Source Group LOOP
      DO IGRP = 1 , NUMGRP
!        Begin Receptor LOOP
         RECEPTOR_LOOP:DO IREC = 1 , NUMREC
            IF ( NHIVAL.GT.1 ) THEN
               IF ( AVEVAL(IREC,IGRP,IAVE,ITYP)                         &
     &              .GT.HIVALU(IREC,NHIVAL,IGRP,IAVE,ITYP) ) THEN
                  DO J = NHIVAL - 1 , 1 , -1
                     IF ( AVEVAL(IREC,IGRP,IAVE,ITYP)                   &
     &                    .LE.HIVALU(IREC,J,IGRP,IAVE,ITYP) ) THEN
                        HIVALU(IREC,J+1,IGRP,IAVE,ITYP)                 &
     &                     = AVEVAL(IREC,IGRP,IAVE,ITYP)
                        IF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).EQ.0 )&
     &                       THEN
                           HCLMSG(IREC,J+1,IGRP,IAVE,ITYP) = ' '
                        ELSE
!                          Set Indicator Of Calm and Msg    ---   CALL HSETFG
                           CALL HSETFG(0,J)
                        ENDIF
                        NHIDAT(IREC,J+1,IGRP,IAVE,ITYP) = KURDAT
!                       Exit Block
                        GOTO 50
                     ELSE
                        HIVALU(IREC,J+1,IGRP,IAVE,ITYP)                 &
     &                     = HIVALU(IREC,J,IGRP,IAVE,ITYP)
                        HCLMSG(IREC,J+1,IGRP,IAVE,ITYP)                 &
     &                     = HCLMSG(IREC,J,IGRP,IAVE,ITYP)
                        NHIDAT(IREC,J+1,IGRP,IAVE,ITYP)                 &
     &                     = NHIDAT(IREC,J,IGRP,IAVE,ITYP)
                        IF ( J.EQ.1 ) THEN
                           HIVALU(IREC,1,IGRP,IAVE,ITYP)                &
     &                        = AVEVAL(IREC,IGRP,IAVE,ITYP)
                           IF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE)    &
     &                          .EQ.0 ) THEN
                              HCLMSG(IREC,1,IGRP,IAVE,ITYP) = ' '
                           ELSE
!                             Set Indicator Of Calm and Msg ---   CALL HSETFG
                              CALL HSETFG(1,1)
                           ENDIF
                           NHIDAT(IREC,1,IGRP,IAVE,ITYP) = KURDAT
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ELSEIF ( NHIVAL.EQ.1 ) THEN
               IF ( AVEVAL(IREC,IGRP,IAVE,ITYP)                         &
     &              .GT.HIVALU(IREC,1,IGRP,IAVE,ITYP) ) THEN
                  HIVALU(IREC,1,IGRP,IAVE,ITYP)                         &
     &               = AVEVAL(IREC,IGRP,IAVE,ITYP)
                  IF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).EQ.0 ) THEN
                     HCLMSG(IREC,1,IGRP,IAVE,ITYP) = ' '
                  ELSE
!                    Set Indicator Of Calm and Missing      ---   CALL HSETFG
                     CALL HSETFG(1,1)
                  ENDIF
                  NHIDAT(IREC,1,IGRP,IAVE,ITYP) = KURDAT
               ENDIF
            ENDIF
 50      ENDDO RECEPTOR_LOOP
!        End Receptor LOOP
      ENDDO
!     End Source Group LOOP
 
      CONTINUE
      END
!*==HSETFG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HSETFG(INDT,J)
!***********************************************************************
!                 HSETFG Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Set Calm and Missing Flag Of the Result
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To correct error in order of indices for array
!                    HCLMSG on first assignment to 'b' - 9/29/92
!
!        INPUTS:  High Value Options
!                 Array of CONC or DEPOS Averages
!                 Averaging Period
!
!        OUTPUTS: Updated Highest Value Flag Array
!
!        CALLED FROM:   NHIGH
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: J , INDT
 
!     Variable Initializations
      MODNAM = 'HSETFG'
 
      IF ( INDT.EQ.0 ) THEN
!        Set Indicator Of Calm and Missing
         IF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).EQ.0 ) THEN
            HCLMSG(IREC,J+1,IGRP,IAVE,ITYP) = 'c'
         ELSEIF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            HCLMSG(IREC,J+1,IGRP,IAVE,ITYP) = 'm'
         ELSEIF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            HCLMSG(IREC,J+1,IGRP,IAVE,ITYP) = 'b'
         ENDIF
      ELSEIF ( INDT.EQ.1 ) THEN
!        Set Indicator Of Calm and Missing
         IF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).EQ.0 ) THEN
            HCLMSG(IREC,1,IGRP,IAVE,ITYP) = 'c'
         ELSEIF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            HCLMSG(IREC,1,IGRP,IAVE,ITYP) = 'm'
         ELSEIF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            HCLMSG(IREC,1,IGRP,IAVE,ITYP) = 'b'
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==MAXVALUE.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MAXVALUE
!***********************************************************************
!                 MAXVALUE Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Update Overall Maximum Value Arrays
!                 NMAX = 50 Assigned in PARAMETER Statement
!                 Note: For duplicate values, the earlier occurrence keeps
!                       its rank within the array
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Maximum Value Table Options
!                 Array of CONC or DEPOS Averages
!                 Averaging Period
!
!        OUTPUTS: Updated Maximum Value Array
!                 Updated Maximum Date Array
!                 Updated Maximum Receptor Array
!
!        CALLED FROM:   HIVALS
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: J
 
!     Variable Initializations
      MODNAM = 'MAXVALUE'
 
!     Begin Source Group LOOP
      DO IGRP = 1 , NUMGRP
!        Begin Receptor LOOP
         RECEPTOR_LOOP:DO IREC = 1 , NUMREC
            IF ( NMXVAL.GT.1 ) THEN
               IF ( AVEVAL(IREC,IGRP,IAVE,ITYP)                         &
     &              .GT.RMXVAL(NMXVAL,IGRP,IAVE,ITYP) ) THEN
                  DO J = NMXVAL - 1 , 1 , -1
                     IF ( AVEVAL(IREC,IGRP,IAVE,ITYP)                   &
     &                    .LE.RMXVAL(J,IGRP,IAVE,ITYP) ) THEN
                        RMXVAL(J+1,IGRP,IAVE,ITYP)                      &
     &                     = AVEVAL(IREC,IGRP,IAVE,ITYP)
                        IF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).EQ.0 )&
     &                       THEN
                           MCLMSG(J+1,IGRP,IAVE,ITYP) = ' '
                        ELSE
!                          Set Indicator Of Calm and Msg    ---   CALL MSETFG
                           CALL MSETFG(0,J)
                        ENDIF
                        MXDATE(J+1,IGRP,IAVE,ITYP) = KURDAT
                        MXLOCA(J+1,IGRP,IAVE,ITYP) = IREC
!                       Exit Block
                        GOTO 50
                     ELSE
                        RMXVAL(J+1,IGRP,IAVE,ITYP)                      &
     &                     = RMXVAL(J,IGRP,IAVE,ITYP)
                        MXDATE(J+1,IGRP,IAVE,ITYP)                      &
     &                     = MXDATE(J,IGRP,IAVE,ITYP)
                        MCLMSG(J+1,IGRP,IAVE,ITYP)                      &
     &                     = MCLMSG(J,IGRP,IAVE,ITYP)
                        MXLOCA(J+1,IGRP,IAVE,ITYP)                      &
     &                     = MXLOCA(J,IGRP,IAVE,ITYP)
                        IF ( J.EQ.1 ) THEN
                           RMXVAL(1,IGRP,IAVE,ITYP)                     &
     &                        = AVEVAL(IREC,IGRP,IAVE,ITYP)
                           IF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE)    &
     &                          .EQ.0 ) THEN
                              MCLMSG(1,IGRP,IAVE,ITYP) = ' '
                           ELSE
!                             Set Indicator Of Calm and Msg ---   CALL MSETFG
                              CALL MSETFG(1,1)
                           ENDIF
                           MXDATE(1,IGRP,IAVE,ITYP) = KURDAT
                           MXLOCA(1,IGRP,IAVE,ITYP) = IREC
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ELSEIF ( NMXVAL.EQ.1 ) THEN
               IF ( AVEVAL(IREC,IGRP,IAVE,ITYP)                         &
     &              .GT.RMXVAL(1,IGRP,IAVE,ITYP) ) THEN
                  RMXVAL(1,IGRP,IAVE,ITYP) = AVEVAL(IREC,IGRP,IAVE,ITYP)
                  IF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).EQ.0 ) THEN
                     MCLMSG(1,IGRP,IAVE,ITYP) = ' '
                  ELSE
!                    Set Indicator Of Calm and Missing      ---   CALL MSETFG
                     CALL MSETFG(1,1)
                  ENDIF
                  MXDATE(1,IGRP,IAVE,ITYP) = KURDAT
                  MXLOCA(1,IGRP,IAVE,ITYP) = IREC
               ENDIF
            ENDIF
 50      ENDDO RECEPTOR_LOOP
!        End Receptor LOOP
      ENDDO
!     End Source Group LOOP
 
      CONTINUE
      END
!*==MSETFG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MSETFG(INDT,J)
!***********************************************************************
!                 MSETFG Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Set Calm and Missing Flag Of the Max Result
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Maximum Value Table Options
!                 Array of CONC or DEPOS Averages
!                 Averaging Period
!
!        OUTPUTS: Updated Maximum Value Flag Array
!
!        CALLED FROM:   MAXVALUE
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: J , INDT
 
!     Variable Initializations
      MODNAM = 'MSETFG'
 
      IF ( INDT.EQ.0 ) THEN
!        Set Indicator Of Calm and Missing
         IF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).EQ.0 ) THEN
            MCLMSG(J+1,IGRP,IAVE,ITYP) = 'c'
         ELSEIF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            MCLMSG(J+1,IGRP,IAVE,ITYP) = 'm'
         ELSEIF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            MCLMSG(J+1,IGRP,IAVE,ITYP) = 'b'
         ENDIF
      ELSEIF ( INDT.EQ.1 ) THEN
!        Set Indicator Of Calm and Missing
         IF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).EQ.0 ) THEN
            MCLMSG(1,IGRP,IAVE,ITYP) = 'c'
         ELSEIF ( NUMCLM(IAVE).EQ.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            MCLMSG(1,IGRP,IAVE,ITYP) = 'm'
         ELSEIF ( NUMCLM(IAVE).NE.0 .AND. NUMMSG(IAVE).NE.0 ) THEN
            MCLMSG(1,IGRP,IAVE,ITYP) = 'b'
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==MAXFIL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MAXFIL
!***********************************************************************
!                 MAXFIL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Update Maximum Value File (>Threshold)
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   Moved check for RSTSAV (SAVEFILE option) outside
!                    the receptor loop, and replaced 'read to end' loop
!                    with POSITION='APPEND' in OPEN statement for
!                    Fortran 90 version.
!                    R.W. Brode, PES, Inc.,  6/23/98
!
!        INPUTS:  Maximum File Options
!                 Array of CONC or DEPOS Averages
!                 Averaging Period
!
!        OUTPUTS: Updated Maximum Value File
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'MAXFIL'
 
!     Check for High/Max Value Options - Skip Update If KAVE=1,
!     And No CALCS Were Made for the Current Hour
      IF ( CALCS .OR. KAVE(IAVE).NE.1 ) THEN
!        Begin Source Group LOOP
         DO IGRP = 1 , NUMGRP
!           Check for MAXIFILE Option for This IGRP,IAVE Combination
            IF ( MAXFLE(IGRP,IAVE).EQ.1 ) THEN
!              Begin Receptor LOOP
               DO IREC = 1 , NUMREC
!                 For the Values Over Threshold
                  IF ( AVEVAL(IREC,IGRP,IAVE,1).GE.THRESH(IGRP,IAVE) )  &
     &                 WRITE (IMXUNT(IGRP,IAVE),THRFRM,ERR=99)          &
     &                        KAVE(IAVE) , GRPID(IGRP) , KURDAT ,       &
     &                        AXR(IREC) , AYR(IREC) , AZELEV(IREC) ,    &
     &                        AZHILL(IREC) , AZFLAG(IREC) ,             &
     &                        AVEVAL(IREC,IGRP,IAVE,1)
               ENDDO
!              End Receptor LOOP
               IF ( RSTSAV ) THEN
!                 Saving Intermediate Results to File for Later Re-start
!                 Close MAXIFILE and Reposition to End
                  CLOSE (IMXUNT(IGRP,IAVE))
                  OPEN (IMXUNT(IGRP,IAVE),FILE=THRFIL(IGRP,IAVE),       &
     &                  POSITION='APPEND')
               ENDIF
            ENDIF
         ENDDO
!        End Source Group LOOP
      ENDIF
 
      GOTO 999
 
!     WRITE Error Message for Problem Writing to Maximum Value File
 99   WRITE (DUMMY,'("MAXFL",I3.3)') IMXUNT(IGRP,IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==POSTFL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE POSTFL
!***********************************************************************
!                 POSTFL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Write Concurrent Values to File for Postprocessing
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   Replaced 'read to end' loop with POSITION='APPEND'
!                    in OPEN statements for Fortran 90 version with
!                    RSTSAV (SAVEFILE option).
!                    R.W. Brode, PES, Inc.,  6/23/98
!
!        INPUTS:  Postprocessing File Options
!                 Array of CONC or DEPOS Averages
!
!        OUTPUTS: Postprocessor Files
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'POSTFL'
 
!     Begin Source Group LOOP
      DO IGRP = 1 , NUMGRP
!        Check for POSTFILE Option for This IGRP,IAVE Combination
         IF ( IPSTFL(IGRP,IAVE).EQ.1 ) THEN
            IF ( IPSFRM(IGRP,IAVE).EQ.0 ) THEN
!              WRITE Results to Unformatted POSTFILE
               WRITE (IPSUNT(IGRP,IAVE),ERR=99) KURDAT , KAVE(IAVE) ,   &
     &                GRPID(IGRP) ,                                     &
     &                ((AVEVAL(IREC,IGRP,IAVE,ITYP),IREC=1,NUMREC),     &
     &                ITYP=1,NUMTYP)
               IF ( RSTSAV ) THEN
!                 Saving Intermediate Results to File for Later Re-start
!                 Close POSTFILE and Reposition to End
                  CLOSE (IPSUNT(IGRP,IAVE))
                  OPEN (IPSUNT(IGRP,IAVE),FILE=PSTFIL(IGRP,IAVE),       &
     &                  FORM='UNFORMATTED',POSITION='APPEND')
               ENDIF
            ELSE
!              WRITE Results to Formatted Plot File
!              Begin Receptor LOOP
               DO IREC = 1 , NUMREC
                  WRITE (IPSUNT(IGRP,IAVE),PSTFRM,ERR=99) AXR(IREC) ,   &
     &                   AYR(IREC) ,                                    &
     &                   (AVEVAL(IREC,IGRP,IAVE,ITYP),ITYP=1,NUMTYP) ,  &
     &                   AZELEV(IREC) , AZHILL(IREC) , AZFLAG(IREC) ,   &
     &                   CHRAVE(IAVE) , GRPID(IGRP) , KURDAT ,          &
     &                   NETID(IREC)
               ENDDO
!              End Receptor LOOP
               IF ( RSTSAV ) THEN
!                 Saving Intermediate Results to File for Later Re-start
!                 Close POSTFILE and Reposition to End
                  CLOSE (IPSUNT(IGRP,IAVE))
                  OPEN (IPSUNT(IGRP,IAVE),FILE=PSTFIL(IGRP,IAVE),       &
     &                  FORM='FORMATTED',POSITION='APPEND')
               ENDIF
            ENDIF
         ENDIF
      ENDDO
!     End Source Group LOOP
 
      GOTO 999
 
!     WRITE Error Message for Problem Writing to Postprocessor File
 99   WRITE (DUMMY,'("PSTFL",I3.3)') IPSUNT(IGRP,IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==TOXXFL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE TOXXFL
!***********************************************************************
!                 TOXXFL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Update TOXXFILE Buffers, and Write Out if Full
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 29, 1992
!
!        INPUTS:  TOXXFILE Options
!                 Array of CONC or DEPOS Averages
!                 Averaging Period
!
!        OUTPUTS: Updated TOXXFILE Buffers and File
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IG , ICODE
      REAL :: CUTOFF
 
!     Variable Initializations
      MODNAM = 'TOXXFL'
 
!     Check for TOXXFILE Option - Skip Update If KAVE=1,
!     And No CALCS Were Made for the Current Hour
      IF ( ITOXFL(IAVE).EQ.1 .AND. (CALCS .OR. KAVE(IAVE).NE.1) ) THEN
!        Convert TOXXFILE Threshold to User Units
         CUTOFF = TOXTHR(IAVE)*EMIFAC(1)
 
!        Begin Receptor LOOP
         DO IREC = 1 , NUMREC
 
!           Begin Source Group LOOP
            DO IGRP = 1 , NUMGRP
 
!              For the Values Over Threshold (in user units), Fill Buffers
               IF ( AVEVAL(IREC,IGRP,IAVE,1).GE.CUTOFF ) THEN
                  DO IG = 1 , NUMGRP
!                    Loop Through Groups and Write Values to Buffer
                     IPAIR = IPAIR + 1
                     ICODE = 100000*ILINE + 1000*IG + IREC
                     IDCONC(IAVE,IPAIR) = ICODE
!                    Convert CONC Values Back to Units of g/s
                     TXCONC(IAVE,IPAIR) = AVEVAL(IREC,IG,IAVE,1)        &
     &                  /EMIFAC(1)
                     IF ( IPAIR.EQ.NPAIR ) THEN
!                       Write Out Full Buffers and Reset Counter
                        WRITE (ITXUNT(IAVE),ERR=99)                     &
     &                         (IDCONC(IAVE,I),I=1,NPAIR)
                        WRITE (ITXUNT(IAVE),ERR=99)                     &
     &                         (TXCONC(IAVE,I),I=1,NPAIR)
                        IPAIR = 0
                     ENDIF
                  ENDDO
!                 Exit Source Group LOOP
                  GOTO 50
               ENDIF
 
            ENDDO
!           End Source Group LOOP
 
 50      ENDDO
!        End Receptor LOOP
      ENDIF
 
      GOTO 999
 
!     WRITE Error Message for Problem Writing to TOXXFILE
 99   WRITE (DUMMY,'("TOXFL",I3.3)') ITXUNT(IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==PRTDAY.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRTDAY
!***********************************************************************
!                 PRTDAY Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Write Concurrent Values to Printed Output File
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To adjust format statement 9082 for BOUNDARY receptors
!                    to better accommodate UTM coordinates - 9/29/92
!
!        INPUTS:  Postprocessing File Options
!                 Array of CONC or DEPOS Averages
!
!        OUTPUTS: Postprocessor Files
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K , II , NX , NY , INDZ , INDC , ISRF , INDEXW
      REAL :: YCOVAL , XRMS , YRMS , DIST , DIR
      CHARACTER BUF132*132
 
!     Variable Initializations
      MODNAM = 'PRTDAY'
 
!     Begin Source Group LOOP
      DO IGRP = 1 , NUMGRP
 
!        Fill Work Array With SRCIDs For This Group
         INDGRP = 0
         DO ISRC = 1 , NUMSRC
            IF ( IGROUP(ISRC,IGRP).EQ.1 ) THEN
               INDGRP = INDGRP + 1
               WORKID(INDGRP) = SRCID(ISRC)
            ENDIF
         ENDDO
!        Check for More Than 31 Sources Per Group
         INDEXW = MIN(31,NSRC)
         IF ( INDGRP.GT.INDEXW ) THEN
            WORKID(INDEXW) = ' . . . '
            INDGRP = INDEXW
         ENDIF
 
!        Print Results for Receptor Networks
!        Set Number of Columns Per Page, NCPP
         NCPP = 9
!        Set Number of Rows Per Page, NRPP
         NRPP = 40
!        Begin LOOP Through Networks
         DO I = 1 , INNET
!           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1 , NPPX
               DO NY = 1 , NPPY
                  CALL HEADER
                  WRITE (IOUNIT,9032) CHRAVE(IAVE) ,                    &
     &                                (CHIDEP(II,ITYP),II=1,6) , IHOUR ,&
     &                                JDAY , IYR , GRPID(IGRP) ,        &
     &                                (WORKID(K),K=1,INDGRP)
                  WRITE (IOUNIT,9037) NTID(I) , NTTYP(I)
 9037             FORMAT (/35X,'*** NETWORK ID: ',A8,                   &
     &                    ' ;  NETWORK TYPE: ',A8,' ***')
!                 Print The Value By Groups
                  WRITE (IOUNIT,9011) CHIDEP(3,ITYP) , POLLUT ,         &
     &                                OUTLBL(ITYP)
                  IF ( NX.EQ.NPPX ) THEN
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ENDIF
                  ELSE
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ENDIF
                  ENDIF
                  WRITE (IOUNIT,9010)
 9010             FORMAT (66(' -')/)
                  IF ( NY.EQ.NPPY ) THEN
                     DO K = 1 + NRPP*(NY-1) , NUMYPT(I)
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AVEVAL(INDZ+J-1,IGRP,IAVE,ITYP),     &
     &                            J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AVEVAL(INDZ+J-1,IGRP,IAVE,ITYP),     &
     &                            J=1+NCPP*(NX-1),NCPP*NX)
                        ENDIF
                     ENDDO
                  ELSE
                     DO K = 1 + NRPP*(NY-1) , NRPP*NY
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AVEVAL(INDZ+J-1,IGRP,IAVE,ITYP),     &
     &                            J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AVEVAL(INDZ+J-1,IGRP,IAVE,ITYP),     &
     &                            J=1+NCPP*(NX-1),NCPP*NX)
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
            ENDDO
         ENDDO
!        End LOOP Through Networks
 
         IF ( IRSTAT(4).NE.0 .OR. IRSTAT(8).NE.0 ) THEN
!RWB        Include EVALCART receptors with DISCCART receptors.  2/14/95
!           Print Out The Coord. & Concentrations For Discrete Cart Receptors
            INDC = 0
            DO IREC = 1 , NUMREC
               IF ( RECTYP(IREC).EQ.'DC' ) THEN
                  INDC = INDC + 1
                  IF ( MOD(INDC-1,80).EQ.0 ) THEN
                     CALL HEADER
                     WRITE (IOUNIT,9032) CHRAVE(IAVE) ,                 &
     &                      (CHIDEP(II,ITYP),II=1,6) , IHOUR , JDAY ,   &
     &                      IYR , GRPID(IGRP) , (WORKID(K),K=1,INDGRP)
                     WRITE (IOUNIT,9043)
 9043                FORMAT (/45X,                                      &
     &                      '*** DISCRETE CARTESIAN RECEPTOR POINTS ***'&
     &                      )
                     WRITE (IOUNIT,9011) CHIDEP(3,ITYP) , POLLUT ,      &
     &                      OUTLBL(ITYP)
                     WRITE (IOUNIT,9048) CHIDEP(3,ITYP) , CHIDEP(3,ITYP)
 9048                FORMAT (6X,' X-COORD (M)   Y-COORD (M)        ',A4,&
     &                       22X,' X-COORD (M)   Y-COORD (M)        ',  &
     &                       A4,/65(' -'))
                  ENDIF
                  IF ( MOD(INDC,2).NE.0 ) THEN
                     WRITE (BUF132(1:60),9045) AXR(IREC) , AYR(IREC) ,  &
     &                      AVEVAL(IREC,IGRP,IAVE,ITYP)
                  ELSE
                     WRITE (BUF132(61:120),9045) AXR(IREC) , AYR(IREC) ,&
     &                      AVEVAL(IREC,IGRP,IAVE,ITYP)
                     WRITE (IOUNIT,9090) BUF132
                     WRITE (BUF132,9095)
                  ENDIF
               ENDIF
            ENDDO
            IF ( MOD(INDC,2).NE.0 ) THEN
               WRITE (IOUNIT,9090) BUF132
               WRITE (BUF132,9095)
            ENDIF
         ENDIF
 
         IF ( IRSTAT(5).NE.0 ) THEN
!           Print Out The Coord. & Concentrations For Discrete Polar Receptors
            INDC = 0
            DO IREC = 1 , NUMREC
               IF ( RECTYP(IREC).EQ.'DP' ) THEN
                  INDC = INDC + 1
                  XRMS = AXR(IREC) - AXS(IREF(IREC))
                  YRMS = AYR(IREC) - AYS(IREF(IREC))
                  DIST = SQRT(XRMS*XRMS+YRMS*YRMS)
                  DIR = ATAN2(XRMS,YRMS)*RTODEG
                  IF ( DIR.LE.0.0 ) DIR = DIR + 360.
                  IF ( MOD(INDC-1,80).EQ.0 ) THEN
                     CALL HEADER
                     WRITE (IOUNIT,9032) CHRAVE(IAVE) ,                 &
     &                      (CHIDEP(II,ITYP),II=1,6) , IHOUR , JDAY ,   &
     &                      IYR , GRPID(IGRP) , (WORKID(K),K=1,INDGRP)
                     WRITE (IOUNIT,9044)
 9044                FORMAT (/47X,                                      &
     &                       '*** DISCRETE POLAR RECEPTOR POINTS ***')
                     WRITE (IOUNIT,9011) CHIDEP(3,ITYP) , POLLUT ,      &
     &                      OUTLBL(ITYP)
                     WRITE (IOUNIT,9049) CHIDEP(3,ITYP) , CHIDEP(3,ITYP)
 9049                FORMAT (5X,'ORIGIN',59X,'ORIGIN',/5X,              &
     &                     ' SRCID       DIST (M)     DIR (DEG)        '&
     &                     ,A4,18X,                                     &
     &                     ' SRCID       DIST (M)     DIR (DEG)        '&
     &                     ,A4,/65(' -'))
                  ENDIF
                  IF ( MOD(INDC,2).NE.0 ) THEN
                     WRITE (BUF132(1:65),9047) SRCID(IREF(IREC)) ,      &
     &                      DIST , DIR , AVEVAL(IREC,IGRP,IAVE,ITYP)
                  ELSE
                     WRITE (BUF132(66:130),9047) SRCID(IREF(IREC)) ,    &
     &                      DIST , DIR , AVEVAL(IREC,IGRP,IAVE,ITYP)
                     WRITE (IOUNIT,9090) BUF132
                     WRITE (BUF132,9095)
                  ENDIF
               ENDIF
            ENDDO
            IF ( MOD(INDC,2).NE.0 ) THEN
               WRITE (IOUNIT,9090) BUF132
               WRITE (BUF132,9095)
            ENDIF
         ENDIF
 
!        Write Out The Boundary Receptors For The Sources
         IF ( IRSTAT(6).NE.0 ) THEN
            INDC = 0
            IREC = 1
            DO WHILE ( IREC.LE.NUMREC )
               IF ( RECTYP(IREC).EQ.'BD' ) THEN
                  INDC = INDC + 1
                  ISRF = IREF(IREC)
                  IF ( MOD(INDC-1,3).EQ.0 ) THEN
                     CALL HEADER
                     WRITE (IOUNIT,9032) CHRAVE(IAVE) ,                 &
     &                      (CHIDEP(II,ITYP),II=1,6) , IHOUR , JDAY ,   &
     &                      IYR , GRPID(IGRP) , (WORKID(K),K=1,INDGRP)
                     WRITE (IOUNIT,9011) CHIDEP(3,ITYP) , POLLUT ,      &
     &                      OUTLBL(ITYP)
                  ENDIF
                  WRITE (IOUNIT,9082) SRCID(ISRF) , SRCTYP(ISRF) ,      &
     &                                AXS(ISRF) , AYS(ISRF) , AZS(ISRF) &
     &                                , CHIDEP(3,ITYP) , CHIDEP(3,ITYP) &
     &                                , CHIDEP(3,ITYP) ,                &
     &                                (J,AXR(IREC+J-1),AYR(IREC+J-1),   &
     &                                AVEVAL(IREC+J-1,IGRP,IAVE,ITYP),  &
     &                                J=1,36)
 9082             FORMAT (' BOUNDARY RECEPTOR NETWORK OF SOURCE ID: ',  &
     &                    A8,/,5X,' OF SOURCE TYPE: ',A8,               &
     &                    '; WITH ORIGIN AT (',2(F10.2,', '),F10.2,     &
     &                    ')'/3(' (SEC.)  X-COORD    Y-COORD       ',A4,&
     &                    6X),/,                                        &
     &                    12(3(1X,I4,2X,F9.1,',',F10.1,',',F13.5,' ',2X)&
     &                    ,/),/)
                  IREC = IREC + 36
               ELSE
                  IREC = IREC + 1
               ENDIF
            ENDDO
         ENDIF
 
      ENDDO
 
      CONTINUE
!     End Source Group LOOP
 
 9011 FORMAT (/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9013 FORMAT (2X,F10.2,1X,'|',1X,9(F13.5))
 9016 FORMAT (3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT (3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT (3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT (3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9032 FORMAT (20X,'*** CONCURRENT ',A5,1X,6A4,'VALUES',                 &
     &        ' ENDING WITH HOUR ',I2,' FOR DAY ',I3,' OF ',I4,         &
     &        ' ***'/24X,'FOR SOURCE GROUP:',1X,A8,/24X,                &
     &        'INCLUDING SOURCE(S):      ',7(A8,', ',:),/10X,           &
     &        12(A8,', ',:)/10X,12(A8,', ',:))
 9045 FORMAT (6X,2(F12.2,2X),F13.5)
 9047 FORMAT (4X,A8,': ',2(F12.2,2X),F13.5)
 9090 FORMAT (A132)
 9095 FORMAT (132(' '))
      END
!*==RSDUMP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE RSDUMP
!***********************************************************************
!                 RSDUMP Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Save Intermediate Results Arrays for Later Restart
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance.  Specifically, to output the
!                    10-digit date variable (FULLDATE) with 4-digit
!                    year for date comparisons.
!                    Also modified to output arrays associated with
!                    post-1997 PM10 processing.
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        MODIFIED:   Changed parameter for specifying the number of
!                    high annual/period averages from NVAL to NHIANN.
!                    R.W. Brode, PES, Inc.,  4/3/98
!
!        MODIFIED:   Changed parameter for specifying the number of
!                    high annual/period averages from NVAL to NHIANN.
!                    R.W. Brode, PES, Inc.,  4/3/98
!
!        INPUTS:  Current Date Variable
!                 Array Limits
!                 Results Arrays
!
!        OUTPUTS: Unformatted File of Intermediate Results
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K , L , M
 
!     Variable Initializations
      MODNAM = 'RSDUMP'
      NDUMP = NDUMP + 1
 
!     Check for Monthly Averages and Only Dump at End of Month
      IF ( MONTH .AND. .NOT.ENDMON ) GOTO 1000
 
      IF ( SAVFIL.EQ.SAVFL2 .OR. MOD(NDUMP,2).NE.0 ) THEN
         OPEN (UNIT=IDPUNT,ERR=99,FILE=SAVFIL,FORM='UNFORMATTED',       &
     &         IOSTAT=IOERRN,STATUS='UNKNOWN')
         WRITE (IDPUNT) FULLDATE
         WRITE (IDPUNT) NHIVAL , NMXVAL , NUMREC , NUMGRP , NUMAVE ,    &
     &                  NUMTYP
 
         IF ( NHIVAL.GT.0 ) THEN
            WRITE (IDPUNT) (((((HIVALU(I,J,K,L,M),I=1,NUMREC),J=1,NHIVAL&
     &                     ),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
            WRITE (IDPUNT) (((((NHIDAT(I,J,K,L,M),I=1,NUMREC),J=1,NHIVAL&
     &                     ),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
            WRITE (IDPUNT) (((((HCLMSG(I,J,K,L,M),I=1,NUMREC),J=1,NHIVAL&
     &                     ),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
 
            IF ( PM10AVE ) THEN
               WRITE (IDPUNT) NUMYRS
               WRITE (IDPUNT) ((SUMH4H(I,J),I=1,NUMREC),J=1,NUMGRP)
            ENDIF
 
         ENDIF
 
         IF ( NMXVAL.GT.0 ) THEN
            WRITE (IDPUNT) ((((RMXVAL(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
            WRITE (IDPUNT) ((((MXDATE(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
            WRITE (IDPUNT) ((((MXLOCA(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
            WRITE (IDPUNT) ((((MCLMSG(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
         ENDIF
 
         IF ( SEASONHR ) THEN
            WRITE (IDPUNT) (((((SHVALS(I,J,K,L,M),I=1,NUMREC),J=1,NUMGRP&
     &                     ),K=1,4),L=1,24),M=1,NUMTYP)
            WRITE (IDPUNT) ((NSEAHR(I,J),I=1,4),J=1,24)
            WRITE (IDPUNT) ((NSEACM(I,J),I=1,4),J=1,24)
         ENDIF
 
         IF ( PERIOD ) THEN
            WRITE (IDPUNT) IANHRS , IANCLM , IANMSG
            WRITE (IDPUNT) (((ANNVAL(I,J,K),I=1,NUMREC),J=1,NUMGRP),K=1,&
     &                     NUMTYP)
            IF ( MULTYR ) THEN
               WRITE (IDPUNT) (((AMXVAL(I,J,K),I=1,NHIANN),J=1,NUMGRP), &
     &                        K=1,NUMTYP)
               WRITE (IDPUNT) (((IMXLOC(I,J,K),I=1,NHIANN),J=1,NUMGRP), &
     &                        K=1,NUMTYP)
            ENDIF
         ELSEIF ( ANNUAL ) THEN
            WRITE (IDPUNT) IANHRS , IANCLM , IANMSG , NUMYRS
            WRITE (IDPUNT) (((ANNVAL(I,J,K),I=1,NUMREC),J=1,NUMGRP),K=1,&
     &                     NUMTYP)
            WRITE (IDPUNT) (((SUMANN(I,J,K),I=1,NUMREC),J=1,NUMGRP),K=1,&
     &                     NUMTYP)
         ENDIF
 
         CLOSE (IDPUNT)
 
      ELSE
         OPEN (UNIT=IDPUN2,ERR=99,FILE=SAVFL2,FORM='UNFORMATTED',       &
     &         IOSTAT=IOERRN,STATUS='UNKNOWN')
         WRITE (IDPUN2) FULLDATE
         WRITE (IDPUN2) NHIVAL , NMXVAL , NUMREC , NUMGRP , NUMAVE ,    &
     &                  NUMTYP
 
         IF ( NHIVAL.GT.0 ) THEN
            WRITE (IDPUN2) (((((HIVALU(I,J,K,L,M),I=1,NUMREC),J=1,NHIVAL&
     &                     ),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
            WRITE (IDPUN2) (((((NHIDAT(I,J,K,L,M),I=1,NUMREC),J=1,NHIVAL&
     &                     ),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
            WRITE (IDPUN2) (((((HCLMSG(I,J,K,L,M),I=1,NUMREC),J=1,NHIVAL&
     &                     ),K=1,NUMGRP),L=1,NUMAVE),M=1,NUMTYP)
 
            IF ( PM10AVE ) THEN
               WRITE (IDPUN2) NUMYRS
               WRITE (IDPUN2) ((SUMH4H(I,J),I=1,NUMREC),J=1,NUMGRP)
            ENDIF
 
         ENDIF
 
         IF ( NMXVAL.GT.0 ) THEN
            WRITE (IDPUN2) ((((RMXVAL(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
            WRITE (IDPUN2) ((((MXDATE(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
            WRITE (IDPUN2) ((((MXLOCA(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
            WRITE (IDPUN2) ((((MCLMSG(I,J,K,L),I=1,NMXVAL),J=1,NUMGRP),K&
     &                     =1,NUMAVE),L=1,NUMTYP)
         ENDIF
 
         IF ( SEASONHR ) THEN
            WRITE (IDPUN2) (((((SHVALS(I,J,K,L,M),I=1,NUMREC),J=1,NUMGRP&
     &                     ),K=1,4),L=1,24),M=1,NUMTYP)
            WRITE (IDPUN2) ((NSEAHR(I,J),I=1,4),J=1,24)
            WRITE (IDPUN2) ((NSEACM(I,J),I=1,4),J=1,24)
         ENDIF
 
         IF ( PERIOD ) THEN
            WRITE (IDPUN2) IANHRS , IANCLM , IANMSG
            WRITE (IDPUN2) (((ANNVAL(I,J,K),I=1,NUMREC),J=1,NUMGRP),K=1,&
     &                     NUMTYP)
            IF ( MULTYR ) THEN
               WRITE (IDPUN2) (((AMXVAL(I,J,K),I=1,NHIANN),J=1,NUMGRP), &
     &                        K=1,NUMTYP)
               WRITE (IDPUN2) (((IMXLOC(I,J,K),I=1,NHIANN),J=1,NUMGRP), &
     &                        K=1,NUMTYP)
            ENDIF
         ELSEIF ( ANNUAL ) THEN
            WRITE (IDPUN2) IANHRS , IANCLM , IANMSG , NUMYRS
            WRITE (IDPUN2) (((ANNVAL(I,J,K),I=1,NUMREC),J=1,NUMGRP),K=1,&
     &                     NUMTYP)
            WRITE (IDPUN2) (((SUMANN(I,J,K),I=1,NUMREC),J=1,NUMGRP),K=1,&
     &                     NUMTYP)
         ENDIF
 
         CLOSE (IDPUN2)
 
      ENDIF
 
      GOTO 1000
 
 99   CALL ERRHDL(PATH,MODNAM,'E','500','SAVEFILE')
      RUNERR = .TRUE.
 
 1000 CONTINUE
      END
!*==EVLINI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE EVLINI
!***********************************************************************
!                 EVLINI Module of AERMOD
!
!        PURPOSE: Initialize ARC Values for EVALFILE Option
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    November 29, 1993
!
!        REVISIONS:  Added ARCCL() variable for true centerline
!                    calculations.  Changed 7/25/94, R.F. Lee.
!
!        INPUTS:
!
!        OUTPUTS:
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
 
!     Variable Initializations
      MODNAM = 'EVLINI'
 
      DO I = 1 , NUMARC
         ARCMAX(I) = 0.0
!CRFL
!CRFL  Add true centerline calculations:  add ARCCL(I)
!CRFL  Changed 7/25/94, R.F. Lee
!CRFL
         ARCCL(I) = 0.0
         QMAX(I) = 0.0
         DXMAX(I) = 0.0
         UMAX(I) = 0.0
         U3MAX(I) = 0.0
         SVMAX(I) = 0.0
         SWMAX(I) = 0.0
         SYMAX(I) = 0.0
         SY3MX(I) = 0.0
         HEMAX(I) = 0.0
         CHIDMW(I) = 0.0
         CHINMW(I) = 0.0
         CHI3MW(I) = 0.0
         CHIDML(I) = 0.0
         CHINML(I) = 0.0
         CHI3ML(I) = 0.0
      ENDDO
 
      CONTINUE
      END
!*==EVALCK.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EVALCK
!***********************************************************************
!                 EVALCK Module of AERMOD
!
!        PURPOSE: Check ARC Values for EVALFILE Option
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    November 29, 1993
!
!        REVISIONS:  Added true centerline calculations.
!                    Changed 7/25/94, R.F. Lee.
!
!        INPUTS:
!
!        OUTPUTS:
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , INDEX
      REAL :: CHIOQ
 
!     Variable Initializations
      MODNAM = 'EVALCK'
 
!     Set ARC Index
      INDEX = NDXARC(IREC)
 
!     Check for INDEX = 0, i.e., this receptor is not an EVALCART receptor.
!     Skip to RETURN for INDEX = 0
      IF ( INDEX.EQ.0 ) GOTO 99
 
!CRFL
!CRFL  Add true centerline calculations:  add CHIOQC
!CRFL  Change made 7/25/94, R.F. Lee.
!CRFL
!     Calculate Normalized Concentration, CHI/Q
      CHIOQ = HRVAL(1)/(QTK*EMIFAC(1))
!     Check ARCMAX Array
      IF ( CHIOQ.GT.ARCMAX(INDEX) ) THEN
         ARCMAX(INDEX) = CHIOQ
!CRFL
!CRFL  Add true centerline calculations:  add arc centerline
!CRFL  calculation ARCCL(INDEX).  Note that, although ARCCL is
!CRFL  is calculated redundantly for all receptors in the arc,
!CRFL  the value calculated at the receptor showing the max is
!CRFL  used.  This assures that the most reasonable downwind
!CRFL  distance will be used in the calculation.
!CRFL  Changed 7/25/94, R.F. Lee.
!CRFL
         ARCCL(INDEX) = CHIOQ
         QMAX(INDEX) = QTK*EMIFAC(1)
         DXMAX(INDEX) = DISTR
!RJP
!RJP     Use appropriate effective parameters
!RJP
         IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
            UMAX(INDEX) = UEFF
            SVMAX(INDEX) = SVEFF
            SWMAX(INDEX) = SWEFF
            SYMAX(INDEX) = SY
            HEMAX(INDEX) = HE
!crfl 5/19/95 Grab SZ at maximum receptor in arc
            SZMAX(INDEX) = SZ
            CHIDMW(INDEX) = 0.0
            CHINMW(INDEX) = 0.0
            CHI3MW(INDEX) = 0.0
            CHIDML(INDEX) = 0.0
            CHINML(INDEX) = 0.0
            CHI3ML(INDEX) = 0.0
            HSBLMX(INDEX) = HSBL
         ELSEIF ( PPF.GT.0.999 ) THEN
            UMAX(INDEX) = UEFFD
            U3MAX(INDEX) = UEFF3
            SVMAX(INDEX) = SVEFF3
            SWMAX(INDEX) = SWEFF3
            SYMAX(INDEX) = SY
            SY3MX(INDEX) = SY3
            HEMAX(INDEX) = HSP + DHP3
            CHIDMW(INDEX) = CHIDW/QMAX(INDEX)
            CHINMW(INDEX) = CHINW/QMAX(INDEX)
            CHI3MW(INDEX) = CHI3W/QMAX(INDEX)
            CHIDML(INDEX) = CHIDL/QMAX(INDEX)
            CHINML(INDEX) = CHINL/QMAX(INDEX)
            CHI3ML(INDEX) = CHI3L/QMAX(INDEX)
            HSBLMX(INDEX) = HPEN
         ELSE
            UMAX(INDEX) = UEFFD
            U3MAX(INDEX) = UEFF3
            SVMAX(INDEX) = SVEFFD
            SWMAX(INDEX) = SWEFFD
            SYMAX(INDEX) = SY
            SY3MX(INDEX) = SY3
            HEMAX(INDEX) = HSP + DHP1
            CHIDMW(INDEX) = CHIDW/QMAX(INDEX)
            CHINMW(INDEX) = CHINW/QMAX(INDEX)
            CHI3MW(INDEX) = CHI3W/QMAX(INDEX)
            CHIDML(INDEX) = CHIDL/QMAX(INDEX)
            CHINML(INDEX) = CHINL/QMAX(INDEX)
            CHI3ML(INDEX) = CHI3L/QMAX(INDEX)
            HSBLMX(INDEX) = HPEN
         ENDIF
      ENDIF
 
 99   CONTINUE
      END
!*==EVALFL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EVALFL
!***********************************************************************
!                 EVALFL Module of AERMOD
!
!        PURPOSE: Output ARC Values for EVALFILE Option
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    November 29, 1993
!
!        REVISIONS:  Added true centerline calculations.
!                    Changed 7/25/94, R.F. Lee.
!
!        INPUTS:
!
!        OUTPUTS:
!
!        CALLED FROM:   PCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: CWIC , CWICN , CWICW , CWICL , UOUST , SVOU , HEOZI ,     &
     &        ZIOL , FSTAR , UOWST , XNDIM , PWSTAR , UOUT , SYOUT ,    &
     &        OBUOUT
 
      SAVE 
      INTEGER :: I , INDEX
 
!     Variable Initializations
      MODNAM = 'EVALFL'
 
!     LOOP Through ARCs
      DO I = 1 , NUMARC
!C
!C   Changes dated 2/25/94, 3/2/94, 3/4/94, 3/8/94, 3/9/94, 3/14/94,
!C     and 4/20/94
!C     by Russ Lee, to add Bowen Ratio and additional parameters.
!C
!        Calculate Crosswind Integrated Concentration, CWIC
!CRFL
!CRFL  "ARCMAX" was changed to ARCCL in the following statement to
!CRFL  give a "true" CWIC.  Changed 7/25/94, R.F. Lee.
!CRFL
!RWB         CWIC = SRT2PI * SYMAX(I) * ARCCL(I)
!RWB     Modify CWIC to be sum of CWIC's of individual "plumes".  2/13/95
!RWB     Note that WRAP and LIFT components are included in ARCCL.
         IF ( (STABLE .OR. (UNSTAB .AND. HS.GE.ZI)) ) THEN
            CWIC = SRT2PI*SYMAX(I)*ARCCL(I)
!           Now calculate CWIC with U*ZI normalization,
!           using maximum of HE & ZI, instead of ZI.
            CWICN = CWIC*UMAX(I)*AMAX1(HEMAX(I),ZI)
         ELSE
!           Calculate WRAP and LIFT components of CWIC
!           First calculate CWIC without U*ZI normalization.
!           Note that the CHIDM_, CHINM_ and CHI3M_ terms have already been
!           normalized by QTK.
            CWICW = SRT2PI*SYMAX(I)*(CHIDMW(I)+CHINMW(I))               &
     &              + SRT2PI*SY3MX(I)*CHI3MW(I)
            CWICL = SRT2PI*SYMAX(I)*(CHIDML(I)+CHINML(I))               &
     &              + SRT2PI*SY3MX(I)*CHI3ML(I)
!           Combine WRAP and LIFT components. Include decay and normalization.
            CWIC = (FOPT*CWICW+(1.0-FOPT)*CWICL)*D
 
!           Calculate WRAP and LIFT components of CWIC
!           Now calculate CWIC with U*ZI normalization.
!           Use HPEN (=AMAX1(HE3,ZI)) for penetrated source instead of ZI.
            CWICW = SRT2PI*SYMAX(I)*UMAX(I)*ZI*(CHIDMW(I)+CHINMW(I))    &
     &              + SRT2PI*SY3MX(I)*U3MAX(I)*HPEN*CHI3MW(I)
            CWICL = SRT2PI*SYMAX(I)*UMAX(I)*ZI*(CHIDML(I)+CHINML(I))    &
     &              + SRT2PI*SY3MX(I)*U3MAX(I)*HPEN*CHI3ML(I)
!           Combine WRAP and LIFT components. Include decay and normalization.
            CWICN = (FOPT*CWICW+(1.0-FOPT)*CWICL)*D
 
         ENDIF
 
!        Calculate U/Ustar
         IF ( USTAR.GE.1.0E-10 ) THEN
            UOUST = UMAX(I)/USTAR
         ELSE
            UOUST = -999.
         ENDIF
 
!        Calculate sigma-v / U
         IF ( UMAX(I).GE.1.0E-10 ) THEN
            SVOU = SVMAX(I)/UMAX(I)
         ELSE
            SVOU = -999.
         ENDIF
 
!        Calculate He / Zi
         IF ( ZI.GE.1.0E-10 ) THEN
            HEOZI = HEMAX(I)/ZI
         ELSE
            HEOZI = -999.
         ENDIF
 
!        Calculate Zi / L
         IF ( ABS(OBULEN).GE.1.0E-10 ) THEN
            ZIOL = ZI/OBULEN
         ELSE
            ZIOL = 999.
         ENDIF
 
!RWBC      Calculate total F
!RWB       FTOT = FB + FM
!RWB     Replace FTOT with FSTAR (non-dimensional buoyancy flux).  2/13/95
!RWB     Note that UP is the latest value for plume rise wind speed
!RWB     from the iterative stable plume rise.
         IF ( WSTAR.GE.1.0E-10 ) THEN
            FSTAR = FB/(UP*WSTAR*WSTAR*ZI)
         ELSE
            FSTAR = -999.
         ENDIF
 
         IF ( OBULEN.LT.0. ) THEN
 
!           Calculate U / WSTAR when L < 0
            IF ( WSTAR.GE.1.0E-10 ) THEN
               UOWST = UMAX(I)/WSTAR
            ELSE
               UOWST = -999.
            ENDIF
 
!           Calculate nondimensional distance when L < 0
            IF ( UMAX(I).GE.1.0E-10 .AND. ZI.GE.1.0E-10 ) THEN
               XNDIM = DXMAX(I)*WSTAR/(UMAX(I)*ZI)
            ELSE
               XNDIM = -999.
            ENDIF
!crfl 5/18/95 When unstable, put WSTAR into PWSTAR variable to be printed.
            PWSTAR = WSTAR
 
         ELSE
 
!           Set UOWST and XNDIM to -999 when L >= 0
            UOWST = -999.
            XNDIM = -999.
!crfl 5/18/95 When stable, put Sigma-Z into PWSTAR variable to be printed.
            PWSTAR = SZMAX(I)
         ENDIF
 
!CRFL
!CRFL  Added ARCCL(I), arc true centerline concentration for the arc.
!CRFL  Change made 7/25/94, R.F. Lee.
!CRFL
!RWB           WRITE(IELUNT(ISRC),9000) SRCID(ISRC), KURDAT, ARCID(I),
!RWB     &                      ARCMAX(I), QMAX(I), CWIC,
!RWB     &                      DXMAX(I), UMAX(I), SVMAX(I),
!RWB     &                      SWMAX(I), SYMAX(I), HEMAX(I),
!RWB     &                      OBULEN, ZI, USTAR, WSTAR, FB, FM,
!RWB     &                      BOWEN, UOUST, SVOU, ZIOL, UOWST, XNDIM,
!RWB     &                      HEOZI, FTOT, AHS(ISRC), ARCCL(I), DOPTS
!RWBCRWB                        Added DOPTS, Developmental Options (C*10)
 
!RWB     Modified to output CHI's for individual "plumes".  2/13/95
!RWB     First select appropriate sigma-y to print out. Use SY3 for mostly
!RWB     penetrated plumes.
         IF ( UNSTAB .AND. HS.LT.ZI .AND. PPF.GT.0.999 ) THEN
            UOUT = U3MAX(I)
            SYOUT = SY3MX(I)
         ELSE
            UOUT = UMAX(I)
            SYOUT = SYMAX(I)
         ENDIF
 
         IF ( URBSTAB ) THEN
            OBUOUT = ABS(URBOBULEN)
         ELSE
            OBUOUT = OBULEN
         ENDIF
 
 
!crfl 5/18/95 Changed WSTAR to PWSTAR so I could output another variable
!crfl         (Sigma-Z) in stable conditions without upsetting WSTAR.
         WRITE (IELUNT(ISRC),9000) SRCID(ISRC) , KURDAT , ARCID(I) ,    &
     &                             ARCMAX(I) , QMAX(I) , CWIC , CWICN , &
     &                             DXMAX(I) , UOUT , SVMAX(I) , SWMAX(I)&
     &                             , SYOUT , HEMAX(I) , OBUOUT , ZI ,   &
     &                             USTAR , PWSTAR , FB , FM , BOWEN ,   &
     &                             PPF , CHIDML(I) , CHINML(I) ,        &
     &                             CHI3ML(I) , XNDIM , HEOZI , FSTAR ,  &
     &                             AHS(ISRC) , ARCCL(I) , AFV ,         &
     &                             HSBLMX(I)
 
!CRFL     &       /,9X,6(1X,G12.4),/,9X,3(1X,G12.4))
 9000    FORMAT (1X,A8,1X,I8.8,1X,A8,4(1X,G12.6),/,9X,6(1X,G12.4),/,9X, &
     &           6(1X,G12.4),/,9X,6(1X,G12.4),/,9X,4(1X,G12.4),1X,      &
     &           '0000000000',1X,G12.4,1X,G12.4)
!RWB                      Added Flow Vector, AFV
!RWB                      Added height of effective reflecting surface, HSBLMX
 
 
      ENDDO
!C   End of changes dated 2/25/94 through 3/14/94 by Russ Lee
!C
 
      CONTINUE
      END
!*==COCARD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE COCARD
!***********************************************************************
!                 COCARD Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To process COntrol Pathway card images
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   Added undocumentd NODRYDP and NOWETDP options to
!                    MODOPS header.  Also moved code to write header of
!                    DEBUG output file to AERMOD.FOR to follow SETUP,
!                    to accommodate final setting for DRYDPLT and WETDPLT.
!                    R. W. Brode, PES - 10/26/2004
!
!        MODIFIED:   To allow 24-hour or ANNUAL averages to be modeled
!                    separately for post-1997 PM10 processing.
!                    R. W. Brode, PES - 12/2/98
!
!        MODIFIED:   To add error check for use of NOSMPL option with
!                    FLAT terrain.
!                    R. W. Brode, PES - 9/30/94
!
!        MODIFIED:   To add DDEP and WDEP parameters to CONC/DEPOS options
!                    to allow just the wet or just the dry deposition flux
!                    to be reported.  DEPOS now reports the sum of wet and
!                    dry fluxes.  Also, a new option parameter is provided
!                    to force the Intermeiate Terrain procedure to ignore
!                    either the simple terrain model or the complex terrain
!                    model (NOSMPL/NOCMPL).
!                    D. Strimaitis, SRC - 11/8/93
!
!        MODIFIED:   To add DEPLETE parameter for plume depletion option
!                    and to allow flagpole receptors with DEPOS option.
!                    D. Strimaitis, SRC - 2/15/93
!
!        INPUTS:  Pathway (CO) and Keyword
!
!        OUTPUTS: Processing Option Switches
!                 Option Setup Status Switches
!
!        CALLED FROM:   SETUP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'COCARD'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Set Status Switch
         ISTART = .TRUE.
         ICSTAT(1) = ICSTAT(1) + 1
!           WRITE Error Message: Repeat Non-repeatable Keyword
         IF ( ICSTAT(1).NE.1 ) CALL ERRHDL(PATH,MODNAM,'W','135',KEYWRD)
      ELSEIF ( KEYWRD.EQ.'TITLEONE' ) THEN
!        Set Status Switch
         ICSTAT(2) = ICSTAT(2) + 1
         IF ( ICSTAT(2).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'W','135',KEYWRD)
         ELSE
!           Process Titles                                  ---   CALL TITLES
            CALL TITLES
         ENDIF
      ELSEIF ( KEYWRD.EQ.'TITLETWO' ) THEN
!        Set Status Switch
         ICSTAT(3) = ICSTAT(3) + 1
         IF ( ICSTAT(3).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'W','135',KEYWRD)
         ELSE
!           Process Titles                                  ---   CALL TITLES
            CALL TITLES
         ENDIF
      ELSEIF ( KEYWRD.EQ.'MODELOPT' ) THEN
!        Set Status Switch
         ICSTAT(4) = ICSTAT(4) + 1
         IF ( ICSTAT(4).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Modeling Options                        ---   CALL MODOPT
            CALL MODOPT
         ENDIF
      ELSEIF ( KEYWRD.EQ.'AVERTIME' ) THEN
!        Set Status Switch
         ICSTAT(5) = ICSTAT(5) + 1
         IF ( ICSTAT(5).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Averaging Time Options                  ---   CALL AVETIM
            CALL AVETIM
         ENDIF
      ELSEIF ( KEYWRD.EQ.'POLLUTID' ) THEN
!        Set Status Switch
         ICSTAT(6) = ICSTAT(6) + 1
         IF ( ICSTAT(6).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSEIF ( ICSTAT(4).NE.1 ) THEN
!           WRITE Error Message: Keyword Out of Order (Must Follow MODELOPT)
            CALL ERRHDL(PATH,MODNAM,'E','140',KEYWRD)
         ELSE
!           Process Pollutant ID Option                     ---   CALL POLLID
            CALL POLLID
         ENDIF
      ELSEIF ( KEYWRD.EQ.'HALFLIFE' .OR. KEYWRD.EQ.'DCAYCOEF' ) THEN
         IF ( KEYWRD.EQ.'HALFLIFE' ) THEN
!           Check for Previous DCAYCOEF Keyword in Runstream File
            IF ( ICSTAT(8).NE.0 ) THEN
               CALL ERRHDL(PATH,MODNAM,'W','155',KEYWRD)
               GOTO 999
            ELSE
!              Set Status Switch and Check for Duplicate Keyword
               ICSTAT(7) = ICSTAT(7) + 1
               IF ( ICSTAT(7).NE.1 ) THEN
!                 WRITE Error Message: Repeat Non-repeatable Keyword
                  CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
                  GOTO 999
               ENDIF
            ENDIF
         ELSEIF ( KEYWRD.EQ.'DCAYCOEF' ) THEN
!           Check for Previous HALFLIFE Keyword in Runstream File
            IF ( ICSTAT(7).NE.0 ) THEN
               CALL ERRHDL(PATH,MODNAM,'W','155',KEYWRD)
               GOTO 999
            ELSE
!              Set Status Switch and Check for Duplicate Keyword
               ICSTAT(8) = ICSTAT(8) + 1
               IF ( ICSTAT(8).NE.1 ) THEN
!                 WRITE Error Message: Repeat Non-repeatable Keyword
                  CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
                  GOTO 999
               ENDIF
            ENDIF
         ENDIF
!        Check for Keyword Out of Order
         IF ( ICSTAT(4).NE.1 ) THEN
!           WRITE Error Message: Keyword Out of Order (Must Follow MODELOPT)
            CALL ERRHDL(PATH,MODNAM,'E','140',KEYWRD)
         ELSEIF ( ICSTAT(6).NE.1 ) THEN
!           WRITE Error Message: Keyword Out of Order (Must Follow POLLUTID)
            CALL ERRHDL(PATH,MODNAM,'E','140',KEYWRD)
         ENDIF
!        Process Exponential Decay Option                   ---   CALL EDECAY
         CALL EDECAY
      ELSEIF ( KEYWRD.EQ.'FLAGPOLE' ) THEN
!        Set Status Switch
         ICSTAT(11) = ICSTAT(11) + 1
         IF ( ICSTAT(11).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Flagpole Receptor Height Option         ---   CALL FLAGDF
            CALL FLAGDF
         ENDIF
      ELSEIF ( KEYWRD.EQ.'RUNORNOT' ) THEN
!        Set Status Switch
         ICSTAT(12) = ICSTAT(12) + 1
         IF ( ICSTAT(12).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Option to Run Model or Not              ---   CALL RUNNOT
            CALL RUNNOT
         ENDIF
      ELSEIF ( KEYWRD.EQ.'EVENTFIL' ) THEN
!        Set Status Switch
         ICSTAT(13) = ICSTAT(13) + 1
         IF ( ICSTAT(13).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process EVENT File Option                       ---   CALL EVNTFL
            CALL EVNTFL
         ENDIF
      ELSEIF ( KEYWRD.EQ.'SAVEFILE' ) THEN
!        Set Status Switch
         ICSTAT(14) = ICSTAT(14) + 1
         IF ( ICSTAT(14).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Model Re-start Save File Option         ---   CALL SAVEFL
            CALL SAVEFL
         ENDIF
      ELSEIF ( KEYWRD.EQ.'INITFILE' ) THEN
!        Set Status Switch
         ICSTAT(15) = ICSTAT(15) + 1
         IF ( ICSTAT(15).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Re-start Initialization File Option     ---   CALL INITFL
            CALL INITFL
         ENDIF
      ELSEIF ( KEYWRD.EQ.'MULTYEAR' ) THEN
!        Set Status Switch
         ICSTAT(16) = ICSTAT(16) + 1
         IF ( ICSTAT(16).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Multiple-Year Run Option                ---   CALL MYEAR
            CALL MYEAR
         ENDIF
      ELSEIF ( KEYWRD.EQ.'ERRORFIL' ) THEN
!        Set Status Switch
         ICSTAT(17) = ICSTAT(17) + 1
         IF ( ICSTAT(17).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Error File Option                       ---   CALL ERRFIL
            CALL ERRFIL
         ENDIF
      ELSEIF ( KEYWRD.EQ.'GDSEASON' ) THEN
!        Set Status Switch
         ICSTAT(18) = ICSTAT(18) + 1
         IF ( ICSTAT(18).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Seasons for GASDEP Option              ---   CALL GDSEAS
            CALL GDSEAS
         ENDIF
      ELSEIF ( KEYWRD.EQ.'GASDEPDF' ) THEN
!        Set Status Switch
         ICSTAT(19) = ICSTAT(19) + 1
         IF ( ICSTAT(19).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process GASDEP Defaults Option                  ---   CALL GDDEF
            CALL GDDEF
         ENDIF
      ELSEIF ( KEYWRD.EQ.'GASDEPVD' ) THEN
!        Set Status Switch
         ICSTAT(20) = ICSTAT(20) + 1
         IF ( ICSTAT(20).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           User Specified Deposition Velocity Option       ---   CALL GVSUBD
            CALL GVSUBD
         ENDIF
      ELSEIF ( KEYWRD.EQ.'GDLANUSE' ) THEN
!        Set Status Switch
         ICSTAT(21) = ICSTAT(21) + 1
         IF ( ICSTAT(21).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Error File Option                       ---   CALL GDLAND
            CALL GDLAND
         ENDIF
      ELSEIF ( KEYWRD.EQ.'DEBUGOPT' ) THEN
!        Set Status Switch
         ICSTAT(22) = ICSTAT(22) + 1
         IF ( ICSTAT(22).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Error File Option                       ---   CALL DEBOPT
            CALL DEBOPT
         ENDIF
      ELSEIF ( KEYWRD.EQ.'URBANOPT' ) THEN
!        Set Status Switch
         ICSTAT(23) = ICSTAT(23) + 1
         IF ( ICSTAT(23).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Error File Option                       ---   CALL URBOPT
            CALL URBOPT
         ENDIF
      ELSEIF ( KEYWRD.EQ.'OZONEVAL' ) THEN
!        Set Status Switch
         ICSTAT(24) = ICSTAT(24) + 1
         IF ( ICSTAT(24).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
            IF ( PVMRM .OR. OLM ) THEN
!              Process O3 Value Option                    ---   CALL O3VAL
               CALL O3VAL
            ELSE
!              Write Error Message:  OZONEVAL specified without PVMRM or OLM
               CALL ERRHDL(PATH,MODNAM,'E','142',KEYWRD)
            ENDIF
         ENDIF
      ELSEIF ( KEYWRD.EQ.'OZONEFIL' ) THEN
!        Set Status Switch
         ICSTAT(26) = ICSTAT(26) + 1
         IF ( ICSTAT(26).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
            IF ( PVMRM .OR. OLM ) THEN
!              Process O3 File Option                    ---   CALL O3FIL
               CALL O3FIL
            ELSE
!              Write Error Message:  OZONEFIL specified without PVMRM or OLM
               CALL ERRHDL(PATH,MODNAM,'E','142',KEYWRD)
            ENDIF
         ENDIF
      ELSEIF ( KEYWRD.EQ.'NO2EQUIL' ) THEN
!        Set Status Switch
         ICSTAT(27) = ICSTAT(27) + 1
         IF ( ICSTAT(27).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
            IF ( PVMRM ) THEN
!              Process NO2Equil Option                    ---   CALL NO2EQ
               CALL NO2EQ
            ELSE
!              Write Error Message:  NO2EQUIL specified without PVMRM
               CALL ERRHDL(PATH,MODNAM,'E','143',KEYWRD)
            ENDIF
         ENDIF
      ELSEIF ( KEYWRD.EQ.'FINISHED' ) THEN
!        Set Status Switch
         IFINIS = .TRUE.
!        Set Status Switch
         ICSTAT(25) = ICSTAT(25) + 1
         IF ( ICSTAT(25).NE.1 ) THEN
!           WRITE Error Message: Repeat Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
            GOTO 999
         ENDIF
 
!        Check for Missing Mandatory Keywords
         IF ( ICSTAT(1).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         IF ( ICSTAT(2).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','TITLEONE')
         IF ( ICSTAT(4).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','MODELOPT')
         IF ( ICSTAT(5).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','AVERTIME')
         IF ( ICSTAT(6).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','POLLUTID')
         IF ( ICSTAT(12).EQ.0 )                                         &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','RUNORNOT')
 
         IF ( OLM .OR. PVMRM ) THEN
            IF ( ICSTAT(24).EQ.0 .AND. ICSTAT(26).EQ.0 ) THEN
!              Write Error Message:  Ozone value or data file needed
               IF ( OLM ) THEN
                  DUMMY = '  OLM  '
               ELSEIF ( PVMRM ) THEN
                  DUMMY = ' PVMRM '
               ENDIF
               CALL ERRHDL(PATH,MODNAM,'E','283',DUMMY)
            ENDIF
         ENDIF
 
!        OPEN Restart Save and Initialization Files
         IF ( RSTSAV ) THEN
            DUMMY = 'SAVEFILE'
            OPEN (UNIT=IDPUNT,ERR=99,FILE=SAVFIL,FORM='UNFORMATTED',    &
     &            IOSTAT=IOERRN,STATUS='UNKNOWN')
            IF ( SAVFL2.NE.SAVFIL )                                     &
     &           OPEN (UNIT=IDPUN2,ERR=99,FILE=SAVFL2,                  &
     &           FORM='UNFORMATTED',IOSTAT=IOERRN,STATUS='UNKNOWN')
         ENDIF
         IF ( RSTINP ) THEN
            DUMMY = 'INITFILE'
            OPEN (UNIT=IRSUNT,ERR=99,FILE=INIFIL,FORM='UNFORMATTED',    &
     &            IOSTAT=IOERRN,STATUS='OLD')
         ENDIF
 
!        Check Averaging Periods Selected for SCREEN Mode Option
         IF ( SCREEN ) THEN
            IF ( NUMAVE.GT.1 ) THEN
!              WRITE Error Message:  Too Many Averaging Periods Selected
               CALL ERRHDL(PATH,MODNAM,'E','295',' 1h Only')
            ELSEIF ( KAVE(1).NE.1 ) THEN
!              WRITE Error Message:  Invalid Averaging Period Selected
               CALL ERRHDL(PATH,MODNAM,'E','295',' 1h Only')
            ENDIF
!              WRITE Error Message:  Too Many Averaging Periods Selected
            IF ( PERIOD ) CALL ERRHDL(PATH,MODNAM,'E','295',' 1h Only')
         ENDIF
 
!        Generate MODOPS Character Array to Summarize Modeling Options
         IF ( CONC ) MODOPS(1) = 'CONC '
         IF ( DEPOS ) MODOPS(2) = 'DEPOS'
         IF ( DDEP ) MODOPS(3) = 'DDEP'
         IF ( WDEP ) MODOPS(4) = 'WDEP'
         IF ( DFAULT ) THEN
            MODOPS(5) = 'DFAULT'
         ELSEIF ( TOXICS ) THEN
            MODOPS(5) = 'TOXICS'
         ENDIF
         IF ( FLAT ) THEN
            MODOPS(6) = 'FLAT'
         ELSE
            MODOPS(6) = 'ELEV'
         ENDIF
         IF ( FLGPOL ) MODOPS(7) = 'FLGPOL'
         IF ( NOSTD ) MODOPS(8) = 'NOSTD'
         IF ( NOCHKD ) MODOPS(9) = 'NOCHKD'
         IF ( NOWARN ) MODOPS(10) = 'NOWARN'
         IF ( SCREEN ) MODOPS(11) = 'SCREEN'
         IF ( MULTYR ) MODOPS(12) = 'MULTYR'
         IF ( ARDPLETE ) THEN
            MODOPS(13) = 'ARDPLT'
         ELSEIF ( ROMBERG ) THEN
            MODOPS(13) = 'ROMBRG'
         ELSEIF ( DDPLETE ) THEN
            MODOPS(13) = 'DRYDPL'
         ELSEIF ( .NOT.DDPLETE ) THEN
            MODOPS(13) = 'NODDPL'
         ENDIF
         IF ( WDPLETE ) THEN
            MODOPS(14) = 'WETDPL'
         ELSEIF ( .NOT.WDPLETE ) THEN
            MODOPS(14) = 'NOWDPL'
         ENDIF
         IF ( SCIM ) MODOPS(15) = 'SCIM'
         IF ( PVMRM ) THEN
            MODOPS(16) = 'PVMRM'
         ELSEIF ( OLM ) THEN
            MODOPS(16) = 'OLM'
         ENDIF
 
!           Write Error Message:  Cannot use SCIM with short term averages
         IF ( SCIM .AND. NUMAVE.GT.0 )                                  &
     &        CALL ERRHDL(PATH,MODNAM,'E','154','ST AVES')
!           Write Error Message:  Cannot use SCIM with PERIOD average
         IF ( SCIM .AND. PERIOD )                                       &
     &         CALL ERRHDL(PATH,MODNAM,'E','154','PERIOD')
         IF ( SCIM .AND. DEPOS ) THEN
!           Write Warning Message:  Ignore DEPOS when using SCIM
            DEPOS = .FALSE.
            NUMTYP = NUMTYP - 1
            CALL ERRHDL(PATH,MODNAM,'W','156',' DEPOS ')
         ENDIF
!           Write Error Message:  Gas Dry Deposition Option w/o TOXICS Option
         IF ( .NOT.TOXICS .AND. ICSTAT(18).GT.0 )                       &
     &        CALL ERRHDL(PATH,MODNAM,'E','198','GDSEASON')
!           Write Error Message:  Gas Dry Deposition Option w/o TOXICS Option
         IF ( .NOT.TOXICS .AND. ICSTAT(19).GT.0 )                       &
     &        CALL ERRHDL(PATH,MODNAM,'E','198','GASDEPDF')
!           Write Error Message:  Gas Dry Deposition Option w/o TOXICS Option
         IF ( .NOT.TOXICS .AND. ICSTAT(20).GT.0 )                       &
     &        CALL ERRHDL(PATH,MODNAM,'E','198','GASDEPVD')
!           Write Error Message:  Gas Dry Deposition Option w/o TOXICS Option
         IF ( .NOT.TOXICS .AND. ICSTAT(21).GT.0 )                       &
     &        CALL ERRHDL(PATH,MODNAM,'E','198','GDLANUSE')
 
         IF ( DEPOS .OR. WDEP ) THEN
            LWGAS = .TRUE.
            LWPART = .TRUE.
         ENDIF
 
!        Adjust output label for ANNUAL average deposition fluxes
         IF ( ANNUAL ) THEN
            DO ITYP = 1 , NUMTYP
               IF ( .NOT.CONC .OR. ITYP.GT.1 ) PERLBL(ITYP)             &
     &               = 'GRAMS/M**2/YR'
            ENDDO
         ENDIF
 
!        Check for new (post-1997) PM10 processing
         IF ( (POLLUT.EQ.'PM10' .OR. POLLUT.EQ.'PM-10') .AND.           &
     &        .NOT.MULTYR ) THEN
            PM10AVE = .TRUE.
!              Write Error Message: Short Term average must be 24-hr only
            IF ( NUMAVE.GT.1 .OR. (NUMAVE.EQ.1 .AND. KAVE(1).NE.24) )   &
     &           CALL ERRHDL(PATH,MODNAM,'E','363','AVERTIME')
!              Write Error Message: Long term average must be ANNUAL
            IF ( PERIOD ) CALL ERRHDL(PATH,MODNAM,'E','363','AVERTIME')
         ENDIF
 
!        Check for pollutant ID = 'NO2' for PVMRM and OLM options
!           Write Error Message:  Pollutant ID doesn't match option
         IF ( (PVMRM .OR. OLM) .AND. POLLUT.NE.'NO2' )                  &
     &        CALL ERRHDL(PATH,MODNAM,'E','284',' NO2 ')
 
         GOTO 1000
 
!        WRITE Error Message for Error Opening File
 99      CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)
         IF ( DUMMY.EQ.'SAVEFILE' ) THEN
!           Reset Logical Flag for SAVEFILE Option Due to Error Opening File
            RSTSAV = .FALSE.
         ELSEIF ( DUMMY.EQ.'INITFILE' ) THEN
!           Reset Logical Flag for INITFILE Option Due to Error Opening File
            RSTINP = .FALSE.
         ENDIF
 
 1000    CONTINUE
 
      ELSE
!        Write Error Message: Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==TITLES.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE TITLES
!***********************************************************************
!                 TITLES Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Title Information From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Title Strings for Model Outputs
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'TITLES'
 
      IF ( KEYWRD.EQ.'TITLEONE' ) THEN
         TITLE1 = RUNST1(LOCE(2)+2:80)
!           Write Error Message: Missing Parameter Title
         IF ( RUNST1(LOCE(2)+2:80).EQ.' ' )                             &
     &         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ELSEIF ( KEYWRD.EQ.'TITLETWO' ) THEN
         TITLE2 = RUNST1(LOCE(2)+2:80)
!           Write Warning Message
         IF ( RUNST1(LOCE(2)+2:80).EQ.' ' )                             &
     &         CALL ERRHDL(PATH,MODNAM,'W','200',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==MODOPT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MODOPT
!***********************************************************************
!                 MODOPT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Modeling Options From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate undocumented options to turn off
!                    depletion, which is now the default.
!                    R. W. Brode, MACTEC/PES - 10/26/2004
!
!        MODIFIED:   To allow for calculating CONC/DEPOS/DDEP/WDEP in
!                    a single model run.
!                    R. W. Brode, PES - 4/17/95
!
!        MODIFIED:   To add DDEP and WDEP parameters to CONC/DEPOS options
!                    to allow just the wet or just the dry deposition flux
!                    to be reported.  DEPOS now reports the sum of wet and
!                    dry fluxes.  Also, a new option parameter is provided
!                    to force the Intermeiate Terrain procedure to ignore
!                    either the simple terrain model or the complex terrain
!                    model (NOSMPL/NOCMPL).
!                    D. Strimaitis, SRC - 11/8/93
!
!        MODIFIED:   To add DEPLETE parameter for plume depletion option
!                    D. Strimaitis, SRC - 2/15/93
!
!        MODIFIED:   To Output Warning Message '206' For Overriding
!                    Non-DEFAULT Option - 9/29/92
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Modeling Option Logical Switch Settings
!
!        ERROR HANDLING:   Checks for Too Few or Too Many Option Keywords;
!                          Checks for Invalid Option Keywords;
!                          Checks for Conflicting or Missing Option Keywords
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
      CHARACTER KOPT*8
 
!     Variable Initializations - Initialize All Logical Switches to FALSE
      MODNAM = 'MODOPT'
 
!     Check for Too Few or Too Many Parameters
      IF ( IFC.LT.3 ) THEN
!        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ELSEIF ( IFC.GT.14 ) THEN
!        WRITE Warning Message   ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'W','202',KEYWRD)
      ENDIF
 
!     First Check for Presence of DFAULT Switch
      DO I = 3 , IFC
         KOPT = FIELD(I)
         IF ( KOPT.EQ.'DFAULT' .OR. KOPT.EQ.'DEFAULT' ) THEN
            DFAULT = .TRUE.
            ELEV = .TRUE.
            FLAT = .FALSE.
            MSGPRO = .TRUE.
            NOSTD = .FALSE.
            NOCHKD = .FALSE.
            SCREEN = .FALSE.
            TOXICS = .FALSE.
            PVMRM = .FALSE.
            OLM = .FALSE.
         ENDIF
      ENDDO
 
!     Next Check for Presence of TOXICS Switch
      DO I = 3 , IFC
         KOPT = FIELD(I)
         IF ( (KOPT.EQ.'TOXICS' .OR. KOPT.EQ.'TOXIC') .AND.             &
     &        .NOT.DFAULT ) TOXICS = .TRUE.
      ENDDO
 
      NUMTYP = 0
!     Loop Through Fields Again Setting All Swithes
      DO I = 3 , IFC
         KOPT = FIELD(I)
         IF ( KOPT.EQ.'DFAULT' ) THEN
            DFAULT = .TRUE.
         ELSEIF ( KOPT.EQ.'CONC' ) THEN
            IF ( .NOT.CONC ) THEN
               CONC = .TRUE.
               NUMTYP = NUMTYP + 1
            ENDIF
         ELSEIF ( KOPT.EQ.'DEPOS' ) THEN
            IF ( .NOT.DEPOS ) THEN
               DEPOS = .TRUE.
               NUMTYP = NUMTYP + 1
            ENDIF
         ELSEIF ( KOPT.EQ.'DDEP' ) THEN
            IF ( .NOT.DDEP ) THEN
               DDEP = .TRUE.
               NUMTYP = NUMTYP + 1
            ENDIF
         ELSEIF ( KOPT.EQ.'WDEP' ) THEN
            IF ( .NOT.WDEP ) THEN
               WDEP = .TRUE.
               NUMTYP = NUMTYP + 1
            ENDIF
         ELSEIF ( KOPT.EQ.'DRYDPLT' ) THEN
            DDPLETE = .TRUE.
         ELSEIF ( KOPT.EQ.'NODRYDP' ) THEN
!           Dry depletion is now standard - include "option" to override it
            DDPLETE = .FALSE.
         ELSEIF ( KOPT.EQ.'ROMBERG' ) THEN
            ROMBERG = .TRUE.
            DDPLETE = .TRUE.
         ELSEIF ( KOPT.EQ.'AREADPLT' ) THEN
            IF ( TOXICS ) THEN
               ARDPLETE = .TRUE.
               DDPLETE = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'E','198',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'WETDPLT' ) THEN
            WDPLETE = .TRUE.
         ELSEIF ( KOPT.EQ.'NOWETDP' ) THEN
!           Wet depletion is now standard - include "option" to override it
            WDPLETE = .FALSE.
         ELSEIF ( KOPT.EQ.'NOSTD' ) THEN
            IF ( .NOT.DFAULT ) THEN
               NOSTD = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'NOWARN' ) THEN
            NOWARN = .TRUE.
         ELSEIF ( KOPT.EQ.'NOCHKD' ) THEN
            IF ( .NOT.DFAULT ) THEN
               NOCHKD = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'SCREEN' ) THEN
            IF ( .NOT.DFAULT ) THEN
               SCREEN = .TRUE.
!              Set NOCHKD option on for SCREEN mode
               NOCHKD = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'FLAT' ) THEN
            IF ( .NOT.DFAULT ) THEN
               FLAT = .TRUE.
               ELEV = .FALSE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'SCIM' ) THEN
            IF ( TOXICS ) THEN
               SCIM = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'E','198',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'TOXICS' ) THEN
            IF ( .NOT.DFAULT ) THEN
               TOXICS = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'PVMRM' ) THEN
            IF ( .NOT.DFAULT ) THEN
               PVMRM = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSEIF ( KOPT.EQ.'OLM' ) THEN
            IF ( .NOT.DFAULT ) THEN
               OLM = .TRUE.
            ELSE
!              WRITE Warning Message     ! Non-DEFAULT Option Overridden
               CALL ERRHDL(PATH,MODNAM,'W','206',KOPT)
            ENDIF
         ELSE
!           WRITE Error Message     ! Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203',KOPT)
         ENDIF
      ENDDO
 
!        WRITE Error Message       ! Can't specify PVMRM and OLM
      IF ( OLM .AND. PVMRM )                                            &
     &      CALL ERRHDL(PATH,MODNAM,'E','141','        ')
 
!     Setup Label Array for Concentration and Depositions
      IF ( NUMTYP.GT.NTYP ) THEN
!        WRITE Error Message: Number of output types exceeds maximum
         WRITE (DUMMY,'(I4)') NTYP
         CALL ERRHDL(PATH,MODNAM,'E','290',DUMMY)
      ELSEIF ( NUMTYP.EQ.0 ) THEN
!        WRITE Warning Message: No Output Types Selected, Assume CONC Only
         CALL ERRHDL(PATH,MODNAM,'W','205','CONC')
         NUMTYP = 1
         ITYP = 1
         CONC = .TRUE.
         CHIDEP(1,ITYP) = 'AVER'
         CHIDEP(2,ITYP) = 'AGE '
         CHIDEP(3,ITYP) = 'CONC'
         CHIDEP(4,ITYP) = 'ENTR'
         CHIDEP(5,ITYP) = 'ATIO'
         CHIDEP(6,ITYP) = 'N   '
         EMIFAC(ITYP) = 1.0E06
         EMILBL(ITYP) = 'GRAMS/SEC'
         OUTLBL(ITYP) = 'MICROGRAMS/M**3'
         PERLBL(ITYP) = 'MICROGRAMS/M**3'
         OUTTYP(ITYP) = 'CONC'
      ELSEIF ( CONC ) THEN
         ITYP = 1
         CHIDEP(1,ITYP) = 'AVER'
         CHIDEP(2,ITYP) = 'AGE '
         CHIDEP(3,ITYP) = 'CONC'
         CHIDEP(4,ITYP) = 'ENTR'
         CHIDEP(5,ITYP) = 'ATIO'
         CHIDEP(6,ITYP) = 'N   '
         EMIFAC(ITYP) = 1.0E06
         EMILBL(ITYP) = 'GRAMS/SEC'
         OUTLBL(ITYP) = 'MICROGRAMS/M**3'
         PERLBL(ITYP) = 'MICROGRAMS/M**3'
         OUTTYP(ITYP) = 'CONC'
         IF ( DEPOS ) THEN
            ITYP = 2
            CHIDEP(1,ITYP) = '  TO'
            CHIDEP(2,ITYP) = 'TAL '
            CHIDEP(3,ITYP) = 'DEPO'
            CHIDEP(4,ITYP) = 'SITI'
            CHIDEP(5,ITYP) = 'ON  '
            CHIDEP(6,ITYP) = '    '
            EMIFAC(ITYP) = 3600.
            EMILBL(ITYP) = 'GRAMS/SEC'
            OUTLBL(ITYP) = 'GRAMS/M**2'
            PERLBL(ITYP) = 'GRAMS/M**2'
            OUTTYP(ITYP) = 'DEPOS'
            IF ( DDEP ) THEN
               ITYP = 3
               CHIDEP(1,ITYP) = '    '
               CHIDEP(2,ITYP) = 'DRY '
               CHIDEP(3,ITYP) = 'DEPO'
               CHIDEP(4,ITYP) = 'SITI'
               CHIDEP(5,ITYP) = 'ON  '
               CHIDEP(6,ITYP) = '    '
               EMIFAC(ITYP) = 3600.
               EMILBL(ITYP) = 'GRAMS/SEC'
               OUTLBL(ITYP) = 'GRAMS/M**2'
               PERLBL(ITYP) = 'GRAMS/M**2'
               OUTTYP(ITYP) = 'DDEP'
               IF ( WDEP ) THEN
                  ITYP = 4
                  CHIDEP(1,ITYP) = '    '
                  CHIDEP(2,ITYP) = 'WET '
                  CHIDEP(3,ITYP) = 'DEPO'
                  CHIDEP(4,ITYP) = 'SITI'
                  CHIDEP(5,ITYP) = 'ON  '
                  CHIDEP(6,ITYP) = '    '
                  EMIFAC(ITYP) = 3600.
                  EMILBL(ITYP) = 'GRAMS/SEC'
                  OUTLBL(ITYP) = 'GRAMS/M**2'
                  PERLBL(ITYP) = 'GRAMS/M**2'
                  OUTTYP(ITYP) = 'WDEP'
               ENDIF
            ELSEIF ( WDEP ) THEN
               ITYP = 3
               CHIDEP(1,ITYP) = '    '
               CHIDEP(2,ITYP) = 'WET '
               CHIDEP(3,ITYP) = 'DEPO'
               CHIDEP(4,ITYP) = 'SITI'
               CHIDEP(5,ITYP) = 'ON  '
               CHIDEP(6,ITYP) = '    '
               EMIFAC(ITYP) = 3600.
               EMILBL(ITYP) = 'GRAMS/SEC'
               OUTLBL(ITYP) = 'GRAMS/M**2'
               PERLBL(ITYP) = 'GRAMS/M**2'
               OUTTYP(ITYP) = 'WDEP'
            ENDIF
         ELSEIF ( DDEP ) THEN
            ITYP = 2
            CHIDEP(1,ITYP) = '    '
            CHIDEP(2,ITYP) = 'DRY '
            CHIDEP(3,ITYP) = 'DEPO'
            CHIDEP(4,ITYP) = 'SITI'
            CHIDEP(5,ITYP) = 'ON  '
            CHIDEP(6,ITYP) = '    '
            EMIFAC(ITYP) = 3600.
            EMILBL(ITYP) = 'GRAMS/SEC'
            OUTLBL(ITYP) = 'GRAMS/M**2'
            PERLBL(ITYP) = 'GRAMS/M**2'
            OUTTYP(ITYP) = 'DDEP'
            IF ( WDEP ) THEN
               ITYP = 3
               CHIDEP(1,ITYP) = '    '
               CHIDEP(2,ITYP) = 'WET '
               CHIDEP(3,ITYP) = 'DEPO'
               CHIDEP(4,ITYP) = 'SITI'
               CHIDEP(5,ITYP) = 'ON  '
               CHIDEP(6,ITYP) = '    '
               EMIFAC(ITYP) = 3600.
               EMILBL(ITYP) = 'GRAMS/SEC'
               OUTLBL(ITYP) = 'GRAMS/M**2'
               PERLBL(ITYP) = 'GRAMS/M**2'
               OUTTYP(ITYP) = 'WDEP'
            ENDIF
         ELSEIF ( WDEP ) THEN
            ITYP = 2
            CHIDEP(1,ITYP) = '    '
            CHIDEP(2,ITYP) = 'WET '
            CHIDEP(3,ITYP) = 'DEPO'
            CHIDEP(4,ITYP) = 'SITI'
            CHIDEP(5,ITYP) = 'ON  '
            CHIDEP(6,ITYP) = '    '
            EMIFAC(ITYP) = 3600.
            EMILBL(ITYP) = 'GRAMS/SEC'
            OUTLBL(ITYP) = 'GRAMS/M**2'
            PERLBL(ITYP) = 'GRAMS/M**2'
            OUTTYP(ITYP) = 'WDEP'
         ENDIF
      ELSEIF ( DEPOS ) THEN
         ITYP = 1
         CHIDEP(1,ITYP) = '  TO'
         CHIDEP(2,ITYP) = 'TAL '
         CHIDEP(3,ITYP) = 'DEPO'
         CHIDEP(4,ITYP) = 'SITI'
         CHIDEP(5,ITYP) = 'ON  '
         CHIDEP(6,ITYP) = '    '
         EMIFAC(ITYP) = 3600.
         EMILBL(ITYP) = 'GRAMS/SEC'
         OUTLBL(ITYP) = 'GRAMS/M**2'
         PERLBL(ITYP) = 'GRAMS/M**2'
         OUTTYP(ITYP) = 'DEPOS'
         IF ( DDEP ) THEN
            ITYP = 2
            CHIDEP(1,ITYP) = '    '
            CHIDEP(2,ITYP) = 'DRY '
            CHIDEP(3,ITYP) = 'DEPO'
            CHIDEP(4,ITYP) = 'SITI'
            CHIDEP(5,ITYP) = 'ON  '
            CHIDEP(6,ITYP) = '    '
            EMIFAC(ITYP) = 3600.
            EMILBL(ITYP) = 'GRAMS/SEC'
            OUTLBL(ITYP) = 'GRAMS/M**2'
            PERLBL(ITYP) = 'GRAMS/M**2'
            OUTTYP(ITYP) = 'DDEP'
            IF ( WDEP ) THEN
               ITYP = 3
               CHIDEP(1,ITYP) = '    '
               CHIDEP(2,ITYP) = 'WET '
               CHIDEP(3,ITYP) = 'DEPO'
               CHIDEP(4,ITYP) = 'SITI'
               CHIDEP(5,ITYP) = 'ON  '
               CHIDEP(6,ITYP) = '    '
               EMIFAC(ITYP) = 3600.
               EMILBL(ITYP) = 'GRAMS/SEC'
               OUTLBL(ITYP) = 'GRAMS/M**2'
               PERLBL(ITYP) = 'GRAMS/M**2'
               OUTTYP(ITYP) = 'WDEP'
            ENDIF
         ELSEIF ( WDEP ) THEN
            ITYP = 2
            CHIDEP(1,ITYP) = '    '
            CHIDEP(2,ITYP) = 'WET '
            CHIDEP(3,ITYP) = 'DEPO'
            CHIDEP(4,ITYP) = 'SITI'
            CHIDEP(5,ITYP) = 'ON  '
            CHIDEP(6,ITYP) = '    '
            EMIFAC(ITYP) = 3600.
            EMILBL(ITYP) = 'GRAMS/SEC'
            OUTLBL(ITYP) = 'GRAMS/M**2'
            PERLBL(ITYP) = 'GRAMS/M**2'
            OUTTYP(ITYP) = 'WDEP'
         ENDIF
      ELSEIF ( DDEP ) THEN
         ITYP = 1
         CHIDEP(1,ITYP) = '    '
         CHIDEP(2,ITYP) = 'DRY '
         CHIDEP(3,ITYP) = 'DEPO'
         CHIDEP(4,ITYP) = 'SITI'
         CHIDEP(5,ITYP) = 'ON  '
         CHIDEP(6,ITYP) = '    '
         EMIFAC(ITYP) = 3600.
         EMILBL(ITYP) = 'GRAMS/SEC'
         OUTLBL(ITYP) = 'GRAMS/M**2'
         PERLBL(ITYP) = 'GRAMS/M**2'
         OUTTYP(ITYP) = 'DDEP'
         IF ( WDEP ) THEN
            ITYP = 2
            CHIDEP(1,ITYP) = '    '
            CHIDEP(2,ITYP) = 'WET '
            CHIDEP(3,ITYP) = 'DEPO'
            CHIDEP(4,ITYP) = 'SITI'
            CHIDEP(5,ITYP) = 'ON  '
            CHIDEP(6,ITYP) = '    '
            EMIFAC(ITYP) = 3600.
            EMILBL(ITYP) = 'GRAMS/SEC'
            OUTLBL(ITYP) = 'GRAMS/M**2'
            PERLBL(ITYP) = 'GRAMS/M**2'
            OUTTYP(ITYP) = 'WDEP'
         ENDIF
      ELSEIF ( WDEP ) THEN
         ITYP = 1
         CHIDEP(1,ITYP) = '    '
         CHIDEP(2,ITYP) = 'WET '
         CHIDEP(3,ITYP) = 'DEPO'
         CHIDEP(4,ITYP) = 'SITI'
         CHIDEP(5,ITYP) = 'ON  '
         CHIDEP(6,ITYP) = '    '
         EMIFAC(ITYP) = 3600.
         EMILBL(ITYP) = 'GRAMS/SEC'
         OUTLBL(ITYP) = 'GRAMS/M**2'
         PERLBL(ITYP) = 'GRAMS/M**2'
         OUTTYP(ITYP) = 'WDEP'
      ENDIF
 
      EMICON = 1.0E06
 
!     Modify PLTFRM and PSTFRM if needed for more than one output type
      IF ( NUMTYP.GT.1 ) THEN
         WRITE (PLTFRM,1009) NUMTYP + 2
 1009    FORMAT ('(',I1,                                                &
     &   '(1X,F13.5),3(1X,F8.2),3X,A5,2X,A8,2X,A4,6X,A8,2X,         I8)'&
     &   )
         WRITE (PSTFRM,1019) NUMTYP + 2
 1019    FORMAT ('(',I1,                                                &
     &           '(1X,F13.5),3(1X,F8.2),2X,A6,2X,A8,2X,I8.8,2X,A8)')
      ENDIF
 
      CONTINUE
      END
!*==AVETIM.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE AVETIM
!***********************************************************************
!                 AVETIM Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Averaging Time Options From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Averaging Period Array and PERIOD Logical Switch
!
!        ERROR HANDLING:   Checks for Too Many Short Term Averages (>4);
!                          Checks for Invalid Averaging Periods, MOD(24,X) NE 0;
!                          Checks for Duplicate Short Term Averaging Periods
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K
      REAL :: AVENUM
      CHARACTER*8 KOPT
 
!     Variable Initializations
      MODNAM = 'AVETIM'
 
!     Check for No Parameters
!        WRITE Error Message     ! No Parameters
      IF ( IFC.LT.3 ) CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
 
!     First Check for Presence of PERIOD or ANNUAL Switch
      DO I = 3 , IFC
         KOPT = FIELD(I)
         IF ( KOPT.EQ.'PERIOD' ) THEN
            PERIOD = .TRUE.
         ELSEIF ( KOPT.EQ.'ANNUAL' ) THEN
            ANNUAL = .TRUE.
         ENDIF
      ENDDO
 
!     Check for Both PERIOD and ANNUAL
      IF ( PERIOD .AND. ANNUAL )                                        &
     &     CALL ERRHDL(PATH,MODNAM,'E','294',KEYWRD)
 
!     Check for Too Many Averaging Periods
      IF ( PERIOD .OR. ANNUAL ) THEN
!           WRITE Error Message: Too Many Period Or Time Fields
         IF ( IFC.GT.NAVE+3 ) CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!           WRITE Error Message: Too Many Period Or Time Fields
         IF ( IFC.GT.NAVE+2 ) CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ENDIF
 
!     Loop Through Fields Again, Filling KAVE Array for Short Term Averages
      J = 0
      DO I = 3 , IFC
         KOPT = FIELD(I)
         IF ( KOPT.NE.'PERIOD' .AND. KOPT.NE.'ANNUAL' ) THEN
            IF ( KOPT.NE.'MONTH' ) THEN
               CALL STONUM(KOPT,8,AVENUM,IMIT)
!                 Write Error Message:Invalid Numerical Field
               IF ( IMIT.EQ.-1 )                                        &
     &              CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
!              Check for Valid Averaging Period
               IF ( (MOD(24,INT(AVENUM)).EQ.0 .AND. IMIT.EQ.1) ) THEN
                  J = J + 1
                  IF ( J.LE.NAVE ) THEN
                     KAVE(J) = AVENUM
                     WRITE (CHRAVE(J),'(I2,"-HR")') KAVE(J)
                     NUMAVE = J
!                    Check for Duplicate Averaging Periods
                     DO K = J - 1 , 1 , -1
!                          WRITE Error Message    ! Duplicate Averaging Period
                        IF ( KAVE(J).EQ.KAVE(K) )                       &
     &                       CALL ERRHDL(PATH,MODNAM,'E','211',KEYWRD)
                     ENDDO
                  ELSE
!                    WRITE Error Message   ! Too Many Short Term Averaging Periods
                     WRITE (DUMMY,'(I8)') NAVE
                     CALL ERRHDL(PATH,MODNAM,'E','210',DUMMY)
                  ENDIF
               ELSE
!                 WRITE Error Message      ! Invalid Averaging Period
                  CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
               ENDIF
            ELSE
               J = J + 1
               IF ( J.LE.NAVE ) THEN
                  KAVE(J) = 720
                  MONTH = .TRUE.
                  CHRAVE(J) = 'MONTH'
                  NUMAVE = J
!                 Check for Duplicate Averaging Periods
                  DO K = J - 1 , 1 , -1
!                       WRITE Error Message    ! Duplicate Averaging Period
                     IF ( KAVE(J).EQ.KAVE(K) )                          &
     &                     CALL ERRHDL(PATH,MODNAM,'E','211',KEYWRD)
                  ENDDO
               ELSE
!                 WRITE Error Message   ! Too Many Short Term Averaging Periods
                  WRITE (DUMMY,'(I8)') NAVE
                  CALL ERRHDL(PATH,MODNAM,'E','210',DUMMY)
               ENDIF
            ENDIF
         ENDIF
      ENDDO
 
      CONTINUE
      END
!*==POLLID.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE POLLID
!***********************************************************************
!                 POLLID Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Pollutant Identification Option
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Pollutant Identification Option
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'POLLID'
 
!     Check The Number Of The Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.3 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      POLLUT = FIELD(3)
 
 999  CONTINUE
      END
!*==EDECAY.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EDECAY
!***********************************************************************
!                 EDECAY Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Exponential Decay Options
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Exponental Decay Options
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EDECAY'
 
!     Check The Number Of The Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.3 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Start To Get Decay Coef.
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
 
      IF ( KEYWRD.EQ.'HALFLIFE' ) THEN
         HAFLIF = FNUM
!        Calculate Decay Coef. by Halflife
         DECOEF = 0.693/HAFLIF
      ELSEIF ( KEYWRD.EQ.'DCAYCOEF' ) THEN
         DECOEF = FNUM
      ENDIF
 
!     Check for Urban Regulatory Default for SO2
      IF ( DFAULT .AND. URBAN .AND. POLLUT.EQ.'SO2' ) THEN
!           WRITE Warning Message: Attempt to Override Regulatory Default
         IF ( DECOEF.NE.4.81E-5 )                                       &
     &         CALL ERRHDL(PATH,MODNAM,'W','206','DCAYCOEF')
         DECOEF = 4.81E-5
      ELSEIF ( DFAULT ) THEN
!           WRITE Warning Message: Attempt to Override Regulatory Default
         IF ( DECOEF.NE.0.0 )                                           &
     &         CALL ERRHDL(PATH,MODNAM,'W','206','DCAYCOEF')
         DECOEF = 0.0
      ENDIF
 
 999  CONTINUE
      END
!*==RUNNOT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE RUNNOT
!***********************************************************************
!                 RUNNOT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Option To RUN Or NOT From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Model RUN Logical Switch
!
!        ERROR HANDLING:   Checks for Invalid Parameters;
!                          Checks for No Parameters;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'RUNNOT'
 
      IF ( IFC.EQ.3 ) THEN
         IF ( FIELD(3).EQ.'RUN' ) THEN
            RUN = .TRUE.
         ELSEIF ( FIELD(3).EQ.'NOT' ) THEN
            RUN = .FALSE.
         ELSE
!           WRITE Error Message  ! Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         ENDIF
      ELSEIF ( IFC.GT.3 ) THEN
!        WRITE Error Message     ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==FLAGDF.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE FLAGDF
!***********************************************************************
!                 FLAGDF Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Default Flagpole Receptor Height Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Default Flagpole Receptor Heights
!
!        ERROR HANDLING:   Checks for Invalid Parameters;
!                          Checks for No Parameters;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
      REAL :: ZFLG
 
!     Variable Initializations
      MODNAM = 'FLAGDF'
      FLGPOL = .TRUE.
 
      IF ( IFC.EQ.3 ) THEN
         CALL STONUM(FIELD(3),ILEN_FLD,ZFLG,IMIT)
!           Write Error Message:Invalid Numerical Field
         IF ( IMIT.EQ.-1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         IF ( ZFLG.GE.0.0 .AND. IMIT.EQ.1 ) THEN
            DO I = 1 , NREC
               AZFLAG(I) = ZFLG
            ENDDO
         ELSEIF ( ZFLG.LT.0.0 ) THEN
!            WRITE Error Message: Invalid Data. Positive Value Turns Negative
            CALL ERRHDL(PATH,MODNAM,'E','209','ZFLAG')
         ELSEIF ( IMIT.NE.1 ) THEN
!            WRITE Error Message: Field Number Not Meet Requirement
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
!            WRITE Error Message: Invalid Parameter
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         ENDIF
      ELSEIF ( IFC.GT.3 ) THEN
!        WRITE Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'W','205','ZFLAG=0.')
      ENDIF
 
      CONTINUE
      END
!*==EVNTFL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EVNTFL
!***********************************************************************
!                 EVNTFL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process EVENT File Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: EVENT File Logical Switch and EVENT Filename
!
!        ERROR HANDLING:   Checks for No Parametes;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EVNTFL'
 
      IF ( IFC.EQ.3 ) THEN
         EVENTS = .TRUE.
         EVFILE = RUNST1(LOCB(3):LOCE(3))
         EVPARM = 'DETAIL'
      ELSEIF ( IFC.EQ.4 ) THEN
         EVENTS = .TRUE.
         EVFILE = RUNST1(LOCB(3):LOCE(3))
         EVPARM = FIELD(4)
      ELSEIF ( IFC.GT.4 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Warning Message         ! No Parameters - Use Default Name
         CALL ERRHDL(PATH,MODNAM,'W','207',KEYWRD)
         EVENTS = .TRUE.
         EVFILE = 'EVENTS.INP'
         EVPARM = 'DETAIL'
      ENDIF
 
!     Check for Invalid EVPARM
!        WRITE Warning Message         ! Invalid Parameter - Use Default
      IF ( EVPARM.NE.'SOCONT' .AND. EVPARM.NE.'DETAIL' )                &
     &     CALL ERRHDL(PATH,MODNAM,'W','203','EVPARM')
 
!     Open The EVENT Input File
      OPEN (UNIT=IEVUNT,FILE=EVFILE,STATUS='UNKNOWN',FORM='FORMATTED')
 
      CONTINUE
      END
!*==SAVEFL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SAVEFL
!***********************************************************************
!                 SAVEFL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process RESTART File Save Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: RSTSAV File Logical Switch and RESTART Filename
!
!        ERROR HANDLING:   Checks for No Parametes (uses default name);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'SAVEFL'
 
      IF ( MULTYR ) THEN
!        WRITE Error Message:  Conflicting Options RE-START and MULTYEAR
         CALL ERRHDL(PATH,MODNAM,'E','145',KEYWRD)
      ELSEIF ( IFC.EQ.3 ) THEN
         RSTSAV = .TRUE.
         SAVFIL = RUNST1(LOCB(3):LOCE(3))
         SAVFL2 = SAVFIL
         INCRST = 1
      ELSEIF ( IFC.EQ.4 ) THEN
         RSTSAV = .TRUE.
         SAVFIL = RUNST1(LOCB(3):LOCE(3))
         SAVFL2 = SAVFIL
         CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
         INCRST = NINT(FNUM)
!           Write Error Message:Invalid Numerical Field
         IF ( IMIT.EQ.-1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSEIF ( IFC.EQ.5 ) THEN
         RSTSAV = .TRUE.
         SAVFIL = RUNST1(LOCB(3):LOCE(3))
         CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
         INCRST = NINT(FNUM)
!           Write Error Message:Invalid Numerical Field
         IF ( IMIT.EQ.-1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         SAVFL2 = RUNST1(LOCB(5):LOCE(5))
      ELSEIF ( IFC.GT.5 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Warning Message          ! No Parameters - Use Default Name
         CALL ERRHDL(PATH,MODNAM,'W','207',KEYWRD)
         RSTSAV = .TRUE.
         SAVFIL = 'SAVE.FIL'
         SAVFL2 = SAVFIL
         INCRST = 1
      ENDIF
 
      CONTINUE
      END
!*==INITFL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE INITFL
!***********************************************************************
!                 INITFL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process RESTART Initialization Input File Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To change default filename to SAVE.FIL to match
!                    default name for SAVEFILE card.
!                    R.W. Brode, PES, Inc. - 6/20/95
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: RSTINP Logical Switch and Re-start Input Filename
!
!        ERROR HANDLING:   Checks for No Parametes (uses default name);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'INITFL'
 
      IF ( MULTYR ) THEN
!        WRITE Error Message:  Conflicting Options RE-START and MULTYEAR
         CALL ERRHDL(PATH,MODNAM,'E','145',KEYWRD)
      ELSEIF ( IFC.EQ.3 ) THEN
         RSTINP = .TRUE.
         INIFIL = RUNST1(LOCB(3):LOCE(3))
      ELSEIF ( IFC.GT.3 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Warning Message          ! No Parameters - Use Default Name
         CALL ERRHDL(PATH,MODNAM,'W','207',KEYWRD)
         RSTINP = .TRUE.
         INIFIL = 'SAVE.FIL'
      ENDIF
 
      CONTINUE
      END
!*==ERRFIL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ERRFIL
!***********************************************************************
!                 ERRFIL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Error Message File Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Error Message File Logical Switch and ERRMSG Filename
!
!        ERROR HANDLING:   Checks for No Parametes (uses default name);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'ERRFIL'
 
      IF ( IFC.EQ.3 ) THEN
         ERRLST = .TRUE.
         MSGFIL = RUNST1(LOCB(3):LOCE(3))
      ELSEIF ( IFC.GT.3 ) THEN
!*       WRITE Error Message                ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!*       WRITE Warning Message              ! No Parameters - Use Default Name
         CALL ERRHDL(PATH,MODNAM,'W','207',KEYWRD)
         ERRLST = .TRUE.
         MSGFIL = 'ERRORS.LST'
      ENDIF
!*#
 
      CONTINUE
      END
!*==DEBOPT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE DEBOPT
!***********************************************************************
!                 DEBOPT Module of AERMOD
!
!        PURPOSE: Process Debug Output File Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Debug File Logical Switches and Filenames
!
!        ERROR HANDLING:   Checks for Too Few Parameters (uses default name);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12 , KOPT*8
      INTEGER :: I
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'DEBOPT'
 
!     Check for Too Few or Too Many Parameters
      IF ( IFC.LT.3 ) THEN
!        WRITE Error Message     ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ELSEIF ( IFC.GT.6 ) THEN
!        WRITE Warning Message   ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ENDIF
 
!     First Check for Presence of Debug Switches
      DO I = 3 , IFC
         KOPT = FIELD(I)
         IF ( KOPT.EQ.'MODEL' ) THEN
            DEBUG = .TRUE.
         ELSEIF ( KOPT.EQ.'METEOR' ) THEN
            METEOR = .TRUE.
         ENDIF
      ENDDO
 
!     Check for presence of filenames - use defaults if none given.
      IF ( IFC.EQ.3 .AND. DEBUG ) THEN
         DBGFIL = 'MODEL.DBG'
      ELSEIF ( IFC.EQ.3 .AND. METEOR ) THEN
         DBMFIL = 'METEOR.DBG'
      ELSEIF ( IFC.EQ.4 .AND. DEBUG .AND. METEOR ) THEN
         DBGFIL = 'MODEL.DBG'
         DBMFIL = 'METEOR.DBG'
      ELSEIF ( IFC.EQ.4 .AND. DEBUG ) THEN
         DBGFIL = RUNST1(LOCB(4):LOCE(4))
      ELSEIF ( IFC.EQ.4 .AND. METEOR ) THEN
         DBMFIL = RUNST1(LOCB(4):LOCE(4))
      ELSEIF ( IFC.EQ.5 .AND. DEBUG .AND. METEOR ) THEN
         IF ( FIELD(4).NE.'METEOR' ) THEN
            DBGFIL = RUNST1(LOCB(4):LOCE(4))
            DBMFIL = 'METEOR.DBG'
         ELSE
            DBGFIL = 'MODEL.DBG'
            DBMFIL = RUNST1(LOCB(5):LOCE(5))
         ENDIF
      ELSEIF ( IFC.EQ.6 .AND. (DEBUG) .AND. METEOR ) THEN
         DBGFIL = RUNST1(LOCB(4):LOCE(4))
         DBMFIL = RUNST1(LOCB(6):LOCE(6))
      ELSE
!        WRITE Error Message and Reset Logical Flags to .FALSE.
         CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
         DEBUG = .FALSE.
         METEOR = .FALSE.
      ENDIF
 
      IF ( DEBUG ) THEN
!        Open debug output file
         DUMMY = 'DBGFIL'
         OPEN (UNIT=DBGUNT,FILE=DBGFIL,ERR=99,STATUS='UNKNOWN')
      ENDIF
 
      IF ( METEOR ) THEN
!        Open debug meteorology profile output file
         DUMMY = 'DBMFIL'
         OPEN (UNIT=DBMUNT,FILE=DBMFIL,ERR=99,STATUS='UNKNOWN')
      ENDIF
 
      GOTO 999
 
!     WRITE Error Message:  Error Opening File
 99   CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)
 
 999  CONTINUE
      END
!*==MYEAR.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MYEAR
!***********************************************************************
!                 MYEAR Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process RESTART File Save Option
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: RSTSAV File Logical Switch and RESTART Filename
!
!        ERROR HANDLING:   Checks for No Parametes (uses default name);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'MYEAR'
 
      IF ( RSTSAV .OR. RSTINP ) THEN
!        WRITE Error Message:  Conflicting Options RE-START and MULTYEAR
         CALL ERRHDL(PATH,MODNAM,'E','145',KEYWRD)
      ELSEIF ( POLLUT.NE.'PM10' .AND. POLLUT.NE.'PM-10' .AND.           &
     &         POLLUT.NE.'LEAD' .AND. POLLUT.NE.'OTHER' ) THEN
!        WRITE Error Message:  Conflicting Options MULTYEAR For Wrong POLLUT
         CALL ERRHDL(PATH,MODNAM,'E','150',KEYWRD)
      ELSEIF ( IFC.EQ.4 ) THEN
         IF ( FIELD(3).EQ.'H6H' ) THEN
            MULTYR = .TRUE.
            RSTSAV = .TRUE.
!           Use Character Substring to Retrieve Filenames to Maintain Case
            SAVFIL = RUNST1(LOCB(4):LOCE(4))
            SAVFL2 = SAVFIL
!           Value of INCRST is Set to 365 or 366 in SUB. MECARD
         ELSE
!           Write Error Message:  Missing Secondary Keyword
            CALL ERRHDL(PATH,MODNAM,'E','352','  H6H  ')
         ENDIF
      ELSEIF ( IFC.EQ.5 ) THEN
         IF ( FIELD(3).EQ.'H6H' ) THEN
            MULTYR = .TRUE.
            RSTSAV = .TRUE.
!           Use Character Substring to Retrieve Filenames to Maintain Case
            SAVFIL = RUNST1(LOCB(4):LOCE(4))
            SAVFL2 = SAVFIL
            RSTINP = .TRUE.
            INIFIL = RUNST1(LOCB(5):LOCE(5))
!           Value of INCRST is Set to 365 or 366 in SUB. MECARD
         ELSE
!           Write Error Message:  Missing Secondary Keyword
            CALL ERRHDL(PATH,MODNAM,'E','352','  H6H  ')
         ENDIF
      ELSEIF ( IFC.GT.5 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSEIF ( IFC.EQ.3 .AND. FIELD(3).EQ.'H6H' ) THEN
!        WRITE Error Message           ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
      ELSEIF ( IFC.EQ.3 .AND. FIELD(3).NE.'H6H' ) THEN
!        Write Error Message:  Missing Secondary Keyword
         CALL ERRHDL(PATH,MODNAM,'E','352','  H6H  ')
      ELSEIF ( IFC.LT.3 ) THEN
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ENDIF
 
!        Write Warning Message:  Use of old PM10 processing option
      IF ( POLLUT.EQ.'PM10' .OR. POLLUT.EQ.'PM-10' )                    &
     &     CALL ERRHDL(PATH,MODNAM,'W','353','PRE-1997')
 
      CONTINUE
      END
!*==GDDEF.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GDDEF
!***********************************************************************
!                 GDDEF Module of ISC3 Model
!
!        PURPOSE: Processes Dry Deposition Default Parameters for Gases
!
!        PROGRAMMER: R. W. Brode, PES, Inc.
!
!        DATE:    May 16, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Dry Deposition Reference Parameters for Gases
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'GDDEF'
 
!     Check the Number of Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.5 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.6 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Read Gas Dry Deposition Parameters
!     Change Them To Numbers
!     First Get Reactivity Value (fo)
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
!     Assign The Field
      FO = FNUM
 
!     Now Get Fraction of Maximum Green LAI for Seasonal Category 2
      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
!     Assign The Field
      FSEAS2 = FNUM
 
!     Now Get Fraction of Maximum Green LAI for Seasonal Category 5
      CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
!     Assign The Field
      FSEAS5 = FNUM
 
      IF ( IFC.EQ.6 ) THEN
!        Get the Reference Species (Optional)
         REFSPE = FIELD(6)
      ELSE
         REFSPE = '      '
      ENDIF
 
 999  CONTINUE
      END
!*==GDSEAS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GDSEAS
!***********************************************************************
!                 GDSEAS Module of ISC3 Model
!
!        PURPOSE: Define Seasons for Gas Dry Deposition (per Wesely)
!
!        PROGRAMMER: R. W. Brode, PES, Inc.
!
!        DATE:    May 18, 2001
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Dry Deposition Reference Parameters for Gases
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER I , J , ISEA_NDX
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'GDSEAS'
 
!     Check the Number of Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.3 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.14 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      ISET = 0
      DO I = 3 , IFC
!        Change Fields To Numbers
         CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 100
         ENDIF
         DO J = 1 , IMIT
            ISET = ISET + 1
!           Assign The Field
            IF ( ISET.LE.12 ) THEN
               ISEA_NDX = NINT(FNUM)
               IF ( ISEA_NDX.GE.1 .AND. ISEA_NDX.LE.5 ) THEN
                  ISEAS_GD(ISET) = ISEA_NDX
               ELSE
!                 WRITE Error Message    ! Season Index out-of-range
                  CALL ERRHDL(PATH,MODNAM,'E','380',KEYWRD)
               ENDIF
            ELSE
!              WRITE Error Message    ! Too Many Months Input
               CALL ERRHDL(PATH,MODNAM,'E','234',KEYWRD)
            ENDIF
         ENDDO
 100  ENDDO
 
      LDGAS = .TRUE.
 
 999  CONTINUE
      END
!*==GVSUBD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GVSUBD
!***********************************************************************
!                 GVSUBD Module of ISC3 Model
!
!        PURPOSE: Processes Dry Deposition Reference Parameters for Gases
!
!        PROGRAMMER: R. W. Brode, PES, Inc.
!
!        DATE:    September 3, 1996
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: User-specified Dry Deposition Velocity for Gases
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'GVSUBD'
 
!     Check the Number of Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.3 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.3 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Read User-specified Dry Deposition Velocity
!     Change Them To Numbers
!     First Get Reference Cuticle Resistance
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
!     Assign The Field
      USERVD = FNUM
 
!     Perform range/validity check
      IF ( USERVD.LT.0.0 ) THEN
!        Write Error Message:  Negative deposition velocity
         CALL ERRHDL(PATH,MODNAM,'E','209',' USERVD ')
      ELSEIF ( USERVD.EQ.0.0 ) THEN
!        Write Error Message:  Deposition velocity = 0.0
         CALL ERRHDL(PATH,MODNAM,'W','320',' USERVD ')
      ELSEIF ( USERVD.GT.0.05 ) THEN
!        Write Warning Message:  Large deposition velocity
         CALL ERRHDL(PATH,MODNAM,'W','320',' USERVD ')
      ENDIF
 
!     Set Logical Variable for User-specified Deposition Velocity
      LUSERVD = .TRUE.
 
!     Set logical LDGAS to indicate processing of gaseous dry deposition
      LDGAS = .TRUE.
 
 999  CONTINUE
      END
!*==GDLAND.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GDLAND
!***********************************************************************
!                 GDLAND Module of ISC3 Model
!
!        PURPOSE: Define Land Use Categories by Direction for
!                 Gas Dry Deposition (per Wesely, et al, 2001)
!
!        PROGRAMMER: R. W. Brode, PES, Inc.
!
!        DATE:    December 30, 2002
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Dry Deposition Reference Parameters for Gases
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER I , J , ILAND_NDX
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'GDLAND'
 
!     Check the Number of Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.3 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.38 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      ISET = 0
      DO I = 3 , IFC
!        Change Fields To Numbers
         CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 100
         ENDIF
         DO J = 1 , IMIT
            ISET = ISET + 1
!           Assign The Field
            IF ( ISET.LE.36 ) THEN
               ILAND_NDX = NINT(FNUM)
               IF ( ILAND_NDX.GE.1 .AND. ILAND_NDX.LE.9 ) THEN
                  ILAND_GD(ISET) = ILAND_NDX
               ELSE
!                 WRITE Error Message    ! Land Use Index out-of-range
                  CALL ERRHDL(PATH,MODNAM,'E','380',KEYWRD)
               ENDIF
            ELSE
!              WRITE Error Message    ! Too Many Directions Input
               CALL ERRHDL(PATH,MODNAM,'E','234',KEYWRD)
            ENDIF
         ENDDO
 100  ENDDO
 
      LDGAS = .TRUE.
 
 999  CONTINUE
      END
!*==URBOPT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE URBOPT
!***********************************************************************
!                 URBOPT Module of AERMOD Model
!
!        PURPOSE: Process Urban Option Inputs
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    June 11, 1996
!
!        MODIFIED:   To include optional parameter for urban roughness
!                    length.  Defaults to 1.0 meter if no value input.
!                    R.W. Brode, PES, Inc. - 09/10/02
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: URBPOP  [R]  Urban population
!                 URBNAM  [C]  Name of urban area (optional)
!                 URBZ0   [R]  Urban roughness lenght, m (optional)
!                                defaults to 1.0 meter
!
!        ERROR HANDLING:   Checks for Invalid Parameters;
!                          Checks for No Parameters;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'URBOPT'
      URBAN = .TRUE.
 
!     Determine Whether There Are Too Few Or Too Many Parameter Fields
      IF ( IFC.LT.3 ) THEN
!        WRITE Error Message: Missing Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.5 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GE.3 ) THEN
         CALL STONUM(FIELD(3),ILEN_FLD,URBPOP,IMIT)
!           Write Error Message:Invalid Numerical Field
         IF ( IMIT.EQ.-1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSE
!        WRITE Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'W','200',KEYWRD)
      ENDIF
 
!        Assign name of urban area (optional)
      IF ( IFC.GE.4 ) URBNAM = FIELD(4)
 
      IF ( IFC.EQ.5 ) THEN
!        Assign value of urban roughness length (optional)
         CALL STONUM(FIELD(5),ILEN_FLD,URBZ0,IMIT)
!           Write Error Message:Invalid Numerical Field
         IF ( IMIT.EQ.-1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         IF ( URBZ0.LT.0.50 ) THEN
!           Write Warning Message: Urban roughness out of range
            CALL ERRHDL(PATH,MODNAM,'W','320','URBAN Z0')
         ELSEIF ( URBZ0.GT.1.50 .AND. URBZ0.LT.5.0 ) THEN
!           Write Warning Message: Urban roughness out of range
            CALL ERRHDL(PATH,MODNAM,'W','320','URBAN Z0')
         ELSEIF ( URBZ0.GE.5.0 ) THEN
!           Write Error Message: Urban roughness out of range
            CALL ERRHDL(PATH,MODNAM,'E','320','URBAN Z0')
         ENDIF
      ELSE
         URBZ0 = 1.0
      ENDIF
 
 999  CONTINUE
      END
!*==O3VAL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE O3VAL
!***********************************************************************
!                 O3VAL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes Ozone Value Option
!
!        PROGRAMMER: Roger W. Brode
!
!        DATE:    May 3, 2002
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS:
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'O3VAL'
 
!     Check The Number Of The Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.4 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Start To Get Ozone Value
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
 
!     Assign value to O3BACK variable
      O3BACK = FNUM
 
!     Check for units of ozone value
      IF ( IFC.EQ.4 ) THEN
         IF ( FIELD(4).EQ.'PPM' .OR. FIELD(4).EQ.'PPB' .OR. FIELD(4)    &
     &        .EQ.'UG/M3' ) THEN
            O3VALUNITS = FIELD(4)
         ELSE
!           Write Error Message:  Invalid units for ozone value
            CALL ERRHDL(PATH,MODNAM,'E','203',' O3UNITS')
         ENDIF
      ELSE
         O3VALUNITS = 'UG/M3'
      ENDIF
 
      IF ( O3VALUNITS.EQ.'PPB' ) THEN
         O3BACK = (O3BACK/1000.)*1960.
      ELSEIF ( O3VALUNITS.EQ.'PPM' ) THEN
         O3BACK = O3BACK*1960.
      ENDIF
 
!     Check range of value
      IF ( O3BACK.LE.0.0 .OR. O3BACK.GT.500.0 )                         &
     &      CALL ERRHDL(PATH,MODNAM,'W','320',' O3BACK ')
 
 999  CONTINUE
      END
!*==O3FIL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE O3FIL
!***********************************************************************
!                 O3FIL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Ozone Data File Option
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    May 3, 2002
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS:
!
!        ERROR HANDLING:   Checks for No Parametes (uses default name);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   COCARD
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'O3FIL'
 
!     Check The Number Of The Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.3 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.5 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      O3FILE = .TRUE.
      OZONFL = RUNST1(LOCB(3):LOCE(3))
 
!     Open The EVENT Input File
      OPEN (UNIT=IO3UNT,FILE=OZONFL,STATUS='OLD',ERR=998,               &
     &      FORM='FORMATTED')
 
!     Check for units of ozone value
      IF ( IFC.GE.4 ) THEN
         IF ( FIELD(4).EQ.'PPM' .OR. FIELD(4).EQ.'PPB' .OR. FIELD(4)    &
     &        .EQ.'UG/M3' ) THEN
            O3FILUNITS = FIELD(4)
         ELSE
!           Write Error Message:  Invalid units for ozone value
            CALL ERRHDL(PATH,MODNAM,'E','203',' O3UNITS')
         ENDIF
      ELSE
         O3FILUNITS = 'UG/M3'
      ENDIF
 
      IF ( IFC.EQ.5 ) THEN
         O3FORM = FIELD(5)
      ELSE
         O3FORM = 'FREE'
      ENDIF
 
      GOTO 999
 
!     Process Error Messages
 998  CALL ERRHDL(PATH,MODNAM,'E','500',KEYWRD)
 
 999  CONTINUE
      END
!*==NO2EQ.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE NO2EQ
!***********************************************************************
!                 NO2EQ Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Processes NO2 Equilibrium Value for PVMRM
!
!        PROGRAMMER: Roger W. Brode
!
!        DATE:    May 3, 2004
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS:
!
!        CALLED FROM:   COCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'NO2EQ'
 
!     Check The Number Of The Fields
      IF ( IFC.LE.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.3 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Start To Get Ozone Value
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
 
!     Assign value to NO2Equil variable
      NO2EQUIL = FNUM
 
!     Check range of value
      IF ( NO2EQUIL.LT.0.10 .OR. NO2EQUIL.GT.1.0 )                      &
     &     CALL ERRHDL(PATH,MODNAM,'E','380','NO2Equil')
 
 999  CONTINUE
      END
!*==EV_SETUP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE EV_SETUP
!***********************************************************************
!                 EV_SETUP Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Controls Processing of Run SETUP Information
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!        MODIFIED BY D. Strimaitis, SRC (for GRIDDED TERRAIN Processing)
!
!        MODIFIED:   Moved the code to insert a blank line in temporary event
!                    file after each pathway from SUB EVEFIL.
!                    R.W. Brode, PES, Inc. - November 15, 1995.
!
!        MODIFIED:  Default format for METFRM modified to eliminate the
!                   variable ZDM on input.
!                   BY:  J. Paumier, PES              DATE: 27 July 1994
!
!        DATE:    December 15, 1993
!
!        INPUTS:  Input Runstream File
!
!        OUTPUTS: Processing Option Switches
!                 Arrays of Source Parameters
!                 Arrays of Receptor Locations
!                 Meteorological Data Specifications
!                 Terrain Grid Data Specifications
!                 Output Options
!
!        CALLED FROM:   MAIN
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IFSTAT
      LOGICAL NOPATH , NOKEY
      CHARACTER RDFRM*20 , ECFRM*20 , EVFRM*20
      CHARACTER INPFLD*2 , PATHWY(7)*2
      INTERFACE
      SUBROUTINE EXPATH(INPFLD,PATHWY,IPN,NOPATH)
      CHARACTER(LEN=2) , INTENT(IN) :: INPFLD
      CHARACTER(LEN=2) , INTENT(IN) , DIMENSION(:) :: PATHWY
      INTEGER , INTENT(IN) :: IPN
      LOGICAL , INTENT(OUT) :: NOPATH
      END
      END INTERFACE
 
 
!     Variable Initializations
      MODNAM = 'EV_SETUP'
      EOF = .FALSE.
      ILINE = 0
 
!     Setup READ format and ECHO format for runstream record,
!     based on the ISTRG PARAMETER (set in MAIN1)
      WRITE (RDFRM,9100) ISTRG , ISTRG
 9100 FORMAT ('(A',I3.3,',T1,',I3.3,'A1)')
      WRITE (ECFRM,9250) ISTRG
 9250 FORMAT ('(1X,A',I3.3,')')
      WRITE (EVFRM,9300) ISTRG
 9300 FORMAT ('(A',I3.3,')')
 
!     LOOP Through Input Runstream Records
      DO WHILE ( .NOT.EOF )
 
!        Increment the Line Counter
         ILINE = ILINE + 1
 
!        READ Record to Buffers, as A80 and 80A1 for ISTRG = 80.
!        Length of ISTRG is Set in PARAMETER Statement in MAIN1
         READ (INUNIT,RDFRM,END=999) RUNST1 , (RUNST(I),I=1,ISTRG)
 
!        Convert Lower Case to Upper Case Letters           ---   CALL LWRUPR
         CALL LWRUPR
 
!        Define Fields on Card                              ---   CALL DEFINE
         CALL DEFINE
 
!        Get the Contents of the Fields                     ---   CALL GETFLD
         CALL GETFLD
 
         IF ( ECHO .AND. (FIELD(1).EQ.'OU' .AND. FIELD(2).EQ.'FINISHED')&
     &        ) THEN
!           Echo Last Input Card to Output File (Use Character Substring to
!           Avoid Echoing ^Z Which May Appear at "End of File" for Some
!           Editors).  Also, Allow for Shift in the Input Runstream File of
!           Up to 3 Columns.
            IF ( LOCB(1).EQ.1 ) THEN
               WRITE (IOUNIT,9200) RUNST1(1:11)
 9200          FORMAT (' ',A11)
            ELSEIF ( LOCB(1).EQ.2 ) THEN
               WRITE (IOUNIT,9210) RUNST1(1:12)
 9210          FORMAT (' ',A12)
            ELSEIF ( LOCB(1).EQ.3 ) THEN
               WRITE (IOUNIT,9220) RUNST1(1:13)
 9220          FORMAT (' ',A13)
            ELSEIF ( LOCB(1).EQ.4 ) THEN
               WRITE (IOUNIT,9230) RUNST1(1:14)
 9230          FORMAT (' ',A14)
            ENDIF
         ELSEIF ( ECHO ) THEN
!           Echo Full Input Card to Output File
            WRITE (IOUNIT,ECFRM) RUNST1
         ENDIF
 
!        If Blank Line, Then CYCLE to Next Card
         IF ( BLINE ) GOTO 11
 
!        Check for 'NO ECHO' In First Two Fields
         IF ( FIELD(1).EQ.'NO' .AND. FIELD(2).EQ.'ECHO' ) THEN
            ECHO = .FALSE.
            GOTO 11
         ENDIF
 
!        Extract Pathway ID From Field 1                    ---   CALL EXPATH
         PATHWY(1) = 'CO'
         PATHWY(2) = 'SO'
         PATHWY(3) = 'ME'
         PATHWY(4) = 'TG'
         PATHWY(5) = 'EV'
         PATHWY(6) = 'OU'
         PATHWY(7) = '**'
         CALL EXPATH(FIELD(1),PATHWY,7,NOPATH)
 
!        For Invalid Pathway and Comment Lines Skip to Next Record
         IF ( NOPATH ) THEN
!           WRITE Error Message    ! Invalid Pathway ID
            CALL ERRHDL(PPATH,MODNAM,'E','100',PATH)
            PATH = PPATH
            GOTO 11
         ELSEIF ( PATH.EQ.'**' ) THEN
            GOTO 11
         ENDIF
 
!        Extract Keyword From Field 2                       ---   CALL EXKEY
         CALL EXKEY(FIELD(2),NOKEY)
 
         IF ( NOKEY ) THEN
!           WRITE Error Message    ! Invalid Keyword
            CALL ERRHDL(PATH,MODNAM,'E','105',KEYWRD)
            PKEYWD = KEYWRD
            GOTO 11
         ENDIF
 
!        Check for Proper Order of Setup Cards              ---   CALL SETORD
         CALL EV_SETORD
 
!        Process Input Card Based on Pathway
         IF ( PATH.EQ.'CO' ) THEN
!           Process COntrol Pathway Cards                   ---   CALL COCARD
            CALL COCARD
         ELSEIF ( PATH.EQ.'SO' ) THEN
!           Process SOurce Pathway Cards                    ---   CALL SOCARD
            CALL SOCARD
         ELSEIF ( PATH.EQ.'ME' ) THEN
!           Process MEteorology Pathway Cards               ---   CALL MECARD
            CALL MECARD
         ELSEIF ( PATH.EQ.'EV' ) THEN
!           Process EVent Pathway Cards                     ---   CALL EVCARD
            CALL EVCARD
         ELSEIF ( PATH.EQ.'TG' ) THEN
!           Process Terrain Grid Pathway Cards              ---   CALL TGCARD
            CALL TGCARD
         ELSEIF ( PATH.EQ.'OU' ) THEN
!           Process OUtput Pathway Cards                    ---   CALL OUCARD
            CALL EV_OUCARD
         ENDIF
 
!        Store the Current Keyword as the Previous Keyword
         PKEYWD = KEYWRD
 
!        Check for 'OU FINISHED' Card.  Exit DO WHILE Loop By Branching
!        to Statement 999 in Order to Avoid Reading a ^Z "End of File"
!        Marker That May Be Present For Some Editors.
         IF ( PATH.EQ.'OU' .AND. KEYWRD.EQ.'FINISHED' ) GOTO 999
 
         GOTO 11
 999     EOF = .TRUE.
 11      CONTINUE
      ENDDO
 
!     Reinitialize Line Number Counter to Count Meteorology Data
      ILINE = 0
 
!     Check That All Pathways Were Finished
      IF ( ICSTAT(25).NE.1 .OR. ISSTAT(25).NE.1 .OR. IMSTAT(25)         &
     &     .NE.1 .OR. IESTAT(25).NE.1 .OR. IOSTAT(25).NE.1 ) THEN
!        Runstream File Incomplete, Save I?STAT to IFSTAT and Write Message
         IFSTAT = ICSTAT(25)*10000 + ISSTAT(25)*1000 + IMSTAT(25)       &
     &            *100 + IESTAT(25)*10 + IOSTAT(25)
         WRITE (DUMMY,'(I5.5)') IFSTAT
         CALL ERRHDL(PATH,MODNAM,'E','125',DUMMY)
      ENDIF
 
      CONTINUE
      END
!*==EV_SETORD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_SETORD
!***********************************************************************
!                 EV_SETORD Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Check Run Stream Setup Images for Proper
!                 Order
!
!        MODIFIED:   To allow for skipping of TG pathway if no terrain
!                    grid is used.  Roger Brode, PES, Inc. - 11/7/94
!
!        INPUTS:  Input Runstream Card Image
!
!        OUTPUTS: Status Settings and Error Messages
!
!        CALLED FROM:   SETUP
!***********************************************************************
!
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EV_SETORD'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
         IF ( ISTART .OR. .NOT.IFINIS ) THEN
!           WRITE Error Message: Starting Out of Order
            CALL ERRHDL(PPATH,MODNAM,'E','115',PATH)
         ELSEIF ( IPNUM.NE.IPPNUM+1 ) THEN
            IF ( PATH.EQ.'EV' .AND. PPATH.EQ.'ME' ) THEN
!              TG Pathway has been omitted - Assume no TG file and no error
               LTGRID = .FALSE.
            ELSE
!              WRITE Error Message: Pathway Out of Order
               CALL ERRHDL(PPATH,MODNAM,'E','120',PATH)
            ENDIF
         ENDIF
!        Set Starting Indicator
         ISTART = .TRUE.
!        Set Finished Indicator
         IFINIS = .FALSE.
      ELSEIF ( KEYWRD.EQ.'FINISHED' ) THEN
         IF ( IFINIS .OR. .NOT.ISTART ) THEN
!           WRITE Error Message: Finished Out of Order
            CALL ERRHDL(PPATH,MODNAM,'E','115',PATH)
         ELSEIF ( ISTART .AND. PATH.NE.PPATH ) THEN
!           WRITE Warning Message: Pathway Out of Order
            CALL ERRHDL(PPATH,MODNAM,'E','120',PATH)
         ENDIF
!        Reset Starting Indicator
         ISTART = .FALSE.
!        Set Finished Indicator
         IFINIS = .TRUE.
      ELSEIF ( .NOT.ISTART .OR. IFINIS ) THEN
!        WRITE Error Message: Starting or Finished Out of Order
         CALL ERRHDL(PPATH,MODNAM,'E','115',PATH)
      ELSEIF ( ISTART .AND. PATH.NE.PPATH ) THEN
!        WRITE Warning Message: Pathway Out of Order
         CALL ERRHDL(PPATH,MODNAM,'E','120',PATH)
      ENDIF
 
!     Save Current Path and Path Number as Previous Path and Number
      PPATH = PATH
      IPPNUM = IPNUM
 
      CONTINUE
      END
!*==EV_OUCARD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_OUCARD
!***********************************************************************
!                 EV_OUCARD Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: To process OUtput Pathway card images
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Pathway (OU) and Keyword
!
!        OUTPUTS: Output Option Switches
!                 Output Setup Status Switches
!
!        CALLED FROM:   SETUP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EV_OUCARD'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Set Status Switch
         IOSTAT(1) = IOSTAT(1) + 1
      ELSEIF ( KEYWRD.EQ.'EVENTOUT' ) THEN
!        Process EVENT Output File Option                ---   CALL OEVENT
         CALL OEVENT
!        Set Status Switch
         IOSTAT(2) = IOSTAT(2) + 1
      ELSEIF ( KEYWRD.EQ.'FINISHED' ) THEN
!        Set Status Switch
         IOSTAT(25) = IOSTAT(25) + 1
!        Check If Missing Mandatory Keyword
         IF ( IOSTAT(1).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         IF ( IOSTAT(2).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','EVENTOUT')
      ELSE
!        Write Error Message:  Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==OEVENT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OEVENT
!***********************************************************************
!                 OEVENT Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: To Process EVENT File Output Selections
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Parameters
!
!        OUTPUTS: Output Option Switches
!
!        CALLED FROM:   OUCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      CHARACTER OPTION*6
 
!     Variable Initializations
      MODNAM = 'OEVENT'
 
!     Check If Enough Fields
      IF ( IFC.EQ.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.3 ) THEN
!        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Assign Variable of EVENTOUT
      OPTION = FIELD(3)
      IF ( OPTION.EQ.'SOCONT' ) THEN
         SOCONT = .TRUE.
      ELSEIF ( OPTION.EQ.'DETAIL' ) THEN
         DETAIL = .TRUE.
      ELSE
!        WRITE Error Message:  Invalid Parameter Field
         CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==EVLOOP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EVLOOP
!***********************************************************************
!                 EVLOOP Module of ISC2 Short Term EVENT Model - ISCEV2
!
!        PURPOSE: Controls Main Calculation Loop Through Events
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To remove mixed-mode math in calculation of
!                    IENDHR - 4/19/93
!
!        INPUTS:  Source, Receptor and Setup Options
!
!        OUTPUTS: Update Hourly Results
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IEVYR
      LOGICAL FOPEN
 
!     Variable Initializations
      MODNAM = 'EVLOOP'
      EOF = .FALSE.
      FOPEN = .FALSE.
 
!     Flush HRVAL, AVEVAL, GRPAVE and GRPVAL    ---   CALL FLUSH
      CALL EV_FLUSH
 
      DO WHILE ( FULLDATE.LT.IEDATE .AND. .NOT.EOF )
!        Retrieve Hourly Meteorology Data for Current Day   ---   CALL MEREAD
         CALL MEREAD
 
!        Check for Hourly Emissions File
         INQUIRE (UNIT=IHREMI,OPENED=FOPEN)
!*          Retrieve Hourly Emissions from File for Current Day---   CALL HQREAD
         IF ( FOPEN ) CALL HQREAD
 
!        Write Out Update to the Screen for the PC Version
         WRITE (*,909) JDAY , IYR
 909     FORMAT ('+','Now Processing Events For Day No. ',I4,' of ',I4)
 
         IF ( IPROC(JDAY).EQ.1 .AND. .NOT.RUNERR ) THEN
!           Begin The Event Loop
            DO IEVENT = 1 , NUMEVE
 
!              Calculate year of event for multiple year data files
               IEVYR = INT(EVDATE(IEVENT)/1000000)
               IF ( EVJDAY(IEVENT).EQ.JDAY .AND. IEVYR.EQ.IYEAR ) THEN
 
                  IENDHR = EVDATE(IEVENT) - INT(EVDATE(IEVENT)/100)*100
                  ISTAHR = IENDHR - EVAPER(IEVENT) + 1
 
                  DO IHOUR = ISTAHR , IENDHR
                     KHOUR = IHOUR
!                    Retrieve Hourly Data for Current Event ---   CALL METEXT
                     CALL EV_METEXT
!*                   Process Hourly Emissions from File
!*                   Begin Source Loop
                     DO ISRC = 1 , NUMSRC
!*                        Retrieve Source Parameters for This Hour     ---   CALL HRQEXT
                        IF ( QFLAG(ISRC).EQ.'HOURLY' )                  &
     &                       CALL EV_HRQEXT(ISRC)
                     ENDDO
!*                   End Source Loop
!*----
                     IF ( CLMHR .AND. CLMPRO ) THEN
!                       Check for Calm Hr & Processing and
!                       Increment Counters
                        EV_NUMHRS = EV_NUMHRS + 1
                        EV_NUMCLM = EV_NUMCLM + 1
                     ELSEIF ( MSGHR .AND. MSGPRO ) THEN
!                       Check for Missing Hour & Processing and
!                       Increment Counters
                        EV_NUMHRS = EV_NUMHRS + 1
                        EV_NUMMSG = EV_NUMMSG + 1
                     ELSEIF ( ZI.LE.0 ) THEN
!                       Write Out The Informational Message &
!                       Increment Counters
                        WRITE (DUMMY,'(I8.8)') KURDAT
                        CALL ERRHDL(PATH,MODNAM,'I','470',DUMMY)
                        EV_NUMHRS = EV_NUMHRS + 1
                     ELSE
!                       Set CALCS Flag, Increment Counters
!                       & Calculate HRVAL
                        CALCS = .TRUE.
                        EV_NUMHRS = EV_NUMHRS + 1
!                       Calculate CONC or DEPOS Values      ---   CALL EVCALC
                        CALL EVCALC
                     ENDIF
 
                  ENDDO
 
!                 Calculate Applicable Averages             ---   CALL AVEREV
                  CALL AVEREV
 
!                 Print Out Model Results                   ---   CALL OUTPUT
                  CALL EV_OUTPUT
 
!                 Flush HRVAL, AVEVAL, GRPAVE and GRPVAL    ---   CALL FLUSH
                  CALL EV_FLUSH
 
!                 Reset CALCS Flag
                  CALCS = .FALSE.
 
!                 Reset the Counters
                  EV_NUMHRS = 0
                  EV_NUMCLM = 0
                  EV_NUMMSG = 0
 
               ENDIF
 
            ENDDO
!           End Event LOOP
 
         ENDIF
      ENDDO
!     End Loop Through Meteorology Data
 
      CONTINUE
      END
!*==MEREAD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MEREAD
!***********************************************************************
!                MEREAD Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Controls Extraction and Quality Assurance of
!                 One Day of Meteorological Data
!
!        PROGRAMMER: ROGER BRODE, JEFF WANG
!
!        DATE:    March 2, 1992
!
!        MODIFIED:  To remove support for unformatted meteorological
!                   data files.
!                   R.W. Brode, PES, Inc., 4/10/2000
!
!        MODIFIED:  To incorporate modifications to date processing
!                   for Y2K compliance, including use of date window
!                   variables (ISTRT_WIND and ISTRT_CENT) and calculation
!                   of 10-digit date variable (FULLDATE) with 4-digit
!                   year for date comparisons.
!                   Also modified calls to METDAT insteaad of EV_METDAT
!                   to allow use of same routine for both normal and
!                   EVENT processing.
!                   R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Meteorology File Specifications
!
!        OUTPUTS: Arrays of Meteorological Variables for One Day
!
!        CALLED FROM:   EVLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: DAY , AFVM1 , C1 , C2 , C3 , STEFB , RN , ES25
      INTEGER :: I , J , IHR , IJDAY , IDATCHK , JUYI , JUSI , JSYI ,   &
     &           JSSI , JFLAG , LEVEL , METVER
      CHARACTER(LEN=8) :: CUSI , CSSI , COSI
      CHARACTER(LEN=6) :: SPEC1 , SPEC2 , SPEC3
      CHARACTER(LEN=132) :: BUFFER
 
!     Variable Initializations
      MODNAM = 'MEREAD'
      PATH = 'MX'
 
!---- Constants used in the computation of QSW
      C1 = 5.31E-13
      C2 = 60.0
      C3 = 1.12
      STEFB = 5.67E-08
 
!     READ Meteorology Data Based on Format --
!     When DRY deposition is modeled, U-star, L, and z0 (surface
!     roughness length) are read in addition to the standard RAMMET
!     data.  These must be provided at the end of each hourly record
!     for the FORMATTED ASCII, CARD, and FREE options.
!
!     When WET deposition is modeled, ipcode (precip.
!     code) and prate (precip. rate in mm/hr) must also be added to
!     each hourly record.
!     The format statement allows for all additional data:
 
!     Calculate the MMDDHH variable to check for end of the year
      IDATCHK = KURDAT - INT(KURDAT/1000000)*1000000
      IF ( (IMONTH.EQ.12 .AND. IDAY.EQ.31 .AND. IHOUR.EQ.24) .OR.       &
     &     IDATCHK.EQ.123124 ) THEN
!        End of year has been reached - check for presence of header
!        record at beginning of next year for multi-year data files.
         READ (MFUNIT,'(A132)',ERR=998,END=1000,IOSTAT=IOERRN) BUFFER
         READ (BUFFER,1900,ERR=998,IOSTAT=IOERRN) ALAT , ALON , SPEC1 , &
     &         CUSI , SPEC2 , CSSI , SPEC3 , COSI , METVER
 1900    FORMAT (2A10,T31,A6,T38,A8,T48,A6,T55,A8,T65,A6,T72,A8,T94,I5)
!        Convert character IDs to integers
         CALL STONUM(CUSI,8,FNUM,IMIT)
         IF ( IMIT.EQ.1 ) THEN
            JUSI = NINT(FNUM)
         ELSE
            JUSI = 0
         ENDIF
         CALL STONUM(CSSI,8,FNUM,IMIT)
         IF ( IMIT.EQ.1 ) THEN
            JSSI = NINT(FNUM)
         ELSE
            JSSI = 0
         ENDIF
 
         IF ( JSSI.NE.IDSURF .OR. JUSI.NE.IDUAIR ) THEN
!           Station IDs don't match runstream input, assume that header
!           record is missing.  Backspace met file and continue processing.
            BACKSPACE MFUNIT
         ELSEIF ( INDEX(BUFFER,':').EQ.0 ) THEN
!           Station IDs match, but record does not contain colon.
!           Assume it must be regular met data record, so backspace met file.
            BACKSPACE MFUNIT
         ENDIF
 
         GOTO 1001
 
!        Error reading 'header record' - assume that header record is
!        missing.  Backspace met file and continue processing.
 998     BACKSPACE MFUNIT
 
      ENDIF
 
 1001 CONTINUE
 
      HOUR_LOOP:DO IHR = 1 , NHR
!
!---- READ surface scaling meteorology data based on format
!
         IF ( LDPART .OR. LWPART .OR. LDGAS .OR. LWGAS ) THEN
!        Read record from ASCII scalar parameter file using FREE format
!        with deposition variables
!
            READ (MFUNIT,*,END=1000,ERR=99,IOSTAT=IOERRN) IYEAR ,       &
     &            IMONTH , IDAY , IJDAY , IHOUR , ASFCHF(IHR) ,         &
     &            AUSTAR(IHR) , AWSTAR(IHR) , AVPTGZI(IHR) ,            &
     &            AZICONV(IHR) , AZIMECH(IHR) , AOBULEN(IHR) ,          &
     &            ASFCZ0(IHR) , ABOWEN(IHR) , AALBEDO(IHR) , AUREF(IHR) &
     &            , AWDREF(IHR) , AUREFHT(IHR) , ATA(IHR) , ATREFHT(IHR)&
     &            , IAPCODE(IHR) , APRATE(IHR) , ARH(IHR) , ASFCP(IHR) ,&
     &            NACLOUD(IHR)
!
!        Calculate solar irradiance, QSW, from Heat Flux, Bowen ratio,
!        albedo and cloud cover, for use in gas deposition algorithm.
            IF ( ASFCHF(IHR).LT.0.0 .OR. ATA(IHR).LT.0.0 .OR.           &
     &           AOBULEN(IHR).EQ.-99999.0 ) THEN
!           Hour is stable or missing
               AQSW(IHR) = 0.0
            ELSE
               RN = (1.+1./ABOWEN(IHR))*ASFCHF(IHR)/0.9
               AQSW(IHR) = (RN*(1.+C3)-C1*ATA(IHR)**6+STEFB*ATA(IHR)    &
     &                     **4-C2*0.1*NACLOUD(IHR))/(1.-AALBEDO(IHR))
            ENDIF
!
!        Save precipitation rates for two previous hours
            IF ( IHR.EQ.1 ) THEN
               APREC2(IHR) = APRATE(NHR-1)
               APREC1(IHR) = APRATE(NHR)
            ELSEIF ( IHR.EQ.2 ) THEN
               APREC2(IHR) = APRATE(NHR)
               APREC1(IHR) = APRATE(IHR-1)
            ELSE
               APREC2(IHR) = APRATE(IHR-2)
               APREC1(IHR) = APRATE(IHR-1)
            ENDIF
 
!        Set variables for dry deposition
            IF ( LDPART .OR. LDGAS ) THEN
               IF ( ATA(IHR).LT.0.0 .OR. APRATE(IHR).LT.0.0 ) THEN
                  AWNEW(IHR) = AWOLD(IHR)
               ELSE
! ...          Compute saturation vapor pressure based on CMAQ formula
                  AESTA(IHR) = 0.6112*EXP(19.83-5417.4/ATA(IHR))
                  ES25 = 3.167
                  AWNEW(IHR) = WOLD + APREC1(IHR) - 0.5*F2*AESTA(IHR)   &
     &                         /ES25
                  WOLD = AWNEW(IHR)
                  AF2(IHR) = AWNEW(IHR)/200.
                  IF ( AF2(IHR).LE.0.01 ) AF2(IHR) = 0.01
                  IF ( AF2(IHR).GT.1.0 ) AF2(IHR) = 1.0
                  F2 = AF2(IHR)
               ENDIF
            ENDIF
 
         ELSE
!        Read record from ASCII scalar parameter file without deposition
!        parameters, using FREE format
!
            READ (MFUNIT,*,END=1000,ERR=99,IOSTAT=IOERRN) IYEAR ,       &
     &            IMONTH , IDAY , IJDAY , IHOUR , ASFCHF(IHR) ,         &
     &            AUSTAR(IHR) , AWSTAR(IHR) , AVPTGZI(IHR) ,            &
     &            AZICONV(IHR) , AZIMECH(IHR) , AOBULEN(IHR) ,          &
     &            ASFCZ0(IHR) , ABOWEN(IHR) , AALBEDO(IHR) , AUREF(IHR) &
     &            , AWDREF(IHR) , AUREFHT(IHR) , ATA(IHR) , ATREFHT(IHR)
!
         ENDIF
 
!     Set the stability logical variables
         IF ( AOBULEN(IHR).GT.0.0 ) THEN
            UNSTAB = .FALSE.
            STABLE = .TRUE.
         ELSE
            UNSTAB = .TRUE.
            STABLE = .FALSE.
         ENDIF
 
!---- Initialize the profile data to missing;
!     READ profile data based on format
!
         CALL PFLINI()
         LEVEL = 1
         JFLAG = 0
         IF ( PROFRM.EQ.'FREE' ) THEN
!        Read record from ASCII profile file using FREE format; compute
!        sigma_V from sigma_A and wind speed
 
            DO WHILE ( JFLAG.EQ.0 )
               READ (MPUNIT,*,END=1000,ERR=98,IOSTAT=IOERRN) KYEAR ,    &
     &               KMONTH , KDAY , KHOUR , PFLHT(LEVEL) , JFLAG ,     &
     &               PFLWD(LEVEL) , PFLWS(LEVEL) , PFLTA(LEVEL) ,       &
     &               PFLSA(LEVEL) , PFLSW(LEVEL)
 
!           Convert the data to the required units
               CALL PFLCNV(LEVEL)
 
!           Set the number of profile levels to current index, store
!           the 'top of profile' flag, and increment level if not at top
!           Check that the level does not exceed the maximum allowable
               NPLVLS = LEVEL
               ANPLVLS(IHR) = LEVEL
               AIFLAG(IHR,LEVEL) = JFLAG
               APFLHT(IHR,LEVEL) = PFLHT(LEVEL)
               APFLWD(IHR,LEVEL) = PFLWD(LEVEL)
               APFLWS(IHR,LEVEL) = PFLWS(LEVEL)
               APFLTA(IHR,LEVEL) = PFLTA(LEVEL)
               APFLSA(IHR,LEVEL) = PFLSA(LEVEL)
               APFLSV(IHR,LEVEL) = PFLSV(LEVEL)
               APFLSW(IHR,LEVEL) = PFLSW(LEVEL)
               IF ( JFLAG.EQ.0 ) THEN
                  LEVEL = LEVEL + 1
 
                  IF ( LEVEL.GT.MXPLVL ) THEN
                     IF ( .NOT.PFLERR ) THEN
!                    WRITE Error Message: Number of profile levels
!                                         exceeds maximum allowable
                        WRITE (DUMMY,'(I8)') MXPLVL
                        CALL ERRHDL(PATH,MODNAM,'E','465',DUMMY)
                        PFLERR = .TRUE.
                        RUNERR = .TRUE.
                     ENDIF
 
!                 Limit the number of levels to the maximum allowable
                     LEVEL = MXPLVL
                  ENDIF
 
               ENDIF
 
            ENDDO
 
!        Compute the vertical potential temperature gradient profile
            IF ( .NOT.RUNERR ) THEN
               NTGLVL = 0
               CALL COMPTG()
               ANTGLVL(IHR) = NTGLVL
               DO I = 1 , NTGLVL
                  APFLTG(IHR,I) = PFLTG(I)
                  APFLTGZ(IHR,I) = PFLTGZ(I)
               ENDDO
            ENDIF
 
!
         ELSE
!        READ record from ASCII profile file using the default format OR
!        the format specified by the user; compute sigma_V from sigma_A
!        and wind speed
!
            DO WHILE ( JFLAG.EQ.0 )
               READ (MPUNIT,PROFRM,END=1000,ERR=98,IOSTAT=IOERRN)       &
     &               KYEAR , KMONTH , KDAY , KHOUR , PFLHT(LEVEL) ,     &
     &               JFLAG , PFLWD(LEVEL) , PFLWS(LEVEL) , PFLTA(LEVEL) &
     &               , PFLSA(LEVEL) , PFLSW(LEVEL)
 
!           Convert the data to the required units
               CALL PFLCNV(LEVEL)
 
!           Set the number of profile levels to current index, store
!           the 'top of profile' flag, and increment level if not at top
               NPLVLS = LEVEL
               ANPLVLS(IHR) = LEVEL
               AIFLAG(IHR,LEVEL) = JFLAG
               APFLHT(IHR,LEVEL) = PFLHT(LEVEL)
               APFLWD(IHR,LEVEL) = PFLWD(LEVEL)
               APFLWS(IHR,LEVEL) = PFLWS(LEVEL)
               APFLTA(IHR,LEVEL) = PFLTA(LEVEL)
               APFLSA(IHR,LEVEL) = PFLSA(LEVEL)
               APFLSV(IHR,LEVEL) = PFLSV(LEVEL)
               APFLSW(IHR,LEVEL) = PFLSW(LEVEL)
               IF ( JFLAG.EQ.0 ) THEN
                  LEVEL = LEVEL + 1
 
                  IF ( LEVEL.GT.MXPLVL ) THEN
                     IF ( .NOT.PFLERR ) THEN
!                    WRITE Error Message: Number of profile levels
!                                         exceeds maximum allowable
                        WRITE (DUMMY,'(I8)') MXPLVL
                        CALL ERRHDL(PATH,MODNAM,'E','465',DUMMY)
                        PFLERR = .TRUE.
                        RUNERR = .TRUE.
                     ENDIF
 
!                 Limit the number of levels to the maximum allowable
                     LEVEL = MXPLVL
                  ENDIF
 
               ENDIF
 
            ENDDO
 
!        Compute the vertical potential temperature gradient profile
            IF ( .NOT.RUNERR ) THEN
               NTGLVL = 0
               CALL COMPTG()
               ANTGLVL(IHR) = NTGLVL
               DO I = 1 , NTGLVL
                  APFLTG(IHR,I) = PFLTG(I)
                  APFLTGZ(IHR,I) = PFLTGZ(I)
               ENDDO
            ENDIF
 
 
         ENDIF
 
      ENDDO HOUR_LOOP
 
!     Set the date variables
      CALL SET_DATES
 
      GOTO 999
 
!     WRITE Error Messages:  Error Reading Met Data File
 
 98   CALL ERRHDL(PATH,MODNAM,'E','510','PROFFILE')
      RUNERR = .TRUE.
      GOTO 999
 
 99   CALL ERRHDL(PATH,MODNAM,'E','510','SURFFILE')
      RUNERR = .TRUE.
      GOTO 999
 
 1000 EOF = .TRUE.
!     Set the date variables
      CALL SET_DATES
 
 999  CONTINUE
      END
!*==EV_METEXT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_METEXT
!***********************************************************************
!                EV_METEXT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Controls Extraction and Quality Assurance of
!                 One Hour of Meteorological Data
!
!        PROGRAMMER: ROGER BRODE, JEFF WANG
!        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION)
!
!        DATE:    November 8, 1993
!
!        MODIFIED:   To remove unused data array (NDAY).
!                    R.W. Brode, PES, Inc., 4/10/2000
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT) and calculation
!                    of 10-digit date variable (FULLDATE) with 4-digit
!                    year for date comparisons.
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        MODIFIED:   To add determination of season index (ISEAS).
!                    R.W. Brode, PES, Inc. - 12/2/98
!
!        MODIFIED BY D. Strimaitis, SRC (for Dry DEPOSITION)
!        (DATE:    February 15, 1993)
!
!        MODIFIED:   To avoid potential math error due to negative
!                    ambient temperatures in calculating the square
!                    root of the stability parameter, RTOFS - 4/19/93
!
!        MODIFIED:
!        7/27/94     J. Paumier, PES, Inc.
!                    The variables for displacement height, ZDM and
!                    AZDM(), were removed from the input to and output
!                    from ISC-COMPDEP.  The following format statements
!                    also were affected: 9009, 9026, 9032, 9033
!
!*       7/27/94     J. Hardikar, PES, Inc.
!*                   Added code to calculate reference wind speed at 10m
!*                   to be used for OPENPIT source algorithms
!
!        INPUTS:  Meteorology File Specifications
!
!        OUTPUTS: Meteorological Variables for One Hour
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER I
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EV_METEXT'
      PATH = 'MX'
 
!     Save Value of Last YR/MN/DY/HR and Previous Hour
      IPDATE = KURDAT
      IPHOUR = IHOUR
 
!     Set Meteorological Variables for This Hour
      SFCHF = ASFCHF(IHOUR)
      UREF = AUREF(IHOUR)
      UREFHT = AUREFHT(IHOUR)
      TA = ATA(IHOUR)
      TREFHT = ATREFHT(IHOUR)
      WDREF = AWDREF(IHOUR)
      USTAR = AUSTAR(IHOUR)
      WSTAR = AWSTAR(IHOUR)
      ZICONV = AZICONV(IHOUR)
      ZIMECH = AZIMECH(IHOUR)
      OBULEN = AOBULEN(IHOUR)
      VPTGZI = AVPTGZI(IHOUR)
      SFCZ0 = ASFCZ0(IHOUR)
      BOWEN = ABOWEN(IHOUR)
      ALBEDO = AALBEDO(IHOUR)
      IPCODE = IAPCODE(IHOUR)
      PRATE = APRATE(IHOUR)
      RH = ARH(IHOUR)
      SFCP = ASFCP(IHOUR)
      NCLOUD = NACLOUD(IHOUR)
      QSW = AQSW(IHOUR)
      WNEW = AWNEW(IHOUR)
      F2 = AF2(IHOUR)
      ESTA = AESTA(IHOUR)
      PREC1 = APREC1(IHOUR)
      PREC2 = APREC2(IHOUR)
 
      NPLVLS = ANPLVLS(IHOUR)
      DO I = 1 , NPLVLS
 
         IFLAG(I) = AIFLAG(IHOUR,I)
         PFLHT(I) = APFLHT(IHOUR,I)
         PFLWD(I) = APFLWD(IHOUR,I)
         PFLWS(I) = APFLWS(IHOUR,I)
         PFLTA(I) = APFLTA(IHOUR,I)
         PFLSA(I) = APFLSA(IHOUR,I)
         PFLSV(I) = APFLSV(IHOUR,I)
         PFLSW(I) = APFLSW(IHOUR,I)
 
      ENDDO
 
      NTGLVL = ANTGLVL(IHOUR)
      DO I = 1 , NTGLVL
 
         PFLTG(I) = APFLTG(IHOUR,I)
         PFLTGZ(I) = APFLTGZ(IHOUR,I)
 
      ENDDO
 
!     Set Meteorological Variables for Current Hour
      CALL SET_METDATA
 
      CONTINUE
      END
!*==EV_CHKDAT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_CHKDAT(IHR)
!***********************************************************************
!                 EV_CHKDAT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Checks Meteorological Data for Record Out of Sequence
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Date Variable
!
!        OUTPUTS: Date Error Messages
!
!        CALLED FROM:   METCHK
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IHR , IPYR , IPMN , IPDY
 
!     Variable Initializations
      MODNAM = 'EV_CHKDAT'
 
!     Check for Record Out of Sequence
      IF ( IHR.EQ.1 ) THEN
         IPYR = IYEAR
         IPMN = IMONTH
         IPDY = IDAY
      ENDIF
      IF ( IYEAR.NE.IPYR .OR. IMONTH.NE.IPMN .OR. IDAY.NE.IPDY .OR.     &
     &     IHOUR.NE.IHR ) THEN
!        WRITE Error Message - Record Out of Sequence
         WRITE (DUMMY,'(4I2.2)') IYEAR , IMONTH , IDAY , IHOUR
         CALL ERRHDL(PATH,MODNAM,'E','450',DUMMY)
         RUNERR = .TRUE.
      ENDIF
 
      CONTINUE
      END
!*==HQREAD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE HQREAD
!***********************************************************************
!*                  HQREAD Module of ISCEV3
!*
!*         PURPOSE: To Read a 24-hour Block of Hourly Emissions Data
!*
!*         PROGRAMMER:  Jayant Hardikar, Roger Brode
!*
!*         DATE:    September 15, 1993
!*
!*         INPUTS:  Variable QFLAG and Current Source Number Being Processed
!*
!*         OUTPUTS: Source Arrays
!*
!*         MODIFIED:  REMOVED THE 'POINT' SOURCE CONDITION, SO IT APPLIES
!*                    TO ALL SOURCE TYPES, EXCEPT SAVING THE TEMP & VEL
!*
!*         CALLED FROM:  HRLOOP
!************************************************************************
!*
!*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IS , IHR , IHYEAR , IHMON , IHDAY , IHHOUR
      CHARACTER RDFRM*20
 
      CHARACTER*8 HRSOID
 
!*    Variable Initializations
      MODNAM = 'HQREAD'
 
      DO IHR = 1 , 24
         DO IS = 1 , NUMSRC
            IF ( QFLAG(IS).EQ.'HOURLY' ) THEN
!*
!*             READ Record to Buffers, A80 and 80A1
!*             Length of ISTRG is Set in PARAMETER Statement in MAIN1
!              Setup READ format and ECHO format for runstream record,
!              based on the ISTRG PARAMETER (set in MAIN1)
               WRITE (RDFRM,9100) ISTRG , ISTRG
 9100          FORMAT ('(A',I3.3,',T1,',I3.3,'A1)')
               READ (IHREMI,RDFRM,ERR=99,END=999) RUNST1 ,              &
     &               (RUNST(I),I=1,ISTRG)
!*
!*             Convert Lower Case to Upper Case Letters              ---   CALL LWRUPR
               CALL LWRUPR
!*
!*             Define Fields on Card                                 ---   CALL DEFINE
               CALL DEFINE
!*
!*             Get the Contents of the Fields                        ---   CALL GETFLD
               CALL GETFLD
!*
!*             Check for number of fields - error if less than 7.
               IF ( IFC.LT.7 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','201','HOUREMIS')
                  RUNERR = .TRUE.
                  GOTO 999
               ENDIF
!*
!*             Assign the Feilds to Local Varables and Check The Numerical Field
!*
               CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
               IHYEAR = NINT(FNUM)
               IF ( IMIT.NE.1 )                                         &
     &              CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
               CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
               IHMON = NINT(FNUM)
               IF ( IMIT.NE.1 )                                         &
     &              CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
               CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
               IHDAY = NINT(FNUM)
               IF ( IMIT.NE.1 )                                         &
     &              CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
               CALL STONUM(FIELD(6),ILEN_FLD,FNUM,IMIT)
               IHHOUR = NINT(FNUM)
               IF ( IMIT.NE.1 )                                         &
     &              CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
               HRSOID = FIELD(7)
 
               IF ( IFC.GE.8 ) THEN
                  CALL STONUM(FIELD(8),ILEN_FLD,EV_HRQS(IS,IHR),IMIT)
                  IF ( IMIT.NE.1 )                                      &
     &                 CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
               ELSE
!*                Emission rate is missing - set to zero
                  EV_HRQS(IS,IHR) = 0.0
               ENDIF
 
               IF ( IFC.EQ.10 ) THEN
!*                Also Assign Exit Temperature and Exit Velocity
                  CALL STONUM(FIELD(9),ILEN_FLD,EV_HRTS(IS,IHR),IMIT)
                  IF ( IMIT.NE.1 )                                      &
     &                 CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
 
                  CALL STONUM(FIELD(10),ILEN_FLD,EV_HRVS(IS,IHR),IMIT)
                  IF ( IMIT.NE.1 )                                      &
     &                 CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
               ELSE
!*                Some missing parameters - assign zeros to all
                  EV_HRTS(IS,IHR) = 0.0
                  EV_HRVS(IS,IHR) = 0.0
               ENDIF
 
!*             Check for Source ID Consistency ; If Failed - Abort Program
               IF ( HRSOID.NE.SRCID(IS) ) THEN
                  WRITE (DUMMY,'(A8)') SRCID(IS)
                  CALL ERRHDL(PATH,MODNAM,'E','342',SRCID(IS))
                  RUNERR = .TRUE.
               ENDIF
 
            ENDIF
         ENDDO
      ENDDO
 
!*    Check for Date and Time Consistency ; If Failed - Abort Program
      KURHRQ = IHYEAR*1000000 + IHMON*10000 + IHDAY*100 + IHHOUR
      IF ( KURDAT.NE.KURHRQ ) THEN
!*       WRITE Error Message - Date mismatch
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'E','455',DUMMY)
         RUNERR = .TRUE.
      ENDIF
 
      GOTO 999
 
!*    Write Error Message for Error Reading Hourly Emissions File
 99   CALL ERRHDL(PATH,MODNAM,'E','510','HOUREMIS')
      RUNERR = .TRUE.
 
 999  CONTINUE
      END
!*==EV_HRQEXT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE EV_HRQEXT(IS)
!***********************************************************************
!*                  EV_HRQEXT Module of AERMOD
!*
!*         PURPOSE: To Assign Hourly Source Parameters
!*
!*         PROGRAMMER:  Jayant Hardikar, Roger Brode
!*
!*         DATE:    September 15, 1993
!*
!*         INPUTS:  Variable QFLAG and Current Source Number Being Processed
!*
!*         OUTPUTS: Source Arrays
!*
!*         MODIFIED:  REMOVED THE 'POINT' SOURCE CONDITION, SO IT APPLIES
!*                    TO ALL SOURCE TYPES, EXCEPT SAVING THE TEMP & VEL
!*
!*         CALLED FROM:  HRLOOP
!************************************************************************
!*
!*    Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: IS
 
!*    Variable Initializations
      MODNAM = 'EV_HRQEXT'
!*
 
!*    Assign the Hourly Emission Parameters to the Stack Variables
      AQS(IS) = EV_HRQS(IS,IHOUR)
 
      IF ( SRCTYP(IS).EQ.'POINT' ) THEN
         ATS(IS) = EV_HRTS(IS,IHOUR)
         AVS(IS) = EV_HRVS(IS,IHOUR)
      ENDIF
 
 
!*    Perform QA Error Checking on Source Parameters
!*
 
      IF ( ATS(IS).EQ.0.0 ) THEN
!*       Set Temperature to Small Negative Value for Ambient Releases
         ATS(IS) = -1.0E-5
      ELSEIF ( ATS(IS).GT.2000.0 ) THEN
!*       WRITE Informational Message:  Exit Temp. > 2000K
         CALL ERRHDL(PATH,MODNAM,'I','320','HRTS')
      ENDIF
 
      IF ( SRCTYP(IS).EQ.'POINT' ) THEN
         IF ( AVS(IS).LT.0.0 ) THEN
!*          WRITE Informational Message:  Negative or Zero Exit Velocity
            CALL ERRHDL(PATH,MODNAM,'I','325','HRVS')
!*          Set to Small Value to Avoid Zero-divide and Underflow
            AVS(IS) = 1.0E-5
         ELSEIF ( AVS(IS).LT.1.0E-5 ) THEN
!*          Set to Small Value to Avoid Zero-divide and Underflow
            AVS(IS) = 1.0E-5
         ELSEIF ( AVS(IS).GT.50.0 ) THEN
!*          WRITE Informational Message:  Exit Velocity > 50.0 m/s
            CALL ERRHDL(PATH,MODNAM,'I','320','HRVS')
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==EVCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE EVCALC
!***********************************************************************
!                 EVCALC Module of ISC2 Short Term EVENT Model - ISCEV2
!
!        PURPOSE: Controls Flow and Processing of CALCulation Modules
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To set NUMREC = 1 and use PCALC, VCALC, ACALC, and
!                    OCALC subroutines.  R.W. Brode, PES, Inc. - 12/2/98
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Receptor Locations
!                 Meteorological Variables for One Hour
!
!        OUTPUTS: Array of 1-hr CONC or DEPOS Values for Each Source/Receptor
!
!        CALLED FROM:   EVLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EVCALC'
      PATH = 'CN'
 
!     Set NUMREC = 1 to allow use of PCALC, VCALC, ACALC, and OCALC subroutines
      NUMREC = 1
 
!     Begin Source LOOP
      SOURCE_LOOP:DO ISRC = 1 , NUMSRC
         IF ( IGROUP(ISRC,IDXEV(IEVENT)).EQ.1 ) THEN
            IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
!              Calculate Point Source Values                ---   CALL PCALC
               CALL PCALC
            ELSEIF ( SRCTYP(ISRC).EQ.'VOLUME' ) THEN
!              Calculate Volume Source Values               ---   CALL VCALC
               CALL VCALC
            ELSEIF ( SRCTYP(ISRC).EQ.'AREA' ) THEN
!              Calculate Area Source Values for Rectangles  ---   CALL ACALC
               CALL ACALC
            ELSEIF ( SRCTYP(ISRC).EQ.'AREAPOLY' ) THEN
!              Calculate Area Source Values for Polygons    ---   CALL ACALC
               CALL ACALC
            ELSEIF ( SRCTYP(ISRC).EQ.'AREACIRC' ) THEN
!              Calculate Area Source Values for Circles     ---   CALL ACALC
               CALL ACALC
            ELSEIF ( SRCTYP(ISRC).EQ.'OPENPIT' ) THEN
!              Calculate OpenPit Source Values              ---   CALL OCALC
               CALL OCALC
            ENDIF
         ENDIF
      ENDDO SOURCE_LOOP
!     End Source LOOP
 
      CONTINUE
      END
!*==EV_SUMVAL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_SUMVAL
!***********************************************************************
!                 EV_SUMVAL Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Sums HRVAL to AVEVAL and ANNVAL Arrays
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  HRVAL - Hourly Value for (IHOUR,ISRC) Combination
!                 Averaging Period Options
!                 Source Groupings
!
!        OUTPUTS: Updated Sums of AVEVAL and ANNVAL Arrays
!
!        CALLED FROM:   PCALC
!                       VCALC
!                       ACALC
!                       OCALC
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EV_SUMVAL'
 
      HRVALS(IHOUR,ISRC) = HRVAL(1)
      EV_AVEVAL(ISRC) = EV_AVEVAL(ISRC) + HRVAL(1)
      GRPVAL(IHOUR) = GRPVAL(IHOUR) + HRVAL(1)
 
      CONTINUE
      END
!*==STODBL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE STODBL(STRVAR,LEN,FNUM,IMUTI)
!***********************************************************************
!                 Subroutine STODBL
!
!        PURPOSE: Gets Double Precision of Real Number
!                 From A Stream Variable
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To Change Exponent Limit for Out-of-range
!                    Inputs - 9/29/92
!
!        INPUTS:  Input String Variable
!                 Length of Character String
!
!        OUTPUTS: Double Precision Real Numbers
!
!        CALLED FROM: (This Is A Utility Program)
!***********************************************************************
!
!     Variable Declarations
      IMPLICIT NONE
 
      INTEGER :: IMUTI , LEN , I
      REAL :: FDEC , FDC1 , HEAD
      CHARACTER STRVAR*(*) , CHK , MODNAM*6 , NUMS*10
      DOUBLE PRECISION FNUM , CNUM
      LOGICAL MEND , IN , NMARK , PMARK , DMARK , MMARK , EMARK
 
!     Variable Initialization
      MODNAM = 'STODBL'
      NUMS = '0123456789'
      I = 1
      MEND = .FALSE.
      IN = .FALSE.
      NMARK = .FALSE.
      PMARK = .FALSE.
      DMARK = .FALSE.
      MMARK = .FALSE.
      EMARK = .FALSE.
      CNUM = 0.0
      IMUTI = 1
      FDEC = 1.
 
!     Beginning the Processing
      DO WHILE ( .NOT.MEND .AND. I.LE.LEN )
         CHK = STRVAR(I:I)
         IF ( CHK.NE.' ' ) THEN
            IN = .TRUE.
            IF ( CHK.GE.'0' .AND. CHK.LE.'9' ) THEN
!              CHK is a Number, Assign a Value
               IF ( .NOT.DMARK ) THEN
                  CNUM = CNUM*10. + FLOAT(INDEX(NUMS,CHK)-1)
               ELSE
                  FDEC = FDEC/10.
                  FDC1 = FDEC*FLOAT(INDEX(NUMS,CHK)-1)
                  CNUM = CNUM + FDC1
               ENDIF
            ELSE
!              Handle The E-Type Real Number
               IF ( .NOT.EMARK .AND. CHK.EQ.'E' ) THEN
                  EMARK = .TRUE.
                  IF ( .NOT.NMARK ) THEN
                     HEAD = CNUM
                  ELSE
                     HEAD = -CNUM
                  ENDIF
                  DMARK = .FALSE.
                  NMARK = .FALSE.
                  CNUM = 0.0
               ELSEIF ( .NOT.PMARK .AND. CHK.EQ.'+' ) THEN
!                 Set Positive Indicator
                  PMARK = .TRUE.
               ELSEIF ( .NOT.NMARK .AND. CHK.EQ.'-' ) THEN
!                 Set Negative Indicator
                  NMARK = .TRUE.
               ELSEIF ( .NOT.DMARK .AND. CHK.EQ.'.' ) THEN
!                 Set Decimal Indicator
                  DMARK = .TRUE.
               ELSEIF ( .NOT.MMARK .AND. CHK.EQ.'*' .AND. .NOT.NMARK )  &
     &                  THEN
!                 Set Repeat Indicator
                  MMARK = .TRUE.
                  IMUTI = NINT(CNUM)
                  CNUM = 0.0
               ELSE
!                 Error Occurs, Set Switch and Exit Out Of The Subroutine
                  GOTO 9999
               ENDIF
            ENDIF
         ELSEIF ( IN .AND. CHK.EQ.' ' ) THEN
            MEND = .TRUE.
         ENDIF
         I = I + 1
      ENDDO
 
      FNUM = CNUM
 
!     In Case Of Negative Field, Value set to Negative
      IF ( NMARK ) FNUM = -FNUM
 
!     In Case of *E* Format, Check for Exponents Out of Range
      IF ( EMARK .AND. ABS(FNUM).LE.30. ) THEN
         FNUM = HEAD*10**(FNUM)
      ELSEIF ( EMARK .AND. ABS(FNUM).GT.30. ) THEN
         IF ( FNUM.LT.0.0 ) THEN
            FNUM = 0.0
         ELSEIF ( FNUM.GT.0.0 ) THEN
            FNUM = HEAD*10**30.
         ENDIF
         GOTO 9999
      ENDIF
 
      GOTO 1000
 
!     Set Error Switch for Illegal Numerical Field (WRITE Message and Handle
!     Error in Calling Routine)
 9999 IMUTI = -1
 
 1000 CONTINUE
      END
!*==AVEREV.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE AVEREV
!***********************************************************************
!                 AVEREV Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Sums Values and Calculates Averages
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Averaging Time Option Switches
!                 Array of CONC or DEPOS Values for One Hour, HRVALS
!
!        OUTPUTS: Updated Array of Cumulative Values and Averages, AVEVAL
!
!        CALLED FROM:   EVLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: SNUM
 
!     Variable Initializations
      MODNAM = 'AVEREV'
 
!     Calculate Average CONCentrations If Hour is Right
      IF ( CONC ) THEN
         IF ( EVAPER(IEVENT).NE.1 ) THEN
!           Calculate Denominator Considering Calms and Missing,
!           Skipping Averaging if Averaging Period is 1-Hour
            SNUM = AMAX0((EV_NUMHRS-EV_NUMCLM-EV_NUMMSG),               &
     &             NINT(EV_NUMHRS*0.75+0.4))
!           Begin Source Group LOOP
            DO ISRC = 1 , NUMSRC
               IF ( IGROUP(ISRC,IDXEV(IEVENT)).EQ.1 ) EV_AVEVAL(ISRC)   &
     &              = (1./SNUM)*EV_AVEVAL(ISRC)
            ENDDO
!           End Source Group LOOP
         ENDIF
      ENDIF
 
!     Calculate The Group Value
      GRPAVE = 0.
!     Begin Source Group LOOP
      DO ISRC = 1 , NUMSRC
         IF ( IGROUP(ISRC,IDXEV(IEVENT)).EQ.1 ) GRPAVE = GRPAVE +       &
     &        EV_AVEVAL(ISRC)
      ENDDO
!     End Source Group LOOP
 
      CONTINUE
      END
!*==EV_OUTPUT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_OUTPUT
!***********************************************************************
!                 EV_OUTPUT Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Controls Output of Printed Model Results
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Receptor Locations
!                 Arrays of Model Results
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'EV_OUTPUT'
 
      IF ( SOCONT ) THEN
!        Print Out Source Contribution To the Event         ---   CALL PRTSOC
         CALL PRTSOC
      ELSEIF ( DETAIL ) THEN
!        Print Out Detal Summary of The Event               ---   CALL PRTDET
         CALL PRTDET
      ENDIF
 
      CONTINUE
      END
!*==PRTSOC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRTSOC
!***********************************************************************
!                 PRTSOC Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Print Out The Source Contribution Data
!                 To The Event
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To correct overflow on format statement 9068, and
!                    to use separate array for source IDs in the header
!                    (HEADID) - 9/29/92
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Model Results
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   OUTPUT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , N , NROW , NPAGE , INGRP , IOGRP
      REAL :: WAVEV(NSRC)
      CHARACTER*8 HEADID(NSRC)
 
!     Variable Initializations
      MODNAM = 'PRTSOC'
 
!     Set Up The Print Array
      INGRP = 0
      DO ISRC = 1 , NUMSRC
         IF ( IGROUP(ISRC,IDXEV(IEVENT)).EQ.1 ) THEN
            INGRP = INGRP + 1
            WORKID(INGRP) = SRCID(ISRC)
            HEADID(INGRP) = SRCID(ISRC)
            WAVEV(INGRP) = EV_AVEVAL(ISRC)
         ENDIF
      ENDDO
!     Check for More Than 34 Sources Per Group
      IF ( INGRP.GT.34 ) THEN
         HEADID(34) = ' . . . '
         IOGRP = 34
      ELSE
         IOGRP = INGRP
      ENDIF
 
!     Determine Number of Rows, NROW, @ 3 Values Per Row
      NROW = 1 + INT((INGRP-1)/3)
!     Determine Number of Pages, NPAGE, @ 40 Rows Per Page
      NPAGE = 1 + INT((NROW-1)/40)
 
!     Loop Through Pages For This Event
      DO N = 1 , NPAGE
 
!        Print The Source Contributions
         CALL HEADER
         WRITE (IOUNIT,9058) EVNAME(IEVENT) , EVAPER(IEVENT) ,          &
     &                       EVDATE(IEVENT) , AXR(IEVENT) , AYR(IEVENT) &
     &                       , AZELEV(IEVENT) , AZFLAG(IEVENT)
 
 9058    FORMAT (43X,'*** SOURCE CONTRIBUTIONS FOR EVENT: ',A8,         &
     &           ' ***'//1X,'---> AVE. PER.: ',I3,' HRS;',              &
     &           '  END DATE:  ',I8.8,                                  &
     &           ';  LOCATION (XR,YR,ZELEV,ZFLAG):',4F11.2,' (M)'/)
 
         WRITE (IOUNIT,9068) EVGRP(IEVENT) , (HEADID(I),I=1,IOGRP)
 9068    FORMAT (1X,'GROUP ID: ',A8,1X,'OF SOURCES: ',10(A8,', ')/12x,  &
     &           12(A8,', ')/12x,12(A8,', '))
         WRITE (IOUNIT,9070) GRPAVE
 9070    FORMAT (/3X,'*** GROUP VALUE = ',F14.5,' ***'/)
         WRITE (IOUNIT,9062)
 9062    FORMAT (3(' SOURCE ID     CONTRIBUTION ',8X)                   &
     &           /3(' ---------     ------------ ',8X))
 
!        Print Out The Source Contributions
         IF ( N.EQ.NPAGE ) THEN
            WRITE (IOUNIT,9066) (WORKID(I),WAVEV(I),I=1+120*(N-1),INGRP)
         ELSE
            WRITE (IOUNIT,9066) (WORKID(I),WAVEV(I),I=1+120*(N-1),120*N)
         ENDIF
 
      ENDDO
 
      CONTINUE
 9066 FORMAT (3(2X,A8,4X,F13.5,9X:))
      END
!*==PRTDET.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRTDET
!***********************************************************************
!                 PRTDET Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Print Out The Source Contribution Data
!                 To The Event
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Model Results
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   OUTPUT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , N , NSPP , NPAGE , IHR , INGRP
      REAL :: WAVEV(NSRC) , WHRVAL(24,NSRC)
 
!     Variable Initializations
      MODNAM = 'PRTDET'
 
!     Set Up The Printing Work Array
      INGRP = 0
      DO ISRC = 1 , NUMSRC
         IF ( IGROUP(ISRC,IDXEV(IEVENT)).EQ.1 ) THEN
            INGRP = INGRP + 1
            WORKID(INGRP) = SRCID(ISRC)
            WAVEV(INGRP) = EV_AVEVAL(ISRC)
            DO IHR = ISTAHR , IENDHR
               WHRVAL(IHR,INGRP) = HRVALS(IHR,ISRC)
            ENDDO
         ENDIF
      ENDDO
 
!     Set Number of Sources Per Page, NSPP
      NSPP = 8
!     Calculate Number of Pages for This Event (NSPP Sources per Page)
      NPAGE = 1 + INT((INGRP-1)/NSPP)
      DO N = 1 , NPAGE
         CALL HEADER
         WRITE (IOUNIT,9058) EVNAME(IEVENT) , EVAPER(IEVENT) ,          &
     &                       EVDATE(IEVENT) , AXR(IEVENT) , AYR(IEVENT) &
     &                       , AZELEV(IEVENT) , AZFLAG(IEVENT)
 
 9058    FORMAT (43X,'*** SOURCE CONTRIBUTIONS FOR EVENT: ',A8,         &
     &           ' ***'/1X,'---> AVE. PER.: ',I3,' HRS;',               &
     &           '  END DATE:  ',I8.8,                                  &
     &           ';  LOCATION (XR,YR,ZELEV,ZFLAG):',4F11.2,' (M)')
 
         IF ( N.EQ.NPAGE ) THEN
!           Print Out The Values for the Last Page
            WRITE (IOUNIT,9068) EVGRP(IEVENT) ,                         &
     &                          (WORKID(I),I=1+NSPP*(N-1),INGRP)
            WRITE (IOUNIT,9066)
 
!           Print Out The Source Contributions for the Last Page
            DO I = ISTAHR , IENDHR
               WRITE (IOUNIT,9062) I , GRPVAL(I) ,                      &
     &                             (WHRVAL(I,J),J=1+NSPP*(N-1),INGRP)
            ENDDO
            WRITE (IOUNIT,9064) GRPAVE , (WAVEV(I),I=1+NSPP*(N-1),INGRP)
         ELSE
!           Print Out The Values for the Current Page
            WRITE (IOUNIT,9068) EVGRP(IEVENT) ,                         &
     &                          (WORKID(I),I=1+NSPP*(N-1),NSPP*N)
            WRITE (IOUNIT,9066)
 
!           Print Out The Source Contributions for the Current Page
            DO I = ISTAHR , IENDHR
               WRITE (IOUNIT,9062) I , GRPVAL(I) ,                      &
     &                             (WHRVAL(I,J),J=1+NSPP*(N-1),NSPP*N)
            ENDDO
            WRITE (IOUNIT,9064) GRPAVE ,                                &
     &                          (WAVEV(I),I=1+NSPP*(N-1),NSPP*N)
         ENDIF
 
         IF ( N.EQ.1 ) THEN
!           Write Out the Meteorology Data
            NEWMET = .TRUE.
            DO IHOUR = ISTAHR , IENDHR
               UREF = AUREF(IHOUR)
               UREFHT = AUREFHT(IHOUR)
               TA = ATA(IHOUR)
               TREFHT = ATREFHT(IHOUR)
               WDREF = AWDREF(IHOUR)
               SFCHF = ASFCHF(IHOUR)
               USTAR = AUSTAR(IHOUR)
               WSTAR = AWSTAR(IHOUR)
               ZICONV = AZICONV(IHOUR)
               ZIMECH = AZIMECH(IHOUR)
               OBULEN = AOBULEN(IHOUR)
               VPTGZI = AVPTGZI(IHOUR)
               SFCZ0 = ASFCZ0(IHOUR)
               BOWEN = ABOWEN(IHOUR)
               ALBEDO = AALBEDO(IHOUR)
!              Write Out The Meteorology Data
               CALL METDET
            ENDDO
         ENDIF
      ENDDO
 
      CONTINUE
 9068 FORMAT (1X,'HOUR GROUP:',A8,' OF',3X,A8,7(6X,A8:))
 9066 FORMAT (65('- '))
 9062 FORMAT (1X,I3,2X,9(1X,F13.5:))
 9064 FORMAT (65('- ')/1X,'AVER:',9(1X,F13.5:))
      END
!*==METDET.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE METDET
!***********************************************************************
!                 METDET Module of the AMS/EPA Regulatory Model - AERMOD - EVENT
!
!        PURPOSE: Print Out The Details Of The Meteorology Data
!
!        PROGRAMMER: Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Meteorology Input Data
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   PRTDET
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'METDET'
 
!     Meteorology Data Summary
      IF ( NEWMET ) THEN
         NEWMET = .FALSE.
         WRITE (IOUNIT,9025)
 
 
 9025    FORMAT (' MET DATA --> YR MO DY HR','     H0','     U*',       &
     &           '     W*','  DT/DZ',' ZICNV',' ZIMCH','  M-O LEN',     &
     &           '    Z0','  BOWEN',' ALBEDO','  REF WS','   WD',       &
     &           '     HT','  REF TA','     HT')
      ENDIF
      WRITE (IOUNIT,9026) IYEAR , IMONTH , IDAY , IHOUR , SFCHF ,       &
     &                    USTAR , WSTAR , VPTGZI , ZICONV , ZIMECH ,    &
     &                    OBULEN , SFCZ0 , BOWEN , ALBEDO , UREF ,      &
     &                    WDREF , UREFHT , TA , TREFHT
 9026 FORMAT (14X,4(I2.2,1X),F6.1,1X,3(F6.3,1X),2(F5.0,1X),F8.1,1X,F5.2,&
     &        1X,2(F6.2,1X),F7.2,1X,F5.0,3(1X,F6.1))
 
      CONTINUE
      END
!*==EV_FLUSH.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EV_FLUSH
!***********************************************************************
!                 Module EV_FLUSH of ISC2 Model - EVENT
!
!        PURPOSE: To Flush AVEVAL and HRVALS Array
!
!        PROGRAMMER: Todd Hawes, Roger Brode and Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  AVEVAL, HRVALS
!
!        OUTPUTS: Flushed AVEVAL and HRVALS
!
!        CALLED FROM:  MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I
 
!     Variable Initializations
      MODNAM = 'EV_FLUSH'
 
!     Flush the Hourly Value
      DO I = 1 , NUMTYP
         HRVAL(I) = 0.0
      ENDDO
 
!     Flush the Group Values
      GRPAVE = 0.0
      DO IHOUR = 1 , NHR
         GRPVAL(IHOUR) = 0.0
      ENDDO
 
!     Flush the Block Average Calculations
      DO ISRC = 1 , NUMSRC
         EV_AVEVAL(ISRC) = 0.0
         DO IHOUR = 1 , NHR
            HRVALS(IHOUR,ISRC) = 0.0
         ENDDO
      ENDDO
 
      CONTINUE
      END
!*==EVCARD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE EVCARD
!***********************************************************************
!                 EVCARD Module of ISCEV2 Model
!
!        PURPOSE: To process EVent Pathway card images
!
!        PROGRAMMER:  Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT) and calculation
!                    of 10-digit variables for start date (ISDATE) and
!                    end date (IEDATE).
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        MODIFIED:   To remove reassignment of ISYEAR.
!                    R.W. Brode, PES, 4/2/99
!
!        MODIFIED:   To remove mixed-mode math in calculation of
!                    ISDATE and IEDATE - 4/19/93
!
!        INPUTS:  Pathway (EV) and Keyword
!
!        OUTPUTS: Pass Two Event Setup
!
!        CALLED FROM:   SETUP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , ILSAVE , ITEMPDATE , ITEMPYEAR
 
!     Variable Initializations
      MODNAM = 'EVCARD'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Set Status Switch
         IESTAT(1) = IESTAT(1) + 1
         IEVENT = 1
!           Error Message: Repeat Starting In Same Pathway
         IF ( IESTAT(1).NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
      ELSEIF ( KEYWRD.EQ.'EVENTPER' ) THEN
!        Set Status Switch
         IESTAT(2) = IESTAT(2) + 1
!        Check for First Occurrence of EVENTPER Card, and
!        Reinitialize IPROC Array
         IF ( IESTAT(2).EQ.1 ) THEN
            DO I = 1 , 366
               IPROC(I) = 0
            ENDDO
         ENDIF
!        Process Average Period, Date and Source Group      ---   CALL EVPER
         CALL EVPER
      ELSEIF ( KEYWRD.EQ.'EVENTLOC' ) THEN
!        Set Status Switch
         IESTAT(3) = IESTAT(3) + 1
!        Process Discrete Receptor Location                 ---   CALL EVLOC
         CALL EVLOC
      ELSEIF ( KEYWRD.EQ.'INCLUDED' ) THEN
!        Set Status Switch
         IESTAT(10) = IESTAT(10) + 1
!        Save ILINE as ISAVE
         ILSAVE = ILINE
!        Process the Included Receptor File                 ---   CALL INCLUD
         CALL INCLUD
!        Retrieve ILINE From ISAVE
         ILINE = ILSAVE
      ELSEIF ( KEYWRD.EQ.'FINISHED' ) THEN
!        Check for missing EVENTLOC cards
!           Write Error Message:  Missing EVENTLOC
         IF ( IESTAT(2).GT.IESTAT(3) )                                  &
     &        CALL ERRHDL(PATH,MODNAM,'E','130','EVENTLOC')
         NUMEVE = IEVENT - 1
!        Set Status Switch
         IESTAT(25) = IESTAT(25) + 1
         IF ( IESTAT(25).NE.1 ) THEN
!           Error Message: Repeat Finished In Same Pathway
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
            GOTO 999
         ENDIF
 
!        Get start date, ISDATE, and end date, IEDATE
         ISDATE = EVDATE(1)
         IEDATE = EVDATE(1)
         ISYR = ISDATE/1000000
         IEYR = IEDATE/1000000
!        Convert 8-digit EVDATE to 10-digit ISDATE and IEDATE
         IF ( ISYR.GE.ISTRT_WIND .AND. ISYR.LE.99 ) THEN
            ISYR = ISTRT_CENT*100 + ISYR
            ISDATE = ISTRT_CENT*100000000 + ISDATE
         ELSEIF ( ISYR.LT.ISTRT_WIND ) THEN
            ISYR = (ISTRT_CENT+1)*100 + ISYR
            ISDATE = (ISTRT_CENT+1)*100000000 + ISDATE
         ENDIF
         IF ( IEYR.GE.ISTRT_WIND .AND. IEYR.LE.99 ) THEN
            IEYR = ISTRT_CENT*100 + IEYR
            IEDATE = ISTRT_CENT*100000000 + IEDATE
         ELSEIF ( IEYR.LT.ISTRT_WIND ) THEN
            IEYR = (ISTRT_CENT+1)*100 + IEYR
            IEDATE = (ISTRT_CENT+1)*100000000 + IEDATE
         ENDIF
!        Loop through events to find start date and end date
         DO I = 1 , NUMEVE
            ITEMPDATE = EVDATE(I)
            ITEMPYEAR = ITEMPDATE/1000000
            IF ( ITEMPYEAR.GE.ISTRT_WIND .AND. ITEMPYEAR.LE.99 ) THEN
               ITEMPDATE = ISTRT_CENT*100000000 + ITEMPDATE
            ELSEIF ( ITEMPYEAR.LT.ISTRT_WIND ) THEN
               ITEMPDATE = (ISTRT_CENT+1)*100000000 + ITEMPDATE
            ENDIF
            IF ( ITEMPDATE.LT.ISDATE ) ISDATE = ITEMPDATE
            IF ( ITEMPDATE.GT.IEDATE ) IEDATE = ITEMPDATE
         ENDDO
!        Set start hour to 00 and end hour to 24
         ISDATE = (ISDATE/100)*100
         IEDATE = (IEDATE/100)*100 + 24
         ISYR = ISDATE/1000000
         IEYR = IEDATE/1000000
         ISMN = (ISDATE/10000) - (ISDATE/1000000)*100
         IEMN = (IEDATE/10000) - (IEDATE/1000000)*100
         ISDY = (ISDATE/100) - (ISDATE/10000)*100
         IEDY = (IEDATE/100) - (IEDATE/10000)*100
 
!        Write Out The Error Message: Mandatory Keyword Missing
         IF ( IESTAT(1).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         IF ( IESTAT(2).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','EVENTPER')
         IF ( IESTAT(3).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','EVENTLOC')
 
      ELSE
!        Write Error Message: Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==EVPER.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EVPER
!***********************************************************************
!                 EVPER Module of ISCEV2 Model
!
!        PURPOSE: Processes Date, Average Period And Source Group data
!                 for EVENT
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT).
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Event Name, Group ID, Average Period, Date
!
!        CALLED FROM:   EVCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: ISDX , IMN , IDY , IEVYR2 , IEVYR4
      CHARACTER USEVN*8
      LOGICAL FIND
      DOUBLE PRECISION DNUM
 
!     Variable Initializations
      MODNAM = 'EVPER'
      FIND = .FALSE.
 
      IF ( IEVENT.GT.NEVE ) THEN
!        WRITE Error Message    ! Too Many Events Specified
         WRITE (DUMMY,'(I8)') NEVE
         CALL ERRHDL(PATH,MODNAM,'E','290',DUMMY)
         GOTO 999
      ENDIF
 
!     Check Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.2 ) THEN
!        Error Message: Missing Parameter
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.6 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.7 ) THEN
!        Error Message: Too Many Parameters
!        Note That FIELD(7) Is Ignored If Present:  Used To Hold
!        Concentration Value for Events Generated From PASS ONE
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     READ EVNAME, AVEPER, GRPID, DATE
 
!     Get The Event Name
      USEVN = FIELD(3)
!     Check for Previous EVNAME
      CALL SINDEX(EVNAME,NEVE,USEVN,ISDX,FIND)
      IF ( .NOT.FIND ) THEN
         EVNAME(IEVENT) = USEVN
      ELSE
!        Error Message: Duplicate EVNAME
         CALL ERRHDL(PATH,MODNAM,'E','313',EVNAME(ISDX))
         GOTO 999
      ENDIF
 
!     Get Averaging Period For The Event
      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ELSE
         EVAPER(IEVENT) = NINT(FNUM)
      ENDIF
 
!     Check for Valid Averaging Period
      DO IAVE = 1 , NUMAVE
         IF ( EVAPER(IEVENT).EQ.KAVE(IAVE) ) THEN
            FIND = .TRUE.
!              Write Error Message for Invalid Averaging Period, Must be <=24
            IF ( EVAPER(IEVENT).GT.24 )                                 &
     &            CALL ERRHDL(PATH,MODNAM,'E','390',EVNAME(IEVENT))
         ENDIF
      ENDDO
!        Error Message: Averaging Period Does Not Match
      IF ( .NOT.FIND ) CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
 
!     Take The Group ID
      EVGRP(IEVENT) = FIELD(5)
 
!     Retrieve The Index of The Group Array
      FIND = .FALSE.
      CALL SINDEX(GRPID,NGRP,EVGRP(IEVENT),ISDX,FIND)
      IF ( .NOT.FIND ) THEN
!        Error Message: Group ID Does Not Match
         CALL ERRHDL(PATH,MODNAM,'E','203','GROUPID')
      ELSE
         IDXEV(IEVENT) = ISDX
      ENDIF
 
!     Get The Date Of The Event -
!     First Convert Character String to Double Precision Real
      CALL STODBL(FIELD(6),ILEN_FLD,DNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ELSE
!        Note - EVDATE is an Integer Array
         EVDATE(IEVENT) = NINT(DNUM)
!        Extract 2-digit year from event date
         IEVYR2 = NINT(DNUM/1000000.)
!        Convert to 4-digit year
         IF ( IEVYR2.GE.ISTRT_WIND .AND. IEVYR2.LE.99 ) THEN
            IEVYR4 = ISTRT_CENT*100 + IEVYR2
         ELSEIF ( IEVYR2.LT.ISTRT_WIND ) THEN
            IEVYR4 = (ISTRT_CENT+1)*100 + IEVYR2
         ENDIF
         IMN = NINT(DNUM/10000.) - NINT(DNUM/1000000.)*100
         IDY = NINT(DNUM/100.) - NINT(DNUM/10000.)*100
         CALL JULIAN(IEVYR4,IMN,IDY,JDAY)
         IF ( JDAY.GE.1 .AND. JDAY.LE.366 ) THEN
            IPROC(JDAY) = 1
            EVJDAY(IEVENT) = JDAY
         ELSE
!           WRITE Error Message    ! Invalid Julian Day
            CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
            GOTO 999
         ENDIF
      ENDIF
 
      IEVENT = IEVENT + 1
 
 999  CONTINUE
      END
!*==EVLOC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE EVLOC
!***********************************************************************
!                 EVLOC Module of ISCEV2 Model
!
!        PURPOSE: Processes Receptor Location Inputs for Events
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Event Name, AXR, AYR, AZELEV, AZFLAG of the Event
!
!        CALLED FROM:   EVCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: ISDX
      REAL :: SETAXR , SETAYR
      CHARACTER USEVN*8 , IDNAM1*4 , IDNAM2*4
      LOGICAL FIND
 
!     Variable Initializations
      MODNAM = 'EVLOC'
 
!     Check Whether There Are Enough Parameter Fields
      IF ( IFC.EQ.2 ) THEN
!        Error Message: Missing Parameter
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.8 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.10 ) THEN
!        Error Message: Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     READ Event Name, XCOOR,YCOOR,ELEV,FLAG And Assign to Different Array
      USEVN = FIELD(3)
!     Check for Previous EVNAME
      CALL SINDEX(EVNAME,NEVE,USEVN,ISDX,FIND)
      IF ( .NOT.FIND ) THEN
!        Error Message: EVNAME Does Not Match
         CALL ERRHDL(PATH,MODNAM,'E','203','EVNAME')
         GOTO 999
      ENDIF
 
      IDNAM1 = FIELD(4)
 
      CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSE
         SETAXR = FNUM
      ENDIF
 
      IDNAM2 = FIELD(6)
 
      CALL STONUM(FIELD(7),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.EQ.-1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ELSE
         SETAYR = FNUM
      ENDIF
 
      IF ( IFC.GE.8 ) THEN
         CALL STONUM(FIELD(8),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
            AZELEV(ISDX) = FNUM
         ENDIF
         CALL STONUM(FIELD(9),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
            AZHILL(ISDX) = FNUM
         ENDIF
      ELSE
         AZELEV(ISDX) = 0.
         AZHILL(ISDX) = 0.
      ENDIF
 
      IF ( IFC.EQ.10 ) THEN
         CALL STONUM(FIELD(10),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSE
            AZFLAG(ISDX) = FNUM
         ENDIF
      ELSE
         AZFLAG(ISDX) = 0.
      ENDIF
 
      IF ( IDNAM1.EQ.'XR=' .AND. IDNAM2.EQ.'YR=' ) THEN
         AXR(ISDX) = SETAXR
         AYR(ISDX) = SETAYR
      ELSEIF ( IDNAM1.EQ.'RNG=' .AND. IDNAM2.EQ.'DIR=' ) THEN
         AXR(ISDX) = SETAXR*SIN(SETAYR*DTORAD)
         AYR(ISDX) = SETAXR*COS(SETAYR*DTORAD)
      ELSE
!        Write Error Message: Illegal Parameter
         CALL ERRHDL(PATH,MODNAM,'E','203','REC-TYPE')
      ENDIF
 
 999  CONTINUE
      END
!*==IBLVAL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE IBLVAL(XARG)
!=======================================================================
!             IBLVAL Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:  Calculating effective parameters for the inhomogeneous
!             boundary layer (IBL).
!
!   Input:    Downwind distance, XARG (m)
!
!   Output:   Effective parameters for wind speed, turbulence and
!             lapse rate
!
!   Called by:  PCALC, VCALC, ACALC, PLUMEF, PWIDTH
!
!   Assumptions:
!
!   Developer(s): Roger Brode, PES, Inc.
!   Date:         January 17, 1995
!
!   Revision history:
!
!RWB              Modified to use ZRT (height of receptor above stack
!                 base) instead of ZFLAG (height of receptor above
!                 ground) in defining the layer for the effective
!                 parameters.
!                 R.W. Brode, PES, 8/5/98
!
!RWB              Added calculation of effective Dtheta/Dz (TGEFF and
!                 TGEFF3) for use in calculating stable sigma-z.
!                 R.W. Brode, PES, 8/5/98
!
!RWB              Modified to let plume centroid height follow plume
!                 centerline height above ZI/2.  Also limit upper bound
!                 of averaging layer for direct plume to be .LE. ZI.
!                 This is needed to address cases where the
!                 plume height may exceed ZI.  For the SBL, the effective
!                 parameters are calculated at the plume centerline height.
!                 R.W. Brode, PES, 1/26/95
!
!   Reference(s): "Options for the Treatment of Inhomogeneity",
!                 Al Cimorelli, Revision 5, 12/13/94
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: NDXEFF , NDXBHI , NDXBLO , NDXALO
      REAL :: XARG , SZNEW , ZHI , ZLO , SZOLD , SZ3NEW , SZ3OLD ,      &
     &        SZDAVG , SZDNEW , SZDOLD
 
      SAVE 
!
!---- Data dictionary
!
!---- Data initializations
      MODNAM = 'IBLVAL'
!
!     *************************************************************
!
 
!RWB  Initialize the effective parameters based on
!RWB  values at plume height
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
         HTEFF = HE
         CALL LOCATE(GRIDHT,1,MXGLVL,HTEFF,NDXEFF)
         CALL GINTRP(GRIDHT(NDXEFF),GRIDWS(NDXEFF),GRIDHT(NDXEFF+1),    &
     &               GRIDWS(NDXEFF+1),HTEFF,UEFF)
         CALL GINTRP(GRIDHT(NDXEFF),GRIDSV(NDXEFF),GRIDHT(NDXEFF+1),    &
     &               GRIDSV(NDXEFF+1),HTEFF,SVEFF)
         CALL GINTRP(GRIDHT(NDXEFF),GRIDSW(NDXEFF),GRIDHT(NDXEFF+1),    &
     &               GRIDSW(NDXEFF+1),HTEFF,SWEFF)
         CALL GINTRP(GRIDHT(NDXEFF),GRIDTG(NDXEFF),GRIDHT(NDXEFF+1),    &
     &               GRIDTG(NDXEFF+1),HTEFF,TGEFF)
         IF ( PVMRM ) CALL GINTRP(GRIDHT(NDXEFF),GRIDEPS(NDXEFF),       &
     &                            GRIDHT(NDXEFF+1),GRIDEPS(NDXEFF+1),   &
     &                            HTEFF,EPSEFF)
 
!RWB     Modify treatment of low wind/low turbulence cases.
!RWB     R. Brode, PES, 8/15/96
         SWEFF = MAX(SWEFF,SWMIN)
         SVEFF = MAX(SVEFF,SVMIN,0.05*UEFF)
         UEFF = SQRT(UEFF*UEFF+2.*SVEFF*SVEFF)
 
!RJP     Add temporary debugging statement here.
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6014) UEFF , SVEFF , SWEFF
 6014       FORMAT (5X,'Initial effective parameters ',                 &
     &              'for the stable ','plume:',//,5x,'Ueff = ',F7.2,    &
     &              ' m/s; ','SVeff = ',F7.2,' m/s; SWeff = ',F7.2,     &
     &              ' m/s.',/)
         ENDIF
 
      ELSEIF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
 
!        Direct and Indirect Source
 
         IF ( PPF.LT.1.0 ) THEN
!RWB        Initialize effective parameters based on values at the
!RWB        plume centroid height (CENTER)
            HTEFF = CENTER
            CALL LOCATE(GRIDHT,1,MXGLVL,HTEFF,NDXEFF)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDWS(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDWS(NDXEFF+1),HTEFF,UEFFD)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDSV(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDSV(NDXEFF+1),HTEFF,SVEFFD)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDSW(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDSW(NDXEFF+1),HTEFF,SWEFFD)
            IF ( PVMRM ) CALL GINTRP(GRIDHT(NDXEFF),GRIDEPS(NDXEFF),    &
     &                               GRIDHT(NDXEFF+1),GRIDEPS(NDXEFF+1),&
     &                               HTEFF,EPSEFFD)
 
!RWB        Modify treatment of low wind/low turbulence cases.
!RWB        R. Brode, PES, 8/15/96
            SWEFFD = MAX(SWEFFD,SWMIN)
            SVEFFD = MAX(SVEFFD,SVMIN,0.05*UEFFD)
            UEFFD = SQRT(UEFFD*UEFFD+2.*SVEFFD*SVEFFD)
 
!RJP        Add temporary debugging statement here.
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6015) UEFFD , SVEFFD , SWEFFD
 6015          FORMAT (5X,'Initial effective parameters ',              &
     &                 'for the direct convective ','plume:',//,5x,     &
     &                 'UeffD = ',F7.2,' m/s; ','SVeffD = ',F7.2,       &
     &                 ' m/s; SWeffD = ',F7.2,' m/s.',/)
            ENDIF
 
         ENDIF
!RJP
!RJP     Penetrated source
!RJP
         IF ( PPF.GT.0.0 ) THEN
            HTEFF = HE3
            CALL LOCATE(GRIDHT,1,MXGLVL,HTEFF,NDXEFF)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDWS(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDWS(NDXEFF+1),HTEFF,UEFF3)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDSV(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDSV(NDXEFF+1),HTEFF,SVEFF3)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDSW(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDSW(NDXEFF+1),HTEFF,SWEFF3)
            CALL GINTRP(GRIDHT(NDXEFF),GRIDTG(NDXEFF),GRIDHT(NDXEFF+1), &
     &                  GRIDTG(NDXEFF+1),HTEFF,TGEFF3)
            IF ( PVMRM ) CALL GINTRP(GRIDHT(NDXEFF),GRIDEPS(NDXEFF),    &
     &                               GRIDHT(NDXEFF+1),GRIDEPS(NDXEFF+1),&
     &                               HTEFF,EPSEFF3)
 
!RWB        Modify treatment of low wind/low turbulence cases.
!RWB        R. Brode, PES, 8/15/96
            SWEFF3 = MAX(SWEFF3,SWMIN)
            SVEFF3 = MAX(SVEFF3,SVMIN,0.05*UEFF3)
            UEFF3 = SQRT(UEFF3*UEFF3+2.*SVEFF3*SVEFF3)
 
!RJP        Add temporary debugging statement here.
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6016) PPF , UEFF3 , SVEFF3 , SWEFF3
 6016          FORMAT (5X,'Penetration fraction = ',f6.3,/,5X,          &
     &                 'Initial effective parameters ',                 &
     &                 'for the penetrated ','plume:',//,5x,'Ueff3 = ', &
     &                 F7.2,' m/s; ','SVeff3 = ',F7.2,' m/s; SWeff3 = ',&
     &                 F7.2,' m/s.',/)
            ENDIF
         ENDIF
 
      ENDIF
 
!     End initialization.  Next compute averages across plume layer.
 
      IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
!        Determine Dispersion Parameters              ---   CALL PDIS
         CALL PDIS(XARG)
      ELSEIF ( SRCTYP(ISRC).EQ.'VOLUME' ) THEN
!        Determine Dispersion Parameters              ---   CALL VDIS
         CALL VDIS(XARG)
      ELSEIF ( SRCTYP(ISRC).EQ.'AREA' .OR. SRCTYP(ISRC)                 &
     &         .EQ.'AREAPOLY' .OR. SRCTYP(ISRC).EQ.'AREACIRC' .OR.      &
     &         SRCTYP(ISRC).EQ.'OPENPIT' ) THEN
!        Determine Vertical Dispersion Parameters     ---   CALL ADISZ
         CALL ADISZ(XARG)
      ENDIF
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
 
         SZNEW = SZ
 
         CENTER = HE
         IF ( CENTER.LE.5.0 .AND. ZRT.LE.5.0 ) THEN
            ZHI = 5.0
            ZLO = 0.0
         ELSEIF ( CENTER.GT.ZRT ) THEN
            ZHI = CENTER
            ZLO = MAX(CENTER-SZCOEF*SZNEW,ZRT)
         ELSE
            ZHI = MIN(CENTER+SZCOEF*SZNEW,ZRT)
            ZLO = CENTER
         ENDIF
 
!RJP     Add temporary debugging statement here.
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6030) IREC , CENTER , SZNEW , ZRT , ZLO , ZHI
 6030       FORMAT (5X,'Stable plume calculation',' for receptor # ',I3,&
     &              //,5x,'Height of plume center of mass = ',f6.1,     &
     &              ' m; Sigma-z estimate = ',f11.1,' m; ',             &
     &              'Receptor height = ',f6.1,' m; ',/,5x,'New ',       &
     &              'effective parameters are averaged between ',f6.1,  &
     &              ' and ',F6.1,' meters.',/)
         ENDIF
 
         CALL LOCATE(GRIDHT,1,MXGLVL,ZHI,NDXBHI)
         CALL LOCATE(GRIDHT,1,MXGLVL,ZLO,NDXBLO)
         NDXALO = NDXBLO + 1
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDWS,ZLO,NDXALO,ZHI,NDXBHI,UEFF)
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDSV,ZLO,NDXALO,ZHI,NDXBHI,SVEFF)
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDSW,ZLO,NDXALO,ZHI,NDXBHI,SWEFF)
         CALL ANYAVG(MXGLVL,GRIDHT,GRIDTG,ZLO,NDXALO,ZHI,NDXBHI,TGEFF)
         IF ( PVMRM ) CALL ANYAVG(MXGLVL,GRIDHT,GRIDEPS,ZLO,NDXALO,ZHI, &
     &                            NDXBHI,EPSEFF)
         SZOLD = SZ
 
!RWB     Modify treatment of low wind/low turbulence cases.
!RWB     R. Brode, PES, 8/15/96
         SWEFF = MAX(SWEFF,SWMIN)
         SVEFF = MAX(SVEFF,SVMIN,0.05*UEFF)
         UEFF = SQRT(UEFF*UEFF+2.*SVEFF*SVEFF)
 
!RJP     Add temporary debugging statement here.
 
         IF ( DEBUG ) THEN
            WRITE (DBGUNT,6031) UEFF , SVEFF , SWEFF
 6031       FORMAT (5X,'Effective parameters for stable ','plume:',//,  &
     &              5x,'Ueff = ',F7.2,' m/s; ','SVeff = ',F7.2,         &
     &              ' m/s; SWeff = ',F7.2,' m/s.',/)
         ENDIF
 
      ELSEIF ( UNSTAB .AND. (HS.LT.ZI) ) THEN
!RJP
!RJP  Process effective values for direct and penetrated plumes
!RJP
!RJP  First, process the penetrated plume, then the direct plumes.
!RJP
 
         IF ( PPF.GT.0.0 ) THEN
 
            SZ3NEW = SZ3
 
!RWB        Change ZEFF to ZRT in following block. RWB 1/23/95
            IF ( HE3.GT.ZRT ) THEN
               ZHI = HE3
               ZLO = MAX(HE3-SZCOEF*SZ3NEW,ZRT)
            ELSE
               ZHI = MIN(HE3+SZCOEF*SZ3NEW,ZRT)
               ZLO = HE3
            ENDIF
 
!RJP        Add temporary debugging statement here.
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6040) IREC , HE3 , SZ3NEW , ZRT , ZLO , ZHI
 6040          FORMAT (5X,'Penetrated plume calculation',               &
     &                 ' for receptor # ',I3,//,5x,                     &
     &                 'Height of plume center of mass = ',f6.1,        &
     &                 ' m; Sigma-z estimate = ',f11.1,' m; ',          &
     &                 'Receptor height = ',f6.1,' m; ',/,5x,'New ',    &
     &                 'effective parameters are averaged between ',    &
     &                 f6.1,' and ',F6.1,' meters.',/)
            ENDIF
 
            CALL LOCATE(GRIDHT,1,MXGLVL,ZHI,NDXBHI)
            CALL LOCATE(GRIDHT,1,MXGLVL,ZLO,NDXBLO)
            NDXALO = NDXBLO + 1
            CALL ANYAVG(MXGLVL,GRIDHT,GRIDWS,ZLO,NDXALO,ZHI,NDXBHI,     &
     &                  UEFF3)
            CALL ANYAVG(MXGLVL,GRIDHT,GRIDSV,ZLO,NDXALO,ZHI,NDXBHI,     &
     &                  SVEFF3)
            CALL ANYAVG(MXGLVL,GRIDHT,GRIDSW,ZLO,NDXALO,ZHI,NDXBHI,     &
     &                  SWEFF3)
            CALL ANYAVG(MXGLVL,GRIDHT,GRIDTG,ZLO,NDXALO,ZHI,NDXBHI,     &
     &                  TGEFF3)
            IF ( PVMRM ) CALL ANYAVG(MXGLVL,GRIDHT,GRIDEPS,ZLO,NDXALO,  &
     &                               ZHI,NDXBHI,EPSEFF3)
            SZ3OLD = SZ3
 
!RWB        Modify treatment of low wind/low turbulence cases.  R. Brode, PES,
!RWB        8/15/96
            SWEFF3 = MAX(SWEFF3,SWMIN)
            SVEFF3 = MAX(SVEFF3,SVMIN,0.05*UEFF3)
            UEFF3 = SQRT(UEFF3*UEFF3+2.*SVEFF3*SVEFF3)
 
!RJP        Add temporary debugging statement here.
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6041) UEFF3 , SVEFF3 , SWEFF3
 6041          FORMAT (5X,'Effective parameters for penetrated ',       &
     &                 'plume:',//,5x,'Ueff3 = ',F7.2,' m/s; ',         &
     &                 'SVeff3 = ',F7.2,' m/s; SWeff3 = ',F7.2,' m/s.', &
     &                 /)
            ENDIF
 
         ENDIF
 
         IF ( PPF.LT.1.0 ) THEN
 
!RJP        Process the direct plumes here. *************************
 
            SZDAVG = 0.5*(SZD1+SZD2)
            SZDNEW = SZDAVG
 
!RWB        Computation of CENTER (plume centroid height) has been
!RWB        moved to SUB. CENTROID (CALC1.FOR).
 
!RWB        Change ZEFF to ZRT in following block. RWB 1/23/95
            IF ( CENTER.LE.5.0 .AND. ZRT.LE.5.0 ) THEN
               ZHI = MIN(5.0,ZI)
               ZLO = 0.0
            ELSEIF ( CENTER.GT.ZRT ) THEN
!RWB           Limit ZHI to be .LE. ZI
               ZHI = MIN(CENTER,ZI)
               ZLO = MAX(CENTER-SZCOEF*SZDNEW,ZRT)
            ELSE
               ZHI = MIN(CENTER+SZCOEF*SZDNEW,ZRT)
               ZHI = MIN(ZHI,ZI)
               ZLO = CENTER
            ENDIF
 
!RJP        Add temporary debugging statement here.
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6050) IREC , CENTER , SZDNEW , ZRT , ZLO , &
     &                             ZHI
 6050          FORMAT (5X,'Direct plume calculation',' for receptor # ',&
     &                 I3,//,5x,'Height of plume center of mass = ',    &
     &                 f6.1,' m; Sigma-z estimate = ',f11.1,' m; ',     &
     &                 'Receptor height = ',f6.1,' m; ',/,5x,'New ',    &
     &                 'effective parameters are averaged between ',    &
     &                 f6.1,' and ',F6.1,' meters.',/)
            ENDIF
 
!RWB        Check for ZHI .LE. ZLO, skip averages
            IF ( ZHI.GT.ZLO ) THEN
               CALL LOCATE(GRIDHT,1,MXGLVL,ZHI,NDXBHI)
               CALL LOCATE(GRIDHT,1,MXGLVL,ZLO,NDXBLO)
               NDXALO = NDXBLO + 1
               CALL ANYAVG(MXGLVL,GRIDHT,GRIDWS,ZLO,NDXALO,ZHI,NDXBHI,  &
     &                     UEFFD)
               CALL ANYAVG(MXGLVL,GRIDHT,GRIDSV,ZLO,NDXALO,ZHI,NDXBHI,  &
     &                     SVEFFD)
               CALL ANYAVG(MXGLVL,GRIDHT,GRIDSW,ZLO,NDXALO,ZHI,NDXBHI,  &
     &                     SWEFFD)
               IF ( PVMRM ) CALL ANYAVG(MXGLVL,GRIDHT,GRIDEPS,ZLO,      &
     &                                  NDXALO,ZHI,NDXBHI,EPSEFFD)
            ELSE
!RWB           Use values at ZI if ZHI .LE. ZLO
               HTEFF = ZI
               CALL LOCATE(GRIDHT,1,MXGLVL,HTEFF,NDXEFF)
               CALL GINTRP(GRIDHT(NDXEFF),GRIDWS(NDXEFF),               &
     &                     GRIDHT(NDXEFF+1),GRIDWS(NDXEFF+1),HTEFF,     &
     &                     UEFFD)
               CALL GINTRP(GRIDHT(NDXEFF),GRIDSV(NDXEFF),               &
     &                     GRIDHT(NDXEFF+1),GRIDSV(NDXEFF+1),HTEFF,     &
     &                     SVEFFD)
               CALL GINTRP(GRIDHT(NDXEFF),GRIDSW(NDXEFF),               &
     &                     GRIDHT(NDXEFF+1),GRIDSW(NDXEFF+1),HTEFF,     &
     &                     SWEFFD)
               IF ( PVMRM ) CALL GINTRP(GRIDHT(NDXEFF),GRIDEPS(NDXEFF), &
     &                                  GRIDHT(NDXEFF+1),               &
     &                                  GRIDEPS(NDXEFF+1),HTEFF,EPSEFFD)
            ENDIF
            SZDOLD = SZDAVG
 
!RWB        Modify treatment of low wind/low turbulence cases.
!RWB        R. Brode, PES, 8/15/96
            SWEFFD = MAX(SWEFFD,SWMIN)
            SVEFFD = MAX(SVEFFD,SVMIN,0.05*UEFFD)
            UEFFD = SQRT(UEFFD*UEFFD+2.*SVEFFD*SVEFFD)
 
!RJP        Add temporary debugging statement here.
 
            IF ( DEBUG ) THEN
               WRITE (DBGUNT,6051) UEFFD , SVEFFD , SWEFFD
 6051          FORMAT (5X,'Effective parameters for direct ','plume:',  &
     &                 //,5x,'UeffD = ',F7.2,' m/s; ','SVeffD = ',F7.2, &
     &                 ' m/s; SWeffD = ',F7.2,' m/s.',/)
            ENDIF
 
         ENDIF
 
      ENDIF
 
!RWB  Set effective parameters for indirect source = direct source
      IF ( UNSTAB .AND. HS.LT.ZI ) THEN
         UEFFN = UEFFD
         SVEFFN = SVEFFD
         SWEFFN = SWEFFD
      ENDIF
 
      CONTINUE
      END
!*==METINI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE METINI
!=======================================================================
!             METINI Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:  To compute the met parameters at stack top and the averages
!             within the mixed layer
!
!   Input:
!
!   Output:
!
!   Called by:   PCALC
!
!   Assumptions:
!
!   Developer(s): Jim Paumier and Roger Brode, PES, Inc.
!   Date:         30 September 1993
!
!   Revision history:
!                      Added initialization of effective parameters
!                      to stack top parameters, including TGEFF and
!                      TGEFF3, replacing intializations that were
!                      formerly included in subroutine PCALC.
!                      R.W. Brode, PES, 12/6/99
!
!                      Calls to ZIAVER to average sigma-V, sigma-W
!                      and wind speed moved here from METEXT.  This
!                      allows averaging up to HS when it is higher
!                      than ZI.  It now averages from the surface to
!                      the higher of ZI or HS.  Ref:  Summary of AERMOD
!                      equations, A. Venkatram, 7/7/94.  Changed 7/12/94
!                      by Russell F. Lee.
!
!                      Added calculation of local vertical lagrangian
!                      time scales at stack height and at ZI/2.  These
!                      are needed for calculating the effective TsubLZ
!                      and the horizontal lagrangian time scale,
!                      respectively.  Changed 7/14/94 by R.F. Lee
!
!
!   Reference(s): "Inhomogeneous Boundary Layer", A. Venkatram, 6/25/93
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: VALABV , VBELOW
 
      SAVE 
 
!---- Data dictionary
!
!---- Data initializations
!
!.......................................................................
!---- Compute the parameter values at stack height
 
!CRFL
!CRFL  Add calculation of local vertical lagrangian time scale
!CRFL  at stack height and at ZI/2.
!CRFL
 
      IF ( NDXSTK(ISRC).GE.1 ) THEN
!----    Sigma_V at stack height
         CALL GINTRP(GRIDHT(NDXSTK(ISRC)),GRIDSV(NDXSTK(ISRC)),         &
     &               GRIDHT(NDXSTK(ISRC)+1),GRIDSV(NDXSTK(ISRC)+1),HS,  &
     &               SVS)
 
!----    Sigma_W
         CALL GINTRP(GRIDHT(NDXSTK(ISRC)),GRIDSW(NDXSTK(ISRC)),         &
     &               GRIDHT(NDXSTK(ISRC)+1),GRIDSW(NDXSTK(ISRC)+1),HS,  &
     &               SWS)
 
!----    Wind speed
         CALL GINTRP(GRIDHT(NDXSTK(ISRC)),GRIDWS(NDXSTK(ISRC)),         &
     &               GRIDHT(NDXSTK(ISRC)+1),GRIDWS(NDXSTK(ISRC)+1),HS,  &
     &               US)
 
!----    Wind direction
!----    Check for 360 crossover and adjust if necessary
         VALABV = GRIDWD(NDXSTK(ISRC)+1)
         VBELOW = GRIDWD(NDXSTK(ISRC))
 
         IF ( (VALABV-VBELOW).LT.-180.0 ) THEN
            VALABV = VALABV + 360.
         ELSEIF ( (VALABV-VBELOW).GT.180.0 ) THEN
            VALABV = VALABV - 360.
         ENDIF
 
         CALL GINTRP(GRIDHT(NDXSTK(ISRC)),VBELOW,GRIDHT(NDXSTK(ISRC)+1),&
     &               VALABV,HS,WDIR)
 
!        Check for WDIR > 360 or < 0
         IF ( WDIR.GT.360. ) THEN
            WDIR = WDIR - 360.
         ELSEIF ( WDIR.LE.0.0 ) THEN
            WDIR = WDIR + 360.
         ENDIF
!
!----    Potential temperature gradient
         CALL GINTRP(GRIDHT(NDXSTK(ISRC)),GRIDTG(NDXSTK(ISRC)),         &
     &               GRIDHT(NDXSTK(ISRC)+1),GRIDTG(NDXSTK(ISRC)+1),HS,  &
     &               TGS)
 
!----    Potential temperature
         CALL GINTRP(GRIDHT(NDXSTK(ISRC)),GRIDPT(NDXSTK(ISRC)),         &
     &               GRIDHT(NDXSTK(ISRC)+1),GRIDPT(NDXSTK(ISRC)+1),HS,  &
     &               PTS)
 
      ELSE
!        Use GRID value for lowest level
         SVS = GRIDSV(1)
         SWS = GRIDSW(1)
         US = GRIDWS(1)
         WDIR = GRIDWD(1)
         TGS = GRIDTG(1)
         PTS = GRIDPT(1)
      ENDIF
 
!RWB  Modify the treatment of low wind/low turbulence cases per 7/31/96
!RWB  write-up by Steve Perry.  R. Brode, PES, 8/15/96
      SWS = MAX(SWS,SWMIN)
      SVS = MAX(SVS,SVMIN,0.05*US)
      US = SQRT(US*US+2.*SVS*SVS)
 
!
!---- If the wind for the hour is not calm or missing, then convert
!     direction to radians, compute sine and cosine of direction,
!     and determine nearest 10-degree sector.
!
      IF ( (.NOT.CLMHR .OR. .NOT.CLMPRO) .AND.                          &
     &     (.NOT.MSGHR .OR. .NOT.MSGPRO) ) THEN
!
!---->   wind direction = wind direction in degrees * DTORAD
 
         WDSIN = SIN(WDIR*DTORAD)
         WDCOS = COS(WDIR*DTORAD)
 
         AFV = WDIR - 180.0
         IF ( AFV.LT.0.0 ) AFV = AFV + 360.0
         IFVSEC = INT(AFV*0.10+0.4999)
         IF ( IFVSEC.EQ.0 ) IFVSEC = 36
 
      ENDIF
 
!
!     ------------------------------------------------------------
!     Apply lower limit of 0.002 K/m to lapse rate for stable
!     layers.
!     ------------------------------------------------------------
!
!RJP
!RJP  ASSIGN TGP AS TGS INITIALLY
!RJP
      TGP = TGS
!
 
!---- Calculate potential temperature at stack height, PTS, for plume
!     rise calculations.  Compute stack height ambient temperature, TA.
!     NOTE:  TA is no longer the temperature read in by METEXT from the
!            scalar file
      TA = PTS - GOVRCP*(HS+ZBASE)
 
!--------Compute the overbar (average) quantities for sigma_V, sigma_W,
!        and wind speed, from the surface to the higher of ZI or HS.
!        The procedure is to average to ZI using ZIAVER, then extend it
!        to HS using HEAVER.  LOCATE locates the highest gridded height
!        before HS.
 
      CALL ZIAVER(MXGLVL,GRIDHT,GRIDSV,ZI,NDX4ZI,SVAVG,SVATZI)
      CALL ZIAVER(MXGLVL,GRIDHT,GRIDSW,ZI,NDX4ZI,SWAVG,SWATZI)
      CALL ZIAVER(MXGLVL,GRIDHT,GRIDWS,ZI,NDX4ZI,UAVG,UATZI)
 
!---- Assign wind speed to use for plume rise, UP = US
      UP = US
 
!     Compute the Brunt-Vaisala frequency, BVF, at stack height for STABLE
!     conditions or for UNSTAB releases above ZI.  Check for TGS < 0 first.
      IF ( (TGS.GT.0.0) .AND. (STABLE .OR. (UNSTAB .AND. HS.GE.ZI)) )   &
     &     THEN
         BVF = SQRT(G*TGS/PTS)
      ELSE
         BVF = 1.0E-10
      ENDIF
 
      IF ( BVF.LT.1.0E-10 ) BVF = 1.0E-10
 
      BVPRIM = 0.7*BVF
 
!RJP  For downwash calculations, set temporarily assigned effective values
      UEFF = US
      SVEFF = SVS
      SWEFF = SWS
      TGEFF = TGS
      UEFFD = US
      SVEFFD = SVS
      SWEFFD = SWS
!RWB  Add effective parameters for indirect plume.  RWB, 12/8/94
      UEFFN = US
      SVEFFN = SVS
      SWEFFN = SWS
      UEFF3 = US
      SVEFF3 = SVS
      SWEFF3 = SWS
      TGEFF3 = TGS
 
!     Define temporary values of CENTER and SURFAC based on HS
      CENTER = HS
      IF ( CENTER.LT.0.1*ZI ) THEN
         SURFAC = .TRUE.
 
      ELSE
         SURFAC = .FALSE.
      ENDIF
 
      CONTINUE
      END
!*==LOCATE.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE LOCATE(PARRAY,LVLBLW,LVLABV,VALUE,NDXBLW)
!=======================================================================
!             LOCATE Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To return the array index such that VALUE is between
!                PARRAY(NDXBLW) and PARRAY(NDXBLW+1).
!
!   Input:       Array of gridded values (PARRAY)
!                Lower array bound at which to start the search (LVLBLW)
!                Upper array bound at which to end the search (LVLABV)
!                Value being searched for (VALUE)
!
!   Output:      Index of PARRAY immediately below VALUE (NDXBLW)
!
!   Called by:   Utility routine that can be used by any module:
!                  SRCSET (in SOSET) for stack heights
!                  METEXT for mixing height
!
!   Assumptions: PARRAY must be montonically increasing or decreasing;
!                LVLBLW can be no less than 1;
!
!   Developer(s): Jim Paumier and Roger Brode, PES, Inc.
!   Date:         30 September 1993
!
!   Revision history:
!                <none>
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
!
      IMPLICIT NONE
 
      INTEGER LVLABV , LVLBLW , NDXBLW , JL , JM , JU
      REAL PARRAY(LVLABV) , VALUE
!
!---- Data dictionary
!     JL   lower bound temporary variable
!     JM   midpoint temporary variable
!     JU   upper bound temporary variable
!
!----
      JL = LVLBLW - 1
      JU = LVLABV + 1
 
      DO WHILE ( (JU-JL).GT.1 )
 
         JM = (JU+JL)/2
 
         IF ( VALUE.GE.PARRAY(JM) ) THEN
            JL = JM
         ELSE
            JU = JM
         ENDIF
 
      ENDDO
 
      NDXBLW = JL
 
      CONTINUE
      END
!*==ANYAVG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
!RJP  Add subroutine ANYAVG
 
      SUBROUTINE ANYAVG(NLVLS,HTS,PARRAY,ZBOT,NDXABV,ZTOP,NDXBLW,VALAVG)
!***********************************************************************
!             ANYAVG Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To compute the average value of the parameter between
!                any two heights (ZBOT and ZTOP)
!
!   Input:       Number of levels in the profile (NLVLS)
!                Array of gridded profile heights (HTS)
!                Parameter array (PARRAY)
!                Lower bound of averaging layer (ZBOT)
!                Index of the level gridded profile height immediately
!                   above ZBOT (NDXABV)
!                Upper bound of averaging layer (ZTOP)
!                Index of the level gridded profile height immediately
!                   below ZTOP (NDXBLW)
!
!   Output:      Average value of parameter in layer (VALAVG);
!
!   Called by:   METEXT
!
!   Assumptions: If ZTOP is above the highest profile height (5000 m),
!                then we assume the profile is constant
!                (= PARRAY(NLVLS)) above 5000 m and compute
!                the average accordingly.
!
!   Adjustments: If ZBOT is less than 0.5 m, it is set to 0.5 m.  If ZTOP
!                is less than 0.5 m, it is set to 0.51 m.
!
!   Programmer:  Bob Paine
!
!   Date:        October 4, 1994
!
!   Revision history:
!                Derived from ZIAVER
!
!   Reference(s): Alternative Approach to Treatment of inhomogeneity
!                 October 3, 1994 (Al Cimorelli)
!
!***********************************************************************
!
!---- Variable declarations
!
      IMPLICIT NONE
 
      INTEGER I , NLVLS , NDXABV , NDXBLW
      REAL HTS(NLVLS) , PARRAY(NLVLS) , ZBOT , ZTOP , SUM , VALAVG
      REAL VALBOT , VALTOP
!
!---- Data initializations
!
!.......................................................................
!
      SUM = 0.0
!
!     NDXABV is the profile index of the height just above ZBOT, and
!     NDXBLW is the profile index of the height just below ZTOP.
!
!---- Sum over each layer of the gridded profile (PARRAY) from NDXABV
!     to NDXBLW.  First, check to see if ZBOT and ZTOP are so close
!     together that summation over several profile levels is not
!     necessary.
!
!     Check for minimum values of ZTOP and ZBOT.
!
      IF ( ZBOT.LT.0.5 ) THEN
         ZBOT = 0.5
         NDXABV = 2
      ENDIF
      IF ( ZTOP.LT.0.51 ) THEN
         ZTOP = 0.51
         NDXBLW = 2
      ENDIF
!
      IF ( NDXBLW.LT.NDXABV ) GOTO 300
      IF ( NDXBLW.EQ.NDXABV ) GOTO 200
!
!     Sum using trapezoidal rule over intermediate profile layers.
!
      DO I = NDXABV + 1 , NDXBLW
         SUM = SUM + (HTS(I)-HTS(I-1))*0.5*(PARRAY(I)+PARRAY(I-1))
      ENDDO
!
!---- Finish the summation over partial layers at bottom (first), then
!     the top.
!
 200  CONTINUE
      IF ( NDXABV.GT.1 ) THEN
         CALL GINTRP(HTS(NDXABV-1),PARRAY(NDXABV-1),HTS(NDXABV),        &
     &               PARRAY(NDXABV),ZBOT,VALBOT)
         SUM = SUM + (HTS(NDXABV)-ZBOT)*0.5*(VALBOT+PARRAY(NDXABV))
      ELSE
         SUM = SUM + (HTS(1)-ZBOT)*PARRAY(1)
      ENDIF
 
      IF ( NDXBLW.LT.NLVLS ) THEN
         CALL GINTRP(HTS(NDXBLW),PARRAY(NDXBLW),HTS(NDXBLW+1),          &
     &               PARRAY(NDXBLW+1),ZTOP,VALTOP)
         SUM = SUM + (ZTOP-HTS(NDXBLW))*0.5*(VALTOP+PARRAY(NDXBLW))
      ELSE
         SUM = SUM + (ZTOP-HTS(NLVLS))*PARRAY(NLVLS)
      ENDIF
!
!     Take average
!
      VALAVG = SUM/(ZTOP-ZBOT)
      GOTO 999
!
!     At 300, just take the interpolated value halfway between ZBOT
!     and ZTOP, because both are within the same profile layer.
!
 300  CALL GINTRP(HTS(NDXABV-1),PARRAY(NDXABV-1),HTS(NDXABV),           &
     &            PARRAY(NDXABV),0.5*(ZBOT+ZTOP),VALAVG)
!
 999  CONTINUE
      END
!*==INPSUM.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE INPSUM
!***********************************************************************
!                 INPSUM Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Print Out The Input Data Summary
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Receptor Locations
!                 Arrays of Model Results
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'INPSUM'
 
!     Print Out The Model Options
      CALL PRTOPT
 
!     Print Out The Input Source Data
      CALL PRTSRC
 
      IF ( .NOT.EVONLY ) THEN
!        Print Out The Input Receptor Coordinates.
         CALL PRTREC
 
!        Check For Receptors Too Close To Sources (< 1m or < 3Lb)
         CALL CHKREC
      ENDIF
 
!     Print Out The Input Met Data Summary
      CALL PRTMET
 
      CONTINUE
      END
!*==PRTOPT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRTOPT
!***********************************************************************
!                 PRTOPT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Print Out The Model Options and Keyword Summary
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To Remove Summary of Keywords Table
!                    Roger Brode, PES, Inc.,  - 11/08/94
!
!        MODIFIED:   To add pathway 'TG' to process input file of Gridded
!                    Terrain data.
!                    D. Strimaitis, SRC - 11/8/93
!
!        MODIFIED:   To add DDEP and WDEP parameters to CONC/DEPOS options
!                    to allow just the wet or just the dry deposition flux
!                    to be reported.  DEPOS now reports the sum of wet and
!                    dry fluxes.  Expand keywords to include input of wet
!                    scavenging coefficients (SO path).  Add override of
!                    Intermediate Terrain so that results are for only the
!                    simple terrain or the complex terrain model.
!                    D. Strimaitis, SRC - 11/8/93
!
!        MODIFIED:  To Include TOXXFILE Option - 9/29/92
!
!        INPUTS:  Model Options and Keyword Summarys
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   INPSUM
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , ILMAX
      REAL :: STORE
 
!     Variable Initializations
      MODNAM = 'PRTOPT'
 
!     Summarize The Model Options
      CALL HEADER
      WRITE (IOUNIT,9041)
 
 9041 FORMAT (44X,'***     MODEL SETUP OPTIONS SUMMARY       ***'/63    &
     &        (' -')/)
      IF ( CONC ) WRITE (IOUNIT,*)                                      &
     &                            '**Model Is Setup For Calculation of '&
     &                            , 'Average CONCentration Values.'
      IF ( DEPOS ) WRITE (IOUNIT,*)                                     &
     &                            '**Model Is Setup For Calculation of '&
     &                            , 'Total DEPOSition Values.'
      IF ( DDEP ) WRITE (IOUNIT,*)                                      &
     &                            '**Model Is Setup For Calculation of '&
     &                            , 'Dry DEPosition Values.'
      IF ( WDEP ) WRITE (IOUNIT,*)                                      &
     &                            '**Model Is Setup For Calculation of '&
     &                            , 'Wet DEPosition Values.'
 
      WRITE (IOUNIT,9099)
      WRITE (IOUNIT,*) '  --  DEPOSITION LOGIC  --'
      IF ( DDPLETE ) THEN
         WRITE (IOUNIT,*) '**Model Uses DRY DEPLETION.  DDPLETE = ' ,   &
     &                    DDPLETE
      ELSE
         WRITE (IOUNIT,*) '**Model Uses NO DRY DEPLETION.  DDPLETE = ' ,&
     &                    DDPLETE
      ENDIF
      IF ( WDPLETE ) THEN
         WRITE (IOUNIT,*) '**Model Uses WET DEPLETION.  WDPLETE = ' ,   &
     &                    WDPLETE
      ELSE
         WRITE (IOUNIT,*) '**Model Uses NO WET DEPLETION.  WDPLETE = ' ,&
     &                    WDPLETE
      ENDIF
      IF ( LDGAS .AND. LUSERVD ) THEN
         WRITE (IOUNIT,*)                                               &
     &                   '**USER-SPECIFIED DRY DEPOSITION VELOCITY for '&
     &                   , 'Gases Provided.  LDGAS = ' , LDGAS
      ELSEIF ( LDGAS ) THEN
         WRITE (IOUNIT,*)                                               &
     &                   '**GAS DRY DEPOSITION Data Provided.  LDGAS = '&
     &                   , LDGAS
      ELSE
         WRITE (IOUNIT,*) '**NO GAS DRY DEPOSITION Data Provided. '
      ENDIF
 
      WRITE (IOUNIT,9099)
      IF ( .NOT.URBAN ) THEN
         WRITE (IOUNIT,*) '**Model Uses RURAL Dispersion Only.'
      ELSEIF ( URBAN ) THEN
         WRITE (IOUNIT,9039) NUMURB
 9039    FORMAT (1X,'**Model Uses URBAN Dispersion Algorithm ',         &
     &           'for the SBL for ',I5,' Source(s).')
         WRITE (IOUNIT,9040) URBPOP , URBZ0
 9040    FORMAT (3X,'The Urban Population = ',F11.1,' ;  Urban ',       &
     &           'Roughness Length = ',F6.3,' m')
      ENDIF
 
      WRITE (IOUNIT,9099)
      IF ( DFAULT ) THEN
         WRITE (IOUNIT,*) '**Model Uses Regulatory DEFAULT Options:'
         WRITE (IOUNIT,*) '           1. Stack-tip Downwash.'
         WRITE (IOUNIT,*) '           2. Model Accounts for ELEVated ' ,&
     &                    'Terrain Effects.'
         WRITE (IOUNIT,*) '           3. Use Calms Processing ' ,       &
     &                    'Routine.'
         WRITE (IOUNIT,*) '           4. Use Missing Data ' ,           &
     &                    'Processing Routine.'
         WRITE (IOUNIT,*) '           5. "Upper Bound" Values ' ,       &
     &                    'for Supersquat Buildings.'
         IF ( URBAN .AND. POLLUT.EQ.'SO2' ) THEN
            WRITE (IOUNIT,*) '           6. Half-life of 4 hrs for' ,   &
     &                       ' URBAN SO2.'
         ELSEIF ( URBAN .AND. POLLUT.NE.'SO2' ) THEN
            WRITE (IOUNIT,*) '           6. No Exponential Decay for' , &
     &                       ' URBAN/Non-SO2'
         ELSE
            WRITE (IOUNIT,*) '           6. No Exponential Decay'
         ENDIF
      ELSE
         WRITE (IOUNIT,*) '**Model Uses User-Specified Options:'
         IF ( NOSTD ) THEN
            WRITE (IOUNIT,*) '        1. Not Use Stack-tip ' ,          &
     &                       'Downwash.'
         ELSE
            WRITE (IOUNIT,*) '        1. Stack-tip Downwash.'
         ENDIF
         IF ( FLAT ) THEN
            WRITE (IOUNIT,*) '        2. Model Assumes Receptors on ' , &
     &                       'FLAT Terrain.'
         ELSEIF ( ELEV ) THEN
            WRITE (IOUNIT,*) '        2. Model Accounts for ELEVated ' ,&
     &                       'Terrain Effects.'
         ENDIF
         IF ( PVMRM ) THEN
            WRITE (IOUNIT,*) '        3. Plume Volume Molar Ratio ' ,   &
     &                       'Method (PVMRM) Used for NO2 Conversion'
            WRITE (IOUNIT,*) '           with an Equilibrium NO2/NOx ' ,&
     &                       'Ratio of ' , NO2EQUIL
         ELSEIF ( OLM ) THEN
            WRITE (IOUNIT,*) '        3. Ozone Limiting Method (OLM) ' ,&
     &                       'Used for NO2 Conversion.'
         ELSEIF ( POLLUT.EQ.'NO2' ) THEN
            WRITE (IOUNIT,*) '        3. Full Conversion Assumed for ' ,&
     &                       'NO2.'
         ENDIF
      ENDIF
 
      IF ( NOWARN .OR. NOCHKD .OR. SCREEN .OR. TOXICS .OR. SCIM ) THEN
         WRITE (IOUNIT,9099)
         WRITE (IOUNIT,*) '**Other Options Specified:'
      ENDIF
      IF ( NOCHKD ) WRITE (IOUNIT,*)                                    &
     &                            '        NOCHKD - Suppresses checking'&
     &                            ,                                     &
     &                         ' of date sequence in meteorology files.'
      IF ( NOWARN ) WRITE (IOUNIT,*)                                    &
     &                             '        NOWARN - Suppresses writing'&
     &                             ,                                    &
     &                         ' of warning messages in main print file'
      IF ( TOXICS ) WRITE (IOUNIT,*)                                    &
     &                           '        TOXICS - Allows use of TOXICS'&
     &                           , ' option enhancements.'
      IF ( SCIM ) WRITE (IOUNIT,*) '        SCIM   - Uses Sampled' ,    &
     &                             ' Chronological Input Model option.'
      IF ( SCREEN ) WRITE (IOUNIT,*)                                    &
     &                         '        SCREEN - Uses screening option '&
     &                         ,                                        &
     &                   'which forces calculation of centerline values'
!*#
      WRITE (IOUNIT,9099)
      IF ( FLGPOL ) THEN
         WRITE (IOUNIT,*) '**Model Accepts FLAGPOLE Receptor Heights.'
      ELSE
         WRITE (IOUNIT,*)                                               &
     &                   '**Model Assumes No FLAGPOLE Receptor Heights.'
      ENDIF
 
!     Model Sources And Receptors Summary
      WRITE (IOUNIT,9099)
      IF ( PERIOD ) THEN
         IF ( NUMAVE.GT.0 ) THEN
            WRITE (IOUNIT,9042) NUMAVE , (CHRAVE(I),I=1,NUMAVE)
            WRITE (IOUNIT,9043)
 9043       FORMAT (1X,'    and Calculates PERIOD Averages')
         ELSE
            WRITE (IOUNIT,9045)
 9045       FORMAT (1X,'**Model Calculates PERIOD Averages Only')
         ENDIF
      ELSEIF ( ANNUAL ) THEN
         IF ( NUMAVE.GT.0 ) THEN
            WRITE (IOUNIT,9042) NUMAVE , (CHRAVE(I),I=1,NUMAVE)
            WRITE (IOUNIT,9143)
 9143       FORMAT (1X,'    and Calculates ANNUAL Averages')
         ELSE
            WRITE (IOUNIT,9145)
 9145       FORMAT (1X,'**Model Calculates ANNUAL Averages Only')
         ENDIF
      ELSE
         WRITE (IOUNIT,9042) NUMAVE , (CHRAVE(I),I=1,NUMAVE)
      ENDIF
 
!     Write Out Numbers of Sources, Groups, and Receptors for This Run
      WRITE (IOUNIT,9099)
      IF ( EVONLY ) THEN
         WRITE (IOUNIT,9046) NUMSRC , NUMGRP , NUMEVE
 9046    FORMAT (1X,'**This Run Includes: ',I5,' Source(s);  ',I5,      &
     &           ' Source Group(s); and  ',I6,' Event(s)')
      ELSEIF ( .NOT.EVONLY ) THEN
         WRITE (IOUNIT,9044) NUMSRC , NUMGRP , NUMREC
 9044    FORMAT (1X,'**This Run Includes: ',I5,' Source(s);  ',I5,      &
     &           ' Source Group(s); and  ',I6,' Receptor(s)')
      ENDIF
 
!     Write Out Pollutant Type
      WRITE (IOUNIT,9099)
      WRITE (IOUNIT,9048) POLLUT
 9048 FORMAT (1X,'**The Model Assumes A Pollutant Type of:  ',A8)
 
!     Model Run OR Not Options
      WRITE (IOUNIT,9099)
      IF ( RUN ) THEN
         WRITE (IOUNIT,*) '**Model Set To Continue RUNning After the ' ,&
     &                    'Setup Testing.'
      ELSE
         WRITE (IOUNIT,*) '**Model Will NOT Run After the ' ,           &
     &                    'Setup Testing.'
      ENDIF
 
!     Model Output Options Setting Summary
      WRITE (IOUNIT,9099)
      WRITE (IOUNIT,9070)
 9070 FORMAT (1X,'**Output Options Selected:')
      IF ( PERIOD ) THEN
!        PERIOD Averages by Receptor Are Output
         WRITE (IOUNIT,9071)
 9071    FORMAT (10X,                                                   &
     &           'Model Outputs Tables of PERIOD Averages by Receptor')
      ELSEIF ( ANNUAL ) THEN
!        ANNUAL Averages by Receptor Are Output
         WRITE (IOUNIT,9171)
 9171    FORMAT (10X,                                                   &
     &           'Model Outputs Tables of ANNUAL Averages by Receptor')
      ENDIF
      IF ( IOSTAT(2).GT.0 ) THEN
!        RECTABLE Keyword Used
         WRITE (IOUNIT,9072)
 9072    FORMAT (10X,                                                   &
     &           'Model Outputs Tables of Highest Short Term Values by',&
     &           ' Receptor (RECTABLE Keyword)')
      ENDIF
      IF ( IOSTAT(3).GT.0 ) THEN
!        MAXTABLE Keyword Used
         WRITE (IOUNIT,9073)
 9073    FORMAT (10X,                                                   &
     &           'Model Outputs Tables of Overall Maximum Short Term',  &
     &           ' Values (MAXTABLE Keyword)')
      ENDIF
      IF ( IOSTAT(4).GT.0 ) THEN
!        DAYTABLE Keyword Used
         WRITE (IOUNIT,9074)
 9074    FORMAT (10X,                                                   &
     &           'Model Outputs Tables of Concurrent Short Term Values',&
     &          ' by Receptor for Each Day Processed (DAYTABLE Keyword)'&
     &          )
      ENDIF
      IF ( IOSTAT(5).GT.0 ) THEN
!        MAXIFILE Keyword Used
         WRITE (IOUNIT,9075)
 9075    FORMAT (10X,'Model Outputs External File(s) of Threshold',     &
     &           ' Violations (MAXIFILE Keyword)')
      ENDIF
      IF ( IOSTAT(6).GT.0 ) THEN
!        POSTFILE Keyword Used
         WRITE (IOUNIT,9076)
 9076    FORMAT (10X,                                                   &
     &           'Model Outputs External File(s) of Concurrent Values', &
     &           ' for Postprocessing (POSTFILE Keyword)')
      ENDIF
      IF ( IOSTAT(7).GT.0 ) THEN
!        PLOTFILE Keyword Used
         WRITE (IOUNIT,9077)
 9077    FORMAT (10X,'Model Outputs External File(s) of High Values for'&
     &           ,' Plotting (PLOTFILE Keyword)')
      ENDIF
      IF ( IOSTAT(8).GT.0 ) THEN
!        TOXXFILE Keyword Used
         WRITE (IOUNIT,9078)
 9078    FORMAT (10X,                                                   &
     &           'Model Outputs External File(s) of Values for Input',  &
     &           ' to TOXX Model (TOXXFILE Keyword)')
      ENDIF
      IF ( IOSTAT(9).GT.0 ) THEN
!        SEASONHR Keyword Used
         WRITE (IOUNIT,99071)
99071    FORMAT (10X,                                                   &
     &           'Model Outputs External File(s) of Values by Season',  &
     &           ' and Hour-of-Day (SEASONHR Keyword)')
      ENDIF
      IF ( IOSTAT(10).GT.0 ) THEN
!        RANKFILE Keyword Used
         WRITE (IOUNIT,99072)
99072    FORMAT (10X,'Model Outputs External File(s) of Ranked Values', &
     &           ' (RANKFILE Keyword)')
      ENDIF
      IF ( IOSTAT(11).GT.0 ) THEN
!        EVALFILE Keyword Used
         WRITE (IOUNIT,99073)
99073    FORMAT (10X,                                                   &
     &           'Model Outputs External File(s) of Arc-maximum Values',&
     &           ' for Evaluation Purposes (EVALFILE Keyword)')
      ENDIF
 
!     Write Explanatory Note About Calm and Missing Flags
      IF ( CLMPRO .OR. MSGPRO ) THEN
         WRITE (IOUNIT,9099)
         WRITE (IOUNIT,9079) CHIDEP(3,1)
 9079    FORMAT (1X,'**NOTE:  The Following Flags May Appear Following '&
     &           ,A4,' Values:  c for Calm Hours',/65X,                 &
     &           'm for Missing Hours',/65X,                            &
     &           'b for Both Calm and Missing Hours')
      ENDIF
 
!     Model Misc. Information
      WRITE (IOUNIT,9099)
      WRITE (IOUNIT,9050) ZBASE , DECOEF , ROTANG
 9050 FORMAT (1X,'**Misc. Inputs:  Base Elev. for Pot. Temp. Profile ', &
     &        '(m MSL) = ',F8.2,' ;  Decay Coef. = ',G12.4,' ;',        &
     &        '  Rot. Angle = ',F7.1)
      WRITE (IOUNIT,9055) EMILBL(1) , EMIFAC(1) , OUTLBL(1)
 9055 FORMAT (18X,'Emission Units = ',A40,' ;  Emission Rate Unit ',    &
     &        'Factor = ',G13.5,/18X,'Output Units   = ',A40)
      IF ( LUSERVD ) THEN
         WRITE (IOUNIT,9056) USERVD
 9056    FORMAT (18X,'User-Specified Dry Deposition Velocity for Gases '&
     &           ,'(m/s) = ',G13.5)
      ENDIF
 
      IF ( .NOT.EVONLY ) THEN
!        Calculate Allocated Storage Requirements (est.)
         STORE = NSRC*(37+NQF+5*NSEC+8*NPDMAX+2*NVMAX+NWET+NGRP)        &
     &           + NPDMAX*(21+NWET)                                     &
     &           + NREC*(8+NHIVAL*NGRP*NAVE*NTYP*2.25+NGRP*NAVE*NTYP+   &
     &           NGRP*NTYP) + NNET*(9+IXM+IYM)                          &
     &           + NHIVAL*(NGRP*NAVE*NTYP*3.25+NGRP*NTYP*2+NAVE)        &
     &           + NMXVAL*(NGRP*NAVE*NTYP*3.25)                         &
     &           + NAVE*(21+2*NPAIR+12*NHIVAL*NGRP+39*NGRP) + NGRP*55 + &
     &           NTYP*23 + NVMAX*10
         STORE = STORE*4./1.0E6 + 1.2
         WRITE (IOUNIT,9099)
         WRITE (IOUNIT,9057) STORE
 9057    FORMAT (1X,'**Approximate Storage Requirements of Model = ',   &
     &           F7.1,' MB of RAM.')
      ENDIF
 
!     Model I/O Setting Summary
      WRITE (IOUNIT,9099)
      ILMAX = MIN(80,ILEN_FLD)
      IF ( INPFIL.NE.' ' .OR. OUTFIL.NE.' ' ) THEN
         WRITE (IOUNIT,9080) INPFIL(1:ILMAX) , OUTFIL(1:ILMAX)
 9080    FORMAT (1X,'**Input Runstream File:          ',A80,/1X,        &
     &           '**Output Print File:             ',A80)
      ENDIF
      IF ( ERRLST ) WRITE (IOUNIT,9081) MSGFIL(1:ILMAX)
 9081 FORMAT (1X,'**Detailed Error/Message File:   ',A80)
      IF ( EVENTS ) WRITE (IOUNIT,9082) EVFILE(1:ILMAX)
 9082 FORMAT (1X,'**File Created for Event Model:  ',A80)
      IF ( RSTSAV ) WRITE (IOUNIT,9083) SAVFIL(1:ILMAX)
 9083 FORMAT (1X,'**File for Saving Result Arrays: ',A80)
      IF ( RSTINP ) WRITE (IOUNIT,9084) INIFIL(1:ILMAX)
 9084 FORMAT (1X,'**File for Initializing Arrays:  ',A80)
 
      IF ( MULTYR ) THEN
         WRITE (IOUNIT,*) '**This Run is Part of a Multi-year Run.'
         WRITE (IOUNIT,*) '  NOTE:  PERIOD Results Are for Current ' ,  &
     &                    'Period Only.'
         WRITE (IOUNIT,*) '         Short Term Results Are Cumulative' ,&
     &                    ' Across All Years Processed.'
      ENDIF
 
      CONTINUE
 9042 FORMAT (1X,'**Model Calculates ',I2,' Short Term Average(s)',     &
     &        ' of:  ',9(A5,2X,:))
 
 9099 FORMAT (1X,' ')
      END
!*==PRTSRC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRTSRC
!***********************************************************************
!                 PRTSRC Module of the AMS/EPA Regulatory Model - AERMOD
! ----------------------------------------------------------------------
! ---    ISC-PRIME     Version 1.0    Level 970812              Modified
! ---        V. Tino
! ---        Earth Tech, Inc.
!            Prepared for EPRI under contract WO3527-01
! ----------------------------------------------------------------------
!
!        PURPOSE: Print Out The Input Source Data Summary
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION)
!
!        DATE:    November 8, 1993
!
!        MODIFIED by YICHENG ZHUANG, SRC to combine version 93188 with
!                 version 93046 - 9/28/93
!
!        MODIFIED BY D. Strimaitis, SRC (for DEPOSITION) - 2/25/93
!
!*       MODIFIED BY PES (for OPENPIT Source) - 7/22/94
!
!*       MODIFIED BY PES to properly handle page breaks in summary
!*                of sources within a source group - 11/19/98
!
!*       MODIFIED BY R. Brode, PES to include additional building
!                 dimensions for PRIME downwash algorithm - 8/9/01
!
!*       MODIFIED BY R. Brode, MACTEC/PES to include identification
!                 of urban and Method 2 sources - 9/29/03
!
!        INPUTS:  Model Options and Keyword Summarys
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   INPSUM
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K , NL , I1 , I2 , I3 , IFR , IDW , ITO ,      &
     &           INDC , INGRP
      CHARACTER BLDING*3 , URB*3 , IQUN*12
      CHARACTER ATHRUF(6)*1 , SEASON(4)*6 , DAYOFWEEK(3)*8 ,            &
     &          DAYOFWEEK7(7)*8 , CNPD*5
 
!     Variable Initializations
      DATA ATHRUF/'A' , 'B' , 'C' , 'D' , 'E' , 'F'/
      DATA SEASON/'WINTER' , 'SPRING' , 'SUMMER' , ' FALL '/
      DATA DAYOFWEEK/'WEEKDAY ' , 'SATURDAY' , 'SUNDAY  '/
      DATA DAYOFWEEK7/'MONDAY  ' , 'TUESDAY ' , 'WEDNESDY' ,            &
     &     'THURSDAY' , 'FRIDAY  ' , 'SATURDAY' , 'SUNDAY  '/
      MODNAM = 'PRTSRC'
 
      IF ( ISSTAT(8).EQ.0 ) THEN
!        Write Default Emission Rate Units
         IQUN = ' (GRAMS/SEC)'
      ELSE
         IQUN = '(USER UNITS)'
      ENDIF
 
!     Write Out The Point Source Data, If Any
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( SRCTYP(I).EQ.'POINT' ) THEN
            INDC = INDC + 1
            IF ( URBSRC(I).EQ.'Y' ) THEN
               URB = 'YES'
            ELSE
               URB = 'NO'
            ENDIF
            BLDING = 'NO'
            DO J = 1 , NSEC
 
! --- PRIME -------------------------------------------------------
! prm          IF (ADSBH(J,I).NE.0.0 .AND. ADSBW(J,I).NE.0.0) THEN
! -----------------------------------------------------------------
 
               IF ( ADSBH(J,I).NE.0.0 .AND. ADSBW(J,I).NE.0.0 .AND.     &
     &              ADSBL(J,I).NE.0.0 ) BLDING = 'YES'
            ENDDO
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9046) IQUN
 9046          FORMAT (//50X,'*** POINT SOURCE DATA ***'///14X,         &
     &                 'NUMBER EMISSION RATE',20X,                      &
     &                 'BASE     STACK   STACK',4X,                     &
     &               'STACK     STACK    BUILDING  URBAN  EMISSION RATE'&
     &               ,/4X,'SOURCE',5X,'PART. ',A12,5X,'X',8X,'Y',6X,    &
     &               'ELEV.    ','HEIGHT  TEMP.   EXIT VEL. DIAMETER',  &
     &               3X,'EXISTS   SOURCE ',' SCALAR VARY',/4X,          &
     &               '  ID       CATS.              ',1X,               &
     &               2('(METERS) (METERS) '),'(DEG.K) ',' (M/SEC) ',1X, &
     &               '(METERS)',24X,'BY'/65(' -')/)
            ENDIF
            IF ( L_METHOD2(I) ) THEN
               WRITE (CNPD,'("METH2")')
            ELSE
               WRITE (CNPD,'(I4,1X)') INPD(I)
            ENDIF
            WRITE (IOUNIT,9047) SRCID(I) , CNPD , AQS(I) , AXS(I) ,     &
     &                          AYS(I) , AZS(I) , AHS(I) , ATS(I) ,     &
     &                          AVS(I) , ADS(I) , BLDING , URB ,        &
     &                          QFLAG(I)
 9047       FORMAT (3X,A8,3X,A5,2X,E11.5,2F10.1,F8.1,4F9.2,6X,A3,6X,A3, &
     &              4X,A6)
         ENDIF
      ENDDO
 
!     Write Out The Volume Source Data, If Any
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( SRCTYP(I).EQ.'VOLUME' ) THEN
            INDC = INDC + 1
            IF ( URBSRC(I).EQ.'Y' ) THEN
               URB = 'YES'
            ELSE
               URB = 'NO'
            ENDIF
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9074) IQUN
 9074          FORMAT (//50X,'*** VOLUME SOURCE DATA ***'//14X,         &
     &                 'NUMBER EMISSION RATE',20X,                      &
     &                 'BASE    RELEASE    INIT.',4X,                   &
     &                 'INIT.   URBAN  EMISSION RATE',/5X,'SOURCE',4X,  &
     &                 'PART. ',A12,5X,'X',8X,'Y',6X,'ELEV.   ',        &
     &                 'HEIGHT      SY       SZ     SOURCE  SCALAR VARY'&
     &                 ,/4X,'  ID       CATS.              ',1X,        &
     &                 3('(METERS) (METERS) '),13X,'BY'/61(' -')/)
            ENDIF
            WRITE (IOUNIT,9075) SRCID(I) , INPD(I) , AQS(I) , AXS(I) ,  &
     &                          AYS(I) , AZS(I) , AHS(I) , ASYINI(I) ,  &
     &                          ASZINI(I) , URB , QFLAG(I)
 9075       FORMAT (3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,1X,F8.2,1X,   &
     &              F8.2,5X,A3,4X,A6)
         ENDIF
      ENDDO
 
!     Write Out The Area Source Data, If Any
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( SRCTYP(I).EQ.'AREA' ) THEN
            INDC = INDC + 1
            IF ( URBSRC(I).EQ.'Y' ) THEN
               URB = 'YES'
            ELSE
               URB = 'NO'
            ENDIF
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9076) IQUN
 9076          FORMAT (//50X,'*** AREA SOURCE DATA ***'//14X,           &
     &                 'NUMBER EMISSION RATE',2X,'COORD (SW CORNER)',2X,&
     &                 'BASE     RELEASE  X-DIM     Y-DIM    ORIENT.',  &
     &                 4X,'INIT.   URBAN  ','EMISSION RATE',/4X,        &
     &                 'SOURCE',5X,'PART. ',A11,7X,'X',8X,'Y',6X,       &
     &                 'ELEV.    ',                                     &
     &          'HEIGHT  OF AREA   OF AREA   OF AREA     SZ     SOURCE '&
     &          ,' SCALAR VARY',/4X,'  ID       CATS.   /METER**2)  ',  &
     &          1X,2('(METERS) (METERS) '),2('(METERS)',2X),            &
     &          ' (DEG.)  (METERS)',14X,'BY'/66(' -')/)
            ENDIF
            WRITE (IOUNIT,9077) SRCID(I) , INPD(I) , AQS(I) , AXS(I) ,  &
     &                          AYS(I) , AZS(I) , AHS(I) , AXINIT(I) ,  &
     &                          AYINIT(I) , AANGLE(I) , ASZINI(I) ,     &
     &                          URB , QFLAG(I)
 9077       FORMAT (3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,3(1X,F9.2),1X,&
     &              F8.2,5X,A3,4X,A6)
         ENDIF
 
      ENDDO
 
!     Write Out The AREACIRC Source Data, If Any
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( SRCTYP(I).EQ.'AREACIRC' ) THEN
            INDC = INDC + 1
            IF ( URBSRC(I).EQ.'Y' ) THEN
               URB = 'YES'
            ELSE
               URB = 'NO'
            ENDIF
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9078) IQUN
 9078          FORMAT (//48X,'*** AREACIRC SOURCE DATA ***'//14X,       &
     &                 'NUMBER EMISSION RATE',4X,'CENTER OF AREA',3X,   &
     &                 'BASE     RELEASE  RADIUS     NUMBER     INIT.', &
     &                 3X,'URBAN  EMISSION RATE',/4X,'SOURCE',5X,       &
     &                 'PART. ',A11,7X,'X',8X,'Y',6X,'ELEV.    ',       &
     &      'HEIGHT   OF AREA   OF VERTS.    SZ     SOURCE  SCALAR VARY'&
     &      ,/4X,'  ID       CATS.   /METER**2)  ',1X,                  &
     &      2('(METERS) (METERS) '),21X,'(METERS)',14X,'BY'/63(' -')/)
            ENDIF
            WRITE (IOUNIT,9079) SRCID(I) , INPD(I) , AQS(I) , AXS(I) ,  &
     &                          AYS(I) , AZS(I) , AHS(I) , RADIUS(I) ,  &
     &                          NVERTS(I) , ASZINI(I) , URB , QFLAG(I)
 9079       FORMAT (3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,2X,F9.2,4X,I4,&
     &              4X,F8.2,5X,A3,4X,A6)
         ENDIF
      ENDDO
 
!     Write Out The AREAPOLY Source Data, If Any
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( SRCTYP(I).EQ.'AREAPOLY' ) THEN
            INDC = INDC + 1
            IF ( URBSRC(I).EQ.'Y' ) THEN
               URB = 'YES'
            ELSE
               URB = 'NO'
            ENDIF
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9080) IQUN
 9080          FORMAT (//48X,'*** AREAPOLY SOURCE DATA ***'//14X,       &
     &                 'NUMBER EMISSION RATE',3X,'LOCATION OF AREA',2X, &
     &                 'BASE     RELEASE  NUMBER      INIT.',3X,        &
     &                 'URBAN  EMISSION RATE',/4X,'SOURCE',5X,'PART. ', &
     &                 A11,7X,'X',8X,'Y',6X,'ELEV.    ',                &
     &                'HEIGHT  OF VERTS.     SZ     SOURCE  SCALAR VARY'&
     &                ,/4X,'  ID       CATS.   /METER**2)  ',1X,        &
     &                2('(METERS) (METERS) '),11X,                      &
     &                '(METERS)              BY'/63(' -')/)
            ENDIF
            WRITE (IOUNIT,9081) SRCID(I) , INPD(I) , AQS(I) , AXS(I) ,  &
     &                          AYS(I) , AZS(I) , AHS(I) , NVERTS(I) ,  &
     &                          ASZINI(I) , URB , QFLAG(I)
 9081       FORMAT (3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,4X,I4,5X,F8.2,&
     &              5X,A3,4X,A6)
         ENDIF
      ENDDO
 
!*    Write Out The OpenPit Source Data, If Any
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( SRCTYP(I).EQ.'OPENPIT' ) THEN
            INDC = INDC + 1
            IF ( URBSRC(I).EQ.'Y' ) THEN
               URB = 'YES'
            ELSE
               URB = 'NO'
            ENDIF
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9082) IQUN
 9082          FORMAT (//50X,'*** OPENPIT SOURCE DATA ***'//14X,        &
     &                 'NUMBER EMISSION RATE',2X,'COORD (SW CORNER)',2X,&
     &                 'BASE     RELEASE  X-DIM     Y-DIM    ORIENT.',  &
     &                 4X,'VOLUME',3X,'URBAN  EMISSION RATE',/4X,       &
     &                 'SOURCE',5X,'PART. ',A11,7X,'X',8X,'Y',6X,       &
     &                 'ELEV.    ',                                     &
     &                'HEIGHT  OF PIT    OF PIT    OF PIT     OF PIT   '&
     &                ,'SOURCE  SCALAR VARY',/4X,                       &
     &                '  ID       CATS.   /METER**2)  ',1X,             &
     &                2('(METERS) (METERS) '),2('(METERS)',2X),         &
     &                ' (DEG.) ',3X,'(M**3)               BY'/66(' -')/)
            ENDIF
            WRITE (IOUNIT,9083) SRCID(I) , INPD(I) , AQS(I) , AXS(I) ,  &
     &                          AYS(I) , AZS(I) , AHS(I) , AXINIT(I) ,  &
     &                          AYINIT(I) , AANGLE(I) , AVOLUM(I) ,     &
     &                          URB , QFLAG(I)
 9083       FORMAT (3X,A8,2X,I5,3X,E11.5,2F10.1,F8.1,F9.2,3(1X,F9.2),3X,&
     &              E10.5,2X,A3,4X,A6)
         ENDIF
      ENDDO
 
!     Print The Source Group IDs with Source IDs
      INDC = 0
      DO J = 1 , NUMGRP
         INGRP = 0
         DO K = 1 , NUMSRC
            IF ( IGROUP(K,J).EQ.1 ) THEN
               INGRP = INGRP + 1
               WORKID(INGRP) = SRCID(K)
            ENDIF
         ENDDO
!        Determine Number of Lines @ 12/Line
         NL = 1 + INT((INGRP-1)/12)
         DO K = 1 , NL
            INDC = INDC + 1
            IF ( MOD(INDC-1,20).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9058)
 9058          FORMAT (//43X,'*** SOURCE IDs DEFINING SOURCE GROUPS ***'&
     &                 //1X,'GROUP ID',49X,'SOURCE IDs'/)
            ENDIF
            IF ( K.EQ.1 .AND. K.EQ.NL ) THEN
               WRITE (IOUNIT,9068) GRPID(J) , (WORKID(I),I=1,INGRP)
            ELSEIF ( K.EQ.1 .AND. K.NE.NL ) THEN
               WRITE (IOUNIT,9068) GRPID(J) , (WORKID(I),I=1,12*K)
            ELSEIF ( K.EQ.NL ) THEN
               WRITE (IOUNIT,9067) (WORKID(I),I=1+12*(K-1),INGRP)
            ELSE
               WRITE (IOUNIT,9067) (WORKID(I),I=1+12*(K-1),12*K)
            ENDIF
         ENDDO
      ENDDO
 
!     Print The OLM Source Group IDs with Source IDs
      INDC = 0
      DO J = 1 , NUMOLM
         INGRP = 0
         DO K = 1 , NUMSRC
            IF ( IGRP_OLM(K,J).EQ.1 ) THEN
               INGRP = INGRP + 1
               WORKID(INGRP) = SRCID(K)
            ENDIF
         ENDDO
!        Determine Number of Lines @ 12/Line
         NL = 1 + INT((INGRP-1)/12)
         DO K = 1 , NL
            INDC = INDC + 1
            IF ( MOD(INDC-1,20).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9059)
 9059          FORMAT (//41X,                                           &
     &                 '*** SOURCE IDs DEFINING OLM SOURCE GROUPS ***'/ &
     &                 41X,                                             &
     &                 '***        FOR COMBINING PLUMES           ***'/1&
     &                 X,'OLMGRP ID',49X,'SOURCE IDs'/)
            ENDIF
            IF ( K.EQ.1 .AND. K.EQ.NL ) THEN
               WRITE (IOUNIT,9068) OLMID(J) , (WORKID(I),I=1,INGRP)
            ELSEIF ( K.EQ.1 .AND. K.NE.NL ) THEN
               WRITE (IOUNIT,9068) OLMID(J) , (WORKID(I),I=1,12*K)
            ELSEIF ( K.EQ.NL ) THEN
               WRITE (IOUNIT,9067) (WORKID(I),I=1+12*(K-1),INGRP)
            ELSE
               WRITE (IOUNIT,9067) (WORKID(I),I=1+12*(K-1),12*K)
            ENDIF
         ENDDO
      ENDDO
 
!     Print out NO2_RATIO Data for OLM and PVMRM Options
      IF ( OLM .OR. PVMRM ) THEN
         INDC = 0
         DO I = 1 , NUMSRC , 4
            INDC = INDC + 1
            IF ( MOD(INDC-1,40).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9060)
 9060          FORMAT (//39X,                                           &
     &               '*** IN-STACK NO2 RATIOS FOR OLM/PVMRM OPTIONS ***'&
     &               ///1X,4('SOURCE_ID',2X,'NO2_RATIO',8X)/)
            ENDIF
            IF ( I+3.LE.NUMSRC ) THEN
               WRITE (IOUNIT,9061) SRCID(I) , ANO2_RATIO(I) , SRCID(I+1)&
     &                             , ANO2_RATIO(I+1) , SRCID(I+2) ,     &
     &                             ANO2_RATIO(I+2) , SRCID(I+3) ,       &
     &                             ANO2_RATIO(I+3)
            ELSEIF ( I+2.LE.NUMSRC ) THEN
               WRITE (IOUNIT,9061) SRCID(I) , ANO2_RATIO(I) , SRCID(I+1)&
     &                             , ANO2_RATIO(I+1) , SRCID(I+2) ,     &
     &                             ANO2_RATIO(I+2)
            ELSEIF ( I+1.LE.NUMSRC ) THEN
               WRITE (IOUNIT,9061) SRCID(I) , ANO2_RATIO(I) , SRCID(I+1)&
     &                             , ANO2_RATIO(I+1)
            ELSE
               WRITE (IOUNIT,9061) SRCID(I) , ANO2_RATIO(I)
            ENDIF
         ENDDO
      ENDIF
 
!     Print Out Wet or Dry Deposition Information.
      INDC = 0
      DO I = 1 , NUMSRC
         NPD = INPD(I)
         IF ( NPD.NE.0 .AND. .NOT.L_METHOD2(I) ) THEN
            INDC = INDC + 1
            IF ( MOD(INDC-1,3).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9049)
            ENDIF
            WRITE (IOUNIT,9050) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,9051) (APHI(J,I),J=1,NPD)
 9051       FORMAT (/10X,'MASS FRACTION ='/2(10X,10(F9.5,', ')/))
            WRITE (IOUNIT,9052) (APDIAM(J,I),J=1,NPD)
            WRITE (IOUNIT,9053) (APDENS(J,I),J=1,NPD)
         ELSEIF ( NPD.NE.0 .AND. L_METHOD2(I) ) THEN
!           Summarize inputs for Method 2 particle deposition
            INDC = INDC + 1
            IF ( MOD(INDC-1,3).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9049)
            ENDIF
            WRITE (IOUNIT,9050) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,99051) (FINEMASS(I),J=1,NPD)
99051       FORMAT (/10X,                                               &
     &              'FINE PARTICLE MASS FRACTION ='/2(10X,10(F9.5,', ') &
     &              /))
            WRITE (IOUNIT,9052) (APDIAM(J,I),J=1,NPD)
            WRITE (IOUNIT,9053) (APDENS(J,I),J=1,NPD)
         ELSEIF ( TOXICS .AND. (LWGAS .OR. (LDGAS .AND. .NOT.LUSERVD)) )&
     &            THEN
!           Summarize inputs for TOXICS option gas deposition
            INDC = INDC + 1
            IF ( MOD(INDC-1,3).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9049)
            ENDIF
            WRITE (IOUNIT,9050) SRCID(I) , SRCTYP(I)
            IF ( LDGAS ) THEN
               WRITE (IOUNIT,99090) PDIFF(I)
99090          FORMAT (/10X,'DIFF IN AIR (M**2/SEC)     =',2X,E9.2)
               WRITE (IOUNIT,99091) PDIFFW(I)
99091          FORMAT (/10X,'DIFF IN WATER (M**2/SEC)   =',2X,E9.2)
               WRITE (IOUNIT,99093) RCLI(I)
99093          FORMAT (/10X,'LEAF LIPID RESIST (SEC/M)  =',2X,E9.2)
               WRITE (IOUNIT,9094) HENRY(I)
 9094          FORMAT (/10X,'HENRY`S LAW COEFFICIENT    =',2X,E9.2)
            ENDIF
 
         ENDIF
      ENDDO
 
!     Write Out Direction Specific Bldg. Dimensions, If Present
      INDC = 0
      DO I = 1 , NUMSRC
         BLDING = 'NO'
         DO J = 1 , NSEC
 
! --- PRIME ---------------------------------------------------
! prm       IF (ADSBH(J,I).NE.0.0 .AND. ADSBW(J,I).NE.0.0) THEN
! prm - ONLY BLDG DIMENSIONS MUST BE NONZERO HERE!
! -------------------------------------------------------------
 
            IF ( ADSBH(J,I).NE.0.0 .AND. ADSBW(J,I).NE.0.0 .AND.        &
     &           ADSBL(J,I).NE.0.0 ) BLDING = 'YES'
         ENDDO
         IF ( BLDING.EQ.'YES' ) THEN
            INDC = INDC + 1
!           Print Out Direction Specific Bldg. Dimensions
            IF ( MOD(INDC-1,4).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9064)
! prm&       /,6('  IFV   BH     BW  WAK'),/,
! prm&       6(6(2X,I3,F6.1,',',F6.1,',',I2,1X)/)/)
! ------------------------------------------------------------
 
 9064          FORMAT (42X,                                             &
     &                 '*** DIRECTION SPECIFIC BUILDING DIMENSIONS ***'/&
     &                 )
            ENDIF
 
! --- PRIME ----------------------------------------------------------
! prm&           (J,ABS(ADSBH(J,I)),ADSBW(J,I),IDSWAK(J,I), J=1,NSEC)
            WRITE (IOUNIT,9062) SRCID(I) ,                              &
     &                          (J,ABS(ADSBH(J,I)),ADSBW(J,I),ADSBL(J,I)&
     &                          ,ADSXADJ(J,I),ADSYADJ(J,I),J=1,NSEC)
 
! --- PRIME --------------------------------------------------
 9062       FORMAT (/' SOURCE ID: ',A8,/,                               &
     &              2('  IFV    BH      BW      BL     XADJ    YADJ',3X)&
     &              ,/,18(2(2X,I3,5(F7.1,','),2X)/))
! --------------------------------------------------------------------
         ENDIF
      ENDDO
 
!     Print Source Emission Rate Scalars.
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'SEASON' ) THEN
            INDC = INDC + 1
            IF ( MOD(INDC-1,6).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9002)
 
 9002          FORMAT (39X,                                             &
     &            '* SOURCE EMISSION RATE SCALARS WHICH VARY SEASONALLY'&
     &            ,' *'//)
               WRITE (IOUNIT,9004) (SEASON(I1),I1=1,4)
 9004          FORMAT (40X,4(A6,9X)/20X,40('- ')/)
            ENDIF
            WRITE (IOUNIT,9005) SRCID(I) , SRCTYP(I)
 9005       FORMAT (/10X,' SOURCE ID = ',A8,' ;  SOURCE TYPE = ',A8,    &
     &              ' :')
            WRITE (IOUNIT,9006) (QFACT(I1,I),I1=1,4)
 9006       FORMAT (38X,4(E10.5,5X))
         ENDIF
      ENDDO
 
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'MONTH' ) THEN
            INDC = INDC + 1
            IF ( MOD(INDC-1,6).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9007)
 9007          FORMAT (41X,                                             &
     &             '* SOURCE EMISSION RATE SCALARS WHICH VARY MONTHLY *'&
     &             ,//)
               WRITE (IOUNIT,9008)
 9008          FORMAT (7X,                                              &
     &             'JANUARY  FEBRUARY   MARCH     APRIL      MAY       '&
     &             ,                                                    &
     &      'JUNE      JULY     AUGUST   SEPTEMBER  OCTOBER  NOVEMBER  '&
     &      ,'DECEMBER'/)
               WRITE (IOUNIT,9013)
            ENDIF
            WRITE (IOUNIT,9009) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,9010) (QFACT(I1,I),I1=1,12)
 9010       FORMAT (5X,12E10.4)
         ENDIF
      ENDDO
 
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'HROFDY' ) THEN
            INDC = INDC + 1
            IF ( MOD(INDC-1,5).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9011)
 9011          FORMAT (28X,                                             &
     &              '* SOURCE EMISSION RATE SCALARS WHICH VARY FOR EACH'&
     &              ,' HOUR OF THE DAY *'//)
               WRITE (IOUNIT,9012)
               WRITE (IOUNIT,9013)
            ENDIF
            WRITE (IOUNIT,9009) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,9014) (I1,QFACT(I1,I),I1=1,24)
         ENDIF
      ENDDO
 
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'WSPEED' ) THEN
            INDC = INDC + 1
            IF ( MOD(INDC-1,3).EQ.0 ) THEN
               CALL HEADER
               WRITE (IOUNIT,9015)
 9015          FORMAT (20X,                                             &
     &                 '* SOURCE EMISSION RATE SCALARS WHICH VARY WITH',&
     &                 ' STABILITY AND WIND SPEED (STAR) *'//)
               WRITE (IOUNIT,9013)
            ENDIF
            WRITE (IOUNIT,9009) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,9025) (J,J=1,6)
 9025       FORMAT (/26X,6('   WIND SPEED')/26X,6('   CATEGORY',I2))
            WRITE (IOUNIT,9024) (QFACT(I2,I),I2=1,6)
 9024       FORMAT (6X,'STABILITY CATEGORY ',A1,6(1X,E12.5))
         ENDIF
      ENDDO
 
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'SEASHR' ) THEN
            INDC = INDC + 1
            CALL HEADER
            WRITE (IOUNIT,9018)
 9018       FORMAT (22X,'* SOURCE EMISSION RATE SCALARS WHICH VARY',    &
     &              ' SEASONALLY AND DIURNALLY (SEASHR) *'//)
            WRITE (IOUNIT,9012)
            WRITE (IOUNIT,9013)
            WRITE (IOUNIT,9009) SRCID(I) , SRCTYP(I)
            DO I1 = 1 , 4
               IFR = (I1-1)*24
               WRITE (IOUNIT,9019) SEASON(I1)
 9019          FORMAT (59X,'SEASON = ',A6)
               WRITE (IOUNIT,9014) (I2,QFACT(I2+IFR,I),I2=1,24)
            ENDDO
         ENDIF
      ENDDO
 
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'SHRDOW' ) THEN
            INDC = INDC + 1
            CALL HEADER
            WRITE (IOUNIT,99018)
99018       FORMAT (17X,'* SOURCE EMISSION RATE SCALARS WHICH VARY',    &
     &            ' SEASONALLY, DIURNALLY AND BY DAY OF WEEK (SHRDOW) *'&
     &            /)
            WRITE (IOUNIT,99009) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,99012)
            WRITE (IOUNIT,99013)
            DO I1 = 1 , 3
               IDW = (I1-1)*96
               DO I2 = 1 , 4
                  IFR = (I2-1)*24
                  WRITE (IOUNIT,99019) SEASON(I2) , DAYOFWEEK(I1)
                  WRITE (IOUNIT,99014) (I3,QFACT(I3+IFR+IDW,I),I3=1,24)
               ENDDO
            ENDDO
         ENDIF
      ENDDO
 
      INDC = 0
      DO I = 1 , NUMSRC
         IF ( QFLAG(I).EQ.'SHRDOW7' ) THEN
            INDC = INDC + 1
            CALL HEADER
            WRITE (IOUNIT,79018)
79018       FORMAT (17X,'* SOURCE EMISSION RATE SCALARS WHICH VARY',    &
     &           ' SEASONALLY, DIURNALLY AND BY DAY OF WEEK (SHRDOW7) *'&
     &           /)
            WRITE (IOUNIT,99009) SRCID(I) , SRCTYP(I)
            WRITE (IOUNIT,99012)
            WRITE (IOUNIT,99013)
            DO I1 = 1 , 7
               IDW = (I1-1)*96
               DO I2 = 1 , 4
                  IFR = (I2-1)*24
                  WRITE (IOUNIT,99019) SEASON(I2) , DAYOFWEEK7(I1)
                  WRITE (IOUNIT,99014) (I3,QFACT(I3+IFR+IDW,I),I3=1,24)
               ENDDO
            ENDDO
         ENDIF
      ENDDO
 9003 FORMAT (56X,'* FOR ALL SOURCES *'//)
 9017 FORMAT (19X,A1,5X,6(5X,E10.5))
 9085 FORMAT (/10X,'SCAV COEF [LIQ] 1/(S-MM/HR)=',2X,E9.2)
 9086 FORMAT (/10X,'SCAV COEF [ICE] 1/(S-MM/HR)=',2X,E9.2)
 9090 FORMAT (/10X,'MOLECULAR DIFF  (M**2/SEC) =',2X,E9.2)
 9091 FORMAT (/10X,'ALPHA STAR                 =',2X,E9.2)
 9092 FORMAT (/10X,'REACTIVITY PARAMETER       =',2X,E9.2)
 9093 FORMAT (/10X,'MESOPHYLL RESIST (SEC/M)   =',2X,E9.2)
 
      CONTINUE
 9009 FORMAT (/' SOURCE ID = ',A8,' ;  SOURCE TYPE = ',A8,' :')
99009 FORMAT (' SOURCE ID = ',A8,' ;  SOURCE TYPE = ',A8,' :')
 9012 FORMAT (5X,6('HOUR    SCALAR',6X))
99012 FORMAT (2X,8('HOUR   SCALAR',3X))
 9013 FORMAT (1X,65('- ')/)
99013 FORMAT (1X,65('- '))
 9014 FORMAT (4(5X,6(I3,3X,E10.5,4X)/))
99014 FORMAT (2(3X,8(I2,2X,E9.4,3X)/),3X,8(I2,2X,E9.4,3X))
99019 FORMAT (46X,'SEASON = ',A6,';  DAY OF WEEK = ',A8)
 9049 FORMAT (48X,'*** SOURCE PARTICULATE/GAS DATA ***'//)
 9050 FORMAT (//10X,'*** SOURCE ID = ',A8,'; SOURCE TYPE = ',A8,' ***')
 9052 FORMAT (/10X,'PARTICLE DIAMETER (MICRONS) ='/2(10X,10(F9.5,', ')/)&
     &        )
 9053 FORMAT (/10X,'PARTICLE DENSITY (G/CM**3)  ='/2(10X,10(F9.5,', ')/)&
     &        )
 9061 FORMAT (1X,4(A8,3X,F7.3,10X))
 9068 FORMAT (//2X,A8,1X,12(1X,A8,','))
 9067 FORMAT (/11X,12(1X,A8,','))
      END
!*==PRTREC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PRTREC
!***********************************************************************
!                 PRTREC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Print Out The Receptor Network Values
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To remove reference to Boundary
!                    Receptors - 4/1/2004
!
!        MODIFIED:   To Adjust Format Statement 9082 for Boundary
!                    Receptors - 9/29/92
!
!        INPUTS:  Arrays of Source Parameters
!                 Arrays of Receptor Locations
!                 Arrays of Model Results
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   INPSUM
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K , INDZ , NX , NY , INDC , ISRF
      REAL :: YCOVAL , XRMS , YRMS , RANGE , RADIAL
      CHARACTER BUF132*132
 
!     Variable Initializations
      MODNAM = 'PRTREC'
 
      DO I = 1 , INNET
         CALL HEADER
         WRITE (IOUNIT,9034)
 9034    FORMAT (/40X,'*** GRIDDED RECEPTOR NETWORK SUMMARY ***')
         WRITE (IOUNIT,9037) NTID(I) , NTTYP(I)
         IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
            WRITE (IOUNIT,9038)
 9038       FORMAT (/42X,'*** X-COORDINATES OF GRID ***'/52X,           &
     &              '(METERS)'/)
         ELSE
            WRITE (IOUNIT,9036) XORIG(I) , YORIG(I)
 9036       FORMAT (/42X,'*** ORIGIN FOR POLAR NETWORK ***'/,32X,       &
     &              'X-ORIG =',F10.2,' ;   Y-ORIG = ',F10.2,            &
     &              '  (METERS)')
            WRITE (IOUNIT,9039)
 9039       FORMAT (/42X,'*** DISTANCE RANGES OF NETWORK ***'/52X,      &
     &              '(METERS)'/)
         ENDIF
         WRITE (IOUNIT,9040) (XCOORD(J,I),J=1,NUMXPT(I))
         IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
            WRITE (IOUNIT,9041)
 9041       FORMAT (/42X,'*** Y-COORDINATES OF GRID *** ',/52X,         &
     &              '(METERS)'/)
         ELSE
            WRITE (IOUNIT,9042)
 9042       FORMAT (/42X,'*** DIRECTION RADIALS OF NETWORK *** ',/52X,  &
     &              '(DEGREES)'/)
         ENDIF
         WRITE (IOUNIT,9040) (YCOORD(J,I),J=1,NUMYPT(I))
         IF ( ELEV ) THEN
!           Print Terrain Heights for Network
!           Set Number of Columns Per Page, NCPP
            NCPP = 9
!           Set Number of Rows Per Page, NRPP
            NRPP = 40
!           Begin LOOP Through Networks
!           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1 , NPPX
               DO NY = 1 , NPPY
                  CALL HEADER
                  WRITE (IOUNIT,9037) NTID(I) , NTTYP(I)
                  WRITE (IOUNIT,9011)
 
 9011             FORMAT (/48X,'* ELEVATION HEIGHTS IN METERS *'/)
                  IF ( NX.EQ.NPPX ) THEN
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ENDIF
                  ELSE
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ENDIF
                  ENDIF
                  WRITE (IOUNIT,9010)
                  IF ( NY.EQ.NPPY ) THEN
                     DO K = 1 + NRPP*(NY-1) , NUMYPT(I)
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NCPP*NX)
                        ENDIF
                     ENDDO
                  ELSE
                     DO K = 1 + NRPP*(NY-1) , NRPP*NY
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZELEV(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NCPP*NX)
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
            ENDDO
!           Print Hill Height Scales for Network
!           Set Number of Columns Per Page, NCPP
            NCPP = 9
!           Set Number of Rows Per Page, NRPP
            NRPP = 40
!           Begin LOOP Through Networks
!           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1 , NPPX
               DO NY = 1 , NPPY
                  CALL HEADER
                  WRITE (IOUNIT,9037) NTID(I) , NTTYP(I)
                  WRITE (IOUNIT,9012)
 9012             FORMAT (/48X,'* HILL HEIGHT SCALES IN METERS *'/)
                  IF ( NX.EQ.NPPX ) THEN
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ENDIF
                  ELSE
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ENDIF
                  ENDIF
                  WRITE (IOUNIT,9010)
                  IF ( NY.EQ.NPPY ) THEN
                     DO K = 1 + NRPP*(NY-1) , NUMYPT(I)
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZHILL(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZHILL(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NCPP*NX)
                        ENDIF
                     ENDDO
                  ELSE
                     DO K = 1 + NRPP*(NY-1) , NRPP*NY
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZHILL(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZHILL(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NCPP*NX)
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
            ENDDO
         ENDIF
         IF ( FLGPOL ) THEN
!           Print The Receptor Heights Above Ground for This Network
!           Set Number of Columns Per Page, NCPP
            NCPP = 9
!           Set Number of Rows Per Page, NRPP
            NRPP = 40
!           Begin LOOP Through Networks
!           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO NX = 1 , NPPX
               DO NY = 1 , NPPY
                  CALL HEADER
                  WRITE (IOUNIT,9037) NTID(I) , NTTYP(I)
                  WRITE (IOUNIT,9035)
 9035             FORMAT (/44X,'* RECEPTOR FLAGPOLE HEIGHTS IN METERS *'&
     &                    /)
                  IF ( NX.EQ.NPPX ) THEN
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NUMXPT(I))
                     ENDIF
                  ELSE
                     IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                        WRITE (IOUNIT,9016)
                        WRITE (IOUNIT,9017)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                        WRITE (IOUNIT,9018)
                        WRITE (IOUNIT,9019)                             &
     &                         (XCOORD(J,I),J=1+NCPP*(NX-1),NCPP*NX)
                     ENDIF
                  ENDIF
                  WRITE (IOUNIT,9010)
                  IF ( NY.EQ.NPPY ) THEN
                     DO K = 1 + NRPP*(NY-1) , NUMYPT(I)
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NCPP*NX)
                        ENDIF
                     ENDDO
                  ELSE
                     DO K = 1 + NRPP*(NY-1) , NRPP*NY
                        IF ( NTTYP(I).EQ.'GRIDCART' ) THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSEIF ( NTTYP(I).EQ.'GRIDPOLR' ) THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        ENDIF
                        IF ( NX.EQ.NPPX ) THEN
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NUMXPT(I))
                        ELSE
                           WRITE (IOUNIT,9013) YCOVAL ,                 &
     &                            (AZFLAG(INDZ+J-1),J=1+NCPP*(NX-1),    &
     &                            NCPP*NX)
                        ENDIF
                     ENDDO
                  ENDIF
               ENDDO
            ENDDO
         ENDIF
      ENDDO
 
      IF ( IRSTAT(4).NE.0 .OR. IRSTAT(8).NE.0 ) THEN
!RWB     Include EVALCART receptors with DISCCART receptors.  2/14/95
!        Print Out The Coordinates, Height , Hill Height & Flags For
!        Discrete Cart Receptors
 
         INDC = 0
         DO I = 1 , NUMREC
            IF ( RECTYP(I).EQ.'DC' ) THEN
               INDC = INDC + 1
               IF ( MOD(INDC-1,90).EQ.0 ) THEN
                  CALL HEADER
                  WRITE (IOUNIT,9043)
 9043             FORMAT (/45X,'*** DISCRETE CARTESIAN RECEPTORS ***',  &
     &                    /43X,'(X-COORD, Y-COORD, ZELEV, ZHILL, ZFLAG)'&
     &                    ,/45X,'              (METERS)'/)
               ENDIF
               IF ( MOD(INDC,2).NE.0 ) THEN
                  WRITE (BUF132(1:65),9045) AXR(I) , AYR(I) , AZELEV(I) &
     &                   , AZHILL(I) , AZFLAG(I)
               ELSE
                  WRITE (BUF132(66:130),9045) AXR(I) , AYR(I) ,         &
     &                   AZELEV(I) , AZHILL(I) , AZFLAG(I)
                  WRITE (IOUNIT,9090) BUF132
                  WRITE (BUF132,9095)
               ENDIF
            ENDIF
         ENDDO
         IF ( MOD(INDC,2).NE.0 ) THEN
            WRITE (IOUNIT,9090) BUF132
            WRITE (BUF132,9095)
         ENDIF
      ENDIF
 
      IF ( IRSTAT(5).NE.0 ) THEN
!        Print Out The Coordinates, Height & Flags For Discrete Polar Receptors
         INDC = 0
         DO I = 1 , NUMREC
            IF ( RECTYP(I).EQ.'DP' ) THEN
               INDC = INDC + 1
               XRMS = AXR(I) - AXS(IREF(I))
               YRMS = AYR(I) - AYS(IREF(I))
               RANGE = SQRT(XRMS*XRMS+YRMS*YRMS)
               RADIAL = ATAN2(XRMS,YRMS)*RTODEG
               IF ( RADIAL.LE.0.0 ) RADIAL = RADIAL + 360.
               IF ( MOD(INDC-1,90).EQ.0 ) THEN
                  CALL HEADER
                  WRITE (IOUNIT,9044)
 9044             FORMAT (/43X,'    *** DISCRETE POLAR RECEPTORS ***',  &
     &                    /43X,                                         &
     &                    ' ORIGIN: (DIST, DIR, ZELEV, ZHILL, ZFLAG)',  &
     &                    /43X,                                         &
     &                    ' SRCID: (METERS,DEG,METERS,METERS,METERS)'/)
               ENDIF
               IF ( MOD(INDC,2).NE.0 ) THEN
                  WRITE (BUF132(1:65),9047) SRCID(IREF(I)) , RANGE ,    &
     &                   RADIAL , AZELEV(I) , AZHILL(I) , AZFLAG(I)
               ELSE
                  WRITE (BUF132(66:130),9047) SRCID(IREF(I)) , RANGE ,  &
     &                   RADIAL , AZELEV(I) , AZHILL(I) , AZFLAG(I)
                  WRITE (IOUNIT,9090) BUF132
                  WRITE (BUF132,9095)
               ENDIF
            ENDIF
         ENDDO
         IF ( MOD(INDC,2).NE.0 ) THEN
            WRITE (IOUNIT,9090) BUF132
            WRITE (BUF132,9095)
         ENDIF
      ENDIF
 
      CONTINUE
 9037 FORMAT (/34X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',A8,' ***')
 9040 FORMAT (100(5X,10(F10.1,',')/))
 9010 FORMAT (66(' -')/)
 9013 FORMAT (2X,F10.2,1X,'|',1X,9(1X,F12.2,:))
 9016 FORMAT (3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT (3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT (3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT (3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9045 FORMAT (4X,' (',4(F9.1,', '),F9.1,'); ')
 9047 FORMAT (3X,A8,': (',F9.1,', ',3(F7.1,', '),F7.1,'); ')
 9090 FORMAT (A132)
 9095 FORMAT (132(' '))
      END
!*==CHKREC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CHKREC
!***********************************************************************
!                 CHKREC Module of the AMS/EPA Regulatory Model - AERMOD
! ----------------------------------------------------------------------
! ---    ISC-PRIME     Version 1.0    Level 970812              Modified
! ---        D. Strimaitis
! ---        Earth Tech, Inc.
!            Prepared for EPRI under contract WO3527-01
! ----------------------------------------------------------------------
!
!        PURPOSE: Print Out The Input Met Data Summary and Source Groups
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To account for new area source algorithm, which
!                    allows for receptors located within the area - 7/7/93
!
!        MODIFIED:   To account for OpenPit Source - PES - 7/22/94
!
!        INPUTS:  Source and Receptor Inputs
!
!        OUTPUTS: Listing of Receptors Too Close To Sources
!
!        CALLED FROM:   INPSUM
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: INC , ISEC , INOUT
      REAL :: DIST , ANG , XMIN , XVM(5) , YVM(5)
 
!     Variable Initializations
      MODNAM = 'CHKREC'
      INC = 0
 
!     Begin Source LOOP
      DO ISRC = 1 , NUMSRC
 
!        Set Effective Source Radius Based on Source Type
         IF ( SRCTYP(ISRC).EQ.'POINT' ) THEN
            XRAD = 0.0
         ELSEIF ( SRCTYP(ISRC).EQ.'VOLUME' ) THEN
            XRAD = 2.15*ASYINI(ISRC)
         ELSEIF ( SRCTYP(ISRC).EQ.'AREA' .OR. SRCTYP(ISRC)              &
     &            .EQ.'AREAPOLY' .OR. SRCTYP(ISRC).EQ.'AREACIRC' ) THEN
!           Cycle to Next Source for AREA Sources - No Restrictions on
!           Receptor Placement for New Algorithm
            GOTO 100
         ELSEIF ( SRCTYP(ISRC).EQ.'OPENPIT' ) THEN
            XRAD = -1.0
            XVM(1) = AXVERT(1,ISRC)
            XVM(2) = AXVERT(2,ISRC)
            XVM(3) = AXVERT(3,ISRC)
            XVM(4) = AXVERT(4,ISRC)
            XVM(5) = AXVERT(5,ISRC)
            YVM(1) = AYVERT(1,ISRC)
            YVM(2) = AYVERT(2,ISRC)
            YVM(3) = AYVERT(3,ISRC)
            YVM(4) = AYVERT(4,ISRC)
            YVM(5) = AYVERT(5,ISRC)
         ENDIF
 
!        Begin Receptor LOOP
         DO IREC = 1 , NUMREC
 
!           Calculate DIST From Edge of Source to Receptor
            X = AXR(IREC) - AXS(ISRC)
            Y = AYR(IREC) - AYS(ISRC)
            DIST = SQRT(X*X+Y*Y) - XRAD
 
            IF ( DIST.LT.0.99 ) THEN
!              Receptor Is Too Close To Source
               INC = INC + 1
               IF ( MOD((INC-1),40).EQ.0 ) THEN
                  CALL HEADER
                  WRITE (IOUNIT,9002)
               ENDIF
               WRITE (IOUNIT,9003) SRCID(ISRC) , AXR(IREC) , AYR(IREC) ,&
     &                             DIST
 9003          FORMAT (31X,A8,5X,F13.1,1X,F13.1,7X,F10.2)
 
! --- PRIME --------------------------------------------------------
! --- Drop check for receptors in cavity because PRIME includes
! --- module for concentrations in the cavity
!
!            ELSE IF (SRCTYP(ISRC) .EQ. 'POINT') THEN
!C              Check For Receptors Less Than 3*ZLB For POINT Sources
!               ANG = ATAN2(X,Y) * RTODEG
!               IF (ANG .LT. 0.0) ANG = ANG + 360.0
!               ISEC = INT(ANG*0.10 + 0.4999)
!               IF (ISEC .EQ. 0) ISEC = 36
!               IF (ISEC .LE. NSEC) THEN
!                  DSBH = ADSBH(ISEC,ISRC)
!                  DSBW = ADSBW(ISEC,ISRC)
!                  XMIN = 3.*AMIN1(DSBH,DSBW)
!                  IF (DIST .LT. XMIN) THEN
!C                    Receptor Is Too Close To Source
!                     INC = INC + 1
!                     IF (MOD((INC-1), 40) .EQ. 0) THEN
!                        CALL HEADER
!                        WRITE(IOUNIT,9002)
!                     END IF
!                     WRITE(IOUNIT,9003) SRCID(ISRC), AXR(IREC),
!     &                                  AYR(IREC), DIST
!                  END IF
!               END IF
! ------------------------------------------------------------------
 
            ELSEIF ( SRCTYP(ISRC).EQ.'OPENPIT' ) THEN
!              Check for receptors within boundary of an open pit source
               XR = AXR(IREC)
               YR = AYR(IREC)
               CALL PNPOLY(XR,YR,XVM,YVM,5,INOUT)
               IF ( INOUT.GT.0 ) THEN
!                 Receptor is within boundary
                  INC = INC + 1
                  IF ( MOD((INC-1),40).EQ.0 ) THEN
                     CALL HEADER
                     WRITE (IOUNIT,9002)
                  ENDIF
                  WRITE (IOUNIT,9004) SRCID(ISRC) , AXR(IREC) ,         &
     &                                AYR(IREC)
 9004             FORMAT (31X,A8,5X,F13.1,1X,F13.1,7X,'   OPENPIT')
               ENDIF
            ENDIF
 
         ENDDO
!        End Receptor LOOP
 
 100  ENDDO
 
      CONTINUE
!     End Source LOOP
 
! --- PRIME ---------------------------------------------------------
! prm& ' OR 3*ZLB IN DISTANCE, OR WITHIN OPEN PIT SOURCE',//
! -------------------------------------------------------------------
 9002 FORMAT (22X,'* SOURCE-RECEPTOR COMBINATIONS FOR WHICH ',          &
     &        'CALCULATIONS MAY NOT BE PERFORMED *'/27X,                &
     &        'LESS THAN 1.0 METER',' OR WITHIN OPEN PIT SOURCE',///31X,&
     &        'SOURCE',9X,'- - RECEPTOR LOCATION - -',9X,'DISTANCE',    &
     &        /31X,'  ID  ',9X,'XR (METERS)   YR (METERS)',9X,          &
     &        '(METERS)',/30X,30('- ')/)
      END
!*==PRTMET.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRTMET
!***********************************************************************
!                 PRTMET Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Print Out The Input Met Data Summary and Source Groups
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To output 4-digit start year and end year for
!                    Y2K compliance.
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Model Options and Keyword Summarys
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   INPSUM
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K
 
!     Variable Initializations
      MODNAM = 'PRTMET'
 
!     Start New Page and Print The Titles
      CALL HEADER
 
!     Print The Meteorology Data Date Array.
      WRITE (IOUNIT,9037) (IPROC(I),I=1,366)
 9037 FORMAT (/44X,'*** METEOROLOGICAL DAYS SELECTED FOR PROCESSING ***'&
     &        /63X,'(1=YES; 0=NO)'//8(11X,5(10I2,2X)/))
 
      IF ( ISDATE.NE.0 .OR. IEDATE.NE.2147123124 ) THEN
!        Write Out User-specified Start and End Dates
         WRITE (IOUNIT,9038) ISYR , ISMN , ISDY , ISHR , IEYR , IEMN ,  &
     &                       IEDY , IEHR
 9038    FORMAT (/23X,                                                  &
     &           'METEOROLOGICAL DATA PROCESSED BETWEEN START DATE: ',  &
     &           I4,1X,3I3,/59X,'AND END DATE: ',I4,1X,3I3)
      ENDIF
 
      WRITE (IOUNIT,9039)
 9039 FORMAT (/16X,'NOTE:  METEOROLOGICAL DATA ACTUALLY PROCESSED WILL',&
     &        ' ALSO DEPEND ON WHAT IS INCLUDED IN THE DATA FILE.'/)
 
!     Print the upper bound of the first 5 wind speed categories
      WRITE (IOUNIT,9001) (UCAT(I),I=1,5)
 
 9001 FORMAT (//34X,'*** UPPER BOUND OF FIRST THROUGH FIFTH WIND SPEED',&
     &        ' CATEGORIES ***'/60X,'(METERS/SEC)'//46X,5(F7.2,','))
 
      CONTINUE
      END
!*==RSINIT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE RSINIT
!***********************************************************************
!                 RSINIT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Initialize Results Variables for Restart
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   Added arrays associated with post-1997 PM10
!                    processing.
!                    R.W. Brode, PES, Inc.,  5/12/99
!
!        MODIFIED:   Changed parameter for specifying the number of
!                    high annual/period averages from NVAL to NHIANN.
!                    R.W. Brode, PES, Inc.,  4/3/98
!
!        INPUTS:  None
!
!        OUTPUTS: Initialized Variables
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K , L , M
 
!     Variable Initializations
      MODNAM = 'RSINIT'
 
      READ (IRSUNT,ERR=99,END=999) ISDATE
      READ (IRSUNT,ERR=99,END=999) NHIVAL , NMXVAL , NUMREC , NUMGRP ,  &
     &                             NUMAVE , NUMTYP
 
      IF ( NHIVAL.GT.0 ) THEN
         READ (IRSUNT,ERR=99,END=999) (((((HIVALU(I,J,K,L,M),I=1,NUMREC)&
     &                                ,J=1,NHIVAL),K=1,NUMGRP),L=1,     &
     &                                NUMAVE),M=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) (((((NHIDAT(I,J,K,L,M),I=1,NUMREC)&
     &                                ,J=1,NHIVAL),K=1,NUMGRP),L=1,     &
     &                                NUMAVE),M=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) (((((HCLMSG(I,J,K,L,M),I=1,NUMREC)&
     &                                ,J=1,NHIVAL),K=1,NUMGRP),L=1,     &
     &                                NUMAVE),M=1,NUMTYP)
 
         IF ( PM10AVE ) THEN
            READ (IRSUNT,ERR=99,END=999) NUMYRS
            READ (IRSUNT,ERR=99,END=999)                                &
     &            ((SUMH4H(I,J),I=1,NUMREC),J=1,NUMGRP)
         ENDIF
 
      ENDIF
 
      IF ( NMXVAL.GT.0 ) THEN
         READ (IRSUNT,ERR=99,END=999) ((((RMXVAL(I,J,K,L),I=1,NMXVAL),J=&
     &                                1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) ((((MXDATE(I,J,K,L),I=1,NMXVAL),J=&
     &                                1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) ((((MXLOCA(I,J,K,L),I=1,NMXVAL),J=&
     &                                1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) ((((MCLMSG(I,J,K,L),I=1,NMXVAL),J=&
     &                                1,NUMGRP),K=1,NUMAVE),L=1,NUMTYP)
      ENDIF
 
      IF ( SEASONHR ) THEN
!        Initialize the SEASON by HOUR-OF-DAY Arrays
         READ (IRSUNT,ERR=99,END=999) (((((SHVALS(I,J,K,L,M),I=1,NUMREC)&
     &                                ,J=1,NUMGRP),K=1,4),L=1,24),M=1,  &
     &                                NUMTYP)
         READ (IRSUNT,ERR=99,END=999) ((NSEAHR(I,J),I=1,4),J=1,24)
         READ (IRSUNT,ERR=99,END=999) ((NSEACM(I,J),I=1,4),J=1,24)
      ENDIF
 
      IF ( PERIOD ) THEN
         READ (IRSUNT,ERR=99,END=999) IANHRS , IANCLM , IANMSG
         READ (IRSUNT,ERR=99,END=999) (((ANNVAL(I,J,K),I=1,NUMREC),J=1, &
     &                                NUMGRP),K=1,NUMTYP)
      ELSEIF ( ANNUAL ) THEN
         READ (IRSUNT,ERR=99,END=999) IANHRS , IANCLM , IANMSG , NUMYRS
         READ (IRSUNT,ERR=99,END=999) (((ANNVAL(I,J,K),I=1,NUMREC),J=1, &
     &                                NUMGRP),K=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) (((SUMANN(I,J,K),I=1,NUMREC),J=1, &
     &                                NUMGRP),K=1,NUMTYP)
      ENDIF
 
      IF ( MULTYR .AND. PERIOD ) THEN
!        Reinitialize the ANNVAL Array and Annual Counters
         DO K = 1 , NUMTYP
            DO J = 1 , NUMGRP
               DO I = 1 , NUMREC
                  ANNVAL(I,J,K) = 0.0
               ENDDO
            ENDDO
         ENDDO
         IANHRS = 0
         IANCLM = 0
         IANMSG = 0
!        Read the Maximum Annual Values
         READ (IRSUNT,ERR=99,END=999) (((AMXVAL(I,J,K),I=1,NHIANN),J=1, &
     &                                NUMGRP),K=1,NUMTYP)
         READ (IRSUNT,ERR=99,END=999) (((IMXLOC(I,J,K),I=1,NHIANN),J=1, &
     &                                NUMGRP),K=1,NUMTYP)
      ENDIF
 
      GOTO 1000
 
!     WRITE Error Message:  Error Reading INITFILE
 99   DUMMY = 'INITFILE'
      CALL ERRHDL(PATH,MODNAM,'E','510',DUMMY)
      RUNERR = .TRUE.
      GOTO 1000
 
!     WRITE Error Message:  End of File Reached for INITFILE
 999  DUMMY = 'INITFILE'
      CALL ERRHDL(PATH,MODNAM,'E','580',DUMMY)
      RUNERR = .TRUE.
 
 1000 CONTINUE
      END
!*==RESINI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE RESINI
!***********************************************************************
!                 RESINI Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Initialize Results Variables With Zeroes
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   Added results arrays for post-1997 PM10 processing
!                    option.  Also replaced labeled DO loop terminators
!                    with unlabeled END DO statements.
!                    R.W. Brode, PES, Inc.,  11/19/98
!
!        MODIFIED:   Changed parameter for specifying the number of
!                    high annual/period averages from NVAL to NHIANN.
!                    R.W. Brode, PES, Inc.,  4/3/98
!
!        INPUTS:  None
!
!        OUTPUTS: Initialized Variables
!
!        CALLED FROM:   MAIN
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , K , L , M
 
!     Variable Initializations
      MODNAM = 'RESINI'
 
!     Initialize the Results Arrays
      DO M = 1 , NUMTYP
         HRVAL(M) = 0.0
         DO L = 1 , NUMAVE
            NUMHRS(L) = 0
            NUMCLM(L) = 0
            NUMMSG(L) = 0
            DO K = 1 , NUMGRP
               DO J = 1 , NUMREC
                  AVEVAL(J,K,L,M) = 0.0
                  DO I = 1 , NHIVAL
                     HIVALU(J,I,K,L,M) = 0.0
                     NHIDAT(J,I,K,L,M) = 0
                     HCLMSG(J,I,K,L,M) = ' '
                     HMAX(I,K,L,M) = 0.0
                     HMDATE(I,K,L,M) = 0
                     HMLOC(I,K,L,M) = 0
                     HMCLM(I,K,L,M) = ' '
                  ENDDO
               ENDDO
               DO J = 1 , NMXVAL
                  RMXVAL(J,K,L,M) = 0.0
                  MXDATE(J,K,L,M) = 0
                  MXLOCA(J,K,L,M) = 0
                  MCLMSG(J,K,L,M) = ' '
               ENDDO
            ENDDO
         ENDDO
      ENDDO
      IANHRS = 0
      IANCLM = 0
      IANMSG = 0
 
!     The following were added as part of implementing the SCIM option
      NSKIPTOT = 0
      NSKIPWET = 0
      NSKIPDRY = 0
      NSWETCLM = 0
      NSDRYCLM = 0
      IANWET = 0
      IWETCLM = 0
      IWETMSG = 0
      NWETHR = 0
 
      DO K = 1 , NUMTYP
         DO J = 1 , NUMGRP
            DO I = 1 , NUMREC
               ANNVAL(I,J,K) = 0.0
               SUMANN(I,J,K) = 0.0
            ENDDO
            DO I = 1 , NHIANN
               AMXVAL(I,J,K) = 0.0
               IMXLOC(I,J,K) = 0
            ENDDO
         ENDDO
      ENDDO
 
!     Initialize results array for post-1997 PM10 processing
      DO J = 1 , NUMGRP
         DO I = 1 , NUMREC
            SUMH4H(I,J) = 0.0
         ENDDO
         DO I = 1 , NMXPM
            MXPMVAL(I,J) = 0.0
            MXPMLOC(I,J) = 0
         ENDDO
      ENDDO
 
!     Initialize results arrays for SEASONHR option
      DO M = 1 , NUMTYP
         DO L = 1 , 24
            DO K = 1 , 4
               DO J = 1 , NUMGRP
                  DO I = 1 , NUMREC
 
                     SHVALS(I,J,K,L,M) = 0.0
 
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
      ENDDO
 
      DO J = 1 , 24
         DO I = 1 , 4
 
            NSEAHR(I,J) = 0
            NSEACM(I,J) = 0
 
         ENDDO
      ENDDO
 
      CONTINUE
      END
!*==MECARD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE MECARD
!***********************************************************************
!                 MECARD Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To process MEteorology Pathway Card Images
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To remove support for unformatted meteorological
!                    data files.
!                    R.W. Brode, PES, Inc., 4/10/2000
!
!        MODIFIED:  To Include TOXXFILE Option - 9/29/92
!
!        INPUTS:  Pathway (ME) and Keyword
!
!        OUTPUTS: Meteorology Option Switches
!                 Meteorology Setup Status Switches
!
!        CALLED FROM:   SETUP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , ND , NDYS
 
!     Variable Initializations
      MODNAM = 'MECARD'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Set Status Switch
         IMSTAT(1) = IMSTAT(1) + 1
!           WRITE Error Message: Non-repeatable Keyword
         IF ( IMSTAT(1).NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
 
      ELSEIF ( KEYWRD.EQ.'SURFFILE' ) THEN
!        Set Status Switch
         IMSTAT(2) = IMSTAT(2) + 1
         IF ( IMSTAT(2).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Surface Meteorology File Information    ---   CALL SURFIL
            CALL SURFIL
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'PROFFILE' ) THEN
!        Set Status Switch
         IMSTAT(3) = IMSTAT(3) + 1
         IF ( IMSTAT(3).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Profile Meteorology File Information    ---   CALL PROFIL
            CALL PROFIL
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'SURFDATA' ) THEN
!        Set Status Switch
         IMSTAT(4) = IMSTAT(4) + 1
         IF ( IMSTAT(4).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Surface Data Information                ---   CALL SFDATA
            CALL SFDATA
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'UAIRDATA' ) THEN
!        Set Status Switch
         IMSTAT(5) = IMSTAT(5) + 1
         IF ( IMSTAT(5).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Upper Air Data Information              ---   CALL UADATA
            CALL UADATA
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'STARTEND' ) THEN
!        Set Status Switch
         IMSTAT(6) = IMSTAT(6) + 1
         IF ( SCIM ) THEN
!           Write out error message:  STARTEND cannot be used with SCIM option
            CALL ERRHDL(PATH,MODNAM,'E','154',KEYWRD)
         ELSE
            IF ( IMSTAT(6).NE.1 ) THEN
!              WRITE Error Message: Non-repeatable Keyword
               CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
            ELSE
!              Process Start and End Dates for Reading      ---   CALL STAEND
               CALL STAEND
            ENDIF
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'DAYRANGE' ) THEN
!        Set Status Switch
         IMSTAT(7) = IMSTAT(7) + 1
         IF ( SCIM ) THEN
!           Write out error message:  DAYRANGE cannot be used with SCIM option
            CALL ERRHDL(PATH,MODNAM,'E','154',KEYWRD)
         ELSE
!           Check for First Occurrence of DAYRANGE Card, and
!           Reinitialize IPROC Array
            IF ( IMSTAT(7).EQ.1 ) THEN
               DO I = 1 , 366
                  IPROC(I) = 0
               ENDDO
            ENDIF
!           Process Days and Day Ranges for Processing      ---   CALL DAYRNG
            CALL DAYRNG
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'WDROTATE' ) THEN
!        Set Status Switch
         IMSTAT(8) = IMSTAT(8) + 1
         IF ( IMSTAT(8).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Wind Direction Correction Option        ---   CALL WDROTA
            CALL WDROTA
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'SITEDATA' ) THEN
!        Set Status Switch
         IMSTAT(9) = IMSTAT(9) + 1
         IF ( IMSTAT(9).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process On-site Data Information                ---   CALL ONDATA
            CALL ONDATA
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'PROFBASE' ) THEN
!        Set Status Switch
         IMSTAT(10) = IMSTAT(10) + 1
         IF ( IMSTAT(10).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process On-site Data Information                ---   CALL PRBASE
            CALL PRBASE
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'WINDCATS' ) THEN
!        Set Status Switch
         IMSTAT(11) = IMSTAT(11) + 1
         IF ( IMSTAT(11).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Wind Speed Categories                   ---   CALL WSCATS
            CALL WSCATS
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'SCIMBYHR' .AND. SCIM ) THEN
!        Set Status Switch
         IMSTAT(12) = IMSTAT(12) + 1
         IF ( IMSTAT(12).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
!           Process Wind Speed Categories                   ---   CALL SCIMIT
            CALL SCIMIT
         ENDIF
 
      ELSEIF ( KEYWRD.EQ.'FINISHED' ) THEN
!        Set Status Switch
         IMSTAT(25) = IMSTAT(25) + 1
         IF ( IMSTAT(25).NE.1 ) THEN
!           WRITE Error Message: Non-repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
            GOTO 999
         ENDIF
!        Write Error Messages for Missing Mandatory Keyword(s)
         IF ( IMSTAT(1).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         IF ( IMSTAT(2).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','SURFFILE')
         IF ( IMSTAT(3).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','PROFFILE')
         IF ( IMSTAT(5).EQ.0 )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','UAIRDATA')
         IF ( IMSTAT(10).EQ.0 )                                         &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','PROFBASE')
         IF ( SCIM .AND. IMSTAT(12).EQ.0 )                              &
     &         CALL ERRHDL(PATH,MODNAM,'E','130','SCIMBYHR')
 
!        OPEN Met Data File                                 ---   CALL MEOPEN
         IF ( IMSTAT(2).NE.0 .AND. IMSTAT(3).NE.0 ) CALL MEOPEN
 
         IF ( MULTYR ) THEN
!           Set the Increment for Saving Results, INCRST, Based on
!           ISYEAR, Surface Data Year, from SURFDATA Keyword
            IF ( (MOD(ISYEAR,4).NE.0) .OR.                              &
     &           (MOD(ISYEAR,100).EQ.0 .AND. MOD(ISYEAR,400).NE.0) )    &
     &           THEN
!              Not a Leap Year
               INCRST = 365
            ELSE
!              Leap Year
               INCRST = 366
            ENDIF
         ENDIF
 
!        Determine Number of Hours to be Processed, NHOURS, For Use
!        With the TOXXFILE Option - 9/29/92
         IF ( (MOD(ISYEAR,4).NE.0) .OR.                                 &
     &        (MOD(ISYEAR,100).EQ.0 .AND. MOD(ISYEAR,400).NE.0) ) THEN
!           Not a Leap Year
            ND = 365
         ELSE
!           Leap Year
            ND = 366
         ENDIF
         NDYS = 0
         DO I = 1 , ND
            IF ( IPROC(I).EQ.1 ) NDYS = NDYS + 1
         ENDDO
         NHOURS = NDYS*24
 
      ELSE
!        Write Error Message: Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==SURFIL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SURFIL
!***********************************************************************
!                 SURFIL Module of AERMOD
!
!        PURPOSE: Process Surface Meteorology Input File Options
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, James Paumier
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Meteorological Data Filename and Format
!
!        ERROR HANDLING:   Checks for No Parameters;
!                          Checks for No Format (uses default);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
!     Variable Initializations
      MODNAM = 'SURFIL'
 
      IF ( IFC.EQ.3 ) THEN
!        Retrieve Met Data Filename as Character Substring to Maintain Case
         METINP = RUNST1(LOCB(3):LOCE(3))
!        Use Default Met Data Format: Initialized in SUBROUTINE VARINI to
      ELSEIF ( IFC.EQ.4 ) THEN
!        Retrieve Met Data Filename as Character Substring to Maintain Case
         METINP = RUNST1(LOCB(3):LOCE(3))
!        Check for Format String > 105 (Limit for METFRM Variable)
         IF ( (LOCE(4)-LOCB(4)).LE.104 ) THEN
            IF ( (LOCE(4)-LOCB(4)).GT.39 ) THEN
!              Retrieve Met Format as Char. Substring to Bypass Field Limit
               METFRM = RUNST1(LOCB(4):LOCE(4))
            ELSE
!              Retrieve Met Format From FIELD(4)
               METFRM = FIELD(4)
            ENDIF
         ELSE
!           WRITE Error Message:  METFRM Field is Too Long
            CALL ERRHDL(PATH,MODNAM,'E','203',' METFRM ')
         ENDIF
      ELSEIF ( IFC.GT.4 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Warning Message         ! No Parameters Specified
         CALL ERRHDL(PATH,MODNAM,'W','200',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==PROFIL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PROFIL
!***********************************************************************
!                 PROFIL Module of AERMOD
!
!        PURPOSE: Process Profile Meteorology Input File Options
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, James Paumier
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Meteorological Data Filename and Format
!
!        ERROR HANDLING:   Checks for No Parameters;
!                          Checks for No Format (uses default);
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
!     Variable Initializations
      MODNAM = 'PROFIL'
 
      IF ( IFC.EQ.3 ) THEN
!        Retrieve Met Data Filename as Character Substring to Maintain Case
         PROINP = RUNST1(LOCB(3):LOCE(3))
!        Use Default Met Data Format: Initialized in SUBROUTINE VARINI to
      ELSEIF ( IFC.EQ.4 ) THEN
!        Retrieve Met Data Filename as Character Substring to Maintain Case
         PROINP = RUNST1(LOCB(3):LOCE(3))
!        Check for Format String > 60 (Limit for PROFRM Variable)
         IF ( (LOCE(4)-LOCB(4)).LE.59 ) THEN
            IF ( (LOCE(4)-LOCB(4)).GT.39 ) THEN
!              Retrieve Met Format as Char. Substring to Bypass Field Limit
               PROFRM = RUNST1(LOCB(4):LOCE(4))
            ELSE
!              Retrieve Met Format From FIELD(4)
               PROFRM = FIELD(4)
            ENDIF
         ELSE
!           WRITE Error Message:  PROFRM Field is Too Long
            CALL ERRHDL(PATH,MODNAM,'E','203',' PROFRM ')
         ENDIF
      ELSEIF ( IFC.GT.4 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Warning Message         ! No Parameters Specified
         CALL ERRHDL(PATH,MODNAM,'W','200',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==SFDATA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SFDATA
!***********************************************************************
!                 SFDATA Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Meteorology Surface Data Station Options
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT).
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Meteorological Surface Data Station Identification
!
!        ERROR HANDLING:   Checks for Too Few Parameters;
!                          Checks for Invalid Numeric Fields;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: SFX , SFY
 
!     Variable Initializations
      MODNAM = 'SFDATA'
 
      IF ( IFC.EQ.2 ) THEN
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.4 ) THEN
!        WRITE Error Message           ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.7 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 199
      ENDIF
      IDSURF = NINT(FNUM)
 
 199  CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 299
      ENDIF
      ISYEAR = NINT(FNUM)
!     Check for 2-digit Input and Convert ISYEAR to Four Digits
      IF ( ISYEAR.GE.ISTRT_WIND .AND. ISYEAR.LE.99 ) THEN
         ISYEAR = ISTRT_CENT*100 + ISYEAR
      ELSEIF ( ISYEAR.LT.ISTRT_WIND ) THEN
         ISYEAR = (ISTRT_CENT+1)*100 + ISYEAR
      ENDIF
 
 299  IF ( IFC.GE.5 ) THEN
!        Retrieve Surface Data Station Name (Optional)
         SFNAME = FIELD(5)
      ELSE
         SFNAME = 'UNKNOWN'
      ENDIF
 
      IF ( IFC.EQ.7 ) THEN
!        Retrieve Coordinates for Surface Data Location (Optional)
         CALL STONUM(FIELD(6),ILEN_FLD,SFX,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         CALL STONUM(FIELD(7),ILEN_FLD,SFY,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==UADATA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE UADATA
!***********************************************************************
!                 UADATA Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Meteorology Upper Air Data Station Options
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT).
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Meteorological Upper Air Data Station Identification
!
!        ERROR HANDLING:   Checks for Too Few Parameters;
!                          Checks for Invalid Numeric Fields;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: UAX , UAY
 
!     Variable Initializations
      MODNAM = 'UADATA'
 
      IF ( IFC.EQ.2 ) THEN
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.4 ) THEN
!        WRITE Error Message           ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.7 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 199
      ENDIF
      IDUAIR = NINT(FNUM)
 
 199  CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 299
      ENDIF
      IUYEAR = NINT(FNUM)
!     Convert IUYEAR to Four Digits
      IF ( IUYEAR.GE.ISTRT_WIND .AND. IUYEAR.LE.99 ) THEN
         IUYEAR = ISTRT_CENT*100 + IUYEAR
      ELSEIF ( IUYEAR.LT.ISTRT_WIND ) THEN
         IUYEAR = (ISTRT_CENT+1)*100 + IUYEAR
      ENDIF
 
 299  IF ( IFC.GE.5 ) THEN
!        Retrieve Surface Data Station Name (Optional)
         UANAME = FIELD(5)
      ELSE
         UANAME = 'UNKNOWN'
      ENDIF
 
      IF ( IFC.EQ.7 ) THEN
!        Retrieve Coordinates for Surface Data Location (Optional)
         CALL STONUM(FIELD(6),ILEN_FLD,UAX,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         CALL STONUM(FIELD(7),ILEN_FLD,UAY,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==ONDATA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ONDATA
!***********************************************************************
!                 ONDATA Module of AERMOD
!
!        PURPOSE: Process On-site Meteorology Data Station Options
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, James Paumier
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: On-site Meteorological Data Station Identification
!
!        ERROR HANDLING:   Checks for Too Few Parameters;
!                          Checks for Invalid Numeric Fields;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: ONX , ONY
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'ONDATA'
 
      IF ( IFC.EQ.2 ) THEN
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.LT.4 ) THEN
!        WRITE Error Message           ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.7 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
      CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 199
      ENDIF
      IDSITE = INT(FNUM)
 
 199  CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!     Check The Numerical Field
      IF ( IMIT.NE.1 ) THEN
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 299
      ENDIF
      IOYEAR = INT(FNUM)
 
 299  IF ( IFC.GE.5 ) THEN
!        Retrieve Surface Data Station Name (Optional)
         ONNAME = FIELD(5)
      ELSE
         ONNAME = 'UNKNOWN'
      ENDIF
 
      IF ( IFC.EQ.7 ) THEN
!        Retrieve Coordinates for Surface Data Location (Optional)
         CALL STONUM(FIELD(6),ILEN_FLD,ONX,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         CALL STONUM(FIELD(7),ILEN_FLD,ONY,IMIT)
         IF ( IMIT.NE.1 ) CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==PRBASE.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PRBASE
!***********************************************************************
!                 PRBASE Module of the AERMOD Model
!
!        PURPOSE: Process Inputs for Profile Base Elevation
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    November 9, 1998
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Profile Base Elevation (m MSL), ZBASE
!
!        ERROR HANDLING:   Checks for No Parameters;
!                          Checks for No Units (uses default of m);
!                          Checks for Invalid or Suspicious Values of ZBASE;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'PRBASE'
 
      IF ( IFC.EQ.3 .OR. IFC.EQ.4 ) THEN
         CALL STONUM(FIELD(3),ILEN_FLD,ZBASE,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 999
         ENDIF
         IF ( IFC.EQ.4 .AND. FIELD(4).EQ.'FEET' ) THEN
            ZBASE = 0.3048*ZBASE
         ELSEIF ( IFC.EQ.4 .AND. FIELD(4).NE.'METERS' ) THEN
!           WRITE Warning Message - Invalid ZRUNIT Parameter
            CALL ERRHDL(PATH,MODNAM,'W','203','ZRUNIT')
         ENDIF
         IF ( ZBASE.LT.0.0 .AND. IMIT.EQ.1 ) THEN
!           WRITE Warning Message - Possible Error In ZBASE
            CALL ERRHDL(PATH,MODNAM,'W','340',KEYWRD)
         ELSEIF ( IMIT.NE.1 ) THEN
!           WRITE Error Message - Invalid Numeric Field
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ENDIF
      ELSEIF ( IFC.GT.4 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ENDIF
 
!     Reinitialize AZS, AZELEV, and AZHILL arrays for FLAT terrain
      IF ( FLAT ) THEN
         DO ISRC = 1 , NUMSRC
            AZS(ISRC) = ZBASE
         ENDDO
         DO IREC = 1 , NUMREC
            AZELEV(IREC) = ZBASE
            AZHILL(IREC) = ZBASE
         ENDDO
      ENDIF
 
 999  CONTINUE
      END
!*==STAEND.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE STAEND
!***********************************************************************
!                 STAEND Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process Start and End Dates for Meteorology File
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT) and calculation
!                    of 10-digit variables for start date (ISDATE) and
!                    end date (IEDATE).
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Start and End Dates to Read from Meteorological File
!
!        ERROR HANDLING:   Checks for Too Few Parameters;
!                          Checks for Invalid Numeric Fields;
!                          Checks for Too Many Parameters
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER IDYMAX(12)
 
!     Variable Initializations
      MODNAM = 'STAEND'
      DATA IDYMAX/31 , 29 , 31 , 30 , 31 , 30 , 31 , 31 , 30 , 31 , 30 ,&
     &     31/
 
      IF ( IFC.EQ.8 ) THEN
!        Process for YR, MD, DY
         CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 198
         ENDIF
         ISYR = NINT(FNUM)
 198     CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 298
         ENDIF
         ISMN = NINT(FNUM)
 298     CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 398
         ENDIF
         ISDY = NINT(FNUM)
 398     CALL STONUM(FIELD(6),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 498
         ENDIF
         IEYR = NINT(FNUM)
 498     CALL STONUM(FIELD(7),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 598
         ENDIF
         IEMN = NINT(FNUM)
 598     CALL STONUM(FIELD(8),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 698
         ENDIF
         IEDY = NINT(FNUM)
 698     CONTINUE
!        Convert ISYR and IEYR to Four Digits
         IF ( ISYR.GE.ISTRT_WIND .AND. ISYR.LE.99 ) THEN
            ISYR = ISTRT_CENT*100 + ISYR
         ELSEIF ( ISYR.LT.ISTRT_WIND ) THEN
            ISYR = (ISTRT_CENT+1)*100 + ISYR
         ENDIF
         IF ( IEYR.GE.ISTRT_WIND .AND. IEYR.LE.99 ) THEN
            IEYR = ISTRT_CENT*100 + IEYR
         ELSEIF ( IEYR.LT.ISTRT_WIND ) THEN
            IEYR = (ISTRT_CENT+1)*100 + IEYR
         ENDIF
!        Calculate JULIAN Day for Start and End Dates
         CALL JULIAN(ISYR,ISMN,ISDY,ISJDAY)
         CALL JULIAN(IEYR,IEMN,IEDY,IEJDAY)
!        Use 0 for Start Hour and 24 for End Hour
         ISHR = 0
         IEHR = 24
!        Calculate 10-digit start date (ISDATE) and end date (IEDATE)
         IF ( ISYR.LE.2147 ) THEN
            ISDATE = ISYR*1000000 + ISMN*10000 + ISDY*100 + ISHR
         ELSE
            CALL ERRHDL(PATH,MODNAM,'E','365',KEYWRD)
            ISDATE = 2147123124
         ENDIF
         IF ( IEYR.LE.2147 ) THEN
            IEDATE = IEYR*1000000 + IEMN*10000 + IEDY*100 + IEHR
         ELSE
            CALL ERRHDL(PATH,MODNAM,'E','365',KEYWRD)
            IEDATE = 2147123124
         ENDIF
      ELSEIF ( IFC.EQ.10 ) THEN
!        Process for YR, MD, DY, HR
         CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 199
         ENDIF
         ISYR = NINT(FNUM)
 199     CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 299
         ENDIF
         ISMN = NINT(FNUM)
 299     CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 399
         ENDIF
         ISDY = NINT(FNUM)
 399     CALL STONUM(FIELD(6),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 499
         ENDIF
         ISHR = NINT(FNUM)
 499     CALL STONUM(FIELD(7),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 599
         ENDIF
         IEYR = NINT(FNUM)
 599     CALL STONUM(FIELD(8),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 699
         ENDIF
         IEMN = NINT(FNUM)
 699     CALL STONUM(FIELD(9),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 799
         ENDIF
         IEDY = NINT(FNUM)
 799     CALL STONUM(FIELD(10),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 899
         ENDIF
         IEHR = NINT(FNUM)
 899     CONTINUE
!        Convert ISYR and IEYR to Four Digits
         IF ( ISYR.GE.ISTRT_WIND .AND. ISYR.LE.99 ) THEN
            ISYR = ISTRT_CENT*100 + ISYR
         ELSEIF ( ISYR.LT.ISTRT_WIND ) THEN
            ISYR = (ISTRT_CENT+1)*100 + ISYR
         ENDIF
         IF ( IEYR.GE.ISTRT_WIND .AND. IEYR.LE.99 ) THEN
            IEYR = ISTRT_CENT*100 + IEYR
         ELSEIF ( IEYR.LT.ISTRT_WIND ) THEN
            IEYR = (ISTRT_CENT+1)*100 + IEYR
         ENDIF
!        Calculate JULIAN Day for Start and End Dates
         CALL JULIAN(ISYR,ISMN,ISDY,ISJDAY)
         CALL JULIAN(IEYR,IEMN,IEDY,IEJDAY)
!        Calculate 10-digit start date (ISDATE) and end date (IEDATE)
         IF ( ISYR.LE.2147 ) THEN
            ISDATE = ISYR*1000000 + ISMN*10000 + ISDY*100 + ISHR
         ELSE
            CALL ERRHDL(PATH,MODNAM,'E','365',KEYWRD)
            ISDATE = 2147123124
         ENDIF
         IF ( IEYR.LE.2147 ) THEN
            IEDATE = IEYR*1000000 + IEMN*10000 + IEDY*100 + IEHR
         ELSE
            CALL ERRHDL(PATH,MODNAM,'E','365',KEYWRD)
            IEDATE = 2147123124
         ENDIF
!           Adjust Start Hour to One Hour Earlier
         IF ( ISHR.NE.0 ) ISDATE = ISDATE - 1
      ELSEIF ( IFC.GT.8 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message           ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
      ENDIF
 
!     Determine MN, DY, and HR for end-of-the-year check.
!     Subtract one from start hour to set end hour for the year of data
      IENDHOUR = ISHR - 1
      IF ( IENDHOUR.LE.0 ) IENDHOUR = 24
      IF ( ISDY.GT.1 ) THEN
         IENDDY = ISDY - 1
         IENDMN = ISMN
      ELSE
         IENDMN = ISMN - 1
         IF ( IENDMN.EQ.0 ) IENDMN = 12
         IENDDY = IDYMAX(IENDMN)
      ENDIF
 
      CONTINUE
      END
!*==DAYRNG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE DAYRNG
!***********************************************************************
!                 DAYRNG Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Process the Selection of Days and Ranges of Days
!                 for Processing from the Meteorology File
!
!        PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: Array of Dates to Process from Meteorological File
!
!        ERROR HANDLING:   Checks for Too Few Parameters;
!                          Checks for Invalid Numeric Fields;
!                          Checks for Improper Combinations of Fields;
!                          Checks for Dates Out of Range
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , K , IMN , IDY , IMN1 , IDY1 , IMN2 , IDY2 , JDAYB ,&
     &           JDAYE
      CHARACTER BEGRNG*8 , ENDRNG*8 , CMN1*8 , CDY1*8 , CMN2*8 , CDY2*8
      CHARACTER BLNK08*8
      LOGICAL RMARK , GMARK
 
!     Variable Initializations
      MODNAM = 'DAYRNG'
      DATA BLNK08/'        '/
 
      IF ( IFC.LT.3 ) THEN
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ELSE
         DO I = 3 , IFC
!           First Check For Range Marker (-) And Gregorian Day Marker (/)
!           Initialize Character Fields
            BEGRNG = BLNK08
            ENDRNG = BLNK08
            CMN1 = BLNK08
            CDY1 = BLNK08
            CMN2 = BLNK08
            CDY2 = BLNK08
            CALL FSPLIT(PATH,KEYWRD,FIELD(I),ILEN_FLD,'-',RMARK,BEGRNG, &
     &                  ENDRNG)
            CALL FSPLIT(PATH,KEYWRD,BEGRNG,8,'/',GMARK,CMN1,CDY1)
            IF ( RMARK .AND. GMARK )                                    &
     &            CALL FSPLIT(PATH,KEYWRD,ENDRNG,8,'/',GMARK,CMN2,CDY2)
 
            IF ( .NOT.RMARK .AND. .NOT.GMARK ) THEN
!              Field Must Be a Single Julian Day
               CALL STONUM(BEGRNG,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  JDAY = NINT(FNUM)
               ENDIF
               IF ( JDAY.GE.1 .AND. JDAY.LE.366 .AND. IMIT.EQ.1 ) THEN
                  IPROC(JDAY) = 1
               ELSE
!                 WRITE Error Message    ! Invalid Julian Day
                  CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
               ENDIF
               IF ( JDAY.LT.ISJDAY .OR. JDAY.GT.IEJDAY ) THEN
!                 WRITE Warning Message  ! Julian Day Out-of-Range
                  WRITE (DUMMY,'(I8)') JDAY
                  CALL ERRHDL(PATH,MODNAM,'W','350',DUMMY)
               ENDIF
 
            ELSEIF ( RMARK .AND. .NOT.GMARK ) THEN
!              Field Must Be a Julian Day Range - Extract Beg & End
               CALL STONUM(BEGRNG,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  JDAYB = NINT(FNUM)
               ENDIF
               CALL STONUM(ENDRNG,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  JDAYE = NINT(FNUM)
               ENDIF
               IF ( (JDAYB.LE.JDAYE) .AND. (JDAYB.GE.1) .AND.           &
     &              (JDAYE.LE.366) ) THEN
                  DO K = JDAYB , JDAYE
                     IPROC(K) = 1
                  ENDDO
               ELSE
!                 WRITE Error Message    ! Invalid Julian Day Range
                  CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
               ENDIF
               IF ( JDAYB.LT.ISJDAY .OR. JDAYE.GT.IEJDAY ) THEN
!                 WRITE Warning Message  ! Julian Day Out-of-Range
                  WRITE (DUMMY,'(I3,"-",I3)') JDAYB , JDAYE
                  CALL ERRHDL(PATH,MODNAM,'W','350',DUMMY)
               ENDIF
 
            ELSEIF ( .NOT.RMARK .AND. GMARK ) THEN
!               Field Must Be a Single Month/Day
               CALL STONUM(CMN1,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  IMN = NINT(FNUM)
               ENDIF
               CALL STONUM(CDY1,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  IDY = NINT(FNUM)
               ENDIF
               CALL JULIAN(ISYEAR,IMN,IDY,JDAY)
               IF ( JDAY.GE.1 .AND. JDAY.LE.366 ) THEN
                  IPROC(JDAY) = 1
               ELSE
!                 WRITE Error Message    ! Invalid Julian Day
                  CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
               ENDIF
               IF ( JDAY.LT.ISJDAY .OR. JDAY.GT.IEJDAY ) THEN
!                 WRITE Warning Message  ! Julian Day Out-of-Range
                  WRITE (DUMMY,'(I8)') JDAY
                  CALL ERRHDL(PATH,MODNAM,'W','350',DUMMY)
               ENDIF
 
            ELSEIF ( RMARK .AND. GMARK ) THEN
!              Field Must Be a Greg. Date Range (MN/DY-MN/DY)
               CALL STONUM(CMN1,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 41
               ELSE
                  IMN1 = NINT(FNUM)
               ENDIF
               CALL STONUM(CDY1,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 41
               ELSE
                  IDY1 = NINT(FNUM)
               ENDIF
 41            CALL STONUM(CMN2,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  IMN2 = NINT(FNUM)
               ENDIF
               CALL STONUM(CDY2,8,FNUM,IMIT)
!              Check The Numerical Field
               IF ( IMIT.EQ.-1 ) THEN
                  CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
                  GOTO 40
               ELSE
                  IDY2 = NINT(FNUM)
               ENDIF
               CALL JULIAN(ISYEAR,IMN1,IDY1,JDAYB)
               CALL JULIAN(ISYEAR,IMN2,IDY2,JDAYE)
               IF ( (JDAYB.LE.JDAYE) .AND. (JDAYB.GE.1) .AND.           &
     &              (JDAYE.LE.366) ) THEN
                  DO K = JDAYB , JDAYE
                     IPROC(K) = 1
                  ENDDO
               ELSE
!                 WRITE Error Message    ! Invalid Julian Day
                  CALL ERRHDL(PATH,MODNAM,'E','203','Juli Day')
               ENDIF
               IF ( JDAYB.LT.ISJDAY .OR. JDAYE.GT.IEJDAY ) THEN
!                 WRITE Warning Message  ! Julian Day Out-of-Range
                  WRITE (DUMMY,'(I3,"-",I3)') JDAYB , JDAYE
                  CALL ERRHDL(PATH,MODNAM,'W','350',DUMMY)
               ENDIF
 
            ELSE
!               WRITE Error Message    ! Invalid Field
               CALL ERRHDL(PATH,MODNAM,'E','203','DAYRANGE')
            ENDIF
 
 40      ENDDO
      ENDIF
 
      CONTINUE
      END
!*==WDROTA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE WDROTA
!***********************************************************************
!                 WDROTA Module of the AMS/EPA Regulatory Model - AERMOD
!
!     PURPOSE:    PROCESSES INPUT FOR ROTATING WIND DIRECTION DATA
!
!     PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!     INPUTS:     Input Runstream Image Parameters
!
!     OUTPUT:     Wind Direction Rotation Angle
!
!     CALLED FROM:   MECARD
!
!     ERROR HANDLING:   Checks for No Parameters;
!                       Checks for Too Many Parameters;
!                       Checks for Invalid Numeric Field
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      ROTANG = 0.0
      MODNAM = 'WDROTA'
 
      IF ( IFC.EQ.3 ) THEN
         CALL STONUM(FIELD(3),ILEN_FLD,ROTANG,IMIT)
         IF ( IMIT.NE.1 ) THEN
!            WRITE Error Message  ! Invalid Numeric Field Encountered
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         ELSEIF ( ABS(ROTANG).GT.180.0 ) THEN
!            WRITE Error Message       ! ROTANG Out of Range
            CALL ERRHDL(PATH,MODNAM,'E','380','ROTANG')
         ENDIF
      ELSEIF ( IFC.GT.3 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==WSCATS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE WSCATS
!***********************************************************************
!                 WSCATS Module of the AMS/EPA Regulatory Model - AERMOD
!
!     PURPOSE:    PROCESSES INPUT FOR WIND SPEED CATEGORIES
!
!     PROGRAMMER: Roger Brode, Jeff Wang
!
!        DATE:    March 2, 1992
!
!     INPUTS:     Input Runstream Image Parameters
!
!     OUTPUT:     Array of Wind Speed Category Limits (5)
!
!     CALLED FROM:   MECARD
!
!     ERROR HANDLING:   Checks for No Parameters;
!                       Checks for Too Many Parameters;
!                       Checks for Invalid Numeric Fields;
!                       Checks for Wind Speed Category Decreasing
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IWS
 
!     Variable Initializations
      MODNAM = 'WSCATS'
 
      IF ( IFC.EQ.7 ) THEN
!        Fill UCAT Array
         DO I = 3 , IFC
            CALL STONUM(FIELD(I),ILEN_FLD,FNUM,IMIT)
            IF ( IMIT.NE.1 ) THEN
!              WRITE Error Message  ! Invalid Numeric Field Encountered
               CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            ELSEIF ( FNUM.LT.1.0 .OR. FNUM.GT.20.0 ) THEN
!               WRITE Error Message       ! UCAT Out of Range
               CALL ERRHDL(PATH,MODNAM,'E','380','UCAT')
            ELSE
               IWS = I - 2
               UCAT(IWS) = FNUM
!                 WRITE Error Message    ! Invalid UCAT Value, LE Previous
               IF ( IWS.GT.1 .AND. UCAT(IWS).LE.UCAT(IWS-1) )           &
     &              CALL ERRHDL(PATH,MODNAM,'E','203','UCAT')
            ENDIF
         ENDDO
      ELSEIF ( IFC.GT.7 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message           ! No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==MEOPEN.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE MEOPEN
!***********************************************************************
!                 MEOPEN Module of the AERMOD Model
!
!        PURPOSE: Open The Input file for Hourly Meteorological Data,
!                 And Check Header Record
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Meteorology File Specifications
!
!        OUTPUTS: File OPEN Error Status
!
!        CALLED FROM:   SETUP
!
!        REVISION HISTORY:
!         --  Modified check of version date in header record of surface
!             file.  Fatal error occurs if version date is greater than
!             90000 OR less than current release date.
!             R. Brode, PES, 09/10/02
!         --  Modified comparisons of met station IDs between SURFFILE
!             header record and ME pathway.  IDs are initially read as
!             integers, and then as characters if an error occurs.  Also
!             changed from fatal error to a warning message if a mismatch
!             occurs, and included SITEDATA ID in the comparison.
!             R. Brode, PES, 11/10/98
!         --  Modified to check for version date associated with of AERMET
!             surface file, and compare to two reference dates.  Versions
!             prior to first date cause fatal error, while version prior to
!             second date cause warning.  R. Brode, PES, 11/21/97
!         --  Removed the comparison of the years defined in the input
!             data file with the years declared in the control file
!         --  Added OPEN for the profile file
!         --  Read and interpreted the latitude and longitude in the
!             first record of the SURFFILE
!
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: METVER , IOSI , ISSI , IUSI
 
      SAVE 
 
!     Set Parameters for AERMET Version Dates.
!     Using data > MDATE1 or < MDATE2 causes a fatal error message.
      INTEGER , PARAMETER :: MDATE1 = 90000 , MDATE2 = 04300
 
      CHARACTER(LEN=8) :: CUSI , CSSI , COSI
      CHARACTER(LEN=6) :: SPEC1 , SPEC2 , SPEC3
 
!     Variable Initializations
      MODNAM = 'MEOPEN'
 
!     File Unit Initialized in BLOCK DATA INIT
!     File Format Set By Keyword "SURFFILE" on "ME" pathway
!     OPEN Surface Met Data File --- Formatted is the only option
!     READ In the Station Numbers for Comparison to SETUP File
 
      OPEN (UNIT=MFUNIT,ERR=998,FILE=METINP,FORM='FORMATTED',           &
     &      IOSTAT=IOERRN,STATUS='OLD')
 
      GOTO 1000
 
!     Write Out Error Message for File OPEN Error
 998  CALL ERRHDL(PATH,MODNAM,'E','500','SURFFILE')
!     Skip READ if there is an error opening file
      GOTO 1001
 
 1000 CONTINUE
 
      READ (MFUNIT,1900,ERR=90,IOSTAT=IOERRN) ALAT , ALON , SPEC1 ,     &
     &      IUSI , SPEC2 , ISSI , SPEC3 , IOSI , METVER
 1900 FORMAT (2A10,T31,A6,T38,I8,T48,A6,T55,I8,T65,A6,T72,I8,T94,I5)
 
      GOTO 800
 
 90   CONTINUE
 
!     Error reading the header record. Now we'll try using character
!     instead of integer reads for the station IDs.
 
      REWIND MFUNIT
      READ (MFUNIT,1901,ERR=99,IOSTAT=IOERRN) ALAT , ALON , SPEC1 ,     &
     &      CUSI , SPEC2 , CSSI , SPEC3 , COSI , METVER
 1901 FORMAT (2A10,T31,A6,T38,A8,T48,A6,T55,A8,T65,A6,T72,A8,T94,I5)
 
!     Convert character IDs to integers
      CALL STONUM(CUSI,8,FNUM,IMIT)
      IF ( IMIT.EQ.1 ) THEN
         IUSI = NINT(FNUM)
      ELSE
         IUSI = 0
      ENDIF
      CALL STONUM(CSSI,8,FNUM,IMIT)
      IF ( IMIT.EQ.1 ) THEN
         ISSI = NINT(FNUM)
      ELSE
         ISSI = 0
      ENDIF
      CALL STONUM(COSI,8,FNUM,IMIT)
      IF ( IMIT.EQ.1 ) THEN
         IOSI = NINT(FNUM)
      ELSE
         IOSI = 0
      ENDIF
 
 800  CONTINUE
 
!     Check for valid version of meteorological data
      IF ( METVER.GT.MDATE1 .OR. METVER.LT.MDATE2 ) THEN
         WRITE (DUMMY,'(2X,I5.5)') METVER
         CALL ERRHDL(PATH,MODNAM,'E','395',DUMMY)
      ENDIF
 
!     Check Station IDs in SURFFILE for agreement with ME pathway
!        Write Warning Message:  SURFDATA id mismatch
      IF ( ISSI.NE.IDSURF ) CALL ERRHDL(PATH,MODNAM,'W','530','SURFDATA'&
     &                                  )
!        Write Warning Message:  UAIRDATA id mismatch
      IF ( IUSI.NE.IDUAIR ) CALL ERRHDL(PATH,MODNAM,'W','530','UAIRDATA'&
     &                                  )
      IF ( IMSTAT(9).EQ.1 ) THEN
!           Write Warning Message:  SITEDATA id mismatch
         IF ( IOSI.NE.IDSITE )                                          &
     &         CALL ERRHDL(PATH,MODNAM,'W','530','SITEDATA')
      ENDIF
 
!     Get the hemisphere and latitude (from the first record of the
!     scalar file
      CALL DCDLAT()
 
      GOTO 1001
 
!     Write Out Error Message for File READ Error
 99   CALL ERRHDL(PATH,MODNAM,'E','510','SURFFILE')
 
 1001 CONTINUE
 
!     File Format Set By Keyword "PROFFILE" on "ME" pathway
!     OPEN Profile Met Data File --- Formatted is the only option
 
      OPEN (UNIT=MPUNIT,ERR=999,FILE=PROINP,FORM='FORMATTED',           &
     &      IOSTAT=IOERRN,STATUS='OLD')
 
      GOTO 1002
 
!     Write Out Error Message for File OPEN Error
 999  CALL ERRHDL(PATH,MODNAM,'E','500','PROFFILE')
      GOTO 1002
 
 1002 CONTINUE
 
      END
!*==SCIMIT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SCIMIT
!***********************************************************************
!                 SCIMIT Module of ISC3 Short Term Model - ISCST3
!
!        PURPOSE: Process Sampled Chronological Input Model (SCIM) Options
!                 From Runstream Input Image
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    April 14, 1998
!
!        INPUTS:  Input Runstream Image Parameters
!
!        OUTPUTS: SCIM parameters:  Start Hour (1-24)
!                                   Number of Hours to Skip
!                                   Optional filename to summarize
!                                      the SCIM's meteorology
!
!        ERROR HANDLING:   Checks for No Parameters;
!                          Checks for Too Many Parameters;
!                          Checks for Invalid Numeric Inputs
!
!        CALLED FROM:   MECARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'SCIMIT'
 
      IF ( IFC.EQ.6 .OR. IFC.EQ.8 ) THEN
         CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 999
         ELSE
            NREGSTART = NINT(FNUM)
         ENDIF
!           WRITE Error Message        ! Start Hour out of range
         IF ( NREGSTART.LT.1 .OR. NREGSTART.GT.24 )                     &
     &        CALL ERRHDL(PATH,MODNAM,'E','380','StartHr')
 
         CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 999
         ELSE
            NREGINT = NINT(FNUM)
         ENDIF
!           WRITE Error Message        ! NRegInt is out of range
         IF ( NREGINT.LT.1 )                                            &
     &        CALL ERRHDL(PATH,MODNAM,'E','380','NRegInt')
 
         CALL STONUM(FIELD(5),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 999
         ELSE
            NWETSTART = NINT(FNUM)
         ENDIF
 
         CALL STONUM(FIELD(6),ILEN_FLD,FNUM,IMIT)
!        Check The Numerical Field
         IF ( IMIT.EQ.-1 ) THEN
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GOTO 999
         ELSE
            NWETINT = NINT(FNUM)
         ENDIF
 
!        Temporarily set NWETSTART=0 and NWETINT=0 until wet deposition is
!        included in AERMOD.
         IF ( NWETSTART.NE.0 .OR. NWETINT.NE.0 ) THEN
            CALL ERRHDL(PATH,MODNAM,'W','157',KEYWRD)
            NWETSTART = 0
            NWETINT = 0
         ENDIF
 
         IF ( NWETINT.GE.1 ) THEN
            IF ( DEPOS .OR. WDEP .OR. WDPLETE ) THEN
               WETSCIM = .TRUE.
            ELSE
!              WRITE Error Message: Wet SCIM'ing, but no DEPOS/WDEP/WDPLETE
               CALL ERRHDL(PATH,MODNAM,'E','383',KEYWRD)
            ENDIF
 
!              WRITE Error Message: NWetStrt is out of range
            IF ( NWETSTART.LE.0 .OR. NWETSTART.GT.NWETINT )             &
     &           CALL ERRHDL(PATH,MODNAM,'E','380','NWetStrt')
         ELSEIF ( NWETINT.EQ.0 ) THEN
            WETSCIM = .FALSE.
         ELSE
!           WRITE Error Message: NWETINT is out of range
            CALL ERRHDL(PATH,MODNAM,'E','380','NWetInt')
         ENDIF
 
         IF ( IFC.EQ.8 ) THEN
!           Optional file for summary of SCIM'd met data is specified
            SCIMOUT = .TRUE.
            SCIM_SFCFIL = FIELD(7)
            SCIM_PROFIL = FIELD(8)
            OPEN (UNIT=ISUNIT,FILE=SCIM_SFCFIL,STATUS='UNKNOWN')
            OPEN (UNIT=IPUNIT,FILE=SCIM_PROFIL,STATUS='UNKNOWN')
         ENDIF
      ELSEIF ( IFC.GT.8 ) THEN
!        WRITE Error Message           ! Too Many Parameters
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
      ELSE
!        WRITE Error Message           ! Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
      ENDIF
 
 999  CONTINUE
      END
!*==METEXT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE METEXT
!***********************************************************************
!                METEXT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Controls Extraction and Quality Assurance of
!                 One Hour of Meteorological Data
!
!        PROGRAMMER: ROGER BRODE, JEFF WANG
!        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION)
!
!        DATE:    November 8, 1993
!
!        MODIFIED BY D. Strimaitis, SRC (for Dry DEPOSITION)
!        (DATE:    February 15, 1993)
!
!        MODIFIED:   To avoid potential math error due to negative
!                    ambient temperatures in calculating the square
!                    root of the stability parameter, RTOFS - 4/19/93
!
!        MODIFIED:
!        7/27/94     J. Paumier, PES, Inc.
!                    The variables for displacement height, ZDM and
!                    AZDM(), were removed from the input to and output
!                    from ISC-COMPDEP.  The following format statements
!                    also were affected: 9009, 9026, 9032, 9033
!
!*       7/27/94     J. Hardikar, PES, Inc.
!*                   Added code to calculate reference wind speed at 10m
!*                   to be used for OPENPIT source algorithms
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance, including use of date window
!                    variables (ISTRT_WIND and ISTRT_CENT) and calculation
!                    of 10-digit date variable (FULLDATE) with 4-digit
!                    year for date comparisons.
!                    Also moved call to METDAT to allow use of single
!                    METDAT routine for normal and EVENT processing.
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        MODIFIED:   To remove support for unformatted meteorological
!                    data files.
!                    R.W. Brode, PES, Inc., 4/10/2000
!
!        MODIFIED:   To correct potential problem with check for
!                    concatenated data files.
!                    R.W. Brode, PES, Inc., 9/15/2000
!
!        MODIFIED:   To incorporate additional variables for dry
!                    and wet deposition, and to remove formatted
!                    read for surface file.  Surface file is now
!                    read FREE format.
!                    R.W. Brode, PES, Inc., 9/29/2003
!
!        MODIFIED:   Moved call to SUB. METDAT ahead of call to
!                    SUB. SET_METDATA to avoid potential problem
!                    with negative precipitation for first hour
!                    of data.
!                    R.W. Brode, MACTEC, 10/26/2004
!
!        INPUTS:  Meteorology File Specifications
!
!        OUTPUTS: Meteorological Variables for One Hour
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: DAY , AFVM1 , C1 , C2 , C3 , STEFB , RN , ES25
      INTEGER :: IDYMAX(12) , GINDEX , IJDAY , JFLAG , LEVEL
      INTEGER :: METVER , JUYI , JUSI , JSYI , JSSI
      CHARACTER(LEN=8) :: CUSI , CSSI , COSI
      CHARACTER(LEN=6) :: SPEC1 , SPEC2 , SPEC3
      CHARACTER(LEN=132) :: BUFFER
 
!     Variable Initializations
      MODNAM = 'METEXT'
      PATH = 'MX'
      DATA IDYMAX/31 , 29 , 31 , 30 , 31 , 30 , 31 , 31 , 30 , 31 , 30 ,&
     &     31/
 
!---- Constants used in the computation of QSW
      C1 = 5.31E-13
      C2 = 60.0
      C3 = 1.12
      STEFB = 5.67E-08
 
!     Save Value of Last YR/MN/DY/HR and Previous Hour
      IPDATE = KURDAT
      IPHOUR = IHOUR
 
!     READ Meteorology Data Based on Format --
!     When DRY deposition is modeled, U-star, L, and z0 (surface
!     roughness length) are read in addition to the standard RAMMET
!     data.  These must be provided at the end of each hourly record
!     for the FORMATTED ASCII, CARD, and FREE options.
!
!     When WET deposition is modeled, ipcode (precip.
!     code) and prate (precip. rate in mm/hr) must also be added to
!     each hourly record.
!     The format statement allows for all additional data:
 
 9009 FORMAT (4I2,2F9.4,F6.1,I2,2F7.1,2F8.4,F9.4,F10.1,F8.4,I4,F7.2)
 9019 FORMAT (4I2,2F9.4,F6.1,I2,2F7.1,2F8.4,F9.4,F10.1,F8.4,F8.1,F8.3,  &
     &        I4,F7.2)
!jop  FORMAT(4I2,2F9.4,F6.1,I2,2F7.1,2F8.4,F9.4,F10.1,F8.4,F5.1,I4,F7.2)
 
!     Initialize USTAR, OBULEN, SFCZ0, QSW, IPCODE, AND PRATE to ZERO for hour
      USTAR = 0.0
      OBULEN = 0.0
      SFCZ0 = 0.0
!jop  ZDM    = 0.0
      QSW = 0.0
      IPCODE = 0
      PRATE = 0.0
 
      ILINE = ILINE + 1
 
      IF ( IMONTH.EQ.12 .AND. IDAY.EQ.31 .AND. IHOUR.EQ.24 ) THEN
!        End of year has been reached - check for presence of header
!        record at beginning of next year for multi-year data files.
         READ (MFUNIT,'(A132)',ERR=998,END=1000,IOSTAT=IOERRN) BUFFER
         READ (BUFFER,1900,ERR=998,IOSTAT=IOERRN) ALAT , ALON , SPEC1 , &
     &         CUSI , SPEC2 , CSSI , SPEC3 , COSI , METVER
 1900    FORMAT (2A10,T31,A6,T38,A8,T48,A6,T55,A8,T65,A6,T72,A8,T94,I5)
!        Convert character IDs to integers
         CALL STONUM(CUSI,8,FNUM,IMIT)
         IF ( IMIT.EQ.1 ) THEN
            JUSI = NINT(FNUM)
         ELSE
            JUSI = 0
         ENDIF
         CALL STONUM(CSSI,8,FNUM,IMIT)
         IF ( IMIT.EQ.1 ) THEN
            JSSI = NINT(FNUM)
         ELSE
            JSSI = 0
         ENDIF
 
         IF ( JSSI.NE.IDSURF .OR. JUSI.NE.IDUAIR ) THEN
!           Station IDs don't match runstream input, assume that header
!           record is missing.  Backspace met file and continue processing.
            BACKSPACE MFUNIT
         ELSEIF ( INDEX(BUFFER,':').EQ.0 ) THEN
!           Station IDs match, but record does not contain colon.
!           Assume it must be regular met data record, so backspace met file.
            BACKSPACE MFUNIT
         ENDIF
 
         GOTO 1001
 
!        Error reading 'header record' - assume that header record is
!        missing.  Backspace met file and continue processing.
 998     BACKSPACE MFUNIT
 
      ENDIF
 
 1001 CONTINUE
 
!
!---- READ surface scaling meteorology data based on format
!
      IF ( LDPART .OR. LWPART .OR. LDGAS .OR. LWGAS ) THEN
!        Read record from ASCII scalar parameter file using FREE format
!        with deposition variables
!
         READ (MFUNIT,*,END=1000,ERR=99,IOSTAT=IOERRN) IYEAR , IMONTH , &
     &         IDAY , IJDAY , IHOUR , SFCHF , USTAR , WSTAR , VPTGZI ,  &
     &         ZICONV , ZIMECH , OBULEN , SFCZ0 , BOWEN , ALBEDO ,      &
     &         UREF , WDREF , UREFHT , TA , TREFHT , IPCODE , PRATE ,   &
     &         RH , SFCP , NCLOUD
!        Calculate solar irradiance, QSW, from Heat Flux, Bowen ratio,
!        albedo and cloud cover, for use in gas deposition algorithm.
         IF ( SFCHF.LT.0.0 .OR. TA.LT.0.0 .OR. OBULEN.EQ.-99999.0 ) THEN
!           Hour is stable or missing
            QSW = 0.0
         ELSE
            RN = (1.+1./BOWEN)*SFCHF/0.9
            QSW = (RN*(1.+C3)-C1*TA**6+STEFB*TA**4-C2*0.1*NCLOUD)       &
     &            /(1.-ALBEDO)
         ENDIF
!
!        Set variables for dry deposition
         IF ( LDPART .OR. LDGAS ) THEN
            IF ( TA.LT.0.0 .OR. PRATE.LT.0.0 ) THEN
               WNEW = WOLD
            ELSE
! ...          Compute saturation vapor pressure based on CMAQ formula
               ESTA = 0.6112*EXP(19.83-5417.4/TA)
               ES25 = 3.167
               WNEW = WOLD + PREC1 - 0.5*F2*ESTA/ES25
               WOLD = WNEW
               F2 = WNEW/200.
               IF ( F2.LE.0.01 ) F2 = 0.01
               IF ( F2.GT.1.0 ) F2 = 1.0
            ENDIF
         ENDIF
 
      ELSE
!        Read record from ASCII scalar parameter file without deposition
!        parameters, using FREE format
!
         READ (MFUNIT,*,END=1000,ERR=99,IOSTAT=IOERRN) IYEAR , IMONTH , &
     &         IDAY , IJDAY , IHOUR , SFCHF , USTAR , WSTAR , VPTGZI ,  &
     &         ZICONV , ZIMECH , OBULEN , SFCZ0 , BOWEN , ALBEDO ,      &
     &         UREF , WDREF , UREFHT , TA , TREFHT
!
      ENDIF
 
!     Set the stability logical variables, which are needed in COMPTG
      IF ( OBULEN.GT.0.0 ) THEN
         UNSTAB = .FALSE.
         STABLE = .TRUE.
      ELSE
         UNSTAB = .TRUE.
         STABLE = .FALSE.
      ENDIF
 
!---- Initialize the profile data to missing;
!     READ profile data based on format
!
      CALL PFLINI()
      LEVEL = 1
      JFLAG = 0
      IF ( PROFRM.EQ.'FREE' ) THEN
!        Read record from ASCII profile file using FREE format; compute
!        sigma_V from sigma_A and wind speed
 
         DO WHILE ( JFLAG.EQ.0 )
            READ (MPUNIT,*,END=1000,ERR=98,IOSTAT=IOERRN) KYEAR ,       &
     &            KMONTH , KDAY , KHOUR , PFLHT(LEVEL) , JFLAG ,        &
     &            PFLWD(LEVEL) , PFLWS(LEVEL) , PFLTA(LEVEL) ,          &
     &            PFLSA(LEVEL) , PFLSW(LEVEL)
 
!           Convert the data to the required units
            CALL PFLCNV(LEVEL)
 
!           Set the number of profile levels to current index, store
!           the 'top of profile' flag, and increment level if not at top
!           Check that the level does not exceed the maximum allowable
            NPLVLS = LEVEL
            IFLAG(LEVEL) = JFLAG
            IF ( JFLAG.EQ.0 ) THEN
               LEVEL = LEVEL + 1
 
               IF ( LEVEL.GT.MXPLVL ) THEN
                  IF ( .NOT.PFLERR ) THEN
!                    WRITE Error Message: Number of profile levels
!                                         exceeds maximum allowable
                     WRITE (DUMMY,'(I8)') MXPLVL
                     CALL ERRHDL(PATH,MODNAM,'E','465',DUMMY)
                     PFLERR = .TRUE.
                     RUNERR = .TRUE.
                  ENDIF
 
!                 Limit the number of levels to the maximum allowable
                  LEVEL = MXPLVL
               ENDIF
 
            ENDIF
 
         ENDDO
 
!        Compute the vertical potential temperature gradient profile
         IF ( .NOT.RUNERR ) THEN
            NTGLVL = 0
            CALL COMPTG()
         ENDIF
 
!
      ELSE
!        READ record from ASCII profile file using the default format OR
!        the format specified by the user; compute sigma_V from sigma_A
!        and wind speed
!
         DO WHILE ( JFLAG.EQ.0 )
            READ (MPUNIT,PROFRM,END=1000,ERR=98,IOSTAT=IOERRN) KYEAR ,  &
     &            KMONTH , KDAY , KHOUR , PFLHT(LEVEL) , JFLAG ,        &
     &            PFLWD(LEVEL) , PFLWS(LEVEL) , PFLTA(LEVEL) ,          &
     &            PFLSA(LEVEL) , PFLSW(LEVEL)
 
!           Convert the data to the required units
            CALL PFLCNV(LEVEL)
 
!           Set the number of profile levels to current index, store
!           the 'top of profile' flag, and increment level if not at top
!           Check that the level does not exceed the maximum allowable
            NPLVLS = LEVEL
            IFLAG(LEVEL) = JFLAG
            IF ( JFLAG.EQ.0 ) THEN
               LEVEL = LEVEL + 1
 
               IF ( LEVEL.GT.MXPLVL ) THEN
                  IF ( .NOT.PFLERR ) THEN
!                    WRITE Error Message: Number of profile levels
!                                         exceeds maximum allowable
                     WRITE (DUMMY,'(I8)') MXPLVL
                     CALL ERRHDL(PATH,MODNAM,'E','465',DUMMY)
                     PFLERR = .TRUE.
                     RUNERR = .TRUE.
                  ENDIF
 
!                 Limit the number of levels to the maximum allowable
                  LEVEL = MXPLVL
               ENDIF
 
            ENDIF
 
         ENDDO
 
!        Compute the vertical potential temperature gradient profile
         IF ( .NOT.RUNERR ) THEN
            NTGLVL = 0
            CALL COMPTG()
         ENDIF
 
 
      ENDIF
 
!        Write Out Sample of the Meteorology Data
!        (Up to the First 24 Hours)                         ---   CALL METDAT
      IF ( ILINE.EQ.1 ) CALL METDAT
 
!     Set Meteorological Variables for Current Hour
      CALL SET_METDATA
 
      IF ( ILINE.EQ.1 ) THEN
         IF ( PM10AVE .OR. ANNUAL ) THEN
            IF ( IMSTAT(6).EQ.0 ) THEN
!              Determine MN, DY, and HR for end-of-the-year check.
!              Subtract one from start hour to set end hour for the year of data
               IENDHOUR = IHOUR - 1
               IF ( IENDHOUR.LE.0 ) IENDHOUR = 24
               IF ( IDAY.GT.1 ) THEN
                  IENDDY = IDAY - 1
                  IENDMN = IMONTH
               ELSE
                  IENDMN = IMONTH - 1
                  IF ( IENDMN.EQ.0 ) IENDMN = 12
                  IENDDY = IDYMAX(IENDMN)
               ENDIF
            ELSEIF ( FULLDATE.GT.ISDATE+1 ) THEN
!              Write Error Message:  Data File Starts Later then ISDATE
               WRITE (DUMMY,'(I8.8)') KURDAT
               CALL ERRHDL(PATH,MODNAM,'E','487',DUMMY)
               RUNERR = .TRUE.
            ENDIF
         ENDIF
      ENDIF
 
      GOTO 999
 
!---- End-of-file and error handling for METEXT
!
!     WRITE Error Messages:  Error Reading Met Data File
 
 98   CALL ERRHDL(PATH,MODNAM,'E','510','PROFFILE')
      RUNERR = .TRUE.
      GOTO 999
 
 99   CALL ERRHDL(PATH,MODNAM,'E','510','SURFFILE')
      RUNERR = .TRUE.
      GOTO 999
 
 1000 EOF = .TRUE.
 
 999  CONTINUE
      END
!*==SET_METDATA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SET_METDATA
!***********************************************************************
!                 SET_METDATA Module of ISC3 Short Term Model
!
!        PURPOSE: Sets the meteorological data variables for current hour
!
!        PROGRAMMER: ROGER BRODE
!
!        DATE:    May 12, 1999
!
!        MODIFIED:   To include call to GRDEPS, for calculation of
!                    gridded turbulence dissipation rate for use in the
!                    PVMRM algorithm.
!                    R. W. Brode, MACTEC (f/k/a PES), Inc., 07/27/04
!
!                    To include determination of the day-of-week index
!                    (1 for Weekday [M-F], 2 for Saturday, 3 for Sunday)
!                    for use in the option to vary emissions by season,
!                    hour-of-day, and day-of-week (SHRDOW).
!                    R.W. Brode, PES, Inc., 4/10/2000
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Meteorological Data Error and Status Switches
!
!        CALLED FROM:   METEXT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
!     Declare Arrays for Use With Day/Date Calcs
      INTEGER :: NDAY(12) , IDYMAX(12)
      INTEGER :: I , IA , IY , IM , ID , NL , GINDEX , NUMSW
      REAL :: SUMSW
 
!     Variable Initializations
      MODNAM = 'SET_METDATA'
      DATA NDAY/31 , 59 , 90 , 120 , 151 , 181 , 212 , 243 , 273 , 304 ,&
     &     334 , 365/
      DATA IDYMAX/31 , 29 , 31 , 30 , 31 , 30 , 31 , 31 , 30 , 31 , 30 ,&
     &     31/
 
!---- Assign the mixing height/boundary layer height to another variable
!     so it can be manipulated and massaged as required.
 
      IF ( ZICONV.GE.0.0 .AND. ZICONV.LT.1.0 ) ZICONV = 1.0
      IF ( ZIMECH.GE.0.0 .AND. ZIMECH.LT.1.0 ) ZIMECH = 1.0
 
!     Set the date variables for this hour
      CALL SET_DATES
 
!     Determine SEASON
      IF ( IMONTH.LE.2 .OR. IMONTH.EQ.12 ) THEN
         ISEAS = 1
      ELSEIF ( IMONTH.GE.3 .AND. IMONTH.LE.5 ) THEN
         ISEAS = 2
      ELSEIF ( IMONTH.GE.6 .AND. IMONTH.LE.8 ) THEN
         ISEAS = 3
      ELSEIF ( IMONTH.GE.9 .AND. IMONTH.LE.11 ) THEN
         ISEAS = 4
      ENDIF
 
!     Determine Day of Week (1 = Weekday [M-F], 2 = Saturday, 3 = Sunday).
!     Based on "Frequently Asked Questions about Calendars," Version 2.2,
!     by Claus Tondering, April 9, 2000, available on the web at URL
!     http://www.tondering.dk/claus/calendar/html
      IA = (14-IMONTH)/12
      IY = IYR - IA
      IM = IMONTH + 12*IA - 2
      ID = MOD((IDAY+IY+IY/4-IY/100+IY/400+(31*IM)/12),7)
      IF ( ID.GE.1 .AND. ID.LE.5 ) THEN
!        This is a weekday
         IDAY_OF_WEEK = 1
      ELSEIF ( ID.EQ.6 ) THEN
!        This is a Saturday
         IDAY_OF_WEEK = 2
      ELSEIF ( ID.EQ.0 ) THEN
!        This is a Sunday
         IDAY_OF_WEEK = 3
      ENDIF
      IF ( ID.EQ.0 ) THEN
!        This is a Sunday
         IDAY_OF_WEEK7 = 7
      ELSE
!        This is weekday or Saturday
         IDAY_OF_WEEK7 = ID
      ENDIF
 
      IF ( MONTH .AND. IHOUR.EQ.24 ) THEN
!        Check for the End of the Month
         IF ( IMONTH.EQ.1 .OR. (MOD(IYR,4).NE.0) .OR.                   &
     &        (MOD(IYR,100).EQ.0 .AND. MOD(IYR,400).NE.0) ) THEN
!           Not a Leap Year OR Month = January
            IF ( JDAY.EQ.NDAY(IMONTH) ) ENDMON = .TRUE.
         ELSE
!           Leap Year AND Month > January
            IF ( JDAY.EQ.NDAY(IMONTH)+1 ) ENDMON = .TRUE.
         ENDIF
      ENDIF
 
!     Check Data for Calms, Missing, Out-of-Range Values    ---   CALL METCHK
      CALL METCHK
 
!     Limit ZI to 4000 meters.
      IF ( ZICONV.GT.4000. ) ZICONV = 4000.
      IF ( ZIMECH.GT.4000. ) ZIMECH = 4000.
!     Select appropriate mixing height from convective and mechanical values
      IF ( .NOT.MSGHR .AND. OBULEN.LT.0.0 ) THEN
         ZI = AMAX1(ZICONV,ZIMECH)
      ELSEIF ( .NOT.MSGHR ) THEN
         ZI = ZIMECH
      ELSE
         ZI = -999.0
      ENDIF
!RWB  Avoid ZI = 0.0.
      IF ( ZI.GE.0.0 .AND. ZI.LT.1.0 ) ZI = 1.0
 
!     Apply ROTANG Adjustment to Wind Direction
      IF ( ROTANG.NE.0.0 ) THEN
         WDREF = WDREF - ROTANG
         IF ( WDREF.LE.0.0 ) WDREF = WDREF + 360.
      ENDIF
 
!---- Make correction to the profile wind direction(s)
!     (default, ROTANG = 0.0)
 
      IF ( ROTANG.NE.0.0 ) THEN
         DO NL = 1 , NPLVLS
            IF ( PFLWD(NL).GT.0.0 ) THEN
               PFLWD(NL) = PFLWD(NL) - ROTANG
 
               IF ( PFLWD(NL).LE.0.0 ) PFLWD(NL) = PFLWD(NL) + 360.0
 
            ENDIF
         ENDDO
      ENDIF
 
!
!---- Check the RUNERR flag - if it is FALSE, then there is sufficient
!     data to continue processing the data
      URBSTAB = .FALSE.
 
      IF ( .NOT.RUNERR ) THEN
!
         IF ( .NOT.CLMHR .AND. .NOT.MSGHR ) THEN
!           Set the stability logical variables
            IF ( OBULEN.GT.0.0 ) THEN
               UNSTAB = .FALSE.
               STABLE = .TRUE.
            ELSE
               UNSTAB = .TRUE.
               STABLE = .FALSE.
            ENDIF
 
            IF ( FULLDATE.GT.ISDATE .AND. IPROC(JDAY).EQ.1 ) THEN
!
!              Initialize the gridded profile arrays
               DO GINDEX = 1 , MXGLVL
                  GRIDSV(GINDEX) = -99.0
                  GRIDSW(GINDEX) = -99.0
                  GRIDWS(GINDEX) = -99.0
                  GRIDWD(GINDEX) = -99.0
                  GRIDTG(GINDEX) = -99.0
                  GRIDPT(GINDEX) = -99.0
                  IF ( URBAN ) THEN
                     GRDSVR(GINDEX) = -99.0
                     GRDSVU(GINDEX) = -99.0
                     GRDSWR(GINDEX) = -99.0
                     GRDSWU(GINDEX) = -99.0
                     GRDTGR(GINDEX) = -99.0
                     GRDTGU(GINDEX) = -99.0
                     GRDPTR(GINDEX) = -99.0
                     GRDPTU(GINDEX) = -99.0
                  ENDIF
               ENDDO
 
!              Get the index from the array of gridded heights that
!              corresponds to the height immediately below ZI
 
               CALL LOCATE(GRIDHT,1,MXGLVL,ZI,NDX4ZI)
 
!              Compute THETA_STAR and DTHDZ for the gridded
!              potential temperature gradient
 
               CALL TGINIT()
!
!              Profile all variables here except sv and sw; defer sv
!              and sw until u at zi is known.
!
               CALL GRDWS()
               CALL GRDWD()
               CALL GRDPTG()
               CALL GRDPT()
 
!----------    Compute density profile for PRIME
               CALL GRDDEN
 
!----------    Compute the parameter values at ZI; if ZI is above the
!              highest gridded profile level, use the value at the high-
!              est level
               IF ( NDX4ZI.LT.MXGLVL ) THEN
                  CALL GINTRP(GRIDHT(NDX4ZI),GRIDWS(NDX4ZI),            &
     &                        GRIDHT(NDX4ZI+1),GRIDWS(NDX4ZI+1),ZI,     &
     &                        UATZI)
                  CALL GINTRP(GRIDHT(NDX4ZI),GRIDPT(NDX4ZI),            &
     &                        GRIDHT(NDX4ZI+1),GRIDPT(NDX4ZI+1),ZI,     &
     &                        PTATZI)
 
               ELSE
                  UATZI = GRIDWS(MXGLVL)
                  PTATZI = GRIDPT(MXGLVL)
 
               ENDIF
!
!              Add turbulence variables here
!
               CALL GRDSV()
 
!              Obtain residual turbulence value before calling GRDSW
               NUMSW = 0
               SUMSW = 0.0
 
               DO I = 1 , NPLVLS
                  IF ( PFLHT(I).GE.ZI .AND. PFLSW(I).GE.0.0 ) THEN
                     NUMSW = NUMSW + 1
                     SUMSW = SUMSW + PFLSW(I)
                  ENDIF
               ENDDO
 
               IF ( NUMSW.GT.0 ) THEN
                  SWRMAX = SUMSW/NUMSW
               ELSE
                  SWRMAX = 0.02*UATZI
               ENDIF
 
               CALL GRDSW()
 
               IF ( NDX4ZI.LT.MXGLVL ) THEN
                  CALL GINTRP(GRIDHT(NDX4ZI),GRIDSV(NDX4ZI),            &
     &                        GRIDHT(NDX4ZI+1),GRIDSV(NDX4ZI+1),ZI,     &
     &                        SVATZI)
                  CALL GINTRP(GRIDHT(NDX4ZI),GRIDSW(NDX4ZI),            &
     &                        GRIDHT(NDX4ZI+1),GRIDSW(NDX4ZI+1),ZI,     &
     &                        SWATZI)
               ELSE
                  SVATZI = GRIDSV(MXGLVL)
                  SWATZI = GRIDSW(MXGLVL)
               ENDIF
 
!              Compute gridded profile of epsilon for PVMRM option
               IF ( PVMRM ) CALL GRDEPS
!
!              Compute Urban Profiles if Needed
               IF ( URBAN .AND. STABLE ) THEN
                  ZIRUR = ZI
                  CALL URBCALC
                  CALL GRDURBAN
               ENDIF
 
            ENDIF
 
         ELSE
!           To correctly compute the smoothed PBL heights, the previous
!           hour's smoothed height must be reset to missing, otherwise
!           the last nonmissing value is used in the computation.
 
            HNPREV = -999.0
 
         ENDIF
 
!        Write every other level of gridded profile data to a file
!        up to a height of 1000 m;
 
      ENDIF
 
!     Set Appropriate Wind Speed Category Index
      IF ( UREF.LE.UCAT(1) ) THEN
         IUCAT = 1
      ELSEIF ( UREF.LE.UCAT(2) ) THEN
         IUCAT = 2
      ELSEIF ( UREF.LE.UCAT(3) ) THEN
         IUCAT = 3
      ELSEIF ( UREF.LE.UCAT(4) ) THEN
         IUCAT = 4
      ELSEIF ( UREF.LE.UCAT(5) ) THEN
         IUCAT = 5
      ELSE
         IUCAT = 6
      ENDIF
 
!     Set Stability Category based on Golder (1972) for use with
!     TOXICS Area Source Optimizations
      CALL LTOPG(KST)
 
      IF ( MSGHR ) THEN
         IF ( .NOT.MSGPRO ) THEN
!           Set Flag for Runtime Met. Error to Prevent Further Calculations
            RUNERR = .TRUE.
!           WRITE Error Message:  Missing Meteorological Data
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'E','460',DUMMY)
         ELSE
!           WRITE Informational Message:  Missing Meteorological Data
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'I','460',DUMMY)
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==SET_DATES.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE SET_DATES
!***********************************************************************
!                 SET_DATES Module of ISC3 Short Term Model
!
!        PURPOSE: Sets the date variables for current hour
!
!        PROGRAMMER: ROGER BRODE
!
!        DATE:    May 12, 1999
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Meteorological Data Error and Status Switches
!
!        CALLED FROM:   SET_METDATA
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'SET_DATES'
 
!     Determine The Current Julian Day and Calculate Current Gregorian Date
!     First Convert Year to 4-Digit Value
      IF ( IYEAR.GE.ISTRT_WIND .AND. IYEAR.LE.99 ) THEN
         IYR = ISTRT_CENT*100 + IYEAR
      ELSEIF ( IYEAR.LT.ISTRT_WIND ) THEN
         IYR = (ISTRT_CENT+1)*100 + IYEAR
      ELSE
!        Input IYEAR must be 4-digit:  Save to IYR and convert to 2-digit
         IYR = IYEAR
         IYEAR = IYR - 100*(IYR/100)
      ENDIF
 
!     Determine Julian Day (Day of Year) Number, JDAY    ---   CALL JULIAN
      CALL JULIAN(IYR,IMONTH,IDAY,JDAY)
 
!     Calculate 8-digit Integer Variable for Current Date/Hour, KURDAT
!     and 10-digit Integer Variable (with 4-digit year), FULLDATE
      KURDAT = IYEAR*1000000 + IMONTH*10000 + IDAY*100 + IHOUR
      IF ( IYR.GE.2148 ) THEN
!        Write Error Message:  Input Year is > 2147.
         WRITE (DUMMY,'("YR= ",I4)') IYR
         CALL ERRHDL(PATH,MODNAM,'E','365',DUMMY)
         RUNERR = .TRUE.
         FULLDATE = 2147123124
      ELSE
         FULLDATE = IYR*1000000 + IMONTH*10000 + IDAY*100 + IHOUR
      ENDIF
 
!     Check for 4-digit year input for profile data
      IF ( KYEAR.GE.100 ) KYEAR = KYEAR - 100*(KYEAR/100)
      KURPFL = KYEAR*1000000 + KMONTH*10000 + KDAY*100 + KHOUR
 
      CONTINUE
      END
!*==METCHK.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE METCHK
!***********************************************************************
!                 METCHK Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Performs Various Checks and Quality Assurance of
!                 One Hour of Meteorological Data
!
!        PROGRAMMER: JEFF WANG, ROGER BRODE
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To skip date sequence checking for EVENT processing,
!                    which is handled separately by EV_CHKDAT.
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Meteorological Data Error and Status Switches
!
!        CALLED FROM:   METEXT
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'METCHK'
      CLMHR = .FALSE.
      MSGHR = .FALSE.
 
!----    Check date for record out of sequence on the surface
!        scaling file - NOCHKD=.TRUE. means no date check   ---   CALL CHKDAT
      IF ( .NOT.NOCHKD .AND. .NOT.EVONLY ) CALL CHKDAT
 
!---- Compare date & time in the scaling and profile files  ---   CALL CMPDAT
      CALL CMPDAT
 
!---- Check Data for Calm Winds                             ---   CALL CHKCLM
      CALL CHKCLM
 
!----    Check data for missing data indicators             ---   CALL CHKMSG
      IF ( .NOT.CLMHR ) CALL CHKMSG
 
!---- Check Data for Out-of-Range Values                    ---   CALL METQA
      CALL METQA
 
      CONTINUE
      END
!*==CHKDAT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CHKDAT
!***********************************************************************
!                 CHKDAT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Checks Meteorological Data for Record Out of Sequence
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To remove support for unformatted meteorological
!                    data files.
!                    R.W. Brode, PES, Inc., 4/10/2000
!
!        MODIFIED:   To incorporate modifications to date processing
!                    for Y2K compliance.  Specifically, allow for
!                    transition from KURDAT=99123124 to KURDAT=00010101
!                    for new century.
!                    R.W. Brode, PES, Inc., 5/12/99
!
!        INPUTS:  Date Variable
!
!        OUTPUTS: Date Error Messages
!
!        CALLED FROM:   METCHK
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'CHKDAT'
 
!     Check for Record Out of Sequence
      IF ( IPDATE.NE.0 ) THEN
         IF ( KURDAT.LE.IPDATE ) THEN
!           Check for date crossing century mark.
            IF ( KURDAT.NE.10101 .OR. IPDATE.NE.99123124 ) THEN
!              WRITE Error Message - Record Out of Sequence
               WRITE (DUMMY,'(I8.8)') KURDAT
               CALL ERRHDL(PATH,MODNAM,'E','450',DUMMY)
               RUNERR = .TRUE.
            ENDIF
         ELSEIF ( IHOUR.NE.1 .AND. (KURDAT-IPDATE).NE.1 ) THEN
!           WRITE Error Message - Record Out of Sequence
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'E','450',DUMMY)
            RUNERR = .TRUE.
         ELSEIF ( IHOUR.EQ.1 .AND. IPHOUR.NE.24 ) THEN
!           WRITE Error Message - Record Out of Sequence
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'E','450',DUMMY)
            RUNERR = .TRUE.
         ENDIF
      ENDIF
 
      CONTINUE
      END
!*==CMPDAT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CMPDAT
!***********************************************************************
!             CMPDAT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Compares the date and time from the scalar and profile
!                 files
!
!        PROGRAMMER: Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Date variables
!
!        OUTPUTS: Date error messages
!
!        ASSUMPTIONS:   <none>
!
!        CALLED FROM:   METCHK
!***********************************************************************
 
!---- Variable declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!---- Variable initializations
      MODNAM = 'CMPDAT'
 
!---- Check for a date mismatch between the scalar and profile files
!
      IF ( KURDAT.NE.KURPFL ) THEN
!        WRITE Error Message - Date mismatch
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'E','456',DUMMY)
         RUNERR = .TRUE.
!
      ENDIF
 
      CONTINUE
      END
!*==CHKCLM.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
!
      SUBROUTINE CHKCLM
!***********************************************************************
!                 CHKCLM Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Checks One Hour Meteorological Data for Calm Winds
!
!        PROGRAMMER: ROGER BRODE, JEFF WANG
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Calm Hour Flag, CLMHR, and Message
!
!        CALLED FROM:   METCHK
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'CHKCLM'
 
!     Check Data for Calm Winds (<= Threshold Value, UMIN)
!     The Threshold Value is Initially Set = 0.0
      IF ( UREF.GE.0.0 .AND. UREF.LE.UMIN ) THEN
         CLMHR = .TRUE.
!        WRITE Informational Message: Calm Hour
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'I','440',DUMMY)
!        Note that NOCALM option is not available in AERMOD.
!        CLMPRO is always .TRUE.
         IF ( .NOT.CLMPRO ) UREF = 1.0
      ENDIF
 
      CONTINUE
      END
!*==CHKMSG.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE CHKMSG
!***********************************************************************
!                 CHKMSG Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Checks One Hour Meteorological Data for Missing Data
!
!        PROGRAMMER: JEFF WANG
!
!        DATE:    March 2, 1992
!
!        MODIFIED:  To Change Wind Direction Range Check - 10/26/2004
!
!        MODIFIED:  To Change Temperature Range Check - 9/29/92
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Meteorological Data Error and Status Switches
!
!        CALLED FROM:   METCHK
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'CHKMSG'
 
!---- Check Data for Missing Data Indicators
!
!     Wind speed (meters/second)
      IF ( UREF.GE.90.0 .OR. UREF.LT.0.0 ) THEN
         MSGHR = .TRUE.
!
!     Wind direction (degrees from north)
      ELSEIF ( (WDREF.GT.900.0) .OR. (WDREF.LE.-9.0) ) THEN
         MSGHR = .TRUE.
!
!     Ambient temperature (kelvins)
      ELSEIF ( (TA.GT.900.0) .OR. (TA.LE.0.0) ) THEN
         MSGHR = .TRUE.
!
!     Monin-Obukhov length (meters)
      ELSEIF ( OBULEN.LT.-99990.0 ) THEN
         MSGHR = .TRUE.
 
!     Convective Mixing height (meters)
      ELSEIF ( OBULEN.LT.0.0 .AND.                                      &
     &         ((ZICONV.GT.90000.0) .OR. (ZICONV.LT.0.0)) ) THEN
         MSGHR = .TRUE.
!
!     Mechanical Mixing height (meters)
      ELSEIF ( (ZIMECH.GT.90000.0) .OR. (ZIMECH.LT.0.0) ) THEN
         MSGHR = .TRUE.
!
!     Surface friction velocity (meters/second)
      ELSEIF ( USTAR.LT.0.0 ) THEN
         MSGHR = .TRUE.
 
!     Convective velocity scale (meters/second)
      ELSEIF ( WSTAR.LT.0.0 .AND.                                       &
     &         (OBULEN.LT.0.0 .AND. OBULEN.GT.-99990.0) ) THEN
         MSGHR = .TRUE.
!
      ENDIF
 
      CONTINUE
      END
!*==METQA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE METQA
!***********************************************************************
!                 METQA Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Performs Quality Assurance Checks for
!                 One Hour of Meteorological Data
!
!        PROGRAMMER: JEFF WANG, ROGER BRODE
!
!        DATE:    March 2, 1992
!
!        MODIFIED:  To adjust warning limit for USTAR from 2.0 to 4.0,
!                   adjust warning limit for WSTAR from 3.0 to 4.0, and
!                   to minimize duplication of warning messages for
!                   missing hours.
!                   R. Brode, MACTEC/PES, 10/26/2004
!
!        MODIFIED:  To check for errors reading surface variables for
!                   new deposition algorithms.  R. Brode, PES, 12/6/94
!
!        MODIFIED:  To Change Temperature Range Check Lower Limit To
!                   230 K - 9/29/92
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Meteorological Data Error and Status Switches
!
!        CALLED FROM:   METCHK
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: NL
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'METQA'
 
!---- Check Data for Out-of-Range Values:
 
!---- Wind direction:
      IF ( (WDREF.LT.0.0 .AND. WDREF.GT.-9.0) .OR.                      &
     &     (WDREF.GT.360.0 .AND. WDREF.LT.900.0) ) THEN
!        WRITE Warning Message: Invalid Wind Dir'n
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','410',DUMMY)
      ENDIF
 
      IF ( WDREF.EQ.0.0 ) WDREF = 360.0
 
      DO NL = 1 , NPLVLS
         IF ( PFLWD(NL).EQ.0.0 ) PFLWD(NL) = 360.0
      ENDDO
 
!---- Wind speed range:
      IF ( UREF.LT.0.0 .AND. UREF.GT.-9.0 ) THEN
!        WRITE Warning Message: Invalid Wind Speed
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','420',DUMMY)
      ENDIF
!
      IF ( UREF.GT.30.0 .AND. UREF.LT.90.0 ) THEN
!        WRITE Warning Message: Wind Speed Over 30m/s
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','420',DUMMY)
      ENDIF
 
!---- Wind data reference height:
      IF ( UREFHT.GT.100.0 ) THEN
!
!        -----------------------------------------------
!        Height of the wind data to be used in the
!        computation is greater than 100m -  warn the user
!        -----------------------------------------------
 
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','475',DUMMY)
 
      ENDIF
 
!---- Ambient temperature:
      IF ( (TA.LT.220.0 .AND. TA.GT.0.0) .OR.                           &
     &     (TA.GT.330.0 .AND. TA.LT.900.0) ) THEN
!        WRITE Warning Message: Ambient Temperature May be Out-of-Range
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','430',DUMMY)
      ENDIF
 
!---- Friction velocity (meters/second):
      IF ( USTAR.GT.4.0 ) THEN
!        WRITE Warning Message: Friction velocity may be too large
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','432',DUMMY)
      ENDIF
 
!---- Convective velocity (meters/second):
      IF ( WSTAR.GT.4.00 ) THEN
!        WRITE Warning Message: Convective velocity may be too large
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','438',DUMMY)
      ELSEIF ( WSTAR.EQ.0.0 ) THEN
!        WRITE Warning Message: Convective velocity = 0.0, set to 0.001
         WRITE (DUMMY,'(I8.8)') KURDAT
         CALL ERRHDL(PATH,MODNAM,'W','438',DUMMY)
         WSTAR = 0.001
      ENDIF
 
!---- Surface roughness length (m):
      IF ( SFCZ0.LT.0.001 ) THEN
         IF ( .NOT.MSGHR .AND. .NOT.CLMHR ) THEN
!           WRITE Warning Message:  Surface roughness length out-of-range
            WRITE (DUMMY,'(I8.8)') KURDAT
            CALL ERRHDL(PATH,MODNAM,'W','435',DUMMY)
         ENDIF
!        Set to 0.001 to avoid divide-by-zero error
         SFCZ0 = 0.001
      ENDIF
 
!---- Check for precipitation rate out of range
!        Assume precipitation is missing, set to 0.0
      IF ( PRATE.LT.0.0 .OR. PRATE.EQ.99 ) PRATE = 0.0
 
      CONTINUE
      END
!*==METDAT.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE METDAT
!***********************************************************************
!                 METDAT Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Print Out The Summary Of The Meteorology Data
!
!        PROGRAMMER: JEFF WANG
!        MODIFIED BY D. Strimaitis, SRC (for Wet & Dry DEPOSITION)
!
!        DATE:    November 8, 1993
!
!        MODIFIED:   To remove support for unformatted meteorological
!                    data files.
!                    R.W. Brode, PES, Inc., 4/10/2000
!
!        MODIFIED BY R.W. Brode, PES, to avoid print string > 132 chars.
!        (DATE:    December 29, 1997)
!
!        MODIFIED BY D. Strimaitis, SRC (for Dry DEPOSITION)
!        (DATE:    February 15, 1993)
!
!        INPUTS:  Meteorology Input Data
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   METEXT, MEREAD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IHR , ILMAX , IJDAY
!     Declare Arrays for storing date variables
      INTEGER IMNTH(24) , INDY(24) , INHR(24)
 
!     Variable Initializations
      MODNAM = 'METDAT'
 
!---- WRITE Out Header Information
      CALL HEADER
      WRITE (IOUNIT,9011)
!
!---- FORMAT statements
!
 9011 FORMAT (/12X,'*** UP TO THE FIRST 24 HOURS OF ',                  &
     &        'METEOROLOGICAL DATA ***'/)
      WRITE (IOUNIT,9016) METINP , PROINP , METFRM , PROFRM
 9016 FORMAT (3X,'Surface file:   ',A60,/,3X,'Profile file:   ',A60,/,  &
     &        3X,'Surface format: ',A105,/,3X,'Profile format: ',A105)
      WRITE (IOUNIT,9020) IDSURF , IDUAIR , SFNAME , UANAME , ISYEAR ,  &
     &                    IUYEAR
 9020 FORMAT (3X,'Surface station no.: ',I8,18X,                        &
     &        'Upper air station no.: ',I8/18X,'Name: ',A40,3X,'Name: ',&
     &        A40/18X,'Year: ',I6,37X,'Year: ',I6)
      WRITE (IOUNIT,9024)
 9024 FORMAT (/' First 24 hours of scalar data')
      IF ( LDPART .OR. LDGAS .OR. LWPART .OR. LWGAS ) THEN
         WRITE (IOUNIT,99025)
99025    FORMAT (' YR',' MO',' DY',' HR','     H0','     U*','     W*', &
     &           '  DT/DZ',' ZICNV',' ZIMCH','  M-O LEN','  Z0 ',       &
     &           'BOWEN','  ALB','  REF WS','   WD','   HT','  REF TA', &
     &           '  HT',' IPCOD',' PRATE','  RH',' SFCP',               &
     &           ' CCVR'/66('- '))
      ELSE
         WRITE (IOUNIT,9025)
 9025    FORMAT (' YR',' MO',' DY',' JDY',' HR','     H0','     U*',    &
     &           '     W*','  DT/DZ',' ZICNV',' ZIMCH','  M-O LEN',     &
     &           '    Z0','  BOWEN',' ALBEDO','  REF WS','   WD',       &
     &           '     HT','  REF TA','     HT',/60('- '))
      ENDIF
 
!---- Since the first record has been read, write out the data to
!     IOUNIT, then read the next record from the scalar file
 
      DO I = 1 , 24
!
 
!        We use the IF..ELSE structure because the Julian day that
!        is passed in COMMON is JDAY, not IJDAY.
         IF ( I.EQ.1 ) THEN
 
            IF ( LDPART .OR. LWPART .OR. LDGAS .OR. LWGAS ) THEN
               WRITE (IOUNIT,99026) IYEAR , IMONTH , IDAY , IHOUR ,     &
     &                              SFCHF , USTAR , WSTAR , VPTGZI ,    &
     &                              ZICONV , ZIMECH , OBULEN , SFCZ0 ,  &
     &                              BOWEN , ALBEDO , UREF , WDREF ,     &
     &                              UREFHT , TA , TREFHT , IPCODE ,     &
     &                              PRATE , RH , SFCP , NCLOUD
            ELSE
               WRITE (IOUNIT,9026) IYEAR , IMONTH , IDAY , JDAY ,       &
     &                             IHOUR , SFCHF , USTAR , WSTAR ,      &
     &                             VPTGZI , ZICONV , ZIMECH , OBULEN ,  &
     &                             SFCZ0 , BOWEN , ALBEDO , UREF ,      &
     &                             WDREF , UREFHT , TA , TREFHT
            ENDIF
 
         ELSE
            IF ( IYEAR.GE.100 ) IYEAR = IYEAR - 100*(IYEAR/100)
            IF ( LDPART .OR. LWPART .OR. LDGAS .OR. LWGAS ) THEN
               WRITE (IOUNIT,99026) IYEAR , IMONTH , IDAY , IHOUR ,     &
     &                              SFCHF , USTAR , WSTAR , VPTGZI ,    &
     &                              ZICONV , ZIMECH , OBULEN , SFCZ0 ,  &
     &                              BOWEN , ALBEDO , UREF , WDREF ,     &
     &                              UREFHT , TA , TREFHT , IPCODE ,     &
     &                              PRATE , RH , SFCP , NCLOUD
            ELSE
               WRITE (IOUNIT,9026) IYEAR , IMONTH , IDAY , IJDAY ,      &
     &                             IHOUR , SFCHF , USTAR , WSTAR ,      &
     &                             VPTGZI , ZICONV , ZIMECH , OBULEN ,  &
     &                             SFCZ0 , BOWEN , ALBEDO , UREF ,      &
     &                             WDREF , UREFHT , TA , TREFHT
            ENDIF
 
         ENDIF
 
         IF ( LDPART .OR. LWPART .OR. LDGAS .OR. LWGAS ) THEN
!           Read record from ASCII scalar parameter file using FREE format
!           with deposition variables
            READ (MFUNIT,*,END=999,ERR=99,IOSTAT=IOERRN) IYEAR ,        &
     &            IMONTH , IDAY , IJDAY , IHOUR , SFCHF , USTAR ,       &
     &            WSTAR , VPTGZI , ZICONV , ZIMECH , OBULEN , SFCZ0 ,   &
     &            BOWEN , ALBEDO , UREF , WDREF , UREFHT , TA , TREFHT ,&
     &            IPCODE , PRATE , RH , SFCP , NCLOUD
!
         ELSE
!           Read hourly records from ASCII file using FREE format
!           without deposition variables
            READ (MFUNIT,*,END=999,ERR=99,IOSTAT=IOERRN) IYEAR ,        &
     &            IMONTH , IDAY , IJDAY , IHOUR , SFCHF , USTAR ,       &
     &            WSTAR , VPTGZI , ZICONV , ZIMECH , OBULEN , SFCZ0 ,   &
     &            BOWEN , ALBEDO , UREF , WDREF , UREFHT , TA , TREFHT
!
         ENDIF
!
      ENDDO
!
!---- REWIND met file, skip first record (with the latitude &
!     longitude), and reset variables to the first hour in the file.
!
 999  CONTINUE
      REWIND MFUNIT
      READ (MFUNIT,'(I2)') IDUM
!
      IF ( LDPART .OR. LWPART .OR. LDGAS .OR. LWGAS ) THEN
!        Read record from ASCII scalar parameter file using FREE format
!        with deposition variables
         READ (MFUNIT,*,END=999,ERR=99,IOSTAT=IOERRN) IYEAR , IMONTH ,  &
     &         IDAY , IJDAY , IHOUR , SFCHF , USTAR , WSTAR , VPTGZI ,  &
     &         ZICONV , ZIMECH , OBULEN , SFCZ0 , BOWEN , ALBEDO ,      &
     &         UREF , WDREF , UREFHT , TA , TREFHT , IPCODE , PRATE ,   &
     &         RH , SFCP , NCLOUD
 
!
      ELSE
!        Read hourly records from ASCII file using FREE format
!        without deposition variables
         READ (MFUNIT,*,END=999,ERR=99,IOSTAT=IOERRN) IYEAR , IMONTH ,  &
     &         IDAY , IJDAY , IHOUR , SFCHF , USTAR , WSTAR , VPTGZI ,  &
     &         ZICONV , ZIMECH , OBULEN , SFCZ0 , BOWEN , ALBEDO ,      &
     &         UREF , WDREF , UREFHT , TA , TREFHT
 
!
      ENDIF
 
!---- Write the first hour of profile data to IOUNIT; only 1 hour
!        is written because there can be up to 20 levels of data, which
!        could create a large amount of output.
 
      IF ( NPLVLS.GT.10 ) CALL HEADER
 
      WRITE (IOUNIT,9034)
 9034 FORMAT (//,' First hour of profile data')
      WRITE (IOUNIT,9035)
 9035 FORMAT (' YR',' MO',' DY',' HR',' HEIGHT',' F','  WDIR',          &
     &        '    WSPD',' AMB_TMP',' sigmaA','  sigmaW','  sigmaV')
      DO I = 1 , NPLVLS
         WRITE (IOUNIT,9036) KYEAR , KMONTH , KDAY , KHOUR , PFLHT(I) , &
     &                       IFLAG(I) , PFLWD(I) , PFLWS(I) , PFLTA(I) ,&
     &                       PFLSA(I) , PFLSW(I) , PFLSV(I)
 9036    FORMAT (1X,4(I2.2,1X),F6.1,1X,I1,1X,F5.0,1X,F7.2,1X,F7.1,1X,   &
     &           F6.1,1X,F7.2,1X,F7.2)
      ENDDO
      WRITE (IOUNIT,9037)
 9037 FORMAT (/' F indicates top of profile (=1) or below (=0)')
 
      GOTO 9999
 
!---- WRITE Error Message:  Error Reading Met Data Input File
!
 99   CALL ERRHDL(PATH,MODNAM,'E','510','SURFFILE')
      RUNERR = .TRUE.
 
 9999 CONTINUE
 9026 FORMAT (1X,3(I2.2,1X),I3,1X,I2.2,1X,F6.1,1X,3(F6.3,1X),2(F5.0,1X),&
     &        F8.1,1X,F5.2,1X,2(F6.2,1X),F7.2,1X,F5.0,3(1X,F6.1))
99026 FORMAT (1X,3(I2.2,1X),I2.2,1X,F6.1,1X,3(F6.3,1X),2(F5.0,1X),F8.1, &
     &        1X,F4.2,1X,2(F4.2,1X),F7.2,1X,F5.0,1X,F4.0,1X,F6.1,1X,    &
     &        F4.0,I3,F7.2,F6.0,F6.0,I3)
      END
!*==METSUM.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE METSUM
!***********************************************************************
!                 METSUM Module of ISC3 Short Term Model - ISCST3
!
!        PURPOSE: Print Out The Summary Of The Meteorology Data
!                 Sampled Using the SCIM Option
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    April 14, 1998
!
!        MODIFIED:  To output missing temperatures correctly in the
!                   SCIM met data file.
!                   R.W. Brode, PES, Inc., - 02/25/02
!
!        INPUTS:  Meteorology Input Data
!
!        OUTPUTS: Printed Model Outputs
!
!        CALLED FROM:   HRLOOP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      REAL :: PFLTEMP
      INTEGER :: I , ILMAX
 
!     Variable Initializations
      MODNAM = 'METSUM'
 
!     WRITE Out Header Information
      IF ( ILINE.EQ.IFIRSTHR ) THEN
!        Write Surface Data
         WRITE (ISUNIT,9011)
 
 9011    FORMAT (/1X,'*** SUMMARY OF THE SAMPLED SURFACE ',             &
     &           'METEOROLOGICAL DATA USED WITH THE SCIM OPTION ***'/)
         ILMAX = MIN(80,ILEN_FLD)
         WRITE (ISUNIT,9016) METINP(1:ILMAX) , METFRM
 9016    FORMAT (1X,'Surface file:   ',A80,/,1X,'Surface format: ',A105)
         WRITE (ISUNIT,9020) IDSURF , IDUAIR , SFNAME , UANAME ,        &
     &                       ISYEAR , IUYEAR
 9020    FORMAT (1X,'SURFACE STATION NO.: ',I6,20X,                     &
     &           'UPPER AIR STATION NO.: ',I6/16X,'NAME: ',A40,3X,      &
     &           'NAME: ',A40/16X,'YEAR: ',I6,37X,'YEAR: ',I6/)
         WRITE (ISUNIT,9025)
 9025    FORMAT (' YR',' MO',' DY',' JDY',' HR','     H0','     U*',    &
     &           '     W*','  DT/DZ',' ZICNV',' ZIMCH','  M-O LEN',     &
     &           '    Z0','  BOWEN',' ALBEDO','  REF WS','   WD',       &
     &           '     HT','  REF TA','     HT',/60(' -'))
 
!        Write Profile Data
         WRITE (IPUNIT,99011)
 
99011    FORMAT (/1X,'*** SUMMARY OF THE SAMPLED PROFILE ',             &
     &           'METEOROLOGICAL DATA USED WITH THE SCIM OPTION ***'/)
         ILMAX = MIN(80,ILEN_FLD)
         WRITE (IPUNIT,99016) PROINP(1:ILMAX) , PROFRM
99016    FORMAT (1X,'Profile file:   ',A80,/,1X,'Profile format: ',A105)
         WRITE (IPUNIT,99020) IDSURF , IDUAIR , SFNAME , UANAME ,       &
     &                        ISYEAR , IUYEAR
99020    FORMAT (1X,'SURFACE STATION NO.: ',I6,20X,                     &
     &           'UPPER AIR STATION NO.: ',I6/16X,'NAME: ',A40,3X,      &
     &           'NAME: ',A40/16X,'YEAR: ',I6,37X,'YEAR: ',I6/)
         WRITE (IPUNIT,99025)
99025    FORMAT (' YR',' MO',' DY',' HR',' HEIGHT',' F','  WDIR',       &
     &           '    WSPD',' AMB_TMP',' sigmaA','  sigmaW',/29(' -'))
      ENDIF
 
      WRITE (ISUNIT,9026) IYEAR , IMONTH , IDAY , JDAY , IHOUR , SFCHF ,&
     &                    USTAR , WSTAR , VPTGZI , ZICONV , ZIMECH ,    &
     &                    OBULEN , SFCZ0 , BOWEN , ALBEDO , UREF ,      &
     &                    WDREF , UREFHT , TA , TREFHT
 9026 FORMAT (1X,3(I2.2,1X),I3,1X,I2.2,1X,F6.1,1X,3(F6.3,1X),2(F5.0,1X),&
     &        F8.1,1X,F5.2,1X,2(F6.2,1X),F7.2,1X,F5.0,3(1X,F6.1))
 
      DO I = 1 , NPLVLS
         IF ( PFLTA(I).EQ.-999.0 ) THEN
            PFLTEMP = PFLTA(I)
         ELSE
            PFLTEMP = PFLTA(I) - DCTODK
         ENDIF
         WRITE (IPUNIT,99026) KYEAR , KMONTH , KDAY , KHOUR , PFLHT(I) ,&
     &                        IFLAG(I) , PFLWD(I) , PFLWS(I) , PFLTEMP ,&
     &                        PFLSW(I) , PFLSV(I)
99026    FORMAT (1X,4(I2.2,1X),F6.1,1X,I1,1X,F5.0,1X,F7.2,1X,F7.1,1X,   &
     &           F6.1,1X,F7.2)
      ENDDO
 
 
      CONTINUE
      END
!*==PFLCNV.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
 
      SUBROUTINE PFLCNV(LEVEL)
!***********************************************************************
!             PFLCNV Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Converts data in profile file to the required units
!
!        PROGRAMMER: Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        INPUTS:  Hourly profile data
!
!        OUTPUTS: Hourly profile data converted to required units
!
!        Revisions:
!                    R. Brode, PES, Inc.                  25 Feb 2002
!                    Modify upper limit on temperature from 900 to 90
!                    so that a value of 99.0 will be treated as
!                    missing
!
!                    R. Brode, PES, Inc.                  22 Jan 1998
!                    Check for wind direction > 900. and recode
!                    as missing (-999.0).
!
!                    J. Paumier, PES, Inc                 16 Dec 1994
!                    Fixed the logic in determining if ambient
!                    temperature is missing in the conversion from
!                    Celsius to kelvin
!
!        ASSUMPTIONS:
!
!        CALLED FROM:  METEXT
!***********************************************************************
 
!---- Variable Declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER LEVEL
      REAL SIGRAD , EPSIL , USUBV
 
!
!---- Variable Initializations
!
      MODNAM = 'PFLCNV'
!-----------------------------------------------------------------------
 
!     Change the missing value indicator for wind speed to -99.0
 
      IF ( PFLWS(LEVEL).LT.0.0 .OR. PFLWS(LEVEL).GT.90.0 ) PFLWS(LEVEL) &
     &     = -99.0
 
!     Change the wind direction from 0.0 to 360.0 if wind speed is nonzero
 
      IF ( PFLWS(LEVEL).GT.0.0 .AND. PFLWD(LEVEL).EQ.0.0 ) THEN
         PFLWD(LEVEL) = 360.0
 
      ELSEIF ( PFLWD(LEVEL).GT.900.0 ) THEN
         PFLWD(LEVEL) = -999.0
 
      ELSEIF ( PFLWS(LEVEL).EQ.0.0 .AND. PFLWD(LEVEL).EQ.0.0 ) THEN
         PFLWS(LEVEL) = -99.0
         PFLWD(LEVEL) = -999.0
 
      ENDIF
 
!     Compute sigmaV from nonmissing wind speed and sigmaTHETA
 
      IF ( PFLWS(LEVEL).GT.0.0 .AND. PFLSA(LEVEL).GE.0.0 .AND.          &
     &     PFLSA(LEVEL).LT.99.0 ) THEN
         SIGRAD = PFLSA(LEVEL)*DTORAD
         EPSIL = SIN(SIGRAD)*(1.0-GSIGV*SIGRAD)
         USUBV = PFLWS(LEVEL)*SQRT(1.0-EPSIL*EPSIL)
         PFLSV(LEVEL) = SIGRAD*USUBV
!        Compare to minimum value PARAMETER, SVMIN = 0.2
         PFLSV(LEVEL) = AMAX1(SVMIN,PFLSV(LEVEL))
 
      ELSE
         PFLSV(LEVEL) = -99.0
 
      ENDIF
 
!     Convert temperature from degrees Celsius to kelvins
 
      IF ( PFLTA(LEVEL).GT.-90.0 .AND. PFLTA(LEVEL).LT.90.0 ) THEN
         PFLTA(LEVEL) = PFLTA(LEVEL) + DCTODK
 
      ELSE
         PFLTA(LEVEL) = -999.0
 
      ENDIF
 
!     Change the missing value indicator for sigmaW to -99.0
 
      IF ( PFLSW(LEVEL).LT.0.0 .OR. PFLSW(LEVEL).GT.90.0 ) THEN
         PFLSW(LEVEL) = -99.0
      ELSE
!        Compare to minimum value PARAMETER, SWMIN = 0.02
         PFLSW(LEVEL) = AMAX1(SWMIN,PFLSW(LEVEL))
      ENDIF
 
      CONTINUE
      END
!*==PFLINI.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE PFLINI()
!***********************************************************************
!             PFLINI Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Initializes the observed profile arrays to missing
!
!        PROGRAMMER: Jim Paumier, PES, Inc.
!
!        DATE:    September 30, 1993
!
!        INPUTS:  None
!
!        OUTPUTS: Initialized observed profile arrays
!
!        ASSUMPTIONS:
!
!        CALLED FROM:  METEXT
!***********************************************************************
!
!---- Variable Declarations
!
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I , J
 
      SAVE 
 
!
!---- Variable Initializations
!
      MODNAM = 'PFLINI'
      PATH = 'MX'
 
!.......................................................................
!
      DO I = 1 , MXPLVL
         IFLAG(I) = 0
         PFLHT(I) = -99.0
         PFLWS(I) = -99.0
         PFLWD(I) = -99.0
         PFLTA(I) = -99.0
         PFLSA(I) = -99.0
         PFLSW(I) = -99.0
         PFLSV(I) = -99.0
         PFLTG(I) = -99.0
         PFLTGZ(I) = -99.0
      ENDDO
 
      CONTINUE
      END
!*==ZIAVER.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE ZIAVER(NLVLS,HTS,PARRAY,ZI,NDXBLW,PBLAVG,VALZI)
!***********************************************************************
!             ZIAVER Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     To compute the average value of the parameter between
!                the surface and the mixing height
!
!   Input:       Number of levels in the profile (NLVLS)
!                Array of gridded profile heights (HTS)
!                Parameter array (PARRAY)
!                Boundary layer height (ZI) (or stack height, if higher)
!                Index of the level gridded profile height immediately
!                   below ZI (NDXBLW)
!                Value of parameter at ZI (VALZI)
!
!   Output:      Average value of parameter in boundary layer (PBLAVG);
!
!   Called by:   METEXT
!
!   Assumptions: If the mixing height (ZI) is above the highest
!                profile height (5000 m), then we assume the profile
!                is constant (= PARRAY(NLVLS)) above ZI and compute
!                the average accordingly.
!
!
!   Programmer:  Jim Paumier PES, Inc.
!
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   Reference(s): Inhomgeneous Boundary Layer, A. Venkatram,
!                 June 25, 1993 (GOLF document #5)
!
!***********************************************************************
!
!---- Variable declarations
!
      IMPLICIT NONE
 
      INTEGER NDXBLW , NLVLS , I
      REAL HTS(NLVLS) , PARRAY(NLVLS) , ZI , SUM , PBLAVG , VALZI
!
!---- Data dictionary
!
!---- Data initializations
!
!.......................................................................
 
      SUM = 0.0
 
!---- Sum over each layer of the gridded profile (PARRAY) to the level
!     immediately below ZI
 
      DO I = 2 , NDXBLW
         SUM = SUM + (HTS(I)-HTS(I-1))*0.5*(PARRAY(I)+PARRAY(I-1))
      ENDDO
 
!---- Finish the summation
 
      IF ( NDXBLW.LT.NLVLS ) THEN
!------- Add the area between the level below ZI and ZI to the
!        sum and compute the average.
 
         SUM = SUM + (ZI-HTS(NDXBLW))*0.5*(VALZI+PARRAY(NDXBLW))
         PBLAVG = SUM/ZI
 
      ELSE
!----    ZI is above the top level (5000 m), assume the parameter is
!        constant above that level and sum accordingly and compute
!        the average
         SUM = SUM + (ZI-HTS(NLVLS))*PARRAY(NLVLS)
         PBLAVG = SUM/ZI
      ENDIF
 
      CONTINUE
      END
!*==GINTRP.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GINTRP(HTBELO,VBELOW,HTABOV,VABOVE,REQDHT,VALUE)
!***********************************************************************
!             GINTRP Module of the AMS/EPA Regulatory Model - AERMOD
!
!   Purpose:     A generalized interpolation routine
!
!   Input:       Height below the required height (HTBELO)
!                Value below the required height (VBELOW)
!                Height above the required height (HTBELO)
!                Value above the required height (VBELOW)
!                Height at which a value is required (REQDHT)
!
!   Output:      Value of the parameter at the required level (VALUE)
!
!   Called by:   Utility routine called by many modules
!
!   Assumptions:
!
!   Programmer:  Jim Paumier, PES, Inc.
!
!   Date:        September 30, 1993
!
!   Revision history:
!                <none>
!
!   Reference(s):
!
!***********************************************************************
!
!---- Variable declarations
!
      IMPLICIT NONE
      REAL VALUE , HTBELO , VBELOW , HTABOV , VABOVE , REQDHT
!
!---- Data dictionary
!
!---- Data initializations
!
!.......................................................................
!
!---- Interpolate
 
      VALUE = VBELOW + ((REQDHT-HTBELO)/(HTABOV-HTBELO))*(VABOVE-VBELOW)
 
      CONTINUE
      END
!*==URBCALC.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE URBCALC
!***********************************************************************
!             URBCALC Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Calculates Parameters for Urban Stable Boundary Layer
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    June 11, 1996
!
!        MODIFIED:  Calculate an urban ustar by setting equivalence
!                   between convective sigma-w based on urban wtar
!                   and mechanical sigma-w based on urban ustar at
!                   a height of 7 times the urban roughness length.
!                   R.W. Brode, PES, Inc., - 06/10/02
!
!        MODIFIED:  To set the value for Z_iuo at 400m instead of
!                   500m in calculation of ZIURB, based on observed data.
!                   R.W. Brode, PES, Inc., - 04/08/02
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Urban Mixing Height, Heat Flux, and "Convective
!                 Velocity Scale"
!
!        ASSUMPTIONS:  <none>
!
!        CALLED FROM:  METEXT
!***********************************************************************
 
!---- Variable declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      REAL :: DELTUR , URBHF , RHO , HT7Z0
 
      SAVE 
 
!---- Variable initializations
      MODNAM = 'URBCAL'
 
!     Compute Urban-Rural Temperature Difference (DELTRUR = 12.0)
!RWB  DELTUR = DELTRUR * (0.1046 * ALOG(URBPOP/REFPOP) + 0.9983)
!RWB  Use rounded values for parameters
      DELTUR = DELTRUR*(0.1*ALOG(URBPOP/REFPOP)+1.0)
 
!     Compute Urban Convective Mixing Height
      ZIURB = 400.0*(URBPOP/REFPOP)**0.25
 
!     Compute Urban Heat Flux, and recalculate Monin-Obukhov length
      URBHF = 0.03*DELTUR*USTAR
      RHO = 101325./(287.04*TA)
 
!     Compute Urban WSTAR
      URBWSTR = ((G/TA)*URBHF*ZIURB)**0.333333
 
!     Compute Urban USTAR; first set height for equivalence between
!     convective and mechanical sigma-w as 7 times the maximum of the
!     rural and urban surface roughness length.
      HT7Z0 = 7.*MAX(URBZ0,SFCZ0)
      URBUSTR = MAX(USTAR,SQRT(1.6*(HT7Z0/ZIURB)**0.6667)               &
     &          /(1.3*(1.-HT7Z0/MAX(ZIURB,ZIMECH))**0.5)*URBWSTR)
 
!     Compute equivalent Monin-Obukhov length
      URBOBULEN = -((TA*URBUSTR**3)/(0.4*G*URBHF))
 
!     Save Rural values of USTAR and OBULEN
      RURUSTR = USTAR
      RUROBULEN = OBULEN
 
      CONTINUE
      END
!*==GRDURBAN.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GRDURBAN
!***********************************************************************
!             GRDURBAN Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Computes Urban Profiles
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:    June 11, 1996
!
!        MODIFIED:   Changed subroutine name from GRDURB to GRDURBAN.
!                    R. Brode, PES, 11/21/97
!
!        INPUTS:  Meteorological Variables for One Hour
!
!        OUTPUTS: Urban Profiles of sigma-v, sigma-w, Tlz, VPTG
!
!        ASSUMPTIONS:  <none>
!
!        CALLED FROM:  METEXT
!***********************************************************************
 
!---- Variable declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
      REAL :: ZDCRS , SV2 , SVURB , SV2DCR , VAL2 , ATZI , SW2 , SWURB
 
      SAVE 
 
!---- Variable initializations
      MODNAM = 'GRDURB'
 
      ZDCRS = AT1PT2*ZIURB
 
!     Loop Through Grid Levels
      DO I = 1 , MXGLVL
 
         GRDSVR(I) = GRIDSV(I)
         GRDSWR(I) = GRIDSW(I)
         GRDTGR(I) = GRIDTG(I)
         GRDPTR(I) = GRIDPT(I)
 
         SV2 = 0.35*URBWSTR**2
!
         IF ( GRIDHT(I).LE.ZIURB ) THEN
            SVURB = SQRT(SV2)
 
         ELSEIF ( GRIDHT(I).GT.ZIURB .AND. GRIDHT(I).LE.ZDCRS ) THEN
!           COMPUTE sigmaV at 1.2*ZI
            SV2DCR = AMIN1(SV2,0.25)
!           INTERPOLATE between value of SV2 at ZI and at 1.2*ZI
            CALL GINTRP(ZIURB,SV2,ZDCRS,SV2DCR,GRIDHT(I),VAL2)
            SVURB = SQRT(VAL2)
 
         ELSE   ! requested height is above 1.2*mixing height
            ATZI = SQRT(SV2)
            SVURB = AMIN1(ATZI,0.5)
 
         ENDIF
!
 
         IF ( GRIDHT(I).LE.0.1*ZIURB ) THEN
            SW2 = 1.6*(GRIDHT(I)/ZIURB)**0.667*URBWSTR**2
            SWURB = SQRT(SW2)
 
         ELSEIF ( GRIDHT(I).GT.0.1*ZIURB .AND. GRIDHT(I).LE.ZIURB ) THEN
            SWURB = SQRT(0.35*URBWSTR**2)
 
         ELSEIF ( GRIDHT(I).GT.ZIURB ) THEN
!           COMPUTE sigmaW at ZI and 1.2*ZI
!           (The coefficient 0.7 = 1.7 - HEIGHT/ZI, but HEIGHT = ZI)
 
            SW2 = 0.35*URBWSTR**2*EXP(-(6.*(GRIDHT(I)-ZIURB)/ZIURB))
            SWURB = SQRT(SW2)
 
         ENDIF
!
         GRDSVU(I) = SQRT(GRIDSV(I)**2+SVURB**2)
         GRDSWU(I) = SQRT(GRIDSW(I)**2+SWURB**2)
 
         IF ( GRIDHT(I).LE.ZIURB ) THEN
            GRDTGU(I) = 1.0E-5
         ELSE
            GRDTGU(I) = GRIDTG(I)
         ENDIF
 
      ENDDO
 
!---- Compute potential temperature profile from urban Dtheta/Dz profile
      CALL GRDPTURB
 
 
      CONTINUE
      END
!*==GRDPTURB.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GRDPTURB
!=======================================================================
!                GRDPTURB module of the AERMOD Dispersion Model
!
!   Purpose:     To construct a profile of gridded values of
!                potential temperature for URBAN cases
!
!   Input:       Profile of gridded potential temperature gradients
!                Temperature at the reference height
!                Profile of grid heights
!
!   Output:      Potential temperature profile at the grid heights.
!
!   Assumptions: There is at least one grid level below the reference
!                temperature height (which should be satisfied
!                because the lowest grid level is 0.5 meters)
!
!   Called by:   METEXT
!
!   Programmer:  Jim Paumier                          30 Sept 1993
!                Pacific Environmental Services
!
!   Revision history:
!        12/10/97  - R. Brode, PES, Inc.
!                    Corrected the order of array indices used for profiling
!                    potential temperature above the reference height.
!        12/16/94  - J. Paumier, PES, Inc.
!                  - CALL LOCATE to get the number of levels below the
!                    temperature reference height, replacing the original
!                    method which relied on grid heights being every 10 m
!
!-----------------------------------------------------------------------
!
!---- Variable declarations
 
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: NBELOW , L
      REAL :: PTREF
 
      SAVE 
!---- Data definitions
!
!
!---- Data initializations
!
!
!.......................................................................
!
 
!---- Determine the grid level below the temperature reference
!     height (as defined in the scalar file)               ---- CALL LOCATE
 
      CALL LOCATE(GRIDHT,1,MXGLVL,TREFHT,NBELOW)
 
!---- Compute the potential temperature at the reference level
!     using the reference temperature (TA), the reference
!     temperature height (TREFHT), and the average stack base
!     elevation of all the emission sources (ZBASE)
 
      PTREF = TA + GOVRCP*(TREFHT+ZBASE)
 
!---- Compute the potential temperature at the grid level below
!     the temperature reference height
 
      GRDPTU(NBELOW) = PTREF - 0.5*(GRDTGU(NBELOW+1)+GRDTGU(NBELOW))    &
     &                 *(TREFHT-GRIDHT(NBELOW))
 
 
!---- Compute Potential Temp Values for Grid Levels Below Reference Ht.
      DO L = NBELOW - 1 , 1 , -1
         GRDPTU(L) = GRDPTU(L+1) - 0.5*(GRDTGU(L+1)+GRDTGU(L))          &
     &               *(GRIDHT(L+1)-GRIDHT(L))
      ENDDO
 
 
!---- Compute Potential Temp Values for Grid Levels Above Reference Ht.
      DO L = NBELOW + 1 , MXGLVL
 
         GRDPTU(L) = GRDPTU(L-1) + 0.5*(GRDTGU(L)+GRDTGU(L-1))          &
     &               *(GRIDHT(L)-GRIDHT(L-1))
 
      ENDDO
 
      CONTINUE
      END
!*==METDEB.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
!CRFL
!CRFL  Subroutine METDEB added to improve debug output of meteorological
!CRFL  data.
!CRFL
 
      SUBROUTINE METDEB
!***********************************************************************
!             METDEB Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Writes debug output of this hour's meteorological
!                 data.
!
!        PROGRAMMERS:  Bob Paine (developer) and Russ Lee (implementation)
!
!        DATE:    August 18, 1994;  Revised September 26, 1994.
!
!        INPUTS:  Meteorological data input to model
!
!        OUTPUTS: Meteorological data output to debug file
!
!        ASSUMPTIONS:  None
!
!        CALLED FROM:  HRLOOP
!***********************************************************************
 
!---- Variable declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
 
      SAVE 
 
!---- Variable initializations
      MODNAM = 'METDEB'
 
      IF ( METHDR ) THEN
         WRITE (DBMUNT,6115) IYEAR , IMONTH , IDAY , IHOUR , ZI , TA ,  &
     &                       USTAR , WSTAR , OBULEN , SFCZ0 , UAVG ,    &
     &                       SVAVG , SWAVG , UATZI , SVATZI , SWATZI ,  &
     &                       VPTGZI
!
 6115    FORMAT (1X,80('-'),//,'  SURFACE AND PROFILE MET DATA:',/,T48, &
     &           'MONIN-    SFC',/,T17,                                 &
     &           'MIXING   SFC                  OBUKHOV   ROUGH.',/,T17,&
     &           'HEIGHT   TEMP    U*     W*    LENGTH    LENGTH',/,    &
     &           '  YR MO DA HR',                                       &
     &           '    (M)     (K)   (M/S)  (M/S)     (M)      (M)',//,  &
     &           1X,4I3,3X,F6.1,2X,F5.1,2X,F5.3,2X,F5.3,2X,F7.1,3X,     &
     &           F7.4///,                                               &
     &           ' <--AVG: SFC TO ZI---> <--------VALUE AT ZI-------->',&
     &           /,'   U    SIG-V  SIG-W      U    SIG-V  SIG-W   VPTG',&
     &           /,' (M/S)  (M/S)  (M/S)    (M/S)  (M/S)  (M/S)   (K/M)'&
     &           ,//,1X,F5.2,2(2X,F5.2),3X,F5.2,2X,F5.2,2X,F5.2,1X,F7.4,&
     &           //)
         WRITE (DBMUNT,6118)
!RJP 6117 FORMAT (1X,I5,1X,F6.0,3(2X,F5.2),1X,F7.0,3(2X,F5.2),2(1X,F7.0))
 6118    FORMAT (5X,' GRID     WIND    WIND                    POT.',/, &
     &           5X,'HEIGHT    DIR.    SPEED   SIG-V   SIG-W   TEMP.',  &
     &           '  VPTG',/,5X,                                         &
     &           ' (M)     (DEG)    (M/S)   (M/S)   (M/S)    (K)  ',    &
     &           ' (K/M)',/)
         DO I = MXGLVL , 1 , -1
            WRITE (DBMUNT,6120) I , GRIDHT(I) , GRIDWD(I) , GRIDWS(I) , &
     &                          GRIDSV(I) , GRIDSW(I) , GRIDPT(I) ,     &
     &                          GRIDTG(I)
 6120       FORMAT (I4,F7.1,2X,F6.1,2X,F7.2,1X,F7.2,1X,F7.2,1X,F6.2,1X, &
     &              F9.6)
         ENDDO
         WRITE (DBMUNT,6116)
 6116    FORMAT (//,1X,'            <-STABLE/DIRECT EFF. VALUES-> ',    &
     &         '<--INDIRECT EFF. VALUES--> <--PENETRATED EFF. VALUES-->'&
     &         ,/,' RECEPT  DIST.    U    SIG-V  SIG-W   ',             &
     &         '       U    SIG-V  SIG-W          U    SIG-V  SIG-W  ', &
     &         '   ',/)
         METHDR = .FALSE.
      ENDIF
 
      IF ( STABLE .OR. (UNSTAB .AND. (HS.GE.ZI)) ) THEN
         WRITE (DBMUNT,6131) IREC , X , UEFF , SVEFF , SWEFF
 
!RJP  Add new FORMAT statements here.
 
 6131    FORMAT (1X,I5,1X,F6.0,1X,3(2X,F5.2))
      ELSEIF ( PPF.GE.1.0 ) THEN
         WRITE (DBMUNT,6132) IREC , X , UEFF3 , SVEFF3 , SWEFF3
 6132    FORMAT (1X,I5,1X,F6.0,1X,54X,3(2X,F5.2))
      ELSEIF ( PPF.LE.0.0 ) THEN
         WRITE (DBMUNT,6133) IREC , X , UEFFD , SVEFFD , SWEFFD ,       &
     &                       UEFFN , SVEFFN , SWEFFN
 6133    FORMAT (1X,I5,1X,F6.0,1X,2(3(2X,F5.2),6X))
      ELSE
         WRITE (DBMUNT,6134) IREC , X , UEFFD , SVEFFD , SWEFFD ,       &
     &                       UEFFN , SVEFFN , SWEFFN , UEFF3 , SVEFF3 , &
     &                       SWEFF3
 6134    FORMAT (1X,I5,1X,F6.0,1X,3(3(2X,F5.2),6X))
      ENDIF
 
      CONTINUE
      END
!*==GRDEPS.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE GRDEPS
!***********************************************************************
!             GRDEPS Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: Computes profile of epsilon, turbulence dissipation
!                 rate, for PVMRM option
!
!        PROGRAMMER: Roger Brode, PES, Inc.
!
!        DATE:       May 13, 2002
!
!        INPUTS:
!
!        OUTPUTS:
!
!        ASSUMPTIONS:
!
!        CALLED FROM:  METEXT
!***********************************************************************
 
!---- Variable declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
      INTEGER :: I
      REAL :: TSUBLR
      REAL , PARAMETER :: AR1 = 0.46
 
      SAVE 
 
!---- Variable initializations
      MODNAM = 'GRDEPS'
 
!     Loop Through Grid Levels
      DO I = 1 , MXGLVL
 
         TSUBLR = AR1*ZI/GRIDSW(I)
         GRIDEPS(I) = 0.78*GRIDSW(I)*GRIDSW(I)/TSUBLR
 
      ENDDO
 
      CONTINUE
      END
!*==OUCARD.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
      SUBROUTINE OUCARD
!***********************************************************************
!                 OUCARD Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To process OUtput Pathway card images
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:   To add subroutine call for TOXXFILE option - 9/29/92
!
!        INPUTS:  Pathway (OU) and Keyword
!
!        OUTPUTS: Output Option Switches
!                 Output Setup Status Switches
!
!        CALLED FROM:   SETUP
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
 
!     Variable Initializations
      MODNAM = 'OUCARD'
 
      IF ( KEYWRD.EQ.'STARTING' ) THEN
!        Set Status Switch
         IOSTAT(1) = IOSTAT(1) + 1
      ELSEIF ( KEYWRD.EQ.'RECTABLE' ) THEN
!        Process High Value Output Option                   ---   CALL OUHIGH
         CALL OUHIGH
!        Set Status Switch
         IOSTAT(2) = IOSTAT(2) + 1
      ELSEIF ( KEYWRD.EQ.'MAXTABLE' ) THEN
!        Process Maximum 50 Table Option                    ---   CALL OUMXVL
         CALL OUMXVL
!        Set Status Switch
         IOSTAT(3) = IOSTAT(3) + 1
      ELSEIF ( KEYWRD.EQ.'DAYTABLE' ) THEN
!        Process Daily Value Table Option                   ---   CALL OUDALY
         CALL OUDALY
!        Set Status Switch
         IOSTAT(4) = IOSTAT(4) + 1
      ELSEIF ( KEYWRD.EQ.'MAXIFILE' ) THEN
!        Process Maximum Value (Threshold) File Option      ---   CALL OUMXFL
         CALL OUMXFL
!        Set Status Switch
         IOSTAT(5) = IOSTAT(5) + 1
      ELSEIF ( KEYWRD.EQ.'POSTFILE' ) THEN
!        Process Postprocessing File Output Option          ---   CALL OUPOST
         CALL OUPOST
!        Set Status Switch
         IOSTAT(6) = IOSTAT(6) + 1
      ELSEIF ( KEYWRD.EQ.'PLOTFILE' ) THEN
!        Process Plotting File Output Option                ---   CALL OUPLOT
         CALL OUPLOT
!        Set Status Switch
         IOSTAT(7) = IOSTAT(7) + 1
      ELSEIF ( KEYWRD.EQ.'TOXXFILE' ) THEN
!        Process TOXXFILE Output Option                     ---   CALL OUTOXX
         CALL OUTOXX
!        Set Status Switch
         IOSTAT(8) = IOSTAT(8) + 1
      ELSEIF ( KEYWRD.EQ.'SEASONHR' ) THEN
         IF ( .NOT.SCIM ) THEN
!           Process Season by Hour-of-Day Output Option  ---   CALL OUSEAS
            CALL OUSEAS
!           Set Status Switch
            IOSTAT(9) = IOSTAT(9) + 1
         ELSE
!           Write Error Message: Conflicting Options SCIM and SEASONHR
            CALL ERRHDL(PATH,MODNAM,'E','154',KEYWRD)
         ENDIF
      ELSEIF ( KEYWRD.EQ.'RANKFILE' ) THEN
!        Process RANKFILE Output Option                     ---   CALL OURANK
         CALL OURANK
!        Set Status Switch
         IOSTAT(10) = IOSTAT(10) + 1
      ELSEIF ( KEYWRD.EQ.'EVALFILE' ) THEN
!        Process EVALFILE Output Option                     ---   CALL OUEVAL
         CALL OUEVAL
!        Set Status Switch
         IOSTAT(11) = IOSTAT(11) + 1
      ELSEIF ( KEYWRD.EQ.'FINISHED' ) THEN
!        Set Status Switch
         IOSTAT(25) = IOSTAT(25) + 1
!        Check The Consistency of The Output Options
         CALL OUTQA
      ELSE
!        Write Error Message: Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      ENDIF
 
      CONTINUE
      END
!*==OUTQA.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OUTQA
!***********************************************************************
!                 OUTQA Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To process OUtput Pathway card images QA Check
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        MODIFIED:  To check for EVALFILE option without EVALCART.
!                   R.W. Brode, MACTEC/PES - 10/26/04
!
!        MODIFIED:  To Include TOXXFILE Option - 9/29/92
!
!        INPUTS:  Pathway (OU) and Keyword
!
!        OUTPUTS: Output Messages
!
!        CALLED FROM: OUCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , IVAL , IDCST1
      LOGICAL OUTOPT
      CHARACTER KEYMSG*8 , MSG1*3
 
!     Variable Initializations
      MODNAM = 'OUTQA'
      MSG1 = '-HR'
      OUTOPT = .FALSE.
 
!     Check If Missing Mandatory Keyword
      IF ( IOSTAT(1).EQ.0 ) CALL ERRHDL(PATH,MODNAM,'E','130','STARTING'&
     &                                  )
 
!     Check For Lack of Any Output Option Cards
      DO I = 2 , 8
         IF ( IOSTAT(I).GT.0 ) OUTOPT = .TRUE.
      ENDDO
!        WRITE Error Message - No Output Keywords and No PERIOD Averages
      IF ( .NOT.OUTOPT .AND. .NOT.PERIOD .AND. .NOT.ANNUAL )            &
     &     CALL ERRHDL(PATH,MODNAM,'E','190','  ')
 
      DO IAVE = 1 , NUMAVE
         IDCST1 = 0
         DO IVAL = 1 , NVAL
            IF ( NHIAVE(IVAL,IAVE).EQ.1 ) IDCST1 = 1
         ENDDO
         IF ( IDCST1.EQ.0 .AND. MAXAVE(IAVE).EQ.0 .AND. IDYTAB(IAVE)    &
     &        .EQ.0 ) THEN
            WRITE (KEYMSG,'(I2.2,A3)') KAVE(IAVE) , MSG1
            CALL ERRHDL(PATH,MODNAM,'W','540',KEYMSG)
         ENDIF
      ENDDO
 
!     Check for DAYTABLE Option With SAVEFILE or INITFILE Options
!        WRITE Warning Message: DAYTABLE Results Overwritten on Re-start
      IF ( DAYTAB .AND. (RSTSAV .OR. RSTINP) )                          &
     &      CALL ERRHDL(PATH,MODNAM,'W','195','DAYTABLE')
!     Check for TOXXFILE Option With SAVEFILE or INITFILE Options
!        WRITE Error Message: Incompatible Options
      IF ( TXFILE .AND. (RSTSAV .OR. RSTINP) )                          &
     &      CALL ERRHDL(PATH,MODNAM,'E','195','TOXXFILE')
 
!     Check for post-1997 PM10 processing with EVENTFIL and no MAXIFILE
      IF ( PM10AVE .AND. EVENTS .AND. .NOT.MXFILE ) THEN
!        Write Warning Message:  EVENTFIL option not compatible
!        with post-1997 PM10 processing without MAXIFILE option
         CALL ERRHDL(PATH,MODNAM,'W','197','EVENTFIL')
         EVENTS = .FALSE.
      ENDIF
 
!     Check for EVALFILE Option without EVALCART Inputs
      IF ( IOSTAT(11).GT.0 .AND. NUMARC.EQ.0 )                          &
     &      CALL ERRHDL(PATH,MODNAM,'E','256','NUMARC=0')
 
      CONTINUE
      END
!*==OUHIGH.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OUHIGH
!***********************************************************************
!                 OUHIGH Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To process High Value By Receptor Table
!                 Output Selections
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Parameters
!
!        OUTPUTS: Output Option Switches
!
!        CALLED FROM:   OUCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , ILOCH(NAVE) , IPRDT , IPRDT1 , IPRDT2 , ISPRD ,&
     &           IEPRD , HIGHST(NVAL)
      CHARACTER LPRD*8 , HPRD*8 , NCHR1(10)*8 , NCHR2(10)*4
      LOGICAL FOUND , RMARK
 
!     Variable Initializations
      DATA (NCHR1(I),I=1,10)/'FIRST' , 'SECOND' , 'THIRD' , 'FOURTH' ,  &
     &      'FIFTH' , 'SIXTH' , 'SEVENTH' , 'EIGHTH' , 'NINTH' ,        &
     &      'TENTH'/
      DATA (NCHR2(I),I=1,10)/'1ST' , '2ND' , '3RD' , '4TH' , '5TH' ,    &
     &      '6TH' , '7TH' , '8TH' , '9TH' , '10TH'/
      MODNAM = 'OUHIGH'
      FOUND = .FALSE.
 
      DO I = 1 , NVAL
         HIGHST(I) = 0
      ENDDO
 
      DO I = 1 , NAVE
         ILOCH(I) = 0
      ENDDO
 
!     Check If Enough Fields
      IF ( IFC.EQ.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.EQ.3 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.13 ) THEN
!        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Retrieve Averaging Period
      IF ( FIELD(3).EQ.'ALLAVE' ) THEN
!        Go For All Averaging Periods
         DO I = 1 , NUMAVE
            INHI(I) = 1
            ILOCH(I) = 1
         ENDDO
         FOUND = .TRUE.
      ELSEIF ( FIELD(3).EQ.'MONTH' .AND. MONTH ) THEN
!        Set Value of IPRDT = 720 for MONTHly Averages
         IPRDT = 720
!        Search The Period to find out the Location
         DO I = 1 , NUMAVE
            IF ( IPRDT.EQ.KAVE(I) ) THEN
               FOUND = .TRUE.
               INHI(I) = 1
               ILOCH(I) = 1
            ENDIF
         ENDDO
      ELSE
         CALL FSPLIT(PATH,KEYWRD,FIELD(3),ILEN_FLD,'-',RMARK,LPRD,HPRD)
!        Single Time Period
         IF ( HPRD.EQ.LPRD ) THEN
            CALL STONUM(HPRD,8,FNUM,IMIT)
            IF ( IMIT.NE.1 ) THEN
!              Write Error Message:Invalid Numerical Field
               CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
               GOTO 115
            ENDIF
            IPRDT1 = NINT(FNUM)
!           Search The Period to find out the Location
            DO I = 1 , NUMAVE
               IF ( IPRDT1.EQ.KAVE(I) ) THEN
                  FOUND = .TRUE.
                  INHI(I) = 1
                  ILOCH(I) = 1
               ENDIF
            ENDDO
         ELSE
!           Find The Lower Boundary
            CALL STONUM(LPRD,8,FNUM,IMIT)
            IF ( IMIT.NE.1 ) THEN
!              Write Error Message:Invalid Numerical Field
               CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
               GOTO 114
            ENDIF
            IPRDT1 = NINT(FNUM)
!           Find The Upper Boundary
 114        CALL STONUM(HPRD,8,FNUM,IMIT)
            IF ( IMIT.NE.1 ) THEN
!              Write Error Message:Invalid Numerical Field
               CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
               GOTO 115
            ENDIF
            IPRDT2 = NINT(FNUM)
!           Search The Period to find out the Location
            DO I = 1 , NUMAVE
               IF ( KAVE(I).GE.IPRDT1 .AND. KAVE(I).LE.IPRDT2 ) THEN
                  FOUND = .TRUE.
                  INHI(I) = 1
                  ILOCH(I) = 1
               ENDIF
            ENDDO
!           Multi Time Period
         ENDIF
      ENDIF
 
 115  CONTINUE
 
!     Check Averaging Period Against KAVE Array,
      IF ( .NOT.FOUND ) THEN
!        Error Message:E203 AVEPER Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
         GOTO 999
      ENDIF
 
!     Check for Previous NHIGHEST Card for This Averaging Period
 
!     Begin LOOP Through Fields
      DO I = 4 , IFC
!        Retrieve The High Value
         CALL FSPLIT(PATH,KEYWRD,FIELD(I),ILEN_FLD,'-',RMARK,LPRD,HPRD)
!        Fit To The Status Array
         ISPRD = 0
         IEPRD = 0
         DO J = 1 , 10
            IF ( LPRD.EQ.NCHR1(J) .OR. LPRD.EQ.NCHR2(J) ) ISPRD = J
            IF ( HPRD.EQ.NCHR1(J) .OR. HPRD.EQ.NCHR2(J) ) IEPRD = J
         ENDDO
         IF ( ISPRD.EQ.0 .OR. IEPRD.EQ.0 ) THEN
!           Write Error Message:Illegal Parameter Field
            CALL ERRHDL(PATH,MODNAM,'E','203','HIVALU')
            GOTO 100
         ENDIF
         IF ( ISPRD.GT.NVAL .OR. IEPRD.GT.NVAL ) THEN
!           Write Error Message: High Value Requested Exceeds NVAL
            WRITE (DUMMY,'(I8)') NVAL
            CALL ERRHDL(PATH,MODNAM,'E','270',DUMMY)
            GOTO 100
         ENDIF
         DO J = ISPRD , IEPRD
            HIGHST(J) = 1
         ENDDO
!        Check for new PM10 processing with other than 4th highest
         IF ( PM10AVE ) THEN
            IF ( ISPRD.NE.4 .OR. IEPRD.NE.4 )                           &
     &            CALL ERRHDL(PATH,MODNAM,'E','354','RECTABLE')
         ENDIF
!     End LOOP Through Fields
 100  ENDDO
 
!     Set Array Switch to Indicate Which High Values to Report
!     And Set the Maximum Number of High Values, NHIVAL
      DO I = 1 , NUMAVE
         DO J = 1 , NVAL
            IF ( HIGHST(J).EQ.1 .AND. ILOCH(I).EQ.1 ) THEN
               NHIAVE(J,I) = 1
               IF ( J.GT.NHIVAL ) NHIVAL = J
            ENDIF
         ENDDO
      ENDDO
 
 999  CONTINUE
      END
!*==OUMXVL.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OUMXVL
!***********************************************************************
!                 OUMXVL Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Process Maximum (Overall) Value Table
!                 Output Selections
!
!        PROGRAMMER: Jeff Wang, Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Parameters
!
!        OUTPUTS: Output Option Switches
!
!        CALLED FROM:   OUCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , IPRDT
      LOGICAL FOUND
 
!     Variable Initializations
      MODNAM = 'OUMXVL'
      FOUND = .FALSE.
 
!     Check for Appropriate Number of Fields
      IF ( IFC.EQ.2 ) THEN
!        Error Message: No Parameters
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.EQ.3 ) THEN
!        Error Message: Not Enough Parameters
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.4 ) THEN
!        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Retrieve Averaging Period
      IF ( FIELD(3).EQ.'ALLAVE' ) THEN
!        Go For All Averaging Periods
         DO I = 1 , NUMAVE
            MAXAVE(I) = 1
         ENDDO
         FOUND = .TRUE.
      ELSE
         IF ( FIELD(3).EQ.'MONTH' .AND. MONTH ) THEN
!           Set Value of IPRDT = 720 for MONTHly Averages
            IPRDT = 720
         ELSE
            CALL STONUM(FIELD(3),ILEN_FLD,FNUM,IMIT)
            IF ( IMIT.NE.1 ) THEN
!              Write Error Message:Invalid Numerical Field
               CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
               GOTO 999
            ENDIF
            IPRDT = NINT(FNUM)
         ENDIF
!        Check Averaging Period Against KAVE Array
         J = 1
         DO WHILE ( .NOT.FOUND .AND. J.LE.NUMAVE )
            IF ( IPRDT.EQ.KAVE(J) ) THEN
               FOUND = .TRUE.
               INDAVE = J
               MAXAVE(J) = 1
            ENDIF
            J = J + 1
         ENDDO
      ENDIF
      IF ( .NOT.FOUND ) THEN
!        Error Message: E203 AVEPER Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
         GOTO 999
      ENDIF
 
!     Set Number of Maximum Values to Sort
      CALL STONUM(FIELD(4),ILEN_FLD,FNUM,IMIT)
      IF ( IMIT.NE.1 ) THEN
!        Write Error Message:Invalid Numerical Field
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
      INUM = NINT(FNUM)
      IF ( INUM.GT.NMAX ) THEN
!        WRITE Error Message:  Maximum Value Selected Exceeds NMAX
         WRITE (DUMMY,'(I8)') NMAX
         CALL ERRHDL(PATH,MODNAM,'E','280',DUMMY)
         GOTO 999
      ELSEIF ( INUM.LE.0 ) THEN
!        Write Error Message:Invalid Numerical Field
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GOTO 999
      ENDIF
 
      IF ( FIELD(3).EQ.'ALLAVE' ) THEN
!        Go For All Averaging Periods
         DO I = 1 , NUMAVE
            IMXVAL(I) = INUM
         ENDDO
      ELSE
         IMXVAL(INDAVE) = INUM
      ENDIF
 
      IF ( INUM.GT.NMXVAL ) NMXVAL = INUM
 
 999  CONTINUE
      END
!*==OUDALY.spg  processed by SPAG 6.55Dc at 09:50 on 23 Sep 2005
 
      SUBROUTINE OUDALY
!***********************************************************************
!                 OUDALY Module of the AMS/EPA Regulatory Model - AERMOD
!
!        PURPOSE: To Process Daily Concurrent Value Table
!                 Output Selections
!
!        PROGRAMMER: Roger Brode
!
!        DATE:    March 2, 1992
!
!        INPUTS:  Input Runstream Parameters
!
!        OUTPUTS: Output Option Switches
!
!        CALLED FROM:   OUCARD
!***********************************************************************
 
!     Variable Declarations
      USE MAIN1
      IMPLICIT NONE
      CHARACTER MODNAM*12
 
      SAVE 
      INTEGER :: I , J , IPRDT
      LOGICAL FOUND
 
!     Variable Initializations
      MODNAM = 'OUDALY'
 
!     Check for Appropriate Number of Fields
      IF ( IFC.EQ.2 ) THEN
!        Error Message: No AvePer And High Value
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GOTO 999
      ELSEIF ( IFC.GT.NUMAVE+2 ) THEN
!        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GOTO 999
      ENDIF
 
!     Retrieve Averaging Period(s)
      IF ( FIELD(3).EQ.'ALLAVE' ) THEN
!        Go For All Averaging Periods
         DO I = 1 , NUMAVE
            IDYTAB(I) = 1
         ENDDO
!        Set Logical Switch Indicating That Daily Value Tables Are Generated
         DAYTAB = .TRUE.
      ELSE
         DO I = 3 , IFC
            IF ( FIELD(I).EQ.'MONTH' .AND. MONTH ) THEN
!              Set Value of IPRDT = 720 for MONTHly Averages
               IPRDT = 720
            ELSE
               FOUND = .FALSE.
            