/*************************************************
* Qt Mutex Source File                           *
* (C) 1999-2006 The Botan Project                *
*************************************************/

#include <botan/mux_qt.h>
#include <botan/exceptn.h>
#include <qmutex.h>

#if !defined(QT_THREAD_SUPPORT)
   #error Your version of Qt does not support threads or mutexes
#endif

namespace Botan {

namespace {

/*************************************************
* Qt Mutex                                       *
*************************************************/
class Qt_Mutex : public Mutex
   {
   public:
      void lock() { mutex.lock(); }
      void unlock() { mutex.unlock(); }
   private:
      QMutex mutex;
   };

}

/*************************************************
* Qt Mutex Factory                               *
*************************************************/
Mutex* Qt_Mutex_Factory::make()
   {
   return new Qt_Mutex();
   }

}
