/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  int opcode;   /* Either TK_GLOB or TK_LIKE */
  int not;      /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 239
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct AttachKey yy40;
  int yy60;
  struct TrigEvent yy62;
  struct {int value; int mask;} yy243;
  struct LikeOp yy258;
  ExprList* yy266;
  IdList* yy272;
  Select* yy331;
  struct LimitVal yy348;
  Token yy406;
  SrcList* yy427;
  Expr* yy454;
  TriggerStep* yy455;
  int yy477;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 564
#define YYNRULE 305
#define YYERRORSYMBOL 141
#define YYERRSYMDT yy477
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   263,  261,  261,  154,  124,  126,  128,  130,  132,  134,
 /*    10 */   136,  138,  140,  142,  350,  567,  145,  641,  261,  369,
 /*    20 */   144,  114,  116,  112,  118,    7,  124,  126,  128,  130,
 /*    30 */   132,  134,  136,  138,  140,  142,  136,  138,  140,  142,
 /*    40 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*    50 */   114,  116,  112,  118,    9,  124,  126,  128,  130,  132,
 /*    60 */   134,  136,  138,  140,  142,  574,  223,  262,  262,  124,
 /*    70 */   126,  128,  130,  132,  134,  136,  138,  140,  142,   13,
 /*    80 */    96,  145,   13,    2,  262,  144,    4,   78,  371,   92,
 /*    90 */    10,  373,  380,  385,  132,  134,  136,  138,  140,  142,
 /*   100 */    75,    3,  562,  388,  296,  110,   94,  146,  157,  162,
 /*   110 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   77,
 /*   120 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   130 */   145,   65,  573,   13,  144,   11,  371,   66,  292,  373,
 /*   140 */   380,  385,  870,    1,  563,   14,   15,    4,   14,   15,
 /*   150 */   172,  388,   51,  665,  110,   94,  146,  157,  162,  167,
 /*   160 */   156,  161,  120,  122,  114,  116,  112,  118,   72,  124,
 /*   170 */   126,  128,  130,  132,  134,  136,  138,  140,  142,   51,
 /*   180 */    37,  341,   40,   59,   67,   69,  305,  336,  107,  106,
 /*   190 */   108,  847,  572,   34,  338,   96,  366,  349,   13,   14,
 /*   200 */    15,  371,   12,  145,  373,  380,  385,  144,  564,   40,
 /*   210 */    59,   67,   69,  305,  336,   75,  388,    3,  562,  190,
 /*   220 */   345,  338,   44,   45,   95,  460,  802,  110,   94,  146,
 /*   230 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   240 */   118,  575,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   250 */   140,  142,   20,   48,  800,  364,  362,  101,  102,  367,
 /*   260 */   499,  295,   49,  596,   14,   15,  191,   32,   33,   27,
 /*   270 */   148,  403,   96,   50,  147,  534,   46,  145,  494,  466,
 /*   280 */   456,  144,  580,  279,   36,  340,   47,  399,  309,   81,
 /*   290 */   368,  401,   75,  335,  398,  505,  176,  501,  150,  151,
 /*   300 */   197,  110,   94,  146,  157,  162,  167,  156,  161,  120,
 /*   310 */   122,  114,  116,  112,  118,   77,  124,  126,  128,  130,
 /*   320 */   132,  134,  136,  138,  140,  142,  149,  280,  258,  169,
 /*   330 */    96,   39,  281,   13,  298,  367,   96,  175,   22,  335,
 /*   340 */    28,  145,  188,  402,   33,  144,  217,    6,    5,  171,
 /*   350 */    75,  173,  174,   25,  176,  581,   75,   57,   58,  507,
 /*   360 */   235,  351,  356,  357,  265,  110,   94,  146,  157,  162,
 /*   370 */   167,  156,  161,  120,  122,  114,  116,  112,  118,  503,
 /*   380 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   390 */   457,   77,  243,  294,   48,  227,  236,  293,  297,   14,
 /*   400 */    15,  288,   96,   49,  217,  152,  222,  163,  168,  278,
 /*   410 */    24,   13,  687,   13,   50,  145,  518,  201,  152,  144,
 /*   420 */   163,  168,   75,  358,  582,  171,  176,  173,  174,  263,
 /*   430 */   171,  261,  173,  174,  354,  356,  357,  588,  211,  110,
 /*   440 */    94,  146,  157,  162,  167,  156,  161,  120,  122,  114,
 /*   450 */   116,  112,  118,  654,  124,  126,  128,  130,  132,  134,
 /*   460 */   136,  138,  140,  142,  303,   13,  688,   96,  250,  817,
 /*   470 */    96,   16,   17,   18,  246,   81,  216,   14,   15,   14,
 /*   480 */    15,  145,   13,  406,  435,  144,   13,   75,  487,  387,
 /*   490 */    75,  493,  248,  258,  235,  660,  358,  262,  310,  852,
 /*   500 */   171,   26,  173,  174,  253,  110,   94,  146,  157,  162,
 /*   510 */   167,  156,  161,  120,  122,  114,  116,  112,  118,  397,
 /*   520 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   530 */   229,   14,   15,  489,  250,  152,  252,  163,  168,  171,
 /*   540 */   839,  173,  174,  360,  361,   96,  145,  533,   14,   15,
 /*   550 */   144,  866,   14,   15,  801,  442,  312,  275,  255,  453,
 /*   560 */   850,  338,  251,  535,  536,   75,  662,  247,   13,  493,
 /*   570 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   580 */   114,  116,  112,  118,  845,  124,  126,  128,  130,  132,
 /*   590 */   134,  136,  138,  140,  142,  726,   96,  171,   96,  173,
 /*   600 */   174,  171,  252,  173,  174,  152,  583,  163,  168,   42,
 /*   610 */   720,  525,   96,  145,  441,  271,   75,  144,   75,  170,
 /*   620 */   302,  640,   91,   31,  358,  313,  320,  322,  251,  432,
 /*   630 */   434,  433,   75,  844,   14,   15,  176,  110,   94,  146,
 /*   640 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   650 */   118,   77,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   660 */   140,  142,  171,   96,  173,  174,  331,   52,  171,   96,
 /*   670 */   173,  174,   96,  195,  213,  207,   29,  348,  145,   54,
 /*   680 */   310,  318,  144,   75,  455,  342,  217,   93,   83,   75,
 /*   690 */    30,  452,   75,  109,  587,  286,  111,  171,  265,  173,
 /*   700 */   174,  319,  110,   94,  146,  157,  162,  167,  156,  161,
 /*   710 */   120,  122,  114,  116,  112,  118,   77,  124,  126,  128,
 /*   720 */   130,  132,  134,  136,  138,  140,  142,  244,   96,  187,
 /*   730 */    96,   96,  810,  331,  214,  266,  215,   35,  312,   96,
 /*   740 */    96,  479,  328,  145,  623,   38,  327,  144,   75,  455,
 /*   750 */    75,   75,  113,  689,  115,  117,  315,  461,  426,   75,
 /*   760 */    75,   77,  463,  119,  121,  407,  325,  110,  165,  146,
 /*   770 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   780 */   118,   77,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   790 */   140,  142,   42,   96,   96,   96,   96,  824,  273,  159,
 /*   800 */   415,   96,  410,  272,   96,  273,  479,   41,  145,  332,
 /*   810 */   537,   43,  144,   75,   75,   75,   75,  123,  125,  127,
 /*   820 */   129,   75,  465,   64,   75,  131,   53,  463,  133,  158,
 /*   830 */   317,  316,  265,   94,  146,  157,  162,  167,  156,  161,
 /*   840 */   120,  122,  114,  116,  112,  118,  219,  124,  126,  128,
 /*   850 */   130,  132,  134,  136,  138,  140,  142,   96,  689,   96,
 /*   860 */    96,  532,   96,  331,  299,   96,  215,   96,   96,  283,
 /*   870 */    96,  261,  219,   96,  145,   96,  840,   75,  144,   75,
 /*   880 */    75,  135,   75,  137,  139,   75,  141,   75,   75,  143,
 /*   890 */    75,  153,  155,   75,  164,   75,  376,  166,   56,  178,
 /*   900 */   146,  157,  162,  167,  156,  161,  120,  122,  114,  116,
 /*   910 */   112,  118,  652,  124,  126,  128,  130,  132,  134,  136,
 /*   920 */   138,  140,  142,   76,   96,   96,   96,   71,  438,  364,
 /*   930 */   362,  437,   96,   96,   96,   96,  331,  262,  233,  332,
 /*   940 */    96,   55,  331,  439,   75,   75,   75,  331,  180,  182,
 /*   950 */   184,  199,   75,   75,   75,   75,  196,  198,  208,  210,
 /*   960 */    75,  107,  106,  108,  212,  720,  326,  177,  327,  382,
 /*   970 */   430,  431,  107,  106,  108,  391,  548,   61,   96,   96,
 /*   980 */   449,  471,  458,   45,  183,  181,  300,   96,  476,  352,
 /*   990 */    96,  353,  179,   73,   74,  343,  346,   95,   75,   75,
 /*  1000 */   290,   96,  224,  240,  345,  275,   42,   75,   95,   76,
 /*  1010 */    75,  245,  332,   71,  277,  383,  275,  327,  332,   96,
 /*  1020 */    75,   75,  404,  332,  287,  386,   96,  392,  421,  327,
 /*  1030 */   101,  102,  103,  104,  105,  185,  189,  199,   96,   75,
 /*  1040 */    96,  101,  102,  427,  414,   60,   75,  107,  106,  108,
 /*  1050 */   474,  470,  486,  177,   77,  450,  421,  327,   75,  484,
 /*  1060 */    75,  273,  478,  436,  491,  492,  423,  490,  421,  421,
 /*  1070 */   183,  181,  421,  421,  483,  421,   77,  421,  179,   73,
 /*  1080 */    74,  476,  244,   95,   77,   81,  526,  860,  490,  421,
 /*  1090 */   689,  522,   62,   64,  500,   70,  597,   63,  523,   68,
 /*  1100 */   598,   76,   81,   79,   81,   71,  502,  504,   84,   80,
 /*  1110 */   506,  510,  244,  514,  239,  520,  101,  102,  103,  104,
 /*  1120 */   105,  185,  189,   77,  546,  241,   82,  558,   86,  199,
 /*  1130 */    85,  225,   90,   87,   97,   88,   99,  142,   89,  107,
 /*  1140 */   106,  108,  160,   98,  516,  177,  100,  218,  666,  667,
 /*  1150 */   668,  186,  209,  193,  192,  194,  200,  204,  203,  202,
 /*  1160 */   206,  205,  183,  181,  219,  220,  221,  226,  228,  232,
 /*  1170 */   179,   73,   74,  230,  233,   95,  234,  231,  237,  242,
 /*  1180 */   238,  215,  260,  249,  257,  276,  267,  254,  256,  259,
 /*  1190 */   264,  269,  270,   76,  274,  282,  301,   71,  219,  268,
 /*  1200 */   285,  291,  284,  306,  324,  307,  311,  308,  101,  102,
 /*  1210 */   103,  104,  105,  185,  189,  803,  355,  329,  375,  304,
 /*  1220 */   314,  199,  321,  337,  330,  365,  334,  372,  309,  333,
 /*  1230 */   323,  107,  106,  108,  344,  339,  347,  177,  374,  378,
 /*  1240 */   400,  359,  370,  377,  381,  379,  384,  389,  363,  390,
 /*  1250 */   393,  394,  396,   54,  183,  181,  289,  408,  395,  409,
 /*  1260 */   411,  413,  179,   73,   74,  412,  416,   95,  417,  420,
 /*  1270 */   428,  422,  832,  429,  443,  440,  444,  837,  838,   76,
 /*  1280 */   446,  445,  448,   71,  451,  808,  809,  459,  454,  447,
 /*  1290 */   418,  727,  728,  831,  464,  462,  846,  457,  469,  419,
 /*  1300 */   101,  102,  103,  104,  105,  185,  189,  199,  467,  468,
 /*  1310 */   472,  473,  475,  424,  848,  477,  480,  107,  106,  108,
 /*  1320 */   425,  482,  488,  177,  485,  849,  481,  495,  496,  851,
 /*  1330 */   659,  661,  816,  858,  497,  509,  511,  719,  513,  515,
 /*  1340 */   183,  181,  722,  517,  725,  519,  521,  524,  179,   73,
 /*  1350 */    74,  818,  528,   95,  530,  819,  820,  531,  538,  821,
 /*  1360 */     8,  822,  539,  823,  549,   19,   21,   23,  405,  541,
 /*  1370 */   542,  544,  543,  859,  547,  861,  862,  865,  545,  540,
 /*  1380 */   551,  867,  557,  555,  552,  550,  101,  102,  103,  104,
 /*  1390 */   105,  185,  189,  554,  560,  559,  561,  868,  529,  545,
 /*  1400 */   460,  545,  545,  545,  545,  527,  545,  553,  545,  545,
 /*  1410 */   545,  545,  556,  545,  545,  545,  545,  545,  545,  545,
 /*  1420 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1430 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1440 */   545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1450 */   545,  545,  545,  508,  512,  456,  545,  545,  545,  498,
 /*  1460 */   545,  545,  545,  545,   81,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    24,   26,   26,   78,   79,   80,   81,   82,   83,   84,
 /*    10 */    85,   86,   87,   88,   22,    9,   40,   23,   26,   25,
 /*    20 */    44,   74,   75,   76,   77,    9,   79,   80,   81,   82,
 /*    30 */    83,   84,   85,   86,   87,   88,   85,   86,   87,   88,
 /*    40 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    50 */    74,   75,   76,   77,  148,   79,   80,   81,   82,   83,
 /*    60 */    84,   85,   86,   87,   88,    9,   25,   92,   92,   79,
 /*    70 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   26,
 /*    80 */   150,   40,   26,  144,   92,   44,  147,  157,   94,   48,
 /*    90 */   149,   97,   98,   99,   83,   84,   85,   86,   87,   88,
 /*   100 */   170,    9,   10,  109,  174,   64,   65,   66,   67,   68,
 /*   110 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  189,
 /*   120 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   130 */    40,   29,    9,   26,   44,   12,   94,   35,   85,   97,
 /*   140 */    98,   99,  142,  143,  144,   92,   93,  147,   92,   93,
 /*   150 */   112,  109,   66,  115,   64,   65,   66,   67,   68,   69,
 /*   160 */    70,   71,   72,   73,   74,   75,   76,   77,   22,   79,
 /*   170 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   66,
 /*   180 */    94,   95,   96,   97,   98,   99,  100,  101,   60,   61,
 /*   190 */    62,   17,    9,  160,  108,  150,  163,  164,   26,   92,
 /*   200 */    93,   94,  150,   40,   97,   98,   99,   44,    0,   96,
 /*   210 */    97,   98,   99,  100,  101,  170,  109,    9,   10,  174,
 /*   220 */    92,  108,  186,  187,   96,   51,  136,   64,   65,   66,
 /*   230 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   240 */    77,    9,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   250 */    87,   88,  149,   18,   17,   83,   84,  129,  130,  150,
 /*   260 */    20,   23,   27,  117,   92,   93,  221,  158,  159,   22,
 /*   270 */    40,   24,  150,   38,   44,  103,   41,   40,  104,  105,
 /*   280 */   106,   44,    9,  157,  168,  169,   51,  177,  178,  115,
 /*   290 */   181,  182,  170,  177,  184,   55,  174,   57,   68,   69,
 /*   300 */   137,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   310 */    73,   74,   75,   76,   77,  189,   79,   80,   81,   82,
 /*   320 */    83,   84,   85,   86,   87,   88,   96,  201,  202,   22,
 /*   330 */   150,  169,  206,   26,  212,  150,  150,   23,  149,  177,
 /*   340 */   155,   40,   23,  158,  159,   44,  224,  145,  146,  111,
 /*   350 */   170,  113,  114,  151,  174,    9,  170,   13,   14,  157,
 /*   360 */   174,  165,  166,  167,  163,   64,   65,   66,   67,   68,
 /*   370 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  139,
 /*   380 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   390 */    64,  189,  212,  112,   18,  209,  210,  116,   23,   92,
 /*   400 */    93,  200,  150,   27,  224,  217,  218,  219,  220,   22,
 /*   410 */   149,   26,   23,   26,   38,   40,  214,   41,  217,   44,
 /*   420 */   219,  220,  170,  227,    9,  111,  174,  113,  114,   24,
 /*   430 */   111,   26,  113,  114,  165,  166,  167,    9,  137,   64,
 /*   440 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   450 */    75,   76,   77,  127,   79,   80,   81,   82,   83,   84,
 /*   460 */    85,   86,   87,   88,   23,   26,   23,  150,   25,    9,
 /*   470 */   150,   13,   14,   15,   25,  115,  224,   92,   93,   92,
 /*   480 */    93,   40,   26,  153,   47,   44,   26,  170,  128,  171,
 /*   490 */   170,  174,  201,  202,  174,    9,  227,   92,   45,    9,
 /*   500 */   111,  152,  113,  114,  119,   64,   65,   66,   67,   68,
 /*   510 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   66,
 /*   520 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   530 */   210,   92,   93,  216,   25,  217,   93,  219,  220,  111,
 /*   540 */   103,  113,  114,  129,  130,  150,   40,  150,   92,   93,
 /*   550 */    44,    9,   92,   93,   17,  225,  103,  150,  119,  229,
 /*   560 */     9,  108,  119,  166,  167,  170,    9,  118,   26,  174,
 /*   570 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   580 */    74,   75,   76,   77,   11,   79,   80,   81,   82,   83,
 /*   590 */    84,   85,   86,   87,   88,    9,  150,  111,  150,  113,
 /*   600 */   114,  111,   93,  113,  114,  217,    9,  219,  220,  103,
 /*   610 */     9,  216,  150,   40,   21,  208,  170,   44,  170,  157,
 /*   620 */   174,   23,  174,   25,  227,  104,  105,  106,  119,  104,
 /*   630 */   105,  106,  170,   11,   92,   93,  174,   64,   65,   66,
 /*   640 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   650 */    77,  189,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   660 */    87,   88,  111,  150,  113,  114,  150,   96,  111,  150,
 /*   670 */   113,  114,  150,  136,  212,  138,  156,  162,   40,  108,
 /*   680 */    45,   32,   44,  170,  157,  170,  224,  174,  192,  170,
 /*   690 */    23,   98,  170,  174,    9,  199,  174,  111,  163,  113,
 /*   700 */   114,   52,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   710 */    72,   73,   74,   75,   76,   77,  189,   79,   80,   81,
 /*   720 */    82,   83,   84,   85,   86,   87,   88,  126,  150,  157,
 /*   730 */   150,  150,  139,  150,   23,  200,   25,  161,  103,  150,
 /*   740 */   150,  214,  226,   40,   23,  150,   25,   44,  170,  157,
 /*   750 */   170,  170,  174,   24,  174,  174,  107,  230,  136,  170,
 /*   760 */   170,  189,  235,  174,  174,   20,  183,   64,   65,   66,
 /*   770 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   780 */    77,  189,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   790 */    87,   88,  103,  150,  150,  150,  150,    9,   25,   66,
 /*   800 */    55,  150,   57,   23,  150,   25,  214,  171,   40,  226,
 /*   810 */    22,   33,   44,  170,  170,  170,  170,  174,  174,  174,
 /*   820 */   174,  170,  230,  102,  170,  174,  171,  235,  174,   96,
 /*   830 */    95,   96,  163,   65,   66,   67,   68,   69,   70,   71,
 /*   840 */    72,   73,   74,   75,   76,   77,  117,   79,   80,   81,
 /*   850 */    82,   83,   84,   85,   86,   87,   88,  150,  103,  150,
 /*   860 */   150,   73,  150,  150,   23,  150,   25,  150,  150,  200,
 /*   870 */   150,   26,  117,  150,   40,  150,  103,  170,   44,  170,
 /*   880 */   170,  174,  170,  174,  174,  170,  174,  170,  170,  174,
 /*   890 */   170,  174,  174,  170,  174,  170,  183,  174,   42,  174,
 /*   900 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   910 */    76,   77,    9,   79,   80,   81,   82,   83,   84,   85,
 /*   920 */    86,   87,   88,   22,  150,  150,  150,   26,   28,   83,
 /*   930 */    84,   31,  150,  150,  150,  150,  150,   92,   26,  226,
 /*   940 */   150,  180,  150,   43,  170,  170,  170,  150,  174,  174,
 /*   950 */   174,   50,  170,  170,  170,  170,  174,  174,  174,  174,
 /*   960 */   170,   60,   61,   62,  174,    9,   23,   66,   25,  183,
 /*   970 */    53,   54,   60,   61,   62,  183,  131,  172,  150,  150,
 /*   980 */   183,   25,  186,  187,   83,   84,   85,  150,  150,   23,
 /*   990 */   150,   25,   91,   92,   93,   83,   84,   96,  170,  170,
 /*  1000 */   150,  150,  174,  174,   92,  150,  103,  170,   96,   22,
 /*  1010 */   170,  174,  226,   26,  174,   23,  150,   25,  226,  150,
 /*  1020 */   170,  170,  157,  226,  174,  174,  150,   23,  150,   25,
 /*  1030 */   129,  130,  131,  132,  133,  134,  135,   50,  150,  170,
 /*  1040 */   150,  129,  130,  174,  157,   46,  170,   60,   61,   62,
 /*  1050 */   174,  213,  157,   66,  189,   23,  150,   25,  170,   23,
 /*  1060 */   170,   25,  174,  208,  174,   23,  188,   25,  150,  150,
 /*  1070 */    83,   84,  150,  150,  208,  150,  189,  150,   91,   92,
 /*  1080 */    93,  150,  126,   96,  189,  115,   23,    9,   25,  150,
 /*  1090 */     9,  157,  171,  102,  188,   22,  117,  173,  128,  171,
 /*  1100 */   117,   22,  115,  190,  115,   26,  188,  188,  193,  189,
 /*  1110 */   188,  188,  126,  188,  124,  188,  129,  130,  131,  132,
 /*  1120 */   133,  134,  135,  189,   46,  123,  191,  188,  195,   50,
 /*  1130 */   194,  121,  125,  196,  117,  197,  117,   88,  198,   60,
 /*  1140 */    61,   62,   96,  150,  213,   66,  150,  150,  115,  115,
 /*  1150 */   115,   22,  136,  223,  222,   17,   22,   25,  187,   23,
 /*  1160 */    23,  150,   83,   84,  117,  150,  154,  122,   25,  101,
 /*  1170 */    91,   92,   93,  211,   26,   96,  162,  172,  211,  122,
 /*  1180 */   172,   25,  154,  203,  119,  103,  204,  150,  150,  150,
 /*  1190 */   150,  120,   22,   22,  150,   23,   23,   26,  117,  205,
 /*  1200 */   205,  117,  204,  150,   22,  175,  150,  176,  129,  130,
 /*  1210 */   131,  132,  133,  134,  135,  136,   23,  211,   22,  171,
 /*  1220 */   179,   50,  179,  162,  172,  163,  172,  150,  178,  211,
 /*  1230 */   179,   60,   61,   62,  170,  180,  170,   66,   46,   23,
 /*  1240 */   182,  228,  182,  173,   22,  171,  171,   46,  228,   22,
 /*  1250 */   100,  150,  176,  108,   83,   84,   85,  150,  175,  154,
 /*  1260 */   150,   24,   91,   92,   93,  154,  150,   96,  154,  103,
 /*  1270 */    39,  154,   11,   37,  139,   47,  150,  103,  103,   22,
 /*  1280 */   103,  154,   22,   26,  171,    9,  139,  185,   11,  150,
 /*  1290 */   231,  127,  127,    9,    9,   17,   17,   64,  107,  232,
 /*  1300 */   129,  130,  131,  132,  133,  134,  135,   50,  185,  150,
 /*  1310 */   150,   73,  194,  233,    9,   73,  127,   60,   61,   62,
 /*  1320 */   234,   22,   22,   66,  215,    9,  150,  118,  150,    9,
 /*  1330 */     9,    9,    9,    9,  194,  118,  194,    9,  185,  107,
 /*  1340 */    83,   84,    9,  194,    9,  127,  215,   22,   91,   92,
 /*  1350 */    93,    9,  150,   96,  150,    9,    9,  154,  150,    9,
 /*  1360 */    11,    9,   23,    9,   34,   16,   17,   18,   19,  236,
 /*  1370 */   163,  150,   24,    9,  163,    9,    9,    9,  237,   30,
 /*  1380 */   236,    9,   20,  154,  150,   36,  129,  130,  131,  132,
 /*  1390 */   133,  134,  135,  150,  140,   59,  150,    9,   49,  238,
 /*  1400 */    51,  238,  238,  238,  238,   56,  238,   58,  238,  238,
 /*  1410 */   238,  238,   63,  238,  238,  238,  238,  238,  238,  238,
 /*  1420 */   238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
 /*  1430 */   238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
 /*  1440 */   238,  238,  238,  238,  238,  238,  238,  238,  238,  238,
 /*  1450 */   238,  238,  238,  104,  105,  106,  238,  238,  238,  110,
 /*  1460 */   238,  238,  238,  238,  115,
};
#define YY_SHIFT_USE_DFLT (-76)
static const short yy_shift_ofst[] = {
 /*     0 */    92,  208,  -76,  -76, 1349,    6,   16,  -76,  458,  123,
 /*    10 */   183,   56,  232,  -76,  -76,  -76,  -76,  -76,  -76,  123,
 /*    20 */   273,  123,  346,  123,  415,  247,  597,  456,  598,  667,
 /*    30 */   685,  107,  -76,  -25,  -76,   86,  -76,  456,  113,  -76,
 /*    40 */   689,  -76,  778,  235,  -76,  -76,  -76,  -76,  -76,  -76,
 /*    50 */   -76,  571,  689,  -76,  856,  -76,  344,  -76,  -76,  999,
 /*    60 */   102,  689,  991,  -76,  -76,  -76,  -76,  689,  -76, 1073,
 /*    70 */  1257,  146,  901,  979,  983,  -76,  987,  -76,  238,  989,
 /*    80 */   -76,  281,  -76,  449,  986, 1002,  990, 1010, 1007,  -76,
 /*    90 */  1257,   41, 1257,  638, 1257,  -76, 1017,  456, 1019,  456,
 /*   100 */   -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  834,
 /*   110 */  1257,  768, 1257,  -10, 1257,  -10, 1257,  -10, 1257,  -10,
 /*   120 */  1257,  -53, 1257,  -53, 1257,   11, 1257,   11, 1257,   11,
 /*   130 */  1257,   11, 1257,  -49, 1257,  -49, 1257, 1049, 1257, 1049,
 /*   140 */  1257, 1049, 1257,  -76,  -76,  -76,  230,  -76,  -76,  -76,
 /*   150 */   -76,  -76, 1257,  -75, 1257,  -10,  -76,  733,  -76, 1046,
 /*   160 */   -76,  -76,  -76, 1257,  703, 1257,  -53,  -76,  307,  987,
 /*   170 */   314,   38, 1033, 1034, 1035,  -76,  638, 1257,  834, 1257,
 /*   180 */   -76, 1257,  -76, 1257,  -76, 1129,  989,  319,  -76, 1079,
 /*   190 */    90, 1016,  537, 1138,  -76, 1257,  163, 1257,  638, 1134,
 /*   200 */   376, 1136,  -76, 1132,  456, 1137,  -76, 1257,  237, 1257,
 /*   210 */   301, 1257,  638,  711,  -76, 1257,  -76,  -76, 1047,  456,
 /*   220 */   -76,  -76,  -76, 1257,  638, 1045, 1257, 1143, 1257, 1068,
 /*   230 */   102,  -76, 1148,  -76,  -76,  638, 1068,  102,  -76, 1257,
 /*   240 */   638, 1057, 1257, 1156, 1257,  638,  -76,  -76,  509,  -76,
 /*   250 */   -76,  -76,  385,  -76,  439,  -76, 1065,  -76,  387, 1047,
 /*   260 */   405,  -76,  -76,  456,  -76,  -76, 1082, 1071,  -76, 1170,
 /*   270 */   456,  780,  -76,  456,  -76,  -76, 1257,  638,  989,  389,
 /*   280 */   443, 1172,  405, 1082, 1071,  -76, 1171,  -24,  -76,  -76,
 /*   290 */  1084,   53,  -76,  -76,  -76,  -76,  375,  -76,  841,  -76,
 /*   300 */  1173,  -76,  441,  689,  -76,  456, 1182,  -76,  635,  -76,
 /*   310 */   456,  -76,  521,  649,  -76,  735,  -76,  -76,  -76,  -76,
 /*   320 */   649,  -76,  649,  -76,  456,  943,  -76,  456, 1068,  102,
 /*   330 */   -76,  -76, 1068,  102,  -76,  -76, 1148,  -76,  856,  -76,
 /*   340 */   -76,  912,  -76,  128,  -76,  -76,  128,  -76,  -76,   -8,
 /*   350 */   846,  966,  -76,  846, 1193,  -76,  -76,  -76,  414,  -76,
 /*   360 */   -76,  -76,  414,  -76,  -76,  -76,  -76,  -76,   -6,   42,
 /*   370 */   -76,  456,  -76, 1192, 1196,  456,  721, 1216,  689,  -76,
 /*   380 */  1222,  456,  992,  689,  -76, 1257,  506,  -76, 1201, 1227,
 /*   390 */   456, 1004, 1150,  456, 1182,  -76,  453, 1145,  -76,  -76,
 /*   400 */   -76,  -76,  -76,  989,  428,  593,  745,  456, 1047,  -76,
 /*   410 */   456,  729, 1237,  989,  486,  456, 1047,  900,  525, 1166,
 /*   420 */   456, 1047,  -76, 1231,  622, 1261, 1257,  573, 1236,  917,
 /*   430 */   -76,  -76, 1174, 1175,  437,  456,  773,  -76,  -76, 1228,
 /*   440 */   -76,  -76, 1135,  456,  755, 1177,  456, 1260,  456, 1032,
 /*   450 */   903, 1276, 1147, 1277,  174,  490,  326,  235,  -76, 1164,
 /*   460 */  1165, 1278, 1284, 1285,  174, 1279, 1233,  456, 1191,  456,
 /*   470 */   956,  456, 1238, 1257,  638, 1305, 1242, 1257,  638, 1189,
 /*   480 */   456, 1299,  456, 1036,  -76,  360,  551, 1300, 1257, 1042,
 /*   490 */  1257,  638, 1316,  638, 1209,  456,  601, 1320,  240,  456,
 /*   500 */  1321,  456, 1322,  456, 1323,  456, 1324,  557, 1217,  456,
 /*   510 */   601, 1328, 1233,  456, 1232,  456,  956, 1333, 1218,  456,
 /*   520 */  1299,  970,  586, 1325, 1257, 1063, 1335,  460, 1342,  456,
 /*   530 */  1047,  788,  172, 1346, 1347, 1350, 1352,  456, 1339, 1354,
 /*   540 */  1330,  -25, 1348,  456, 1078, 1364,  845, 1366, 1367,  -76,
 /*   550 */  1330,  456, 1368,  542, 1081, 1372, 1362,  456, 1336, 1254,
 /*   560 */   456, 1388,  -76,  -76,
};
#define YY_REDUCE_USE_DFLT (-95)
static const short yy_reduce_ofst[] = {
 /*     0 */     0,  -61,  -95,  -95,  202,  -95,  -95,  -95,  -94,  -59,
 /*    10 */   -95,   52,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  103,
 /*    20 */   -95,  189,  -95,  261,  -95,  349,  -95,  185,  520,  -95,
 /*    30 */   -95,  109,  -95,   33,  576,  116,  -95,  595,  162,  -95,
 /*    40 */   636,  -95,  -95,   36,  -95,  -95,  -95,  -95,  -95,  -95,
 /*    50 */   -95,  -95,  655,  -95,  761,  -95,  -95,  -95,  -95,  -95,
 /*    60 */   805,  921,  924,  -95,  -95,  -95,  -95,  928,  -95,  -95,
 /*    70 */   446,  -95,  122,  -95,  -95,  -95,  -70,  -95,  913,  920,
 /*    80 */   -95,  935,  496,  915,  936,  933,  937,  938,  940,  -95,
 /*    90 */   448,  388,  513,  388,  519,  -95,  -95,  993,  -95,  996,
 /*   100 */   -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  -95,  388,
 /*   110 */   522,  388,  578,  388,  580,  388,  581,  388,  589,  388,
 /*   120 */   590,  388,  643,  388,  644,  388,  645,  388,  646,  388,
 /*   130 */   651,  388,  654,  388,  707,  388,  709,  388,  710,  388,
 /*   140 */   712,  388,  715,  388,  -95,  -95,  -95,  -95,  -95,  -95,
 /*   150 */   -95,  -95,  717,  188,  718,  388,  -95,  -95,  -95,  -95,
 /*   160 */   -95,  -95,  -95,  720,  388,  723,  388,  -95,  997,  462,
 /*   170 */   913,  -95,  -95,  -95,  -95,  -95,  388,  725,  388,  774,
 /*   180 */   388,  775,  388,  776,  388,  -95,  572,  913,  -95,   45,
 /*   190 */   388,  932,  930,  -95,  -95,  782,  388,  783,  388,  -95,
 /*   200 */   971,  -95,  -95,  -95, 1011,  -95,  -95,  784,  388,  785,
 /*   210 */   388,  790,  388,  -95,  -95,  252,  -95,  -95, 1012, 1015,
 /*   220 */   -95,  -95,  -95,  828,  388,  -95,  186,  -95,  320,  962,
 /*   230 */  1005,  -95, 1014,  -95,  -95,  388,  967, 1008,  -95,  829,
 /*   240 */   388,  -95,  180,  -95,  837,  388,  -95,  291,  980,  -95,
 /*   250 */   -95,  -95, 1037,  -95, 1038,  -95,  -95,  -95, 1039, 1028,
 /*   260 */   535,  -95,  -95, 1040,  -95,  -95,  982,  994,  -95,  -95,
 /*   270 */   407,  -95,  -95, 1044,  -95,  -95,  840,  388,  126,  913,
 /*   280 */   980,  -95,  669,  998,  995,  -95,  850,  201,  -95,  -95,
 /*   290 */   -95,  993,  -95,  -95,  -95,  -95,  388,  -95,  -95,  -95,
 /*   300 */   -95,  -95,  388, 1048,  -95, 1053, 1030, 1031, 1050,  -95,
 /*   310 */  1056,  -95,  -95, 1041,  -95,  -95,  -95,  -95,  -95,  -95,
 /*   320 */  1043,  -95, 1051,  -95,  583,  -95,  -95,  516, 1006, 1052,
 /*   330 */   -95,  -95, 1018, 1054,  -95,  -95, 1061,  -95, 1055,  -95,
 /*   340 */   -95,  515,  -95, 1064,  -95,  -95, 1066,  -95,  -95, 1062,
 /*   350 */   196,  -95,  -95,  269,  -95,  -95,  -95,  -95, 1013,  -95,
 /*   360 */   -95,  -95, 1020,  -95,  -95,  -95,  -95,  -95, 1058, 1060,
 /*   370 */   -95, 1077,  -95,  -95,  -95,  713, 1070,  -95, 1074,  -95,
 /*   380 */   -95,  786,  -95, 1075,  -95,  851,  318,  -95,  -95,  -95,
 /*   390 */   792,  -95,  -95, 1101, 1083, 1076,  110,  -95,  -95,  -95,
 /*   400 */   -95,  -95,  -95,  865,  913,  330,  -95, 1107, 1105,  -95,
 /*   410 */  1110, 1111,  -95,  887,  913, 1116, 1114, 1059, 1067,  -95,
 /*   420 */   878, 1117,  -95, 1080, 1086,  -95,  869,  388,  -95,  -95,
 /*   430 */   -95,  -95,  -95,  -95,  -95,  855,  -95,  -95,  -95,  -95,
 /*   440 */   -95,  -95,  -95, 1126, 1127,  -95, 1139,  -95,  797,  -95,
 /*   450 */  1113,  -95,  -95,  -95,  527,  913, 1102,  796,  -95,  -95,
 /*   460 */   -95,  -95,  -95,  -95,  592,  -95, 1123, 1159,  -95,  838,
 /*   470 */  1118, 1160,  -95,  876,  388,  -95,  -95,  888,  388,  -95,
 /*   480 */  1176, 1109,  866,  -95,  -95,  895,  913,  -95,  317,  -95,
 /*   490 */   890,  388,  -95,  388,  -95, 1178, 1140,  -95,  -95,  906,
 /*   500 */   -95,  918,  -95,  919,  -95,  922,  -95,  913,  -95,  923,
 /*   510 */  1142,  -95, 1153,  925,  -95,  931, 1149,  -95,  -95,  927,
 /*   520 */  1131,  934,  913,  -95,  395,  -95,  -95, 1202,  -95, 1204,
 /*   530 */  1203,  -95,  397,  -95,  -95,  -95,  -95, 1208,  -95,  -95,
 /*   540 */  1133, 1207,  -95, 1221, 1141,  -95, 1211,  -95,  -95,  -95,
 /*   550 */  1144, 1234,  -95, 1243, 1229,  -95,  -95,  939,  -95,  -95,
 /*   560 */  1246,  -95,  -95,  -95,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   570,  570,  565,  568,  869,  869,  869,  569,  576,  869,
 /*    10 */   869,  869,  869,  596,  597,  598,  577,  578,  579,  869,
 /*    20 */   869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*    30 */   869,  869,  589,  599,  608,  591,  607,  869,  869,  609,
 /*    40 */   652,  615,  869,  869,  653,  656,  657,  658,  855,  856,
 /*    50 */   857,  869,  652,  616,  637,  635,  869,  638,  639,  869,
 /*    60 */   708,  652,  623,  617,  624,  706,  707,  652,  618,  869,
 /*    70 */   869,  738,  807,  744,  739,  735,  869,  663,  869,  869,
 /*    80 */   664,  672,  674,  681,  720,  711,  713,  701,  715,  669,
 /*    90 */   869,  716,  869,  717,  869,  737,  869,  869,  740,  869,
 /*   100 */   741,  742,  743,  745,  746,  747,  750,  751,  752,  753,
 /*   110 */   869,  754,  869,  755,  869,  756,  869,  757,  869,  758,
 /*   120 */   869,  759,  869,  760,  869,  761,  869,  762,  869,  763,
 /*   130 */   869,  764,  869,  765,  869,  766,  869,  767,  869,  768,
 /*   140 */   869,  769,  869,  770,  771,  772,  869,  773,  774,  781,
 /*   150 */   788,  791,  869,  776,  869,  775,  778,  869,  779,  869,
 /*   160 */   782,  780,  787,  869,  869,  869,  789,  790,  869,  807,
 /*   170 */   869,  869,  869,  869,  869,  794,  806,  869,  783,  869,
 /*   180 */   784,  869,  785,  869,  786,  869,  869,  869,  796,  869,
 /*   190 */   869,  869,  869,  869,  797,  869,  869,  869,  798,  869,
 /*   200 */   869,  869,  853,  869,  869,  869,  854,  869,  869,  869,
 /*   210 */   869,  869,  799,  869,  792,  807,  804,  805,  689,  869,
 /*   220 */   690,  795,  777,  869,  718,  869,  869,  702,  869,  709,
 /*   230 */   708,  703,  869,  593,  710,  705,  709,  708,  704,  869,
 /*   240 */   714,  869,  807,  712,  869,  721,  673,  684,  682,  683,
 /*   250 */   692,  693,  869,  694,  869,  695,  869,  696,  869,  689,
 /*   260 */   680,  594,  595,  869,  678,  679,  698,  700,  685,  869,
 /*   270 */   869,  869,  699,  869,  733,  734,  869,  697,  684,  869,
 /*   280 */   869,  869,  680,  698,  700,  686,  869,  680,  675,  676,
 /*   290 */   869,  869,  677,  670,  671,  793,  869,  736,  869,  748,
 /*   300 */   869,  749,  869,  652,  619,  869,  811,  625,  620,  626,
 /*   310 */   869,  627,  869,  869,  628,  869,  631,  632,  633,  634,
 /*   320 */   869,  629,  869,  630,  869,  869,  812,  869,  709,  708,
 /*   330 */   813,  815,  709,  708,  814,  621,  869,  622,  637,  636,
 /*   340 */   610,  869,  611,  869,  612,  744,  869,  613,  614,  600,
 /*   350 */   830,  869,  601,  830,  869,  602,  605,  606,  869,  825,
 /*   360 */   827,  828,  869,  826,  829,  604,  603,  592,  869,  869,
 /*   370 */   642,  869,  645,  869,  869,  869,  869,  869,  652,  646,
 /*   380 */   869,  869,  869,  652,  647,  869,  652,  648,  869,  869,
 /*   390 */   869,  869,  869,  869,  811,  625,  650,  869,  649,  651,
 /*   400 */   643,  644,  590,  869,  869,  586,  869,  869,  689,  584,
 /*   410 */   869,  869,  869,  869,  869,  869,  689,  836,  869,  869,
 /*   420 */   869,  689,  691,  841,  869,  869,  869,  869,  869,  869,
 /*   430 */   842,  843,  869,  869,  869,  869,  869,  833,  834,  869,
 /*   440 */   835,  585,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   450 */   869,  869,  869,  869,  869,  869,  869,  869,  655,  869,
 /*   460 */   869,  869,  869,  869,  869,  869,  654,  869,  869,  869,
 /*   470 */   869,  869,  869,  869,  723,  869,  869,  869,  724,  869,
 /*   480 */   869,  731,  869,  869,  732,  869,  869,  869,  869,  869,
 /*   490 */   869,  729,  869,  730,  869,  869,  869,  869,  869,  869,
 /*   500 */   869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   510 */   869,  869,  654,  869,  869,  869,  869,  869,  869,  869,
 /*   520 */   731,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   530 */   689,  869,  830,  869,  869,  869,  869,  869,  869,  869,
 /*   540 */   864,  869,  869,  869,  869,  869,  869,  869,  869,  863,
 /*   550 */   864,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   560 */   869,  869,  571,  566,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*    CASCADE => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*       GLOB => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*       LIKE => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*  STATEMENT => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*      CDATE => ID */
   26,  /*      CTIME => ID */
   26,  /* CTIMESTAMP => ID */
   26,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ASC",           "ATTACH",        "BEFORE",      
  "CASCADE",       "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "GLOB",          "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "REINDEX",       "RENAME",      
  "CDATE",         "CTIME",         "CTIMESTAMP",    "ALTER",       
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "EXISTS",        "CASE",        
  "WHEN",          "THEN",          "ELSE",          "INDEX",       
  "TO",            "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "onconf",      
  "sortorder",     "autoinc",       "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "collate",     
  "exprlist",      "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT term",
 /*  48 */ "carg ::= DEFAULT PLUS term",
 /*  49 */ "carg ::= DEFAULT MINUS term",
 /*  50 */ "carg ::= DEFAULT id",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "autoinc ::=",
 /*  60 */ "autoinc ::= AUTOINCR",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= raisetype",
 /*  93 */ "resolvetype ::= IGNORE",
 /*  94 */ "resolvetype ::= REPLACE",
 /*  95 */ "cmd ::= DROP TABLE fullname",
 /*  96 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  97 */ "cmd ::= DROP VIEW fullname",
 /*  98 */ "cmd ::= select",
 /*  99 */ "select ::= oneselect",
 /* 100 */ "select ::= select multiselect_op oneselect",
 /* 101 */ "multiselect_op ::= UNION",
 /* 102 */ "multiselect_op ::= UNION ALL",
 /* 103 */ "multiselect_op ::= INTERSECT",
 /* 104 */ "multiselect_op ::= EXCEPT",
 /* 105 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 106 */ "distinct ::= DISTINCT",
 /* 107 */ "distinct ::= ALL",
 /* 108 */ "distinct ::=",
 /* 109 */ "sclp ::= selcollist COMMA",
 /* 110 */ "sclp ::=",
 /* 111 */ "selcollist ::= sclp expr as",
 /* 112 */ "selcollist ::= sclp STAR",
 /* 113 */ "selcollist ::= sclp nm DOT STAR",
 /* 114 */ "as ::= AS nm",
 /* 115 */ "as ::= ids",
 /* 116 */ "as ::=",
 /* 117 */ "from ::=",
 /* 118 */ "from ::= FROM seltablist",
 /* 119 */ "stl_prefix ::= seltablist joinop",
 /* 120 */ "stl_prefix ::=",
 /* 121 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 122 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 123 */ "seltablist_paren ::= select",
 /* 124 */ "seltablist_paren ::= seltablist",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "fullname ::= nm dbnm",
 /* 128 */ "joinop ::= COMMA",
 /* 129 */ "joinop ::= JOIN",
 /* 130 */ "joinop ::= JOIN_KW JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 133 */ "on_opt ::= ON expr",
 /* 134 */ "on_opt ::=",
 /* 135 */ "using_opt ::= USING LP inscollist RP",
 /* 136 */ "using_opt ::=",
 /* 137 */ "orderby_opt ::=",
 /* 138 */ "orderby_opt ::= ORDER BY sortlist",
 /* 139 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 140 */ "sortlist ::= sortitem collate sortorder",
 /* 141 */ "sortitem ::= expr",
 /* 142 */ "sortorder ::= ASC",
 /* 143 */ "sortorder ::= DESC",
 /* 144 */ "sortorder ::=",
 /* 145 */ "collate ::=",
 /* 146 */ "collate ::= COLLATE id",
 /* 147 */ "groupby_opt ::=",
 /* 148 */ "groupby_opt ::= GROUP BY exprlist",
 /* 149 */ "having_opt ::=",
 /* 150 */ "having_opt ::= HAVING expr",
 /* 151 */ "limit_opt ::=",
 /* 152 */ "limit_opt ::= LIMIT expr",
 /* 153 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 154 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 155 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 156 */ "where_opt ::=",
 /* 157 */ "where_opt ::= WHERE expr",
 /* 158 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 159 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 160 */ "setlist ::= nm EQ expr",
 /* 161 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 162 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 163 */ "insert_cmd ::= INSERT orconf",
 /* 164 */ "insert_cmd ::= REPLACE",
 /* 165 */ "itemlist ::= itemlist COMMA expr",
 /* 166 */ "itemlist ::= expr",
 /* 167 */ "inscollist_opt ::=",
 /* 168 */ "inscollist_opt ::= LP inscollist RP",
 /* 169 */ "inscollist ::= inscollist COMMA nm",
 /* 170 */ "inscollist ::= nm",
 /* 171 */ "expr ::= term",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "term ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "term ::= INTEGER",
 /* 179 */ "term ::= FLOAT",
 /* 180 */ "term ::= STRING",
 /* 181 */ "expr ::= BLOB",
 /* 182 */ "expr ::= REGISTER",
 /* 183 */ "expr ::= VARIABLE",
 /* 184 */ "expr ::= ID LP exprlist RP",
 /* 185 */ "expr ::= ID LP STAR RP",
 /* 186 */ "term ::= CTIME",
 /* 187 */ "term ::= CDATE",
 /* 188 */ "term ::= CTIMESTAMP",
 /* 189 */ "expr ::= expr AND expr",
 /* 190 */ "expr ::= expr OR expr",
 /* 191 */ "expr ::= expr LT expr",
 /* 192 */ "expr ::= expr GT expr",
 /* 193 */ "expr ::= expr LE expr",
 /* 194 */ "expr ::= expr GE expr",
 /* 195 */ "expr ::= expr NE expr",
 /* 196 */ "expr ::= expr EQ expr",
 /* 197 */ "expr ::= expr BITAND expr",
 /* 198 */ "expr ::= expr BITOR expr",
 /* 199 */ "expr ::= expr LSHIFT expr",
 /* 200 */ "expr ::= expr RSHIFT expr",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "likeop ::= LIKE",
 /* 208 */ "likeop ::= GLOB",
 /* 209 */ "likeop ::= NOT LIKE",
 /* 210 */ "likeop ::= NOT GLOB",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOTNULL",
 /* 217 */ "expr ::= expr NOT NULL",
 /* 218 */ "expr ::= expr IS NOT NULL",
 /* 219 */ "expr ::= NOT expr",
 /* 220 */ "expr ::= BITNOT expr",
 /* 221 */ "expr ::= MINUS expr",
 /* 222 */ "expr ::= PLUS expr",
 /* 223 */ "between_op ::= BETWEEN",
 /* 224 */ "between_op ::= NOT BETWEEN",
 /* 225 */ "expr ::= expr between_op expr AND expr",
 /* 226 */ "in_op ::= IN",
 /* 227 */ "in_op ::= NOT IN",
 /* 228 */ "expr ::= expr in_op LP exprlist RP",
 /* 229 */ "expr ::= LP select RP",
 /* 230 */ "expr ::= expr in_op LP select RP",
 /* 231 */ "expr ::= expr in_op nm dbnm",
 /* 232 */ "expr ::= EXISTS LP select RP",
 /* 233 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 234 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 235 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 236 */ "case_else ::= ELSE expr",
 /* 237 */ "case_else ::=",
 /* 238 */ "case_operand ::= expr",
 /* 239 */ "case_operand ::=",
 /* 240 */ "exprlist ::= exprlist COMMA expritem",
 /* 241 */ "exprlist ::= expritem",
 /* 242 */ "expritem ::= expr",
 /* 243 */ "expritem ::=",
 /* 244 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 245 */ "uniqueflag ::= UNIQUE",
 /* 246 */ "uniqueflag ::=",
 /* 247 */ "idxlist_opt ::=",
 /* 248 */ "idxlist_opt ::= LP idxlist RP",
 /* 249 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 250 */ "idxlist ::= idxitem collate sortorder",
 /* 251 */ "idxitem ::= nm",
 /* 252 */ "cmd ::= DROP INDEX fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER",
 /* 264 */ "number ::= FLOAT",
 /* 265 */ "plus_opt ::= PLUS",
 /* 266 */ "plus_opt ::=",
 /* 267 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 268 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 269 */ "trigger_time ::= BEFORE",
 /* 270 */ "trigger_time ::= AFTER",
 /* 271 */ "trigger_time ::= INSTEAD OF",
 /* 272 */ "trigger_time ::=",
 /* 273 */ "trigger_event ::= DELETE",
 /* 274 */ "trigger_event ::= INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 280 */ "when_clause ::=",
 /* 281 */ "when_clause ::= WHEN expr",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 283 */ "trigger_cmd_list ::=",
 /* 284 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 287 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 288 */ "trigger_cmd ::= select",
 /* 289 */ "expr ::= RAISE LP IGNORE RP",
 /* 290 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 291 */ "raisetype ::= ROLLBACK",
 /* 292 */ "raisetype ::= ABORT",
 /* 293 */ "raisetype ::= FAIL",
 /* 294 */ "cmd ::= DROP TRIGGER fullname",
 /* 295 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY ids",
 /* 298 */ "key_opt ::= KEY BLOB",
 /* 299 */ "database_kw_opt ::= DATABASE",
 /* 300 */ "database_kw_opt ::=",
 /* 301 */ "cmd ::= DETACH database_kw_opt nm",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 157:
    case 189:
    case 206:
#line 325 "parse.y"
{sqlite3SelectDelete((yypminor->yy331));}
#line 1315 "parse.c"
      break;
    case 170:
    case 174:
    case 194:
    case 196:
    case 204:
    case 210:
    case 224:
#line 584 "parse.y"
{sqlite3ExprDelete((yypminor->yy454));}
#line 1326 "parse.c"
      break;
    case 175:
    case 183:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 212:
    case 213:
    case 216:
    case 222:
#line 796 "parse.y"
{sqlite3ExprListDelete((yypminor->yy266));}
#line 1341 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 454 "parse.y"
{sqlite3SrcListDelete((yypminor->yy427));}
#line 1349 "parse.c"
      break;
    case 198:
#line 516 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy348).pLimit);
  sqlite3ExprDelete((yypminor->yy348).pOffset);
}
#line 1357 "parse.c"
      break;
    case 205:
    case 208:
    case 215:
#line 472 "parse.y"
{sqlite3IdListDelete((yypminor->yy272));}
#line 1364 "parse.c"
      break;
    case 230:
    case 235:
#line 889 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy455));}
#line 1370 "parse.c"
      break;
    case 232:
#line 873 "parse.y"
{sqlite3IdListDelete((yypminor->yy62).b);}
#line 1375 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 145, 1 },
  { 144, 1 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 146, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 151, 5 },
  { 153, 1 },
  { 153, 0 },
  { 152, 4 },
  { 152, 2 },
  { 155, 3 },
  { 155, 1 },
  { 158, 3 },
  { 159, 1 },
  { 162, 1 },
  { 163, 1 },
  { 163, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 160, 0 },
  { 160, 1 },
  { 160, 4 },
  { 160, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 161, 2 },
  { 161, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 5 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 173, 0 },
  { 173, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 156, 0 },
  { 156, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 3 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 171, 0 },
  { 171, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 146, 3 },
  { 146, 7 },
  { 146, 3 },
  { 146, 1 },
  { 157, 1 },
  { 157, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 154, 0 },
  { 154, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 5 },
  { 209, 3 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 211, 0 },
  { 211, 2 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 146, 4 },
  { 194, 0 },
  { 194, 2 },
  { 146, 6 },
  { 213, 5 },
  { 213, 3 },
  { 146, 8 },
  { 146, 5 },
  { 214, 2 },
  { 214, 1 },
  { 216, 3 },
  { 216, 1 },
  { 215, 0 },
  { 215, 3 },
  { 208, 3 },
  { 208, 1 },
  { 174, 1 },
  { 174, 3 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 4 },
  { 174, 4 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 217, 1 },
  { 217, 1 },
  { 217, 2 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 174, 4 },
  { 174, 2 },
  { 174, 3 },
  { 174, 2 },
  { 174, 3 },
  { 174, 4 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 219, 1 },
  { 219, 2 },
  { 174, 5 },
  { 220, 1 },
  { 220, 2 },
  { 174, 5 },
  { 174, 3 },
  { 174, 5 },
  { 174, 4 },
  { 174, 4 },
  { 174, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 212, 3 },
  { 212, 1 },
  { 224, 1 },
  { 224, 0 },
  { 146, 11 },
  { 225, 1 },
  { 225, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 226, 1 },
  { 146, 3 },
  { 146, 1 },
  { 146, 2 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 6 },
  { 146, 3 },
  { 166, 2 },
  { 167, 2 },
  { 228, 1 },
  { 228, 1 },
  { 227, 1 },
  { 227, 0 },
  { 146, 5 },
  { 229, 10 },
  { 231, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 0 },
  { 232, 1 },
  { 232, 1 },
  { 232, 1 },
  { 232, 3 },
  { 233, 0 },
  { 233, 3 },
  { 233, 3 },
  { 234, 0 },
  { 234, 2 },
  { 230, 3 },
  { 230, 0 },
  { 235, 6 },
  { 235, 8 },
  { 235, 5 },
  { 235, 4 },
  { 235, 1 },
  { 174, 4 },
  { 174, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 146, 3 },
  { 146, 6 },
  { 237, 0 },
  { 237, 2 },
  { 237, 2 },
  { 236, 1 },
  { 236, 0 },
  { 146, 3 },
  { 146, 1 },
  { 146, 3 },
  { 146, 6 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 84 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1907 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1912 "parse.c"
        break;
      case 7:
#line 89 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1917 "parse.c"
        break;
      case 8:
#line 95 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy60);}
#line 1922 "parse.c"
        break;
      case 12:
#line 100 "parse.y"
{yygotominor.yy60 = TK_DEFERRED;}
#line 1927 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 101:
      case 103:
      case 104:
#line 101 "parse.y"
{yygotominor.yy60 = yymsp[0].major;}
#line 1937 "parse.c"
        break;
      case 16:
      case 17:
#line 104 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1943 "parse.c"
        break;
      case 18:
#line 106 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1948 "parse.c"
        break;
      case 20:
#line 111 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406,yymsp[-3].minor.yy60,0);
}
#line 1955 "parse.c"
        break;
      case 21:
      case 60:
      case 74:
      case 106:
      case 224:
      case 227:
#line 115 "parse.y"
{yygotominor.yy60 = 1;}
#line 1965 "parse.c"
        break;
      case 22:
      case 59:
      case 73:
      case 75:
      case 86:
      case 107:
      case 108:
      case 223:
      case 226:
#line 116 "parse.y"
{yygotominor.yy60 = 0;}
#line 1978 "parse.c"
        break;
      case 23:
#line 117 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1985 "parse.c"
        break;
      case 24:
#line 120 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy331);
  sqlite3SelectDelete(yymsp[0].minor.yy331);
}
#line 1993 "parse.c"
        break;
      case 28:
#line 132 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy406);}
#line 1998 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 263:
      case 264:
#line 138 "parse.y"
{yygotominor.yy406 = yymsp[0].minor.yy0;}
#line 2010 "parse.c"
        break;
      case 36:
#line 193 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy406,&yymsp[0].minor.yy406);}
#line 2015 "parse.c"
        break;
      case 37:
#line 194 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy406,&yymsp[0].minor.yy0);}
#line 2020 "parse.c"
        break;
      case 38:
#line 196 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy406,&yymsp[0].minor.yy0);}
#line 2025 "parse.c"
        break;
      case 39:
      case 114:
      case 115:
      case 126:
      case 146:
      case 251:
      case 261:
      case 262:
#line 198 "parse.y"
{yygotominor.yy406 = yymsp[0].minor.yy406;}
#line 2037 "parse.c"
        break;
      case 40:
#line 199 "parse.y"
{yygotominor.yy406.z=yymsp[-1].minor.yy406.z; yygotominor.yy406.n=yymsp[0].minor.yy406.n+(yymsp[0].minor.yy406.z-yymsp[-1].minor.yy406.z);}
#line 2042 "parse.c"
        break;
      case 41:
#line 201 "parse.y"
{ yygotominor.yy60 = atoi(yymsp[0].minor.yy406.z); }
#line 2047 "parse.c"
        break;
      case 42:
#line 202 "parse.y"
{ yygotominor.yy60 = -atoi(yymsp[0].minor.yy406.z); }
#line 2052 "parse.c"
        break;
      case 47:
      case 48:
#line 207 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy454);}
#line 2058 "parse.c"
        break;
      case 49:
#line 209 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2066 "parse.c"
        break;
      case 50:
#line 213 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy406);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2074 "parse.c"
        break;
      case 52:
#line 222 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy60);}
#line 2079 "parse.c"
        break;
      case 53:
#line 224 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy60,yymsp[0].minor.yy60);}
#line 2084 "parse.c"
        break;
      case 54:
#line 225 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy60,0,0);}
#line 2089 "parse.c"
        break;
      case 56:
#line 228 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy406,yymsp[-1].minor.yy266,yymsp[0].minor.yy60);}
#line 2094 "parse.c"
        break;
      case 57:
#line 229 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy60);}
#line 2099 "parse.c"
        break;
      case 58:
#line 230 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy406.z, yymsp[0].minor.yy406.n);}
#line 2104 "parse.c"
        break;
      case 61:
#line 243 "parse.y"
{ yygotominor.yy60 = OE_Restrict * 0x010101; }
#line 2109 "parse.c"
        break;
      case 62:
#line 244 "parse.y"
{ yygotominor.yy60 = (yymsp[-1].minor.yy60 & yymsp[0].minor.yy243.mask) | yymsp[0].minor.yy243.value; }
#line 2114 "parse.c"
        break;
      case 63:
#line 246 "parse.y"
{ yygotominor.yy243.value = 0;     yygotominor.yy243.mask = 0x000000; }
#line 2119 "parse.c"
        break;
      case 64:
#line 247 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60;     yygotominor.yy243.mask = 0x0000ff; }
#line 2124 "parse.c"
        break;
      case 65:
#line 248 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60<<8;  yygotominor.yy243.mask = 0x00ff00; }
#line 2129 "parse.c"
        break;
      case 66:
#line 249 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60<<16; yygotominor.yy243.mask = 0xff0000; }
#line 2134 "parse.c"
        break;
      case 67:
#line 251 "parse.y"
{ yygotominor.yy60 = OE_SetNull; }
#line 2139 "parse.c"
        break;
      case 68:
#line 252 "parse.y"
{ yygotominor.yy60 = OE_SetDflt; }
#line 2144 "parse.c"
        break;
      case 69:
#line 253 "parse.y"
{ yygotominor.yy60 = OE_Cascade; }
#line 2149 "parse.c"
        break;
      case 70:
#line 254 "parse.y"
{ yygotominor.yy60 = OE_Restrict; }
#line 2154 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 89:
      case 91:
      case 92:
      case 163:
#line 256 "parse.y"
{yygotominor.yy60 = yymsp[0].minor.yy60;}
#line 2165 "parse.c"
        break;
      case 82:
#line 273 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy266,yymsp[0].minor.yy60,yymsp[-2].minor.yy60);}
#line 2170 "parse.c"
        break;
      case 83:
#line 275 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy266,yymsp[0].minor.yy60,0,0);}
#line 2175 "parse.c"
        break;
      case 85:
#line 278 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy266, &yymsp[-3].minor.yy406, yymsp[-2].minor.yy266, yymsp[-1].minor.yy60);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy60);
}
#line 2183 "parse.c"
        break;
      case 88:
      case 90:
#line 292 "parse.y"
{yygotominor.yy60 = OE_Default;}
#line 2189 "parse.c"
        break;
      case 93:
#line 297 "parse.y"
{yygotominor.yy60 = OE_Ignore;}
#line 2194 "parse.c"
        break;
      case 94:
      case 164:
#line 298 "parse.y"
{yygotominor.yy60 = OE_Replace;}
#line 2200 "parse.c"
        break;
      case 95:
#line 302 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy427, 0);
}
#line 2207 "parse.c"
        break;
      case 96:
#line 309 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy406, &yymsp[-2].minor.yy406, yymsp[0].minor.yy331, yymsp[-5].minor.yy60);
}
#line 2214 "parse.c"
        break;
      case 97:
#line 312 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy427, 1);
}
#line 2221 "parse.c"
        break;
      case 98:
#line 319 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy331, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy331);
}
#line 2229 "parse.c"
        break;
      case 99:
      case 123:
#line 329 "parse.y"
{yygotominor.yy331 = yymsp[0].minor.yy331;}
#line 2235 "parse.c"
        break;
      case 100:
#line 331 "parse.y"
{
  if( yymsp[0].minor.yy331 ){
    yymsp[0].minor.yy331->op = yymsp[-1].minor.yy60;
    yymsp[0].minor.yy331->pPrior = yymsp[-2].minor.yy331;
  }
  yygotominor.yy331 = yymsp[0].minor.yy331;
}
#line 2246 "parse.c"
        break;
      case 102:
#line 340 "parse.y"
{yygotominor.yy60 = TK_ALL;}
#line 2251 "parse.c"
        break;
      case 105:
#line 345 "parse.y"
{
  yygotominor.yy331 = sqlite3SelectNew(yymsp[-6].minor.yy266,yymsp[-5].minor.yy427,yymsp[-4].minor.yy454,yymsp[-3].minor.yy266,yymsp[-2].minor.yy454,yymsp[-1].minor.yy266,yymsp[-7].minor.yy60,yymsp[0].minor.yy348.pLimit,yymsp[0].minor.yy348.pOffset);
}
#line 2258 "parse.c"
        break;
      case 109:
      case 248:
#line 366 "parse.y"
{yygotominor.yy266 = yymsp[-1].minor.yy266;}
#line 2264 "parse.c"
        break;
      case 110:
      case 137:
      case 147:
      case 247:
#line 367 "parse.y"
{yygotominor.yy266 = 0;}
#line 2272 "parse.c"
        break;
      case 111:
#line 368 "parse.y"
{
   yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-2].minor.yy266,yymsp[-1].minor.yy454,yymsp[0].minor.yy406.n?&yymsp[0].minor.yy406:0);
}
#line 2279 "parse.c"
        break;
      case 112:
#line 371 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-1].minor.yy266, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2286 "parse.c"
        break;
      case 113:
#line 374 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-3].minor.yy266, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2295 "parse.c"
        break;
      case 116:
#line 386 "parse.y"
{yygotominor.yy406.n = 0;}
#line 2300 "parse.c"
        break;
      case 117:
#line 398 "parse.y"
{yygotominor.yy427 = sqliteMalloc(sizeof(*yygotominor.yy427));}
#line 2305 "parse.c"
        break;
      case 118:
#line 399 "parse.y"
{yygotominor.yy427 = yymsp[0].minor.yy427;}
#line 2310 "parse.c"
        break;
      case 119:
#line 404 "parse.y"
{
   yygotominor.yy427 = yymsp[-1].minor.yy427;
   if( yygotominor.yy427 && yygotominor.yy427->nSrc>0 ) yygotominor.yy427->a[yygotominor.yy427->nSrc-1].jointype = yymsp[0].minor.yy60;
}
#line 2318 "parse.c"
        break;
      case 120:
#line 408 "parse.y"
{yygotominor.yy427 = 0;}
#line 2323 "parse.c"
        break;
      case 121:
#line 409 "parse.y"
{
  yygotominor.yy427 = sqlite3SrcListAppend(yymsp[-5].minor.yy427,&yymsp[-4].minor.yy406,&yymsp[-3].minor.yy406);
  if( yymsp[-2].minor.yy406.n ) sqlite3SrcListAddAlias(yygotominor.yy427,&yymsp[-2].minor.yy406);
  if( yymsp[-1].minor.yy454 ){
    if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pOn = yymsp[-1].minor.yy454; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy454); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2339 "parse.c"
        break;
      case 122:
#line 423 "parse.y"
{
    yygotominor.yy427 = sqlite3SrcListAppend(yymsp[-6].minor.yy427,0,0);
    yygotominor.yy427->a[yygotominor.yy427->nSrc-1].pSelect = yymsp[-4].minor.yy331;
    if( yymsp[-2].minor.yy406.n ) sqlite3SrcListAddAlias(yygotominor.yy427,&yymsp[-2].minor.yy406);
    if( yymsp[-1].minor.yy454 ){
      if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pOn = yymsp[-1].minor.yy454; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy454); }
    }
    if( yymsp[0].minor.yy272 ){
      if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pUsing = yymsp[0].minor.yy272; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
    }
  }
#line 2356 "parse.c"
        break;
      case 124:
#line 444 "parse.y"
{
     yygotominor.yy331 = sqlite3SelectNew(0,yymsp[0].minor.yy427,0,0,0,0,0,0,0);
  }
#line 2363 "parse.c"
        break;
      case 125:
#line 450 "parse.y"
{yygotominor.yy406.z=0; yygotominor.yy406.n=0;}
#line 2368 "parse.c"
        break;
      case 127:
#line 455 "parse.y"
{yygotominor.yy427 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406);}
#line 2373 "parse.c"
        break;
      case 128:
      case 129:
#line 459 "parse.y"
{ yygotominor.yy60 = JT_INNER; }
#line 2379 "parse.c"
        break;
      case 130:
#line 461 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2384 "parse.c"
        break;
      case 131:
#line 462 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy406,0); }
#line 2389 "parse.c"
        break;
      case 132:
#line 464 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy406,&yymsp[-1].minor.yy406); }
#line 2394 "parse.c"
        break;
      case 133:
      case 141:
      case 150:
      case 157:
      case 171:
      case 211:
      case 236:
      case 238:
      case 242:
#line 468 "parse.y"
{yygotominor.yy454 = yymsp[0].minor.yy454;}
#line 2407 "parse.c"
        break;
      case 134:
      case 149:
      case 156:
      case 212:
      case 237:
      case 239:
      case 243:
#line 469 "parse.y"
{yygotominor.yy454 = 0;}
#line 2418 "parse.c"
        break;
      case 135:
      case 168:
#line 473 "parse.y"
{yygotominor.yy272 = yymsp[-1].minor.yy272;}
#line 2424 "parse.c"
        break;
      case 136:
      case 167:
#line 474 "parse.y"
{yygotominor.yy272 = 0;}
#line 2430 "parse.c"
        break;
      case 138:
      case 148:
#line 485 "parse.y"
{yygotominor.yy266 = yymsp[0].minor.yy266;}
#line 2436 "parse.c"
        break;
      case 139:
#line 486 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266,yymsp[-2].minor.yy454,yymsp[-1].minor.yy406.n>0?&yymsp[-1].minor.yy406:0);
  if( yygotominor.yy266 ) yygotominor.yy266->a[yygotominor.yy266->nExpr-1].sortOrder = yymsp[0].minor.yy60;
}
#line 2444 "parse.c"
        break;
      case 140:
#line 490 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy454,yymsp[-1].minor.yy406.n>0?&yymsp[-1].minor.yy406:0);
  if( yygotominor.yy266 && yygotominor.yy266->a ) yygotominor.yy266->a[0].sortOrder = yymsp[0].minor.yy60;
}
#line 2452 "parse.c"
        break;
      case 142:
      case 144:
#line 499 "parse.y"
{yygotominor.yy60 = SQLITE_SO_ASC;}
#line 2458 "parse.c"
        break;
      case 143:
#line 500 "parse.y"
{yygotominor.yy60 = SQLITE_SO_DESC;}
#line 2463 "parse.c"
        break;
      case 145:
#line 502 "parse.y"
{yygotominor.yy406.z = 0; yygotominor.yy406.n = 0;}
#line 2468 "parse.c"
        break;
      case 151:
#line 520 "parse.y"
{yygotominor.yy348.pLimit = 0; yygotominor.yy348.pOffset = 0;}
#line 2473 "parse.c"
        break;
      case 152:
#line 521 "parse.y"
{yygotominor.yy348.pLimit = yymsp[0].minor.yy454; yygotominor.yy348.pOffset = 0;}
#line 2478 "parse.c"
        break;
      case 153:
#line 523 "parse.y"
{yygotominor.yy348.pLimit = yymsp[-2].minor.yy454; yygotominor.yy348.pOffset = yymsp[0].minor.yy454;}
#line 2483 "parse.c"
        break;
      case 154:
#line 525 "parse.y"
{yygotominor.yy348.pOffset = yymsp[-2].minor.yy454; yygotominor.yy348.pLimit = yymsp[0].minor.yy454;}
#line 2488 "parse.c"
        break;
      case 155:
#line 529 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy427,yymsp[0].minor.yy454);}
#line 2493 "parse.c"
        break;
      case 158:
#line 543 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy427,yymsp[-1].minor.yy266,yymsp[0].minor.yy454,yymsp[-4].minor.yy60);}
#line 2498 "parse.c"
        break;
      case 159:
#line 546 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266,yymsp[0].minor.yy454,&yymsp[-2].minor.yy406);}
#line 2503 "parse.c"
        break;
      case 160:
#line 547 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[0].minor.yy454,&yymsp[-2].minor.yy406);}
#line 2508 "parse.c"
        break;
      case 161:
#line 553 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy427, yymsp[-1].minor.yy266, 0, yymsp[-4].minor.yy272, yymsp[-7].minor.yy60);}
#line 2513 "parse.c"
        break;
      case 162:
#line 555 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy427, 0, yymsp[0].minor.yy331, yymsp[-1].minor.yy272, yymsp[-4].minor.yy60);}
#line 2518 "parse.c"
        break;
      case 165:
      case 240:
#line 565 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-2].minor.yy266,yymsp[0].minor.yy454,0);}
#line 2524 "parse.c"
        break;
      case 166:
      case 241:
#line 566 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[0].minor.yy454,0);}
#line 2530 "parse.c"
        break;
      case 169:
#line 575 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(yymsp[-2].minor.yy272,&yymsp[0].minor.yy406);}
#line 2535 "parse.c"
        break;
      case 170:
#line 576 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(0,&yymsp[0].minor.yy406);}
#line 2540 "parse.c"
        break;
      case 172:
#line 587 "parse.y"
{yygotominor.yy454 = yymsp[-1].minor.yy454; sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2545 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 588 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2554 "parse.c"
        break;
      case 174:
      case 175:
#line 589 "parse.y"
{yygotominor.yy454 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2560 "parse.c"
        break;
      case 176:
#line 591 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy406);
  yygotominor.yy454 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2569 "parse.c"
        break;
      case 177:
#line 596 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy406);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy406);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy454 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2580 "parse.c"
        break;
      case 182:
#line 607 "parse.y"
{yygotominor.yy454 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2585 "parse.c"
        break;
      case 183:
#line 608 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy454 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2594 "parse.c"
        break;
      case 184:
#line 613 "parse.y"
{
  yygotominor.yy454 = sqlite3ExprFunction(yymsp[-1].minor.yy266, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2602 "parse.c"
        break;
      case 185:
#line 617 "parse.y"
{
  yygotominor.yy454 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2610 "parse.c"
        break;
      case 186:
      case 187:
      case 188:
#line 621 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[0].major,0,0,0);}
#line 2617 "parse.c"
        break;
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
#line 624 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy454, yymsp[0].minor.yy454, 0);}
#line 2639 "parse.c"
        break;
      case 207:
#line 643 "parse.y"
{yygotominor.yy258.opcode = TK_LIKE; yygotominor.yy258.not = 0;}
#line 2644 "parse.c"
        break;
      case 208:
#line 644 "parse.y"
{yygotominor.yy258.opcode = TK_GLOB; yygotominor.yy258.not = 0;}
#line 2649 "parse.c"
        break;
      case 209:
#line 645 "parse.y"
{yygotominor.yy258.opcode = TK_LIKE; yygotominor.yy258.not = 1;}
#line 2654 "parse.c"
        break;
      case 210:
#line 646 "parse.y"
{yygotominor.yy258.opcode = TK_GLOB; yygotominor.yy258.not = 1;}
#line 2659 "parse.c"
        break;
      case 213:
#line 650 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy454, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy454, 0);
  if( yymsp[0].minor.yy454 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy454, 0);
  }
  yygotominor.yy454 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->op = yymsp[-2].minor.yy258.opcode;
  if( yymsp[-2].minor.yy258.not ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-3].minor.yy454->span, &yymsp[-1].minor.yy454->span);
}
#line 2674 "parse.c"
        break;
      case 214:
#line 662 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2682 "parse.c"
        break;
      case 215:
#line 666 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2690 "parse.c"
        break;
      case 216:
#line 670 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2698 "parse.c"
        break;
      case 217:
#line 674 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2706 "parse.c"
        break;
      case 218:
#line 678 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2714 "parse.c"
        break;
      case 219:
      case 220:
#line 682 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2723 "parse.c"
        break;
      case 221:
#line 690 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2731 "parse.c"
        break;
      case 222:
#line 694 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2739 "parse.c"
        break;
      case 225:
#line 701 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy454, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy454, 0);
  yygotominor.yy454 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy454, 0, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->pList = pList;
  if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy454->span);
}
#line 2751 "parse.c"
        break;
      case 228:
#line 713 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pList = yymsp[-1].minor.yy266;
    if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy0);
  }
#line 2761 "parse.c"
        break;
      case 229:
#line 719 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = yymsp[-1].minor.yy331;
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2770 "parse.c"
        break;
      case 230:
#line 724 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = yymsp[-1].minor.yy331;
    if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy0);
  }
#line 2780 "parse.c"
        break;
      case 231:
#line 730 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406);
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    if( yymsp[-2].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy454->span,yymsp[0].minor.yy406.z?&yymsp[0].minor.yy406:&yymsp[-1].minor.yy406);
  }
#line 2791 "parse.c"
        break;
      case 232:
#line 737 "parse.y"
{
    Expr *p = yygotominor.yy454 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy331;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }
  }
#line 2802 "parse.c"
        break;
      case 233:
#line 747 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy454, yymsp[-1].minor.yy454, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->pList = yymsp[-2].minor.yy266;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2811 "parse.c"
        break;
      case 234:
#line 754 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266, yymsp[-2].minor.yy454, 0);
  yygotominor.yy266 = sqlite3ExprListAppend(yygotominor.yy266, yymsp[0].minor.yy454, 0);
}
#line 2819 "parse.c"
        break;
      case 235:
#line 758 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy454, 0);
  yygotominor.yy266 = sqlite3ExprListAppend(yygotominor.yy266, yymsp[0].minor.yy454, 0);
}
#line 2827 "parse.c"
        break;
      case 244:
#line 783 "parse.y"
{
  if( yymsp[-9].minor.yy60!=OE_None ) yymsp[-9].minor.yy60 = yymsp[0].minor.yy60;
  if( yymsp[-9].minor.yy60==OE_Default) yymsp[-9].minor.yy60 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy406, &yymsp[-6].minor.yy406, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy406,0),yymsp[-2].minor.yy266,yymsp[-9].minor.yy60, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2836 "parse.c"
        break;
      case 245:
      case 292:
#line 790 "parse.y"
{yygotominor.yy60 = OE_Abort;}
#line 2842 "parse.c"
        break;
      case 246:
#line 791 "parse.y"
{yygotominor.yy60 = OE_None;}
#line 2847 "parse.c"
        break;
      case 249:
#line 801 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy406.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy406.z, yymsp[-1].minor.yy406.n);
  }
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266, p, &yymsp[-2].minor.yy406);
}
#line 2859 "parse.c"
        break;
      case 250:
#line 809 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy406.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy406.z, yymsp[-1].minor.yy406.n);
  }
  yygotominor.yy266 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy406);
}
#line 2871 "parse.c"
        break;
      case 252:
#line 822 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy427);}
#line 2876 "parse.c"
        break;
      case 253:
      case 254:
#line 826 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2882 "parse.c"
        break;
      case 255:
      case 257:
#line 832 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy406,0);}
#line 2888 "parse.c"
        break;
      case 256:
#line 833 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy0,0);}
#line 2893 "parse.c"
        break;
      case 258:
#line 835 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy406,1);
}
#line 2900 "parse.c"
        break;
      case 259:
#line 838 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy406,&yymsp[-3].minor.yy406,&yymsp[-1].minor.yy406,0);}
#line 2905 "parse.c"
        break;
      case 260:
#line 839 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406,0,0);}
#line 2910 "parse.c"
        break;
      case 267:
#line 852 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy406.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy406.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy455, &all);
}
#line 2920 "parse.c"
        break;
      case 268:
#line 861 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy406, &yymsp[-6].minor.yy406, yymsp[-5].minor.yy60, yymsp[-4].minor.yy62.a, yymsp[-4].minor.yy62.b, yymsp[-2].minor.yy427, yymsp[-1].minor.yy60, yymsp[0].minor.yy454, yymsp[-9].minor.yy60);
  yygotominor.yy406 = (yymsp[-6].minor.yy406.n==0?yymsp[-7].minor.yy406:yymsp[-6].minor.yy406);
}
#line 2928 "parse.c"
        break;
      case 269:
      case 272:
#line 867 "parse.y"
{ yygotominor.yy60 = TK_BEFORE; }
#line 2934 "parse.c"
        break;
      case 270:
#line 868 "parse.y"
{ yygotominor.yy60 = TK_AFTER;  }
#line 2939 "parse.c"
        break;
      case 271:
#line 869 "parse.y"
{ yygotominor.yy60 = TK_INSTEAD;}
#line 2944 "parse.c"
        break;
      case 273:
      case 274:
      case 275:
#line 874 "parse.y"
{yygotominor.yy62.a = yymsp[0].major; yygotominor.yy62.b = 0;}
#line 2951 "parse.c"
        break;
      case 276:
#line 877 "parse.y"
{yygotominor.yy62.a = TK_UPDATE; yygotominor.yy62.b = yymsp[0].minor.yy272;}
#line 2956 "parse.c"
        break;
      case 277:
      case 278:
#line 880 "parse.y"
{ yygotominor.yy60 = TK_ROW; }
#line 2962 "parse.c"
        break;
      case 279:
#line 882 "parse.y"
{ yygotominor.yy60 = TK_STATEMENT; }
#line 2967 "parse.c"
        break;
      case 280:
#line 885 "parse.y"
{ yygotominor.yy454 = 0; }
#line 2972 "parse.c"
        break;
      case 281:
#line 886 "parse.y"
{ yygotominor.yy454 = yymsp[0].minor.yy454; }
#line 2977 "parse.c"
        break;
      case 282:
#line 890 "parse.y"
{
  yymsp[-2].minor.yy455->pNext = yymsp[0].minor.yy455;
  yygotominor.yy455 = yymsp[-2].minor.yy455;
}
#line 2985 "parse.c"
        break;
      case 283:
#line 894 "parse.y"
{ yygotominor.yy455 = 0; }
#line 2990 "parse.c"
        break;
      case 284:
#line 900 "parse.y"
{ yygotominor.yy455 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy406, yymsp[-1].minor.yy266, yymsp[0].minor.yy454, yymsp[-4].minor.yy60); }
#line 2995 "parse.c"
        break;
      case 285:
#line 905 "parse.y"
{yygotominor.yy455 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy406, yymsp[-4].minor.yy272, yymsp[-1].minor.yy266, 0, yymsp[-7].minor.yy60);}
#line 3000 "parse.c"
        break;
      case 286:
#line 908 "parse.y"
{yygotominor.yy455 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy406, yymsp[-1].minor.yy272, 0, yymsp[0].minor.yy331, yymsp[-4].minor.yy60);}
#line 3005 "parse.c"
        break;
      case 287:
#line 912 "parse.y"
{yygotominor.yy455 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy406, yymsp[0].minor.yy454);}
#line 3010 "parse.c"
        break;
      case 288:
#line 915 "parse.y"
{yygotominor.yy455 = sqlite3TriggerSelectStep(yymsp[0].minor.yy331); }
#line 3015 "parse.c"
        break;
      case 289:
#line 918 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy454->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3024 "parse.c"
        break;
      case 290:
#line 923 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy406); 
  yygotominor.yy454->iColumn = yymsp[-3].minor.yy60;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3033 "parse.c"
        break;
      case 291:
#line 931 "parse.y"
{yygotominor.yy60 = OE_Rollback;}
#line 3038 "parse.c"
        break;
      case 293:
#line 933 "parse.y"
{yygotominor.yy60 = OE_Fail;}
#line 3043 "parse.c"
        break;
      case 294:
#line 938 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy427);
}
#line 3050 "parse.c"
        break;
      case 295:
#line 944 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy406, &yymsp[-1].minor.yy406, yymsp[0].minor.yy40.type, &yymsp[0].minor.yy40.key);
}
#line 3057 "parse.c"
        break;
      case 296:
#line 948 "parse.y"
{ yygotominor.yy40.type = 0; }
#line 3062 "parse.c"
        break;
      case 297:
#line 949 "parse.y"
{ yygotominor.yy40.type=1; yygotominor.yy40.key = yymsp[0].minor.yy406; }
#line 3067 "parse.c"
        break;
      case 298:
#line 950 "parse.y"
{ yygotominor.yy40.type=2; yygotominor.yy40.key = yymsp[0].minor.yy0; }
#line 3072 "parse.c"
        break;
      case 301:
#line 956 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy406);
}
#line 3079 "parse.c"
        break;
      case 302:
#line 962 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3084 "parse.c"
        break;
      case 303:
#line 963 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy406, &yymsp[0].minor.yy406);}
#line 3089 "parse.c"
        break;
      case 304:
#line 968 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy427,&yymsp[0].minor.yy406);
}
#line 3096 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3163 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
