/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */

#ifndef _KAMMUMAIN_H_
#define _KAMMUMAIN_H_

#include <qwidget.h>
#include <qprocess.h>
#include <qcolor.h>
#include <khtml_part.h>
#include <qlayout.h>
#include <qdict.h>

extern "C"
{
#include <gammu/gammu.h>
}
#undef bool
#include "kammumain_base.h"

class QPainter;
class KURL;
class KHTMLPart;
class KTempFile;
class KColorButton;
class KFontRequester;
class QLayout;

class KammuMain : public KammuMain_base
{
    Q_OBJECT

public:
    KammuMain(QWidget *parent);

    virtual ~KammuMain();
    void addToFileListMIDI(QListViewItem*);
    void addToFileListImage(QListViewItem*);
    void readFile(QString name, GSM_File* file);

public slots:
    void updateGeneralInfo();
    void mirrorPhone();
    void closeEvent( QEvent *event );
    void fileContextMenu( QListViewItem* item, const QPoint& point , int);
    void smsContextMenu( QListViewItem* item, const QPoint& point );
    void summaryContextMenu(const QString &url, const QPoint &point);
    void smsClicked( QListViewItem* item );
    void newSms();
    void writeToBrowser();
    void setStyleSheet();
    void initPhone();
    void terminatePhone();
    void checkSecurityStatus();
    void changePage( QListViewItem* item );
    void generateSummaryHTML();
    void openURL( const KURL & url );
    void getFileSystem();
    void refreshMainListView();
    void getDateTime();
    void setDateTime();
    void getAlarm();
    void setAlarm();
    void getRingtonesList();
    void notifyTest( int type, QString from, QString text );
    void folderListClicked(QListViewItem* item);

signals:
    void signalChangeStatusbarMessage(const QString&);
    void signalChangeStatusbarProgress( int, int, QString );
    void signalClose( QWidget*, QEvent* );
    void signalNotification( int, QString, QString );
    void signalOperationInProgress(int);
    void signalOpProgressSetup(int);
    void signalOpIncProgress();

private:
    KHTMLPart *browser;
    QProcess * proc;
    QTimer * timer;
    QTimer * searchtimer;
    QGridLayout * layout9;
    QColor * gradient;
    QString stylesheet;
    QGridLayout *summaryLayout;
    KTempFile    *tempfile;
    GSM_StateMachine s;
    GSM_Phone_Functions *phone;
    INI_Section  *config;
    GSM_Locale	locale;
    GSM_Error error;
    QString m_unread;
    QString summaryHTML;
    QMap <QString,GSM_File> filesys; //This will be necessary for file operations...
};

#endif // _KAMMUMAIN_H_
