/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */

#include "statusbar.h"

#include <qapplication.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qtooltip.h>

#include <kactionclasses.h>
#include <kdebug.h>
#include <kglobalsettings.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kprogress.h>

StatusBar::StatusBar( QWidget *parent, const char *name )
        : KStatusBar( parent, name )
{

    addWidget( box = new QHBox( this ), 1, true );
    messageLabel = new KSqueezedTextLabel( box );
    opProgress = new KProgress ( box );
    opProgress->hide();
    box->setStretchFactor( messageLabel, 10 );
    batLabel = new QLabel( box );
    batLabel->setText( "  Battery  " );
    batProgress = new KProgress( box );
    netLabel = new QLabel( box );
    netLabel->setText( "  Network  " );
    netProgress = new KProgress( box );
    netName = new QLabel( box );

    QSize size( messageLabel->sizeHint() );
    box->setFixedHeight( size.height() + 2 );
}

StatusBar::~StatusBar()
{}

void StatusBar::message( const QString& message )
{
    kdDebug() << " statusbar::message " << message << endl;
    messageLabel->setText( message );
}

void StatusBar::progress( int net, int bat, QString network )
{
    netProgress->setProgress( net );
    batProgress->setProgress( bat );
    netName->setText( "  " + network );
}

void StatusBar::messageTemporary( const QString& message )
{
    messageLabel->setText( message );
    disconnect( this, SLOT( restore() ) );
    QTimer::singleShot( TEMP_MESSAGE_DURATION, this, SLOT( restore() ) );
}

void StatusBar::restore()
{
    messageLabel->setText( oldMessage );
}

void StatusBar::clear()
{
    oldMessage = "";
    messageLabel->clear();
}

#include "statusbar.moc"
