/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */

#include "trayicon.h"
#include "settings.h"

#include <qimage.h>
#include <kapplication.h>
#include <kwin.h>
#include <klocale.h>


TrayIcon::TrayIcon( QWidget *parent )
  : KSystemTray( parent )
{
    QPixmap icon = KSystemTray::loadIcon( "kmobiletools" );
    setPixmap( icon );
}

TrayIcon::~TrayIcon( )
{
}

void TrayIcon::notify( int type, QString from, QString text )
{
    if( KammuConfig::showSystray() ) {
        
        if( type == 1 ) {  // SMS
        
            notification = new TrayNotification( QString( i18n( "<qt><nobr><b>New SMS from '%1':</b></nobr><br><nobr>\"'%2'\"</nobr></qt>" ) ).arg( from ).arg( text ), QString::null );
        
        }
        
        notification->setAnchor(mapToGlobal(pos()));
        notification->show();
        KWin::setOnAllDesktops(notification->winId(), true);
        connect( notification, SIGNAL( signalIgnoreButtonClicked() ), notification, SLOT( close() ));
               
    }
}

#include "trayicon.moc"

