#!/bin/bash

set -o errexit

# This tool informs you about changes that were done in Weblate in SLE translations.

if test $# -ne 2 ; then
	echo "Usage: $0 project_name_without_leading_\"yast-\" language_code"
	exit 1
fi
PROJECT=$1
LNG=$2



WEBLATE_FILE=merge-tool-$PROJECT-$LNG-weblate.po
FTP_TEMP=merge-tool-$PROJECT-$LNG

curl https://l10n.opensuse.org/download/yast-$PROJECT/master/$LNG/ >$WEBLATE_FILE
curl ftp://ftp.suse.com/pub/people/sbrabec/yast-translations-sle-contributions/$PROJECT/$LNG.po >$PROJECT-$LNG-ftp.po

msgcat --use-first $PROJECT-$LNG-ftp.po $WEBLATE_FILE -o $FTP_TEMP-completed-cat.po
msgmerge $FTP_TEMP-completed-cat.po $WEBLATE_FILE -o $FTP_TEMP-completed.po

msgcat $FTP_TEMP-completed.po $FTP_TEMP-weblate.po -o $FTP_TEMP-weblate-cat-f.po

if grep -s "#-#-#-#-#" $FTP_TEMP-weblate-cat-f.po ; then
	sed "s/$FTP_TEMP-completed.po/SLE import/;s/$FTP_TEMP-weblate.po/current Weblate/" <$FTP_TEMP-weblate-cat-f.po >$PROJECT-$LNG-changes.po
	echo "There are changed Weblate strings imported from SLE translations."
	echo "Please search for \"#-#-#-#-#\" in $PROJECT-$LNG-changes.po and decide (e. g. in the ftp po file)."
else
	echo "No changes were done in Weblate since SLE import."
fi
echo "You can review $PROJECT-$LNG-ftp.po that was just downloaded from FTP."

rm $FTP_TEMP-*.po
