/*
 * Logger
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 */

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include "hda/log.h"

int verbose_mode;
char *progname = "";

void log_info(const char *format, ...)
{
	va_list ap;

	if (!verbose_mode)
		return;

	va_start(ap, format);
	fprintf(stderr, "%s: INFO: ", progname);
	vfprintf(stderr, format, ap);
	va_end(ap);
}

void log_verbose(const char *format, ...)
{
	va_list ap;

	if (verbose_mode < 1)
		return;

	va_start(ap, format);
	fprintf(stderr, "%s: INFO: ", progname);
	vfprintf(stderr, format, ap);
	va_end(ap);
}

void log_error(const char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	fprintf(stderr, "%s: ERROR: ", progname);
	vfprintf(stderr, format, ap);
	va_end(ap);
}
