/*
 * Helper functions for codec modules
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 */

#ifndef __CODECS_COMMON_H_INC
#define __CODECS_COMMON_H_INC

#include "cmds.h"
#include "io.h"
#include "mixer.h"
#include "patch.h"

struct codec_config_unsol {
	hda_nid_t nid;
	unsigned char tag;
	unsigned char shift;
	struct hda_cmds cmds;
};

struct codec_config_preset {
	/* mixers to create, NULL-terminated */
	struct hda_std_mixer *mixers[10];
	/* initialization verbs, NULL-terminated */
	struct hda_verb *init_verbs[10];
	/*
	 * analog output
	 */
	/* number of DACs */
	int num_dacs;
	/* NIDs of DACs (not necessary NULL-terminated */
	hda_nid_t *dac_nids;
	/* additionally assigned NIDs (e.g. HP, speaker), NULL-terminated */
	hda_nid_t *extra_nids;
	/*
	 * analog input
	 */
	/* ADC NID */
	hda_nid_t adc_nid;
	/* Connection-selective input mux (optional, NULL if not needed) */
	struct hda_input_mux *input_mux;
	/* NID for input-mux */
	hda_nid_t input_mux_nid;
	/* NIDs of corresponding pin widgets (optional) */
	hda_nid_t *input_mux_pins;
	/* digital output */
	hda_nid_t dig_out_nid;
	/* digital input */
	hda_nid_t dig_in_nid;
	/* additional PCMs - NULL-terminated */
	struct hda_usr_pcm_info *extra_pcms[5];
	/* unsolicited events, - NULL-terminated */
	struct codec_config_unsol *unsols[5];
};

int codec_build_preset(const struct hda_codec_table *tbl,
		       struct codec_config_preset *preset);

int codec_preset_add_init_verb(struct codec_config_preset *preset,
			       struct hda_verb *verb);
int codec_preset_add_mixer(struct codec_config_preset *preset,
			   struct hda_std_mixer *mix);

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(ary)	(sizeof(ary) / sizeof((ary)[0]))
#endif

#endif /* __CODECS_COMMON_H_INC */
