#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "hda/types.h"
#include "hda/io.h"
#include "hda/log.h"

int main(int argc, char **argv)
{
	int val;
	unsigned int nid, verb, param;

	if (argc < 5) {
		log_error("usage: wrverb device nid verb parameter\n");
		return 1;
	}
	if (!hda_open_devfile(argv[1]))
		return 1;
	nid = strtol(argv[2], NULL, 0);
	if (nid > 0xff) {
		fprintf(stderr, "invalid nid 0x%x\n", nid);
		return 1;
	}
	verb = strtol(argv[3], NULL, 0);
	if (verb > 0xffff) {
		fprintf(stderr, "invalid verb 0x%x\n", verb);
		return 1;
	}
	param = strtol(argv[4], NULL, 0);
	if (param > 0xffff) {
		fprintf(stderr, "invalid param 0x%x\n", param);
		return 1;
	}
	val = hda_codec_read(nid, verb, param);
	printf("value = 0x%x\n", val);
	hda_close_devfile();
	return 0;
}
