/*
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "measure.h"

static int show_hex = 0;
static int with_proc = 0;
static int fd;

static int lookup(unsigned long addr, struct ksym_lookup_info *info)
{
	memset(info, 0, sizeof(*info));
	info->addr = addr;
	if (ioctl(fd, LAT_TEST_GETSYMBOL, info) < 0)
		fprintf(stderr, "ioctl(GETSYMBOL) err!!\n");
	return *info->name != 0;
}

static void show_trace(struct latency_test_info *info)
{
	int i, j;
	struct ksym_lookup_info rec;

	for (i = 0; i < info->processed; i++) {
		if (i > 0)
			printf("#%d\n", i);
		if (with_proc) {
			char comm[17];
			strncpy(comm, &info->comm[i][0], 16);
			comm[16] = 0;
			printf("  comm=%s\n", comm);
		}
		for (j = 0; j < MAX_STACK; j++) {
			if (! info->stacks[i][j])
				break;
			if (show_hex)
				printf("  <%08lx>", info->stacks[i][j]);
			if (lookup(info->stacks[i][j], &rec))
				printf("  %s (+%lx/%lx)\n", rec.name, rec.offset, rec.size);
			else if (show_hex)
				printf("\n");
		}
	}
}

static void check_dump(char *file, float threshold)
{
	FILE *fp;
	struct latency_info info;
	struct latency_test_info stack;

	if ((fp = fopen(file, "r")) == NULL) {
		fprintf(stderr, "can't open %s\n", file);
		exit(1);
	}

	while (! feof(fp)) {
		int show = 0;
		fread(&info, sizeof(info), 1, fp);
		if (info.with_stack)
			fread(&stack, sizeof(stack), 1, fp);
		if (threshold == 0) {
			if (info.with_stack)
				show = 1;
		} else if (info.sched_diff > threshold)
			show = 1;
		if (show) {
			printf("T=%g diff=%g\n", info.elapsed,
			       info.sched_diff * 1000.0);
			if (info.with_stack)
				show_trace(&stack);
			printf("\n");
		}
	}

	fclose(fp);
}

static void usage(void)
{
	fprintf(stderr, "usage: showtrace [-opts] data-file [threshold(ms)]\n");
}

int main(int argc, char **argv)
{
	int c;
	float threshold = 0;

	while ((c = getopt(argc, argv, "hp")) != -1) {
		switch (c) {
		case 'h':
			show_hex = 1;
			break;
		case 'p':
			with_proc = 1;
			break;
		default:
			usage();
			return 1;
		}
	}

	if (argc - optind < 1) {
		usage();
		return 1;
	}

	if (argc > optind + 1)
		threshold = atof(argv[optind + 1]) / 1000.0;

	fd = open("/dev/midi0", O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "error opening device\n");
		return 1;
	}
	check_dump(argv[optind], threshold);
	return 0;
}
