
#include <math.h>

/* Bring in gd library functions */
#include "gd.h"
#include "gdfonts.h"

/* Bring in standard I/O so we can output the GIF to a file */
#include <stdio.h>

#define CHART_X1 50
#define CHART_X2 840

#define CHART_Y1 20
#define CHART_Y2 599

//#define PIXEL_PER_MS 90
#define GRID_MS 5

int PIXEL_PER_MS;

void draw_chart(char *output_file,float *time_arr,float *latency_arr,float *latency2_arr,int num_samples,float deadline,float fragment_latency,float cpu_latency,int overruns,double max_timediff,double max_timediff2,double time_1ms,double time_2ms,double cpu_time_02ms,double cpu_time_01ms) 
{
        /* Declare the image */
        gdImagePtr im;
        /* Declare an output file */
        FILE *out;
        /* Declare color indexes */
        int black;
        int red;
        int gray;
        int gray2;
        int yellow;
        int green;
        int white;
        int white2;

int oldx,oldy;
int x,y;
int index,i;
double i2;
double time_division;
double total_time;
int tmp_ms;
int over_flag=0;
int old_x1;
char str1[80];

PIXEL_PER_MS=450/(deadline*1000.0);
printf("PIXEL_PER_MS=%d\n",PIXEL_PER_MS);


        /* Allocate the image: 64 pixels across by 64 pixels tall */
        im = gdImageCreate(CHART_X2+20,680 );

        /* Allocate the color black (red, green and blue all minimum).
                Since this is the first color in a new image, it will
                be the background color. */
        black = gdImageColorAllocate(im,0 , 0, 0);
        gray = gdImageColorAllocate(im,64 , 64, 64);
        gray2 = gdImageColorAllocate(im,110 , 110, 110);
        white2 = gdImageColorAllocate(im,200 , 200, 200);
        yellow = gdImageColorAllocate(im,230 , 230, 0);

        red = gdImageColorAllocate(im,255 , 0, 0);
        green = gdImageColorAllocate(im,0 , 255, 0);

        /* Allocate the color white (red, green and blue all maximum). */
        white = gdImageColorAllocate(im, 255, 255, 255);
        



  oldx=CHART_X1+1;
  oldy=CHART_Y2-latency_arr[0]*1000*PIXEL_PER_MS;

  old_x1=CHART_X1;


for(i=CHART_Y2;i>=CHART_Y1;i-=PIXEL_PER_MS)
{
  gdImageLine(im, CHART_X1,i, CHART_X2, i, gray);
}

tmp_ms=0;
for(i=CHART_Y2;i>=CHART_Y1;i-=PIXEL_PER_MS*GRID_MS)
{
  gdImageLine(im, CHART_X1,i, CHART_X2, i, gray2);
  sprintf(str1,"%3.1d ms",tmp_ms);
  tmp_ms+=GRID_MS;
  gdImageString(im, gdFontSmall,7, i-8, str1, white); 
}

  gdImageLine(im, CHART_X1,CHART_Y2, CHART_X2, CHART_Y2, white2);
  gdImageLine(im, CHART_X1,CHART_Y2, CHART_X1, CHART_Y1, white2);


  total_time=time_arr[num_samples-1]-time_arr[0];

  time_division=1.0;
  if(total_time>200.0) time_division=10.0;

  for(i2=0;i2<total_time;i2+=time_division)
  {
    x=CHART_X1+(CHART_X2-CHART_X1)*i2/total_time;
    gdImageLine(im, x,CHART_Y2+3, x, CHART_Y2-3, white2);
  }



  for(i2=0;i2<total_time;i2+=time_division*10.0)
  {
    x=CHART_X1+(CHART_X2-CHART_X1)*i2/total_time;
    gdImageLine(im, x,CHART_Y2+5, x, CHART_Y2-5, white2);
  sprintf(str1,"%.0f",i2);
  gdImageString(im, gdFontSmall,x+2,CHART_Y2+8, str1, white); 
  }

  gdImageString(im, gdFontSmall,CHART_X2-70,CHART_Y2+16, "time (sec)", white); 



for(index=0;index<num_samples;index++)
{
//  x=CHART_X1+index*(CHART_X2-CHART_X1)/(num_samples-1);
  x=CHART_X1+(time_arr[index]-time_arr[0])/total_time*(CHART_X2-CHART_X1);

  y=CHART_Y2-latency_arr[index]*1000*PIXEL_PER_MS;
  if(y<CHART_Y1)
  {
    y=CHART_Y1;
    if((x-old_x1)>30)
    {
      sprintf(str1,"%.1fms",(latency_arr[index]*1000.0));
      gdImageString(im, gdFontSmall,x+2,y-4+10*over_flag, str1, white); 
      over_flag=1-over_flag;
      old_x1=x;
    }
  }

  gdImageLine(im, oldx,oldy, x, y, white);

  oldx=x;
  oldy=y;
  
}

  oldx=CHART_X1+1;
  oldy=CHART_Y2-latency2_arr[0]*1000*PIXEL_PER_MS;

for(index=0;index<num_samples;index++)
{
//  x=CHART_X1+index*(CHART_X2-CHART_X1)/(num_samples-1);
  x=CHART_X1+(time_arr[index]-time_arr[0])/total_time*(CHART_X2-CHART_X1);

  y=CHART_Y2-latency2_arr[index]*1000*PIXEL_PER_MS;
  if(y<CHART_Y1)
  { 
    y=CHART_Y1;
  }

  gdImageLine(im, oldx,oldy, x, y, green);
  oldx=x;
  oldy=y;
  
}




  sprintf(str1,"max latency:   %.1f ms",(max_timediff*1000.0));
  gdImageString(im, gdFontSmall,CHART_X1,CHART_Y2+25 , str1, white); 
  sprintf(str1,"overruns: %d",overruns);
  gdImageString(im, gdFontSmall,CHART_X1+160,CHART_Y2+25 , str1, white); 

  sprintf(str1,"between +/-1ms  : %6.2f%%",(time_1ms/num_samples)*100.0);
  gdImageString(im, gdFontSmall,CHART_X1+300,CHART_Y2+25 , str1, white); 

  sprintf(str1,"between +/-2ms  : %6.2f%%",(time_2ms/num_samples)*100.0);
  gdImageString(im, gdFontSmall,CHART_X1+480,CHART_Y2+25 , str1, white); 

  sprintf(str1,"between +/-0.2ms: %6.2f%%",(cpu_time_02ms/num_samples)*100.0);
  gdImageString(im, gdFontSmall,CHART_X1+300,CHART_Y2+40 , str1, green); 

  sprintf(str1,"between +/-0.1ms: %6.2f%%",(cpu_time_01ms/num_samples)*100.0);
  gdImageString(im, gdFontSmall,CHART_X1+480,CHART_Y2+40 , str1, green); 

  y=CHART_Y2-deadline*1000.0*PIXEL_PER_MS;
gdImageLine(im,CHART_X1,y,CHART_X2,y,red);
  sprintf(str1,"%4.2f ms",(deadline*1000.0));
  gdImageString(im, gdFontSmall,CHART_X1+2, y-12, str1, red); 

  y=CHART_Y2-cpu_latency*1000.0*PIXEL_PER_MS;
  sprintf(str1,"cpu latency:   %4.2f ms (max = %4.2f ms)",(cpu_latency*1000.0),(max_timediff2*1000.0));
  gdImageString(im, gdFontSmall,CHART_X1,CHART_Y2+40 , str1, green); 


  y=CHART_Y2-fragment_latency*1000.0*PIXEL_PER_MS;
gdImageLine(im,CHART_X1,y,CHART_X2,y,yellow);
  sprintf(str1,"fragm.latency: %4.2f ms",(fragment_latency*1000.0));
  gdImageString(im, gdFontSmall,CHART_X1,CHART_Y2+56 , str1, yellow); 



        /* Open a file for writing. "wb" means "write binary", important
                under MSDOS, harmless under Unix. */
        out = fopen(output_file, "wb");

        /* Output the image to the disk file. */
        gdImagePng(im, out);

        /* Close the file. */
        fclose(out);

        /* Destroy the image in memory. */
        gdImageDestroy(im);
}

