#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <fcntl.h>
#include <sched.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <signal.h>
#include <linux/rtc.h>

#include "gfx.h"

#define DEBUG 1

#define MAX_TIME_SAMPLES 250000

double cpu_load=0.80;

#ifdef USE_PENTIUM_TIMER
__inline__ unsigned long long int rdtsc()
                    {
                      unsigned long long int x;
                      __asm__ volatile (".byte 0x0f, 0x31" : "=A" (x));     return x;
                    }
#endif

#ifdef USE_PENTIUM_TIMER
  #define mygettime() (rdtsc() / cpu_hz)
#endif

#ifdef USE_GENERIC_TIMER
double mygettime(void)
{
  static struct timeval mytv;
  gettimeofday(&mytv,NULL);
  return(mytv.tv_sec+mytv.tv_usec/1000000.0);  
}
#endif


int calibrate_loop(void);
int set_realtime_priority(void);
void *my_exithandler(void);
void mydelay(int loops);
void sigio_handler (int sig);

static int rtc_fd;

int u,k,t1;
int counter=0;
int fc=0;
int delta;
int maxdelta=0;
int min_sound_delta=100000000;
double media;
double num_medie=0;
double sum_sound_delta=0;
int sound_delta;
int wb=0;
int sb=0;

double loops_per_sec;
int loops_per_grain;
int loops_per_run;
double grain_len;
double cpu_hz=0.0;

double mytimediff;
double mytimediff2;
double mytime1;
double mytime2;
double mytime3;
double old_mytime3;


double fragment_latency=0.0;
double fragment_latency_minus_1ms,fragment_latency_plus_1ms;
double fragment_latency_minus_2ms,fragment_latency_plus_2ms;

double cpu_latency=0.0;
double cpu_latency_minus_02ms,cpu_latency_plus_02ms;
double cpu_latency_minus_01ms,cpu_latency_plus_01ms;



int SYNC_USECS=0;

int c;


int MYSIZE=0;

float time_arr[MAX_TIME_SAMPLES+1];
float latency_arr[MAX_TIME_SAMPLES+1];
float latency2_arr[MAX_TIME_SAMPLES+1];

short sample_buffer[65536];

#define MYSONGSIZE 25000000


int myerrs=0;

double buffer_latency;

int mynumfragments;
int myfragmentsize;

int overruns=0;
double max_timediff=0.0;
double max_timediff2=0.0;
  pid_t pid=-1;

  int num_time_samples=0;
  int num_times_within_1ms=0;
  int num_times_within_2ms=0;

  int cpu_num_times_within_02ms=0;
  int cpu_num_times_within_01ms=0;

  double mytime_start;
  double mytime_end;
  double mytime_x;

int main(int argc,char **argv)
{




  int res;

  int rtc_interval;
  int oflags;

  mynumfragments=3;

  signal(SIGTERM,my_exithandler);
  signal(SIGINT,my_exithandler);

  old_mytime3=-1.0;


if(argc != 2)
{
  fprintf(stderr,"wrong number of arguments, exiting.\n");
  exit(1);
}

    rtc_interval=atoi(argv[1]);
    if(mynumfragments <2 || mynumfragments >16)
    {
      fprintf(stderr,"num fragments out of range: valid values 2-16\n");
      exit(1);
    }

  printf("rtc_interval=%d\n",rtc_interval);



  if(DEBUG)  fprintf(stderr,"calling mlockall() to prevent pagefaults ....\n");
  if(mlockall(MCL_CURRENT|MCL_FUTURE))
  {
    perror("mlockall() failed, exiting. mlock");
    exit(1);
  }


  res=set_realtime_priority();
  if(res == -1)
  {
    fprintf(stderr,"can't get realtime priority, run the program as root.\n");
    exit(1);
  }

  if(res==0) if(DEBUG) fprintf(stderr,"got realtime scheduling\n");



loops_per_sec=calibrate_loop();

grain_len=1.0/((double)rtc_interval);
loops_per_grain=loops_per_sec*grain_len;

buffer_latency=3.0*grain_len;

if(DEBUG) printf("loops per grain = %d\n",loops_per_grain);
if(DEBUG) printf("GRAIN_LEN=%f ms \n",grain_len*1000.0);

loops_per_run=loops_per_grain*cpu_load;
if(DEBUG) printf("cpu_load=%f  loops per run = %d\n",cpu_load,loops_per_run);





  fragment_latency=grain_len;
  fragment_latency_minus_1ms=fragment_latency-0.001;
  fragment_latency_plus_1ms=fragment_latency+0.001;

  fragment_latency_minus_2ms=fragment_latency-0.002;
  fragment_latency_plus_2ms=fragment_latency+0.002;

  cpu_latency=grain_len*cpu_load;
  cpu_latency_minus_02ms=cpu_latency-0.0002;
  cpu_latency_plus_02ms=cpu_latency+0.0002;

  cpu_latency_minus_01ms=cpu_latency-0.0001;
  cpu_latency_plus_01ms=cpu_latency+0.0001;


printf("grain latency = %f ms\n",fragment_latency*1000.0);
printf("cpu latency = %f ms\n",cpu_latency*1000.0);


        if ((rtc_fd = open ("/dev/rtc", O_RDONLY)) < 0) {
                perror ("open: ");
                return -1;
        }

        signal (SIGIO, sigio_handler);

        if (fcntl (rtc_fd, F_SETOWN, getpid()) < 0) {
                perror ("fcntl setown: ");
                return -1;
        }

        if ((oflags = fcntl (rtc_fd, F_GETFL)) < 0) {
                perror ("fcntl getfl: ");
                return -1;
        }


        if (fcntl (rtc_fd, F_SETFL, oflags | FASYNC) < 0) {
                perror ("fcntl setfl: ");
                return -1;
        }


        if (ioctl(rtc_fd, RTC_IRQP_SET, rtc_interval) < 0) {
                perror ("rtc irq set: ");
                return -1;
        }

        if (ioctl (rtc_fd, RTC_PIE_ON, 0) < 0) {
                perror ("rtc pie on: ");
                return -1;
        }

printf("entering main sleep loop ....\n");
        while (1) {
                sleep (999999999);
        }



mytime_start=mygettime();


  return(0);
}



int set_realtime_priority(void)
{
struct sched_param schp;
	/*
	 * set the process to realtime privs
	 */
        memset(&schp, 0, sizeof(schp));
	schp.sched_priority = sched_get_priority_max(SCHED_FIFO);

	if (sched_setscheduler(0, SCHED_FIFO, &schp) != 0) {
		perror("sched_setscheduler");
		return -1;
	}

	return 0;

}

void *my_exithandler(void)
{
  int overruns2=overruns;
if(pid == 0)
{
 exit(0); // child (sync() process) exits quietly.
}

mytime_end=mygettime();

        close (rtc_fd);


if (overruns2>999) overruns2=999;

if(DEBUG)  printf("\nNUMBER of OVERRUNS = %d  , max latency=%.1f ms  factor=%.1f %% of buffer\n",overruns2,max_timediff*1000.0,(max_timediff/buffer_latency)*100.0);

//printf("% 5.1fms (% 3d)%5.1f%%|",max_timediff*1000.0,overruns2,(max_timediff/buffer_latency)*100.0);
printf("%5.1fms (%3d)|",max_timediff*1000.0,overruns2);

printf("\n1MS num_time_samples=%d num_times_within_1ms=%d factor=%f\n",num_time_samples,num_times_within_1ms,num_times_within_1ms*100.0/num_time_samples);

printf("2MS num_time_samples=%d num_times_within_2ms=%d factor=%f\n",num_time_samples,num_times_within_2ms,num_times_within_2ms*100.0/num_time_samples);
draw_chart("out.png",time_arr,latency_arr,latency2_arr,num_time_samples,buffer_latency,fragment_latency,cpu_latency,overruns,max_timediff,max_timediff2,num_times_within_1ms,num_times_within_2ms,cpu_num_times_within_02ms,cpu_num_times_within_01ms);




if(DEBUG) fprintf(stderr,"\nexiting.\n");

  exit(0);
}




#define NUM_TESTS 1400





int calibrate_loop(void)
{
  FILE *f;
  char *res;
  char s1[100];
  double tmp_loops_per_sec;
  double mytime1,mytime2;

  f=fopen("/proc/cpuinfo","r");
  if(f==NULL)
  {
    perror("can't open /proc/cpuinfo, exiting. open");
    exit(1);
  }

  for(;;)
  {
    res=fgets(s1,100,f);
    if(res==NULL) break;
    if(!memcmp(s1,"cpu MHz",7))
    {
      cpu_hz=atof(&s1[10])*1000000.0;
      break;
    }
  }
  fclose(f);
  if(cpu_hz < 1.0)
  {
    fprintf(stderr,"can't determine CPU clock frequency, exiting.\n");
  }


if(DEBUG) printf("calibrating loop ....\n");

#define CALIB_LOOPS 200000000

mytime1=mygettime();
mydelay(CALIB_LOOPS);
mytime2=mygettime();


if(DEBUG) printf("time diff= %f \n",mytime2-mytime1);

if(DEBUG) printf("loops/sec = %f\n",CALIB_LOOPS/(mytime2-mytime1));
tmp_loops_per_sec=CALIB_LOOPS/(mytime2-mytime1);


return(tmp_loops_per_sec);

}

void mydelay(int loops)
{
  int k=0;
  int u;
  for(u=0;u<loops;u++) k+=1;
}





void sigio_handler (int sig)


{
        unsigned long rtc_data;
        static unsigned long interrupts = 0;

        read (rtc_fd, &rtc_data, sizeof (rtc_data));
        interrupts += (rtc_data >> 8);

//        fprintf (stdout, "%ld\n", interrupts);
//        fflush (stdout);



  mytime1=mygettime();
  mydelay(loops_per_run);
  mytime2=mygettime();
  mytime3=mytime2;

  //printf("before write =%f\n",mytime2);
  //printf("after write  =%f\n",mytime3);


  mytimediff=mytime3-old_mytime3;

  if(old_mytime3 < 0.0) mytimediff=0.0;
  //printf("HANDLER: mytimediff  =%f\n",mytimediff);
  mytimediff2=mytime2-mytime1;

  old_mytime3=mytime3;

  mytime_x=mytime1-mytime_start;
  time_arr[num_time_samples]=mytime_x;
  latency_arr[num_time_samples]=mytimediff;
  latency2_arr[num_time_samples]=mytimediff2;

  num_time_samples++;
  if(num_time_samples >= MAX_TIME_SAMPLES) my_exithandler();

  if(mytimediff >= (fragment_latency_minus_1ms) && mytimediff <= (fragment_latency_plus_1ms)) num_times_within_1ms++;

  if(mytimediff >= (fragment_latency_minus_2ms) && mytimediff <= (fragment_latency_plus_2ms)) num_times_within_2ms++;


  if(mytimediff2 >= (cpu_latency_minus_02ms) && mytimediff2 <= (cpu_latency_plus_02ms)) cpu_num_times_within_02ms++;

  if(mytimediff2 >= (cpu_latency_minus_01ms) && mytimediff2 <= (cpu_latency_plus_01ms)) cpu_num_times_within_01ms++;



  if(mytimediff2 > max_timediff2) max_timediff2=mytimediff2;

  if(mytimediff > max_timediff) max_timediff=mytimediff;
  //printf("DIFF=%f\n",mytimediff*1000.0);


  if(mytimediff >= buffer_latency )
  {
    overruns++;

    if(DEBUG)
    {
      printf("OVERRUN nr=%d :",overruns);
      printf("time diff=%f buffer_latency=%f factor=%.1f %%\n",mytimediff,buffer_latency,(mytimediff/buffer_latency)*100.0);
    }
  }


}

