/*
   iecdump - dump IEC958 status bits on ALSA
   Copyright (C) 2003 by Takashi Iwai <tiwai@suse.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <alsa/asoundlib.h>

extern void dump_iec958(snd_aes_iec958_t *iec);

static void usage(void)
{
	printf("Usage: iecdump [-D device] [-x]\n");
	printf("  -x: dump the AESx hex code for iec958 PCM parameters\n");
}

int main(int argc, char **argv)
{
	const char *dev = "default";
	const char *spdif_str = "IEC958 Playback Default";
	snd_ctl_t *ctl;
	snd_ctl_elem_value_t *cval;
	snd_aes_iec958_t iec958;
	int dumphex = 0;
	int c;

	while ((c = getopt(argc, argv, "D:xh")) != -1) {
		switch (c) {
		case 'D':
			dev = optarg;
			break;
		case 'x':
			dumphex = 1;
			break;
		default:
			usage();
			return 1;
		}
	}

	if (snd_ctl_open(&ctl, dev, 0) < 0) {
		perror("snd_ctl_open");
		return 1;
	}

	snd_ctl_elem_value_alloca(&cval);
	snd_ctl_elem_value_set_interface(cval, SND_CTL_ELEM_IFACE_MIXER);
	snd_ctl_elem_value_set_name(cval, spdif_str);
	if (snd_ctl_elem_read(ctl, cval) < 0) {
		snd_ctl_elem_value_set_interface(cval, SND_CTL_ELEM_IFACE_PCM);
		if (snd_ctl_elem_read(ctl, cval) < 0) {
			perror("snd_ctl_elem_read");
			return 1;
		}
	}

	snd_ctl_elem_value_get_iec958(cval, &iec958);
	if (dumphex)
		printf("AES0=0x%02x,AES1=0x%02x,AES2=0x%02x,AES3=0x%02x\n",
		       iec958.status[0], iec958.status[1], iec958.status[2], iec958.status[3]);
	else
		dump_iec958(&iec958);

	snd_ctl_close(ctl);
	return 0;
}
