/***************************************************************************
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configdialog.h"
#include "archivelimits.h"
#include "archivetypes.h"
#include "specialfiletypes.h"
#include "autoscanoptions.h"
#include "logoptions.h"

#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qobjectlist.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtextcodec.h>
#include <qtooltip.h>
#include <qvbox.h>

#include <kapplication.h> //kapp
#include <kcombobox.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <klocale.h>
#include <kstandarddirs.h>

//////////////////////////////////////////////////////////////////////////////////////////
// PUBLIC
//////////////////////////////////////////////////////////////////////////////////////////

KlamavConfigDialog::KlamavConfigDialog( QWidget *parent, const char* name, KConfigSkeleton *config )
        : KConfigDialog( parent, name, config )
{
    setWFlags( WDestructiveClose );

    // IMPORTANT Don't simply change the page names, they are used as identifiers in other parts of the app.
            m_archivelimits = new ArchiveLimits( 0, "Archive Limits" );
            m_archivetypes = new ArchiveTypes( 0, "Archive Types" );
            m_specialfiletypes = new SpecialFileTypes( 0, "File Types" );
	    m_autoscanoptions = new AutoScanOptions( 0, "Auto-Scan" );
	    m_logoptions = new LogOptions( 0, "Event Logging" );

    // add pages
    addPage( m_archivelimits, i18n( "Archive Limits" ), "ark", i18n( "Configure Archive Limits" ) );
    addPage( m_archivetypes,   i18n( "Archive Types" ), "tgz", i18n( "Configure Archive Types" ) );
    addPage( m_specialfiletypes, i18n( "File Types" ), "folder", i18n( "Configure File Types" ) );
    addPage( m_autoscanoptions, i18n( "Auto-Scan" ), "filefind", i18n( "Configure Auto-Scan" ) );
    addPage( m_logoptions, i18n( "Event Logging" ), "kate", i18n( "Configure Events to Log" ) );

    QObjectList *list = queryList( "QLabel", "infoPixmap" );
    for( QObject *label = list->first(); label; label = list->next() )
        static_cast<QLabel*>(label)->setPixmap( QMessageBox::standardIcon( QMessageBox::Information ) );
    delete list;

    //stop KFont Requesters getting stupidly large
    list = queryList( "QLabel", "m_sampleLabel" );
    for( QObject *label = list->first(); label; label = list->next() )
        static_cast<QLabel*>(label)->setMaximumWidth( 250 );
    delete list;


}

KlamavConfigDialog::~KlamavConfigDialog()
{
}



/** Show page by object name */
void KlamavConfigDialog::showPage( const QCString& page )
{
    for( uint index = 0; index < m_pageList.count(); index++ ) {
        if ( m_pageList[index]->name() == page ) {
            KConfigDialog::showPage( index );
            return;
        }
    }
}

/** Reimplemented from KConfigDialog */
void KlamavConfigDialog::addPage( QWidget *page, const QString &itemName, const QString &pixmapName, const QString &header, bool manage )
{
    // Add the widget pointer to our list, for later reference
    m_pageList << page;

    KConfigDialog::addPage( page, itemName, pixmapName, header, manage );
}





#include "configdialog.moc"
