// SPDX-FileCopyrightText: 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#pragma once

namespace DDEDesktop {
template <class T>
class Singleton
{
public:
    static inline T *instance()
    {
        static T  *_instance = new T;
        return _instance;
    }

protected:
    Singleton(void) {}
    ~Singleton(void) {}
    Singleton(const Singleton &) {}
    Singleton &operator= (const Singleton &);
};
}



