/* gnome-nibbles.c generated by valac 0.40.8, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libgnome-games-support.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_0_PROPERTY,
	NIBBLES_NUM_PROPERTIES
};
static GParamSpec* nibbles_properties[NIBBLES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;
enum  {
	SCOREBOARD_0_PROPERTY,
	SCOREBOARD_NUM_PROPERTIES
};
static GParamSpec* scoreboard_properties[SCOREBOARD_NUM_PROPERTIES];
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
enum  {
	PLAYER_SCORE_BOX_0_PROPERTY,
	PLAYER_SCORE_BOX_NUM_PROPERTIES
};
static GParamSpec* player_score_box_properties[PLAYER_SCORE_BOX_NUM_PROPERTIES];
typedef struct _ControlsGridPrivate ControlsGridPrivate;
enum  {
	CONTROLS_GRID_0_PROPERTY,
	CONTROLS_GRID_NUM_PROPERTIES
};
static GParamSpec* controls_grid_properties[CONTROLS_GRID_NUM_PROPERTIES];

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkApplicationWindow* window;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	GtkHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GeeLinkedList* number_of_players_buttons;
	GeeLinkedList* number_of_ai_buttons;
	GtkButton* next_button;
	GtkButton* start_button;
	GtkBox* grids_box;
	GdkPixbuf* arrow_pixbuf;
	GdkPixbuf* arrow_key_pixbuf;
	GtkStack* statusbar_stack;
	GtkLabel* countdown;
	Scoreboard* scoreboard;
	GdkPixbuf* scoreboard_life;
	PreferencesDialog* preferences_dialog;
	NibblesView* view;
	GtkBox* game_box;
	GamesGridFrame* frame;
	NibblesGame* game;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	guint countdown_id;
	gint seconds;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block1Data {
	int _ref_count_;
	Nibbles* self;
	GtkMessageDialog* dialog;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Nibbles* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block3Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* label;
	GtkButton* button;
};

struct _Block4Data {
	int _ref_count_;
	Nibbles* self;
	gboolean should_unpause;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* game_over_label;
	GtkLabel* msg_label;
	GtkLabel* score_label;
	GtkLabel* points_left_label;
	GtkButton* button;
};

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

struct _ControlsGrid {
	GtkGrid parent_instance;
	ControlsGridPrivate * priv;
};

struct _ControlsGridClass {
	GtkGridClass parent_class;
};

struct _ControlsGridPrivate {
	GtkLabel* name_label;
	GtkImage* arrow_up;
	GtkImage* arrow_down;
	GtkImage* arrow_left;
	GtkImage* arrow_right;
	GtkOverlay* move_up;
	GtkLabel* move_up_label;
	GtkOverlay* move_down;
	GtkLabel* move_down_label;
	GtkOverlay* move_left;
	GtkLabel* move_left_label;
	GtkOverlay* move_right;
	GtkLabel* move_right_label;
};


static gpointer nibbles_parent_class = NULL;
static gpointer scoreboard_parent_class = NULL;
static gpointer player_score_box_parent_class = NULL;
static gpointer controls_grid_parent_class = NULL;

GType nibbles_get_type (void) G_GNUC_CONST;
GType scoreboard_get_type (void) G_GNUC_CONST;
GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES, NibblesPrivate))
#define NIBBLES_COUNTDOWN_TIME 3
static void nibbles_start_game_cb (Nibbles* self);
static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void nibbles_new_game_cb (Nibbles* self);
static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void nibbles_pause_cb (Nibbles* self);
static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void nibbles_preferences_cb (Nibbles* self);
static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void nibbles_scores_cb (Nibbles* self);
static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void nibbles_help_cb (Nibbles* self);
static void _nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void nibbles_show_new_game_screen_cb (Nibbles* self);
static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void nibbles_show_controls_screen_cb (Nibbles* self);
static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void nibbles_back_cb (Nibbles* self);
static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
Nibbles* nibbles_new (void);
Nibbles* nibbles_construct (GType object_type);
static gint nibbles_real_handle_local_options (GApplication* base,
                                        GVariantDict* options);
static void nibbles_real_startup (GApplication* base);
static void nibbles_settings_changed_cb (Nibbles* self,
                                  const gchar* key);
static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self);
#define NIBBLES_GAME_MAX_WORMS 6
static void nibbles_worm_settings_changed_cb (Nibbles* self,
                                       GSettings* changed_worm_settings,
                                       const gchar* key);
static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
static void nibbles_size_allocate_cb (Nibbles* self,
                               GtkAllocation* allocation);
static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                         GtkAllocation* allocation,
                                                         gpointer self);
static gboolean nibbles_window_state_event_cb (Nibbles* self,
                                        GdkEventWindowState* event);
static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                       GdkEventWindowState* event,
                                                                       gpointer self);
static gboolean nibbles_key_press_event_cb (Nibbles* self,
                                     GtkWidget* widget,
                                     GdkEventKey* event);
static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self);
#define NIBBLES_GAME_MAX_HUMANS 4
static void nibbles_change_number_of_players_cb (Nibbles* self,
                                          GtkToggleButton* button);
static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
#define NIBBLES_GAME_MAX_AI 5
static void nibbles_change_number_of_ai_cb (Nibbles* self,
                                     GtkToggleButton* button);
static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self);
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type,
                                     GSettings* settings);
static void nibbles_log_score_cb (Nibbles* self,
                           gint score,
                           gint level_reached);
static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                   gint score,
                                                   gint level_reached,
                                                   gpointer self);
static void nibbles_level_completed_cb (Nibbles* self);
static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                               gpointer self);
static void __lambda13_ (Nibbles* self);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game);
static gboolean nibbles_configure_event_cb (Nibbles* self,
                                     GdkEventConfigure* event);
static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                                 GdkEventConfigure* event,
                                                                 gpointer self);
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
Scoreboard* scoreboard_new (void);
Scoreboard* scoreboard_construct (GType object_type);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self,
                                          const gchar* pixmap,
                                          gint xsize,
                                          gint ysize);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
static void nibbles_show_first_run_screen (Nibbles* self);
static void nibbles_create_scores (Nibbles* self);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
void nibbles_game_save_properties (NibblesGame* self,
                                   GSettings* settings);
static gboolean nibbles_countdown_cb (Nibbles* self);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
void nibbles_game_start (NibblesGame* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval);
void nibbles_view_board_rescale (NibblesView* self,
                                 gint tile_size);
void nibbles_view_boni_rescale (NibblesView* self,
                                gint tile_size);
void nibbles_view_warps_rescale (NibblesView* self,
                                 gint tile_size);
GType worm_get_type (void) G_GNUC_CONST;
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
void nibbles_game_set_tile_size (NibblesGame* self,
                                 gint value);
void nibbles_game_reset (NibblesGame* self);
void nibbles_view_new_level (NibblesView* self,
                             gint level);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_view_connect_worm_signals (NibblesView* self);
void scoreboard_clear (Scoreboard* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
void scoreboard_register (Scoreboard* self,
                          Worm* worm,
                          const gchar* color_name,
                          GdkPixbuf* life_pixbuf);
gchar* nibbles_view_colorval_name (gint colorval);
void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
void nibbles_game_add_worms (NibblesGame* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_show_game_view (Nibbles* self);
static void nibbles_start_game_with_countdown (Nibbles* self);
static gboolean _nibbles_countdown_cb_gsource_func (gpointer self);
static void nibbles_restart_game (Nibbles* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gboolean nibbles_game_get_is_running (NibblesGame* self);
void nibbles_game_stop (NibblesGame* self);
static void __lambda7_ (Block1Data* _data1_,
                 gint response_id);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
gint nibbles_game_get_numworms (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
GType worm_direction_get_type (void) G_GNUC_CONST;
GType controls_grid_get_type (void) G_GNUC_CONST;
gint worm_get_id (Worm* self);
ControlsGrid* controls_grid_new (gint worm_id,
                                 WormProperties* worm_props,
                                 GdkPixbuf* arrow,
                                 GdkPixbuf* arrow_key);
ControlsGrid* controls_grid_construct (GType object_type,
                                       gint worm_id,
                                       WormProperties* worm_props,
                                       GdkPixbuf* arrow,
                                       GdkPixbuf* arrow_key);
static GamesScoresCategory* nibbles_category_request (Nibbles* self,
                                               const gchar* key);
static gchar* nibbles_get_new_scores_key (Nibbles* self,
                                   const gchar* old_key);
static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                           gpointer self);
static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                                          gpointer self);
static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self,
                                                  gint speed,
                                                  gboolean fakes);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_get_fakes (NibblesGame* self);
static void nibbles_game_over (Nibbles* self,
                        gint score,
                        glong lowest_high_score,
                        gint level_reached);
gint nibbles_game_get_start_level (NibblesGame* self);
static void __lambda10_ (Block2Data* _data2_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
#define NIBBLES_GAME_MAX_LEVEL 26
static void __lambda11_ (Block3Data* _data3_);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda12_ (Block3Data* _data3_);
static gboolean ___lambda12__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window,
                                           GSettings* settings,
                                           GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkApplicationWindow* window,
                                                 GSettings* settings,
                                                 GeeArrayList* worm_settings);
static void __lambda8_ (Block4Data* _data4_);
static void ___lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                     gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
gint nibbles_main (gchar** args,
                   int args_length1);
static void nibbles_finalize (GObject * obj);
GType player_score_box_get_type (void) G_GNUC_CONST;
#define SCOREBOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCOREBOARD, ScoreboardPrivate))
gint worm_get_score (Worm* self);
gint worm_get_lives (Worm* self);
PlayerScoreBox* player_score_box_new (const gchar* name,
                                      PangoColor* color,
                                      gint score,
                                      gint lives_left,
                                      GdkPixbuf* life_pixbuf);
PlayerScoreBox* player_score_box_construct (GType object_type,
                                            const gchar* name,
                                            PangoColor* color,
                                            gint score,
                                            gint lives_left,
                                            GdkPixbuf* life_pixbuf);
void player_score_box_update (PlayerScoreBox* self,
                              gint score,
                              gint lives_left);
static void scoreboard_finalize (GObject * obj);
#define PLAYER_SCORE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxPrivate))
#define WORM_MAX_LIVES 12
#define WORM_STARTING_LIVES 6
void player_score_box_update_score (PlayerScoreBox* self,
                                    gint score);
void player_score_box_update_lives (PlayerScoreBox* self,
                                    gint lives_left);
static void player_score_box_finalize (GObject * obj);
#define CONTROLS_GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTROLS_GRID, ControlsGridPrivate))
static void controls_grid_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[8] = {{"start-game", _nibbles_start_game_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_pause_cb_gsimple_action_activate_callback}, {"preferences", _nibbles_preferences_cb_gsimple_action_activate_callback}, {"scores", _nibbles_scores_cb_gsimple_action_activate_callback}, {"help", _nibbles_help_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GActionEntry NIBBLES_menu_entries[3] = {{"show-new-game-screen", _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback}, {"show-controls-screen", _nibbles_show_controls_screen_cb_gsimple_action_activate_callback}, {"back", _nibbles_back_cb_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};

static void
_nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	nibbles_start_game_cb ((Nibbles*) self);
}


static void
_nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	nibbles_new_game_cb ((Nibbles*) self);
}


static void
_nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	nibbles_pause_cb ((Nibbles*) self);
}


static void
_nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	nibbles_preferences_cb ((Nibbles*) self);
}


static void
_nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	nibbles_scores_cb ((Nibbles*) self);
}


static void
_nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	nibbles_help_cb ((Nibbles*) self);
}


static void
_nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	nibbles_about_cb ((Nibbles*) self);
}


static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}


static void
_nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	nibbles_show_new_game_screen_cb ((Nibbles*) self);
}


static void
_nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	nibbles_show_controls_screen_cb ((Nibbles*) self);
}


static void
_nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	nibbles_back_cb ((Nibbles*) self);
}


Nibbles*
nibbles_construct (GType object_type)
{
	Nibbles * self = NULL;
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
	return self;
}


Nibbles*
nibbles_new (void)
{
	return nibbles_construct (TYPE_NIBBLES);
}


static gint
nibbles_real_handle_local_options (GApplication* base,
                                   GVariantDict* options)
{
	Nibbles * self;
	gint result = 0;
	self = (Nibbles*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-nibbles %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}


static void
_nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                 const gchar* key,
                                                 gpointer self)
{
	nibbles_settings_changed_cb ((Nibbles*) self, key);
}


static void
_nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
	nibbles_worm_settings_changed_cb ((Nibbles*) self, _sender, key);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                    GtkAllocation* allocation,
                                                    gpointer self)
{
	nibbles_size_allocate_cb ((Nibbles*) self, allocation);
}


static gboolean
_nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                              GdkEventWindowState* event,
                                                              gpointer self)
{
	gboolean result;
	result = nibbles_window_state_event_cb ((Nibbles*) self, event);
	return result;
}


static gboolean
_nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                        GdkEventKey* event,
                                                        gpointer self)
{
	gboolean result;
	result = nibbles_key_press_event_cb ((Nibbles*) self, _sender, event);
	return result;
}


static void
_nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
	nibbles_change_number_of_players_cb ((Nibbles*) self, _sender);
}


static void
_nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                           gpointer self)
{
	nibbles_change_number_of_ai_cb ((Nibbles*) self, _sender);
}


static void
_nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                              gint score,
                                              gint level_reached,
                                              gpointer self)
{
	nibbles_log_score_cb ((Nibbles*) self, score, level_reached);
}


static void
_nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                          gpointer self)
{
	nibbles_level_completed_cb ((Nibbles*) self);
}


static void
__lambda13_ (Nibbles* self)
{
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "paused");
	} else {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "scoreboard");
	}
}


static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda13_ ((Nibbles*) self);
}


static gboolean
_nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                        GdkEventConfigure* event,
                                                        gpointer self)
{
	gboolean result;
	result = nibbles_configure_event_cb ((Nibbles*) self, event);
	return result;
}


static void
nibbles_real_startup (GApplication* base)
{
	Nibbles * self;
	gchar** argv = NULL;
	gint argv_length1;
	gint _argv_size_;
	GtkSettings* _tmp0_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* _tmp2_;
	GdkScreen* _tmp3_;
	GtkCssProvider* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GeeArrayList* _tmp7_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GAction* _tmp30_;
	GSimpleAction* _tmp31_;
	GAction* _tmp32_;
	GSimpleAction* _tmp33_;
	GAction* _tmp34_;
	GSimpleAction* _tmp35_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_;
	GtkApplicationWindow* _tmp39_;
	GtkApplicationWindow* _tmp40_;
	GtkApplicationWindow* _tmp41_;
	GtkApplicationWindow* _tmp42_;
	GtkApplicationWindow* _tmp43_;
	GSettings* _tmp44_;
	GSettings* _tmp45_;
	GSettings* _tmp46_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_;
	GtkHeaderBar* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_;
	GtkOverlay* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_;
	GtkButton* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_;
	GtkButton* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_;
	GtkStack* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_;
	GtkBox* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_;
	GtkStack* _tmp68_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_;
	GtkLabel* _tmp71_;
	GeeLinkedList* _tmp72_;
	GeeLinkedList* _tmp86_;
	GtkBuilder* _tmp100_;
	GObject* _tmp101_;
	GtkButton* _tmp102_;
	GtkBuilder* _tmp103_;
	GObject* _tmp104_;
	GtkButton* _tmp105_;
	GtkBuilder* _tmp106_;
	GObject* _tmp107_;
	GtkBox* _tmp108_;
	GtkApplicationWindow* _tmp109_;
	GtkHeaderBar* _tmp110_;
	GtkApplicationWindow* _tmp111_;
	GSettings* _tmp112_;
	NibblesGame* _tmp113_;
	NibblesGame* _tmp114_;
	NibblesGame* _tmp115_;
	NibblesGame* _tmp116_;
	NibblesGame* _tmp117_;
	NibblesView* _tmp118_;
	NibblesView* _tmp119_;
	NibblesView* _tmp120_;
	GSettings* _tmp121_;
	NibblesView* _tmp122_;
	GamesGridFrame* _tmp123_;
	GtkBox* _tmp124_;
	GamesGridFrame* _tmp125_;
	Scoreboard* _tmp126_;
	NibblesView* _tmp127_;
	NibblesGame* _tmp128_;
	gint _tmp129_;
	gint _tmp130_;
	NibblesGame* _tmp131_;
	gint _tmp132_;
	gint _tmp133_;
	GdkPixbuf* _tmp134_;
	Scoreboard* _tmp135_;
	GtkStack* _tmp136_;
	Scoreboard* _tmp137_;
	GamesGridFrame* _tmp138_;
	NibblesView* _tmp139_;
	GamesGridFrame* _tmp140_;
	NibblesGame* _tmp141_;
	GSettings* _tmp142_;
	NibblesGame* _tmp143_;
	GSettings* _tmp144_;
	NibblesView* _tmp145_;
	NibblesGame* _tmp146_;
	gint _tmp147_;
	gint _tmp148_;
	NibblesGame* _tmp149_;
	gint _tmp150_;
	gint _tmp151_;
	GdkPixbuf* _tmp152_;
	NibblesView* _tmp153_;
	NibblesGame* _tmp154_;
	gint _tmp155_;
	gint _tmp156_;
	NibblesGame* _tmp157_;
	gint _tmp158_;
	gint _tmp159_;
	GdkPixbuf* _tmp160_;
	gboolean first_run = FALSE;
	GSettings* _tmp161_;
	gboolean _tmp162_;
	GtkApplicationWindow* _tmp163_;
	self = (Nibbles*) base;
	G_APPLICATION_CLASS (nibbles_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	argv = NULL;
	argv_length1 = 0;
	_argv_size_ = argv_length1;
	gtk_clutter_init (&argv_length1, &argv);
	g_set_prgname ("org.gnome.Nibbles");
	g_set_application_name (_ ("Nibbles"));
	gtk_window_set_default_icon_name ("gnome-nibbles");
	_tmp0_ = gtk_settings_get_default ();
	g_object_set ((GObject*) _tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	_tmp1_ = gtk_css_provider_new ();
	css_provider = _tmp1_;
	_tmp2_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp2_, "/org/gnome/nibbles/ui/nibbles.css");
	_tmp3_ = gdk_screen_get_default ();
	_tmp4_ = css_provider;
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, G_N_ELEMENTS (NIBBLES_action_entries), self);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_menu_entries, G_N_ELEMENTS (NIBBLES_menu_entries), self);
	_tmp5_ = g_settings_new ("org.gnome.nibbles");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	_tmp6_ = self->priv->settings;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _nibbles_settings_changed_cb_g_settings_changed, self, 0);
	_tmp7_ = gee_array_list_new (g_settings_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_settings);
	self->priv->worm_settings = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				gchar* name = NULL;
				gint _tmp11_;
				gchar* _tmp12_;
				GeeArrayList* _tmp13_;
				const gchar* _tmp14_;
				GSettings* _tmp15_;
				GSettings* _tmp16_;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				GSettings* _tmp20_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				if (!(_tmp10_ < NIBBLES_GAME_MAX_WORMS)) {
					break;
				}
				_tmp11_ = i;
				_tmp12_ = g_strdup_printf ("org.gnome.nibbles.worm%d", _tmp11_);
				name = _tmp12_;
				_tmp13_ = self->priv->worm_settings;
				_tmp14_ = name;
				_tmp15_ = g_settings_new (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
				_g_object_unref0 (_tmp16_);
				_tmp17_ = self->priv->worm_settings;
				_tmp18_ = i;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
				_tmp20_ = (GSettings*) _tmp19_;
				g_signal_connect_object (_tmp20_, "changed", (GCallback) _nibbles_worm_settings_changed_cb_g_settings_changed, self, 0);
				_g_object_unref0 (_tmp20_);
				_g_free0 (name);
			}
		}
	}
	_tmp21_ = g_strdup ("<Primary>q");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("Escape");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp26_);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_strdup ("F1");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp31_;
	_tmp32_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp33_;
	_tmp34_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp35_;
	_tmp36_ = gtk_builder_new_from_resource ("/org/gnome/nibbles/ui/nibbles.ui");
	builder = _tmp36_;
	_tmp37_ = builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "nibbles-window");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp38_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp39_;
	_tmp40_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "size-allocate", (GCallback) _nibbles_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp41_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp41_, "window-state-event", (GCallback) _nibbles_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp42_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp42_, "key-press-event", (GCallback) _nibbles_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	_tmp43_ = self->priv->window;
	_tmp44_ = self->priv->settings;
	_tmp45_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) _tmp43_, g_settings_get_int (_tmp44_, "window-width"), g_settings_get_int (_tmp45_, "window-height"));
	_tmp46_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp46_, "window-is-maximized")) {
		GtkApplicationWindow* _tmp47_;
		_tmp47_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp47_);
	}
	_tmp48_ = builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "headerbar");
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp50_;
	_tmp51_ = builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "main_overlay");
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp53_;
	_tmp54_ = builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "new_game_button");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp56_;
	_tmp57_ = builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "pause_button");
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp59_;
	_tmp60_ = builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "main_stack");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp62_;
	_tmp63_ = builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "game_box");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->game_box);
	self->priv->game_box = _tmp65_;
	_tmp66_ = builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "statusbar_stack");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->statusbar_stack);
	self->priv->statusbar_stack = _tmp68_;
	_tmp69_ = builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "countdown");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->countdown);
	self->priv->countdown = _tmp71_;
	_tmp72_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->number_of_players_buttons);
	self->priv->number_of_players_buttons = _tmp72_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp73_ = FALSE;
			_tmp73_ = TRUE;
			while (TRUE) {
				gint _tmp75_;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp76_;
				gint _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				GObject* _tmp80_;
				GtkToggleButton* _tmp81_;
				GtkToggleButton* _tmp82_;
				GtkToggleButton* _tmp83_;
				GeeLinkedList* _tmp84_;
				GtkToggleButton* _tmp85_;
				if (!_tmp73_) {
					gint _tmp74_;
					_tmp74_ = i;
					i = _tmp74_ + 1;
				}
				_tmp73_ = FALSE;
				_tmp75_ = i;
				if (!(_tmp75_ < NIBBLES_GAME_MAX_HUMANS)) {
					break;
				}
				_tmp76_ = builder;
				_tmp77_ = i;
				_tmp78_ = g_strdup_printf ("players%d", _tmp77_ + 1);
				_tmp79_ = _tmp78_;
				_tmp80_ = gtk_builder_get_object (_tmp76_, _tmp79_);
				_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_toggle_button_get_type (), GtkToggleButton));
				_tmp82_ = _tmp81_;
				_g_free0 (_tmp79_);
				button = _tmp82_;
				_tmp83_ = button;
				g_signal_connect_object (_tmp83_, "toggled", (GCallback) _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled, self, 0);
				_tmp84_ = self->priv->number_of_players_buttons;
				_tmp85_ = button;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, _tmp85_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp86_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->number_of_ai_buttons);
	self->priv->number_of_ai_buttons = _tmp86_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp87_ = FALSE;
			_tmp87_ = TRUE;
			while (TRUE) {
				gint _tmp89_;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp90_;
				gint _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				GObject* _tmp94_;
				GtkToggleButton* _tmp95_;
				GtkToggleButton* _tmp96_;
				GtkToggleButton* _tmp97_;
				GeeLinkedList* _tmp98_;
				GtkToggleButton* _tmp99_;
				if (!_tmp87_) {
					gint _tmp88_;
					_tmp88_ = i;
					i = _tmp88_ + 1;
				}
				_tmp87_ = FALSE;
				_tmp89_ = i;
				if (!(_tmp89_ <= NIBBLES_GAME_MAX_AI)) {
					break;
				}
				_tmp90_ = builder;
				_tmp91_ = i;
				_tmp92_ = g_strdup_printf ("ai%d", _tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = gtk_builder_get_object (_tmp90_, _tmp93_);
				_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_toggle_button_get_type (), GtkToggleButton));
				_tmp96_ = _tmp95_;
				_g_free0 (_tmp93_);
				button = _tmp96_;
				_tmp97_ = button;
				g_signal_connect_object (_tmp97_, "toggled", (GCallback) _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled, self, 0);
				_tmp98_ = self->priv->number_of_ai_buttons;
				_tmp99_ = button;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, _tmp99_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp100_ = builder;
	_tmp101_ = gtk_builder_get_object (_tmp100_, "next_button");
	_tmp102_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->next_button);
	self->priv->next_button = _tmp102_;
	_tmp103_ = builder;
	_tmp104_ = gtk_builder_get_object (_tmp103_, "start_button");
	_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->start_button);
	self->priv->start_button = _tmp105_;
	_tmp106_ = builder;
	_tmp107_ = gtk_builder_get_object (_tmp106_, "grids_box");
	_tmp108_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->grids_box);
	self->priv->grids_box = _tmp108_;
	_tmp109_ = self->priv->window;
	_tmp110_ = self->priv->headerbar;
	gtk_window_set_titlebar ((GtkWindow*) _tmp109_, (GtkWidget*) _tmp110_);
	_tmp111_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp111_);
	_tmp112_ = self->priv->settings;
	_tmp113_ = nibbles_game_new (_tmp112_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp113_;
	_tmp114_ = self->priv->game;
	g_signal_connect_object (_tmp114_, "log-score", (GCallback) _nibbles_log_score_cb_nibbles_game_log_score, self, 0);
	_tmp115_ = self->priv->game;
	g_signal_connect_object (_tmp115_, "level-completed", (GCallback) _nibbles_level_completed_cb_nibbles_game_level_completed, self, 0);
	_tmp116_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp116_, "notify::is-paused", (GCallback) ___lambda13__g_object_notify, self, 0);
	_tmp117_ = self->priv->game;
	_tmp118_ = nibbles_view_new (_tmp117_);
	g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp118_;
	_tmp119_ = self->priv->view;
	g_signal_connect_object ((GtkWidget*) _tmp119_, "configure-event", (GCallback) _nibbles_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp120_ = self->priv->view;
	_tmp121_ = self->priv->settings;
	_tmp120_->is_muted = !g_settings_get_boolean (_tmp121_, "sound");
	_tmp122_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp122_);
	_tmp123_ = games_grid_frame_new (NIBBLES_GAME_WIDTH, NIBBLES_GAME_HEIGHT);
	g_object_ref_sink (_tmp123_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp123_;
	_tmp124_ = self->priv->game_box;
	_tmp125_ = self->priv->frame;
	gtk_box_pack_start (_tmp124_, (GtkWidget*) _tmp125_, TRUE, TRUE, (guint) 0);
	_tmp126_ = scoreboard_new ();
	g_object_ref_sink (_tmp126_);
	_g_object_unref0 (self->priv->scoreboard);
	self->priv->scoreboard = _tmp126_;
	_tmp127_ = self->priv->view;
	_tmp128_ = self->priv->game;
	_tmp129_ = nibbles_game_get_tile_size (_tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = self->priv->game;
	_tmp132_ = nibbles_game_get_tile_size (_tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = nibbles_view_load_pixmap_file (_tmp127_, "scoreboard-life.svg", 2 * _tmp130_, 2 * _tmp133_);
	_g_object_unref0 (self->priv->scoreboard_life);
	self->priv->scoreboard_life = _tmp134_;
	_tmp135_ = self->priv->scoreboard;
	gtk_widget_show ((GtkWidget*) _tmp135_);
	_tmp136_ = self->priv->statusbar_stack;
	_tmp137_ = self->priv->scoreboard;
	gtk_stack_add_named (_tmp136_, (GtkWidget*) _tmp137_, "scoreboard");
	_tmp138_ = self->priv->frame;
	_tmp139_ = self->priv->view;
	gtk_container_add ((GtkContainer*) _tmp138_, (GtkWidget*) _tmp139_);
	_tmp140_ = self->priv->frame;
	gtk_widget_show ((GtkWidget*) _tmp140_);
	_tmp141_ = self->priv->game;
	_tmp142_ = self->priv->settings;
	nibbles_game_set_numhumans (_tmp141_, g_settings_get_int (_tmp142_, "players"));
	_tmp143_ = self->priv->game;
	_tmp144_ = self->priv->settings;
	nibbles_game_set_numai (_tmp143_, g_settings_get_int (_tmp144_, "ai"));
	_tmp145_ = self->priv->view;
	_tmp146_ = self->priv->game;
	_tmp147_ = nibbles_game_get_tile_size (_tmp146_);
	_tmp148_ = _tmp147_;
	_tmp149_ = self->priv->game;
	_tmp150_ = nibbles_game_get_tile_size (_tmp149_);
	_tmp151_ = _tmp150_;
	_tmp152_ = nibbles_view_load_pixmap_file (_tmp145_, "arrow.svg", 5 * _tmp148_, 5 * _tmp151_);
	_g_object_unref0 (self->priv->arrow_pixbuf);
	self->priv->arrow_pixbuf = _tmp152_;
	_tmp153_ = self->priv->view;
	_tmp154_ = self->priv->game;
	_tmp155_ = nibbles_game_get_tile_size (_tmp154_);
	_tmp156_ = _tmp155_;
	_tmp157_ = self->priv->game;
	_tmp158_ = nibbles_game_get_tile_size (_tmp157_);
	_tmp159_ = _tmp158_;
	_tmp160_ = nibbles_view_load_pixmap_file (_tmp153_, "arrow-key.svg", 5 * _tmp156_, 5 * _tmp159_);
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
	self->priv->arrow_key_pixbuf = _tmp160_;
	_tmp161_ = self->priv->settings;
	first_run = g_settings_get_boolean (_tmp161_, "first-run");
	_tmp162_ = first_run;
	if (_tmp162_) {
		nibbles_show_first_run_screen (self);
	} else {
		nibbles_show_new_game_screen_cb (self);
	}
	nibbles_create_scores (self);
	_tmp163_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp163_);
	_g_object_unref0 (builder);
	_g_object_unref0 (css_provider);
}


static void
nibbles_real_activate (GApplication* base)
{
	Nibbles * self;
	GtkApplicationWindow* _tmp0_;
	self = (Nibbles*) base;
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void
nibbles_real_shutdown (GApplication* base)
{
	Nibbles * self;
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gboolean _tmp5_;
	NibblesGame* _tmp6_;
	GSettings* _tmp7_;
	self = (Nibbles*) base;
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->game;
	_tmp7_ = self->priv->settings;
	nibbles_game_save_properties (_tmp6_, _tmp7_);
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static gboolean
nibbles_countdown_cb (Nibbles* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	GtkLabel* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->seconds;
	self->priv->seconds = _tmp0_ - 1;
	_tmp1_ = self->priv->seconds;
	if (_tmp1_ == 0) {
		GtkStack* _tmp2_;
		NibblesView* _tmp3_;
		ClutterActor* _tmp4_;
		ClutterActor* _tmp5_;
		NibblesGame* _tmp6_;
		NibblesGame* _tmp7_;
		GSimpleAction* _tmp8_;
		GSimpleAction* _tmp9_;
		_tmp2_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp2_, "scoreboard");
		_tmp3_ = self->priv->view;
		_tmp4_ = nibbles_view_get_name_labels (_tmp3_);
		_tmp5_ = _tmp4_;
		clutter_actor_hide (_tmp5_);
		_tmp6_ = self->priv->game;
		nibbles_game_add_bonus (_tmp6_, TRUE);
		_tmp7_ = self->priv->game;
		nibbles_game_start (_tmp7_);
		_tmp8_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp8_, TRUE);
		_tmp9_ = self->priv->back_action;
		g_simple_action_set_enabled (_tmp9_, TRUE);
		self->priv->countdown_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp10_ = self->priv->countdown;
	_tmp11_ = self->priv->seconds;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean
nibbles_key_press_event_cb (Nibbles* self,
                            GtkWidget* widget,
                            GdkEventKey* event)
{
	gboolean result = FALSE;
	NibblesGame* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = event->keyval;
	result = nibbles_game_handle_keypress (_tmp0_, _tmp1_);
	return result;
}


static void
nibbles_size_allocate_cb (Nibbles* self,
                          GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->window;
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
	self->priv->window_width = _tmp4_;
	self->priv->window_height = _tmp5_;
}


static gboolean
nibbles_window_state_event_cb (Nibbles* self,
                               GdkEventWindowState* event)
{
	gboolean result = FALSE;
	GdkWindowState _tmp0_;
	GdkWindowState _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->changed_mask;
	if ((_tmp0_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkWindowState _tmp1_;
		_tmp1_ = event->new_window_state;
		self->priv->is_maximized = (_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp2_ = event->changed_mask;
	if ((_tmp2_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkWindowState _tmp3_;
		_tmp3_ = event->new_window_state;
		self->priv->is_tiled = (_tmp3_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean
nibbles_configure_event_cb (Nibbles* self,
                            GdkEventConfigure* event)
{
	gboolean result = FALSE;
	gint tile_size = 0;
	gint ts_x = 0;
	gint ts_y = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	NibblesGame* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->width;
	ts_x = _tmp0_ / NIBBLES_GAME_WIDTH;
	_tmp1_ = event->height;
	ts_y = _tmp1_ / NIBBLES_GAME_HEIGHT;
	_tmp2_ = ts_x;
	_tmp3_ = event->width;
	if ((_tmp2_ * NIBBLES_GAME_WIDTH) > _tmp3_) {
		gint _tmp4_;
		_tmp4_ = ts_x;
		ts_x = _tmp4_ - 1;
	}
	_tmp5_ = ts_y;
	_tmp6_ = event->height;
	if ((_tmp5_ * NIBBLES_GAME_HEIGHT) > _tmp6_) {
		gint _tmp7_;
		_tmp7_ = ts_y;
		ts_y = _tmp7_ - 1;
	}
	_tmp8_ = ts_x;
	_tmp9_ = ts_y;
	tile_size = MIN (_tmp8_, _tmp9_);
	_tmp11_ = tile_size;
	if (_tmp11_ == 0) {
		_tmp10_ = TRUE;
	} else {
		NibblesGame* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = self->priv->game;
		_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ == 0;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	_tmp15_ = self->priv->game;
	_tmp16_ = nibbles_game_get_tile_size (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = tile_size;
	if (_tmp17_ != _tmp18_) {
		NibblesView* _tmp19_;
		ClutterActor* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		NibblesView* _tmp23_;
		gint _tmp24_;
		NibblesView* _tmp25_;
		gint _tmp26_;
		NibblesView* _tmp27_;
		gint _tmp28_;
		NibblesGame* _tmp44_;
		gint _tmp45_;
		_tmp19_ = self->priv->view;
		_tmp20_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) _tmp19_);
		_tmp21_ = tile_size;
		_tmp22_ = tile_size;
		clutter_actor_set_size (_tmp20_, (gfloat) (_tmp21_ * NIBBLES_GAME_WIDTH), (gfloat) (_tmp22_ * NIBBLES_GAME_HEIGHT));
		_tmp23_ = self->priv->view;
		_tmp24_ = tile_size;
		nibbles_view_board_rescale (_tmp23_, _tmp24_);
		_tmp25_ = self->priv->view;
		_tmp26_ = tile_size;
		nibbles_view_boni_rescale (_tmp25_, _tmp26_);
		_tmp27_ = self->priv->view;
		_tmp28_ = tile_size;
		nibbles_view_warps_rescale (_tmp27_, _tmp28_);
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesGame* _tmp29_;
			GeeLinkedList* _tmp30_;
			GeeLinkedList* _tmp31_;
			GeeLinkedList* _tmp32_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _worm_index = 0;
			_tmp29_ = self->priv->game;
			_tmp30_ = nibbles_game_get_worms (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			_worm_list = _tmp32_;
			_tmp33_ = _worm_list;
			_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_worm_size = _tmp35_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp39_;
				gint _tmp40_;
				gpointer _tmp41_;
				Worm* _tmp42_;
				gint _tmp43_;
				_tmp36_ = _worm_index;
				_worm_index = _tmp36_ + 1;
				_tmp37_ = _worm_index;
				_tmp38_ = _worm_size;
				if (!(_tmp37_ < _tmp38_)) {
					break;
				}
				_tmp39_ = _worm_list;
				_tmp40_ = _worm_index;
				_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
				worm = (Worm*) _tmp41_;
				_tmp42_ = worm;
				_tmp43_ = tile_size;
				g_signal_emit_by_name (_tmp42_, "rescaled", _tmp43_);
				_g_object_unref0 (worm);
			}
			_g_object_unref0 (_worm_list);
		}
		_tmp44_ = self->priv->game;
		_tmp45_ = tile_size;
		nibbles_game_set_tile_size (_tmp44_, _tmp45_);
	}
	result = FALSE;
	return result;
}


static void
_scoreboard_update_g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
	scoreboard_update ((Scoreboard*) self);
}


static void
nibbles_start_game_cb (Nibbles* self)
{
	GSettings* _tmp0_;
	NibblesGame* _tmp1_;
	NibblesView* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesView* _tmp6_;
	Scoreboard* _tmp7_;
	NibblesGame* _tmp39_;
	NibblesView* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
	_tmp1_ = self->priv->game;
	nibbles_game_reset (_tmp1_);
	_tmp2_ = self->priv->view;
	_tmp3_ = self->priv->game;
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
	_tmp5_ = _tmp4_;
	nibbles_view_new_level (_tmp2_, _tmp5_);
	_tmp6_ = self->priv->view;
	nibbles_view_connect_worm_signals (_tmp6_);
	_tmp7_ = self->priv->scoreboard;
	scoreboard_clear (_tmp7_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp8_;
		GeeLinkedList* _tmp9_;
		GeeLinkedList* _tmp10_;
		GeeLinkedList* _tmp11_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _worm_index = 0;
		_tmp8_ = self->priv->game;
		_tmp9_ = nibbles_game_get_worms (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_worm_list = _tmp11_;
		_tmp12_ = _worm_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_worm_size = _tmp14_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			gint color = 0;
			NibblesGame* _tmp21_;
			GeeHashMap* _tmp22_;
			GeeHashMap* _tmp23_;
			Worm* _tmp24_;
			gpointer _tmp25_;
			WormProperties* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			Scoreboard* _tmp29_;
			Worm* _tmp30_;
			gint _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GdkPixbuf* _tmp34_;
			Worm* _tmp35_;
			Scoreboard* _tmp36_;
			Worm* _tmp37_;
			Scoreboard* _tmp38_;
			_tmp15_ = _worm_index;
			_worm_index = _tmp15_ + 1;
			_tmp16_ = _worm_index;
			_tmp17_ = _worm_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _worm_list;
			_tmp19_ = _worm_index;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
			worm = (Worm*) _tmp20_;
			_tmp21_ = self->priv->game;
			_tmp22_ = nibbles_game_get_worm_props (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = worm;
			_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
			_tmp26_ = (WormProperties*) _tmp25_;
			_tmp27_ = (*_tmp26_).color;
			_tmp28_ = _tmp27_;
			_worm_properties_free0 (_tmp26_);
			color = _tmp28_;
			_tmp29_ = self->priv->scoreboard;
			_tmp30_ = worm;
			_tmp31_ = color;
			_tmp32_ = nibbles_view_colorval_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->scoreboard_life;
			scoreboard_register (_tmp29_, _tmp30_, _tmp33_, _tmp34_);
			_g_free0 (_tmp33_);
			_tmp35_ = worm;
			_tmp36_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp35_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp36_, 0);
			_tmp37_ = worm;
			_tmp38_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp37_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp38_, 0);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp39_ = self->priv->game;
	nibbles_game_add_worms (_tmp39_);
	_tmp40_ = self->priv->view;
	nibbles_view_create_name_labels (_tmp40_);
	nibbles_show_game_view (self);
	nibbles_start_game_with_countdown (self);
}


static gboolean
_nibbles_countdown_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_countdown_cb ((Nibbles*) self);
	return result;
}


static void
nibbles_start_game_with_countdown (Nibbles* self)
{
	GtkStack* _tmp0_;
	GSimpleAction* _tmp1_;
	NibblesView* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->statusbar_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "countdown");
	_tmp1_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	self->priv->seconds = NIBBLES_COUNTDOWN_TIME;
	_tmp2_ = self->priv->view;
	_tmp3_ = nibbles_view_get_name_labels (_tmp2_);
	_tmp4_ = _tmp3_;
	clutter_actor_show (_tmp4_);
	_tmp5_ = self->priv->countdown;
	_tmp6_ = g_strdup_printf ("%i", NIBBLES_COUNTDOWN_TIME);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
}


static void
nibbles_restart_game (Nibbles* self)
{
	NibblesView* _tmp0_;
	NibblesGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NibblesGame* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
	_tmp3_ = _tmp2_;
	nibbles_view_new_level (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->game;
	nibbles_game_add_worms (_tmp4_);
	nibbles_start_game_with_countdown (self);
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Nibbles* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
__lambda7_ (Block1Data* _data1_,
            gint response_id)
{
	Nibbles* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = _data1_->self;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		nibbles_show_new_game_screen_cb (self);
	}
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = response_id == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp1_) {
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = nibbles_game_get_is_paused (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp5_;
		NibblesView* _tmp7_;
		_tmp5_ = self->priv->seconds;
		if (_tmp5_ == 0) {
			NibblesGame* _tmp6_;
			_tmp6_ = self->priv->game;
			nibbles_game_start (_tmp6_);
		} else {
			self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp7_ = self->priv->view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	}
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
}


static void
___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda7_ (self, response_id);
}


static void
nibbles_new_game_cb (Nibbles* self)
{
	Block1Data* _data1_;
	guint _tmp0_;
	NibblesGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkApplicationWindow* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkButton* button = NULL;
	GtkWidget* _tmp8_;
	GtkButton* _tmp9_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->countdown_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->countdown_id;
		g_source_remove (_tmp1_);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		NibblesGame* _tmp5_;
		_tmp5_ = self->priv->game;
		nibbles_game_stop (_tmp5_);
	}
	_tmp6_ = self->priv->window;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp6_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Are you sure you want to start a new game?"));
	g_object_ref_sink (_tmp7_);
	_data1_->dialog = _tmp7_;
	g_object_set (_data1_->dialog, "secondary-text", _ ("If you start a new game, the current one will be lost."), NULL);
	_tmp8_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data1_->dialog, (gint) GTK_RESPONSE_OK);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton));
	button = _tmp9_;
	gtk_button_set_label (button, _ ("_New Game"));
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda7__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data1_->dialog);
	_g_object_unref0 (button);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void
nibbles_pause_cb (Nibbles* self)
{
	NibblesGame* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = nibbles_game_get_is_running (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			NibblesGame* _tmp4_;
			GtkButton* _tmp5_;
			_tmp4_ = self->priv->game;
			nibbles_game_pause (_tmp4_);
			_tmp5_ = self->priv->pause_button;
			gtk_button_set_label (_tmp5_, _ ("_Resume"));
		} else {
			NibblesGame* _tmp6_;
			GtkButton* _tmp7_;
			NibblesView* _tmp8_;
			_tmp6_ = self->priv->game;
			nibbles_game_unpause (_tmp6_);
			_tmp7_ = self->priv->pause_button;
			gtk_button_set_label (_tmp7_, _ ("_Pause"));
			_tmp8_ = self->priv->view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
		}
	}
}


static void
nibbles_settings_changed_cb (Nibbles* self,
                             const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp3_;
				GSettings* _tmp4_;
				_tmp3_ = self->priv->game;
				_tmp4_ = self->priv->settings;
				nibbles_game_set_speed (_tmp3_, g_settings_get_int (_tmp4_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("sound")))) {
		switch (0) {
			default:
			{
				NibblesView* _tmp5_;
				GSettings* _tmp6_;
				_tmp5_ = self->priv->view;
				_tmp6_ = self->priv->settings;
				_tmp5_->is_muted = !g_settings_get_boolean (_tmp6_, key);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("fakes")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp7_;
				GSettings* _tmp8_;
				_tmp7_ = self->priv->game;
				_tmp8_ = self->priv->settings;
				nibbles_game_set_fakes (_tmp7_, g_settings_get_boolean (_tmp8_, key));
				break;
			}
		}
	}
}


static void
nibbles_worm_settings_changed_cb (Nibbles* self,
                                  GSettings* changed_worm_settings,
                                  const gchar* key)
{
	NibblesGame* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint id = 0;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	NibblesGame* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Worm* worm = NULL;
	NibblesGame* _tmp10_;
	GeeLinkedList* _tmp11_;
	GeeLinkedList* _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_;
	WormProperties* properties = NULL;
	NibblesGame* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	Worm* _tmp18_;
	gpointer _tmp19_;
	const gchar* _tmp20_;
	GQuark _tmp22_ = 0U;
	static GQuark _tmp21_label0 = 0;
	static GQuark _tmp21_label1 = 0;
	static GQuark _tmp21_label2 = 0;
	static GQuark _tmp21_label3 = 0;
	static GQuark _tmp21_label4 = 0;
	NibblesGame* _tmp28_;
	GeeHashMap* _tmp29_;
	GeeHashMap* _tmp30_;
	Worm* _tmp31_;
	WormProperties* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_worm_settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = self->priv->worm_settings;
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp5_, changed_worm_settings);
	_tmp6_ = id;
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_numworms (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp6_ >= _tmp9_) {
		return;
	}
	_tmp10_ = self->priv->game;
	_tmp11_ = nibbles_game_get_worms (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = id;
	_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
	worm = (Worm*) _tmp14_;
	_tmp15_ = self->priv->game;
	_tmp16_ = nibbles_game_get_worm_props (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = worm;
	_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
	properties = (WormProperties*) _tmp19_;
	_tmp20_ = key;
	_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
	if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("color")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp23_;
				_tmp23_ = properties;
				(*_tmp23_).color = g_settings_get_enum (changed_worm_settings, "color");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("key-up")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp24_;
				_tmp24_ = properties;
				(*_tmp24_).up = (guint) g_settings_get_int (changed_worm_settings, "key-up");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label2) ? _tmp21_label2 : (_tmp21_label2 = g_quark_from_static_string ("key-down")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp25_;
				_tmp25_ = properties;
				(*_tmp25_).down = (guint) g_settings_get_int (changed_worm_settings, "key-down");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label3) ? _tmp21_label3 : (_tmp21_label3 = g_quark_from_static_string ("key-left")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp26_;
				_tmp26_ = properties;
				(*_tmp26_).left = (guint) g_settings_get_int (changed_worm_settings, "key-left");
				break;
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label4) ? _tmp21_label4 : (_tmp21_label4 = g_quark_from_static_string ("key-right")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp27_;
				_tmp27_ = properties;
				(*_tmp27_).right = (guint) g_settings_get_int (changed_worm_settings, "key-right");
				break;
			}
		}
	}
	_tmp28_ = self->priv->game;
	_tmp29_ = nibbles_game_get_worm_props (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = worm;
	_tmp32_ = properties;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, _tmp32_);
	_worm_properties_free0 (properties);
	_g_object_unref0 (worm);
}


static void
nibbles_show_first_run_screen (Nibbles* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "first_run");
}


static void
nibbles_show_new_game_screen_cb (Nibbles* self)
{
	guint _tmp0_;
	NibblesGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkHeaderBar* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GeeLinkedList* _tmp12_;
	NibblesGame* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	GtkToggleButton* _tmp17_;
	GeeLinkedList* _tmp18_;
	NibblesGame* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gpointer _tmp22_;
	GtkToggleButton* _tmp23_;
	GtkApplicationWindow* _tmp24_;
	GtkButton* _tmp25_;
	GtkStack* _tmp26_;
	GtkStack* _tmp27_;
	GtkStack* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->countdown_id;
		g_source_remove (_tmp1_);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		NibblesGame* _tmp5_;
		_tmp5_ = self->priv->game;
		nibbles_game_stop (_tmp5_);
	}
	_tmp6_ = self->priv->headerbar;
	gtk_header_bar_set_title (_tmp6_, _ ("Nibbles"));
	_tmp7_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp9_, TRUE);
	_tmp10_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->number_of_players_buttons;
	_tmp13_ = self->priv->game;
	_tmp14_ = nibbles_game_get_numhumans (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp15_ - 1);
	_tmp17_ = (GtkToggleButton*) _tmp16_;
	gtk_toggle_button_set_active (_tmp17_, TRUE);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->number_of_ai_buttons;
	_tmp19_ = self->priv->game;
	_tmp20_ = nibbles_game_get_numai (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp21_);
	_tmp23_ = (GtkToggleButton*) _tmp22_;
	gtk_toggle_button_set_active (_tmp23_, TRUE);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = self->priv->window;
	_tmp25_ = self->priv->next_button;
	gtk_window_set_default ((GtkWindow*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp26_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp27_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp27_, "number_of_players");
	_tmp28_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp28_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
}


static void
nibbles_show_controls_screen_cb (Nibbles* self)
{
	NibblesGame* _tmp40_;
	NibblesGame* _tmp41_;
	GeeArrayList* _tmp42_;
	GtkBox* _tmp43_;
	GList* _tmp44_;
	GtkApplicationWindow* _tmp77_;
	GtkButton* _tmp78_;
	GtkStack* _tmp79_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _button_index = 0;
		_tmp0_ = self->priv->number_of_players_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_button_list = _tmp1_;
		_tmp2_ = _button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_button_size = _tmp4_;
		_button_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkToggleButton* _tmp11_;
			_tmp5_ = _button_index;
			_button_index = _tmp5_ + 1;
			_tmp6_ = _button_index;
			_tmp7_ = _button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _button_list;
			_tmp9_ = _button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = button;
			if (gtk_toggle_button_get_active (_tmp11_)) {
				gint numhumans = 0;
				GtkToggleButton* _tmp12_;
				const gchar* _tmp13_;
				NibblesGame* _tmp14_;
				gint _tmp15_;
				GSettings* _tmp16_;
				NibblesGame* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				numhumans = -1;
				_tmp12_ = button;
				_tmp13_ = gtk_button_get_label ((GtkButton*) _tmp12_);
				sscanf (_tmp13_, "_%d", &numhumans);
				_tmp14_ = self->priv->game;
				_tmp15_ = numhumans;
				nibbles_game_set_numhumans (_tmp14_, _tmp15_);
				_tmp16_ = self->priv->settings;
				_tmp17_ = self->priv->game;
				_tmp18_ = nibbles_game_get_numhumans (_tmp17_);
				_tmp19_ = _tmp18_;
				g_settings_set_int (_tmp16_, "players", _tmp19_);
				_g_object_unref0 (button);
				break;
			}
			_g_object_unref0 (button);
		}
		_g_object_unref0 (_button_list);
	}
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp20_;
		GeeLinkedList* _tmp21_;
		gint _button_size = 0;
		GeeLinkedList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _button_index = 0;
		_tmp20_ = self->priv->number_of_ai_buttons;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_button_list = _tmp21_;
		_tmp22_ = _button_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_button_size = _tmp24_;
		_button_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			GtkToggleButton* _tmp31_;
			_tmp25_ = _button_index;
			_button_index = _tmp25_ + 1;
			_tmp26_ = _button_index;
			_tmp27_ = _button_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _button_list;
			_tmp29_ = _button_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			button = (GtkToggleButton*) _tmp30_;
			_tmp31_ = button;
			if (gtk_toggle_button_get_active (_tmp31_)) {
				gint numai = 0;
				GtkToggleButton* _tmp32_;
				const gchar* _tmp33_;
				NibblesGame* _tmp34_;
				gint _tmp35_;
				GSettings* _tmp36_;
				NibblesGame* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				numai = -1;
				_tmp32_ = button;
				_tmp33_ = gtk_button_get_label ((GtkButton*) _tmp32_);
				sscanf (_tmp33_, "_%d", &numai);
				_tmp34_ = self->priv->game;
				_tmp35_ = numai;
				nibbles_game_set_numai (_tmp34_, _tmp35_);
				_tmp36_ = self->priv->settings;
				_tmp37_ = self->priv->game;
				_tmp38_ = nibbles_game_get_numai (_tmp37_);
				_tmp39_ = _tmp38_;
				g_settings_set_int (_tmp36_, "ai", _tmp39_);
				_g_object_unref0 (button);
				break;
			}
			_g_object_unref0 (button);
		}
		_g_object_unref0 (_button_list);
	}
	_tmp40_ = self->priv->game;
	nibbles_game_create_worms (_tmp40_);
	_tmp41_ = self->priv->game;
	_tmp42_ = self->priv->worm_settings;
	nibbles_game_load_worm_properties (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->grids_box;
	_tmp44_ = gtk_container_get_children ((GtkContainer*) _tmp43_);
	{
		GList* grid_collection = NULL;
		GList* grid_it = NULL;
		grid_collection = _tmp44_;
		for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
			GtkWidget* grid = NULL;
			grid = (GtkWidget*) grid_it->data;
			{
				GtkWidget* _tmp45_;
				_tmp45_ = grid;
				gtk_widget_destroy (_tmp45_);
			}
		}
		(grid_collection == NULL) ? NULL : (grid_collection = (g_list_free (grid_collection), NULL));
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp46_;
		GeeLinkedList* _tmp47_;
		GeeLinkedList* _tmp48_;
		GeeLinkedList* _tmp49_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _worm_index = 0;
		_tmp46_ = self->priv->game;
		_tmp47_ = nibbles_game_get_worms (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _g_object_ref0 (_tmp48_);
		_worm_list = _tmp49_;
		_tmp50_ = _worm_list;
		_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_worm_size = _tmp52_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp56_;
			gint _tmp57_;
			gpointer _tmp58_;
			Worm* _tmp59_;
			gboolean _tmp60_;
			_tmp53_ = _worm_index;
			_worm_index = _tmp53_ + 1;
			_tmp54_ = _worm_index;
			_tmp55_ = _worm_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _worm_list;
			_tmp57_ = _worm_index;
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _tmp57_);
			worm = (Worm*) _tmp58_;
			_tmp59_ = worm;
			_tmp60_ = _tmp59_->is_human;
			if (_tmp60_) {
				ControlsGrid* grid = NULL;
				Worm* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				NibblesGame* _tmp64_;
				GeeHashMap* _tmp65_;
				GeeHashMap* _tmp66_;
				Worm* _tmp67_;
				gpointer _tmp68_;
				WormProperties* _tmp69_;
				GdkPixbuf* _tmp70_;
				GdkPixbuf* _tmp71_;
				WormProperties _tmp72_;
				ControlsGrid* _tmp73_;
				ControlsGrid* _tmp74_;
				GtkBox* _tmp75_;
				ControlsGrid* _tmp76_;
				_tmp61_ = worm;
				_tmp62_ = worm_get_id (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = self->priv->game;
				_tmp65_ = nibbles_game_get_worm_props (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = worm;
				_tmp68_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp66_, _tmp67_);
				_tmp69_ = (WormProperties*) _tmp68_;
				_tmp70_ = self->priv->arrow_pixbuf;
				_tmp71_ = self->priv->arrow_key_pixbuf;
				_tmp72_ = *_tmp69_;
				_tmp73_ = controls_grid_new (_tmp63_, &_tmp72_, _tmp70_, _tmp71_);
				g_object_ref_sink (_tmp73_);
				_tmp74_ = _tmp73_;
				_worm_properties_free0 (_tmp69_);
				grid = _tmp74_;
				_tmp75_ = self->priv->grids_box;
				_tmp76_ = grid;
				gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
				_g_object_unref0 (grid);
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp77_ = self->priv->window;
	_tmp78_ = self->priv->start_button;
	gtk_window_set_default ((GtkWindow*) _tmp77_, (GtkWidget*) _tmp78_);
	_tmp79_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp79_, "controls");
}


static void
nibbles_show_game_view (Nibbles* self)
{
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GSimpleAction* _tmp3_;
	GtkHeaderBar* _tmp4_;
	NibblesGame* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->pause_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->headerbar;
	_tmp5_ = self->priv->game;
	_tmp6_ = nibbles_game_get_current_level (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Level %d"), _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_header_bar_set_title (_tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp10_, "game_box");
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp11_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
}


static void
nibbles_back_cb (Nibbles* self)
{
	GtkStack* _tmp0_;
	gchar* child_name = NULL;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	GtkStack* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	child_name = _tmp3_;
	_tmp4_ = child_name;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first_run")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp8_;
				_tmp8_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				nibbles_new_game_cb (self);
				break;
			}
		}
	}
	_tmp9_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_g_free0 (child_name);
}


static void
nibbles_change_number_of_players_cb (Nibbles* self,
                                     GtkToggleButton* button)
{
	gint numhumans = 0;
	const gchar* _tmp16_;
	gint min_ai = 0;
	gint _tmp17_;
	gint max_ai = 0;
	gint _tmp18_;
	gint _tmp47_;
	GeeLinkedList* _tmp51_;
	gint _tmp52_;
	gpointer _tmp53_;
	GtkToggleButton* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_button_index = 0;
		_tmp0_ = self->priv->number_of_players_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_other_button_list = _tmp1_;
		_tmp2_ = _other_button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_other_button_size = _tmp4_;
		_other_button_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkToggleButton* _tmp11_;
			_tmp5_ = _other_button_index;
			_other_button_index = _tmp5_ + 1;
			_tmp6_ = _other_button_index;
			_tmp7_ = _other_button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _other_button_list;
			_tmp9_ = _other_button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			other_button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = other_button;
			if (button != _tmp11_) {
				GtkToggleButton* _tmp12_;
				_tmp12_ = other_button;
				if (gtk_toggle_button_get_active (_tmp12_)) {
					GtkToggleButton* _tmp13_;
					GtkToggleButton* _tmp14_;
					GtkToggleButton* _tmp15_;
					_tmp13_ = other_button;
					g_signal_handlers_block_matched (_tmp13_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_tmp14_ = other_button;
					gtk_toggle_button_set_active (_tmp14_, FALSE);
					_tmp15_ = other_button;
					g_signal_handlers_unblock_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_g_object_unref0 (other_button);
					break;
				}
			}
			_g_object_unref0 (other_button);
		}
		_g_object_unref0 (_other_button_list);
	}
	gtk_toggle_button_set_active (button, TRUE);
	numhumans = -1;
	_tmp16_ = gtk_button_get_label ((GtkButton*) button);
	sscanf (_tmp16_, "_%d", &numhumans);
	_tmp17_ = numhumans;
	min_ai = 4 - _tmp17_;
	_tmp18_ = numhumans;
	max_ai = NIBBLES_GAME_MAX_WORMS - _tmp18_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint _tmp21_;
				gint _tmp22_;
				GeeLinkedList* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_;
				GtkToggleButton* _tmp26_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = i;
				_tmp22_ = min_ai;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = self->priv->number_of_ai_buttons;
				_tmp24_ = i;
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
				_tmp26_ = (GtkToggleButton*) _tmp25_;
				gtk_widget_hide ((GtkWidget*) _tmp26_);
				_g_object_unref0 (_tmp26_);
			}
		}
	}
	{
		gint i = 0;
		gint _tmp27_;
		_tmp27_ = min_ai;
		i = _tmp27_;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				GeeLinkedList* _tmp32_;
				gint _tmp33_;
				gpointer _tmp34_;
				GtkToggleButton* _tmp35_;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp30_ = i;
				_tmp31_ = max_ai;
				if (!(_tmp30_ <= _tmp31_)) {
					break;
				}
				_tmp32_ = self->priv->number_of_ai_buttons;
				_tmp33_ = i;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
				_tmp35_ = (GtkToggleButton*) _tmp34_;
				gtk_widget_show ((GtkWidget*) _tmp35_);
				_g_object_unref0 (_tmp35_);
			}
		}
	}
	{
		gint i = 0;
		gint _tmp36_;
		_tmp36_ = max_ai;
		i = _tmp36_ + 1;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				gint _tmp39_;
				GeeLinkedList* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				GeeLinkedList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				GtkToggleButton* _tmp46_;
				if (!_tmp37_) {
					gint _tmp38_;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp39_ = i;
				_tmp40_ = self->priv->number_of_ai_buttons;
				_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
				_tmp42_ = _tmp41_;
				if (!(_tmp39_ < _tmp42_)) {
					break;
				}
				_tmp43_ = self->priv->number_of_ai_buttons;
				_tmp44_ = i;
				_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _tmp44_);
				_tmp46_ = (GtkToggleButton*) _tmp45_;
				gtk_widget_hide ((GtkWidget*) _tmp46_);
				_g_object_unref0 (_tmp46_);
			}
		}
	}
	_tmp47_ = numhumans;
	if (_tmp47_ == 4) {
		GeeLinkedList* _tmp48_;
		gpointer _tmp49_;
		GtkToggleButton* _tmp50_;
		_tmp48_ = self->priv->number_of_ai_buttons;
		_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp48_, 0);
		_tmp50_ = (GtkToggleButton*) _tmp49_;
		gtk_widget_show ((GtkWidget*) _tmp50_);
		_g_object_unref0 (_tmp50_);
	}
	_tmp51_ = self->priv->number_of_ai_buttons;
	_tmp52_ = min_ai;
	_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _tmp52_);
	_tmp54_ = (GtkToggleButton*) _tmp53_;
	gtk_toggle_button_set_active (_tmp54_, TRUE);
	_g_object_unref0 (_tmp54_);
}


static void
nibbles_change_number_of_ai_cb (Nibbles* self,
                                GtkToggleButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_button_index = 0;
		_tmp0_ = self->priv->number_of_ai_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_other_button_list = _tmp1_;
		_tmp2_ = _other_button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_other_button_size = _tmp4_;
		_other_button_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkToggleButton* _tmp11_;
			_tmp5_ = _other_button_index;
			_other_button_index = _tmp5_ + 1;
			_tmp6_ = _other_button_index;
			_tmp7_ = _other_button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _other_button_list;
			_tmp9_ = _other_button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			other_button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = other_button;
			if (button != _tmp11_) {
				GtkToggleButton* _tmp12_;
				_tmp12_ = other_button;
				if (gtk_toggle_button_get_active (_tmp12_)) {
					GtkToggleButton* _tmp13_;
					GtkToggleButton* _tmp14_;
					GtkToggleButton* _tmp15_;
					_tmp13_ = other_button;
					g_signal_handlers_block_matched (_tmp13_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_tmp14_ = other_button;
					gtk_toggle_button_set_active (_tmp14_, FALSE);
					_tmp15_ = other_button;
					g_signal_handlers_unblock_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_g_object_unref0 (other_button);
					break;
				}
			}
			_g_object_unref0 (other_button);
		}
		_g_object_unref0 (_other_button_list);
	}
	gtk_toggle_button_set_active (button, TRUE);
}


static GamesScoresCategory*
nibbles_category_request (Nibbles* self,
                          const gchar* key)
{
	GamesScoresCategory* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _cat_index = 0;
		_tmp0_ = self->priv->scorecats;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_cat_list = _tmp1_;
		_tmp2_ = _cat_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_cat_size = _tmp4_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GamesScoresCategory* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp5_ = _cat_index;
			_cat_index = _tmp5_ + 1;
			_tmp6_ = _cat_index;
			_tmp7_ = _cat_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _cat_list;
			_tmp9_ = _cat_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			cat = (GamesScoresCategory*) _tmp10_;
			_tmp11_ = cat;
			_tmp12_ = games_scores_category_get_key (_tmp11_);
			_tmp13_ = _tmp12_;
			if (g_strcmp0 (key, _tmp13_) == 0) {
				result = cat;
				_g_object_unref0 (_cat_list);
				return result;
			}
			_g_object_unref0 (cat);
		}
		_g_object_unref0 (_cat_list);
	}
	result = NULL;
	return result;
}


static gchar*
nibbles_get_new_scores_key (Nibbles* self,
                            const gchar* old_key)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old_key != NULL, NULL);
	_tmp0_ = old_key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("1.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("fast");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("2.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("medium");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("3.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("slow");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("4.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("beginner");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("1.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("fast-fakes");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("2.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("medium-fakes");
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("3.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("slow-fakes");
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("4.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("beginner-fakes");
				result = _tmp10_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


static GamesScoresCategory*
_nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                      gpointer self)
{
	GamesScoresCategory* result;
	result = nibbles_category_request ((Nibbles*) self, category_key);
	return result;
}


static gchar*
_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                                   gpointer self)
{
	gchar* result;
	result = nibbles_get_new_scores_key ((Nibbles*) self, old_key);
	return result;
}


static void
nibbles_create_scores (Nibbles* self)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GeeLinkedList* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresCategory* _tmp6_;
	GeeLinkedList* _tmp7_;
	GamesScoresCategory* _tmp8_;
	GamesScoresCategory* _tmp9_;
	GeeLinkedList* _tmp10_;
	GamesScoresCategory* _tmp11_;
	GamesScoresCategory* _tmp12_;
	GeeLinkedList* _tmp13_;
	GamesScoresCategory* _tmp14_;
	GamesScoresCategory* _tmp15_;
	GeeLinkedList* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GamesScoresCategory* _tmp18_;
	GeeLinkedList* _tmp19_;
	GamesScoresCategory* _tmp20_;
	GamesScoresCategory* _tmp21_;
	GeeLinkedList* _tmp22_;
	GamesScoresCategory* _tmp23_;
	GamesScoresCategory* _tmp24_;
	GtkApplicationWindow* _tmp25_;
	GamesScoresDirectoryImporter* _tmp26_;
	GamesScoresDirectoryImporter* _tmp27_;
	GamesScoresContext* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->scorecats);
	self->priv->scorecats = _tmp0_;
	_tmp1_ = self->priv->scorecats;
	_tmp2_ = games_scores_category_new ("beginner", _ ("Beginner"));
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->scorecats;
	_tmp5_ = games_scores_category_new ("slow", _ ("Slow"));
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->scorecats;
	_tmp8_ = games_scores_category_new ("medium", _ ("Medium"));
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->scorecats;
	_tmp11_ = games_scores_category_new ("fast", _ ("Fast"));
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->scorecats;
	_tmp14_ = games_scores_category_new ("beginner-fakes", _ ("Beginner with Fakes"));
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->scorecats;
	_tmp17_ = games_scores_category_new ("slow-fakes", _ ("Slow with Fakes"));
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->scorecats;
	_tmp20_ = games_scores_category_new ("medium-fakes", _ ("Medium with Fakes"));
	_tmp21_ = _tmp20_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->scorecats;
	_tmp23_ = games_scores_category_new ("fast-fakes", _ ("Fast with Fakes"));
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->window;
	_tmp26_ = games_scores_directory_importer_new_with_convert_func (_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func, self);
	_tmp27_ = _tmp26_;
	_tmp28_ = games_scores_context_new_with_importer ("gnome-nibbles", _ ("Difficulty Level:"), (GtkWindow*) _tmp25_, _nibbles_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp27_);
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp28_;
	_g_object_unref0 (_tmp27_);
}


static GamesScoresCategory*
nibbles_get_scores_category (Nibbles* self,
                             gint speed,
                             gboolean fakes)
{
	GamesScoresCategory* result = NULL;
	gchar* key = NULL;
	GeeLinkedList* _tmp21_;
	gpointer _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	key = NULL;
	switch (speed) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fast");
			_g_free0 (key);
			key = _tmp0_;
			break;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("medium");
			_g_free0 (key);
			key = _tmp1_;
			break;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("slow");
			_g_free0 (key);
			key = _tmp2_;
			break;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("beginner");
			_g_free0 (key);
			key = _tmp3_;
			break;
		}
		default:
		break;
	}
	if (fakes) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = key;
		_tmp5_ = g_strconcat (_tmp4_, "-fakes", NULL);
		_g_free0 (key);
		key = _tmp5_;
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp6_;
		GeeLinkedList* _tmp7_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _cat_index = 0;
		_tmp6_ = self->priv->scorecats;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_cat_list = _tmp7_;
		_tmp8_ = _cat_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_cat_size = _tmp10_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			const gchar* _tmp17_;
			GamesScoresCategory* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp11_ = _cat_index;
			_cat_index = _tmp11_ + 1;
			_tmp12_ = _cat_index;
			_tmp13_ = _cat_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _cat_list;
			_tmp15_ = _cat_index;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
			cat = (GamesScoresCategory*) _tmp16_;
			_tmp17_ = key;
			_tmp18_ = cat;
			_tmp19_ = games_scores_category_get_key (_tmp18_);
			_tmp20_ = _tmp19_;
			if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
				result = cat;
				_g_object_unref0 (_cat_list);
				_g_free0 (key);
				return result;
			}
			_g_object_unref0 (cat);
		}
		_g_object_unref0 (_cat_list);
	}
	_tmp21_ = self->priv->scorecats;
	_tmp22_ = gee_linked_list_first (_tmp21_);
	result = (GamesScoresCategory*) _tmp22_;
	_g_free0 (key);
	return result;
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Nibbles* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void
__lambda10_ (Block2Data* _data2_,
             GObject* object,
             GAsyncResult* _result_)
{
	Nibbles* self;
	glong _tmp3_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gnome-nibbles.vala:851: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = _data2_->lowest_high_score;
	nibbles_game_over (self, _data2_->score, _tmp3_, _data2_->level_reached);
}


static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ (self, source_object, res);
	block2_data_unref (self);
}


static void
nibbles_log_score_cb (Nibbles* self,
                      gint score,
                      gint level_reached)
{
	Block2Data* _data2_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesGame* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GamesScoresCategory* _tmp9_;
	GamesScoresCategory* _tmp10_;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	glong _tmp13_ = 0L;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	NibblesGame* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	NibblesGame* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GamesScoresContext* _tmp30_;
	NibblesGame* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	NibblesGame* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GamesScoresCategory* _tmp37_;
	GamesScoresCategory* _tmp38_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->score = score;
	_data2_->level_reached = level_reached;
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->scores_context;
	_tmp3_ = self->priv->game;
	_tmp4_ = nibbles_game_get_speed (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->game;
	_tmp7_ = nibbles_game_get_fakes (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = nibbles_get_scores_category (self, _tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = games_scores_context_get_high_scores (_tmp2_, _tmp10_, 10);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	scores = _tmp12_;
	_tmp14_ = scores;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == 10) {
		GeeList* _tmp17_;
		gpointer _tmp18_;
		GamesScoresScore* _tmp19_;
		glong _tmp20_;
		glong _tmp21_;
		_tmp17_ = scores;
		_tmp18_ = gee_list_last (_tmp17_);
		_tmp19_ = (GamesScoresScore*) _tmp18_;
		_tmp20_ = games_scores_score_get_score (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp13_ = _tmp21_;
		_g_object_unref0 (_tmp19_);
	} else {
		_tmp13_ = (glong) -1;
	}
	_data2_->lowest_high_score = _tmp13_;
	_tmp22_ = self->priv->game;
	_tmp23_ = nibbles_game_get_numhumans (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ != 1) {
		glong _tmp25_;
		_tmp25_ = _data2_->lowest_high_score;
		nibbles_game_over (self, _data2_->score, _tmp25_, _data2_->level_reached);
		_g_object_unref0 (scores);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp26_ = self->priv->game;
	_tmp27_ = nibbles_game_get_start_level (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != 1) {
		glong _tmp29_;
		_tmp29_ = _data2_->lowest_high_score;
		nibbles_game_over (self, _data2_->score, _tmp29_, _data2_->level_reached);
		_g_object_unref0 (scores);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp30_ = self->priv->scores_context;
	_tmp31_ = self->priv->game;
	_tmp32_ = nibbles_game_get_speed (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->priv->game;
	_tmp35_ = nibbles_game_get_fakes (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = nibbles_get_scores_category (self, _tmp33_, _tmp36_);
	_tmp38_ = _tmp37_;
	games_scores_context_add_score (_tmp30_, (glong) _data2_->score, _tmp38_, NULL, ___lambda10__gasync_ready_callback, block2_data_ref (_data2_));
	_g_object_unref0 (_tmp38_);
	_g_object_unref0 (scores);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void
nibbles_scores_cb (Nibbles* self)
{
	gboolean should_unpause = FALSE;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GamesScoresContext* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		should_unpause = TRUE;
	}
	_tmp4_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp4_);
	_tmp5_ = should_unpause;
	if (_tmp5_) {
		GSimpleAction* _tmp6_;
		_tmp6_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp6_, "activate", NULL);
	}
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Nibbles* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->button);
		_g_object_unref0 (_data3_->label);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void
__lambda11_ (Block3Data* _data3_)
{
	Nibbles* self;
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	GtkHeaderBar* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	NibblesView* _tmp8_;
	self = _data3_->self;
	_tmp0_ = _data3_->label;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = _data3_->button;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->headerbar;
	_tmp3_ = self->priv->game;
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_ ("Level %d"), _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_header_bar_set_title (_tmp2_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp8_);
	nibbles_restart_game (self);
}


static void
___lambda11__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda11_ (self);
}


static gboolean
__lambda12_ (Block3Data* _data3_)
{
	Nibbles* self;
	gboolean result = FALSE;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	self = _data3_->self;
	_tmp0_ = _data3_->button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = _data3_->button;
	gtk_widget_grab_default ((GtkWidget*) _tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ (self);
	return result;
}


static void
nibbles_level_completed_cb (Nibbles* self)
{
	Block3Data* _data3_;
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NibblesView* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	NibblesGame* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkLabel* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkOverlay* _tmp28_;
	GtkLabel* _tmp29_;
	GtkOverlay* _tmp30_;
	GtkButton* _tmp31_;
	GtkOverlay* _tmp32_;
	GtkOverlay* _tmp33_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NIBBLES_GAME_MAX_LEVEL) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp3_ = self->priv->view;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp5_, FALSE);
	_tmp6_ = self->priv->game;
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (_ ("Level %d Completed!"), _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_data3_->label = _tmp12_;
	_tmp13_ = _data3_->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	_tmp14_ = _data3_->label;
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	_tmp15_ = _data3_->label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 150);
	_tmp16_ = _data3_->label;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, "menu-title");
	_tmp18_ = _data3_->label;
	gtk_widget_show ((GtkWidget*) _tmp18_);
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("_Next Level"));
	g_object_ref_sink (_tmp19_);
	_data3_->button = _tmp19_;
	_tmp20_ = _data3_->button;
	gtk_button_set_use_underline (_tmp20_, TRUE);
	_tmp21_ = _data3_->button;
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_CENTER);
	_tmp22_ = _data3_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
	_tmp23_ = _data3_->button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp23_, 100);
	_tmp24_ = _data3_->button;
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
	gtk_style_context_add_class (_tmp25_, "suggested-action");
	_tmp26_ = _data3_->button;
	gtk_widget_set_can_default ((GtkWidget*) _tmp26_, TRUE);
	_tmp27_ = _data3_->button;
	g_signal_connect_data (_tmp27_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp28_ = self->priv->overlay;
	_tmp29_ = _data3_->label;
	gtk_overlay_add_overlay (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->overlay;
	_tmp31_ = _data3_->button;
	gtk_overlay_add_overlay (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->overlay;
	gtk_widget_grab_default ((GtkWidget*) _tmp33_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda12__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Nibbles* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void
__lambda8_ (Block4Data* _data4_)
{
	Nibbles* self;
	gboolean _tmp0_;
	self = _data4_->self;
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = NULL;
	_tmp0_ = _data4_->should_unpause;
	if (_tmp0_) {
		GSimpleAction* _tmp1_;
		_tmp1_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp1_, "activate", NULL);
	}
}


static void
___lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                gpointer self)
{
	__lambda8_ (self);
}


static void
nibbles_preferences_cb (Nibbles* self)
{
	Block4Data* _data4_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PreferencesDialog* _tmp4_;
	GtkApplicationWindow* _tmp8_;
	GSettings* _tmp9_;
	GeeArrayList* _tmp10_;
	PreferencesDialog* _tmp11_;
	PreferencesDialog* _tmp12_;
	PreferencesDialog* _tmp13_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		_data4_->should_unpause = TRUE;
	}
	_tmp4_ = self->priv->preferences_dialog;
	if (_tmp4_ != NULL) {
		PreferencesDialog* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp5_);
		_tmp6_ = _data4_->should_unpause;
		if (_tmp6_) {
			GSimpleAction* _tmp7_;
			_tmp7_ = self->priv->pause_action;
			g_signal_emit_by_name (_tmp7_, "activate", NULL);
		}
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp8_ = self->priv->window;
	_tmp9_ = self->priv->settings;
	_tmp10_ = self->priv->worm_settings;
	_tmp11_ = preferences_dialog_new (_tmp8_, _tmp9_, _tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp11_;
	_tmp12_ = self->priv->preferences_dialog;
	g_signal_connect_data ((GtkWidget*) _tmp12_, "destroy", (GCallback) ___lambda8__gtk_widget_destroy, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp13_ = self->priv->preferences_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp13_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Nibbles* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->button);
		_g_object_unref0 (_data5_->points_left_label);
		_g_object_unref0 (_data5_->score_label);
		_g_object_unref0 (_data5_->msg_label);
		_g_object_unref0 (_data5_->game_over_label);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void
__lambda9_ (Block5Data* _data5_)
{
	Nibbles* self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkButton* _tmp3_;
	GtkLabel* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	self = _data5_->self;
	_tmp0_ = _data5_->game_over_label;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = _data5_->score_label;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
	_tmp2_ = _data5_->points_left_label;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
	_tmp3_ = _data5_->button;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
	_tmp4_ = _data5_->msg_label;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp5_, TRUE);
	_tmp6_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp6_, TRUE);
	nibbles_show_new_game_screen_cb (self);
}


static void
___lambda9__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda9_ (self);
}


static void
nibbles_game_over (Nibbles* self,
                   gint score,
                   glong lowest_high_score,
                   gint level_reached)
{
	Block5Data* _data5_;
	gboolean is_high_score = FALSE;
	gboolean is_game_won = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	gint _tmp13_;
	GtkLabel* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkLabel* _tmp16_;
	gchar* score_string = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	gint _tmp30_;
	GtkLabel* _tmp31_;
	glong points_left = 0L;
	glong _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	gint _tmp40_;
	GtkLabel* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkStyleContext* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* _tmp50_;
	GtkOverlay* _tmp51_;
	GtkLabel* _tmp52_;
	gboolean _tmp53_;
	NibblesGame* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gboolean _tmp61_ = FALSE;
	NibblesGame* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	GtkOverlay* _tmp68_;
	GtkButton* _tmp69_;
	GtkButton* _tmp70_;
	GtkOverlay* _tmp71_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	is_high_score = ((glong) score) > lowest_high_score;
	is_game_won = level_reached == (NIBBLES_GAME_MAX_LEVEL + 1);
	_tmp1_ = is_game_won;
	if (_tmp1_) {
		_tmp0_ = _ ("Congratulations!");
	} else {
		_tmp0_ = _ ("Game Over!");
	}
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp2_);
	_data5_->game_over_label = _tmp2_;
	_tmp3_ = _data5_->game_over_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = _data5_->game_over_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = _data5_->game_over_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp5_, 150);
	_tmp6_ = _data5_->game_over_label;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, "menu-title");
	_tmp8_ = _data5_->game_over_label;
	gtk_widget_show ((GtkWidget*) _tmp8_);
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("You have completed the game."));
	g_object_ref_sink (_tmp9_);
	_data5_->msg_label = _tmp9_;
	_tmp10_ = _data5_->msg_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
	_tmp11_ = _data5_->msg_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	_tmp12_ = _data5_->msg_label;
	_tmp13_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, _tmp13_ / 3);
	_tmp14_ = _data5_->msg_label;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, "menu-title");
	_tmp16_ = _data5_->msg_label;
	gtk_widget_show ((GtkWidget*) _tmp16_);
	_tmp17_ = g_strdup (ngettext ("%d Point", "%d Points", (gulong) score));
	score_string = _tmp17_;
	_tmp18_ = score_string;
	_tmp19_ = g_strdup_printf (_tmp18_, score);
	_g_free0 (score_string);
	score_string = _tmp19_;
	_tmp20_ = score_string;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("<b>", _tmp21_, "</b>", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_data5_->score_label = _tmp25_;
	_tmp26_ = _data5_->score_label;
	gtk_label_set_use_markup (_tmp26_, TRUE);
	_tmp27_ = _data5_->score_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
	_tmp28_ = _data5_->score_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
	_tmp29_ = _data5_->score_label;
	_tmp30_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp29_, (_tmp30_ / 3) + 80);
	_tmp31_ = _data5_->score_label;
	gtk_widget_show ((GtkWidget*) _tmp31_);
	points_left = lowest_high_score - score;
	_tmp32_ = points_left;
	_tmp33_ = g_strdup_printf (_ ("(%ld more points to reach the leaderboard)"), _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = (GtkLabel*) gtk_label_new (_tmp34_);
	g_object_ref_sink (_tmp35_);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	_data5_->points_left_label = _tmp36_;
	_tmp37_ = _data5_->points_left_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp37_, GTK_ALIGN_CENTER);
	_tmp38_ = _data5_->points_left_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp38_, GTK_ALIGN_START);
	_tmp39_ = _data5_->points_left_label;
	_tmp40_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp39_, (_tmp40_ / 3) + 100);
	_tmp41_ = _data5_->points_left_label;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	_tmp42_ = (GtkButton*) gtk_button_new_with_label (_ ("_Play Again"));
	g_object_ref_sink (_tmp42_);
	_data5_->button = _tmp42_;
	_tmp43_ = _data5_->button;
	gtk_button_set_use_underline (_tmp43_, TRUE);
	_tmp44_ = _data5_->button;
	gtk_widget_set_halign ((GtkWidget*) _tmp44_, GTK_ALIGN_CENTER);
	_tmp45_ = _data5_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp45_, GTK_ALIGN_END);
	_tmp46_ = _data5_->button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp46_, 100);
	_tmp47_ = _data5_->button;
	_tmp48_ = gtk_widget_get_style_context ((GtkWidget*) _tmp47_);
	gtk_style_context_add_class (_tmp48_, "suggested-action");
	_tmp49_ = _data5_->button;
	g_signal_connect_data (_tmp49_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp50_ = _data5_->button;
	gtk_widget_show ((GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->overlay;
	_tmp52_ = _data5_->game_over_label;
	gtk_overlay_add_overlay (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = is_game_won;
	if (_tmp53_) {
		GtkOverlay* _tmp54_;
		GtkLabel* _tmp55_;
		_tmp54_ = self->priv->overlay;
		_tmp55_ = _data5_->msg_label;
		gtk_overlay_add_overlay (_tmp54_, (GtkWidget*) _tmp55_);
	}
	_tmp56_ = self->priv->game;
	_tmp57_ = nibbles_game_get_numhumans (_tmp56_);
	_tmp58_ = _tmp57_;
	if (_tmp58_ == 1) {
		GtkOverlay* _tmp59_;
		GtkLabel* _tmp60_;
		_tmp59_ = self->priv->overlay;
		_tmp60_ = _data5_->score_label;
		gtk_overlay_add_overlay (_tmp59_, (GtkWidget*) _tmp60_);
	}
	_tmp62_ = self->priv->game;
	_tmp63_ = nibbles_game_get_numhumans (_tmp62_);
	_tmp64_ = _tmp63_;
	if (_tmp64_ == 1) {
		gboolean _tmp65_;
		_tmp65_ = is_high_score;
		_tmp61_ = !_tmp65_;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		GtkOverlay* _tmp66_;
		GtkLabel* _tmp67_;
		_tmp66_ = self->priv->overlay;
		_tmp67_ = _data5_->points_left_label;
		gtk_overlay_add_overlay (_tmp66_, (GtkWidget*) _tmp67_);
	}
	_tmp68_ = self->priv->overlay;
	_tmp69_ = _data5_->button;
	gtk_overlay_add_overlay (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = _data5_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp70_);
	_tmp71_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp71_);
	_g_free0 (score_string);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void
nibbles_help_cb (Nibbles* self)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		gtk_show_uri (_tmp1_, "help:gnome-nibbles", gtk_get_current_event_time (), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("gnome-nibbles.vala:1032: Unable to open help: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
nibbles_about_cb (Nibbles* self)
{
	static const gchar* authors[6] = {"Sean MacIsaac", "Ian Peters", "Andreas Røsdal", "Guillaume Beland", "Iulian-Gabriel Radu", NULL};
	static const gchar* documenters[2] = {"Kevin Breit", NULL};
	static const gchar* artists[2] = {"Allan Day", NULL};
	GtkApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _ ("Nibbles"), "logo-icon-name", "gnome-nibbles", "version", VERSION, "comments", _ ("A worm game for GNOME"), "copyright", "Copyright © 1999–2008 Sean MacIsaac, Ian Peters, Andreas Røsdal\n" "Copyright © 2009 Guillaume Beland\n" "Copyright © 2015 Iulian-Gabriel Radu", "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
}


gint
nibbles_main (gchar** args,
              int args_length1)
{
	gint result = 0;
	Nibbles* _tmp0_;
	Nibbles* _tmp1_;
	gint _tmp2_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = nibbles_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


int
main (int argc,
      char ** argv)
{
	return nibbles_main (argv, argc);
}


static void
nibbles_class_init (NibblesClass * klass)
{
	nibbles_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesPrivate));
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) nibbles_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) nibbles_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) nibbles_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) nibbles_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
}


static void
nibbles_instance_init (Nibbles * self)
{
	self->priv = NIBBLES_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->game = NULL;
	self->priv->countdown_id = (guint) 0;
	self->priv->seconds = 0;
}


static void
nibbles_finalize (GObject * obj)
{
	Nibbles * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->worm_settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->number_of_players_buttons);
	_g_object_unref0 (self->priv->number_of_ai_buttons);
	_g_object_unref0 (self->priv->next_button);
	_g_object_unref0 (self->priv->start_button);
	_g_object_unref0 (self->priv->grids_box);
	_g_object_unref0 (self->priv->arrow_pixbuf);
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
	_g_object_unref0 (self->priv->statusbar_stack);
	_g_object_unref0 (self->priv->countdown);
	_g_object_unref0 (self->priv->scoreboard);
	_g_object_unref0 (self->priv->scoreboard_life);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->scorecats);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->back_action);
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
}


GType
nibbles_get_type (void)
{
	static volatile gsize nibbles_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
		GType nibbles_type_id;
		nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_type_id__volatile, nibbles_type_id);
	}
	return nibbles_type_id__volatile;
}


Scoreboard*
scoreboard_construct (GType object_type)
{
	Scoreboard * self = NULL;
	GeeHashMap* _tmp0_;
	self = (Scoreboard*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->boxes);
	self->priv->boxes = _tmp0_;
	return self;
}


Scoreboard*
scoreboard_new (void)
{
	return scoreboard_construct (TYPE_SCOREBOARD);
}


void
scoreboard_register (Scoreboard* self,
                     Worm* worm,
                     const gchar* color_name,
                     GdkPixbuf* life_pixbuf)
{
	PangoColor color = {0};
	PlayerScoreBox* box = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PangoColor _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	PlayerScoreBox* _tmp9_;
	PlayerScoreBox* _tmp10_;
	GeeHashMap* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	g_return_if_fail (color_name != NULL);
	g_return_if_fail (life_pixbuf != NULL);
	memset (&color, 0, sizeof (PangoColor));
	pango_color_parse (&color, color_name);
	_tmp0_ = worm_get_id (worm);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Player %d"), _tmp1_ + 1);
	_tmp3_ = _tmp2_;
	_tmp4_ = color;
	_tmp5_ = worm_get_score (worm);
	_tmp6_ = _tmp5_;
	_tmp7_ = worm_get_lives (worm);
	_tmp8_ = _tmp7_;
	_tmp9_ = player_score_box_new (_tmp3_, &_tmp4_, _tmp6_, _tmp8_, life_pixbuf);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp3_);
	box = _tmp10_;
	_tmp11_ = self->priv->boxes;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, box, worm);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (box);
}


void
scoreboard_update (Scoreboard* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			PlayerScoreBox* _tmp11_;
			PlayerScoreBox* _tmp12_;
			Worm* worm = NULL;
			GeeMapEntry* _tmp13_;
			gconstpointer _tmp14_;
			Worm* _tmp15_;
			Worm* _tmp16_;
			PlayerScoreBox* _tmp17_;
			Worm* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			Worm* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp6_ = _entry_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _entry_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			entry = (GeeMapEntry*) _tmp8_;
			_tmp9_ = entry;
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
			box = _tmp12_;
			_tmp13_ = entry;
			_tmp14_ = gee_map_entry_get_value (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _g_object_ref0 ((Worm*) _tmp15_);
			worm = _tmp16_;
			_tmp17_ = box;
			_tmp18_ = worm;
			_tmp19_ = worm_get_score (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = worm;
			_tmp22_ = worm_get_lives (_tmp21_);
			_tmp23_ = _tmp22_;
			player_score_box_update (_tmp17_, _tmp20_, _tmp23_);
			_g_object_unref0 (worm);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


void
scoreboard_clear (Scoreboard* self)
{
	GeeHashMap* _tmp14_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			PlayerScoreBox* _tmp11_;
			PlayerScoreBox* _tmp12_;
			PlayerScoreBox* _tmp13_;
			_tmp6_ = _entry_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _entry_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			entry = (GeeMapEntry*) _tmp8_;
			_tmp9_ = entry;
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
			box = _tmp12_;
			_tmp13_ = box;
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_tmp14_ = self->priv->boxes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp14_);
}


static void
scoreboard_class_init (ScoreboardClass * klass)
{
	gint Scoreboard_private_offset;
	scoreboard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreboardPrivate));
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
	Scoreboard_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/scoreboard.ui");
}


static void
scoreboard_instance_init (Scoreboard * self)
{
	self->priv = SCOREBOARD_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
scoreboard_finalize (GObject * obj)
{
	Scoreboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
	_g_object_unref0 (self->priv->boxes);
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
}


GType
scoreboard_get_type (void)
{
	static volatile gsize scoreboard_type_id__volatile = 0;
	if (g_once_init_enter (&scoreboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
		GType scoreboard_type_id;
		scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
		g_once_init_leave (&scoreboard_type_id__volatile, scoreboard_type_id);
	}
	return scoreboard_type_id__volatile;
}


PlayerScoreBox*
player_score_box_construct (GType object_type,
                            const gchar* name,
                            PangoColor* color,
                            gint score,
                            gint lives_left,
                            GdkPixbuf* life_pixbuf)
{
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GeeLinkedList* _tmp14_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (life_pixbuf != NULL, NULL);
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = pango_color_to_string (color);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, name, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "</span>", NULL);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp0_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp11_ = self->priv->score_label;
	_tmp12_ = g_strdup_printf ("%i", score);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp11_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->life_images);
	self->priv->life_images = _tmp14_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				GtkImage* life = NULL;
				GtkImage* _tmp18_;
				GtkImage* _tmp19_;
				gint _tmp20_;
				GeeLinkedList* _tmp22_;
				GtkImage* _tmp23_;
				GtkGrid* _tmp24_;
				GtkImage* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ < WORM_MAX_LIVES)) {
					break;
				}
				_tmp18_ = (GtkImage*) gtk_image_new_from_pixbuf (life_pixbuf);
				g_object_ref_sink (_tmp18_);
				life = _tmp18_;
				_tmp19_ = life;
				gtk_widget_show ((GtkWidget*) _tmp19_);
				_tmp20_ = i;
				if (_tmp20_ >= WORM_STARTING_LIVES) {
					GtkImage* _tmp21_;
					_tmp21_ = life;
					gtk_widget_set_opacity ((GtkWidget*) _tmp21_, (gdouble) 0);
				}
				_tmp22_ = self->priv->life_images;
				_tmp23_ = life;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				_tmp24_ = self->priv->lives_grid;
				_tmp25_ = life;
				_tmp26_ = i;
				_tmp27_ = i;
				gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, _tmp26_ % 6, _tmp27_ / 6, 1, 1);
				_g_object_unref0 (life);
			}
		}
	}
	return self;
}


PlayerScoreBox*
player_score_box_new (const gchar* name,
                      PangoColor* color,
                      gint score,
                      gint lives_left,
                      GdkPixbuf* life_pixbuf)
{
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, life_pixbuf);
}


void
player_score_box_update (PlayerScoreBox* self,
                         gint score,
                         gint lives_left)
{
	g_return_if_fail (self != NULL);
	player_score_box_update_score (self, score);
	player_score_box_update_lives (self, lives_left);
}


void
player_score_box_update_score (PlayerScoreBox* self,
                               gint score)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_label;
	_tmp1_ = g_strdup_printf ("%i", score);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}


void
player_score_box_update_lives (PlayerScoreBox* self,
                               gint lives_left)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		GeeLinkedList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->life_images;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				GeeLinkedList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				GtkImage* _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ >= lives_left)) {
					break;
				}
				_tmp6_ = self->priv->life_images;
				_tmp7_ = i;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
				_tmp9_ = (GtkImage*) _tmp8_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp9_, (gdouble) 0);
				_g_object_unref0 (_tmp9_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				GeeLinkedList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				GtkImage* _tmp16_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				if (!(_tmp12_ < lives_left)) {
					break;
				}
				_tmp13_ = self->priv->life_images;
				_tmp14_ = i;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
				_tmp16_ = (GtkImage*) _tmp15_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp16_, (gdouble) 1);
				_g_object_unref0 (_tmp16_);
			}
		}
	}
}


static void
player_score_box_class_init (PlayerScoreBoxClass * klass)
{
	gint PlayerScoreBox_private_offset;
	player_score_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PlayerScoreBoxPrivate));
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
	PlayerScoreBox_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/player-score-box.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
}


static void
player_score_box_instance_init (PlayerScoreBox * self)
{
	self->priv = PLAYER_SCORE_BOX_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
player_score_box_finalize (GObject * obj)
{
	PlayerScoreBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->score_label);
	_g_object_unref0 (self->priv->lives_grid);
	_g_object_unref0 (self->priv->life_images);
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
}


GType
player_score_box_get_type (void)
{
	static volatile gsize player_score_box_type_id__volatile = 0;
	if (g_once_init_enter (&player_score_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
		GType player_score_box_type_id;
		player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
		g_once_init_leave (&player_score_box_type_id__volatile, player_score_box_type_id);
	}
	return player_score_box_type_id__volatile;
}


ControlsGrid*
controls_grid_construct (GType object_type,
                         gint worm_id,
                         WormProperties* worm_props,
                         GdkPixbuf* arrow,
                         GdkPixbuf* arrow_key)
{
	ControlsGrid * self = NULL;
	PangoColor color = {0};
	WormProperties _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* player_id = NULL;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkImage* _tmp13_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* _tmp15_;
	GtkImage* _tmp16_;
	GdkPixbuf* _tmp17_;
	GdkPixbuf* _tmp18_;
	GtkImage* _tmp19_;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp21_;
	GtkImage* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	gchar* upper_key = NULL;
	WormProperties _tmp25_;
	guint _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	WormProperties _tmp41_;
	guint _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	WormProperties _tmp57_;
	guint _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	WormProperties _tmp73_;
	guint _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	const gchar* _tmp77_;
	g_return_val_if_fail (worm_props != NULL, NULL);
	g_return_val_if_fail (arrow != NULL, NULL);
	g_return_val_if_fail (arrow_key != NULL, NULL);
	self = (ControlsGrid*) g_object_new (object_type, NULL);
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = *worm_props;
	_tmp1_ = _tmp0_.color;
	_tmp2_ = nibbles_view_colorval_name (_tmp1_);
	_tmp3_ = _tmp2_;
	pango_color_parse (&color, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_strdup_printf (_ ("Player %d"), worm_id + 1);
	player_id = _tmp4_;
	_tmp5_ = self->priv->name_label;
	_tmp6_ = pango_color_to_string (&color);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = player_id;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp8_, "\">", _tmp10_, "</span></b>", NULL);
	_tmp12_ = _tmp11_;
	gtk_label_set_markup (_tmp5_, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp7_);
	_tmp13_ = self->priv->arrow_up;
	_tmp14_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_NONE);
	_tmp15_ = _tmp14_;
	gtk_image_set_from_pixbuf (_tmp13_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->arrow_down;
	_tmp17_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
	_tmp18_ = _tmp17_;
	gtk_image_set_from_pixbuf (_tmp16_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->arrow_left;
	_tmp20_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
	_tmp21_ = _tmp20_;
	gtk_image_set_from_pixbuf (_tmp19_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->arrow_right;
	_tmp23_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_CLOCKWISE);
	_tmp24_ = _tmp23_;
	gtk_image_set_from_pixbuf (_tmp22_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = *worm_props;
	_tmp26_ = _tmp25_.up;
	_tmp27_ = gdk_keyval_name (_tmp26_);
	_tmp28_ = g_utf8_strup (_tmp27_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp28_;
	_tmp29_ = upper_key;
	if (g_strcmp0 (_tmp29_, "UP") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp30_;
		GtkOverlay* _tmp31_;
		GdkPixbuf* _tmp32_;
		GtkImage* _tmp33_;
		GtkImage* _tmp34_;
		GtkOverlay* _tmp35_;
		_tmp30_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_NONE);
		rotated_pixbuf = _tmp30_;
		_tmp31_ = self->priv->move_up;
		_tmp32_ = rotated_pixbuf;
		_tmp33_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp32_);
		g_object_ref_sink (_tmp33_);
		_tmp34_ = _tmp33_;
		gtk_overlay_add_overlay (_tmp31_, (GtkWidget*) _tmp34_);
		_g_object_unref0 (_tmp34_);
		_tmp35_ = self->priv->move_up;
		gtk_widget_show_all ((GtkWidget*) _tmp35_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp36_ = self->priv->move_up_label;
		_tmp37_ = upper_key;
		_tmp38_ = string_to_string (_tmp37_);
		_tmp39_ = g_strconcat ("<b>", _tmp38_, "</b>", NULL);
		_tmp40_ = _tmp39_;
		gtk_label_set_markup (_tmp36_, _tmp40_);
		_g_free0 (_tmp40_);
	}
	_tmp41_ = *worm_props;
	_tmp42_ = _tmp41_.down;
	_tmp43_ = gdk_keyval_name (_tmp42_);
	_tmp44_ = g_utf8_strup (_tmp43_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp44_;
	_tmp45_ = upper_key;
	if (g_strcmp0 (_tmp45_, "DOWN") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp46_;
		GtkOverlay* _tmp47_;
		GdkPixbuf* _tmp48_;
		GtkImage* _tmp49_;
		GtkImage* _tmp50_;
		GtkOverlay* _tmp51_;
		_tmp46_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
		rotated_pixbuf = _tmp46_;
		_tmp47_ = self->priv->move_down;
		_tmp48_ = rotated_pixbuf;
		_tmp49_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp48_);
		g_object_ref_sink (_tmp49_);
		_tmp50_ = _tmp49_;
		gtk_overlay_add_overlay (_tmp47_, (GtkWidget*) _tmp50_);
		_g_object_unref0 (_tmp50_);
		_tmp51_ = self->priv->move_down;
		gtk_widget_show_all ((GtkWidget*) _tmp51_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp52_ = self->priv->move_down_label;
		_tmp53_ = upper_key;
		_tmp54_ = string_to_string (_tmp53_);
		_tmp55_ = g_strconcat ("<b>", _tmp54_, "</b>", NULL);
		_tmp56_ = _tmp55_;
		gtk_label_set_markup (_tmp52_, _tmp56_);
		_g_free0 (_tmp56_);
	}
	_tmp57_ = *worm_props;
	_tmp58_ = _tmp57_.left;
	_tmp59_ = gdk_keyval_name (_tmp58_);
	_tmp60_ = g_utf8_strup (_tmp59_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp60_;
	_tmp61_ = upper_key;
	if (g_strcmp0 (_tmp61_, "LEFT") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp62_;
		GtkOverlay* _tmp63_;
		GdkPixbuf* _tmp64_;
		GtkImage* _tmp65_;
		GtkImage* _tmp66_;
		GtkOverlay* _tmp67_;
		_tmp62_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
		rotated_pixbuf = _tmp62_;
		_tmp63_ = self->priv->move_left;
		_tmp64_ = rotated_pixbuf;
		_tmp65_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp64_);
		g_object_ref_sink (_tmp65_);
		_tmp66_ = _tmp65_;
		gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp66_);
		_g_object_unref0 (_tmp66_);
		_tmp67_ = self->priv->move_left;
		gtk_widget_show_all ((GtkWidget*) _tmp67_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp68_ = self->priv->move_left_label;
		_tmp69_ = upper_key;
		_tmp70_ = string_to_string (_tmp69_);
		_tmp71_ = g_strconcat ("<b>", _tmp70_, "</b>", NULL);
		_tmp72_ = _tmp71_;
		gtk_label_set_markup (_tmp68_, _tmp72_);
		_g_free0 (_tmp72_);
	}
	_tmp73_ = *worm_props;
	_tmp74_ = _tmp73_.right;
	_tmp75_ = gdk_keyval_name (_tmp74_);
	_tmp76_ = g_utf8_strup (_tmp75_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp76_;
	_tmp77_ = upper_key;
	if (g_strcmp0 (_tmp77_, "RIGHT") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp78_;
		GtkOverlay* _tmp79_;
		GdkPixbuf* _tmp80_;
		GtkImage* _tmp81_;
		GtkImage* _tmp82_;
		GtkOverlay* _tmp83_;
		_tmp78_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_CLOCKWISE);
		rotated_pixbuf = _tmp78_;
		_tmp79_ = self->priv->move_right;
		_tmp80_ = rotated_pixbuf;
		_tmp81_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp80_);
		g_object_ref_sink (_tmp81_);
		_tmp82_ = _tmp81_;
		gtk_overlay_add_overlay (_tmp79_, (GtkWidget*) _tmp82_);
		_g_object_unref0 (_tmp82_);
		_tmp83_ = self->priv->move_right;
		gtk_widget_show_all ((GtkWidget*) _tmp83_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp84_;
		const gchar* _tmp85_;
		const gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		_tmp84_ = self->priv->move_right_label;
		_tmp85_ = upper_key;
		_tmp86_ = string_to_string (_tmp85_);
		_tmp87_ = g_strconcat ("<b>", _tmp86_, "</b>", NULL);
		_tmp88_ = _tmp87_;
		gtk_label_set_markup (_tmp84_, _tmp88_);
		_g_free0 (_tmp88_);
	}
	_g_free0 (upper_key);
	_g_free0 (player_id);
	return self;
}


ControlsGrid*
controls_grid_new (gint worm_id,
                   WormProperties* worm_props,
                   GdkPixbuf* arrow,
                   GdkPixbuf* arrow_key)
{
	return controls_grid_construct (TYPE_CONTROLS_GRID, worm_id, worm_props, arrow, arrow_key);
}


static void
controls_grid_class_init (ControlsGridClass * klass)
{
	gint ControlsGrid_private_offset;
	controls_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ControlsGridPrivate));
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
	ControlsGrid_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/controls-grid.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_label));
}


static void
controls_grid_instance_init (ControlsGrid * self)
{
	self->priv = CONTROLS_GRID_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
controls_grid_finalize (GObject * obj)
{
	ControlsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->arrow_up);
	_g_object_unref0 (self->priv->arrow_down);
	_g_object_unref0 (self->priv->arrow_left);
	_g_object_unref0 (self->priv->arrow_right);
	_g_object_unref0 (self->priv->move_up);
	_g_object_unref0 (self->priv->move_up_label);
	_g_object_unref0 (self->priv->move_down);
	_g_object_unref0 (self->priv->move_down_label);
	_g_object_unref0 (self->priv->move_left);
	_g_object_unref0 (self->priv->move_left_label);
	_g_object_unref0 (self->priv->move_right);
	_g_object_unref0 (self->priv->move_right_label);
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
}


GType
controls_grid_get_type (void)
{
	static volatile gsize controls_grid_type_id__volatile = 0;
	if (g_once_init_enter (&controls_grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
		GType controls_grid_type_id;
		controls_grid_type_id = g_type_register_static (gtk_grid_get_type (), "ControlsGrid", &g_define_type_info, 0);
		g_once_init_leave (&controls_grid_type_id__volatile, controls_grid_type_id);
	}
	return controls_grid_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



