<?php

namespace Moxl\Xec\Action\Pubsub;

use Moxl\Xec\Action;
use Moxl\Stanza\Pubsub;
use Moxl\Xec\Action\Pubsub\Errors;

use Movim\Picture;

class GetItem extends Errors
{
    protected $_to;
    protected $_node;
    protected $_id;
    protected $_askreply;

    protected $_parentid;

    public function request()
    {
        $this->store();
        Pubsub::getItem($this->_to, $this->_node, $this->_id);
    }

    public function handle($stanza, $parent = false)
    {
        if ($stanza->pubsub->items->item) {
            foreach ($stanza->pubsub->items->item as $item) {
                if (isset($item->entry)
                && (string)$item->entry->attributes()->xmlns == 'http://www.w3.org/2005/Atom') {
                    $p = \App\Post::firstOrNew([
                        'server' => $this->_to,
                        'node' => $this->_node,
                        'nodeid' => $this->_id
                    ]);
                    $p->set($item);

                    if (isset($this->_parentid)) {
                        $p->parent_id    = $this->_parentid;
                    }

                    if ($p->isComment() && !isset($p->parent_id)) return;

                    $p->save();

                    if (is_array($this->_askreply)) {
                        $this->pack(\App\Post::find($this->_askreply));
                        $this->deliver();
                    } else {
                        $this->pack($p);
                        $this->event('post', $this->packet);
                    }

                    $this->pack($p);
                    $this->deliver();
                } elseif (isset($item->metadata)
                && (string)$item->metadata->attributes()->xmlns == 'urn:xmpp:avatar:metadata'
                && isset($item->metadata->info->attributes()->url)) {
                    $i = \App\Info::where('server', $this->_to)
                                  ->where('node', $this->_node)
                                  ->first();

                    if ($i && $i->avatarhash !== (string)$item->metadata->info->attributes()->id) {
                        $p = new Picture;
                        $p->fromURL((string)$item->metadata->info->attributes()->url);
                        $p->set((string)$item->metadata->info->attributes()->id);

                        $i->avatarhash = (string)$item->metadata->info->attributes()->id;
                        $i->save();

                        $this->method('avatar');
                        $this->pack([
                            'server' => $this->_to,
                            'node' => $this->_node
                        ]);
                        $this->deliver();
                    }
                }
            }
        } else {
            $pd = new PostDelete;
            $pd->setTo($this->_to)
               ->setNode($this->_node)
               ->setId($this->_id);

            $pd->handle($stanza);
        }
    }

    public function errorItemNotFound($stanza, $parent = false)
    {
        $this->errorServiceUnavailable($stanza, $parent);
    }

    public function errorServiceUnavailable($stanza, $parent = false)
    {
        $pd = new PostDelete;
        $pd->setTo($this->_to)
           ->setNode($this->_node)
           ->setId($this->_id);

        $pd->handle($stanza);
    }
}
