MACRO( DEBUG_INCLUDE_DIRECTORIES _TAG )
    IF($ENV{DEBUG_VERBOSE})
            message(" ")
            message("--------------------------------------------------------")
            message("[DEBUG:INCL_DIR:${_TAG}] INCLUDE_DIRECTORIES:")
            message("--------------------------------------------------------")
            get_property(debug_dirs DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR} PROPERTY INCLUDE_DIRECTORIES)
            foreach(dir ${debug_dirs})
                    message("${dir}")
            endforeach()
    ENDIF($ENV{DEBUG_VERBOSE})
ENDMACRO(DEBUG_INCLUDE_DIRECTORIES)

MACRO( DEBUG_VAR )
    IF($ENV{DEBUG_VERBOSE})
            message(" ")
            FOREACH(var ${ARGN})
                message("[DEBUG:VAR:${var}] ${${var}}")
            ENDFOREACH(var)
    ENDIF($ENV{DEBUG_VERBOSE})
ENDMACRO(DEBUG_VAR)

MACRO( DEBUG_GLOBAL_VAR )
    IF($ENV{DEBUG_VERBOSE})
            message(" ")
            FOREACH(var ${ARGN})
                get_property(temp GLOBAL PROPERTY ${var} )
                message("[DEBUG:GLOBAL_VAR:${var}] ${temp}")
            ENDFOREACH(var)
    ENDIF($ENV{DEBUG_VERBOSE})
ENDMACRO(DEBUG_GLOBAL_VAR)

MACRO( DEBUG_MESSAGE _msg )
    message(" ")
    IF($ENV{DEBUG_VERBOSE})
            message("[DEBUG:MSG] ${_msg}")
    ENDIF($ENV{DEBUG_VERBOSE})
ENDMACRO(DEBUG_MESSAGE)

