# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource_py3 import SubResource


class ApplicationGatewayTrustedRootCertificate(SubResource):
    """Trusted Root certificates of an application gateway.

    :param id: Resource ID.
    :type id: str
    :param data: Certificate public data.
    :type data: str
    :param keyvault_secret_id: KeyVault Secret Id for certificate.
    :type keyvault_secret_id: str
    :param provisioning_state: Provisioning state of the trusted root
     certificate resource. Possible values are: 'Updating', 'Deleting', and
     'Failed'.
    :type provisioning_state: str
    :param name: Name of the trusted root certificate that is unique within an
     Application Gateway.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'keyvault_secret_id': {'key': 'properties.keyvaultSecretId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, data: str=None, keyvault_secret_id: str=None, provisioning_state: str=None, name: str=None, etag: str=None, type: str=None, **kwargs) -> None:
        super(ApplicationGatewayTrustedRootCertificate, self).__init__(id=id, **kwargs)
        self.data = data
        self.keyvault_secret_id = keyvault_secret_id
        self.provisioning_state = provisioning_state
        self.name = name
        self.etag = etag
        self.type = type
