# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnStringInfo(Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: 'MySql',
     'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus',
     'EventHub', 'ApiHub', 'DocDb', 'RedisCache', 'PostgreSQL'
    :type type: str or ~azure.mgmt.web.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ConnectionStringType'},
    }

    def __init__(self, **kwargs):
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.type = kwargs.get('type', None)
