% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceResults.R
\name{reduceResults}
\alias{reduceResults}
\title{Reduce Results}
\usage{
reduceResults(fun, ids = NULL, init, ..., reg = getDefaultRegistry())
}
\arguments{
\item{fun}{[\code{function}]\cr
A function to reduce the results. The result of previous iterations (or
the \code{init}) will be passed as first argument, the result of of the
i-th iteration as second. See \code{\link[base]{Reduce}} for some
examples.
If the function has the formal argument \dQuote{job}, the \code{\link{Job}}/\code{\link{Experiment}}
is also passed to the function (named).}

\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to the return value of \code{\link{findDone}}.
Invalid ids are ignored.}

\item{init}{[\code{ANY}]\cr
Initial element, as used in \code{\link[base]{Reduce}}.
If missing, the reduction uses the result of the first job as \code{init} and the reduction starts
with the second job.}

\item{...}{[\code{ANY}]\cr
Additional arguments passed to function \code{fun}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
Aggregated results in the same order as provided ids.
  Return type depends on the user function. If \code{ids}
  is empty, \code{reduceResults} returns \code{init} (if available) or \code{NULL} otherwise.
}
\description{
A version of \code{\link[base]{Reduce}} for \code{\link{Registry}} objects
which iterates over finished jobs and aggregates them.
All jobs must have terminated, an error is raised otherwise.
}
\note{
If you have thousands of jobs, disabling the progress bar (\code{options(batchtools.progress = FALSE)})
can significantly increase the performance.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(function(a, b) list(sum = a+b, prod = a*b), a = 1:3, b = 1:3, reg = tmp)
submitJobs(reg = tmp)
waitForJobs(reg = tmp)

# Extract element sum from each result
reduceResults(function(aggr, res) c(aggr, res$sum), init = list(), reg = tmp)

# Aggregate element sum via '+'
reduceResults(function(aggr, res) aggr + res$sum, init = 0, reg = tmp)

# Aggregate element prod via '*' where parameter b < 3
reduce = function(aggr, res, job) {
  if (job$pars$b >= 3)
    return(aggr)
  aggr * res$prod
}
reduceResults(reduce, init = 1, reg = tmp)

# Reduce to data.frame() (inefficient, use reduceResultsDataTable() instead)
reduceResults(rbind, init = data.frame(), reg = tmp)

# Reduce to data.frame by collecting results first, then utilize vectorization of rbind:
res = reduceResultsList(fun = as.data.frame, reg = tmp)
do.call(rbind, res)

# Reduce with custom combine function:
comb = function(x, y) list(sum = x$sum + y$sum, prod = x$prod * y$prod)
reduceResults(comb, reg = tmp)

# The same with neutral element NULL
comb = function(x, y) if (is.null(x)) y else list(sum = x$sum + y$sum, prod = x$prod * y$prod)
reduceResults(comb, init = NULL, reg = tmp)

# Alternative: Reduce in list, reduce manually in a 2nd step
res = reduceResultsList(reg = tmp)
Reduce(comb, res)
}
\seealso{
Other Results: \code{\link{batchMapResults}},
  \code{\link{loadResult}}, \code{\link{reduceResultsList}}
}
\concept{Results}
