// file automatically generated by "../../../rheolef/nfem/basis/basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "bubble.h"
using namespace rheolef;
using namespace std;
class basis_bubble_p {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_bubble_e {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_bubble_t {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_bubble_T {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static tensor hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<tensor >& values);
  static void hat_node(
    vector<point>& hat_node);
};
basis_rep::dof_family_type
basis_bubble_p::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_bubble_p::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = 1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_bubble_p::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_bubble_p::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis bubble");
  return val;
}
void
basis_bubble_p::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] = 1.0;
}
void
basis_bubble_p::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
}
void
basis_bubble_p::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis bubble");
}
void
basis_bubble_p::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point();
}
basis_rep::dof_family_type
basis_bubble_e::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_bubble_e::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  4.0*hat_x[0]+-4.0*(hat_x[0]*hat_x[0]);
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_bubble_e::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  -8.0*hat_x[0]+4.0;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_bubble_e::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis bubble");
  return val;
}
void
basis_bubble_e::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] =  -4.0*(hat_x[0]*hat_x[0])+4.0*hat_x[0];
}
void
basis_bubble_e::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
  values[0][0] =  -8.0*hat_x[0]+4.0;
}
void
basis_bubble_e::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis bubble");
}
void
basis_bubble_e::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point(5.0000000000000000e-01);
}
basis_rep::dof_family_type
basis_bubble_t::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_bubble_t::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  -27.0*( (hat_x[0]*hat_x[0])-hat_x[0])*hat_x[1]+-27.0*hat_x[0]*(hat_x[1]*hat_x[1]);
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_bubble_t::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  -27.0*(hat_x[1]*hat_x[1])+-27.0*( 2.0*hat_x[0]-1.0)*hat_x[1];
      val[1] =  -54.0*hat_x[0]*hat_x[1]+27.0*hat_x[0]+-27.0*(hat_x[0]*hat_x[0]);
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_bubble_t::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis bubble");
  return val;
}
void
basis_bubble_t::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] =  -27.0*hat_x[0]*(hat_x[1]*hat_x[1])+27.0*( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1];
}
void
basis_bubble_t::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
  values[0][0] =  -27.0*(hat_x[1]*hat_x[1])+-27.0*hat_x[1]*( 2.0*hat_x[0]-1.0);
  values[0][1] =  -27.0*(hat_x[0]*hat_x[0])+27.0*hat_x[0]+-54.0*hat_x[0]*hat_x[1];
}
void
basis_bubble_t::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis bubble");
}
void
basis_bubble_t::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point((1.0/3.0), (1.0/3.0));
}
basis_rep::dof_family_type
basis_bubble_T::dof_family(
  size_type    i_dof_local)
{
  return element_constant::Lagrange;
}
Float
basis_bubble_T::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  -256.0*hat_x[0]*hat_x[1]*(hat_x[2]*hat_x[2])+-256.0*( hat_x[0]*(hat_x[1]*hat_x[1])-( hat_x[0]-(hat_x[0]*hat_x[0]))*hat_x[1])*hat_x[2];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_bubble_T::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  -256.0*( hat_x[1]*( 2.0*hat_x[0]-1.0)+(hat_x[1]*hat_x[1]))*hat_x[2]+-256.0*hat_x[1]*(hat_x[2]*hat_x[2]);
      val[1] =  256.0*hat_x[2]*( hat_x[0]+-2.0*hat_x[0]*hat_x[1]-(hat_x[0]*hat_x[0]))+-256.0*hat_x[0]*(hat_x[2]*hat_x[2]);
      val[2] =  -512.0*hat_x[0]*hat_x[1]*hat_x[2]+256.0*hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0]))+-256.0*hat_x[0]*(hat_x[1]*hat_x[1]);
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
tensor
basis_bubble_T::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  tensor val(0.);
  error_macro ("hessian_eval: invalid basis bubble");
  return val;
}
void
basis_bubble_T::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] =  -256.0*hat_x[2]*( (hat_x[1]*hat_x[1])*hat_x[0]-hat_x[1]*( hat_x[0]-(hat_x[0]*hat_x[0])))+-256.0*hat_x[1]*(hat_x[2]*hat_x[2])*hat_x[0];
}
void
basis_bubble_T::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
  values[0][0] =  -256.0*hat_x[2]*( ( 2.0*hat_x[0]-1.0)*hat_x[1]+(hat_x[1]*hat_x[1]))+-256.0*(hat_x[2]*hat_x[2])*hat_x[1];
  values[0][1] =  -256.0*( 2.0*hat_x[0]*hat_x[1]-hat_x[0]+(hat_x[0]*hat_x[0]))*hat_x[2]+-256.0*(hat_x[2]*hat_x[2])*hat_x[0];
  values[0][2] =  -256.0*hat_x[1]*( (hat_x[0]*hat_x[0])-hat_x[0])+-256.0*hat_x[0]*(hat_x[1]*hat_x[1])+-512.0*hat_x[2]*hat_x[0]*hat_x[1];
}
void
basis_bubble_T::hessian_eval(
  const point&   hat_x,
  vector<tensor >& values)
{
  tensor ini_val(0.);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis bubble");
}
void
basis_bubble_T::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point(2.5000000000000000e-01, 2.5000000000000000e-01, 2.5000000000000000e-01);
}
basis_bubble::~basis_bubble()
{
}
basis_bubble::size_type
basis_bubble::degree () const
{
    return 4;
}
basis_bubble::size_type
basis_bubble::size (
    reference_element hat_K, basis_rep::dof_family_type family) const
{
    if (family != element_constant::Lagrange && family != element_constant::dof_family_max) return 0;
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 1;
      }
      case reference_element::t: {
        return 1;
      }
      case reference_element::T: {
        return 1;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
basis_rep::dof_family_type
basis_bubble::dof_family(
    reference_element hat_K,
    size_type         i_dof_local) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_bubble_p::dof_family (i_dof_local);
      }
      case reference_element::e: {
      return basis_bubble_e::dof_family (i_dof_local);
      }
      case reference_element::t: {
      return basis_bubble_t::dof_family (i_dof_local);
      }
      case reference_element::T: {
      return basis_bubble_T::dof_family (i_dof_local);
      }
      default : {
        error_macro ("dof_family: unsupported `" << hat_K.name() << "' element type");
        return element_constant::dof_family_max;
      }
    }
}
Float
basis_bubble::eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_bubble_p::eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_bubble_e::eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_bubble_t::eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_bubble_T::eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
point
basis_bubble::grad_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_bubble_p::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_bubble_e::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_bubble_t::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_bubble_T::grad_eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
        return point();
      }
    }
}
tensor
basis_bubble::hessian_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
  error_macro ("hessian_eval: invalid basis bubble");
  tensor ini_val(0.);
  return ini_val;
}
void
basis_bubble::eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<Float>&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_bubble_p::eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_bubble_e::eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_bubble_t::eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_bubble_T::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_bubble::grad_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<point>&    values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_bubble_p::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_bubble_e::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_bubble_t::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_bubble_T::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_bubble::hessian_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<tensor >&    values) const
{
  error_macro ("hessian_eval: invalid basis bubble");
}
void
basis_bubble::hat_node(
    reference_element hat_K,
    vector<point>&    hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_bubble_p::hat_node (hat_node);
      }
      case reference_element::e: {
      return basis_bubble_e::hat_node (hat_node);
      }
      case reference_element::t: {
      return basis_bubble_t::hat_node (hat_node);
      }
      case reference_element::T: {
      return basis_bubble_T::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
basis_rep* make_bubble(void) { return new_macro(basis_bubble); }
