// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

extern crate gtk_sys;
extern crate shell_words;
extern crate tempdir;
use std::env;
use std::error::Error;
use std::path::Path;
use std::mem::{align_of, size_of};
use std::process::Command;
use std::str;
use gtk_sys::*;

static PACKAGES: &[&str] = &["gtk+-3.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Compiler, Box<Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Compiler { args })
    }

    pub fn define<'a, V: Into<Option<&'a str>>>(&mut self, var: &str, val: V) {
        let arg = match val.into() {
            None => format!("-D{}", var),
            Some(val) => format!("-D{}={}", var, val),
        };
        self.args.push(arg);
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}",
                               &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let mut cmd = Command::new("pkg-config");
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}",
                           &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}


#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
    /// Number of tests that failed to compile.
    failed_to_compile: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn record_failed_to_compile(&mut self) {
        self.failed += 1;
        self.failed_to_compile += 1;
    }
    fn summary(&self) -> String {
        format!(
            "{} passed; {} failed (compilation errors: {})",
            self.passed,
            self.failed,
            self.failed_to_compile)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!("1",
               get_c_value(tmpdir.path(), &cc, "1").expect("C constant"),
               "failed to obtain correct constant value for 1");

    let mut results : Results = Default::default();
    for (i, &(name, rust_value)) in RUST_CONSTANTS.iter().enumerate() {
        match get_c_value(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(ref c_value) => {
                if rust_value == c_value {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_value, c_value);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("constants ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let tmpdir = tempdir::TempDir::new("abi").expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(Layout {size: 1, alignment: 1},
               get_c_layout(tmpdir.path(), &cc, "char").expect("C layout"),
               "failed to obtain correct layout for char type");

    let mut results : Results = Default::default();
    for (i, &(name, rust_layout)) in RUST_LAYOUTS.iter().enumerate() {
        match get_c_layout(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            },
            Ok(c_layout) => {
                if rust_layout == c_layout {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!("Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                              name, rust_layout, &c_layout);
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("layout    ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

fn get_c_layout(dir: &Path, cc: &Compiler, name: &str) -> Result<Layout, Box<Error>> {
    let exe = dir.join("layout");
    let mut cc = cc.clone();
    cc.define("ABI_TYPE_NAME", name);
    cc.compile(Path::new("tests/layout.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    let stdout = str::from_utf8(&output.stdout)?;
    let mut words = stdout.trim().split_whitespace();
    let size = words.next().unwrap().parse().unwrap();
    let alignment = words.next().unwrap().parse().unwrap();
    Ok(Layout {size, alignment})
}

fn get_c_value(dir: &Path, cc: &Compiler, name: &str) -> Result<String, Box<Error>> {
    let exe = dir.join("constant");
    let mut cc = cc.clone();
    cc.define("ABI_CONSTANT_NAME", name);
    cc.compile(Path::new("tests/constant.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}",
                           &abi_cmd, &output).into());
    }

    Ok(str::from_utf8(&output.stdout)?.trim().to_owned())
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    ("GtkAboutDialog", Layout {size: size_of::<GtkAboutDialog>(), alignment: align_of::<GtkAboutDialog>()}),
    ("GtkAccelFlags", Layout {size: size_of::<GtkAccelFlags>(), alignment: align_of::<GtkAccelFlags>()}),
    ("GtkAccelGroup", Layout {size: size_of::<GtkAccelGroup>(), alignment: align_of::<GtkAccelGroup>()}),
    ("GtkAccelGroupClass", Layout {size: size_of::<GtkAccelGroupClass>(), alignment: align_of::<GtkAccelGroupClass>()}),
    ("GtkAccelLabel", Layout {size: size_of::<GtkAccelLabel>(), alignment: align_of::<GtkAccelLabel>()}),
    ("GtkAccelLabelClass", Layout {size: size_of::<GtkAccelLabelClass>(), alignment: align_of::<GtkAccelLabelClass>()}),
    ("GtkAccessible", Layout {size: size_of::<GtkAccessible>(), alignment: align_of::<GtkAccessible>()}),
    ("GtkAccessibleClass", Layout {size: size_of::<GtkAccessibleClass>(), alignment: align_of::<GtkAccessibleClass>()}),
    ("GtkAction", Layout {size: size_of::<GtkAction>(), alignment: align_of::<GtkAction>()}),
    ("GtkActionBar", Layout {size: size_of::<GtkActionBar>(), alignment: align_of::<GtkActionBar>()}),
    ("GtkActionClass", Layout {size: size_of::<GtkActionClass>(), alignment: align_of::<GtkActionClass>()}),
    ("GtkActionEntry", Layout {size: size_of::<GtkActionEntry>(), alignment: align_of::<GtkActionEntry>()}),
    ("GtkActionGroup", Layout {size: size_of::<GtkActionGroup>(), alignment: align_of::<GtkActionGroup>()}),
    ("GtkActionGroupClass", Layout {size: size_of::<GtkActionGroupClass>(), alignment: align_of::<GtkActionGroupClass>()}),
    ("GtkActionableInterface", Layout {size: size_of::<GtkActionableInterface>(), alignment: align_of::<GtkActionableInterface>()}),
    ("GtkActivatableIface", Layout {size: size_of::<GtkActivatableIface>(), alignment: align_of::<GtkActivatableIface>()}),
    ("GtkAdjustment", Layout {size: size_of::<GtkAdjustment>(), alignment: align_of::<GtkAdjustment>()}),
    ("GtkAdjustmentClass", Layout {size: size_of::<GtkAdjustmentClass>(), alignment: align_of::<GtkAdjustmentClass>()}),
    ("GtkAlign", Layout {size: size_of::<GtkAlign>(), alignment: align_of::<GtkAlign>()}),
    ("GtkAlignment", Layout {size: size_of::<GtkAlignment>(), alignment: align_of::<GtkAlignment>()}),
    ("GtkAllocation", Layout {size: size_of::<GtkAllocation>(), alignment: align_of::<GtkAllocation>()}),
    ("GtkAppChooserButton", Layout {size: size_of::<GtkAppChooserButton>(), alignment: align_of::<GtkAppChooserButton>()}),
    ("GtkAppChooserDialog", Layout {size: size_of::<GtkAppChooserDialog>(), alignment: align_of::<GtkAppChooserDialog>()}),
    ("GtkAppChooserWidget", Layout {size: size_of::<GtkAppChooserWidget>(), alignment: align_of::<GtkAppChooserWidget>()}),
    ("GtkApplication", Layout {size: size_of::<GtkApplication>(), alignment: align_of::<GtkApplication>()}),
    ("GtkApplicationClass", Layout {size: size_of::<GtkApplicationClass>(), alignment: align_of::<GtkApplicationClass>()}),
    ("GtkApplicationInhibitFlags", Layout {size: size_of::<GtkApplicationInhibitFlags>(), alignment: align_of::<GtkApplicationInhibitFlags>()}),
    ("GtkApplicationWindow", Layout {size: size_of::<GtkApplicationWindow>(), alignment: align_of::<GtkApplicationWindow>()}),
    ("GtkArrow", Layout {size: size_of::<GtkArrow>(), alignment: align_of::<GtkArrow>()}),
    ("GtkArrowAccessible", Layout {size: size_of::<GtkArrowAccessible>(), alignment: align_of::<GtkArrowAccessible>()}),
    ("GtkArrowAccessibleClass", Layout {size: size_of::<GtkArrowAccessibleClass>(), alignment: align_of::<GtkArrowAccessibleClass>()}),
    ("GtkArrowClass", Layout {size: size_of::<GtkArrowClass>(), alignment: align_of::<GtkArrowClass>()}),
    ("GtkArrowPlacement", Layout {size: size_of::<GtkArrowPlacement>(), alignment: align_of::<GtkArrowPlacement>()}),
    ("GtkArrowType", Layout {size: size_of::<GtkArrowType>(), alignment: align_of::<GtkArrowType>()}),
    ("GtkAspectFrame", Layout {size: size_of::<GtkAspectFrame>(), alignment: align_of::<GtkAspectFrame>()}),
    ("GtkAssistant", Layout {size: size_of::<GtkAssistant>(), alignment: align_of::<GtkAssistant>()}),
    ("GtkAssistantPageType", Layout {size: size_of::<GtkAssistantPageType>(), alignment: align_of::<GtkAssistantPageType>()}),
    ("GtkAttachOptions", Layout {size: size_of::<GtkAttachOptions>(), alignment: align_of::<GtkAttachOptions>()}),
    ("GtkBaselinePosition", Layout {size: size_of::<GtkBaselinePosition>(), alignment: align_of::<GtkBaselinePosition>()}),
    ("GtkBin", Layout {size: size_of::<GtkBin>(), alignment: align_of::<GtkBin>()}),
    ("GtkBindingArg", Layout {size: size_of::<GtkBindingArg>(), alignment: align_of::<GtkBindingArg>()}),
    ("GtkBindingSignal", Layout {size: size_of::<GtkBindingSignal>(), alignment: align_of::<GtkBindingSignal>()}),
    ("GtkBooleanCellAccessible", Layout {size: size_of::<GtkBooleanCellAccessible>(), alignment: align_of::<GtkBooleanCellAccessible>()}),
    ("GtkBooleanCellAccessibleClass", Layout {size: size_of::<GtkBooleanCellAccessibleClass>(), alignment: align_of::<GtkBooleanCellAccessibleClass>()}),
    ("GtkBorder", Layout {size: size_of::<GtkBorder>(), alignment: align_of::<GtkBorder>()}),
    ("GtkBorderStyle", Layout {size: size_of::<GtkBorderStyle>(), alignment: align_of::<GtkBorderStyle>()}),
    ("GtkBox", Layout {size: size_of::<GtkBox>(), alignment: align_of::<GtkBox>()}),
    ("GtkBuildableIface", Layout {size: size_of::<GtkBuildableIface>(), alignment: align_of::<GtkBuildableIface>()}),
    ("GtkBuilder", Layout {size: size_of::<GtkBuilder>(), alignment: align_of::<GtkBuilder>()}),
    ("GtkBuilderClass", Layout {size: size_of::<GtkBuilderClass>(), alignment: align_of::<GtkBuilderClass>()}),
    ("GtkBuilderError", Layout {size: size_of::<GtkBuilderError>(), alignment: align_of::<GtkBuilderError>()}),
    ("GtkButton", Layout {size: size_of::<GtkButton>(), alignment: align_of::<GtkButton>()}),
    ("GtkButtonAccessible", Layout {size: size_of::<GtkButtonAccessible>(), alignment: align_of::<GtkButtonAccessible>()}),
    ("GtkButtonAccessibleClass", Layout {size: size_of::<GtkButtonAccessibleClass>(), alignment: align_of::<GtkButtonAccessibleClass>()}),
    ("GtkButtonBox", Layout {size: size_of::<GtkButtonBox>(), alignment: align_of::<GtkButtonBox>()}),
    ("GtkButtonBoxStyle", Layout {size: size_of::<GtkButtonBoxStyle>(), alignment: align_of::<GtkButtonBoxStyle>()}),
    ("GtkButtonRole", Layout {size: size_of::<GtkButtonRole>(), alignment: align_of::<GtkButtonRole>()}),
    ("GtkButtonsType", Layout {size: size_of::<GtkButtonsType>(), alignment: align_of::<GtkButtonsType>()}),
    ("GtkCalendar", Layout {size: size_of::<GtkCalendar>(), alignment: align_of::<GtkCalendar>()}),
    ("GtkCalendarClass", Layout {size: size_of::<GtkCalendarClass>(), alignment: align_of::<GtkCalendarClass>()}),
    ("GtkCalendarDisplayOptions", Layout {size: size_of::<GtkCalendarDisplayOptions>(), alignment: align_of::<GtkCalendarDisplayOptions>()}),
    ("GtkCellAccessible", Layout {size: size_of::<GtkCellAccessible>(), alignment: align_of::<GtkCellAccessible>()}),
    ("GtkCellAccessibleClass", Layout {size: size_of::<GtkCellAccessibleClass>(), alignment: align_of::<GtkCellAccessibleClass>()}),
    ("GtkCellAccessibleParentIface", Layout {size: size_of::<GtkCellAccessibleParentIface>(), alignment: align_of::<GtkCellAccessibleParentIface>()}),
    ("GtkCellArea", Layout {size: size_of::<GtkCellArea>(), alignment: align_of::<GtkCellArea>()}),
    ("GtkCellAreaBox", Layout {size: size_of::<GtkCellAreaBox>(), alignment: align_of::<GtkCellAreaBox>()}),
    ("GtkCellAreaBoxClass", Layout {size: size_of::<GtkCellAreaBoxClass>(), alignment: align_of::<GtkCellAreaBoxClass>()}),
    ("GtkCellAreaClass", Layout {size: size_of::<GtkCellAreaClass>(), alignment: align_of::<GtkCellAreaClass>()}),
    ("GtkCellAreaContext", Layout {size: size_of::<GtkCellAreaContext>(), alignment: align_of::<GtkCellAreaContext>()}),
    ("GtkCellAreaContextClass", Layout {size: size_of::<GtkCellAreaContextClass>(), alignment: align_of::<GtkCellAreaContextClass>()}),
    ("GtkCellEditableIface", Layout {size: size_of::<GtkCellEditableIface>(), alignment: align_of::<GtkCellEditableIface>()}),
    ("GtkCellLayoutIface", Layout {size: size_of::<GtkCellLayoutIface>(), alignment: align_of::<GtkCellLayoutIface>()}),
    ("GtkCellRenderer", Layout {size: size_of::<GtkCellRenderer>(), alignment: align_of::<GtkCellRenderer>()}),
    ("GtkCellRendererAccel", Layout {size: size_of::<GtkCellRendererAccel>(), alignment: align_of::<GtkCellRendererAccel>()}),
    ("GtkCellRendererAccelClass", Layout {size: size_of::<GtkCellRendererAccelClass>(), alignment: align_of::<GtkCellRendererAccelClass>()}),
    ("GtkCellRendererAccelMode", Layout {size: size_of::<GtkCellRendererAccelMode>(), alignment: align_of::<GtkCellRendererAccelMode>()}),
    ("GtkCellRendererClass", Layout {size: size_of::<GtkCellRendererClass>(), alignment: align_of::<GtkCellRendererClass>()}),
    ("GtkCellRendererCombo", Layout {size: size_of::<GtkCellRendererCombo>(), alignment: align_of::<GtkCellRendererCombo>()}),
    ("GtkCellRendererComboClass", Layout {size: size_of::<GtkCellRendererComboClass>(), alignment: align_of::<GtkCellRendererComboClass>()}),
    ("GtkCellRendererMode", Layout {size: size_of::<GtkCellRendererMode>(), alignment: align_of::<GtkCellRendererMode>()}),
    ("GtkCellRendererPixbuf", Layout {size: size_of::<GtkCellRendererPixbuf>(), alignment: align_of::<GtkCellRendererPixbuf>()}),
    ("GtkCellRendererPixbufClass", Layout {size: size_of::<GtkCellRendererPixbufClass>(), alignment: align_of::<GtkCellRendererPixbufClass>()}),
    ("GtkCellRendererProgress", Layout {size: size_of::<GtkCellRendererProgress>(), alignment: align_of::<GtkCellRendererProgress>()}),
    ("GtkCellRendererProgressClass", Layout {size: size_of::<GtkCellRendererProgressClass>(), alignment: align_of::<GtkCellRendererProgressClass>()}),
    ("GtkCellRendererSpin", Layout {size: size_of::<GtkCellRendererSpin>(), alignment: align_of::<GtkCellRendererSpin>()}),
    ("GtkCellRendererSpinClass", Layout {size: size_of::<GtkCellRendererSpinClass>(), alignment: align_of::<GtkCellRendererSpinClass>()}),
    ("GtkCellRendererSpinner", Layout {size: size_of::<GtkCellRendererSpinner>(), alignment: align_of::<GtkCellRendererSpinner>()}),
    ("GtkCellRendererSpinnerClass", Layout {size: size_of::<GtkCellRendererSpinnerClass>(), alignment: align_of::<GtkCellRendererSpinnerClass>()}),
    ("GtkCellRendererState", Layout {size: size_of::<GtkCellRendererState>(), alignment: align_of::<GtkCellRendererState>()}),
    ("GtkCellRendererText", Layout {size: size_of::<GtkCellRendererText>(), alignment: align_of::<GtkCellRendererText>()}),
    ("GtkCellRendererTextClass", Layout {size: size_of::<GtkCellRendererTextClass>(), alignment: align_of::<GtkCellRendererTextClass>()}),
    ("GtkCellRendererToggle", Layout {size: size_of::<GtkCellRendererToggle>(), alignment: align_of::<GtkCellRendererToggle>()}),
    ("GtkCellRendererToggleClass", Layout {size: size_of::<GtkCellRendererToggleClass>(), alignment: align_of::<GtkCellRendererToggleClass>()}),
    ("GtkCellView", Layout {size: size_of::<GtkCellView>(), alignment: align_of::<GtkCellView>()}),
    ("GtkCellViewClass", Layout {size: size_of::<GtkCellViewClass>(), alignment: align_of::<GtkCellViewClass>()}),
    ("GtkCheckButton", Layout {size: size_of::<GtkCheckButton>(), alignment: align_of::<GtkCheckButton>()}),
    ("GtkCheckMenuItem", Layout {size: size_of::<GtkCheckMenuItem>(), alignment: align_of::<GtkCheckMenuItem>()}),
    ("GtkCheckMenuItemAccessible", Layout {size: size_of::<GtkCheckMenuItemAccessible>(), alignment: align_of::<GtkCheckMenuItemAccessible>()}),
    ("GtkCheckMenuItemAccessibleClass", Layout {size: size_of::<GtkCheckMenuItemAccessibleClass>(), alignment: align_of::<GtkCheckMenuItemAccessibleClass>()}),
    ("GtkColorButton", Layout {size: size_of::<GtkColorButton>(), alignment: align_of::<GtkColorButton>()}),
    ("GtkColorChooserDialog", Layout {size: size_of::<GtkColorChooserDialog>(), alignment: align_of::<GtkColorChooserDialog>()}),
    ("GtkColorChooserInterface", Layout {size: size_of::<GtkColorChooserInterface>(), alignment: align_of::<GtkColorChooserInterface>()}),
    ("GtkColorChooserWidget", Layout {size: size_of::<GtkColorChooserWidget>(), alignment: align_of::<GtkColorChooserWidget>()}),
    ("GtkColorSelection", Layout {size: size_of::<GtkColorSelection>(), alignment: align_of::<GtkColorSelection>()}),
    ("GtkColorSelectionDialog", Layout {size: size_of::<GtkColorSelectionDialog>(), alignment: align_of::<GtkColorSelectionDialog>()}),
    ("GtkComboBox", Layout {size: size_of::<GtkComboBox>(), alignment: align_of::<GtkComboBox>()}),
    ("GtkComboBoxAccessible", Layout {size: size_of::<GtkComboBoxAccessible>(), alignment: align_of::<GtkComboBoxAccessible>()}),
    ("GtkComboBoxAccessibleClass", Layout {size: size_of::<GtkComboBoxAccessibleClass>(), alignment: align_of::<GtkComboBoxAccessibleClass>()}),
    ("GtkComboBoxText", Layout {size: size_of::<GtkComboBoxText>(), alignment: align_of::<GtkComboBoxText>()}),
    ("GtkContainer", Layout {size: size_of::<GtkContainer>(), alignment: align_of::<GtkContainer>()}),
    ("GtkContainerAccessible", Layout {size: size_of::<GtkContainerAccessible>(), alignment: align_of::<GtkContainerAccessible>()}),
    ("GtkContainerAccessibleClass", Layout {size: size_of::<GtkContainerAccessibleClass>(), alignment: align_of::<GtkContainerAccessibleClass>()}),
    ("GtkContainerCellAccessible", Layout {size: size_of::<GtkContainerCellAccessible>(), alignment: align_of::<GtkContainerCellAccessible>()}),
    ("GtkContainerCellAccessibleClass", Layout {size: size_of::<GtkContainerCellAccessibleClass>(), alignment: align_of::<GtkContainerCellAccessibleClass>()}),
    ("GtkCornerType", Layout {size: size_of::<GtkCornerType>(), alignment: align_of::<GtkCornerType>()}),
    ("GtkCssProvider", Layout {size: size_of::<GtkCssProvider>(), alignment: align_of::<GtkCssProvider>()}),
    ("GtkCssProviderClass", Layout {size: size_of::<GtkCssProviderClass>(), alignment: align_of::<GtkCssProviderClass>()}),
    ("GtkCssProviderError", Layout {size: size_of::<GtkCssProviderError>(), alignment: align_of::<GtkCssProviderError>()}),
    ("GtkCssSectionType", Layout {size: size_of::<GtkCssSectionType>(), alignment: align_of::<GtkCssSectionType>()}),
    ("GtkDebugFlag", Layout {size: size_of::<GtkDebugFlag>(), alignment: align_of::<GtkDebugFlag>()}),
    ("GtkDeleteType", Layout {size: size_of::<GtkDeleteType>(), alignment: align_of::<GtkDeleteType>()}),
    ("GtkDestDefaults", Layout {size: size_of::<GtkDestDefaults>(), alignment: align_of::<GtkDestDefaults>()}),
    ("GtkDialog", Layout {size: size_of::<GtkDialog>(), alignment: align_of::<GtkDialog>()}),
    ("GtkDialogFlags", Layout {size: size_of::<GtkDialogFlags>(), alignment: align_of::<GtkDialogFlags>()}),
    ("GtkDirectionType", Layout {size: size_of::<GtkDirectionType>(), alignment: align_of::<GtkDirectionType>()}),
    ("GtkDragResult", Layout {size: size_of::<GtkDragResult>(), alignment: align_of::<GtkDragResult>()}),
    ("GtkDrawingArea", Layout {size: size_of::<GtkDrawingArea>(), alignment: align_of::<GtkDrawingArea>()}),
    ("GtkDrawingAreaClass", Layout {size: size_of::<GtkDrawingAreaClass>(), alignment: align_of::<GtkDrawingAreaClass>()}),
    ("GtkEditableInterface", Layout {size: size_of::<GtkEditableInterface>(), alignment: align_of::<GtkEditableInterface>()}),
    ("GtkEntry", Layout {size: size_of::<GtkEntry>(), alignment: align_of::<GtkEntry>()}),
    ("GtkEntryAccessible", Layout {size: size_of::<GtkEntryAccessible>(), alignment: align_of::<GtkEntryAccessible>()}),
    ("GtkEntryAccessibleClass", Layout {size: size_of::<GtkEntryAccessibleClass>(), alignment: align_of::<GtkEntryAccessibleClass>()}),
    ("GtkEntryBuffer", Layout {size: size_of::<GtkEntryBuffer>(), alignment: align_of::<GtkEntryBuffer>()}),
    ("GtkEntryBufferClass", Layout {size: size_of::<GtkEntryBufferClass>(), alignment: align_of::<GtkEntryBufferClass>()}),
    ("GtkEntryClass", Layout {size: size_of::<GtkEntryClass>(), alignment: align_of::<GtkEntryClass>()}),
    ("GtkEntryCompletion", Layout {size: size_of::<GtkEntryCompletion>(), alignment: align_of::<GtkEntryCompletion>()}),
    ("GtkEntryCompletionClass", Layout {size: size_of::<GtkEntryCompletionClass>(), alignment: align_of::<GtkEntryCompletionClass>()}),
    ("GtkEntryIconPosition", Layout {size: size_of::<GtkEntryIconPosition>(), alignment: align_of::<GtkEntryIconPosition>()}),
    ("GtkEventBox", Layout {size: size_of::<GtkEventBox>(), alignment: align_of::<GtkEventBox>()}),
    ("GtkEventSequenceState", Layout {size: size_of::<GtkEventSequenceState>(), alignment: align_of::<GtkEventSequenceState>()}),
    ("GtkExpander", Layout {size: size_of::<GtkExpander>(), alignment: align_of::<GtkExpander>()}),
    ("GtkExpanderAccessible", Layout {size: size_of::<GtkExpanderAccessible>(), alignment: align_of::<GtkExpanderAccessible>()}),
    ("GtkExpanderAccessibleClass", Layout {size: size_of::<GtkExpanderAccessibleClass>(), alignment: align_of::<GtkExpanderAccessibleClass>()}),
    ("GtkExpanderStyle", Layout {size: size_of::<GtkExpanderStyle>(), alignment: align_of::<GtkExpanderStyle>()}),
    ("GtkFileChooserAction", Layout {size: size_of::<GtkFileChooserAction>(), alignment: align_of::<GtkFileChooserAction>()}),
    ("GtkFileChooserButton", Layout {size: size_of::<GtkFileChooserButton>(), alignment: align_of::<GtkFileChooserButton>()}),
    ("GtkFileChooserConfirmation", Layout {size: size_of::<GtkFileChooserConfirmation>(), alignment: align_of::<GtkFileChooserConfirmation>()}),
    ("GtkFileChooserDialog", Layout {size: size_of::<GtkFileChooserDialog>(), alignment: align_of::<GtkFileChooserDialog>()}),
    ("GtkFileChooserError", Layout {size: size_of::<GtkFileChooserError>(), alignment: align_of::<GtkFileChooserError>()}),
    ("GtkFileChooserNativeClass", Layout {size: size_of::<GtkFileChooserNativeClass>(), alignment: align_of::<GtkFileChooserNativeClass>()}),
    ("GtkFileChooserWidget", Layout {size: size_of::<GtkFileChooserWidget>(), alignment: align_of::<GtkFileChooserWidget>()}),
    ("GtkFileFilterFlags", Layout {size: size_of::<GtkFileFilterFlags>(), alignment: align_of::<GtkFileFilterFlags>()}),
    ("GtkFileFilterInfo", Layout {size: size_of::<GtkFileFilterInfo>(), alignment: align_of::<GtkFileFilterInfo>()}),
    ("GtkFixed", Layout {size: size_of::<GtkFixed>(), alignment: align_of::<GtkFixed>()}),
    ("GtkFixedChild", Layout {size: size_of::<GtkFixedChild>(), alignment: align_of::<GtkFixedChild>()}),
    ("GtkFlowBox", Layout {size: size_of::<GtkFlowBox>(), alignment: align_of::<GtkFlowBox>()}),
    ("GtkFlowBoxAccessible", Layout {size: size_of::<GtkFlowBoxAccessible>(), alignment: align_of::<GtkFlowBoxAccessible>()}),
    ("GtkFlowBoxAccessibleClass", Layout {size: size_of::<GtkFlowBoxAccessibleClass>(), alignment: align_of::<GtkFlowBoxAccessibleClass>()}),
    ("GtkFlowBoxChild", Layout {size: size_of::<GtkFlowBoxChild>(), alignment: align_of::<GtkFlowBoxChild>()}),
    ("GtkFlowBoxChildAccessible", Layout {size: size_of::<GtkFlowBoxChildAccessible>(), alignment: align_of::<GtkFlowBoxChildAccessible>()}),
    ("GtkFlowBoxChildAccessibleClass", Layout {size: size_of::<GtkFlowBoxChildAccessibleClass>(), alignment: align_of::<GtkFlowBoxChildAccessibleClass>()}),
    ("GtkFontButton", Layout {size: size_of::<GtkFontButton>(), alignment: align_of::<GtkFontButton>()}),
    ("GtkFontChooserDialog", Layout {size: size_of::<GtkFontChooserDialog>(), alignment: align_of::<GtkFontChooserDialog>()}),
    ("GtkFontChooserIface", Layout {size: size_of::<GtkFontChooserIface>(), alignment: align_of::<GtkFontChooserIface>()}),
    ("GtkFontChooserWidget", Layout {size: size_of::<GtkFontChooserWidget>(), alignment: align_of::<GtkFontChooserWidget>()}),
    ("GtkFontSelection", Layout {size: size_of::<GtkFontSelection>(), alignment: align_of::<GtkFontSelection>()}),
    ("GtkFontSelectionDialog", Layout {size: size_of::<GtkFontSelectionDialog>(), alignment: align_of::<GtkFontSelectionDialog>()}),
    ("GtkFrame", Layout {size: size_of::<GtkFrame>(), alignment: align_of::<GtkFrame>()}),
    ("GtkFrameAccessible", Layout {size: size_of::<GtkFrameAccessible>(), alignment: align_of::<GtkFrameAccessible>()}),
    ("GtkFrameAccessibleClass", Layout {size: size_of::<GtkFrameAccessibleClass>(), alignment: align_of::<GtkFrameAccessibleClass>()}),
    ("GtkGLArea", Layout {size: size_of::<GtkGLArea>(), alignment: align_of::<GtkGLArea>()}),
    ("GtkGLAreaClass", Layout {size: size_of::<GtkGLAreaClass>(), alignment: align_of::<GtkGLAreaClass>()}),
    ("GtkGrid", Layout {size: size_of::<GtkGrid>(), alignment: align_of::<GtkGrid>()}),
    ("GtkHBox", Layout {size: size_of::<GtkHBox>(), alignment: align_of::<GtkHBox>()}),
    ("GtkHButtonBox", Layout {size: size_of::<GtkHButtonBox>(), alignment: align_of::<GtkHButtonBox>()}),
    ("GtkHPaned", Layout {size: size_of::<GtkHPaned>(), alignment: align_of::<GtkHPaned>()}),
    ("GtkHSV", Layout {size: size_of::<GtkHSV>(), alignment: align_of::<GtkHSV>()}),
    ("GtkHSVClass", Layout {size: size_of::<GtkHSVClass>(), alignment: align_of::<GtkHSVClass>()}),
    ("GtkHScale", Layout {size: size_of::<GtkHScale>(), alignment: align_of::<GtkHScale>()}),
    ("GtkHScaleClass", Layout {size: size_of::<GtkHScaleClass>(), alignment: align_of::<GtkHScaleClass>()}),
    ("GtkHScrollbar", Layout {size: size_of::<GtkHScrollbar>(), alignment: align_of::<GtkHScrollbar>()}),
    ("GtkHScrollbarClass", Layout {size: size_of::<GtkHScrollbarClass>(), alignment: align_of::<GtkHScrollbarClass>()}),
    ("GtkHSeparator", Layout {size: size_of::<GtkHSeparator>(), alignment: align_of::<GtkHSeparator>()}),
    ("GtkHSeparatorClass", Layout {size: size_of::<GtkHSeparatorClass>(), alignment: align_of::<GtkHSeparatorClass>()}),
    ("GtkHandleBox", Layout {size: size_of::<GtkHandleBox>(), alignment: align_of::<GtkHandleBox>()}),
    ("GtkHeaderBar", Layout {size: size_of::<GtkHeaderBar>(), alignment: align_of::<GtkHeaderBar>()}),
    ("GtkIMContext", Layout {size: size_of::<GtkIMContext>(), alignment: align_of::<GtkIMContext>()}),
    ("GtkIMContextClass", Layout {size: size_of::<GtkIMContextClass>(), alignment: align_of::<GtkIMContextClass>()}),
    ("GtkIMContextInfo", Layout {size: size_of::<GtkIMContextInfo>(), alignment: align_of::<GtkIMContextInfo>()}),
    ("GtkIMContextSimple", Layout {size: size_of::<GtkIMContextSimple>(), alignment: align_of::<GtkIMContextSimple>()}),
    ("GtkIMContextSimpleClass", Layout {size: size_of::<GtkIMContextSimpleClass>(), alignment: align_of::<GtkIMContextSimpleClass>()}),
    ("GtkIMMulticontext", Layout {size: size_of::<GtkIMMulticontext>(), alignment: align_of::<GtkIMMulticontext>()}),
    ("GtkIMMulticontextClass", Layout {size: size_of::<GtkIMMulticontextClass>(), alignment: align_of::<GtkIMMulticontextClass>()}),
    ("GtkIMPreeditStyle", Layout {size: size_of::<GtkIMPreeditStyle>(), alignment: align_of::<GtkIMPreeditStyle>()}),
    ("GtkIMStatusStyle", Layout {size: size_of::<GtkIMStatusStyle>(), alignment: align_of::<GtkIMStatusStyle>()}),
    ("GtkIconFactory", Layout {size: size_of::<GtkIconFactory>(), alignment: align_of::<GtkIconFactory>()}),
    ("GtkIconFactoryClass", Layout {size: size_of::<GtkIconFactoryClass>(), alignment: align_of::<GtkIconFactoryClass>()}),
    ("GtkIconLookupFlags", Layout {size: size_of::<GtkIconLookupFlags>(), alignment: align_of::<GtkIconLookupFlags>()}),
    ("GtkIconSize", Layout {size: size_of::<GtkIconSize>(), alignment: align_of::<GtkIconSize>()}),
    ("GtkIconTheme", Layout {size: size_of::<GtkIconTheme>(), alignment: align_of::<GtkIconTheme>()}),
    ("GtkIconThemeClass", Layout {size: size_of::<GtkIconThemeClass>(), alignment: align_of::<GtkIconThemeClass>()}),
    ("GtkIconThemeError", Layout {size: size_of::<GtkIconThemeError>(), alignment: align_of::<GtkIconThemeError>()}),
    ("GtkIconView", Layout {size: size_of::<GtkIconView>(), alignment: align_of::<GtkIconView>()}),
    ("GtkIconViewAccessible", Layout {size: size_of::<GtkIconViewAccessible>(), alignment: align_of::<GtkIconViewAccessible>()}),
    ("GtkIconViewAccessibleClass", Layout {size: size_of::<GtkIconViewAccessibleClass>(), alignment: align_of::<GtkIconViewAccessibleClass>()}),
    ("GtkIconViewDropPosition", Layout {size: size_of::<GtkIconViewDropPosition>(), alignment: align_of::<GtkIconViewDropPosition>()}),
    ("GtkImage", Layout {size: size_of::<GtkImage>(), alignment: align_of::<GtkImage>()}),
    ("GtkImageAccessible", Layout {size: size_of::<GtkImageAccessible>(), alignment: align_of::<GtkImageAccessible>()}),
    ("GtkImageAccessibleClass", Layout {size: size_of::<GtkImageAccessibleClass>(), alignment: align_of::<GtkImageAccessibleClass>()}),
    ("GtkImageCellAccessible", Layout {size: size_of::<GtkImageCellAccessible>(), alignment: align_of::<GtkImageCellAccessible>()}),
    ("GtkImageCellAccessibleClass", Layout {size: size_of::<GtkImageCellAccessibleClass>(), alignment: align_of::<GtkImageCellAccessibleClass>()}),
    ("GtkImageClass", Layout {size: size_of::<GtkImageClass>(), alignment: align_of::<GtkImageClass>()}),
    ("GtkImageMenuItem", Layout {size: size_of::<GtkImageMenuItem>(), alignment: align_of::<GtkImageMenuItem>()}),
    ("GtkImageType", Layout {size: size_of::<GtkImageType>(), alignment: align_of::<GtkImageType>()}),
    ("GtkInfoBar", Layout {size: size_of::<GtkInfoBar>(), alignment: align_of::<GtkInfoBar>()}),
    ("GtkInputHints", Layout {size: size_of::<GtkInputHints>(), alignment: align_of::<GtkInputHints>()}),
    ("GtkInputPurpose", Layout {size: size_of::<GtkInputPurpose>(), alignment: align_of::<GtkInputPurpose>()}),
    ("GtkInvisible", Layout {size: size_of::<GtkInvisible>(), alignment: align_of::<GtkInvisible>()}),
    ("GtkInvisibleClass", Layout {size: size_of::<GtkInvisibleClass>(), alignment: align_of::<GtkInvisibleClass>()}),
    ("GtkJunctionSides", Layout {size: size_of::<GtkJunctionSides>(), alignment: align_of::<GtkJunctionSides>()}),
    ("GtkJustification", Layout {size: size_of::<GtkJustification>(), alignment: align_of::<GtkJustification>()}),
    ("GtkLabel", Layout {size: size_of::<GtkLabel>(), alignment: align_of::<GtkLabel>()}),
    ("GtkLabelAccessible", Layout {size: size_of::<GtkLabelAccessible>(), alignment: align_of::<GtkLabelAccessible>()}),
    ("GtkLabelAccessibleClass", Layout {size: size_of::<GtkLabelAccessibleClass>(), alignment: align_of::<GtkLabelAccessibleClass>()}),
    ("GtkLabelClass", Layout {size: size_of::<GtkLabelClass>(), alignment: align_of::<GtkLabelClass>()}),
    ("GtkLayout", Layout {size: size_of::<GtkLayout>(), alignment: align_of::<GtkLayout>()}),
    ("GtkLevelBar", Layout {size: size_of::<GtkLevelBar>(), alignment: align_of::<GtkLevelBar>()}),
    ("GtkLevelBarAccessible", Layout {size: size_of::<GtkLevelBarAccessible>(), alignment: align_of::<GtkLevelBarAccessible>()}),
    ("GtkLevelBarAccessibleClass", Layout {size: size_of::<GtkLevelBarAccessibleClass>(), alignment: align_of::<GtkLevelBarAccessibleClass>()}),
    ("GtkLevelBarClass", Layout {size: size_of::<GtkLevelBarClass>(), alignment: align_of::<GtkLevelBarClass>()}),
    ("GtkLevelBarMode", Layout {size: size_of::<GtkLevelBarMode>(), alignment: align_of::<GtkLevelBarMode>()}),
    ("GtkLicense", Layout {size: size_of::<GtkLicense>(), alignment: align_of::<GtkLicense>()}),
    ("GtkLinkButton", Layout {size: size_of::<GtkLinkButton>(), alignment: align_of::<GtkLinkButton>()}),
    ("GtkLinkButtonAccessible", Layout {size: size_of::<GtkLinkButtonAccessible>(), alignment: align_of::<GtkLinkButtonAccessible>()}),
    ("GtkLinkButtonAccessibleClass", Layout {size: size_of::<GtkLinkButtonAccessibleClass>(), alignment: align_of::<GtkLinkButtonAccessibleClass>()}),
    ("GtkListBox", Layout {size: size_of::<GtkListBox>(), alignment: align_of::<GtkListBox>()}),
    ("GtkListBoxAccessible", Layout {size: size_of::<GtkListBoxAccessible>(), alignment: align_of::<GtkListBoxAccessible>()}),
    ("GtkListBoxAccessibleClass", Layout {size: size_of::<GtkListBoxAccessibleClass>(), alignment: align_of::<GtkListBoxAccessibleClass>()}),
    ("GtkListBoxRow", Layout {size: size_of::<GtkListBoxRow>(), alignment: align_of::<GtkListBoxRow>()}),
    ("GtkListBoxRowAccessible", Layout {size: size_of::<GtkListBoxRowAccessible>(), alignment: align_of::<GtkListBoxRowAccessible>()}),
    ("GtkListBoxRowAccessibleClass", Layout {size: size_of::<GtkListBoxRowAccessibleClass>(), alignment: align_of::<GtkListBoxRowAccessibleClass>()}),
    ("GtkListStore", Layout {size: size_of::<GtkListStore>(), alignment: align_of::<GtkListStore>()}),
    ("GtkListStoreClass", Layout {size: size_of::<GtkListStoreClass>(), alignment: align_of::<GtkListStoreClass>()}),
    ("GtkLockButton", Layout {size: size_of::<GtkLockButton>(), alignment: align_of::<GtkLockButton>()}),
    ("GtkLockButtonAccessible", Layout {size: size_of::<GtkLockButtonAccessible>(), alignment: align_of::<GtkLockButtonAccessible>()}),
    ("GtkLockButtonAccessibleClass", Layout {size: size_of::<GtkLockButtonAccessibleClass>(), alignment: align_of::<GtkLockButtonAccessibleClass>()}),
    ("GtkMenu", Layout {size: size_of::<GtkMenu>(), alignment: align_of::<GtkMenu>()}),
    ("GtkMenuAccessible", Layout {size: size_of::<GtkMenuAccessible>(), alignment: align_of::<GtkMenuAccessible>()}),
    ("GtkMenuAccessibleClass", Layout {size: size_of::<GtkMenuAccessibleClass>(), alignment: align_of::<GtkMenuAccessibleClass>()}),
    ("GtkMenuBar", Layout {size: size_of::<GtkMenuBar>(), alignment: align_of::<GtkMenuBar>()}),
    ("GtkMenuButton", Layout {size: size_of::<GtkMenuButton>(), alignment: align_of::<GtkMenuButton>()}),
    ("GtkMenuButtonAccessible", Layout {size: size_of::<GtkMenuButtonAccessible>(), alignment: align_of::<GtkMenuButtonAccessible>()}),
    ("GtkMenuButtonAccessibleClass", Layout {size: size_of::<GtkMenuButtonAccessibleClass>(), alignment: align_of::<GtkMenuButtonAccessibleClass>()}),
    ("GtkMenuDirectionType", Layout {size: size_of::<GtkMenuDirectionType>(), alignment: align_of::<GtkMenuDirectionType>()}),
    ("GtkMenuItem", Layout {size: size_of::<GtkMenuItem>(), alignment: align_of::<GtkMenuItem>()}),
    ("GtkMenuItemAccessible", Layout {size: size_of::<GtkMenuItemAccessible>(), alignment: align_of::<GtkMenuItemAccessible>()}),
    ("GtkMenuItemAccessibleClass", Layout {size: size_of::<GtkMenuItemAccessibleClass>(), alignment: align_of::<GtkMenuItemAccessibleClass>()}),
    ("GtkMenuShell", Layout {size: size_of::<GtkMenuShell>(), alignment: align_of::<GtkMenuShell>()}),
    ("GtkMenuShellAccessible", Layout {size: size_of::<GtkMenuShellAccessible>(), alignment: align_of::<GtkMenuShellAccessible>()}),
    ("GtkMenuShellAccessibleClass", Layout {size: size_of::<GtkMenuShellAccessibleClass>(), alignment: align_of::<GtkMenuShellAccessibleClass>()}),
    ("GtkMenuToolButton", Layout {size: size_of::<GtkMenuToolButton>(), alignment: align_of::<GtkMenuToolButton>()}),
    ("GtkMessageDialog", Layout {size: size_of::<GtkMessageDialog>(), alignment: align_of::<GtkMessageDialog>()}),
    ("GtkMessageType", Layout {size: size_of::<GtkMessageType>(), alignment: align_of::<GtkMessageType>()}),
    ("GtkMisc", Layout {size: size_of::<GtkMisc>(), alignment: align_of::<GtkMisc>()}),
    ("GtkMiscClass", Layout {size: size_of::<GtkMiscClass>(), alignment: align_of::<GtkMiscClass>()}),
    ("GtkMountOperation", Layout {size: size_of::<GtkMountOperation>(), alignment: align_of::<GtkMountOperation>()}),
    ("GtkMountOperationClass", Layout {size: size_of::<GtkMountOperationClass>(), alignment: align_of::<GtkMountOperationClass>()}),
    ("GtkMovementStep", Layout {size: size_of::<GtkMovementStep>(), alignment: align_of::<GtkMovementStep>()}),
    ("GtkNativeDialog", Layout {size: size_of::<GtkNativeDialog>(), alignment: align_of::<GtkNativeDialog>()}),
    ("GtkNativeDialogClass", Layout {size: size_of::<GtkNativeDialogClass>(), alignment: align_of::<GtkNativeDialogClass>()}),
    ("GtkNotebook", Layout {size: size_of::<GtkNotebook>(), alignment: align_of::<GtkNotebook>()}),
    ("GtkNotebookAccessible", Layout {size: size_of::<GtkNotebookAccessible>(), alignment: align_of::<GtkNotebookAccessible>()}),
    ("GtkNotebookAccessibleClass", Layout {size: size_of::<GtkNotebookAccessibleClass>(), alignment: align_of::<GtkNotebookAccessibleClass>()}),
    ("GtkNotebookPageAccessible", Layout {size: size_of::<GtkNotebookPageAccessible>(), alignment: align_of::<GtkNotebookPageAccessible>()}),
    ("GtkNotebookPageAccessibleClass", Layout {size: size_of::<GtkNotebookPageAccessibleClass>(), alignment: align_of::<GtkNotebookPageAccessibleClass>()}),
    ("GtkNotebookTab", Layout {size: size_of::<GtkNotebookTab>(), alignment: align_of::<GtkNotebookTab>()}),
    ("GtkNumberUpLayout", Layout {size: size_of::<GtkNumberUpLayout>(), alignment: align_of::<GtkNumberUpLayout>()}),
    ("GtkNumerableIcon", Layout {size: size_of::<GtkNumerableIcon>(), alignment: align_of::<GtkNumerableIcon>()}),
    ("GtkNumerableIconClass", Layout {size: size_of::<GtkNumerableIconClass>(), alignment: align_of::<GtkNumerableIconClass>()}),
    ("GtkOffscreenWindow", Layout {size: size_of::<GtkOffscreenWindow>(), alignment: align_of::<GtkOffscreenWindow>()}),
    ("GtkOrientableIface", Layout {size: size_of::<GtkOrientableIface>(), alignment: align_of::<GtkOrientableIface>()}),
    ("GtkOrientation", Layout {size: size_of::<GtkOrientation>(), alignment: align_of::<GtkOrientation>()}),
    ("GtkOverlay", Layout {size: size_of::<GtkOverlay>(), alignment: align_of::<GtkOverlay>()}),
    ("GtkPackDirection", Layout {size: size_of::<GtkPackDirection>(), alignment: align_of::<GtkPackDirection>()}),
    ("GtkPackType", Layout {size: size_of::<GtkPackType>(), alignment: align_of::<GtkPackType>()}),
    ("GtkPadActionEntry", Layout {size: size_of::<GtkPadActionEntry>(), alignment: align_of::<GtkPadActionEntry>()}),
    ("GtkPadActionType", Layout {size: size_of::<GtkPadActionType>(), alignment: align_of::<GtkPadActionType>()}),
    ("GtkPageOrientation", Layout {size: size_of::<GtkPageOrientation>(), alignment: align_of::<GtkPageOrientation>()}),
    ("GtkPageRange", Layout {size: size_of::<GtkPageRange>(), alignment: align_of::<GtkPageRange>()}),
    ("GtkPageSet", Layout {size: size_of::<GtkPageSet>(), alignment: align_of::<GtkPageSet>()}),
    ("GtkPanDirection", Layout {size: size_of::<GtkPanDirection>(), alignment: align_of::<GtkPanDirection>()}),
    ("GtkPaned", Layout {size: size_of::<GtkPaned>(), alignment: align_of::<GtkPaned>()}),
    ("GtkPanedAccessible", Layout {size: size_of::<GtkPanedAccessible>(), alignment: align_of::<GtkPanedAccessible>()}),
    ("GtkPanedAccessibleClass", Layout {size: size_of::<GtkPanedAccessibleClass>(), alignment: align_of::<GtkPanedAccessibleClass>()}),
    ("GtkPathPriorityType", Layout {size: size_of::<GtkPathPriorityType>(), alignment: align_of::<GtkPathPriorityType>()}),
    ("GtkPathType", Layout {size: size_of::<GtkPathType>(), alignment: align_of::<GtkPathType>()}),
    ("GtkPlacesOpenFlags", Layout {size: size_of::<GtkPlacesOpenFlags>(), alignment: align_of::<GtkPlacesOpenFlags>()}),
    ("GtkPlug", Layout {size: size_of::<GtkPlug>(), alignment: align_of::<GtkPlug>()}),
    ("GtkPolicyType", Layout {size: size_of::<GtkPolicyType>(), alignment: align_of::<GtkPolicyType>()}),
    ("GtkPopover", Layout {size: size_of::<GtkPopover>(), alignment: align_of::<GtkPopover>()}),
    ("GtkPopoverAccessible", Layout {size: size_of::<GtkPopoverAccessible>(), alignment: align_of::<GtkPopoverAccessible>()}),
    ("GtkPopoverAccessibleClass", Layout {size: size_of::<GtkPopoverAccessibleClass>(), alignment: align_of::<GtkPopoverAccessibleClass>()}),
    ("GtkPopoverConstraint", Layout {size: size_of::<GtkPopoverConstraint>(), alignment: align_of::<GtkPopoverConstraint>()}),
    ("GtkPositionType", Layout {size: size_of::<GtkPositionType>(), alignment: align_of::<GtkPositionType>()}),
    ("GtkPrintDuplex", Layout {size: size_of::<GtkPrintDuplex>(), alignment: align_of::<GtkPrintDuplex>()}),
    ("GtkPrintError", Layout {size: size_of::<GtkPrintError>(), alignment: align_of::<GtkPrintError>()}),
    ("GtkPrintOperation", Layout {size: size_of::<GtkPrintOperation>(), alignment: align_of::<GtkPrintOperation>()}),
    ("GtkPrintOperationAction", Layout {size: size_of::<GtkPrintOperationAction>(), alignment: align_of::<GtkPrintOperationAction>()}),
    ("GtkPrintOperationClass", Layout {size: size_of::<GtkPrintOperationClass>(), alignment: align_of::<GtkPrintOperationClass>()}),
    ("GtkPrintOperationPreviewIface", Layout {size: size_of::<GtkPrintOperationPreviewIface>(), alignment: align_of::<GtkPrintOperationPreviewIface>()}),
    ("GtkPrintOperationResult", Layout {size: size_of::<GtkPrintOperationResult>(), alignment: align_of::<GtkPrintOperationResult>()}),
    ("GtkPrintPages", Layout {size: size_of::<GtkPrintPages>(), alignment: align_of::<GtkPrintPages>()}),
    ("GtkPrintQuality", Layout {size: size_of::<GtkPrintQuality>(), alignment: align_of::<GtkPrintQuality>()}),
    ("GtkPrintStatus", Layout {size: size_of::<GtkPrintStatus>(), alignment: align_of::<GtkPrintStatus>()}),
    ("GtkProgressBar", Layout {size: size_of::<GtkProgressBar>(), alignment: align_of::<GtkProgressBar>()}),
    ("GtkProgressBarAccessible", Layout {size: size_of::<GtkProgressBarAccessible>(), alignment: align_of::<GtkProgressBarAccessible>()}),
    ("GtkProgressBarAccessibleClass", Layout {size: size_of::<GtkProgressBarAccessibleClass>(), alignment: align_of::<GtkProgressBarAccessibleClass>()}),
    ("GtkProgressBarClass", Layout {size: size_of::<GtkProgressBarClass>(), alignment: align_of::<GtkProgressBarClass>()}),
    ("GtkPropagationPhase", Layout {size: size_of::<GtkPropagationPhase>(), alignment: align_of::<GtkPropagationPhase>()}),
    ("GtkRadioAction", Layout {size: size_of::<GtkRadioAction>(), alignment: align_of::<GtkRadioAction>()}),
    ("GtkRadioActionClass", Layout {size: size_of::<GtkRadioActionClass>(), alignment: align_of::<GtkRadioActionClass>()}),
    ("GtkRadioActionEntry", Layout {size: size_of::<GtkRadioActionEntry>(), alignment: align_of::<GtkRadioActionEntry>()}),
    ("GtkRadioButton", Layout {size: size_of::<GtkRadioButton>(), alignment: align_of::<GtkRadioButton>()}),
    ("GtkRadioButtonAccessible", Layout {size: size_of::<GtkRadioButtonAccessible>(), alignment: align_of::<GtkRadioButtonAccessible>()}),
    ("GtkRadioButtonAccessibleClass", Layout {size: size_of::<GtkRadioButtonAccessibleClass>(), alignment: align_of::<GtkRadioButtonAccessibleClass>()}),
    ("GtkRadioMenuItem", Layout {size: size_of::<GtkRadioMenuItem>(), alignment: align_of::<GtkRadioMenuItem>()}),
    ("GtkRadioMenuItemAccessible", Layout {size: size_of::<GtkRadioMenuItemAccessible>(), alignment: align_of::<GtkRadioMenuItemAccessible>()}),
    ("GtkRadioMenuItemAccessibleClass", Layout {size: size_of::<GtkRadioMenuItemAccessibleClass>(), alignment: align_of::<GtkRadioMenuItemAccessibleClass>()}),
    ("GtkRadioToolButton", Layout {size: size_of::<GtkRadioToolButton>(), alignment: align_of::<GtkRadioToolButton>()}),
    ("GtkRange", Layout {size: size_of::<GtkRange>(), alignment: align_of::<GtkRange>()}),
    ("GtkRangeAccessible", Layout {size: size_of::<GtkRangeAccessible>(), alignment: align_of::<GtkRangeAccessible>()}),
    ("GtkRangeAccessibleClass", Layout {size: size_of::<GtkRangeAccessibleClass>(), alignment: align_of::<GtkRangeAccessibleClass>()}),
    ("GtkRangeClass", Layout {size: size_of::<GtkRangeClass>(), alignment: align_of::<GtkRangeClass>()}),
    ("GtkRcFlags", Layout {size: size_of::<GtkRcFlags>(), alignment: align_of::<GtkRcFlags>()}),
    ("GtkRcProperty", Layout {size: size_of::<GtkRcProperty>(), alignment: align_of::<GtkRcProperty>()}),
    ("GtkRcStyleClass", Layout {size: size_of::<GtkRcStyleClass>(), alignment: align_of::<GtkRcStyleClass>()}),
    ("GtkRcTokenType", Layout {size: size_of::<GtkRcTokenType>(), alignment: align_of::<GtkRcTokenType>()}),
    ("GtkRecentAction", Layout {size: size_of::<GtkRecentAction>(), alignment: align_of::<GtkRecentAction>()}),
    ("GtkRecentActionClass", Layout {size: size_of::<GtkRecentActionClass>(), alignment: align_of::<GtkRecentActionClass>()}),
    ("GtkRecentChooserDialog", Layout {size: size_of::<GtkRecentChooserDialog>(), alignment: align_of::<GtkRecentChooserDialog>()}),
    ("GtkRecentChooserError", Layout {size: size_of::<GtkRecentChooserError>(), alignment: align_of::<GtkRecentChooserError>()}),
    ("GtkRecentChooserIface", Layout {size: size_of::<GtkRecentChooserIface>(), alignment: align_of::<GtkRecentChooserIface>()}),
    ("GtkRecentChooserMenu", Layout {size: size_of::<GtkRecentChooserMenu>(), alignment: align_of::<GtkRecentChooserMenu>()}),
    ("GtkRecentChooserWidget", Layout {size: size_of::<GtkRecentChooserWidget>(), alignment: align_of::<GtkRecentChooserWidget>()}),
    ("GtkRecentData", Layout {size: size_of::<GtkRecentData>(), alignment: align_of::<GtkRecentData>()}),
    ("GtkRecentFilterFlags", Layout {size: size_of::<GtkRecentFilterFlags>(), alignment: align_of::<GtkRecentFilterFlags>()}),
    ("GtkRecentFilterInfo", Layout {size: size_of::<GtkRecentFilterInfo>(), alignment: align_of::<GtkRecentFilterInfo>()}),
    ("GtkRecentManager", Layout {size: size_of::<GtkRecentManager>(), alignment: align_of::<GtkRecentManager>()}),
    ("GtkRecentManagerClass", Layout {size: size_of::<GtkRecentManagerClass>(), alignment: align_of::<GtkRecentManagerClass>()}),
    ("GtkRecentManagerError", Layout {size: size_of::<GtkRecentManagerError>(), alignment: align_of::<GtkRecentManagerError>()}),
    ("GtkRecentSortType", Layout {size: size_of::<GtkRecentSortType>(), alignment: align_of::<GtkRecentSortType>()}),
    ("GtkRegionFlags", Layout {size: size_of::<GtkRegionFlags>(), alignment: align_of::<GtkRegionFlags>()}),
    ("GtkReliefStyle", Layout {size: size_of::<GtkReliefStyle>(), alignment: align_of::<GtkReliefStyle>()}),
    ("GtkRendererCellAccessible", Layout {size: size_of::<GtkRendererCellAccessible>(), alignment: align_of::<GtkRendererCellAccessible>()}),
    ("GtkRendererCellAccessibleClass", Layout {size: size_of::<GtkRendererCellAccessibleClass>(), alignment: align_of::<GtkRendererCellAccessibleClass>()}),
    ("GtkRequestedSize", Layout {size: size_of::<GtkRequestedSize>(), alignment: align_of::<GtkRequestedSize>()}),
    ("GtkRequisition", Layout {size: size_of::<GtkRequisition>(), alignment: align_of::<GtkRequisition>()}),
    ("GtkResizeMode", Layout {size: size_of::<GtkResizeMode>(), alignment: align_of::<GtkResizeMode>()}),
    ("GtkResponseType", Layout {size: size_of::<GtkResponseType>(), alignment: align_of::<GtkResponseType>()}),
    ("GtkRevealer", Layout {size: size_of::<GtkRevealer>(), alignment: align_of::<GtkRevealer>()}),
    ("GtkRevealerTransitionType", Layout {size: size_of::<GtkRevealerTransitionType>(), alignment: align_of::<GtkRevealerTransitionType>()}),
    ("GtkScale", Layout {size: size_of::<GtkScale>(), alignment: align_of::<GtkScale>()}),
    ("GtkScaleAccessible", Layout {size: size_of::<GtkScaleAccessible>(), alignment: align_of::<GtkScaleAccessible>()}),
    ("GtkScaleAccessibleClass", Layout {size: size_of::<GtkScaleAccessibleClass>(), alignment: align_of::<GtkScaleAccessibleClass>()}),
    ("GtkScaleButton", Layout {size: size_of::<GtkScaleButton>(), alignment: align_of::<GtkScaleButton>()}),
    ("GtkScaleButtonAccessible", Layout {size: size_of::<GtkScaleButtonAccessible>(), alignment: align_of::<GtkScaleButtonAccessible>()}),
    ("GtkScaleButtonAccessibleClass", Layout {size: size_of::<GtkScaleButtonAccessibleClass>(), alignment: align_of::<GtkScaleButtonAccessibleClass>()}),
    ("GtkScaleClass", Layout {size: size_of::<GtkScaleClass>(), alignment: align_of::<GtkScaleClass>()}),
    ("GtkScrollStep", Layout {size: size_of::<GtkScrollStep>(), alignment: align_of::<GtkScrollStep>()}),
    ("GtkScrollType", Layout {size: size_of::<GtkScrollType>(), alignment: align_of::<GtkScrollType>()}),
    ("GtkScrollableInterface", Layout {size: size_of::<GtkScrollableInterface>(), alignment: align_of::<GtkScrollableInterface>()}),
    ("GtkScrollablePolicy", Layout {size: size_of::<GtkScrollablePolicy>(), alignment: align_of::<GtkScrollablePolicy>()}),
    ("GtkScrollbar", Layout {size: size_of::<GtkScrollbar>(), alignment: align_of::<GtkScrollbar>()}),
    ("GtkScrollbarClass", Layout {size: size_of::<GtkScrollbarClass>(), alignment: align_of::<GtkScrollbarClass>()}),
    ("GtkScrolledWindow", Layout {size: size_of::<GtkScrolledWindow>(), alignment: align_of::<GtkScrolledWindow>()}),
    ("GtkScrolledWindowAccessible", Layout {size: size_of::<GtkScrolledWindowAccessible>(), alignment: align_of::<GtkScrolledWindowAccessible>()}),
    ("GtkScrolledWindowAccessibleClass", Layout {size: size_of::<GtkScrolledWindowAccessibleClass>(), alignment: align_of::<GtkScrolledWindowAccessibleClass>()}),
    ("GtkSearchBar", Layout {size: size_of::<GtkSearchBar>(), alignment: align_of::<GtkSearchBar>()}),
    ("GtkSearchEntry", Layout {size: size_of::<GtkSearchEntry>(), alignment: align_of::<GtkSearchEntry>()}),
    ("GtkSearchEntryClass", Layout {size: size_of::<GtkSearchEntryClass>(), alignment: align_of::<GtkSearchEntryClass>()}),
    ("GtkSelectionMode", Layout {size: size_of::<GtkSelectionMode>(), alignment: align_of::<GtkSelectionMode>()}),
    ("GtkSensitivityType", Layout {size: size_of::<GtkSensitivityType>(), alignment: align_of::<GtkSensitivityType>()}),
    ("GtkSeparator", Layout {size: size_of::<GtkSeparator>(), alignment: align_of::<GtkSeparator>()}),
    ("GtkSeparatorClass", Layout {size: size_of::<GtkSeparatorClass>(), alignment: align_of::<GtkSeparatorClass>()}),
    ("GtkSeparatorMenuItem", Layout {size: size_of::<GtkSeparatorMenuItem>(), alignment: align_of::<GtkSeparatorMenuItem>()}),
    ("GtkSeparatorToolItem", Layout {size: size_of::<GtkSeparatorToolItem>(), alignment: align_of::<GtkSeparatorToolItem>()}),
    ("GtkSettings", Layout {size: size_of::<GtkSettings>(), alignment: align_of::<GtkSettings>()}),
    ("GtkSettingsClass", Layout {size: size_of::<GtkSettingsClass>(), alignment: align_of::<GtkSettingsClass>()}),
    ("GtkSettingsValue", Layout {size: size_of::<GtkSettingsValue>(), alignment: align_of::<GtkSettingsValue>()}),
    ("GtkShadowType", Layout {size: size_of::<GtkShadowType>(), alignment: align_of::<GtkShadowType>()}),
    ("GtkShortcutType", Layout {size: size_of::<GtkShortcutType>(), alignment: align_of::<GtkShortcutType>()}),
    ("GtkShortcutsWindow", Layout {size: size_of::<GtkShortcutsWindow>(), alignment: align_of::<GtkShortcutsWindow>()}),
    ("GtkSizeGroup", Layout {size: size_of::<GtkSizeGroup>(), alignment: align_of::<GtkSizeGroup>()}),
    ("GtkSizeGroupClass", Layout {size: size_of::<GtkSizeGroupClass>(), alignment: align_of::<GtkSizeGroupClass>()}),
    ("GtkSizeGroupMode", Layout {size: size_of::<GtkSizeGroupMode>(), alignment: align_of::<GtkSizeGroupMode>()}),
    ("GtkSizeRequestMode", Layout {size: size_of::<GtkSizeRequestMode>(), alignment: align_of::<GtkSizeRequestMode>()}),
    ("GtkSocket", Layout {size: size_of::<GtkSocket>(), alignment: align_of::<GtkSocket>()}),
    ("GtkSortType", Layout {size: size_of::<GtkSortType>(), alignment: align_of::<GtkSortType>()}),
    ("GtkSpinButton", Layout {size: size_of::<GtkSpinButton>(), alignment: align_of::<GtkSpinButton>()}),
    ("GtkSpinButtonAccessible", Layout {size: size_of::<GtkSpinButtonAccessible>(), alignment: align_of::<GtkSpinButtonAccessible>()}),
    ("GtkSpinButtonAccessibleClass", Layout {size: size_of::<GtkSpinButtonAccessibleClass>(), alignment: align_of::<GtkSpinButtonAccessibleClass>()}),
    ("GtkSpinButtonClass", Layout {size: size_of::<GtkSpinButtonClass>(), alignment: align_of::<GtkSpinButtonClass>()}),
    ("GtkSpinButtonUpdatePolicy", Layout {size: size_of::<GtkSpinButtonUpdatePolicy>(), alignment: align_of::<GtkSpinButtonUpdatePolicy>()}),
    ("GtkSpinType", Layout {size: size_of::<GtkSpinType>(), alignment: align_of::<GtkSpinType>()}),
    ("GtkSpinner", Layout {size: size_of::<GtkSpinner>(), alignment: align_of::<GtkSpinner>()}),
    ("GtkSpinnerAccessible", Layout {size: size_of::<GtkSpinnerAccessible>(), alignment: align_of::<GtkSpinnerAccessible>()}),
    ("GtkSpinnerAccessibleClass", Layout {size: size_of::<GtkSpinnerAccessibleClass>(), alignment: align_of::<GtkSpinnerAccessibleClass>()}),
    ("GtkSpinnerClass", Layout {size: size_of::<GtkSpinnerClass>(), alignment: align_of::<GtkSpinnerClass>()}),
    ("GtkStack", Layout {size: size_of::<GtkStack>(), alignment: align_of::<GtkStack>()}),
    ("GtkStackAccessible", Layout {size: size_of::<GtkStackAccessible>(), alignment: align_of::<GtkStackAccessible>()}),
    ("GtkStackAccessibleClass", Layout {size: size_of::<GtkStackAccessibleClass>(), alignment: align_of::<GtkStackAccessibleClass>()}),
    ("GtkStackSidebar", Layout {size: size_of::<GtkStackSidebar>(), alignment: align_of::<GtkStackSidebar>()}),
    ("GtkStackSwitcher", Layout {size: size_of::<GtkStackSwitcher>(), alignment: align_of::<GtkStackSwitcher>()}),
    ("GtkStackTransitionType", Layout {size: size_of::<GtkStackTransitionType>(), alignment: align_of::<GtkStackTransitionType>()}),
    ("GtkStateFlags", Layout {size: size_of::<GtkStateFlags>(), alignment: align_of::<GtkStateFlags>()}),
    ("GtkStateType", Layout {size: size_of::<GtkStateType>(), alignment: align_of::<GtkStateType>()}),
    ("GtkStatusIcon", Layout {size: size_of::<GtkStatusIcon>(), alignment: align_of::<GtkStatusIcon>()}),
    ("GtkStatusIconClass", Layout {size: size_of::<GtkStatusIconClass>(), alignment: align_of::<GtkStatusIconClass>()}),
    ("GtkStatusbar", Layout {size: size_of::<GtkStatusbar>(), alignment: align_of::<GtkStatusbar>()}),
    ("GtkStatusbarAccessible", Layout {size: size_of::<GtkStatusbarAccessible>(), alignment: align_of::<GtkStatusbarAccessible>()}),
    ("GtkStatusbarAccessibleClass", Layout {size: size_of::<GtkStatusbarAccessibleClass>(), alignment: align_of::<GtkStatusbarAccessibleClass>()}),
    ("GtkStock", Layout {size: size_of::<GtkStock>(), alignment: align_of::<GtkStock>()}),
    ("GtkStockItem", Layout {size: size_of::<GtkStockItem>(), alignment: align_of::<GtkStockItem>()}),
    ("GtkStyleClass", Layout {size: size_of::<GtkStyleClass>(), alignment: align_of::<GtkStyleClass>()}),
    ("GtkStyleContext", Layout {size: size_of::<GtkStyleContext>(), alignment: align_of::<GtkStyleContext>()}),
    ("GtkStyleContextClass", Layout {size: size_of::<GtkStyleContextClass>(), alignment: align_of::<GtkStyleContextClass>()}),
    ("GtkStyleContextPrintFlags", Layout {size: size_of::<GtkStyleContextPrintFlags>(), alignment: align_of::<GtkStyleContextPrintFlags>()}),
    ("GtkStyleProperties", Layout {size: size_of::<GtkStyleProperties>(), alignment: align_of::<GtkStyleProperties>()}),
    ("GtkStylePropertiesClass", Layout {size: size_of::<GtkStylePropertiesClass>(), alignment: align_of::<GtkStylePropertiesClass>()}),
    ("GtkStyleProviderIface", Layout {size: size_of::<GtkStyleProviderIface>(), alignment: align_of::<GtkStyleProviderIface>()}),
    ("GtkSwitch", Layout {size: size_of::<GtkSwitch>(), alignment: align_of::<GtkSwitch>()}),
    ("GtkSwitchAccessible", Layout {size: size_of::<GtkSwitchAccessible>(), alignment: align_of::<GtkSwitchAccessible>()}),
    ("GtkSwitchAccessibleClass", Layout {size: size_of::<GtkSwitchAccessibleClass>(), alignment: align_of::<GtkSwitchAccessibleClass>()}),
    ("GtkSwitchClass", Layout {size: size_of::<GtkSwitchClass>(), alignment: align_of::<GtkSwitchClass>()}),
    ("GtkTable", Layout {size: size_of::<GtkTable>(), alignment: align_of::<GtkTable>()}),
    ("GtkTargetEntry", Layout {size: size_of::<GtkTargetEntry>(), alignment: align_of::<GtkTargetEntry>()}),
    ("GtkTargetFlags", Layout {size: size_of::<GtkTargetFlags>(), alignment: align_of::<GtkTargetFlags>()}),
    ("GtkTargetPair", Layout {size: size_of::<GtkTargetPair>(), alignment: align_of::<GtkTargetPair>()}),
    ("GtkTearoffMenuItem", Layout {size: size_of::<GtkTearoffMenuItem>(), alignment: align_of::<GtkTearoffMenuItem>()}),
    ("GtkTextBuffer", Layout {size: size_of::<GtkTextBuffer>(), alignment: align_of::<GtkTextBuffer>()}),
    ("GtkTextBufferClass", Layout {size: size_of::<GtkTextBufferClass>(), alignment: align_of::<GtkTextBufferClass>()}),
    ("GtkTextBufferTargetInfo", Layout {size: size_of::<GtkTextBufferTargetInfo>(), alignment: align_of::<GtkTextBufferTargetInfo>()}),
    ("GtkTextCellAccessible", Layout {size: size_of::<GtkTextCellAccessible>(), alignment: align_of::<GtkTextCellAccessible>()}),
    ("GtkTextCellAccessibleClass", Layout {size: size_of::<GtkTextCellAccessibleClass>(), alignment: align_of::<GtkTextCellAccessibleClass>()}),
    ("GtkTextChildAnchor", Layout {size: size_of::<GtkTextChildAnchor>(), alignment: align_of::<GtkTextChildAnchor>()}),
    ("GtkTextChildAnchorClass", Layout {size: size_of::<GtkTextChildAnchorClass>(), alignment: align_of::<GtkTextChildAnchorClass>()}),
    ("GtkTextDirection", Layout {size: size_of::<GtkTextDirection>(), alignment: align_of::<GtkTextDirection>()}),
    ("GtkTextExtendSelection", Layout {size: size_of::<GtkTextExtendSelection>(), alignment: align_of::<GtkTextExtendSelection>()}),
    ("GtkTextIter", Layout {size: size_of::<GtkTextIter>(), alignment: align_of::<GtkTextIter>()}),
    ("GtkTextMark", Layout {size: size_of::<GtkTextMark>(), alignment: align_of::<GtkTextMark>()}),
    ("GtkTextMarkClass", Layout {size: size_of::<GtkTextMarkClass>(), alignment: align_of::<GtkTextMarkClass>()}),
    ("GtkTextSearchFlags", Layout {size: size_of::<GtkTextSearchFlags>(), alignment: align_of::<GtkTextSearchFlags>()}),
    ("GtkTextTag", Layout {size: size_of::<GtkTextTag>(), alignment: align_of::<GtkTextTag>()}),
    ("GtkTextTagClass", Layout {size: size_of::<GtkTextTagClass>(), alignment: align_of::<GtkTextTagClass>()}),
    ("GtkTextTagTable", Layout {size: size_of::<GtkTextTagTable>(), alignment: align_of::<GtkTextTagTable>()}),
    ("GtkTextTagTableClass", Layout {size: size_of::<GtkTextTagTableClass>(), alignment: align_of::<GtkTextTagTableClass>()}),
    ("GtkTextView", Layout {size: size_of::<GtkTextView>(), alignment: align_of::<GtkTextView>()}),
    ("GtkTextViewAccessible", Layout {size: size_of::<GtkTextViewAccessible>(), alignment: align_of::<GtkTextViewAccessible>()}),
    ("GtkTextViewAccessibleClass", Layout {size: size_of::<GtkTextViewAccessibleClass>(), alignment: align_of::<GtkTextViewAccessibleClass>()}),
    ("GtkTextViewLayer", Layout {size: size_of::<GtkTextViewLayer>(), alignment: align_of::<GtkTextViewLayer>()}),
    ("GtkTextWindowType", Layout {size: size_of::<GtkTextWindowType>(), alignment: align_of::<GtkTextWindowType>()}),
    ("GtkThemingEngine", Layout {size: size_of::<GtkThemingEngine>(), alignment: align_of::<GtkThemingEngine>()}),
    ("GtkThemingEngineClass", Layout {size: size_of::<GtkThemingEngineClass>(), alignment: align_of::<GtkThemingEngineClass>()}),
    ("GtkToggleAction", Layout {size: size_of::<GtkToggleAction>(), alignment: align_of::<GtkToggleAction>()}),
    ("GtkToggleActionClass", Layout {size: size_of::<GtkToggleActionClass>(), alignment: align_of::<GtkToggleActionClass>()}),
    ("GtkToggleActionEntry", Layout {size: size_of::<GtkToggleActionEntry>(), alignment: align_of::<GtkToggleActionEntry>()}),
    ("GtkToggleButton", Layout {size: size_of::<GtkToggleButton>(), alignment: align_of::<GtkToggleButton>()}),
    ("GtkToggleButtonAccessible", Layout {size: size_of::<GtkToggleButtonAccessible>(), alignment: align_of::<GtkToggleButtonAccessible>()}),
    ("GtkToggleButtonAccessibleClass", Layout {size: size_of::<GtkToggleButtonAccessibleClass>(), alignment: align_of::<GtkToggleButtonAccessibleClass>()}),
    ("GtkToggleToolButton", Layout {size: size_of::<GtkToggleToolButton>(), alignment: align_of::<GtkToggleToolButton>()}),
    ("GtkToolButton", Layout {size: size_of::<GtkToolButton>(), alignment: align_of::<GtkToolButton>()}),
    ("GtkToolItem", Layout {size: size_of::<GtkToolItem>(), alignment: align_of::<GtkToolItem>()}),
    ("GtkToolItemGroup", Layout {size: size_of::<GtkToolItemGroup>(), alignment: align_of::<GtkToolItemGroup>()}),
    ("GtkToolPalette", Layout {size: size_of::<GtkToolPalette>(), alignment: align_of::<GtkToolPalette>()}),
    ("GtkToolPaletteDragTargets", Layout {size: size_of::<GtkToolPaletteDragTargets>(), alignment: align_of::<GtkToolPaletteDragTargets>()}),
    ("GtkToolShellIface", Layout {size: size_of::<GtkToolShellIface>(), alignment: align_of::<GtkToolShellIface>()}),
    ("GtkToolbar", Layout {size: size_of::<GtkToolbar>(), alignment: align_of::<GtkToolbar>()}),
    ("GtkToolbarSpaceStyle", Layout {size: size_of::<GtkToolbarSpaceStyle>(), alignment: align_of::<GtkToolbarSpaceStyle>()}),
    ("GtkToolbarStyle", Layout {size: size_of::<GtkToolbarStyle>(), alignment: align_of::<GtkToolbarStyle>()}),
    ("GtkToplevelAccessible", Layout {size: size_of::<GtkToplevelAccessible>(), alignment: align_of::<GtkToplevelAccessible>()}),
    ("GtkToplevelAccessibleClass", Layout {size: size_of::<GtkToplevelAccessibleClass>(), alignment: align_of::<GtkToplevelAccessibleClass>()}),
    ("GtkTreeDragDestIface", Layout {size: size_of::<GtkTreeDragDestIface>(), alignment: align_of::<GtkTreeDragDestIface>()}),
    ("GtkTreeDragSourceIface", Layout {size: size_of::<GtkTreeDragSourceIface>(), alignment: align_of::<GtkTreeDragSourceIface>()}),
    ("GtkTreeIter", Layout {size: size_of::<GtkTreeIter>(), alignment: align_of::<GtkTreeIter>()}),
    ("GtkTreeModelFilter", Layout {size: size_of::<GtkTreeModelFilter>(), alignment: align_of::<GtkTreeModelFilter>()}),
    ("GtkTreeModelFilterClass", Layout {size: size_of::<GtkTreeModelFilterClass>(), alignment: align_of::<GtkTreeModelFilterClass>()}),
    ("GtkTreeModelFlags", Layout {size: size_of::<GtkTreeModelFlags>(), alignment: align_of::<GtkTreeModelFlags>()}),
    ("GtkTreeModelIface", Layout {size: size_of::<GtkTreeModelIface>(), alignment: align_of::<GtkTreeModelIface>()}),
    ("GtkTreeModelSort", Layout {size: size_of::<GtkTreeModelSort>(), alignment: align_of::<GtkTreeModelSort>()}),
    ("GtkTreeModelSortClass", Layout {size: size_of::<GtkTreeModelSortClass>(), alignment: align_of::<GtkTreeModelSortClass>()}),
    ("GtkTreeSelection", Layout {size: size_of::<GtkTreeSelection>(), alignment: align_of::<GtkTreeSelection>()}),
    ("GtkTreeSelectionClass", Layout {size: size_of::<GtkTreeSelectionClass>(), alignment: align_of::<GtkTreeSelectionClass>()}),
    ("GtkTreeSortableIface", Layout {size: size_of::<GtkTreeSortableIface>(), alignment: align_of::<GtkTreeSortableIface>()}),
    ("GtkTreeStore", Layout {size: size_of::<GtkTreeStore>(), alignment: align_of::<GtkTreeStore>()}),
    ("GtkTreeStoreClass", Layout {size: size_of::<GtkTreeStoreClass>(), alignment: align_of::<GtkTreeStoreClass>()}),
    ("GtkTreeView", Layout {size: size_of::<GtkTreeView>(), alignment: align_of::<GtkTreeView>()}),
    ("GtkTreeViewAccessible", Layout {size: size_of::<GtkTreeViewAccessible>(), alignment: align_of::<GtkTreeViewAccessible>()}),
    ("GtkTreeViewAccessibleClass", Layout {size: size_of::<GtkTreeViewAccessibleClass>(), alignment: align_of::<GtkTreeViewAccessibleClass>()}),
    ("GtkTreeViewColumn", Layout {size: size_of::<GtkTreeViewColumn>(), alignment: align_of::<GtkTreeViewColumn>()}),
    ("GtkTreeViewColumnClass", Layout {size: size_of::<GtkTreeViewColumnClass>(), alignment: align_of::<GtkTreeViewColumnClass>()}),
    ("GtkTreeViewColumnSizing", Layout {size: size_of::<GtkTreeViewColumnSizing>(), alignment: align_of::<GtkTreeViewColumnSizing>()}),
    ("GtkTreeViewDropPosition", Layout {size: size_of::<GtkTreeViewDropPosition>(), alignment: align_of::<GtkTreeViewDropPosition>()}),
    ("GtkTreeViewGridLines", Layout {size: size_of::<GtkTreeViewGridLines>(), alignment: align_of::<GtkTreeViewGridLines>()}),
    ("GtkUIManager", Layout {size: size_of::<GtkUIManager>(), alignment: align_of::<GtkUIManager>()}),
    ("GtkUIManagerClass", Layout {size: size_of::<GtkUIManagerClass>(), alignment: align_of::<GtkUIManagerClass>()}),
    ("GtkUIManagerItemType", Layout {size: size_of::<GtkUIManagerItemType>(), alignment: align_of::<GtkUIManagerItemType>()}),
    ("GtkUnit", Layout {size: size_of::<GtkUnit>(), alignment: align_of::<GtkUnit>()}),
    ("GtkVBox", Layout {size: size_of::<GtkVBox>(), alignment: align_of::<GtkVBox>()}),
    ("GtkVButtonBox", Layout {size: size_of::<GtkVButtonBox>(), alignment: align_of::<GtkVButtonBox>()}),
    ("GtkVPaned", Layout {size: size_of::<GtkVPaned>(), alignment: align_of::<GtkVPaned>()}),
    ("GtkVScale", Layout {size: size_of::<GtkVScale>(), alignment: align_of::<GtkVScale>()}),
    ("GtkVScaleClass", Layout {size: size_of::<GtkVScaleClass>(), alignment: align_of::<GtkVScaleClass>()}),
    ("GtkVScrollbar", Layout {size: size_of::<GtkVScrollbar>(), alignment: align_of::<GtkVScrollbar>()}),
    ("GtkVScrollbarClass", Layout {size: size_of::<GtkVScrollbarClass>(), alignment: align_of::<GtkVScrollbarClass>()}),
    ("GtkVSeparator", Layout {size: size_of::<GtkVSeparator>(), alignment: align_of::<GtkVSeparator>()}),
    ("GtkVSeparatorClass", Layout {size: size_of::<GtkVSeparatorClass>(), alignment: align_of::<GtkVSeparatorClass>()}),
    ("GtkViewport", Layout {size: size_of::<GtkViewport>(), alignment: align_of::<GtkViewport>()}),
    ("GtkVolumeButton", Layout {size: size_of::<GtkVolumeButton>(), alignment: align_of::<GtkVolumeButton>()}),
    ("GtkWidget", Layout {size: size_of::<GtkWidget>(), alignment: align_of::<GtkWidget>()}),
    ("GtkWidgetAccessible", Layout {size: size_of::<GtkWidgetAccessible>(), alignment: align_of::<GtkWidgetAccessible>()}),
    ("GtkWidgetAccessibleClass", Layout {size: size_of::<GtkWidgetAccessibleClass>(), alignment: align_of::<GtkWidgetAccessibleClass>()}),
    ("GtkWidgetClass", Layout {size: size_of::<GtkWidgetClass>(), alignment: align_of::<GtkWidgetClass>()}),
    ("GtkWidgetHelpType", Layout {size: size_of::<GtkWidgetHelpType>(), alignment: align_of::<GtkWidgetHelpType>()}),
    ("GtkWindow", Layout {size: size_of::<GtkWindow>(), alignment: align_of::<GtkWindow>()}),
    ("GtkWindowAccessible", Layout {size: size_of::<GtkWindowAccessible>(), alignment: align_of::<GtkWindowAccessible>()}),
    ("GtkWindowAccessibleClass", Layout {size: size_of::<GtkWindowAccessibleClass>(), alignment: align_of::<GtkWindowAccessibleClass>()}),
    ("GtkWindowGroup", Layout {size: size_of::<GtkWindowGroup>(), alignment: align_of::<GtkWindowGroup>()}),
    ("GtkWindowGroupClass", Layout {size: size_of::<GtkWindowGroupClass>(), alignment: align_of::<GtkWindowGroupClass>()}),
    ("GtkWindowPosition", Layout {size: size_of::<GtkWindowPosition>(), alignment: align_of::<GtkWindowPosition>()}),
    ("GtkWindowType", Layout {size: size_of::<GtkWindowType>(), alignment: align_of::<GtkWindowType>()}),
    ("GtkWrapMode", Layout {size: size_of::<GtkWrapMode>(), alignment: align_of::<GtkWrapMode>()}),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("GTK_ACCEL_LOCKED", "2"),
    ("GTK_ACCEL_MASK", "7"),
    ("GTK_ACCEL_VISIBLE", "1"),
    ("GTK_ALIGN_BASELINE", "4"),
    ("GTK_ALIGN_CENTER", "3"),
    ("GTK_ALIGN_END", "2"),
    ("GTK_ALIGN_FILL", "0"),
    ("GTK_ALIGN_START", "1"),
    ("GTK_APPLICATION_INHIBIT_IDLE", "8"),
    ("GTK_APPLICATION_INHIBIT_LOGOUT", "1"),
    ("GTK_APPLICATION_INHIBIT_SUSPEND", "4"),
    ("GTK_APPLICATION_INHIBIT_SWITCH", "2"),
    ("GTK_ARROWS_BOTH", "0"),
    ("GTK_ARROWS_END", "2"),
    ("GTK_ARROWS_START", "1"),
    ("GTK_ARROW_DOWN", "1"),
    ("GTK_ARROW_LEFT", "2"),
    ("GTK_ARROW_NONE", "4"),
    ("GTK_ARROW_RIGHT", "3"),
    ("GTK_ARROW_UP", "0"),
    ("GTK_ASSISTANT_PAGE_CONFIRM", "2"),
    ("GTK_ASSISTANT_PAGE_CONTENT", "0"),
    ("GTK_ASSISTANT_PAGE_CUSTOM", "5"),
    ("GTK_ASSISTANT_PAGE_INTRO", "1"),
    ("GTK_ASSISTANT_PAGE_PROGRESS", "4"),
    ("GTK_ASSISTANT_PAGE_SUMMARY", "3"),
    ("GTK_BASELINE_POSITION_BOTTOM", "2"),
    ("GTK_BASELINE_POSITION_CENTER", "1"),
    ("GTK_BASELINE_POSITION_TOP", "0"),
    ("GTK_BORDER_STYLE_DASHED", "6"),
    ("GTK_BORDER_STYLE_DOTTED", "5"),
    ("GTK_BORDER_STYLE_DOUBLE", "7"),
    ("GTK_BORDER_STYLE_GROOVE", "8"),
    ("GTK_BORDER_STYLE_HIDDEN", "4"),
    ("GTK_BORDER_STYLE_INSET", "2"),
    ("GTK_BORDER_STYLE_NONE", "0"),
    ("GTK_BORDER_STYLE_OUTSET", "3"),
    ("GTK_BORDER_STYLE_RIDGE", "9"),
    ("GTK_BORDER_STYLE_SOLID", "1"),
    ("GTK_BUILDER_ERROR_DUPLICATE_ID", "8"),
    ("GTK_BUILDER_ERROR_INVALID_ATTRIBUTE", "3"),
    ("GTK_BUILDER_ERROR_INVALID_ID", "13"),
    ("GTK_BUILDER_ERROR_INVALID_PROPERTY", "11"),
    ("GTK_BUILDER_ERROR_INVALID_SIGNAL", "12"),
    ("GTK_BUILDER_ERROR_INVALID_TAG", "4"),
    ("GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION", "0"),
    ("GTK_BUILDER_ERROR_INVALID_VALUE", "6"),
    ("GTK_BUILDER_ERROR_MISSING_ATTRIBUTE", "2"),
    ("GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE", "5"),
    ("GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED", "9"),
    ("GTK_BUILDER_ERROR_TEMPLATE_MISMATCH", "10"),
    ("GTK_BUILDER_ERROR_UNHANDLED_TAG", "1"),
    ("GTK_BUILDER_ERROR_VERSION_MISMATCH", "7"),
    ("GTK_BUTTONBOX_CENTER", "5"),
    ("GTK_BUTTONBOX_EDGE", "2"),
    ("GTK_BUTTONBOX_END", "4"),
    ("GTK_BUTTONBOX_EXPAND", "6"),
    ("GTK_BUTTONBOX_SPREAD", "1"),
    ("GTK_BUTTONBOX_START", "3"),
    ("GTK_BUTTONS_CANCEL", "3"),
    ("GTK_BUTTONS_CLOSE", "2"),
    ("GTK_BUTTONS_NONE", "0"),
    ("GTK_BUTTONS_OK", "1"),
    ("GTK_BUTTONS_OK_CANCEL", "5"),
    ("GTK_BUTTONS_YES_NO", "4"),
    ("GTK_BUTTON_ROLE_CHECK", "1"),
    ("GTK_BUTTON_ROLE_NORMAL", "0"),
    ("GTK_BUTTON_ROLE_RADIO", "2"),
    ("GTK_CALENDAR_NO_MONTH_CHANGE", "4"),
    ("GTK_CALENDAR_SHOW_DAY_NAMES", "2"),
    ("GTK_CALENDAR_SHOW_DETAILS", "32"),
    ("GTK_CALENDAR_SHOW_HEADING", "1"),
    ("GTK_CALENDAR_SHOW_WEEK_NUMBERS", "8"),
    ("GTK_CELL_RENDERER_ACCEL_MODE_GTK", "0"),
    ("GTK_CELL_RENDERER_ACCEL_MODE_MODIFIER_TAP", "2"),
    ("GTK_CELL_RENDERER_ACCEL_MODE_OTHER", "1"),
    ("GTK_CELL_RENDERER_EXPANDABLE", "32"),
    ("GTK_CELL_RENDERER_EXPANDED", "64"),
    ("GTK_CELL_RENDERER_FOCUSED", "16"),
    ("GTK_CELL_RENDERER_INSENSITIVE", "4"),
    ("GTK_CELL_RENDERER_MODE_ACTIVATABLE", "1"),
    ("GTK_CELL_RENDERER_MODE_EDITABLE", "2"),
    ("GTK_CELL_RENDERER_MODE_INERT", "0"),
    ("GTK_CELL_RENDERER_PRELIT", "2"),
    ("GTK_CELL_RENDERER_SELECTED", "1"),
    ("GTK_CELL_RENDERER_SORTED", "8"),
    ("GTK_CORNER_BOTTOM_LEFT", "1"),
    ("GTK_CORNER_BOTTOM_RIGHT", "3"),
    ("GTK_CORNER_TOP_LEFT", "0"),
    ("GTK_CORNER_TOP_RIGHT", "2"),
    ("GTK_CSS_PROVIDER_ERROR_DEPRECATED", "4"),
    ("GTK_CSS_PROVIDER_ERROR_FAILED", "0"),
    ("GTK_CSS_PROVIDER_ERROR_IMPORT", "2"),
    ("GTK_CSS_PROVIDER_ERROR_NAME", "3"),
    ("GTK_CSS_PROVIDER_ERROR_SYNTAX", "1"),
    ("GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE", "5"),
    ("GTK_CSS_SECTION_BINDING_SET", "3"),
    ("GTK_CSS_SECTION_COLOR_DEFINITION", "2"),
    ("GTK_CSS_SECTION_DECLARATION", "6"),
    ("GTK_CSS_SECTION_DOCUMENT", "0"),
    ("GTK_CSS_SECTION_IMPORT", "1"),
    ("GTK_CSS_SECTION_KEYFRAMES", "8"),
    ("GTK_CSS_SECTION_RULESET", "4"),
    ("GTK_CSS_SECTION_SELECTOR", "5"),
    ("GTK_CSS_SECTION_VALUE", "7"),
    ("GTK_DEBUG_ACTIONS", "524288"),
    ("GTK_DEBUG_BASELINES", "16384"),
    ("GTK_DEBUG_BUILDER", "2048"),
    ("GTK_DEBUG_GEOMETRY", "256"),
    ("GTK_DEBUG_ICONTHEME", "512"),
    ("GTK_DEBUG_INTERACTIVE", "131072"),
    ("GTK_DEBUG_KEYBINDINGS", "32"),
    ("GTK_DEBUG_LAYOUT", "2097152"),
    ("GTK_DEBUG_MISC", "1"),
    ("GTK_DEBUG_MODULES", "128"),
    ("GTK_DEBUG_MULTIHEAD", "64"),
    ("GTK_DEBUG_NO_CSS_CACHE", "8192"),
    ("GTK_DEBUG_NO_PIXEL_CACHE", "65536"),
    ("GTK_DEBUG_PIXEL_CACHE", "32768"),
    ("GTK_DEBUG_PLUGSOCKET", "2"),
    ("GTK_DEBUG_PRINTING", "1024"),
    ("GTK_DEBUG_RESIZE", "1048576"),
    ("GTK_DEBUG_SIZE_REQUEST", "4096"),
    ("GTK_DEBUG_TEXT", "4"),
    ("GTK_DEBUG_TOUCHSCREEN", "262144"),
    ("GTK_DEBUG_TREE", "8"),
    ("GTK_DEBUG_UPDATES", "16"),
    ("GTK_DELETE_CHARS", "0"),
    ("GTK_DELETE_DISPLAY_LINES", "3"),
    ("GTK_DELETE_DISPLAY_LINE_ENDS", "4"),
    ("GTK_DELETE_PARAGRAPHS", "6"),
    ("GTK_DELETE_PARAGRAPH_ENDS", "5"),
    ("GTK_DELETE_WHITESPACE", "7"),
    ("GTK_DELETE_WORDS", "2"),
    ("GTK_DELETE_WORD_ENDS", "1"),
    ("GTK_DEST_DEFAULT_ALL", "7"),
    ("GTK_DEST_DEFAULT_DROP", "4"),
    ("GTK_DEST_DEFAULT_HIGHLIGHT", "2"),
    ("GTK_DEST_DEFAULT_MOTION", "1"),
    ("GTK_DIALOG_DESTROY_WITH_PARENT", "2"),
    ("GTK_DIALOG_MODAL", "1"),
    ("GTK_DIALOG_USE_HEADER_BAR", "4"),
    ("GTK_DIR_DOWN", "3"),
    ("GTK_DIR_LEFT", "4"),
    ("GTK_DIR_RIGHT", "5"),
    ("GTK_DIR_TAB_BACKWARD", "1"),
    ("GTK_DIR_TAB_FORWARD", "0"),
    ("GTK_DIR_UP", "2"),
    ("GTK_DRAG_RESULT_ERROR", "5"),
    ("GTK_DRAG_RESULT_GRAB_BROKEN", "4"),
    ("GTK_DRAG_RESULT_NO_TARGET", "1"),
    ("GTK_DRAG_RESULT_SUCCESS", "0"),
    ("GTK_DRAG_RESULT_TIMEOUT_EXPIRED", "3"),
    ("GTK_DRAG_RESULT_USER_CANCELLED", "2"),
    ("GTK_ENTRY_ICON_PRIMARY", "0"),
    ("GTK_ENTRY_ICON_SECONDARY", "1"),
    ("GTK_EVENT_SEQUENCE_CLAIMED", "1"),
    ("GTK_EVENT_SEQUENCE_DENIED", "2"),
    ("GTK_EVENT_SEQUENCE_NONE", "0"),
    ("GTK_EXPAND", "1"),
    ("GTK_EXPANDER_COLLAPSED", "0"),
    ("GTK_EXPANDER_EXPANDED", "3"),
    ("GTK_EXPANDER_SEMI_COLLAPSED", "1"),
    ("GTK_EXPANDER_SEMI_EXPANDED", "2"),
    ("GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER", "3"),
    ("GTK_FILE_CHOOSER_ACTION_OPEN", "0"),
    ("GTK_FILE_CHOOSER_ACTION_SAVE", "1"),
    ("GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER", "2"),
    ("GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME", "1"),
    ("GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM", "0"),
    ("GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN", "2"),
    ("GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS", "2"),
    ("GTK_FILE_CHOOSER_ERROR_BAD_FILENAME", "1"),
    ("GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME", "3"),
    ("GTK_FILE_CHOOSER_ERROR_NONEXISTENT", "0"),
    ("GTK_FILE_FILTER_DISPLAY_NAME", "4"),
    ("GTK_FILE_FILTER_FILENAME", "1"),
    ("GTK_FILE_FILTER_MIME_TYPE", "8"),
    ("GTK_FILE_FILTER_URI", "2"),
    ("GTK_FILL", "4"),
    ("GTK_ICON_LOOKUP_DIR_LTR", "128"),
    ("GTK_ICON_LOOKUP_DIR_RTL", "256"),
    ("GTK_ICON_LOOKUP_FORCE_REGULAR", "32"),
    ("GTK_ICON_LOOKUP_FORCE_SIZE", "16"),
    ("GTK_ICON_LOOKUP_FORCE_SVG", "2"),
    ("GTK_ICON_LOOKUP_FORCE_SYMBOLIC", "64"),
    ("GTK_ICON_LOOKUP_GENERIC_FALLBACK", "8"),
    ("GTK_ICON_LOOKUP_NO_SVG", "1"),
    ("GTK_ICON_LOOKUP_USE_BUILTIN", "4"),
    ("GTK_ICON_SIZE_BUTTON", "4"),
    ("GTK_ICON_SIZE_DIALOG", "6"),
    ("GTK_ICON_SIZE_DND", "5"),
    ("GTK_ICON_SIZE_INVALID", "0"),
    ("GTK_ICON_SIZE_LARGE_TOOLBAR", "3"),
    ("GTK_ICON_SIZE_MENU", "1"),
    ("GTK_ICON_SIZE_SMALL_TOOLBAR", "2"),
    ("GTK_ICON_THEME_FAILED", "1"),
    ("GTK_ICON_THEME_NOT_FOUND", "0"),
    ("GTK_ICON_VIEW_DROP_ABOVE", "4"),
    ("GTK_ICON_VIEW_DROP_BELOW", "5"),
    ("GTK_ICON_VIEW_DROP_INTO", "1"),
    ("GTK_ICON_VIEW_DROP_LEFT", "2"),
    ("GTK_ICON_VIEW_DROP_RIGHT", "3"),
    ("GTK_ICON_VIEW_NO_DROP", "0"),
    ("GTK_IMAGE_ANIMATION", "4"),
    ("GTK_IMAGE_EMPTY", "0"),
    ("GTK_IMAGE_GICON", "6"),
    ("GTK_IMAGE_ICON_NAME", "5"),
    ("GTK_IMAGE_ICON_SET", "3"),
    ("GTK_IMAGE_PIXBUF", "1"),
    ("GTK_IMAGE_STOCK", "2"),
    ("GTK_IMAGE_SURFACE", "7"),
    ("GTK_IM_PREEDIT_CALLBACK", "1"),
    ("GTK_IM_PREEDIT_NONE", "2"),
    ("GTK_IM_PREEDIT_NOTHING", "0"),
    ("GTK_IM_STATUS_CALLBACK", "1"),
    ("GTK_IM_STATUS_NONE", "2"),
    ("GTK_IM_STATUS_NOTHING", "0"),
    ("GTK_INPUT_ERROR", "-1"),
    ("GTK_INPUT_HINT_EMOJI", "512"),
    ("GTK_INPUT_HINT_INHIBIT_OSK", "128"),
    ("GTK_INPUT_HINT_LOWERCASE", "8"),
    ("GTK_INPUT_HINT_NONE", "0"),
    ("GTK_INPUT_HINT_NO_EMOJI", "1024"),
    ("GTK_INPUT_HINT_NO_SPELLCHECK", "2"),
    ("GTK_INPUT_HINT_SPELLCHECK", "1"),
    ("GTK_INPUT_HINT_UPPERCASE_CHARS", "16"),
    ("GTK_INPUT_HINT_UPPERCASE_SENTENCES", "64"),
    ("GTK_INPUT_HINT_UPPERCASE_WORDS", "32"),
    ("GTK_INPUT_HINT_VERTICAL_WRITING", "256"),
    ("GTK_INPUT_HINT_WORD_COMPLETION", "4"),
    ("GTK_INPUT_PURPOSE_ALPHA", "1"),
    ("GTK_INPUT_PURPOSE_DIGITS", "2"),
    ("GTK_INPUT_PURPOSE_EMAIL", "6"),
    ("GTK_INPUT_PURPOSE_FREE_FORM", "0"),
    ("GTK_INPUT_PURPOSE_NAME", "7"),
    ("GTK_INPUT_PURPOSE_NUMBER", "3"),
    ("GTK_INPUT_PURPOSE_PASSWORD", "8"),
    ("GTK_INPUT_PURPOSE_PHONE", "4"),
    ("GTK_INPUT_PURPOSE_PIN", "9"),
    ("GTK_INPUT_PURPOSE_URL", "5"),
    ("GTK_JUNCTION_BOTTOM", "12"),
    ("GTK_JUNCTION_CORNER_BOTTOMLEFT", "4"),
    ("GTK_JUNCTION_CORNER_BOTTOMRIGHT", "8"),
    ("GTK_JUNCTION_CORNER_TOPLEFT", "1"),
    ("GTK_JUNCTION_CORNER_TOPRIGHT", "2"),
    ("GTK_JUNCTION_LEFT", "5"),
    ("GTK_JUNCTION_NONE", "0"),
    ("GTK_JUNCTION_RIGHT", "10"),
    ("GTK_JUNCTION_TOP", "3"),
    ("GTK_JUSTIFY_CENTER", "2"),
    ("GTK_JUSTIFY_FILL", "3"),
    ("GTK_JUSTIFY_LEFT", "0"),
    ("GTK_JUSTIFY_RIGHT", "1"),
    ("GTK_LEVEL_BAR_MODE_CONTINUOUS", "0"),
    ("GTK_LEVEL_BAR_MODE_DISCRETE", "1"),
    ("GTK_LEVEL_BAR_OFFSET_FULL", "full"),
    ("GTK_LEVEL_BAR_OFFSET_HIGH", "high"),
    ("GTK_LEVEL_BAR_OFFSET_LOW", "low"),
    ("GTK_LICENSE_AGPL_3_0", "13"),
    ("GTK_LICENSE_AGPL_3_0_ONLY", "14"),
    ("GTK_LICENSE_ARTISTIC", "8"),
    ("GTK_LICENSE_BSD", "6"),
    ("GTK_LICENSE_CUSTOM", "1"),
    ("GTK_LICENSE_GPL_2_0", "2"),
    ("GTK_LICENSE_GPL_2_0_ONLY", "9"),
    ("GTK_LICENSE_GPL_3_0", "3"),
    ("GTK_LICENSE_GPL_3_0_ONLY", "10"),
    ("GTK_LICENSE_LGPL_2_1", "4"),
    ("GTK_LICENSE_LGPL_2_1_ONLY", "11"),
    ("GTK_LICENSE_LGPL_3_0", "5"),
    ("GTK_LICENSE_LGPL_3_0_ONLY", "12"),
    ("GTK_LICENSE_MIT_X11", "7"),
    ("GTK_LICENSE_UNKNOWN", "0"),
    ("GTK_MAX_COMPOSE_LEN", "7"),
    ("GTK_MENU_DIR_CHILD", "1"),
    ("GTK_MENU_DIR_NEXT", "2"),
    ("GTK_MENU_DIR_PARENT", "0"),
    ("GTK_MENU_DIR_PREV", "3"),
    ("GTK_MESSAGE_ERROR", "3"),
    ("GTK_MESSAGE_INFO", "0"),
    ("GTK_MESSAGE_OTHER", "4"),
    ("GTK_MESSAGE_QUESTION", "2"),
    ("GTK_MESSAGE_WARNING", "1"),
    ("GTK_MOVEMENT_BUFFER_ENDS", "8"),
    ("GTK_MOVEMENT_DISPLAY_LINES", "3"),
    ("GTK_MOVEMENT_DISPLAY_LINE_ENDS", "4"),
    ("GTK_MOVEMENT_HORIZONTAL_PAGES", "9"),
    ("GTK_MOVEMENT_LOGICAL_POSITIONS", "0"),
    ("GTK_MOVEMENT_PAGES", "7"),
    ("GTK_MOVEMENT_PARAGRAPHS", "5"),
    ("GTK_MOVEMENT_PARAGRAPH_ENDS", "6"),
    ("GTK_MOVEMENT_VISUAL_POSITIONS", "1"),
    ("GTK_MOVEMENT_WORDS", "2"),
    ("GTK_NOTEBOOK_TAB_FIRST", "0"),
    ("GTK_NOTEBOOK_TAB_LAST", "1"),
    ("GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT", "6"),
    ("GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT", "7"),
    ("GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP", "1"),
    ("GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM", "0"),
    ("GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP", "3"),
    ("GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM", "2"),
    ("GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT", "4"),
    ("GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT", "5"),
    ("GTK_ORIENTATION_HORIZONTAL", "0"),
    ("GTK_ORIENTATION_VERTICAL", "1"),
    ("GTK_PACK_DIRECTION_BTT", "3"),
    ("GTK_PACK_DIRECTION_LTR", "0"),
    ("GTK_PACK_DIRECTION_RTL", "1"),
    ("GTK_PACK_DIRECTION_TTB", "2"),
    ("GTK_PACK_END", "1"),
    ("GTK_PACK_START", "0"),
    ("GTK_PAD_ACTION_BUTTON", "0"),
    ("GTK_PAD_ACTION_RING", "1"),
    ("GTK_PAD_ACTION_STRIP", "2"),
    ("GTK_PAGE_ORIENTATION_LANDSCAPE", "1"),
    ("GTK_PAGE_ORIENTATION_PORTRAIT", "0"),
    ("GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE", "3"),
    ("GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT", "2"),
    ("GTK_PAGE_SET_ALL", "0"),
    ("GTK_PAGE_SET_EVEN", "1"),
    ("GTK_PAGE_SET_ODD", "2"),
    ("GTK_PAN_DIRECTION_DOWN", "3"),
    ("GTK_PAN_DIRECTION_LEFT", "0"),
    ("GTK_PAN_DIRECTION_RIGHT", "1"),
    ("GTK_PAN_DIRECTION_UP", "2"),
    ("GTK_PAPER_NAME_A3", "iso_a3"),
    ("GTK_PAPER_NAME_A4", "iso_a4"),
    ("GTK_PAPER_NAME_A5", "iso_a5"),
    ("GTK_PAPER_NAME_B5", "iso_b5"),
    ("GTK_PAPER_NAME_EXECUTIVE", "na_executive"),
    ("GTK_PAPER_NAME_LEGAL", "na_legal"),
    ("GTK_PAPER_NAME_LETTER", "na_letter"),
    ("GTK_PATH_CLASS", "2"),
    ("GTK_PATH_PRIO_APPLICATION", "8"),
    ("GTK_PATH_PRIO_GTK", "4"),
    ("GTK_PATH_PRIO_HIGHEST", "15"),
    ("GTK_PATH_PRIO_LOWEST", "0"),
    ("GTK_PATH_PRIO_MASK", "15"),
    ("GTK_PATH_PRIO_RC", "12"),
    ("GTK_PATH_PRIO_THEME", "10"),
    ("GTK_PATH_WIDGET", "0"),
    ("GTK_PATH_WIDGET_CLASS", "1"),
    ("GTK_PHASE_BUBBLE", "2"),
    ("GTK_PHASE_CAPTURE", "1"),
    ("GTK_PHASE_NONE", "0"),
    ("GTK_PHASE_TARGET", "3"),
    ("GTK_PLACES_OPEN_NEW_TAB", "2"),
    ("GTK_PLACES_OPEN_NEW_WINDOW", "4"),
    ("GTK_PLACES_OPEN_NORMAL", "1"),
    ("GTK_POLICY_ALWAYS", "0"),
    ("GTK_POLICY_AUTOMATIC", "1"),
    ("GTK_POLICY_EXTERNAL", "3"),
    ("GTK_POLICY_NEVER", "2"),
    ("GTK_POPOVER_CONSTRAINT_NONE", "0"),
    ("GTK_POPOVER_CONSTRAINT_WINDOW", "1"),
    ("GTK_POS_BOTTOM", "3"),
    ("GTK_POS_LEFT", "0"),
    ("GTK_POS_RIGHT", "1"),
    ("GTK_POS_TOP", "2"),
    ("GTK_PRINT_DUPLEX_HORIZONTAL", "1"),
    ("GTK_PRINT_DUPLEX_SIMPLEX", "0"),
    ("GTK_PRINT_DUPLEX_VERTICAL", "2"),
    ("GTK_PRINT_ERROR_GENERAL", "0"),
    ("GTK_PRINT_ERROR_INTERNAL_ERROR", "1"),
    ("GTK_PRINT_ERROR_INVALID_FILE", "3"),
    ("GTK_PRINT_ERROR_NOMEM", "2"),
    ("GTK_PRINT_OPERATION_ACTION_EXPORT", "3"),
    ("GTK_PRINT_OPERATION_ACTION_PREVIEW", "2"),
    ("GTK_PRINT_OPERATION_ACTION_PRINT", "1"),
    ("GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG", "0"),
    ("GTK_PRINT_OPERATION_RESULT_APPLY", "1"),
    ("GTK_PRINT_OPERATION_RESULT_CANCEL", "2"),
    ("GTK_PRINT_OPERATION_RESULT_ERROR", "0"),
    ("GTK_PRINT_OPERATION_RESULT_IN_PROGRESS", "3"),
    ("GTK_PRINT_PAGES_ALL", "0"),
    ("GTK_PRINT_PAGES_CURRENT", "1"),
    ("GTK_PRINT_PAGES_RANGES", "2"),
    ("GTK_PRINT_PAGES_SELECTION", "3"),
    ("GTK_PRINT_QUALITY_DRAFT", "3"),
    ("GTK_PRINT_QUALITY_HIGH", "2"),
    ("GTK_PRINT_QUALITY_LOW", "0"),
    ("GTK_PRINT_QUALITY_NORMAL", "1"),
    ("GTK_PRINT_SETTINGS_COLLATE", "collate"),
    ("GTK_PRINT_SETTINGS_DEFAULT_SOURCE", "default-source"),
    ("GTK_PRINT_SETTINGS_DITHER", "dither"),
    ("GTK_PRINT_SETTINGS_DUPLEX", "duplex"),
    ("GTK_PRINT_SETTINGS_FINISHINGS", "finishings"),
    ("GTK_PRINT_SETTINGS_MEDIA_TYPE", "media-type"),
    ("GTK_PRINT_SETTINGS_NUMBER_UP", "number-up"),
    ("GTK_PRINT_SETTINGS_NUMBER_UP_LAYOUT", "number-up-layout"),
    ("GTK_PRINT_SETTINGS_N_COPIES", "n-copies"),
    ("GTK_PRINT_SETTINGS_ORIENTATION", "orientation"),
    ("GTK_PRINT_SETTINGS_OUTPUT_BASENAME", "output-basename"),
    ("GTK_PRINT_SETTINGS_OUTPUT_BIN", "output-bin"),
    ("GTK_PRINT_SETTINGS_OUTPUT_DIR", "output-dir"),
    ("GTK_PRINT_SETTINGS_OUTPUT_FILE_FORMAT", "output-file-format"),
    ("GTK_PRINT_SETTINGS_OUTPUT_URI", "output-uri"),
    ("GTK_PRINT_SETTINGS_PAGE_RANGES", "page-ranges"),
    ("GTK_PRINT_SETTINGS_PAGE_SET", "page-set"),
    ("GTK_PRINT_SETTINGS_PAPER_FORMAT", "paper-format"),
    ("GTK_PRINT_SETTINGS_PAPER_HEIGHT", "paper-height"),
    ("GTK_PRINT_SETTINGS_PAPER_WIDTH", "paper-width"),
    ("GTK_PRINT_SETTINGS_PRINTER", "printer"),
    ("GTK_PRINT_SETTINGS_PRINTER_LPI", "printer-lpi"),
    ("GTK_PRINT_SETTINGS_PRINT_PAGES", "print-pages"),
    ("GTK_PRINT_SETTINGS_QUALITY", "quality"),
    ("GTK_PRINT_SETTINGS_RESOLUTION", "resolution"),
    ("GTK_PRINT_SETTINGS_RESOLUTION_X", "resolution-x"),
    ("GTK_PRINT_SETTINGS_RESOLUTION_Y", "resolution-y"),
    ("GTK_PRINT_SETTINGS_REVERSE", "reverse"),
    ("GTK_PRINT_SETTINGS_SCALE", "scale"),
    ("GTK_PRINT_SETTINGS_USE_COLOR", "use-color"),
    ("GTK_PRINT_SETTINGS_WIN32_DRIVER_EXTRA", "win32-driver-extra"),
    ("GTK_PRINT_SETTINGS_WIN32_DRIVER_VERSION", "win32-driver-version"),
    ("GTK_PRINT_STATUS_FINISHED", "7"),
    ("GTK_PRINT_STATUS_FINISHED_ABORTED", "8"),
    ("GTK_PRINT_STATUS_GENERATING_DATA", "2"),
    ("GTK_PRINT_STATUS_INITIAL", "0"),
    ("GTK_PRINT_STATUS_PENDING", "4"),
    ("GTK_PRINT_STATUS_PENDING_ISSUE", "5"),
    ("GTK_PRINT_STATUS_PREPARING", "1"),
    ("GTK_PRINT_STATUS_PRINTING", "6"),
    ("GTK_PRINT_STATUS_SENDING_DATA", "3"),
    ("GTK_PRIORITY_RESIZE", "10"),
    ("GTK_RC_BASE", "8"),
    ("GTK_RC_BG", "2"),
    ("GTK_RC_FG", "1"),
    ("GTK_RC_TEXT", "4"),
    ("GTK_RC_TOKEN_ACTIVE", "273"),
    ("GTK_RC_TOKEN_APPLICATION", "296"),
    ("GTK_RC_TOKEN_BASE", "280"),
    ("GTK_RC_TOKEN_BG", "278"),
    ("GTK_RC_TOKEN_BG_PIXMAP", "286"),
    ("GTK_RC_TOKEN_BIND", "290"),
    ("GTK_RC_TOKEN_BINDING", "289"),
    ("GTK_RC_TOKEN_CLASS", "293"),
    ("GTK_RC_TOKEN_COLOR", "307"),
    ("GTK_RC_TOKEN_ENGINE", "300"),
    ("GTK_RC_TOKEN_FG", "277"),
    ("GTK_RC_TOKEN_FONT", "283"),
    ("GTK_RC_TOKEN_FONTSET", "284"),
    ("GTK_RC_TOKEN_FONT_NAME", "285"),
    ("GTK_RC_TOKEN_GTK", "295"),
    ("GTK_RC_TOKEN_HIGHEST", "299"),
    ("GTK_RC_TOKEN_IM_MODULE_FILE", "303"),
    ("GTK_RC_TOKEN_IM_MODULE_PATH", "302"),
    ("GTK_RC_TOKEN_INCLUDE", "271"),
    ("GTK_RC_TOKEN_INSENSITIVE", "276"),
    ("GTK_RC_TOKEN_INVALID", "270"),
    ("GTK_RC_TOKEN_LAST", "309"),
    ("GTK_RC_TOKEN_LOWEST", "294"),
    ("GTK_RC_TOKEN_LTR", "305"),
    ("GTK_RC_TOKEN_MODULE_PATH", "301"),
    ("GTK_RC_TOKEN_NORMAL", "272"),
    ("GTK_RC_TOKEN_PIXMAP_PATH", "287"),
    ("GTK_RC_TOKEN_PRELIGHT", "274"),
    ("GTK_RC_TOKEN_RC", "298"),
    ("GTK_RC_TOKEN_RTL", "306"),
    ("GTK_RC_TOKEN_SELECTED", "275"),
    ("GTK_RC_TOKEN_STOCK", "304"),
    ("GTK_RC_TOKEN_STYLE", "288"),
    ("GTK_RC_TOKEN_TEXT", "279"),
    ("GTK_RC_TOKEN_THEME", "297"),
    ("GTK_RC_TOKEN_UNBIND", "308"),
    ("GTK_RC_TOKEN_WIDGET", "291"),
    ("GTK_RC_TOKEN_WIDGET_CLASS", "292"),
    ("GTK_RC_TOKEN_XTHICKNESS", "281"),
    ("GTK_RC_TOKEN_YTHICKNESS", "282"),
    ("GTK_RECENT_CHOOSER_ERROR_INVALID_URI", "1"),
    ("GTK_RECENT_CHOOSER_ERROR_NOT_FOUND", "0"),
    ("GTK_RECENT_FILTER_AGE", "32"),
    ("GTK_RECENT_FILTER_APPLICATION", "8"),
    ("GTK_RECENT_FILTER_DISPLAY_NAME", "2"),
    ("GTK_RECENT_FILTER_GROUP", "16"),
    ("GTK_RECENT_FILTER_MIME_TYPE", "4"),
    ("GTK_RECENT_FILTER_URI", "1"),
    ("GTK_RECENT_MANAGER_ERROR_INVALID_ENCODING", "2"),
    ("GTK_RECENT_MANAGER_ERROR_INVALID_URI", "1"),
    ("GTK_RECENT_MANAGER_ERROR_NOT_FOUND", "0"),
    ("GTK_RECENT_MANAGER_ERROR_NOT_REGISTERED", "3"),
    ("GTK_RECENT_MANAGER_ERROR_READ", "4"),
    ("GTK_RECENT_MANAGER_ERROR_UNKNOWN", "6"),
    ("GTK_RECENT_MANAGER_ERROR_WRITE", "5"),
    ("GTK_RECENT_SORT_CUSTOM", "3"),
    ("GTK_RECENT_SORT_LRU", "2"),
    ("GTK_RECENT_SORT_MRU", "1"),
    ("GTK_RECENT_SORT_NONE", "0"),
    ("GTK_REGION_EVEN", "1"),
    ("GTK_REGION_FIRST", "4"),
    ("GTK_REGION_LAST", "8"),
    ("GTK_REGION_ODD", "2"),
    ("GTK_REGION_ONLY", "16"),
    ("GTK_REGION_SORTED", "32"),
    ("GTK_RELIEF_HALF", "1"),
    ("GTK_RELIEF_NONE", "2"),
    ("GTK_RELIEF_NORMAL", "0"),
    ("GTK_RESIZE_IMMEDIATE", "2"),
    ("GTK_RESIZE_PARENT", "0"),
    ("GTK_RESIZE_QUEUE", "1"),
    ("GTK_RESPONSE_ACCEPT", "-3"),
    ("GTK_RESPONSE_APPLY", "-10"),
    ("GTK_RESPONSE_CANCEL", "-6"),
    ("GTK_RESPONSE_CLOSE", "-7"),
    ("GTK_RESPONSE_DELETE_EVENT", "-4"),
    ("GTK_RESPONSE_HELP", "-11"),
    ("GTK_RESPONSE_NO", "-9"),
    ("GTK_RESPONSE_NONE", "-1"),
    ("GTK_RESPONSE_OK", "-5"),
    ("GTK_RESPONSE_REJECT", "-2"),
    ("GTK_RESPONSE_YES", "-8"),
    ("GTK_REVEALER_TRANSITION_TYPE_CROSSFADE", "1"),
    ("GTK_REVEALER_TRANSITION_TYPE_NONE", "0"),
    ("GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN", "5"),
    ("GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT", "3"),
    ("GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT", "2"),
    ("GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP", "4"),
    ("GTK_SCROLL_END", "15"),
    ("GTK_SCROLL_ENDS", "2"),
    ("GTK_SCROLL_HORIZONTAL_ENDS", "5"),
    ("GTK_SCROLL_HORIZONTAL_PAGES", "4"),
    ("GTK_SCROLL_HORIZONTAL_STEPS", "3"),
    ("GTK_SCROLL_JUMP", "1"),
    ("GTK_SCROLL_MINIMUM", "0"),
    ("GTK_SCROLL_NATURAL", "1"),
    ("GTK_SCROLL_NONE", "0"),
    ("GTK_SCROLL_PAGES", "1"),
    ("GTK_SCROLL_PAGE_BACKWARD", "4"),
    ("GTK_SCROLL_PAGE_DOWN", "9"),
    ("GTK_SCROLL_PAGE_FORWARD", "5"),
    ("GTK_SCROLL_PAGE_LEFT", "12"),
    ("GTK_SCROLL_PAGE_RIGHT", "13"),
    ("GTK_SCROLL_PAGE_UP", "8"),
    ("GTK_SCROLL_START", "14"),
    ("GTK_SCROLL_STEPS", "0"),
    ("GTK_SCROLL_STEP_BACKWARD", "2"),
    ("GTK_SCROLL_STEP_DOWN", "7"),
    ("GTK_SCROLL_STEP_FORWARD", "3"),
    ("GTK_SCROLL_STEP_LEFT", "10"),
    ("GTK_SCROLL_STEP_RIGHT", "11"),
    ("GTK_SCROLL_STEP_UP", "6"),
    ("GTK_SELECTION_BROWSE", "2"),
    ("GTK_SELECTION_MULTIPLE", "3"),
    ("GTK_SELECTION_NONE", "0"),
    ("GTK_SELECTION_SINGLE", "1"),
    ("GTK_SENSITIVITY_AUTO", "0"),
    ("GTK_SENSITIVITY_OFF", "2"),
    ("GTK_SENSITIVITY_ON", "1"),
    ("GTK_SHADOW_ETCHED_IN", "3"),
    ("GTK_SHADOW_ETCHED_OUT", "4"),
    ("GTK_SHADOW_IN", "1"),
    ("GTK_SHADOW_NONE", "0"),
    ("GTK_SHADOW_OUT", "2"),
    ("GTK_SHORTCUT_ACCELERATOR", "0"),
    ("GTK_SHORTCUT_GESTURE", "7"),
    ("GTK_SHORTCUT_GESTURE_PINCH", "1"),
    ("GTK_SHORTCUT_GESTURE_ROTATE_CLOCKWISE", "3"),
    ("GTK_SHORTCUT_GESTURE_ROTATE_COUNTERCLOCKWISE", "4"),
    ("GTK_SHORTCUT_GESTURE_STRETCH", "2"),
    ("GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_LEFT", "5"),
    ("GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_RIGHT", "6"),
    ("GTK_SHRINK", "2"),
    ("GTK_SIZE_GROUP_BOTH", "3"),
    ("GTK_SIZE_GROUP_HORIZONTAL", "1"),
    ("GTK_SIZE_GROUP_NONE", "0"),
    ("GTK_SIZE_GROUP_VERTICAL", "2"),
    ("GTK_SIZE_REQUEST_CONSTANT_SIZE", "2"),
    ("GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH", "0"),
    ("GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT", "1"),
    ("GTK_SORT_ASCENDING", "0"),
    ("GTK_SORT_DESCENDING", "1"),
    ("GTK_SPIN_END", "5"),
    ("GTK_SPIN_HOME", "4"),
    ("GTK_SPIN_PAGE_BACKWARD", "3"),
    ("GTK_SPIN_PAGE_FORWARD", "2"),
    ("GTK_SPIN_STEP_BACKWARD", "1"),
    ("GTK_SPIN_STEP_FORWARD", "0"),
    ("GTK_SPIN_USER_DEFINED", "6"),
    ("GTK_STACK_TRANSITION_TYPE_CROSSFADE", "1"),
    ("GTK_STACK_TRANSITION_TYPE_NONE", "0"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_DOWN", "9"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP", "17"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_LEFT", "10"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT", "18"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_RIGHT", "11"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT", "19"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_UP", "8"),
    ("GTK_STACK_TRANSITION_TYPE_OVER_UP_DOWN", "16"),
    ("GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN", "5"),
    ("GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT", "3"),
    ("GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT", "6"),
    ("GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT", "2"),
    ("GTK_STACK_TRANSITION_TYPE_SLIDE_UP", "4"),
    ("GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN", "7"),
    ("GTK_STACK_TRANSITION_TYPE_UNDER_DOWN", "13"),
    ("GTK_STACK_TRANSITION_TYPE_UNDER_LEFT", "14"),
    ("GTK_STACK_TRANSITION_TYPE_UNDER_RIGHT", "15"),
    ("GTK_STACK_TRANSITION_TYPE_UNDER_UP", "12"),
    ("GTK_STATE_ACTIVE", "1"),
    ("GTK_STATE_FLAG_ACTIVE", "1"),
    ("GTK_STATE_FLAG_BACKDROP", "64"),
    ("GTK_STATE_FLAG_CHECKED", "2048"),
    ("GTK_STATE_FLAG_DIR_LTR", "128"),
    ("GTK_STATE_FLAG_DIR_RTL", "256"),
    ("GTK_STATE_FLAG_DROP_ACTIVE", "4096"),
    ("GTK_STATE_FLAG_FOCUSED", "32"),
    ("GTK_STATE_FLAG_INCONSISTENT", "16"),
    ("GTK_STATE_FLAG_INSENSITIVE", "8"),
    ("GTK_STATE_FLAG_LINK", "512"),
    ("GTK_STATE_FLAG_NORMAL", "0"),
    ("GTK_STATE_FLAG_PRELIGHT", "2"),
    ("GTK_STATE_FLAG_SELECTED", "4"),
    ("GTK_STATE_FLAG_VISITED", "1024"),
    ("GTK_STATE_FOCUSED", "6"),
    ("GTK_STATE_INCONSISTENT", "5"),
    ("GTK_STATE_INSENSITIVE", "4"),
    ("GTK_STATE_NORMAL", "0"),
    ("GTK_STATE_PRELIGHT", "2"),
    ("GTK_STATE_SELECTED", "3"),
    ("GTK_STOCK_ABOUT", "gtk-about"),
    ("GTK_STOCK_ADD", "gtk-add"),
    ("GTK_STOCK_APPLY", "gtk-apply"),
    ("GTK_STOCK_BOLD", "gtk-bold"),
    ("GTK_STOCK_CANCEL", "gtk-cancel"),
    ("GTK_STOCK_CAPS_LOCK_WARNING", "gtk-caps-lock-warning"),
    ("GTK_STOCK_CDROM", "gtk-cdrom"),
    ("GTK_STOCK_CLEAR", "gtk-clear"),
    ("GTK_STOCK_CLOSE", "gtk-close"),
    ("GTK_STOCK_COLOR_PICKER", "gtk-color-picker"),
    ("GTK_STOCK_CONNECT", "gtk-connect"),
    ("GTK_STOCK_CONVERT", "gtk-convert"),
    ("GTK_STOCK_COPY", "gtk-copy"),
    ("GTK_STOCK_CUT", "gtk-cut"),
    ("GTK_STOCK_DELETE", "gtk-delete"),
    ("GTK_STOCK_DIALOG_AUTHENTICATION", "gtk-dialog-authentication"),
    ("GTK_STOCK_DIALOG_ERROR", "gtk-dialog-error"),
    ("GTK_STOCK_DIALOG_INFO", "gtk-dialog-info"),
    ("GTK_STOCK_DIALOG_QUESTION", "gtk-dialog-question"),
    ("GTK_STOCK_DIALOG_WARNING", "gtk-dialog-warning"),
    ("GTK_STOCK_DIRECTORY", "gtk-directory"),
    ("GTK_STOCK_DISCARD", "gtk-discard"),
    ("GTK_STOCK_DISCONNECT", "gtk-disconnect"),
    ("GTK_STOCK_DND", "gtk-dnd"),
    ("GTK_STOCK_DND_MULTIPLE", "gtk-dnd-multiple"),
    ("GTK_STOCK_EDIT", "gtk-edit"),
    ("GTK_STOCK_EXECUTE", "gtk-execute"),
    ("GTK_STOCK_FILE", "gtk-file"),
    ("GTK_STOCK_FIND", "gtk-find"),
    ("GTK_STOCK_FIND_AND_REPLACE", "gtk-find-and-replace"),
    ("GTK_STOCK_FLOPPY", "gtk-floppy"),
    ("GTK_STOCK_FULLSCREEN", "gtk-fullscreen"),
    ("GTK_STOCK_GOTO_BOTTOM", "gtk-goto-bottom"),
    ("GTK_STOCK_GOTO_FIRST", "gtk-goto-first"),
    ("GTK_STOCK_GOTO_LAST", "gtk-goto-last"),
    ("GTK_STOCK_GOTO_TOP", "gtk-goto-top"),
    ("GTK_STOCK_GO_BACK", "gtk-go-back"),
    ("GTK_STOCK_GO_DOWN", "gtk-go-down"),
    ("GTK_STOCK_GO_FORWARD", "gtk-go-forward"),
    ("GTK_STOCK_GO_UP", "gtk-go-up"),
    ("GTK_STOCK_HARDDISK", "gtk-harddisk"),
    ("GTK_STOCK_HELP", "gtk-help"),
    ("GTK_STOCK_HOME", "gtk-home"),
    ("GTK_STOCK_INDENT", "gtk-indent"),
    ("GTK_STOCK_INDEX", "gtk-index"),
    ("GTK_STOCK_INFO", "gtk-info"),
    ("GTK_STOCK_ITALIC", "gtk-italic"),
    ("GTK_STOCK_JUMP_TO", "gtk-jump-to"),
    ("GTK_STOCK_JUSTIFY_CENTER", "gtk-justify-center"),
    ("GTK_STOCK_JUSTIFY_FILL", "gtk-justify-fill"),
    ("GTK_STOCK_JUSTIFY_LEFT", "gtk-justify-left"),
    ("GTK_STOCK_JUSTIFY_RIGHT", "gtk-justify-right"),
    ("GTK_STOCK_LEAVE_FULLSCREEN", "gtk-leave-fullscreen"),
    ("GTK_STOCK_MEDIA_FORWARD", "gtk-media-forward"),
    ("GTK_STOCK_MEDIA_NEXT", "gtk-media-next"),
    ("GTK_STOCK_MEDIA_PAUSE", "gtk-media-pause"),
    ("GTK_STOCK_MEDIA_PLAY", "gtk-media-play"),
    ("GTK_STOCK_MEDIA_PREVIOUS", "gtk-media-previous"),
    ("GTK_STOCK_MEDIA_RECORD", "gtk-media-record"),
    ("GTK_STOCK_MEDIA_REWIND", "gtk-media-rewind"),
    ("GTK_STOCK_MEDIA_STOP", "gtk-media-stop"),
    ("GTK_STOCK_MISSING_IMAGE", "gtk-missing-image"),
    ("GTK_STOCK_NETWORK", "gtk-network"),
    ("GTK_STOCK_NEW", "gtk-new"),
    ("GTK_STOCK_NO", "gtk-no"),
    ("GTK_STOCK_OK", "gtk-ok"),
    ("GTK_STOCK_OPEN", "gtk-open"),
    ("GTK_STOCK_ORIENTATION_LANDSCAPE", "gtk-orientation-landscape"),
    ("GTK_STOCK_ORIENTATION_PORTRAIT", "gtk-orientation-portrait"),
    ("GTK_STOCK_ORIENTATION_REVERSE_LANDSCAPE", "gtk-orientation-reverse-landscape"),
    ("GTK_STOCK_ORIENTATION_REVERSE_PORTRAIT", "gtk-orientation-reverse-portrait"),
    ("GTK_STOCK_PAGE_SETUP", "gtk-page-setup"),
    ("GTK_STOCK_PASTE", "gtk-paste"),
    ("GTK_STOCK_PREFERENCES", "gtk-preferences"),
    ("GTK_STOCK_PRINT", "gtk-print"),
    ("GTK_STOCK_PRINT_ERROR", "gtk-print-error"),
    ("GTK_STOCK_PRINT_PAUSED", "gtk-print-paused"),
    ("GTK_STOCK_PRINT_PREVIEW", "gtk-print-preview"),
    ("GTK_STOCK_PRINT_REPORT", "gtk-print-report"),
    ("GTK_STOCK_PRINT_WARNING", "gtk-print-warning"),
    ("GTK_STOCK_PROPERTIES", "gtk-properties"),
    ("GTK_STOCK_QUIT", "gtk-quit"),
    ("GTK_STOCK_REDO", "gtk-redo"),
    ("GTK_STOCK_REFRESH", "gtk-refresh"),
    ("GTK_STOCK_REMOVE", "gtk-remove"),
    ("GTK_STOCK_REVERT_TO_SAVED", "gtk-revert-to-saved"),
    ("GTK_STOCK_SAVE", "gtk-save"),
    ("GTK_STOCK_SAVE_AS", "gtk-save-as"),
    ("GTK_STOCK_SELECT_ALL", "gtk-select-all"),
    ("GTK_STOCK_SELECT_COLOR", "gtk-select-color"),
    ("GTK_STOCK_SELECT_FONT", "gtk-select-font"),
    ("GTK_STOCK_SORT_ASCENDING", "gtk-sort-ascending"),
    ("GTK_STOCK_SORT_DESCENDING", "gtk-sort-descending"),
    ("GTK_STOCK_SPELL_CHECK", "gtk-spell-check"),
    ("GTK_STOCK_STOP", "gtk-stop"),
    ("GTK_STOCK_STRIKETHROUGH", "gtk-strikethrough"),
    ("GTK_STOCK_UNDELETE", "gtk-undelete"),
    ("GTK_STOCK_UNDERLINE", "gtk-underline"),
    ("GTK_STOCK_UNDO", "gtk-undo"),
    ("GTK_STOCK_UNINDENT", "gtk-unindent"),
    ("GTK_STOCK_YES", "gtk-yes"),
    ("GTK_STOCK_ZOOM_100", "gtk-zoom-100"),
    ("GTK_STOCK_ZOOM_FIT", "gtk-zoom-fit"),
    ("GTK_STOCK_ZOOM_IN", "gtk-zoom-in"),
    ("GTK_STOCK_ZOOM_OUT", "gtk-zoom-out"),
    ("GTK_STYLE_CLASS_ACCELERATOR", "accelerator"),
    ("GTK_STYLE_CLASS_ARROW", "arrow"),
    ("GTK_STYLE_CLASS_BACKGROUND", "background"),
    ("GTK_STYLE_CLASS_BOTTOM", "bottom"),
    ("GTK_STYLE_CLASS_BUTTON", "button"),
    ("GTK_STYLE_CLASS_CALENDAR", "calendar"),
    ("GTK_STYLE_CLASS_CELL", "cell"),
    ("GTK_STYLE_CLASS_CHECK", "check"),
    ("GTK_STYLE_CLASS_COMBOBOX_ENTRY", "combobox-entry"),
    ("GTK_STYLE_CLASS_CONTEXT_MENU", "context-menu"),
    ("GTK_STYLE_CLASS_CSD", "csd"),
    ("GTK_STYLE_CLASS_CURSOR_HANDLE", "cursor-handle"),
    ("GTK_STYLE_CLASS_DEFAULT", "default"),
    ("GTK_STYLE_CLASS_DESTRUCTIVE_ACTION", "destructive-action"),
    ("GTK_STYLE_CLASS_DIM_LABEL", "dim-label"),
    ("GTK_STYLE_CLASS_DND", "dnd"),
    ("GTK_STYLE_CLASS_DOCK", "dock"),
    ("GTK_STYLE_CLASS_ENTRY", "entry"),
    ("GTK_STYLE_CLASS_ERROR", "error"),
    ("GTK_STYLE_CLASS_EXPANDER", "expander"),
    ("GTK_STYLE_CLASS_FLAT", "flat"),
    ("GTK_STYLE_CLASS_FRAME", "frame"),
    ("GTK_STYLE_CLASS_GRIP", "grip"),
    ("GTK_STYLE_CLASS_HEADER", "header"),
    ("GTK_STYLE_CLASS_HIGHLIGHT", "highlight"),
    ("GTK_STYLE_CLASS_HORIZONTAL", "horizontal"),
    ("GTK_STYLE_CLASS_IMAGE", "image"),
    ("GTK_STYLE_CLASS_INFO", "info"),
    ("GTK_STYLE_CLASS_INLINE_TOOLBAR", "inline-toolbar"),
    ("GTK_STYLE_CLASS_INSERTION_CURSOR", "insertion-cursor"),
    ("GTK_STYLE_CLASS_LABEL", "label"),
    ("GTK_STYLE_CLASS_LEFT", "left"),
    ("GTK_STYLE_CLASS_LEVEL_BAR", "level-bar"),
    ("GTK_STYLE_CLASS_LINKED", "linked"),
    ("GTK_STYLE_CLASS_LIST", "list"),
    ("GTK_STYLE_CLASS_LIST_ROW", "list-row"),
    ("GTK_STYLE_CLASS_MARK", "mark"),
    ("GTK_STYLE_CLASS_MENU", "menu"),
    ("GTK_STYLE_CLASS_MENUBAR", "menubar"),
    ("GTK_STYLE_CLASS_MENUITEM", "menuitem"),
    ("GTK_STYLE_CLASS_MESSAGE_DIALOG", "message-dialog"),
    ("GTK_STYLE_CLASS_MONOSPACE", "monospace"),
    ("GTK_STYLE_CLASS_NEEDS_ATTENTION", "needs-attention"),
    ("GTK_STYLE_CLASS_NOTEBOOK", "notebook"),
    ("GTK_STYLE_CLASS_OSD", "osd"),
    ("GTK_STYLE_CLASS_OVERSHOOT", "overshoot"),
    ("GTK_STYLE_CLASS_PANE_SEPARATOR", "pane-separator"),
    ("GTK_STYLE_CLASS_PAPER", "paper"),
    ("GTK_STYLE_CLASS_POPOVER", "popover"),
    ("GTK_STYLE_CLASS_POPUP", "popup"),
    ("GTK_STYLE_CLASS_PRIMARY_TOOLBAR", "primary-toolbar"),
    ("GTK_STYLE_CLASS_PROGRESSBAR", "progressbar"),
    ("GTK_STYLE_CLASS_PULSE", "pulse"),
    ("GTK_STYLE_CLASS_QUESTION", "question"),
    ("GTK_STYLE_CLASS_RADIO", "radio"),
    ("GTK_STYLE_CLASS_RAISED", "raised"),
    ("GTK_STYLE_CLASS_READ_ONLY", "read-only"),
    ("GTK_STYLE_CLASS_RIGHT", "right"),
    ("GTK_STYLE_CLASS_RUBBERBAND", "rubberband"),
    ("GTK_STYLE_CLASS_SCALE", "scale"),
    ("GTK_STYLE_CLASS_SCALE_HAS_MARKS_ABOVE", "scale-has-marks-above"),
    ("GTK_STYLE_CLASS_SCALE_HAS_MARKS_BELOW", "scale-has-marks-below"),
    ("GTK_STYLE_CLASS_SCROLLBAR", "scrollbar"),
    ("GTK_STYLE_CLASS_SCROLLBARS_JUNCTION", "scrollbars-junction"),
    ("GTK_STYLE_CLASS_SEPARATOR", "separator"),
    ("GTK_STYLE_CLASS_SIDEBAR", "sidebar"),
    ("GTK_STYLE_CLASS_SLIDER", "slider"),
    ("GTK_STYLE_CLASS_SPINBUTTON", "spinbutton"),
    ("GTK_STYLE_CLASS_SPINNER", "spinner"),
    ("GTK_STYLE_CLASS_STATUSBAR", "statusbar"),
    ("GTK_STYLE_CLASS_SUBTITLE", "subtitle"),
    ("GTK_STYLE_CLASS_SUGGESTED_ACTION", "suggested-action"),
    ("GTK_STYLE_CLASS_TITLE", "title"),
    ("GTK_STYLE_CLASS_TITLEBAR", "titlebar"),
    ("GTK_STYLE_CLASS_TOOLBAR", "toolbar"),
    ("GTK_STYLE_CLASS_TOOLTIP", "tooltip"),
    ("GTK_STYLE_CLASS_TOP", "top"),
    ("GTK_STYLE_CLASS_TOUCH_SELECTION", "touch-selection"),
    ("GTK_STYLE_CLASS_TROUGH", "trough"),
    ("GTK_STYLE_CLASS_UNDERSHOOT", "undershoot"),
    ("GTK_STYLE_CLASS_VERTICAL", "vertical"),
    ("GTK_STYLE_CLASS_VIEW", "view"),
    ("GTK_STYLE_CLASS_WARNING", "warning"),
    ("GTK_STYLE_CLASS_WIDE", "wide"),
    ("GTK_STYLE_CONTEXT_PRINT_NONE", "0"),
    ("GTK_STYLE_CONTEXT_PRINT_RECURSE", "1"),
    ("GTK_STYLE_CONTEXT_PRINT_SHOW_STYLE", "2"),
    ("GTK_STYLE_PROPERTY_BACKGROUND_COLOR", "background-color"),
    ("GTK_STYLE_PROPERTY_BACKGROUND_IMAGE", "background-image"),
    ("GTK_STYLE_PROPERTY_BORDER_COLOR", "border-color"),
    ("GTK_STYLE_PROPERTY_BORDER_RADIUS", "border-radius"),
    ("GTK_STYLE_PROPERTY_BORDER_STYLE", "border-style"),
    ("GTK_STYLE_PROPERTY_BORDER_WIDTH", "border-width"),
    ("GTK_STYLE_PROPERTY_COLOR", "color"),
    ("GTK_STYLE_PROPERTY_FONT", "font"),
    ("GTK_STYLE_PROPERTY_MARGIN", "margin"),
    ("GTK_STYLE_PROPERTY_PADDING", "padding"),
    ("GTK_STYLE_PROVIDER_PRIORITY_APPLICATION", "600"),
    ("GTK_STYLE_PROVIDER_PRIORITY_FALLBACK", "1"),
    ("GTK_STYLE_PROVIDER_PRIORITY_SETTINGS", "400"),
    ("GTK_STYLE_PROVIDER_PRIORITY_THEME", "200"),
    ("GTK_STYLE_PROVIDER_PRIORITY_USER", "800"),
    ("GTK_STYLE_REGION_COLUMN", "column"),
    ("GTK_STYLE_REGION_COLUMN_HEADER", "column-header"),
    ("GTK_STYLE_REGION_ROW", "row"),
    ("GTK_STYLE_REGION_TAB", "tab"),
    ("GTK_TARGET_OTHER_APP", "4"),
    ("GTK_TARGET_OTHER_WIDGET", "8"),
    ("GTK_TARGET_SAME_APP", "1"),
    ("GTK_TARGET_SAME_WIDGET", "2"),
    ("GTK_TEXT_BUFFER_TARGET_INFO_BUFFER_CONTENTS", "-1"),
    ("GTK_TEXT_BUFFER_TARGET_INFO_RICH_TEXT", "-2"),
    ("GTK_TEXT_BUFFER_TARGET_INFO_TEXT", "-3"),
    ("GTK_TEXT_DIR_LTR", "1"),
    ("GTK_TEXT_DIR_NONE", "0"),
    ("GTK_TEXT_DIR_RTL", "2"),
    ("GTK_TEXT_EXTEND_SELECTION_LINE", "1"),
    ("GTK_TEXT_EXTEND_SELECTION_WORD", "0"),
    ("GTK_TEXT_SEARCH_CASE_INSENSITIVE", "4"),
    ("GTK_TEXT_SEARCH_TEXT_ONLY", "2"),
    ("GTK_TEXT_SEARCH_VISIBLE_ONLY", "1"),
    ("GTK_TEXT_VIEW_LAYER_ABOVE", "1"),
    ("GTK_TEXT_VIEW_LAYER_ABOVE_TEXT", "3"),
    ("GTK_TEXT_VIEW_LAYER_BELOW", "0"),
    ("GTK_TEXT_VIEW_LAYER_BELOW_TEXT", "2"),
    ("GTK_TEXT_VIEW_PRIORITY_VALIDATE", "5"),
    ("GTK_TEXT_WINDOW_BOTTOM", "6"),
    ("GTK_TEXT_WINDOW_LEFT", "3"),
    ("GTK_TEXT_WINDOW_PRIVATE", "0"),
    ("GTK_TEXT_WINDOW_RIGHT", "4"),
    ("GTK_TEXT_WINDOW_TEXT", "2"),
    ("GTK_TEXT_WINDOW_TOP", "5"),
    ("GTK_TEXT_WINDOW_WIDGET", "1"),
    ("GTK_TOOLBAR_BOTH", "2"),
    ("GTK_TOOLBAR_BOTH_HORIZ", "3"),
    ("GTK_TOOLBAR_ICONS", "0"),
    ("GTK_TOOLBAR_SPACE_EMPTY", "0"),
    ("GTK_TOOLBAR_SPACE_LINE", "1"),
    ("GTK_TOOLBAR_TEXT", "1"),
    ("GTK_TOOL_PALETTE_DRAG_GROUPS", "2"),
    ("GTK_TOOL_PALETTE_DRAG_ITEMS", "1"),
    ("GTK_TREE_MODEL_ITERS_PERSIST", "1"),
    ("GTK_TREE_MODEL_LIST_ONLY", "2"),
    ("GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID", "-1"),
    ("GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID", "-2"),
    ("GTK_TREE_VIEW_COLUMN_AUTOSIZE", "1"),
    ("GTK_TREE_VIEW_COLUMN_FIXED", "2"),
    ("GTK_TREE_VIEW_COLUMN_GROW_ONLY", "0"),
    ("GTK_TREE_VIEW_DROP_AFTER", "1"),
    ("GTK_TREE_VIEW_DROP_BEFORE", "0"),
    ("GTK_TREE_VIEW_DROP_INTO_OR_AFTER", "3"),
    ("GTK_TREE_VIEW_DROP_INTO_OR_BEFORE", "2"),
    ("GTK_TREE_VIEW_GRID_LINES_BOTH", "3"),
    ("GTK_TREE_VIEW_GRID_LINES_HORIZONTAL", "1"),
    ("GTK_TREE_VIEW_GRID_LINES_NONE", "0"),
    ("GTK_TREE_VIEW_GRID_LINES_VERTICAL", "2"),
    ("GTK_UI_MANAGER_ACCELERATOR", "256"),
    ("GTK_UI_MANAGER_AUTO", "0"),
    ("GTK_UI_MANAGER_MENU", "2"),
    ("GTK_UI_MANAGER_MENUBAR", "1"),
    ("GTK_UI_MANAGER_MENUITEM", "32"),
    ("GTK_UI_MANAGER_PLACEHOLDER", "8"),
    ("GTK_UI_MANAGER_POPUP", "16"),
    ("GTK_UI_MANAGER_POPUP_WITH_ACCELS", "512"),
    ("GTK_UI_MANAGER_SEPARATOR", "128"),
    ("GTK_UI_MANAGER_TOOLBAR", "4"),
    ("GTK_UI_MANAGER_TOOLITEM", "64"),
    ("GTK_UNIT_INCH", "2"),
    ("GTK_UNIT_MM", "3"),
    ("GTK_UNIT_NONE", "0"),
    ("GTK_UNIT_POINTS", "1"),
    ("GTK_UPDATE_ALWAYS", "0"),
    ("GTK_UPDATE_IF_VALID", "1"),
    ("GTK_WIDGET_HELP_TOOLTIP", "0"),
    ("GTK_WIDGET_HELP_WHATS_THIS", "1"),
    ("GTK_WINDOW_POPUP", "1"),
    ("GTK_WINDOW_TOPLEVEL", "0"),
    ("GTK_WIN_POS_CENTER", "1"),
    ("GTK_WIN_POS_CENTER_ALWAYS", "3"),
    ("GTK_WIN_POS_CENTER_ON_PARENT", "4"),
    ("GTK_WIN_POS_MOUSE", "2"),
    ("GTK_WIN_POS_NONE", "0"),
    ("GTK_WRAP_CHAR", "1"),
    ("GTK_WRAP_NONE", "0"),
    ("GTK_WRAP_WORD", "2"),
    ("GTK_WRAP_WORD_CHAR", "3"),
];


