#ifndef TC_ERRCODE_H
#define TC_ERRCODE_H

#ifdef __cplusplus
extern "C" {
#endif

#define TC_SUCCESS                  0   /*  执行成功  */
#define TC_ERR_NULL                 1   /*  HANDLE句柄为空  */
#define TC_API_UNDEFINE             2   /*  接口未定义  */
#define TC_UNDEFINE_ALGO            10  /*  未定义算法  */
#define TC_DECRYPT_BUFFER_OVERSIZE  11  /*  待解密消息长度超出限制  */
#define TC_AUTH_HMAC_OVERSIZE       12  /*  授权认证口令长度超出限制  */
#define TC_ENCRYPT_BUFFER_OVERSIZE  13  /*  待加密消息长度超出限制  */
#define TC_HASH_BUFFER_OVERSIZE     14  /*  待哈希消息长度超出限制  */
#define TC_SIGN_BUFFER_OVERSIZE     15  /*  待签名消息长度超出限制  */
#define TC_VERIFY_BUFFER_OVERSIZE   16  /*  待验证消息长度超出限制  */
#define TC_NODE_OVERCAPACITY        20  /*  HANDLE对应节点数量超出限制  */
#define TC_PARENT_INDEX             21  /*  无效父节点索引  */
#define TC_OBJECT_INDEX             22  /*  无效子节点索引  */
#define TC_NV_READPUBLIC            23  /*  读取NV公共空间失败  */
#define TC_NV_SIZE                  24  /*  NV索引下的空间大小不满足输入的size大小 */
#define TC_NV_MAXBUFFER             25  /*  获取MAXBUFFER的size出错  */
#define TC_NV_OFFSET                26  /*  NV索引下的偏移大小不满足输入offset的大小  */
#define TC_COMMAND_START            31  /*  调用接口TC_Start返回错误  */
#define TC_COMMAND_END              32  /*  调用接口TC_End返回错误  */
#define TC_COMMAND_LOAD             33  /*  调用接口TC_Load返回错误  */
#define TC_COMMAND_EVICTCONTROL     34  /*  调用接口TC_EvictControl返回错误  */
#define TC_COMMAND_ENCRYPT          35  /*  调用接口TC_Encrypt返回错误  */
#define TC_COMMAND_DECRYPT          36  /*  调用接口TC_Decrypt返回错误  */
#define TC_COMMAND_CREATEPRIMARY    37  /*  调用接口TC_CreatePrimary返回错误  */
#define TC_COMMAND_CREATE           38  /*  调用接口TC_Create返回错误  */
#define TC_COMMAND_SIGN             39  /*  调用接口TC_Sign返回错误  */
#define TC_COMMAND_VERIFYSIGNATURE  40  /*  调用接口TC_VerifySignature返回错误  */
#define TC_COMMAND_HASH             41  /*  调用接口TC_Hash返回错误  */
#define TC_COMMAND_NVDEFINE         42  /*  调用接口TC_NVDefine返回错误  */
#define TC_COMMAND_NVRELEASE        43  /*  调用接口TC_NVRelease返回错误  */
#define TC_COMMAND_NVWRITE          44  /*  调用接口TC_NVWrite返回错误  */
#define TC_COMMAND_NVREAD           45  /*  调用接口TC_NVRead返回错误  */

#ifdef __cplusplus
}
#endif

#endif /* TC_ERRCODE_H */