    #include <stdarg.h>

    #include "tc_private/tc_handle.h"
    #include "tc_private/tc_private.h"

    #include "log/log.h"

    #include "tc_tpm2.h"
    #include "tpm2_common.h"

    #include "tc_type.h"
    #include "tc_errcode.h"

    struct tpm2_start_ctx
    {
        uint8_t         *device;
        TC_HANDLE       *handle;
    };

    TC_RC tpm2_start_init(struct api_ctx_st *api_ctx, int num, ...)
    {
        TC_RC rc = TC_SUCCESS;
        struct tpm2_start_ctx* sctx = (struct tpm2_start_ctx*)malloc(sizeof(struct tpm2_start_ctx));

        va_list ap;
        va_start(ap, num);
        sctx->handle = va_arg(ap, TC_HANDLE*);
        sctx->device = va_arg(ap, uint8_t*);
        va_end(ap);

        api_ctx->data = (HANDLE_DATA*)sctx;
        return rc;
    }

    TC_RC tpm2_start_free(struct api_ctx_st *api_ctx)
    {
        TC_RC rc = TC_SUCCESS;  
        free(api_ctx->data); 
        api_ctx->data = NULL;
        api_ctx->cmd_code = API_NULL;
        return rc;
    }

    TC_RC tpm2_start(API_CTX *ctx)
    {
        TC_RC rc = TC_SUCCESS;

        struct tpm2_start_ctx* sctx = (struct tpm2_start_ctx*)ctx->data;

        TC_HANDLE_CTX* tc_handle_ctx = (TC_HANDLE_CTX*)(*sctx->handle);

        tc_handle_ctx->handle.tc_object->count = 0;
        tc_handle_ctx->handle.tc_context = (TC_CONTEXT*)tpm2_init(sctx->device);
        if (tc_handle_ctx->handle.tc_context == NULL) {
            log_error("Failed to run api_start:0x%0x\n", rc);
            rc = TC_COMMAND_START;
        }

        return rc;
    }