
#ifndef __SIPROSLICREG__
#define __SIPROSLICREG__

// Registers
#define PS_SPI_MODE	0
#define PS_PCM_MODE	1
#define PS_PCM_TX_L	2
#define PS_PCM_TX_H	3
#define PS_PCM_RX_L	4
#define PS_PCM_RX_H	5
#define	PS_DIO_CTRL	6
#define PS_RESERVED7	7
#define PS_LOOPBACK	8
#define PS_TXRX_PGC	9
#define PS_IMPEDANCE	10
#define PS_HYB_BAL_RL	11
#define PS_RESERVED12	12
#define PS_RESERVED13	13
#define PS_PWR_DN_CTRL1	14
#define PS_PWR_DN_CTRL2	15
#define PS_RESERVED16	16
#define PS_RESERVED17	17
#define PS_INT_REG1	18
#define PS_INT_REG2	19
#define PS_INT_REG3	20
#define PS_INT_MASK1	21
#define PS_INT_MASK2	22
#define PS_INT_MASK3	23
#define PS_DTMF_OUT	24
#define PS_RESERVED25	25
#define PS_RESERVED26	26
#define PS_RESERVED27	27
#define PS_IND_DATA_L	28
#define PS_IND_DATA_H	29
#define PS_IND_ADDR	30
#define PS_IND_ADDR_ST	31
#define PS_OSC1		32
#define PS_OSC2		33
#define PS_RG_OSC_CTRL	34
#define PS_PM_OSC_CTRL	35
#define PS_OSC1_ACT_L	36
#define PS_OSC1_ACT_H	37
#define PS_OSC1_INACT_L	38
#define PS_OSC1_INACT_H	39
#define PS_OSC2_ACT_L	40
#define PS_OSC2_ACT_H	41
#define PS_OSC2_INACT_L	42
#define PS_OSC2_INACT_H	43
#define PS_PM_ACT_L	44
#define PS_PM_ACT_H	45
#define PS_PM_INACT_L	46
#define PS_PM_INACT_H	47
#define PS_RG_OSC_ACT_L	48
#define PS_RG_OSC_ACT_H	49
#define PS_RG_OSC_INACT_l	50
#define PS_RG_OSC_INACT_H	51
#define PS_FSK_DATA	52
#define PS_RESERVED53	53
#define PS_RESERVED54	54
#define PS_RESERVED55	55
#define PS_RESERVED56	56
#define PS_RESERVED57	57
#define PS_RESERVED58	58
#define PS_RESERVED59	59
#define PS_RESERVED60	60
#define PS_RESERVED61	61
#define PS_RESERVED62	62
#define PS_RG_LP_DEBOUNCE	63
#define PS_MODE		64
#define PS_EXT_BIOP_TRANS	65
#define PS_BAT_CTRL	66
#define PS_AUTO_MAN_CTRL	67
#define PS_LP_COND_IND	68
#define PS_LP_CLOSE_DEBOUNCE	69
#define PS_RG_TRIP_DEBOUNCE	70
#define PS_OFHK_LP_CUR	71
#define PS_ONHK_VOLT	72
#define PS_COMM_MODE_VOLT	73
#define PS_VBAT_H	74
#define PS_VBAT_L	75
#define PS_PWR_MON_PTR	76
#define PS_PWR_MON_OUT	77
#define PS_LP_VOLT	78
#define PS_LP_CUR	79
#define PS_TIP_VOLT	80
#define PS_RING_VOLT	81
#define PS_VBAT_VOLT1	82
#define PS_VBAT_VOLT2	83
#define PS_Q1_CUR	84
#define PS_Q2_CUR	85
#define PS_Q3_CUR	86
#define PS_Q4_CUR	87
#define PS_Q5_CUR	88
#define PS_Q6_CUR	89
#define PS_RESERVED90	90
#define PS_RESERVED91	91
#define PS_DCDC_PWM_PERIOD	92
#define PS_DCDC_MIN_OFF_T	93
#define PS_DCDC_PWN_PULSE	94
#define PS_RESERVED95	95
#define PS_CALIB_CTRL_REG1	96
#define PS_CALIB_CTRL_REG2	97
#define PS_CALIB_RING_GAIN	98
#define PS_CALIB_TIP_GAIN	99
#define PS_CALIB_DIFF_LP_GAIN	100
#define PS_CALIB_COMM_LP_GAIN	101
#define PS_CALIB_CURR_LIMIT	102
#define PS_CALIB_ADC_OFFSET	103
#define PS_CALIB_DAC_ADC_OFFSET	104
#define PS_CALIB_DAC_OFFSET	105
#define PS_CALIB_COMM_MODE	106
#define PS_CALIB_DC_PEAK	107
#define PS_FEAT_ENHANCE	108

// Indirect registers
#define PSI_DTMF_ROW_0_PEAK	0
#define PSI_DTMF_ROW_1_PEAK	1
#define PSI_DTMF_ROW_2_PEAK	2
#define PSI_DTMF_ROW_3_PEAK	3
#define PSI_DTMF_COL_PEAK	4
#define PSI_DTMF_FWD_TWIST	5
#define PSI_DTMF_REV_TWIST	6
#define PSI_DTMF_ROW_RATIO	7
#define PSI_DTMF_COL_RATIO	8
#define PSI_DTMF_ROW_2ND_HARM	9
#define PSI_DTMF_COL_2ND_HARM	10
#define PSI_DTMF_PWR_MIN	11
#define PSI_DTMF_HOT_LIM	12
#define PSI_OSC1_COEFF	13
#define PSI_OSC1_AMP	14
#define PSI_OSC1_INIT_PHASE	15
#define PSI_OSC2_COEFF	16
#define PSI_OSC2_AMP	17
#define PSI_OSC2_INIT_PHASE	18
#define PSI_RING_DC_OFFSET	19
#define PSI_RING_FREQ_COEFF	20
#define PSI_RING_AMP	21
#define PSI_RING_INIT	22
#define PSI_PMO_RISE_TIME	23
#define PSI_PMO_INIT	24
#define PSI_PMO_FREQ	25
#define PSI_RX_DIG_GAIN	26
#define PSI_TX_DIG_GAIN	27
#define PSI_LP_CLOSE_H	28
#define PSI_RING_TRIP	29
#define PSI_COMM_MODE_L	30
#define PSI_COMM_MODE_H	31
#define PSI_PWR_Q1_Q2	32
#define PSI_PWR_Q3_Q4	33
#define PSI_PWR_Q5_Q6	34
#define PSI_LOOP_CLOSE	35
#define PSI_RING_TRIP_LPF	36
#define PSI_PWR_LPF_Q1_Q2	37
#define PSI_PWR_LPF_Q3_Q4	38
#define PSI_PWR_LPF_Q5_Q6	39
#define PSI_COMM_MODE_BIAS_RING	40
#define PSI_DCDC_MIN_VOV	41
#define PSI_RESERVED42	42
#define PSI_LP_CLOSE_L		43
// A lot of reserved registers!
#define PSI_FSK0_X	99
#define PSI_FSK0_INIT	100
#define PSI_FSK1_X	101
#define PSI_FSK1_INIT	102
#define PSI_FSK_0TO1_TRAN	103
#define PSI_FSK_1TO0_TRAN	104

static struct ps_country_reg {
	const char *country;
	unsigned short value;
} ps_country_regs[] = {
	{"ARGENTINA",  0x8},
	{"AUSTRALIA",  0xD},
	{"AUSTRIA",    0xD},
	{"BAHRAIN",    0xC},
	{"BELGIUM",    0xC},
	{"BRAZIL",     0x8},
	{"BULGARIA",   0xD},
	{"CANADA",     0x8},
	{"CHILE",      0x8},
	{"CHINA",      0xC},
	{"COLOMBIA",   0x8},
	{"CROATIA",    0xC},
	{"CYPRUS",     0xC},
	{"CZECH",      0xC},
	{"DENMARK",    0xC},
	{"ECUADOR",    0x8},
	{"EGYPT",      0x8},
	{"ELSALVADOR", 0x8},
	{"FINLAND",    0xC},
	{"FRANCE",     0xC},
	{"GERMANY",    0xD},
	{"GREECE",     0xC},
	{"GUAM",       0x8},
	{"HONGKONG",   0x8},
	{"HUNGARY",    0x8},
	{"ICELAND",    0xC},
	{"INDIA",      0xF},
	{"INDONESIA",  0x8},
	{"IRELAND",    0xC},
	{"ISRAEL",     0xC},
	{"ITALY",      0xC},
	{"JAPAN",      0x8},
	{"JORDAN",     0x8},
	{"KAZAKHSTAN", 0x8},
	{"KUWAIT",     0x8},
	{"LATVIA",     0xC},
	{"LEBANON",    0xC},
	{"LUXEMBOURG", 0xC},
	{"MACAO",      0x8},
	{"MALAYSIA",   0x8},
	{"MALTA",      0xC},
	{"MEXICO",     0x8},
	{"MOROCCO",    0xC},
	{"NETHERLANDS",0xC},
	{"NEWZEALAND", 0xF},
	{"NIGERIA",    0xC},
	{"NORWAY",     0xC},
	{"OMAN",       0x8},
	{"PAKISTAN",   0x8},
	{"PERU",       0x8},
	{"PHILIPPINES",0x8},
	{"POLAND",     0x8},
	{"PORTUGAL",   0xC},
	{"ROMANIA",    0x8},
	{"RUSSIA",     0x8},
	{"SAUDIARABIA",0x8},
	{"SINGAPORE",  0x8},
	{"SLOVAKIA",   0xE},
	{"SLOVENIA",   0xE},
	{"SOUTHAFRICA",0xE},
	{"SOUTHKOREA", 0x8},
	{"SPAIN",      0xC},
	{"SWEDEN",     0xC},
	{"SWITZERLAND",0xC},
	{"SYRIA",      0x8},
	{"TAIWAN",     0x8},
	{"THAILAND",   0x8},
	{"UAE",        0x8},
	{"UK",         0xC},
	{"USA",        0x8},
	{"YEMEN",      0x8},

	// Place holder names for impedance settings
	// that have no other way to be selected.
	{"OHM900",     0x9},
	{"CAPOHM600",  0xA},
	{"CAPOHM900",  0xB}
};

#endif
