#!/usr/bin/env python
import sys
import os

import sphinx_rtd_theme

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('../../source'))

# -- General configuration ------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html

Argonne = u'Argonne National Laboratory'
project = u'TomoPy'
copyright = u'2013-2019, ' + Argonne

release = os.popen('git log -1 --format="%H"').read().strip()

# We require sphinx >=2 because of sphinxcontrib.bibtex,
needs_sphinx = '2.0'

extensions = [
    'IPython.sphinxext.ipython_console_highlighting',
    'IPython.sphinxext.ipython_directive',
    'nbsphinx',
    'sphinx.ext.autodoc',
    'sphinx.ext.mathjax',
    'sphinx.ext.todo',
    'sphinx.ext.autosummary',
    'sphinx.ext.napoleon',
    'sphinxcontrib.bibtex',
    'sphinx.ext.viewcode',
]

exclude_patterns = ['_build', '**.ipynb_checkpoints']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# -- Options for bibtex

bibtex_bibfiles = [
    'bibtex/zcite.bib',
    'bibtex/zref.bib',
]

# -- Options for Napoleon -----------------------------------------------------

napoleon_google_docstring = True
napoleon_numpy_docstring = True
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = False
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = False
napoleon_use_admonition_for_references = False
napoleon_use_ivar = False
napoleon_use_param = False
napoleon_use_rtype = False

# -- Options for TODO ---------------------------------------------------------

todo_include_todos = True

# -- Options for nbsphinx -----------------------------------------------------

nbsphinx_execute_arguments = [
    "--InlineBackend.figure_formats={'svg', 'pdf'}",
    "--InlineBackend.rc={'figure.dpi': 96}",
]

# This is processed by Jinja2 and inserted before each notebook
nbsphinx_prolog = r"""
{% set docname = env.doc2path(env.docname, base='doc/source') %}

.. only:: html

    .. role:: raw-html(raw)
        :format: html

    .. nbinfo::

        This page was generated from `/doc/source/{{ env.doc2path(env.docname, base=None) }}`__.
        Interactive online version:
        :raw-html:`<a href="https://mybinder.org/v2/gh/tomopy/tomopy/{{ env.config.release }}?filepath=/doc/source/{{ env.doc2path(env.docname, base=None) }}"><img alt="Binder badge" src="https://mybinder.org/badge_logo.svg" style="vertical-align:text-bottom"></a>`

    __ https://github.com/tomopy/tomopy/blob/
        {{ env.config.release }}/doc/source/{{ env.doc2path(env.docname, base=None) }}

.. raw:: latex

    \nbsphinxstartnotebook{\scriptsize\noindent\strut
    \textcolor{gray}{The following section was generated from
    \sphinxcode{\sphinxupquote{\strut {{ docname | escape_latex }}}} \dotfill}}
"""

# -- Options for HTML output ----------------------------------------------

html_theme = 'sphinx_rtd_theme'
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

html_theme_options = {
    'style_nav_header_background': '#4f8fb8ff',
    'collapse_navigation': False,
    'logo_only': True,
}

html_logo = 'img/tomopy-logo-wide-mono.svg'

html_favicon = 'img/tomopy-logo.svg'

# Output file base name for HTML help builder.
htmlhelp_basename = project + 'doc'

# -- Options for LaTeX output ---------------------------------------------

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    ('index', project + '.tex', project + u' Documentation', Argonne,
     'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
latex_logo = 'img/tomopy-logo.svg'

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [('index', project, project + u' Documentation', [
    Argonne,
], 1)]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    ('index', project, project + u' Documentation', Argonne, project,
     'TomoPy: Tomographic Reconstruction in Python.', 'Miscellaneous'),
]

# -- Options for Texinfo output -------------------------------------------
# http://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html#confval-autodoc_mock_imports

autodoc_mock_imports = [
    'concurrent',
    'DM3lib',
    'libtomo',
    'tomopy.util.extern',
    'matplotlib',
    'numexpr',
    'numpy',
    'pyfftw',
    'pywt',
    'scipy',
    'skimage',
    'tifffile',
]
