/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper;

import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.ui.tamper.EditObjectView;
import com.aspect.snoop.ui.tamper.array.EditArrayView;
import com.aspect.snoop.ui.tamper.bytearray.EditByteArrayView;
import com.aspect.snoop.ui.tamper.list.EditListView;
import com.aspect.snoop.ui.tamper.map.EditMapView;
import com.aspect.snoop.util.ReflectionUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class ObjectTableModel
extends AbstractTableModel {
    private List<Field> fields;
    private Object toEdit;
    private static Class[] columnTypes = new Class[]{String.class, String.class, String.class, JButton.class};
    private static String[] columnNames = new String[]{"Name", "Type", "toString()", ""};

    public ObjectTableModel(Object toEdit, List<Field> fields) {
        this.fields = fields;
        this.toEdit = toEdit;
    }

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.fields.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Field f = this.fields.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return f.getName();
            }
            case 1: 
            case 2: 
            case 3: {
                final Field accessibleField = ReflectionUtil.getAccessibleField(this.toEdit, f);
                try {
                    Object innerObject = accessibleField.get(this.toEdit);
                    if (columnIndex == 1) {
                        return accessibleField.getType().getName();
                    }
                    if (columnIndex == 2) {
                        return String.valueOf(innerObject);
                    }
                    if (innerObject == null) {
                        return null;
                    }
                    final Object obj = innerObject;
                    JButton btn = new JButton("Edit");
                    btn.setEnabled(true);
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (obj.getClass().isArray()) {
                                EditArrayView view = new EditArrayView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (Object[])obj);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ObjectTableModel.this.fireTableStructureChanged();
                            } else if (obj instanceof Map) {
                                EditMapView view = new EditMapView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (Map)obj);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ObjectTableModel.this.fireTableStructureChanged();
                            } else if (obj instanceof List) {
                                EditListView view = new EditListView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (List)obj);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ObjectTableModel.this.fireTableStructureChanged();
                            } else if (obj instanceof byte[]) {
                                EditByteArrayView view = new EditByteArrayView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (byte[])obj);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ObjectTableModel.this.fireTableStructureChanged();
                                try {
                                    accessibleField.set(ObjectTableModel.this.toEdit, view.getBytes());
                                }
                                catch (IllegalArgumentException ex) {
                                    AgentLogger.error(ex);
                                }
                                catch (IllegalAccessException ex) {
                                    AgentLogger.error(ex);
                                }
                                ObjectTableModel.this.fireTableStructureChanged();
                            } else {
                                EditObjectView view = new EditObjectView((Frame)JavaSnoop.getApplication().getMainFrame(), true, obj);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ObjectTableModel.this.fireTableStructureChanged();
                                if (view.shouldReplaceObject()) {
                                    try {
                                        accessibleField.set(ObjectTableModel.this.toEdit, view.getObjectReplacement());
                                    }
                                    catch (IllegalArgumentException ex) {
                                        AgentLogger.error("Couldn't save edited object: " + ex.getMessage(), ex);
                                    }
                                    catch (IllegalAccessException ex) {
                                        AgentLogger.error("Couldn't save edited object: " + ex.getMessage(), ex);
                                    }
                                }
                            }
                        }
                    });
                    return btn;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

