/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.process;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.util.ReflectionUtil;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SearchMainMethodsView
extends JDialog {
    private static final Logger logger = Logger.getLogger(SearchMainMethodsView.class);
    List<ChangeListener> changeListeners = new Vector<ChangeListener>();
    private JButton btnCancel;
    private JButton btnSelect;
    private JScrollPane jScrollPane1;
    private JList lstSearchMainClasses;

    public SearchMainMethodsView(Frame parent, boolean modal, ClassPool pool, List<String> classes) {
        super(parent, modal);
        this.initComponents();
        this.lstSearchMainClasses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = SearchMainMethodsView.this.lstSearchMainClasses.locationToIndex(e.getPoint());
                    logger.trace((Object)("Double clicked on Item " + index));
                    SearchMainMethodsView.this.select();
                }
            }
        });
        DefaultListModel<String> list = new DefaultListModel<String>();
        for (String clazz : classes) {
            try {
                CtClass c = pool.get(clazz);
                if (!ReflectionUtil.hasMainClass(c, pool)) continue;
                list.addElement(clazz);
            }
            catch (NotFoundException e) {
                logger.warn((Object)e);
            }
        }
        this.lstSearchMainClasses.setModel(list);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstSearchMainClasses = new JList();
        this.btnCancel = new JButton();
        this.btnSelect = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(SearchMainMethodsView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.lstSearchMainClasses.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstSearchMainClasses.setName("lstSearchMainClasses");
        this.jScrollPane1.setViewportView(this.lstSearchMainClasses);
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(SearchMainMethodsView.class, (Object)this);
        this.btnCancel.setAction(actionMap.get("cancel"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnSelect.setAction(actionMap.get("select"));
        this.btnSelect.setText(resourceMap.getString("btnSelect.text", new Object[0]));
        this.btnSelect.setName("btnSelect");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnCancel).addGap(18, 18, 18).addComponent(this.btnSelect))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 237, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelect).addComponent(this.btnCancel)).addContainerGap()));
        this.pack();
    }

    void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Action
    public void select() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this.lstSearchMainClasses.getSelectedValue()));
        }
        this.setVisible(false);
    }

    @Action
    public void cancel() {
        this.setVisible(false);
    }
}

