/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper.bytearray;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AsciiArrayTableModel
extends AbstractTableModel {
    private byte[] bytes;
    private static Class[] columnTypes = new Class[]{Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class, Character.class};
    private static String[] columnNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private JTable mirrorTable;

    public AsciiArrayTableModel(JTable mirrorTable, byte[] bytes) {
        this.bytes = bytes;
        this.mirrorTable = mirrorTable;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return columnTypes[column];
    }

    @Override
    public int getRowCount() {
        boolean isRemainder;
        int rows = this.bytes.length / 16;
        boolean bl = isRemainder = this.bytes.length % 16 != 0;
        if (isRemainder) {
            ++rows;
        }
        return rows;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public void setValueAt(Object o, int rowIndex, int columnIndex) {
        int offset = rowIndex * 16 + columnIndex;
        if (o != null) {
            this.bytes[offset] = Byte.parseByte("" + (Character)o);
            this.mirrorTable.updateUI();
            this.mirrorTable.repaint();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int offset = rowIndex * 16 + columnIndex;
        if (offset >= this.bytes.length) {
            return null;
        }
        return Character.valueOf((char)this.bytes[offset]);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }
}

