/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.PrintWriter;
import java.util.List;
import javassist.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.StackMapTable;

public class ClassFileWriter {
    public static void print(ClassFile cf) {
        ClassFileWriter.print(cf, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile cf, PrintWriter out) {
        int acc;
        int i;
        int mod = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out.println("major: " + cf.major + ", minor: " + cf.minor + " modifiers: " + Integer.toHexString(cf.getAccessFlags()));
        out.println(String.valueOf(Modifier.toString(mod)) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        String[] infs = cf.getInterfaces();
        if (infs != null && infs.length > 0) {
            out.print("    implements ");
            out.print(infs[0]);
            i = 1;
            while (i < infs.length) {
                out.print(", " + infs[i]);
                ++i;
            }
            out.println();
        }
        out.println();
        List list = cf.getFields();
        int n = list.size();
        i = 0;
        while (i < n) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            acc = finfo.getAccessFlags();
            out.println(String.valueOf(Modifier.toString(AccessFlag.toModifier(acc))) + " " + finfo.getName() + "\t" + finfo.getDescriptor());
            ClassFileWriter.printAttributes(finfo.getAttributes(), out, 'f');
            ++i;
        }
        out.println();
        list = cf.getMethods();
        n = list.size();
        i = 0;
        while (i < n) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            acc = minfo.getAccessFlags();
            out.println(String.valueOf(Modifier.toString(AccessFlag.toModifier(acc))) + " " + minfo.getName() + "\t" + minfo.getDescriptor());
            ClassFileWriter.printAttributes(minfo.getAttributes(), out, 'm');
            out.println();
            ++i;
        }
        out.println();
        ClassFileWriter.printAttributes(cf.getAttributes(), out, 'c');
    }

    static void printAttributes(List list, PrintWriter out, char kind) {
        if (list == null) {
            return;
        }
        int n = list.size();
        int i = 0;
        while (i < n) {
            AttributeInfo ai = (AttributeInfo)list.get(i);
            if (ai instanceof CodeAttribute) {
                CodeAttribute ca = (CodeAttribute)ai;
                out.println("attribute: " + ai.getName() + ": " + ai.getClass().getName());
                out.println("max stack " + ca.getMaxStack() + ", max locals " + ca.getMaxLocals() + ", " + ca.getExceptionTable().size() + " catch blocks");
                out.println("<code attribute begin>");
                ClassFileWriter.printAttributes(ca.getAttributes(), out, kind);
                out.println("<code attribute end>");
            } else if (ai instanceof StackMapTable) {
                out.println("<stack map table begin>");
                StackMapTable.Printer.print((StackMapTable)ai, out);
                out.println("<stack map table end>");
            } else if (ai instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)ai;
                String sig = sa.getSignature();
                out.println("signature: " + sig);
                try {
                    String s = kind == 'c' ? SignatureAttribute.toClassSignature(sig).toString() : (kind == 'm' ? SignatureAttribute.toMethodSignature(sig).toString() : SignatureAttribute.toFieldSignature(sig).toString());
                    out.println("           " + s);
                }
                catch (BadBytecode e) {
                    out.println("           syntax error");
                }
            } else {
                out.println("attribute: " + ai.getName() + " (" + ai.get().length + " byte): " + ai.getClass().getName());
            }
            ++i;
        }
    }
}

