/*
 * Decompiled with CFR 0.152.
 */
package javassist.util.proxy;

import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

class SerializedProxy
implements Serializable {
    private String superClass;
    private String[] interfaces;
    private MethodFilter filter;
    private MethodHandler handler;

    SerializedProxy(Class proxy, MethodFilter f, MethodHandler h) {
        this.filter = f;
        this.handler = h;
        this.superClass = proxy.getSuperclass().getName();
        Class<?>[] infs = proxy.getInterfaces();
        int n = infs.length;
        this.interfaces = new String[n - 1];
        String setterInf = ProxyObject.class.getName();
        int i = 0;
        while (i < n) {
            String name = infs[i].getName();
            if (!name.equals(setterInf)) {
                this.interfaces[i] = name;
            }
            ++i;
        }
    }

    protected Class loadClass(final String className) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(className, true, cl);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot load the class: " + className, pae.getException());
        }
    }

    Object readResolve() throws ObjectStreamException {
        try {
            int n = this.interfaces.length;
            Class[] infs = new Class[n];
            int i = 0;
            while (i < n) {
                infs[i] = this.loadClass(this.interfaces[i]);
                ++i;
            }
            ProxyFactory f = new ProxyFactory();
            f.setSuperclass(this.loadClass(this.superClass));
            f.setInterfaces(infs);
            f.setFilter(this.filter);
            f.setHandler(this.handler);
            return f.createClass().newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidClassException(e.getMessage());
        }
        catch (InstantiationException e2) {
            throw new InvalidObjectException(e2.getMessage());
        }
        catch (IllegalAccessException e3) {
            throw new InvalidClassException(e3.getMessage());
        }
    }
}

