% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeVersion.R
\name{removeVersion}
\alias{removeVersion}
\title{Remove a version of an asset}
\usage{
removeVersion(project, asset, version, url = restUrl(), token = accessToken())
}
\arguments{
\item{project}{String containing the project to remove.}

\item{asset}{String containing the asset to remove.}

\item{version}{String containing the version of the asset to remove.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a gypsum administrator account.}
}
\value{
\code{NULL} is invisibly returned if the project or its contents was successfully removed.
}
\description{
Remove a version of an asset from the gypsum backend.
}
\examples{
if (interactive()) {
    # Mocking up a versioned asset.
    init <- startUpload(
        project="test-R", 
        asset="removal", 
        version="v1", 
        files=character(0),
        probation=TRUE
    )
    completeUpload(init) 

    removeVersion("test-R", asset="removal", version="v1")
}
}
\seealso{
\code{\link{removeAsset}} and \code{\link{removeProject}}, to remove an asset or project.
}
\author{
Aaron Lun
}
