(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  This mixin provides an 'ajax' method that can be used to perform ajax requests that
  respect Discourse paths and the run loop.
**/

var _trackView = false;
var _transientHeader = null;

Discourse.Ajax = Em.Mixin.create({

  setTransientHeader: function(k, v) {
    _transientHeader = {key: k, value: v};
  },

  viewTrackingRequired: function() {
    _trackView = true;
  },

  /**
    Our own $.ajax method. Makes sure the .then method executes in an Ember runloop
    for performance reasons. Also automatically adjusts the URL to support installs
    in subfolders.

    @method ajax
  **/
  ajax: function() {
    var url, args;
    var ajax;

    if (arguments.length === 1) {
      if (typeof arguments[0] === "string") {
        url = arguments[0];
        args = {};
      } else {
        args = arguments[0];
        url = args.url;
        delete args.url;
      }
    } else if (arguments.length === 2) {
      url = arguments[0];
      args = arguments[1];
    }

    if (args.success || args.error) {
      throw "Discourse.ajax should use promises";
    }

    var performAjax = function(resolve, reject) {

      args.headers = args.headers || {};

      if (_transientHeader) {
        args.headers[_transientHeader.key] = _transientHeader.value;
        _transientHeader = null;
      }

      if (_trackView && (!args.type || args.type === "GET")) {
        _trackView = false;
        // DON'T CHANGE: rack is prepending "HTTP_" in the header's name
        args.headers['Discourse-Track-View'] = "true";
      }

      args.success = function(data, textStatus, xhr) {
        if (xhr.getResponseHeader('Discourse-Readonly')) {
          Ember.run(function() {
            Discourse.Site.currentProp('isReadOnly', true);
          });
        }

        if (args.returnXHR) {
          data = { result: data, xhr: xhr };
        }

        Ember.run(null, resolve, data);
      };

      args.error = function(xhr, textStatus, errorThrown) {
        // note: for bad CSRF we don't loop an extra request right away.
        //  this allows us to eliminate the possibility of having a loop.
        if (xhr.status === 403 && xhr.responseText === "['BAD CSRF']") {
          Discourse.Session.current().set('csrfToken', null);
        }

        // If it's a parsererror, don't reject
        if (xhr.status === 200) return args.success(xhr);

        // Fill in some extra info
        xhr.jqTextStatus = textStatus;
        xhr.requestedUrl = url;

        Ember.run(null, reject, {
          jqXHR: xhr,
          textStatus: textStatus,
          errorThrown: errorThrown
        });
      };

      // We default to JSON on GET. If we don't, sometimes if the server doesn't return the proper header
      // it will not be parsed as an object.
      if (!args.type) args.type = 'GET';
      if (!args.dataType && args.type.toUpperCase() === 'GET') args.dataType = 'json';

      if (args.dataType === "script") {
        args.headers['Discourse-Script'] = true;
      }

      if (args.type === 'GET' && args.cache !== true) {
        args.cache = false;
      }

      ajax = $.ajax(Discourse.getURL(url), args);
    };

    var promise;

    // For cached pages we strip out CSRF tokens, need to round trip to server prior to sending the
    //  request (bypass for GET, not needed)
    if(args.type && args.type.toUpperCase() !== 'GET' && !Discourse.Session.currentProp('csrfToken')){
      promise = new Ember.RSVP.Promise(function(resolve, reject){
        ajax = $.ajax(Discourse.getURL('/session/csrf'), {cache: false})
           .success(function(result){
              Discourse.Session.currentProp('csrfToken', result.csrf);
              performAjax(resolve, reject);
           });
      });
    } else {
      promise = new Ember.RSVP.Promise(performAjax);
    }

    promise.abort = function(){
      if (ajax) {
        ajax.abort();
      }
    };

    return promise;
  }

});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/*global Favcount:true*/

var DiscourseResolver = require('discourse/ember/resolver').default;

// Allow us to import Ember
define('ember', ['exports'], function(__exports__) {
  __exports__.default = Ember;
});

var _pluginCallbacks = [];

window.Discourse = Ember.Application.extend(Discourse.Ajax, {
  rootElement: '#main',
  _docTitle: document.title,
  __TAGS_INCLUDED__: true,

  getURL: function(url) {
    if (!url) return url;

    // if it's a non relative URL, return it.
    if (url !== '/' && !/^\/[^\/]/.test(url)) return url;

    if (url.indexOf(Discourse.BaseUri) !== -1) return url;
    if (url[0] !== "/") url = "/" + url;

    return Discourse.BaseUri + url;
  },

  getURLWithCDN: function(url) {
    url = this.getURL(url);
    // only relative urls
    if (Discourse.CDN && /^\/[^\/]/.test(url)) {
      url = Discourse.CDN + url;
    } else if (Discourse.S3CDN) {
      url = url.replace(Discourse.S3BaseUrl, Discourse.S3CDN);
    }
    return url;
  },

  Resolver: DiscourseResolver,

  _titleChanged: function() {
    var title = this.get('_docTitle') || Discourse.SiteSettings.title;

    // if we change this we can trigger changes on document.title
    // only set if changed.
    if($('title').text() !== title) {
      $('title').text(title);
    }

    var notifyCount = this.get('notifyCount');
    if (notifyCount > 0 && !Discourse.User.currentProp('dynamic_favicon')) {
      title = "(" + notifyCount + ") " + title;
    }

    document.title = title;
  }.observes('_docTitle', 'hasFocus', 'notifyCount'),

  faviconChanged: function() {
    if(Discourse.User.currentProp('dynamic_favicon')) {
      var url = Discourse.SiteSettings.favicon_url;
      if (/^http/.test(url)) {
        url = Discourse.getURL("/favicon/proxied?" + encodeURIComponent(url));
      }
      new Favcount(url).set(
        this.get('notifyCount')
      );
    }
  }.observes('notifyCount'),

  // The classes of buttons to show on a post
  postButtons: function() {
    return Discourse.SiteSettings.post_menu.split("|").map(function(i) {
      return i.replace(/\+/, '').capitalize();
    });
  }.property(),

  notifyTitle: function(count) {
    this.set('notifyCount', count);
  },

  notifyBackgroundCountIncrement: function() {
    if (!this.get('hasFocus')) {
      this.set('backgroundNotify', true);
      this.set('notifyCount', (this.get('notifyCount') || 0) + 1);
    }
  },

  resetBackgroundNotifyCount: function() {
    if (this.get('hasFocus') && this.get('backgroundNotify')) {
      this.set('notifyCount', 0);
    }
    this.set('backgroundNotify', false);
  }.observes('hasFocus'),

  authenticationComplete: function(options) {
    // TODO, how to dispatch this to the controller without the container?
    var loginController = Discourse.__container__.lookup('controller:login');
    return loginController.authenticationComplete(options);
  },

  /**
    Start up the Discourse application by running all the initializers we've defined.

    @method start
  **/
  start: function() {

    $('noscript').remove();

    Object.keys(requirejs._eak_seen).forEach(function(key) {
      if (/\/pre\-initializers\//.test(key)) {
        var module = require(key, null, null, true);
        if (!module) { throw new Error(key + ' must export an initializer.'); }
        Discourse.initializer(module.default);
      }
    });

    Object.keys(requirejs._eak_seen).forEach(function(key) {
      if (/\/initializers\//.test(key)) {
        var module = require(key, null, null, true);
        if (!module) { throw new Error(key + ' must export an initializer.'); }

        var init = module.default;
        var oldInitialize = init.initialize;
        init.initialize = function(app) {
          oldInitialize.call(this, app.container, Discourse);
        };

        Discourse.instanceInitializer(init);
      }
    });

    // Plugins that are registered via `<script>` tags.
    var withPluginApi = require('discourse/lib/plugin-api').withPluginApi;
    var initCount = 0;
    _pluginCallbacks.forEach(function(cb) {
      Discourse.instanceInitializer({
        name: "_discourse_plugin_" + (++initCount),
        after: 'inject-objects',
        initialize: function() {
          withPluginApi(cb.version, cb.code);
        }
      });
    });
  },

  requiresRefresh: function(){
    var desired = Discourse.get("desiredAssetVersion");
    return desired && Discourse.get("currentAssetVersion") !== desired;
  }.property("currentAssetVersion", "desiredAssetVersion"),

  _registerPluginCode: function(version, code) {
    _pluginCallbacks.push({ version: version, code: code });
  },

  assetVersion: Ember.computed({
    get: function() {
      return this.get("currentAssetVersion");
    },
    set: function(key, val) {
      if(val) {
        if (this.get("currentAssetVersion")) {
          this.set("desiredAssetVersion", val);
        } else {
          this.set("currentAssetVersion", val);
        }
      }
      return this.get("currentAssetVersion");
    }
  })
}).create();

function RemovedObject(name) {
  this._removedName = name;
}

function methodMissing() {
  console.warn("The " + this._removedName + " object has been removed from Discourse " +
               "and your plugin needs to be updated.");
};

Discourse.RemovedObject = RemovedObject;

['reopen', 'registerButton', 'on', 'off'].forEach(function(m) { RemovedObject.prototype[m] = methodMissing; });

['discourse/views/post', 'discourse/components/post-menu'].forEach(function(moduleName) {
  define(moduleName, [], function() { return new RemovedObject(moduleName); });
});



// IIFE Wrapped Content Ends

 })(this);
define("ember-addons/utils/extract-value", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = extractValue;

    function extractValue(desc) {
      return desc.value || typeof desc.initializer === 'function' && desc.initializer();
    }
  });
define("ember-addons/utils/handle-descriptor", 
  ["ember","./extract-value","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";


    __exports__["default"] = handleDescriptor;

    var Ember = __dependency1__["default"];
    var extractValue = __dependency2__["default"];

    var computed = Ember.computed;
    var get = Ember.get;

    function handleDescriptor(target, key, desc) {
      var params = arguments.length <= 3 || arguments[3] === undefined ? [] : arguments[3];

      return {
        enumerable: desc.enumerable,
        configurable: desc.configurable,
        writeable: desc.writeable,
        initializer: function () {
          var computedDescriptor = undefined;

          if (desc.writable) {
            var val = extractValue(desc);
            if (typeof val === 'object') {
              var value = {};
              if (val.get) {
                value.get = callUserSuppliedGet(params, val.get);
              }
              if (val.set) {
                value.set = callUserSuppliedSet(params, val.set);
              }
              computedDescriptor = value;
            } else {
              computedDescriptor = callUserSuppliedGet(params, val);
            }
          } else {
            throw new Error('ember-computed-decorators does not support using getters and setters');
          }

          return computed.apply(null, params.concat(computedDescriptor));
        }
      };
    }

    function niceAttr(attr) {
      var parts = attr.split('.');
      var i = undefined;

      for (i = 0; i < parts.length; i++) {
        if (parts[i] === '@each' || parts[i] === '[]' || parts[i].indexOf('{') !== -1) {
          break;
        }
      }

      return parts.slice(0, i).join('.');
    }

    function callUserSuppliedGet(params, func) {
      params = params.map(niceAttr);
      return function () {
        var _this = this;

        var paramValues = params.map(function (p) {
          return get(_this, p);
        });

        return func.apply(this, paramValues);
      };
    }

    function callUserSuppliedSet(params, func) {
      params = params.map(niceAttr);
      return function (key, value) {
        var _this2 = this;

        var paramValues = params.map(function (p) {
          return get(_this2, p);
        });
        paramValues.unshift(value);

        return func.apply(this, paramValues);
      };
    }
  });
define("ember-addons/utils/is-descriptor", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = isDescriptor;

    function isDescriptor(item) {
      return item && typeof item === 'object' && 'writable' in item && 'enumerable' in item && 'configurable' in item;
    }
  });
define("ember-addons/decorator-alias", 
  ["./utils/extract-value","exports"],
  function(__dependency1__, __exports__) {
    "use strict";


    __exports__["default"] = decoratorAlias;
    var extractValue = __dependency1__["default"];
    function decoratorAlias(fn, errorMessage) {
      return function () {
        for (var _len = arguments.length, params = Array(_len), _key = 0; _key < _len; _key++) {
          params[_key] = arguments[_key];
        }

        // determine if user called as @computed('blah', 'blah') or @computed
        if (params.length === 0) {
          throw new Error(errorMessage);
        } else {
          return function (target, key, desc) {
            return {
              enumerable: desc.enumerable,
              configurable: desc.configurable,
              writable: desc.writable,
              initializer: function () {
                var value = extractValue(desc);
                return fn.apply(null, params.concat(value));
              }
            };
          };
        }
      };
    }
  });
define("ember-addons/macro-alias", 
  ["./utils/is-descriptor","exports"],
  function(__dependency1__, __exports__) {
    "use strict";


    __exports__["default"] = macroAlias;

    function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

    var isDescriptor = __dependency1__["default"];

    function handleDescriptor(target, property, desc, fn) {
      var params = arguments.length <= 4 || arguments[4] === undefined ? [] : arguments[4];

      return {
        enumerable: desc.enumerable,
        configurable: desc.configurable,
        writable: desc.writable,
        initializer: function () {
          return fn.apply(undefined, _toConsumableArray(params));
        }
      };
    }
    function macroAlias(fn) {
      return function () {
        for (var _len = arguments.length, params = Array(_len), _key = 0; _key < _len; _key++) {
          params[_key] = arguments[_key];
        }

        if (isDescriptor(params[params.length - 1])) {
          return handleDescriptor.apply(undefined, params.concat([fn]));
        } else {
          return function (target, property, desc) {
            return handleDescriptor(target, property, desc, fn, params);
          };
        }
      };
    }
  });
define("ember-addons/ember-computed-decorators", 
  ["./utils/handle-descriptor","./utils/is-descriptor","./utils/extract-value","./decorator-alias","./macro-alias","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    var _slice = Array.prototype.slice;

    __exports__["default"] = computedDecorator;

    __exports__.readOnly = readOnly;
    var handleDescriptor = __dependency1__["default"];
    var isDescriptor = __dependency2__["default"];
    var extractValue = __dependency3__["default"];

    var decoratorAlias = __dependency4__["default"];

    var macroAlias = __dependency5__["default"];

    function computedDecorator() {
      for (var _len = arguments.length, params = Array(_len), _key = 0; _key < _len; _key++) {
        params[_key] = arguments[_key];
      }

      // determine if user called as @computed('blah', 'blah') or @computed
      if (isDescriptor(params[params.length - 1])) {
        return handleDescriptor.apply(undefined, arguments);
      } else {
        return function () /* target, key, desc */{
          return handleDescriptor.apply(undefined, _slice.call(arguments).concat([params]));
        };
      }
    }

    function readOnly(target, name, desc) {
      return {
        writable: false,
        enumerable: desc.enumerable,
        configurable: desc.configurable,
        initializer: function () {
          var value = extractValue(desc);
          return value.readOnly();
        }
      };
    }

    var on = decoratorAlias(Ember.on, 'Can not `on` without event names');
    __exports__.on = on;
    var observes = decoratorAlias(Ember.observer, 'Can not `observe` without property names');__exports__.observes = observes;
    var alias = macroAlias(Ember.computed.alias);
    __exports__.alias = alias;
    var and = macroAlias(Ember.computed.and);
    __exports__.and = and;
    var bool = macroAlias(Ember.computed.bool);
    __exports__.bool = bool;
    var collect = macroAlias(Ember.computed.collect);
    __exports__.collect = collect;
    var empty = macroAlias(Ember.computed.empty);
    __exports__.empty = empty;
    var equal = macroAlias(Ember.computed.equal);
    __exports__.equal = equal;
    var filter = macroAlias(Ember.computed.filter);
    __exports__.filter = filter;
    var filterBy = macroAlias(Ember.computed.filterBy);
    __exports__.filterBy = filterBy;
    var gt = macroAlias(Ember.computed.gt);
    __exports__.gt = gt;
    var gte = macroAlias(Ember.computed.gte);
    __exports__.gte = gte;
    var lt = macroAlias(Ember.computed.lt);
    __exports__.lt = lt;
    var lte = macroAlias(Ember.computed.lte);
    __exports__.lte = lte;
    var map = macroAlias(Ember.computed.map);
    __exports__.map = map;
    var mapBy = macroAlias(Ember.computed.mapBy);
    __exports__.mapBy = mapBy;
    var match = macroAlias(Ember.computed.match);
    __exports__.match = match;
    var max = macroAlias(Ember.computed.max);
    __exports__.max = max;
    var min = macroAlias(Ember.computed.min);
    __exports__.min = min;
    var none = macroAlias(Ember.computed.none);
    __exports__.none = none;
    var not = macroAlias(Ember.computed.not);
    __exports__.not = not;
    var notEmpty = macroAlias(Ember.computed.notEmpty);
    __exports__.notEmpty = notEmpty;
    var oneWay = macroAlias(Ember.computed.oneWay);
    __exports__.oneWay = oneWay;
    var or = macroAlias(Ember.computed.or);
    __exports__.or = or;
    var readOnly = macroAlias(Ember.computed.readOnly);
    __exports__.readOnly = readOnly;
    var reads = macroAlias(Ember.computed.reads);
    __exports__.reads = reads;
    var setDiff = macroAlias(Ember.computed.setDiff);
    __exports__.setDiff = setDiff;
    var sort = macroAlias(Ember.computed.sort);
    __exports__.sort = sort;
    var sum = macroAlias(Ember.computed.sum);
    __exports__.sum = sum;
    var union = macroAlias(Ember.computed.union);
    __exports__.union = union;
    var uniq = macroAlias(Ember.computed.uniq);
    __exports__.uniq = uniq;
  });
define("discourse/lib/hash", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.hashString = hashString;
    /*eslint no-bitwise:0 */

    // Note: before changing this be aware the same algo is used server side for avatars.

    function hashString(str) {
      var hash = 0;
      for (var i = 0; i < str.length; i++) {
        hash = (hash << 5) - hash + str.charCodeAt(i);
        hash |= 0;
      }
      return hash;
    }
  });
define("discourse/lib/load-script", 
  ["exports"],
  function(__exports__) {
    "use strict";


    __exports__["default"] = loadScript;
    /* global assetPath */

    var _loaded = {};
    var _loading = {};

    function loadWithTag(path, cb) {
      var head = document.getElementsByTagName('head')[0];

      var s = document.createElement('script');
      s.src = path;
      if (Ember.Test) {
        Ember.Test.pendingAjaxRequests++;
      }
      head.appendChild(s);

      s.onload = s.onreadystatechange = function (_, abort) {
        if (Ember.Test) {
          Ember.Test.pendingAjaxRequests--;
        }
        if (abort || !s.readyState || s.readyState === "loaded" || s.readyState === "complete") {
          s = s.onload = s.onreadystatechange = null;
          if (!abort) {
            Ember.run(null, cb);
          }
        }
      };
    }
    function loadScript(url, opts) {
      opts = opts || {};

      return new Ember.RSVP.Promise(function (resolve) {
        url = Discourse.getURL(assetPath && assetPath(url) || url);

        // If we already loaded this url
        if (_loaded[url]) {
          return resolve();
        }
        if (_loading[url]) {
          return _loading[url].then(resolve);
        }

        var done;
        _loading[url] = new Ember.RSVP.Promise(function (_done) {
          done = _done;
        });

        _loading[url].then(function () {
          delete _loading[url];
        });

        var cb = function () {
          _loaded[url] = true;
          done();
          resolve();
        };

        var cdnUrl = url;

        // Scripts should always load from CDN
        if (Discourse.CDN && url[0] === "/" && url[1] !== "/") {
          cdnUrl = Discourse.CDN.replace(/\/$/, "") + url;
        }

        // Some javascript depends on the path of where it is loaded (ace editor)
        // to dynamically load more JS. In that case, add the `scriptTag: true`
        // option.
        if (opts.scriptTag) {
          loadWithTag(cdnUrl, cb);
        } else {
          Discourse.ajax({ url: cdnUrl, dataType: "script", cache: true }).then(cb);
        }
      });
    }
  });
define("discourse/lib/notification-levels", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = {
      WATCHING: 3,
      TRACKING: 2,
      REGULAR: 1,
      MUTED: 0
    };
  });
define("discourse/lib/app-events", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Object.extend(Ember.Evented);
  });
define("discourse/lib/url", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /*global LockOn:true*/

    var _jumpScheduled = false;
    var rewrites = [];

    var DiscourseURL = Ember.Object.extend({

      // Used for matching a topic
      TOPIC_REGEXP: /\/t\/([^\/]+)\/(\d+)\/?(\d+)?/,

      isJumpScheduled: function () {
        return _jumpScheduled;
      },

      // Jumps to a particular post in the stream
      jumpToPost: function (postNumber, opts) {
        var holderId = '#post_' + postNumber;
        var offset = function () {
          var $header = $('header');
          var $title = $('#topic-title');
          var windowHeight = $(window).height() - $title.height();
          var expectedOffset = $title.height() - $header.find('.contents').height() + windowHeight / 5;

          return $header.outerHeight(true) + (expectedOffset < 0 ? 0 : expectedOffset);
        };

        Em.run.schedule('afterRender', function () {
          if (postNumber === 1) {
            $(window).scrollTop(0);
            return;
          }

          var lockon = new LockOn(holderId, { offsetCalculator: offset });
          var holder = $(holderId);

          if (holder.length > 0 && opts && opts.skipIfOnScreen) {
            // if we are on screen skip
            var elementTop = lockon.elementTop(),
                scrollTop = $(window).scrollTop(),
                windowHeight = $(window).height() - offset(),
                height = holder.height();

            if (elementTop > scrollTop && elementTop + height < scrollTop + windowHeight) {
              return;
            }
          }

          lockon.lock();
        });
      },

      /**
        Browser aware replaceState. Will only be invoked if the browser supports it.
         @method replaceState
        @param {String} path The path we are replacing our history state with.
      **/
      replaceState: function (path) {
        if (window.history && window.history.pushState && window.history.replaceState && !navigator.userAgent.match(/((iPod|iPhone|iPad).+\bOS\s+[1-4]|WebApps\/.+CFNetwork)/) && window.location.pathname !== path) {

          // Always use replaceState in the next runloop to prevent weird routes changing
          // while URLs are loading. For example, while a topic loads it sets `currentPost`
          // which triggers a replaceState even though the topic hasn't fully loaded yet!
          Em.run.next(function () {
            var location = DiscourseURL.get('router.location');
            if (location && location.replaceURL) {
              location.replaceURL(path);
            }
          });
        }
      },

      // Scroll to the same page, different anchor
      scrollToId: function (id) {
        if (Em.isEmpty(id)) {
          return;
        }

        _jumpScheduled = true;
        Em.run.schedule('afterRender', function () {
          var $elem = $(id);
          if ($elem.length === 0) {
            $elem = $("[name='" + id.replace('#', '') + "']");
          }
          if ($elem.length > 0) {
            $('html,body').scrollTop($elem.offset().top - $('header').height() - 15);
            _jumpScheduled = false;
          }
        });
      },

      routeToTag: function (a) {
        if (a && a.host !== document.location.host) {
          document.location = a.href;
          return false;
        }

        return this.routeTo(a.href);
      },

      /**
        Our custom routeTo method is used to intelligently overwrite default routing
        behavior.
         It contains the logic necessary to route within a topic using replaceState to
        keep the history intact.
      **/
      routeTo: function (path, opts) {
        if (Em.isEmpty(path)) {
          return;
        }

        if (Discourse.get('requiresRefresh')) {
          document.location.href = Discourse.getURL(path);
          return;
        }

        // Protocol relative URLs
        if (path.indexOf('//') === 0) {
          document.location = path;
          return;
        }

        // Scroll to the same page, different anchor
        if (path.indexOf('#') === 0) {
          this.scrollToId(path);
          this.replaceState(path);
          return;
        }

        var oldPath = window.location.pathname;
        path = path.replace(/(https?\:)?\/\/[^\/]+/, '');

        // handle prefixes
        if (path.match(/^\//)) {
          var rootURL = Discourse.BaseUri === undefined ? "/" : Discourse.BaseUri;
          rootURL = rootURL.replace(/\/$/, '');
          path = path.replace(rootURL, '');
        }

        // Rewrite /my/* urls
        if (path.indexOf('/my/') === 0) {
          var currentUser = Discourse.User.current();
          if (currentUser) {
            path = path.replace('/my/', '/users/' + currentUser.get('username_lower') + "/");
          } else {
            document.location.href = "/404";
            return;
          }
        }

        rewrites.forEach(function (rw) {
          return path = path.replace(rw.regexp, rw.replacement);
        });

        if (this.navigatedToPost(oldPath, path)) {
          return;
        }
        // Schedule a DOM cleanup event
        Em.run.scheduleOnce('afterRender', Discourse.Route, 'cleanDOM');

        // TODO: Extract into rules we can inject into the URL handler
        if (this.navigatedToHome(oldPath, path)) {
          return;
        }

        if (oldPath === path) {
          // If navigating to the same path send an app event. Views can watch it
          // and tell their controllers to refresh
          this.appEvents.trigger('url:refresh');
        }

        return this.handleURL(path, opts);
      },

      rewrite: function (regexp, replacement) {
        rewrites.push({ regexp: regexp, replacement: replacement });
      },

      redirectTo: function (url) {
        window.location = Discourse.getURL(url);
      },

      /**
       * Determines whether a URL is internal or not
       *
       * @method isInternal
       * @param {String} url
      **/
      isInternal: function (url) {
        if (url && url.length) {
          if (url.indexOf('//') === 0) {
            url = "http:" + url;
          }
          if (url.indexOf('#') === 0) {
            return true;
          }
          if (url.indexOf('/') === 0) {
            return true;
          }
          if (url.indexOf(this.origin()) === 0) {
            return true;
          }
          if (url.replace(/^http/, 'https').indexOf(this.origin()) === 0) {
            return true;
          }
          if (url.replace(/^https/, 'http').indexOf(this.origin()) === 0) {
            return true;
          }
        }
        return false;
      },

      /**
        @private
         If the URL is in the topic form, /t/something/:topic_id/:post_number
        then we want to apply some special logic. If the post_number changes within the
        same topic, use replaceState and instruct our controller to load more posts.
         @method navigatedToPost
        @param {String} oldPath the previous path we were on
        @param {String} path the path we're navigating to
      **/
      navigatedToPost: function (oldPath, path) {
        var _this = this;

        var newMatches = this.TOPIC_REGEXP.exec(path);
        var newTopicId = newMatches ? newMatches[2] : null;

        if (newTopicId) {
          var oldMatches = this.TOPIC_REGEXP.exec(oldPath);
          var oldTopicId = oldMatches ? oldMatches[2] : null;

          // If the topic_id is the same
          if (oldTopicId === newTopicId) {
            var _ret = (function () {
              DiscourseURL.replaceState(path);

              var container = Discourse.__container__;
              var topicController = container.lookup('controller:topic');
              var opts = {};
              var postStream = topicController.get('model.postStream');

              if (newMatches[3]) {
                opts.nearPost = newMatches[3];
              }
              if (path.match(/last$/)) {
                opts.nearPost = topicController.get('model.highest_post_number');
              }
              var closest = opts.nearPost || 1;

              opts.cancelSummary = true;

              postStream.refresh(opts).then(function () {
                topicController.setProperties({
                  'model.currentPost': closest,
                  enteredAt: new Date().getTime().toString()
                });

                var closestPost = postStream.closestPostForPostNumber(closest);
                var progress = postStream.progressIndexOfPost(closestPost);
                var progressController = container.lookup('controller:topic-progress');

                progressController.set('progressPosition', progress);
                _this.appEvents.trigger('post:highlight', closest);
              }).then(function () {
                DiscourseURL.jumpToPost(closest, { skipIfOnScreen: true });
              });

              // Abort routing, we have replaced our state.
              return {
                v: true
              };
            })();

            if (typeof _ret === 'object') return _ret.v;
          }
        }

        return false;
      },

      /**
        @private
         Handle the custom case of routing to the root path from itself.
         @param {String} oldPath the previous path we were on
        @param {String} path the path we're navigating to
      **/
      navigatedToHome: function (oldPath, path) {
        var homepage = Discourse.Utilities.defaultHomepage();

        if (window.history && window.history.pushState && (path === "/" || path === "/" + homepage) && (oldPath === "/" || oldPath === "/" + homepage)) {
          this.appEvents.trigger('url:refresh');
          return true;
        }

        return false;
      },

      // This has been extracted so it can be tested.
      origin: function () {
        return window.location.origin + (Discourse.BaseUri === "/" ? '' : Discourse.BaseUri);
      },

      /**
        @private
         Get a handle on the application's router. Note that currently it uses `__container__` which is not
        advised but there is no other way to access the router.
         @property router
      **/
      router: (function () {
        return Discourse.__container__.lookup('router:main');
      }).property().volatile(),

      // Get a controller. Note that currently it uses `__container__` which is not
      // advised but there is no other way to access the router.
      controllerFor: function (name) {
        return Discourse.__container__.lookup('controller:' + name);
      },

      /**
        Be wary of looking up the router. In this case, we have links in our
        HTML, say form compiled markdown posts, that need to be routed.
      **/
      handleURL: function (path, opts) {
        opts = opts || {};

        var router = this.get('router');

        if (opts.replaceURL) {
          this.replaceState(path);
        } else {
          router.router.updateURL(path);
        }

        var split = path.split('#');
        var elementId = undefined;

        if (split.length === 2) {
          path = split[0];
          elementId = split[1];
        }

        var transition = router.handleURL(path);
        transition._discourse_intercepted = true;
        transition.promise.then(function () {
          if (elementId) {

            _jumpScheduled = true;
            Em.run.next('afterRender', function () {
              var offset = $('#' + elementId).offset();
              if (offset && offset.top) {
                $('html, body').scrollTop(offset.top - $('header').height() - 10);
                _jumpScheduled = false;
              }
            });
          }
        });
      }
    }).create();

    __exports__["default"] = DiscourseURL;
  });
define("discourse/lib/debounce", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
      Debounce a Javascript function. This means if it's called many times in a time limit it
      should only be executed once (at the end of the limit counted from the last call made).
      Original function will be called with the context and arguments from the last call made.
    **/

    __exports__["default"] = function (func, wait) {
      var self = undefined,
          args = undefined;
      var later = function () {
        func.apply(self, args);
      };

      return function () {
        self = this;
        args = arguments;

        Ember.run.debounce(null, later, wait);
      };
    }
  });
define("discourse/lib/quote", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = {

      REGEXP: /\[quote=([^\]]*)\]((?:[\s\S](?!\[quote=[^\]]*\]))*?)\[\/quote\]/im,

      // Build the BBCode quote around the selected text
      build: function (post, contents, opts) {
        var contents_hashed, result, sansQuotes, stripped, stripped_hashed, tmp;
        var full = opts && opts["full"];
        var raw = opts && opts["raw"];

        if (!post) {
          return "";
        }

        if (!contents) contents = "";

        sansQuotes = contents.replace(this.REGEXP, '').trim();
        if (sansQuotes.length === 0) {
          return "";
        }

        // Escape the content of the quote
        sansQuotes = sansQuotes.replace(/</g, "&lt;").replace(/>/g, "&gt;");

        result = "[quote=\"" + post.get('username') + ", post:" + post.get('post_number') + ", topic:" + post.get('topic_id');

        /* Strip the HTML from cooked */
        tmp = document.createElement('div');
        tmp.innerHTML = post.get('cooked');
        stripped = tmp.textContent || tmp.innerText || "";

        /*
          Let's remove any non alphanumeric characters as a kind of hash. Yes it's
          not accurate but it should work almost every time we need it to. It would be unlikely
          that the user would quote another post that matches in exactly this way.
        */
        stripped_hashed = stripped.replace(/[^a-zA-Z0-9]/g, '');
        contents_hashed = contents.replace(/[^a-zA-Z0-9]/g, '');

        /* If the quote is the full message, attribute it as such */
        if (full || stripped_hashed === contents_hashed) result += ", full:true";
        result += "\"]\n" + (raw ? contents : sansQuotes) + "\n[/quote]\n\n";

        return result;
      }

    };
  });
define("discourse/lib/key-value-store", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // A simple key value store that uses LocalStorage
    var safeLocalStorage = undefined;

    try {
      safeLocalStorage = localStorage;
      if (localStorage["disableLocalStorage"] === "true") {
        safeLocalStorage = null;
      } else {
        // makes sure we can write to the local storage
        safeLocalStorage["safeLocalStorage"] = true;
      }
    } catch (e) {
      // cookies disabled, we don't care
      safeLocalStorage = null;
    }

    var KeyValueStore = function (ctx) {
      this.context = ctx;
    };

    KeyValueStore.prototype = {
      abandonLocal: function () {
        if (!safeLocalStorage) {
          return;
        }

        var i = safeLocalStorage.length - 1;
        while (i >= 0) {
          var k = safeLocalStorage.key(i);
          if (k.substring(0, this.context.length) === this.context) {
            safeLocalStorage.removeItem(k);
          }
          i--;
        }
        return true;
      },

      remove: function (key) {
        if (!safeLocalStorage) {
          return;
        }
        return safeLocalStorage.removeItem(this.context + key);
      },

      set: function (opts) {
        if (!safeLocalStorage) {
          return false;
        }
        safeLocalStorage[this.context + opts.key] = opts.value;
      },

      setObject: function (opts) {
        this.set({ key: opts.key, value: JSON.stringify(opts.value) });
      },

      get: function (key) {
        if (!safeLocalStorage) {
          return null;
        }
        return safeLocalStorage[this.context + key];
      },

      getInt: function (key, def) {
        if (!def) {
          def = 0;
        }
        if (!safeLocalStorage) {
          return def;
        }
        var result = parseInt(this.get(key));
        if (!isFinite(result)) {
          return def;
        }
        return result;
      },

      getObject: function (key) {
        if (!safeLocalStorage) {
          return null;
        }
        try {
          return JSON.parse(safeLocalStorage[this.context + key]);
        } catch (e) {}
      }
    };

    // API compatibility with `localStorage`
    KeyValueStore.prototype.getItem = KeyValueStore.prototype.get;
    KeyValueStore.prototype.removeItem = KeyValueStore.prototype.remove;
    KeyValueStore.prototype.setItem = function (key, value) {
      this.set({ key: key, value: value });
    };

    __exports__["default"] = KeyValueStore;
  });
define("discourse/lib/helpers", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.htmlHelper = htmlHelper;
    __exports__.registerHelper = registerHelper;
    __exports__.registerUnbound = registerUnbound;
    // `Ember.Helper` is only available in versions after 1.12

    function htmlHelper(fn) {
      if (Ember.Helper) {
        return Ember.Helper.helper(function () {
          return new Handlebars.SafeString(fn.apply(this, Array.prototype.slice.call(arguments)) || '');
        });
      } else {
        return Ember.Handlebars.makeBoundHelper(function () {
          return new Handlebars.SafeString(fn.apply(this, Array.prototype.slice.call(arguments)) || '');
        });
      }
    }

    function registerHelper(name, fn) {
      Ember.HTMLBars._registerHelper(name, fn);
    }

    var get = Discourse.EmberCompatHandlebars.get;

    function resolveParams(ctx, options) {
      var params = {};
      var hash = options.hash;

      if (hash) {
        if (options.hashTypes) {
          Object.keys(hash).forEach(function (k) {
            var type = options.hashTypes[k];
            if (type === "STRING" || type === "StringLiteral") {
              params[k] = hash[k];
            } else if (type === "ID" || type === "PathExpression") {
              params[k] = get(ctx, hash[k], options);
            }
          });
        } else {
          params = hash;
        }
      }
      return params;
    }

    function registerUnbound(name, fn) {
      var func = function (property, options) {
        if (options.types && (options.types[0] === "ID" || options.types[0] === "PathExpression")) {
          property = get(this, property, options);
        }

        return fn.call(this, property, resolveParams(this, options));
      };

      Handlebars.registerHelper(name, func);
      Ember.Handlebars.registerHelper(name, func);
    }
  });
define("discourse/helpers/i18n", 
  ["discourse/lib/helpers"],
  function(__dependency1__) {
    "use strict";
    var registerUnbound = __dependency1__.registerUnbound;

    registerUnbound('i18n', function (key, params) {
      return I18n.t(key, params);
    });

    registerUnbound('replace-emoji', function (text) {
      return new Handlebars.SafeString(Discourse.Emoji.unescape(text));
    });
  });
define("discourse/helpers/fa-icon", 
  ["virtual-dom","discourse/lib/helpers","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.iconHTML = iconHTML;
    __exports__.iconNode = iconNode;
    var h = __dependency1__.h;
    var registerUnbound = __dependency2__.registerUnbound;

    function iconClasses(icon, params) {
      var classes = "fa fa-" + icon;
      if (params.modifier) {
        classes += " fa-" + params.modifier;
      }
      if (params['class']) {
        classes += ' ' + params['class'];
      }
      return classes;
    }

    function iconHTML(icon, params) {
      params = params || {};

      var html = "<i class='" + iconClasses(icon, params) + "'";
      if (params.label) {
        html += " aria-hidden='true'";
      }
      html += "></i>";
      if (params.label) {
        html += "<span class='sr-only'>" + I18n.t(params.label) + "</span>";
      }
      return html;
    }

    function iconNode(icon, params) {
      params = params || {};

      var properties = {
        className: iconClasses(icon, params),
        attributes: { "aria-hidden": true }
      };

      if (params.title) {
        properties.attributes.title = params.title;
      }

      if (params.label) {
        return h('i', properties, h('span.sr-only', I18n.t(params.label)));
      } else {
        return h('i', properties);
      }
    }

    registerUnbound('fa-icon', function (icon, params) {
      return new Handlebars.SafeString(iconHTML(icon, params));
    });
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

// keep IIF for simpler testing

// EmberCompatHandlebars is a mechanism for quickly rendering templates which is Ember aware
// templates are highly compatible with Ember so you don't need to worry about calling "get"
// and computed properties function, additionally it uses stringParams like Ember does

(function(){

  // compat with ie8 in case this gets picked up elsewhere
  var objectCreate = Object.create || function(parent) {
    function F() {}
    F.prototype = parent;
    return new F();
  };


  var RawHandlebars = Handlebars.create();

  RawHandlebars.helper = function() {};
  RawHandlebars.helpers = objectCreate(Handlebars.helpers);

  RawHandlebars.helpers.get = function(context, options){
    var firstContext =  options.contexts[0];
    var val = firstContext[context];

    if (val && val.isDescriptor) { return Em.get(firstContext, context); }
    val = val === undefined ? Em.get(firstContext, context): val;
    return val;
  };

  // adds compatability so this works with stringParams
  var stringCompatHelper = function(fn){

    var old = RawHandlebars.helpers[fn];
    RawHandlebars.helpers[fn] = function(context,options){
      return old.apply(this, [
          RawHandlebars.helpers.get(context,options),
          options
      ]);
    };
  };

  // #each .. in support (as format is transformed to this)
  RawHandlebars.registerHelper('each', function(localName,inKeyword,contextName,options){
    var list = Em.get(this, contextName);
    var output = [];
    var innerContext = Object.create(this);
    for (var i=0; i<list.length; i++) {
      innerContext[localName] = list[i];
      output.push(options.fn(innerContext));
    }
    return output.join('');
  });

  stringCompatHelper("if");
  stringCompatHelper("unless");
  stringCompatHelper("with");


  if (Handlebars.Compiler) {
    RawHandlebars.Compiler = function() {};
    RawHandlebars.Compiler.prototype = objectCreate(Handlebars.Compiler.prototype);
    RawHandlebars.Compiler.prototype.compiler = RawHandlebars.Compiler;

    RawHandlebars.JavaScriptCompiler = function() {};

    RawHandlebars.JavaScriptCompiler.prototype = objectCreate(Handlebars.JavaScriptCompiler.prototype);
    RawHandlebars.JavaScriptCompiler.prototype.compiler = RawHandlebars.JavaScriptCompiler;
    RawHandlebars.JavaScriptCompiler.prototype.namespace = "Discourse.EmberCompatHandlebars";

    function buildPath(blk, args) {

      var result = { type: "PathExpression",
                     data: false,
                     depth: blk.path.depth,
                     loc: blk.path.loc };

      // Server side precompile doesn't have jquery.extend
      Object.keys(args).forEach(function (a) {
        result[a] = args[a];
      });

      return result;
    }

    function replaceGet(ast) {
      var visitor = new Handlebars.Visitor();
      visitor.mutating = true;

      visitor.MustacheStatement = function(mustache) {
        if (!(mustache.params.length || mustache.hash)) {
          mustache.params[0] = mustache.path;
          mustache.path = buildPath(mustache, { parts: ['get'], original: 'get', strict: true, falsy: true });
        }
        return Handlebars.Visitor.prototype.MustacheStatement.call(this, mustache);
      };

      // rewrite `each x as |y|` as each y in x`
      // This allows us to use the same syntax in all templates
      visitor.BlockStatement = function(block) {
        if (block.path.original === 'each' && block.params.length === 1) {
          var paramName = block.program.blockParams[0];
          block.params = [ buildPath(block, { original: paramName }),
                           { type: "CommentStatement", value: "in" },
                           block.params[0] ];
          delete block.program.blockParams;
        }

        return Handlebars.Visitor.prototype.BlockStatement.call(this, block);
      };

      visitor.accept(ast);
    }

    RawHandlebars.precompile = function(value, asObject) {
      var ast = Handlebars.parse(value);
      replaceGet(ast);

      var options = {
        knownHelpers: {
          get: true
        },
        data: true,
        stringParams: true
      };

      asObject = asObject === undefined ? true : asObject;

      var environment = new RawHandlebars.Compiler().compile(ast, options);
      return new RawHandlebars.JavaScriptCompiler().compile(environment, options, undefined, asObject);
    };

    RawHandlebars.compile = function(string) {
      var ast = Handlebars.parse(string);
      replaceGet(ast);

      // this forces us to rewrite helpers
      var options = {  data: true, stringParams: true };
      var environment = new RawHandlebars.Compiler().compile(ast, options);
      var templateSpec = new RawHandlebars.JavaScriptCompiler().compile(environment, options, undefined, true);

      var template = RawHandlebars.template(templateSpec);
      template.isMethod = false;

      return template;
    };
  }

  RawHandlebars.get = function(ctx, property, options){
    if (options.types && options.data.view) {
      var view = options.data.view;
      return view.getStream ? view.getStream(property).value() : view.getAttr(property);
    } else {
      return Ember.get(ctx, property);
    }
  };

  Discourse.EmberCompatHandlebars = RawHandlebars;

})();


// IIFE Wrapped Content Ends

 })(this);
define("discourse/lib/computed", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.propertyEqual = propertyEqual;
    __exports__.propertyNotEqual = propertyNotEqual;
    __exports__.propertyGreaterThan = propertyGreaterThan;
    __exports__.propertyLessThan = propertyLessThan;
    __exports__.i18n = i18n;
    __exports__.fmt = fmt;
    __exports__.url = url;
    __exports__.endWith = endWith;
    __exports__.setting = setting;
    /**
      Returns whether two properties are equal to each other.

      @method propertyEqual
      @params {String} p1 the first property
      @params {String} p2 the second property
      @return {Function} computedProperty function
    **/

    function propertyEqual(p1, p2) {
      return Em.computed(function () {
        return this.get(p1) === this.get(p2);
      }).property(p1, p2);
    }

    /**
      Returns whether two properties are not equal to each other.

      @method propertyNotEqual
      @params {String} p1 the first property
      @params {String} p2 the second property
      @return {Function} computedProperty function
    **/

    function propertyNotEqual(p1, p2) {
      return Em.computed(function () {
        return this.get(p1) !== this.get(p2);
      }).property(p1, p2);
    }

    function propertyGreaterThan(p1, p2) {
      return Ember.computed(function () {
        return this.get(p1) > this.get(p2);
      }).property(p1, p2);
    }

    function propertyLessThan(p1, p2) {
      return Ember.computed(function () {
        return this.get(p1) < this.get(p2);
      }).property(p1, p2);
    }

    /**
      Returns i18n version of a string based on a property.

      @method i18n
      @params {String} properties* to format
      @params {String} format the i18n format string
      @return {Function} computedProperty function
    **/

    function i18n() {
      var args = Array.prototype.slice.call(arguments, 0);
      var format = args.pop();
      var computed = Em.computed(function () {
        var self = this;
        return I18n.t(format.fmt.apply(format, args.map(function (a) {
          return self.get(a);
        })));
      });
      return computed.property.apply(computed, args);
    }

    /**
      Uses an Ember String `fmt` call to format a string. See:
      http://emberjs.com/api/classes/Em.String.html#method_fmt

      @method fmt
      @params {String} properties* to format
      @params {String} format the format string
      @return {Function} computedProperty function
    **/

    function fmt() {
      var args = Array.prototype.slice.call(arguments, 0);
      var format = args.pop();
      var computed = Em.computed(function () {
        var self = this;
        return format.fmt.apply(format, args.map(function (a) {
          return self.get(a);
        }));
      });
      return computed.property.apply(computed, args);
    }

    /**
      Creates a URL using Discourse.getURL. It takes a fmt string just like
      fmt does.

      @method url
      @params {String} properties* to format
      @params {String} format the format string for the URL
      @return {Function} computedProperty function returning a URL
    **/

    function url() {
      var args = Array.prototype.slice.call(arguments, 0);
      var format = args.pop();
      var computed = Em.computed(function () {
        var self = this;
        return Discourse.getURL(format.fmt.apply(format, args.map(function (a) {
          return self.get(a);
        })));
      });
      return computed.property.apply(computed, args);
    }

    /**
      Returns whether properties end with a string

      @method endWith
      @params {String} properties* to check
      @params {String} substring the substring
      @return {Function} computedProperty function
    **/

    function endWith() {
      var args = Array.prototype.slice.call(arguments, 0);
      var substring = args.pop();
      var computed = Em.computed(function () {
        var self = this;
        return _.all(args.map(function (a) {
          return self.get(a);
        }), function (s) {
          var position = s.length - substring.length,
              lastIndex = s.lastIndexOf(substring);
          return lastIndex !== -1 && lastIndex === position;
        });
      });
      return computed.property.apply(computed, args);
    }

    /**
      Creates a property from a SiteSetting. In the future the plan is for them to
      be able to update when changed.

      @method setting
      @param {String} name of site setting
    **/

    function setting(name) {
      return Em.computed(function () {
        return Discourse.SiteSettings[name];
      }).property();
    }
  });
define("discourse/lib/formatter", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.shortDate = shortDate;
    __exports__.toTitleCase = toTitleCase;
    __exports__.longDate = longDate;
    __exports__.longDateNoYear = longDateNoYear;
    __exports__.updateRelativeAge = updateRelativeAge;
    __exports__.autoUpdatingRelativeAge = autoUpdatingRelativeAge;
    __exports__.relativeAge = relativeAge;
    __exports__.number = number;
    /* global BreakString:true */

    /*
    * memoize.js
    * by @philogb and @addyosmani
    * with further optimizations by @mathias
    * and @DmitryBaranovsk
    * perf tests: http://bit.ly/q3zpG3
    * Released under an MIT license.
    *
    * modified with cap by Sam
    */

    function cappedMemoize(fn, max) {
      fn.maxMemoize = max;
      fn.memoizeLength = 0;

      return function () {
        var args = Array.prototype.slice.call(arguments);
        var hash = "";
        var i = args.length;
        var currentArg = null;
        while (i--) {
          currentArg = args[i];
          hash += currentArg === new Object(currentArg) ? JSON.stringify(currentArg) : currentArg;
          if (!fn.memoize) {
            fn.memoize = {};
          }
        }
        if (hash in fn.memoize) {
          return fn.memoize[hash];
        } else {
          fn.memoizeLength++;
          if (fn.memoizeLength > max) {
            fn.memoizeLength = 0;
            fn.memoize = {};
          }
          var result = fn.apply(this, args);
          fn.memoize[hash] = result;
          return result;
        }
      };
    }

    var breakUp = cappedMemoize(function (str, hint) {
      return new BreakString(str).break(hint);
    }, 100);
    __exports__.breakUp = breakUp;

    function shortDate(date) {
      return moment(date).format(I18n.t("dates.medium.date_year"));
    }

    function shortDateNoYear(date) {
      return moment(date).format(I18n.t("dates.tiny.date_month"));
    }

    function tinyDateYear(date) {
      return moment(date).format(I18n.t("dates.tiny.date_year"));
    }

    // http://stackoverflow.com/questions/196972/convert-string-to-title-case-with-javascript
    // TODO: locale support ?

    function toTitleCase(str) {
      return str.replace(/\w\S*/g, function (txt) {
        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
      });
    }

    function longDate(dt) {
      if (!dt) return;
      return moment(dt).longDate();
    }

    // suppress year, if current year

    function longDateNoYear(dt) {
      if (!dt) return;

      if (new Date().getFullYear() !== dt.getFullYear()) {
        return moment(dt).format(I18n.t("dates.long_date_with_year"));
      } else {
        return moment(dt).format(I18n.t("dates.long_date_without_year"));
      }
    }

    function updateRelativeAge(elems) {
      // jQuery .each
      elems.each(function () {
        var $this = $(this);
        $this.html(relativeAge(new Date($this.data('time')), { format: $this.data('format'), wrapInSpan: false }));
      });
    }

    function autoUpdatingRelativeAge(date, options) {
      if (!date) return "";
      if (+date === +new Date(0)) return "";

      options = options || {};
      var format = options.format || "tiny";

      var append = "";
      if (format === 'medium') {
        append = " date";
        if (options.leaveAgo) {
          format = 'medium-with-ago';
        }
        options.wrapInSpan = false;
      }

      var relAge = relativeAge(date, options);

      if (format === 'tiny' && relativeAgeTinyShowsYear(relAge)) {
        append += " with-year";
      }

      if (options.title) {
        append += "' title='" + longDate(date);
      }

      return "<span class='relative-date" + append + "' data-time='" + date.getTime() + "' data-format='" + format + "'>" + relAge + "</span>";
    }

    function relativeAgeTiny(date) {
      var format = "tiny";
      var distance = Math.round((new Date() - date) / 1000);
      var distanceInMinutes = Math.round(distance / 60.0);

      var formatted = undefined;
      var t = function (key, opts) {
        return I18n.t("dates." + format + "." + key, opts);
      };

      switch (true) {

        case distanceInMinutes < 1:
          formatted = t("less_than_x_minutes", { count: 1 });
          break;
        case distanceInMinutes >= 1 && distanceInMinutes <= 44:
          formatted = t("x_minutes", { count: distanceInMinutes });
          break;
        case distanceInMinutes >= 45 && distanceInMinutes <= 89:
          formatted = t("about_x_hours", { count: 1 });
          break;
        case distanceInMinutes >= 90 && distanceInMinutes <= 1409:
          formatted = t("about_x_hours", { count: Math.round(distanceInMinutes / 60.0) });
          break;
        case Discourse.SiteSettings.relative_date_duration === 0 && distanceInMinutes <= 525599:
          formatted = shortDateNoYear(date);
          break;
        case distanceInMinutes >= 1410 && distanceInMinutes <= 2519:
          formatted = t("x_days", { count: 1 });
          break;
        case distanceInMinutes >= 2520 && distanceInMinutes <= (Discourse.SiteSettings.relative_date_duration || 14) * 1440:
          formatted = t("x_days", { count: Math.round(distanceInMinutes / 1440.0) });
          break;
        default:
          if (date.getFullYear() === new Date().getFullYear()) {
            formatted = shortDateNoYear(date);
          } else {
            formatted = tinyDateYear(date);
          }
          break;
      }

      return formatted;
    }

    /*
     * Returns true if the given tiny date string includes the year.
     * Useful for checking if the string isn't so tiny.
     */
    function relativeAgeTinyShowsYear(relativeAgeString) {
      return relativeAgeString.match(/'[\d]{2}$/);
    }

    function relativeAgeMediumSpan(distance, leaveAgo) {
      var formatted = undefined;
      var distanceInMinutes = Math.round(distance / 60.0);

      var t = function (key, opts) {
        return I18n.t("dates.medium" + (leaveAgo ? "_with_ago" : "") + "." + key, opts);
      };

      switch (true) {
        case distanceInMinutes >= 1 && distanceInMinutes <= 55:
          formatted = t("x_minutes", { count: distanceInMinutes });
          break;
        case distanceInMinutes >= 56 && distanceInMinutes <= 89:
          formatted = t("x_hours", { count: 1 });
          break;
        case distanceInMinutes >= 90 && distanceInMinutes <= 1409:
          formatted = t("x_hours", { count: Math.round(distanceInMinutes / 60.0) });
          break;
        case distanceInMinutes >= 1410 && distanceInMinutes <= 2159:
          formatted = t("x_days", { count: 1 });
          break;
        case distanceInMinutes >= 2160:
          formatted = t("x_days", { count: Math.round((distanceInMinutes - 720.0) / 1440.0) });
          break;
      }
      return formatted || '&mdash';
    }

    function relativeAgeMedium(date, options) {
      var wrapInSpan = options.wrapInSpan !== false;
      var leaveAgo = options.leaveAgo;
      var distance = Math.round((new Date() - date) / 1000);

      if (!date) {
        return "&mdash;";
      }

      var fullReadable = longDate(date);
      var fiveDaysAgo = 432000;
      var oneMinuteAgo = 60;

      var displayDate = "";
      if (distance < oneMinuteAgo) {
        displayDate = I18n.t("now");
      } else if (distance > fiveDaysAgo) {
        if (new Date().getFullYear() !== date.getFullYear()) {
          displayDate = shortDate(date);
        } else {
          displayDate = shortDateNoYear(date);
        }
      } else {
        displayDate = relativeAgeMediumSpan(distance, leaveAgo);
      }
      if (wrapInSpan) {
        return "<span class='date' title='" + fullReadable + "'>" + displayDate + "</span>";
      } else {
        return displayDate;
      }
    }

    // mostly lifted from rails with a few amendments

    function relativeAge(date, options) {
      options = options || {};
      var format = options.format || "tiny";

      if (format === "tiny") {
        return relativeAgeTiny(date, options);
      } else if (format === "medium") {
        return relativeAgeMedium(date, options);
      } else if (format === 'medium-with-ago') {
        return relativeAgeMedium(date, _.extend(options, { format: 'medium', leaveAgo: true }));
      }

      return "UNKNOWN FORMAT";
    }

    function number(val) {
      var formattedNumber = undefined;

      val = parseInt(val, 10);
      if (isNaN(val)) val = 0;

      if (val > 999999) {
        formattedNumber = I18n.toNumber(val / 1000000, { precision: 1 });
        return I18n.t("number.short.millions", { number: formattedNumber });
      }
      if (val > 999) {
        formattedNumber = I18n.toNumber(val / 1000, { precision: 1 });
        return I18n.t("number.short.thousands", { number: formattedNumber });
      }
      return val.toString();
    }
  });
define("discourse/lib/eyeline", 
  ["exports"],
  function(__exports__) {
    "use strict";
    //  Track visible elemnts on the screen.
    var Eyeline = function Eyeline(selector) {
      this.selector = selector;
    };

    Eyeline.prototype.update = function () {
      if (Ember.testing) {
        return;
      }

      var docViewTop = $(window).scrollTop(),
          windowHeight = $(window).height(),
          docViewBottom = docViewTop + windowHeight,
          $elements = $(this.selector),
          bottomOffset = $elements.last().offset(),
          self = this;

      var atBottom = false;
      if (bottomOffset) {
        atBottom = bottomOffset.top <= docViewBottom && bottomOffset.top >= docViewTop;
      }

      return $elements.each(function (i, elem) {
        var $elem = $(elem),
            elemTop = $elem.offset().top,
            elemBottom = elemTop + $elem.height();

        var markSeen = false;

        // Make sure the element is visible
        if (!$elem.is(':visible')) return true;

        // It's seen if...
        // ...the element is vertically within the top and botom
        if (elemTop <= docViewBottom && elemTop >= docViewTop) markSeen = true;

        // ...the element top is above the top and the bottom is below the bottom (large elements)
        if (elemTop <= docViewTop && elemBottom >= docViewBottom) markSeen = true;

        // ...we're at the bottom and the bottom of the element is visible (large bottom elements)
        if (atBottom && elemBottom >= docViewTop) markSeen = true;

        if (!markSeen) return true;

        // If you hit the bottom we mark all the elements as seen. Otherwise, just the first one
        if (!atBottom) {
          self.trigger('saw', { detail: $elem });
          if (i === 0) {
            self.trigger('sawTop', { detail: $elem });
          }
          return false;
        }
        if (i === 0) {
          self.trigger('sawTop', { detail: $elem });
        }
        if (i === $elements.length - 1) {
          return self.trigger('sawBottom', { detail: $elem });
        }
      });
    };

    //  Call this when we know aren't loading any more elements. Mark the rest as seen
    Eyeline.prototype.flushRest = function () {
      if (Ember.testing) {
        return;
      }
      var self = this;
      $(this.selector).each(function (i, elem) {
        return self.trigger('saw', { detail: $(elem) });
      });
    };

    RSVP.EventTarget.mixin(Eyeline.prototype);

    __exports__["default"] = Eyeline;
  });
define("discourse/mixins/scrolling", 
  ["discourse/lib/debounce","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var debounce = __dependency1__["default"];

    /**
      This object provides the DOM methods we need for our Mixin to bind to scrolling
      methods in the browser. By removing them from the Mixin we can test them
      easier.
    **/
    var ScrollingDOMMethods = {
      bindOnScroll: function (onScrollMethod, name) {
        name = name || 'default';
        $(document).bind('touchmove.discourse-' + name, onScrollMethod);
        $(window).bind('scroll.discourse-' + name, onScrollMethod);
      },

      unbindOnScroll: function (name) {
        name = name || 'default';
        $(window).unbind('scroll.discourse-' + name);
        $(document).unbind('touchmove.discourse-' + name);
      },

      screenNotFull: function () {
        return $(window).height() > $("#main").height();
      }
    };

    var Scrolling = Ember.Mixin.create({

      // Begin watching for scroll events. By default they will be called at max every 100ms.
      // call with {debounce: N} for a diff time
      bindScrolling: function (opts) {
        var _this = this;

        opts = opts || { debounce: 100 };

        // So we can not call the scrolled event while transitioning
        var router = Discourse.__container__.lookup('router:main').router;

        var onScrollMethod = function () {
          if (router.activeTransition) {
            return;
          }
          return Ember.run.scheduleOnce('afterRender', _this, 'scrolled');
        };

        if (opts.debounce) {
          onScrollMethod = debounce(onScrollMethod, opts.debounce);
        }

        ScrollingDOMMethods.bindOnScroll(onScrollMethod, opts.name);
      },

      screenNotFull: function () {
        return ScrollingDOMMethods.screenNotFull();
      },

      unbindScrolling: function (name) {
        ScrollingDOMMethods.unbindOnScroll(name);
      }
    });

    __exports__.ScrollingDOMMethods = ScrollingDOMMethods;
    __exports__["default"] = Scrolling;
  });

Discourse.Scrolling = require('discourse/mixins/scrolling').default;
define("discourse/models/model", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var Model = Ember.Object.extend();

    Model.reopenClass({
      extractByKey: function (collection, klass) {
        var retval = {};
        if (Ember.isEmpty(collection)) {
          return retval;
        }

        collection.forEach(function (item) {
          retval[item.id] = klass.create(item);
        });
        return retval;
      }
    });

    __exports__["default"] = Model;
  });

Discourse.Model = require('discourse/models/model').default;
define("discourse/models/rest", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var RestModel = Ember.Object.extend({
      isNew: Ember.computed.equal('__state', 'new'),
      isCreated: Ember.computed.equal('__state', 'created'),
      isSaving: false,

      afterUpdate: Ember.K,

      update: function (props) {
        var _this = this;

        if (this.get('isSaving')) {
          return Ember.RSVP.reject();
        }

        props = props || this.updateProperties();

        var type = this.get('__type'),
            store = this.get('store');

        var self = this;
        self.set('isSaving', true);
        return store.update(type, this.get('id'), props).then(function (res) {
          var payload = self.__munge(res.payload || res.responseJson);

          if (payload.success === "OK") {
            Ember.warn("An update call should return the updated attributes");
            res = props;
          }

          self.setProperties(payload);
          self.afterUpdate(res);
          return res;
        }).finally(function () {
          return _this.set('isSaving', false);
        });
      },

      _saveNew: function (props) {
        var _this2 = this;

        if (this.get('isSaving')) {
          return Ember.RSVP.reject();
        }

        props = props || this.createProperties();

        var type = this.get('__type'),
            store = this.get('store'),
            adapter = store.adapterFor(type);

        var self = this;
        self.set('isSaving', true);
        return adapter.createRecord(store, type, props).then(function (res) {
          if (!res) {
            throw "Received no data back from createRecord";
          }

          // We can get a response back without properties, for example
          // when a post is queued.
          if (res.payload) {
            self.setProperties(self.__munge(res.payload));
            self.set('__state', 'created');
          }

          res.target = self;
          return res;
        }).finally(function () {
          return _this2.set('isSaving', false);
        });
      },

      createProperties: function () {
        throw "You must overwrite `createProperties()` before saving a record";
      },

      save: function (props) {
        return this.get('isNew') ? this._saveNew(props) : this.update(props);
      },

      destroyRecord: function () {
        var type = this.get('__type');
        return this.store.destroyRecord(type, this);
      }
    });

    RestModel.reopenClass({

      // Overwrite and JSON will be passed through here before `create` and `update`
      munge: function (json) {
        return json;
      },

      create: function (args) {
        args = args || {};
        if (!args.store) {
          var container = Discourse.__container__;
          // Ember.warn('Use `store.createRecord` to create records instead of `.create()`');
          args.store = container.lookup('store:main');
        }

        args.__munge = this.munge;
        return this._super(this.munge(args, args.store));
      }
    });

    __exports__["default"] = RestModel;
  });
define("discourse/models/badge-grouping", 
  ["ember-addons/ember-computed-decorators","discourse/models/rest","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var RestModel = __dependency2__["default"];

    __exports__["default"] = RestModel.extend(_createDecoratedObject([{
      key: 'i18nNameKey',
      decorators: [computed('name')],
      value: function () {
        return this.get('name').toLowerCase().replace(/\s/g, '_');
      }
    }, {
      key: 'displayName',
      decorators: [computed('name')],
      value: function () {
        var i18nKey = 'badges.badge_grouping.' + this.get('i18nNameKey') + '.name';
        return I18n.t(i18nKey, { defaultValue: this.get('name') });
      }
    }]));
  });
define("discourse/models/badge", 
  ["discourse/models/badge-grouping","discourse/models/rest","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var BadgeGrouping = __dependency1__["default"];
    var RestModel = __dependency2__["default"];

    var Badge = RestModel.extend({

      newBadge: Em.computed.none('id'),

      url: (function () {
        return Discourse.getURL('/badges/' + this.get('id') + '/' + this.get('slug'));
      }).property(),

      /**
        Update this badge with the response returned by the server on save.
         @method updateFromJson
        @param {Object} json The JSON response returned by the server
      **/
      updateFromJson: function (json) {
        var self = this;
        if (json.badge) {
          Object.keys(json.badge).forEach(function (key) {
            self.set(key, json.badge[key]);
          });
        }
        if (json.badge_types) {
          json.badge_types.forEach(function (badgeType) {
            if (badgeType.id === self.get('badge_type_id')) {
              self.set('badge_type', Object.create(badgeType));
            }
          });
        }
      },

      badgeTypeClassName: (function () {
        var type = this.get('badge_type.name') || "";
        return "badge-type-" + type.toLowerCase();
      }).property('badge_type.name'),

      /**
        Save and update the badge from the server's response.
         @method save
        @returns {Promise} A promise that resolves to the updated `Badge`
      **/
      save: function (data) {
        var url = "/admin/badges",
            requestType = "POST";
        var self = this;

        if (this.get('id')) {
          // We are updating an existing badge.
          url += "/" + this.get('id');
          requestType = "PUT";
        }

        return Discourse.ajax(url, {
          type: requestType,
          data: data
        }).then(function (json) {
          self.updateFromJson(json);
          return self;
        }).catch(function (error) {
          throw error;
        });
      },

      /**
        Destroy the badge.
         @method destroy
        @returns {Promise} A promise that resolves to the server response
      **/
      destroy: function () {
        if (this.get('newBadge')) return Ember.RSVP.resolve();
        return Discourse.ajax("/admin/badges/" + this.get('id'), {
          type: "DELETE"
        });
      }
    });

    Badge.reopenClass({
      /**
        Create `Badge` instances from the server JSON response.
         @method createFromJson
        @param {Object} json The JSON returned by the server
        @returns Array or instance of `Badge` depending on the input JSON
      **/
      createFromJson: function (json) {
        // Create BadgeType objects.
        var badgeTypes = {};
        if ('badge_types' in json) {
          json.badge_types.forEach(function (badgeTypeJson) {
            badgeTypes[badgeTypeJson.id] = Ember.Object.create(badgeTypeJson);
          });
        }

        var badgeGroupings = {};
        if ('badge_groupings' in json) {
          json.badge_groupings.forEach(function (badgeGroupingJson) {
            badgeGroupings[badgeGroupingJson.id] = BadgeGrouping.create(badgeGroupingJson);
          });
        }

        // Create Badge objects.
        var badges = [];
        if ("badge" in json) {
          badges = [json.badge];
        } else if (json.badges) {
          badges = json.badges;
        }
        badges = badges.map(function (badgeJson) {
          var badge = Badge.create(badgeJson);
          badge.set('badge_type', badgeTypes[badge.get('badge_type_id')]);
          badge.set('badge_grouping', badgeGroupings[badge.get('badge_grouping_id')]);
          return badge;
        });

        if ("badge" in json) {
          return badges[0];
        } else {
          return badges;
        }
      },

      /**
        Find all `Badge` instances that have been defined.
         @method findAll
        @returns {Promise} a promise that resolves to an array of `Badge`
      **/
      findAll: function (opts) {
        var listable = "";
        if (opts && opts.onlyListable) {
          listable = "?only_listable=true";
        }
        return Discourse.ajax('/badges.json' + listable).then(function (badgesJson) {
          return Badge.createFromJson(badgesJson);
        });
      },

      /**
        Returns a `Badge` that has the given ID.
         @method findById
        @param {Number} id ID of the badge
        @returns {Promise} a promise that resolves to a `Badge`
      **/
      findById: function (id) {
        return Discourse.ajax("/badges/" + id).then(function (badgeJson) {
          return Badge.createFromJson(badgeJson);
        });
      }
    });

    __exports__["default"] = Badge;
  });
define("discourse/models/permission-type", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var PermissionType = Discourse.Model.extend({
      description: (function () {
        var key = "";

        switch (this.get("id")) {
          case 1:
            key = "full";
            break;
          case 2:
            key = "create_post";
            break;
          case 3:
            key = "readonly";
            break;
        }
        return I18n.t("permission_types." + key);
      }).property("id")
    });

    PermissionType.FULL = 1;
    PermissionType.CREATE_POST = 2;
    PermissionType.READONLY = 3;

    __exports__["default"] = PermissionType;
  });
define("discourse/models/user-action-group", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
      A data model representing a group of UserActions
    **/

    __exports__["default"] = Discourse.Model.extend({
      push: function (item) {
        if (!this.items) {
          this.items = [];
        }
        return this.items.push(item);
      }
    });
  });
define("discourse/models/category", 
  ["discourse/models/rest","ember-addons/ember-computed-decorators","discourse/models/permission-type","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var RestModel = __dependency1__["default"];
    var on = __dependency2__.on;
    var PermissionType = __dependency3__["default"];

    var Category = RestModel.extend(_createDecoratedObject([{
      key: 'setupGroupsAndPermissions',
      decorators: [on('init')],
      value: function () {
        var availableGroups = this.get('available_groups');
        if (!availableGroups) {
          return;
        }
        this.set("availableGroups", availableGroups);

        var groupPermissions = this.get('group_permissions');
        if (groupPermissions) {
          this.set('permissions', groupPermissions.map(function (elem) {
            availableGroups.removeObject(elem.group_name);
            return {
              group_name: elem.group_name,
              permission: PermissionType.create({ id: elem.permission_type })
            };
          }));
        }
      }
    }, {
      key: 'availablePermissions',
      initializer: function () {
        return (function () {
          return [PermissionType.create({ id: PermissionType.FULL }), PermissionType.create({ id: PermissionType.CREATE_POST }), PermissionType.create({ id: PermissionType.READONLY })];
        }).property();
      }
    }, {
      key: 'searchContext',
      initializer: function () {
        return (function () {
          return { type: 'category', id: this.get('id'), category: this };
        }).property('id');
      }
    }, {
      key: 'url',
      initializer: function () {
        return (function () {
          return Discourse.getURL("/c/") + Category.slugFor(this);
        }).property('name');
      }
    }, {
      key: 'fullSlug',
      initializer: function () {
        return (function () {
          return this.get("url").slice(3).replace("/", "-");
        }).property("url");
      }
    }, {
      key: 'nameLower',
      initializer: function () {
        return (function () {
          return this.get('name').toLowerCase();
        }).property('name');
      }
    }, {
      key: 'unreadUrl',
      initializer: function () {
        return (function () {
          return this.get('url') + '/l/unread';
        }).property('url');
      }
    }, {
      key: 'newUrl',
      initializer: function () {
        return (function () {
          return this.get('url') + '/l/new';
        }).property('url');
      }
    }, {
      key: 'style',
      initializer: function () {
        return (function () {
          return "background-color: #" + this.get('category.color') + "; color: #" + this.get('category.text_color') + ";";
        }).property('color', 'text_color');
      }
    }, {
      key: 'moreTopics',
      initializer: function () {
        return (function () {
          return this.get('topic_count') > Discourse.SiteSettings.category_featured_topics;
        }).property('topic_count');
      }
    }, {
      key: 'save',
      initializer: function () {
        return function () {
          var url = "/categories";
          if (this.get('id')) {
            url = "/categories/" + this.get('id');
          }

          return Discourse.ajax(url, {
            data: {
              name: this.get('name'),
              slug: this.get('slug'),
              color: this.get('color'),
              text_color: this.get('text_color'),
              secure: this.get('secure'),
              permissions: this.get('permissionsForUpdate'),
              auto_close_hours: this.get('auto_close_hours'),
              auto_close_based_on_last_post: this.get("auto_close_based_on_last_post"),
              position: this.get('position'),
              email_in: this.get('email_in'),
              email_in_allow_strangers: this.get('email_in_allow_strangers'),
              parent_category_id: this.get('parent_category_id'),
              logo_url: this.get('logo_url'),
              background_url: this.get('background_url'),
              allow_badges: this.get('allow_badges'),
              custom_fields: this.get('custom_fields'),
              topic_template: this.get('topic_template'),
              suppress_from_homepage: this.get('suppress_from_homepage')
            },
            type: this.get('id') ? 'PUT' : 'POST'
          });
        };
      }
    }, {
      key: 'permissionsForUpdate',
      initializer: function () {
        return (function () {
          var rval = {};
          _.each(this.get("permissions"), function (p) {
            rval[p.group_name] = p.permission.id;
          });
          return rval;
        }).property("permissions");
      }
    }, {
      key: 'destroy',
      initializer: function () {
        return function () {
          return Discourse.ajax("/categories/" + (this.get('id') || this.get('slug')), { type: 'DELETE' });
        };
      }
    }, {
      key: 'addPermission',
      initializer: function () {
        return function (permission) {
          this.get("permissions").addObject(permission);
          this.get("availableGroups").removeObject(permission.group_name);
        };
      }
    }, {
      key: 'removePermission',
      initializer: function () {
        return function (permission) {
          this.get("permissions").removeObject(permission);
          this.get("availableGroups").addObject(permission.group_name);
        };
      }
    }, {
      key: 'permissions',
      initializer: function () {
        return (function () {
          return Em.A([{ group_name: "everyone", permission: PermissionType.create({ id: 1 }) }, { group_name: "admins", permission: PermissionType.create({ id: 2 }) }, { group_name: "crap", permission: PermissionType.create({ id: 3 }) }]);
        }).property();
      }
    }, {
      key: 'latestTopic',
      initializer: function () {
        return (function () {
          var topics = this.get('topics');
          if (topics && topics.length) {
            return topics[0];
          }
        }).property("topics");
      }
    }, {
      key: 'featuredTopics',
      initializer: function () {
        return (function () {
          var topics = this.get('topics');
          if (topics && topics.length) {
            return topics.slice(0, Discourse.SiteSettings.category_featured_topics || 2);
          }
        }).property('topics');
      }
    }, {
      key: 'unreadTopics',
      initializer: function () {
        return (function () {
          return this.topicTrackingState.countUnread(this.get('id'));
        }).property('topicTrackingState.messageCount');
      }
    }, {
      key: 'newTopics',
      initializer: function () {
        return (function () {
          return this.topicTrackingState.countNew(this.get('id'));
        }).property('topicTrackingState.messageCount');
      }
    }, {
      key: 'topicStatsTitle',
      initializer: function () {
        return (function () {
          var string = I18n.t('categories.topic_stats');
          _.each(this.get('topicCountStats'), function (stat) {
            string += ' ' + I18n.t('categories.topic_stat_sentence', { count: stat.value, unit: stat.unit });
          }, this);
          return string;
        }).property('post_count');
      }
    }, {
      key: 'postStatsTitle',
      initializer: function () {
        return (function () {
          var string = I18n.t('categories.post_stats');
          _.each(this.get('postCountStats'), function (stat) {
            string += ' ' + I18n.t('categories.post_stat_sentence', { count: stat.value, unit: stat.unit });
          }, this);
          return string;
        }).property('post_count');
      }
    }, {
      key: 'topicCountStats',
      initializer: function () {
        return (function () {
          return this.countStats('topics');
        }).property('topics_year', 'topics_month', 'topics_week', 'topics_day');
      }
    }, {
      key: 'setNotification',
      initializer: function () {
        return function (notification_level) {
          var url = "/category/" + this.get('id') + "/notifications";
          this.set('notification_level', notification_level);
          return Discourse.ajax(url, {
            data: {
              notification_level: notification_level
            },
            type: 'POST'
          });
        };
      }
    }, {
      key: 'postCountStats',
      initializer: function () {
        return (function () {
          return this.countStats('posts');
        }).property('posts_year', 'posts_month', 'posts_week', 'posts_day');
      }
    }, {
      key: 'countStats',
      initializer: function () {
        return function (prefix) {
          var stats = [],
              val;
          _.each(['day', 'week', 'month', 'year'], function (unit) {
            val = this.get(prefix + '_' + unit);
            if (val > 0) stats.pushObject({ value: val, unit: I18n.t(unit) });
            if (stats.length === 2) return false;
          }, this);
          return stats;
        };
      }
    }, {
      key: 'isUncategorizedCategory',
      initializer: function () {
        return (function () {
          return this.get('id') === Discourse.Site.currentProp("uncategorized_category_id");
        }).property('id');
      }
    }]));

    var _uncategorized;

    Category.reopenClass({

      findUncategorized: function () {
        _uncategorized = _uncategorized || Category.list().findBy('id', Discourse.Site.currentProp('uncategorized_category_id'));
        return _uncategorized;
      },

      slugFor: function (category) {
        var separator = arguments.length <= 1 || arguments[1] === undefined ? "/" : arguments[1];

        if (!category) return "";

        var parentCategory = Em.get(category, 'parentCategory');
        var result = "";

        if (parentCategory) {
          result = Category.slugFor(parentCategory) + separator;
        }

        var id = Em.get(category, 'id'),
            slug = Em.get(category, 'slug');

        return !slug || slug.trim().length === 0 ? '' + result + id + '-category' : result + slug;
      },

      list: function () {
        return Discourse.SiteSettings.fixed_category_positions ? Discourse.Site.currentProp('categories') : Discourse.Site.currentProp('sortedCategories');
      },

      listByActivity: function () {
        return Discourse.Site.currentProp('sortedCategories');
      },

      idMap: function () {
        return Discourse.Site.currentProp('categoriesById');
      },

      findSingleBySlug: function (slug) {
        return Category.list().find(function (c) {
          return Category.slugFor(c) === slug;
        });
      },

      findById: function (id) {
        if (!id) {
          return;
        }
        return Category.idMap()[id];
      },

      findByIds: function (ids) {
        var categories = [];
        _.each(ids, function (id) {
          var found = Category.findById(id);
          if (found) {
            categories.push(found);
          }
        });
        return categories;
      },

      findBySlug: function (slug, parentSlug) {
        var categories = Category.list();
        var category = undefined;

        if (parentSlug) {
          var _ret = (function () {
            var parentCategory = Category.findSingleBySlug(parentSlug);
            if (parentCategory) {
              if (slug === 'none') {
                return {
                  v: parentCategory
                };
              }

              category = categories.find(function (item) {
                return item && item.get('parentCategory') === parentCategory && Category.slugFor(item) === parentSlug + "/" + slug;
              });
            }
          })();

          if (typeof _ret === 'object') return _ret.v;
        } else {
          category = Category.findSingleBySlug(slug);

          // If we have a parent category, we need to enforce it
          if (category && category.get('parentCategory')) return;
        }

        // In case the slug didn't work, try to find it by id instead.
        if (!category) {
          category = categories.findBy('id', parseInt(slug, 10));
        }

        return category;
      },

      reloadById: function (id) {
        return Discourse.ajax('/c/' + id + '/show.json');
      },

      reloadBySlug: function (slug, parentSlug) {
        return parentSlug ? Discourse.ajax('/c/' + parentSlug + '/' + slug + '/find_by_slug.json') : Discourse.ajax('/c/' + slug + '/find_by_slug.json');
      },

      search: function (term, opts) {
        var limit = 5;

        if (opts) {
          if (opts.limit === 0) {
            return [];
          } else if (opts.limit) {
            limit = opts.limit;
          }
        }

        var emptyTerm = term === "";
        var slugTerm = term;

        if (!emptyTerm) {
          term = term.toLowerCase();
          slugTerm = term;
          term = term.replace(/-/g, " ");
        }

        var categories = Category.listByActivity();
        var length = categories.length;
        var i;
        var data = [];

        var done = function () {
          return data.length === limit;
        };

        for (i = 0; i < length && !done(); i++) {
          var category = categories[i];
          if (emptyTerm && !category.get('parent_category_id') || !emptyTerm && (category.get('name').toLowerCase().indexOf(term) === 0 || category.get('slug').toLowerCase().indexOf(slugTerm) === 0)) {

            data.push(category);
          }
        }

        if (!done()) {
          for (i = 0; i < length && !done(); i++) {
            var category = categories[i];

            if (!emptyTerm && (category.get('name').toLowerCase().indexOf(term) > 0 || category.get('slug').toLowerCase().indexOf(slugTerm) > 0)) {

              if (data.indexOf(category) === -1) data.push(category);
            }
          }
        }

        return _.sortBy(data, function (category) {
          return category.get('read_restricted');
        });
      }
    });

    __exports__["default"] = Category;
  });

Discourse.Category = require('discourse/models/category').default;
define("discourse/lib/ajax-error", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.extractError = extractError;
    __exports__.throwAjaxError = throwAjaxError;
    __exports__.popupAjaxError = popupAjaxError;

    function extractError(error, defaultMessage) {
      if (error instanceof Error) {
        Ember.Logger.error(error.stack);
      }

      if (typeof error === "string") {
        Ember.Logger.error(error);
      }

      if (error.jqXHR) {
        error = error.jqXHR;
      }

      var parsedError = undefined,
          parsedJSON = undefined;

      if (error.responseJSON) {
        parsedJSON = error.responseJSON;
      }

      if (!parsedJSON && error.responseText) {
        try {
          parsedJSON = $.parseJSON(error.responseText);
        } catch (ex) {
          // in case the JSON doesn't parse
          Ember.Logger.error(ex.stack);
        }
      }

      if (parsedJSON) {
        if (parsedJSON.errors && parsedJSON.errors.length > 0) {
          parsedError = parsedJSON.errors.join("<br>");
        } else if (parsedJSON.error) {
          parsedError = parsedJSON.error;
        } else if (parsedJSON.failed) {
          parsedError = parsedJSON.message;
        }
      }

      if (!parsedError) {
        if (error.status && error.status >= 400) {
          parsedError = error.status + " " + error.statusText;
        }
      }

      return parsedError || defaultMessage || I18n.t('generic_error');
    }

    function throwAjaxError(undoCallback) {
      return function (error) {
        // If we provided an `undo` callback
        if (undoCallback) {
          undoCallback(error);
        }
        throw extractError(error);
      };
    }

    function popupAjaxError(error) {
      bootbox.alert(extractError(error));
    }
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Contains methods to help us with markdown formatting.

  @class Markdown
  @namespace Discourse
  @module Discourse
**/

/**
 * An object mapping from HTML tag names to an object mapping the valid
 * attributes on that tag to an array of permitted values.
 *
 * The permitted values can be strings or regexes.
 *
 * The pseduo-attribute 'data-*' can be used to validate any data-foo
 * attributes without any specified validations.
 *
 * Code can insert into this map by calling Discourse.Markdown.whiteListTag().
 *
 * Example:
 *
 * <pre><code>
 * {
 *   a: {
 *     href: ['*'],
 *     data-mention-id: [/^\d+$/],
 *     ...
 *   },
 *   code: {
 *     class: ['ada', 'haskell', 'c', 'cpp', ... ]
 *   },
 *   ...
 * }
 * </code></pre>
 *
 * @private
 */

var _validTags = {};
/**
 * Classes valid on all elements. Map from class name to 'true'.
 * @private
 */
var _validClasses = {};
var _validIframes = [];
var _decoratedCaja = false;

function validateAttribute(tagName, attribName, value) {
  var tag = _validTags[tagName];

  // Handle classes
  if (attribName === "class") {
    if (_validClasses[value]) { return value; }
  }

  if (attribName.indexOf('data-') === 0) {
    // data-* catch-all validators
    if (tag && tag['data-*'] && !tag[attribName]) {
      var permitted = tag['data-*'];
      if (permitted && (
            permitted.indexOf(value) !== -1 ||
            permitted.indexOf('*') !== -1 ||
            ((permitted instanceof RegExp) && permitted.test(value)))
        ) { return value; }
    }
  }

  if (tag) {
    var attrs = tag[attribName];
    if (attrs && (attrs.indexOf(value) !== -1 ||
                  attrs.indexOf('*') !== -1) ||
                  _.any(attrs, function(r) { return (r instanceof RegExp) && r.test(value); })
        ) { return value; }
  }

  // return undefined;
}

function anchorRegexp(regex) {
  if (/^\^.*\$$/.test(regex.source)) {
    return regex; // already anchored
  }

  var flags = "";
  if (regex.global) {
    if (typeof console !== 'undefined') {
      console.warn("attribute validation regex should not be global");
    }
  }

  if (regex.ignoreCase) { flags += "i"; }
  if (regex.multiline) { flags += "m"; }
  if (regex.sticky) { throw "Invalid attribute validation regex - cannot be sticky"; }

  return new RegExp("^" + regex.source + "$", flags);
}

Discourse.Markdown = {

  /**
    Add to the attribute whitelist for a certain HTML tag.

    @param {String} tagName tag to whitelist the attr for
    @param {String} attribName attr to whitelist for the tag
    @param {String | RegExp} [value] whitelisted value for the attribute
  **/
  whiteListTag: function(tagName, attribName, value) {
    if (value instanceof RegExp) {
      value = anchorRegexp(value);
    }
    _validTags[tagName] = _validTags[tagName] || {};
    _validTags[tagName][attribName] = _validTags[tagName][attribName] || [];
    _validTags[tagName][attribName].push(value || '*');
  },

  /**
    Whitelists more classes for sanitization.

    @param {...String} var_args Classes to whitelist
    @method whiteListClass
  **/
  whiteListClass: function() {
    var args = Array.prototype.slice.call(arguments);
    args.forEach(function (a) { _validClasses[a] = true; });
  },

  /**
    Whitelists iframes for sanitization

    @method whiteListIframe
    @param {Regexp} regexp The regexp to whitelist.
  **/
  whiteListIframe: function(regexp) {
    _validIframes.push(regexp);
  },

  /**
    Convert a raw string to a cooked markdown string.

    @method cook
    @param {String} raw the raw string we want to apply markdown to
    @param {Object} opts the options for the rendering
    @return {String} the cooked markdown string
  **/
  cook: function(raw, opts) {
    if (!opts) opts = {};

    // Make sure we've got a string
    if (!raw || raw.length === 0) return "";

    return this.markdownConverter(opts).makeHtml(raw);
  },

  /**
    Checks to see if a URL is allowed in the cooked content

    @method urlAllowed
    @param {String} uri Url to check
    @param {Number} effect ignored
    @param {Number} ltype ignored
    @param {Object} hints an object with hints, used to check if this url is from an iframe
    @return {String} url to insert in the cooked content
  **/
  urlAllowed: function (uri, effect, ltype, hints) {
    var url = typeof(uri) === "string" ? uri : uri.toString();

    // escape single quotes
    url = url.replace(/'/g, "%27");

    // whitelist some iframe only
    if (hints && hints.XML_TAG === "iframe" && hints.XML_ATTR === "src") {
      for (var i = 0, length = _validIframes.length; i < length; i++) {
        if(_validIframes[i].test(url)) { return url; }
      }
      return;
    }

    // absolute urls
    if(/^(https?:)?\/\/[\w\.\-]+/i.test(url)) { return url; }
    // relative urls
    if(/^\/[\w\.\-]+/i.test(url)) { return url; }
    // anchors
    if(/^#[\w\.\-]+/i.test(url)) { return url; }
    // mailtos
    if(/^mailto:[\w\.\-@]+/i.test(url)) { return url; }
  },

  /**
    Sanitize text using the sanitizer

    @method sanitize
    @param {String} text The text to sanitize
    @return {String} text The sanitized text
  **/
  sanitize: function(text) {
    if (!window.html_sanitize || !text) return "";

    // Allow things like <3 and <_<
    text = text.replace(/<([^A-Za-z\/\!]|$)/g, "&lt;$1");

    // The first time, let's add some more whitelisted tags
    if (!_decoratedCaja) {

      // Add anything whitelisted to the list of elements if it's not in there already.
      var elements = window.html4.ELEMENTS;
      Object.keys(_validTags).forEach(function(t) {
        if (!elements[t]) {
          elements[t] = 0;
        }
      });

      _decoratedCaja = true;
    }

    return window.html_sanitize(text, Discourse.Markdown.urlAllowed, validateAttribute);
  },

  /**
    Creates a Markdown.Converter that we we can use for formatting

    @method markdownConverter
    @param {Object} opts the converting options
  **/
  markdownConverter: function(opts) {
    if (!opts) opts = {};

    return {
      makeHtml: function(text) {
        text = Discourse.Dialect.cook(text, opts);
        return !text ? "" : text;
      }
    };
  }

};

RSVP.EventTarget.mixin(Discourse.Markdown);

Discourse.Markdown.whiteListTag('a', 'class', 'attachment');
Discourse.Markdown.whiteListTag('a', 'class', 'onebox');
Discourse.Markdown.whiteListTag('a', 'class', 'mention');
Discourse.Markdown.whiteListTag('a', 'class', 'mention-group');
Discourse.Markdown.whiteListTag('a', 'class', 'hashtag');

Discourse.Markdown.whiteListTag('a', 'target', '_blank');
Discourse.Markdown.whiteListTag('a', 'rel', 'nofollow');
Discourse.Markdown.whiteListTag('a', 'data-bbcode');
Discourse.Markdown.whiteListTag('a', 'name');

Discourse.Markdown.whiteListTag('img', 'src', /^data:image.*$/i);

Discourse.Markdown.whiteListTag('div', 'class', 'title');
Discourse.Markdown.whiteListTag('div', 'class', 'quote-controls');

Discourse.Markdown.whiteListTag('span', 'class', 'mention');
Discourse.Markdown.whiteListTag('span', 'class', 'hashtag');
Discourse.Markdown.whiteListTag('aside', 'class', 'quote');
Discourse.Markdown.whiteListTag('aside', 'data-*');

Discourse.Markdown.whiteListTag('span', 'bbcode-b');
Discourse.Markdown.whiteListTag('span', 'bbcode-i');
Discourse.Markdown.whiteListTag('span', 'bbcode-u');
Discourse.Markdown.whiteListTag('span', 'bbcode-s');

// used for pinned topics
Discourse.Markdown.whiteListTag('span', 'class', 'excerpt');

Discourse.Markdown.whiteListIframe(/^(https?:)?\/\/www\.google\.com\/maps\/embed\?.+/i);
Discourse.Markdown.whiteListIframe(/^(https?:)?\/\/www\.openstreetmap\.org\/export\/embed.html\?.+/i);


// IIFE Wrapped Content Ends

 })(this);
define("discourse/lib/search", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.translateResults = translateResults;

    function translateResults(results, opts) {

      var User = require('discourse/models/user').default;
      var Category = require('discourse/models/category').default;
      var Post = require('discourse/models/post').default;
      var Topic = require('discourse/models/topic').default;

      if (!opts) opts = {};

      // Topics might not be included
      if (!results.topics) {
        results.topics = [];
      }
      if (!results.users) {
        results.users = [];
      }
      if (!results.posts) {
        results.posts = [];
      }
      if (!results.categories) {
        results.categories = [];
      }

      var topicMap = {};
      results.topics = results.topics.map(function (topic) {
        topic = Topic.create(topic);
        topicMap[topic.id] = topic;
        return topic;
      });

      results.posts = results.posts.map(function (post) {
        post = Post.create(post);
        post.set('topic', topicMap[post.topic_id]);
        return post;
      });

      results.users = results.users.map(function (user) {
        user = User.create(user);
        return user;
      });

      results.categories = results.categories.map(function (category) {
        return Category.list().findProperty('id', category.id);
      }).compact();

      var r = results.grouped_search_result;
      results.resultTypes = [];

      // TODO: consider refactoring front end to take a better structure
      [['topic', 'posts'], ['user', 'users'], ['category', 'categories']].forEach(function (pair) {
        var type = pair[0],
            name = pair[1];
        if (results[name].length > 0) {
          var result = {
            results: results[name],
            componentName: "search-result-" + (opts.searchContext && opts.searchContext.type === 'topic' && type === 'topic' ? 'post' : type),
            type: type,
            more: r['more_' + name]
          };

          if (result.more && name === "posts" && opts.fullSearchUrl) {
            result.more = false;
            result.moreUrl = opts.fullSearchUrl;
          }

          results.resultTypes.push(result);
        }
      });

      var noResults = !!(results.topics.length === 0 && results.posts.length === 0 && results.users.length === 0 && results.categories.length === 0);

      return noResults ? null : Em.Object.create(results);
    }

    function searchForTerm(term, opts) {
      if (!opts) opts = {};

      // Only include the data we have
      var data = { term: term, include_blurbs: 'true' };
      if (opts.typeFilter) data.type_filter = opts.typeFilter;
      if (opts.searchForId) data.search_for_id = true;

      if (opts.searchContext) {
        data.search_context = {
          type: opts.searchContext.type,
          id: opts.searchContext.id
        };
      }

      var promise = Discourse.ajax('/search/query', { data: data });

      promise.then(function (results) {
        return translateResults(results, opts);
      });

      return promise;
    }

    var searchContextDescription = function (type, name) {
      if (type) {
        switch (type) {
          case 'topic':
            return I18n.t('search.context.topic');
          case 'user':
            return I18n.t('search.context.user', { username: name });
          case 'category':
            return I18n.t('search.context.category', { category: name });
          case 'private_messages':
            return I18n.t('search.context.private_messages');
        }
      }
    };

    var getSearchKey = function (args) {
      return args.q + "|" + (args.searchContext && args.searchContext.type || "") + "|" + (args.searchContext && args.searchContext.id || "");
    };

    var isValidSearchTerm = function (searchTerm) {
      if (searchTerm) {
        return searchTerm.trim().length >= Discourse.SiteSettings.min_search_term_length;
      } else {
        return false;
      }
    };

    __exports__.searchForTerm = searchForTerm;
    __exports__.searchContextDescription = searchContextDescription;
    __exports__.getSearchKey = getSearchKey;
    __exports__.isValidSearchTerm = isValidSearchTerm;
  });
define("discourse/lib/user-search", 
  ["discourse/lib/autocomplete","exports"],
  function(__dependency1__, __exports__) {
    "use strict";


    __exports__["default"] = userSearch;
    var CANCELLED_STATUS = __dependency1__.CANCELLED_STATUS;

    var cache = {},
        cacheTopicId,
        cacheTime,
        currentTerm,
        oldSearch;

    function performSearch(term, topicId, includeGroups, includeMentionableGroups, allowedUsers, resultsFn) {
      var cached = cache[term];
      if (cached) {
        resultsFn(cached);
        return;
      }

      // need to be able to cancel this
      oldSearch = $.ajax(Discourse.getURL('/users/search/users'), {
        data: { term: term,
          topic_id: topicId,
          include_groups: includeGroups,
          include_mentionable_groups: includeMentionableGroups,
          topic_allowed_users: allowedUsers }
      });

      var returnVal = CANCELLED_STATUS;

      oldSearch.then(function (r) {
        cache[term] = r;
        cacheTime = new Date();
        // If there is a newer search term, return null
        if (term === currentTerm) {
          returnVal = r;
        }
      }).always(function () {
        oldSearch = null;
        resultsFn(returnVal);
      });
    }

    var debouncedSearch = _.debounce(performSearch, 300);

    function organizeResults(r, options) {
      if (r === CANCELLED_STATUS) {
        return r;
      }

      var exclude = options.exclude || [],
          limit = options.limit || 5,
          users = [],
          groups = [],
          results = [];

      if (r.users) {
        r.users.every(function (u) {
          if (exclude.indexOf(u.username) === -1) {
            users.push(u);
            results.push(u);
          }
          return results.length <= limit;
        });
      }

      if (r.groups) {
        r.groups.every(function (g) {
          if (results.length > limit) return false;
          if (exclude.indexOf(g.name) === -1) {
            groups.push(g);
            results.push(g);
          }
          return true;
        });
      }

      results.users = users;
      results.groups = groups;
      return results;
    }
    function userSearch(options) {
      var term = options.term || "",
          includeGroups = options.includeGroups,
          includeMentionableGroups = options.includeMentionableGroups,
          allowedUsers = options.allowedUsers,
          topicId = options.topicId;

      if (oldSearch) {
        oldSearch.abort();
        oldSearch = null;
      }

      currentTerm = term;

      return new Ember.RSVP.Promise(function (resolve) {
        // TODO site setting for allowed regex in username
        if (term.match(/[^a-zA-Z0-9_\.\-]/)) {
          resolve([]);
          return;
        }
        if (new Date() - cacheTime > 30000 || cacheTopicId !== topicId) {
          cache = {};
        }

        cacheTopicId = topicId;

        var clearPromise = setTimeout(function () {
          resolve(CANCELLED_STATUS);
        }, 5000);

        debouncedSearch(term, topicId, includeGroups, includeMentionableGroups, allowedUsers, function (r) {
          clearTimeout(clearPromise);
          resolve(organizeResults(r, options));
        });
      });
    }
  });
define("discourse/lib/export-csv", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.exportUserArchive = exportUserArchive;
    __exports__.exportEntity = exportEntity;
    function exportEntityByType(type, entity, args) {
      return Discourse.ajax("/export_csv/export_entity.json", {
        method: 'POST',
        data: { entity_type: type, entity: entity, args: args }
      });
    }

    function exportUserArchive() {
      return exportEntityByType('user', 'user_archive').then(function () {
        bootbox.alert(I18n.t("admin.export_csv.success"));
      }).catch(function () {
        bootbox.alert(I18n.t("admin.export_csv.rate_limit_error"));
      });
    }

    function exportEntity(entity, args) {
      return exportEntityByType('admin', entity, args);
    }
  });
define("discourse/lib/autocomplete", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
      This is a jQuery plugin to support autocompleting values in our text fields.

      @module $.fn.autocomplete
    **/

    var CANCELLED_STATUS = "__CANCELLED";

    __exports__.CANCELLED_STATUS = CANCELLED_STATUS;
    var allowedLettersRegex = /[\s\t\[\{\(\/]/;

    var keys = {
      backSpace: 8,
      tab: 9,
      enter: 13,
      shift: 16,
      ctrl: 17,
      alt: 18,
      esc: 27,
      space: 32,
      leftWindows: 91,
      rightWindows: 92,
      pageUp: 33,
      pageDown: 34,
      end: 35,
      home: 36,
      leftArrow: 37,
      upArrow: 38,
      rightArrow: 39,
      downArrow: 40,
      insert: 45,
      deleteKey: 46,
      zero: 48,
      a: 65,
      z: 90
    };

    var inputTimeout = undefined;

    __exports__["default"] = function (options) {
      var autocompletePlugin = this;

      if (this.length === 0) return;

      if (options === 'destroy') {
        Ember.run.cancel(inputTimeout);

        $(this).off('keyup.autocomplete').off('keydown.autocomplete').off('paste.autocomplete').off('click.autocomplete');

        return;
      }

      if (options && options.cancel && this.data("closeAutocomplete")) {
        this.data("closeAutocomplete")();
        return this;
      }

      if (this.length !== 1) {
        if (window.console) {
          window.console.log("WARNING: passed multiple elements to $.autocomplete, skipping.");
          if (window.Error) {
            window.console.log(new window.Error().stack);
          }
        }
        return this;
      }

      var disabled = options && options.disabled;
      var wrap = null;
      var autocompleteOptions = null;
      var selectedOption = null;
      var completeStart = null;
      var completeEnd = null;
      var me = this;
      var div = null;
      var prevTerm = null;

      // input is handled differently
      var isInput = this[0].tagName === "INPUT";
      var inputSelectedItems = [];

      var closeAutocomplete = function () {
        if (div) {
          div.hide().remove();
        }
        div = null;
        completeStart = null;
        autocompleteOptions = null;
        prevTerm = null;
      };

      var addInputSelectedItem = function (item) {
        var transformed,
            transformedItem = item;

        if (options.transformComplete) {
          transformedItem = options.transformComplete(transformedItem);
        }
        // dump what we have in single mode, just in case
        if (options.single) {
          inputSelectedItems = [];
        }
        transformed = _.isArray(transformedItem) ? transformedItem : [transformedItem || item];

        var divs = transformed.map(function (itm) {
          var d = $("<div class='item'><span>" + itm + "<a class='remove' href><i class='fa fa-times'></i></a></span></div>");
          var prev = me.parent().find('.item:last');
          if (prev.length === 0) {
            me.parent().prepend(d);
          } else {
            prev.after(d);
          }
          inputSelectedItems.push(itm);
          return d[0];
        });

        if (options.onChangeItems) {
          options.onChangeItems(inputSelectedItems);
        }

        $(divs).find('a').click(function () {
          closeAutocomplete();
          inputSelectedItems.splice($.inArray(transformedItem, inputSelectedItems), 1);
          $(this).parent().parent().remove();
          if (options.single) {
            me.show();
          }
          if (options.onChangeItems) {
            options.onChangeItems(inputSelectedItems);
          }
          return false;
        });
      };

      var completeTerm = function (term) {
        if (term) {
          if (isInput) {
            me.val("");
            if (options.single) {
              me.hide();
            }
            addInputSelectedItem(term);
          } else {
            if (options.transformComplete) {
              term = options.transformComplete(term);
            }

            if (term) {
              var text = me.val();
              text = text.substring(0, completeStart) + (options.key || "") + term + ' ' + text.substring(completeEnd + 1, text.length);
              me.val(text);
              Discourse.Utilities.setCaretPosition(me[0], completeStart + 1 + term.length);

              if (options && options.afterComplete) {
                options.afterComplete(text);
              }
            }
          }
        }
        closeAutocomplete();
      };

      if (isInput) {
        var width = this.width();
        wrap = this.wrap("<div class='ac-wrap clearfix" + (disabled ? " disabled" : "") + "'/>").parent();
        wrap.width(width);
        if (options.single) {
          this.css("width", "100%");
        } else {
          this.width(150);
        }
        this.attr('name', this.attr('name') + "-renamed");
        var vals = this.val().split(",");
        _.each(vals, function (x) {
          if (x !== "") {
            if (options.reverseTransform) {
              x = options.reverseTransform(x);
            }
            addInputSelectedItem(x);
          }
        });
        if (options.items) {
          _.each(options.items, function (item) {
            addInputSelectedItem(item);
          });
        }
        this.val("");
        completeStart = 0;
        wrap.click(function () {
          autocompletePlugin.focus();
          return true;
        });
      }

      var markSelected = function () {
        var links = div.find('li a');
        links.removeClass('selected');
        return $(links[selectedOption]).addClass('selected');
      };

      var renderAutocomplete = function () {
        if (div) {
          div.hide().remove();
        }
        if (autocompleteOptions.length === 0) return;

        div = $(options.template({ options: autocompleteOptions }));

        var ul = div.find('ul');
        selectedOption = 0;
        markSelected();
        ul.find('li').click(function () {
          selectedOption = ul.find('li').index(this);
          completeTerm(autocompleteOptions[selectedOption]);
          return false;
        });
        var pos = null;
        var vOffset = 0;
        var hOffset = 0;
        if (isInput) {
          pos = {
            left: 0,
            top: 0
          };
          vOffset = -32;
          hOffset = 0;
        } else {
          pos = me.caretPosition({
            pos: completeStart,
            key: options.key
          });
          hOffset = 27;
        }
        div.css({
          left: "-1000px"
        });

        me.parent().append(div);

        if (!isInput) {
          vOffset = div.height();
        }

        if (Discourse.Site.currentProp('mobileView') && !isInput) {
          div.css('width', 'auto');

          if (me.height() / 2 >= pos.top) {
            vOffset = -23;
          }
          if (me.width() / 2 <= pos.left) {
            hOffset = -div.width();
          }
        }

        var mePos = me.position();
        var borderTop = parseInt(me.css('border-top-width'), 10) || 0;
        div.css({
          position: 'absolute',
          top: mePos.top + pos.top - vOffset + borderTop + 'px',
          left: mePos.left + pos.left + hOffset + 'px'
        });
      };

      var SKIP = "skip";

      var dataSource = function (term, opts) {
        if (prevTerm === term) {
          return SKIP;
        }

        prevTerm = term;
        if (term.length !== 0 && term.trim().length === 0) {
          closeAutocomplete();
          return null;
        } else {
          return opts.dataSource(term);
        }
      };

      var updateAutoComplete = function (r) {

        if (completeStart === null || r === SKIP) return;

        if (r && r.then && typeof r.then === "function") {
          if (div) {
            div.hide().remove();
          }
          r.then(updateAutoComplete);
          return;
        }

        // Allow an update method to cancel. This allows us to debounce
        // promises without leaking
        if (r === CANCELLED_STATUS) {
          return;
        }

        autocompleteOptions = r;
        if (!r || r.length === 0) {
          closeAutocomplete();
        } else {
          renderAutocomplete();
        }
      };

      // chain to allow multiples
      var oldClose = me.data("closeAutocomplete");
      me.data("closeAutocomplete", function () {
        if (oldClose) {
          oldClose();
        }
        closeAutocomplete();
      });

      $(this).on('click.autocomplete', function () {
        closeAutocomplete();
      });

      $(this).on('paste.autocomplete', function () {
        _.delay(function () {
          me.trigger("keydown");
        }, 50);
      });

      var checkTriggerRule = function (opts) {
        if (options.triggerRule) {
          return options.triggerRule(me[0], opts);
        } else {
          return true;
        }
      };

      $(this).on('keyup.autocomplete', function (e) {
        if ([keys.esc, keys.enter].indexOf(e.which) !== -1) return true;

        var caretPosition = Discourse.Utilities.caretPosition(me[0]);

        if (options.key && completeStart === null && caretPosition > 0) {
          var key = me[0].value[caretPosition - 1];
          if (key === options.key) {
            var prevChar = me.val().charAt(caretPosition - 2);
            if (checkTriggerRule() && (!prevChar || allowedLettersRegex.test(prevChar))) {
              completeStart = completeEnd = caretPosition - 1;
              updateAutoComplete(dataSource("", options));
            }
          }
        } else if (completeStart !== null) {
          var term = me.val().substring(completeStart + (options.key ? 1 : 0), caretPosition);
          updateAutoComplete(dataSource(term, options));
        }
      });

      $(this).on('keydown.autocomplete', function (e) {
        var c, caretPosition, i, initial, prev, prevIsGood, stopFound, term, total, userToComplete;

        if (e.ctrlKey || e.altKey || e.metaKey) {
          return true;
        }

        if (options.allowAny) {
          // saves us wiring up a change event as well

          Ember.run.cancel(inputTimeout);
          inputTimeout = Ember.run.later(function () {
            if (inputSelectedItems.length === 0) {
              inputSelectedItems.push("");
            }

            if (_.isString(inputSelectedItems[0]) && me.val().length > 0) {
              inputSelectedItems.pop();
              inputSelectedItems.push(me.val());
              if (options.onChangeItems) {
                options.onChangeItems(inputSelectedItems);
              }
            }
          }, 50);
        }

        if (!options.key) {
          completeStart = 0;
        }
        if (e.which === keys.shift) return;
        if (completeStart === null && e.which === keys.backSpace && options.key) {
          c = Discourse.Utilities.caretPosition(me[0]);
          c -= 1;
          initial = c;
          prevIsGood = true;
          while (prevIsGood && c >= 0) {
            c -= 1;
            prev = me[0].value[c];
            stopFound = prev === options.key;
            if (stopFound) {
              prev = me[0].value[c - 1];
              if (checkTriggerRule({ backSpace: true }) && (!prev || allowedLettersRegex.test(prev))) {
                completeStart = c;
                caretPosition = completeEnd = initial;
                term = me[0].value.substring(c + 1, initial);
                updateAutoComplete(dataSource(term, options));
                return true;
              }
            }
            prevIsGood = /[a-zA-Z\.-]/.test(prev);
          }
        }

        // ESC
        if (e.which === keys.esc) {
          if (div !== null) {
            closeAutocomplete();
            return false;
          }
          return true;
        }

        if (completeStart !== null) {
          caretPosition = Discourse.Utilities.caretPosition(me[0]);

          // allow people to right arrow out of completion
          if (e.which === keys.rightArrow && me[0].value[caretPosition] === ' ') {
            closeAutocomplete();
            return true;
          }

          // If we've backspaced past the beginning, cancel unless no key
          if (caretPosition <= completeStart && options.key) {
            closeAutocomplete();
            return true;
          }

          // Keyboard codes! So 80's.
          switch (e.which) {
            case keys.enter:
            case keys.tab:
              if (!autocompleteOptions) return true;
              if (selectedOption >= 0 && (userToComplete = autocompleteOptions[selectedOption])) {
                completeTerm(userToComplete);
              } else {
                // We're cancelling it, really.
                return true;
              }
              e.stopImmediatePropagation();
              return false;
            case keys.upArrow:
              selectedOption = selectedOption - 1;
              if (selectedOption < 0) {
                selectedOption = 0;
              }
              markSelected();
              return false;
            case keys.downArrow:
              total = autocompleteOptions.length;
              selectedOption = selectedOption + 1;
              if (selectedOption >= total) {
                selectedOption = total - 1;
              }
              if (selectedOption < 0) {
                selectedOption = 0;
              }
              markSelected();
              return false;
            case keys.backSpace:
              completeEnd = caretPosition;
              caretPosition--;

              if (caretPosition < 0) {
                closeAutocomplete();
                if (isInput) {
                  i = wrap.find('a:last');
                  if (i) {
                    i.click();
                  }
                }
                return true;
              }

              term = me.val().substring(completeStart + (options.key ? 1 : 0), caretPosition);

              if (completeStart === caretPosition && term === options.key) {
                closeAutocomplete();
              }

              updateAutoComplete(dataSource(term, options));
              return true;
            default:
              completeEnd = caretPosition;
              return true;
          }
        }
      });

      return this;
    }
  });
define("discourse/lib/after-transition", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
      CSS transitions are a PITA, often we need to queue some js after a transition, this helper ensures
      it happens after the transition.

      SO: http://stackoverflow.com/questions/9943435/css3-animation-end-techniques
    **/

    var dummy = document.createElement("div"),
        eventNameHash = {
      webkit: "webkitTransitionEnd",
      Moz: "transitionend",
      O: "oTransitionEnd",
      ms: "MSTransitionEnd"
    };

    var transitionEnd = (function () {
      var retValue;
      retValue = "transitionend";
      Object.keys(eventNameHash).some(function (vendor) {
        if (vendor + "TransitionProperty" in dummy.style) {
          retValue = eventNameHash[vendor];
          return true;
        }
      });
      return retValue;
    })();

    __exports__["default"] = function (element, callback) {
      return $(element).on(transitionEnd, callback);
    }
  });
define("discourse/lib/safari-hacks", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.isWorkaroundActive = isWorkaroundActive;
    function applicable() {
      // IE has no DOMNodeInserted so can not get this hack despite saying it is like iPhone
      // This will apply hack on all iDevices
      return navigator.userAgent.match(/(iPad|iPhone|iPod)/g) && navigator.userAgent.match(/Safari/g) && !navigator.userAgent.match(/Trident/g);
    }

    var workaroundActive = false;

    function isWorkaroundActive() {
      return workaroundActive;
    }

    // per http://stackoverflow.com/questions/29001977/safari-in-ios8-is-scrolling-screen-when-fixed-elements-get-focus/29064810
    function positioningWorkaround($fixedElement) {
      if (!applicable()) {
        return;
      }

      var fixedElement = $fixedElement[0];

      var done = false;
      var originalScrollTop = 0;

      var blurredNow = function (evt) {
        if (!done && _.include($(document.activeElement).parents(), fixedElement)) {
          // something in focus so skip
          return;
        }

        done = true;

        $('#main-outlet').show();
        $('header').show();

        fixedElement.style.position = '';
        fixedElement.style.top = '';
        fixedElement.style.height = '';

        $(window).scrollTop(originalScrollTop);

        if (evt) {
          evt.target.removeEventListener('blur', blurred);
        }
        workaroundActive = false;
      };

      var blurred = _.debounce(blurredNow, 250);

      var positioningHack = function (evt) {
        var self = this;
        done = false;

        // we need this, otherwise changing focus means we never clear
        self.addEventListener('blur', blurred);

        if (fixedElement.style.top === '0px') {
          if (this !== document.activeElement) {
            evt.preventDefault();
            self.focus();
          }
          return;
        }

        originalScrollTop = $(window).scrollTop();

        // take care of body

        $('#main-outlet').hide();
        $('header').hide();

        $(window).scrollTop(0);

        fixedElement.style.top = '0px';

        fixedElement.style.height = parseInt(window.innerHeight * 0.6) + "px";

        // I used to do this, but it seems like we don't need to with position
        // fixed
        // setTimeout(()=>$(window).scrollTop(0),500);

        evt.preventDefault();
        self.focus();
        workaroundActive = true;
      };

      function attachTouchStart(elem, fn) {
        if (!$(elem).data('listening')) {
          elem.addEventListener('touchstart', fn);
          $(elem).data('listening', true);
        }
      }

      var checkForInputs = _.debounce(function () {
        $fixedElement.find('button:not(.hide-preview),a:not(.mobile-file-upload):not(.toggle-toolbar)').each(function (idx, elem) {
          if ($(elem).parents('.autocomplete').length > 0) {
            return;
          }

          if ($(elem).parents('.d-editor-button-bar').length > 0) {
            return;
          }

          attachTouchStart(this, function (evt) {
            done = true;
            $(document.activeElement).blur();
            evt.preventDefault();
            $(this).click();
          });
        });
        $fixedElement.find('input[type=text],textarea').each(function () {
          attachTouchStart(this, positioningHack);
        });
      }, 100);

      fixedElement.addEventListener('DOMNodeInserted', checkForInputs);
    }

    __exports__["default"] = positioningWorkaround;
  });
define("discourse/adapters/email-template", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestAdapter = __dependency1__["default"];

    __exports__["default"] = RestAdapter.extend({
      basePath: function () {
        return "/admin/customize/";
      }
    });
  });
define("discourse/adapters/notification", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestAdapter = __dependency1__["default"];

    __exports__["default"] = RestAdapter.extend({ cache: true });
  });
define("discourse/adapters/post-reply-history", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestAdapter = __dependency1__["default"];

    __exports__["default"] = RestAdapter.extend({
      find: function (store, type, findArgs) {
        var maxReplies = Discourse.SiteSettings.max_reply_history;
        return Discourse.ajax('/posts/' + findArgs.postId + '/reply-history?max_replies=' + maxReplies).then(function (replies) {
          return { post_reply_histories: replies };
        });
      }
    });
  });
define("discourse/adapters/post-reply", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestAdapter = __dependency1__["default"];

    __exports__["default"] = RestAdapter.extend({
      find: function (store, type, findArgs) {
        return Discourse.ajax('/posts/' + findArgs.postId + '/replies').then(function (replies) {
          return { post_replies: replies };
        });
      }
    });
  });
define("discourse/adapters/post", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestAdapter = __dependency1__["default"];
    var Result = __dependency1__.Result;

    __exports__["default"] = RestAdapter.extend({

      find: function (store, type, findArgs) {
        return this._super(store, type, findArgs).then(function (result) {
          return { post: result };
        });
      },

      createRecord: function (store, type, args) {
        var typeField = Ember.String.underscore(type);
        args.nested_post = true;
        return Discourse.ajax(this.pathFor(store, type), { method: 'POST', data: args }).then(function (json) {
          return new Result(json[typeField], json);
        });
      }

    });
  });
define("discourse/adapters/rest", 
  ["discourse/lib/hash","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.Result = Result;
    var hashString = __dependency1__.hashString;

    var ADMIN_MODELS = ['plugin', 'site-customization', 'embeddable-host'];

    function Result(payload, responseJson) {
      this.payload = payload;
      this.responseJson = responseJson;
      this.target = null;
    }

    var ajax = Discourse.ajax;

    // We use this to make sure 404s are caught
    function rethrow(error) {
      if (error.status === 404) {
        throw "404: " + error.responseText;
      }
      throw error;
    }

    __exports__["default"] = Ember.Object.extend({

      storageKey: function (type, findArgs, options) {
        if (options && options.cacheKey) {
          return options.cacheKey;
        }
        var hashedArgs = Math.abs(hashString(JSON.stringify(findArgs)));
        return type + '_' + hashedArgs;
      },

      basePath: function (store, type) {
        if (ADMIN_MODELS.indexOf(type.replace('_', '-')) !== -1) {
          return "/admin/";
        }
        return "/";
      },

      appendQueryParams: function (path, findArgs) {
        if (findArgs) {
          if (typeof findArgs === "object") {
            var queryString = Object.keys(findArgs).reject(function (k) {
              return !findArgs[k];
            }).map(function (k) {
              return k + "=" + encodeURIComponent(findArgs[k]);
            });

            if (queryString.length) {
              return path + "?" + queryString.join('&');
            }
          } else {
            // It's serializable as a string if not an object
            return path + "/" + findArgs;
          }
        }
        return path;
      },

      pathFor: function (store, type, findArgs) {
        var path = this.basePath(store, type, findArgs) + Ember.String.underscore(store.pluralize(type));
        return this.appendQueryParams(path, findArgs);
      },

      findAll: function (store, type) {
        return ajax(this.pathFor(store, type)).catch(rethrow);
      },

      find: function (store, type, findArgs) {
        return ajax(this.pathFor(store, type, findArgs)).catch(rethrow);
      },

      findStale: function (store, type, findArgs, options) {
        if (this.cached) {
          return this.cached[this.storageKey(type, findArgs, options)];
        }
      },

      cacheFind: function (store, type, findArgs, opts, hydrated) {
        this.cached = this.cached || {};
        this.cached[this.storageKey(type, findArgs, opts)] = hydrated;
      },

      update: function (store, type, id, attrs) {
        var data = {};
        var typeField = Ember.String.underscore(type);
        data[typeField] = attrs;
        return ajax(this.pathFor(store, type, id), { method: 'PUT', data: data }).then(function (json) {
          return new Result(json[typeField], json);
        });
      },

      createRecord: function (store, type, attrs) {
        var data = {};
        var typeField = Ember.String.underscore(type);
        data[typeField] = attrs;
        return ajax(this.pathFor(store, type), { method: 'POST', data: data }).then(function (json) {
          return new Result(json[typeField], json);
        });
      },

      destroyRecord: function (store, type, record) {
        return ajax(this.pathFor(store, type, record.get('id')), { method: 'DELETE' });
      }

    });
  });
define("discourse/adapters/tag-notification", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RESTAdapter = __dependency1__["default"];

    __exports__["default"] = RESTAdapter.extend({
      pathFor: function (store, type, id) {
        return "/tags/" + id + "/notifications";
      }
    });
  });
define("discourse/adapters/topic-list", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.finderFor = finderFor;
    var RestAdapter = __dependency1__["default"];

    function finderFor(filter, params) {
      return function () {
        var url = Discourse.getURL("/") + filter + ".json";

        if (params) {
          (function () {
            var keys = Object.keys(params),
                encoded = [];

            keys.forEach(function (p) {
              var value = encodeURI(params[p]);
              if (typeof value !== 'undefined') {
                encoded.push(p + "=" + value);
              }
            });

            if (encoded.length > 0) {
              url += "?" + encoded.join('&');
            }
          })();
        }
        return Discourse.ajax(url);
      };
    }

    __exports__["default"] = RestAdapter.extend({

      find: function (store, type, findArgs) {
        var filter = findArgs.filter;
        var params = findArgs.params;

        return PreloadStore.getAndRemove("topic_list_" + filter, finderFor(filter, params)).then(function (result) {
          result.filter = filter;
          result.params = params;
          return result;
        });
      }
    });
  });
define("discourse/adapters/topic", 
  ["discourse/adapters/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestAdapter = __dependency1__["default"];

    __exports__["default"] = RestAdapter.extend({
      find: function (store, type, findArgs) {
        if (findArgs.similar) {
          return Discourse.ajax("/topics/similar_to", { data: findArgs.similar });
        } else {
          return this._super(store, type, findArgs);
        }
      }
    });
  });
define("discourse/models/result-set", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.ArrayProxy.extend({
      loading: false,
      loadingMore: false,
      totalRows: 0,
      refreshing: false,

      content: null,
      loadMoreUrl: null,
      refreshUrl: null,
      findArgs: null,
      store: null,
      __type: null,

      canLoadMore: (function () {
        return this.get('length') < this.get('totalRows');
      }).property('totalRows', 'length'),

      loadMore: function () {
        var _this = this;

        var loadMoreUrl = this.get('loadMoreUrl');
        if (!loadMoreUrl) {
          return;
        }

        var totalRows = this.get('totalRows');
        if (this.get('length') < totalRows && !this.get('loadingMore')) {
          var _ret = (function () {
            _this.set('loadingMore', true);

            var self = _this;
            return {
              v: _this.store.appendResults(_this, _this.get('__type'), loadMoreUrl).finally(function () {
                self.set('loadingMore', false);
              })
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        }

        return Ember.RSVP.resolve();
      },

      refresh: function () {
        if (this.get('refreshing')) {
          return;
        }

        var refreshUrl = this.get('refreshUrl');
        if (!refreshUrl) {
          return;
        }

        var self = this;
        this.set('refreshing', true);
        return this.store.refreshResults(this, this.get('__type'), refreshUrl).finally(function () {
          self.set('refreshing', false);
        });
      }
    });
  });
define("discourse/models/store", 
  ["discourse/models/rest","discourse/models/result-set","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];
    var ResultSet = __dependency2__["default"];

    var _identityMap = undefined;

    // You should only call this if you're a test scaffold
    function flushMap() {
      _identityMap = {};
    }

    function storeMap(type, id, obj) {
      if (!id) {
        return;
      }

      _identityMap[type] = _identityMap[type] || {};
      _identityMap[type][id] = obj;
    }

    function fromMap(type, id) {
      var byType = _identityMap[type];
      if (byType) {
        return byType[id];
      }
    }

    function removeMap(type, id) {
      var byType = _identityMap[type];
      if (byType) {
        delete byType[id];
      }
    }

    function findAndRemoveMap(type, id) {
      var byType = _identityMap[type];
      if (byType) {
        var result = byType[id];
        delete byType[id];
        return result;
      }
    }

    flushMap();

    __exports__["default"] = Ember.Object.extend({
      _plurals: { 'post-reply': 'post-replies',
        'post-reply-history': 'post_reply_histories' },

      pluralize: function (thing) {
        return this._plurals[thing] || thing + "s";
      },

      addPluralization: function (thing, plural) {
        this._plurals[thing] = plural;
      },

      findAll: function (type) {
        var self = this;
        return this.adapterFor(type).findAll(this, type).then(function (result) {
          return self._resultSet(type, result);
        });
      },

      // Mostly for legacy, things like TopicList without ResultSets
      findFiltered: function (type, findArgs) {
        var self = this;
        return this.adapterFor(type).find(this, type, findArgs).then(function (result) {
          return self._build(type, result);
        });
      },

      _hydrateFindResults: function (result, type, findArgs) {
        if (typeof findArgs === "object") {
          return this._resultSet(type, result, findArgs);
        } else {
          return this._hydrate(type, result[Ember.String.underscore(type)], result);
        }
      },

      // See if the store can find stale data. We sometimes prefer to show stale data and
      // refresh it in the background.
      findStale: function (type, findArgs, opts) {
        var _this = this;

        var stale = this.adapterFor(type).findStale(this, type, findArgs, opts);
        return {
          hasResults: stale !== undefined,
          results: stale,
          refresh: function () {
            return _this.find(type, findArgs, opts);
          }
        };
      },

      find: function (type, findArgs, opts) {
        var _this2 = this;

        var adapter = this.adapterFor(type);
        return adapter.find(this, type, findArgs, opts).then(function (result) {
          var hydrated = _this2._hydrateFindResults(result, type, findArgs, opts);
          if (adapter.cache) {
            var stale = adapter.findStale(_this2, type, findArgs, opts);
            hydrated = _this2._updateStale(stale, hydrated);
            adapter.cacheFind(_this2, type, findArgs, opts, hydrated);
          }
          return hydrated;
        });
      },

      _updateStale: function (stale, hydrated) {
        if (!stale) {
          return hydrated;
        }

        hydrated.set('content', hydrated.get('content').map(function (item) {
          var staleItem = stale.content.findBy('id', item.get('id'));
          if (staleItem) {
            staleItem.setProperties(item);
          } else {
            staleItem = item;
          }
          return staleItem;
        }));
        return hydrated;
      },

      refreshResults: function (resultSet, type, url) {
        var self = this;
        return Discourse.ajax(url).then(function (result) {
          var typeName = Ember.String.underscore(self.pluralize(type));
          var content = result[typeName].map(function (obj) {
            return self._hydrate(type, obj, result);
          });
          resultSet.set('content', content);
        });
      },

      appendResults: function (resultSet, type, url) {
        var self = this;

        return Discourse.ajax(url).then(function (result) {
          var typeName = Ember.String.underscore(self.pluralize(type)),
              totalRows = result["total_rows_" + typeName] || result.get('totalRows'),
              loadMoreUrl = result["load_more_" + typeName],
              content = result[typeName].map(function (obj) {
            return self._hydrate(type, obj, result);
          });

          resultSet.setProperties({ totalRows: totalRows, loadMoreUrl: loadMoreUrl });
          resultSet.get('content').pushObjects(content);

          // If we've loaded them all, clear the load more URL
          if (resultSet.get('length') >= totalRows) {
            resultSet.set('loadMoreUrl', null);
          }
        });
      },

      update: function (type, id, attrs) {
        return this.adapterFor(type).update(this, type, id, attrs, function (result) {
          if (result && result[type] && result[type].id) {
            var oldRecord = findAndRemoveMap(type, id);
            storeMap(type, result[type].id, oldRecord);
          }
          return result;
        });
      },

      createRecord: function (type, attrs) {
        attrs = attrs || {};
        return !!attrs.id ? this._hydrate(type, attrs) : this._build(type, attrs);
      },

      destroyRecord: function (type, record) {
        // If the record is new, don't perform an Ajax call
        if (record.get('isNew')) {
          removeMap(type, record.get('id'));
          return Ember.RSVP.Promise.resolve(true);
        }

        return this.adapterFor(type).destroyRecord(this, type, record).then(function (result) {
          removeMap(type, record.get('id'));
          return result;
        });
      },

      _resultSet: function (type, result, findArgs) {
        var _this3 = this;

        var typeName = Ember.String.underscore(this.pluralize(type));
        var content = result[typeName].map(function (obj) {
          return _this3._hydrate(type, obj, result);
        });

        var createArgs = {
          content: content,
          findArgs: findArgs,
          totalRows: result["total_rows_" + typeName] || content.length,
          loadMoreUrl: result["load_more_" + typeName],
          refreshUrl: result['refresh_' + typeName],
          store: this,
          __type: type
        };

        if (result.extras) {
          createArgs.extras = result.extras;
        }

        return ResultSet.create(createArgs);
      },

      _build: function (type, obj) {
        obj.store = this;
        obj.__type = type;
        obj.__state = obj.id ? "created" : "new";

        // TODO: Have injections be automatic
        obj.topicTrackingState = this.container.lookup('topic-tracking-state:main');
        obj.keyValueStore = this.container.lookup('key-value-store:main');

        var klass = this.container.lookupFactory('model:' + type) || RestModel;
        var model = klass.create(obj);

        storeMap(type, obj.id, model);
        return model;
      },

      adapterFor: function (type) {
        return this.container.lookup('adapter:' + type) || this.container.lookup('adapter:rest');
      },

      _lookupSubType: function (subType, type, id, root) {
        var _this4 = this;

        // cheat: we know we already have categories in memory
        // TODO: topics do their own resolving of `category_id`
        // to category. That should either respect this or be
        // removed.
        if (subType === 'category' && type !== 'topic') {
          return Discourse.Category.findById(id);
        }

        var pluralType = this.pluralize(subType);
        var collection = root[this.pluralize(subType)];
        if (collection) {
          var _ret = (function () {
            var hashedProp = "__hashed_" + pluralType;
            var hashedCollection = root[hashedProp];
            if (!hashedCollection) {
              hashedCollection = {};
              collection.forEach(function (it) {
                hashedCollection[it.id] = it;
              });
              root[hashedProp] = hashedCollection;
            }

            var found = hashedCollection[id];
            if (found) {
              var hydrated = _this4._hydrate(subType, found, root);
              hashedCollection[id] = hydrated;
              return {
                v: hydrated
              };
            }
          })();

          if (typeof _ret === 'object') return _ret.v;
        }
      },

      _hydrateEmbedded: function (type, obj, root) {
        var self = this;
        Object.keys(obj).forEach(function (k) {
          var m = /(.+)\_id(s?)$/.exec(k);
          if (m) {
            (function () {
              var subType = m[1];

              if (m[2]) {
                var hydrated = obj[k].map(function (id) {
                  return self._lookupSubType(subType, type, id, root);
                });
                obj[self.pluralize(subType)] = hydrated || [];
                delete obj[k];
              } else {
                var hydrated = self._lookupSubType(subType, type, obj[k], root);
                if (hydrated) {
                  obj[subType] = hydrated;
                  delete obj[k];
                }
              }
            })();
          }
        });
      },

      _hydrate: function (type, obj, root) {
        if (!obj) {
          throw "Can't hydrate " + type + " of `null`";
        }
        if (!obj.id) {
          throw "Can't hydrate " + type + " without an `id`";
        }

        root = root || obj;

        // Experimental: If serialized with a certain option we'll wire up embedded objects
        // automatically.
        if (root.__rest_serializer === "1") {
          this._hydrateEmbedded(type, obj, root);
        }

        var existing = fromMap(type, obj.id);
        if (existing === obj) {
          return existing;
        }

        if (existing) {
          delete obj.id;
          var klass = this.container.lookupFactory('model:' + type) || RestModel;
          existing.setProperties(klass.munge(obj));
          return existing;
        }

        return this._build(type, obj);
      }
    });

    __exports__.flushMap = flushMap;
  });
define("discourse/models/post-action-type", 
  ["discourse/models/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];

    var PostActionType = RestModel.extend({
      notCustomFlag: Em.computed.not('is_custom_flag')
    });

    var MAX_MESSAGE_LENGTH = 500;

    __exports__.MAX_MESSAGE_LENGTH = MAX_MESSAGE_LENGTH;
    __exports__["default"] = PostActionType;
  });
define("discourse/models/action-summary", 
  ["discourse/models/rest","discourse/lib/ajax-error","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];
    var popupAjaxError = __dependency2__.popupAjaxError;

    __exports__["default"] = RestModel.extend({

      canToggle: (function () {
        return this.get('can_undo') || this.get('can_act');
      }).property('can_undo', 'can_act'),

      // Remove it
      removeAction: function () {
        this.setProperties({
          acted: false,
          count: this.get('count') - 1,
          can_act: true,
          can_undo: false
        });
      },

      togglePromise: function (post) {
        return this.get('acted') ? this.undo(post) : this.act(post);
      },

      toggle: function (post) {
        if (!this.get('acted')) {
          this.act(post);
          return true;
        } else {
          this.undo(post);
          return false;
        }
      },

      // Perform this action
      act: function (post, opts) {

        if (!opts) opts = {};

        var action = this.get('actionType.name_key');

        // Mark it as acted
        this.setProperties({
          acted: true,
          count: this.get('count') + 1,
          can_act: false,
          can_undo: true
        });

        if (action === 'notify_moderators' || action === 'notify_user') {
          this.set('can_undo', false);
          this.set('can_defer_flags', false);
        }

        // Create our post action
        var self = this;
        return Discourse.ajax("/post_actions", {
          type: 'POST',
          data: {
            id: this.get('flagTopic') ? this.get('flagTopic.id') : post.get('id'),
            post_action_type_id: this.get('id'),
            message: opts.message,
            is_warning: opts.isWarning,
            take_action: opts.takeAction,
            flag_topic: this.get('flagTopic') ? true : false
          },
          returnXHR: true
        }).then(function (data) {
          if (!self.get('flagTopic')) {
            post.updateActionsSummary(data.result);
          }
          var remaining = parseInt(data.xhr.getResponseHeader('Discourse-Actions-Remaining') || 0);
          var max = parseInt(data.xhr.getResponseHeader('Discourse-Actions-Max') || 0);
          return { acted: true, remaining: remaining, max: max };
        }).catch(function (error) {
          popupAjaxError(error);
          self.removeAction(post);
        });
      },

      // Undo this action
      undo: function (post) {
        this.removeAction(post);

        // Remove our post action
        return Discourse.ajax("/post_actions/" + post.get('id'), {
          type: 'DELETE',
          data: { post_action_type_id: this.get('id') }
        }).then(function (result) {
          post.updateActionsSummary(result);
          return { acted: false };
        });
      },

      deferFlags: function (post) {
        var _this = this;

        return Discourse.ajax("/post_actions/defer_flags", {
          type: "POST",
          data: { post_action_type_id: this.get("id"), id: post.get('id') }
        }).then(function () {
          return _this.set('count', 0);
        });
      }
    });
  });
define("discourse/models/post", 
  ["discourse/models/rest","discourse/lib/ajax-error","discourse/models/action-summary","discourse/lib/computed","discourse/lib/quote","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var RestModel = __dependency1__["default"];
    var popupAjaxError = __dependency2__.popupAjaxError;
    var ActionSummary = __dependency3__["default"];
    var url = __dependency4__.url;
    var propertyEqual = __dependency4__.propertyEqual;
    var Quote = __dependency5__["default"];
    var computed = __dependency6__["default"];

    var Post = RestModel.extend(_createDecoratedObject([{
      key: 'siteSettings',
      decorators: [computed()],
      value: function () {
        // TODO: Remove this once one instantiate all `Discourse.Post` models via the store.
        return Discourse.SiteSettings;
      }
    }, {
      key: 'shareUrl',
      initializer: function () {
        return (function () {
          var user = Discourse.User.current();
          var userSuffix = user ? '?u=' + user.get('username_lower') : '';

          if (this.get('firstPost')) {
            return this.get('topic.url') + userSuffix;
          } else {
            return this.get('url') + userSuffix;
          }
        }).property('url');
      }
    }, {
      key: 'new_user',
      initializer: function () {
        return Em.computed.equal('trust_level', 0);
      }
    }, {
      key: 'firstPost',
      initializer: function () {
        return Em.computed.equal('post_number', 1);
      }
    }, {
      key: 'deletedViaTopic',

      // Posts can show up as deleted if the topic is deleted
      initializer: function () {
        return Em.computed.and('firstPost', 'topic.deleted_at');
      }
    }, {
      key: 'deleted',
      initializer: function () {
        return Em.computed.or('deleted_at', 'deletedViaTopic');
      }
    }, {
      key: 'notDeleted',
      initializer: function () {
        return Em.computed.not('deleted');
      }
    }, {
      key: 'showName',
      initializer: function () {
        return (function () {
          var name = this.get('name');
          return name && name !== this.get('username') && Discourse.SiteSettings.display_name_on_posts;
        }).property('name', 'username');
      }
    }, {
      key: 'postDeletedBy',
      initializer: function () {
        return (function () {
          if (this.get('firstPost')) {
            return this.get('topic.deleted_by');
          }
          return this.get('deleted_by');
        }).property('firstPost', 'deleted_by', 'topic.deleted_by');
      }
    }, {
      key: 'postDeletedAt',
      initializer: function () {
        return (function () {
          if (this.get('firstPost')) {
            return this.get('topic.deleted_at');
          }
          return this.get('deleted_at');
        }).property('firstPost', 'deleted_at', 'topic.deleted_at');
      }
    }, {
      key: 'url',
      initializer: function () {
        return (function () {
          return Discourse.Utilities.postUrl(this.get('topic.slug') || this.get('topic_slug'), this.get('topic_id'), this.get('post_number'));
        }).property('post_number', 'topic_id', 'topic.slug');
      }
    }, {
      key: 'urlWithNumber',
      decorators: [computed('post_number', 'url')],
      value: function (postNumber, postUrl) {
        return postNumber === 1 ? postUrl + "/1" : postUrl;
      }
    }, {
      key: 'usernameUrl',
      initializer: function () {
        return url('username', '/users/%@');
      }
    }, {
      key: 'topicOwner',
      initializer: function () {
        return propertyEqual('topic.details.created_by.id', 'user_id');
      }
    }, {
      key: 'updatePostField',
      value: function (field, value) {
        var _this = this;

        var data = {};
        data[field] = value;

        return Discourse.ajax('/posts/' + this.get('id') + '/' + field, { type: 'PUT', data: data }).then(function () {
          _this.set(field, value);
          _this.incrementProperty("version");
        }).catch(popupAjaxError);
      }
    }, {
      key: 'internalLinks',
      initializer: function () {
        return (function () {
          if (Ember.isEmpty(this.get('link_counts'))) return null;
          return this.get('link_counts').filterProperty('internal').filterProperty('title');
        }).property('link_counts.@each.internal');
      }
    }, {
      key: 'flagsAvailable',
      initializer: function () {
        return (function () {
          var post = this;
          return Discourse.Site.currentProp('flagTypes').filter(function (item) {
            return post.get("actionByName." + item.get('name_key') + ".can_act");
          });
        }).property('actions_summary.@each.can_act');
      }
    }, {
      key: 'afterUpdate',
      value: function (res) {
        if (res.category) {
          Discourse.Site.current().updateCategory(res.category);
        }
      }
    }, {
      key: 'updateProperties',
      value: function () {
        return {
          post: { raw: this.get('raw'), edit_reason: this.get('editReason') },
          image_sizes: this.get('imageSizes')
        };
      }
    }, {
      key: 'createProperties',
      value: function () {
        // composer only used once, defer the dependency
        var Composer = require('discourse/models/composer').default;
        var data = this.getProperties(Composer.serializedFieldsForCreate());
        data.reply_to_post_number = this.get('reply_to_post_number');
        data.image_sizes = this.get('imageSizes');

        var metaData = this.get('metaData');

        // Put the metaData into the request
        if (metaData) {
          data.meta_data = {};
          Object.keys(metaData).forEach(function (key) {
            data.meta_data[key] = metaData.get(key);
          });
        }

        return data;
      }
    }, {
      key: 'expand',

      // Expands the first post's content, if embedded and shortened.
      value: function () {
        var self = this;
        return Discourse.ajax("/posts/" + this.get('id') + "/expand-embed").then(function (post) {
          self.set('cooked', "<section class='expanded-embed'>" + post.cooked + "</section>");
        });
      }
    }, {
      key: 'recover',

      // Recover a deleted post
      value: function () {
        var post = this,
            initProperties = post.getProperties('deleted_at', 'deleted_by', 'user_deleted', 'can_delete');

        post.setProperties({
          deleted_at: null,
          deleted_by: null,
          user_deleted: false,
          can_delete: false
        });

        return Discourse.ajax("/posts/" + this.get('id') + "/recover", { type: 'PUT', cache: false }).then(function (data) {
          post.setProperties({
            cooked: data.cooked,
            raw: data.raw,
            user_deleted: false,
            can_delete: true,
            version: data.version
          });
        }).catch(function (error) {
          popupAjaxError(error);
          post.setProperties(initProperties);
        });
      }
    }, {
      key: 'setDeletedState',

      /**
        Changes the state of the post to be deleted. Does not call the server, that should be
        done elsewhere.
      **/
      value: function (deletedBy) {
        this.set('oldCooked', this.get('cooked'));

        // Moderators can delete posts. Users can only trigger a deleted at message, unless delete_removed_posts_after is 0.
        if (deletedBy.get('staff') || Discourse.SiteSettings.delete_removed_posts_after === 0) {
          this.setProperties({
            deleted_at: new Date(),
            deleted_by: deletedBy,
            can_delete: false
          });
        } else {
          this.setProperties({
            cooked: Discourse.Markdown.cook(I18n.t("post.deleted_by_author", { count: Discourse.SiteSettings.delete_removed_posts_after })),
            can_delete: false,
            version: this.get('version') + 1,
            can_recover: true,
            can_edit: false,
            user_deleted: true
          });
        }
      }
    }, {
      key: 'undoDeleteState',

      /**
        Changes the state of the post to NOT be deleted. Does not call the server.
        This can only be called after setDeletedState was called, but the delete
        failed on the server.
      **/
      value: function () {
        if (this.get('oldCooked')) {
          this.setProperties({
            deleted_at: null,
            deleted_by: null,
            cooked: this.get('oldCooked'),
            version: this.get('version') - 1,
            can_recover: false,
            can_delete: true,
            user_deleted: false
          });
        }
      }
    }, {
      key: 'destroy',
      value: function (deletedBy) {
        this.setDeletedState(deletedBy);
        return Discourse.ajax("/posts/" + this.get('id'), {
          data: { context: window.location.pathname },
          type: 'DELETE'
        });
      }
    }, {
      key: 'updateFromPost',

      /**
        Updates a post from another's attributes. This will normally happen when a post is loading but
        is already found in an identity map.
      **/
      value: function (otherPost) {
        var self = this;
        Object.keys(otherPost).forEach(function (key) {
          var value = otherPost[key],
              oldValue = self[key];

          if (!value) {
            value = null;
          }
          if (!oldValue) {
            oldValue = null;
          }

          var skip = false;
          if (typeof value !== "function" && oldValue !== value) {
            // wishing for an identity map
            if (key === "reply_to_user" && value && oldValue) {
              skip = value.username === oldValue.username || Em.get(value, "username") === Em.get(oldValue, "username");
            }

            if (!skip) {
              self.set(key, value);
            }
          }
        });
      }
    }, {
      key: 'expandHidden',
      value: function () {
        var _this2 = this;

        return Discourse.ajax("/posts/" + this.get('id') + "/cooked.json").then(function (result) {
          _this2.setProperties({ cooked: result.cooked, cooked_hidden: false });
        });
      }
    }, {
      key: 'rebake',
      value: function () {
        return Discourse.ajax("/posts/" + this.get("id") + "/rebake", { type: "PUT" });
      }
    }, {
      key: 'unhide',
      value: function () {
        return Discourse.ajax("/posts/" + this.get("id") + "/unhide", { type: "PUT" });
      }
    }, {
      key: 'toggleBookmark',
      value: function () {
        var self = this;
        var bookmarkedTopic = undefined;

        this.toggleProperty("bookmarked");

        if (this.get("bookmarked") && !this.get("topic.bookmarked")) {
          this.set("topic.bookmarked", true);
          bookmarkedTopic = true;
        }

        // need to wait to hear back from server (stuff may not be loaded)

        return Discourse.Post.updateBookmark(this.get('id'), this.get('bookmarked')).then(function (result) {
          self.set("topic.bookmarked", result.topic_bookmarked);
        }).catch(function (e) {
          self.toggleProperty("bookmarked");
          if (bookmarkedTopic) {
            self.set("topic.bookmarked", false);
          }
          throw e;
        });
      }
    }, {
      key: 'updateActionsSummary',
      value: function (json) {
        if (json && json.id === this.get('id')) {
          json = Post.munge(json);
          this.set('actions_summary', json.actions_summary);
        }
      }
    }, {
      key: 'revertToRevision',
      value: function (version) {
        return Discourse.ajax('/posts/' + this.get('id') + '/revisions/' + version + '/revert', { type: 'PUT' });
      }
    }]));

    Post.reopenClass({

      munge: function (json) {
        if (json.actions_summary) {
          (function () {
            var lookup = Em.Object.create();

            // this area should be optimized, it is creating way too many objects per post
            json.actions_summary = json.actions_summary.map(function (a) {
              a.actionType = Discourse.Site.current().postActionTypeById(a.id);
              a.count = a.count || 0;
              var actionSummary = ActionSummary.create(a);
              lookup[a.actionType.name_key] = actionSummary;

              if (a.actionType.name_key === "like") {
                json.likeAction = actionSummary;
              }
              return actionSummary;
            });

            json.actionByName = lookup;
          })();
        }

        if (json && json.reply_to_user) {
          json.reply_to_user = Discourse.User.create(json.reply_to_user);
        }
        return json;
      },

      updateBookmark: function (postId, bookmarked) {
        return Discourse.ajax("/posts/" + postId + "/bookmark", {
          type: 'PUT',
          data: { bookmarked: bookmarked }
        });
      },

      deleteMany: function (selectedPosts, selectedReplies) {
        return Discourse.ajax("/posts/destroy_many", {
          type: 'DELETE',
          data: {
            post_ids: selectedPosts.map(function (p) {
              return p.get('id');
            }),
            reply_post_ids: selectedReplies.map(function (p) {
              return p.get('id');
            })
          }
        });
      },

      loadRevision: function (postId, version) {
        return Discourse.ajax("/posts/" + postId + "/revisions/" + version + ".json").then(function (result) {
          return Ember.Object.create(result);
        });
      },

      hideRevision: function (postId, version) {
        return Discourse.ajax("/posts/" + postId + "/revisions/" + version + "/hide", { type: 'PUT' });
      },

      showRevision: function (postId, version) {
        return Discourse.ajax("/posts/" + postId + "/revisions/" + version + "/show", { type: 'PUT' });
      },

      loadQuote: function (postId) {
        return Discourse.ajax("/posts/" + postId + ".json").then(function (result) {
          var post = Discourse.Post.create(result);
          return Quote.build(post, post.get('raw'), { raw: true, full: true });
        });
      },

      loadRawEmail: function (postId) {
        return Discourse.ajax('/posts/' + postId + '/raw-email.json');
      }

    });

    __exports__["default"] = Post;

    // Don't drop the /1
  });

Discourse.Post = require('discourse/models/post').default;
define("discourse/lib/posts-with-placeholders", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.Placeholder = Placeholder;

    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__.default;

    function Placeholder(viewName) {
      this.viewName = viewName;
    }

    __exports__["default"] = Ember.Object.extend(Ember.Array, _createDecoratedObject([{
      key: 'posts',
      initializer: function () {
        return null;
      }
    }, {
      key: '_appendingIds',
      initializer: function () {
        return null;
      }
    }, {
      key: 'init',
      value: function () {
        this._appendingIds = {};
      }
    }, {
      key: 'length',
      decorators: [computed],
      value: function () {
        return this.get('posts.length') + Object.keys(this._appendingIds || {}).length;
      }
    }, {
      key: '_changeArray',
      value: function (cb, offset, removed, inserted) {
        this.arrayContentWillChange(offset, removed, inserted);
        cb();
        this.arrayContentDidChange(offset, removed, inserted);
        this.propertyDidChange('length');
      }
    }, {
      key: 'clear',
      value: function (cb) {
        this._changeArray(cb, 0, this.get('posts.length'), 0);
      }
    }, {
      key: 'appendPost',
      value: function (cb) {
        this._changeArray(cb, this.get('posts.length'), 0, 1);
      }
    }, {
      key: 'removePost',
      value: function (cb) {
        this._changeArray(cb, this.get('posts.length') - 1, 1, 0);
      }
    }, {
      key: 'refreshAll',
      value: function (cb) {
        var length = this.get('posts.length');
        this._changeArray(cb, 0, length, length);
      }
    }, {
      key: 'appending',
      value: function (postIds) {
        var _this = this;

        this._changeArray(function () {
          var appendingIds = _this._appendingIds;
          postIds.forEach(function (pid) {
            return appendingIds[pid] = true;
          });
        }, this.get('length'), 0, postIds.length);
      }
    }, {
      key: 'finishedAppending',
      value: function (postIds) {
        var _this2 = this;

        this._changeArray(function () {
          var appendingIds = _this2._appendingIds;
          postIds.forEach(function (pid) {
            return delete appendingIds[pid];
          });
        }, this.get('posts.length') - postIds.length, postIds.length, postIds.length);
      }
    }, {
      key: 'finishedPrepending',
      value: function (postIds) {
        this._changeArray(Ember.K, 0, 0, postIds.length);
      }
    }, {
      key: 'objectAt',
      value: function (index) {
        var posts = this.get('posts');
        return index < posts.length ? posts[index] : new Placeholder('post-placeholder');
      }
    }]));
  });
define("discourse/models/post-stream", 
  ["discourse/lib/url","discourse/models/rest","discourse/lib/posts-with-placeholders","ember-addons/ember-computed-decorators","discourse/models/topic","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var DiscourseURL = __dependency1__["default"];
    var RestModel = __dependency2__["default"];
    var PostsWithPlaceholders = __dependency3__["default"];
    var computed = __dependency4__.default;
    var loadTopicView = __dependency5__.loadTopicView;

    __exports__["default"] = RestModel.extend(_createDecoratedObject([{
      key: '_identityMap',
      initializer: function () {
        return null;
      }
    }, {
      key: 'posts',
      initializer: function () {
        return null;
      }
    }, {
      key: 'stream',
      initializer: function () {
        return null;
      }
    }, {
      key: 'userFilters',
      initializer: function () {
        return null;
      }
    }, {
      key: 'summary',
      initializer: function () {
        return null;
      }
    }, {
      key: 'loaded',
      initializer: function () {
        return null;
      }
    }, {
      key: 'loadingAbove',
      initializer: function () {
        return null;
      }
    }, {
      key: 'loadingBelow',
      initializer: function () {
        return null;
      }
    }, {
      key: 'loadingFilter',
      initializer: function () {
        return null;
      }
    }, {
      key: 'stagingPost',
      initializer: function () {
        return null;
      }
    }, {
      key: 'postsWithPlaceholders',
      initializer: function () {
        return null;
      }
    }, {
      key: 'init',
      value: function () {
        this._identityMap = {};
        var posts = [];
        var postsWithPlaceholders = PostsWithPlaceholders.create({ posts: posts, store: this.store });

        this.setProperties({
          posts: posts,
          postsWithPlaceholders: postsWithPlaceholders,
          stream: [],
          userFilters: [],
          summary: false,
          loaded: false,
          loadingAbove: false,
          loadingBelow: false,
          loadingFilter: false,
          stagingPost: false
        });
      }
    }, {
      key: 'loading',
      initializer: function () {
        return Ember.computed.or('loadingAbove', 'loadingBelow', 'loadingFilter', 'stagingPost');
      }
    }, {
      key: 'notLoading',
      initializer: function () {
        return Ember.computed.not('loading');
      }
    }, {
      key: 'filteredPostsCount',
      initializer: function () {
        return Ember.computed.alias("stream.length");
      }
    }, {
      key: 'hasPosts',
      decorators: [computed('posts.[]')],
      value: function () {
        return this.get('posts.length') > 0;
      }
    }, {
      key: 'hasLoadedData',
      decorators: [computed('hasPosts', 'filteredPostsCount')],
      value: function (hasPosts, filteredPostsCount) {
        return hasPosts && filteredPostsCount > 0;
      }
    }, {
      key: 'canAppendMore',
      initializer: function () {
        return Ember.computed.and('notLoading', 'hasPosts', 'lastPostNotLoaded');
      }
    }, {
      key: 'canPrependMore',
      initializer: function () {
        return Ember.computed.and('notLoading', 'hasPosts', 'firstPostNotLoaded');
      }
    }, {
      key: 'firstPostPresent',
      decorators: [computed('hasLoadedData', 'firstPostId', 'posts.[]')],
      value: function (hasLoadedData, firstPostId) {
        if (!hasLoadedData) {
          return false;
        }
        return !!this.get('posts').findProperty('id', firstPostId);
      }
    }, {
      key: 'firstPostNotLoaded',
      initializer: function () {
        return Ember.computed.not('firstPostPresent');
      }
    }, {
      key: 'firstPostId',
      initializer: function () {
        return Ember.computed.alias('stream.firstObject');
      }
    }, {
      key: 'lastPostId',
      initializer: function () {
        return Ember.computed.alias('stream.lastObject');
      }
    }, {
      key: 'loadedAllPosts',
      decorators: [computed('hasLoadedData', 'lastPostId', 'posts.@each.id')],
      value: function (hasLoadedData, lastPostId) {
        if (!hasLoadedData) {
          return false;
        }
        if (lastPostId === -1) {
          return true;
        }

        return !!this.get('posts').findProperty('id', lastPostId);
      }
    }, {
      key: 'lastPostNotLoaded',
      initializer: function () {
        return Ember.computed.not('loadedAllPosts');
      }
    }, {
      key: 'streamFilters',
      decorators: [computed('summary', 'show_deleted', 'userFilters.[]')],
      value: function (summary, showDeleted) {
        var result = {};
        if (summary) {
          result.filter = "summary";
        }
        if (showDeleted) {
          result.show_deleted = true;
        }

        var userFilters = this.get('userFilters');
        if (!Ember.isEmpty(userFilters)) {
          result.username_filters = userFilters.join(",");
        }

        return result;
      }
    }, {
      key: 'hasNoFilters',
      decorators: [computed('streamFilters.[]', 'topic.posts_count', 'posts.length')],
      value: function () {
        var streamFilters = this.get('streamFilters');
        return !(streamFilters && (streamFilters.filter === 'summary' || streamFilters.username_filters));
      }
    }, {
      key: 'previousWindow',
      decorators: [computed('posts.[]', 'stream.[]')],
      value: function () {
        // If we can't find the last post loaded, bail
        var firstPost = _.first(this.get('posts'));
        if (!firstPost) {
          return [];
        }

        // Find the index of the last post loaded, if not found, bail
        var stream = this.get('stream');
        var firstIndex = this.indexOf(firstPost);
        if (firstIndex === -1) {
          return [];
        }

        var startIndex = firstIndex - this.get('topic.chunk_size');
        if (startIndex < 0) {
          startIndex = 0;
        }
        return stream.slice(startIndex, firstIndex);
      }
    }, {
      key: 'nextWindow',
      decorators: [computed('posts.lastObject', 'stream.[]')],
      value: function (lastLoadedPost) {
        // If we can't find the last post loaded, bail
        if (!lastLoadedPost) {
          return [];
        }

        // Find the index of the last post loaded, if not found, bail
        var stream = this.get('stream');
        var lastIndex = this.indexOf(lastLoadedPost);
        if (lastIndex === -1) {
          return [];
        }
        if (lastIndex + 1 >= this.get('highest_post_number')) {
          return [];
        }

        // find our window of posts
        return stream.slice(lastIndex + 1, lastIndex + this.get('topic.chunk_size') + 1);
      }
    }, {
      key: 'cancelFilter',
      value: function () {
        this.set('summary', false);
        this.set('show_deleted', false);
        this.get('userFilters').clear();
      }
    }, {
      key: 'toggleSummary',
      value: function () {
        var _this = this;

        this.get('userFilters').clear();
        this.toggleProperty('summary');

        return this.refresh().then(function () {
          if (_this.get('summary')) {
            _this.jumpToSecondVisible();
          }
        });
      }
    }, {
      key: 'toggleDeleted',
      value: function () {
        this.toggleProperty('show_deleted');
        return this.refresh();
      }
    }, {
      key: 'jumpToSecondVisible',
      value: function () {
        var posts = this.get('posts');
        if (posts.length > 1) {
          var secondPostNum = posts[1].get('post_number');
          DiscourseURL.jumpToPost(secondPostNum);
        }
      }
    }, {
      key: 'toggleParticipant',

      // Filter the stream to a particular user.
      value: function (username) {
        var _this2 = this;

        var userFilters = this.get('userFilters');
        this.set('summary', false);
        this.set('show_deleted', true);

        var jump = false;
        if (userFilters.contains(username)) {
          userFilters.removeObject(username);
        } else {
          userFilters.addObject(username);
          jump = true;
        }
        return this.refresh().then(function () {
          if (jump) {
            _this2.jumpToSecondVisible();
          }
        });
      }
    }, {
      key: 'refresh',

      /**
        Loads a new set of posts into the stream. If you provide a `nearPost` option and the post
        is already loaded, it will simply scroll there and load nothing.
      **/
      value: function (opts) {
        var _this3 = this;

        opts = opts || {};
        opts.nearPost = parseInt(opts.nearPost, 10);

        if (opts.cancelSummary) {
          this.set('summary', false);
          delete opts.cancelSummary;
        }

        var topic = this.get('topic');

        // Do we already have the post in our list of posts? Jump there.
        if (opts.forceLoad) {
          this.set('loaded', false);
        } else {
          var postWeWant = this.get('posts').findProperty('post_number', opts.nearPost);
          if (postWeWant) {
            return Ember.RSVP.resolve();
          }
        }

        // TODO: if we have all the posts in the filter, don't go to the server for them.
        this.set('loadingFilter', true);

        opts = _.merge(opts, this.get('streamFilters'));

        // Request a topicView
        return loadTopicView(topic, opts).then(function (json) {
          _this3.updateFromJson(json.post_stream);
          _this3.setProperties({ loadingFilter: false, loaded: true });
        }).catch(function (result) {
          _this3.errorLoading(result);
          throw result;
        });
      }
    }, {
      key: 'collapsePosts',
      value: function (from, to) {
        var posts = this.get('posts');
        var remove = posts.filter(function (post) {
          var postNumber = post.get('post_number');
          return postNumber >= from && postNumber <= to;
        });

        posts.removeObjects(remove);

        // make gap
        this.set('gaps', this.get('gaps') || { before: {}, after: {} });
        var before = this.get('gaps.before');
        var post = posts.find(function (p) {
          return p.get('post_number') > to;
        });

        before[post.get('id')] = remove.map(function (p) {
          return p.get('id');
        });
        post.set('hasGap', true);

        this.get('stream').enumerableContentDidChange();
      }
    }, {
      key: 'fillGapBefore',

      // Fill in a gap of posts before a particular post
      value: function (post, gap) {
        var _this4 = this;

        var postId = post.get('id'),
            stream = this.get('stream'),
            idx = stream.indexOf(postId),
            currentPosts = this.get('posts');

        if (idx !== -1) {
          var _ret = (function () {
            // Insert the gap at the appropriate place
            stream.splice.apply(stream, [idx, 0].concat(gap));

            var postIdx = currentPosts.indexOf(post);
            var origIdx = postIdx;
            if (postIdx !== -1) {
              return {
                v: _this4.findPostsByIds(gap).then(function (posts) {
                  posts.forEach(function (p) {
                    var stored = _this4.storePost(p);
                    if (!currentPosts.contains(stored)) {
                      currentPosts.insertAt(postIdx++, stored);
                    }
                  });

                  delete _this4.get('gaps.before')[postId];
                  _this4.get('stream').enumerableContentDidChange();
                  _this4.get('postsWithPlaceholders').arrayContentDidChange(origIdx, 0, posts.length);
                  post.set('hasGap', false);
                })
              };
            }
          })();

          if (typeof _ret === 'object') return _ret.v;
        }
        return Ember.RSVP.resolve();
      }
    }, {
      key: 'fillGapAfter',

      // Fill in a gap of posts after a particular post
      value: function (post, gap) {
        var _this5 = this;

        var postId = post.get('id'),
            stream = this.get('stream'),
            idx = stream.indexOf(postId);

        if (idx !== -1) {
          stream.pushObjects(gap);
          return this.appendMore().then(function () {
            delete _this5.get('gaps.after')[postId];
            _this5.get('stream').enumerableContentDidChange();
          });
        }
        return Ember.RSVP.resolve();
      }
    }, {
      key: 'appendMore',

      // Appends the next window of posts to the stream. Call it when scrolling downwards.
      value: function () {
        var _this6 = this;

        // Make sure we can append more posts
        if (!this.get('canAppendMore')) {
          return Ember.RSVP.resolve();
        }

        var postIds = this.get('nextWindow');
        if (Ember.isEmpty(postIds)) {
          return Ember.RSVP.resolve();
        }

        this.set('loadingBelow', true);
        var postsWithPlaceholders = this.get('postsWithPlaceholders');
        postsWithPlaceholders.appending(postIds);
        return this.findPostsByIds(postIds).then(function (posts) {
          posts.forEach(function (p) {
            return _this6.appendPost(p);
          });
          return posts;
        }).finally(function () {
          postsWithPlaceholders.finishedAppending(postIds);
          _this6.set('loadingBelow', false);
        });
      }
    }, {
      key: 'prependMore',

      // Prepend the previous window of posts to the stream. Call it when scrolling upwards.
      value: function () {
        var _this7 = this;

        // Make sure we can append more posts
        if (!this.get('canPrependMore')) {
          return Ember.RSVP.resolve();
        }

        var postIds = this.get('previousWindow');
        if (Ember.isEmpty(postIds)) {
          return Ember.RSVP.resolve();
        }

        this.set('loadingAbove', true);
        return this.findPostsByIds(postIds.reverse()).then(function (posts) {
          posts.forEach(function (p) {
            return _this7.prependPost(p);
          });
        }).finally(function () {
          var postsWithPlaceholders = _this7.get('postsWithPlaceholders');
          postsWithPlaceholders.finishedPrepending(postIds);
          _this7.set('loadingAbove', false);
        });
      }
    }, {
      key: 'stagePost',

      /**
        Stage a post for insertion in the stream. It should be rendered right away under the
        assumption that the post will succeed. We can then `commitPost` when it succeeds or
        `undoPost` when it fails.
      **/
      value: function (post, user) {
        // We can't stage two posts simultaneously
        if (this.get('stagingPost')) {
          return "alreadyStaging";
        }

        this.set('stagingPost', true);

        var topic = this.get('topic');
        topic.setProperties({
          posts_count: (topic.get('posts_count') || 0) + 1,
          last_posted_at: new Date(),
          'details.last_poster': user,
          highest_post_number: (topic.get('highest_post_number') || 0) + 1
        });

        post.setProperties({
          post_number: topic.get('highest_post_number'),
          topic: topic,
          created_at: new Date(),
          id: -1
        });

        // If we're at the end of the stream, add the post
        if (this.get('loadedAllPosts')) {
          this.appendPost(post);
          this.get('stream').addObject(post.get('id'));
          return "staged";
        }

        return "offScreen";
      }
    }, {
      key: 'commitPost',

      // Commit the post we staged. Call this after a save succeeds.
      value: function (post) {
        if (this.get('topic.id') === post.get('topic_id')) {
          if (this.get('loadedAllPosts')) {
            this.appendPost(post);
            this.get('stream').addObject(post.get('id'));
          }
        }

        this.get('stream').removeObject(-1);
        this._identityMap[-1] = null;
        this.set('stagingPost', false);
      }
    }, {
      key: 'undoPost',

      /**
        Undo a post we've staged in the stream. Remove it from being rendered and revert the
        state we changed.
      **/
      value: function (post) {
        var _this8 = this;

        this.get('stream').removeObject(-1);
        this.get('postsWithPlaceholders').removePost(function () {
          return _this8.posts.removeObject(post);
        });
        this._identityMap[-1] = null;

        var topic = this.get('topic');
        this.set('stagingPost', false);

        topic.setProperties({
          highest_post_number: (topic.get('highest_post_number') || 0) - 1,
          posts_count: (topic.get('posts_count') || 0) - 1
        });

        // TODO unfudge reply count on parent post
      }
    }, {
      key: 'prependPost',
      value: function (post) {
        var stored = this.storePost(post);
        if (stored) {
          var posts = this.get('posts');
          posts.unshiftObject(stored);
        }

        return post;
      }
    }, {
      key: 'appendPost',
      value: function (post) {
        var _this9 = this;

        var stored = this.storePost(post);
        if (stored) {
          (function () {
            var posts = _this9.get('posts');

            if (!posts.contains(stored)) {
              if (!_this9.get('loadingBelow')) {
                _this9.get('postsWithPlaceholders').appendPost(function () {
                  return posts.pushObject(stored);
                });
              } else {
                posts.pushObject(stored);
              }
            }

            if (stored.get('id') !== -1) {
              _this9.set('lastAppended', stored);
            }
          })();
        }
        return post;
      }
    }, {
      key: 'removePosts',
      value: function (posts) {
        var _this10 = this;

        if (Ember.isEmpty(posts)) {
          return;
        }

        this.get('postsWithPlaceholders').refreshAll(function () {
          var allPosts = _this10.get('posts');
          var postIds = posts.map(function (p) {
            return p.get('id');
          });
          var identityMap = _this10._identityMap;

          _this10.get('stream').removeObjects(postIds);
          allPosts.removeObjects(posts);
          postIds.forEach(function (id) {
            return delete identityMap[id];
          });
        });
      }
    }, {
      key: 'findLoadedPost',

      // Returns a post from the identity map if it's been inserted.
      value: function (id) {
        return this._identityMap[id];
      }
    }, {
      key: 'loadPost',
      value: function (postId) {
        var _this11 = this;

        var url = "/posts/" + postId;
        var store = this.store;

        return Discourse.ajax(url).then(function (p) {
          return _this11.storePost(store.createRecord('post', p));
        });
      }
    }, {
      key: 'triggerNewPostInStream',

      /**
        Finds and adds a post to the stream by id. Typically this would happen if we receive a message
        from the message bus indicating there's a new post. We'll only insert it if we currently
        have no filters.
      **/
      value: function (postId) {
        var _this12 = this;

        var resolved = Ember.RSVP.Promise.resolve();

        if (!postId) {
          return resolved;
        }

        // We only trigger if there are no filters active
        if (!this.get('hasNoFilters')) {
          return resolved;
        }

        var loadedAllPosts = this.get('loadedAllPosts');

        if (this.get('stream').indexOf(postId) === -1) {
          this.get('stream').addObject(postId);
          if (loadedAllPosts) {
            this.set('loadingLastPost', true);
            return this.findPostsByIds([postId]).then(function (posts) {
              posts.forEach(function (p) {
                return _this12.appendPost(p);
              });
            }).finally(function () {
              _this12.set('loadingLastPost', false);
            });
          }
        }

        return resolved;
      }
    }, {
      key: 'triggerRecoveredPost',
      value: function (postId) {
        var _this13 = this;

        var existing = this._identityMap[postId];

        if (existing) {
          return this.triggerChangedPost(postId, new Date());
        } else {
          var _ret3 = (function () {
            // need to insert into stream
            var url = "/posts/" + postId;
            var store = _this13.store;
            return {
              v: Discourse.ajax(url).then(function (p) {
                var post = store.createRecord('post', p);
                var stream = _this13.get("stream");
                var posts = _this13.get("posts");
                _this13.storePost(post);

                // we need to zip this into the stream
                var index = 0;
                stream.forEach(function (pid) {
                  if (pid < p.id) {
                    index += 1;
                  }
                });

                stream.insertAt(index, p.id);

                index = 0;
                posts.forEach(function (_post) {
                  if (_post.id < p.id) {
                    index += 1;
                  }
                });

                if (index < posts.length) {
                  posts.insertAt(index, post);
                } else {
                  if (post.post_number < posts[posts.length - 1].post_number + 5) {
                    _this13.appendMore();
                  }
                }
              })
            };
          })();

          if (typeof _ret3 === 'object') return _ret3.v;
        }
      }
    }, {
      key: 'triggerDeletedPost',
      value: function (postId) {
        var _this14 = this;

        var existing = this._identityMap[postId];

        if (existing) {
          var _ret4 = (function () {
            var url = "/posts/" + postId;
            var store = _this14.store;

            return {
              v: Discourse.ajax(url).then(function (p) {
                _this14.storePost(store.createRecord('post', p));
              }).catch(function () {
                _this14.removePosts([existing]);
              })
            };
          })();

          if (typeof _ret4 === 'object') return _ret4.v;
        }
        return Ember.RSVP.Promise.resolve();
      }
    }, {
      key: 'triggerChangedPost',
      value: function (postId, updatedAt) {
        var _this15 = this;

        var resolved = Ember.RSVP.Promise.resolve();
        if (!postId) {
          return resolved;
        }

        var existing = this._identityMap[postId];
        if (existing && existing.updated_at !== updatedAt) {
          var _ret5 = (function () {
            var url = "/posts/" + postId;
            var store = _this15.store;
            return {
              v: Discourse.ajax(url).then(function (p) {
                return _this15.storePost(store.createRecord('post', p));
              })
            };
          })();

          if (typeof _ret5 === 'object') return _ret5.v;
        }
        return resolved;
      }
    }, {
      key: 'closestPostForPostNumber',

      /**
        Returns the closest post given a postNumber that may not exist in the stream.
        For example, if the user asks for a post that's deleted or otherwise outside the range.
        This allows us to set the progress bar with the correct number.
      **/
      value: function (postNumber) {
        if (!this.get('hasPosts')) {
          return;
        }

        var closest = null;
        this.get('posts').forEach(function (p) {
          if (!closest) {
            closest = p;
            return;
          }

          if (Math.abs(postNumber - p.get('post_number')) < Math.abs(closest.get('post_number') - postNumber)) {
            closest = p;
          }
        });

        return closest;
      }
    }, {
      key: 'progressIndexOfPost',

      // Get the index of a post in the stream. (Use this for the topic progress bar.)
      value: function (post) {
        return this.progressIndexOfPostId(post.get('id'));
      }
    }, {
      key: 'progressIndexOfPostId',

      // Get the index in the stream of a post id. (Use this for the topic progress bar.)
      value: function (postId) {
        return this.get('stream').indexOf(postId) + 1;
      }
    }, {
      key: 'closestPostNumberFor',

      /**
        Returns the closest post number given a postNumber that may not exist in the stream.
        For example, if the user asks for a post that's deleted or otherwise outside the range.
        This allows us to set the progress bar with the correct number.
      **/
      value: function (postNumber) {
        if (!this.get('hasPosts')) {
          return;
        }

        var closest = null;
        this.get('posts').forEach(function (p) {
          if (closest === postNumber) {
            return;
          }
          if (!closest) {
            closest = p.get('post_number');
          }

          if (Math.abs(postNumber - p.get('post_number')) < Math.abs(closest - postNumber)) {
            closest = p.get('post_number');
          }
        });

        return closest;
      }
    }, {
      key: 'findPostIdForPostNumber',

      // Find a postId for a postNumber, respecting gaps
      value: function (postNumber) {
        var stream = this.get('stream'),
            beforeLookup = this.get('gaps.before'),
            streamLength = stream.length;

        var sum = 1;
        for (var i = 0; i < streamLength; i++) {
          var pid = stream[i];

          // See if there are posts before this post
          if (beforeLookup) {
            var before = beforeLookup[pid];
            if (before) {
              for (var j = 0; j < before.length; j++) {
                if (sum === postNumber) {
                  return pid;
                }
                sum++;
              }
            }
          }

          if (sum === postNumber) {
            return pid;
          }
          sum++;
        }
      }
    }, {
      key: 'updateFromJson',
      value: function (postStreamData) {
        var _this16 = this;

        var posts = this.get('posts');

        var postsWithPlaceholders = this.get('postsWithPlaceholders');
        postsWithPlaceholders.clear(function () {
          return posts.clear();
        });

        this.set('gaps', null);
        if (postStreamData) {
          (function () {
            // Load posts if present
            var store = _this16.store;
            postStreamData.posts.forEach(function (p) {
              return _this16.appendPost(store.createRecord('post', p));
            });
            delete postStreamData.posts;

            // Update our attributes
            _this16.setProperties(postStreamData);
          })();
        }
      }
    }, {
      key: 'storePost',

      /**
        Stores a post in our identity map, and sets up the references it needs to
        find associated objects like the topic. It might return a different reference
        than you supplied if the post has already been loaded.
      **/
      value: function (post) {
        // Calling `Ember.get(undefined)` raises an error
        if (!post) {
          return;
        }

        var postId = Ember.get(post, 'id');
        if (postId) {
          var existing = this._identityMap[post.get('id')];

          // Update the `highest_post_number` if this post is higher.
          var postNumber = post.get('post_number');
          if (postNumber && postNumber > (this.get('topic.highest_post_number') || 0)) {
            this.set('topic.highest_post_number', postNumber);
          }

          if (existing) {
            // If the post is in the identity map, update it and return the old reference.
            existing.updateFromPost(post);
            return existing;
          }

          post.set('topic', this.get('topic'));
          this._identityMap[post.get('id')] = post;
        }
        return post;
      }
    }, {
      key: 'findPostsByIds',
      value: function (postIds) {
        var identityMap = this._identityMap;
        var unloaded = postIds.filter(function (p) {
          return !identityMap[p];
        });

        // Load our unloaded posts by id
        return this.loadIntoIdentityMap(unloaded).then(function () {
          return postIds.map(function (p) {
            return identityMap[p];
          }).compact();
        });
      }
    }, {
      key: 'loadIntoIdentityMap',
      value: function (postIds) {
        var _this17 = this;

        if (Ember.isEmpty(postIds)) {
          return Ember.RSVP.resolve([]);
        }

        var url = "/t/" + this.get('topic.id') + "/posts.json";
        var data = { post_ids: postIds };
        var store = this.store;
        return Discourse.ajax(url, { data: data }).then(function (result) {
          var posts = Ember.get(result, "post_stream.posts");
          if (posts) {
            posts.forEach(function (p) {
              return _this17.storePost(store.createRecord('post', p));
            });
          }
        });
      }
    }, {
      key: 'indexOf',
      value: function (post) {
        return this.get('stream').indexOf(post.get('id'));
      }
    }, {
      key: 'errorLoading',

      // Handles an error loading a topic based on a HTTP status code. Updates
      // the text to the correct values.
      value: function (result) {
        var status = result.jqXHR.status;

        var topic = this.get('topic');
        this.set('loadingFilter', false);
        topic.set('errorLoading', true);

        // If the result was 404 the post is not found
        // If it was 410 the post is deleted and the user should not see it
        if (status === 404 || status === 410) {
          topic.set('notFoundHtml', result.jqXHR.responseText);
          return;
        }

        // If the result is 403 it means invalid access
        if (status === 403) {
          topic.set('noRetry', true);
          if (Discourse.User.current()) {
            topic.set('message', I18n.t('topic.invalid_access.description'));
          } else {
            topic.set('message', I18n.t('topic.invalid_access.login_required'));
          }
          return;
        }

        // Otherwise supply a generic error message
        topic.set('message', I18n.t('topic.server_error.description'));
      }
    }]));

    /**
      Returns a JS Object of current stream filter options. It should match the query
      params for the stream.
    **/

    /**
      Returns the window of posts above the current set in the stream, bound to the top of the stream.
      This is the collection we'll ask for when scrolling upwards.
    **/

    /**
      Returns the window of posts below the current set in the stream, bound by the bottom of the
      stream. This is the collection we use when scrolling downwards.
    **/
  });
define("discourse/models/topic-details", 
  ["discourse/models/rest","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    /**
      A model representing a Topic's details that aren't always present, such as a list of participants.
      When showing topics in lists and such this information should not be required.
    **/

    var RestModel = __dependency1__["default"];

    var TopicDetails = RestModel.extend({
      loaded: false,

      updateFromJson: function (details) {
        var _this = this;

        var topic = this.get('topic');

        if (details.allowed_users) {
          details.allowed_users = details.allowed_users.map(function (u) {
            return Discourse.User.create(u);
          });
        }

        if (details.suggested_topics) {
          (function () {
            var store = _this.store;
            details.suggested_topics = details.suggested_topics.map(function (st) {
              return store.createRecord('topic', st);
            });
          })();
        }

        if (details.participants) {
          details.participants = details.participants.map(function (p) {
            p.topic = topic;
            return Ember.Object.create(p);
          });
        }

        this.setProperties(details);
        this.set('loaded', true);
      },

      notificationReasonText: (function () {
        var level = this.get('notification_level');
        if (typeof level !== 'number') {
          level = 1;
        }

        var localeString = "topic.notifications.reasons." + level;
        if (typeof this.get('notifications_reason_id') === 'number') {
          var tmp = localeString + "_" + this.get('notifications_reason_id');
          // some sane protection for missing translations of edge cases
          if (I18n.lookup(tmp)) {
            localeString = tmp;
          }
        }
        return I18n.t(localeString, { username: Discourse.User.currentProp('username_lower') });
      }).property('notification_level', 'notifications_reason_id'),

      updateNotifications: function (v) {
        this.set('notification_level', v);
        this.set('notifications_reason_id', null);
        return Discourse.ajax("/t/" + this.get('topic.id') + "/notifications", {
          type: 'POST',
          data: { notification_level: v }
        });
      },

      removeAllowedUser: function (user) {
        var users = this.get('allowed_users');
        var username = user.get('username');

        return Discourse.ajax("/t/" + this.get('topic.id') + "/remove-allowed-user", {
          type: 'PUT',
          data: { username: username }
        }).then(function () {
          users.removeObject(users.findProperty('username', username));
        });
      }
    });

    __exports__["default"] = TopicDetails;
  });
define("discourse/models/topic", 
  ["discourse/models/store","discourse/models/rest","discourse/lib/computed","discourse/lib/formatter","ember-addons/ember-computed-decorators","discourse/models/action-summary","discourse/lib/ajax-error","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __exports__) {
    "use strict";
    __exports__.loadTopicView = loadTopicView;
    __exports__.movePosts = movePosts;
    __exports__.mergeTopic = mergeTopic;

    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var flushMap = __dependency1__.flushMap;
    var RestModel = __dependency2__["default"];
    var propertyEqual = __dependency3__.propertyEqual;
    var longDate = __dependency4__.longDate;
    var computed = __dependency5__["default"];
    var ActionSummary = __dependency6__["default"];
    var popupAjaxError = __dependency7__.popupAjaxError;

    function loadTopicView(topic, args) {
      var topicId = topic.get('id');
      var data = _.merge({}, args);
      var url = Discourse.getURL("/t/") + topicId;
      var jsonUrl = (data.nearPost ? url + '/' + data.nearPost : url) + '.json';

      delete data.nearPost;
      delete data.__type;
      delete data.store;

      return PreloadStore.getAndRemove('topic_' + topicId, function () {
        return Discourse.ajax(jsonUrl, { data: data });
      }).then(function (json) {
        topic.updateFromJson(json);
        return json;
      });
    }

    var Topic = RestModel.extend(_createDecoratedObject([{
      key: 'message',
      initializer: function () {
        return null;
      }
    }, {
      key: 'errorLoading',
      initializer: function () {
        return false;
      }
    }, {
      key: 'creator',
      decorators: [computed('posters.firstObject')],
      value: function (poster) {
        return poster && poster.user;
      }
    }, {
      key: 'lastPoster',
      decorators: [computed('posters.[]')],
      value: function (posters) {
        var user;
        if (posters && posters.length > 0) {
          var latest = posters.filter(function (p) {
            return p.extras && p.extras.indexOf("latest") >= 0;
          })[0];
          user = latest && latest.user;
        }
        return user || this.get("creator");
      }
    }, {
      key: 'fancyTitle',
      decorators: [computed('fancy_title')],
      value: function (title) {
        title = title || "";
        title = Discourse.Emoji.unescape(title);
        return Discourse.CensoredWords.censor(title);
      }
    }, {
      key: 'bumpedAt',

      // returns createdAt if there's no bumped date
      initializer: function () {
        return (function () {
          var bumpedAt = this.get('bumped_at');
          if (bumpedAt) {
            return new Date(bumpedAt);
          } else {
            return this.get('createdAt');
          }
        }).property('bumped_at', 'createdAt');
      }
    }, {
      key: 'bumpedAtTitle',
      initializer: function () {
        return (function () {
          return I18n.t('first_post') + ": " + longDate(this.get('createdAt')) + "\n" + I18n.t('last_post') + ": " + longDate(this.get('bumpedAt'));
        }).property('bumpedAt');
      }
    }, {
      key: 'createdAt',
      initializer: function () {
        return (function () {
          return new Date(this.get('created_at'));
        }).property('created_at');
      }
    }, {
      key: 'postStream',
      initializer: function () {
        return (function () {
          return this.store.createRecord('postStream', { id: this.get('id'), topic: this });
        }).property();
      }
    }, {
      key: 'visibleListTags',
      decorators: [computed('tags')],
      value: function (tags) {
        if (!tags || !Discourse.SiteSettings.suppress_overlapping_tags_in_list) {
          return tags;
        }

        var title = this.get('title');
        var newTags = [];

        tags.forEach(function (tag) {
          if (title.toLowerCase().indexOf(tag) === -1 || Discourse.SiteSettings.staff_tags.indexOf(tag) !== -1) {
            newTags.push(tag);
          }
        });

        return newTags;
      }
    }, {
      key: 'replyCount',
      initializer: function () {
        return (function () {
          return this.get('posts_count') - 1;
        }).property('posts_count');
      }
    }, {
      key: 'details',
      initializer: function () {
        return (function () {
          return this.store.createRecord('topicDetails', { id: this.get('id'), topic: this });
        }).property();
      }
    }, {
      key: 'invisible',
      initializer: function () {
        return Em.computed.not('visible');
      }
    }, {
      key: 'deleted',
      initializer: function () {
        return Em.computed.notEmpty('deleted_at');
      }
    }, {
      key: 'searchContext',
      initializer: function () {
        return (function () {
          return { type: 'topic', id: this.get('id') };
        }).property('id');
      }
    }, {
      key: '_categoryIdChanged',
      initializer: function () {
        return (function () {
          this.set('category', Discourse.Category.findById(this.get('category_id')));
        }).observes('category_id').on('init');
      }
    }, {
      key: '_categoryNameChanged',
      initializer: function () {
        return (function () {
          var categoryName = this.get('categoryName');
          var category = undefined;
          if (categoryName) {
            category = Discourse.Category.list().findProperty('name', categoryName);
          }
          this.set('category', category);
        }).observes('categoryName');
      }
    }, {
      key: 'categoryClass',
      initializer: function () {
        return (function () {
          return 'category-' + this.get('category.fullSlug');
        }).property('category.fullSlug');
      }
    }, {
      key: 'shareUrl',
      initializer: function () {
        return (function () {
          var user = Discourse.User.current();
          return this.get('url') + (user ? '?u=' + user.get('username_lower') : '');
        }).property('url');
      }
    }, {
      key: 'url',
      initializer: function () {
        return (function () {
          var slug = this.get('slug') || '';
          if (slug.trim().length === 0) {
            slug = "topic";
          }
          return Discourse.getURL("/t/") + slug + "/" + this.get('id');
        }).property('id', 'slug');
      }
    }, {
      key: 'urlForPostNumber',

      // Helper to build a Url with a post number
      value: function (postNumber) {
        var url = this.get('url');
        if (postNumber && postNumber > 0) {
          url += "/" + postNumber;
        }
        return url;
      }
    }, {
      key: 'totalUnread',
      initializer: function () {
        return (function () {
          var count = (this.get('unread') || 0) + (this.get('new_posts') || 0);
          return count > 0 ? count : null;
        }).property('new_posts', 'unread');
      }
    }, {
      key: 'lastReadUrl',
      initializer: function () {
        return (function () {
          return this.urlForPostNumber(this.get('last_read_post_number'));
        }).property('url', 'last_read_post_number');
      }
    }, {
      key: 'lastUnreadUrl',
      initializer: function () {
        return (function () {
          var postNumber = Math.min(this.get('last_read_post_number') + 1, this.get('highest_post_number'));
          return this.urlForPostNumber(postNumber);
        }).property('url', 'last_read_post_number', 'highest_post_number');
      }
    }, {
      key: 'lastPostUrl',
      initializer: function () {
        return (function () {
          return this.urlForPostNumber(this.get('highest_post_number'));
        }).property('url', 'highest_post_number');
      }
    }, {
      key: 'firstPostUrl',
      initializer: function () {
        return (function () {
          return this.urlForPostNumber(1);
        }).property('url');
      }
    }, {
      key: 'summaryUrl',
      initializer: function () {
        return (function () {
          return this.urlForPostNumber(1) + (this.get('has_summary') ? "?filter=summary" : "");
        }).property('url');
      }
    }, {
      key: 'lastPosterUrl',
      initializer: function () {
        return (function () {
          return Discourse.getURL("/users/") + this.get("last_poster.username");
        }).property('last_poster');
      }
    }, {
      key: 'displayNewPosts',

      // The amount of new posts to display. It might be different than what the server
      // tells us if we are still asynchronously flushing our "recently read" data.
      // So take what the browser has seen into consideration.
      initializer: function () {
        return (function () {
          var highestSeen = Discourse.Session.currentProp('highestSeenByTopic')[this.get('id')];
          if (highestSeen) {
            var delta = highestSeen - this.get('last_read_post_number');
            if (delta > 0) {
              var result = this.get('new_posts') - delta;
              if (result < 0) {
                result = 0;
              }
              return result;
            }
          }
          return this.get('new_posts');
        }).property('new_posts', 'id');
      }
    }, {
      key: 'viewsHeat',
      initializer: function () {
        return (function () {
          var v = this.get('views');
          if (v >= Discourse.SiteSettings.topic_views_heat_high) return 'heatmap-high';
          if (v >= Discourse.SiteSettings.topic_views_heat_medium) return 'heatmap-med';
          if (v >= Discourse.SiteSettings.topic_views_heat_low) return 'heatmap-low';
          return null;
        }).property('views');
      }
    }, {
      key: 'archetypeObject',
      initializer: function () {
        return (function () {
          return Discourse.Site.currentProp('archetypes').findProperty('id', this.get('archetype'));
        }).property('archetype');
      }
    }, {
      key: 'isPrivateMessage',
      initializer: function () {
        return Em.computed.equal('archetype', 'private_message');
      }
    }, {
      key: 'isBanner',
      initializer: function () {
        return Em.computed.equal('archetype', 'banner');
      }
    }, {
      key: 'toggleStatus',
      value: function (property) {
        this.toggleProperty(property);
        this.saveStatus(property, !!this.get(property));
      }
    }, {
      key: 'saveStatus',
      value: function (property, value, until) {
        if (property === 'closed') {
          this.incrementProperty('posts_count');

          if (value === true) {
            this.set('details.auto_close_at', null);
          }
        }
        return Discourse.ajax(this.get('url') + "/status", {
          type: 'PUT',
          data: {
            status: property,
            enabled: !!value,
            until: until
          }
        });
      }
    }, {
      key: 'makeBanner',
      value: function () {
        var self = this;
        return Discourse.ajax('/t/' + this.get('id') + '/make-banner', { type: 'PUT' }).then(function () {
          self.set('archetype', 'banner');
        });
      }
    }, {
      key: 'removeBanner',
      value: function () {
        var self = this;
        return Discourse.ajax('/t/' + this.get('id') + '/remove-banner', { type: 'PUT' }).then(function () {
          self.set('archetype', 'regular');
        });
      }
    }, {
      key: 'toggleBookmark',
      value: function () {
        var _this = this;

        if (this.get('bookmarking')) {
          return Ember.RSVP.Promise.resolve();
        }
        this.set("bookmarking", true);

        var stream = this.get('postStream');
        var posts = Em.get(stream, 'posts');
        var firstPost = posts && posts[0] && posts[0].get('post_number') === 1 && posts[0];
        var bookmark = !this.get('bookmarked');
        var path = bookmark ? '/bookmark' : '/remove_bookmarks';

        var toggleBookmarkOnServer = function () {
          return Discourse.ajax('/t/' + _this.get('id') + path, { type: 'PUT' }).then(function () {
            _this.toggleProperty('bookmarked');
            if (bookmark && firstPost) {
              firstPost.set('bookmarked', true);
              return [firstPost.id];
            }
            if (!bookmark && posts) {
              var _ret = (function () {

                var updated = [];
                posts.forEach(function (post) {
                  if (post.get('bookmarked')) {
                    post.set('bookmarked', false);
                    updated.push(post.get('id'));
                  }
                });
                return {
                  v: updated
                };
              })();

              if (typeof _ret === 'object') return _ret.v;
            }

            return [];
          }).catch(function (error) {
            var showGenericError = true;
            if (error && error.responseText) {
              try {
                bootbox.alert($.parseJSON(error.responseText).errors);
                showGenericError = false;
              } catch (e) {}
            }

            if (showGenericError) {
              bootbox.alert(I18n.t('generic_error'));
            }

            throw error;
          }).finally(function () {
            return _this.set('bookmarking', false);
          });
        };

        var unbookmarkedPosts = [];
        if (!bookmark && posts) {
          posts.forEach(function (post) {
            return post.get('bookmarked') && unbookmarkedPosts.push(post);
          });
        }

        return new Ember.RSVP.Promise(function (resolve) {
          if (unbookmarkedPosts.length > 1) {
            bootbox.confirm(I18n.t("bookmarks.confirm_clear"), I18n.t("no_value"), I18n.t("yes_value"), function (confirmed) {
              return confirmed ? toggleBookmarkOnServer().then(resolve) : resolve();
            });
          } else {
            toggleBookmarkOnServer().then(resolve);
          }
        });
      }
    }, {
      key: 'createInvite',
      value: function (emailOrUsername, groupNames) {
        return Discourse.ajax("/t/" + this.get('id') + "/invite", {
          type: 'POST',
          data: { user: emailOrUsername, group_names: groupNames }
        });
      }
    }, {
      key: 'generateInviteLink',
      initializer: function () {
        return function (email, groupNames, topicId) {
          return Discourse.ajax('/invites/link', {
            type: 'POST',
            data: { email: email, group_names: groupNames, topic_id: topicId }
          });
        };
      }
    }, {
      key: 'destroy',

      // Delete this topic
      value: function (deleted_by) {
        this.setProperties({
          deleted_at: new Date(),
          deleted_by: deleted_by,
          'details.can_delete': false,
          'details.can_recover': true
        });
        return Discourse.ajax("/t/" + this.get('id'), {
          data: { context: window.location.pathname },
          type: 'DELETE'
        });
      }
    }, {
      key: 'recover',

      // Recover this topic if deleted
      value: function () {
        this.setProperties({
          deleted_at: null,
          deleted_by: null,
          'details.can_delete': true,
          'details.can_recover': false
        });
        return Discourse.ajax("/t/" + this.get('id') + "/recover", { type: 'PUT' });
      }
    }, {
      key: 'updateFromJson',

      // Update our attributes from a JSON result
      value: function (json) {
        var _this2 = this;

        this.get('details').updateFromJson(json.details);

        var keys = Object.keys(json);
        keys.removeObject('details');
        keys.removeObject('post_stream');

        keys.forEach(function (key) {
          return _this2.set(key, json[key]);
        });
      }
    }, {
      key: 'reload',
      value: function () {
        var self = this;
        return Discourse.ajax('/t/' + this.get('id'), { type: 'GET' }).then(function (topic_json) {
          self.updateFromJson(topic_json);
        });
      }
    }, {
      key: 'isPinnedUncategorized',
      initializer: function () {
        return (function () {
          return this.get('pinned') && this.get('category.isUncategorizedCategory');
        }).property('pinned', 'category.isUncategorizedCategory');
      }
    }, {
      key: 'clearPin',
      value: function () {
        var topic = this;

        // Clear the pin optimistically from the object
        topic.set('pinned', false);
        topic.set('unpinned', true);

        Discourse.ajax("/t/" + this.get('id') + "/clear-pin", {
          type: 'PUT'
        }).then(null, function () {
          // On error, put the pin back
          topic.set('pinned', true);
          topic.set('unpinned', false);
        });
      }
    }, {
      key: 'togglePinnedForUser',
      value: function () {
        if (this.get('pinned')) {
          this.clearPin();
        } else {
          this.rePin();
        }
      }
    }, {
      key: 'rePin',
      value: function () {
        var topic = this;

        // Clear the pin optimistically from the object
        topic.set('pinned', true);
        topic.set('unpinned', false);

        Discourse.ajax("/t/" + this.get('id') + "/re-pin", {
          type: 'PUT'
        }).then(null, function () {
          // On error, put the pin back
          topic.set('pinned', true);
          topic.set('unpinned', false);
        });
      }
    }, {
      key: 'hasExcerpt',
      initializer: function () {
        return Em.computed.notEmpty('excerpt');
      }
    }, {
      key: 'excerptTruncated',
      initializer: function () {
        return (function () {
          var e = this.get('excerpt');
          return e && e.substr(e.length - 8, 8) === '&hellip;';
        }).property('excerpt');
      }
    }, {
      key: 'readLastPost',
      initializer: function () {
        return propertyEqual('last_read_post_number', 'highest_post_number');
      }
    }, {
      key: 'canClearPin',
      initializer: function () {
        return Em.computed.and('pinned', 'readLastPost');
      }
    }, {
      key: 'archiveMessage',
      value: function () {
        var _this3 = this;

        this.set("archiving", true);
        var promise = Discourse.ajax('/t/' + this.get('id') + '/archive-message', { type: 'PUT' });

        promise.then(function (msg) {
          _this3.set('message_archived', true);
          if (msg && msg.group_name) {
            _this3.set('inboxGroupName', msg.group_name);
          }
        }).finally(function () {
          return _this3.set('archiving', false);
        });

        return promise;
      }
    }, {
      key: 'moveToInbox',
      value: function () {
        var _this4 = this;

        this.set("archiving", true);
        var promise = Discourse.ajax('/t/' + this.get('id') + '/move-to-inbox', { type: 'PUT' });

        promise.then(function (msg) {
          _this4.set('message_archived', false);
          if (msg && msg.group_name) {
            _this4.set('inboxGroupName', msg.group_name);
          }
        }).finally(function () {
          return _this4.set('archiving', false);
        });

        return promise;
      }
    }, {
      key: 'convertTopic',
      value: function (type) {
        return Discourse.ajax('/t/' + this.get('id') + '/convert-topic/' + type, { type: 'PUT' }).then(function () {
          window.location.reload();
        }).catch(popupAjaxError);
      }
    }]));

    Topic.reopenClass({
      NotificationLevel: {
        WATCHING: 3,
        TRACKING: 2,
        REGULAR: 1,
        MUTED: 0
      },

      createActionSummary: function (result) {
        if (result.actions_summary) {
          (function () {
            var lookup = Em.Object.create();
            result.actions_summary = result.actions_summary.map(function (a) {
              a.post = result;
              a.actionType = Discourse.Site.current().postActionTypeById(a.id);
              var actionSummary = ActionSummary.create(a);
              lookup.set(a.actionType.get('name_key'), actionSummary);
              return actionSummary;
            });
            result.set('actionByName', lookup);
          })();
        }
      },

      update: function (topic, props) {
        props = JSON.parse(JSON.stringify(props)) || {};

        // We support `category_id` and `categoryId` for compatibility
        if (typeof props.categoryId !== "undefined") {
          props.category_id = props.categoryId;
          delete props.categoryId;
        }

        // Make sure we never change the category for private messages
        if (topic.get("isPrivateMessage")) {
          delete props.category_id;
        }

        // Annoyingly, empty arrays are not sent across the wire. This
        // allows us to make a distinction between arrays that were not
        // sent and arrays that we specifically want to be empty.
        Object.keys(props).forEach(function (k) {
          var v = props[k];
          if (v instanceof Array && v.length === 0) {
            props[k + '_empty_array'] = true;
          }
        });

        return Discourse.ajax(topic.get('url'), { type: 'PUT', data: props }).then(function (result) {
          // The title can be cleaned up server side
          props.title = result.basic_topic.title;
          props.fancy_title = result.basic_topic.fancy_title;
          topic.setProperties(props);
        });
      },

      create: function () {
        var result = this._super.apply(this, arguments);
        this.createActionSummary(result);
        return result;
      },

      // Load a topic, but accepts a set of filters
      find: function (topicId, opts) {
        var url = Discourse.getURL("/t/") + topicId;
        if (opts.nearPost) {
          url += "/" + opts.nearPost;
        }

        var data = {};
        if (opts.postsAfter) {
          data.posts_after = opts.postsAfter;
        }
        if (opts.postsBefore) {
          data.posts_before = opts.postsBefore;
        }
        if (opts.trackVisit) {
          data.track_visit = true;
        }

        // Add username filters if we have them
        if (opts.userFilters && opts.userFilters.length > 0) {
          data.username_filters = [];
          opts.userFilters.forEach(function (username) {
            data.username_filters.push(username);
          });
          data.show_deleted = true;
        }

        // Add the summary of filter if we have it
        if (opts.summary === true) {
          data.summary = true;
        }

        // Check the preload store. If not, load it via JSON
        return Discourse.ajax(url + ".json", { data: data });
      },

      changeOwners: function (topicId, opts) {
        var promise = Discourse.ajax("/t/" + topicId + "/change-owner", {
          type: 'POST',
          data: opts
        }).then(function (result) {
          if (result.success) return result;
          promise.reject(new Error("error changing ownership of posts"));
        });
        return promise;
      },

      changeTimestamp: function (topicId, timestamp) {
        var promise = Discourse.ajax("/t/" + topicId + '/change-timestamp', {
          type: 'PUT',
          data: { timestamp: timestamp }
        }).then(function (result) {
          if (result.success) return result;
          promise.reject(new Error("error updating timestamp of topic"));
        });
        return promise;
      },

      bulkOperation: function (topics, operation) {
        return Discourse.ajax("/topics/bulk", {
          type: 'PUT',
          data: {
            topic_ids: topics.map(function (t) {
              return t.get('id');
            }),
            operation: operation
          }
        });
      },

      bulkOperationByFilter: function (filter, operation, categoryId) {
        var data = { filter: filter, operation: operation };
        if (categoryId) data['category_id'] = categoryId;
        return Discourse.ajax("/topics/bulk", {
          type: 'PUT',
          data: data
        });
      },

      resetNew: function () {
        return Discourse.ajax("/topics/reset-new", { type: 'PUT' });
      },

      idForSlug: function (slug) {
        return Discourse.ajax("/t/id_for/" + slug);
      }
    });

    function moveResult(result) {
      if (result.success) {
        // We should be hesitant to flush the map but moving ids is one rare case
        flushMap();
        return result;
      }
      throw "error moving posts topic";
    }

    function movePosts(topicId, data) {
      return Discourse.ajax("/t/" + topicId + "/move-posts", { type: 'POST', data: data }).then(moveResult);
    }

    function mergeTopic(topicId, destinationTopicId) {
      return Discourse.ajax("/t/" + topicId + "/merge-topic", {
        type: 'POST',
        data: { destination_topic_id: destinationTopicId }
      }).then(moveResult);
    }

    __exports__["default"] = Topic;
  });

Discourse.Topic = require('discourse/models/topic').default;
define("discourse/models/user-action", 
  ["discourse/models/rest","discourse/lib/computed","ember-addons/ember-computed-decorators","discourse/models/user-action-group","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var RestModel = __dependency1__["default"];
    var url = __dependency2__.url;
    var on = __dependency3__.on;
    var computed = __dependency3__["default"];
    var UserActionGroup = __dependency4__["default"];

    var UserActionTypes = {
      likes_given: 1,
      likes_received: 2,
      bookmarks: 3,
      topics: 4,
      posts: 5,
      replies: 6,
      mentions: 7,
      quotes: 9,
      edits: 11,
      messages_sent: 12,
      messages_received: 13,
      pending: 14
    };
    var InvertedActionTypes = {};

    _.each(UserActionTypes, function (k, v) {
      InvertedActionTypes[k] = v;
    });

    var UserAction = RestModel.extend(_createDecoratedObject([{
      key: '_attachCategory',
      decorators: [on("init")],
      value: function () {
        var categoryId = this.get('category_id');
        if (categoryId) {
          this.set('category', Discourse.Category.findById(categoryId));
        }
      }
    }, {
      key: 'descriptionKey',
      decorators: [computed("action_type")],
      value: function (action) {
        if (action === null || UserAction.TO_SHOW.indexOf(action) >= 0) {
          if (this.get('isPM')) {
            return this.get('sameUser') ? 'sent_by_you' : 'sent_by_user';
          } else {
            return this.get('sameUser') ? 'posted_by_you' : 'posted_by_user';
          }
        }

        if (this.get('topicType')) {
          return this.get('sameUser') ? 'you_posted_topic' : 'user_posted_topic';
        }

        if (this.get('postReplyType')) {
          if (this.get('reply_to_post_number')) {
            return this.get('sameUser') ? 'you_replied_to_post' : 'user_replied_to_post';
          } else {
            return this.get('sameUser') ? 'you_replied_to_topic' : 'user_replied_to_topic';
          }
        }

        if (this.get('mentionType')) {
          if (this.get('sameUser')) {
            return 'you_mentioned_user';
          } else {
            return this.get('targetUser') ? 'user_mentioned_you' : 'user_mentioned_user';
          }
        }
      }
    }, {
      key: 'sameUser',
      decorators: [computed("username")],
      value: function (username) {
        return username === Discourse.User.currentProp('username');
      }
    }, {
      key: 'targetUser',
      decorators: [computed("target_username")],
      value: function (targetUsername) {
        return targetUsername === Discourse.User.currentProp('username');
      }
    }, {
      key: 'presentName',
      initializer: function () {
        return Em.computed.any('name', 'username');
      }
    }, {
      key: 'targetDisplayName',
      initializer: function () {
        return Em.computed.any('target_name', 'target_username');
      }
    }, {
      key: 'actingDisplayName',
      initializer: function () {
        return Em.computed.any('acting_name', 'acting_username');
      }
    }, {
      key: 'targetUserUrl',
      initializer: function () {
        return url('target_username', '/users/%@');
      }
    }, {
      key: 'usernameLower',
      decorators: [computed("username")],
      value: function (username) {
        return username.toLowerCase();
      }
    }, {
      key: 'userUrl',
      initializer: function () {
        return url('usernameLower', '/users/%@');
      }
    }, {
      key: 'postUrl',
      decorators: [computed()],
      value: function () {
        return Discourse.Utilities.postUrl(this.get('slug'), this.get('topic_id'), this.get('post_number'));
      }
    }, {
      key: 'replyUrl',
      decorators: [computed()],
      value: function () {
        return Discourse.Utilities.postUrl(this.get('slug'), this.get('topic_id'), this.get('reply_to_post_number'));
      }
    }, {
      key: 'replyType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.replies);
      }
    }, {
      key: 'postType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.posts);
      }
    }, {
      key: 'topicType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.topics);
      }
    }, {
      key: 'bookmarkType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.bookmarks);
      }
    }, {
      key: 'messageSentType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.messages_sent);
      }
    }, {
      key: 'messageReceivedType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.messages_received);
      }
    }, {
      key: 'mentionType',
      initializer: function () {
        return Em.computed.equal('action_type', UserActionTypes.mentions);
      }
    }, {
      key: 'isPM',
      initializer: function () {
        return Em.computed.or('messageSentType', 'messageReceivedType');
      }
    }, {
      key: 'postReplyType',
      initializer: function () {
        return Em.computed.or('postType', 'replyType');
      }
    }, {
      key: 'removableBookmark',
      initializer: function () {
        return Em.computed.and('bookmarkType', 'sameUser');
      }
    }, {
      key: 'addChild',
      value: function (action) {
        var groups = this.get("childGroups");
        if (!groups) {
          groups = {
            likes: UserActionGroup.create({ icon: "fa fa-heart" }),
            stars: UserActionGroup.create({ icon: "fa fa-star" }),
            edits: UserActionGroup.create({ icon: "fa fa-pencil" }),
            bookmarks: UserActionGroup.create({ icon: "fa fa-bookmark" })
          };
        }
        this.set("childGroups", groups);

        var bucket = (function () {
          switch (action.action_type) {
            case UserActionTypes.likes_given:
            case UserActionTypes.likes_received:
              return "likes";
            case UserActionTypes.edits:
              return "edits";
            case UserActionTypes.bookmarks:
              return "bookmarks";
          }
        })();
        var current = groups[bucket];
        if (current) {
          current.push(action);
        }
      }
    }, {
      key: 'children',
      initializer: function () {
        return (function () {
          var g = this.get("childGroups");
          var rval = [];
          if (g) {
            rval = [g.likes, g.stars, g.edits, g.bookmarks].filter(function (i) {
              return i.get("items") && i.get("items").length > 0;
            });
          }
          return rval;
        }).property("childGroups", "childGroups.likes.items", "childGroups.likes.items.[]", "childGroups.stars.items", "childGroups.stars.items.[]", "childGroups.edits.items", "childGroups.edits.items.[]", "childGroups.bookmarks.items", "childGroups.bookmarks.items.[]");
      }
    }, {
      key: 'switchToActing',
      value: function () {
        this.setProperties({
          username: this.get('acting_username'),
          name: this.get('actingDisplayName')
        });
      }
    }]));

    UserAction.reopenClass({
      collapseStream: function (stream) {
        var uniq = {};
        var collapsed = [];
        var pos = 0;

        stream.forEach(function (item) {
          var key = "" + item.topic_id + "-" + item.post_number;
          var found = uniq[key];
          if (found === void 0) {

            var current = undefined;
            if (UserAction.TO_COLLAPSE.indexOf(item.action_type) >= 0) {
              current = UserAction.create(item);
              item.switchToActing();
              current.addChild(item);
            } else {
              current = item;
            }
            uniq[key] = pos;
            collapsed[pos] = current;
            pos += 1;
          } else {
            if (UserAction.TO_COLLAPSE.indexOf(item.action_type) >= 0) {
              item.switchToActing();
              collapsed[found].addChild(item);
            } else {
              collapsed[found].setProperties(item.getProperties('action_type', 'description'));
            }
          }
        });
        return collapsed;
      },

      TYPES: UserActionTypes,
      TYPES_INVERTED: InvertedActionTypes,

      TO_COLLAPSE: [UserActionTypes.likes_given, UserActionTypes.likes_received, UserActionTypes.edits, UserActionTypes.bookmarks],

      TO_SHOW: [UserActionTypes.likes_given, UserActionTypes.likes_received, UserActionTypes.edits, UserActionTypes.bookmarks, UserActionTypes.messages_sent, UserActionTypes.messages_received]

    });

    __exports__["default"] = UserAction;
  });

Discourse.UserAction = require('discourse/models/user-action').default;
define("discourse/models/draft", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var Draft = Discourse.Model.extend();

    Draft.reopenClass({

      clear: function (key, sequence) {
        return Discourse.ajax("/draft.json", {
          type: 'DELETE',
          data: {
            draft_key: key,
            sequence: sequence
          }
        });
      },

      get: function (key) {
        return Discourse.ajax('/draft.json', {
          data: { draft_key: key },
          dataType: 'json'
        });
      },

      getLocal: function (key, current) {
        // TODO: implement this
        return current;
      },

      save: function (key, sequence, data) {
        data = typeof data === "string" ? data : JSON.stringify(data);
        return Discourse.ajax("/draft.json", {
          type: 'POST',
          data: {
            draft_key: key,
            data: data,
            sequence: sequence
          }
        });
      }

    });

    __exports__["default"] = Draft;
  });
define("discourse/models/composer", 
  ["discourse/models/rest","discourse/models/topic","discourse/lib/ajax-error","discourse/lib/quote","discourse/models/draft","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var RestModel = __dependency1__["default"];
    var Topic = __dependency2__["default"];
    var throwAjaxError = __dependency3__.throwAjaxError;
    var Quote = __dependency4__["default"];
    var Draft = __dependency5__["default"];
    var computed = __dependency6__["default"];

    var CLOSED = 'closed',
        SAVING = 'saving',
        OPEN = 'open',
        DRAFT = 'draft',

    // The actions the composer can take
    CREATE_TOPIC = 'createTopic',
        PRIVATE_MESSAGE = 'privateMessage',
        REPLY = 'reply',
        EDIT = 'edit',
        REPLY_AS_NEW_TOPIC_KEY = "reply_as_new_topic",

    // When creating, these fields are moved into the post model from the composer model
    _create_serializer = {
      raw: 'reply',
      title: 'title',
      category: 'categoryId',
      topic_id: 'topic.id',
      is_warning: 'isWarning',
      whisper: 'whisper',
      archetype: 'archetypeId',
      target_usernames: 'targetUsernames',
      typing_duration_msecs: 'typingTime',
      composer_open_duration_msecs: 'composerTime',
      tags: 'tags'
    },
        _edit_topic_serializer = {
      title: 'topic.title',
      categoryId: 'topic.category.id',
      tags: 'topic.tags'
    };

    var Composer = RestModel.extend(_createDecoratedObject([{
      key: '_categoryId',
      initializer: function () {
        return null;
      }
    }, {
      key: 'archetypes',
      initializer: function () {
        return (function () {
          return this.site.get('archetypes');
        }).property();
      }
    }, {
      key: 'categoryId',
      decorators: [computed],
      initializer: function () {
        return {
          get: function () {
            return this._categoryId;
          },

          // We wrap categoryId this way so we can fire `applyTopicTemplate` with
          // the previous value as well as the new value
          set: function (categoryId) {
            var oldCategoryId = this._categoryId;

            if (Ember.isEmpty(categoryId)) {
              categoryId = null;
            }
            this._categoryId = categoryId;

            if (oldCategoryId !== categoryId) {
              this.applyTopicTemplate(oldCategoryId, categoryId);
            }
            return categoryId;
          }
        };
      }
    }, {
      key: 'creatingTopic',
      initializer: function () {
        return Em.computed.equal('action', CREATE_TOPIC);
      }
    }, {
      key: 'creatingPrivateMessage',
      initializer: function () {
        return Em.computed.equal('action', PRIVATE_MESSAGE);
      }
    }, {
      key: 'notCreatingPrivateMessage',
      initializer: function () {
        return Em.computed.not('creatingPrivateMessage');
      }
    }, {
      key: 'showCategoryChooser',
      decorators: [computed("privateMessage", "archetype.hasOptions")],
      value: function (isPrivateMessage, hasOptions) {
        var manyCategories = Discourse.Category.list().length > 1;
        return !isPrivateMessage && (hasOptions || manyCategories);
      }
    }, {
      key: 'privateMessage',
      decorators: [computed("creatingPrivateMessage", "topic")],
      value: function (creatingPrivateMessage, topic) {
        return creatingPrivateMessage || topic && topic.get('archetype') === 'private_message';
      }
    }, {
      key: 'topicFirstPost',
      initializer: function () {
        return Em.computed.or('creatingTopic', 'editingFirstPost');
      }
    }, {
      key: 'editingPost',
      initializer: function () {
        return Em.computed.equal('action', EDIT);
      }
    }, {
      key: 'replyingToTopic',
      initializer: function () {
        return Em.computed.equal('action', REPLY);
      }
    }, {
      key: 'viewOpen',
      initializer: function () {
        return Em.computed.equal('composeState', OPEN);
      }
    }, {
      key: 'viewDraft',
      initializer: function () {
        return Em.computed.equal('composeState', DRAFT);
      }
    }, {
      key: 'composeStateChanged',
      initializer: function () {
        return (function () {
          var oldOpen = this.get('composerOpened');

          if (this.get('composeState') === OPEN) {
            this.set('composerOpened', oldOpen || new Date());
          } else {
            if (oldOpen) {
              var oldTotal = this.get('composerTotalOpened') || 0;
              this.set('composerTotalOpened', oldTotal + (new Date() - oldOpen));
            }
            this.set('composerOpened', null);
          }
        }).observes('composeState');
      }
    }, {
      key: 'composerTime',
      initializer: function () {
        return (function () {
          var total = this.get('composerTotalOpened') || 0;

          var oldOpen = this.get('composerOpened');
          if (oldOpen) {
            total += new Date() - oldOpen;
          }

          return total;
        }).property().volatile();
      }
    }, {
      key: 'archetype',
      initializer: function () {
        return (function () {
          return this.get('archetypes').findProperty('id', this.get('archetypeId'));
        }).property('archetypeId');
      }
    }, {
      key: 'archetypeChanged',
      initializer: function () {
        return (function () {
          return this.set('metaData', Em.Object.create());
        }).observes('archetype');
      }
    }, {
      key: 'typing',

      // view detected user is typing
      initializer: function () {
        return _.throttle(function () {
          var typingTime = this.get("typingTime") || 0;
          this.set("typingTime", typingTime + 100);
        }, 100, { leading: false, trailing: true });
      }
    }, {
      key: 'editingFirstPost',
      initializer: function () {
        return Em.computed.and('editingPost', 'post.firstPost');
      }
    }, {
      key: 'canEditTitle',
      initializer: function () {
        return Em.computed.or('creatingTopic', 'creatingPrivateMessage', 'editingFirstPost');
      }
    }, {
      key: 'canCategorize',
      initializer: function () {
        return Em.computed.and('canEditTitle', 'notCreatingPrivateMessage');
      }
    }, {
      key: 'actionTitle',

      // Determine the appropriate title for this action
      initializer: function () {
        return (function () {
          var topic = this.get('topic');

          var postLink = undefined,
              topicLink = undefined,
              usernameLink = undefined;
          if (topic) {
            var postNumber = this.get('post.post_number');
            postLink = "<a href='" + topic.get('url') + "/" + postNumber + "'>" + I18n.t("post.post_number", { number: postNumber }) + "</a>";
            topicLink = "<a href='" + topic.get('url') + "'> " + Discourse.Utilities.escapeExpression(topic.get('title')) + "</a>";
            usernameLink = "<a href='" + topic.get('url') + "/" + postNumber + "'>" + this.get('post.username') + "</a>";
          }

          var postDescription = undefined;
          var post = this.get('post');

          if (post) {
            postDescription = I18n.t('post.' + this.get('action'), {
              link: postLink,
              replyAvatar: Discourse.Utilities.tinyAvatar(post.get('avatar_template')),
              username: this.get('post.username'),
              usernameLink: usernameLink
            });

            if (!this.site.mobileView) {
              var replyUsername = post.get('reply_to_user.username');
              var replyAvatarTemplate = post.get('reply_to_user.avatar_template');
              if (replyUsername && replyAvatarTemplate && this.get('action') === EDIT) {
                postDescription += " <i class='fa fa-mail-forward reply-to-glyph'></i> " + Discourse.Utilities.tinyAvatar(replyAvatarTemplate) + " " + replyUsername;
              }
            }
          }

          switch (this.get('action')) {
            case PRIVATE_MESSAGE:
              return I18n.t('topic.private_message');
            case CREATE_TOPIC:
              return I18n.t('topic.create_long');
            case REPLY:
            case EDIT:
              if (postDescription) return postDescription;
              if (topic) return I18n.t('post.reply_topic', { link: topicLink });
          }
        }).property('action', 'post', 'topic', 'topic.title');
      }
    }, {
      key: 'cantSubmitPost',

      // whether to disable the post button
      initializer: function () {
        return (function () {

          // can't submit while loading
          if (this.get('loading')) return true;

          // title is required when
          //  - creating a new topic/private message
          //  - editing the 1st post
          if (this.get('canEditTitle') && !this.get('titleLengthValid')) return true;

          // reply is always required
          if (this.get('missingReplyCharacters') > 0) return true;

          if (this.get("privateMessage")) {
            // need at least one user when sending a PM
            return this.get('targetUsernames') && (this.get('targetUsernames').trim() + ',').indexOf(',') === 0;
          } else {
            // has a category? (when needed)
            return this.get('canCategorize') && !this.siteSettings.allow_uncategorized_topics && !this.get('categoryId') && !this.user.get('admin');
          }
        }).property('loading', 'canEditTitle', 'titleLength', 'targetUsernames', 'replyLength', 'categoryId', 'missingReplyCharacters');
      }
    }, {
      key: 'titleLengthValid',
      initializer: function () {
        return (function () {
          if (this.user.get('admin') && this.get('post.static_doc') && this.get('titleLength') > 0) return true;
          if (this.get('titleLength') < this.get('minimumTitleLength')) return false;
          return this.get('titleLength') <= this.siteSettings.max_topic_title_length;
        }).property('minimumTitleLength', 'titleLength', 'post.static_doc');
      }
    }, {
      key: 'saveIcon',

      // The icon for the save button
      initializer: function () {
        return (function () {
          switch (this.get('action')) {
            case EDIT:
              return '<i class="fa fa-pencil"></i>';
            case REPLY:
              return '<i class="fa fa-reply"></i>';
            case CREATE_TOPIC:
              return '<i class="fa fa-plus"></i>';
            case PRIVATE_MESSAGE:
              return '<i class="fa fa-envelope"></i>';
          }
        }).property('action');
      }
    }, {
      key: 'saveText',

      // The text for the save button
      initializer: function () {
        return (function () {
          switch (this.get('action')) {
            case EDIT:
              return I18n.t('composer.save_edit');
            case REPLY:
              return I18n.t('composer.reply');
            case CREATE_TOPIC:
              return I18n.t('composer.create_topic');
            case PRIVATE_MESSAGE:
              return I18n.t('composer.create_pm');
          }
        }).property('action');
      }
    }, {
      key: 'hasMetaData',
      initializer: function () {
        return (function () {
          var metaData = this.get('metaData');
          return metaData ? Em.isEmpty(Em.keys(this.get('metaData'))) : false;
        }).property('metaData');
      }
    }, {
      key: 'replyDirty',

      /**
        Did the user make changes to the reply?
         @property replyDirty
      **/
      initializer: function () {
        return (function () {
          return this.get('reply') !== this.get('originalText');
        }).property('reply', 'originalText');
      }
    }, {
      key: 'missingTitleCharacters',

      /**
        Number of missing characters in the title until valid.
         @property missingTitleCharacters
      **/
      initializer: function () {
        return (function () {
          return this.get('minimumTitleLength') - this.get('titleLength');
        }).property('minimumTitleLength', 'titleLength');
      }
    }, {
      key: 'minimumTitleLength',

      /**
        Minimum number of characters for a title to be valid.
         @property minimumTitleLength
      **/
      initializer: function () {
        return (function () {
          if (this.get('privateMessage')) {
            return this.siteSettings.min_private_message_title_length;
          } else {
            return this.siteSettings.min_topic_title_length;
          }
        }).property('privateMessage');
      }
    }, {
      key: 'missingReplyCharacters',
      initializer: function () {
        return (function () {
          var postType = this.get('post.post_type');
          if (postType === this.site.get('post_types.small_action')) {
            return 0;
          }
          return this.get('minimumPostLength') - this.get('replyLength');
        }).property('minimumPostLength', 'replyLength');
      }
    }, {
      key: 'minimumPostLength',

      /**
        Minimum number of characters for a post body to be valid.
         @property minimumPostLength
      **/
      initializer: function () {
        return (function () {
          if (this.get('privateMessage')) {
            return this.siteSettings.min_private_message_post_length;
          } else if (this.get('topicFirstPost')) {
            // first post (topic body)
            return this.siteSettings.min_first_post_length;
          } else {
            return this.siteSettings.min_post_length;
          }
        }).property('privateMessage', 'topicFirstPost');
      }
    }, {
      key: 'titleLength',

      /**
        Computes the length of the title minus non-significant whitespaces
         @property titleLength
      **/
      initializer: function () {
        return (function () {
          var title = this.get('title') || "";
          return title.replace(/\s+/img, " ").trim().length;
        }).property('title');
      }
    }, {
      key: 'replyLength',

      /**
        Computes the length of the reply minus the quote(s) and non-significant whitespaces
         @property replyLength
      **/
      initializer: function () {
        return (function () {
          var reply = this.get('reply') || "";
          while (Quote.REGEXP.test(reply)) {
            reply = reply.replace(Quote.REGEXP, "");
          }
          return reply.replace(/\s+/img, " ").trim().length;
        }).property('reply');
      }
    }, {
      key: '_setupComposer',
      initializer: function () {
        return (function () {
          this.set('archetypeId', this.site.get('default_archetype'));
        }).on('init');
      }
    }, {
      key: 'appendText',

      /**
        Append text to the current reply
         @method appendText
        @param {String} text the text to append
      **/
      value: function (text, position, opts) {
        var reply = this.get('reply') || '';
        position = typeof position === "number" ? position : reply.length;

        var before = reply.slice(0, position) || '';
        var after = reply.slice(position) || '';

        var stripped = undefined,
            i = undefined;
        if (opts && opts.block) {
          if (before.trim() !== "") {
            stripped = before.replace(/\r/g, "");
            for (i = 0; i < 2; i++) {
              if (stripped[stripped.length - 1 - i] !== "\n") {
                before += "\n";
                position++;
              }
            }
          }
          if (after.trim() !== "") {
            stripped = after.replace(/\r/g, "");
            for (i = 0; i < 2; i++) {
              if (stripped[i] !== "\n") {
                after = "\n" + after;
              }
            }
          }
        }

        if (opts && opts.space) {
          if (before.length > 0 && !before[before.length - 1].match(/\s/)) {
            before = before + " ";
          }
          if (after.length > 0 && !after[0].match(/\s/)) {
            after = " " + after;
          }
        }

        this.set('reply', before + text + after);

        return before.length + text.length;
      }
    }, {
      key: 'prependText',
      value: function (text, opts) {
        var reply = this.get('reply') || '';

        if (opts && opts.new_line && reply.length > 0) {
          text = text.trim() + "\n\n";
        }
        this.set('reply', text + reply);
      }
    }, {
      key: 'applyTopicTemplate',
      value: function (oldCategoryId, categoryId) {
        if (this.get('action') !== CREATE_TOPIC) {
          return;
        }
        var reply = this.get('reply');

        // If the user didn't change the template, clear it
        if (oldCategoryId) {
          var oldCat = this.site.categories.findProperty('id', oldCategoryId);
          if (oldCat && oldCat.get('topic_template') === reply) {
            reply = "";
          }
        }

        if (!Ember.isEmpty(reply)) {
          return;
        }
        var category = this.site.categories.findProperty('id', categoryId);
        if (category) {
          this.set('reply', category.get('topic_template') || "");
        }
      }
    }, {
      key: 'open',

      /*
         Open a composer
          opts:
           action   - The action we're performing: edit, reply or createTopic
           post     - The post we're replying to, if present
           topic    - The topic we're replying to, if present
           quote    - If we're opening a reply from a quote, the quote we're making
      */
      value: function (opts) {
        if (!opts) opts = {};
        this.set('loading', false);

        var replyBlank = Em.isEmpty(this.get("reply"));

        var composer = this;
        if (!replyBlank && (opts.reply || opts.action === EDIT) && this.get('replyDirty')) {
          return;
        }

        if (opts.action === REPLY && this.get('action') === EDIT) this.set('reply', '');
        if (!opts.draftKey) throw 'draft key is required';
        if (opts.draftSequence === null) throw 'draft sequence is required';

        this.setProperties({
          draftKey: opts.draftKey,
          draftSequence: opts.draftSequence,
          composeState: opts.composerState || OPEN,
          action: opts.action,
          topic: opts.topic,
          targetUsernames: opts.usernames,
          composerTotalOpened: opts.composerTime,
          typingTime: opts.typingTime
        });

        if (opts.post) {
          this.set('post', opts.post);

          this.set('whisper', opts.post.get('post_type') === this.site.get('post_types.whisper'));
          if (!this.get('topic')) {
            this.set('topic', opts.post.get('topic'));
          }
        } else {
          this.set('post', null);
        }

        this.setProperties({
          archetypeId: opts.archetypeId || this.site.get('default_archetype'),
          metaData: opts.metaData ? Em.Object.create(opts.metaData) : null,
          reply: opts.reply || this.get("reply") || ""
        });

        // We set the category id separately for topic templates on opening of composer
        this.set('categoryId', opts.categoryId || this.get('topic.category.id'));

        if (!this.get('categoryId') && this.get('creatingTopic')) {
          var categories = Discourse.Category.list();
          if (categories.length === 1) {
            this.set('categoryId', categories[0].get('id'));
          }
        }

        if (opts.postId) {
          this.set('loading', true);
          this.store.find('post', opts.postId).then(function (post) {
            composer.set('post', post);
            composer.set('loading', false);
          });
        }

        // If we are editing a post, load it.
        if (opts.action === EDIT && opts.post) {

          var topicProps = this.serialize(_edit_topic_serializer);
          topicProps.loading = true;

          this.setProperties(topicProps);

          this.store.find('post', opts.post.get('id')).then(function (post) {
            composer.setProperties({
              reply: post.get('raw'),
              originalText: post.get('raw'),
              loading: false
            });
          });
        } else if (opts.action === REPLY && opts.quote) {
          this.setProperties({
            reply: opts.quote,
            originalText: opts.quote
          });
        }
        if (opts.title) {
          this.set('title', opts.title);
        }
        this.set('originalText', opts.draft ? '' : this.get('reply'));

        return false;
      }
    }, {
      key: 'save',
      value: function (opts) {
        if (!this.get('cantSubmitPost')) {
          return this.get('editingPost') ? this.editPost(opts) : this.createPost(opts);
        }
      }
    }, {
      key: 'clearState',

      /**
        Clear any state we have in preparation for a new composition.
         @method clearState
      **/
      value: function () {
        this.setProperties({
          originalText: null,
          reply: null,
          post: null,
          title: null,
          editReason: null,
          stagedPost: false,
          typingTime: 0,
          composerOpened: null,
          composerTotalOpened: 0
        });
      }
    }, {
      key: 'editPost',

      // When you edit a post
      value: function (opts) {
        var post = this.get('post'),
            oldCooked = post.get('cooked'),
            self = this;

        var promise = undefined;

        // Update the title if we've changed it, otherwise consider it a
        // successful resolved promise
        if (this.get('title') && post.get('post_number') === 1 && this.get('topic.details.can_edit')) {
          var topicProps = this.getProperties(Object.keys(_edit_topic_serializer));

          promise = Topic.update(this.get('topic'), topicProps);
        } else {
          promise = Ember.RSVP.resolve();
        }

        var props = {
          raw: this.get('reply'),
          edit_reason: opts.editReason,
          image_sizes: opts.imageSizes,
          cooked: this.getCookedHtml()
        };

        this.set('composeState', CLOSED);

        var rollback = throwAjaxError(function () {
          post.set('cooked', oldCooked);
          self.set('composeState', OPEN);
        });

        return promise.then(function () {
          return post.save(props).then(function (result) {
            self.clearState();
            return result;
          }).catch(function (error) {
            throw error;
          });
        }).catch(rollback);
      }
    }, {
      key: 'serialize',
      value: function (serializer, dest) {
        var _this = this;

        dest = dest || {};
        Object.keys(serializer).forEach(function (f) {
          var val = _this.get(serializer[f]);
          if (typeof val !== 'undefined') {
            Ember.set(dest, f, val);
          }
        });
        return dest;
      }
    }, {
      key: 'createPost',

      // Create a new Post
      value: function (opts) {
        var post = this.get('post'),
            topic = this.get('topic'),
            user = this.user,
            postStream = this.get('topic.postStream');

        var addedToStream = false;

        var postTypes = this.site.get('post_types');
        var postType = this.get('whisper') ? postTypes.whisper : postTypes.regular;

        // Build the post object
        var createdPost = this.store.createRecord('post', {
          imageSizes: opts.imageSizes,
          cooked: this.getCookedHtml(),
          reply_count: 0,
          name: user.get('name'),
          display_username: user.get('name'),
          username: user.get('username'),
          user_id: user.get('id'),
          user_title: user.get('title'),
          avatar_template: user.get('avatar_template'),
          user_custom_fields: user.get('custom_fields'),
          post_type: postType,
          actions_summary: [],
          moderator: user.get('moderator'),
          admin: user.get('admin'),
          yours: true,
          read: true,
          wiki: false,
          typingTime: this.get('typingTime'),
          composerTime: this.get('composerTime')
        });

        this.serialize(_create_serializer, createdPost);

        if (post) {
          createdPost.setProperties({
            reply_to_post_number: post.get('post_number'),
            reply_to_user: {
              username: post.get('username'),
              avatar_template: post.get('avatar_template')
            }
          });
        }

        var state = null;

        // If we're in a topic, we can append the post instantly.
        if (postStream) {
          // If it's in reply to another post, increase the reply count
          if (post) {
            post.set('reply_count', (post.get('reply_count') || 0) + 1);
            post.set('replies', []);
          }

          // We do not stage posts in mobile view, we do not have the "cooked"
          // Furthermore calculating cooked is very complicated, especially since
          // we would need to handle oneboxes and other bits that are not even in the
          // engine, staging will just cause a blank post to render
          if (!_.isEmpty(createdPost.get('cooked'))) {
            state = postStream.stagePost(createdPost, user);
            if (state === "alreadyStaging") {
              return;
            }
          }
        }

        var composer = this;
        composer.set('composeState', SAVING);
        composer.set("stagedPost", state === "staged" && createdPost);

        return createdPost.save().then(function (result) {
          var saving = true;

          if (result.responseJson.action === "enqueued") {
            if (postStream) {
              postStream.undoPost(createdPost);
            }
            return result;
          }

          if (topic) {
            // It's no longer a new post
            topic.set('draft_sequence', result.target.draft_sequence);
            postStream.commitPost(createdPost);
            addedToStream = true;
          } else {
            // We created a new topic, let's show it.
            composer.set('composeState', CLOSED);
            saving = false;

            // Update topic_count for the category
            var category = composer.site.get('categories').find(function (x) {
              return x.get('id') === (parseInt(createdPost.get('category'), 10) || 1);
            });
            if (category) category.incrementProperty('topic_count');
            Discourse.notifyPropertyChange('globalNotice');
          }

          composer.clearState();
          composer.set('createdPost', createdPost);

          if (addedToStream) {
            composer.set('composeState', CLOSED);
          } else if (saving) {
            composer.set('composeState', SAVING);
          }

          return result;
        }).catch(throwAjaxError(function () {
          if (postStream) {
            postStream.undoPost(createdPost);
          }
          Ember.run.next(function () {
            return composer.set('composeState', OPEN);
          });
        }));
      }
    }, {
      key: 'getCookedHtml',
      value: function () {
        return $('#reply-control .d-editor-preview').html().replace(/<span class="marker"><\/span>/g, '');
      }
    }, {
      key: 'saveDraft',
      value: function () {
        // Do not save when drafts are disabled
        if (this.get('disableDrafts')) return;
        // Do not save when there is no reply
        if (!this.get('reply')) return;
        // Do not save when the reply's length is too small
        if (this.get('replyLength') < this.siteSettings.min_post_length) return;

        var data = {
          reply: this.get('reply'),
          action: this.get('action'),
          title: this.get('title'),
          categoryId: this.get('categoryId'),
          postId: this.get('post.id'),
          archetypeId: this.get('archetypeId'),
          metaData: this.get('metaData'),
          usernames: this.get('targetUsernames'),
          composerTime: this.get('composerTime'),
          typingTime: this.get('typingTime')
        };

        this.set('draftStatus', I18n.t('composer.saving_draft_tip'));

        var composer = this;

        if (this._clearingStatus) {
          Em.run.cancel(this._clearingStatus);
          this._clearingStatus = null;
        }

        // try to save the draft
        return Draft.save(this.get('draftKey'), this.get('draftSequence'), data).then(function () {
          composer.set('draftStatus', I18n.t('composer.saved_draft_tip'));
        }).catch(function () {
          composer.set('draftStatus', I18n.t('composer.drafts_offline'));
        });
      }
    }, {
      key: 'dataChanged',
      initializer: function () {
        return (function () {
          var draftStatus = this.get('draftStatus');
          var self = this;

          if (draftStatus && !this._clearingStatus) {

            this._clearingStatus = Em.run.later(this, function () {
              self.set('draftStatus', null);
              self._clearingStatus = null;
            }, 1000);
          }
        }).observes('title', 'reply');
      }
    }]));

    Composer.reopenClass({

      // TODO: Replace with injection
      create: function (args) {
        args = args || {};
        args.user = args.user || Discourse.User.current();
        args.site = args.site || Discourse.Site.current();
        args.siteSettings = args.siteSettings || Discourse.SiteSettings;
        return this._super(args);
      },

      serializeToTopic: function (fieldName, property) {
        if (!property) {
          property = fieldName;
        }
        _edit_topic_serializer[fieldName] = property;
      },

      serializeOnCreate: function (fieldName, property) {
        if (!property) {
          property = fieldName;
        }
        _create_serializer[fieldName] = property;
      },

      serializedFieldsForCreate: function () {
        return Object.keys(_create_serializer);
      },

      // The status the compose view can have
      CLOSED: CLOSED,
      SAVING: SAVING,
      OPEN: OPEN,
      DRAFT: DRAFT,

      // The actions the composer can take
      CREATE_TOPIC: CREATE_TOPIC,
      PRIVATE_MESSAGE: PRIVATE_MESSAGE,
      REPLY: REPLY,
      EDIT: EDIT,

      // Draft key
      REPLY_AS_NEW_TOPIC_KEY: REPLY_AS_NEW_TOPIC_KEY
    });

    __exports__["default"] = Composer;
  });
define("discourse/mixins/add-archetype-class", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // Mix this in to a view that has a `archetype` property to automatically
    // add it to the body as the view is entered / left / model is changed.
    // This is used for keeping the `body` style in sync for the background image.
    __exports__["default"] = {
      _init: (function () {
        this.get('archetype');
      }).on('init'),

      _cleanUp: function () {
        $('body').removeClass(function (_, css) {
          return (css.match(/\barchetype-\S+/g) || []).join(' ');
        });
      },

      _archetypeChanged: (function () {
        var archetype = this.get('archetype');
        this._cleanUp();

        if (archetype) {
          $('body').addClass('archetype-' + archetype);
        }
      }).observes('archetype'),

      _willDestroyElement: (function () {
        this._cleanUp();
      }).on('willDestroyElement')
    };
  });

Discourse.AddArchetypeClass = require('discourse/mixins/add-archetype-class').default;
define("discourse/mixins/add-category-class", 
  ["ember","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    // Mix this in to a view that has a `categoryFullSlug` property to automatically
    // add it to the body as the view is entered / left / model is changed.
    // This is used for keeping the `body` style in sync for the background image.

    var Ember = __dependency1__["default"];
    var on = Ember.on;
    var observer = Ember.observer;

    __exports__["default"] = {
      _categoryChanged: on("didInsertElement", observer("categoryFullSlug", function () {
        var categoryFullSlug = this.get("categoryFullSlug");

        this._removeClass();

        if (categoryFullSlug) {
          $("body").addClass("category-" + categoryFullSlug);
        }
      })),

      _leave: on("willDestroyElement", function () {
        this.removeObserver("categoryFullSlug");
        this._removeClass();
      }),

      _removeClass: function () {
        $("body").removeClass(function (_, css) {
          return (css.match(/\bcategory-\S+/g) || []).join(" ");
        });
      }
    };
  });

Discourse.AddCategoryClass = require('discourse/mixins/add-category-class').default;
define("discourse/mixins/badge-select-controller", 
  ["discourse/models/badge","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var Badge = __dependency1__["default"];

    __exports__["default"] = Ember.Mixin.create({
      saving: false,
      saved: false,

      selectableUserBadges: (function () {
        var items = this.get('filteredList');
        items = _.uniq(items, false, function (e) {
          return e.get('badge.name');
        });
        items.unshiftObject(Em.Object.create({
          badge: Badge.create({ name: I18n.t('badges.none') })
        }));
        return items;
      }).property('filteredList'),

      savingStatus: (function () {
        if (this.get('saving')) {
          return I18n.t('saving');
        } else {
          return I18n.t('save');
        }
      }).property('saving'),

      selectedUserBadge: (function () {
        var selectedUserBadgeId = parseInt(this.get('selectedUserBadgeId'));
        var selectedUserBadge = null;
        this.get('selectableUserBadges').forEach(function (userBadge) {
          if (userBadge.get('id') === selectedUserBadgeId) {
            selectedUserBadge = userBadge;
          }
        });
        return selectedUserBadge;
      }).property('selectedUserBadgeId'),

      disableSave: Em.computed.alias('saving')
    });
  });

Discourse.BadgeSelectController = require('discourse/mixins/badge-select-controller').default;
define("discourse/mixins/buffered-content", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.bufferedProperty = bufferedProperty;
    /* global BufferedProxy: true */

    function bufferedProperty(property) {
      var mixin = {
        buffered: (function () {
          return Em.ObjectProxy.extend(BufferedProxy).create({
            content: this.get(property)
          });
        }).property(property),

        rollbackBuffer: function () {
          this.get('buffered').discardBufferedChanges();
        },

        commitBuffer: function () {
          this.get('buffered').applyBufferedChanges();
        }
      };

      // It's a good idea to null out fields when declaring objects
      mixin.property = null;

      return Ember.Mixin.create(mixin);
    }

    __exports__["default"] = bufferedProperty('content');
  });

Discourse.BufferedContent = require('discourse/mixins/buffered-content').default;
define("discourse/mixins/bulk-topic-selection", 
  ["discourse/lib/notification-levels","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var NotificationLevels = __dependency1__["default"];

    __exports__["default"] = Ember.Mixin.create({
      bulkSelectEnabled: false,
      selected: null,

      canBulkSelect: Em.computed.alias('currentUser.staff'),

      resetSelected: (function () {
        this.set('selected', []);
      }).on('init'),

      actions: {
        toggleBulkSelect: function () {
          this.toggleProperty('bulkSelectEnabled');
          this.get('selected').clear();
        },

        dismissRead: function (operationType) {
          var self = this,
              selected = this.get('selected');

          var operation = undefined;
          if (operationType === "posts") {
            operation = { type: 'dismiss_posts' };
          } else {
            operation = { type: 'change_notification_level',
              notification_level_id: NotificationLevels.REGULAR };
          }

          var promise = undefined;
          if (selected.length > 0) {
            promise = Discourse.Topic.bulkOperation(selected, operation);
          } else {
            promise = Discourse.Topic.bulkOperationByFilter('unread', operation, this.get('category.id'));
          }
          promise.then(function (result) {
            if (result && result.topic_ids) {
              (function () {
                var tracker = self.topicTrackingState;
                result.topic_ids.forEach(function (t) {
                  tracker.removeTopic(t);
                });
                tracker.incrementMessageCount();
              })();
            }
            self.send('closeModal');
            self.send('refresh');
          });
        }
      }
    });
  });

Discourse.BulkTopicSelection = require('discourse/mixins/bulk-topic-selection').default;
define("discourse/mixins/can-check-emails", 
  ["discourse/lib/computed","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var propertyEqual = __dependency1__.propertyEqual;
    var setting = __dependency1__.setting;

    __exports__["default"] = Ember.Mixin.create({
      isOwnEmail: propertyEqual("model.id", "currentUser.id"),
      showEmailOnProfile: setting("show_email_on_profile"),
      canStaffCheckEmails: Em.computed.and("showEmailOnProfile", "currentUser.staff"),
      canAdminCheckEmails: Em.computed.alias("currentUser.admin"),
      canCheckEmails: Em.computed.or("isOwnEmail", "canStaffCheckEmails", "canAdminCheckEmails")
    });
  });

Discourse.CanCheckEmails = require('discourse/mixins/can-check-emails').default;
define("discourse/mixins/cleans-up", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // Include this mixin if you want to be notified when the dom should be
    // cleaned (usually on route change.)
    __exports__["default"] = Ember.Mixin.create({
      _initializeChooser: (function () {
        this.appEvents.on('dom:clean', this, "cleanUp");
      }).on('didInsertElement'),

      _clearChooser: (function () {
        this.appEvents.off('dom:clean', this, "cleanUp");
      }).on('willDestroyElement')
    });
  });

Discourse.CleansUp = require('discourse/mixins/cleans-up').default;
define("discourse/mixins/load-more", 
  ["discourse/lib/eyeline","discourse/mixins/scrolling","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var Eyeline = __dependency1__["default"];
    var Scrolling = __dependency2__["default"];
    var on = __dependency3__.on;

    // Provides the ability to load more items for a view which is scrolled to the bottom.
    __exports__["default"] = Ember.Mixin.create(Ember.ViewTargetActionSupport, Scrolling, _createDecoratedObject([{
      key: 'scrolled',
      value: function () {
        var eyeline = this.get('eyeline');
        return eyeline && eyeline.update();
      }
    }, {
      key: 'loadMoreUnlessFull',
      value: function () {
        if (this.screenNotFull()) {
          this.send("loadMore");
        }
      }
    }, {
      key: '_bindEyeline',
      decorators: [on("didInsertElement")],
      value: function () {
        var _this = this;

        var eyeline = new Eyeline(this.get('eyelineSelector') + ":last");
        this.set('eyeline', eyeline);
        eyeline.on('sawBottom', function () {
          return _this.send('loadMore');
        });
        this.bindScrolling();
      }
    }, {
      key: '_removeEyeline',
      decorators: [on("willDestroyElement")],
      value: function () {
        this.unbindScrolling();
      }
    }]));
  });

Discourse.LoadMore = require('discourse/mixins/load-more').default;
define("discourse/mixins/modal-functionality", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Em.Mixin.create({
      flashMessage: null,

      needs: ['modal'],

      flash: function (message, messageClass) {
        this.set('flashMessage', Em.Object.create({ message: message, messageClass: messageClass }));
      }
    });
  });

Discourse.ModalFunctionality = require('discourse/mixins/modal-functionality').default;
define("discourse/mixins/open-composer", 
  ["discourse/models/composer","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    // This mixin allows a route to open the composer
    var Composer = __dependency1__["default"];

    __exports__["default"] = Ember.Mixin.create({

      openComposer: function (controller) {
        this.controllerFor('composer').open({
          categoryId: controller.get('category.id'),
          action: Composer.CREATE_TOPIC,
          draftKey: controller.get('model.draft_key'),
          draftSequence: controller.get('model.draft_sequence')
        });
      },

      openComposerWithTopicParams: function (controller, topicTitle, topicBody, topicCategoryId, topicCategory) {
        this.controllerFor('composer').open({
          action: Composer.CREATE_TOPIC,
          topicTitle: topicTitle,
          topicBody: topicBody,
          topicCategoryId: topicCategoryId,
          topicCategory: topicCategory,
          draftKey: controller.get('model.draft_key'),
          draftSequence: controller.get('model.draft_sequence')
        });
      },

      openComposerWithMessageParams: function (usernames, topicTitle, topicBody) {
        this.controllerFor('composer').open({
          action: Composer.PRIVATE_MESSAGE,
          usernames: usernames,
          topicTitle: topicTitle,
          topicBody: topicBody,
          archetypeId: 'private_message',
          draftKey: 'new_private_message'
        });
      }

    });
  });

Discourse.OpenComposer = require('discourse/mixins/open-composer').default;
define("discourse/mixins/scroll-top", 
  ["discourse/lib/url","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];

    function scrollTop() {
      if (DiscourseURL.isJumpScheduled()) {
        return;
      }
      Ember.run.schedule('afterRender', function () {
        $(document).scrollTop(0);
      });
    }

    __exports__["default"] = Ember.Mixin.create({
      _scrollTop: scrollTop.on('didInsertElement')
    });

    __exports__.scrollTop = scrollTop;
  });

Discourse.ScrollTop = require('discourse/mixins/scroll-top').default;
define("discourse/mixins/selected-posts-count", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Em.Mixin.create({

      selectedPostsCount: (function () {
        if (this.get('allPostsSelected')) {
          return this.get('model.posts_count') || this.get('topic.posts_count') || this.get('posts_count');
        }

        var sum = this.get('selectedPosts.length') || 0;
        if (this.get('selectedReplies')) {
          this.get('selectedReplies').forEach(function (p) {
            sum += p.get('reply_count') || 0;
          });
        }

        return sum;
      }).property('selectedPosts.length', 'allPostsSelected', 'selectedReplies.length'),

      // The username that owns every selected post, or undefined if no selection or if ownership is mixed.
      selectedPostsUsername: (function () {
        // Don't proceed if replies are selected or usernames are mixed
        // Changing ownership in those cases normally doesn't make sense
        if (this.get('selectedReplies') && this.get('selectedReplies').length > 0) {
          return undefined;
        }
        if (this.get('selectedPosts').length <= 0) {
          return undefined;
        }

        var selectedPosts = this.get('selectedPosts'),
            username = selectedPosts[0].username;

        if (selectedPosts.every(function (post) {
          return post.username === username;
        })) {
          return username;
        } else {
          return undefined;
        }
      }).property('selectedPosts.length', 'selectedReplies.length')
    });
  });

Discourse.SelectedPostsCount = require('discourse/mixins/selected-posts-count').default;
define("discourse/mixins/singleton", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
      This mixin allows a class to return a singleton, as well as a method to quickly
      read/write attributes on the singleton.


      Example usage:

      ```javascript

        // Define your class and apply the Mixin
        User = Ember.Object.extend({});
        User.reopenClass(Singleton);

        // Retrieve the current instance:
        var instance = User.current();

      ```

      Commonly you want to read or write a property on the singleton. There's a
      helper method which is a little nicer than `.current().get()`:

      ```javascript

        // Sets the age to 34
        User.currentProp('age', 34);

        console.log(User.currentProp('age')); // 34

      ```

      If you want to customize how the singleton is created, redefine the `createCurrent`
      method:

      ```javascript

        // Define your class and apply the Mixin
        Foot = Ember.Object.extend({});
        Foot.reopenClass(Singleton, {
          createCurrent: function() {
            return Foot.create({toes: 5});
          }
        });

        console.log(Foot.currentProp('toes')); // 5

      ```
    **/

    var Singleton = Ember.Mixin.create({

      current: function () {
        if (!this._current) {
          this._current = this.createCurrent();
        }
        return this._current;
      },

      /**
        How the singleton instance is created. This can be overridden
        with logic for creating (or even returning null) your instance.
         By default it just calls `create` with an empty object.
      **/
      createCurrent: function () {
        return this.create({});
      },

      // Returns OR sets a property on the singleton instance.
      currentProp: function (property, value) {
        var instance = this.current();
        if (!instance) {
          return;
        }

        if (typeof value !== "undefined") {
          instance.set(property, value);
          return value;
        } else {
          return instance.get(property);
        }
      },

      resetCurrent: function (val) {
        this._current = val;
      }
    });

    __exports__["default"] = Singleton;
  });

Discourse.Singleton = require('discourse/mixins/singleton').default;
define("discourse/mixins/string-buffer", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Mixin.create({

      _watchProps: (function () {
        var _this = this;

        var args = this.get('rerenderTriggers');
        if (!Ember.isNone(args)) {
          args.forEach(function (k) {
            return _this.addObserver(k, _this.rerenderString);
          });
        }
      }).on('init'),

      render: function (buffer) {
        this.renderString(buffer);
      },

      renderString: function (buffer) {
        var template = Discourse.__container__.lookup('template:' + this.rawTemplate);
        if (template) {
          buffer.push(template(this));
        }
      },

      _rerenderString: function () {
        var $sel = this.$();
        if (!$sel) {
          return;
        }

        var buffer = [];
        this.renderString(buffer);

        // Chrome likes scrolling after HTML is set
        // This happens if you navigate back and forth a few times
        // Before removing this code confirm that this does not cause scrolling
        // 1. Sort by views
        // 2. Go to last post on one of the topics
        // 3. Hit back
        // 4. Go to last post on same topic
        // 5. Expand likes
        var scrollTop = $(window).scrollTop();
        $sel.html(buffer.join(''));
        $(window).scrollTop(scrollTop);
      },

      rerenderString: function () {
        Ember.run.once(this, '_rerenderString');
      }

    });
  });

Discourse.StringBuffer = require('discourse/mixins/string-buffer').default;
define("discourse/mixins/upload", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Em.Mixin.create({
      uploading: false,
      uploadProgress: 0,

      uploadDone: function () {
        Em.warn("You should implement `uploadDone`");
      },

      _initialize: (function () {
        var _this = this;

        var $upload = this.$(),
            csrf = Discourse.Session.currentProp("csrfToken"),
            uploadUrl = Discourse.getURL(this.getWithDefault("uploadUrl", "/uploads")),
            reset = function () {
          return _this.setProperties({ uploading: false, uploadProgress: 0 });
        };

        this.messageBus.subscribe("/uploads/" + this.get("type"), function (upload) {
          if (upload && upload.url) {
            _this.uploadDone(upload);
          } else {
            Discourse.Utilities.displayErrorForUpload(upload);
          }
          reset();
        });

        $upload.fileupload({
          url: uploadUrl + ".json?client_id=" + this.messageBus.clientId + "&authenticity_token=" + encodeURIComponent(csrf),
          dataType: "json",
          dropZone: $upload,
          pasteZone: $upload
        });

        $upload.on("fileuploaddrop", function (e, data) {
          if (data.files.length > 10) {
            bootbox.alert(I18n.t("post.errors.too_many_dragged_and_dropped_files"));
            return false;
          } else {
            return true;
          }
        });

        $upload.on("fileuploadsubmit", function (e, data) {
          var isValid = Discourse.Utilities.validateUploadedFiles(data.files, true);
          var form = { type: _this.get("type") };
          if (_this.get("data")) {
            form = $.extend(form, _this.get("data"));
          }
          data.formData = form;
          _this.setProperties({ uploadProgress: 0, uploading: isValid });
          return isValid;
        });

        $upload.on("fileuploadprogressall", function (e, data) {
          var progress = parseInt(data.loaded / data.total * 100, 10);
          _this.set("uploadProgress", progress);
        });

        $upload.on("fileuploadfail", function (e, data) {
          Discourse.Utilities.displayErrorForUpload(data);
          reset();
        });
      }).on("didInsertElement"),

      _destroy: (function () {
        this.messageBus.unsubscribe("/uploads/" + this.get("type"));
        var $upload = this.$();
        try {
          $upload.fileupload("destroy");
        } catch (e) {/* wasn't initialized yet */}
        $upload.off();
      }).on("willDestroyElement")
    });
  });

Discourse.Upload = require('discourse/mixins/upload').default;
define("discourse/mixins/url-refresh", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // A Mixin that a view can use to listen for 'url:refresh' when
    // it is on screen, and will send an action to refresh its data.
    //
    // This is useful if you want to get around Ember's default
    // behavior of not refreshing when navigating to the same place.
    __exports__["default"] = {
      didInsertElement: function () {
        var _this = this;

        this._super();
        this.appEvents.on('url:refresh', function () {
          return _this.sendAction('refresh');
        });
      },

      willDestroyElement: function () {
        this._super();
        this.appEvents.off('url:refresh');
      }
    };
  });

Discourse.UrlRefresh = require('discourse/mixins/url-refresh').default;
define("discourse/mixins/viewing-action-type", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = {
      viewingActionType: function (userActionType) {
        this.controllerFor('user').set('userActionType', userActionType);
        this.controllerFor('user-activity').set('userActionType', userActionType);
      }

    };
  });

Discourse.ViewingActionType = require('discourse/mixins/viewing-action-type').default;
define("discourse/models/invite", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var Invite = Discourse.Model.extend({

      rescind: function () {
        Discourse.ajax('/invites', {
          type: 'DELETE',
          data: { email: this.get('email') }
        });
        this.set('rescinded', true);
      },

      reinvite: function () {
        Discourse.ajax('/invites/reinvite', {
          type: 'POST',
          data: { email: this.get('email') }
        });
        this.set('reinvited', true);
      }

    });

    Invite.reopenClass({

      create: function () {
        var result = this._super.apply(this, arguments);
        if (result.user) {
          result.user = Discourse.User.create(result.user);
        }
        return result;
      },

      findInvitedBy: function (user, filter, search, offset) {
        if (!user) {
          return Em.RSVP.resolve();
        }

        var data = {};
        if (!Em.isNone(filter)) {
          data.filter = filter;
        }
        if (!Em.isNone(search)) {
          data.search = search;
        }
        data.offset = offset || 0;

        return Discourse.ajax("/users/" + user.get('username_lower') + "/invited.json", { data: data }).then(function (result) {
          result.invites = result.invites.map(function (i) {
            return Invite.create(i);
          });

          return Em.Object.create(result);
        });
      },

      findInvitedCount: function (user) {
        if (!user) {
          return Em.RSVP.resolve();
        }
        return Discourse.ajax("/users/" + user.get('username_lower') + "/invited_count.json").then(function (result) {
          return Em.Object.create(result.counts);
        });
      }

    });

    __exports__["default"] = Invite;
  });
define("discourse/models/user-badge", 
  ["discourse/models/badge","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var Badge = __dependency1__["default"];

    var UserBadge = Discourse.Model.extend({
      postUrl: (function () {
        if (this.get('topic_title')) {
          return "/t/-/" + this.get('topic_id') + "/" + this.get('post_number');
        }
      }).property(), // avoid the extra bindings for now

      revoke: function () {
        return Discourse.ajax("/user_badges/" + this.get('id'), {
          type: "DELETE"
        });
      }
    });

    UserBadge.reopenClass({

      createFromJson: function (json) {
        // Create User objects.
        if (json.users === undefined) {
          json.users = [];
        }
        var users = {};
        json.users.forEach(function (userJson) {
          users[userJson.id] = Discourse.User.create(userJson);
        });

        // Create Topic objects.
        if (json.topics === undefined) {
          json.topics = [];
        }
        var topics = {};
        json.topics.forEach(function (topicJson) {
          topics[topicJson.id] = Discourse.Topic.create(topicJson);
        });

        // Create the badges.
        if (json.badges === undefined) {
          json.badges = [];
        }
        var badges = {};
        Badge.createFromJson(json).forEach(function (badge) {
          badges[badge.get('id')] = badge;
        });

        // Create UserBadge object(s).
        var userBadges = [];
        if ("user_badge" in json) {
          userBadges = [json.user_badge];
        } else {
          userBadges = json.user_badge_info && json.user_badge_info.user_badges || json.user_badges;
        }

        userBadges = userBadges.map(function (userBadgeJson) {
          var userBadge = UserBadge.create(userBadgeJson);

          var grantedAtDate = Date.parse(userBadge.get('granted_at'));
          userBadge.set('grantedAt', grantedAtDate);

          userBadge.set('badge', badges[userBadge.get('badge_id')]);
          if (userBadge.get('user_id')) {
            userBadge.set('user', users[userBadge.get('user_id')]);
          }
          if (userBadge.get('granted_by_id')) {
            userBadge.set('granted_by', users[userBadge.get('granted_by_id')]);
          }
          if (userBadge.get('topic_id')) {
            userBadge.set('topic', topics[userBadge.get('topic_id')]);
          }
          return userBadge;
        });

        if ("user_badge" in json) {
          return userBadges[0];
        } else {
          if (json.user_badge_info) {
            userBadges.grant_count = json.user_badge_info.grant_count;
            userBadges.username = json.user_badge_info.username;
          }
          return userBadges;
        }
      },

      /**
        Find all badges for a given username.
         @method findByUsername
        @param {String} username
        @param {Object} options
        @returns {Promise} a promise that resolves to an array of `UserBadge`.
      **/
      findByUsername: function (username, options) {
        var url = "/user-badges/" + username + ".json";
        if (options && options.grouped) {
          url += "?grouped=true";
        }
        return Discourse.ajax(url).then(function (json) {
          return UserBadge.createFromJson(json);
        });
      },

      /**
        Find all badge grants for a given badge ID.
         @method findById
        @param {String} badgeId
        @returns {Promise} a promise that resolves to an array of `UserBadge`.
      **/
      findByBadgeId: function (badgeId, options) {
        if (!options) {
          options = {};
        }
        options.badge_id = badgeId;

        return Discourse.ajax("/user_badges.json", {
          data: options
        }).then(function (json) {
          return UserBadge.createFromJson(json);
        });
      },

      /**
        Grant the badge having id `badgeId` to the user identified by `username`.
         @method grant
        @param {Integer} badgeId id of the badge to be granted.
        @param {String} username username of the user to be granted the badge.
        @returns {Promise} a promise that resolves to an instance of `UserBadge`.
      **/
      grant: function (badgeId, username, reason) {
        return Discourse.ajax("/user_badges", {
          type: "POST",
          data: {
            username: username,
            badge_id: badgeId,
            reason: reason
          }
        }).then(function (json) {
          return UserBadge.createFromJson(json);
        });
      }
    });

    __exports__["default"] = UserBadge;
  });
define("discourse/controllers/discovery-sortable", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // Just add query params here to have them automatically passed to topic list filters.
    var queryParams = {
      order: { replace: true, refreshModel: true },
      ascending: { replace: true, refreshModel: true },
      status: { replace: true, refreshModel: true },
      state: { replace: true, refreshModel: true },
      search: { replace: true, refreshModel: true },
      max_posts: { replace: true, refreshModel: true },
      q: { replace: true, refreshModel: true }
    };

    __exports__.queryParams = queryParams;
    // Basic controller options
    var controllerOpts = {
      needs: ['discovery/topics'],
      queryParams: Object.keys(queryParams)
    };

    // Aliases for the values
    controllerOpts.queryParams.forEach(function (p) {
      return controllerOpts[p] = Em.computed.alias('controllers.discovery/topics.' + p);
    });

    __exports__["default"] = Ember.Controller.extend(controllerOpts);
  });
define("discourse/controllers/navigation/default", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['discovery', 'discovery/topics'];
      }
    }, {
      key: 'categories',
      decorators: [computed()],
      value: function () {
        return Discourse.Category.list();
      }
    }, {
      key: 'navItems',
      decorators: [computed("filterMode")],
      value: function (filterMode) {
        // we don't want to show the period in the navigation bar since it's in a dropdown
        if (filterMode.indexOf("top/") === 0) {
          filterMode = filterMode.replace("top/", "");
        }
        return Discourse.NavItem.buildList(null, { filterMode: filterMode });
      }
    }]));
  });
define("discourse/views/container", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.ContainerView.extend({

      attachViewWithArgs: function (viewArgs, viewClass) {
        if (typeof viewClass === "string") {
          viewClass = this.container.lookupFactory("view:" + viewClass) || this.container.lookupFactory("component:" + viewClass);
        }

        if (!viewClass) {
          viewClass = Ember.View.extend();
        }
        this.pushObject(this.createChildView(viewClass, viewArgs));
      },

      attachViewClass: function (viewClass) {
        this.attachViewWithArgs(null, viewClass);
      }
    });
  });
define("discourse/views/modal-body", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ("value" in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === "function") { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError("The decorator for method " + descriptor.key + " is of the invalid type " + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var observes = __dependency1__.observes;
    var on = __dependency1__.on;

    __exports__["default"] = Ember.View.extend(_createDecoratedObject([{
      key: "focusInput",
      initializer: function () {
        return true;
      }
    }, {
      key: "_setupModal",
      decorators: [on("didInsertElement")],
      value: function () {
        var _this = this;

        $('#modal-alert').hide();
        $('#discourse-modal').modal('show');

        // Focus on first element
        if (!this.site.mobileView && this.get('focusInput')) {
          Em.run.schedule('afterRender', function () {
            return _this.$('input:first').focus();
          });
        }

        var title = this.get('title');
        if (title) {
          this.set('controller.controllers.modal.title', title);
        }
      }
    }, {
      key: "flashMessageChanged",
      decorators: [observes("controller.flashMessage")],
      value: function () {
        var flashMessage = this.get('controller.flashMessage');
        if (flashMessage) {
          var messageClass = flashMessage.get('messageClass') || 'success';
          $('#modal-alert').hide().removeClass('alert-error', 'alert-success').addClass("alert alert-" + messageClass).html(flashMessage.get('message')).fadeIn();
        }
      }
    }]));
  });
define("discourse/views/flag", 
  ["discourse/views/modal-body","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalBodyView = __dependency1__["default"];

    __exports__["default"] = ModalBodyView.extend({
      templateName: 'modal/flag',

      title: (function () {
        return this.get('controller.flagTopic') ? I18n.t('flagging_topic.title') : I18n.t('flagging.title');
      }).property('controller.flagTopic'),

      _selectRadio: function () {
        this.$("input[type='radio']").prop('checked', false);

        var nameKey = this.get('controller.selected.name_key');
        if (!nameKey) {
          return;
        }

        this.$('#radio_' + nameKey).prop('checked', 'true');
      },

      selectedChanged: (function () {
        Ember.run.next(this, this._selectRadio);
      }).observes('controller.selected.name_key'),

      // See: https://github.com/emberjs/ember.js/issues/10869
      _selectedHack: (function () {
        this.removeObserver('controller.selected.name_key');
      }).on('willDestroyElement')
    });
  });
define("discourse/components/combo-box", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var on = __dependency1__.on;
    var observes = __dependency1__.observes;

    __exports__["default"] = Ember.Component.extend(_createDecoratedObject([{
      key: 'tagName',
      initializer: function () {
        return 'select';
      }
    }, {
      key: 'attributeBindings',
      initializer: function () {
        return ['tabindex'];
      }
    }, {
      key: 'classNames',
      initializer: function () {
        return ['combobox'];
      }
    }, {
      key: 'valueAttribute',
      initializer: function () {
        return 'id';
      }
    }, {
      key: 'nameProperty',
      initializer: function () {
        return 'name';
      }
    }, {
      key: 'render',
      value: function (buffer) {
        var _this = this;

        var nameProperty = this.get('nameProperty');
        var none = this.get('none');

        // Add none option if required
        if (typeof none === "string") {
          buffer.push('<option value="">' + I18n.t(none) + "</option>");
        } else if (typeof none === "object") {
          buffer.push("<option value=\"\">" + Em.get(none, nameProperty) + "</option>");
        }

        var selected = this.get('value');
        if (!Em.isNone(selected)) {
          selected = selected.toString();
        }

        if (this.get('content')) {
          this.get('content').forEach(function (o) {
            var val = o[_this.get('valueAttribute')];
            if (typeof val === "undefined") {
              val = o;
            }
            if (!Em.isNone(val)) {
              val = val.toString();
            }

            var selectedText = val === selected ? "selected" : "";
            var name = Handlebars.Utils.escapeExpression(Ember.get(o, nameProperty) || o);
            buffer.push('<option ' + selectedText + ' value="' + val + '">' + name + '</option>');
          });
        }
      }
    }, {
      key: 'valueChanged',
      decorators: [observes('value')],
      value: function () {
        var $combo = this.$(),
            val = this.get('value');

        if (val !== undefined && val !== null) {
          $combo.select2('val', val.toString());
        } else {
          $combo.select2('val', null);
        }
      }
    }, {
      key: '_rerenderOnChange',
      decorators: [observes('content.[]')],
      value: function () {
        this.rerender();
      }
    }, {
      key: '_initializeCombo',
      decorators: [on('didInsertElement')],
      value: function () {
        var _this2 = this;

        // Workaround for https://github.com/emberjs/ember.js/issues/9813
        // Can be removed when fixed. Without it, the wrong option is selected
        this.$('option').each(function (i, o) {
          return o.selected = !!$(o).attr('selected');
        });

        // observer for item names changing (optional)
        if (this.get('nameChanges')) {
          this.addObserver('content.@each.' + this.get('nameProperty'), this.rerender);
        }

        var $elem = this.$();
        var minimumResultsForSearch = this.capabilities.isIOS ? -1 : 5;
        $elem.select2({ formatResult: this.comboTemplate, minimumResultsForSearch: minimumResultsForSearch, width: 'resolve' });

        var castInteger = this.get('castInteger');
        $elem.on("change", function (e) {
          var val = $(e.target).val();
          if (val && val.length && castInteger) {
            val = parseInt(val, 10);
          }
          _this2.set('value', val);
        });
        $elem.trigger('change');
      }
    }, {
      key: '_destroyDropdown',
      decorators: [on('willDestroyElement')],
      value: function () {
        this.$().select2('destroy');
      }
    }]));
  });
define("discourse/components/edit-category-panel", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.buildCategoryPanel = buildCategoryPanel;
    var EditCategoryPanel = Ember.Component.extend({
      classNameBindings: [':modal-tab', 'activeTab::invisible']
    });

    __exports__["default"] = EditCategoryPanel;

    function buildCategoryPanel(tab, extras) {
      return EditCategoryPanel.extend({
        activeTab: Ember.computed.equal('selectedTab', tab)
      }, extras || {});
    }
  });
define("discourse/views/button", 
  ["discourse/mixins/string-buffer","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var StringBuffer = __dependency1__["default"];

    __exports__["default"] = Ember.View.extend(StringBuffer, {
      tagName: 'button',
      classNameBindings: [':btn', ':standard', 'dropDownToggle'],
      attributeBindings: ['title', 'data-toggle', 'data-share-url'],

      title: (function () {
        return I18n.t(this.get('helpKey') || this.get('textKey'));
      }).property('helpKey', 'textKey'),

      text: (function () {
        if (Ember.isEmpty(this.get('textKey'))) {
          return "";
        }
        return I18n.t(this.get('textKey'));
      }).property('textKey'),

      renderString: function (buffer) {
        if (this.renderIcon) {
          this.renderIcon(buffer);
        }
        buffer.push(this.get('text'));
      }
    });
  });
define("discourse/components/dropdown-button", 
  ["discourse/mixins/string-buffer","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var StringBuffer = __dependency1__["default"];

    __exports__["default"] = Ember.Component.extend(StringBuffer, {
      classNameBindings: [':btn-group', 'hidden'],
      rerenderTriggers: ['text', 'longDescription'],

      _bindClick: (function () {
        var _this = this;

        // If there's a click handler, call it
        if (this.clicked) {
          (function () {
            var self = _this;
            _this.$().on('click.dropdown-button', 'ul li', function (e) {
              e.preventDefault();
              if ($(e.currentTarget).data('id') !== self.get('activeItem')) {
                self.clicked($(e.currentTarget).data('id'));
              }
              self.$('.dropdown-toggle').dropdown('toggle');
              return false;
            });
          })();
        }
      }).on('didInsertElement'),

      _unbindClick: (function () {
        this.$().off('click.dropdown-button', 'ul li');
      }).on('willDestroyElement'),

      renderString: function (buffer) {
        var _this2 = this;

        var title = this.get('title');
        if (title) {
          buffer.push("<h4 class='title'>" + title + "</h4>");
        }

        buffer.push('<button class=\'btn standard dropdown-toggle ' + this.get('buttonExtraClasses') + '\' data-toggle=\'dropdown\'>' + this.get('text') + '</button>');
        buffer.push("<ul class='dropdown-menu'>");

        var contents = this.get('dropDownContent');
        if (contents) {
          (function () {
            var self = _this2;
            contents.forEach(function (row) {
              var id = row.id,
                  className = self.get('activeItem') === id ? 'disabled' : '';

              buffer.push("<li data-id=\"" + id + "\" class=\"" + className + "\"><a href>");
              buffer.push("<span class='icon " + row.styleClasses + "'></span>");
              buffer.push("<div><span class='title'>" + row.title + "</span>");
              buffer.push("<span>" + row.description + "</span></div>");
              buffer.push("</a></li>");
            });
          })();
        }

        buffer.push("</ul>");

        var desc = this.get('longDescription');
        if (desc) {
          buffer.push("<p>");
          buffer.push(desc);
          buffer.push("</p>");
        }
      }
    });
  });
define("discourse/components/notifications-button", 
  ["discourse/components/dropdown-button","discourse/lib/notification-levels","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var DropdownButton = __dependency1__["default"];
    var NotificationLevels = __dependency2__["default"];

    var NotificationsButton = DropdownButton.extend({
      classNames: ['notification-options'],
      title: '',
      buttonIncludesText: true,
      activeItem: Em.computed.alias('notificationLevel'),
      i18nPrefix: '',
      i18nPostfix: '',
      watchingClasses: 'fa fa-exclamation-circle watching',
      trackingClasses: 'fa fa-circle tracking',
      mutedClasses: 'fa fa-times-circle muted',
      regularClasses: 'fa fa-circle-o regular',

      options: (function () {
        return [['WATCHING', 'watching', this.watchingClasses], ['TRACKING', 'tracking', this.trackingClasses], ['REGULAR', 'regular', this.regularClasses], ['MUTED', 'muted', this.mutedClasses]];
      }).property(),

      dropDownContent: (function () {
        var contents = [],
            prefix = this.get('i18nPrefix'),
            postfix = this.get('i18nPostfix');

        _.each(this.get('options'), function (pair) {
          if (postfix === '_pm' && pair[1] === 'regular') {
            return;
          }
          contents.push({
            id: NotificationLevels[pair[0]],
            title: I18n.t(prefix + '.' + pair[1] + postfix + '.title'),
            description: I18n.t(prefix + '.' + pair[1] + postfix + '.description'),
            styleClasses: pair[2]
          });
        });

        return contents;
      }).property(),

      text: (function () {
        var self = this,
            prefix = this.get('i18nPrefix'),
            postfix = this.get('i18nPostfix');

        var key = (function () {
          switch (this.get('notificationLevel')) {
            case NotificationLevels.WATCHING:
              return 'watching';
            case NotificationLevels.TRACKING:
              return 'tracking';
            case NotificationLevels.MUTED:
              return 'muted';
            default:
              return 'regular';
          }
        }).call(this);

        var icon = (function () {
          switch (key) {
            case 'watching':
              return '<i class="' + self.watchingClasses + '"></i>&nbsp;';
            case 'tracking':
              return '<i class="' + self.trackingClasses + '"></i>&nbsp;';
            case 'muted':
              return '<i class="' + self.mutedClasses + '"></i>&nbsp;';
            default:
              return '<i class="' + self.regularClasses + '"></i>&nbsp;';
          }
        })();
        return icon + (this.get('buttonIncludesText') ? I18n.t(prefix + '.' + key + postfix + ".title") : '') + "<span class='caret'></span>";
      }).property('notificationLevel'),

      clicked: function () /* id */{
        // sub-class needs to implement this
      }

    });

    __exports__["default"] = NotificationsButton;
    __exports__.NotificationLevels = NotificationLevels;
  });
define("discourse/components/topic-notifications-button", 
  ["discourse/components/notifications-button","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var NotificationsButton = __dependency1__["default"];

    __exports__["default"] = NotificationsButton.extend({
      longDescription: Em.computed.alias('topic.details.notificationReasonText'),
      hidden: Em.computed.alias('topic.deleted'),
      notificationLevel: Em.computed.alias('topic.details.notification_level'),
      i18nPrefix: 'topic.notifications',

      i18nPostfix: (function () {
        return this.get('topic.isPrivateMessage') ? '_pm' : '';
      }).property('topic.isPrivateMessage'),

      clicked: function (id) {
        this.get('topic.details').updateNotifications(id);
      }
    });
  });
define("discourse/lib/link-mentions", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.linkSeenMentions = linkSeenMentions;
    __exports__.fetchUnseenMentions = fetchUnseenMentions;
    function replaceSpan($e, username, opts) {
      if (opts && opts.group) {
        var extra = "",
            extraClass = "";
        if (opts.mentionable) {
          extra = " data-name='" + username + "' data-mentionable-user-count='" + opts.mentionable.user_count + "' ";
          extraClass = " notify";
        }
        $e.replaceWith("<a href='" + Discourse.getURL("/groups/") + username + "' class='mention-group" + extraClass + "'" + extra + ">@" + username + "</a>");
      } else {
        $e.replaceWith("<a href='" + Discourse.getURL("/users/") + username.toLowerCase() + "' class='mention'>@" + username + "</a>");
      }
    }

    var found = [];
    var foundGroups = [];
    var mentionableGroups = [];
    var checked = [];

    function updateFound($mentions, usernames) {
      Ember.run.scheduleOnce('afterRender', function () {
        $mentions.each(function (i, e) {
          var $e = $(e);
          var username = usernames[i];
          if (found.indexOf(username.toLowerCase()) !== -1) {
            replaceSpan($e, username);
          } else if (foundGroups.indexOf(username) !== -1) {
            var mentionable = _(mentionableGroups).where({ name: username }).first();
            replaceSpan($e, username, { group: true, mentionable: mentionable });
          } else if (checked.indexOf(username) !== -1) {
            $e.addClass('mention-tested');
          }
        });
      });
    }

    function linkSeenMentions($elem, siteSettings) {
      var $mentions = $('span.mention:not(.mention-tested)', $elem);
      if ($mentions.length) {
        var usernames = $mentions.map(function (_, e) {
          return $(e).text().substr(1);
        });
        var unseen = _.uniq(usernames).filter(function (u) {
          return u.length >= siteSettings.min_username_length && checked.indexOf(u) === -1;
        });
        updateFound($mentions, usernames);
        return unseen;
      }

      return [];
    }

    function fetchUnseenMentions($elem, usernames) {
      return Discourse.ajax("/users/is_local_username", { data: { usernames: usernames } }).then(function (r) {
        found.push.apply(found, r.valid);
        foundGroups.push.apply(foundGroups, r.valid_groups);
        mentionableGroups.push.apply(mentionableGroups, r.mentionable_groups);
        checked.push.apply(checked, usernames);
        return r;
      });
    }
  });
define("discourse/components/site-header", 
  ["discourse/components/mount-widget","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.headerHeight = headerHeight;

    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var MountWidget = __dependency1__["default"];
    var observes = __dependency2__.observes;

    var _flagProperties = [];
    function addFlagProperty(prop) {
      _flagProperties.pushObject(prop);
    }

    var PANEL_BODY_MARGIN = 30;

    var SiteHeaderComponent = MountWidget.extend(_createDecoratedObject([{
      key: 'widget',
      initializer: function () {
        return 'header';
      }
    }, {
      key: 'docAt',
      initializer: function () {
        return null;
      }
    }, {
      key: 'dockedHeader',
      initializer: function () {
        return null;
      }
    }, {
      key: '_topic',
      initializer: function () {
        return null;
      }
    }, {
      key: '_notificationsChanged',
      decorators: [observes('currentUser.unread_notifications', 'currentUser.unread_private_messages')],
      value: function () {
        this.queueRerender();
      }
    }, {
      key: 'examineDockHeader',
      value: function () {
        var _this = this;

        var $body = $('body');

        // Check the dock after the current run loop. While rendering,
        // it's much slower to calculate `outlet.offset()`
        Ember.run.next(function () {
          if (_this.docAt === null) {
            var outlet = $('#main-outlet');
            if (!(outlet && outlet.length === 1)) return;
            _this.docAt = outlet.offset().top;
          }

          var offset = window.pageYOffset || $('html').scrollTop();
          if (offset >= _this.docAt) {
            if (!_this.dockedHeader) {
              $body.addClass('docked');
              _this.dockedHeader = true;
            }
          } else {
            if (_this.dockedHeader) {
              $body.removeClass('docked');
              _this.dockedHeader = false;
            }
          }
        });
      }
    }, {
      key: 'setTopic',
      value: function (topic) {
        this._topic = topic;
        this.queueRerender();
      }
    }, {
      key: 'didInsertElement',
      value: function () {
        var _this2 = this;

        this._super();
        $(window).bind('scroll.discourse-dock', function () {
          return _this2.examineDockHeader();
        });
        $(document).bind('touchmove.discourse-dock', function () {
          return _this2.examineDockHeader();
        });
        $(window).on('resize.discourse-menu-panel', function () {
          return _this2.afterRender();
        });

        this.appEvents.on('header:show-topic', function (topic) {
          return _this2.setTopic(topic);
        });
        this.appEvents.on('header:hide-topic', function () {
          return _this2.setTopic(null);
        });

        this.dispatch('notifications:changed', 'user-notifications');
        this.dispatch('header:keyboard-trigger', 'header');

        this.appEvents.on('dom:clean', function () {
          // For performance, only trigger a re-render if any menu panels are visible
          if (_this2.$('.menu-panel').length) {
            _this2.eventDispatched('dom:clean', 'header');
          }
        });

        this.examineDockHeader();
      }
    }, {
      key: 'willDestroyElement',
      value: function () {
        this._super();
        $(window).unbind('scroll.discourse-dock');
        $(document).unbind('touchmove.discourse-dock');
        $('body').off('keydown.header');
        this.appEvents.off('notifications:changed');
        $(window).off('resize.discourse-menu-panel');

        this.appEvents.off('header:show-topic');
        this.appEvents.off('header:hide-topic');
        this.appEvents.off('dom:clean');
      }
    }, {
      key: 'buildArgs',
      value: function () {
        var _this3 = this;

        return {
          flagCount: _flagProperties.reduce(function (prev, cur) {
            return prev + (_this3.get(cur) || 0);
          }, 0),
          topic: this._topic,
          canSignUp: this.get('canSignUp')
        };
      }
    }, {
      key: 'afterRender',
      value: function () {
        var $menuPanels = $('.menu-panel');
        if ($menuPanels.length === 0) {
          return;
        }

        var $window = $(window);
        var windowWidth = parseInt($window.width());

        var headerWidth = $('#main-outlet .container').width() || 1100;
        var remaining = parseInt((windowWidth - headerWidth) / 2);
        var viewMode = remaining < 50 ? 'slide-in' : 'drop-down';

        $menuPanels.each(function (idx, panel) {
          var $panel = $(panel);
          var width = parseInt($panel.attr('data-max-width') || 300);
          if (windowWidth - width < 50) {
            width = windowWidth - 50;
          }

          $panel.removeClass('drop-down').removeClass('slide-in').addClass(viewMode);

          var $panelBody = $('.panel-body', $panel);
          var contentHeight = parseInt($('.panel-body-contents', $panel).height());

          // We use a mutationObserver to check for style changes, so it's important
          // we don't set it if it doesn't change. Same goes for the $panelBody!
          var style = $panel.prop('style');

          if (viewMode === 'drop-down') {
            var $buttonPanel = $('header ul.icons');
            if ($buttonPanel.length === 0) {
              return;
            }

            // These values need to be set here, not in the css file - this is to deal with the
            // possibility of the window being resized and the menu changing from .slide-in to .drop-down.
            if (style.top !== '100%' || style.height !== 'auto') {
              $panel.css({ top: '100%', height: 'auto' });
            }

            // adjust panel height
            var fullHeight = parseInt($window.height());
            var offsetTop = $panel.offset().top;
            var scrollTop = $window.scrollTop();

            if (contentHeight + (offsetTop - scrollTop) + PANEL_BODY_MARGIN > fullHeight) {
              contentHeight = fullHeight - (offsetTop - scrollTop) - PANEL_BODY_MARGIN;
            }
            if ($panelBody.height() !== contentHeight) {
              $panelBody.height(contentHeight);
            }
            $('body').addClass('drop-down-visible');
          } else {
            var menuTop = headerHeight();

            var height = undefined;
            var winHeight = $(window).height() - 16;
            if (menuTop + contentHeight < winHeight) {
              height = contentHeight + "px";
            } else {
              height = winHeight - menuTop;
            }

            if ($panelBody.prop('style').height !== '100%') {
              $panelBody.height('100%');
            }
            if (style.top !== menuTop + "px" || style.height !== height) {
              $panel.css({ top: menuTop + "px", height: height });
            }
            $('body').removeClass('drop-down-visible');
          }

          $panel.width(width);
        });
      }
    }]));

    __exports__["default"] = SiteHeaderComponent;

    function applyFlaggedProperties() {
      var args = _flagProperties.slice();
      args.push((function () {
        this.queueRerender();
      }).on('init'));

      SiteHeaderComponent.reopen({ _flagsChanged: Ember.observer.apply(this, args) });
    }

    addFlagProperty('currentUser.site_flagged_posts_count');
    addFlagProperty('currentUser.post_queue_new_count');

    __exports__.addFlagProperty = addFlagProperty;
    __exports__.applyFlaggedProperties = applyFlaggedProperties;

    function headerHeight() {
      var $header = $('header.d-header');
      var headerOffset = $header.offset();
      var headerOffsetTop = headerOffset ? headerOffset.top : 0;
      return parseInt($header.outerHeight() + headerOffsetTop - $(window).scrollTop());
    }

    // profileWidget: true,
    // classNameBindings: ['editingTopic'],
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:


var discourseEscape = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': "&quot;",
  "'": "&#x27;",
  '`': '&#x60;'
};
var discourseBadChars = /[&<>"'`]/g;
var discoursePossible = /[&<>"'`]/;

function discourseEscapeChar(chr) {
  return discourseEscape[chr];
}
Discourse.Utilities = {

  translateSize: function(size) {
    switch (size) {
      case 'tiny': return 20;
      case 'small': return 25;
      case 'medium': return 32;
      case 'large': return 45;
      case 'extra_large': return 60;
      case 'huge': return 120;
    }
    return size;
  },

  // Handlebars no longer allows spaces in its `escapeExpression` code which makes it
  // unsuitable for many of Discourse's uses. Use `Handlebars.Utils.escapeExpression`
  // when escaping an attribute in HTML, otherwise this one will do.
  escapeExpression: function(string) {
    // don't escape SafeStrings, since they're already safe
    if (string instanceof Handlebars.SafeString) {
      return string.toString();
    } else if (string == null) {
      return "";
    } else if (!string) {
      return string + '';
    }

    // Force a string conversion as this will be done by the append regardless and
    // the regex test will do this transparently behind the scenes, causing issues if
    // an object's to string has escaped characters in it.
    string = "" + string;

    if(!discoursePossible.test(string)) { return string; }
    return string.replace(discourseBadChars, discourseEscapeChar);
  },

  avatarUrl: function(template, size) {
    if (!template) { return ""; }
    var rawSize = Discourse.Utilities.getRawSize(Discourse.Utilities.translateSize(size));
    return template.replace(/\{size\}/g, rawSize);
  },

  getRawSize: function(size) {
    var pixelRatio = window.devicePixelRatio || 1;
    return size * Math.min(3, Math.max(1, Math.round(pixelRatio)));
  },

  avatarImg: function(options) {
    var size = Discourse.Utilities.translateSize(options.size);
    var url = Discourse.Utilities.avatarUrl(options.avatarTemplate, size);

    // We won't render an invalid url
    if (!url || url.length === 0) { return ""; }

    var classes = "avatar" + (options.extraClasses ? " " + options.extraClasses : "");
    var title = (options.title) ? " title='" + Handlebars.Utils.escapeExpression(options.title || "") + "'" : "";

    return "<img alt='' width='" + size + "' height='" + size + "' src='" + Discourse.getURLWithCDN(url) + "' class='" + classes + "'" + title + ">";
  },

  tinyAvatar: function(avatarTemplate, options) {
    return Discourse.Utilities.avatarImg(_.merge({avatarTemplate: avatarTemplate, size: 'tiny' }, options));
  },

  postUrl: function(slug, topicId, postNumber) {
    var url = Discourse.getURL("/t/");
    if (slug) {
      url += slug + "/";
    } else {
      url += 'topic/';
    }
    url += topicId;
    if (postNumber > 1) {
      url += "/" + postNumber;
    }
    return url;
  },

  userUrl: function(username) {
    return Discourse.getURL("/users/" + username.toLowerCase());
  },

  emailValid: function(email) {
    // see:  http://stackoverflow.com/questions/46155/validate-email-address-in-javascript
    var re = /^[a-zA-Z0-9!#$%&'*+\/=?\^_`{|}~\-]+(?:\.[a-zA-Z0-9!#$%&'\*+\/=?\^_`{|}~\-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-]*[a-zA-Z0-9])?$/;
    return re.test(email);
  },

  selectedText: function() {
    var html = '';

    if (typeof window.getSelection !== "undefined") {
      var sel = window.getSelection();
      if (sel.rangeCount) {
        var container = document.createElement("div");
        for (var i = 0, len = sel.rangeCount; i < len; ++i) {
          container.appendChild(sel.getRangeAt(i).cloneContents());
        }
        html = container.innerHTML;
      }
    } else if (typeof document.selection !== "undefined") {
      if (document.selection.type === "Text") {
        html = document.selection.createRange().htmlText;
      }
    }

    // Strip out any .click elements from the HTML before converting it to text
    var div = document.createElement('div');
    div.innerHTML = html;
    var $div = $(div);
    // Find all emojis and replace with its title attribute.
    $div.find('img.emoji').replaceWith(function() { return this.title; });
    $('.clicks', $div).remove();
    var text = div.textContent || div.innerText || "";

    return String(text).trim();
  },

  // Determine the row and col of the caret in an element
  caretRowCol: function(el) {
    var caretPosition = Discourse.Utilities.caretPosition(el);
    var rows = el.value.slice(0, caretPosition).split("\n");
    var rowNum = rows.length;

    var colNum = caretPosition - rows.splice(0, rowNum - 1).reduce(function(sum, row) {
      return sum + row.length + 1;
    }, 0);

    return { rowNum: rowNum, colNum: colNum};
  },

  // Determine the position of the caret in an element
  caretPosition: function(el) {
    var r, rc, re;
    if (el.selectionStart) {
      return el.selectionStart;
    }
    if (document.selection) {
      el.focus();
      r = document.selection.createRange();
      if (!r) return 0;

      re = el.createTextRange();
      rc = re.duplicate();
      re.moveToBookmark(r.getBookmark());
      rc.setEndPoint('EndToStart', re);
      return rc.text.length;
    }
    return 0;
  },

  // Set the caret's position
  setCaretPosition: function(ctrl, pos) {
    var range;
    if (ctrl.setSelectionRange) {
      ctrl.focus();
      ctrl.setSelectionRange(pos, pos);
      return;
    }
    if (ctrl.createTextRange) {
      range = ctrl.createTextRange();
      range.collapse(true);
      range.moveEnd('character', pos);
      range.moveStart('character', pos);
      return range.select();
    }
  },

  validateUploadedFiles: function(files, bypassNewUserRestriction) {
    if (!files || files.length === 0) { return false; }

    if (files.length > 1) {
      bootbox.alert(I18n.t('post.errors.too_many_uploads'));
      return false;
    }

    var upload = files[0];

    // CHROME ONLY: if the image was pasted, sets its name to a default one
    if (typeof Blob !== "undefined" && typeof File !== "undefined") {
      if (upload instanceof Blob && !(upload instanceof File) && upload.type === "image/png") { upload.name = "blob.png"; }
    }

    var type = Discourse.Utilities.uploadTypeFromFileName(upload.name);

    return Discourse.Utilities.validateUploadedFile(upload, type, bypassNewUserRestriction);
  },

  validateUploadedFile: function(file, type, bypassNewUserRestriction) {
    // check that the uploaded file is authorized
    if (!Discourse.Utilities.authorizesAllExtensions() &&
        !Discourse.Utilities.isAuthorizedUpload(file)) {
      var extensions = Discourse.Utilities.authorizedExtensions();
      bootbox.alert(I18n.t('post.errors.upload_not_authorized', { authorized_extensions: extensions }));
      return false;
    }

    if (!bypassNewUserRestriction) {
      // ensures that new users can upload a file
      if (!Discourse.User.current().isAllowedToUploadAFile(type)) {
        bootbox.alert(I18n.t('post.errors.' + type + '_upload_not_allowed_for_new_user'));
        return false;
      }
    }

    // everything went fine
    return true;
  },

  uploadTypeFromFileName: function(fileName) {
    return Discourse.Utilities.isAnImage(fileName) ? 'image' : 'attachment';
  },

  authorizesAllExtensions: function() {
    return Discourse.SiteSettings.authorized_extensions.indexOf("*") >= 0;
  },

  isAuthorizedUpload: function(file) {
    if (file && file.name) {
      var extensions = _.chain(Discourse.SiteSettings.authorized_extensions.split("|"))
                        .reject(function(extension) { return extension.indexOf("*") >= 0; })
                        .map(function(extension) { return (extension.indexOf(".") === 0 ? extension.substring(1) : extension).replace(".", "\\."); })
                        .value();
      return new RegExp("\\.(" + extensions.join("|") + ")$", "i").test(file.name);
    }
    return false;
  },

  authorizedExtensions: function() {
    return _.chain(Discourse.SiteSettings.authorized_extensions.split("|"))
            .reject(function(extension) { return extension.indexOf("*") >= 0; })
            .map(function(extension) { return extension.toLowerCase(); })
            .value()
            .join(", ");
  },

  getUploadMarkdown: function(upload) {
    if (Discourse.Utilities.isAnImage(upload.original_filename)) {
      return '<img src="' + upload.url + '" width="' + upload.width + '" height="' + upload.height + '">';
    } else if (!Discourse.SiteSettings.prevent_anons_from_downloading_files && (/\.(mov|mp4|webm|ogv|mp3|ogg|wav)$/i).test(upload.original_filename)) {
      // is Audio/Video
      if (Discourse.CDN) {
        return Discourse.CDN.startsWith('//') ? "http:" + Discourse.getURLWithCDN(upload.url) : Discourse.getURLWithCDN(upload.url);
      } else {
        return "http://" + Discourse.BaseUrl + upload.url;
      }
    } else {
      return '<a class="attachment" href="' + upload.url + '">' + upload.original_filename + '</a> (' + I18n.toHumanSize(upload.filesize) + ')';
    }
  },

  isAnImage: function(path) {
    return (/\.(png|jpe?g|gif|bmp|tiff?|svg|webp|ico)$/i).test(path);
  },

  allowsImages: function() {
    return Discourse.Utilities.authorizesAllExtensions() ||
           (/(png|jpe?g|gif|bmp|tiff?|svg|webp|ico)/i).test(Discourse.Utilities.authorizedExtensions());
  },

  allowsAttachments: function() {
    return Discourse.Utilities.authorizesAllExtensions() ||
           !(/((png|jpe?g|gif|bmp|tiff?|svg|web|ico)(,\s)?)+$/i).test(Discourse.Utilities.authorizedExtensions());
  },

  displayErrorForUpload: function(data) {
    // deal with meaningful errors first
    if (data.jqXHR) {
      switch (data.jqXHR.status) {
        // cancelled by the user
        case 0: return;

        // entity too large, usually returned from the web server
        case 413:
          var type = Discourse.Utilities.uploadTypeFromFileName(data.files[0].name);
          var maxSizeKB = Discourse.SiteSettings['max_' + type + '_size_kb'];
          bootbox.alert(I18n.t('post.errors.file_too_large', { max_size_kb: maxSizeKB }));
          return;

        // the error message is provided by the server
        case 422:
          if (data.jqXHR.responseJSON.message) {
            bootbox.alert(data.jqXHR.responseJSON.message);
          } else {
            bootbox.alert(data.jqXHR.responseJSON.join("\n"));
          }
          return;
      }
    } else if (data.errors && data.errors.length > 0) {
      bootbox.alert(data.errors.join("\n"));
      return;
    }
    // otherwise, display a generic error message
    bootbox.alert(I18n.t('post.errors.upload'));
  },

  defaultHomepage: function() {
    // the homepage is the first item of the 'top_menu' site setting
    return Discourse.SiteSettings.top_menu.split("|")[0].split(",")[0];
  }

};


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/*eslint no-bitwise:0 */

/**

  Discourse uses the Markdown.js as its main parser. `Discourse.Dialect` is the framework
  for extending it with additional formatting.

**/

var parser = window.BetterMarkdown,
    MD = parser.Markdown,
    DialectHelpers = parser.DialectHelpers,
    dialect = MD.dialects.Discourse = DialectHelpers.subclassDialect( MD.dialects.Gruber ),
    initialized = false,
    emitters = [],
    hoisted,
    preProcessors = [],
    escape = Discourse.Utilities.escapeExpression;

/**
  Initialize our dialects for processing.

  @method initializeDialects
**/
function initializeDialects() {
  MD.buildBlockOrder(dialect.block);
  var index = dialect.block.__order__.indexOf("code");
  if (index > -1) {
    dialect.block.__order__.splice(index, 1);
    dialect.block.__order__.unshift("code");
  }
  MD.buildInlinePatterns(dialect.inline);
  initialized = true;
}

/**
  Process the text nodes in the JsonML tree, calling any emitters that have
  been added.

  @method processTextNodes
  @param {Array} node the JsonML tree
  @param {Object} event the parse node event data
  @param {Function} emitter the function to call on the text node
**/
function processTextNodes(node, event, emitter) {
  if (node.length < 2) { return; }

  if (node[0] === '__RAW') {
    var hash = Discourse.Dialect.guid();
    hoisted[hash] = node[1];
    node[1] = hash;
    return;
  }

  for (var j=1; j<node.length; j++) {
    var textContent = node[j];
    if (typeof textContent === "string") {
      var result = emitter(textContent, event);
      if (result) {
        if (result instanceof Array) {
          node.splice.apply(node, [j, 1].concat(result));
        } else {
          node[j] = result;
        }
      } else {
        node[j] = textContent;
      }

    }
  }
}


/**
  Parse a JSON ML tree, using registered handlers to adjust it if necessary.

  @method parseTree
  @param {Array} tree the JsonML tree to parse
  @param {Array} path the path of ancestors to the current node in the tree. Can be used for matching.
  @param {Object} insideCounts counts what tags we're inside
  @returns {Array} the parsed tree
**/
function parseTree(tree, path, insideCounts) {

  if (tree instanceof Array) {
    var event = {node: tree, path: path, dialect: dialect, insideCounts: insideCounts || {}};
    Discourse.Dialect.trigger('parseNode', event);

    for (var j=0; j<emitters.length; j++) {
      processTextNodes(tree, event, emitters[j]);
    }

    path = path || [];
    insideCounts = insideCounts || {};

    path.push(tree);

    for (var i=1; i<tree.length; i++) {
      var n = tree[i],
          tagName = n[0];

      insideCounts[tagName] = (insideCounts[tagName] || 0) + 1;

      if (n && n.length === 2 && n[0] === "p" && /^<!--([\s\S]*)-->$/.exec(n[1])) {
        // Remove paragraphs around comment-only nodes.
        tree[i] = n[1];
      } else {
        parseTree(n, path, insideCounts);
      }

      insideCounts[tagName] = insideCounts[tagName] - 1;
    }

    // If raw nodes are in paragraphs, pull them up
    if (tree.length === 2 && tree[0] === 'p' && tree[1] instanceof Array && tree[1][0] === "__RAW") {
      var text = tree[1][1];
      tree[0] = "__RAW";
      tree[1] = text;
    }

    path.pop();
  }
  return tree;
}

/**
  Returns true if there's an invalid word boundary for a match.

  @method invalidBoundary
  @param {Object} args our arguments, including whether we care about boundaries
  @param {Array} prev the previous content, if exists
  @returns {Boolean} whether there is an invalid word boundary
**/
function invalidBoundary(args, prev) {
  if (!(args.wordBoundary || args.spaceBoundary || args.spaceOrTagBoundary)) { return false; }

  var last = prev[prev.length - 1];
  if (typeof last !== "string") { return false; }

  if (args.wordBoundary && (!last.match(/\W$/))) { return true; }
  if (args.spaceBoundary && (!last.match(/\s$/))) { return true; }
  if (args.spaceOrTagBoundary && (!last.match(/(\s|\>)$/))) { return true; }
}

/**
  Returns the number of (terminated) lines in a string.

  @method countLines
  @param {string} str the string.
  @returns {Integer} number of terminated lines in str
**/
function countLines(str) {
  var index = -1, count = 0;
  while ((index = str.indexOf("\n", index + 1)) !== -1) { count++; }
  return count;
}

function hoister(t, target, replacement) {
  var regexp = new RegExp(target.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), "g");
  if (t.match(regexp)) {
    var hash = Discourse.Dialect.guid();
    t = t.replace(regexp, hash);
    hoisted[hash] = replacement;
  }
  return t;
}

function outdent(t) {
  return t.replace(/^([ ]{4}|\t)/gm, "");
}

function removeEmptyLines(t) {
  return t.replace(/^\n+/, "")
          .replace(/\s+$/, "");
}

function hideBackslashEscapedCharacters(t) {
  return t.replace(/\\\\/g, "\u1E800")
          .replace(/\\`/g, "\u1E8001");
}

function showBackslashEscapedCharacters(t) {
  return t.replace(/\u1E8001/g, "\\`")
          .replace(/\u1E800/g, "\\\\");
}

function hoistCodeBlocksAndSpans(text) {
  // replace all "\`" with a single character
  text = hideBackslashEscapedCharacters(text);

  // /!\ the order is important /!\

  // fenced code blocks (AKA GitHub code blocks)
  text = text.replace(/(^\n*|\n)```([a-z0-9\-]*)\n([\s\S]*?)\n```/g, function(_, before, language, content) {
    var hash = Discourse.Dialect.guid();
    hoisted[hash] = escape(showBackslashEscapedCharacters(removeEmptyLines(content)));
    return before + "```" + language + "\n" + hash + "\n```";
  });

  // markdown code blocks
  text = text.replace(/(^\n*|\n\n)((?:(?:[ ]{4}|\t).*\n*)+)/g, function(match, before, content, index) {
    // make sure we aren't in a list
    var previousLine = text.slice(0, index).trim().match(/.*$/);
    if (previousLine && previousLine[0].length) {
      previousLine = previousLine[0].trim();
      if (/^(?:\*|\+|-|\d+\.)\s+/.test(previousLine)) {
        return match;
      }
    }
    // we can safely hoist the code block
    var hash = Discourse.Dialect.guid();
    hoisted[hash] = escape(outdent(showBackslashEscapedCharacters(removeEmptyLines(content))));
    return before + "    " + hash + "\n";
  });

  // <pre>...</pre> code blocks
  text = text.replace(/(\s|^)<pre>([\s\S]*?)<\/pre>/ig, function(_, before, content) {
    var hash = Discourse.Dialect.guid();
    hoisted[hash] = escape(showBackslashEscapedCharacters(removeEmptyLines(content)));
    return before + "<pre>" + hash + "</pre>";
  });

  // code spans (double & single `)
  ["``", "`"].forEach(function(delimiter) {
    var regexp = new RegExp("(^|[^`])" + delimiter + "([^`\\n]+?)" + delimiter + "([^`]|$)", "g");
    text = text.replace(regexp, function(_, before, content, after) {
      var hash = Discourse.Dialect.guid();
      hoisted[hash] = escape(showBackslashEscapedCharacters(content.trim()));
      return before + delimiter + hash + delimiter + after;
    });
  });

  // replace back all weird character with "\`"
  return showBackslashEscapedCharacters(text);
}

/**
  An object used for rendering our dialects.

  @class Dialect
  @namespace Discourse
  @module Discourse
**/
Discourse.Dialect = {

  // http://stackoverflow.com/a/8809472/17174
  guid: function(){
    var d = new Date().getTime();
    if(window.performance && typeof window.performance.now === "function"){
        d += performance.now(); //use high-precision timer if available
    }
    var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
        var r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d/16);
        return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
    return uuid;
  },

  /**
    Cook text using the dialects.

    @method cook
    @param {String} text the raw text to cook
    @param {Object} opts hash of options
    @returns {String} the cooked text
  **/
  cook: function(text, opts) {
    if (!initialized) { initializeDialects(); }

    dialect.options = opts;

    // Helps us hoist out HTML
    hoisted = {};

    // pre-hoist all code-blocks/spans
    text = hoistCodeBlocksAndSpans(text);

    // pre-processors
    preProcessors.forEach(function(p) {
      text = p(text, hoister);
    });

    var tree = parser.toHTMLTree(text, 'Discourse'),
        result = parser.renderJsonML(parseTree(tree));

    if (opts.sanitize) {
      result = Discourse.Markdown.sanitize(result);
    } else if (opts.sanitizerFunction) {
      result = opts.sanitizerFunction(result);
    }

    // If we hoisted out anything, put it back
    var keys = Object.keys(hoisted);
    if (keys.length) {
      var found = true;

      var unhoist = function(key) {
        result = result.replace(new RegExp(key, "g"), function() {
          found = true;
          return hoisted[key];
        });
      };

      while(found) {
        found = false;
        keys.forEach(unhoist);
      }
    }

    return result.trim();
  },

  /**
    Adds a text pre-processor. Use only if necessary, as a dialect
    that emits JsonML is much better if possible.
  **/
  addPreProcessor: function(preProc) {
    preProcessors.push(preProc);
  },

  /**
    Registers an inline replacer function

    @method registerInline
    @param {String} start The token the replacement begins with
    @param {Function} fn The replacing function
  **/
  registerInline: function(start, fn) {
    dialect.inline[start] = fn;
  },


  /**
    The simplest kind of replacement possible. Replace a stirng token with JsonML.

    For example to replace all occurrances of :) with a smile image:

    ```javascript
      Discourse.Dialect.inlineReplace(':)', function (text) {
        return ['img', {src: '/images/smile.png'}];
      });

    ```

    @method inlineReplace
    @param {String} token The token we want to replace
    @param {Function} emitter A function that emits the JsonML for the replacement.
  **/
  inlineReplace: function(token, emitter) {
    this.registerInline(token, function(text, match, prev) {
      return [token.length, emitter.call(this, token, match, prev)];
    });
  },

  /**
    Matches inline using a regular expression. The emitter function is passed
    the matches from the regular expression.

    For example, this auto links URLs:

    ```javascript
      Discourse.Dialect.inlineRegexp({
        matcher: /((?:https?:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.])(?:[^\s()<>]+|\([^\s()<>]+\))+(?:\([^\s()<>]+\)|[^`!()\[\]{};:'".,<>?«»“”‘’\s]))/gm,
        spaceBoundary: true,
        start: 'http',

        emitter: function(matches) {
          var url = matches[1];
          return ['a', {href: url}, url];
        }
      });
    ```

    @method inlineRegexp
    @param {Object} args Our replacement options
      @param {Function} [opts.emitter] The function that will be called with the contents and regular expresison match and returns JsonML.
      @param {String} [opts.start] The starting token we want to find
      @param {String} [opts.matcher] The regular expression to match
      @param {Boolean} [opts.wordBoundary] If true, the match must be on a word boundary
      @param {Boolean} [opts.spaceBoundary] If true, the match must be on a space boundary
  **/
  inlineRegexp: function(args) {
    this.registerInline(args.start, function(text, match, prev) {
      if (invalidBoundary(args, prev)) { return; }

      args.matcher.lastIndex = 0;
      var m = args.matcher.exec(text);
      if (m) {
        var result = args.emitter.call(this, m);
        if (result) {
          return [m[0].length, result];
        }
      }
    });
  },

  /**
    Handles inline replacements surrounded by tokens.

    For example, to handle markdown style bold. Note we use `concat` on the array because
    the contents are JsonML too since we didn't pass `rawContents` as true. This supports
    recursive markup.

    ```javascript

      Discourse.Dialect.inlineBetween({
        between: '**',
        wordBoundary: true.
        emitter: function(contents) {
          return ['strong'].concat(contents);
        }
      });
    ```

    @method inlineBetween
    @param {Object} args Our replacement options
      @param {Function} [opts.emitter] The function that will be called with the contents and returns JsonML.
      @param {String} [opts.start] The starting token we want to find
      @param {String} [opts.stop] The ending token we want to find
      @param {String} [opts.between] A shortcut for when the `start` and `stop` are the same.
      @param {Boolean} [opts.rawContents] If true, the contents between the tokens will not be parsed.
      @param {Boolean} [opts.wordBoundary] If true, the match must be on a word boundary
      @param {Boolean} [opts.spaceBoundary] If true, the match must be on a space boundary
  **/
  inlineBetween: function(args) {
    var start = args.start || args.between,
        stop = args.stop || args.between,
        startLength = start.length,
        self = this;

    this.registerInline(start, function(text, match, prev) {
      if (invalidBoundary(args, prev)) { return; }

      var endPos = self.findEndPos(text, start, stop, args, startLength);
      if (endPos === -1) { return; }
      var between = text.slice(startLength, endPos);

      // If rawcontents is set, don't process inline
      if (!args.rawContents) {
        between = this.processInline(between);
      }

      var contents = args.emitter.call(this, between);
      if (contents) {
        return [endPos+stop.length, contents];
      }
    });
  },

  findEndPos: function(text, start, stop, args, offset) {
    var endPos, nextStart;
    do {
      endPos = text.indexOf(stop, offset);
      if (endPos === -1) { return -1; }
      nextStart = text.indexOf(start, offset);
      offset = endPos + stop.length;
    } while (nextStart !== -1 && nextStart < endPos);
    return endPos;
  },

  /**
    Registers a block for processing. This is more complicated than using one of
    the other helpers such as `replaceBlock` so consider using them first!

    @method registerBlock
    @param {String} name the name of the block handler
    @param {Function} handler the handler
  **/
  registerBlock: function(name, handler) {
    dialect.block[name] = handler;
  },

  /**
    Replaces a block of text between a start and stop. As opposed to inline, these
    might span multiple lines.

    Here's an example that takes the content between `[code]` ... `[/code]` and
    puts them inside a `pre` tag:

    ```javascript
      Discourse.Dialect.replaceBlock({
        start: /(\[code\])([\s\S]*)/igm,
        stop: '[/code]',
        rawContents: true,

        emitter: function(blockContents) {
          return ['p', ['pre'].concat(blockContents)];
        }
      });
    ```

    @method replaceBlock
    @param {Object} args Our replacement options
      @param {RegExp} [args.start] The starting regexp we want to find
      @param {String} [args.stop] The ending token we want to find
      @param {Boolean} [args.rawContents] True to skip recursive processing
      @param {Function} [args.emitter] The emitting function to transform the contents of the block into jsonML

  **/
  replaceBlock: function(args) {
    var fn = function(block, next) {

      var linebreaks = dialect.options.traditional_markdown_linebreaks ||
          Discourse.SiteSettings.traditional_markdown_linebreaks;
      if (linebreaks && args.skipIfTradtionalLinebreaks) { return; }

      args.start.lastIndex = 0;
      var result = [], match = (args.start).exec(block);
      if (!match) { return; }

      var lastChance = function() {
        return !next.some(function(blk) { return blk.match(args.stop); });
      };

      // shave off start tag and leading text, if any.
      var pos = args.start.lastIndex - match[0].length,
          leading = block.slice(0, pos),
          trailing = match[2] ? match[2].replace(/^\n*/, "") : "";

      if(args.withoutLeading && args.withoutLeading.test(leading)) {
        //The other leading block should be processed first! eg a code block wrapped around a code block.
        return;
      }

      // just give up if there's no stop tag in this or any next block
      args.stop.lastIndex = block.length - trailing.length;
      if (!args.stop.exec(block) && lastChance()) { return; }
      if (leading.length > 0) {
        var parsedLeading = this.processBlock(MD.mk_block(leading), []);
        if (parsedLeading && parsedLeading[0]) {
          result.push(parsedLeading[0]);
        }
      }
      if (trailing.length > 0) {
        next.unshift(MD.mk_block(trailing, block.trailing,
          block.lineNumber + countLines(leading) + (match[2] ? match[2].length : 0) - trailing.length));
      }

      // go through the available blocks to find the matching stop tag.
      var contentBlocks = [], nesting = 0, actualEndPos = -1, currentBlock;
      blockloop:
      while (currentBlock = next.shift()) {
        // collect all the start and stop tags in the current block
        args.start.lastIndex = 0;
        var startPos = [], m;
        while (m = (args.start).exec(currentBlock)) {
          startPos.push(args.start.lastIndex - m[0].length);
          args.start.lastIndex = args.start.lastIndex - (m[2] ? m[2].length : 0);
        }
        args.stop.lastIndex = 0;
        var endPos = [];
        while (m = (args.stop).exec(currentBlock)) {
          endPos.push(args.stop.lastIndex - m[0].length);
        }

        // go through the available end tags:
        var ep = 0, sp = 0; // array indices
        while (ep < endPos.length) {
          if (sp < startPos.length && startPos[sp] < endPos[ep]) {
            // there's an end tag, but there's also another start tag first. we need to go deeper.
            sp++; nesting++;
          } else if (nesting > 0) {
            // found an end tag, but we must go up a level first.
            ep++; nesting--;
          } else {
            // found an end tag and we're at the top: done! -- or: start tag and end tag are
            // identical, (i.e. startPos[sp] == endPos[ep]), so we don't do nesting at all.
            actualEndPos = endPos[ep];
            break blockloop;
          }
        }

        if (lastChance()) {
          // when lastChance() becomes true the first time, currentBlock contains the last
          // end tag available in the input blocks but it's not on the right nesting level
          // or we would have terminated the loop already. the only thing we can do is to
          // treat the last available end tag as tho it were matched with our start tag
          // and let the emitter figure out how to render the garbage inside.
          actualEndPos = endPos[endPos.length - 1];
          break;
        }

        // any left-over start tags still increase the nesting level
        nesting += startPos.length - sp;
        contentBlocks.push(currentBlock);
      }

      var stopLen = currentBlock.match(args.stop)[0].length,
          before = currentBlock.slice(0, actualEndPos).replace(/\n*$/, ""),
          after = currentBlock.slice(actualEndPos + stopLen).replace(/^\n*/, "");
      if (before.length > 0) contentBlocks.push(MD.mk_block(before, "", currentBlock.lineNumber));
      if (after.length > 0) next.unshift(MD.mk_block(after, currentBlock.trailing, currentBlock.lineNumber + countLines(before)));

      var emitterResult = args.emitter.call(this, contentBlocks, match, dialect.options);
      if (emitterResult) { result.push(emitterResult); }
      return result;
    };

    if (args.priority) {
      fn.priority = args.priority;
    }

    this.registerBlock(args.start.toString(), fn);
  },

  /**
    After the parser has been executed, post process any text nodes in the HTML document.
    This is useful if you want to apply a transformation to the text.

    If you are generating HTML from the text, it is preferable to use the replacer
    functions and do it in the parsing part of the pipeline. This function is best for
    simple transformations or transformations that have to happen after all earlier
    processing is done.

    For example, to convert all text to upper case:

    ```javascript

      Discourse.Dialect.postProcessText(function (text) {
        return text.toUpperCase();
      });

    ```

    @method postProcessText
    @param {Function} emitter The function to call with the text. It returns JsonML to modify the tree.
  **/
  postProcessText: function(emitter) {
    emitters.push(emitter);
  },

  /**
    After the parser has been executed, change the contents of a HTML tag.

    Let's say you want to replace the contents of all code tags to prepend
    "EVIL TROUT HACKED YOUR CODE!":

    ```javascript
      Discourse.Dialect.postProcessTag('code', function (contents) {
        return "EVIL TROUT HACKED YOUR CODE!\n\n" + contents;
      });
    ```

    @method postProcessTag
    @param {String} tag The HTML tag you want to match on
    @param {Function} emitter The function to call with the text. It returns JsonML to modify the tree.
  **/
  postProcessTag: function(tag, emitter) {
    Discourse.Dialect.on('parseNode', function (event) {
      var node = event.node;
      if (node[0] === tag) {
        node[node.length-1] = emitter(node[node.length-1]);
      }
    });
  }

};

RSVP.EventTarget.mixin(Discourse.Dialect);




// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

// TODO @robin to move this whole thing to es6
Discourse.Emoji = {};

// bump up this number to expire all emojis
Discourse.Emoji.ImageVersion = "2"

var emoji = ["100", "1234", "8ball", "a", "ab", "abc", "abcd", "accept", "aerial_tramway", "airplane", "airplane_arriving", "airplane_departure", "airplane_small", "alarm_clock", "alembic", "alien", "ambulance", "amphora", "anchor", "angel", "anger", "anger_right", "angry", "anguished", "ant", "apple", "aquarius", "aries", "arrow_backward", "arrow_double_down", "arrow_double_up", "arrow_down", "arrow_down_small", "arrow_forward", "arrow_heading_down", "arrow_heading_up", "arrow_left", "arrow_lower_left", "arrow_lower_right", "arrow_right", "arrow_right_hook", "arrow_up", "arrow_up_down", "arrow_up_small", "arrow_upper_left", "arrow_upper_right", "arrows_clockwise", "arrows_counterclockwise", "art", "articulated_lorry", "astonished", "athletic_shoe", "atm", "atom", "b", "baby", "baby_bottle", "baby_chick", "baby_symbol", "back", "badminton", "baggage_claim", "balloon", "ballot_box", "ballot_box_with_check", "bamboo", "banana", "bangbang", "bank", "bar_chart", "barber", "baseball", "basketball", "basketball_player", "bath", "bathtub", "battery", "beach", "beach_umbrella", "bear", "bed", "bee", "beer", "beers", "beetle", "beginner", "bell", "bellhop", "bento", "bicyclist", "bike", "bikini", "biohazard", "bird", "birthday", "black_circle", "black_joker", "black_large_square", "black_medium_small_square", "black_medium_square", "black_nib", "black_small_square", "black_square_button", "blossom", "blowfish", "blue_book", "blue_car", "blue_heart", "blush", "boar", "bomb", "book", "bookmark", "bookmark_tabs", "books", "boom", "boot", "bouquet", "bow", "bow_and_arrow", "bowling", "boy", "bread", "bride_with_veil", "bridge_at_night", "briefcase", "broken_heart", "bug", "bulb", "bullettrain_front", "bullettrain_side", "burrito", "bus", "busstop", "bust_in_silhouette", "busts_in_silhouette", "cactus", "cake", "calendar", "calendar_spiral", "calling", "camel", "camera", "camera_with_flash", "camping", "cancer", "candle", "candy", "capital_abcd", "capricorn", "card_box", "card_index", "carousel_horse", "cat", "cat2", "cd", "chains", "champagne", "chart", "chart_with_downwards_trend", "chart_with_upwards_trend", "checkered_flag", "cheese", "cherries", "cherry_blossom", "chestnut", "chicken", "children_crossing", "chipmunk", "chocolate_bar", "christmas_tree", "church", "cinema", "circus_tent", "city_dusk", "city_sunset", "cityscape", "cl", "clap", "clapper", "classical_building", "clipboard", "clock", "clock1", "clock10", "clock1030", "clock11", "clock1130", "clock12", "clock1230", "clock130", "clock2", "clock230", "clock3", "clock330", "clock4", "clock430", "clock5", "clock530", "clock6", "clock630", "clock7", "clock730", "clock8", "clock830", "clock9", "clock930", "closed_book", "closed_lock_with_key", "closed_umbrella", "cloud", "cloud_lightning", "cloud_rain", "cloud_snow", "cloud_tornado", "clubs", "cocktail", "coffee", "coffin", "cold_sweat", "comet", "compression", "computer", "confetti_ball", "confounded", "confused", "congratulations", "construction", "construction_site", "construction_worker", "control_knobs", "convenience_store", "cookie", "cool", "cop", "copyright", "corn", "couch", "couple", "couple_with_heart", "couplekiss", "cow", "cow2", "crab", "crayon", "credit_card", "crescent_moon", "cricket", "crocodile", "cross", "crossed_flags", "crossed_swords", "crown", "cruise_ship", "cry", "crying_cat_face", "crystal_ball", "cupid", "curly_loop", "currency_exchange", "curry", "custard", "customs", "cyclone", "dagger", "dancer", "dancers", "dango", "dark_sunglasses", "dart", "dash", "date", "deciduous_tree", "department_store", "desert", "desktop", "diamond_shape_with_a_dot_inside", "diamonds", "disappointed", "disappointed_relieved", "dividers", "dizzy", "dizzy_face", "do_not_litter", "dog", "dog2", "dollar", "dolls", "dolphin", "door", "doughnut", "dove", "dragon", "dragon_face", "dress", "dromedary_camel", "droplet", "dvd", "e-mail", "ear", "ear_of_rice", "earth_africa", "earth_americas", "earth_asia", "egg", "eggplant", "eight", "eight_pointed_black_star", "eight_spoked_asterisk", "electric_plug", "elephant", "end", "envelope", "envelope_with_arrow", "euro", "european_castle", "european_post_office", "evergreen_tree", "exclamation", "expressionless", "eye", "eyeglasses", "eyes", "factory", "fallen_leaf", "family", "fast_forward", "fax", "fearful", "feet", "ferris_wheel", "ferry", "field_hockey", "file_cabinet", "file_folder", "film_frames", "fire", "fire_engine", "fireworks", "first_quarter_moon", "first_quarter_moon_with_face", "fish", "fish_cake", "fishing_pole_and_fish", "fist", "five", "flag_black", "flag_cn", "flag_de", "flag_es", "flag_fr", "flag_gb", "flag_it", "flag_jp", "flag_kr", "flag_ru", "flag_us", "flag_white", "flags", "flashlight", "fleur-de-lis", "floppy_disk", "flower_playing_cards", "flushed", "fog", "foggy", "football", "footprints", "fork_and_knife", "fork_knife_plate", "fountain", "four", "four_leaf_clover", "frame_photo", "free", "fried_shrimp", "fries", "frog", "frowning", "frowning2", "fuelpump", "full_moon", "full_moon_with_face", "game_die", "gear", "gem", "gemini", "ghost", "gift", "gift_heart", "girl", "globe_with_meridians", "goat", "golf", "golfer", "grapes", "green_apple", "green_book", "green_heart", "grey_exclamation", "grey_question", "grimacing", "grin", "grinning", "guardsman", "guitar", "gun", "haircut", "hamburger", "hammer", "hammer_pick", "hamster", "hand_splayed", "handbag", "hash", "hatched_chick", "hatching_chick", "head_bandage", "headphones", "hear_no_evil", "heart", "heart_decoration", "heart_exclamation", "heart_eyes", "heart_eyes_cat", "heartbeat", "heartpulse", "hearts", "heavy_check_mark", "heavy_division_sign", "heavy_dollar_sign", "heavy_minus_sign", "heavy_multiplication_x", "heavy_plus_sign", "helicopter", "helmet_with_cross", "herb", "hibiscus", "high_brightness", "high_heel", "hockey", "hole", "homes", "honey_pot", "horse", "horse_racing", "hospital", "hot_pepper", "hotdog", "hotel", "hotsprings", "hourglass", "hourglass_flowing_sand", "house", "house_abandoned", "house_with_garden", "hugging", "hushed", "ice_cream", "ice_skate", "icecream", "id", "ideograph_advantage", "imp", "inbox_tray", "incoming_envelope", "information_desk_person", "information_source", "innocent", "interrobang", "iphone", "island", "izakaya_lantern", "jack_o_lantern", "japan", "japanese_castle", "japanese_goblin", "japanese_ogre", "jeans", "joy", "joy_cat", "joystick", "kaaba", "key", "key2", "keyboard", "kimono", "kiss", "kissing", "kissing_cat", "kissing_closed_eyes", "kissing_heart", "kissing_smiling_eyes", "knife", "koala", "koko", "label", "large_blue_circle", "large_blue_diamond", "large_orange_diamond", "last_quarter_moon", "last_quarter_moon_with_face", "laughing", "leaves", "ledger", "left_luggage", "left_right_arrow", "leftwards_arrow_with_hook", "lemon", "leo", "leopard", "level_slider", "levitate", "libra", "lifter", "light_rail", "link", "lion_face", "lips", "lipstick", "lock", "lock_with_ink_pen", "lollipop", "loop", "loud_sound", "loudspeaker", "love_hotel", "love_letter", "low_brightness", "m", "mag", "mag_right", "mahjong", "mailbox", "mailbox_closed", "mailbox_with_mail", "mailbox_with_no_mail", "man", "man_with_gua_pi_mao", "man_with_turban", "mans_shoe", "map", "maple_leaf", "mask", "massage", "meat_on_bone", "medal", "mega", "melon", "menorah", "mens", "metal", "metro", "microphone", "microphone2", "microscope", "middle_finger", "military_medal", "milky_way", "minibus", "minidisc", "mobile_phone_off", "money_mouth", "money_with_wings", "moneybag", "monkey", "monkey_face", "monorail", "mortar_board", "mosque", "motorboat", "motorcycle", "motorway", "mount_fuji", "mountain", "mountain_bicyclist", "mountain_cableway", "mountain_railway", "mountain_snow", "mouse", "mouse2", "mouse_three_button", "movie_camera", "moyai", "muscle", "mushroom", "musical_keyboard", "musical_note", "musical_score", "mute", "nail_care", "name_badge", "necktie", "negative_squared_cross_mark", "nerd", "neutral_face", "new", "new_moon", "new_moon_with_face", "newspaper", "newspaper2", "ng", "night_with_stars", "nine", "no_bell", "no_bicycles", "no_entry", "no_entry_sign", "no_good", "no_mobile_phones", "no_mouth", "no_pedestrians", "no_smoking", "non-potable_water", "nose", "notebook", "notebook_with_decorative_cover", "notepad_spiral", "notes", "nut_and_bolt", "o", "o2", "ocean", "octopus", "oden", "office", "oil", "ok", "ok_hand", "ok_woman", "older_man", "older_woman", "om_symbol", "on", "oncoming_automobile", "oncoming_bus", "oncoming_police_car", "oncoming_taxi", "one", "open_file_folder", "open_hands", "open_mouth", "ophiuchus", "orange_book", "orthodox_cross", "outbox_tray", "ox", "package", "page_facing_up", "page_with_curl", "pager", "paintbrush", "palm_tree", "panda_face", "paperclip", "paperclips", "park", "parking", "part_alternation_mark", "partly_sunny", "passport_control", "pause_button", "peace", "peach", "pear", "pen_ballpoint", "pen_fountain", "pencil", "pencil2", "penguin", "pensive", "performing_arts", "persevere", "person_frowning", "person_with_blond_hair", "person_with_pouting_face", "pick", "pig", "pig2", "pig_nose", "pill", "pineapple", "ping_pong", "pisces", "pizza", "place_of_worship", "play_pause", "point_down", "point_left", "point_right", "point_up", "point_up_2", "police_car", "poodle", "poop", "popcorn", "post_office", "postal_horn", "postbox", "potable_water", "pouch", "poultry_leg", "pound", "pouting_cat", "pray", "prayer_beads", "princess", "printer", "projector", "punch", "purple_heart", "purse", "pushpin", "put_litter_in_its_place", "question", "rabbit", "rabbit2", "race_car", "racehorse", "radio", "radio_button", "radioactive", "rage", "railway_car", "railway_track", "rainbow", "raised_hand", "raised_hands", "raising_hand", "ram", "ramen", "rat", "record_button", "recycle", "red_car", "red_circle", "registered", "relaxed", "relieved", "reminder_ribbon", "repeat", "repeat_one", "restroom", "revolving_hearts", "rewind", "ribbon", "rice", "rice_ball", "rice_cracker", "rice_scene", "ring", "robot", "rocket", "roller_coaster", "rolling_eyes", "rooster", "rose", "rosette", "rotating_light", "round_pushpin", "rowboat", "rugby_football", "runner", "running_shirt_with_sash", "sa", "sagittarius", "sailboat", "sake", "sandal", "santa", "satellite", "satellite_orbital", "saxophone", "scales", "school", "school_satchel", "scissors", "scorpion", "scorpius", "scream", "scream_cat", "scroll", "seat", "secret", "see_no_evil", "seedling", "seven", "shamrock", "shaved_ice", "sheep", "shell", "shield", "shinto_shrine", "ship", "shirt", "shopping_bags", "shower", "signal_strength", "six", "six_pointed_star", "ski", "skier", "skull", "skull_crossbones", "sleeping", "sleeping_accommodation", "sleepy", "slight_frown", "slight_smile", "slot_machine", "small_blue_diamond", "small_orange_diamond", "small_red_triangle", "small_red_triangle_down", "smile", "smile_cat", "smiley", "smiley_cat", "smiling_imp", "smirk", "smirk_cat", "smoking", "snail", "snake", "snowboarder", "snowflake", "snowman", "snowman2", "sob", "soccer", "soon", "sos", "sound", "space_invader", "spades", "spaghetti", "sparkle", "sparkler", "sparkles", "sparkling_heart", "speak_no_evil", "speaker", "speaking_head", "speech_balloon", "speedboat", "spider", "spider_web", "spy", "stadium", "star", "star2", "star_and_crescent", "star_of_david", "stars", "station", "statue_of_liberty", "steam_locomotive", "stew", "stop_button", "stopwatch", "straight_ruler", "strawberry", "stuck_out_tongue", "stuck_out_tongue_closed_eyes", "stuck_out_tongue_winking_eye", "sun_with_face", "sunflower", "sunglasses", "sunny", "sunrise", "sunrise_over_mountains", "surfer", "sushi", "suspension_railway", "sweat", "sweat_drops", "sweat_smile", "sweet_potato", "swimmer", "symbols", "synagogue", "syringe", "taco", "tada", "tanabata_tree", "tangerine", "taurus", "taxi", "tea", "telephone", "telephone_receiver", "telescope", "ten", "tennis", "tent", "thermometer", "thermometer_face", "thinking", "thought_balloon", "three", "thumbsdown", "thumbsup", "thunder_cloud_rain", "ticket", "tickets", "tiger", "tiger2", "timer", "tired_face", "tm", "toilet", "tokyo_tower", "tomato", "tongue", "tools", "top", "tophat", "track_next", "track_previous", "trackball", "tractor", "traffic_light", "train", "train2", "tram", "triangular_flag_on_post", "triangular_ruler", "trident", "triumph", "trolleybus", "trophy", "tropical_drink", "tropical_fish", "truck", "trumpet", "tulip", "turkey", "turtle", "tv", "twisted_rightwards_arrows", "two", "two_hearts", "two_men_holding_hands", "two_women_holding_hands", "u5272", "u5408", "u55b6", "u6307", "u6708", "u6709", "u6e80", "u7121", "u7533", "u7981", "u7a7a", "umbrella", "umbrella2", "unamused", "underage", "unicorn", "unlock", "up", "upside_down", "urn", "v", "vertical_traffic_light", "vhs", "vibration_mode", "video_camera", "video_game", "violin", "virgo", "volcano", "volleyball", "vs", "vulcan", "walking", "waning_crescent_moon", "waning_gibbous_moon", "warning", "wastebasket", "watch", "water_buffalo", "watermelon", "wave", "wavy_dash", "waxing_crescent_moon", "waxing_gibbous_moon", "wc", "weary", "wedding", "whale", "whale2", "wheel_of_dharma", "wheelchair", "white_check_mark", "white_circle", "white_flower", "white_large_square", "white_medium_small_square", "white_medium_square", "white_small_square", "white_square_button", "white_sun_cloud", "white_sun_rain_cloud", "white_sun_small_cloud", "wind_blowing_face", "wind_chime", "wine_glass", "wink", "wolf", "woman", "womans_clothes", "womans_hat", "womens", "worried", "wrench", "writing_hand", "x", "yellow_heart", "yen", "yin_yang", "yum", "zap", "zero", "zipper_mouth", "zzz", "+1", "-1"];
var aliases = {"airplane_small":["small_airplane"], "anger_right":["right_anger_bubble"], "atom":["atom_symbol"], "ballot_box":["ballot_box_with_ballot"], "basketball_player":["person_with_ball"], "beach":["beach_with_umbrella"], "beach_umbrella":["umbrella_on_ground"], "bellhop":["bellhop_bell"], "biohazard":["biohazard_sign"], "bow_and_arrow":["archery"], "calendar_spiral":["spiral_calendar_pad"], "card_box":["card_file_box"], "champagne":["bottle_with_popping_cork"], "cheese":["cheese_wedge"], "city_sunset":["city_sunrise"], "clock":["mantlepiece_clock"], "cloud_lightning":["cloud_with_lightning"], "cloud_rain":["cloud_with_rain"], "cloud_snow":["cloud_with_snow"], "cloud_tornado":["cloud_with_tornado"], "construction_site":["building_construction"], "couch":["couch_and_lamp"], "crayon":["lower_left_crayon"], "cricket":["cricket_bat_ball"], "cross":["latin_cross"], "cruise_ship":["passenger_ship"], "dagger":["dagger_knife"], "desktop":["desktop_computer"], "dividers":["card_index_dividers"], "dove":["dove_of_peace"], "e-mail":["email"], "feet":["paw_prints"], "fire":["flame"], "flag_black":["waving_black_flag"], "flag_cn":["cn"], "flag_de":["de"], "flag_es":["es"], "flag_fr":["fr"], "flag_gb":["gb"], "flag_it":["it"], "flag_jp":["jp"], "flag_kr":["kr"], "flag_ru":["ru"], "flag_us":["us"], "flag_white":["waving_white_flag"], "fork_knife_plate":["fork_and_knife_with_plate"], "frame_photo":["frame_with_picture"], "frowning2":["white_frowning_face"], "hammer_pick":["hammer_and_pick"], "hand_splayed":["raised_hand_with_fingers_splayed"], "head_bandage":["face_with_head_bandage"], "heart_exclamation":["heavy_heart_exclamation_mark_ornament"], "helmet_with_cross":["helmet_with_white_cross"], "homes":["house_buildings"], "hotdog":["hot_dog"], "house_abandoned":["derelict_house_building"], "hugging":["hugging_face"], "island":["desert_island"], "key2":["old_key"], "laughing":["satisfied"], "levitate":["man_in_business_suit_levitating"], "lifter":["weight_lifter"], "lion_face":["lion"], "map":["world_map"], "medal":["sports_medal"], "metal":["sign_of_the_horns"], "microphone2":["studio_microphone"], "middle_finger":["reversed_hand_with_middle_finger_extended"], "money_mouth":["money_mouth_face"], "motorcycle":["racing_motorcycle"], "mountain_snow":["snow_capped_mountain"], "mouse_three_button":["three_button_mouse"], "nerd":["nerd_face"], "newspaper2":["rolled_up_newspaper"], "notepad_spiral":["spiral_note_pad"], "oil":["oil_drum"], "older_woman":["grandma"], "paintbrush":["lower_left_paintbrush"], "paperclips":["linked_paperclips"], "park":["national_park"], "pause_button":["double_vertical_bar"], "peace":["peace_symbol"], "pen_ballpoint":["lower_left_ballpoint_pen"], "pen_fountain":["lower_left_fountain_pen"], "ping_pong":["table_tennis"], "place_of_worship":["worship_symbol"], "poop":["shit", "hankey", "poo"], "projector":["film_projector"], "race_car":["racing_car"], "radioactive":["radioactive_sign"], "railway_track":["railroad_track"], "robot":["robot_face"], "rolling_eyes":["face_with_rolling_eyes"], "skull":["skeleton"], "skull_crossbones":["skull_and_crossbones"], "slight_frown":["slightly_frowning_face"], "slight_smile":["slightly_smiling_face", "slightly_smiling"], "speaking_head":["speaking_head_in_silhouette"], "spy":["sleuth_or_spy"], "thermometer_face":["face_with_thermometer"], "thinking":["thinking_face"], "thumbsdown":["-1"], "thumbsup":["+1"], "thunder_cloud_rain":["thunder_cloud_and_rain"], "tickets":["admission_tickets"], "timer":["timer_clock"], "tools":["hammer_and_wrench"], "track_next":["next_track"], "track_previous":["previous_track"], "unicorn":["unicorn_face"], "upside_down":["upside_down_face"], "urn":["funeral_urn"], "vulcan":["raised_hand_with_part_between_middle_and_ring_fingers"], "white_sun_cloud":["white_sun_behind_cloud"], "white_sun_rain_cloud":["white_sun_behind_cloud_with_rain"], "white_sun_small_cloud":["white_sun_with_small_cloud"], "zipper_mouth":["zipper_mouth_face"]};

var extendedEmoji = {};
if (Discourse.Dialect) {
  Discourse.Dialect.registerEmoji = function(code, url) {
    code = code.toLowerCase();
    extendedEmoji[code] = url;
  };
}

var _unicodeReplacements;
var _unicodeRegexp;
Discourse.Dialect.setUnicodeReplacements = function(replacements) {
  _unicodeReplacements = replacements;
  if (replacements) {
    _unicodeRegexp = new RegExp(Object.keys(replacements).join("|"), "g");
  }
}

// This method is used by PrettyText to reset custom emojis in multisites
Discourse.Dialect.resetEmojis = function() {
  extendedEmoji = {};
};

var customEmojiCallbacks = [];
Discourse.Emoji.addCustomEmojis = function(cb) {
  customEmojiCallbacks.push(cb);
};

Discourse.Emoji.applyCustomEmojis = function() {
  var self = this;
  _.each(customEmojiCallbacks, function(cb) { cb.apply(self); });
};

Discourse.Emoji.list = function(){
  var list = emoji.slice(0);
  _.each(extendedEmoji, function(v,k){ list.push(k); });
  return list;
};


var emojiHash = {};
// add all default emojis
emoji.forEach(function(code){ emojiHash[code] = true; });
// and their aliases

var aliasHash = {};
for (var name in aliases) {
  aliases[name].forEach(function(alias) {
    aliasHash[alias] = name;
  });
}

Discourse.Emoji.unescape = function(string) {
  //this can be further improved by supporting matches of emoticons that don't begin with a colon
  if (Discourse.SiteSettings.enable_emoji && string.indexOf(":") >= 0) {
    string = string.replace(/\B:[^\s:]+:?\B/g, function(m) {
      var isEmoticon = !!Discourse.Emoji.translations[m],
            emoji = isEmoticon ? Discourse.Emoji.translations[m] : m.slice(1, m.length - 1),
            hasEndingColon = m.lastIndexOf(":") === m.length - 1,
            url = Discourse.Emoji.urlFor(emoji);
      return url && (isEmoticon || hasEndingColon) ? "<img src='" + url + "' title='" + emoji + "' alt='" + emoji + "' class='emoji'>" : m;
    });
  }

  return string;
};

Discourse.Emoji.urlFor = urlFor = function(code) {
  var url, set = Discourse.SiteSettings.emoji_set;

  code = code.toLowerCase();

  if(extendedEmoji.hasOwnProperty(code)) {
    url = extendedEmoji[code];
  }

  if(!url && emojiHash.hasOwnProperty(code)) {
    url = Discourse.getURL('/images/emoji/' + set + '/' + code + '.png');
  }

  if(url && url[0] !== 'h' && Discourse.CDN) {
    url = Discourse.CDN + url;
  }

  if(url){
    url = url + "?v=" + Discourse.Emoji.ImageVersion;
  }

  return url;
};

Discourse.Emoji.exists = function(code){
  code = code.toLowerCase();
  return !!(extendedEmoji.hasOwnProperty(code) || emojiHash.hasOwnProperty(code));
};

function imageFor(code) {
  code = code.toLowerCase();
  var url = urlFor(code);
  if (url) {
    var code = ':' + code + ':';
    return ['img', { href: url, title: code, 'class': 'emoji', alt: code }];
  }
}

// Also support default emotions
var translations = {
  ':)'   : 'slight_smile',
  ':-)'  : 'slight_smile',
  ':('   : 'frowning',
  ':-('  : 'frowning',
  ';)'   : 'wink',
  ';-)'  : 'wink',
  ':\'(' : 'cry',
  ':\'-(': 'cry',
  ':-\'(': 'cry',
  ':p'   : 'stuck_out_tongue',
  ':P'   : 'stuck_out_tongue',
  ':-P'  : 'stuck_out_tongue',
  ':O'   : 'open_mouth',
  ':-O'  : 'open_mouth',
  ':D'   : 'smiley',
  ':-D'  : 'smiley',
  ':|'   : 'expressionless',
  ':-|'  : 'expressionless',
  ':/'   : 'confused',
  '8-)'  : 'sunglasses',
  ";P"   : 'stuck_out_tongue_winking_eye',
  ";-P"  : 'stuck_out_tongue_winking_eye',
  ":$"   : 'blush',
  ":-$"  : 'blush'
};

Discourse.Emoji.translations = translations;

function checkPrev(prev) {
  if (prev && prev.length) {
    var lastToken = prev[prev.length-1];
    if (lastToken && lastToken.charAt) {
      var lastChar = lastToken.charAt(lastToken.length-1);
      if (!/\W/.test(lastChar)) return false;
    }
  }
  return true;
}

var translationsWithColon = {};
Object.keys(translations).forEach(function (t) {
  if (t[0] === ':') {
    translationsWithColon[t] = translations[t];
  } else {
    var replacement = translations[t];
    Discourse.Dialect.inlineReplace(t, function (token, match, prev) {
      if (!Discourse.SiteSettings.enable_emoji) { return token; }
      return checkPrev(prev) ? imageFor(replacement) : token;
    });
  }
});

Discourse.Dialect.addPreProcessor(function(text) {
  if (_unicodeReplacements) {
    _unicodeRegexp.lastIndex = 0;

    var m;
    while ((m = _unicodeRegexp.exec(text)) !== null) {

      var replacement = ":" + _unicodeReplacements[m[0]] + ":";

      var before = text.charAt(m.index-1);
      if (!/\B/.test(before)) {
        replacement = "\u200b" + replacement;
      }

      text = text.replace(m[0], replacement);
    }
  }

  return text;
});

function escapeRegExp(s) {
  return s.replace(/[-/\\^$*+?.()|[\]{}]/gi, '\\$&');
}

var translationColonRegexp = new RegExp(Object.keys(translationsWithColon).map(function (t) {
                                           return "(" + escapeRegExp(t) + ")";
                                         }).join("|"));

Discourse.Dialect.registerInline(':', function(text, match, prev) {
  if (!Discourse.SiteSettings.enable_emoji) { return; }

  var endPos = text.indexOf(':', 1),
      firstSpace = text.search(/\s/),
      contents;

  if (!checkPrev(prev)) { return; }

  // If there is no trailing colon, check our translations that begin with colons
  if (endPos === -1 || (firstSpace !== -1 && endPos > firstSpace)) {
    translationColonRegexp.lastIndex = 0;
    var m = translationColonRegexp.exec(text);
    if (m && m[0] && text.indexOf(m[0]) === 0) {
      // Check outer edge
      var lastChar = text.charAt(m[0].length);
      if (lastChar && !/\s/.test(lastChar)) return;
      contents = imageFor(translationsWithColon[m[0]]);
      if (contents) {
        return [m[0].length, contents];
      }
    }
    return;
  }

  // Simple find and replace from our array
  var between = text.slice(1, endPos);
  contents = imageFor(between);
  if (contents) {
    return [endPos+1, contents];
  }
});


var toSearch;
Discourse.Emoji.search = function(term, options) {
  var maxResults = (options && options["maxResults"]) || -1;
  if (maxResults === 0) { return []; }

  toSearch = toSearch || _.union(_.keys(emojiHash), _.keys(extendedEmoji), _.keys(aliasHash)).sort();

  var i, results = [];
  function addResult(term) {
    var val = aliasHash[term] || term;
    if (results.indexOf(val) === -1) {
      results.push(val);
    }
    return maxResults > 0 && results.length >= maxResults;
  }

  var item;
  for (i=0; i<toSearch.length; i++) {
    item = toSearch[i];
    if (item.indexOf(term) === 0 && addResult(item)) {
      return results;
    }
  }

  for (i=0; i<toSearch.length; i++) {
    item = toSearch[i];
    if (item.indexOf(term) === 0 && addResult(item)) {
      return results;
    }
  }

  return results;
};

Discourse.Markdown.whiteListTag('img', 'class', 'emoji');


// IIFE Wrapped Content Ends

 })(this);
define("discourse/lib/emoji/emoji-groups", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // note that these categories are copied from Slack
    // be careful, there are ~20 differences in synonyms, e.g. :boom: vs. :collision:
    // a few Emoji are actually missing from the Slack categories as well (?), and were added
    var groups = [{
      name: "people",
      fullname: "People",
      tabicon: "grinning",
      icons: ["slight_smile", "grinning", "grin", "joy", "smiley", "smile", "sweat_smile", "laughing", "innocent", "smiling_imp", "imp", "wink", "blush", "relaxed", "yum", "relieved", "heart_eyes", "sunglasses", "smirk", "neutral_face", "expressionless", "unamused", "sweat", "pensive", "confused", "confounded", "kissing", "kissing_heart", "kissing_smiling_eyes", "kissing_closed_eyes", "stuck_out_tongue", "stuck_out_tongue_winking_eye", "stuck_out_tongue_closed_eyes", "disappointed", "worried", "angry", "rage", "cry", "persevere", "triumph", "disappointed_relieved", "frowning", "anguished", "fearful", "weary", "sleepy", "tired_face", "grimacing", "sob", "open_mouth", "hushed", "cold_sweat", "scream", "astonished", "flushed", "sleeping", "dizzy_face", "no_mouth", "mask", "smile_cat", "joy_cat", "smiley_cat", "heart_eyes_cat", "smirk_cat", "kissing_cat", "pouting_cat", "crying_cat_face", "scream_cat", "footprints", "bust_in_silhouette", "busts_in_silhouette", "baby", "boy", "girl", "man", "woman", "family", "couple", "two_men_holding_hands", "two_women_holding_hands", "dancers", "bride_with_veil", "person_with_blond_hair", "man_with_gua_pi_mao", "man_with_turban", "older_man", "older_woman", "cop", "construction_worker", "princess", "guardsman", "angel", "santa", "ghost", "japanese_ogre", "japanese_goblin", "hankey", "skull", "alien", "space_invader", "bow", "information_desk_person", "no_good", "ok_woman", "raising_hand", "person_with_pouting_face", "person_frowning", "massage", "haircut", "couple_with_heart", "couplekiss", "raised_hands", "clap", "hand", "ear", "eyes", "nose", "lips", "kiss", "tongue", "nail_care", "wave", "+1", "-1", "point_up", "point_up_2", "point_down", "point_left", "point_right", "ok_hand", "v", "facepunch", "fist", "raised_hand", "muscle", "open_hands", "pray", "anger_right", "eye", "frowning2", "hand_splayed", "head_bandage", "hugging", "middle_finger", "money_mouth", "nerd", "poop", "punch", "robot", "rolling_eyes", "skull_crossbones", "slight_frown", "speaking_head", "spy", "thinking", "thumbsdown", "thumbsup", "upside_down", "urn", "vulcan", "wind_blowing_face", "writing_hand", "zipper_mouth"]
    }, {
      name: "nature",
      fullname: "Nature",
      tabicon: "evergreen_tree",
      icons: ["seedling", "evergreen_tree", "deciduous_tree", "palm_tree", "cactus", "tulip", "cherry_blossom", "rose", "hibiscus", "sunflower", "blossom", "bouquet", "ear_of_rice", "herb", "four_leaf_clover", "maple_leaf", "fallen_leaf", "leaves", "mushroom", "chestnut", "rat", "mouse2", "mouse", "hamster", "ox", "water_buffalo", "cow2", "cow", "tiger2", "leopard", "tiger", "rabbit2", "rabbit", "cat2", "cat", "racehorse", "horse", "ram", "sheep", "goat", "rooster", "chicken", "baby_chick", "hatching_chick", "hatched_chick", "bird", "penguin", "elephant", "dromedary_camel", "camel", "boar", "pig2", "pig", "pig_nose", "dog2", "poodle", "dog", "wolf", "bear", "koala", "panda_face", "monkey_face", "see_no_evil", "hear_no_evil", "speak_no_evil", "monkey", "dragon", "dragon_face", "crocodile", "snake", "turtle", "frog", "whale2", "whale", "dolphin", "octopus", "fish", "tropical_fish", "blowfish", "shell", "snail", "bug", "ant", "bee", "beetle", "feet", "zap", "fire", "crescent_moon", "sunny", "partly_sunny", "cloud", "droplet", "sweat_drops", "umbrella", "dash", "snowflake", "star2", "star", "stars", "sunrise_over_mountains", "sunrise", "rainbow", "ocean", "volcano", "milky_way", "mount_fuji", "japan", "globe_with_meridians", "earth_africa", "earth_americas", "earth_asia", "new_moon", "waxing_crescent_moon", "first_quarter_moon", "moon", "full_moon", "waning_gibbous_moon", "last_quarter_moon", "waning_crescent_moon", "new_moon_with_face", "full_moon_with_face", "first_quarter_moon_with_face", "last_quarter_moon_with_face", "sun_with_face", "chipmunk", "cloud_lightning", "cloud_rain", "cloud_snow", "cloud_tornado", "comet", "crab", "dove", "fog", "lion_face", "scorpion", "spider", "spider_web", "thunder_cloud_rain", "turkey", "unicorn", "waxing_gibbous_moon", "white_sun_cloud", "white_sun_rain_cloud", "white_sun_small_cloud"]
    }, {
      name: "food",
      fullname: "Food & Drink",
      tabicon: "hamburger",
      icons: ["tomato", "eggplant", "corn", "sweet_potato", "grapes", "melon", "watermelon", "tangerine", "lemon", "banana", "pineapple", "apple", "green_apple", "pear", "peach", "cherries", "strawberry", "hamburger", "pizza", "meat_on_bone", "poultry_leg", "rice_cracker", "rice_ball", "rice", "curry", "ramen", "spaghetti", "bread", "fries", "dango", "oden", "sushi", "fried_shrimp", "fish_cake", "icecream", "shaved_ice", "ice_cream", "doughnut", "cookie", "chocolate_bar", "candy", "lollipop", "custard", "honey_pot", "cake", "bento", "stew", "egg", "fork_and_knife", "tea", "coffee", "sake", "wine_glass", "cocktail", "tropical_drink", "beer", "beers", "baby_bottle", "burrito", "champagne", "cheese", "hot_pepper", "hotdog", "taco"]
    }, {
      name: "celebration",
      fullname: "Celebration",
      tabicon: "gift",
      icons: ["ribbon", "gift", "birthday", "jack_o_lantern", "christmas_tree", "tanabata_tree", "bamboo", "rice_scene", "fireworks", "sparkler", "tada", "confetti_ball", "balloon", "dizzy", "sparkles", "boom", "mortar_board", "crown", "dolls", "flags", "wind_chime", "crossed_flags", "izakaya_lantern", "ring", "heart", "broken_heart", "love_letter", "two_hearts", "revolving_hearts", "heartbeat", "heartpulse", "sparkling_heart", "cupid", "gift_heart", "heart_decoration", "purple_heart", "yellow_heart", "green_heart", "blue_heart", "heart_exclamation"]
    }, {
      name: "activity",
      fullname: "Activities",
      tabicon: "soccer",
      icons: ["runner", "walking", "dancer", "rowboat", "swimmer", "surfer", "bath", "snowboarder", "ski", "snowman", "bicyclist", "mountain_bicyclist", "horse_racing", "tent", "fishing_pole_and_fish", "soccer", "basketball", "football", "baseball", "tennis", "rugby_football", "golf", "trophy", "running_shirt_with_sash", "checkered_flag", "musical_keyboard", "guitar", "violin", "saxophone", "trumpet", "musical_note", "notes", "musical_score", "headphones", "microphone", "performing_arts", "ticket", "tophat", "circus_tent", "clapper", "art", "dart", "8ball", "bowling", "slot_machine", "game_die", "video_game", "flower_playing_cards", "black_joker", "mahjong", "carousel_horse", "ferris_wheel", "roller_coaster", "badminton", "ballot_box", "basketball_player", "bow_and_arrow", "cricket", "crossed_swords", "field_hockey", "golfer", "hockey", "ice_skate", "paintbrush", "skier", "snowman2", "stadium", "volleyball"]
    }, {
      name: "travel",
      fullname: "Travel & Places",
      tabicon: "airplane",
      icons: ["train", "mountain_railway", "railway_car", "steam_locomotive", "monorail", "bullettrain_side", "bullettrain_front", "train2", "metro", "light_rail", "station", "tram", "bus", "oncoming_bus", "trolleybus", "minibus", "ambulance", "fire_engine", "police_car", "oncoming_police_car", "rotating_light", "taxi", "oncoming_taxi", "car", "oncoming_automobile", "blue_car", "truck", "articulated_lorry", "tractor", "bike", "busstop", "fuelpump", "construction", "vertical_traffic_light", "traffic_light", "rocket", "helicopter", "airplane", "seat", "anchor", "ship", "speedboat", "boat", "aerial_tramway", "mountain_cableway", "suspension_railway", "passport_control", "customs", "baggage_claim", "left_luggage", "yen", "euro", "pound", "dollar", "statue_of_liberty", "moyai", "foggy", "tokyo_tower", "fountain", "european_castle", "japanese_castle", "city_sunrise", "city_sunset", "night_with_stars", "bridge_at_night", "house", "house_with_garden", "office", "department_store", "factory", "post_office", "european_post_office", "hospital", "bank", "hotel", "love_hotel", "wedding", "church", "convenience_store", "school", "cn", "de", "es", "fr", "gb", "it", "jp", "kr", "ru", "us", "airplane_arriving", "airplane_departure", "airplane_small", "beach", "beach_umbrella", "camping", "city_dusk", "cityscape", "classical_building", "construction_site", "cruise_ship", "desert", "ferry", "flag_black", "flag_cn", "flag_de", "flag_es", "flag_fr", "flag_gb", "flag_it", "flag_jp", "flag_kr", "flag_ru", "flag_us", "flag_white", "hole", "homes", "house_abandoned", "island", "kaaba", "map", "mosque", "motorboat", "motorcycle", "motorway", "mountain", "mountain_snow", "park", "place_of_worship", "race_car", "railway_track", "red_car", "sailboat", "shinto_shrine", "sleeping_accommodation", "synagogue"]
    }, {
      name: "objects",
      fullname: "Objects & Symbols",
      tabicon: "eyeglasses",
      icons: ["watch", "iphone", "calling", "computer", "alarm_clock", "hourglass_flowing_sand", "hourglass", "camera", "video_camera", "movie_camera", "tv", "radio", "pager", "telephone_receiver", "phone", "fax", "minidisc", "floppy_disk", "cd", "dvd", "vhs", "battery", "electric_plug", "bulb", "flashlight", "satellite", "credit_card", "money_with_wings", "moneybag", "gem", "closed_umbrella", "pouch", "purse", "handbag", "briefcase", "school_satchel", "lipstick", "eyeglasses", "womans_hat", "sandal", "high_heel", "boot", "mans_shoe", "athletic_shoe", "bikini", "dress", "kimono", "womans_clothes", "shirt", "necktie", "jeans", "door", "shower", "bathtub", "toilet", "barber", "syringe", "pill", "microscope", "telescope", "crystal_ball", "wrench", "hocho", "nut_and_bolt", "hammer", "bomb", "smoking", "gun", "bookmark", "newspaper", "key", "email", "envelope_with_arrow", "incoming_envelope", "e-mail", "inbox_tray", "outbox_tray", "package", "postal_horn", "postbox", "mailbox_closed", "mailbox", "mailbox_with_mail", "mailbox_with_no_mail", "page_facing_up", "page_with_curl", "bookmark_tabs", "chart_with_upwards_trend", "chart_with_downwards_trend", "bar_chart", "date", "calendar", "low_brightness", "high_brightness", "scroll", "clipboard", "book", "notebook", "notebook_with_decorative_cover", "ledger", "closed_book", "green_book", "blue_book", "orange_book", "books", "card_index", "link", "paperclip", "pushpin", "scissors", "triangular_ruler", "round_pushpin", "straight_ruler", "triangular_flag_on_post", "file_folder", "open_file_folder", "black_nib", "pencil2", "memo", "lock_with_ink_pen", "closed_lock_with_key", "lock", "unlock", "mega", "loudspeaker", "sound", "loud_sound", "speaker", "mute", "zzz", "bell", "no_bell", "thought_balloon", "speech_balloon", "children_crossing", "mag", "mag_right", "no_entry_sign", "no_entry", "name_badge", "no_pedestrians", "do_not_litter", "no_bicycles", "non-potable_water", "no_mobile_phones", "underage", "accept", "ideograph_advantage", "white_flower", "secret", "congratulations", "u5408", "u6e80", "u7981", "u6709", "u7121", "u7533", "u55b6", "u6708", "u5272", "u7a7a", "sa", "koko", "u6307", "chart", "sparkle", "eight_spoked_asterisk", "negative_squared_cross_mark", "white_check_mark", "eight_pointed_black_star", "vibration_mode", "mobile_phone_off", "vs", "a", "b", "ab", "cl", "o2", "sos", "id", "parking", "wc", "cool", "free", "new", "ng", "ok", "up", "atm", "aries", "taurus", "gemini", "cancer", "leo", "virgo", "libra", "scorpius", "sagittarius", "capricorn", "aquarius", "pisces", "restroom", "mens", "womens", "baby_symbol", "wheelchair", "potable_water", "no_smoking", "put_litter_in_its_place", "arrow_forward", "arrow_backward", "arrow_up_small", "arrow_down_small", "fast_forward", "rewind", "arrow_double_up", "arrow_double_down", "arrow_right", "arrow_left", "arrow_up", "arrow_down", "arrow_upper_right", "arrow_lower_right", "arrow_lower_left", "arrow_upper_left", "arrow_up_down", "left_right_arrow", "arrows_counterclockwise", "arrow_right_hook", "leftwards_arrow_with_hook", "arrow_heading_up", "arrow_heading_down", "twisted_rightwards_arrows", "repeat", "repeat_one", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "keycap_ten", "1234", "hash", "abc", "abcd", "capital_abcd", "information_source", "signal_strength", "cinema", "symbols", "heavy_plus_sign", "heavy_minus_sign", "wavy_dash", "heavy_division_sign", "heavy_multiplication_x", "heavy_check_mark", "arrows_clockwise", "tm", "copyright", "registered", "currency_exchange", "heavy_dollar_sign", "curly_loop", "loop", "part_alternation_mark", "exclamation", "bangbang", "question", "grey_exclamation", "grey_question", "interrobang", "x", "o", "100", "end", "back", "on", "top", "soon", "cyclone", "m", "ophiuchus", "six_pointed_star", "beginner", "trident", "warning", "hotsprings", "recycle", "anger", "diamond_shape_with_a_dot_inside", "spades", "clubs", "hearts", "diamonds", "ballot_box_with_check", "white_circle", "black_circle", "radio_button", "red_circle", "large_blue_circle", "small_red_triangle", "small_red_triangle_down", "small_orange_diamond", "small_blue_diamond", "large_orange_diamond", "large_blue_diamond", "black_small_square", "white_small_square", "black_large_square", "white_large_square", "black_medium_square", "white_medium_square", "black_medium_small_square", "white_medium_small_square", "black_square_button", "white_square_button", "clock1", "clock2", "clock3", "clock4", "clock5", "clock6", "clock7", "clock8", "clock9", "clock10", "clock11", "clock12", "clock130", "clock230", "clock330", "clock430", "clock530", "clock630", "clock730", "clock830", "clock930", "clock1030", "clock1130", "clock1230", "alembic", "amphora", "atom", "biohazard", "bed", "bellhop", "calendar_spiral", "camera_with_flash", "candle", "card_box", "chains", "clock", "coffin", "compression", "control_knobs", "couch", "crayon", "cross", "dagger", "dark_sunglasses", "desktop", "dividers", "envelope", "file_cabinet", "film_frames", "fleur-de-lis", "fork_knife_plate", "frame_photo", "gear", "hammer_pick", "helmet_with_cross", "joystick", "key2", "keyboard", "knife", "label", "level_slider", "levitate", "lifter", "medal", "menorah", "metal", "microphone2", "military_medal", "mouse_three_button", "newspaper2", "notepad_spiral", "oil", "om_symbol", "orthodox_cross", "paperclips", "pause_button", "peace", "pen_ballpoint", "pen_fountain", "pencil", "pick", "ping_pong", "play_pause", "popcorn", "prayer_beads", "printer", "projector", "radioactive", "record_button", "reminder_ribbon", "rosette", "satellite_orbital", "scales", "shamrock", "shield", "shopping_bags", "star_and_crescent", "star_of_david", "stop_button", "stopwatch", "telephone", "ten", "thermometer", "thermometer_face", "tickets", "timer", "tools", "track_next", "track_previous", "trackball", "umbrella2", "wastebasket", "wheel_of_dharma", "yin_yang"]
    }];

    // scrub groups
    groups.forEach(function (group) {
      group.icons = group.icons.reject(function (obj) {
        return !Discourse.Emoji.exists(obj);
      });
    });

    // export so others can modify
    Discourse.Emoji.groups = groups;

    __exports__["default"] = groups;
  });
define("discourse/lib/emoji/emoji-toolbar", 
  ["discourse/lib/emoji/emoji-groups","discourse/lib/key-value-store","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var groups = __dependency1__["default"];
    var KeyValueStore = __dependency2__["default"];

    var keyValueStore = new KeyValueStore("discourse_emojis_");
    var EMOJI_USAGE = "emojiUsage";

    var PER_ROW = 12;
    var PER_PAGE = 60;

    var ungroupedIcons = undefined,
        recentlyUsedIcons = undefined;

    if (!keyValueStore.getObject(EMOJI_USAGE)) {
      keyValueStore.setObject({ key: EMOJI_USAGE, value: {} });
    }

    function closeSelector() {
      $('.emoji-modal, .emoji-modal-wrapper').remove();
      $('body, textarea').off('keydown.emoji');
    }

    function initializeUngroupedIcons() {
      var groupedIcons = {};

      groups.forEach(function (group) {
        group.icons.forEach(function (icon) {
          return groupedIcons[icon] = true;
        });
      });

      ungroupedIcons = [];
      var emojis = Discourse.Emoji.list();
      emojis.forEach(function (emoji) {
        if (groupedIcons[emoji] !== true) {
          ungroupedIcons.push(emoji);
        }
      });

      if (ungroupedIcons.length) {
        groups.push({ name: 'ungrouped', icons: ungroupedIcons });
      }
    }

    function trackEmojiUsage(title) {
      var recent = keyValueStore.getObject(EMOJI_USAGE) || {};

      if (!recent[title]) {
        recent[title] = { title: title, usage: 0 };
      }
      recent[title]["usage"]++;

      keyValueStore.setObject({ key: EMOJI_USAGE, value: recent });

      // clear the cache
      recentlyUsedIcons = null;
    }

    function sortByUsage(a, b) {
      if (a.usage > b.usage) {
        return -1;
      }
      if (b.usage > a.usage) {
        return 1;
      }
      return a.title.localeCompare(b.title);
    }

    function initializeRecentlyUsedIcons() {
      recentlyUsedIcons = [];

      var usage = _.map(keyValueStore.getObject(EMOJI_USAGE)).sort(sortByUsage);
      var recent = usage.slice(0, PER_ROW);

      if (recent.length > 0) {

        recent.forEach(function (emoji) {
          return recentlyUsedIcons.push(emoji.title);
        });

        var recentGroup = groups.findProperty('name', 'recent');
        if (recentGroup) {
          recentGroup.icons = recentlyUsedIcons;
        } else {
          groups.push({ name: 'recent', icons: recentlyUsedIcons });
        }
      }
    }

    function toolbar(selected) {
      if (!ungroupedIcons) {
        initializeUngroupedIcons();
      }
      if (!recentlyUsedIcons) {
        initializeRecentlyUsedIcons();
      }

      return groups.map(function (g, i) {
        var icon = g.tabicon;
        var title = g.fullname;
        if (g.name === "recent") {
          icon = "star";
          title = "Recent";
        } else if (g.name === "ungrouped") {
          icon = g.icons[0];
          title = "Custom";
        }

        return { src: Discourse.Emoji.urlFor(icon),
          title: title,
          groupId: i,
          selected: i === selected };
      });
    }

    function bindEvents(page, offset, options) {
      $('.emoji-page a').click(function (e) {
        var title = $(e.currentTarget).attr('title');
        trackEmojiUsage(title);
        options.onSelect(title);
        closeSelector();
        return false;
      }).hover(function (e) {
        var title = $(e.currentTarget).attr('title');
        var html = "<img src='" + Discourse.Emoji.urlFor(title) + "' class='emoji'> <span>:" + title + ":<span>";
        $('.emoji-modal .info').html(html);
      }, function () {
        return $('.emoji-modal .info').html("");
      });

      $('.emoji-modal .nav .next a').click(function () {
        return render(page, offset + PER_PAGE, options);
      });
      $('.emoji-modal .nav .prev a').click(function () {
        return render(page, offset - PER_PAGE, options);
      });

      $('.emoji-modal .toolbar a').click(function () {
        var p = parseInt($(this).data('group-id'));
        render(p, 0, options);
        return false;
      });
    }

    function render(page, offset, options) {
      keyValueStore.set({ key: "emojiPage", value: page });
      keyValueStore.set({ key: "emojiOffset", value: offset });

      var toolbarItems = toolbar(page);
      var rows = [];
      var row = [];
      var icons = groups[page].icons;
      var max = offset + PER_PAGE;

      for (var i = offset; i < max; i++) {
        if (!icons[i]) {
          break;
        }
        if (row.length === PER_ROW) {
          rows.push(row);
          row = [];
        }
        row.push({ src: Discourse.Emoji.urlFor(icons[i]), title: icons[i] });
      }
      rows.push(row);

      var model = {
        toolbarItems: toolbarItems,
        rows: rows,
        prevDisabled: offset === 0,
        nextDisabled: max + 1 > icons.length
      };

      $('.emoji-modal', options.appendTo).remove();
      var template = options.container.lookup('template:emoji-toolbar.raw');
      options.appendTo.append(template(model));

      bindEvents(page, offset, options);
    }

    function showSelector(options) {
      options = options || {};
      options.appendTo = options.appendTo || $('body');

      options.appendTo.append('<div class="emoji-modal-wrapper"></div>');
      $('.emoji-modal-wrapper').click(function () {
        return closeSelector();
      });

      if (Discourse.Site.currentProp('mobileView')) {
        PER_ROW = 9;
      }
      var page = keyValueStore.getInt("emojiPage", 0);
      var offset = keyValueStore.getInt("emojiOffset", 0);

      render(page, offset, options);

      $('body, textarea').on('keydown.emoji', function (e) {
        if (e.which === 27) {
          closeSelector();
          return false;
        }
      });
    }

    __exports__.showSelector = showSelector;
  });
define("discourse/components/d-editor", 
  ["discourse/lib/load-script","ember-addons/ember-computed-decorators","discourse/lib/emoji/emoji-toolbar","discourse/models/category","discourse/lib/category-hashtags","discourse/lib/tag-hashtags","discourse/lib/category-tag-search","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __exports__) {
    "use strict";
    var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

    var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

    __exports__.addToolbarCallback = addToolbarCallback;
    __exports__.onToolbarCreate = onToolbarCreate;

    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

    /*global Mousetrap:true */

    var loadScript = __dependency1__["default"];
    var computed = __dependency2__.default;
    var on = __dependency2__.on;
    var observes = __dependency2__.observes;
    var showSelector = __dependency3__.showSelector;
    var Category = __dependency4__["default"];
    var categoryHashtagTriggerRule = __dependency5__.categoryHashtagTriggerRule;
    var TAG_HASHTAG_POSTFIX = __dependency6__.TAG_HASHTAG_POSTFIX;
    var searchCategoryTag = __dependency7__.search;
    var SEPARATOR = __dependency5__.SEPARATOR;

    // Our head can be a static string or a function that returns a string
    // based on input (like for numbered lists).
    function getHead(head, prev) {
      if (typeof head === "string") {
        return [head, head.length];
      } else {
        return getHead(head(prev));
      }
    }

    var OP = {
      NONE: 0,
      REMOVED: 1,
      ADDED: 2
    };

    var _createCallbacks = [];

    var Toolbar = (function () {
      function Toolbar(site) {
        _classCallCheck(this, Toolbar);

        this.shortcuts = {};

        this.groups = [{ group: 'fontStyles', buttons: [] }, { group: 'insertions', buttons: [] }, { group: 'extras', buttons: [] }];

        this.addButton({
          trimLeading: true,
          id: 'bold',
          group: 'fontStyles',
          shortcut: 'B',
          perform: function (e) {
            return e.applySurround('**', '**', 'bold_text');
          }
        });

        this.addButton({
          trimLeading: true,
          id: 'italic',
          group: 'fontStyles',
          shortcut: 'I',
          perform: function (e) {
            return e.applySurround('_', '_', 'italic_text');
          }
        });

        this.addButton({ id: 'link', group: 'insertions', shortcut: 'K', action: 'showLinkModal' });

        this.addButton({
          id: 'quote',
          group: 'insertions',
          icon: 'quote-right',
          shortcut: 'Shift+9',
          perform: function (e) {
            return e.applySurround('> ', '', 'code_text');
          }
        });

        this.addButton({
          id: 'code',
          group: 'insertions',
          shortcut: 'Shift+C',
          perform: function (e) {
            if (e.selected.value.indexOf("\n") !== -1) {
              e.applySurround('    ', '', 'code_text');
            } else {
              e.applySurround('`', '`', 'code_text');
            }
          }
        });

        this.addButton({
          id: 'bullet',
          group: 'extras',
          icon: 'list-ul',
          shortcut: 'Shift+8',
          title: 'composer.ulist_title',
          perform: function (e) {
            return e.applyList('* ', 'list_item');
          }
        });

        this.addButton({
          id: 'list',
          group: 'extras',
          icon: 'list-ol',
          shortcut: 'Shift+7',
          title: 'composer.olist_title',
          perform: function (e) {
            return e.applyList(function (i) {
              return !i ? "1. " : parseInt(i) + 1 + '. ';
            }, 'list_item');
          }
        });

        this.addButton({
          id: 'heading',
          group: 'extras',
          icon: 'font',
          shortcut: 'Alt+1',
          perform: function (e) {
            return e.applyList('## ', 'heading_text');
          }
        });

        this.addButton({
          id: 'rule',
          group: 'extras',
          icon: 'minus',
          shortcut: 'Alt+R',
          title: 'composer.hr_title',
          perform: function (e) {
            return e.addText("\n\n----------\n");
          }
        });

        if (site.mobileView) {
          this.groups.push({ group: 'mobileExtras', buttons: [] });

          this.addButton({
            id: 'preview',
            group: 'mobileExtras',
            icon: 'television',
            title: 'composer.hr_preview',
            perform: function (e) {
              return e.preview();
            }
          });
        }

        this.groups[this.groups.length - 1].lastGroup = true;
      }

      _createClass(Toolbar, [{
        key: 'addButton',
        value: function addButton(button) {
          var g = this.groups.findProperty('group', button.group);
          if (!g) {
            throw 'Couldn\'t find toolbar group ' + button.group;
          }

          var createdButton = {
            id: button.id,
            className: button.className || button.id,
            icon: button.icon || button.id,
            action: button.action || 'toolbarButton',
            perform: button.perform || Ember.K,
            trimLeading: button.trimLeading
          };

          if (button.sendAction) {
            createdButton.sendAction = button.sendAction;
          }

          var title = I18n.t(button.title || 'composer.' + button.id + '_title');
          if (button.shortcut) {
            var mac = /Mac|iPod|iPhone|iPad/.test(navigator.platform);
            var mod = mac ? 'Meta' : 'Ctrl';
            var shortcutTitle = mod + '+' + button.shortcut;

            // Mac users are used to glyphs for shortcut keys
            if (mac) {
              shortcutTitle = shortcutTitle.replace('Shift', "\u21E7").replace('Meta', "\u2318").replace('Alt', "\u2325").replace(/\+/g, '');
            } else {
              shortcutTitle = shortcutTitle.replace('Shift', I18n.t('shortcut_modifier_key.shift')).replace('Ctrl', I18n.t('shortcut_modifier_key.ctrl')).replace('Alt', I18n.t('shortcut_modifier_key.alt'));
            }

            createdButton.title = title + ' (' + shortcutTitle + ')';

            this.shortcuts[(mod + '+' + button.shortcut).toLowerCase()] = createdButton;
          } else {
            createdButton.title = title;
          }

          if (button.unshift) {
            g.buttons.unshift(createdButton);
          } else {
            g.buttons.push(createdButton);
          }
        }
      }]);

      return Toolbar;
    })();

    function addToolbarCallback(func) {
      _createCallbacks.push(func);
    }

    function onToolbarCreate(func) {
      console.warn('`onToolbarCreate` is deprecated, use the plugin api instead.');
      addToolbarCallback(func);
    }

    ;

    __exports__["default"] = Ember.Component.extend(_createDecoratedObject([{
      key: 'classNames',
      initializer: function () {
        return ['d-editor'];
      }
    }, {
      key: 'ready',
      initializer: function () {
        return false;
      }
    }, {
      key: 'forcePreview',
      initializer: function () {
        return false;
      }
    }, {
      key: 'insertLinkHidden',
      initializer: function () {
        return true;
      }
    }, {
      key: 'linkUrl',
      initializer: function () {
        return '';
      }
    }, {
      key: 'linkText',
      initializer: function () {
        return '';
      }
    }, {
      key: 'lastSel',
      initializer: function () {
        return null;
      }
    }, {
      key: '_mouseTrap',
      initializer: function () {
        return null;
      }
    }, {
      key: 'placeholderTranslated',
      decorators: [computed('placeholder')],
      value: function (placeholder) {
        if (placeholder) return I18n.t(placeholder);
        return null;
      }
    }, {
      key: '_startUp',
      decorators: [on('didInsertElement')],
      value: function () {
        var _this = this;

        var container = this.get('container'),
            $editorInput = this.$('.d-editor-input');

        this._applyEmojiAutocomplete(container, $editorInput);
        this._applyCategoryHashtagAutocomplete(container, $editorInput);

        loadScript('defer/html-sanitizer-bundle').then(function () {
          return _this.set('ready', true);
        });

        var mouseTrap = Mousetrap(this.$('.d-editor-input')[0]);

        var shortcuts = this.get('toolbar.shortcuts');
        Object.keys(shortcuts).forEach(function (sc) {
          var button = shortcuts[sc];
          mouseTrap.bind(sc, function () {
            _this.send(button.action, button);
            return false;
          });
        });

        // disable clicking on links in the preview
        this.$('.d-editor-preview').on('click.preview', function (e) {
          e.preventDefault();
          return false;
        });

        this.appEvents.on('composer:insert-text', function (text) {
          _this._addText(_this._getSelected(), text);
        });

        this._mouseTrap = mouseTrap;
      }
    }, {
      key: '_shutDown',
      decorators: [on('willDestroyElement')],
      value: function () {
        this.appEvents.off('composer:insert-text');

        var mouseTrap = this._mouseTrap;
        Object.keys(this.get('toolbar.shortcuts')).forEach(function (sc) {
          return mouseTrap.unbind(sc);
        });
        this.$('.d-editor-preview').off('click.preview');
      }
    }, {
      key: 'toolbar',
      decorators: [computed],
      value: function () {
        var toolbar = new Toolbar(this.site);
        _createCallbacks.forEach(function (cb) {
          return cb(toolbar);
        });
        this.sendAction('extraButtons', toolbar);
        return toolbar;
      }
    }, {
      key: '_updatePreview',
      value: function () {
        var _this2 = this;

        if (this._state !== "inDOM") {
          return;
        }

        var value = this.get('value');
        var markdownOptions = this.get('markdownOptions') || {};
        markdownOptions.sanitize = true;

        this.set('preview', Discourse.Dialect.cook(value || "", markdownOptions));
        Ember.run.scheduleOnce('afterRender', function () {
          if (_this2._state !== "inDOM") {
            return;
          }
          var $preview = _this2.$('.d-editor-preview');
          if ($preview.length === 0) return;

          _this2.sendAction('previewUpdated', $preview);
        });
      }
    }, {
      key: '_watchForChanges',
      decorators: [observes('ready', 'value')],
      value: function () {
        if (!this.get('ready')) {
          return;
        }
        Ember.run.debounce(this, this._updatePreview, 30);
      }
    }, {
      key: '_applyCategoryHashtagAutocomplete',
      value: function (container) {
        var template = container.lookup('template:category-tag-autocomplete.raw');
        var siteSettings = this.siteSettings;

        this.$('.d-editor-input').autocomplete({
          template: template,
          key: '#',
          transformComplete: function (obj) {
            if (obj.model) {
              return Category.slugFor(obj.model, SEPARATOR);
            } else {
              return '' + obj.text + TAG_HASHTAG_POSTFIX;
            }
          },
          dataSource: function (term) {
            return searchCategoryTag(term, siteSettings);
          },
          triggerRule: function (textarea, opts) {
            return categoryHashtagTriggerRule(textarea, opts);
          }
        });
      }
    }, {
      key: '_applyEmojiAutocomplete',
      value: function (container, $editorInput) {
        if (!this.siteSettings.enable_emoji) {
          return;
        }

        var template = container.lookup('template:emoji-selector-autocomplete.raw');
        var self = this;

        $editorInput.autocomplete({
          template: template,
          key: ":",
          afterComplete: function (text) {
            self.set('value', text);
          },

          transformComplete: function (v) {
            if (v.code) {
              return v.code + ':';
            } else {
              showSelector({
                appendTo: self.$(),
                container: container,
                onSelect: function (title) {
                  // Remove the previously type characters when a new emoji is selected from the selector.
                  var selected = self._getSelected();
                  var newPre = selected.pre.replace(/:[^:]+$/, ":");
                  var numOfRemovedChars = selected.pre.length - newPre.length;
                  selected.pre = newPre;
                  selected.start -= numOfRemovedChars;
                  selected.end -= numOfRemovedChars;
                  self._addText(selected, title + ':');
                }
              });
              return "";
            }
          },

          dataSource: function (term) {
            return new Ember.RSVP.Promise(function (resolve) {
              var full = ':' + term;
              term = term.toLowerCase();

              if (term === "") {
                return resolve(["slight_smile", "smile", "wink", "sunny", "blush"]);
              }

              if (Discourse.Emoji.translations[full]) {
                return resolve([Discourse.Emoji.translations[full]]);
              }

              var options = Discourse.Emoji.search(term, { maxResults: 5 });

              return resolve(options);
            }).then(function (list) {
              return list.map(function (code) {
                return { code: code, src: Discourse.Emoji.urlFor(code) };
              });
            }).then(function (list) {
              if (list.length) {
                list.push({ label: I18n.t("composer.more_emoji") });
              }
              return list;
            });
          }
        });
      }
    }, {
      key: '_getSelected',
      value: function (trimLeading) {
        if (!this.get('ready')) {
          return;
        }

        var textarea = this.$('textarea.d-editor-input')[0];
        var value = textarea.value;
        var start = textarea.selectionStart;
        var end = textarea.selectionEnd;

        // trim trailing spaces cause **test ** would be invalid
        while (end > start && /\s/.test(value.charAt(end - 1))) {
          end--;
        }

        if (trimLeading) {
          // trim leading spaces cause ** test** would be invalid
          while (end > start && /\s/.test(value.charAt(start))) {
            start++;
          }
        }

        var selVal = value.substring(start, end);
        var pre = value.slice(0, start);
        var post = value.slice(end);

        return { start: start, end: end, value: selVal, pre: pre, post: post };
      }
    }, {
      key: '_selectText',
      value: function (from, length) {
        var _this3 = this;

        Ember.run.scheduleOnce('afterRender', function () {
          var $textarea = _this3.$('textarea.d-editor-input');
          var textarea = $textarea[0];
          var oldScrollPos = $textarea.scrollTop();
          if (!_this3.capabilities.isIOS) {
            $textarea.focus();
          }
          textarea.selectionStart = from;
          textarea.selectionEnd = textarea.selectionStart + length;
          $textarea.scrollTop(oldScrollPos);
        });
      }
    }, {
      key: '_getMultilineContents',

      // perform the same operation over many lines of text
      value: function (lines, head, hval, hlen, tail, tlen) {
        var operation = OP.NONE;

        return lines.map(function (l) {
          if (l.length === 0) {
            return l;
          }

          if (operation !== OP.ADDED && (l.slice(0, hlen) === hval && tlen === 0 || l.slice(-tlen) === tail)) {
            operation = OP.REMOVED;
            if (tlen === 0) {
              var _result = l.slice(hlen);

              var _getHead = getHead(head, hval);

              var _getHead2 = _slicedToArray(_getHead, 2);

              hval = _getHead2[0];
              hlen = _getHead2[1];

              return _result;
            } else if (l.slice(-tlen) === tail) {
              var _result2 = l.slice(hlen, -tlen);

              var _getHead3 = getHead(head, hval);

              var _getHead32 = _slicedToArray(_getHead3, 2);

              hval = _getHead32[0];
              hlen = _getHead32[1];

              return _result2;
            }
          } else if (operation === OP.NONE) {
            operation = OP.ADDED;
          } else if (operation === OP.REMOVED) {
            return l;
          }

          var result = '' + hval + l + tail;

          var _getHead4 = getHead(head, hval);

          var _getHead42 = _slicedToArray(_getHead4, 2);

          hval = _getHead42[0];
          hlen = _getHead42[1];

          return result;
        }).join("\n");
      }
    }, {
      key: '_applySurround',
      value: function (sel, head, tail, exampleKey) {
        var pre = sel.pre;
        var post = sel.post;

        var tlen = tail.length;
        if (sel.start === sel.end) {
          if (tlen === 0) {
            return;
          }

          var _getHead5 = getHead(head);

          var _getHead52 = _slicedToArray(_getHead5, 2);

          var hval = _getHead52[0];
          var hlen = _getHead52[1];

          var example = I18n.t('composer.' + exampleKey);
          this.set('value', '' + pre + hval + example + tail + post);
          this._selectText(pre.length + hlen, example.length);
        } else {
          var lines = sel.value.split("\n");

          var _getHead6 = getHead(head);

          var _getHead62 = _slicedToArray(_getHead6, 2);

          var hval = _getHead62[0];
          var hlen = _getHead62[1];

          if (lines.length === 1 && pre.slice(-tlen) === tail && post.slice(0, hlen) === hval) {
            this.set('value', '' + pre.slice(0, -hlen) + sel.value + post.slice(tlen));
            this._selectText(sel.start - hlen, sel.value.length);
          } else {
            var contents = this._getMultilineContents(lines, head, hval, hlen, tail, tlen);

            this.set('value', '' + pre + contents + post);
            if (lines.length === 1 && tlen > 0) {
              this._selectText(sel.start + hlen, contents.length - hlen - hlen);
            } else {
              this._selectText(sel.start, contents.length);
            }
          }
        }
      }
    }, {
      key: '_applyList',
      value: function (sel, head, exampleKey) {
        if (sel.value.indexOf("\n") !== -1) {
          this._applySurround(sel, head, '', exampleKey);
        } else {
          var _getHead7 = getHead(head);

          var _getHead72 = _slicedToArray(_getHead7, 2);

          var hval = _getHead72[0];
          var hlen = _getHead72[1];

          if (sel.start === sel.end) {
            sel.value = I18n.t('composer.' + exampleKey);
          }

          var trimmedPre = sel.pre.trim();
          var number = sel.value.indexOf(hval) === 0 ? sel.value.slice(hlen) : '' + hval + sel.value;
          var preLines = trimmedPre.length ? trimmedPre + '\n\n' : "";

          var trimmedPost = sel.post.trim();
          var post = trimmedPost.length ? '\n\n' + trimmedPost : trimmedPost;

          this.set('value', '' + preLines + number + post);
          this._selectText(preLines.length, number.length);
        }
      }
    }, {
      key: '_addText',
      value: function (sel, text) {
        var _this4 = this;

        var insert = '' + sel.pre + text;
        this.set('value', '' + insert + sel.post);
        this._selectText(insert.length, 0);
        Ember.run.scheduleOnce("afterRender", function () {
          return _this4.$("textarea.d-editor-input").focus();
        });
      }
    }, {
      key: '_togglePreview',
      value: function () {
        this.toggleProperty('forcePreview');
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          toolbarButton: function (button) {
            var _this5 = this;

            var selected = this._getSelected(button.trimLeading);
            var toolbarEvent = {
              selected: selected,
              applySurround: function (head, tail, exampleKey) {
                return _this5._applySurround(selected, head, tail, exampleKey);
              },
              applyList: function (head, exampleKey) {
                return _this5._applyList(selected, head, exampleKey);
              },
              addText: function (text) {
                return _this5._addText(selected, text);
              },
              preview: function () {
                return _this5._togglePreview();
              }
            };

            if (button.sendAction) {
              return this.sendAction(button.sendAction, toolbarEvent);
            } else {
              button.perform(toolbarEvent);
            }
          },

          hidePreview: function () {
            this.set('forcePreview', false);
          },

          showLinkModal: function () {
            this._lastSel = this._getSelected();
            this.set('insertLinkHidden', false);
          },

          insertLink: function () {
            var origLink = this.get('linkUrl');
            var linkUrl = origLink.indexOf('://') === -1 ? 'http://' + origLink : origLink;
            var sel = this._lastSel;

            if (Ember.isEmpty(linkUrl)) {
              return;
            }

            var linkText = this.get('linkText') || '';
            if (linkText.length) {
              this._addText(sel, '[' + linkText + '](' + linkUrl + ')');
            } else {
              if (sel.value) {
                this._addText(sel, '[' + sel.value + '](' + linkUrl + ')');
              } else {
                this._addText(sel, '[' + origLink + '](' + linkUrl + ')');
                this._selectText(sel.start + 1, origLink.length);
              }
            }

            this.set('linkUrl', '');
            this.set('linkText', '');
          },

          emoji: function () {
            var _this6 = this;

            showSelector({
              appendTo: this.$(),
              container: this.container,
              onSelect: function (title) {
                return _this6._addText(_this6._getSelected(), ':' + title + ':');
              }
            });
          }
        };
      }
    }]));
  });
define("discourse/views/composer", 
  ["discourse/lib/after-transition","discourse/lib/safari-hacks","discourse/components/site-header","ember-addons/ember-computed-decorators","discourse/models/composer","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var afterTransition = __dependency1__["default"];
    var positioningWorkaround = __dependency2__["default"];
    var headerHeight = __dependency3__.headerHeight;
    var computed = __dependency4__.default;
    var on = __dependency4__.on;
    var observes = __dependency4__.observes;
    var Composer = __dependency5__["default"];

    var ComposerView = Ember.View.extend(_createDecoratedObject([{
      key: '_lastKeyTimeout',
      initializer: function () {
        return null;
      }
    }, {
      key: 'elementId',
      initializer: function () {
        return 'reply-control';
      }
    }, {
      key: 'classNameBindings',
      initializer: function () {
        return ['composer.creatingPrivateMessage:private-message', 'composeState', 'composer.loading', 'composer.canEditTitle:edit-title', 'composer.createdPost:created-post', 'composer.creatingTopic:topic'];
      }
    }, {
      key: 'composer',
      initializer: function () {
        return Em.computed.alias('controller.model');
      }
    }, {
      key: 'composeState',
      decorators: [computed('composer.composeState')],
      value: function (composeState) {
        return composeState || Composer.CLOSED;
      }
    }, {
      key: 'movePanels',
      value: function (sizePx) {

        $('#main-outlet').css('padding-bottom', sizePx);

        // signal the progress bar it should move!
        this.appEvents.trigger("composer:resized");
      }
    }, {
      key: 'resize',
      decorators: [observes('composeState', 'composer.action')],
      value: function () {
        var _this = this;

        Ember.run.scheduleOnce('afterRender', function () {
          var h = $('#reply-control').height() || 0;
          _this.movePanels(h + "px");

          // Figure out the size of the fields
          var $fields = _this.$('.composer-fields');
          var fieldPos = $fields.position();
          if (fieldPos) {
            _this.$('.wmd-controls').css('top', $fields.height() + fieldPos.top + 5);
          }

          // get the submit panel height
          var submitPos = _this.$('.submit-panel').position();
          if (submitPos) {
            _this.$('.wmd-controls').css('bottom', h - submitPos.top + 7);
          }
        });
      }
    }, {
      key: 'keyUp',
      value: function () {
        var _this2 = this;

        var controller = this.get('controller');
        controller.checkReplyLength();

        this.get('composer').typing();

        var lastKeyUp = new Date();
        this._lastKeyUp = lastKeyUp;

        // One second from now, check to see if the last key was hit when
        // we recorded it. If it was, the user paused typing.
        Ember.run.cancel(this._lastKeyTimeout);
        this._lastKeyTimeout = Ember.run.later(function () {
          if (lastKeyUp !== _this2._lastKeyUp) {
            return;
          }

          // Search for similar topics if the user pauses typing
          controller.findSimilarTopics();
        }, 1000);
      }
    }, {
      key: 'keyDown',
      value: function (e) {
        if (e.which === 27) {
          this.get('controller').send('hitEsc');
          return false;
        } else if (e.which === 13 && (e.ctrlKey || e.metaKey)) {
          // CTRL+ENTER or CMD+ENTER
          this.get('controller').send('save');
          return false;
        }
      }
    }, {
      key: '_enableResizing',
      decorators: [on('didInsertElement')],
      value: function () {
        var _this3 = this;

        var $replyControl = $('#reply-control');
        var resize = function () {
          return Ember.run(function () {
            return _this3.resize();
          });
        };

        $replyControl.DivResizer({
          resize: resize,
          maxHeight: function (winHeight) {
            return winHeight - headerHeight();
          },
          onDrag: function (sizePx) {
            return _this3.movePanels(sizePx);
          }
        });

        afterTransition($replyControl, resize);
        positioningWorkaround(this.$());
      }
    }, {
      key: 'click',
      value: function () {
        this.get('controller').send('openIfDraft');
      }
    }]));

    RSVP.EventTarget.mixin(ComposerView);
    __exports__["default"] = ComposerView;
  });
define("discourse/lib/show-modal", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = function (name, opts) {
      opts = opts || {};
      var container = Discourse.__container__;

      // We use the container here because modals are like singletons
      // in Discourse. Only one can be shown with a particular state.
      var route = container.lookup('route:application');
      var modalController = route.controllerFor('modal');

      modalController.set('modalClass', null);

      var viewClass = container.lookupFactory('view:' + name);
      var controller = container.lookup('controller:' + name);
      if (viewClass) {
        route.render(name, { into: 'modal', outlet: 'modalBody' });
      } else {
        var templateName = Ember.String.dasherize(name);

        var renderArgs = { into: 'modal', outlet: 'modalBody', view: 'modal-body' };
        if (controller) {
          renderArgs.controller = name;
        }

        route.render('modal/' + templateName, renderArgs);
        if (opts.title) {
          modalController.set('title', I18n.t(opts.title));
        }
      }

      if (controller) {
        var model = opts.model;
        if (model) {
          controller.set('model', model);
        }
        if (controller.onShow) {
          controller.onShow();
        }
        controller.set('flashMessage', null);
      }

      return controller;
    };
  });
define("discourse/lib/screen-track", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

    function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

    // We use this class to track how long posts in a topic are on the screen.
    var PAUSE_UNLESS_SCROLLED = 1000 * 60 * 3;
    var MAX_TRACKING_TIME = 1000 * 60 * 6;
    var ANON_MAX_TOPIC_IDS = 5;

    var getTime = function () {
      return new Date().getTime();
    };

    var _default = (function () {
      function _default(topicTrackingState, siteSettings, session, currentUser) {
        _classCallCheck(this, _default);

        this.topicTrackingState = topicTrackingState;
        this.siteSettings = siteSettings;
        this.session = session;
        this.currentUser = currentUser;
        this.reset();
      }

      _createClass(_default, [{
        key: 'start',
        value: function start(topicId, topicController) {
          var _this = this;

          var currentTopicId = this._topicId;
          if (currentTopicId && currentTopicId !== topicId) {
            this.tick();
            this.flush();
          }

          this.reset();

          // Create an interval timer if we don't have one.
          if (!this._interval) {
            this._interval = setInterval(function () {
              return _this.tick();
            }, 1000);
            $(window).on('scroll.screentrack', function () {
              return _this.scrolled();
            });
          }

          this._topicId = topicId;
          this._topicController = topicController;
        }
      }, {
        key: 'stop',
        value: function stop() {
          // already stopped no need to "extra stop"
          if (!this._topicId) {
            return;
          }

          $(window).off('scroll.screentrack');
          this.tick();
          this.flush();
          this.reset();

          this._topicId = null;
          this._topicController = null;

          if (this._interval) {
            clearInterval(this._interval);
            this._interval = null;
          }
        }
      }, {
        key: 'setOnscreen',
        value: function setOnscreen(onscreen) {
          this._onscreen = onscreen;
        }

        // Reset our timers
      }, {
        key: 'reset',
        value: function reset() {
          var now = getTime();
          this._lastTick = now;
          this._lastScrolled = now;
          this._lastFlush = 0;
          this._timings = {};
          this._totalTimings = {};
          this._topicTime = 0;
          this._onscreen = [];
        }
      }, {
        key: 'scrolled',
        value: function scrolled() {
          this._lastScrolled = getTime();
        }
      }, {
        key: 'registerAnonCallback',
        value: function registerAnonCallback(cb) {
          this._anonCallback = cb;
        }
      }, {
        key: 'flush',
        value: function flush() {
          var _this2 = this;

          var newTimings = {};
          var totalTimings = this._totalTimings;

          var timings = this._timings;
          Object.keys(this._timings).forEach(function (postNumber) {
            var time = timings[postNumber];
            totalTimings[postNumber] = totalTimings[postNumber] || 0;

            if (time > 0 && totalTimings[postNumber] < MAX_TRACKING_TIME) {
              totalTimings[postNumber] += time;
              newTimings[postNumber] = time;
            }
            timings[postNumber] = 0;
          });

          var topicId = parseInt(this._topicId, 10);
          var highestSeen = 0;

          Object.keys(newTimings).forEach(function (postNumber) {
            highestSeen = Math.max(highestSeen, parseInt(postNumber, 10));
          });

          var highestSeenByTopic = this.session.get('highestSeenByTopic');
          if ((highestSeenByTopic[topicId] || 0) < highestSeen) {
            highestSeenByTopic[topicId] = highestSeen;
          }

          this.topicTrackingState.updateSeen(topicId, highestSeen);

          if (!$.isEmptyObject(newTimings)) {
            if (this.currentUser) {
              Discourse.ajax('/topics/timings', {
                data: {
                  timings: newTimings,
                  topic_time: this._topicTime,
                  topic_id: topicId
                },
                cache: false,
                type: 'POST',
                headers: {
                  'X-SILENCE-LOGGER': 'true'
                }
              }).then(function () {
                var controller = _this2._topicController;
                if (controller) {
                  var postNumbers = Object.keys(newTimings).map(function (v) {
                    return parseInt(v, 10);
                  });
                  controller.readPosts(topicId, postNumbers);
                }
              });
            } else if (this._anonCallback) {
              // Anonymous viewer - save to localStorage
              var storage = this.keyValueStore;

              // Save total time
              var existingTime = storage.getInt('anon-topic-time');
              storage.setItem('anon-topic-time', existingTime + this._topicTime);

              // Save unique topic IDs up to a max
              var topicIds = storage.get('anon-topic-ids');
              if (topicIds) {
                topicIds = topicIds.split(',').map(function (e) {
                  return parseInt(e);
                });
              } else {
                topicIds = [];
              }
              if (topicIds.indexOf(topicId) === -1 && topicIds.length < ANON_MAX_TOPIC_IDS) {
                topicIds.push(topicId);
                storage.setItem('anon-topic-ids', topicIds.join(','));
              }

              // Inform the observer
              this._anonCallback();

              // No need to call controller.readPosts()
            }

            this._topicTime = 0;
          }

          this._lastFlush = 0;
        }
      }, {
        key: 'tick',
        value: function tick() {
          var now = new Date().getTime();

          // If the user hasn't scrolled the browser in a long time, stop tracking time read
          var sinceScrolled = now - this._lastScrolled;
          if (sinceScrolled > PAUSE_UNLESS_SCROLLED) {
            return;
          }

          var diff = now - this._lastTick;
          this._lastFlush += diff;
          this._lastTick = now;

          var totalTimings = this._totalTimings;
          var timings = this._timings;
          var nextFlush = this.siteSettings.flush_timings_secs * 1000;

          var rush = Object.keys(timings).some(function (postNumber) {
            return timings[postNumber] > 0 && !totalTimings[postNumber];
          });

          if (this._lastFlush > nextFlush || rush) {
            this.flush();
          }

          // Don't track timings if we're not in focus
          if (!Discourse.get("hasFocus")) return;

          this._topicTime += diff;

          this._onscreen.forEach(function (postNumber) {
            return timings[postNumber] = (timings[postNumber] || 0) + diff;
          });
        }
      }]);

      return _default;
    })();

    __exports__["default"] = _default;
  });
define("discourse/routes/discourse", 
  ["discourse/models/composer","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.cleanDOM = cleanDOM;
    var Composer = __dependency1__["default"];

    var DiscourseRoute = Ember.Route.extend({

      // Set to true to refresh a model without a transition if a query param
      // changes
      resfreshQueryWithoutTransition: false,

      refresh: function () {
        var _this = this;

        if (!this.refreshQueryWithoutTransition) {
          return this._super();
        }

        if (!this.router.router.activeTransition) {
          (function () {
            var controller = _this.controller,
                model = controller.get('model'),
                params = _this.controller.getProperties(Object.keys(_this.queryParams));

            model.set('loading', true);
            _this.model(params).then(function (m) {
              return _this.setupController(controller, m);
            });
          })();
        }
      },

      _refreshTitleOnce: function () {
        this.send('_collectTitleTokens', []);
      },

      actions: {

        _collectTitleTokens: function (tokens) {
          // If there's a title token method, call it and get the token
          if (this.titleToken) {
            var t = this.titleToken();
            if (t && t.length) {
              if (t instanceof Array) {
                t.forEach(function (ti) {
                  tokens.push(ti);
                });
              } else {
                tokens.push(t);
              }
            }
          }
          return true;
        },

        refreshTitle: function () {
          Ember.run.once(this, this._refreshTitleOnce);
        }
      },

      redirectIfLoginRequired: function () {
        var app = this.controllerFor('application');
        if (app.get('loginRequired')) {
          this.replaceWith('login');
        }
      },

      openTopicDraft: function (model) {
        // If there's a draft, open the create topic composer
        if (model.draft) {
          var composer = this.controllerFor('composer');
          if (!composer.get('model.viewOpen')) {
            composer.open({
              action: Composer.CREATE_TOPIC,
              draft: model.draft,
              draftKey: model.draft_key,
              draftSequence: model.draft_sequence
            });
          }
        }
      },

      isPoppedState: function (transition) {
        return !transition._discourse_intercepted && !!transition.intent.url;
      }
    });

    function cleanDOM() {
      if (window.MiniProfiler) {
        window.MiniProfiler.pageTransition();
      }

      // Close some elements that may be open
      $('header ul.icons li').removeClass('active');
      $('[data-toggle="dropdown"]').parent().removeClass('open');
      // close the lightbox
      if ($.magnificPopup && $.magnificPopup.instance) {
        $.magnificPopup.instance.close();
        $('body').removeClass('mfp-zoom-out-cur');
      }

      // Remove any link focus
      // NOTE: the '.not("body")' is here to prevent a bug in IE10 on Win7
      // cf. https://stackoverflow.com/questions/5657371
      $(document.activeElement).not("body").not(".no-blur").blur();

      Discourse.set('notifyCount', 0);
      $('#discourse-modal').modal('hide');
      var hideDropDownFunction = $('html').data('hide-dropdown');
      if (hideDropDownFunction) {
        hideDropDownFunction();
      }

      // TODO: Avoid container lookup here
      var appEvents = Discourse.__container__.lookup('app-events:main');
      appEvents.trigger('dom:clean');
    }

    __exports__["default"] = DiscourseRoute;
  });

Discourse.Route = require('discourse/routes/discourse').default;
define("discourse/routes/build-topic-route", 
  ["discourse/controllers/discovery-sortable","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var queryParams = __dependency1__.queryParams;

    // A helper to build a topic route for a filter
    function filterQueryParams(params, defaultParams) {
      var findOpts = defaultParams || {};
      if (params) {
        Object.keys(queryParams).forEach(function (opt) {
          if (params[opt]) {
            findOpts[opt] = params[opt];
          }
        });
      }
      return findOpts;
    }

    function findTopicList(store, tracking, filter, filterParams, extras) {
      extras = extras || {};
      return new Ember.RSVP.Promise(function (resolve) {
        var session = Discourse.Session.current();

        if (extras.cached) {
          var cachedList = session.get('topicList');

          // Try to use the cached version if it exists and is greater than the topics per page
          if (cachedList && cachedList.get('filter') === filter && (cachedList.get('topics.length') || 0) > cachedList.get('per_page') && _.isEqual(cachedList.get('listParams'), filterParams)) {
            cachedList.set('loaded', true);

            if (tracking) {
              tracking.updateTopics(cachedList.get('topics'));
            }
            return resolve(cachedList);
          }
          session.set('topicList', null);
        } else {
          // Clear the cache
          session.setProperties({ topicList: null, topicListScrollPosition: null });
        }

        // Clean up any string parameters that might slip through
        filterParams = filterParams || {};
        Object.keys(filterParams).forEach(function (k) {
          var val = filterParams[k];
          if (val === "undefined" || val === "null" || val === 'false') {
            filterParams[k] = undefined;
          }
        });

        return resolve(store.findFiltered('topicList', { filter: filter, params: filterParams || {} }));
      }).then(function (list) {
        list.set('listParams', filterParams);
        if (tracking) {
          tracking.sync(list, list.filter);
          tracking.trackIncoming(list.filter);
        }
        Discourse.Session.currentProp('topicList', list);
        return list;
      });
    }

    __exports__["default"] = function (filter, extras) {
      extras = extras || {};
      return Discourse.Route.extend({
        queryParams: queryParams,

        beforeModel: function () {
          this.controllerFor('navigation/default').set('filterMode', filter);
        },

        model: function (data, transition) {
          // attempt to stop early cause we need this to be called before .sync
          this.screenTrack.stop();

          var findOpts = filterQueryParams(data),
              findExtras = { cached: this.isPoppedState(transition) };

          return findTopicList(this.store, this.topicTrackingState, filter, findOpts, findExtras);
        },

        titleToken: function () {
          if (filter === Discourse.Utilities.defaultHomepage()) {
            return;
          }

          var filterText = I18n.t('filters.' + filter.replace('/', '.') + '.title');
          return I18n.t('filters.with_topics', { filter: filterText });
        },

        setupController: function (controller, model) {
          var topicOpts = {
            model: model,
            category: null,
            period: model.get('for_period') || (filter.indexOf('/') > 0 ? filter.split('/')[1] : ''),
            selected: [],
            expandGloballyPinned: true
          };

          var params = model.get('params');
          if (params && Object.keys(params).length) {
            if (params.order !== undefined) {
              topicOpts.order = params.order;
            }
            if (params.ascending !== undefined) {
              topicOpts.ascending = params.ascending;
            }
          }
          this.controllerFor('discovery/topics').setProperties(topicOpts);

          this.openTopicDraft(model);
          this.controllerFor('navigation/default').set('canCreateTopic', model.get('can_create_topic'));
        },

        resetController: function (controller, isExiting) {
          if (isExiting) {
            controller.setProperties({ order: "default", ascending: false });
          }
        },

        renderTemplate: function () {
          this.render('navigation/default', { outlet: 'navigation-bar' });
          this.render('discovery/topics', { controller: 'discovery/topics', outlet: 'list-container' });
        }
      }, extras);
    }

    __exports__.filterQueryParams = filterQueryParams;
    __exports__.findTopicList = findTopicList;
  });
define("discourse/routes/restricted-user", 
  ["discourse/routes/discourse","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseRoute = __dependency1__["default"];

    // A base route that allows us to redirect when access is restricted
    __exports__["default"] = DiscourseRoute.extend({

      afterModel: function () {
        if (!this.modelFor('user').get('can_edit')) {
          this.replaceWith('userActivity');
        }
      }

    });
  });
define("discourse/routes/user-topic-list", 
  ["discourse/mixins/viewing-action-type","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ViewingActionType = __dependency1__["default"];

    __exports__["default"] = Discourse.Route.extend(ViewingActionType, {
      renderTemplate: function () {
        this.render('user-topics-list');
      },

      setupController: function (controller, model) {
        var userActionType = this.get('userActionType');
        this.controllerFor('user').set('userActionType', userActionType);
        this.controllerFor('user-activity').set('userActionType', userActionType);
        this.controllerFor('user-topics-list').setProperties({
          model: model,
          hideCategory: false,
          showParticipants: false
        });
      }
    });
  });
define("discourse/routes/user-activity-stream", 
  ["discourse/mixins/viewing-action-type","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ViewingActionType = __dependency1__["default"];

    __exports__["default"] = Discourse.Route.extend(ViewingActionType, {
      model: function () {
        return this.modelFor("user").get("stream");
      },

      afterModel: function () {
        return this.modelFor("user").get("stream").filterBy(this.get("userActionType"));
      },

      renderTemplate: function () {
        this.render("user_stream");
      },

      setupController: function (controller, model) {
        controller.set("model", model);
        this.viewingActionType(this.get("userActionType"));
      },

      actions: {

        didTransition: function () {
          this.controllerFor("user-activity")._showFooter();
          return true;
        },

        removeBookmark: function (userAction) {
          var user = this.modelFor("user");
          Discourse.Post.updateBookmark(userAction.get("post_id"), false).then(function () {
            // remove the user action from the stream
            user.get("stream").remove(userAction);
            // update the counts
            user.get("stats").forEach(function (stat) {
              if (stat.get("action_type") === userAction.action_type) {
                stat.decrementProperty("count");
              }
            });
          });
        }

      }
    });
  });
define("discourse/routes/topic-from-params", 
  ["discourse/lib/url","discourse/models/draft","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];
    var Draft = __dependency2__["default"];

    // This route is used for retrieving a topic based on params
    __exports__["default"] = Discourse.Route.extend({

      // Avoid default model hook
      model: function (params) {
        return params;
      },

      setupController: function (controller, params) {
        params = params || {};
        params.track_visit = true;

        var self = this,
            topic = this.modelFor('topic'),
            postStream = topic.get('postStream'),
            topicController = this.controllerFor('topic'),
            topicProgressController = this.controllerFor('topic-progress'),
            composerController = this.controllerFor('composer');

        // I sincerely hope no topic gets this many posts
        if (params.nearPost === "last") {
          params.nearPost = 999999999;
        }

        params.forceLoad = true;

        postStream.refresh(params).then(function () {
          // TODO we are seeing errors where closest post is null and this is exploding
          // we need better handling and logging for this condition.

          // The post we requested might not exist. Let's find the closest post
          var closestPost = postStream.closestPostForPostNumber(params.nearPost || 1),
              closest = closestPost.get('post_number'),
              progress = postStream.progressIndexOfPost(closestPost);

          topicController.setProperties({
            'model.currentPost': closest,
            enteredAt: new Date().getTime().toString()
          });

          topicProgressController.setProperties({
            progressPosition: progress,
            expanded: false
          });

          // Highlight our post after the next render
          Ember.run.scheduleOnce('afterRender', function () {
            self.appEvents.trigger('post:highlight', closest);
          });
          DiscourseURL.jumpToPost(closest);

          if (!Ember.isEmpty(topic.get('draft'))) {
            composerController.open({
              draft: Draft.getLocal(topic.get('draft_key'), topic.get('draft')),
              draftKey: topic.get('draft_key'),
              draftSequence: topic.get('draft_sequence'),
              topic: topic,
              ignoreIfChanged: true
            });
          }
        }).catch(function (e) {
          Ember.warn('Could not view topic', e);
        });
      }

    });
  });
define("discourse/components/text-field", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    __exports__["default"] = Ember.TextField.extend(_createDecoratedObject([{
      key: 'attributeBindings',
      initializer: function () {
        return ['autocorrect', 'autocapitalize', 'autofocus', 'maxLength'];
      }
    }, {
      key: 'placeholder',
      decorators: [computed("placeholderKey")],
      value: function (placeholderKey) {
        return placeholderKey ? I18n.t(placeholderKey) : "";
      }
    }]));
  });
define("discourse/components/visible", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Component.extend({
      visibleChanged: (function () {
        this.rerender();
      }).observes("visible"),

      render: function (buffer) {
        if (this._state !== 'inDOM' && this._state !== 'preRender' && this._state !== 'inBuffer') {
          return;
        }
        if (!this.get("visible")) {
          return;
        }

        return this._super(buffer);
      }
    });
  });
define("discourse/components/conditional-loading-spinner", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Component.extend({
      classNameBindings: ['containerClass', 'condition:visible'],

      containerClass: (function () {
        return this.get('size') === 'small' ? 'inline-spinner' : undefined;
      }).property('size'),

      render: function (buffer) {
        if (this.get('condition')) {
          buffer.push('<div class="spinner ' + this.get('size') + '"}}></div>');
        } else {
          return this._super(buffer);
        }
      },

      _conditionChanged: (function () {
        this.rerender();
      }).observes('condition')
    });
  });
define("discourse/helpers/user-avatar", 
  ["discourse/lib/helpers","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var registerUnbound = __dependency1__.registerUnbound;

    function renderAvatar(user, options) {
      options = options || {};

      if (user) {

        var username = Em.get(user, options.usernamePath || 'username');
        var avatarTemplate = Em.get(user, options.avatarTemplatePath || 'avatar_template');

        if (!username || !avatarTemplate) {
          return '';
        }

        var title = undefined;
        if (!options.ignoreTitle) {
          // first try to get a title
          title = Em.get(user, 'title');
          // if there was no title provided
          if (!title) {
            // try to retrieve a description
            var description = Em.get(user, 'description');
            // if a description has been provided
            if (description && description.length > 0) {
              // preprend the username before the description
              title = username + " - " + description;
            }
          }
        }

        return Discourse.Utilities.avatarImg({
          size: options.imageSize,
          extraClasses: Em.get(user, 'extras') || options.extraClasses,
          title: title || username,
          avatarTemplate: avatarTemplate
        });
      } else {
        return '';
      }
    }

    registerUnbound('avatar', function (user, params) {
      return new Handlebars.SafeString(renderAvatar.call(this, user, params));
    });

    __exports__.renderAvatar = renderAvatar;
  });
define("discourse/helpers/cold-age-class", 
  ["discourse/lib/helpers","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var registerUnbound = __dependency1__.registerUnbound;

    function daysSinceEpoch(dt) {
      // 1000 * 60 * 60 * 24 = days since epoch
      return dt.getTime() / 86400000;
    }

    registerUnbound('cold-age-class', function (dt, params) {
      var className = params['class'] || 'age';

      if (!dt) {
        return className;
      }

      var startDate = params.startDate || new Date();

      // Show heat on age
      var nowDays = daysSinceEpoch(startDate),
          epochDays = daysSinceEpoch(new Date(dt));

      if (nowDays - epochDays > Discourse.SiteSettings.cold_age_days_high) return className + ' coldmap-high';
      if (nowDays - epochDays > Discourse.SiteSettings.cold_age_days_medium) return className + ' coldmap-med';
      if (nowDays - epochDays > Discourse.SiteSettings.cold_age_days_low) return className + ' coldmap-low';

      return className;
    });

    __exports__.daysSinceEpoch = daysSinceEpoch;
  });
define("discourse/helpers/loading-spinner", 
  ["discourse/lib/helpers","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var htmlHelper = __dependency1__.htmlHelper;

    function renderSpinner(cssClass) {
      var html = "<div class='spinner";
      if (cssClass) {
        html += ' ' + cssClass;
      }
      return html + "'></div>";
    }
    var spinnerHTML = renderSpinner();

    __exports__["default"] = htmlHelper(function (params) {
      var hash = params.hash;
      return renderSpinner(hash && hash.size ? hash.size : undefined);
    });

    __exports__.spinnerHTML = spinnerHTML;
    __exports__.renderSpinner = renderSpinner;
  });
define("discourse/helpers/category-link", 
  ["discourse/lib/helpers","discourse/helpers/fa-icon","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.categoryBadgeHTML = categoryBadgeHTML;
    __exports__.categoryLinkHTML = categoryLinkHTML;
    var registerUnbound = __dependency1__.registerUnbound;
    var iconHTML = __dependency2__.iconHTML;

    var get = Em.get,
        escapeExpression = Handlebars.Utils.escapeExpression;

    function categoryStripe(color, classes) {
      var style = color ? "style='background-color: #" + color + ";'" : "";
      return "<span class='" + classes + "' " + style + "></span>";
    }

    /**
      Generates category badge HTML

      @param {Object} category The category to generate the badge for.
      @param {Object} opts
        @param {String}  [opts.url] The url that we want the category badge to link to.
        @param {Boolean} [opts.allowUncategorized] If false, returns an empty string for the uncategorized category.
        @param {Boolean} [opts.link] If false, the category badge will not be a link.
        @param {Boolean} [opts.hideParaent] If true, parent category will be hidden in the badge.
    **/

    function categoryBadgeHTML(category, opts) {
      opts = opts || {};

      if (!category || !opts.allowUncategorized && Em.get(category, 'id') === Discourse.Site.currentProp("uncategorized_category_id") && Discourse.SiteSettings.suppress_uncategorized_badge) return "";

      var description = get(category, 'description_text'),
          restricted = get(category, 'read_restricted'),
          url = opts.url ? opts.url : Discourse.getURL("/c/") + Discourse.Category.slugFor(category),
          href = opts.link === false ? '' : url,
          tagName = opts.link === false || opts.link === "false" ? 'span' : 'a',
          extraClasses = opts.extraClasses ? ' ' + opts.extraClasses : '',
          color = get(category, 'color'),
          html = "",
          parentCat = null;

      if (!opts.hideParent) {
        parentCat = Discourse.Category.findById(get(category, 'parent_category_id'));
      }

      if (parentCat && parentCat !== category) {
        html += categoryStripe(get(parentCat, 'color'), "badge-category-parent-bg");
      }

      html += categoryStripe(color, "badge-category-bg");

      var classNames = "badge-category clear-badge";
      if (restricted) {
        classNames += " restricted";
      }

      var textColor = "#" + get(category, 'text_color');

      html += "<span" + ' style="color: ' + textColor + ';" ' + 'data-drop-close="true" class="' + classNames + '"' + (description ? 'title="' + escapeExpression(description) + '" ' : '') + ">";

      var name = escapeExpression(get(category, 'name'));

      if (restricted) {
        html += iconHTML('lock') + " " + name;
      } else {
        html += name;
      }
      html += "</span>";

      if (href) {
        href = " href='" + href + "' ";
      }

      extraClasses = Discourse.SiteSettings.category_style ? Discourse.SiteSettings.category_style + extraClasses : extraClasses;

      return "<" + tagName + " class='badge-wrapper " + extraClasses + "' " + href + ">" + html + "</" + tagName + ">";
    }

    function categoryLinkHTML(category, options) {
      var categoryOptions = {};

      // TODO: This is a compatibility layer with the old helper structure.
      // Can be removed once we migrate to `registerUnbound` fully
      if (options && options.hash) {
        options = options.hash;
      }

      if (options) {
        if (options.allowUncategorized) {
          categoryOptions.allowUncategorized = true;
        }
        if (options.link !== undefined) {
          categoryOptions.link = options.link;
        }
        if (options.extraClasses) {
          categoryOptions.extraClasses = options.extraClasses;
        }
        if (options.hideParent) {
          categoryOptions.hideParent = true;
        }
      }
      return new Handlebars.SafeString(categoryBadgeHTML(category, categoryOptions));
    }

    registerUnbound('category-link', categoryLinkHTML);
  });
define("discourse/lib/export-result", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.outputExportResult = outputExportResult;

    function outputExportResult(result) {
      if (result.success) {
        bootbox.alert(I18n.t("admin.export_csv.success"));
      } else {
        bootbox.alert(I18n.t("admin.export_csv.failed"));
      }
    }
  });
define("discourse/lib/autosize", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var set = typeof Set === "function" ? new Set() : (function () {
    	var list = [];

    	return {
    		has: function (key) {
    			return Boolean(list.indexOf(key) > -1);
    		},
    		add: function (key) {
    			list.push(key);
    		},
    		delete: function (key) {
    			list.splice(list.indexOf(key), 1);
    		}
    	};
    })();

    function assign(ta) {
    	var _ref = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    	var _ref$setOverflowX = _ref.setOverflowX;
    	var setOverflowX = _ref$setOverflowX === undefined ? true : _ref$setOverflowX;
    	var _ref$setOverflowY = _ref.setOverflowY;
    	var setOverflowY = _ref$setOverflowY === undefined ? true : _ref$setOverflowY;

    	if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || set.has(ta)) return;

    	var heightOffset = null;
    	var overflowY = null;
    	var clientWidth = ta.clientWidth;

    	function init() {
    		var style = window.getComputedStyle(ta, null);

    		overflowY = style.overflowY;

    		if (style.resize === 'vertical') {
    			ta.style.resize = 'none';
    		} else if (style.resize === 'both') {
    			ta.style.resize = 'horizontal';
    		}

    		if (style.boxSizing === 'content-box') {
    			heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
    		} else {
    			heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
    		}
    		// Fix when a textarea is not on document body and heightOffset is Not a Number
    		if (isNaN(heightOffset)) {
    			heightOffset = 0;
    		}

    		update();
    	}

    	function changeOverflow(value) {
    		{
    			// Chrome/Safari-specific fix:
    			// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
    			// made available by removing the scrollbar. The following forces the necessary text reflow.
    			var width = ta.style.width;
    			ta.style.width = '0px';
    			// Force reflow:
    			/* jshint ignore:start */
    			ta.offsetWidth;
    			/* jshint ignore:end */
    			ta.style.width = width;
    		}

    		overflowY = value;

    		if (setOverflowY) {
    			ta.style.overflowY = value;
    		}

    		resize();
    	}

    	function resize() {
    		var htmlTop = window.pageYOffset;
    		var bodyTop = document.body.scrollTop;
    		var originalHeight = ta.style.height;

    		ta.style.height = 'auto';

    		var endHeight = ta.scrollHeight + heightOffset;

    		if (ta.scrollHeight === 0) {
    			// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
    			ta.style.height = originalHeight;
    			return;
    		}

    		ta.style.height = endHeight + 'px';

    		// used to check if an update is actually necessary on window.resize
    		clientWidth = ta.clientWidth;

    		// prevents scroll-position jumping
    		document.documentElement.scrollTop = htmlTop;
    		document.body.scrollTop = bodyTop;
    	}

    	function update() {
    		var startHeight = ta.style.height;

    		resize();

    		var style = window.getComputedStyle(ta, null);

    		if (style.height !== ta.style.height) {
    			if (overflowY !== 'visible') {
    				changeOverflow('visible');
    			}
    		} else {
    			if (overflowY !== 'hidden') {
    				changeOverflow('hidden');
    			}
    		}

    		if (startHeight !== ta.style.height) {
    			var evt = document.createEvent('Event');
    			evt.initEvent('autosize:resized', true, false);
    			ta.dispatchEvent(evt);
    		}
    	}

    	var pageResize = function () {
    		if (ta.clientWidth !== clientWidth) {
    			update();
    		}
    	};

    	var destroy = (function (style) {
    		window.removeEventListener('resize', pageResize, false);
    		ta.removeEventListener('input', update, false);
    		ta.removeEventListener('keyup', update, false);
    		ta.removeEventListener('autosize:destroy', destroy, false);
    		ta.removeEventListener('autosize:update', update, false);
    		set.delete(ta);

    		Object.keys(style).forEach(function (key) {
    			ta.style[key] = style[key];
    		});
    	}).bind(ta, {
    		height: ta.style.height,
    		resize: ta.style.resize,
    		overflowY: ta.style.overflowY,
    		overflowX: ta.style.overflowX,
    		wordWrap: ta.style.wordWrap
    	});

    	ta.addEventListener('autosize:destroy', destroy, false);

    	// IE9 does not fire onpropertychange or oninput for deletions,
    	// so binding to onkeyup to catch most of those events.
    	// There is no way that I know of to detect something like 'cut' in IE9.
    	if ('onpropertychange' in ta && 'oninput' in ta) {
    		ta.addEventListener('keyup', update, false);
    	}

    	window.addEventListener('resize', pageResize, false);
    	ta.addEventListener('input', update, false);
    	ta.addEventListener('autosize:update', update, false);
    	set.add(ta);

    	if (setOverflowX) {
    		ta.style.overflowX = 'hidden';
    		ta.style.wordWrap = 'break-word';
    	}

    	init();
    }

    function exportDestroy(ta) {
    	if (!(ta && ta.nodeName && ta.nodeName === 'TEXTAREA')) return;
    	var evt = document.createEvent('Event');
    	evt.initEvent('autosize:destroy', true, false);
    	ta.dispatchEvent(evt);
    }

    function exportUpdate(ta) {
    	if (!(ta && ta.nodeName && ta.nodeName === 'TEXTAREA')) return;
    	var evt = document.createEvent('Event');
    	evt.initEvent('autosize:update', true, false);
    	ta.dispatchEvent(evt);
    }

    var autosize = function (el, options) {
    	if (el) {
    		Array.prototype.forEach.call(el.length ? el : [el], function (x) {
    			return assign(x, options);
    		});
    	}
    	return el;
    };
    autosize.destroy = function (el) {
    	if (el) {
    		Array.prototype.forEach.call(el.length ? el : [el], exportDestroy);
    	}
    	return el;
    };
    autosize.update = function (el) {
    	if (el) {
    		Array.prototype.forEach.call(el.length ? el : [el], exportUpdate);
    	}
    	return el;
    };

    __exports__["default"] = autosize;
  });
define("discourse/lib/binary-search", 
  ["exports"],
  function(__exports__) {
    "use strict";


    __exports__["default"] = binarySearch;
    // The binarySearch() function is licensed under the UNLICENSE
    // https://github.com/Olical/binary-search

    // Modified for use in Discourse

    function binarySearch(list, target, keyProp) {
      var min = 0;
      var max = list.length - 1;
      var guess;
      var keyProperty = keyProp || "id";

      while (min <= max) {
        guess = Math.floor((min + max) / 2);

        if (Em.get(list[guess], keyProperty) === target) {
          return guess;
        } else {
          if (Em.get(list[guess], keyProperty) < target) {
            min = guess + 1;
          } else {
            max = guess - 1;
          }
        }
      }

      return -Math.floor((min + max) / 2);
    }
  });
define("discourse/lib/category-hashtags", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.replaceSpan = replaceSpan;
    __exports__.categoryHashtagTriggerRule = categoryHashtagTriggerRule;
    var SEPARATOR = ":";

    __exports__.SEPARATOR = SEPARATOR;

    function replaceSpan($elem, categorySlug, categoryLink) {
      $elem.replaceWith("<a href=\"" + categoryLink + "\" class=\"hashtag\">#<span>" + categorySlug + "</span></a>");
    }

    ;

    function categoryHashtagTriggerRule(textarea, opts) {
      var result = Discourse.Utilities.caretRowCol(textarea);
      var row = result.rowNum;
      var col = result.colNum;
      var line = textarea.value.split("\n")[row - 1];

      if (opts && opts.backSpace) {
        col = col - 1;
        line = line.slice(0, line.length - 1);

        // Don't trigger autocomplete when backspacing into a `#category |` => `#category|`
        if (/^#{1}\w+/.test(line)) return false;
      }

      if (col < 6) {
        // Don't trigger autocomplete when ATX-style headers are used
        return line.slice(0, col) !== "#".repeat(col);
      } else {
        return true;
      }
    }
  });
define("discourse/lib/category-tag-search", 
  ["discourse/lib/autocomplete","discourse/models/category","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.search = search;
    var CANCELLED_STATUS = __dependency1__.CANCELLED_STATUS;
    var Category = __dependency2__["default"];

    var cache = {};
    var cacheTime;
    var oldSearch;

    function updateCache(term, results) {
      cache[term] = results;
      cacheTime = new Date();
      return results;
    }

    function searchTags(term, categories, limit) {
      return new Ember.RSVP.Promise(function (resolve) {
        var clearPromise = setTimeout(function () {
          resolve(CANCELLED_STATUS);
        }, 5000);

        var debouncedSearch = _.debounce(function (q, cats, resultFunc) {
          oldSearch = $.ajax(Discourse.getURL("/tags/filter/search"), {
            type: 'GET',
            cache: true,
            data: { limit: limit, q: q }
          });

          var returnVal = CANCELLED_STATUS;

          oldSearch.then(function (r) {
            var tags = r.results.map(function (tag) {
              return { text: tag.text, count: tag.count };
            });
            returnVal = cats.concat(tags);
          }).always(function () {
            oldSearch = null;
            resultFunc(returnVal);
          });
        }, 300);

        debouncedSearch(term, categories, function (result) {
          clearTimeout(clearPromise);
          resolve(updateCache(term, result));
        });
      });
    };

    function search(term, siteSettings) {
      if (oldSearch) {
        oldSearch.abort();
        oldSearch = null;
      }

      if (new Date() - cacheTime > 30000) cache = {};
      var cached = cache[term];
      if (cached) return cached;

      var limit = 5;
      var categories = Category.search(term, { limit: limit });
      var numOfCategories = categories.length;
      categories = categories.map(function (category) {
        return { model: category };
      });

      if (numOfCategories !== limit && siteSettings.tagging_enabled) {
        return searchTags(term, categories, limit - numOfCategories);
      } else {
        return updateCache(term, categories);
      }
    }

    ;
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

Discourse.CensoredWords = {
  censor: function(text) {
    var censorRegexp,
        censored = Discourse.SiteSettings.censored_words;

    if (censored && censored.length) {
      if (!censorRegexp) {
        var split = censored.split("|");
        if (split && split.length) {
          censorRegexp = new RegExp("\\b(?:" + split.map(function (t) { return "(" + t.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&') + ")"; }).join("|") + ")\\b", "ig");
        }
      }
      if (censorRegexp) {
        var m = censorRegexp.exec(text);
        while (m && m[0]) {
          var replacement = new Array(m[0].length+1).join('&#9632;');
          text = text.replace(new RegExp("\\b" + m[0] + "\\b", "ig"), replacement);
          m = censorRegexp.exec(text);
        }

      }
    }
    return text;
  }
};


// IIFE Wrapped Content Ends

 })(this);
define("discourse/lib/click-track", 
  ["discourse/lib/url","discourse/lib/intercept-click","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.isValidLink = isValidLink;
    var DiscourseURL = __dependency1__["default"];
    var wantsNewWindow = __dependency2__.wantsNewWindow;

    function isValidLink($link) {
      return $link.hasClass("track-link") || $link.closest('.hashtag,.badge-category,.onebox-result,.onebox-body').length === 0;
    }

    ;

    __exports__["default"] = {
      trackClick: function (e) {
        // cancel click if triggered as part of selection.
        if (Discourse.Utilities.selectedText() !== "") {
          return false;
        }

        var $link = $(e.currentTarget);

        // don't track lightboxes, group mentions or links with disabled tracking
        if ($link.hasClass('lightbox') || $link.hasClass('mention-group') || $link.hasClass('no-track-link') || $link.hasClass('hashtag')) {
          return true;
        }

        // don't track links in quotes or in elided part
        if ($link.parents('aside.quote,.elided').length) {
          return true;
        }

        var href = $link.attr('href') || $link.data('href'),
            $article = $link.closest('article,.excerpt,#revisions'),
            postId = $article.data('post-id'),
            topicId = $('#topic').data('topic-id') || $article.data('topic-id'),
            userId = $link.data('user-id');

        if (!href || href.trim().length === 0) {
          return false;
        }
        if (href.indexOf("mailto:") === 0) {
          return true;
        }

        if (!userId) userId = $article.data('user-id');

        var ownLink = userId && userId === Discourse.User.currentProp('id'),
            trackingUrl = Discourse.getURL("/clicks/track?url=" + encodeURIComponent(href));
        if (postId && !$link.data('ignore-post-id')) {
          trackingUrl += "&post_id=" + encodeURI(postId);
        }
        if (topicId) {
          trackingUrl += "&topic_id=" + encodeURI(topicId);
        }

        // Update badge clicks unless it's our own
        if (!ownLink) {
          var $badge = $('span.badge', $link);
          if ($badge.length === 1) {
            // don't update counts in category badge nor in oneboxes (except when we force it)
            if (isValidLink($link)) {
              var html = $badge.html();
              if (/^\d+$/.test(html)) {
                $badge.html(parseInt(html, 10) + 1);
              }
            }
          }
        }

        // If they right clicked, change the destination href
        if (e.which === 3) {
          var destination = Discourse.SiteSettings.track_external_right_clicks ? trackingUrl : href;
          $link.attr('href', destination);
          return true;
        }

        // if they want to open in a new tab, do an AJAX request
        if (wantsNewWindow(e)) {
          Discourse.ajax("/clicks/track", {
            data: {
              url: href,
              post_id: postId,
              topic_id: topicId,
              redirect: false
            },
            dataType: 'html'
          });
          return true;
        }

        e.preventDefault();

        // We don't track clicks on quote back buttons
        if ($link.hasClass('back') || $link.hasClass('quote-other-topic')) {
          return true;
        }

        // Remove the href, put it as a data attribute
        if (!$link.data('href')) {
          $link.addClass('no-href');
          $link.data('href', $link.attr('href'));
          $link.attr('href', null);
          // Don't route to this URL
          $link.data('auto-route', true);
        }

        // restore href
        setTimeout(function () {
          $link.removeClass('no-href');
          $link.attr('href', $link.data('href'));
          $link.data('href', null);
        }, 50);

        // warn the user if they can't download the file
        if (Discourse.SiteSettings.prevent_anons_from_downloading_files && $link.hasClass("attachment") && !Discourse.User.current()) {
          bootbox.alert(I18n.t("post.errors.attachment_download_requires_login"));
          return false;
        }

        // If we're on the same site, use the router and track via AJAX
        if (DiscourseURL.isInternal(href) && !$link.hasClass('attachment')) {
          Discourse.ajax("/clicks/track", {
            data: {
              url: href,
              post_id: postId,
              topic_id: topicId,
              redirect: false
            },
            dataType: 'html'
          });
          DiscourseURL.routeTo(href);
          return false;
        }

        // Otherwise, use a custom URL with a redirect
        if (Discourse.User.currentProp('external_links_in_new_tab')) {
          var win = window.open(trackingUrl, '_blank');
          win.focus();
        } else {
          DiscourseURL.redirectTo(trackingUrl);
        }

        return false;
      }
    };
  });
define("discourse/lib/copy-text", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
     * Copy text to the clipboard. Must be called from within a user gesture (Chrome).
     */

    __exports__["default"] = function (text, element) {
      var supported = false;
      try {
        // Chrome: This only returns true within a user gesture.
        // Chrome: queryCommandEnabled() only returns true if a selection is
        //   present, so we use queryCommandSupported() instead for the fail-fast.
        if (document.queryCommandSupported('copy')) {
          supported = true;
        }
      } catch (e) {
        // Ignore
      }
      if (!supported) {
        return;
      }

      var newRange = document.createRange();
      newRange.selectNode(element);
      var selection = window.getSelection();
      selection.removeAllRanges();
      selection.addRange(newRange);

      try {
        if (document.execCommand("copy")) {
          return true;
        }
      } catch (e) {
        // Ignore
      }
      return false;
    }
  });
define("discourse/lib/decimal-adjust", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // from: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/floor

    __exports__["default"] = function (type, value, exp) {
      // If the exp is undefined or zero...
      if (typeof exp === 'undefined' || +exp === 0) {
        return Math[type](value);
      }
      value = +value;
      exp = +exp;
      // If the value is not a number or the exp is not an integer...
      if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
        return NaN;
      }
      // Shift
      value = value.toString().split('e');
      value = Math[type](+(value[0] + 'e' + (value[1] ? +value[1] - exp : -exp)));
      // Shift back
      value = value.toString().split('e');
      return +(value[0] + 'e' + (value[1] ? +value[1] + exp : exp));
    }
  });
define("discourse/lib/desktop-notifications", 
  ["discourse/lib/url","discourse/lib/key-value-store","discourse/lib/page-tracker","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];
    var KeyValueStore = __dependency2__["default"];
    var onPageChange = __dependency3__.onPageChange;

    var primaryTab = false;
    var liveEnabled = false;
    var havePermission = null;
    var mbClientId = "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx";
    var lastAction = -1;

    var focusTrackerKey = "focus-tracker";
    var idleThresholdTime = 1000 * 10; // 10 seconds

    var context = "discourse_desktop_notifications_";
    var keyValueStore = new KeyValueStore(context);

    // Called from an initializer
    function init(messageBus) {
      liveEnabled = false;
      mbClientId = messageBus.clientId;

      if (!Discourse.User.current()) {
        return;
      }

      try {
        keyValueStore.getItem(focusTrackerKey);
      } catch (e) {
        Em.Logger.info('Discourse desktop notifications are disabled - localStorage denied.');
        return;
      }

      if (!("Notification" in window)) {
        Em.Logger.info('Discourse desktop notifications are disabled - not supported by browser');
        return;
      }

      try {
        if (Notification.permission === "granted") {
          havePermission = true;
        } else if (Notification.permission === "denied") {
          havePermission = false;
          return;
        }
      } catch (e) {
        Em.Logger.warn('Unexpected error, Notification is defined on window but not a responding correctly ' + e);
      }

      liveEnabled = true;
      try {
        // Preliminary checks passed, continue with setup
        setupNotifications();
      } catch (e) {
        Em.Logger.error(e);
      }
    }

    // This function is only called if permission was granted
    function setupNotifications() {

      window.addEventListener("storage", function (e) {
        // note: This event only fires when other tabs setItem()
        var key = e.key;
        if (key !== '' + context + focusTrackerKey) {
          return true;
        }
        primaryTab = false;
      });

      window.addEventListener("focus", function () {
        if (!primaryTab) {
          primaryTab = true;
          keyValueStore.setItem(focusTrackerKey, mbClientId);
        }
      });

      if (document && typeof document.hidden !== "undefined" && document["hidden"]) {
        primaryTab = false;
      } else {
        primaryTab = true;
        keyValueStore.setItem(focusTrackerKey, mbClientId);
      }

      if (document) {
        document.addEventListener("scroll", resetIdle);
      }

      onPageChange(resetIdle);
    }

    function resetIdle() {
      lastAction = Date.now();
    }
    function isIdle() {
      return lastAction + idleThresholdTime < Date.now();
    }

    // Call-in point from message bus
    function onNotification(data) {
      if (!liveEnabled) {
        return;
      }
      if (!primaryTab) {
        return;
      }
      if (!isIdle()) {
        return;
      }
      if (keyValueStore.getItem('notifications-disabled')) {
        return;
      }

      var notificationTitle = I18n.t(i18nKey(data.notification_type), {
        site_title: Discourse.SiteSettings.title,
        topic: data.topic_title,
        username: data.username
      });

      var notificationBody = data.excerpt;
      var notificationIcon = Discourse.SiteSettings.logo_small_url || Discourse.SiteSettings.logo_url;
      var notificationTag = "discourse-notification-" + Discourse.SiteSettings.title + "-" + data.topic_id;

      requestPermission().then(function () {
        // This shows the notification!
        var notification = new Notification(notificationTitle, {
          body: notificationBody,
          icon: notificationIcon,
          tag: notificationTag
        });

        function clickEventHandler() {
          DiscourseURL.routeTo(data.post_url);
          // Cannot delay this until the page renders
          // due to trigger-based permissions
          window.focus();
        }

        notification.addEventListener('click', clickEventHandler);
        setTimeout(function () {
          notification.close();
          notification.removeEventListener('click', clickEventHandler);
        }, 10 * 1000);
      });
    }

    // Utility function
    // Wraps Notification.requestPermission in a Promise
    function requestPermission() {
      if (havePermission === true) {
        return Ember.RSVP.resolve();
      } else if (havePermission === false) {
        return Ember.RSVP.reject();
      } else {
        return new Ember.RSVP.Promise(function (resolve, reject) {
          Notification.requestPermission(function (status) {
            if (status === "granted") {
              resolve();
            } else {
              reject();
            }
          });
        });
      }
    }

    function i18nKey(notification_type) {
      return "notifications.popup." + Discourse.Site.current().get("notificationLookup")[notification_type];
    }

    // Exported for controllers/notification.js.es6

    __exports__.init = init;
    __exports__.onNotification = onNotification;
  });
define("discourse/lib/discourse-location", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
    @module Discourse
    */

    var get = Ember.get,
        set = Ember.set;
    var popstateFired = false;
    var supportsHistoryState = window.history && 'state' in window.history;

    var popstateCallbacks = [];

    /**
      `Ember.DiscourseLocation` implements the location API using the browser's
      `history.pushState` API.

      @class DiscourseLocation
      @namespace Discourse
      @extends Ember.Object
    */
    var DiscourseLocation = Ember.Object.extend({

      init: function () {
        set(this, 'location', get(this, 'location') || window.location);
        this.initState();
      },

      /**
        @private
         Used to set state on first call to setURL
         @method initState
      */
      initState: function () {
        var history = get(this, 'history') || window.history;
        if (history && history.scrollRestoration) {
          history.scrollRestoration = "manual";
        }

        set(this, 'history', history);

        var url = this.formatURL(this.getURL());
        var loc = get(this, 'location');

        if (loc && loc.hash) {
          url += loc.hash;
        }

        this.replaceState(url);
      },

      /**
        Will be pre-pended to path upon state change
         @property rootURL
        @default '/'
      */
      rootURL: '/',

      /**
        @private
         Returns the current `location.pathname` without rootURL
         @method getURL
      */
      getURL: function () {
        var location = get(this, 'location');
        var url = location.pathname;

        url = url.replace(Discourse.BaseUri, '');

        var search = location.search || '';
        url += search;

        return url;
      },

      /**
        @private
         Uses `history.pushState` to update the url without a page reload.
         @method setURL
        @param path {String}
      */
      setURL: function (path) {
        var state = this.getState();
        path = this.formatURL(path);

        if (state && state.path !== path) {
          this.pushState(path);
        }
      },

      /**
        @private
         Uses `history.replaceState` to update the url without a page reload
        or history modification.
         @method replaceURL
        @param path {String}
      */
      replaceURL: function (path) {
        var state = this.getState();
        path = this.formatURL(path);

        if (state && state.path !== path) {
          this.replaceState(path);
        }
      },

      /**
       @private
        Get the current `history.state`
       Polyfill checks for native browser support and falls back to retrieving
       from a private _historyState constiable
        @method getState
      */
      getState: function () {
        return supportsHistoryState ? get(this, 'history').state : this._historyState;
      },

      /**
       @private
        Pushes a new state
        @method pushState
       @param path {String}
      */
      pushState: function (path) {
        var state = { path: path };

        // store state if browser doesn't support `history.state`
        if (!supportsHistoryState) {
          this._historyState = state;
        } else {
          get(this, 'history').pushState(state, null, path);
        }

        // used for webkit workaround
        this._previousURL = this.getURL();
      },

      /**
       @private
        Replaces the current state
        @method replaceState
       @param path {String}
      */
      replaceState: function (path) {
        var state = { path: path };

        // store state if browser doesn't support `history.state`
        if (!supportsHistoryState) {
          this._historyState = state;
        } else {
          get(this, 'history').replaceState(state, null, path);
        }

        // used for webkit workaround
        this._previousURL = this.getURL();
      },

      /**
        @private
         Register a callback to be invoked whenever the browser
        history changes, including using forward and back buttons.
         @method onUpdateURL
        @param callback {Function}
      */
      onUpdateURL: function (callback) {
        var guid = Ember.guidFor(this),
            self = this;

        Ember.$(window).on('popstate.ember-location-' + guid, function () {
          // Ignore initial page load popstate event in Chrome
          if (!popstateFired) {
            popstateFired = true;
            if (self.getURL() === self._previousURL) {
              return;
            }
          }
          var url = self.getURL();
          popstateCallbacks.forEach(function (cb) {
            cb(url);
          });
          callback(url);
        });
      },

      /**
        @private
         Used when using `{{action}}` helper.  The url is always appended to the rootURL.
         @method formatURL
        @param url {String}
      */
      formatURL: function (url) {
        var rootURL = get(this, 'rootURL');

        if (url !== '') {
          rootURL = rootURL.replace(/\/$/, '');

          if (rootURL.length > 0 && url.indexOf(rootURL + "/") === 0) {
            rootURL = "";
          }
        }

        return rootURL + url;
      },

      willDestroy: function () {
        var guid = Ember.guidFor(this);

        Ember.$(window).off('popstate.ember-location-' + guid);
      }

    });

    __exports__["default"] = DiscourseLocation;
  });
define("discourse/lib/highlight-syntax", 
  ["discourse/lib/load-script","exports"],
  function(__dependency1__, __exports__) {
    "use strict";


    __exports__["default"] = highlightSyntax;
    /*global hljs:true */

    var loadScript = __dependency1__["default"];
    function highlightSyntax($elem) {
      var selector = Discourse.SiteSettings.autohighlight_all_code ? 'pre code' : 'pre code[class]',
          path = Discourse.HighlightJSPath;

      if (!path) {
        return;
      }

      $(selector, $elem).each(function (i, e) {
        $(e).removeClass('lang-auto');
        loadScript(path).then(function () {
          return hljs.highlightBlock(e);
        });
      });
    }
  });
define("discourse/lib/intercept-click", 
  ["discourse/lib/url","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.wantsNewWindow = wantsNewWindow;

    __exports__["default"] = interceptClick;
    var DiscourseURL = __dependency1__["default"];

    function wantsNewWindow(e) {
      return e.isDefaultPrevented() || e.shiftKey || e.metaKey || e.ctrlKey || e.button && e.button !== 0;
    }

    /**
      Discourse does some server side rendering of HTML, such as the `cooked` contents of
      posts. The downside of this in an Ember app is the links will not go through the router.
      This jQuery code intercepts clicks on those links and routes them properly.
    **/
    function interceptClick(e) {
      if (wantsNewWindow(e)) {
        return;
      }

      var $currentTarget = $(e.currentTarget),
          href = $currentTarget.attr('href');

      if (!href || href === '#' || $currentTarget.attr('target') || $currentTarget.data('ember-action') || $currentTarget.data('auto-route') || $currentTarget.data('share-url') || $currentTarget.data('user-card') || $currentTarget.hasClass('widget-link') || $currentTarget.hasClass('mention') || !$currentTarget.hasClass('d-link') && $currentTarget.hasClass('ember-view') || $currentTarget.hasClass('lightbox') || href.indexOf("mailto:") === 0 || href.match(/^http[s]?:\/\//i) && !href.match(new RegExp("^http:\\/\\/" + window.location.hostname, "i"))) {
        return;
      }

      e.preventDefault();
      DiscourseURL.routeTo(href);
      return false;
    }
  });
define("discourse/lib/is-element-in-viewport", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = function (element) {
          if (element instanceof jQuery) {
                element = element[0];
          }

          var $window = $(window),
              rect = element.getBoundingClientRect();

          return rect.top >= 0 && rect.left >= 0 && rect.bottom <= $window.height() && rect.right <= $window.width();
    }
  });
define("discourse/lib/keyboard-shortcuts", 
  ["discourse/lib/url","discourse/models/composer","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];
    var Composer = __dependency2__["default"];

    var bindings = {
      '!': { postAction: 'showFlags' },
      '#': { handler: 'toggleProgress', anonymous: true },
      '/': { handler: 'toggleSearch', anonymous: true },
      '=': { handler: 'toggleHamburgerMenu', anonymous: true },
      '?': { handler: 'showHelpModal', anonymous: true },
      '.': { click: '.alert.alert-info.clickable', anonymous: true }, // show incoming/updated topics
      'b': { handler: 'toggleBookmark' },
      'c': { handler: 'createTopic' },
      'ctrl+f': { handler: 'showPageSearch', anonymous: true },
      'command+f': { handler: 'showPageSearch', anonymous: true },
      'd': { postAction: 'deletePost' },
      'e': { postAction: 'editPost' },
      'end': { handler: 'goToLastPost', anonymous: true },
      'f': { handler: 'toggleBookmarkTopic' },
      'g h': { path: '/', anonymous: true },
      'g l': { path: '/latest', anonymous: true },
      'g n': { path: '/new' },
      'g u': { path: '/unread' },
      'g c': { path: '/categories', anonymous: true },
      'g t': { path: '/top', anonymous: true },
      'g b': { path: '/bookmarks' },
      'g p': { path: '/my/activity' },
      'g m': { path: '/my/messages' },
      'home': { handler: 'goToFirstPost', anonymous: true },
      'j': { handler: 'selectDown', anonymous: true },
      'k': { handler: 'selectUp', anonymous: true },
      'l': { click: '.topic-post.selected button.toggle-like' },
      'm m': { click: 'div.notification-options li[data-id="0"] a' }, // mark topic as muted
      'm r': { click: 'div.notification-options li[data-id="1"] a' }, // mark topic as regular
      'm t': { click: 'div.notification-options li[data-id="2"] a' }, // mark topic as tracking
      'm w': { click: 'div.notification-options li[data-id="3"] a' }, // mark topic as watching
      'o,enter': { click: '.topic-list tr.selected a.title', anonymous: true }, // open selected topic
      'p': { handler: 'showCurrentUser' },
      'q': { handler: 'quoteReply' },
      'r': { postAction: 'replyToPost' },
      's': { click: '.topic-post.selected a.post-date', anonymous: true }, // share post
      'shift+j': { handler: 'nextSection', anonymous: true },
      'shift+k': { handler: 'prevSection', anonymous: true },
      'shift+p': { handler: 'pinUnpinTopic' },
      'shift+r': { handler: 'replyToTopic' },
      'shift+s': { click: '#topic-footer-buttons button.share', anonymous: true }, // share topic
      'shift+z shift+z': { handler: 'logout' },
      't': { postAction: 'replyAsNewTopic' },
      'u': { handler: 'goBack', anonymous: true },
      'x r': { click: '#dismiss-new,#dismiss-new-top,#dismiss-posts,#dismiss-posts-top' }, // dismiss new/posts
      'x t': { click: '#dismiss-topics,#dismiss-topics-top' } // dismiss topics
    };

    __exports__["default"] = {
      bindEvents: function (keyTrapper, container) {
        var _this = this;

        this.keyTrapper = keyTrapper;
        this.container = container;
        this._stopCallback();

        this.searchService = this.container.lookup('search-service:main');
        this.appEvents = this.container.lookup('app-events:main');
        this.currentUser = this.container.lookup('current-user:main');

        Object.keys(bindings).forEach(function (key) {
          var binding = bindings[key];
          if (!binding.anonymous && !_this.currentUser) {
            return;
          }

          if (binding.path) {
            _this._bindToPath(binding.path, key);
          } else if (binding.handler) {
            _this._bindToFunction(binding.handler, key);
          } else if (binding.postAction) {
            _this._bindToSelectedPost(binding.postAction, key);
          } else if (binding.click) {
            _this._bindToClick(binding.click, key);
          }
        });
      },

      toggleBookmark: function () {
        this.sendToSelectedPost('toggleBookmark');
        this.sendToTopicListItemView('toggleBookmark');
      },

      toggleBookmarkTopic: function () {
        var topic = this.currentTopic();
        // BIG hack, need a cleaner way
        if (topic && $('.posts-wrapper').length > 0) {
          topic.toggleBookmark();
        } else {
          this.sendToTopicListItemView('toggleBookmark');
        }
      },

      logout: function () {
        this.container.lookup('route:application').send('logout');
      },

      quoteReply: function () {
        this.sendToSelectedPost("replyToPost");
        // lazy but should work for now
        setTimeout(function () {
          $('.d-editor .quote').click();
        }, 500);
      },

      goToFirstPost: function () {
        this._jumpTo('jumpTop');
      },

      goToLastPost: function () {
        this._jumpTo('jumpBottom');
      },

      _jumpTo: function (direction) {
        if ($('.container.posts').length) {
          this.container.lookup('controller:topic-progress').send(direction);
        }
      },

      replyToTopic: function () {
        this._replyToPost();
      },

      selectDown: function () {
        this._moveSelection(1);
      },

      selectUp: function () {
        this._moveSelection(-1);
      },

      goBack: function () {
        history.back();
      },

      nextSection: function () {
        this._changeSection(1);
      },

      prevSection: function () {
        this._changeSection(-1);
      },

      showPageSearch: function (event) {
        var _this2 = this;

        Ember.run(function () {
          _this2.appEvents.trigger('header:keyboard-trigger', { type: 'page-search', event: event });
        });
      },

      createTopic: function () {
        this.container.lookup('controller:composer').open({ action: Composer.CREATE_TOPIC, draftKey: Composer.CREATE_TOPIC });
      },

      pinUnpinTopic: function () {
        this.container.lookup('controller:topic').togglePinnedState();
      },

      toggleProgress: function () {
        this.container.lookup('controller:topic-progress').send('toggleExpansion', { highlight: true });
      },

      toggleSearch: function (event) {
        this.appEvents.trigger('header:keyboard-trigger', { type: 'search', event: event });
      },

      toggleHamburgerMenu: function (event) {
        this.appEvents.trigger('header:keyboard-trigger', { type: 'hamburger', event: event });
      },

      showCurrentUser: function (event) {
        this.appEvents.trigger('header:keyboard-trigger', { type: 'user', event: event });
      },

      showHelpModal: function () {
        this.container.lookup('controller:application').send('showKeyboardShortcutsHelp');
      },

      sendToTopicListItemView: function (action) {
        var elem = $('tr.selected.topic-list-item.ember-view')[0];
        if (elem) {
          var view = Ember.View.views[elem.id];
          view.send(action);
        }
      },

      currentTopic: function () {
        var topicController = this.container.lookup('controller:topic');
        if (topicController) {
          var topic = topicController.get('model');
          if (topic) {
            return topic;
          }
        }
      },

      sendToSelectedPost: function (action) {
        var container = this.container;
        // TODO: We should keep track of the post without a CSS class
        var selectedPostId = parseInt($('.topic-post.selected article.boxed').data('post-id'), 10);
        if (selectedPostId) {
          var topicController = container.lookup('controller:topic');
          var post = topicController.get('model.postStream.posts').findBy('id', selectedPostId);
          if (post) {
            // TODO: Use ember closure actions
            var actionMethod = topicController._actions[action];
            if (!actionMethod) {
              var topicRoute = container.lookup('route:topic');
              actionMethod = topicRoute._actions[action];
            }

            var result = actionMethod.call(topicController, post);
            if (result && result.then) {
              this.appEvents.trigger('post-stream:refresh', { id: selectedPostId });
            }
          }
        }
      },

      _bindToSelectedPost: function (action, binding) {
        var _this3 = this;

        this.keyTrapper.bind(binding, function () {
          return _this3.sendToSelectedPost(action);
        });
      },

      _bindToPath: function (path, key) {
        this.keyTrapper.bind(key, function () {
          return DiscourseURL.routeTo(path);
        });
      },

      _bindToClick: function (selector, binding) {
        binding = binding.split(',');
        this.keyTrapper.bind(binding, function (e) {
          var $sel = $(selector);

          // Special case: We're binding to enter.
          if (e && e.keyCode === 13) {
            // Binding to enter should only be effective when there is something
            // to select.
            if ($sel.length === 0) {
              return;
            }

            // If effective, prevent default.
            e.preventDefault();
          }
          $sel.click();
        });
      },

      _bindToFunction: function (func, binding) {
        if (typeof this[func] === 'function') {
          this.keyTrapper.bind(binding, _.bind(this[func], this));
        }
      },

      _moveSelection: function (direction) {
        var $articles = this._findArticles();

        if (typeof $articles === 'undefined') {
          return;
        }

        var $selected = $articles.filter('.selected');
        var index = $articles.index($selected);

        if ($selected.length !== 0) {
          //boundries check
          // loop is not allowed
          if (direction === -1 && index === 0) {
            return;
          }
          if (direction === 1 && index === $articles.size() - 1) {
            return;
          }
        }

        // if nothing is selected go to the first post on screen
        if ($selected.length === 0) {
          (function () {
            var scrollTop = $(document).scrollTop();

            index = 0;
            $articles.each(function () {
              var top = $(this).position().top;
              if (top >= scrollTop) {
                return false;
              }
              index += 1;
            });

            if (index >= $articles.length) {
              index = $articles.length - 1;
            }

            direction = 0;
          })();
        }

        var $article = $articles.eq(index + direction);

        if ($article.size() > 0) {

          $articles.removeClass('selected');
          $article.addClass('selected');

          if ($article.is('.topic-post')) {
            $('a.tabLoc', $article).focus();
          }

          this._scrollList($article, direction);
        }
      },

      _scrollList: function ($article) {
        // Try to keep the article on screen
        var pos = $article.offset();
        var height = $article.height();
        var headerHeight = $('header.d-header').height();
        var scrollTop = $(window).scrollTop();
        var windowHeight = $(window).height();

        // skip if completely on screen
        if (pos.top - headerHeight > scrollTop && pos.top + height < scrollTop + windowHeight) {
          return;
        }

        var scrollPos = pos.top + height / 2 - windowHeight * 0.5;
        if (height > windowHeight - headerHeight) {
          scrollPos = pos.top - headerHeight;
        }
        if (scrollPos < 0) {
          scrollPos = 0;
        }

        if (this._scrollAnimation) {
          this._scrollAnimation.stop();
        }
        this._scrollAnimation = $("html, body").animate({ scrollTop: scrollPos + "px" }, 100);
      },

      _findArticles: function () {
        var $topicList = $('.topic-list'),
            $topicArea = $('.posts-wrapper');

        if ($topicArea.size() > 0) {
          return $('.posts-wrapper .topic-post, .topic-list tbody tr');
        } else if ($topicList.size() > 0) {
          return $topicList.find('.topic-list-item');
        }
      },

      _changeSection: function (direction) {
        var $sections = $('.nav.nav-pills li'),
            active = $('.nav.nav-pills li.active'),
            index = $sections.index(active) + direction;

        if (index >= 0 && index < $sections.length) {
          $sections.eq(index).find('a').click();
        }
      },

      _stopCallback: function () {
        var oldStopCallback = this.keyTrapper.prototype.stopCallback;

        this.keyTrapper.prototype.stopCallback = function (e, element, combo, sequence) {
          if ((combo === 'ctrl+f' || combo === 'command+f') && element.id === 'search-term') {
            return false;
          }
          return oldStopCallback.call(this, e, element, combo, sequence);
        };
      },

      _replyToPost: function () {
        this.container.lookup('controller:topic').send('replyToPost');
      }
    };
  });
define("discourse/lib/lightbox", 
  ["discourse/lib/load-script","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var loadScript = __dependency1__["default"];

    __exports__["default"] = function ($elem) {
      $("a.lightbox", $elem).each(function (i, e) {
        loadScript("/javascripts/jquery.magnific-popup-min.js").then(function () {
          var $e = $(e);
          // do not lightbox spoiled images
          if ($e.parents(".spoiler").length > 0 || $e.parents(".spoiled").length > 0) {
            return;
          }

          $e.magnificPopup({
            type: "image",
            closeOnContentClick: false,
            removalDelay: 300,
            mainClass: "mfp-zoom-in",

            callbacks: {
              open: function () {
                var wrap = this.wrap,
                    img = this.currItem.img,
                    maxHeight = img.css("max-height");

                wrap.on("click.pinhandler", "img", function () {
                  wrap.toggleClass("mfp-force-scrollbars");
                  img.css("max-height", wrap.hasClass("mfp-force-scrollbars") ? "none" : maxHeight);
                });
              },
              beforeClose: function () {
                this.wrap.off("click.pinhandler");
                this.wrap.removeClass("mfp-force-scrollbars");
              }
            },

            image: {
              titleSrc: function (item) {
                var href = item.el.data("download-href") || item.src;
                var src = [item.el.attr("title"), $("span.informations", item.el).text().replace('x', '&times;')];
                if (!Discourse.SiteSettings.prevent_anons_from_downloading_files || Discourse.User.current()) {
                  src.push('<a class="image-source-link" href="' + href + '">' + I18n.t("lightbox.download") + '</a>');
                }
                return src.join(' &middot; ');
              }
            }

          });
        });
      });
    }
  });
define("discourse/lib/link-category-hashtags", 
  ["discourse/lib/category-hashtags","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.linkSeenCategoryHashtags = linkSeenCategoryHashtags;
    __exports__.fetchUnseenCategoryHashtags = fetchUnseenCategoryHashtags;
    var replaceSpan = __dependency1__.replaceSpan;

    var validCategoryHashtags = {};
    var checkedCategoryHashtags = [];
    var testedKey = 'tested';
    var testedClass = 'hashtag-' + testedKey;

    function updateFound($hashtags, categorySlugs) {
      Ember.run.schedule('afterRender', function () {
        $hashtags.each(function (index, hashtag) {
          var categorySlug = categorySlugs[index];
          var link = validCategoryHashtags[categorySlug];
          var $hashtag = $(hashtag);

          if (link) {
            replaceSpan($hashtag, categorySlug, link);
          } else if (checkedCategoryHashtags.indexOf(categorySlug) !== -1) {
            $hashtag.addClass(testedClass);
          }
        });
      });
    };

    function linkSeenCategoryHashtags($elem) {
      var $hashtags = $('span.hashtag:not(.' + testedClass + ')', $elem);
      var unseen = [];

      if ($hashtags.length) {
        var categorySlugs = $hashtags.map(function (_, hashtag) {
          return $(hashtag).text().substr(1);
        });
        if (categorySlugs.length) {
          _.uniq(categorySlugs).forEach(function (categorySlug) {
            if (checkedCategoryHashtags.indexOf(categorySlug) === -1) {
              unseen.push(categorySlug);
            }
          });
        }
        updateFound($hashtags, categorySlugs);
      }

      return unseen;
    }

    ;

    function fetchUnseenCategoryHashtags(categorySlugs) {
      return Discourse.ajax("/category_hashtags/check", { data: { category_slugs: categorySlugs } }).then(function (response) {
        response.valid.forEach(function (category) {
          validCategoryHashtags[category.slug] = category.url;
        });
        checkedCategoryHashtags.push.apply(checkedCategoryHashtags, categorySlugs);
      });
    }
  });
define("discourse/lib/link-tag-hashtag", 
  ["discourse/lib/category-hashtags","discourse/lib/tag-hashtags","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.linkSeenTagHashtags = linkSeenTagHashtags;
    __exports__.fetchUnseenTagHashtags = fetchUnseenTagHashtags;
    var replaceSpan = __dependency1__.replaceSpan;
    var TAG_HASHTAG_POSTFIX = __dependency2__.TAG_HASHTAG_POSTFIX;

    var validTagHashtags = {};
    var checkedTagHashtags = [];
    var testedClass = 'tag-hashtag-tested';

    function updateFound($hashtags, tagValues) {
      Ember.run.schedule('afterRender', function () {
        $hashtags.each(function (index, hashtag) {
          var tagValue = tagValues[index];
          var link = validTagHashtags[tagValue];
          var $hashtag = $(hashtag);

          if (link) {
            replaceSpan($hashtag, tagValue, link);
          } else if (checkedTagHashtags.indexOf(tagValue) !== -1) {
            $hashtag.addClass(testedClass);
          }
        });
      });
    }

    function linkSeenTagHashtags($elem) {
      var $hashtags = $('span.hashtag:not(.' + testedClass + ')', $elem);
      var unseen = [];

      if ($hashtags.length) {
        var tagValues = $hashtags.map(function (_, hashtag) {
          return $(hashtag).text().substr(1).replace('' + TAG_HASHTAG_POSTFIX, "");
        });

        if (tagValues.length) {
          _.uniq(tagValues).forEach(function (tagValue) {
            if (checkedTagHashtags.indexOf(tagValue) === -1) unseen.push(tagValue);
          });
        }
        updateFound($hashtags, tagValues);
      }

      return unseen;
    }

    ;

    function fetchUnseenTagHashtags(tagValues) {
      return Discourse.ajax("/tags/check", { data: { tag_values: tagValues } }).then(function (response) {
        response.valid.forEach(function (tag) {
          validTagHashtags[tag.value] = tag.url;
        });
        checkedTagHashtags.push.apply(checkedTagHashtags, tagValues);
      });
    }
  });
define("discourse/lib/logout", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = logout;

    function logout(siteSettings, keyValueStore) {
      keyValueStore.abandonLocal();

      var redirect = siteSettings.logout_redirect;
      if (Ember.isEmpty(redirect)) {
        window.location.pathname = Discourse.getURL('/');
      } else {
        window.location.href = redirect;
      }
    }
  });
define("discourse/lib/mobile", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.forceMobile = forceMobile;
    __exports__.resetMobile = resetMobile;
    var mobileForced = false;

    //  An object that is responsible for logic related to mobile devices.
    var Mobile = {
      isMobileDevice: false,
      mobileView: false,

      init: function () {
        var $html = $('html');
        this.isMobileDevice = mobileForced || $html.hasClass('mobile-device');
        this.mobileView = mobileForced || $html.hasClass('mobile-view');

        if (Ember.testing || mobileForced) {
          return;
        }

        try {
          if (window.location.search.match(/mobile_view=1/)) {
            localStorage.mobileView = true;
          }
          if (window.location.search.match(/mobile_view=0/)) {
            localStorage.mobileView = false;
          }
          if (localStorage.mobileView) {
            var savedValue = localStorage.mobileView === 'true';
            if (savedValue !== this.mobileView) {
              this.reloadPage(savedValue);
            }
          }
        } catch (err) {
          // localStorage may be disabled, just skip this
          // you get security errors if it is disabled
        }
      },

      toggleMobileView: function () {
        try {
          if (localStorage) {
            localStorage.mobileView = !this.mobileView;
          }
        } catch (err) {
          // localStorage may be disabled, skip
        }
        this.reloadPage(!this.mobileView);
      },

      reloadPage: function (mobile) {
        window.location.assign(window.location.pathname + '?mobile_view=' + (mobile ? '1' : '0'));
      }
    };

    function forceMobile() {
      mobileForced = true;
    }

    function resetMobile() {
      mobileForced = false;
    }

    // Backwards compatibiltity, deprecated
    Object.defineProperty(Discourse, 'Mobile', {
      get: function () {
        Ember.warn("DEPRECATION: `Discourse.Mobile` is deprecated, use `this.site.mobileView` instead");
        return Mobile;
      }
    });

    __exports__["default"] = Mobile;
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  A helper for looking up oneboxes and displaying them

  For now it only stores in a local Javascript Object, in future we can change it so it uses localStorage
  or some other mechanism.

  @class Onebox
  @namespace Discourse
  @module Discourse
**/

Discourse.Onebox = {

  // The cache is just a JS Object
  localCache: {},

  // A cache of failed URLs
  failedCache: {},

  /**
    Perform a lookup of a onebox based an anchor element. It will insert a loading
    indicator and remove it when the loading is complete or fails.

    @method load
    @param {HTMLElement} e the anchor element whose onebox we want to look up
    @param {Boolean} refresh true if we want to force a refresh of the onebox
  **/
  load: function(e, refresh) {

    var $elem = $(e);

    // If the onebox has loaded, return
    if ($elem.data('onebox-loaded')) return;
    if ($elem.hasClass('loading-onebox')) return;

    var url = e.href;

    // Unless we're forcing a refresh...
    if (!refresh) {
      // If we have it in our cache, return it.
      var cached = this.localCache[url];
      if (cached) return cached;

      // If the request failed, don't do anything
      var failed = this.failedCache[url];
      if (failed) return;
    }

    // Add the loading CSS class
    $elem.addClass('loading-onebox');

    // Retrieve the onebox
    var promise = Discourse.ajax("/onebox", {
      dataType: 'html',
      data: { url: url, refresh: refresh },
      cache: true
    });

    // We can call this when loading is complete
    var loadingFinished = function() {
      $elem.removeClass('loading-onebox');
      $elem.data('onebox-loaded');
    };

    var onebox = this;
    promise.then(function(html) {

      // loaded onebox
      loadingFinished();

      onebox.localCache[url] = html;
      $elem.replaceWith(html);

    }, function() {
      // If the request failed log it as such
      onebox.failedCache[url] = true;
      loadingFinished();
    });

  },

  /**
    Return the cached contents of a Onebox

    @method lookupCache
    @param {String} url the url of the onebox
    @return {String} the cached contents of the onebox or null if not found
  **/
  lookupCache: function(url) {
    return this.localCache[url];
  },

  /**
    Store the contents of a Onebox in our local cache.

    @method cache
    @private
    @param {String} url the url of the onebox we crawled
    @param {String} contents the contents we want to cache
  **/
  cache: function(url, contents) {
    this.localCache[url] = contents;
  }

};




// IIFE Wrapped Content Ends

 })(this);
define("discourse/lib/page-tracker", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.startPageTracking = startPageTracking;
    __exports__.onPageChange = onPageChange;
    var PageTracker = Ember.Object.extend(Ember.Evented);
    var _pageTracker = PageTracker.create();

    var _started = false;

    function startPageTracking(router) {
      if (_started) {
        return;
      }

      router.on('didTransition', function () {
        this.send('refreshTitle');
        var url = Discourse.getURL(this.get('url'));

        // Refreshing the title is debounced, so we need to trigger this in the
        // next runloop to have the correct title.
        Em.run.next(function () {
          _pageTracker.trigger('change', url, Discourse.get('_docTitle'));
        });
      });
      _started = true;
    }

    function onPageChange(fn) {
      _pageTracker.on('change', fn);
    }

    // backwards compatibility
    var BackwardsCompat = {
      current: function () {
        console.warn('Using PageTracker.current() is deprecated. Your plugin should use the PluginAPI');
        return _pageTracker;
      }
    };

    Discourse.PageTracker = BackwardsCompat;
    __exports__["default"] = BackwardsCompat;
  });
define("discourse/lib/plugin-api", 
  ["discourse/helpers/fa-icon","discourse/widgets/post-cooked","discourse/components/composer-editor","discourse/widgets/post-menu","discourse/lib/transform-post","discourse/components/d-editor","discourse/components/mount-widget","discourse/widgets/widget","discourse/lib/page-tracker","discourse/widgets/post-stream","virtual-dom","discourse/components/site-header","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __exports__) {
    "use strict";
    var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

    __exports__.withPluginApi = withPluginApi;
    __exports__.decorateCooked = decorateCooked;

    function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

    var iconNode = __dependency1__.iconNode;
    var addDecorator = __dependency2__.addDecorator;
    var ComposerEditor = __dependency3__["default"];
    var addButton = __dependency4__.addButton;
    var includeAttributes = __dependency5__.includeAttributes;
    var addToolbarCallback = __dependency6__.addToolbarCallback;
    var addWidgetCleanCallback = __dependency7__.addWidgetCleanCallback;
    var _createWidget = __dependency8__.createWidget;
    var _decorateWidget = __dependency8__.decorateWidget;
    var changeSetting = __dependency8__.changeSetting;
    var _onPageChange = __dependency9__.onPageChange;
    var _preventCloak = __dependency10__.preventCloak;
    var h = __dependency11__.h;
    var _addFlagProperty = __dependency12__.addFlagProperty;

    var PluginApi = (function () {
      function PluginApi(version, container) {
        _classCallCheck(this, PluginApi);

        this.version = version;
        this.container = container;
        this._currentUser = container.lookup('current-user:main');
        this.h = h;
      }

      /**
       * Use this function to retrieve the currently logged in user within your plugin.
       * If the user is not logged in, it will be `null`.
      **/

      _createClass(PluginApi, [{
        key: 'getCurrentUser',
        value: function getCurrentUser() {
          return this._currentUser;
        }

        /**
         * Used for decorating the `cooked` content of a post after it is rendered using
         * jQuery.
         *
         * `callback` will be called when it is time to decorate with a jQuery selector.
         *
         * Use `options.onlyStream` if you only want to decorate posts within a topic,
         * and not in other places like the user stream.
         *
         * For example, to add a yellow background to all posts you could do this:
         *
         * ```
         * api.decorateCooked($elem => $elem.css({ backgroundColor: 'yellow' }));
         * ```
         **/
      }, {
        key: 'decorateCooked',
        value: function decorateCooked(callback, opts) {
          opts = opts || {};

          addDecorator(callback);

          if (!opts.onlyStream) {
            decorate(ComposerEditor, 'previewRefreshed', callback);
            decorate(this.container.lookupFactory('component:user-stream'), 'didInsertElement', callback);
          }
        }

        /**
         * addPosterIcon(callback)
         *
         * This function can be used to add an icon with a link that will be displayed
         * beside a poster's name. The `callback` is called with the post's user custom
         * fields and post attrions. An icon will be rendered if the callback returns
         * an object with the appropriate attributes.
         *
         * The returned object can have the following attributes:
         *
         *   icon        the font awesome icon to render
         *   emoji       an emoji icon to render
         *   className   (optional) a css class to apply to the icon
         *   url         (optional) where to link the icon
         *   title       (optional) the tooltip title for the icon on hover
         *
         * ```
         * api.addPosterIcon((cfs, attrs) => {
         *   if (cfs.customer) {
         *     return { icon: 'user', className: 'customer', title: 'customer' };
         *   }
         * });
         * ```
         **/
      }, {
        key: 'addPosterIcon',
        value: function addPosterIcon(cb) {
          var site = this.container.lookup('site:main');
          var loc = site && site.mobileView ? 'before' : 'after';

          _decorateWidget('poster-name:' + loc, function (dec) {
            var attrs = dec.attrs;
            var result = cb(attrs.userCustomFields || {}, attrs);

            if (result) {
              var iconBody = undefined;

              if (result.icon) {
                iconBody = iconNode(result.icon);
              } else if (result.emoji) {
                iconBody = result.emoji.split('|').map(function (emoji) {
                  var src = Discourse.Emoji.urlFor(emoji);
                  return dec.h('img', { className: 'emoji', attributes: { src: src } });
                });

                iconBody = result.emoji.split('|').map(function (name) {
                  return dec.attach('emoji', { name: name });
                });
              }

              if (result.text) {
                iconBody = [iconBody, result.text];
              }

              if (result.url) {
                iconBody = dec.h('a', { attributes: { href: result.url } }, iconBody);
              }

              return dec.h('span.poster-icon', { className: result.className, attributes: { title: result.title } }, iconBody);
            }
          });
        }

        /**
         * The main interface for extending widgets with additional HTML.
         *
         * The `name` you pass it should be the name of the widget and a type
         * for the decorator. All widgets support `before` and `after` types.
         *
         * Example:
         *
         * ```
         * api.decorateWidget('post:after', () => {
         *   return "I am displayed after every post!";
         * });
         * ```
         *
         * Your decorator will be called with an instance of a `DecoratorHelper`
         * object, which provides methods you can use to build more interesting
         * formatting.
         *
         * ```
         * api.decorateWidget('post:after', helper => {
         *   return helper.h('p.fancy', `I'm an HTML paragraph on post with id ${helper.attrs.id}`);
         * });
         *
         * (View the source for `DecoratorHelper` for more helper methods you
         * can use in your plugin decorators.)
         *
         **/
      }, {
        key: 'decorateWidget',
        value: function decorateWidget(name, fn) {
          _decorateWidget(name, fn);
        }

        /**
         * Adds a new action to a widget that already exists. You can use this to
         * add additional functionality from your plugin.
         *
         * Example:
         *
         * ```
         * api.attachWidgetAction('post', 'annoyMe', () => {
         *  alert('ANNOYED!');
         * });
         * ```
         **/
      }, {
        key: 'attachWidgetAction',
        value: function attachWidgetAction(widget, actionName, fn) {
          var widgetClass = this.container.lookupFactory('widget:' + widget);
          widgetClass.prototype[actionName] = fn;
        }

        /**
         * Add more attributes to the Post's `attrs` object passed through to widgets.
         * You'll need to do this if you've added attributes to the serializer for a
         * Post and want to use them when you're rendering.
         *
         * Example:
         *
         * ```
         * // attrs.poster_age and attrs.poster_height will be present
         * api.includePostAttributes('poster_age', 'poster_height');
         * ```
         *
         **/
      }, {
        key: 'includePostAttributes',
        value: function includePostAttributes() {
          includeAttributes.apply(undefined, arguments);
        }

        /**
         * Add a new button below a post with your plugin.
         *
         * The `callback` function will be called whenever the post menu is rendered,
         * and if you return an object with the button details it will be rendered.
         *
         * Example:
         *
         * ```
         * api.addPostMenuButton('coffee', () => {
         *   return {
         *     action: 'drinkCoffee',
         *     icon: 'coffee',
         *     className: 'hot-coffee',
         *     title: 'coffee.title',
         *     position: 'first'  // can be `first`, `last` or `second-last-hidden`
         *   };
         * });
         **/
      }, {
        key: 'addPostMenuButton',
        value: function addPostMenuButton(name, callback) {
          addButton(name, callback);
        }

        /**
         * A hook that is called when the editor toolbar is created. You can
         * use this to add custom editor buttons.
         *
         * Example:
         *
         * ```
         * api.onToolbarCreate(toolbar => {
         *   toolbar.addButton({
         *     id: 'pop-text',
         *     group: 'extras',
         *     icon: 'bolt',
         *     action: 'makeItPop',
         *     title: 'pop_format.title'
         *   });
         * });
         **/
      }, {
        key: 'onToolbarCreate',
        value: function onToolbarCreate(callback) {
          addToolbarCallback(callback);
        }

        /**
         * A hook that is called when the post stream is removed from the DOM.
         * This advanced hook should be used if you end up wiring up any
         * events that need to be torn down when the user leaves the topic
         * page.
         **/
      }, {
        key: 'cleanupStream',
        value: function cleanupStream(fn) {
          addWidgetCleanCallback('post-stream', fn);
        }

        /**
          Called whenever the "page" changes. This allows us to set up analytics
          and other tracking.
           To get notified when the page changes, you can install a hook like so:
           ```javascript
            api.onPageChange((url, title) => {
              console.log('the page changed to: ' + url + ' and title ' + title);
            });
          ```
        **/
      }, {
        key: 'onPageChange',
        value: function onPageChange(fn) {
          _onPageChange(fn);
        }

        /**
         * Changes a setting associated with a widget. For example, if
         * you wanted small avatars in the post stream:
         *
         * ```javascript
         * api.changeWidgetSetting('post-avatar', 'size', 'small');
         * ```
         *
         **/
      }, {
        key: 'changeWidgetSetting',
        value: function changeWidgetSetting(widgetName, settingName, newValue) {
          changeSetting(widgetName, settingName, newValue);
        }

        /**
         * Prevents an element in the post stream from being cloaked.
         * This is useful if you are using a plugin such as youtube
         * and don't want the video removed once it has begun
         * playing.
         *
         * ```javascript
         * api.preventCloak(1234);
         * ```
         **/
      }, {
        key: 'preventCloak',
        value: function preventCloak(postId) {
          _preventCloak(postId);
        }

        /**
         * Exposes the widget creating ability to plugins. Plugins can
         * register their own plugins and attach them with decorators.
         * See `createWidget` in `discourse/widgets/widget` for more info.
         **/
      }, {
        key: 'createWidget',
        value: function createWidget(name, args) {
          return _createWidget(name, args);
        }

        /**
         * Adds a property that can be summed for calculating the flag counter
         **/
      }, {
        key: 'addFlagProperty',
        value: function addFlagProperty(property) {
          return _addFlagProperty(property);
        }
      }]);

      return PluginApi;
    })();

    var _pluginv01 = undefined;
    function getPluginApi(version) {
      version = parseFloat(version);
      if (version <= 0.4) {
        if (!_pluginv01) {
          _pluginv01 = new PluginApi(version, Discourse.__container__);
        }
        return _pluginv01;
      } else {
        console.warn('Plugin API v' + version + ' is not supported');
      }
    }

    /**
     * withPluginApi(version, apiCodeCallback, opts)
     *
     * Helper to version our client side plugin API. Pass the version of the API that your
     * plugin is coded against. If that API is available, the `apiCodeCallback` function will
     * be called with the `PluginApi` object.
    */

    function withPluginApi(version, apiCodeCallback, opts) {
      opts = opts || {};

      var api = getPluginApi(version);
      if (api) {
        return apiCodeCallback(api);
      }
    }

    var _decorateId = 0;
    function decorate(klass, evt, cb) {
      var mixin = {};
      mixin["_decorate_" + _decorateId++] = (function ($elem) {
        cb($elem);
      }).on(evt);
      klass.reopen(mixin);
    }

    function decorateCooked() {
      console.warn('`decorateCooked` has been removed. Use `getPluginApi(version).decorateCooked` instead');
    }
  });
define("discourse/lib/render-tag", 
  ["virtual-dom","exports"],
  function(__dependency1__, __exports__) {
    "use strict";


    __exports__["default"] = renderTag;__exports__.tagNode = tagNode;
    var h = __dependency1__.h;
    function renderTag(tag, params) {
      params = params || {};
      tag = Handlebars.Utils.escapeExpression(tag);
      var classes = ['tag-' + tag, 'discourse-tag'];
      var tagName = params.tagName || "a";
      var href = tagName === "a" ? " href='" + Discourse.getURL("/tags/" + tag) + "' " : "";

      if (Discourse.SiteSettings.tag_style || params.style) {
        classes.push(params.style || Discourse.SiteSettings.tag_style);
      }

      var val = "<" + tagName + href + " class='" + classes.join(" ") + "'>" + tag + "</" + tagName + ">";

      if (params.count) {
        val += " <span class='discourse-tag-count'>x" + params.count + "</span>";
      }

      return val;
    }

    ;

    function tagNode(tag, params) {
      var classes = ['tag-' + tag, 'discourse-tag'];
      var tagName = params.tagName || "a";

      if (Discourse.SiteSettings.tag_style || params.style) {
        classes.push(params.style || Discourse.SiteSettings.tag_style);
      }

      if (tagName === 'a') {
        var href = Discourse.getURL('/tags/' + tag);
        return h(tagName, { className: classes.join(' '), attributes: { href: href } }, tag);
      } else {
        return h(tagName, { className: classes.join(' ') }, tag);
      }
    }
  });
define("discourse/lib/round", 
  ["discourse/lib/decimal-adjust","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var decimalAdjust = __dependency1__["default"];

    __exports__["default"] = function (value, exp) {
      return decimalAdjust("round", value, exp);
    }
  });
define("discourse/lib/sharing", 
  ["exports"],
  function(__exports__) {
    "use strict";
    /**
      If you want to add a new sharing source to Discourse, you can do so like this:

      ```javascript
        import Sharing from 'discourse/lib/sharing';

        Sharing.addSource({

          // This id must be present in the `share_links` site setting too
          id: 'twitter',

          // The icon that will be displayed, choose between font awesome class name `faIcon` and custom HTML `htmlIcon`.
          // When both provided, prefer `faIcon`
          faIcon: 'fa-twitter-square'
          htmlIcon: '<img src="example.com/example.jpg">',

          // A callback for generating the remote link from the `link` and `title`
          generateUrl: function(link, title) {
            return "http://twitter.com/intent/tweet?url=" + encodeURIComponent(link) + "&text=" + encodeURIComponent(title);
          },

          // If true, opens in a popup of `popupHeight` size. If false it's opened in a new tab
          shouldOpenInPopup: true,
          popupHeight: 265
        });
      ```
    **/

    var _sources = {};

    __exports__["default"] = {
      addSource: function (source) {
        _sources[source.id] = source;
      },

      activeSources: function (linksSetting) {
        return linksSetting.split('|').map(function (s) {
          return _sources[s];
        }).compact();
      }
    };
  });
define("discourse/lib/static-route-builder", 
  ["discourse/lib/url","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];

    var configs = {
      "faq": "faq_url",
      "tos": "tos_url",
      "privacy": "privacy_policy_url"
    };

    __exports__["default"] = function (page) {
      return Discourse.Route.extend({
        renderTemplate: function () {
          this.render("static");
        },

        beforeModel: function (transition) {
          var configKey = configs[page];
          if (configKey && Discourse.SiteSettings[configKey].length > 0) {
            transition.abort();
            DiscourseURL.redirectTo(Discourse.SiteSettings[configKey]);
          }
        },

        activate: function () {
          this._super();
          // Scroll to an element if exists
          DiscourseURL.scrollToId(document.location.hash);
        },

        model: function () {
          return Discourse.StaticPage.find(page);
        },

        setupController: function (controller, model) {
          this.controllerFor("static").set("model", model);
        },

        actions: {
          didTransition: function () {
            this.controllerFor("application").set("showFooter", true);
            return true;
          }
        }
      });
    };
  });
define("discourse/lib/tag-hashtags", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var TAG_HASHTAG_POSTFIX = '::tag';
    __exports__.TAG_HASHTAG_POSTFIX = TAG_HASHTAG_POSTFIX;
  });
define("discourse/lib/transform-post", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.includeAttributes = includeAttributes;
    __exports__.transformBasicPost = transformBasicPost;

    __exports__["default"] = transformPost;
    function actionDescription(action, acted, count) {
      if (acted) {
        if (count <= 1) {
          return I18n.t('post.actions.by_you.' + action);
        } else {
          return I18n.t('post.actions.by_you_and_others.' + action, { count: count - 1 });
        }
      } else {
        return I18n.t('post.actions.by_others.' + action, { count: count });
      }
    }

    var _additionalAttributes = [];

    function includeAttributes() {
      for (var _len = arguments.length, attributes = Array(_len), _key = 0; _key < _len; _key++) {
        attributes[_key] = arguments[_key];
      }

      attributes.forEach(function (a) {
        return _additionalAttributes.push(a);
      });
    }

    function transformBasicPost(post) {
      // Note: it can be dangerous to not use `get` in Ember code, but this is significantly
      // faster and has tests to confirm it works. We only call `get` when the property is a CP
      return {
        id: post.id,
        hidden: post.hidden,
        deleted: post.get('deleted'),
        deleted_at: post.deleted_at,
        user_deleted: post.user_deleted,
        isDeleted: post.deleted_at || post.user_deleted,
        deletedByAvatarTemplate: null,
        deletedByUsername: null,
        primary_group_name: post.primary_group_name,
        wiki: post.wiki,
        firstPost: post.post_number === 1,
        post_number: post.post_number,
        cooked: post.cooked,
        via_email: post.via_email,
        isAutoGenerated: post.is_auto_generated,
        user_id: post.user_id,
        usernameUrl: Discourse.getURL('/users/' + post.username),
        username: post.username,
        avatar_template: post.avatar_template,
        bookmarked: post.bookmarked,
        yours: post.yours,
        shareUrl: post.get('shareUrl'),
        staff: post.staff,
        admin: post.admin,
        moderator: post.moderator,
        new_user: post.trust_level === 0,
        name: post.name,
        user_title: post.user_title,
        created_at: post.created_at,
        updated_at: post.updated_at,
        canDelete: post.can_delete,
        canRecover: post.can_recover,
        canEdit: post.can_edit,
        canFlag: !Ember.isEmpty(post.get('flagsAvailable')),
        version: post.version,
        canRecoverTopic: false,
        canDeletedTopic: false,
        canViewEditHistory: post.can_view_edit_history,
        canWiki: post.can_wiki,
        showLike: false,
        liked: false,
        canToggleLike: false,
        likeCount: false,
        actionsSummary: null,
        read: post.read,
        replyToUsername: null,
        replyToAvatarTemplate: null,
        reply_to_post_number: post.reply_to_post_number,
        cooked_hidden: !!post.cooked_hidden,
        expandablePost: false,
        replyCount: post.reply_count
      };
    }

    function transformPost(currentUser, site, post, prevPost, nextPost) {
      // Note: it can be dangerous to not use `get` in Ember code, but this is significantly
      // faster and has tests to confirm it works. We only call `get` when the property is a CP
      var postType = post.post_type;
      var postTypes = site.post_types;
      var topic = post.topic;
      var details = topic.get('details');

      var postAtts = transformBasicPost(post);

      var createdBy = details.created_by || {};

      postAtts.topicId = topic.id;
      postAtts.topicOwner = createdBy.id === post.user_id;
      postAtts.topicCreatedById = createdBy.id;
      postAtts.post_type = postType;
      postAtts.via_email = post.via_email;
      postAtts.isAutoGenerated = post.is_auto_generated;
      postAtts.isModeratorAction = postType === postTypes.moderator_action;
      postAtts.isWhisper = postType === postTypes.whisper;
      postAtts.isSmallAction = postType === postTypes.small_action;
      postAtts.canBookmark = !!currentUser;
      postAtts.canManage = currentUser && currentUser.get('canManageTopic');
      postAtts.canViewRawEmail = currentUser && (currentUser.id === post.user_id || currentUser.staff);
      postAtts.canReplyAsNewTopic = details.can_reply_as_new_topic;
      postAtts.isWarning = topic.is_warning;
      postAtts.links = post.get('internalLinks');
      postAtts.replyDirectlyBelow = nextPost && nextPost.reply_to_post_number === post.post_number;
      postAtts.replyDirectlyAbove = prevPost && post.reply_to_post_number === prevPost.post_number;
      postAtts.linkCounts = post.link_counts;
      postAtts.actionCode = post.action_code;
      postAtts.actionCodeWho = post.action_code_who;
      postAtts.userCustomFields = post.user_custom_fields;
      postAtts.topicUrl = topic.get('url');

      var showPMMap = topic.archetype === 'private_message' && post.post_number === 1;
      if (showPMMap) {
        postAtts.showPMMap = true;
        postAtts.allowedGroups = details.allowed_groups;
        postAtts.allowedUsers = details.allowed_users;
        postAtts.canRemoveAllowedUsers = details.can_remove_allowed_users;
        postAtts.canInvite = details.can_invite_to;
      }

      var showTopicMap = showPMMap || post.post_number === 1 && topic.archetype === 'regular' && topic.posts_count > 1;
      if (showTopicMap) {
        postAtts.showTopicMap = true;
        postAtts.topicCreatedAt = topic.created_at;
        postAtts.createdByUsername = createdBy.username;
        postAtts.createdByAvatarTemplate = createdBy.avatar_template;

        postAtts.lastPostUrl = topic.get('lastPostUrl');
        postAtts.lastPostUsername = details.last_poster.username;
        postAtts.lastPostAvatarTemplate = details.last_poster.avatar_template;
        postAtts.lastPostAt = topic.last_posted_at;

        postAtts.topicReplyCount = topic.get('replyCount');
        postAtts.topicViews = topic.views;
        postAtts.topicViewsHeat = topic.get('viewsHeat');

        postAtts.participantCount = topic.participant_count;
        postAtts.topicLikeCount = topic.like_count;
        postAtts.topicLinks = details.links;
        if (postAtts.topicLinks) {
          postAtts.topicLinkLength = details.links.length;
        }
        postAtts.topicPostsCount = topic.posts_count;

        postAtts.participants = details.participants;

        var postStream = topic.get('postStream');
        postAtts.userFilters = postStream.userFilters;
        postAtts.topicSummaryEnabled = postStream.summary;
        postAtts.topicWordCount = topic.word_count;
        postAtts.hasTopicSummary = topic.has_summary;
      }

      if (postAtts.isDeleted) {
        postAtts.deletedByAvatarTemplate = post.get('postDeletedBy.avatar_template');
        postAtts.deletedByUsername = post.get('postDeletedBy.username');
      }

      var replyToUser = post.get('reply_to_user');
      if (replyToUser) {
        postAtts.replyToUsername = replyToUser.username;
        postAtts.replyToAvatarTemplate = replyToUser.avatar_template;
      }

      if (post.actions_summary) {
        postAtts.actionsSummary = post.actions_summary.filter(function (a) {
          return a.actionType.name_key !== 'like' && a.count > 0;
        }).map(function (a) {
          var acted = a.acted;
          var action = a.actionType.name_key;
          var count = a.count;

          return { id: a.id,
            postId: post.id,
            action: action,
            acted: acted,
            count: count,
            canUndo: a.can_undo,
            canDeferFlags: a.can_defer_flags,
            description: actionDescription(action, acted, count) };
        });
      }

      var likeAction = post.likeAction;
      if (likeAction) {
        postAtts.liked = likeAction.acted;
        postAtts.canToggleLike = likeAction.get('canToggle');
        postAtts.showLike = postAtts.liked || postAtts.canToggleLike;
        postAtts.likeCount = likeAction.count;
      }

      if (postAtts.post_number === 1) {
        postAtts.canRecoverTopic = topic.deleted_at && details.can_recover;
        postAtts.canDeleteTopic = !topic.deleted_at && details.can_delete;
        postAtts.expandablePost = topic.expandable_first_post;
      } else {
        postAtts.canRecover = postAtts.isDeleted && postAtts.canRecover;
        postAtts.canDelete = !postAtts.isDeleted && postAtts.canDelete;
      }

      _additionalAttributes.forEach(function (a) {
        return postAtts[a] = post[a];
      });

      return postAtts;
    }
  });
define("discourse/router", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.mapRoutes = mapRoutes;
    var rootURL = Discourse.BaseUri;

    var BareRouter = Ember.Router.extend({
      rootURL: rootURL,
      location: Ember.testing ? 'none' : 'discourse-location'
    });

    function mapRoutes() {

      var Router = BareRouter.extend();
      var resources = {};
      var paths = {};

      // If a module is defined as `route-map` in discourse or a plugin, its routes
      // will be built automatically. You can supply a `resource` property to
      // automatically put it in that resource, such as `admin`. That way plugins
      // can define admin routes.
      Object.keys(requirejs._eak_seen).forEach(function (key) {
        if (/route-map$/.test(key)) {
          var module = require(key, null, null, true);
          if (!module || !module.default) {
            throw new Error(key + ' must export a route map.');
          }

          var mapObj = module.default;
          if (typeof mapObj === 'function') {
            mapObj = { resource: 'root', map: mapObj };
          }

          if (!resources[mapObj.resource]) {
            resources[mapObj.resource] = [];
          }
          resources[mapObj.resource].push(mapObj.map);
          if (mapObj.path) {
            paths[mapObj.resource] = mapObj.path;
          }
        }
      });

      return Router.map(function () {
        var router = this;

        // Do the root resources first
        if (resources.root) {
          resources.root.forEach(function (m) {
            m.call(router);
          });
          delete resources.root;
        }

        // Even if no plugins set it up, we need an `adminPlugins` route
        var adminPlugins = 'admin.adminPlugins';
        resources[adminPlugins] = resources[adminPlugins] || [Ember.K];
        paths[adminPlugins] = paths[adminPlugins] || "/plugins";

        var segments = {},
            standalone = [];

        Object.keys(resources).forEach(function (r) {
          var m = /^([^\.]+)\.(.*)$/.exec(r);
          if (m) {
            segments[m[1]] = m[2];
          } else {
            standalone.push(r);
          }
        });

        // Apply other resources next. A little hacky but works!
        standalone.forEach(function (r) {
          router.resource(r, { path: paths[r] }, function () {
            var res = this;
            resources[r].forEach(function (m) {
              m.call(res);
            });

            var s = segments[r];
            if (s) {
              var full = r + '.' + s;
              res.resource(s, { path: paths[full] }, function () {
                var nestedRes = this;
                resources[full].forEach(function (m) {
                  m.call(nestedRes);
                });
              });
            }
          });
        });

        this.route('unknown', { path: '*path' });
      });
    }

    __exports__["default"] = BareRouter;
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  This addition handles auto linking of text. When included, it will parse out links and create
  a hrefs for them.
**/

var urlReplacerArgs = {
  matcher: /^((?:https?:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.])(?:[^\s()<>]+|\([^\s()<>]+\))+(?:\([^\s()<>]+\)|[^`!()\[\]{};:'".,<>?«»“”‘’\s]))/,
  spaceOrTagBoundary: true,

  emitter: function(matches) {
    var url = matches[1],
        displayUrl = url;

    // Don't autolink a markdown link to something
    if (url.match(/\]\[\d$/)) { return; }

    // If we improperly caught a markdown link abort
    if (url.match(/\(http/)) { return; }

    if (url.match(/^www/)) { url = "http://" + url; }
    return ['a', {href: url}, displayUrl];
  }
};

Discourse.Dialect.inlineRegexp(_.merge({start: 'http'}, urlReplacerArgs));
Discourse.Dialect.inlineRegexp(_.merge({start: 'www'}, urlReplacerArgs));


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

Discourse.BBCode = {};

/**
  Create a simple BBCode tag handler

  @method replaceBBCode
  @param {tag} tag the tag we want to match
  @param {function} emitter the function that creates JsonML for the tag
  @param {Object} opts options to pass to Discourse.Dialect.inlineBetween
    @param {Function} [opts.emitter] The function that will be called with the contents and returns JsonML.
    @param {String} [opts.start] The starting token we want to find
    @param {String} [opts.stop] The ending token we want to find
    @param {String} [opts.between] A shortcut for when the `start` and `stop` are the same.
    @param {Boolean} [opts.rawContents] If true, the contents between the tokens will not be parsed.
    @param {Boolean} [opts.wordBoundary] If true, the match must be on a word boundary
    @param {Boolean} [opts.spaceBoundary] If true, the match must be on a sppace boundary
**/

Discourse.BBCode.register = function(codeName, args, emitter) {

  // Optional second param for args
  if (typeof args === "function") {
    emitter = args;
    args = {};
  }

  Discourse.Dialect.replaceBlock({
    start: new RegExp("\\[" + codeName + "(=[^\\[\\]]+)?\\]([\\s\\S]*)", "igm"),
    stop: new RegExp("\\[\\/" + codeName + "\\]", "igm"),
    emitter: function(blockContents, matches, options) {
      while (blockContents.length && (typeof blockContents[0] === "string" || blockContents[0] instanceof String)) {
        blockContents[0] = String(blockContents[0]).replace(/^\s+/, '');
        if (!blockContents[0].length) {
          blockContents.shift();
        } else {
          break;
        }
      }

      var contents = [];
      if (blockContents.length) {
        var self = this;

        var nextContents = blockContents.slice(1);
        blockContents = this.processBlock(blockContents[0], nextContents).concat(nextContents);

        blockContents.forEach(function (bc) {
          if (typeof bc === "string" || bc instanceof String) {
            var processed = self.processInline(String(bc));
            if (processed.length) {
              contents.push(['p'].concat(processed));
            }
          } else {
            contents.push(bc);
          }
        });
      }
      if (!args.singlePara && contents.length === 1 && contents[0] instanceof Array && contents[0][0] === "para") {
        contents[0].shift();
        contents = contents[0];
      }
      var result = emitter(contents, matches[1] ? matches[1].replace(/^=|\"/g, '') : null, options);
      return args.noWrap ? result : ['p', result];
    }
  });
};

Discourse.BBCode.replaceBBCode = function (tag, emitter, opts) {
  opts = opts || {};
  opts = _.merge(opts, { start: "[" + tag + "]", stop: "[/" + tag + "]", emitter: emitter });
  Discourse.Dialect.inlineBetween(opts);

  tag = tag.toUpperCase();
  opts = _.merge(opts, { start: "[" + tag + "]", stop: "[/" + tag + "]", emitter: emitter });
  Discourse.Dialect.inlineBetween(opts);
};

/**
  Shortcut to call replaceBBCode with `rawContents` as true.

  @method replaceBBCode
  @param {tag} tag the tag we want to match
  @param {function} emitter the function that creates JsonML for the tag
**/
Discourse.BBCode.rawBBCode = function (tag, emitter) {
  Discourse.BBCode.replaceBBCode(tag, emitter, { rawContents: true });
};

/**
  Creates a BBCode handler that accepts parameters. Passes them to the emitter.

  @method replaceBBCodeParamsRaw
  @param {tag} tag the tag we want to match
  @param {function} emitter the function that creates JsonML for the tag
**/
Discourse.BBCode.replaceBBCodeParamsRaw = function (tag, emitter) {
  var opts = {
    rawContents: true,
    emitter: function(contents) {
      var regexp = /^([^\]]+)\]([\S\s]*)$/,
          m = regexp.exec(contents);

      if (m) { return emitter.call(this, m[1], m[2]); }
    }
  };

  Discourse.Dialect.inlineBetween(_.merge(opts, { start: "[" + tag + "=", stop: "[/" + tag + "]" }));

  tag = tag.toUpperCase();
  Discourse.Dialect.inlineBetween(_.merge(opts, { start: "[" + tag + "=", stop: "[/" + tag + "]" }));
};

/**
  Filters an array of JSON-ML nodes, removing nodes that represent empty lines ("\n").

  @method removeEmptyLines
  @param {Array} [contents] Array of JSON-ML nodes
**/
Discourse.BBCode.removeEmptyLines = function (contents) {
  var result = [];
  for (var i=0; i < contents.length; i++) {
    if (contents[i] !== "\n") { result.push(contents[i]); }
  }
  return result;
};

Discourse.BBCode.replaceBBCode('b', function(contents) { return ['span', {'class': 'bbcode-b'}].concat(contents); });
Discourse.BBCode.replaceBBCode('i', function(contents) { return ['span', {'class': 'bbcode-i'}].concat(contents); });
Discourse.BBCode.replaceBBCode('u', function(contents) { return ['span', {'class': 'bbcode-u'}].concat(contents); });
Discourse.BBCode.replaceBBCode('s', function(contents) { return ['span', {'class': 'bbcode-s'}].concat(contents); });
Discourse.Markdown.whiteListTag('span', 'class', /^bbcode-[bius]$/);

Discourse.BBCode.replaceBBCode('ul', function(contents) { return ['ul'].concat(Discourse.BBCode.removeEmptyLines(contents)); });
Discourse.BBCode.replaceBBCode('ol', function(contents) { return ['ol'].concat(Discourse.BBCode.removeEmptyLines(contents)); });
Discourse.BBCode.replaceBBCode('li', function(contents) { return ['li'].concat(Discourse.BBCode.removeEmptyLines(contents)); });

Discourse.BBCode.rawBBCode('img', function(contents) { return ['img', {href: contents}]; });
Discourse.BBCode.rawBBCode('email', function(contents) { return ['a', {href: "mailto:" + contents, 'data-bbcode': true}, contents]; });

Discourse.BBCode.replaceBBCode('url', function(contents) {
  if (!Array.isArray(contents)) { return; }
  if (contents.length === 1 && contents[0][0] === 'a') {
    // single-line bbcode links shouldn't be oneboxed, so we mark this as a bbcode link.
    if (typeof contents[0][1] !== 'object') { contents[0].splice(1, 0, {}); }
    contents[0][1]['data-bbcode'] = true;
  }
  return ['concat'].concat(contents);
});
Discourse.BBCode.replaceBBCodeParamsRaw('url', function(param, contents) {
  var url = param.replace(/(^")|("$)/g, '');
  return ['a', {'href': url}].concat(this.processInline(contents));
});
Discourse.Dialect.on('parseNode', function(event) {
  if (!Array.isArray(event.node)) { return; }
  var result = [ event.node[0] ];
  var nodes = event.node.slice(1);
  var i, j;
  for (i = 0; i < nodes.length; i++) {
    if (Array.isArray(nodes[i]) && nodes[i][0] === 'concat') {
      for (j = 1; j < nodes[i].length; j++) { result.push(nodes[i][j]); }
    } else {
      result.push(nodes[i]);
    }
  }
  for (i = 0; i < result.length; i++) { event.node[i] = result[i]; }
});

Discourse.BBCode.replaceBBCodeParamsRaw("email", function(param, contents) {
  return ['a', {href: "mailto:" + param, 'data-bbcode': true}].concat(contents);
});

// Handles `[code] ... [/code]` blocks
Discourse.Dialect.replaceBlock({
  start: /(\[code\])([\s\S]*)/igm,
  stop: /\[\/code\]/igm,
  rawContents: true,

  emitter: function(blockContents) {
    var inner = blockContents.join("\n");
    return ['p', ['pre', ['code', {'class': Discourse.SiteSettings.default_code_lang}, inner]]];
  }
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  markdown-js doesn't ensure that em/strong codes are present on word boundaries.
  So we create our own handlers here.
**/

// From PageDown
var aLetter = /[a-zA-Z0-9\u00aa\u00b5\u00ba\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376-\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0523\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0621-\u064a\u0660-\u0669\u066e-\u066f\u0671-\u06d3\u06d5\u06e5-\u06e6\u06ee-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07c0-\u07ea\u07f4-\u07f5\u07fa\u0904-\u0939\u093d\u0950\u0958-\u0961\u0966-\u096f\u0971-\u0972\u097b-\u097f\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc-\u09dd\u09df-\u09e1\u09e6-\u09f1\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a59-\u0a5c\u0a5e\u0a66-\u0a6f\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0-\u0ae1\u0ae6-\u0aef\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b35-\u0b39\u0b3d\u0b5c-\u0b5d\u0b5f-\u0b61\u0b66-\u0b6f\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0be6-\u0bef\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58-\u0c59\u0c60-\u0c61\u0c66-\u0c6f\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0-\u0ce1\u0ce6-\u0cef\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d28\u0d2a-\u0d39\u0d3d\u0d60-\u0d61\u0d66-\u0d6f\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32-\u0e33\u0e40-\u0e46\u0e50-\u0e59\u0e81-\u0e82\u0e84\u0e87-\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa-\u0eab\u0ead-\u0eb0\u0eb2-\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0ed0-\u0ed9\u0edc-\u0edd\u0f00\u0f20-\u0f29\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8b\u1000-\u102a\u103f-\u1049\u1050-\u1055\u105a-\u105d\u1061\u1065-\u1066\u106e-\u1070\u1075-\u1081\u108e\u1090-\u1099\u10a0-\u10c5\u10d0-\u10fa\u10fc\u1100-\u1159\u115f-\u11a2\u11a8-\u11f9\u1200-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u1676\u1681-\u169a\u16a0-\u16ea\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u17e0-\u17e9\u1810-\u1819\u1820-\u1877\u1880-\u18a8\u18aa\u1900-\u191c\u1946-\u196d\u1970-\u1974\u1980-\u19a9\u19c1-\u19c7\u19d0-\u19d9\u1a00-\u1a16\u1b05-\u1b33\u1b45-\u1b4b\u1b50-\u1b59\u1b83-\u1ba0\u1bae-\u1bb9\u1c00-\u1c23\u1c40-\u1c49\u1c4d-\u1c7d\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u203f-\u2040\u2054\u2071\u207f\u2090-\u2094\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2183-\u2184\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2c6f\u2c71-\u2c7d\u2c80-\u2ce4\u2d00-\u2d25\u2d30-\u2d65\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005-\u3006\u3031-\u3035\u303b-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31b7\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fc3\ua000-\ua48c\ua500-\ua60c\ua610-\ua62b\ua640-\ua65f\ua662-\ua66e\ua67f-\ua697\ua717-\ua71f\ua722-\ua788\ua78b-\ua78c\ua7fb-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8d0-\ua8d9\ua900-\ua925\ua930-\ua946\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa50-\uaa59\uac00-\ud7a3\uf900-\ufa2d\ufa30-\ufa6a\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe33-\ufe34\ufe4d-\ufe4f\ufe70-\ufe74\ufe76-\ufefc\uff10-\uff19\uff21-\uff3a\uff3f\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc]/;


var unhoist = function(obj,from,to){
  var unhoisted = 0;
  var regex = new RegExp(from, "g");

  if(_.isArray(obj)){
    for(var i=0; i<obj.length; i++){
      var item = obj[i];

      if(_.isString(item)){
        // Odd, but we need +1 for the / in front of /*
        var matches = item.match(regex);
        unhoisted -= matches ? matches.length : 0;

        obj[i] = item.replace(regex, to);
        unhoisted += item.length - obj[i].length;
      }
      if(_.isArray(item)){
        unhoisted += unhoist(item, from, to);
      }
    }
  }
  return unhoisted;
};

var replaceMarkdown = function(match, tag) {
  var hash = Discourse.Dialect.guid();

  Discourse.Dialect.registerInline(match, function(text, matched, prev){
    if(!text || text.length < match.length + 1) {
      return;
    }
    var lastText = prev[prev.length-1];
    lastText = typeof lastText === "string" && lastText;
    lastText = lastText && lastText[lastText.length-1];
    if(lastText && (lastText === "/" || lastText.match(aLetter))){
      return;
    }

    if(text[match.length].match(/\s/)) {
      return;
    }

    // hoist out escaped \*
    text = text.replace(new RegExp("\\\\\\" + match[0], "g"), hash);

    var endText = new RegExp("[^\\s|" + match[0] + "]" + match.replace(/\*/g,"\\*") + "([^" + match[0] + "]|$)");

    var finish = text.split("\n")[0].search(endText);
    if(finish && finish >= 0) {
      var newText = text.substring(match.length, finish+1);
      newText = this.processInline(newText);

      var unhoisted_length = unhoist(newText,hash,match[0]);

      var array = typeof tag === "string" ? [tag].concat(newText) : [tag[0], [tag[1]].concat(newText)];

      return [(finish + match.length + 1) - unhoisted_length, array];
    }
  });
};

replaceMarkdown('***', ['strong','em']);
replaceMarkdown('___', ['strong','em']);
replaceMarkdown('**', 'strong');
replaceMarkdown('__', 'strong');
replaceMarkdown('*', 'em');
replaceMarkdown('_', 'em');




// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Supports Discourse's category hashtags (#category-slug) for automatically
  generating a link to the category.
**/

Discourse.Dialect.inlineRegexp({
  start: '#',
  matcher: /^#([\w-:]{1,101})/i,
  spaceOrTagBoundary: true,

  emitter: function(matches) {
    var slug = matches[1],
        hashtag = matches[0],
        attributeClass = 'hashtag',
        categoryHashtagLookup = this.dialect.options.categoryHashtagLookup,
        result = categoryHashtagLookup && categoryHashtagLookup(slug);

    if (result) {
      return ['a', { class: attributeClass, href: result[0] }, '#', ["span", {}, result[1]]];
    } else {
      return ['span', { class: attributeClass }, hashtag];
    }
  }
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

Discourse.Dialect.addPreProcessor(function(text) {
  return Discourse.CensoredWords.censor(text);
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Support for various code blocks
**/


var acceptableCodeClasses;

function init() {
  acceptableCodeClasses = Discourse.SiteSettings.highlighted_languages.split("|");
  if (Discourse.SiteSettings.highlighted_languages.length > 0) {
    var regexpSource = "^lang-(" + "nohighlight|auto|" + Discourse.SiteSettings.highlighted_languages + ")$";
    Discourse.Markdown.whiteListTag('code', 'class', new RegExp(regexpSource, "i"));
  }
}

if (Discourse.SiteSettings) {
  init();
} else {
  Discourse.initializer({initialize: init, name: 'load-acceptable-code-classes'});
}


var textCodeClasses = ["text", "pre", "plain"];

function codeFlattenBlocks(blocks) {
  var result = "";
  blocks.forEach(function(b) {
    result += b;
    if (b.trailing) { result += b.trailing; }
  });
  return result;
}

Discourse.Dialect.replaceBlock({
  start: /^`{3}([^\n\[\]]+)?\n?([\s\S]*)?/gm,
  stop: /^```$/gm,
  withoutLeading: /\[quote/gm, //if leading text contains a quote this should not match
  emitter: function(blockContents, matches) {

    var klass = Discourse.SiteSettings.default_code_lang;

    if (acceptableCodeClasses && matches[1] && acceptableCodeClasses.indexOf(matches[1]) !== -1) {
      klass = matches[1];
    }

    if (textCodeClasses.indexOf(matches[1]) !== -1) {
      return ['p', ['pre', ['code', {'class': 'lang-nohighlight'}, codeFlattenBlocks(blockContents) ]]];
    } else  {
      return ['p', ['pre', ['code', {'class': 'lang-' + klass}, codeFlattenBlocks(blockContents) ]]];
    }
  }
});

Discourse.Dialect.replaceBlock({
  start: /(<pre[^\>]*\>)([\s\S]*)/igm,
  stop: /<\/pre>/igm,
  rawContents: true,
  skipIfTradtionalLinebreaks: true,

  emitter: function(blockContents) {
    return ['p', ['pre', codeFlattenBlocks(blockContents)]];
  }
});

// Ensure that content in a code block is fully escaped. This way it's not white listed
// and we can use HTML and Javascript examples.
Discourse.Dialect.on('parseNode', function (event) {
  var node = event.node,
      path = event.path;

  if (node[0] === 'code') {
    var contents = node[node.length-1],
        regexp;

    if (path && path[path.length-1] && path[path.length-1][0] && path[path.length-1][0] === "pre") {
      regexp = / +$/g;
    } else {
      regexp = /^ +| +$/g;
    }
    node[node.length-1] = Discourse.Utilities.escapeExpression(contents.replace(regexp,''));
  }
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  If a row begins with HTML tags, don't parse it.
**/

var blockTags = ['address', 'article', 'aside', 'audio', 'blockquote', 'canvas', 'dd', 'div',
                 'dl', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3',
                 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr', 'iframe', 'noscript', 'ol', 'output',
                 'p', 'pre', 'section', 'table', 'tfoot', 'ul', 'video'],

    splitAtLast = function(tag, block, next, first) {
      var endTag = "</" + tag + ">",
          endTagIndex = first ? block.indexOf(endTag) : block.lastIndexOf(endTag);

      if (endTagIndex !== -1) {
        endTagIndex += endTag.length;

        var leading = block.substr(0, endTagIndex),
            trailing = block.substr(endTagIndex).replace(/^\s+/, '');

        if (trailing.length) {
          next.unshift(trailing);
        }

        return [ leading ];
      }
    };

Discourse.Dialect.registerBlock('html', function(block, next) {
  var split, pos;

  // Fix manual blockquote paragraphing even though it's not strictly correct
  // PERF NOTE: /\S+<blockquote/ is a perf hog for search, try on huge string
  if (pos = block.search(/<blockquote/) >= 0) {
    if(block.substring(0, pos).search(/\s/) === -1) {
      split = splitAtLast('blockquote', block, next, true);
      if (split) { return this.processInline(split[0]); }
    }
  }

  var m = /^<([^>]+)\>/.exec(block);
  if (m && m[1]) {
    var tag = m[1].split(/\s/);
    if (tag && tag[0] && blockTags.indexOf(tag[0]) !== -1) {
      split = splitAtLast(tag[0], block, next);
      if (split) {
        if (split.length === 1 && split[0] === block) { return; }
        return split;
      }
      return [ block.toString() ];
    }
  }
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Supports Discourse's custom @mention syntax for calling out a user in a post.
  It will add a special class to them, and create a link if the user is found in a
  local map.
**/

Discourse.Dialect.inlineRegexp({
  start: '@',
  // NOTE: since we can't use SiteSettings here (they loads later in process)
  // we are being less strict to account for more cases than allowed
  matcher: /^@(\w[\w.-]{0,59})\b/i,
  wordBoundary: true,

  emitter: function(matches) {
    var mention = matches[0].trim(),
        name = matches[1],
        mentionLookup = this.dialect.options.mentionLookup;

    var type = mentionLookup && mentionLookup(name);
    if (type === "user") {
      return ['a', {'class': 'mention', href: Discourse.getURL("/users/") + name.toLowerCase()}, mention];
    } else if (type === "group") {
      return ['a', {'class': 'mention-group', href: Discourse.getURL("/groups/") + name}, mention];
    } else {
      return ['span', {'class': 'mention'}, mention];
    }
  }
});

// We have to prune @mentions that are within links.
Discourse.Dialect.on("parseNode", function(event) {
  var node = event.node,
      path = event.path;

  if (node[1] && node[1]["class"] === 'mention')  {
    var parent = path[path.length - 1];
    // If the parent is an 'a', remove it
    if (parent && parent[0] === 'a') {
      var name = node[2];
      node.length = 0;
      node[0] = "__RAW";
      node[1] = name;
    }
  }

});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

Discourse.Dialect.on('parseNode', function (event) {
  var node = event.node,
      path = event.path;

  if (node[0] === 'a') {

    // It's invalid HTML to nest a link within another so strip it out.
    for (var i=0; i<path.length; i++) {
      if (path[i][0] === 'a') {
        var parent = path[path.length - 1],
            pos = parent.indexOf(node);

        // Just leave the link text
        if (pos !== -1) {
          parent[pos] = node[2];
        }
        return;
      }
    }
  }
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Support for the newline behavior in markdown that most expect. Look through all text nodes
  in the tree, replace any new lines with `br`s.
**/

Discourse.Dialect.postProcessText(function (text, event) {
  var opts = event.dialect.options,
      insideCounts = event.insideCounts,
      linebreaks = opts.traditional_markdown_linebreaks || Discourse.SiteSettings.traditional_markdown_linebreaks;

  if (linebreaks || (insideCounts.pre > 0)) { return; }

  if (text === "\n") {
    // If the tag is just a new line, replace it with a `<br>`
    return [['br']];
  } else {


    // If the text node contains new lines, perhaps with text between them, insert the
    // `<br>` tags.
    var split = text.split(/\n+/);
    if (split.length) {
      var replacement = [];
      for (var i=0; i<split.length; i++) {
        if (split[i].length > 0) { replacement.push(split[i]); }
        if (i !== split.length-1) { replacement.push(['br']); }
      }

      return replacement;
    }
  }

});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Given a node in the document and its parent, determine whether it is on its
  own line or not.

  @method isOnOneLine
  @namespace Discourse.Dialect
**/

var isOnOneLine = function(link, parent) {
  if (!parent) { return false; }

  var siblings = parent.slice(1);
  if ((!siblings) || (siblings.length < 1)) { return false; }

  var idx = siblings.indexOf(link);
  if (idx === -1) { return false; }

  if (idx > 0) {
    var prev = siblings[idx-1];
    if (prev[0] !== 'br') { return false; }
  }

  if (idx < siblings.length) {
    var next = siblings[idx+1];
    if (next && (!((next[0] === 'br') || (typeof next === 'string' && next.trim() === "")))) { return false; }
  }

  return true;
};

/**
  We only onebox stuff that is on its own line. This navigates the JsonML tree and
  correctly inserts the oneboxes.

  @event parseNode
  @namespace Discourse.Dialect
**/
Discourse.Dialect.on("parseNode", function(event) {
  var node = event.node,
      path = event.path;

  // We only care about links
  if (node[0] !== 'a')  { return; }

  var parent = path[path.length - 1];

  // We don't onebox bbcode
  if (node[1]['data-bbcode']) {
    delete node[1]['data-bbcode'];
    return;
  }

  // We don't onebox mentions
  if (node[1]['class'] === 'mention') { return; }

  // Don't onebox links within a list
  for (var i=0; i<path.length; i++) {
    if (path[i][0] === 'li') { return; }
  }

  // If the link has a different label text than the link itself, don't onebox it.
  var label = node[node.length-1];
  if (label !== node[1]['href']) { return; }

  if (isOnOneLine(node, parent)) {

    node[1]['class'] = 'onebox';
    node[1].target = '_blank';

    if (Discourse && Discourse.Onebox) {
      var contents = Discourse.Onebox.lookupCache(node[1].href);
      if (contents) {
        node[0] = '__RAW';
        node[1] = contents;
        node.length = 2;
      }
    }
  }
});



// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

var esc = Handlebars.Utils.escapeExpression;

Discourse.BBCode.register('quote', {noWrap: true, singlePara: true}, function(contents, bbParams, options) {
  var params = {'class': 'quote'},
      username = null;

  if (bbParams) {
    var paramsSplit = bbParams.split(/\,\s*/);
    username = paramsSplit[0];

    paramsSplit.forEach(function(p,i) {
      if (i > 0) {
        var assignment = p.split(':');
        if (assignment[0] && assignment[1]) {
          var escaped = esc(assignment[0]);
          // don't escape attributes, makes no sense
          if(escaped === assignment[0]) {
            params['data-' + assignment[0]] = esc(assignment[1].trim());
          }
        }
      }
    });
  }

  var avatarImg;
  var postNumber = parseInt(params['data-post'], 10);
  var topicId = parseInt(params['data-topic'], 10);

  if (options.lookupAvatarByPostNumber) {
    // client-side, we can retrieve the avatar from the post
    avatarImg = options.lookupAvatarByPostNumber(postNumber, topicId);
  } else if (options.lookupAvatar) {
    // server-side, we need to lookup the avatar from the username
    avatarImg = options.lookupAvatar(username);
  }

  // If there's no username just return a simple quote
  if (!username) {
    return ['p', ['aside', params, ['blockquote'].concat(contents)]];
  }

  var header = [ 'div', {'class': 'title'},
                 ['div', {'class': 'quote-controls'}],
                 avatarImg ? ['__RAW', avatarImg] : "",
                 username ? I18n.t('user.said', {username: username}) : ""
               ];

  if (options.topicId && postNumber && options.getTopicInfo && topicId !== options.topicId) {
    var topicInfo = options.getTopicInfo(topicId);
    if (topicInfo) {
      var href = topicInfo.href;
      if (postNumber > 0) { href += "/" + postNumber; }
      // get rid of username said stuff
      header.pop();
      header.push(['a', {'href': href}, topicInfo.title]);
    }
  }


  return ['aside', params, header, ['blockquote'].concat(contents)];
});


// IIFE Wrapped Content Ends

 })(this);
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

var tableFlattenBlocks = function(blocks) {
  var result = "";
  blocks.forEach(function(b) {
    result += b;
    if (b.trailing) { result += b.trailing; }
  });

  // bypass newline insertion
  return result.replace(/[\n\r]/g, " ");
};

var emitter = function(contents) {
  // TODO event should be fired when sanitizer loads
  if (window.html4 && window.html4.ELEMENTS.td !== 1) {
     window.html4.ELEMENTS.table = 0;
     window.html4.ELEMENTS.tbody = 1;
     window.html4.ELEMENTS.td = 1;
     window.html4.ELEMENTS.thead = 1;
     window.html4.ELEMENTS.th = 1;
     window.html4.ELEMENTS.tr = 1;
  }
  return ['table', {"class": "md-table"}, tableFlattenBlocks.apply(this, [contents])];
};

var tableBlock = {
  start: /(<table[^>]*>)([\S\s]*)/igm,
  stop: /<\/table>/igm,
  rawContents: true,
  emitter: emitter,
  priority: 1
};

var init = function(){
  if (Discourse.SiteSettings.allow_html_tables) {
    Discourse.Markdown.whiteListTag("table");
    Discourse.Markdown.whiteListTag("table", "class", "md-table");
    Discourse.Markdown.whiteListTag("tbody");
    Discourse.Markdown.whiteListTag("thead");
    Discourse.Markdown.whiteListTag("tr");
    Discourse.Markdown.whiteListTag("th");
    Discourse.Markdown.whiteListTag("td");
    Discourse.Dialect.replaceBlock(tableBlock);

  }
};

if (Discourse.SiteSettings) {
  init();
} else {
  Discourse.initializer({initialize: init, name: 'enable-html-tables'});
}


// IIFE Wrapped Content Ends

 })(this);
define("discourse/controllers/about", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({
      faqOverriden: Ember.computed.gt('siteSettings.faq_url.length', 0),

      contactInfo: (function () {
        if (this.siteSettings.contact_url) {
          return I18n.t('about.contact_info', { contact_info: "<a href='" + this.siteSettings.contact_url + "' target='_blank'>" + this.siteSettings.contact_url + "</a>" });
        } else if (this.siteSettings.contact_email) {
          return I18n.t('about.contact_info', { contact_info: this.siteSettings.contact_email });
        } else {
          return null;
        }
      }).property()
    });
  });
define("discourse/controllers/application", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'showTop',
      initializer: function () {
        return true;
      }
    }, {
      key: 'showFooter',
      initializer: function () {
        return false;
      }
    }, {
      key: 'styleCategory',
      initializer: function () {
        return null;
      }
    }, {
      key: 'canSignUp',
      decorators: [computed],
      value: function () {
        return !Discourse.SiteSettings.invite_only && Discourse.SiteSettings.allow_new_registrations && !Discourse.SiteSettings.enable_sso;
      }
    }, {
      key: 'loginRequired',
      decorators: [computed],
      value: function () {
        return Discourse.SiteSettings.login_required && !Discourse.User.current();
      }
    }]));
  });
define("discourse/controllers/avatar-selector", 
  ["ember-addons/ember-computed-decorators","discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ("value" in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === "function") { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError("The decorator for method " + descriptor.key + " is of the invalid type " + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var ModalFunctionality = __dependency2__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: "selectedUploadId",
      decorators: [computed("selected", "system_avatar_upload_id", "gravatar_avatar_upload_id", "custom_avatar_upload_id")],
      value: function (selected, system, gravatar, custom) {
        switch (selected) {
          case "system":
            return system;
          case "gravatar":
            return gravatar;
          default:
            return custom;
        }
      }
    }, {
      key: "selectedAvatarTemplate",
      decorators: [computed("selected", "system_avatar_template", "gravatar_avatar_template", "custom_avatar_template")],
      value: function (selected, system, gravatar, custom) {
        switch (selected) {
          case "system":
            return system;
          case "gravatar":
            return gravatar;
          default:
            return custom;
        }
      }
    }, {
      key: "allowAvatarUpload",
      decorators: [computed()],
      value: function () {
        return this.siteSettings.allow_uploaded_avatars && Discourse.Utilities.allowsImages();
      }
    }, {
      key: "actions",
      initializer: function () {
        return {
          useUploadedAvatar: function () {
            this.set("selected", "uploaded");
          },
          useGravatar: function () {
            this.set("selected", "gravatar");
          },
          useSystem: function () {
            this.set("selected", "system");
          },

          refreshGravatar: function () {
            var _this = this;

            this.set("gravatarRefreshDisabled", true);
            return Discourse.ajax("/user_avatar/" + this.get("username") + "/refresh_gravatar.json", { method: "POST" }).then(function (result) {
              return _this.setProperties({
                gravatar_avatar_template: result.gravatar_avatar_template,
                gravatar_avatar_upload_id: result.gravatar_upload_id
              });
            }).finally(function () {
              return _this.set("gravatarRefreshDisabled", false);
            });
          }
        };
      }
    }]));
  });
define("discourse/controllers/badges/index", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({
      badgeGroups: (function () {
        var sorted = _.sortBy(this.get('model'), function (badge) {
          var pos = badge.get('badge_grouping.position');
          var type = badge.get('badge_type_id');
          var name = badge.get('name');

          return ("000" + pos).slice(-4) + (10 - type) + name;
        });

        var grouped = [];
        var group = [],
            groupId;

        sorted.forEach(function (badge) {
          if (groupId !== badge.badge_grouping_id) {
            if (group && group.length > 0) {
              grouped.push({ badges: group, badgeGrouping: group[0].badge_grouping });
            }
            group = [];
            groupId = badge.badge_grouping_id;
          }
          group.push(badge);
        });

        if (group && group.length > 0) {
          grouped.push({ badges: group, badgeGrouping: group[0].badge_grouping });
        }

        return grouped;
      }).property('model')
    });
  });
define("discourse/controllers/badges/show", 
  ["discourse/models/user-badge","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var UserBadge = __dependency1__["default"];
    var computed = __dependency2__.default;
    var observes = __dependency2__.observes;

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'queryParams',
      initializer: function () {
        return ['username'];
      }
    }, {
      key: 'noMoreBadges',
      initializer: function () {
        return false;
      }
    }, {
      key: 'userBadges',
      initializer: function () {
        return null;
      }
    }, {
      key: 'needs',
      initializer: function () {
        return ["application"];
      }
    }, {
      key: 'user',
      decorators: [computed('username')],
      value: function (username) {
        if (username) {
          return this.get('userBadges')[0].get('user');
        }
      }
    }, {
      key: 'grantCount',
      decorators: [computed('username', 'model.grant_count', 'userBadges.grant_count')],
      value: function (username, modelCount, userCount) {
        return username ? userCount : modelCount;
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          loadMore: function () {
            var _this = this;

            if (this.get('loadingMore')) {
              return;
            }
            this.set('loadingMore', true);

            var userBadges = this.get('userBadges');

            UserBadge.findByBadgeId(this.get('model.id'), {
              offset: userBadges.length,
              username: this.get('username')
            }).then(function (result) {
              userBadges.pushObjects(result);
              if (userBadges.length === 0) {
                _this.set('noMoreBadges', true);
              }
            }).finally(function () {
              _this.set('loadingMore', false);
            });
          }
        };
      }
    }, {
      key: 'canLoadMore',
      decorators: [computed('noMoreBadges', 'grantCount', 'userBadges.length')],
      value: function (noMoreBadges, grantCount, userBadgeLength) {
        if (noMoreBadges) {
          return false;
        }
        return grantCount > (userBadgeLength || 0);
      }
    }, {
      key: 'canShowOthers',
      decorators: [computed('user', 'model.grant_count')],
      value: function (user, grantCount) {
        return !!user && grantCount > 1;
      }
    }, {
      key: '_showFooter',
      decorators: [observes('canLoadMore')],
      value: function () {
        this.set("controllers.application.showFooter", !this.get("canLoadMore"));
      }
    }]));
  });
define("discourse/controllers/bulk-notification-level", 
  ["discourse/lib/notification-levels","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var NotificationLevels = __dependency1__["default"];

    // Support for changing the notification level of various topics
    __exports__["default"] = Em.Controller.extend({
      needs: ['topic-bulk-actions'],
      notificationLevelId: null,

      notificationLevels: (function () {
        var result = [];
        Object.keys(NotificationLevels).forEach(function (k) {
          result.push({
            id: NotificationLevels[k].toString(),
            name: I18n.t('topic.notifications.' + k.toLowerCase() + ".title"),
            description: I18n.t('topic.notifications.' + k.toLowerCase() + ".description")
          });
        });
        return result;
      }).property(),

      disabled: Em.computed.empty("notificationLevelId"),

      actions: {
        changeNotificationLevel: function () {
          this.get('controllers.topic-bulk-actions').performAndRefresh({
            type: 'change_notification_level',
            notification_level_id: this.get('notificationLevelId')
          });
        }
      }
    });
  });
define("discourse/controllers/change-owner", 
  ["discourse/mixins/selected-posts-count","discourse/mixins/modal-functionality","discourse/lib/url","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var SelectedPostsCount = __dependency1__["default"];
    var ModalFunctionality = __dependency2__["default"];
    var DiscourseURL = __dependency3__["default"];

    // Modal related to changing the ownership of posts
    __exports__["default"] = Ember.Controller.extend(SelectedPostsCount, ModalFunctionality, {
      needs: ['topic'],

      topicController: Em.computed.alias('controllers.topic'),
      selectedPosts: Em.computed.alias('topicController.selectedPosts'),
      saving: false,
      new_user: null,

      buttonDisabled: (function () {
        if (this.get('saving')) return true;
        return Ember.isEmpty(this.get('new_user'));
      }).property('saving', 'new_user'),

      buttonTitle: (function () {
        if (this.get('saving')) return I18n.t('saving');
        return I18n.t('topic.change_owner.action');
      }).property('saving'),

      onShow: function () {
        this.setProperties({
          saving: false,
          new_user: ''
        });
      },

      actions: {
        changeOwnershipOfPosts: function () {
          this.set('saving', true);

          var postIds = this.get('selectedPosts').map(function (p) {
            return p.get('id');
          }),
              self = this,
              saveOpts = {
            post_ids: postIds,
            username: this.get('new_user')
          };

          Discourse.Topic.changeOwners(this.get('topicController.model.id'), saveOpts).then(function () {
            // success
            self.send('closeModal');
            self.get('topicController').send('deselectAll');
            if (self.get('topicController.multiSelect')) {
              self.get('topicController').send('toggleMultiSelect');
            }
            Em.run.next(function () {
              DiscourseURL.routeTo(self.get("topicController.model.url"));
            });
          }, function () {
            // failure
            self.flash(I18n.t('topic.change_owner.error'), 'alert-error');
            self.set('saving', false);
          });
          return false;
        }
      }
    });
  });
define("discourse/controllers/change-timestamp", 
  ["discourse/mixins/modal-functionality","ember-addons/ember-computed-decorators","discourse/lib/url","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var ModalFunctionality = __dependency1__["default"];
    var computed = __dependency2__["default"];
    var DiscourseURL = __dependency3__["default"];

    // Modal related to changing the timestamp of posts
    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['topic'];
      }
    }, {
      key: 'topicController',
      initializer: function () {
        return Em.computed.alias('controllers.topic');
      }
    }, {
      key: 'saving',
      initializer: function () {
        return false;
      }
    }, {
      key: 'date',
      initializer: function () {
        return '';
      }
    }, {
      key: 'time',
      initializer: function () {
        return '';
      }
    }, {
      key: 'buttonTitle',
      decorators: [computed('saving')],
      value: function (saving) {
        return saving ? I18n.t('saving') : I18n.t('topic.change_timestamp.action');
      }
    }, {
      key: 'createdAt',
      decorators: [computed('date', 'time')],
      value: function (date, time) {
        return moment(date + ' ' + time, 'YYYY-MM-DD HH:mm:ss');
      }
    }, {
      key: 'validTimestamp',
      decorators: [computed('createdAt')],
      value: function (createdAt) {
        return moment().diff(createdAt, 'minutes') < 0;
      }
    }, {
      key: 'buttonDisabled',
      decorators: [computed('saving', 'date', 'validTimestamp')],
      value: function () {
        if (this.get('saving') || this.get('validTimestamp')) return true;
        return Ember.isEmpty(this.get('date'));
      }
    }, {
      key: 'onShow',
      initializer: function () {
        return function () {
          this.setProperties({
            date: moment().format('YYYY-MM-DD')
          });
        };
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          changeTimestamp: function () {
            this.set('saving', true);
            var self = this,
                topic = this.get('topicController.model');

            Discourse.Topic.changeTimestamp(topic.get('id'), this.get('createdAt').unix()).then(function () {
              self.send('closeModal');
              self.setProperties({ date: '', time: '', saving: false });
              Em.run.next(function () {
                DiscourseURL.routeTo(topic.get('url'));
              });
            }).catch(function () {
              self.flash(I18n.t('topic.change_timestamp.error'), 'alert-error');
              self.set('saving', false);
            });
            return false;
          }
        };
      }
    }]));
  });
define("discourse/controllers/composer-messages", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // A controller for displaying messages as the user composes a message.
    __exports__["default"] = Ember.ArrayController.extend({
      needs: ['composer'],

      // Whether we've checked our messages
      checkedMessages: false,

      _init: (function () {
        this.reset();
      }).on("init"),

      actions: {
        closeMessage: function (message) {
          this.removeObject(message);
        },

        hideMessage: function (message) {
          this.removeObject(message);
          // kind of hacky but the visibility depends on this
          this.get('messagesByTemplate')[message.get('templateName')] = undefined;
        },

        popup: function (message) {
          var messagesByTemplate = this.get('messagesByTemplate');
          var templateName = message.get('templateName');

          if (!messagesByTemplate[templateName]) {
            this.pushObject(message);
            messagesByTemplate[templateName] = message;
          }
        }
      },

      // Resets all active messages.
      // For example if composing a new post.
      reset: function () {
        this.clear();
        this.setProperties({
          messagesByTemplate: {},
          queuedForTyping: [],
          checkedMessages: false
        });
      },

      // Called after the user has typed a reply.
      // Some messages only get shown after being typed.
      typedReply: function () {
        var _this = this;

        this.get('queuedForTyping').forEach(function (msg) {
          return _this.send("popup", msg);
        });
      },

      groupsMentioned: function (groups) {
        var _this2 = this;

        // reset existing messages, this should always win it is critical
        this.reset();
        groups.forEach(function (group) {
          var msg = I18n.t('composer.group_mentioned', {
            group: "@" + group.name,
            count: group.user_count,
            group_link: Discourse.getURL('/group/' + group.name + '/members')
          });
          _this2.send("popup", Em.Object.create({
            templateName: 'composer/group-mentioned',
            body: msg }));
        });
      },

      // Figure out if there are any messages that should be displayed above the composer.
      queryFor: function (composer) {
        if (this.get('checkedMessages')) {
          return;
        }

        var self = this;
        var queuedForTyping = self.get('queuedForTyping');

        Discourse.ComposerMessage.find(composer).then(function (messages) {
          self.set('checkedMessages', true);
          messages.forEach(function (msg) {
            return msg.wait_for_typing ? queuedForTyping.addObject(msg) : self.send("popup", msg);
          });
        });
      }

    });
  });
define("discourse/controllers/composer", 
  ["discourse/lib/url","discourse/lib/quote","discourse/models/draft","discourse/models/composer","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var DiscourseURL = __dependency1__["default"];
    var Quote = __dependency2__["default"];
    var Draft = __dependency3__["default"];
    var Composer = __dependency4__["default"];
    var computed = __dependency5__.default;
    var observes = __dependency5__.observes;

    function loadDraft(store, opts) {
      opts = opts || {};

      var draft = opts.draft;
      var draftKey = opts.draftKey;
      var draftSequence = opts.draftSequence;

      try {
        if (draft && typeof draft === 'string') {
          draft = JSON.parse(draft);
        }
      } catch (error) {
        draft = null;
        Draft.clear(draftKey, draftSequence);
      }
      if (draft && (draft.title && draft.title !== '' || draft.reply && draft.reply !== '')) {
        var composer = store.createRecord('composer');
        composer.open({
          draftKey: draftKey,
          draftSequence: draftSequence,
          action: draft.action,
          title: draft.title,
          categoryId: draft.categoryId || opts.categoryId,
          postId: draft.postId,
          archetypeId: draft.archetypeId,
          reply: draft.reply,
          metaData: draft.metaData,
          usernames: draft.usernames,
          draft: true,
          composerState: Composer.DRAFT,
          composerTime: draft.composerTime,
          typingTime: draft.typingTime
        });
        return composer;
      }
    }

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['modal', 'topic', 'composer-messages', 'application'];
      }
    }, {
      key: 'replyAsNewTopicDraft',
      initializer: function () {
        return Em.computed.equal('model.draftKey', Composer.REPLY_AS_NEW_TOPIC_KEY);
      }
    }, {
      key: 'checkedMessages',
      initializer: function () {
        return false;
      }
    }, {
      key: 'showEditReason',
      initializer: function () {
        return false;
      }
    }, {
      key: 'editReason',
      initializer: function () {
        return null;
      }
    }, {
      key: 'scopedCategoryId',
      initializer: function () {
        return null;
      }
    }, {
      key: 'similarTopics',
      initializer: function () {
        return null;
      }
    }, {
      key: 'similarTopicsMessage',
      initializer: function () {
        return null;
      }
    }, {
      key: 'lastSimilaritySearch',
      initializer: function () {
        return null;
      }
    }, {
      key: 'optionsVisible',
      initializer: function () {
        return false;
      }
    }, {
      key: 'lastValidatedAt',
      initializer: function () {
        return null;
      }
    }, {
      key: 'isUploading',
      initializer: function () {
        return false;
      }
    }, {
      key: 'topic',
      initializer: function () {
        return null;
      }
    }, {
      key: 'showToolbar',
      initializer: function () {
        return Em.computed({
          get: function () {
            var keyValueStore = this.container.lookup('key-value-store:main');
            var storedVal = keyValueStore.get("toolbar-enabled");
            if (this._toolbarEnabled === undefined && storedVal === undefined) {
              // iPhone 6 is 375, anything narrower and toolbar should
              // be default disabled.
              // That said we should remember the state
              this._toolbarEnabled = $(window).width() > 370;
            }
            return this._toolbarEnabled || storedVal === "true";
          },
          set: function (key, val) {
            var keyValueStore = this.container.lookup('key-value-store:main');
            this._toolbarEnabled = val;
            keyValueStore.set({ key: "toolbar-enabled", value: val ? "true" : "false" });
            return val;
          }
        });
      }
    }, {
      key: 'topicModel',
      initializer: function () {
        return Ember.computed.alias('controllers.topic.model');
      }
    }, {
      key: '_initializeSimilar',
      initializer: function () {
        return (function () {
          this.set('similarTopics', []);
        }).on('init');
      }
    }, {
      key: 'canEditTags',
      decorators: [computed('model.canEditTitle', 'model.creatingPrivateMessage')],
      value: function (canEditTitle, creatingPrivateMessage) {
        return !this.site.mobileView && this.site.get('can_tag_topics') && canEditTitle && !creatingPrivateMessage;
      }
    }, {
      key: 'canWhisper',
      decorators: [computed('model.action')],
      value: function (action) {
        var currentUser = this.currentUser;
        return currentUser && currentUser.get('staff') && this.siteSettings.enable_whispers && action === Composer.REPLY;
      }
    }, {
      key: 'showWarning',
      initializer: function () {
        return (function () {
          if (!Discourse.User.currentProp('staff')) {
            return false;
          }

          var usernames = this.get('model.targetUsernames');
          var hasTargetGroups = this.get('model.hasTargetGroups');

          // We need exactly one user to issue a warning
          if (Ember.isEmpty(usernames) || usernames.split(',').length !== 1 || hasTargetGroups) {
            return false;
          }
          return this.get('model.creatingPrivateMessage');
        }).property('model.creatingPrivateMessage', 'model.targetUsernames');
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {

          toggleWhisper: function () {
            this.toggleProperty('model.whisper');
          },

          toggleToolbar: function () {
            this.toggleProperty('showToolbar');
          },

          showOptions: function (loc) {
            this.appEvents.trigger('popup-menu:open', loc);
            this.set('optionsVisible', true);
          },

          hideOptions: function () {
            this.set('optionsVisible', false);
          },

          // Toggle the reply view
          toggle: function () {
            this.toggle();
          },

          togglePreview: function () {
            this.get('model').togglePreview();
          },

          // Import a quote from the post
          importQuote: function (toolbarEvent) {
            var _this = this;

            var postStream = this.get('topic.postStream');
            var postId = this.get('model.post.id');

            // If there is no current post, use the first post id from the stream
            if (!postId && postStream) {
              postId = postStream.get('stream.firstObject');
            }

            // If we're editing a post, fetch the reply when importing a quote
            if (this.get('model.editingPost')) {
              var replyToPostNumber = this.get('model.post.reply_to_post_number');
              if (replyToPostNumber) {
                var replyPost = postStream.get('posts').findBy('post_number', replyToPostNumber);
                if (replyPost) {
                  postId = replyPost.get('id');
                }
              }
            }

            if (postId) {
              var _ret = (function () {
                _this.set('model.loading', true);
                var composer = _this;

                return {
                  v: _this.store.find('post', postId).then(function (post) {
                    var quote = Quote.build(post, post.get("raw"), { raw: true, full: true });
                    toolbarEvent.addText(quote);
                    composer.set('model.loading', false);
                  })
                };
              })();

              if (typeof _ret === 'object') return _ret.v;
            }
          },

          cancel: function () {
            this.cancelComposer();
          },

          save: function () {
            this.save();
          },

          displayEditReason: function () {
            this.set("showEditReason", true);
          },

          hitEsc: function () {
            var messages = this.get('controllers.composer-messages.model');
            if (messages.length) {
              messages.popObject();
              return;
            }

            if (this.get('model.viewOpen')) {
              this.shrink();
            }
          },

          openIfDraft: function () {
            if (this.get('model.viewDraft')) {
              this.set('model.composeState', Composer.OPEN);
            }
          },

          groupsMentioned: function (groups) {
            if (!this.get('model.creatingPrivateMessage') && !this.get('model.topic.isPrivateMessage')) {
              this.get('controllers.composer-messages').groupsMentioned(groups);
            }
          }

        };
      }
    }, {
      key: 'categories',
      initializer: function () {
        return (function () {
          return Discourse.Category.list();
        }).property();
      }
    }, {
      key: 'toggle',
      value: function () {
        this.closeAutocomplete();
        switch (this.get('model.composeState')) {
          case Composer.OPEN:
            if (Ember.isEmpty(this.get('model.reply')) && Ember.isEmpty(this.get('model.title'))) {
              this.close();
            } else {
              this.shrink();
            }
            break;
          case Composer.DRAFT:
            this.set('model.composeState', Composer.OPEN);
            break;
          case Composer.SAVING:
            this.close();
        }
        return false;
      }
    }, {
      key: 'disableSubmit',
      initializer: function () {
        return Ember.computed.or("model.loading", "isUploading");
      }
    }, {
      key: 'save',
      value: function (force) {
        var _this2 = this;

        var composer = this.get('model');
        var self = this;

        // Clear the warning state if we're not showing the checkbox anymore
        if (!this.get('showWarning')) {
          this.set('model.isWarning', false);
        }

        if (composer.get('cantSubmitPost')) {
          this.set('lastValidatedAt', Date.now());
          return;
        }

        composer.set('disableDrafts', true);

        // for now handle a very narrow use case
        // if we are replying to a topic AND not on the topic pop the window up
        if (!force && composer.get('replyingToTopic')) {
          var _ret2 = (function () {

            var currentTopic = _this2.get('topicModel');
            if (!currentTopic || currentTopic.get('id') !== composer.get('topic.id')) {
              var message = I18n.t("composer.posting_not_on_topic");

              var buttons = [{
                "label": I18n.t("composer.cancel"),
                "class": "cancel",
                "link": true
              }];

              if (currentTopic) {
                buttons.push({
                  "label": I18n.t("composer.reply_here") + "<br/><div class='topic-title overflow-ellipsis'>" + Discourse.Utilities.escapeExpression(currentTopic.get('title')) + "</div>",
                  "class": "btn btn-reply-here",
                  "callback": function () {
                    composer.set('topic', currentTopic);
                    composer.set('post', null);
                    self.save(true);
                  }
                });
              }

              buttons.push({
                "label": I18n.t("composer.reply_original") + "<br/><div class='topic-title overflow-ellipsis'>" + Discourse.Utilities.escapeExpression(_this2.get('model.topic.title')) + "</div>",
                "class": "btn-primary btn-reply-on-original",
                "callback": function () {
                  self.save(true);
                }
              });

              bootbox.dialog(message, buttons, { "classes": "reply-where-modal" });
              return {
                v: undefined
              };
            }
          })();

          if (typeof _ret2 === 'object') return _ret2.v;
        }

        var staged = false;

        // TODO: This should not happen in model
        var imageSizes = {};
        $('#reply-control .d-editor-preview img').each(function (i, e) {
          var $img = $(e);
          var src = $img.prop('src');

          if (src && src.length) {
            imageSizes[src] = { width: $img.width(), height: $img.height() };
          }
        });

        var promise = composer.save({ imageSizes: imageSizes, editReason: this.get("editReason") }).then(function (result) {
          if (result.responseJson.action === "enqueued") {
            self.send('postWasEnqueued', result.responseJson);
            self.destroyDraft();
            self.close();
            self.appEvents.trigger('post-stream:refresh');
            return result;
          }

          // If user "created a new topic/post" or "replied as a new topic" successfully, remove the draft.
          if (result.responseJson.action === "create_post" || self.get('replyAsNewTopicDraft')) {
            self.destroyDraft();
          }
          if (self.get('model.action') === 'edit') {
            self.appEvents.trigger('post-stream:refresh', { id: parseInt(result.responseJson.id) });
          } else {
            self.appEvents.trigger('post-stream:refresh');
          }

          if (result.responseJson.action === "create_post") {
            self.appEvents.trigger('post:highlight', result.payload.post_number);
          }
          self.close();

          var currentUser = Discourse.User.current();
          if (composer.get('creatingTopic')) {
            currentUser.set('topic_count', currentUser.get('topic_count') + 1);
          } else {
            currentUser.set('reply_count', currentUser.get('reply_count') + 1);
          }

          var disableJumpReply = Discourse.User.currentProp('disable_jump_reply');
          if (!composer.get('replyingToTopic') || !disableJumpReply) {
            var post = result.target;
            if (post && !staged) {
              DiscourseURL.routeTo(post.get('url'));
            }
          }
        }).catch(function (error) {
          composer.set('disableDrafts', false);
          self.appEvents.one('composer:opened', function () {
            return bootbox.alert(error);
          });
        });

        if (this.get('controllers.application.currentRouteName').split('.')[0] === 'topic' && composer.get('topic.id') === this.get('topicModel.id')) {
          staged = composer.get('stagedPost');
        }

        this.appEvents.trigger('post-stream:posted', staged);

        this.messageBus.pause();
        promise.finally(function () {
          return _this2.messageBus.resume();
        });

        return promise;
      }
    }, {
      key: 'checkReplyLength',

      // Checks to see if a reply has been typed.
      // This is signaled by a keyUp event in a view.
      value: function () {
        if (!Ember.isEmpty('model.reply')) {
          // Notify the composer messages controller that a reply has been typed. Some
          // messages only appear after typing.
          this.get('controllers.composer-messages').typedReply();
        }
      }
    }, {
      key: 'findSimilarTopics',

      // Fired after a user stops typing.
      // Considers whether to check for similar topics based on the current composer state.
      value: function () {
        // We don't care about similar topics unless creating a topic
        if (!this.get('model.creatingTopic')) {
          return;
        }

        var body = this.get('model.reply') || '';
        var title = this.get('model.title') || '';

        // Ensure the fields are of the minimum length
        if (body.length < Discourse.SiteSettings.min_body_similar_length) {
          return;
        }
        if (title.length < Discourse.SiteSettings.min_title_similar_length) {
          return;
        }

        // TODO pass the 200 in from somewhere
        body = body.substr(0, 200);

        // Done search over and over
        if (title + body === this.get('lastSimilaritySearch')) {
          return;
        }
        this.set('lastSimilaritySearch', title + body);

        var messageController = this.get('controllers.composer-messages'),
            similarTopics = this.get('similarTopics');

        var message = this.get('similarTopicsMessage');
        if (!message) {
          message = Discourse.ComposerMessage.create({
            templateName: 'composer/similar-topics',
            extraClass: 'similar-topics'
          });
          this.set('similarTopicsMessage', message);
        }

        this.store.find('similar-topic', { title: title, raw: body }).then(function (newTopics) {
          similarTopics.clear();
          similarTopics.pushObjects(newTopics.get('content'));

          if (similarTopics.get('length') > 0) {
            message.set('similarTopics', similarTopics);
            messageController.send("popup", message);
          } else if (message) {
            messageController.send("hideMessage", message);
          }
        });
      }
    }, {
      key: 'open',

      /**
        Open the composer view
         @method open
        @param {Object} opts Options for creating a post
          @param {String} opts.action The action we're performing: edit, reply or createTopic
          @param {Discourse.Post} [opts.post] The post we're replying to
          @param {Discourse.Topic} [opts.topic] The topic we're replying to
          @param {String} [opts.quote] If we're opening a reply from a quote, the quote we're making
      **/
      value: function (opts) {
        opts = opts || {};

        if (!opts.draftKey) {
          alert("composer was opened without a draft key");
          throw "composer opened without a proper draft key";
        }

        // If we show the subcategory list, scope the categories drop down to
        // the category we opened the composer with.
        if (this.siteSettings.show_subcategory_list && opts.draftKey !== 'reply_as_new_topic') {
          this.set('scopedCategoryId', opts.categoryId);
        }

        var composerMessages = this.get('controllers.composer-messages'),
            self = this;

        var composerModel = this.get('model');

        this.setProperties({ showEditReason: false, editReason: null });
        composerMessages.reset();

        // If we want a different draft than the current composer, close it and clear our model.
        if (composerModel && opts.draftKey !== composerModel.draftKey && composerModel.composeState === Composer.DRAFT) {
          this.close();
          composerModel = null;
        }

        return new Ember.RSVP.Promise(function (resolve, reject) {
          if (composerModel && composerModel.get('replyDirty')) {

            // If we're already open, we don't have to do anything
            if (composerModel.get('composeState') === Composer.OPEN && composerModel.get('draftKey') === opts.draftKey && !opts.action) {
              return resolve();
            }

            // If it's the same draft, just open it up again.
            if (composerModel.get('composeState') === Composer.DRAFT && composerModel.get('draftKey') === opts.draftKey) {
              composerModel.set('composeState', Composer.OPEN);
              if (!opts.action) return resolve();
            }

            // If it's a different draft, cancel it and try opening again.
            return self.cancelComposer().then(function () {
              return self.open(opts);
            }).then(resolve, reject);
          }

          // we need a draft sequence for the composer to work
          if (opts.draftSequence === undefined) {
            return Draft.get(opts.draftKey).then(function (data) {
              opts.draftSequence = data.draft_sequence;
              opts.draft = data.draft;
              self._setModel(composerModel, opts);
            }).then(resolve, reject);
          }

          self._setModel(composerModel, opts);
          resolve();
        });
      }
    }, {
      key: '_setModel',

      // Given a potential instance and options, set the model for this composer.
      value: function (composerModel, opts) {
        var _this3 = this;

        if (opts.draft) {
          composerModel = loadDraft(this.store, opts);
          if (composerModel) {
            composerModel.set('topic', opts.topic);
          }
        } else {
          composerModel = composerModel || this.store.createRecord('composer');
          composerModel.open(opts);
        }

        this.set('model', composerModel);
        composerModel.set('composeState', Composer.OPEN);
        composerModel.set('isWarning', false);

        if (opts.topicTitle && opts.topicTitle.length <= this.siteSettings.max_topic_title_length) {
          this.set('model.title', opts.topicTitle);
        }

        if (opts.topicCategoryId) {
          this.set('model.categoryId', opts.topicCategoryId);
        } else if (opts.topicCategory) {
          (function () {
            var splitCategory = opts.topicCategory.split("/");
            var category = undefined;

            if (!splitCategory[1]) {
              category = _this3.site.get('categories').findProperty('nameLower', splitCategory[0].toLowerCase());
            } else {
              (function () {
                var categories = Discourse.Category.list();
                var mainCategory = categories.findProperty('nameLower', splitCategory[0].toLowerCase());
                category = categories.find(function (item) {
                  return item && item.get('nameLower') === splitCategory[1].toLowerCase() && item.get('parent_category_id') === mainCategory.id;
                });
              })();
            }

            if (category) {
              _this3.set('model.categoryId', category.get('id'));
            }
          })();
        }

        if (opts.topicBody) {
          this.set('model.reply', opts.topicBody);
        }

        this.get('controllers.composer-messages').queryFor(composerModel);
      }
    }, {
      key: 'viewNewReply',

      // View a new reply we've made
      value: function () {
        DiscourseURL.routeTo(this.get('model.createdPost.url'));
        this.close();
        return false;
      }
    }, {
      key: 'destroyDraft',
      value: function () {
        var key = this.get('model.draftKey');
        if (key) {
          Draft.clear(key, this.get('model.draftSequence'));
        }
      }
    }, {
      key: 'cancelComposer',
      value: function () {
        var self = this;

        return new Ember.RSVP.Promise(function (resolve) {
          if (self.get('model.hasMetaData') || self.get('model.replyDirty')) {
            bootbox.confirm(I18n.t("post.abandon.confirm"), I18n.t("post.abandon.no_value"), I18n.t("post.abandon.yes_value"), function (result) {
              if (result) {
                self.destroyDraft();
                self.get('model').clearState();
                self.close();
                resolve();
              }
            });
          } else {
            // it is possible there is some sort of crazy draft with no body ... just give up on it
            self.destroyDraft();
            self.get('model').clearState();
            self.close();
            resolve();
          }
        });
      }
    }, {
      key: 'shrink',
      value: function () {
        if (this.get('model.replyDirty')) {
          this.collapse();
        } else {
          this.close();
        }
      }
    }, {
      key: '_saveDraft',
      value: function () {
        var model = this.get('model');
        if (model) {
          model.saveDraft();
        };
      }
    }, {
      key: '_shouldSaveDraft',
      decorators: [observes('model.reply', 'model.title')],
      value: function () {
        Ember.run.debounce(this, this._saveDraft, 2000);
      }
    }, {
      key: 'categoryValidation',
      decorators: [computed('model.categoryId', 'lastValidatedAt')],
      value: function (categoryId, lastValidatedAt) {
        if (!this.siteSettings.allow_uncategorized_topics && !categoryId) {
          return Discourse.InputValidation.create({ failed: true, reason: I18n.t('composer.error.category_missing'), lastShownAt: lastValidatedAt });
        }
      }
    }, {
      key: 'collapse',
      value: function () {
        this._saveDraft();
        this.set('model.composeState', Composer.DRAFT);
      }
    }, {
      key: 'close',
      value: function () {
        this.setProperties({ model: null, lastValidatedAt: null });
      }
    }, {
      key: 'closeAutocomplete',
      value: function () {
        $('.d-editor-input').autocomplete({ cancel: true });
      }
    }, {
      key: 'canEdit',
      initializer: function () {
        return (function () {
          return this.get("model.action") === "edit" && Discourse.User.current().get("can_edit");
        }).property("model.action");
      }
    }, {
      key: 'visible',
      initializer: function () {
        return (function () {
          var state = this.get('model.composeState');
          return state && state !== 'closed';
        }).property('model.composeState');
      }
    }]));
  });
define("discourse/controllers/create-account", 
  ["discourse/lib/debounce","discourse/mixins/modal-functionality","discourse/lib/computed","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var debounce = __dependency1__["default"];
    var ModalFunctionality = __dependency2__["default"];
    var setting = __dependency3__.setting;
    var on = __dependency4__.on;

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['login'];
      }
    }, {
      key: 'uniqueUsernameValidation',
      initializer: function () {
        return null;
      }
    }, {
      key: 'globalNicknameExists',
      initializer: function () {
        return false;
      }
    }, {
      key: 'complete',
      initializer: function () {
        return false;
      }
    }, {
      key: 'accountPasswordConfirm',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'accountChallenge',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'formSubmitted',
      initializer: function () {
        return false;
      }
    }, {
      key: 'rejectedEmails',
      initializer: function () {
        return Em.A([]);
      }
    }, {
      key: 'rejectedPasswords',
      initializer: function () {
        return Em.A([]);
      }
    }, {
      key: 'prefilledUsername',
      initializer: function () {
        return null;
      }
    }, {
      key: 'userFields',
      initializer: function () {
        return null;
      }
    }, {
      key: 'isDeveloper',
      initializer: function () {
        return false;
      }
    }, {
      key: 'hasAuthOptions',
      initializer: function () {
        return Em.computed.notEmpty('authOptions');
      }
    }, {
      key: 'canCreateLocal',
      initializer: function () {
        return setting('enable_local_logins');
      }
    }, {
      key: 'showCreateForm',
      initializer: function () {
        return Em.computed.or('hasAuthOptions', 'canCreateLocal');
      }
    }, {
      key: 'maxUsernameLength',
      initializer: function () {
        return setting('max_username_length');
      }
    }, {
      key: 'minUsernameLength',
      initializer: function () {
        return setting('min_username_length');
      }
    }, {
      key: 'resetForm',
      value: function () {
        // We wrap the fields in a structure so we can assign a value
        this.setProperties({
          accountName: '',
          accountEmail: '',
          accountUsername: '',
          accountPassword: '',
          authOptions: null,
          globalNicknameExists: false,
          complete: false,
          formSubmitted: false,
          rejectedEmails: [],
          rejectedPasswords: [],
          prefilledUsername: null,
          isDeveloper: false
        });
        this._createUserFields();
      }
    }, {
      key: 'submitDisabled',
      initializer: function () {
        return (function () {
          if (!this.get('emailValidation.failed') && !this.get('passwordRequired')) return false; // 3rd party auth
          if (this.get('formSubmitted')) return true;
          if (this.get('nameValidation.failed')) return true;
          if (this.get('emailValidation.failed')) return true;
          if (this.get('usernameValidation.failed')) return true;
          if (this.get('passwordValidation.failed')) return true;

          // Validate required fields
          var userFields = this.get('userFields');
          if (userFields) {
            userFields = userFields.filterProperty('field.required');
          }
          if (!Ember.isEmpty(userFields)) {
            var anyEmpty = userFields.any(function (uf) {
              var val = uf.get('value');
              return !val || Ember.isEmpty(val);
            });
            if (anyEmpty) {
              return true;
            }
          }
          return false;
        }).property('passwordRequired', 'nameValidation.failed', 'emailValidation.failed', 'usernameValidation.failed', 'passwordValidation.failed', 'formSubmitted', 'userFields.@each.value');
      }
    }, {
      key: 'usernameRequired',
      initializer: function () {
        return Ember.computed.not('authOptions.omit_username');
      }
    }, {
      key: 'passwordRequired',
      initializer: function () {
        return (function () {
          return Ember.isEmpty(this.get('authOptions.auth_provider'));
        }).property('authOptions.auth_provider');
      }
    }, {
      key: 'passwordInstructions',
      initializer: function () {
        return (function () {
          return this.get('isDeveloper') ? I18n.t('user.password.instructions', { count: Discourse.SiteSettings.min_admin_password_length }) : I18n.t('user.password.instructions', { count: Discourse.SiteSettings.min_password_length });
        }).property('isDeveloper');
      }
    }, {
      key: 'nameInstructions',
      initializer: function () {
        return (function () {
          return I18n.t(Discourse.SiteSettings.full_name_required ? 'user.name.instructions_required' : 'user.name.instructions');
        }).property();
      }
    }, {
      key: 'nameValidation',

      // Validate the name.
      initializer: function () {
        return (function () {
          if (Discourse.SiteSettings.full_name_required && Ember.isEmpty(this.get('accountName'))) {
            return Discourse.InputValidation.create({ failed: true });
          }

          return Discourse.InputValidation.create({ ok: true });
        }).property('accountName');
      }
    }, {
      key: 'emailValidation',

      // Check the email address
      initializer: function () {
        return (function () {
          // If blank, fail without a reason
          var email = undefined;
          if (Ember.isEmpty(this.get('accountEmail'))) {
            return Discourse.InputValidation.create({
              failed: true
            });
          }

          email = this.get("accountEmail");

          if (this.get('rejectedEmails').contains(email)) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.email.invalid')
            });
          }

          if (this.get('authOptions.email') === email && this.get('authOptions.email_valid')) {
            return Discourse.InputValidation.create({
              ok: true,
              reason: I18n.t('user.email.authenticated', {
                provider: this.authProviderDisplayName(this.get('authOptions.auth_provider'))
              })
            });
          }

          if (Discourse.Utilities.emailValid(email)) {
            return Discourse.InputValidation.create({
              ok: true,
              reason: I18n.t('user.email.ok')
            });
          }

          return Discourse.InputValidation.create({
            failed: true,
            reason: I18n.t('user.email.invalid')
          });
        }).property('accountEmail', 'rejectedEmails.[]');
      }
    }, {
      key: 'emailValidated',
      initializer: function () {
        return (function () {
          return this.get('authOptions.email') === this.get("accountEmail") && this.get('authOptions.email_valid');
        }).property('accountEmail', 'authOptions.email', 'authOptions.email_valid');
      }
    }, {
      key: 'authProviderDisplayName',
      value: function (provider) {
        switch (provider) {
          case "Google_oauth2":
            return "Google";
          default:
            return provider;
        }
      }
    }, {
      key: 'prefillUsername',
      initializer: function () {
        return (function () {
          if (this.get('prefilledUsername')) {
            // If username field has been filled automatically, and email field just changed,
            // then remove the username.
            if (this.get('accountUsername') === this.get('prefilledUsername')) {
              this.set('accountUsername', '');
            }
            this.set('prefilledUsername', null);
          }
          if (this.get('emailValidation.ok') && (Ember.isEmpty(this.get('accountUsername')) || this.get('authOptions.email'))) {
            // If email is valid and username has not been entered yet,
            // or email and username were filled automatically by 3rd parth auth,
            // then look for a registered username that matches the email.
            this.fetchExistingUsername();
          }
        }).observes('emailValidation', 'accountEmail');
      }
    }, {
      key: 'fetchExistingUsername',
      initializer: function () {
        return debounce(function () {
          var self = this;
          Discourse.User.checkUsername(null, this.get('accountEmail')).then(function (result) {
            if (result.suggestion && (Ember.isEmpty(self.get('accountUsername')) || self.get('accountUsername') === self.get('authOptions.username'))) {
              self.set('accountUsername', result.suggestion);
              self.set('prefilledUsername', result.suggestion);
            }
          });
        }, 500);
      }
    }, {
      key: 'usernameMatch',
      initializer: function () {
        return (function () {
          if (this.usernameNeedsToBeValidatedWithEmail()) {
            if (this.get('emailValidation.failed')) {
              if (this.shouldCheckUsernameMatch()) {
                return this.set('uniqueUsernameValidation', Discourse.InputValidation.create({
                  failed: true,
                  reason: I18n.t('user.username.enter_email')
                }));
              } else {
                return this.set('uniqueUsernameValidation', Discourse.InputValidation.create({ failed: true }));
              }
            } else if (this.shouldCheckUsernameMatch()) {
              this.set('uniqueUsernameValidation', Discourse.InputValidation.create({
                failed: true,
                reason: I18n.t('user.username.checking')
              }));
              return this.checkUsernameAvailability();
            }
          }
        }).observes('accountEmail');
      }
    }, {
      key: 'basicUsernameValidation',
      initializer: function () {
        return (function () {
          this.set('uniqueUsernameValidation', null);

          if (this.get('accountUsername') === this.get('prefilledUsername')) {
            return Discourse.InputValidation.create({
              ok: true,
              reason: I18n.t('user.username.prefilled')
            });
          }

          // If blank, fail without a reason
          if (Ember.isEmpty(this.get('accountUsername'))) {
            return Discourse.InputValidation.create({
              failed: true
            });
          }

          // If too short
          if (this.get('accountUsername').length < Discourse.SiteSettings.min_username_length) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.username.too_short')
            });
          }

          // If too long
          if (this.get('accountUsername').length > this.get('maxUsernameLength')) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.username.too_long')
            });
          }

          this.checkUsernameAvailability();
          // Let's check it out asynchronously
          return Discourse.InputValidation.create({
            failed: true,
            reason: I18n.t('user.username.checking')
          });
        }).property('accountUsername');
      }
    }, {
      key: 'shouldCheckUsernameMatch',
      initializer: function () {
        return function () {
          return !Ember.isEmpty(this.get('accountUsername')) && this.get('accountUsername').length >= this.get('minUsernameLength');
        };
      }
    }, {
      key: 'checkUsernameAvailability',
      initializer: function () {
        return debounce(function () {
          var _this = this;
          if (this.shouldCheckUsernameMatch()) {
            return Discourse.User.checkUsername(this.get('accountUsername'), this.get('accountEmail')).then(function (result) {
              _this.set('isDeveloper', false);
              if (result.available) {
                if (result.is_developer) {
                  _this.set('isDeveloper', true);
                }
                return _this.set('uniqueUsernameValidation', Discourse.InputValidation.create({
                  ok: true,
                  reason: I18n.t('user.username.available')
                }));
              } else {
                if (result.suggestion) {
                  return _this.set('uniqueUsernameValidation', Discourse.InputValidation.create({
                    failed: true,
                    reason: I18n.t('user.username.not_available', result)
                  }));
                } else if (result.errors) {
                  return _this.set('uniqueUsernameValidation', Discourse.InputValidation.create({
                    failed: true,
                    reason: result.errors.join(' ')
                  }));
                } else {
                  return _this.set('uniqueUsernameValidation', Discourse.InputValidation.create({
                    failed: true,
                    reason: I18n.t('user.username.enter_email')
                  }));
                }
              }
            });
          }
        }, 500);
      }
    }, {
      key: 'usernameValidation',

      // Actually wait for the async name check before we're 100% sure we're good to go
      initializer: function () {
        return (function () {
          var basicValidation = this.get('basicUsernameValidation');
          var uniqueUsername = this.get('uniqueUsernameValidation');
          return uniqueUsername ? uniqueUsername : basicValidation;
        }).property('uniqueUsernameValidation', 'basicUsernameValidation');
      }
    }, {
      key: 'usernameNeedsToBeValidatedWithEmail',
      value: function () {
        return this.get('globalNicknameExists') || false;
      }
    }, {
      key: 'passwordValidation',

      // Validate the password
      initializer: function () {
        return (function () {
          if (!this.get('passwordRequired')) {
            return Discourse.InputValidation.create({ ok: true });
          }

          // If blank, fail without a reason
          var password = this.get("accountPassword");
          if (Ember.isEmpty(this.get('accountPassword'))) {
            return Discourse.InputValidation.create({ failed: true });
          }

          // If too short
          var passwordLength = this.get('isDeveloper') ? Discourse.SiteSettings.min_admin_password_length : Discourse.SiteSettings.min_password_length;
          if (password.length < passwordLength) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.password.too_short')
            });
          }

          if (this.get('rejectedPasswords').contains(password)) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.password.common')
            });
          }

          if (!Ember.isEmpty(this.get('accountUsername')) && this.get('accountPassword') === this.get('accountUsername')) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.password.same_as_username')
            });
          }

          if (!Ember.isEmpty(this.get('accountEmail')) && this.get('accountPassword') === this.get('accountEmail')) {
            return Discourse.InputValidation.create({
              failed: true,
              reason: I18n.t('user.password.same_as_email')
            });
          }

          // Looks good!
          return Discourse.InputValidation.create({
            ok: true,
            reason: I18n.t('user.password.ok')
          });
        }).property('accountPassword', 'rejectedPasswords.[]', 'accountUsername', 'accountEmail', 'isDeveloper');
      }
    }, {
      key: 'fetchConfirmationValue',
      decorators: [on('init')],
      value: function () {
        var _this2 = this;

        return Discourse.ajax('/users/hp.json').then(function (json) {
          _this2.set('accountPasswordConfirm', json.value);
          _this2.set('accountChallenge', json.challenge.split("").reverse().join(""));
        });
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          externalLogin: function (provider) {
            this.get('controllers.login').send('externalLogin', provider);
          },

          createAccount: function () {
            var self = this,
                attrs = this.getProperties('accountName', 'accountEmail', 'accountPassword', 'accountUsername', 'accountPasswordConfirm', 'accountChallenge'),
                userFields = this.get('userFields');

            // Add the userfields to the data
            if (!Ember.isEmpty(userFields)) {
              attrs.userFields = {};
              userFields.forEach(function (f) {
                attrs.userFields[f.get('field.id')] = f.get('value');
              });
            }

            this.set('formSubmitted', true);
            return Discourse.User.createAccount(attrs).then(function (result) {
              self.set('isDeveloper', false);
              if (result.success) {
                // Trigger the browser's password manager using the hidden static login form:
                var $hidden_login_form = $('#hidden-login-form');
                $hidden_login_form.find('input[name=username]').val(attrs.accountUsername);
                $hidden_login_form.find('input[name=password]').val(attrs.accountPassword);
                $hidden_login_form.find('input[name=redirect]').val(Discourse.getURL('/users/account-created'));
                $hidden_login_form.submit();
              } else {
                self.flash(result.message || I18n.t('create_account.failed'), 'error');
                if (result.is_developer) {
                  self.set('isDeveloper', true);
                }
                if (result.errors && result.errors.email && result.errors.email.length > 0 && result.values) {
                  self.get('rejectedEmails').pushObject(result.values.email);
                }
                if (result.errors && result.errors.password && result.errors.password.length > 0) {
                  self.get('rejectedPasswords').pushObject(attrs.accountPassword);
                }
                self.set('formSubmitted', false);
              }
              if (result.active && !Discourse.SiteSettings.must_approve_users) {
                return window.location.reload();
              }
            }, function () {
              self.set('formSubmitted', false);
              return self.flash(I18n.t('create_account.failed'), 'error');
            });
          }
        };
      }
    }, {
      key: '_createUserFields',
      initializer: function () {
        return (function () {
          if (!this.site) {
            return;
          }

          var userFields = this.site.get('user_fields');
          if (userFields) {
            userFields = _.sortBy(userFields, 'position').map(function (f) {
              return Ember.Object.create({ value: null, field: f });
            });
          }
          this.set('userFields', userFields);
        }).on('init');
      }
    }]));
  });
define("discourse/controllers/discovery", 
  ["discourse/lib/url","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend({
      needs: ['navigation/category', 'discovery/topics', 'application'],
      loading: false,

      category: Em.computed.alias('controllers.navigation/category.category'),
      noSubcategories: Em.computed.alias('controllers.navigation/category.noSubcategories'),

      loadedAllItems: Em.computed.not("controllers.discovery/topics.model.canLoadMore"),

      _showFooter: (function () {
        this.set("controllers.application.showFooter", this.get("loadedAllItems"));
      }).observes("loadedAllItems"),

      showMoreUrl: function (period) {
        var url = '',
            category = this.get('category');
        if (category) {
          url = '/c/' + Discourse.Category.slugFor(category) + (this.get('noSubcategories') ? '/none' : '') + '/l';
        }
        url += '/top/' + period;
        return url;
      },

      actions: {
        changePeriod: function (p) {
          DiscourseURL.routeTo(this.showMoreUrl(p));
        }
      }

    });
  });
define("discourse/controllers/discovery/categories", 
  ["discourse/controllers/discovery","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscoveryController = __dependency1__["default"];

    __exports__["default"] = DiscoveryController.extend({
      needs: ['modal', 'discovery'],

      withLogo: Em.computed.filterBy('model.categories', 'logo_url'),
      showPostsColumn: Em.computed.empty('withLogo'),

      // this makes sure the composer isn't scoping to a specific category
      category: null,

      actions: {

        refresh: function () {
          // Don't refresh if we're still loading
          if (this.get('controllers.discovery.loading')) {
            return;
          }

          // If we `send('loading')` here, due to returning true it bubbles up to the
          // router and ember throws an error due to missing `handlerInfos`.
          // Lesson learned: Don't call `loading` yourself.
          this.set('controllers.discovery.loading', true);

          var CategoryList = require('discourse/models/category-list').default;
          var parentCategory = this.get('model.parentCategory');
          var promise = parentCategory ? CategoryList.listForParent(this.store, parentCategory) : CategoryList.list(this.store);

          var self = this;
          promise.then(function (list) {
            self.set('model', list);
            self.send('loadingComplete');
          });
        }
      },

      canEdit: (function () {
        return Discourse.User.currentProp('staff');
      }).property(),

      latestTopicOnly: (function () {
        return this.get('model.categories').find(function (c) {
          return c.get('featuredTopics.length') > 1;
        }) === undefined;
      }).property('model.categories.@each.featuredTopics.length')

    });
  });
define("discourse/controllers/discovery/topics", 
  ["discourse/controllers/discovery","discourse/controllers/discovery-sortable","discourse/mixins/bulk-topic-selection","discourse/lib/computed","discourse/lib/show-modal","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    var DiscoveryController = __dependency1__["default"];
    var queryParams = __dependency2__.queryParams;
    var BulkTopicSelection = __dependency3__["default"];
    var endWith = __dependency4__.endWith;
    var showModal = __dependency5__["default"];

    var controllerOpts = {
      needs: ['discovery'],
      period: null,

      canStar: Em.computed.alias('controllers.discovery/topics.currentUser.id'),
      showTopicPostBadges: Em.computed.not('controllers.discovery/topics.new'),

      redirectedReason: Em.computed.alias('currentUser.redirected_to_top.reason'),

      order: 'default',
      ascending: false,
      expandGloballyPinned: false,
      expandAllPinned: false,

      actions: {

        changeSort: function (sortBy) {
          if (sortBy === this.get('order')) {
            this.toggleProperty('ascending');
          } else {
            this.setProperties({ order: sortBy, ascending: false });
          }

          this.get('model').refreshSort(sortBy, this.get('ascending'));
        },

        // Show newly inserted topics
        showInserted: function () {
          var tracker = this.topicTrackingState;

          // Move inserted into topics
          this.get('content').loadBefore(tracker.get('newIncoming'));
          tracker.resetTracking();
          return false;
        },

        refresh: function () {
          var _this = this;

          var filter = this.get('model.filter');

          this.setProperties({ order: "default", ascending: false });

          // Don't refresh if we're still loading
          if (this.get('controllers.discovery.loading')) {
            return;
          }

          // If we `send('loading')` here, due to returning true it bubbles up to the
          // router and ember throws an error due to missing `handlerInfos`.
          // Lesson learned: Don't call `loading` yourself.
          this.set('controllers.discovery.loading', true);

          this.store.findFiltered('topicList', { filter: filter }).then(function (list) {
            var TopicList = require('discourse/models/topic-list').default;
            TopicList.hideUniformCategory(list, _this.get('category'));

            _this.setProperties({ model: list });
            _this.resetSelected();

            if (_this.topicTrackingState) {
              _this.topicTrackingState.sync(list, filter);
            }

            _this.send('loadingComplete');
          });
        },

        resetNew: function () {
          var _this2 = this;

          this.topicTrackingState.resetNew();
          Discourse.Topic.resetNew().then(function () {
            return _this2.send('refresh');
          });
        },

        dismissReadPosts: function () {
          showModal('dismiss-read', { title: 'topics.bulk.dismiss_read' });
        }
      },

      isFilterPage: function (filter, filterType) {
        if (!filter) {
          return false;
        }
        return filter.match(new RegExp(filterType + '$', 'gi')) ? true : false;
      },

      showDismissRead: (function () {
        return this.isFilterPage(this.get('model.filter'), 'unread') && this.get('model.topics.length') > 0;
      }).property('model.filter', 'model.topics.length'),

      showResetNew: (function () {
        return this.get('model.filter') === 'new' && this.get('model.topics.length') > 0;
      }).property('model.filter', 'model.topics.length'),

      showDismissAtTop: (function () {
        return (this.isFilterPage(this.get('model.filter'), 'new') || this.isFilterPage(this.get('model.filter'), 'unread')) && this.get('model.topics.length') >= 30;
      }).property('model.filter', 'model.topics.length'),

      hasTopics: Em.computed.gt('model.topics.length', 0),
      allLoaded: Em.computed.empty('model.more_topics_url'),
      latest: endWith('model.filter', 'latest'),
      new: endWith('model.filter', 'new'),
      top: Em.computed.notEmpty('period'),
      yearly: Em.computed.equal('period', 'yearly'),
      quarterly: Em.computed.equal('period', 'quarterly'),
      monthly: Em.computed.equal('period', 'monthly'),
      weekly: Em.computed.equal('period', 'weekly'),
      daily: Em.computed.equal('period', 'daily'),

      footerMessage: (function () {
        if (!this.get('allLoaded')) {
          return;
        }

        var category = this.get('category');
        if (category) {
          return I18n.t('topics.bottom.category', { category: category.get('name') });
        } else {
          var split = (this.get('model.filter') || '').split('/');
          if (this.get('model.topics.length') === 0) {
            return I18n.t("topics.none." + split[0], {
              category: split[1]
            });
          } else {
            return I18n.t("topics.bottom." + split[0], {
              category: split[1]
            });
          }
        }
      }).property('allLoaded', 'model.topics.length'),

      footerEducation: (function () {
        if (!this.get('allLoaded') || this.get('model.topics.length') > 0 || !Discourse.User.current()) {
          return;
        }

        var split = (this.get('model.filter') || '').split('/');

        if (split[0] !== 'new' && split[0] !== 'unread') {
          return;
        }

        return I18n.t("topics.none.educate." + split[0], {
          userPrefsUrl: Discourse.getURL("/users/") + Discourse.User.currentProp("username_lower") + "/preferences"
        });
      }).property('allLoaded', 'model.topics.length')

    };

    Object.keys(queryParams).forEach(function (p) {
      // If we don't have a default value, initialize it to null
      if (typeof controllerOpts[p] === 'undefined') {
        controllerOpts[p] = null;
      }
    });

    __exports__["default"] = DiscoveryController.extend(controllerOpts, BulkTopicSelection);
  });
define("discourse/controllers/edit-category", 
  ["discourse/mixins/modal-functionality","discourse/lib/url","discourse/lib/ajax-error","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];
    var DiscourseURL = __dependency2__["default"];
    var extractError = __dependency3__.extractError;

    // Modal for editing / creating a category
    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      selectedTab: null,
      saving: false,
      deleting: false,
      panels: null,

      _initPanels: (function () {
        this.set('panels', []);
      }).on('init'),

      onShow: function () {
        this.changeSize();
        this.titleChanged();
      },

      changeSize: (function () {
        if (!Ember.isEmpty(this.get('model.description'))) {
          this.set('controllers.modal.modalClass', 'edit-category-modal full');
        } else {
          this.set('controllers.modal.modalClass', 'edit-category-modal small');
        }
      }).observes('model.description'),

      title: (function () {
        if (this.get('model.id')) {
          return I18n.t("category.edit_long") + " : " + this.get('model.name');
        }
        return I18n.t("category.create") + (this.get('model.name') ? " : " + this.get('model.name') : '');
      }).property('model.id', 'model.name'),

      titleChanged: (function () {
        this.set('controllers.modal.title', this.get('title'));
      }).observes('title'),

      disabled: (function () {
        if (this.get('saving') || this.get('deleting')) return true;
        if (!this.get('model.name')) return true;
        if (!this.get('model.color')) return true;
        return false;
      }).property('saving', 'model.name', 'model.color', 'deleting'),

      deleteDisabled: (function () {
        return this.get('deleting') || this.get('saving') || false;
      }).property('disabled', 'saving', 'deleting'),

      categoryName: (function () {
        var name = this.get('name') || "";
        return name.trim().length > 0 ? name : I18n.t("preview");
      }).property('name'),

      saveLabel: (function () {
        if (this.get('saving')) return "saving";
        if (this.get('model.isUncategorizedCategory')) return "save";
        return this.get('model.id') ? "category.save" : "category.create";
      }).property('saving', 'model.id'),

      actions: {
        saveCategory: function () {
          var self = this,
              model = this.get('model'),
              parentCategory = Discourse.Category.list().findBy('id', parseInt(model.get('parent_category_id'), 10));

          this.set('saving', true);
          model.set('parentCategory', parentCategory);

          this.get('model').save().then(function (result) {
            self.set('saving', false);
            self.send('closeModal');
            model.setProperties({ slug: result.category.slug, id: result.category.id });
            DiscourseURL.redirectTo("/c/" + Discourse.Category.slugFor(model));
          }).catch(function (error) {
            self.flash(extractError(error), 'error');
            self.set('saving', false);
          });
        },

        deleteCategory: function () {
          var self = this;
          this.set('deleting', true);

          this.send('hideModal');
          bootbox.confirm(I18n.t("category.delete_confirm"), I18n.t("no_value"), I18n.t("yes_value"), function (result) {
            if (result) {
              self.get('model').destroy().then(function () {
                // success
                self.send('closeModal');
                DiscourseURL.redirectTo("/categories");
              }, function (error) {
                self.flash(extractError(error), 'error');
                self.send('reopenModal');
                self.displayErrors([I18n.t("category.delete_error")]);
                self.set('deleting', false);
              });
            } else {
              self.send('reopenModal');
              self.set('deleting', false);
            }
          });
        }
      }

    });
  });
define("discourse/controllers/edit-topic-auto-close", 
  ["ember-addons/ember-computed-decorators","discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var observes = __dependency1__.observes;
    var ModalFunctionality = __dependency2__["default"];

    // Modal related to auto closing of topics
    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: 'auto_close_valid',
      initializer: function () {
        return true;
      }
    }, {
      key: 'auto_close_invalid',
      initializer: function () {
        return Em.computed.not('auto_close_valid');
      }
    }, {
      key: 'disable_submit',
      initializer: function () {
        return Em.computed.or('auto_close_invalid', 'loading');
      }
    }, {
      key: 'loading',
      initializer: function () {
        return false;
      }
    }, {
      key: 'setAutoCloseTime',
      decorators: [observes("model.details.auto_close_at", "model.details.auto_close_hours")],
      value: function () {
        var autoCloseTime = null;

        if (this.get("model.details.auto_close_based_on_last_post")) {
          autoCloseTime = this.get("model.details.auto_close_hours");
        } else if (this.get("model.details.auto_close_at")) {
          var closeTime = new Date(this.get("model.details.auto_close_at"));
          if (closeTime > new Date()) {
            autoCloseTime = moment(closeTime).format("YYYY-MM-DD HH:mm");
          }
        }

        this.set("model.auto_close_time", autoCloseTime);
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          saveAutoClose: function () {
            this.setAutoClose(this.get("model.auto_close_time"));
          },
          removeAutoClose: function () {
            this.setAutoClose(null);
          }
        };
      }
    }, {
      key: 'setAutoClose',
      value: function (time) {
        var _this = this;

        var self = this;
        this.set('loading', true);
        Discourse.ajax({
          url: '/t/' + this.get('model.id') + '/autoclose',
          type: 'PUT',
          dataType: 'json',
          data: {
            auto_close_time: time,
            auto_close_based_on_last_post: this.get("model.details.auto_close_based_on_last_post"),
            timezone_offset: new Date().getTimezoneOffset()
          }
        }).then(function (result) {
          self.set('loading', false);
          if (result.success) {
            _this.send('closeModal');
            _this.set('model.details.auto_close_at', result.auto_close_at);
            _this.set('model.details.auto_close_hours', result.auto_close_hours);
          } else {
            bootbox.alert(I18n.t('composer.auto_close.error'));
          }
        }).catch(function () {
          // TODO - incorrectly responds to network errors as bad input
          bootbox.alert(I18n.t('composer.auto_close.error'));
          self.set('loading', false);
        });
      }
    }, {
      key: 'willCloseImmediately',
      initializer: function () {
        return (function () {
          if (!this.get('model.details.auto_close_based_on_last_post')) {
            return false;
          }
          var closeDate = new Date(this.get('model.last_posted_at'));
          closeDate.setHours(closeDate.getHours() + this.get('model.auto_close_time'));
          return closeDate < new Date();
        }).property('model.details.auto_close_based_on_last_post', 'model.auto_close_time', 'model.last_posted_at');
      }
    }, {
      key: 'willCloseI18n',
      initializer: function () {
        return (function () {
          if (this.get('model.details.auto_close_based_on_last_post')) {
            return I18n.t('topic.auto_close_immediate', { hours: this.get('model.auto_close_time') });
          }
        }).property('model.details.auto_close_based_on_last_post', 'model.auto_close_time');
      }
    }]));
  });
define("discourse/controllers/exception", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var ButtonBackBright = {
      classes: "btn-primary",
      action: "back",
      key: "errors.buttons.back"
    },
        ButtonBackDim = {
      classes: "",
      action: "back",
      key: "errors.buttons.back"
    },
        ButtonTryAgain = {
      classes: "btn-primary",
      action: "tryLoading",
      key: "errors.buttons.again",
      icon: "refresh"
    },
        ButtonLoadPage = {
      classes: "btn-primary",
      action: "tryLoading",
      key: "errors.buttons.fixed"
    };

    // The controller for the nice error page
    __exports__["default"] = Ember.Controller.extend({
      thrown: null,
      lastTransition: null,

      isNetwork: (function () {
        // never made it on the wire
        if (this.get('thrown.readyState') === 0) return true;
        // timed out
        if (this.get('thrown.jqTextStatus') === "timeout") return true;
        return false;
      }).property(),
      isNotFound: Em.computed.equal('thrown.status', 404),
      isForbidden: Em.computed.equal('thrown.status', 403),
      isServer: Em.computed.gte('thrown.status', 500),
      isUnknown: Em.computed.none('isNetwork', 'isServer'),

      // TODO
      // make ajax requests to /srv/status with exponential backoff
      // if one succeeds, set networkFixed to true, which puts a "Fixed!" message on the page
      networkFixed: false,
      loading: false,

      _init: (function () {
        this.set('loading', false);
      }).on('init'),

      reason: (function () {
        if (this.get('isNetwork')) {
          return I18n.t('errors.reasons.network');
        } else if (this.get('isServer')) {
          return I18n.t('errors.reasons.server');
        } else if (this.get('isNotFound')) {
          return I18n.t('errors.reasons.not_found');
        } else if (this.get('isForbidden')) {
          return I18n.t('errors.reasons.forbidden');
        } else {
          // TODO
          return I18n.t('errors.reasons.unknown');
        }
      }).property('isNetwork', 'isServer', 'isUnknown'),

      requestUrl: Em.computed.alias('thrown.requestedUrl'),

      desc: (function () {
        if (this.get('networkFixed')) {
          return I18n.t('errors.desc.network_fixed');
        } else if (this.get('isNetwork')) {
          return I18n.t('errors.desc.network');
        } else if (this.get('isNotFound')) {
          return I18n.t('errors.desc.not_found');
        } else if (this.get('isServer')) {
          return I18n.t('errors.desc.server', { status: this.get('thrown.status') + " " + this.get('thrown.statusText') });
        } else {
          // TODO
          return I18n.t('errors.desc.unknown');
        }
      }).property('networkFixed', 'isNetwork', 'isServer', 'isUnknown'),

      enabledButtons: (function () {
        if (this.get('networkFixed')) {
          return [ButtonLoadPage];
        } else if (this.get('isNetwork')) {
          return [ButtonBackDim, ButtonTryAgain];
        } else {
          return [ButtonBackBright, ButtonTryAgain];
        }
      }).property('networkFixed', 'isNetwork', 'isServer', 'isUnknown'),

      actions: {
        back: function () {
          window.history.back();
        },

        tryLoading: function () {
          this.set('loading', true);
          var self = this;
          Em.run.schedule('afterRender', function () {
            self.get('lastTransition').retry();
            self.set('loading', false);
          });
        }
      }
    });
  });
define("discourse/controllers/feature-topic", 
  ["discourse/mixins/modal-functionality","discourse/helpers/category-link","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var ModalFunctionality = __dependency1__["default"];
    var categoryLinkHTML = __dependency2__.categoryLinkHTML;
    var computed = __dependency3__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ["topic"];
      }
    }, {
      key: 'loading',
      initializer: function () {
        return true;
      }
    }, {
      key: 'pinnedInCategoryCount',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'pinnedGloballyCount',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'bannerCount',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'reset',
      value: function () {
        this.setProperties({
          "model.pinnedInCategoryUntil": null,
          "model.pinnedGloballyUntil": null,
          pinInCategoryTipShownAt: false,
          pinGloballyTipShownAt: false
        });
      }
    }, {
      key: 'categoryLink',
      decorators: [computed("model.category")],
      value: function (category) {
        return categoryLinkHTML(category, { allowUncategorized: true });
      }
    }, {
      key: 'unPinMessage',
      decorators: [computed("categoryLink", "model.pinned_globally", "model.pinned_until")],
      value: function (categoryLink, pinnedGlobally, pinnedUntil) {
        var name = "topic.feature_topic.unpin";
        if (pinnedGlobally) name += "_globally";
        if (moment(pinnedUntil) > moment()) name += "_until";
        var until = moment(pinnedUntil).format("LL");

        return I18n.t(name, { categoryLink: categoryLink, until: until });
      }
    }, {
      key: 'pinMessage',
      decorators: [computed("categoryLink")],
      value: function (categoryLink) {
        return I18n.t("topic.feature_topic.pin", { categoryLink: categoryLink });
      }
    }, {
      key: 'alreadyPinnedMessage',
      decorators: [computed("categoryLink", "pinnedInCategoryCount")],
      value: function (categoryLink, count) {
        var key = count === 0 ? "topic.feature_topic.not_pinned" : "topic.feature_topic.already_pinned";
        return I18n.t(key, { categoryLink: categoryLink, count: count });
      }
    }, {
      key: 'pinDisabled',
      decorators: [computed("parsedPinnedInCategoryUntil")],
      value: function (parsedPinnedInCategoryUntil) {
        return !this._isDateValid(parsedPinnedInCategoryUntil);
      }
    }, {
      key: 'pinGloballyDisabled',
      decorators: [computed("parsedPinnedGloballyUntil")],
      value: function (parsedPinnedGloballyUntil) {
        return !this._isDateValid(parsedPinnedGloballyUntil);
      }
    }, {
      key: 'parsedPinnedInCategoryUntil',
      decorators: [computed("model.pinnedInCategoryUntil")],
      value: function (pinnedInCategoryUntil) {
        return this._parseDate(pinnedInCategoryUntil);
      }
    }, {
      key: 'parsedPinnedGloballyUntil',
      decorators: [computed("model.pinnedGloballyUntil")],
      value: function (pinnedGloballyUntil) {
        return this._parseDate(pinnedGloballyUntil);
      }
    }, {
      key: 'pinInCategoryValidation',
      decorators: [computed("pinDisabled")],
      value: function (pinDisabled) {
        if (pinDisabled) {
          return Discourse.InputValidation.create({ failed: true, reason: I18n.t("topic.feature_topic.pin_validation") });
        }
      }
    }, {
      key: 'pinGloballyValidation',
      decorators: [computed("pinGloballyDisabled")],
      value: function (pinGloballyDisabled) {
        if (pinGloballyDisabled) {
          return Discourse.InputValidation.create({ failed: true, reason: I18n.t("topic.feature_topic.pin_validation") });
        }
      }
    }, {
      key: '_parseDate',
      value: function (date) {
        return moment(date, ["YYYY-MM-DD", "YYYY-MM-DD HH:mm"]);
      }
    }, {
      key: '_isDateValid',
      value: function (parsedDate) {
        return parsedDate.isValid() && parsedDate > moment();
      }
    }, {
      key: 'onShow',
      value: function () {
        var _this = this;

        this.set("loading", true);

        return Discourse.ajax("/topics/feature_stats.json", {
          data: { category_id: this.get("model.category.id") }
        }).then(function (result) {
          if (result) {
            _this.setProperties({
              pinnedInCategoryCount: result.pinned_in_category_count,
              pinnedGloballyCount: result.pinned_globally_count,
              bannerCount: result.banner_count
            });
          }
        }).finally(function () {
          return _this.set("loading", false);
        });
      }
    }, {
      key: '_forwardAction',
      value: function (name) {
        this.get("controllers.topic").send(name);
        this.send("closeModal");
      }
    }, {
      key: '_confirmBeforePinning',
      value: function (count, name, action) {
        var _this2 = this;

        if (count < 4) {
          this._forwardAction(action);
        } else {
          this.send("hideModal");
          bootbox.confirm(I18n.t("topic.feature_topic.confirm_" + name, { count: count }), I18n.t("no_value"), I18n.t("yes_value"), function (confirmed) {
            return confirmed ? _this2._forwardAction(action) : _this2.send("reopenModal");
          });
        }
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          pin: function () {
            if (this.get("pinDisabled")) {
              this.set("pinInCategoryTipShownAt", Date.now());
            } else {
              this._forwardAction("togglePinned");
            }
          },

          pinGlobally: function () {
            if (this.get("pinGloballyDisabled")) {
              this.set("pinGloballyTipShownAt", Date.now());
            } else {
              this._confirmBeforePinning(this.get("pinnedGloballyCount"), "pin_globally", "pinGlobally");
            }
          },

          unpin: function () {
            this._forwardAction("togglePinned");
          },
          makeBanner: function () {
            this._forwardAction("makeBanner");
          },
          removeBanner: function () {
            this._forwardAction("removeBanner");
          }
        };
      }
    }]));
  });
define("discourse/controllers/flag", 
  ["discourse/mixins/modal-functionality","discourse/models/action-summary","discourse/models/post-action-type","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];
    var ActionSummary = __dependency2__["default"];
    var MAX_MESSAGE_LENGTH = __dependency3__.MAX_MESSAGE_LENGTH;

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      userDetails: null,
      selected: null,
      flagTopic: null,
      message: null,
      isWarning: false,
      topicActionByName: null,

      onShow: function () {
        this.set('selected', null);
      },

      flagsAvailable: (function () {
        var _this = this;

        if (!this.get('flagTopic')) {
          // flagging post
          var flagsAvailable = this.get('model.flagsAvailable');

          // "message user" option should be at the top
          var notifyUserIndex = flagsAvailable.indexOf(flagsAvailable.filterProperty('name_key', 'notify_user')[0]);
          if (notifyUserIndex !== -1) {
            var notifyUser = flagsAvailable[notifyUserIndex];
            flagsAvailable.splice(notifyUserIndex, 1);
            flagsAvailable.splice(0, 0, notifyUser);
          }
          return flagsAvailable;
        } else {
          var _ret = (function () {
            // flagging topic
            var self = _this,
                lookup = Em.Object.create();

            _.each(_this.get("model.actions_summary"), function (a) {
              a.flagTopic = self.get('model');
              a.actionType = self.site.topicFlagTypeById(a.id);
              var actionSummary = ActionSummary.create(a);
              lookup.set(a.actionType.get('name_key'), actionSummary);
            });
            _this.set('topicActionByName', lookup);

            return {
              v: _this.site.get('topic_flag_types').filter(function (item) {
                return _.any(self.get("model.actions_summary"), function (a) {
                  return a.id === item.get('id') && a.can_act;
                });
              })
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        }
      }).property('post', 'flagTopic', 'model.actions_summary.@each.can_act'),

      staffFlagsAvailable: (function () {
        return this.get('model.flagsAvailable').length > 1;
      }).property('post', 'flagTopic', 'model.actions_summary.@each.can_act'),

      submitEnabled: (function () {
        var selected = this.get('selected');
        if (!selected) return false;

        if (selected.get('is_custom_flag')) {
          var len = this.get('message.length') || 0;
          return len >= Discourse.SiteSettings.min_private_message_post_length && len <= MAX_MESSAGE_LENGTH;
        }
        return true;
      }).property('selected.is_custom_flag', 'message.length'),

      submitDisabled: Em.computed.not('submitEnabled'),

      // Staff accounts can "take action"
      canTakeAction: (function () {
        if (this.get("flagTopic")) return false;

        // We can only take actions on non-custom flags
        if (this.get('selected.is_custom_flag')) return false;
        return Discourse.User.currentProp('staff');
      }).property('selected.is_custom_flag'),

      submitText: (function () {
        if (this.get('selected.is_custom_flag')) {
          return "<i class='fa fa-envelope'></i>" + I18n.t(this.get('flagTopic') ? "flagging_topic.notify_action" : "flagging.notify_action");
        } else {
          return "<i class='fa fa-flag'></i>" + I18n.t(this.get('flagTopic') ? "flagging_topic.action" : "flagging.action");
        }
      }).property('selected.is_custom_flag'),

      actions: {
        takeAction: function () {
          this.send('createFlag', { takeAction: true });
          this.set('model.hidden', true);
        },

        createFlag: function (opts) {
          var _this2 = this;

          var postAction = undefined; // an instance of ActionSummary

          if (!this.get('flagTopic')) {
            postAction = this.get('model.actions_summary').findProperty('id', this.get('selected.id'));
          } else {
            postAction = this.get('topicActionByName.' + this.get('selected.name_key'));
          }

          var params = this.get('selected.is_custom_flag') ? { message: this.get('message') } : {};
          if (opts) {
            params = $.extend(params, opts);
          }

          this.send('hideModal');

          postAction.act(this.get('model'), params).then(function () {
            _this2.send('closeModal');
            if (params.message) {
              _this2.set('message', '');
            }
            _this2.appEvents.trigger('post-stream:refresh', { id: _this2.get('model.id') });
          }).catch(function (errors) {
            _this2.send('closeModal');
            if (errors && errors.responseText) {
              bootbox.alert($.parseJSON(errors.responseText).errors);
            } else {
              bootbox.alert(I18n.t('generic_error'));
            }
          });
        },

        createFlagAsWarning: function () {
          this.send('createFlag', { isWarning: true });
          this.set('model.hidden', true);
        },

        changePostActionType: function (action) {
          this.set('selected', action);
        }
      },

      canDeleteSpammer: (function () {
        if (this.get("flagTopic")) return false;

        if (Discourse.User.currentProp('staff') && this.get('selected.name_key') === 'spam') {
          return this.get('userDetails.can_be_deleted') && this.get('userDetails.can_delete_all_posts');
        } else {
          return false;
        }
      }).property('selected.name_key', 'userDetails.can_be_deleted', 'userDetails.can_delete_all_posts'),

      canSendWarning: (function () {
        if (this.get("flagTopic")) return false;

        return Discourse.User.currentProp('staff') && this.get('selected.name_key') === 'notify_user';
      }).property('selected.name_key'),

      usernameChanged: (function () {
        this.set('userDetails', null);
        this.fetchUserDetails();
      }).observes('model.username'),

      fetchUserDetails: function () {
        var _this3 = this;

        if (Discourse.User.currentProp('staff') && this.get('model.username')) {
          var AdminUser = require('admin/models/admin-user').default;
          AdminUser.find(this.get('model.user_id')).then(function (user) {
            return _this3.set('userDetails', user);
          });
        }
      }

    });
  });
define("discourse/controllers/forgot-password", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {

      // You need a value in the field to submit it.
      submitDisabled: (function () {
        return Ember.isEmpty((this.get('accountEmailOrUsername') || '').trim()) || this.get('disabled');
      }).property('accountEmailOrUsername', 'disabled'),

      onShow: function () {
        if ($.cookie('email')) {
          this.set('accountEmailOrUsername', $.cookie('email'));
        }
      },

      actions: {
        submit: function () {
          var self = this;

          if (this.get('submitDisabled')) return false;

          this.set('disabled', true);

          var success = function (data) {
            // don't tell people what happened, this keeps it more secure (ensure same on server)
            var escaped = Discourse.Utilities.escapeExpression(self.get('accountEmailOrUsername'));
            var isEmail = self.get('accountEmailOrUsername').match(/@/);

            var key = 'forgot_password.complete_' + (isEmail ? 'email' : 'username');
            var extraClass;

            if (data.user_found === true) {
              key += '_found';
              self.set('accountEmailOrUsername', '');
              bootbox.alert(I18n.t(key, { email: escaped, username: escaped }));
              self.send("closeModal");
            } else {
              if (data.user_found === false) {
                key += '_not_found';
                extraClass = 'error';
              }

              self.flash(I18n.t(key, { email: escaped, username: escaped }), extraClass);
            }
          };

          var fail = function (e) {
            self.flash(e.responseJSON.errors[0], 'error');
          };

          Discourse.ajax('/session/forgot_password', {
            data: { login: this.get('accountEmailOrUsername').trim() },
            type: 'POST'
          }).then(success, fail).finally(function () {
            setTimeout(function () {
              self.set('disabled', false);
            }, 1000);
          });

          return false;
        }
      }

    });
  });
define("discourse/controllers/full-page-search", 
  ["discourse/lib/search","discourse/lib/show-modal","ember-addons/ember-computed-decorators","discourse/models/category","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var translateResults = __dependency1__.translateResults;
    var searchContextDescription = __dependency1__.searchContextDescription;
    var getSearchKey = __dependency1__.getSearchKey;
    var isValidSearchTerm = __dependency1__.isValidSearchTerm;
    var showModal = __dependency2__["default"];
    var computed = __dependency3__.default;
    var observes = __dependency3__.observes;
    var Category = __dependency4__["default"];

    var SortOrders = [{ name: I18n.t('search.relevance'), id: 0 }, { name: I18n.t('search.latest_post'), id: 1, term: 'order:latest' }, { name: I18n.t('search.most_liked'), id: 2, term: 'order:likes' }, { name: I18n.t('search.most_viewed'), id: 3, term: 'order:views' }];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ["application"];
      }
    }, {
      key: 'loading',
      initializer: function () {
        return Em.computed.not("model");
      }
    }, {
      key: 'queryParams',
      initializer: function () {
        return ["q", "context_id", "context", "skip_context"];
      }
    }, {
      key: 'q',
      initializer: function () {
        return null;
      }
    }, {
      key: 'selected',
      initializer: function () {
        return [];
      }
    }, {
      key: 'context_id',
      initializer: function () {
        return null;
      }
    }, {
      key: 'context',
      initializer: function () {
        return null;
      }
    }, {
      key: 'searching',
      initializer: function () {
        return false;
      }
    }, {
      key: 'sortOrder',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'sortOrders',
      initializer: function () {
        return SortOrders;
      }
    }, {
      key: 'resultCount',
      decorators: [computed('model.posts')],
      value: function (posts) {
        return posts && posts.length;
      }
    }, {
      key: 'hasAutofocus',
      decorators: [computed('q')],
      value: function (q) {
        return Em.isEmpty(q);
      }
    }, {
      key: 'searchContextEnabled',
      decorators: [computed('skip_context', 'context')],
      initializer: function () {
        return {
          get: function (skip, context) {
            return !skip && context || skip === "false";
          },
          set: function (val) {
            this.set('skip_context', val ? "false" : "true");
          }
        };
      }
    }, {
      key: 'searchContextDescription',
      decorators: [computed('context', 'context_id')],
      value: function (context, id) {
        var name = id;
        if (context === 'category') {
          var category = Category.findById(id);
          if (!category) {
            return;
          }

          name = category.get('name');
        }
        return searchContextDescription(context, name);
      }
    }, {
      key: 'searchActive',
      decorators: [computed('q')],
      value: function (q) {
        return isValidSearchTerm(q);
      }
    }, {
      key: 'searchButtonDisabled',
      decorators: [computed('searchTerm', 'searching')],
      value: function (searchTerm, searching) {
        return !!(searching || !isValidSearchTerm(searchTerm));
      }
    }, {
      key: 'noSortQ',
      decorators: [computed('q')],
      value: function (q) {
        if (q) {
          SortOrders.forEach(function (order) {
            if (q.indexOf(order.term) > -1) {
              q = q.replace(order.term, "");
              q = q.trim();
            }
          });
        }
        return Discourse.Utilities.escapeExpression(q);
      }
    }, {
      key: '_searchOnSortChange',
      initializer: function () {
        return true;
      }
    }, {
      key: 'setSearchTerm',
      value: function (term) {
        var _this = this;

        this._searchOnSortChange = false;
        if (term) {
          SortOrders.forEach(function (order) {
            if (term.indexOf(order.term) > -1) {
              _this.set('sortOrder', order.id);
              term = term.replace(order.term, "");
              term = term.trim();
            }
          });
        }
        this._searchOnSortChange = true;
        this.set('searchTerm', term);
      }
    }, {
      key: 'triggerSearch',
      decorators: [observes('sortOrder')],
      value: function () {
        if (this._searchOnSortChange) {
          this.search();
        }
      }
    }, {
      key: 'modelChanged',
      decorators: [observes('model')],
      value: function () {
        if (this.get("searchTerm") !== this.get("q")) {
          this.setSearchTerm(this.get("q"));
        }
      }
    }, {
      key: 'showLikeCount',
      decorators: [computed('q')],
      value: function (q) {
        return q && q.indexOf("order:likes") > -1;
      }
    }, {
      key: 'qChanged',
      decorators: [observes('q')],
      value: function () {
        var model = this.get("model");
        if (model && this.get("model.q") !== this.get("q")) {
          this.setSearchTerm(this.get("q"));
          this.send("search");
        }
      }
    }, {
      key: '_showFooter',
      decorators: [observes('loading')],
      value: function () {
        this.set("controllers.application.showFooter", !this.get("loading"));
      }
    }, {
      key: 'canBulkSelect',
      initializer: function () {
        return Em.computed.alias('currentUser.staff');
      }
    }, {
      key: 'search',
      value: function () {
        var _this2 = this;

        if (this.get("searching")) return;
        this.set("searching", true);

        var router = Discourse.__container__.lookup('router:main');

        var args = { q: this.get("searchTerm") };

        var sortOrder = this.get("sortOrder");
        if (sortOrder && SortOrders[sortOrder].term) {
          args.q += " " + SortOrders[sortOrder].term;
        }

        this.set("q", args.q);
        this.set("model", null);

        var skip = this.get("skip_context");
        if (!skip && this.get('context') || skip === "false") {
          args.search_context = {
            type: this.get('context'),
            id: this.get('context_id')
          };
        }

        var searchKey = getSearchKey(args);

        Discourse.ajax("/search", { data: args }).then(function (results) {
          var model = translateResults(results) || {};
          router.transientCache('lastSearch', { searchKey: searchKey, model: model }, 5);
          _this2.set("model", model);
        }).finally(function () {
          _this2.set("searching", false);
        });
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {

          selectAll: function () {
            this.get('selected').addObjects(this.get('model.posts').map(function (r) {
              return r.topic;
            }));
            // Doing this the proper way is a HUGE pain,
            // we can hack this to work by observing each on the array
            // in the component, however, when we select ANYTHING, we would force
            // 50 traversals of the list
            // This hack is cheap and easy
            $('.fps-result input[type=checkbox]').prop('checked', true);
          },

          clearAll: function () {
            this.get('selected').clear();
            $('.fps-result input[type=checkbox]').prop('checked', false);
          },

          toggleBulkSelect: function () {
            this.toggleProperty('bulkSelectEnabled');
            this.get('selected').clear();
          },

          refresh: function () {
            this.set('bulkSelectEnabled', false);
            this.get('selected').clear();
            this.search();
          },

          showSearchHelp: function () {
            // TODO: dupe code should be centralized
            Discourse.ajax("/static/search_help.html", { dataType: 'html' }).then(function (model) {
              showModal('searchHelp', { model: model });
            });
          },

          search: function () {
            if (this.get("searchButtonDisabled")) return;
            this.search();
          }
        };
      }
    }]));
  });
define("discourse/controllers/group-index", 
  ["discourse/lib/computed","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var fmt = __dependency1__.fmt;

    __exports__["default"] = Ember.ArrayController.extend({
      needs: ['group'],
      loading: false,
      emptyText: fmt('type', 'groups.empty.%@'),

      actions: {
        loadMore: function () {
          var _this = this;

          if (this.get('loading')) {
            return;
          }
          this.set('loading', true);
          var posts = this.get('model');
          if (posts && posts.length) {
            var beforePostId = posts[posts.length - 1].get('id');
            var group = this.get('controllers.group.model');

            var opts = { beforePostId: beforePostId, type: this.get('type') };
            group.findPosts(opts).then(function (newPosts) {
              posts.addObjects(newPosts);
              _this.set('loading', false);
            });
          }
        }
      }
    });
  });
define("discourse/controllers/group", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__.default;
    var observes = __dependency1__.observes;

    var Tab = Em.Object.extend(_createDecoratedObject([{
      key: 'location',
      decorators: [computed('name')],
      value: function (name) {
        return 'group.' + name;
      }
    }, {
      key: 'message',
      decorators: [computed('name')],
      value: function (name) {
        return I18n.t('groups.' + name);
      }
    }]));

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'counts',
      initializer: function () {
        return null;
      }
    }, {
      key: 'showing',
      initializer: function () {
        return 'posts';
      }
    }, {
      key: 'countsChanged',
      decorators: [observes('counts')],
      value: function () {
        var counts = this.get('counts');
        this.get('tabs').forEach(function (tab) {
          tab.set('count', counts.get(tab.get('name')));
        });
      }
    }, {
      key: 'showingChanged',
      decorators: [observes('showing')],
      value: function () {
        var showing = this.get('showing');

        this.get('tabs').forEach(function (tab) {
          tab.set('active', showing === tab.get('name'));
        });
      }
    }, {
      key: 'tabs',
      initializer: function () {
        return [Tab.create({ name: 'posts', active: true, 'location': 'group.index' }), Tab.create({ name: 'topics' }), Tab.create({ name: 'mentions' }), Tab.create({ name: 'members' }), Tab.create({ name: 'messages' })];
      }
    }]));
  });
define("discourse/controllers/group/members", 
  ["discourse/lib/ajax-error","ember-addons/ember-computed-decorators","discourse/models/group","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var popupAjaxError = __dependency1__.popupAjaxError;
    var computed = __dependency2__["default"];
    var Group = __dependency3__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'loading',
      initializer: function () {
        return false;
      }
    }, {
      key: 'limit',
      initializer: function () {
        return null;
      }
    }, {
      key: 'offset',
      initializer: function () {
        return null;
      }
    }, {
      key: 'isOwner',
      decorators: [computed('model.owners.[]')],
      value: function (owners) {
        if (this.get('currentUser.admin')) {
          return true;
        }
        var currentUserId = this.get('currentUser.id');
        if (currentUserId) {
          return !!owners.findBy('id', currentUserId);
        }
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          removeMember: function (user) {
            this.get('model').removeMember(user);
          },

          addMembers: function () {
            var _this = this;

            var usernames = this.get('usernames');
            if (usernames && usernames.length > 0) {
              this.get('model').addMembers(usernames).then(function () {
                return _this.set('usernames', []);
              }).catch(popupAjaxError);
            }
          },

          loadMore: function () {
            var _this2 = this;

            if (this.get("loading")) {
              return;
            }
            if (this.get("model.members.length") >= this.get("model.user_count")) {
              return;
            }

            this.set("loading", true);

            Group.loadMembers(this.get("model.name"), this.get("model.members.length"), this.get("limit")).then(function (result) {
              _this2.get("model.members").addObjects(result.members.map(function (member) {
                return Discourse.User.create(member);
              }));
              _this2.setProperties({
                loading: false,
                user_count: result.meta.total,
                limit: result.meta.limit,
                offset: Math.min(result.meta.offset + result.meta.limit, result.meta.total)
              });
            });
          }
        };
      }
    }]));
  });
define("discourse/controllers/header", 
  ["discourse/components/site-header","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.addFlagProperty = addFlagProperty;
    var realAddFlagProperty = __dependency1__.addFlagProperty;

    function addFlagProperty(prop) {
      Ember.warn("importing `addFlagProperty` is deprecated. Use the PluginAPI instead");
      realAddFlagProperty(prop);
    }
  });
define("discourse/controllers/history", 
  ["discourse/mixins/modal-functionality","discourse/helpers/category-link","ember-addons/ember-computed-decorators","discourse/lib/computed","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var ModalFunctionality = __dependency1__["default"];
    var categoryBadgeHTML = __dependency2__.categoryBadgeHTML;
    var computed = __dependency3__["default"];
    var propertyGreaterThan = __dependency4__.propertyGreaterThan;
    var propertyLessThan = __dependency4__.propertyLessThan;

    function customTagArray(fieldName) {
      return (function () {
        var val = this.get(fieldName);
        if (!val) {
          return val;
        }
        if (!Array.isArray(val)) {
          val = [val];
        }
        return val;
      }).property(fieldName);
    }

    // This controller handles displaying of history
    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: 'loading',
      initializer: function () {
        return true;
      }
    }, {
      key: 'viewMode',
      initializer: function () {
        return "side_by_side";
      }
    }, {
      key: '_changeViewModeOnMobile',
      initializer: function () {
        return (function () {
          if (this.site.mobileView) {
            this.set("viewMode", "inline");
          }
        }).on("init");
      }
    }, {
      key: 'previousTagChanges',
      initializer: function () {
        return customTagArray('model.tags_changes.previous');
      }
    }, {
      key: 'currentTagChanges',
      initializer: function () {
        return customTagArray('model.tags_changes.current');
      }
    }, {
      key: 'revisionsText',
      decorators: [computed('previousVersion', 'model.current_version', 'model.version_count')],
      value: function (previous, current, total) {
        return I18n.t("post.revisions.controls.comparing_previous_to_current_out_of_total", {
          previous: previous, current: current, total: total
        });
      }
    }, {
      key: 'refresh',
      value: function (postId, postVersion) {
        var _this = this;

        this.set("loading", true);

        Discourse.Post.loadRevision(postId, postVersion).then(function (result) {
          _this.setProperties({ loading: false, model: result });
        });
      }
    }, {
      key: 'hide',
      value: function (postId, postVersion) {
        var _this2 = this;

        Discourse.Post.hideRevision(postId, postVersion).then(function () {
          return _this2.refresh(postId, postVersion);
        });
      }
    }, {
      key: 'show',
      value: function (postId, postVersion) {
        var _this3 = this;

        Discourse.Post.showRevision(postId, postVersion).then(function () {
          return _this3.refresh(postId, postVersion);
        });
      }
    }, {
      key: 'revert',
      value: function (post, postVersion) {
        var _this4 = this;

        post.revertToRevision(postVersion).then(function (result) {
          _this4.refresh(post.get('id'), postVersion);
          if (result.topic) {
            post.set('topic.slug', result.topic.slug);
            post.set('topic.title', result.topic.title);
            post.set('topic.fancy_title', result.topic.fancy_title);
          }
          if (result.category_id) {
            post.set('topic.category', Discourse.Category.findById(result.category_id));
          }
          _this4.send("closeModal");
        }).catch(function (e) {
          if (e.jqXHR.responseJSON && e.jqXHR.responseJSON.errors && e.jqXHR.responseJSON.errors[0]) {
            bootbox.alert(e.jqXHR.responseJSON.errors[0]);
          }
        });
      }
    }, {
      key: 'createdAtDate',
      decorators: [computed('model.created_at')],
      value: function (createdAt) {
        return moment(createdAt).format("LLLL");
      }
    }, {
      key: 'previousVersion',
      decorators: [computed('model.current_version')],
      value: function (current) {
        return current - 1;
      }
    }, {
      key: 'displayGoToPrevious',
      decorators: [computed('model.current_revision', 'model.previous_revision')],
      value: function (current, prev) {
        return prev && current > prev;
      }
    }, {
      key: 'displayRevisions',
      initializer: function () {
        return Ember.computed.gt("model.version_count", 2);
      }
    }, {
      key: 'displayGoToFirst',
      initializer: function () {
        return propertyGreaterThan("model.current_revision", "model.first_revision");
      }
    }, {
      key: 'displayGoToNext',
      initializer: function () {
        return propertyLessThan("model.current_revision", "model.next_revision");
      }
    }, {
      key: 'displayGoToLast',
      initializer: function () {
        return propertyLessThan("model.current_revision", "model.next_revision");
      }
    }, {
      key: 'hideGoToFirst',
      initializer: function () {
        return Ember.computed.not("displayGoToFirst");
      }
    }, {
      key: 'hideGoToPrevious',
      initializer: function () {
        return Ember.computed.not("displayGoToPrevious");
      }
    }, {
      key: 'hideGoToNext',
      initializer: function () {
        return Ember.computed.not("displayGoToNext");
      }
    }, {
      key: 'hideGoToLast',
      initializer: function () {
        return Ember.computed.not("displayGoToLast");
      }
    }, {
      key: 'loadFirstDisabled',
      initializer: function () {
        return Ember.computed.or("loading", "hideGoToFirst");
      }
    }, {
      key: 'loadPreviousDisabled',
      initializer: function () {
        return Ember.computed.or("loading", "hideGoToPrevious");
      }
    }, {
      key: 'loadNextDisabled',
      initializer: function () {
        return Ember.computed.or("loading", "hideGoToNext");
      }
    }, {
      key: 'loadLastDisabled',
      initializer: function () {
        return Ember.computed.or("loading", "hideGoToLast");
      }
    }, {
      key: 'displayShow',
      decorators: [computed('model.previous_hidden')],
      value: function (prevHidden) {
        return prevHidden && this.currentUser && this.currentUser.get('staff');
      }
    }, {
      key: 'displayHide',
      decorators: [computed('model.previous_hidden')],
      value: function (prevHidden) {
        return !prevHidden && this.currentUser && this.currentUser.get('staff');
      }
    }, {
      key: 'displayRevert',
      decorators: [computed()],
      value: function () {
        return this.currentUser && this.currentUser.get('staff');
      }
    }, {
      key: 'isEitherRevisionHidden',
      initializer: function () {
        return Ember.computed.or("model.previous_hidden", "model.current_hidden");
      }
    }, {
      key: 'hiddenClasses',
      decorators: [computed('model.previous_hidden', 'model.current_hidden', 'displayingInline')],
      value: function (prevHidden, currentHidden, displayingInline) {
        if (displayingInline) {
          return this.get("isEitherRevisionHidden") ? "hidden-revision-either" : null;
        } else {
          var result = [];
          if (prevHidden) {
            result.push("hidden-revision-previous");
          }
          if (currentHidden) {
            result.push("hidden-revision-current");
          }
          return result.join(" ");
        }
      }
    }, {
      key: 'displayingInline',
      initializer: function () {
        return Em.computed.equal("viewMode", "inline");
      }
    }, {
      key: 'displayingSideBySide',
      initializer: function () {
        return Em.computed.equal("viewMode", "side_by_side");
      }
    }, {
      key: 'displayingSideBySideMarkdown',
      initializer: function () {
        return Em.computed.equal("viewMode", "side_by_side_markdown");
      }
    }, {
      key: 'inlineClass',
      decorators: [computed("displayingInline")],
      value: function (displayingInline) {
        return displayingInline ? "btn-primary" : "";
      }
    }, {
      key: 'sideBySideClass',
      decorators: [computed("displayingSideBySide")],
      value: function (displayingSideBySide) {
        return displayingSideBySide ? "btn-primary" : "";
      }
    }, {
      key: 'sideBySideMarkdownClass',
      decorators: [computed("displayingSideBySideMarkdown")],
      value: function (displayingSideBySideMarkdown) {
        return displayingSideBySideMarkdown ? "btn-primary" : "";
      }
    }, {
      key: 'previousCategory',
      decorators: [computed('model.category_id_changes')],
      value: function (changes) {
        if (changes) {
          var category = Discourse.Category.findById(changes["previous"]);
          return categoryBadgeHTML(category, { allowUncategorized: true });
        }
      }
    }, {
      key: 'currentCategory',
      decorators: [computed('model.category_id_changes')],
      value: function (changes) {
        if (changes) {
          var category = Discourse.Category.findById(changes["current"]);
          return categoryBadgeHTML(category, { allowUncategorized: true });
        }
      }
    }, {
      key: 'wikiDisabled',
      decorators: [computed('model.wiki_changes')],
      value: function (changes) {
        return changes && !changes['current'];
      }
    }, {
      key: 'postTypeDisabled',
      decorators: [computed('model.post_type_changes')],
      value: function (changes) {
        return changes && changes['current'] !== this.site.get('post_types.moderator_action');
      }
    }, {
      key: 'titleDiff',
      decorators: [computed('viewMode', 'model.title_changes')],
      value: function (viewMode) {
        if (viewMode === "side_by_side_markdown") {
          viewMode = "side_by_side";
        }
        return this.get("model.title_changes." + viewMode);
      }
    }, {
      key: 'bodyDiff',
      decorators: [computed('viewMode', 'model.body_changes')],
      value: function (viewMode) {
        return this.get("model.body_changes." + viewMode);
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          loadFirstVersion: function () {
            this.refresh(this.get("model.post_id"), this.get("model.first_revision"));
          },
          loadPreviousVersion: function () {
            this.refresh(this.get("model.post_id"), this.get("model.previous_revision"));
          },
          loadNextVersion: function () {
            this.refresh(this.get("model.post_id"), this.get("model.next_revision"));
          },
          loadLastVersion: function () {
            this.refresh(this.get("model.post_id"), this.get("model.last_revision"));
          },

          hideVersion: function () {
            this.hide(this.get("model.post_id"), this.get("model.current_revision"));
          },
          showVersion: function () {
            this.show(this.get("model.post_id"), this.get("model.current_revision"));
          },

          revertToVersion: function () {
            this.revert(this.get("post"), this.get("model.current_revision"));
          },

          displayInline: function () {
            this.set("viewMode", "inline");
          },
          displaySideBySide: function () {
            this.set("viewMode", "side_by_side");
          },
          displaySideBySideMarkdown: function () {
            this.set("viewMode", "side_by_side_markdown");
          }
        };
      }
    }]));
  });
define("discourse/controllers/invite", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      needs: ['user-invited-show'],

      // If this isn't defined, it will proxy to the user model on the preferences
      // page which is wrong.
      emailOrUsername: null,
      inviteIcon: "envelope",

      isAdmin: (function () {
        return Discourse.User.currentProp("admin");
      }).property(),

      disabled: (function () {
        if (this.get('model.saving')) return true;
        if (Ember.isEmpty(this.get('emailOrUsername'))) return true;
        var emailOrUsername = this.get('emailOrUsername').trim();
        // when inviting to forum, email must be valid
        if (!this.get('invitingToTopic') && !Discourse.Utilities.emailValid(emailOrUsername)) return true;
        // normal users (not admin) can't invite users to private topic via email
        if (!this.get('isAdmin') && this.get('isPrivateTopic') && Discourse.Utilities.emailValid(emailOrUsername)) return true;
        // when inviting to private topic via email, group name must be specified
        if (this.get('isPrivateTopic') && Ember.isEmpty(this.get('model.groupNames')) && Discourse.Utilities.emailValid(emailOrUsername)) return true;
        if (this.get('model.details.can_invite_to')) return false;
        return false;
      }).property('isAdmin', 'emailOrUsername', 'invitingToTopic', 'isPrivateTopic', 'model.groupNames', 'model.saving'),

      disabledCopyLink: (function () {
        if (this.get('model.saving')) return true;
        if (Ember.isEmpty(this.get('emailOrUsername'))) return true;
        var emailOrUsername = this.get('emailOrUsername').trim();
        // email must be valid
        if (!Discourse.Utilities.emailValid(emailOrUsername)) return true;
        // normal users (not admin) can't invite users to private topic via email
        if (!this.get('isAdmin') && this.get('isPrivateTopic') && Discourse.Utilities.emailValid(emailOrUsername)) return true;
        // when inviting to private topic via email, group name must be specified
        if (this.get('isPrivateTopic') && Ember.isEmpty(this.get('model.groupNames')) && Discourse.Utilities.emailValid(emailOrUsername)) return true;
        return false;
      }).property('emailOrUsername', 'model.saving', 'isPrivateTopic', 'model.groupNames'),

      buttonTitle: (function () {
        return this.get('model.saving') ? 'topic.inviting' : 'topic.invite_reply.action';
      }).property('model.saving'),

      // We are inviting to a topic if the model isn't the current user.
      // The current user would mean we are inviting to the forum in general.
      invitingToTopic: (function () {
        return this.get('model') !== this.currentUser;
      }).property('model'),

      showCopyInviteButton: (function () {
        return !Discourse.SiteSettings.enable_sso && !this.get('isMessage');
      }).property('isMessage'),

      topicId: Ember.computed.alias('model.id'),

      // Is Private Topic? (i.e. visible only to specific group members)
      isPrivateTopic: Em.computed.and('invitingToTopic', 'model.category.read_restricted'),

      // Is Private Message?
      isMessage: Em.computed.equal('model.archetype', 'private_message'),

      // Allow Existing Members? (username autocomplete)
      allowExistingMembers: (function () {
        return this.get('invitingToTopic');
      }).property('invitingToTopic'),

      // Show Groups? (add invited user to private group)
      showGroups: (function () {
        return this.get('isAdmin') && (Discourse.Utilities.emailValid(this.get('emailOrUsername')) || this.get('isPrivateTopic') || !this.get('invitingToTopic')) && !Discourse.SiteSettings.enable_sso && Discourse.SiteSettings.enable_local_logins && !this.get('isMessage');
      }).property('isAdmin', 'emailOrUsername', 'isPrivateTopic', 'isMessage', 'invitingToTopic'),

      // Instructional text for the modal.
      inviteInstructions: (function () {
        if (Discourse.SiteSettings.enable_sso || !Discourse.SiteSettings.enable_local_logins) {
          // inviting existing user when SSO enabled
          return I18n.t('topic.invite_reply.sso_enabled');
        } else if (this.get('isMessage')) {
          // inviting to a message
          return I18n.t('topic.invite_private.email_or_username');
        } else if (this.get('invitingToTopic')) {
          // inviting to a private/public topic
          if (this.get('isPrivateTopic') && !this.get('isAdmin')) {
            // inviting to a private topic and is not admin
            return I18n.t('topic.invite_reply.to_username');
          } else {
            // when inviting to a topic, display instructions based on provided entity
            if (Ember.isEmpty(this.get('emailOrUsername'))) {
              return I18n.t('topic.invite_reply.to_topic_blank');
            } else if (Discourse.Utilities.emailValid(this.get('emailOrUsername'))) {
              this.set("inviteIcon", "envelope");
              return I18n.t('topic.invite_reply.to_topic_email');
            } else {
              this.set("inviteIcon", "hand-o-right");
              return I18n.t('topic.invite_reply.to_topic_username');
            }
          }
        } else {
          // inviting to forum
          return I18n.t('topic.invite_reply.to_forum');
        }
      }).property('isMessage', 'invitingToTopic', 'emailOrUsername'),

      // Instructional text for the group selection.
      groupInstructions: (function () {
        return this.get('isPrivateTopic') ? I18n.t('topic.automatically_add_to_groups_required') : I18n.t('topic.automatically_add_to_groups_optional');
      }).property('isPrivateTopic'),

      groupFinder: function (term) {
        var Group = require('discourse/models/group').default;
        return Group.findAll({ search: term, ignore_automatic: true });
      },

      successMessage: (function () {
        if (this.get('model.inviteLink')) {
          return I18n.t('user.invited.generated_link_message', { inviteLink: this.get('model.inviteLink'), invitedEmail: this.get('emailOrUsername') });
        } else if (this.get('isMessage')) {
          return I18n.t('topic.invite_private.success');
        } else if (Discourse.Utilities.emailValid(this.get('emailOrUsername'))) {
          return I18n.t('topic.invite_reply.success_email', { emailOrUsername: this.get('emailOrUsername') });
        } else {
          return I18n.t('topic.invite_reply.success_username');
        }
      }).property('model.inviteLink', 'isMessage', 'emailOrUsername'),

      errorMessage: (function () {
        return this.get('isMessage') ? I18n.t('topic.invite_private.error') : I18n.t('topic.invite_reply.error');
      }).property('isMessage'),

      placeholderKey: (function () {
        return Discourse.SiteSettings.enable_sso || !Discourse.SiteSettings.enable_local_logins ? 'topic.invite_reply.username_placeholder' : 'topic.invite_private.email_or_username_placeholder';
      }).property(),

      // Reset the modal to allow a new user to be invited.
      reset: function () {
        this.set('emailOrUsername', null);
        this.get('model').setProperties({
          groupNames: null,
          error: false,
          saving: false,
          finished: false,
          inviteLink: null
        });
      },

      actions: {

        createInvite: function () {
          var _this = this;

          var Invite = require('discourse/models/invite').default;
          var self = this;

          if (this.get('disabled')) {
            return;
          }

          var groupNames = this.get('model.groupNames'),
              userInvitedController = this.get('controllers.user-invited-show'),
              model = this.get('model');

          model.setProperties({ saving: true, error: false });

          return this.get('model').createInvite(this.get('emailOrUsername').trim(), groupNames).then(function (result) {
            model.setProperties({ saving: false, finished: true });
            if (!_this.get('invitingToTopic')) {
              Invite.findInvitedBy(_this.currentUser, userInvitedController.get('filter')).then(function (invite_model) {
                userInvitedController.set('model', invite_model);
                userInvitedController.set('totalInvites', invite_model.invites.length);
              });
            } else if (_this.get('isMessage') && result && result.user) {
              _this.get('model.details.allowed_users').pushObject(Ember.Object.create(result.user));
            }
          }).catch(function (e) {
            if (e.jqXHR.responseJSON && e.jqXHR.responseJSON.errors) {
              self.set("errorMessage", e.jqXHR.responseJSON.errors[0]);
            } else {
              self.set("errorMessage", self.get('isMessage') ? I18n.t('topic.invite_private.error') : I18n.t('topic.invite_reply.error'));
            }
            model.setProperties({ saving: false, error: true });
          });
        },

        generateInvitelink: function () {
          var _this2 = this;

          var Invite = require('discourse/models/invite').default;
          var self = this;

          if (this.get('disabled')) {
            return;
          }

          var groupNames = this.get('model.groupNames'),
              userInvitedController = this.get('controllers.user-invited-show'),
              model = this.get('model');

          var topicId = null;
          if (this.get('invitingToTopic')) {
            topicId = this.get('model.id');
          }

          model.setProperties({ saving: true, error: false });

          return this.get('model').generateInviteLink(this.get('emailOrUsername').trim(), groupNames, topicId).then(function (result) {
            model.setProperties({ saving: false, finished: true, inviteLink: result });
            Invite.findInvitedBy(_this2.currentUser, userInvitedController.get('filter')).then(function (invite_model) {
              userInvitedController.set('model', invite_model);
              userInvitedController.set('totalInvites', invite_model.invites.length);
            });
          }).catch(function (e) {
            if (e.jqXHR.responseJSON && e.jqXHR.responseJSON.errors) {
              self.set("errorMessage", e.jqXHR.responseJSON.errors[0]);
            } else {
              self.set("errorMessage", self.get('isMessage') ? I18n.t('topic.invite_private.error') : I18n.t('topic.invite_reply.error'));
            }
            model.setProperties({ saving: false, error: true });
          });
        }
      }

    });
  });
define("discourse/controllers/keyboard-shortcuts-help", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      needs: ['modal'],

      onShow: function () {
        this.set('controllers.modal.modalClass', 'keyboard-shortcuts-modal');
      }
    });
  });
define("discourse/controllers/login", 
  ["discourse/mixins/modal-functionality","discourse/lib/show-modal","discourse/lib/computed","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];
    var showModal = __dependency2__["default"];
    var setting = __dependency3__.setting;

    // This is happening outside of the app via popup
    var AuthErrors = ['requires_invite', 'awaiting_approval', 'awaiting_confirmation', 'admin_not_allowed_from_ip_address', 'not_allowed_from_ip_address'];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      needs: ['modal', 'createAccount', 'forgotPassword', 'application'],
      authenticate: null,
      loggingIn: false,
      loggedIn: false,

      canLoginLocal: setting('enable_local_logins'),
      loginRequired: Em.computed.alias('controllers.application.loginRequired'),

      resetForm: function () {
        this.set('authenticate', null);
        this.set('loggingIn', false);
        this.set('loggedIn', false);
      },

      /**
       Determines whether at least one login button is enabled
      **/
      hasAtLeastOneLoginButton: (function () {
        return Em.get("Discourse.LoginMethod.all").length > 0;
      }).property("Discourse.LoginMethod.all.[]"),

      loginButtonText: (function () {
        return this.get('loggingIn') ? I18n.t('login.logging_in') : I18n.t('login.title');
      }).property('loggingIn'),

      loginDisabled: Em.computed.or('loggingIn', 'loggedIn'),

      showSignupLink: (function () {
        return this.get('controllers.application.canSignUp') && !this.get('loggingIn') && Ember.isEmpty(this.get('authenticate'));
      }).property('loggingIn', 'authenticate'),

      showSpinner: (function () {
        return this.get('loggingIn') || this.get('authenticate');
      }).property('loggingIn', 'authenticate'),

      actions: {
        login: function () {
          var self = this;

          if (Ember.isEmpty(this.get('loginName')) || Ember.isEmpty(this.get('loginPassword'))) {
            self.flash(I18n.t('login.blank_username_or_password'), 'error');
            return;
          }

          this.set('loggingIn', true);

          Discourse.ajax("/session", {
            data: { login: this.get('loginName'), password: this.get('loginPassword') },
            type: 'POST'
          }).then(function (result) {
            // Successful login
            if (result.error) {
              self.set('loggingIn', false);
              if (result.reason === 'not_activated') {
                self.send('showNotActivated', {
                  username: self.get('loginName'),
                  sentTo: result.sent_to_email,
                  currentEmail: result.current_email
                });
              } else if (result.reason === 'suspended') {
                self.send("closeModal");
                bootbox.alert(result.error);
              } else {
                self.flash(result.error, 'error');
              }
            } else {
              self.set('loggedIn', true);
              // Trigger the browser's password manager using the hidden static login form:
              var $hidden_login_form = $('#hidden-login-form');
              var destinationUrl = $.cookie('destination_url');
              var shouldRedirectToUrl = self.session.get("shouldRedirectToUrl");
              var ssoDestinationUrl = $.cookie('sso_destination_url');
              $hidden_login_form.find('input[name=username]').val(self.get('loginName'));
              $hidden_login_form.find('input[name=password]').val(self.get('loginPassword'));

              if (ssoDestinationUrl) {
                $.cookie('sso_destination_url', null);
                window.location.assign(ssoDestinationUrl);
                return;
              } else if (destinationUrl) {
                // redirect client to the original URL
                $.cookie('destination_url', null);
                $hidden_login_form.find('input[name=redirect]').val(destinationUrl);
              } else if (shouldRedirectToUrl) {
                self.session.set("shouldRedirectToUrl", null);
                $hidden_login_form.find('input[name=redirect]').val(shouldRedirectToUrl);
              } else {
                $hidden_login_form.find('input[name=redirect]').val(window.location.href);
              }

              if (navigator.userAgent.match(/(iPad|iPhone|iPod)/g) && navigator.userAgent.match(/Safari/g)) {
                // In case of Safari on iOS do not submit hidden login form
                window.location.href = $hidden_login_form.find('input[name=redirect]').val();
              } else {
                $hidden_login_form.submit();
              }
              return;
            }
          }, function (e) {
            // Failed to login
            if (e.jqXHR && e.jqXHR.status === 429) {
              self.flash(I18n.t('login.rate_limit'), 'error');
            } else {
              self.flash(I18n.t('login.error'), 'error');
            }
            self.set('loggingIn', false);
          });

          return false;
        },

        externalLogin: function (loginMethod) {
          var _this = this;

          var name = loginMethod.get("name");
          var customLogin = loginMethod.get("customLogin");

          if (customLogin) {
            customLogin();
          } else {
            var authUrl = loginMethod.get('customUrl') || Discourse.getURL("/auth/" + name);
            if (loginMethod.get("fullScreenLogin")) {
              window.location = authUrl;
            } else {
              (function () {
                _this.set('authenticate', name);
                var left = _this.get('lastX') - 400;
                var top = _this.get('lastY') - 200;

                var height = loginMethod.get("frameHeight") || 400;
                var width = loginMethod.get("frameWidth") || 800;
                var w = window.open(authUrl, "_blank", "menubar=no,status=no,height=" + height + ",width=" + width + ",left=" + left + ",top=" + top);
                var self = _this;
                var timer = setInterval(function () {
                  if (!w || w.closed) {
                    clearInterval(timer);
                    self.set('authenticate', null);
                  }
                }, 1000);
              })();
            }
          }
        },

        createAccount: function () {
          var createAccountController = this.get('controllers.createAccount');
          if (createAccountController) {
            createAccountController.resetForm();
            var loginName = this.get('loginName');
            if (loginName && loginName.indexOf('@') > 0) {
              createAccountController.set("accountEmail", loginName);
            } else {
              createAccountController.set("accountUsername", loginName);
            }
          }
          this.send('showCreateAccount');
        },

        forgotPassword: function () {
          var forgotPasswordController = this.get('controllers.forgotPassword');
          if (forgotPasswordController) {
            forgotPasswordController.set("accountEmailOrUsername", this.get("loginName"));
          }
          this.send("showForgotPassword");
        }
      },

      authMessage: (function () {
        if (Ember.isEmpty(this.get('authenticate'))) return "";
        var method = Discourse.get('LoginMethod.all').findProperty("name", this.get("authenticate"));
        if (method) {
          return method.get('message');
        }
      }).property('authenticate'),

      authenticationComplete: function (options) {

        var self = this;
        function loginError(errorMsg, className) {
          showModal('login');
          Ember.run.next(function () {
            self.flash(errorMsg, className || 'success');
            self.set('authenticate', null);
          });
        }

        for (var i = 0; i < AuthErrors.length; i++) {
          var cond = AuthErrors[i];
          if (options[cond]) {
            return loginError(I18n.t("login." + cond));
          }
        }

        if (options.suspended) {
          return loginError(options.suspended_message, 'error');
        }

        // Reload the page if we're authenticated
        if (options.authenticated) {
          var destinationUrl = $.cookie('destination_url');
          var shouldRedirectToUrl = self.session.get("shouldRedirectToUrl");
          if (self.get('loginRequired') && destinationUrl) {
            // redirect client to the original URL
            $.cookie('destination_url', null);
            window.location.href = destinationUrl;
          } else if (shouldRedirectToUrl) {
            self.session.set("shouldRedirectToUrl", null);
            window.location.href = shouldRedirectToUrl;
          } else if (window.location.pathname === Discourse.getURL('/login')) {
            window.location.pathname = Discourse.getURL('/');
          } else {
            window.location.reload();
          }
          return;
        }

        var createAccountController = this.get('controllers.createAccount');
        createAccountController.setProperties({
          accountEmail: options.email,
          accountUsername: options.username,
          accountName: options.name,
          authOptions: Ember.Object.create(options)
        });
        showModal('createAccount');
      }

    });
  });
define("discourse/controllers/merge-topic", 
  ["discourse/mixins/selected-posts-count","discourse/mixins/modal-functionality","discourse/models/topic","discourse/lib/url","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    var SelectedPostsCount = __dependency1__["default"];
    var ModalFunctionality = __dependency2__["default"];
    var movePosts = __dependency3__.movePosts;
    var mergeTopic = __dependency3__.mergeTopic;
    var DiscourseURL = __dependency4__["default"];

    // Modal related to merging of topics
    __exports__["default"] = Ember.Controller.extend(SelectedPostsCount, ModalFunctionality, {
      needs: ['topic'],

      saving: false,
      selectedTopicId: null,

      topicController: Em.computed.alias('controllers.topic'),
      selectedPosts: Em.computed.alias('topicController.selectedPosts'),
      selectedReplies: Em.computed.alias('topicController.selectedReplies'),
      allPostsSelected: Em.computed.alias('topicController.allPostsSelected'),

      buttonDisabled: (function () {
        if (this.get('saving')) return true;
        return Ember.isEmpty(this.get('selectedTopicId'));
      }).property('selectedTopicId', 'saving'),

      buttonTitle: (function () {
        if (this.get('saving')) return I18n.t('saving');
        return I18n.t('topic.merge_topic.title');
      }).property('saving'),

      onShow: function () {
        this.set('controllers.modal.modalClass', 'split-modal');
      },

      actions: {
        movePostsToExistingTopic: function () {
          var topicId = this.get('model.id');

          this.set('saving', true);

          var promise = null;
          if (this.get('allPostsSelected')) {
            promise = mergeTopic(topicId, this.get('selectedTopicId'));
          } else {
            var postIds = this.get('selectedPosts').map(function (p) {
              return p.get('id');
            });
            var replyPostIds = this.get('selectedReplies').map(function (p) {
              return p.get('id');
            });

            promise = movePosts(topicId, {
              destination_topic_id: this.get('selectedTopicId'),
              post_ids: postIds,
              reply_post_ids: replyPostIds
            });
          }

          var self = this;
          promise.then(function (result) {
            // Posts moved
            self.send('closeModal');
            self.get('topicController').send('toggleMultiSelect');
            Em.run.next(function () {
              DiscourseURL.routeTo(result.url);
            });
          }).catch(function () {
            self.flash(I18n.t('topic.merge_topic.error'));
          }).finally(function () {
            self.set('saving', false);
          });
          return false;
        }
      }

    });
  });
define("discourse/controllers/modal", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend();
  });
define("discourse/controllers/navigation/categories", 
  ["discourse/controllers/navigation/default","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var NavigationDefaultController = __dependency1__["default"];

    __exports__["default"] = NavigationDefaultController.extend();
  });
define("discourse/controllers/navigation/category", 
  ["ember-addons/ember-computed-decorators","discourse/controllers/navigation/default","discourse/lib/computed","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var NavigationDefaultController = __dependency2__["default"];
    var setting = __dependency3__.setting;

    __exports__["default"] = NavigationDefaultController.extend(_createDecoratedObject([{
      key: 'subcategoryListSetting',
      initializer: function () {
        return setting('show_subcategory_list');
      }
    }, {
      key: 'showingParentCategory',
      initializer: function () {
        return Em.computed.none('category.parentCategory');
      }
    }, {
      key: 'showingSubcategoryList',
      initializer: function () {
        return Em.computed.and('subcategoryListSetting', 'showingParentCategory');
      }
    }, {
      key: 'navItems',
      decorators: [computed("showingSubcategoryList", "category", "noSubcategories")],
      value: function (showingSubcategoryList, category, noSubcategories) {
        return Discourse.NavItem.buildList(category, { noSubcategories: noSubcategories });
      }
    }]));
  });
define("discourse/controllers/not-activated", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      emailSent: false,

      onShow: function () {
        this.set("emailSent", false);
      },

      actions: {
        sendActivationEmail: function () {
          Discourse.ajax('/users/action/send_activation_email', { data: { username: this.get('username') }, type: 'POST' });
          this.set('emailSent', true);
        }
      }

    });
  });
define("discourse/controllers/post-enqueued", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({
      description: Ember.computed('model.reason', function () {
        var reason = this.get('model.reason');
        return reason ? I18n.t('queue_reason.' + reason + '.description') : I18n.t('queue.approval.description');
      })
    });
  });
define("discourse/controllers/preferences", 
  ["discourse/lib/computed","discourse/mixins/can-check-emails","discourse/lib/ajax-error","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var setting = __dependency1__.setting;
    var CanCheckEmails = __dependency2__["default"];
    var popupAjaxError = __dependency3__.popupAjaxError;
    var computed = __dependency4__["default"];

    __exports__["default"] = Ember.Controller.extend(CanCheckEmails, _createDecoratedObject([{
      key: 'selectedCategories',
      decorators: [computed("model.watchedCategories", "model.trackedCategories", "model.mutedCategories")],
      value: function (watched, tracked, muted) {
        return [].concat(watched, tracked, muted);
      }
    }, {
      key: 'saved',

      // By default we haven't saved anything
      initializer: function () {
        return false;
      }
    }, {
      key: 'newNameInput',
      initializer: function () {
        return null;
      }
    }, {
      key: 'userFields',
      decorators: [computed("model.user_fields.@each.value")],
      value: function () {
        var _this = this;

        var siteUserFields = this.site.get('user_fields');
        if (!Ember.isEmpty(siteUserFields)) {
          var _ret = (function () {
            var userFields = _this.get('model.user_fields');

            // Staff can edit fields that are not `editable`
            if (!_this.get('currentUser.staff')) {
              siteUserFields = siteUserFields.filterProperty('editable', true);
            }
            return {
              v: siteUserFields.sortBy('position').map(function (field) {
                var value = userFields ? userFields[field.get('id').toString()] : null;
                return Ember.Object.create({ value: value, field: field });
              })
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        }
      }
    }, {
      key: 'cannotDeleteAccount',
      initializer: function () {
        return Em.computed.not('currentUser.can_delete_account');
      }
    }, {
      key: 'deleteDisabled',
      initializer: function () {
        return Em.computed.or('model.isSaving', 'deleting', 'cannotDeleteAccount');
      }
    }, {
      key: 'canEditName',
      initializer: function () {
        return setting('enable_names');
      }
    }, {
      key: 'nameInstructions',
      decorators: [computed()],
      value: function () {
        return I18n.t(this.siteSettings.full_name_required ? 'user.name.instructions_required' : 'user.name.instructions');
      }
    }, {
      key: 'canSelectTitle',
      decorators: [computed("model.has_title_badges")],
      value: function (hasTitleBadges) {
        return this.siteSettings.enable_badges && hasTitleBadges;
      }
    }, {
      key: 'canChangePassword',
      decorators: [computed()],
      value: function () {
        return !this.siteSettings.enable_sso && this.siteSettings.enable_local_logins;
      }
    }, {
      key: 'canReceiveDigest',
      decorators: [computed()],
      value: function () {
        return !this.siteSettings.disable_digest_emails;
      }
    }, {
      key: 'availableLocales',
      decorators: [computed()],
      value: function () {
        return this.siteSettings.available_locales.split('|').map(function (s) {
          return { name: s, value: s };
        });
      }
    }, {
      key: 'previousRepliesOptions',
      initializer: function () {
        return [{ name: I18n.t('user.email_previous_replies.always'), value: 0 }, { name: I18n.t('user.email_previous_replies.unless_emailed'), value: 1 }, { name: I18n.t('user.email_previous_replies.never'), value: 2 }];
      }
    }, {
      key: 'digestFrequencies',
      initializer: function () {
        return [{ name: I18n.t('user.email_digests.every_30_minutes'), value: 30 }, { name: I18n.t('user.email_digests.every_hour'), value: 60 }, { name: I18n.t('user.email_digests.daily'), value: 1440 }, { name: I18n.t('user.email_digests.every_three_days'), value: 4320 }, { name: I18n.t('user.email_digests.weekly'), value: 10080 }, { name: I18n.t('user.email_digests.every_two_weeks'), value: 20160 }];
      }
    }, {
      key: 'likeNotificationFrequencies',
      initializer: function () {
        return [{ name: I18n.t('user.like_notification_frequency.always'), value: 0 }, { name: I18n.t('user.like_notification_frequency.first_time_and_daily'), value: 1 }, { name: I18n.t('user.like_notification_frequency.first_time'), value: 2 }, { name: I18n.t('user.like_notification_frequency.never'), value: 3 }];
      }
    }, {
      key: 'autoTrackDurations',
      initializer: function () {
        return [{ name: I18n.t('user.auto_track_options.never'), value: -1 }, { name: I18n.t('user.auto_track_options.immediately'), value: 0 }, { name: I18n.t('user.auto_track_options.after_30_seconds'), value: 30000 }, { name: I18n.t('user.auto_track_options.after_1_minute'), value: 60000 }, { name: I18n.t('user.auto_track_options.after_2_minutes'), value: 120000 }, { name: I18n.t('user.auto_track_options.after_3_minutes'), value: 180000 }, { name: I18n.t('user.auto_track_options.after_4_minutes'), value: 240000 }, { name: I18n.t('user.auto_track_options.after_5_minutes'), value: 300000 }, { name: I18n.t('user.auto_track_options.after_10_minutes'), value: 600000 }];
      }
    }, {
      key: 'considerNewTopicOptions',
      initializer: function () {
        return [{ name: I18n.t('user.new_topic_duration.not_viewed'), value: -1 }, { name: I18n.t('user.new_topic_duration.after_1_day'), value: 60 * 24 }, { name: I18n.t('user.new_topic_duration.after_2_days'), value: 60 * 48 }, { name: I18n.t('user.new_topic_duration.after_1_week'), value: 7 * 60 * 24 }, { name: I18n.t('user.new_topic_duration.after_2_weeks'), value: 2 * 7 * 60 * 24 }, { name: I18n.t('user.new_topic_duration.last_here'), value: -2 }];
      }
    }, {
      key: 'saveButtonText',
      decorators: [computed("model.isSaving")],
      value: function (isSaving) {
        return isSaving ? I18n.t('saving') : I18n.t('save');
      }
    }, {
      key: 'reset',
      value: function () {
        this.setProperties({
          passwordProgress: null
        });
      }
    }, {
      key: 'passwordProgress',
      initializer: function () {
        return null;
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {

          checkMailingList: function () {
            var _this2 = this;

            Em.run.next(function () {
              var postsPerDay = _this2.get('model.mailing_list_posts_per_day');
              if (!postsPerDay || postsPerDay < 2) {
                _this2.set('model.user_option.mailing_list_mode', true);
                return;
              }

              bootbox.confirm(I18n.t("user.enable_mailing_list", { count: postsPerDay }), I18n.t("no_value"), I18n.t("yes_value"), function (success) {
                if (success) {
                  _this2.set('model.user_option.mailing_list_mode', true);
                }
              });
            });
          },

          save: function () {
            var _this3 = this;

            this.set('saved', false);

            var model = this.get('model');
            var userFields = this.get('userFields');

            // Update the user fields
            if (!Ember.isEmpty(userFields)) {
              (function () {
                var modelFields = model.get('user_fields');
                if (!Ember.isEmpty(modelFields)) {
                  userFields.forEach(function (uf) {
                    modelFields[uf.get('field.id').toString()] = uf.get('value');
                  });
                }
              })();
            }

            // Cook the bio for preview
            model.set('name', this.get('newNameInput'));
            return model.save().then(function () {
              if (Discourse.User.currentProp('id') === model.get('id')) {
                Discourse.User.currentProp('name', model.get('name'));
              }
              model.set('bio_cooked', Discourse.Markdown.cook(Discourse.Markdown.sanitize(model.get('bio_raw'))));
              _this3.set('saved', true);
            }).catch(popupAjaxError);
          },

          changePassword: function () {
            var _this4 = this;

            if (!this.get('passwordProgress')) {
              this.set('passwordProgress', I18n.t("user.change_password.in_progress"));
              return this.get('model').changePassword().then(function () {
                // password changed
                _this4.setProperties({
                  changePasswordProgress: false,
                  passwordProgress: I18n.t("user.change_password.success")
                });
              }).catch(function () {
                // password failed to change
                _this4.setProperties({
                  changePasswordProgress: false,
                  passwordProgress: I18n.t("user.change_password.error")
                });
              });
            }
          },

          delete: function () {
            var _this5 = this;

            this.set('deleting', true);
            var self = this,
                message = I18n.t('user.delete_account_confirm'),
                model = this.get('model'),
                buttons = [{ label: I18n.t("cancel"),
              class: "cancel-inline",
              link: true,
              callback: function () {
                _this5.set('deleting', false);
              }
            }, { label: '<i class="fa fa-exclamation-triangle"></i> ' + I18n.t("user.delete_account"),
              class: "btn btn-danger",
              callback: function () {
                model.delete().then(function () {
                  bootbox.alert(I18n.t('user.deleted_yourself'), function () {
                    window.location.pathname = Discourse.getURL('/');
                  });
                }, function () {
                  bootbox.alert(I18n.t('user.delete_yourself_not_allowed'));
                  self.set('deleting', false);
                });
              }
            }];
            bootbox.dialog(message, buttons, { "classes": "delete-account" });
          }
        };
      }
    }]));
  });
define("discourse/controllers/preferences/about", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({
      saving: false,
      newBio: null,

      saveButtonText: (function () {
        return this.get('saving') ? I18n.t("saving") : I18n.t('user.change');
      }).property('saving')

    });
  });
define("discourse/controllers/preferences/badge-title", 
  ["discourse/mixins/badge-select-controller","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var BadgeSelectController = __dependency1__["default"];

    __exports__["default"] = Ember.ArrayController.extend(BadgeSelectController, {

      filteredList: (function () {
        return this.get('model').filterBy('badge.allow_title', true);
      }).property('model'),

      actions: {
        save: function () {
          this.setProperties({ saved: false, saving: true });

          var self = this;
          Discourse.ajax(this.get('user.path') + "/preferences/badge_title", {
            type: "PUT",
            data: { user_badge_id: self.get('selectedUserBadgeId') }
          }).then(function () {
            self.setProperties({
              saved: true,
              saving: false,
              "user.title": self.get('selectedUserBadge.badge.name')
            });
          }, function () {
            bootbox.alert(I18n.t('generic_error'));
          });
        }
      }
    });
  });
define("discourse/controllers/preferences/card-badge", 
  ["discourse/mixins/badge-select-controller","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var BadgeSelectController = __dependency1__["default"];

    __exports__["default"] = Ember.ArrayController.extend(BadgeSelectController, {
      filteredList: (function () {
        return this.get('model').filter(function (b) {
          return !Ember.isEmpty(b.get('badge.image'));
        });
      }).property('model'),

      actions: {
        save: function () {
          this.setProperties({ saved: false, saving: true });

          var self = this;
          Discourse.ajax(this.get('user.path') + "/preferences/card-badge", {
            type: "PUT",
            data: { user_badge_id: self.get('selectedUserBadgeId') }
          }).then(function () {
            self.setProperties({
              saved: true,
              saving: false,
              "user.card_image_badge": self.get('selectedUserBadge.badge.image')
            });
          }).catch(function () {
            self.set('saving', false);
            bootbox.alert(I18n.t('generic_error'));
          });
        }
      }
    });
  });
define("discourse/controllers/preferences/email", 
  ["discourse/lib/computed","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var propertyEqual = __dependency1__.propertyEqual;

    __exports__["default"] = Ember.Controller.extend({
      taken: false,
      saving: false,
      error: false,
      success: false,
      newEmail: null,

      newEmailEmpty: Em.computed.empty('newEmail'),
      saveDisabled: Em.computed.or('saving', 'newEmailEmpty', 'taken', 'unchanged'),
      unchanged: propertyEqual('newEmailLower', 'currentUser.email'),

      newEmailLower: (function () {
        return this.get('newEmail').toLowerCase().trim();
      }).property('newEmail'),

      saveButtonText: (function () {
        if (this.get('saving')) return I18n.t("saving");
        return I18n.t("user.change");
      }).property('saving'),

      actions: {
        changeEmail: function () {
          var self = this;
          this.set('saving', true);
          return this.get('content').changeEmail(this.get('newEmail')).then(function () {
            self.set('success', true);
          }, function (e) {
            self.setProperties({ error: true, saving: false });
            if (e.jqXHR.responseJSON && e.jqXHR.responseJSON.errors && e.jqXHR.responseJSON.errors[0]) {
              self.set('errorMessage', e.jqXHR.responseJSON.errors[0]);
            } else {
              self.set('errorMessage', I18n.t('user.change_email.error'));
            }
          });
        }
      }

    });
  });
define("discourse/controllers/preferences/username", 
  ["discourse/lib/computed","discourse/lib/url","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var setting = __dependency1__.setting;
    var propertyEqual = __dependency1__.propertyEqual;
    var DiscourseURL = __dependency2__["default"];

    __exports__["default"] = Ember.Controller.extend({
      taken: false,
      saving: false,
      error: false,
      errorMessage: null,
      newUsername: null,

      maxLength: setting('max_username_length'),
      minLength: setting('min_username_length'),
      newUsernameEmpty: Em.computed.empty('newUsername'),
      saveDisabled: Em.computed.or('saving', 'newUsernameEmpty', 'taken', 'unchanged', 'errorMessage'),
      unchanged: propertyEqual('newUsername', 'username'),

      checkTaken: (function () {
        if (this.get('newUsername') && this.get('newUsername').length < this.get('minLength')) {
          this.set('errorMessage', I18n.t('user.name.too_short'));
        } else {
          var self = this;
          this.set('taken', false);
          this.set('errorMessage', null);
          if (Ember.isEmpty(this.get('newUsername'))) return;
          if (this.get('unchanged')) return;
          Discourse.User.checkUsername(this.get('newUsername'), undefined, this.get('content.id')).then(function (result) {
            if (result.errors) {
              self.set('errorMessage', result.errors.join(' '));
            } else if (result.available === false) {
              self.set('taken', true);
            }
          });
        }
      }).observes('newUsername'),

      saveButtonText: (function () {
        if (this.get('saving')) return I18n.t("saving");
        return I18n.t("user.change");
      }).property('saving'),

      actions: {
        changeUsername: function () {
          var self = this;
          return bootbox.confirm(I18n.t("user.change_username.confirm"), I18n.t("no_value"), I18n.t("yes_value"), function (result) {
            if (result) {
              self.set('saving', true);
              self.get('content').changeUsername(self.get('newUsername')).then(function () {
                DiscourseURL.redirectTo("/users/" + self.get('newUsername').toLowerCase() + "/preferences");
              }, function () {
                // error
                self.set('error', true);
                self.set('saving', false);
              });
            }
          });
        }
      }

    });
  });
define("discourse/controllers/quote-button", 
  ["discourse/lib/load-script","discourse/lib/quote","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var loadScript = __dependency1__["default"];
    var Quote = __dependency2__["default"];
    var computed = __dependency3__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['topic', 'composer'];
      }
    }, {
      key: '_loadSanitizer',
      initializer: function () {
        return (function () {
          loadScript('defer/html-sanitizer-bundle');
        }).on('init');
      }
    }, {
      key: 'post',
      decorators: [computed('buffer', 'postId')],
      value: function (buffer, postId) {
        if (!postId || Ember.isEmpty(buffer)) {
          return null;
        }

        var postStream = this.get('controllers.topic.model.postStream');
        var post = postStream.findLoadedPost(postId);

        return post;
      }
    }, {
      key: 'selectText',

      // Save the currently selected text and displays the
      //  "quote reply" button
      value: function (postId) {
        // anonymous users cannot "quote-reply"
        if (!this.currentUser) return;

        // don't display the "quote-reply" button if we can't reply
        var topicDetails = this.get('controllers.topic.model.details');
        if (!(topicDetails.get('can_reply_as_new_topic') || topicDetails.get('can_create_post'))) {
          return;
        }

        var selection = window.getSelection();

        // no selections
        if (selection.isCollapsed) {
          this.set('buffer', '');
          return;
        }

        // retrieve the selected range
        var range = selection.getRangeAt(0),
            cloned = range.cloneRange(),
            $ancestor = $(range.commonAncestorContainer);

        if ($ancestor.closest('.cooked').length === 0) {
          this.set('buffer', '');
          return;
        }

        var selectedText = Discourse.Utilities.selectedText();
        if (this.get('buffer') === selectedText) return;

        // we need to retrieve the post data from the posts collection in the topic controller
        this.set('postId', postId);
        this.set('buffer', selectedText);

        // create a marker element
        var markerElement = document.createElement("span");
        // containing a single invisible character
        markerElement.appendChild(document.createTextNode("\ufeff"));

        var isMobileDevice = this.site.isMobileDevice;
        var capabilities = this.capabilities,
            isIOS = capabilities.isIOS,
            isAndroid = capabilities.isAndroid;

        // collapse the range at the beginning/end of the selection
        range.collapse(!isMobileDevice);
        // and insert it at the start of our selection range
        range.insertNode(markerElement);

        // retrieve the position of the marker
        var markerOffset = $(markerElement).offset(),
            $quoteButton = $('.quote-button');

        // remove the marker
        markerElement.parentNode.removeChild(markerElement);

        // work around Chrome that would sometimes lose the selection
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(cloned);

        // move the quote button above the marker
        Em.run.schedule('afterRender', function () {
          var topOff = markerOffset.top;
          var leftOff = markerOffset.left;

          if (isMobileDevice || isIOS || isAndroid) {
            topOff = topOff + 20;
            leftOff = Math.min(leftOff + 10, $(window).width() - $quoteButton.outerWidth());
          } else {
            topOff = topOff - $quoteButton.outerHeight() - 5;
          }

          $quoteButton.offset({ top: topOff, left: leftOff });
        });
      }
    }, {
      key: 'quoteText',
      value: function () {
        var _this = this;

        var Composer = require('discourse/models/composer').default;
        var postId = this.get('postId');
        var post = this.get('post');

        // defer load if needed, if in an expanded replies section
        if (!post) {
          var postStream = this.get('controllers.topic.model.postStream');
          return postStream.loadPost(postId).then(function (p) {
            _this.set('post', p);
            return _this.quoteText();
          });
        }

        // If we can't create a post, delegate to reply as new topic
        if (!this.get('controllers.topic.model.details.can_create_post')) {
          this.get('controllers.topic').send('replyAsNewTopic', post);
          return;
        }

        var composerController = this.get('controllers.composer');
        var composerOpts = {
          action: Composer.REPLY,
          draftKey: post.get('topic.draft_key')
        };

        if (post.get('post_number') === 1) {
          composerOpts.topic = post.get("topic");
        } else {
          composerOpts.post = post;
        }

        // If the composer is associated with a different post, we don't change it.
        var composerPost = composerController.get('content.post');
        if (composerPost && composerPost.get('id') !== this.get('post.id')) {
          composerOpts.post = composerPost;
        }

        var buffer = this.get('buffer');
        var quotedText = Quote.build(post, buffer);
        composerOpts.quote = quotedText;
        if (composerController.get('content.viewOpen') || composerController.get('content.viewDraft')) {
          this.appEvents.trigger('composer:insert-text', quotedText);
        } else {
          composerController.open(composerOpts);
        }
        this.set('buffer', '');
        return false;
      }
    }, {
      key: 'deselectText',
      value: function () {
        // clear selected text
        window.getSelection().removeAllRanges();
        // clean up the buffer
        this.set('buffer', '');
      }
    }]));
  });
define("discourse/controllers/raw-email", 
  ["discourse/mixins/modal-functionality","discourse/models/post","admin/models/incoming-email","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];
    var Post = __dependency2__["default"];
    var IncomingEmail = __dependency3__["default"];

    // This controller handles displaying of raw email
    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      rawEmail: "",

      loadRawEmail: function (postId) {
        var _this = this;

        return Post.loadRawEmail(postId).then(function (result) {
          return _this.set("rawEmail", result.raw_email);
        });
      },

      loadIncomingRawEmail: function (incomingEmailId) {
        var _this2 = this;

        return IncomingEmail.loadRawEmail(incomingEmailId).then(function (result) {
          return _this2.set("rawEmail", result.raw_email);
        });
      }

    });
  });
define("discourse/controllers/rename-tag", 
  ["discourse/mixins/modal-functionality","discourse/mixins/buffered-content","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];
    var BufferedContent = __dependency2__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, BufferedContent, {

      renameDisabled: (function () {
        var filterRegexp = new RegExp(this.site.tags_filter_regexp, "g"),
            newId = this.get('buffered.id').replace(filterRegexp, '').trim();

        return newId.length === 0 || newId === this.get('model.id');
      }).property('buffered.id', 'id'),

      actions: {
        performRename: function () {
          var tag = this.get('model'),
              self = this;
          tag.update({ id: this.get('buffered.id') }).then(function () {
            self.send('closeModal');
            self.transitionToRoute('tags.show', tag.get('id'));
          }).catch(function () {
            self.flash(I18n.t('generic_error'), 'error');
          });
        }
      }
    });
  });
define("discourse/controllers/reorder-categories", 
  ["discourse/mixins/modal-functionality","discourse/lib/ajax-error","ember-addons/ember-computed-decorators","ember","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var ModalFunctionality = __dependency1__["default"];
    // import BufferedProxy from 'ember-buffered-proxy/proxy';
    var popupAjaxError = __dependency2__.popupAjaxError;
    var on = __dependency3__.on;
    var computed = __dependency3__.default;
    var Ember = __dependency4__["default"];

    var BufferedProxy = window.BufferedProxy;var SortableArrayProxy = Ember.ArrayProxy.extend(Ember.SortableMixin);

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, Ember.Evented, _createDecoratedObject([{
      key: '_fixOrder',
      decorators: [on('init')],
      value: function () {
        this.send('fixIndices');
      }
    }, {
      key: 'categoriesBuffered',
      decorators: [computed("site.categories")],
      value: function (categories) {
        var bufProxy = Ember.ObjectProxy.extend(BufferedProxy);
        return categories.map(function (c) {
          return bufProxy.create({ content: c });
        });
      }
    }, {
      key: 'categoriesOrdered',
      initializer: function () {
        return (function () {
          return SortableArrayProxy.create({
            sortProperties: ['content.position'],
            content: this.get('categoriesBuffered')
          });
        }).property('categoriesBuffered');
      }
    }, {
      key: 'showFixIndices',
      initializer: function () {
        return (function () {
          var cats = this.get('categoriesOrdered');
          var len = cats.get('length');
          for (var i = 0; i < len; i++) {
            if (cats.objectAt(i).get('position') !== i) {
              return true;
            }
          }
          return false;
        }).property('categoriesOrdered.@each.position');
      }
    }, {
      key: 'showApplyAll',
      initializer: function () {
        return (function () {
          var anyChanged = false;
          this.get('categoriesBuffered').forEach(function (bc) {
            anyChanged = anyChanged || bc.get('hasBufferedChanges');
          });
          return anyChanged;
        }).property('categoriesBuffered.@each.hasBufferedChanges');
      }
    }, {
      key: 'saveDisabled',
      initializer: function () {
        return Ember.computed.or('showApplyAll', 'showFixIndices');
      }
    }, {
      key: 'moveDir',
      value: function (cat, dir) {
        var cats = this.get('categoriesOrdered');
        var curIdx = cats.indexOf(cat);
        var desiredIdx = curIdx + dir;
        if (desiredIdx >= 0 && desiredIdx < cats.get('length')) {
          var curPos = cat.get('position');
          cat.set('position', curPos + dir);
          var otherCat = cats.objectAt(desiredIdx);
          otherCat.set('position', curPos - dir);
          this.send('commit');
        }
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {

          moveUp: function (cat) {
            this.moveDir(cat, -1);
          },
          moveDown: function (cat) {
            this.moveDir(cat, 1);
          },

          fixIndices: function () {
            var cats = this.get('categoriesOrdered');
            var len = cats.get('length');
            for (var i = 0; i < len; i++) {
              cats.objectAt(i).set('position', i);
            }
            this.send('commit');
          },

          commit: function () {
            this.get('categoriesBuffered').forEach(function (bc) {
              if (bc.get('hasBufferedChanges')) {
                bc.applyBufferedChanges();
              }
            });
            this.propertyDidChange('categoriesBuffered');
          },

          saveOrder: function () {
            var _this = this;

            var data = {};
            this.get('categoriesBuffered').forEach(function (cat) {
              data[cat.get('id')] = cat.get('position');
            });
            Discourse.ajax('/categories/reorder', { type: 'POST', data: { mapping: JSON.stringify(data) } }).then(function () {
              return _this.send("closeModal");
            }).catch(popupAjaxError);
          }
        };
      }
    }]));
  });
define("discourse/controllers/search-help", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      needs: ['modal'],

      showGoogleSearch: (function () {
        return !Discourse.SiteSettings.login_required;
      }).property()
    });
  });
define("discourse/controllers/share", 
  ["discourse/lib/sharing","discourse/lib/formatter","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var Sharing = __dependency1__["default"];
    var longDateNoYear = __dependency2__.longDateNoYear;
    var computed = __dependency3__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['topic'];
      }
    }, {
      key: 'title',
      decorators: [computed('type', 'postNumber')],
      value: function (type, postNumber) {
        if (type === 'topic') {
          return I18n.t('share.topic');
        }
        if (postNumber) {
          return I18n.t('share.post', { postNumber: postNumber });
        } else {
          return I18n.t('share.topic');
        }
      }
    }, {
      key: 'displayDate',
      decorators: [computed('date')],
      value: function (date) {
        return longDateNoYear(new Date(date));
      }
    }, {
      key: 'actions',

      // Close the share controller
      initializer: function () {
        return {
          close: function () {
            this.setProperties({ link: '', postNumber: '' });
            return false;
          },

          share: function (source) {
            var url = source.generateUrl(this.get('link'), this.get('title'));
            if (source.shouldOpenInPopup) {
              window.open(url, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,width=600,height=' + (source.popupHeight || 315));
            } else {
              window.open(url, '_blank');
            }
          }
        };
      }
    }, {
      key: 'sources',
      decorators: [computed],
      value: function () {
        return Sharing.activeSources(this.siteSettings.share_links);
      }
    }]));
  });
define("discourse/controllers/split-topic", 
  ["discourse/mixins/selected-posts-count","discourse/mixins/modal-functionality","discourse/lib/ajax-error","discourse/models/topic","discourse/lib/url","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    var SelectedPostsCount = __dependency1__["default"];
    var ModalFunctionality = __dependency2__["default"];
    var extractError = __dependency3__.extractError;
    var movePosts = __dependency4__.movePosts;
    var DiscourseURL = __dependency5__["default"];

    // Modal related to auto closing of topics
    __exports__["default"] = Ember.Controller.extend(SelectedPostsCount, ModalFunctionality, {
      needs: ['topic'],
      topicName: null,
      saving: false,
      categoryId: null,

      topicController: Em.computed.alias('controllers.topic'),
      selectedPosts: Em.computed.alias('topicController.selectedPosts'),
      selectedReplies: Em.computed.alias('topicController.selectedReplies'),
      allPostsSelected: Em.computed.alias('topicController.allPostsSelected'),

      buttonDisabled: (function () {
        if (this.get('saving')) return true;
        return Ember.isEmpty(this.get('topicName'));
      }).property('saving', 'topicName'),

      buttonTitle: (function () {
        if (this.get('saving')) return I18n.t('saving');
        return I18n.t('topic.split_topic.action');
      }).property('saving'),

      onShow: function () {
        this.setProperties({
          'controllers.modal.modalClass': 'split-modal',
          saving: false,
          categoryId: null,
          topicName: ''
        });
      },

      actions: {
        movePostsToNewTopic: function () {
          this.set('saving', true);

          var postIds = this.get('selectedPosts').map(function (p) {
            return p.get('id');
          }),
              replyPostIds = this.get('selectedReplies').map(function (p) {
            return p.get('id');
          }),
              self = this,
              categoryId = this.get('categoryId'),
              saveOpts = {
            title: this.get('topicName'),
            post_ids: postIds,
            reply_post_ids: replyPostIds
          };

          if (!Ember.isNone(categoryId)) {
            saveOpts.category_id = categoryId;
          }

          movePosts(this.get('model.id'), saveOpts).then(function (result) {
            // Posts moved
            self.send('closeModal');
            self.get('topicController').send('toggleMultiSelect');
            Ember.run.next(function () {
              DiscourseURL.routeTo(result.url);
            });
          }).catch(function (xhr) {
            self.flash(extractError(xhr, I18n.t('topic.split_topic.error')));
          }).finally(function () {
            self.set('saving', false);
          });
          return false;
        }
      }

    });
  });
define("discourse/controllers/static", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['application'];
      }
    }, {
      key: 'showLoginButton',
      initializer: function () {
        return Em.computed.equal("model.path", "login");
      }
    }, {
      key: 'showSignupButton',
      decorators: [computed("model.path")],
      value: function () {
        return this.get("model.path") === "login" && this.get('controllers.application.canSignUp');
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          markFaqRead: function () {
            var currentUser = this.currentUser;
            if (currentUser) {
              Discourse.ajax("/users/read-faq", { method: "POST" }).then(function () {
                currentUser.set('read_faq', true);
              });
            }
          }
        };
      }
    }]));
  });
define("discourse/controllers/tags-index", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({
      sortProperties: ['count:desc', 'id'],

      sortedTags: Ember.computed.sort('model', 'sortProperties'),

      actions: {
        sortByCount: function () {
          this.set('sortProperties', ['count:desc', 'id']);
        },

        sortById: function () {
          this.set('sortProperties', ['id']);
        }
      }
    });
  });
define("discourse/controllers/tags-show", 
  ["discourse/mixins/bulk-topic-selection","discourse/models/nav-item","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var BulkTopicSelection = __dependency1__["default"];
    var NavItem = __dependency2__.default;
    var extraNavItemProperties = __dependency2__.extraNavItemProperties;
    var customNavItemHref = __dependency2__.customNavItemHref;

    if (extraNavItemProperties) {
      extraNavItemProperties(function (text, opts) {
        if (opts && opts.tagId) {
          return { tagId: opts.tagId };
        } else {
          return {};
        }
      });
    }

    if (customNavItemHref) {
      customNavItemHref(function (navItem) {
        if (navItem.get('tagId')) {
          var name = navItem.get('name');

          if (!Discourse.Site.currentProp('filters').contains(name)) {
            return null;
          }

          var path = "/tags/",
              category = navItem.get("category");

          if (category) {
            path += "c/";
            path += Discourse.Category.slugFor(category);
            if (navItem.get('noSubcategories')) {
              path += '/none';
            }
            path += "/";
          }

          path += navItem.get('tagId') + "/l/";
          return path + name.replace(' ', '-');
        } else {
          return null;
        }
      });
    }

    __exports__["default"] = Ember.Controller.extend(BulkTopicSelection, {
      needs: ["application"],

      tag: null,
      list: null,
      canAdminTag: Ember.computed.alias("currentUser.staff"),
      filterMode: null,
      navMode: 'latest',
      loading: false,
      canCreateTopic: false,
      order: 'default',
      ascending: false,
      status: null,
      state: null,
      search: null,
      max_posts: null,
      q: null,

      queryParams: ['order', 'ascending', 'status', 'state', 'search', 'max_posts', 'q'],

      navItems: (function () {
        return NavItem.buildList(this.get('category'), { tagId: this.get('tag.id'), filterMode: this.get('filterMode') });
      }).property('category', 'tag.id', 'filterMode'),

      showTagFilter: (function () {
        return Discourse.SiteSettings.show_filter_by_tag;
      }).property('category'),

      categories: (function () {
        return Discourse.Category.list();
      }).property(),

      showAdminControls: (function () {
        return this.get('canAdminTag') && !this.get('category');
      }).property('canAdminTag', 'category'),

      loadMoreTopics: function () {
        return this.get("list").loadMore();
      },

      _showFooter: (function () {
        this.set("controllers.application.showFooter", !this.get("list.canLoadMore"));
      }).observes("list.canLoadMore"),

      footerMessage: (function () {
        if (this.get('loading') || this.get('list.topics.length') !== 0) {
          return;
        }

        if (this.get('list.topics.length') === 0) {
          return I18n.t('tagging.topics.none.' + this.get('navMode'), { tag: this.get('tag.id') });
        } else {
          return I18n.t('tagging.topics.bottom.' + this.get('navMode'), { tag: this.get('tag.id') });
        }
      }).property('navMode', 'list.topics.length', 'loading'),

      actions: {
        changeSort: function (sortBy) {
          if (sortBy === this.get('order')) {
            this.toggleProperty('ascending');
          } else {
            this.setProperties({ order: sortBy, ascending: false });
          }
          this.send('invalidateModel');
        },

        refresh: function () {
          var self = this;
          // TODO: this probably doesn't work anymore
          return this.store.findFiltered('topicList', { filter: 'tags/' + this.get('tag.id') }).then(function (list) {
            self.set("list", list);
            self.resetSelected();
          });
        },

        deleteTag: function () {
          var self = this;
          bootbox.confirm(I18n.t("tagging.delete_confirm"), function (result) {
            if (!result) {
              return;
            }

            self.get("tag").destroyRecord().then(function () {
              self.transitionToRoute("tags.index");
            }).catch(function () {
              bootbox.alert(I18n.t("generic_error"));
            });
          });
        },

        changeTagNotification: function (id) {
          var tagNotification = this.get("tagNotification");
          tagNotification.update({ notification_level: id });
        }
      }
    });
  });
define("discourse/controllers/topic-bulk-actions", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    var _buttons = [];

    function addBulkButton(action, key) {
      _buttons.push({ action: action, label: "topics.bulk." + key });
    }

    // Default buttons
    addBulkButton('showChangeCategory', 'change_category');
    addBulkButton('deleteTopics', 'delete');
    addBulkButton('closeTopics', 'close_topics');
    addBulkButton('archiveTopics', 'archive_topics');
    addBulkButton('showNotificationLevel', 'notification_level');
    addBulkButton('resetRead', 'reset_read');
    addBulkButton('unlistTopics', 'unlist_topics');
    addBulkButton('showTagTopics', 'change_tags');

    // Modal for performing bulk actions on topics
    __exports__["default"] = Ember.ArrayController.extend(ModalFunctionality, {
      tags: null,
      buttonRows: null,

      emptyTags: Ember.computed.empty('tags'),

      onShow: function () {
        this.set('controllers.modal.modalClass', 'topic-bulk-actions-modal small');

        var buttonRows = [];
        var row = [];
        _buttons.forEach(function (b) {
          row.push(b);
          if (row.length === 4) {
            buttonRows.push(row);
            row = [];
          }
        });
        if (row.length) {
          buttonRows.push(row);
        }

        this.set('buttonRows', buttonRows);
        this.send('changeBulkTemplate', 'modal/bulk_actions_buttons');
      },

      perform: function (operation) {
        var _this = this;

        this.set('loading', true);

        var topics = this.get('model');
        return Discourse.Topic.bulkOperation(this.get('model'), operation).then(function (result) {
          _this.set('loading', false);
          if (result && result.topic_ids) {
            return result.topic_ids.map(function (t) {
              return topics.findBy('id', t);
            });
          }
          return result;
        }).catch(function () {
          bootbox.alert(I18n.t('generic_error'));
          _this.set('loading', false);
        });
      },

      forEachPerformed: function (operation, cb) {
        var _this2 = this;

        this.perform(operation).then(function (topics) {
          if (topics) {
            topics.forEach(cb);
            (_this2.get('refreshClosure') || Ember.k)();
            _this2.send('closeModal');
          }
        });
      },

      performAndRefresh: function (operation) {
        var _this3 = this;

        return this.perform(operation).then(function () {
          (_this3.get('refreshClosure') || Ember.k)();
          _this3.send('closeModal');
        });
      },

      actions: {
        showTagTopics: function () {
          this.set('tags', '');
          this.send('changeBulkTemplate', 'bulk-tag');
        },

        changeTags: function () {
          this.performAndRefresh({ type: 'change_tags', tags: this.get('tags') });
        },

        showChangeCategory: function () {
          this.send('changeBulkTemplate', 'modal/bulk_change_category');
          this.set('controllers.modal.modalClass', 'topic-bulk-actions-modal full');
        },

        showNotificationLevel: function () {
          this.send('changeBulkTemplate', 'modal/bulk_notification_level');
        },

        deleteTopics: function () {
          this.performAndRefresh({ type: 'delete' });
        },

        closeTopics: function () {
          this.forEachPerformed({ type: 'close' }, function (t) {
            return t.set('closed', true);
          });
        },

        archiveTopics: function () {
          this.forEachPerformed({ type: 'archive' }, function (t) {
            return t.set('archived', true);
          });
        },

        unlistTopics: function () {
          this.forEachPerformed({ type: 'unlist' }, function (t) {
            return t.set('visible', false);
          });
        },

        changeCategory: function () {
          var _this4 = this;

          var categoryId = parseInt(this.get('newCategoryId'), 10) || 0;
          var category = Discourse.Category.findById(categoryId);

          this.perform({ type: 'change_category', category_id: categoryId }).then(function (topics) {
            topics.forEach(function (t) {
              return t.set('category', category);
            });
            (_this4.get('refreshClosure') || Ember.k)();
            _this4.send('closeModal');
          });
        },

        resetRead: function () {
          this.performAndRefresh({ type: 'reset_read' });
        }
      }
    });

    __exports__.addBulkButton = addBulkButton;
  });
define("discourse/controllers/topic-entrance", 
  ["discourse/lib/url","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];

    function entranceDate(dt, showTime) {
      var today = new Date();

      if (dt.toDateString() === today.toDateString()) {
        return moment(dt).format(I18n.t("dates.time"));
      }

      if (dt.getYear() === today.getYear()) {
        // No year
        return moment(dt).format(showTime ? I18n.t("dates.long_date_without_year_with_linebreak") : I18n.t("dates.long_no_year_no_time"));
      }

      return moment(dt).format(showTime ? I18n.t('dates.long_date_with_year_with_linebreak') : I18n.t('dates.long_date_with_year_without_time'));
    }

    __exports__["default"] = Ember.Controller.extend({
      position: null,

      createdDate: (function () {
        return new Date(this.get('model.created_at'));
      }).property('model.created_at'),

      bumpedDate: (function () {
        return new Date(this.get('model.bumped_at'));
      }).property('model.bumped_at'),

      showTime: (function () {
        var diffMs = this.get('bumpedDate').getTime() - this.get('createdDate').getTime();
        return diffMs < 1000 * 60 * 60 * 24 * 2;
      }).property('createdDate', 'bumpedDate'),

      topDate: (function () {
        return entranceDate(this.get('createdDate'), this.get('showTime'));
      }).property('createdDate'),

      bottomDate: (function () {
        return entranceDate(this.get('bumpedDate'), this.get('showTime'));
      }).property('bumpedDate'),

      actions: {
        show: function (data) {
          // Show the chooser but only if the model changes
          if (this.get('model') !== data.topic) {
            this.set('model', data.topic);
            this.set('position', data.position);
          }
        },

        enterTop: function () {
          DiscourseURL.routeTo(this.get('model.url'));
        },

        enterBottom: function () {
          DiscourseURL.routeTo(this.get('model.lastPostUrl'));
        }
      }
    });
  });
define("discourse/controllers/topic-progress", 
  ["discourse/lib/url","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseURL = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend({
      needs: ['topic'],
      progressPosition: null,
      expanded: false,
      toPostIndex: null,

      actions: {
        toggleExpansion: function (opts) {
          this.toggleProperty('expanded');
          if (this.get('expanded')) {
            this.set('toPostIndex', this.get('progressPosition'));
            if (opts && opts.highlight) {
              // TODO: somehow move to view?
              Em.run.next(function () {
                $('.jump-form input').select().focus();
              });
            }
          }
        },

        jumpPost: function () {
          var postIndex = parseInt(this.get('toPostIndex'), 10);

          // Validate the post index first
          if (isNaN(postIndex) || postIndex < 1) {
            postIndex = 1;
          }
          if (postIndex > this.get('model.postStream.filteredPostsCount')) {
            postIndex = this.get('model.postStream.filteredPostsCount');
          }
          this.set('toPostIndex', postIndex);
          var stream = this.get('model.postStream'),
              postId = stream.findPostIdForPostNumber(postIndex);

          if (!postId) {
            Em.Logger.warn("jump-post code broken - requested an index outside the stream array");
            return;
          }

          var post = stream.findLoadedPost(postId);
          if (post) {
            this.jumpTo(this.get('model').urlForPostNumber(post.get('post_number')));
          } else {
            var self = this;
            // need to load it
            stream.findPostsByIds([postId]).then(function (arr) {
              post = arr[0];
              self.jumpTo(self.get('model').urlForPostNumber(post.get('post_number')));
            });
          }
        },

        jumpTop: function () {
          this.jumpTo(this.get('model.firstPostUrl'));
        },

        jumpBottom: function () {
          this.jumpTo(this.get('model.lastPostUrl'));
        }
      },

      // Route and close the expansion
      jumpTo: function (url) {
        this.set('expanded', false);
        DiscourseURL.routeTo(url);
      },

      streamPercentage: (function () {
        if (!this.get('model.postStream.loaded')) {
          return 0;
        }
        if (this.get('model.postStream.highest_post_number') === 0) {
          return 0;
        }
        var perc = this.get('progressPosition') / this.get('model.postStream.filteredPostsCount');
        return perc > 1.0 ? 1.0 : perc;
      }).property('model.postStream.loaded', 'progressPosition', 'model.postStream.filteredPostsCount'),

      jumpTopDisabled: (function () {
        return this.get('progressPosition') <= 3;
      }).property('progressPosition'),

      filteredPostCountChanged: (function () {
        if (this.get('model.postStream.filteredPostsCount') < this.get('progressPosition')) {
          this.set('progressPosition', this.get('model.postStream.filteredPostsCount'));
        }
      }).observes('model.postStream.filteredPostsCount'),

      jumpBottomDisabled: (function () {
        return this.get('progressPosition') >= this.get('model.postStream.filteredPostsCount') || this.get('progressPosition') >= this.get('model.highest_post_number');
      }).property('model.postStream.filteredPostsCount', 'model.highest_post_number', 'progressPosition'),

      hideProgress: (function () {
        if (!this.get('model.postStream.loaded')) return true;
        if (!this.get('model.currentPost')) return true;
        if (this.get('model.postStream.filteredPostsCount') < 2) return true;
        return false;
      }).property('model.postStream.loaded', 'model.currentPost', 'model.postStream.filteredPostsCount'),

      hugeNumberOfPosts: (function () {
        return this.get('model.postStream.filteredPostsCount') >= Discourse.SiteSettings.short_progress_text_threshold;
      }).property('model.highest_post_number'),

      jumpToBottomTitle: (function () {
        if (this.get('hugeNumberOfPosts')) {
          return I18n.t('topic.progress.jump_bottom_with_number', { post_number: this.get('model.highest_post_number') });
        } else {
          return I18n.t('topic.progress.jump_bottom');
        }
      }).property('hugeNumberOfPosts', 'model.highest_post_number')

    });
  });
define("discourse/controllers/topic-unsubscribe", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({

      stopNotificiationsText: (function () {
        return I18n.t("topic.unsubscribe.stop_notifications", { title: this.get("model.fancyTitle") });
      }).property("model.fancyTitle")

    });
  });
define("discourse/controllers/topic", 
  ["discourse/mixins/buffered-content","discourse/mixins/selected-posts-count","discourse/helpers/loading-spinner","discourse/models/topic","discourse/lib/quote","discourse/lib/ajax-error","ember-addons/ember-computed-decorators","discourse/models/composer","discourse/lib/url","discourse/helpers/category-link","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var BufferedContent = __dependency1__["default"];
    var SelectedPostsCount = __dependency2__["default"];
    var spinnerHTML = __dependency3__.spinnerHTML;
    var Topic = __dependency4__["default"];
    var Quote = __dependency5__["default"];
    var popupAjaxError = __dependency6__.popupAjaxError;
    var computed = __dependency7__["default"];
    var Composer = __dependency8__["default"];
    var DiscourseURL = __dependency9__["default"];
    var categoryBadgeHTML = __dependency10__.categoryBadgeHTML;

    __exports__["default"] = Ember.Controller.extend(SelectedPostsCount, BufferedContent, _createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['modal', 'composer', 'quote-button', 'topic-progress', 'application'];
      }
    }, {
      key: 'multiSelect',
      initializer: function () {
        return false;
      }
    }, {
      key: 'allPostsSelected',
      initializer: function () {
        return false;
      }
    }, {
      key: 'editingTopic',
      initializer: function () {
        return false;
      }
    }, {
      key: 'selectedPosts',
      initializer: function () {
        return null;
      }
    }, {
      key: 'selectedReplies',
      initializer: function () {
        return null;
      }
    }, {
      key: 'queryParams',
      initializer: function () {
        return ['filter', 'username_filters', 'show_deleted'];
      }
    }, {
      key: 'loadedAllPosts',
      initializer: function () {
        return Em.computed.or('model.postStream.loadedAllPosts', 'model.postStream.loadingLastPost');
      }
    }, {
      key: 'enteredAt',
      initializer: function () {
        return null;
      }
    }, {
      key: 'retrying',
      initializer: function () {
        return false;
      }
    }, {
      key: 'adminMenuVisible',
      initializer: function () {
        return false;
      }
    }, {
      key: 'showRecover',
      initializer: function () {
        return Em.computed.and('model.deleted', 'model.details.can_recover');
      }
    }, {
      key: 'isFeatured',
      initializer: function () {
        return Em.computed.or("model.pinned_at", "model.isBanner");
      }
    }, {
      key: '_titleChanged',
      initializer: function () {
        return (function () {
          var title = this.get('model.title');
          if (!Ember.isEmpty(title)) {

            // Note normally you don't have to trigger this, but topic titles can be updated
            // and are sometimes lazily loaded.
            this.send('refreshTitle');
          }
        }).observes('model.title', 'category');
      }
    }, {
      key: 'showSelectedPostsAtBottom',
      decorators: [computed('site.mobileView', 'model.posts_count')],
      value: function (mobileView, postsCount) {
        return mobileView && postsCount > 3;
      }
    }, {
      key: 'postsToRender',
      decorators: [computed('model.postStream.posts')],
      value: function () {
        return this.capabilities.isAndroid ? this.get('model.postStream.posts') : this.get('model.postStream.postsWithPlaceholders');
      }
    }, {
      key: 'androidLoading',
      decorators: [computed('model.postStream.loadingFilter')],
      value: function (loading) {
        return this.capabilities.isAndroid && loading;
      }
    }, {
      key: 'show_deleted',
      decorators: [computed('model.postStream.summary')],
      initializer: function () {
        return {
          set: function (value) {
            var postStream = this.get('model.postStream');
            if (!postStream) {
              return;
            }
            postStream.set('show_deleted', value);
            return postStream.get('show_deleted') ? true : undefined;
          },
          get: function () {
            return this.get('postStream.show_deleted') ? true : undefined;
          }
        };
      }
    }, {
      key: 'filter',
      decorators: [computed('model.postStream.summary')],
      initializer: function () {
        return {
          set: function (value) {
            var postStream = this.get('model.postStream');
            if (!postStream) {
              return;
            }
            postStream.set('summary', value === "summary");
            return postStream.get('summary') ? "summary" : undefined;
          },
          get: function () {
            return this.get('postStream.summary') ? "summary" : undefined;
          }
        };
      }
    }, {
      key: 'browseMoreMessage',
      decorators: [computed('model', 'topicTrackingState.messageCount')],
      value: function (model) {

        // TODO decide what to show for pms
        if (model.get('isPrivateMessage')) {
          return;
        }

        var opts = { latestLink: '<a href="' + Discourse.getURL("/latest") + '">' + I18n.t("topic.view_latest_topics") + '</a>' };
        var category = model.get('category');

        if (category && Em.get(category, 'id') === Discourse.Site.currentProp("uncategorized_category_id")) {
          category = null;
        }

        if (category) {
          opts.catLink = categoryBadgeHTML(category);
        } else {
          opts.catLink = "<a href=\"" + Discourse.getURL("/categories") + "\">" + I18n.t("topic.browse_all_categories") + "</a>";
        }

        var unreadTopics = this.topicTrackingState.countUnread();
        var newTopics = this.topicTrackingState.countNew();

        if (newTopics + unreadTopics > 0) {
          var hasBoth = unreadTopics > 0 && newTopics > 0;

          return I18n.messageFormat("topic.read_more_MF", {
            "BOTH": hasBoth,
            "UNREAD": unreadTopics,
            "NEW": newTopics,
            "CATEGORY": category ? true : false,
            latestLink: opts.latestLink,
            catLink: opts.catLink
          });
        } else if (category) {
          return I18n.t("topic.read_more_in_category", opts);
        } else {
          return I18n.t("topic.read_more", opts);
        }
      }
    }, {
      key: 'pmPath',
      decorators: [computed('model')],
      value: function (model) {
        return this.currentUser && this.currentUser.pmPath(model);
      }
    }, {
      key: 'suggestedTitle',
      decorators: [computed('model')],
      value: function (model) {
        return model.get('isPrivateMessage') ? '<i class=\'private-message-glyph fa fa-envelope\'></i> ' + I18n.t("suggested_topics.pm_title") : I18n.t("suggested_topics.title");
      }
    }, {
      key: 'username_filters',
      decorators: [computed('model.postStream.streamFilters.username_filters')],
      initializer: function () {
        return {
          set: function (value) {
            var postStream = this.get('model.postStream');
            if (!postStream) {
              return;
            }
            postStream.set('streamFilters.username_filters', value);
            return postStream.get('streamFilters.username_filters');
          },
          get: function () {
            return this.get('postStream.streamFilters.username_filters');
          }
        };
      }
    }, {
      key: '_clearSelected',
      initializer: function () {
        return (function () {
          this.set('selectedPosts', []);
          this.set('selectedReplies', []);
        }).on('init');
      }
    }, {
      key: 'showCategoryChooser',
      initializer: function () {
        return Ember.computed.not("model.isPrivateMessage");
      }
    }, {
      key: 'gotoInbox',
      value: function (name) {
        var url = '/users/' + this.get('currentUser.username_lower') + '/messages';
        if (name) {
          url = url + '/group/' + name;
        }
        DiscourseURL.routeTo(url);
      }
    }, {
      key: 'selectedQuery',
      initializer: function () {
        return (function () {
          var _this = this;

          return function (post) {
            return _this.postSelected(post);
          };
        }).property();
      }
    }, {
      key: 'canEditTags',
      decorators: [computed('model.isPrivateMessage')],
      value: function (isPrivateMessage) {
        return !isPrivateMessage && this.site.get('can_tag_topics');
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {

          fillGapBefore: function (args) {
            return this.get('model.postStream').fillGapBefore(args.post, args.gap);
          },

          fillGapAfter: function (args) {
            return this.get('model.postStream').fillGapAfter(args.post, args.gap);
          },

          // Called the the topmost visible post on the page changes.
          topVisibleChanged: function (event) {
            var post = event.post;
            var refresh = event.refresh;

            if (!post) {
              return;
            }

            var postStream = this.get('model.postStream');
            var firstLoadedPost = postStream.get('posts.firstObject');

            var currentPostNumber = post.get('post_number');
            this.set('model.currentPost', currentPostNumber);
            this.send('postChangedRoute', currentPostNumber);

            if (post.get('post_number') === 1) {
              return;
            }

            if (firstLoadedPost && firstLoadedPost === post) {
              postStream.prependMore().then(function () {
                return refresh();
              });
            }
          },

          //  Called the the bottommost visible post on the page changes.
          bottomVisibleChanged: function (event) {
            var post = event.post;
            var refresh = event.refresh;

            var postStream = this.get('model.postStream');
            var lastLoadedPost = postStream.get('posts.lastObject');

            this.set('controllers.topic-progress.progressPosition', postStream.progressIndexOfPost(post));

            if (lastLoadedPost && lastLoadedPost === post && postStream.get('canAppendMore')) {
              postStream.appendMore().then(function () {
                return refresh();
              });
              // show loading stuff
              refresh();
            }
          },

          toggleSummary: function () {
            return this.get('model.postStream').toggleSummary();
          },

          removeAllowedUser: function (user) {
            return this.get('model.details').removeAllowedUser(user);
          },

          showTopicAdminMenu: function () {
            this.set('adminMenuVisible', true);
          },

          hideTopicAdminMenu: function () {
            this.set('adminMenuVisible', false);
          },

          deleteTopic: function () {
            this.deleteTopic();
          },

          archiveMessage: function () {
            var _this2 = this;

            var topic = this.get('model');
            topic.archiveMessage().then(function () {
              _this2.gotoInbox(topic.get("inboxGroupName"));
            });
          },

          moveToInbox: function () {
            var _this3 = this;

            var topic = this.get('model');
            topic.moveToInbox().then(function () {
              _this3.gotoInbox(topic.get("inboxGroupName"));
            });
          },

          // Post related methods
          replyToPost: function (post) {
            var composerController = this.get('controllers.composer'),
                quoteController = this.get('controllers.quote-button'),
                quotedText = Quote.build(quoteController.get('post'), quoteController.get('buffer')),
                topic = post ? post.get('topic') : this.get('model');

            quoteController.set('buffer', '');

            if (composerController.get('content.topic.id') === topic.get('id') && composerController.get('content.action') === Composer.REPLY) {
              composerController.set('content.post', post);
              composerController.set('content.composeState', Composer.OPEN);
              this.appEvents.trigger('composer:insert-text', quotedText.trim());
            } else {

              var opts = {
                action: Composer.REPLY,
                draftKey: topic.get('draft_key'),
                draftSequence: topic.get('draft_sequence')
              };

              if (quotedText) {
                opts.quote = quotedText;
              }

              if (post && post.get("post_number") !== 1) {
                opts.post = post;
              } else {
                opts.topic = topic;
              }

              composerController.open(opts);
            }
            return false;
          },

          recoverPost: function (post) {
            // Recovering the first post recovers the topic instead
            if (post.get('post_number') === 1) {
              this.recoverTopic();
              return;
            }
            post.recover();
          },

          deletePost: function (post) {
            var _this4 = this;

            // Deleting the first post deletes the topic
            if (post.get('post_number') === 1) {
              return this.deleteTopic();
            } else if (!post.can_delete) {
              // check if current user can delete post
              return false;
            }

            var user = Discourse.User.current(),
                replyCount = post.get('reply_count'),
                self = this;

            // If the user is staff and the post has replies, ask if they want to delete replies too.
            if (user.get('staff') && replyCount > 0) {
              bootbox.dialog(I18n.t("post.controls.delete_replies.confirm", { count: replyCount }), [{ label: I18n.t("cancel"),
                'class': 'btn-danger right' }, { label: I18n.t("post.controls.delete_replies.no_value"),
                callback: function () {
                  post.destroy(user);
                }
              }, { label: I18n.t("post.controls.delete_replies.yes_value"),
                'class': 'btn-primary',
                callback: function () {
                  Discourse.Post.deleteMany([post], [post]);
                  self.get('model.postStream.posts').forEach(function (p) {
                    if (p === post || p.get('reply_to_post_number') === post.get('post_number')) {
                      p.setDeletedState(user);
                    }
                  });
                }
              }]);
            } else {
              return post.destroy(user).then(function () {
                _this4.appEvents.trigger('post-stream:refresh');
              }).catch(function (error) {
                popupAjaxError(error);
                post.undoDeleteState();
              });
            }
          },

          editPost: function (post) {
            if (!Discourse.User.current()) {
              return bootbox.alert(I18n.t('post.controls.edit_anonymous'));
            }

            // check if current user can edit post
            if (!post.can_edit) {
              return false;
            }

            var composer = this.get('controllers.composer'),
                composerModel = composer.get('model'),
                opts = {
              post: post,
              action: Composer.EDIT,
              draftKey: post.get('topic.draft_key'),
              draftSequence: post.get('topic.draft_sequence')
            };

            // Cancel and reopen the composer for the first post
            if (composerModel && (post.get('firstPost') || composerModel.get('editingFirstPost'))) {
              composer.cancelComposer().then(function () {
                return composer.open(opts);
              });
            } else {
              composer.open(opts);
            }
          },

          toggleBookmark: function (post) {
            var _this5 = this;

            if (!this.currentUser) {
              alert(I18n.t("bookmarks.not_bookmarked"));
              return;
            }
            if (post) {
              return post.toggleBookmark().catch(popupAjaxError);
            } else {
              return this.get("model").toggleBookmark().then(function (changedIds) {
                if (!changedIds) {
                  return;
                }
                changedIds.forEach(function (id) {
                  return _this5.appEvents.trigger('post-stream:refresh', { id: id });
                });
              });
            }
          },

          jumpTop: function () {
            this.get('controllers.topic-progress').send('jumpTop');
          },

          selectAll: function () {
            var posts = this.get('model.postStream.posts');
            var selectedPosts = this.get('selectedPosts');
            if (posts) {
              selectedPosts.addObjects(posts);
            }
            this.set('allPostsSelected', true);
            this.appEvents.trigger('post-stream:refresh', { force: true });
          },

          deselectAll: function () {
            this.get('selectedPosts').clear();
            this.get('selectedReplies').clear();
            this.set('allPostsSelected', false);
            this.appEvents.trigger('post-stream:refresh', { force: true });
          },

          toggleParticipant: function (user) {
            this.get('model.postStream').toggleParticipant(Em.get(user, 'username'));
          },

          editTopic: function () {
            if (!this.get('model.details.can_edit')) return false;

            this.set('editingTopic', true);
            return false;
          },

          cancelEditingTopic: function () {
            this.set('editingTopic', false);
            this.rollbackBuffer();
          },

          toggleMultiSelect: function () {
            this.toggleProperty('multiSelect');
            this.appEvents.trigger('post-stream:refresh', { force: true });
          },

          finishedEditingTopic: function () {
            if (!this.get('editingTopic')) {
              return;
            }

            // save the modifications
            var self = this,
                props = this.get('buffered.buffer');

            Topic.update(this.get('model'), props).then(function () {
              // Note we roll back on success here because `update` saves
              // the properties to the topic.
              self.rollbackBuffer();
              self.set('editingTopic', false);
            }).catch(popupAjaxError);
          },

          toggledSelectedPost: function (post) {
            this.performTogglePost(post);
          },

          toggledSelectedPostReplies: function (post) {
            var selectedReplies = this.get('selectedReplies');
            if (this.performTogglePost(post)) {
              selectedReplies.addObject(post);
            } else {
              selectedReplies.removeObject(post);
            }
          },

          deleteSelected: function () {
            var _this6 = this;

            bootbox.confirm(I18n.t("post.delete.confirm", { count: this.get('selectedPostsCount') }), function (result) {
              if (result) {

                // If all posts are selected, it's the same thing as deleting the topic
                if (_this6.get('allPostsSelected')) {
                  return _this6.deleteTopic();
                }

                var selectedPosts = _this6.get('selectedPosts');
                var selectedReplies = _this6.get('selectedReplies');
                var postStream = _this6.get('model.postStream');

                Discourse.Post.deleteMany(selectedPosts, selectedReplies);
                postStream.get('posts').forEach(function (p) {
                  if (_this6.postSelected(p)) {
                    p.set('deleted_at', new Date());
                  }
                });

                _this6.send('toggleMultiSelect');
              }
            });
          },

          expandHidden: function (post) {
            post.expandHidden();
          },

          toggleVisibility: function () {
            this.get('content').toggleStatus('visible');
          },

          toggleClosed: function () {
            this.get('content').toggleStatus('closed');
          },

          recoverTopic: function () {
            this.get('content').recover();
          },

          makeBanner: function () {
            this.get('content').makeBanner();
          },

          removeBanner: function () {
            this.get('content').removeBanner();
          },

          togglePinned: function () {
            var value = this.get('model.pinned_at') ? false : true,
                topic = this.get('content'),
                until = this.get('model.pinnedInCategoryUntil');

            // optimistic update
            topic.setProperties({
              pinned_at: value ? moment() : null,
              pinned_globally: false,
              pinned_until: value ? until : null
            });

            return topic.saveStatus("pinned", value, until);
          },

          pinGlobally: function () {
            var topic = this.get('content'),
                until = this.get('model.pinnedGloballyUntil');

            // optimistic update
            topic.setProperties({
              pinned_at: moment(),
              pinned_globally: true,
              pinned_until: until
            });

            return topic.saveStatus("pinned_globally", true, until);
          },

          toggleArchived: function () {
            this.get('content').toggleStatus('archived');
          },

          clearPin: function () {
            this.get('content').clearPin();
          },

          togglePinnedForUser: function () {
            if (this.get('model.pinned_at')) {
              var topic = this.get('content');
              if (topic.get('pinned')) {
                topic.clearPin();
              } else {
                topic.rePin();
              }
            }
          },

          replyAsNewTopic: function (post) {
            var composerController = this.get('controllers.composer'),
                quoteController = this.get('controllers.quote-button'),
                quotedText = Quote.build(quoteController.get('post'), quoteController.get('buffer')),
                self = this;

            quoteController.deselectText();

            composerController.open({
              action: Composer.CREATE_TOPIC,
              draftKey: Composer.REPLY_AS_NEW_TOPIC_KEY,
              categoryId: this.get('model.category.id')
            }).then(function () {
              return Em.isEmpty(quotedText) ? "" : quotedText;
            }).then(function (q) {
              var postUrl = location.protocol + '//' + location.host + post.get('url');
              var postLink = '[' + Handlebars.escapeExpression(self.get('model.title')) + '](' + postUrl + ')';
              composerController.get('model').prependText(I18n.t("post.continue_discussion", { postLink: postLink }) + '\n\n' + q, { new_line: true });
            });
          },

          retryLoading: function () {
            var self = this;
            self.set('retrying', true);
            this.get('model.postStream').refresh().then(function () {
              self.set('retrying', false);
            }, function () {
              self.set('retrying', false);
            });
          },

          toggleWiki: function (post) {
            return post.updatePostField('wiki', !post.get('wiki'));
          },

          togglePostType: function (post) {
            var regular = this.site.get('post_types.regular');
            var moderator = this.site.get('post_types.moderator_action');

            return post.updatePostField('post_type', post.get('post_type') === moderator ? regular : moderator);
          },

          rebakePost: function (post) {
            return post.rebake();
          },

          unhidePost: function (post) {
            return post.unhide();
          },

          changePostOwner: function (post) {
            this.get('selectedPosts').addObject(post);
            this.send('changeOwner');
          },

          convertToPublicTopic: function () {
            this.get('content').convertTopic("public");
          },

          convertToPrivateMessage: function () {
            this.get('content').convertTopic("private");
          }
        };
      }
    }, {
      key: 'togglePinnedState',
      value: function () {
        this.send('togglePinnedForUser');
      }
    }, {
      key: 'canMergeTopic',
      initializer: function () {
        return (function () {
          if (!this.get('model.details.can_move_posts')) return false;
          return this.get('selectedPostsCount') > 0;
        }).property('selectedPostsCount');
      }
    }, {
      key: 'canSplitTopic',
      initializer: function () {
        return (function () {
          if (!this.get('model.details.can_move_posts')) return false;
          if (this.get('allPostsSelected')) return false;
          return this.get('selectedPostsCount') > 0;
        }).property('selectedPostsCount');
      }
    }, {
      key: 'canChangeOwner',
      initializer: function () {
        return (function () {
          if (!Discourse.User.current() || !Discourse.User.current().admin) return false;
          return this.get('selectedPostsUsername') !== undefined;
        }).property('selectedPostsUsername');
      }
    }, {
      key: 'categories',
      initializer: function () {
        return (function () {
          return Discourse.Category.list();
        }).property();
      }
    }, {
      key: 'canSelectAll',
      initializer: function () {
        return Em.computed.not('allPostsSelected');
      }
    }, {
      key: 'canDeselectAll',
      initializer: function () {
        return (function () {
          if (this.get('selectedPostsCount') > 0) return true;
          if (this.get('allPostsSelected')) return true;
        }).property('selectedPostsCount', 'allPostsSelected');
      }
    }, {
      key: 'canDeleteSelected',
      initializer: function () {
        return (function () {
          var selectedPosts = this.get('selectedPosts');

          if (this.get('allPostsSelected')) return true;
          if (this.get('selectedPostsCount') === 0) return false;

          var canDelete = true;
          selectedPosts.forEach(function (p) {
            if (!p.get('can_delete')) {
              canDelete = false;
              return false;
            }
          });
          return canDelete;
        }).property('selectedPostsCount');
      }
    }, {
      key: 'hasError',
      initializer: function () {
        return Ember.computed.or('model.notFoundHtml', 'model.message');
      }
    }, {
      key: 'noErrorYet',
      initializer: function () {
        return Ember.computed.not('hasError');
      }
    }, {
      key: 'multiSelectChanged',
      initializer: function () {
        return (function () {
          // Deselect all posts when multi select is turned off
          if (!this.get('multiSelect')) {
            this.send('deselectAll');
          }
        }).observes('multiSelect');
      }
    }, {
      key: 'deselectPost',
      value: function (post) {
        this.get('selectedPosts').removeObject(post);

        var selectedReplies = this.get('selectedReplies');
        selectedReplies.removeObject(post);

        var selectedReply = selectedReplies.findProperty('post_number', post.get('reply_to_post_number'));
        if (selectedReply) {
          selectedReplies.removeObject(selectedReply);
        }

        this.set('allPostsSelected', false);
      }
    }, {
      key: 'postSelected',
      value: function (post) {
        if (this.get('allPostsSelected')) {
          return true;
        }
        if (this.get('selectedPosts').contains(post)) {
          return true;
        }
        if (this.get('selectedReplies').findProperty('post_number', post.get('reply_to_post_number'))) {
          return true;
        }

        return false;
      }
    }, {
      key: 'loadingHTML',
      initializer: function () {
        return (function () {
          return spinnerHTML;
        }).property();
      }
    }, {
      key: 'recoverTopic',
      value: function () {
        this.get('content').recover();
      }
    }, {
      key: 'deleteTopic',
      value: function () {
        this.unsubscribe();
        this.get('content').destroy(Discourse.User.current());
      }
    }, {
      key: 'subscribe',

      // Receive notifications for this topic
      value: function () {
        var _this7 = this;

        // Unsubscribe before subscribing again
        this.unsubscribe();

        var refresh = function (args) {
          return _this7.appEvents.trigger('post-stream:refresh', args);
        };

        this.messageBus.subscribe("/topic/" + this.get('model.id'), function (data) {
          var topic = _this7.get('model');

          if (data.notification_level_change) {
            topic.set('details.notification_level', data.notification_level_change);
            topic.set('details.notifications_reason_id', data.notifications_reason_id);
            return;
          }

          var postStream = _this7.get('model.postStream');
          switch (data.type) {
            case "acted":
              postStream.triggerChangedPost(data.id, data.updated_at).then(function () {
                return refresh({ id: data.id, refreshLikes: true });
              });
              break;
            case "revised":
            case "rebaked":
              {
                postStream.triggerChangedPost(data.id, data.updated_at).then(function () {
                  return refresh({ id: data.id });
                });
                break;
              }
            case "deleted":
              {
                postStream.triggerDeletedPost(data.id, data.post_number).then(function () {
                  return refresh({ id: data.id });
                });
                break;
              }
            case "recovered":
              {
                postStream.triggerRecoveredPost(data.id, data.post_number).then(function () {
                  return refresh({ id: data.id });
                });
                break;
              }
            case "created":
              {
                postStream.triggerNewPostInStream(data.id).then(function () {
                  return refresh();
                });
                if (_this7.get('currentUser.id') !== data.user_id) {
                  Discourse.notifyBackgroundCountIncrement();
                }
                break;
              }
            case "move_to_inbox":
              {
                topic.set("message_archived", false);
                break;
              }
            case "archived":
              {
                topic.set("message_archived", true);
                break;
              }
            default:
              {
                Em.Logger.warn("unknown topic bus message type", data);
              }
          }

          if (data.reload_topic) {
            topic.reload().then(function () {
              _this7.send('postChangedRoute', topic.get('post_number') || 1);
            });
          }
        });
      }
    }, {
      key: 'unsubscribe',
      value: function () {
        var topicId = this.get('content.id');
        if (!topicId) return;

        // there is a condition where the view never calls unsubscribe, navigate to a topic from a topic
        this.messageBus.unsubscribe('/topic/*');
      }
    }, {
      key: 'reply',

      // Topic related
      value: function () {
        this.replyToPost();
      }
    }, {
      key: 'performTogglePost',
      value: function (post) {
        var selectedPosts = this.get('selectedPosts');
        if (this.postSelected(post)) {
          this.deselectPost(post);
          return false;
        } else {
          selectedPosts.addObject(post);
          // If the user manually selects all posts, all posts are selected
          this.set('allPostsSelected', selectedPosts.length === this.get('model.posts_count'));
          return true;
        }
      }
    }, {
      key: 'readPosts',
      value: function (topicId, postNumbers) {
        var _this8 = this;

        var topic = this.get("model");
        var postStream = topic.get("postStream");

        if (topic.get('id') === topicId) {

          // TODO identity map for postNumber
          postStream.get('posts').forEach(function (post) {
            if (!post.read && postNumbers.indexOf(post.post_number) !== -1) {
              post.set('read', true);
              _this8.appEvents.trigger('post-stream:refresh', { id: post.id });
            }
          });

          var max = _.max(postNumbers);
          if (max > topic.get("last_read_post_number")) {
            topic.set("last_read_post_number", max);
          }

          if (this.siteSettings.automatically_unpin_topics && this.currentUser && this.currentUser.automatically_unpin_topics) {
            // automatically unpin topics when the user reaches the bottom
            if (topic.get("pinned") && max >= topic.get("highest_post_number")) {
              Em.run.next(function () {
                return topic.clearPin();
              });
            }
          }
        }
      }
    }, {
      key: '_showFooter',
      initializer: function () {
        return (function () {
          var showFooter = this.get("model.postStream.loaded") && this.get("model.postStream.loadedAllPosts");
          this.set("controllers.application.showFooter", showFooter);
        }).observes("model.postStream.{loaded,loadedAllPosts}");
      }
    }]));
  });
define("discourse/controllers/upload-customization", 
  ["discourse/mixins/modal-functionality","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var ModalFunctionality = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, {
      notReady: Em.computed.not('ready'),
      needs: ['adminCustomizeCssHtml'],

      ready: (function () {
        try {
          var parsed = JSON.parse(this.get('customizationFile'));
          return !!parsed["site_customization"];
        } catch (e) {
          return false;
        }
      }).property('customizationFile'),

      actions: {
        createCustomization: function () {
          var object = JSON.parse(this.get('customizationFile')).site_customization;

          // Slight fixup before creating object
          object.enabled = false;
          delete object.id;
          delete object.key;

          var controller = this.get('controllers.adminCustomizeCssHtml');
          controller.send('newCustomization', object);
        }
      }

    });
  });
define("discourse/controllers/upload-selector", 
  ["discourse/mixins/modal-functionality","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.uploadTranslate = uploadTranslate;

    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var ModalFunctionality = __dependency1__["default"];
    var computed = __dependency2__.default;

    function uploadTranslate(key, options) {
      options = options || {};
      if (Discourse.Utilities.allowsAttachments()) {
        key += "_with_attachments";
      }
      return I18n.t('upload_selector.' + key, options);
    }

    __exports__["default"] = Ember.Controller.extend(ModalFunctionality, _createDecoratedObject([{
      key: 'showMore',
      initializer: function () {
        return false;
      }
    }, {
      key: 'local',
      initializer: function () {
        return true;
      }
    }, {
      key: 'imageUrl',
      initializer: function () {
        return null;
      }
    }, {
      key: 'imageLink',
      initializer: function () {
        return null;
      }
    }, {
      key: 'remote',
      initializer: function () {
        return Ember.computed.not("local");
      }
    }, {
      key: 'uploadIcon',
      decorators: [computed],
      value: function () {
        return Discourse.Utilities.allowsAttachments() ? "upload" : "picture-o";
      }
    }, {
      key: 'tip',
      decorators: [computed('controller.local')],
      value: function (local) {
        var source = local ? "local" : "remote";
        var authorized_extensions = Discourse.Utilities.authorizesAllExtensions() ? "" : '(' + Discourse.Utilities.authorizedExtensions() + ')';
        return uploadTranslate(source + '_tip', { authorized_extensions: authorized_extensions });
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          upload: function () {
            if (this.get('local')) {
              $('.wmd-controls').fileupload('add', { fileInput: $('#filename-input') });
            } else {
              var imageUrl = this.get('imageUrl') || '';
              var imageLink = this.get('imageLink') || '';
              var toolbarEvent = this.get('toolbarEvent');

              if (this.get('showMore') && imageLink.length > 3) {
                toolbarEvent.addText('[![](' + imageUrl + ')](' + imageLink + ')');
              } else {
                toolbarEvent.addText(imageUrl);
              }
            }
            this.send('closeModal');
          },

          useLocal: function () {
            this.setProperties({ local: true, showMore: false });
          },
          useRemote: function () {
            this.set("local", false);
          },
          toggleShowMore: function () {
            this.toggleProperty("showMore");
          }
        };
      }
    }]));
  });
define("discourse/controllers/user-activity", 
  ["discourse/lib/export-csv","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var exportUserArchive = __dependency1__.exportUserArchive;

    __exports__["default"] = Ember.Controller.extend({
      userActionType: null,
      needs: ["application", "user"],
      currentPath: Em.computed.alias('controllers.application.currentPath'),
      viewingSelf: Em.computed.alias("controllers.user.viewingSelf"),
      showBookmarks: Em.computed.alias("controllers.user.showBookmarks"),

      _showFooter: (function () {
        var showFooter;
        if (this.get("userActionType")) {
          var stat = _.find(this.get("model.stats"), { action_type: this.get("userActionType") });
          showFooter = stat && stat.count <= this.get("model.stream.itemsLoaded");
        } else {
          showFooter = this.get("model.statsCountNonPM") <= this.get("model.stream.itemsLoaded");
        }
        this.set("controllers.application.showFooter", showFooter);
      }).observes("userActionType", "model.stream.itemsLoaded"),

      actions: {
        exportUserArchive: function () {
          bootbox.confirm(I18n.t("admin.export_csv.user_archive_confirm"), I18n.t("no_value"), I18n.t("yes_value"), function (confirmed) {
            if (confirmed) {
              exportUserArchive();
            }
          });
        }
      }

    });
  });
define("discourse/controllers/user-badges", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.ArrayController.extend({
      needs: ["user"],
      user: Em.computed.alias("controllers.user.model"),
      sortProperties: ['badge.badge_type.sort_order', 'badge.name'],
      orderBy: function (ub1, ub2) {
        var sr1 = ub1.get('badge.badge_type.sort_order');
        var sr2 = ub2.get('badge.badge_type.sort_order');

        if (sr1 > sr2) {
          return -1;
        }

        if (sr2 > sr1) {
          return 1;
        }

        return ub1.get('badge.name') < ub2.get('badge.name') ? -1 : 1;
      }
    });
  });
define("discourse/controllers/user-card", 
  ["discourse/lib/url","discourse/lib/computed","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var DiscourseURL = __dependency1__["default"];
    var propertyNotEqual = __dependency2__.propertyNotEqual;
    var setting = __dependency2__.setting;
    var computed = __dependency3__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['topic', 'application'];
      }
    }, {
      key: 'visible',
      initializer: function () {
        return false;
      }
    }, {
      key: 'user',
      initializer: function () {
        return null;
      }
    }, {
      key: 'username',
      initializer: function () {
        return null;
      }
    }, {
      key: 'avatar',
      initializer: function () {
        return null;
      }
    }, {
      key: 'userLoading',
      initializer: function () {
        return null;
      }
    }, {
      key: 'cardTarget',
      initializer: function () {
        return null;
      }
    }, {
      key: 'post',
      initializer: function () {
        return null;
      }
    }, {
      key: 'topicPostCount',

      // If inside a topic
      initializer: function () {
        return null;
      }
    }, {
      key: 'postStream',
      initializer: function () {
        return Em.computed.alias('controllers.topic.model.postStream');
      }
    }, {
      key: 'enoughPostsForFiltering',
      initializer: function () {
        return Em.computed.gte('topicPostCount', 2);
      }
    }, {
      key: 'viewingTopic',
      initializer: function () {
        return Em.computed.match('controllers.application.currentPath', /^topic\./);
      }
    }, {
      key: 'viewingAdmin',
      initializer: function () {
        return Em.computed.match('controllers.application.currentPath', /^admin\./);
      }
    }, {
      key: 'showFilter',
      initializer: function () {
        return Em.computed.and('viewingTopic', 'postStream.hasNoFilters', 'enoughPostsForFiltering');
      }
    }, {
      key: 'showName',
      initializer: function () {
        return propertyNotEqual('user.name', 'user.username');
      }
    }, {
      key: 'hasUserFilters',
      initializer: function () {
        return Em.computed.gt('postStream.userFilters.length', 0);
      }
    }, {
      key: 'isSuspended',
      initializer: function () {
        return Em.computed.notEmpty('user.suspend_reason');
      }
    }, {
      key: 'showBadges',
      initializer: function () {
        return setting('enable_badges');
      }
    }, {
      key: 'showMoreBadges',
      initializer: function () {
        return Em.computed.gt('moreBadgesCount', 0);
      }
    }, {
      key: 'showDelete',
      initializer: function () {
        return Em.computed.and("viewingAdmin", "showName", "user.canBeDeleted");
      }
    }, {
      key: 'linkWebsite',
      initializer: function () {
        return Em.computed.not('user.isBasic');
      }
    }, {
      key: 'hasLocationOrWebsite',
      initializer: function () {
        return Em.computed.or('user.location', 'user.website_name');
      }
    }, {
      key: 'publicUserFields',
      decorators: [computed('user.user_fields.@each.value')],
      value: function () {
        var _this = this;

        var siteUserFields = this.site.get('user_fields');
        if (!Ember.isEmpty(siteUserFields)) {
          var _ret = (function () {
            var userFields = _this.get('user.user_fields');
            return {
              v: siteUserFields.filterProperty('show_on_user_card', true).sortBy('position').map(function (field) {
                Ember.set(field, 'dasherized_name', field.get('name').dasherize());
                var value = userFields ? userFields[field.get('id')] : null;
                return Ember.isEmpty(value) ? null : Ember.Object.create({ value: value, field: field });
              }).compact()
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        }
      }
    }, {
      key: 'removeNoFollow',
      decorators: [computed("user.trust_level")],
      value: function (trustLevel) {
        return trustLevel > 2 && !this.siteSettings.tl3_links_no_follow;
      }
    }, {
      key: 'moreBadgesCount',
      initializer: function () {
        return (function () {
          return this.get('user.badge_count') - this.get('user.featured_user_badges.length');
        }).property('user.badge_count', 'user.featured_user_badges.[]');
      }
    }, {
      key: 'hasCardBadgeImage',
      initializer: function () {
        return (function () {
          var img = this.get('user.card_badge.image');
          return img && img.indexOf('fa-') !== 0;
        }).property('user.card_badge.image');
      }
    }, {
      key: 'show',
      value: function (username, postId, target) {
        var _this2 = this;

        // XSS protection (should be encapsulated)
        username = username.toString().replace(/[^A-Za-z0-9_\.\-]/g, "");

        // No user card for anon
        if (this.siteSettings.hide_user_profiles_from_public && !this.currentUser) {
          return;
        }

        // Don't show on mobile
        if (this.site.mobileView) {
          var url = "/users/" + username;
          DiscourseURL.routeTo(url);
          return;
        }

        var currentUsername = this.get('username'),
            wasVisible = this.get('visible'),
            previousTarget = this.get('cardTarget'),
            post = this.get('viewingTopic') && postId ? this.get('postStream').findLoadedPost(postId) : null;

        if (username === currentUsername && this.get('userLoading') === username) {
          // debounce
          return;
        }

        if (wasVisible) {
          this.close();
          if (target === previousTarget) {
            return; // Same target, close it without loading the new user card
          }
        }

        this.setProperties({ username: username, userLoading: username, cardTarget: target, post: post });

        var args = { stats: false };
        args.include_post_count_for = this.get('controllers.topic.model.id');
        args.skip_track_visit = true;

        return Discourse.User.findByUsername(username, args).then(function (user) {
          if (user.topic_post_count) {
            _this2.set('topicPostCount', user.topic_post_count[args.include_post_count_for]);
          }
          _this2.setProperties({ user: user, avatar: user, visible: true });
        }).catch(function (error) {
          _this2.close();
          throw error;
        }).finally(function () {
          _this2.set('userLoading', null);
        });
      }
    }, {
      key: 'close',
      value: function () {
        this.setProperties({
          visible: false,
          user: null,
          username: null,
          avatar: null,
          userLoading: null,
          cardTarget: null,
          post: null,
          topicPostCount: null
        });
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          togglePosts: function (user) {
            var postStream = this.get('postStream');
            postStream.toggleParticipant(user.get('username'));
            this.close();
          },

          cancelFilter: function () {
            var postStream = this.get('postStream');
            postStream.cancelFilter();
            postStream.refresh();
            this.close();
          },

          showUser: function () {
            this.transitionToRoute('user', this.get('user'));
            this.close();
          }
        };
      }
    }]));
  });
define("discourse/controllers/user-invited-show", 
  ["discourse/models/invite","discourse/lib/debounce","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var Invite = __dependency1__["default"];
    var debounce = __dependency2__["default"];

    // This controller handles actions related to a user's invitations
    __exports__["default"] = Ember.Controller.extend({
      user: null,
      model: null,
      filter: null,
      totalInvites: null,
      invitesCount: null,
      canLoadMore: true,
      invitesLoading: false,

      init: function () {
        this._super();
        this.set('searchTerm', '');
      },

      uploadText: (function () {
        return I18n.t("user.invited.bulk_invite.text");
      }).property(),

      /**
        Observe the search term box with a debouncer and change the results.
         @observes searchTerm
      **/
      _searchTermChanged: debounce(function () {
        var self = this;
        Invite.findInvitedBy(self.get('user'), this.get('filter'), this.get('searchTerm')).then(function (invites) {
          self.set('model', invites);
        });
      }, 250).observes('searchTerm'),

      inviteRedeemed: Em.computed.equal('filter', 'redeemed'),

      /**
        Can the currently logged in user invite users to the site
         @property canInviteToForum
      **/
      canInviteToForum: (function () {
        return Discourse.User.currentProp('can_invite_to_forum');
      }).property(),

      /**
        Can the currently logged in user bulk invite users to the site (only Admin is allowed to perform this operation)
         @property canBulkInvite
      **/
      canBulkInvite: (function () {
        return Discourse.User.currentProp('admin');
      }).property(),

      /**
        Should the search filter input box be displayed?
         @property showSearch
      **/
      showSearch: (function () {
        return this.get('totalInvites') > 9;
      }).property('totalInvites'),

      pendingLabel: (function () {
        if (this.get('invitesCount.total') > 50) {
          return I18n.t('user.invited.pending_tab_with_count', { count: this.get('invitesCount.pending') });
        } else {
          return I18n.t('user.invited.pending_tab');
        }
      }).property('invitesCount'),

      redeemedLabel: (function () {
        if (this.get('invitesCount.total') > 50) {
          return I18n.t('user.invited.redeemed_tab_with_count', { count: this.get('invitesCount.redeemed') });
        } else {
          return I18n.t('user.invited.redeemed_tab');
        }
      }).property('invitesCount'),

      actions: {

        rescind: function (invite) {
          invite.rescind();
          return false;
        },

        reinvite: function (invite) {
          invite.reinvite();
          return false;
        },

        loadMore: function () {
          var self = this;
          var model = self.get('model');

          if (self.get('canLoadMore') && !self.get('invitesLoading')) {
            self.set('invitesLoading', true);
            Invite.findInvitedBy(self.get('user'), self.get('filter'), self.get('searchTerm'), model.invites.length).then(function (invite_model) {
              self.set('invitesLoading', false);
              model.invites.pushObjects(invite_model.invites);
              if (invite_model.invites.length === 0 || invite_model.invites.length < Discourse.SiteSettings.invites_per_page) {
                self.set('canLoadMore', false);
              }
            });
          }
        }
      }

    });
  });
define("discourse/controllers/user-notifications", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.ArrayController.extend({
      needs: ['application'],

      _showFooter: (function () {
        this.set("controllers.application.showFooter", !this.get("model.canLoadMore"));
      }).observes("model.canLoadMore"),

      currentPath: Em.computed.alias('controllers.application.currentPath'),

      actions: {
        resetNew: function () {
          var _this = this;

          Discourse.ajax('/notifications/mark-read', { method: 'PUT' }).then(function () {
            _this.setEach('read', true);
          });
        },

        loadMore: function () {
          this.get('model').loadMore();
        }
      }
    });
  });
define("discourse/controllers/user-posts", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Controller.extend({
      needs: ["application"],

      _showFooter: (function () {
        this.set("controllers.application.showFooter", !this.get("model.canLoadMore"));
      }).observes("model.canLoadMore")
    });
  });
define("discourse/controllers/user-private-messages", 
  ["ember-addons/ember-computed-decorators","discourse/models/topic","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var Topic = __dependency2__["default"];

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ["application", "user-topics-list", "user"];
      }
    }, {
      key: 'pmView',
      initializer: function () {
        return false;
      }
    }, {
      key: 'viewingSelf',
      initializer: function () {
        return Em.computed.alias('controllers.user.viewingSelf');
      }
    }, {
      key: 'isGroup',
      initializer: function () {
        return Em.computed.equal('pmView', 'groups');
      }
    }, {
      key: 'currentPath',
      initializer: function () {
        return Em.computed.alias('controllers.application.currentPath');
      }
    }, {
      key: 'selected',
      initializer: function () {
        return Em.computed.alias('controllers.user-topics-list.selected');
      }
    }, {
      key: 'bulkSelectEnabled',
      initializer: function () {
        return Em.computed.alias('controllers.user-topics-list.bulkSelectEnabled');
      }
    }, {
      key: 'showNewPM',
      initializer: function () {
        return (function () {
          return this.get('controllers.user.viewingSelf') && Discourse.User.currentProp('can_send_private_messages');
        }).property('controllers.user.viewingSelf');
      }
    }, {
      key: 'hasSelection',
      decorators: [computed('selected.[]', 'bulkSelectEnabled')],
      value: function (selected, bulkSelectEnabled) {
        return bulkSelectEnabled && selected && selected.length > 0;
      }
    }, {
      key: 'canMoveToInbox',
      decorators: [computed('hasSelection', 'pmView', 'archive')],
      value: function (hasSelection, pmView, archive) {
        return hasSelection && (pmView === "archive" || archive);
      }
    }, {
      key: 'canArchive',
      decorators: [computed('hasSelection', 'pmView', 'archive')],
      value: function (hasSelection, pmView, archive) {
        return hasSelection && pmView !== "archive" && !archive;
      }
    }, {
      key: 'bulkOperation',
      value: function (operation) {
        var _this = this;

        var selected = this.get('selected');
        var params = { type: operation };
        if (this.get('isGroup')) {
          params.group = this.get('groupFilter');
        }

        Topic.bulkOperation(selected, params).then(function () {
          var model = _this.get('controllers.user-topics-list.model');
          var topics = model.get('topics');
          topics.removeObjects(selected);
          selected.clear();
          model.loadMore();
        }, function () {
          bootbox.alert(I18n.t("user.messages.failed_to_move"));
        });
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          archive: function () {
            this.bulkOperation("archive_messages");
          },
          toInbox: function () {
            this.bulkOperation("move_messages_to_inbox");
          },
          toggleBulkSelect: function () {
            this.toggleProperty("bulkSelectEnabled");
          },
          selectAll: function () {
            $('input.bulk-select:not(checked)').click();
          }
        };
      }
    }]));
  });
define("discourse/controllers/user-summary", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    // should be kept in sync with 'UserSummary::MAX_SUMMARY_RESULTS'
    var MAX_SUMMARY_RESULTS = 6;
    // should be kept in sync with 'UserSummary::MAX_BADGES'
    var MAX_BADGES = 6;

    __exports__["default"] = Ember.Controller.extend(_createDecoratedObject([{
      key: 'needs',
      initializer: function () {
        return ['user'];
      }
    }, {
      key: 'user',
      initializer: function () {
        return Ember.computed.alias('controllers.user.model');
      }
    }, {
      key: 'moreTopics',
      decorators: [computed("model.topics.length")],
      value: function (topicsLength) {
        return topicsLength >= MAX_SUMMARY_RESULTS;
      }
    }, {
      key: 'moreReplies',
      decorators: [computed("model.replies.length")],
      value: function (repliesLength) {
        return repliesLength >= MAX_SUMMARY_RESULTS;
      }
    }, {
      key: 'moreBadges',
      decorators: [computed("model.badges.length")],
      value: function (badgesLength) {
        return badgesLength >= MAX_BADGES;
      }
    }]));
  });
define("discourse/controllers/user-topics-list", 
  ["exports"],
  function(__exports__) {
    "use strict";
    // Lists of topics on a user's page.
    __exports__["default"] = Ember.Controller.extend({
      needs: ["application", "user"],
      hideCategory: false,
      showPosters: false,

      _showFooter: (function () {
        this.set("controllers.application.showFooter", !this.get("model.canLoadMore"));
      }).observes("model.canLoadMore"),

      actions: {
        loadMore: function () {
          this.get('model').loadMore();
        }
      }

    });
  });
define("discourse/controllers/user", 
  ["discourse/mixins/can-check-emails","ember-addons/ember-computed-decorators","discourse/models/user-action","discourse/models/user","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var CanCheckEmails = __dependency1__["default"];
    var computed = __dependency2__["default"];
    var UserAction = __dependency3__["default"];
    var User = __dependency4__["default"];

    __exports__["default"] = Ember.Controller.extend(CanCheckEmails, _createDecoratedObject([{
      key: 'indexStream',
      initializer: function () {
        return false;
      }
    }, {
      key: 'userActionType',
      initializer: function () {
        return null;
      }
    }, {
      key: 'needs',
      initializer: function () {
        return ['application', 'user-notifications', 'user-topics-list'];
      }
    }, {
      key: 'currentPath',
      initializer: function () {
        return Em.computed.alias('controllers.application.currentPath');
      }
    }, {
      key: 'viewingSelf',
      decorators: [computed("content.username")],
      value: function (username) {
        return username === User.currentProp('username');
      }
    }, {
      key: 'collapsedInfo',
      decorators: [computed('indexStream', 'viewingSelf', 'forceExpand')],
      value: function (indexStream, viewingSelf, forceExpand) {
        return (!indexStream || viewingSelf) && !forceExpand;
      }
    }, {
      key: 'linkWebsite',
      initializer: function () {
        return Em.computed.not('model.isBasic');
      }
    }, {
      key: 'removeNoFollow',
      decorators: [computed("model.trust_level")],
      value: function (trustLevel) {
        return trustLevel > 2 && !this.siteSettings.tl3_links_no_follow;
      }
    }, {
      key: 'showBookmarks',
      decorators: [computed('viewingSelf', 'currentUser.admin')],
      value: function (viewingSelf, isAdmin) {
        return viewingSelf || isAdmin;
      }
    }, {
      key: 'showPrivateMessages',
      decorators: [computed('viewingSelf', 'currentUser.admin')],
      value: function (viewingSelf, isAdmin) {
        return this.siteSettings.enable_private_messages && (viewingSelf || isAdmin);
      }
    }, {
      key: 'showNotificationsTab',
      decorators: [computed('viewingSelf', 'currentUser.staff')],
      value: function (viewingSelf, staff) {
        return viewingSelf || staff;
      }
    }, {
      key: 'showBadges',
      decorators: [computed("content.badge_count")],
      value: function (badgeCount) {
        return Discourse.SiteSettings.enable_badges && badgeCount > 0;
      }
    }, {
      key: 'privateMessageView',
      decorators: [computed("userActionType")],
      value: function (userActionType) {
        return userActionType === UserAction.TYPES.messages_sent || userActionType === UserAction.TYPES.messages_received;
      }
    }, {
      key: 'showActionTypeSummary',
      decorators: [computed("indexStream", "userActionType")],
      value: function (indexStream, userActionType, showPMs) {
        return (indexStream || userActionType) && !showPMs;
      }
    }, {
      key: 'canInviteToForum',
      decorators: [computed()],
      value: function () {
        return User.currentProp('can_invite_to_forum');
      }
    }, {
      key: 'canDeleteUser',
      initializer: function () {
        return Ember.computed.and("model.can_be_deleted", "model.can_delete_all_posts");
      }
    }, {
      key: 'publicUserFields',
      decorators: [computed('model.user_fields.@each.value')],
      value: function () {
        var _this = this;

        var siteUserFields = this.site.get('user_fields');
        if (!Ember.isEmpty(siteUserFields)) {
          var _ret = (function () {
            var userFields = _this.get('model.user_fields');
            return {
              v: siteUserFields.filterProperty('show_on_profile', true).sortBy('position').map(function (field) {
                field.dasherized_name = field.get('name').dasherize();
                var value = userFields ? userFields[field.get('id').toString()] : null;
                return Ember.isEmpty(value) ? null : Ember.Object.create({ value: value, field: field });
              }).compact()
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        }
      }
    }, {
      key: 'actions',
      initializer: function () {
        return {
          expandProfile: function () {
            this.set('forceExpand', true);
          },

          adminDelete: function () {
            // I really want this deferred, don't want to bring in all this code till used
            var AdminUser = require('admin/models/admin-user').default;
            AdminUser.find(this.get('model.id')).then(function (user) {
              return user.destroy({ deletePosts: true });
            });
          }

        };
      }
    }]));
  });
define("discourse/controllers/users", 
  ["discourse/lib/debounce","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var debounce = __dependency1__["default"];

    __exports__["default"] = Ember.Controller.extend({
      needs: ["application"],
      queryParams: ["period", "order", "asc", "name"],
      period: "weekly",
      order: "likes_received",
      asc: null,
      name: "",

      showTimeRead: Ember.computed.equal("period", "all"),

      _setName: debounce(function () {
        this.set("name", this.get("nameInput"));
      }, 500).observes("nameInput"),

      _showFooter: (function () {
        this.set("controllers.application.showFooter", !this.get("model.canLoadMore"));
      }).observes("model.canLoadMore"),

      actions: {
        loadMore: function () {
          this.get("model").loadMore();
        }
      }
    });
  });
define("discourse/models/admin-post", 
  ["discourse/models/post","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var Post = __dependency1__["default"];

    __exports__["default"] = Post.extend({

      _attachCategory: (function () {
        var categoryId = this.get("category_id");
        if (categoryId) {
          this.set("category", Discourse.Category.findById(categoryId));
        }
      }).on("init"),

      presentName: Em.computed.any('name', 'username'),

      sameUser: (function () {
        return this.get("username") === Discourse.User.currentProp("username");
      }).property("username"),

      descriptionKey: (function () {
        if (this.get("reply_to_post_number")) {
          return this.get("sameUser") ? "you_replied_to_post" : "user_replied_to_post";
        } else {
          return this.get("sameUser") ? "you_replied_to_topic" : "user_replied_to_topic";
        }
      }).property("reply_to_post_number", "sameUser")

    });
  });
define("discourse/models/archetype", 
  ["discourse/lib/computed","discourse/models/rest","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var propertyEqual = __dependency1__.propertyEqual;
    var RestModel = __dependency2__["default"];

    __exports__["default"] = RestModel.extend({
      hasOptions: Em.computed.gt('options.length', 0),
      isDefault: propertyEqual('id', 'site.default_archetype'),
      notDefault: Em.computed.not('isDefault')
    });
  });
define("discourse/models/category-list", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var CategoryList = Ember.ArrayProxy.extend({
      init: function () {
        this.set('content', []);
        this._super();
      }
    });

    CategoryList.reopenClass({
      categoriesFrom: function (store, result) {
        var categories = CategoryList.create();
        var users = Discourse.Model.extractByKey(result.featured_users, Discourse.User);
        var list = Discourse.Category.list();

        result.category_list.categories.forEach(function (c) {
          if (c.parent_category_id) {
            c.parentCategory = list.findBy('id', c.parent_category_id);
          }

          if (c.subcategory_ids) {
            c.subcategories = c.subcategory_ids.map(function (scid) {
              return list.findBy('id', parseInt(scid, 10));
            });
          }

          if (c.featured_user_ids) {
            c.featured_users = c.featured_user_ids.map(function (u) {
              return users[u];
            });
          }

          if (c.topics) {
            c.topics = c.topics.map(function (t) {
              return Discourse.Topic.create(t);
            });
          }

          categories.pushObject(store.createRecord('category', c));
        });
        return categories;
      },

      listForParent: function (store, category) {
        var _this = this;

        return Discourse.ajax('/categories.json?parent_category_id=' + category.get("id")).then(function (result) {
          return CategoryList.create({
            categories: _this.categoriesFrom(store, result),
            parentCategory: category
          });
        });
      },

      list: function (store) {
        var _this2 = this;

        var getCategories = function () {
          return Discourse.ajax("/categories.json");
        };
        return PreloadStore.getAndRemove("categories_list", getCategories).then(function (result) {
          return CategoryList.create({
            categories: _this2.categoriesFrom(store, result),
            can_create_category: result.category_list.can_create_category,
            can_create_topic: result.category_list.can_create_topic,
            draft_key: result.category_list.draft_key,
            draft: result.category_list.draft,
            draft_sequence: result.category_list.draft_sequence
          });
        });
      }
    });

    __exports__["default"] = CategoryList;
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  Represents a pop up message displayed over the composer

  @class ComposerMessage
  @extends Ember.Object
  @namespace Discourse
  @module Discourse
**/

Discourse.ComposerMessage = Em.Object.extend({});

Discourse.ComposerMessage.reopenClass({
  /**
    Look for composer messages given the current composing settings.

    @method find
    @param {Discourse.Composer} composer The current composer
    @returns {Discourse.ComposerMessage} the composer message to display (or null)
  **/
  find: function(composer) {

    var data = { composerAction: composer.get('action') },
        topicId = composer.get('topic.id'),
        postId = composer.get('post.id');

    if (topicId) { data.topic_id = topicId; }
    if (postId)  { data.post_id = postId; }

    return Discourse.ajax('/composer-messages', { data: data }).then(function (messages) {
      return messages.map(function (message) {
        return Discourse.ComposerMessage.create(message);
      });
    });
  }

});


// IIFE Wrapped Content Ends

 })(this);
define("discourse/models/group", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    var Group = Discourse.Model.extend(_createDecoratedObject([{
      key: 'limit',
      initializer: function () {
        return 50;
      }
    }, {
      key: 'offset',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'user_count',
      initializer: function () {
        return 0;
      }
    }, {
      key: 'owners',
      initializer: function () {
        return [];
      }
    }, {
      key: 'hasOwners',
      initializer: function () {
        return Ember.computed.notEmpty('owners');
      }
    }, {
      key: 'emailDomains',
      decorators: [computed("automatic_membership_email_domains")],
      value: function (value) {
        return Em.isEmpty(value) ? "" : value;
      }
    }, {
      key: 'type',
      initializer: function () {
        return (function () {
          return this.get("automatic") ? "automatic" : "custom";
        }).property("automatic");
      }
    }, {
      key: 'userCountDisplay',
      decorators: [computed('user_count')],
      value: function (userCount) {
        // don't display zero its ugly
        if (userCount > 0) {
          return userCount;
        }
      }
    }, {
      key: 'findMembers',
      value: function () {
        if (Em.isEmpty(this.get('name'))) {
          return;
        }

        var self = this,
            offset = Math.min(this.get("user_count"), Math.max(this.get("offset"), 0));

        return Group.loadMembers(this.get("name"), offset, this.get("limit")).then(function (result) {
          var ownerIds = {};
          result.owners.forEach(function (owner) {
            return ownerIds[owner.id] = true;
          });

          self.setProperties({
            user_count: result.meta.total,
            limit: result.meta.limit,
            offset: result.meta.offset,
            members: result.members.map(function (member) {
              if (ownerIds[member.id]) {
                member.owner = true;
              }
              return Discourse.User.create(member);
            }),
            owners: result.owners.map(function (owner) {
              return Discourse.User.create(owner);
            })
          });
        });
      }
    }, {
      key: 'removeOwner',
      value: function (member) {
        var self = this;
        return Discourse.ajax('/admin/groups/' + this.get('id') + '/owners.json', {
          type: "DELETE",
          data: { user_id: member.get("id") }
        }).then(function () {
          // reload member list
          self.findMembers();
        });
      }
    }, {
      key: 'removeMember',
      value: function (member) {
        var self = this;
        return Discourse.ajax('/groups/' + this.get('id') + '/members.json', {
          type: "DELETE",
          data: { user_id: member.get("id") }
        }).then(function () {
          // reload member list
          self.findMembers();
        });
      }
    }, {
      key: 'addMembers',
      value: function (usernames) {
        var self = this;
        return Discourse.ajax('/groups/' + this.get('id') + '/members.json', {
          type: "PUT",
          data: { usernames: usernames }
        }).then(function () {
          self.findMembers();
        });
      }
    }, {
      key: 'addOwners',
      value: function (usernames) {
        var self = this;
        return Discourse.ajax('/admin/groups/' + this.get('id') + '/owners.json', {
          type: "PUT",
          data: { usernames: usernames }
        }).then(function () {
          self.findMembers();
        });
      }
    }, {
      key: 'asJSON',
      value: function () {
        return {
          name: this.get('name'),
          alias_level: this.get('alias_level'),
          visible: !!this.get('visible'),
          automatic_membership_email_domains: this.get('emailDomains'),
          automatic_membership_retroactive: !!this.get('automatic_membership_retroactive'),
          title: this.get('title'),
          primary_group: !!this.get('primary_group'),
          grant_trust_level: this.get('grant_trust_level'),
          incoming_email: this.get("incoming_email")
        };
      }
    }, {
      key: 'create',
      value: function () {
        var self = this;
        return Discourse.ajax("/admin/groups", { type: "POST", data: this.asJSON() }).then(function (resp) {
          self.set('id', resp.basic_group.id);
        });
      }
    }, {
      key: 'save',
      value: function () {
        return Discourse.ajax("/admin/groups/" + this.get('id'), { type: "PUT", data: this.asJSON() });
      }
    }, {
      key: 'destroy',
      value: function () {
        if (!this.get('id')) {
          return;
        }
        return Discourse.ajax("/admin/groups/" + this.get('id'), { type: "DELETE" });
      }
    }, {
      key: 'findPosts',
      value: function (opts) {
        opts = opts || {};

        var type = opts['type'] || 'posts';

        var data = {};
        if (opts.beforePostId) {
          data.before_post_id = opts.beforePostId;
        }

        return Discourse.ajax('/groups/' + this.get('name') + '/' + type + '.json', { data: data }).then(function (posts) {
          return posts.map(function (p) {
            p.user = Discourse.User.create(p.user);
            p.topic = Discourse.Topic.create(p.topic);
            return Em.Object.create(p);
          });
        });
      }
    }, {
      key: 'setNotification',
      value: function (notification_level) {
        this.set("notification_level", notification_level);
        return Discourse.ajax('/groups/' + this.get("name") + '/notifications', {
          data: { notification_level: notification_level },
          type: "POST"
        });
      }
    }]));

    Group.reopenClass({
      findAll: function (opts) {
        return Discourse.ajax("/admin/groups.json", { data: opts }).then(function (groups) {
          return groups.map(function (g) {
            return Group.create(g);
          });
        });
      },

      findGroupCounts: function (name) {
        return Discourse.ajax("/groups/" + name + "/counts.json").then(function (result) {
          return Em.Object.create(result.counts);
        });
      },

      find: function (name) {
        return Discourse.ajax("/groups/" + name + ".json").then(function (result) {
          return Group.create(result.basic_group);
        });
      },

      loadMembers: function (name, offset, limit) {
        return Discourse.ajax('/groups/' + name + '/members.json', {
          data: {
            limit: limit || 50,
            offset: offset || 0
          }
        });
      }
    });

    __exports__["default"] = Group;
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

/**
  A trivial model we use to handle input validation

  @class InputValidation
  @extends Discourse.Model
  @namespace Discourse
  @module Discourse
**/

Discourse.InputValidation = Discourse.Model.extend({});




// IIFE Wrapped Content Ends

 })(this);
define("discourse/models/live-post-counts", 
  ["exports"],
  function(__exports__) {
    "use strict";
    var LivePostCounts = Discourse.Model.extend({});

    LivePostCounts.reopenClass({
      find: function () {
        return Discourse.ajax("/about/live_post_counts.json").then(function (result) {
          return LivePostCounts.create(result);
        });
      }
    });

    __exports__["default"] = LivePostCounts;
  });
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

Discourse.LoginMethod = Ember.Object.extend({
  title: function() {
    var titleSetting = this.get('titleSetting');
    if (!Ember.isEmpty(titleSetting)) {
      var result = Discourse.SiteSettings[titleSetting];
      if (!Ember.isEmpty(result)) { return result; }
    }

    return this.get("titleOverride") || I18n.t("login." + this.get("name") + ".title");
  }.property(),

  message: function() {
    return this.get("messageOverride") || I18n.t("login." + this.get("name") + ".message");
  }.property()
});

// Note, you can add login methods by adding to the list
//  just Em.get("Discourse.LoginMethod.all") and then
//  pushObject for any new methods
Discourse.LoginMethod.reopenClass({
  register: function(method) {
    if (this.methods){
      this.methods.pushObject(method);
    } else {
      this.preRegister = this.preRegister || [];
      this.preRegister.push(method);
    }
  },

  all: function(){
    if (this.methods) { return this.methods; }

    var methods = this.methods = Em.A();

    [ "google_oauth2",
      "facebook",
      "cas",
      "twitter",
      "yahoo",
      "instagram",
      "github"
    ].forEach(function(name){
      if (Discourse.SiteSettings["enable_" + name + "_logins"]) {

        var params = {name: name};

        if (name === "google_oauth2") {
          params.frameWidth = 850;
          params.frameHeight = 500;
        } else if (name === "facebook") {
          params.frameHeight = 450;
        }

        methods.pushObject(Discourse.LoginMethod.create(params));
      }
    });

    if (this.preRegister){
      this.preRegister.forEach(function(method){
        var enabledSetting = method.get('enabledSetting');
        if (enabledSetting) {
          if (Discourse.SiteSettings[enabledSetting]) {
            methods.pushObject(method);
          }
        } else {
          methods.pushObject(method);
        }
      });
      delete this.preRegister;
    }
    return methods;
  }.property()
});



// IIFE Wrapped Content Ends

 })(this);
define("discourse/models/nav-item", 
  ["discourse/lib/formatter","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    __exports__.extraNavItemProperties = extraNavItemProperties;
    __exports__.customNavItemHref = customNavItemHref;
    var toTitleCase = __dependency1__.toTitleCase;

    var NavItem = Discourse.Model.extend({

      displayName: (function () {
        var categoryName = this.get('categoryName'),
            name = this.get('name'),
            count = this.get('count') || 0;

        if (name === 'latest' && !Discourse.Site.currentProp('mobileView')) {
          count = 0;
        }

        var extra = { count: count };
        var titleKey = count === 0 ? '.title' : '.title_with_count';

        if (categoryName) {
          name = 'category';
          extra.categoryName = toTitleCase(categoryName);
        }
        return I18n.t("filters." + name.replace("/", ".") + titleKey, extra);
      }).property('categoryName', 'name', 'count'),

      categoryName: (function () {
        var split = this.get('name').split('/');
        return split[0] === 'category' ? split[1] : null;
      }).property('name'),

      categorySlug: (function () {
        var split = this.get('name').split('/');
        if (split[0] === 'category' && split[1]) {
          var cat = Discourse.Site.current().categories.findProperty('nameLower', split[1].toLowerCase());
          return cat ? Discourse.Category.slugFor(cat) : null;
        }
        return null;
      }).property('name'),

      href: (function () {
        var customHref = null;
        _.each(NavItem.customNavItemHrefs, function (cb) {
          customHref = cb.call(this, this);
          if (customHref) {
            return false;
          }
        }, this);
        if (customHref) {
          return customHref;
        }
        return Discourse.getURL("/") + this.get('filterMode');
      }).property('filterMode'),

      // href from this item
      filterMode: (function () {
        var name = this.get('name');

        if (name.split('/')[0] === 'category') {
          return 'c/' + this.get('categorySlug');
        } else {
          var mode = "",
              category = this.get("category");

          if (category) {
            mode += "c/";
            mode += Discourse.Category.slugFor(this.get('category'));
            if (this.get('noSubcategories')) {
              mode += '/none';
            }
            mode += "/l/";
          }
          return mode + name.replace(' ', '-');
        }
      }).property('name'),

      count: (function () {
        var state = this.get('topicTrackingState');
        if (state) {
          return state.lookupCount(this.get('name'), this.get('category'));
        }
      }).property('topicTrackingState.messageCount')

    });

    NavItem.reopenClass({

      extraArgsCallbacks: [],
      customNavItemHrefs: [],

      // create a nav item from the text, will return null if there is not valid nav item for this particular text
      fromText: function (text, opts) {
        var split = text.split(","),
            name = split[0],
            testName = name.split("/")[0],
            anonymous = !Discourse.User.current();

        if (anonymous && !Discourse.Site.currentProp('anonymous_top_menu_items').contains(testName)) return null;
        if (!Discourse.Category.list() && testName === "categories") return null;
        if (!Discourse.Site.currentProp('top_menu_items').contains(testName)) return null;

        var args = { name: name, hasIcon: name === "unread" },
            extra = null,
            self = this;
        if (opts.category) {
          args.category = opts.category;
        }
        if (opts.noSubcategories) {
          args.noSubcategories = true;
        }
        _.each(NavItem.extraArgsCallbacks, function (cb) {
          extra = cb.call(self, text, opts);
          _.merge(args, extra);
        });

        var store = Discourse.__container__.lookup('store:main');
        return store.createRecord('nav-item', args);
      },

      buildList: function (category, args) {
        args = args || {};

        if (category) {
          args.category = category;
        }

        var items = Discourse.SiteSettings.top_menu.split("|");

        if (args.filterMode && !_.some(items, function (i) {
          return i.indexOf(args.filterMode) !== -1;
        })) {
          items.push(args.filterMode);
        }

        return items.map(function (i) {
          return Discourse.NavItem.fromText(i, args);
        }).filter(function (i) {
          return i !== null && !(category && i.get("name").indexOf("categor") === 0);
        });
      }

    });

    __exports__["default"] = NavItem;

    function extraNavItemProperties(cb) {
      NavItem.extraArgsCallbacks.push(cb);
    }

    function customNavItemHref(cb) {
      NavItem.customNavItemHrefs.push(cb);
    }
  });

Discourse.NavItem = require('discourse/models/nav-item').default;
define("discourse/models/session", 
  ["discourse/models/rest","discourse/mixins/singleton","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];
    var Singleton = __dependency2__["default"];

    // A data model representing current session data. You can put transient
    // data here you might want later. It is not stored or serialized anywhere.
    var Session = RestModel.extend({
      init: function () {
        this.set('highestSeenByTopic', {});
      }
    });

    Session.reopenClass(Singleton);
    __exports__["default"] = Session;
  });

Discourse.Session = require('discourse/models/session').default;
define("discourse/models/site", 
  ["ember-addons/ember-computed-decorators","discourse/models/archetype","discourse/models/post-action-type","discourse/mixins/singleton","discourse/models/rest","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var Archetype = __dependency2__["default"];
    var PostActionType = __dependency3__["default"];
    var Singleton = __dependency4__["default"];
    var RestModel = __dependency5__["default"];

    var Site = RestModel.extend(_createDecoratedObject([{
      key: 'isReadOnly',
      initializer: function () {
        return Em.computed.alias('is_readonly');
      }
    }, {
      key: 'notificationLookup',
      decorators: [computed("notification_types")],
      value: function (notificationTypes) {
        var result = [];
        _.each(notificationTypes, function (v, k) {
          return result[v] = k;
        });
        return result;
      }
    }, {
      key: 'flagTypes',
      decorators: [computed("post_action_types.[]")],
      value: function () {
        var postActionTypes = this.get('post_action_types');
        if (!postActionTypes) return [];
        return postActionTypes.filterProperty('is_flag', true);
      }
    }, {
      key: 'topicCountDesc',
      initializer: function () {
        return ['topic_count:desc'];
      }
    }, {
      key: 'categoriesByCount',
      initializer: function () {
        return Ember.computed.sort('categories', 'topicCountDesc');
      }
    }, {
      key: 'sortedCategories',
      decorators: [computed("categoriesByCount", "categories.[]")],
      value: function (cats) {
        var result = [],
            remaining = {};

        cats.forEach(function (c) {
          var parentCategoryId = parseInt(c.get('parent_category_id'), 10);
          if (!parentCategoryId) {
            result.pushObject(c);
          } else {
            remaining[parentCategoryId] = remaining[parentCategoryId] || [];
            remaining[parentCategoryId].pushObject(c);
          }
        });

        Object.keys(remaining).forEach(function (parentCategoryId) {
          var category = result.findBy('id', parseInt(parentCategoryId, 10)),
              index = result.indexOf(category);

          if (index !== -1) {
            result.replace(index + 1, 0, remaining[parentCategoryId]);
          }
        });

        return result;
      }
    }, {
      key: 'postActionTypeById',
      value: function (id) {
        return this.get("postActionByIdLookup.action" + id);
      }
    }, {
      key: 'topicFlagTypeById',
      value: function (id) {
        return this.get("topicFlagByIdLookup.action" + id);
      }
    }, {
      key: 'removeCategory',
      value: function (id) {
        var categories = this.get('categories');
        var existingCategory = categories.findProperty('id', id);
        if (existingCategory) {
          categories.removeObject(existingCategory);
          delete this.get('categoriesById').categoryId;
        }
      }
    }, {
      key: 'updateCategory',
      value: function (newCategory) {
        var categories = this.get('categories');
        var categoryId = Em.get(newCategory, 'id');
        var existingCategory = categories.findProperty('id', categoryId);

        // Don't update null permissions
        if (newCategory.permission === null) {
          delete newCategory.permission;
        }

        if (existingCategory) {
          existingCategory.setProperties(newCategory);
        } else {
          // TODO insert in right order?
          newCategory = this.store.createRecord('category', newCategory);
          categories.pushObject(newCategory);
          this.get('categoriesById')[categoryId] = newCategory;
        }
      }
    }]));

    Site.reopenClass(Singleton, {

      // The current singleton will retrieve its attributes from the `PreloadStore`.
      createCurrent: function () {
        var store = Discourse.__container__.lookup('store:main');
        return store.createRecord('site', PreloadStore.get('site'));
      },

      create: function () {
        var result = this._super.apply(this, arguments);
        var store = result.store;

        if (result.categories) {
          result.categoriesById = {};
          result.categories = _.map(result.categories, function (c) {
            return result.categoriesById[c.id] = store.createRecord('category', c);
          });

          // Associate the categories with their parents
          result.categories.forEach(function (c) {
            if (c.get('parent_category_id')) {
              c.set('parentCategory', result.categoriesById[c.get('parent_category_id')]);
            }
          });
        }

        if (result.trust_levels) {
          result.trustLevels = result.trust_levels.map(function (tl) {
            return Discourse.TrustLevel.create(tl);
          });
          delete result.trust_levels;
        }

        if (result.post_action_types) {
          result.postActionByIdLookup = Em.Object.create();
          result.post_action_types = _.map(result.post_action_types, function (p) {
            var actionType = PostActionType.create(p);
            result.postActionByIdLookup.set("action" + p.id, actionType);
            return actionType;
          });
        }

        if (result.topic_flag_types) {
          result.topicFlagByIdLookup = Em.Object.create();
          result.topic_flag_types = _.map(result.topic_flag_types, function (p) {
            var actionType = PostActionType.create(p);
            result.topicFlagByIdLookup.set("action" + p.id, actionType);
            return actionType;
          });
        }

        if (result.archetypes) {
          result.archetypes = _.map(result.archetypes, function (a) {
            a.site = result;
            return Archetype.create(a);
          });
        }

        if (result.user_fields) {
          result.user_fields = result.user_fields.map(function (uf) {
            return Ember.Object.create(uf);
          });
        }

        return result;
      }
    });

    __exports__["default"] = Site;

    // Sort subcategories under parents
  });

Discourse.Site = require('discourse/models/site').default;
(function () {

var $ = window.jQuery;
// IIFE Wrapped Content Begins:

Discourse.StaticPage = Em.Object.extend();

Discourse.StaticPage.reopenClass({
  find: function(path) {
    return new Em.RSVP.Promise(function(resolve) {
      // Models shouldn't really be doing Ajax request, but this is a huge speed boost if we
      // preload content.
      var $preloaded = $("noscript[data-path=\"/" + path + "\"]");
      if ($preloaded.length) {
        var text = $preloaded.text();
        text = text.match(/<!-- preload-content: -->((?:.|[\n\r])*)<!-- :preload-content -->/)[1];
        resolve(Discourse.StaticPage.create({path: path, html: text}));
      } else {
        Discourse.ajax(path + ".html", {dataType: 'html'}).then(function (result) {
          resolve(Discourse.StaticPage.create({path: path, html: result}));
        });
      }
    });
  }
});


// IIFE Wrapped Content Ends

 })(this);
define("discourse/models/topic-list", 
  ["discourse/models/rest","discourse/models/model","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];
    var Model = __dependency2__["default"];

    function topicsFrom(result, store) {
      if (!result) {
        return;
      }

      // Stitch together our side loaded data
      var categories = Discourse.Category.list(),
          users = Model.extractByKey(result.users, Discourse.User);

      return result.topic_list.topics.map(function (t) {
        t.category = categories.findBy('id', t.category_id);
        t.posters.forEach(function (p) {
          p.user = users[p.user_id];
        });
        if (t.participants) {
          t.participants.forEach(function (p) {
            p.user = users[p.user_id];
          });
        }
        return store.createRecord('topic', t);
      });
    }

    var TopicList = RestModel.extend({
      canLoadMore: Em.computed.notEmpty("more_topics_url"),

      forEachNew: function (topics, callback) {
        var topicIds = [];

        _.each(this.get('topics'), function (topic) {
          return topicIds[topic.get('id')] = true;
        });

        _.each(topics, function (topic) {
          if (!topicIds[topic.id]) {
            callback(topic);
          }
        });
      },

      refreshSort: function (order, ascending) {
        var params = this.get('params') || {};

        if (params.q) {
          // search is unique, nothing else allowed with it
          params = { q: params.q };
        } else {
          params.order = order || params.order;
          params.ascending = ascending;
        }

        this.set('params', params);
      },

      loadMore: function () {
        var _this = this;

        if (this.get('loadingMore')) {
          return Ember.RSVP.resolve();
        }

        var moreUrl = this.get('more_topics_url');
        if (moreUrl) {
          var _ret = (function () {
            var self = _this;
            _this.set('loadingMore', true);

            var store = _this.store;
            return {
              v: Discourse.ajax({ url: moreUrl }).then(function (result) {
                var topicsAdded = 0;

                if (result) {
                  var _ret2 = (function () {
                    // the new topics loaded from the server
                    var newTopics = topicsFrom(result, store),
                        topics = self.get("topics");

                    self.forEachNew(newTopics, function (t) {
                      t.set('highlight', topicsAdded++ === 0);
                      topics.pushObject(t);
                    });

                    self.setProperties({
                      loadingMore: false,
                      more_topics_url: result.topic_list.more_topics_url
                    });

                    Discourse.Session.currentProp('topicList', self);
                    return {
                      v: self.get('more_topics_url')
                    };
                  })();

                  if (typeof _ret2 === 'object') return _ret2.v;
                }
              })
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        } else {
          // Return a promise indicating no more results
          return Ember.RSVP.resolve();
        }
      },

      // loads topics with these ids "before" the current topics
      loadBefore: function (topic_ids) {
        var topicList = this,
            topics = this.get('topics');

        // refresh dupes
        topics.removeObjects(topics.filter(function (topic) {
          return topic_ids.indexOf(topic.get('id')) >= 0;
        }));

        var url = '' + Discourse.getURL("/") + this.get('filter') + '?topic_ids=' + topic_ids.join(",");
        var store = this.store;

        return Discourse.ajax({ url: url }).then(function (result) {
          var i = 0;
          topicList.forEachNew(topicsFrom(result, store), function (t) {
            // highlight the first of the new topics so we can get a visual feedback
            t.set('highlight', true);
            topics.insertAt(i, t);
            i++;
          });
          Discourse.Session.currentProp('topicList', topicList);
        });
      }
    });

    TopicList.reopenClass({

      munge: function (json, store) {
        json.inserted = json.inserted || [];
        json.can_create_topic = json.topic_list.can_create_topic;
        json.more_topics_url = json.topic_list.more_topics_url;
        json.draft_key = json.topic_list.draft_key;
        json.draft_sequence = json.topic_list.draft_sequence;
        json.draft = json.topic_list.draft;
        json.for_period = json.topic_list.for_period;
        json.loaded = true;
        json.per_page = json.topic_list.per_page;
        json.topics = topicsFrom(json, store);

        return json;
      },

      find: function (filter, params) {
        var store = Discourse.__container__.lookup('store:main');
        return store.findFiltered('topicList', { filter: filter, params: params });
      },

      // hide the category when it has no children
      hideUniformCategory: function (list, category) {
        list.set('hideCategory', category && !category.get("has_children"));
      }

    });

    __exports__["default"] = TopicList;
  });
define("discourse/models/topic-tracking-state", 
  ["discourse/lib/notification-levels","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    __exports__.startTracking = startTracking;

    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ("value" in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === "function") { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError("The decorator for method " + descriptor.key + " is of the invalid type " + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var NotificationLevels = __dependency1__["default"];
    var computed = __dependency2__["default"];
    var on = __dependency2__.on;

    function isNew(topic) {
      return topic.last_read_post_number === null && (topic.notification_level !== 0 && !topic.notification_level || topic.notification_level >= NotificationLevels.TRACKING);
    }

    function isUnread(topic) {
      return topic.last_read_post_number !== null && topic.last_read_post_number < topic.highest_post_number && topic.notification_level >= NotificationLevels.TRACKING;
    }

    var TopicTrackingState = Discourse.Model.extend(_createDecoratedObject([{
      key: "messageCount",
      initializer: function () {
        return 0;
      }
    }, {
      key: "_setup",
      decorators: [on("init")],
      value: function () {
        this.unreadSequence = [];
        this.newSequence = [];
        this.states = {};
      }
    }, {
      key: "establishChannels",
      value: function () {
        var tracker = this;

        var process = function (data) {
          if (data.message_type === "delete") {
            tracker.removeTopic(data.topic_id);
            tracker.incrementMessageCount();
          }

          if (data.message_type === "new_topic" || data.message_type === "latest") {
            var muted_category_ids = Discourse.User.currentProp("muted_category_ids");
            if (_.include(muted_category_ids, data.payload.category_id)) {
              return;
            }
          }

          // fill parent_category_id we need it for counting new/unread
          if (data.payload && data.payload.category_id) {
            var category = Discourse.Category.findById(data.payload.category_id);

            if (category && category.parent_category_id) {
              data.payload.parent_category_id = category.parent_category_id;
            }
          }

          if (data.message_type === "latest") {
            tracker.notify(data);
          }

          if (data.message_type === "new_topic" || data.message_type === "unread" || data.message_type === "read") {
            tracker.notify(data);
            var old = tracker.states["t" + data.topic_id];

            // don't add tracking state for read stuff that was not tracked in first place
            if (old || data.message_type !== "read") {
              if (!_.isEqual(old, data.payload)) {
                tracker.states["t" + data.topic_id] = data.payload;
                tracker.incrementMessageCount();
              }
            }
          }
        };

        this.messageBus.subscribe("/new", process);
        this.messageBus.subscribe("/latest", process);
        if (this.currentUser) {
          this.messageBus.subscribe("/unread/" + this.currentUser.get('id'), process);
        }

        this.messageBus.subscribe("/delete", function (msg) {
          var old = tracker.states["t" + msg.topic_id];
          if (old) {
            old.deleted = true;
          }
          tracker.incrementMessageCount();
        });

        this.messageBus.subscribe("/recover", function (msg) {
          var old = tracker.states["t" + msg.topic_id];
          if (old) {
            delete old.deleted;
          }
          tracker.incrementMessageCount();
        });
      }
    }, {
      key: "updateSeen",
      value: function (topicId, highestSeen) {
        if (!topicId || !highestSeen) {
          return;
        }
        var state = this.states["t" + topicId];
        if (state && (!state.last_read_post_number || state.last_read_post_number < highestSeen)) {
          state.last_read_post_number = highestSeen;
          this.incrementMessageCount();
        }
      }
    }, {
      key: "notify",
      value: function (data) {
        if (!this.newIncoming) {
          return;
        }
        if (data.archetype === "private_message") {
          return;
        }

        var filter = this.get("filter");
        var filterCategory = this.get("filterCategory");
        var categoryId = data.payload && data.payload.category_id;

        if (filterCategory && filterCategory.get("id") !== categoryId) {
          var category = categoryId && Discourse.Category.findById(categoryId);
          if (!category || category.get("parentCategory.id") !== filterCategory.get('id')) {
            return;
          }
        }

        if (filter === Discourse.Utilities.defaultHomepage()) {
          var suppressed_from_homepage_category_ids = Discourse.Site.currentProp("suppressed_from_homepage_category_ids");
          if (_.include(suppressed_from_homepage_category_ids, data.payload.category_id)) {
            return;
          }
        }

        if ((filter === "all" || filter === "latest" || filter === "new") && data.message_type === "new_topic") {
          this.addIncoming(data.topic_id);
        }

        if ((filter === "all" || filter === "unread") && data.message_type === "unread") {
          var old = this.states["t" + data.topic_id];
          if (!old || old.highest_post_number === old.last_read_post_number) {
            this.addIncoming(data.topic_id);
          }
        }

        if (filter === "latest" && data.message_type === "latest") {
          this.addIncoming(data.topic_id);
        }

        this.set("incomingCount", this.newIncoming.length);
      }
    }, {
      key: "addIncoming",
      value: function (topicId) {
        if (this.newIncoming.indexOf(topicId) === -1) {
          this.newIncoming.push(topicId);
        }
      }
    }, {
      key: "resetTracking",
      value: function () {
        this.newIncoming = [];
        this.set("incomingCount", 0);
      }
    }, {
      key: "trackIncoming",

      // track how many new topics came for this filter
      value: function (filter) {
        this.newIncoming = [];
        var split = filter.split('/');

        if (split.length >= 4) {
          filter = split[split.length - 1];
          // c/cat/subcat/l/latest
          var category = Discourse.Category.findSingleBySlug(split.splice(1, split.length - 3).join('/'));
          this.set("filterCategory", category);
        } else {
          this.set("filterCategory", null);
        }

        this.set("filter", filter);
        this.set("incomingCount", 0);
      }
    }, {
      key: "hasIncoming",
      decorators: [computed("incomingCount")],
      value: function (incomingCount) {
        return incomingCount && incomingCount > 0;
      }
    }, {
      key: "removeTopic",
      value: function (topic_id) {
        delete this.states["t" + topic_id];
      }
    }, {
      key: "updateTopics",

      // If we have a cached topic list, we can update it from our tracking
      // information.
      value: function (topics) {
        if (Em.isEmpty(topics)) {
          return;
        }

        var states = this.states;
        topics.forEach(function (t) {
          var state = states['t' + t.get('id')];

          if (state) {
            var lastRead = t.get('last_read_post_number');
            if (lastRead !== state.last_read_post_number) {
              var postsCount = t.get('posts_count');
              var newPosts = postsCount - state.highest_post_number,
                  unread = postsCount - state.last_read_post_number;

              if (newPosts < 0) {
                newPosts = 0;
              }
              if (!state.last_read_post_number) {
                unread = 0;
              }
              if (unread < 0) {
                unread = 0;
              }

              t.setProperties({
                highest_post_number: state.highest_post_number,
                last_read_post_number: state.last_read_post_number,
                new_posts: newPosts,
                unread: unread,
                unseen: !state.last_read_post_number
              });
            }
          }
        });
      }
    }, {
      key: "sync",
      value: function (list, filter) {
        var tracker = this,
            states = tracker.states;

        if (!list || !list.topics) {
          return;
        }

        // compensate for delayed "new" topics
        // client side we know they are not new, server side we think they are
        for (var i = list.topics.length - 1; i >= 0; i--) {
          var state = states["t" + list.topics[i].id];
          if (state && state.last_read_post_number > 0) {
            if (filter === "new") {
              list.topics.splice(i, 1);
            } else {
              list.topics[i].set('unseen', false);
              list.topics[i].set('dont_sync', true);
            }
          }
        }

        list.topics.forEach(function (topic) {
          var row = tracker.states["t" + topic.id] || {};
          row.topic_id = topic.id;
          row.notification_level = topic.notification_level;

          if (topic.unseen) {
            row.last_read_post_number = null;
          } else if (topic.unread || topic.new_posts) {
            row.last_read_post_number = topic.highest_post_number - ((topic.unread || 0) + (topic.new_posts || 0));
          } else {
            if (!topic.dont_sync) {
              delete tracker.states["t" + topic.id];
            }
            return;
          }

          row.highest_post_number = topic.highest_post_number;
          if (topic.category) {
            row.category_id = topic.category.id;
          }

          tracker.states["t" + topic.id] = row;
        });

        // Correct missing states, safeguard in case message bus is corrupt
        if ((filter === "new" || filter === "unread") && !list.more_topics_url) {
          (function () {

            var ids = {};
            list.topics.forEach(function (r) {
              return ids["t" + r.id] = true;
            });

            _.each(tracker.states, function (v, k) {

              // we are good if we are on the list
              if (ids[k]) {
                return;
              }

              if (filter === "unread" && isUnread(v)) {
                // pretend read
                v.last_read_post_number = v.highest_post_number;
              }

              if (filter === "new" && isNew(v)) {
                // pretend not new
                v.last_read_post_number = 1;
              }
            });
          })();
        }

        this.incrementMessageCount();
      }
    }, {
      key: "incrementMessageCount",
      value: function () {
        this.set("messageCount", this.get("messageCount") + 1);
      }
    }, {
      key: "countNew",
      value: function (category_id) {
        return _.chain(this.states).where(isNew).where(function (topic) {
          return topic.archetype !== "private_message" && !topic.deleted && (topic.category_id === category_id || topic.parent_category_id === category_id || !category_id);
        }).value().length;
      }
    }, {
      key: "resetNew",
      value: function () {
        var _this = this;

        Object.keys(this.states).forEach(function (id) {
          if (_this.states[id].last_read_post_number === null) {
            delete _this.states[id];
          }
        });
      }
    }, {
      key: "countUnread",
      value: function (category_id) {
        return _.chain(this.states).where(isUnread).where(function (topic) {
          return topic.archetype !== "private_message" && !topic.deleted && (topic.category_id === category_id || topic.parent_category_id === category_id || !category_id);
        }).value().length;
      }
    }, {
      key: "countCategory",
      value: function (category_id) {
        var sum = 0;
        _.each(this.states, function (topic) {
          if (topic.category_id === category_id && !topic.deleted) {
            sum += topic.last_read_post_number === null || topic.last_read_post_number < topic.highest_post_number ? 1 : 0;
          }
        });
        return sum;
      }
    }, {
      key: "lookupCount",
      value: function (name, category) {
        if (name === "latest") {
          return this.lookupCount("new", category) + this.lookupCount("unread", category);
        }

        var categoryId = category ? Em.get(category, "id") : null;
        var categoryName = category ? Em.get(category, "name") : null;

        if (name === "new") {
          return this.countNew(categoryId);
        } else if (name === "unread") {
          return this.countUnread(categoryId);
        } else {
          categoryName = name.split("/")[1];
          if (categoryName) {
            return this.countCategory(categoryId);
          }
        }
      }
    }, {
      key: "loadStates",
      value: function (data) {
        var states = this.states;
        var idMap = Discourse.Category.idMap();

        // I am taking some shortcuts here to avoid 500 gets for
        // a large list
        if (data) {
          _.each(data, function (topic) {
            var category = idMap[topic.category_id];
            if (category && category.parent_category_id) {
              topic.parent_category_id = category.parent_category_id;
            }
            states["t" + topic.topic_id] = topic;
          });
        }
      }
    }]));

    function startTracking(tracking) {
      var data = PreloadStore.get('topicTrackingStates');
      tracking.loadStates(data);
      tracking.initialStatesLength = data && data.length;
      tracking.establishChannels();
      PreloadStore.remove('topicTrackingStates');
    }

    __exports__["default"] = TopicTrackingState;
  });
define("discourse/models/trust-level", 
  ["discourse/models/rest","discourse/lib/computed","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];
    var fmt = __dependency2__.fmt;

    __exports__["default"] = RestModel.extend({
      detailedName: fmt('id', 'name', '%@ - %@')
    });
  });

Discourse.TrustLevel = require('discourse/models/trust-level').default;
define("discourse/models/user-action-stat", 
  ["discourse/models/rest","discourse/models/user-action","discourse/lib/computed","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var RestModel = __dependency1__["default"];
    var UserAction = __dependency2__["default"];
    var i18n = __dependency3__.i18n;

    __exports__["default"] = RestModel.extend({

      isPM: (function () {
        var actionType = this.get('action_type');
        return actionType === UserAction.TYPES.messages_sent || actionType === UserAction.TYPES.messages_received;
      }).property('action_type'),

      description: i18n('action_type', 'user_action_groups.%@'),

      isResponse: (function () {
        var actionType = this.get('action_type');
        return actionType === UserAction.TYPES.replies || actionType === UserAction.TYPES.quotes;
      }).property('action_type')

    });
  });
define("discourse/models/user-posts-stream", 
  ["discourse/lib/computed","discourse/models/admin-post","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var url = __dependency1__.url;
    var AdminPost = __dependency2__["default"];

    __exports__["default"] = Discourse.Model.extend({
      loaded: false,

      _initialize: (function () {
        this.setProperties({
          itemsLoaded: 0,
          canLoadMore: true,
          content: []
        });
      }).on("init"),

      url: url("user.username_lower", "filter", "itemsLoaded", "/posts/%@/%@?offset=%@"),

      filterBy: function (filter) {
        if (this.get("loaded") && this.get("filter") === filter) {
          return Ember.RSVP.resolve();
        }

        this.setProperties({
          filter: filter,
          itemsLoaded: 0,
          canLoadMore: true,
          content: []
        });

        return this.findItems();
      },

      findItems: function () {
        var self = this;
        if (this.get("loading") || !this.get("canLoadMore")) {
          return Ember.RSVP.reject();
        }

        this.set("loading", true);

        return Discourse.ajax(this.get("url"), { cache: false }).then(function (result) {
          if (result) {
            var posts = result.map(function (post) {
              return AdminPost.create(post);
            });
            self.get("content").pushObjects(posts);
            self.setProperties({
              loaded: true,
              itemsLoaded: self.get("itemsLoaded") + posts.length,
              canLoadMore: posts.length > 0
            });
          }
        }).finally(function () {
          self.set("loading", false);
        });
      }

    });
  });
define("discourse/models/user-stream", 
  ["discourse/lib/computed","discourse/models/rest","discourse/models/user-action","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    var url = __dependency1__.url;
    var RestModel = __dependency2__["default"];
    var UserAction = __dependency3__["default"];

    __exports__["default"] = RestModel.extend({
      loaded: false,

      _initialize: (function () {
        this.setProperties({ itemsLoaded: 0, content: [] });
      }).on("init"),

      filterParam: (function () {
        var filter = this.get('filter');
        if (filter === Discourse.UserAction.TYPES.replies) {
          return [UserAction.TYPES.replies, UserAction.TYPES.quotes].join(",");
        }

        if (!filter) {
          return [UserAction.TYPES.topics, UserAction.TYPES.posts].join(",");
        }

        return filter;
      }).property('filter'),

      baseUrl: url('itemsLoaded', 'user.username_lower', '/user_actions.json?offset=%@&username=%@'),

      filterBy: function (filter) {
        this.setProperties({ filter: filter, itemsLoaded: 0, content: [], lastLoadedUrl: null });
        return this.findItems();
      },

      remove: function (userAction) {
        // 1) remove the user action from the child groups
        this.get("content").forEach(function (ua) {
          ["likes", "stars", "edits", "bookmarks"].forEach(function (group) {
            var items = ua.get("childGroups." + group + ".items");
            if (items) {
              items.removeObject(userAction);
            }
          });
        });

        // 2) remove the parents that have no children
        var content = this.get("content").filter(function (ua) {
          return ["likes", "stars", "edits", "bookmarks"].any(function (group) {
            return ua.get("childGroups." + group + ".items.length") > 0;
          });
        });

        this.setProperties({ content: content, itemsLoaded: content.length });
      },

      findItems: function () {
        var self = this;

        var findUrl = this.get('baseUrl');
        if (this.get('filterParam')) {
          findUrl += "&filter=" + this.get('filterParam');
        }

        // Don't load the same stream twice. We're probably at the end.
        var lastLoadedUrl = this.get('lastLoadedUrl');
        if (lastLoadedUrl === findUrl) {
          return Ember.RSVP.resolve();
        }

        if (this.get('loading')) {
          return Ember.RSVP.resolve();
        }
        this.set('loading', true);
        return Discourse.ajax(findUrl, { cache: 'false' }).then(function (result) {
          if (result && result.user_actions) {
            (function () {
              var copy = Em.A();
              result.user_actions.forEach(function (action) {
                action.title = Discourse.Emoji.unescape(Handlebars.Utils.escapeExpression(action.title));
                copy.pushObject(UserAction.create(action));
              });

              self.get('content').pushObjects(UserAction.collapseStream(copy));
              self.setProperties({
                loaded: true,
                itemsLoaded: self.get('itemsLoaded') + result.user_actions.length
              });
            })();
          }
        }).finally(function () {
          self.set('loading', false);
          self.set('lastLoadedUrl', findUrl);
        });
      }

    });
  });
define("discourse/models/user", 
  ["discourse/lib/computed","discourse/models/rest","discourse/models/user-stream","discourse/models/user-posts-stream","discourse/mixins/singleton","discourse/lib/formatter","ember-addons/ember-computed-decorators","discourse/models/badge","discourse/models/user-badge","discourse/models/user-action-stat","discourse/models/user-action","discourse/models/group","discourse/models/topic","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __dependency6__, __dependency7__, __dependency8__, __dependency9__, __dependency10__, __dependency11__, __dependency12__, __dependency13__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var url = __dependency1__.url;
    var RestModel = __dependency2__["default"];
    var UserStream = __dependency3__["default"];
    var UserPostsStream = __dependency4__["default"];
    var Singleton = __dependency5__["default"];
    var longDate = __dependency6__.longDate;
    var computed = __dependency7__.default;
    var observes = __dependency7__.observes;
    var Badge = __dependency8__["default"];
    var UserBadge = __dependency9__["default"];
    var UserActionStat = __dependency10__["default"];
    var UserAction = __dependency11__["default"];
    var Group = __dependency12__["default"];
    var Topic = __dependency13__["default"];

    var User = RestModel.extend(_createDecoratedObject([{
      key: 'hasPMs',
      initializer: function () {
        return Em.computed.gt("private_messages_stats.all", 0);
      }
    }, {
      key: 'hasStartedPMs',
      initializer: function () {
        return Em.computed.gt("private_messages_stats.mine", 0);
      }
    }, {
      key: 'hasUnreadPMs',
      initializer: function () {
        return Em.computed.gt("private_messages_stats.unread", 0);
      }
    }, {
      key: 'hasPosted',
      initializer: function () {
        return Em.computed.gt("post_count", 0);
      }
    }, {
      key: 'hasNotPosted',
      initializer: function () {
        return Em.computed.not("hasPosted");
      }
    }, {
      key: 'canBeDeleted',
      initializer: function () {
        return Em.computed.and("can_be_deleted", "hasNotPosted");
      }
    }, {
      key: 'redirected_to_top',
      initializer: function () {
        return {
          reason: null
        };
      }
    }, {
      key: 'stream',
      decorators: [computed()],
      value: function () {
        return UserStream.create({ user: this });
      }
    }, {
      key: 'postsStream',
      decorators: [computed()],
      value: function () {
        return UserPostsStream.create({ user: this });
      }
    }, {
      key: 'staff',
      initializer: function () {
        return Em.computed.or('admin', 'moderator');
      }
    }, {
      key: 'destroySession',
      value: function () {
        return Discourse.ajax('/session/' + this.get('username'), { type: 'DELETE' });
      }
    }, {
      key: 'searchContext',
      decorators: [computed("username_lower")],
      value: function (username) {
        return {
          type: 'user',
          id: username,
          user: this
        };
      }
    }, {
      key: 'displayName',
      decorators: [computed("username", "name")],
      value: function (username, name) {
        if (Discourse.SiteSettings.enable_names && !Ember.isEmpty(name)) {
          return name;
        }
        return username;
      }
    }, {
      key: 'profileBackground',
      decorators: [computed('profile_background')],
      value: function (bgUrl) {
        if (Em.isEmpty(bgUrl) || !Discourse.SiteSettings.allow_profile_backgrounds) {
          return;
        }
        return ('background-image: url(' + Discourse.getURLWithCDN(bgUrl) + ')').htmlSafe();
      }
    }, {
      key: 'path',
      decorators: [computed()],
      value: function () {
        // no need to observe, requires a hard refresh to update
        return Discourse.getURL('/users/' + this.get('username_lower'));
      }
    }, {
      key: 'pmPath',
      value: function (topic) {
        var userId = this.get('id');
        var username = this.get('username_lower');

        var details = topic && topic.get('details');
        var allowedUsers = details && details.get('allowed_users');
        var groups = details && details.get('allowed_groups');

        // directly targetted so go to inbox
        if (!groups || allowedUsers && allowedUsers.findBy("id", userId)) {
          return Discourse.getURL('/users/' + username + '/messages');
        } else {
          if (groups && groups[0]) {
            return Discourse.getURL('/users/' + username + '/messages/group/' + groups[0].name);
          }
        }
      }
    }, {
      key: 'adminPath',
      initializer: function () {
        return url('id', 'username_lower', "/admin/users/%@1/%@2");
      }
    }, {
      key: 'mutedTopicsPath',
      initializer: function () {
        return url('/latest?state=muted');
      }
    }, {
      key: 'username_lower',
      decorators: [computed("username")],
      value: function (username) {
        return username.toLowerCase();
      }
    }, {
      key: 'trustLevel',
      decorators: [computed("trust_level")],
      value: function (trustLevel) {
        return Discourse.Site.currentProp('trustLevels').findProperty('id', parseInt(trustLevel, 10));
      }
    }, {
      key: 'isBasic',
      initializer: function () {
        return Em.computed.equal('trust_level', 0);
      }
    }, {
      key: 'isLeader',
      initializer: function () {
        return Em.computed.equal('trust_level', 3);
      }
    }, {
      key: 'isElder',
      initializer: function () {
        return Em.computed.equal('trust_level', 4);
      }
    }, {
      key: 'canManageTopic',
      initializer: function () {
        return Em.computed.or('staff', 'isElder');
      }
    }, {
      key: 'isSuspended',
      initializer: function () {
        return Em.computed.equal('suspended', true);
      }
    }, {
      key: 'suspended',
      decorators: [computed("suspended_till")],
      value: function (suspendedTill) {
        return suspendedTill && moment(suspendedTill).isAfter();
      }
    }, {
      key: 'suspendedTillDate',
      decorators: [computed("suspended_till")],
      value: function (suspendedTill) {
        return longDate(suspendedTill);
      }
    }, {
      key: 'changeUsername',
      value: function (new_username) {
        return Discourse.ajax('/users/' + this.get('username_lower') + '/preferences/username', {
          type: 'PUT',
          data: { new_username: new_username }
        });
      }
    }, {
      key: 'changeEmail',
      value: function (email) {
        return Discourse.ajax('/users/' + this.get('username_lower') + '/preferences/email', {
          type: 'PUT',
          data: { email: email }
        });
      }
    }, {
      key: 'copy',
      value: function () {
        return Discourse.User.create(this.getProperties(Object.keys(this)));
      }
    }, {
      key: 'save',
      value: function () {
        var _this = this;

        var data = this.getProperties('bio_raw', 'website', 'location', 'name', 'locale', 'custom_fields', 'user_fields', 'muted_usernames', 'profile_background', 'card_background');

        ['email_always', 'mailing_list_mode', 'external_links_in_new_tab', 'email_digests', 'email_direct', 'email_in_reply_to', 'email_private_messages', 'email_previous_replies', 'dynamic_favicon', 'enable_quoting', 'disable_jump_reply', 'automatically_unpin_topics', 'digest_after_minutes', 'new_topic_duration_minutes', 'auto_track_topics_after_msecs', 'like_notification_frequency', 'include_tl0_in_digests'].forEach(function (s) {
          data[s] = _this.get('user_option.' + s);
        });

        ['muted', 'watched', 'tracked'].forEach(function (s) {
          var cats = _this.get(s + 'Categories').map(function (c) {
            return c.get('id');
          });
          // HACK: denote lack of categories
          if (cats.length === 0) {
            cats = [-1];
          }
          data[s + '_category_ids'] = cats;
        });

        if (!Discourse.SiteSettings.edit_history_visible_to_public) {
          data['edit_history_public'] = this.get('user_option.edit_history_public');
        }

        // TODO: We can remove this when migrated fully to rest model.
        this.set('isSaving', true);
        return Discourse.ajax('/users/' + this.get('username_lower'), {
          data: data,
          type: 'PUT'
        }).then(function (result) {
          _this.set('bio_excerpt', result.user.bio_excerpt);
          var userProps = Em.getProperties(_this.get('user_option'), 'enable_quoting', 'external_links_in_new_tab', 'dynamic_favicon');
          Discourse.User.current().setProperties(userProps);
        }).finally(function () {
          _this.set('isSaving', false);
        });
      }
    }, {
      key: 'changePassword',
      value: function () {
        return Discourse.ajax("/session/forgot_password", {
          dataType: 'json',
          data: { login: this.get('username') },
          type: 'POST'
        });
      }
    }, {
      key: 'loadUserAction',
      value: function (id) {
        var _this2 = this;

        var stream = this.get('stream');
        return Discourse.ajax('/user_actions/' + id + '.json', { cache: 'false' }).then(function (result) {
          if (result && result.user_action) {
            var ua = result.user_action;

            if ((_this2.get('stream.filter') || ua.action_type) !== ua.action_type) return;
            if (!_this2.get('stream.filter') && !_this2.inAllStream(ua)) return;

            ua.title = Discourse.Emoji.unescape(Handlebars.Utils.escapeExpression(ua.title));
            var action = UserAction.collapseStream([UserAction.create(ua)]);
            stream.set('itemsLoaded', stream.get('itemsLoaded') + 1);
            stream.get('content').insertAt(0, action[0]);
          }
        });
      }
    }, {
      key: 'inAllStream',
      value: function (ua) {
        return ua.action_type === UserAction.TYPES.posts || ua.action_type === UserAction.TYPES.topics;
      }
    }, {
      key: 'displayGroups',
      decorators: [computed("groups.[]")],
      value: function () {
        var groups = this.get('groups');
        var filtered = groups.filter(function (group) {
          return !group.automatic || group.name === "moderators";
        });
        return filtered.length === 0 ? null : filtered;
      }
    }, {
      key: 'statsCountNonPM',
      decorators: [computed("statsExcludingPms.@each.count")],
      value: function () {
        var _this3 = this;

        if (Ember.isEmpty(this.get('statsExcludingPms'))) return 0;
        var count = 0;
        _.each(this.get('statsExcludingPms'), function (val) {
          if (_this3.inAllStream(val)) {
            count += val.count;
          }
        });
        return count;
      }
    }, {
      key: 'statsExcludingPms',
      decorators: [computed("stats.@each.isPM")],
      value: function () {
        if (Ember.isEmpty(this.get('stats'))) return [];
        return this.get('stats').rejectProperty('isPM');
      }
    }, {
      key: 'findDetails',
      value: function (options) {
        var user = this;

        return PreloadStore.getAndRemove('user_' + user.get('username'), function () {
          return Discourse.ajax('/users/' + user.get('username') + '.json', { data: options });
        }).then(function (json) {

          if (!Em.isEmpty(json.user.stats)) {
            json.user.stats = Discourse.User.groupStats(_.map(json.user.stats, function (s) {
              if (s.count) s.count = parseInt(s.count, 10);
              return UserActionStat.create(s);
            }));
          }

          if (!Em.isEmpty(json.user.groups)) {
            json.user.groups = json.user.groups.map(function (g) {
              return Group.create(g);
            });
          }

          if (json.user.invited_by) {
            json.user.invited_by = Discourse.User.create(json.user.invited_by);
          }

          if (!Em.isEmpty(json.user.featured_user_badge_ids)) {
            (function () {
              var userBadgesMap = {};
              UserBadge.createFromJson(json).forEach(function (userBadge) {
                userBadgesMap[userBadge.get('id')] = userBadge;
              });
              json.user.featured_user_badges = json.user.featured_user_badge_ids.map(function (id) {
                return userBadgesMap[id];
              });
            })();
          }

          if (json.user.card_badge) {
            json.user.card_badge = Badge.create(json.user.card_badge);
          }

          user.setProperties(json.user);
          return user;
        });
      }
    }, {
      key: 'findStaffInfo',
      value: function () {
        var _this4 = this;

        if (!Discourse.User.currentProp("staff")) {
          return Ember.RSVP.resolve(null);
        }
        return Discourse.ajax('/users/' + this.get("username_lower") + '/staff-info.json').then(function (info) {
          _this4.setProperties(info);
        });
      }
    }, {
      key: 'pickAvatar',
      value: function (upload_id, type, avatar_template) {
        var _this5 = this;

        return Discourse.ajax('/users/' + this.get("username_lower") + '/preferences/avatar/pick', {
          type: 'PUT',
          data: { upload_id: upload_id, type: type }
        }).then(function () {
          return _this5.setProperties({
            avatar_template: avatar_template,
            uploaded_avatar_id: upload_id
          });
        });
      }
    }, {
      key: 'isAllowedToUploadAFile',
      value: function (type) {
        return this.get('staff') || this.get('trust_level') > 0 || Discourse.SiteSettings['newuser_max_' + type + 's'] > 0;
      }
    }, {
      key: 'createInvite',
      value: function (email, group_names) {
        return Discourse.ajax('/invites', {
          type: 'POST',
          data: { email: email, group_names: group_names }
        });
      }
    }, {
      key: 'generateInviteLink',
      value: function (email, group_names, topic_id) {
        return Discourse.ajax('/invites/link', {
          type: 'POST',
          data: { email: email, group_names: group_names, topic_id: topic_id }
        });
      }
    }, {
      key: 'updateMutedCategories',
      decorators: [observes("muted_category_ids")],
      value: function () {
        this.set("mutedCategories", Discourse.Category.findByIds(this.muted_category_ids));
      }
    }, {
      key: 'updateTrackedCategories',
      decorators: [observes("tracked_category_ids")],
      value: function () {
        this.set("trackedCategories", Discourse.Category.findByIds(this.tracked_category_ids));
      }
    }, {
      key: 'updateWatchedCategories',
      decorators: [observes("watched_category_ids")],
      value: function () {
        this.set("watchedCategories", Discourse.Category.findByIds(this.watched_category_ids));
      }
    }, {
      key: 'canDeleteAccount',
      decorators: [computed("can_delete_account", "reply_count", "topic_count")],
      value: function (canDeleteAccount, replyCount, topicCount) {
        return !Discourse.SiteSettings.enable_sso && canDeleteAccount && (replyCount || 0) + (topicCount || 0) <= 1;
      }
    }, {
      key: "delete",
      initializer: function () {
        return function () {
          if (this.get('can_delete_account')) {
            return Discourse.ajax("/users/" + this.get('username'), {
              type: 'DELETE',
              data: { context: window.location.pathname }
            });
          } else {
            return Ember.RSVP.reject(I18n.t('user.delete_yourself_not_allowed'));
          }
        };
      }
    }, {
      key: 'dismissBanner',
      value: function (bannerKey) {
        this.set("dismissed_banner_key", bannerKey);
        Discourse.ajax('/users/' + this.get('username'), {
          type: 'PUT',
          data: { dismissed_banner_key: bannerKey }
        });
      }
    }, {
      key: 'checkEmail',
      value: function () {
        var _this6 = this;

        return Discourse.ajax('/users/' + this.get("username_lower") + '/emails.json', {
          type: "PUT",
          data: { context: window.location.pathname }
        }).then(function (result) {
          if (result) {
            _this6.setProperties({
              email: result.email,
              associated_accounts: result.associated_accounts
            });
          }
        });
      }
    }, {
      key: 'summary',
      value: function () {
        return Discourse.ajax('/users/' + this.get("username_lower") + '/summary.json').then(function (json) {
          var summary = json["user_summary"];
          var topicMap = {};
          var badgeMap = {};

          json.topics.forEach(function (t) {
            return topicMap[t.id] = Topic.create(t);
          });
          Badge.createFromJson(json).forEach(function (b) {
            return badgeMap[b.id] = b;
          });

          summary.topics = summary.topic_ids.map(function (id) {
            return topicMap[id];
          });

          summary.replies.forEach(function (r) {
            r.topic = topicMap[r.topic_id];
            r.url = r.topic.urlForPostNumber(r.post_number);
            r.createdAt = new Date(r.created_at);
          });

          summary.links.forEach(function (l) {
            l.topic = topicMap[l.topic_id];
            l.post_url = l.topic.urlForPostNumber(l.post_number);
          });

          if (summary.badges) {
            summary.badges = summary.badges.map(function (ub) {
              var badge = badgeMap[ub.badge_id];
              badge.count = ub.count;
              return badge;
            });
          }

          return summary;
        });
      }
    }]));

    User.reopenClass(Singleton, {

      // Find a `Discourse.User` for a given username.
      findByUsername: function (username, options) {
        var user = User.create({ username: username });
        return user.findDetails(options);
      },

      // TODO: Use app.register and junk Singleton
      createCurrent: function () {
        var userJson = PreloadStore.get('currentUser');
        if (userJson) {
          var store = Discourse.__container__.lookup('store:main');
          return store.createRecord('user', userJson);
        }
        return null;
      },

      checkUsername: function (username, email, for_user_id) {
        return Discourse.ajax('/users/check_username', {
          data: { username: username, email: email, for_user_id: for_user_id }
        });
      },

      groupStats: function (stats) {
        var responses = UserActionStat.create({
          count: 0,
          action_type: UserAction.TYPES.replies
        });

        stats.filterProperty('isResponse').forEach(function (stat) {
          responses.set('count', responses.get('count') + stat.get('count'));
        });

        var result = Em.A();
        result.pushObjects(stats.rejectProperty('isResponse'));

        var insertAt = 0;
        result.forEach(function (item, index) {
          if (item.action_type === UserAction.TYPES.topics || item.action_type === UserAction.TYPES.posts) {
            insertAt = index + 1;
          }
        });
        if (responses.count > 0) {
          result.insertAt(insertAt, responses);
        }
        return result;
      },

      createAccount: function (attrs) {
        return Discourse.ajax("/users", {
          data: {
            name: attrs.accountName,
            email: attrs.accountEmail,
            password: attrs.accountPassword,
            username: attrs.accountUsername,
            password_confirmation: attrs.accountPasswordConfirm,
            challenge: attrs.accountChallenge,
            user_fields: attrs.userFields
          },
          type: 'POST'
        });
      }
    });

    __exports__["default"] = User;

    // The user's stat count, excluding PMs.

    // The user's stats, excluding PMs.
  });

Discourse.User = require('discourse/models/user').default;
define("discourse/components/activity-filter", 
  ["discourse/mixins/string-buffer","discourse/models/user-action","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var StringBuffer = __dependency1__["default"];
    var UserAction = __dependency2__["default"];

    __exports__["default"] = Ember.Component.extend(StringBuffer, {
      tagName: 'li',
      classNameBindings: ['active', 'noGlyph'],

      rerenderTriggers: ['content.count', 'count'],
      noGlyph: Em.computed.empty('icon'),

      isIndexStream: (function () {
        return !this.get('content');
      }).property('content.count'),

      active: (function () {
        if (this.get('isIndexStream')) {
          return !this.get('userActionType');
        }
        var content = this.get('content');
        if (content) {
          return parseInt(this.get('userActionType'), 10) === parseInt(Em.get(content, 'action_type'), 10);
        }
      }).property('userActionType', 'isIndexStream'),

      activityCount: (function () {
        return this.get('content.count') || this.get('count') || 0;
      }).property('content.count', 'count'),

      typeKey: (function () {
        var actionType = this.get('content.action_type');
        if (actionType === UserAction.TYPES.messages_received) {
          return "";
        }

        var result = UserAction.TYPES_INVERTED[actionType];
        if (!result) {
          return "";
        }

        // We like our URLS to have hyphens, not underscores
        return "/" + result.replace("_", "-");
      }).property('content.action_type'),

      url: (function () {
        return "/users/" + this.get('user.username_lower') + "/activity" + this.get('typeKey');
      }).property('typeKey', 'user.username_lower'),

      description: (function () {
        return this.get('content.description') || I18n.t("user.filters.all");
      }).property('content.description'),

      renderString: function (buffer) {
        buffer.push("<a href='" + this.get('url') + "'>");
        var icon = this.get('icon');
        if (icon) {
          buffer.push("<i class='glyph fa fa-" + icon + "'></i> ");
        }
        buffer.push(this.get('description') + " <span class='count'>(" + this.get('activityCount') + ")</span></a>");
      },

      icon: (function () {
        switch (parseInt(this.get('content.action_type'), 10)) {
          case UserAction.TYPES.likes_received:
            return "heart";
          case UserAction.TYPES.bookmarks:
            return "bookmark";
          case UserAction.TYPES.edits:
            return "pencil";
          case UserAction.TYPES.replies:
            return "reply";
          case UserAction.TYPES.mentions:
            return "at";
        }
      }).property("content.action_type")
    });
  });
define("discourse/components/auto-close-form", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ("value" in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === "function") { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError("The decorator for method " + descriptor.key + " is of the invalid type " + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var observes = __dependency1__.observes;

    __exports__["default"] = Ember.Component.extend(_createDecoratedObject([{
      key: "limited",
      initializer: function () {
        return false;
      }
    }, {
      key: "autoCloseValid",
      initializer: function () {
        return false;
      }
    }, {
      key: "autoCloseUnits",
      decorators: [computed("limited")],
      value: function (limited) {
        var key = limited ? "composer.auto_close.limited.units" : "composer.auto_close.all.units";
        return I18n.t(key);
      }
    }, {
      key: "autoCloseExamples",
      decorators: [computed("limited")],
      value: function (limited) {
        var key = limited ? "composer.auto_close.limited.examples" : "composer.auto_close.all.examples";
        return I18n.t(key);
      }
    }, {
      key: "_updateAutoCloseValid",
      decorators: [observes("autoCloseTime", "limited")],
      value: function () {
        var limited = this.get("limited"),
            autoCloseTime = this.get("autoCloseTime"),
            isValid = this._isAutoCloseValid(autoCloseTime, limited);
        this.set("autoCloseValid", isValid);
      }
    }, {
      key: "_isAutoCloseValid",
      value: function (autoCloseTime, limited) {
        var t = (autoCloseTime || "").toString().trim();
        if (t.length === 0) {
          // "empty" is always valid
          return true;
        } else if (limited) {
          // only # of hours in limited mode
          return t.match(/^(\d+\.)?\d+$/);
        } else {
          if (t.match(/^\d{4}-\d{1,2}-\d{1,2}(?: \d{1,2}:\d{2}(\s?[AP]M)?){0,1}$/i)) {
            // timestamp must be in the future
            return moment(t).isAfter();
          } else {
            // either # of hours or absolute time
            return (t.match(/^(\d+\.)?\d+$/) || t.match(/^\d{1,2}:\d{2}(\s?[AP]M)?$/i)) !== null;
          }
        }
      }
    }]));
  });
define("discourse/components/avatar-uploader", 
  ["ember-addons/ember-computed-decorators","discourse/mixins/upload","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ("value" in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === "function") { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError("The decorator for method " + descriptor.key + " is of the invalid type " + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var UploadMixin = __dependency2__["default"];

    __exports__["default"] = Em.Component.extend(UploadMixin, _createDecoratedObject([{
      key: "type",
      initializer: function () {
        return "avatar";
      }
    }, {
      key: "tagName",
      initializer: function () {
        return "span";
      }
    }, {
      key: "imageIsNotASquare",
      initializer: function () {
        return false;
      }
    }, {
      key: "uploadButtonText",
      decorators: [computed("uploading")],
      value: function (uploading) {
        return uploading ? I18n.t("uploading") : I18n.t("user.change_avatar.upload_picture");
      }
    }, {
      key: "uploadDone",
      value: function (upload) {
        this.setProperties({
          imageIsNotASquare: upload.width !== upload.height,
          uploadedAvatarTemplate: upload.url,
          uploadedAvatarId: upload.id
        });

        this.sendAction("done");
      }
    }, {
      key: "data",
      decorators: [computed("user_id")],
      value: function (user_id) {
        return { user_id: user_id };
      }
    }]));
  });
define("discourse/components/badge-button", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Component.extend({
      tagName: 'span',
      classNameBindings: [':user-badge', 'badge.badgeTypeClassName'],
      title: (function () {
        return $("<div>" + this.get('badge.description') + "</div>").text();
      }).property('badge.description'),
      attributeBindings: ['data-badge-name', 'title'],
      'data-badge-name': Em.computed.alias('badge.name')
    });
  });
define("discourse/components/badge-card", 
  ["ember-addons/ember-computed-decorators","discourse/lib/url","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];
    var DiscourseURL = __dependency2__["default"];

    __exports__["default"] = Ember.Component.extend(_createDecoratedObject([{
      key: 'size',
      initializer: function () {
        return 'medium';
      }
    }, {
      key: 'classNameBindings',
      initializer: function () {
        return [':badge-card', 'size', 'navigateOnClick:hyperlink'];
      }
    }, {
      key: 'click',
      value: function (e) {
        if (e.target && e.target.nodeName === "A") {
          return true;
        }

        if (!this.get('navigateOnClick')) {
          return false;
        }

        var url = this.get('badge.url');
        var username = this.get('username');
        if (username) {
          url = url + "?username=" + encodeURIComponent(username);
        }
        DiscourseURL.routeTo(url);
        return true;
      }
    }, {
      key: 'displayCount',
      decorators: [computed('count', 'badge.grant_count')],
      value: function (count, grantCount) {
        if (count == null) {
          return grantCount;
        }
        if (count > 1) {
          return count;
        }
      }
    }, {
      key: 'summary',
      decorators: [computed('size')],
      value: function (size) {
        if (size === 'large') {
          var longDescription = this.get('badge.long_description');
          if (!_.isEmpty(longDescription)) {
            return Discourse.Emoji.unescape(longDescription);
          }
        }
        return this.get('badge.description');
      }
    }]));
  });
define("discourse/components/basic-topic-list", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Component.extend({
      loadingMore: Ember.computed.alias('topicList.loadingMore'),
      loading: Ember.computed.not('loaded'),

      loaded: (function () {
        var topicList = this.get('topicList');
        if (topicList) {
          return topicList.get('loaded');
        } else {
          return true;
        }
      }).property('topicList.loaded'),

      _topicListChanged: (function () {
        this._initFromTopicList(this.get('topicList'));
      }).observes('topicList.[]'),

      _initFromTopicList: function (topicList) {
        if (topicList !== null) {
          this.set('topics', topicList.get('topics'));
          this.rerender();
        }
      },

      init: function () {
        this._super();
        var topicList = this.get('topicList');
        if (topicList) {
          this._initFromTopicList(topicList);
        } else {
          // Without a topic list, we assume it's loaded always.
          this.set('loaded', true);
        }
      },

      click: function (e) {
        // Mobile basic-topic-list doesn't use the `topic-list-item` view so
        // the event for the topic entrance is never wired up.
        if (!this.site.mobileView) {
          return;
        }

        var target = $(e.target);

        if (target.hasClass('posts-map')) {
          var topicId = target.closest('tr').attr('data-topic-id');
          if (topicId) {
            if (target.prop('tagName') !== 'A') {
              target = target.find('a');
            }

            var topic = this.get('topics').findProperty('id', parseInt(topicId));
            this.sendAction('postsAction', { topic: topic, position: target.offset() });
          }
          return false;
        }
      }

    });
  });
define("discourse/components/bread-crumbs", 
  ["exports"],
  function(__exports__) {
    "use strict";
    //  A breadcrumb including category drop downs
    __exports__["default"] = Ember.Component.extend({
      classNameBindings: ['hidden:hidden', ':category-breadcrumb'],
      tagName: 'ol',
      parentCategory: Em.computed.alias('category.parentCategory'),

      parentCategories: Em.computed.filter('categories', function (c) {
        if (c.id === this.site.get("uncategorized_category_id") && !this.siteSettings.allow_uncategorized_topics) {
          // Don't show "uncategorized" if allow_uncategorized_topics setting is false.
          return false;
        }
        return !c.get('parentCategory');
      }),

      hidden: (function () {
        return this.site.mobileView && !this.get('category');
      }).property('category'),

      firstCategory: (function () {
        return this.get('parentCategory') || this.get('category');
      }).property('parentCategory', 'category'),

      secondCategory: (function () {
        if (this.get('parentCategory')) return this.get('category');
        return null;
      }).property('category', 'parentCategory'),

      childCategories: (function () {
        if (this.get('hideSubcategories')) {
          return [];
        }
        var firstCategory = this.get('firstCategory');
        if (!firstCategory) {
          return [];
        }

        return this.get('categories').filter(function (c) {
          return c.get('parentCategory') === firstCategory;
        });
      }).property('firstCategory', 'hideSubcategories'),

      render: function (buffer) {
        if (this.get('hidden')) {
          return;
        }
        this._super(buffer);
      }

    });
  });
define("discourse/components/bulk-select-button", 
  ["discourse/lib/show-modal","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var showModal = __dependency1__["default"];

    __exports__["default"] = Ember.Component.extend({
      actions: {
        showBulkActions: function () {
          var _this = this;

          var controller = showModal('topic-bulk-actions', { model: this.get('selected'), title: 'topics.bulk.actions' });
          controller.set('refreshClosure', function () {
            return _this.sendAction();
          });
        }
      }
    });
  });
define("discourse/components/categories-admin-dropdown", 
  ["discourse/helpers/fa-icon","discourse/components/dropdown-button","ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var iconHTML = __dependency1__.iconHTML;
    var DropdownButton = __dependency2__["default"];
    var computed = __dependency3__["default"];

    __exports__["default"] = DropdownButton.extend(_createDecoratedObject([{
      key: 'buttonExtraClasses',
      initializer: function () {
        return 'no-text';
      }
    }, {
      key: 'title',
      initializer: function () {
        return '';
      }
    }, {
      key: 'text',
      initializer: function () {
        return iconHTML('bars') + ' ' + iconHTML('caret-down');
      }
    }, {
      key: 'classNames',
      initializer: function () {
        return ['category-notification-menu', 'category-admin-menu'];
      }
    }, {
      key: 'dropDownContent',
      decorators: [computed()],
      value: function () {
        var includeReorder = this.get('siteSettings.fixed_category_positions');
        var items = [{ id: 'create',
          title: I18n.t('category.create'),
          description: I18n.t('category.create_long'),
          styleClasses: 'fa fa-plus' }];
        if (includeReorder) {
          items.push({
            id: 'reorder',
            title: I18n.t('categories.reorder.title'),
            description: I18n.t('categories.reorder.title_long'),
            styleClasses: 'fa fa-random'
          });
        }
        return items;
      }
    }, {
      key: 'actionNames',
      initializer: function () {
        return {
          create: 'createCategory',
          reorder: 'reorderCategories'
        };
      }
    }, {
      key: 'clicked',
      value: function (id) {
        this.sendAction('actionNames.' + id);
      }
    }]));
  });
define("discourse/components/category-chooser", 
  ["discourse/components/combo-box","discourse/helpers/category-link","ember-addons/ember-computed-decorators","discourse/models/permission-type","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var ComboboxView = __dependency1__["default"];
    var categoryBadgeHTML = __dependency2__.categoryBadgeHTML;
    var computed = __dependency3__["default"];
    var observes = __dependency3__.observes;
    var on = __dependency3__.on;
    var PermissionType = __dependency4__["default"];

    __exports__["default"] = ComboboxView.extend(_createDecoratedObject([{
      key: 'classNames',
      initializer: function () {
        return ['combobox category-combobox'];
      }
    }, {
      key: 'dataAttributes',
      initializer: function () {
        return ['id', 'description_text'];
      }
    }, {
      key: 'overrideWidths',
      initializer: function () {
        return true;
      }
    }, {
      key: 'castInteger',
      initializer: function () {
        return true;
      }
    }, {
      key: 'content',
      decorators: [computed("scopedCategoryId", "categories")],
      value: function (scopedCategoryId, categories) {
        // Always scope to the parent of a category, if present
        if (scopedCategoryId) {
          var scopedCat = Discourse.Category.findById(scopedCategoryId);
          scopedCategoryId = scopedCat.get('parent_category_id') || scopedCat.get('id');
        }

        return categories.filter(function (c) {
          if (scopedCategoryId && c.get('id') !== scopedCategoryId && c.get('parent_category_id') !== scopedCategoryId) {
            return false;
          }
          if (c.get('isUncategorizedCategory')) {
            return false;
          }
          return c.get('permission') === PermissionType.FULL;
        });
      }
    }, {
      key: '_updateCategories',
      decorators: [observes("site.sortedCategories"), on("init")],
      value: function () {
        if (!this.get('categories')) {
          var categories = Discourse.SiteSettings.fixed_category_positions_on_create ? Discourse.Category.list() : Discourse.Category.listByActivity();
          this.set('categories', categories);
        }
      }
    }, {
      key: 'none',
      decorators: [computed("rootNone")],
      value: function (rootNone) {
        if (Discourse.SiteSettings.allow_uncategorized_topics) {
          if (rootNone) {
            return "category.none";
          } else {
            return Discourse.Category.findUncategorized();
          }
        } else {
          return 'category.choose';
        }
      }
    }, {
      key: 'comboTemplate',
      value: function (item) {
        var category = undefined;

        // If we have no id, but text with the uncategorized name, we can use that badge.
        if (Ember.isEmpty(item.id)) {
          var uncat = Discourse.Category.findUncategorized();
          if (uncat && uncat.get('name') === item.text) {
            category = uncat;
          }
        } else {
          category = Discourse.Category.findById(parseInt(item.id, 10));
        }

        if (!category) return item.text;
        var result = categoryBadgeHTML(category, { link: false, allowUncategorized: true, hideParent: true });
        var parentCategoryId = category.get('parent_category_id');

        if (parentCategoryId) {
          result = categoryBadgeHTML(Discourse.Category.findById(parentCategoryId), { link: false }) + "&nbsp;" + result;
        }

        result += ' <span class=\'topic-count\'>&times; ' + category.get('topic_count') + '</span>';

        var description = category.get('description');
        // TODO wtf how can this be null?;
        if (description && description !== 'null') {
          result += '<div class="category-desc">' + description.substr(0, 200) + (description.length > 200 ? '&hellip;' : '') + '</div>';
        }

        return result;
      }
    }]));
  });
define("discourse/components/category-drop", 
  ["discourse/lib/computed","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var setting = __dependency1__.setting;
    var get = Ember.get;

    __exports__["default"] = Ember.Component.extend({
      classNameBindings: ['category::no-category', 'categories:has-drop', 'categoryStyle'],
      categoryStyle: setting('category_style'),
      expanded: false,

      tagName: 'li',

      iconClass: (function () {
        if (this.get('expanded')) {
          return "fa fa-caret-down";
        }
        return "fa fa-caret-right";
      }).property('expanded'),

      allCategoriesUrl: (function () {
        if (this.get('subCategory')) {
          return this.get('parentCategory.url') || "/";
        } else {
          return "/";
        }
      }).property('parentCategory.url', 'subCategory'),

      noCategoriesUrl: (function () {
        return this.get('parentCategory.url') + "/none";
      }).property('parentCategory.url'),

      allCategoriesLabel: (function () {
        if (this.get('subCategory')) {
          return I18n.t('categories.all_subcategories', { categoryName: this.get('parentCategory.name') });
        }
        return I18n.t('categories.all');
      }).property('category'),

      dropdownButtonClass: (function () {
        var result = 'badge-category category-dropdown-button';
        if (Em.isNone(this.get('category'))) {
          result += ' home';
        }
        return result;
      }).property('category'),

      categoryColor: (function () {
        var category = this.get('category');

        if (category) {
          var color = get(category, 'color');

          if (color) {
            var style = "";
            if (color) {
              style += "background-color: #" + color + ";";
            }
            return style.htmlSafe();
          }
        }

        return "background-color: #eee;".htmlSafe();
      }).property('category'),

      badgeStyle: (function () {
        var category = this.get('category');

        if (category) {
          var color = get(category, 'color'),
              textColor = get(category, 'text_color');

          if (color || textColor) {
            var style = "";
            if (color) {
              style += "background-color: #" + color + "; border-color: #" + color + ";";
            }
            if (textColor) {
              style += "color: #" + textColor + "; ";
            }
            return style.htmlSafe();
          }
        }

        return "background-color: #eee; color: #333".htmlSafe();
      }).property('category'),

      clickEventName: (function () {
        return "click.category-drop-" + (this.get('category.id') || "all");
      }).property('category.id'),

      actions: {
        expand: function () {
          var self = this;

          if (!this.get('renderCategories')) {
            this.set('renderCategories', true);
            Em.run.next(function () {
              self.send('expand');
            });
            return;
          }

          if (this.get('expanded')) {
            this.close();
            return;
          }

          if (this.get('categories')) {
            this.set('expanded', true);
          }
          var $dropdown = this.$()[0];

          this.$('a[data-drop-close]').on('click.category-drop', function () {
            self.close();
          });

          Em.run.next(function () {
            self.$('.cat a').add('html').on(self.get('clickEventName'), function (e) {
              var $target = $(e.target),
                  closest = $target.closest($dropdown);

              if ($(e.currentTarget).hasClass('badge-wrapper')) {
                self.close();
              }

              return $(e.currentTarget).hasClass('badge-category') || closest.length && closest[0] === $dropdown ? true : self.close();
            });
          });
        }
      },

      removeEvents: function () {
        $('html').off(this.get('clickEventName'));
        this.$('a[data-drop-close]').off('click.category-drop');
      },

      close: function () {
        this.removeEvents();
        this.set('expanded', false);
      },

      willDestroyElement: function () {
        this.removeEvents();
      }

    });
  });
define("discourse/components/category-group", 
  ["discourse/helpers/category-link","discourse/models/category","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var categoryBadgeHTML = __dependency1__.categoryBadgeHTML;
    var Category = __dependency2__["default"];

    __exports__["default"] = Ember.Component.extend({

      _initializeAutocomplete: (function () {
        var self = this,
            template = this.container.lookup('template:category-group-autocomplete.raw'),
            regexp = new RegExp('href=[\'"]' + Discourse.getURL('/c/') + '([^\'"]+)');

        this.$('input').autocomplete({
          items: this.get('categories'),
          single: false,
          allowAny: false,
          dataSource: function (term) {
            return Category.list().filter(function (category) {
              var regex = new RegExp(term, "i");
              return category.get("name").match(regex) && !_.contains(self.get('blacklist') || [], category) && !_.contains(self.get('categories'), category);
            });
          },
          onChangeItems: function (items) {
            var categories = _.map(items, function (link) {
              var slug = link.match(regexp)[1];
              return Category.findSingleBySlug(slug);
            });
            Em.run.next(function () {
              return self.set("categories", categories);
            });
          },
          template: template,
          transformComplete: function (category) {
            return categoryBadgeHTML(category, { allowUncategorized: true });
          }
        });
      }).on('didInsertElement')

    });
  });
define("discourse/components/category-logo-link", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Em.Component.extend({
      tagName: 'a',
      attributeBindings: ['href'],
      href: (function () {
        return Discourse.getURL('/c/') + Discourse.Category.slugFor(this.get('category'));
      }).property(),

      render: function (buffer) {
        var categoryLogo = this.get('category.logo_url');
        buffer.push('<img class="category-logo" src=\'' + categoryLogo + '\'/>');
      }
    });
  });
define("discourse/components/category-notifications-button", 
  ["discourse/components/notifications-button","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var NotificationsButton = __dependency1__["default"];

    __exports__["default"] = NotificationsButton.extend({
      classNames: ['notification-options', 'category-notification-menu'],
      buttonIncludesText: false,
      hidden: Em.computed.alias('category.deleted'),
      notificationLevel: Em.computed.alias('category.notification_level'),
      i18nPrefix: 'category.notifications',

      clicked: function (id) {
        this.get('category').setNotification(id);
      }
    });
  });
define("discourse/components/category-panel-base", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__.buildCategoryPanel = buildCategoryPanel;
    var CategoryPanelBase = Ember.Component.extend({
      classNameBindings: [':modal-tab', 'activeTab::invisible']
    });

    __exports__["default"] = CategoryPanelBase;

    function buildCategoryPanel(tab, extras) {
      return CategoryPanelBase.extend({
        activeTab: Ember.computed.equal('selectedTab', tab)
      }, extras || {});
    }
  });
define("discourse/components/category-title-link", 
  ["discourse/helpers/fa-icon","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var iconHTML = __dependency1__.iconHTML;

    __exports__["default"] = Em.Component.extend({
      tagName: 'h3',

      render: function (buffer) {
        var category = this.get('category');
        var categoryUrl = Discourse.getURL('/c/') + Discourse.Category.slugFor(category);
        var categoryName = Handlebars.Utils.escapeExpression(category.get('name'));

        if (category.get('read_restricted')) {
          buffer.push(iconHTML('lock'));
        }

        buffer.push('<a href=\'' + categoryUrl + '\'>');
        buffer.push('<span class=\'category-name\'>' + categoryName + '</span>');
        buffer.push('</a>');
      }
    });
  });
define("discourse/components/category-unread", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Component.extend({
      tagName: 'span'
    });
  });
define("discourse/components/cdn-img", 
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = Ember.Component.extend({
      tagName: 'img',
      attributeBindings: ['cdnSrc:src'],

      cdnSrc: (function () {
        return Discourse.getURLWithCDN(this.get('src'));
      }).property('src')
    });
  });
define("discourse/components/check-mark", 
  ["ember-addons/ember-computed-decorators","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    function _createDecoratedObject(descriptors) { var target = {}; for (var i = 0; i < descriptors.length; i++) { var descriptor = descriptors[i]; var decorators = descriptor.decorators; var key = descriptor.key; delete descriptor.key; delete descriptor.decorators; descriptor.enumerable = true; descriptor.configurable = true; if ('value' in descriptor || descriptor.initializer) descriptor.writable = true; if (decorators) { for (var f = 0; f < decorators.length; f++) { var decorator = decorators[f]; if (typeof decorator === 'function') { descriptor = decorator(target, key, descriptor) || descriptor; } else { throw new TypeError('The decorator for method ' + descriptor.key + ' is of the invalid type ' + typeof decorator); } } } if (descriptor.initializer) { descriptor.value = descriptor.initializer.call(target); } Object.defineProperty(target, key, descriptor); } return target; }

    var computed = __dependency1__["default"];

    __exports__["default"] = Ember.Component.extend(_createDecoratedObject([{
      key: 'tagName',
      initializer: function () {
        return 'span';
      }
    }, {
      key: 'classNameBindings',
      initializer: function () {
        return [':check-display', 'status'];
      }
    }, {
      key: 'status',
      decorators: [computed('checked')],
      value: function (checked) {
        return checked ? 'status-checked' : 'status-unchecked';
      }
    }, {
      key: 'render',
      value: function (buffer) {
        var icon = this.get('checked') ? 'check' : 'times';
        buffer.push('<i class=\'fa fa-' + icon + '\'></i>');
      }
    }]));
  });
define("discourse/components/choose-topic", 
  ["discourse/lib/debounce","discourse/lib/search","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var debounce = __dependency1__["default"];
    var searchForTerm = __dependency2__.searchForTerm;

    __exports__["default"] = Ember.Component.extend({
      loading: null,
      noResults: null,
      topics: null,

      topicTitleChanged: (function () {
        this.setProperties({
          loading: true,
          noResults: true,
          selectedTopicId: null
        });
        this.search(this.get('topicTitle'));
      }).observes('topicTitle'),

      topicsChanged: (function () {
        var topics = this.get('topics');
        if (topics) {
          this.set('noResults', topics.length === 0);
        }
        this.set('loading', false);
      }).observes('topics'),

      search: debounce(function (title) {
        var self = this,
            currentTopicId = this.get("currentTopicId");

        if (Em.isEmpty(title)) {
          self.setProperties({ topics: null, loading: false });
          return;
        }

        searchForTerm(title, { typeFilter: 'topic', searchForId: true }).then(function (results) {
          if (results && results.posts && results.posts.length > 0) {
            self.set('topics', results.posts.mapBy('topic').filter(function (t) {
              return t.get("id") !== currentTopicId;
            }));
          } else {
            self.setProperties({ topics: null, loading: false });
          }
        });
      }, 300),

      actions: {
        chooseTopic: function (topic) {
          var topicId = Em.get(topic, 'id');
          this.set('selectedTopicId', topicId);
          Ember.run.next(function () {
            return $('#choose-topic-' + topicId).prop('checked', 'true');
          });
          return false;
        }
      }

    });
  });
define("discourse/components/color-picker", 
  ["discourse/views/container","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var DiscourseContainerView = __dependency1__["default"];

    __exports__["default"] = DiscourseContainerView.extend({
      classNames: 'colors-container',

      _createButtons: (function () {
        var colors = this.get('colors'),
            isUsed,
            usedColors = this.get('usedColors') || [];

        if (!colors) return;

        var self = this;
        colors.forEach(function (color) {
          isUsed = usedColors.indexOf(color.toUpperCase()) >= 0;

          self.attachViewWithArgs({
            tagName: 'button',
            attributeBindings: ['style', 'title'],
            classNames: ['colorpicker'].concat(isUsed ? ['used-color'] : ['unused-color']),
            style: ('background-color: #' + color + ';').htmlSafe(),
            title: isUsed ? I18n.t("category.already_used") : null,
            click: function () {
              self.set("value", color);
              return false;
            }
          });
        });
      }).on('init')
    });
  });
define("discourse/components/composer-editor", 
  ["discourse/lib/user-search","ember-addons/ember-computed-decorators","discourse/lib/link-mentions","discourse/lib/link-category-hashtags","discourse