/* Copyright (C) 1991, 1995, 1996, 1997, 1998, 1999 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* This is a compatibility file.  If we don't build the libc with
   versioning don't compile this file.  */
#if defined PIC && DO_VERSIONING

#include <errno.h>
#include <sys/resource.h>
#include <sys/types.h>

extern int __old_getrlimit (enum __rlimit_resource, struct rlimit *);

/* Put the soft and hard limits for RESOURCE in *RLIMITS.
   Returns 0 if successful, -1 if not (and sets errno).  */
int
__old_getrlimit64 (enum __rlimit_resource resource, struct rlimit64 *rlimits)
{
  struct rlimit rlimits32;

  if (__old_getrlimit (resource, &rlimits32) < 0)
    return -1;

  if (rlimits32.rlim_cur == RLIM_INFINITY >> 1)
    rlimits->rlim_cur = RLIM64_INFINITY >> 1;
  else
    rlimits->rlim_cur = rlimits32.rlim_cur;
  if (rlimits32.rlim_max == RLIM_INFINITY >> 1)
    rlimits->rlim_max = RLIM64_INFINITY >> 1;
  else
    rlimits->rlim_max = rlimits32.rlim_max;

  return 0;
}

symbol_version (__old_getrlimit64, getrlimit64, GLIBC_2.1);

#endif /* PIC && DO_VERSIONING */
