'\"
'\" Copyright (c) 1993-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH continue n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
continue \- Skip to the next iteration of a loop
.SH SYNOPSIS
\fBcontinue\fR
.BE
.SH DESCRIPTION
.PP
This command is typically invoked inside the body of a looping command
such as \fBfor\fR or \fBforeach\fR or \fBwhile\fR.
It returns a 4 (\fBTCL_CONTINUE\fR) result code, which causes a continue
exception to occur.
The exception causes the current script to be aborted
out to the innermost containing loop command, which then
continues with the next iteration of the loop.
Catch exceptions are also handled in a few other situations, such
as the \fBcatch\fR command and the outermost scripts of procedure
bodies.
.SH EXAMPLE
.PP
Print a line for each of the integers from 0 to 10 \fIexcept\fR 5:
.PP
.CS
for {set x 0} {$x<10} {incr x} {
    if {$x == 5} {
        \fBcontinue\fR
    }
    puts "x is $x"
}
.CE
.SH "SEE ALSO"
break(n), for(n), foreach(n), return(n), while(n)
.SH KEYWORDS
continue, iteration, loop
'\" Local Variables:
'\" mode: nroff
'\" End:
