/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceAttachment;
import com.amazonaws.services.ec2.model.InstancePrivateIpAddressResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceNetworkInterface {
    private String networkInterfaceId;
    private String subnetId;
    private String vpcId;
    private String description;
    private String ownerId;
    private String status;
    private String privateIpAddress;
    private String privateDnsName;
    private Boolean sourceDestCheck;
    private List<GroupIdentifier> groups;
    private InstanceNetworkInterfaceAttachment attachment;
    private InstanceNetworkInterfaceAssociation association;
    private List<InstancePrivateIpAddressResponse> privateIpAddresses;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public InstanceNetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public InstanceNetworkInterface withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public InstanceNetworkInterface withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InstanceNetworkInterface withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public InstanceNetworkInterface withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public InstanceNetworkInterface withStatus(String status) {
        this.status = status;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public InstanceNetworkInterface withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public InstanceNetworkInterface withPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public InstanceNetworkInterface withSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
        return this;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public List<GroupIdentifier> getGroups() {
        if (this.groups == null) {
            this.groups = new ArrayList<GroupIdentifier>();
        }
        return this.groups;
    }

    public void setGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ArrayList<GroupIdentifier> groupsCopy = new ArrayList<GroupIdentifier>(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public InstanceNetworkInterface withGroups(GroupIdentifier ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<GroupIdentifier>(groups.length));
        }
        for (GroupIdentifier value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public InstanceNetworkInterface withGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ArrayList<GroupIdentifier> groupsCopy = new ArrayList<GroupIdentifier>(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public InstanceNetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(InstanceNetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
    }

    public InstanceNetworkInterface withAttachment(InstanceNetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    public InstanceNetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(InstanceNetworkInterfaceAssociation association) {
        this.association = association;
    }

    public InstanceNetworkInterface withAssociation(InstanceNetworkInterfaceAssociation association) {
        this.association = association;
        return this;
    }

    public List<InstancePrivateIpAddressResponse> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ArrayList<InstancePrivateIpAddressResponse>();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<InstancePrivateIpAddressResponse> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ArrayList<InstancePrivateIpAddressResponse> privateIpAddressesCopy = new ArrayList<InstancePrivateIpAddressResponse>(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public InstanceNetworkInterface withPrivateIpAddresses(InstancePrivateIpAddressResponse ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<InstancePrivateIpAddressResponse>(privateIpAddresses.length));
        }
        for (InstancePrivateIpAddressResponse value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public InstanceNetworkInterface withPrivateIpAddresses(Collection<InstancePrivateIpAddressResponse> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ArrayList<InstancePrivateIpAddressResponse> privateIpAddressesCopy = new ArrayList<InstancePrivateIpAddressResponse>(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkInterfaceId != null) {
            sb.append("NetworkInterfaceId: " + this.networkInterfaceId + ", ");
        }
        if (this.subnetId != null) {
            sb.append("SubnetId: " + this.subnetId + ", ");
        }
        if (this.vpcId != null) {
            sb.append("VpcId: " + this.vpcId + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.ownerId != null) {
            sb.append("OwnerId: " + this.ownerId + ", ");
        }
        if (this.status != null) {
            sb.append("Status: " + this.status + ", ");
        }
        if (this.privateIpAddress != null) {
            sb.append("PrivateIpAddress: " + this.privateIpAddress + ", ");
        }
        if (this.privateDnsName != null) {
            sb.append("PrivateDnsName: " + this.privateDnsName + ", ");
        }
        if (this.sourceDestCheck != null) {
            sb.append("SourceDestCheck: " + this.sourceDestCheck + ", ");
        }
        if (this.groups != null) {
            sb.append("Groups: " + this.groups + ", ");
        }
        if (this.attachment != null) {
            sb.append("Attachment: " + this.attachment + ", ");
        }
        if (this.association != null) {
            sb.append("Association: " + this.association + ", ");
        }
        if (this.privateIpAddresses != null) {
            sb.append("PrivateIpAddresses: " + this.privateIpAddresses + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.isSourceDestCheck() == null ? 0 : this.isSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getAssociation() == null ? 0 : this.getAssociation().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.isSourceDestCheck() == null ^ this.isSourceDestCheck() == null) {
            return false;
        }
        if (other.isSourceDestCheck() != null && !other.isSourceDestCheck().equals(this.isSourceDestCheck())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getAssociation() == null ^ this.getAssociation() == null) {
            return false;
        }
        if (other.getAssociation() != null && !other.getAssociation().equals(this.getAssociation())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        return other.getPrivateIpAddresses() == null || other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses());
    }
}

