/* $Id: tstIEMAImplDataInt-Amd.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Amd - r150736 on AMD Ryzen Threadripper 3990X 64-Core Processor.
 */

/*
 * Copyright (C) 2022-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

BINU16_TEST_T const g_aTests_bsf_u16_amd[] =
{
    { 0x2f3116, 0x2f3156, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x0805c3, 0x0805c3, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x3c2b17, 0x3c2b57, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x041b86, 0x041bc6, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x3e0ed7, 0x3e0ed7, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x005296, 0x0052d6, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x365c12, 0x365c52, 0xc03e, 0xc03e, 0x0000, 0x0 }, /* #6 */
    { 0x016353, 0x016353, 0xa8fa, 0xa8fa, 0x0000, 0x0 }, /* #7 */
    { 0x0653c7, 0x0653c7, 0xef5d, 0xef5d, 0x0000, 0x0 }, /* #8 */
    { 0x1f6896, 0x1f68d6, 0x24db, 0x24db, 0x0000, 0x0 }, /* #9 */
    { 0x325b43, 0x325b43, 0xc986, 0xc986, 0x0000, 0x0 }, /* #10 */
    { 0x2434c2, 0x2434c2, 0x48b5, 0x48b5, 0x0000, 0x0 }, /* #11 */
    { 0x2614d7, 0x261497, 0xdd1e, 0x0000, 0x065b, 0x0 }, /* #12 */
    { 0x3b4ac3, 0x3b4a83, 0x63a6, 0x0001, 0x3a5a, 0x0 }, /* #13 */
    { 0x140d43, 0x140d03, 0xe0ac, 0x0001, 0x5d46, 0x0 }, /* #14 */
    { 0x174102, 0x174102, 0xb10d, 0x0003, 0xcde8, 0x0 }, /* #15 */
    { 0x075e06, 0x075e06, 0x537e, 0x0000, 0x8869, 0x0 }, /* #16 */
    { 0x326652, 0x326612, 0x710d, 0x0001, 0x2036, 0x0 }, /* #17 */
    { 0x1d7217, 0x1d7217, 0xda63, 0x0000, 0x9abd, 0x0 }, /* #18 */
    { 0x382947, 0x382907, 0x0457, 0x0001, 0xf5f2, 0x0 }, /* #19 */
    { 0x371002, 0x371002, 0xaa1d, 0x0000, 0x68e7, 0x0 }, /* #20 */
    { 0x1a1f96, 0x1a1f96, 0x488a, 0x0000, 0x7091, 0x0 }, /* #21 */
    { 0x026146, 0x026106, 0x65e4, 0x0000, 0x7f83, 0x0 }, /* #22 */
    { 0x1c2182, 0x1c2182, 0x74d0, 0x0003, 0x2918, 0x0 }, /* #23 */
    { 0x1c1857, 0x1c1817, 0x04c2, 0x0003, 0x9498, 0x0 }, /* #24 */
    { 0x050bc3, 0x050b83, 0xabf0, 0x0000, 0x53b9, 0x0 }, /* #25 */
    { 0x041ad6, 0x041a96, 0x3672, 0x0001, 0x766a, 0x0 }, /* #26 */
    { 0x216652, 0x216612, 0xcba5, 0x0000, 0xd709, 0x0 }, /* #27 */
    { 0x181293, 0x181293, 0x2252, 0x0000, 0x5bd5, 0x0 }, /* #28 */
    { 0x3924c7, 0x392487, 0x4e51, 0x0001, 0xb936, 0x0 }, /* #29 */
    { 0x212ed3, 0x212e93, 0xe465, 0x0000, 0xbdc3, 0x0 }, /* #30 */
    { 0x2e75c2, 0x2e7582, 0xd2c6, 0x0000, 0xf289, 0x0 }, /* #31 */
    { 0x043203, 0x043203, 0xc142, 0x0002, 0xd46c, 0x0 }, /* #32 */
    { 0x0a0ed7, 0x0a0e97, 0x0191, 0x0001, 0x144e, 0x0 }, /* #33 */
    { 0x3a3786, 0x3a3786, 0x6bad, 0x0000, 0x50b9, 0x0 }, /* #34 */
    { 0x235002, 0x235002, 0x853b, 0x0000, 0xe9fb, 0x0 }, /* #35 */
    { 0x0c6793, 0x0c6793, 0x05bf, 0x0002, 0x6c94, 0x0 }, /* #36 */
    { 0x3e1c07, 0x3e1c07, 0x1d11, 0x0002, 0x62a4, 0x0 }, /* #37 */
    { 0x3f0183, 0x3f0183, 0x798a, 0x0000, 0x83ff, 0x0 }, /* #38 */
    { 0x230e06, 0x230e06, 0x1e08, 0x0000, 0xdecd, 0x0 }, /* #39 */
    { 0x201513, 0x201513, 0xcf71, 0x0001, 0x138e, 0x0 }, /* #40 */
    { 0x0a6e92, 0x0a6e92, 0x3057, 0x0001, 0xca32, 0x0 }, /* #41 */
    { 0x0c1b93, 0x0c1b93, 0x8f15, 0x0000, 0xae65, 0x0 }, /* #42 */
    { 0x217286, 0x217286, 0x1af0, 0x0000, 0x997b, 0x0 }, /* #43 */
    { 0x240a47, 0x240a07, 0x49c3, 0x0001, 0xacda, 0x0 }, /* #44 */
    { 0x2e2783, 0x2e2783, 0x5607, 0x0000, 0x0c83, 0x0 }, /* #45 */
    { 0x3372c6, 0x337286, 0x55bc, 0x0001, 0xd65e, 0x0 }, /* #46 */
    { 0x114c52, 0x114c12, 0x5f3e, 0x0002, 0xeffc, 0x0 }, /* #47 */
    { 0x0e1a12, 0x0e1a12, 0x3122, 0x0000, 0xdc01, 0x0 }, /* #48 */
    { 0x0f6092, 0x0f6092, 0xcb5c, 0x0000, 0x1f3d, 0x0 }, /* #49 */
    { 0x137546, 0x137506, 0x276e, 0x0000, 0xda79, 0x0 }, /* #50 */
    { 0x1f5093, 0x1f5093, 0x5f7e, 0x0000, 0x8693, 0x0 }, /* #51 */
    { 0x3a48d2, 0x3a4892, 0x9b78, 0x0000, 0xf30f, 0x0 }, /* #52 */
    { 0x2b1e47, 0x2b1e07, 0x03f4, 0x0001, 0xbd12, 0x0 }, /* #53 */
    { 0x1620c7, 0x162087, 0x4d90, 0x0000, 0x4a8d, 0x0 }, /* #54 */
    { 0x041f83, 0x041f83, 0x4578, 0x0000, 0xd891, 0x0 }, /* #55 */
    { 0x284116, 0x284116, 0xfbf9, 0x0000, 0xa5ad, 0x0 }, /* #56 */
    { 0x013783, 0x013783, 0x2d8f, 0x0000, 0x23d3, 0x0 }, /* #57 */
    { 0x2e1112, 0x2e1112, 0x6dae, 0x0000, 0xbaf7, 0x0 }, /* #58 */
    { 0x3638d6, 0x363896, 0x7a89, 0x0000, 0xeb57, 0x0 }, /* #59 */
    { 0x2e4753, 0x2e4713, 0xe029, 0x0000, 0xcddf, 0x0 }, /* #60 */
    { 0x010312, 0x010312, 0xd237, 0x0000, 0x3801, 0x0 }, /* #61 */
    { 0x0c0997, 0x0c0997, 0xd909, 0x0002, 0x0814, 0x0 }, /* #62 */
    { 0x2c1346, 0x2c1306, 0xfef9, 0x0000, 0xcce5, 0x0 }, /* #63 */
    { 0x3a67c6, 0x3a6786, 0x38ba, 0x0000, 0x3e91, 0x0 }, /* #64 */
    { 0x0d5fd7, 0x0d5f97, 0xc48e, 0x0000, 0x636d, 0x0 }, /* #65 */
    { 0x3b4592, 0x3b4592, 0xf9b0, 0x0003, 0xa918, 0x0 }, /* #66 */
    { 0x390796, 0x390796, 0xc51d, 0x0000, 0x2d1d, 0x0 }, /* #67 */
    { 0x2261c3, 0x226183, 0x7671, 0x0001, 0x00ce, 0x0 }, /* #68 */
    { 0x377e96, 0x377e96, 0xbf47, 0x0003, 0xe4f8, 0x0 }, /* #69 */
    { 0x3d6b86, 0x3d6b86, 0x4766, 0x0000, 0x8cf7, 0x0 }, /* #70 */
    { 0x0f4053, 0x0f4013, 0x9cce, 0x0002, 0xb1d4, 0x0 }, /* #71 */
    { 0x2207c2, 0x220782, 0xba8e, 0x0004, 0xfa70, 0x0 }, /* #72 */
    { 0x3d6343, 0x3d6303, 0x0f6e, 0x0004, 0x1cb0, 0x0 }, /* #73 */
    { 0x197f92, 0x197f92, 0x04ce, 0x0000, 0x7d59, 0x0 }, /* #74 */
    { 0x2a0296, 0x2a0296, 0xc553, 0x0000, 0xd637, 0x0 }, /* #75 */
    { 0x2746d2, 0x274692, 0x4893, 0x0004, 0xcb10, 0x0 }, /* #76 */
    { 0x0f2252, 0x0f2212, 0x7f33, 0x0000, 0x038d, 0x0 }, /* #77 */
    { 0x033283, 0x033283, 0x8c8f, 0x0005, 0x22a0, 0x0 }, /* #78 */
    { 0x383816, 0x383816, 0xf53e, 0x0003, 0xd1e8, 0x0 }, /* #79 */
    { 0x317d82, 0x317d82, 0x7251, 0x0000, 0x3d79, 0x0 }, /* #80 */
    { 0x346c47, 0x346c07, 0xb9fc, 0x0000, 0x6a63, 0x0 }, /* #81 */
    { 0x193f53, 0x193f13, 0x4b42, 0x0000, 0xf823, 0x0 }, /* #82 */
    { 0x1f02c2, 0x1f0282, 0x8735, 0x0000, 0xaa7b, 0x0 }, /* #83 */
    { 0x241606, 0x241606, 0xf42c, 0x0000, 0x8b3f, 0x0 }, /* #84 */
    { 0x3c0597, 0x3c0597, 0x53fe, 0x0001, 0x4a6a, 0x0 }, /* #85 */
    { 0x0626d3, 0x062693, 0x2a67, 0x0000, 0xd131, 0x0 }, /* #86 */
    { 0x130b43, 0x130b03, 0x12d4, 0x0004, 0x2f90, 0x0 }, /* #87 */
    { 0x0e2212, 0x0e2212, 0x5a87, 0x0002, 0x709c, 0x0 }, /* #88 */
    { 0x363c82, 0x363c82, 0xc4b3, 0x0000, 0xdd4d, 0x0 }, /* #89 */
    { 0x002586, 0x002586, 0x0384, 0x0005, 0x0d20, 0x0 }, /* #90 */
    { 0x185682, 0x185682, 0xaf60, 0x0001, 0xd3a6, 0x0 }, /* #91 */
    { 0x086dd7, 0x086d97, 0xd188, 0x0001, 0x679e, 0x0 }, /* #92 */
    { 0x383752, 0x383712, 0x1ad1, 0x0001, 0x9dde, 0x0 }, /* #93 */
    { 0x3f6416, 0x3f6416, 0x2055, 0x0000, 0xeaa5, 0x0 }, /* #94 */
    { 0x372bc6, 0x372b86, 0x9f74, 0x0002, 0xae74, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsf_u16_amd = RT_ELEMENTS(g_aTests_bsf_u16_amd);

BINU16_TEST_T const g_aTests_bsr_u16_amd[] =
{
    { 0x157946, 0x157946, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x076313, 0x076353, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x165443, 0x165443, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x133b16, 0x133b56, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x0b46d7, 0x0b46d7, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x352717, 0x352757, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x1b7c07, 0x1b7c47, 0x4054, 0x4054, 0x0000, 0x0 }, /* #6 */
    { 0x1a04d2, 0x1a04d2, 0xaae3, 0xaae3, 0x0000, 0x0 }, /* #7 */
    { 0x244ed2, 0x244ed2, 0x13ac, 0x13ac, 0x0000, 0x0 }, /* #8 */
    { 0x163643, 0x163643, 0xbf43, 0xbf43, 0x0000, 0x0 }, /* #9 */
    { 0x1367d7, 0x1367d7, 0xb25b, 0xb25b, 0x0000, 0x0 }, /* #10 */
    { 0x042ec7, 0x042ec7, 0xc0da, 0xc0da, 0x0000, 0x0 }, /* #11 */
    { 0x2f5f13, 0x2f5f13, 0x3a3e, 0x000f, 0xda7d, 0x0 }, /* #12 */
    { 0x1450c6, 0x145086, 0x7fd3, 0x000a, 0x0651, 0x0 }, /* #13 */
    { 0x385cc3, 0x385c83, 0xa432, 0x000f, 0xfa29, 0x0 }, /* #14 */
    { 0x193296, 0x193296, 0x6b66, 0x000c, 0x183e, 0x0 }, /* #15 */
    { 0x3d22d2, 0x3d2292, 0xb998, 0x000f, 0xdf66, 0x0 }, /* #16 */
    { 0x203c96, 0x203c96, 0x72c5, 0x000c, 0x1339, 0x0 }, /* #17 */
    { 0x0c0b97, 0x0c0b97, 0x3678, 0x000c, 0x1ade, 0x0 }, /* #18 */
    { 0x132157, 0x132117, 0x9843, 0x000e, 0x679e, 0x0 }, /* #19 */
    { 0x0f6897, 0x0f6897, 0x985c, 0x000f, 0xdc10, 0x0 }, /* #20 */
    { 0x3b1e96, 0x3b1e96, 0x5fb6, 0x000f, 0xc437, 0x0 }, /* #21 */
    { 0x1120c6, 0x112086, 0x7eda, 0x000d, 0x249c, 0x0 }, /* #22 */
    { 0x010e47, 0x010e07, 0xf618, 0x000f, 0xa6db, 0x0 }, /* #23 */
    { 0x011407, 0x011407, 0x4005, 0x000d, 0x2343, 0x0 }, /* #24 */
    { 0x2d2b12, 0x2d2b12, 0x1b99, 0x000c, 0x1481, 0x0 }, /* #25 */
    { 0x2f5243, 0x2f5203, 0x3da3, 0x000f, 0xd26c, 0x0 }, /* #26 */
    { 0x2b6c92, 0x2b6c92, 0xb87a, 0x000e, 0x6c84, 0x0 }, /* #27 */
    { 0x3f0883, 0x3f0883, 0xbb92, 0x000e, 0x7d71, 0x0 }, /* #28 */
    { 0x143b47, 0x143b07, 0x6b8c, 0x000f, 0xbb4a, 0x0 }, /* #29 */
    { 0x371cd7, 0x371c97, 0x3573, 0x000e, 0x4820, 0x0 }, /* #30 */
    { 0x023703, 0x023703, 0xe613, 0x000f, 0xf7f7, 0x0 }, /* #31 */
    { 0x3030c7, 0x303087, 0xfc6e, 0x000f, 0xcfd1, 0x0 }, /* #32 */
    { 0x043606, 0x043606, 0x9cb3, 0x000f, 0xdca9, 0x0 }, /* #33 */
    { 0x317016, 0x317016, 0xd616, 0x000e, 0x5c40, 0x0 }, /* #34 */
    { 0x037146, 0x037106, 0x06ec, 0x000f, 0x83fb, 0x0 }, /* #35 */
    { 0x0e5702, 0x0e5702, 0x7b29, 0x000f, 0xe092, 0x0 }, /* #36 */
    { 0x074613, 0x074613, 0x1931, 0x0008, 0x017e, 0x0 }, /* #37 */
    { 0x0b1d57, 0x0b1d17, 0x67aa, 0x000f, 0xfc24, 0x0 }, /* #38 */
    { 0x013b46, 0x013b06, 0xb5fc, 0x000f, 0xbb31, 0x0 }, /* #39 */
    { 0x3315c2, 0x331582, 0xae6d, 0x000f, 0x8533, 0x0 }, /* #40 */
    { 0x337f03, 0x337f03, 0x5532, 0x000f, 0x823a, 0x0 }, /* #41 */
    { 0x2f3996, 0x2f3996, 0xe0ce, 0x000c, 0x1950, 0x0 }, /* #42 */
    { 0x2e6c87, 0x2e6c87, 0xf1b5, 0x000f, 0xc7bf, 0x0 }, /* #43 */
    { 0x2f5992, 0x2f5992, 0x1939, 0x000c, 0x1cbc, 0x0 }, /* #44 */
    { 0x2d3897, 0x2d3897, 0xea81, 0x000f, 0xd65c, 0x0 }, /* #45 */
    { 0x294312, 0x294312, 0x81e5, 0x000f, 0xf350, 0x0 }, /* #46 */
    { 0x233b93, 0x233b93, 0x814e, 0x000e, 0x477f, 0x0 }, /* #47 */
    { 0x392202, 0x392202, 0xd887, 0x000f, 0x99de, 0x0 }, /* #48 */
    { 0x3d4186, 0x3d4186, 0xba4b, 0x000f, 0xc117, 0x0 }, /* #49 */
    { 0x225d43, 0x225d03, 0xcd5a, 0x000b, 0x0984, 0x0 }, /* #50 */
    { 0x0a7192, 0x0a7192, 0xddfd, 0x000e, 0x4031, 0x0 }, /* #51 */
    { 0x217197, 0x217197, 0xa859, 0x000f, 0x8e67, 0x0 }, /* #52 */
    { 0x210f82, 0x210f82, 0xdf62, 0x000f, 0xae6d, 0x0 }, /* #53 */
    { 0x3c7956, 0x3c7916, 0xe50b, 0x000e, 0x4ef9, 0x0 }, /* #54 */
    { 0x264802, 0x264802, 0xa288, 0x000f, 0x9fb0, 0x0 }, /* #55 */
    { 0x2c0747, 0x2c0707, 0x9a39, 0x000c, 0x191c, 0x0 }, /* #56 */
    { 0x162182, 0x162182, 0x836b, 0x000c, 0x122d, 0x0 }, /* #57 */
    { 0x0a7517, 0x0a7517, 0x93fb, 0x000e, 0x741f, 0x0 }, /* #58 */
    { 0x114246, 0x114206, 0xa07c, 0x000e, 0x4036, 0x0 }, /* #59 */
    { 0x0a2d16, 0x0a2d16, 0x3155, 0x000f, 0xf1ef, 0x0 }, /* #60 */
    { 0x260843, 0x260803, 0xdee4, 0x000e, 0x4ed9, 0x0 }, /* #61 */
    { 0x2c2602, 0x2c2602, 0x09a9, 0x000e, 0x4377, 0x0 }, /* #62 */
    { 0x3a67d3, 0x3a6793, 0x00de, 0x000d, 0x2801, 0x0 }, /* #63 */
    { 0x0f7712, 0x0f7712, 0x6188, 0x000e, 0x5796, 0x0 }, /* #64 */
    { 0x3f6146, 0x3f6106, 0x4219, 0x000f, 0x9eb2, 0x0 }, /* #65 */
    { 0x1252d3, 0x125293, 0x7710, 0x000f, 0xbcc5, 0x0 }, /* #66 */
    { 0x2a3e97, 0x2a3e97, 0x80c6, 0x000e, 0x7fd4, 0x0 }, /* #67 */
    { 0x3d6fd2, 0x3d6f92, 0x5a2e, 0x000f, 0xa3fa, 0x0 }, /* #68 */
    { 0x077483, 0x077483, 0x257c, 0x000c, 0x1137, 0x0 }, /* #69 */
    { 0x2f6687, 0x2f6687, 0xef99, 0x000d, 0x373a, 0x0 }, /* #70 */
    { 0x2c4dc6, 0x2c4d86, 0x13dc, 0x000f, 0xf4aa, 0x0 }, /* #71 */
    { 0x0a62d3, 0x0a6293, 0x1784, 0x000a, 0x07d4, 0x0 }, /* #72 */
    { 0x1b1c46, 0x1b1c06, 0x8e74, 0x000f, 0x9e04, 0x0 }, /* #73 */
    { 0x353f52, 0x353f12, 0x2f99, 0x000d, 0x25b2, 0x0 }, /* #74 */
    { 0x0d7947, 0x0d7907, 0x8065, 0x000f, 0x85c2, 0x0 }, /* #75 */
    { 0x092f96, 0x092f96, 0x31f7, 0x000e, 0x5e77, 0x0 }, /* #76 */
    { 0x121396, 0x121396, 0x5e32, 0x000e, 0x4a58, 0x0 }, /* #77 */
    { 0x166896, 0x166896, 0xc3e6, 0x000e, 0x5931, 0x0 }, /* #78 */
    { 0x234743, 0x234703, 0x4010, 0x000c, 0x1440, 0x0 }, /* #79 */
    { 0x3a7d52, 0x3a7d12, 0x3bcf, 0x000f, 0xb97e, 0x0 }, /* #80 */
    { 0x3719c7, 0x371987, 0xcbc2, 0x000e, 0x6972, 0x0 }, /* #81 */
    { 0x266f92, 0x266f92, 0xf8bd, 0x000e, 0x50f3, 0x0 }, /* #82 */
    { 0x3115c6, 0x311586, 0xe8ff, 0x000f, 0xdf47, 0x0 }, /* #83 */
    { 0x395457, 0x395417, 0xb14b, 0x000f, 0xd622, 0x0 }, /* #84 */
    { 0x200047, 0x200007, 0x7322, 0x000f, 0xc776, 0x0 }, /* #85 */
    { 0x0e5516, 0x0e5516, 0x4c7a, 0x000f, 0xf0ac, 0x0 }, /* #86 */
    { 0x123453, 0x123413, 0xeaa7, 0x000f, 0x80fc, 0x0 }, /* #87 */
    { 0x2b5897, 0x2b5897, 0x8230, 0x000e, 0x5c2b, 0x0 }, /* #88 */
    { 0x353c52, 0x353c12, 0x9822, 0x000c, 0x129d, 0x0 }, /* #89 */
    { 0x273342, 0x273302, 0x6ce5, 0x000d, 0x39d4, 0x0 }, /* #90 */
    { 0x3f4bc6, 0x3f4b86, 0x80e6, 0x000f, 0x9ac2, 0x0 }, /* #91 */
    { 0x2763c3, 0x276383, 0xdea3, 0x000f, 0xa45d, 0x0 }, /* #92 */
    { 0x1f0f02, 0x1f0f02, 0xf904, 0x000f, 0xb1e9, 0x0 }, /* #93 */
    { 0x255a16, 0x255a16, 0xf49d, 0x000e, 0x7b14, 0x0 }, /* #94 */
    { 0x0906c2, 0x090682, 0x2d65, 0x000e, 0x45f4, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsr_u16_amd = RT_ELEMENTS(g_aTests_bsr_u16_amd);

BINU16_TEST_T const g_aTests_imul_two_u16_amd[] =
{
    { 0x3a2996, 0x3a2196, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x1559c3, 0x1551c2, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x005292, 0x005292, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x345cd3, 0x3454d2, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x157f86, 0x157786, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x3c5582, 0x3c5582, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x244e53, 0x244652, 0x8406, 0x0000, 0x0000, 0x0 }, /* #6 */
    { 0x365303, 0x365302, 0x7fbc, 0x0000, 0x0000, 0x0 }, /* #7 */
    { 0x034043, 0x034042, 0xef06, 0x0000, 0x0000, 0x0 }, /* #8 */
    { 0x3b2a02, 0x3b2202, 0xaca7, 0x0000, 0x0000, 0x0 }, /* #9 */
    { 0x1c1e53, 0x1c1652, 0x49a6, 0x0000, 0x0000, 0x0 }, /* #10 */
    { 0x0849d3, 0x0841d2, 0x65bf, 0x0000, 0x0000, 0x0 }, /* #11 */
    { 0x220d93, 0x220d93, 0x3fed, 0xe973, 0xe2df, 0x0 }, /* #12 */
    { 0x252d52, 0x252d53, 0x3323, 0xca67, 0x71ed, 0x0 }, /* #13 */
    { 0x201296, 0x201a97, 0x75b8, 0xadd0, 0x9e16, 0x0 }, /* #14 */
    { 0x293953, 0x293953, 0xb237, 0xf841, 0x4d47, 0x0 }, /* #15 */
    { 0x3202c6, 0x320ac7, 0x5ca2, 0xcfb8, 0xa71c, 0x0 }, /* #16 */
    { 0x014a46, 0x014a47, 0x7133, 0xf307, 0xdedd, 0x0 }, /* #17 */
    { 0x1d4012, 0x1d4813, 0x2121, 0xb05c, 0x38dc, 0x0 }, /* #18 */
    { 0x2d2c47, 0x2d2c47, 0x9a6b, 0xe3b0, 0xf710, 0x0 }, /* #19 */
    { 0x106242, 0x106a43, 0x7cf7, 0x95fa, 0x7d56, 0x0 }, /* #20 */
    { 0x3a3253, 0x3a3a53, 0x2e15, 0x2800, 0x8800, 0x0 }, /* #21 */
    { 0x1a3a42, 0x1a3a43, 0x5139, 0xd5d5, 0x957d, 0x0 }, /* #22 */
    { 0x1e5582, 0x1e5d83, 0xc406, 0x7d9a, 0x6aef, 0x0 }, /* #23 */
    { 0x287fd6, 0x287fd7, 0xb60c, 0x5570, 0xd274, 0x0 }, /* #24 */
    { 0x1669c3, 0x1669c3, 0x9b0e, 0x7378, 0xc764, 0x0 }, /* #25 */
    { 0x230fc7, 0x230fc7, 0x2ce2, 0x2e86, 0xeaf3, 0x0 }, /* #26 */
    { 0x2d0706, 0x2d0f07, 0xd3a0, 0xda40, 0xd07a, 0x0 }, /* #27 */
    { 0x387e87, 0x387e87, 0xf5a3, 0x0c12, 0xb0c6, 0x0 }, /* #28 */
    { 0x265493, 0x265c93, 0xb582, 0x5cd2, 0x85a9, 0x0 }, /* #29 */
    { 0x3a3052, 0x3a3853, 0xeaa0, 0xc5e0, 0xcf73, 0x0 }, /* #30 */
    { 0x0b0ad3, 0x0b0ad3, 0xd9d5, 0x0387, 0x59eb, 0x0 }, /* #31 */
    { 0x2065c7, 0x206dc7, 0x1c59, 0x18ec, 0x52cc, 0x0 }, /* #32 */
    { 0x190f16, 0x190f17, 0x8c92, 0x1960, 0xe730, 0x0 }, /* #33 */
    { 0x1d20d7, 0x1d28d7, 0xe28a, 0xfc42, 0x112d, 0x0 }, /* #34 */
    { 0x1637c2, 0x163fc3, 0x182b, 0xa02a, 0xb17e, 0x0 }, /* #35 */
    { 0x267b82, 0x267b83, 0x495d, 0x2363, 0x93bf, 0x0 }, /* #36 */
    { 0x200993, 0x200993, 0xa637, 0x297c, 0xa464, 0x0 }, /* #37 */
    { 0x1c4513, 0x1c4d13, 0x0686, 0x5bd4, 0x5ace, 0x0 }, /* #38 */
    { 0x0d4a03, 0x0d4a03, 0x18b1, 0x03eb, 0x4d5b, 0x0 }, /* #39 */
    { 0x3e3c57, 0x3e3c57, 0x39b1, 0x39e5, 0x9c75, 0x0 }, /* #40 */
    { 0x056a56, 0x056a57, 0xe82c, 0x6f30, 0xbee4, 0x0 }, /* #41 */
    { 0x250916, 0x250917, 0xc14e, 0x6e2c, 0x0cfa, 0x0 }, /* #42 */
    { 0x2b0a42, 0x2b0a43, 0x1c13, 0x0358, 0x2a48, 0x0 }, /* #43 */
    { 0x2a7983, 0x2a7983, 0x6ab8, 0x9038, 0x62d1, 0x0 }, /* #44 */
    { 0x060cd7, 0x060cd7, 0xeb1a, 0xf674, 0xf8a2, 0x0 }, /* #45 */
    { 0x1908c3, 0x1908c3, 0x54d4, 0x3ce0, 0x5158, 0x0 }, /* #46 */
    { 0x1478d6, 0x1478d7, 0x95c8, 0x1b30, 0xa396, 0x0 }, /* #47 */
    { 0x336682, 0x336e83, 0x2bde, 0x9a48, 0x091c, 0x0 }, /* #48 */
    { 0x203cc2, 0x203cc3, 0x27dd, 0xf1b1, 0x5de5, 0x0 }, /* #49 */
    { 0x1270d7, 0x1278d7, 0xee4d, 0xe063, 0x416f, 0x0 }, /* #50 */
    { 0x100897, 0x100897, 0xceb4, 0xd444, 0x9375, 0x0 }, /* #51 */
    { 0x1a1397, 0x1a1b97, 0x7e66, 0x8c26, 0x5da1, 0x0 }, /* #52 */
    { 0x0e7f56, 0x0e7f57, 0x30ae, 0xae8a, 0xfbc3, 0x0 }, /* #53 */
    { 0x226412, 0x226c13, 0xcaf7, 0x5711, 0x2437, 0x0 }, /* #54 */
    { 0x111e06, 0x111e07, 0x5eb6, 0x74ca, 0x293f, 0x0 }, /* #55 */
    { 0x111206, 0x111a07, 0x0e0b, 0x6c11, 0x2bd3, 0x0 }, /* #56 */
    { 0x335002, 0x335803, 0x0773, 0x9eca, 0x4f8e, 0x0 }, /* #57 */
    { 0x3a2a96, 0x3a2a97, 0x291e, 0xe2b4, 0xaa06, 0x0 }, /* #58 */
    { 0x0b00c3, 0x0b08c3, 0xde7b, 0xde17, 0x7a15, 0x0 }, /* #59 */
    { 0x2d0b43, 0x2d0b43, 0x9416, 0xc0f0, 0x6468, 0x0 }, /* #60 */
    { 0x341596, 0x341d97, 0xe1bc, 0x64a0, 0x3d58, 0x0 }, /* #61 */
    { 0x2b17c6, 0x2b1fc7, 0x8cfe, 0x4294, 0x7db6, 0x0 }, /* #62 */
    { 0x205b96, 0x205b97, 0xab08, 0x3a08, 0x9de1, 0x0 }, /* #63 */
    { 0x255c83, 0x255c83, 0x1a1f, 0x9989, 0x2757, 0x0 }, /* #64 */
    { 0x375313, 0x375b13, 0xd597, 0xaa5d, 0xc62b, 0x0 }, /* #65 */
    { 0x266502, 0x266d03, 0x7041, 0x9822, 0xcfa2, 0x0 }, /* #66 */
    { 0x3f1902, 0x3f1903, 0x80bb, 0xfcd5, 0xa7af, 0x0 }, /* #67 */
    { 0x0e0d97, 0x0e0d97, 0xfa12, 0x13ea, 0xcc8d, 0x0 }, /* #68 */
    { 0x2b74d2, 0x2b7cd3, 0xc894, 0x1c24, 0xa215, 0x0 }, /* #69 */
    { 0x3247d2, 0x324fd3, 0x94a4, 0x76f0, 0xcb5c, 0x0 }, /* #70 */
    { 0x3a24c3, 0x3a2cc3, 0xb67f, 0xc5eb, 0x7295, 0x0 }, /* #71 */
    { 0x123092, 0x123893, 0xadad, 0x65d5, 0x4dc9, 0x0 }, /* #72 */
    { 0x2653c7, 0x265bc7, 0x047e, 0x8094, 0xf936, 0x0 }, /* #73 */
    { 0x350297, 0x350a97, 0x6695, 0xbaad, 0xf5b9, 0x0 }, /* #74 */
    { 0x204842, 0x204843, 0x9b66, 0x43ee, 0x60ad, 0x0 }, /* #75 */
    { 0x1a2942, 0x1a2943, 0x6372, 0x5356, 0xf883, 0x0 }, /* #76 */
    { 0x2d7b83, 0x2d7b83, 0x3312, 0x7a5a, 0xf185, 0x0 }, /* #77 */
    { 0x286786, 0x286f87, 0xe121, 0x15dd, 0x513d, 0x0 }, /* #78 */
    { 0x071942, 0x071943, 0x503d, 0x95e6, 0x15de, 0x0 }, /* #79 */
    { 0x073ec7, 0x073ec7, 0x4bea, 0x306c, 0x1f9e, 0x0 }, /* #80 */
    { 0x094c57, 0x094c57, 0x7e95, 0x6924, 0x8f94, 0x0 }, /* #81 */
    { 0x147e86, 0x147e87, 0xf591, 0x185c, 0x349c, 0x0 }, /* #82 */
    { 0x3a2096, 0x3a2897, 0xbebc, 0x8d94, 0x2f2b, 0x0 }, /* #83 */
    { 0x096e93, 0x096e93, 0x2ff6, 0xeac8, 0xeeec, 0x0 }, /* #84 */
    { 0x0a5b03, 0x0a5b03, 0x911c, 0x63c0, 0xc790, 0x0 }, /* #85 */
    { 0x014452, 0x014c53, 0x2ad8, 0xfe90, 0xfe16, 0x0 }, /* #86 */
    { 0x370e86, 0x370e87, 0x4304, 0xc2d8, 0xe836, 0x0 }, /* #87 */
    { 0x0c52c7, 0x0c5ac7, 0xfa29, 0x8a24, 0xc584, 0x0 }, /* #88 */
    { 0x0e7e96, 0x0e7e97, 0x49f7, 0x8d62, 0x152e, 0x0 }, /* #89 */
    { 0x0e3256, 0x0e3a57, 0xf2b2, 0x01a8, 0x98f4, 0x0 }, /* #90 */
    { 0x334a07, 0x334a07, 0x9270, 0xd3a0, 0x1936, 0x0 }, /* #91 */
    { 0x2d3cc3, 0x2d3cc3, 0x5916, 0xce2e, 0xc525, 0x0 }, /* #92 */
    { 0x0936d7, 0x093ed7, 0xd84c, 0x0fa0, 0x8978, 0x0 }, /* #93 */
    { 0x323086, 0x323887, 0x3457, 0x78b4, 0x3c6c, 0x0 }, /* #94 */
    { 0x121357, 0x121b57, 0x1a01, 0x5a1d, 0x681d, 0x0 }, /* #95 */
};
uint32_t const g_cTests_imul_two_u16_amd = RT_ELEMENTS(g_aTests_imul_two_u16_amd);

BINU32_TEST_T const g_aTests_bsf_u32_amd[] =
{
    { 0x157742, 0x157742, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x237646, 0x237646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x072f17, 0x072f57, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x2c7816, 0x2c7856, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x132686, 0x1326c6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x086916, 0x086956, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x3509c2, 0x3509c2, 0xada6a42d, 0xada6a42d, 0x00000000, 0x0 }, /* #6 */
    { 0x243e92, 0x243ed2, 0x571d19fb, 0x571d19fb, 0x00000000, 0x0 }, /* #7 */
    { 0x143997, 0x1439d7, 0x4524a5d6, 0x4524a5d6, 0x00000000, 0x0 }, /* #8 */
    { 0x032812, 0x032852, 0xbbb50e8a, 0xbbb50e8a, 0x00000000, 0x0 }, /* #9 */
    { 0x0d2487, 0x0d24c7, 0x89f483ee, 0x89f483ee, 0x00000000, 0x0 }, /* #10 */
    { 0x010357, 0x010357, 0x2f5758ed, 0x2f5758ed, 0x00000000, 0x0 }, /* #11 */
    { 0x0f6896, 0x0f6896, 0xd023ad88, 0x00000001, 0x5655e4d2, 0x0 }, /* #12 */
    { 0x214346, 0x214306, 0x6f9b39a8, 0x00000001, 0x37e65d02, 0x0 }, /* #13 */
    { 0x246bc7, 0x246b87, 0xc0617adc, 0x00000000, 0x7fc901b5, 0x0 }, /* #14 */
    { 0x0f5397, 0x0f5397, 0x57792da4, 0x00000000, 0x14a396d9, 0x0 }, /* #15 */
    { 0x042bd2, 0x042b92, 0x72b6479d, 0x00000000, 0x9d17cf41, 0x0 }, /* #16 */
    { 0x274353, 0x274313, 0x1c88814d, 0x00000000, 0x45e0f4dd, 0x0 }, /* #17 */
    { 0x2b7d02, 0x2b7d02, 0xca2fa8ef, 0x00000000, 0x7efc08f5, 0x0 }, /* #18 */
    { 0x304dd6, 0x304d96, 0x82cdf99c, 0x00000002, 0x20be7234, 0x0 }, /* #19 */
    { 0x3b4497, 0x3b4497, 0xb2139039, 0x00000000, 0xa261c8b1, 0x0 }, /* #20 */
    { 0x3f0ec7, 0x3f0e87, 0x666cea80, 0x00000000, 0xf8978d35, 0x0 }, /* #21 */
    { 0x372f93, 0x372f93, 0xfe6999fa, 0x00000002, 0xc6fc2cec, 0x0 }, /* #22 */
    { 0x295e56, 0x295e16, 0x4c321614, 0x00000005, 0xec47a220, 0x0 }, /* #23 */
    { 0x251a43, 0x251a03, 0xbf290e03, 0x00000001, 0xa057075a, 0x0 }, /* #24 */
    { 0x233646, 0x233606, 0x3c7b60e5, 0x00000002, 0x48169a3c, 0x0 }, /* #25 */
    { 0x275d42, 0x275d02, 0xab712746, 0x00000000, 0x11c99bc5, 0x0 }, /* #26 */
    { 0x114c56, 0x114c16, 0xbd865ca7, 0x00000000, 0x802cf77f, 0x0 }, /* #27 */
    { 0x2c53c3, 0x2c5383, 0xb702cc39, 0x00000000, 0x18adef39, 0x0 }, /* #28 */
    { 0x343483, 0x343483, 0x79414831, 0x00000003, 0xaceac728, 0x0 }, /* #29 */
    { 0x392a03, 0x392a03, 0x105a3a96, 0x00000004, 0x13bc7710, 0x0 }, /* #30 */
    { 0x2c6642, 0x2c6602, 0x59c96a98, 0x00000000, 0x76752e61, 0x0 }, /* #31 */
    { 0x381f03, 0x381f03, 0x357d8b92, 0x00000000, 0x85565a81, 0x0 }, /* #32 */
    { 0x0f4dc3, 0x0f4d83, 0xcf562795, 0x00000002, 0xe140cfe4, 0x0 }, /* #33 */
    { 0x1012c2, 0x101282, 0x4a151f4c, 0x00000000, 0xf0b9bbbf, 0x0 }, /* #34 */
    { 0x153242, 0x153202, 0x824a877a, 0x00000001, 0xab045bc2, 0x0 }, /* #35 */
    { 0x245453, 0x245413, 0x5e23fdab, 0x00000001, 0xcce2f502, 0x0 }, /* #36 */
    { 0x037d97, 0x037d97, 0xc6f4285b, 0x00000000, 0x478592c1, 0x0 }, /* #37 */
    { 0x256196, 0x256196, 0x1ebd4849, 0x00000001, 0xdcd4e136, 0x0 }, /* #38 */
    { 0x0d4fd7, 0x0d4f97, 0x4ec83aa4, 0x00000002, 0x3b820d64, 0x0 }, /* #39 */
    { 0x3d3ec3, 0x3d3e83, 0x91af781a, 0x00000003, 0x16f5fc08, 0x0 }, /* #40 */
    { 0x357cd6, 0x357c96, 0xca6140dd, 0x00000000, 0xb6e9727d, 0x0 }, /* #41 */
    { 0x1b2982, 0x1b2982, 0x29d74d09, 0x00000003, 0xb602c028, 0x0 }, /* #42 */
    { 0x151dc3, 0x151d83, 0x20aab325, 0x00000002, 0xe6d752e4, 0x0 }, /* #43 */
    { 0x030a82, 0x030a82, 0xa9309ce1, 0x00000001, 0xb68badba, 0x0 }, /* #44 */
    { 0x3a4b03, 0x3a4b03, 0xdea818bd, 0x00000002, 0x6df03004, 0x0 }, /* #45 */
    { 0x206e03, 0x206e03, 0xd361047c, 0x00000002, 0x866d72d4, 0x0 }, /* #46 */
    { 0x0d6043, 0x0d6003, 0x1f88af58, 0x00000003, 0x46afeb68, 0x0 }, /* #47 */
    { 0x077c46, 0x077c06, 0x70c35b86, 0x00000006, 0xe9adf440, 0x0 }, /* #48 */
    { 0x3e2b02, 0x3e2b02, 0xd914f0cd, 0x00000000, 0x2dcd506b, 0x0 }, /* #49 */
    { 0x1a5916, 0x1a5916, 0x74859ad2, 0x00000000, 0xef778cc1, 0x0 }, /* #50 */
    { 0x3a0c13, 0x3a0c13, 0x4d6ebc7c, 0x00000000, 0x6118989b, 0x0 }, /* #51 */
    { 0x0a7916, 0x0a7916, 0xc0a73f5b, 0x00000001, 0x24306fb2, 0x0 }, /* #52 */
    { 0x354283, 0x354283, 0x16e137a5, 0x00000001, 0xdc0c5e32, 0x0 }, /* #53 */
    { 0x3c53d6, 0x3c5396, 0x5ee39be8, 0x00000000, 0xf110cd03, 0x0 }, /* #54 */
    { 0x031917, 0x031917, 0x7333cd94, 0x00000000, 0x0dfdc9cf, 0x0 }, /* #55 */
    { 0x0c3c16, 0x0c3c16, 0x108505d7, 0x00000000, 0xcd428f8d, 0x0 }, /* #56 */
    { 0x1e1993, 0x1e1993, 0xea36b68a, 0x00000002, 0xee0a33ac, 0x0 }, /* #57 */
    { 0x061986, 0x061986, 0xe7910f1b, 0x00000000, 0x6476eabb, 0x0 }, /* #58 */
    { 0x2c4e86, 0x2c4e86, 0xfaaa5a75, 0x00000000, 0x8618f63d, 0x0 }, /* #59 */
    { 0x0e4297, 0x0e4297, 0xcb2c04bb, 0x00000000, 0xb6eab78b, 0x0 }, /* #60 */
    { 0x3822d7, 0x382297, 0x05f78881, 0x00000001, 0x7e22d036, 0x0 }, /* #61 */
    { 0x132912, 0x132912, 0x174297ad, 0x00000002, 0x14f40b9c, 0x0 }, /* #62 */
    { 0x265a56, 0x265a16, 0x03f4f671, 0x00000001, 0x075f9792, 0x0 }, /* #63 */
    { 0x177606, 0x177606, 0xae590e9a, 0x00000000, 0x98cdd90f, 0x0 }, /* #64 */
    { 0x257483, 0x257483, 0x70ca0c4d, 0x00000000, 0xa0edac41, 0x0 }, /* #65 */
    { 0x077042, 0x077002, 0xeb70b53e, 0x00000000, 0x748b308d, 0x0 }, /* #66 */
    { 0x2013c6, 0x201386, 0xeccffdb5, 0x00000001, 0xcb19ade2, 0x0 }, /* #67 */
    { 0x2676d3, 0x267693, 0x095ecd02, 0x00000002, 0xaee5431c, 0x0 }, /* #68 */
    { 0x187b53, 0x187b13, 0x769baaa3, 0x00000001, 0x25dff02a, 0x0 }, /* #69 */
    { 0x100986, 0x100986, 0xcb2eef75, 0x00000000, 0xf66af00f, 0x0 }, /* #70 */
    { 0x360492, 0x360492, 0x58c1d5f9, 0x00000000, 0x5dc6db21, 0x0 }, /* #71 */
    { 0x1c0382, 0x1c0382, 0x1fc5931a, 0x00000000, 0xa43ca041, 0x0 }, /* #72 */
    { 0x3d3ed2, 0x3d3e92, 0xece6eebd, 0x00000001, 0x6d43d152, 0x0 }, /* #73 */
    { 0x231682, 0x231682, 0xa32ffc0e, 0x00000000, 0xa34d2e01, 0x0 }, /* #74 */
    { 0x077697, 0x077697, 0x95140bca, 0x00000000, 0x97120595, 0x0 }, /* #75 */
    { 0x2c25d3, 0x2c2593, 0x933cfe31, 0x00000000, 0x09544cd5, 0x0 }, /* #76 */
    { 0x003893, 0x003893, 0xed0cbd5b, 0x00000000, 0x1f63d94b, 0x0 }, /* #77 */
    { 0x0e7bd2, 0x0e7b92, 0xcd78afa0, 0x00000002, 0xee52591c, 0x0 }, /* #78 */
    { 0x185506, 0x185506, 0x07360d81, 0x00000000, 0x6db093d9, 0x0 }, /* #79 */
    { 0x3a43d3, 0x3a4393, 0x8103f467, 0x00000001, 0xeaa296b6, 0x0 }, /* #80 */
    { 0x141c92, 0x141c92, 0x9af4cba2, 0x00000002, 0x3d652754, 0x0 }, /* #81 */
    { 0x393c16, 0x393c16, 0x27d991da, 0x00000001, 0x3cf693a6, 0x0 }, /* #82 */
    { 0x171686, 0x171686, 0x565d760c, 0x00000002, 0x11f1194c, 0x0 }, /* #83 */
    { 0x337693, 0x337693, 0x74035087, 0x00000001, 0xc59be9be, 0x0 }, /* #84 */
    { 0x0e5c87, 0x0e5c87, 0xcd9f9c44, 0x00000002, 0x69cc5c2c, 0x0 }, /* #85 */
    { 0x376206, 0x376206, 0xf88c3dda, 0x00000001, 0xbf30f10a, 0x0 }, /* #86 */
    { 0x2067c7, 0x206787, 0x3a5b0f77, 0x00000000, 0x30546b8f, 0x0 }, /* #87 */
    { 0x211212, 0x211212, 0xffbd1875, 0x00000000, 0x5790ead7, 0x0 }, /* #88 */
    { 0x297602, 0x297602, 0x0fe0765d, 0x00000000, 0x597adbcf, 0x0 }, /* #89 */
    { 0x3520c6, 0x352086, 0xa968f1cd, 0x00000000, 0xa8daffcb, 0x0 }, /* #90 */
    { 0x0f1e17, 0x0f1e17, 0xe59baa80, 0x00000000, 0x0ed6ed9d, 0x0 }, /* #91 */
    { 0x0a06d3, 0x0a0693, 0xe5c81423, 0x00000000, 0x72a23a09, 0x0 }, /* #92 */
    { 0x103ed7, 0x103e97, 0x060db244, 0x00000001, 0xad329176, 0x0 }, /* #93 */
    { 0x2c11d6, 0x2c1196, 0x8890c118, 0x00000005, 0x577533e0, 0x0 }, /* #94 */
    { 0x204302, 0x204302, 0x880d0905, 0x00000000, 0xcfcb4c37, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsf_u32_amd = RT_ELEMENTS(g_aTests_bsf_u32_amd);

BINU32_TEST_T const g_aTests_bsr_u32_amd[] =
{
    { 0x3857c6, 0x3857c6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x202bc7, 0x202bc7, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x240812, 0x240852, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x291096, 0x2910d6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x020386, 0x0203c6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x3d1f86, 0x3d1fc6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x224ed7, 0x224ed7, 0x6ec1ecb8, 0x6ec1ecb8, 0x00000000, 0x0 }, /* #6 */
    { 0x1c3c03, 0x1c3c43, 0x9c28088e, 0x9c28088e, 0x00000000, 0x0 }, /* #7 */
    { 0x0951c6, 0x0951c6, 0x2673781d, 0x2673781d, 0x00000000, 0x0 }, /* #8 */
    { 0x126c57, 0x126c57, 0x76b8ea19, 0x76b8ea19, 0x00000000, 0x0 }, /* #9 */
    { 0x114c13, 0x114c53, 0x39a1dc9e, 0x39a1dc9e, 0x00000000, 0x0 }, /* #10 */
    { 0x1b4756, 0x1b4756, 0x89704af1, 0x89704af1, 0x00000000, 0x0 }, /* #11 */
    { 0x081906, 0x081906, 0x0a64fc55, 0x0000001e, 0x6bf235c7, 0x0 }, /* #12 */
    { 0x285306, 0x285306, 0x31c0a7b6, 0x0000001e, 0x5f42d812, 0x0 }, /* #13 */
    { 0x3715c6, 0x371586, 0x160a2a1a, 0x0000001d, 0x35523d17, 0x0 }, /* #14 */
    { 0x284c52, 0x284c12, 0xa77c6de4, 0x0000001f, 0x9a12c8d0, 0x0 }, /* #15 */
    { 0x3d5d07, 0x3d5d07, 0x2e7c2853, 0x0000001f, 0xd93b78fc, 0x0 }, /* #16 */
    { 0x041602, 0x041602, 0x68cac4e0, 0x0000001c, 0x184383df, 0x0 }, /* #17 */
    { 0x065296, 0x065296, 0x1b75d4f0, 0x0000001c, 0x14eee6a5, 0x0 }, /* #18 */
    { 0x280613, 0x280613, 0xbe4286af, 0x0000001f, 0xc1986b18, 0x0 }, /* #19 */
    { 0x1e7553, 0x1e7513, 0x518381ba, 0x0000001e, 0x50ba0425, 0x0 }, /* #20 */
    { 0x262197, 0x262197, 0x6d2f880c, 0x0000001e, 0x4b8ce301, 0x0 }, /* #21 */
    { 0x0b5c93, 0x0b5c93, 0xdf6adf2e, 0x0000001f, 0xe162551f, 0x0 }, /* #22 */
    { 0x027752, 0x027712, 0x11295298, 0x0000001d, 0x2feda2c8, 0x0 }, /* #23 */
    { 0x1a31c2, 0x1a3182, 0xd7809777, 0x0000001e, 0x7b583282, 0x0 }, /* #24 */
    { 0x1c1316, 0x1c1316, 0x5777764f, 0x0000001f, 0xe3f84892, 0x0 }, /* #25 */
    { 0x247b93, 0x247b93, 0xabf4a22d, 0x0000001b, 0x09c36fba, 0x0 }, /* #26 */
    { 0x1c2157, 0x1c2117, 0xbf11174e, 0x0000001f, 0xbb11430e, 0x0 }, /* #27 */
    { 0x096a47, 0x096a07, 0xb9ea509e, 0x0000001f, 0xc652f39a, 0x0 }, /* #28 */
    { 0x370696, 0x370696, 0x02d92c06, 0x0000001f, 0xffd93f5f, 0x0 }, /* #29 */
    { 0x0f3786, 0x0f3786, 0x233df04c, 0x0000001f, 0xb76b1fa7, 0x0 }, /* #30 */
    { 0x2b2957, 0x2b2917, 0x1de8c6c9, 0x0000001c, 0x1d52e649, 0x0 }, /* #31 */
    { 0x0c7256, 0x0c7216, 0x8083e314, 0x0000001f, 0x92b15723, 0x0 }, /* #32 */
    { 0x0f4443, 0x0f4403, 0xd06869f0, 0x0000001d, 0x370334cd, 0x0 }, /* #33 */
    { 0x3f3bc7, 0x3f3b87, 0xc700bdc0, 0x0000001e, 0x41a9acab, 0x0 }, /* #34 */
    { 0x070f47, 0x070f07, 0x3854e546, 0x0000001b, 0x0d989462, 0x0 }, /* #35 */
    { 0x3534c7, 0x353487, 0x89f7b829, 0x0000001d, 0x265b90db, 0x0 }, /* #36 */
    { 0x034e57, 0x034e17, 0xaf8dbe7e, 0x00000019, 0x02d57b69, 0x0 }, /* #37 */
    { 0x194cc6, 0x194c86, 0x0b7f82f7, 0x0000001d, 0x206f2c06, 0x0 }, /* #38 */
    { 0x336f42, 0x336f02, 0x3255196c, 0x0000001e, 0x70f81b44, 0x0 }, /* #39 */
    { 0x064747, 0x064707, 0xc798fc5b, 0x0000001f, 0xccdfdf16, 0x0 }, /* #40 */
    { 0x2f23d6, 0x2f2396, 0xb56187cf, 0x0000001c, 0x161b426a, 0x0 }, /* #41 */
    { 0x254856, 0x254816, 0x6439f1d8, 0x0000001f, 0x9834ae7c, 0x0 }, /* #42 */
    { 0x2b7c03, 0x2b7c03, 0xa062913d, 0x0000001f, 0xe72d4c67, 0x0 }, /* #43 */
    { 0x331243, 0x331203, 0x38357e49, 0x0000001e, 0x7ff62846, 0x0 }, /* #44 */
    { 0x0e4d43, 0x0e4d03, 0xc5716844, 0x0000001c, 0x18746bfa, 0x0 }, /* #45 */
    { 0x1c7683, 0x1c7683, 0x8c43c5c0, 0x0000001f, 0xb56be75d, 0x0 }, /* #46 */
    { 0x2246c6, 0x224686, 0x442fe3f1, 0x0000001e, 0x641e0630, 0x0 }, /* #47 */
    { 0x284bd6, 0x284b96, 0xbe8ae6c9, 0x0000001e, 0x5135d706, 0x0 }, /* #48 */
    { 0x377493, 0x377493, 0xd0196eef, 0x0000001f, 0xb5c235fe, 0x0 }, /* #49 */
    { 0x265246, 0x265206, 0x0f17390e, 0x0000001f, 0xbda2cddf, 0x0 }, /* #50 */
    { 0x3a0b16, 0x3a0b16, 0x396dd73c, 0x0000001c, 0x1a4de26c, 0x0 }, /* #51 */
    { 0x0c2dd3, 0x0c2d93, 0x725c624c, 0x0000001e, 0x4f39a63c, 0x0 }, /* #52 */
    { 0x1034d3, 0x103493, 0x9d17c6a8, 0x0000001f, 0xc3f34e84, 0x0 }, /* #53 */
    { 0x273e02, 0x273e02, 0xbab3d8ad, 0x0000001d, 0x355663f6, 0x0 }, /* #54 */
    { 0x3c6782, 0x3c6782, 0x8ee72e75, 0x0000001e, 0x6b9b0af7, 0x0 }, /* #55 */
    { 0x2d1552, 0x2d1512, 0xd612c2a9, 0x0000001f, 0xa9a9f091, 0x0 }, /* #56 */
    { 0x3054d7, 0x305497, 0x282d4be0, 0x0000001f, 0xb5d0948e, 0x0 }, /* #57 */
    { 0x093307, 0x093307, 0x49374738, 0x0000001b, 0x0c24d315, 0x0 }, /* #58 */
    { 0x1e2ec3, 0x1e2e83, 0x140f83c8, 0x0000001e, 0x4694ea95, 0x0 }, /* #59 */
    { 0x350046, 0x350006, 0x27aeec74, 0x0000001f, 0x8d25c806, 0x0 }, /* #60 */
    { 0x2f2953, 0x2f2913, 0x8f0c8157, 0x0000001f, 0xfdff9f4c, 0x0 }, /* #61 */
    { 0x335642, 0x335602, 0xb96be660, 0x0000001f, 0x9ae1c613, 0x0 }, /* #62 */
    { 0x133802, 0x133802, 0x454219f6, 0x0000001e, 0x76b6682c, 0x0 }, /* #63 */
    { 0x313cc6, 0x313c86, 0x314c6899, 0x0000001b, 0x0f672e18, 0x0 }, /* #64 */
    { 0x033186, 0x033186, 0x6039af3a, 0x0000001f, 0xab1f3a30, 0x0 }, /* #65 */
    { 0x255c43, 0x255c03, 0xddcbd7ff, 0x0000001d, 0x31d1b5a1, 0x0 }, /* #66 */
    { 0x2b7696, 0x2b7696, 0x14b60ed1, 0x0000001e, 0x7c86e6c9, 0x0 }, /* #67 */
    { 0x1955d7, 0x195597, 0x57b014f3, 0x0000001e, 0x692f8a7e, 0x0 }, /* #68 */
    { 0x2d0c07, 0x2d0c07, 0x7e4be9d8, 0x0000001e, 0x69e5a4af, 0x0 }, /* #69 */
    { 0x1e7286, 0x1e7286, 0xc70f86bf, 0x0000001e, 0x4c578a0b, 0x0 }, /* #70 */
    { 0x277f57, 0x277f17, 0x52ec291e, 0x0000001e, 0x4e7f9b1a, 0x0 }, /* #71 */
    { 0x1f4f47, 0x1f4f07, 0x18e91ee1, 0x0000001e, 0x70ea7361, 0x0 }, /* #72 */
    { 0x3c7e57, 0x3c7e17, 0x745fc53c, 0x0000001f, 0xbb8e0100, 0x0 }, /* #73 */
    { 0x236657, 0x236617, 0x23297b6e, 0x0000001f, 0xf866a59e, 0x0 }, /* #74 */
    { 0x0344d7, 0x034497, 0xd4d8760f, 0x0000001b, 0x0f2edd7a, 0x0 }, /* #75 */
    { 0x0e7c57, 0x0e7c17, 0x2f4768e1, 0x0000001d, 0x3936a406, 0x0 }, /* #76 */
    { 0x0a4417, 0x0a4417, 0xca8f7952, 0x0000001e, 0x5165fbe8, 0x0 }, /* #77 */
    { 0x3d6617, 0x3d6617, 0x1ab9b0e1, 0x0000001e, 0x550bb24f, 0x0 }, /* #78 */
    { 0x270c07, 0x270c07, 0x7fa28f60, 0x0000001f, 0x89730843, 0x0 }, /* #79 */
    { 0x230c43, 0x230c03, 0xcb73b0a2, 0x0000001f, 0xd8518261, 0x0 }, /* #80 */
    { 0x063ac2, 0x063a82, 0x2c8e9b15, 0x0000001f, 0x8667b761, 0x0 }, /* #81 */
    { 0x384492, 0x384492, 0xa31d4b96, 0x0000001f, 0x984d97b0, 0x0 }, /* #82 */
    { 0x213047, 0x213007, 0x85bc0c90, 0x0000001f, 0xbcdce5b4, 0x0 }, /* #83 */
    { 0x2c2b83, 0x2c2b83, 0xe4788081, 0x0000001f, 0xa33ca7db, 0x0 }, /* #84 */
    { 0x304dc3, 0x304d83, 0x07ba5141, 0x0000001c, 0x192ca731, 0x0 }, /* #85 */
    { 0x140ec2, 0x140e82, 0xa7303646, 0x0000001f, 0xce3b41c3, 0x0 }, /* #86 */
    { 0x1a1157, 0x1a1117, 0x85fb6de3, 0x0000001f, 0xbdeb75f9, 0x0 }, /* #87 */
    { 0x0e6f06, 0x0e6f06, 0x221aa7cd, 0x0000001f, 0x83fe9539, 0x0 }, /* #88 */
    { 0x365313, 0x365313, 0x3ea5e6c8, 0x0000001f, 0xfdd27499, 0x0 }, /* #89 */
    { 0x252952, 0x252912, 0xe62d05ef, 0x0000001c, 0x15e0a17d, 0x0 }, /* #90 */
    { 0x0a4197, 0x0a4197, 0x16d827f6, 0x0000001e, 0x49279331, 0x0 }, /* #91 */
    { 0x301b56, 0x301b16, 0xba300d60, 0x0000001f, 0xa8be584b, 0x0 }, /* #92 */
    { 0x165986, 0x165986, 0xc7ab361b, 0x0000001f, 0xf96d4b5f, 0x0 }, /* #93 */
    { 0x2f6747, 0x2f6707, 0x0bef4106, 0x0000001f, 0xc89617dc, 0x0 }, /* #94 */
    { 0x381196, 0x381196, 0xa45ec3fc, 0x0000001f, 0x8994e80b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsr_u32_amd = RT_ELEMENTS(g_aTests_bsr_u32_amd);

BINU32_TEST_T const g_aTests_imul_two_u32_amd[] =
{
    { 0x0e4fc2, 0x0e47c2, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x203412, 0x203412, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x165996, 0x165196, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x152283, 0x152282, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x0c6252, 0x0c6252, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x0d2a13, 0x0d2212, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x071016, 0x071016, 0x73b153f7, 0x00000000, 0x00000000, 0x0 }, /* #6 */
    { 0x3f1786, 0x3f1786, 0x3e3cb04b, 0x00000000, 0x00000000, 0x0 }, /* #7 */
    { 0x1a4c86, 0x1a4486, 0xb65fd23c, 0x00000000, 0x00000000, 0x0 }, /* #8 */
    { 0x237d07, 0x237506, 0x2a7368f4, 0x00000000, 0x00000000, 0x0 }, /* #9 */
    { 0x2f21c7, 0x2f21c6, 0x2665acca, 0x00000000, 0x00000000, 0x0 }, /* #10 */
    { 0x333643, 0x333642, 0xcd3184e7, 0x00000000, 0x00000000, 0x0 }, /* #11 */
    { 0x0c6057, 0x0c6857, 0xee90b8f1, 0xb69f1d89, 0x9f5dee19, 0x0 }, /* #12 */
    { 0x3a3b47, 0x3a3b47, 0x2c650cc7, 0x4517c99f, 0x5e2a1469, 0x0 }, /* #13 */
    { 0x2229c3, 0x2229c3, 0x5a65dd1c, 0x492dd29c, 0x559787a1, 0x0 }, /* #14 */
    { 0x0906c7, 0x090ec7, 0xb1559b6a, 0x26639666, 0x2b4e8647, 0x0 }, /* #15 */
    { 0x113587, 0x113d87, 0x0464cad9, 0xc7955f2b, 0x75418fa3, 0x0 }, /* #16 */
    { 0x3d3187, 0x3d3987, 0x86867a89, 0xe0d84463, 0xa6d6dc8b, 0x0 }, /* #17 */
    { 0x293d92, 0x293d93, 0xcf8af987, 0xdcb7e38b, 0x6d0436dd, 0x0 }, /* #18 */
    { 0x2d7e43, 0x2d7e43, 0x880f96af, 0x3f80b645, 0x376dbf4b, 0x0 }, /* #19 */
    { 0x297153, 0x297953, 0xc10c63cc, 0x9742a10c, 0x146c0771, 0x0 }, /* #20 */
    { 0x1c1612, 0x1c1e13, 0x7e884a52, 0xa6348408, 0x25c78e64, 0x0 }, /* #21 */
    { 0x155a96, 0x155a97, 0x13afe0f8, 0xcd71c100, 0x7fdac3e0, 0x0 }, /* #22 */
    { 0x316893, 0x316893, 0x3b647afb, 0x23472101, 0x41c61333, 0x0 }, /* #23 */
    { 0x161b03, 0x161b03, 0x511a78db, 0x4114d896, 0x60f47aa2, 0x0 }, /* #24 */
    { 0x1f5342, 0x1f5b43, 0x24b147c0, 0x5ea583c0, 0xf2dda111, 0x0 }, /* #25 */
    { 0x391e03, 0x391e03, 0x9c746e91, 0x1f574c9f, 0x6007002f, 0x0 }, /* #26 */
    { 0x1d1e16, 0x1d1e17, 0xd8224cb8, 0xeef33320, 0x73daf13c, 0x0 }, /* #27 */
    { 0x133496, 0x133c97, 0xdabed98f, 0xd4dad16c, 0x27bd69d4, 0x0 }, /* #28 */
    { 0x2e7186, 0x2e7987, 0x4fbcd8c8, 0x8bca2bd0, 0xf73c3a8a, 0x0 }, /* #29 */
    { 0x275652, 0x275e53, 0x8bc4c594, 0xdb0c4324, 0xe3877d95, 0x0 }, /* #30 */
    { 0x055346, 0x055b47, 0xb43b61d9, 0xa62d924c, 0x2695292c, 0x0 }, /* #31 */
    { 0x023c53, 0x023c53, 0x9606102f, 0x915064cc, 0x281088f4, 0x0 }, /* #32 */
    { 0x0f0086, 0x0f0887, 0x80407263, 0xdb2cf562, 0x0715c1b6, 0x0 }, /* #33 */
    { 0x201756, 0x201f57, 0x68712c2f, 0x834a5ba6, 0xde0bf73a, 0x0 }, /* #34 */
    { 0x143112, 0x143913, 0x03c575b1, 0xaa1acd86, 0x98b1b966, 0x0 }, /* #35 */
    { 0x026416, 0x026c17, 0xe1d430b3, 0x421a7436, 0xf1c969f2, 0x0 }, /* #36 */
    { 0x0a2847, 0x0a2847, 0xb77611ba, 0x2dccf550, 0xe885e6c8, 0x0 }, /* #37 */
    { 0x326942, 0x326943, 0x2cdc21a7, 0xf296452a, 0x682592c6, 0x0 }, /* #38 */
    { 0x073a96, 0x073a97, 0xedd70985, 0x45f1f45e, 0x80b21246, 0x0 }, /* #39 */
    { 0x0d3207, 0x0d3a07, 0xcbc91291, 0x304e62c2, 0xbde1f3a2, 0x0 }, /* #40 */
    { 0x023043, 0x023843, 0x0478e038, 0x0d642c50, 0x9bc89fa6, 0x0 }, /* #41 */
    { 0x297a57, 0x297a57, 0xfce098e9, 0xd217baf8, 0x3d570838, 0x0 }, /* #42 */
    { 0x1c33d6, 0x1c3bd7, 0x1dacf77f, 0xc18b829b, 0xc6ace2e5, 0x0 }, /* #43 */
    { 0x242bc7, 0x242bc7, 0xf078440f, 0xa9a25908, 0x27bc6e78, 0x0 }, /* #44 */
    { 0x383d57, 0x383d57, 0x8f1c720d, 0x263868b6, 0x9483dc0e, 0x0 }, /* #45 */
    { 0x244653, 0x244e53, 0xcecf440e, 0xcbfb39c4, 0x497d1b8e, 0x0 }, /* #46 */
    { 0x1c0c57, 0x1c0c57, 0xb0f8a1a8, 0x4742b570, 0x133d35b6, 0x0 }, /* #47 */
    { 0x114992, 0x114993, 0x0376a63e, 0xab3de4e8, 0xe29c530c, 0x0 }, /* #48 */
    { 0x104a96, 0x104a97, 0xf0905df8, 0x731bb280, 0xd6095db0, 0x0 }, /* #49 */
    { 0x2579d3, 0x2579d3, 0xb2b52606, 0x1330b27a, 0x52d38ebf, 0x0 }, /* #50 */
    { 0x004816, 0x004817, 0xf60fb97d, 0x5669f3b1, 0x825ad945, 0x0 }, /* #51 */
    { 0x2e6303, 0x2e6b03, 0x4528958f, 0x95dbb9f2, 0x2b72e1ee, 0x0 }, /* #52 */
    { 0x0e6683, 0x0e6e83, 0xf101b15f, 0x965fa805, 0xe623ed1b, 0x0 }, /* #53 */
    { 0x233c02, 0x233c03, 0x7d8bc527, 0xc3c35f4e, 0xe33ca302, 0x0 }, /* #54 */
    { 0x316a42, 0x316a43, 0xbcf98f39, 0x6e5bf708, 0xe42a2748, 0x0 }, /* #55 */
    { 0x391b52, 0x391b53, 0x7bf2344a, 0xab467772, 0xda470505, 0x0 }, /* #56 */
    { 0x1a1897, 0x1a1897, 0xd9a1b72b, 0x331d7d02, 0x08009606, 0x0 }, /* #57 */
    { 0x396806, 0x396807, 0xb49c0f10, 0xe14aa4f0, 0xb1a11f3f, 0x0 }, /* #58 */
    { 0x0a7a87, 0x0a7a87, 0x0ef3e471, 0x8df6ba65, 0xae1adf35, 0x0 }, /* #59 */
    { 0x344906, 0x344907, 0xa4d3f66f, 0xe56ee4f4, 0x57d8044c, 0x0 }, /* #60 */
    { 0x024682, 0x024e83, 0x066b49b0, 0x62f9ebe0, 0xedb2c51a, 0x0 }, /* #61 */
    { 0x2a6613, 0x2a6e13, 0xb81d6382, 0x77345e2c, 0xd1700896, 0x0 }, /* #62 */
    { 0x0338c3, 0x0338c3, 0x1c19419e, 0xf637a824, 0x7e231b4e, 0x0 }, /* #63 */
    { 0x155e96, 0x155e97, 0x7707e09e, 0x8cc9af22, 0xa62be21f, 0x0 }, /* #64 */
    { 0x0a74c7, 0x0a7cc7, 0xb8203027, 0x837a83d6, 0x09396d3a, 0x0 }, /* #65 */
    { 0x322046, 0x322847, 0x29ecb2fb, 0x399b63ab, 0xb2dab311, 0x0 }, /* #66 */
    { 0x223b06, 0x223b07, 0xb35ae071, 0x80e4ab2e, 0x1345350e, 0x0 }, /* #67 */
    { 0x1e3406, 0x1e3c07, 0xce690564, 0x052bba80, 0xd0e0efa0, 0x0 }, /* #68 */
    { 0x137a02, 0x137a03, 0x6c04336a, 0x7dce4b9a, 0xc7cb8ab9, 0x0 }, /* #69 */
    { 0x001c82, 0x001c83, 0x5d3b90cf, 0x1a142b46, 0xf1a035da, 0x0 }, /* #70 */
    { 0x2f3557, 0x2f3d57, 0x77344921, 0x73a66b0b, 0x89ad52ab, 0x0 }, /* #71 */
    { 0x0e5d83, 0x0e5d83, 0x2d1d6d8b, 0xe6febdf0, 0xa702d7d0, 0x0 }, /* #72 */
    { 0x264d87, 0x264d87, 0x13ff0dfa, 0x62f1f3f6, 0x4deea257, 0x0 }, /* #73 */
    { 0x242593, 0x242d93, 0x9d68cd0c, 0x8f81fbec, 0x0b6ddde9, 0x0 }, /* #74 */
    { 0x041287, 0x041a87, 0x3bc749de, 0x971b47a4, 0x18c2cd4e, 0x0 }, /* #75 */
    { 0x346942, 0x346943, 0x7cc7daa6, 0x139c9284, 0xa4e3e776, 0x0 }, /* #76 */
    { 0x312793, 0x312f93, 0x46e6fa81, 0x60fe6131, 0x66482eb1, 0x0 }, /* #77 */
    { 0x317a13, 0x317a13, 0x018726c6, 0x2c44cd2c, 0xd00291f2, 0x0 }, /* #78 */
    { 0x3b4fc7, 0x3b4fc7, 0x124e7434, 0x24c0180c, 0x1caf0b4f, 0x0 }, /* #79 */
    { 0x0f1f12, 0x0f1f13, 0xa77af1dd, 0xede23d82, 0xf89cf86a, 0x0 }, /* #80 */
    { 0x393503, 0x393d03, 0x34875cd0, 0xc174be40, 0xa2de9774, 0x0 }, /* #81 */
    { 0x297342, 0x297b43, 0x29d628ce, 0x095074cc, 0x6b1122aa, 0x0 }, /* #82 */
    { 0x3a7dd2, 0x3a7dd3, 0x952d7c52, 0xcde1b4bc, 0x1d3d172e, 0x0 }, /* #83 */
    { 0x3c5c03, 0x3c5c03, 0x220fd0cd, 0x19badcd7, 0xfc555433, 0x0 }, /* #84 */
    { 0x0a7f17, 0x0a7f17, 0x76f235d8, 0xb74d1770, 0xd7ad34ea, 0x0 }, /* #85 */
    { 0x2c7ac2, 0x2c7ac3, 0x66c51b62, 0x675390c8, 0xd688f3a4, 0x0 }, /* #86 */
    { 0x331f82, 0x331f83, 0xec2f5b30, 0x383a11b0, 0x990bc2f9, 0x0 }, /* #87 */
    { 0x2d1713, 0x2d1f13, 0xd61b7773, 0xe1a953e1, 0xe53f2a5b, 0x0 }, /* #88 */
    { 0x357043, 0x357843, 0x4572d730, 0x82aa9ea0, 0xf68db3ee, 0x0 }, /* #89 */
    { 0x200b12, 0x200b13, 0xabb7d25f, 0x5c5c32c8, 0x71549238, 0x0 }, /* #90 */
    { 0x0b5482, 0x0b5c83, 0xa3769693, 0x7af4a70f, 0x3e979f15, 0x0 }, /* #91 */
    { 0x0d3bc7, 0x0d3bc7, 0xda913af8, 0x011b0cc0, 0x34b67d68, 0x0 }, /* #92 */
    { 0x2351c3, 0x2359c3, 0x9414a7f4, 0xa389a870, 0x581eaf4c, 0x0 }, /* #93 */
    { 0x0632d3, 0x063ad3, 0xf54e72dd, 0xcb026e61, 0x71574755, 0x0 }, /* #94 */
    { 0x0c5797, 0x0c5f97, 0x6a4fac62, 0x416b60ca, 0x54be8c75, 0x0 }, /* #95 */
};
uint32_t const g_cTests_imul_two_u32_amd = RT_ELEMENTS(g_aTests_imul_two_u32_amd);

BINU64_TEST_T const g_aTests_bsf_u64_amd[] =
{
    { 0x253e46, 0x253e46, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x062d16, 0x062d56, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x3c3457, 0x3c3457, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x0f4ac2, 0x0f4ac2, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x1246c3, 0x1246c3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x254257, 0x254257, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x2e3f96, 0x2e3fd6, 0xaf785d2e7aec4c1a, 0xaf785d2e7aec4c1a, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x2d3006, 0x2d3046, 0x4bbe1e7d8889c084, 0x4bbe1e7d8889c084, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x032692, 0x0326d2, 0xa4de447d2eec70bf, 0xa4de447d2eec70bf, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x221e47, 0x221e47, 0x64517b6d37fe7b4e, 0x64517b6d37fe7b4e, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x3e6487, 0x3e64c7, 0xeeb6ebed30fbf976, 0xeeb6ebed30fbf976, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x3b2c92, 0x3b2cd2, 0xa9487171f9ead8ef, 0xa9487171f9ead8ef, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x0f46c3, 0x0f4683, 0x0198a72f30ca8baf, 0x0000000000000001, 0xd080e7914d08204e, 0x0 }, /* #12 */
    { 0x226907, 0x226907, 0x5b178a902332958f, 0x0000000000000003, 0x76e9782f668a22a8, 0x0 }, /* #13 */
    { 0x111286, 0x111286, 0x8c1930584df2fe5b, 0x0000000000000002, 0x83d1d89209b4e79c, 0x0 }, /* #14 */
    { 0x215b13, 0x215b13, 0xcda3895bce2a951c, 0x0000000000000000, 0xb05b4f00eb8edd2f, 0x0 }, /* #15 */
    { 0x1f21c7, 0x1f2187, 0xe7dcbb82c637b7cc, 0x0000000000000006, 0x2d3248368c9a6840, 0x0 }, /* #16 */
    { 0x230916, 0x230916, 0x893fe547fc334235, 0x0000000000000000, 0xc9aa659581e59d0f, 0x0 }, /* #17 */
    { 0x333ed3, 0x333e93, 0x22dcb89438abfac5, 0x0000000000000000, 0xa3e93b7808da0e6d, 0x0 }, /* #18 */
    { 0x3f7686, 0x3f7686, 0x3cb861ef297e8b58, 0x0000000000000000, 0x458b0476ad25b10d, 0x0 }, /* #19 */
    { 0x120287, 0x120287, 0xbebc1e075aabb416, 0x0000000000000000, 0x086b7b36b0579e91, 0x0 }, /* #20 */
    { 0x261a83, 0x261a83, 0xf3da6a376758c0cf, 0x0000000000000000, 0x4d7a8a1848735b79, 0x0 }, /* #21 */
    { 0x003493, 0x003493, 0xcdba5f12a57b50ee, 0x0000000000000003, 0x80d7d9bd46b79dc8, 0x0 }, /* #22 */
    { 0x182887, 0x182887, 0x745c7cac8f0e4ee0, 0x0000000000000000, 0x3dfb883ee3fd1b0f, 0x0 }, /* #23 */
    { 0x2d3e16, 0x2d3e16, 0xdce7bc0ce2a47c78, 0x0000000000000001, 0x7503350371eae77a, 0x0 }, /* #24 */
    { 0x0d13d3, 0x0d1393, 0xf7cccc2b31edd3b1, 0x0000000000000000, 0xd156f017267037ab, 0x0 }, /* #25 */
    { 0x2c1f93, 0x2c1f93, 0x19e7e3b2732a3c77, 0x0000000000000000, 0xaf83241f8715e93b, 0x0 }, /* #26 */
    { 0x380797, 0x380797, 0xf87dfb0418cdf0d4, 0x0000000000000000, 0x9ea9a04056eb0169, 0x0 }, /* #27 */
    { 0x175952, 0x175912, 0x56a785e38586e1fe, 0x0000000000000000, 0xaf32716ad0472687, 0x0 }, /* #28 */
    { 0x337e53, 0x337e13, 0x5c64e9c3d1001508, 0x0000000000000003, 0xbd1f7f0d252f3098, 0x0 }, /* #29 */
    { 0x0e6e82, 0x0e6e82, 0x89e5994dc2c2e765, 0x0000000000000001, 0x55f7248a00b3b422, 0x0 }, /* #30 */
    { 0x3f6b42, 0x3f6b02, 0x13e784c29a3051c9, 0x0000000000000000, 0xd63d4cef04bd0797, 0x0 }, /* #31 */
    { 0x056a53, 0x056a13, 0xb94dadf615da7557, 0x0000000000000001, 0xdeb81e961ad80ede, 0x0 }, /* #32 */
    { 0x203a47, 0x203a07, 0xa36ab73a601c5279, 0x0000000000000000, 0x5c895cb3332373d3, 0x0 }, /* #33 */
    { 0x247a47, 0x247a07, 0x848734526db3c0e4, 0x0000000000000002, 0x4ab26d56487c16a4, 0x0 }, /* #34 */
    { 0x282e96, 0x282e96, 0xa343a170060a9edc, 0x0000000000000000, 0x45ecf165ad1bf2f9, 0x0 }, /* #35 */
    { 0x1c41c2, 0x1c4182, 0x5c1186d7e660c898, 0x0000000000000001, 0x9077d17c02ab9ba6, 0x0 }, /* #36 */
    { 0x1a2c56, 0x1a2c16, 0x4db3c443c614d7d3, 0x0000000000000002, 0xa2825876151a11bc, 0x0 }, /* #37 */
    { 0x3d5d82, 0x3d5d82, 0x1ab561bf24592d6d, 0x0000000000000000, 0xae7ec80bfa24711f, 0x0 }, /* #38 */
    { 0x3f6206, 0x3f6206, 0xdaddc3662dfc7abb, 0x0000000000000000, 0x4c41dc0d15478c25, 0x0 }, /* #39 */
    { 0x155fc6, 0x155f86, 0xa5eee4237a55d97f, 0x0000000000000000, 0xbfd40c5426c3c949, 0x0 }, /* #40 */
    { 0x357f82, 0x357f82, 0xd34d83cef807f887, 0x0000000000000003, 0x0c93bfe346085348, 0x0 }, /* #41 */
    { 0x1a7753, 0x1a7713, 0x734bddfaf265b4f7, 0x0000000000000000, 0x7071f28f39da6265, 0x0 }, /* #42 */
    { 0x2b2302, 0x2b2302, 0xc563a71a662311c1, 0x0000000000000000, 0xff88caec916fbf8d, 0x0 }, /* #43 */
    { 0x026c82, 0x026c82, 0x4200559b3763ef7e, 0x0000000000000000, 0x758b191963f43423, 0x0 }, /* #44 */
    { 0x1c53c7, 0x1c5387, 0xd1193a2f3d934ae1, 0x0000000000000000, 0x2de34f0a0f3b0d41, 0x0 }, /* #45 */
    { 0x1a3107, 0x1a3107, 0xaa1d573e2b4ae374, 0x0000000000000000, 0x672c7230ac4adddf, 0x0 }, /* #46 */
    { 0x3c6213, 0x3c6213, 0x7faa6d3274689b47, 0x0000000000000000, 0xbc59fbf70de70e45, 0x0 }, /* #47 */
    { 0x2d54c2, 0x2d5482, 0x391775ead4a188ba, 0x0000000000000000, 0x11569f03f33e93c1, 0x0 }, /* #48 */
    { 0x2106d3, 0x210693, 0xcabd00ae115c3881, 0x0000000000000000, 0x20f2a8d27e77a503, 0x0 }, /* #49 */
    { 0x292497, 0x292497, 0x2e7d4e77cafd1923, 0x0000000000000002, 0xfdc06a3564aa9f4c, 0x0 }, /* #50 */
    { 0x3c7e12, 0x3c7e12, 0x0a5d657d230c82c5, 0x0000000000000000, 0x92c5e248f9b1f6db, 0x0 }, /* #51 */
    { 0x0a6e92, 0x0a6e92, 0x3096b7f3ac367d8c, 0x0000000000000004, 0x1f16631c3706cb70, 0x0 }, /* #52 */
    { 0x047403, 0x047403, 0x456e0f7a3c7196f6, 0x0000000000000001, 0x653c2bc33cba3632, 0x0 }, /* #53 */
    { 0x1d4303, 0x1d4303, 0xf24b81d841e25542, 0x0000000000000000, 0x8e18e771bb39c687, 0x0 }, /* #54 */
    { 0x0253c7, 0x025387, 0xdba6040c7c9d4de8, 0x0000000000000000, 0xd24aab907053ded5, 0x0 }, /* #55 */
    { 0x050453, 0x050413, 0xde526d300ff21545, 0x0000000000000004, 0xcaddd513b57e9ab0, 0x0 }, /* #56 */
    { 0x0f78c3, 0x0f7883, 0xea592f2914d6ecdf, 0x0000000000000000, 0x547cb61985274277, 0x0 }, /* #57 */
    { 0x172dd3, 0x172d93, 0x681188e95640f83b, 0x0000000000000002, 0x7991ee3ad7338d8c, 0x0 }, /* #58 */
    { 0x2f3f57, 0x2f3f17, 0x8fb7f6368e6900de, 0x0000000000000000, 0xad2c526936855b49, 0x0 }, /* #59 */
    { 0x160282, 0x160282, 0xfd21772d4b1c840d, 0x0000000000000000, 0x6194ffd4a0176b89, 0x0 }, /* #60 */
    { 0x276952, 0x276912, 0xd41572ac4748d099, 0x0000000000000000, 0xa298375ccc1b8481, 0x0 }, /* #61 */
    { 0x1a2b97, 0x1a2b97, 0xb57c614421b7006a, 0x0000000000000001, 0x9e0209c038d5d2ca, 0x0 }, /* #62 */
    { 0x0e2b86, 0x0e2b86, 0xdd33da7fa0932831, 0x0000000000000001, 0x9fbdf07bb74df7a6, 0x0 }, /* #63 */
    { 0x372b86, 0x372b86, 0x4ff52ec0254a2006, 0x0000000000000000, 0x2901dddb69d0476f, 0x0 }, /* #64 */
    { 0x0c69c7, 0x0c6987, 0xda2d7112b17c56e7, 0x0000000000000001, 0x214e2193dd5a82fe, 0x0 }, /* #65 */
    { 0x3e6bc7, 0x3e6b87, 0xe36473e3dbd78904, 0x0000000000000000, 0xb0a76ee597f46f0f, 0x0 }, /* #66 */
    { 0x213603, 0x213603, 0x123f2349cefec13f, 0x0000000000000001, 0x95464d906f25b7ce, 0x0 }, /* #67 */
    { 0x0e5486, 0x0e5486, 0xb71396e6d6592710, 0x0000000000000000, 0x9523cb7f2717f249, 0x0 }, /* #68 */
    { 0x052a86, 0x052a86, 0x902ed76c1a2a510b, 0x0000000000000006, 0xef50355db340fbc0, 0x0 }, /* #69 */
    { 0x1f04c7, 0x1f0487, 0x681d615aa890851b, 0x0000000000000002, 0xfaa4f6f560e2911c, 0x0 }, /* #70 */
    { 0x116cc7, 0x116c87, 0x2134d1ef9dc4c451, 0x0000000000000000, 0x6c71f5d692c2b2f1, 0x0 }, /* #71 */
    { 0x024b47, 0x024b07, 0x1b5469b88fb78c2f, 0x0000000000000005, 0x063e9e9e02e8dde0, 0x0 }, /* #72 */
    { 0x1f1a47, 0x1f1a07, 0x6a48a2ef09c96623, 0x0000000000000002, 0xb5107fbec6c12f6c, 0x0 }, /* #73 */
    { 0x322e03, 0x322e03, 0x49ba751b21482dda, 0x0000000000000000, 0x455510bd305e656d, 0x0 }, /* #74 */
    { 0x3e0bd2, 0x3e0b92, 0xb7d87600a1fc4029, 0x0000000000000003, 0x9146b9d5a42b3778, 0x0 }, /* #75 */
    { 0x1257c7, 0x125787, 0xd3d5f4cd7402f4f2, 0x0000000000000000, 0xa446f5e6c3bae9bb, 0x0 }, /* #76 */
    { 0x3a0252, 0x3a0212, 0x808c1540f5f84d12, 0x0000000000000000, 0x8442ee5cecc71d07, 0x0 }, /* #77 */
    { 0x2e5c13, 0x2e5c13, 0x3bde2c32ee7abc44, 0x0000000000000001, 0xd44205143727c626, 0x0 }, /* #78 */
    { 0x1b6e47, 0x1b6e07, 0x138056dd88af782b, 0x0000000000000000, 0x1ece86740ec6d12b, 0x0 }, /* #79 */
    { 0x1d5a46, 0x1d5a06, 0x83f4d8767c5358f3, 0x0000000000000000, 0x05b3bd51bfaf2d01, 0x0 }, /* #80 */
    { 0x1213c3, 0x121383, 0xd1c3e251e98f960b, 0x0000000000000000, 0xe525bdb0d33f5dc7, 0x0 }, /* #81 */
    { 0x0800d7, 0x080097, 0x6b8f03b99b84569a, 0x0000000000000000, 0x23465041ba3d9dd9, 0x0 }, /* #82 */
    { 0x3f0e52, 0x3f0e12, 0x2dffe3dfd6c5387e, 0x0000000000000002, 0xc26821e37ac97de4, 0x0 }, /* #83 */
    { 0x083f53, 0x083f13, 0x9c1fcaf59fc86023, 0x0000000000000000, 0xb2d5bb96ab45ca13, 0x0 }, /* #84 */
    { 0x0e2fc2, 0x0e2f82, 0x6d9514c186347ddf, 0x0000000000000003, 0xdf613085d685a248, 0x0 }, /* #85 */
    { 0x387bd3, 0x387b93, 0xccc46874f2cb7a35, 0x0000000000000003, 0xd7368882b2a59e38, 0x0 }, /* #86 */
    { 0x3c1a97, 0x3c1a97, 0x776943e3b4fda14e, 0x0000000000000007, 0x3a863cb01fe80880, 0x0 }, /* #87 */
    { 0x3a0582, 0x3a0582, 0x658055d6cd5cda1f, 0x0000000000000000, 0x0f81367d8c8388a9, 0x0 }, /* #88 */
    { 0x207152, 0x207112, 0x84912aeb05efd520, 0x0000000000000003, 0x09d98cdf5698cd78, 0x0 }, /* #89 */
    { 0x2f0986, 0x2f0986, 0xdee88902836dd1cb, 0x0000000000000000, 0x7c1b587b747b12fb, 0x0 }, /* #90 */
    { 0x0e1213, 0x0e1213, 0x6d2ab0a776842e3f, 0x0000000000000000, 0xd2c111770db3bb1b, 0x0 }, /* #91 */
    { 0x214613, 0x214613, 0x37fc4ebffa130a1a, 0x0000000000000004, 0x2964a542d595fa50, 0x0 }, /* #92 */
    { 0x1d2543, 0x1d2503, 0xf6cd4eadcfce631e, 0x0000000000000001, 0xf6eda52ee0e85bf6, 0x0 }, /* #93 */
    { 0x370b06, 0x370b06, 0xf572a1a888d28f8f, 0x0000000000000000, 0xbb6d251878d358d5, 0x0 }, /* #94 */
    { 0x1e6902, 0x1e6902, 0xe57fb37436087612, 0x0000000000000000, 0x4c320edfe2deb8bb, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsf_u64_amd = RT_ELEMENTS(g_aTests_bsf_u64_amd);

BINU64_TEST_T const g_aTests_bsr_u64_amd[] =
{
    { 0x2e7987, 0x2e79c7, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x2e4e93, 0x2e4ed3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x285086, 0x2850c6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x065952, 0x065952, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x142683, 0x1426c3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x2e0c07, 0x2e0c47, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x2c65d7, 0x2c65d7, 0x2a5e21991d443a85, 0x2a5e21991d443a85, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x2f5982, 0x2f59c2, 0x2cbfabaee1b2f81e, 0x2cbfabaee1b2f81e, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x204357, 0x204357, 0xd10365b536ace551, 0xd10365b536ace551, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0a7782, 0x0a77c2, 0xc5d09ef62933c517, 0xc5d09ef62933c517, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x344c43, 0x344c43, 0x2f3eac48c83c4e64, 0x2f3eac48c83c4e64, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x206406, 0x206446, 0x8249631363670c11, 0x8249631363670c11, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x077593, 0x077593, 0xb315116b89b79304, 0x000000000000003d, 0x22f1c4a72c2aa200, 0x0 }, /* #12 */
    { 0x2541d7, 0x254197, 0xdcd85de3445aac18, 0x000000000000003f, 0xe4ee40ed80fc11b4, 0x0 }, /* #13 */
    { 0x281a86, 0x281a86, 0xc6e6f416d9fa6890, 0x000000000000003f, 0xb710a3a6c6704dff, 0x0 }, /* #14 */
    { 0x280382, 0x280382, 0x8053be984fbfe8e7, 0x000000000000003f, 0xe38afe8cba060e26, 0x0 }, /* #15 */
    { 0x0d4c42, 0x0d4c02, 0x0522eab949a553d5, 0x000000000000003e, 0x465fd83e77601a51, 0x0 }, /* #16 */
    { 0x2d5196, 0x2d5196, 0x65aafc5f1be34492, 0x000000000000003e, 0x73df0b205f838631, 0x0 }, /* #17 */
    { 0x131d46, 0x131d06, 0x9ef77bd2397c88c5, 0x000000000000003f, 0xa71305aa89e248b3, 0x0 }, /* #18 */
    { 0x186fd2, 0x186f92, 0xd0fa5b4ff9709f8a, 0x000000000000003e, 0x4310aea32480c911, 0x0 }, /* #19 */
    { 0x397192, 0x397192, 0x77ab4b8fdf59aa0d, 0x000000000000003f, 0x94407af5d83d1d15, 0x0 }, /* #20 */
    { 0x087516, 0x087516, 0x91b5416dc8073724, 0x000000000000003e, 0x4852b27492da8503, 0x0 }, /* #21 */
    { 0x0161d2, 0x016192, 0x75352ba380588b9a, 0x000000000000003e, 0x5432b54cf5c3f59f, 0x0 }, /* #22 */
    { 0x1c3bc3, 0x1c3b83, 0x89bd9797596b26c2, 0x000000000000003f, 0x9837f55351c10908, 0x0 }, /* #23 */
    { 0x0b2893, 0x0b2893, 0x30e4700e00d44882, 0x000000000000003f, 0xda930b9e2578c035, 0x0 }, /* #24 */
    { 0x1f6086, 0x1f6086, 0x64d5422e770db4be, 0x000000000000003d, 0x3d79248c6cec0db9, 0x0 }, /* #25 */
    { 0x0e2387, 0x0e2387, 0x3f20f2b7eedc44ad, 0x000000000000003d, 0x3684fd824249bac5, 0x0 }, /* #26 */
    { 0x1f1e92, 0x1f1e92, 0xa28a0b824ee517fd, 0x000000000000003f, 0xcdc7598554f99585, 0x0 }, /* #27 */
    { 0x0631d6, 0x063196, 0xc69c867ec9f16307, 0x000000000000003d, 0x3e05ca290e41bd96, 0x0 }, /* #28 */
    { 0x1b0a42, 0x1b0a02, 0x794416d4521a3f94, 0x000000000000003f, 0xf73addedfb70fe1b, 0x0 }, /* #29 */
    { 0x000ec6, 0x000e86, 0xcc27c115301469b4, 0x000000000000003f, 0xec52d6f785f54fef, 0x0 }, /* #30 */
    { 0x1f08d6, 0x1f0896, 0xa6b4e6e2e6fede4e, 0x000000000000003f, 0x929ff3e36ea21348, 0x0 }, /* #31 */
    { 0x044582, 0x044582, 0x46c9f02a180b312e, 0x000000000000003f, 0x920bd40690f053c5, 0x0 }, /* #32 */
    { 0x0c7fd7, 0x0c7f97, 0x0cc35bcfd2fac1b5, 0x000000000000003f, 0xf76e1bd6edc07994, 0x0 }, /* #33 */
    { 0x253bd3, 0x253b93, 0xb74155f9d5905706, 0x000000000000003f, 0xc766fed562736ac6, 0x0 }, /* #34 */
    { 0x247692, 0x247692, 0x39bbd358ad248972, 0x000000000000003f, 0xd218d30523471e56, 0x0 }, /* #35 */
    { 0x061756, 0x061716, 0xbb6da7db6a284b64, 0x000000000000003f, 0xd325ced89c273958, 0x0 }, /* #36 */
    { 0x2e7187, 0x2e7187, 0xbd41208f0af48cb2, 0x000000000000003d, 0x23b3d3407ec0cc87, 0x0 }, /* #37 */
    { 0x3241c3, 0x324183, 0xe373016bfec3b836, 0x000000000000003f, 0xcfb6370e51b24881, 0x0 }, /* #38 */
    { 0x180013, 0x180013, 0x255347e2fac812ef, 0x000000000000003e, 0x45efdea37e947a66, 0x0 }, /* #39 */
    { 0x012242, 0x012202, 0x3ceaa8197c4b710b, 0x000000000000003f, 0xa8525062d1c24161, 0x0 }, /* #40 */
    { 0x1b0747, 0x1b0707, 0x00a969eabb58c3f6, 0x000000000000003f, 0x89e5d85033991f8a, 0x0 }, /* #41 */
    { 0x1c1217, 0x1c1217, 0x6a30887140fb2ca7, 0x000000000000003e, 0x6307d779184de92e, 0x0 }, /* #42 */
    { 0x135ac6, 0x135a86, 0x786217af34f4df15, 0x000000000000003c, 0x19d5b023f0011fe7, 0x0 }, /* #43 */
    { 0x1e77c2, 0x1e7782, 0x455ffe97b525cf97, 0x000000000000003d, 0x2f6cf77051fbe0f1, 0x0 }, /* #44 */
    { 0x287243, 0x287203, 0xee82c55833814f62, 0x000000000000003f, 0xefeb06084b6a4d16, 0x0 }, /* #45 */
    { 0x190fc3, 0x190f83, 0x3a3284056c9c1147, 0x000000000000003f, 0xb7b83fef8a79a2f0, 0x0 }, /* #46 */
    { 0x2d0057, 0x2d0017, 0x0415ea341c0e9fb0, 0x000000000000003c, 0x1e30c29497b2d6bf, 0x0 }, /* #47 */
    { 0x361202, 0x361202, 0xc8ac43de23ad5512, 0x000000000000003f, 0xce443c79e59ba844, 0x0 }, /* #48 */
    { 0x1e5413, 0x1e5413, 0x061b0b2b4b61dd97, 0x000000000000003e, 0x66bcdae6997a372e, 0x0 }, /* #49 */
    { 0x076693, 0x076693, 0xc13325e0eb29bcef, 0x000000000000003f, 0xf5d5b006a123ceac, 0x0 }, /* #50 */
    { 0x171652, 0x171612, 0xa1b997bbec8fff2b, 0x000000000000003c, 0x1f44f74c9f98a81c, 0x0 }, /* #51 */
    { 0x072e97, 0x072e97, 0xf69147b84d98fb29, 0x000000000000003e, 0x4401b133fbfb9d04, 0x0 }, /* #52 */
    { 0x182e06, 0x182e06, 0x075553620151674e, 0x000000000000003c, 0x1c4de0ec9985c12e, 0x0 }, /* #53 */
    { 0x295543, 0x295503, 0x5f9514badbb26efe, 0x000000000000003f, 0xf9ae257a7483cf88, 0x0 }, /* #54 */
    { 0x1e2ad7, 0x1e2a97, 0x8bf2f3d0856c57b8, 0x000000000000003e, 0x5c6704fabb64e2d0, 0x0 }, /* #55 */
    { 0x374787, 0x374787, 0xaed73549a0d4bd49, 0x000000000000003d, 0x26ccd5c6bbdaffc0, 0x0 }, /* #56 */
    { 0x266ec6, 0x266e86, 0x617960d6d04dc3ea, 0x000000000000003f, 0xda7fd7e827c492c5, 0x0 }, /* #57 */
    { 0x376ec2, 0x376e82, 0x76a7a292711c43ce, 0x000000000000003e, 0x7be18d32f7a23b46, 0x0 }, /* #58 */
    { 0x3d0d02, 0x3d0d02, 0x59673509b16ac7db, 0x000000000000003d, 0x3cbedc43f50a6259, 0x0 }, /* #59 */
    { 0x2e51d7, 0x2e5197, 0xfb9108e345940fac, 0x000000000000003f, 0xdd8fbc306edeae75, 0x0 }, /* #60 */
    { 0x0c2347, 0x0c2307, 0x6e48d3ab4161981a, 0x000000000000003e, 0x798c9382af40974a, 0x0 }, /* #61 */
    { 0x285952, 0x285912, 0xd8ae64853d003558, 0x000000000000003e, 0x6515c6c8595fdeb3, 0x0 }, /* #62 */
    { 0x2d2852, 0x2d2812, 0xb65d424111055a15, 0x000000000000003f, 0xc84abe6c24a8d549, 0x0 }, /* #63 */
    { 0x1b4982, 0x1b4982, 0x551fc4d8354c11b9, 0x000000000000003f, 0xad43b04298b46c91, 0x0 }, /* #64 */
    { 0x287512, 0x287512, 0xea8a4e76383337a5, 0x000000000000003e, 0x7272900c5e3715b6, 0x0 }, /* #65 */
    { 0x0f3e87, 0x0f3e87, 0x4af2508b6b923189, 0x000000000000003e, 0x426b0a8eea85fc1d, 0x0 }, /* #66 */
    { 0x0171d7, 0x017197, 0x05291a95ba2e8912, 0x000000000000003d, 0x3d5eac284d904fac, 0x0 }, /* #67 */
    { 0x383647, 0x383607, 0x103db5acf30ecb2f, 0x000000000000003f, 0xd4f3fba2ad9701c0, 0x0 }, /* #68 */
    { 0x0d5347, 0x0d5307, 0x208432283ce02884, 0x000000000000003f, 0x89f25762c6f91199, 0x0 }, /* #69 */
    { 0x0708d3, 0x070893, 0x300fc7ef7a968565, 0x000000000000003f, 0xb2aee4f9dc0f5563, 0x0 }, /* #70 */
    { 0x3a3147, 0x3a3107, 0xec6249481556a8c5, 0x000000000000003f, 0xec8de5725527deb3, 0x0 }, /* #71 */
    { 0x123612, 0x123612, 0x809870c04ab922c0, 0x000000000000003e, 0x59a1b1fa58124d8e, 0x0 }, /* #72 */
    { 0x2b4207, 0x2b4207, 0xdb13b89b36516a34, 0x000000000000003e, 0x42f0cde76bbcf6d3, 0x0 }, /* #73 */
    { 0x1e1b06, 0x1e1b06, 0x4b2b65e86b404f9f, 0x000000000000003f, 0x8189d5374a599dd8, 0x0 }, /* #74 */
    { 0x0d0e83, 0x0d0e83, 0x349144aa193dfc93, 0x000000000000003f, 0xfbc1692b6d3330af, 0x0 }, /* #75 */
    { 0x1f2493, 0x1f2493, 0x547ed789f4b5ef80, 0x000000000000003a, 0x07761a6a53786de2, 0x0 }, /* #76 */
    { 0x0049c7, 0x004987, 0x04a0bb03462d3f73, 0x000000000000003e, 0x6ce490451337af86, 0x0 }, /* #77 */
    { 0x3b3903, 0x3b3903, 0x81eb7e16bb7127ca, 0x000000000000003f, 0xf852728a0ba2f829, 0x0 }, /* #78 */
    { 0x1d5ec3, 0x1d5e83, 0xae0c76cf9a55aa02, 0x000000000000003d, 0x3c2a7d3cb44c487a, 0x0 }, /* #79 */
    { 0x040d02, 0x040d02, 0x3f82abc7bc717fe1, 0x000000000000003d, 0x3c6b7319b5a36d85, 0x0 }, /* #80 */
    { 0x110d46, 0x110d06, 0xfcefa5b908139263, 0x000000000000003e, 0x49d0de98996933f0, 0x0 }, /* #81 */
    { 0x057306, 0x057306, 0xfe0962166cd5a41c, 0x000000000000003f, 0xed9b53399a06b22b, 0x0 }, /* #82 */
    { 0x347b46, 0x347b06, 0x35249dcfd0251f38, 0x000000000000003f, 0xed8d675cfdac18c1, 0x0 }, /* #83 */
    { 0x3c6043, 0x3c6003, 0xa37dd82e986f0fea, 0x000000000000003e, 0x47921111dafbc636, 0x0 }, /* #84 */
    { 0x1e76d3, 0x1e7693, 0xa7274d438d94d8d4, 0x000000000000003e, 0x4ea95b78c5417dca, 0x0 }, /* #85 */
    { 0x342ac7, 0x342a87, 0x24df373fa466014c, 0x000000000000003d, 0x34397ac16c2ae561, 0x0 }, /* #86 */
    { 0x2a5083, 0x2a5083, 0x9afb9cca2c8bfea7, 0x000000000000003c, 0x1cccfadafcf29f9c, 0x0 }, /* #87 */
    { 0x290cd3, 0x290c93, 0x09e42ae0a3d35e8b, 0x000000000000003e, 0x627b4dba62bafe06, 0x0 }, /* #88 */
    { 0x2c0007, 0x2c0007, 0xbcc1cfcec3b56fd8, 0x000000000000003f, 0xe26def08c2265462, 0x0 }, /* #89 */
    { 0x2807c2, 0x280782, 0x8484d8b8a6dd340f, 0x000000000000003a, 0x0491e07eedb01a59, 0x0 }, /* #90 */
    { 0x297282, 0x297282, 0xa001e9e7641ec4ab, 0x000000000000003b, 0x0c1b57a45da34d1b, 0x0 }, /* #91 */
    { 0x165613, 0x165613, 0x51715b2fdc4857a2, 0x000000000000003e, 0x7e7cc145ce5ff7aa, 0x0 }, /* #92 */
    { 0x343907, 0x343907, 0x81246b2f3f21c176, 0x000000000000003c, 0x1d02040ebdf8db3e, 0x0 }, /* #93 */
    { 0x1862d6, 0x186296, 0xddb7d16313c0e7e2, 0x000000000000003f, 0x9c2743600f13c9d3, 0x0 }, /* #94 */
    { 0x3802c6, 0x380286, 0xadce4b7b449951e0, 0x000000000000003e, 0x5679e917f3927db0, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bsr_u64_amd = RT_ELEMENTS(g_aTests_bsr_u64_amd);

BINU64_TEST_T const g_aTests_imul_two_u64_amd[] =
{
    { 0x357082, 0x357082, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x027fd7, 0x0277d6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1e37d7, 0x1e37d6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x3f59c2, 0x3f51c2, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x284d46, 0x284546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x310f16, 0x310716, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x291e07, 0x291606, 0x4dccd65de0fc3449, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x0d1b92, 0x0d1392, 0x29ec75847260b0a2, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x176352, 0x176352, 0x65366f57f9c9a420, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x074bd7, 0x0743d6, 0x31420e5325179cf6, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x3a2516, 0x3a2516, 0x9586f87bceb61a84, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x235e47, 0x235646, 0x3e8c62a80202b06b, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x212386, 0x212b87, 0x8ca38b92b12d2bff, 0x3a3c4c1b1eb4a747, 0x67523252c52024b9, 0x0 }, /* #12 */
    { 0x253983, 0x253983, 0xa4cfd1dc59800903, 0x601569f9b7b8e3ab, 0xb85b1c3607daf639, 0x0 }, /* #13 */
    { 0x193a03, 0x193a03, 0x515e654baeb780a3, 0xcac15d9fe7aadc9f, 0x9bcb38154c4c27d5, 0x0 }, /* #14 */
    { 0x0e78d6, 0x0e78d7, 0x24f3f1ef2a3a7955, 0x6425adbfe96fe261, 0x2719a3b4cb9094dd, 0x0 }, /* #15 */
    { 0x0a3347, 0x0a3b47, 0xb24be03c0441a742, 0x51e2fdecfada2146, 0xcb6c7800d36ebdc3, 0x0 }, /* #16 */
    { 0x3a4dd3, 0x3a4dd3, 0xa0337680a5cda59b, 0xeb1072dd1dbddf2d, 0x14f2ffa6d2a8fed7, 0x0 }, /* #17 */
    { 0x2e16d6, 0x2e1ed7, 0x05986193269ed49c, 0xbcbcaf3427b182d4, 0x8408ca33172dfcc3, 0x0 }, /* #18 */
    { 0x125c56, 0x125c57, 0x40cf0ae5c13fc1d7, 0x4f4f01ab1e8ff92b, 0x96ea5f7758d440cd, 0x0 }, /* #19 */
    { 0x210943, 0x210943, 0x9430897eecc27b5a, 0x315ad5870b4ce5c0, 0x5b3ef4b87e92da60, 0x0 }, /* #20 */
    { 0x346a03, 0x346a03, 0x68e7604ebf1b899b, 0xd78c9830f8e72c90, 0x47db1acdae63d6b0, 0x0 }, /* #21 */
    { 0x3c2d96, 0x3c2d97, 0x5d91e4270a2853be, 0xa51241c2583d7762, 0x98f1763b9519ec6f, 0x0 }, /* #22 */
    { 0x094913, 0x094913, 0x477e9602c11eb6f9, 0x038fa8f39e3d81f6, 0x42d009b807aa6126, 0x0 }, /* #23 */
    { 0x2e3146, 0x2e3947, 0xcde3c3e9b0a6aa03, 0xf5b27abcca82e35a, 0xc3bf5dd3a452fd1e, 0x0 }, /* #24 */
    { 0x286a46, 0x286a47, 0x2546094d09b47080, 0xf4de0ea5754c5600, 0x98ba7460190cd22c, 0x0 }, /* #25 */
    { 0x2e7802, 0x2e7803, 0xefe84f0bd9d11d82, 0xacc01d28af0bfc24, 0xcd853d283c9d9492, 0x0 }, /* #26 */
    { 0x3234d2, 0x323cd3, 0x2d32e1f293ec08c1, 0x5f1a55b1aa02d70c, 0x6615235f278fee0c, 0x0 }, /* #27 */
    { 0x056656, 0x056e57, 0x71ba2620f2c15133, 0x2af11fbda91fd95c, 0x6a96c07a741d3934, 0x0 }, /* #28 */
    { 0x361f46, 0x361f47, 0x9a7f4ccfcb1cf68f, 0xccc423d222b06a3d, 0xba2f94f99b8bd873, 0x0 }, /* #29 */
    { 0x1d0547, 0x1d0d47, 0xd462c1656e58fd60, 0x7fa492d957a4ef20, 0x009bf2cd5f86f92b, 0x0 }, /* #30 */
    { 0x2111d6, 0x2119d7, 0x2caf381377afa5d0, 0x725f87d4aca03100, 0x196ac86ae38a7e50, 0x0 }, /* #31 */
    { 0x0b5502, 0x0b5d03, 0x11817f93534db08b, 0xc96075de49aeb831, 0xb16b015e8cdeb5b3, 0x0 }, /* #32 */
    { 0x267c56, 0x267c57, 0x988451d9d78ac8ca, 0xf0dd813432658ed4, 0xe3cc989c97198a22, 0x0 }, /* #33 */
    { 0x373c02, 0x373c03, 0x0186fd8b254c807a, 0xc7e2308e87b111c2, 0x67eb9bf0456fb175, 0x0 }, /* #34 */
    { 0x0a3e03, 0x0a3e03, 0x7a366c25d60270b8, 0x3df86c67f965e690, 0x60526c24caf60efe, 0x0 }, /* #35 */
    { 0x3960c3, 0x3968c3, 0x5d09e3888cdb7990, 0xad31904c94b453c0, 0x3e6a54477439049c, 0x0 }, /* #36 */
    { 0x034207, 0x034a07, 0x97074a1ecd2c4b5b, 0x5b07fd75ff0565d7, 0xf52e23c41f932435, 0x0 }, /* #37 */
    { 0x2e54d6, 0x2e5cd7, 0xbdcac22bf9cbf715, 0x722ffcc954012596, 0xa3f14c31ca91b4be, 0x0 }, /* #38 */
    { 0x013746, 0x013f47, 0x48ea0e32471c259f, 0xabb5e011b235b4d0, 0x7c69f5b17e49f930, 0x0 }, /* #39 */
    { 0x015653, 0x015e53, 0x161158609b52c14f, 0x93d6dfac684d3a5f, 0xd7810c95ccc111f1, 0x0 }, /* #40 */
    { 0x211643, 0x211e43, 0xd11d49fa74fc126b, 0xa314ddbec396d25f, 0x3891967219e3c4dd, 0x0 }, /* #41 */
    { 0x2c3343, 0x2c3b43, 0x7ab97c0067e15594, 0xb645e5e9eec32f58, 0xb6e97d7ce77c021e, 0x0 }, /* #42 */
    { 0x2d7406, 0x2d7c07, 0x495c9831451e5112, 0xa19d2da0a6f56d9e, 0x9d42bbbd9e0bde97, 0x0 }, /* #43 */
    { 0x332502, 0x332d03, 0xfe46ff5bb69dfce8, 0xbecaf1c04612a6b0, 0xe4f41df66726cf4e, 0x0 }, /* #44 */
    { 0x1b3543, 0x1b3d43, 0xce30a155d1856af3, 0x03bc944aa21fa28e, 0xf219b2bc1aafdaba, 0x0 }, /* #45 */
    { 0x250f03, 0x250f03, 0x9679d23b34da08d4, 0x25053b14fa97bf50, 0xb2971fd7d7d92b04, 0x0 }, /* #46 */
    { 0x2b7613, 0x2b7e13, 0x3469618071dd3f56, 0x7ec3dbd25d1500ce, 0x879bcb7a32805635, 0x0 }, /* #47 */
    { 0x0b3a57, 0x0b3a57, 0x59bb3608eec06742, 0xe8df979d437a2bfc, 0x3b83582191d8753e, 0x0 }, /* #48 */
    { 0x0e7d07, 0x0e7d07, 0x7e1ac8370c077714, 0xbce724938257e39c, 0x1eb83c2d504eb2bb, 0x0 }, /* #49 */
    { 0x365ed2, 0x365ed3, 0x3e56569593266785, 0x0c61c506d069fadc, 0xf7a66424d64e702c, 0x0 }, /* #50 */
    { 0x3834d2, 0x383cd3, 0xe7778f151c297bb0, 0xd86bd563f4b5c0b0, 0xce4fb2579a52bff1, 0x0 }, /* #51 */
    { 0x057512, 0x057d13, 0x5461eec44e0a8407, 0xfee2cdf09b46e3f5, 0x833ba6f3a982b123, 0x0 }, /* #52 */
    { 0x0d1d07, 0x0d1d07, 0xcbe228d78e8a16d9, 0xcbe9f0c8c649ff4c, 0x4ade6e8face7622c, 0x0 }, /* #53 */
    { 0x2c1487, 0x2c1c87, 0x499f0d3ec5d596cb, 0x3a864938c0b1ae3c, 0xf3aad04c691e8734, 0x0 }, /* #54 */
    { 0x114816, 0x114817, 0x5d1be0a0bd5322f4, 0xabff7f0e65371258, 0xc1b6eab79138374e, 0x0 }, /* #55 */
    { 0x2b1542, 0x2b1d43, 0xc3dc8efc73942838, 0xd00b4fbe8115f2f0, 0x6a9cd91ac52f6532, 0x0 }, /* #56 */
    { 0x314fd3, 0x314fd3, 0x929a47a7482f3277, 0x7a7685c79b38a12d, 0x935a57fd4ed62e7b, 0x0 }, /* #57 */
    { 0x064dc3, 0x064dc3, 0xdf88ef2b5870f399, 0x132212149e8117c5, 0xa09be84e970e210d, 0x0 }, /* #58 */
    { 0x306993, 0x306993, 0x8ca20b47dae56e24, 0xbe9f698f54f8ac5c, 0x028937742292899f, 0x0 }, /* #59 */
    { 0x1742c6, 0x174ac7, 0x6dc454f1dd75ff2e, 0xfdcdbb85702d508a, 0x1fb5aee974a4d283, 0x0 }, /* #60 */
    { 0x2e7416, 0x2e7c17, 0x236669ae97075909, 0x9ed17c6b33865265, 0x8be2130258a4517d, 0x0 }, /* #61 */
    { 0x0d6e46, 0x0d6e47, 0x16d010366d5e7eb2, 0x8d6c30db76f65f80, 0xd61accb1f5d875c0, 0x0 }, /* #62 */
    { 0x342482, 0x342c83, 0xb1d5162418e442ab, 0x2b64a3e146ba154a, 0x923f1d7c5ca0cfde, 0x0 }, /* #63 */
    { 0x286213, 0x286a13, 0xb118a985aa9264d0, 0x305961f403bfd410, 0x22ae16b5ca2194c5, 0x0 }, /* #64 */
    { 0x1456d6, 0x145ed7, 0xd26a302ea6e63041, 0x5d534ef848221233, 0x4dc1df5779812573, 0x0 }, /* #65 */
    { 0x2d4fc7, 0x2d4fc7, 0x3cfaea0104a63949, 0x74e9da56705bbe95, 0x9ab3b76d7d1906ed, 0x0 }, /* #66 */
    { 0x0f62c7, 0x0f6ac7, 0xf4abd1f5835f874d, 0x8f8698ab1a40d422, 0xa578e8e03c6567aa, 0x0 }, /* #67 */
    { 0x005d52, 0x005d53, 0x946459ffdbc3cf62, 0xf56d88bc16431cdc, 0x1cb52b7988507ece, 0x0 }, /* #68 */
    { 0x392382, 0x392b83, 0x97f737f4fd540874, 0x236d5e7a7c3de578, 0xbbae2b99a77a8076, 0x0 }, /* #69 */
    { 0x300916, 0x300917, 0x03c0db6a37027aa0, 0x245b0557d362ebc0, 0xcdca13d92a852ee6, 0x0 }, /* #70 */
    { 0x1d1283, 0x1d1a83, 0xd02af75becf22ff6, 0xb20fa6219776537a, 0x2cafe8dd34d57fa7, 0x0 }, /* #71 */
    { 0x213cc2, 0x213cc3, 0xf9abc43e73662f4e, 0x6dd14c01df2c191e, 0x2eb46b9c7be100d9, 0x0 }, /* #72 */
    { 0x050786, 0x050f87, 0x0f6633611b327bed, 0xa7084d371e2d3600, 0x3462022afeb74e00, 0x0 }, /* #73 */
    { 0x3c4f17, 0x3c4f17, 0xe47e9082432c9742, 0xf1e864b0f082874a, 0xf95c64d9f1415985, 0x0 }, /* #74 */
    { 0x2120c6, 0x2128c7, 0x85e5b98e1c30c53f, 0x51aa79aa18b5c845, 0x31b8495becf93d7b, 0x0 }, /* #75 */
    { 0x180ed7, 0x180ed7, 0x2c1de1c457b7ecd6, 0x594540b24b544da8, 0x4ced8402ddd1217c, 0x0 }, /* #76 */
    { 0x3546c2, 0x354ec3, 0x6194c428ff4c2ae7, 0x9675a1cf66affc17, 0x4f58865badda2f51, 0x0 }, /* #77 */
    { 0x1c6907, 0x1c6907, 0xe350479dcb48f700, 0xd15d81348ea44100, 0x4b141241ab8da687, 0x0 }, /* #78 */
    { 0x3a6f17, 0x3a6f17, 0x151d18714dd2f621, 0xaac8a345ce93ee1e, 0x0195b345292fce5e, 0x0 }, /* #79 */
    { 0x2c1886, 0x2c1887, 0x2438b4871cd9e0d8, 0x3535ec118d75b540, 0x58515c9c86d43e78, 0x0 }, /* #80 */
    { 0x171217, 0x171a17, 0x0d143ada012e65a9, 0x19679ec16487b623, 0x89684b83ab23c4eb, 0x0 }, /* #81 */
    { 0x350a42, 0x350a43, 0x2de4be7dcd098c76, 0xdd28feab5c1795ae, 0x9a070d0dc4961815, 0x0 }, /* #82 */
    { 0x295dd6, 0x295dd7, 0x94b46f0995e2aca4, 0x7e21348149369414, 0x8343c68c91e5c27d, 0x0 }, /* #83 */
    { 0x2033d6, 0x203bd7, 0xeec0b7502faaaee6, 0x2a2e4a166c25ffbc, 0x4a08c2f4ee42fd2a, 0x0 }, /* #84 */
    { 0x374707, 0x374f07, 0x78c5ff8bf01fd0cf, 0xdea0398caef46925, 0x63f4d4f80f0c1bcb, 0x0 }, /* #85 */
    { 0x097813, 0x097813, 0x52125e889dc775f9, 0x798756985c915650, 0xfd317659f3fc5cd0, 0x0 }, /* #86 */
    { 0x110d47, 0x110d47, 0x72a8dbfadf3e4aec, 0x9ed9fbbdd6d569ac, 0x8aebc5b96c021411, 0x0 }, /* #87 */
    { 0x017a42, 0x017a43, 0xaa3265efccd6cd16, 0xa9d42aa7fc2c4d56, 0xd84c25e6d2c26461, 0x0 }, /* #88 */
    { 0x0c2b82, 0x0c2b83, 0x6bc8a210f1bbf8c2, 0xf419789ace2bc18a, 0xebba8cea8107dee5, 0x0 }, /* #89 */
    { 0x396d13, 0x396d13, 0xc41f53cc9fe82ded, 0x644969ca2b75e25d, 0x74cc811fe4b67831, 0x0 }, /* #90 */
    { 0x315603, 0x315e03, 0xed844238b90da003, 0x6ddcf814fbd285a0, 0x714fbd13461781e0, 0x0 }, /* #91 */
    { 0x064387, 0x064b87, 0x8d7799804145cc8a, 0x743729f00b6707ce, 0x218f1c5066feca3b, 0x0 }, /* #92 */
    { 0x0b7a13, 0x0b7a13, 0x203c1364fbd8f309, 0xcebb8f0fd8d86058, 0x1526c627881d3b98, 0x0 }, /* #93 */
    { 0x1b3542, 0x1b3d43, 0x10dc99ab89c7a00c, 0xb4fb4ebe66a7a448, 0xca12513d82ecd306, 0x0 }, /* #94 */
    { 0x1321c2, 0x1329c3, 0x42aedfd9a4628f50, 0x5bd384e07833eaa0, 0x5d835c57a6ea41c2, 0x0 }, /* #95 */
};
uint32_t const g_cTests_imul_two_u64_amd = RT_ELEMENTS(g_aTests_imul_two_u64_amd);

BINU16_TEST_T const g_aTests_shld_u16_amd[] =
{
    { 0x2362c6, 0x236256, 0x0000, 0x0000, 0x0000, 39 }, /* #0 */
    { 0x211882, 0x211056, 0x0000, 0x0000, 0x0000, 44 }, /* #1 */
    { 0x1754d7, 0x175456, 0x0000, 0x0000, 0x0000,  5 }, /* #2 */
    { 0x241bc7, 0x241356, 0x0000, 0x0000, 0x0000, 22 }, /* #3 */
    { 0x061352, 0x061356, 0x0000, 0x0000, 0x0000,  4 }, /* #4 */
    { 0x3a6d82, 0x3a6556, 0x0000, 0x0000, 0x0000,  4 }, /* #5 */
    { 0x2f2613, 0x2f2656, 0x88d9, 0x0000, 0x0000, 23 }, /* #6 */
    { 0x037146, 0x037156, 0x6265, 0x0000, 0x0000, 26 }, /* #7 */
    { 0x2a1fd6, 0x2a1797, 0xd7cb, 0x8000, 0x0000, 15 }, /* #8 */
    { 0x392397, 0x392397, 0xd33b, 0xd33b, 0x0000,  0 }, /* #9 */
    { 0x0d2c56, 0x0d2456, 0x434f, 0x0000, 0x0000, 50 }, /* #10 */
    { 0x250583, 0x250556, 0xa0d4, 0x0000, 0x0000, 29 }, /* #11 */
    { 0x2f03d3, 0x2f0393, 0xfeca, 0xb2a2, 0x88e1,  6 }, /* #12 */
    { 0x312b86, 0x312316, 0x4a99, 0x2f6a, 0xbda8, 62 }, /* #13 */
    { 0x0a63c6, 0x0a6316, 0x0410, 0x21b1, 0xd8e6,  9 }, /* #14 */
    { 0x221dd6, 0x221592, 0x34bf, 0xf46b, 0x1afd, 58 }, /* #15 */
    { 0x3d7883, 0x3d7012, 0x13c1, 0x7a38, 0xe8e1, 30 }, /* #16 */
    { 0x102747, 0x102797, 0x1197, 0xfdaf, 0xf6bc, 46 }, /* #17 */
    { 0x372187, 0x372116, 0xb521, 0x7f7b, 0xbdbf, 25 }, /* #18 */
    { 0x071543, 0x071d92, 0x62e0, 0xe075, 0x7575, 40 }, /* #19 */
    { 0x284a12, 0x284292, 0x9afd, 0xdc8f, 0x723f, 30 }, /* #20 */
    { 0x002003, 0x002096, 0xca8e, 0xd36c, 0x69b6, 49 }, /* #21 */
    { 0x236283, 0x236212, 0x4696, 0x10c8, 0x4320, 30 }, /* #22 */
    { 0x076a57, 0x076297, 0xffe6, 0xf335, 0x6a89,  7 }, /* #23 */
    { 0x1e1702, 0x1e1f13, 0x148f, 0x23fd, 0xf469,  6 }, /* #24 */
    { 0x1847d3, 0x184f17, 0x340c, 0x0335, 0x0cd6, 14 }, /* #25 */
    { 0x377a97, 0x377212, 0x35c2, 0x4afe, 0x5fc9, 59 }, /* #26 */
    { 0x300a82, 0x300a17, 0x119a, 0x19aa, 0xa26a,  4 }, /* #27 */
    { 0x002f46, 0x002716, 0xc511, 0x7bc3, 0xef0e, 46 }, /* #28 */
    { 0x347787, 0x347793, 0x76cb, 0xa0f1, 0x41e2, 47 }, /* #29 */
    { 0x192386, 0x192312, 0x851e, 0x28f4, 0x8875, 35 }, /* #30 */
    { 0x350653, 0x350612, 0x0ba5, 0x5d2c, 0x918a, 35 }, /* #31 */
    { 0x3f7296, 0x3f7a13, 0xe565, 0x657c, 0x657c, 48 }, /* #32 */
    { 0x1b3116, 0x1b3112, 0x8080, 0x0573, 0x5cc1, 26 }, /* #33 */
    { 0x387187, 0x387112, 0xd134, 0x5bf1, 0xdf8a, 61 }, /* #34 */
    { 0x143e96, 0x143e92, 0x0352, 0x8915, 0x2455, 14 }, /* #35 */
    { 0x0b6286, 0x0b6292, 0x1c67, 0xb175, 0xeb62, 55 }, /* #36 */
    { 0x2b50d6, 0x2b5096, 0x16f9, 0xd774, 0x6bba, 17 }, /* #37 */
    { 0x207c53, 0x207493, 0x7120, 0xc480, 0x2b48,  2 }, /* #38 */
    { 0x315dd6, 0x315d13, 0x29b8, 0x3701, 0x0a9e,  5 }, /* #39 */
    { 0x380a57, 0x380292, 0xb2a9, 0x879b, 0x79b8, 60 }, /* #40 */
    { 0x3f0716, 0x3f0793, 0x42af, 0xe15e, 0x0af1, 45 }, /* #41 */
    { 0x2605c2, 0x260512, 0xe7d5, 0x1cc8, 0x7320, 30 }, /* #42 */
    { 0x1c2ac3, 0x1c2296, 0xa145, 0xabc3, 0xe1d5, 25 }, /* #43 */
    { 0x3f3d47, 0x3f3516, 0x84f5, 0x7a93, 0x277a,  7 }, /* #44 */
    { 0x235c52, 0x235416, 0x0d83, 0x0927, 0x49c2, 26 }, /* #45 */
    { 0x246f53, 0x246716, 0xa280, 0x280a, 0xa843,  4 }, /* #46 */
    { 0x142a13, 0x142296, 0xff2a, 0xe722, 0x45ce, 23 }, /* #47 */
    { 0x2a4386, 0x2a4312, 0x20f6, 0x41ec, 0x09fd,  1 }, /* #48 */
    { 0x0669d6, 0x066196, 0x400f, 0xe7cf, 0xcf9f, 63 }, /* #49 */
    { 0x1c7c02, 0x1c7496, 0x94e4, 0x99a3, 0x399a, 52 }, /* #50 */
    { 0x007e17, 0x007e96, 0xc85b, 0xd841, 0x0827, 11 }, /* #51 */
    { 0x297d06, 0x297597, 0x5756, 0xb43c, 0xd0f1, 14 }, /* #52 */
    { 0x277896, 0x277817, 0x0407, 0x01e7, 0x9f27,  6 }, /* #53 */
    { 0x3c2493, 0x3c2496, 0xc90b, 0xb4c9, 0x26d3, 22 }, /* #54 */
    { 0x3b7cc3, 0x3b7c13, 0xace4, 0x6725, 0xbfd5,  3 }, /* #55 */
    { 0x106f46, 0x106712, 0xac7f, 0x2054, 0x02a1, 61 }, /* #56 */
    { 0x245a52, 0x245212, 0xa1a0, 0x2ad3, 0x4cab, 22 }, /* #57 */
    { 0x263686, 0x263692, 0xca26, 0xf04a, 0xbc12, 50 }, /* #58 */
    { 0x066303, 0x066316, 0xec97, 0x746c, 0xd1b1, 62 }, /* #59 */
    { 0x032f97, 0x032796, 0xff5f, 0xd9e2, 0xe2d9, 56 }, /* #60 */
    { 0x0018c6, 0x001016, 0xa733, 0x5ee1, 0x0af7, 21 }, /* #61 */
    { 0x066a92, 0x066a17, 0x9adf, 0x5bfa, 0xd5d8, 37 }, /* #62 */
    { 0x001847, 0x001012, 0x2062, 0x70c2, 0x184e, 27 }, /* #63 */
    { 0x017d13, 0x017512, 0x2b53, 0x67c1, 0x82cf, 55 }, /* #64 */
    { 0x091507, 0x091596, 0x38df, 0xe07b, 0xef81, 54 }, /* #65 */
    { 0x346a17, 0x346216, 0xa0ec, 0x689f, 0xed13, 19 }, /* #66 */
    { 0x2a5d57, 0x2a5d13, 0xcb6c, 0x0d7f, 0x35ff, 46 }, /* #67 */
    { 0x3d6906, 0x3d6116, 0x12d0, 0x02e8, 0x1740, 45 }, /* #68 */
    { 0x366113, 0x366192, 0x136d, 0xbdfe, 0x5eff, 49 }, /* #69 */
    { 0x2b7e46, 0x2b7612, 0x38a4, 0x5258, 0xb105, 39 }, /* #70 */
    { 0x3a3696, 0x3a3612, 0xb2dd, 0x5f54, 0xf545, 60 }, /* #71 */
    { 0x122953, 0x122192, 0xa3ca, 0xf0e0, 0x383c, 26 }, /* #72 */
    { 0x331547, 0x331592, 0xb1ad, 0xaa13, 0xea84, 18 }, /* #73 */
    { 0x0e3746, 0x0e3712, 0x0b51, 0x16a2, 0x02a4,  1 }, /* #74 */
    { 0x0901c2, 0x090116, 0x0c1e, 0x4dc9, 0x9b92, 31 }, /* #75 */
    { 0x000557, 0x000596, 0x4fca, 0xe4f5, 0x793d, 50 }, /* #76 */
    { 0x2d0297, 0x2d0216, 0x66d3, 0x42fa, 0xbe90, 58 }, /* #77 */
    { 0x102503, 0x102592, 0x6fcd, 0x808a, 0x08a8, 60 }, /* #78 */
    { 0x267f97, 0x267f17, 0x5cd6, 0x35bd, 0xf6b4, 38 }, /* #79 */
    { 0x321842, 0x321896, 0x774b, 0xee96, 0x039f, 33 }, /* #80 */
    { 0x0c1f93, 0x0c1f92, 0xab64, 0xad91, 0x4e72,  2 }, /* #81 */
    { 0x036582, 0x036512, 0xe83d, 0x7a79, 0x3cf1, 41 }, /* #82 */
    { 0x2c7fd2, 0x2c7fd2, 0x6fdd, 0x6fdd, 0x29e7, 32 }, /* #83 */
    { 0x191a86, 0x191212, 0x1326, 0x4f13, 0x4f13, 48 }, /* #84 */
    { 0x136d52, 0x136512, 0x8d45, 0x2f2c, 0xe58b, 43 }, /* #85 */
    { 0x352f02, 0x352712, 0xefc6, 0x07ab, 0xeac1, 26 }, /* #86 */
    { 0x1b6807, 0x1b6097, 0xd028, 0xa050, 0x0b08,  1 }, /* #87 */
    { 0x277403, 0x277c92, 0x377d, 0xddf4, 0x15c9, 34 }, /* #88 */
    { 0x1f6c03, 0x1f6416, 0x5141, 0x4eb2, 0x93ac, 50 }, /* #89 */
    { 0x111ad6, 0x111a17, 0x1659, 0x596a, 0x596a, 48 }, /* #90 */
    { 0x1126d6, 0x112693, 0xef00, 0xde01, 0xf32c,  1 }, /* #91 */
    { 0x0e3f57, 0x0e3f17, 0xbf48, 0x4830, 0x30ea, 40 }, /* #92 */
    { 0x2a7f87, 0x2a7712, 0x4b24, 0x7215, 0x42ae, 59 }, /* #93 */
    { 0x0465d6, 0x046516, 0x7581, 0x0665, 0x8332, 17 }, /* #94 */
    { 0x280993, 0x280917, 0xda7f, 0x3ffa, 0xf44b, 39 }, /* #95 */
    { 0x184687, 0x184692, 0x6d6e, 0xc907, 0x920f, 63 }, /* #96 */
    { 0x216e82, 0x216612, 0x16e0, 0x74d9, 0xe9b2, 15 }, /* #97 */
    { 0x0a3116, 0x0a3112, 0xf848, 0x1bba, 0x6ee8, 46 }, /* #98 */
    { 0x196ed3, 0x196616, 0xacd7, 0x2cc9, 0x9664, 49 }, /* #99 */
    { 0x3f1b43, 0x3f1316, 0xba2e, 0x3dac, 0x61ed, 21 }, /* #100 */
    { 0x2e17d7, 0x2e1716, 0xe434, 0x127b, 0x27b1, 28 }, /* #101 */
    { 0x3574c7, 0x357496, 0xfa6f, 0xa947, 0x947a, 60 }, /* #102 */
    { 0x081e46, 0x081697, 0x65c7, 0xc72e, 0x1cb8, 46 }, /* #103 */
    { 0x355896, 0x355892, 0x663e, 0xc7ce, 0x770b, 37 }, /* #104 */
    { 0x011693, 0x011696, 0xa835, 0xc6c6, 0x6363, 57 }, /* #105 */
    { 0x2d2407, 0x2d2412, 0x1319, 0x7c40, 0x03e2, 21 }, /* #106 */
    { 0x046d86, 0x046d96, 0xa4d1, 0xe703, 0xce07, 47 }, /* #107 */
    { 0x2e7516, 0x2e7512, 0x064d, 0x0c9b, 0xe481, 33 }, /* #108 */
    { 0x216ed6, 0x216697, 0x46f5, 0xd6d4, 0xb509, 42 }, /* #109 */
    { 0x2463d2, 0x246396, 0xdde7, 0xbba3, 0x7747, 63 }, /* #110 */
    { 0x214303, 0x214393, 0x9ac0, 0x81a4, 0xd22c, 41 }, /* #111 */
    { 0x2a6356, 0x2a6316, 0x036e, 0x515a, 0x5a51, 24 }, /* #112 */
    { 0x072342, 0x072396, 0x9edc, 0xf1bd, 0xbe37, 51 }, /* #113 */
    { 0x3433c3, 0x3433c3, 0xd943, 0xd943, 0xeb5e,  0 }, /* #114 */
    { 0x174f53, 0x174f92, 0x5a2b, 0xfa13, 0xe84f, 14 }, /* #115 */
    { 0x311e42, 0x311e42, 0x24dd, 0x24dd, 0x397b, 32 }, /* #116 */
    { 0x1e3c17, 0x1e3412, 0x42e6, 0x619b, 0x19b6, 12 }, /* #117 */
    { 0x0947c3, 0x094716, 0x701e, 0x4d6a, 0xd49a, 55 }, /* #118 */
    { 0x1204d2, 0x120c96, 0xb80d, 0xd5e7, 0x5e7f, 44 }, /* #119 */
    { 0x2c2306, 0x2c2b13, 0x2114, 0x14c8, 0xc8f8, 40 }, /* #120 */
    { 0x2b6f87, 0x2b6797, 0x6bd7, 0xaf5c, 0x2090, 34 }, /* #121 */
    { 0x3617d3, 0x361716, 0x64f9, 0x25b7, 0x4b6e, 31 }, /* #122 */
    { 0x252782, 0x252792, 0xdb54, 0xd2e0, 0x7069, 57 }, /* #123 */
    { 0x001a46, 0x001293, 0x8270, 0x863d, 0xc7ae, 43 }, /* #124 */
    { 0x2f7bc2, 0x2f7312, 0x4484, 0x2e8c, 0x6174, 53 }, /* #125 */
    { 0x057d13, 0x057512, 0x725b, 0x6c5b, 0xb6d8, 55 }, /* #126 */
    { 0x105a07, 0x105a96, 0x0a72, 0xbb3f, 0xecfd, 46 }, /* #127 */
};
uint32_t const g_cTests_shld_u16_amd = RT_ELEMENTS(g_aTests_shld_u16_amd);

BINU16_TEST_T const g_aTests_shrd_u16_amd[] =
{
    { 0x2039c2, 0x203156, 0x0000, 0x0000, 0x0000, 40 }, /* #0 */
    { 0x086886, 0x086056, 0x0000, 0x0000, 0x0000, 27 }, /* #1 */
    { 0x266046, 0x266056, 0x0000, 0x0000, 0x0000, 52 }, /* #2 */
    { 0x250ad3, 0x250256, 0x0000, 0x0000, 0x0000, 40 }, /* #3 */
    { 0x140713, 0x140756, 0x0000, 0x0000, 0x0000, 34 }, /* #4 */
    { 0x3137d7, 0x313756, 0x0000, 0x0000, 0x0000, 49 }, /* #5 */
    { 0x0b0e02, 0x0b0656, 0x40ae, 0x0000, 0x0000, 49 }, /* #6 */
    { 0x3d6916, 0x3d6116, 0xd689, 0x0003, 0x0000, 14 }, /* #7 */
    { 0x3a0406, 0x3a0412, 0x45d4, 0x0004, 0x0000, 12 }, /* #8 */
    { 0x303f16, 0x303756, 0x3ec2, 0x0000, 0x0000, 27 }, /* #9 */
    { 0x044687, 0x044613, 0x874f, 0x10e9, 0x0000, 35 }, /* #10 */
    { 0x0479d2, 0x047156, 0x2541, 0x0000, 0x0000, 25 }, /* #11 */
    { 0x2569c2, 0x256197, 0x6b44, 0xda78, 0x6d3c, 15 }, /* #12 */
    { 0x0f1e16, 0x0f1e96, 0x6c3f, 0xb371, 0xc6cd, 58 }, /* #13 */
    { 0x3a5fd3, 0x3a5f92, 0x9339, 0xa852, 0xa14a, 18 }, /* #14 */
    { 0x3c0197, 0x3c0996, 0x3992, 0xa87d, 0xb50f, 61 }, /* #15 */
    { 0x0d4d86, 0x0d4d96, 0xc453, 0x9635, 0x2c6b, 17 }, /* #16 */
    { 0x325d06, 0x325d13, 0xcf78, 0x4b3d, 0xea12,  6 }, /* #17 */
    { 0x3d0ac6, 0x3d0a17, 0x2fd2, 0x4617, 0xaa8c, 41 }, /* #18 */
    { 0x002387, 0x002396, 0x09bf, 0xd895, 0x12bb, 21 }, /* #19 */
    { 0x322b03, 0x322b16, 0x0769, 0x60ed, 0x93bb,  3 }, /* #20 */
    { 0x014416, 0x014c17, 0xd79f, 0x5b8e, 0x2b71, 13 }, /* #21 */
    { 0x222b16, 0x222396, 0x0781, 0xf41e, 0xc73d, 38 }, /* #22 */
    { 0x116046, 0x116816, 0xe5fa, 0x4b12, 0xb124, 20 }, /* #23 */
    { 0x055446, 0x055412, 0x737d, 0x07ec, 0x3f60, 19 }, /* #24 */
    { 0x1418c7, 0x141092, 0x974f, 0xfbc1, 0xf07e, 22 }, /* #25 */
    { 0x2c4f42, 0x2c4f92, 0x72d6, 0x8d49, 0x6352, 62 }, /* #26 */
    { 0x002617, 0x002612, 0x59b7, 0x374f, 0x3cdd, 26 }, /* #27 */
    { 0x006003, 0x006016, 0x3eeb, 0x3a5f, 0xd2f9, 51 }, /* #28 */
    { 0x046057, 0x046016, 0x315f, 0x00dd, 0x806e, 63 }, /* #29 */
    { 0x3b3486, 0x3b3496, 0x1683, 0xd860, 0x306c, 23 }, /* #30 */
    { 0x0b4803, 0x0b4012, 0x76d6, 0x052f, 0x14bc, 18 }, /* #31 */
    { 0x253496, 0x253497, 0x9b9b, 0xfb4d, 0xf5f6,  9 }, /* #32 */
    { 0x1a0456, 0x1a0c92, 0x409b, 0x85b5, 0x85b5, 16 }, /* #33 */
    { 0x113e96, 0x113e16, 0x8828, 0x4414, 0x3a94,  1 }, /* #34 */
    { 0x165907, 0x165916, 0x1c8f, 0x43d4, 0x21ea, 31 }, /* #35 */
    { 0x033987, 0x033197, 0x1ee9, 0xf4b8, 0x7e97, 13 }, /* #36 */
    { 0x274f86, 0x274712, 0x467b, 0x32ad, 0x55a6, 21 }, /* #37 */
    { 0x0c04c7, 0x0c0496, 0x09cc, 0xd705, 0x705d, 20 }, /* #38 */
    { 0x0b3f87, 0x0b3797, 0x6f7b, 0xd8de, 0x316c,  7 }, /* #39 */
    { 0x2865d2, 0x286d16, 0xf297, 0x5dcf, 0xb9eb, 21 }, /* #40 */
    { 0x071416, 0x071c92, 0x165a, 0xa2cb, 0x724d, 35 }, /* #41 */
    { 0x370683, 0x370e12, 0xd3ae, 0x74ba, 0x73a5, 43 }, /* #42 */
    { 0x0f16c7, 0x0f1e96, 0xed04, 0xaed4, 0xbb52, 50 }, /* #43 */
    { 0x3d7a52, 0x3d7a52, 0x5aca, 0x5aca, 0xb6ce,  0 }, /* #44 */
    { 0x0777c3, 0x077f12, 0xcdd2, 0x5ce3, 0xce35, 52 }, /* #45 */
    { 0x307096, 0x307096, 0xc909, 0xc987, 0x7261, 46 }, /* #46 */
    { 0x0a2912, 0x0a2993, 0xba28, 0xa6ae, 0xaa9a, 10 }, /* #47 */
    { 0x3300c2, 0x330892, 0xc27b, 0xa537, 0x37a5, 56 }, /* #48 */
    { 0x296383, 0x296b97, 0xf43d, 0x980f, 0xe603, 46 }, /* #49 */
    { 0x0d59d3, 0x0d5197, 0xee4b, 0xdc7e, 0xadc7, 12 }, /* #50 */
    { 0x1334d6, 0x133496, 0xfa85, 0xca00, 0x3280, 62 }, /* #51 */
    { 0x194582, 0x194d96, 0x06a5, 0xa035, 0x6754,  5 }, /* #52 */
    { 0x0b0e06, 0x0b0612, 0x674e, 0x3c29, 0x4f0a, 62 }, /* #53 */
    { 0x271a07, 0x271a96, 0x866e, 0xbc33, 0xcb37, 37 }, /* #54 */
    { 0x2f1696, 0x2f1e92, 0x6e8a, 0x81ec, 0x40f6, 63 }, /* #55 */
    { 0x345b92, 0x345396, 0x5a66, 0xd5a6, 0x112d,  4 }, /* #56 */
    { 0x105953, 0x105953, 0x2802, 0x2802, 0xb317,  0 }, /* #57 */
    { 0x1b6bc6, 0x1b6b12, 0xd2d5, 0x475e, 0xd791, 22 }, /* #58 */
    { 0x0b6312, 0x0b6316, 0x5a83, 0x344d, 0x8d13, 14 }, /* #59 */
    { 0x0d7053, 0x0d7816, 0x584d, 0x5ecf, 0x5ecf, 16 }, /* #60 */
    { 0x0655d3, 0x065593, 0x3586, 0xe6b0, 0x07b7,  3 }, /* #61 */
    { 0x3f3f86, 0x3f3712, 0x4265, 0x34a7, 0x29cd, 54 }, /* #62 */
    { 0x2e2093, 0x2e2896, 0x27a1, 0x8082, 0xf808, 12 }, /* #63 */
    { 0x270d07, 0x270d07, 0x1944, 0x1944, 0xfe43,  0 }, /* #64 */
    { 0x1a29d2, 0x1a2116, 0x284e, 0x3281, 0x4099, 55 }, /* #65 */
    { 0x120dd7, 0x120516, 0x299a, 0x2d4b, 0x5a96, 17 }, /* #66 */
    { 0x0f5857, 0x0f5096, 0xf962, 0xcab1, 0xab1c, 52 }, /* #67 */
    { 0x147702, 0x147716, 0x22dd, 0x1021, 0xe204, 45 }, /* #68 */
    { 0x3f0dc7, 0x3f0517, 0x4432, 0x110c, 0x49c8, 34 }, /* #69 */
    { 0x2d5a93, 0x2d5a13, 0x4e36, 0x6938, 0xc81a, 38 }, /* #70 */
    { 0x2a53d2, 0x2a5317, 0xc9e1, 0x160f, 0x0b07, 47 }, /* #71 */
    { 0x104447, 0x104447, 0x1726, 0x1726, 0xbfe3,  0 }, /* #72 */
    { 0x130053, 0x130012, 0x8d92, 0x3619, 0x9b0c, 47 }, /* #73 */
    { 0x1a7752, 0x1a7f17, 0x4ee2, 0x53b8, 0x0fa9, 34 }, /* #74 */
    { 0x130446, 0x130492, 0x9c2b, 0xd17f, 0xf45f, 30 }, /* #75 */
    { 0x1e5517, 0x1e5d12, 0x1df6, 0x4549, 0x28a9, 61 }, /* #76 */
    { 0x046502, 0x046596, 0xc798, 0xd76f, 0xfd76, 28 }, /* #77 */
    { 0x2d5616, 0x2d5616, 0xb0de, 0xb0de, 0xc396,  0 }, /* #78 */
    { 0x1c6e03, 0x1c6696, 0x6910, 0xda44, 0xcc9b,  2 }, /* #79 */
    { 0x2646c3, 0x264e96, 0x1973, 0xa788, 0xe229, 54 }, /* #80 */
    { 0x010f47, 0x010792, 0x49a5, 0xc5f7, 0xf17d, 62 }, /* #81 */
    { 0x222e42, 0x222e12, 0xbdc8, 0x57b9, 0xc6ea,  3 }, /* #82 */
    { 0x1c24c6, 0x1c2c92, 0x5614, 0x9375, 0x6eb2, 53 }, /* #83 */
    { 0x162953, 0x162996, 0x36dd, 0xa61b, 0xed4c,  9 }, /* #84 */
    { 0x080c56, 0x080c56, 0xb09c, 0xb09c, 0xe67b, 32 }, /* #85 */
    { 0x0b7f13, 0x0b7793, 0x0bd7, 0xf85e, 0x617f,  5 }, /* #86 */
    { 0x1e04c2, 0x1e0412, 0xa4bc, 0x31c8, 0x418e, 59 }, /* #87 */
    { 0x0b2993, 0x0b2996, 0x5371, 0xa274, 0x4e94, 21 }, /* #88 */
    { 0x150193, 0x150193, 0xf66a, 0xf66a, 0xbfd0, 32 }, /* #89 */
    { 0x2078c7, 0x207812, 0xa111, 0x6394, 0x8c72, 61 }, /* #90 */
    { 0x0c6006, 0x0c6897, 0x81fd, 0xab81, 0x20ab, 40 }, /* #91 */
    { 0x176812, 0x176892, 0x478b, 0x908f, 0x0f48, 39 }, /* #92 */
    { 0x3b5582, 0x3b5517, 0x1047, 0x0e60, 0xc1cc, 45 }, /* #93 */
    { 0x3c3bc2, 0x3c3392, 0x32b4, 0xf7d9, 0xdf67, 18 }, /* #94 */
    { 0x1467d6, 0x146f13, 0x6e24, 0x6ea8, 0x3754, 47 }, /* #95 */
    { 0x1935d3, 0x193d96, 0x19f4, 0x867d, 0xf336, 34 }, /* #96 */
    { 0x373112, 0x373116, 0x051b, 0x2fc9, 0x5f92, 17 }, /* #97 */
    { 0x3f6852, 0x3f6092, 0xd212, 0xec0d, 0xc0de, 20 }, /* #98 */
    { 0x1e6442, 0x1e6496, 0x0358, 0xcffa, 0x9ff5, 17 }, /* #99 */
    { 0x107583, 0x107592, 0x8649, 0xd943, 0x287b, 53 }, /* #100 */
    { 0x072907, 0x072917, 0xc95e, 0x4c95, 0x7754,  4 }, /* #101 */
    { 0x0460c2, 0x046812, 0x28b3, 0x5245, 0x2a92, 59 }, /* #102 */
    { 0x122307, 0x122312, 0xbdff, 0x0dfd, 0xbfa1, 21 }, /* #103 */
    { 0x013293, 0x013216, 0x0c47, 0x1c87, 0x1c87, 16 }, /* #104 */
    { 0x052552, 0x052512, 0x5c48, 0x0557, 0xb815, 42 }, /* #105 */
    { 0x375ad2, 0x375212, 0x5806, 0x1bbc, 0x0dde, 63 }, /* #106 */
    { 0x005d82, 0x005596, 0x6cf3, 0xdddb, 0xdf77, 42 }, /* #107 */
    { 0x240713, 0x240792, 0xfac1, 0xcc31, 0x9863, 49 }, /* #108 */
    { 0x3a7657, 0x3a7e12, 0x3a5f, 0x4e0d, 0x4e0d, 16 }, /* #109 */
    { 0x097c06, 0x097c06, 0xca6e, 0xca6e, 0x05bd,  0 }, /* #110 */
    { 0x304397, 0x304397, 0x442f, 0x442f, 0x9064,  0 }, /* #111 */
    { 0x3c2e96, 0x3c2612, 0xad67, 0x3329, 0x4999, 27 }, /* #112 */
    { 0x0c0817, 0x0c0817, 0x9e2f, 0x9e2f, 0x2232,  0 }, /* #113 */
    { 0x2b7897, 0x2b7812, 0xa185, 0x7c34, 0x347c, 24 }, /* #114 */
    { 0x021406, 0x021492, 0xc21a, 0xe10d, 0x46ef, 33 }, /* #115 */
    { 0x216b93, 0x216b16, 0x7ef7, 0x5cde, 0x9bcb, 21 }, /* #116 */
    { 0x005dc7, 0x005d97, 0x1867, 0x8c33, 0x2e51, 33 }, /* #117 */
    { 0x096707, 0x096716, 0xdd53, 0x2e77, 0x973b, 31 }, /* #118 */
    { 0x1d2f86, 0x1d2712, 0x7ab1, 0x3c80, 0x00f2, 26 }, /* #119 */
    { 0x152ad2, 0x152292, 0x6101, 0xd840, 0x96c3, 34 }, /* #120 */
    { 0x0a6997, 0x0a6197, 0x6883, 0xe98e, 0x74c7, 47 }, /* #121 */
    { 0x384112, 0x384192, 0xc85c, 0xe810, 0x1d02, 61 }, /* #122 */
    { 0x3d5713, 0x3d5f92, 0xe397, 0xa5c7, 0xec52,  7 }, /* #123 */
    { 0x013486, 0x013c16, 0xff58, 0x718e, 0x18e7, 52 }, /* #124 */
    { 0x046647, 0x046692, 0xe8e6, 0xf473, 0x803b, 33 }, /* #125 */
    { 0x0605c2, 0x060592, 0xdab8, 0xd432, 0x6a19, 31 }, /* #126 */
    { 0x174ac7, 0x174a96, 0x8063, 0xa0d8, 0x0a0d, 12 }, /* #127 */
};
uint32_t const g_cTests_shrd_u16_amd = RT_ELEMENTS(g_aTests_shrd_u16_amd);

BINU32_TEST_T const g_aTests_shld_u32_amd[] =
{
    { 0x3a1986, 0x3a1156, 0x00000000, 0x00000000, 0x00000000, 43 }, /* #0 */
    { 0x326596, 0x326556, 0x00000000, 0x00000000, 0x00000000, 51 }, /* #1 */
    { 0x311147, 0x311156, 0x00000000, 0x00000000, 0x00000000, 55 }, /* #2 */
    { 0x3c2b97, 0x3c2356, 0x00000000, 0x00000000, 0x00000000, 27 }, /* #3 */
    { 0x0067c3, 0x006756, 0x00000000, 0x00000000, 0x00000000, 108 }, /* #4 */
    { 0x035e86, 0x035656, 0x00000000, 0x00000000, 0x00000000, 102 }, /* #5 */
    { 0x016a57, 0x016297, 0xfdc7a753, 0xc7a75300, 0x00000000, 40 }, /* #6 */
    { 0x0a4bc6, 0x0a4b17, 0x1e07d424, 0x09000000, 0x00000000, 54 }, /* #7 */
    { 0x2538c3, 0x253097, 0x63f3cfca, 0xcf3f2800, 0x00000000, 10 }, /* #8 */
    { 0x1c24c3, 0x1c2497, 0xde33239e, 0x91cf0000, 0x00000000, 15 }, /* #9 */
    { 0x034393, 0x034316, 0xc20b0989, 0x40000000, 0x00000000, 62 }, /* #10 */
    { 0x026e07, 0x026e96, 0x48992d3e, 0xc969f000, 0x00000000, 11 }, /* #11 */
    { 0x2a1086, 0x2a1896, 0x41626c2c, 0xb192af78, 0x64abde3d, 26 }, /* #12 */
    { 0x366547, 0x366512, 0xe850e39f, 0x50e39f16, 0x1690113a, 104 }, /* #13 */
    { 0x3b2103, 0x3b2112, 0x8d33ff86, 0x184332f4, 0x10ccbd2f, 26 }, /* #14 */
    { 0x051246, 0x051212, 0xe64e708d, 0x2349efd3, 0x27bf4ca0, 22 }, /* #15 */
    { 0x186fc6, 0x186793, 0x0d67ccb1, 0xf32c766b, 0xd9af7f57, 14 }, /* #16 */
    { 0x2a5fd7, 0x2a5f13, 0x7b0dd294, 0x294c87c1, 0xc87c10d6, 116 }, /* #17 */
    { 0x1e0ac7, 0x1e0a96, 0x9bdd46db, 0xf751b6e7, 0x9c5702fb, 70 }, /* #18 */
    { 0x227b12, 0x227b17, 0x929917aa, 0x50070622, 0x00e0c443, 123 }, /* #19 */
    { 0x1a1f43, 0x1a1f96, 0x9f4e0cf2, 0xf27d33f3, 0x7d33f3ec, 88 }, /* #20 */
    { 0x010696, 0x010612, 0x94df1ce9, 0x6f8e74c1, 0x83e33087, 71 }, /* #21 */
    { 0x1f4ec3, 0x1f4ec3, 0x70c7bbc4, 0x70c7bbc4, 0x08f859e1, 96 }, /* #22 */
    { 0x2d2546, 0x2d2d17, 0x1d857e4f, 0x7e4fa727, 0xa72783ad, 112 }, /* #23 */
    { 0x0c2042, 0x0c2097, 0x5b37abc4, 0xabc4e3ed, 0xe3edffa5, 16 }, /* #24 */
    { 0x206e96, 0x206e17, 0x16999d61, 0x617f2b56, 0x7f2b56de, 56 }, /* #25 */
    { 0x1e3747, 0x1e3793, 0xf286f098, 0xe131f23b, 0xf91da512, 113 }, /* #26 */
    { 0x0f3592, 0x0f3d13, 0x66862519, 0x128c9876, 0x30eda011, 47 }, /* #27 */
    { 0x1d21d2, 0x1d2913, 0xd2178843, 0x0bc421e3, 0xc6f2effc, 71 }, /* #28 */
    { 0x102112, 0x102917, 0x1feabfbb, 0x57f7659a, 0x2cd19e5b, 45 }, /* #29 */
    { 0x190607, 0x190616, 0xb95abc8a, 0x455a0812, 0xb4102570, 23 }, /* #30 */
    { 0x126386, 0x126b17, 0x5599a3d4, 0x1ea4ce96, 0x99d2df33, 83 }, /* #31 */
    { 0x090242, 0x090293, 0xa5509c3a, 0x8751e816, 0x8f40b6f9, 21 }, /* #32 */
    { 0x3365d2, 0x336d17, 0x50aba7d7, 0x5d3ebfac, 0xf5981ccd, 11 }, /* #33 */
    { 0x0f6307, 0x0f6b17, 0xf0aff9a4, 0x48e25d2d, 0x712e96f4, 57 }, /* #34 */
    { 0x2a2497, 0x2a2497, 0x7bdb3f7d, 0xfbedb92b, 0xb7256711, 51 }, /* #35 */
    { 0x317742, 0x317712, 0x0721cf14, 0x52f288b6, 0xbca22db4, 58 }, /* #36 */
    { 0x2a5193, 0x2a5913, 0x00d32f55, 0x528c896b, 0x28c896b2, 92 }, /* #37 */
    { 0x0e2406, 0x0e2412, 0x5fb2222e, 0x45c4fc45, 0x27e22b17, 117 }, /* #38 */
    { 0x264c87, 0x264c13, 0x4f3dd605, 0x605e4ae0, 0xe4ae0ae7, 84 }, /* #39 */
    { 0x285c02, 0x285416, 0xfe0e72c4, 0x72c4a690, 0xa690e283, 16 }, /* #40 */
    { 0x363112, 0x363992, 0xe224dc92, 0x888341b0, 0x220d06c1, 126 }, /* #41 */
    { 0x060746, 0x060712, 0xc2873861, 0x70c3770d, 0xbb868a66, 17 }, /* #42 */
    { 0x1b5783, 0x1b5793, 0x75ec2afe, 0xb0abfb8f, 0xe3faa55a, 42 }, /* #43 */
    { 0x231a03, 0x231293, 0x35143e3b, 0xe3bc401c, 0xc401cf8a, 20 }, /* #44 */
    { 0x1c1392, 0x1c1b17, 0x7ba6bfa1, 0x74d7f430, 0x806f019f, 69 }, /* #45 */
    { 0x024407, 0x024c96, 0x2c87eab5, 0x87eab5cf, 0xcf4227ea, 104 }, /* #46 */
    { 0x321053, 0x321896, 0xde2b1379, 0xf3bc173a, 0xde0b9d3b, 57 }, /* #47 */
    { 0x3f3cc3, 0x3f3c13, 0x51b89489, 0x1b89489e, 0xed1fd849, 68 }, /* #48 */
    { 0x3027c7, 0x302712, 0x0397048e, 0x737d614a, 0x6fac294c, 91 }, /* #49 */
    { 0x2604d6, 0x260493, 0xae636f55, 0x8dbd5408, 0x02224d3e, 10 }, /* #50 */
    { 0x261f52, 0x261f92, 0x13e7eb68, 0xda37c408, 0xdf1023e1, 22 }, /* #51 */
    { 0x194387, 0x194397, 0x80a8aef2, 0xc909d6cc, 0x4275b308, 122 }, /* #52 */
    { 0x202ed2, 0x202616, 0x26a1efa6, 0x4d43df4d, 0xd17c8f1a, 65 }, /* #53 */
    { 0x220f02, 0x220797, 0xcbe31e7c, 0xe35f3327, 0x6be664fc, 59 }, /* #54 */
    { 0x1f0c93, 0x1f0c96, 0x43d08a72, 0x87a114e4, 0x70316526,  1 }, /* #55 */
    { 0x052a13, 0x052a13, 0xfc6878c5, 0xfc6878c5, 0x6ed0ec7e,  0 }, /* #56 */
    { 0x0a5483, 0x0a5497, 0x6d461dcb, 0x8b27193c, 0x164e3279, 95 }, /* #57 */
    { 0x220913, 0x220996, 0xb78bbc56, 0xbbc56f6f, 0xf6f9ef6a, 44 }, /* #58 */
    { 0x0a4556, 0x0a4512, 0x05635668, 0x5635668f, 0xfcbdc89b, 68 }, /* #59 */
    { 0x2c5a42, 0x2c5a17, 0xb459af32, 0x459af322, 0x2bfd1677,  4 }, /* #60 */
    { 0x077b93, 0x077316, 0x9549c562, 0x2b16f1ed, 0xde3dafd9, 83 }, /* #61 */
    { 0x2803d3, 0x280393, 0xa6a8bf62, 0xf6210ace, 0x10acef95, 20 }, /* #62 */
    { 0x3f7156, 0x3f7193, 0xf407a92c, 0xea4b38bc, 0xe2f3c337, 78 }, /* #63 */
    { 0x0834d2, 0x083c17, 0xee8367bc, 0x67bc750f, 0x750f7f7f, 16 }, /* #64 */
    { 0x1e0ad7, 0x1e0216, 0xcfad2a15, 0x57c697c6, 0xf1a5f190, 58 }, /* #65 */
    { 0x057c87, 0x057493, 0x17c60cf3, 0x85be2945, 0x0b7c528a, 95 }, /* #66 */
    { 0x2a6802, 0x2a6892, 0x5b1a96ee, 0xb7777558, 0xeeab11fc, 83 }, /* #67 */
    { 0x2a03d2, 0x2a0393, 0xfd7ed3b1, 0xfb4ec445, 0x117c49d5, 106 }, /* #68 */
    { 0x161092, 0x161012, 0x486f003b, 0x6f003bef, 0xef7825d0,  8 }, /* #69 */
    { 0x0b3047, 0x0b3813, 0x21ce078c, 0x0e703c64, 0x9d5189aa, 67 }, /* #70 */
    { 0x157d82, 0x157d82, 0x51a4f8f0, 0x51a4f8f0, 0x65d37e70, 64 }, /* #71 */
    { 0x1e5317, 0x1e5b92, 0xb5295453, 0xa7d8bea2, 0xec5f513c, 57 }, /* #72 */
    { 0x0c5cc6, 0x0c5c17, 0xcb272b67, 0x3fc494ed, 0xf8929dbc, 123 }, /* #73 */
    { 0x073652, 0x073652, 0xd2c0ff18, 0xd2c0ff18, 0x3cabab19, 64 }, /* #74 */
    { 0x2b5a56, 0x2b5212, 0x118b7a4d, 0x5bd268e0, 0x1c0a5e3a, 11 }, /* #75 */
    { 0x333012, 0x333093, 0x1d1ab0f2, 0xcb0d5c3e, 0xc3570f9f, 58 }, /* #76 */
    { 0x3a2853, 0x3a2892, 0x73f73097, 0xe612fd32, 0xe9972428, 109 }, /* #77 */
    { 0x221a06, 0x221216, 0x056d8f45, 0x0adb1e8b, 0x9bd91e9f,  1 }, /* #78 */
    { 0x291956, 0x291112, 0x545195c3, 0x32b86f07, 0x783f3fa0, 13 }, /* #79 */
    { 0x064e93, 0x064e92, 0x82986b26, 0x986b2664, 0x64a2adf2, 40 }, /* #80 */
    { 0x2c3b43, 0x2c3b17, 0x4e709ea5, 0x2c1dfb50, 0x83bf6a0b, 91 }, /* #81 */
    { 0x323796, 0x323f92, 0xcfdef2e2, 0xf79711b0, 0x361bdb91, 43 }, /* #82 */
    { 0x3735c3, 0x373512, 0x4307e9e8, 0x60fd3d1f, 0xfc8d7fe5, 69 }, /* #83 */
    { 0x3f6e56, 0x3f6693, 0x50af1f87, 0xc3ac9f80, 0x593f0173, 119 }, /* #84 */
    { 0x180c47, 0x180497, 0xb7a9f9bc, 0xe7c25718, 0xf84ae304, 123 }, /* #85 */
    { 0x2e3246, 0x2e3297, 0x7a660fbb, 0xd3307dde, 0xc292fcc4,  3 }, /* #86 */
    { 0x1537c3, 0x153793, 0x0d136cde, 0xbc6ca0d3, 0x36506986, 25 }, /* #87 */
    { 0x2f4542, 0x2f4d96, 0x593f9076, 0xc9fc83b2, 0x5c2560c0,  3 }, /* #88 */
    { 0x3a79c6, 0x3a7112, 0x6790452f, 0x452f30ae, 0x30ae24f3, 80 }, /* #89 */
    { 0x043242, 0x043216, 0x2349e2d3, 0x60f957b2, 0x07cabd92, 61 }, /* #90 */
    { 0x216c87, 0x216c17, 0x1b7a0550, 0x439fcb55, 0xe7f2d547, 90 }, /* #91 */
    { 0x2e4692, 0x2e4e96, 0x00b6618d, 0xcc31a8b7, 0x45be7058, 45 }, /* #92 */
    { 0x383b46, 0x383b92, 0x9583434d, 0xac1a1a6e, 0xdcb77f43, 67 }, /* #93 */
    { 0x081957, 0x081193, 0x3fff8ec9, 0xf1d9245e, 0x22f74ef2, 77 }, /* #94 */
    { 0x191542, 0x191516, 0x16162b22, 0x5858ac8b, 0xc969d082, 34 }, /* #95 */
    { 0x033992, 0x033913, 0xa6d3f491, 0x23cabb20, 0xe55d9054, 57 }, /* #96 */
    { 0x2b6813, 0x2b6097, 0x45ff631e, 0x8f40e235, 0x81c46a79, 87 }, /* #97 */
    { 0x292842, 0x292892, 0xf4dc659e, 0xf38c9d20, 0x7193a402, 59 }, /* #98 */
    { 0x174806, 0x174813, 0x5b3b3cba, 0x59c200c4, 0xce100621, 61 }, /* #99 */
    { 0x284913, 0x284917, 0x7bea9077, 0x483bf259, 0xe4b2b42f, 79 }, /* #100 */
    { 0x1725c2, 0x1725c2, 0x2639d673, 0x2639d673, 0x1f2e2ba0, 32 }, /* #101 */
    { 0x215957, 0x215957, 0xee0bae44, 0xee0bae44, 0x80de2acd,  0 }, /* #102 */
    { 0x3f1387, 0x3f1b13, 0xaaa2b918, 0x5515c8c1, 0x21260d59, 99 }, /* #103 */
    { 0x0614c6, 0x061412, 0x1e400e0b, 0x3c801c16, 0x7f5a03b0, 33 }, /* #104 */
    { 0x333e42, 0x333e13, 0x70d1a19e, 0x0964e2f7, 0x12c9c5ef, 95 }, /* #105 */
    { 0x394413, 0x394c13, 0x9a6c7c4f, 0x3f2154d0, 0xc8553416, 122 }, /* #106 */
    { 0x192116, 0x192193, 0x8d267e91, 0xd23b47f1, 0xda3f8929, 53 }, /* #107 */
    { 0x1d4907, 0x1d4197, 0xb02720e7, 0x8139073c, 0x98e15737, 35 }, /* #108 */
    { 0x255fc2, 0x255716, 0x48b996cc, 0x5b33416c, 0xd05b2f8d, 50 }, /* #109 */
    { 0x0d1902, 0x0d1116, 0xbbc0bd0f, 0x1fd578c6, 0xeabc6342, 121 }, /* #110 */
    { 0x217806, 0x217016, 0xa0d9186f, 0x36461bf3, 0xccd33042, 38 }, /* #111 */
    { 0x0f0b46, 0x0f0b92, 0x1974d88c, 0xd88c4634, 0x4634dc62, 112 }, /* #112 */
    { 0x194882, 0x194097, 0x45fb0abd, 0xe923f00a, 0x247e015c, 59 }, /* #113 */
    { 0x227317, 0x227393, 0xac0fd56e, 0xa0e14fd6, 0x83853f5b, 126 }, /* #114 */
    { 0x3e6c53, 0x3e6c92, 0x1f95ab55, 0xb56ab364, 0x9b238a79, 45 }, /* #115 */
    { 0x374093, 0x374012, 0xc3861c4e, 0x3861c4e9, 0x99ac6784, 68 }, /* #116 */
    { 0x321386, 0x321312, 0x2f3d9aca, 0x55abebe6, 0xb57d7cd4, 59 }, /* #117 */
    { 0x2b4196, 0x2b4112, 0x0b341ef7, 0x7bdf2b73, 0xcadcefe0, 50 }, /* #118 */
    { 0x045e17, 0x045693, 0x27c71f52, 0xea403b2a, 0x01d954e5, 85 }, /* #119 */
    { 0x011047, 0x011097, 0xa75b78ff, 0xfe664c18, 0xe664c188, 60 }, /* #120 */
    { 0x1a78d3, 0x1a7097, 0x2305ebc0, 0xaf0166e2, 0x59b89c36, 82 }, /* #121 */
    { 0x156606, 0x156e17, 0xf6f0b738, 0x0eb19b36, 0x758cd9b5, 93 }, /* #122 */
    { 0x304e12, 0x304697, 0x5fdf77d1, 0xfdf77d14, 0x48334ab0,  4 }, /* #123 */
    { 0x295287, 0x295297, 0xd3aacb9b, 0x9737e43a, 0xf21d5806, 113 }, /* #124 */
    { 0x176242, 0x176a92, 0x34876727, 0x90ece4f4, 0xa5856d35, 37 }, /* #125 */
    { 0x026857, 0x026097, 0x3111edae, 0xb6b8402d, 0x100b7480, 18 }, /* #126 */
    { 0x373452, 0x373c13, 0x6e8d8598, 0x66034f75, 0x0d3dd608, 86 }, /* #127 */
};
uint32_t const g_cTests_shld_u32_amd = RT_ELEMENTS(g_aTests_shld_u32_amd);

BINU32_TEST_T const g_aTests_shrd_u32_amd[] =
{
    { 0x0d4f16, 0x0d4756, 0x00000000, 0x00000000, 0x00000000,  4 }, /* #0 */
    { 0x024313, 0x024356, 0x00000000, 0x00000000, 0x00000000, 45 }, /* #1 */
    { 0x2b2fd7, 0x2b2756, 0x00000000, 0x00000000, 0x00000000, 101 }, /* #2 */
    { 0x386646, 0x386656, 0x00000000, 0x00000000, 0x00000000, 79 }, /* #3 */
    { 0x037716, 0x037756, 0x00000000, 0x00000000, 0x00000000, 101 }, /* #4 */
    { 0x304b56, 0x304356, 0x00000000, 0x00000000, 0x00000000, 61 }, /* #5 */
    { 0x3b6a97, 0x3b6217, 0x2c546bd8, 0x02c546bd, 0x00000000, 36 }, /* #6 */
    { 0x0d3543, 0x0d3517, 0x04eb7789, 0x004eb778, 0x00000000, 100 }, /* #7 */
    { 0x2c3cd3, 0x2c3416, 0x768f0811, 0x0768f081, 0x00000000, 68 }, /* #8 */
    { 0x095282, 0x095212, 0x8ee319e2, 0x08ee319e, 0x00000000, 100 }, /* #9 */
    { 0x347d03, 0x347512, 0x300e4f31, 0x0000300e, 0x00000000, 112 }, /* #10 */
    { 0x1c7c87, 0x1c7416, 0xaa0893b4, 0x0002a822, 0x00000000, 78 }, /* #11 */
    { 0x345e17, 0x345e93, 0x4a4cb9ce, 0x8aa4a4cb, 0x733a88aa, 44 }, /* #12 */
    { 0x2a3a92, 0x2a3a12, 0x98ab7976, 0x7498ab79, 0x21b35f74, 72 }, /* #13 */
    { 0x0f1503, 0x0f1516, 0x5aec934c, 0x365aec93, 0x21ba9136, 104 }, /* #14 */
    { 0x270843, 0x270897, 0xdb6b1fc3, 0xaf9350c6, 0x95f26a18, 61 }, /* #15 */
    { 0x1d7692, 0x1d7697, 0x51dd328d, 0xf87c28ee, 0x1121f0f8, 17 }, /* #16 */
    { 0x1c7413, 0x1c7497, 0xe1e5ec9b, 0xf0f2f64d, 0x7e10c57f,  1 }, /* #17 */
    { 0x074956, 0x074997, 0x0df336fd, 0xa20306f9, 0xda9f4406, 17 }, /* #18 */
    { 0x1c5c86, 0x1c5497, 0xc71c57c1, 0xc6638e2b, 0x15c5438c,  9 }, /* #19 */
    { 0x3b5806, 0x3b5016, 0xb2da58ab, 0x39e6faeb, 0x9cf37d75, 127 }, /* #20 */
    { 0x2d1e96, 0x2d1e93, 0x378ef3e7, 0x981bc779, 0x4a2edf30,  9 }, /* #21 */
    { 0x276303, 0x276392, 0xf2b133d7, 0xfc28241f, 0x8fc28241, 124 }, /* #22 */
    { 0x0809c6, 0x080196, 0x93c39428, 0xe4f0e50a, 0xcd33d83b, 66 }, /* #23 */
    { 0x1a0156, 0x1a0116, 0x4260c222, 0x284c1844, 0xde696839, 99 }, /* #24 */
    { 0x352c87, 0x352c13, 0xf3c8129a, 0x5f3c8129, 0x143d5705, 36 }, /* #25 */
    { 0x0d1857, 0x0d1897, 0xc2542b88, 0x9c2542b8, 0x23f5eee9, 68 }, /* #26 */
    { 0x123e43, 0x123e13, 0xec12f347, 0x7c6ffb04, 0x1021f1bf, 50 }, /* #27 */
    { 0x2e3687, 0x2e3e16, 0x6747b0f3, 0x67e6747b, 0x13b2567e, 76 }, /* #28 */
    { 0x273a82, 0x273a92, 0xe73bfd3d, 0xb9ceff4f, 0x936ec3ea, 98 }, /* #29 */
    { 0x161552, 0x161512, 0x90114fb9, 0x1205d920, 0xe08902ec, 119 }, /* #30 */
    { 0x1f6a06, 0x1f6292, 0x41bf527b, 0xdf00abd5, 0x37c02af5, 62 }, /* #31 */
    { 0x326452, 0x326497, 0x0e5ffc58, 0xf5ff98e1, 0x3faffcc7, 123 }, /* #32 */
    { 0x2c2456, 0x2c2496, 0x3c6359e0, 0xc9e31acf, 0x9ea1a019,  5 }, /* #33 */
    { 0x1a59d6, 0x1a5116, 0x7795adb3, 0x3bf001b7, 0x43bf001b, 124 }, /* #34 */
    { 0x1a5b12, 0x1a5b92, 0x442620eb, 0x9da3a0a2, 0x233b4741, 121 }, /* #35 */
    { 0x2b2e47, 0x2b2e16, 0xdb3515dd, 0x6e1fdb35, 0x7a2e6e1f, 16 }, /* #36 */
    { 0x395f57, 0x395f17, 0xc7777bd1, 0x68af1ddd, 0xf561da2b, 110 }, /* #37 */
    { 0x0333c6, 0x033397, 0x3b99d00f, 0xcaa9d68e, 0x6f2aa75a, 58 }, /* #38 */
    { 0x2d5307, 0x2d5396, 0x98edd5e7, 0xf5ea63b7, 0x26763d7a, 110 }, /* #39 */
    { 0x0d7383, 0x0d7392, 0x872dc8ba, 0xe090e5b9, 0x8ed52f04, 11 }, /* #40 */
    { 0x0e4156, 0x0e4117, 0x25b88ce4, 0x04b7119c, 0x772a00e8, 35 }, /* #41 */
    { 0x307e07, 0x307617, 0x0abd4de1, 0x20a8e055, 0xd244151c, 117 }, /* #42 */
    { 0x1a6996, 0x1a6197, 0x4f11d0fe, 0xfc404f11, 0x5aaffc40, 112 }, /* #43 */
    { 0x152243, 0x152212, 0xc2921b14, 0x06385243, 0x862fe031, 11 }, /* #44 */
    { 0x293e53, 0x293693, 0x21d885e9, 0xe21d885e, 0x4e3fb62e, 36 }, /* #45 */
    { 0x3f5a82, 0x3f5297, 0x986a6661, 0xcf2f4130, 0xb16797a0, 55 }, /* #46 */
    { 0x1f2087, 0x1f2013, 0xc3639d2a, 0x11e1b1ce, 0xc0e33223, 73 }, /* #47 */
    { 0x1e0357, 0x1e0b93, 0x5df5af49, 0xa0bbeb5e, 0xacc711d0, 39 }, /* #48 */
    { 0x343852, 0x343813, 0x923b67bf, 0x52476cf7, 0xfa1835f2, 67 }, /* #49 */
    { 0x032e16, 0x032e17, 0xda99dbfc, 0x57b9b533, 0xeb39abdc, 47 }, /* #50 */
    { 0x122fc2, 0x122793, 0x1e47c533, 0xe3d00f23, 0x39e3c7a0, 17 }, /* #51 */
    { 0x060a06, 0x060a93, 0xfb519e2b, 0xad9d6137, 0xab67584d, 126 }, /* #52 */
    { 0x1f2242, 0x1f2213, 0xd9c45fdb, 0x0e7d9c45, 0xab7150e7, 76 }, /* #53 */
    { 0x3d7c82, 0x3d7c13, 0x7bb8f194, 0x55f8d602, 0xaafc6b01, 31 }, /* #54 */
    { 0x0d5f07, 0x0d5f16, 0x97d9c7ab, 0x6b0f6272, 0x5ac3d89c, 126 }, /* #55 */
    { 0x1f0992, 0x1f0913, 0xb148b6d5, 0x562916da, 0x1cdb733a, 35 }, /* #56 */
    { 0x3a5807, 0x3a5016, 0x9bb3a34c, 0x0c99bb3a, 0xaea5e0c9, 12 }, /* #57 */
    { 0x3e7602, 0x3e7693, 0xb090ef1d, 0xda138e9d, 0xfb4271d3, 93 }, /* #58 */
    { 0x2f0f97, 0x2f0796, 0x3ac3f4aa, 0xee9d61fa, 0x16f403dd,  9 }, /* #59 */
    { 0x1e0b86, 0x1e0b17, 0x29598d53, 0x595a2959, 0xb64d595a, 16 }, /* #60 */
    { 0x300f17, 0x300f17, 0xc7f72437, 0x63fb921b, 0x726abbca, 33 }, /* #61 */
    { 0x044646, 0x044693, 0xd6234bbf, 0xe83e7e7a, 0x2741f3f3, 123 }, /* #62 */
    { 0x124613, 0x124e17, 0x6789afac, 0x7b6789af, 0x006c597b, 72 }, /* #63 */
    { 0x1178c2, 0x117817, 0x6f913246, 0x57baa0f6, 0x257baa0f, 92 }, /* #64 */
    { 0x3c1a12, 0x3c1213, 0x83692e08, 0x1cb83692, 0xae4d31cb, 44 }, /* #65 */
    { 0x3d0297, 0x3d0297, 0x77fcef4e, 0xc3276c77, 0xbec3276c, 120 }, /* #66 */
    { 0x1b2216, 0x1b2293, 0xdfe53e4d, 0xd75065f7, 0x035d4197, 58 }, /* #67 */
    { 0x123ed2, 0x123e92, 0x8799d20f, 0xaaf8799d, 0xc3addaaf, 12 }, /* #68 */
    { 0x3c6852, 0x3c6013, 0xe32c9de0, 0x18c43ffb, 0x46310ffe, 126 }, /* #69 */
    { 0x1464c7, 0x146c93, 0xee3984e2, 0x9491f71c, 0x82432923, 81 }, /* #70 */
    { 0x0473c3, 0x047b92, 0xc4a7d705, 0xac5d3625, 0x67158ba6, 85 }, /* #71 */
    { 0x142e97, 0x142616, 0x4c492607, 0x14c49260, 0x165fbcb1, 68 }, /* #72 */
    { 0x334406, 0x334c13, 0x0db89d11, 0x69f9c401, 0x934fce20, 27 }, /* #73 */
    { 0x093587, 0x093596, 0xd4f6a051, 0xe5d45af5, 0x4b97516b, 58 }, /* #74 */
    { 0x3706c2, 0x370e13, 0xd29c5585, 0x7245a538, 0x55b2b922, 79 }, /* #75 */
    { 0x3824d3, 0x382413, 0xa094f37d, 0x1a094f37, 0x52fda441, 36 }, /* #76 */
    { 0x135886, 0x135092, 0x1c2c628f, 0xf5931e38, 0x65fac98f, 23 }, /* #77 */
    { 0x362d07, 0x362516, 0xf3485ba4, 0x3be690b7, 0x9378a71d, 103 }, /* #78 */
    { 0x3f0fd7, 0x3f0793, 0xf5fe91b4, 0xc7d7fa46, 0xdc0ffcf1, 38 }, /* #79 */
    { 0x3a1696, 0x3a1e13, 0xd7bebb6d, 0x63c39af7, 0x2b031e1c, 83 }, /* #80 */
    { 0x121106, 0x121997, 0x346364db, 0xa02ecd18, 0x297280bb, 18 }, /* #81 */
    { 0x265a02, 0x265a97, 0x85e6f328, 0xacbd5e50, 0xfd65eaf2, 91 }, /* #82 */
    { 0x0c01d2, 0x0c0993, 0x66a149f6, 0x9bfba875, 0xe6feea1d, 62 }, /* #83 */
    { 0x0f3607, 0x0f3617, 0xdbede9b3, 0x089f518d, 0x6089f518, 92 }, /* #84 */
    { 0x1b0a57, 0x1b0217, 0xd703df2b, 0x22f6b5c0, 0xbf308bda, 114 }, /* #85 */
    { 0x197d52, 0x197513, 0x470defd7, 0x3f7d1c37, 0x63fd0fdf, 110 }, /* #86 */
    { 0x3a5493, 0x3a5c13, 0x1bc6b854, 0x58de35c2, 0x536fa10b, 37 }, /* #87 */
    { 0x131512, 0x131592, 0x475f82f2, 0xf8e02794, 0x8f8e0279, 60 }, /* #88 */
    { 0x1c2446, 0x1c2416, 0x39a50ee1, 0x3f35839a, 0x8373f358, 52 }, /* #89 */
    { 0x0c5083, 0x0c5013, 0x7f3b78fd, 0x35a6bf9d, 0x59846b4d, 81 }, /* #90 */
    { 0x313802, 0x313897, 0x00a99e85, 0x8054cf42, 0xffe64eed, 97 }, /* #91 */
    { 0x373b53, 0x373312, 0xa2f38fa5, 0x318e8bce, 0xa45bcc63, 14 }, /* #92 */
    { 0x2f4847, 0x2f4847, 0xc5bc9ff9, 0xc5bc9ff9, 0xa2aab833, 96 }, /* #93 */
    { 0x0f6fc6, 0x0f6f97, 0xad7b06b1, 0x9ead7b06, 0x27f4869e, 72 }, /* #94 */
    { 0x1a7e53, 0x1a7e17, 0x9076ce7e, 0x720ed9cf, 0x27eebaa3, 35 }, /* #95 */
    { 0x346bc3, 0x346316, 0x57cee7cd, 0x38622be7, 0x10d470c4, 81 }, /* #96 */
    { 0x046703, 0x046f93, 0x19069797, 0xb0c834bc, 0x7fca4756, 37 }, /* #97 */
    { 0x094dc2, 0x094597, 0x596d5529, 0xc8927565, 0x58f2249d, 54 }, /* #98 */
    { 0x060e92, 0x060617, 0x34eeec6a, 0x3e69ddd8, 0xb1e35f1f, 39 }, /* #99 */
    { 0x1b6953, 0x1b6117, 0x12ea2c87, 0x117d9812, 0x4c117d98, 88 }, /* #100 */
    { 0x120e97, 0x120e96, 0xcbfc0557, 0xbacbfc05, 0x0ec2b9ba, 104 }, /* #101 */
    { 0x120783, 0x120797, 0x26f5a049, 0xc9adc4de, 0x47ee4d6e, 83 }, /* #102 */
    { 0x206046, 0x206897, 0xf4a5a5b8, 0x8c3b73d2, 0x27230edc, 22 }, /* #103 */
    { 0x2c3793, 0x2c3716, 0x3789dc99, 0x0f1bc4ee, 0x7bf1fe1e, 41 }, /* #104 */
    { 0x356957, 0x356917, 0x1dac100a, 0x5130911d, 0x4b513091, 56 }, /* #105 */
    { 0x0d46d6, 0x0d4697, 0x75038f1e, 0xf2a45709, 0x3ca915c2, 126 }, /* #106 */
    { 0x2d3652, 0x2d3e92, 0x71d17bd7, 0x85c745ef, 0x70199aa1,  6 }, /* #107 */
    { 0x375d52, 0x375d17, 0xf7634e6d, 0x6afeec69, 0x18b21357, 107 }, /* #108 */
    { 0x3f0243, 0x3f0a93, 0x59cad731, 0xace56b98, 0x93f5df31, 65 }, /* #109 */
    { 0x167ed6, 0x167e17, 0x1af414d4, 0x435e829a, 0x0e8398f2, 35 }, /* #110 */
    { 0x292b13, 0x292392, 0x88a09a02, 0xf8f47445, 0xa7df1e8e, 21 }, /* #111 */
    { 0x2a0ec3, 0x2a0e96, 0x2a4adc1d, 0x9bca92b7, 0x18b92a6f, 106 }, /* #112 */
    { 0x233c12, 0x233416, 0x15dabc74, 0x2e2a3ed4, 0x8b8a8fb5, 126 }, /* #113 */
    { 0x126e56, 0x126613, 0x841ce7e4, 0x2bd8841c, 0x85bc2bd8, 16 }, /* #114 */
    { 0x332597, 0x332512, 0xf546b1ef, 0x2f74f3d5, 0xb44bdd3c, 118 }, /* #115 */
    { 0x136006, 0x136817, 0x9a5ac8de, 0x69a5ac8d, 0xbe397456,  4 }, /* #116 */
    { 0x055416, 0x055c16, 0x315bc651, 0x4fd98ade, 0x403929fb, 45 }, /* #117 */
    { 0x180587, 0x180d17, 0xeb9d41b3, 0x446523eb, 0x61446523, 56 }, /* #118 */
    { 0x1a7b92, 0x1a7b17, 0x1c711da7, 0x6c38e388, 0x0651cd87, 109 }, /* #119 */
    { 0x112d57, 0x112516, 0x25c193a2, 0x3a4df25c, 0x47c3a4df, 116 }, /* #120 */
    { 0x382f17, 0x382f96, 0xc8e374e0, 0xa1c455f9, 0xcd0e22af, 91 }, /* #121 */
    { 0x2b6a93, 0x2b6a12, 0x053f5031, 0x74e0a7ea, 0xbfa9c3a7, 107 }, /* #122 */
    { 0x096942, 0x096993, 0x23329067, 0x88cca419, 0x4ca66c3e, 66 }, /* #123 */
    { 0x1b0946, 0x1b0197, 0x2408372d, 0xeeb12041, 0x175e7dd6, 109 }, /* #124 */
    { 0x065947, 0x065917, 0x826c8bf7, 0x649cca09, 0x24592732, 22 }, /* #125 */
    { 0x0e5213, 0x0e5a97, 0x0678adc0, 0xb8dc8833, 0xdcd71b91, 53 }, /* #126 */
    { 0x2c1357, 0x2c1b17, 0x93a9577e, 0x578da3c9, 0xd2af1b47, 57 }, /* #127 */
};
uint32_t const g_cTests_shrd_u32_amd = RT_ELEMENTS(g_aTests_shrd_u32_amd);

BINU64_TEST_T const g_aTests_shld_u64_amd[] =
{
    { 0x010a16, 0x010256, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 165 }, /* #0 */
    { 0x211952, 0x211156, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 30 }, /* #1 */
    { 0x0c00d2, 0x0c0056, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 76 }, /* #2 */
    { 0x172983, 0x172156, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 222 }, /* #3 */
    { 0x1d0ed3, 0x1d0656, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 68 }, /* #4 */
    { 0x1f3d17, 0x1f3556, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 80 }, /* #5 */
    { 0x137f53, 0x137797, 0x6da48cc026140a1f, 0xf000000000000000, 0x0000000000000000, 124 }, /* #6 */
    { 0x3813d2, 0x381b96, 0x69a1bc616f250da0, 0xda00000000000000, 0x0000000000000000, 116 }, /* #7 */
    { 0x2b53c2, 0x2b5397, 0xc46526040dd1bb62, 0xbb62000000000000, 0x0000000000000000, 176 }, /* #8 */
    { 0x2c4f16, 0x2c4f17, 0x9e92ff694fd1eadf, 0x3d25fed29fa3d5be, 0x0000000000000000,  1 }, /* #9 */
    { 0x366517, 0x366516, 0x32b433cfe9ba016f, 0x02de000000000000, 0x0000000000000000, 113 }, /* #10 */
    { 0x333dd3, 0x333597, 0xb4469112fff51927, 0xa444bffd4649c000, 0x0000000000000000, 142 }, /* #11 */
    { 0x387603, 0x387693, 0xa0148f7194a7008a, 0xee3294e0115b111c, 0xd888e67425d5542b, 21 }, /* #12 */
    { 0x340582, 0x340516, 0x51e2817486b30073, 0x0ba43598039d4a6c, 0xa94d82c76da110ab, 211 }, /* #13 */
    { 0x0d21c6, 0x0d2992, 0xbe09be2b8263cbc8, 0xbc814c7ee9431a43, 0x14c7ee9431a439b2, 52 }, /* #14 */
    { 0x3866d3, 0x386612, 0xc82811140d44704a, 0x088a06a2382564b0, 0xc96144b4be793c3a, 15 }, /* #15 */
    { 0x016e53, 0x016616, 0x9619932ea1ba6c42, 0x19932ea1ba6c4284, 0x84c829a3e90dbc57, 200 }, /* #16 */
    { 0x012682, 0x012e92, 0x4a27db5fb0c6cb05, 0xd960a64c84547fd6, 0x326422a3feb36001, 45 }, /* #17 */
    { 0x006447, 0x006c13, 0x7868f8d2c6bf495b, 0x1f1a58d7e92b6a52, 0x529477bef3a7e0c0, 77 }, /* #18 */
    { 0x160b16, 0x160397, 0x5d2ea138d78501a3, 0xaf0a0346b4fc7d7b, 0x5a7e3ebda05a9353, 225 }, /* #19 */
    { 0x0a0102, 0x0a0112, 0x373f529d5449dd87, 0x755127761f29075b, 0xca41d6e8de48fe94, 154 }, /* #20 */
    { 0x354613, 0x354e92, 0x8b9c798495cb23d1, 0xc24ae591e8a01034, 0x402068e18dedefe4, 215 }, /* #21 */
    { 0x1f7903, 0x1f7913, 0xeb5f9e477adf8fe3, 0x7e3f8e0fba89d64a, 0x83eea27592905d90, 42 }, /* #22 */
    { 0x327893, 0x327093, 0xa5e64b76df65c5ed, 0xdab9e236ef64c8c8, 0x5cf11b77b264643d, 121 }, /* #23 */
    { 0x3c64c3, 0x3c6c92, 0xfb4145a85ec39842, 0xc398429ce115bfba, 0x9ce115bfba4457cf, 104 }, /* #24 */
    { 0x093703, 0x093712, 0x7d3c5c3736c30402, 0x1009a4a9af8d1729, 0x692a6be345ca5f1d, 50 }, /* #25 */
    { 0x0d3212, 0x0d3216, 0xc30b94d883d1da92, 0x53620f476a48cc06, 0x3301b82f2d59134b, 210 }, /* #26 */
    { 0x181f83, 0x181f96, 0x698a587254582f50, 0xc52c392a2c17a828, 0x50750645b9b4da7f, 71 }, /* #27 */
    { 0x195252, 0x195a96, 0xe52e17492b86e525, 0x95c37292e2ffc824, 0xc5ff904834faed84, 223 }, /* #28 */
    { 0x2c3d53, 0x2c3d96, 0x1efdb166e2edcb24, 0xd8b37176e5922b2e, 0x565cb19ce189af6f, 15 }, /* #29 */
    { 0x042cc7, 0x042c13, 0xd6709b5b73accf96, 0x3e5bd0ea02beeb9d, 0xf43a80afbae77edf, 242 }, /* #30 */
    { 0x230492, 0x230c17, 0x4950b2b6989c7b05, 0x2542cada6271ec14, 0x12d326e1d104cf81, 66 }, /* #31 */
    { 0x1117d7, 0x111f13, 0xa135ed7c3c87579b, 0x7c3c87579bce041a, 0xce041a58db7a99c0, 152 }, /* #32 */
    { 0x3c3553, 0x3c3d13, 0x148e218202aca525, 0x1c430405594a4ae5, 0x72c52aa9bf39e858, 73 }, /* #33 */
    { 0x3b1152, 0x3b1992, 0x1d1f12b046f66fb2, 0xfb217711762e303e, 0x17711762e303efbf, 244 }, /* #34 */
    { 0x041606, 0x041612, 0x0d641d16e3571ef2, 0x5b8d5c7bca11a1a1, 0x8468685ca7b1b70b, 26 }, /* #35 */
    { 0x162196, 0x162913, 0x9e718085b012bde6, 0x5ef335c93042d6d6, 0x6b926085adaccc33, 239 }, /* #36 */
    { 0x3f5587, 0x3f5d96, 0x53e98cc4b84851aa, 0xa7d319897090a355, 0x973871bf4a18a212, 129 }, /* #37 */
    { 0x204616, 0x204e92, 0xf1e74d511c596644, 0x89b5152536110a34, 0xda8a929b08851a6f, 185 }, /* #38 */
    { 0x3a6006, 0x3a6896, 0x6b5ea6551ad16d4c, 0xb6a653462183097d, 0xa68c430612fa2cb1, 175 }, /* #39 */
    { 0x100146, 0x100996, 0xb7135b5b70575af0, 0xd78089e1be7cbe96, 0x113c37cf97d2cf9c, 179 }, /* #40 */
    { 0x0e6cc6, 0x0e6497, 0xe25fdb4893e51e1d, 0xe1d26a14247c3356, 0x26a14247c3356599, 244 }, /* #41 */
    { 0x2d67d7, 0x2d6f13, 0x46d56f77a5861908, 0x77a5861908288f02, 0x288f02f12688f122, 216 }, /* #42 */
    { 0x033e57, 0x033e57, 0x39f37909c07bb626, 0x39f37909c07bb626, 0xfcc668579f8f5b98, 192 }, /* #43 */
    { 0x0f1217, 0x0f1a96, 0x08780b7366c1c028, 0xcd838051ddb40695, 0xeeda034ac137af5d, 33 }, /* #44 */
    { 0x2c2496, 0x2c2497, 0xb21596739eab1593, 0x96739eab15934521, 0x45213639274871b5, 208 }, /* #45 */
    { 0x1f3253, 0x1f3212, 0x68a4df5f50348764, 0x3487644c9470b720, 0x4c9470b72044ead1, 168 }, /* #46 */
    { 0x144bc7, 0x144b96, 0xd7c7a86cd23cb74b, 0xd9a4796e9769e3c9, 0xb4f1e4f235027779, 217 }, /* #47 */
    { 0x055296, 0x055a92, 0x2f27ec9ce838e498, 0xe838e498c9381e5e, 0xc9381e5e661f2ec7, 224 }, /* #48 */
    { 0x2b71d3, 0x2b7197, 0x4aac617f317e0d8f, 0x8bf06c785f7fbee1, 0x0beff7dc3b34de52, 163 }, /* #49 */
    { 0x0a27c3, 0x0a2f17, 0xc182405f503a0494, 0x202fa81d024a56e8, 0xadd0edf0ce501dbf, 15 }, /* #50 */
    { 0x3f2b16, 0x3f2b92, 0xff21c2fb2f256176, 0xc2eca700d74e0310, 0x53806ba701882df2, 241 }, /* #51 */
    { 0x335f52, 0x335797, 0x342243a0334cc13b, 0xd9317b9af5ac2ec0, 0x262f735eb585d81d, 187 }, /* #52 */
    { 0x135c46, 0x135c17, 0x52ffadb005242b09, 0x490ac240eb092703, 0x03ac249c0fe4078e, 166 }, /* #53 */
    { 0x3d78c7, 0x3d7093, 0xe7f083f3f3ce38c2, 0x9c7185443e98753e, 0xa21f4c3a9f66fbd4, 41 }, /* #54 */
    { 0x200983, 0x200913, 0x06b831a33b58db95, 0x506350b2be6c2e89, 0x06350b2be6c2e89a, 60 }, /* #55 */
    { 0x3a4642, 0x3a4e13, 0xe474fff906e50c0b, 0x4fff906e50c0b631, 0x631507cdbd514721, 140 }, /* #56 */
    { 0x373f97, 0x373797, 0x613390521c7a4c7c, 0xf3064a48d10120a5, 0xc192923440482959, 186 }, /* #57 */
    { 0x085f02, 0x085793, 0xc8631030d3d50d67, 0xacfd1254c553f77c, 0xe892a62a9fbbe470, 53 }, /* #58 */
    { 0x262e03, 0x262697, 0x3ae811e892a146ad, 0xe892a146add0a222, 0xd0a2223b59efd562, 216 }, /* #59 */
    { 0x105006, 0x105813, 0x8ae6e61f1d88f65f, 0x65fa2dac5003d0e0, 0xa2dac5003d0e02d0, 180 }, /* #60 */
    { 0x1640c6, 0x164012, 0x6f774603257eeb03, 0x064afdd606f4a21c, 0x7a510e503f95a820, 25 }, /* #61 */
    { 0x185552, 0x185d13, 0xaac62add8b935b2e, 0x156ec5c9ad974a51, 0x94a2c86a3828291b, 143 }, /* #62 */
    { 0x242fd7, 0x242716, 0x61dd526ee05ca32e, 0x05ca32e9adafaf28, 0x9adafaf2894ee5f4, 164 }, /* #63 */
    { 0x156383, 0x156b13, 0xb91bb99d1b8214ae, 0x5da8a6f03f166e61, 0xd453781f8b373089, 121 }, /* #64 */
    { 0x0c2c96, 0x0c2497, 0xe41d4167cd564193, 0x9aac832613423e4e, 0x09a11f277cb1048a, 97 }, /* #65 */
    { 0x1b6b43, 0x1b6b92, 0x02e2914416a944c7, 0xa944c7bb6d4f4ba8, 0xbb6d4f4ba8af08d6, 104 }, /* #66 */
    { 0x214382, 0x214b17, 0xc8ef1c744c72dc92, 0x1d131cb72487ec3a, 0x1fb0e8a3ca350841, 150 }, /* #67 */
    { 0x2d16c6, 0x2d1e96, 0x7237f284fdb9de5d, 0xe46fe509fb73bcbb, 0xbcfb5eb6b712f2b1,  1 }, /* #68 */
    { 0x026183, 0x026116, 0x58543a0676e39909, 0x76e39909e0a73aeb, 0xe0a73aeb81ad6c64, 224 }, /* #69 */
    { 0x306092, 0x306097, 0x44ae2ae9905bf2fe, 0xf97f4abef3c36341, 0x957de786c6834a39, 111 }, /* #70 */
    { 0x130653, 0x130e13, 0x1e89980da04e8d41, 0x46a0f1a44168edae, 0xe34882d1db5dadf8, 111 }, /* #71 */
    { 0x001e97, 0x001e96, 0x97fb0574de6b5296, 0xd4a5b12afb669848, 0xc4abed9a61230ef8, 174 }, /* #72 */
    { 0x337e97, 0x337e17, 0x14b93c92c6595c47, 0x2b88f0e981b731a6, 0x874c0db98d37c0b2, 109 }, /* #73 */
    { 0x100d43, 0x100d17, 0xdaba73cf7d7270b1, 0x7270b1b2bd13d947, 0xb2bd13d947094992, 104 }, /* #74 */
    { 0x3c0497, 0x3c0c13, 0x970064deb26d1317, 0x31772d3ccd95ade3, 0x72d3ccd95ade369e, 116 }, /* #75 */
    { 0x0d2ad6, 0x0d2a17, 0xb8712ad5090d0f72, 0x5090d0f72b4234e8, 0xb4234e890db343b9, 28 }, /* #76 */
    { 0x2925d3, 0x292d17, 0x3f11d28ed605e9ea, 0x7a7ab51ecb35aac5, 0xd47b2cd6ab1688fb, 238 }, /* #77 */
    { 0x1e7bc6, 0x1e7b96, 0x785cb1a1ab586535, 0xf0b9634356b0ca6a, 0x2becbb2a0d91fec3, 193 }, /* #78 */
    { 0x116f42, 0x116f13, 0x97ce98b525fd492a, 0x7f524abebc63544f, 0xfaf18d513c8bc01c, 230 }, /* #79 */
    { 0x0c5942, 0x0c5193, 0x6cafbdefc37fcb03, 0xbdefc37fcb03268f, 0x268fd39a85decda8, 16 }, /* #80 */
    { 0x103a17, 0x103a92, 0x80702c46a2aae05d, 0xb8176fa7da29211a, 0xbe9f68a4846ac8b7, 238 }, /* #81 */
    { 0x060442, 0x060412, 0xdd162fc55c572464, 0x2fc55c5724646b37, 0x6b370eea5b9a3d6e, 208 }, /* #82 */
    { 0x014412, 0x014497, 0xa76ee1c8699e2a9c, 0xc390d33c553812a9, 0x0954d683e0a94685, 17 }, /* #83 */
    { 0x1e7596, 0x1e7597, 0xfc3a7fa09817b43e, 0xeb413a095e491211, 0xb413a095e4912117, 188 }, /* #84 */
    { 0x2e2893, 0x2e2813, 0xf75567fed6bf838c, 0x567fed6bf838ccef, 0xcefcd8db481e91e7, 140 }, /* #85 */
    { 0x3474c7, 0x347c17, 0x1151d1b245e71a02, 0x151d1b245e71a024, 0x449bf38c529e0600, 132 }, /* #86 */
    { 0x0c5192, 0x0c5193, 0xda743a5fbcbeebf1, 0xafc5ee251ce81291, 0x7b89473a04a4408a, 50 }, /* #87 */
    { 0x1b1cc7, 0x1b1cc7, 0xac8757a6fb0692ab, 0xac8757a6fb0692ab, 0xc84fae7ba98b8af4, 128 }, /* #88 */
    { 0x347e87, 0x347616, 0x8429169274fa3a43, 0x4340ce8a59a588ee, 0x40ce8a59a588ee33, 120 }, /* #89 */
    { 0x0912c2, 0x091a92, 0x0baa996d3a422194, 0xa996d3a422194bd6, 0xbd6f18daad3ee9ea, 140 }, /* #90 */
    { 0x331bd7, 0x331393, 0x390e0e0b1a7bd9a5, 0xbd9a52288135a09b, 0x2288135a09bc3244, 108 }, /* #91 */
    { 0x036986, 0x036992, 0xbd8edd9421c67afa, 0xf5f4b7dc4165dcea, 0x5bee20b2ee755ff2, 113 }, /* #92 */
    { 0x0d1e83, 0x0d1697, 0x3d431d669f29fb91, 0xfb91dc2ab51dc13f, 0xdc2ab51dc13f32f6, 48 }, /* #93 */
    { 0x1a2ac2, 0x1a2a13, 0x6945c9f9af424aef, 0x7cf3a3be7f267983, 0x9e7477cfe4cf306d, 123 }, /* #94 */
    { 0x005507, 0x005516, 0x55bb5fc49d908662, 0x4ec84331611b3c1d, 0xc236783b408c68d5, 159 }, /* #95 */
    { 0x211082, 0x211016, 0xcb4d4d644ccc950c, 0x5a6a6b226664a863, 0x62ce34ba401406db,  3 }, /* #96 */
    { 0x0c6bd2, 0x0c6393, 0xf9208f6207d61972, 0xc9cff7ed922296a4, 0x73fdfb6488a5a90e, 186 }, /* #97 */
    { 0x283292, 0x283216, 0xa19e1fda8352360f, 0x3fb506a46c1f8c4d, 0xc6268586d43d5347, 145 }, /* #98 */
    { 0x172b13, 0x172b92, 0x9724578b8fccee1b, 0xee1ba6492e3612ef, 0xa6492e3612ef728b, 176 }, /* #99 */
    { 0x351407, 0x351c96, 0x8d43f300f4f81d2e, 0xe4e2f928e2806aca, 0x4e2f928e2806aca1, 188 }, /* #100 */
    { 0x397183, 0x397116, 0xe4c19245fb6081e0, 0x4917ed8207833f88, 0xcfe20bcb206a02dd, 146 }, /* #101 */
    { 0x016ed2, 0x016693, 0xcf7357cd30a5b68a, 0x852db45327030754, 0x64e060ea9d895ba7, 99 }, /* #102 */
    { 0x1121d6, 0x112116, 0xc911392d56ce680d, 0x725aad9cd01b2aca, 0x956576f349c0ded5, 81 }, /* #103 */
    { 0x152497, 0x152497, 0xa3902edc3728bb92, 0xc94f2d4eef677a50, 0x9e5a9ddecef4a095, 55 }, /* #104 */
    { 0x102886, 0x102016, 0x4f80d30f7dde548c, 0x0d30f7dde548c711, 0x7117417d52a0a690, 140 }, /* #105 */
    { 0x1927d3, 0x192f13, 0x782219d08285380a, 0x429c053ad0602f43, 0x75a0c05e86cce44e, 167 }, /* #106 */
    { 0x375b57, 0x375b17, 0xadcdf81b5295929f, 0x37e06d4a564a7c96, 0x25b517e0ad5bcc1b, 74 }, /* #107 */
    { 0x051657, 0x051612, 0x7cda554fc0858108, 0x04224551da35885b, 0x9154768d6216f592, 178 }, /* #108 */
    { 0x303a12, 0x303293, 0xb6685e044c7e4704, 0x81131f91c10f0361, 0x3c0d850ffdf47483, 150 }, /* #109 */
    { 0x0f5c02, 0x0f5497, 0xbcd8cc9327f52dee, 0xf52dee2154d470bd, 0x2154d470bd5ee61a, 40 }, /* #110 */
    { 0x3f4102, 0x3f4917, 0xd459afc234e2c68e, 0x47248cd7758610f9, 0x4919aeeb0c21f3fe, 247 }, /* #111 */
    { 0x335a13, 0x335a13, 0x20bd38ffe9287b65, 0x4943db28542704ef, 0x0a84e09de6e8fe23, 163 }, /* #112 */
    { 0x065a52, 0x065a96, 0x6dcad3c1da157825, 0x94a51c45647c50ed, 0x294711591f143b63, 58 }, /* #113 */
    { 0x2976c7, 0x297612, 0x9b549ae162b508cc, 0x38b58c9ac7c21be5, 0x716b19358f8437cb, 191 }, /* #114 */
    { 0x017353, 0x017397, 0x293e9257134e0d1b, 0xa7068de59b29e665, 0xcb3653cccaf9a2e8, 167 }, /* #115 */
    { 0x0d46d3, 0x0d4616, 0x299b74bc6102c401, 0x66dd2f1840b10071, 0xc6d7ac1c5d0d18ce, 198 }, /* #116 */
    { 0x154793, 0x154793, 0x4662f434c1a34666, 0x4662f434c1a34666, 0x1b35d9548a8ea606, 192 }, /* #117 */
    { 0x3a65c7, 0x3a6593, 0x39e47afdae4516ee, 0xe47afdae4516eeab, 0xab108e32474695bc, 136 }, /* #118 */
    { 0x2e73d3, 0x2e7b17, 0x2caa54c357362d47, 0x57362d477cdb22fa, 0x7cdb22fae2a305f1, 32 }, /* #119 */
    { 0x206d96, 0x206512, 0xd99d5a9ab04e220c, 0x0c6c2ed6a429a762, 0x6c2ed6a429a7626c, 120 }, /* #120 */
    { 0x0c2352, 0x0c2b17, 0x8d5124aeace47f0c, 0x2db9d88bb28fc895, 0xb6e7622eca3f2256, 254 }, /* #121 */
    { 0x294706, 0x294f13, 0xcad5d89048d34a00, 0x2091a69400605cba, 0x302e5d251d7cdb7e, 217 }, /* #122 */
    { 0x040107, 0x040996, 0x673b2c6a57bcb992, 0xf2e64a93d3ff3a77, 0xa4f4ffce9de11818, 42 }, /* #123 */
    { 0x151502, 0x151512, 0x03236fbfd815dc13, 0x46df7fb02bb827bc, 0xde2c44f0cb7d8708,  9 }, /* #124 */
    { 0x234e56, 0x234e96, 0xb9c5ceb330342f2d, 0x9ed95690d4c2c41d, 0x3db2ad21a985883a, 255 }, /* #125 */
    { 0x0d2c52, 0x0d2493, 0x5b69b4789a584e03, 0x80e8544b382e31d0, 0xa1512ce0b8c74057, 54 }, /* #126 */
    { 0x376782, 0x376797, 0x0f13c50935423a93, 0xa937c2d59911aecf, 0x7c2d59911aecfa6e, 116 }, /* #127 */
};
uint32_t const g_cTests_shld_u64_amd = RT_ELEMENTS(g_aTests_shld_u64_amd);

BINU64_TEST_T const g_aTests_shrd_u64_amd[] =
{
    { 0x1c0e12, 0x1c0656, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 47 }, /* #0 */
    { 0x022812, 0x022056, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 219 }, /* #1 */
    { 0x1b3d52, 0x1b3556, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 224 }, /* #2 */
    { 0x135c52, 0x135456, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000,  2 }, /* #3 */
    { 0x2541c2, 0x254156, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 159 }, /* #4 */
    { 0x077d03, 0x077556, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 113 }, /* #5 */
    { 0x204cc3, 0x204cc3, 0x39cf9f8afacf35b7, 0x39cf9f8afacf35b7, 0x0000000000000000, 128 }, /* #6 */
    { 0x3c4813, 0x3c4016, 0xfffb0419e7df76f5, 0x0000000000001fff, 0x0000000000000000, 243 }, /* #7 */
    { 0x381887, 0x381017, 0x4dbf9b13511a2df6, 0x000000000000136f, 0x0000000000000000, 114 }, /* #8 */
    { 0x3440d3, 0x344057, 0x751d76172893a5e9, 0x0000000000000000, 0x0000000000000000, 63 }, /* #9 */
    { 0x337602, 0x337617, 0xe4fdedfd43e3dde9, 0x000001c9fbdbfa87, 0x0000000000000000, 215 }, /* #10 */
    { 0x3f21d7, 0x3f2116, 0x3d03d004c34f155e, 0x00000000007a07a0, 0x0000000000000000, 231 }, /* #11 */
    { 0x165416, 0x165c96, 0x8730581a28f46d3f, 0xb741bbcc3982c0d1, 0x87920518f6e83779, 93 }, /* #12 */
    { 0x184552, 0x184d16, 0x00fd5b87a06ea893, 0x621401fab70f40dd, 0x0edd9010d0a6310a, 15 }, /* #13 */
    { 0x0c5257, 0x0c5a16, 0x953bce9ebd455e72, 0x5acedf9d92f42593, 0x2d676fcec97a12c9, 127 }, /* #14 */
    { 0x0c7617, 0x0c7e92, 0x37099d1fbab8bf17, 0x827a3054f4e66e13, 0xcccd413d182a7a73, 47 }, /* #15 */
    { 0x1a6f13, 0x1a6796, 0x8e16331cfe746ecc, 0xecd28e16331cfe74, 0x9f2cd6400e27ecd2, 144 }, /* #16 */
    { 0x0517d3, 0x051f92, 0x5e4d1607bc9ecf90, 0xaf268b03de4f67c8, 0x23d0c9a5d6e155ef,  1 }, /* #17 */
    { 0x214112, 0x214997, 0xadcb15158378c4f6, 0xa5f5b962a2b06f18, 0x9489a205efd52d2f, 203 }, /* #18 */
    { 0x283c87, 0x283413, 0x0b213acfa29d6442, 0x37b83815ce164275, 0xf50fd21bdc1c0ae7, 167 }, /* #19 */
    { 0x365003, 0x365812, 0x13397b21c554152a, 0x68b0b78d84ce5ec8, 0xe78adde1a2c2de36, 226 }, /* #20 */
    { 0x340246, 0x340a13, 0xc8c153a95bdcfa7d, 0x60ddce0c5b80bcc8, 0x4b60ddce0c5b80bc, 56 }, /* #21 */
    { 0x2421d7, 0x242916, 0x2c28085b90fd65d3, 0x78205c8b0a0216e4, 0xbe5272b0dde08172, 154 }, /* #22 */
    { 0x171203, 0x171a12, 0x8747196fd43491a9, 0x757c43a38cb7ea1a, 0xb1dc465d0cd6eaf8, 17 }, /* #23 */
    { 0x076906, 0x076193, 0xc769c3728581b849, 0xe5f8e13cea578ed3, 0x331e72fc709e752b, 111 }, /* #24 */
    { 0x035186, 0x035186, 0x695b4d71d330ced6, 0x695b4d71d330ced6, 0x31cf39ac38d14038, 192 }, /* #25 */
    { 0x3b0787, 0x3b0712, 0x7827e01dd2fe5794, 0x1e09f80774bf95e5, 0xd5f185d741eaacb8, 130 }, /* #26 */
    { 0x0e2002, 0x0e2816, 0xccf983883cec888f, 0x4a9f4cf33e60e20f, 0xbc81a812512a7d33, 154 }, /* #27 */
    { 0x0f6406, 0x0f6c93, 0x22fb464969c576cf, 0xaa8e266433536e45, 0xb2d547133219a9b7, 119 }, /* #28 */
    { 0x3373c2, 0x337b16, 0xbc1217bd7787e9f9, 0x54687d4b8eebc121, 0xdeb9154687d4b8ee, 108 }, /* #29 */
    { 0x1d7106, 0x1d7197, 0x2bf217c3716ef663, 0xc337e57e42f86e2d, 0x4b145c87a2f619bf, 147 }, /* #30 */
    { 0x1b6547, 0x1b6d92, 0x698fee00cfa92453, 0xa77c9b71fad31fdc, 0x20ac2ad3be4db8fd, 103 }, /* #31 */
    { 0x3652c2, 0x365a92, 0x126c2495343b133d, 0x8946107ceaddd289, 0xff128c20f9d5bba5, 57 }, /* #32 */
    { 0x010b93, 0x010b92, 0xa72a1af74766b1e8, 0xa14ef54188de9ca8, 0x28602853bd506237, 174 }, /* #33 */
    { 0x057a02, 0x057a92, 0xa238b5c856ccd705, 0x8a42ce93a238b5c8, 0x28081a288a42ce93, 160 }, /* #34 */
    { 0x0132c7, 0x013a96, 0xd33275adb148912a, 0x9cd38cab977567a6, 0xf24e69c655cbbab3, 247 }, /* #35 */
    { 0x2a6ec3, 0x2a6e13, 0x29e35213d615b034, 0x7e8bbe2590b97094, 0x80fd177c4b2172e1, 57 }, /* #36 */
    { 0x091b93, 0x091316, 0x571a450cdd0f4b53, 0x208cdb7323d15c69, 0x190d482336dcc8f4, 174 }, /* #37 */
    { 0x266d97, 0x266517, 0x75cbed97ecac9296, 0x03eb6e030eb97db2, 0xac1c68901f5b7018, 99 }, /* #38 */
    { 0x070dc3, 0x070d16, 0x50f5b1734af5d317, 0x7d72551e8b50f5b1, 0xf248517d72551e8b, 40 }, /* #39 */
    { 0x115846, 0x115896, 0xc77aa48eecc249ca, 0x80c35c77aa48eecc, 0x550971a64bd80c35, 20 }, /* #40 */
    { 0x2b7cd6, 0x2b7412, 0x64e47615baec22db, 0x0a756f2530490726, 0x10a756f253049072, 60 }, /* #41 */
    { 0x231593, 0x231d16, 0x459f83653032887f, 0x7b15167e0d94c0ca, 0x561aedc8ab6b5ec5, 206 }, /* #42 */
    { 0x110616, 0x110e97, 0x1c1bdabc1f41d937, 0x8693a78e0ded5e0f, 0x2c8fc99d6b0d274f, 25 }, /* #43 */
    { 0x100a43, 0x100296, 0x5cd624c1f29a0176, 0xf21dde0e5508b9ac, 0x3f78790eef072a84, 175 }, /* #44 */
    { 0x246bd6, 0x246312, 0xaf72e189b76b739b, 0x22bdcb8626ddadce, 0x596e3f8d5f352288,  6 }, /* #45 */
    { 0x261d96, 0x261592, 0x436bf63e4228c825, 0xccac50dafd8f908a, 0x29391aa2ef1f32b1, 210 }, /* #46 */
    { 0x226842, 0x226893, 0x4c102550b840669a, 0xb0c70035abe98204, 0x361d75863801ad5f, 43 }, /* #47 */
    { 0x3e4002, 0x3e4096, 0x8ee77409559c65ec, 0xd7323578ee774095, 0x52154445fd732357, 28 }, /* #48 */
    { 0x3670d2, 0x367012, 0x431f2c21093df6f0, 0x11218f9610849efb, 0x05056fda34572422, 201 }, /* #49 */
    { 0x1a4596, 0x1a4d96, 0x8f92229d2163903b, 0x8b68f73c863cf2cf, 0x45b47b9e431e7967, 255 }, /* #50 */
    { 0x3e4792, 0x3e4f97, 0x5abb89b17b4c7d61, 0xb56aee26c5ed31f5, 0xd538e8b00e4cd12d, 134 }, /* #51 */
    { 0x202d03, 0x202d12, 0x71c4c0e28fc87626, 0x4af24592b2edc713, 0xa88852bc9164acbb, 110 }, /* #52 */
    { 0x115bc7, 0x115313, 0xf3c17cf47628d90b, 0x236fe782f9e8ec51, 0x8a3cb8a463f291b7, 15 }, /* #53 */
    { 0x1a5106, 0x1a5112, 0x9c9e7f7d6edac48e, 0x118a548153882e19, 0x08c52a40a9c4170c, 63 }, /* #54 */
    { 0x161916, 0x161113, 0x9199ad4861e445aa, 0x36f323335a90c3c8, 0xd774c578ff6f1b79, 79 }, /* #55 */
    { 0x107086, 0x107017, 0x6b041c8451293f71, 0x25550a0f6bb0d0b1, 0x89554283daec342c, 62 }, /* #56 */
    { 0x111252, 0x111a97, 0xc001e314e4a7bb6c, 0xbbdf1ab706000f18, 0x0a5caad77be356e0, 101 }, /* #57 */
    { 0x3314c7, 0x331c16, 0xed5446ca03367947, 0x7e8165ccb3b27b55, 0x08a5fa059732cec9, 178 }, /* #58 */
    { 0x363947, 0x363192, 0xde73b1a2b8c82eb9, 0xc493379cec68ae32, 0x02965b297d93124c, 18 }, /* #59 */
    { 0x103b87, 0x103396, 0xb81daae442f64c94, 0xe3be7b84b81daae4, 0xee9f2971e3be7b84, 160 }, /* #60 */
    { 0x110a02, 0x110213, 0x585528d097c35260, 0x1f7a9f96154a3425, 0x56ae2188547dea7e, 90 }, /* #61 */
    { 0x321ac2, 0x321a97, 0xb1b2dbe4017cf102, 0xa107ab05201b6365, 0xeebf5083d582900d, 111 }, /* #62 */
    { 0x0020c6, 0x002012, 0x533928f27b3ad412, 0x33b4f36bd4a354ce, 0x7154ced3cdaf528d, 242 }, /* #63 */
    { 0x112cd6, 0x112496, 0x716b06f2e9f479d6, 0xff440e8c2e2d60de, 0xa8b8aa17fa207461, 227 }, /* #64 */
    { 0x361246, 0x361212, 0x613541d7ac059010, 0x0e309aa0ebd602c8, 0x1a910b6faf75bc1c,  9 }, /* #65 */
    { 0x2b0187, 0x2b0196, 0xafff6104990d2ce8, 0xd7ffb0824c869674, 0xf3789b6d273a870d, 129 }, /* #66 */
    { 0x243c42, 0x243412, 0x06bf0fbf4b784be6, 0x199d8b241afc3efd, 0x2d867d67466762c9, 94 }, /* #67 */
    { 0x0702c6, 0x070296, 0x3800424e4aa4888a, 0xc7000849c9549111, 0xe440f76859014c6e, 67 }, /* #68 */
    { 0x166296, 0x166216, 0x28c4b49048642cf9, 0x25189692090c859f, 0xe7d36dc54a2a6ed9, 195 }, /* #69 */
    { 0x3f2b52, 0x3f2317, 0x5fbce6e6763ef6cc, 0x1534a5fbce6e6763, 0x29034f7d9e01534a, 148 }, /* #70 */
    { 0x033502, 0x033d96, 0xfa75691a8e8eb2b0, 0x8ed18bf4ead2351d, 0x6e2f774cb24768c5, 23 }, /* #71 */
    { 0x3c5f86, 0x3c5713, 0xd0a67e1e64f8e58c, 0x1cd0a67e1e64f8e5, 0x74943407a2a1ec1c, 136 }, /* #72 */
    { 0x131717, 0x131716, 0x89d1634a5d5067d7, 0x3f3f0f5eaa27458d, 0x428402cfcfc3d7aa, 38 }, /* #73 */
    { 0x335e86, 0x335e96, 0x9aa7103a2804ea20, 0x8368e1a5d819aa71, 0x24f0e8368e1a5d81, 44 }, /* #74 */
    { 0x264783, 0x264797, 0x55880a3f86bcce3d, 0xc6cfbaac4051fc35, 0xe34e136a9658d9f7, 21 }, /* #75 */
    { 0x124152, 0x124916, 0x5f35fe078e08bb23, 0x6fe783a8e8be6bfc, 0x3a632637f3c1d474, 167 }, /* #76 */
    { 0x122a87, 0x122a97, 0xed13e22c2983544e, 0xa9d197ba9bb44f88, 0x5016ef2a7465eea6, 166 }, /* #77 */
    { 0x007607, 0x007e97, 0xdb0c5b380f4f3c7d, 0xa02cfb689071d077, 0xd0167db44838e83b, 127 }, /* #78 */
    { 0x277887, 0x277892, 0xfe9487e797b54829, 0x843fa521f9e5ed52, 0xfcfc7005ac5eb210, 138 }, /* #79 */
    { 0x3a36d6, 0x3a3e13, 0xc82c4256eee62783, 0x6a36e823d905884a, 0x1614427b51b7411e, 99 }, /* #80 */
    { 0x070d96, 0x070d96, 0x18e29b22faceb553, 0x18e29b22faceb553, 0x962bb8b7c536e1f1, 192 }, /* #81 */
    { 0x266c86, 0x266c92, 0x89630da766bc221a, 0xaa98e55189630da7, 0x9bf75f83aa98e551, 160 }, /* #82 */
    { 0x1f7012, 0x1f7817, 0x8edcfb5054fe7988, 0x467c76e7da82a7f3, 0xe5cd36068df748cf, 77 }, /* #83 */
    { 0x2a22c7, 0x2a2a92, 0xb1c7993ca618fa09, 0x8ff638f32794c31f, 0x3cbe3abc271d6c7f, 203 }, /* #84 */
    { 0x095456, 0x095c13, 0x1cbe903a36ffef67, 0x6c3b0e5f481d1b7f, 0x959d6498b056d876, 17 }, /* #85 */
    { 0x091a13, 0x091a12, 0xe3460b387b594aec, 0x77cb8a9b9fe3460b, 0xb8ef0a77cb8a9b9f, 168 }, /* #86 */
    { 0x0a1883, 0x0a1013, 0x5f4fa9c7d419a3c8, 0x23957389abf02fa7, 0x66ee472ae71357e0, 49 }, /* #87 */
    { 0x161116, 0x161916, 0x925533dc0496f3a2, 0x7fbdc92a99ee024b, 0x692efaf26c46ff7b, 209 }, /* #88 */
    { 0x367c03, 0x367c17, 0x26d093d7ebe57a8c, 0x7c71e68f3f49b424, 0x5f1a09f1c79a3cfd, 42 }, /* #89 */
    { 0x1144d2, 0x114c97, 0xc265b7d2ee8781f7, 0x9c6132dbe97743c0, 0xd7445ad664073d38, 137 }, /* #90 */
    { 0x217bc7, 0x217b93, 0xc572d123a6876eab, 0xab1ee8e1bacc0f8a, 0x97558f7470dd6607, 119 }, /* #91 */
    { 0x013147, 0x013993, 0xb3d5455211d2072d, 0x956d744a2767aa8a, 0xf6d83f4ab6ba2513, 103 }, /* #92 */
    { 0x3d2b56, 0x3d2396, 0x3eeb69d12f2a406b, 0xe270fbada744bca9, 0x9e94b3891170389c, 14 }, /* #93 */
    { 0x355313, 0x355b96, 0x84b38302a2b6a3ac, 0x8ab17cbf3dc5e2e1, 0x822ac5f2fcf7178b, 250 }, /* #94 */
    { 0x322612, 0x322e12, 0x6564441654e192ab, 0x4e1d959110595386, 0xfa203212d9b21387, 142 }, /* #95 */
    { 0x1805c6, 0x180593, 0xe103dcb19db81755, 0xe0848df966e103dc, 0x84f099e0848df966, 168 }, /* #96 */
    { 0x037383, 0x037392, 0x6453c12b1a3078ef, 0xf7931fdb55dc6164, 0x61f7931fdb55dc61, 120 }, /* #97 */
    { 0x336f93, 0x336f96, 0x255d572576e3cbdd, 0x91012aeab92bb71e, 0x08e0bd7413047220, 13 }, /* #98 */
    { 0x0c3306, 0x0c3316, 0x5a316f99eac7a923, 0x1caea08ad18b7ccf, 0x4195db2b6395d411, 221 }, /* #99 */
    { 0x227407, 0x227493, 0x7cfd1e6b94375636, 0xd3110b5457cfd1e6, 0x7fecde2d3110b545, 36 }, /* #100 */
    { 0x197397, 0x197b92, 0x7c694f137786f1bf, 0xa6910f92e3541a3e, 0x954d221f25c6a834, 249 }, /* #101 */
    { 0x3a0d87, 0x3a0596, 0xe94ba7b925ec0155, 0xe1fc6697c262c3a5, 0xd6b87f19a5f098b0, 246 }, /* #102 */
    { 0x1e6757, 0x1e6f96, 0x7152c2bd43d281f8, 0x8d17152c2bd43d28, 0x54b9bd9d57ee28d1, 12 }, /* #103 */
    { 0x087a96, 0x087296, 0x06def24b17bb41d4, 0xf65c9218b7a9f230, 0xbecb924316f53e46, 189 }, /* #104 */
    { 0x370817, 0x370016, 0x69c7b92ece879ec1, 0x3a41bda71ee4bb3a, 0x06eca49af74e906f, 214 }, /* #105 */
    { 0x2221d3, 0x222996, 0x9ff3c538bcdc4017, 0x9473fe78a7179b88, 0x71507a0b702f4ca3, 75 }, /* #106 */
    { 0x031856, 0x031816, 0xd8ac47acd2b2ccee, 0x4acd57ec5623d669, 0xf7de62be56959aaf, 153 }, /* #107 */
    { 0x274e96, 0x274e13, 0xcd12e5b105e2507f, 0x4149fa09d2e715e6, 0xaa8293f413a5ce2b, 249 }, /* #108 */
    { 0x020917, 0x020992, 0x0f5f01c2e7a248e2, 0x95646420d7143d7c, 0xaa022559190835c5, 110 }, /* #109 */
    { 0x1303d3, 0x130312, 0xc0a636a2afa22eac, 0x31c73f981339b5b0, 0xd8c71cfe604ce6d6, 58 }, /* #110 */
    { 0x055083, 0x055017, 0x5a5474ce84e8f59a, 0x1ad2a3a6742747ac, 0x33a341dadec08de3, 133 }, /* #111 */
    { 0x0e5487, 0x0e5c97, 0x080a8f731fd7aabd, 0x98d067f02840547b, 0xcaf928731a0cfe05, 165 }, /* #112 */
    { 0x0c24c6, 0x0c2c12, 0x671d7290c6e02ada, 0x40fc98bffece3ae5, 0xc8329f207e4c5fff, 231 }, /* #113 */
    { 0x3436c6, 0x343e92, 0x5a80a9ccec3ff356, 0xad4054e6761ff9ab, 0x8d9c8195b50b9dab,  1 }, /* #114 */
    { 0x3534d7, 0x353493, 0xd5b1efd96ce1b30c, 0xed842678d415f6ad, 0x557db084cf1a82be, 245 }, /* #115 */
    { 0x275fd7, 0x275f17, 0x476f057f5918416b, 0x4987032747e5f11d, 0x385261c0c9d1f97c, 246 }, /* #116 */
    { 0x073313, 0x073317, 0xee088db812ac4d53, 0x0c6efdc111b70255, 0x4c7254e7f3906377, 19 }, /* #117 */
    { 0x1b62d7, 0x1b6a12, 0x89c52b39b87dc7c0, 0x44e2959cdc3ee3e0, 0x3ea8ab3d99c2b7ac, 193 }, /* #118 */
    { 0x3c1807, 0x3c1892, 0x0deb882598556351, 0x9e0a88dd746837ae, 0xa0c16782a2375d1a, 110 }, /* #119 */
    { 0x2c0213, 0x2c0a96, 0xffdf90e93c85f9fd, 0xb4707ff7e43a4f21, 0xc3790ea62ea2d1c1, 18 }, /* #120 */
    { 0x015812, 0x015092, 0x3781f36242beb976, 0xd66d9bc401bc0f9b, 0x01ac435acdb37880, 101 }, /* #121 */
    { 0x0d3e43, 0x0d3697, 0x7a2c371dbf3afec4, 0xcd68f947a2c371db, 0xba6c755e2cd68f94, 28 }, /* #122 */
    { 0x203dd7, 0x203d93, 0xaae7f79b277da916, 0xae44661ee3d55cfe, 0x63b005722330f71e, 171 }, /* #123 */
    { 0x2e2f92, 0x2e2796, 0x591a797783526f90, 0xe3424b4d477f00b2, 0x8871a125a6a3bf80, 119 }, /* #124 */
    { 0x056bd6, 0x056b93, 0x0b3a9a92986acb14, 0x8d1e7b4002cea6a4, 0x70b6b5ea3479ed00, 162 }, /* #125 */
    { 0x3c23c7, 0x3c2316, 0xc74a81d0bc2e5ac9, 0x37d9bcb2428d031d, 0x8bcdf66f2c90a340, 118 }, /* #126 */
    { 0x112516, 0x112517, 0xff3ca83df56ce151, 0x3e578ebfe79507be, 0x5f32aa6d89f2bc75, 27 }, /* #127 */
};
uint32_t const g_cTests_shrd_u64_amd = RT_ELEMENTS(g_aTests_shrd_u64_amd);

BINU8_TEST_T const g_aTests_rol_u8_amd[] =
{
    { 0x031706, 0x031706, 0x00, 0x00, 0, 6  }, /* #0 */
    { 0x3c68d3, 0x3c60d2, 0x00, 0x00, 0, 6  }, /* #0 b */
    { 0x1024c3, 0x1024c2, 0x00, 0x00, 0, 9  }, /* #1 */
    { 0x2f5b16, 0x2f5316, 0x00, 0x00, 0, 9  }, /* #1 b */
    { 0x0b4447, 0x0b4446, 0x00, 0x00, 0, 13 }, /* #2 */
    { 0x343b92, 0x343392, 0x00, 0x00, 0, 13 }, /* #2 b */
    { 0x283443, 0x283442, 0x00, 0x00, 0, 4  }, /* #3 */
    { 0x174b96, 0x174396, 0x00, 0x00, 0, 4  }, /* #3 b */
    { 0x382dd6, 0x3825d6, 0x00, 0x00, 0, 30 }, /* #4 */
    { 0x075203, 0x075202, 0x00, 0x00, 0, 30 }, /* #4 b */
    { 0x352786, 0x352786, 0x00, 0x00, 0, 8  }, /* #5 */
    { 0x0a5853, 0x0a5052, 0x00, 0x00, 0, 8  }, /* #5 b */
    { 0x3e24c6, 0x3e24c7, 0xfd, 0xdf, 0, 4  }, /* #6 */
    { 0x015b13, 0x015313, 0xfd, 0xdf, 0, 4  }, /* #6 b */
    { 0x282c42, 0x282442, 0x01, 0x04, 0, 10 }, /* #7 */
    { 0x175397, 0x175396, 0x01, 0x04, 0, 10 }, /* #7 b */
    { 0x174857, 0x174057, 0xbf, 0xf7, 0, 21 }, /* #8 */
    { 0x283782, 0x283783, 0xbf, 0xf7, 0, 21 }, /* #8 b */
    { 0x270fc6, 0x270fc6, 0xbe, 0xbe, 0, 0  }, /* #9 */
    { 0x187013, 0x187013, 0xbe, 0xbe, 0, 0  }, /* #9 b */
    { 0x247656, 0x247e57, 0xfb, 0x7f, 0, 13 }, /* #10 */
    { 0x1b0983, 0x1b0983, 0xfb, 0x7f, 0, 13 }, /* #10 b */
    { 0x180bc2, 0x180bc3, 0x4e, 0x39, 0, 18 }, /* #11 */
    { 0x277417, 0x277c17, 0x4e, 0x39, 0, 18 }, /* #11 b */
    { 0x316a52, 0x316253, 0xcf, 0xe7, 0, 15 }, /* #12 */
    { 0x0e1587, 0x0e1587, 0xcf, 0xe7, 0, 15 }, /* #12 b */
    { 0x0d4683, 0x0d4683, 0x6c, 0x8d, 0, 13 }, /* #13 */
    { 0x323956, 0x323157, 0x6c, 0x8d, 0, 13 }, /* #13 b */
    { 0x203cc7, 0x203cc7, 0x67, 0x67, 0, 16 }, /* #14 */
    { 0x1f4312, 0x1f4b13, 0x67, 0x67, 0, 16 }, /* #14 b */
    { 0x184897, 0x184097, 0xb5, 0xad, 0, 27 }, /* #15 */
    { 0x273742, 0x273743, 0xb5, 0xad, 0, 27 }, /* #15 b */
    { 0x1c6e16, 0x1c6e17, 0xdc, 0x73, 0, 18 }, /* #16 */
    { 0x2311c3, 0x2319c3, 0xdc, 0x73, 0, 18 }, /* #16 b */
    { 0x1d5d87, 0x1d5d87, 0x46, 0x46, 0, 0  }, /* #17 */
    { 0x222252, 0x222252, 0x46, 0x46, 0, 0  }, /* #17 b */
    { 0x1c5ac6, 0x1c5ac6, 0x10, 0x10, 0, 0  }, /* #18 */
    { 0x232513, 0x232513, 0x10, 0x10, 0, 0  }, /* #18 b */
    { 0x2a0346, 0x2a0347, 0x73, 0x9b, 0, 3  }, /* #19 */
    { 0x157c93, 0x157493, 0x73, 0x9b, 0, 3  }, /* #19 b */
    { 0x275c96, 0x275c96, 0xca, 0xb2, 0, 22 }, /* #20 */
    { 0x182343, 0x182b42, 0xca, 0xb2, 0, 22 }, /* #20 b */
    { 0x0f7fd2, 0x0f77d2, 0x82, 0x28, 0, 20 }, /* #21 */
    { 0x300007, 0x300006, 0x82, 0x28, 0, 20 }, /* #21 b */
    { 0x3d7853, 0x3d7853, 0x6f, 0x6f, 0, 24 }, /* #22 */
    { 0x020786, 0x020f87, 0x6f, 0x6f, 0, 24 }, /* #22 b */
    { 0x075717, 0x075f16, 0x4f, 0x9e, 0, 25 }, /* #23 */
    { 0x3828c2, 0x3828c2, 0x4f, 0x9e, 0, 25 }, /* #23 b */
    { 0x3a54d7, 0x3a5cd7, 0xc5, 0x71, 0, 30 }, /* #24 */
    { 0x052b02, 0x052b03, 0xc5, 0x71, 0, 30 }, /* #24 b */
    { 0x206f42, 0x206742, 0xe1, 0x78, 0, 14 }, /* #25 */
    { 0x1f1097, 0x1f1096, 0xe1, 0x78, 0, 14 }, /* #25 b */
    { 0x2f39d6, 0x2f39d6, 0x4a, 0x4a, 0, 0  }, /* #26 */
    { 0x104603, 0x104603, 0x4a, 0x4a, 0, 0  }, /* #26 b */
    { 0x306042, 0x306842, 0x31, 0xc4, 0, 2  }, /* #27 */
    { 0x0f1f97, 0x0f1f96, 0x31, 0xc4, 0, 2  }, /* #27 b */
    { 0x2a5507, 0x2a5507, 0xae, 0xd5, 0, 13 }, /* #28 */
    { 0x152ad2, 0x1522d3, 0xae, 0xd5, 0, 13 }, /* #28 b */
    { 0x1d3d86, 0x1d3d87, 0xd6, 0x6b, 0, 23 }, /* #29 */
    { 0x224253, 0x224a53, 0xd6, 0x6b, 0, 23 }, /* #29 b */
    { 0x0c4bc3, 0x0c4bc2, 0x4b, 0xd2, 0, 22 }, /* #30 */
    { 0x333416, 0x333c16, 0x4b, 0xd2, 0, 22 }, /* #30 b */
    { 0x364643, 0x364642, 0x01, 0x10, 0, 28 }, /* #31 */
    { 0x093996, 0x093196, 0x01, 0x10, 0, 28 }, /* #31 b */
    { 0x1d3286, 0x1d3287, 0xdd, 0xbb, 0, 29 }, /* #32 */
    { 0x224d53, 0x224553, 0xdd, 0xbb, 0, 29 }, /* #32 b */
    { 0x0f4f83, 0x0f4f82, 0x90, 0x84, 0, 27 }, /* #33 */
    { 0x303056, 0x303856, 0x90, 0x84, 0, 27 }, /* #33 b */
    { 0x1f0d07, 0x1f0507, 0xfb, 0xbf, 0, 28 }, /* #34 */
    { 0x2072d2, 0x2072d3, 0xfb, 0xbf, 0, 28 }, /* #34 b */
    { 0x046093, 0x046092, 0x16, 0x2c, 0, 1  }, /* #35 */
    { 0x3b1f46, 0x3b1746, 0x16, 0x2c, 0, 1  }, /* #35 b */
    { 0x290252, 0x290a52, 0x59, 0xb2, 0, 9  }, /* #36 */
    { 0x167d87, 0x167d86, 0x59, 0xb2, 0, 9  }, /* #36 b */
    { 0x217092, 0x217893, 0xeb, 0x7d, 0, 13 }, /* #37 */
    { 0x1e0f47, 0x1e0f47, 0xeb, 0x7d, 0, 13 }, /* #37 b */
    { 0x2d1342, 0x2d1343, 0xf9, 0xcf, 0, 3  }, /* #38 */
    { 0x126c97, 0x126497, 0xf9, 0xcf, 0, 3  }, /* #38 b */
    { 0x050256, 0x050256, 0xf4, 0xf4, 0, 0  }, /* #39 */
    { 0x3a7d83, 0x3a7d83, 0xf4, 0xf4, 0, 0  }, /* #39 b */
    { 0x052d92, 0x052592, 0x40, 0x08, 0, 5  }, /* #40 */
    { 0x3a5247, 0x3a5246, 0x40, 0x08, 0, 5  }, /* #40 b */
    { 0x100317, 0x100b16, 0xa2, 0xa8, 0, 14 }, /* #41 */
    { 0x2f7cc2, 0x2f7cc2, 0xa2, 0xa8, 0, 14 }, /* #41 b */
    { 0x2b2c57, 0x2b2c56, 0x91, 0x8c, 0, 3  }, /* #42 */
    { 0x145382, 0x145b82, 0x91, 0x8c, 0, 3  }, /* #42 b */
    { 0x341697, 0x341696, 0x8e, 0x3a, 0, 2  }, /* #43 */
    { 0x0b6942, 0x0b6142, 0x8e, 0x3a, 0, 2  }, /* #43 b */
    { 0x0b4c56, 0x0b4c57, 0xb5, 0x5b, 0, 4  }, /* #44 */
    { 0x343383, 0x343b83, 0xb5, 0x5b, 0, 4  }, /* #44 b */
    { 0x1312c3, 0x131ac2, 0x72, 0x9c, 0, 14 }, /* #45 */
    { 0x2c6d16, 0x2c6d16, 0x72, 0x9c, 0, 14 }, /* #45 b */
    { 0x2a23c2, 0x2a23c2, 0x02, 0x02, 0, 16 }, /* #46 */
    { 0x155c17, 0x155416, 0x02, 0x02, 0, 16 }, /* #46 b */
    { 0x1d7886, 0x1d7087, 0xf7, 0xf7, 0, 8  }, /* #47 */
    { 0x220753, 0x220753, 0xf7, 0xf7, 0, 8  }, /* #47 b */
    { 0x0f7246, 0x0f7a47, 0x26, 0x13, 0, 7  }, /* #48 */
    { 0x300d93, 0x300d93, 0x26, 0x13, 0, 7  }, /* #48 b */
    { 0x302393, 0x302392, 0x90, 0x48, 0, 31 }, /* #49 */
    { 0x0f5c46, 0x0f5446, 0x90, 0x48, 0, 31 }, /* #49 b */
    { 0x1e4412, 0x1e4413, 0x79, 0x97, 0, 12 }, /* #50 */
    { 0x213bc7, 0x2133c7, 0x79, 0x97, 0, 12 }, /* #50 b */
    { 0x355c86, 0x355487, 0xd6, 0xb5, 0, 14 }, /* #51 */
    { 0x0a2353, 0x0a2353, 0xd6, 0xb5, 0, 14 }, /* #51 b */
    { 0x023103, 0x023103, 0xe8, 0xe8, 0, 0  }, /* #52 */
    { 0x3d4ed6, 0x3d4ed6, 0xe8, 0xe8, 0, 0  }, /* #52 b */
    { 0x2a4a87, 0x2a4286, 0x44, 0x44, 0, 20 }, /* #53 */
    { 0x153552, 0x153552, 0x44, 0x44, 0, 20 }, /* #53 b */
    { 0x343282, 0x343282, 0x1e, 0x3c, 0, 17 }, /* #54 */
    { 0x0b4d57, 0x0b4556, 0x1e, 0x3c, 0, 17 }, /* #54 b */
    { 0x2207d3, 0x2207d3, 0xf8, 0xf1, 0, 1  }, /* #55 */
    { 0x1d7806, 0x1d7007, 0xf8, 0xf1, 0, 1  }, /* #55 b */
    { 0x294983, 0x294983, 0x94, 0x29, 0, 9  }, /* #56 */
    { 0x163656, 0x163e57, 0x94, 0x29, 0, 9  }, /* #56 b */
    { 0x084cd6, 0x0844d7, 0xe7, 0xe7, 0, 8  }, /* #57 */
    { 0x373303, 0x373303, 0xe7, 0xe7, 0, 8  }, /* #57 b */
    { 0x263397, 0x263397, 0x6b, 0xb5, 0, 7  }, /* #58 */
    { 0x194c42, 0x194443, 0x6b, 0xb5, 0, 7  }, /* #58 b */
    { 0x174f56, 0x174f57, 0xed, 0x7b, 0, 6  }, /* #59 */
    { 0x283083, 0x283883, 0xed, 0x7b, 0, 6  }, /* #59 b */
    { 0x1734c6, 0x173cc7, 0x90, 0x21, 0, 17 }, /* #60 */
    { 0x284b13, 0x284b13, 0x90, 0x21, 0, 17 }, /* #60 b */
    { 0x1a64c6, 0x1a64c6, 0x09, 0x12, 0, 1  }, /* #61 */
    { 0x251b13, 0x251312, 0x09, 0x12, 0, 1  }, /* #61 b */
    { 0x2f4346, 0x2f4346, 0x42, 0x24, 0, 12 }, /* #62 */
    { 0x103c93, 0x103492, 0x42, 0x24, 0, 12 }, /* #62 b */
    { 0x1c2007, 0x1c2006, 0x84, 0x12, 0, 26 }, /* #63 */
    { 0x235fd2, 0x2357d2, 0x84, 0x12, 0, 26 }, /* #63 b */
    { 0x2e1e02, 0x2e1602, 0x36, 0x36, 0, 8  }, /* #64 */
    { 0x1161d7, 0x1161d6, 0x36, 0x36, 0, 8  }, /* #64 b */
    { 0x182746, 0x182746, 0xa5, 0x5a, 0, 28 }, /* #65 */
    { 0x275893, 0x275092, 0xa5, 0x5a, 0, 28 }, /* #65 b */
    { 0x1f5396, 0x1f5396, 0xa0, 0x28, 0, 22 }, /* #66 */
    { 0x202c43, 0x202442, 0xa0, 0x28, 0, 22 }, /* #66 b */
    { 0x015d12, 0x015513, 0xd1, 0xd1, 0, 8  }, /* #67 */
    { 0x3e22c7, 0x3e22c7, 0xd1, 0xd1, 0, 8  }, /* #67 b */
    { 0x2f1483, 0x2f1c82, 0xe9, 0xf4, 0, 23 }, /* #68 */
    { 0x106b56, 0x106b56, 0xe9, 0xf4, 0, 23 }, /* #68 b */
    { 0x341786, 0x341f87, 0x2e, 0x17, 0, 15 }, /* #69 */
    { 0x0b6853, 0x0b6853, 0x2e, 0x17, 0, 15 }, /* #69 b */
    { 0x285d52, 0x285d53, 0x6b, 0x6b, 0, 24 }, /* #70 */
    { 0x172287, 0x172a87, 0x6b, 0x6b, 0, 24 }, /* #70 b */
    { 0x200553, 0x200553, 0xed, 0xbd, 0, 21 }, /* #71 */
    { 0x1f7a86, 0x1f7287, 0xed, 0xbd, 0, 21 }, /* #71 b */
    { 0x2e7083, 0x2e7883, 0xe4, 0x39, 0, 30 }, /* #72 */
    { 0x110f56, 0x110f57, 0xe4, 0x39, 0, 30 }, /* #72 b */
    { 0x303406, 0x303c06, 0x78, 0xf0, 0, 9  }, /* #73 */
    { 0x0f4bd3, 0x0f4bd2, 0x78, 0xf0, 0, 9  }, /* #73 b */
    { 0x1b36d6, 0x1b36d6, 0x43, 0x34, 0, 12 }, /* #74 */
    { 0x244903, 0x244102, 0x43, 0x34, 0, 12 }, /* #74 b */
    { 0x0d2796, 0x0d2f97, 0x55, 0x55, 0, 8  }, /* #75 */
    { 0x325843, 0x325843, 0x55, 0x55, 0, 8  }, /* #75 b */
    { 0x2b1613, 0x2b1613, 0x91, 0x91, 0, 16 }, /* #76 */
    { 0x1469c6, 0x1461c7, 0x91, 0x91, 0, 16 }, /* #76 b */
    { 0x017092, 0x017892, 0x4d, 0x9a, 0, 25 }, /* #77 */
    { 0x3e0f47, 0x3e0f46, 0x4d, 0x9a, 0, 25 }, /* #77 b */
    { 0x3b4302, 0x3b4b02, 0x57, 0xea, 0, 13 }, /* #78 */
    { 0x043cd7, 0x043cd6, 0x57, 0xea, 0, 13 }, /* #78 b */
    { 0x1e4643, 0x1e4e42, 0xad, 0xb6, 0, 10 }, /* #79 */
    { 0x213996, 0x213996, 0xad, 0xb6, 0, 10 }, /* #79 b */
    { 0x085896, 0x085897, 0xf0, 0x0f, 0, 4  }, /* #80 */
    { 0x372743, 0x372f43, 0xf0, 0x0f, 0, 4  }, /* #80 b */
    { 0x245397, 0x245397, 0xee, 0xbb, 0, 30 }, /* #81 */
    { 0x1b2c42, 0x1b2443, 0xee, 0xbb, 0, 30 }, /* #81 b */
    { 0x3a3b87, 0x3a3386, 0x14, 0x28, 0, 25 }, /* #82 */
    { 0x054452, 0x054452, 0x14, 0x28, 0, 25 }, /* #82 b */
    { 0x3b3c02, 0x3b3403, 0x69, 0xa5, 0, 26 }, /* #83 */
    { 0x0443d7, 0x0443d7, 0x69, 0xa5, 0, 26 }, /* #83 b */
    { 0x3d00d7, 0x3d00d6, 0xa0, 0x28, 0, 22 }, /* #84 */
    { 0x027f02, 0x027702, 0xa0, 0x28, 0, 22 }, /* #84 b */
    { 0x090403, 0x090402, 0x42, 0x24, 0, 4  }, /* #85 */
    { 0x367bd6, 0x3673d6, 0x42, 0x24, 0, 4  }, /* #85 b */
    { 0x302f17, 0x302f16, 0x6f, 0xde, 0, 9  }, /* #86 */
    { 0x0f50c2, 0x0f58c2, 0x6f, 0xde, 0, 9  }, /* #86 b */
    { 0x1c6d83, 0x1c6d82, 0x4d, 0xa6, 0, 7  }, /* #87 */
    { 0x231256, 0x231a56, 0x4d, 0xa6, 0, 7  }, /* #87 b */
    { 0x2b5697, 0x2b5696, 0x3c, 0x78, 0, 25 }, /* #88 */
    { 0x142942, 0x142142, 0x3c, 0x78, 0, 25 }, /* #88 b */
    { 0x2f5e13, 0x2f5612, 0x28, 0x28, 0, 8  }, /* #89 */
    { 0x1021c6, 0x1021c6, 0x28, 0x28, 0, 8  }, /* #89 b */
    { 0x267407, 0x267407, 0xfa, 0xf5, 0, 9  }, /* #90 */
    { 0x190bd2, 0x1903d3, 0xfa, 0xf5, 0, 9  }, /* #90 b */
    { 0x323e07, 0x323606, 0x01, 0x10, 0, 20 }, /* #91 */
    { 0x0d41d2, 0x0d41d2, 0x01, 0x10, 0, 20 }, /* #91 b */
    { 0x287bd2, 0x287bd3, 0x4e, 0x27, 0, 7  }, /* #92 */
    { 0x170407, 0x170c07, 0x4e, 0x27, 0, 7  }, /* #92 b */
    { 0x1368c2, 0x1360c3, 0x9f, 0xf9, 0, 20 }, /* #93 */
    { 0x2c1717, 0x2c1717, 0x9f, 0xf9, 0, 20 }, /* #93 b */
    { 0x2f7702, 0x2f7702, 0x11, 0x22, 0, 9  }, /* #94 */
    { 0x1008d7, 0x1000d6, 0x11, 0x22, 0, 9  }, /* #94 b */
    { 0x160e12, 0x160e12, 0x79, 0xbc, 0, 23 }, /* #95 */
    { 0x2971c7, 0x2979c6, 0x79, 0xbc, 0, 23 }, /* #95 b */
};
uint32_t const g_cTests_rol_u8_amd = RT_ELEMENTS(g_aTests_rol_u8_amd);

BINU8_TEST_T const g_aTests_ror_u8_amd[] =
{
    { 0x2a5a87, 0x2a5286, 0x00, 0x00, 0, 17 }, /* #0 */
    { 0x152552, 0x152552, 0x00, 0x00, 0, 17 }, /* #0 b */
    { 0x0d3802, 0x0d3002, 0x00, 0x00, 0, 19 }, /* #1 */
    { 0x3247d7, 0x3247d6, 0x00, 0x00, 0, 19 }, /* #1 b */
    { 0x392e17, 0x392616, 0x00, 0x00, 0, 2  }, /* #2 */
    { 0x0651c2, 0x0651c2, 0x00, 0x00, 0, 2  }, /* #2 b */
    { 0x320242, 0x320242, 0x00, 0x00, 0, 12 }, /* #3 */
    { 0x0d7d97, 0x0d7596, 0x00, 0x00, 0, 12 }, /* #3 b */
    { 0x3c0002, 0x3c0002, 0x00, 0x00, 0, 16 }, /* #4 */
    { 0x037fd7, 0x0377d6, 0x00, 0x00, 0, 16 }, /* #4 b */
    { 0x123587, 0x123586, 0x00, 0x00, 0, 11 }, /* #5 */
    { 0x2d4a52, 0x2d4252, 0x00, 0x00, 0, 11 }, /* #5 b */
    { 0x3c7697, 0x3c7696, 0x44, 0x11, 0, 18 }, /* #6 */
    { 0x030942, 0x030142, 0x44, 0x11, 0, 18 }, /* #6 b */
    { 0x095347, 0x095b46, 0xc8, 0x64, 0, 1  }, /* #7 */
    { 0x362c92, 0x362c92, 0xc8, 0x64, 0, 1  }, /* #7 b */
    { 0x1d2bd3, 0x1d23d3, 0xe3, 0xf1, 0, 17 }, /* #8 */
    { 0x225406, 0x225407, 0xe3, 0xf1, 0, 17 }, /* #8 b */
    { 0x311216, 0x311a16, 0x28, 0x41, 0, 13 }, /* #9 */
    { 0x0e6dc3, 0x0e6dc2, 0x28, 0x41, 0, 13 }, /* #9 b */
    { 0x031b83, 0x031b83, 0xb5, 0xb5, 0, 0  }, /* #10 */
    { 0x3c6456, 0x3c6456, 0xb5, 0xb5, 0, 0  }, /* #10 b */
    { 0x004616, 0x004616, 0x71, 0x2e, 0, 19 }, /* #11 */
    { 0x3f39c3, 0x3f31c2, 0x71, 0x2e, 0, 19 }, /* #11 b */
    { 0x225cc2, 0x225cc3, 0x46, 0x8c, 0, 7  }, /* #12 */
    { 0x1d2317, 0x1d2b17, 0x46, 0x8c, 0, 7  }, /* #12 b */
    { 0x017f13, 0x017f12, 0xe8, 0x47, 0, 29 }, /* #13 */
    { 0x3e00c6, 0x3e08c6, 0xe8, 0x47, 0, 29 }, /* #13 b */
    { 0x3122d6, 0x312ad6, 0x03, 0x60, 0, 11 }, /* #14 */
    { 0x0e5d03, 0x0e5d02, 0x03, 0x60, 0, 11 }, /* #14 b */
    { 0x383c56, 0x383c56, 0xd2, 0x69, 0, 17 }, /* #15 */
    { 0x074383, 0x074b82, 0xd2, 0x69, 0, 17 }, /* #15 b */
    { 0x3051c7, 0x3051c7, 0xf2, 0xe5, 0, 7  }, /* #16 */
    { 0x0f2e12, 0x0f2613, 0xf2, 0xe5, 0, 7  }, /* #16 b */
    { 0x2874d3, 0x2874d2, 0x04, 0x01, 0, 18 }, /* #17 */
    { 0x170b06, 0x170306, 0x04, 0x01, 0, 18 }, /* #17 b */
    { 0x247946, 0x247147, 0xf3, 0xcf, 0, 30 }, /* #18 */
    { 0x1b0693, 0x1b0693, 0xf3, 0xcf, 0, 30 }, /* #18 b */
    { 0x032bd3, 0x0323d2, 0xd0, 0x0d, 0, 4  }, /* #19 */
    { 0x3c5406, 0x3c5406, 0xd0, 0x0d, 0, 4  }, /* #19 b */
    { 0x247082, 0x247082, 0x7e, 0x3f, 0, 9  }, /* #20 */
    { 0x1b0f57, 0x1b0756, 0x7e, 0x3f, 0, 9  }, /* #20 b */
    { 0x173f86, 0x173787, 0xaf, 0xfa, 0, 20 }, /* #21 */
    { 0x284053, 0x284053, 0xaf, 0xfa, 0, 20 }, /* #21 b */
    { 0x202fc6, 0x2027c6, 0x64, 0x19, 0, 2  }, /* #22 */
    { 0x1f5013, 0x1f5012, 0x64, 0x19, 0, 2  }, /* #22 b */
    { 0x0f5cc7, 0x0f54c6, 0x58, 0x2c, 0, 1  }, /* #23 */
    { 0x302312, 0x302312, 0x58, 0x2c, 0, 1  }, /* #23 b */
    { 0x3a6e42, 0x3a6e43, 0x89, 0x98, 0, 20 }, /* #24 */
    { 0x051197, 0x051997, 0x89, 0x98, 0, 20 }, /* #24 b */
    { 0x1e1252, 0x1e1a53, 0x35, 0x9a, 0, 9  }, /* #25 */
    { 0x216d87, 0x216d87, 0x35, 0x9a, 0, 9  }, /* #25 b */
    { 0x151016, 0x151017, 0x91, 0xc8, 0, 17 }, /* #26 */
    { 0x2a6fc3, 0x2a67c3, 0x91, 0xc8, 0, 17 }, /* #26 b */
    { 0x0b5106, 0x0b5907, 0xe7, 0x9f, 0, 14 }, /* #27 */
    { 0x342ed3, 0x342ed3, 0xe7, 0x9f, 0, 14 }, /* #27 b */
    { 0x394747, 0x394f47, 0xd3, 0xa7, 0, 15 }, /* #28 */
    { 0x063892, 0x063893, 0xd3, 0xa7, 0, 15 }, /* #28 b */
    { 0x286ac7, 0x2862c6, 0x78, 0x1e, 0, 2  }, /* #29 */
    { 0x171512, 0x171512, 0x78, 0x1e, 0, 2  }, /* #29 b */
    { 0x117ac3, 0x1172c3, 0xf2, 0xe5, 0, 7  }, /* #30 */
    { 0x2e0516, 0x2e0517, 0xf2, 0xe5, 0, 7  }, /* #30 b */
    { 0x2136d7, 0x2136d7, 0xd3, 0xd3, 0, 16 }, /* #31 */
    { 0x1e4902, 0x1e4103, 0xd3, 0xd3, 0, 16 }, /* #31 b */
    { 0x3c1a97, 0x3c1296, 0x0a, 0x28, 0, 30 }, /* #32 */
    { 0x036542, 0x036542, 0x0a, 0x28, 0, 30 }, /* #32 b */
    { 0x104547, 0x104d46, 0x6f, 0x7b, 0, 5  }, /* #33 */
    { 0x2f3a92, 0x2f3a92, 0x6f, 0x7b, 0, 5  }, /* #33 b */
    { 0x015d92, 0x015592, 0x41, 0x14, 0, 12 }, /* #34 */
    { 0x3e2247, 0x3e2246, 0x41, 0x14, 0, 12 }, /* #34 b */
    { 0x1472d7, 0x147ad7, 0x32, 0x91, 0, 21 }, /* #35 */
    { 0x2b0d02, 0x2b0d03, 0x32, 0x91, 0, 21 }, /* #35 b */
    { 0x3546d7, 0x3546d7, 0x6a, 0xd4, 0, 23 }, /* #36 */
    { 0x0a3902, 0x0a3103, 0x6a, 0xd4, 0, 23 }, /* #36 b */
    { 0x367387, 0x367b87, 0x3e, 0x8f, 0, 2  }, /* #37 */
    { 0x090c52, 0x090c53, 0x3e, 0x8f, 0, 2  }, /* #37 b */
    { 0x146b52, 0x146b52, 0x68, 0x43, 0, 29 }, /* #38 */
    { 0x2b1487, 0x2b1c86, 0x68, 0x43, 0, 29 }, /* #38 b */
    { 0x016c12, 0x016c13, 0x91, 0x91, 0, 16 }, /* #39 */
    { 0x3e13c7, 0x3e1bc7, 0x91, 0x91, 0, 16 }, /* #39 b */
    { 0x304856, 0x304056, 0x20, 0x10, 0, 17 }, /* #40 */
    { 0x0f3783, 0x0f3782, 0x20, 0x10, 0, 17 }, /* #40 b */
    { 0x105f86, 0x105787, 0x67, 0xec, 0, 11 }, /* #41 */
    { 0x2f2053, 0x2f2053, 0x67, 0xec, 0, 11 }, /* #41 b */
    { 0x122916, 0x122117, 0x1b, 0xc6, 0, 10 }, /* #42 */
    { 0x2d56c3, 0x2d56c3, 0x1b, 0xc6, 0, 10 }, /* #42 b */
    { 0x2e1c87, 0x2e1487, 0xcf, 0xfc, 0, 4  }, /* #43 */
    { 0x116352, 0x116353, 0xcf, 0xfc, 0, 4  }, /* #43 b */
    { 0x2f4e92, 0x2f4e92, 0xe3, 0x7c, 0, 3  }, /* #44 */
    { 0x103147, 0x103946, 0xe3, 0x7c, 0, 3  }, /* #44 b */
    { 0x083dd6, 0x083dd7, 0xba, 0xab, 0, 4  }, /* #45 */
    { 0x374203, 0x374a03, 0xba, 0xab, 0, 4  }, /* #45 b */
    { 0x2b4b06, 0x2b4307, 0x07, 0xc1, 0, 18 }, /* #46 */
    { 0x1434d3, 0x1434d3, 0x07, 0xc1, 0, 18 }, /* #46 b */
    { 0x3f2107, 0x3f2106, 0x59, 0x2b, 0, 11 }, /* #47 */
    { 0x005ed2, 0x0056d2, 0x59, 0x2b, 0, 11 }, /* #47 b */
    { 0x106d42, 0x106d42, 0xae, 0x75, 0, 5  }, /* #48 */
    { 0x2f1297, 0x2f1a96, 0xae, 0x75, 0, 5  }, /* #48 b */
    { 0x1b6386, 0x1b6b86, 0x77, 0x77, 0, 20 }, /* #49 */
    { 0x241c53, 0x241c52, 0x77, 0x77, 0, 20 }, /* #49 b */
    { 0x2c3202, 0x2c3202, 0x12, 0x09, 0, 25 }, /* #50 */
    { 0x134dd7, 0x1345d6, 0x12, 0x09, 0, 25 }, /* #50 b */
    { 0x373682, 0x373e83, 0x38, 0x83, 0, 4  }, /* #51 */
    { 0x084957, 0x084957, 0x38, 0x83, 0, 4  }, /* #51 b */
    { 0x0c3107, 0x0c3906, 0x5c, 0x5c, 0, 16 }, /* #52 */
    { 0x334ed2, 0x334ed2, 0x5c, 0x5c, 0, 16 }, /* #52 b */
    { 0x322013, 0x322012, 0xc0, 0x0c, 0, 28 }, /* #53 */
    { 0x0d5fc6, 0x0d57c6, 0xc0, 0x0c, 0, 28 }, /* #53 b */
    { 0x070343, 0x070342, 0x68, 0x34, 0, 17 }, /* #54 */
    { 0x387c96, 0x387496, 0x68, 0x34, 0, 17 }, /* #54 b */
    { 0x233f57, 0x233757, 0x5b, 0xda, 0, 29 }, /* #55 */
    { 0x1c4082, 0x1c4083, 0x5b, 0xda, 0, 29 }, /* #55 b */
    { 0x3b3506, 0x3b3d07, 0x82, 0x82, 0, 8  }, /* #56 */
    { 0x044ad3, 0x044ad3, 0x82, 0x82, 0, 8  }, /* #56 b */
    { 0x164216, 0x164a16, 0xcc, 0x66, 0, 25 }, /* #57 */
    { 0x293dc3, 0x293dc2, 0xcc, 0x66, 0, 25 }, /* #57 b */
    { 0x291542, 0x291543, 0x19, 0xc8, 0, 5  }, /* #58 */
    { 0x166a97, 0x166297, 0x19, 0xc8, 0, 5  }, /* #58 b */
    { 0x0129c7, 0x0121c7, 0x67, 0xec, 0, 19 }, /* #59 */
    { 0x3e5612, 0x3e5613, 0x67, 0xec, 0, 19 }, /* #59 b */
    { 0x346387, 0x346387, 0x77, 0xee, 0, 23 }, /* #60 */
    { 0x0b1c52, 0x0b1453, 0x77, 0xee, 0, 23 }, /* #60 b */
    { 0x2a5a93, 0x2a5293, 0x77, 0xee, 0, 23 }, /* #61 */
    { 0x152546, 0x152547, 0x77, 0xee, 0, 23 }, /* #61 b */
    { 0x3b3257, 0x3b3a57, 0xf2, 0x97, 0, 5  }, /* #62 */
    { 0x044d82, 0x044d83, 0xf2, 0x97, 0, 5  }, /* #62 b */
    { 0x084953, 0x084952, 0xce, 0x67, 0, 17 }, /* #63 */
    { 0x373686, 0x373e86, 0xce, 0x67, 0, 17 }, /* #63 b */
    { 0x314307, 0x314307, 0x4f, 0xe9, 0, 19 }, /* #64 */
    { 0x0e3cd2, 0x0e34d3, 0x4f, 0xe9, 0, 19 }, /* #64 b */
    { 0x1a7f97, 0x1a7f97, 0x85, 0x85, 0, 0  }, /* #65 */
    { 0x250042, 0x250042, 0x85, 0x85, 0, 0  }, /* #65 b */
    { 0x154492, 0x154493, 0x9a, 0xd4, 0, 5  }, /* #66 */
    { 0x2a3b47, 0x2a3347, 0x9a, 0xd4, 0, 5  }, /* #66 b */
    { 0x1042d3, 0x104ad3, 0xe5, 0x97, 0, 30 }, /* #67 */
    { 0x2f3d06, 0x2f3d07, 0xe5, 0x97, 0, 30 }, /* #67 b */
    { 0x360c83, 0x360483, 0x7c, 0xf8, 0, 15 }, /* #68 */
    { 0x097356, 0x097357, 0x7c, 0xf8, 0, 15 }, /* #68 b */
    { 0x3e2a56, 0x3e2257, 0xe3, 0xc7, 0, 23 }, /* #69 */
    { 0x015583, 0x015583, 0xe3, 0xc7, 0, 23 }, /* #69 b */
    { 0x3d6e03, 0x3d6e02, 0x6d, 0x6b, 0, 13 }, /* #70 */
    { 0x0211d6, 0x0219d6, 0x6d, 0x6b, 0, 13 }, /* #70 b */
    { 0x086796, 0x086f97, 0xea, 0xab, 0, 14 }, /* #71 */
    { 0x371843, 0x371843, 0xea, 0xab, 0, 14 }, /* #71 b */
    { 0x242996, 0x242197, 0xc5, 0xc5, 0, 16 }, /* #72 */
    { 0x1b5643, 0x1b5643, 0xc5, 0xc5, 0, 16 }, /* #72 b */
    { 0x382dc6, 0x3825c6, 0x93, 0x39, 0, 28 }, /* #73 */
    { 0x075213, 0x075212, 0x93, 0x39, 0, 28 }, /* #73 b */
    { 0x0f3c47, 0x0f3447, 0x66, 0xcc, 0, 31 }, /* #74 */
    { 0x304392, 0x304393, 0x66, 0xcc, 0, 31 }, /* #74 b */
    { 0x0d0193, 0x0d0192, 0xe3, 0x3e, 0, 4  }, /* #75 */
    { 0x327e46, 0x327646, 0xe3, 0x3e, 0, 4  }, /* #75 b */
    { 0x141312, 0x141312, 0x33, 0x33, 0, 8  }, /* #76 */
    { 0x2b6cc7, 0x2b64c6, 0x33, 0x33, 0, 8  }, /* #76 b */
    { 0x2d4d83, 0x2d4582, 0x1c, 0x0e, 0, 1  }, /* #77 */
    { 0x123256, 0x123256, 0x1c, 0x0e, 0, 1  }, /* #77 b */
    { 0x180b07, 0x180b07, 0x29, 0x94, 0, 1  }, /* #78 */
    { 0x2774d2, 0x277cd3, 0x29, 0x94, 0, 1  }, /* #78 b */
    { 0x0a51d6, 0x0a51d6, 0x1c, 0x1c, 0, 16 }, /* #79 */
    { 0x352e03, 0x352602, 0x1c, 0x1c, 0, 16 }, /* #79 b */
    { 0x3e1512, 0x3e1d13, 0x86, 0xa1, 0, 10 }, /* #80 */
    { 0x016ac7, 0x016ac7, 0x86, 0xa1, 0, 10 }, /* #80 b */
    { 0x210b87, 0x210b87, 0x4c, 0x4c, 0, 0  }, /* #81 */
    { 0x1e7452, 0x1e7452, 0x4c, 0x4c, 0, 0  }, /* #81 b */
    { 0x361002, 0x361803, 0xf2, 0xbc, 0, 26 }, /* #82 */
    { 0x096fd7, 0x096fd7, 0xf2, 0xbc, 0, 26 }, /* #82 b */
    { 0x2f1696, 0x2f1e97, 0x75, 0xba, 0, 1  }, /* #83 */
    { 0x106943, 0x106943, 0x75, 0xba, 0, 1  }, /* #83 b */
    { 0x004f46, 0x004f46, 0xac, 0x56, 0, 17 }, /* #84 */
    { 0x3f3093, 0x3f3892, 0xac, 0x56, 0, 17 }, /* #84 b */
    { 0x126007, 0x126807, 0x2f, 0xbc, 0, 30 }, /* #85 */
    { 0x2d1fd2, 0x2d1fd3, 0x2f, 0xbc, 0, 30 }, /* #85 b */
    { 0x293352, 0x293b52, 0x74, 0x47, 0, 12 }, /* #86 */
    { 0x164c87, 0x164c86, 0x74, 0x47, 0, 12 }, /* #86 b */
    { 0x2e4e96, 0x2e4e96, 0x65, 0x65, 0, 16 }, /* #87 */
    { 0x113143, 0x113942, 0x65, 0x65, 0, 16 }, /* #87 b */
    { 0x0a2e86, 0x0a2e87, 0xdc, 0x9b, 0, 27 }, /* #88 */
    { 0x355153, 0x355953, 0xdc, 0x9b, 0, 27 }, /* #88 b */
    { 0x222317, 0x222317, 0xfb, 0xfb, 0, 16 }, /* #89 */
    { 0x1d5cc2, 0x1d54c3, 0xfb, 0xfb, 0, 16 }, /* #89 b */
    { 0x3c6352, 0x3c6b52, 0xbd, 0x6f, 0, 26 }, /* #90 */
    { 0x031c87, 0x031c86, 0xbd, 0x6f, 0, 26 }, /* #90 b */
    { 0x0f7ac2, 0x0f72c2, 0x8e, 0x1d, 0, 15 }, /* #91 */
    { 0x300517, 0x300516, 0x8e, 0x1d, 0, 15 }, /* #91 b */
    { 0x2a1392, 0x2a1392, 0x2c, 0x0b, 0, 26 }, /* #92 */
    { 0x156c47, 0x156446, 0x2c, 0x0b, 0, 26 }, /* #92 b */
    { 0x261d82, 0x261582, 0xc1, 0x38, 0, 19 }, /* #93 */
    { 0x196257, 0x196256, 0xc1, 0x38, 0, 19 }, /* #93 b */
    { 0x075753, 0x075f53, 0x52, 0xa4, 0, 7  }, /* #94 */
    { 0x382886, 0x382887, 0x52, 0xa4, 0, 7  }, /* #94 b */
    { 0x071906, 0x071907, 0xea, 0xba, 0, 2  }, /* #95 */
    { 0x3866d3, 0x386ed3, 0xea, 0xba, 0, 2  }, /* #95 b */
};
uint32_t const g_cTests_ror_u8_amd = RT_ELEMENTS(g_aTests_ror_u8_amd);

BINU8_TEST_T const g_aTests_rcl_u8_amd[] =
{
    { 0x2c1c47, 0x2c1446, 0x00, 0x20, 0, 24 }, /* #0 */
    { 0x136392, 0x136392, 0x00, 0x00, 0, 24 }, /* #0 b */
    { 0x300692, 0x300692, 0x00, 0x00, 0, 1  }, /* #1 */
    { 0x0f7947, 0x0f7146, 0x00, 0x01, 0, 1  }, /* #1 b */
    { 0x3c5f16, 0x3c5716, 0x00, 0x00, 0, 19 }, /* #2 */
    { 0x0320c3, 0x0320c2, 0x00, 0x01, 0, 19 }, /* #2 b */
    { 0x127a42, 0x127242, 0x00, 0x00, 0, 22 }, /* #3 */
    { 0x2d0597, 0x2d0596, 0x00, 0x08, 0, 22 }, /* #3 b */
    { 0x0c3cc3, 0x0c34c2, 0x00, 0x08, 0, 13 }, /* #4 */
    { 0x334316, 0x334316, 0x00, 0x00, 0, 13 }, /* #4 b */
    { 0x312a97, 0x312296, 0x00, 0x10, 0, 14 }, /* #5 */
    { 0x0e5542, 0x0e5542, 0x00, 0x00, 0, 14 }, /* #5 b */
    { 0x073552, 0x073553, 0xfe, 0xcf, 0, 14 }, /* #6 */
    { 0x384a87, 0x384287, 0xfe, 0xdf, 0, 14 }, /* #6 b */
    { 0x363cd3, 0x3634d3, 0xbb, 0xee, 0, 7  }, /* #7 */
    { 0x094306, 0x094307, 0xbb, 0xae, 0, 7  }, /* #7 b */
    { 0x0a36d6, 0x0a36d6, 0x42, 0x21, 0, 26 }, /* #8 */
    { 0x354903, 0x354902, 0x42, 0xa1, 0, 26 }, /* #8 b */
    { 0x122497, 0x122c96, 0xd5, 0xaf, 0, 30 }, /* #9 */
    { 0x2d5b42, 0x2d5b42, 0xd5, 0xab, 0, 30 }, /* #9 b */
    { 0x270597, 0x270597, 0xd8, 0xd8, 0, 9  }, /* #10 */
    { 0x187a42, 0x187a42, 0xd8, 0xd8, 0, 9  }, /* #10 b */
    { 0x3376c6, 0x337ec6, 0x59, 0xc9, 0, 30 }, /* #11 */
    { 0x0c0913, 0x0c0912, 0x59, 0xcd, 0, 30 }, /* #11 b */
    { 0x2624c6, 0x2624c7, 0xc7, 0xd8, 0, 24 }, /* #12 */
    { 0x195b13, 0x195313, 0xc7, 0xf8, 0, 24 }, /* #12 b */
    { 0x296b03, 0x296b03, 0x7c, 0x7c, 0, 18 }, /* #13 */
    { 0x1614d6, 0x1614d6, 0x7c, 0x7c, 0, 18 }, /* #13 b */
    { 0x1e3fd7, 0x1e37d7, 0xdb, 0xb7, 0, 28 }, /* #14 */
    { 0x214002, 0x214003, 0xdb, 0xb6, 0, 28 }, /* #14 b */
    { 0x271253, 0x271252, 0xcf, 0x7f, 0, 3  }, /* #15 */
    { 0x186d86, 0x186586, 0xcf, 0x7b, 0, 3  }, /* #15 b */
    { 0x053703, 0x053703, 0xdd, 0xdd, 0, 18 }, /* #16 */
    { 0x3a48d6, 0x3a48d6, 0xdd, 0xdd, 0, 18 }, /* #16 b */
    { 0x092697, 0x092e97, 0x45, 0x45, 0, 18 }, /* #17 */
    { 0x365942, 0x365142, 0x45, 0x45, 0, 18 }, /* #17 b */
    { 0x174156, 0x174156, 0x61, 0x61, 0, 9  }, /* #18 */
    { 0x283e83, 0x283e83, 0x61, 0x61, 0, 9  }, /* #18 b */
    { 0x176556, 0x176556, 0x30, 0x0c, 0, 7  }, /* #19 */
    { 0x281a83, 0x281282, 0x30, 0x4c, 0, 7  }, /* #19 b */
    { 0x331a87, 0x331287, 0x5b, 0xba, 0, 22 }, /* #20 */
    { 0x0c6552, 0x0c6553, 0x5b, 0xb2, 0, 22 }, /* #20 b */
    { 0x1b4fd6, 0x1b4fd6, 0xbf, 0xfd, 0, 2  }, /* #21 */
    { 0x243003, 0x243802, 0xbf, 0xff, 0, 2  }, /* #21 b */
    { 0x1f1897, 0x1f1097, 0xae, 0xda, 0, 23 }, /* #22 */
    { 0x206742, 0x206743, 0xae, 0xca, 0, 23 }, /* #22 b */
    { 0x380ad7, 0x380ad7, 0x9c, 0x39, 0, 28 }, /* #23 */
    { 0x077502, 0x077d03, 0x9c, 0x38, 0, 28 }, /* #23 b */
    { 0x2e2e57, 0x2e2e57, 0xf2, 0xf2, 0, 0  }, /* #24 */
    { 0x115182, 0x115182, 0xf2, 0xf2, 0, 0  }, /* #24 b */
    { 0x1b5842, 0x1b5843, 0x84, 0x08, 0, 19 }, /* #25 */
    { 0x242797, 0x242f97, 0x84, 0x09, 0, 19 }, /* #25 b */
    { 0x055a86, 0x055287, 0x5c, 0x85, 0, 23 }, /* #26 */
    { 0x3a2553, 0x3a2553, 0x5c, 0x95, 0, 23 }, /* #26 b */
    { 0x1e3012, 0x1e3813, 0xa5, 0x2a, 0, 3  }, /* #27 */
    { 0x214fc7, 0x214fc7, 0xa5, 0x2e, 0, 3  }, /* #27 b */
    { 0x090043, 0x090042, 0x20, 0x09, 0, 4  }, /* #28 */
    { 0x367f96, 0x367796, 0x20, 0x01, 0, 4  }, /* #28 b */
    { 0x290542, 0x290d42, 0xed, 0xed, 0, 9  }, /* #29 */
    { 0x167a97, 0x167297, 0xed, 0xed, 0, 9  }, /* #29 b */
    { 0x3f5693, 0x3f5693, 0xb0, 0xb0, 0, 18 }, /* #30 */
    { 0x002946, 0x002946, 0xb0, 0xb0, 0, 18 }, /* #30 b */
    { 0x021512, 0x021d12, 0x29, 0xa4, 0, 11 }, /* #31 */
    { 0x3d6ac7, 0x3d6ac6, 0x29, 0xa6, 0, 11 }, /* #31 b */
    { 0x3d66d6, 0x3d66d7, 0xbe, 0xf2, 0, 12 }, /* #32 */
    { 0x021903, 0x021103, 0xbe, 0xf6, 0, 12 }, /* #32 b */
    { 0x0b5793, 0x0b5f93, 0x24, 0x24, 0, 27 }, /* #33 */
    { 0x342846, 0x342046, 0x24, 0x24, 0, 27 }, /* #33 b */
    { 0x2e6fc2, 0x2e6fc3, 0xd3, 0x4d, 0, 29 }, /* #34 */
    { 0x111017, 0x111817, 0xd3, 0x4f, 0, 29 }, /* #34 b */
    { 0x321a53, 0x321253, 0x7f, 0xdf, 0, 25 }, /* #35 */
    { 0x0d6586, 0x0d6587, 0x7f, 0x9f, 0, 25 }, /* #35 b */
    { 0x3f2842, 0x3f2043, 0x70, 0xc0, 0, 20 }, /* #36 */
    { 0x005797, 0x005797, 0x70, 0xc2, 0, 20 }, /* #36 b */
    { 0x0f63c6, 0x0f63c6, 0x4d, 0x4d, 0, 27 }, /* #37 */
    { 0x301c13, 0x301c13, 0x4d, 0x4d, 0, 27 }, /* #37 b */
    { 0x1a0dc7, 0x1a05c7, 0xa2, 0xa2, 0, 27 }, /* #38 */
    { 0x257212, 0x257a12, 0xa2, 0xa2, 0, 27 }, /* #38 b */
    { 0x120d92, 0x120593, 0x97, 0xd2, 0, 6  }, /* #39 */
    { 0x2d7247, 0x2d7247, 0x97, 0xf2, 0, 6  }, /* #39 b */
    { 0x2b2e43, 0x2b2e42, 0x97, 0xbe, 0, 3  }, /* #40 */
    { 0x145196, 0x145996, 0x97, 0xba, 0, 3  }, /* #40 b */
    { 0x3d5d47, 0x3d5d46, 0x2a, 0xa9, 0, 4  }, /* #41 */
    { 0x022292, 0x022a92, 0x2a, 0xa1, 0, 4  }, /* #41 b */
    { 0x137ac3, 0x137ac2, 0xd6, 0xeb, 0, 26 }, /* #42 */
    { 0x2c0516, 0x2c0516, 0xd6, 0x6b, 0, 26 }, /* #42 b */
    { 0x2c6907, 0x2c6106, 0xcb, 0x5f, 0, 12 }, /* #43 */
    { 0x1316d2, 0x1316d2, 0xcb, 0x5b, 0, 12 }, /* #43 b */
    { 0x120b93, 0x120b93, 0xc5, 0x78, 0, 24 }, /* #44 */
    { 0x2d7446, 0x2d7c47, 0xc5, 0x58, 0, 24 }, /* #44 b */
    { 0x1f7e92, 0x1f7693, 0xb9, 0xca, 0, 30 }, /* #45 */
    { 0x200147, 0x200147, 0xb9, 0xce, 0, 30 }, /* #45 b */
    { 0x312d57, 0x312d57, 0x45, 0x45, 0, 27 }, /* #46 */
    { 0x0e5282, 0x0e5282, 0x45, 0x45, 0, 27 }, /* #46 b */
    { 0x2d6b43, 0x2d6343, 0xac, 0x9a, 0, 5  }, /* #47 */
    { 0x121496, 0x121497, 0xac, 0x8a, 0, 5  }, /* #47 b */
    { 0x295f57, 0x295f56, 0x8b, 0xbc, 0, 4  }, /* #48 */
    { 0x162082, 0x162882, 0x8b, 0xb4, 0, 4  }, /* #48 b */
    { 0x157283, 0x157a83, 0x7d, 0x6f, 0, 15 }, /* #49 */
    { 0x2a0d56, 0x2a0d57, 0x7d, 0x4f, 0, 15 }, /* #49 b */
    { 0x0a4b53, 0x0a4353, 0x92, 0x92, 0, 18 }, /* #50 */
    { 0x353486, 0x353c86, 0x92, 0x92, 0, 18 }, /* #50 b */
    { 0x3b4907, 0x3b4906, 0xc8, 0x8e, 0, 22 }, /* #51 */
    { 0x0436d2, 0x043ed2, 0xc8, 0x86, 0, 22 }, /* #51 b */
    { 0x066203, 0x066a03, 0xd5, 0x57, 0, 29 }, /* #52 */
    { 0x391dd6, 0x391dd7, 0xd5, 0x55, 0, 29 }, /* #52 b */
    { 0x2011c7, 0x2019c6, 0x22, 0xa4, 0, 24 }, /* #53 */
    { 0x1f6e12, 0x1f6e12, 0x22, 0x84, 0, 24 }, /* #53 b */
    { 0x0f4f83, 0x0f4f83, 0x6b, 0x5d, 0, 30 }, /* #54 */
    { 0x303056, 0x303857, 0x6b, 0x59, 0, 30 }, /* #54 b */
    { 0x0a14c3, 0x0a14c2, 0xa6, 0x6d, 0, 4  }, /* #55 */
    { 0x356b16, 0x356316, 0xa6, 0x65, 0, 4  }, /* #55 b */
    { 0x223197, 0x223197, 0xc8, 0xc8, 0, 0  }, /* #56 */
    { 0x1d4e42, 0x1d4e42, 0xc8, 0xc8, 0, 0  }, /* #56 b */
    { 0x0461c7, 0x0469c7, 0xa6, 0x69, 0, 7  }, /* #57 */
    { 0x3b1e12, 0x3b1e13, 0xa6, 0x29, 0, 7  }, /* #57 b */
    { 0x1439c3, 0x1431c3, 0xc9, 0xc9, 0, 18 }, /* #58 */
    { 0x2b4616, 0x2b4e16, 0xc9, 0xc9, 0, 18 }, /* #58 b */
    { 0x2007d3, 0x2007d3, 0xbe, 0xf6, 0, 12 }, /* #59 */
    { 0x1f7806, 0x1f7007, 0xbe, 0xf2, 0, 12 }, /* #59 b */
    { 0x2d0156, 0x2d0957, 0x4a, 0x28, 0, 2  }, /* #60 */
    { 0x127e83, 0x127e83, 0x4a, 0x2a, 0, 2  }, /* #60 b */
    { 0x3a64c6, 0x3a6cc7, 0xa9, 0x2a, 0, 23 }, /* #61 */
    { 0x051b13, 0x051b13, 0xa9, 0x3a, 0, 23 }, /* #61 b */
    { 0x040082, 0x040083, 0x74, 0xd0, 0, 20 }, /* #62 */
    { 0x3b7f57, 0x3b7757, 0x74, 0xd2, 0, 20 }, /* #62 b */
    { 0x0f29c6, 0x0f29c6, 0xcb, 0xb6, 0, 22 }, /* #63 */
    { 0x305613, 0x305e12, 0xcb, 0xbe, 0, 22 }, /* #63 b */
    { 0x137c42, 0x137c43, 0x9b, 0x4d, 0, 17 }, /* #64 */
    { 0x2c0397, 0x2c0397, 0x9b, 0xcd, 0, 17 }, /* #64 b */
    { 0x3b2042, 0x3b2043, 0x7d, 0xe9, 0, 3  }, /* #65 */
    { 0x045f97, 0x045797, 0x7d, 0xed, 0, 3  }, /* #65 b */
    { 0x253b17, 0x253317, 0xe4, 0x93, 0, 29 }, /* #66 */
    { 0x1a44c2, 0x1a44c3, 0xe4, 0x91, 0, 29 }, /* #66 b */
    { 0x3715c3, 0x3715c3, 0xdb, 0xed, 0, 26 }, /* #67 */
    { 0x086a16, 0x086a17, 0xdb, 0x6d, 0, 26 }, /* #67 b */
    { 0x104c92, 0x104493, 0x79, 0xc9, 0, 12 }, /* #68 */
    { 0x2f3347, 0x2f3347, 0x79, 0xcd, 0, 12 }, /* #68 b */
    { 0x295252, 0x295a52, 0x77, 0xe7, 0, 23 }, /* #69 */
    { 0x162d87, 0x162d86, 0x77, 0xf7, 0, 23 }, /* #69 b */
    { 0x354297, 0x354a97, 0xca, 0x5c, 0, 14 }, /* #70 */
    { 0x0a3d42, 0x0a3d43, 0xca, 0x4c, 0, 14 }, /* #70 b */
    { 0x224fd7, 0x2247d6, 0x23, 0x47, 0, 10 }, /* #71 */
    { 0x1d3002, 0x1d3002, 0x23, 0x46, 0, 10 }, /* #71 b */
    { 0x067103, 0x067902, 0xe9, 0x9f, 0, 13 }, /* #72 */
    { 0x390ed6, 0x390ed6, 0xe9, 0x97, 0, 13 }, /* #72 b */
    { 0x1b6fd2, 0x1b6fd3, 0x76, 0x63, 0, 13 }, /* #73 */
    { 0x241007, 0x241807, 0x76, 0x6b, 0, 13 }, /* #73 b */
    { 0x121742, 0x121f42, 0x5a, 0xd1, 0, 3  }, /* #74 */
    { 0x2d6897, 0x2d6896, 0x5a, 0xd5, 0, 3  }, /* #74 b */
    { 0x305f96, 0x305f97, 0x8a, 0x14, 0, 19 }, /* #75 */
    { 0x0f2043, 0x0f2843, 0x8a, 0x15, 0, 19 }, /* #75 b */
    { 0x0f4f96, 0x0f4797, 0x6d, 0xb4, 0, 11 }, /* #76 */
    { 0x303043, 0x303043, 0x6d, 0xb6, 0, 11 }, /* #76 b */
    { 0x196bc2, 0x196bc2, 0xbb, 0xd7, 0, 24 }, /* #77 */
    { 0x261417, 0x261c16, 0xbb, 0xf7, 0, 24 }, /* #77 b */
    { 0x2335c6, 0x233dc6, 0x5f, 0xbe, 0, 10 }, /* #78 */
    { 0x1c4a13, 0x1c4a12, 0x5f, 0xbf, 0, 10 }, /* #78 b */
    { 0x327f87, 0x327786, 0x17, 0x5e, 0, 2  }, /* #79 */
    { 0x0d0052, 0x0d0052, 0x17, 0x5c, 0, 2  }, /* #79 b */
    { 0x296956, 0x296956, 0x2c, 0x2c, 0, 0  }, /* #80 */
    { 0x161683, 0x161683, 0x2c, 0x2c, 0, 0  }, /* #80 b */
    { 0x054ad7, 0x054ad6, 0x97, 0xbe, 0, 3  }, /* #81 */
    { 0x3a3502, 0x3a3d02, 0x97, 0xba, 0, 3  }, /* #81 b */
    { 0x091f43, 0x091f42, 0xbe, 0xfb, 0, 11 }, /* #82 */
    { 0x366096, 0x366896, 0xbe, 0xf9, 0, 11 }, /* #82 b */
    { 0x2b2793, 0x2b2793, 0xfc, 0xe7, 0, 21 }, /* #83 */
    { 0x145846, 0x145047, 0xfc, 0xe3, 0, 21 }, /* #83 b */
    { 0x013dc7, 0x0135c7, 0x7f, 0xfe, 0, 20 }, /* #84 */
    { 0x3e4212, 0x3e4213, 0x7f, 0xfc, 0, 20 }, /* #84 b */
    { 0x2a0612, 0x2a0613, 0x1f, 0x87, 0, 25 }, /* #85 */
    { 0x1579c7, 0x1571c7, 0x1f, 0xc7, 0, 25 }, /* #85 b */
    { 0x0276c3, 0x027ec2, 0xe0, 0xf0, 0, 8  }, /* #86 */
    { 0x3d0916, 0x3d0116, 0xe0, 0x70, 0, 8  }, /* #86 b */
    { 0x0f4a42, 0x0f4a43, 0xa1, 0x0a, 0, 21 }, /* #87 */
    { 0x303597, 0x303d97, 0xa1, 0x0e, 0, 21 }, /* #87 b */
    { 0x267896, 0x267097, 0xc7, 0xb1, 0, 7  }, /* #88 */
    { 0x190743, 0x190743, 0xc7, 0xf1, 0, 7  }, /* #88 b */
    { 0x383d92, 0x383d92, 0xbf, 0xfd, 0, 29 }, /* #89 */
    { 0x074247, 0x074a46, 0xbf, 0xff, 0, 29 }, /* #89 b */
    { 0x0e6886, 0x0e6886, 0xa0, 0xa0, 0, 18 }, /* #90 */
    { 0x311753, 0x311753, 0xa0, 0xa0, 0, 18 }, /* #90 b */
    { 0x3e72d3, 0x3e72d2, 0x78, 0x5e, 0, 25 }, /* #91 */
    { 0x010d06, 0x010506, 0x78, 0x1e, 0, 25 }, /* #91 b */
    { 0x295ed2, 0x2956d2, 0xc1, 0x0b, 0, 30 }, /* #92 */
    { 0x162107, 0x162106, 0xc1, 0x0f, 0, 30 }, /* #92 b */
    { 0x144712, 0x144713, 0x5d, 0xd2, 0, 4  }, /* #93 */
    { 0x2b38c7, 0x2b30c7, 0x5d, 0xda, 0, 4  }, /* #93 b */
    { 0x294bd6, 0x2943d6, 0x5c, 0x5c, 0, 9  }, /* #94 */
    { 0x163403, 0x163c03, 0x5c, 0x5c, 0, 9  }, /* #94 b */
    { 0x1b37c7, 0x1b3fc6, 0xaa, 0xab, 0, 2  }, /* #95 */
    { 0x244812, 0x244812, 0xaa, 0xa9, 0, 2  }, /* #95 b */
};
uint32_t const g_cTests_rcl_u8_amd = RT_ELEMENTS(g_aTests_rcl_u8_amd);

BINU8_TEST_T const g_aTests_rcr_u8_amd[] =
{
    { 0x180712, 0x180712, 0x00, 0x00, 0, 29 }, /* #0 */
    { 0x2778c7, 0x2778c6, 0x00, 0x40, 0, 29 }, /* #0 b */
    { 0x126b47, 0x126346, 0x00, 0x01, 0, 17 }, /* #1 */
    { 0x2d1492, 0x2d1492, 0x00, 0x00, 0, 17 }, /* #1 b */
    { 0x2c51d2, 0x2c51d2, 0x00, 0x00, 0, 20 }, /* #2 */
    { 0x132e07, 0x132e06, 0x00, 0x40, 0, 20 }, /* #2 b */
    { 0x395516, 0x395516, 0x00, 0x00, 0, 8  }, /* #3 */
    { 0x062ac3, 0x0622c2, 0x00, 0x01, 0, 8  }, /* #3 b */
    { 0x255c96, 0x255496, 0x00, 0x00, 0, 17 }, /* #4 */
    { 0x1a2343, 0x1a2342, 0x00, 0x01, 0, 17 }, /* #4 b */
    { 0x0e4c52, 0x0e4452, 0x00, 0x00, 0, 11 }, /* #5 */
    { 0x313387, 0x313b86, 0x00, 0x40, 0, 11 }, /* #5 b */
    { 0x281e02, 0x281602, 0x23, 0xc4, 0, 12 }, /* #6 */
    { 0x1761d7, 0x1761d6, 0x23, 0xe4, 0, 12 }, /* #6 b */
    { 0x016d57, 0x016556, 0x46, 0xd4, 0, 31 }, /* #7 */
    { 0x3e1282, 0x3e1282, 0x46, 0xc4, 0, 31 }, /* #7 b */
    { 0x1b1183, 0x1b1183, 0xe5, 0xe5, 0, 18 }, /* #8 */
    { 0x246e56, 0x246656, 0xe5, 0xe5, 0, 18 }, /* #8 b */
    { 0x115853, 0x115853, 0x65, 0xb2, 0, 19 }, /* #9 */
    { 0x2e2786, 0x2e2787, 0x65, 0x32, 0, 19 }, /* #9 b */
    { 0x2575d7, 0x257dd7, 0x12, 0x44, 0, 11 }, /* #10 */
    { 0x1a0a02, 0x1a0203, 0x12, 0x04, 0, 11 }, /* #10 b */
    { 0x3e01c2, 0x3e09c3, 0x03, 0x80, 0, 20 }, /* #11 */
    { 0x017e17, 0x017617, 0x03, 0xc0, 0, 20 }, /* #11 b */
    { 0x0378d6, 0x0378d7, 0x2f, 0x78, 0, 6  }, /* #12 */
    { 0x3c0703, 0x3c0f03, 0x2f, 0x7c, 0, 6  }, /* #12 b */
    { 0x2a0803, 0x2a0003, 0x2f, 0xe5, 0, 30 }, /* #13 */
    { 0x1577d6, 0x1577d7, 0x2f, 0xc5, 0, 30 }, /* #13 b */
    { 0x1e6557, 0x1e6557, 0xb7, 0xed, 0, 20 }, /* #14 */
    { 0x211a82, 0x211a83, 0xb7, 0xad, 0, 20 }, /* #14 b */
    { 0x252a86, 0x252286, 0xd1, 0x2d, 0, 13 }, /* #15 */
    { 0x1a5553, 0x1a5552, 0xd1, 0x3d, 0, 13 }, /* #15 b */
    { 0x2d7fc6, 0x2d77c6, 0x1d, 0x3a, 0, 17 }, /* #16 */
    { 0x120013, 0x120012, 0x1d, 0x3b, 0, 17 }, /* #16 b */
    { 0x3c36d2, 0x3c36d2, 0x1b, 0xc3, 0, 21 }, /* #17 */
    { 0x034907, 0x034106, 0x1b, 0xe3, 0, 21 }, /* #17 b */
    { 0x180853, 0x180053, 0xaf, 0xf5, 0, 21 }, /* #18 */
    { 0x277786, 0x277787, 0xaf, 0xd5, 0, 21 }, /* #18 b */
    { 0x326913, 0x326913, 0x5d, 0x6b, 0, 3  }, /* #19 */
    { 0x0d16c6, 0x0d1ec7, 0x5d, 0x4b, 0, 3  }, /* #19 b */
    { 0x040c93, 0x040492, 0x76, 0xd7, 0, 13 }, /* #20 */
    { 0x3b7346, 0x3b7346, 0x76, 0xc7, 0, 13 }, /* #20 b */
    { 0x1741d6, 0x1741d7, 0xb1, 0x15, 0, 23 }, /* #21 */
    { 0x283e03, 0x283603, 0xb1, 0x1d, 0, 23 }, /* #21 b */
    { 0x3408c3, 0x3408c2, 0x10, 0x44, 0, 2  }, /* #22 */
    { 0x0b7716, 0x0b7716, 0x10, 0x04, 0, 2  }, /* #22 b */
    { 0x057d97, 0x057596, 0x06, 0xd0, 0, 22 }, /* #23 */
    { 0x3a0242, 0x3a0242, 0x06, 0xc0, 0, 22 }, /* #23 b */
    { 0x3a7f03, 0x3a7f03, 0x85, 0x85, 0, 27 }, /* #24 */
    { 0x0500d6, 0x0508d6, 0x85, 0x85, 0, 27 }, /* #24 b */
    { 0x271b16, 0x271316, 0xf3, 0xf3, 0, 27 }, /* #25 */
    { 0x1864c3, 0x1864c3, 0xf3, 0xf3, 0, 27 }, /* #25 b */
    { 0x2b29d2, 0x2b21d2, 0x3a, 0x1d, 0, 19 }, /* #26 */
    { 0x145607, 0x145e06, 0x3a, 0x9d, 0, 19 }, /* #26 b */
    { 0x214347, 0x214346, 0xe7, 0xfe, 0, 4  }, /* #27 */
    { 0x1e3c92, 0x1e3492, 0xe7, 0xee, 0, 4  }, /* #27 b */
    { 0x073b16, 0x073b17, 0xc3, 0x86, 0, 8  }, /* #28 */
    { 0x3844c3, 0x384cc3, 0xc3, 0x87, 0, 8  }, /* #28 b */
    { 0x316797, 0x316797, 0x85, 0x85, 0, 0  }, /* #29 */
    { 0x0e1842, 0x0e1842, 0x85, 0x85, 0, 0  }, /* #29 b */
    { 0x121687, 0x121686, 0x25, 0xc9, 0, 20 }, /* #30 */
    { 0x2d6952, 0x2d6952, 0x25, 0x89, 0, 20 }, /* #30 b */
    { 0x1c17d7, 0x1c17d7, 0xc1, 0xe0, 0, 28 }, /* #31 */
    { 0x236802, 0x236803, 0xc1, 0x60, 0, 28 }, /* #31 b */
    { 0x192503, 0x192d02, 0xd2, 0x97, 0, 24 }, /* #32 */
    { 0x265ad6, 0x265ad6, 0xd2, 0x93, 0, 24 }, /* #32 b */
    { 0x382416, 0x382416, 0x59, 0xc9, 0, 6  }, /* #33 */
    { 0x075bc3, 0x0753c2, 0x59, 0xcd, 0, 6  }, /* #33 b */
    { 0x066d42, 0x066543, 0xa2, 0x12, 0, 6  }, /* #34 */
    { 0x391297, 0x391297, 0xa2, 0x16, 0, 6  }, /* #34 b */
    { 0x2a15c7, 0x2a1dc6, 0x6c, 0x5b, 0, 2  }, /* #35 */
    { 0x156a12, 0x156212, 0x6c, 0x1b, 0, 2  }, /* #35 b */
    { 0x064a07, 0x064a07, 0x61, 0x86, 0, 7  }, /* #36 */
    { 0x3935d2, 0x393dd3, 0x61, 0x84, 0, 7  }, /* #36 b */
    { 0x1547d2, 0x1547d2, 0xb3, 0xcd, 0, 7  }, /* #37 */
    { 0x2a3807, 0x2a3006, 0xb3, 0xcf, 0, 7  }, /* #37 b */
    { 0x004bc6, 0x004bc6, 0x6f, 0x6f, 0, 18 }, /* #38 */
    { 0x3f3413, 0x3f3c13, 0x6f, 0x6f, 0, 18 }, /* #38 b */
    { 0x3f3112, 0x3f3912, 0x0d, 0x83, 0, 11 }, /* #39 */
    { 0x004ec7, 0x0046c6, 0x0d, 0xc3, 0, 11 }, /* #39 b */
    { 0x107d93, 0x107d93, 0xba, 0xba, 0, 0  }, /* #40 */
    { 0x2f0246, 0x2f0246, 0xba, 0xba, 0, 0  }, /* #40 b */
    { 0x1b1c92, 0x1b1c92, 0xa3, 0x8d, 0, 25 }, /* #41 */
    { 0x246347, 0x246b46, 0xa3, 0x8f, 0, 25 }, /* #41 b */
    { 0x210dd7, 0x2105d7, 0x3a, 0x3a, 0, 9  }, /* #42 */
    { 0x1e7202, 0x1e7202, 0x3a, 0x3a, 0, 9  }, /* #42 b */
    { 0x023506, 0x023506, 0x98, 0xc2, 0, 6  }, /* #43 */
    { 0x3d4ad3, 0x3d42d2, 0x98, 0xc6, 0, 6  }, /* #43 b */
    { 0x3135d7, 0x313dd7, 0x95, 0x95, 0, 9  }, /* #44 */
    { 0x0e4a02, 0x0e4a02, 0x95, 0x95, 0, 9  }, /* #44 b */
    { 0x040813, 0x040813, 0x8d, 0x71, 0, 3  }, /* #45 */
    { 0x3b77c6, 0x3b7fc7, 0x8d, 0x51, 0, 3  }, /* #45 b */
    { 0x1e6312, 0x1e6b13, 0x2b, 0x62, 0, 31 }, /* #46 */
    { 0x211cc7, 0x211cc7, 0x2b, 0x72, 0, 31 }, /* #46 b */
    { 0x1f2346, 0x1f2347, 0xe6, 0x39, 0, 11 }, /* #47 */
    { 0x205c93, 0x205c93, 0xe6, 0x79, 0, 11 }, /* #47 b */
    { 0x030e82, 0x030683, 0x12, 0x20, 0, 5  }, /* #48 */
    { 0x3c7157, 0x3c7157, 0x12, 0x28, 0, 5  }, /* #48 b */
    { 0x284f07, 0x284707, 0x58, 0x15, 0, 4  }, /* #49 */
    { 0x1730d2, 0x1730d3, 0x58, 0x05, 0, 4  }, /* #49 b */
    { 0x0d4557, 0x0d4557, 0xeb, 0xf5, 0, 28 }, /* #50 */
    { 0x323a82, 0x323a83, 0xeb, 0x75, 0, 28 }, /* #50 b */
    { 0x166252, 0x166252, 0xd0, 0x0d, 0, 22 }, /* #51 */
    { 0x291d87, 0x291586, 0xd0, 0x1d, 0, 22 }, /* #51 b */
    { 0x070d42, 0x070543, 0x9a, 0x26, 0, 20 }, /* #52 */
    { 0x387297, 0x387a97, 0x9a, 0x66, 0, 20 }, /* #52 b */
    { 0x193c52, 0x193452, 0x38, 0x38, 0, 9  }, /* #53 */
    { 0x264387, 0x264387, 0x38, 0x38, 0, 9  }, /* #53 b */
    { 0x245e47, 0x245646, 0x81, 0x07, 0, 25 }, /* #54 */
    { 0x1b2192, 0x1b2192, 0x81, 0x05, 0, 25 }, /* #54 b */
    { 0x237883, 0x237882, 0xa3, 0x7a, 0, 4  }, /* #55 */
    { 0x1c0756, 0x1c0f56, 0xa3, 0x6a, 0, 4  }, /* #55 b */
    { 0x105e86, 0x105686, 0xfe, 0xfe, 0, 27 }, /* #56 */
    { 0x2f2153, 0x2f2153, 0xfe, 0xfe, 0, 27 }, /* #56 b */
    { 0x055f07, 0x055f06, 0x56, 0xab, 0, 19 }, /* #57 */
    { 0x3a20d2, 0x3a20d2, 0x56, 0x2b, 0, 19 }, /* #57 b */
    { 0x376306, 0x376b07, 0x8d, 0xa8, 0, 13 }, /* #58 */
    { 0x081cd3, 0x081cd3, 0x8d, 0xb8, 0, 13 }, /* #58 b */
    { 0x2f0196, 0x2f0196, 0x18, 0x18, 0, 0  }, /* #59 */
    { 0x107e43, 0x107e43, 0x18, 0x18, 0, 0  }, /* #59 b */
    { 0x275807, 0x275807, 0xd6, 0xad, 0, 8  }, /* #60 */
    { 0x1827d2, 0x182fd3, 0xd6, 0xac, 0, 8  }, /* #60 b */
    { 0x210096, 0x210896, 0x8a, 0x8a, 0, 27 }, /* #61 */
    { 0x1e7f43, 0x1e7f43, 0x8a, 0x8a, 0, 27 }, /* #61 b */
    { 0x1b3387, 0x1b3b86, 0x56, 0xb5, 0, 15 }, /* #62 */
    { 0x244c52, 0x244c52, 0x56, 0xb1, 0, 15 }, /* #62 b */
    { 0x234b06, 0x234b07, 0xb1, 0x58, 0, 28 }, /* #63 */
    { 0x1c34d3, 0x1c34d3, 0xb1, 0xd8, 0, 28 }, /* #63 b */
    { 0x387d83, 0x387d83, 0x5c, 0x95, 0, 4  }, /* #64 */
    { 0x070256, 0x070a57, 0x5c, 0x85, 0, 4  }, /* #64 b */
    { 0x057682, 0x057e83, 0x9d, 0x53, 0, 3  }, /* #65 */
    { 0x3a0957, 0x3a0957, 0x9d, 0x73, 0, 3  }, /* #65 b */
    { 0x0b6483, 0x0b6c83, 0xa5, 0xa5, 0, 27 }, /* #66 */
    { 0x341b56, 0x341b56, 0xa5, 0xa5, 0, 27 }, /* #66 b */
    { 0x0f4dc2, 0x0f4dc2, 0xab, 0xad, 0, 25 }, /* #67 */
    { 0x303217, 0x303a16, 0xab, 0xaf, 0, 25 }, /* #67 b */
    { 0x3762c3, 0x3762c3, 0x5c, 0xca, 0, 14 }, /* #68 */
    { 0x081d16, 0x081517, 0x5c, 0xc2, 0, 14 }, /* #68 b */
    { 0x0554c3, 0x0554c2, 0x30, 0x26, 0, 30 }, /* #69 */
    { 0x3a2b16, 0x3a2316, 0x30, 0x06, 0, 30 }, /* #69 b */
    { 0x345a92, 0x345293, 0x9e, 0x3c, 0, 17 }, /* #70 */
    { 0x0b2547, 0x0b2547, 0x9e, 0x3d, 0, 17 }, /* #70 b */
    { 0x261ac2, 0x261ac2, 0x23, 0x8c, 0, 7  }, /* #71 */
    { 0x196517, 0x196d16, 0x23, 0x8e, 0, 7  }, /* #71 b */
    { 0x103c12, 0x103413, 0xf3, 0xe6, 0, 8  }, /* #72 */
    { 0x2f43c7, 0x2f43c7, 0xf3, 0xe7, 0, 8  }, /* #72 b */
    { 0x185f13, 0x185f13, 0x72, 0x72, 0, 18 }, /* #73 */
    { 0x2720c6, 0x2728c6, 0x72, 0x72, 0, 18 }, /* #73 b */
    { 0x3e3582, 0x3e3583, 0xa2, 0x28, 0, 29 }, /* #74 */
    { 0x014a57, 0x014a57, 0xa2, 0x68, 0, 29 }, /* #74 b */
    { 0x111816, 0x111817, 0x83, 0xa0, 0, 11 }, /* #75 */
    { 0x2e67c3, 0x2e67c3, 0x83, 0xe0, 0, 11 }, /* #75 b */
    { 0x320903, 0x320102, 0x9b, 0xde, 0, 6  }, /* #76 */
    { 0x0d76d6, 0x0d76d6, 0x9b, 0xda, 0, 6  }, /* #76 b */
    { 0x0745d3, 0x074dd2, 0x6c, 0x5b, 0, 29 }, /* #77 */
    { 0x383a06, 0x383206, 0x6c, 0x1b, 0, 29 }, /* #77 b */
    { 0x327c92, 0x327492, 0x08, 0x01, 0, 30 }, /* #78 */
    { 0x0d0347, 0x0d0346, 0x08, 0x21, 0, 30 }, /* #78 b */
    { 0x050787, 0x050787, 0xac, 0xac, 0, 0  }, /* #79 */
    { 0x3a7852, 0x3a7852, 0xac, 0xac, 0, 0  }, /* #79 b */
    { 0x200283, 0x200a83, 0xd6, 0x75, 0, 11 }, /* #80 */
    { 0x1f7d56, 0x1f7557, 0xd6, 0x35, 0, 11 }, /* #80 b */
    { 0x3f3046, 0x3f3046, 0x07, 0x07, 0, 0  }, /* #81 */
    { 0x004f93, 0x004f93, 0x07, 0x07, 0, 0  }, /* #81 b */
    { 0x360297, 0x360a97, 0x3f, 0x9f, 0, 10 }, /* #82 */
    { 0x097d42, 0x097543, 0x3f, 0x1f, 0, 10 }, /* #82 b */
    { 0x2e4387, 0x2e4387, 0x83, 0xe0, 0, 29 }, /* #83 */
    { 0x113c52, 0x113c53, 0x83, 0xa0, 0, 29 }, /* #83 b */
    { 0x072082, 0x072082, 0xb0, 0x2c, 0, 11 }, /* #84 */
    { 0x385f57, 0x385f56, 0xb0, 0x6c, 0, 11 }, /* #84 b */
    { 0x3661c2, 0x3669c3, 0xba, 0x74, 0, 26 }, /* #85 */
    { 0x091e17, 0x091e17, 0xba, 0x75, 0, 26 }, /* #85 b */
    { 0x136796, 0x136f96, 0xf2, 0x9e, 0, 30 }, /* #86 */
    { 0x2c1843, 0x2c1842, 0xf2, 0xbe, 0, 30 }, /* #86 b */
    { 0x184d57, 0x184556, 0x11, 0x31, 0, 4  }, /* #87 */
    { 0x273282, 0x273282, 0x11, 0x21, 0, 4  }, /* #87 b */
    { 0x1c6347, 0x1c6b46, 0x69, 0x9b, 0, 14 }, /* #88 */
    { 0x231c92, 0x231c92, 0x69, 0x93, 0, 14 }, /* #88 b */
    { 0x3d6fd3, 0x3d6fd2, 0x5a, 0xad, 0, 28 }, /* #89 */
    { 0x021006, 0x021006, 0x5a, 0x2d, 0, 28 }, /* #89 b */
    { 0x1c0397, 0x1c0b97, 0x41, 0xa0, 0, 19 }, /* #90 */
    { 0x237c42, 0x237443, 0x41, 0x20, 0, 19 }, /* #90 b */
    { 0x0b09d6, 0x0b01d6, 0x6f, 0xde, 0, 26 }, /* #91 */
    { 0x347603, 0x347602, 0x6f, 0xdf, 0, 26 }, /* #91 b */
    { 0x1600c2, 0x1608c2, 0xb1, 0x56, 0, 21 }, /* #92 */
    { 0x297f17, 0x297f16, 0xb1, 0x76, 0, 21 }, /* #92 b */
    { 0x1619d3, 0x1611d3, 0xd1, 0x1e, 0, 5  }, /* #93 */
    { 0x296606, 0x296607, 0xd1, 0x16, 0, 5  }, /* #93 b */
    { 0x107312, 0x107b12, 0xae, 0x57, 0, 28 }, /* #94 */
    { 0x2f0cc7, 0x2f04c6, 0xae, 0xd7, 0, 28 }, /* #94 b */
    { 0x187c17, 0x187c17, 0x6b, 0x76, 0, 22 }, /* #95 */
    { 0x2703c2, 0x270bc3, 0x6b, 0x66, 0, 22 }, /* #95 b */
};
uint32_t const g_cTests_rcr_u8_amd = RT_ELEMENTS(g_aTests_rcr_u8_amd);

BINU8_TEST_T const g_aTests_shl_u8_amd[] =
{
    { 0x216a87, 0x216256, 0x00, 0x00, 0, 17 }, /* #0 */
    { 0x1e1552, 0x1e1556, 0x00, 0x00, 0, 17 }, /* #0 b */
    { 0x367a02, 0x367256, 0x00, 0x00, 0, 19 }, /* #1 */
    { 0x0905d7, 0x090556, 0x00, 0x00, 0, 19 }, /* #1 b */
    { 0x235417, 0x235456, 0x00, 0x00, 0, 16 }, /* #2 */
    { 0x1c2bc2, 0x1c2356, 0x00, 0x00, 0, 16 }, /* #2 b */
    { 0x233b53, 0x233356, 0x00, 0x00, 0, 24 }, /* #3 */
    { 0x1c4486, 0x1c4456, 0x00, 0x00, 0, 24 }, /* #3 b */
    { 0x017d82, 0x017556, 0x00, 0x00, 0, 1  }, /* #4 */
    { 0x3e0257, 0x3e0256, 0x00, 0x00, 0, 1  }, /* #4 b */
    { 0x2e6682, 0x2e6656, 0x00, 0x00, 0, 17 }, /* #5 */
    { 0x111957, 0x111156, 0x00, 0x00, 0, 17 }, /* #5 b */
    { 0x063356, 0x063356, 0xc6, 0x00, 0, 13 }, /* #6 */
    { 0x394c83, 0x394456, 0xc6, 0x00, 0, 13 }, /* #6 b */
    { 0x210617, 0x210656, 0xcf, 0x00, 0, 17 }, /* #7 */
    { 0x1e79c2, 0x1e7156, 0xcf, 0x00, 0, 17 }, /* #7 b */
    { 0x284dc7, 0x284593, 0x5b, 0xb0, 0, 4  }, /* #8 */
    { 0x173212, 0x173293, 0x5b, 0xb0, 0, 4  }, /* #8 b */
    { 0x383553, 0x383556, 0x2e, 0x00, 0, 10 }, /* #9 */
    { 0x074a86, 0x074256, 0x2e, 0x00, 0, 10 }, /* #9 b */
    { 0x106352, 0x106397, 0xf8, 0xf0, 0, 1  }, /* #10 */
    { 0x2f1c87, 0x2f1497, 0xf8, 0xf0, 0, 1  }, /* #10 b */
    { 0x350486, 0x350456, 0x39, 0x00, 0, 25 }, /* #11 */
    { 0x0a7b53, 0x0a7356, 0x39, 0x00, 0, 25 }, /* #11 b */
    { 0x3d3f07, 0x3d3756, 0x0b, 0x00, 0, 10 }, /* #12 */
    { 0x0240d2, 0x024056, 0x0b, 0x00, 0, 10 }, /* #12 b */
    { 0x201fc3, 0x201756, 0x47, 0x00, 0, 26 }, /* #13 */
    { 0x1f6016, 0x1f6056, 0x47, 0x00, 0, 26 }, /* #13 b */
    { 0x3f2382, 0x3f2356, 0x3c, 0x00, 0, 19 }, /* #14 */
    { 0x005c57, 0x005456, 0x3c, 0x00, 0, 19 }, /* #14 b */
    { 0x121457, 0x121493, 0x75, 0xa8, 0, 3  }, /* #15 */
    { 0x2d6b82, 0x2d6393, 0x75, 0xa8, 0, 3  }, /* #15 b */
    { 0x282017, 0x282056, 0xf7, 0x00, 0, 25 }, /* #16 */
    { 0x175fc2, 0x175756, 0xf7, 0x00, 0, 25 }, /* #16 b */
    { 0x242413, 0x242456, 0x9b, 0x00, 0, 19 }, /* #17 */
    { 0x1b5bc6, 0x1b5356, 0x9b, 0x00, 0, 19 }, /* #17 b */
    { 0x356e97, 0x356656, 0xe5, 0x00, 0, 14 }, /* #18 */
    { 0x0a1142, 0x0a1156, 0xe5, 0x00, 0, 14 }, /* #18 b */
    { 0x0015c2, 0x001556, 0x17, 0x00, 0, 29 }, /* #19 */
    { 0x3f6a17, 0x3f6256, 0x17, 0x00, 0, 29 }, /* #19 b */
    { 0x082442, 0x082493, 0x0c, 0x80, 0, 5  }, /* #20 */
    { 0x375b97, 0x375393, 0x0c, 0x80, 0, 5  }, /* #20 b */
    { 0x185816, 0x185056, 0x62, 0x00, 0, 18 }, /* #21 */
    { 0x2727c3, 0x272756, 0x62, 0x00, 0, 18 }, /* #21 b */
    { 0x2c5882, 0x2c5896, 0xdd, 0xe8, 0, 3  }, /* #22 */
    { 0x132757, 0x132f96, 0xdd, 0xe8, 0, 3  }, /* #22 b */
    { 0x235b52, 0x235316, 0x1b, 0x6c, 0, 2  }, /* #23 */
    { 0x1c2487, 0x1c2416, 0x1b, 0x6c, 0, 2  }, /* #23 b */
    { 0x2e7383, 0x2e7b92, 0xaa, 0x80, 0, 6  }, /* #24 */
    { 0x110c56, 0x110c92, 0xaa, 0x80, 0, 6  }, /* #24 b */
    { 0x320606, 0x320656, 0xa8, 0x00, 0, 29 }, /* #25 */
    { 0x0d79d3, 0x0d7156, 0xa8, 0x00, 0, 29 }, /* #25 b */
    { 0x0c2687, 0x0c2656, 0x08, 0x00, 0, 13 }, /* #26 */
    { 0x335952, 0x335156, 0x08, 0x00, 0, 13 }, /* #26 b */
    { 0x287416, 0x287456, 0x25, 0x00, 0, 18 }, /* #27 */
    { 0x170bc3, 0x170356, 0x25, 0x00, 0, 18 }, /* #27 b */
    { 0x3151c2, 0x315156, 0xf5, 0x00, 0, 26 }, /* #28 */
    { 0x0e2e17, 0x0e2656, 0xf5, 0x00, 0, 26 }, /* #28 b */
    { 0x1c3617, 0x1c3612, 0xa1, 0x40, 0, 6  }, /* #29 */
    { 0x2349c2, 0x234112, 0xa1, 0x40, 0, 6  }, /* #29 b */
    { 0x212312, 0x212b57, 0x33, 0x00, 0, 8  }, /* #30 */
    { 0x1e5cc7, 0x1e5c57, 0x33, 0x00, 0, 8  }, /* #30 b */
    { 0x0f4256, 0x0f4a57, 0x8d, 0x00, 0, 8  }, /* #31 */
    { 0x303d83, 0x303d57, 0x8d, 0x00, 0, 8  }, /* #31 b */
    { 0x1143c6, 0x114356, 0xe9, 0x00, 0, 28 }, /* #32 */
    { 0x2e3c13, 0x2e3456, 0xe9, 0x00, 0, 28 }, /* #32 b */
    { 0x2a6686, 0x2a6656, 0x1c, 0x00, 0, 15 }, /* #33 */
    { 0x151953, 0x151156, 0x1c, 0x00, 0, 15 }, /* #33 b */
    { 0x335782, 0x335782, 0x6e, 0x6e, 0, 0  }, /* #34 */
    { 0x0c2857, 0x0c2857, 0x6e, 0x6e, 0, 0  }, /* #34 b */
    { 0x1a21c7, 0x1a2156, 0x5d, 0x00, 0, 27 }, /* #35 */
    { 0x255e12, 0x255656, 0x5d, 0x00, 0, 27 }, /* #35 b */
    { 0x106c92, 0x106456, 0x58, 0x00, 0, 14 }, /* #36 */
    { 0x2f1347, 0x2f1356, 0x58, 0x00, 0, 14 }, /* #36 b */
    { 0x242487, 0x242c92, 0xfa, 0x80, 0, 6  }, /* #37 */
    { 0x1b5b52, 0x1b5b92, 0xfa, 0x80, 0, 6  }, /* #37 b */
    { 0x231dc2, 0x231556, 0x65, 0x00, 0, 14 }, /* #38 */
    { 0x1c6217, 0x1c6256, 0x65, 0x00, 0, 14 }, /* #38 b */
    { 0x0b3ed2, 0x0b3656, 0x8d, 0x00, 0, 23 }, /* #39 */
    { 0x344107, 0x344156, 0x8d, 0x00, 0, 23 }, /* #39 b */
    { 0x103e06, 0x103656, 0xa9, 0x00, 0, 17 }, /* #40 */
    { 0x2f41d3, 0x2f4156, 0xa9, 0x00, 0, 17 }, /* #40 b */
    { 0x092203, 0x092256, 0x64, 0x00, 0, 16 }, /* #41 */
    { 0x365dd6, 0x365556, 0x64, 0x00, 0, 16 }, /* #41 b */
    { 0x040206, 0x040256, 0x62, 0x00, 0, 19 }, /* #42 */
    { 0x3b7dd3, 0x3b7556, 0x62, 0x00, 0, 19 }, /* #42 b */
    { 0x041202, 0x041256, 0xeb, 0x00, 0, 14 }, /* #43 */
    { 0x3b6dd7, 0x3b6556, 0xeb, 0x00, 0, 14 }, /* #43 b */
    { 0x082493, 0x082497, 0xff, 0xc0, 0, 6  }, /* #44 */
    { 0x375b46, 0x375397, 0xff, 0xc0, 0, 6  }, /* #44 b */
    { 0x361596, 0x361556, 0x8e, 0x00, 0, 8  }, /* #45 */
    { 0x096a43, 0x096256, 0x8e, 0x00, 0, 8  }, /* #45 b */
    { 0x224b52, 0x224356, 0xac, 0x00, 0, 19 }, /* #46 */
    { 0x1d3487, 0x1d3456, 0xac, 0x00, 0, 19 }, /* #46 b */
    { 0x331a16, 0x331212, 0xcd, 0x68, 0, 3  }, /* #47 */
    { 0x0c65c3, 0x0c6512, 0xcd, 0x68, 0, 3  }, /* #47 b */
    { 0x0441d3, 0x044156, 0xfc, 0x00, 0, 11 }, /* #48 */
    { 0x3b3e06, 0x3b3656, 0xfc, 0x00, 0, 11 }, /* #48 b */
    { 0x192cd2, 0x192456, 0xea, 0x00, 0, 8  }, /* #49 */
    { 0x265307, 0x265356, 0xea, 0x00, 0, 8  }, /* #49 b */
    { 0x130e07, 0x130e07, 0x1f, 0x1f, 0, 0  }, /* #50 */
    { 0x2c71d2, 0x2c71d2, 0x1f, 0x1f, 0, 0  }, /* #50 b */
    { 0x2a7397, 0x2a7356, 0xa4, 0x00, 0, 16 }, /* #51 */
    { 0x150c42, 0x150456, 0xa4, 0x00, 0, 16 }, /* #51 b */
    { 0x1932d6, 0x193256, 0x3d, 0x00, 0, 21 }, /* #52 */
    { 0x264d03, 0x264556, 0x3d, 0x00, 0, 21 }, /* #52 b */
    { 0x2273c2, 0x227393, 0xfb, 0xec, 0, 2  }, /* #53 */
    { 0x1d0c17, 0x1d0493, 0xfb, 0xec, 0, 2  }, /* #53 b */
    { 0x354897, 0x354056, 0xcc, 0x00, 0, 17 }, /* #54 */
    { 0x0a3742, 0x0a3756, 0xcc, 0x00, 0, 17 }, /* #54 b */
    { 0x3b4386, 0x3b4356, 0xe6, 0x00, 0, 25 }, /* #55 */
    { 0x043c53, 0x043456, 0xe6, 0x00, 0, 25 }, /* #55 b */
    { 0x0b2996, 0x0b2156, 0x0d, 0x00, 0, 13 }, /* #56 */
    { 0x345643, 0x345656, 0x0d, 0x00, 0, 13 }, /* #56 b */
    { 0x107e07, 0x107656, 0x61, 0x00, 0, 18 }, /* #57 */
    { 0x2f01d2, 0x2f0156, 0x61, 0x00, 0, 18 }, /* #57 b */
    { 0x272143, 0x272156, 0x9e, 0x00, 0, 18 }, /* #58 */
    { 0x185e96, 0x185656, 0x9e, 0x00, 0, 18 }, /* #58 b */
    { 0x021497, 0x021456, 0x26, 0x00, 0, 26 }, /* #59 */
    { 0x3d6b42, 0x3d6356, 0x26, 0x00, 0, 26 }, /* #59 b */
    { 0x1a3897, 0x1a3056, 0x54, 0x00, 0, 30 }, /* #60 */
    { 0x254742, 0x254756, 0x54, 0x00, 0, 30 }, /* #60 b */
    { 0x0f3f03, 0x0f3756, 0x34, 0x00, 0, 26 }, /* #61 */
    { 0x3040d6, 0x304056, 0x34, 0x00, 0, 26 }, /* #61 b */
    { 0x394586, 0x394556, 0xa7, 0x00, 0, 11 }, /* #62 */
    { 0x063a53, 0x063256, 0xa7, 0x00, 0, 11 }, /* #62 b */
    { 0x0d1507, 0x0d1556, 0xf9, 0x00, 0, 18 }, /* #63 */
    { 0x326ad2, 0x326256, 0xf9, 0x00, 0, 18 }, /* #63 b */
    { 0x3c7106, 0x3c7156, 0xea, 0x00, 0, 31 }, /* #64 */
    { 0x030ed3, 0x030656, 0xea, 0x00, 0, 31 }, /* #64 b */
    { 0x3d7407, 0x3d7456, 0x68, 0x00, 0, 29 }, /* #65 */
    { 0x020bd2, 0x020356, 0x68, 0x00, 0, 29 }, /* #65 b */
    { 0x323056, 0x323056, 0x89, 0x00, 0, 17 }, /* #66 */
    { 0x0d4f83, 0x0d4756, 0x89, 0x00, 0, 17 }, /* #66 b */
    { 0x321506, 0x321516, 0x06, 0x0c, 0, 1  }, /* #67 */
    { 0x0d6ad3, 0x0d6216, 0x06, 0x0c, 0, 1  }, /* #67 b */
    { 0x0a7b57, 0x0a7356, 0x72, 0x00, 0, 8  }, /* #68 */
    { 0x350482, 0x350456, 0x72, 0x00, 0, 8  }, /* #68 b */
    { 0x131a52, 0x131a13, 0x50, 0x40, 0, 2  }, /* #69 */
    { 0x2c6587, 0x2c6d13, 0x50, 0x40, 0, 2  }, /* #69 b */
    { 0x3b7d52, 0x3b7d52, 0xe1, 0xe1, 0, 0  }, /* #70 */
    { 0x040287, 0x040287, 0xe1, 0xe1, 0, 0  }, /* #70 b */
    { 0x063947, 0x063193, 0x16, 0x80, 0, 6  }, /* #71 */
    { 0x394692, 0x394693, 0x16, 0x80, 0, 6  }, /* #71 b */
    { 0x3205d2, 0x320556, 0x6e, 0x00, 0, 18 }, /* #72 */
    { 0x0d7a07, 0x0d7256, 0x6e, 0x00, 0, 18 }, /* #72 b */
    { 0x107796, 0x107f17, 0xac, 0x60, 0, 3  }, /* #73 */
    { 0x2f0843, 0x2f0817, 0xac, 0x60, 0, 3  }, /* #73 b */
    { 0x151643, 0x151656, 0xda, 0x00, 0, 9  }, /* #74 */
    { 0x2a6996, 0x2a6156, 0xda, 0x00, 0, 9  }, /* #74 b */
    { 0x1f57c7, 0x1f5797, 0xe7, 0xc0, 0, 6  }, /* #75 */
    { 0x202812, 0x202097, 0xe7, 0xc0, 0, 6  }, /* #75 b */
    { 0x1f0047, 0x1f0056, 0x63, 0x00, 0, 15 }, /* #76 */
    { 0x207f92, 0x207756, 0x63, 0x00, 0, 15 }, /* #76 b */
    { 0x254143, 0x254156, 0xde, 0x00, 0, 30 }, /* #77 */
    { 0x1a3e96, 0x1a3656, 0xde, 0x00, 0, 30 }, /* #77 b */
    { 0x2300d6, 0x230056, 0x18, 0x00, 0, 12 }, /* #78 */
    { 0x1c7f03, 0x1c7756, 0x18, 0x00, 0, 12 }, /* #78 b */
    { 0x313d87, 0x313556, 0xb5, 0x00, 0, 17 }, /* #79 */
    { 0x0e4252, 0x0e4256, 0xb5, 0x00, 0, 17 }, /* #79 b */
    { 0x3c5343, 0x3c5356, 0x0b, 0x00, 0, 26 }, /* #80 */
    { 0x032c96, 0x032456, 0x0b, 0x00, 0, 26 }, /* #80 b */
    { 0x342dd7, 0x342556, 0xc6, 0x00, 0, 10 }, /* #81 */
    { 0x0b5202, 0x0b5256, 0xc6, 0x00, 0, 10 }, /* #81 b */
    { 0x272096, 0x272056, 0x2b, 0x00, 0, 28 }, /* #82 */
    { 0x185f43, 0x185756, 0x2b, 0x00, 0, 28 }, /* #82 b */
    { 0x0b1a53, 0x0b1a96, 0xac, 0xc0, 0, 4  }, /* #83 */
    { 0x346586, 0x346d96, 0xac, 0xc0, 0, 4  }, /* #83 b */
    { 0x264853, 0x264056, 0x34, 0x00, 0, 15 }, /* #84 */
    { 0x193786, 0x193756, 0x34, 0x00, 0, 15 }, /* #84 b */
    { 0x212983, 0x212156, 0xdb, 0x00, 0, 20 }, /* #85 */
    { 0x1e5656, 0x1e5656, 0xdb, 0x00, 0, 20 }, /* #85 b */
    { 0x0c2a96, 0x0c2256, 0x3b, 0x00, 0, 29 }, /* #86 */
    { 0x335543, 0x335556, 0x3b, 0x00, 0, 29 }, /* #86 b */
    { 0x373e16, 0x373656, 0x80, 0x00, 0, 8  }, /* #87 */
    { 0x0841c3, 0x084156, 0x80, 0x00, 0, 8  }, /* #87 b */
    { 0x361687, 0x361656, 0x9c, 0x00, 0, 24 }, /* #88 */
    { 0x096952, 0x096156, 0x9c, 0x00, 0, 24 }, /* #88 b */
    { 0x3c4c57, 0x3c4456, 0xa8, 0x00, 0, 30 }, /* #89 */
    { 0x033382, 0x033356, 0xa8, 0x00, 0, 30 }, /* #89 b */
    { 0x3f3e93, 0x3f3656, 0xc5, 0x00, 0, 9  }, /* #90 */
    { 0x004146, 0x004156, 0xc5, 0x00, 0, 9  }, /* #90 b */
    { 0x3b3606, 0x3b3656, 0xd7, 0x00, 0, 22 }, /* #91 */
    { 0x0449d3, 0x044156, 0xd7, 0x00, 0, 22 }, /* #91 b */
    { 0x056117, 0x056957, 0x57, 0x00, 0, 8  }, /* #92 */
    { 0x3a1ec2, 0x3a1e57, 0x57, 0x00, 0, 8  }, /* #92 b */
    { 0x3a1f96, 0x3a1756, 0x21, 0x00, 0, 28 }, /* #93 */
    { 0x056043, 0x056056, 0x21, 0x00, 0, 28 }, /* #93 b */
    { 0x201a16, 0x201216, 0x8a, 0x50, 0, 3  }, /* #94 */
    { 0x1f65c3, 0x1f6516, 0x8a, 0x50, 0, 3  }, /* #94 b */
    { 0x190056, 0x190056, 0xc3, 0x00, 0, 26 }, /* #95 */
    { 0x267f83, 0x267756, 0xc3, 0x00, 0, 26 }, /* #95 b */
};
uint32_t const g_cTests_shl_u8_amd = RT_ELEMENTS(g_aTests_shl_u8_amd);

BINU8_TEST_T const g_aTests_shr_u8_amd[] =
{
    { 0x2e5357, 0x2e5356, 0x00, 0x00, 0, 4  }, /* #0 */
    { 0x112c82, 0x112456, 0x00, 0x00, 0, 4  }, /* #0 b */
    { 0x3c6fd6, 0x3c6756, 0x00, 0x00, 0, 30 }, /* #1 */
    { 0x031003, 0x031056, 0x00, 0x00, 0, 30 }, /* #1 b */
    { 0x2d3d52, 0x2d3556, 0x00, 0x00, 0, 17 }, /* #2 */
    { 0x124287, 0x124256, 0x00, 0x00, 0, 17 }, /* #2 b */
    { 0x240c53, 0x240456, 0x00, 0x00, 0, 28 }, /* #3 */
    { 0x1b7386, 0x1b7356, 0x00, 0x00, 0, 28 }, /* #3 b */
    { 0x156796, 0x156756, 0x00, 0x00, 0, 11 }, /* #4 */
    { 0x2a1843, 0x2a1056, 0x00, 0x00, 0, 11 }, /* #4 b */
    { 0x063456, 0x063456, 0x00, 0x00, 0, 8  }, /* #5 */
    { 0x394b83, 0x394356, 0x00, 0x00, 0, 8  }, /* #5 b */
    { 0x077c13, 0x077456, 0x91, 0x00, 0, 30 }, /* #6 */
    { 0x3803c6, 0x380356, 0x91, 0x00, 0, 30 }, /* #6 b */
    { 0x091616, 0x091656, 0x1d, 0x00, 0, 14 }, /* #7 */
    { 0x3669c3, 0x366156, 0x1d, 0x00, 0, 14 }, /* #7 b */
    { 0x180f57, 0x180756, 0xd7, 0x00, 0, 28 }, /* #8 */
    { 0x277082, 0x277056, 0xd7, 0x00, 0, 28 }, /* #8 b */
    { 0x247ec2, 0x247656, 0x36, 0x00, 0, 19 }, /* #9 */
    { 0x1b0117, 0x1b0156, 0x36, 0x00, 0, 19 }, /* #9 b */
    { 0x2a0993, 0x2a0113, 0xf2, 0x01, 0, 7  }, /* #10 */
    { 0x157646, 0x157613, 0xf2, 0x01, 0, 7  }, /* #10 b */
    { 0x336896, 0x336056, 0x91, 0x00, 0, 10 }, /* #11 */
    { 0x0c1743, 0x0c1756, 0x91, 0x00, 0, 10 }, /* #11 b */
    { 0x2a4596, 0x2a4556, 0xf9, 0x00, 0, 17 }, /* #12 */
    { 0x153a43, 0x153256, 0xf9, 0x00, 0, 17 }, /* #12 b */
    { 0x315402, 0x315456, 0xed, 0x00, 0, 19 }, /* #13 */
    { 0x0e2bd7, 0x0e2356, 0xed, 0x00, 0, 19 }, /* #13 b */
    { 0x2c2713, 0x2c2756, 0x81, 0x00, 0, 29 }, /* #14 */
    { 0x1358c6, 0x135056, 0x81, 0x00, 0, 29 }, /* #14 b */
    { 0x1f3a12, 0x1f3256, 0xb6, 0x00, 0, 23 }, /* #15 */
    { 0x2045c7, 0x204556, 0xb6, 0x00, 0, 23 }, /* #15 b */
    { 0x1855c2, 0x185556, 0x51, 0x00, 0, 20 }, /* #16 */
    { 0x272a17, 0x272256, 0x51, 0x00, 0, 20 }, /* #16 b */
    { 0x1471c7, 0x147156, 0x1e, 0x00, 0, 28 }, /* #17 */
    { 0x2b0e12, 0x2b0656, 0x1e, 0x00, 0, 28 }, /* #17 b */
    { 0x374017, 0x374012, 0x47, 0x04, 0, 4  }, /* #18 */
    { 0x083fc2, 0x083712, 0x47, 0x04, 0, 4  }, /* #18 b */
    { 0x3747c3, 0x374712, 0x9c, 0x02, 0, 6  }, /* #19 */
    { 0x083816, 0x083012, 0x9c, 0x02, 0, 6  }, /* #19 b */
    { 0x371ac7, 0x371212, 0x94, 0x25, 0, 2  }, /* #20 */
    { 0x086512, 0x086512, 0x94, 0x25, 0, 2  }, /* #20 b */
    { 0x3f3242, 0x3f3256, 0x69, 0x00, 0, 15 }, /* #21 */
    { 0x004d97, 0x004556, 0x69, 0x00, 0, 15 }, /* #21 b */
    { 0x0e2543, 0x0e2d13, 0xdd, 0x6e, 0, 1  }, /* #22 */
    { 0x315a96, 0x315a13, 0xdd, 0x6e, 0, 1  }, /* #22 b */
    { 0x140ec2, 0x140656, 0xd4, 0x00, 0, 16 }, /* #23 */
    { 0x2b7117, 0x2b7156, 0xd4, 0x00, 0, 16 }, /* #23 b */
    { 0x3d51c7, 0x3d5156, 0x73, 0x00, 0, 8  }, /* #24 */
    { 0x022e12, 0x022656, 0x73, 0x00, 0, 8  }, /* #24 b */
    { 0x0321d6, 0x032156, 0x19, 0x00, 0, 23 }, /* #25 */
    { 0x3c5e03, 0x3c5656, 0x19, 0x00, 0, 23 }, /* #25 b */
    { 0x225986, 0x225156, 0x08, 0x00, 0, 21 }, /* #26 */
    { 0x1d2653, 0x1d2656, 0x08, 0x00, 0, 21 }, /* #26 b */
    { 0x1b2f02, 0x1b2756, 0x55, 0x00, 0, 20 }, /* #27 */
    { 0x2450d7, 0x245056, 0x55, 0x00, 0, 20 }, /* #27 b */
    { 0x2f4753, 0x2f4756, 0xe1, 0x00, 0, 24 }, /* #28 */
    { 0x103886, 0x103056, 0xe1, 0x00, 0, 24 }, /* #28 b */
    { 0x164b53, 0x164356, 0x3c, 0x00, 0, 27 }, /* #29 */
    { 0x293486, 0x293456, 0x3c, 0x00, 0, 27 }, /* #29 b */
    { 0x254ed6, 0x254656, 0xe9, 0x00, 0, 25 }, /* #30 */
    { 0x1a3103, 0x1a3156, 0xe9, 0x00, 0, 25 }, /* #30 b */
    { 0x0e7a17, 0x0e7256, 0x4c, 0x00, 0, 26 }, /* #31 */
    { 0x3105c2, 0x310556, 0x4c, 0x00, 0, 26 }, /* #31 b */
    { 0x102212, 0x102212, 0x21, 0x04, 0, 3  }, /* #32 */
    { 0x2f5dc7, 0x2f5512, 0x21, 0x04, 0, 3  }, /* #32 b */
    { 0x325fc2, 0x325756, 0xb2, 0x00, 0, 30 }, /* #33 */
    { 0x0d2017, 0x0d2056, 0xb2, 0x00, 0, 30 }, /* #33 b */
    { 0x0e5486, 0x0e5456, 0x27, 0x00, 0, 21 }, /* #34 */
    { 0x312b53, 0x312356, 0x27, 0x00, 0, 21 }, /* #34 b */
    { 0x3b0912, 0x3b0156, 0x23, 0x00, 0, 31 }, /* #35 */
    { 0x0476c7, 0x047656, 0x23, 0x00, 0, 31 }, /* #35 b */
    { 0x0c7a97, 0x0c7256, 0x3e, 0x00, 0, 29 }, /* #36 */
    { 0x330542, 0x330556, 0x3e, 0x00, 0, 29 }, /* #36 b */
    { 0x3d5947, 0x3d5156, 0x29, 0x00, 0, 10 }, /* #37 */
    { 0x022692, 0x022656, 0x29, 0x00, 0, 10 }, /* #37 b */
    { 0x0a1f86, 0x0a1756, 0xde, 0x00, 0, 20 }, /* #38 */
    { 0x356053, 0x356056, 0xde, 0x00, 0, 20 }, /* #38 b */
    { 0x142bd6, 0x142313, 0xb3, 0x02, 0, 6  }, /* #39 */
    { 0x2b5403, 0x2b5413, 0xb3, 0x02, 0, 6  }, /* #39 b */
    { 0x375e43, 0x375656, 0x64, 0x00, 0, 17 }, /* #40 */
    { 0x082196, 0x082156, 0x64, 0x00, 0, 17 }, /* #40 b */
    { 0x1b5782, 0x1b5756, 0xd5, 0x00, 0, 28 }, /* #41 */
    { 0x242857, 0x242056, 0xd5, 0x00, 0, 28 }, /* #41 b */
    { 0x032d96, 0x032556, 0x98, 0x00, 0, 13 }, /* #42 */
    { 0x3c5243, 0x3c5256, 0x98, 0x00, 0, 13 }, /* #42 b */
    { 0x091453, 0x091456, 0x25, 0x00, 0, 19 }, /* #43 */
    { 0x366b86, 0x366356, 0x25, 0x00, 0, 19 }, /* #43 b */
    { 0x166813, 0x166056, 0x64, 0x00, 0, 23 }, /* #44 */
    { 0x2917c6, 0x291756, 0x64, 0x00, 0, 23 }, /* #44 b */
    { 0x0e01d6, 0x0e0156, 0x6d, 0x00, 0, 29 }, /* #45 */
    { 0x317e03, 0x317656, 0x6d, 0x00, 0, 29 }, /* #45 b */
    { 0x086653, 0x086612, 0x58, 0x16, 0, 2  }, /* #46 */
    { 0x371986, 0x371112, 0x58, 0x16, 0, 2  }, /* #46 b */
    { 0x184e52, 0x184617, 0x54, 0x0a, 0, 3  }, /* #47 */
    { 0x273187, 0x273117, 0x54, 0x0a, 0, 3  }, /* #47 b */
    { 0x3d5746, 0x3d5717, 0x37, 0x1b, 0, 1  }, /* #48 */
    { 0x022893, 0x022017, 0x37, 0x1b, 0, 1  }, /* #48 b */
    { 0x0e2f86, 0x0e2756, 0x4c, 0x00, 0, 22 }, /* #49 */
    { 0x315053, 0x315056, 0x4c, 0x00, 0, 22 }, /* #49 b */
    { 0x3e1a06, 0x3e1256, 0x8a, 0x00, 0, 22 }, /* #50 */
    { 0x0165d3, 0x016556, 0x8a, 0x00, 0, 22 }, /* #50 b */
    { 0x304dc7, 0x304556, 0x25, 0x00, 0, 31 }, /* #51 */
    { 0x0f3212, 0x0f3256, 0x25, 0x00, 0, 31 }, /* #51 b */
    { 0x010e96, 0x010656, 0x20, 0x00, 0, 25 }, /* #52 */
    { 0x3e7143, 0x3e7156, 0x20, 0x00, 0, 25 }, /* #52 b */
    { 0x146d13, 0x146d13, 0xd5, 0xd5, 0, 0  }, /* #53 */
    { 0x2b12c6, 0x2b12c6, 0xd5, 0xd5, 0, 0  }, /* #53 b */
    { 0x081c17, 0x081456, 0x0d, 0x00, 0, 26 }, /* #54 */
    { 0x3763c2, 0x376356, 0x0d, 0x00, 0, 26 }, /* #54 b */
    { 0x081602, 0x081656, 0x8d, 0x00, 0, 18 }, /* #55 */
    { 0x3769d7, 0x376156, 0x8d, 0x00, 0, 18 }, /* #55 b */
    { 0x0f6dc7, 0x0f6d12, 0xe0, 0x70, 0, 1  }, /* #56 */
    { 0x301212, 0x301a12, 0xe0, 0x70, 0, 1  }, /* #56 b */
    { 0x302717, 0x302757, 0x89, 0x00, 0, 8  }, /* #57 */
    { 0x0f58c2, 0x0f5057, 0x89, 0x00, 0, 8  }, /* #57 b */
    { 0x2d5743, 0x2d5756, 0x5b, 0x00, 0, 31 }, /* #58 */
    { 0x122896, 0x122056, 0x5b, 0x00, 0, 31 }, /* #58 b */
    { 0x3d68d2, 0x3d68d2, 0xb8, 0xb8, 0, 0  }, /* #59 */
    { 0x021707, 0x021707, 0xb8, 0xb8, 0, 0  }, /* #59 b */
    { 0x0b4487, 0x0b4456, 0x85, 0x00, 0, 23 }, /* #60 */
    { 0x343b52, 0x343356, 0x85, 0x00, 0, 23 }, /* #60 b */
    { 0x0e3806, 0x0e3056, 0xc3, 0x00, 0, 10 }, /* #61 */
    { 0x3147d3, 0x314756, 0xc3, 0x00, 0, 10 }, /* #61 b */
    { 0x291896, 0x291056, 0x18, 0x00, 0, 24 }, /* #62 */
    { 0x166743, 0x166756, 0x18, 0x00, 0, 24 }, /* #62 b */
    { 0x245c12, 0x245456, 0xac, 0x00, 0, 27 }, /* #63 */
    { 0x1b23c7, 0x1b2356, 0xac, 0x00, 0, 27 }, /* #63 b */
    { 0x1044c2, 0x104456, 0x02, 0x00, 0, 25 }, /* #64 */
    { 0x2f3b17, 0x2f3356, 0x02, 0x00, 0, 25 }, /* #64 b */
    { 0x324193, 0x324156, 0xe0, 0x00, 0, 11 }, /* #65 */
    { 0x0d3e46, 0x0d3656, 0xe0, 0x00, 0, 11 }, /* #65 b */
    { 0x0a6507, 0x0a6556, 0xa4, 0x00, 0, 24 }, /* #66 */
    { 0x351ad2, 0x351256, 0xa4, 0x00, 0, 24 }, /* #66 b */
    { 0x3c5d07, 0x3c5556, 0x24, 0x00, 0, 26 }, /* #67 */
    { 0x0322d2, 0x032256, 0x24, 0x00, 0, 26 }, /* #67 b */
    { 0x045597, 0x045556, 0xf5, 0x00, 0, 11 }, /* #68 */
    { 0x3b2a42, 0x3b2256, 0xf5, 0x00, 0, 11 }, /* #68 b */
    { 0x195b12, 0x195356, 0x04, 0x00, 0, 17 }, /* #69 */
    { 0x2624c7, 0x262456, 0x04, 0x00, 0, 17 }, /* #69 b */
    { 0x1e5382, 0x1e5356, 0xa3, 0x00, 0, 13 }, /* #70 */
    { 0x212c57, 0x212456, 0xa3, 0x00, 0, 13 }, /* #70 b */
    { 0x3a0743, 0x3a0757, 0x0b, 0x00, 0, 4  }, /* #71 */
    { 0x057896, 0x057057, 0x0b, 0x00, 0, 4  }, /* #71 b */
    { 0x056256, 0x056256, 0x84, 0x00, 0, 12 }, /* #72 */
    { 0x3a1d83, 0x3a1556, 0x84, 0x00, 0, 12 }, /* #72 b */
    { 0x0321c2, 0x0321c2, 0xed, 0xed, 0, 0  }, /* #73 */
    { 0x3c5e17, 0x3c5e17, 0xed, 0xed, 0, 0  }, /* #73 b */
    { 0x307ad6, 0x307256, 0x72, 0x00, 0, 9  }, /* #74 */
    { 0x0f0503, 0x0f0556, 0x72, 0x00, 0, 9  }, /* #74 b */
    { 0x146cc2, 0x146456, 0x63, 0x00, 0, 25 }, /* #75 */
    { 0x2b1317, 0x2b1356, 0x63, 0x00, 0, 25 }, /* #75 b */
    { 0x1b51c7, 0x1b5156, 0x33, 0x00, 0, 13 }, /* #76 */
    { 0x242e12, 0x242656, 0x33, 0x00, 0, 13 }, /* #76 b */
    { 0x111997, 0x111156, 0x36, 0x00, 0, 24 }, /* #77 */
    { 0x2e6642, 0x2e6656, 0x36, 0x00, 0, 24 }, /* #77 b */
    { 0x3f0883, 0x3f0056, 0x7c, 0x00, 0, 24 }, /* #78 */
    { 0x007756, 0x007756, 0x7c, 0x00, 0, 24 }, /* #78 b */
    { 0x224842, 0x224056, 0x8a, 0x00, 0, 25 }, /* #79 */
    { 0x1d3797, 0x1d3756, 0x8a, 0x00, 0, 25 }, /* #79 b */
    { 0x203d86, 0x203556, 0x7e, 0x00, 0, 11 }, /* #80 */
    { 0x1f4253, 0x1f4256, 0x7e, 0x00, 0, 11 }, /* #80 b */
    { 0x386396, 0x386356, 0xa5, 0x00, 0, 24 }, /* #81 */
    { 0x071c43, 0x071456, 0xa5, 0x00, 0, 24 }, /* #81 b */
    { 0x1f2016, 0x1f2016, 0xbb, 0x17, 0, 3  }, /* #82 */
    { 0x205fc3, 0x205716, 0xbb, 0x17, 0, 3  }, /* #82 b */
    { 0x1401d3, 0x140156, 0x41, 0x00, 0, 15 }, /* #83 */
    { 0x2b7e06, 0x2b7656, 0x41, 0x00, 0, 15 }, /* #83 b */
    { 0x280586, 0x280556, 0x0e, 0x00, 0, 28 }, /* #84 */
    { 0x177a53, 0x177256, 0x0e, 0x00, 0, 28 }, /* #84 b */
    { 0x3473d2, 0x347356, 0xfd, 0x00, 0, 30 }, /* #85 */
    { 0x0b0c07, 0x0b0456, 0xfd, 0x00, 0, 30 }, /* #85 b */
    { 0x2a0517, 0x2a0556, 0xea, 0x00, 0, 21 }, /* #86 */
    { 0x157ac2, 0x157256, 0xea, 0x00, 0, 21 }, /* #86 b */
    { 0x3d7902, 0x3d7156, 0x64, 0x00, 0, 12 }, /* #87 */
    { 0x0206d7, 0x020656, 0x64, 0x00, 0, 12 }, /* #87 b */
    { 0x2b78d2, 0x2b7056, 0x1b, 0x00, 0, 21 }, /* #88 */
    { 0x140707, 0x140756, 0x1b, 0x00, 0, 21 }, /* #88 b */
    { 0x352296, 0x352256, 0x4c, 0x00, 0, 25 }, /* #89 */
    { 0x0a5d43, 0x0a5556, 0x4c, 0x00, 0, 25 }, /* #89 b */
    { 0x116356, 0x116356, 0xbf, 0x00, 0, 11 }, /* #90 */
    { 0x2e1c83, 0x2e1456, 0xbf, 0x00, 0, 11 }, /* #90 b */
    { 0x080046, 0x080046, 0x6e, 0x6e, 0, 0  }, /* #91 */
    { 0x377f93, 0x377f93, 0x6e, 0x6e, 0, 0  }, /* #91 b */
    { 0x300a57, 0x300213, 0x83, 0x20, 0, 2  }, /* #92 */
    { 0x0f7582, 0x0f7513, 0x83, 0x20, 0, 2  }, /* #92 b */
    { 0x010cc6, 0x010456, 0x01, 0x00, 0, 6  }, /* #93 */
    { 0x3e7313, 0x3e7356, 0x01, 0x00, 0, 6  }, /* #93 b */
    { 0x204f87, 0x204756, 0x7a, 0x00, 0, 23 }, /* #94 */
    { 0x1f3052, 0x1f3056, 0x7a, 0x00, 0, 23 }, /* #94 b */
    { 0x131b82, 0x131356, 0x4f, 0x00, 0, 19 }, /* #95 */
    { 0x2c6457, 0x2c6456, 0x4f, 0x00, 0, 19 }, /* #95 b */
};
uint32_t const g_cTests_shr_u8_amd = RT_ELEMENTS(g_aTests_shr_u8_amd);

BINU8_TEST_T const g_aTests_sar_u8_amd[] =
{
    { 0x3b34d6, 0x3b3456, 0x00, 0x00, 0, 16 }, /* #0 */
    { 0x044b03, 0x044356, 0x00, 0x00, 0, 16 }, /* #0 b */
    { 0x225b86, 0x225356, 0x00, 0x00, 0, 20 }, /* #1 */
    { 0x1d2453, 0x1d2456, 0x00, 0x00, 0, 20 }, /* #1 b */
    { 0x276f92, 0x276756, 0x00, 0x00, 0, 1  }, /* #2 */
    { 0x181047, 0x181056, 0x00, 0x00, 0, 1  }, /* #2 b */
    { 0x325ec3, 0x325656, 0x00, 0x00, 0, 8  }, /* #3 */
    { 0x0d2116, 0x0d2156, 0x00, 0x00, 0, 8  }, /* #3 b */
    { 0x3d0787, 0x3d0756, 0x00, 0x00, 0, 2  }, /* #4 */
    { 0x027852, 0x027056, 0x00, 0x00, 0, 2  }, /* #4 b */
    { 0x147ec6, 0x147656, 0x00, 0x00, 0, 30 }, /* #5 */
    { 0x2b0113, 0x2b0156, 0x00, 0x00, 0, 30 }, /* #5 b */
    { 0x112d86, 0x112596, 0xf8, 0xff, 0, 3  }, /* #6 */
    { 0x2e5253, 0x2e5296, 0xf8, 0xff, 0, 3  }, /* #6 b */
    { 0x1576d3, 0x157656, 0x5e, 0x00, 0, 21 }, /* #7 */
    { 0x2a0906, 0x2a0156, 0x5e, 0x00, 0, 21 }, /* #7 b */
    { 0x314343, 0x314397, 0xb2, 0xff, 0, 13 }, /* #8 */
    { 0x0e3c96, 0x0e3497, 0xb2, 0xff, 0, 13 }, /* #8 b */
    { 0x0d3f52, 0x0d3797, 0xd2, 0xff, 0, 23 }, /* #9 */
    { 0x324087, 0x324097, 0xd2, 0xff, 0, 23 }, /* #9 b */
    { 0x005997, 0x005156, 0x02, 0x00, 0, 13 }, /* #10 */
    { 0x3f2642, 0x3f2656, 0x02, 0x00, 0, 13 }, /* #10 b */
    { 0x167f96, 0x167756, 0x6a, 0x00, 0, 19 }, /* #11 */
    { 0x290043, 0x290056, 0x6a, 0x00, 0, 19 }, /* #11 b */
    { 0x294d03, 0x294556, 0x53, 0x00, 0, 24 }, /* #12 */
    { 0x1632d6, 0x163256, 0x53, 0x00, 0, 24 }, /* #12 b */
    { 0x2c0b82, 0x2c0356, 0x4d, 0x00, 0, 23 }, /* #13 */
    { 0x137457, 0x137456, 0x4d, 0x00, 0, 23 }, /* #13 b */
    { 0x0b47c3, 0x0b4797, 0xe3, 0xff, 0, 14 }, /* #14 */
    { 0x343816, 0x343097, 0xe3, 0xff, 0, 14 }, /* #14 b */
    { 0x0b6b13, 0x0b6397, 0x80, 0xff, 0, 31 }, /* #15 */
    { 0x3414c6, 0x341497, 0x80, 0xff, 0, 31 }, /* #15 b */
    { 0x3f0dd6, 0x3f0dd6, 0xe8, 0xe8, 0, 0  }, /* #16 */
    { 0x007203, 0x007203, 0xe8, 0xe8, 0, 0  }, /* #16 b */
    { 0x025492, 0x025497, 0xdf, 0xff, 0, 18 }, /* #17 */
    { 0x3d2b47, 0x3d2397, 0xdf, 0xff, 0, 18 }, /* #17 b */
    { 0x3b39c3, 0x3b3156, 0x60, 0x00, 0, 18 }, /* #18 */
    { 0x044616, 0x044656, 0x60, 0x00, 0, 18 }, /* #18 b */
    { 0x1d09d7, 0x1d0112, 0x26, 0x02, 0, 4  }, /* #19 */
    { 0x227602, 0x227612, 0x26, 0x02, 0, 4  }, /* #19 b */
    { 0x070896, 0x070097, 0xd7, 0xff, 0, 31 }, /* #20 */
    { 0x387743, 0x387797, 0xd7, 0xff, 0, 31 }, /* #20 b */
    { 0x157e87, 0x157697, 0xaf, 0xff, 0, 19 }, /* #21 */
    { 0x2a0152, 0x2a0197, 0xaf, 0xff, 0, 19 }, /* #21 b */
    { 0x066592, 0x066556, 0x6b, 0x00, 0, 9  }, /* #22 */
    { 0x391a47, 0x391256, 0x6b, 0x00, 0, 9  }, /* #22 b */
    { 0x1549c2, 0x154156, 0x5f, 0x00, 0, 20 }, /* #23 */
    { 0x2a3617, 0x2a3656, 0x5f, 0x00, 0, 20 }, /* #23 b */
    { 0x0b2e96, 0x0b2697, 0xe1, 0xff, 0, 28 }, /* #24 */
    { 0x345143, 0x345197, 0xe1, 0xff, 0, 28 }, /* #24 b */
    { 0x2b2a87, 0x2b2213, 0x38, 0x01, 0, 5  }, /* #25 */
    { 0x145552, 0x145513, 0x38, 0x01, 0, 5  }, /* #25 b */
    { 0x1c7bc3, 0x1c7393, 0xc7, 0xf8, 0, 3  }, /* #26 */
    { 0x230416, 0x230493, 0xc7, 0xf8, 0, 3  }, /* #26 b */
    { 0x344206, 0x344256, 0x29, 0x00, 0, 22 }, /* #27 */
    { 0x0b3dd3, 0x0b3556, 0x29, 0x00, 0, 22 }, /* #27 b */
    { 0x192487, 0x192497, 0xb5, 0xff, 0, 17 }, /* #28 */
    { 0x265b52, 0x265397, 0xb5, 0xff, 0, 17 }, /* #28 b */
    { 0x294797, 0x294797, 0xe2, 0xff, 0, 23 }, /* #29 */
    { 0x163842, 0x163097, 0xe2, 0xff, 0, 23 }, /* #29 b */
    { 0x295203, 0x295256, 0x62, 0x00, 0, 14 }, /* #30 */
    { 0x162dd6, 0x162556, 0x62, 0x00, 0, 14 }, /* #30 b */
    { 0x1e2cc3, 0x1e2497, 0xbb, 0xff, 0, 19 }, /* #31 */
    { 0x215316, 0x215397, 0xbb, 0xff, 0, 19 }, /* #31 b */
    { 0x214903, 0x214197, 0x82, 0xff, 0, 14 }, /* #32 */
    { 0x1e36d6, 0x1e3697, 0x82, 0xff, 0, 14 }, /* #32 b */
    { 0x3230d3, 0x323097, 0x84, 0xf0, 0, 3  }, /* #33 */
    { 0x0d4f06, 0x0d4797, 0x84, 0xf0, 0, 3  }, /* #33 b */
    { 0x0045c2, 0x004556, 0x1c, 0x00, 0, 31 }, /* #34 */
    { 0x3f3a17, 0x3f3256, 0x1c, 0x00, 0, 31 }, /* #34 b */
    { 0x346703, 0x346756, 0x24, 0x00, 0, 25 }, /* #35 */
    { 0x0b18d6, 0x0b1056, 0x24, 0x00, 0, 25 }, /* #35 b */
    { 0x3d1093, 0x3d1097, 0xf3, 0xff, 0, 13 }, /* #36 */
    { 0x026f46, 0x026797, 0xf3, 0xff, 0, 13 }, /* #36 b */
    { 0x356182, 0x356156, 0x10, 0x00, 0, 22 }, /* #37 */
    { 0x0a1e57, 0x0a1656, 0x10, 0x00, 0, 22 }, /* #37 b */
    { 0x232893, 0x232056, 0x67, 0x00, 0, 12 }, /* #38 */
    { 0x1c5746, 0x1c5756, 0x67, 0x00, 0, 12 }, /* #38 b */
    { 0x1d10d6, 0x1d1012, 0x45, 0x04, 0, 4  }, /* #39 */
    { 0x226f03, 0x226712, 0x45, 0x04, 0, 4  }, /* #39 b */
    { 0x276252, 0x276297, 0xfe, 0xff, 0, 15 }, /* #40 */
    { 0x181d87, 0x181597, 0xfe, 0xff, 0, 15 }, /* #40 b */
    { 0x342a97, 0x342297, 0x88, 0xff, 0, 28 }, /* #41 */
    { 0x0b5542, 0x0b5597, 0x88, 0xff, 0, 28 }, /* #41 b */
    { 0x116a43, 0x116a43, 0x18, 0x18, 0, 0  }, /* #42 */
    { 0x2e1596, 0x2e1596, 0x18, 0x18, 0, 0  }, /* #42 b */
    { 0x017283, 0x017297, 0x8f, 0xff, 0, 17 }, /* #43 */
    { 0x3e0d56, 0x3e0597, 0x8f, 0xff, 0, 17 }, /* #43 b */
    { 0x317c87, 0x317456, 0x0e, 0x00, 0, 19 }, /* #44 */
    { 0x0e0352, 0x0e0356, 0x0e, 0x00, 0, 19 }, /* #44 b */
    { 0x220846, 0x220097, 0xf9, 0xff, 0, 5  }, /* #45 */
    { 0x1d7793, 0x1d7797, 0xf9, 0xff, 0, 5  }, /* #45 b */
    { 0x0e0b92, 0x0e0396, 0xe8, 0xfa, 0, 2  }, /* #46 */
    { 0x317447, 0x317496, 0xe8, 0xfa, 0, 2  }, /* #46 b */
    { 0x226c97, 0x226497, 0x81, 0xff, 0, 25 }, /* #47 */
    { 0x1d1342, 0x1d1397, 0x81, 0xff, 0, 25 }, /* #47 b */
    { 0x0d5786, 0x0d5756, 0x28, 0x00, 0, 10 }, /* #48 */
    { 0x322853, 0x322056, 0x28, 0x00, 0, 10 }, /* #48 b */
    { 0x3d2997, 0x3d2197, 0xd1, 0xff, 0, 7  }, /* #49 */
    { 0x025642, 0x025697, 0xd1, 0xff, 0, 7  }, /* #49 b */
    { 0x060dc6, 0x060596, 0x8a, 0xc5, 0, 1  }, /* #50 */
    { 0x397213, 0x397296, 0x8a, 0xc5, 0, 1  }, /* #50 b */
    { 0x3b6807, 0x3b6097, 0xa2, 0xff, 0, 29 }, /* #51 */
    { 0x0417d2, 0x041797, 0xa2, 0xff, 0, 29 }, /* #51 b */
    { 0x2a1983, 0x2a1197, 0xc3, 0xff, 0, 26 }, /* #52 */
    { 0x156656, 0x156697, 0xc3, 0xff, 0, 26 }, /* #52 b */
    { 0x283202, 0x283202, 0x76, 0x76, 0, 0  }, /* #53 */
    { 0x174dd7, 0x174dd7, 0x76, 0x76, 0, 0  }, /* #53 b */
    { 0x3d02c2, 0x3d0256, 0x1c, 0x00, 0, 8  }, /* #54 */
    { 0x027d17, 0x027556, 0x1c, 0x00, 0, 8  }, /* #54 b */
    { 0x360686, 0x360697, 0xe4, 0xff, 0, 12 }, /* #55 */
    { 0x097953, 0x097197, 0xe4, 0xff, 0, 12 }, /* #55 b */
    { 0x347852, 0x347056, 0x48, 0x00, 0, 12 }, /* #56 */
    { 0x0b0787, 0x0b0756, 0x48, 0x00, 0, 12 }, /* #56 b */
    { 0x2d4186, 0x2d4197, 0xc4, 0xff, 0, 14 }, /* #57 */
    { 0x123e53, 0x123697, 0xc4, 0xff, 0, 14 }, /* #57 b */
    { 0x2d7147, 0x2d7197, 0xd1, 0xff, 0, 22 }, /* #58 */
    { 0x120e92, 0x120697, 0xd1, 0xff, 0, 22 }, /* #58 b */
    { 0x2b7152, 0x2b7156, 0x27, 0x00, 0, 9  }, /* #59 */
    { 0x140e87, 0x140656, 0x27, 0x00, 0, 9  }, /* #59 b */
    { 0x300886, 0x300056, 0x5d, 0x00, 0, 9  }, /* #60 */
    { 0x0f7753, 0x0f7756, 0x5d, 0x00, 0, 9  }, /* #60 b */
    { 0x310907, 0x310156, 0x53, 0x00, 0, 15 }, /* #61 */
    { 0x0e76d2, 0x0e7656, 0x53, 0x00, 0, 15 }, /* #61 b */
    { 0x342d87, 0x342597, 0xa7, 0xff, 0, 25 }, /* #62 */
    { 0x0b5252, 0x0b5297, 0xa7, 0xff, 0, 25 }, /* #62 b */
    { 0x114753, 0x114797, 0xe4, 0xff, 0, 18 }, /* #63 */
    { 0x2e3886, 0x2e3097, 0xe4, 0xff, 0, 18 }, /* #63 b */
    { 0x1011d2, 0x101197, 0xdf, 0xff, 0, 21 }, /* #64 */
    { 0x2f6e07, 0x2f6697, 0xdf, 0xff, 0, 21 }, /* #64 b */
    { 0x2435c7, 0x243556, 0x10, 0x00, 0, 8  }, /* #65 */
    { 0x1b4a12, 0x1b4256, 0x10, 0x00, 0, 8  }, /* #65 b */
    { 0x3d33c6, 0x3d3356, 0x6c, 0x00, 0, 8  }, /* #66 */
    { 0x024c13, 0x024456, 0x6c, 0x00, 0, 8  }, /* #66 b */
    { 0x1b1057, 0x1b1056, 0x1e, 0x00, 0, 22 }, /* #67 */
    { 0x246f82, 0x246756, 0x1e, 0x00, 0, 22 }, /* #67 b */
    { 0x062882, 0x062097, 0xec, 0xff, 0, 22 }, /* #68 */
    { 0x395757, 0x395797, 0xec, 0xff, 0, 22 }, /* #68 b */
    { 0x114c47, 0x114497, 0xf5, 0xff, 0, 5  }, /* #69 */
    { 0x2e3392, 0x2e3397, 0xf5, 0xff, 0, 5  }, /* #69 b */
    { 0x2e4496, 0x2e4456, 0x23, 0x00, 0, 25 }, /* #70 */
    { 0x113b43, 0x113356, 0x23, 0x00, 0, 25 }, /* #70 b */
    { 0x2f5ed3, 0x2f5656, 0x1a, 0x00, 0, 20 }, /* #71 */
    { 0x102106, 0x102156, 0x1a, 0x00, 0, 20 }, /* #71 b */
    { 0x350996, 0x350157, 0x31, 0x00, 0, 6  }, /* #72 */
    { 0x0a7643, 0x0a7657, 0x31, 0x00, 0, 6  }, /* #72 b */
    { 0x1d4047, 0x1d4097, 0xc5, 0xff, 0, 12 }, /* #73 */
    { 0x223f92, 0x223797, 0xc5, 0xff, 0, 12 }, /* #73 b */
    { 0x125fd3, 0x125797, 0xa2, 0xff, 0, 23 }, /* #74 */
    { 0x2d2006, 0x2d2097, 0xa2, 0xff, 0, 23 }, /* #74 b */
    { 0x3a2b97, 0x3a2317, 0x13, 0x09, 0, 1  }, /* #75 */
    { 0x055442, 0x055417, 0x13, 0x09, 0, 1  }, /* #75 b */
    { 0x0c4a17, 0x0c4292, 0xb4, 0xfb, 0, 4  }, /* #76 */
    { 0x3335c2, 0x333592, 0xb4, 0xfb, 0, 4  }, /* #76 b */
    { 0x184006, 0x184093, 0xbe, 0xf7, 0, 3  }, /* #77 */
    { 0x273fd3, 0x273793, 0xbe, 0xf7, 0, 3  }, /* #77 b */
    { 0x334ad7, 0x334297, 0xcc, 0xff, 0, 23 }, /* #78 */
    { 0x0c3502, 0x0c3597, 0xcc, 0xff, 0, 23 }, /* #78 b */
    { 0x3c4557, 0x3c4597, 0xee, 0xff, 0, 20 }, /* #79 */
    { 0x033a82, 0x033297, 0xee, 0xff, 0, 20 }, /* #79 b */
    { 0x041952, 0x041156, 0x45, 0x00, 0, 12 }, /* #80 */
    { 0x3b6687, 0x3b6656, 0x45, 0x00, 0, 12 }, /* #80 b */
    { 0x0d3e82, 0x0d3697, 0xd5, 0xff, 0, 19 }, /* #81 */
    { 0x324157, 0x324197, 0xd5, 0xff, 0, 19 }, /* #81 b */
    { 0x1d6386, 0x1d6356, 0x31, 0x00, 0, 7  }, /* #82 */
    { 0x221c53, 0x221456, 0x31, 0x00, 0, 7  }, /* #82 b */
    { 0x196c83, 0x196497, 0xc8, 0xff, 0, 16 }, /* #83 */
    { 0x261356, 0x261397, 0xc8, 0xff, 0, 16 }, /* #83 b */
    { 0x344dd6, 0x344593, 0x96, 0xf2, 0, 3  }, /* #84 */
    { 0x0b3203, 0x0b3293, 0x96, 0xf2, 0, 3  }, /* #84 b */
    { 0x3e5487, 0x3e5416, 0x1a, 0x03, 0, 3  }, /* #85 */
    { 0x012b52, 0x012316, 0x1a, 0x03, 0, 3  }, /* #85 b */
    { 0x3f3416, 0x3f3497, 0x82, 0xff, 0, 15 }, /* #86 */
    { 0x004bc3, 0x004397, 0x82, 0xff, 0, 15 }, /* #86 b */
    { 0x0f7417, 0x0f7456, 0x05, 0x00, 0, 7  }, /* #87 */
    { 0x300bc2, 0x300356, 0x05, 0x00, 0, 7  }, /* #87 b */
    { 0x220ec3, 0x220657, 0x1d, 0x00, 0, 5  }, /* #88 */
    { 0x1d7116, 0x1d7157, 0x1d, 0x00, 0, 5  }, /* #88 b */
    { 0x376b93, 0x376356, 0x73, 0x00, 0, 15 }, /* #89 */
    { 0x081446, 0x081456, 0x73, 0x00, 0, 15 }, /* #89 b */
    { 0x240f93, 0x240797, 0xf0, 0xff, 0, 18 }, /* #90 */
    { 0x1b7046, 0x1b7097, 0xf0, 0xff, 0, 18 }, /* #90 b */
    { 0x296d97, 0x296597, 0x84, 0xff, 0, 18 }, /* #91 */
    { 0x161242, 0x161297, 0x84, 0xff, 0, 18 }, /* #91 b */
    { 0x2e7b53, 0x2e7397, 0x84, 0xff, 0, 10 }, /* #92 */
    { 0x110486, 0x110497, 0x84, 0xff, 0, 10 }, /* #92 b */
    { 0x117a07, 0x117256, 0x2a, 0x00, 0, 28 }, /* #93 */
    { 0x2e05d2, 0x2e0556, 0x2a, 0x00, 0, 28 }, /* #93 b */
    { 0x0f12c2, 0x0f12c2, 0x72, 0x72, 0, 0  }, /* #94 */
    { 0x306d17, 0x306d17, 0x72, 0x72, 0, 0  }, /* #94 b */
    { 0x0e6056, 0x0e6097, 0x8e, 0xff, 0, 26 }, /* #95 */
    { 0x311f83, 0x311797, 0x8e, 0xff, 0, 26 }, /* #95 b */
};
uint32_t const g_cTests_sar_u8_amd = RT_ELEMENTS(g_aTests_sar_u8_amd);

BINU16_TEST_T const g_aTests_rol_u16_amd[] =
{
    { 0x242c86, 0x242486, 0x0000, 0x0000, 0, 4  }, /* #0 */
    { 0x1b5353, 0x1b5352, 0x0000, 0x0000, 0, 4  }, /* #0 b */
    { 0x0a37d3, 0x0a37d2, 0x0000, 0x0000, 0, 56 }, /* #1 */
    { 0x354806, 0x354006, 0x0000, 0x0000, 0, 56 }, /* #1 b */
    { 0x3765c7, 0x3765c6, 0x0000, 0x0000, 0, 57 }, /* #2 */
    { 0x081a12, 0x081212, 0x0000, 0x0000, 0, 57 }, /* #2 b */
    { 0x371e52, 0x371652, 0x0000, 0x0000, 0, 63 }, /* #3 */
    { 0x086187, 0x086186, 0x0000, 0x0000, 0, 63 }, /* #3 b */
    { 0x002593, 0x002592, 0x0000, 0x0000, 0, 12 }, /* #4 */
    { 0x3f5a46, 0x3f5246, 0x0000, 0x0000, 0, 12 }, /* #4 b */
    { 0x064d13, 0x064512, 0x0000, 0x0000, 0, 53 }, /* #5 */
    { 0x3932c6, 0x3932c6, 0x0000, 0x0000, 0, 53 }, /* #5 b */
    { 0x230856, 0x230857, 0x0ec2, 0x0761, 0, 15 }, /* #6 */
    { 0x1c7783, 0x1c7f83, 0x0ec2, 0x0761, 0, 15 }, /* #6 b */
    { 0x0031c2, 0x0039c3, 0xcbf9, 0x397f, 0, 45 }, /* #7 */
    { 0x3f4e17, 0x3f4e17, 0xcbf9, 0x397f, 0, 45 }, /* #7 b */
    { 0x361003, 0x361003, 0xe5eb, 0xcbd7, 0, 1  }, /* #8 */
    { 0x096fd6, 0x0967d7, 0xe5eb, 0xcbd7, 0, 1  }, /* #8 b */
    { 0x087ed2, 0x087ed3, 0x5747, 0x5d1d, 0, 18 }, /* #9 */
    { 0x370107, 0x370907, 0x5747, 0x5d1d, 0, 18 }, /* #9 b */
    { 0x376052, 0x376052, 0x784d, 0x784d, 0, 32 }, /* #10 */
    { 0x081f87, 0x081f87, 0x784d, 0x784d, 0, 32 }, /* #10 b */
    { 0x0f69c2, 0x0f69c2, 0x8718, 0xc438, 0, 27 }, /* #11 */
    { 0x301617, 0x301e16, 0x8718, 0xc438, 0, 27 }, /* #11 b */
    { 0x2110c2, 0x2110c2, 0x982d, 0x982d, 0, 32 }, /* #12 */
    { 0x1e6f17, 0x1e6f17, 0x982d, 0x982d, 0, 32 }, /* #12 b */
    { 0x0a3253, 0x0a3a53, 0x8860, 0x0c11, 0, 37 }, /* #13 */
    { 0x354d86, 0x354d87, 0x8860, 0x0c11, 0, 37 }, /* #13 b */
    { 0x2a6b42, 0x2a6b43, 0xa334, 0x28cd, 0, 30 }, /* #14 */
    { 0x151497, 0x151c97, 0xa334, 0x28cd, 0, 30 }, /* #14 b */
    { 0x174e13, 0x174e12, 0xd09d, 0xee84, 0, 27 }, /* #15 */
    { 0x2831c6, 0x2839c6, 0xd09d, 0xee84, 0, 27 }, /* #15 b */
    { 0x163143, 0x163143, 0x66a2, 0x66a2, 0, 32 }, /* #16 */
    { 0x294e96, 0x294e96, 0x66a2, 0x66a2, 0, 32 }, /* #16 b */
    { 0x341042, 0x341043, 0x53ba, 0xa53b, 0, 44 }, /* #17 */
    { 0x0b6f97, 0x0b6797, 0x53ba, 0xa53b, 0, 44 }, /* #17 b */
    { 0x132c86, 0x132487, 0x43f9, 0xf287, 0, 41 }, /* #18 */
    { 0x2c5353, 0x2c5353, 0x43f9, 0xf287, 0, 41 }, /* #18 b */
    { 0x301a83, 0x301a82, 0xb3a4, 0x9674, 0, 29 }, /* #19 */
    { 0x0f6556, 0x0f6d56, 0xb3a4, 0x9674, 0, 29 }, /* #19 b */
    { 0x1e5dd2, 0x1e55d3, 0x12e7, 0xc4b9, 0, 30 }, /* #20 */
    { 0x212207, 0x212207, 0x12e7, 0xc4b9, 0, 30 }, /* #20 b */
    { 0x196ac2, 0x196ac2, 0x9f94, 0xa4fc, 0, 43 }, /* #21 */
    { 0x261517, 0x261d16, 0x9f94, 0xa4fc, 0, 43 }, /* #21 b */
    { 0x284057, 0x284856, 0x535e, 0x9af2, 0, 51 }, /* #22 */
    { 0x173f82, 0x173f82, 0x535e, 0x9af2, 0, 51 }, /* #22 b */
    { 0x1636c2, 0x1636c3, 0x36bf, 0xb5f9, 0, 19 }, /* #23 */
    { 0x294917, 0x294117, 0x36bf, 0xb5f9, 0, 19 }, /* #23 b */
    { 0x3e3ec3, 0x3e3ec3, 0x987e, 0x30fd, 0, 33 }, /* #24 */
    { 0x014116, 0x014917, 0x987e, 0x30fd, 0, 33 }, /* #24 b */
    { 0x234b16, 0x234b17, 0x4520, 0x0229, 0, 43 }, /* #25 */
    { 0x1c34c3, 0x1c3cc3, 0x4520, 0x0229, 0, 43 }, /* #25 b */
    { 0x0c2516, 0x0c2d16, 0x23ea, 0x8fa8, 0, 2  }, /* #26 */
    { 0x335ac3, 0x335ac2, 0x23ea, 0x8fa8, 0, 2  }, /* #26 b */
    { 0x3d2842, 0x3d2043, 0xc21d, 0xc21d, 0, 16 }, /* #27 */
    { 0x025797, 0x025797, 0xc21d, 0xc21d, 0, 16 }, /* #27 b */
    { 0x340ed7, 0x340ed6, 0xcfa5, 0xfa5c, 0, 52 }, /* #28 */
    { 0x0b7102, 0x0b7902, 0xcfa5, 0xfa5c, 0, 52 }, /* #28 b */
    { 0x080b03, 0x080303, 0xc6d1, 0x8da3, 0, 1  }, /* #29 */
    { 0x3774d6, 0x3774d7, 0xc6d1, 0x8da3, 0, 1  }, /* #29 b */
    { 0x234993, 0x234192, 0x433f, 0x67e8, 0, 5  }, /* #30 */
    { 0x1c3646, 0x1c3646, 0x433f, 0x67e8, 0, 5  }, /* #30 b */
    { 0x2b3246, 0x2b3246, 0x6773, 0x6cee, 0, 45 }, /* #31 */
    { 0x144d93, 0x144592, 0x6773, 0x6cee, 0, 45 }, /* #31 b */
    { 0x0d1b43, 0x0d1b43, 0x9d75, 0x59d7, 0, 12 }, /* #32 */
    { 0x326496, 0x326c97, 0x9d75, 0x59d7, 0, 12 }, /* #32 b */
    { 0x3f3a53, 0x3f3a53, 0xefbe, 0xefbe, 0, 0  }, /* #33 */
    { 0x004586, 0x004586, 0xefbe, 0xefbe, 0, 0  }, /* #33 b */
    { 0x193117, 0x193117, 0x1aad, 0xa355, 0, 29 }, /* #34 */
    { 0x264ec2, 0x2646c3, 0x1aad, 0xa355, 0, 29 }, /* #34 b */
    { 0x0e7446, 0x0e7c47, 0x9490, 0x2129, 0, 57 }, /* #35 */
    { 0x310b93, 0x310b93, 0x9490, 0x2129, 0, 57 }, /* #35 b */
    { 0x227596, 0x227596, 0x255d, 0x55d2, 0, 52 }, /* #36 */
    { 0x1d0a43, 0x1d0242, 0x255d, 0x55d2, 0, 52 }, /* #36 b */
    { 0x193543, 0x193d43, 0x4166, 0x320b, 0, 27 }, /* #37 */
    { 0x264a96, 0x264a97, 0x4166, 0x320b, 0, 27 }, /* #37 b */
    { 0x3e69d3, 0x3e69d2, 0x12d2, 0x9096, 0, 11 }, /* #38 */
    { 0x011606, 0x011e06, 0x12d2, 0x9096, 0, 11 }, /* #38 b */
    { 0x3c4b96, 0x3c4b97, 0x9988, 0x1133, 0, 25 }, /* #39 */
    { 0x033443, 0x033c43, 0x9988, 0x1133, 0, 25 }, /* #39 b */
    { 0x381106, 0x381906, 0x197d, 0xfa32, 0, 25 }, /* #40 */
    { 0x076ed3, 0x076ed2, 0x197d, 0xfa32, 0, 25 }, /* #40 b */
    { 0x357053, 0x357053, 0x9eb5, 0xacf5, 0, 59 }, /* #41 */
    { 0x0a0f86, 0x0a0787, 0x9eb5, 0xacf5, 0, 59 }, /* #41 b */
    { 0x040bc2, 0x0403c2, 0x4058, 0x5840, 0, 8  }, /* #42 */
    { 0x3b7417, 0x3b7416, 0x4058, 0x5840, 0, 8  }, /* #42 b */
    { 0x256a16, 0x256a17, 0x1e37, 0x1b8f, 0, 39 }, /* #43 */
    { 0x1a15c3, 0x1a1dc3, 0x1e37, 0x1b8f, 0, 39 }, /* #43 b */
    { 0x187d83, 0x187582, 0x4b83, 0x1a5c, 0, 43 }, /* #44 */
    { 0x270256, 0x270256, 0x4b83, 0x1a5c, 0, 43 }, /* #44 b */
    { 0x3d5686, 0x3d5687, 0x4a6b, 0xad29, 0, 10 }, /* #45 */
    { 0x022953, 0x022153, 0x4a6b, 0xad29, 0, 10 }, /* #45 b */
    { 0x2f2646, 0x2f2e47, 0x1a86, 0x430d, 0, 55 }, /* #46 */
    { 0x105993, 0x105993, 0x1a86, 0x430d, 0, 55 }, /* #46 b */
    { 0x1939d3, 0x1939d3, 0xa317, 0x18bd, 0, 35 }, /* #47 */
    { 0x264606, 0x264e07, 0xa317, 0x18bd, 0, 35 }, /* #47 b */
    { 0x104d97, 0x104d97, 0xeab1, 0x558f, 0, 35 }, /* #48 */
    { 0x2f3242, 0x2f3a43, 0xeab1, 0x558f, 0, 35 }, /* #48 b */
    { 0x021343, 0x021b42, 0xfafa, 0xbebe, 0, 22 }, /* #49 */
    { 0x3d6c96, 0x3d6c96, 0xfafa, 0xbebe, 0, 22 }, /* #49 b */
    { 0x0c0096, 0x0c0896, 0xbdcd, 0xdbdc, 0, 60 }, /* #50 */
    { 0x337f43, 0x337f42, 0xbdcd, 0xdbdc, 0, 60 }, /* #50 b */
    { 0x372a82, 0x372a83, 0xa2ac, 0x1565, 0, 35 }, /* #51 */
    { 0x085557, 0x085d57, 0xa2ac, 0x1565, 0, 35 }, /* #51 b */
    { 0x125282, 0x125a82, 0xb6c3, 0xdb0e, 0, 50 }, /* #52 */
    { 0x2d2d57, 0x2d2d56, 0xb6c3, 0xdb0e, 0, 50 }, /* #52 b */
    { 0x391413, 0x391c13, 0xba71, 0x1ba7, 0, 12 }, /* #53 */
    { 0x066bc6, 0x066bc7, 0xba71, 0x1ba7, 0, 12 }, /* #53 b */
    { 0x275147, 0x275946, 0xed5b, 0xdf6a, 0, 27 }, /* #54 */
    { 0x182e92, 0x182e92, 0xed5b, 0xdf6a, 0, 27 }, /* #54 b */
    { 0x056302, 0x056b02, 0xf249, 0x93e4, 0, 57 }, /* #55 */
    { 0x3a1cd7, 0x3a1cd6, 0xf249, 0x93e4, 0, 57 }, /* #55 b */
    { 0x180c93, 0x180c92, 0x9426, 0x9426, 0, 16 }, /* #56 */
    { 0x277346, 0x277b46, 0x9426, 0x9426, 0, 16 }, /* #56 b */
    { 0x310bd3, 0x3103d3, 0x67c7, 0xf1d9, 0, 22 }, /* #57 */
    { 0x0e7406, 0x0e7407, 0x67c7, 0xf1d9, 0, 22 }, /* #57 b */
    { 0x1925c7, 0x192dc6, 0x65e6, 0xf332, 0, 23 }, /* #58 */
    { 0x265a12, 0x265a12, 0x65e6, 0xf332, 0, 23 }, /* #58 b */
    { 0x310996, 0x310997, 0x0d96, 0x2c1b, 0, 9  }, /* #59 */
    { 0x0e7643, 0x0e7e43, 0x0d96, 0x2c1b, 0, 9  }, /* #59 b */
    { 0x0f1cc7, 0x0f14c6, 0xeb85, 0x17ae, 0, 26 }, /* #60 */
    { 0x306312, 0x306312, 0xeb85, 0x17ae, 0, 26 }, /* #60 b */
    { 0x113b16, 0x113316, 0x9787, 0x7978, 0, 44 }, /* #61 */
    { 0x2e44c3, 0x2e44c2, 0x9787, 0x7978, 0, 44 }, /* #61 b */
    { 0x311716, 0x311716, 0x22a8, 0x4550, 0, 1  }, /* #62 */
    { 0x0e68c3, 0x0e60c2, 0x22a8, 0x4550, 0, 1  }, /* #62 b */
    { 0x065492, 0x065492, 0x3f97, 0x7f2e, 0, 33 }, /* #63 */
    { 0x392b47, 0x392346, 0x3f97, 0x7f2e, 0, 33 }, /* #63 b */
    { 0x1f6003, 0x1f6802, 0x50a6, 0xa650, 0, 56 }, /* #64 */
    { 0x201fd6, 0x201fd6, 0x50a6, 0xa650, 0, 56 }, /* #64 b */
    { 0x224602, 0x224e02, 0x0609, 0xc120, 0, 5  }, /* #65 */
    { 0x1d39d7, 0x1d39d6, 0x0609, 0xc120, 0, 5  }, /* #65 b */
    { 0x3d1b82, 0x3d1383, 0xaa0d, 0xaa0d, 0, 48 }, /* #66 */
    { 0x026457, 0x026457, 0xaa0d, 0xaa0d, 0, 48 }, /* #66 b */
    { 0x100d12, 0x100d12, 0x0b56, 0xac16, 0, 57 }, /* #67 */
    { 0x2f72c7, 0x2f7ac6, 0x0b56, 0xac16, 0, 57 }, /* #67 b */
    { 0x144a52, 0x144a53, 0x24e6, 0x2731, 0, 35 }, /* #68 */
    { 0x2b3587, 0x2b3d87, 0x24e6, 0x2731, 0, 35 }, /* #68 b */
    { 0x026897, 0x026096, 0x7e6d, 0x6d7e, 0, 40 }, /* #69 */
    { 0x3d1742, 0x3d1742, 0x7e6d, 0x6d7e, 0, 40 }, /* #69 b */
    { 0x3a7202, 0x3a7202, 0x5214, 0x290a, 0, 47 }, /* #70 */
    { 0x050dd7, 0x0505d6, 0x5214, 0x290a, 0, 47 }, /* #70 b */
    { 0x214747, 0x214f46, 0x3c07, 0xe780, 0, 29 }, /* #71 */
    { 0x1e3892, 0x1e3892, 0x3c07, 0xe780, 0, 29 }, /* #71 b */
    { 0x376753, 0x376f52, 0x282c, 0xa0b0, 0, 2  }, /* #72 */
    { 0x081886, 0x081886, 0x282c, 0xa0b0, 0, 2  }, /* #72 b */
    { 0x367857, 0x367057, 0x0864, 0x9021, 0, 58 }, /* #73 */
    { 0x090782, 0x090783, 0x0864, 0x9021, 0, 58 }, /* #73 b */
    { 0x136483, 0x136482, 0x14b2, 0x4296, 0, 61 }, /* #74 */
    { 0x2c1b56, 0x2c1356, 0x14b2, 0x4296, 0, 61 }, /* #74 b */
    { 0x305982, 0x305183, 0x733c, 0x9e39, 0, 55 }, /* #75 */
    { 0x0f2657, 0x0f2657, 0x733c, 0x9e39, 0, 55 }, /* #75 b */
    { 0x170ed2, 0x170ed3, 0xbabe, 0x5d5f, 0, 31 }, /* #76 */
    { 0x287107, 0x287907, 0xbabe, 0x5d5f, 0, 31 }, /* #76 b */
    { 0x061c03, 0x061403, 0x08ff, 0xfc23, 0, 42 }, /* #77 */
    { 0x3963d6, 0x3963d7, 0x08ff, 0xfc23, 0, 42 }, /* #77 b */
    { 0x060896, 0x060897, 0x7624, 0x23b1, 0, 59 }, /* #78 */
    { 0x397743, 0x397f43, 0x7624, 0x23b1, 0, 59 }, /* #78 b */
    { 0x1a0957, 0x1a0156, 0x2c24, 0x242c, 0, 24 }, /* #79 */
    { 0x257682, 0x257682, 0x2c24, 0x242c, 0, 24 }, /* #79 b */
    { 0x022ad3, 0x0222d3, 0x0ca6, 0x8329, 0, 46 }, /* #80 */
    { 0x3d5506, 0x3d5507, 0x0ca6, 0x8329, 0, 46 }, /* #80 b */
    { 0x1b1002, 0x1b1003, 0xb8a5, 0x8a5b, 0, 36 }, /* #81 */
    { 0x246fd7, 0x2467d7, 0xb8a5, 0x8a5b, 0, 36 }, /* #81 b */
    { 0x044387, 0x044b87, 0x24ea, 0x5127, 0, 43 }, /* #82 */
    { 0x3b3c52, 0x3b3c53, 0x24ea, 0x5127, 0, 43 }, /* #82 b */
    { 0x194e43, 0x194e42, 0x2859, 0x8592, 0, 36 }, /* #83 */
    { 0x263196, 0x263996, 0x2859, 0x8592, 0, 36 }, /* #83 b */
    { 0x027bc3, 0x0273c3, 0xfc60, 0xf8c1, 0, 49 }, /* #84 */
    { 0x3d0416, 0x3d0417, 0xfc60, 0xf8c1, 0, 49 }, /* #84 b */
    { 0x3d6282, 0x3d6283, 0x7eee, 0x9fbb, 0, 46 }, /* #85 */
    { 0x021d57, 0x021557, 0x7eee, 0x9fbb, 0, 46 }, /* #85 b */
    { 0x182ec2, 0x182ec3, 0x130c, 0x0c13, 0, 24 }, /* #86 */
    { 0x275117, 0x275917, 0x130c, 0x0c13, 0, 24 }, /* #86 b */
    { 0x3c7c86, 0x3c7c87, 0x6722, 0x3391, 0, 31 }, /* #87 */
    { 0x030353, 0x030b53, 0x6722, 0x3391, 0, 31 }, /* #87 b */
    { 0x2740d6, 0x2740d6, 0x636b, 0x36b6, 0, 52 }, /* #88 */
    { 0x183f03, 0x183702, 0x636b, 0x36b6, 0, 52 }, /* #88 b */
    { 0x094ed2, 0x094ed2, 0x9c5b, 0xdce2, 0, 59 }, /* #89 */
    { 0x363107, 0x363906, 0x9c5b, 0xdce2, 0, 59 }, /* #89 b */
    { 0x344407, 0x344c07, 0xb54a, 0x6a95, 0, 33 }, /* #90 */
    { 0x0b3bd2, 0x0b3bd3, 0xb54a, 0x6a95, 0, 33 }, /* #90 b */
    { 0x2a5cd2, 0x2a5cd3, 0x0ab4, 0x6815, 0, 9  }, /* #91 */
    { 0x152307, 0x152b07, 0x0ab4, 0x6815, 0, 9  }, /* #91 b */
    { 0x241bd7, 0x2413d6, 0x0e80, 0x3a00, 0, 2  }, /* #92 */
    { 0x1b6402, 0x1b6402, 0x0e80, 0x3a00, 0, 2  }, /* #92 b */
    { 0x376b56, 0x376b57, 0xacd2, 0x6695, 0, 19 }, /* #93 */
    { 0x081483, 0x081c83, 0xacd2, 0x6695, 0, 19 }, /* #93 b */
    { 0x366f06, 0x366f07, 0xf9d9, 0x3f3b, 0, 45 }, /* #94 */
    { 0x0910d3, 0x0918d3, 0xf9d9, 0x3f3b, 0, 45 }, /* #94 b */
    { 0x192386, 0x192386, 0x8809, 0x1310, 0, 41 }, /* #95 */
    { 0x265c53, 0x265452, 0x8809, 0x1310, 0, 41 }, /* #95 b */
};
uint32_t const g_cTests_rol_u16_amd = RT_ELEMENTS(g_aTests_rol_u16_amd);

BINU16_TEST_T const g_aTests_ror_u16_amd[] =
{
    { 0x2b3913, 0x2b3112, 0x0000, 0x0000, 0, 1  }, /* #0 */
    { 0x1446c6, 0x1446c6, 0x0000, 0x0000, 0, 1  }, /* #0 b */
    { 0x096bc7, 0x0963c6, 0x0000, 0x0000, 0, 11 }, /* #1 */
    { 0x361412, 0x361412, 0x0000, 0x0000, 0, 11 }, /* #1 b */
    { 0x3b1b57, 0x3b1356, 0x0000, 0x0000, 0, 29 }, /* #2 */
    { 0x046482, 0x046482, 0x0000, 0x0000, 0, 29 }, /* #2 b */
    { 0x110012, 0x110012, 0x0000, 0x0000, 0, 37 }, /* #3 */
    { 0x2e7fc7, 0x2e77c6, 0x0000, 0x0000, 0, 37 }, /* #3 b */
    { 0x052cd2, 0x0524d2, 0x0000, 0x0000, 0, 18 }, /* #4 */
    { 0x3a5307, 0x3a5306, 0x0000, 0x0000, 0, 18 }, /* #4 b */
    { 0x2d1087, 0x2d1086, 0x0000, 0x0000, 0, 16 }, /* #5 */
    { 0x126f52, 0x126752, 0x0000, 0x0000, 0, 16 }, /* #5 b */
    { 0x211302, 0x211b03, 0x31a1, 0xa131, 0, 56 }, /* #6 */
    { 0x1e6cd7, 0x1e6cd7, 0x31a1, 0xa131, 0, 56 }, /* #6 b */
    { 0x211803, 0x211802, 0x9429, 0x4ca1, 0, 5  }, /* #7 */
    { 0x1e67d6, 0x1e6fd6, 0x9429, 0x4ca1, 0, 5  }, /* #7 b */
    { 0x312547, 0x312546, 0x6fec, 0x37f6, 0, 49 }, /* #8 */
    { 0x0e5a92, 0x0e5292, 0x6fec, 0x37f6, 0, 49 }, /* #8 b */
    { 0x1b6447, 0x1b6c46, 0xfb46, 0x7da3, 0, 49 }, /* #9 */
    { 0x241b92, 0x241b92, 0xfb46, 0x7da3, 0, 49 }, /* #9 b */
    { 0x330046, 0x330846, 0xab72, 0x5b95, 0, 29 }, /* #10 */
    { 0x0c7f93, 0x0c7f92, 0xab72, 0x5b95, 0, 29 }, /* #10 b */
    { 0x107853, 0x107052, 0x4858, 0x1612, 0, 26 }, /* #11 */
    { 0x2f0786, 0x2f0786, 0x4858, 0x1612, 0, 26 }, /* #11 b */
    { 0x237053, 0x237052, 0x55f0, 0x157c, 0, 34 }, /* #12 */
    { 0x1c0f86, 0x1c0786, 0x55f0, 0x157c, 0, 34 }, /* #12 b */
    { 0x322f57, 0x322f56, 0x2beb, 0x657d, 0, 19 }, /* #13 */
    { 0x0d5082, 0x0d5882, 0x2beb, 0x657d, 0, 19 }, /* #13 b */
    { 0x052246, 0x052a46, 0xed28, 0x51da, 0, 55 }, /* #14 */
    { 0x3a5d93, 0x3a5d92, 0xed28, 0x51da, 0, 55 }, /* #14 b */
    { 0x262287, 0x262a86, 0x126e, 0x4dc2, 0, 27 }, /* #15 */
    { 0x195d52, 0x195d52, 0x126e, 0x4dc2, 0, 27 }, /* #15 b */
    { 0x074f53, 0x074752, 0x4414, 0x2888, 0, 39 }, /* #16 */
    { 0x383086, 0x383086, 0x4414, 0x2888, 0, 39 }, /* #16 b */
    { 0x0158c3, 0x0158c3, 0x0de5, 0x9437, 0, 54 }, /* #17 */
    { 0x3e2716, 0x3e2f17, 0x0de5, 0x9437, 0, 54 }, /* #17 b */
    { 0x336e43, 0x336e42, 0x014d, 0x5340, 0, 42 }, /* #18 */
    { 0x0c1196, 0x0c1996, 0x014d, 0x5340, 0, 42 }, /* #18 b */
    { 0x2c2646, 0x2c2647, 0xfcea, 0xf9d5, 0, 31 }, /* #19 */
    { 0x135993, 0x135193, 0xfcea, 0xf9d5, 0, 31 }, /* #19 b */
    { 0x077e42, 0x077e42, 0xf279, 0x7c9e, 0, 2  }, /* #20 */
    { 0x380197, 0x380996, 0xf279, 0x7c9e, 0, 2  }, /* #20 b */
    { 0x025817, 0x025016, 0x1caf, 0x2bc7, 0, 58 }, /* #21 */
    { 0x3d27c2, 0x3d27c2, 0x1caf, 0x2bc7, 0, 58 }, /* #21 b */
    { 0x061596, 0x061d97, 0x4cdf, 0x9be9, 0, 11 }, /* #22 */
    { 0x396a43, 0x396a43, 0x4cdf, 0x9be9, 0, 11 }, /* #22 b */
    { 0x1d18d3, 0x1d18d2, 0x65c9, 0x7259, 0, 58 }, /* #23 */
    { 0x226706, 0x226f06, 0x65c9, 0x7259, 0, 58 }, /* #23 b */
    { 0x2c3a03, 0x2c3202, 0xc4db, 0x26de, 0, 13 }, /* #24 */
    { 0x1345d6, 0x1345d6, 0xc4db, 0x26de, 0, 13 }, /* #24 b */
    { 0x1b0212, 0x1b0213, 0x2d75, 0xd4b5, 0, 6  }, /* #25 */
    { 0x247dc7, 0x2475c7, 0x2d75, 0xd4b5, 0, 6  }, /* #25 b */
    { 0x3b61d2, 0x3b69d2, 0x93a3, 0x4727, 0, 39 }, /* #26 */
    { 0x041e07, 0x041e06, 0x93a3, 0x4727, 0, 39 }, /* #26 b */
    { 0x292bd6, 0x292bd7, 0xe7d1, 0x8f3e, 0, 5  }, /* #27 */
    { 0x165403, 0x165c03, 0xe7d1, 0x8f3e, 0, 5  }, /* #27 b */
    { 0x296ec2, 0x2966c3, 0xcdd2, 0xd2cd, 0, 40 }, /* #28 */
    { 0x161117, 0x161117, 0xcdd2, 0xd2cd, 0, 40 }, /* #28 b */
    { 0x381002, 0x381802, 0xc4ea, 0x589d, 0, 35 }, /* #29 */
    { 0x076fd7, 0x076fd6, 0xc4ea, 0x589d, 0, 35 }, /* #29 b */
    { 0x2e5b12, 0x2e5312, 0xe845, 0x17a1, 0, 22 }, /* #30 */
    { 0x1124c7, 0x1124c6, 0xe845, 0x17a1, 0, 22 }, /* #30 b */
    { 0x3574c7, 0x3574c6, 0xb228, 0x1645, 0, 3  }, /* #31 */
    { 0x0a0b12, 0x0a0312, 0xb228, 0x1645, 0, 3  }, /* #31 b */
    { 0x317217, 0x317216, 0x048c, 0x1809, 0, 7  }, /* #32 */
    { 0x0e0dc2, 0x0e05c2, 0x048c, 0x1809, 0, 7  }, /* #32 b */
    { 0x176492, 0x176c92, 0x7d5e, 0x579f, 0, 26 }, /* #33 */
    { 0x281b47, 0x281b46, 0x7d5e, 0x579f, 0, 26 }, /* #33 b */
    { 0x3a5897, 0x3a5097, 0xa30f, 0xd187, 0, 1  }, /* #34 */
    { 0x052742, 0x052743, 0xa30f, 0xd187, 0, 1  }, /* #34 b */
    { 0x250e53, 0x250653, 0x5c7d, 0xeae3, 0, 37 }, /* #35 */
    { 0x1a7186, 0x1a7187, 0x5c7d, 0xeae3, 0, 37 }, /* #35 b */
    { 0x155b97, 0x155b96, 0x893a, 0x4ea2, 0, 58 }, /* #36 */
    { 0x2a2442, 0x2a2c42, 0x893a, 0x4ea2, 0, 58 }, /* #36 b */
    { 0x273f47, 0x273747, 0xdc3e, 0xedc3, 0, 52 }, /* #37 */
    { 0x184092, 0x184093, 0xdc3e, 0xedc3, 0, 52 }, /* #37 b */
    { 0x3a1e03, 0x3a1e03, 0x211b, 0x908d, 0, 17 }, /* #38 */
    { 0x0561d6, 0x0569d7, 0x211b, 0x908d, 0, 17 }, /* #38 b */
    { 0x0c0b96, 0x0c0397, 0xd0ba, 0xd0ba, 0, 48 }, /* #39 */
    { 0x337443, 0x337443, 0xd0ba, 0xd0ba, 0, 48 }, /* #39 b */
    { 0x1c6496, 0x1c6496, 0x6405, 0x2b20, 0, 21 }, /* #40 */
    { 0x231b43, 0x231342, 0x6405, 0x2b20, 0, 21 }, /* #40 b */
    { 0x060083, 0x060082, 0x420b, 0x1684, 0, 23 }, /* #41 */
    { 0x397f56, 0x397756, 0x420b, 0x1684, 0, 23 }, /* #41 b */
    { 0x063157, 0x063156, 0xa532, 0x2995, 0, 13 }, /* #42 */
    { 0x394e82, 0x394682, 0xa532, 0x2995, 0, 13 }, /* #42 b */
    { 0x0e3ec7, 0x0e3ec7, 0x0fc6, 0x8c1f, 0, 39 }, /* #43 */
    { 0x314112, 0x314913, 0x0fc6, 0x8c1f, 0, 39 }, /* #43 b */
    { 0x1121d2, 0x1121d3, 0xe5e7, 0xe7e5, 0, 40 }, /* #44 */
    { 0x2e5e07, 0x2e5607, 0xe5e7, 0xe7e5, 0, 40 }, /* #44 b */
    { 0x0e7203, 0x0e7203, 0xf502, 0xf502, 0, 16 }, /* #45 */
    { 0x310dd6, 0x3105d7, 0xf502, 0xf502, 0, 16 }, /* #45 b */
    { 0x220a96, 0x220297, 0x5173, 0xe6a2, 0, 23 }, /* #46 */
    { 0x1d7543, 0x1d7543, 0x5173, 0xe6a2, 0, 23 }, /* #46 b */
    { 0x2f45d7, 0x2f4dd6, 0x5f6b, 0x6b5f, 0, 40 }, /* #47 */
    { 0x103a02, 0x103a02, 0x5f6b, 0x6b5f, 0, 40 }, /* #47 b */
    { 0x2b7693, 0x2b7e93, 0x494d, 0x94d4, 0, 44 }, /* #48 */
    { 0x140946, 0x140947, 0x494d, 0x94d4, 0, 44 }, /* #48 b */
    { 0x0715c6, 0x071dc7, 0x3f77, 0x9fbb, 0, 49 }, /* #49 */
    { 0x386a13, 0x386a13, 0x3f77, 0x9fbb, 0, 49 }, /* #49 b */
    { 0x023e53, 0x023e53, 0x1d6d, 0x8eb6, 0, 1  }, /* #50 */
    { 0x3d4186, 0x3d4987, 0x1d6d, 0x8eb6, 0, 1  }, /* #50 b */
    { 0x3a5796, 0x3a5797, 0xcd21, 0xd21c, 0, 60 }, /* #51 */
    { 0x052843, 0x052043, 0xcd21, 0xd21c, 0, 60 }, /* #51 b */
    { 0x156802, 0x156002, 0xc655, 0x1957, 0, 46 }, /* #52 */
    { 0x2a17d7, 0x2a17d6, 0xc655, 0x1957, 0, 46 }, /* #52 b */
    { 0x312d12, 0x312512, 0xb811, 0x2370, 0, 39 }, /* #53 */
    { 0x0e52c7, 0x0e52c6, 0xb811, 0x2370, 0, 39 }, /* #53 b */
    { 0x1024c7, 0x102cc6, 0x4f3b, 0x79da, 0, 61 }, /* #54 */
    { 0x2f5b12, 0x2f5b12, 0x4f3b, 0x79da, 0, 61 }, /* #54 b */
    { 0x377957, 0x377156, 0x0c03, 0x00c3, 0, 26 }, /* #55 */
    { 0x080682, 0x080682, 0x0c03, 0x00c3, 0, 26 }, /* #55 b */
    { 0x130f56, 0x130757, 0xd6ae, 0xed6a, 0, 52 }, /* #56 */
    { 0x2c7083, 0x2c7083, 0xd6ae, 0xed6a, 0, 52 }, /* #56 b */
    { 0x270107, 0x270906, 0xaad1, 0x68d5, 0, 25 }, /* #57 */
    { 0x187ed2, 0x187ed2, 0xaad1, 0x68d5, 0, 25 }, /* #57 b */
    { 0x242012, 0x242812, 0x3991, 0x44e6, 0, 38 }, /* #58 */
    { 0x1b5fc7, 0x1b5fc6, 0x3991, 0x44e6, 0, 38 }, /* #58 b */
    { 0x182012, 0x182812, 0xaf5c, 0x7ae5, 0, 45 }, /* #59 */
    { 0x275fc7, 0x275fc6, 0xaf5c, 0x7ae5, 0, 45 }, /* #59 b */
    { 0x222402, 0x222403, 0xd34a, 0xd2b4, 0, 10 }, /* #60 */
    { 0x1d5bd7, 0x1d53d7, 0xd34a, 0xd2b4, 0, 10 }, /* #60 b */
    { 0x0b69d6, 0x0b61d7, 0xf113, 0xf113, 0, 16 }, /* #61 */
    { 0x341603, 0x341603, 0xf113, 0xf113, 0, 16 }, /* #61 b */
    { 0x3b76d3, 0x3b7ed2, 0xf2ea, 0x5d5e, 0, 43 }, /* #62 */
    { 0x040906, 0x040906, 0xf2ea, 0x5d5e, 0, 43 }, /* #62 b */
    { 0x053a47, 0x053a46, 0x5452, 0x5254, 0, 24 }, /* #63 */
    { 0x3a4592, 0x3a4d92, 0x5452, 0x5254, 0, 24 }, /* #63 b */
    { 0x3b4886, 0x3b4887, 0x9b5d, 0xbb36, 0, 55 }, /* #64 */
    { 0x043753, 0x043f53, 0x9b5d, 0xbb36, 0, 55 }, /* #64 b */
    { 0x3d1d97, 0x3d1596, 0xe522, 0x22e5, 0, 56 }, /* #65 */
    { 0x026242, 0x026242, 0xe522, 0x22e5, 0, 56 }, /* #65 b */
    { 0x1b1c93, 0x1b1c93, 0xc974, 0xa64b, 0, 21 }, /* #66 */
    { 0x246346, 0x246b47, 0xc974, 0xa64b, 0, 21 }, /* #66 b */
    { 0x2546c7, 0x254ec6, 0x67cb, 0x6cf9, 0, 19 }, /* #67 */
    { 0x1a3912, 0x1a3912, 0x67cb, 0x6cf9, 0, 19 }, /* #67 b */
    { 0x337287, 0x337a86, 0xa809, 0x5013, 0, 63 }, /* #68 */
    { 0x0c0d52, 0x0c0d52, 0xa809, 0x5013, 0, 63 }, /* #68 b */
    { 0x106787, 0x106786, 0xe06a, 0x0357, 0, 13 }, /* #69 */
    { 0x2f1852, 0x2f1052, 0xe06a, 0x0357, 0, 13 }, /* #69 b */
    { 0x2844c3, 0x2844c2, 0x12c5, 0x12c5, 0, 48 }, /* #70 */
    { 0x173b16, 0x173316, 0x12c5, 0x12c5, 0, 48 }, /* #70 b */
    { 0x1d61d7, 0x1d61d6, 0x92fd, 0x25fb, 0, 63 }, /* #71 */
    { 0x221e02, 0x221602, 0x92fd, 0x25fb, 0, 63 }, /* #71 b */
    { 0x342a13, 0x342212, 0x0731, 0x1cc4, 0, 46 }, /* #72 */
    { 0x0b55c6, 0x0b55c6, 0x0731, 0x1cc4, 0, 46 }, /* #72 b */
    { 0x3272d3, 0x327ad2, 0xd2cb, 0x597a, 0, 59 }, /* #73 */
    { 0x0d0d06, 0x0d0d06, 0xd2cb, 0x597a, 0, 59 }, /* #73 b */
    { 0x0b6c43, 0x0b6442, 0x9031, 0x0319, 0, 44 }, /* #74 */
    { 0x341396, 0x341396, 0x9031, 0x0319, 0, 44 }, /* #74 b */
    { 0x1f2796, 0x1f2f97, 0xa928, 0xa928, 0, 16 }, /* #75 */
    { 0x205843, 0x205843, 0xa928, 0xa928, 0, 16 }, /* #75 b */
    { 0x237bc7, 0x2373c6, 0x33b9, 0x33b9, 0, 16 }, /* #76 */
    { 0x1c0412, 0x1c0412, 0x33b9, 0x33b9, 0, 16 }, /* #76 b */
    { 0x284c97, 0x284496, 0x8811, 0x1188, 0, 24 }, /* #77 */
    { 0x173342, 0x173342, 0x8811, 0x1188, 0, 24 }, /* #77 b */
    { 0x195c96, 0x195c96, 0x511f, 0x47d4, 0, 58 }, /* #78 */
    { 0x262343, 0x262b42, 0x511f, 0x47d4, 0, 58 }, /* #78 b */
    { 0x041253, 0x041a53, 0xe1bd, 0x86f7, 0, 62 }, /* #79 */
    { 0x3b6d86, 0x3b6d87, 0xe1bd, 0x86f7, 0, 62 }, /* #79 b */
    { 0x0f4782, 0x0f4783, 0x6f0f, 0xede1, 0, 3  }, /* #80 */
    { 0x303857, 0x303057, 0x6f0f, 0xede1, 0, 3  }, /* #80 b */
    { 0x263cd7, 0x2634d7, 0x1ba2, 0xdd10, 0, 29 }, /* #81 */
    { 0x194302, 0x194303, 0x1ba2, 0xdd10, 0, 29 }, /* #81 b */
    { 0x0a3e47, 0x0a3e47, 0xf0a4, 0x93c2, 0, 22 }, /* #82 */
    { 0x354192, 0x354993, 0xf0a4, 0x93c2, 0, 22 }, /* #82 b */
    { 0x3d2f52, 0x3d2752, 0x4650, 0x0465, 0, 20 }, /* #83 */
    { 0x025087, 0x025086, 0x4650, 0x0465, 0, 20 }, /* #83 b */
    { 0x1b0a47, 0x1b0247, 0x873d, 0xcf61, 0, 42 }, /* #84 */
    { 0x247592, 0x247593, 0x873d, 0xcf61, 0, 42 }, /* #84 b */
    { 0x311853, 0x311053, 0x4a47, 0xe948, 0, 51 }, /* #85 */
    { 0x0e6786, 0x0e6787, 0x4a47, 0xe948, 0, 51 }, /* #85 b */
    { 0x2a4052, 0x2a4052, 0xa316, 0x2d46, 0, 7  }, /* #86 */
    { 0x153f87, 0x153786, 0xa316, 0x2d46, 0, 7  }, /* #86 b */
    { 0x190e52, 0x190652, 0xc9fc, 0x327f, 0, 34 }, /* #87 */
    { 0x267187, 0x267186, 0xc9fc, 0x327f, 0, 34 }, /* #87 b */
    { 0x044dd7, 0x0445d6, 0x6099, 0x2658, 0, 26 }, /* #88 */
    { 0x3b3202, 0x3b3202, 0x6099, 0x2658, 0, 26 }, /* #88 b */
    { 0x337f86, 0x337786, 0x840d, 0x3610, 0, 38 }, /* #89 */
    { 0x0c0053, 0x0c0052, 0x840d, 0x3610, 0, 38 }, /* #89 b */
    { 0x2f5457, 0x2f5457, 0x85d9, 0xcc2e, 0, 21 }, /* #90 */
    { 0x102b82, 0x102383, 0x85d9, 0xcc2e, 0, 21 }, /* #90 b */
    { 0x372312, 0x372b12, 0xd2f3, 0x79e9, 0, 57 }, /* #91 */
    { 0x085cc7, 0x085cc6, 0xd2f3, 0x79e9, 0, 57 }, /* #91 b */
    { 0x3b6f93, 0x3b6f92, 0x8806, 0x6880, 0, 52 }, /* #92 */
    { 0x041046, 0x041846, 0x8806, 0x6880, 0, 52 }, /* #92 b */
    { 0x0a1dd6, 0x0a15d6, 0x1971, 0x1197, 0, 52 }, /* #93 */
    { 0x356203, 0x356202, 0x1971, 0x1197, 0, 52 }, /* #93 b */
    { 0x2b7fd2, 0x2b7fd3, 0xd365, 0xba6c, 0, 3  }, /* #94 */
    { 0x140007, 0x140807, 0xd365, 0xba6c, 0, 3  }, /* #94 b */
    { 0x3d3257, 0x3d3256, 0x5fb0, 0x0bf6, 0, 35 }, /* #95 */
    { 0x024d82, 0x024582, 0x5fb0, 0x0bf6, 0, 35 }, /* #95 b */
};
uint32_t const g_cTests_ror_u16_amd = RT_ELEMENTS(g_aTests_ror_u16_amd);

BINU16_TEST_T const g_aTests_rcl_u16_amd[] =
{
    { 0x283a12, 0x283212, 0x0000, 0x0000, 0, 58 }, /* #0 */
    { 0x1745c7, 0x1745c6, 0x0000, 0x0100, 0, 58 }, /* #0 b */
    { 0x264742, 0x264742, 0x0000, 0x0000, 0, 20 }, /* #1 */
    { 0x193897, 0x193096, 0x0000, 0x0004, 0, 20 }, /* #1 b */
    { 0x3b5003, 0x3b5002, 0x0000, 0x0200, 0, 42 }, /* #2 */
    { 0x042fd6, 0x0427d6, 0x0000, 0x0000, 0, 42 }, /* #2 b */
    { 0x370e56, 0x370656, 0x0000, 0x0000, 0, 30 }, /* #3 */
    { 0x087183, 0x087182, 0x0000, 0x1000, 0, 30 }, /* #3 b */
    { 0x0532d6, 0x0532d6, 0x0000, 0x0000, 0, 8  }, /* #4 */
    { 0x3a4d03, 0x3a4502, 0x0000, 0x0080, 0, 8  }, /* #4 b */
    { 0x122942, 0x122142, 0x0000, 0x0000, 0, 62 }, /* #5 */
    { 0x2d5697, 0x2d5696, 0x0000, 0x1000, 0, 62 }, /* #5 b */
    { 0x2529d7, 0x2521d7, 0x9e5e, 0x9e5e, 0, 17 }, /* #6 */
    { 0x1a5602, 0x1a5e02, 0x9e5e, 0x9e5e, 0, 17 }, /* #6 b */
    { 0x0b5e06, 0x0b5e07, 0x9334, 0x2668, 0, 33 }, /* #7 */
    { 0x3421d3, 0x3429d3, 0x9334, 0x2669, 0, 33 }, /* #7 b */
    { 0x385083, 0x385882, 0x8e1d, 0xe1dc, 0, 21 }, /* #8 */
    { 0x072f56, 0x072f56, 0x8e1d, 0xe1d4, 0, 21 }, /* #8 b */
    { 0x146f07, 0x146f07, 0xe5bb, 0x6efc, 0, 6  }, /* #9 */
    { 0x2b10d2, 0x2b18d3, 0xe5bb, 0x6edc, 0, 6  }, /* #9 b */
    { 0x097b93, 0x097392, 0x890c, 0x1989, 0, 26 }, /* #10 */
    { 0x360446, 0x360446, 0x890c, 0x1889, 0, 26 }, /* #10 b */
    { 0x1f5ec7, 0x1f56c6, 0x0ce3, 0x3867, 0, 44 }, /* #11 */
    { 0x202112, 0x202112, 0x0ce3, 0x3067, 0, 44 }, /* #11 b */
    { 0x360803, 0x360002, 0x3b91, 0x6772, 0, 14 }, /* #12 */
    { 0x0977d6, 0x0977d6, 0x3b91, 0x4772, 0, 14 }, /* #12 b */
    { 0x311582, 0x311583, 0x21c3, 0x8870, 0, 15 }, /* #13 */
    { 0x0e6a57, 0x0e6257, 0x21c3, 0xc870, 0, 15 }, /* #13 b */
    { 0x0c5717, 0x0c5717, 0xdd4c, 0xd4ce, 0, 21 }, /* #14 */
    { 0x3328c2, 0x3320c3, 0xdd4c, 0xd4c6, 0, 21 }, /* #14 b */
    { 0x023396, 0x023397, 0xee3c, 0x8f1d, 0, 23 }, /* #15 */
    { 0x3d4c43, 0x3d4443, 0xee3c, 0x8f3d, 0, 23 }, /* #15 b */
    { 0x043d03, 0x043503, 0x9a20, 0xa20c, 0, 21 }, /* #16 */
    { 0x3b42d6, 0x3b42d7, 0x9a20, 0xa204, 0, 21 }, /* #16 b */
    { 0x112153, 0x112952, 0x5b80, 0xdc05, 0, 35 }, /* #17 */
    { 0x2e5e86, 0x2e5e86, 0x5b80, 0xdc01, 0, 35 }, /* #17 b */
    { 0x2c7417, 0x2c7c16, 0x63b4, 0xc769, 0, 1  }, /* #18 */
    { 0x130bc2, 0x130bc2, 0x63b4, 0xc768, 0, 1  }, /* #18 b */
    { 0x3b3d53, 0x3b3553, 0x6df8, 0xb7e2, 0, 19 }, /* #19 */
    { 0x044286, 0x044287, 0x6df8, 0xb7e0, 0, 19 }, /* #19 b */
    { 0x3f6dc2, 0x3f65c3, 0x74d0, 0xa074, 0, 41 }, /* #20 */
    { 0x001217, 0x001217, 0x74d0, 0xa174, 0, 41 }, /* #20 b */
    { 0x137f83, 0x137f83, 0xbaa4, 0x526e, 0, 39 }, /* #21 */
    { 0x2c0056, 0x2c0857, 0xbaa4, 0x522e, 0, 39 }, /* #21 b */
    { 0x3d1297, 0x3d1a96, 0x5a4a, 0xb495, 0, 50 }, /* #22 */
    { 0x026d42, 0x026d42, 0x5a4a, 0xb494, 0, 50 }, /* #22 b */
    { 0x3c5d13, 0x3c5d12, 0x15f4, 0xfa45, 0, 39 }, /* #23 */
    { 0x0322c6, 0x032ac6, 0x15f4, 0xfa05, 0, 39 }, /* #23 b */
    { 0x002d07, 0x002d07, 0x6a92, 0x2b54, 0, 61 }, /* #24 */
    { 0x3f52d2, 0x3f5ad3, 0x6a92, 0x2354, 0, 61 }, /* #24 b */
    { 0x277103, 0x277903, 0x0ae9, 0x74c2, 0, 39 }, /* #25 */
    { 0x180ed6, 0x180ed7, 0x0ae9, 0x7482, 0, 39 }, /* #25 b */
    { 0x361ac7, 0x361ac7, 0x04f3, 0x3ce0, 0, 38 }, /* #26 */
    { 0x096512, 0x096d13, 0x04f3, 0x3cc0, 0, 38 }, /* #26 b */
    { 0x2524c7, 0x252cc7, 0x3da4, 0x27b4, 0, 14 }, /* #27 */
    { 0x1a5b12, 0x1a5b13, 0x3da4, 0x07b4, 0, 14 }, /* #27 b */
    { 0x340817, 0x340816, 0x51aa, 0x8d55, 0, 52 }, /* #28 */
    { 0x0b77c2, 0x0b7fc2, 0x51aa, 0x8d51, 0, 52 }, /* #28 b */
    { 0x1b4a53, 0x1b4253, 0x60f7, 0xec1e, 0, 46 }, /* #29 */
    { 0x243586, 0x243587, 0x60f7, 0xcc1e, 0, 46 }, /* #29 b */
    { 0x342386, 0x342b86, 0xbdb7, 0xdbaf, 0, 39 }, /* #30 */
    { 0x0b5c53, 0x0b5c52, 0xbdb7, 0xdbef, 0, 39 }, /* #30 b */
    { 0x332d86, 0x332d87, 0xd80f, 0x6c07, 0, 16 }, /* #31 */
    { 0x0c5253, 0x0c5253, 0xd80f, 0xec07, 0, 16 }, /* #31 b */
    { 0x200a17, 0x200a16, 0x35d8, 0xec4d, 0, 7  }, /* #32 */
    { 0x1f75c2, 0x1f7dc2, 0x35d8, 0xec0d, 0, 7  }, /* #32 b */
    { 0x262c83, 0x262482, 0xd10c, 0x33a2, 0, 42 }, /* #33 */
    { 0x195356, 0x195356, 0xd10c, 0x31a2, 0, 42 }, /* #33 b */
    { 0x1c1f92, 0x1c1f93, 0x6d46, 0x518d, 0, 23 }, /* #34 */
    { 0x236047, 0x236847, 0x6d46, 0x51ad, 0, 23 }, /* #34 b */
    { 0x1d4b82, 0x1d4b83, 0x901b, 0x01b4, 0, 36 }, /* #35 */
    { 0x223457, 0x223c57, 0x901b, 0x01bc, 0, 36 }, /* #35 b */
    { 0x123c53, 0x123453, 0x1f9a, 0xa8fc, 0, 12 }, /* #36 */
    { 0x2d4386, 0x2d4387, 0x1f9a, 0xa0fc, 0, 12 }, /* #36 b */
    { 0x162406, 0x162c07, 0x37de, 0x0df7, 0, 47 }, /* #37 */
    { 0x295bd3, 0x295bd3, 0x37de, 0x4df7, 0, 47 }, /* #37 b */
    { 0x353356, 0x353b56, 0x3a5c, 0xe970, 0, 51 }, /* #38 */
    { 0x0a4c83, 0x0a4c82, 0x3a5c, 0xe972, 0, 51 }, /* #38 b */
    { 0x300e86, 0x300e86, 0x2d53, 0xa98b, 0, 7  }, /* #39 */
    { 0x0f7153, 0x0f7952, 0x2d53, 0xa9cb, 0, 7  }, /* #39 b */
    { 0x1f2713, 0x1f2712, 0x002f, 0x17c0, 0, 24 }, /* #40 */
    { 0x2058c6, 0x2050c6, 0x002f, 0x1780, 0, 24 }, /* #40 b */
    { 0x145ac6, 0x1452c7, 0x3b02, 0xd810, 0, 35 }, /* #41 */
    { 0x2b2513, 0x2b2513, 0x3b02, 0xd814, 0, 35 }, /* #41 b */
    { 0x112592, 0x112592, 0x8ca0, 0x1194, 0, 31 }, /* #42 */
    { 0x2e5a47, 0x2e5246, 0x8ca0, 0x3194, 0, 31 }, /* #42 b */
    { 0x3c2192, 0x3c2992, 0xcd2a, 0xa669, 0, 44 }, /* #43 */
    { 0x035e47, 0x035e46, 0xcd2a, 0xae69, 0, 44 }, /* #43 b */
    { 0x3d4b92, 0x3d4b93, 0xbaa5, 0x54ab, 0, 22 }, /* #44 */
    { 0x023447, 0x023c47, 0xbaa5, 0x54bb, 0, 22 }, /* #44 b */
    { 0x2a0316, 0x2a0316, 0xb85e, 0x5e5c, 0, 25 }, /* #45 */
    { 0x157cc3, 0x1574c2, 0xb85e, 0x5edc, 0, 25 }, /* #45 b */
    { 0x3673c7, 0x3673c7, 0x5aa6, 0x5aa6, 0, 0  }, /* #46 */
    { 0x090c12, 0x090c12, 0x5aa6, 0x5aa6, 0, 0  }, /* #46 b */
    { 0x345182, 0x345982, 0x96db, 0x96db, 0, 49 }, /* #47 */
    { 0x0b2e57, 0x0b2657, 0x96db, 0x96db, 0, 49 }, /* #47 b */
    { 0x212c17, 0x212416, 0x8198, 0x0663, 0, 34 }, /* #48 */
    { 0x1e53c2, 0x1e53c2, 0x8198, 0x0661, 0, 34 }, /* #48 b */
    { 0x0813d3, 0x0813d3, 0xf392, 0xe725, 0, 18 }, /* #49 */
    { 0x376c06, 0x376407, 0xf392, 0xe724, 0, 18 }, /* #49 b */
    { 0x260a13, 0x260212, 0xafa4, 0x4d7d, 0, 61 }, /* #50 */
    { 0x1975c6, 0x1975c6, 0xafa4, 0x457d, 0, 61 }, /* #50 b */
    { 0x0e2802, 0x0e2802, 0x2b1e, 0x2b1e, 0, 0  }, /* #51 */
    { 0x3157d7, 0x3157d7, 0x2b1e, 0x2b1e, 0, 0  }, /* #51 b */
    { 0x0b6842, 0x0b6843, 0xd4fd, 0x4fd6, 0, 53 }, /* #52 */
    { 0x341797, 0x341f97, 0xd4fd, 0x4fde, 0, 53 }, /* #52 b */
    { 0x2345c6, 0x234dc7, 0x3c87, 0x1e43, 0, 48 }, /* #53 */
    { 0x1c3a13, 0x1c3213, 0x3c87, 0x9e43, 0, 48 }, /* #53 b */
    { 0x1d4517, 0x1d4d16, 0xce2e, 0xe717, 0, 16 }, /* #54 */
    { 0x223ac2, 0x2232c2, 0xce2e, 0x6717, 0, 16 }, /* #54 b */
    { 0x381a86, 0x381287, 0x6a01, 0xa804, 0, 34 }, /* #55 */
    { 0x076553, 0x076553, 0x6a01, 0xa806, 0, 34 }, /* #55 b */
    { 0x127dc6, 0x127dc6, 0x8863, 0xd10c, 0, 14 }, /* #56 */
    { 0x2d0213, 0x2d0a12, 0x8863, 0xf10c, 0, 14 }, /* #56 b */
    { 0x052a16, 0x052216, 0x86f0, 0x4378, 0, 16 }, /* #57 */
    { 0x3a55c3, 0x3a5dc2, 0x86f0, 0xc378, 0, 16 }, /* #57 b */
    { 0x3b7906, 0x3b7907, 0xeb7c, 0x7c75, 0, 40 }, /* #58 */
    { 0x0406d3, 0x040ed3, 0xeb7c, 0x7cf5, 0, 40 }, /* #58 b */
    { 0x393643, 0x393e42, 0xfea6, 0x9bfd, 0, 10 }, /* #59 */
    { 0x064996, 0x064996, 0xfea6, 0x99fd, 0, 10 }, /* #59 b */
    { 0x1b3407, 0x1b3406, 0x7ed3, 0x77ed, 0, 13 }, /* #60 */
    { 0x244bd2, 0x2443d2, 0x7ed3, 0x67ed, 0, 13 }, /* #60 b */
    { 0x326357, 0x326356, 0xa68d, 0x68dd, 0, 36 }, /* #61 */
    { 0x0d1c82, 0x0d1482, 0xa68d, 0x68d5, 0, 36 }, /* #61 b */
    { 0x121742, 0x121742, 0x98f2, 0x98f2, 0, 32 }, /* #62 */
    { 0x2d6897, 0x2d6897, 0x98f2, 0x98f2, 0, 32 }, /* #62 b */
    { 0x030606, 0x030e07, 0x692d, 0x2d34, 0, 40 }, /* #63 */
    { 0x3c79d3, 0x3c79d3, 0x692d, 0x2db4, 0, 40 }, /* #63 b */
    { 0x2771c2, 0x2771c2, 0xe050, 0x0a0e, 0, 5  }, /* #64 */
    { 0x180e17, 0x180616, 0xe050, 0x0a1e, 0, 5  }, /* #64 b */
    { 0x301cd3, 0x3014d3, 0x3a12, 0xd094, 0, 35 }, /* #65 */
    { 0x0f6306, 0x0f6307, 0x3a12, 0xd090, 0, 35 }, /* #65 b */
    { 0x3d7812, 0x3d7012, 0xb073, 0x1cd6, 0, 55 }, /* #66 */
    { 0x0207c7, 0x0207c6, 0xb073, 0x1cf6, 0, 55 }, /* #66 b */
    { 0x377ac6, 0x377ac7, 0x12ca, 0x6504, 0, 39 }, /* #67 */
    { 0x080513, 0x080d13, 0x12ca, 0x6544, 0, 39 }, /* #67 b */
    { 0x0c4c86, 0x0c4486, 0x6338, 0x0c67, 0, 31 }, /* #68 */
    { 0x333353, 0x333352, 0x6338, 0x2c67, 0, 31 }, /* #68 b */
    { 0x1a3296, 0x1a3a96, 0xf626, 0x99ec, 0, 10 }, /* #69 */
    { 0x254d43, 0x254d42, 0xf626, 0x9bec, 0, 10 }, /* #69 b */
    { 0x084b17, 0x084b16, 0x7c35, 0xd6f8, 0, 59 }, /* #70 */
    { 0x3734c2, 0x373cc2, 0x7c35, 0xd4f8, 0, 59 }, /* #70 b */
    { 0x0f0082, 0x0f0882, 0xcef1, 0xef16, 0, 36 }, /* #71 */
    { 0x307f57, 0x307f56, 0xcef1, 0xef1e, 0, 36 }, /* #71 b */
    { 0x290086, 0x290087, 0x1765, 0x942e, 0, 59 }, /* #72 */
    { 0x167f53, 0x167753, 0x1765, 0x962e, 0, 59 }, /* #72 b */
    { 0x3c5283, 0x3c5283, 0x0b18, 0x0b18, 0, 32 }, /* #73 */
    { 0x032d56, 0x032d56, 0x0b18, 0x0b18, 0, 32 }, /* #73 b */
    { 0x0e01c3, 0x0e01c3, 0x4ff5, 0xfd69, 0, 23 }, /* #74 */
    { 0x317e16, 0x317617, 0x4ff5, 0xfd49, 0, 23 }, /* #74 b */
    { 0x374f42, 0x374743, 0xdf7c, 0xef8d, 0, 22 }, /* #75 */
    { 0x083097, 0x083097, 0xdf7c, 0xef9d, 0, 22 }, /* #75 b */
    { 0x322687, 0x322e86, 0x9c7f, 0xe3fe, 0, 3  }, /* #76 */
    { 0x0d5952, 0x0d5952, 0x9c7f, 0xe3fa, 0, 3  }, /* #76 b */
    { 0x0b0e82, 0x0b0682, 0x616b, 0x5acc, 0, 6  }, /* #77 */
    { 0x347157, 0x347156, 0x616b, 0x5aec, 0, 6  }, /* #77 b */
    { 0x2d1a52, 0x2d1a52, 0xa096, 0xb282, 0, 60 }, /* #78 */
    { 0x126587, 0x126d86, 0xa096, 0xb682, 0, 60 }, /* #78 b */
    { 0x294c53, 0x294c53, 0x9cde, 0x6737, 0, 47 }, /* #79 */
    { 0x163386, 0x163b87, 0x9cde, 0x2737, 0, 47 }, /* #79 b */
    { 0x3207c2, 0x320fc3, 0xcd10, 0x1066, 0, 57 }, /* #80 */
    { 0x0d7817, 0x0d7817, 0xcd10, 0x10e6, 0, 57 }, /* #80 b */
    { 0x161656, 0x161657, 0x46dd, 0xa46d, 0, 45 }, /* #81 */
    { 0x296983, 0x296183, 0x46dd, 0xb46d, 0, 45 }, /* #81 b */
    { 0x126312, 0x126b13, 0xae30, 0x0571, 0, 61 }, /* #82 */
    { 0x2d1cc7, 0x2d1cc7, 0xae30, 0x0d71, 0, 61 }, /* #82 b */
    { 0x355442, 0x355443, 0x7e9b, 0xd367, 0, 5  }, /* #83 */
    { 0x0a2b97, 0x0a2397, 0x7e9b, 0xd377, 0, 5  }, /* #83 b */
    { 0x346c02, 0x346c03, 0x9c98, 0x2613, 0, 23 }, /* #84 */
    { 0x0b13d7, 0x0b1bd7, 0x9c98, 0x2633, 0, 23 }, /* #84 b */
    { 0x0b6b83, 0x0b6382, 0xa203, 0x203d, 0, 36 }, /* #85 */
    { 0x341456, 0x341456, 0xa203, 0x2035, 0, 36 }, /* #85 b */
    { 0x090dd3, 0x090dd2, 0xe0f4, 0xf4f0, 0, 40 }, /* #86 */
    { 0x367206, 0x367a06, 0xe0f4, 0xf470, 0, 40 }, /* #86 b */
    { 0x375342, 0x375b43, 0x694e, 0x29c6, 0, 37 }, /* #87 */
    { 0x082c97, 0x082c97, 0x694e, 0x29d6, 0, 37 }, /* #87 b */
    { 0x2d6686, 0x2d6687, 0x8cb1, 0x8a32, 0, 43 }, /* #88 */
    { 0x121953, 0x121153, 0x8cb1, 0x8e32, 0, 43 }, /* #88 b */
    { 0x3f2717, 0x3f2f17, 0xb341, 0x41d9, 0, 8  }, /* #89 */
    { 0x0058c2, 0x0058c3, 0xb341, 0x4159, 0, 8  }, /* #89 b */
    { 0x382357, 0x382356, 0x23c4, 0x4789, 0, 33 }, /* #90 */
    { 0x075c82, 0x075482, 0x23c4, 0x4788, 0, 33 }, /* #90 b */
    { 0x265ac7, 0x265ac6, 0x3bdf, 0xf7e7, 0, 23 }, /* #91 */
    { 0x192512, 0x192d12, 0x3bdf, 0xf7c7, 0, 23 }, /* #91 b */
    { 0x2d2816, 0x2d2816, 0x5910, 0xc881, 0, 20 }, /* #92 */
    { 0x1257c3, 0x125fc2, 0x5910, 0xc885, 0, 20 }, /* #92 b */
    { 0x2b5b57, 0x2b5b56, 0x45ba, 0xea8b, 0, 59 }, /* #93 */
    { 0x142482, 0x142c82, 0x45ba, 0xe88b, 0, 59 }, /* #93 b */
    { 0x0b1017, 0x0b1817, 0xbcae, 0x6f2b, 0, 47 }, /* #94 */
    { 0x346fc2, 0x346fc3, 0xbcae, 0x2f2b, 0, 47 }, /* #94 b */
    { 0x111a52, 0x111253, 0xd73b, 0xceda, 0, 38 }, /* #95 */
    { 0x2e6587, 0x2e6587, 0xd73b, 0xcefa, 0, 38 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u16_amd = RT_ELEMENTS(g_aTests_rcl_u16_amd);

BINU16_TEST_T const g_aTests_rcr_u16_amd[] =
{
    { 0x3f5e52, 0x3f5652, 0x0000, 0x0000, 0, 59 }, /* #0 */
    { 0x002187, 0x002186, 0x0000, 0x0040, 0, 59 }, /* #0 b */
    { 0x3e7e17, 0x3e7e16, 0x0000, 0x8000, 0, 50 }, /* #1 */
    { 0x0101c2, 0x0101c2, 0x0000, 0x0000, 0, 50 }, /* #1 b */
    { 0x372246, 0x372246, 0x0000, 0x0000, 0, 26 }, /* #2 */
    { 0x085d93, 0x085592, 0x0000, 0x0080, 0, 26 }, /* #2 b */
    { 0x1743d6, 0x1743d6, 0x0000, 0x0000, 0, 16 }, /* #3 */
    { 0x283c03, 0x283402, 0x0000, 0x0001, 0, 16 }, /* #3 b */
    { 0x0311c6, 0x0311c6, 0x0000, 0x0000, 0, 13 }, /* #4 */
    { 0x3c6e13, 0x3c6612, 0x0000, 0x0008, 0, 13 }, /* #4 b */
    { 0x3a7143, 0x3a7142, 0x0000, 0x0040, 0, 42 }, /* #5 */
    { 0x050e96, 0x050696, 0x0000, 0x0000, 0, 42 }, /* #5 b */
    { 0x1a17c3, 0x1a1fc2, 0x418c, 0x6328, 0, 43 }, /* #6 */
    { 0x256816, 0x256816, 0x418c, 0x6308, 0, 43 }, /* #6 b */
    { 0x222657, 0x222e56, 0xbd3e, 0x9f6f, 0, 59 }, /* #7 */
    { 0x1d5982, 0x1d5982, 0xbd3e, 0x9f2f, 0, 59 }, /* #7 b */
    { 0x1c3ec2, 0x1c3ec3, 0xb9cb, 0x96b9, 0, 8  }, /* #8 */
    { 0x234117, 0x234917, 0xb9cb, 0x97b9, 0, 8  }, /* #8 b */
    { 0x1f5982, 0x1f5182, 0x6041, 0x0981, 0, 23 }, /* #9 */
    { 0x202657, 0x202656, 0x6041, 0x0d81, 0, 23 }, /* #9 b */
    { 0x0946c2, 0x094ec2, 0x8580, 0x5804, 0, 45 }, /* #10 */
    { 0x363917, 0x363916, 0x8580, 0x580c, 0, 45 }, /* #10 b */
    { 0x072a92, 0x072292, 0x3700, 0x0037, 0, 57 }, /* #11 */
    { 0x385547, 0x385546, 0x3700, 0x0137, 0, 57 }, /* #11 b */
    { 0x0d5347, 0x0d5347, 0x06fe, 0xfd06, 0, 57 }, /* #12 */
    { 0x322c92, 0x322493, 0x06fe, 0xfc06, 0, 57 }, /* #12 b */
    { 0x012e52, 0x012652, 0x41c9, 0x0e49, 0, 63 }, /* #13 */
    { 0x3e5187, 0x3e5186, 0x41c9, 0x0e4d, 0, 63 }, /* #13 b */
    { 0x2b3c86, 0x2b3c87, 0x380b, 0x80b1, 0, 13 }, /* #14 */
    { 0x144353, 0x144b53, 0x380b, 0x80b9, 0, 13 }, /* #14 b */
    { 0x1226d2, 0x122ed3, 0x6363, 0x6331, 0, 41 }, /* #15 */
    { 0x2d5907, 0x2d5907, 0x6363, 0x63b1, 0, 41 }, /* #15 b */
    { 0x347dd3, 0x347dd3, 0x72ee, 0x75cb, 0, 55 }, /* #16 */
    { 0x0b0206, 0x0b0a07, 0x72ee, 0x71cb, 0, 55 }, /* #16 b */
    { 0x393bd7, 0x3933d7, 0xe177, 0x0bbf, 0, 31 }, /* #17 */
    { 0x064402, 0x064403, 0xe177, 0x0bbb, 0, 31 }, /* #17 b */
    { 0x2b6a57, 0x2b6257, 0x8bc7, 0x1f17, 0, 56 }, /* #18 */
    { 0x141582, 0x141583, 0x8bc7, 0x1d17, 0, 56 }, /* #18 b */
    { 0x273187, 0x273187, 0xdccf, 0x33fb, 0, 60 }, /* #19 */
    { 0x184e52, 0x184653, 0xdccf, 0x33db, 0, 60 }, /* #19 b */
    { 0x3c6ad6, 0x3c62d7, 0x39ff, 0x3fe3, 0, 61 }, /* #20 */
    { 0x031503, 0x031503, 0x39ff, 0x3ff3, 0, 61 }, /* #20 b */
    { 0x3b1217, 0x3b1a17, 0x370e, 0x874d, 0, 10 }, /* #21 */
    { 0x046dc2, 0x046dc3, 0x370e, 0x870d, 0, 10 }, /* #21 b */
    { 0x004a12, 0x004212, 0x2251, 0x2511, 0, 30 }, /* #22 */
    { 0x3f35c7, 0x3f35c6, 0x2251, 0x2519, 0, 30 }, /* #22 b */
    { 0x1029d3, 0x1021d2, 0xb085, 0xec21, 0, 2  }, /* #23 */
    { 0x2f5606, 0x2f5e06, 0xb085, 0xac21, 0, 2  }, /* #23 b */
    { 0x2f4ac6, 0x2f4ac6, 0xcad1, 0xb459, 0, 43 }, /* #24 */
    { 0x103513, 0x103d12, 0xcad1, 0xb479, 0, 43 }, /* #24 b */
    { 0x222c13, 0x222c12, 0x28bf, 0xbf94, 0, 9  }, /* #25 */
    { 0x1d53c6, 0x1d5bc6, 0x28bf, 0xbf14, 0, 9  }, /* #25 b */
    { 0x0b5fd6, 0x0b5fd6, 0xb912, 0x92e4, 0, 6  }, /* #26 */
    { 0x342003, 0x342802, 0xb912, 0x96e4, 0, 6  }, /* #26 b */
    { 0x2e6d46, 0x2e6d46, 0x28ea, 0x8ea1, 0, 62 }, /* #27 */
    { 0x111293, 0x111a92, 0x28ea, 0x8ea9, 0, 62 }, /* #27 b */
    { 0x3b6bc2, 0x3b63c3, 0xa383, 0x1c1a, 0, 63 }, /* #28 */
    { 0x041417, 0x041417, 0xa383, 0x1c1e, 0, 63 }, /* #28 b */
    { 0x2b6017, 0x2b6016, 0x6d1d, 0xd1db, 0, 45 }, /* #29 */
    { 0x141fc2, 0x1417c2, 0x6d1d, 0xd1d3, 0, 45 }, /* #29 b */
    { 0x2c61c6, 0x2c69c6, 0xb4d9, 0x569b, 0, 35 }, /* #30 */
    { 0x131e13, 0x131e12, 0xb4d9, 0x769b, 0, 35 }, /* #30 b */
    { 0x044d87, 0x044d86, 0x57ec, 0xbf65, 0, 14 }, /* #31 */
    { 0x3b3252, 0x3b3a52, 0x57ec, 0xbf61, 0, 14 }, /* #31 b */
    { 0x3a5a13, 0x3a5a12, 0xb412, 0xb682, 0, 20 }, /* #32 */
    { 0x0525c6, 0x052dc6, 0xb412, 0x9682, 0, 20 }, /* #32 b */
    { 0x206513, 0x206513, 0xe07e, 0x03f7, 0, 31 }, /* #33 */
    { 0x1f1ac6, 0x1f12c7, 0xe07e, 0x03f3, 0, 31 }, /* #33 b */
    { 0x263812, 0x263813, 0x674a, 0xa519, 0, 10 }, /* #34 */
    { 0x1947c7, 0x194fc7, 0x674a, 0xa559, 0, 10 }, /* #34 b */
    { 0x2c1e42, 0x2c1e43, 0x130c, 0x8130, 0, 53 }, /* #35 */
    { 0x136197, 0x136997, 0x130c, 0x9130, 0, 53 }, /* #35 b */
    { 0x0a68d3, 0x0a68d2, 0x3114, 0x988a, 0, 18 }, /* #36 */
    { 0x351706, 0x351706, 0x3114, 0x188a, 0, 18 }, /* #36 b */
    { 0x241056, 0x241056, 0x2ecd, 0xcd17, 0, 26 }, /* #37 */
    { 0x1b6f83, 0x1b6782, 0x2ecd, 0xcd97, 0, 26 }, /* #37 b */
    { 0x325147, 0x325146, 0x5e50, 0xf285, 0, 63 }, /* #38 */
    { 0x0d2e92, 0x0d2692, 0x5e50, 0xf281, 0, 63 }, /* #38 b */
    { 0x3f1b12, 0x3f1b12, 0x76b2, 0x76b2, 0, 0  }, /* #39 */
    { 0x0064c7, 0x0064c7, 0x76b2, 0x76b2, 0, 0  }, /* #39 b */
    { 0x0b0e53, 0x0b0e53, 0x2c0f, 0x9607, 0, 50 }, /* #40 */
    { 0x347186, 0x347187, 0x2c0f, 0x1607, 0, 50 }, /* #40 b */
    { 0x271d03, 0x271d03, 0x6cdb, 0x76cd, 0, 4  }, /* #41 */
    { 0x1862d6, 0x186ad7, 0x6cdb, 0x66cd, 0, 4  }, /* #41 b */
    { 0x342206, 0x342207, 0x81e3, 0xe340, 0, 58 }, /* #42 */
    { 0x0b5dd3, 0x0b55d3, 0x81e3, 0xe3c0, 0, 58 }, /* #42 b */
    { 0x023a16, 0x023216, 0xa3e9, 0x3e95, 0, 45 }, /* #43 */
    { 0x3d45c3, 0x3d45c2, 0xa3e9, 0x3e9d, 0, 45 }, /* #43 b */
    { 0x226252, 0x226a52, 0x1c28, 0x70a0, 0, 47 }, /* #44 */
    { 0x1d1d87, 0x1d1d86, 0x1c28, 0x70a2, 0, 47 }, /* #44 b */
    { 0x086596, 0x086d97, 0x2e4a, 0x9285, 0, 28 }, /* #45 */
    { 0x371a43, 0x371a43, 0x2e4a, 0x92a5, 0, 28 }, /* #45 b */
    { 0x043302, 0x043b02, 0x53c4, 0x53c4, 0, 17 }, /* #46 */
    { 0x3b4cd7, 0x3b4cd7, 0x53c4, 0x53c4, 0, 17 }, /* #46 b */
    { 0x181c03, 0x181c02, 0xeaa9, 0xa9f5, 0, 26 }, /* #47 */
    { 0x2763d6, 0x276bd6, 0xeaa9, 0xa975, 0, 26 }, /* #47 b */
    { 0x1542c6, 0x154ac6, 0xd2ac, 0xb1a5, 0, 56 }, /* #48 */
    { 0x2a3d13, 0x2a3d12, 0xd2ac, 0xb3a5, 0, 56 }, /* #48 b */
    { 0x1c6057, 0x1c6856, 0x3e54, 0x549f, 0, 26 }, /* #49 */
    { 0x231f82, 0x231f82, 0x3e54, 0x541f, 0, 26 }, /* #49 b */
    { 0x0b6957, 0x0b6957, 0x241f, 0x920f, 0, 33 }, /* #50 */
    { 0x341682, 0x341683, 0x241f, 0x120f, 0, 33 }, /* #50 b */
    { 0x131707, 0x131706, 0xa090, 0x1a09, 0, 21 }, /* #51 */
    { 0x2c68d2, 0x2c60d2, 0xa090, 0x0a09, 0, 21 }, /* #51 b */
    { 0x1d7786, 0x1d7787, 0xa433, 0x0cd4, 0, 28 }, /* #52 */
    { 0x220853, 0x220053, 0xa433, 0x0cf4, 0, 28 }, /* #52 b */
    { 0x2c0ed7, 0x2c06d7, 0x7718, 0x18bb, 0, 41 }, /* #53 */
    { 0x137102, 0x137103, 0x7718, 0x183b, 0, 41 }, /* #53 b */
    { 0x2e0397, 0x2e0b97, 0xeb88, 0x711e, 0, 61 }, /* #54 */
    { 0x117c42, 0x117c43, 0xeb88, 0x710e, 0, 61 }, /* #54 b */
    { 0x1f0556, 0x1f0d57, 0x1043, 0x8410, 0, 51 }, /* #55 */
    { 0x207a83, 0x207283, 0x1043, 0xc410, 0, 51 }, /* #55 b */
    { 0x1812c3, 0x1812c3, 0x4c2e, 0x4c2e, 0, 0  }, /* #56 */
    { 0x276d16, 0x276d16, 0x4c2e, 0x4c2e, 0, 0  }, /* #56 b */
    { 0x385987, 0x385187, 0x5ff5, 0xff5a, 0, 30 }, /* #57 */
    { 0x072652, 0x072653, 0x5ff5, 0xff52, 0, 30 }, /* #57 b */
    { 0x1b5682, 0x1b5e82, 0x28ec, 0x8ec1, 0, 30 }, /* #58 */
    { 0x242957, 0x242956, 0x28ec, 0x8ec9, 0, 30 }, /* #58 b */
    { 0x151343, 0x151b43, 0x735d, 0xb735, 0, 4  }, /* #59 */
    { 0x2a6c96, 0x2a6c97, 0x735d, 0xa735, 0, 4  }, /* #59 b */
    { 0x224312, 0x224312, 0x4bea, 0x25f5, 0, 18 }, /* #60 */
    { 0x1d3cc7, 0x1d3cc6, 0x4bea, 0xa5f5, 0, 18 }, /* #60 b */
    { 0x3c1ec6, 0x3c16c7, 0x63d7, 0x1eb9, 0, 46 }, /* #61 */
    { 0x036113, 0x036113, 0x63d7, 0x1ebd, 0, 46 }, /* #61 b */
    { 0x074412, 0x074413, 0x2fc9, 0xe48b, 0, 10 }, /* #62 */
    { 0x383bc7, 0x3833c7, 0x2fc9, 0xe4cb, 0, 10 }, /* #62 b */
    { 0x311e56, 0x311656, 0x0c18, 0x0c03, 0, 42 }, /* #63 */
    { 0x0e6183, 0x0e6182, 0x0c18, 0x0c43, 0, 42 }, /* #63 b */
    { 0x2b1117, 0x2b1917, 0xb6b5, 0x5aed, 0, 27 }, /* #64 */
    { 0x146ec2, 0x146ec3, 0xb6b5, 0x5aad, 0, 27 }, /* #64 b */
    { 0x2e3d02, 0x2e3d03, 0x77d3, 0x9df4, 0, 2  }, /* #65 */
    { 0x1142d7, 0x1142d7, 0x77d3, 0xddf4, 0, 2  }, /* #65 b */
    { 0x0c51c2, 0x0c59c2, 0x2451, 0x8891, 0, 38 }, /* #66 */
    { 0x332e17, 0x332e16, 0x2451, 0x8c91, 0, 38 }, /* #66 b */
    { 0x291c87, 0x291487, 0xb7f6, 0xedb7, 0, 8  }, /* #67 */
    { 0x166352, 0x166353, 0xb7f6, 0xecb7, 0, 8  }, /* #67 b */
    { 0x1835d2, 0x1835d2, 0x9f08, 0x213e, 0, 24 }, /* #68 */
    { 0x274a07, 0x274206, 0x9f08, 0x233e, 0, 24 }, /* #68 b */
    { 0x107f93, 0x107f92, 0xd08a, 0xae84, 0, 54 }, /* #69 */
    { 0x2f0046, 0x2f0846, 0xd08a, 0xa684, 0, 54 }, /* #69 b */
    { 0x2c3f93, 0x2c3f92, 0x86da, 0x6dac, 0, 62 }, /* #70 */
    { 0x134046, 0x134846, 0x86da, 0x6da4, 0, 62 }, /* #70 b */
    { 0x191457, 0x191456, 0x1c00, 0x008e, 0, 58 }, /* #71 */
    { 0x266b82, 0x266382, 0x1c00, 0x000e, 0, 58 }, /* #71 b */
    { 0x083f86, 0x083f87, 0x9d06, 0x4193, 0, 11 }, /* #72 */
    { 0x374053, 0x374853, 0x9d06, 0x41b3, 0, 11 }, /* #72 b */
    { 0x181706, 0x181f06, 0xec16, 0x760b, 0, 33 }, /* #73 */
    { 0x2768d3, 0x2760d2, 0xec16, 0xf60b, 0, 33 }, /* #73 b */
    { 0x291287, 0x291287, 0x94df, 0xf94d, 0, 4  }, /* #74 */
    { 0x166d52, 0x166553, 0x94df, 0xe94d, 0, 4  }, /* #74 b */
    { 0x274b96, 0x274b97, 0xd576, 0x5d9a, 0, 11 }, /* #75 */
    { 0x183443, 0x183c43, 0xd576, 0x5dba, 0, 11 }, /* #75 b */
    { 0x225192, 0x225993, 0xbb4a, 0x7694, 0, 16 }, /* #76 */
    { 0x1d2e47, 0x1d2e47, 0xbb4a, 0x7695, 0, 16 }, /* #76 b */
    { 0x2f3617, 0x2f3617, 0xeba2, 0xeba2, 0, 0  }, /* #77 */
    { 0x1049c2, 0x1049c2, 0xeba2, 0xeba2, 0, 0  }, /* #77 b */
    { 0x291a47, 0x291247, 0x11a4, 0x2446, 0, 55 }, /* #78 */
    { 0x166592, 0x166593, 0x11a4, 0x2046, 0, 55 }, /* #78 b */
    { 0x3b2242, 0x3b2a42, 0x615a, 0xad18, 0, 59 }, /* #79 */
    { 0x045d97, 0x045d96, 0x615a, 0xad58, 0, 59 }, /* #79 b */
    { 0x0219d6, 0x0219d7, 0x8bdc, 0x88bd, 0, 36 }, /* #80 */
    { 0x3d6603, 0x3d6e03, 0x8bdc, 0x98bd, 0, 36 }, /* #80 b */
    { 0x3f71c7, 0x3f71c7, 0x475a, 0x1d6a, 0, 15 }, /* #81 */
    { 0x000e12, 0x000613, 0x475a, 0x1d68, 0, 15 }, /* #81 b */
    { 0x243cc6, 0x2434c7, 0xb77a, 0xe96e, 0, 24 }, /* #82 */
    { 0x1b4313, 0x1b4313, 0xb77a, 0xeb6e, 0, 24 }, /* #82 b */
    { 0x024d07, 0x024506, 0xd932, 0xec99, 0, 1  }, /* #83 */
    { 0x3d32d2, 0x3d3ad2, 0xd932, 0x6c99, 0, 1  }, /* #83 b */
    { 0x2c7246, 0x2c7a47, 0xced5, 0xaace, 0, 8  }, /* #84 */
    { 0x130d93, 0x130d93, 0xced5, 0xabce, 0, 8  }, /* #84 b */
    { 0x013483, 0x013c82, 0x615e, 0xb0af, 0, 18 }, /* #85 */
    { 0x3e4b56, 0x3e4356, 0x615e, 0x30af, 0, 18 }, /* #85 b */
    { 0x1272c2, 0x1272c3, 0x40ff, 0xc81f, 0, 20 }, /* #86 */
    { 0x2d0d17, 0x2d0517, 0x40ff, 0xe81f, 0, 20 }, /* #86 b */
    { 0x0901c3, 0x0901c3, 0x6fa9, 0xd4db, 0, 27 }, /* #87 */
    { 0x367e16, 0x367617, 0x6fa9, 0xd49b, 0, 27 }, /* #87 b */
    { 0x3430d7, 0x3438d7, 0xbfbd, 0x7f7b, 0, 48 }, /* #88 */
    { 0x0b4f02, 0x0b4f03, 0xbfbd, 0x7f7a, 0, 48 }, /* #88 b */
    { 0x1c5992, 0x1c5192, 0x8bc0, 0x08bc, 0, 53 }, /* #89 */
    { 0x232647, 0x232646, 0x8bc0, 0x18bc, 0, 53 }, /* #89 b */
    { 0x282c57, 0x282c56, 0x4ca0, 0x5053, 0, 10 }, /* #90 */
    { 0x175382, 0x175b82, 0x4ca0, 0x5013, 0, 10 }, /* #90 b */
    { 0x136907, 0x136906, 0x650c, 0xa196, 0, 29 }, /* #91 */
    { 0x2c16d2, 0x2c1ed2, 0x650c, 0xa186, 0, 29 }, /* #91 b */
    { 0x2526c7, 0x252ec6, 0xa214, 0xa688, 0, 55 }, /* #92 */
    { 0x1a5912, 0x1a5912, 0xa214, 0xa288, 0, 55 }, /* #92 b */
    { 0x114516, 0x114d17, 0xd6bb, 0x6bb6, 0, 45 }, /* #93 */
    { 0x2e3ac3, 0x2e3ac3, 0xd6bb, 0x6bbe, 0, 45 }, /* #93 b */
    { 0x301f16, 0x301f16, 0x189a, 0x8313, 0, 20 }, /* #94 */
    { 0x0f60c3, 0x0f68c2, 0x189a, 0xa313, 0, 20 }, /* #94 b */
    { 0x102d53, 0x102d53, 0x8096, 0xb012, 0, 3  }, /* #95 */
    { 0x2f5286, 0x2f5a87, 0x8096, 0x9012, 0, 3  }, /* #95 b */
};
uint32_t const g_cTests_rcr_u16_amd = RT_ELEMENTS(g_aTests_rcr_u16_amd);

BINU16_TEST_T const g_aTests_shl_u16_amd[] =
{
    { 0x316f56, 0x316756, 0x0000, 0x0000, 0, 46 }, /* #0 */
    { 0x0e1083, 0x0e1056, 0x0000, 0x0000, 0, 46 }, /* #0 b */
    { 0x1b3307, 0x1b3356, 0x0000, 0x0000, 0, 31 }, /* #1 */
    { 0x244cd2, 0x244456, 0x0000, 0x0000, 0, 31 }, /* #1 b */
    { 0x223092, 0x223056, 0x0000, 0x0000, 0, 7  }, /* #2 */
    { 0x1d4f47, 0x1d4756, 0x0000, 0x0000, 0, 7  }, /* #2 b */
    { 0x213057, 0x213056, 0x0000, 0x0000, 0, 52 }, /* #3 */
    { 0x1e4f82, 0x1e4756, 0x0000, 0x0000, 0, 52 }, /* #3 b */
    { 0x2a6983, 0x2a6156, 0x0000, 0x0000, 0, 54 }, /* #4 */
    { 0x151656, 0x151656, 0x0000, 0x0000, 0, 54 }, /* #4 b */
    { 0x3a5416, 0x3a5456, 0x0000, 0x0000, 0, 58 }, /* #5 */
    { 0x052bc3, 0x052356, 0x0000, 0x0000, 0, 58 }, /* #5 b */
    { 0x064396, 0x064b17, 0x282d, 0x05a0, 0, 5  }, /* #6 */
    { 0x393c43, 0x393c17, 0x282d, 0x05a0, 0, 5  }, /* #6 b */
    { 0x234957, 0x234156, 0xb39c, 0x0000, 0, 15 }, /* #7 */
    { 0x1c3682, 0x1c3656, 0xb39c, 0x0000, 0, 15 }, /* #7 b */
    { 0x123397, 0x123356, 0xd9c1, 0x0000, 0, 54 }, /* #8 */
    { 0x2d4c42, 0x2d4456, 0xd9c1, 0x0000, 0, 54 }, /* #8 b */
    { 0x332f07, 0x332756, 0x5e83, 0x0000, 0, 21 }, /* #9 */
    { 0x0c50d2, 0x0c5056, 0x5e83, 0x0000, 0, 21 }, /* #9 b */
    { 0x125606, 0x125656, 0x448f, 0x0000, 0, 30 }, /* #10 */
    { 0x2d29d3, 0x2d2156, 0x448f, 0x0000, 0, 30 }, /* #10 b */
    { 0x2c5a46, 0x2c5256, 0xad99, 0x0000, 0, 30 }, /* #11 */
    { 0x132593, 0x132556, 0xad99, 0x0000, 0, 30 }, /* #11 b */
    { 0x1553d2, 0x155356, 0x0ad6, 0x0000, 0, 59 }, /* #12 */
    { 0x2a2c07, 0x2a2456, 0x0ad6, 0x0000, 0, 59 }, /* #12 b */
    { 0x183f83, 0x183f96, 0x6896, 0xc000, 0, 13 }, /* #13 */
    { 0x274056, 0x274896, 0x6896, 0xc000, 0, 13 }, /* #13 b */
    { 0x165b03, 0x165b17, 0x5010, 0x0100, 0, 36 }, /* #14 */
    { 0x2924d6, 0x292c17, 0x5010, 0x0100, 0, 36 }, /* #14 b */
    { 0x063257, 0x063a57, 0x7d38, 0x0000, 0, 45 }, /* #15 */
    { 0x394d82, 0x394d57, 0x7d38, 0x0000, 0, 45 }, /* #15 b */
    { 0x101803, 0x101056, 0x120c, 0x0000, 0, 30 }, /* #16 */
    { 0x2f67d6, 0x2f6756, 0x120c, 0x0000, 0, 30 }, /* #16 b */
    { 0x3c1547, 0x3c1d17, 0xe235, 0x4000, 0, 14 }, /* #17 */
    { 0x036a92, 0x036a17, 0xe235, 0x4000, 0, 14 }, /* #17 b */
    { 0x1050d2, 0x105056, 0xd781, 0x0000, 0, 49 }, /* #18 */
    { 0x2f2f07, 0x2f2756, 0xd781, 0x0000, 0, 49 }, /* #18 b */
    { 0x385f97, 0x385797, 0x5beb, 0xd600, 0, 9  }, /* #19 */
    { 0x072042, 0x072097, 0x5beb, 0xd600, 0, 9  }, /* #19 b */
    { 0x266b83, 0x266356, 0xaa8f, 0x0000, 0, 31 }, /* #20 */
    { 0x191456, 0x191456, 0xaa8f, 0x0000, 0, 31 }, /* #20 b */
    { 0x1f7cc3, 0x1f7497, 0xedb5, 0xa800, 0, 11 }, /* #21 */
    { 0x200316, 0x200397, 0xedb5, 0xa800, 0, 11 }, /* #21 b */
    { 0x355e82, 0x355656, 0x8f70, 0x0000, 0, 18 }, /* #22 */
    { 0x0a2157, 0x0a2156, 0x8f70, 0x0000, 0, 18 }, /* #22 b */
    { 0x1d3213, 0x1d3a92, 0x8aed, 0xbb40, 0, 6  }, /* #23 */
    { 0x224dc6, 0x224d92, 0x8aed, 0xbb40, 0, 6  }, /* #23 b */
    { 0x2d6403, 0x2d6416, 0x957a, 0x55e8, 0, 34 }, /* #24 */
    { 0x121bd6, 0x121316, 0x957a, 0x55e8, 0, 34 }, /* #24 b */
    { 0x3e0e52, 0x3e0656, 0xa5f4, 0x0000, 0, 60 }, /* #25 */
    { 0x017187, 0x017156, 0xa5f4, 0x0000, 0, 60 }, /* #25 b */
    { 0x225a42, 0x225256, 0x6c21, 0x0000, 0, 54 }, /* #26 */
    { 0x1d2597, 0x1d2556, 0x6c21, 0x0000, 0, 54 }, /* #26 b */
    { 0x151d57, 0x151556, 0xec8f, 0x0000, 0, 23 }, /* #27 */
    { 0x2a6282, 0x2a6256, 0xec8f, 0x0000, 0, 23 }, /* #27 b */
    { 0x1d4c43, 0x1d4497, 0xf6bd, 0xb5e8, 0, 35 }, /* #28 */
    { 0x223396, 0x223397, 0xf6bd, 0xb5e8, 0, 35 }, /* #28 b */
    { 0x3e6497, 0x3e6456, 0x967b, 0x0000, 0, 59 }, /* #29 */
    { 0x011b42, 0x011356, 0x967b, 0x0000, 0, 59 }, /* #29 b */
    { 0x2e2d52, 0x2e2d52, 0x3668, 0x3668, 0, 0  }, /* #30 */
    { 0x115287, 0x115287, 0x3668, 0x3668, 0, 0  }, /* #30 b */
    { 0x2c02d3, 0x2c0a17, 0x8a90, 0x5200, 0, 37 }, /* #31 */
    { 0x137d06, 0x137d17, 0x8a90, 0x5200, 0, 37 }, /* #31 b */
    { 0x2a3c87, 0x2a3456, 0x9008, 0x0000, 0, 31 }, /* #32 */
    { 0x154352, 0x154356, 0x9008, 0x0000, 0, 31 }, /* #32 b */
    { 0x1b1757, 0x1b1f96, 0x5fda, 0xbfb4, 0, 1  }, /* #33 */
    { 0x246882, 0x246896, 0x5fda, 0xbfb4, 0, 1  }, /* #33 b */
    { 0x337c53, 0x337456, 0xfdd2, 0x0000, 0, 49 }, /* #34 */
    { 0x0c0386, 0x0c0356, 0xfdd2, 0x0000, 0, 49 }, /* #34 b */
    { 0x180656, 0x180656, 0x07eb, 0x0000, 0, 31 }, /* #35 */
    { 0x277983, 0x277156, 0x07eb, 0x0000, 0, 31 }, /* #35 b */
    { 0x276e06, 0x276656, 0x9562, 0x0000, 0, 52 }, /* #36 */
    { 0x1811d3, 0x181156, 0x9562, 0x0000, 0, 52 }, /* #36 b */
    { 0x2f1743, 0x2f1756, 0x83b7, 0x0000, 0, 57 }, /* #37 */
    { 0x106896, 0x106056, 0x83b7, 0x0000, 0, 57 }, /* #37 b */
    { 0x093043, 0x093892, 0x9b93, 0xdc98, 0, 35 }, /* #38 */
    { 0x364f96, 0x364f92, 0x9b93, 0xdc98, 0, 35 }, /* #38 b */
    { 0x231582, 0x231582, 0xd5b4, 0xd5b4, 0, 32 }, /* #39 */
    { 0x1c6a57, 0x1c6a57, 0xd5b4, 0xd5b4, 0, 32 }, /* #39 b */
    { 0x2b4883, 0x2b4056, 0xc277, 0x0000, 0, 60 }, /* #40 */
    { 0x143756, 0x143756, 0xc277, 0x0000, 0, 60 }, /* #40 b */
    { 0x190a92, 0x190297, 0xbaaf, 0x8000, 0, 47 }, /* #41 */
    { 0x267547, 0x267597, 0xbaaf, 0x8000, 0, 47 }, /* #41 b */
    { 0x0d1892, 0x0d1056, 0xa3f0, 0x0000, 0, 25 }, /* #42 */
    { 0x326747, 0x326756, 0xa3f0, 0x0000, 0, 25 }, /* #42 b */
    { 0x2b1193, 0x2b1156, 0x545e, 0x0000, 0, 19 }, /* #43 */
    { 0x146e46, 0x146656, 0x545e, 0x0000, 0, 19 }, /* #43 b */
    { 0x002406, 0x002c57, 0x6621, 0x0000, 0, 48 }, /* #44 */
    { 0x3f5bd3, 0x3f5b57, 0x6621, 0x0000, 0, 48 }, /* #44 b */
    { 0x2b0882, 0x2b0896, 0x6ab3, 0xb300, 0, 8  }, /* #45 */
    { 0x147757, 0x147f96, 0x6ab3, 0xb300, 0, 8  }, /* #45 b */
    { 0x234107, 0x234156, 0x7fd7, 0x0000, 0, 51 }, /* #46 */
    { 0x1c3ed2, 0x1c3656, 0x7fd7, 0x0000, 0, 51 }, /* #46 b */
    { 0x2e6007, 0x2e6056, 0xff29, 0x0000, 0, 57 }, /* #47 */
    { 0x111fd2, 0x111756, 0xff29, 0x0000, 0, 57 }, /* #47 b */
    { 0x240012, 0x240097, 0x49f4, 0xd000, 0, 42 }, /* #48 */
    { 0x1b7fc7, 0x1b7797, 0x49f4, 0xd000, 0, 42 }, /* #48 b */
    { 0x3e3d06, 0x3e3512, 0x1b5d, 0x36ba, 0, 1  }, /* #49 */
    { 0x0142d3, 0x014212, 0x1b5d, 0x36ba, 0, 1  }, /* #49 b */
    { 0x160283, 0x160a96, 0xa34b, 0xc000, 0, 14 }, /* #50 */
    { 0x297d56, 0x297d96, 0xa34b, 0xc000, 0, 14 }, /* #50 b */
    { 0x0d25c2, 0x0d2d17, 0x721c, 0x0e00, 0, 39 }, /* #51 */
    { 0x325a17, 0x325a17, 0x721c, 0x0e00, 0, 39 }, /* #51 b */
    { 0x163fc3, 0x163f13, 0x5562, 0x5620, 0, 36 }, /* #52 */
    { 0x294016, 0x294813, 0x5562, 0x5620, 0, 36 }, /* #52 b */
    { 0x1d3092, 0x1d3016, 0xd322, 0x2000, 0, 12 }, /* #53 */
    { 0x224f47, 0x224716, 0xd322, 0x2000, 0, 12 }, /* #53 b */
    { 0x1e2307, 0x1e2312, 0x4f6e, 0x7b70, 0, 3  }, /* #54 */
    { 0x215cd2, 0x215412, 0x4f6e, 0x7b70, 0, 3  }, /* #54 b */
    { 0x0b7bc3, 0x0b7b96, 0x3186, 0xc618, 0, 34 }, /* #55 */
    { 0x340416, 0x340c96, 0x3186, 0xc618, 0, 34 }, /* #55 b */
    { 0x2e6b97, 0x2e6b17, 0xd735, 0x5000, 0, 44 }, /* #56 */
    { 0x111442, 0x111c17, 0xd735, 0x5000, 0, 44 }, /* #56 b */
    { 0x2920c6, 0x292016, 0x34fe, 0x69fc, 0, 1  }, /* #57 */
    { 0x165f13, 0x165716, 0x34fe, 0x69fc, 0, 1  }, /* #57 b */
    { 0x3b4003, 0x3b4056, 0x74d6, 0x0000, 0, 21 }, /* #58 */
    { 0x043fd6, 0x043756, 0x74d6, 0x0000, 0, 21 }, /* #58 b */
    { 0x314a53, 0x314a96, 0xbe4d, 0xd000, 0, 44 }, /* #59 */
    { 0x0e3586, 0x0e3d96, 0xbe4d, 0xd000, 0, 44 }, /* #59 b */
    { 0x052b12, 0x052b57, 0xf8d1, 0x0000, 0, 16 }, /* #60 */
    { 0x3a54c7, 0x3a5c57, 0xf8d1, 0x0000, 0, 16 }, /* #60 b */
    { 0x030d83, 0x030d57, 0x4c26, 0x0000, 0, 47 }, /* #61 */
    { 0x3c7256, 0x3c7a57, 0x4c26, 0x0000, 0, 47 }, /* #61 b */
    { 0x184a46, 0x184256, 0x02d0, 0x0000, 0, 56 }, /* #62 */
    { 0x273593, 0x273556, 0x02d0, 0x0000, 0, 56 }, /* #62 b */
    { 0x3c2793, 0x3c2756, 0x5a20, 0x0000, 0, 23 }, /* #63 */
    { 0x035846, 0x035056, 0x5a20, 0x0000, 0, 23 }, /* #63 b */
    { 0x0e2712, 0x0e2f96, 0x3229, 0xa400, 0, 10 }, /* #64 */
    { 0x3158c7, 0x315896, 0x3229, 0xa400, 0, 10 }, /* #64 b */
    { 0x0a6b03, 0x0a6356, 0x573b, 0x0000, 0, 17 }, /* #65 */
    { 0x3514d6, 0x351456, 0x573b, 0x0000, 0, 17 }, /* #65 b */
    { 0x1e2547, 0x1e2556, 0x9ca2, 0x0000, 0, 18 }, /* #66 */
    { 0x215a92, 0x215256, 0x9ca2, 0x0000, 0, 18 }, /* #66 b */
    { 0x1f3c53, 0x1f3c13, 0xad31, 0x4c40, 0, 38 }, /* #67 */
    { 0x204386, 0x204b13, 0xad31, 0x4c40, 0, 38 }, /* #67 b */
    { 0x310343, 0x310397, 0x907d, 0xa000, 0, 45 }, /* #68 */
    { 0x0e7c96, 0x0e7497, 0x907d, 0xa000, 0, 45 }, /* #68 b */
    { 0x0f53d2, 0x0f5b92, 0xd2ee, 0x9770, 0, 3  }, /* #69 */
    { 0x302c07, 0x302c92, 0xd2ee, 0x9770, 0, 3  }, /* #69 b */
    { 0x1c4103, 0x1c4156, 0xfd44, 0x0000, 0, 27 }, /* #70 */
    { 0x233ed6, 0x233656, 0xfd44, 0x0000, 0, 27 }, /* #70 b */
    { 0x1249c2, 0x124197, 0x7da3, 0xb460, 0, 5  }, /* #71 */
    { 0x2d3617, 0x2d3697, 0x7da3, 0xb460, 0, 5  }, /* #71 b */
    { 0x2d6f56, 0x2d6756, 0x9d0c, 0x0000, 0, 19 }, /* #72 */
    { 0x121083, 0x121056, 0x9d0c, 0x0000, 0, 19 }, /* #72 b */
    { 0x0e2b53, 0x0e2356, 0xc753, 0x0000, 0, 49 }, /* #73 */
    { 0x315486, 0x315456, 0xc753, 0x0000, 0, 49 }, /* #73 b */
    { 0x045c92, 0x045456, 0x2c24, 0x0000, 0, 26 }, /* #74 */
    { 0x3b2347, 0x3b2356, 0x2c24, 0x0000, 0, 26 }, /* #74 b */
    { 0x143a07, 0x143256, 0x4245, 0x0000, 0, 52 }, /* #75 */
    { 0x2b45d2, 0x2b4556, 0x4245, 0x0000, 0, 52 }, /* #75 b */
    { 0x0c4f83, 0x0c4793, 0xfa8e, 0xea38, 0, 2  }, /* #76 */
    { 0x333056, 0x333093, 0xfa8e, 0xea38, 0, 2  }, /* #76 b */
    { 0x066a57, 0x066216, 0x209b, 0x1360, 0, 37 }, /* #77 */
    { 0x391582, 0x391516, 0x209b, 0x1360, 0, 37 }, /* #77 b */
    { 0x251696, 0x251656, 0xc28e, 0x0000, 0, 59 }, /* #78 */
    { 0x1a6943, 0x1a6156, 0xc28e, 0x0000, 0, 59 }, /* #78 b */
    { 0x1c1b92, 0x1c1356, 0x4763, 0x0000, 0, 28 }, /* #79 */
    { 0x236447, 0x236456, 0x4763, 0x0000, 0, 28 }, /* #79 b */
    { 0x033243, 0x033256, 0xf145, 0x0000, 0, 49 }, /* #80 */
    { 0x3c4d96, 0x3c4556, 0xf145, 0x0000, 0, 49 }, /* #80 b */
    { 0x003a52, 0x003a17, 0x96f0, 0x7800, 0, 7  }, /* #81 */
    { 0x3f4587, 0x3f4d17, 0x96f0, 0x7800, 0, 7  }, /* #81 b */
    { 0x0c4b83, 0x0c4356, 0x298d, 0x0000, 0, 58 }, /* #82 */
    { 0x333456, 0x333456, 0x298d, 0x0000, 0, 58 }, /* #82 b */
    { 0x2d0c43, 0x2d0456, 0x96f0, 0x0000, 0, 23 }, /* #83 */
    { 0x127396, 0x127356, 0x96f0, 0x0000, 0, 23 }, /* #83 b */
    { 0x111942, 0x111917, 0x8495, 0x2a00, 0, 41 }, /* #84 */
    { 0x2e6697, 0x2e6e17, 0x8495, 0x2a00, 0, 41 }, /* #84 b */
    { 0x0e2ac3, 0x0e2256, 0xb3e6, 0x0000, 0, 58 }, /* #85 */
    { 0x315516, 0x315556, 0xb3e6, 0x0000, 0, 58 }, /* #85 b */
    { 0x291342, 0x291356, 0x3dce, 0x0000, 0, 31 }, /* #86 */
    { 0x166c97, 0x166456, 0x3dce, 0x0000, 0, 31 }, /* #86 b */
    { 0x2f6bd2, 0x2f6b17, 0xa945, 0x28a0, 0, 5  }, /* #87 */
    { 0x101407, 0x101c17, 0xa945, 0x28a0, 0, 5  }, /* #87 b */
    { 0x3f6742, 0x3f6797, 0xcb17, 0xc000, 0, 14 }, /* #88 */
    { 0x001897, 0x001097, 0xcb17, 0xc000, 0, 14 }, /* #88 b */
    { 0x145093, 0x145056, 0xf9e6, 0x0000, 0, 62 }, /* #89 */
    { 0x2b2f46, 0x2b2756, 0xf9e6, 0x0000, 0, 62 }, /* #89 b */
    { 0x181486, 0x181c96, 0xefa9, 0xa400, 0, 10 }, /* #90 */
    { 0x276b53, 0x276b96, 0xefa9, 0xa400, 0, 10 }, /* #90 b */
    { 0x064487, 0x064456, 0x36c7, 0x0000, 0, 21 }, /* #91 */
    { 0x393b52, 0x393356, 0x36c7, 0x0000, 0, 21 }, /* #91 b */
    { 0x000012, 0x000056, 0x0920, 0x0000, 0, 51 }, /* #92 */
    { 0x3f7fc7, 0x3f7756, 0x0920, 0x0000, 0, 51 }, /* #92 b */
    { 0x302d02, 0x302556, 0x9e45, 0x0000, 0, 59 }, /* #93 */
    { 0x0f52d7, 0x0f5256, 0x9e45, 0x0000, 0, 59 }, /* #93 b */
    { 0x2d60d6, 0x2d6056, 0xdbc8, 0x0000, 0, 60 }, /* #94 */
    { 0x121f03, 0x121756, 0xdbc8, 0x0000, 0, 60 }, /* #94 b */
    { 0x072606, 0x072656, 0x205d, 0x0000, 0, 62 }, /* #95 */
    { 0x3859d3, 0x385156, 0x205d, 0x0000, 0, 62 }, /* #95 b */
};
uint32_t const g_cTests_shl_u16_amd = RT_ELEMENTS(g_aTests_shl_u16_amd);

BINU16_TEST_T const g_aTests_shr_u16_amd[] =
{
    { 0x354d53, 0x354556, 0x0000, 0x0000, 0, 18 }, /* #0 */
    { 0x0a3286, 0x0a3256, 0x0000, 0x0000, 0, 18 }, /* #0 b */
    { 0x324757, 0x324756, 0x0000, 0x0000, 0, 21 }, /* #1 */
    { 0x0d3882, 0x0d3056, 0x0000, 0x0000, 0, 21 }, /* #1 b */
    { 0x2215d2, 0x221556, 0x0000, 0x0000, 0, 4  }, /* #2 */
    { 0x1d6a07, 0x1d6256, 0x0000, 0x0000, 0, 4  }, /* #2 b */
    { 0x0562c6, 0x056256, 0x0000, 0x0000, 0, 9  }, /* #3 */
    { 0x3a1d13, 0x3a1556, 0x0000, 0x0000, 0, 9  }, /* #3 b */
    { 0x1e1903, 0x1e1156, 0x0000, 0x0000, 0, 10 }, /* #4 */
    { 0x2166d6, 0x216656, 0x0000, 0x0000, 0, 10 }, /* #4 b */
    { 0x224517, 0x224556, 0x0000, 0x0000, 0, 6  }, /* #5 */
    { 0x1d3ac2, 0x1d3256, 0x0000, 0x0000, 0, 6  }, /* #5 b */
    { 0x356ec6, 0x356ec6, 0x36ca, 0x36ca, 0, 32 }, /* #6 */
    { 0x0a1113, 0x0a1113, 0x36ca, 0x36ca, 0, 32 }, /* #6 b */
    { 0x260887, 0x260056, 0xb8e5, 0x0000, 0, 20 }, /* #7 */
    { 0x197752, 0x197756, 0xb8e5, 0x0000, 0, 20 }, /* #7 b */
    { 0x153682, 0x153657, 0xaf23, 0x0000, 0, 16 }, /* #8 */
    { 0x2a4957, 0x2a4157, 0xaf23, 0x0000, 0, 16 }, /* #8 b */
    { 0x1417d3, 0x141713, 0x2f4a, 0x000b, 0, 10 }, /* #9 */
    { 0x2b6806, 0x2b6013, 0x2f4a, 0x000b, 0, 10 }, /* #9 b */
    { 0x225997, 0x225112, 0x8495, 0x0002, 0, 14 }, /* #10 */
    { 0x1d2642, 0x1d2612, 0x8495, 0x0002, 0, 14 }, /* #10 b */
    { 0x2f1e13, 0x2f1617, 0x3fc8, 0x0003, 0, 12 }, /* #11 */
    { 0x1061c6, 0x106117, 0x3fc8, 0x0003, 0, 12 }, /* #11 b */
    { 0x347943, 0x347113, 0x11af, 0x046b, 0, 2  }, /* #12 */
    { 0x0b0696, 0x0b0613, 0x11af, 0x046b, 0, 2  }, /* #12 b */
    { 0x382102, 0x382156, 0x4d4c, 0x0000, 0, 22 }, /* #13 */
    { 0x075ed7, 0x075656, 0x4d4c, 0x0000, 0, 22 }, /* #13 b */
    { 0x0d4c46, 0x0d4456, 0xa510, 0x0000, 0, 58 }, /* #14 */
    { 0x323393, 0x323356, 0xa510, 0x0000, 0, 58 }, /* #14 b */
    { 0x2355d7, 0x235556, 0xd42c, 0x0000, 0, 56 }, /* #15 */
    { 0x1c2a02, 0x1c2256, 0xd42c, 0x0000, 0, 56 }, /* #15 b */
    { 0x1a2206, 0x1a2212, 0xa41e, 0x0052, 0, 41 }, /* #16 */
    { 0x255dd3, 0x255512, 0xa41e, 0x0052, 0, 41 }, /* #16 b */
    { 0x362b93, 0x362316, 0xf67f, 0x000f, 0, 44 }, /* #17 */
    { 0x095446, 0x095416, 0xf67f, 0x000f, 0, 44 }, /* #17 b */
    { 0x3818d7, 0x381017, 0x2b14, 0x000a, 0, 42 }, /* #18 */
    { 0x076702, 0x076717, 0x2b14, 0x000a, 0, 42 }, /* #18 b */
    { 0x2e45c3, 0x2e4556, 0x777f, 0x0000, 0, 26 }, /* #19 */
    { 0x113a16, 0x113256, 0x777f, 0x0000, 0, 26 }, /* #19 b */
    { 0x080d46, 0x080557, 0xaeb6, 0x0000, 0, 48 }, /* #20 */
    { 0x377293, 0x377257, 0xaeb6, 0x0000, 0, 48 }, /* #20 b */
    { 0x332ec7, 0x332656, 0x6fc3, 0x0000, 0, 57 }, /* #21 */
    { 0x0c5112, 0x0c5156, 0x6fc3, 0x0000, 0, 57 }, /* #21 b */
    { 0x1c4113, 0x1c4156, 0x34d0, 0x0000, 0, 15 }, /* #22 */
    { 0x233ec6, 0x233656, 0x34d0, 0x0000, 0, 15 }, /* #22 b */
    { 0x2f0686, 0x2f0616, 0x852f, 0x0021, 0, 10 }, /* #23 */
    { 0x107953, 0x107116, 0x852f, 0x0021, 0, 10 }, /* #23 b */
    { 0x0825d7, 0x082517, 0xdcad, 0x001b, 0, 43 }, /* #24 */
    { 0x375a02, 0x375217, 0xdcad, 0x001b, 0, 43 }, /* #24 b */
    { 0x144412, 0x144456, 0x475f, 0x0000, 0, 50 }, /* #25 */
    { 0x2b3bc7, 0x2b3356, 0x475f, 0x0000, 0, 50 }, /* #25 b */
    { 0x281883, 0x281013, 0x32b7, 0x0001, 0, 45 }, /* #26 */
    { 0x176756, 0x176713, 0x32b7, 0x0001, 0, 45 }, /* #26 b */
    { 0x2e00c7, 0x2e0056, 0x4910, 0x0000, 0, 29 }, /* #27 */
    { 0x117f12, 0x117756, 0x4910, 0x0000, 0, 29 }, /* #27 b */
    { 0x0a4c47, 0x0a4456, 0xa552, 0x0000, 0, 51 }, /* #28 */
    { 0x353392, 0x353356, 0xa552, 0x0000, 0, 51 }, /* #28 b */
    { 0x030a92, 0x030216, 0x2a8a, 0x0055, 0, 39 }, /* #29 */
    { 0x3c7547, 0x3c7516, 0x2a8a, 0x0055, 0, 39 }, /* #29 b */
    { 0x1d5916, 0x1d5116, 0x6a8c, 0x0003, 0, 13 }, /* #30 */
    { 0x2226c3, 0x222616, 0x6a8c, 0x0003, 0, 13 }, /* #30 b */
    { 0x321b56, 0x321356, 0x6369, 0x0000, 0, 54 }, /* #31 */
    { 0x0d6483, 0x0d6456, 0x6369, 0x0000, 0, 54 }, /* #31 b */
    { 0x022006, 0x022056, 0x7100, 0x0000, 0, 60 }, /* #32 */
    { 0x3d5fd3, 0x3d5756, 0x7100, 0x0000, 0, 60 }, /* #32 b */
    { 0x275e03, 0x275656, 0x494d, 0x0000, 0, 23 }, /* #33 */
    { 0x1821d6, 0x182156, 0x494d, 0x0000, 0, 23 }, /* #33 b */
    { 0x1813c3, 0x181312, 0x3c16, 0x1e0b, 0, 1  }, /* #34 */
    { 0x276c16, 0x276412, 0x3c16, 0x1e0b, 0, 1  }, /* #34 b */
    { 0x1f5e87, 0x1f5656, 0x1803, 0x0000, 0, 60 }, /* #35 */
    { 0x202152, 0x202156, 0x1803, 0x0000, 0, 60 }, /* #35 b */
    { 0x1615c7, 0x161512, 0xb20b, 0x000b, 0, 12 }, /* #36 */
    { 0x296a12, 0x296212, 0xb20b, 0x000b, 0, 12 }, /* #36 b */
    { 0x0a7bd7, 0x0a7312, 0x9852, 0x0026, 0, 42 }, /* #37 */
    { 0x350402, 0x350412, 0x9852, 0x0026, 0, 42 }, /* #37 b */
    { 0x251193, 0x251156, 0xb07a, 0x0000, 0, 21 }, /* #38 */
    { 0x1a6e46, 0x1a6656, 0xb07a, 0x0000, 0, 21 }, /* #38 b */
    { 0x317093, 0x317056, 0x45c3, 0x0000, 0, 23 }, /* #39 */
    { 0x0e0f46, 0x0e0756, 0x45c3, 0x0000, 0, 23 }, /* #39 b */
    { 0x080952, 0x080156, 0xb738, 0x0000, 0, 50 }, /* #40 */
    { 0x377687, 0x377656, 0xb738, 0x0000, 0, 50 }, /* #40 b */
    { 0x1f5942, 0x1f5112, 0x8017, 0x0040, 0, 41 }, /* #41 */
    { 0x202697, 0x202612, 0x8017, 0x0040, 0, 41 }, /* #41 b */
    { 0x183086, 0x183013, 0x4e8e, 0x0013, 0, 42 }, /* #42 */
    { 0x274f53, 0x274713, 0x4e8e, 0x0013, 0, 42 }, /* #42 b */
    { 0x295302, 0x295316, 0xc167, 0x000c, 0, 12 }, /* #43 */
    { 0x162cd7, 0x162416, 0xc167, 0x000c, 0, 12 }, /* #43 b */
    { 0x385617, 0x385656, 0x93e7, 0x0000, 0, 55 }, /* #44 */
    { 0x0729c2, 0x072156, 0x93e7, 0x0000, 0, 55 }, /* #44 b */
    { 0x0d2b82, 0x0d2356, 0x8dca, 0x0000, 0, 52 }, /* #45 */
    { 0x325457, 0x325456, 0x8dca, 0x0000, 0, 52 }, /* #45 b */
    { 0x095643, 0x095656, 0x3aef, 0x0000, 0, 48 }, /* #46 */
    { 0x362996, 0x362156, 0x3aef, 0x0000, 0, 48 }, /* #46 b */
    { 0x0e3416, 0x0e3456, 0x2d9d, 0x0000, 0, 19 }, /* #47 */
    { 0x314bc3, 0x314356, 0x2d9d, 0x0000, 0, 19 }, /* #47 b */
    { 0x0c55c2, 0x0c5516, 0xf16c, 0x078b, 0, 5  }, /* #48 */
    { 0x332a17, 0x332216, 0xf16c, 0x078b, 0, 5  }, /* #48 b */
    { 0x1932c3, 0x193256, 0x5140, 0x0000, 0, 21 }, /* #49 */
    { 0x264d16, 0x264556, 0x5140, 0x0000, 0, 21 }, /* #49 b */
    { 0x0d7396, 0x0d7313, 0x4acc, 0x0004, 0, 12 }, /* #50 */
    { 0x320c43, 0x320413, 0x4acc, 0x0004, 0, 12 }, /* #50 b */
    { 0x216946, 0x216156, 0xb21d, 0x0000, 0, 56 }, /* #51 */
    { 0x1e1693, 0x1e1656, 0xb21d, 0x0000, 0, 56 }, /* #51 b */
    { 0x310957, 0x310116, 0xd88e, 0x0036, 0, 42 }, /* #52 */
    { 0x0e7682, 0x0e7616, 0xd88e, 0x0036, 0, 42 }, /* #52 b */
    { 0x0b7d43, 0x0b7556, 0x1f5f, 0x0000, 0, 57 }, /* #53 */
    { 0x340296, 0x340256, 0x1f5f, 0x0000, 0, 57 }, /* #53 b */
    { 0x011c07, 0x011456, 0x8db3, 0x0000, 0, 20 }, /* #54 */
    { 0x3e63d2, 0x3e6356, 0x8db3, 0x0000, 0, 20 }, /* #54 b */
    { 0x0b6907, 0x0b6156, 0xce4f, 0x0000, 0, 61 }, /* #55 */
    { 0x3416d2, 0x341656, 0xce4f, 0x0000, 0, 61 }, /* #55 b */
    { 0x2d2217, 0x2d2256, 0x46c6, 0x0000, 0, 30 }, /* #56 */
    { 0x125dc2, 0x125556, 0x46c6, 0x0000, 0, 30 }, /* #56 b */
    { 0x010253, 0x010213, 0x5fef, 0x0bfd, 0, 35 }, /* #57 */
    { 0x3e7d86, 0x3e7513, 0x5fef, 0x0bfd, 0, 35 }, /* #57 b */
    { 0x002313, 0x002356, 0x1f40, 0x0000, 0, 27 }, /* #58 */
    { 0x3f5cc6, 0x3f5456, 0x1f40, 0x0000, 0, 27 }, /* #58 b */
    { 0x003c56, 0x003416, 0x1903, 0x0003, 0, 11 }, /* #59 */
    { 0x3f4383, 0x3f4316, 0x1903, 0x0003, 0, 11 }, /* #59 b */
    { 0x121852, 0x121056, 0x90a4, 0x0000, 0, 55 }, /* #60 */
    { 0x2d6787, 0x2d6756, 0x90a4, 0x0000, 0, 55 }, /* #60 b */
    { 0x272197, 0x272917, 0xe0c7, 0x7063, 0, 1  }, /* #61 */
    { 0x185e42, 0x185e17, 0xe0c7, 0x7063, 0, 1  }, /* #61 b */
    { 0x2a5dd3, 0x2a5517, 0x7ae4, 0x001e, 0, 10 }, /* #62 */
    { 0x152206, 0x152217, 0x7ae4, 0x001e, 0, 10 }, /* #62 b */
    { 0x3452c7, 0x345217, 0x08be, 0x0022, 0, 38 }, /* #63 */
    { 0x0b2d12, 0x0b2517, 0x08be, 0x0022, 0, 38 }, /* #63 b */
    { 0x353502, 0x353d17, 0x8d1b, 0x468d, 0, 33 }, /* #64 */
    { 0x0a4ad7, 0x0a4a17, 0x8d1b, 0x468d, 0, 33 }, /* #64 b */
    { 0x1a6d02, 0x1a6513, 0x66f9, 0x0001, 0, 46 }, /* #65 */
    { 0x2512d7, 0x251213, 0x66f9, 0x0001, 0, 46 }, /* #65 b */
    { 0x133007, 0x133016, 0x4c36, 0x04c3, 0, 4  }, /* #66 */
    { 0x2c4fd2, 0x2c4716, 0x4c36, 0x04c3, 0, 4  }, /* #66 b */
    { 0x385352, 0x385313, 0xfbef, 0x03ef, 0, 6  }, /* #67 */
    { 0x072c87, 0x072413, 0xfbef, 0x03ef, 0, 6  }, /* #67 b */
    { 0x243712, 0x243717, 0xc4be, 0x0c4b, 0, 36 }, /* #68 */
    { 0x1b48c7, 0x1b4017, 0xc4be, 0x0c4b, 0, 36 }, /* #68 b */
    { 0x017507, 0x017517, 0xfaf3, 0x00fa, 0, 40 }, /* #69 */
    { 0x3e0ad2, 0x3e0217, 0xfaf3, 0x00fa, 0, 40 }, /* #69 b */
    { 0x3873d6, 0x3873d6, 0x9a97, 0x9a97, 0, 0  }, /* #70 */
    { 0x070c03, 0x070c03, 0x9a97, 0x9a97, 0, 0  }, /* #70 b */
    { 0x3f56c2, 0x3f5616, 0xb7d9, 0x2df6, 0, 34 }, /* #71 */
    { 0x002917, 0x002116, 0xb7d9, 0x2df6, 0, 34 }, /* #71 b */
    { 0x187896, 0x187056, 0x07c8, 0x0000, 0, 29 }, /* #72 */
    { 0x270743, 0x270756, 0x07c8, 0x0000, 0, 29 }, /* #72 b */
    { 0x210a86, 0x210256, 0x38ae, 0x0000, 0, 23 }, /* #73 */
    { 0x1e7553, 0x1e7556, 0x38ae, 0x0000, 0, 23 }, /* #73 b */
    { 0x0f6097, 0x0f6012, 0xc029, 0x0601, 0, 5  }, /* #74 */
    { 0x301f42, 0x301712, 0xc029, 0x0601, 0, 5  }, /* #74 b */
    { 0x2b3e96, 0x2b3656, 0xb2d1, 0x0000, 0, 25 }, /* #75 */
    { 0x144143, 0x144156, 0xb2d1, 0x0000, 0, 25 }, /* #75 b */
    { 0x297496, 0x297417, 0x0bdb, 0x00bd, 0, 36 }, /* #76 */
    { 0x160b43, 0x160317, 0x0bdb, 0x00bd, 0, 36 }, /* #76 b */
    { 0x2b24c2, 0x2b2413, 0x9dec, 0x009d, 0, 8  }, /* #77 */
    { 0x145b17, 0x145313, 0x9dec, 0x009d, 0, 8  }, /* #77 b */
    { 0x142347, 0x142313, 0x1168, 0x0008, 0, 9  }, /* #78 */
    { 0x2b5c92, 0x2b5413, 0x1168, 0x0008, 0, 9  }, /* #78 b */
    { 0x390d93, 0x390556, 0xccec, 0x0000, 0, 20 }, /* #79 */
    { 0x067246, 0x067256, 0xccec, 0x0000, 0, 20 }, /* #79 b */
    { 0x372ac6, 0x372a17, 0xb147, 0x58a3, 0, 1  }, /* #80 */
    { 0x085513, 0x085d17, 0xb147, 0x58a3, 0, 1  }, /* #80 b */
    { 0x091216, 0x091256, 0xa96b, 0x0000, 0, 27 }, /* #81 */
    { 0x366dc3, 0x366556, 0xa96b, 0x0000, 0, 27 }, /* #81 b */
    { 0x0728c2, 0x072012, 0x042d, 0x0008, 0, 7  }, /* #82 */
    { 0x385717, 0x385712, 0x042d, 0x0008, 0, 7  }, /* #82 b */
    { 0x293992, 0x293156, 0x3fe1, 0x0000, 0, 57 }, /* #83 */
    { 0x164647, 0x164656, 0x3fe1, 0x0000, 0, 57 }, /* #83 b */
    { 0x0a1f46, 0x0a1f46, 0x73c3, 0x73c3, 0, 0  }, /* #84 */
    { 0x356093, 0x356093, 0x73c3, 0x73c3, 0, 0  }, /* #84 b */
    { 0x1a09d2, 0x1a0156, 0xdc73, 0x0000, 0, 58 }, /* #85 */
    { 0x257607, 0x257656, 0xdc73, 0x0000, 0, 58 }, /* #85 b */
    { 0x2c0a82, 0x2c0213, 0x7379, 0x0001, 0, 46 }, /* #86 */
    { 0x137557, 0x137513, 0x7379, 0x0001, 0, 46 }, /* #86 b */
    { 0x277ed2, 0x277616, 0x70a6, 0x070a, 0, 36 }, /* #87 */
    { 0x180107, 0x180116, 0x70a6, 0x070a, 0, 36 }, /* #87 b */
    { 0x0a7a92, 0x0a7a92, 0x53bb, 0x53bb, 0, 32 }, /* #88 */
    { 0x350547, 0x350547, 0x53bb, 0x53bb, 0, 32 }, /* #88 b */
    { 0x190607, 0x190656, 0x57fe, 0x0000, 0, 23 }, /* #89 */
    { 0x2679d2, 0x267156, 0x57fe, 0x0000, 0, 23 }, /* #89 b */
    { 0x2c3116, 0x2c3112, 0xbfba, 0x17f7, 0, 35 }, /* #90 */
    { 0x134ec3, 0x134612, 0xbfba, 0x17f7, 0, 35 }, /* #90 b */
    { 0x014dc2, 0x014556, 0x6c95, 0x0000, 0, 24 }, /* #91 */
    { 0x3e3217, 0x3e3256, 0x6c95, 0x0000, 0, 24 }, /* #91 b */
    { 0x1e0c12, 0x1e0416, 0xc53c, 0x00c5, 0, 40 }, /* #92 */
    { 0x2173c7, 0x217316, 0xc53c, 0x00c5, 0, 40 }, /* #92 b */
    { 0x235252, 0x235256, 0x9241, 0x0000, 0, 63 }, /* #93 */
    { 0x1c2d87, 0x1c2556, 0x9241, 0x0000, 0, 63 }, /* #93 b */
    { 0x2c13d2, 0x2c1356, 0x8e91, 0x0000, 0, 19 }, /* #94 */
    { 0x136c07, 0x136456, 0x8e91, 0x0000, 0, 19 }, /* #94 b */
    { 0x113343, 0x113316, 0xadb3, 0x0005, 0, 13 }, /* #95 */
    { 0x2e4c96, 0x2e4416, 0xadb3, 0x0005, 0, 13 }, /* #95 b */
};
uint32_t const g_cTests_shr_u16_amd = RT_ELEMENTS(g_aTests_shr_u16_amd);

BINU16_TEST_T const g_aTests_sar_u16_amd[] =
{
    { 0x191d86, 0x191556, 0x0000, 0x0000, 0, 9  }, /* #0 */
    { 0x266253, 0x266256, 0x0000, 0x0000, 0, 9  }, /* #0 b */
    { 0x307ad3, 0x307256, 0x0000, 0x0000, 0, 31 }, /* #1 */
    { 0x0f0506, 0x0f0556, 0x0000, 0x0000, 0, 31 }, /* #1 b */
    { 0x1321c3, 0x132156, 0x0000, 0x0000, 0, 4  }, /* #2 */
    { 0x2c5e16, 0x2c5656, 0x0000, 0x0000, 0, 4  }, /* #2 b */
    { 0x111643, 0x111656, 0x0000, 0x0000, 0, 39 }, /* #3 */
    { 0x2e6996, 0x2e6156, 0x0000, 0x0000, 0, 39 }, /* #3 b */
    { 0x285582, 0x285556, 0x0000, 0x0000, 0, 57 }, /* #4 */
    { 0x172a57, 0x172256, 0x0000, 0x0000, 0, 57 }, /* #4 b */
    { 0x364456, 0x364456, 0x0000, 0x0000, 0, 6  }, /* #5 */
    { 0x093b83, 0x093356, 0x0000, 0x0000, 0, 6  }, /* #5 b */
    { 0x1363c2, 0x136317, 0x13aa, 0x0009, 0, 9  }, /* #6 */
    { 0x2c1c17, 0x2c1417, 0x13aa, 0x0009, 0, 9  }, /* #6 b */
    { 0x150396, 0x150397, 0xb00b, 0xffff, 0, 31 }, /* #7 */
    { 0x2a7c43, 0x2a7497, 0xb00b, 0xffff, 0, 31 }, /* #7 b */
    { 0x1f6e82, 0x1f6656, 0x50c6, 0x0000, 0, 62 }, /* #8 */
    { 0x201157, 0x201156, 0x50c6, 0x0000, 0, 62 }, /* #8 b */
    { 0x062d57, 0x062597, 0xd038, 0xffff, 0, 51 }, /* #9 */
    { 0x395282, 0x395297, 0xd038, 0xffff, 0, 51 }, /* #9 b */
    { 0x194193, 0x194197, 0x8fdf, 0xffff, 0, 60 }, /* #10 */
    { 0x263e46, 0x263697, 0x8fdf, 0xffff, 0, 60 }, /* #10 b */
    { 0x0a3a16, 0x0a3256, 0x51c7, 0x0000, 0, 59 }, /* #11 */
    { 0x3545c3, 0x354556, 0x51c7, 0x0000, 0, 59 }, /* #11 b */
    { 0x3c4807, 0x3c4097, 0xf342, 0xffff, 0, 49 }, /* #12 */
    { 0x0337d2, 0x033797, 0xf342, 0xffff, 0, 49 }, /* #12 b */
    { 0x016616, 0x016697, 0xfb5d, 0xffff, 0, 52 }, /* #13 */
    { 0x3e19c3, 0x3e1197, 0xfb5d, 0xffff, 0, 52 }, /* #13 b */
    { 0x3465d6, 0x346597, 0x84e7, 0xffff, 0, 50 }, /* #14 */
    { 0x0b1a03, 0x0b1297, 0x84e7, 0xffff, 0, 50 }, /* #14 b */
    { 0x0f4c82, 0x0f4456, 0x776e, 0x0000, 0, 49 }, /* #15 */
    { 0x303357, 0x303356, 0x776e, 0x0000, 0, 49 }, /* #15 b */
    { 0x156392, 0x156313, 0x6a3f, 0x01a8, 0, 6  }, /* #16 */
    { 0x2a1c47, 0x2a1413, 0x6a3f, 0x01a8, 0, 6  }, /* #16 b */
    { 0x254682, 0x254697, 0x9cd8, 0xffff, 0, 49 }, /* #17 */
    { 0x1a3957, 0x1a3197, 0x9cd8, 0xffff, 0, 49 }, /* #17 b */
    { 0x254f43, 0x254793, 0xc2f1, 0xffc2, 0, 40 }, /* #18 */
    { 0x1a3096, 0x1a3093, 0xc2f1, 0xffc2, 0, 40 }, /* #18 b */
    { 0x0e16d7, 0x0e1692, 0xeda7, 0xff6d, 0, 37 }, /* #19 */
    { 0x316902, 0x316192, 0xeda7, 0xff6d, 0, 37 }, /* #19 b */
    { 0x210557, 0x210597, 0xe1e2, 0xffe1, 0, 40 }, /* #20 */
    { 0x1e7a82, 0x1e7297, 0xe1e2, 0xffe1, 0, 40 }, /* #20 b */
    { 0x031306, 0x031313, 0x158b, 0x0158, 0, 4  }, /* #21 */
    { 0x3c6cd3, 0x3c6413, 0x158b, 0x0158, 0, 4  }, /* #21 b */
    { 0x325087, 0x325097, 0x9399, 0xffff, 0, 57 }, /* #22 */
    { 0x0d2f52, 0x0d2797, 0x9399, 0xffff, 0, 57 }, /* #22 b */
    { 0x3b6c16, 0x3b6493, 0xfb26, 0xffec, 0, 6  }, /* #23 */
    { 0x0413c3, 0x041393, 0xfb26, 0xffec, 0, 6  }, /* #23 b */
    { 0x037446, 0x037497, 0xe035, 0xffff, 0, 62 }, /* #24 */
    { 0x3c0b93, 0x3c0397, 0xe035, 0xffff, 0, 62 }, /* #24 b */
    { 0x0c7402, 0x0c7456, 0x17e1, 0x0000, 0, 25 }, /* #25 */
    { 0x330bd7, 0x330356, 0x17e1, 0x0000, 0, 25 }, /* #25 b */
    { 0x3a2507, 0x3a2556, 0x1799, 0x0000, 0, 47 }, /* #26 */
    { 0x055ad2, 0x055256, 0x1799, 0x0000, 0, 47 }, /* #26 b */
    { 0x2169d7, 0x216196, 0xd4a0, 0xffff, 0, 14 }, /* #27 */
    { 0x1e1602, 0x1e1696, 0xd4a0, 0xffff, 0, 14 }, /* #27 b */
    { 0x355916, 0x355193, 0xab2e, 0xffea, 0, 10 }, /* #28 */
    { 0x0a26c3, 0x0a2693, 0xab2e, 0xffea, 0, 10 }, /* #28 b */
    { 0x180b13, 0x180397, 0xec49, 0xffff, 0, 59 }, /* #29 */
    { 0x2774c6, 0x277497, 0xec49, 0xffff, 0, 59 }, /* #29 b */
    { 0x2c6ed2, 0x2c6697, 0xe6ff, 0xffff, 0, 28 }, /* #30 */
    { 0x131107, 0x131197, 0xe6ff, 0xffff, 0, 28 }, /* #30 b */
    { 0x177f02, 0x177792, 0xe019, 0xffe0, 0, 8  }, /* #31 */
    { 0x2800d7, 0x280092, 0xe019, 0xffe0, 0, 8  }, /* #31 b */
    { 0x342302, 0x342356, 0x0f96, 0x0000, 0, 14 }, /* #32 */
    { 0x0b5cd7, 0x0b5456, 0x0f96, 0x0000, 0, 14 }, /* #32 b */
    { 0x091982, 0x091193, 0x8ff1, 0xfff1, 0, 11 }, /* #33 */
    { 0x366657, 0x366693, 0x8ff1, 0xfff1, 0, 11 }, /* #33 b */
    { 0x3d4783, 0x3d4712, 0x5828, 0x02c1, 0, 5  }, /* #34 */
    { 0x023856, 0x023012, 0x5828, 0x02c1, 0, 5  }, /* #34 b */
    { 0x077997, 0x077197, 0x9f92, 0xfff3, 0, 43 }, /* #35 */
    { 0x380642, 0x380697, 0x9f92, 0xfff3, 0, 43 }, /* #35 b */
    { 0x223697, 0x223692, 0xa018, 0xfff4, 0, 11 }, /* #36 */
    { 0x1d4942, 0x1d4192, 0xa018, 0xfff4, 0, 11 }, /* #36 b */
    { 0x3f09c3, 0x3f0197, 0x86ee, 0xf0dd, 0, 35 }, /* #37 */
    { 0x007616, 0x007697, 0x86ee, 0xf0dd, 0, 35 }, /* #37 b */
    { 0x260292, 0x260217, 0x5c53, 0x1714, 0, 2  }, /* #38 */
    { 0x197d47, 0x197517, 0x5c53, 0x1714, 0, 2  }, /* #38 b */
    { 0x180b92, 0x180397, 0xb689, 0xffff, 0, 18 }, /* #39 */
    { 0x277447, 0x277497, 0xb689, 0xffff, 0, 18 }, /* #39 b */
    { 0x1452c7, 0x145292, 0x8f93, 0xff1f, 0, 7  }, /* #40 */
    { 0x2b2d12, 0x2b2592, 0x8f93, 0xff1f, 0, 7  }, /* #40 b */
    { 0x001ec2, 0x001613, 0x4684, 0x0008, 0, 11 }, /* #41 */
    { 0x3f6117, 0x3f6113, 0x4684, 0x0008, 0, 11 }, /* #41 b */
    { 0x057d92, 0x057597, 0xeba3, 0xf5d1, 0, 1  }, /* #42 */
    { 0x3a0247, 0x3a0297, 0xeba3, 0xf5d1, 0, 1  }, /* #42 b */
    { 0x034d96, 0x034597, 0xc96d, 0xffff, 0, 50 }, /* #43 */
    { 0x3c3243, 0x3c3297, 0xc96d, 0xffff, 0, 50 }, /* #43 b */
    { 0x292e56, 0x292e56, 0x829e, 0x829e, 0, 0  }, /* #44 */
    { 0x165183, 0x165183, 0x829e, 0x829e, 0, 0  }, /* #44 b */
    { 0x0d6d82, 0x0d6593, 0xbb72, 0xfffd, 0, 13 }, /* #45 */
    { 0x321257, 0x321293, 0xbb72, 0xfffd, 0, 13 }, /* #45 b */
    { 0x232ec2, 0x232612, 0x25f5, 0x0001, 0, 13 }, /* #46 */
    { 0x1c5117, 0x1c5112, 0x25f5, 0x0001, 0, 13 }, /* #46 b */
    { 0x0c56c3, 0x0c5697, 0xb70f, 0xffff, 0, 61 }, /* #47 */
    { 0x332916, 0x332197, 0xb70f, 0xffff, 0, 61 }, /* #47 b */
    { 0x235616, 0x235656, 0x699d, 0x0000, 0, 22 }, /* #48 */
    { 0x1c29c3, 0x1c2156, 0x699d, 0x0000, 0, 22 }, /* #48 b */
    { 0x116282, 0x116257, 0x5cf2, 0x0000, 0, 47 }, /* #49 */
    { 0x2e1d57, 0x2e1557, 0x5cf2, 0x0000, 0, 47 }, /* #49 b */
    { 0x2a6c57, 0x2a6497, 0xb505, 0xffff, 0, 59 }, /* #50 */
    { 0x151382, 0x151397, 0xb505, 0xffff, 0, 59 }, /* #50 b */
    { 0x117c42, 0x117456, 0x1582, 0x0000, 0, 50 }, /* #51 */
    { 0x2e0397, 0x2e0356, 0x1582, 0x0000, 0, 50 }, /* #51 b */
    { 0x014097, 0x014056, 0x228a, 0x0000, 0, 63 }, /* #52 */
    { 0x3e3f42, 0x3e3756, 0x228a, 0x0000, 0, 63 }, /* #52 b */
    { 0x0652d6, 0x065297, 0xa21f, 0xffff, 0, 30 }, /* #53 */
    { 0x392d03, 0x392597, 0xa21f, 0xffff, 0, 30 }, /* #53 b */
    { 0x2d36c6, 0x2d3697, 0xcfc9, 0xffff, 0, 25 }, /* #54 */
    { 0x124913, 0x124197, 0xcfc9, 0xffff, 0, 25 }, /* #54 b */
    { 0x3f4ec3, 0x3f4656, 0x6f66, 0x0000, 0, 16 }, /* #55 */
    { 0x003116, 0x003156, 0x6f66, 0x0000, 0, 16 }, /* #55 b */
    { 0x2a64d3, 0x2a6497, 0x90ef, 0xffff, 0, 61 }, /* #56 */
    { 0x151b06, 0x151397, 0x90ef, 0xffff, 0, 61 }, /* #56 b */
    { 0x0e3282, 0x0e3256, 0x0b0b, 0x0000, 0, 17 }, /* #57 */
    { 0x314d57, 0x314556, 0x0b0b, 0x0000, 0, 17 }, /* #57 b */
    { 0x054d07, 0x054556, 0x64e6, 0x0000, 0, 28 }, /* #58 */
    { 0x3a32d2, 0x3a3256, 0x64e6, 0x0000, 0, 28 }, /* #58 b */
    { 0x2455d6, 0x245556, 0x7606, 0x0000, 0, 28 }, /* #59 */
    { 0x1b2a03, 0x1b2256, 0x7606, 0x0000, 0, 28 }, /* #59 b */
    { 0x333813, 0x333097, 0xacf4, 0xffff, 0, 60 }, /* #60 */
    { 0x0c47c6, 0x0c4797, 0xacf4, 0xffff, 0, 60 }, /* #60 b */
    { 0x163043, 0x163056, 0x0137, 0x0000, 0, 10 }, /* #61 */
    { 0x294f96, 0x294756, 0x0137, 0x0000, 0, 10 }, /* #61 b */
    { 0x027bd3, 0x027316, 0x0d7b, 0x01af, 0, 35 }, /* #62 */
    { 0x3d0406, 0x3d0416, 0x0d7b, 0x01af, 0, 35 }, /* #62 b */
    { 0x2e02c3, 0x2e0256, 0x5afe, 0x0000, 0, 61 }, /* #63 */
    { 0x117d16, 0x117556, 0x5afe, 0x0000, 0, 61 }, /* #63 b */
    { 0x2a2f12, 0x2a2713, 0x3d65, 0x0001, 0, 13 }, /* #64 */
    { 0x1550c7, 0x155013, 0x3d65, 0x0001, 0, 13 }, /* #64 b */
    { 0x0f13c7, 0x0f1397, 0x8a16, 0xffff, 0, 17 }, /* #65 */
    { 0x306c12, 0x306497, 0x8a16, 0xffff, 0, 17 }, /* #65 b */
    { 0x132317, 0x132392, 0x9c28, 0xf385, 0, 3  }, /* #66 */
    { 0x2c5cc2, 0x2c5492, 0x9c28, 0xf385, 0, 3  }, /* #66 b */
    { 0x196806, 0x196012, 0x5b74, 0x000b, 0, 43 }, /* #67 */
    { 0x2617d3, 0x261712, 0x5b74, 0x000b, 0, 43 }, /* #67 b */
    { 0x054407, 0x054497, 0xe3a9, 0xffff, 0, 26 }, /* #68 */
    { 0x3a3bd2, 0x3a3397, 0xe3a9, 0xffff, 0, 26 }, /* #68 b */
    { 0x340496, 0x340413, 0x5358, 0x0002, 0, 45 }, /* #69 */
    { 0x0b7b43, 0x0b7313, 0x5358, 0x0002, 0, 45 }, /* #69 b */
    { 0x007f02, 0x007716, 0x2884, 0x0288, 0, 4  }, /* #70 */
    { 0x3f00d7, 0x3f0016, 0x2884, 0x0288, 0, 4  }, /* #70 b */
    { 0x332703, 0x332712, 0x43eb, 0x0004, 0, 44 }, /* #71 */
    { 0x0c58d6, 0x0c5012, 0x43eb, 0x0004, 0, 44 }, /* #71 b */
    { 0x0c6e12, 0x0c6656, 0x2677, 0x0000, 0, 60 }, /* #72 */
    { 0x3311c7, 0x331156, 0x2677, 0x0000, 0, 60 }, /* #72 b */
    { 0x092302, 0x092393, 0x813a, 0xfe04, 0, 6  }, /* #73 */
    { 0x365cd7, 0x365493, 0x813a, 0xfe04, 0, 6  }, /* #73 b */
    { 0x3b5c43, 0x3b5497, 0xd431, 0xffff, 0, 63 }, /* #74 */
    { 0x042396, 0x042397, 0xd431, 0xffff, 0, 63 }, /* #74 b */
    { 0x375307, 0x375397, 0x8a39, 0xffff, 0, 20 }, /* #75 */
    { 0x082cd2, 0x082497, 0x8a39, 0xffff, 0, 20 }, /* #75 b */
    { 0x2a4053, 0x2a4092, 0xca89, 0xff2a, 0, 6  }, /* #76 */
    { 0x153f86, 0x153792, 0xca89, 0xff2a, 0, 6  }, /* #76 b */
    { 0x263e06, 0x263e06, 0xddc9, 0xddc9, 0, 32 }, /* #77 */
    { 0x1941d3, 0x1941d3, 0xddc9, 0xddc9, 0, 32 }, /* #77 b */
    { 0x131857, 0x131096, 0xe893, 0xffff, 0, 45 }, /* #78 */
    { 0x2c6782, 0x2c6796, 0xe893, 0xffff, 0, 45 }, /* #78 b */
    { 0x142057, 0x142017, 0x51b0, 0x028d, 0, 37 }, /* #79 */
    { 0x2b5f82, 0x2b5717, 0x51b0, 0x028d, 0, 37 }, /* #79 b */
    { 0x181657, 0x181656, 0x410a, 0x0000, 0, 52 }, /* #80 */
    { 0x276982, 0x276156, 0x410a, 0x0000, 0, 52 }, /* #80 b */
    { 0x1b7f97, 0x1b7797, 0xe48d, 0xffff, 0, 19 }, /* #81 */
    { 0x240042, 0x240097, 0xe48d, 0xffff, 0, 19 }, /* #81 b */
    { 0x2d6002, 0x2d6056, 0x5f10, 0x0000, 0, 59 }, /* #82 */
    { 0x121fd7, 0x121756, 0x5f10, 0x0000, 0, 59 }, /* #82 b */
    { 0x0e2197, 0x0e2156, 0x5eee, 0x0000, 0, 54 }, /* #83 */
    { 0x315e42, 0x315656, 0x5eee, 0x0000, 0, 54 }, /* #83 b */
    { 0x151382, 0x151397, 0xd57e, 0xffff, 0, 30 }, /* #84 */
    { 0x2a6c57, 0x2a6497, 0xd57e, 0xffff, 0, 30 }, /* #84 b */
    { 0x3e0d96, 0x3e0597, 0xaebb, 0xffff, 0, 63 }, /* #85 */
    { 0x017243, 0x017297, 0xaebb, 0xffff, 0, 63 }, /* #85 b */
    { 0x173c43, 0x173497, 0xbb50, 0xffff, 0, 53 }, /* #86 */
    { 0x284396, 0x284397, 0xbb50, 0xffff, 0, 53 }, /* #86 b */
    { 0x044882, 0x044097, 0xaaed, 0xffff, 0, 59 }, /* #87 */
    { 0x3b3757, 0x3b3797, 0xaaed, 0xffff, 0, 59 }, /* #87 b */
    { 0x0d6c17, 0x0d6497, 0xadd1, 0xffff, 0, 49 }, /* #88 */
    { 0x3213c2, 0x321397, 0xadd1, 0xffff, 0, 49 }, /* #88 b */
    { 0x3f3b47, 0x3f3397, 0xaaa6, 0xfffa, 0, 44 }, /* #89 */
    { 0x004492, 0x004497, 0xaaa6, 0xfffa, 0, 44 }, /* #89 b */
    { 0x350097, 0x350056, 0x6850, 0x0000, 0, 50 }, /* #90 */
    { 0x0a7f42, 0x0a7756, 0x6850, 0x0000, 0, 50 }, /* #90 b */
    { 0x280f57, 0x280756, 0x4bf1, 0x0000, 0, 23 }, /* #91 */
    { 0x177082, 0x177056, 0x4bf1, 0x0000, 0, 23 }, /* #91 b */
    { 0x0a2a07, 0x0a2296, 0xddda, 0xffff, 0, 46 }, /* #92 */
    { 0x3555d2, 0x355596, 0xddda, 0xffff, 0, 46 }, /* #92 b */
    { 0x084016, 0x084017, 0x5a48, 0x0005, 0, 44 }, /* #93 */
    { 0x373fc3, 0x373717, 0x5a48, 0x0005, 0, 44 }, /* #93 b */
    { 0x183b82, 0x183397, 0xbb1f, 0xffff, 0, 25 }, /* #94 */
    { 0x274457, 0x274497, 0xbb1f, 0xffff, 0, 25 }, /* #94 b */
    { 0x251096, 0x251096, 0xb06b, 0xffd8, 0, 41 }, /* #95 */
    { 0x1a6f43, 0x1a6796, 0xb06b, 0xffd8, 0, 41 }, /* #95 b */
};
uint32_t const g_cTests_sar_u16_amd = RT_ELEMENTS(g_aTests_sar_u16_amd);

BINU32_TEST_T const g_aTests_rol_u32_amd[] =
{
    { 0x2f37d7, 0x2f37d6, 0x00000000, 0x00000000, 0, 51 }, /* #0 */
    { 0x104802, 0x104002, 0x00000000, 0x00000000, 0, 51 }, /* #0 b */
    { 0x107512, 0x107512, 0x00000000, 0x00000000, 0, 59 }, /* #1 */
    { 0x2f0ac7, 0x2f02c6, 0x00000000, 0x00000000, 0, 59 }, /* #1 b */
    { 0x137b03, 0x137302, 0x00000000, 0x00000000, 0, 2  }, /* #2 */
    { 0x2c04d6, 0x2c04d6, 0x00000000, 0x00000000, 0, 2  }, /* #2 b */
    { 0x3d79d2, 0x3d71d2, 0x00000000, 0x00000000, 0, 51 }, /* #3 */
    { 0x020607, 0x020606, 0x00000000, 0x00000000, 0, 51 }, /* #3 b */
    { 0x172492, 0x172492, 0x00000000, 0x00000000, 0, 9  }, /* #4 */
    { 0x285b47, 0x285346, 0x00000000, 0x00000000, 0, 9  }, /* #4 b */
    { 0x3d7692, 0x3d7692, 0x00000000, 0x00000000, 0, 89 }, /* #5 */
    { 0x020947, 0x020146, 0x00000000, 0x00000000, 0, 89 }, /* #5 b */
    { 0x026853, 0x026852, 0xd056f578, 0xadeaf1a0, 0, 41 }, /* #6 */
    { 0x3d1786, 0x3d1f86, 0xd056f578, 0xadeaf1a0, 0, 41 }, /* #6 b */
    { 0x307d87, 0x307587, 0x8bc35d35, 0xae9ac5e1, 0, 111 }, /* #7 */
    { 0x0f0252, 0x0f0253, 0x8bc35d35, 0xae9ac5e1, 0, 111 }, /* #7 b */
    { 0x0d7a06, 0x0d7207, 0xb55bdb73, 0xaadedb9d, 0, 99 }, /* #8 */
    { 0x3205d3, 0x3205d3, 0xb55bdb73, 0xaadedb9d, 0, 99 }, /* #8 b */
    { 0x186ed6, 0x1866d7, 0x5e237d44, 0xe237d445, 0, 36 }, /* #9 */
    { 0x271103, 0x271103, 0x5e237d44, 0xe237d445, 0, 36 }, /* #9 b */
    { 0x045353, 0x045353, 0xf6fc9273, 0xc9273f6f, 0, 12 }, /* #10 */
    { 0x3b2c86, 0x3b2487, 0xf6fc9273, 0xc9273f6f, 0, 12 }, /* #10 b */
    { 0x3c2382, 0x3c2b82, 0xf89a9318, 0x9318f89a, 0, 48 }, /* #11 */
    { 0x035c57, 0x035c56, 0xf89a9318, 0x9318f89a, 0, 48 }, /* #11 b */
    { 0x197853, 0x197052, 0x66c7f718, 0x7f71866c, 0, 12 }, /* #12 */
    { 0x260786, 0x260786, 0x66c7f718, 0x7f71866c, 0, 12 }, /* #12 b */
    { 0x247487, 0x247487, 0xb8fa32eb, 0xd771f465, 0, 89 }, /* #13 */
    { 0x1b0b52, 0x1b0353, 0xb8fa32eb, 0xd771f465, 0, 89 }, /* #13 b */
    { 0x2e6d92, 0x2e6d93, 0x87b14c76, 0x14c7687b, 0, 108 }, /* #14 */
    { 0x111247, 0x111a47, 0x87b14c76, 0x14c7687b, 0, 108 }, /* #14 b */
    { 0x224093, 0x224092, 0x12d31b3d, 0x6cf44b4c, 0, 114 }, /* #15 */
    { 0x1d3f46, 0x1d3746, 0x12d31b3d, 0x6cf44b4c, 0, 114 }, /* #15 b */
    { 0x205b53, 0x205353, 0x32136a5f, 0x9909b52f, 0, 63 }, /* #16 */
    { 0x1f2486, 0x1f2487, 0x32136a5f, 0x9909b52f, 0, 63 }, /* #16 b */
    { 0x2c6987, 0x2c6187, 0x724e87ff, 0xfdc93a1f, 0, 122 }, /* #17 */
    { 0x131652, 0x131653, 0x724e87ff, 0xfdc93a1f, 0, 122 }, /* #17 b */
    { 0x306dd7, 0x3065d6, 0x559887c8, 0x2acc43e4, 0, 95 }, /* #18 */
    { 0x0f1202, 0x0f1202, 0x559887c8, 0x2acc43e4, 0, 95 }, /* #18 b */
    { 0x0d7686, 0x0d7686, 0xda2ab206, 0x55640db4, 0, 41 }, /* #19 */
    { 0x320953, 0x320152, 0xda2ab206, 0x55640db4, 0, 41 }, /* #19 b */
    { 0x2732c7, 0x273ac7, 0x64385767, 0x67643857, 0, 24 }, /* #20 */
    { 0x184d12, 0x184d13, 0x64385767, 0x67643857, 0, 24 }, /* #20 b */
    { 0x206516, 0x206d17, 0x74d65bbf, 0x6efdd359, 0, 50 }, /* #21 */
    { 0x1f1ac3, 0x1f1ac3, 0x74d65bbf, 0x6efdd359, 0, 50 }, /* #21 b */
    { 0x325ed6, 0x3256d6, 0x6ccdaf87, 0x6d7c3b66, 0, 11 }, /* #22 */
    { 0x0d2103, 0x0d2102, 0x6ccdaf87, 0x6d7c3b66, 0, 11 }, /* #22 b */
    { 0x250682, 0x250e83, 0xe7a40ba5, 0x205d2f3d, 0, 75 }, /* #23 */
    { 0x1a7957, 0x1a7957, 0xe7a40ba5, 0x205d2f3d, 0, 75 }, /* #23 b */
    { 0x224fc6, 0x224fc6, 0xfea7922a, 0xafea7922, 0, 92 }, /* #24 */
    { 0x1d3013, 0x1d3812, 0xfea7922a, 0xafea7922, 0, 92 }, /* #24 b */
    { 0x230a42, 0x230a42, 0x0df889d5, 0xa1bf113a, 0, 29 }, /* #25 */
    { 0x1c7597, 0x1c7d96, 0x0df889d5, 0xa1bf113a, 0, 29 }, /* #25 b */
    { 0x187697, 0x187e97, 0x8619651f, 0x2ca3f0c3, 0, 45 }, /* #26 */
    { 0x270942, 0x270943, 0x8619651f, 0x2ca3f0c3, 0, 45 }, /* #26 b */
    { 0x333787, 0x333786, 0xd9982e16, 0x5b6660b8, 0, 122 }, /* #27 */
    { 0x0c4852, 0x0c4052, 0xd9982e16, 0x5b6660b8, 0, 122 }, /* #27 b */
    { 0x363a86, 0x363a87, 0x7606b558, 0x0ec0d6ab, 0, 29 }, /* #28 */
    { 0x094553, 0x094d53, 0x7606b558, 0x0ec0d6ab, 0, 29 }, /* #28 b */
    { 0x116a93, 0x116a92, 0x58416626, 0x99610598, 0, 58 }, /* #29 */
    { 0x2e1546, 0x2e1d46, 0x58416626, 0x99610598, 0, 58 }, /* #29 b */
    { 0x2a0b06, 0x2a0307, 0x578ef913, 0xdf226af1, 0, 77 }, /* #30 */
    { 0x1574d3, 0x1574d3, 0x578ef913, 0xdf226af1, 0, 77 }, /* #30 b */
    { 0x2d3357, 0x2d3356, 0xb647c48e, 0x75b23e24, 0, 59 }, /* #31 */
    { 0x124c82, 0x124482, 0xb647c48e, 0x75b23e24, 0, 59 }, /* #31 b */
    { 0x2a3b92, 0x2a3b92, 0xc2483301, 0xcc070920, 0, 82 }, /* #32 */
    { 0x154447, 0x154c46, 0xc2483301, 0xcc070920, 0, 82 }, /* #32 b */
    { 0x291613, 0x291e13, 0x08e85467, 0x19c23a15, 0, 22 }, /* #33 */
    { 0x1669c6, 0x1669c7, 0x08e85467, 0x19c23a15, 0, 22 }, /* #33 b */
    { 0x075b83, 0x075382, 0x125c9d39, 0x7224b93a, 0, 25 }, /* #34 */
    { 0x382456, 0x382456, 0x125c9d39, 0x7224b93a, 0, 25 }, /* #34 b */
    { 0x1f3b93, 0x1f3392, 0x9bc26070, 0x260709bc, 0, 76 }, /* #35 */
    { 0x204446, 0x204446, 0x9bc26070, 0x260709bc, 0, 76 }, /* #35 b */
    { 0x1c6b17, 0x1c6316, 0xe5989ca6, 0x729b9662, 0, 18 }, /* #36 */
    { 0x2314c2, 0x2314c2, 0xe5989ca6, 0x729b9662, 0, 18 }, /* #36 b */
    { 0x1f1452, 0x1f1c52, 0xfeaeb927, 0x93ff575c, 0, 23 }, /* #37 */
    { 0x206b87, 0x206b86, 0xfeaeb927, 0x93ff575c, 0, 23 }, /* #37 b */
    { 0x0763d6, 0x076bd6, 0x30bf235e, 0x8d78c2fc, 0, 82 }, /* #38 */
    { 0x381c03, 0x381c02, 0x30bf235e, 0x8d78c2fc, 0, 82 }, /* #38 b */
    { 0x3111c3, 0x3111c2, 0x98d5c45c, 0x45c98d5c, 0, 20 }, /* #39 */
    { 0x0e6e16, 0x0e6616, 0x98d5c45c, 0x45c98d5c, 0, 20 }, /* #39 b */
    { 0x121956, 0x121156, 0x8e050ed6, 0x143b5a38, 0, 74 }, /* #40 */
    { 0x2d6683, 0x2d6682, 0x8e050ed6, 0x143b5a38, 0, 74 }, /* #40 b */
    { 0x1b0c12, 0x1b0c12, 0x2dd344b0, 0x89605ba6, 0, 81 }, /* #41 */
    { 0x2473c7, 0x247bc6, 0x2dd344b0, 0x89605ba6, 0, 81 }, /* #41 b */
    { 0x1a2496, 0x1a2c97, 0xc6abaea2, 0x458d575d, 0, 25 }, /* #42 */
    { 0x255b43, 0x255b43, 0xc6abaea2, 0x458d575d, 0, 25 }, /* #42 b */
    { 0x3c3a52, 0x3c3252, 0xdbb434c1, 0x1dbb434c, 0, 28 }, /* #43 */
    { 0x034587, 0x034586, 0xdbb434c1, 0x1dbb434c, 0, 28 }, /* #43 b */
    { 0x144853, 0x144852, 0xba184c36, 0x86130dae, 0, 6  }, /* #44 */
    { 0x2b3786, 0x2b3f86, 0xba184c36, 0x86130dae, 0, 6  }, /* #44 b */
    { 0x2c3f96, 0x2c3f97, 0x784c781e, 0x098f03cf, 0, 69 }, /* #45 */
    { 0x134043, 0x134843, 0x784c781e, 0x098f03cf, 0, 69 }, /* #45 b */
    { 0x1a4657, 0x1a4657, 0x51ddf34b, 0xbbe696a3, 0, 73 }, /* #46 */
    { 0x253982, 0x253183, 0x51ddf34b, 0xbbe696a3, 0, 73 }, /* #46 b */
    { 0x120ec2, 0x120ec3, 0x7d64cc2d, 0x26616beb, 0, 43 }, /* #47 */
    { 0x2d7117, 0x2d7917, 0x7d64cc2d, 0x26616beb, 0, 43 }, /* #47 b */
    { 0x026007, 0x026806, 0x7689d6b7, 0xddda275a, 0, 90 }, /* #48 */
    { 0x3d1fd2, 0x3d1fd2, 0x7689d6b7, 0xddda275a, 0, 90 }, /* #48 b */
    { 0x0f1a86, 0x0f1286, 0x5d2098df, 0x4131beba, 0, 105 }, /* #49 */
    { 0x306553, 0x306552, 0x5d2098df, 0x4131beba, 0, 105 }, /* #49 b */
    { 0x1142d6, 0x1142d7, 0xd4c2a79e, 0xcf6a6153, 0, 55 }, /* #50 */
    { 0x2e3d03, 0x2e3503, 0xd4c2a79e, 0xcf6a6153, 0, 55 }, /* #50 b */
    { 0x082b93, 0x082393, 0x434004f9, 0xf2868009, 0, 25 }, /* #51 */
    { 0x375446, 0x375447, 0x434004f9, 0xf2868009, 0, 25 }, /* #51 b */
    { 0x380987, 0x380987, 0x750f30b6, 0x30b6750f, 0, 112 }, /* #52 */
    { 0x077652, 0x077e53, 0x750f30b6, 0x30b6750f, 0, 112 }, /* #52 b */
    { 0x344b43, 0x344343, 0x28cc1a2c, 0xa2c28cc1, 0, 116 }, /* #53 */
    { 0x0b3496, 0x0b3497, 0x28cc1a2c, 0xa2c28cc1, 0, 116 }, /* #53 b */
    { 0x230407, 0x230407, 0xebe311a6, 0xebe311a6, 0, 32 }, /* #54 */
    { 0x1c7bd2, 0x1c7bd2, 0xebe311a6, 0xebe311a6, 0, 32 }, /* #54 b */
    { 0x382cc2, 0x382cc2, 0x72849b46, 0xda339424, 0, 19 }, /* #55 */
    { 0x075317, 0x075b16, 0x72849b46, 0xda339424, 0, 19 }, /* #55 b */
    { 0x2d2947, 0x2d2147, 0x8ff09898, 0xf098988f, 0, 40 }, /* #56 */
    { 0x125692, 0x125693, 0x8ff09898, 0xf098988f, 0, 40 }, /* #56 b */
    { 0x257513, 0x257d13, 0x7a86a137, 0x50d426ef, 0, 101 }, /* #57 */
    { 0x1a0ac6, 0x1a0ac7, 0x7a86a137, 0x50d426ef, 0, 101 }, /* #57 b */
    { 0x3102d6, 0x310ad7, 0x5af9900b, 0x6be6402d, 0, 2  }, /* #58 */
    { 0x0e7d03, 0x0e7d03, 0x5af9900b, 0x6be6402d, 0, 2  }, /* #58 b */
    { 0x117007, 0x117807, 0x76915e94, 0x22bd28ed, 0, 9  }, /* #59 */
    { 0x2e0fd2, 0x2e0fd3, 0x76915e94, 0x22bd28ed, 0, 9  }, /* #59 b */
    { 0x2d1153, 0x2d1153, 0x71cbefe8, 0xc72fbfa1, 0, 98 }, /* #60 */
    { 0x126e86, 0x126687, 0x71cbefe8, 0xc72fbfa1, 0, 98 }, /* #60 b */
    { 0x143f42, 0x143f42, 0x1f86a465, 0xca3f0d48, 0, 57 }, /* #61 */
    { 0x2b4097, 0x2b4896, 0x1f86a465, 0xca3f0d48, 0, 57 }, /* #61 b */
    { 0x364447, 0x364446, 0x0504d488, 0x01413522, 0, 30 }, /* #62 */
    { 0x093b92, 0x093392, 0x0504d488, 0x01413522, 0, 30 }, /* #62 b */
    { 0x370256, 0x370257, 0xe14230c9, 0xc2846193, 0, 1  }, /* #63 */
    { 0x087d83, 0x087583, 0xe14230c9, 0xc2846193, 0, 1  }, /* #63 b */
    { 0x2e04c6, 0x2e0cc6, 0xb30e9aef, 0xe9aefb30, 0, 108 }, /* #64 */
    { 0x117b13, 0x117b12, 0xb30e9aef, 0xe9aefb30, 0, 108 }, /* #64 b */
    { 0x0665c3, 0x0665c3, 0x8f42f70b, 0x8f42f70b, 0, 0  }, /* #65 */
    { 0x391a16, 0x391a16, 0x8f42f70b, 0x8f42f70b, 0, 0  }, /* #65 b */
    { 0x367912, 0x367113, 0xb223ebf4, 0x911f5fa5, 0, 99 }, /* #66 */
    { 0x0906c7, 0x0906c7, 0xb223ebf4, 0x911f5fa5, 0, 99 }, /* #66 b */
    { 0x165157, 0x165157, 0x7449d5db, 0xd127576d, 0, 2  }, /* #67 */
    { 0x292e82, 0x292683, 0x7449d5db, 0xd127576d, 0, 2  }, /* #67 b */
    { 0x134cc6, 0x1344c7, 0x05b0a9a0, 0x854d002d, 0, 75 }, /* #68 */
    { 0x2c3313, 0x2c3313, 0x05b0a9a0, 0x854d002d, 0, 75 }, /* #68 b */
    { 0x3d0ac6, 0x3d02c7, 0x27ab6d76, 0xeadb5d89, 0, 38 }, /* #69 */
    { 0x027513, 0x027513, 0x27ab6d76, 0xeadb5d89, 0, 38 }, /* #69 b */
    { 0x353816, 0x353016, 0x1b8a6633, 0x331b8a66, 0, 56 }, /* #70 */
    { 0x0a47c3, 0x0a47c2, 0x1b8a6633, 0x331b8a66, 0, 56 }, /* #70 b */
    { 0x1e4653, 0x1e4e52, 0x489b0d5d, 0xd5d489b0, 0, 20 }, /* #71 */
    { 0x213986, 0x213986, 0x489b0d5d, 0xd5d489b0, 0, 20 }, /* #71 b */
    { 0x1e6f43, 0x1e6743, 0xec647326, 0xb191cc9b, 0, 98 }, /* #72 */
    { 0x211096, 0x211097, 0xec647326, 0xb191cc9b, 0, 98 }, /* #72 b */
    { 0x2c7b06, 0x2c7b06, 0x4094038e, 0x8128071c, 0, 65 }, /* #73 */
    { 0x1304d3, 0x130cd2, 0x4094038e, 0x8128071c, 0, 65 }, /* #73 b */
    { 0x181a52, 0x181a52, 0xeb2818da, 0xdaeb2818, 0, 88 }, /* #74 */
    { 0x276587, 0x276d86, 0xeb2818da, 0xdaeb2818, 0, 88 }, /* #74 b */
    { 0x0a0716, 0x0a0716, 0x6a218908, 0x4843510c, 0, 83 }, /* #75 */
    { 0x3578c3, 0x3570c2, 0x6a218908, 0x4843510c, 0, 83 }, /* #75 b */
    { 0x180502, 0x180d02, 0x530c2364, 0xc8a61846, 0, 25 }, /* #76 */
    { 0x277ad7, 0x277ad6, 0x530c2364, 0xc8a61846, 0, 25 }, /* #76 b */
    { 0x0d75c7, 0x0d75c7, 0x85717580, 0xc5d60215, 0, 74 }, /* #77 */
    { 0x320a12, 0x320213, 0x85717580, 0xc5d60215, 0, 74 }, /* #77 b */
    { 0x256842, 0x256042, 0x5abb812f, 0x04bd6aee, 0, 50 }, /* #78 */
    { 0x1a1797, 0x1a1796, 0x5abb812f, 0x04bd6aee, 0, 50 }, /* #78 b */
    { 0x020e82, 0x020e83, 0x20e3e853, 0x071f4299, 0, 3  }, /* #79 */
    { 0x3d7157, 0x3d7957, 0x20e3e853, 0x071f4299, 0, 3  }, /* #79 b */
    { 0x260d53, 0x260553, 0xcd76d2d9, 0xdb4b6735, 0, 74 }, /* #80 */
    { 0x197286, 0x197287, 0xcd76d2d9, 0xdb4b6735, 0, 74 }, /* #80 b */
    { 0x3828d2, 0x3820d3, 0x1309cc90, 0x84e64809, 0, 7  }, /* #81 */
    { 0x075707, 0x075707, 0x1309cc90, 0x84e64809, 0, 7  }, /* #81 b */
    { 0x1e67c2, 0x1e67c3, 0xf26da7a0, 0xa7a0f26d, 0, 16 }, /* #82 */
    { 0x211817, 0x211017, 0xf26da7a0, 0xa7a0f26d, 0, 16 }, /* #82 b */
    { 0x024693, 0x024e92, 0x156907a3, 0xab483d18, 0, 35 }, /* #83 */
    { 0x3d3946, 0x3d3946, 0x156907a3, 0xab483d18, 0, 35 }, /* #83 b */
    { 0x193256, 0x193a57, 0xab024ad6, 0x6ab024ad, 0, 124 }, /* #84 */
    { 0x264d83, 0x264d83, 0xab024ad6, 0x6ab024ad, 0, 124 }, /* #84 b */
    { 0x1451c6, 0x1451c7, 0xcf0e7d4e, 0x9f53b3c3, 0, 110 }, /* #85 */
    { 0x2b2e13, 0x2b2613, 0xcf0e7d4e, 0x9f53b3c3, 0, 110 }, /* #85 b */
    { 0x214292, 0x214a92, 0x4df6ee91, 0xe914df6e, 0, 20 }, /* #86 */
    { 0x1e3d47, 0x1e3d46, 0x4df6ee91, 0xe914df6e, 0, 20 }, /* #86 b */
    { 0x3a4b12, 0x3a4b12, 0xa329b827, 0x9e8ca6e0, 0, 122 }, /* #87 */
    { 0x0534c7, 0x053cc6, 0xa329b827, 0x9e8ca6e0, 0, 122 }, /* #87 b */
    { 0x394386, 0x394b87, 0xf48a0c4d, 0x4189be91, 0, 45 }, /* #88 */
    { 0x063c53, 0x063c53, 0xf48a0c4d, 0x4189be91, 0, 45 }, /* #88 b */
    { 0x063706, 0x063706, 0x5c0616cf, 0x0616cf5c, 0, 104 }, /* #89 */
    { 0x3948d3, 0x3940d2, 0x5c0616cf, 0x0616cf5c, 0, 104 }, /* #89 b */
    { 0x2008c6, 0x2000c6, 0x9ba2311e, 0x623d3744, 0, 17 }, /* #90 */
    { 0x1f7713, 0x1f7712, 0x9ba2311e, 0x623d3744, 0, 17 }, /* #90 b */
    { 0x322c97, 0x322c96, 0x472aece4, 0xabb3911c, 0, 74 }, /* #91 */
    { 0x0d5342, 0x0d5b42, 0x472aece4, 0xabb3911c, 0, 74 }, /* #91 b */
    { 0x0e4e42, 0x0e4e43, 0xf5fdaa35, 0x1afafed5, 0, 23 }, /* #92 */
    { 0x313197, 0x313997, 0xf5fdaa35, 0x1afafed5, 0, 23 }, /* #92 b */
    { 0x306d93, 0x306d92, 0x976b7293, 0x9cbb5b94, 0, 59 }, /* #93 */
    { 0x0f1246, 0x0f1a46, 0x976b7293, 0x9cbb5b94, 0, 59 }, /* #93 b */
    { 0x3d6892, 0x3d6092, 0x9431ea34, 0x18f51a4a, 0, 71 }, /* #94 */
    { 0x021747, 0x021746, 0x9431ea34, 0x18f51a4a, 0, 71 }, /* #94 b */
    { 0x2d4cd2, 0x2d44d2, 0x6218e05d, 0x18e05d62, 0, 40 }, /* #95 */
    { 0x123307, 0x123306, 0x6218e05d, 0x18e05d62, 0, 40 }, /* #95 b */
};
uint32_t const g_cTests_rol_u32_amd = RT_ELEMENTS(g_aTests_rol_u32_amd);

BINU32_TEST_T const g_aTests_ror_u32_amd[] =
{
    { 0x3a76c3, 0x3a76c2, 0x00000000, 0x00000000, 0, 54 }, /* #0 */
    { 0x050916, 0x050116, 0x00000000, 0x00000000, 0, 54 }, /* #0 b */
    { 0x3d2b57, 0x3d2356, 0x00000000, 0x00000000, 0, 83 }, /* #1 */
    { 0x025482, 0x025482, 0x00000000, 0x00000000, 0, 83 }, /* #1 b */
    { 0x233f06, 0x233706, 0x00000000, 0x00000000, 0, 2  }, /* #2 */
    { 0x1c40d3, 0x1c40d2, 0x00000000, 0x00000000, 0, 2  }, /* #2 b */
    { 0x281b07, 0x281306, 0x00000000, 0x00000000, 0, 102 }, /* #3 */
    { 0x1764d2, 0x1764d2, 0x00000000, 0x00000000, 0, 102 }, /* #3 b */
    { 0x2f4196, 0x2f4196, 0x00000000, 0x00000000, 0, 8  }, /* #4 */
    { 0x103e43, 0x103642, 0x00000000, 0x00000000, 0, 8  }, /* #4 b */
    { 0x1a3696, 0x1a3696, 0x00000000, 0x00000000, 0, 45 }, /* #5 */
    { 0x254943, 0x254142, 0x00000000, 0x00000000, 0, 45 }, /* #5 b */
    { 0x0f6786, 0x0f6787, 0xa0a2e4cc, 0xca0a2e4c, 0, 36 }, /* #6 */
    { 0x301853, 0x301053, 0xa0a2e4cc, 0xca0a2e4c, 0, 36 }, /* #6 b */
    { 0x2d3553, 0x2d3553, 0xf2a5d7e7, 0xfcfe54ba, 0, 43 }, /* #7 */
    { 0x124a86, 0x124287, 0xf2a5d7e7, 0xfcfe54ba, 0, 43 }, /* #7 b */
    { 0x0e1603, 0x0e1602, 0xb809463b, 0x18eee025, 0, 14 }, /* #8 */
    { 0x3169d6, 0x3161d6, 0xb809463b, 0x18eee025, 0, 14 }, /* #8 b */
    { 0x000b12, 0x000312, 0x29ec600a, 0x28a7b180, 0, 6  }, /* #9 */
    { 0x3f74c7, 0x3f74c6, 0x29ec600a, 0x28a7b180, 0, 6  }, /* #9 b */
    { 0x2863c3, 0x2863c3, 0xe0b7910f, 0xfe0b7910, 0, 100 }, /* #10 */
    { 0x171c16, 0x171417, 0xe0b7910f, 0xfe0b7910, 0, 100 }, /* #10 b */
    { 0x2f4692, 0x2f4693, 0x2bdd7f8e, 0xebfc715e, 0, 117 }, /* #11 */
    { 0x103947, 0x103147, 0x2bdd7f8e, 0xebfc715e, 0, 117 }, /* #11 b */
    { 0x0f7896, 0x0f7097, 0xc0776f5e, 0xdebd80ee, 0, 15 }, /* #12 */
    { 0x300743, 0x300743, 0xc0776f5e, 0xdebd80ee, 0, 15 }, /* #12 b */
    { 0x0e5946, 0x0e5147, 0x809ccd97, 0xcbc04e66, 0, 73 }, /* #13 */
    { 0x312693, 0x312693, 0x809ccd97, 0xcbc04e66, 0, 73 }, /* #13 b */
    { 0x333413, 0x333413, 0x8567b9b8, 0xcdc42b3d, 0, 77 }, /* #14 */
    { 0x0c4bc6, 0x0c43c7, 0x8567b9b8, 0xcdc42b3d, 0, 77 }, /* #14 b */
    { 0x3f0956, 0x3f0957, 0x4c5199da, 0xb498a333, 0, 7  }, /* #15 */
    { 0x007683, 0x007e83, 0x4c5199da, 0xb498a333, 0, 7  }, /* #15 b */
    { 0x080b86, 0x080b87, 0x88aec27a, 0x9ea22bb0, 0, 10 }, /* #16 */
    { 0x377453, 0x377c53, 0x88aec27a, 0x9ea22bb0, 0, 10 }, /* #16 b */
    { 0x351957, 0x351957, 0x929258d9, 0x92c6cc94, 0, 21 }, /* #17 */
    { 0x0a6682, 0x0a6e83, 0x929258d9, 0x92c6cc94, 0, 21 }, /* #17 b */
    { 0x3e2e97, 0x3e2e96, 0xc2e684e3, 0x4271e173, 0, 17 }, /* #18 */
    { 0x015142, 0x015942, 0xc2e684e3, 0x4271e173, 0, 17 }, /* #18 b */
    { 0x023303, 0x023b03, 0x37253591, 0xa6b226e4, 0, 51 }, /* #19 */
    { 0x3d4cd6, 0x3d4cd7, 0x37253591, 0xa6b226e4, 0, 51 }, /* #19 b */
    { 0x0c5747, 0x0c5747, 0x8335b42d, 0x8335b42d, 0, 0  }, /* #20 */
    { 0x332892, 0x332892, 0x8335b42d, 0x8335b42d, 0, 0  }, /* #20 b */
    { 0x2a6606, 0x2a6e07, 0x628b8b45, 0xa2e2d158, 0, 58 }, /* #21 */
    { 0x1519d3, 0x1519d3, 0x628b8b45, 0xa2e2d158, 0, 58 }, /* #21 b */
    { 0x250092, 0x250092, 0xd248a418, 0x18d248a4, 0, 8  }, /* #22 */
    { 0x1a7f47, 0x1a7746, 0xd248a418, 0x18d248a4, 0, 8  }, /* #22 b */
    { 0x0718d2, 0x0718d2, 0x28cbeff5, 0x5197dfea, 0, 63 }, /* #23 */
    { 0x386707, 0x386f06, 0x28cbeff5, 0x5197dfea, 0, 63 }, /* #23 b */
    { 0x062d42, 0x062542, 0xa10d814d, 0x05368436, 0, 46 }, /* #24 */
    { 0x395297, 0x395296, 0xa10d814d, 0x05368436, 0, 46 }, /* #24 b */
    { 0x392d53, 0x392d53, 0x7e56e52f, 0xb7297bf2, 0, 117 }, /* #25 */
    { 0x065286, 0x065a87, 0x7e56e52f, 0xb7297bf2, 0, 117 }, /* #25 b */
    { 0x223753, 0x223f53, 0x4db34f91, 0xa7c8a6d9, 0, 113 }, /* #26 */
    { 0x1d4886, 0x1d4887, 0x4db34f91, 0xa7c8a6d9, 0, 113 }, /* #26 b */
    { 0x033703, 0x033703, 0x91d0d8de, 0xde91d0d8, 0, 72 }, /* #27 */
    { 0x3c48d6, 0x3c40d7, 0x91d0d8de, 0xde91d0d8, 0, 72 }, /* #27 b */
    { 0x157ed3, 0x1576d2, 0xf04105e6, 0x05e6f041, 0, 48 }, /* #28 */
    { 0x2a0106, 0x2a0106, 0xf04105e6, 0x05e6f041, 0, 48 }, /* #28 b */
    { 0x340a82, 0x340a82, 0x54b176f0, 0x54b176f0, 0, 0  }, /* #29 */
    { 0x0b7557, 0x0b7557, 0x54b176f0, 0x54b176f0, 0, 0  }, /* #29 b */
    { 0x074682, 0x074e82, 0xcbe5b2ba, 0x597cb657, 0, 67 }, /* #30 */
    { 0x383957, 0x383956, 0xcbe5b2ba, 0x597cb657, 0, 67 }, /* #30 b */
    { 0x332243, 0x332243, 0xa618a698, 0xc530c534, 0, 5  }, /* #31 */
    { 0x0c5d96, 0x0c5597, 0xa618a698, 0xc530c534, 0, 5  }, /* #31 b */
    { 0x313a07, 0x313207, 0x3ea054e6, 0xea054e63, 0, 124 }, /* #32 */
    { 0x0e45d2, 0x0e45d3, 0x3ea054e6, 0xea054e63, 0, 124 }, /* #32 b */
    { 0x180157, 0x180956, 0x5f0a72da, 0x5396d2f8, 0, 117 }, /* #33 */
    { 0x277e82, 0x277e82, 0x5f0a72da, 0x5396d2f8, 0, 117 }, /* #33 b */
    { 0x1762d3, 0x176ad3, 0x76ac0a35, 0xb56051ab, 0, 29 }, /* #34 */
    { 0x281d06, 0x281d07, 0x76ac0a35, 0xb56051ab, 0, 29 }, /* #34 b */
    { 0x041fd3, 0x041fd3, 0xc3e2be5f, 0x97f0f8af, 0, 74 }, /* #35 */
    { 0x3b6006, 0x3b6807, 0xc3e2be5f, 0x97f0f8af, 0, 74 }, /* #35 b */
    { 0x2e3393, 0x2e3393, 0xc26d72ee, 0xc26d72ee, 0, 0  }, /* #36 */
    { 0x114c46, 0x114c46, 0xc26d72ee, 0xc26d72ee, 0, 0  }, /* #36 b */
    { 0x185c86, 0x185c87, 0x41f5e5b2, 0x83ebcb64, 0, 31 }, /* #37 */
    { 0x272353, 0x272b53, 0x41f5e5b2, 0x83ebcb64, 0, 31 }, /* #37 b */
    { 0x151543, 0x151542, 0x537c885b, 0x10b6a6f9, 0, 47 }, /* #38 */
    { 0x2a6a96, 0x2a6296, 0x537c885b, 0x10b6a6f9, 0, 47 }, /* #38 b */
    { 0x2e4756, 0x2e4f57, 0x484eec2f, 0x909dd85e, 0, 63 }, /* #39 */
    { 0x113883, 0x113883, 0x484eec2f, 0x909dd85e, 0, 63 }, /* #39 b */
    { 0x1b6103, 0x1b6102, 0xfdd1bb74, 0x1bb74fdd, 0, 52 }, /* #40 */
    { 0x241ed6, 0x2416d6, 0xfdd1bb74, 0x1bb74fdd, 0, 52 }, /* #40 b */
    { 0x2e0c17, 0x2e0c16, 0xafb7adac, 0x57dbd6d6, 0, 1  }, /* #41 */
    { 0x1173c2, 0x117bc2, 0xafb7adac, 0x57dbd6d6, 0, 1  }, /* #41 b */
    { 0x3d6703, 0x3d6f03, 0x95bfd884, 0x92b7fb10, 0, 67 }, /* #42 */
    { 0x0218d6, 0x0218d7, 0x95bfd884, 0x92b7fb10, 0, 67 }, /* #42 b */
    { 0x1d1e16, 0x1d1e16, 0xabe24fed, 0x7f6d5f12, 0, 45 }, /* #43 */
    { 0x2261c3, 0x2269c2, 0xabe24fed, 0x7f6d5f12, 0, 45 }, /* #43 b */
    { 0x1c3087, 0x1c3886, 0xd791d74a, 0x791d74ad, 0, 92 }, /* #44 */
    { 0x234f52, 0x234f52, 0xd791d74a, 0x791d74ad, 0, 92 }, /* #44 b */
    { 0x081e43, 0x081643, 0xaefa6987, 0xc3d77d34, 0, 41 }, /* #45 */
    { 0x376196, 0x376197, 0xaefa6987, 0xc3d77d34, 0, 41 }, /* #45 b */
    { 0x2d5b92, 0x2d5392, 0x042a6007, 0x0e0854c0, 0, 7  }, /* #46 */
    { 0x122447, 0x122446, 0x042a6007, 0x0e0854c0, 0, 7  }, /* #46 b */
    { 0x375ed6, 0x375ed6, 0xb8f2b296, 0x652d71e5, 0, 15 }, /* #47 */
    { 0x082103, 0x082902, 0xb8f2b296, 0x652d71e5, 0, 15 }, /* #47 b */
    { 0x114186, 0x114186, 0x69f7e6f8, 0x1a7df9be, 0, 34 }, /* #48 */
    { 0x2e3e53, 0x2e3652, 0x69f7e6f8, 0x1a7df9be, 0, 34 }, /* #48 b */
    { 0x347793, 0x347f92, 0x4dab64f7, 0x56c9ee9b, 0, 119 }, /* #49 */
    { 0x0b0846, 0x0b0846, 0x4dab64f7, 0x56c9ee9b, 0, 119 }, /* #49 b */
    { 0x2b6d56, 0x2b6d56, 0x855f8905, 0x5855f890, 0, 4  }, /* #50 */
    { 0x141283, 0x141a82, 0x855f8905, 0x5855f890, 0, 4  }, /* #50 b */
    { 0x1e0f02, 0x1e0702, 0x21189a82, 0x23135044, 0, 27 }, /* #51 */
    { 0x2170d7, 0x2170d6, 0x21189a82, 0x23135044, 0, 27 }, /* #51 b */
    { 0x1c7d82, 0x1c7582, 0x91f6185e, 0x3ec30bd2, 0, 91 }, /* #52 */
    { 0x230257, 0x230256, 0x91f6185e, 0x3ec30bd2, 0, 91 }, /* #52 b */
    { 0x0e2c92, 0x0e2c92, 0xbb19fe79, 0x7633fcf3, 0, 63 }, /* #53 */
    { 0x315347, 0x315b46, 0xbb19fe79, 0x7633fcf3, 0, 63 }, /* #53 b */
    { 0x0c2446, 0x0c2c46, 0x85294e65, 0x6585294e, 0, 8  }, /* #54 */
    { 0x335b93, 0x335b92, 0x85294e65, 0x6585294e, 0, 8  }, /* #54 b */
    { 0x017c53, 0x017452, 0x8ec8b26f, 0x3b22c9be, 0, 126 }, /* #55 */
    { 0x3e0386, 0x3e0386, 0x8ec8b26f, 0x3b22c9be, 0, 126 }, /* #55 b */
    { 0x187507, 0x187506, 0x588690d0, 0x0588690d, 0, 68 }, /* #56 */
    { 0x270ad2, 0x2702d2, 0x588690d0, 0x0588690d, 0, 68 }, /* #56 b */
    { 0x175207, 0x175a06, 0x8a949e6d, 0x5293cdb1, 0, 91 }, /* #57 */
    { 0x282dd2, 0x282dd2, 0x8a949e6d, 0x5293cdb1, 0, 91 }, /* #57 b */
    { 0x3b3d13, 0x3b3d13, 0x2ab10267, 0x88133955, 0, 85 }, /* #58 */
    { 0x0442c6, 0x044ac7, 0x2ab10267, 0x88133955, 0, 85 }, /* #58 b */
    { 0x271843, 0x271843, 0x46e9566e, 0xb372374a, 0, 77 }, /* #59 */
    { 0x186796, 0x186f97, 0x46e9566e, 0xb372374a, 0, 77 }, /* #59 b */
    { 0x1c0587, 0x1c0587, 0x6fb716ff, 0xc5bfdbed, 0, 82 }, /* #60 */
    { 0x237a52, 0x237253, 0x6fb716ff, 0xc5bfdbed, 0, 82 }, /* #60 b */
    { 0x032b02, 0x032b02, 0x69fc9b98, 0x4dcc34fe, 0, 49 }, /* #61 */
    { 0x3c54d7, 0x3c5cd6, 0x69fc9b98, 0x4dcc34fe, 0, 49 }, /* #61 b */
    { 0x244316, 0x244317, 0x690bb863, 0xda42ee18, 0, 34 }, /* #62 */
    { 0x1b3cc3, 0x1b34c3, 0x690bb863, 0xda42ee18, 0, 34 }, /* #62 b */
    { 0x372c96, 0x372c96, 0xb89a8064, 0x4b89a806, 0, 68 }, /* #63 */
    { 0x085343, 0x085b42, 0xb89a8064, 0x4b89a806, 0, 68 }, /* #63 b */
    { 0x131287, 0x131286, 0xbb7b1e62, 0x1e62bb7b, 0, 112 }, /* #64 */
    { 0x2c6d52, 0x2c6552, 0xbb7b1e62, 0x1e62bb7b, 0, 112 }, /* #64 b */
    { 0x083f42, 0x083743, 0x48c64a33, 0xc64a3348, 0, 24 }, /* #65 */
    { 0x374097, 0x374097, 0x48c64a33, 0xc64a3348, 0, 24 }, /* #65 b */
    { 0x2f7e52, 0x2f7e53, 0xa172594c, 0xb29942e4, 0, 15 }, /* #66 */
    { 0x100187, 0x100987, 0xa172594c, 0xb29942e4, 0, 15 }, /* #66 b */
    { 0x3a2bc2, 0x3a23c2, 0x4ce25978, 0x099c4b2f, 0, 99 }, /* #67 */
    { 0x055417, 0x055416, 0x4ce25978, 0x099c4b2f, 0, 99 }, /* #67 b */
    { 0x1d4583, 0x1d4d82, 0xfe7eb6d3, 0x4ff9fadb, 0, 6  }, /* #68 */
    { 0x223a56, 0x223a56, 0xfe7eb6d3, 0x4ff9fadb, 0, 6  }, /* #68 b */
    { 0x3b7796, 0x3b7797, 0x8ca849f4, 0xfa465424, 0, 41 }, /* #69 */
    { 0x040843, 0x040043, 0x8ca849f4, 0xfa465424, 0, 41 }, /* #69 b */
    { 0x111f02, 0x111f03, 0x335300fc, 0xa601f866, 0, 55 }, /* #70 */
    { 0x2e60d7, 0x2e68d7, 0x335300fc, 0xa601f866, 0, 55 }, /* #70 b */
    { 0x054bc3, 0x0543c2, 0xe0f10c53, 0x14f83c43, 0, 10 }, /* #71 */
    { 0x3a3416, 0x3a3416, 0xe0f10c53, 0x14f83c43, 0, 10 }, /* #71 b */
    { 0x2e2bd3, 0x2e2bd2, 0x68d444b4, 0x44b468d4, 0, 48 }, /* #72 */
    { 0x115406, 0x115c06, 0x68d444b4, 0x44b468d4, 0, 48 }, /* #72 b */
    { 0x277113, 0x277913, 0xa5f8cd24, 0x8cd24a5f, 0, 116 }, /* #73 */
    { 0x180ec6, 0x180ec7, 0xa5f8cd24, 0x8cd24a5f, 0, 116 }, /* #73 b */
    { 0x0300c2, 0x0300c2, 0x45a8505f, 0x0a0be8b5, 0, 51 }, /* #74 */
    { 0x3c7f17, 0x3c7716, 0x45a8505f, 0x0a0be8b5, 0, 51 }, /* #74 b */
    { 0x3c4ed6, 0x3c4ed7, 0x6a372581, 0xb51b92c0, 0, 33 }, /* #75 */
    { 0x033103, 0x033903, 0x6a372581, 0xb51b92c0, 0, 33 }, /* #75 b */
    { 0x383216, 0x383a17, 0x556a3cc0, 0xad47980a, 0, 59 }, /* #76 */
    { 0x074dc3, 0x074dc3, 0x556a3cc0, 0xad47980a, 0, 59 }, /* #76 b */
    { 0x174fd2, 0x174fd3, 0x054ce71e, 0x8f02a673, 0, 73 }, /* #77 */
    { 0x283007, 0x283807, 0x054ce71e, 0x8f02a673, 0, 73 }, /* #77 b */
    { 0x085b06, 0x085307, 0x23eb58df, 0xf91f5ac6, 0, 101 }, /* #78 */
    { 0x3724d3, 0x3724d3, 0x23eb58df, 0xf91f5ac6, 0, 101 }, /* #78 b */
    { 0x143907, 0x143106, 0x94c136a8, 0x36a894c1, 0, 16 }, /* #79 */
    { 0x2b46d2, 0x2b46d2, 0x94c136a8, 0x36a894c1, 0, 16 }, /* #79 b */
    { 0x1c0503, 0x1c0d02, 0xbaa2bc15, 0x515e0add, 0, 25 }, /* #80 */
    { 0x237ad6, 0x237ad6, 0xbaa2bc15, 0x515e0add, 0, 25 }, /* #80 b */
    { 0x3f69d2, 0x3f61d2, 0x349c0a71, 0x029c4d27, 0, 50 }, /* #81 */
    { 0x001607, 0x001606, 0x349c0a71, 0x029c4d27, 0, 50 }, /* #81 b */
    { 0x247cc2, 0x247cc3, 0x6dd04bbf, 0xbbf6dd04, 0, 108 }, /* #82 */
    { 0x1b0317, 0x1b0b17, 0x6dd04bbf, 0xbbf6dd04, 0, 108 }, /* #82 b */
    { 0x1c6916, 0x1c6917, 0x20f755cd, 0xa41eeab9, 0, 35 }, /* #83 */
    { 0x2316c3, 0x231ec3, 0x20f755cd, 0xa41eeab9, 0, 35 }, /* #83 b */
    { 0x3c4f42, 0x3c4743, 0x2dc1453f, 0xf2dc1453, 0, 100 }, /* #84 */
    { 0x033097, 0x033097, 0x2dc1453f, 0xf2dc1453, 0, 100 }, /* #84 b */
    { 0x3c5082, 0x3c5882, 0x965178dd, 0x78dd9651, 0, 112 }, /* #85 */
    { 0x032f57, 0x032f56, 0x965178dd, 0x78dd9651, 0, 112 }, /* #85 b */
    { 0x2d0116, 0x2d0117, 0xef77e705, 0xce0bdeef, 0, 111 }, /* #86 */
    { 0x127ec3, 0x1276c3, 0xef77e705, 0xce0bdeef, 0, 111 }, /* #86 b */
    { 0x0f2a42, 0x0f2a43, 0x24a71073, 0x99253883, 0, 37 }, /* #87 */
    { 0x305597, 0x305d97, 0x24a71073, 0x99253883, 0, 37 }, /* #87 b */
    { 0x1f61d2, 0x1f69d2, 0x3eecf096, 0x63eecf09, 0, 100 }, /* #88 */
    { 0x201e07, 0x201e06, 0x3eecf096, 0x63eecf09, 0, 100 }, /* #88 b */
    { 0x023747, 0x023f47, 0x2110dea7, 0x9c84437a, 0, 102 }, /* #89 */
    { 0x3d4892, 0x3d4893, 0x2110dea7, 0x9c84437a, 0, 102 }, /* #89 b */
    { 0x066452, 0x066c53, 0x3f420951, 0xa89fa104, 0, 73 }, /* #90 */
    { 0x391b87, 0x391b87, 0x3f420951, 0xa89fa104, 0, 73 }, /* #90 b */
    { 0x0f3fd3, 0x0f37d3, 0x75ef9e7b, 0xf6ebdf3c, 0, 103 }, /* #91 */
    { 0x304006, 0x304007, 0x75ef9e7b, 0xf6ebdf3c, 0, 103 }, /* #91 b */
    { 0x264907, 0x264906, 0x89461689, 0x61689894, 0, 116 }, /* #92 */
    { 0x1936d2, 0x193ed2, 0x89461689, 0x61689894, 0, 116 }, /* #92 b */
    { 0x3f2697, 0x3f2e97, 0x26d9dc2e, 0x89b6770b, 0, 66 }, /* #93 */
    { 0x005942, 0x005943, 0x26d9dc2e, 0x89b6770b, 0, 66 }, /* #93 b */
    { 0x361246, 0x361a46, 0xc133867d, 0x7dc13386, 0, 40 }, /* #94 */
    { 0x096d93, 0x096d92, 0xc133867d, 0x7dc13386, 0, 40 }, /* #94 b */
    { 0x206107, 0x206907, 0xa74c5a1c, 0xa1ca74c5, 0, 108 }, /* #95 */
    { 0x1f1ed2, 0x1f1ed3, 0xa74c5a1c, 0xa1ca74c5, 0, 108 }, /* #95 b */
};
uint32_t const g_cTests_ror_u32_amd = RT_ELEMENTS(g_aTests_ror_u32_amd);

BINU32_TEST_T const g_aTests_rcl_u32_amd[] =
{
    { 0x1e7d56, 0x1e7d56, 0x00000000, 0x00000000, 0, 32 }, /* #0 */
    { 0x210283, 0x210283, 0x00000000, 0x00000000, 0, 32 }, /* #0 b */
    { 0x3b1982, 0x3b1182, 0x00000000, 0x00000000, 0, 85 }, /* #1 */
    { 0x046657, 0x046656, 0x00000000, 0x00100000, 0, 85 }, /* #1 b */
    { 0x0c5887, 0x0c5086, 0x00000000, 0x10000000, 0, 125 }, /* #2 */
    { 0x332752, 0x332752, 0x00000000, 0x00000000, 0, 125 }, /* #2 b */
    { 0x0c2f56, 0x0c2756, 0x00000000, 0x00000000, 0, 87 }, /* #3 */
    { 0x335083, 0x335082, 0x00000000, 0x00400000, 0, 87 }, /* #3 b */
    { 0x104b17, 0x104316, 0x00000000, 0x40000000, 0, 63 }, /* #4 */
    { 0x2f34c2, 0x2f34c2, 0x00000000, 0x00000000, 0, 63 }, /* #4 b */
    { 0x2b0d12, 0x2b0512, 0x00000000, 0x00000000, 0, 118 }, /* #5 */
    { 0x1472c7, 0x1472c6, 0x00000000, 0x00200000, 0, 118 }, /* #5 b */
    { 0x200952, 0x200153, 0x9ec5fa2f, 0xd8bf45e9, 0, 69 }, /* #6 */
    { 0x1f7687, 0x1f7687, 0x9ec5fa2f, 0xd8bf45f9, 0, 69 }, /* #6 b */
    { 0x100a07, 0x100206, 0x191e2081, 0x3c410319, 0, 9  }, /* #7 */
    { 0x2f75d2, 0x2f75d2, 0x191e2081, 0x3c410219, 0, 9  }, /* #7 b */
    { 0x1d2152, 0x1d2153, 0xf791dcb7, 0xef23b96e, 0, 97 }, /* #8 */
    { 0x225e87, 0x225687, 0xf791dcb7, 0xef23b96f, 0, 97 }, /* #8 b */
    { 0x1b7b53, 0x1b7b53, 0x6bbd2e3c, 0x71e5aef4, 0, 19 }, /* #9 */
    { 0x240486, 0x240c87, 0x6bbd2e3c, 0x71e1aef4, 0, 19 }, /* #9 b */
    { 0x3a7892, 0x3a7092, 0x5c5d2711, 0x5d27112e, 0, 40 }, /* #10 */
    { 0x050747, 0x050746, 0x5c5d2711, 0x5d2711ae, 0, 40 }, /* #10 b */
    { 0x267097, 0x267897, 0xa87f0efe, 0x7f6a1fc3, 0, 119 }, /* #11 */
    { 0x190f42, 0x190f43, 0xa87f0efe, 0x7f2a1fc3, 0, 119 }, /* #11 b */
    { 0x2a5212, 0x2a5a13, 0x07f1c4e3, 0x181fc713, 0, 123 }, /* #12 */
    { 0x152dc7, 0x152dc7, 0x07f1c4e3, 0x1c1fc713, 0, 123 }, /* #12 b */
    { 0x2e6987, 0x2e6986, 0xc0d9f8e4, 0xcfc72703, 0, 43 }, /* #13 */
    { 0x111652, 0x111e52, 0xc0d9f8e4, 0xcfc72303, 0, 43 }, /* #13 b */
    { 0x0b2292, 0x0b2a92, 0xd79ddcb7, 0xed79ddcb, 0, 125 }, /* #14 */
    { 0x345d47, 0x345d46, 0xd79ddcb7, 0xfd79ddcb, 0, 125 }, /* #14 b */
    { 0x330082, 0x330882, 0x4dc4543e, 0x9b88a87c, 0, 1  }, /* #15 */
    { 0x0c7f57, 0x0c7f56, 0x4dc4543e, 0x9b88a87d, 0, 1  }, /* #15 b */
    { 0x0c6f53, 0x0c6753, 0xd6be1104, 0xaf84413a, 0, 70 }, /* #16 */
    { 0x331086, 0x331087, 0xd6be1104, 0xaf84411a, 0, 70 }, /* #16 b */
    { 0x1e3f03, 0x1e3f02, 0x35964b99, 0xb25cccd6, 0, 75 }, /* #17 */
    { 0x2140d6, 0x2148d6, 0x35964b99, 0xb25cc8d6, 0, 75 }, /* #17 b */
    { 0x104e47, 0x104646, 0x0bf478fa, 0x7d42fd1e, 0, 55 }, /* #18 */
    { 0x2f3192, 0x2f3192, 0x0bf478fa, 0x7d02fd1e, 0, 55 }, /* #18 b */
    { 0x1d1896, 0x1d1096, 0x6741064f, 0x0832799d, 0, 43 }, /* #19 */
    { 0x226743, 0x226742, 0x6741064f, 0x08327d9d, 0, 43 }, /* #19 b */
    { 0x1829d2, 0x1821d3, 0xf67d85ab, 0xbd9f616a, 0, 127 }, /* #20 */
    { 0x275607, 0x275607, 0xf67d85ab, 0xfd9f616a, 0, 127 }, /* #20 b */
    { 0x107783, 0x107783, 0xdc9e873d, 0xe873dee4, 0, 76 }, /* #21 */
    { 0x2f0856, 0x2f0057, 0xdc9e873d, 0xe873d6e4, 0, 76 }, /* #21 b */
    { 0x0d7707, 0x0d7706, 0x97d46bda, 0x5f51af6b, 0, 66 }, /* #22 */
    { 0x3208d2, 0x3200d2, 0x97d46bda, 0x5f51af69, 0, 66 }, /* #22 b */
    { 0x327943, 0x327143, 0x06b93cfa, 0xa835c9e7, 0, 92 }, /* #23 */
    { 0x0d0696, 0x0d0697, 0x06b93cfa, 0xa035c9e7, 0, 92 }, /* #23 b */
    { 0x3c1116, 0x3c1916, 0x742311fb, 0xc47ece84, 0, 78 }, /* #24 */
    { 0x036ec3, 0x036ec2, 0x742311fb, 0xc47eee84, 0, 78 }, /* #24 b */
    { 0x2f0d87, 0x2f0d86, 0x53fcd637, 0xd637a9fe, 0, 112 }, /* #25 */
    { 0x107252, 0x107a52, 0x53fcd637, 0xd63729fe, 0, 112 }, /* #25 b */
    { 0x052e07, 0x052607, 0xb2ee1599, 0x8566765d, 0, 110 }, /* #26 */
    { 0x3a51d2, 0x3a51d3, 0xb2ee1599, 0x8566565d, 0, 110 }, /* #26 b */
    { 0x1f7f16, 0x1f7f17, 0xd92dc00d, 0x25b801ad, 0, 101 }, /* #27 */
    { 0x2000c3, 0x2008c3, 0xd92dc00d, 0x25b801bd, 0, 101 }, /* #27 b */
    { 0x021a53, 0x021253, 0xd121f877, 0xfa243f0e, 0, 62 }, /* #28 */
    { 0x3d6586, 0x3d6587, 0xd121f877, 0xda243f0e, 0, 62 }, /* #28 b */
    { 0x2b6717, 0x2b6f16, 0xd31a7759, 0xcf4c69dd, 0, 91 }, /* #29 */
    { 0x1418c2, 0x1418c2, 0xd31a7759, 0xcb4c69dd, 0, 91 }, /* #29 b */
    { 0x1d4c97, 0x1d4c97, 0xb8ad3996, 0x69ccb6e2, 0, 107 }, /* #30 */
    { 0x223342, 0x223b43, 0xb8ad3996, 0x69ccb2e2, 0, 107 }, /* #30 b */
    { 0x373516, 0x373516, 0x0293d788, 0x4f5e2005, 0, 10 }, /* #31 */
    { 0x084ac3, 0x0842c2, 0x0293d788, 0x4f5e2205, 0, 10 }, /* #31 b */
    { 0x090257, 0x090256, 0xd84ba6c7, 0x25d363f6, 0, 71 }, /* #32 */
    { 0x367d82, 0x367582, 0xd84ba6c7, 0x25d363b6, 0, 71 }, /* #32 b */
    { 0x0d35d2, 0x0d3dd3, 0x54125581, 0x5604a824, 0, 114 }, /* #33 */
    { 0x324a07, 0x324a07, 0x54125581, 0x5606a824, 0, 114 }, /* #33 b */
    { 0x1b1b06, 0x1b1b07, 0x635eb3ca, 0x4635eb3c, 0, 61 }, /* #34 */
    { 0x2464d3, 0x246cd3, 0x635eb3ca, 0x5635eb3c, 0, 61 }, /* #34 b */
    { 0x112b93, 0x112392, 0xac8dbca6, 0x536b236f, 0, 119 }, /* #35 */
    { 0x2e5446, 0x2e5446, 0xac8dbca6, 0x532b236f, 0, 119 }, /* #35 b */
    { 0x371ac6, 0x3712c6, 0x6b94836d, 0x6da6b948, 0, 117 }, /* #36 */
    { 0x086513, 0x086512, 0x6b94836d, 0x6db6b948, 0, 117 }, /* #36 b */
    { 0x2f6c47, 0x2f6447, 0x6d098f24, 0xe496d098, 0, 21 }, /* #37 */
    { 0x101392, 0x101393, 0x6d098f24, 0xe486d098, 0, 21 }, /* #37 b */
    { 0x327b82, 0x327382, 0x8e0a515b, 0x515b4705, 0, 16 }, /* #38 */
    { 0x0d0457, 0x0d0456, 0x8e0a515b, 0x515bc705, 0, 16 }, /* #38 b */
    { 0x0f7e87, 0x0f7686, 0xe810fcdd, 0x6efa043f, 0, 55 }, /* #39 */
    { 0x300152, 0x300152, 0xe810fcdd, 0x6eba043f, 0, 55 }, /* #39 b */
    { 0x0b4c82, 0x0b4c82, 0x608c0f5f, 0xc1181ebe, 0, 1  }, /* #40 */
    { 0x343357, 0x343b56, 0x608c0f5f, 0xc1181ebf, 0, 1  }, /* #40 b */
    { 0x0d1b17, 0x0d1317, 0x5acb79b2, 0xbcd956b2, 0, 47 }, /* #41 */
    { 0x3264c2, 0x3264c3, 0x5acb79b2, 0xbcd916b2, 0, 47 }, /* #41 b */
    { 0x1d49c6, 0x1d49c7, 0x6f16a4ab, 0x2559bc5a, 0, 51 }, /* #42 */
    { 0x223613, 0x223e13, 0x6f16a4ab, 0x255dbc5a, 0, 51 }, /* #42 b */
    { 0x036712, 0x036f12, 0x9aa60669, 0x9819a535, 0, 42 }, /* #43 */
    { 0x3c18c7, 0x3c18c6, 0x9aa60669, 0x9819a735, 0, 42 }, /* #43 b */
    { 0x072d56, 0x072557, 0xac3bbd29, 0xde94ab0e, 0, 111 }, /* #44 */
    { 0x385283, 0x385283, 0xac3bbd29, 0xde94eb0e, 0, 111 }, /* #44 b */
    { 0x2f5d56, 0x2f5d56, 0x1b762ac3, 0xc36ec558, 0, 30 }, /* #45 */
    { 0x102283, 0x102a82, 0x1b762ac3, 0xe36ec558, 0, 30 }, /* #45 b */
    { 0x384892, 0x384092, 0xa26621d0, 0x6621d051, 0, 40 }, /* #46 */
    { 0x073747, 0x073746, 0xa26621d0, 0x6621d0d1, 0, 40 }, /* #46 b */
    { 0x206912, 0x206113, 0x7d543590, 0x903eaa1a, 0, 56 }, /* #47 */
    { 0x1f16c7, 0x1f16c7, 0x7d543590, 0x90beaa1a, 0, 56 }, /* #47 b */
    { 0x0555c3, 0x055dc3, 0xfa9ef6e2, 0x7ea7bdb8, 0, 127 }, /* #48 */
    { 0x3a2a16, 0x3a2a17, 0xfa9ef6e2, 0x3ea7bdb8, 0, 127 }, /* #48 b */
    { 0x371a43, 0x371a43, 0xa6787529, 0x0ea53a67, 0, 77 }, /* #49 */
    { 0x086596, 0x086d97, 0xa6787529, 0x0ea52a67, 0, 77 }, /* #49 b */
    { 0x3224d3, 0x3224d3, 0xf88f3e37, 0xc479f1bf, 0, 99 }, /* #50 */
    { 0x0d5b06, 0x0d5307, 0xf88f3e37, 0xc479f1bb, 0, 99 }, /* #50 b */
    { 0x1c1917, 0x1c1116, 0x73464873, 0x68c90e77, 0, 37 }, /* #51 */
    { 0x2366c2, 0x2366c2, 0x73464873, 0x68c90e67, 0, 37 }, /* #51 b */
    { 0x1f79c7, 0x1f79c7, 0x308fcdf7, 0x1f9bef30, 0, 9  }, /* #52 */
    { 0x200612, 0x200e13, 0x308fcdf7, 0x1f9bee30, 0, 9  }, /* #52 b */
    { 0x281c06, 0x281406, 0x088a1404, 0x14040445, 0, 80 }, /* #53 */
    { 0x1763d3, 0x1763d2, 0x088a1404, 0x14048445, 0, 80 }, /* #53 b */
    { 0x286a87, 0x286286, 0x08294dc4, 0x420a5371, 0, 95 }, /* #54 */
    { 0x171552, 0x171552, 0x08294dc4, 0x020a5371, 0, 95 }, /* #54 b */
    { 0x160d87, 0x160d87, 0x78e521f6, 0x6bc7290f, 0, 28 }, /* #55 */
    { 0x297252, 0x297a53, 0x78e521f6, 0x63c7290f, 0, 28 }, /* #55 b */
    { 0x220f43, 0x220f42, 0x6c356729, 0xdb0d59ca, 0, 63 }, /* #56 */
    { 0x1d7096, 0x1d7896, 0x6c356729, 0x9b0d59ca, 0, 63 }, /* #56 b */
    { 0x272f92, 0x272f93, 0x4aa65199, 0x54ca3324, 0, 69 }, /* #57 */
    { 0x185047, 0x185847, 0x4aa65199, 0x54ca3334, 0, 69 }, /* #57 b */
    { 0x1c1813, 0x1c1012, 0xc238fc0e, 0x471f81dc, 0, 69 }, /* #58 */
    { 0x2367c6, 0x2367c6, 0xc238fc0e, 0x471f81cc, 0, 69 }, /* #58 b */
    { 0x3f4cd3, 0x3f4cd3, 0x5b56fd61, 0x6fd61ada, 0, 76 }, /* #59 */
    { 0x003306, 0x003b07, 0x5b56fd61, 0x6fd612da, 0, 76 }, /* #59 b */
    { 0x3b2403, 0x3b2403, 0xf3f96c8b, 0x917f3f96, 0, 85 }, /* #60 */
    { 0x045bd6, 0x0453d7, 0xf3f96c8b, 0x916f3f96, 0, 85 }, /* #60 b */
    { 0x2e5756, 0x2e5f57, 0x81fd0c04, 0x03fa1808, 0, 33 }, /* #61 */
    { 0x112883, 0x112883, 0x81fd0c04, 0x03fa1809, 0, 33 }, /* #61 b */
    { 0x0c2d16, 0x0c2517, 0x4bee82dd, 0xa4bee82d, 0, 29 }, /* #62 */
    { 0x3352c3, 0x3352c3, 0x4bee82dd, 0xb4bee82d, 0, 29 }, /* #62 b */
    { 0x2a2a02, 0x2a2a02, 0x5e584e0a, 0xb09c145e, 0, 105 }, /* #63 */
    { 0x1555d7, 0x155dd6, 0x5e584e0a, 0xb09c155e, 0, 105 }, /* #63 b */
    { 0x142c17, 0x142c16, 0x1db87aa8, 0xaa23b70f, 0, 86 }, /* #64 */
    { 0x2b53c2, 0x2b5bc2, 0x1db87aa8, 0xaa03b70f, 0, 86 }, /* #64 b */
    { 0x0e5593, 0x0e5593, 0x2855da47, 0xa47942ae, 0, 84 }, /* #65 */
    { 0x312a46, 0x312247, 0x2855da47, 0xa47142ae, 0, 84 }, /* #65 b */
    { 0x196d96, 0x196597, 0x9704d587, 0xa5c13561, 0, 95 }, /* #66 */
    { 0x261243, 0x261243, 0x9704d587, 0xe5c13561, 0, 95 }, /* #66 b */
    { 0x0e3b56, 0x0e3b56, 0x97755b93, 0xab726977, 0, 109 }, /* #67 */
    { 0x314483, 0x314c82, 0x97755b93, 0xab727977, 0, 109 }, /* #67 b */
    { 0x3271d7, 0x3279d7, 0xe3d011bf, 0x4046ffc7, 0, 74 }, /* #68 */
    { 0x0d0e02, 0x0d0e03, 0xe3d011bf, 0x4046fdc7, 0, 74 }, /* #68 b */
    { 0x310ad2, 0x3102d3, 0x423fa679, 0x9e4847f4, 0, 22 }, /* #69 */
    { 0x0e7507, 0x0e7507, 0x423fa679, 0x9e6847f4, 0, 22 }, /* #69 b */
    { 0x145a03, 0x145a02, 0x4dff5f75, 0xeb4dff5f, 0, 121 }, /* #70 */
    { 0x2b25d6, 0x2b2dd6, 0x4dff5f75, 0xea4dff5f, 0, 121 }, /* #70 b */
    { 0x1123c6, 0x112bc6, 0x0a83a8e4, 0x8e40541d, 0, 116 }, /* #71 */
    { 0x2e5c13, 0x2e5c12, 0x0a83a8e4, 0x8e48541d, 0, 116 }, /* #71 b */
    { 0x1a5206, 0x1a5206, 0xd25d04ca, 0x0994d25d, 0, 49 }, /* #72 */
    { 0x252dd3, 0x2525d2, 0xd25d04ca, 0x0995d25d, 0, 49 }, /* #72 b */
    { 0x2d2293, 0x2d2292, 0x0a56e49a, 0x4d4295b9, 0, 23 }, /* #73 */
    { 0x125d46, 0x125546, 0x0a56e49a, 0x4d0295b9, 0, 23 }, /* #73 b */
    { 0x1b6106, 0x1b6907, 0x0781169b, 0x022d3607, 0, 73 }, /* #74 */
    { 0x241ed3, 0x241ed3, 0x0781169b, 0x022d3707, 0, 73 }, /* #74 b */
    { 0x1f3557, 0x1f3556, 0x9670b974, 0x59c2e5d3, 0, 2  }, /* #75 */
    { 0x204a82, 0x204282, 0x9670b974, 0x59c2e5d1, 0, 2  }, /* #75 b */
    { 0x392186, 0x392986, 0x5563b84e, 0xee138aac, 0, 46 }, /* #76 */
    { 0x065e53, 0x065e52, 0x5563b84e, 0xee13aaac, 0, 46 }, /* #76 b */
    { 0x110e83, 0x110e83, 0xe1a2f439, 0x7a1cf868, 0, 111 }, /* #77 */
    { 0x2e7156, 0x2e7957, 0xe1a2f439, 0x7a1cb868, 0, 111 }, /* #77 b */
    { 0x0f7e17, 0x0f7e17, 0x0de927a3, 0x493d1c37, 0, 75 }, /* #78 */
    { 0x3001c2, 0x3009c3, 0x0de927a3, 0x493d1837, 0, 75 }, /* #78 b */
    { 0x3a4916, 0x3a4916, 0xe1a7c771, 0xf8ee2e1a, 0, 77 }, /* #79 */
    { 0x0536c3, 0x053ec2, 0xe1a7c771, 0xf8ee3e1a, 0, 77 }, /* #79 b */
    { 0x3045c2, 0x3045c3, 0x7cc8f21c, 0xe4387cc8, 0, 113 }, /* #80 */
    { 0x0f3a17, 0x0f3217, 0x7cc8f21c, 0xe4397cc8, 0, 113 }, /* #80 b */
    { 0x2d1e93, 0x2d1e92, 0x88f1f8b0, 0xc311e3f1, 0, 58 }, /* #81 */
    { 0x126146, 0x126946, 0x88f1f8b0, 0xc111e3f1, 0, 58 }, /* #81 b */
    { 0x1b52c2, 0x1b5ac3, 0x25203426, 0x20342612, 0, 40 }, /* #82 */
    { 0x242d17, 0x242d17, 0x25203426, 0x20342692, 0, 40 }, /* #82 b */
    { 0x327a93, 0x327a93, 0xeee8ffec, 0x7747ff67, 0, 3  }, /* #83 */
    { 0x0d0546, 0x0d0d47, 0xeee8ffec, 0x7747ff63, 0, 3  }, /* #83 b */
    { 0x080847, 0x080846, 0xa4998f73, 0xf49331ee, 0, 30 }, /* #84 */
    { 0x377792, 0x377f92, 0xa4998f73, 0xd49331ee, 0, 30 }, /* #84 b */
    { 0x2d2a42, 0x2d2a43, 0x69c46375, 0x4d388c6e, 0, 30 }, /* #85 */
    { 0x125597, 0x125d97, 0x69c46375, 0x6d388c6e, 0, 30 }, /* #85 b */
    { 0x187a56, 0x187a57, 0x931d6405, 0x6405498e, 0, 16 }, /* #86 */
    { 0x270583, 0x270d83, 0x931d6405, 0x6405c98e, 0, 16 }, /* #86 b */
    { 0x057506, 0x057506, 0x61219d15, 0x1219d153, 0, 4  }, /* #87 */
    { 0x3a0ad3, 0x3a02d2, 0x61219d15, 0x1219d15b, 0, 4  }, /* #87 b */
    { 0x106756, 0x106f56, 0x5e6fd9d5, 0xf37ecea9, 0, 99 }, /* #88 */
    { 0x2f1883, 0x2f1882, 0x5e6fd9d5, 0xf37ecead, 0, 99 }, /* #88 b */
    { 0x205d16, 0x205d17, 0xd1c9285d, 0x24a175a3, 0, 74 }, /* #89 */
    { 0x1f22c3, 0x1f2ac3, 0xd1c9285d, 0x24a177a3, 0, 74 }, /* #89 b */
    { 0x187b12, 0x187b12, 0xc28d16b7, 0x8b5bb0a3, 0, 47 }, /* #90 */
    { 0x2704c7, 0x270cc6, 0xc28d16b7, 0x8b5bf0a3, 0, 47 }, /* #90 b */
    { 0x074006, 0x074807, 0x1399af50, 0x5ea01399, 0, 17 }, /* #91 */
    { 0x383fd3, 0x383fd3, 0x1399af50, 0x5ea11399, 0, 17 }, /* #91 b */
    { 0x054b82, 0x054b83, 0xf06a94e9, 0x4e978354, 0, 84 }, /* #92 */
    { 0x3a3457, 0x3a3c57, 0xf06a94e9, 0x4e9f8354, 0, 84 }, /* #92 b */
    { 0x375452, 0x375453, 0x59692104, 0x96921042, 0, 36 }, /* #93 */
    { 0x082b87, 0x082387, 0x59692104, 0x9692104a, 0, 36 }, /* #93 b */
    { 0x222853, 0x222852, 0xd95afbc4, 0xfbc4ecad, 0, 48 }, /* #94 */
    { 0x1d5786, 0x1d5f86, 0xd95afbc4, 0xfbc46cad, 0, 48 }, /* #94 b */
    { 0x0a5816, 0x0a5817, 0xdbe78eb5, 0x6f9e3ad5, 0, 98 }, /* #95 */
    { 0x3527c3, 0x352fc3, 0xdbe78eb5, 0x6f9e3ad7, 0, 98 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u32_amd = RT_ELEMENTS(g_aTests_rcl_u32_amd);

BINU32_TEST_T const g_aTests_rcr_u32_amd[] =
{
    { 0x0c0017, 0x0c0016, 0x00000000, 0x00008000, 0, 49 }, /* #0 */
    { 0x337fc2, 0x3377c2, 0x00000000, 0x00000000, 0, 49 }, /* #0 b */
    { 0x334a52, 0x334a52, 0x00000000, 0x00000000, 0, 96 }, /* #1 */
    { 0x0c3587, 0x0c3587, 0x00000000, 0x00000000, 0, 96 }, /* #1 b */
    { 0x074506, 0x074506, 0x00000000, 0x00000000, 0, 24 }, /* #2 */
    { 0x383ad3, 0x3832d2, 0x00000000, 0x00000100, 0, 24 }, /* #2 b */
    { 0x1e76c2, 0x1e76c2, 0x00000000, 0x00000000, 0, 39 }, /* #3 */
    { 0x210917, 0x210116, 0x00000000, 0x02000000, 0, 39 }, /* #3 b */
    { 0x294896, 0x294096, 0x00000000, 0x00000000, 0, 42 }, /* #4 */
    { 0x163743, 0x163742, 0x00000000, 0x00400000, 0, 42 }, /* #4 b */
    { 0x3f4907, 0x3f4106, 0x00000000, 0x00004000, 0, 114 }, /* #5 */
    { 0x0036d2, 0x0036d2, 0x00000000, 0x00000000, 0, 114 }, /* #5 b */
    { 0x134a87, 0x134a87, 0x9e97948f, 0x48fcf4bc, 0, 77 }, /* #6 */
    { 0x2c3552, 0x2c3d53, 0x9e97948f, 0x48f4f4bc, 0, 77 }, /* #6 b */
    { 0x160406, 0x160c07, 0x1fff6d15, 0x68a87ffd, 0, 46 }, /* #7 */
    { 0x297bd3, 0x297bd3, 0x1fff6d15, 0x68ac7ffd, 0, 46 }, /* #7 b */
    { 0x3e0f02, 0x3e0f03, 0xe98ae11a, 0x4e98ae11, 0, 68 }, /* #8 */
    { 0x0170d7, 0x0178d7, 0xe98ae11a, 0x5e98ae11, 0, 68 }, /* #8 b */
    { 0x3030c6, 0x3030c7, 0x0ef00c84, 0xe019080e, 0, 24 }, /* #9 */
    { 0x0f4f13, 0x0f4713, 0x0ef00c84, 0xe019090e, 0, 24 }, /* #9 b */
    { 0x0b4f82, 0x0b4f82, 0x5fe49b11, 0x897f926c, 0, 70 }, /* #10 */
    { 0x343057, 0x343856, 0x5fe49b11, 0x8d7f926c, 0, 70 }, /* #10 b */
    { 0x2a6696, 0x2a6e97, 0x6292ec09, 0x60498a4b, 0, 110 }, /* #11 */
    { 0x151943, 0x151943, 0x6292ec09, 0x604d8a4b, 0, 110 }, /* #11 b */
    { 0x071703, 0x071702, 0xaa0ac3d2, 0x1e96a82b, 0, 14 }, /* #12 */
    { 0x3868d6, 0x3860d6, 0xaa0ac3d2, 0x1e92a82b, 0, 14 }, /* #12 b */
    { 0x132287, 0x132286, 0x39937c09, 0x267326f8, 0, 103 }, /* #13 */
    { 0x2c5d52, 0x2c5552, 0x39937c09, 0x247326f8, 0, 103 }, /* #13 b */
    { 0x0a1b12, 0x0a1b13, 0xdb4a6b43, 0x4d686db4, 0, 52 }, /* #14 */
    { 0x3564c7, 0x356cc7, 0xdb4a6b43, 0x4d687db4, 0, 52 }, /* #14 b */
    { 0x352257, 0x352a56, 0x88200f6c, 0x41007b66, 0, 30 }, /* #15 */
    { 0x0a5d82, 0x0a5d82, 0x88200f6c, 0x41007b62, 0, 30 }, /* #15 b */
    { 0x0617d3, 0x061fd2, 0xf9e156eb, 0xadd7f9e1, 0, 80 }, /* #16 */
    { 0x396806, 0x396806, 0xf9e156eb, 0xadd6f9e1, 0, 80 }, /* #16 b */
    { 0x0e38d7, 0x0e38d7, 0x147d7723, 0x91c51f5d, 0, 42 }, /* #17 */
    { 0x314702, 0x314f03, 0x147d7723, 0x91851f5d, 0, 42 }, /* #17 b */
    { 0x3a2d82, 0x3a2582, 0xf441d77d, 0xefaf441d, 0, 44 }, /* #18 */
    { 0x055257, 0x055256, 0xf441d77d, 0xefbf441d, 0, 44 }, /* #18 b */
    { 0x167d13, 0x167512, 0x0acad9b3, 0xcd9c2b2b, 0, 78 }, /* #19 */
    { 0x2902c6, 0x2902c6, 0x0acad9b3, 0xcd982b2b, 0, 78 }, /* #19 b */
    { 0x166ad7, 0x166ad7, 0x77536c97, 0xbba9b64b, 0, 97 }, /* #20 */
    { 0x291502, 0x291503, 0x77536c97, 0x3ba9b64b, 0, 97 }, /* #20 b */
    { 0x247687, 0x247e87, 0x5c6b756b, 0x6ead75c6, 0, 52 }, /* #21 */
    { 0x1b0952, 0x1b0953, 0x5c6b756b, 0x6ead65c6, 0, 52 }, /* #21 b */
    { 0x1d6497, 0x1d6c97, 0x9f4ca232, 0x4ca232cf, 0, 89 }, /* #22 */
    { 0x221b42, 0x221b43, 0x9f4ca232, 0x4ca2324f, 0, 89 }, /* #22 b */
    { 0x2f4e42, 0x2f4643, 0xe73c791e, 0xe739e3c8, 0, 5  }, /* #23 */
    { 0x103197, 0x103197, 0xe73c791e, 0xef39e3c8, 0, 5  }, /* #23 b */
    { 0x072906, 0x072906, 0x86165122, 0x86165122, 0, 32 }, /* #24 */
    { 0x3856d3, 0x3856d3, 0x86165122, 0x86165122, 0, 32 }, /* #24 b */
    { 0x082c96, 0x082c97, 0x9bb0ed38, 0xb4e13761, 0, 15 }, /* #25 */
    { 0x375343, 0x375b43, 0x9bb0ed38, 0xb4e33761, 0, 15 }, /* #25 b */
    { 0x2d1546, 0x2d1d46, 0x70aaf926, 0xbe498e15, 0, 19 }, /* #26 */
    { 0x126a93, 0x126a92, 0x70aaf926, 0xbe49ae15, 0, 19 }, /* #26 b */
    { 0x3d1987, 0x3d1187, 0x4f9ea0a8, 0xcf505453, 0, 26 }, /* #27 */
    { 0x026652, 0x026653, 0x4f9ea0a8, 0xcf505413, 0, 26 }, /* #27 b */
    { 0x394682, 0x394683, 0x354c70c7, 0x1c6a98e1, 0, 39 }, /* #28 */
    { 0x063957, 0x063157, 0x354c70c7, 0x1e6a98e1, 0, 39 }, /* #28 b */
    { 0x2003c7, 0x2003c7, 0x30181c86, 0x0d30181c, 0, 104 }, /* #29 */
    { 0x1f7c12, 0x1f7413, 0x30181c86, 0x0c30181c, 0, 104 }, /* #29 b */
    { 0x2b5586, 0x2b5586, 0x7f726fa8, 0x1fdc9bea, 0, 34 }, /* #30 */
    { 0x142a53, 0x142a52, 0x7f726fa8, 0x5fdc9bea, 0, 34 }, /* #30 b */
    { 0x0f2b87, 0x0f2387, 0xac0e646f, 0xd6073237, 0, 1  }, /* #31 */
    { 0x305452, 0x305c53, 0xac0e646f, 0x56073237, 0, 1  }, /* #31 b */
    { 0x233b46, 0x233346, 0x9050b97c, 0x24142e5f, 0, 66 }, /* #32 */
    { 0x1c4493, 0x1c4c92, 0x9050b97c, 0x64142e5f, 0, 66 }, /* #32 b */
    { 0x121b46, 0x121346, 0x75047eaa, 0x11faa8ea, 0, 23 }, /* #33 */
    { 0x2d6493, 0x2d6492, 0x75047eaa, 0x11faaaea, 0, 23 }, /* #33 b */
    { 0x030dc6, 0x030dc6, 0xe97f091e, 0x48f3a5fc, 0, 46 }, /* #34 */
    { 0x3c7213, 0x3c7a12, 0xe97f091e, 0x48f7a5fc, 0, 46 }, /* #34 b */
    { 0x1c5353, 0x1c5353, 0x1af78b59, 0xde2d6635, 0, 55 }, /* #35 */
    { 0x232c86, 0x232487, 0x1af78b59, 0xde2d6435, 0, 55 }, /* #35 b */
    { 0x3909d6, 0x3901d6, 0x2ed01bb4, 0xdda0bb40, 0, 110 }, /* #36 */
    { 0x067603, 0x067602, 0x2ed01bb4, 0xdda4bb40, 0, 110 }, /* #36 b */
    { 0x113947, 0x113946, 0xf20fad19, 0x67e41f5a, 0, 103 }, /* #37 */
    { 0x2e4692, 0x2e4e92, 0xf20fad19, 0x65e41f5a, 0, 103 }, /* #37 b */
    { 0x247456, 0x247456, 0x73ad018b, 0x0c59ceb4, 0, 46 }, /* #38 */
    { 0x1b0b83, 0x1b0382, 0x73ad018b, 0x0c5dceb4, 0, 46 }, /* #38 b */
    { 0x360f16, 0x360716, 0x6c189b1b, 0xd8d9b062, 0, 14 }, /* #39 */
    { 0x0970c3, 0x0970c2, 0x6c189b1b, 0xd8ddb062, 0, 14 }, /* #39 b */
    { 0x182092, 0x182893, 0xfb0c2f5d, 0x75f6185e, 0, 71 }, /* #40 */
    { 0x275f47, 0x275f47, 0xfb0c2f5d, 0x77f6185e, 0, 71 }, /* #40 b */
    { 0x211f83, 0x211783, 0x959b56f0, 0x0cacdab7, 0, 37 }, /* #41 */
    { 0x1e6056, 0x1e6057, 0x959b56f0, 0x04acdab7, 0, 37 }, /* #41 b */
    { 0x264c56, 0x264457, 0x64f973e7, 0x3e5cf9cc, 0, 123 }, /* #42 */
    { 0x193383, 0x193383, 0x64f973e7, 0x3e5cf9ec, 0, 123 }, /* #42 b */
    { 0x3a2082, 0x3a2882, 0xb7bf6eba, 0x5bdfb75d, 0, 65 }, /* #43 */
    { 0x055f57, 0x055756, 0xb7bf6eba, 0xdbdfb75d, 0, 65 }, /* #43 b */
    { 0x093a02, 0x093a03, 0x211b3c1a, 0x4211b3c1, 0, 68 }, /* #44 */
    { 0x3645d7, 0x364dd7, 0x211b3c1a, 0x5211b3c1, 0, 68 }, /* #44 b */
    { 0x036617, 0x036617, 0xc434c53d, 0xef10d314, 0, 70 }, /* #45 */
    { 0x3c19c2, 0x3c11c3, 0xc434c53d, 0xeb10d314, 0, 70 }, /* #45 b */
    { 0x144096, 0x144096, 0x5764a02f, 0xec9405e5, 0, 124 }, /* #46 */
    { 0x2b3f43, 0x2b3742, 0x5764a02f, 0xec9405f5, 0, 124 }, /* #46 b */
    { 0x0e4a96, 0x0e4a97, 0xd38d3bdb, 0x6d38d3bd, 0, 100 }, /* #47 */
    { 0x313543, 0x313d43, 0xd38d3bdb, 0x7d38d3bd, 0, 100 }, /* #47 b */
    { 0x2957c7, 0x295fc7, 0x6f41dbd9, 0xbd076f66, 0, 31 }, /* #48 */
    { 0x162812, 0x162813, 0x6f41dbd9, 0xbd076f64, 0, 31 }, /* #48 b */
    { 0x171213, 0x171a12, 0xaab93239, 0x473aab93, 0, 108 }, /* #49 */
    { 0x286dc6, 0x286dc6, 0xaab93239, 0x472aab93, 0, 108 }, /* #49 b */
    { 0x287697, 0x287697, 0xfc1ce8df, 0xfe0e746f, 0, 33 }, /* #50 */
    { 0x170942, 0x170943, 0xfc1ce8df, 0x7e0e746f, 0, 33 }, /* #50 b */
    { 0x371687, 0x371687, 0x9628009d, 0x3b962800, 0, 72 }, /* #51 */
    { 0x086952, 0x086153, 0x9628009d, 0x3a962800, 0, 72 }, /* #51 b */
    { 0x343ad7, 0x3432d7, 0x894acca7, 0xc4a56653, 0, 33 }, /* #52 */
    { 0x0b4502, 0x0b4d03, 0x894acca7, 0x44a56653, 0, 33 }, /* #52 b */
    { 0x0e1c83, 0x0e1483, 0x943370c9, 0x0cdc3272, 0, 123 }, /* #53 */
    { 0x316356, 0x316357, 0x943370c9, 0x0cdc3252, 0, 123 }, /* #53 b */
    { 0x287482, 0x287483, 0x7e5437ca, 0xf2a1be51, 0, 62 }, /* #54 */
    { 0x170b57, 0x170357, 0x7e5437ca, 0xf2a1be55, 0, 62 }, /* #54 b */
    { 0x3b2186, 0x3b2186, 0x7b5d9ca4, 0xe521ed76, 0, 110 }, /* #55 */
    { 0x045e53, 0x045652, 0x7b5d9ca4, 0xe525ed76, 0, 110 }, /* #55 b */
    { 0x042dd2, 0x0425d3, 0xddaf5c7f, 0xfb76bd71, 0, 102 }, /* #56 */
    { 0x3b5207, 0x3b5207, 0xddaf5c7f, 0xff76bd71, 0, 102 }, /* #56 b */
    { 0x071153, 0x071152, 0x015db03f, 0x0576c0fe, 0, 31 }, /* #57 */
    { 0x386e86, 0x386686, 0x015db03f, 0x0576c0fc, 0, 31 }, /* #57 b */
    { 0x244e13, 0x244e13, 0xe941c9cd, 0xbe941c9c, 0, 100 }, /* #58 */
    { 0x1b31c6, 0x1b39c7, 0xe941c9cd, 0xae941c9c, 0, 100 }, /* #58 b */
    { 0x323213, 0x323213, 0x6d1155e3, 0x1db44557, 0, 6  }, /* #59 */
    { 0x0d4dc6, 0x0d45c7, 0x6d1155e3, 0x19b44557, 0, 6  }, /* #59 b */
    { 0x217e86, 0x217686, 0xce63db0a, 0x299cc7b6, 0, 103 }, /* #60 */
    { 0x1e0153, 0x1e0152, 0xce63db0a, 0x2b9cc7b6, 0, 103 }, /* #60 b */
    { 0x220957, 0x220956, 0xe8d4edf3, 0xa76f9fa3, 0, 118 }, /* #61 */
    { 0x1d7682, 0x1d7e82, 0xe8d4edf3, 0xa76f9ba3, 0, 118 }, /* #61 b */
    { 0x1e0446, 0x1e0c46, 0x43ec4101, 0x8090fb10, 0, 42 }, /* #62 */
    { 0x217b93, 0x217b92, 0x43ec4101, 0x80d0fb10, 0, 42 }, /* #62 b */
    { 0x3d04d6, 0x3d0cd7, 0xa99d97aa, 0x97aa54ce, 0, 17 }, /* #63 */
    { 0x027b03, 0x027b03, 0xa99d97aa, 0x97aad4ce, 0, 17 }, /* #63 b */
    { 0x384213, 0x384a12, 0xa2cf86c7, 0x8b3e1b1f, 0, 127 }, /* #64 */
    { 0x073dc6, 0x073dc6, 0xa2cf86c7, 0x8b3e1b1d, 0, 127 }, /* #64 b */
    { 0x004887, 0x004086, 0x336161e5, 0xc3cb3361, 0, 16 }, /* #65 */
    { 0x3f3752, 0x3f3752, 0x336161e5, 0xc3ca3361, 0, 16 }, /* #65 b */
    { 0x3652c2, 0x3652c3, 0x2d337191, 0x33719116, 0, 25 }, /* #66 */
    { 0x092d17, 0x092517, 0x2d337191, 0x33719196, 0, 25 }, /* #66 b */
    { 0x3b75d6, 0x3b7dd6, 0x8212f819, 0x4be06504, 0, 55 }, /* #67 */
    { 0x040a03, 0x040a02, 0x8212f819, 0x4be06704, 0, 55 }, /* #67 b */
    { 0x354d07, 0x354507, 0xcf5e678a, 0xd799e2b9, 0, 59 }, /* #68 */
    { 0x0a32d2, 0x0a32d3, 0xcf5e678a, 0xd799e299, 0, 59 }, /* #68 b */
    { 0x216016, 0x216816, 0x34352dc7, 0x6a5b8e34, 0, 24 }, /* #69 */
    { 0x1e1fc3, 0x1e1fc2, 0x34352dc7, 0x6a5b8f34, 0, 24 }, /* #69 b */
    { 0x273502, 0x273502, 0xbc894e8b, 0xe8b5e44a, 0, 13 }, /* #70 */
    { 0x184ad7, 0x1842d6, 0xbc894e8b, 0xe8bde44a, 0, 13 }, /* #70 b */
    { 0x220796, 0x220f96, 0x349fa735, 0xa349fa73, 0, 100 }, /* #71 */
    { 0x1d7843, 0x1d7842, 0x349fa735, 0xb349fa73, 0, 100 }, /* #71 b */
    { 0x131043, 0x131843, 0xdeae6f12, 0x78977ab9, 0, 78 }, /* #72 */
    { 0x2c6f96, 0x2c6f97, 0xdeae6f12, 0x78937ab9, 0, 78 }, /* #72 b */
    { 0x206907, 0x206107, 0xa1e4eecd, 0xdd9ba1e4, 0, 112 }, /* #73 */
    { 0x1f16d2, 0x1f16d3, 0xa1e4eecd, 0xdd9aa1e4, 0, 112 }, /* #73 b */
    { 0x1d3682, 0x1d3e83, 0x6a03545e, 0x501aa2f1, 0, 94 }, /* #74 */
    { 0x224957, 0x224957, 0x6a03545e, 0x501aa2f5, 0, 94 }, /* #74 b */
    { 0x1a73d3, 0x1a7bd2, 0x523b2e5a, 0xb96aa476, 0, 15 }, /* #75 */
    { 0x250c06, 0x250c06, 0x523b2e5a, 0xb968a476, 0, 15 }, /* #75 b */
    { 0x186fd3, 0x1867d3, 0xe76b4e48, 0x3923ced6, 0, 47 }, /* #76 */
    { 0x271006, 0x271007, 0xe76b4e48, 0x3921ced6, 0, 47 }, /* #76 b */
    { 0x206516, 0x206d16, 0x95cec663, 0x695cec66, 0, 68 }, /* #77 */
    { 0x1f1ac3, 0x1f1ac2, 0x95cec663, 0x795cec66, 0, 68 }, /* #77 b */
    { 0x3b0997, 0x3b0997, 0xead00dc7, 0x6806e3fa, 0, 26 }, /* #78 */
    { 0x047642, 0x047e43, 0xead00dc7, 0x6806e3ba, 0, 26 }, /* #78 b */
    { 0x225516, 0x225516, 0x5d93b1b5, 0xec9d8da9, 0, 62 }, /* #79 */
    { 0x1d2ac3, 0x1d22c2, 0x5d93b1b5, 0xec9d8dad, 0, 62 }, /* #79 b */
    { 0x3f4407, 0x3f4407, 0xcc5374cd, 0xcc5374cd, 0, 96 }, /* #80 */
    { 0x003bd2, 0x003bd2, 0xcc5374cd, 0xcc5374cd, 0, 96 }, /* #80 b */
    { 0x2f1443, 0x2f1c43, 0x1d6edbc1, 0xb6f063ad, 0, 83 }, /* #81 */
    { 0x106b96, 0x106b97, 0x1d6edbc1, 0xb6f043ad, 0, 83 }, /* #81 b */
    { 0x065686, 0x065e86, 0xec2e2a13, 0x6ec2e2a1, 0, 36 }, /* #82 */
    { 0x392953, 0x392952, 0xec2e2a13, 0x7ec2e2a1, 0, 36 }, /* #82 b */
    { 0x394997, 0x394197, 0x2898b9be, 0xd2898b9b, 0, 68 }, /* #83 */
    { 0x063642, 0x063643, 0x2898b9be, 0xc2898b9b, 0, 68 }, /* #83 b */
    { 0x067117, 0x067117, 0x6bbfe688, 0x116bbfe6, 0, 40 }, /* #84 */
    { 0x390ec2, 0x3906c3, 0x6bbfe688, 0x106bbfe6, 0, 40 }, /* #84 b */
    { 0x140bd3, 0x1403d2, 0xf0d47d9d, 0xcefc351f, 0, 74 }, /* #85 */
    { 0x2b7406, 0x2b7406, 0xf0d47d9d, 0xcebc351f, 0, 74 }, /* #85 b */
    { 0x153997, 0x153997, 0x29003c73, 0x29003c73, 0, 96 }, /* #86 */
    { 0x2a4642, 0x2a4642, 0x29003c73, 0x29003c73, 0, 96 }, /* #86 b */
    { 0x1c3a92, 0x1c3292, 0x4f5c5af2, 0x2d7913d7, 0, 18 }, /* #87 */
    { 0x234547, 0x234546, 0x4f5c5af2, 0x2d7953d7, 0, 18 }, /* #87 b */
    { 0x085003, 0x085803, 0x5158d48c, 0x48ca8ac6, 0, 13 }, /* #88 */
    { 0x372fd6, 0x372fd7, 0x5158d48c, 0x48c28ac6, 0, 13 }, /* #88 b */
    { 0x031056, 0x031857, 0x50a594ee, 0x429653b8, 0, 31 }, /* #89 */
    { 0x3c6f83, 0x3c6f83, 0x50a594ee, 0x429653ba, 0, 31 }, /* #89 b */
    { 0x2e4c83, 0x2e4c83, 0x5b68b056, 0x6d160ad5, 0, 124 }, /* #90 */
    { 0x113356, 0x113b57, 0x5b68b056, 0x6d160ac5, 0, 124 }, /* #90 b */
    { 0x2b1017, 0x2b1816, 0x24c2f042, 0x985e0852, 0, 60 }, /* #91 */
    { 0x146fc2, 0x146fc2, 0x24c2f042, 0x985e0842, 0, 60 }, /* #91 b */
    { 0x202452, 0x202c52, 0xedfacae8, 0xae876fd6, 0, 109 }, /* #92 */
    { 0x1f5b87, 0x1f5b86, 0xedfacae8, 0xae8f6fd6, 0, 109 }, /* #92 b */
    { 0x0d6216, 0x0d6a17, 0x287ff17b, 0x8a1ffc5e, 0, 2  }, /* #93 */
    { 0x321dc3, 0x3215c3, 0x287ff17b, 0xca1ffc5e, 0, 2  }, /* #93 b */
    { 0x0d7982, 0x0d7983, 0xa83967fb, 0x41cb3fda, 0, 94 }, /* #94 */
    { 0x320657, 0x320e57, 0xa83967fb, 0x41cb3fde, 0, 94 }, /* #94 b */
    { 0x3640c2, 0x3648c3, 0xfd578e23, 0x88dfaaf1, 0, 75 }, /* #95 */
    { 0x093f17, 0x093f17, 0xfd578e23, 0x88ffaaf1, 0, 75 }, /* #95 b */
};
uint32_t const g_cTests_rcr_u32_amd = RT_ELEMENTS(g_aTests_rcr_u32_amd);

BINU32_TEST_T const g_aTests_shl_u32_amd[] =
{
    { 0x345952, 0x345156, 0x00000000, 0x00000000, 0, 72 }, /* #0 */
    { 0x0b2687, 0x0b2656, 0x00000000, 0x00000000, 0, 72 }, /* #0 b */
    { 0x2865c3, 0x286556, 0x00000000, 0x00000000, 0, 62 }, /* #1 */
    { 0x171a16, 0x171256, 0x00000000, 0x00000000, 0, 62 }, /* #1 b */
    { 0x314943, 0x314156, 0x00000000, 0x00000000, 0, 17 }, /* #2 */
    { 0x0e3696, 0x0e3656, 0x00000000, 0x00000000, 0, 17 }, /* #2 b */
    { 0x115882, 0x115056, 0x00000000, 0x00000000, 0, 105 }, /* #3 */
    { 0x2e2757, 0x2e2756, 0x00000000, 0x00000000, 0, 105 }, /* #3 b */
    { 0x290556, 0x290556, 0x00000000, 0x00000000, 0, 36 }, /* #4 */
    { 0x167a83, 0x167256, 0x00000000, 0x00000000, 0, 36 }, /* #4 b */
    { 0x104d52, 0x104556, 0x00000000, 0x00000000, 0, 23 }, /* #5 */
    { 0x2f3287, 0x2f3256, 0x00000000, 0x00000000, 0, 23 }, /* #5 b */
    { 0x196802, 0x196817, 0x6e571dd2, 0x74800000, 0, 22 }, /* #6 */
    { 0x2617d7, 0x261f17, 0x6e571dd2, 0x74800000, 0, 22 }, /* #6 b */
    { 0x1436c3, 0x143e17, 0xf45f0aec, 0x45f0aec0, 0, 36 }, /* #7 */
    { 0x2b4916, 0x2b4917, 0xf45f0aec, 0x45f0aec0, 0, 36 }, /* #7 b */
    { 0x096606, 0x096656, 0x66891744, 0x00000000, 0, 31 }, /* #8 */
    { 0x3619d3, 0x361156, 0x66891744, 0x00000000, 0, 31 }, /* #8 b */
    { 0x3d70d6, 0x3d7817, 0x04908620, 0x10000000, 0, 55 }, /* #9 */
    { 0x020f03, 0x020f17, 0x04908620, 0x10000000, 0, 55 }, /* #9 b */
    { 0x0b3896, 0x0b3817, 0xdcf22281, 0x14080000, 0, 83 }, /* #10 */
    { 0x344743, 0x344f17, 0xdcf22281, 0x14080000, 0, 83 }, /* #10 b */
    { 0x130957, 0x130112, 0x88dfe4ea, 0x37f93a80, 0, 6  }, /* #11 */
    { 0x2c7682, 0x2c7612, 0x88dfe4ea, 0x37f93a80, 0, 6  }, /* #11 b */
    { 0x1578c2, 0x1578c2, 0x72550da4, 0x72550da4, 0, 32 }, /* #12 */
    { 0x2a0717, 0x2a0717, 0x72550da4, 0x72550da4, 0, 32 }, /* #12 b */
    { 0x0a7bd3, 0x0a7316, 0x25e29a3d, 0x7a000000, 0, 57 }, /* #13 */
    { 0x350406, 0x350416, 0x25e29a3d, 0x7a000000, 0, 57 }, /* #13 b */
    { 0x3e4102, 0x3e4116, 0x1af10a84, 0x21508000, 0, 109 }, /* #14 */
    { 0x013ed7, 0x013616, 0x1af10a84, 0x21508000, 0, 109 }, /* #14 b */
    { 0x3006d2, 0x300e96, 0xa21a0ac5, 0xac500000, 0, 84 }, /* #15 */
    { 0x0f7907, 0x0f7996, 0xa21a0ac5, 0xac500000, 0, 84 }, /* #15 b */
    { 0x0a3786, 0x0a3797, 0x8442cac6, 0x8c000000, 0, 89 }, /* #16 */
    { 0x354853, 0x354097, 0x8442cac6, 0x8c000000, 0, 89 }, /* #16 b */
    { 0x253b42, 0x253b17, 0xf39d1f29, 0x29000000, 0, 56 }, /* #17 */
    { 0x1a4497, 0x1a4c17, 0xf39d1f29, 0x29000000, 0, 56 }, /* #17 b */
    { 0x0925d2, 0x092d17, 0x9e6ddd75, 0x775d4000, 0, 110 }, /* #18 */
    { 0x365a07, 0x365a17, 0x9e6ddd75, 0x775d4000, 0, 110 }, /* #18 b */
    { 0x282686, 0x282e57, 0x618c646e, 0x00000000, 0, 63 }, /* #19 */
    { 0x175953, 0x175957, 0x618c646e, 0x00000000, 0, 63 }, /* #19 b */
    { 0x124f02, 0x124f96, 0x70413959, 0x9cac8000, 0, 79 }, /* #20 */
    { 0x2d30d7, 0x2d3896, 0x70413959, 0x9cac8000, 0, 79 }, /* #20 b */
    { 0x241112, 0x241112, 0xfce691dd, 0x7348ee80, 0, 103 }, /* #21 */
    { 0x1b6ec7, 0x1b6612, 0xfce691dd, 0x7348ee80, 0, 103 }, /* #21 b */
    { 0x1c22c7, 0x1c2216, 0x1c71719c, 0x5c670000, 0, 46 }, /* #22 */
    { 0x235d12, 0x235516, 0x1c71719c, 0x5c670000, 0, 46 }, /* #22 b */
    { 0x1a3242, 0x1a3216, 0xd0dbd977, 0x36f65dc0, 0, 70 }, /* #23 */
    { 0x254d97, 0x254516, 0xd0dbd977, 0x36f65dc0, 0, 70 }, /* #23 b */
    { 0x2e6182, 0x2e6116, 0xa1455e0d, 0x2af06800, 0, 11 }, /* #24 */
    { 0x111e57, 0x111616, 0xa1455e0d, 0x2af06800, 0, 11 }, /* #24 b */
    { 0x1a5743, 0x1a5743, 0x036c39a9, 0x036c39a9, 0, 0  }, /* #25 */
    { 0x252896, 0x252896, 0x036c39a9, 0x036c39a9, 0, 0  }, /* #25 b */
    { 0x2b53d2, 0x2b5316, 0x77df80d9, 0x6c800000, 0, 55 }, /* #26 */
    { 0x142c07, 0x142416, 0x77df80d9, 0x6c800000, 0, 55 }, /* #26 b */
    { 0x1869c2, 0x186917, 0x01c29d58, 0x4eac0000, 0, 79 }, /* #27 */
    { 0x271617, 0x271e17, 0x01c29d58, 0x4eac0000, 0, 79 }, /* #27 b */
    { 0x275593, 0x275516, 0x3aeafc37, 0x6e000000, 0, 25 }, /* #28 */
    { 0x182a46, 0x182216, 0x3aeafc37, 0x6e000000, 0, 25 }, /* #28 b */
    { 0x156147, 0x156917, 0x2a7a874c, 0x0e980000, 0, 49 }, /* #29 */
    { 0x2a1e92, 0x2a1e17, 0x2a7a874c, 0x0e980000, 0, 49 }, /* #29 b */
    { 0x0a1d57, 0x0a1d96, 0x9c8c6fdc, 0x8c6fdc00, 0, 40 }, /* #30 */
    { 0x356282, 0x356a96, 0x9c8c6fdc, 0x8c6fdc00, 0, 40 }, /* #30 b */
    { 0x367c07, 0x367c96, 0x9a08ecb6, 0xcb600000, 0, 20 }, /* #31 */
    { 0x0903d2, 0x090b96, 0x9a08ecb6, 0xcb600000, 0, 20 }, /* #31 b */
    { 0x1843d7, 0x184b96, 0x9a60fbb9, 0xee400000, 0, 54 }, /* #32 */
    { 0x273c02, 0x273c96, 0x9a60fbb9, 0xee400000, 0, 54 }, /* #32 b */
    { 0x3328c2, 0x332097, 0xaa8342e2, 0xa1710000, 0, 15 }, /* #33 */
    { 0x0c5717, 0x0c5797, 0xaa8342e2, 0xa1710000, 0, 15 }, /* #33 b */
    { 0x275796, 0x275f57, 0x5a3cd33a, 0x00000000, 0, 63 }, /* #34 */
    { 0x182843, 0x182857, 0x5a3cd33a, 0x00000000, 0, 63 }, /* #34 b */
    { 0x1f1f46, 0x1f1716, 0xcd4691d0, 0x47400000, 0, 82 }, /* #35 */
    { 0x206093, 0x206016, 0xcd4691d0, 0x47400000, 0, 82 }, /* #35 b */
    { 0x020c93, 0x020c96, 0xa0dd29ea, 0x9ea00000, 0, 84 }, /* #36 */
    { 0x3d7346, 0x3d7b96, 0xa0dd29ea, 0x9ea00000, 0, 84 }, /* #36 b */
    { 0x0d3cc6, 0x0d3497, 0xb3189dc9, 0xdc900000, 0, 84 }, /* #37 */
    { 0x324313, 0x324397, 0xb3189dc9, 0xdc900000, 0, 84 }, /* #37 b */
    { 0x2a2c83, 0x2a2c17, 0xeb2b93e9, 0x595c9f48, 0, 35 }, /* #38 */
    { 0x155356, 0x155b17, 0xeb2b93e9, 0x595c9f48, 0, 35 }, /* #38 b */
    { 0x3c3b92, 0x3c3316, 0x5b7e8e09, 0x12000000, 0, 121 }, /* #39 */
    { 0x034447, 0x034416, 0x5b7e8e09, 0x12000000, 0, 121 }, /* #39 b */
    { 0x351652, 0x351e13, 0x92e9d037, 0x74e81b80, 0, 103 }, /* #40 */
    { 0x0a6987, 0x0a6913, 0x92e9d037, 0x74e81b80, 0, 103 }, /* #40 b */
    { 0x2b78c6, 0x2b78c6, 0x560dc907, 0x560dc907, 0, 96 }, /* #41 */
    { 0x140713, 0x140713, 0x560dc907, 0x560dc907, 0, 96 }, /* #41 b */
    { 0x0677c3, 0x067f57, 0x05bfbfd4, 0x00000000, 0, 62 }, /* #42 */
    { 0x390816, 0x390857, 0x05bfbfd4, 0x00000000, 0, 62 }, /* #42 b */
    { 0x3335c2, 0x333d13, 0x59501a7a, 0x2a034f40, 0, 101 }, /* #43 */
    { 0x0c4a17, 0x0c4a13, 0x59501a7a, 0x2a034f40, 0, 101 }, /* #43 b */
    { 0x240f16, 0x240f96, 0xf762a666, 0xec54ccc0, 0, 69 }, /* #44 */
    { 0x1b70c3, 0x1b7896, 0xf762a666, 0xec54ccc0, 0, 69 }, /* #44 b */
    { 0x096692, 0x096616, 0x078ae184, 0x10000000, 0, 122 }, /* #45 */
    { 0x361947, 0x361116, 0x078ae184, 0x10000000, 0, 122 }, /* #45 b */
    { 0x2c3116, 0x2c3917, 0x6f4cd4c4, 0x53100000, 0, 114 }, /* #46 */
    { 0x134ec3, 0x134e17, 0x6f4cd4c4, 0x53100000, 0, 114 }, /* #46 b */
    { 0x0416d2, 0x041e96, 0xe3495fdb, 0x92bfb600, 0, 73 }, /* #47 */
    { 0x3b6907, 0x3b6996, 0xe3495fdb, 0x92bfb600, 0, 73 }, /* #47 b */
    { 0x2c3382, 0x2c3b96, 0x262be581, 0xf9604000, 0, 14 }, /* #48 */
    { 0x134c57, 0x134c96, 0x262be581, 0xf9604000, 0, 14 }, /* #48 b */
    { 0x184593, 0x184597, 0x55d2bf34, 0x9a000000, 0, 55 }, /* #49 */
    { 0x273a46, 0x273297, 0x55d2bf34, 0x9a000000, 0, 55 }, /* #49 b */
    { 0x203987, 0x203197, 0x94aab156, 0x8ab00000, 0, 51 }, /* #50 */
    { 0x1f4652, 0x1f4697, 0x94aab156, 0x8ab00000, 0, 51 }, /* #50 b */
    { 0x3a5b07, 0x3a5b96, 0x47edc6d8, 0xdc6d8000, 0, 76 }, /* #51 */
    { 0x0524d2, 0x052c96, 0x47edc6d8, 0xdc6d8000, 0, 76 }, /* #51 b */
    { 0x2b3cd2, 0x2b3416, 0xd4e8394e, 0x70000000, 0, 27 }, /* #52 */
    { 0x144307, 0x144316, 0xd4e8394e, 0x70000000, 0, 27 }, /* #52 b */
    { 0x0d2352, 0x0d2b17, 0x85e72656, 0x0bce4cac, 0, 33 }, /* #53 */
    { 0x325c87, 0x325c17, 0x85e72656, 0x0bce4cac, 0, 33 }, /* #53 b */
    { 0x3558c6, 0x355896, 0x3aa11c17, 0xa84705c0, 0, 102 }, /* #54 */
    { 0x0a2713, 0x0a2f96, 0x3aa11c17, 0xa84705c0, 0, 102 }, /* #54 b */
    { 0x2408d6, 0x240896, 0x828a107f, 0xfe000000, 0, 121 }, /* #55 */
    { 0x1b7703, 0x1b7f96, 0x828a107f, 0xfe000000, 0, 121 }, /* #55 b */
    { 0x206d16, 0x206d96, 0xc72d5744, 0x80000000, 0, 93 }, /* #56 */
    { 0x1f12c3, 0x1f1a96, 0xc72d5744, 0x80000000, 0, 93 }, /* #56 b */
    { 0x295a83, 0x295a17, 0xc940b994, 0x02e65000, 0, 74 }, /* #57 */
    { 0x162556, 0x162d17, 0xc940b994, 0x02e65000, 0, 74 }, /* #57 b */
    { 0x294fd7, 0x294f17, 0x045690ab, 0x15a42ac0, 0, 70 }, /* #58 */
    { 0x163002, 0x163817, 0x045690ab, 0x15a42ac0, 0, 70 }, /* #58 b */
    { 0x0903c3, 0x090b96, 0xa417ab11, 0xf5622000, 0, 109 }, /* #59 */
    { 0x367c16, 0x367c96, 0xa417ab11, 0xf5622000, 0, 109 }, /* #59 b */
    { 0x2a6006, 0x2a6097, 0xb3c7ceb6, 0x8f9d6c00, 0, 73 }, /* #60 */
    { 0x151fd3, 0x151797, 0xb3c7ceb6, 0x8f9d6c00, 0, 73 }, /* #60 b */
    { 0x227912, 0x227116, 0x8e7aa8e4, 0x40000000, 0, 124 }, /* #61 */
    { 0x1d06c7, 0x1d0616, 0x8e7aa8e4, 0x40000000, 0, 124 }, /* #61 b */
    { 0x2754d6, 0x275c96, 0xe5baf546, 0xa3000000, 0, 87 }, /* #62 */
    { 0x182b03, 0x182b96, 0xe5baf546, 0xa3000000, 0, 87 }, /* #62 b */
    { 0x3864d3, 0x386416, 0x7a2d22f5, 0x5a45ea00, 0, 41 }, /* #63 */
    { 0x071b06, 0x071316, 0x7a2d22f5, 0x5a45ea00, 0, 41 }, /* #63 b */
    { 0x1e6d46, 0x1e6d96, 0xecd792fc, 0xbc97e000, 0, 43 }, /* #64 */
    { 0x211293, 0x211a96, 0xecd792fc, 0xbc97e000, 0, 43 }, /* #64 b */
    { 0x026e93, 0x026e96, 0x0eff090b, 0xc0000000, 0, 94 }, /* #65 */
    { 0x3d1146, 0x3d1996, 0x0eff090b, 0xc0000000, 0, 94 }, /* #65 b */
    { 0x0e7bc7, 0x0e7316, 0xb273d9fa, 0x7e800000, 0, 118 }, /* #66 */
    { 0x310412, 0x310416, 0xb273d9fa, 0x7e800000, 0, 118 }, /* #66 b */
    { 0x114487, 0x114c17, 0x927d0628, 0x3e831400, 0, 103 }, /* #67 */
    { 0x2e3b52, 0x2e3b17, 0x927d0628, 0x3e831400, 0, 103 }, /* #67 b */
    { 0x210b47, 0x210b17, 0x51093aa9, 0x48000000, 0, 123 }, /* #68 */
    { 0x1e7492, 0x1e7c17, 0x51093aa9, 0x48000000, 0, 123 }, /* #68 b */
    { 0x3e2d96, 0x3e2597, 0xbfeaa372, 0xc8000000, 0, 122 }, /* #69 */
    { 0x015243, 0x015297, 0xbfeaa372, 0xc8000000, 0, 122 }, /* #69 b */
    { 0x0b1dd2, 0x0b1516, 0x4adaac6a, 0x35000000, 0, 55 }, /* #70 */
    { 0x346207, 0x346216, 0x4adaac6a, 0x35000000, 0, 55 }, /* #70 b */
    { 0x3553c7, 0x355b17, 0xe72cf274, 0x396793a0, 0, 67 }, /* #71 */
    { 0x0a2c12, 0x0a2c17, 0xe72cf274, 0x396793a0, 0, 67 }, /* #71 b */
    { 0x1d3692, 0x1d3697, 0x8eb8fe2c, 0xe2c00000, 0, 20 }, /* #72 */
    { 0x224947, 0x224197, 0x8eb8fe2c, 0xe2c00000, 0, 20 }, /* #72 b */
    { 0x202092, 0x202016, 0xb284b8b6, 0x2d800000, 0, 118 }, /* #73 */
    { 0x1f5f47, 0x1f5716, 0xb284b8b6, 0x2d800000, 0, 118 }, /* #73 b */
    { 0x3f6107, 0x3f6996, 0x1f3cb933, 0xc0000000, 0, 30 }, /* #74 */
    { 0x001ed2, 0x001e96, 0x1f3cb933, 0xc0000000, 0, 30 }, /* #74 b */
    { 0x086383, 0x086b17, 0xd252748d, 0x48d00000, 0, 52 }, /* #75 */
    { 0x371c56, 0x371c17, 0xd252748d, 0x48d00000, 0, 52 }, /* #75 b */
    { 0x394113, 0x394197, 0x9d327ffc, 0x80000000, 0, 93 }, /* #76 */
    { 0x063ec6, 0x063697, 0x9d327ffc, 0x80000000, 0, 93 }, /* #76 b */
    { 0x084213, 0x084212, 0x00ff9239, 0x1ff24720, 0, 5  }, /* #77 */
    { 0x373dc6, 0x373512, 0x00ff9239, 0x1ff24720, 0, 5  }, /* #77 b */
    { 0x2c4d06, 0x2c4d17, 0xe6bd3124, 0x4c490000, 0, 46 }, /* #78 */
    { 0x1332d3, 0x133a17, 0xe6bd3124, 0x4c490000, 0, 46 }, /* #78 b */
    { 0x190487, 0x190c96, 0xe1c02998, 0xc0000000, 0, 27 }, /* #79 */
    { 0x267b52, 0x267b96, 0xe1c02998, 0xc0000000, 0, 27 }, /* #79 b */
    { 0x3d6f53, 0x3d6797, 0xb36cc2b8, 0xc0000000, 0, 59 }, /* #80 */
    { 0x021086, 0x021097, 0xb36cc2b8, 0xc0000000, 0, 59 }, /* #80 b */
    { 0x3f4683, 0x3f4697, 0xb2c3e15e, 0xf0af0000, 0, 47 }, /* #81 */
    { 0x003956, 0x003197, 0xb2c3e15e, 0xf0af0000, 0, 47 }, /* #81 b */
    { 0x2305d7, 0x230d17, 0x545ec8bb, 0x645d8000, 0, 111 }, /* #82 */
    { 0x1c7a02, 0x1c7a17, 0x545ec8bb, 0x645d8000, 0, 111 }, /* #82 b */
    { 0x3546d3, 0x354616, 0x60471c14, 0x50000000, 0, 26 }, /* #83 */
    { 0x0a3906, 0x0a3116, 0x60471c14, 0x50000000, 0, 26 }, /* #83 b */
    { 0x046016, 0x046016, 0x4dd3e343, 0x4dd3e343, 0, 32 }, /* #84 */
    { 0x3b1fc3, 0x3b1fc3, 0x4dd3e343, 0x4dd3e343, 0, 32 }, /* #84 b */
    { 0x345e93, 0x345e96, 0x65004045, 0xa0000000, 0, 125 }, /* #85 */
    { 0x0b2146, 0x0b2996, 0x65004045, 0xa0000000, 0, 125 }, /* #85 b */
    { 0x181852, 0x181817, 0x75ad1f03, 0x1f030000, 0, 80 }, /* #86 */
    { 0x276787, 0x276f17, 0x75ad1f03, 0x1f030000, 0, 80 }, /* #86 b */
    { 0x3d7753, 0x3d7716, 0x3cf31e88, 0x20000000, 0, 122 }, /* #87 */
    { 0x020886, 0x020016, 0x3cf31e88, 0x20000000, 0, 122 }, /* #87 b */
    { 0x3e7443, 0x3e7416, 0x43de0e12, 0x24000000, 0, 57 }, /* #88 */
    { 0x010b96, 0x010316, 0x43de0e12, 0x24000000, 0, 57 }, /* #88 b */
    { 0x090d93, 0x090516, 0x0a781c80, 0x72000000, 0, 50 }, /* #89 */
    { 0x367246, 0x367216, 0x0a781c80, 0x72000000, 0, 50 }, /* #89 b */
    { 0x137b02, 0x137b96, 0x2abb1a28, 0x8a000000, 0, 86 }, /* #90 */
    { 0x2c04d7, 0x2c0c96, 0x2abb1a28, 0x8a000000, 0, 86 }, /* #90 b */
    { 0x0a34c2, 0x0a3c92, 0xb1698726, 0xc5a61c98, 0, 34 }, /* #91 */
    { 0x354b17, 0x354b92, 0xb1698726, 0xc5a61c98, 0, 34 }, /* #91 b */
    { 0x3a3ad3, 0x3a3a92, 0x4ac1242b, 0xac1242b0, 0, 100 }, /* #92 */
    { 0x054506, 0x054d92, 0x4ac1242b, 0xac1242b0, 0, 100 }, /* #92 b */
    { 0x0c0c57, 0x0c0416, 0x953daca7, 0x7b594e00, 0, 41 }, /* #93 */
    { 0x337382, 0x337316, 0x953daca7, 0x7b594e00, 0, 41 }, /* #93 b */
    { 0x3d3f03, 0x3d3716, 0xfd112054, 0x2a000000, 0, 87 }, /* #94 */
    { 0x0240d6, 0x024016, 0xfd112054, 0x2a000000, 0, 87 }, /* #94 b */
    { 0x0926d2, 0x092697, 0xaf13e688, 0xcd100000, 0, 49 }, /* #95 */
    { 0x365907, 0x365197, 0xaf13e688, 0xcd100000, 0, 49 }, /* #95 b */
};
uint32_t const g_cTests_shl_u32_amd = RT_ELEMENTS(g_aTests_shl_u32_amd);

BINU32_TEST_T const g_aTests_shr_u32_amd[] =
{
    { 0x033b46, 0x033356, 0x00000000, 0x00000000, 0, 33 }, /* #0 */
    { 0x3c4493, 0x3c4456, 0x00000000, 0x00000000, 0, 33 }, /* #0 b */
    { 0x2c5352, 0x2c5356, 0x00000000, 0x00000000, 0, 102 }, /* #1 */
    { 0x132c87, 0x132456, 0x00000000, 0x00000000, 0, 102 }, /* #1 b */
    { 0x1e3752, 0x1e3756, 0x00000000, 0x00000000, 0, 74 }, /* #2 */
    { 0x214887, 0x214056, 0x00000000, 0x00000000, 0, 74 }, /* #2 b */
    { 0x292412, 0x292456, 0x00000000, 0x00000000, 0, 71 }, /* #3 */
    { 0x165bc7, 0x165356, 0x00000000, 0x00000000, 0, 71 }, /* #3 b */
    { 0x094c56, 0x094456, 0x00000000, 0x00000000, 0, 87 }, /* #4 */
    { 0x363383, 0x363356, 0x00000000, 0x00000000, 0, 87 }, /* #4 b */
    { 0x357d82, 0x357556, 0x00000000, 0x00000000, 0, 87 }, /* #5 */
    { 0x0a0257, 0x0a0256, 0x00000000, 0x00000000, 0, 87 }, /* #5 b */
    { 0x3e72d6, 0x3e7217, 0x37fb0be7, 0x00000006, 0, 59 }, /* #6 */
    { 0x010d03, 0x010517, 0x37fb0be7, 0x00000006, 0, 59 }, /* #6 b */
    { 0x2a3ac3, 0x2a3217, 0x9c95beac, 0x00009c95, 0, 48 }, /* #7 */
    { 0x154516, 0x154517, 0x9c95beac, 0x00009c95, 0, 48 }, /* #7 b */
    { 0x212496, 0x212412, 0x69f359ea, 0x001a7cd6, 0, 42 }, /* #8 */
    { 0x1e5b43, 0x1e5312, 0x69f359ea, 0x001a7cd6, 0, 42 }, /* #8 b */
    { 0x174a92, 0x174217, 0x73d3533b, 0x039e9a99, 0, 101 }, /* #9 */
    { 0x283547, 0x283517, 0x73d3533b, 0x039e9a99, 0, 101 }, /* #9 b */
    { 0x1a7d97, 0x1a7516, 0xa0bee3f9, 0x00000028, 0, 58 }, /* #10 */
    { 0x250242, 0x250216, 0xa0bee3f9, 0x00000028, 0, 58 }, /* #10 b */
    { 0x0f3203, 0x0f3213, 0xb2b7b22d, 0x0000595b, 0, 49 }, /* #11 */
    { 0x304dd6, 0x304513, 0xb2b7b22d, 0x0000595b, 0, 49 }, /* #11 b */
    { 0x016493, 0x016417, 0x7e45a751, 0x00fc8b4e, 0, 71 }, /* #12 */
    { 0x3e1b46, 0x3e1317, 0x7e45a751, 0x00fc8b4e, 0, 71 }, /* #12 b */
    { 0x214b43, 0x214316, 0x3f69d8d2, 0x03f69d8d, 0, 4  }, /* #13 */
    { 0x1e3496, 0x1e3416, 0x3f69d8d2, 0x03f69d8d, 0, 4  }, /* #13 b */
    { 0x280ed6, 0x280612, 0x4c6e4395, 0x0131b90e, 0, 102 }, /* #14 */
    { 0x177103, 0x177112, 0x4c6e4395, 0x0131b90e, 0, 102 }, /* #14 b */
    { 0x391542, 0x391542, 0x8822c4d7, 0x8822c4d7, 0, 64 }, /* #15 */
    { 0x066a97, 0x066a97, 0x8822c4d7, 0x8822c4d7, 0, 64 }, /* #15 b */
    { 0x0b1852, 0x0b1012, 0x4debe4ff, 0x00000013, 0, 122 }, /* #16 */
    { 0x346787, 0x346712, 0x4debe4ff, 0x00000013, 0, 122 }, /* #16 b */
    { 0x1e55d6, 0x1e5512, 0xcc1d1a7e, 0x00cc1d1a, 0, 104 }, /* #17 */
    { 0x212a03, 0x212212, 0xcc1d1a7e, 0x00cc1d1a, 0, 104 }, /* #17 b */
    { 0x126602, 0x126612, 0x0bb152a4, 0x00000001, 0, 123 }, /* #18 */
    { 0x2d19d7, 0x2d1112, 0x0bb152a4, 0x00000001, 0, 123 }, /* #18 b */
    { 0x093093, 0x093016, 0x68e7024d, 0x00000347, 0, 53 }, /* #19 */
    { 0x364f46, 0x364716, 0x68e7024d, 0x00000347, 0, 53 }, /* #19 b */
    { 0x3d71d6, 0x3d7117, 0x854fa280, 0x00000042, 0, 57 }, /* #20 */
    { 0x020e03, 0x020617, 0x854fa280, 0x00000042, 0, 57 }, /* #20 b */
    { 0x3b5247, 0x3b5256, 0x2f321766, 0x00000000, 0, 63 }, /* #21 */
    { 0x042d92, 0x042556, 0x2f321766, 0x00000000, 0, 63 }, /* #21 b */
    { 0x2e6347, 0x2e6317, 0x06c1a85b, 0x000d8350, 0, 39 }, /* #22 */
    { 0x111c92, 0x111417, 0x06c1a85b, 0x000d8350, 0, 39 }, /* #22 b */
    { 0x143d12, 0x143517, 0xc5c89fd2, 0x00c5c89f, 0, 72 }, /* #23 */
    { 0x2b42c7, 0x2b4217, 0xc5c89fd2, 0x00c5c89f, 0, 72 }, /* #23 b */
    { 0x0d6813, 0x0d6012, 0x0de3ad33, 0x00de3ad3, 0, 100 }, /* #24 */
    { 0x3217c6, 0x321712, 0x0de3ad33, 0x00de3ad3, 0, 100 }, /* #24 b */
    { 0x094f96, 0x094713, 0xf84fc464, 0x00000007, 0, 29 }, /* #25 */
    { 0x363043, 0x363013, 0xf84fc464, 0x00000007, 0, 29 }, /* #25 b */
    { 0x1641d3, 0x164112, 0x61994a24, 0x000c3329, 0, 11 }, /* #26 */
    { 0x293e06, 0x293612, 0x61994a24, 0x000c3329, 0, 11 }, /* #26 b */
    { 0x097643, 0x097613, 0x423b0d13, 0x00211d86, 0, 9  }, /* #27 */
    { 0x360996, 0x360113, 0x423b0d13, 0x00211d86, 0, 9  }, /* #27 b */
    { 0x3a3a46, 0x3a3213, 0x0b1b5659, 0x058dab2c, 0, 65 }, /* #28 */
    { 0x054593, 0x054513, 0x0b1b5659, 0x058dab2c, 0, 65 }, /* #28 b */
    { 0x287547, 0x287516, 0xaa336e48, 0x0000aa33, 0, 112 }, /* #29 */
    { 0x170a92, 0x170216, 0xaa336e48, 0x0000aa33, 0, 112 }, /* #29 b */
    { 0x0f4e56, 0x0f4612, 0xf967d2af, 0x0000003e, 0, 26 }, /* #30 */
    { 0x303183, 0x303112, 0xf967d2af, 0x0000003e, 0, 26 }, /* #30 b */
    { 0x100b12, 0x100316, 0xd108684e, 0x00000344, 0, 86 }, /* #31 */
    { 0x2f74c7, 0x2f7416, 0xd108684e, 0x00000344, 0, 86 }, /* #31 b */
    { 0x3167c2, 0x316712, 0x809531a6, 0x0020254c, 0, 106 }, /* #32 */
    { 0x0e1817, 0x0e1012, 0x809531a6, 0x0020254c, 0, 106 }, /* #32 b */
    { 0x361687, 0x361616, 0x2a492f75, 0x000000a9, 0, 86 }, /* #33 */
    { 0x096952, 0x096116, 0x2a492f75, 0x000000a9, 0, 86 }, /* #33 b */
    { 0x2f3842, 0x2f3012, 0x20de3ded, 0x0008378f, 0, 74 }, /* #34 */
    { 0x104797, 0x104712, 0x20de3ded, 0x0008378f, 0, 74 }, /* #34 b */
    { 0x1b6607, 0x1b6612, 0x1b9a68e2, 0x000dcd34, 0, 105 }, /* #35 */
    { 0x2419d2, 0x241112, 0x1b9a68e2, 0x000dcd34, 0, 105 }, /* #35 b */
    { 0x180e16, 0x180612, 0xe32000b0, 0x01c64001, 0, 39 }, /* #36 */
    { 0x2771c3, 0x277112, 0xe32000b0, 0x01c64001, 0, 39 }, /* #36 b */
    { 0x326cc6, 0x326413, 0x4f4d1350, 0x00000004, 0, 92 }, /* #37 */
    { 0x0d1313, 0x0d1313, 0x4f4d1350, 0x00000004, 0, 92 }, /* #37 b */
    { 0x3d2a12, 0x3d2216, 0xcb6ab894, 0x0196d571, 0, 103 }, /* #38 */
    { 0x0255c7, 0x025516, 0xcb6ab894, 0x0196d571, 0, 103 }, /* #38 b */
    { 0x013e16, 0x013612, 0x2e09b9e9, 0x00005c13, 0, 111 }, /* #39 */
    { 0x3e41c3, 0x3e4112, 0x2e09b9e9, 0x00005c13, 0, 111 }, /* #39 b */
    { 0x063086, 0x063013, 0xe7db546f, 0x00073eda, 0, 45 }, /* #40 */
    { 0x394f53, 0x394713, 0xe7db546f, 0x00073eda, 0, 45 }, /* #40 b */
    { 0x0e5f93, 0x0e5713, 0x2f77ad3c, 0x00000002, 0, 124 }, /* #41 */
    { 0x312046, 0x312013, 0x2f77ad3c, 0x00000002, 0, 124 }, /* #41 b */
    { 0x101516, 0x101513, 0x9e9806fc, 0x000004f4, 0, 21 }, /* #42 */
    { 0x2f6ac3, 0x2f6213, 0x9e9806fc, 0x000004f4, 0, 21 }, /* #42 b */
    { 0x216057, 0x216016, 0xe8d12783, 0x0e8d1278, 0, 100 }, /* #43 */
    { 0x1e1f82, 0x1e1716, 0xe8d12783, 0x0e8d1278, 0, 100 }, /* #43 b */
    { 0x3a5597, 0x3a5513, 0xdd52f1d2, 0x00dd52f1, 0, 8  }, /* #44 */
    { 0x052a42, 0x052213, 0xdd52f1d2, 0x00dd52f1, 0, 8  }, /* #44 b */
    { 0x062d13, 0x062516, 0x490e5c8e, 0x00000012, 0, 26 }, /* #45 */
    { 0x3952c6, 0x395216, 0x490e5c8e, 0x00000012, 0, 26 }, /* #45 b */
    { 0x0d5ec6, 0x0d5612, 0x741176f8, 0x0e822edf, 0, 3  }, /* #46 */
    { 0x322113, 0x322112, 0x741176f8, 0x0e822edf, 0, 3  }, /* #46 b */
    { 0x1c4892, 0x1c4017, 0xc1aab43d, 0x00000060, 0, 121 }, /* #47 */
    { 0x233747, 0x233717, 0xc1aab43d, 0x00000060, 0, 121 }, /* #47 b */
    { 0x2a3d97, 0x2a3516, 0x0405059d, 0x00001014, 0, 78 }, /* #48 */
    { 0x154242, 0x154216, 0x0405059d, 0x00001014, 0, 78 }, /* #48 b */
    { 0x305312, 0x305312, 0x5ea79d53, 0x00000001, 0, 94 }, /* #49 */
    { 0x0f2cc7, 0x0f2412, 0x5ea79d53, 0x00000001, 0, 94 }, /* #49 b */
    { 0x1a2b06, 0x1a2316, 0xc746d261, 0x0000063a, 0, 85 }, /* #50 */
    { 0x2554d3, 0x255416, 0xc746d261, 0x0000063a, 0, 85 }, /* #50 b */
    { 0x0c2cd7, 0x0c2413, 0xf993e582, 0x007cc9f2, 0, 41 }, /* #51 */
    { 0x335302, 0x335313, 0xf993e582, 0x007cc9f2, 0, 41 }, /* #51 b */
    { 0x247b52, 0x247312, 0x585c44f3, 0x0b0b889e, 0, 3  }, /* #52 */
    { 0x1b0487, 0x1b0412, 0x585c44f3, 0x0b0b889e, 0, 3  }, /* #52 b */
    { 0x1244d6, 0x124412, 0x20a6de81, 0x00829b7a, 0, 102 }, /* #53 */
    { 0x2d3b03, 0x2d3312, 0x20a6de81, 0x00829b7a, 0, 102 }, /* #53 b */
    { 0x223346, 0x223316, 0x47fd590d, 0x008ffab2, 0, 103 }, /* #54 */
    { 0x1d4c93, 0x1d4416, 0x47fd590d, 0x008ffab2, 0, 103 }, /* #54 b */
    { 0x036f17, 0x036717, 0xfc45883a, 0x00001f88, 0, 19 }, /* #55 */
    { 0x3c10c2, 0x3c1017, 0xfc45883a, 0x00001f88, 0, 19 }, /* #55 b */
    { 0x271112, 0x271112, 0x0dd3ea8f, 0x0dd3ea8f, 0, 96 }, /* #56 */
    { 0x186ec7, 0x186ec7, 0x0dd3ea8f, 0x0dd3ea8f, 0, 96 }, /* #56 b */
    { 0x3f5893, 0x3f5013, 0xb0e5aec7, 0x000000b0, 0, 56 }, /* #57 */
    { 0x002746, 0x002713, 0xb0e5aec7, 0x000000b0, 0, 56 }, /* #57 b */
    { 0x064906, 0x064117, 0xa9ae1e98, 0x0000000a, 0, 92 }, /* #58 */
    { 0x3936d3, 0x393617, 0xa9ae1e98, 0x0000000a, 0, 92 }, /* #58 b */
    { 0x0f6092, 0x0f6017, 0xbfa84b6f, 0x00017f50, 0, 15 }, /* #59 */
    { 0x301f47, 0x301717, 0xbfa84b6f, 0x00017f50, 0, 15 }, /* #59 b */
    { 0x2f3d93, 0x2f3517, 0x04c9163c, 0x00009922, 0, 107 }, /* #60 */
    { 0x104246, 0x104217, 0x04c9163c, 0x00009922, 0, 107 }, /* #60 b */
    { 0x0b4903, 0x0b4903, 0x0241adea, 0x0241adea, 0, 96 }, /* #61 */
    { 0x3436d6, 0x3436d6, 0x0241adea, 0x0241adea, 0, 96 }, /* #61 b */
    { 0x002296, 0x002212, 0x6e687448, 0x00000037, 0, 25 }, /* #62 */
    { 0x3f5d43, 0x3f5512, 0x6e687448, 0x00000037, 0, 25 }, /* #62 b */
    { 0x231fc2, 0x231713, 0x778fb6ac, 0x00000ef1, 0, 51 }, /* #63 */
    { 0x1c6017, 0x1c6013, 0x778fb6ac, 0x00000ef1, 0, 51 }, /* #63 b */
    { 0x046496, 0x046417, 0xe67ceb4b, 0x00000003, 0, 126 }, /* #64 */
    { 0x3b1b43, 0x3b1317, 0xe67ceb4b, 0x00000003, 0, 126 }, /* #64 b */
    { 0x152507, 0x152516, 0x6e079809, 0x0001b81e, 0, 78 }, /* #65 */
    { 0x2a5ad2, 0x2a5216, 0x6e079809, 0x0001b81e, 0, 78 }, /* #65 b */
    { 0x1744d7, 0x174417, 0x00288118, 0x00000028, 0, 16 }, /* #66 */
    { 0x283b02, 0x283317, 0x00288118, 0x00000028, 0, 16 }, /* #66 b */
    { 0x2168d6, 0x216017, 0x11b3feb6, 0x000046cf, 0, 78 }, /* #67 */
    { 0x1e1703, 0x1e1717, 0x11b3feb6, 0x000046cf, 0, 78 }, /* #67 b */
    { 0x202643, 0x202612, 0x122f968c, 0x00000002, 0, 123 }, /* #68 */
    { 0x1f5996, 0x1f5112, 0x122f968c, 0x00000002, 0, 123 }, /* #68 b */
    { 0x3f7207, 0x3f7256, 0x058b124a, 0x00000000, 0, 29 }, /* #69 */
    { 0x000dd2, 0x000556, 0x058b124a, 0x00000000, 0, 29 }, /* #69 b */
    { 0x272503, 0x272517, 0x3a427ac1, 0x00000003, 0, 28 }, /* #70 */
    { 0x185ad6, 0x185217, 0x3a427ac1, 0x00000003, 0, 28 }, /* #70 b */
    { 0x103852, 0x103013, 0x892c05ce, 0x00449602, 0, 105 }, /* #71 */
    { 0x2f4787, 0x2f4713, 0x892c05ce, 0x00449602, 0, 105 }, /* #71 b */
    { 0x161ad3, 0x161a12, 0xb7c357b8, 0x5be1abdc, 0, 33 }, /* #72 */
    { 0x296506, 0x296d12, 0xb7c357b8, 0x5be1abdc, 0, 33 }, /* #72 b */
    { 0x2b0353, 0x2b0317, 0x622f8156, 0x00000188, 0, 118 }, /* #73 */
    { 0x147c86, 0x147417, 0x622f8156, 0x00000188, 0, 118 }, /* #73 b */
    { 0x1402c3, 0x140217, 0x63d4ef68, 0x00000063, 0, 56 }, /* #74 */
    { 0x2b7d16, 0x2b7517, 0x63d4ef68, 0x00000063, 0, 56 }, /* #74 b */
    { 0x190757, 0x190712, 0xeec3ed87, 0x0007761f, 0, 13 }, /* #75 */
    { 0x267882, 0x267012, 0xeec3ed87, 0x0007761f, 0, 13 }, /* #75 b */
    { 0x0374c3, 0x037412, 0x568218d8, 0x0015a086, 0, 74 }, /* #76 */
    { 0x3c0b16, 0x3c0312, 0x568218d8, 0x0015a086, 0, 74 }, /* #76 b */
    { 0x3d6483, 0x3d6413, 0x32e782e1, 0x000000cb, 0, 54 }, /* #77 */
    { 0x021b56, 0x021313, 0x32e782e1, 0x000000cb, 0, 54 }, /* #77 b */
    { 0x0c7007, 0x0c7016, 0xb7d6a109, 0x2df5a842, 0, 2  }, /* #78 */
    { 0x330fd2, 0x330716, 0xb7d6a109, 0x2df5a842, 0, 2  }, /* #78 b */
    { 0x276c07, 0x276c07, 0xf0c0a5a9, 0xf0c0a5a9, 0, 64 }, /* #79 */
    { 0x1813d2, 0x1813d2, 0xf0c0a5a9, 0xf0c0a5a9, 0, 64 }, /* #79 b */
    { 0x136b56, 0x136316, 0xb33f69c2, 0x00000166, 0, 87 }, /* #80 */
    { 0x2c1483, 0x2c1416, 0xb33f69c2, 0x00000166, 0, 87 }, /* #80 b */
    { 0x123652, 0x123613, 0x4c3616a1, 0x00130d85, 0, 74 }, /* #81 */
    { 0x2d4987, 0x2d4113, 0x4c3616a1, 0x00130d85, 0, 74 }, /* #81 b */
    { 0x3c7a52, 0x3c7212, 0x875e7143, 0x0000875e, 0, 80 }, /* #82 */
    { 0x030587, 0x030512, 0x875e7143, 0x0000875e, 0, 80 }, /* #82 b */
    { 0x370ed7, 0x370616, 0xbff94423, 0x05ffca21, 0, 37 }, /* #83 */
    { 0x087102, 0x087116, 0xbff94423, 0x05ffca21, 0, 37 }, /* #83 b */
    { 0x054d82, 0x054512, 0x262d412c, 0x00000002, 0, 28 }, /* #84 */
    { 0x3a3257, 0x3a3212, 0x262d412c, 0x00000002, 0, 28 }, /* #84 b */
    { 0x167d47, 0x167513, 0x27ce5dda, 0x0000027c, 0, 116 }, /* #85 */
    { 0x290292, 0x290213, 0x27ce5dda, 0x0000027c, 0, 116 }, /* #85 b */
    { 0x2d46c7, 0x2d4612, 0x8a41c165, 0x00000045, 0, 121 }, /* #86 */
    { 0x123912, 0x123112, 0x8a41c165, 0x00000045, 0, 121 }, /* #86 b */
    { 0x2a7242, 0x2a7257, 0x36fba9f1, 0x00000000, 0, 62 }, /* #87 */
    { 0x150d97, 0x150557, 0x36fba9f1, 0x00000000, 0, 62 }, /* #87 b */
    { 0x082e83, 0x082613, 0xe6af7537, 0x000000e6, 0, 56 }, /* #88 */
    { 0x375156, 0x375113, 0xe6af7537, 0x000000e6, 0, 56 }, /* #88 b */
    { 0x0c7c96, 0x0c7416, 0xf5076a9f, 0x001ea0ed, 0, 107 }, /* #89 */
    { 0x330343, 0x330316, 0xf5076a9f, 0x001ea0ed, 0, 107 }, /* #89 b */
    { 0x0713d6, 0x071317, 0x2ea6dcf4, 0x00017536, 0, 109 }, /* #90 */
    { 0x386c03, 0x386417, 0x2ea6dcf4, 0x00017536, 0, 109 }, /* #90 b */
    { 0x2b5717, 0x2b5716, 0xaded2887, 0x00056f69, 0, 77 }, /* #91 */
    { 0x1428c2, 0x142016, 0xaded2887, 0x00056f69, 0, 77 }, /* #91 b */
    { 0x3653c3, 0x365313, 0xf952663b, 0x000001f2, 0, 55 }, /* #92 */
    { 0x092c16, 0x092413, 0xf952663b, 0x000001f2, 0, 55 }, /* #92 b */
    { 0x0275d3, 0x027517, 0x43613052, 0x00021b09, 0, 13 }, /* #93 */
    { 0x3d0a06, 0x3d0217, 0x43613052, 0x00021b09, 0, 13 }, /* #93 b */
    { 0x197cc2, 0x197417, 0x6760a1af, 0x00019d82, 0, 46 }, /* #94 */
    { 0x260317, 0x260317, 0x6760a1af, 0x00019d82, 0, 46 }, /* #94 b */
    { 0x3c7517, 0x3c7512, 0xcfc0725b, 0x000067e0, 0, 113 }, /* #95 */
    { 0x030ac2, 0x030212, 0xcfc0725b, 0x000067e0, 0, 113 }, /* #95 b */
};
uint32_t const g_cTests_shr_u32_amd = RT_ELEMENTS(g_aTests_shr_u32_amd);

BINU32_TEST_T const g_aTests_sar_u32_amd[] =
{
    { 0x3830d6, 0x383056, 0x00000000, 0x00000000, 0, 80 }, /* #0 */
    { 0x074f03, 0x074756, 0x00000000, 0x00000000, 0, 80 }, /* #0 b */
    { 0x3f0242, 0x3f0256, 0x00000000, 0x00000000, 0, 55 }, /* #1 */
    { 0x007d97, 0x007556, 0x00000000, 0x00000000, 0, 55 }, /* #1 b */
    { 0x0f4607, 0x0f4656, 0x00000000, 0x00000000, 0, 60 }, /* #2 */
    { 0x3039d2, 0x303156, 0x00000000, 0x00000000, 0, 60 }, /* #2 b */
    { 0x0f2586, 0x0f2556, 0x00000000, 0x00000000, 0, 80 }, /* #3 */
    { 0x305a53, 0x305256, 0x00000000, 0x00000000, 0, 80 }, /* #3 b */
    { 0x306ac3, 0x306256, 0x00000000, 0x00000000, 0, 41 }, /* #4 */
    { 0x0f1516, 0x0f1556, 0x00000000, 0x00000000, 0, 41 }, /* #4 b */
    { 0x355103, 0x355156, 0x00000000, 0x00000000, 0, 18 }, /* #5 */
    { 0x0a2ed6, 0x0a2656, 0x00000000, 0x00000000, 0, 18 }, /* #5 b */
    { 0x283652, 0x283616, 0x6328411d, 0x00000c65, 0, 115 }, /* #6 */
    { 0x174987, 0x174116, 0x6328411d, 0x00000c65, 0, 115 }, /* #6 b */
    { 0x033dc7, 0x033593, 0xdf2a5171, 0xff7ca945, 0, 6  }, /* #7 */
    { 0x3c4212, 0x3c4293, 0xdf2a5171, 0xff7ca945, 0, 6  }, /* #7 b */
    { 0x045603, 0x045697, 0xf94640e0, 0xffffff28, 0, 83 }, /* #8 */
    { 0x3b29d6, 0x3b2197, 0xf94640e0, 0xffffff28, 0, 83 }, /* #8 b */
    { 0x091442, 0x091497, 0xfbe634bd, 0xffbe634b, 0, 4  }, /* #9 */
    { 0x366b97, 0x366397, 0xfbe634bd, 0xffbe634b, 0, 4  }, /* #9 b */
    { 0x097ed3, 0x097697, 0xf1ef4bc5, 0xffffffff, 0, 31 }, /* #10 */
    { 0x360106, 0x360197, 0xf1ef4bc5, 0xffffffff, 0, 31 }, /* #10 b */
    { 0x3072d6, 0x307217, 0x0a4db65d, 0x00149b6c, 0, 71 }, /* #11 */
    { 0x0f0d03, 0x0f0517, 0x0a4db65d, 0x00149b6c, 0, 71 }, /* #11 b */
    { 0x3d5256, 0x3d5292, 0xe705f90c, 0xffffffce, 0, 87 }, /* #12 */
    { 0x022d83, 0x022592, 0xe705f90c, 0xffffffce, 0, 87 }, /* #12 b */
    { 0x363b42, 0x363392, 0xbc74a531, 0xef1d294c, 0, 34 }, /* #13 */
    { 0x094497, 0x094492, 0xbc74a531, 0xef1d294c, 0, 34 }, /* #13 b */
    { 0x122ed7, 0x122693, 0xe440c394, 0xffffffc8, 0, 119 }, /* #14 */
    { 0x2d5102, 0x2d5193, 0xe440c394, 0xffffffc8, 0, 119 }, /* #14 b */
    { 0x2f0917, 0x2f0112, 0x58d9a71c, 0x163669c7, 0, 2  }, /* #15 */
    { 0x1076c2, 0x107612, 0x58d9a71c, 0x163669c7, 0, 2  }, /* #15 b */
    { 0x2f7596, 0x2f7592, 0x94905ccc, 0xfffff292, 0, 115 }, /* #16 */
    { 0x100a43, 0x100292, 0x94905ccc, 0xfffff292, 0, 115 }, /* #16 b */
    { 0x1527d3, 0x152793, 0x8271571b, 0xffffc138, 0, 49 }, /* #17 */
    { 0x2a5806, 0x2a5093, 0x8271571b, 0xffffc138, 0, 49 }, /* #17 b */
    { 0x3e7d46, 0x3e7513, 0x4f1a52fb, 0x00000004, 0, 124 }, /* #18 */
    { 0x010293, 0x010213, 0x4f1a52fb, 0x00000004, 0, 124 }, /* #18 b */
    { 0x230d83, 0x230516, 0x39e76506, 0x000039e7, 0, 112 }, /* #19 */
    { 0x1c7256, 0x1c7216, 0x39e76506, 0x000039e7, 0, 112 }, /* #19 b */
    { 0x066a46, 0x066216, 0x606b234b, 0x00030359, 0, 13 }, /* #20 */
    { 0x391593, 0x391516, 0x606b234b, 0x00030359, 0, 13 }, /* #20 b */
    { 0x105e12, 0x105692, 0xd820b4e0, 0xfffffb04, 0, 83 }, /* #21 */
    { 0x2f21c7, 0x2f2192, 0xd820b4e0, 0xfffffb04, 0, 83 }, /* #21 b */
    { 0x1c1c97, 0x1c1493, 0xfbf6cf4c, 0xffffffdf, 0, 85 }, /* #22 */
    { 0x236342, 0x236393, 0xfbf6cf4c, 0xffffffdf, 0, 85 }, /* #22 b */
    { 0x3b1496, 0x3b1496, 0x841feebb, 0xffffffe1, 0, 26 }, /* #23 */
    { 0x046b43, 0x046396, 0x841feebb, 0xffffffe1, 0, 26 }, /* #23 b */
    { 0x030103, 0x030116, 0x7e41dec8, 0x01f9077b, 0, 102 }, /* #24 */
    { 0x3c7ed6, 0x3c7616, 0x7e41dec8, 0x01f9077b, 0, 102 }, /* #24 b */
    { 0x1c78c6, 0x1c7017, 0x7786f4dc, 0x00001de1, 0, 82 }, /* #25 */
    { 0x230713, 0x230717, 0x7786f4dc, 0x00001de1, 0, 82 }, /* #25 b */
    { 0x274643, 0x274613, 0x617e1a7b, 0x00000001, 0, 62 }, /* #26 */
    { 0x183996, 0x183113, 0x617e1a7b, 0x00000001, 0, 62 }, /* #26 b */
    { 0x1b3ad3, 0x1b3212, 0x35469010, 0x06a8d202, 0, 67 }, /* #27 */
    { 0x244506, 0x244512, 0x35469010, 0x06a8d202, 0, 67 }, /* #27 b */
    { 0x333b93, 0x333397, 0xb54c3c6f, 0xfffb54c3, 0, 12 }, /* #28 */
    { 0x0c4446, 0x0c4497, 0xb54c3c6f, 0xfffb54c3, 0, 12 }, /* #28 b */
    { 0x187643, 0x187696, 0xca440c76, 0xffffe522, 0, 17 }, /* #29 */
    { 0x270996, 0x270196, 0xca440c76, 0xffffe522, 0, 17 }, /* #29 b */
    { 0x0b4496, 0x0b4417, 0x4c8572f2, 0x0013215c, 0, 74 }, /* #30 */
    { 0x343b43, 0x343317, 0x4c8572f2, 0x0013215c, 0, 74 }, /* #30 b */
    { 0x1d2d12, 0x1d2592, 0xbacd150a, 0xfffeeb34, 0, 46 }, /* #31 */
    { 0x2252c7, 0x225292, 0xbacd150a, 0xfffeeb34, 0, 46 }, /* #31 b */
    { 0x2d1ed6, 0x2d1697, 0xd88dbddd, 0xfb11b7bb, 0, 67 }, /* #32 */
    { 0x126103, 0x126197, 0xd88dbddd, 0xfb11b7bb, 0, 67 }, /* #32 b */
    { 0x2c1f12, 0x2c1793, 0xb73ef688, 0xfffedcfb, 0, 14 }, /* #33 */
    { 0x1360c7, 0x136093, 0xb73ef688, 0xfffedcfb, 0, 14 }, /* #33 b */
    { 0x153b87, 0x153312, 0x06f8d8cd, 0x00001be3, 0, 78 }, /* #34 */
    { 0x2a4452, 0x2a4412, 0x06f8d8cd, 0x00001be3, 0, 78 }, /* #34 b */
    { 0x2b5156, 0x2b5117, 0x3a69258e, 0x00074d24, 0, 107 }, /* #35 */
    { 0x142e83, 0x142617, 0x3a69258e, 0x00074d24, 0, 107 }, /* #35 b */
    { 0x0c0b82, 0x0c0316, 0x348d9aa1, 0x0000d236, 0, 78 }, /* #36 */
    { 0x337457, 0x337416, 0x348d9aa1, 0x0000d236, 0, 78 }, /* #36 b */
    { 0x015147, 0x015116, 0x7114b249, 0x000e2296, 0, 75 }, /* #37 */
    { 0x3e2e92, 0x3e2616, 0x7114b249, 0x000e2296, 0, 75 }, /* #37 b */
    { 0x1b1c16, 0x1b1417, 0x39991f75, 0x00001ccc, 0, 49 }, /* #38 */
    { 0x2463c3, 0x246317, 0x39991f75, 0x00001ccc, 0, 49 }, /* #38 b */
    { 0x134712, 0x134797, 0xac729ae4, 0xffac729a, 0, 8  }, /* #39 */
    { 0x2c38c7, 0x2c3097, 0xac729ae4, 0xffac729a, 0, 8  }, /* #39 b */
    { 0x2c3013, 0x2c3096, 0x87c8374e, 0xffffffff, 0, 95 }, /* #40 */
    { 0x134fc6, 0x134796, 0x87c8374e, 0xffffffff, 0, 95 }, /* #40 b */
    { 0x3d4983, 0x3d4196, 0xac829d59, 0xfffffeb2, 0, 54 }, /* #41 */
    { 0x023656, 0x023696, 0xac829d59, 0xfffffeb2, 0, 54 }, /* #41 b */
    { 0x083ac2, 0x083297, 0xa90bd7b8, 0xffd485eb, 0, 105 }, /* #42 */
    { 0x374517, 0x374597, 0xa90bd7b8, 0xffd485eb, 0, 105 }, /* #42 b */
    { 0x270f52, 0x270717, 0x03e1198b, 0x00003e11, 0, 44 }, /* #43 */
    { 0x187087, 0x187017, 0x03e1198b, 0x00003e11, 0, 44 }, /* #43 b */
    { 0x036f02, 0x036717, 0x7f2f310d, 0x0fe5e621, 0, 99 }, /* #44 */
    { 0x3c10d7, 0x3c1017, 0x7f2f310d, 0x0fe5e621, 0, 99 }, /* #44 b */
    { 0x374557, 0x374517, 0x63fe5f99, 0x00000063, 0, 24 }, /* #45 */
    { 0x083a82, 0x083217, 0x63fe5f99, 0x00000063, 0, 24 }, /* #45 b */
    { 0x2d5047, 0x2d5096, 0xacc71918, 0xffffffff, 0, 31 }, /* #46 */
    { 0x122f92, 0x122796, 0xacc71918, 0xffffffff, 0, 31 }, /* #46 b */
    { 0x116417, 0x116493, 0xcb9df947, 0xffffffe5, 0, 25 }, /* #47 */
    { 0x2e1bc2, 0x2e1393, 0xcb9df947, 0xffffffe5, 0, 25 }, /* #47 b */
    { 0x3e0fc6, 0x3e0793, 0x8747fe1b, 0xfff8747f, 0, 44 }, /* #48 */
    { 0x017013, 0x017093, 0x8747fe1b, 0xfff8747f, 0, 44 }, /* #48 b */
    { 0x0a2256, 0x0a2292, 0x85e9d0a6, 0xfc2f4e85, 0, 37 }, /* #49 */
    { 0x355d83, 0x355592, 0x85e9d0a6, 0xfc2f4e85, 0, 37 }, /* #49 b */
    { 0x194557, 0x194513, 0x76df13e3, 0x0003b6f8, 0, 13 }, /* #50 */
    { 0x263a82, 0x263213, 0x76df13e3, 0x0003b6f8, 0, 13 }, /* #50 b */
    { 0x277cc3, 0x277417, 0x298c1eff, 0x00298c1e, 0, 40 }, /* #51 */
    { 0x180316, 0x180317, 0x298c1eff, 0x00298c1e, 0, 40 }, /* #51 b */
    { 0x100156, 0x100196, 0x84474fd5, 0xffffff84, 0, 120 }, /* #52 */
    { 0x2f7e83, 0x2f7696, 0x84474fd5, 0xffffff84, 0, 120 }, /* #52 b */
    { 0x011a02, 0x011212, 0x2ef03d94, 0x00000bbc, 0, 114 }, /* #53 */
    { 0x3e65d7, 0x3e6512, 0x2ef03d94, 0x00000bbc, 0, 114 }, /* #53 b */
    { 0x2d34c3, 0x2d3497, 0x8ba301ea, 0xffffc5d1, 0, 113 }, /* #54 */
    { 0x124b16, 0x124397, 0x8ba301ea, 0xffffc5d1, 0, 113 }, /* #54 b */
    { 0x3248c2, 0x324016, 0x79e2a1f9, 0x00000f3c, 0, 115 }, /* #55 */
    { 0x0d3717, 0x0d3716, 0x79e2a1f9, 0x00000f3c, 0, 115 }, /* #55 b */
    { 0x3b3887, 0x3b3017, 0x1b067827, 0x0000d833, 0, 77 }, /* #56 */
    { 0x044752, 0x044717, 0x1b067827, 0x0000d833, 0, 77 }, /* #56 b */
    { 0x377cd6, 0x377496, 0x9982aeea, 0xffff3305, 0, 15 }, /* #57 */
    { 0x080303, 0x080396, 0x9982aeea, 0xffff3305, 0, 15 }, /* #57 b */
    { 0x0953d3, 0x095392, 0xba33f13f, 0xfffffff7, 0, 27 }, /* #58 */
    { 0x362c06, 0x362492, 0xba33f13f, 0xfffffff7, 0, 27 }, /* #58 b */
    { 0x214c13, 0x214497, 0xae1164a1, 0xfffffff5, 0, 123 }, /* #59 */
    { 0x1e33c6, 0x1e3397, 0xae1164a1, 0xfffffff5, 0, 123 }, /* #59 b */
    { 0x3c19c2, 0x3c1116, 0x5e9c7572, 0x00002f4e, 0, 17 }, /* #60 */
    { 0x036617, 0x036616, 0x5e9c7572, 0x00002f4e, 0, 17 }, /* #60 b */
    { 0x392e87, 0x392693, 0xdd276abd, 0xfffff749, 0, 18 }, /* #61 */
    { 0x065152, 0x065193, 0xdd276abd, 0xfffff749, 0, 18 }, /* #61 b */
    { 0x092412, 0x092496, 0xa59eb268, 0xffffff4b, 0, 119 }, /* #62 */
    { 0x365bc7, 0x365396, 0xa59eb268, 0xffffff4b, 0, 119 }, /* #62 b */
    { 0x1f6e52, 0x1f6612, 0x1883f213, 0x00000031, 0, 119 }, /* #63 */
    { 0x201187, 0x201112, 0x1883f213, 0x00000031, 0, 119 }, /* #63 b */
    { 0x2a3802, 0x2a3016, 0x2c981968, 0x00000059, 0, 55 }, /* #64 */
    { 0x1547d7, 0x154716, 0x2c981968, 0x00000059, 0, 55 }, /* #64 b */
    { 0x3f20c2, 0x3f2012, 0x490979e2, 0x0490979e, 0, 100 }, /* #65 */
    { 0x005f17, 0x005712, 0x490979e2, 0x0490979e, 0, 100 }, /* #65 b */
    { 0x105e57, 0x105613, 0x2f8e30a5, 0x0000000b, 0, 90 }, /* #66 */
    { 0x2f2182, 0x2f2113, 0x2f8e30a5, 0x0000000b, 0, 90 }, /* #66 b */
    { 0x3b2883, 0x3b2017, 0x5273d047, 0x00a4e7a0, 0, 71 }, /* #67 */
    { 0x045756, 0x045717, 0x5273d047, 0x00a4e7a0, 0, 71 }, /* #67 b */
    { 0x3e04d7, 0x3e0417, 0x44cd96e3, 0x000899b2, 0, 11 }, /* #68 */
    { 0x017b02, 0x017317, 0x44cd96e3, 0x000899b2, 0, 11 }, /* #68 b */
    { 0x1e3657, 0x1e3613, 0x338b7fff, 0x0019c5bf, 0, 73 }, /* #69 */
    { 0x214982, 0x214113, 0x338b7fff, 0x0019c5bf, 0, 73 }, /* #69 b */
    { 0x047a07, 0x047213, 0x717a6a32, 0x00000001, 0, 126 }, /* #70 */
    { 0x3b05d2, 0x3b0513, 0x717a6a32, 0x00000001, 0, 126 }, /* #70 b */
    { 0x1b69c2, 0x1b69c2, 0x7f3e6bdb, 0x7f3e6bdb, 0, 32 }, /* #71 */
    { 0x241617, 0x241617, 0x7f3e6bdb, 0x7f3e6bdb, 0, 32 }, /* #71 b */
    { 0x016b92, 0x016392, 0xe612f899, 0xfff3097c, 0, 41 }, /* #72 */
    { 0x3e1447, 0x3e1492, 0xe612f899, 0xfff3097c, 0, 41 }, /* #72 b */
    { 0x0167d6, 0x016712, 0x279b391a, 0x00000001, 0, 93 }, /* #73 */
    { 0x3e1803, 0x3e1012, 0x279b391a, 0x00000001, 0, 93 }, /* #73 b */
    { 0x341f47, 0x341757, 0x1bb0f166, 0x00000000, 0, 61 }, /* #74 */
    { 0x0b6092, 0x0b6057, 0x1bb0f166, 0x00000000, 0, 61 }, /* #74 b */
    { 0x2c53c6, 0x2c5356, 0x000398e0, 0x00000000, 0, 117 }, /* #75 */
    { 0x132c13, 0x132456, 0x000398e0, 0x00000000, 0, 117 }, /* #75 b */
    { 0x314153, 0x314113, 0x6641a41e, 0x00003320, 0, 49 }, /* #76 */
    { 0x0e3e86, 0x0e3613, 0x6641a41e, 0x00003320, 0, 49 }, /* #76 b */
    { 0x160817, 0x160097, 0xf6426606, 0xffffffff, 0, 62 }, /* #77 */
    { 0x2977c2, 0x297797, 0xf6426606, 0xffffffff, 0, 62 }, /* #77 b */
    { 0x060447, 0x060413, 0x321e2bcd, 0x0643c579, 0, 67 }, /* #78 */
    { 0x397b92, 0x397313, 0x321e2bcd, 0x0643c579, 0, 67 }, /* #78 b */
    { 0x347256, 0x347292, 0xc6c63edc, 0xfffffffe, 0, 125 }, /* #79 */
    { 0x0b0d83, 0x0b0592, 0xc6c63edc, 0xfffffffe, 0, 125 }, /* #79 b */
    { 0x2b2387, 0x2b2392, 0xe4a98034, 0xffff254c, 0, 13 }, /* #80 */
    { 0x145c52, 0x145492, 0xe4a98034, 0xffff254c, 0, 13 }, /* #80 b */
    { 0x132297, 0x132293, 0xd0c0a7e0, 0xffffffa1, 0, 55 }, /* #81 */
    { 0x2c5d42, 0x2c5593, 0xd0c0a7e0, 0xffffffa1, 0, 55 }, /* #81 b */
    { 0x1a6883, 0x1a6093, 0xf1e154d7, 0xffffffc7, 0, 86 }, /* #82 */
    { 0x251756, 0x251793, 0xf1e154d7, 0xffffffc7, 0, 86 }, /* #82 b */
    { 0x233a93, 0x233293, 0xd862f163, 0xffffffb0, 0, 23 }, /* #83 */
    { 0x1c4546, 0x1c4593, 0xd862f163, 0xffffffb0, 0, 23 }, /* #83 b */
    { 0x0c5b07, 0x0c5316, 0x663f5458, 0x00000033, 0, 89 }, /* #84 */
    { 0x3324d2, 0x332416, 0x663f5458, 0x00000033, 0, 89 }, /* #84 b */
    { 0x3d6253, 0x3d6292, 0x9083d677, 0xfff9083d, 0, 108 }, /* #85 */
    { 0x021d86, 0x021592, 0x9083d677, 0xfff9083d, 0, 108 }, /* #85 b */
    { 0x051853, 0x051017, 0x3fc028ee, 0x003fc028, 0, 72 }, /* #86 */
    { 0x3a6786, 0x3a6717, 0x3fc028ee, 0x003fc028, 0, 72 }, /* #86 b */
    { 0x2e4943, 0x2e4192, 0xc80c09ae, 0xffffff20, 0, 118 }, /* #87 */
    { 0x113696, 0x113692, 0xc80c09ae, 0xffffff20, 0, 118 }, /* #87 b */
    { 0x341f53, 0x341792, 0xca878641, 0xff2a1e19, 0, 102 }, /* #88 */
    { 0x0b6086, 0x0b6092, 0xca878641, 0xff2a1e19, 0, 102 }, /* #88 b */
    { 0x0039c3, 0x003117, 0x7f506023, 0x0001fd41, 0, 78 }, /* #89 */
    { 0x3f4616, 0x3f4617, 0x7f506023, 0x0001fd41, 0, 78 }, /* #89 b */
    { 0x087257, 0x087216, 0x7495242e, 0x0000001d, 0, 122 }, /* #90 */
    { 0x370d82, 0x370516, 0x7495242e, 0x0000001d, 0, 122 }, /* #90 b */
    { 0x382142, 0x382197, 0xcb57e25c, 0xfffffe5a, 0, 85 }, /* #91 */
    { 0x075e97, 0x075697, 0xcb57e25c, 0xfffffe5a, 0, 85 }, /* #91 b */
    { 0x2a6907, 0x2a6196, 0x81eae0b8, 0xf03d5c17, 0, 3  }, /* #92 */
    { 0x1516d2, 0x151696, 0x81eae0b8, 0xf03d5c17, 0, 3  }, /* #92 b */
    { 0x174ec2, 0x174697, 0xd40f04e6, 0xfffffa81, 0, 83 }, /* #93 */
    { 0x283117, 0x283197, 0xd40f04e6, 0xfffffa81, 0, 83 }, /* #93 b */
    { 0x272b53, 0x272393, 0xa797bb31, 0xffffffd3, 0, 25 }, /* #94 */
    { 0x185486, 0x185493, 0xa797bb31, 0xffffffd3, 0, 25 }, /* #94 b */
    { 0x162bc7, 0x162317, 0x3fb00bbf, 0x07f60177, 0, 67 }, /* #95 */
    { 0x295412, 0x295417, 0x3fb00bbf, 0x07f60177, 0, 67 }, /* #95 b */
};
uint32_t const g_cTests_sar_u32_amd = RT_ELEMENTS(g_aTests_sar_u32_amd);

BINU64_TEST_T const g_aTests_rol_u64_amd[] =
{
    { 0x2e6dc6, 0x2e65c6, 0x0000000000000000, 0x0000000000000000, 0, 166 }, /* #0 */
    { 0x111213, 0x111212, 0x0000000000000000, 0x0000000000000000, 0, 166 }, /* #0 b */
    { 0x0842c6, 0x0842c6, 0x0000000000000000, 0x0000000000000000, 0, 229 }, /* #1 */
    { 0x373d13, 0x373512, 0x0000000000000000, 0x0000000000000000, 0, 229 }, /* #1 b */
    { 0x075f82, 0x075782, 0x0000000000000000, 0x0000000000000000, 0, 84 }, /* #2 */
    { 0x382057, 0x382056, 0x0000000000000000, 0x0000000000000000, 0, 84 }, /* #2 b */
    { 0x0b6b93, 0x0b6392, 0x0000000000000000, 0x0000000000000000, 0, 17 }, /* #3 */
    { 0x341446, 0x341446, 0x0000000000000000, 0x0000000000000000, 0, 17 }, /* #3 b */
    { 0x170416, 0x170416, 0x0000000000000000, 0x0000000000000000, 0, 9  }, /* #4 */
    { 0x287bc3, 0x2873c2, 0x0000000000000000, 0x0000000000000000, 0, 9  }, /* #4 b */
    { 0x287353, 0x287352, 0x0000000000000000, 0x0000000000000000, 0, 237 }, /* #5 */
    { 0x170c86, 0x170486, 0x0000000000000000, 0x0000000000000000, 0, 237 }, /* #5 b */
    { 0x230682, 0x230682, 0x6645087343088c93, 0x6111926cc8a10e68, 0, 165 }, /* #6 */
    { 0x1c7957, 0x1c7156, 0x6645087343088c93, 0x6111926cc8a10e68, 0, 165 }, /* #6 b */
    { 0x113052, 0x113052, 0x9c952ff319511e31, 0x478c67254bfcc654, 0, 46 }, /* #7 */
    { 0x2e4f87, 0x2e4786, 0x9c952ff319511e31, 0x478c67254bfcc654, 0, 46 }, /* #7 b */
    { 0x332e56, 0x332656, 0xf0a4494532fad0d4, 0x1a9e148928a65f5a, 0, 245 }, /* #8 */
    { 0x0c5183, 0x0c5182, 0xf0a4494532fad0d4, 0x1a9e148928a65f5a, 0, 245 }, /* #8 b */
    { 0x160e06, 0x160607, 0x17ecb397347b7f74, 0xfb2ce5cd1edfdd05, 0, 198 }, /* #9 */
    { 0x2971d3, 0x2971d3, 0x17ecb397347b7f74, 0xfb2ce5cd1edfdd05, 0, 198 }, /* #9 b */
    { 0x246852, 0x246053, 0x7ffca322a3528a67, 0xbffe519151a94533, 0, 255 }, /* #10 */
    { 0x1b1787, 0x1b1787, 0x7ffca322a3528a67, 0xbffe519151a94533, 0, 255 }, /* #10 b */
    { 0x217316, 0x217b16, 0x3f7b56d2c8686bc5, 0xc8686bc53f7b56d2, 0, 96 }, /* #11 */
    { 0x1e0cc3, 0x1e0cc2, 0x3f7b56d2c8686bc5, 0xc8686bc53f7b56d2, 0, 96 }, /* #11 b */
    { 0x191757, 0x191756, 0x23404a519e531f9c, 0x11a02528cf298fce, 0, 191 }, /* #12 */
    { 0x266882, 0x266082, 0x23404a519e531f9c, 0x11a02528cf298fce, 0, 191 }, /* #12 b */
    { 0x207693, 0x207693, 0x1ed2814e1e530e57, 0xed2814e1e530e571, 0, 132 }, /* #13 */
    { 0x1f0946, 0x1f0147, 0x1ed2814e1e530e57, 0xed2814e1e530e571, 0, 132 }, /* #13 b */
    { 0x246a13, 0x246212, 0xcbc714d4303c6011, 0x78c023978e29a860, 0, 41 }, /* #14 */
    { 0x1b15c6, 0x1b15c6, 0xcbc714d4303c6011, 0x78c023978e29a860, 0, 41 }, /* #14 b */
    { 0x1259c2, 0x1259c2, 0xa848beef9a8d2447, 0xfbbe6a34911ea122, 0, 146 }, /* #15 */
    { 0x2d2617, 0x2d2e16, 0xa848beef9a8d2447, 0xfbbe6a34911ea122, 0, 146 }, /* #15 b */
    { 0x146902, 0x146902, 0xfc57786cc13bca31, 0x9de518fe2bbc3660, 0, 103 }, /* #16 */
    { 0x2b16d7, 0x2b1ed6, 0xfc57786cc13bca31, 0x9de518fe2bbc3660, 0, 103 }, /* #16 b */
    { 0x1842c2, 0x1842c3, 0x7807cdb5add9d467, 0xcdb5add9d4677807, 0, 208 }, /* #17 */
    { 0x273d17, 0x273517, 0x7807cdb5add9d467, 0xcdb5add9d4677807, 0, 208 }, /* #17 b */
    { 0x2069d6, 0x2069d6, 0x1b980544938c3b86, 0xdcc02a249c61dc30, 0, 131 }, /* #18 */
    { 0x1f1603, 0x1f1e02, 0x1b980544938c3b86, 0xdcc02a249c61dc30, 0, 131 }, /* #18 b */
    { 0x070c82, 0x070483, 0x8fadc31514ebf721, 0x862a29d7ee431f5b, 0, 145 }, /* #19 */
    { 0x387357, 0x387357, 0x8fadc31514ebf721, 0x862a29d7ee431f5b, 0, 145 }, /* #19 b */
    { 0x107c52, 0x107c53, 0x4c0b6d2099942122, 0x6da4133284244981, 0, 13 }, /* #20 */
    { 0x2f0387, 0x2f0b87, 0x4c0b6d2099942122, 0x6da4133284244981, 0, 13 }, /* #20 b */
    { 0x101142, 0x101143, 0xf0239dffadfada91, 0xf5bf5b523e0473bf, 0, 221 }, /* #21 */
    { 0x2f6e97, 0x2f6697, 0xf0239dffadfada91, 0xf5bf5b523e0473bf, 0, 221 }, /* #21 b */
    { 0x3d25d6, 0x3d25d6, 0xbff9a073e25ce200, 0x0e7c4b9c4017ff34, 0, 213 }, /* #22 */
    { 0x025a03, 0x025202, 0xbff9a073e25ce200, 0x0e7c4b9c4017ff34, 0, 213 }, /* #22 b */
    { 0x266117, 0x266117, 0xcf2050a3f4f24b18, 0xc92c633c81428fd3, 0, 234 }, /* #23 */
    { 0x191ec2, 0x1916c3, 0xcf2050a3f4f24b18, 0xc92c633c81428fd3, 0, 234 }, /* #23 b */
    { 0x1b4fd7, 0x1b47d7, 0xad685e6c549e6e7f, 0xeb5a179b15279b9f, 0, 190 }, /* #24 */
    { 0x243002, 0x243003, 0xad685e6c549e6e7f, 0xeb5a179b15279b9f, 0, 190 }, /* #24 b */
    { 0x2666c2, 0x2666c2, 0xa6bc1267fe6c08e5, 0x0933ff360472d35e, 0, 15 }, /* #25 */
    { 0x191917, 0x191116, 0xa6bc1267fe6c08e5, 0x0933ff360472d35e, 0, 15 }, /* #25 b */
    { 0x2a7f82, 0x2a7783, 0x564edadd56ae704d, 0xd56ae704d564edad, 0, 156 }, /* #26 */
    { 0x150057, 0x150057, 0x564edadd56ae704d, 0xd56ae704d564edad, 0, 156 }, /* #26 b */
    { 0x3f4d86, 0x3f4d86, 0xf5ae8d0e08ba2857, 0xe8a15fd6ba343822, 0, 170 }, /* #27 */
    { 0x003253, 0x003a52, 0xf5ae8d0e08ba2857, 0xe8a15fd6ba343822, 0, 170 }, /* #27 b */
    { 0x0b2053, 0x0b2852, 0x7cc4d223054ceab4, 0x91182a6755a3e626, 0, 211 }, /* #28 */
    { 0x345f86, 0x345f86, 0x7cc4d223054ceab4, 0x91182a6755a3e626, 0, 211 }, /* #28 b */
    { 0x112d92, 0x112d92, 0x1555c0a1ec1cc722, 0xae050f60e63910aa, 0, 203 }, /* #29 */
    { 0x2e5247, 0x2e5a46, 0x1555c0a1ec1cc722, 0xae050f60e63910aa, 0, 203 }, /* #29 b */
    { 0x2e5c46, 0x2e5c47, 0x5811b51186ae38c7, 0x6046d4461ab8e31d, 0, 66 }, /* #30 */
    { 0x112393, 0x112b93, 0x5811b51186ae38c7, 0x6046d4461ab8e31d, 0, 66 }, /* #30 b */
    { 0x3c6bc3, 0x3c63c3, 0x8ece183e9e5c8f74, 0xd3cb91ee91d9c307, 0, 221 }, /* #31 */
    { 0x031416, 0x031417, 0x8ece183e9e5c8f74, 0xd3cb91ee91d9c307, 0, 221 }, /* #31 b */
    { 0x340642, 0x340643, 0xaaedbc1394d9dbce, 0xd55db782729b3b79, 0, 61 }, /* #32 */
    { 0x0b7997, 0x0b7197, 0xaaedbc1394d9dbce, 0xd55db782729b3b79, 0, 61 }, /* #32 b */
    { 0x1d0a12, 0x1d0212, 0xa84bb6ac8041ed71, 0x4020f6b8d425db56, 0, 223 }, /* #33 */
    { 0x2275c7, 0x2275c6, 0xa84bb6ac8041ed71, 0x4020f6b8d425db56, 0, 223 }, /* #33 b */
    { 0x3e57c7, 0x3e57c6, 0x926b9724db1355e2, 0x49ae5c936c4d578a, 0, 194 }, /* #34 */
    { 0x012812, 0x012012, 0x926b9724db1355e2, 0x49ae5c936c4d578a, 0, 194 }, /* #34 b */
    { 0x365597, 0x365596, 0x7afdd05dafc243fd, 0x243fd7afdd05dafc, 0, 236 }, /* #35 */
    { 0x092a42, 0x092242, 0x7afdd05dafc243fd, 0x243fd7afdd05dafc, 0, 236 }, /* #35 b */
    { 0x262f13, 0x262712, 0x1237fe3008321da4, 0x321da41237fe3008, 0, 168 }, /* #36 */
    { 0x1950c6, 0x1950c6, 0x1237fe3008321da4, 0x321da41237fe3008, 0, 168 }, /* #36 b */
    { 0x1228d6, 0x1228d6, 0xbd6517f69252d9fb, 0xfddeb28bfb49296c, 0, 247 }, /* #37 */
    { 0x2d5703, 0x2d5f02, 0xbd6517f69252d9fb, 0xfddeb28bfb49296c, 0, 247 }, /* #37 b */
    { 0x102ed6, 0x102ed6, 0xd8cc1c01460882ef, 0xa3044177ec660e00, 0, 95 }, /* #38 */
    { 0x2f5103, 0x2f5902, 0xd8cc1c01460882ef, 0xa3044177ec660e00, 0, 95 }, /* #38 b */
    { 0x171b13, 0x171b12, 0x2d120012f4e133d5, 0x97a7099ea9689000, 0, 219 }, /* #39 */
    { 0x2864c6, 0x286cc6, 0x2d120012f4e133d5, 0x97a7099ea9689000, 0, 219 }, /* #39 b */
    { 0x2f53c7, 0x2f5bc7, 0x725ac2b8bb3a53e8, 0x29f4392d615c5d9d, 0, 175 }, /* #40 */
    { 0x102c12, 0x102c13, 0x725ac2b8bb3a53e8, 0x29f4392d615c5d9d, 0, 175 }, /* #40 b */
    { 0x293bd7, 0x2933d7, 0x148f71a131b2d830, 0xc684c6cb60c0523d, 0, 146 }, /* #41 */
    { 0x164402, 0x164403, 0x148f71a131b2d830, 0xc684c6cb60c0523d, 0, 146 }, /* #41 b */
    { 0x124a06, 0x124207, 0xb31f44b1778f9389, 0x98fa258bbc7c9c4d, 0, 131 }, /* #42 */
    { 0x2d35d3, 0x2d35d3, 0xb31f44b1778f9389, 0x98fa258bbc7c9c4d, 0, 131 }, /* #42 b */
    { 0x1a5a83, 0x1a5a82, 0xfa4b9152e92bcbb7, 0x92bcbb7fa4b9152e, 0, 100 }, /* #43 */
    { 0x252556, 0x252d56, 0xfa4b9152e92bcbb7, 0x92bcbb7fa4b9152e, 0, 100 }, /* #43 b */
    { 0x076583, 0x076d83, 0x1702335808ec61b3, 0x02335808ec61b317, 0, 8  }, /* #44 */
    { 0x381a56, 0x381a57, 0x1702335808ec61b3, 0x02335808ec61b317, 0, 8  }, /* #44 b */
    { 0x362c03, 0x362402, 0x45e49d15310326be, 0x49d15310326be45e, 0, 140 }, /* #45 */
    { 0x0953d6, 0x0953d6, 0x45e49d15310326be, 0x49d15310326be45e, 0, 140 }, /* #45 b */
    { 0x0e30c7, 0x0e38c6, 0xe0c6348a372603d7, 0x9146e4c07afc18c6, 0, 213 }, /* #46 */
    { 0x314f12, 0x314f12, 0xe0c6348a372603d7, 0x9146e4c07afc18c6, 0, 213 }, /* #46 b */
    { 0x2a5ad2, 0x2a5ad3, 0xa39541d6dab8f002, 0x5b6ae3c00a8e5507, 0, 218 }, /* #47 */
    { 0x152507, 0x152d07, 0xa39541d6dab8f002, 0x5b6ae3c00a8e5507, 0, 218 }, /* #47 b */
    { 0x3f2c97, 0x3f2c97, 0xee32cb619c9d9737, 0x2cb619c9d9737ee3, 0, 204 }, /* #48 */
    { 0x005342, 0x005b43, 0xee32cb619c9d9737, 0x2cb619c9d9737ee3, 0, 204 }, /* #48 b */
    { 0x3a3947, 0x3a3947, 0xb17467bc2dfdcc5e, 0x62e8cf785bfb98bd, 0, 1  }, /* #49 */
    { 0x054692, 0x054e93, 0xb17467bc2dfdcc5e, 0x62e8cf785bfb98bd, 0, 1  }, /* #49 b */
    { 0x3f1256, 0x3f1256, 0x58908727ae20835d, 0x421c9eb8820d7562, 0, 10 }, /* #50 */
    { 0x006d83, 0x006582, 0x58908727ae20835d, 0x421c9eb8820d7562, 0, 10 }, /* #50 b */
    { 0x033f87, 0x033f87, 0x7de33c58bcc16939, 0x305a4e5f78cf162f, 0, 38 }, /* #51 */
    { 0x3c4052, 0x3c4853, 0x7de33c58bcc16939, 0x305a4e5f78cf162f, 0, 38 }, /* #51 b */
    { 0x0b3ac3, 0x0b32c2, 0x84b686fd73d4824c, 0x499096d0dfae7a90, 0, 117 }, /* #52 */
    { 0x344516, 0x344516, 0x84b686fd73d4824c, 0x499096d0dfae7a90, 0, 117 }, /* #52 b */
    { 0x071a43, 0x071a42, 0xd950613ac3d51105, 0xc27587aa220bb2a0, 0, 209 }, /* #53 */
    { 0x386596, 0x386d96, 0xd950613ac3d51105, 0xc27587aa220bb2a0, 0, 209 }, /* #53 b */
    { 0x0315c3, 0x031dc3, 0x61e85e2ad95ce5a3, 0x5b2b9cb46c3d0bc5, 0, 157 }, /* #54 */
    { 0x3c6a16, 0x3c6a17, 0x61e85e2ad95ce5a3, 0x5b2b9cb46c3d0bc5, 0, 157 }, /* #54 b */
    { 0x1312c2, 0x1312c3, 0xf9233172373ccea6, 0xccea6f9233172373, 0, 172 }, /* #55 */
    { 0x2c6d17, 0x2c6517, 0xf9233172373ccea6, 0xccea6f9233172373, 0, 172 }, /* #55 b */
    { 0x256786, 0x256786, 0xe9e6384dd7b7e430, 0x6384dd7b7e430e9e, 0, 140 }, /* #56 */
    { 0x1a1853, 0x1a1052, 0xe9e6384dd7b7e430, 0x6384dd7b7e430e9e, 0, 140 }, /* #56 b */
    { 0x087712, 0x087f12, 0x1b6bf3c1610915a4, 0xd20db5f9e0b0848a, 0, 247 }, /* #57 */
    { 0x3708c7, 0x3708c6, 0x1b6bf3c1610915a4, 0xd20db5f9e0b0848a, 0, 247 }, /* #57 b */
    { 0x0b1647, 0x0b1647, 0x6d2bbd5f79f69ac7, 0x9f69ac76d2bbd5f7, 0, 36 }, /* #58 */
    { 0x346992, 0x346193, 0x6d2bbd5f79f69ac7, 0x9f69ac76d2bbd5f7, 0, 36 }, /* #58 b */
    { 0x2f5e02, 0x2f5e03, 0x87d4db59f4f03b89, 0x3c0ee261f536d67d, 0, 230 }, /* #59 */
    { 0x1021d7, 0x1029d7, 0x87d4db59f4f03b89, 0x3c0ee261f536d67d, 0, 230 }, /* #59 b */
    { 0x2d7d06, 0x2d7d07, 0x241335d089b37245, 0x7245241335d089b3, 0, 48 }, /* #60 */
    { 0x1202d3, 0x120ad3, 0x241335d089b37245, 0x7245241335d089b3, 0, 48 }, /* #60 b */
    { 0x251046, 0x251846, 0xce484f1acf6289da, 0x909e359ec513b59c, 0, 73 }, /* #61 */
    { 0x1a6f93, 0x1a6f92, 0xce484f1acf6289da, 0x909e359ec513b59c, 0, 73 }, /* #61 b */
    { 0x1b4cd7, 0x1b4cd7, 0x938129b7c6d13f08, 0x1b44fc224e04a6df, 0, 98 }, /* #62 */
    { 0x243302, 0x243b03, 0x938129b7c6d13f08, 0x1b44fc224e04a6df, 0, 98 }, /* #62 b */
    { 0x160542, 0x160542, 0x7e7a896cd1112c68, 0x3f3d44b668889634, 0, 127 }, /* #63 */
    { 0x297a97, 0x297296, 0x7e7a896cd1112c68, 0x3f3d44b668889634, 0, 127 }, /* #63 b */
    { 0x3d3956, 0x3d3957, 0x716b5a54bc8f8133, 0x33716b5a54bc8f81, 0, 248 }, /* #64 */
    { 0x024683, 0x024e83, 0x716b5a54bc8f8133, 0x33716b5a54bc8f81, 0, 248 }, /* #64 b */
    { 0x2a5013, 0x2a5813, 0x7d41d34bac6f4597, 0x4bac6f45977d41d3, 0, 88 }, /* #65 */
    { 0x152fc6, 0x152fc7, 0x7d41d34bac6f4597, 0x4bac6f45977d41d3, 0, 88 }, /* #65 b */
    { 0x172846, 0x172047, 0x60d3a6f33fa8c3df, 0x99fd461efb069d37, 0, 91 }, /* #66 */
    { 0x285793, 0x285793, 0x60d3a6f33fa8c3df, 0x99fd461efb069d37, 0, 91 }, /* #66 b */
    { 0x061e92, 0x061e92, 0x356a1decd816a01e, 0xd403c6ad43bd9b02, 0, 45 }, /* #67 */
    { 0x396147, 0x396946, 0x356a1decd816a01e, 0xd403c6ad43bd9b02, 0, 45 }, /* #67 b */
    { 0x276a46, 0x276247, 0x9286217e8f79ffc2, 0xff0a4a1885fa3de7, 0, 178 }, /* #68 */
    { 0x181593, 0x181593, 0x9286217e8f79ffc2, 0xff0a4a1885fa3de7, 0, 178 }, /* #68 b */
    { 0x1f5897, 0x1f5096, 0xb50a87ae96286147, 0x51ed42a1eba58a18, 0, 182 }, /* #69 */
    { 0x202742, 0x202742, 0xb50a87ae96286147, 0x51ed42a1eba58a18, 0, 182 }, /* #69 b */
    { 0x153dc3, 0x153dc3, 0x247035f5ee8becee, 0x2381afaf745f6771, 0, 131 }, /* #70 */
    { 0x2a4216, 0x2a4a17, 0x247035f5ee8becee, 0x2381afaf745f6771, 0, 131 }, /* #70 b */
    { 0x3550c7, 0x3558c7, 0x35dfb8c75509cac6, 0x77ee31d54272b18d, 0, 70 }, /* #71 */
    { 0x0a2f12, 0x0a2f13, 0x35dfb8c75509cac6, 0x77ee31d54272b18d, 0, 70 }, /* #71 b */
    { 0x1548c2, 0x1540c3, 0x8420bdef0a1b444b, 0xbc286d112e1082f7, 0, 218 }, /* #72 */
    { 0x2a3717, 0x2a3717, 0x8420bdef0a1b444b, 0xbc286d112e1082f7, 0, 218 }, /* #72 b */
    { 0x1b11d3, 0x1b11d3, 0x8580900c18b0e4d9, 0xb30b0120183161c9, 0, 121 }, /* #73 */
    { 0x246e06, 0x246607, 0x8580900c18b0e4d9, 0xb30b0120183161c9, 0, 121 }, /* #73 b */
    { 0x163817, 0x163016, 0xd995057a9e34c1a4, 0x349b32a0af53c698, 0, 181 }, /* #74 */
    { 0x2947c2, 0x2947c2, 0xd995057a9e34c1a4, 0x349b32a0af53c698, 0, 181 }, /* #74 b */
    { 0x213d56, 0x213d56, 0x3db253a7cc8a161f, 0xe9f3228587cf6c94, 0, 150 }, /* #75 */
    { 0x1e4283, 0x1e4a82, 0x3db253a7cc8a161f, 0xe9f3228587cf6c94, 0, 150 }, /* #75 b */
    { 0x0c2312, 0x0c2b12, 0x128c9f55b75c6390, 0xe404a327d56dd718, 0, 246 }, /* #76 */
    { 0x335cc7, 0x335cc6, 0x128c9f55b75c6390, 0xe404a327d56dd718, 0, 246 }, /* #76 b */
    { 0x396096, 0x396096, 0x942514c1c80740a5, 0x5942514c1c80740a, 0, 60 }, /* #77 */
    { 0x061f43, 0x061742, 0x942514c1c80740a5, 0x5942514c1c80740a, 0, 60 }, /* #77 b */
    { 0x181d86, 0x181d86, 0xbac0bf6ac28ffb61, 0xac28ffb61bac0bf6, 0, 28 }, /* #78 */
    { 0x276253, 0x276a52, 0xbac0bf6ac28ffb61, 0xac28ffb61bac0bf6, 0, 28 }, /* #78 b */
    { 0x134157, 0x134957, 0xeb660d4afed75659, 0x660d4afed75659eb, 0, 136 }, /* #79 */
    { 0x2c3e82, 0x2c3e83, 0xeb660d4afed75659, 0x660d4afed75659eb, 0, 136 }, /* #79 b */
    { 0x262ac7, 0x2622c7, 0xa4974698fb1fcc33, 0xfcc33a4974698fb1, 0, 236 }, /* #80 */
    { 0x195512, 0x195513, 0xa4974698fb1fcc33, 0xfcc33a4974698fb1, 0, 236 }, /* #80 b */
    { 0x080b86, 0x080b86, 0x0261025179f6ed7a, 0x8128bcfb76bd0130, 0, 15 }, /* #81 */
    { 0x377453, 0x377c52, 0x0261025179f6ed7a, 0x8128bcfb76bd0130, 0, 15 }, /* #81 b */
    { 0x1f23d3, 0x1f2bd2, 0x2e627fbd3b7c8e4d, 0xf91c9a5cc4ff7a76, 0, 233 }, /* #82 */
    { 0x205c06, 0x205c06, 0x2e627fbd3b7c8e4d, 0xf91c9a5cc4ff7a76, 0, 233 }, /* #82 b */
    { 0x2e2246, 0x2e2246, 0xcf6794aac2d488e5, 0x794aac2d488e5cf6, 0, 204 }, /* #83 */
    { 0x115d93, 0x115592, 0xcf6794aac2d488e5, 0x794aac2d488e5cf6, 0, 204 }, /* #83 b */
    { 0x1432c3, 0x1432c2, 0xc29e070b89391530, 0x29e070b89391530c, 0, 132 }, /* #84 */
    { 0x2b4d16, 0x2b4516, 0xc29e070b89391530, 0x29e070b89391530c, 0, 132 }, /* #84 b */
    { 0x274186, 0x274187, 0xd03bfab40f86a312, 0xd5a07c35189681df, 0, 147 }, /* #85 */
    { 0x183e53, 0x183653, 0xd03bfab40f86a312, 0xd5a07c35189681df, 0, 147 }, /* #85 b */
    { 0x091403, 0x091c03, 0xa7a83b92029490b4, 0x724052921694f507, 0, 149 }, /* #86 */
    { 0x366bd6, 0x366bd7, 0xa7a83b92029490b4, 0x724052921694f507, 0, 149 }, /* #86 b */
    { 0x220f42, 0x220742, 0xa8cef09bd8f5ab82, 0x7784dec7ad5c1546, 0, 11 }, /* #87 */
    { 0x1d7097, 0x1d7096, 0xa8cef09bd8f5ab82, 0x7784dec7ad5c1546, 0, 11 }, /* #87 b */
    { 0x034ac3, 0x034ac3, 0xb3893af5deb4dace, 0x671275ebbd69b59d, 0, 65 }, /* #88 */
    { 0x3c3516, 0x3c3d17, 0xb3893af5deb4dace, 0x671275ebbd69b59d, 0, 65 }, /* #88 b */
    { 0x216b07, 0x216307, 0x7d2eff27ec233bdc, 0xfc9fb08cef71f4bb, 0, 210 }, /* #89 */
    { 0x1e14d2, 0x1e14d3, 0x7d2eff27ec233bdc, 0xfc9fb08cef71f4bb, 0, 210 }, /* #89 b */
    { 0x335053, 0x335853, 0x964e8649e360873c, 0x4324f1b0439e4b27, 0, 15 }, /* #90 */
    { 0x0c2f86, 0x0c2f87, 0x964e8649e360873c, 0x4324f1b0439e4b27, 0, 15 }, /* #90 b */
    { 0x0e1b12, 0x0e1312, 0x9d0595fbd9d2c6fb, 0x37dce82cafdece96, 0, 115 }, /* #91 */
    { 0x3164c7, 0x3164c6, 0x9d0595fbd9d2c6fb, 0x37dce82cafdece96, 0, 115 }, /* #91 b */
    { 0x0b7216, 0x0b7217, 0x191379e1373771d9, 0xb9bb8ec8c89bcf09, 0, 163 }, /* #92 */
    { 0x340dc3, 0x3405c3, 0x191379e1373771d9, 0xb9bb8ec8c89bcf09, 0, 163 }, /* #92 b */
    { 0x151e02, 0x151602, 0x787dd610ea2f12d6, 0x5e25acf0fbac21d4, 0, 105 }, /* #93 */
    { 0x2a61d7, 0x2a61d6, 0x787dd610ea2f12d6, 0x5e25acf0fbac21d4, 0, 105 }, /* #93 b */
    { 0x046c17, 0x046c17, 0x7b14ef01bde6caee, 0x14ef01bde6caee7b, 0, 200 }, /* #94 */
    { 0x3b13c2, 0x3b1bc3, 0x7b14ef01bde6caee, 0x14ef01bde6caee7b, 0, 200 }, /* #94 b */
    { 0x215756, 0x215f56, 0x9acbd5c33c0a953c, 0xa9e4d65eae19e054, 0, 243 }, /* #95 */
    { 0x1e2883, 0x1e2882, 0x9acbd5c33c0a953c, 0xa9e4d65eae19e054, 0, 243 }, /* #95 b */
};
uint32_t const g_cTests_rol_u64_amd = RT_ELEMENTS(g_aTests_rol_u64_amd);

BINU64_TEST_T const g_aTests_ror_u64_amd[] =
{
    { 0x1a3e43, 0x1a3642, 0x0000000000000000, 0x0000000000000000, 0, 56 }, /* #0 */
    { 0x254196, 0x254196, 0x0000000000000000, 0x0000000000000000, 0, 56 }, /* #0 b */
    { 0x1f7982, 0x1f7182, 0x0000000000000000, 0x0000000000000000, 0, 8  }, /* #1 */
    { 0x200657, 0x200656, 0x0000000000000000, 0x0000000000000000, 0, 8  }, /* #1 b */
    { 0x371457, 0x371456, 0x0000000000000000, 0x0000000000000000, 0, 106 }, /* #2 */
    { 0x086b82, 0x086382, 0x0000000000000000, 0x0000000000000000, 0, 106 }, /* #2 b */
    { 0x2158d7, 0x2150d6, 0x0000000000000000, 0x0000000000000000, 0, 132 }, /* #3 */
    { 0x1e2702, 0x1e2702, 0x0000000000000000, 0x0000000000000000, 0, 132 }, /* #3 b */
    { 0x1e2e52, 0x1e2652, 0x0000000000000000, 0x0000000000000000, 0, 151 }, /* #4 */
    { 0x215187, 0x215186, 0x0000000000000000, 0x0000000000000000, 0, 151 }, /* #4 b */
    { 0x264a12, 0x264212, 0x0000000000000000, 0x0000000000000000, 0, 164 }, /* #5 */
    { 0x1935c7, 0x1935c6, 0x0000000000000000, 0x0000000000000000, 0, 164 }, /* #5 b */
    { 0x012fd2, 0x0127d3, 0xfdcdd5ffe3bfb046, 0xc77f608dfb9babff, 0, 223 }, /* #6 */
    { 0x3e5007, 0x3e5007, 0xfdcdd5ffe3bfb046, 0xc77f608dfb9babff, 0, 223 }, /* #6 b */
    { 0x3803d6, 0x380bd7, 0xbb552b5516cb45d3, 0xa95aa8b65a2e9dda, 0, 181 }, /* #7 */
    { 0x077c03, 0x077c03, 0xbb552b5516cb45d3, 0xa95aa8b65a2e9dda, 0, 181 }, /* #7 b */
    { 0x061d97, 0x061d96, 0xd7ab21bcfb42b1dc, 0x68563b9af564379f, 0, 155 }, /* #8 */
    { 0x396242, 0x396a42, 0xd7ab21bcfb42b1dc, 0x68563b9af564379f, 0, 155 }, /* #8 b */
    { 0x2f7886, 0x2f7886, 0xc1c9e4742a5c0eb6, 0x703adb072791d0a9, 0, 150 }, /* #9 */
    { 0x100753, 0x100f52, 0xc1c9e4742a5c0eb6, 0x703adb072791d0a9, 0, 150 }, /* #9 b */
    { 0x061417, 0x061417, 0x10aaee35f9e692b9, 0xf3cd25722155dc6b, 0, 31 }, /* #10 */
    { 0x396bc2, 0x3963c3, 0x10aaee35f9e692b9, 0xf3cd25722155dc6b, 0, 31 }, /* #10 b */
    { 0x210516, 0x210516, 0x345397eced6aa477, 0x1dcd14e5fb3b5aa9, 0, 202 }, /* #11 */
    { 0x1e7ac3, 0x1e72c2, 0x345397eced6aa477, 0x1dcd14e5fb3b5aa9, 0, 202 }, /* #11 b */
    { 0x070403, 0x070c02, 0x741995923ab1e0bc, 0x665648eac782f1d0, 0, 246 }, /* #12 */
    { 0x387bd6, 0x387bd6, 0x741995923ab1e0bc, 0x665648eac782f1d0, 0, 246 }, /* #12 b */
    { 0x1f47c2, 0x1f4fc3, 0xeb54aadbace9d3de, 0xa74f7bad52ab6eb3, 0, 22 }, /* #13 */
    { 0x203817, 0x203817, 0xeb54aadbace9d3de, 0xa74f7bad52ab6eb3, 0, 22 }, /* #13 b */
    { 0x2f1102, 0x2f1103, 0x129cf33100daa557, 0xc4a73ccc4036a955, 0, 130 }, /* #14 */
    { 0x106ed7, 0x1066d7, 0x129cf33100daa557, 0xc4a73ccc4036a955, 0, 130 }, /* #14 b */
    { 0x025057, 0x025857, 0x7d54a3f040867c74, 0x867c747d54a3f040, 0, 216 }, /* #15 */
    { 0x3d2f82, 0x3d2f83, 0x7d54a3f040867c74, 0x867c747d54a3f040, 0, 216 }, /* #15 b */
    { 0x2f0c86, 0x2f0c86, 0x09bdc542ea2789a5, 0x4d284dee2a17513c, 0, 13 }, /* #16 */
    { 0x107353, 0x107b52, 0x09bdc542ea2789a5, 0x4d284dee2a17513c, 0, 13 }, /* #16 b */
    { 0x0b2d86, 0x0b2587, 0xe932f2eb6e83397b, 0xfa4cbcbadba0ce5e, 0, 66 }, /* #17 */
    { 0x345253, 0x345253, 0xe932f2eb6e83397b, 0xfa4cbcbadba0ce5e, 0, 66 }, /* #17 b */
    { 0x085d17, 0x085516, 0x5425c0abbcdff849, 0x2e055de6ffc24aa1, 0, 181 }, /* #18 */
    { 0x3722c2, 0x3722c2, 0x5425c0abbcdff849, 0x2e055de6ffc24aa1, 0, 181 }, /* #18 b */
    { 0x342cc6, 0x3424c6, 0x70b8c0bd8b45450e, 0x0e70b8c0bd8b4545, 0, 72 }, /* #19 */
    { 0x0b5313, 0x0b5312, 0x70b8c0bd8b45450e, 0x0e70b8c0bd8b4545, 0, 72 }, /* #19 b */
    { 0x3e6756, 0x3e6f57, 0xd5521c397a05d6b1, 0x870e5e8175ac7554, 0, 242 }, /* #20 */
    { 0x011883, 0x011883, 0xd5521c397a05d6b1, 0x870e5e8175ac7554, 0, 242 }, /* #20 b */
    { 0x100bc3, 0x1003c2, 0x5e3a305b4ac73c17, 0x182da5639e0baf1d, 0, 177 }, /* #21 */
    { 0x2f7416, 0x2f7416, 0x5e3a305b4ac73c17, 0x182da5639e0baf1d, 0, 177 }, /* #21 b */
    { 0x331e43, 0x331643, 0x91bc1e44e95ed814, 0xc1e44e95ed81491b, 0, 116 }, /* #22 */
    { 0x0c6196, 0x0c6197, 0x91bc1e44e95ed814, 0xc1e44e95ed81491b, 0, 116 }, /* #22 b */
    { 0x211853, 0x211052, 0x507e7a91dccde13d, 0x13d507e7a91dccde, 0, 12 }, /* #23 */
    { 0x1e6786, 0x1e6786, 0x507e7a91dccde13d, 0x13d507e7a91dccde, 0, 12 }, /* #23 b */
    { 0x3726c2, 0x372ec3, 0xec948bbeffacd7ee, 0xafddd929177dff59, 0, 207 }, /* #24 */
    { 0x085917, 0x085917, 0xec948bbeffacd7ee, 0xafddd929177dff59, 0, 207 }, /* #24 b */
    { 0x314816, 0x314816, 0x34b432c85e4f7d6f, 0x34b432c85e4f7d6f, 0, 128 }, /* #25 */
    { 0x0e37c3, 0x0e37c3, 0x34b432c85e4f7d6f, 0x34b432c85e4f7d6f, 0, 128 }, /* #25 b */
    { 0x035a02, 0x035a02, 0xa785e7a433a8326a, 0x4193553c2f3d219d, 0, 21 }, /* #26 */
    { 0x3c25d7, 0x3c2dd6, 0xa785e7a433a8326a, 0x4193553c2f3d219d, 0, 21 }, /* #26 b */
    { 0x0039c3, 0x0031c3, 0xe8213604a142cb0e, 0xee8213604a142cb0, 0, 4  }, /* #27 */
    { 0x3f4616, 0x3f4617, 0xe8213604a142cb0e, 0xee8213604a142cb0, 0, 4  }, /* #27 b */
    { 0x0b2fd6, 0x0b27d6, 0xac9161fd7ffbcdff, 0x24587f5ffef37feb, 0, 186 }, /* #28 */
    { 0x345003, 0x345002, 0xac9161fd7ffbcdff, 0x24587f5ffef37feb, 0, 186 }, /* #28 b */
    { 0x167252, 0x167253, 0x6c1e5fce32f5df68, 0xd77da1b0797f38cb, 0, 214 }, /* #29 */
    { 0x290d87, 0x290587, 0x6c1e5fce32f5df68, 0xd77da1b0797f38cb, 0, 214 }, /* #29 b */
    { 0x391d53, 0x391553, 0x03b6106fdc118ae6, 0xfb82315cc076c20d, 0, 35 }, /* #30 */
    { 0x066286, 0x066287, 0x03b6106fdc118ae6, 0xfb82315cc076c20d, 0, 35 }, /* #30 b */
    { 0x103416, 0x103416, 0xc82d2b8b8ae13825, 0x2b84e09720b4ae2e, 0, 222 }, /* #31 */
    { 0x2f4bc3, 0x2f43c2, 0xc82d2b8b8ae13825, 0x2b84e09720b4ae2e, 0, 222 }, /* #31 b */
    { 0x285097, 0x285096, 0xf706a5bb407ab12f, 0x1a96ed01eac4bfdc, 0, 54 }, /* #32 */
    { 0x172f42, 0x172742, 0xf706a5bb407ab12f, 0x1a96ed01eac4bfdc, 0, 54 }, /* #32 b */
    { 0x1d5016, 0x1d5017, 0x3b4fcc679e3d119e, 0xcc679e3d119e3b4f, 0, 112 }, /* #33 */
    { 0x222fc3, 0x2227c3, 0x3b4fcc679e3d119e, 0xcc679e3d119e3b4f, 0, 112 }, /* #33 b */
    { 0x011e96, 0x011696, 0xcc0df014fec74337, 0x037c053fb1d0cdf3, 0, 58 }, /* #34 */
    { 0x3e6143, 0x3e6142, 0xcc0df014fec74337, 0x037c053fb1d0cdf3, 0, 58 }, /* #34 b */
    { 0x117592, 0x117d93, 0x2d35b0ebbc85b137, 0xb1372d35b0ebbc85, 0, 80 }, /* #35 */
    { 0x2e0a47, 0x2e0a47, 0x2d35b0ebbc85b137, 0xb1372d35b0ebbc85, 0, 80 }, /* #35 b */
    { 0x304946, 0x304147, 0x7557d705cfe2d620, 0xf5c173f8b5881d55, 0, 114 }, /* #36 */
    { 0x0f3693, 0x0f3693, 0x7557d705cfe2d620, 0xf5c173f8b5881d55, 0, 114 }, /* #36 b */
    { 0x056d53, 0x056d52, 0x5bc901a07cd8499d, 0x7cd8499d5bc901a0, 0, 160 }, /* #37 */
    { 0x3a1286, 0x3a1a86, 0x5bc901a07cd8499d, 0x7cd8499d5bc901a0, 0, 160 }, /* #37 b */
    { 0x006886, 0x006087, 0x6dec25dc58d880bd, 0xe2c6c405eb6f612e, 0, 229 }, /* #38 */
    { 0x3f1753, 0x3f1753, 0x6dec25dc58d880bd, 0xe2c6c405eb6f612e, 0, 229 }, /* #38 b */
    { 0x007a46, 0x007247, 0xe97b019ff9eebfef, 0xd7fdfd2f6033ff3d, 0, 211 }, /* #39 */
    { 0x3f0593, 0x3f0593, 0xe97b019ff9eebfef, 0xd7fdfd2f6033ff3d, 0, 211 }, /* #39 b */
    { 0x347716, 0x347f17, 0x6e0da6c866b7d14b, 0xb219adf452db8369, 0, 234 }, /* #40 */
    { 0x0b08c3, 0x0b08c3, 0x6e0da6c866b7d14b, 0xb219adf452db8369, 0, 234 }, /* #40 b */
    { 0x0d3883, 0x0d3083, 0x5ff0962601c0e8c0, 0xc4c0381d180bfe12, 0, 43 }, /* #41 */
    { 0x324756, 0x324757, 0x5ff0962601c0e8c0, 0xc4c0381d180bfe12, 0, 43 }, /* #41 b */
    { 0x397d52, 0x397553, 0x59cba0f458069b82, 0xe8b00d3704b39741, 0, 103 }, /* #42 */
    { 0x060287, 0x060287, 0x59cba0f458069b82, 0xe8b00d3704b39741, 0, 103 }, /* #42 b */
    { 0x066e06, 0x066e07, 0x674c995bcfa91b80, 0xa91b80674c995bcf, 0, 88 }, /* #43 */
    { 0x3911d3, 0x3919d3, 0x674c995bcfa91b80, 0xa91b80674c995bcf, 0, 88 }, /* #43 b */
    { 0x037352, 0x037b53, 0x84793e8d1511d029, 0x88e814c23c9f468a, 0, 25 }, /* #44 */
    { 0x3c0c87, 0x3c0c87, 0x84793e8d1511d029, 0x88e814c23c9f468a, 0, 25 }, /* #44 b */
    { 0x2f16c3, 0x2f1ec2, 0x35eba96ecb54f23d, 0x5bb2d53c8f4d7aea, 0, 106 }, /* #45 */
    { 0x106916, 0x106916, 0x35eba96ecb54f23d, 0x5bb2d53c8f4d7aea, 0, 106 }, /* #45 b */
    { 0x092087, 0x092087, 0x341c012f90f8a50d, 0xf21f14a1a6838025, 0, 99 }, /* #46 */
    { 0x365f52, 0x365753, 0x341c012f90f8a50d, 0xf21f14a1a6838025, 0, 99 }, /* #46 b */
    { 0x067a17, 0x067216, 0x0cd350ec70c7cacc, 0x18f959819a6a1d8e, 0, 91 }, /* #47 */
    { 0x3905c2, 0x3905c2, 0x0cd350ec70c7cacc, 0x18f959819a6a1d8e, 0, 91 }, /* #47 b */
    { 0x2724d7, 0x272cd7, 0x948ec1802c3ee299, 0xb0fb8a66523b0600, 0, 222 }, /* #48 */
    { 0x185b02, 0x185b03, 0x948ec1802c3ee299, 0xb0fb8a66523b0600, 0, 222 }, /* #48 b */
    { 0x1a0743, 0x1a0f43, 0x86c60895a9686ce8, 0x895a9686ce886c60, 0, 172 }, /* #49 */
    { 0x257896, 0x257897, 0x86c60895a9686ce8, 0x895a9686ce886c60, 0, 172 }, /* #49 b */
    { 0x116d86, 0x116587, 0x3b58b5021342a102, 0xed62d4084d0a8408, 0, 190 }, /* #50 */
    { 0x2e1253, 0x2e1253, 0x3b58b5021342a102, 0xed62d4084d0a8408, 0, 190 }, /* #50 b */
    { 0x3f4506, 0x3f4d06, 0xeeabed6cb914776a, 0x57dad97228eed5dd, 0, 55 }, /* #51 */
    { 0x003ad3, 0x003ad2, 0xeeabed6cb914776a, 0x57dad97228eed5dd, 0, 55 }, /* #51 b */
    { 0x3b32c2, 0x3b32c3, 0xf6a91774bf7474ef, 0xeff6a91774bf7474, 0, 136 }, /* #52 */
    { 0x044d17, 0x044517, 0xf6a91774bf7474ef, 0xeff6a91774bf7474, 0, 136 }, /* #52 b */
    { 0x131853, 0x131853, 0x3847be0aceabe8e7, 0x8f7c159d57d1ce70, 0, 55 }, /* #53 */
    { 0x2c6786, 0x2c6f87, 0x3847be0aceabe8e7, 0x8f7c159d57d1ce70, 0, 55 }, /* #53 b */
    { 0x067282, 0x067282, 0x70ea48a11c873600, 0x24508e439b003875, 0, 241 }, /* #54 */
    { 0x390d57, 0x390556, 0x70ea48a11c873600, 0x24508e439b003875, 0, 241 }, /* #54 b */
    { 0x331e57, 0x331e57, 0x09765559bfcc7a60, 0xacdfe63d3004bb2a, 0, 233 }, /* #55 */
    { 0x0c6182, 0x0c6983, 0x09765559bfcc7a60, 0xacdfe63d3004bb2a, 0, 233 }, /* #55 b */
    { 0x212386, 0x212386, 0xdfae2d81f06b7868, 0x07c1ade1a37eb8b6, 0, 102 }, /* #56 */
    { 0x1e5c53, 0x1e5452, 0xdfae2d81f06b7868, 0x07c1ade1a37eb8b6, 0, 102 }, /* #56 b */
    { 0x085bc3, 0x0853c3, 0x238c28c7d1723f17, 0xf17238c28c7d1723, 0, 12 }, /* #57 */
    { 0x372416, 0x372417, 0x238c28c7d1723f17, 0xf17238c28c7d1723, 0, 12 }, /* #57 b */
    { 0x367d02, 0x367d03, 0xe1e8ceb22e5165a7, 0x8b2d3f0f46759172, 0, 85 }, /* #58 */
    { 0x0902d7, 0x090ad7, 0xe1e8ceb22e5165a7, 0x8b2d3f0f46759172, 0, 85 }, /* #58 b */
    { 0x2b6197, 0x2b6196, 0x1ea43b5fb46fe6f6, 0x3b5fb46fe6f61ea4, 0, 176 }, /* #59 */
    { 0x141e42, 0x141642, 0x1ea43b5fb46fe6f6, 0x3b5fb46fe6f61ea4, 0, 176 }, /* #59 b */
    { 0x013a82, 0x013a82, 0x87f2f3a2f92a4c3b, 0x5261dc3f979d17c9, 0, 149 }, /* #60 */
    { 0x3e4557, 0x3e4d56, 0x87f2f3a2f92a4c3b, 0x5261dc3f979d17c9, 0, 149 }, /* #60 b */
    { 0x0c5947, 0x0c5147, 0x07d16b5c17ccd18c, 0xf3346301f45ad705, 0, 218 }, /* #61 */
    { 0x332692, 0x332693, 0x07d16b5c17ccd18c, 0xf3346301f45ad705, 0, 218 }, /* #61 b */
    { 0x134a13, 0x134a13, 0x0ef66ee2ba6066b2, 0xbb8ae9819ac83bd9, 0, 238 }, /* #62 */
    { 0x2c35c6, 0x2c3dc7, 0x0ef66ee2ba6066b2, 0xbb8ae9819ac83bd9, 0, 238 }, /* #62 b */
    { 0x2c0cd6, 0x2c0cd6, 0xffa2234cc09bf7af, 0x4446998137ef5fff, 0, 55 }, /* #63 */
    { 0x137303, 0x137b02, 0xffa2234cc09bf7af, 0x4446998137ef5fff, 0, 55 }, /* #63 b */
    { 0x093757, 0x093f57, 0xd42cd3c8cb8fe5a1, 0x8cb8fe5a1d42cd3c, 0, 164 }, /* #64 */
    { 0x364882, 0x364883, 0xd42cd3c8cb8fe5a1, 0x8cb8fe5a1d42cd3c, 0, 164 }, /* #64 b */
    { 0x312b57, 0x312356, 0x5c4b7e2a5bdc4d20, 0x152dee26902e25bf, 0, 233 }, /* #65 */
    { 0x0e5482, 0x0e5482, 0x5c4b7e2a5bdc4d20, 0x152dee26902e25bf, 0, 233 }, /* #65 b */
    { 0x3c1487, 0x3c1c87, 0x72f8e57f3a29625d, 0xb12eb97c72bf9d14, 0, 209 }, /* #66 */
    { 0x036b52, 0x036b53, 0x72f8e57f3a29625d, 0xb12eb97c72bf9d14, 0, 209 }, /* #66 b */
    { 0x185c47, 0x185c46, 0x35023586051e01b5, 0x47806d4d408d6181, 0, 154 }, /* #67 */
    { 0x272392, 0x272b92, 0x35023586051e01b5, 0x47806d4d408d6181, 0, 154 }, /* #67 b */
    { 0x313dd3, 0x313dd2, 0x58ed0a66d5ad1f78, 0x47de163b4299b56b, 0, 82 }, /* #68 */
    { 0x0e4206, 0x0e4a06, 0x58ed0a66d5ad1f78, 0x47de163b4299b56b, 0, 82 }, /* #68 b */
    { 0x0d3f12, 0x0d3f12, 0x74ed270125a9e4d0, 0x4d074ed270125a9e, 0, 204 }, /* #69 */
    { 0x3240c7, 0x3248c6, 0x74ed270125a9e4d0, 0x4d074ed270125a9e, 0, 204 }, /* #69 b */
    { 0x242b87, 0x242b86, 0xb2b7c4379cef8ba0, 0x79cef8ba0b2b7c43, 0, 228 }, /* #70 */
    { 0x1b5452, 0x1b5c52, 0xb2b7c4379cef8ba0, 0x79cef8ba0b2b7c43, 0, 228 }, /* #70 b */
    { 0x1a08c6, 0x1a00c7, 0xb77ec69c7f3de0ff, 0xdfb1a71fcf783fed, 0, 58 }, /* #71 */
    { 0x257713, 0x257713, 0xb77ec69c7f3de0ff, 0xdfb1a71fcf783fed, 0, 58 }, /* #71 b */
    { 0x0d0b13, 0x0d0b13, 0x1fc746d229dbd621, 0xa76f58847f1d1b48, 0, 30 }, /* #72 */
    { 0x3274c6, 0x327cc7, 0x1fc746d229dbd621, 0xa76f58847f1d1b48, 0, 30 }, /* #72 b */
    { 0x0a75d3, 0x0a75d3, 0x206b3b6fbbfd055d, 0xdfe82ae90359db7d, 0, 221 }, /* #73 */
    { 0x350a06, 0x350207, 0x206b3b6fbbfd055d, 0xdfe82ae90359db7d, 0, 221 }, /* #73 b */
    { 0x226092, 0x226092, 0xf014ebf0ec07bd2d, 0x0a75f87603de96f8, 0, 57 }, /* #74 */
    { 0x1d1f47, 0x1d1746, 0xf014ebf0ec07bd2d, 0x0a75f87603de96f8, 0, 57 }, /* #74 b */
    { 0x191386, 0x191b86, 0xa53b7270dd25ee3b, 0x70dd25ee3ba53b72, 0, 40 }, /* #75 */
    { 0x266c53, 0x266c52, 0xa53b7270dd25ee3b, 0x70dd25ee3ba53b72, 0, 40 }, /* #75 b */
    { 0x295a46, 0x295246, 0xff619fd46a794408, 0x1023fd867f51a9e5, 0, 206 }, /* #76 */
    { 0x162593, 0x162592, 0xff619fd46a794408, 0x1023fd867f51a9e5, 0, 206 }, /* #76 b */
    { 0x2b46d7, 0x2b4ed7, 0xc22c30ce9f780b46, 0x8458619d3ef0168d, 0, 127 }, /* #77 */
    { 0x143902, 0x143903, 0xc22c30ce9f780b46, 0x8458619d3ef0168d, 0, 127 }, /* #77 b */
    { 0x2546c3, 0x2546c2, 0x9c2ec29bed260955, 0x04aace17614df693, 0, 145 }, /* #78 */
    { 0x1a3916, 0x1a3116, 0x9c2ec29bed260955, 0x04aace17614df693, 0, 145 }, /* #78 b */
    { 0x235546, 0x235d47, 0x934f3e69207b9c40, 0xa481ee71024d3cf9, 0, 102 }, /* #79 */
    { 0x1c2a93, 0x1c2a93, 0x934f3e69207b9c40, 0xa481ee71024d3cf9, 0, 102 }, /* #79 b */
    { 0x0d4406, 0x0d4c06, 0x15056165a7c0972e, 0x541585969f025cb8, 0, 126 }, /* #80 */
    { 0x323bd3, 0x323bd2, 0x15056165a7c0972e, 0x541585969f025cb8, 0, 126 }, /* #80 b */
    { 0x3e0a47, 0x3e0246, 0x18da68642e707429, 0x1b4d0c85ce0e8523, 0, 251 }, /* #81 */
    { 0x017592, 0x017592, 0x18da68642e707429, 0x1b4d0c85ce0e8523, 0, 251 }, /* #81 b */
    { 0x1f53c2, 0x1f5bc2, 0x17ea2d7a12d3eee9, 0x6bd0969f7748bf51, 0, 173 }, /* #82 */
    { 0x202c17, 0x202c16, 0x17ea2d7a12d3eee9, 0x6bd0969f7748bf51, 0, 173 }, /* #82 b */
    { 0x0e5d83, 0x0e5583, 0x9a21a41e60b24e0a, 0xe0a9a21a41e60b24, 0, 204 }, /* #83 */
    { 0x312256, 0x312257, 0x9a21a41e60b24e0a, 0xe0a9a21a41e60b24, 0, 204 }, /* #83 b */
    { 0x095a83, 0x095282, 0x9bc30f6c5654d653, 0x39bc30f6c5654d65, 0, 132 }, /* #84 */
    { 0x362556, 0x362556, 0x9bc30f6c5654d653, 0x39bc30f6c5654d65, 0, 132 }, /* #84 b */
    { 0x3972d2, 0x3972d3, 0x3c2bc541623e9ae7, 0xe78578a82c47d35c, 0, 67 }, /* #85 */
    { 0x060d07, 0x060507, 0x3c2bc541623e9ae7, 0xe78578a82c47d35c, 0, 67 }, /* #85 b */
    { 0x251996, 0x251196, 0x38fb59a838900bde, 0x05ef1c7dacd41c48, 0, 209 }, /* #86 */
    { 0x1a6643, 0x1a6642, 0x38fb59a838900bde, 0x05ef1c7dacd41c48, 0, 209 }, /* #86 b */
    { 0x1e40d6, 0x1e40d7, 0x843e48db6f5b1307, 0xc1e10f9236dbd6c4, 0, 10 }, /* #87 */
    { 0x213f03, 0x213703, 0x843e48db6f5b1307, 0xc1e10f9236dbd6c4, 0, 10 }, /* #87 b */
    { 0x051756, 0x051756, 0xc06b716b6980b30e, 0x01661d80d6e2d6d3, 0, 215 }, /* #88 */
    { 0x3a6883, 0x3a6082, 0xc06b716b6980b30e, 0x01661d80d6e2d6d3, 0, 215 }, /* #88 b */
    { 0x034316, 0x034316, 0x27246d006f710d5d, 0x21aba4e48da00dee, 0, 19 }, /* #89 */
    { 0x3c3cc3, 0x3c34c2, 0x27246d006f710d5d, 0x21aba4e48da00dee, 0, 19 }, /* #89 b */
    { 0x222d86, 0x222586, 0xc409c09eafafe1af, 0x13813d5f5fc35f88, 0, 247 }, /* #90 */
    { 0x1d5253, 0x1d5252, 0xc409c09eafafe1af, 0x13813d5f5fc35f88, 0, 247 }, /* #90 b */
    { 0x193856, 0x193056, 0x798ba975de096036, 0x12c06cf31752ebbc, 0, 215 }, /* #91 */
    { 0x264783, 0x264782, 0x798ba975de096036, 0x12c06cf31752ebbc, 0, 215 }, /* #91 b */
    { 0x3e4e52, 0x3e4653, 0x311c3c67e8f8f6f0, 0xf47c7b78188e1e33, 0, 97 }, /* #92 */
    { 0x013187, 0x013187, 0x311c3c67e8f8f6f0, 0xf47c7b78188e1e33, 0, 97 }, /* #92 b */
    { 0x136c56, 0x136457, 0x42cffedd4c410d4c, 0xc410d4c42cffedd4, 0, 156 }, /* #93 */
    { 0x2c1383, 0x2c1383, 0x42cffedd4c410d4c, 0xc410d4c42cffedd4, 0, 156 }, /* #93 b */
    { 0x2934d2, 0x293cd2, 0xfb9d662033a68da5, 0x4bf73acc40674d1b, 0, 71 }, /* #94 */
    { 0x164b07, 0x164b06, 0xfb9d662033a68da5, 0x4bf73acc40674d1b, 0, 71 }, /* #94 b */
    { 0x1274d6, 0x127cd7, 0x95ee6bd8e7507fad, 0xbdcd7b1cea0ff5b2, 0, 251 }, /* #95 */
    { 0x2d0b03, 0x2d0b03, 0x95ee6bd8e7507fad, 0xbdcd7b1cea0ff5b2, 0, 251 }, /* #95 b */
};
uint32_t const g_cTests_ror_u64_amd = RT_ELEMENTS(g_aTests_ror_u64_amd);

BINU64_TEST_T const g_aTests_rcl_u64_amd[] =
{
    { 0x001603, 0x001602, 0x0000000000000000, 0x0000000200000000, 0, 226 }, /* #0 */
    { 0x3f69d6, 0x3f61d6, 0x0000000000000000, 0x0000000000000000, 0, 226 }, /* #0 b */
    { 0x0d6597, 0x0d6596, 0x0000000000000000, 0x0002000000000000, 0, 114 }, /* #1 */
    { 0x321a42, 0x321242, 0x0000000000000000, 0x0000000000000000, 0, 114 }, /* #1 b */
    { 0x3a7246, 0x3a7246, 0x0000000000000000, 0x0000000000000000, 0, 131 }, /* #2 */
    { 0x050d93, 0x050592, 0x0000000000000000, 0x0000000000000004, 0, 131 }, /* #2 b */
    { 0x270c07, 0x270406, 0x0000000000000000, 0x0000000000800000, 0, 152 }, /* #3 */
    { 0x1873d2, 0x1873d2, 0x0000000000000000, 0x0000000000000000, 0, 152 }, /* #3 b */
    { 0x1c38d6, 0x1c30d6, 0x0000000000000000, 0x0000000000000000, 0, 205 }, /* #4 */
    { 0x234703, 0x234702, 0x0000000000000000, 0x0000000000001000, 0, 205 }, /* #4 b */
    { 0x181717, 0x181716, 0x0000000000000000, 0x0000000000400000, 0, 215 }, /* #5 */
    { 0x2768c2, 0x2760c2, 0x0000000000000000, 0x0000000000000000, 0, 215 }, /* #5 b */
    { 0x045a52, 0x045a53, 0xbbdb027c1fc7e250, 0x1f894177b604f83f, 0, 106 }, /* #6 */
    { 0x3b2587, 0x3b2d87, 0xbbdb027c1fc7e250, 0x1f894377b604f83f, 0, 106 }, /* #6 b */
    { 0x301a16, 0x301217, 0x2886a4ef868a6757, 0x9d5c510d49df0d14, 0, 178 }, /* #7 */
    { 0x0f65c3, 0x0f65c3, 0x2886a4ef868a6757, 0x9d5e510d49df0d14, 0, 178 }, /* #7 b */
    { 0x3e1343, 0x3e1343, 0x0b639831f66a8583, 0xecd50b070b639831, 0, 161 }, /* #8 */
    { 0x016c96, 0x016497, 0x0b639831f66a8583, 0xecd50b060b639831, 0, 161 }, /* #8 b */
    { 0x1e0042, 0x1e0043, 0x60b206ff75aacddf, 0x9bbe60b206ff75aa, 0, 241 }, /* #9 */
    { 0x217f97, 0x217797, 0x60b206ff75aacddf, 0x9bbf60b206ff75aa, 0, 241 }, /* #9 b */
    { 0x107313, 0x107b13, 0xe3baf8fdda2d89f0, 0x768b627c3c775f1f, 0, 94 }, /* #10 */
    { 0x2f0cc6, 0x2f0cc7, 0xe3baf8fdda2d89f0, 0x768b627c1c775f1f, 0, 94 }, /* #10 b */
    { 0x1e6452, 0x1e6453, 0x0d9cf81e20a18ac2, 0x9f03c414315840d9, 0, 141 }, /* #11 */
    { 0x211b87, 0x211387, 0x0d9cf81e20a18ac2, 0x9f03c414315850d9, 0, 141 }, /* #11 b */
    { 0x1a47d7, 0x1a47d6, 0x56d67e9b287dbc51, 0x3ede28d5b59fa6ca, 0, 167 }, /* #12 */
    { 0x253802, 0x253002, 0x56d67e9b287dbc51, 0x3ede2895b59fa6ca, 0, 167 }, /* #12 b */
    { 0x1a7456, 0x1a7c56, 0xd68b0e5c9b4bf044, 0xe5c9b4bf0446b458, 0, 148 }, /* #13 */
    { 0x250b83, 0x250b82, 0xd68b0e5c9b4bf044, 0xe5c9b4bf044eb458, 0, 148 }, /* #13 b */
    { 0x087946, 0x087147, 0xc0df90609e51a000, 0x946800181bf20c13, 0, 230 }, /* #14 */
    { 0x370693, 0x370693, 0xc0df90609e51a000, 0x946800381bf20c13, 0, 230 }, /* #14 b */
    { 0x353012, 0x353812, 0x06abe80a51133f78, 0xfde00d57d014a226, 0, 242 }, /* #15 */
    { 0x0a4fc7, 0x0a4fc6, 0x06abe80a51133f78, 0xfde20d57d014a226, 0, 242 }, /* #15 b */
    { 0x245cc7, 0x245cc7, 0xbd35de804bcee949, 0x49de9aef4025e774, 0, 184 }, /* #16 */
    { 0x1b2312, 0x1b2b13, 0xbd35de804bcee949, 0x495e9aef4025e774, 0, 184 }, /* #16 b */
    { 0x174202, 0x174202, 0x5b3203e54043ad79, 0x7ca80875af25b320, 0, 85 }, /* #17 */
    { 0x283dd7, 0x2835d6, 0x5b3203e54043ad79, 0x7ca80875af35b320, 0, 85 }, /* #17 b */
    { 0x395116, 0x395916, 0x7dc580a42542b243, 0xcfb8b01484a85648, 0, 126 }, /* #18 */
    { 0x062ec3, 0x062ec2, 0x7dc580a42542b243, 0xefb8b01484a85648, 0, 126 }, /* #18 b */
    { 0x367297, 0x367296, 0xfa122e6e231cd5b4, 0x48b9b88c7356d3f4, 0, 138 }, /* #19 */
    { 0x090d42, 0x090542, 0xfa122e6e231cd5b4, 0x48b9b88c7356d1f4, 0, 138 }, /* #19 b */
    { 0x3a1857, 0x3a1056, 0xf66a6cbd7b912650, 0x650fb35365ebdc89, 0, 52 }, /* #20 */
    { 0x056782, 0x056782, 0xf66a6cbd7b912650, 0x6507b35365ebdc89, 0, 52 }, /* #20 b */
    { 0x391083, 0x391882, 0x7724e3f1257e0f65, 0xddc938fc495f83d9, 0, 127 }, /* #21 */
    { 0x066f56, 0x066f56, 0x7724e3f1257e0f65, 0x9dc938fc495f83d9, 0, 127 }, /* #21 b */
    { 0x161752, 0x161752, 0x236c683b425cef73, 0x5cef7311b6341da1, 0, 168 }, /* #22 */
    { 0x296887, 0x296086, 0x236c683b425cef73, 0x5cef7391b6341da1, 0, 168 }, /* #22 b */
    { 0x265402, 0x265c02, 0x04a21792d9dd2102, 0xb6774840809442f2, 0, 158 }, /* #23 */
    { 0x192bd7, 0x192bd6, 0x04a21792d9dd2102, 0xb6774840a09442f2, 0, 158 }, /* #23 b */
    { 0x174887, 0x174086, 0x5c0cb648b21a4a6e, 0x4590d253757032d9, 0, 91 }, /* #24 */
    { 0x283752, 0x283752, 0x5c0cb648b21a4a6e, 0x4590d253717032d9, 0, 91 }, /* #24 b */
    { 0x247296, 0x247a96, 0x677bae7a7066b70c, 0xcd6e18677bae7a70, 0, 169 }, /* #25 */
    { 0x1b0d43, 0x1b0d42, 0x677bae7a7066b70c, 0xcd6e19677bae7a70, 0, 169 }, /* #25 b */
    { 0x0f0d17, 0x0f0517, 0x7630c1cdd8781ed7, 0x9bb0f03daf7630c1, 0, 89 }, /* #26 */
    { 0x3072c2, 0x3072c3, 0x7630c1cdd8781ed7, 0x9bb0f03dae7630c1, 0, 89 }, /* #26 b */
    { 0x384c07, 0x384c07, 0x5b3baba074632d6e, 0x196b756ceeae81d1, 0, 43 }, /* #27 */
    { 0x0733d2, 0x073bd3, 0x5b3baba074632d6e, 0x196b716ceeae81d1, 0, 43 }, /* #27 b */
    { 0x0e78d3, 0x0e78d3, 0xc5cdbd116133a5da, 0x7a22c2674bb5c5cd, 0, 17 }, /* #28 */
    { 0x310706, 0x310f07, 0xc5cdbd116133a5da, 0x7a22c2674bb4c5cd, 0, 17 }, /* #28 b */
    { 0x3e4547, 0x3e4d46, 0xa24c3ff071f65130, 0xfb289868930ffc1c, 0, 39 }, /* #29 */
    { 0x013a92, 0x013a92, 0xa24c3ff071f65130, 0xfb289828930ffc1c, 0, 39 }, /* #29 b */
    { 0x270016, 0x270016, 0xfba2dc3317eccd6d, 0x66b6bee8b70cc5fb, 0, 175 }, /* #30 */
    { 0x187fc3, 0x1877c2, 0xfba2dc3317eccd6d, 0x66b6fee8b70cc5fb, 0, 175 }, /* #30 b */
    { 0x1a22c2, 0x1a2ac2, 0x21ce3030dedf7a2d, 0xb4439c6061bdbef4, 0, 122 }, /* #31 */
    { 0x255d17, 0x255d16, 0x21ce3030dedf7a2d, 0xb6439c6061bdbef4, 0, 122 }, /* #31 b */
    { 0x0334d2, 0x0334d3, 0xd4e1ec91ac5e15b0, 0xac5e15b06a70f648, 0, 32 }, /* #32 */
    { 0x3c4b07, 0x3c4307, 0xd4e1ec91ac5e15b0, 0xac5e15b0ea70f648, 0, 32 }, /* #32 b */
    { 0x285cc2, 0x285cc2, 0x079b0a85ba3d31f5, 0xa079b0a85ba3d31f, 0, 125 }, /* #33 */
    { 0x172317, 0x172b16, 0x079b0a85ba3d31f5, 0xb079b0a85ba3d31f, 0, 125 }, /* #33 b */
    { 0x304296, 0x304297, 0xf6ce7ea1b8ab4efb, 0xc55a77dbdb39fa86, 0, 35 }, /* #34 */
    { 0x0f3d43, 0x0f3543, 0xf6ce7ea1b8ab4efb, 0xc55a77dfdb39fa86, 0, 35 }, /* #34 b */
    { 0x2139d7, 0x2131d6, 0x4f6561a786c868ff, 0x69e1b21a3fe9ecac, 0, 214 }, /* #35 */
    { 0x1e4602, 0x1e4602, 0x4f6561a786c868ff, 0x69e1b21a3fc9ecac, 0, 214 }, /* #35 b */
    { 0x313502, 0x313d02, 0xef589078648f1b88, 0x9078648f1b8877ac, 0, 144 }, /* #36 */
    { 0x0e4ad7, 0x0e4ad6, 0xef589078648f1b88, 0x9078648f1b88f7ac, 0, 144 }, /* #36 b */
    { 0x2500c7, 0x2508c7, 0x15dc6ce20cb172a0, 0x5045771b38832c5c, 0, 119 }, /* #37 */
    { 0x1a7f12, 0x1a7f13, 0x15dc6ce20cb172a0, 0x5005771b38832c5c, 0, 119 }, /* #37 b */
    { 0x247647, 0x247646, 0x026fc845f76eaa51, 0x117ddbaa94604df9, 0, 22 }, /* #38 */
    { 0x1b0992, 0x1b0192, 0x026fc845f76eaa51, 0x117ddbaa94404df9, 0, 22 }, /* #38 b */
    { 0x065552, 0x065552, 0x3cfbb67226d54a38, 0x381e7ddb39136aa5, 0, 120 }, /* #39 */
    { 0x392a87, 0x392286, 0x3cfbb67226d54a38, 0x389e7ddb39136aa5, 0, 120 }, /* #39 b */
    { 0x093a82, 0x093a83, 0xdda6685b99c61d30, 0x38c3a60dda6685b9, 0, 101 }, /* #40 */
    { 0x364557, 0x364d57, 0xdda6685b99c61d30, 0x38c3a61dda6685b9, 0, 101 }, /* #40 b */
    { 0x306606, 0x306607, 0x3b7c406d2ffbc9c7, 0xa5ff7938e3b7c406, 0, 157 }, /* #41 */
    { 0x0f19d3, 0x0f11d3, 0x3b7c406d2ffbc9c7, 0xa5ff7938f3b7c406, 0, 157 }, /* #41 b */
    { 0x026fc2, 0x0267c3, 0x2fc11e6dc27964af, 0x964af17e08f36e13, 0, 108 }, /* #42 */
    { 0x3d1017, 0x3d1017, 0x2fc11e6dc27964af, 0x964af97e08f36e13, 0, 108 }, /* #42 b */
    { 0x030497, 0x030c97, 0xcb6ead5f2f803a39, 0x007473cb6ead5f2f, 0, 169 }, /* #43 */
    { 0x3c7b42, 0x3c7b43, 0xcb6ead5f2f803a39, 0x007472cb6ead5f2f, 0, 169 }, /* #43 b */
    { 0x0e51c2, 0x0e59c2, 0xcd0cbdd1153509a7, 0x88a9a84d3b3432f7, 0, 219 }, /* #44 */
    { 0x312e17, 0x312e16, 0xcd0cbdd1153509a7, 0x88a9a84d3f3432f7, 0, 219 }, /* #44 b */
    { 0x181843, 0x181843, 0x7e367d502f18b1a3, 0x502f18b1a3bf1b3e, 0, 24 }, /* #45 */
    { 0x276796, 0x276f97, 0x7e367d502f18b1a3, 0x502f18b1a33f1b3e, 0, 24 }, /* #45 b */
    { 0x3f0793, 0x3f0f93, 0x18e8fedf5b941cb6, 0x463a3fb7d6e5072d, 0, 63 }, /* #46 */
    { 0x007846, 0x007847, 0x18e8fedf5b941cb6, 0x063a3fb7d6e5072d, 0, 63 }, /* #46 b */
    { 0x0746c7, 0x0746c6, 0x074413e9ccf95cee, 0x413e9ccf95cee83a, 0, 140 }, /* #47 */
    { 0x383912, 0x383112, 0x074413e9ccf95cee, 0x413e9ccf95cee03a, 0, 140 }, /* #47 b */
    { 0x3f5152, 0x3f5953, 0xe086d649b77dbf00, 0x6efb7e00e086d649, 0, 33 }, /* #48 */
    { 0x002e87, 0x002e87, 0xe086d649b77dbf00, 0x6efb7e01e086d649, 0, 33 }, /* #48 b */
    { 0x342d43, 0x342543, 0x600d34ea016353b7, 0x8d4edec01a69d402, 0, 234 }, /* #49 */
    { 0x0b5296, 0x0b5297, 0x600d34ea016353b7, 0x8d4edcc01a69d402, 0, 234 }, /* #49 b */
    { 0x2a3d16, 0x2a3d17, 0x337e77b33a257e2b, 0x5f8ac66fcef66744, 0, 46 }, /* #50 */
    { 0x1542c3, 0x154ac3, 0x337e77b33a257e2b, 0x5f8ae66fcef66744, 0, 46 }, /* #50 b */
    { 0x153b97, 0x153b97, 0xe7892b55767d78d9, 0x67cf1256aaecfaf1, 0, 186 }, /* #51 */
    { 0x2a4442, 0x2a4c43, 0xe7892b55767d78d9, 0x65cf1256aaecfaf1, 0, 186 }, /* #51 b */
    { 0x345dd2, 0x3455d3, 0x61c42b4da405730c, 0xa405730c30e215a6, 0, 96 }, /* #52 */
    { 0x0b2207, 0x0b2207, 0x61c42b4da405730c, 0xa405730cb0e215a6, 0, 96 }, /* #52 b */
    { 0x365bc6, 0x3653c6, 0x387ee2f0ca4adb3a, 0x19495b674387ee2f, 0, 93 }, /* #53 */
    { 0x092413, 0x092412, 0x387ee2f0ca4adb3a, 0x19495b675387ee2f, 0, 93 }, /* #53 b */
    { 0x170bc7, 0x1703c6, 0x02686915f8a3afc3, 0x09a1a457e28ebf0e, 0, 194 }, /* #54 */
    { 0x287412, 0x287412, 0x02686915f8a3afc3, 0x09a1a457e28ebf0c, 0, 194 }, /* #54 b */
    { 0x236103, 0x236102, 0xb089a2aa365c7703, 0x4d1551b2e3b81ec2, 0, 203 }, /* #55 */
    { 0x1c1ed6, 0x1c16d6, 0xb089a2aa365c7703, 0x4d1551b2e3b81ac2, 0, 203 }, /* #55 b */
    { 0x2b16d7, 0x2b16d6, 0x06a9acd64a27fa6b, 0x6a9acd64a27fa6b8, 0, 4  }, /* #56 */
    { 0x146902, 0x146102, 0x06a9acd64a27fa6b, 0x6a9acd64a27fa6b0, 0, 4  }, /* #56 b */
    { 0x280dc7, 0x280dc7, 0xfe4cb1fdb7f61a9a, 0x7f932c7f6dfd86a6, 0, 255 }, /* #57 */
    { 0x177212, 0x177a13, 0xfe4cb1fdb7f61a9a, 0x3f932c7f6dfd86a6, 0, 255 }, /* #57 b */
    { 0x363c56, 0x363c56, 0x9760ee886186c6ba, 0xd749760ee886186c, 0, 181 }, /* #58 */
    { 0x094383, 0x094b82, 0x9760ee886186c6ba, 0xd759760ee886186c, 0, 181 }, /* #58 b */
    { 0x0e1c83, 0x0e1c83, 0x21f67faf064fd055, 0x27e82ac87d9febc1, 0, 103 }, /* #59 */
    { 0x316356, 0x316b57, 0x21f67faf064fd055, 0x27e82a887d9febc1, 0, 103 }, /* #59 b */
    { 0x281ec6, 0x281ec7, 0x5522f082fa166871, 0x42cd0e25522f082f, 0, 165 }, /* #60 */
    { 0x176113, 0x176913, 0x5522f082fa166871, 0x42cd0e35522f082f, 0, 165 }, /* #60 b */
    { 0x151c97, 0x151497, 0x249d47b9e11bbf12, 0xc4a493a8f73c2377, 0, 118 }, /* #61 */
    { 0x2a6342, 0x2a6343, 0x249d47b9e11bbf12, 0xc48493a8f73c2377, 0, 118 }, /* #61 b */
    { 0x075fd2, 0x075fd2, 0x11c27ebcb66b97e9, 0x84709faf2d9ae5fa, 0, 191 }, /* #62 */
    { 0x382007, 0x382806, 0x11c27ebcb66b97e9, 0xc4709faf2d9ae5fa, 0, 191 }, /* #62 b */
    { 0x0d7006, 0x0d7006, 0x82eadafce0d31875, 0x1d505d5b5f9c1a63, 0, 182 }, /* #63 */
    { 0x320fd3, 0x3207d2, 0x82eadafce0d31875, 0x1d705d5b5f9c1a63, 0, 182 }, /* #63 b */
    { 0x2a1a12, 0x2a1212, 0x87a8cf08c0e919fb, 0x1d233f687a8cf08c, 0, 37 }, /* #64 */
    { 0x1565c7, 0x1565c6, 0x87a8cf08c0e919fb, 0x1d233f787a8cf08c, 0, 37 }, /* #64 b */
    { 0x042202, 0x042a03, 0xd45481a69f91aa8e, 0x52069a7e46aa39a8, 0, 138 }, /* #65 */
    { 0x3b5dd7, 0x3b5dd7, 0xd45481a69f91aa8e, 0x52069a7e46aa3ba8, 0, 138 }, /* #65 b */
    { 0x095d92, 0x095593, 0xf8fc9f7e701fd1a4, 0xfd1a47c7e4fbf380, 0, 108 }, /* #66 */
    { 0x362247, 0x362247, 0xf8fc9f7e701fd1a4, 0xfd1a4fc7e4fbf380, 0, 108 }, /* #66 b */
    { 0x072606, 0x072e06, 0x1b252595f76d178c, 0xfbb68bc606c94965, 0, 31 }, /* #67 */
    { 0x3859d3, 0x3859d2, 0x1b252595f76d178c, 0xfbb68bc646c94965, 0, 31 }, /* #67 b */
    { 0x1c3692, 0x1c3e93, 0x52a7609589c2c740, 0x2a7609589c2c7402, 0, 196 }, /* #68 */
    { 0x234947, 0x234947, 0x52a7609589c2c740, 0x2a7609589c2c740a, 0, 196 }, /* #68 b */
    { 0x3552c6, 0x3552c7, 0x7be40ea9bd604739, 0x903aa6f5811ce4f7, 0, 202 }, /* #69 */
    { 0x0a2d13, 0x0a2513, 0x7be40ea9bd604739, 0x903aa6f5811ce6f7, 0, 202 }, /* #69 b */
    { 0x157343, 0x157b42, 0xe4a487872469e6a1, 0xf350f92921e1c91a, 0, 175 }, /* #70 */
    { 0x2a0c96, 0x2a0c96, 0xe4a487872469e6a1, 0xf350b92921e1c91a, 0, 175 }, /* #70 b */
    { 0x2f2e52, 0x2f2653, 0x4ff477c7e8126636, 0xbe3f409331b13fd1, 0, 211 }, /* #71 */
    { 0x105187, 0x105187, 0x4ff477c7e8126636, 0xbe3f409331b53fd1, 0, 211 }, /* #71 b */
    { 0x2638d3, 0x2638d2, 0xfe17d836825e5100, 0x9794403fc2fb06d0, 0, 230 }, /* #72 */
    { 0x194706, 0x194f06, 0xfe17d836825e5100, 0x9794401fc2fb06d0, 0, 230 }, /* #72 b */
    { 0x284bc2, 0x284bc3, 0x220f2888955b604c, 0x604c110794444aad, 0, 48 }, /* #73 */
    { 0x173417, 0x173c17, 0x220f2888955b604c, 0x604c910794444aad, 0, 48 }, /* #73 b */
    { 0x1e5e17, 0x1e5e17, 0x942a1159e108f958, 0x63285422b3c211f2, 0, 58 }, /* #74 */
    { 0x2121c2, 0x2129c3, 0x942a1159e108f958, 0x61285422b3c211f2, 0, 58 }, /* #74 b */
    { 0x001e02, 0x001602, 0x32a3782d1c3e1ff2, 0x1f0ff90ca8de0b47, 0, 39 }, /* #75 */
    { 0x3f61d7, 0x3f61d6, 0x32a3782d1c3e1ff2, 0x1f0ff94ca8de0b47, 0, 39 }, /* #75 b */
    { 0x102153, 0x102153, 0x56d90be3a01934cb, 0xa01934cbab6c85f1, 0, 160 }, /* #76 */
    { 0x2f5e86, 0x2f5687, 0x56d90be3a01934cb, 0xa01934cb2b6c85f1, 0, 160 }, /* #76 b */
    { 0x341b07, 0x341307, 0xe97ec7cc92dbffeb, 0xffebf4bf63e6496d, 0, 48 }, /* #77 */
    { 0x0b64d2, 0x0b64d3, 0xe97ec7cc92dbffeb, 0xffeb74bf63e6496d, 0, 48 }, /* #77 b */
    { 0x063887, 0x063887, 0x2bc9014d3d3ee37c, 0x5e480a69e9f71be4, 0, 131 }, /* #78 */
    { 0x394752, 0x394f53, 0x2bc9014d3d3ee37c, 0x5e480a69e9f71be0, 0, 131 }, /* #78 b */
    { 0x113156, 0x113956, 0x29ea5bb309be422c, 0x9ea5bb309be422c1, 0, 68 }, /* #79 */
    { 0x2e4e83, 0x2e4e82, 0x29ea5bb309be422c, 0x9ea5bb309be422c9, 0, 68 }, /* #79 b */
    { 0x0c5417, 0x0c5416, 0x40274e6c5387ea4c, 0x274e6c5387ea4ca0, 0, 136 }, /* #80 */
    { 0x332bc2, 0x3323c2, 0x40274e6c5387ea4c, 0x274e6c5387ea4c20, 0, 136 }, /* #80 b */
    { 0x127742, 0x127f43, 0x088df4d99953bcc4, 0x11be9b332a779880, 0, 197 }, /* #81 */
    { 0x2d0897, 0x2d0897, 0x088df4d99953bcc4, 0x11be9b332a779890, 0, 197 }, /* #81 b */
    { 0x0d5782, 0x0d5783, 0x77784a2dfec7ec81, 0xfd8fd90277784a2d, 0, 161 }, /* #82 */
    { 0x322857, 0x322057, 0x77784a2dfec7ec81, 0xfd8fd90377784a2d, 0, 161 }, /* #82 b */
    { 0x2103c2, 0x210bc3, 0xd7d2c472173dc315, 0x1c85cf70c55afa58, 0, 150 }, /* #83 */
    { 0x1e7c17, 0x1e7c17, 0xd7d2c472173dc315, 0x1c85cf70c57afa58, 0, 150 }, /* #83 b */
    { 0x1a7b13, 0x1a7b13, 0x4d50c6050d235f78, 0x028691afbc535431, 0, 23 }, /* #84 */
    { 0x2504c6, 0x250cc7, 0x4d50c6050d235f78, 0x028691afbc135431, 0, 23 }, /* #84 b */
    { 0x156e82, 0x156682, 0x829f36bfe22d2808, 0x29f36bfe22d28084, 0, 196 }, /* #85 */
    { 0x2a1157, 0x2a1156, 0x829f36bfe22d2808, 0x29f36bfe22d2808c, 0, 196 }, /* #85 b */
    { 0x373786, 0x373f86, 0xfe494f9c269dbe8d, 0x929f384d3b7d1afe, 0, 137 }, /* #86 */
    { 0x084853, 0x084852, 0xfe494f9c269dbe8d, 0x929f384d3b7d1bfe, 0, 137 }, /* #86 b */
    { 0x115087, 0x115886, 0xc2fa3756d5917e4a, 0xd5917e4ae17d1bab, 0, 160 }, /* #87 */
    { 0x2e2f52, 0x2e2f52, 0xc2fa3756d5917e4a, 0xd5917e4a617d1bab, 0, 160 }, /* #87 b */
    { 0x1f5696, 0x1f5e96, 0x54d0b34934009f26, 0x9a004f9315342cd2, 0, 31 }, /* #88 */
    { 0x202943, 0x202942, 0x54d0b34934009f26, 0x9a004f9355342cd2, 0, 31 }, /* #88 b */
    { 0x055c16, 0x055416, 0x26285e64e6a24040, 0x179939a8901004c5, 0, 206 }, /* #89 */
    { 0x3a23c3, 0x3a23c2, 0x26285e64e6a24040, 0x179939a8901024c5, 0, 206 }, /* #89 b */
    { 0x006d02, 0x006502, 0x7171af159d406fe3, 0x7501bf8ce2e35e2b, 0, 226 }, /* #90 */
    { 0x3f12d7, 0x3f12d6, 0x7171af159d406fe3, 0x7501bf8ee2e35e2b, 0, 226 }, /* #90 b */
    { 0x2a28d7, 0x2a20d7, 0x70bcae5168ba91d6, 0x945a2ea475ae1795, 0, 214 }, /* #91 */
    { 0x155702, 0x155703, 0x70bcae5168ba91d6, 0x945a2ea4758e1795, 0, 214 }, /* #91 b */
    { 0x3d1bc7, 0x3d13c7, 0x06bfd3b775c8a0f7, 0xdbbae4507bc1aff4, 0, 215 }, /* #92 */
    { 0x026412, 0x026413, 0x06bfd3b775c8a0f7, 0xdbbae4507b81aff4, 0, 215 }, /* #92 b */
    { 0x2b0b87, 0x2b0386, 0xc2e0c7da97c3f846, 0x17063ed4be1fc237, 0, 131 }, /* #93 */
    { 0x147452, 0x147452, 0xc2e0c7da97c3f846, 0x17063ed4be1fc233, 0, 131 }, /* #93 b */
    { 0x2b0fc7, 0x2b07c7, 0x520d7488862e6d5b, 0xae9110c5cdab7520, 0, 205 }, /* #94 */
    { 0x147012, 0x147013, 0x520d7488862e6d5b, 0xae9110c5cdab6520, 0, 205 }, /* #94 b */
    { 0x0c06c2, 0x0c06c2, 0xe2e169c13175a5f0, 0x4c5d697c1c5c2d38, 0, 158 }, /* #95 */
    { 0x337917, 0x337116, 0xe2e169c13175a5f0, 0x4c5d697c3c5c2d38, 0, 158 }, /* #95 b */
};
uint32_t const g_cTests_rcl_u64_amd = RT_ELEMENTS(g_aTests_rcl_u64_amd);

BINU64_TEST_T const g_aTests_rcr_u64_amd[] =
{
    { 0x017446, 0x017446, 0x0000000000000000, 0x0000000000000000, 0, 182 }, /* #0 */
    { 0x3e0b93, 0x3e0392, 0x0000000000000000, 0x0000000000000400, 0, 182 }, /* #0 b */
    { 0x3f6592, 0x3f6592, 0x0000000000000000, 0x0000000000000000, 0, 62 }, /* #1 */
    { 0x001a47, 0x001246, 0x0000000000000000, 0x0000000000000004, 0, 62 }, /* #1 b */
    { 0x151357, 0x151356, 0x0000000000000000, 0x0000000000001000, 0, 244 }, /* #2 */
    { 0x2a6c82, 0x2a6482, 0x0000000000000000, 0x0000000000000000, 0, 244 }, /* #2 b */
    { 0x241883, 0x241882, 0x0000000000000000, 0x4000000000000000, 0, 2  }, /* #3 */
    { 0x1b6756, 0x1b6756, 0x0000000000000000, 0x0000000000000000, 0, 2  }, /* #3 b */
    { 0x041783, 0x041782, 0x0000000000000000, 0x0000000000002000, 0, 179 }, /* #4 */
    { 0x3b6856, 0x3b6056, 0x0000000000000000, 0x0000000000000000, 0, 179 }, /* #4 b */
    { 0x390c96, 0x390496, 0x0000000000000000, 0x0000000000000000, 0, 59 }, /* #5 */
    { 0x067343, 0x067342, 0x0000000000000000, 0x0000000000000020, 0, 59 }, /* #5 b */
    { 0x0e1a97, 0x0e1a96, 0xc12a50996b9111d7, 0x4a94265ae44475f8, 0, 59 }, /* #6 */
    { 0x316542, 0x316d42, 0xc12a50996b9111d7, 0x4a94265ae44475d8, 0, 59 }, /* #6 b */
    { 0x1064d6, 0x106cd7, 0x30c8bda659a15ca2, 0x96685728861917b4, 0, 35 }, /* #7 */
    { 0x2f1b03, 0x2f1b03, 0x30c8bda659a15ca2, 0x96685728a61917b4, 0, 35 }, /* #7 b */
    { 0x0c0087, 0x0c0087, 0xe65e6b96cfeb61bf, 0xfad86ffccbcd72d9, 0, 91 }, /* #8 */
    { 0x337f52, 0x337753, 0xe65e6b96cfeb61bf, 0xfad86fdccbcd72d9, 0, 91 }, /* #8 b */
    { 0x1e6682, 0x1e6e82, 0xf48a429aabe5b011, 0x914853557cb6022f, 0, 60 }, /* #9 */
    { 0x211957, 0x211956, 0xf48a429aabe5b011, 0x914853557cb6023f, 0, 60 }, /* #9 b */
    { 0x0f6c16, 0x0f6c16, 0x4a23a2076216d988, 0x5b66209447440ec4, 0, 151 }, /* #10 */
    { 0x3013c3, 0x301bc2, 0x4a23a2076216d988, 0x5b66229447440ec4, 0, 151 }, /* #10 b */
    { 0x1b2886, 0x1b2886, 0xdc64ec00b4172883, 0x5106dc64ec00b417, 0, 144 }, /* #11 */
    { 0x245753, 0x245f52, 0xdc64ec00b4172883, 0x5107dc64ec00b417, 0, 144 }, /* #11 b */
    { 0x364f47, 0x364f46, 0x0ca49c5829907ba1, 0x927160a641ee8619, 0, 183 }, /* #12 */
    { 0x093092, 0x093892, 0x0ca49c5829907ba1, 0x927160a641ee8419, 0, 183 }, /* #12 b */
    { 0x0778c3, 0x0778c2, 0x8d0784a427b4c555, 0x5213da62aae341e1, 0, 170 }, /* #13 */
    { 0x380716, 0x380f16, 0x8d0784a427b4c555, 0x5213da62aaa341e1, 0, 170 }, /* #13 b */
    { 0x2f4582, 0x2f4d83, 0xf36148e07391f4d6, 0x4d679b0a47039c8f, 0, 77 }, /* #14 */
    { 0x103a57, 0x103a57, 0xf36148e07391f4d6, 0x4d6f9b0a47039c8f, 0, 77 }, /* #14 b */
    { 0x051fc3, 0x051fc2, 0xb8abbc4d19bbcd6d, 0x66ef35b77157789a, 0, 31 }, /* #15 */
    { 0x3a6016, 0x3a6816, 0xb8abbc4d19bbcd6d, 0x66ef35b57157789a, 0, 31 }, /* #15 b */
    { 0x132496, 0x132497, 0xe4ca0045024f4efa, 0x024f4efa72650022, 0, 225 }, /* #16 */
    { 0x2c5b43, 0x2c5343, 0xe4ca0045024f4efa, 0x024f4efaf2650022, 0, 225 }, /* #16 b */
    { 0x3e3586, 0x3e3587, 0x64cfd8949487e12b, 0x3267ec4a4a43f095, 0, 65 }, /* #17 */
    { 0x014a53, 0x014a53, 0x64cfd8949487e12b, 0xb267ec4a4a43f095, 0, 65 }, /* #17 b */
    { 0x372052, 0x372053, 0x7f675a4f9f213de8, 0xef41fd9d693e7c84, 0, 14 }, /* #18 */
    { 0x085f87, 0x085787, 0x7f675a4f9f213de8, 0xef45fd9d693e7c84, 0, 14 }, /* #18 b */
    { 0x227386, 0x227387, 0x1c20080e8daa2014, 0x00a07080203a36a8, 0, 142 }, /* #19 */
    { 0x1d0c53, 0x1d0453, 0x1c20080e8daa2014, 0x00a47080203a36a8, 0, 142 }, /* #19 b */
    { 0x215492, 0x215492, 0x486e45ea33d29dae, 0xdc8bd467a53b5c48, 0, 248 }, /* #20 */
    { 0x1e2b47, 0x1e2346, 0x486e45ea33d29dae, 0xdc8bd467a53b5d48, 0, 248 }, /* #20 b */
    { 0x1e3a47, 0x1e3247, 0x43ae54ce7d1748d3, 0x3a1d72a673e8ba46, 0, 69 }, /* #21 */
    { 0x214592, 0x214593, 0x43ae54ce7d1748d3, 0x321d72a673e8ba46, 0, 69 }, /* #21 b */
    { 0x047587, 0x047d86, 0xa9e9c516e1ca526e, 0xa2dc394a4dda9e9c, 0, 172 }, /* #22 */
    { 0x3b0a52, 0x3b0a52, 0xa9e9c516e1ca526e, 0xa2dc394a4dca9e9c, 0, 172 }, /* #22 b */
    { 0x0c01d3, 0x0c09d3, 0xae3c23359ab9198b, 0x8bd71e119acd5c8c, 0, 73 }, /* #23 */
    { 0x337e06, 0x337e07, 0xae3c23359ab9198b, 0x8b571e119acd5c8c, 0, 73 }, /* #23 b */
    { 0x3a0d02, 0x3a0503, 0xe331e8144673e6be, 0x0288ce7cd7ce331e, 0, 236 }, /* #24 */
    { 0x0572d7, 0x0572d7, 0xe331e8144673e6be, 0x0288ce7cd7de331e, 0, 236 }, /* #24 b */
    { 0x1444d3, 0x1444d2, 0x28b3ee704e7aee50, 0x25167dce09cf5dca, 0, 195 }, /* #25 */
    { 0x2b3b06, 0x2b3306, 0x28b3ee704e7aee50, 0x05167dce09cf5dca, 0, 195 }, /* #25 b */
    { 0x0e1247, 0x0e1246, 0x81e7fecda5e58e66, 0xcd81e7fecda5e58e, 0, 136 }, /* #26 */
    { 0x316d92, 0x316592, 0x81e7fecda5e58e66, 0xcc81e7fecda5e58e, 0, 136 }, /* #26 b */
    { 0x2a1f07, 0x2a1707, 0x672cc1687330498c, 0x2ce5982d0e660931, 0, 195 }, /* #27 */
    { 0x1560d2, 0x1560d3, 0x672cc1687330498c, 0x0ce5982d0e660931, 0, 195 }, /* #27 b */
    { 0x356942, 0x356143, 0x3edb689cc442d1cb, 0x1f6db44e622168e5, 0, 1  }, /* #28 */
    { 0x0a1697, 0x0a1e97, 0x3edb689cc442d1cb, 0x9f6db44e622168e5, 0, 1  }, /* #28 b */
    { 0x2d7396, 0x2d7397, 0xc406cd3ae9473d42, 0xd74a39ea13101b34, 0, 230 }, /* #29 */
    { 0x120c43, 0x120443, 0xc406cd3ae9473d42, 0xd74a39ea17101b34, 0, 230 }, /* #29 b */
    { 0x296e53, 0x296652, 0xba972a82f327cf3e, 0xc9f3cfb752e5505e, 0, 219 }, /* #30 */
    { 0x161186, 0x161186, 0xba972a82f327cf3e, 0xc9f3cf9752e5505e, 0, 219 }, /* #30 b */
    { 0x116d42, 0x116d42, 0x4f946fea49e5d351, 0x51bfa927974d449f, 0, 119 }, /* #31 */
    { 0x2e1297, 0x2e1a96, 0x4f946fea49e5d351, 0x51bfa927974d469f, 0, 119 }, /* #31 b */
    { 0x2c1e17, 0x2c1e17, 0x8c8b2690ec6b9af8, 0x93487635cd7c6322, 0, 50 }, /* #32 */
    { 0x1361c2, 0x1369c3, 0x8c8b2690ec6b9af8, 0x93487635cd7c2322, 0, 50 }, /* #32 b */
    { 0x2d6e47, 0x2d6e46, 0x61922c9e5b8e6524, 0x9258648b2796e399, 0, 74 }, /* #33 */
    { 0x121192, 0x121992, 0x61922c9e5b8e6524, 0x9218648b2796e399, 0, 74 }, /* #33 b */
    { 0x364203, 0x364a03, 0x432e7207a931c7b5, 0xad0cb9c81ea4c71e, 0, 6  }, /* #34 */
    { 0x093dd6, 0x093dd7, 0x432e7207a931c7b5, 0xa90cb9c81ea4c71e, 0, 6  }, /* #34 b */
    { 0x3f2d46, 0x3f2d47, 0x46ba1ae17cbf9893, 0x5d0d70be5fcc4991, 0, 58 }, /* #35 */
    { 0x005293, 0x005a93, 0x46ba1ae17cbf9893, 0x5d0d70be5fcc49d1, 0, 58 }, /* #35 b */
    { 0x024d43, 0x024d43, 0x51f5cce519bc3009, 0x9ca3378601351f5c, 0, 108 }, /* #36 */
    { 0x3d3296, 0x3d3a97, 0x51f5cce519bc3009, 0x9ca3378601251f5c, 0, 108 }, /* #36 b */
    { 0x072bc3, 0x0723c3, 0x5d6ea7c774a57fe1, 0xd6ea7c774a57fe1a, 0, 189 }, /* #37 */
    { 0x385416, 0x385417, 0x5d6ea7c774a57fe1, 0xd6ea7c774a57fe12, 0, 189 }, /* #37 b */
    { 0x133d56, 0x133557, 0x36fe877f64922606, 0x3030dbfa1dfd9248, 0, 14 }, /* #38 */
    { 0x2c4283, 0x2c4283, 0x36fe877f64922606, 0x3034dbfa1dfd9248, 0, 14 }, /* #38 b */
    { 0x363056, 0x363057, 0x60204d61c620fe6f, 0x301026b0e3107f37, 0, 193 }, /* #39 */
    { 0x094f83, 0x094f83, 0x60204d61c620fe6f, 0xb01026b0e3107f37, 0, 193 }, /* #39 b */
    { 0x0020c3, 0x0028c3, 0xc73e51b5f7fc16d2, 0x6971cf946d7dff05, 0, 202 }, /* #40 */
    { 0x3f5f16, 0x3f5f17, 0xc73e51b5f7fc16d2, 0x6931cf946d7dff05, 0, 202 }, /* #40 b */
    { 0x2f5702, 0x2f5702, 0xa6595f87d0950095, 0x02554cb2bf0fa12a, 0, 143 }, /* #41 */
    { 0x1028d7, 0x1020d6, 0xa6595f87d0950095, 0x02574cb2bf0fa12a, 0, 143 }, /* #41 b */
    { 0x177c96, 0x177c96, 0x0a88438a04c79311, 0x0a88438a04c79311, 0, 64 }, /* #42 */
    { 0x280343, 0x280343, 0x0a88438a04c79311, 0x0a88438a04c79311, 0, 64 }, /* #42 b */
    { 0x3e1f56, 0x3e1756, 0xbe9948f9c446b703, 0x2235b81afa6523e7, 0, 94 }, /* #43 */
    { 0x016083, 0x016082, 0xbe9948f9c446b703, 0x2235b81efa6523e7, 0, 94 }, /* #43 b */
    { 0x232812, 0x232812, 0xf0af2ab4369dc7e7, 0x86d3b8fcef0af2ab, 0, 100 }, /* #44 */
    { 0x1c57c7, 0x1c5fc6, 0xf0af2ab4369dc7e7, 0x86d3b8fcff0af2ab, 0, 100 }, /* #44 b */
    { 0x335c12, 0x335412, 0x8255ad3420a15ec8, 0xd69a1050af642095, 0, 242 }, /* #45 */
    { 0x0c23c7, 0x0c23c6, 0x8255ad3420a15ec8, 0xd69a1050af646095, 0, 242 }, /* #45 b */
    { 0x171143, 0x171143, 0x825d8078cd4a330c, 0x19866097601e3352, 0, 82 }, /* #46 */
    { 0x286e96, 0x286697, 0x825d8078cd4a330c, 0x19862097601e3352, 0, 82 }, /* #46 b */
    { 0x2b63c3, 0x2b6bc2, 0xe8a4f06c5b7fe15e, 0xb6ffc2bde8a4f06c, 0, 32 }, /* #47 */
    { 0x141c16, 0x141c16, 0xe8a4f06c5b7fe15e, 0xb6ffc2bce8a4f06c, 0, 32 }, /* #47 b */
    { 0x0a0f83, 0x0a0783, 0xf80b8fbb8aaf41d7, 0x075ff0171f77155e, 0, 143 }, /* #48 */
    { 0x357056, 0x357057, 0xf80b8fbb8aaf41d7, 0x075df0171f77155e, 0, 143 }, /* #48 b */
    { 0x0f0996, 0x0f0197, 0x30e861907fc067f2, 0xc067f2187430c83f, 0, 217 }, /* #49 */
    { 0x307643, 0x307643, 0x30e861907fc067f2, 0xc067f2987430c83f, 0, 217 }, /* #49 b */
    { 0x187d43, 0x187542, 0x394bc12a69c7c0ef, 0xef9ca5e09534e3e0, 0, 201 }, /* #50 */
    { 0x270296, 0x270296, 0x394bc12a69c7c0ef, 0xef1ca5e09534e3e0, 0, 201 }, /* #50 b */
    { 0x393992, 0x393992, 0x247506fcf74ffd26, 0x7fe93091d41bf3dd, 0, 22 }, /* #51 */
    { 0x064647, 0x064e46, 0x247506fcf74ffd26, 0x7fe93491d41bf3dd, 0, 22 }, /* #51 b */
    { 0x345086, 0x345886, 0x906b8d7521945164, 0x41ae35d486514591, 0, 191 }, /* #52 */
    { 0x0b2f53, 0x0b2f52, 0x906b8d7521945164, 0x41ae35d486514593, 0, 191 }, /* #52 b */
    { 0x031a13, 0x031212, 0xa8e0fc468987a6f0, 0x0fc468987a6f0d47, 0, 117 }, /* #53 */
    { 0x3c65c6, 0x3c65c6, 0xa8e0fc468987a6f0, 0x0fc468987a6f0547, 0, 117 }, /* #53 b */
    { 0x0501c2, 0x0501c2, 0xea54f5e8357e1bd3, 0xde9ba953d7a0d5f8, 0, 14 }, /* #54 */
    { 0x3a7e17, 0x3a7616, 0xea54f5e8357e1bd3, 0xde9fa953d7a0d5f8, 0, 14 }, /* #54 b */
    { 0x330786, 0x330787, 0x6de997a66010c8b7, 0xd33008645b9b7a65, 0, 170 }, /* #55 */
    { 0x0c7853, 0x0c7053, 0x6de997a66010c8b7, 0xd33008645bdb7a65, 0, 170 }, /* #55 b */
    { 0x3c0743, 0x3c0742, 0x8235f8b6179bfdd6, 0xf37fbad8235f8b61, 0, 220 }, /* #56 */
    { 0x037896, 0x037096, 0x8235f8b6179bfdd6, 0xf37fbac8235f8b61, 0, 220 }, /* #56 b */
    { 0x165187, 0x165187, 0xfa34eb152e9fc0f4, 0x2e9fc0f4fd1a758a, 0, 97 }, /* #57 */
    { 0x292e52, 0x292653, 0xfa34eb152e9fc0f4, 0x2e9fc0f47d1a758a, 0, 97 }, /* #57 b */
    { 0x3536c6, 0x3536c7, 0x770bf80377996269, 0xf006ef32c4d2770b, 0, 48 }, /* #58 */
    { 0x0a4913, 0x0a4113, 0x770bf80377996269, 0xf006ef32c4d3770b, 0, 48 }, /* #58 b */
    { 0x344907, 0x344107, 0xb8f51d07c78435ff, 0xff71ea3a0f8f086b, 0, 199 }, /* #59 */
    { 0x0b36d2, 0x0b36d3, 0xb8f51d07c78435ff, 0xfd71ea3a0f8f086b, 0, 199 }, /* #59 b */
    { 0x2b6116, 0x2b6916, 0x8ba5b852c250e00e, 0x96e14b0943803917, 0, 119 }, /* #60 */
    { 0x141ec3, 0x141ec2, 0x8ba5b852c250e00e, 0x96e14b0943803b17, 0, 119 }, /* #60 b */
    { 0x194e83, 0x194682, 0x5925a66b02bb5667, 0xd335815dab33d649, 0, 178 }, /* #61 */
    { 0x263156, 0x263156, 0x5925a66b02bb5667, 0xd335815dab339649, 0, 178 }, /* #61 b */
    { 0x263407, 0x263c07, 0x5729f2978637474c, 0x4f94bc31ba3a655c, 0, 54 }, /* #62 */
    { 0x194bd2, 0x194bd3, 0x5729f2978637474c, 0x4f94bc31ba3a615c, 0, 54 }, /* #62 b */
    { 0x243696, 0x243697, 0xf90e4593a6fe2c4c, 0x21c8b274dfc5898f, 0, 252 }, /* #63 */
    { 0x1b4943, 0x1b4143, 0xf90e4593a6fe2c4c, 0x21c8b274dfc5899f, 0, 252 }, /* #63 b */
    { 0x013192, 0x013193, 0xfe0eff54eb6527a9, 0xd6ca4f52fe0eff54, 0, 160 }, /* #64 */
    { 0x3e4e47, 0x3e4647, 0xfe0eff54eb6527a9, 0xd6ca4f53fe0eff54, 0, 160 }, /* #64 b */
    { 0x192387, 0x192b86, 0xcd48669522332af1, 0x79a90cd2a446655e, 0, 3  }, /* #65 */
    { 0x265c52, 0x265c52, 0xcd48669522332af1, 0x59a90cd2a446655e, 0, 3  }, /* #65 b */
    { 0x331c42, 0x331442, 0xa2206891e5d76caf, 0x247975db2bd4440d, 0, 235 }, /* #66 */
    { 0x0c6397, 0x0c6396, 0xa2206891e5d76caf, 0x247975db2bf4440d, 0, 235 }, /* #66 b */
    { 0x1112d3, 0x1112d2, 0xd3be6e539d862c2d, 0xde9df3729cec3161, 0, 69 }, /* #67 */
    { 0x2e6d06, 0x2e6506, 0xd3be6e539d862c2d, 0xd69df3729cec3161, 0, 69 }, /* #67 b */
    { 0x3f0347, 0x3f0b47, 0x1bf930f6822734c4, 0xb41139a6246fe4c3, 0, 166 }, /* #68 */
    { 0x007c92, 0x007c93, 0x1bf930f6822734c4, 0xb41139a6206fe4c3, 0, 166 }, /* #68 b */
    { 0x2b6886, 0x2b6886, 0x094a91a82878a7b5, 0x46a0a1e29ed41295, 0, 47 }, /* #69 */
    { 0x141753, 0x141f52, 0x094a91a82878a7b5, 0x46a0a1e29ed61295, 0, 47 }, /* #69 b */
    { 0x072bc2, 0x0723c2, 0xb27539f9d08b703b, 0xe076b27539f9d08b, 0, 80 }, /* #70 */
    { 0x385417, 0x385416, 0xb27539f9d08b703b, 0xe077b27539f9d08b, 0, 80 }, /* #70 b */
    { 0x0717c3, 0x071fc2, 0x8424abae7f70c347, 0x4abae7f70c347c21, 0, 117 }, /* #71 */
    { 0x386816, 0x386816, 0x8424abae7f70c347, 0x4abae7f70c347421, 0, 117 }, /* #71 b */
    { 0x152cd3, 0x1524d2, 0xd35752ab534db7b3, 0xf67d35752ab534db, 0, 76 }, /* #72 */
    { 0x2a5306, 0x2a5306, 0xd35752ab534db7b3, 0xf66d35752ab534db, 0, 76 }, /* #72 b */
    { 0x177787, 0x177787, 0xa991faaadb5406ea, 0x23f555b6a80dd5a9, 0, 56 }, /* #73 */
    { 0x280852, 0x280053, 0xa991faaadb5406ea, 0x23f555b6a80dd4a9, 0, 56 }, /* #73 b */
    { 0x0b5092, 0x0b5092, 0xbaf609d82016d4f0, 0xf609d82016d4f05d, 0, 249 }, /* #74 */
    { 0x342f47, 0x342746, 0xbaf609d82016d4f0, 0xf609d82016d4f0dd, 0, 249 }, /* #74 b */
    { 0x164182, 0x164183, 0x12f1257f2f7c7147, 0xcbdf1c51c25e24af, 0, 99 }, /* #75 */
    { 0x293e57, 0x293657, 0x12f1257f2f7c7147, 0xcbdf1c51e25e24af, 0, 99 }, /* #75 b */
    { 0x160893, 0x160093, 0x9827b0b4000efd8b, 0x0003bf62f304f616, 0, 163 }, /* #76 */
    { 0x297746, 0x297747, 0x9827b0b4000efd8b, 0x0003bf62d304f616, 0, 163 }, /* #76 b */
    { 0x362257, 0x362257, 0x327e1a1af7a5fce4, 0xe97f39264fc3435e, 0, 219 }, /* #77 */
    { 0x095d82, 0x095583, 0x327e1a1af7a5fce4, 0xe97f39064fc3435e, 0, 219 }, /* #77 b */
    { 0x003bd3, 0x003bd3, 0x8a9271bbe1740f35, 0x524e377c2e81e6b8, 0, 60 }, /* #78 */
    { 0x3f4406, 0x3f4c07, 0x8a9271bbe1740f35, 0x524e377c2e81e6a8, 0, 60 }, /* #78 b */
    { 0x020c47, 0x020447, 0x02c642623f91e2e1, 0xc8f170c0b190988f, 0, 90 }, /* #79 */
    { 0x3d7392, 0x3d7393, 0x02c642623f91e2e1, 0xc8f17080b190988f, 0, 90 }, /* #79 b */
    { 0x381f46, 0x381747, 0x64333ec544ceca0d, 0x15133b2834c8667d, 0, 231 }, /* #80 */
    { 0x076093, 0x076093, 0x64333ec544ceca0d, 0x15133b2836c8667d, 0, 231 }, /* #80 b */
    { 0x125516, 0x125d17, 0x48977ac06825c8a3, 0x80d04b914648977a, 0, 168 }, /* #81 */
    { 0x2d2ac3, 0x2d2ac3, 0x48977ac06825c8a3, 0x80d04b914748977a, 0, 168 }, /* #81 b */
    { 0x0b5f46, 0x0b5f47, 0x904bee23949dfcfb, 0x6904bee23949dfcf, 0, 4  }, /* #82 */
    { 0x342093, 0x342893, 0x904bee23949dfcfb, 0x7904bee23949dfcf, 0, 4  }, /* #82 b */
    { 0x007e83, 0x007e83, 0x194479786d31b0a6, 0x94479786d31b0a68, 0, 61 }, /* #83 */
    { 0x3f0156, 0x3f0957, 0x194479786d31b0a6, 0x94479786d31b0a60, 0, 61 }, /* #83 b */
    { 0x1e6346, 0x1e6347, 0x785c51f4948733d6, 0xd2521ccf58f0b8a3, 0, 231 }, /* #84 */
    { 0x211c93, 0x211493, 0x785c51f4948733d6, 0xd2521ccf5af0b8a3, 0, 231 }, /* #84 b */
    { 0x076a92, 0x076a92, 0xc3b4f5273daf5bd0, 0xbd6f418769ea4e7b, 0, 87 }, /* #85 */
    { 0x381547, 0x381d46, 0xc3b4f5273daf5bd0, 0xbd6f438769ea4e7b, 0, 87 }, /* #85 b */
    { 0x3c7292, 0x3c7a92, 0x037449b85ac80ba4, 0x5ac80ba401ba24dc, 0, 161 }, /* #86 */
    { 0x030d47, 0x030d46, 0x037449b85ac80ba4, 0x5ac80ba481ba24dc, 0, 161 }, /* #86 b */
    { 0x1c04c2, 0x1c0cc2, 0x7290d270b49a1f9a, 0x87e68e521a4e1693, 0, 211 }, /* #87 */
    { 0x237b17, 0x237b16, 0x7290d270b49a1f9a, 0x87e6ae521a4e1693, 0, 211 }, /* #87 b */
    { 0x355497, 0x355c97, 0x38725c5bf35b7167, 0x7e6b6e2cf38725c5, 0, 36 }, /* #88 */
    { 0x0a2b42, 0x0a2b43, 0x38725c5bf35b7167, 0x7e6b6e2ce38725c5, 0, 36 }, /* #88 b */
    { 0x3f71d7, 0x3f71d6, 0x80ac99f06f0d088d, 0x15933e0de1a111b8, 0, 188 }, /* #89 */
    { 0x000e02, 0x000602, 0x80ac99f06f0d088d, 0x15933e0de1a111a8, 0, 188 }, /* #89 b */
    { 0x3f1c87, 0x3f1c86, 0x47e231584529fdfe, 0x8c56114a7f7fa8fc, 0, 115 }, /* #90 */
    { 0x006352, 0x006b52, 0x47e231584529fdfe, 0x8c56114a7f7f88fc, 0, 115 }, /* #90 b */
    { 0x375bc6, 0x3753c6, 0xbc41dd6533bfe8a1, 0x2857883baca677fd, 0, 203 }, /* #91 */
    { 0x082413, 0x082412, 0xbc41dd6533bfe8a1, 0x2877883baca677fd, 0, 203 }, /* #91 b */
    { 0x056397, 0x056b97, 0x7f3b21c0e54f6432, 0x5fcec8703953d90c, 0, 130 }, /* #92 */
    { 0x3a1c42, 0x3a1443, 0x7f3b21c0e54f6432, 0x1fcec8703953d90c, 0, 130 }, /* #92 b */
    { 0x0c1b42, 0x0c1343, 0x5ab038797c634a80, 0xf18d2a00b56070f2, 0, 159 }, /* #93 */
    { 0x336497, 0x336497, 0x5ab038797c634a80, 0xf18d2a02b56070f2, 0, 159 }, /* #93 b */
    { 0x1945c2, 0x194dc2, 0xc759892a97faa0e6, 0x4aa5fea83998eb31, 0, 43 }, /* #94 */
    { 0x263a17, 0x263a16, 0xc759892a97faa0e6, 0x4aa5fea839b8eb31, 0, 43 }, /* #94 b */
    { 0x3122c2, 0x3122c2, 0xe92f705935a12f68, 0x3a4bdc164d684bda, 0, 2  }, /* #95 */
    { 0x0e5d17, 0x0e5d16, 0xe92f705935a12f68, 0x7a4bdc164d684bda, 0, 2  }, /* #95 b */
};
uint32_t const g_cTests_rcr_u64_amd = RT_ELEMENTS(g_aTests_rcr_u64_amd);

BINU64_TEST_T const g_aTests_shl_u64_amd[] =
{
    { 0x186793, 0x186756, 0x0000000000000000, 0x0000000000000000, 0, 145 }, /* #0 */
    { 0x271846, 0x271056, 0x0000000000000000, 0x0000000000000000, 0, 145 }, /* #0 b */
    { 0x376096, 0x376056, 0x0000000000000000, 0x0000000000000000, 0, 215 }, /* #1 */
    { 0x081f43, 0x081756, 0x0000000000000000, 0x0000000000000000, 0, 215 }, /* #1 b */
    { 0x191216, 0x191256, 0x0000000000000000, 0x0000000000000000, 0, 152 }, /* #2 */
    { 0x266dc3, 0x266556, 0x0000000000000000, 0x0000000000000000, 0, 152 }, /* #2 b */
    { 0x092fd7, 0x092756, 0x0000000000000000, 0x0000000000000000, 0, 173 }, /* #3 */
    { 0x365002, 0x365056, 0x0000000000000000, 0x0000000000000000, 0, 173 }, /* #3 b */
    { 0x1b1183, 0x1b1156, 0x0000000000000000, 0x0000000000000000, 0, 102 }, /* #4 */
    { 0x246e56, 0x246656, 0x0000000000000000, 0x0000000000000000, 0, 102 }, /* #4 b */
    { 0x133706, 0x133756, 0x0000000000000000, 0x0000000000000000, 0, 107 }, /* #5 */
    { 0x2c48d3, 0x2c4056, 0x0000000000000000, 0x0000000000000000, 0, 107 }, /* #5 b */
    { 0x2c41c6, 0x2c4197, 0xa7873e80d747bfe4, 0xe1cfa035d1eff900, 0, 198 }, /* #6 */
    { 0x133e13, 0x133697, 0xa7873e80d747bfe4, 0xe1cfa035d1eff900, 0, 198 }, /* #6 b */
    { 0x2d6682, 0x2d6e17, 0xd5bf7252eb00221c, 0x6004438000000000, 0, 165 }, /* #7 */
    { 0x121957, 0x121917, 0xd5bf7252eb00221c, 0x6004438000000000, 0, 165 }, /* #7 b */
    { 0x090793, 0x090716, 0xfcb81c099923ca53, 0x04cc91e529800000, 0, 215 }, /* #8 */
    { 0x367846, 0x367016, 0xfcb81c099923ca53, 0x04cc91e529800000, 0, 215 }, /* #8 b */
    { 0x1a2f17, 0x1a2797, 0x2d15da60b391dc4b, 0x8000000000000000, 0, 191 }, /* #9 */
    { 0x2550c2, 0x255097, 0x2d15da60b391dc4b, 0x8000000000000000, 0, 191 }, /* #9 b */
    { 0x3a04d7, 0x3a0c13, 0x665fffe362efb148, 0x32ffff1b177d8a40, 0, 195 }, /* #10 */
    { 0x057b02, 0x057b13, 0x665fffe362efb148, 0x32ffff1b177d8a40, 0, 195 }, /* #10 b */
    { 0x270cd2, 0x270497, 0x37901dfaf6d76696, 0xaecd2c0000000000, 0, 105 }, /* #11 */
    { 0x187307, 0x187397, 0x37901dfaf6d76696, 0xaecd2c0000000000, 0, 105 }, /* #11 b */
    { 0x2c7c13, 0x2c7416, 0xaba50dc0355b08e5, 0x3940000000000000, 0, 118 }, /* #12 */
    { 0x1303c6, 0x130316, 0xaba50dc0355b08e5, 0x3940000000000000, 0, 118 }, /* #12 b */
    { 0x283cd6, 0x283c96, 0x0fd84d5bc9bbe966, 0x9ab79377d2cc0000, 0, 81 }, /* #13 */
    { 0x174303, 0x174b96, 0x0fd84d5bc9bbe966, 0x9ab79377d2cc0000, 0, 81 }, /* #13 b */
    { 0x3a1c96, 0x3a1416, 0x3112e76faab48338, 0x76faab4833800000, 0, 148 }, /* #14 */
    { 0x056343, 0x056316, 0x3112e76faab48338, 0x76faab4833800000, 0, 148 }, /* #14 b */
    { 0x390482, 0x390497, 0x4df02679c1f259f6, 0xf259f60000000000, 0, 232 }, /* #15 */
    { 0x067b57, 0x067397, 0x4df02679c1f259f6, 0xf259f60000000000, 0, 232 }, /* #15 b */
    { 0x321816, 0x321016, 0x2a22e28d4c800a47, 0x0052380000000000, 0, 107 }, /* #16 */
    { 0x0d67c3, 0x0d6716, 0x2a22e28d4c800a47, 0x0052380000000000, 0, 107 }, /* #16 b */
    { 0x3f3843, 0x3f3817, 0x9cb6b5340ac63ca2, 0x4400000000000000, 0, 121 }, /* #17 */
    { 0x004796, 0x004f17, 0x9cb6b5340ac63ca2, 0x4400000000000000, 0, 121 }, /* #17 b */
    { 0x3860c2, 0x386896, 0x56c217cfa6d89b65, 0xc217cfa6d89b6500, 0, 136 }, /* #18 */
    { 0x071f17, 0x071f96, 0x56c217cfa6d89b65, 0xc217cfa6d89b6500, 0, 136 }, /* #18 b */
    { 0x104746, 0x104f96, 0xb81b4574590c52f8, 0x97c0000000000000, 0, 115 }, /* #19 */
    { 0x2f3893, 0x2f3896, 0xb81b4574590c52f8, 0x97c0000000000000, 0, 115 }, /* #19 b */
    { 0x017a52, 0x017216, 0x387a8c65b218c62c, 0x318b000000000000, 0, 174 }, /* #20 */
    { 0x3e0587, 0x3e0516, 0x387a8c65b218c62c, 0x318b000000000000, 0, 174 }, /* #20 b */
    { 0x3402d6, 0x340216, 0x7c1c6483df5ab4ed, 0x38c907beb569da00, 0, 73 }, /* #21 */
    { 0x0b7d03, 0x0b7516, 0x7c1c6483df5ab4ed, 0x38c907beb569da00, 0, 73 }, /* #21 b */
    { 0x2a7503, 0x2a7516, 0x0b8f84e66ea9c431, 0x1880000000000000, 0, 247 }, /* #22 */
    { 0x150ad6, 0x150216, 0x0b8f84e66ea9c431, 0x1880000000000000, 0, 247 }, /* #22 b */
    { 0x010247, 0x010216, 0x77b1f7ff4318696f, 0x61a5bc0000000000, 0, 234 }, /* #23 */
    { 0x3e7d92, 0x3e7516, 0x77b1f7ff4318696f, 0x61a5bc0000000000, 0, 234 }, /* #23 b */
    { 0x373317, 0x373316, 0xf1a90f2999d8f0cc, 0x6600000000000000, 0, 55 }, /* #24 */
    { 0x084cc2, 0x084416, 0xf1a90f2999d8f0cc, 0x6600000000000000, 0, 55 }, /* #24 b */
    { 0x244f03, 0x244716, 0x6b3641608a5273e3, 0x6c82c114a4e7c600, 0, 201 }, /* #25 */
    { 0x1b30d6, 0x1b3016, 0x6b3641608a5273e3, 0x6c82c114a4e7c600, 0, 201 }, /* #25 b */
    { 0x126607, 0x126e96, 0x94ae6e336ea8ee33, 0xe330000000000000, 0, 180 }, /* #26 */
    { 0x2d19d2, 0x2d1996, 0x94ae6e336ea8ee33, 0xe330000000000000, 0, 180 }, /* #26 b */
    { 0x325442, 0x325c96, 0xb0ae4901a057039d, 0xd02b81ce80000000, 0, 159 }, /* #27 */
    { 0x0d2b97, 0x0d2b96, 0xb0ae4901a057039d, 0xd02b81ce80000000, 0, 159 }, /* #27 b */
    { 0x1a36d7, 0x1a3697, 0x560cda5211481f83, 0x9b4a422903f06000, 0, 205 }, /* #28 */
    { 0x254902, 0x254197, 0x560cda5211481f83, 0x9b4a422903f06000, 0, 205 }, /* #28 b */
    { 0x021e02, 0x021e96, 0x726eaca6b4db6f66, 0xdb6f660000000000, 0, 40 }, /* #29 */
    { 0x3d61d7, 0x3d6996, 0x726eaca6b4db6f66, 0xdb6f660000000000, 0, 40 }, /* #29 b */
    { 0x346216, 0x346a96, 0xbabf96c22c954087, 0xa043800000000000, 0, 175 }, /* #30 */
    { 0x0b1dc3, 0x0b1d96, 0xbabf96c22c954087, 0xa043800000000000, 0, 175 }, /* #30 b */
    { 0x2b26d7, 0x2b2697, 0x0c7dd62c449bbca4, 0xde52000000000000, 0, 239 }, /* #31 */
    { 0x145902, 0x145197, 0x0c7dd62c449bbca4, 0xde52000000000000, 0, 239 }, /* #31 b */
    { 0x1457c6, 0x145797, 0x3ae0697975d03f20, 0xe400000000000000, 0, 245 }, /* #32 */
    { 0x2b2813, 0x2b2097, 0x3ae0697975d03f20, 0xe400000000000000, 0, 245 }, /* #32 b */
    { 0x3869d7, 0x386996, 0xa2ab76a7516e5571, 0xb76a7516e5571000, 0, 140 }, /* #33 */
    { 0x071602, 0x071e96, 0xa2ab76a7516e5571, 0xb76a7516e5571000, 0, 140 }, /* #33 b */
    { 0x211c07, 0x211c17, 0xa1058d0012fef6ee, 0x7b77000000000000, 0, 239 }, /* #34 */
    { 0x1e63d2, 0x1e6b17, 0xa1058d0012fef6ee, 0x7b77000000000000, 0, 239 }, /* #34 b */
    { 0x033316, 0x033316, 0xadaa5ae0dc641147, 0x6e3208a380000000, 0, 95 }, /* #35 */
    { 0x3c4cc3, 0x3c4416, 0xadaa5ae0dc641147, 0x6e3208a380000000, 0, 95 }, /* #35 b */
    { 0x232383, 0x232b17, 0x56c55e77ace1b73e, 0x579deb386dcf8000, 0, 78 }, /* #36 */
    { 0x1c5c56, 0x1c5c17, 0x56c55e77ace1b73e, 0x579deb386dcf8000, 0, 78 }, /* #36 b */
    { 0x2d2c46, 0x2d2497, 0x0763b795e10abaa5, 0xb795e10abaa50000, 0, 208 }, /* #37 */
    { 0x125393, 0x125397, 0x0763b795e10abaa5, 0xb795e10abaa50000, 0, 208 }, /* #37 b */
    { 0x2907c6, 0x290f96, 0x520e436c5452f3f4, 0xfd00000000000000, 0, 182 }, /* #38 */
    { 0x167813, 0x167896, 0x520e436c5452f3f4, 0xfd00000000000000, 0, 182 }, /* #38 b */
    { 0x1b7142, 0x1b7197, 0xcd242027a33c51e3, 0x9a48404f4678a3c6, 0, 1  }, /* #39 */
    { 0x240e97, 0x240697, 0xcd242027a33c51e3, 0x9a48404f4678a3c6, 0, 1  }, /* #39 b */
    { 0x0a3a87, 0x0a3297, 0x8e6395627f643efd, 0xcab13fb21f7e8000, 0, 79 }, /* #40 */
    { 0x354552, 0x354597, 0x8e6395627f643efd, 0xcab13fb21f7e8000, 0, 79 }, /* #40 b */
    { 0x285d06, 0x285d06, 0x65c767e0203a93f3, 0x65c767e0203a93f3, 0, 128 }, /* #41 */
    { 0x1722d3, 0x1722d3, 0x65c767e0203a93f3, 0x65c767e0203a93f3, 0, 128 }, /* #41 b */
    { 0x393183, 0x393917, 0x8e495561dd7d50e2, 0x5438800000000000, 0, 110 }, /* #42 */
    { 0x064e56, 0x064e17, 0x8e495561dd7d50e2, 0x5438800000000000, 0, 110 }, /* #42 b */
    { 0x030b86, 0x030316, 0x438583bd8504e1d1, 0x4e1d100000000000, 0, 236 }, /* #43 */
    { 0x3c7453, 0x3c7416, 0x438583bd8504e1d1, 0x4e1d100000000000, 0, 236 }, /* #43 b */
    { 0x290996, 0x290996, 0x6bad79eaafcfae13, 0xafcfae1300000000, 0, 224 }, /* #44 */
    { 0x167643, 0x167e96, 0x6bad79eaafcfae13, 0xafcfae1300000000, 0, 224 }, /* #44 b */
    { 0x343006, 0x343896, 0x7401e12ccb982e36, 0xcb982e3600000000, 0, 96 }, /* #45 */
    { 0x0b4fd3, 0x0b4f96, 0x7401e12ccb982e36, 0xcb982e3600000000, 0, 96 }, /* #45 b */
    { 0x283982, 0x283197, 0xa60bff3fe2d36ad9, 0xfe2d36ad90000000, 0, 156 }, /* #46 */
    { 0x174657, 0x174697, 0xa60bff3fe2d36ad9, 0xfe2d36ad90000000, 0, 156 }, /* #46 b */
    { 0x0a3dc2, 0x0a3d96, 0x1ced14930272485e, 0xf000000000000000, 0, 187 }, /* #47 */
    { 0x354217, 0x354a96, 0x1ced14930272485e, 0xf000000000000000, 0, 187 }, /* #47 b */
    { 0x093887, 0x093097, 0x830f9b6ff9b9860c, 0xe6dbfe6e61830000, 0, 206 }, /* #48 */
    { 0x364752, 0x364797, 0x830f9b6ff9b9860c, 0xe6dbfe6e61830000, 0, 206 }, /* #48 b */
    { 0x0429c6, 0x042996, 0x6615a11503ae4489, 0xd08a81d722448000, 0, 15 }, /* #49 */
    { 0x3b5613, 0x3b5e96, 0x6615a11503ae4489, 0xd08a81d722448000, 0, 15 }, /* #49 b */
    { 0x167613, 0x167e96, 0x97c49ab9e3b55c63, 0xf1daae3180000000, 0, 223 }, /* #50 */
    { 0x2909c6, 0x290996, 0x97c49ab9e3b55c63, 0xf1daae3180000000, 0, 223 }, /* #50 b */
    { 0x296d06, 0x296d17, 0x6a837e7a3735c2ba, 0x5d00000000000000, 0, 55 }, /* #51 */
    { 0x1612d3, 0x161a17, 0x6a837e7a3735c2ba, 0x5d00000000000000, 0, 55 }, /* #51 b */
    { 0x306986, 0x306996, 0x649cb5631c21a41a, 0xd20d000000000000, 0, 47 }, /* #52 */
    { 0x0f1653, 0x0f1e96, 0x649cb5631c21a41a, 0xd20d000000000000, 0, 47 }, /* #52 b */
    { 0x1d2b13, 0x1d2397, 0x355ab797287f2cde, 0xca1fcb3780000000, 0, 222 }, /* #53 */
    { 0x2254c6, 0x225497, 0x355ab797287f2cde, 0xca1fcb3780000000, 0, 222 }, /* #53 b */
    { 0x3d2e56, 0x3d2616, 0x9db8c550b280ac6f, 0x2b1bc00000000000, 0, 110 }, /* #54 */
    { 0x025183, 0x025116, 0x9db8c550b280ac6f, 0x2b1bc00000000000, 0, 110 }, /* #54 b */
    { 0x2e3793, 0x2e3f17, 0x78c1e2a238d63b18, 0x078a88e358ec6000, 0, 202 }, /* #55 */
    { 0x114846, 0x114817, 0x78c1e2a238d63b18, 0x078a88e358ec6000, 0, 202 }, /* #55 b */
    { 0x024917, 0x024996, 0x32b5f0417100e8d4, 0x8000000000000000, 0, 61 }, /* #56 */
    { 0x3d36c2, 0x3d3e96, 0x32b5f0417100e8d4, 0x8000000000000000, 0, 61 }, /* #56 b */
    { 0x222213, 0x222a57, 0xe5ae27b4aec8624e, 0x0000000000000000, 0, 191 }, /* #57 */
    { 0x1d5dc6, 0x1d5d57, 0xe5ae27b4aec8624e, 0x0000000000000000, 0, 191 }, /* #57 b */
    { 0x1e7dc6, 0x1e7d17, 0x43fb295eb1714739, 0x4739000000000000, 0, 48 }, /* #58 */
    { 0x210213, 0x210a17, 0x43fb295eb1714739, 0x4739000000000000, 0, 48 }, /* #58 b */
    { 0x1669c2, 0x166996, 0x97c927c965412496, 0x9f25950492580000, 0, 82 }, /* #59 */
    { 0x291617, 0x291e96, 0x97c927c965412496, 0x9f25950492580000, 0, 82 }, /* #59 b */
    { 0x087256, 0x087297, 0x4ae3bdb6b2e5c4ed, 0xdedb5972e2768000, 0, 79 }, /* #60 */
    { 0x370d83, 0x370597, 0x4ae3bdb6b2e5c4ed, 0xdedb5972e2768000, 0, 79 }, /* #60 b */
    { 0x3305d3, 0x330597, 0xc1e6a80098ee40e5, 0xca00000000000000, 0, 249 }, /* #61 */
    { 0x0c7a06, 0x0c7297, 0xc1e6a80098ee40e5, 0xca00000000000000, 0, 249 }, /* #61 b */
    { 0x342b82, 0x342312, 0xa896c477eed42055, 0x25b11dfbb5081540, 0, 70 }, /* #62 */
    { 0x0b5457, 0x0b5412, 0xa896c477eed42055, 0x25b11dfbb5081540, 0, 70 }, /* #62 b */
    { 0x2d4ec7, 0x2d4e17, 0x480d0fae13e4a501, 0x4040000000000000, 0, 118 }, /* #63 */
    { 0x123112, 0x123917, 0x480d0fae13e4a501, 0x4040000000000000, 0, 118 }, /* #63 b */
    { 0x0767c7, 0x076797, 0x91f28ef8856e6239, 0x9000000000000000, 0, 252 }, /* #64 */
    { 0x381812, 0x381097, 0x91f28ef8856e6239, 0x9000000000000000, 0, 252 }, /* #64 b */
    { 0x292303, 0x292b96, 0x1e12602b6f817c76, 0xec00000000000000, 0, 121 }, /* #65 */
    { 0x165cd6, 0x165c96, 0x1e12602b6f817c76, 0xec00000000000000, 0, 121 }, /* #65 b */
    { 0x3c6712, 0x3c6f17, 0x8c54041295b7a779, 0x5b7a779000000000, 0, 228 }, /* #66 */
    { 0x0318c7, 0x031817, 0x8c54041295b7a779, 0x5b7a779000000000, 0, 228 }, /* #66 b */
    { 0x1a2912, 0x1a2917, 0xcdb58adb887e1580, 0x0fc2b00000000000, 0, 229 }, /* #67 */
    { 0x2556c7, 0x255e17, 0xcdb58adb887e1580, 0x0fc2b00000000000, 0, 229 }, /* #67 b */
    { 0x3c7952, 0x3c7917, 0x136bb2dd8516abd7, 0x0a2d57ae00000000, 0, 33 }, /* #68 */
    { 0x030687, 0x030e17, 0x136bb2dd8516abd7, 0x0a2d57ae00000000, 0, 33 }, /* #68 b */
    { 0x356b43, 0x356397, 0x4d36f9711d1ebdae, 0xf2e23a3d7b5c0000, 0, 81 }, /* #69 */
    { 0x0a1496, 0x0a1497, 0x4d36f9711d1ebdae, 0xf2e23a3d7b5c0000, 0, 81 }, /* #69 b */
    { 0x220806, 0x220896, 0x590558a44d5064bb, 0xd5064bb000000000, 0, 164 }, /* #70 */
    { 0x1d77d3, 0x1d7f96, 0x590558a44d5064bb, 0xd5064bb000000000, 0, 164 }, /* #70 b */
    { 0x2b4346, 0x2b4b17, 0xfde5aa0b57d09117, 0x0911700000000000, 0, 236 }, /* #71 */
    { 0x143c93, 0x143c17, 0xfde5aa0b57d09117, 0x0911700000000000, 0, 236 }, /* #71 b */
    { 0x116017, 0x116016, 0x7fd1077fa28e98ca, 0x77fa28e98ca00000, 0, 148 }, /* #72 */
    { 0x2e1fc2, 0x2e1716, 0x7fd1077fa28e98ca, 0x77fa28e98ca00000, 0, 148 }, /* #72 b */
    { 0x094452, 0x094c96, 0x34b529e0353a074c, 0xc000000000000000, 0, 252 }, /* #73 */
    { 0x363b87, 0x363b96, 0x34b529e0353a074c, 0xc000000000000000, 0, 252 }, /* #73 b */
    { 0x232593, 0x232516, 0x349688fead0256e3, 0x12b7180000000000, 0, 171 }, /* #74 */
    { 0x1c5a46, 0x1c5216, 0x349688fead0256e3, 0x12b7180000000000, 0, 171 }, /* #74 b */
    { 0x3f5802, 0x3f5896, 0x6ed2f99c8cf32448, 0xd2f99c8cf3244800, 0, 200 }, /* #75 */
    { 0x0027d7, 0x002f96, 0x6ed2f99c8cf32448, 0xd2f99c8cf3244800, 0, 200 }, /* #75 b */
    { 0x3b1152, 0x3b1996, 0x675f89b7bb16177a, 0xc585de8000000000, 0, 102 }, /* #76 */
    { 0x046e87, 0x046e96, 0x675f89b7bb16177a, 0xc585de8000000000, 0, 102 }, /* #76 b */
    { 0x370fd2, 0x370f17, 0x33edad58b06fad97, 0x160df5b2e0000000, 0, 221 }, /* #77 */
    { 0x087007, 0x087817, 0x33edad58b06fad97, 0x160df5b2e0000000, 0, 221 }, /* #77 b */
    { 0x155c42, 0x155497, 0xdd823c17b66fabf4, 0xfa00000000000000, 0, 247 }, /* #78 */
    { 0x2a2397, 0x2a2397, 0xdd823c17b66fabf4, 0xfa00000000000000, 0, 247 }, /* #78 b */
    { 0x3e0fd7, 0x3e0f92, 0xcf55360c5edd3f08, 0xf55360c5edd3f080, 0, 132 }, /* #79 */
    { 0x017002, 0x017892, 0xcf55360c5edd3f08, 0xf55360c5edd3f080, 0, 132 }, /* #79 b */
    { 0x2e0703, 0x2e0716, 0x1562407e5e109fa9, 0x213f520000000000, 0, 41 }, /* #80 */
    { 0x1178d6, 0x117016, 0x1562407e5e109fa9, 0x213f520000000000, 0, 41 }, /* #80 b */
    { 0x3f54c2, 0x3f5416, 0x338152838c0940dc, 0x06e0000000000000, 0, 179 }, /* #81 */
    { 0x002b17, 0x002316, 0x338152838c0940dc, 0x06e0000000000000, 0, 179 }, /* #81 b */
    { 0x235703, 0x235716, 0x7caea6ba7efab1cb, 0x3960000000000000, 0, 117 }, /* #82 */
    { 0x1c28d6, 0x1c2016, 0x7caea6ba7efab1cb, 0x3960000000000000, 0, 117 }, /* #82 b */
    { 0x287dc3, 0x287597, 0xc5cf0acc64e05c59, 0x9381716400000000, 0, 226 }, /* #83 */
    { 0x170216, 0x170297, 0xc5cf0acc64e05c59, 0x9381716400000000, 0, 226 }, /* #83 b */
    { 0x121992, 0x121996, 0xa2b9e3c4b454ab4b, 0xa55a580000000000, 0, 171 }, /* #84 */
    { 0x2d6647, 0x2d6e96, 0xa2b9e3c4b454ab4b, 0xa55a580000000000, 0, 171 }, /* #84 b */
    { 0x032ec2, 0x032616, 0x6aade785bff3009f, 0x7c00000000000000, 0, 122 }, /* #85 */
    { 0x3c5117, 0x3c5116, 0x6aade785bff3009f, 0x7c00000000000000, 0, 122 }, /* #85 b */
    { 0x215f06, 0x215716, 0x9a1a770c2b58e8c7, 0x69dc30ad63a31c00, 0, 10 }, /* #86 */
    { 0x1e20d3, 0x1e2016, 0x9a1a770c2b58e8c7, 0x69dc30ad63a31c00, 0, 10 }, /* #86 b */
    { 0x0466c2, 0x046e96, 0xd2bb87e606141df8, 0xc283bf0000000000, 0, 165 }, /* #87 */
    { 0x3b1917, 0x3b1996, 0xd2bb87e606141df8, 0xc283bf0000000000, 0, 165 }, /* #87 b */
    { 0x0f5682, 0x0f5e96, 0x97588c4613d6414a, 0x9eb20a5000000000, 0, 163 }, /* #88 */
    { 0x302957, 0x302996, 0x97588c4613d6414a, 0x9eb20a5000000000, 0, 163 }, /* #88 b */
    { 0x3a0e13, 0x3a0697, 0x4f4d707a1ffbd8a9, 0xec54800000000000, 0, 111 }, /* #89 */
    { 0x0571c6, 0x057197, 0x4f4d707a1ffbd8a9, 0xec54800000000000, 0, 111 }, /* #89 b */
    { 0x215147, 0x215917, 0x9540e7f0b2fc5926, 0x039fc2cbf1649800, 0, 74 }, /* #90 */
    { 0x1e2e92, 0x1e2e17, 0x9540e7f0b2fc5926, 0x039fc2cbf1649800, 0, 74 }, /* #90 b */
    { 0x3d0593, 0x3d0597, 0x431df02acb4f4c5b, 0x8000000000000000, 0, 255 }, /* #91 */
    { 0x027a46, 0x027297, 0x431df02acb4f4c5b, 0x8000000000000000, 0, 255 }, /* #91 b */
    { 0x1d1106, 0x1d1116, 0xfd4b5858321db8bc, 0x58321db8bc000000, 0, 216 }, /* #92 */
    { 0x226ed3, 0x226616, 0xfd4b5858321db8bc, 0x58321db8bc000000, 0, 216 }, /* #92 b */
    { 0x121c16, 0x121c17, 0x58d574d6a9717957, 0x35aa5c5e55c00000, 0, 86 }, /* #93 */
    { 0x2d63c3, 0x2d6b17, 0x58d574d6a9717957, 0x35aa5c5e55c00000, 0, 86 }, /* #93 b */
    { 0x133857, 0x133016, 0xb7310c408f2d8bbc, 0x431023cb62ef0000, 0, 14 }, /* #94 */
    { 0x2c4782, 0x2c4716, 0xb7310c408f2d8bbc, 0x431023cb62ef0000, 0, 14 }, /* #94 b */
    { 0x350912, 0x350996, 0x5d2f4ca7a8425e17, 0x84bc2e0000000000, 0, 233 }, /* #95 */
    { 0x0a76c7, 0x0a7e96, 0x5d2f4ca7a8425e17, 0x84bc2e0000000000, 0, 233 }, /* #95 b */
};
uint32_t const g_cTests_shl_u64_amd = RT_ELEMENTS(g_aTests_shl_u64_amd);

BINU64_TEST_T const g_aTests_shr_u64_amd[] =
{
    { 0x154152, 0x154156, 0x0000000000000000, 0x0000000000000000, 0, 202 }, /* #0 */
    { 0x2a3e87, 0x2a3656, 0x0000000000000000, 0x0000000000000000, 0, 202 }, /* #0 b */
    { 0x134453, 0x134456, 0x0000000000000000, 0x0000000000000000, 0, 86 }, /* #1 */
    { 0x2c3b86, 0x2c3356, 0x0000000000000000, 0x0000000000000000, 0, 86 }, /* #1 b */
    { 0x0f4ac2, 0x0f4256, 0x0000000000000000, 0x0000000000000000, 0, 24 }, /* #2 */
    { 0x303517, 0x303556, 0x0000000000000000, 0x0000000000000000, 0, 24 }, /* #2 b */
    { 0x0b72c7, 0x0b7256, 0x0000000000000000, 0x0000000000000000, 0, 19 }, /* #3 */
    { 0x340d12, 0x340556, 0x0000000000000000, 0x0000000000000000, 0, 19 }, /* #3 b */
    { 0x236d46, 0x236556, 0x0000000000000000, 0x0000000000000000, 0, 141 }, /* #4 */
    { 0x1c1293, 0x1c1256, 0x0000000000000000, 0x0000000000000000, 0, 141 }, /* #4 b */
    { 0x2d0d46, 0x2d0556, 0x0000000000000000, 0x0000000000000000, 0, 222 }, /* #5 */
    { 0x127293, 0x127256, 0x0000000000000000, 0x0000000000000000, 0, 222 }, /* #5 b */
    { 0x1d5246, 0x1d5213, 0x653f6da727c6afcb, 0x000ca7edb4e4f8d5, 0, 11 }, /* #6 */
    { 0x222d93, 0x222513, 0x653f6da727c6afcb, 0x000ca7edb4e4f8d5, 0, 11 }, /* #6 b */
    { 0x0e5516, 0x0e5556, 0x03b43e510ef62bc7, 0x0000000000000000, 0, 189 }, /* #7 */
    { 0x312ac3, 0x312256, 0x03b43e510ef62bc7, 0x0000000000000000, 0, 189 }, /* #7 b */
    { 0x3f3f17, 0x3f3713, 0x3975eec0ec5abe17, 0x0003975eec0ec5ab, 0, 140 }, /* #8 */
    { 0x0040c2, 0x004013, 0x3975eec0ec5abe17, 0x0003975eec0ec5ab, 0, 140 }, /* #8 b */
    { 0x174993, 0x174113, 0xaf04519d39ff67fd, 0x0000000af04519d3, 0, 92 }, /* #9 */
    { 0x283646, 0x283613, 0xaf04519d39ff67fd, 0x0000000af04519d3, 0, 92 }, /* #9 b */
    { 0x263f52, 0x263717, 0xe374bb650c9c3562, 0x00000000038dd2ed, 0, 230 }, /* #10 */
    { 0x194087, 0x194017, 0xe374bb650c9c3562, 0x00000000038dd2ed, 0, 230 }, /* #10 b */
    { 0x1c5857, 0x1c5017, 0x97f60c001c33f85a, 0x00000004bfb06000, 0, 29 }, /* #11 */
    { 0x232782, 0x232717, 0x97f60c001c33f85a, 0x00000004bfb06000, 0, 29 }, /* #11 b */
    { 0x2b4557, 0x2b4513, 0xdb45dfb93616ed8d, 0x00000000000db45d, 0, 172 }, /* #12 */
    { 0x143a82, 0x143213, 0xdb45dfb93616ed8d, 0x00000000000db45d, 0, 172 }, /* #12 b */
    { 0x336883, 0x336017, 0xe4429d1f32657a55, 0x00000000072214e8, 0, 165 }, /* #13 */
    { 0x0c1756, 0x0c1717, 0xe4429d1f32657a55, 0x00000000072214e8, 0, 165 }, /* #13 b */
    { 0x291156, 0x291112, 0xcc7e4774dd323a01, 0x00000cc7e4774dd3, 0, 20 }, /* #14 */
    { 0x166e83, 0x166612, 0xcc7e4774dd323a01, 0x00000cc7e4774dd3, 0, 20 }, /* #14 b */
    { 0x2e3e02, 0x2e3612, 0xcad00d29cc692454, 0x000000032b4034a7, 0, 30 }, /* #15 */
    { 0x1141d7, 0x114112, 0xcad00d29cc692454, 0x000000032b4034a7, 0, 30 }, /* #15 b */
    { 0x346587, 0x346512, 0x410d2bffb4091819, 0x0000000000000104, 0, 182 }, /* #16 */
    { 0x0b1a52, 0x0b1212, 0x410d2bffb4091819, 0x0000000000000104, 0, 182 }, /* #16 b */
    { 0x163682, 0x163617, 0xc95a26948229d8d3, 0x0000000000192b44, 0, 43 }, /* #17 */
    { 0x294957, 0x294117, 0xc95a26948229d8d3, 0x0000000000192b44, 0, 43 }, /* #17 b */
    { 0x396286, 0x396213, 0xf2e1de364a8f0254, 0x00001e5c3bc6c951, 0, 83 }, /* #18 */
    { 0x061d53, 0x061513, 0xf2e1de364a8f0254, 0x00001e5c3bc6c951, 0, 83 }, /* #18 b */
    { 0x0f5182, 0x0f5117, 0x87fd32e21efd4dc6, 0x00000021ff4cb887, 0, 90 }, /* #19 */
    { 0x302e57, 0x302617, 0x87fd32e21efd4dc6, 0x00000021ff4cb887, 0, 90 }, /* #19 b */
    { 0x083d97, 0x083517, 0xfcbb7f0339c32cf0, 0x000000000003f2ed, 0, 238 }, /* #20 */
    { 0x374242, 0x374217, 0xfcbb7f0339c32cf0, 0x000000000003f2ed, 0, 238 }, /* #20 b */
    { 0x337293, 0x337213, 0x350b5d073da9494c, 0x0000001a85ae839e, 0, 153 }, /* #21 */
    { 0x0c0d46, 0x0c0513, 0x350b5d073da9494c, 0x0000001a85ae839e, 0, 153 }, /* #21 b */
    { 0x057a17, 0x057216, 0x8ddb4a7e51940901, 0x000000008ddb4a7e, 0, 32 }, /* #22 */
    { 0x3a05c2, 0x3a0516, 0x8ddb4a7e51940901, 0x000000008ddb4a7e, 0, 32 }, /* #22 b */
    { 0x236442, 0x236412, 0x28439dea0fd4fd54, 0x0000000028439dea, 0, 32 }, /* #23 */
    { 0x1c1b97, 0x1c1312, 0x28439dea0fd4fd54, 0x0000000028439dea, 0, 32 }, /* #23 b */
    { 0x012216, 0x012212, 0x218ee21520c2fd78, 0x0000000000000002, 0, 188 }, /* #24 */
    { 0x3e5dc3, 0x3e5512, 0x218ee21520c2fd78, 0x0000000000000002, 0, 188 }, /* #24 b */
    { 0x1e3bd6, 0x1e3317, 0xfba1cf34b8bde761, 0x000007dd0e79a5c5, 0, 85 }, /* #25 */
    { 0x214403, 0x214417, 0xfba1cf34b8bde761, 0x000007dd0e79a5c5, 0, 85 }, /* #25 b */
    { 0x007d47, 0x007517, 0x1eba9efafef656c4, 0x000000000001eba9, 0, 172 }, /* #26 */
    { 0x3f0292, 0x3f0217, 0x1eba9efafef656c4, 0x000000000001eba9, 0, 172 }, /* #26 b */
    { 0x262cd2, 0x262413, 0xc04659f3db4a9fe0, 0x000000000060232c, 0, 169 }, /* #27 */
    { 0x195307, 0x195313, 0xc04659f3db4a9fe0, 0x000000000060232c, 0, 169 }, /* #27 b */
    { 0x067cc2, 0x067412, 0x3eb16a212cfbab64, 0x0fac5a884b3eead9, 0, 130 }, /* #28 */
    { 0x390317, 0x390312, 0x3eb16a212cfbab64, 0x0fac5a884b3eead9, 0, 130 }, /* #28 b */
    { 0x101b43, 0x101312, 0x40c5f1b197858c6b, 0x000000040c5f1b19, 0, 220 }, /* #29 */
    { 0x2f6496, 0x2f6412, 0x40c5f1b197858c6b, 0x000000040c5f1b19, 0, 220 }, /* #29 b */
    { 0x2a2b02, 0x2a2316, 0xe44dbc880c495c58, 0x000000000039136f, 0, 42 }, /* #30 */
    { 0x1554d7, 0x155416, 0xe44dbc880c495c58, 0x000000000039136f, 0, 42 }, /* #30 b */
    { 0x0663c2, 0x066313, 0x63c06732d1926b44, 0x00c780ce65a324d6, 0, 199 }, /* #31 */
    { 0x391c17, 0x391413, 0x63c06732d1926b44, 0x00c780ce65a324d6, 0, 199 }, /* #31 b */
    { 0x2d7a93, 0x2d7212, 0x1a818c83238a828f, 0x000000001a818c83, 0, 224 }, /* #32 */
    { 0x120546, 0x120512, 0x1a818c83238a828f, 0x000000001a818c83, 0, 224 }, /* #32 b */
    { 0x342107, 0x342117, 0x9bf8e8f4984027dc, 0x09bf8e8f4984027d, 0, 132 }, /* #33 */
    { 0x0b5ed2, 0x0b5617, 0x9bf8e8f4984027dc, 0x09bf8e8f4984027d, 0, 132 }, /* #33 b */
    { 0x0003d3, 0x000312, 0x5887d10dcb1a0238, 0x0000b10fa21b9634, 0, 15 }, /* #34 */
    { 0x3f7c06, 0x3f7412, 0x5887d10dcb1a0238, 0x0000b10fa21b9634, 0, 15 }, /* #34 b */
    { 0x104793, 0x104716, 0x2f86253eae69001b, 0x00000be1894fab9a, 0, 210 }, /* #35 */
    { 0x2f3846, 0x2f3016, 0x2f86253eae69001b, 0x00000be1894fab9a, 0, 210 }, /* #35 b */
    { 0x0d6a06, 0x0d6212, 0x0c6305416cf60772, 0x063182a0b67b03b9, 0, 193 }, /* #36 */
    { 0x3215d3, 0x321512, 0x0c6305416cf60772, 0x063182a0b67b03b9, 0, 193 }, /* #36 b */
    { 0x1f4812, 0x1f4013, 0x23214c3eb24a2a55, 0x000000000000008c, 0, 118 }, /* #37 */
    { 0x2037c7, 0x203713, 0x23214c3eb24a2a55, 0x000000000000008c, 0, 118 }, /* #37 b */
    { 0x114796, 0x114717, 0x56fc3124c150aac8, 0x0000002b7e189260, 0, 25 }, /* #38 */
    { 0x2e3843, 0x2e3017, 0x56fc3124c150aac8, 0x0000002b7e189260, 0, 25 }, /* #38 b */
    { 0x150692, 0x150616, 0x196d73a3a6070f0e, 0x0000000032dae747, 0, 95 }, /* #39 */
    { 0x2a7947, 0x2a7116, 0x196d73a3a6070f0e, 0x0000000032dae747, 0, 95 }, /* #39 b */
    { 0x170792, 0x170712, 0xc9492c5434341cb6, 0x0001929258a86868, 0, 143 }, /* #40 */
    { 0x287847, 0x287012, 0xc9492c5434341cb6, 0x0001929258a86868, 0, 143 }, /* #40 b */
    { 0x1e7313, 0x1e7316, 0xd7bb8038bfdf379a, 0x01af7700717fbe6f, 0, 135 }, /* #41 */
    { 0x210cc6, 0x210416, 0xd7bb8038bfdf379a, 0x01af7700717fbe6f, 0, 135 }, /* #41 b */
    { 0x2a2a97, 0x2a2216, 0x6e9ab6c3c267d42c, 0x00000006e9ab6c3c, 0, 28 }, /* #42 */
    { 0x155542, 0x155516, 0x6e9ab6c3c267d42c, 0x00000006e9ab6c3c, 0, 28 }, /* #42 b */
    { 0x311282, 0x311212, 0x61322602dc8bd87d, 0x0000000000613226, 0, 40 }, /* #43 */
    { 0x0e6d57, 0x0e6512, 0x61322602dc8bd87d, 0x0000000000613226, 0, 40 }, /* #43 b */
    { 0x072d13, 0x072513, 0x36cd1fc0cc0087b3, 0x00000006d9a3f819, 0, 91 }, /* #44 */
    { 0x3852c6, 0x385213, 0x36cd1fc0cc0087b3, 0x00000006d9a3f819, 0, 91 }, /* #44 b */
    { 0x013fc7, 0x013712, 0xa706ab27a0dd64d4, 0x0000000000000538, 0, 117 }, /* #45 */
    { 0x3e4012, 0x3e4012, 0xa706ab27a0dd64d4, 0x0000000000000538, 0, 117 }, /* #45 b */
    { 0x0a1c12, 0x0a1416, 0x61972117660348a8, 0x000000000000000c, 0, 59 }, /* #46 */
    { 0x3563c7, 0x356316, 0x61972117660348a8, 0x000000000000000c, 0, 59 }, /* #46 b */
    { 0x2a78c6, 0x2a7017, 0xc3037faa64290cbd, 0x06181bfd53214865, 0, 69 }, /* #47 */
    { 0x150713, 0x150717, 0xc3037faa64290cbd, 0x06181bfd53214865, 0, 69 }, /* #47 b */
    { 0x244b96, 0x244312, 0x4e7d490e1ce63858, 0x00004e7d490e1ce6, 0, 144 }, /* #48 */
    { 0x1b3443, 0x1b3412, 0x4e7d490e1ce63858, 0x00004e7d490e1ce6, 0, 144 }, /* #48 b */
    { 0x1a5b53, 0x1a5317, 0xa63e4aa7d985e7f0, 0x000298f92a9f6617, 0, 142 }, /* #49 */
    { 0x252486, 0x252417, 0xa63e4aa7d985e7f0, 0x000298f92a9f6617, 0, 142 }, /* #49 b */
    { 0x2f6846, 0x2f6012, 0xe15564f11f3c143f, 0x000000001c2aac9e, 0, 35 }, /* #50 */
    { 0x101793, 0x101712, 0xe15564f11f3c143f, 0x000000001c2aac9e, 0, 35 }, /* #50 b */
    { 0x063517, 0x063512, 0x9dc7394833073384, 0x0000000000000002, 0, 62 }, /* #51 */
    { 0x394ac2, 0x394212, 0x9dc7394833073384, 0x0000000000000002, 0, 62 }, /* #51 b */
    { 0x217a93, 0x217217, 0x56ef2a50e1541408, 0x0000000000000add, 0, 243 }, /* #52 */
    { 0x1e0546, 0x1e0517, 0x56ef2a50e1541408, 0x0000000000000add, 0, 243 }, /* #52 b */
    { 0x213d06, 0x213517, 0xce4d80ac31ace672, 0x003393602b0c6b39, 0, 138 }, /* #53 */
    { 0x1e42d3, 0x1e4217, 0xce4d80ac31ace672, 0x003393602b0c6b39, 0, 138 }, /* #53 b */
    { 0x063a02, 0x063213, 0x42e105e072ea8579, 0x00000010b841781c, 0, 154 }, /* #54 */
    { 0x3945d7, 0x394513, 0x42e105e072ea8579, 0x00000010b841781c, 0, 154 }, /* #54 b */
    { 0x0c3a07, 0x0c3216, 0x2de37fe115fd60e1, 0x0000000005bc6ffc, 0, 35 }, /* #55 */
    { 0x3345d2, 0x334516, 0x2de37fe115fd60e1, 0x0000000005bc6ffc, 0, 35 }, /* #55 b */
    { 0x2e37c3, 0x2e3712, 0x07cd0b009ca1e147, 0x000000f9a1601394, 0, 211 }, /* #56 */
    { 0x114816, 0x114012, 0x07cd0b009ca1e147, 0x000000f9a1601394, 0, 211 }, /* #56 b */
    { 0x372816, 0x372016, 0xcc1645c07373235b, 0x0330591701cdcc8d, 0, 70 }, /* #57 */
    { 0x0857c3, 0x085716, 0xcc1645c07373235b, 0x0330591701cdcc8d, 0, 70 }, /* #57 b */
    { 0x074a96, 0x074213, 0xba9227d4cb7c02a7, 0x00000000002ea489, 0, 42 }, /* #58 */
    { 0x383543, 0x383513, 0xba9227d4cb7c02a7, 0x00000000002ea489, 0, 42 }, /* #58 b */
    { 0x347052, 0x347012, 0x6992067d9ef41126, 0x0000000000006992, 0, 176 }, /* #59 */
    { 0x0b0f87, 0x0b0712, 0x6992067d9ef41126, 0x0000000000006992, 0, 176 }, /* #59 b */
    { 0x115f16, 0x115716, 0x430f69f8ac437e27, 0x000000000002187b, 0, 45 }, /* #60 */
    { 0x2e20c3, 0x2e2016, 0x430f69f8ac437e27, 0x000000000002187b, 0, 45 }, /* #60 b */
    { 0x271c57, 0x271416, 0xf498d8df66373d4a, 0x03d263637d98dcf5, 0, 70 }, /* #61 */
    { 0x186382, 0x186316, 0xf498d8df66373d4a, 0x03d263637d98dcf5, 0, 70 }, /* #61 b */
    { 0x067046, 0x067016, 0x9c63361246c89ba8, 0x000000009c633612, 0, 32 }, /* #62 */
    { 0x390f93, 0x390716, 0x9c63361246c89ba8, 0x000000009c633612, 0, 32 }, /* #62 b */
    { 0x190217, 0x190213, 0x47e95886a519e869, 0x00047e95886a519e, 0, 76 }, /* #63 */
    { 0x267dc2, 0x267513, 0x47e95886a519e869, 0x00047e95886a519e, 0, 76 }, /* #63 b */
    { 0x343853, 0x343016, 0x82bca380502840e5, 0x0000000001057947, 0, 231 }, /* #64 */
    { 0x0b4786, 0x0b4716, 0x82bca380502840e5, 0x0000000001057947, 0, 231 }, /* #64 b */
    { 0x3d1493, 0x3d1412, 0xa55e2c177251ff83, 0x0000000000000001, 0, 255 }, /* #65 */
    { 0x026b46, 0x026312, 0xa55e2c177251ff83, 0x0000000000000001, 0, 255 }, /* #65 b */
    { 0x342543, 0x342517, 0x1c455c8da37bea16, 0x0000000000000003, 0, 123 }, /* #66 */
    { 0x0b5a96, 0x0b5217, 0x1c455c8da37bea16, 0x0000000000000003, 0, 123 }, /* #66 b */
    { 0x1a0f42, 0x1a0717, 0xd26035d62f21c646, 0x00000034980d758b, 0, 218 }, /* #67 */
    { 0x257097, 0x257017, 0xd26035d62f21c646, 0x00000034980d758b, 0, 218 }, /* #67 b */
    { 0x3f0fd3, 0x3f0717, 0xf864f96171f1c790, 0x0000000000001f0c, 0, 51 }, /* #68 */
    { 0x007006, 0x007017, 0xf864f96171f1c790, 0x0000000000001f0c, 0, 51 }, /* #68 b */
    { 0x0f4046, 0x0f4012, 0x2f27863ea1b3fb0e, 0x0000000000000179, 0, 117 }, /* #69 */
    { 0x303f93, 0x303712, 0x2f27863ea1b3fb0e, 0x0000000000000179, 0, 117 }, /* #69 b */
    { 0x126643, 0x126617, 0xff980f74510197d8, 0x003fe603dd144065, 0, 74 }, /* #70 */
    { 0x2d1996, 0x2d1117, 0xff980f74510197d8, 0x003fe603dd144065, 0, 74 }, /* #70 b */
    { 0x3c4587, 0x3c4556, 0x21dad3194e405631, 0x0000000000000000, 0, 127 }, /* #71 */
    { 0x033a52, 0x033256, 0x21dad3194e405631, 0x0000000000000000, 0, 127 }, /* #71 b */
    { 0x1905d6, 0x190513, 0x275a5e7cc9214582, 0x00000000009d6979, 0, 230 }, /* #72 */
    { 0x267a03, 0x267213, 0x275a5e7cc9214582, 0x00000000009d6979, 0, 230 }, /* #72 b */
    { 0x3b5113, 0x3b5113, 0x865472c4abd17cbd, 0x0000000000021951, 0, 238 }, /* #73 */
    { 0x042ec6, 0x042613, 0x865472c4abd17cbd, 0x0000000000021951, 0, 238 }, /* #73 b */
    { 0x183647, 0x183613, 0x41e891a8ac11c242, 0x000000000107a246, 0, 102 }, /* #74 */
    { 0x274992, 0x274113, 0x41e891a8ac11c242, 0x000000000107a246, 0, 102 }, /* #74 b */
    { 0x0c1082, 0x0c1013, 0x20fe60b1f0e55826, 0x0000000000000083, 0, 54 }, /* #75 */
    { 0x336f57, 0x336713, 0x20fe60b1f0e55826, 0x0000000000000083, 0, 54 }, /* #75 b */
    { 0x194282, 0x194212, 0xb9e59dc66867d936, 0x00000000000173cb, 0, 175 }, /* #76 */
    { 0x263d57, 0x263512, 0xb9e59dc66867d936, 0x00000000000173cb, 0, 175 }, /* #76 b */
    { 0x351b06, 0x351312, 0xe3f7a040be48e60d, 0x038fde8102f92398, 0, 6  }, /* #77 */
    { 0x0a64d3, 0x0a6412, 0xe3f7a040be48e60d, 0x038fde8102f92398, 0, 6  }, /* #77 b */
    { 0x122052, 0x122013, 0xfd3ce4c535db0175, 0x0000000000000001, 0, 191 }, /* #78 */
    { 0x2d5f87, 0x2d5713, 0xfd3ce4c535db0175, 0x0000000000000001, 0, 191 }, /* #78 b */
    { 0x0f3787, 0x0f3716, 0xc0e2fd6fc1707ffe, 0x000000060717eb7e, 0, 221 }, /* #79 */
    { 0x304852, 0x304016, 0xc0e2fd6fc1707ffe, 0x000000060717eb7e, 0, 221 }, /* #79 b */
    { 0x031717, 0x031717, 0x1f01e41c4db3eae3, 0x000000000003e03c, 0, 43 }, /* #80 */
    { 0x3c68c2, 0x3c6017, 0x1f01e41c4db3eae3, 0x000000000003e03c, 0, 43 }, /* #80 b */
    { 0x323852, 0x323013, 0x5b057393754f1564, 0x000005b057393754, 0, 148 }, /* #81 */
    { 0x0d4787, 0x0d4713, 0x5b057393754f1564, 0x000005b057393754, 0, 148 }, /* #81 b */
    { 0x2c20d6, 0x2c2016, 0x9efe10d814216efe, 0x000000009efe10d8, 0, 160 }, /* #82 */
    { 0x135f03, 0x135716, 0x9efe10d814216efe, 0x000000009efe10d8, 0, 160 }, /* #82 b */
    { 0x0d09d7, 0x0d0117, 0xc2c25f5d0adc433d, 0x0000061612fae856, 0, 21 }, /* #83 */
    { 0x327602, 0x327617, 0xc2c25f5d0adc433d, 0x0000061612fae856, 0, 21 }, /* #83 b */
    { 0x314297, 0x314212, 0xcf253d401060fb96, 0x000000cf253d4010, 0, 88 }, /* #84 */
    { 0x0e3d42, 0x0e3512, 0xcf253d401060fb96, 0x000000cf253d4010, 0, 88 }, /* #84 b */
    { 0x184796, 0x184717, 0xed87de6f60456b4e, 0x1db0fbcdec08ad69, 0, 195 }, /* #85 */
    { 0x273843, 0x273017, 0xed87de6f60456b4e, 0x1db0fbcdec08ad69, 0, 195 }, /* #85 b */
    { 0x143c46, 0x143413, 0x1614a974255e5ca6, 0x000005852a5d0957, 0, 210 }, /* #86 */
    { 0x2b4393, 0x2b4313, 0x1614a974255e5ca6, 0x000005852a5d0957, 0, 210 }, /* #86 b */
    { 0x227593, 0x227513, 0xd5d45b363c549833, 0x0000000000000001, 0, 63 }, /* #87 */
    { 0x1d0a46, 0x1d0213, 0xd5d45b363c549833, 0x0000000000000001, 0, 63 }, /* #87 b */
    { 0x024bc3, 0x024313, 0xe9a91ea1a2be06b0, 0x00000000000000e9, 0, 56 }, /* #88 */
    { 0x3d3416, 0x3d3413, 0xe9a91ea1a2be06b0, 0x00000000000000e9, 0, 56 }, /* #88 b */
    { 0x224ac6, 0x224217, 0x65e287405579a77b, 0x32f143a02abcd3bd, 0, 1  }, /* #89 */
    { 0x1d3513, 0x1d3517, 0x65e287405579a77b, 0x32f143a02abcd3bd, 0, 1  }, /* #89 b */
    { 0x0c29c6, 0x0c2116, 0xe47bf1cbcb9fbe23, 0x000000001c8f7e39, 0, 35 }, /* #90 */
    { 0x335613, 0x335616, 0xe47bf1cbcb9fbe23, 0x000000001c8f7e39, 0, 35 }, /* #90 b */
    { 0x352c53, 0x352416, 0x4eedf3990732a8e3, 0x0013bb7ce641ccaa, 0, 74 }, /* #91 */
    { 0x0a5386, 0x0a5316, 0x4eedf3990732a8e3, 0x0013bb7ce641ccaa, 0, 74 }, /* #91 b */
    { 0x3a5587, 0x3a5517, 0xa3d59976c561022c, 0x000000147ab32ed8, 0, 91 }, /* #92 */
    { 0x052a52, 0x052217, 0xa3d59976c561022c, 0x000000147ab32ed8, 0, 91 }, /* #92 b */
    { 0x3460c3, 0x346016, 0x311a2e58b197fbe3, 0x00000062345cb163, 0, 151 }, /* #93 */
    { 0x0b1f16, 0x0b1716, 0x311a2e58b197fbe3, 0x00000062345cb163, 0, 151 }, /* #93 b */
    { 0x2b0506, 0x2b0517, 0xbf6d6bb9d3350b20, 0x002fdb5aee74cd42, 0, 10 }, /* #94 */
    { 0x147ad3, 0x147217, 0xbf6d6bb9d3350b20, 0x002fdb5aee74cd42, 0, 10 }, /* #94 b */
    { 0x134617, 0x134656, 0x173f2a0089a8871f, 0x0000000000000000, 0, 191 }, /* #95 */
    { 0x2c39c2, 0x2c3156, 0x173f2a0089a8871f, 0x0000000000000000, 0, 191 }, /* #95 b */
};
uint32_t const g_cTests_shr_u64_amd = RT_ELEMENTS(g_aTests_shr_u64_amd);

BINU64_TEST_T const g_aTests_sar_u64_amd[] =
{
    { 0x347507, 0x347556, 0x0000000000000000, 0x0000000000000000, 0, 159 }, /* #0 */
    { 0x0b0ad2, 0x0b0256, 0x0000000000000000, 0x0000000000000000, 0, 159 }, /* #0 b */
    { 0x186a86, 0x186256, 0x0000000000000000, 0x0000000000000000, 0, 147 }, /* #1 */
    { 0x271553, 0x271556, 0x0000000000000000, 0x0000000000000000, 0, 147 }, /* #1 b */
    { 0x374d46, 0x374556, 0x0000000000000000, 0x0000000000000000, 0, 204 }, /* #2 */
    { 0x083293, 0x083256, 0x0000000000000000, 0x0000000000000000, 0, 204 }, /* #2 b */
    { 0x203a03, 0x203256, 0x0000000000000000, 0x0000000000000000, 0, 89 }, /* #3 */
    { 0x1f45d6, 0x1f4556, 0x0000000000000000, 0x0000000000000000, 0, 89 }, /* #3 b */
    { 0x3426c2, 0x342656, 0x0000000000000000, 0x0000000000000000, 0, 242 }, /* #4 */
    { 0x0b5917, 0x0b5156, 0x0000000000000000, 0x0000000000000000, 0, 242 }, /* #4 b */
    { 0x2231d2, 0x223156, 0x0000000000000000, 0x0000000000000000, 0, 81 }, /* #5 */
    { 0x1d4e07, 0x1d4656, 0x0000000000000000, 0x0000000000000000, 0, 81 }, /* #5 b */
    { 0x354053, 0x354092, 0xd4c196d39a9c710b, 0xfff53065b4e6a71c, 0, 74 }, /* #6 */
    { 0x0a3f86, 0x0a3792, 0xd4c196d39a9c710b, 0xfff53065b4e6a71c, 0, 74 }, /* #6 b */
    { 0x073a96, 0x073216, 0x22915423f588b6ad, 0x0000000004522a84, 0, 99 }, /* #7 */
    { 0x384543, 0x384516, 0x22915423f588b6ad, 0x0000000004522a84, 0, 99 }, /* #7 b */
    { 0x1945d3, 0x194593, 0xd3bdb6bd413745a6, 0xfffffffffffa77b6, 0, 107 }, /* #8 */
    { 0x263a06, 0x263293, 0xd3bdb6bd413745a6, 0xfffffffffffa77b6, 0, 107 }, /* #8 b */
    { 0x161b03, 0x161312, 0x705fb9f4029c7f26, 0x000000000000000e, 0, 251 }, /* #9 */
    { 0x2964d6, 0x296412, 0x705fb9f4029c7f26, 0x000000000000000e, 0, 251 }, /* #9 b */
    { 0x144443, 0x144497, 0xc41fbe40a40dc579, 0xffffffffffffe20f, 0, 177 }, /* #10 */
    { 0x2b3b96, 0x2b3397, 0xc41fbe40a40dc579, 0xffffffffffffe20f, 0, 177 }, /* #10 b */
    { 0x321652, 0x321616, 0x4c9ef41105f4d450, 0x000000000993de82, 0, 99 }, /* #11 */
    { 0x0d6987, 0x0d6116, 0x4c9ef41105f4d450, 0x000000000993de82, 0, 99 }, /* #11 b */
    { 0x393983, 0x393116, 0x6d434bfdd2ae3d6f, 0x0000036a1a5fee95, 0, 21 }, /* #12 */
    { 0x064656, 0x064616, 0x6d434bfdd2ae3d6f, 0x0000036a1a5fee95, 0, 21 }, /* #12 b */
    { 0x2f2357, 0x2f2313, 0x12985d7c1983a835, 0x094c2ebe0cc1d41a, 0, 65 }, /* #13 */
    { 0x105c82, 0x105413, 0x12985d7c1983a835, 0x094c2ebe0cc1d41a, 0, 65 }, /* #13 b */
    { 0x236212, 0x236217, 0x07ef0402f4035997, 0x000000000fde0805, 0, 95 }, /* #14 */
    { 0x1c1dc7, 0x1c1517, 0x07ef0402f4035997, 0x000000000fde0805, 0, 95 }, /* #14 b */
    { 0x226186, 0x226192, 0x8e7446e133b86321, 0xf8e7446e133b8632, 0, 4  }, /* #15 */
    { 0x1d1e53, 0x1d1692, 0x8e7446e133b86321, 0xf8e7446e133b8632, 0, 4  }, /* #15 b */
    { 0x2d0b16, 0x2d0397, 0x8d76d4e9264e0a10, 0xfffffffffe35db53, 0, 230 }, /* #16 */
    { 0x1274c3, 0x127497, 0x8d76d4e9264e0a10, 0xfffffffffe35db53, 0, 230 }, /* #16 b */
    { 0x261cd7, 0x261416, 0x345009386063be04, 0x0000000000003450, 0, 48 }, /* #17 */
    { 0x196302, 0x196316, 0x345009386063be04, 0x0000000000003450, 0, 48 }, /* #17 b */
    { 0x0c0a17, 0x0c0297, 0xff80eb988cf45ee0, 0xffffffffffffffff, 0, 186 }, /* #18 */
    { 0x3375c2, 0x337597, 0xff80eb988cf45ee0, 0xffffffffffffffff, 0, 186 }, /* #18 b */
    { 0x282052, 0x282056, 0x15ca0407cc35a49c, 0x0000000000000000, 0, 190 }, /* #19 */
    { 0x175f87, 0x175756, 0x15ca0407cc35a49c, 0x0000000000000000, 0, 190 }, /* #19 b */
    { 0x0f18d7, 0x0f1016, 0x044658b50469e532, 0x0044658b50469e53, 0, 68 }, /* #20 */
    { 0x306702, 0x306716, 0x044658b50469e532, 0x0044658b50469e53, 0, 68 }, /* #20 b */
    { 0x307707, 0x307797, 0xfba1f5c5afd8b24d, 0xfffffffdd0fae2d7, 0, 25 }, /* #21 */
    { 0x0f08d2, 0x0f0097, 0xfba1f5c5afd8b24d, 0xfffffffdd0fae2d7, 0, 25 }, /* #21 b */
    { 0x2d0d42, 0x2d0517, 0x0d68d519a1ba4a5f, 0x0000000000001ad1, 0, 47 }, /* #22 */
    { 0x127297, 0x127217, 0x0d68d519a1ba4a5f, 0x0000000000001ad1, 0, 47 }, /* #22 b */
    { 0x215297, 0x215216, 0x78039a2c0c0a4c00, 0x1e00e68b03029300, 0, 66 }, /* #23 */
    { 0x1e2d42, 0x1e2516, 0x78039a2c0c0a4c00, 0x1e00e68b03029300, 0, 66 }, /* #23 b */
    { 0x236bd2, 0x236392, 0xcbf8bd9476c62a24, 0xffffffffffff97f1, 0, 175 }, /* #24 */
    { 0x1c1407, 0x1c1492, 0xcbf8bd9476c62a24, 0xffffffffffff97f1, 0, 175 }, /* #24 b */
    { 0x292146, 0x292196, 0xb6d3af0e530fde6c, 0xdb69d7872987ef36, 0, 65 }, /* #25 */
    { 0x165e93, 0x165696, 0xb6d3af0e530fde6c, 0xdb69d7872987ef36, 0, 65 }, /* #25 b */
    { 0x1b3117, 0x1b3197, 0xf4fad8297f7c3ad6, 0xffffffffffffffff, 0, 191 }, /* #26 */
    { 0x244ec2, 0x244697, 0xf4fad8297f7c3ad6, 0xffffffffffffffff, 0, 191 }, /* #26 b */
    { 0x076cd7, 0x076496, 0xfa12c66407ed8280, 0xffd09633203f6c14, 0, 5  }, /* #27 */
    { 0x381302, 0x381396, 0xfa12c66407ed8280, 0xffd09633203f6c14, 0, 5  }, /* #27 b */
    { 0x1a7712, 0x1a7796, 0xafb7e25e9492c4d2, 0xffffffff5f6fc4bd, 0, 159 }, /* #28 */
    { 0x2508c7, 0x250096, 0xafb7e25e9492c4d2, 0xffffffff5f6fc4bd, 0, 159 }, /* #28 b */
    { 0x2b5d83, 0x2b5592, 0xfe7ae2a2a4924337, 0xfffff3d715152492, 0, 141 }, /* #29 */
    { 0x142256, 0x142292, 0xfe7ae2a2a4924337, 0xfffff3d715152492, 0, 141 }, /* #29 b */
    { 0x171a87, 0x171217, 0x2d555b0f67ce9bc7, 0x0016aaad87b3e74d, 0, 9  }, /* #30 */
    { 0x286552, 0x286517, 0x2d555b0f67ce9bc7, 0x0016aaad87b3e74d, 0, 9  }, /* #30 b */
    { 0x3c2a17, 0x3c2216, 0x4cab70bae0825542, 0x00000000002655b8, 0, 169 }, /* #31 */
    { 0x0355c2, 0x035516, 0x4cab70bae0825542, 0x00000000002655b8, 0, 169 }, /* #31 b */
    { 0x010317, 0x010397, 0xe1170fe31815574f, 0xffff08b87f18c0aa, 0, 13 }, /* #32 */
    { 0x3e7cc2, 0x3e7497, 0xe1170fe31815574f, 0xffff08b87f18c0aa, 0, 13 }, /* #32 b */
    { 0x2b2652, 0x2b2696, 0xfb3380325f7ec2fd, 0xffffffffffffffff, 0, 251 }, /* #33 */
    { 0x145987, 0x145196, 0xfb3380325f7ec2fd, 0xffffffffffffffff, 0, 251 }, /* #33 b */
    { 0x1c0857, 0x1c0016, 0x32f672be1942d61a, 0x00000197b395f0ca, 0, 21 }, /* #34 */
    { 0x237782, 0x237716, 0x32f672be1942d61a, 0x00000197b395f0ca, 0, 21 }, /* #34 b */
    { 0x092a97, 0x092296, 0xed857c80b452e246, 0xfffffff6c2be405a, 0, 217 }, /* #35 */
    { 0x365542, 0x365596, 0xed857c80b452e246, 0xfffffff6c2be405a, 0, 217 }, /* #35 b */
    { 0x1c1412, 0x1c1412, 0xd51d4c7f67b1f830, 0xd51d4c7f67b1f830, 0, 128 }, /* #36 */
    { 0x236bc7, 0x236bc7, 0xd51d4c7f67b1f830, 0xd51d4c7f67b1f830, 0, 128 }, /* #36 b */
    { 0x056746, 0x056797, 0xf837415f19392b04, 0xffffe0dd057c64e4, 0, 206 }, /* #37 */
    { 0x3a1893, 0x3a1097, 0xf837415f19392b04, 0xffffe0dd057c64e4, 0, 206 }, /* #37 b */
    { 0x230ed7, 0x230692, 0xe814baafcc255977, 0xffffffffffffffd0, 0, 183 }, /* #38 */
    { 0x1c7102, 0x1c7192, 0xe814baafcc255977, 0xffffffffffffffd0, 0, 183 }, /* #38 b */
    { 0x1f1113, 0x1f1113, 0x0243ea6c9861e21d, 0x0000000000000243, 0, 112 }, /* #39 */
    { 0x206ec6, 0x206613, 0x0243ea6c9861e21d, 0x0000000000000243, 0, 112 }, /* #39 b */
    { 0x0b0d03, 0x0b0592, 0xa2e2064692584bf2, 0xffffffffd1710323, 0, 97 }, /* #40 */
    { 0x3472d6, 0x347292, 0xa2e2064692584bf2, 0xffffffffd1710323, 0, 97 }, /* #40 b */
    { 0x390413, 0x390417, 0x0a389756b48fc2b7, 0x0000000000014712, 0, 43 }, /* #41 */
    { 0x067bc6, 0x067317, 0x0a389756b48fc2b7, 0x0000000000014712, 0, 43 }, /* #41 b */
    { 0x373f83, 0x373713, 0x5bec382432397bc2, 0x00016fb0e090c8e5, 0, 206 }, /* #42 */
    { 0x084056, 0x084013, 0x5bec382432397bc2, 0x00016fb0e090c8e5, 0, 206 }, /* #42 b */
    { 0x1d4493, 0x1d4416, 0x4da56e0757c9020c, 0x00004da56e0757c9, 0, 144 }, /* #43 */
    { 0x223b46, 0x223316, 0x4da56e0757c9020c, 0x00004da56e0757c9, 0, 144 }, /* #43 b */
    { 0x0f2f16, 0x0f2797, 0xa581a43a08779f65, 0xfffffffffe960690, 0, 230 }, /* #44 */
    { 0x3050c3, 0x305097, 0xa581a43a08779f65, 0xfffffffffe960690, 0, 230 }, /* #44 b */
    { 0x165697, 0x165617, 0x6a87fae6976410c1, 0x0000001aa1feb9a5, 0, 218 }, /* #45 */
    { 0x292942, 0x292117, 0x6a87fae6976410c1, 0x0000001aa1feb9a5, 0, 218 }, /* #45 b */
    { 0x377cc7, 0x377497, 0xae31b7bfe46338fa, 0xfffffffeb8c6deff, 0, 30 }, /* #46 */
    { 0x080312, 0x080397, 0xae31b7bfe46338fa, 0xfffffffeb8c6deff, 0, 30 }, /* #46 b */
    { 0x176586, 0x176593, 0xe1dd0e9f0b5a7d5f, 0xffffffc3ba1d3e16, 0, 23 }, /* #47 */
    { 0x281a53, 0x281293, 0xe1dd0e9f0b5a7d5f, 0xffffffc3ba1d3e16, 0, 23 }, /* #47 b */
    { 0x091887, 0x091093, 0xd6e6ea8467739b83, 0xffffffffffff5b9b, 0, 174 }, /* #48 */
    { 0x366752, 0x366793, 0xd6e6ea8467739b83, 0xffffffffffff5b9b, 0, 174 }, /* #48 b */
    { 0x0a7d82, 0x0a7596, 0xb41036b5f5535d44, 0xffffffed040dad7d, 0, 154 }, /* #49 */
    { 0x350257, 0x350296, 0xb41036b5f5535d44, 0xffffffed040dad7d, 0, 154 }, /* #49 b */
    { 0x3a49c3, 0x3a4196, 0xf26df8711995b05e, 0xffffff26df871199, 0, 148 }, /* #50 */
    { 0x053616, 0x053696, 0xf26df8711995b05e, 0xffffff26df871199, 0, 148 }, /* #50 b */
    { 0x282283, 0x282292, 0xc6b6376981055b70, 0xf8d6c6ed3020ab6e, 0, 195 }, /* #51 */
    { 0x175d56, 0x175592, 0xc6b6376981055b70, 0xf8d6c6ed3020ab6e, 0, 195 }, /* #51 b */
    { 0x2b13d2, 0x2b1396, 0x8ee976e33c2998b8, 0xfffe3ba5db8cf0a6, 0, 142 }, /* #52 */
    { 0x146c07, 0x146496, 0x8ee976e33c2998b8, 0xfffe3ba5db8cf0a6, 0, 142 }, /* #52 b */
    { 0x1b1b12, 0x1b1397, 0x84908cbfd7ab9fed, 0xffffffffffff8490, 0, 240 }, /* #53 */
    { 0x2464c7, 0x246497, 0x84908cbfd7ab9fed, 0xffffffffffff8490, 0, 240 }, /* #53 b */
    { 0x3b7b06, 0x3b7316, 0x5172fff27d139849, 0x0000000005172fff, 0, 164 }, /* #54 */
    { 0x0404d3, 0x040416, 0x5172fff27d139849, 0x0000000005172fff, 0, 164 }, /* #54 b */
    { 0x027897, 0x027016, 0x7052a60941faac7e, 0x00000000007052a6, 0, 168 }, /* #55 */
    { 0x3d0742, 0x3d0716, 0x7052a60941faac7e, 0x00000000007052a6, 0, 168 }, /* #55 b */
    { 0x0d0d82, 0x0d0512, 0x51de762cf28f1d92, 0x00000000000028ef, 0, 177 }, /* #56 */
    { 0x327257, 0x327212, 0x51de762cf28f1d92, 0x00000000000028ef, 0, 177 }, /* #56 b */
    { 0x000bd2, 0x000313, 0x537b71a806b20d1f, 0x0000014dedc6a01a, 0, 150 }, /* #57 */
    { 0x3f7407, 0x3f7413, 0x537b71a806b20d1f, 0x0000014dedc6a01a, 0, 150 }, /* #57 b */
    { 0x361897, 0x361092, 0xf04c037841d0c171, 0xfffffffff82601bc, 0, 225 }, /* #58 */
    { 0x096742, 0x096792, 0xf04c037841d0c171, 0xfffffffff82601bc, 0, 225 }, /* #58 b */
    { 0x2d6712, 0x2d6712, 0x13fb796b1265b7a4, 0x0000000013fb796b, 0, 224 }, /* #59 */
    { 0x1218c7, 0x121012, 0x13fb796b1265b7a4, 0x0000000013fb796b, 0, 224 }, /* #59 b */
    { 0x3d0a03, 0x3d0297, 0x8e1eac2750afedb3, 0xe387ab09d42bfb6c, 0, 130 }, /* #60 */
    { 0x0275d6, 0x027597, 0x8e1eac2750afedb3, 0xe387ab09d42bfb6c, 0, 130 }, /* #60 b */
    { 0x017b56, 0x017b56, 0xb2817733be923b84, 0xb2817733be923b84, 0, 0  }, /* #61 */
    { 0x3e0483, 0x3e0483, 0xb2817733be923b84, 0xb2817733be923b84, 0, 0  }, /* #61 b */
    { 0x141917, 0x141197, 0xcbb83df264679255, 0xfffffffffffffcbb, 0, 180 }, /* #62 */
    { 0x2b66c2, 0x2b6697, 0xcbb83df264679255, 0xfffffffffffffcbb, 0, 180 }, /* #62 b */
    { 0x3c6757, 0x3c6793, 0xd1f6177fb9fff040, 0xfffffffff47d85df, 0, 226 }, /* #63 */
    { 0x031882, 0x031093, 0xd1f6177fb9fff040, 0xfffffffff47d85df, 0, 226 }, /* #63 b */
    { 0x305486, 0x305416, 0x43dc3f437b1a6cc9, 0x00000000000087b8, 0, 175 }, /* #64 */
    { 0x0f2b53, 0x0f2316, 0x43dc3f437b1a6cc9, 0x00000000000087b8, 0, 175 }, /* #64 b */
    { 0x3039d6, 0x303197, 0x9f3dc7775c025d56, 0xffffffffffffffe7, 0, 122 }, /* #65 */
    { 0x0f4603, 0x0f4697, 0x9f3dc7775c025d56, 0xffffffffffffffe7, 0, 122 }, /* #65 b */
    { 0x1a5d12, 0x1a5597, 0xae4e0251fb6a0868, 0xffffff5c9c04a3f6, 0, 151 }, /* #66 */
    { 0x2522c7, 0x252297, 0xae4e0251fb6a0868, 0xffffff5c9c04a3f6, 0, 151 }, /* #66 b */
    { 0x034843, 0x034093, 0x9571819c936a050c, 0xffffff2ae3033926, 0, 151 }, /* #67 */
    { 0x3c3796, 0x3c3793, 0x9571819c936a050c, 0xffffff2ae3033926, 0, 151 }, /* #67 b */
    { 0x1d0d06, 0x1d0597, 0xf92edcf2175f6a1a, 0xffc976e790bafb50, 0, 5  }, /* #68 */
    { 0x2272d3, 0x227297, 0xf92edcf2175f6a1a, 0xffc976e790bafb50, 0, 5  }, /* #68 b */
    { 0x290197, 0x290112, 0x16ba3b9a81baeb7c, 0x0000000000000b5d, 0, 241 }, /* #69 */
    { 0x167e42, 0x167612, 0x16ba3b9a81baeb7c, 0x0000000000000b5d, 0, 241 }, /* #69 b */
    { 0x376e92, 0x376656, 0x25020ddc80861d9c, 0x0000000000000000, 0, 127 }, /* #70 */
    { 0x081147, 0x081156, 0x25020ddc80861d9c, 0x0000000000000000, 0, 127 }, /* #70 b */
    { 0x191653, 0x191697, 0xa081dccb844834ca, 0xfffffffffffa081d, 0, 236 }, /* #71 */
    { 0x266986, 0x266197, 0xa081dccb844834ca, 0xfffffffffffa081d, 0, 236 }, /* #71 b */
    { 0x2a1a42, 0x2a1213, 0x390cb574f1721628, 0x000000000000e432, 0, 238 }, /* #72 */
    { 0x156597, 0x156513, 0x390cb574f1721628, 0x000000000000e432, 0, 238 }, /* #72 b */
    { 0x0c2c47, 0x0c2492, 0xa1c5a8a5c6b724a0, 0xfffffffffffffd0e, 0, 245 }, /* #73 */
    { 0x335392, 0x335392, 0xa1c5a8a5c6b724a0, 0xfffffffffffffd0e, 0, 245 }, /* #73 b */
    { 0x286046, 0x286097, 0xbc7bbc32f552848a, 0xffffffffffffff78, 0, 119 }, /* #74 */
    { 0x171f93, 0x171797, 0xbc7bbc32f552848a, 0xffffffffffffff78, 0, 119 }, /* #74 b */
    { 0x0b4ec3, 0x0b4696, 0xd5915c478d218c88, 0xfffffffffffffd59, 0, 52 }, /* #75 */
    { 0x343116, 0x343196, 0xd5915c478d218c88, 0xfffffffffffffd59, 0, 52 }, /* #75 b */
    { 0x1b56c7, 0x1b5617, 0x559e5d24899fbac3, 0x0000000001567974, 0, 102 }, /* #76 */
    { 0x242912, 0x242117, 0x559e5d24899fbac3, 0x0000000001567974, 0, 102 }, /* #76 b */
    { 0x0a6e93, 0x0a6613, 0x00816b22e211d42f, 0x00102d645c423a85, 0, 67 }, /* #77 */
    { 0x351146, 0x351113, 0x00816b22e211d42f, 0x00102d645c423a85, 0, 67 }, /* #77 b */
    { 0x033253, 0x033292, 0xb6e10d42a7ba484e, 0xfffffffffffff6dc, 0, 51 }, /* #78 */
    { 0x3c4d86, 0x3c4592, 0xb6e10d42a7ba484e, 0xfffffffffffff6dc, 0, 51 }, /* #78 b */
    { 0x026a53, 0x026216, 0x7a60de499d521ec0, 0x000000000f4c1bc9, 0, 99 }, /* #79 */
    { 0x3d1586, 0x3d1516, 0x7a60de499d521ec0, 0x000000000f4c1bc9, 0, 99 }, /* #79 b */
    { 0x2c3ad2, 0x2c3217, 0x4a0de14ff41cba57, 0x0000000000002506, 0, 177 }, /* #80 */
    { 0x134507, 0x134517, 0x4a0de14ff41cba57, 0x0000000000002506, 0, 177 }, /* #80 b */
    { 0x391156, 0x391113, 0x444e2da3d036e65e, 0x0011138b68f40db9, 0, 138 }, /* #81 */
    { 0x066e83, 0x066613, 0x444e2da3d036e65e, 0x0011138b68f40db9, 0, 138 }, /* #81 b */
    { 0x025ed7, 0x025693, 0xdcd0e61e532fa461, 0xffffffee68730f29, 0, 89 }, /* #82 */
    { 0x3d2102, 0x3d2193, 0xdcd0e61e532fa461, 0xffffffee68730f29, 0, 89 }, /* #82 b */
    { 0x294587, 0x294512, 0x517c93545ce73d97, 0x0517c93545ce73d9, 0, 196 }, /* #83 */
    { 0x163a52, 0x163212, 0x517c93545ce73d97, 0x0517c93545ce73d9, 0, 196 }, /* #83 b */
    { 0x2c10d2, 0x2c1016, 0x2fc14a5b23d7d86a, 0x000000000000bf05, 0, 174 }, /* #84 */
    { 0x136f07, 0x136716, 0x2fc14a5b23d7d86a, 0x000000000000bf05, 0, 174 }, /* #84 b */
    { 0x145196, 0x145113, 0x48cb1e91b44b8029, 0x0000000000024658, 0, 237 }, /* #85 */
    { 0x2b2e43, 0x2b2613, 0x48cb1e91b44b8029, 0x0000000000024658, 0, 237 }, /* #85 b */
    { 0x2d5947, 0x2d5112, 0x4ea9cfc8dd5e2088, 0x0000000000000002, 0, 253 }, /* #86 */
    { 0x122692, 0x122612, 0x4ea9cfc8dd5e2088, 0x0000000000000002, 0, 253 }, /* #86 b */
    { 0x0d2fc2, 0x0d2792, 0x82db63f95cbb267b, 0xffffffffffffffc1, 0, 185 }, /* #87 */
    { 0x325017, 0x325092, 0x82db63f95cbb267b, 0xffffffffffffffc1, 0, 185 }, /* #87 b */
    { 0x205956, 0x205193, 0xf8650cbc5ca684fd, 0xffffffffff8650cb, 0, 100 }, /* #88 */
    { 0x1f2683, 0x1f2693, 0xf8650cbc5ca684fd, 0xffffffffff8650cb, 0, 100 }, /* #88 b */
    { 0x0136d7, 0x013697, 0xcd50faf2e792a7f5, 0xfe6a87d7973c953f, 0, 133 }, /* #89 */
    { 0x3e4902, 0x3e4197, 0xcd50faf2e792a7f5, 0xfe6a87d7973c953f, 0, 133 }, /* #89 b */
    { 0x0e1806, 0x0e1017, 0x1f9c91458fa8fd86, 0x0000fce48a2c7d47, 0, 13 }, /* #90 */
    { 0x3167d3, 0x316717, 0x1f9c91458fa8fd86, 0x0000fce48a2c7d47, 0, 13 }, /* #90 b */
    { 0x0f7bc7, 0x0f7392, 0xca223fa13de31f65, 0xffffffffffffffe5, 0, 57 }, /* #91 */
    { 0x300412, 0x300492, 0xca223fa13de31f65, 0xffffffffffffffe5, 0, 57 }, /* #91 b */
    { 0x131e52, 0x131697, 0x98178833c014d6a3, 0xffffffff98178833, 0, 160 }, /* #92 */
    { 0x2c6187, 0x2c6197, 0x98178833c014d6a3, 0xffffffff98178833, 0, 160 }, /* #92 b */
    { 0x100953, 0x100192, 0xb35a79a5ca1def8e, 0xfffd9ad3cd2e50ef, 0, 205 }, /* #93 */
    { 0x2f7686, 0x2f7692, 0xb35a79a5ca1def8e, 0xfffd9ad3cd2e50ef, 0, 205 }, /* #93 b */
    { 0x1645c3, 0x164593, 0x831cd917bd885b38, 0xfffffffffffc18e6, 0, 109 }, /* #94 */
    { 0x293a16, 0x293293, 0x831cd917bd885b38, 0xfffffffffffc18e6, 0, 109 }, /* #94 b */
    { 0x2502c6, 0x250212, 0x2ef3b1500776692f, 0x01779d8a803bb349, 0, 69 }, /* #95 */
    { 0x1a7d13, 0x1a7512, 0x2ef3b1500776692f, 0x01779d8a803bb349, 0, 69 }, /* #95 b */
};
uint32_t const g_cTests_sar_u64_amd = RT_ELEMENTS(g_aTests_sar_u64_amd);

MULDIVU8_TEST_T const g_aTests_mul_u8_amd[] =
{
    { 0x231787, 0x231786, 0x0000, 0x0000, 0x00, 0 }, /* #0 */
    { 0x1d3192, 0x1d3192, 0x0000, 0x0000, 0x00, 0 }, /* #1 */
    { 0x232c87, 0x232486, 0x0000, 0x0000, 0x00, 0 }, /* #2 */
    { 0x136d46, 0x136546, 0x0000, 0x0000, 0x00, 0 }, /* #3 */
    { 0x3d7192, 0x3d7192, 0x0000, 0x0000, 0x00, 0 }, /* #4 */
    { 0x357c07, 0x357406, 0x0000, 0x0000, 0x00, 0 }, /* #5 */
    { 0x2a0702, 0x2a0702, 0x4db7, 0x0000, 0x00, 0 }, /* #6 */
    { 0x1a5b16, 0x1a5316, 0xd932, 0x0000, 0x00, 0 }, /* #7 */
    { 0x100a53, 0x100252, 0x846f, 0x0000, 0x00, 0 }, /* #8 */
    { 0x2d5292, 0x2d5292, 0x3290, 0x0000, 0x00, 0 }, /* #9 */
    { 0x224093, 0x224092, 0x9df3, 0x0000, 0x00, 0 }, /* #10 */
    { 0x314146, 0x314146, 0x6a93, 0x0000, 0x00, 0 }, /* #11 */
    { 0x337b47, 0x337b47, 0x0252, 0x2aec, 0x86, 0 }, /* #12 */
    { 0x387612, 0x387e13, 0x3dfa, 0x2cec, 0x2e, 0 }, /* #13 */
    { 0x155016, 0x155817, 0x3089, 0x6054, 0xb4, 0 }, /* #14 */
    { 0x140197, 0x140997, 0xff9d, 0x4b6f, 0x7b, 0 }, /* #15 */
    { 0x002916, 0x002917, 0x2535, 0x3496, 0xfe, 0 }, /* #16 */
    { 0x3b0b96, 0x3b0b97, 0x2df2, 0x5ac0, 0x60, 0 }, /* #17 */
    { 0x2234c2, 0x223cc3, 0xa18b, 0x7206, 0xd2, 0 }, /* #18 */
    { 0x2e0a12, 0x2e0a13, 0x8186, 0x54cc, 0xa2, 0 }, /* #19 */
    { 0x0268c6, 0x0268c7, 0xdddf, 0xb6ee, 0xd2, 0 }, /* #20 */
    { 0x1b1657, 0x1b1e57, 0x7d7c, 0x7060, 0xe8, 0 }, /* #21 */
    { 0x030992, 0x030192, 0xa701, 0x0034, 0x34, 0 }, /* #22 */
    { 0x1c2b46, 0x1c2b47, 0x0228, 0x2170, 0xd6, 0 }, /* #23 */
    { 0x041992, 0x041192, 0x1d03, 0x0060, 0x20, 0 }, /* #24 */
    { 0x067e12, 0x067e13, 0x5eea, 0x3d3e, 0x43, 0 }, /* #25 */
    { 0x1c2c02, 0x1c2c03, 0x545a, 0x1464, 0x3a, 0 }, /* #26 */
    { 0x2f75d6, 0x2f75d6, 0x1bdd, 0x0000, 0x00, 0 }, /* #27 */
    { 0x003c83, 0x003c83, 0x5d8a, 0x7134, 0xd2, 0 }, /* #28 */
    { 0x296b97, 0x296b97, 0xa315, 0x08f1, 0x6d, 0 }, /* #29 */
    { 0x0c71d7, 0x0c79d7, 0x8e61, 0x5f7c, 0xfc, 0 }, /* #30 */
    { 0x376e02, 0x376e03, 0x15c5, 0xbed8, 0xf8, 0 }, /* #31 */
    { 0x2247d2, 0x224fd3, 0xd0a2, 0x9c4e, 0xf7, 0 }, /* #32 */
    { 0x1817d3, 0x181fd3, 0x9e0e, 0x0d20, 0xf0, 0 }, /* #33 */
    { 0x3b7497, 0x3b7c97, 0xf589, 0x0336, 0x06, 0 }, /* #34 */
    { 0x3b04d7, 0x3b0cd7, 0x82bb, 0x0176, 0x02, 0 }, /* #35 */
    { 0x136ac3, 0x136ac3, 0xa495, 0x2d66, 0x4e, 0 }, /* #36 */
    { 0x006a52, 0x006a53, 0x543f, 0x381c, 0xe4, 0 }, /* #37 */
    { 0x1a3997, 0x1a3997, 0x9862, 0x01ea, 0x05, 0 }, /* #38 */
    { 0x1345d6, 0x134dd7, 0xae08, 0x06c0, 0xd8, 0 }, /* #39 */
    { 0x266c42, 0x266c43, 0xa7d4, 0x1804, 0x1d, 0 }, /* #40 */
    { 0x101cc3, 0x101cc3, 0x2656, 0x3264, 0x96, 0 }, /* #41 */
    { 0x006693, 0x006e93, 0x1fb7, 0x0393, 0x05, 0 }, /* #42 */
    { 0x2f7ac6, 0x2f7ac7, 0x12a4, 0x916c, 0xe3, 0 }, /* #43 */
    { 0x012412, 0x012c13, 0x5bd2, 0x396c, 0x46, 0 }, /* #44 */
    { 0x0a1683, 0x0a1e83, 0xae05, 0x04ec, 0xfc, 0 }, /* #45 */
    { 0x0e5bc7, 0x0e5bc7, 0x9936, 0x1d88, 0x8c, 0 }, /* #46 */
    { 0x390117, 0x390917, 0x938f, 0x7feb, 0xe5, 0 }, /* #47 */
    { 0x023dc3, 0x023dc3, 0x93d0, 0x28a0, 0x32, 0 }, /* #48 */
    { 0x2f1752, 0x2f1f53, 0xd8f1, 0x75ad, 0x7d, 0 }, /* #49 */
    { 0x3c3f87, 0x3c3f87, 0x84af, 0x33f4, 0x4c, 0 }, /* #50 */
    { 0x202ad2, 0x202ad3, 0x111d, 0x07b4, 0x44, 0 }, /* #51 */
    { 0x2e3bc2, 0x2e3bc3, 0x5668, 0x2700, 0x60, 0 }, /* #52 */
    { 0x251ec3, 0x251ec3, 0x4ec3, 0x6c2a, 0x8e, 0 }, /* #53 */
    { 0x3c0dd3, 0x3c0dd3, 0xa55b, 0x071c, 0x14, 0 }, /* #54 */
    { 0x396307, 0x396b07, 0x2f57, 0x4659, 0xcf, 0 }, /* #55 */
    { 0x3d0c42, 0x3d0c43, 0xaddc, 0x2418, 0x2a, 0 }, /* #56 */
    { 0x337f46, 0x337f47, 0x8b29, 0x1f64, 0xc4, 0 }, /* #57 */
    { 0x0474d7, 0x047cd7, 0x9158, 0x1a78, 0x4d, 0 }, /* #58 */
    { 0x134b52, 0x134b53, 0x767b, 0x6f78, 0xe8, 0 }, /* #59 */
    { 0x282dd7, 0x282dd7, 0x0c57, 0x030f, 0x09, 0 }, /* #60 */
    { 0x3b3f87, 0x3b3786, 0xab40, 0x0040, 0x01, 0 }, /* #61 */
    { 0x154b47, 0x154b47, 0x2cc6, 0x1ef0, 0x28, 0 }, /* #62 */
    { 0x2503d6, 0x250bd7, 0x8c57, 0x166e, 0x42, 0 }, /* #63 */
    { 0x3f7803, 0x3f7803, 0xc49e, 0x40ce, 0x69, 0 }, /* #64 */
    { 0x045d86, 0x045d87, 0x3d85, 0x3fe7, 0x7b, 0 }, /* #65 */
    { 0x131342, 0x131b43, 0xfac0, 0x5ac0, 0x79, 0 }, /* #66 */
    { 0x2f2187, 0x2f2987, 0x48a7, 0x1587, 0x21, 0 }, /* #67 */
    { 0x2f3c86, 0x2f3c87, 0x90e5, 0x862e, 0x96, 0 }, /* #68 */
    { 0x0d1347, 0x0d1b47, 0x4f12, 0x09fc, 0x8e, 0 }, /* #69 */
    { 0x315793, 0x315f93, 0xeb6d, 0x345f, 0x7b, 0 }, /* #70 */
    { 0x2c0686, 0x2c0e87, 0xe41b, 0x1677, 0xd5, 0 }, /* #71 */
    { 0x342792, 0x342f93, 0x9618, 0x1578, 0xe5, 0 }, /* #72 */
    { 0x0d6602, 0x0d6e03, 0xb188, 0x29f8, 0x4f, 0 }, /* #73 */
    { 0x240717, 0x240f17, 0xbfde, 0x62dc, 0x72, 0 }, /* #74 */
    { 0x0633c2, 0x063bc3, 0x61ce, 0xc6c2, 0xf7, 0 }, /* #75 */
    { 0x2e2486, 0x2e2c87, 0x8227, 0x0a83, 0x45, 0 }, /* #76 */
    { 0x227447, 0x227c47, 0xc28a, 0x5e56, 0xaf, 0 }, /* #77 */
    { 0x131983, 0x131983, 0x6ba4, 0xa170, 0xfc, 0 }, /* #78 */
    { 0x303993, 0x303993, 0xa041, 0x3db3, 0xf3, 0 }, /* #79 */
    { 0x024747, 0x024f47, 0xe33e, 0x0f04, 0x3e, 0 }, /* #80 */
    { 0x292ec3, 0x292ec3, 0x3343, 0x06ce, 0x1a, 0 }, /* #81 */
    { 0x2a6052, 0x2a6853, 0x6880, 0x1900, 0x32, 0 }, /* #82 */
    { 0x3835d7, 0x383dd7, 0x10b9, 0x6d1f, 0x97, 0 }, /* #83 */
    { 0x3b3a42, 0x3b3a43, 0xc0cb, 0x96aa, 0xbe, 0 }, /* #84 */
    { 0x066b57, 0x066b57, 0xe3f1, 0x70f8, 0x78, 0 }, /* #85 */
    { 0x113896, 0x113897, 0x12c4, 0xbea4, 0xf9, 0 }, /* #86 */
    { 0x105912, 0x105913, 0x8598, 0x5b70, 0x9a, 0 }, /* #87 */
    { 0x3a6dd7, 0x3a6dd7, 0x8b0f, 0x069f, 0x71, 0 }, /* #88 */
    { 0x2f2fc2, 0x2f2fc3, 0x5047, 0x0f88, 0x38, 0 }, /* #89 */
    { 0x1527c6, 0x152fc7, 0x8571, 0x592a, 0xca, 0 }, /* #90 */
    { 0x1b7f42, 0x1b7f43, 0x3740, 0x13c0, 0x4f, 0 }, /* #91 */
    { 0x103496, 0x103c97, 0x4cdc, 0x7e54, 0x93, 0 }, /* #92 */
    { 0x014896, 0x014897, 0xc032, 0x2af8, 0xdc, 0 }, /* #93 */
    { 0x381c16, 0x381c17, 0x1be2, 0x4236, 0x4b, 0 }, /* #94 */
    { 0x125712, 0x125f13, 0x2bba, 0x1458, 0x1c, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u8_amd = RT_ELEMENTS(g_aTests_mul_u8_amd);

MULDIVU8_TEST_T const g_aTests_imul_u8_amd[] =
{
    { 0x045487, 0x045486, 0x0000, 0x0000, 0x00, 0 }, /* #0 */
    { 0x136492, 0x136492, 0x0000, 0x0000, 0x00, 0 }, /* #1 */
    { 0x0b1d47, 0x0b1546, 0x0000, 0x0000, 0x00, 0 }, /* #2 */
    { 0x387797, 0x387796, 0x0000, 0x0000, 0x00, 0 }, /* #3 */
    { 0x1131d7, 0x1131d6, 0x0000, 0x0000, 0x00, 0 }, /* #4 */
    { 0x297413, 0x297412, 0x0000, 0x0000, 0x00, 0 }, /* #5 */
    { 0x0d6d57, 0x0d6556, 0x6d1e, 0x0000, 0x00, 0 }, /* #6 */
    { 0x105013, 0x105012, 0xe565, 0x0000, 0x00, 0 }, /* #7 */
    { 0x2e7686, 0x2e7686, 0x7523, 0x0000, 0x00, 0 }, /* #8 */
    { 0x0972d7, 0x0972d6, 0xed2b, 0x0000, 0x00, 0 }, /* #9 */
    { 0x162dc7, 0x1625c6, 0xe504, 0x0000, 0x00, 0 }, /* #10 */
    { 0x216e06, 0x216606, 0x5f19, 0x0000, 0x00, 0 }, /* #11 */
    { 0x236c06, 0x236c07, 0x4f8a, 0xfa78, 0x0c, 0 }, /* #12 */
    { 0x355657, 0x355e57, 0xb241, 0xe28c, 0x8c, 0 }, /* #13 */
    { 0x246e57, 0x246e57, 0x4dc0, 0xfcc0, 0x0d, 0 }, /* #14 */
    { 0x375943, 0x375943, 0x4fc5, 0x00ec, 0xfc, 0 }, /* #15 */
    { 0x243947, 0x243947, 0xad0d, 0x0186, 0x1e, 0 }, /* #16 */
    { 0x084882, 0x084883, 0x9a2d, 0x09d8, 0x38, 0 }, /* #17 */
    { 0x244196, 0x244997, 0x7a3c, 0x1ab8, 0x72, 0 }, /* #18 */
    { 0x0b0f57, 0x0b0f57, 0xf7e0, 0xfbc0, 0x22, 0 }, /* #19 */
    { 0x055f87, 0x055f87, 0x9528, 0x0cd0, 0x52, 0 }, /* #20 */
    { 0x105753, 0x105f53, 0xa8fb, 0xff51, 0x23, 0 }, /* #21 */
    { 0x373547, 0x373d47, 0xad49, 0x0ed4, 0x34, 0 }, /* #22 */
    { 0x1854c3, 0x185cc3, 0x425b, 0x2a4d, 0x77, 0 }, /* #23 */
    { 0x292a57, 0x292a57, 0x03b7, 0x1762, 0xae, 0 }, /* #24 */
    { 0x330217, 0x330a17, 0x6120, 0x0bc0, 0x5e, 0 }, /* #25 */
    { 0x1222c3, 0x122ac3, 0xe416, 0xf676, 0x91, 0 }, /* #26 */
    { 0x000b43, 0x000b43, 0xc34b, 0x197d, 0x57, 0 }, /* #27 */
    { 0x1f3e96, 0x1f3e97, 0x2c22, 0x03fc, 0x1e, 0 }, /* #28 */
    { 0x3d4ec2, 0x3d4ec3, 0xe251, 0xf07f, 0xcf, 0 }, /* #29 */
    { 0x1f2b43, 0x1f2b43, 0xcf63, 0x09ab, 0x19, 0 }, /* #30 */
    { 0x0d00d7, 0x0d08d7, 0xdd86, 0x2b5e, 0xa5, 0 }, /* #31 */
    { 0x0d55c3, 0x0d5dc3, 0xd11e, 0xf6dc, 0xb2, 0 }, /* #32 */
    { 0x254e46, 0x254e47, 0xac3d, 0xe368, 0x88, 0 }, /* #33 */
    { 0x0a2453, 0x0a2c53, 0x7f89, 0xef44, 0x24, 0 }, /* #34 */
    { 0x0a6c57, 0x0a6c57, 0x7e04, 0x010c, 0x43, 0 }, /* #35 */
    { 0x160247, 0x160a47, 0x452e, 0xf6d6, 0xcd, 0 }, /* #36 */
    { 0x2b39c7, 0x2b39c7, 0x412a, 0x05e8, 0x24, 0 }, /* #37 */
    { 0x180607, 0x180e07, 0x6bac, 0x0dc8, 0xd6, 0 }, /* #38 */
    { 0x1f46c2, 0x1f4ec3, 0x232a, 0x11e2, 0x6d, 0 }, /* #39 */
    { 0x0e0956, 0x0e0156, 0x37d0, 0xffa0, 0x02, 0 }, /* #40 */
    { 0x0b5807, 0x0b5006, 0x97eb, 0x002a, 0xfe, 0 }, /* #41 */
    { 0x2e2ec7, 0x2e2ec7, 0x5951, 0xe845, 0xb5, 0 }, /* #42 */
    { 0x0b6847, 0x0b6847, 0x49e4, 0xf91c, 0x3f, 0 }, /* #43 */
    { 0x1464c6, 0x146cc7, 0xe63e, 0xe3e8, 0x8c, 0 }, /* #44 */
    { 0x3b7e07, 0x3b7e07, 0x378f, 0x33a5, 0x8b, 0 }, /* #45 */
    { 0x1c1497, 0x1c1c97, 0x9a22, 0x0dd0, 0x68, 0 }, /* #46 */
    { 0x0150c2, 0x0158c3, 0x4bc8, 0xf698, 0x2b, 0 }, /* #47 */
    { 0x081d12, 0x081d13, 0x2792, 0x2ed6, 0x93, 0 }, /* #48 */
    { 0x256457, 0x256c57, 0x41f8, 0x0248, 0xb7, 0 }, /* #49 */
    { 0x1b2013, 0x1b2813, 0x02f1, 0x069f, 0x8f, 0 }, /* #50 */
    { 0x3273c2, 0x327bc3, 0x6d08, 0x0330, 0x66, 0 }, /* #51 */
    { 0x120d07, 0x120506, 0xf886, 0x007a, 0xff, 0 }, /* #52 */
    { 0x1a5d02, 0x1a5d03, 0x5afd, 0xfee3, 0x5f, 0 }, /* #53 */
    { 0x1d6546, 0x1d6d47, 0x7568, 0x05b0, 0x0e, 0 }, /* #54 */
    { 0x3e4146, 0x3e4947, 0xf2cb, 0x0601, 0xe3, 0 }, /* #55 */
    { 0x267656, 0x267e57, 0xc458, 0x13f0, 0x3a, 0 }, /* #56 */
    { 0x0560c2, 0x0568c3, 0xb15f, 0x082a, 0x16, 0 }, /* #57 */
    { 0x0e1d93, 0x0e1d93, 0xe6d4, 0x0ad4, 0xc1, 0 }, /* #58 */
    { 0x096c92, 0x096c93, 0x3a7d, 0xc950, 0x90, 0 }, /* #59 */
    { 0x130f56, 0x130f57, 0xe525, 0x09f9, 0x45, 0 }, /* #60 */
    { 0x3c23d7, 0x3c2bd7, 0x2919, 0x0708, 0x48, 0 }, /* #61 */
    { 0x351896, 0x351897, 0xe99b, 0x167d, 0xc7, 0 }, /* #62 */
    { 0x255742, 0x255f43, 0x73b6, 0xe034, 0x6e, 0 }, /* #63 */
    { 0x183187, 0x183987, 0x153e, 0x0f42, 0x3f, 0 }, /* #64 */
    { 0x393c06, 0x393c07, 0xc4c1, 0xef44, 0x44, 0 }, /* #65 */
    { 0x230242, 0x230a43, 0x4bd5, 0x114d, 0x99, 0 }, /* #66 */
    { 0x372716, 0x372f17, 0xc6d4, 0xfd40, 0x10, 0 }, /* #67 */
    { 0x0d1446, 0x0d1c47, 0x1baf, 0xfc85, 0x0b, 0 }, /* #68 */
    { 0x261c13, 0x261c13, 0xfab9, 0x1630, 0xb0, 0 }, /* #69 */
    { 0x276fc2, 0x276fc3, 0x7381, 0x3398, 0x98, 0 }, /* #70 */
    { 0x2675d7, 0x267dd7, 0x2750, 0x1900, 0x50, 0 }, /* #71 */
    { 0x2a5156, 0x2a5957, 0x61d4, 0xfd40, 0x10, 0 }, /* #72 */
    { 0x2f2a12, 0x2f2a13, 0xcfaa, 0x1784, 0xba, 0 }, /* #73 */
    { 0x331753, 0x331f53, 0x6c7e, 0xfd0c, 0xfa, 0 }, /* #74 */
    { 0x2e6057, 0x2e6857, 0x85ac, 0xeba8, 0x3e, 0 }, /* #75 */
    { 0x351f06, 0x351f07, 0x5dd9, 0x0f8a, 0x9a, 0 }, /* #76 */
    { 0x066b97, 0x066b97, 0xbcee, 0x0264, 0xde, 0 }, /* #77 */
    { 0x2a6a06, 0x2a6a07, 0x7032, 0xfd44, 0xf2, 0 }, /* #78 */
    { 0x310e02, 0x310e03, 0xd315, 0xf8f2, 0xaa, 0 }, /* #79 */
    { 0x375992, 0x375993, 0x1a83, 0x324b, 0x99, 0 }, /* #80 */
    { 0x1666d2, 0x166ed3, 0x4a62, 0xd210, 0x88, 0 }, /* #81 */
    { 0x0b43d3, 0x0b4bd3, 0x66b9, 0x030d, 0xf5, 0 }, /* #82 */
    { 0x301456, 0x301c57, 0x4677, 0xd44e, 0xa2, 0 }, /* #83 */
    { 0x1b77c2, 0x1b7fc3, 0xbe05, 0xfefc, 0xcc, 0 }, /* #84 */
    { 0x150416, 0x150c17, 0x0ef1, 0x04fb, 0xab, 0 }, /* #85 */
    { 0x107487, 0x107c87, 0xae88, 0x17e8, 0xcd, 0 }, /* #86 */
    { 0x1b3117, 0x1b3917, 0x5d6f, 0x18b7, 0x39, 0 }, /* #87 */
    { 0x161e42, 0x161e43, 0x678c, 0xca88, 0x76, 0 }, /* #88 */
    { 0x320043, 0x320843, 0xf8f8, 0x00f8, 0xe1, 0 }, /* #89 */
    { 0x180d97, 0x180d97, 0x90ca, 0x1626, 0x97, 0 }, /* #90 */
    { 0x3b6312, 0x3b6b13, 0x6b0e, 0x0142, 0x17, 0 }, /* #91 */
    { 0x156d52, 0x156d53, 0x8b3e, 0x139e, 0x51, 0 }, /* #92 */
    { 0x385787, 0x385f87, 0x5032, 0xee6c, 0xa6, 0 }, /* #93 */
    { 0x016e53, 0x016e53, 0x298c, 0xdf60, 0x48, 0 }, /* #94 */
    { 0x395613, 0x395e13, 0x6924, 0x0f0c, 0x6b, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u8_amd = RT_ELEMENTS(g_aTests_imul_u8_amd);

MULDIVU8_TEST_T const g_aTests_div_u8_amd[] =
{
    { 0x0f5093, 0x0f5093, 0x0000, 0x0000, 0x00, -1 }, /* #0 */
    { 0x061c46, 0x061c46, 0x0000, 0x0000, 0x00, -1 }, /* #1 */
    { 0x321b96, 0x321b96, 0x0000, 0x0000, 0x00, -1 }, /* #2 */
    { 0x063506, 0x063506, 0x0000, 0x0000, 0x00, -1 }, /* #3 */
    { 0x0460c7, 0x0460c7, 0x0000, 0x0000, 0x00, -1 }, /* #4 */
    { 0x0b0457, 0x0b0457, 0x0000, 0x0000, 0x00, -1 }, /* #5 */
    { 0x123a43, 0x123a43, 0xcf8c, 0xcf8c, 0x00, -1 }, /* #6 */
    { 0x1b15c3, 0x1b15c3, 0x9fc3, 0x9fc3, 0x00, -1 }, /* #7 */
    { 0x2769d7, 0x2769d7, 0x76e4, 0x76e4, 0x00, -1 }, /* #8 */
    { 0x020f92, 0x020f92, 0x7e89, 0x7e89, 0x00, -1 }, /* #9 */
    { 0x241196, 0x241196, 0x5bea, 0x5bea, 0x00, -1 }, /* #10 */
    { 0x162013, 0x162013, 0x5208, 0x5208, 0x00, -1 }, /* #11 */
    { 0x3a2556, 0x3a2512, 0x9114, 0x72f2, 0x99, 0 }, /* #12 */
    { 0x2a00d2, 0x2a0012, 0x2208, 0x4848, 0x78, 0 }, /* #13 */
    { 0x3d3717, 0x3d3713, 0x9f64, 0x90d6, 0xbe, 0 }, /* #14 */
    { 0x0b66c6, 0x0b66c6, 0x89e4, 0x89e4, 0x28, -1 }, /* #15 */
    { 0x2f2e42, 0x2f2e42, 0xfead, 0xfead, 0x7c, -1 }, /* #16 */
    { 0x081013, 0x081013, 0x1146, 0x4212, 0xf2, 0 }, /* #17 */
    { 0x094002, 0x094002, 0x84ad, 0x84ad, 0x4c, -1 }, /* #18 */
    { 0x054cc6, 0x054cc6, 0xf1e6, 0xf1e6, 0x59, -1 }, /* #19 */
    { 0x0a1652, 0x0a1652, 0xfec2, 0xfec2, 0xa1, -1 }, /* #20 */
    { 0x3841d3, 0x3841d3, 0x76fd, 0x76fd, 0x2e, -1 }, /* #21 */
    { 0x0f22d3, 0x0f2213, 0x7232, 0x049e, 0xb9, 0 }, /* #22 */
    { 0x301157, 0x301157, 0xc91e, 0xc91e, 0x69, -1 }, /* #23 */
    { 0x0f1256, 0x0f1256, 0xaad6, 0xaad6, 0x42, -1 }, /* #24 */
    { 0x223e83, 0x223e83, 0xd913, 0xd913, 0xba, -1 }, /* #25 */
    { 0x3d35c3, 0x3d35c3, 0x7199, 0x7199, 0x55, -1 }, /* #26 */
    { 0x020dc3, 0x020d13, 0x3651, 0x7d6a, 0x82, 0 }, /* #27 */
    { 0x010e03, 0x010e13, 0xc26e, 0xaec8, 0xf8, 0 }, /* #28 */
    { 0x332796, 0x332712, 0x1bff, 0x3c67, 0x45, 0 }, /* #29 */
    { 0x0d3803, 0x0d3803, 0xaebc, 0xaebc, 0x62, -1 }, /* #30 */
    { 0x1825c6, 0x1825c6, 0xad31, 0xad31, 0x2d, -1 }, /* #31 */
    { 0x1f3dc3, 0x1f3d13, 0x3362, 0x4037, 0xee, 0 }, /* #32 */
    { 0x365647, 0x365613, 0xe899, 0x6dfe, 0xea, 0 }, /* #33 */
    { 0x392286, 0x392286, 0xc4eb, 0xc4eb, 0x34, -1 }, /* #34 */
    { 0x0e7bc3, 0x0e7b13, 0x6012, 0x3fdd, 0x6f, 0 }, /* #35 */
    { 0x0227d2, 0x022712, 0x8cd0, 0xb2aa, 0xd3, 0 }, /* #36 */
    { 0x2764c6, 0x276412, 0x3cfd, 0x138a, 0x71, 0 }, /* #37 */
    { 0x2474d6, 0x2474d6, 0xd713, 0xd713, 0x51, -1 }, /* #38 */
    { 0x335213, 0x335213, 0xfa1a, 0xfa1a, 0x3a, -1 }, /* #39 */
    { 0x367156, 0x367156, 0xefc8, 0xefc8, 0x77, -1 }, /* #40 */
    { 0x261713, 0x261713, 0xfe5b, 0xfe5b, 0x05, -1 }, /* #41 */
    { 0x0824c3, 0x0824c3, 0x7edd, 0x7edd, 0x5f, -1 }, /* #42 */
    { 0x371f96, 0x371f96, 0xacc9, 0xacc9, 0x02, -1 }, /* #43 */
    { 0x041fd7, 0x041fd7, 0x9e80, 0x9e80, 0x58, -1 }, /* #44 */
    { 0x195402, 0x195402, 0xd14e, 0xd14e, 0xc8, -1 }, /* #45 */
    { 0x305a13, 0x305a13, 0x7daf, 0x7daf, 0x5e, -1 }, /* #46 */
    { 0x393b43, 0x393b43, 0xe86b, 0xe86b, 0x43, -1 }, /* #47 */
    { 0x167a82, 0x167a82, 0x2d85, 0x2d85, 0x0c, -1 }, /* #48 */
    { 0x324896, 0x324896, 0x8e20, 0x8e20, 0x1e, -1 }, /* #49 */
    { 0x1769c7, 0x1769c7, 0x6314, 0x6314, 0x25, -1 }, /* #50 */
    { 0x1a4dd6, 0x1a4dd6, 0xae85, 0xae85, 0xae, -1 }, /* #51 */
    { 0x335bd3, 0x335bd3, 0x2f79, 0x2f79, 0x25, -1 }, /* #52 */
    { 0x091917, 0x091917, 0xe708, 0xe708, 0xbf, -1 }, /* #53 */
    { 0x226197, 0x226113, 0x80fc, 0x24f8, 0x85, 0 }, /* #54 */
    { 0x020297, 0x020297, 0x9cce, 0x9cce, 0x77, -1 }, /* #55 */
    { 0x350c17, 0x350c17, 0x4fd2, 0x4fd2, 0x30, -1 }, /* #56 */
    { 0x1e56d2, 0x1e5612, 0x3576, 0x4e48, 0xbd, 0 }, /* #57 */
    { 0x050157, 0x050157, 0xcd01, 0xcd01, 0xa1, -1 }, /* #58 */
    { 0x263a03, 0x263a13, 0x26bb, 0x873c, 0xa3, 0 }, /* #59 */
    { 0x0d3216, 0x0d3212, 0x77cb, 0x15c7, 0x9a, 0 }, /* #60 */
    { 0x381a83, 0x381a83, 0x905d, 0x905d, 0x26, -1 }, /* #61 */
    { 0x126702, 0x126712, 0x2c31, 0x4d6a, 0x6a, 0 }, /* #62 */
    { 0x0a3d03, 0x0a3d03, 0xd31d, 0xd31d, 0x73, -1 }, /* #63 */
    { 0x2c3fd2, 0x2c3fd2, 0xf20e, 0xf20e, 0x01, -1 }, /* #64 */
    { 0x3a0b47, 0x3a0b47, 0xdfe5, 0xdfe5, 0x34, -1 }, /* #65 */
    { 0x266c43, 0x266c43, 0x8db8, 0x8db8, 0x0b, -1 }, /* #66 */
    { 0x2713d2, 0x2713d2, 0xb203, 0xb203, 0x75, -1 }, /* #67 */
    { 0x332482, 0x332412, 0x2f51, 0x173e, 0xc3, 0 }, /* #68 */
    { 0x095657, 0x095657, 0x4235, 0x4235, 0x23, -1 }, /* #69 */
    { 0x301996, 0x301912, 0x0da8, 0x8212, 0xbb, 0 }, /* #70 */
    { 0x143c83, 0x143c83, 0xebba, 0xebba, 0xbe, -1 }, /* #71 */
    { 0x366c07, 0x366c07, 0xc3a6, 0xc3a6, 0x95, -1 }, /* #72 */
    { 0x286493, 0x286413, 0x3404, 0x963a, 0xe3, 0 }, /* #73 */
    { 0x0e4c43, 0x0e4c43, 0xf380, 0xf380, 0xe8, -1 }, /* #74 */
    { 0x031716, 0x031716, 0xde2c, 0xde2c, 0x71, -1 }, /* #75 */
    { 0x150ed6, 0x150ed6, 0xd7d8, 0xd7d8, 0x93, -1 }, /* #76 */
    { 0x2a55d3, 0x2a55d3, 0xfb63, 0xfb63, 0x76, -1 }, /* #77 */
    { 0x072586, 0x072512, 0x3a55, 0x1d6c, 0x8a, 0 }, /* #78 */
    { 0x214fd2, 0x214f12, 0x201d, 0xc025, 0xd9, 0 }, /* #79 */
    { 0x0b7f86, 0x0b7f86, 0xc515, 0xc515, 0x90, -1 }, /* #80 */
    { 0x023042, 0x023042, 0xd56b, 0xd56b, 0x75, -1 }, /* #81 */
    { 0x285ec3, 0x285e13, 0x97f3, 0xbe99, 0xfd, 0 }, /* #82 */
    { 0x050303, 0x050303, 0xacf1, 0xacf1, 0x3c, -1 }, /* #83 */
    { 0x140512, 0x140512, 0xa86b, 0x41cd, 0xd2, 0 }, /* #84 */
    { 0x196dc7, 0x196d13, 0x1002, 0x1c4a, 0x37, 0 }, /* #85 */
    { 0x311252, 0x311212, 0x281d, 0x3f36, 0xbd, 0 }, /* #86 */
    { 0x200513, 0x200513, 0xc2ed, 0xc2ed, 0x58, -1 }, /* #87 */
    { 0x3e7fd2, 0x3e7fd2, 0xf881, 0xf881, 0x42, -1 }, /* #88 */
    { 0x072e52, 0x072e12, 0x3d4f, 0x6a77, 0x83, 0 }, /* #89 */
    { 0x2936d3, 0x293613, 0x9832, 0x0eb6, 0xd6, 0 }, /* #90 */
    { 0x187f16, 0x187f16, 0x4a62, 0x4a62, 0x37, -1 }, /* #91 */
    { 0x187187, 0x187187, 0x5853, 0x5853, 0x18, -1 }, /* #92 */
    { 0x2f5b92, 0x2f5b92, 0x810f, 0x810f, 0x72, -1 }, /* #93 */
    { 0x257b52, 0x257b12, 0x321e, 0x26f6, 0x34, 0 }, /* #94 */
    { 0x3b7ed2, 0x3b7e12, 0x4fdd, 0x6d7c, 0xa4, 0 }, /* #95 */
};
uint32_t const g_cTests_div_u8_amd = RT_ELEMENTS(g_aTests_div_u8_amd);

MULDIVU8_TEST_T const g_aTests_idiv_u8_amd[] =
{
    { 0x3140d2, 0x3140d2, 0x0000, 0x0000, 0x00, -1 }, /* #0 */
    { 0x1d7f86, 0x1d7f86, 0x0000, 0x0000, 0x00, -1 }, /* #1 */
    { 0x3a7997, 0x3a7997, 0x0000, 0x0000, 0x00, -1 }, /* #2 */
    { 0x0e0152, 0x0e0152, 0x0000, 0x0000, 0x00, -1 }, /* #3 */
    { 0x140e43, 0x140e43, 0x0000, 0x0000, 0x00, -1 }, /* #4 */
    { 0x3c2f56, 0x3c2f56, 0x0000, 0x0000, 0x00, -1 }, /* #5 */
    { 0x0f6f16, 0x0f6f16, 0xca9f, 0xca9f, 0x00, -1 }, /* #6 */
    { 0x311303, 0x311303, 0x81d9, 0x81d9, 0x00, -1 }, /* #7 */
    { 0x387043, 0x387043, 0xb398, 0xb398, 0x00, -1 }, /* #8 */
    { 0x374183, 0x374183, 0x62a5, 0x62a5, 0x00, -1 }, /* #9 */
    { 0x395913, 0x395913, 0x5b8c, 0x5b8c, 0x00, -1 }, /* #10 */
    { 0x035693, 0x035693, 0x564a, 0x564a, 0x00, -1 }, /* #11 */
    { 0x393547, 0x393513, 0xd68c, 0xf464, 0x96, 0 }, /* #12 */
    { 0x0600c6, 0x060012, 0x29b3, 0x0b84, 0xaa, 0 }, /* #13 */
    { 0x1f0a47, 0x1f0a47, 0x9117, 0x9117, 0x33, -1 }, /* #14 */
    { 0x162453, 0x162453, 0x4e7f, 0x4e7f, 0x11, -1 }, /* #15 */
    { 0x1f0493, 0x1f0413, 0x1c11, 0x0eb9, 0x9b, 0 }, /* #16 */
    { 0x205dc3, 0x205dc3, 0x7311, 0x7311, 0xe0, -1 }, /* #17 */
    { 0x310852, 0x310852, 0xc9d9, 0xc9d9, 0x58, -1 }, /* #18 */
    { 0x3345d7, 0x3345d7, 0x372f, 0x372f, 0xf9, -1 }, /* #19 */
    { 0x203e92, 0x203e92, 0xb40c, 0xb40c, 0x24, -1 }, /* #20 */
    { 0x0b6082, 0x0b6012, 0x358a, 0x1175, 0x75, 0 }, /* #21 */
    { 0x1a1f07, 0x1a1f13, 0x04a6, 0x0224, 0x21, 0 }, /* #22 */
    { 0x381853, 0x381853, 0xba25, 0xba25, 0xad, -1 }, /* #23 */
    { 0x062b12, 0x062b12, 0x7b15, 0x7b15, 0xf1, -1 }, /* #24 */
    { 0x247802, 0x247812, 0x1eac, 0x086a, 0x4a, 0 }, /* #25 */
    { 0x361b86, 0x361b86, 0x29b8, 0x29b8, 0x30, -1 }, /* #26 */
    { 0x1a3683, 0x1a3683, 0xb31c, 0xb31c, 0x3e, -1 }, /* #27 */
    { 0x1d5813, 0x1d5813, 0x6fe2, 0x6fe2, 0xe5, -1 }, /* #28 */
    { 0x276752, 0x276752, 0x78e3, 0x78e3, 0x64, -1 }, /* #29 */
    { 0x395613, 0x395613, 0x040b, 0x050a, 0x67, 0 }, /* #30 */
    { 0x170682, 0x170612, 0x19c5, 0x1f9e, 0xbd, 0 }, /* #31 */
    { 0x227fd3, 0x227fd3, 0xcb6a, 0xcb6a, 0xcd, -1 }, /* #32 */
    { 0x0d0197, 0x0d0113, 0xf56e, 0xd625, 0xb8, 0 }, /* #33 */
    { 0x097b13, 0x097b13, 0x2bf8, 0x2bf8, 0xb1, -1 }, /* #34 */
    { 0x207792, 0x207792, 0x810a, 0x810a, 0xbc, -1 }, /* #35 */
    { 0x203bc3, 0x203bc3, 0xad92, 0xad92, 0x3a, -1 }, /* #36 */
    { 0x307c47, 0x307c47, 0x571e, 0x571e, 0xd7, -1 }, /* #37 */
    { 0x021787, 0x021787, 0x5e76, 0x5e76, 0x4d, -1 }, /* #38 */
    { 0x015b53, 0x015b53, 0xef1e, 0xef1e, 0x01, -1 }, /* #39 */
    { 0x1c46c3, 0x1c46c3, 0xa851, 0xa851, 0x4b, -1 }, /* #40 */
    { 0x3f6646, 0x3f6646, 0xae21, 0xae21, 0x31, -1 }, /* #41 */
    { 0x255fc2, 0x255fc2, 0x72f5, 0x72f5, 0x20, -1 }, /* #42 */
    { 0x347086, 0x347012, 0x324a, 0x226b, 0x78, 0 }, /* #43 */
    { 0x013fc3, 0x013fc3, 0x628b, 0x628b, 0x44, -1 }, /* #44 */
    { 0x0245d2, 0x0245d2, 0x84d1, 0x84d1, 0xc2, -1 }, /* #45 */
    { 0x2a17c3, 0x2a1713, 0xd144, 0xc45d, 0x80, 0 }, /* #46 */
    { 0x396806, 0x396806, 0x86d4, 0x86d4, 0xc5, -1 }, /* #47 */
    { 0x390ad6, 0x390ad6, 0x29a3, 0x29a3, 0xf8, -1 }, /* #48 */
    { 0x144a07, 0x144a13, 0xea00, 0xd641, 0xaa, 0 }, /* #49 */
    { 0x352387, 0x352387, 0x7a7c, 0x7a7c, 0x0e, -1 }, /* #50 */
    { 0x3b6702, 0x3b6712, 0x2f10, 0x1484, 0x9f, 0 }, /* #51 */
    { 0x2b4192, 0x2b4112, 0x14a3, 0x03a8, 0xc4, 0 }, /* #52 */
    { 0x2f4603, 0x2f4613, 0xec63, 0xb9ce, 0x63, 0 }, /* #53 */
    { 0x270657, 0x270613, 0xfb5e, 0xe3f3, 0x59, 0 }, /* #54 */
    { 0x2175c3, 0x217513, 0xe612, 0xce86, 0x36, 0 }, /* #55 */
    { 0x257e12, 0x257e12, 0x5bff, 0x5bff, 0x3a, -1 }, /* #56 */
    { 0x153ec6, 0x153ec6, 0x8b92, 0x8b92, 0x6c, -1 }, /* #57 */
    { 0x316946, 0x316946, 0x2cc0, 0x2cc0, 0xe6, -1 }, /* #58 */
    { 0x283ad7, 0x283ad7, 0x251a, 0x251a, 0xf8, -1 }, /* #59 */
    { 0x0b5d07, 0x0b5d13, 0x34f0, 0x1692, 0x85, 0 }, /* #60 */
    { 0x320886, 0x320886, 0xebdb, 0xebdb, 0x24, -1 }, /* #61 */
    { 0x164c93, 0x164c93, 0x709f, 0x709f, 0x5f, -1 }, /* #62 */
    { 0x2c10c3, 0x2c10c3, 0x8ff5, 0x8ff5, 0xa3, -1 }, /* #63 */
    { 0x3531c2, 0x353112, 0x1246, 0x1025, 0x7e, 0 }, /* #64 */
    { 0x0a18c7, 0x0a18c7, 0x6c47, 0x6c47, 0x75, -1 }, /* #65 */
    { 0x0f36c6, 0x0f36c6, 0xad76, 0xad76, 0x88, -1 }, /* #66 */
    { 0x2d32c3, 0x2d32c3, 0x56ce, 0x56ce, 0x01, -1 }, /* #67 */
    { 0x2f7d53, 0x2f7d53, 0xab9b, 0xab9b, 0x3a, -1 }, /* #68 */
    { 0x205d96, 0x205d12, 0x1a7b, 0x13bf, 0x98, 0 }, /* #69 */
    { 0x080bc7, 0x080bc7, 0xd08b, 0xd08b, 0x02, -1 }, /* #70 */
    { 0x0f4fc6, 0x0f4fc6, 0x8ef9, 0x8ef9, 0xf2, -1 }, /* #71 */
    { 0x114e07, 0x114e07, 0x77eb, 0x77eb, 0xc8, -1 }, /* #72 */
    { 0x216957, 0x216957, 0xbd0a, 0xbd0a, 0xb3, -1 }, /* #73 */
    { 0x026e47, 0x026e47, 0x5dfa, 0x5dfa, 0x72, -1 }, /* #74 */
    { 0x112b43, 0x112b13, 0x0575, 0x112e, 0x1e, 0 }, /* #75 */
    { 0x0c4d06, 0x0c4d06, 0x45b5, 0x45b5, 0x64, -1 }, /* #76 */
    { 0x0f2517, 0x0f2517, 0xe922, 0xe922, 0x16, -1 }, /* #77 */
    { 0x122ac3, 0x122a13, 0xfbe7, 0xc90e, 0xb9, 0 }, /* #78 */
    { 0x3d4e13, 0x3d4e13, 0xa5dd, 0xa5dd, 0x18, -1 }, /* #79 */
    { 0x0315d6, 0x0315d6, 0x4597, 0x4597, 0x2a, -1 }, /* #80 */
    { 0x1b09c2, 0x1b09c2, 0x5626, 0x5626, 0x94, -1 }, /* #81 */
    { 0x133143, 0x133143, 0x7151, 0x7151, 0xdf, -1 }, /* #82 */
    { 0x3660c3, 0x3660c3, 0x2279, 0x2279, 0xe7, -1 }, /* #83 */
    { 0x1375c6, 0x1375c6, 0x688f, 0x688f, 0xb4, -1 }, /* #84 */
    { 0x2c3547, 0x2c3547, 0x8ac5, 0x8ac5, 0xd3, -1 }, /* #85 */
    { 0x2c04d2, 0x2c0412, 0x17e8, 0x0e56, 0x47, 0 }, /* #86 */
    { 0x1527c6, 0x1527c6, 0x93b0, 0x93b0, 0x3f, -1 }, /* #87 */
    { 0x1b44c6, 0x1b44c6, 0x6cc4, 0x6cc4, 0x41, -1 }, /* #88 */
    { 0x372643, 0x372613, 0xd9d7, 0xf77a, 0xb0, 0 }, /* #89 */
    { 0x360f96, 0x360f12, 0xdf58, 0xc0bc, 0x7a, 0 }, /* #90 */
    { 0x0a24c7, 0x0a24c7, 0xae61, 0xae61, 0x36, -1 }, /* #91 */
    { 0x0b4616, 0x0b4616, 0x955c, 0x955c, 0xa8, -1 }, /* #92 */
    { 0x264083, 0x264083, 0x6876, 0x6876, 0xa1, -1 }, /* #93 */
    { 0x1970d3, 0x1970d3, 0x71c4, 0x71c4, 0x97, -1 }, /* #94 */
    { 0x383d12, 0x383d12, 0x6e66, 0x6e66, 0x99, -1 }, /* #95 */
};
uint32_t const g_cTests_idiv_u8_amd = RT_ELEMENTS(g_aTests_idiv_u8_amd);

MULDIVU16_TEST_T const g_aTests_mul_u16_amd[] =
{
    { 0x022292, 0x022292, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #0 */
    { 0x3f3087, 0x3f3086, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #1 */
    { 0x155fd7, 0x1557d6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #2 */
    { 0x062d43, 0x062542, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #3 */
    { 0x205093, 0x205092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #4 */
    { 0x1d0846, 0x1d0046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #5 */
    { 0x1d3bc3, 0x1d33c2, 0xc0dd, 0x0000, 0x0f74, 0x0000, 0x0000, 0 }, /* #6 */
    { 0x393cd7, 0x3934d6, 0x3592, 0x0000, 0x39eb, 0x0000, 0x0000, 0 }, /* #7 */
    { 0x1c10c2, 0x1c10c2, 0x1550, 0x0000, 0x6c9e, 0x0000, 0x0000, 0 }, /* #8 */
    { 0x280c87, 0x280486, 0x9105, 0x0000, 0xe42b, 0x0000, 0x0000, 0 }, /* #9 */
    { 0x057f42, 0x057742, 0xf279, 0x0000, 0xfab2, 0x0000, 0x0000, 0 }, /* #10 */
    { 0x264c43, 0x264442, 0x20dc, 0x0000, 0x6b6c, 0x0000, 0x0000, 0 }, /* #11 */
    { 0x3d2a56, 0x3d2a57, 0x8886, 0x7584, 0x396f, 0x76f8, 0xdf16, 0 }, /* #12 */
    { 0x0c2fc7, 0x0c2fc7, 0xfeb4, 0xa4e8, 0x060e, 0x8caa, 0x8d62, 0 }, /* #13 */
    { 0x215c02, 0x215c03, 0xd6ac, 0x7d28, 0xc3c0, 0x6b39, 0x7fde, 0 }, /* #14 */
    { 0x1b4fc3, 0x1b4fc3, 0x99aa, 0xaa0a, 0x73c5, 0x72e9, 0xbf71, 0 }, /* #15 */
    { 0x3a24c6, 0x3a2cc7, 0x6a4d, 0xbcf6, 0x0ded, 0x3511, 0x7fce, 0 }, /* #16 */
    { 0x3643d3, 0x364bd3, 0xccc7, 0x2016, 0x5890, 0x575f, 0x6d3a, 0 }, /* #17 */
    { 0x2509d6, 0x2509d7, 0x3cfc, 0x2e24, 0xc99f, 0x3bd8, 0xfb37, 0 }, /* #18 */
    { 0x011242, 0x011a43, 0x7666, 0x372e, 0x4a9a, 0x757f, 0xfe0d, 0 }, /* #19 */
    { 0x3614d6, 0x361cd7, 0x0b78, 0xae20, 0x07f7, 0x0b4f, 0xfc7c, 0 }, /* #20 */
    { 0x333fc7, 0x333fc7, 0xa18f, 0xb26f, 0xeb05, 0x6fc8, 0xb121, 0 }, /* #21 */
    { 0x036e13, 0x036e13, 0x3a47, 0xa44d, 0x1e8e, 0x07eb, 0x22cb, 0 }, /* #22 */
    { 0x3d5a03, 0x3d5a03, 0x692f, 0xfec4, 0xa207, 0x4a27, 0xb47c, 0 }, /* #23 */
    { 0x335582, 0x335d83, 0xb9b7, 0x571b, 0xb4ee, 0x726e, 0x9dbd, 0 }, /* #24 */
    { 0x1b1046, 0x1b1847, 0xcfde, 0x557c, 0x30aa, 0xc56b, 0xf322, 0 }, /* #25 */
    { 0x243f92, 0x243f93, 0x3ea9, 0xcae4, 0xd323, 0x2c9c, 0xb644, 0 }, /* #26 */
    { 0x114502, 0x114d03, 0xab86, 0x4fcc, 0x07cc, 0x9e36, 0xec22, 0 }, /* #27 */
    { 0x0361c2, 0x0369c3, 0xd553, 0xa4fc, 0x4780, 0x3efa, 0x4b94, 0 }, /* #28 */
    { 0x1c7dc3, 0x1c7dc3, 0xe678, 0xbfd8, 0xd452, 0x8636, 0x9515, 0 }, /* #29 */
    { 0x113806, 0x113807, 0xf24e, 0xfdac, 0xe326, 0x1324, 0x143a, 0 }, /* #30 */
    { 0x277386, 0x277b87, 0xc4ac, 0x8168, 0x1a05, 0x3d80, 0x500e, 0 }, /* #31 */
    { 0x0d7593, 0x0d7d93, 0xc73c, 0xc4e0, 0x47c1, 0xaf53, 0xe148, 0 }, /* #32 */
    { 0x036717, 0x036f17, 0x951d, 0x6dbb, 0xbcc9, 0x2dd9, 0x4eb7, 0 }, /* #33 */
    { 0x1b7107, 0x1b7907, 0xb8e7, 0x083a, 0x51f7, 0x3768, 0x4cb6, 0 }, /* #34 */
    { 0x0c5212, 0x0c5a13, 0x2f86, 0x1092, 0x243b, 0x1fbf, 0xab03, 0 }, /* #35 */
    { 0x1f5f93, 0x1f5f93, 0xcb62, 0xb098, 0xa9b9, 0xa876, 0xd40c, 0 }, /* #36 */
    { 0x0e0d82, 0x0e0d83, 0xda95, 0x7281, 0x745d, 0x9080, 0xa93d, 0 }, /* #37 */
    { 0x1320c7, 0x1328c7, 0x3c83, 0xd3f7, 0xfde6, 0x05c9, 0x187d, 0 }, /* #38 */
    { 0x2752d2, 0x275ad3, 0x467d, 0xfd85, 0xbec0, 0x18af, 0x59a9, 0 }, /* #39 */
    { 0x3b1002, 0x3b1803, 0xe82a, 0x4bf8, 0x57b8, 0x1df8, 0x210c, 0 }, /* #40 */
    { 0x1f1d53, 0x1f1d53, 0x5220, 0x3560, 0xb953, 0x0214, 0x067b, 0 }, /* #41 */
    { 0x2e2652, 0x2e2e53, 0x83fa, 0x17d2, 0xba4d, 0x28ea, 0x4f5d, 0 }, /* #42 */
    { 0x127e83, 0x127e83, 0x1779, 0x226f, 0x3de0, 0x0686, 0x4727, 0 }, /* #43 */
    { 0x0e60c2, 0x0e68c3, 0xef9d, 0x34d8, 0x4e5e, 0x29db, 0x2cb8, 0 }, /* #44 */
    { 0x110893, 0x110893, 0xed3c, 0x2748, 0x260a, 0x55c5, 0x5c8e, 0 }, /* #45 */
    { 0x397987, 0x397987, 0x4245, 0xc835, 0xd952, 0x330b, 0xc531, 0 }, /* #46 */
    { 0x0c4a53, 0x0c4a53, 0x5a41, 0x74af, 0x9029, 0x3f15, 0xb2ef, 0 }, /* #47 */
    { 0x3d03c2, 0x3d0bc3, 0x7387, 0xcfae, 0xbd42, 0x1a58, 0x3a62, 0 }, /* #48 */
    { 0x333282, 0x333a83, 0x18cf, 0x7bbf, 0xe49e, 0x072d, 0x4a11, 0 }, /* #49 */
    { 0x205f42, 0x205f43, 0x0b17, 0x5413, 0x1eff, 0x01ec, 0x2c65, 0 }, /* #50 */
    { 0x0431d6, 0x0439d7, 0xdb13, 0xe726, 0xc603, 0x24cd, 0x2b02, 0 }, /* #51 */
    { 0x0445c6, 0x044dc7, 0x344a, 0x395a, 0x1a22, 0x26ca, 0xbde9, 0 }, /* #52 */
    { 0x1648c6, 0x1648c7, 0xd753, 0x656c, 0xb51c, 0x610e, 0x7364, 0 }, /* #53 */
    { 0x0060d3, 0x0068d3, 0x5160, 0x07a0, 0xaa68, 0x3349, 0xa157, 0 }, /* #54 */
    { 0x3b6283, 0x3b6a83, 0xacea, 0x4a32, 0x5673, 0x7131, 0xa795, 0 }, /* #55 */
    { 0x1f4493, 0x1f4c93, 0x5797, 0x5253, 0x85d6, 0x4812, 0xd2a5, 0 }, /* #56 */
    { 0x386ac3, 0x386ac3, 0x3065, 0x1eae, 0x7798, 0x23ef, 0xbe16, 0 }, /* #57 */
    { 0x344f03, 0x344f03, 0xc8bb, 0x99f5, 0xa8a3, 0x74e0, 0x950f, 0 }, /* #58 */
    { 0x0143c3, 0x014bc3, 0xfd44, 0xc94c, 0x92ba, 0x1625, 0x1663, 0 }, /* #59 */
    { 0x003dd2, 0x003dd3, 0x6ddb, 0x935d, 0x6985, 0x4dbc, 0xb527, 0 }, /* #60 */
    { 0x322397, 0x322b97, 0xf2cb, 0x19ef, 0x1323, 0x767b, 0x7ced, 0 }, /* #61 */
    { 0x2f6a46, 0x2f6a47, 0x7f22, 0x85e8, 0xa824, 0x00d8, 0x01b4, 0 }, /* #62 */
    { 0x3579d6, 0x3579d7, 0x44b6, 0xb7ba, 0x2c98, 0x3c29, 0xe027, 0 }, /* #63 */
    { 0x2d5453, 0x2d5c53, 0x23fb, 0xfc2d, 0x44c8, 0x1afa, 0xbff7, 0 }, /* #64 */
    { 0x172e06, 0x172e07, 0x7845, 0x71ed, 0x05db, 0x445f, 0x9189, 0 }, /* #65 */
    { 0x124cd6, 0x124cd7, 0xb89d, 0x293e, 0x5e69, 0x38da, 0x4ed6, 0 }, /* #66 */
    { 0x0a6696, 0x0a6e97, 0x85d9, 0xe8e2, 0x76d8, 0x4fd5, 0x98b2, 0 }, /* #67 */
    { 0x395297, 0x395a97, 0x2383, 0x8cfa, 0xae75, 0x15a3, 0x9bfe, 0 }, /* #68 */
    { 0x245357, 0x245b57, 0x51b7, 0xb3d9, 0x057f, 0x49b6, 0xe6ef, 0 }, /* #69 */
    { 0x245782, 0x245f83, 0xda36, 0xc78a, 0x1973, 0xbf76, 0xe09f, 0 }, /* #70 */
    { 0x3c7dd7, 0x3c7dd7, 0xc162, 0x7060, 0x0b5c, 0x9677, 0xc730, 0 }, /* #71 */
    { 0x102157, 0x102957, 0x8d11, 0x53bf, 0x5f8c, 0x0aea, 0x13cf, 0 }, /* #72 */
    { 0x2a1443, 0x2a1c43, 0x9d3a, 0xa62e, 0x6caa, 0x2777, 0x4043, 0 }, /* #73 */
    { 0x221a46, 0x221a47, 0x1a57, 0x0243, 0x6791, 0x0cc1, 0x7bf5, 0 }, /* #74 */
    { 0x2f3582, 0x2f3d83, 0x15c0, 0xb840, 0x2274, 0x0151, 0x0f87, 0 }, /* #75 */
    { 0x377553, 0x377d53, 0x765b, 0x3213, 0x6bef, 0x167f, 0x30a9, 0 }, /* #76 */
    { 0x2d3317, 0x2d3b17, 0x613c, 0xeb04, 0xcf37, 0x0f2a, 0x27ef, 0 }, /* #77 */
    { 0x303dc2, 0x303dc3, 0xcd1f, 0x3daa, 0xcb76, 0x9c50, 0xc316, 0 }, /* #78 */
    { 0x135a86, 0x135a87, 0x8dff, 0x6f64, 0x6c21, 0x0da6, 0x189c, 0 }, /* #79 */
    { 0x155357, 0x155b57, 0xd33f, 0xd581, 0xe466, 0xbed1, 0xe73f, 0 }, /* #80 */
    { 0x227313, 0x227b13, 0xa1ac, 0x2f4c, 0x4c63, 0x16e0, 0x2439, 0 }, /* #81 */
    { 0x354e03, 0x354e03, 0xe378, 0xb4d8, 0xf3b0, 0xbeaa, 0xd695, 0 }, /* #82 */
    { 0x386546, 0x386d47, 0xa0a5, 0x371c, 0xefc5, 0x48be, 0x73ec, 0 }, /* #83 */
    { 0x1120c2, 0x1128c3, 0x5b43, 0xf47a, 0x8d7e, 0x2b21, 0x78fe, 0 }, /* #84 */
    { 0x012496, 0x012c97, 0x6486, 0xe090, 0xa81b, 0x4aa4, 0xbe18, 0 }, /* #85 */
    { 0x052586, 0x052d87, 0xb18b, 0xe0e6, 0x5c38, 0x6641, 0x9372, 0 }, /* #86 */
    { 0x1e3017, 0x1e3817, 0x826a, 0xa2e4, 0x2313, 0x5fba, 0xbbea, 0 }, /* #87 */
    { 0x3c00c6, 0x3c08c7, 0x6305, 0x593c, 0x0592, 0x5d3c, 0xf10c, 0 }, /* #88 */
    { 0x295d82, 0x295d83, 0xb2a4, 0xa3b0, 0x5728, 0x1ca4, 0x290c, 0 }, /* #89 */
    { 0x0b6087, 0x0b6887, 0x7141, 0x9e33, 0x8a27, 0x1ba0, 0x3e73, 0 }, /* #90 */
    { 0x1778c3, 0x1778c3, 0xe863, 0x15ab, 0xd8d7, 0x4514, 0x4c19, 0 }, /* #91 */
    { 0x340b93, 0x340b93, 0x4f37, 0x991d, 0xcb76, 0x3a43, 0xbc4b, 0 }, /* #92 */
    { 0x291292, 0x291a93, 0xcee8, 0x4258, 0x0e9d, 0x7160, 0x8c47, 0 }, /* #93 */
    { 0x0745d3, 0x074dd3, 0x6417, 0xbcab, 0x383b, 0x4cd8, 0xc48d, 0 }, /* #94 */
    { 0x2a4693, 0x2a4e93, 0xf168, 0x3a60, 0xff0e, 0xf164, 0xfffc, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u16_amd = RT_ELEMENTS(g_aTests_mul_u16_amd);

MULDIVU16_TEST_T const g_aTests_imul_u16_amd[] =
{
    { 0x2623d7, 0x2623d6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #0 */
    { 0x3a3502, 0x3a3502, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #1 */
    { 0x014c47, 0x014446, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #2 */
    { 0x0a5017, 0x0a5016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #3 */
    { 0x0b3b57, 0x0b3356, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #4 */
    { 0x266883, 0x266082, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0 }, /* #5 */
    { 0x1717c7, 0x1717c6, 0x27e5, 0x0000, 0x66d8, 0x0000, 0x0000, 0 }, /* #6 */
    { 0x3a1b52, 0x3a1352, 0xe4a3, 0x0000, 0xb604, 0x0000, 0x0000, 0 }, /* #7 */
    { 0x0a7952, 0x0a7152, 0x42e5, 0x0000, 0xd5b9, 0x0000, 0x0000, 0 }, /* #8 */
    { 0x006852, 0x006052, 0x11c4, 0x0000, 0x9ab9, 0x0000, 0x0000, 0 }, /* #9 */
    { 0x226816, 0x226016, 0xb7fe, 0x0000, 0x9b61, 0x0000, 0x0000, 0 }, /* #10 */
    { 0x1c1f87, 0x1c1786, 0x1ff9, 0x0000, 0x4247, 0x0000, 0x0000, 0 }, /* #11 */
    { 0x066096, 0x066897, 0x4109, 0x983b, 0xce96, 0x051d, 0x1423, 0 }, /* #12 */
    { 0x0b44c6, 0x0b4cc7, 0x932c, 0x3d40, 0x5811, 0x12bb, 0xd3f0, 0 }, /* #13 */
    { 0x134452, 0x134c53, 0x2b81, 0x2865, 0x535a, 0x0ab0, 0x3ee5, 0 }, /* #14 */
    { 0x1d5202, 0x1d5a03, 0xdff3, 0x74d6, 0x078c, 0x0b9a, 0xa352, 0 }, /* #15 */
    { 0x2e7f07, 0x2e7f07, 0x043b, 0x5fb0, 0xfcc3, 0xfe37, 0x9410, 0 }, /* #16 */
    { 0x2d4413, 0x2d4c13, 0x8e44, 0xffa8, 0x3011, 0x1fdb, 0xb84a, 0 }, /* #17 */
    { 0x210f53, 0x210f53, 0x7d52, 0x7312, 0xae49, 0x271a, 0x4fe1, 0 }, /* #18 */
    { 0x1d7302, 0x1d7b03, 0x05f4, 0x4d8c, 0x1078, 0x0173, 0x3e5f, 0 }, /* #19 */
    { 0x135947, 0x135947, 0xc48a, 0xb8b6, 0x62b9, 0xe2b4, 0x7e1f, 0 }, /* #20 */
    { 0x073993, 0x073993, 0x6d5c, 0x8a08, 0xdbb5, 0x29fe, 0x624e, 0 }, /* #21 */
    { 0x332d96, 0x332d97, 0xa266, 0xd038, 0x07a5, 0x060c, 0xef74, 0 }, /* #22 */
    { 0x1c4c82, 0x1c4c83, 0xc593, 0x981a, 0x4fed, 0xebf9, 0x57be, 0 }, /* #23 */
    { 0x1425c7, 0x142dc7, 0x710e, 0xaede, 0x892b, 0x2fa0, 0x6bd9, 0 }, /* #24 */
    { 0x007b56, 0x007b57, 0x8870, 0x6a10, 0xa3ec, 0x02fe, 0xf997, 0 }, /* #25 */
    { 0x1d5887, 0x1d5887, 0xb65a, 0xce50, 0xed6c, 0xe54e, 0x5cc8, 0 }, /* #26 */
    { 0x137f06, 0x137f07, 0xa6d7, 0xf9cc, 0x9271, 0xd686, 0x7714, 0 }, /* #27 */
    { 0x126a17, 0x126a17, 0x3683, 0x3492, 0xfcc8, 0xfa26, 0xe486, 0 }, /* #28 */
    { 0x244d17, 0x244d17, 0x9fd2, 0x29f8, 0xae2c, 0x07a9, 0xeb9c, 0 }, /* #29 */
    { 0x2b0846, 0x2b0847, 0x8829, 0x8f79, 0x472d, 0x044c, 0xf6d1, 0 }, /* #30 */
    { 0x361813, 0x361813, 0x1a85, 0xc247, 0x2c41, 0xf489, 0x915b, 0 }, /* #31 */
    { 0x2b0a92, 0x2b0a93, 0xd274, 0x53f4, 0xe909, 0x1615, 0x83e1, 0 }, /* #32 */
    { 0x134586, 0x134d87, 0x71d5, 0xb178, 0x87c7, 0x1529, 0x2f98, 0 }, /* #33 */
    { 0x084b02, 0x084b03, 0xa051, 0xed70, 0x5fd1, 0x1ffa, 0xaa70, 0 }, /* #34 */
    { 0x2f3d46, 0x2f3d47, 0x5849, 0xa292, 0x550b, 0x21cc, 0x6202, 0 }, /* #35 */
    { 0x320e43, 0x320e43, 0xa520, 0xe340, 0x0ded, 0xe69a, 0x478a, 0 }, /* #36 */
    { 0x366bc2, 0x366bc3, 0xe42a, 0xf04a, 0x886f, 0xf8d7, 0x41d1, 0 }, /* #37 */
    { 0x103a02, 0x103a03, 0x219d, 0xd7e2, 0xe89a, 0xff50, 0xfaca, 0 }, /* #38 */
    { 0x2f0682, 0x2f0e83, 0xf508, 0x8598, 0x0a76, 0x01ef, 0xd2d3, 0 }, /* #39 */
    { 0x073a17, 0x073a17, 0xbc34, 0xc858, 0xfd83, 0x0fa4, 0xc4ee, 0 }, /* #40 */
    { 0x091196, 0x091997, 0x8d84, 0xa930, 0xdab5, 0x1115, 0xd9cc, 0 }, /* #41 */
    { 0x1b7a82, 0x1b7a83, 0x95e7, 0xd75f, 0x9a0a, 0xf7cc, 0x13c9, 0 }, /* #42 */
    { 0x162347, 0x162b47, 0xda52, 0x7be0, 0x47d7, 0x0ea7, 0x9c70, 0 }, /* #43 */
    { 0x2a0007, 0x2a0807, 0xfb22, 0xc68a, 0xae1b, 0x026c, 0x8075, 0 }, /* #44 */
    { 0x163793, 0x163f93, 0x69a7, 0x99c9, 0x56a5, 0x2dd5, 0x6f0f, 0 }, /* #45 */
    { 0x236e13, 0x236e13, 0xefba, 0x7ca0, 0xcde1, 0xf835, 0x7a90, 0 }, /* #46 */
    { 0x0d3c16, 0x0d3c17, 0x852b, 0x0dd3, 0xee74, 0xf575, 0x15f9, 0 }, /* #47 */
    { 0x1841c7, 0x1849c7, 0x7cda, 0x750a, 0x09bb, 0xfec4, 0xfd79, 0 }, /* #48 */
    { 0x264917, 0x264917, 0x3ca1, 0xdf42, 0xa5d2, 0xeaaf, 0xa602, 0 }, /* #49 */
    { 0x005716, 0x005f17, 0x175f, 0x6583, 0x8193, 0x0239, 0x185d, 0 }, /* #50 */
    { 0x1711c7, 0x1719c7, 0x0035, 0xf100, 0xa22d, 0x000f, 0x4d00, 0 }, /* #51 */
    { 0x3172c7, 0x317ac7, 0xb1f9, 0x0018, 0x6581, 0xfdea, 0x06d8, 0 }, /* #52 */
    { 0x3f0886, 0x3f0887, 0x9f0f, 0x960c, 0x9f2d, 0xe447, 0x4934, 0 }, /* #53 */
    { 0x3b15c3, 0x3b1dc3, 0x3e12, 0x3fbc, 0x4f1e, 0x1daf, 0x7a6e, 0 }, /* #54 */
    { 0x0d7453, 0x0d7c53, 0x9e34, 0xf7ec, 0x8ade, 0xeb80, 0x35a7, 0 }, /* #55 */
    { 0x240782, 0x240f83, 0xe90f, 0x5282, 0xe5c6, 0xf8b5, 0x515e, 0 }, /* #56 */
    { 0x067493, 0x067c93, 0xa6ee, 0xd366, 0x56ae, 0x0fc7, 0xd2a5, 0 }, /* #57 */
    { 0x2e78c2, 0x2e78c3, 0x3776, 0x4a78, 0x3733, 0x0bb0, 0x35f4, 0 }, /* #58 */
    { 0x3b3ed6, 0x3b3ed7, 0xefb3, 0x29c2, 0x10ad, 0x001d, 0xfe36, 0 }, /* #59 */
    { 0x2332d2, 0x233ad3, 0xb57f, 0x5409, 0xdace, 0xfcf4, 0x0a77, 0 }, /* #60 */
    { 0x332956, 0x332957, 0x80c7, 0x81fd, 0xc024, 0x2a30, 0xab1b, 0 }, /* #61 */
    { 0x230702, 0x230f03, 0xd9e2, 0xb4c2, 0xc04b, 0x1265, 0x8471, 0 }, /* #62 */
    { 0x212703, 0x212f03, 0xabd7, 0x6626, 0xec49, 0x0db6, 0xd64a, 0 }, /* #63 */
    { 0x3a52d6, 0x3a5ad7, 0x1cc4, 0x5828, 0x9dbe, 0x0483, 0x282a, 0 }, /* #64 */
    { 0x1e6083, 0x1e6883, 0x55cb, 0x6f70, 0xa919, 0xf561, 0xe050, 0 }, /* #65 */
    { 0x1250d3, 0x1258d3, 0x1178, 0xb850, 0xdd53, 0xf7e2, 0x8916, 0 }, /* #66 */
    { 0x0a1b56, 0x0a1b57, 0x9cd1, 0x66c0, 0x68ca, 0x2107, 0xaac0, 0 }, /* #67 */
    { 0x285706, 0x285f07, 0x8849, 0x157c, 0x9811, 0x1d2d, 0xc19c, 0 }, /* #68 */
    { 0x1215d7, 0x121dd7, 0x6345, 0xc440, 0x5423, 0xf032, 0xd740, 0 }, /* #69 */
    { 0x2e44c7, 0x2e4cc7, 0x50ce, 0x1626, 0x196b, 0xefbb, 0xcc75, 0 }, /* #70 */
    { 0x193d52, 0x193d53, 0x6cff, 0x0d22, 0xfb9a, 0x3376, 0x78de, 0 }, /* #71 */
    { 0x126157, 0x126957, 0x07d0, 0x0de0, 0x1da4, 0x013e, 0x28b6, 0 }, /* #72 */
    { 0x204c97, 0x204c97, 0xa09b, 0xcb16, 0x3dec, 0x2b5c, 0x8ba2, 0 }, /* #73 */
    { 0x2f6786, 0x2f6f87, 0x2873, 0x434a, 0xbc78, 0x1413, 0x7f0e, 0 }, /* #74 */
    { 0x087e42, 0x087e43, 0x0dd1, 0x06b9, 0x2afa, 0xfaa0, 0x9c69, 0 }, /* #75 */
    { 0x3f4217, 0x3f4a17, 0x6050, 0x4ef0, 0x2f2b, 0xecf5, 0xcd63, 0 }, /* #76 */
    { 0x262597, 0x262d97, 0x95cf, 0x7606, 0x64d3, 0x2e00, 0x911a, 0 }, /* #77 */
    { 0x270206, 0x270a07, 0x5f9a, 0x4b9a, 0x9f56, 0xed54, 0xce01, 0 }, /* #78 */
    { 0x2e5846, 0x2e5847, 0x212c, 0x0d60, 0xf753, 0xf3f4, 0xa308, 0 }, /* #79 */
    { 0x126297, 0x126a97, 0x49b0, 0x49e0, 0xe7a7, 0xeef0, 0xc4ba, 0 }, /* #80 */
    { 0x184d52, 0x184d53, 0x747f, 0xf1e2, 0x4af9, 0x182b, 0x351e, 0 }, /* #81 */
    { 0x066417, 0x066c17, 0xe438, 0xe268, 0x580c, 0x0961, 0xa98b, 0 }, /* #82 */
    { 0x177317, 0x177b17, 0x9a3d, 0xc042, 0x2f7c, 0x2664, 0x9f6a, 0 }, /* #83 */
    { 0x131282, 0x131a83, 0x6105, 0x308a, 0xabad, 0xfead, 0xfc82, 0 }, /* #84 */
    { 0x266107, 0x266907, 0xe6d1, 0xfefe, 0xbfb2, 0xf582, 0x6a9e, 0 }, /* #85 */
    { 0x265697, 0x265e97, 0x5aa2, 0x88f8, 0x594f, 0x26d9, 0x6dbc, 0 }, /* #86 */
    { 0x110bc2, 0x110bc3, 0xf1fa, 0x9a06, 0x797d, 0xfc9a, 0x3dff, 0 }, /* #87 */
    { 0x173113, 0x173913, 0x640f, 0x70c3, 0x5326, 0xf513, 0xe40d, 0 }, /* #88 */
    { 0x0d28d6, 0x0d28d7, 0x3e04, 0xf5e8, 0xa7a9, 0x15ea, 0x5a7a, 0 }, /* #89 */
    { 0x2812c2, 0x281ac3, 0x69a9, 0x5d27, 0xfc8e, 0xfa59, 0xf24f, 0 }, /* #90 */
    { 0x1f5a02, 0x1f5a03, 0x4b93, 0x1160, 0xb9f4, 0x1468, 0x4520, 0 }, /* #91 */
    { 0x1d73d6, 0x1d7bd7, 0xa0e7, 0x62ee, 0xc99b, 0xf95b, 0x11e2, 0 }, /* #92 */
    { 0x3e2e56, 0x3e2e57, 0xe5a5, 0x4aac, 0xeb7f, 0xfd81, 0x183c, 0 }, /* #93 */
    { 0x0d3a92, 0x0d3a93, 0x7239, 0xfeeb, 0x2079, 0xf64c, 0xea43, 0 }, /* #94 */
    { 0x137a82, 0x137a83, 0xaff6, 0xe150, 0x77bb, 0x1b0d, 0xa978, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u16_amd = RT_ELEMENTS(g_aTests_imul_u16_amd);

MULDIVU16_TEST_T const g_aTests_div_u16_amd[] =
{
    { 0x2d15c6, 0x2d15c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #0 */
    { 0x3a3c16, 0x3a3c16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #1 */
    { 0x011402, 0x011402, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #2 */
    { 0x105243, 0x105243, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #3 */
    { 0x1d52d6, 0x1d52d6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #4 */
    { 0x072f92, 0x072f92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #5 */
    { 0x0649d7, 0x0649d7, 0xc8ce, 0xc8ce, 0x6407, 0x6407, 0x0000, -1 }, /* #6 */
    { 0x091756, 0x091756, 0x1c56, 0x1c56, 0x7da1, 0x7da1, 0x0000, -1 }, /* #7 */
    { 0x205542, 0x205542, 0x68de, 0x68de, 0xe7ad, 0xe7ad, 0x0000, -1 }, /* #8 */
    { 0x364b03, 0x364b03, 0x48cd, 0x48cd, 0xa93b, 0xa93b, 0x0000, -1 }, /* #9 */
    { 0x2b0c92, 0x2b0c92, 0xfea5, 0xfea5, 0x2c5c, 0x2c5c, 0x0000, -1 }, /* #10 */
    { 0x0b0317, 0x0b0317, 0xf15e, 0xf15e, 0x5b72, 0x5b72, 0x0000, -1 }, /* #11 */
    { 0x272b06, 0x272b12, 0x2174, 0x8228, 0x7d28, 0xd90c, 0xf629, 0 }, /* #12 */
    { 0x0a1443, 0x0a1443, 0xf9e6, 0xf9e6, 0x959d, 0x959d, 0x8a49, -1 }, /* #13 */
    { 0x357447, 0x357413, 0x15a7, 0xa01e, 0x9b51, 0x1bed, 0xf853, 0 }, /* #14 */
    { 0x2e2056, 0x2e2012, 0xe41e, 0xb083, 0xa97f, 0x58a2, 0xf5d4, 0 }, /* #15 */
    { 0x265986, 0x265986, 0x7743, 0x7743, 0xd431, 0xd431, 0x071e, -1 }, /* #16 */
    { 0x2e42c3, 0x2e4213, 0xd69b, 0xfc4e, 0x9237, 0x1293, 0x945c, 0 }, /* #17 */
    { 0x2c2556, 0x2c2556, 0xfad5, 0xfad5, 0xc661, 0xc661, 0x21a3, -1 }, /* #18 */
    { 0x1b6ec7, 0x1b6ec7, 0x8458, 0x8458, 0xd9c8, 0xd9c8, 0x0673, -1 }, /* #19 */
    { 0x201993, 0x201993, 0xb76e, 0xb76e, 0xa626, 0xa626, 0x2bd8, -1 }, /* #20 */
    { 0x1a7e13, 0x1a7e13, 0xeddb, 0xeddb, 0xe15f, 0xe15f, 0x2d7c, -1 }, /* #21 */
    { 0x193703, 0x193713, 0x6395, 0x0cee, 0x0b45, 0xb47b, 0xdf1b, 0 }, /* #22 */
    { 0x3c0fc6, 0x3c0f12, 0x36e1, 0x2f39, 0x1e61, 0x6aea, 0xa4af, 0 }, /* #23 */
    { 0x0a14d3, 0x0a1413, 0x0ad5, 0xe0d1, 0x3900, 0x0d6d, 0x40e8, 0 }, /* #24 */
    { 0x015fc3, 0x015f13, 0x15c3, 0xed2c, 0xde5a, 0xd5c3, 0xf000, 0 }, /* #25 */
    { 0x2b2302, 0x2b2312, 0x96c8, 0xa47c, 0x660f, 0x4628, 0x9ed8, 0 }, /* #26 */
    { 0x392343, 0x392343, 0x95c0, 0x95c0, 0x8670, 0x8670, 0x5562, -1 }, /* #27 */
    { 0x173516, 0x173512, 0x6309, 0x019b, 0x00f4, 0x9004, 0x97df, 0 }, /* #28 */
    { 0x1f65d2, 0x1f6512, 0x2767, 0x26d8, 0x0c24, 0x0c07, 0x5004, 0 }, /* #29 */
    { 0x226c87, 0x226c87, 0x8fd4, 0x8fd4, 0xd262, 0xd262, 0x5b86, -1 }, /* #30 */
    { 0x145386, 0x145312, 0x858f, 0x9a3d, 0x937d, 0x78f3, 0xf4cc, 0 }, /* #31 */
    { 0x083752, 0x083752, 0x341f, 0x341f, 0xe500, 0xe500, 0x9a96, -1 }, /* #32 */
    { 0x1b1586, 0x1b1512, 0x4da1, 0xe532, 0xc514, 0xaf61, 0xdc20, 0 }, /* #33 */
    { 0x2f67c3, 0x2f6713, 0x7777, 0x418f, 0x3dac, 0x5e9a, 0xf0d3, 0 }, /* #34 */
    { 0x055592, 0x055512, 0x3185, 0xab5e, 0x3007, 0x4463, 0x47bf, 0 }, /* #35 */
    { 0x305d16, 0x305d16, 0x6894, 0x6894, 0xfcda, 0xfcda, 0x8b08, -1 }, /* #36 */
    { 0x294ad2, 0x294ad2, 0xcba8, 0xcba8, 0xabe4, 0xabe4, 0x25b5, -1 }, /* #37 */
    { 0x142496, 0x142412, 0x5947, 0xa1e2, 0x55c7, 0x32bb, 0x87a6, 0 }, /* #38 */
    { 0x143e57, 0x143e13, 0x4562, 0xaa51, 0x57a2, 0x682a, 0x83b8, 0 }, /* #39 */
    { 0x153886, 0x153886, 0x9e63, 0x9e63, 0xb4ae, 0xb4ae, 0x230a, -1 }, /* #40 */
    { 0x2704d6, 0x2704d6, 0x2da6, 0x2da6, 0xf7f0, 0xf7f0, 0xdc87, -1 }, /* #41 */
    { 0x112856, 0x112812, 0x216b, 0x11e0, 0x0c5d, 0x8eab, 0xb10a, 0 }, /* #42 */
    { 0x1717d2, 0x171712, 0xaf37, 0xbc9c, 0x516b, 0x2363, 0x6e83, 0 }, /* #43 */
    { 0x075f57, 0x075f13, 0x3221, 0x2a0d, 0x192c, 0x9215, 0x993c, 0 }, /* #44 */
    { 0x254e17, 0x254e13, 0x0310, 0x1f59, 0x1ace, 0x6d25, 0xdae3, 0 }, /* #45 */
    { 0x1a28d2, 0x1a28d2, 0xa386, 0xa386, 0xeb9c, 0xeb9c, 0x6505, -1 }, /* #46 */
    { 0x006406, 0x006412, 0x7cd3, 0x1e76, 0x132f, 0x41a1, 0xa13b, 0 }, /* #47 */
    { 0x235052, 0x235052, 0xf109, 0xf109, 0xb505, 0xb505, 0x8dbe, -1 }, /* #48 */
    { 0x083b92, 0x083b92, 0xcfe5, 0xcfe5, 0xf280, 0xf280, 0xf20a, -1 }, /* #49 */
    { 0x3602c6, 0x360212, 0xd4be, 0x65e2, 0x41f6, 0x2720, 0xa5bf, 0 }, /* #50 */
    { 0x2b4612, 0x2b4612, 0x0e1c, 0x0e1c, 0x56bb, 0x56bb, 0x1b29, -1 }, /* #51 */
    { 0x342706, 0x342712, 0xb771, 0xfa48, 0x7324, 0x3bc1, 0x75c6, 0 }, /* #52 */
    { 0x0b4043, 0x0b4013, 0xb7a6, 0xf91c, 0xf5d3, 0x7626, 0xfca0, 0 }, /* #53 */
    { 0x2e1596, 0x2e1512, 0x6eb9, 0x4326, 0x417b, 0x7461, 0xf9a4, 0 }, /* #54 */
    { 0x0a1383, 0x0a1313, 0x4cec, 0x615f, 0x568b, 0x5574, 0xe388, 0 }, /* #55 */
    { 0x390246, 0x390212, 0x514e, 0xf9d1, 0xdf34, 0xab74, 0xe4ba, 0 }, /* #56 */
    { 0x060bc7, 0x060b13, 0xf22f, 0x1ca6, 0x166a, 0xc0e7, 0xc84c, 0 }, /* #57 */
    { 0x1732c7, 0x1732c7, 0xf6ce, 0xf6ce, 0x569f, 0x569f, 0x068a, -1 }, /* #58 */
    { 0x196383, 0x196383, 0x8f25, 0x8f25, 0xd740, 0xd740, 0xcf2e, -1 }, /* #59 */
    { 0x3d7fd3, 0x3d7f13, 0x43d1, 0x69d9, 0x55df, 0x07a1, 0xcfb0, 0 }, /* #60 */
    { 0x3a2ed6, 0x3a2e12, 0x91a9, 0x9d93, 0x2fb1, 0x0775, 0x4d7c, 0 }, /* #61 */
    { 0x1d0cc6, 0x1d0cc6, 0x586d, 0x586d, 0x7450, 0x7450, 0x5b3e, -1 }, /* #62 */
    { 0x046dd6, 0x046d12, 0xa50a, 0xa70b, 0x6ea7, 0x28a3, 0xa995, 0 }, /* #63 */
    { 0x3806c3, 0x380613, 0x861a, 0xa227, 0x53d7, 0x81ef, 0x845d, 0 }, /* #64 */
    { 0x353582, 0x353582, 0x31c6, 0x31c6, 0xdcfb, 0xdcfb, 0x0e65, -1 }, /* #65 */
    { 0x321703, 0x321703, 0x7e22, 0x7e22, 0xf1a1, 0xf1a1, 0x9151, -1 }, /* #66 */
    { 0x077953, 0x077913, 0xc64b, 0xa576, 0x7295, 0x01a5, 0xb149, 0 }, /* #67 */
    { 0x0a3812, 0x0a3812, 0xb23a, 0xb23a, 0x3655, 0x3655, 0x1e4c, -1 }, /* #68 */
    { 0x3d20c7, 0x3d2013, 0x4b76, 0x4f5e, 0x4ede, 0x561c, 0xfe63, 0 }, /* #69 */
    { 0x132592, 0x132512, 0xf91f, 0xe4a3, 0x910f, 0x5e5b, 0xa26c, 0 }, /* #70 */
    { 0x060483, 0x060413, 0xa290, 0xcf42, 0xaf64, 0x2c48, 0xd8a4, 0 }, /* #71 */
    { 0x0032d2, 0x003212, 0x76d5, 0xc745, 0xa407, 0x14b3, 0xd2ba, 0 }, /* #72 */
    { 0x0d6213, 0x0d6213, 0xb40c, 0xfac2, 0xac30, 0x38f8, 0xafca, 0 }, /* #73 */
    { 0x341192, 0x341192, 0x6586, 0x6586, 0x61dd, 0x61dd, 0x027c, -1 }, /* #74 */
    { 0x3c37d7, 0x3c37d7, 0x4885, 0x4885, 0x1aaf, 0x1aaf, 0x08f6, -1 }, /* #75 */
    { 0x3d6ac3, 0x3d6a13, 0x5b5d, 0x6c1a, 0x4b87, 0x6105, 0xb2dc, 0 }, /* #76 */
    { 0x320f92, 0x320f12, 0xfa3e, 0x8679, 0x3d0e, 0x1b69, 0x743d, 0 }, /* #77 */
    { 0x1504d7, 0x150413, 0x8030, 0x3719, 0x0ff3, 0x3f74, 0x4a1c, 0 }, /* #78 */
    { 0x2c2046, 0x2c2046, 0x7b21, 0x7b21, 0xcfa4, 0xcfa4, 0x3140, -1 }, /* #79 */
    { 0x340f47, 0x340f13, 0xbf38, 0x31ae, 0x2990, 0x8fa2, 0xd62d, 0 }, /* #80 */
    { 0x2d58c6, 0x2d5812, 0x7bbc, 0xd094, 0x7f64, 0x2720, 0x9c5b, 0 }, /* #81 */
    { 0x002fc2, 0x002fc2, 0x513f, 0x513f, 0x296e, 0x296e, 0x100c, -1 }, /* #82 */
    { 0x221f17, 0x221f13, 0x3f2b, 0x84d4, 0x4d0d, 0x452b, 0x9480, 0 }, /* #83 */
    { 0x0a0447, 0x0a0447, 0xc635, 0xc635, 0xe63d, 0xe63d, 0xd832, -1 }, /* #84 */
    { 0x164883, 0x164883, 0xa7bd, 0xa7bd, 0x9777, 0x9777, 0x1acd, -1 }, /* #85 */
    { 0x1e1683, 0x1e1683, 0x4591, 0x4591, 0x4150, 0x4150, 0x0c7b, -1 }, /* #86 */
    { 0x3d0a03, 0x3d0a13, 0x6e24, 0x04ab, 0x0410, 0xc491, 0xdeb9, 0 }, /* #87 */
    { 0x3f4807, 0x3f4813, 0x296c, 0x9577, 0x8082, 0xb756, 0xdc1a, 0 }, /* #88 */
    { 0x236a07, 0x236a13, 0x3ac5, 0xdc25, 0x8972, 0x14fc, 0x9fd5, 0 }, /* #89 */
    { 0x0a5b52, 0x0a5b12, 0xfe95, 0x0558, 0x0319, 0x7295, 0x9480, 0 }, /* #90 */
    { 0x2a6a52, 0x2a6a12, 0x0b65, 0x5826, 0x4120, 0x4859, 0xbd22, 0 }, /* #91 */
    { 0x1e1e87, 0x1e1e87, 0xf1b6, 0xf1b6, 0xe4b8, 0xe4b8, 0x0499, -1 }, /* #92 */
    { 0x1a6817, 0x1a6813, 0xa6dd, 0x2a54, 0x1176, 0x1305, 0x699e, 0 }, /* #93 */
    { 0x2c3a47, 0x2c3a47, 0xe667, 0xe667, 0x9144, 0x9144, 0x19f3, -1 }, /* #94 */
    { 0x1d4606, 0x1d4612, 0x836b, 0x6b4f, 0x1850, 0x321c, 0x3a01, 0 }, /* #95 */
};
uint32_t const g_cTests_div_u16_amd = RT_ELEMENTS(g_aTests_div_u16_amd);

MULDIVU16_TEST_T const g_aTests_idiv_u16_amd[] =
{
    { 0x253dd6, 0x253dd6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #0 */
    { 0x3e5716, 0x3e5716, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #1 */
    { 0x1d1782, 0x1d1782, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #2 */
    { 0x3a1457, 0x3a1457, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #3 */
    { 0x154d03, 0x154d03, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #4 */
    { 0x3d5c17, 0x3d5c17, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, -1 }, /* #5 */
    { 0x2b2107, 0x2b2107, 0x3a79, 0x3a79, 0xfc5d, 0xfc5d, 0x0000, -1 }, /* #6 */
    { 0x3e4953, 0x3e4953, 0x2af5, 0x2af5, 0x5917, 0x5917, 0x0000, -1 }, /* #7 */
    { 0x167ac7, 0x167ac7, 0x52ad, 0x52ad, 0xfa55, 0xfa55, 0x0000, -1 }, /* #8 */
    { 0x240583, 0x240583, 0xd3c3, 0xd3c3, 0xceab, 0xceab, 0x0000, -1 }, /* #9 */
    { 0x214747, 0x214747, 0xc9e3, 0xc9e3, 0x6063, 0x6063, 0x0000, -1 }, /* #10 */
    { 0x3a3883, 0x3a3883, 0x1369, 0x1369, 0x6baf, 0x6baf, 0x0000, -1 }, /* #11 */
    { 0x0f43d3, 0x0f43d3, 0x8704, 0x8704, 0x4a63, 0x4a63, 0xe7c9, -1 }, /* #12 */
    { 0x2d5982, 0x2d5982, 0x1167, 0x1167, 0xb048, 0xb048, 0x85f4, -1 }, /* #13 */
    { 0x2a0242, 0x2a0242, 0x4925, 0x4925, 0x3237, 0x3237, 0xf503, -1 }, /* #14 */
    { 0x221a52, 0x221a52, 0xa617, 0xa617, 0x5f74, 0x5f74, 0xdd1d, -1 }, /* #15 */
    { 0x073b17, 0x073b17, 0xd5fc, 0xd5fc, 0xa7f2, 0xa7f2, 0x1899, -1 }, /* #16 */
    { 0x021593, 0x021513, 0x9829, 0xa467, 0xe8b3, 0xd17e, 0x411d, 0 }, /* #17 */
    { 0x3d0007, 0x3d0007, 0x366b, 0x366b, 0xbd2e, 0xbd2e, 0x187f, -1 }, /* #18 */
    { 0x1b5892, 0x1b5892, 0x3d1d, 0x3d1d, 0x4f3d, 0x4f3d, 0x30bd, -1 }, /* #19 */
    { 0x1b5106, 0x1b5106, 0x1ff9, 0x1ff9, 0x3791, 0x3791, 0x2d28, -1 }, /* #20 */
    { 0x174992, 0x174992, 0xe7af, 0xe7af, 0xb69d, 0xb69d, 0x130a, -1 }, /* #21 */
    { 0x3d2213, 0x3d2213, 0x4f2e, 0x4f2e, 0x6615, 0x6615, 0xf7c4, -1 }, /* #22 */
    { 0x390692, 0x390692, 0xe7aa, 0xe7aa, 0x7f98, 0x7f98, 0x11a4, -1 }, /* #23 */
    { 0x154093, 0x154093, 0xac62, 0xac62, 0x579a, 0x579a, 0x46c6, -1 }, /* #24 */
    { 0x1a2617, 0x1a2617, 0xb2c7, 0xb2c7, 0x478a, 0x478a, 0xe2f8, -1 }, /* #25 */
    { 0x311302, 0x311312, 0x1c97, 0xc8a2, 0x193f, 0x4a4b, 0x8b46, 0 }, /* #26 */
    { 0x1c2386, 0x1c2386, 0xbf8c, 0xbf8c, 0xbf43, 0xbf43, 0xdfc2, -1 }, /* #27 */
    { 0x1a5003, 0x1a5003, 0xfd99, 0xfd99, 0x7f93, 0x7f93, 0xc16d, -1 }, /* #28 */
    { 0x2b0706, 0x2b0706, 0x4cc3, 0x4cc3, 0xb8e2, 0xb8e2, 0x239d, -1 }, /* #29 */
    { 0x0b5382, 0x0b5382, 0x3037, 0x3037, 0xab91, 0xab91, 0xd606, -1 }, /* #30 */
    { 0x323187, 0x323187, 0x02f5, 0x02f5, 0x5b4c, 0x5b4c, 0x148c, -1 }, /* #31 */
    { 0x112083, 0x112083, 0x679c, 0x679c, 0x4991, 0x4991, 0xf791, -1 }, /* #32 */
    { 0x3d7cd6, 0x3d7cd6, 0x64c8, 0x64c8, 0xc4f1, 0xc4f1, 0xda08, -1 }, /* #33 */
    { 0x2b6286, 0x2b6212, 0xb7e8, 0xa0b1, 0x1abe, 0x22de, 0xb82a, 0 }, /* #34 */
    { 0x2e6f57, 0x2e6f13, 0xa6e9, 0x7529, 0x2edb, 0x020e, 0x6663, 0 }, /* #35 */
    { 0x091a03, 0x091a03, 0xaa71, 0xaa71, 0x1b19, 0x1b19, 0x27a6, -1 }, /* #36 */
    { 0x123d42, 0x123d42, 0xa14f, 0xa14f, 0x8589, 0x8589, 0x0018, -1 }, /* #37 */
    { 0x0a6686, 0x0a6686, 0xa6fe, 0xa6fe, 0x80da, 0x80da, 0x9ac0, -1 }, /* #38 */
    { 0x154c92, 0x154c12, 0x3714, 0xe7b8, 0x09f4, 0x3394, 0x9710, 0 }, /* #39 */
    { 0x152956, 0x152956, 0x5d50, 0x5d50, 0x3690, 0x3690, 0x570d, -1 }, /* #40 */
    { 0x2142d2, 0x2142d2, 0xf9de, 0xf9de, 0x6a79, 0x6a79, 0x501b, -1 }, /* #41 */
    { 0x3e57c6, 0x3e57c6, 0x392c, 0x392c, 0x86ae, 0x86ae, 0x3253, -1 }, /* #42 */
    { 0x331946, 0x331946, 0x69bf, 0x69bf, 0x9293, 0x9293, 0x1f3e, -1 }, /* #43 */
    { 0x025c47, 0x025c47, 0x9dc7, 0x9dc7, 0x9cda, 0x9cda, 0xdb47, -1 }, /* #44 */
    { 0x2f37c7, 0x2f3713, 0x9172, 0x6091, 0xd795, 0xc0d6, 0x94dc, 0 }, /* #45 */
    { 0x201a93, 0x201a93, 0x7761, 0x7761, 0x9899, 0x9899, 0x8594, -1 }, /* #46 */
    { 0x047643, 0x047643, 0x08ad, 0x08ad, 0x9efb, 0x9efb, 0xa743, -1 }, /* #47 */
    { 0x2526c3, 0x2526c3, 0x2885, 0x2885, 0x6115, 0x6115, 0xaf09, -1 }, /* #48 */
    { 0x2e1e16, 0x2e1e12, 0x9ee5, 0x5c3e, 0xee06, 0xeba1, 0xce1e, 0 }, /* #49 */
    { 0x3d1e53, 0x3d1e53, 0xe7f6, 0xe7f6, 0xd09d, 0xd09d, 0x2ab9, -1 }, /* #50 */
    { 0x176782, 0x176782, 0x140d, 0x140d, 0x933a, 0x933a, 0xc885, -1 }, /* #51 */
    { 0x1236d2, 0x1236d2, 0xc24e, 0xc24e, 0x982f, 0x982f, 0x4a2e, -1 }, /* #52 */
    { 0x393407, 0x393413, 0xefb7, 0x4e28, 0xf024, 0xdf0f, 0xcc11, 0 }, /* #53 */
    { 0x3b2086, 0x3b2012, 0x558a, 0xebd3, 0xfba5, 0xf79d, 0x373f, 0 }, /* #54 */
    { 0x2a3042, 0x2a3042, 0x524e, 0x524e, 0xb772, 0xb772, 0xc569, -1 }, /* #55 */
    { 0x302a02, 0x302a12, 0xead7, 0x930c, 0xcf20, 0xcce7, 0x72d4, 0 }, /* #56 */
    { 0x226393, 0x226313, 0x54b0, 0x0d30, 0xf9bb, 0x9f00, 0x8659, 0 }, /* #57 */
    { 0x0e5593, 0x0e5593, 0xf061, 0xf061, 0x9357, 0x9357, 0x6fe6, -1 }, /* #58 */
    { 0x217d03, 0x217d13, 0x402b, 0x56e0, 0xddef, 0xab0b, 0x9b9f, 0 }, /* #59 */
    { 0x347f13, 0x347f13, 0x5c25, 0x5c25, 0xb979, 0xb979, 0xc14f, -1 }, /* #60 */
    { 0x0e5943, 0x0e5943, 0x5761, 0x5761, 0xc845, 0xc845, 0x44d9, -1 }, /* #61 */
    { 0x1e1656, 0x1e1656, 0x49b3, 0x49b3, 0x9c19, 0x9c19, 0x5323, -1 }, /* #62 */
    { 0x0a2107, 0x0a2107, 0x673b, 0x673b, 0x6034, 0x6034, 0x1c17, -1 }, /* #63 */
    { 0x2352c6, 0x2352c6, 0xce3d, 0xce3d, 0x2308, 0x2308, 0xf94f, -1 }, /* #64 */
    { 0x1269c7, 0x1269c7, 0x47a0, 0x47a0, 0x9624, 0x9624, 0x4192, -1 }, /* #65 */
    { 0x2b6f02, 0x2b6f02, 0xb9f8, 0xb9f8, 0x4ce7, 0x4ce7, 0x0f59, -1 }, /* #66 */
    { 0x2558c3, 0x2558c3, 0x5ee3, 0x5ee3, 0x8a5e, 0x8a5e, 0x40ad, -1 }, /* #67 */
    { 0x2d5356, 0x2d5356, 0xd4d4, 0xd4d4, 0xb02f, 0xb02f, 0x1680, -1 }, /* #68 */
    { 0x2f31d7, 0x2f3113, 0x356a, 0x43ad, 0xde96, 0x8751, 0x819d, 0 }, /* #69 */
    { 0x377883, 0x377883, 0x5dc6, 0x5dc6, 0xa3ce, 0xa3ce, 0x2aac, -1 }, /* #70 */
    { 0x032c52, 0x032c52, 0x5981, 0x5981, 0x31d2, 0x31d2, 0xe204, -1 }, /* #71 */
    { 0x3e0b42, 0x3e0b42, 0xcd7b, 0xcd7b, 0x63f1, 0x63f1, 0x97b5, -1 }, /* #72 */
    { 0x070747, 0x070747, 0xcad1, 0xcad1, 0x818a, 0x818a, 0xbd0b, -1 }, /* #73 */
    { 0x381f12, 0x381f12, 0x97b2, 0x97b2, 0x2764, 0x2764, 0x3bd1, -1 }, /* #74 */
    { 0x332512, 0x332512, 0x568e, 0x568e, 0x946b, 0x946b, 0x379d, -1 }, /* #75 */
    { 0x3d3347, 0x3d3347, 0x2cbb, 0x2cbb, 0xd8ea, 0xd8ea, 0x03e0, -1 }, /* #76 */
    { 0x040606, 0x040606, 0x8ddd, 0x8ddd, 0xcf03, 0xcf03, 0xf2e5, -1 }, /* #77 */
    { 0x195493, 0x195493, 0x325d, 0x325d, 0x9b5a, 0x9b5a, 0x53fa, -1 }, /* #78 */
    { 0x296902, 0x296902, 0xbad6, 0xbad6, 0x4714, 0x4714, 0x777e, -1 }, /* #79 */
    { 0x390013, 0x390013, 0xa1e3, 0xa1e3, 0x564f, 0x564f, 0x99ba, -1 }, /* #80 */
    { 0x394097, 0x394013, 0x9198, 0x87e1, 0xca64, 0xef39, 0x723f, 0 }, /* #81 */
    { 0x380ad2, 0x380a12, 0x34a0, 0x911f, 0x1256, 0x0b0a, 0xd5aa, 0 }, /* #82 */
    { 0x2515d3, 0x2515d3, 0xe1d4, 0xe1d4, 0x359c, 0x359c, 0xb955, -1 }, /* #83 */
    { 0x2c2ac7, 0x2c2ac7, 0xb8ad, 0xb8ad, 0x7c6d, 0x7c6d, 0xeb17, -1 }, /* #84 */
    { 0x353703, 0x353703, 0x6eae, 0x6eae, 0x74b5, 0x74b5, 0x54da, -1 }, /* #85 */
    { 0x1645c7, 0x1645c7, 0x373e, 0x373e, 0xdbdf, 0xdbdf, 0x3d69, -1 }, /* #86 */
    { 0x2a4c06, 0x2a4c06, 0x7713, 0x7713, 0x952c, 0x952c, 0x828b, -1 }, /* #87 */
    { 0x082d83, 0x082d83, 0xd768, 0xd768, 0x17ed, 0x17ed, 0xea3f, -1 }, /* #88 */
    { 0x2761c2, 0x2761c2, 0xf46d, 0xf46d, 0x459d, 0x459d, 0x4fef, -1 }, /* #89 */
    { 0x151396, 0x151312, 0x9430, 0x7f26, 0xf3a9, 0xed1a, 0xe729, 0 }, /* #90 */
    { 0x346a52, 0x346a12, 0x580a, 0xdcc4, 0x0f51, 0x0176, 0x90b5, 0 }, /* #91 */
    { 0x1b5f03, 0x1b5f03, 0xac9e, 0xac9e, 0xcc90, 0xcc90, 0x404b, -1 }, /* #92 */
    { 0x290683, 0x290683, 0xb388, 0xb388, 0xc974, 0xc974, 0x064a, -1 }, /* #93 */
    { 0x210fc7, 0x210f13, 0xa27e, 0x87a7, 0x3270, 0x2d6b, 0x94b5, 0 }, /* #94 */
    { 0x3c0982, 0x3c0982, 0x9df9, 0x9df9, 0x5cce, 0x5cce, 0xf66e, -1 }, /* #95 */
};
uint32_t const g_cTests_idiv_u16_amd = RT_ELEMENTS(g_aTests_idiv_u16_amd);

MULDIVU32_TEST_T const g_aTests_mul_u32_amd[] =
{
    { 0x0b4212, 0x0b4212, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #0 */
    { 0x1f6c82, 0x1f6482, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #1 */
    { 0x147d16, 0x147516, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #2 */
    { 0x1f3c57, 0x1f3456, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #3 */
    { 0x081d57, 0x081556, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #4 */
    { 0x000083, 0x000082, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #5 */
    { 0x364356, 0x364356, 0x611a0f94, 0x00000000, 0x35f4ef59, 0x00000000, 0x00000000, 0 }, /* #6 */
    { 0x0d7887, 0x0d7086, 0xfdb98685, 0x00000000, 0xdf2ea56b, 0x00000000, 0x00000000, 0 }, /* #7 */
    { 0x2e4496, 0x2e4496, 0xf05b1a39, 0x00000000, 0x2d16acfc, 0x00000000, 0x00000000, 0 }, /* #8 */
    { 0x366b86, 0x366386, 0xfea7a6a7, 0x00000000, 0x30ae3e13, 0x00000000, 0x00000000, 0 }, /* #9 */
    { 0x2d0b12, 0x2d0312, 0xf0cd1cd8, 0x00000000, 0xaa20c1ef, 0x00000000, 0x00000000, 0 }, /* #10 */
    { 0x1c6852, 0x1c6052, 0x70866fdf, 0x00000000, 0x0a1ad330, 0x00000000, 0x00000000, 0 }, /* #11 */
    { 0x1e7956, 0x1e7957, 0x228df416, 0x02801224, 0x5593e213, 0x044d5627, 0x1fdf5876, 0 }, /* #12 */
    { 0x283b53, 0x283b53, 0xb2224639, 0x409d0c3c, 0x283082b9, 0x79ec9bda, 0xaf384e1c, 0 }, /* #13 */
    { 0x102856, 0x102857, 0x8751f200, 0xf9aab000, 0x14e70294, 0x4921f974, 0x8a5a6e18, 0 }, /* #14 */
    { 0x316ed7, 0x316ed7, 0x857fb64f, 0x92ab7bb2, 0x039a202e, 0x83438c52, 0xfbb6ceae, 0 }, /* #15 */
    { 0x3b2002, 0x3b2803, 0x8f3ac8c4, 0x77cdb980, 0x5c52e47f, 0x036872ab, 0x06175c60, 0 }, /* #16 */
    { 0x312597, 0x312d97, 0xfff8d3c8, 0xd8ebc838, 0xead4db38, 0x3c829d6c, 0x3c844f7f, 0 }, /* #17 */
    { 0x3f5a96, 0x3f5a97, 0x271c8d0a, 0xce2466da, 0x036f9f95, 0x16d0c465, 0x955611c9, 0 }, /* #18 */
    { 0x294ec6, 0x294ec7, 0x0f4ddda3, 0x7cb61ace, 0x01122102, 0x0c448640, 0xcd350ada, 0 }, /* #19 */
    { 0x1b15c7, 0x1b1dc7, 0xafc874d0, 0x13584ce0, 0x116d3d05, 0x3e512918, 0x5ac13d06, 0 }, /* #20 */
    { 0x0d0356, 0x0d0b57, 0x66a9eaad, 0x6bec0449, 0x1d6e3883, 0x2c9d6a4d, 0x6f402f8d, 0 }, /* #21 */
    { 0x316a17, 0x316a17, 0x5c47d0c0, 0x1ab25280, 0xeed9fbc1, 0x3cf6b3c2, 0xa91f53ee, 0 }, /* #22 */
    { 0x3f6407, 0x3f6c07, 0x2649ca54, 0x869e36d8, 0xb682646f, 0x0ff01002, 0x6a8fcf5e, 0 }, /* #23 */
    { 0x373a06, 0x373a07, 0xe48ab971, 0x1159c3b9, 0x0f94dd48, 0x3078eccb, 0x364bcac9, 0 }, /* #24 */
    { 0x354a43, 0x354a43, 0xf133b225, 0x1b605748, 0xf8f4d532, 0xc5b7acb4, 0xd1d903a8, 0 }, /* #25 */
    { 0x3f1397, 0x3f1b97, 0x48e980a7, 0x27d07e1f, 0xd9fd5883, 0x023483bf, 0x07be0dc9, 0 }, /* #26 */
    { 0x3b2bc3, 0x3b2bc3, 0x788058ba, 0x4078dec4, 0xf2413850, 0x65999821, 0xd7d846ca, 0 }, /* #27 */
    { 0x0f0402, 0x0f0c03, 0x42a35994, 0x2a3cecb4, 0xf24e25b9, 0x4080d738, 0xf7cc8129, 0 }, /* #28 */
    { 0x336813, 0x336813, 0xb4d0f2d0, 0xbd977ea0, 0x81f550c7, 0x934b66c2, 0xd08a39d2, 0 }, /* #29 */
    { 0x1a1253, 0x1a1a53, 0x9af2f8a2, 0x973f8cbe, 0x45a18254, 0x9053b5ca, 0xee735baf, 0 }, /* #30 */
    { 0x0855d6, 0x085dd7, 0x37c51f75, 0x483c14c7, 0x6e9477c1, 0x04a1988e, 0x154237cb, 0 }, /* #31 */
    { 0x1c7b56, 0x1c7b57, 0x1a785f93, 0x475cd6f7, 0x91c1be3e, 0x074f3436, 0x46b0e18d, 0 }, /* #32 */
    { 0x281417, 0x281c17, 0x04c8b435, 0x54eab91c, 0x54af0607, 0x0475f83f, 0xeeb4c02c, 0 }, /* #33 */
    { 0x344156, 0x344957, 0x5f0ac29d, 0x7c7a1665, 0x7b6ee156, 0x284c8b90, 0x6c8c1469, 0 }, /* #34 */
    { 0x101052, 0x101853, 0x5221121b, 0xb605894e, 0xb92bd4bc, 0x37603009, 0xac9bc0ca, 0 }, /* #35 */
    { 0x0e2487, 0x0e2c87, 0xa7a8f6bc, 0xa3c6b5f4, 0x85dec4fb, 0x41b69114, 0x64565e93, 0 }, /* #36 */
    { 0x1b1782, 0x1b1f83, 0x4a65f357, 0xfc038a42, 0x2b4ada16, 0x4a2aa59b, 0xff33f08e, 0 }, /* #37 */
    { 0x361b06, 0x361b07, 0x0369e7b0, 0x0981b400, 0x5de9f663, 0x00936a8b, 0x2b2f0dc0, 0 }, /* #38 */
    { 0x2f4e46, 0x2f4e47, 0xd4979a05, 0x71ec6fdb, 0xad00e9a6, 0x482ea0ba, 0x56eba85f, 0 }, /* #39 */
    { 0x2c5906, 0x2c5907, 0xd01c2eac, 0x8d8c3904, 0x6a3c474a, 0x4a5239f7, 0x5b6c81c3, 0 }, /* #40 */
    { 0x3b3747, 0x3b3f47, 0x1329ccd5, 0xefe9f739, 0x1d46bdc7, 0x0ababdb1, 0x8f5562d5, 0 }, /* #41 */
    { 0x0b15d2, 0x0b1dd3, 0xf7d8a2b0, 0x5269acf0, 0xefa0ed74, 0xa8b89b2e, 0xae4593ed, 0 }, /* #42 */
    { 0x324456, 0x324c57, 0x5138183c, 0x40ce2e9c, 0x39bf34cc, 0x1c43f2d3, 0x591778e9, 0 }, /* #43 */
    { 0x0315d7, 0x031dd7, 0x56908b42, 0x8f7867ee, 0x6ba6a5a0, 0x18f1746e, 0x49c3e297, 0 }, /* #44 */
    { 0x112c83, 0x112c83, 0xae415a77, 0x47184cb2, 0x849a732e, 0x51ae8406, 0x77ffd35e, 0 }, /* #45 */
    { 0x0d5d02, 0x0d5d03, 0x45aafb68, 0x0a38ae70, 0x1c5f8c93, 0x015e07b0, 0x05063646, 0 }, /* #46 */
    { 0x153017, 0x153817, 0x62522361, 0xc8df14d5, 0x9b5c1b56, 0x4836f39d, 0xbc06d9f5, 0 }, /* #47 */
    { 0x0f2352, 0x0f2b53, 0xe2f32174, 0x58f3394c, 0xc819796c, 0x0065c02f, 0x0072c66f, 0 }, /* #48 */
    { 0x012183, 0x012983, 0x7ddb0d65, 0x359e77f3, 0x384c819c, 0x5202fce5, 0xa6d16677, 0 }, /* #49 */
    { 0x1e4357, 0x1e4b57, 0x6158ae45, 0x46499024, 0xc51965f1, 0x4b769601, 0xc673b3d4, 0 }, /* #50 */
    { 0x234746, 0x234f47, 0x36adbe21, 0x810509fc, 0x889d8492, 0x2f4ac732, 0xdd6ab27c, 0 }, /* #51 */
    { 0x2c1ac6, 0x2c1ac7, 0x5dd3ce72, 0xf4d6d0e2, 0xbc96adaa, 0x1a8810d6, 0x486392f9, 0 }, /* #52 */
    { 0x063e92, 0x063e93, 0xeab56097, 0x1759110e, 0x29d86f68, 0x3b1d7778, 0x407a4b22, 0 }, /* #53 */
    { 0x1a2546, 0x1a2d47, 0xd6a28514, 0x7d0bb0f4, 0x07ceefa8, 0x1d36b0fa, 0x22d80299, 0 }, /* #54 */
    { 0x2c6d83, 0x2c6d83, 0x408c0185, 0xcc95f998, 0x67b7c30a, 0x148602ee, 0x5165fab8, 0 }, /* #55 */
    { 0x2f6fc7, 0x2f6fc7, 0xdc53b289, 0x4b977d9c, 0x3aee6fb9, 0x6aa4d51b, 0x7be919bc, 0 }, /* #56 */
    { 0x182456, 0x182c57, 0x814f3a81, 0x511ca851, 0x3889ebd2, 0x749afe26, 0xe6d965d1, 0 }, /* #57 */
    { 0x2b1046, 0x2b1847, 0x858c65d5, 0x50f5c1f4, 0xc47185cb, 0x81503289, 0xf7e1b024, 0 }, /* #58 */
    { 0x332807, 0x332807, 0x02d0b6f6, 0x6f5fd352, 0xd49bf2bf, 0x01858af5, 0x8a5de42b, 0 }, /* #59 */
    { 0x2e4856, 0x2e4857, 0xf564a0bf, 0x18a3bd4e, 0x617597cf, 0xe557e1d9, 0xef41a832, 0 }, /* #60 */
    { 0x0902d2, 0x090ad3, 0x1cedf7a0, 0x1ecf1800, 0x8b1c3836, 0x04b5d5be, 0x29ae87c0, 0 }, /* #61 */
    { 0x126383, 0x126b83, 0xc80adfb4, 0xdb77f20c, 0xd2dd4fc5, 0xc7bfee85, 0xffa0182f, 0 }, /* #62 */
    { 0x137716, 0x137f17, 0xa34507b2, 0x686167fc, 0xc8fc4935, 0x1b87875c, 0x2b2a3b2e, 0 }, /* #63 */
    { 0x137fd3, 0x137fd3, 0x5ab6c5a7, 0x7d710c5c, 0x956a8578, 0x018d142a, 0x04609444, 0 }, /* #64 */
    { 0x257e92, 0x257e93, 0xf1ee6208, 0x56f51e90, 0x196614d4, 0x3988f241, 0x3ce17752, 0 }, /* #65 */
    { 0x206883, 0x206883, 0x014388fb, 0xc2aae820, 0xb8d63836, 0x0046cba4, 0x38047e60, 0 }, /* #66 */
    { 0x050e06, 0x050e07, 0x34e626f3, 0x2f5ad1f2, 0xf20736a6, 0x0b7c3db9, 0x379506c6, 0 }, /* #67 */
    { 0x2f4d86, 0x2f4d87, 0x67a7e3fe, 0x5a9b10de, 0x3f694d08, 0x3e7520d3, 0x9a408991, 0 }, /* #68 */
    { 0x073cc3, 0x073cc3, 0xb1017a28, 0xa65bda70, 0x97faf13a, 0x981476e4, 0xdbf343f6, 0 }, /* #69 */
    { 0x396683, 0x396e83, 0x4cd67208, 0x862303c8, 0x92d871cd, 0x39a7dfac, 0xc0177439, 0 }, /* #70 */
    { 0x0f4a13, 0x0f4a13, 0xde126971, 0xabb5d430, 0x8ac88923, 0x6450196b, 0x73a37f30, 0 }, /* #71 */
    { 0x3342c6, 0x334ac7, 0x80a67936, 0x4843bae8, 0xf15fc88f, 0x6435cad0, 0xc7683d9c, 0 }, /* #72 */
    { 0x245092, 0x245893, 0xd878c53f, 0x8016acc7, 0x20ddd879, 0xa73e1a60, 0xc5c80e79, 0 }, /* #73 */
    { 0x2e2cc6, 0x2e2cc7, 0x2e85b8d9, 0x2e19b6f1, 0xcd2ae73f, 0x0ad981c8, 0x3bb3dfd9, 0 }, /* #74 */
    { 0x2d5f03, 0x2d5f03, 0x74b86af4, 0xd9a79650, 0xb775f509, 0x66a967a2, 0xe12a5f24, 0 }, /* #75 */
    { 0x0c6652, 0x0c6e53, 0x6751a45d, 0xeb1e119f, 0x60fe0aa9, 0x364119ea, 0x866dee2b, 0 }, /* #76 */
    { 0x2f4c53, 0x2f4c53, 0x3e3d7500, 0x15363d00, 0x9a8cff08, 0x17082bff, 0x5ebb94a9, 0 }, /* #77 */
    { 0x1d13d7, 0x1d1bd7, 0x50013cea, 0xb2ca1586, 0x41462edb, 0x34174682, 0xa6ae4d57, 0 }, /* #78 */
    { 0x173f43, 0x173f43, 0x0bd82943, 0x3dbc6ae7, 0x9c7d149b, 0x041044d3, 0x57d3fb8d, 0 }, /* #79 */
    { 0x277213, 0x277a13, 0x508e2290, 0xfe7069b0, 0xa37f246d, 0x377105be, 0xb030a323, 0 }, /* #80 */
    { 0x266786, 0x266f87, 0x29446da1, 0x0b662345, 0xcb799b05, 0x1942231f, 0x9cb06b25, 0 }, /* #81 */
    { 0x0a7987, 0x0a7987, 0xa77a6edb, 0x2def27e7, 0xd704001c, 0x2eddd32a, 0x47a35ae5, 0 }, /* #82 */
    { 0x241503, 0x241d03, 0x083ac50a, 0x2591fc96, 0xca5e3892, 0x05a6fd51, 0xafd3fe8f, 0 }, /* #83 */
    { 0x2d76d3, 0x2d7ed3, 0x101396e4, 0x51dcf080, 0xf6177bce, 0x0c0abf2e, 0xbfc12d20, 0 }, /* #84 */
    { 0x371517, 0x371d17, 0x871d1e3e, 0x33a5439a, 0x08ac9ceb, 0x41ae5dab, 0x7c722d93, 0 }, /* #85 */
    { 0x0e2cc7, 0x0e2cc7, 0x96a5a5cf, 0xed45b1b9, 0x5528c4a6, 0x883eadec, 0xe78699f7, 0 }, /* #86 */
    { 0x265c12, 0x265c13, 0xe6b0ff7b, 0x03dc78b2, 0xee54f815, 0x7e897396, 0x8c6b4276, 0 }, /* #87 */
    { 0x187806, 0x187807, 0x36b99be8, 0x8686dfa8, 0x53aab869, 0x0b2cd449, 0x3446c3d9, 0 }, /* #88 */
    { 0x237657, 0x237e57, 0xcd43e026, 0x3a29a866, 0x2330e597, 0x1902c1c8, 0x1f314f61, 0 }, /* #89 */
    { 0x127946, 0x127947, 0x7898130a, 0x21e93ebe, 0x880a3360, 0x0a38cfef, 0x15b30893, 0 }, /* #90 */
    { 0x377606, 0x377e07, 0x5b3912c5, 0xcd1b91a2, 0xbfff724c, 0x3777d174, 0x9ba91d3a, 0 }, /* #91 */
    { 0x3d79d3, 0x3d79d3, 0x355e3433, 0x3df2c793, 0xaf29ca9b, 0x06d1749b, 0x20b4bf21, 0 }, /* #92 */
    { 0x302047, 0x302847, 0xd758bd34, 0x8b6a802c, 0x42edace5, 0xa3258696, 0xc1f210b7, 0 }, /* #93 */
    { 0x275f42, 0x275f43, 0x95e6b5f7, 0x710eaf55, 0x9db4765c, 0x68aecc9a, 0xb2c6c213, 0 }, /* #94 */
    { 0x2f2843, 0x2f2843, 0xd00ff34c, 0x85f3247c, 0x472e0ad1, 0xb5e08ddb, 0xdfc82305, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u32_amd = RT_ELEMENTS(g_aTests_mul_u32_amd);

MULDIVU32_TEST_T const g_aTests_imul_u32_amd[] =
{
    { 0x334e43, 0x334642, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #0 */
    { 0x1f16d2, 0x1f16d2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #1 */
    { 0x3124c6, 0x3124c6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #2 */
    { 0x266213, 0x266212, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #3 */
    { 0x040683, 0x040682, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #4 */
    { 0x245c93, 0x245492, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 }, /* #5 */
    { 0x0c4706, 0x0c4706, 0xfc9e8626, 0x00000000, 0x8b7968b5, 0x00000000, 0x00000000, 0 }, /* #6 */
    { 0x0948d7, 0x0940d6, 0xe7d4f5bf, 0x00000000, 0x0e51e307, 0x00000000, 0x00000000, 0 }, /* #7 */
    { 0x0f67c3, 0x0f67c2, 0xc2428377, 0x00000000, 0x1cc51b9d, 0x00000000, 0x00000000, 0 }, /* #8 */
    { 0x176f06, 0x176706, 0x449a0172, 0x00000000, 0x5ad4e5ba, 0x00000000, 0x00000000, 0 }, /* #9 */
    { 0x362413, 0x362412, 0xab7bed1c, 0x00000000, 0x550bdf91, 0x00000000, 0x00000000, 0 }, /* #10 */
    { 0x025417, 0x025416, 0xbf3a2476, 0x00000000, 0x822fdf68, 0x00000000, 0x00000000, 0 }, /* #11 */
    { 0x3425d7, 0x342dd7, 0xa8e885e0, 0xd3c025c0, 0xb9ad4a1b, 0xdf635638, 0x5fdc5032, 0 }, /* #12 */
    { 0x1512d7, 0x151ad7, 0x168fb01a, 0xdbfc5434, 0xb3728688, 0x08431c18, 0x5dbfe202, 0 }, /* #13 */
    { 0x0f2143, 0x0f2943, 0x14d91c1b, 0xa825f679, 0xb9c45c21, 0xf66e1545, 0x8a7cb8fb, 0 }, /* #14 */
    { 0x140cd3, 0x140cd3, 0xfcf1443c, 0xf3222e7c, 0x03b6de66, 0x0071dbb0, 0xdac2fc71, 0 }, /* #15 */
    { 0x0b0d46, 0x0b0d47, 0x812787b8, 0x72f75450, 0xca3f6273, 0xdca6241a, 0x47587146, 0 }, /* #16 */
    { 0x344f43, 0x344f43, 0x4dd2f5c6, 0x808771ee, 0xad08daa7, 0xe2e7c4a9, 0xa04b41dd, 0 }, /* #17 */
    { 0x114586, 0x114d87, 0x1f2da572, 0x31a72698, 0x6dc8ef5b, 0x043eab6b, 0x22da77ac, 0 }, /* #18 */
    { 0x264f16, 0x264f17, 0xdd25452e, 0x818d9272, 0xb9e0ddf4, 0xfc742739, 0x1a0bfcaf, 0 }, /* #19 */
    { 0x3a5287, 0x3a5a87, 0xaa3f9e5d, 0x2988acda, 0xb6b62229, 0x1af805c6, 0xaf7ceea2, 0 }, /* #20 */
    { 0x166603, 0x166e03, 0x6aeaf709, 0x5ef5b282, 0xa80085e2, 0x185d1194, 0x3a55ccf2, 0 }, /* #21 */
    { 0x0241c3, 0x0249c3, 0x552d1fbf, 0x3dfcc890, 0x857f6049, 0xf9dbaf64, 0xed8a5b70, 0 }, /* #22 */
    { 0x394e17, 0x394e17, 0x3600159f, 0x024a6943, 0xff8bb63e, 0xee944eab, 0xad69e1dd, 0 }, /* #23 */
    { 0x2b0b56, 0x2b0b57, 0xa290f137, 0xd5c2e73c, 0x19cc846f, 0x169d049c, 0xc20aa0a4, 0 }, /* #24 */
    { 0x2e3e86, 0x2e3e87, 0xe61317df, 0xc60c60c1, 0xaf844500, 0xf769646c, 0x54ce1b5f, 0 }, /* #25 */
    { 0x270486, 0x270c87, 0x9c61e005, 0x61ceb10d, 0x1dba76d1, 0xcf6ef33a, 0x7ccec369, 0 }, /* #26 */
    { 0x3f6282, 0x3f6a83, 0xd11c7b6d, 0x639b1ada, 0x64eb5ab5, 0x076806ba, 0xd7903402, 0 }, /* #27 */
    { 0x061c17, 0x061c17, 0x3fb9fdcb, 0x0c00eeb6, 0x8bc53b1c, 0x0dccf41e, 0x37707562, 0 }, /* #28 */
    { 0x2a1157, 0x2a1957, 0x72ad8d79, 0xd444f797, 0x20233dc0, 0x2f55e2bc, 0x69ab398f, 0 }, /* #29 */
    { 0x0f7082, 0x0f7883, 0x9840ba45, 0x87258220, 0xc1851473, 0xe2d18716, 0x4801aba0, 0 }, /* #30 */
    { 0x2a1953, 0x2a1953, 0x63426d8e, 0x694f3df8, 0xde26b88b, 0x000b87dc, 0x001dbd24, 0 }, /* #31 */
    { 0x2c0683, 0x2c0e83, 0xf4f5204e, 0xfae6d860, 0x4c405bac, 0xfc528401, 0x5542a050, 0 }, /* #32 */
    { 0x2a6f17, 0x2a6f17, 0x21b6f488, 0x6b7a8000, 0xb2701e02, 0xfb9f4ab4, 0xdec25000, 0 }, /* #33 */
    { 0x123fc6, 0x123fc7, 0xdf191507, 0xcdf68697, 0x67b3af57, 0x077cf837, 0xc5bcadf1, 0 }, /* #34 */
    { 0x3f4cd3, 0x3f4cd3, 0xa6aaa72e, 0x2192a51e, 0x0dc5f1aa, 0xd3dc627a, 0x7e7cf7c9, 0 }, /* #35 */
    { 0x2f6dd7, 0x2f6dd7, 0xceab50b1, 0x45a063f3, 0xd13e9bfd, 0x1172efc1, 0xa57307e3, 0 }, /* #36 */
    { 0x0a5b42, 0x0a5b43, 0x1dc2e93f, 0xf8d0ec37, 0x275f365c, 0x0aaf7de3, 0x5bea0709, 0 }, /* #37 */
    { 0x336e12, 0x336e13, 0x421aa278, 0xcbee2b88, 0xa2a0962f, 0xf6ef27a6, 0xdce41a3f, 0 }, /* #38 */
    { 0x372cc2, 0x372cc3, 0xc525d940, 0x1fb17780, 0x37da1c37, 0x19a51f69, 0x90727b86, 0 }, /* #39 */
    { 0x1b1902, 0x1b1903, 0x659c0989, 0x63b41974, 0x6736357c, 0xf019e570, 0xd7f194d4, 0 }, /* #40 */
    { 0x217693, 0x217e93, 0x32836919, 0x302045a3, 0x9169230b, 0xf60839f3, 0xcd7bb01b, 0 }, /* #41 */
    { 0x264387, 0x264b87, 0x5faeee6e, 0x482ddf1e, 0x15a78802, 0x0fa19c00, 0x29d24669, 0 }, /* #42 */
    { 0x0c2cd2, 0x0c2cd3, 0x742e5a75, 0x3db6d506, 0x4f34f2ea, 0x1db8d8a2, 0x417dc42e, 0 }, /* #43 */
    { 0x1a28c7, 0x1a28c7, 0xc47e52c7, 0xf580fbf4, 0x016ca9f2, 0xfed445ec, 0x0509706c, 0 }, /* #44 */
    { 0x3365d6, 0x336dd7, 0xe4b8074b, 0x075b5b7b, 0xede70095, 0x042c49a2, 0xd8d76e91, 0 }, /* #45 */
    { 0x1c1f02, 0x1c1f03, 0x7ac18f68, 0xf4794d58, 0xb9ae33ce, 0xcff31443, 0x9bcb36f7, 0 }, /* #46 */
    { 0x054117, 0x054917, 0x234fbd6a, 0xa1b0f67c, 0xd2a78383, 0xf5789d77, 0xb3ab1706, 0 }, /* #47 */
    { 0x342542, 0x342d43, 0x8d17e55c, 0xcc6039b8, 0x9bd301bb, 0xc93336ef, 0x7a16aa42, 0 }, /* #48 */
    { 0x0370d3, 0x0378d3, 0x4cb94a0e, 0xd03ae5a8, 0x98ad047c, 0xeeeb2e76, 0xc701758c, 0 }, /* #49 */
    { 0x0c3dc3, 0x0c3dc3, 0x30f54927, 0xa4dc717a, 0x3795d960, 0x0f19189d, 0x4ef26af6, 0 }, /* #50 */
    { 0x0c4406, 0x0c4c07, 0x0c7f3582, 0x9e4a0d72, 0x3392110a, 0x05fc467c, 0x7a9cc1f9, 0 }, /* #51 */
    { 0x026057, 0x026857, 0xef60b6b9, 0xdeedec63, 0xf67c64cf, 0xf9b7e728, 0x60be6dfb, 0 }, /* #52 */
    { 0x260a82, 0x260a83, 0x9c51027e, 0x595baeb2, 0x4a7aacb8, 0xe8aee5bb, 0x3be16967, 0 }, /* #53 */
    { 0x0f2893, 0x0f2893, 0x4d7b130b, 0x1ef8a1ef, 0x4b1f5eea, 0xfdbfe1ea, 0xf8907b2d, 0 }, /* #54 */
    { 0x257fd7, 0x257fd7, 0x8d7f02e6, 0x1186786c, 0x4d9750f6, 0x351b68c0, 0x89444d72, 0 }, /* #55 */
    { 0x381cd2, 0x381cd3, 0x19c7e5ee, 0x15d5d1e2, 0x12c89a4e, 0xf7f29a34, 0xb00aa157, 0 }, /* #56 */
    { 0x261012, 0x261813, 0x0006726f, 0x7c07ed81, 0x2742f63f, 0xffff1faf, 0xdd34d70f, 0 }, /* #57 */
    { 0x134997, 0x134997, 0xba447543, 0x5d4de428, 0x646ec06b, 0x15388c54, 0xb21834b8, 0 }, /* #58 */
    { 0x2d5687, 0x2d5e87, 0xc58d4cd1, 0xea1c3606, 0xbfae302f, 0xf046ef0c, 0x44dd9f26, 0 }, /* #59 */
    { 0x3b7a42, 0x3b7a43, 0xb519476e, 0x8add6f7c, 0x4ea0a1fe, 0xe77261ad, 0x53eb3232, 0 }, /* #60 */
    { 0x2c1b82, 0x2c1b83, 0x2a9f6f34, 0x79061d34, 0x893df59c, 0x0b1e60d1, 0x42c7d981, 0 }, /* #61 */
    { 0x184647, 0x184e47, 0x5009bc81, 0x57f578cd, 0x33d1beaa, 0x04c39253, 0x0f3cc64d, 0 }, /* #62 */
    { 0x3f11d7, 0x3f19d7, 0xbbee575e, 0xdb5f7af6, 0x1caa1be2, 0xf66a1fe2, 0x240cc1f5, 0 }, /* #63 */
    { 0x114e52, 0x114e53, 0x4b8007d1, 0x8d59c94c, 0xc2815110, 0xeabf9710, 0xb7f1138c, 0 }, /* #64 */
    { 0x3a6907, 0x3a6907, 0xa6c4e20c, 0xcb066c78, 0xc7d4b68a, 0xdf327cab, 0x5e1c220a, 0 }, /* #65 */
    { 0x3e4dd7, 0x3e4dd7, 0x189de0e3, 0x6774cf2b, 0xa51763b5, 0x03531c5c, 0x22931319, 0 }, /* #66 */
    { 0x0a6002, 0x0a6803, 0x2a3ae4bb, 0x4e31ec31, 0xc07ee779, 0x0c76d1a4, 0x4b8eda03, 0 }, /* #67 */
    { 0x0b2196, 0x0b2997, 0xb7523bb2, 0x40b3e80c, 0x37cd6051, 0xfc787b18, 0x0c6e8276, 0 }, /* #68 */
    { 0x371752, 0x371f53, 0x2dde2be0, 0xe8b19280, 0x951296a6, 0xf2fcf405, 0xb76097ec, 0 }, /* #69 */
    { 0x2b3f07, 0x2b3f07, 0xda7f3fde, 0xe73208a8, 0x983a1569, 0x10cc943b, 0x8d53acec, 0 }, /* #70 */
    { 0x3d40c3, 0x3d48c3, 0x0ffc05d1, 0x50b0a8f9, 0x6ae2055d, 0x01cc7099, 0x1cce32a9, 0 }, /* #71 */
    { 0x2024d2, 0x202cd3, 0x8b1314e7, 0xa2a84b0c, 0x11c14f5f, 0xcf77c94d, 0x6a41ef14, 0 }, /* #72 */
    { 0x371f92, 0x371f93, 0x18839167, 0xdf4f2ecb, 0xa5bf2e97, 0xf3d00a6e, 0x80ba24fd, 0 }, /* #73 */
    { 0x127f17, 0x127f17, 0x9f9fbdd0, 0x58084b70, 0x7066d3bb, 0x0675e483, 0xeed6d3a3, 0 }, /* #74 */
    { 0x202b06, 0x202b07, 0xad06871b, 0x7240a3bc, 0xc79014b5, 0xe9e128a4, 0x443f7af4, 0 }, /* #75 */
    { 0x212b53, 0x212b53, 0x2a251328, 0x4da09768, 0x680cdd89, 0x10918b5a, 0x64a461e9, 0 }, /* #76 */
    { 0x183b97, 0x183b97, 0xf2f1f3c1, 0xb8fb7f8c, 0x6974d29a, 0x0093bfeb, 0xf4aeb28c, 0 }, /* #77 */
    { 0x0c4106, 0x0c4907, 0x7d4aedea, 0x98bcf02c, 0xc249dde9, 0xffc54bb9, 0xff880dfe, 0 }, /* #78 */
    { 0x0e6013, 0x0e6813, 0x055b2c0f, 0x178367cb, 0x64a98f88, 0xffd572e0, 0xf80e3c85, 0 }, /* #79 */
    { 0x277d56, 0x277d57, 0x7615d1db, 0x3bb128f3, 0x52849c9a, 0x1da57a86, 0x40456cc9, 0 }, /* #80 */
    { 0x290042, 0x290843, 0x43d3b797, 0xfd26c075, 0x00ba1c77, 0x0f892185, 0x3aa2e9d3, 0 }, /* #81 */
    { 0x255a83, 0x255a83, 0x92db8bb5, 0x95c91b78, 0x8bb121bf, 0xf4dd47ae, 0x1a1e8898, 0 }, /* #82 */
    { 0x194087, 0x194887, 0x34308f3e, 0x35c15146, 0xa00c4a36, 0x01660d7f, 0x06dc507d, 0 }, /* #83 */
    { 0x2862c3, 0x286ac3, 0x81743ab4, 0x0f9a7900, 0xf5ba20fe, 0xf8af7462, 0x0ecc1f40, 0 }, /* #84 */
    { 0x1b5097, 0x1b5897, 0x424fa6ed, 0x236b97fe, 0x7b5812ca, 0xe3d305c0, 0x9339aa36, 0 }, /* #85 */
    { 0x154916, 0x154917, 0x5584db5f, 0x7d6cf866, 0x855e65d6, 0xfd793058, 0xf86fc75a, 0 }, /* #86 */
    { 0x092353, 0x092b53, 0x89789afc, 0x93b22694, 0x0d071b3f, 0x34fd1c41, 0x8d8dec9b, 0 }, /* #87 */
    { 0x283b12, 0x283b13, 0xe5914903, 0xfa761a81, 0x6550980d, 0x04a2eb8e, 0xd3189d2b, 0 }, /* #88 */
    { 0x361c83, 0x361c83, 0x2aa7da8a, 0xdfcc683a, 0x71fcd0ba, 0x02271b26, 0x0ceb7cf9, 0 }, /* #89 */
    { 0x1966c2, 0x196ec3, 0x16453d28, 0x19810c68, 0x5bb23957, 0xfbfb9db0, 0xd1d2adc9, 0 }, /* #90 */
    { 0x0f7043, 0x0f7843, 0x5b134e61, 0x826972d4, 0x107ef0fd, 0xff49b592, 0xfdff9b54, 0 }, /* #91 */
    { 0x2e4792, 0x2e4f93, 0x2731f962, 0x494cb6d0, 0x9e0aef80, 0xfb17941e, 0xdff1cbe8, 0 }, /* #92 */
    { 0x021d87, 0x021d87, 0xdb625354, 0xb9cbe404, 0x944cbdd7, 0xf7aa9ba8, 0x3a43997d, 0 }, /* #93 */
    { 0x121c42, 0x121c43, 0xd8fce52e, 0x12e5ba38, 0x432a3bd3, 0xf4c33866, 0x49bd9b44, 0 }, /* #94 */
    { 0x1c3306, 0x1c3b07, 0xf537b160, 0xab723ec0, 0x1b5e51bf, 0xff70c235, 0x0d48e0a2, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u32_amd = RT_ELEMENTS(g_aTests_imul_u32_amd);

MULDIVU32_TEST_T const g_aTests_div_u32_amd[] =
{
    { 0x135353, 0x135353, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #0 */
    { 0x265052, 0x265052, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #1 */
    { 0x3848c3, 0x3848c3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #2 */
    { 0x041c47, 0x041c47, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #3 */
    { 0x310716, 0x310716, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #4 */
    { 0x242a47, 0x242a47, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #5 */
    { 0x155413, 0x155413, 0x75965436, 0x75965436, 0x6072e189, 0x6072e189, 0x00000000, -1 }, /* #6 */
    { 0x351ad7, 0x351ad7, 0xb87524a4, 0xb87524a4, 0x12b8c8c4, 0x12b8c8c4, 0x00000000, -1 }, /* #7 */
    { 0x046643, 0x046643, 0xdc2af4a3, 0xdc2af4a3, 0x8823289b, 0x8823289b, 0x00000000, -1 }, /* #8 */
    { 0x3e5c43, 0x3e5c43, 0xb2089b18, 0xb2089b18, 0x12fe5e51, 0x12fe5e51, 0x00000000, -1 }, /* #9 */
    { 0x224242, 0x224242, 0xf575d788, 0xf575d788, 0x4b993d23, 0x4b993d23, 0x00000000, -1 }, /* #10 */
    { 0x3c6b93, 0x3c6b93, 0xb8502a99, 0xb8502a99, 0x171cbfb1, 0x171cbfb1, 0x00000000, -1 }, /* #11 */
    { 0x2d0953, 0x2d0953, 0x967ed64c, 0x967ed64c, 0xe127231d, 0xe127231d, 0x507276bf, -1 }, /* #12 */
    { 0x121ed6, 0x121ed6, 0x28e80310, 0x28e80310, 0xd821453e, 0xd821453e, 0x8e6de43a, -1 }, /* #13 */
    { 0x224412, 0x224412, 0x6df5fef8, 0x7c0308a8, 0x7136635a, 0x58cd4c60, 0xe9b4e3c7, 0 }, /* #14 */
    { 0x163317, 0x163317, 0x1cbbee71, 0x1cbbee71, 0xb6234b73, 0xb6234b73, 0x072ea79d, -1 }, /* #15 */
    { 0x3e3812, 0x3e3812, 0x8315370f, 0xb7562a6b, 0x25d1dc31, 0x20f8409b, 0x34cf285c, 0 }, /* #16 */
    { 0x226bc7, 0x226b13, 0xf26f3bc8, 0xb0db013b, 0x3680056a, 0x4b87fe29, 0x4ee3aeed, 0 }, /* #17 */
    { 0x317213, 0x317213, 0x2e77ddf6, 0x2e77ddf6, 0x7f8d7a22, 0x7f8d7a22, 0x214d8f9a, -1 }, /* #18 */
    { 0x0e5882, 0x0e5882, 0x1baa82ef, 0x1baa82ef, 0xd77a2719, 0xd77a2719, 0xd49d072d, -1 }, /* #19 */
    { 0x0225c7, 0x0225c7, 0x4dc81448, 0x4dc81448, 0x8aabaadd, 0x8aabaadd, 0x0c5e98a4, -1 }, /* #20 */
    { 0x373d56, 0x373d12, 0x31524571, 0xcbf2146d, 0x904d1703, 0x2a3d18f4, 0xb521ce51, 0 }, /* #21 */
    { 0x304317, 0x304313, 0x3c44bb07, 0x04f78717, 0x0452e77a, 0x8f9e2a90, 0xdedb1da1, 0 }, /* #22 */
    { 0x3644d2, 0x3644d2, 0x49a266d0, 0x49a266d0, 0xc50be6a1, 0xc50be6a1, 0x9052569d, -1 }, /* #23 */
    { 0x340697, 0x340697, 0xc6f1d546, 0xc6f1d546, 0x6ee8ea39, 0x6ee8ea39, 0x3d697d11, -1 }, /* #24 */
    { 0x192cc2, 0x192cc2, 0x545c8361, 0x545c8361, 0xc5b5808c, 0xc5b5808c, 0x8f0a6a41, -1 }, /* #25 */
    { 0x0579d3, 0x0579d3, 0x319c5848, 0x319c5848, 0x4f67f86a, 0x4f67f86a, 0x32e5ff0c, -1 }, /* #26 */
    { 0x0b27c2, 0x0b2712, 0x8972df9c, 0x362ded36, 0x14b6a070, 0x209555b2, 0x61df23af, 0 }, /* #27 */
    { 0x1f6856, 0x1f6812, 0xc24ff056, 0x9150a8ab, 0x8e2b9f49, 0x1fa676d1, 0xfa75c68f, 0 }, /* #28 */
    { 0x3e7447, 0x3e7447, 0x6b16e344, 0x6b16e344, 0xeba29b75, 0xeba29b75, 0x008c5588, -1 }, /* #29 */
    { 0x0353d7, 0x035313, 0x0f3fca98, 0x69d54a4b, 0x650de9cd, 0xd21f93b3, 0xf470c58f, 0 }, /* #30 */
    { 0x3a6b02, 0x3a6b02, 0xcfc75c79, 0xcfc75c79, 0xe98834da, 0xe98834da, 0x2d45e983, -1 }, /* #31 */
    { 0x252e87, 0x252e87, 0x1f2f053e, 0x1f2f053e, 0x90cd2a77, 0x90cd2a77, 0x0d9ef33f, -1 }, /* #32 */
    { 0x333417, 0x333413, 0x1e33eebb, 0x67018112, 0x637e467a, 0x91451ab1, 0xf745269d, 0 }, /* #33 */
    { 0x2a4a97, 0x2a4a13, 0x99c72f29, 0xf964ef63, 0x23e939f7, 0x12506b6c, 0x24dcba5f, 0 }, /* #34 */
    { 0x0f6696, 0x0f6612, 0x3eb36034, 0x88d2c941, 0x32711614, 0x53970cf6, 0x5e60b5be, 0 }, /* #35 */
    { 0x3b7d52, 0x3b7d52, 0x6c37ac12, 0x6c37ac12, 0xfb02093f, 0xfb02093f, 0x42ad255d, -1 }, /* #36 */
    { 0x2f7e02, 0x2f7e02, 0xcb8f5dee, 0xcb8f5dee, 0x715fdb03, 0x715fdb03, 0x4c23bb48, -1 }, /* #37 */
    { 0x1c7a13, 0x1c7a13, 0xd5da6785, 0xc6bff79f, 0xb5c257f8, 0x17370f9f, 0xea1d765a, 0 }, /* #38 */
    { 0x054503, 0x054503, 0x6fbe17a4, 0x6fbe17a4, 0xe9022878, 0xe9022878, 0x8caf1424, -1 }, /* #39 */
    { 0x253ad7, 0x253ad7, 0xd141c50e, 0xd141c50e, 0xf4f043cf, 0xf4f043cf, 0xc9f3e630, -1 }, /* #40 */
    { 0x0d5e42, 0x0d5e12, 0x4e31b850, 0xe5114ea1, 0xa23b9377, 0x4905b06d, 0xb54e9c03, 0 }, /* #41 */
    { 0x242446, 0x242446, 0x9fde984c, 0x9fde984c, 0x8ee0b5ec, 0x8ee0b5ec, 0x02c7c169, -1 }, /* #42 */
    { 0x2a55c6, 0x2a55c6, 0xde027d45, 0xde027d45, 0x756e4c67, 0x756e4c67, 0x1f467986, -1 }, /* #43 */
    { 0x145c56, 0x145c56, 0x2301ea90, 0x2301ea90, 0xd2cec6b8, 0xd2cec6b8, 0x055863ad, -1 }, /* #44 */
    { 0x381646, 0x381612, 0x3a882407, 0xcbea957b, 0x3ff58669, 0x4ed5f1a7, 0x504b9920, 0 }, /* #45 */
    { 0x322d07, 0x322d13, 0x832c3da1, 0x159c016a, 0x0d82377b, 0x97a1643d, 0xa008732a, 0 }, /* #46 */
    { 0x007b87, 0x007b13, 0x43c9b748, 0x89887af8, 0x83868626, 0x7db72ea8, 0xf4d14b6c, 0 }, /* #47 */
    { 0x2e3a83, 0x2e3a13, 0x77590855, 0x88a1f72b, 0x763241a9, 0xb108b30b, 0xdd74fade, 0 }, /* #48 */
    { 0x0234c3, 0x0234c3, 0xddd580f6, 0xddd580f6, 0xec05a5c7, 0xec05a5c7, 0xe6c6c265, -1 }, /* #49 */
    { 0x0408c6, 0x040812, 0x1eafa189, 0x31d02834, 0x1c9659ef, 0x78b3c8d1, 0x92ea8966, 0 }, /* #50 */
    { 0x221117, 0x221113, 0xe3540b5e, 0xb202a4fe, 0x22b65a70, 0x129239c0, 0x31eba1b1, 0 }, /* #51 */
    { 0x040513, 0x040513, 0xe1fc52c6, 0x7cf88cb5, 0x7c9e5698, 0x5309ee3b, 0xff47343f, 0 }, /* #52 */
    { 0x373487, 0x373487, 0x98db4405, 0x98db4405, 0x634ed1d6, 0x634ed1d6, 0x4bb24ab6, -1 }, /* #53 */
    { 0x067893, 0x067893, 0xfd736e24, 0xfd736e24, 0x65441d00, 0x65441d00, 0x1acc1ef0, -1 }, /* #54 */
    { 0x3c7ac3, 0x3c7a13, 0x3dfadb14, 0x980de187, 0x60453ea9, 0x3291f23b, 0xa214fa9f, 0 }, /* #55 */
    { 0x120f07, 0x120f13, 0x5458bd40, 0xc4d9110f, 0x8df0bf2f, 0x3f68dfc2, 0xb897cea2, 0 }, /* #56 */
    { 0x3f2b82, 0x3f2b12, 0x170309ab, 0x0cac243b, 0x086fe62e, 0x4330c414, 0xaa70da55, 0 }, /* #57 */
    { 0x0e3903, 0x0e3903, 0x66c30d00, 0x66c30d00, 0x8f8a8ee1, 0x8f8a8ee1, 0x505bedf4, -1 }, /* #58 */
    { 0x235743, 0x235713, 0x2efe4725, 0x84009fee, 0x77f0e63d, 0x3ac515dd, 0xe89bcb7c, 0 }, /* #59 */
    { 0x0c4e92, 0x0c4e12, 0xe5c41856, 0xb34c10ae, 0x2d19ea4c, 0x1d42d0a2, 0x40653ab6, 0 }, /* #60 */
    { 0x3102c7, 0x3102c7, 0x42cad219, 0x42cad219, 0xd1a78991, 0xd1a78991, 0x0e3897a5, -1 }, /* #61 */
    { 0x2b58c6, 0x2b58c6, 0xcb6f0473, 0xcb6f0473, 0x9c935f29, 0x9c935f29, 0x8f4c8b67, -1 }, /* #62 */
    { 0x141f03, 0x141f03, 0x78c1be68, 0x78c1be68, 0x37bbbaf4, 0x37bbbaf4, 0x05ef05c2, -1 }, /* #63 */
    { 0x230693, 0x230693, 0xae462eb3, 0xae462eb3, 0x81a40181, 0x81a40181, 0x765ebcfe, -1 }, /* #64 */
    { 0x096397, 0x096397, 0xc97c4e2b, 0xc97c4e2b, 0xbfefedea, 0xbfefedea, 0x20ecbe71, -1 }, /* #65 */
    { 0x0a7d92, 0x0a7d12, 0xd449278c, 0x1e1ba78c, 0x0ec362bb, 0x66abfff4, 0x7d870b62, 0 }, /* #66 */
    { 0x3c0f52, 0x3c0f52, 0xb924e442, 0xb924e442, 0xa505e730, 0xa505e730, 0x268d3420, -1 }, /* #67 */
    { 0x195553, 0x195513, 0xe8fa9bf0, 0x7f3ccac6, 0x5d13be94, 0x1dd9c57a, 0xbb451649, 0 }, /* #68 */
    { 0x3a3107, 0x3a3107, 0x2be85a4e, 0x2be85a4e, 0x6380cd67, 0x6380cd67, 0x5d2d3766, -1 }, /* #69 */
    { 0x235c53, 0x235c53, 0xbcde1b7a, 0xbcde1b7a, 0x99de26a1, 0x99de26a1, 0x87ba421f, -1 }, /* #70 */
    { 0x0b0507, 0x0b0507, 0xf0417c68, 0xf0417c68, 0x5b4ea898, 0x5b4ea898, 0x091ea129, -1 }, /* #71 */
    { 0x263017, 0x263013, 0x983d369f, 0x219d8d96, 0x1acd0d27, 0xaa22f1dd, 0xcc1aaa03, 0 }, /* #72 */
    { 0x0f51d7, 0x0f5113, 0x08236fb3, 0xd8764575, 0xce7a54f1, 0x6027d16b, 0xf4313428, 0 }, /* #73 */
    { 0x1748d7, 0x174813, 0xe870aa78, 0x97744945, 0x3cc7e1d9, 0x61c16911, 0x66bc8cbb, 0 }, /* #74 */
    { 0x3b7d86, 0x3b7d12, 0x91385e2c, 0x4c050011, 0x4baec45c, 0x62581607, 0xfedd9ad5, 0 }, /* #75 */
    { 0x203613, 0x203613, 0xaa05ef51, 0xaa05ef51, 0xaba2c464, 0xaba2c464, 0x0b0bb871, -1 }, /* #76 */
    { 0x3a0843, 0x3a0813, 0xcdbc301d, 0x6be0e84a, 0x23877dbc, 0x4edff53d, 0x544ff4b0, 0 }, /* #77 */
    { 0x097a06, 0x097a06, 0xd2ec54c6, 0xd2ec54c6, 0xd9b19cde, 0xd9b19cde, 0x1bb1e0d3, -1 }, /* #78 */
    { 0x1f4ad3, 0x1f4a13, 0x436b0ae2, 0x6ed27c1f, 0x68977d2e, 0x86761ea9, 0xf19b8ca7, 0 }, /* #79 */
    { 0x2f4142, 0x2f4112, 0xfb6db7b2, 0xc8222797, 0xa037466c, 0x76b5d8c7, 0xccf08dcd, 0 }, /* #80 */
    { 0x2d3513, 0x2d3513, 0x0edbc0ef, 0x0edbc0ef, 0xbd57b35b, 0xbd57b35b, 0x88c03ad3, -1 }, /* #81 */
    { 0x1617d7, 0x161713, 0xf03ef8df, 0x4b29351b, 0x3645320b, 0x9a19caa9, 0xb8d88c02, 0 }, /* #82 */
    { 0x101543, 0x101543, 0x4d259512, 0x4d259512, 0x9e5dd77c, 0x9e5dd77c, 0x22ee1d77, -1 }, /* #83 */
    { 0x100183, 0x100183, 0x6ae8ece4, 0x6ae8ece4, 0xa218a391, 0xa218a391, 0x7f9ab6e7, -1 }, /* #84 */
    { 0x0e5047, 0x0e5047, 0xac388c11, 0xac388c11, 0xb473e798, 0xb473e798, 0x2569e7e2, -1 }, /* #85 */
    { 0x365a52, 0x365a12, 0xfb7f7880, 0xf654d781, 0x2dc05ad7, 0x0f92e475, 0x2f8c118b, 0 }, /* #86 */
    { 0x1375c3, 0x1375c3, 0xe7b43597, 0xe7b43597, 0xa82a60de, 0xa82a60de, 0x363da36b, -1 }, /* #87 */
    { 0x340252, 0x340252, 0x220cafa8, 0x220cafa8, 0x6ee0500e, 0x6ee0500e, 0x0d982544, -1 }, /* #88 */
    { 0x361a56, 0x361a56, 0x2d4e424d, 0x2d4e424d, 0x2ce2e477, 0x2ce2e477, 0x2405787a, -1 }, /* #89 */
    { 0x282407, 0x282407, 0x012b07a5, 0x012b07a5, 0x3002e23c, 0x3002e23c, 0x0d52e9c4, -1 }, /* #90 */
    { 0x314993, 0x314993, 0x7f9d237d, 0x7f9d237d, 0x658524ff, 0x658524ff, 0x083ff497, -1 }, /* #91 */
    { 0x130a87, 0x130a13, 0x715a62eb, 0x2b7205e5, 0x1fdb60e8, 0x7d125645, 0xbbb72fae, 0 }, /* #92 */
    { 0x1b07d6, 0x1b07d6, 0x03fb43ff, 0x03fb43ff, 0xa52d3d37, 0xa52d3d37, 0x7d0df8f2, -1 }, /* #93 */
    { 0x127706, 0x127712, 0x26e21e69, 0xd9a3313b, 0x873ab444, 0x2f48397e, 0x9f10e011, 0 }, /* #94 */
    { 0x260c06, 0x260c06, 0xb3f2e487, 0xb3f2e487, 0x8f799689, 0x8f799689, 0x378a2522, -1 }, /* #95 */
};
uint32_t const g_cTests_div_u32_amd = RT_ELEMENTS(g_aTests_div_u32_amd);

MULDIVU32_TEST_T const g_aTests_idiv_u32_amd[] =
{
    { 0x0b7782, 0x0b7782, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #0 */
    { 0x112006, 0x112006, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #1 */
    { 0x2a5707, 0x2a5707, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #2 */
    { 0x0b1f82, 0x0b1f82, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #3 */
    { 0x012817, 0x012817, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #4 */
    { 0x2f13c6, 0x2f13c6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, -1 }, /* #5 */
    { 0x3d3c03, 0x3d3c03, 0xf6f94b9d, 0xf6f94b9d, 0x68d34c9d, 0x68d34c9d, 0x00000000, -1 }, /* #6 */
    { 0x0a6c53, 0x0a6c53, 0xaee36f71, 0xaee36f71, 0x55a97bc3, 0x55a97bc3, 0x00000000, -1 }, /* #7 */
    { 0x3c6b06, 0x3c6b06, 0xfade3ed8, 0xfade3ed8, 0x14eff519, 0x14eff519, 0x00000000, -1 }, /* #8 */
    { 0x0467d7, 0x0467d7, 0xcd2067c7, 0xcd2067c7, 0x8a7d408c, 0x8a7d408c, 0x00000000, -1 }, /* #9 */
    { 0x184d82, 0x184d82, 0xbf5dcf92, 0xbf5dcf92, 0xa7e69abe, 0xa7e69abe, 0x00000000, -1 }, /* #10 */
    { 0x394443, 0x394443, 0x0f3a5420, 0x0f3a5420, 0xfe6908af, 0xfe6908af, 0x00000000, -1 }, /* #11 */
    { 0x393903, 0x393913, 0xc758682c, 0x0693dd4a, 0xfd1f454b, 0xdc2038a8, 0x8ffe7f1a, 0 }, /* #12 */
    { 0x0a0c02, 0x0a0c02, 0x99382037, 0x99382037, 0x73cb07d0, 0x73cb07d0, 0x10978b14, -1 }, /* #13 */
    { 0x2b7742, 0x2b7742, 0x817e49af, 0x817e49af, 0x8a17a1c0, 0x8a17a1c0, 0x557c6a40, -1 }, /* #14 */
    { 0x233b92, 0x233b12, 0x06f126e7, 0xed642b37, 0x02310b40, 0x12386772, 0xe1d9b8b3, 0 }, /* #15 */
    { 0x2d0103, 0x2d0103, 0xcbe54d30, 0xcbe54d30, 0x3b2eb13d, 0x3b2eb13d, 0xf6763a25, -1 }, /* #16 */
    { 0x230fc7, 0x230fc7, 0x08fc2a4f, 0x08fc2a4f, 0x2e9d66db, 0x2e9d66db, 0xdfcbcbc5, -1 }, /* #17 */
    { 0x2f2387, 0x2f2387, 0xce4d44c3, 0xce4d44c3, 0xb2dd658a, 0xb2dd658a, 0x653581f0, -1 }, /* #18 */
    { 0x254687, 0x254687, 0xca54a9c5, 0xca54a9c5, 0xbc55eaa2, 0xbc55eaa2, 0xec9f7173, -1 }, /* #19 */
    { 0x116c93, 0x116c93, 0xb6399607, 0xb6399607, 0x7ea8e234, 0x7ea8e234, 0x019ae40f, -1 }, /* #20 */
    { 0x323647, 0x323647, 0x45d0b3cc, 0x45d0b3cc, 0x48cc190f, 0x48cc190f, 0x8f814d1f, -1 }, /* #21 */
    { 0x2e5702, 0x2e5712, 0x1691da9c, 0xfc583222, 0x01a74357, 0x62677622, 0x8c36266d, 0 }, /* #22 */
    { 0x146513, 0x146513, 0xfcd3310a, 0x2d4ed77e, 0x0d38c78c, 0x44d49d42, 0x4ab4bf1c, 0 }, /* #23 */
    { 0x2e4cc3, 0x2e4cc3, 0xca44c45d, 0xca44c45d, 0xa8b7baef, 0xa8b7baef, 0xb651b5cb, -1 }, /* #24 */
    { 0x334253, 0x334253, 0x6e8fb797, 0x6e8fb797, 0x9d5e3262, 0x9d5e3262, 0x133defd1, -1 }, /* #25 */
    { 0x0b2d03, 0x0b2d03, 0xf94d2d9c, 0xf94d2d9c, 0x79ed9afb, 0x79ed9afb, 0x1e59f273, -1 }, /* #26 */
    { 0x3c6b96, 0x3c6b12, 0x93bb56ec, 0xb9d4fabe, 0xf047cae6, 0xec9ac0c6, 0x3959dacd, 0 }, /* #27 */
    { 0x2b6607, 0x2b6607, 0x5812a4f9, 0x5812a4f9, 0xf00ce3c7, 0xf00ce3c7, 0x0ed4a9f5, -1 }, /* #28 */
    { 0x223c43, 0x223c43, 0x91e206bc, 0x91e206bc, 0x8e284aa3, 0x8e284aa3, 0xf73c3b6b, -1 }, /* #29 */
    { 0x210a03, 0x210a03, 0x87e0274b, 0x87e0274b, 0x0d33b0f7, 0x0d33b0f7, 0xfca72ee6, -1 }, /* #30 */
    { 0x381d06, 0x381d06, 0x5641abd3, 0x5641abd3, 0x3177b50f, 0x3177b50f, 0xea100528, -1 }, /* #31 */
    { 0x021a83, 0x021a83, 0x0f385174, 0x0f385174, 0x6f71798c, 0x6f71798c, 0xc2e30f7d, -1 }, /* #32 */
    { 0x0d5906, 0x0d5912, 0x2c231d8e, 0x63371ca7, 0xf5698d18, 0xe9e2b96e, 0xe4ae5ee0, 0 }, /* #33 */
    { 0x1677c3, 0x1677c3, 0xe6245e9f, 0xe6245e9f, 0x5dc02c49, 0x5dc02c49, 0x739b7be1, -1 }, /* #34 */
    { 0x220b17, 0x220b17, 0x34506803, 0x34506803, 0x4adcd89d, 0x4adcd89d, 0xe91151d0, -1 }, /* #35 */
    { 0x126493, 0x126493, 0x3db9db50, 0x3db9db50, 0x34eda1ac, 0x34eda1ac, 0xdd113e59, -1 }, /* #36 */
    { 0x1474c3, 0x1474c3, 0x3fffc743, 0x3fffc743, 0x71732088, 0x71732088, 0x7d5cda14, -1 }, /* #37 */
    { 0x311752, 0x311752, 0x2b07410d, 0x2b07410d, 0x693fd28c, 0x693fd28c, 0x1d181b4f, -1 }, /* #38 */
    { 0x290f42, 0x290f12, 0xea2a6df4, 0xde01607b, 0x0798e4a0, 0x1dd854cd, 0xc6c9c845, 0 }, /* #39 */
    { 0x125dd3, 0x125dd3, 0x926908c4, 0x926908c4, 0xadbea620, 0xadbea620, 0x3f8cb729, -1 }, /* #40 */
    { 0x0d2602, 0x0d2602, 0x7204c87c, 0x7204c87c, 0x98065e8b, 0x98065e8b, 0x8a2924d3, -1 }, /* #41 */
    { 0x301dd3, 0x301d13, 0xdccb9eb4, 0x0d1a3170, 0xfc206b04, 0xdff5bad4, 0xb451f272, 0 }, /* #42 */
    { 0x045607, 0x045607, 0x6cabfe31, 0x6cabfe31, 0x4fbd7ab4, 0x4fbd7ab4, 0xd3b752d3, -1 }, /* #43 */
    { 0x1e24c3, 0x1e24c3, 0xc752b090, 0xc752b090, 0x85c5c1b1, 0x85c5c1b1, 0xfa2f6f40, -1 }, /* #44 */
    { 0x307092, 0x307092, 0x8d038b41, 0x8d038b41, 0x63ab5f13, 0x63ab5f13, 0x47ef0b84, -1 }, /* #45 */
    { 0x1d0b07, 0x1d0b07, 0x8208e803, 0x8208e803, 0x56b81e00, 0x56b81e00, 0x11b99da7, -1 }, /* #46 */
    { 0x1d4802, 0x1d4802, 0xb9641e68, 0xb9641e68, 0x710bdefd, 0x710bdefd, 0xc25cee06, -1 }, /* #47 */
    { 0x0e6dd3, 0x0e6dd3, 0x29281f53, 0x29281f53, 0x8920b814, 0x8920b814, 0xc3154e8e, -1 }, /* #48 */
    { 0x184e16, 0x184e12, 0x05f6f28a, 0x32192010, 0x17ad65e8, 0x2563fd8a, 0x78fd8f50, 0 }, /* #49 */
    { 0x0b6a43, 0x0b6a43, 0x2d8b1e63, 0x2d8b1e63, 0x88782dc4, 0x88782dc4, 0xca04c407, -1 }, /* #50 */
    { 0x214d87, 0x214d87, 0xaaada7b8, 0xaaada7b8, 0x2ede57bf, 0x2ede57bf, 0x4752d4a3, -1 }, /* #51 */
    { 0x061d16, 0x061d16, 0x5a5fb7e2, 0x5a5fb7e2, 0xc22163f5, 0xc22163f5, 0x1e296aea, -1 }, /* #52 */
    { 0x2a58d3, 0x2a58d3, 0x93357042, 0x93357042, 0xd95d06e8, 0xd95d06e8, 0xea70765a, -1 }, /* #53 */
    { 0x2a2452, 0x2a2452, 0x4380e516, 0x4380e516, 0xc3400926, 0xc3400926, 0xa1189f74, -1 }, /* #54 */
    { 0x0b7a03, 0x0b7a03, 0xde4ae53d, 0xde4ae53d, 0xc7101754, 0xc7101754, 0x316bb03e, -1 }, /* #55 */
    { 0x3f7096, 0x3f7096, 0x6f0e40aa, 0x6f0e40aa, 0x50b791dc, 0x50b791dc, 0x43c90b17, -1 }, /* #56 */
    { 0x3714d2, 0x3714d2, 0x52801de6, 0x52801de6, 0x192b115a, 0x192b115a, 0xda805972, -1 }, /* #57 */
    { 0x3058d7, 0x3058d7, 0xafe06e49, 0xafe06e49, 0x7768b400, 0x7768b400, 0xea0e6489, -1 }, /* #58 */
    { 0x2a73d3, 0x2a73d3, 0x7a61def7, 0x7a61def7, 0xaf7568e6, 0xaf7568e6, 0x0539ec61, -1 }, /* #59 */
    { 0x0d77c2, 0x0d77c2, 0x7d469b94, 0x7d469b94, 0xe69051cd, 0xe69051cd, 0x0cea7d82, -1 }, /* #60 */
    { 0x160943, 0x160943, 0x1df9a687, 0x1df9a687, 0xb123f870, 0xb123f870, 0x708bbb17, -1 }, /* #61 */
    { 0x281c92, 0x281c92, 0x7ff62b79, 0x7ff62b79, 0x349346d5, 0x349346d5, 0xb10f64ea, -1 }, /* #62 */
    { 0x2a57c7, 0x2a5713, 0x6e6b0d3b, 0x23751f58, 0xf631b44b, 0xe3eb891b, 0xb933e48c, 0 }, /* #63 */
    { 0x214082, 0x214082, 0x30301976, 0x30301976, 0x25d7cb84, 0x25d7cb84, 0x3a727b58, -1 }, /* #64 */
    { 0x3f6c42, 0x3f6c42, 0x58f82f93, 0x58f82f93, 0x4dfb68b3, 0x4dfb68b3, 0xf496e7c4, -1 }, /* #65 */
    { 0x0a0fd7, 0x0a0fd7, 0xcc7ac9ba, 0xcc7ac9ba, 0xd151f990, 0xd151f990, 0xdcd765d2, -1 }, /* #66 */
    { 0x1d4cc3, 0x1d4cc3, 0x352fa0d2, 0x352fa0d2, 0xc9e75645, 0xc9e75645, 0xf2d0f1ea, -1 }, /* #67 */
    { 0x3a7483, 0x3a7483, 0x963909ba, 0x963909ba, 0xbaadbe8f, 0xbaadbe8f, 0xa4b9bc61, -1 }, /* #68 */
    { 0x3e37d2, 0x3e37d2, 0xfdde1dc5, 0xfdde1dc5, 0x8174b112, 0x8174b112, 0xd415157d, -1 }, /* #69 */
    { 0x194bd3, 0x194bd3, 0xbbd6d455, 0xbbd6d455, 0x950e57f7, 0x950e57f7, 0xe0b144c1, -1 }, /* #70 */
    { 0x186b83, 0x186b83, 0x7e1853b5, 0x7e1853b5, 0xaf1fd0bf, 0xaf1fd0bf, 0xd1c1e498, -1 }, /* #71 */
    { 0x064043, 0x064043, 0xbeb89802, 0xbeb89802, 0x4903cb79, 0x4903cb79, 0x18239a62, -1 }, /* #72 */
    { 0x2c2447, 0x2c2413, 0xbb976431, 0xd87b8d93, 0x10330c5b, 0x338c13e5, 0x970ebe04, 0 }, /* #73 */
    { 0x1d2543, 0x1d2543, 0x6eb95640, 0x6eb95640, 0x49cdbc8a, 0x49cdbc8a, 0x62152de0, -1 }, /* #74 */
    { 0x367f46, 0x367f46, 0x487bbe2f, 0x487bbe2f, 0x34030402, 0x34030402, 0x31fc5ace, -1 }, /* #75 */
    { 0x2d44d2, 0x2d44d2, 0xd25679ac, 0xd25679ac, 0xab4e356f, 0xab4e356f, 0xdb96209f, -1 }, /* #76 */
    { 0x3734d7, 0x3734d7, 0xf443ab75, 0xf443ab75, 0x333ad9c7, 0x333ad9c7, 0x1cafb217, -1 }, /* #77 */
    { 0x153383, 0x153313, 0xab2af455, 0x233c19bc, 0x110f2f6a, 0x50ea9f79, 0x7bf201b9, 0 }, /* #78 */
    { 0x0f3746, 0x0f3746, 0xcbc01d95, 0xcbc01d95, 0xb1d6480d, 0xb1d6480d, 0x6b14670a, -1 }, /* #79 */
    { 0x387852, 0x387852, 0x7dff08b6, 0x7dff08b6, 0xf2950486, 0xf2950486, 0x155c135b, -1 }, /* #80 */
    { 0x3a6707, 0x3a6707, 0xae9a178f, 0xae9a178f, 0x8680e603, 0x8680e603, 0xb87cf31e, -1 }, /* #81 */
    { 0x3d5383, 0x3d5383, 0xdf37d48b, 0xdf37d48b, 0x8a6301b0, 0x8a6301b0, 0x6a03cf23, -1 }, /* #82 */
    { 0x143917, 0x143913, 0x8fb7d707, 0x310134cb, 0xee8614a0, 0xf8077b57, 0xa4b44d10, 0 }, /* #83 */
    { 0x2f6843, 0x2f6843, 0x17662409, 0x17662409, 0x32c7f7b2, 0x32c7f7b2, 0xa65701fd, -1 }, /* #84 */
    { 0x253c83, 0x253c83, 0x9de9f11d, 0x9de9f11d, 0x69d4d716, 0x69d4d716, 0x5474face, -1 }, /* #85 */
    { 0x3e1593, 0x3e1593, 0xd642c1bf, 0xd642c1bf, 0x38bdee03, 0x38bdee03, 0xfd5544e2, -1 }, /* #86 */
    { 0x1d1196, 0x1d1196, 0x144979a4, 0x144979a4, 0xa3d10863, 0xa3d10863, 0x307dcec7, -1 }, /* #87 */
    { 0x120392, 0x120392, 0xf803a1d9, 0xf803a1d9, 0x3676eb1d, 0x3676eb1d, 0x589fed96, -1 }, /* #88 */
    { 0x271f53, 0x271f53, 0xa903daa0, 0xa903daa0, 0x7c06743c, 0x7c06743c, 0x0bb94ec1, -1 }, /* #89 */
    { 0x2166c2, 0x216612, 0xac2ba6be, 0x38c6dfe3, 0xe5d03b6d, 0xfd23a93e, 0x89ed8480, 0 }, /* #90 */
    { 0x157497, 0x157497, 0xaced0abb, 0xaced0abb, 0xbe5bb2db, 0xbe5bb2db, 0x363b67d8, -1 }, /* #91 */
    { 0x1e5286, 0x1e5212, 0xa1910116, 0xfedfb9fd, 0x008f4fbb, 0x6e84fa64, 0x80bb9f1a, 0 }, /* #92 */
    { 0x0a6456, 0x0a6456, 0x52815961, 0x52815961, 0xaa131998, 0xaa131998, 0xcbf55fbc, -1 }, /* #93 */
    { 0x205693, 0x205693, 0x2ad58529, 0x2ad58529, 0xe8197d8a, 0xe8197d8a, 0xe181246a, -1 }, /* #94 */
    { 0x3d5d02, 0x3d5d12, 0x6a42a126, 0x0dbb9c21, 0xfc61db76, 0xc7843cc1, 0xbc8f5fc5, 0 }, /* #95 */
};
uint32_t const g_cTests_idiv_u32_amd = RT_ELEMENTS(g_aTests_idiv_u32_amd);

MULDIVU64_TEST_T const g_aTests_mul_u64_amd[] =
{
    { 0x183e46, 0x183646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #0 */
    { 0x114f02, 0x114702, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #1 */
    { 0x2d1843, 0x2d1042, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #2 */
    { 0x160143, 0x160142, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #3 */
    { 0x341c52, 0x341452, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #4 */
    { 0x0d3552, 0x0d3552, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #5 */
    { 0x272903, 0x272102, 0x163fc92d56b73615, 0x0000000000000000, 0xe42bcb65b5b0b4c4, 0x0000000000000000, 0x0000000000000000, 0 }, /* #6 */
    { 0x360743, 0x360742, 0xa6aadb0adcea7cda, 0x0000000000000000, 0x6455a8b85b12a22e, 0x0000000000000000, 0x0000000000000000, 0 }, /* #7 */
    { 0x350a42, 0x350242, 0x44b8833850f4060a, 0x0000000000000000, 0x70dd2ec66daed3f3, 0x0000000000000000, 0x0000000000000000, 0 }, /* #8 */
    { 0x2a0307, 0x2a0306, 0xcbbb858ca52e7001, 0x0000000000000000, 0xb4c8a1e0c43cd12c, 0x0000000000000000, 0x0000000000000000, 0 }, /* #9 */
    { 0x3b1412, 0x3b1412, 0x69d5ee66fdbe8fd8, 0x0000000000000000, 0x51986a399c16a0d2, 0x0000000000000000, 0x0000000000000000, 0 }, /* #10 */
    { 0x2e0756, 0x2e0756, 0x31b592c35df6bc13, 0x0000000000000000, 0xd4bb3c6007b659b4, 0x0000000000000000, 0x0000000000000000, 0 }, /* #11 */
    { 0x386e17, 0x386e17, 0xc7ecb0c4f356cdf9, 0xf3e6f21d9e39ad57, 0x1ac1a9fa844917ec, 0x6ccf9f0cf88058ab, 0x8b54a5b3e07e69cf, 0 }, /* #12 */
    { 0x0a3142, 0x0a3943, 0x05f54dc055c5346e, 0x986bffdee28ec27a, 0x75ec6ed0eed45454, 0x031ed41dc336388f, 0x86125d40b55f562b, 0 }, /* #13 */
    { 0x283892, 0x283893, 0xd9ea5e11dd21dbe0, 0x784f33dc8e6d2320, 0x74911387a9c5bb61, 0x8c410dd1f0a2ec41, 0xa4c4154920991f07, 0 }, /* #14 */
    { 0x117e52, 0x117e53, 0x5b79e8d469469f23, 0x5cb1fca28db979b5, 0xf713a7b860a4c463, 0x19ed766136519da5, 0x488f37682b683d47, 0 }, /* #15 */
    { 0x3e1113, 0x3e1913, 0x9c6f89061370f336, 0xc7e8c50c75ab1464, 0xb8cce357de8cf77f, 0x920d0eef321a1073, 0xef01857e1361a2b6, 0 }, /* #16 */
    { 0x232b46, 0x232b47, 0x2e9167939630147e, 0xd778f561df2dfcd4, 0xd35bece00c26fbc7, 0x0e56aff7b18ee42f, 0x4ed303199300a316, 0 }, /* #17 */
    { 0x3065c3, 0x306dc3, 0x3904f4362c32c488, 0x03880dfc0583c380, 0xe20d4d5fb43d434c, 0x28145e562b3db4a3, 0xb3f204061752a970, 0 }, /* #18 */
    { 0x264086, 0x264887, 0x2a637e413f9856b0, 0xecad0754e84d7660, 0xda99144d29f613f8, 0x1754741e03fdfa6d, 0x8ce5c1b17803f9b2, 0 }, /* #19 */
    { 0x0f72c2, 0x0f7ac3, 0x5c85c4a07640dd5f, 0xeea73e9e99f57445, 0x89facffb522ff301, 0x01f0d82cb9208b3e, 0x055eb736b16c6cdb, 0 }, /* #20 */
    { 0x0e5dc6, 0x0e5dc7, 0xdc662945d3f0a708, 0x61315ed004851430, 0xbd5be676771fa067, 0x5db87ed9b9484904, 0x6cdbfd435c778d46, 0 }, /* #21 */
    { 0x0e4b87, 0x0e4b87, 0x1c43592d51c8e542, 0xb6687ddc78780974, 0x3cf0de1fc993a7da, 0x17bccf0372308e86, 0xd7023bb6a986e47a, 0 }, /* #22 */
    { 0x1e3587, 0x1e3d87, 0x817f965237cc3c20, 0xfa695e43e2941dc0, 0x59e98bfc9f65e242, 0x6c93d61d84675c79, 0xd6a47020f3e55aae, 0 }, /* #23 */
    { 0x3d5057, 0x3d5857, 0xfd3e6ebba4b45ce3, 0xd5fb997ba3408f96, 0x9da807efcdd7f73a, 0x1accb44dcf5c9465, 0x1b175f0a02a10bf2, 0 }, /* #24 */
    { 0x203816, 0x203817, 0xdfa4852daae01d50, 0x45dfa3cca904c340, 0xc040351c6a237e69, 0xcfd86bac3dcbe8e1, 0xedeac975f75ec164, 0 }, /* #25 */
    { 0x105893, 0x105893, 0xee1964eeb1ef7979, 0x14dab9fd4b2cee87, 0xabca445ac5315ce7, 0x1c31c735b175af51, 0x1e506d12ac4da7ff, 0 }, /* #26 */
    { 0x284842, 0x284843, 0x0a3a5dfb53758c00, 0x924781a568c78c00, 0x9b67c1553df00efb, 0x07a2f31bd3cea79e, 0xbf23194538c5c181, 0 }, /* #27 */
    { 0x102147, 0x102947, 0xb9c2b3e11bc07ade, 0xff56a2300baffb2a, 0x28618efef2bb536a, 0x0eba66220358083f, 0x144c0e29dcf2fb3b, 0 }, /* #28 */
    { 0x3550d3, 0x3558d3, 0x0cfc8df1882b3657, 0x6d8b589b4a351da1, 0xf380a54fd8caf0b3, 0x04193786403d275e, 0x50caea4d42e520c7, 0 }, /* #29 */
    { 0x1c6dd7, 0x1c6dd7, 0xfb279fc6b6af7cc1, 0x9abe62f104f1a31e, 0x5787e79fe66abf54, 0x8932f9a2add2c28f, 0x8bd88f289b77a49e, 0 }, /* #30 */
    { 0x1e31d6, 0x1e39d7, 0xd9a77a4e2cb7d789, 0x54c80d345d44cc2a, 0x815ecc01824ec4de, 0x85e3cb45a10bdbbc, 0x9d7a6b8ff6a3565a, 0 }, /* #31 */
    { 0x2b2913, 0x2b2913, 0x46e43423227368c8, 0x9a622a0d7cf4ef60, 0xbf3a2fa3701b0a31, 0x03c5b110fb811c00, 0x0d9f43777f24decc, 0 }, /* #32 */
    { 0x064097, 0x064897, 0xf1b0228f7f7c2e00, 0x1cdb949e93b9be00, 0x112339c4a2ad1498, 0xa7d3cfe89aaf290f, 0xb1c3fcfddfa59c79, 0 }, /* #33 */
    { 0x160046, 0x160847, 0xabecac071b4763da, 0x6b8c3170b5cb1bf4, 0x3c68a201bf121618, 0x141460a98d389bdd, 0x1de62784b9640ea2, 0 }, /* #34 */
    { 0x2c7b47, 0x2c7b47, 0xc0f38a60df51083b, 0xff5c0e37e2efe7ff, 0x476a2ac07501c5f0, 0x34d743af213d3688, 0x461b6d01cb1ca70d, 0 }, /* #35 */
    { 0x110096, 0x110897, 0xdb2c3d7bee929bb3, 0xf1ef782e7e034c27, 0xfb63de6cf5788500, 0x745e41c18446a604, 0x87ebdb43999fc3bd, 0 }, /* #36 */
    { 0x035553, 0x035d53, 0x92fa309d111f2223, 0x8f9c537c579f0614, 0xc2485ee7e78d9d26, 0x09c785108bdaebe1, 0x11088b5f5d4e90dc, 0 }, /* #37 */
    { 0x363383, 0x363b83, 0x6c05a7b234b16b74, 0x465333c715eb1eb0, 0xd652b2ba2744ce85, 0x2319c0f6eb8fad97, 0x532f35748f53fd9c, 0 }, /* #38 */
    { 0x1e5c83, 0x1e5c83, 0x3810bbd4bf592ed1, 0xb3966e5a10d1ad42, 0x6551e552529b98e1, 0x2bb1837a9c1d14ce, 0xc78228f7a3a67da2, 0 }, /* #39 */
    { 0x0f73d2, 0x0f7bd3, 0x7f181252fe475cb7, 0x32fad2b3bde0a3fb, 0x12a86ec8455ae5da, 0x2f85c71792a38666, 0x5fb8ffcab00136dd, 0 }, /* #40 */
    { 0x213703, 0x213f03, 0x8cb621a9fe24c90a, 0x77e02d104ba92c8c, 0xf00804a8095be4c4, 0x8a63edd7b7ba35a7, 0xfbc6f3bb9e69eb0e, 0 }, /* #41 */
    { 0x2b1886, 0x2b1887, 0x5f3e3b788fb2bba8, 0x97c6141ab8791040, 0x45e65b4e6eb27421, 0x426b3c1554571ce9, 0xb2864baf167460e8, 0 }, /* #42 */
    { 0x1308c6, 0x1308c7, 0x5f51cac100ed5c78, 0x115a2eb0580bea78, 0x588ba9515dcf5bac, 0x5556ee94a3764a5b, 0xe53266b0b9193241, 0 }, /* #43 */
    { 0x333fc6, 0x333fc7, 0xe8a2787d8bbb19ea, 0x00ff98dfe9c9e426, 0xe6812e8c02948c36, 0xa9a291c3b0bad5b2, 0xbaac3ecaab171de7, 0 }, /* #44 */
    { 0x0e7e93, 0x0e7e93, 0xb548283b6f5fb879, 0xb75e76a2192af5f2, 0xefa1514c544954d1, 0x43546387bac6ad72, 0x5f14a258c7e06d02, 0 }, /* #45 */
    { 0x2e4f53, 0x2e4f53, 0x59f4cfd2e8db5df2, 0x129faaec90b3cb14, 0x8bee6164d7781221, 0x51bf86c8a6fd7d2e, 0xe8a41b59cf3bf25a, 0 }, /* #46 */
    { 0x3f2592, 0x3f2d93, 0x712b36e12ad98ec1, 0x6a812a097c8a2acf, 0xcaab5591cc2006ff, 0x36912b81b7b3dfbc, 0x7b6fc372f54bad8f, 0 }, /* #47 */
    { 0x080fd2, 0x080fd3, 0x1c7460440f9c44f9, 0x89e39711082aaa7d, 0x63f433b75c5c1ef4, 0x196c8a180a2db05e, 0xe4bbf60b756f66a5, 0 }, /* #48 */
    { 0x165f06, 0x165f07, 0x0a41a230ccb81846, 0x24c48e0e40f350d2, 0x9c01edeadaff0292, 0x09a6f7afba21bced, 0xf0eb865d42aaac03, 0 }, /* #49 */
    { 0x027d97, 0x027d97, 0xb7b90ed15ac2fe1c, 0x1e4a9993abf862a0, 0xdc9cb1a8567bd7eb, 0x88a19b2ad038dfe0, 0xbe61e5fb3353bc18, 0 }, /* #50 */
    { 0x016196, 0x016997, 0x1d108673204b0470, 0x339da464d0e088b0, 0x7b64738ca7eb17c0, 0x10b0aad8247469da, 0x93019200bfde2b9d, 0 }, /* #51 */
    { 0x391113, 0x391913, 0x112c124487250bd6, 0x08879050512f1386, 0x2dbad9e36463372a, 0x10e8154f375ab823, 0xfc0a71624636dd89, 0 }, /* #52 */
    { 0x197793, 0x197f93, 0xe373f11d1356bc89, 0x41b43c848e5da14a, 0x1019801310dad9ed, 0x6be64f0d261f4fc5, 0x79711f69ba27887a, 0 }, /* #53 */
    { 0x0564c2, 0x056cc3, 0xb0f81af661d04749, 0x69baca11dda7f092, 0x482d33c7b0b2466b, 0x1cd5a9d7a4e31162, 0x29b62a260fa25202, 0 }, /* #54 */
    { 0x093a06, 0x093a07, 0x4069bc96eb4adece, 0xcba9c77185902216, 0xa6218b39dddc3ce3, 0x3dd7c3ed57844c82, 0xf5c8fdb3243b5ebd, 0 }, /* #55 */
    { 0x082f06, 0x082f07, 0x6272afbb3ed1a57e, 0x322f9305a1456f90, 0xcd0ce815576f507b, 0x1f4fbf76ef4ee675, 0x516bcfd68a58e238, 0 }, /* #56 */
    { 0x1a1456, 0x1a1c57, 0x0386a65d3b2ee42e, 0x5a5dc93a6525ec12, 0x75a86b163d142579, 0x02f700bd5f1b1fbe, 0xd742a761840e8cdf, 0 }, /* #57 */
    { 0x3a5d17, 0x3a5d17, 0x57df6b76bdd0cf62, 0x3f218ef9f51dec80, 0xfbf931460f74c80a, 0x03f95cbf1e160871, 0x0b93e2c365122a40, 0 }, /* #58 */
    { 0x0c16d2, 0x0c1ed3, 0x1f3698daf08ba1f7, 0x7da5d26963180179, 0x33c97774396d410b, 0x01f10f640dc56779, 0x0fecb5476fc19c0f, 0 }, /* #59 */
    { 0x317147, 0x317947, 0x7b96957da2c6190c, 0x265a437b96e3d114, 0xd87624d49b30601b, 0x0b9650b06a7c2bd0, 0x180068f7746be6d7, 0 }, /* #60 */
    { 0x2b5d46, 0x2b5d47, 0xc9ee83846a381cdb, 0xd6bf4c427742478f, 0xdd67448309fc7507, 0x75f36c83b616e93a, 0x9588698ca6c3245d, 0 }, /* #61 */
    { 0x091212, 0x091a13, 0x9b40935c739d4970, 0x262470cf8f84f960, 0xc4165e032c8aabd1, 0x33c3d69599ceb17a, 0x555b588cb166d1da, 0 }, /* #62 */
    { 0x127b13, 0x127b13, 0x067f1cf19d505ae3, 0x0fb78103e7620461, 0x34f4b979c345365f, 0x06443f4b22920be6, 0xf6f05b192ebcf2eb, 0 }, /* #63 */
    { 0x2c6256, 0x2c6a57, 0x37541e56eb096b10, 0x93c3d2787fe9f510, 0xe83b28dd3393bc7a, 0x0d79303e5e0e3168, 0x3e570f4f03f7faa1, 0 }, /* #64 */
    { 0x2e4c56, 0x2e4c57, 0x0704a4863615a503, 0x0b22e1ed16bbf445, 0x119591b541cd5d03, 0x03f5a9b0a04e52b0, 0x906f4dc4f2910b17, 0 }, /* #65 */
    { 0x1a0743, 0x1a0f43, 0xda1faac9346808e3, 0xa70cc77c34273533, 0xa4621d039505a058, 0x9d546cfa3498829e, 0xb8a643b5655ee371, 0 }, /* #66 */
    { 0x1e57c2, 0x1e5fc3, 0x51680ede2b9dfd69, 0x82793ee31fbf0d93, 0x86326ed686a819bf, 0x1a4d66f8baa4bb01, 0x52b69df5d90ac79b, 0 }, /* #67 */
    { 0x3c4946, 0x3c4947, 0x2733517fdaf85b51, 0x74cb1cf5334dbfd1, 0xe583a2105a2b9dc7, 0x104992d9082b74e2, 0x6a5d8c236504fc81, 0 }, /* #68 */
    { 0x1b0443, 0x1b0c43, 0xc97277a220d71826, 0x4ff1abab7285e138, 0xf687722fba0c3186, 0x90fe906c208304d0, 0xb842738c3659a874, 0 }, /* #69 */
    { 0x300907, 0x300907, 0x198c934f632af63e, 0xf79e1316f9dc2566, 0x3e1ce8929c1b34a3, 0x1668d8bb3abf7759, 0xe08ab4eb9be909ed, 0 }, /* #70 */
    { 0x2b61d3, 0x2b69d3, 0x2bab19d948b67a33, 0xa24e745d3f94f59e, 0x1112f8afae2e0bf4, 0x29939a2247c08dbd, 0xf3bcb569f484b1ea, 0 }, /* #71 */
    { 0x2a1b02, 0x2a1b03, 0x59ff17b8b254bfd8, 0x25d70bd47dc21878, 0xa42b871b3a6e5f30, 0x0833f0c270de18f6, 0x1755663425b330fd, 0 }, /* #72 */
    { 0x290c97, 0x290c97, 0xb937f0c20b81d6b8, 0x299f027e137340d0, 0x1c177c42f3e85c99, 0x9012468f9126edfd, 0xc720e1ddc9dedf76, 0 }, /* #73 */
    { 0x0c1886, 0x0c1887, 0xed59aaca5139db03, 0xfcb58a401d994f8a, 0xf559c5c799dbebdc, 0x19ac5dae9cd7a614, 0x1bb0c9b7d8c7a72e, 0 }, /* #74 */
    { 0x0b3c42, 0x0b3c43, 0x177b19fafa2aea47, 0x7aa95771074a1b61, 0x0041021a52e67821, 0x0834333bea9d5b59, 0x59716b8aebf0f917, 0 }, /* #75 */
    { 0x0b5ec6, 0x0b5ec7, 0x68a049913743612a, 0x6f7fadafd27c0850, 0x6c8940dbb33e0440, 0x66af82c4749bb224, 0xfb407bb927012188, 0 }, /* #76 */
    { 0x3a4d13, 0x3a4d13, 0x0acd8ed0682d9db7, 0xa8199c7c5da27cef, 0x612a584efd5aff3a, 0x0061ac9ea50e1dd4, 0x090a9bac866f9a89, 0 }, /* #77 */
    { 0x323dd7, 0x323dd7, 0x195e72edcd39fa47, 0xc7c781386ae310e7, 0xed682711c7cb329e, 0x0887dfb35cdf11e7, 0x5615a4ed90dce461, 0 }, /* #78 */
    { 0x3e4ec6, 0x3e4ec7, 0x9942f55b22c3a015, 0xd399c9766adb0dd6, 0x01043eea7afa3651, 0x13eaf51baaf99746, 0x214507677dbe95fe, 0 }, /* #79 */
    { 0x292d16, 0x292d17, 0x889cd3e7628ebb16, 0x6727ea03580ac6b8, 0xb7e1d71df01be71b, 0x800a66b5bf58968a, 0xefefd67f0bf1cd94, 0 }, /* #80 */
    { 0x2b6542, 0x2b6d43, 0xcfc7a693444506e5, 0x6740a0af191f05e9, 0x501199bcbc8925d0, 0x56eabbc198d5fc8e, 0x6b16877f73842eb5, 0 }, /* #81 */
    { 0x3d4302, 0x3d4b03, 0xc69a562f8579e8ab, 0x0d59595a50cff628, 0x33653d8f7e904bdf, 0x370f7b64a8139111, 0x46f923b7fbacb278, 0 }, /* #82 */
    { 0x1746d6, 0x174ed7, 0xfa4416830e86e57b, 0x2f3e742819170220, 0x18ca04460c22312b, 0x8dad9f740e2c1133, 0x90ec9f98b6de9c60, 0 }, /* #83 */
    { 0x213cd6, 0x213cd7, 0xac887776363f28b0, 0x45a80a6df88a8740, 0x9a08c9aef35afad1, 0x7decb2520f34054d, 0xbad7f4b1b6f0cbdc, 0 }, /* #84 */
    { 0x014f52, 0x014f53, 0xa0ce94307edc0cd5, 0x6b1c8816303b205e, 0x5ce839a99a630cf7, 0x8eb381007bb1738d, 0xe32d18561221b5e6, 0 }, /* #85 */
    { 0x1868d2, 0x1868d3, 0x80d4bc5459e70510, 0xe3dc90faf20f3640, 0x31af6c234e98500c, 0x34c4997d7af43973, 0x68daee19f3e4a824, 0 }, /* #86 */
    { 0x056116, 0x056917, 0xdca6485c36bcab9a, 0x08c87458a6ea480a, 0xee06d052a8d8bf89, 0xc9df08a0b0147ea4, 0xea3693d2c156cf19, 0 }, /* #87 */
    { 0x225586, 0x225d87, 0xbe97e6e751f835db, 0x65d20fabc3a607d9, 0xecae831bdd119295, 0x5405b112c0309dd0, 0x70db409d3521995b, 0 }, /* #88 */
    { 0x2f1c52, 0x2f1c53, 0x2e68ccfa44b692f0, 0xee8fa393c80a5fd0, 0x369b7f07626969b7, 0x0d738a3c585d0e05, 0x4a330095dab0c093, 0 }, /* #89 */
    { 0x2b5c43, 0x2b5c43, 0x2c3353dafe75ddc7, 0x5d9def77e3e5cd46, 0xc61477bfddc623e1, 0x1e437e3e9116136a, 0xaf47da44e9c1c08a, 0 }, /* #90 */
    { 0x0a3e96, 0x0a3e97, 0xc4e36fea0527ff33, 0x8b6d7e91fdb36c97, 0xcfb7fbc66fc86e27, 0xaa2906f1232814ee, 0xdd3f4d2db7f2ad0d, 0 }, /* #91 */
    { 0x235453, 0x235c53, 0x73c71905b78ab64f, 0x608cd752b7c272ee, 0xa3825903d43bd2a5, 0x70e579d431166e54, 0xf9a10508db7950b2, 0 }, /* #92 */
    { 0x110e92, 0x110e93, 0xfd7df00240693e5f, 0x93b51763481e7cf6, 0x35b20ec0171832d8, 0x7e47a934583ef167, 0x7f8783023ce67aca, 0 }, /* #93 */
    { 0x2a18c3, 0x2a18c3, 0x7c52307a6e480d12, 0x0f812adb007eccd0, 0x1eb19f9177ecd959, 0x47dc7e9d8b7bf090, 0x93f9c7675f631928, 0 }, /* #94 */
    { 0x126643, 0x126e43, 0x2ac8105d1077d328, 0x04d3cd5522cd7120, 0x25d6333f74aa806f, 0x14710078ae2e4b8a, 0x7a51bbb991bea154, 0 }, /* #95 */
};
uint32_t const g_cTests_mul_u64_amd = RT_ELEMENTS(g_aTests_mul_u64_amd);

MULDIVU64_TEST_T const g_aTests_imul_u64_amd[] =
{
    { 0x3b0c92, 0x3b0492, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #0 */
    { 0x0b7602, 0x0b7602, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #1 */
    { 0x386817, 0x386016, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #2 */
    { 0x017e82, 0x017682, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #3 */
    { 0x2d2592, 0x2d2592, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #4 */
    { 0x113313, 0x113312, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0 }, /* #5 */
    { 0x325f03, 0x325702, 0x898b11d98313cf3e, 0x0000000000000000, 0x83096fe3c940e347, 0x0000000000000000, 0x0000000000000000, 0 }, /* #6 */
    { 0x104257, 0x104256, 0x3818a1593fcf2354, 0x0000000000000000, 0xe3f0236f190917a8, 0x0000000000000000, 0x0000000000000000, 0 }, /* #7 */
    { 0x265ed7, 0x2656d6, 0x5ddd4984909cabf4, 0x0000000000000000, 0x80aadfa4eb05a940, 0x0000000000000000, 0x0000000000000000, 0 }, /* #8 */
    { 0x002907, 0x002106, 0x43214604ae32b55e, 0x0000000000000000, 0x43f13796bd7bb236, 0x0000000000000000, 0x0000000000000000, 0 }, /* #9 */
    { 0x387b93, 0x387392, 0x98614e737d012dba, 0x0000000000000000, 0x0f22fd739c658d59, 0x0000000000000000, 0x0000000000000000, 0 }, /* #10 */
    { 0x2d10c2, 0x2d10c2, 0xaf9711087d7c5c69, 0x0000000000000000, 0x8a05612366df3ca0, 0x0000000000000000, 0x0000000000000000, 0 }, /* #11 */
    { 0x2c66c6, 0x2c6ec7, 0x6321b66663c61b2b, 0x59dae56f87b95aa2, 0x93f2d55d7a4df48e, 0x2f5ceb15d0173663, 0x7a4fac64eb95d6e6, 0 }, /* #12 */
    { 0x3f17d2, 0x3f1fd3, 0x0d4395225dbe9d37, 0xc9a9a8f2c31bf260, 0x20fedc378ff412cf, 0xfb0e03269096e01b, 0xa08df8103c2bd0a0, 0 }, /* #13 */
    { 0x187302, 0x187b03, 0x5129d2e07182626a, 0xb79b2cc82c3c1600, 0x2ba8390f50d378ed, 0xf812626b2888ba5c, 0xe6fe5313713a3f00, 0 }, /* #14 */
    { 0x001847, 0x001847, 0x8d70e1ac7b41906c, 0xaf0944f3a5c91b48, 0x61f2060b6defea18, 0x33f781d487db4404, 0x8bdf3f60186acd96, 0 }, /* #15 */
    { 0x393d96, 0x393d97, 0xe569b11c3d563001, 0x5bc3b075eb50b3f0, 0x213abb9ec55f04e6, 0x0aa0c4d2f37ef00b, 0x99aa7e2996f3b3f0, 0 }, /* #16 */
    { 0x0042c3, 0x004ac3, 0xb0fc2fc8d3bc533a, 0xc6e4e8ac37380552, 0x4048eae87ca52d6b, 0x0774ebbb5f577b8b, 0xe7d74bcf7336257d, 0 }, /* #17 */
    { 0x321752, 0x321f53, 0xdb81faed9d22dba4, 0x21a63c044c9174d0, 0xaa54ba7db2810c8a, 0x070e970e4dfc7afb, 0xce7e6f9b609f9b14, 0 }, /* #18 */
    { 0x113086, 0x113887, 0xaee95e6d07ca3eed, 0x906a2a3ceee84d11, 0x0e60462e9b365e2a, 0x05ecb39f59d82ff2, 0xed4bb320d29f9e35, 0 }, /* #19 */
    { 0x1d1113, 0x1d1913, 0xef9e1bdc0d8e26ef, 0x26ac4951ce7e34ba, 0xbebea553b53741c3, 0xfc9f5514a3b9a92c, 0x34c7c311f6fc66e6, 0 }, /* #20 */
    { 0x172c03, 0x172c03, 0xad6c54949967cbab, 0x8f552d512021de2d, 0x5041d5676324f8ab, 0xfb4d4204a8b0d732, 0x0e90ac3112216587, 0 }, /* #21 */
    { 0x184c47, 0x184c47, 0x0e5b492f8015aa3c, 0x661e1a31ed074744, 0x91b1fb9fcb21b406, 0x048f6aa4ca96bc5e, 0x5150d5463bfead9f, 0 }, /* #22 */
    { 0x216f83, 0x216f83, 0xbeef493d8835b8ac, 0x777b320e50fff4f8, 0x0721029e0fb16412, 0xef4e327220edb942, 0x41af518ac832d6ba, 0 }, /* #23 */
    { 0x125c96, 0x125c97, 0x73ac947be084e076, 0x4e8f4feb47c2d422, 0x94b9b4ae874831be, 0xe3f52955cff5161f, 0xc1f06a696c051623, 0 }, /* #24 */
    { 0x3742d6, 0x374ad7, 0xdd8f0f97deced726, 0x4ed1ad7d6264d032, 0xb9533de41b4891aa, 0xfcd5ec734070c565, 0x178544f188046123, 0 }, /* #25 */
    { 0x315712, 0x315f13, 0xe4b1e6b6530da49b, 0x4a15534a6a3149e1, 0x5ab714809ba1c98c, 0xf85f60da7fff3c0a, 0x4782e573e9a2ed33, 0 }, /* #26 */
    { 0x260592, 0x260d93, 0x87567ebaeb5b8c46, 0xd70a80d1fabc6138, 0xda01a6667f9a09ec, 0x0eea02d592c68d6e, 0xe05b9b076253a0b4, 0 }, /* #27 */
    { 0x1e7903, 0x1e7903, 0x04433fde03782305, 0x625e450a927a8de7, 0x83eaf65f1b160a01, 0x0043f5b28e8f58f2, 0x0ff162dcf6d4d8fb, 0 }, /* #28 */
    { 0x110286, 0x110a87, 0x1072fbd2610fe1d8, 0xedf99d8e06efd810, 0x756da974acf2c141, 0xf983586960c36649, 0x9b0b0cccf2903ae6, 0 }, /* #29 */
    { 0x3553c6, 0x355bc7, 0x0395d743b4cf060b, 0x395a78296fd4ed5a, 0xb54f8f25a267718b, 0xfffb4cdb63a0d519, 0xfeb06cc17a3f024e, 0 }, /* #30 */
    { 0x3433c3, 0x343bc3, 0xea4ef879c6ba3295, 0xe88c6a086a86f96e, 0xbab4b1618bc51ff3, 0xfdab1101838e4171, 0x1b84eb16ece99636, 0 }, /* #31 */
    { 0x262042, 0x262843, 0x337f119435d21576, 0x6f7d74e7beba92ce, 0x458444279b5b46c9, 0x03ad922e83f089a8, 0x1248c2e8ee965f45, 0 }, /* #32 */
    { 0x341692, 0x341e93, 0x0449e58de2ffbed6, 0x72a0fa25f4fee86c, 0xb442ba8c4f7daf01, 0xff14136e67ea585f, 0xc8fd24be48e55822, 0 }, /* #33 */
    { 0x373a86, 0x373a87, 0xbde08eaa68a552d2, 0x6e5b1a1adac2e1a8, 0x4af873cc21b65aa2, 0xe413da20e67f5e41, 0x6c1aa5f4bd7a5bb4, 0 }, /* #34 */
    { 0x054cc3, 0x054cc3, 0x8cd5e1f30e74a84f, 0xbef4527cb48ed8e7, 0xdd5cfb802de51f1a, 0xc87367b4bb4e06b1, 0x7b7b0eb6f66087e9, 0 }, /* #35 */
    { 0x026d16, 0x026d17, 0xca3d6590d425044d, 0xd84c15b9edf720ab, 0x34880c9ec4d6d630, 0xf21168870db4e316, 0x4257b770cff494d7, 0 }, /* #36 */
    { 0x0c1b43, 0x0c1b43, 0xce6ee4162c11f318, 0xef28e4fa205f53d0, 0x025bb943524067c1, 0xed2b39a066402479, 0x6142117cd3dfffbe, 0 }, /* #37 */
    { 0x0974d2, 0x097cd3, 0xad856897693079b1, 0xdf009622df60b164, 0xf880893a9195a8da, 0x17b3f8ecb874d992, 0xb66e13233eb17ca4, 0 }, /* #38 */
    { 0x2a1b93, 0x2a1b93, 0x3fab3c516ccbeae8, 0x8b723f4dfb5c6448, 0xc85f36de83052b52, 0xecc94ba5fa2d1ec5, 0xb2bedce4a30b2d1d, 0 }, /* #39 */
    { 0x3e6497, 0x3e6c97, 0xb22530360d866455, 0xbc0d2b69d4f0db10, 0xd5ab3220678042f2, 0xf5ccc236a680d1c3, 0x218a380e9a67fed0, 0 }, /* #40 */
    { 0x265103, 0x265903, 0xe7888d3c2c5a782f, 0xe6234eef42427e8b, 0x7ce7c9a335f0726a, 0x085aefdf33605997, 0xa893c6b015672c65, 0 }, /* #41 */
    { 0x190253, 0x190a53, 0xdff5b9cfc59690b2, 0xd5ddd68762488b74, 0xc9ab06a37d79d56d, 0xf51b4a2c42a90caf, 0x5709bcaa7b40bc4a, 0 }, /* #42 */
    { 0x014897, 0x014897, 0x40f180a1be0ce682, 0x43831bf699a23cd4, 0x399f734f2f33eb56, 0x1110b1cb27480f89, 0x4344f05f934b85ea, 0 }, /* #43 */
    { 0x006e86, 0x006e87, 0x3f3ec04c1233e63e, 0xdc0b32016a22df3a, 0x897df19e70c2de04, 0x06ee134e4cda252e, 0x1c0d0059eb81e1c3, 0 }, /* #44 */
    { 0x116152, 0x116953, 0x7812182bf868107b, 0x67394fd6c2f69bb3, 0x8dd499922bf0cbcf, 0xdf458bf07c5e382e, 0xba387ceb80ae6829, 0 }, /* #45 */
    { 0x1166d7, 0x116ed7, 0x562686b148007591, 0x3264cbd3ebea4a7c, 0x12c69c78c813e78c, 0x16c1e0c6e83800f1, 0x439fdab26d4ab4bc, 0 }, /* #46 */
    { 0x0e7ec7, 0x0e7ec7, 0xc1c6e6c4daba5f4d, 0x57e31efc531cf17f, 0xa49b7cb769584ec5, 0x13b9dd501d80b730, 0xaed7b0269c1905fb, 0 }, /* #47 */
    { 0x2d26d2, 0x2d2ed3, 0xedbcd3f15ce2cbf7, 0x92e6b8852d975ad3, 0x17a7aa65c7feab80, 0xffa4e9cf29ada185, 0x04fcd797c0a3d905, 0 }, /* #48 */
    { 0x2d7d07, 0x2d7d07, 0x1be1fce8a3c11f1e, 0xf99cc6a9962b601e, 0xa911ae27d1a31278, 0x0cc131e6d6671fe8, 0x751abaf487c09781, 0 }, /* #49 */
    { 0x280442, 0x280c43, 0x05d0a8f85b798037, 0x26b93c51d05a6ffe, 0x48362f9706055597, 0x02c202c22d980c89, 0x79690dab4384a4f2, 0 }, /* #50 */
    { 0x0013d2, 0x001bd3, 0xc0357c58c5e8f13b, 0xc4acdaf315b98462, 0x0a88256037769656, 0x0f61b54aef7a6272, 0xc2459484704dc706, 0 }, /* #51 */
    { 0x196746, 0x196f47, 0x98d705d2cdcb3834, 0x2b1bd970f9699734, 0xe2f99fd28cbf4b8f, 0x0a1f91f8f58e59ce, 0xe6e0cf69b26bc6c1, 0 }, /* #52 */
    { 0x112b43, 0x112b43, 0xf1b597e507ef5500, 0x77d254a581996800, 0x0055c60f490754e2, 0x031762fdec3701d9, 0xc89f3fe8ff3e23c8, 0 }, /* #53 */
    { 0x1c1cc6, 0x1c1cc7, 0x8348dae81f780f9c, 0xb8e10c2692383108, 0x178d3f16e41bb707, 0xdb1896f371260b7d, 0x4bc072963a28c96e, 0 }, /* #54 */
    { 0x3c3202, 0x3c3a03, 0x55be2ddda594f285, 0xdb3cd6805c302fec, 0xb80768c078b51351, 0xec18ef21e688683f, 0xc493d008ee6e31fc, 0 }, /* #55 */
    { 0x3e3f93, 0x3e3f93, 0x2a3e244f7392cac4, 0x12e5fc5473e61f88, 0xf0bda9b955c1f507, 0x045e9f676d3219d1, 0x1a7b1762f3d1ea82, 0 }, /* #56 */
    { 0x3c3083, 0x3c3883, 0x65b9a93f711cfb59, 0x1c9a230d28ff0a84, 0x0c2c10b540169b46, 0x1a76288b7ff91d42, 0x4297bb3ba0fd0224, 0 }, /* #57 */
    { 0x051fd3, 0x051fd3, 0x9d8bdddd44ebeed1, 0xcd06c5c1d8132418, 0x0b90de3a8992e752, 0xf218b2ab7d1b5481, 0x2426ed6053edd898, 0 }, /* #58 */
    { 0x2a6cd6, 0x2a6cd7, 0xc452bde015d9b43f, 0xbc93312b12bc2d16, 0x8abb13ef542fbf57, 0x095d09006b854a45, 0xd7d542338019b56a, 0 }, /* #59 */
    { 0x2d2e56, 0x2d2e57, 0x40b685f50a876bcd, 0x819420937b491c36, 0x51139fdf0f149830, 0xf91e21e8d6e82b2f, 0xe4c62d0f9f65130e, 0 }, /* #60 */
    { 0x386753, 0x386f53, 0x742082ec2c91407b, 0xde83c74046057728, 0x859cb91c286806e5, 0x24c3249b96c75789, 0x510ab493743d00f8, 0 }, /* #61 */
    { 0x152782, 0x152f83, 0xe55b505a5d1d28b4, 0x4fe191aa866b4b14, 0x73bc161b8df878b2, 0x05879e7f48246495, 0xcade23ee814f81f9, 0 }, /* #62 */
    { 0x090482, 0x090c83, 0x1e2466614210d169, 0x3e8d79753a4c82e1, 0x581d582d27bd9a90, 0xf4fa6fa33bc8c9dd, 0xa2643b8cae87feb9, 0 }, /* #63 */
    { 0x0116c3, 0x011ec3, 0xda64e68029d2fb1f, 0x03d9255bf10c9b7a, 0x27aec828d658eb09, 0xf3aa72fca3afe24e, 0x53f6dea2c3d6ef46, 0 }, /* #64 */
    { 0x1267c3, 0x126fc3, 0x3ebb5c3377e49043, 0x61822eb5f257e1e1, 0xcc27c3aabea23871, 0xe7cc4a6a9f83fada, 0x9d3c2d8aade4250b, 0 }, /* #65 */
    { 0x114e06, 0x114e07, 0x9a5867a55d2c96ad, 0xa8bb2da7c557ab50, 0xcc1a1938a1fc8f26, 0x0780b17523601b60, 0xed1b0f8c456dd290, 0 }, /* #66 */
    { 0x194756, 0x194f57, 0x698b42ee1cf63ac0, 0x25165b28d17e4840, 0x01aede61f5d72c90, 0xe6f44d22954110ad, 0xc3403d49bf89b323, 0 }, /* #67 */
    { 0x372617, 0x372e17, 0x0ca0ad80713ad1c0, 0x7ea499592c4c40c0, 0x153b8da208deb4fa, 0x0094d34a6452f2eb, 0x0bc9220638cfb265, 0 }, /* #68 */
    { 0x185ec3, 0x185ec3, 0xabe77880850a5f11, 0xfcbf7f3f4d2d9898, 0x06fbdac5a9983204, 0x0e5e49892cb4c26d, 0xd442c11640d7bf18, 0 }, /* #69 */
    { 0x102042, 0x102843, 0x1b3423818cb56daf, 0x757af727b8a103c0, 0xed8ab2937c06f81a, 0x07bf35596c31c2af, 0x48e6f990acd1e840, 0 }, /* #70 */
    { 0x0a0256, 0x0a0a57, 0x987c22e75df2737d, 0xd08bb42521b3616e, 0x4d17b0a43dd7783f, 0xd756e55fffc97401, 0x648e6f934e4e0686, 0 }, /* #71 */
    { 0x3f4f52, 0x3f4f53, 0x0ba6f7a59dc376b7, 0xe19901dd08a9e226, 0xe1c0e3cdbecc779c, 0xfce7b7b83498a58d, 0xbc01807e3eabb90a, 0 }, /* #72 */
    { 0x1a6ed3, 0x1a6ed3, 0x6703ce5a25bf20d2, 0xc8831550c634a7bc, 0xfbb36cd9eae08ab8, 0x133e9927605634a6, 0x2fd2fb5b80af392e, 0 }, /* #73 */
    { 0x344c92, 0x344c93, 0x850645cb2f58c650, 0xc6b2c40da27bcf80, 0xb77e01195ed035d4, 0x14e7251119d03c9e, 0xd47c705cb17a4d98, 0 }, /* #74 */
    { 0x343287, 0x343a87, 0xda37c7d3ea347622, 0x61ad110186408a3a, 0x1808e36a44201beb, 0x0cae3a2e1705783c, 0xaa148e9daf8a714d, 0 }, /* #75 */
    { 0x1e7b02, 0x1e7b03, 0x6d452c415270d35f, 0x20cf8b2ca13180d6, 0xae65dcbd66daeab0, 0xd9c3684ad639eb90, 0xa66b20a7e17f34ea, 0 }, /* #76 */
    { 0x2c6853, 0x2c6853, 0x0f833183b952618f, 0x559b3497bf4b1f50, 0xa945a6fe6e279769, 0xfab3e8f0a5cbbb9c, 0xa894a6eadbd6a3b0, 0 }, /* #77 */
    { 0x1a0243, 0x1a0a43, 0xe6724349171fc3d6, 0xc822c3fd7357b984, 0xe2a7c90b979fa22a, 0x080497e0708b106d, 0xafacd86eb58023c6, 0 }, /* #78 */
    { 0x353617, 0x353e17, 0x2595690f1cfa1189, 0x5866ceaa3b965457, 0xc2f0e15b74246b0f, 0x0f9a6805c9125a1b, 0x6a47cce9d45b1edf, 0 }, /* #79 */
    { 0x1e0b82, 0x1e0b83, 0x3f66995bbac58bf1, 0x6d90e583f99107eb, 0xa1290a09a8de66b5, 0x04f53bafca220050, 0x1404ea9b3bcb1d9b, 0 }, /* #80 */
    { 0x061117, 0x061917, 0x9a1441d4ce673627, 0x08e2ca48aa34bfc0, 0xeea22eae27edd2ac, 0xf5f161be2fe188ad, 0x1942cdbbd9a6da40, 0 }, /* #81 */
    { 0x105dc7, 0x105dc7, 0xbff937daa08fc98c, 0x020ac2795ca72204, 0x51564ecc82c20ad9, 0x1fea8e20ff0479cf, 0x80634d40f94f5ccb, 0 }, /* #82 */
    { 0x2424d2, 0x242cd3, 0xc51e83ae7089491a, 0xbac27c5c437a2496, 0xb81ae21b165737f5, 0x1392899ceef832ed, 0xaae759eeacf29837, 0 }, /* #83 */
    { 0x014f16, 0x014f17, 0xa8700d4fa92f6c50, 0xd39648e7335efa10, 0x12473a769479f31a, 0x0a579a700d42ed15, 0xe1c3615d424f432d, 0 }, /* #84 */
    { 0x174646, 0x174e47, 0x883624f26761d634, 0x8948b8e8aa07459c, 0x4b233c365ab3b0e7, 0x223c2d489f27d816, 0xb6d613deb64623c3, 0 }, /* #85 */
    { 0x3210c7, 0x3218c7, 0x5e4d149eab3ea71b, 0x7a5626bd28917835, 0x25b7ab9c5684c170, 0x0bffd22160e1a299, 0x209319397d63c2ef, 0 }, /* #86 */
    { 0x1c7dc6, 0x1c7dc7, 0xcb8e89e2f1febe86, 0xff0c8727e57a71ba, 0x50de2a9f7afe5a5b, 0x182f8bb4d640ae1a, 0x89f0263629c0355f, 0 }, /* #87 */
    { 0x1c4906, 0x1c4907, 0x0eb4e19d5e99f928, 0xf90f651b81cbe530, 0x46fe4da8054832c9, 0x01be67c0cbcc02a6, 0x1e5aa93f219c542e, 0 }, /* #88 */
    { 0x1d7682, 0x1d7e83, 0x3845bc1ccc59bd04, 0x02fb2a84ac697f04, 0xcd13545faa40ef20, 0xfce492cb6dbd8479, 0xf1dd5dc9f0085081, 0 }, /* #89 */
    { 0x387187, 0x387987, 0x005ff5f79da51279, 0xdfe5a3c3761e5bb3, 0x649722e11c0d2b52, 0xfff8e89870c386b2, 0xed14f1b43e72f48b, 0 }, /* #90 */
    { 0x081856, 0x081857, 0xa33e0e1a8a4b81e9, 0xd90207295a7a87a9, 0x404a88ed2afbe837, 0x1d39558ee9b1eb12, 0xaf5866f91d637fc1, 0 }, /* #91 */
    { 0x101e83, 0x101e83, 0x973fa90bcc58c25a, 0x7da897dfc732e068, 0xd17b7f9fd4731d19, 0xf570862e5d2af5ed, 0x19cefaa142f7c984, 0 }, /* #92 */
    { 0x280e17, 0x280e17, 0xfdc9b9a2cf089a4b, 0xb4e52a74e2097462, 0xba90fdcf46ba7b32, 0x0036f1f7c44265e5, 0xe729187105075fe6, 0 }, /* #93 */
    { 0x035782, 0x035f83, 0xb4fb7e2d794167a4, 0xaae3a21eb7b38b24, 0x2bee16ff6b18d787, 0xdbdef137c4223046, 0x7b4ab537dc27d5e1, 0 }, /* #94 */
    { 0x3f6d17, 0x3f6d17, 0xbb8e82d57a94bf1a, 0xc567d092d2837090, 0x50b0ea8fc92f8c7f, 0x09851436734e82e8, 0xdc648a9b116d4368, 0 }, /* #95 */
};
uint32_t const g_cTests_imul_u64_amd = RT_ELEMENTS(g_aTests_imul_u64_amd);

MULDIVU64_TEST_T const g_aTests_div_u64_amd[] =
{
    { 0x077582, 0x077582, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #0 */
    { 0x064dc3, 0x064dc3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #1 */
    { 0x361dd3, 0x361dd3, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #2 */
    { 0x353f12, 0x353f12, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #3 */
    { 0x077c43, 0x077c43, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #4 */
    { 0x313806, 0x313806, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #5 */
    { 0x162652, 0x162652, 0xc5a6d1ae8200d901, 0xc5a6d1ae8200d901, 0xc5bf20844b0ff968, 0xc5bf20844b0ff968, 0x0000000000000000, -1 }, /* #6 */
    { 0x2f5dc2, 0x2f5dc2, 0xec32c7486dd023fc, 0xec32c7486dd023fc, 0x415f5a69b9b97f76, 0x415f5a69b9b97f76, 0x0000000000000000, -1 }, /* #7 */
    { 0x282413, 0x282413, 0x7caaaafd89341e33, 0x7caaaafd89341e33, 0x4ee128d268bfe728, 0x4ee128d268bfe728, 0x0000000000000000, -1 }, /* #8 */
    { 0x3e7a97, 0x3e7a97, 0xdda4ea9f46b80e16, 0xdda4ea9f46b80e16, 0x62a43ddaf6279cc0, 0x62a43ddaf6279cc0, 0x0000000000000000, -1 }, /* #9 */
    { 0x1844d2, 0x1844d2, 0x90ddc955eb6c2080, 0x90ddc955eb6c2080, 0xbfadbec010ccf419, 0xbfadbec010ccf419, 0x0000000000000000, -1 }, /* #10 */
    { 0x064fc3, 0x064fc3, 0x41cd60340ca85e65, 0x41cd60340ca85e65, 0xee4326a4926717ac, 0xee4326a4926717ac, 0x0000000000000000, -1 }, /* #11 */
    { 0x1d7096, 0x1d7096, 0x9712b07957265aca, 0x9712b07957265aca, 0xccc27fd7cbffe3c4, 0xccc27fd7cbffe3c4, 0x2378ba6f355702cc, -1 }, /* #12 */
    { 0x043b52, 0x043b52, 0xdea630dc5f1ae4d8, 0xdea630dc5f1ae4d8, 0x1d75e92e30d1cb3c, 0x1d75e92e30d1cb3c, 0x0328fc26281fda1e, -1 }, /* #13 */
    { 0x024516, 0x024516, 0xe910609c334f82bd, 0xe910609c334f82bd, 0xa61d11393236b6d3, 0xa61d11393236b6d3, 0x7a58aa6e7e55e98e, -1 }, /* #14 */
    { 0x1d3987, 0x1d3987, 0x8111d232c862989e, 0x8111d232c862989e, 0xe9c1571af8fef1fd, 0xe9c1571af8fef1fd, 0xd1f8f0d5143d8160, -1 }, /* #15 */
    { 0x0b3902, 0x0b3912, 0xd3aabf5a36562d18, 0xa74d3da8aba90642, 0x4aeaca2baef8b7cc, 0x3a2c1e83960591e6, 0x72a2ccc9fc7ef379, 0 }, /* #16 */
    { 0x325ac3, 0x325a13, 0xf8ffeedf1cc289ca, 0x28901e77b570afc3, 0x1362e7662a9bb088, 0x397540b8de352e19, 0x7a59c23ac245e37b, 0 }, /* #17 */
    { 0x1e2c97, 0x1e2c13, 0x387d7e615114fb49, 0x239b0a8e25a5e3e9, 0x21b54c68b6f45013, 0xe193d75f4a4cfd57, 0xf25b9216c5ab5122, 0 }, /* #18 */
    { 0x137c06, 0x137c06, 0xc98c8d222c513d41, 0xc98c8d222c513d41, 0xb17b978270f81e07, 0xb17b978270f81e07, 0x22db59bc2917f12f, -1 }, /* #19 */
    { 0x207852, 0x207852, 0x5c4fbec2d2fcf173, 0x5c4fbec2d2fcf173, 0x922fe2d6f774c113, 0x922fe2d6f774c113, 0x022c91b805d579c1, -1 }, /* #20 */
    { 0x1268d2, 0x126812, 0x663787567d7d316b, 0x715f4455d30dd650, 0x3fb5d2d247965387, 0x03b03d03a0db39fb, 0x8fdc675f7a23f9ab, 0 }, /* #21 */
    { 0x061613, 0x061613, 0x582c83953968ef25, 0x582c83953968ef25, 0xe973a745d272b799, 0xe973a745d272b799, 0x22e7ef4fa7eab845, -1 }, /* #22 */
    { 0x105e43, 0x105e13, 0xe797ce9a319cb698, 0x052322be84eba63b, 0x04a9a0d6df7cf4c4, 0x714870a637ca2d63, 0xe85906d6e5a1e74f, 0 }, /* #23 */
    { 0x0f6043, 0x0f6013, 0x45853e4ac38e93bc, 0xbd5f0bac7726937c, 0x9d8d6a3a2ebc8fee, 0x90107033e5eb7f80, 0xd4fc65632f3935d1, 0 }, /* #24 */
    { 0x245152, 0x245152, 0x07b0de25e4188c82, 0x07b0de25e4188c82, 0xd3c67dd7acc85314, 0xd3c67dd7acc85314, 0x33cb34890c6fd939, -1 }, /* #25 */
    { 0x2628c7, 0x2628c7, 0xc39d4dfe0d89951f, 0xc39d4dfe0d89951f, 0x9d8fae864c6b608c, 0x9d8fae864c6b608c, 0x29b517cb440aee93, -1 }, /* #26 */
    { 0x2d25d3, 0x2d25d3, 0x081e3a25e40dd50c, 0x081e3a25e40dd50c, 0x720b99d8b87b7820, 0x720b99d8b87b7820, 0x5eebfa0317a14d93, -1 }, /* #27 */
    { 0x096847, 0x096847, 0x4017587c21df219b, 0x4017587c21df219b, 0x601c9456fcb255c3, 0x601c9456fcb255c3, 0x210b8f8a744ecb65, -1 }, /* #28 */
    { 0x3c5ec6, 0x3c5e12, 0x6c375135648742df, 0x36502ca57cf10c33, 0x20985fe3e3b48540, 0x6e839d6575334fff, 0x99a269eaf3bf61a0, 0 }, /* #29 */
    { 0x172f97, 0x172f97, 0xa12ab890d3d56e07, 0xa12ab890d3d56e07, 0xbc3056ccbbbb27c6, 0xbc3056ccbbbb27c6, 0x7c09d2e64992aac6, -1 }, /* #30 */
    { 0x3518d7, 0x3518d7, 0x6dcdd241b3315cf4, 0x6dcdd241b3315cf4, 0x98c20cac63a6c0e5, 0x98c20cac63a6c0e5, 0x60969755abcdfce6, -1 }, /* #31 */
    { 0x295e03, 0x295e13, 0x77d8248f616516b6, 0xa39bd5d321424735, 0x91a54c45cf4844ed, 0xd5b5989d1b2f8f9b, 0xe3e4a0f9fb324f0f, 0 }, /* #32 */
    { 0x044dd7, 0x044d13, 0x1611b9223b929b4c, 0xd1c128c24d11980e, 0xaff423f1e591727f, 0x38ae4d307cdc6dfa, 0xd6bf36a04563bbcf, 0 }, /* #33 */
    { 0x1b4e02, 0x1b4e12, 0x9e58daafa920a59c, 0x6a4884ba70978e36, 0x66a1f8cabde48814, 0x0f42827fad712740, 0xf734ff5113d4ca6a, 0 }, /* #34 */
    { 0x265bd3, 0x265b13, 0xa470a5e40820d8aa, 0x9fd6e563a9304aba, 0x8d7002f69f9b4f40, 0x66e01e742495aa5e, 0xe2870369f4d26b5e, 0 }, /* #35 */
    { 0x311502, 0x311502, 0xd53e14a34e9bc75e, 0xd53e14a34e9bc75e, 0x586ae3835ebd050d, 0x586ae3835ebd050d, 0x16e416b6917eb9fb, -1 }, /* #36 */
    { 0x0f1257, 0x0f1213, 0x73ff72501905700d, 0xc09c6bf117adcefc, 0x6917b29e87a9fcdb, 0x3f1a88d4548e7cf1, 0x8badcd15d2cfd8f9, 0 }, /* #37 */
    { 0x332392, 0x332312, 0x6ef30edde02c185b, 0x1e1dc59d028ed899, 0x071a05e45754e73f, 0x0e17ab22e7d11a0c, 0x3c5de37a025c5727, 0 }, /* #38 */
    { 0x017d86, 0x017d86, 0xca3ed4c5a9d98f0d, 0xca3ed4c5a9d98f0d, 0x57cd0d49e302f797, 0x57cd0d49e302f797, 0x139ea0a2572360a7, -1 }, /* #39 */
    { 0x041693, 0x041693, 0x885ff780db25b44c, 0x885ff780db25b44c, 0xcef020359472199f, 0xcef020359472199f, 0x60b746fb76d2a00f, -1 }, /* #40 */
    { 0x153a52, 0x153a52, 0xc58d0ca16529781e, 0xc58d0ca16529781e, 0x966166fdaf3841b3, 0x966166fdaf3841b3, 0x0d76e833d4b07785, -1 }, /* #41 */
    { 0x067306, 0x067306, 0x346e978f69f38c08, 0x346e978f69f38c08, 0xdb4dc51308a06901, 0xdb4dc51308a06901, 0x4cc15d96cec59139, -1 }, /* #42 */
    { 0x0e1b12, 0x0e1b12, 0xd5040ba82aa67003, 0xb1b092b94f2957ac, 0x3d11d486bc996e32, 0x3e5725a18957adb3, 0x57fbdea55d97c8bc, 0 }, /* #43 */
    { 0x162ed2, 0x162ed2, 0x2828e754d5a39b4d, 0x2828e754d5a39b4d, 0x786b21dfd56b5065, 0x786b21dfd56b5065, 0x6a5d3a42417cd469, -1 }, /* #44 */
    { 0x1b58c2, 0x1b5812, 0x4a1ed115115b7022, 0x5f3af79f436668cc, 0x5b446116ad30bee3, 0x0b1652d7ed39cf9a, 0xf55890b96641f956, 0 }, /* #45 */
    { 0x057d03, 0x057d03, 0xb5dcf2049ad482e2, 0xb5dcf2049ad482e2, 0x5a428236bc95003c, 0x5a428236bc95003c, 0x0f2031dec472d585, -1 }, /* #46 */
    { 0x2a0e47, 0x2a0e47, 0xafdf1810e297b27c, 0xafdf1810e297b27c, 0xc02549199fa4dafd, 0xc02549199fa4dafd, 0x88ff7f8c8fe22935, -1 }, /* #47 */
    { 0x0e44d3, 0x0e4413, 0xbe25b6c33ba3ca0b, 0x22e512fd8239d6eb, 0x1483138fde01fce8, 0x7d0435370ed18c40, 0x967ba420a9793ca1, 0 }, /* #48 */
    { 0x143c42, 0x143c42, 0xc4f09d59a349d7b4, 0xc4f09d59a349d7b4, 0xb807b920c336a301, 0xb807b920c336a301, 0x475544fa030b009d, -1 }, /* #49 */
    { 0x231d86, 0x231d12, 0x863bbfe20b449f61, 0x74bb91ded7955ed0, 0x6f76be813cb291a0, 0xd4c0935102a840c1, 0xf471f71b5cd54052, 0 }, /* #50 */
    { 0x162883, 0x162883, 0xb28e54f838bdc3fd, 0xb28e54f838bdc3fd, 0x8f93c8219e6ca089, 0x8f93c8219e6ca089, 0x8b8489cc6f381757, -1 }, /* #51 */
    { 0x3256c7, 0x325613, 0x89d1a2bc5974e6a2, 0xd61c0a07a985c7d9, 0xd0168bcd62130a80, 0xae1a0a4bc689ee04, 0xf8ccea09f83468ce, 0 }, /* #52 */
    { 0x191203, 0x191203, 0xaa4a9ed2e0ed0a79, 0xaa4a9ed2e0ed0a79, 0x615733c7490102af, 0x615733c7490102af, 0x5626d636618f87f4, -1 }, /* #53 */
    { 0x397e96, 0x397e96, 0xd02ec5de5b25d2be, 0xd02ec5de5b25d2be, 0xa6fc9dd8eec09af2, 0xa6fc9dd8eec09af2, 0x2faf79d712df04ba, -1 }, /* #54 */
    { 0x282a96, 0x282a12, 0x2e53c3e535cc27f6, 0x38b69a91eb3b60fb, 0x2ec34e72bd620725, 0x6f802b18c3161db8, 0xd315abd7d853365a, 0 }, /* #55 */
    { 0x045ad6, 0x045ad6, 0xb24b974e40fd3f5f, 0xb24b974e40fd3f5f, 0xdb42bce140ba9bae, 0xdb42bce140ba9bae, 0x88b5df07ba7e8695, -1 }, /* #56 */
    { 0x054902, 0x054902, 0x2898a7fc88bddb8b, 0x2898a7fc88bddb8b, 0xffc44325be3ca636, 0xffc44325be3ca636, 0xc0b5f72fee1473ab, -1 }, /* #57 */
    { 0x1b6602, 0x1b6602, 0xad59bd2ddfd06fc4, 0xad59bd2ddfd06fc4, 0xffec67ecde92ec9d, 0xffec67ecde92ec9d, 0xad34f44f799af890, -1 }, /* #58 */
    { 0x130592, 0x130512, 0x8ca9c0f3fe302c42, 0x615b51700bb1d70b, 0x26bd39fddcbab8d7, 0x22afe73c9447e73f, 0x65dd66a0512a24e9, 0 }, /* #59 */
    { 0x3c25c3, 0x3c25c3, 0x77a0376c529be042, 0x77a0376c529be042, 0x8e66e28c3796d0cf, 0x8e66e28c3796d0cf, 0x411bf4c204a35cb7, -1 }, /* #60 */
    { 0x216d17, 0x216d17, 0x30a95f7a5b16b87a, 0x30a95f7a5b16b87a, 0xede240d57fbb7c5e, 0xede240d57fbb7c5e, 0x85317b7da10e984f, -1 }, /* #61 */
    { 0x226f02, 0x226f12, 0x2d056902ed2790b3, 0xba893913bd048247, 0x91e573413e313a38, 0x58ae1f37a58b2ddb, 0xc839f9eceef1da68, 0 }, /* #62 */
    { 0x067906, 0x067906, 0x9afab27c0d90c321, 0x9afab27c0d90c321, 0x69a69c9a80dbf8ba, 0x69a69c9a80dbf8ba, 0x438ada49397357d2, -1 }, /* #63 */
    { 0x007052, 0x007012, 0xf8384ce414a951c8, 0xa682542537777da6, 0x9cd943583c692c44, 0x143027760bab2bb6, 0xf125c6c83bd45533, 0 }, /* #64 */
    { 0x1d0d87, 0x1d0d13, 0x48aebafe45406ceb, 0x79286b14822a5a10, 0x3cbf121607769ef9, 0x14426025789ca0cb, 0x805a9064243c8182, 0 }, /* #65 */
    { 0x3d1542, 0x3d1542, 0xdd8803030d9c7fc3, 0xdd8803030d9c7fc3, 0x7821ca8f0c7de9ee, 0x7821ca8f0c7de9ee, 0x4aa0424872798f13, -1 }, /* #66 */
    { 0x1f2b16, 0x1f2b16, 0x483bd6a3c1e3a45d, 0x483bd6a3c1e3a45d, 0xac4d401c10886b8e, 0xac4d401c10886b8e, 0x5ae69d6503ac25d0, -1 }, /* #67 */
    { 0x270082, 0x270082, 0xe71dad1e4126052c, 0xe71dad1e4126052c, 0x2861f282cd50a0a2, 0x2861f282cd50a0a2, 0x036750a49322950c, -1 }, /* #68 */
    { 0x1f6186, 0x1f6186, 0x24ebc039ce7dcc3d, 0x24ebc039ce7dcc3d, 0xb869404e719911f2, 0xb869404e719911f2, 0x1c46c76905fcddd1, -1 }, /* #69 */
    { 0x0d4cd7, 0x0d4cd7, 0x07663cf0ed4db020, 0x07663cf0ed4db020, 0x92a6e7e4c92ab45b, 0x92a6e7e4c92ab45b, 0x455bb1fe4bc2334d, -1 }, /* #70 */
    { 0x023e47, 0x023e47, 0x174ad48e8519a79b, 0x174ad48e8519a79b, 0x735e9c1471c8c294, 0x735e9c1471c8c294, 0x135261a308592038, -1 }, /* #71 */
    { 0x083f13, 0x083f13, 0x64e8a0b1b3e498c0, 0x5d07a11996290990, 0x5c383aa2648dd765, 0xe31138a21fe04220, 0xfdc5464fef9190fa, 0 }, /* #72 */
    { 0x0f2146, 0x0f2146, 0x59d8ffa6b89b4526, 0x59d8ffa6b89b4526, 0x975ea9ed3577f88b, 0x975ea9ed3577f88b, 0x11ce9c6147e61297, -1 }, /* #73 */
    { 0x3c4e16, 0x3c4e16, 0x505b135e66c7eff6, 0x505b135e66c7eff6, 0x5adb49b60b5488b5, 0x5adb49b60b5488b5, 0x38cffc8972c45980, -1 }, /* #74 */
    { 0x0c4456, 0x0c4412, 0x203bfa7ee7317607, 0xd0dcde0615a5fad1, 0xc133ec85c1ba978e, 0x7e90478e4ec957a7, 0xecce4c2237ed1060, 0 }, /* #75 */
    { 0x2803d6, 0x2803d6, 0x948a3bcafe314487, 0x948a3bcafe314487, 0xcda8d2ad7f5b7622, 0xcda8d2ad7f5b7622, 0x8a137dbd869f62dc, -1 }, /* #76 */
    { 0x240856, 0x240856, 0x4e579280d4277dde, 0x4e579280d4277dde, 0xd8effb4cd75339ae, 0xd8effb4cd75339ae, 0xadaa86a9735b475e, -1 }, /* #77 */
    { 0x2e5883, 0x2e5883, 0x4d561db74752ce0e, 0x4d561db74752ce0e, 0xd988851b10b8e038, 0xd988851b10b8e038, 0x7806568751dadd89, -1 }, /* #78 */
    { 0x1a55c7, 0x1a5513, 0x6458320b79ca9a4c, 0x02262b24fc7d68c8, 0x0210f27484c29245, 0xd476a2f0b0dba034, 0xf6201acb669d9ebb, 0 }, /* #79 */
    { 0x3f2107, 0x3f2107, 0x6339d928171bd10d, 0x6339d928171bd10d, 0x9925cc35eae003fc, 0x9925cc35eae003fc, 0x44761031c081b879, -1 }, /* #80 */
    { 0x212416, 0x212412, 0xc1b66eec54c7af10, 0xcfdb32603262330c, 0x9229de5f702c48d4, 0x8aba6ab848a0bab4, 0xb4049d10bac6591d, 0 }, /* #81 */
    { 0x232016, 0x232016, 0x5f2dfd33d6251f5c, 0x5f2dfd33d6251f5c, 0xe264d9e8044a2f43, 0xe264d9e8044a2f43, 0x26c5df170b1e1ffc, -1 }, /* #82 */
    { 0x391397, 0x391313, 0x76b66f7d8f90f8ae, 0xe5a7d3effd1d35b9, 0xa91cc4494351b46e, 0x2724139867ee72a6, 0xbc82ffbca2fbba48, 0 }, /* #83 */
    { 0x234f82, 0x234f12, 0x3c560196fccc1c4c, 0xae29b0273fc42629, 0x44a735fc72823dcc, 0x5814318613ff1b96, 0x64e99aae7dc935c6, 0 }, /* #84 */
    { 0x2a2852, 0x2a2852, 0xec3731541f4504b1, 0xec3731541f4504b1, 0xe32b5ee1db879879, 0xe32b5ee1db879879, 0x00ec9761f46217d0, -1 }, /* #85 */
    { 0x060293, 0x060213, 0x05a718aedca6b8af, 0xf40ec59de2d0ce1f, 0xb8831e539d456b3b, 0xaa94282bf30b5b23, 0xc18a70a2283c18f4, 0 }, /* #86 */
    { 0x283d43, 0x283d43, 0x075a323a60e3bc38, 0x075a323a60e3bc38, 0xb8be010f3297819b, 0xb8be010f3297819b, 0x19883a848237bdb7, -1 }, /* #87 */
    { 0x344112, 0x344112, 0x6621a13b93711905, 0x6621a13b93711905, 0x88f149f3a9e05cdf, 0x88f149f3a9e05cdf, 0x60a1e9ffd92e15ee, -1 }, /* #88 */
    { 0x0915c3, 0x091513, 0xe0c3c6a03f510781, 0x5116e46dc6a09f88, 0x49c8a95355256401, 0x705101b2429992b9, 0xe8efaa49d4e48d29, 0 }, /* #89 */
    { 0x145453, 0x145453, 0x130b6203a309b7f1, 0x130b6203a309b7f1, 0xa2ef3ee0104fbcb9, 0xa2ef3ee0104fbcb9, 0x6b5150cfc908f60b, -1 }, /* #90 */
    { 0x105c42, 0x105c12, 0xdeecb8d2b698a2de, 0x483e80f7e0ee7f2c, 0x2ac20847075a13ae, 0x35ccfecf8017d30a, 0x9783b1f6a8ad833f, 0 }, /* #91 */
    { 0x181983, 0x181913, 0xe1a9a975e00815d6, 0x307ca470399815f0, 0x1d58957b09b45197, 0x4beff72c5e508e76, 0x9af0c717a2bdcd4a, 0 }, /* #92 */
    { 0x1e6587, 0x1e6587, 0xd2044adb52f6eff7, 0xd2044adb52f6eff7, 0xb470c6ff17ce791a, 0xb470c6ff17ce791a, 0x7b50f9a19818aa3e, -1 }, /* #93 */
    { 0x345753, 0x345713, 0xae449e90b42ce076, 0x4f1719aa0245a354, 0x4e9903916cfbe969, 0x5fd6bad4c7258faa, 0xfe67e1f65fb94ce7, 0 }, /* #94 */
    { 0x237d56, 0x237d56, 0x27e147c994d6e33f, 0x27e147c994d6e33f, 0xec9d0633372ff193, 0xec9d0633372ff193, 0x37baafda39021526, -1 }, /* #95 */
};
uint32_t const g_cTests_div_u64_amd = RT_ELEMENTS(g_aTests_div_u64_amd);

MULDIVU64_TEST_T const g_aTests_idiv_u64_amd[] =
{
    { 0x2f4e97, 0x2f4e97, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #0 */
    { 0x122957, 0x122957, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #1 */
    { 0x335a43, 0x335a43, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #2 */
    { 0x2b02d2, 0x2b02d2, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #3 */
    { 0x2c4607, 0x2c4607, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #4 */
    { 0x333f16, 0x333f16, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, -1 }, /* #5 */
    { 0x324fc2, 0x324fc2, 0x1b7747469567f2d4, 0x1b7747469567f2d4, 0xa1fbf358b3e87393, 0xa1fbf358b3e87393, 0x0000000000000000, -1 }, /* #6 */
    { 0x2527d6, 0x2527d6, 0x23a62034835a6524, 0x23a62034835a6524, 0xa2d887222f8c4834, 0xa2d887222f8c4834, 0x0000000000000000, -1 }, /* #7 */
    { 0x0f7bc2, 0x0f7bc2, 0xe853a037bfe16b6c, 0xe853a037bfe16b6c, 0x14ad2f3954b959a8, 0x14ad2f3954b959a8, 0x0000000000000000, -1 }, /* #8 */
    { 0x3751c3, 0x3751c3, 0x13e5e241001a9fa0, 0x13e5e241001a9fa0, 0x45a0c2f99969239b, 0x45a0c2f99969239b, 0x0000000000000000, -1 }, /* #9 */
    { 0x206c53, 0x206c53, 0xcc8436bc45677a25, 0xcc8436bc45677a25, 0x3fab98a27c25770f, 0x3fab98a27c25770f, 0x0000000000000000, -1 }, /* #10 */
    { 0x315456, 0x315456, 0x0eeb491a50eb67cb, 0x0eeb491a50eb67cb, 0xb7c624d2202d3452, 0xb7c624d2202d3452, 0x0000000000000000, -1 }, /* #11 */
    { 0x1b7393, 0x1b7313, 0x63f4f23914c25b40, 0x3cada0a15c01c6e4, 0xe8d9be03a64a8ea0, 0xd1e4f8ee4d161bd0, 0x9e5542e52f49ecbc, 0 }, /* #12 */
    { 0x1a57d3, 0x1a57d3, 0x87d609241ed74875, 0x87d609241ed74875, 0xcc1bbef434f23f54, 0xcc1bbef434f23f54, 0x3162fc0fb1958b61, -1 }, /* #13 */
    { 0x1276d3, 0x127613, 0xc2a7ae641ebed554, 0x95a2d69e751d179f, 0x0dba58f9ceaa496c, 0x07602b9287e64581, 0xdef58edf85276b4d, 0 }, /* #14 */
    { 0x370307, 0x370313, 0xc34d5d7cb271a60f, 0xbceb5c11dc6f90f0, 0x091a4c494c347995, 0x16b547ea9fb5d0af, 0xdd42e06a9d86514a, 0 }, /* #15 */
    { 0x2d3a92, 0x2d3a12, 0xc9360082eeb56db6, 0x7b4730349a8dfed7, 0xfe413671785b7c5a, 0xfee1333fc876a123, 0xfc6032e0eb5d54a5, 0 }, /* #16 */
    { 0x2c4fc3, 0x2c4f13, 0xcbd43f8579b2d556, 0x2d8e04d08038b43b, 0xec5b5fea1b965ba7, 0xbb8362959a78f333, 0x919d15f122f63339, 0 }, /* #17 */
    { 0x0b0a17, 0x0b0a17, 0xe645fd48957b9c1c, 0xe645fd48957b9c1c, 0xaae9ac8cbcf7b66c, 0xaae9ac8cbcf7b66c, 0xe22b4d45d33f522a, -1 }, /* #18 */
    { 0x1d7e83, 0x1d7e83, 0x04c35d7da671f9be, 0x04c35d7da671f9be, 0x7ea2d6a6362edccf, 0x7ea2d6a6362edccf, 0xbb59fba9f4ba6d3d, -1 }, /* #19 */
    { 0x195383, 0x195383, 0x259f74b90239e6cc, 0x259f74b90239e6cc, 0x7b92d022c7a851ce, 0x7b92d022c7a851ce, 0x850ad061239ea78f, -1 }, /* #20 */
    { 0x363392, 0x363312, 0x93adfd33bc8f0d3c, 0x6bdf8bf6d5c16453, 0xd5ccb815c3ca4a30, 0xf1e90e75d610f149, 0x9bda2115b34975e1, 0 }, /* #21 */
    { 0x3177d6, 0x317712, 0xc52eb7141f0fc86a, 0x8777fea6a8d2edc6, 0x1b2cef79ca4682ac, 0x2c52ae16c5fa34f0, 0xc647f47c231dfedf, 0 }, /* #22 */
    { 0x037c16, 0x037c16, 0x74a487d3179cc27c, 0x74a487d3179cc27c, 0x9f637566ddd16978, 0x9f637566ddd16978, 0xe50ab5e7bab0ac76, -1 }, /* #23 */
    { 0x2c0486, 0x2c0486, 0xccc56afe98b007a3, 0xccc56afe98b007a3, 0xecce937774f37112, 0xecce937774f37112, 0xf74099762e33809c, -1 }, /* #24 */
    { 0x1b2e52, 0x1b2e12, 0x59f71916d67dc0b6, 0x4dfdd422767fb993, 0x11870f64ed90217e, 0x28cfda311a1119fb, 0x39885cf0ba037739, 0 }, /* #25 */
    { 0x0d2e12, 0x0d2e12, 0x7e10dbc9469f3407, 0x7e10dbc9469f3407, 0x9a458beec4cda9c8, 0x9a458beec4cda9c8, 0x4a4f3705e2006e63, -1 }, /* #26 */
    { 0x254f42, 0x254f12, 0xa2d60a1a7efe333d, 0x4e7a15c855536c5e, 0xe01a75a0123142d4, 0xa66c779b1c94d4d1, 0x97f322d1e9208caa, 0 }, /* #27 */
    { 0x327453, 0x327453, 0xee587da5d80eb819, 0xee587da5d80eb819, 0x543768cb73a1143b, 0x543768cb73a1143b, 0xe61f9f9c81c1129f, -1 }, /* #28 */
    { 0x276f07, 0x276f07, 0xf5b95e0f07c579b5, 0xf5b95e0f07c579b5, 0x2a6c08879cce4657, 0x2a6c08879cce4657, 0xc0111e4f1aa3ecd3, -1 }, /* #29 */
    { 0x1c5493, 0x1c5493, 0x5965b4427707aecf, 0x5965b4427707aecf, 0x4e83fbde641d86e8, 0x4e83fbde641d86e8, 0x7ecd32d17b0cb343, -1 }, /* #30 */
    { 0x141087, 0x141087, 0xedf977872d4b59df, 0xedf977872d4b59df, 0x363f5abf15167879, 0x363f5abf15167879, 0xc76b8786f95eee3f, -1 }, /* #31 */
    { 0x0e7212, 0x0e7212, 0x2f9933fb43eccd48, 0x376c68b0abcfa3d0, 0xef159dd8b323bc26, 0xc2f724c7a68d57e8, 0xb1de09e5342de80e, 0 }, /* #32 */
    { 0x1b32d6, 0x1b3212, 0x0eac80c50c3d5552, 0x3f15da7855edd2b2, 0x1c2dfab61f3a0d09, 0x44e04c0d09b73ea0, 0x725a47fe4ea6f201, 0 }, /* #33 */
    { 0x2c0e87, 0x2c0e87, 0x7383a55e3040e13d, 0x7383a55e3040e13d, 0xb5c0a5fa07ddd8be, 0xb5c0a5fa07ddd8be, 0xae700d673ad0fc7b, -1 }, /* #34 */
    { 0x001dd7, 0x001dd7, 0x217d01eacd26cbd5, 0x217d01eacd26cbd5, 0x5f8c9b6a9608dba6, 0x5f8c9b6a9608dba6, 0x65c1d14ac82f7d28, -1 }, /* #35 */
    { 0x130557, 0x130557, 0x22b18134161f53b8, 0x22b18134161f53b8, 0xa668aad833998eb7, 0xa668aad833998eb7, 0x34db236021a85e9b, -1 }, /* #36 */
    { 0x2f0e96, 0x2f0e96, 0xfb15af944183e882, 0xfb15af944183e882, 0x4726275a9f1a8935, 0x4726275a9f1a8935, 0x6e6d493259e1aa34, -1 }, /* #37 */
    { 0x200946, 0x200946, 0xbda33937cd5e994f, 0xbda33937cd5e994f, 0x562000ac27018a51, 0x562000ac27018a51, 0x66f8a1b2cf0c278d, -1 }, /* #38 */
    { 0x3f61c6, 0x3f6112, 0x7970e3ab9d09f7e1, 0x2712136224df8a15, 0x04a7ce1762732dd6, 0x060838386526f5ad, 0x1e80fe1be4cb4a64, 0 }, /* #39 */
    { 0x2a2e42, 0x2a2e42, 0x626b0d13cf9682e3, 0x626b0d13cf9682e3, 0x1291b6d1e2278cdf, 0x1291b6d1e2278cdf, 0x23bfbfc5dc795cdd, -1 }, /* #40 */
    { 0x075186, 0x075186, 0xe393dca8c4c314f1, 0xe393dca8c4c314f1, 0x774ed153807babd7, 0x774ed153807babd7, 0xb2ee8425e7b36603, -1 }, /* #41 */
    { 0x253342, 0x253342, 0xa9e5d8408a1bd792, 0xa9e5d8408a1bd792, 0x97cd0c51f0d88810, 0x97cd0c51f0d88810, 0x3baa699156e3a60c, -1 }, /* #42 */
    { 0x384d13, 0x384d13, 0xd61d554b1e676515, 0xd61d554b1e676515, 0xb68af77ddfcaba44, 0xb68af77ddfcaba44, 0x3e0119545d7e6c58, -1 }, /* #43 */
    { 0x261a46, 0x261a46, 0x46348aed1b90e71a, 0x46348aed1b90e71a, 0xb1df6f2ea38cd0c9, 0xb1df6f2ea38cd0c9, 0xa98b7cb803fc4e96, -1 }, /* #44 */
    { 0x294a02, 0x294a02, 0xe6506975c6442e9d, 0xe6506975c6442e9d, 0xc66ff668693b93f9, 0xc66ff668693b93f9, 0x716e6a54a09a49f8, -1 }, /* #45 */
    { 0x012993, 0x012993, 0x552954cb3d6e4f8f, 0x552954cb3d6e4f8f, 0x5d99668c0c7de647, 0x5d99668c0c7de647, 0xa3fd162e421ba156, -1 }, /* #46 */
    { 0x3b5942, 0x3b5912, 0x32de007cefe3493f, 0x69865c810aef1eb2, 0x1d736f600cf1e6fb, 0x37f9ebc5280e0483, 0x47726f520595378e, 0 }, /* #47 */
    { 0x2a1503, 0x2a1503, 0xbfbd0480bc65ce15, 0xbfbd0480bc65ce15, 0x27c3a7e59272b104, 0x27c3a7e59272b104, 0x3a4f10765e43e09b, -1 }, /* #48 */
    { 0x0150c2, 0x015012, 0xbc7d3425b878b42d, 0x0e99c7e3de9fd504, 0xfe915c873fea8829, 0xfa33573be5f95f8d, 0xe6e3947ef951c328, 0 }, /* #49 */
    { 0x297006, 0x297006, 0xe73865777254df92, 0xe73865777254df92, 0x39b72c0e678d7bbe, 0x39b72c0e678d7bbe, 0x992240f928ad898f, -1 }, /* #50 */
    { 0x174906, 0x174912, 0x2708f72217d70ad8, 0x263eaa0316d87150, 0x02fccedd7d98ed33, 0x13a02e8fa31acfe8, 0x13ff69f2637110b3, 0 }, /* #51 */
    { 0x0439d3, 0x043913, 0x8a257e2f2ccc13c3, 0xb7abb34fe34a16d8, 0xe5d337c8b8821b5f, 0xd7f70cfb79fbf473, 0x5ca488cd8df33ede, 0 }, /* #52 */
    { 0x115943, 0x115943, 0x939132482d05bc5b, 0x939132482d05bc5b, 0xdbd78bd3a17c1f01, 0xdbd78bd3a17c1f01, 0xea0f17c5e41cf8c0, -1 }, /* #53 */
    { 0x213cc3, 0x213cc3, 0x38ba049d40396780, 0x38ba049d40396780, 0xe7df4f17bc84fc83, 0xe7df4f17bc84fc83, 0xfc086db6f5c1a447, -1 }, /* #54 */
    { 0x1b0752, 0x1b0712, 0xd7ad9519533f2941, 0x892199b5475b49ee, 0x1c9f77c10517c947, 0x331bb8fbb7a25dbb, 0xc25b4d73e96f2e95, 0 }, /* #55 */
    { 0x395b07, 0x395b07, 0xc6c69cb55e5c7025, 0xc6c69cb55e5c7025, 0x3917d0a0d95a5360, 0x3917d0a0d95a5360, 0xe33af7aa9a5d4c47, -1 }, /* #56 */
    { 0x194bd7, 0x194bd7, 0xe086eeba335e00ce, 0xe086eeba335e00ce, 0xed4b4cfbbaa326d8, 0xed4b4cfbbaa326d8, 0x031b8eaaeaab09f8, -1 }, /* #57 */
    { 0x335d53, 0x335d53, 0x54711d1e163394d8, 0x54711d1e163394d8, 0x6144ace04e2ec7e1, 0x6144ace04e2ec7e1, 0xf4fc1f10a3b1d803, -1 }, /* #58 */
    { 0x1b0f52, 0x1b0f12, 0x1b6a0a4a07262d54, 0x3c85da079387a3b1, 0x129f96dc0ec98e55, 0x12ca7871c107af93, 0x4ec5fb5beb694f11, 0 }, /* #59 */
    { 0x391ad2, 0x391ad2, 0xa3e9e3a7d357b7e4, 0xa3e9e3a7d357b7e4, 0x17819bb650611c30, 0x17819bb650611c30, 0x13f17ac8be15f69b, -1 }, /* #60 */
    { 0x201403, 0x201403, 0x1d47abe42a950436, 0x1d47abe42a950436, 0x4a478de8cc663594, 0x4a478de8cc663594, 0x04cd4d825fb57f9d, -1 }, /* #61 */
    { 0x1b1446, 0x1b1446, 0xada8e954b4231e85, 0xada8e954b4231e85, 0x531a38ab6c6ea137, 0x531a38ab6c6ea137, 0xbdfb56b25e7e6c59, -1 }, /* #62 */
    { 0x390093, 0x390093, 0x0ceea5de00bb5d5d, 0x0ceea5de00bb5d5d, 0x4ff1092447cbb947, 0x4ff1092447cbb947, 0x842c925bd98f22a9, -1 }, /* #63 */
    { 0x3c1683, 0x3c1683, 0xfe519e438fbcf467, 0xfe519e438fbcf467, 0x2ce5ac02e06d60ab, 0x2ce5ac02e06d60ab, 0xbcc33c0a5a7fce55, -1 }, /* #64 */
    { 0x1a5392, 0x1a5392, 0xf1c8bab187bfe34e, 0xf1c8bab187bfe34e, 0x473161f47158f4d3, 0x473161f47158f4d3, 0x6103d24a7b15feaf, -1 }, /* #65 */
    { 0x232a02, 0x232a12, 0x29bb0cea68dc9503, 0x50d4060c6d69047c, 0x1b1d65d8b74cec0d, 0x24a6b31498afc443, 0x55e0deb5e70955d0, 0 }, /* #66 */
    { 0x3d6917, 0x3d6913, 0x758545eb11c081bb, 0x79f30bdde153e16c, 0x2c5fe9733dca4c6e, 0x494198dc5d6742c7, 0x5d27153a8cd793c7, 0 }, /* #67 */
    { 0x224297, 0x224213, 0xeb3cf1c03756ea7d, 0x7d38b544c72b5d04, 0x27c02f3dae23ab40, 0x028ad6928d1e8179, 0x5143f56aba5d8301, 0 }, /* #68 */
    { 0x250b03, 0x250b03, 0x074ffd632f757108, 0x074ffd632f757108, 0x3857c93194847255, 0x3857c93194847255, 0xf498c6fdcb59ccdd, -1 }, /* #69 */
    { 0x302707, 0x302713, 0x81cbb7268f51c6b1, 0x28ca2a61c31a88aa, 0x12467f14656520b5, 0x4187e41da9683cdb, 0x72b2ad75d241243f, 0 }, /* #70 */
    { 0x1a1707, 0x1a1707, 0x7b4d3c9b94661a5e, 0x7b4d3c9b94661a5e, 0xbd3b31660bc6235b, 0xbd3b31660bc6235b, 0x1ae7803f89a79bd4, -1 }, /* #71 */
    { 0x145693, 0x145693, 0xea1f1b51f79d163d, 0xea1f1b51f79d163d, 0x9eb97412e03a7871, 0x9eb97412e03a7871, 0x1bf8f3a821735980, -1 }, /* #72 */
    { 0x0428d2, 0x042812, 0xbbf643d86eaf60b5, 0x0c33bc3d86f8c0c4, 0xfca7f22824e038a9, 0xd6fcf4e5d52c9b59, 0xb9d7f9f7760b6007, 0 }, /* #73 */
    { 0x1c0597, 0x1c0597, 0x0fa6a929177533f7, 0x0fa6a929177533f7, 0x788d909506abcac6, 0x788d909506abcac6, 0xcc705488560f6408, -1 }, /* #74 */
    { 0x3d53c6, 0x3d53c6, 0xaafcf67f5ca45d99, 0xaafcf67f5ca45d99, 0x9439828f459b42b9, 0x9439828f459b42b9, 0x67eb58670baa84a8, -1 }, /* #75 */
    { 0x2f49d7, 0x2f4913, 0x7de36f8a65adedfc, 0x5d399b32d5158ab2, 0xf84c65115eb00d97, 0xf2ac548a77324588, 0xead9e2c11f7f7cca, 0 }, /* #76 */
    { 0x3602c3, 0x360213, 0xcf62c9091777260b, 0x84a9ff62e70c0ca0, 0xc5828250de7c9696, 0xb2d4e0e3c1ff784b, 0x796773cd7b3975d6, 0 }, /* #77 */
    { 0x2355d7, 0x2355d7, 0x8e0633ee6dc5b177, 0x8e0633ee6dc5b177, 0xaed22bd8b93b7646, 0xaed22bd8b93b7646, 0x9e82d8c3a83c89eb, -1 }, /* #78 */
    { 0x251a86, 0x251a86, 0xe15b828f4dbac6f3, 0xe15b828f4dbac6f3, 0xc312b0c4bed8ac38, 0xc312b0c4bed8ac38, 0xe4e44b46c013156f, -1 }, /* #79 */
    { 0x097396, 0x097312, 0xe66541ebc55700f9, 0x674b317b9680922f, 0xee2c54e9c1cadfd2, 0xf51b81ec68681b36, 0xd3d18b57607aa4ad, 0 }, /* #80 */
    { 0x1306c3, 0x1306c3, 0x60682998cf2b3fc7, 0x60682998cf2b3fc7, 0x2d39f7d51682eb9a, 0x2d39f7d51682eb9a, 0xb7b9823d38bdd825, -1 }, /* #81 */
    { 0x150f57, 0x150f13, 0xc37679dbb377e183, 0x1078b61f16c3d148, 0x0777421667aaf012, 0x410351f24b98983b, 0x7408b7436693d701, 0 }, /* #82 */
    { 0x374b12, 0x374b12, 0x2f166664e6fefefc, 0x2f166664e6fefefc, 0x4512a812279c4762, 0x4512a812279c4762, 0x68c63cf3cbd8592b, -1 }, /* #83 */
    { 0x0b2b42, 0x0b2b12, 0x81dcf499fd58920e, 0xe82da677a63f1edf, 0x0369858d513e69c3, 0x0b141df4ce44405c, 0xdb54afe404bf0e8e, 0 }, /* #84 */
    { 0x275096, 0x275012, 0x51f4da977f2eaf44, 0x642da07283a2be1a, 0xd609c494623b198a, 0xc08559c421c29fb2, 0x94c4cfd91b48fcad, 0 }, /* #85 */
    { 0x295b03, 0x295b03, 0x0aa63aad7eeb4f58, 0x0aa63aad7eeb4f58, 0x9638267ce7565a24, 0x9638267ce7565a24, 0xd33dc4ae9a93a51f, -1 }, /* #86 */
    { 0x3b0542, 0x3b0542, 0x766c8f4ba7b18084, 0x766c8f4ba7b18084, 0x94848c131133a0d7, 0x94848c131133a0d7, 0xeb8431ea4a085ebe, -1 }, /* #87 */
    { 0x2930c3, 0x293013, 0x341af4f9d2827a0d, 0xeb5d4e45d0c9ec37, 0x07e19c1815c92228, 0x230c3c041a52e2cf, 0x9e39f49bacceefb2, 0 }, /* #88 */
    { 0x2a1c53, 0x2a1c53, 0x517828f1cbf156c7, 0x517828f1cbf156c7, 0x372766eee7c7ef2c, 0x372766eee7c7ef2c, 0x540a2baabbd6d05f, -1 }, /* #89 */
    { 0x383007, 0x383007, 0x979f9d73ce366eba, 0x979f9d73ce366eba, 0x8097e226f01a15f6, 0x8097e226f01a15f6, 0x64107c3e33802d17, -1 }, /* #90 */
    { 0x280b83, 0x280b83, 0x82424b4a0160ec6e, 0x82424b4a0160ec6e, 0xbe0ad36bce5d0942, 0xbe0ad36bce5d0942, 0xd81d944cf8be5672, -1 }, /* #91 */
    { 0x3315d2, 0x331512, 0x65428e7fa225e2a4, 0xf5104a1fba336c28, 0x036cb746b49967c8, 0x1bb1c15916323dec, 0xafd5b724d674566b, 0 }, /* #92 */
    { 0x2a55d2, 0x2a55d2, 0xb564c1bae2713170, 0xb564c1bae2713170, 0x7040795b29eab5b8, 0x7040795b29eab5b8, 0xb09badd998df5e1c, -1 }, /* #93 */
    { 0x321a57, 0x321a13, 0x979dab8ab1bca3ac, 0xf6ebc2d0c9cbdb5e, 0xfcc2fcd5f068fd22, 0xc955189d061f618c, 0x5b4f7591256543f0, 0 }, /* #94 */
    { 0x2f3146, 0x2f3112, 0x97f23e19d9a94917, 0xc8a4baf15c6e5696, 0xf19598cbe0cb086a, 0xdb56dc68eeca56c5, 0x42aa8525546250db, 0 }, /* #95 */
};
uint32_t const g_cTests_idiv_u64_amd = RT_ELEMENTS(g_aTests_idiv_u64_amd);


/* end of file */
