#ifndef AVIFILE_CONFIG_H
#define AVIFILE_CONFIG_H

#include "avm_stl.h"

AVM_BEGIN_NAMESPACE;

/**********
 * WARNING - this file is meant to be used by internal avifile application
 * DO NOT USE in your own project!
 * the API here could change in any minute
 */

struct ConfigEntry
{
    enum Types
    {
	Int,
	Float,
	Binary
    } type;
    avm::string appname;
    avm::string valname;
    avm::string value;
    union
    {
	int i;
	float f;
    };

    ConfigEntry(const char* _appname = 0, const char* _valname = 0, int _i = 0)
	: type(Int), appname(_appname), valname(_valname), i(_i) {}
    ConfigEntry(const char* _appname, const char* _valname, float _f)
	: type(Float), appname(_appname), valname(_valname), f(_f) {}
    ConfigEntry(const char* _appname, const char* _valname, const char* _v)
	: type(Binary), appname(_appname), valname(_valname), value(_v) {}
    ~ConfigEntry();
    ConfigEntry(const ConfigEntry& e) { operator=(e); }
    ConfigEntry& operator= (const ConfigEntry& e);

    ConfigEntry& SetFloat(float _f) { value.erase(); f = _f; type = Float; return *this; }
    ConfigEntry& SetInt(int _i) { value.erase(); i = _i; type = Int; return *this; }
    ConfigEntry& SetString(const char* _value) { value = _value; type = Binary; return *this; }
};

struct ConfigFile
{
    avm::string filename;
    avm::vector<ConfigEntry> entries;
    bool dirty;
    bool opened;

    ConfigFile(const char* fn);
    ~ConfigFile();
    void Close();
    void Save(); 
    void Open(const char* fn);
    ConfigEntry* Find(const char* appname, const char* valname);
    void push_back(const ConfigEntry& e);

    void sort();
};

AVM_END_NAMESPACE;

#endif // AVIFILE_CONFIG_H
