package do4odoc.tacollections;

import java.io.*;

import com.db4o.*;
import com.db4o.config.*;
import com.db4o.query.*;
import com.db4o.ta.*;

public class TACollectionsExample {

	private static String DB4O_FILE_NAME = "tp.db4o";

	private static int PORT = 4444;

	public static void main(String[] args) {
		new File(TACollectionsExample.DB4O_FILE_NAME).delete();
		ObjectContainer objectContainer = openObjectContainer();
		Team team = new Team("Ferrari");
		// Store the team first time to make it persistent
		objectContainer.store(team);
		objectContainer.close();
		
		objectContainer = openObjectContainer();
		Team team1 = queryTeamByName(objectContainer, "Ferrari");
		team1.addPilot(new Pilot("Felipe Massa"));
		team1.addPilot(new Pilot("Kimi Raikkonen"));
		// No need to re-store team - it will be stored automatically
		objectContainer.close();
		
		
		objectContainer = openObjectContainer();
		// check the results
		ObjectSet<Team> objectSet = objectContainer.query(Team.class);
		while (objectSet.hasNext()) {
			System.out.println(objectSet.next());
		}
		objectContainer.close();
	}
	// end main

	private static ObjectContainer openObjectContainer() {
		EmbeddedConfiguration embeddedConfiguration = Db4oEmbedded
				.newConfiguration();
		embeddedConfiguration.common().add(new TransparentPersistenceSupport());
		return Db4oEmbedded.openFile(embeddedConfiguration, DB4O_FILE_NAME);
	}
	// end openObjectContainer

	private static Team queryTeamByName(ObjectContainer objectContainer,
			final String name) {
		ObjectSet<Team> objectSet = objectContainer
				.query(new Predicate<Team>() {
					@Override
					public boolean match(Team team) {
						return team.getName().equals(name);
					}
				});
		return objectSet.next();
	}
	// end queryTeamByName
}
