/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/* vim: set filetype=c tabstop=2 shiftwidth=2 expandtab: */

/*
 * apply.c - interface to C call mechanism
 *
 * Copyright (c) 1993 Giuseppe Attardi
 * Copyright (c) 2001 Juan Jose Garcia Ripoll
 *
 * See file 'LICENSE' for the copyright details.
 *
 */

#include <ecl/ecl.h>

#ifndef ECL_ASM_APPLY
cl_object
APPLY(cl_narg n, cl_objectfn fn, cl_object *x)
{
  switch (n) {
  case 0:  return (*fn)(n);
  case 1:  return (*fn)(n, x[0]);
  case 2:  return (*fn)(n, x[0],x[1]);
  case 3:  return (*fn)(n, x[0],x[1],x[2]);
  case 4:  return (*fn)(n, x[0],x[1],x[2],x[3]);
  case 5:  return (*fn)(n, x[0],x[1],x[2],x[3],x[4]);
  case 6:  return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5]);
  case 7:  return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6]);
  case 8:  return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7]);
  case 9:  return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8]);
  case 10: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9]);
  case 11: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10]);
  case 12: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11]);
  case 13: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12]);
  case 14: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13]);
  case 15: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14]);
  case 16: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15]);
  case 17: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16]);
  case 18: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17]);
  case 19: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18]);
  case 20: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19]);
  case 21: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20]);
  case 22: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21]);
  case 23: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22]);
  case 24: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23]);
  case 25: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24]);
  case 26: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25]);
  case 27: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26]);
  case 28: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27]);
  case 29: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28]);
  case 30: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29]);
  case 31: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30]);
  case 32: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31]);
  case 33: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32]);
  case 34: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33]);
  case 35: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34]);
  case 36: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35]);
  case 37: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36]);
  case 38: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37]);
  case 39: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38]);
  case 40: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39]);
  case 41: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40]);
  case 42: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41]);
  case 43: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42]);
  case 44: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43]);
  case 45: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44]);
  case 46: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45]);
  case 47: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46]);
  case 48: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47]);
  case 49: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48]);
  case 50: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49]);
  case 51: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50]);
  case 52: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51]);
  case 53: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52]);
  case 54: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53]);
  case 55: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54]);
  case 56: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55]);
  case 57: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56]);
  case 58: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57]);
  case 59: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58]);
  case 60: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59]);
  case 61: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60]);
  case 62: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60],x[61]);
  case 63: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60],x[61],x[62]);
  default: return (*fn)(n, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60],x[61],x[62],x[63]);
    /* Arguments above 64 have been pushed on the stack */
  } 
}

cl_object
APPLY_fixed(cl_narg n, cl_object (*fn)(), cl_object *x)
{
  switch (n) {
  case 0:  return (*fn)();
  case 1:  return (*fn)(x[0]);
  case 2:  return (*fn)(x[0],x[1]);
  case 3:  return (*fn)(x[0],x[1],x[2]);
  case 4:  return (*fn)(x[0],x[1],x[2],x[3]);
  case 5:  return (*fn)(x[0],x[1],x[2],x[3],x[4]);
  case 6:  return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5]);
  case 7:  return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6]);
  case 8:  return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7]);
  case 9:  return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8]);
  case 10: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9]);
  case 11: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10]);
  case 12: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11]);
  case 13: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12]);
  case 14: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13]);
  case 15: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14]);
  case 16: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15]);
  case 17: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16]);
  case 18: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17]);
  case 19: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18]);
  case 20: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19]);
  case 21: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20]);
  case 22: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21]);
  case 23: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22]);
  case 24: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23]);
  case 25: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24]);
  case 26: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25]);
  case 27: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26]);
  case 28: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27]);
  case 29: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28]);
  case 30: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29]);
  case 31: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30]);
  case 32: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31]);
  case 33: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32]);
  case 34: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33]);
  case 35: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34]);
  case 36: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35]);
  case 37: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36]);
  case 38: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37]);
  case 39: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38]);
  case 40: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39]);
  case 41: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40]);
  case 42: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41]);
  case 43: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42]);
  case 44: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43]);
  case 45: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44]);
  case 46: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45]);
  case 47: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46]);
  case 48: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47]);
  case 49: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48]);
  case 50: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49]);
  case 51: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50]);
  case 52: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51]);
  case 53: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52]);
  case 54: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53]);
  case 55: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54]);
  case 56: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55]);
  case 57: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56]);
  case 58: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57]);
  case 59: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58]);
  case 60: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59]);
  case 61: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60]);
  case 62: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60],x[61]);
  case 63: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60],x[61],x[62]);
  case 64: return (*fn)(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
                        x[8],x[9],x[10],x[11],x[12],x[13],x[14],
                        x[15],x[16],x[17],x[18],x[19],x[20],x[21],
                        x[22],x[23],x[24],x[25],x[26],x[27],x[28],
                        x[29],x[30],x[31],x[32],x[33],x[34],x[35],
                        x[36],x[37],x[38],x[39],x[40],x[41],x[42],
                        x[43],x[44],x[45],x[46],x[47],x[48],x[49],
                        x[50],x[51],x[52],x[53],x[54],x[55],x[56],
                        x[57],x[58],x[59],x[60],x[61],x[62],x[63]);
  default:
    FEprogram_error_noreturn("Too many arguments", 0);
  }
}
#endif
